// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Inspector
///
/// Client for invoking operations on Amazon Inspector. Each operation on Amazon Inspector is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_inspector::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_inspector::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_inspector::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AddAttributesToFindings`](crate::client::fluent_builders::AddAttributesToFindings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`finding_arns(Vec<String>)`](crate::client::fluent_builders::AddAttributesToFindings::finding_arns) / [`set_finding_arns(Option<Vec<String>>)`](crate::client::fluent_builders::AddAttributesToFindings::set_finding_arns): <p>The ARNs that specify the findings that you want to assign attributes to.</p>
    ///   - [`attributes(Vec<Attribute>)`](crate::client::fluent_builders::AddAttributesToFindings::attributes) / [`set_attributes(Option<Vec<Attribute>>)`](crate::client::fluent_builders::AddAttributesToFindings::set_attributes): <p>The array of attributes that you want to assign to specified findings.</p>
    /// - On success, responds with [`AddAttributesToFindingsOutput`](crate::output::AddAttributesToFindingsOutput) with field(s):
    ///   - [`failed_items(Option<HashMap<String, FailedItemDetails>>)`](crate::output::AddAttributesToFindingsOutput::failed_items): <p>Attribute details that cannot be described. An error code is provided for each failed item.</p>
    /// - On failure, responds with [`SdkError<AddAttributesToFindingsError>`](crate::error::AddAttributesToFindingsError)
    pub fn add_attributes_to_findings(&self) -> fluent_builders::AddAttributesToFindings {
        fluent_builders::AddAttributesToFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAssessmentTarget`](crate::client::fluent_builders::CreateAssessmentTarget) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_target_name(impl Into<String>)`](crate::client::fluent_builders::CreateAssessmentTarget::assessment_target_name) / [`set_assessment_target_name(Option<String>)`](crate::client::fluent_builders::CreateAssessmentTarget::set_assessment_target_name): <p>The user-defined name that identifies the assessment target that you want to create. The name must be unique within the AWS account.</p>
    ///   - [`resource_group_arn(impl Into<String>)`](crate::client::fluent_builders::CreateAssessmentTarget::resource_group_arn) / [`set_resource_group_arn(Option<String>)`](crate::client::fluent_builders::CreateAssessmentTarget::set_resource_group_arn): <p>The ARN that specifies the resource group that is used to create the assessment target. If resourceGroupArn is not specified, all EC2 instances in the current AWS account and region are included in the assessment target.</p>
    /// - On success, responds with [`CreateAssessmentTargetOutput`](crate::output::CreateAssessmentTargetOutput) with field(s):
    ///   - [`assessment_target_arn(Option<String>)`](crate::output::CreateAssessmentTargetOutput::assessment_target_arn): <p>The ARN that specifies the assessment target that is created.</p>
    /// - On failure, responds with [`SdkError<CreateAssessmentTargetError>`](crate::error::CreateAssessmentTargetError)
    pub fn create_assessment_target(&self) -> fluent_builders::CreateAssessmentTarget {
        fluent_builders::CreateAssessmentTarget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAssessmentTemplate`](crate::client::fluent_builders::CreateAssessmentTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_target_arn(impl Into<String>)`](crate::client::fluent_builders::CreateAssessmentTemplate::assessment_target_arn) / [`set_assessment_target_arn(Option<String>)`](crate::client::fluent_builders::CreateAssessmentTemplate::set_assessment_target_arn): <p>The ARN that specifies the assessment target for which you want to create the assessment template.</p>
    ///   - [`assessment_template_name(impl Into<String>)`](crate::client::fluent_builders::CreateAssessmentTemplate::assessment_template_name) / [`set_assessment_template_name(Option<String>)`](crate::client::fluent_builders::CreateAssessmentTemplate::set_assessment_template_name): <p>The user-defined name that identifies the assessment template that you want to create. You can create several assessment templates for an assessment target. The names of the assessment templates that correspond to a particular assessment target must be unique.</p>
    ///   - [`duration_in_seconds(i32)`](crate::client::fluent_builders::CreateAssessmentTemplate::duration_in_seconds) / [`set_duration_in_seconds(i32)`](crate::client::fluent_builders::CreateAssessmentTemplate::set_duration_in_seconds): <p>The duration of the assessment run in seconds.</p>
    ///   - [`rules_package_arns(Vec<String>)`](crate::client::fluent_builders::CreateAssessmentTemplate::rules_package_arns) / [`set_rules_package_arns(Option<Vec<String>>)`](crate::client::fluent_builders::CreateAssessmentTemplate::set_rules_package_arns): <p>The ARNs that specify the rules packages that you want to attach to the assessment template.</p>
    ///   - [`user_attributes_for_findings(Vec<Attribute>)`](crate::client::fluent_builders::CreateAssessmentTemplate::user_attributes_for_findings) / [`set_user_attributes_for_findings(Option<Vec<Attribute>>)`](crate::client::fluent_builders::CreateAssessmentTemplate::set_user_attributes_for_findings): <p>The user-defined attributes that are assigned to every finding that is generated by the assessment run that uses this assessment template. An attribute is a key and value pair (an <code>Attribute</code> object). Within an assessment template, each key must be unique.</p>
    /// - On success, responds with [`CreateAssessmentTemplateOutput`](crate::output::CreateAssessmentTemplateOutput) with field(s):
    ///   - [`assessment_template_arn(Option<String>)`](crate::output::CreateAssessmentTemplateOutput::assessment_template_arn): <p>The ARN that specifies the assessment template that is created.</p>
    /// - On failure, responds with [`SdkError<CreateAssessmentTemplateError>`](crate::error::CreateAssessmentTemplateError)
    pub fn create_assessment_template(&self) -> fluent_builders::CreateAssessmentTemplate {
        fluent_builders::CreateAssessmentTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateExclusionsPreview`](crate::client::fluent_builders::CreateExclusionsPreview) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_template_arn(impl Into<String>)`](crate::client::fluent_builders::CreateExclusionsPreview::assessment_template_arn) / [`set_assessment_template_arn(Option<String>)`](crate::client::fluent_builders::CreateExclusionsPreview::set_assessment_template_arn): <p>The ARN that specifies the assessment template for which you want to create an exclusions preview.</p>
    /// - On success, responds with [`CreateExclusionsPreviewOutput`](crate::output::CreateExclusionsPreviewOutput) with field(s):
    ///   - [`preview_token(Option<String>)`](crate::output::CreateExclusionsPreviewOutput::preview_token): <p>Specifies the unique identifier of the requested exclusions preview. You can use the unique identifier to retrieve the exclusions preview when running the GetExclusionsPreview API.</p>
    /// - On failure, responds with [`SdkError<CreateExclusionsPreviewError>`](crate::error::CreateExclusionsPreviewError)
    pub fn create_exclusions_preview(&self) -> fluent_builders::CreateExclusionsPreview {
        fluent_builders::CreateExclusionsPreview::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateResourceGroup`](crate::client::fluent_builders::CreateResourceGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_group_tags(Vec<ResourceGroupTag>)`](crate::client::fluent_builders::CreateResourceGroup::resource_group_tags) / [`set_resource_group_tags(Option<Vec<ResourceGroupTag>>)`](crate::client::fluent_builders::CreateResourceGroup::set_resource_group_tags): <p>A collection of keys and an array of possible values, '[{"key":"key1","values":["Value1","Value2"]},{"key":"Key2","values":["Value3"]}]'.</p>  <p>For example,'[{"key":"Name","values":["TestEC2Instance"]}]'.</p>
    /// - On success, responds with [`CreateResourceGroupOutput`](crate::output::CreateResourceGroupOutput) with field(s):
    ///   - [`resource_group_arn(Option<String>)`](crate::output::CreateResourceGroupOutput::resource_group_arn): <p>The ARN that specifies the resource group that is created.</p>
    /// - On failure, responds with [`SdkError<CreateResourceGroupError>`](crate::error::CreateResourceGroupError)
    pub fn create_resource_group(&self) -> fluent_builders::CreateResourceGroup {
        fluent_builders::CreateResourceGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAssessmentRun`](crate::client::fluent_builders::DeleteAssessmentRun) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_run_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteAssessmentRun::assessment_run_arn) / [`set_assessment_run_arn(Option<String>)`](crate::client::fluent_builders::DeleteAssessmentRun::set_assessment_run_arn): <p>The ARN that specifies the assessment run that you want to delete.</p>
    /// - On success, responds with [`DeleteAssessmentRunOutput`](crate::output::DeleteAssessmentRunOutput)

    /// - On failure, responds with [`SdkError<DeleteAssessmentRunError>`](crate::error::DeleteAssessmentRunError)
    pub fn delete_assessment_run(&self) -> fluent_builders::DeleteAssessmentRun {
        fluent_builders::DeleteAssessmentRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAssessmentTarget`](crate::client::fluent_builders::DeleteAssessmentTarget) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_target_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteAssessmentTarget::assessment_target_arn) / [`set_assessment_target_arn(Option<String>)`](crate::client::fluent_builders::DeleteAssessmentTarget::set_assessment_target_arn): <p>The ARN that specifies the assessment target that you want to delete.</p>
    /// - On success, responds with [`DeleteAssessmentTargetOutput`](crate::output::DeleteAssessmentTargetOutput)

    /// - On failure, responds with [`SdkError<DeleteAssessmentTargetError>`](crate::error::DeleteAssessmentTargetError)
    pub fn delete_assessment_target(&self) -> fluent_builders::DeleteAssessmentTarget {
        fluent_builders::DeleteAssessmentTarget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAssessmentTemplate`](crate::client::fluent_builders::DeleteAssessmentTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_template_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteAssessmentTemplate::assessment_template_arn) / [`set_assessment_template_arn(Option<String>)`](crate::client::fluent_builders::DeleteAssessmentTemplate::set_assessment_template_arn): <p>The ARN that specifies the assessment template that you want to delete.</p>
    /// - On success, responds with [`DeleteAssessmentTemplateOutput`](crate::output::DeleteAssessmentTemplateOutput)

    /// - On failure, responds with [`SdkError<DeleteAssessmentTemplateError>`](crate::error::DeleteAssessmentTemplateError)
    pub fn delete_assessment_template(&self) -> fluent_builders::DeleteAssessmentTemplate {
        fluent_builders::DeleteAssessmentTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAssessmentRuns`](crate::client::fluent_builders::DescribeAssessmentRuns) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_run_arns(Vec<String>)`](crate::client::fluent_builders::DescribeAssessmentRuns::assessment_run_arns) / [`set_assessment_run_arns(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeAssessmentRuns::set_assessment_run_arns): <p>The ARN that specifies the assessment run that you want to describe.</p>
    /// - On success, responds with [`DescribeAssessmentRunsOutput`](crate::output::DescribeAssessmentRunsOutput) with field(s):
    ///   - [`assessment_runs(Option<Vec<AssessmentRun>>)`](crate::output::DescribeAssessmentRunsOutput::assessment_runs): <p>Information about the assessment run.</p>
    ///   - [`failed_items(Option<HashMap<String, FailedItemDetails>>)`](crate::output::DescribeAssessmentRunsOutput::failed_items): <p>Assessment run details that cannot be described. An error code is provided for each failed item.</p>
    /// - On failure, responds with [`SdkError<DescribeAssessmentRunsError>`](crate::error::DescribeAssessmentRunsError)
    pub fn describe_assessment_runs(&self) -> fluent_builders::DescribeAssessmentRuns {
        fluent_builders::DescribeAssessmentRuns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAssessmentTargets`](crate::client::fluent_builders::DescribeAssessmentTargets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_target_arns(Vec<String>)`](crate::client::fluent_builders::DescribeAssessmentTargets::assessment_target_arns) / [`set_assessment_target_arns(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeAssessmentTargets::set_assessment_target_arns): <p>The ARNs that specifies the assessment targets that you want to describe.</p>
    /// - On success, responds with [`DescribeAssessmentTargetsOutput`](crate::output::DescribeAssessmentTargetsOutput) with field(s):
    ///   - [`assessment_targets(Option<Vec<AssessmentTarget>>)`](crate::output::DescribeAssessmentTargetsOutput::assessment_targets): <p>Information about the assessment targets.</p>
    ///   - [`failed_items(Option<HashMap<String, FailedItemDetails>>)`](crate::output::DescribeAssessmentTargetsOutput::failed_items): <p>Assessment target details that cannot be described. An error code is provided for each failed item.</p>
    /// - On failure, responds with [`SdkError<DescribeAssessmentTargetsError>`](crate::error::DescribeAssessmentTargetsError)
    pub fn describe_assessment_targets(&self) -> fluent_builders::DescribeAssessmentTargets {
        fluent_builders::DescribeAssessmentTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAssessmentTemplates`](crate::client::fluent_builders::DescribeAssessmentTemplates) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_template_arns(Vec<String>)`](crate::client::fluent_builders::DescribeAssessmentTemplates::assessment_template_arns) / [`set_assessment_template_arns(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeAssessmentTemplates::set_assessment_template_arns): (undocumented)
    /// - On success, responds with [`DescribeAssessmentTemplatesOutput`](crate::output::DescribeAssessmentTemplatesOutput) with field(s):
    ///   - [`assessment_templates(Option<Vec<AssessmentTemplate>>)`](crate::output::DescribeAssessmentTemplatesOutput::assessment_templates): <p>Information about the assessment templates.</p>
    ///   - [`failed_items(Option<HashMap<String, FailedItemDetails>>)`](crate::output::DescribeAssessmentTemplatesOutput::failed_items): <p>Assessment template details that cannot be described. An error code is provided for each failed item.</p>
    /// - On failure, responds with [`SdkError<DescribeAssessmentTemplatesError>`](crate::error::DescribeAssessmentTemplatesError)
    pub fn describe_assessment_templates(&self) -> fluent_builders::DescribeAssessmentTemplates {
        fluent_builders::DescribeAssessmentTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCrossAccountAccessRole`](crate::client::fluent_builders::DescribeCrossAccountAccessRole) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeCrossAccountAccessRole::send) it.

    /// - On success, responds with [`DescribeCrossAccountAccessRoleOutput`](crate::output::DescribeCrossAccountAccessRoleOutput) with field(s):
    ///   - [`role_arn(Option<String>)`](crate::output::DescribeCrossAccountAccessRoleOutput::role_arn): <p>The ARN that specifies the IAM role that Amazon Inspector uses to access your AWS account.</p>
    ///   - [`valid(Option<bool>)`](crate::output::DescribeCrossAccountAccessRoleOutput::valid): <p>A Boolean value that specifies whether the IAM role has the necessary policies attached to enable Amazon Inspector to access your AWS account.</p>
    ///   - [`registered_at(Option<DateTime>)`](crate::output::DescribeCrossAccountAccessRoleOutput::registered_at): <p>The date when the cross-account access role was registered.</p>
    /// - On failure, responds with [`SdkError<DescribeCrossAccountAccessRoleError>`](crate::error::DescribeCrossAccountAccessRoleError)
    pub fn describe_cross_account_access_role(
        &self,
    ) -> fluent_builders::DescribeCrossAccountAccessRole {
        fluent_builders::DescribeCrossAccountAccessRole::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeExclusions`](crate::client::fluent_builders::DescribeExclusions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`exclusion_arns(Vec<String>)`](crate::client::fluent_builders::DescribeExclusions::exclusion_arns) / [`set_exclusion_arns(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeExclusions::set_exclusion_arns): <p>The list of ARNs that specify the exclusions that you want to describe.</p>
    ///   - [`locale(Locale)`](crate::client::fluent_builders::DescribeExclusions::locale) / [`set_locale(Option<Locale>)`](crate::client::fluent_builders::DescribeExclusions::set_locale): <p>The locale into which you want to translate the exclusion's title, description, and recommendation.</p>
    /// - On success, responds with [`DescribeExclusionsOutput`](crate::output::DescribeExclusionsOutput) with field(s):
    ///   - [`exclusions(Option<HashMap<String, Exclusion>>)`](crate::output::DescribeExclusionsOutput::exclusions): <p>Information about the exclusions.</p>
    ///   - [`failed_items(Option<HashMap<String, FailedItemDetails>>)`](crate::output::DescribeExclusionsOutput::failed_items): <p>Exclusion details that cannot be described. An error code is provided for each failed item.</p>
    /// - On failure, responds with [`SdkError<DescribeExclusionsError>`](crate::error::DescribeExclusionsError)
    pub fn describe_exclusions(&self) -> fluent_builders::DescribeExclusions {
        fluent_builders::DescribeExclusions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFindings`](crate::client::fluent_builders::DescribeFindings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`finding_arns(Vec<String>)`](crate::client::fluent_builders::DescribeFindings::finding_arns) / [`set_finding_arns(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeFindings::set_finding_arns): <p>The ARN that specifies the finding that you want to describe.</p>
    ///   - [`locale(Locale)`](crate::client::fluent_builders::DescribeFindings::locale) / [`set_locale(Option<Locale>)`](crate::client::fluent_builders::DescribeFindings::set_locale): <p>The locale into which you want to translate a finding description, recommendation, and the short description that identifies the finding.</p>
    /// - On success, responds with [`DescribeFindingsOutput`](crate::output::DescribeFindingsOutput) with field(s):
    ///   - [`findings(Option<Vec<Finding>>)`](crate::output::DescribeFindingsOutput::findings): <p>Information about the finding.</p>
    ///   - [`failed_items(Option<HashMap<String, FailedItemDetails>>)`](crate::output::DescribeFindingsOutput::failed_items): <p>Finding details that cannot be described. An error code is provided for each failed item.</p>
    /// - On failure, responds with [`SdkError<DescribeFindingsError>`](crate::error::DescribeFindingsError)
    pub fn describe_findings(&self) -> fluent_builders::DescribeFindings {
        fluent_builders::DescribeFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeResourceGroups`](crate::client::fluent_builders::DescribeResourceGroups) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_group_arns(Vec<String>)`](crate::client::fluent_builders::DescribeResourceGroups::resource_group_arns) / [`set_resource_group_arns(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeResourceGroups::set_resource_group_arns): <p>The ARN that specifies the resource group that you want to describe.</p>
    /// - On success, responds with [`DescribeResourceGroupsOutput`](crate::output::DescribeResourceGroupsOutput) with field(s):
    ///   - [`resource_groups(Option<Vec<ResourceGroup>>)`](crate::output::DescribeResourceGroupsOutput::resource_groups): <p>Information about a resource group.</p>
    ///   - [`failed_items(Option<HashMap<String, FailedItemDetails>>)`](crate::output::DescribeResourceGroupsOutput::failed_items): <p>Resource group details that cannot be described. An error code is provided for each failed item.</p>
    /// - On failure, responds with [`SdkError<DescribeResourceGroupsError>`](crate::error::DescribeResourceGroupsError)
    pub fn describe_resource_groups(&self) -> fluent_builders::DescribeResourceGroups {
        fluent_builders::DescribeResourceGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeRulesPackages`](crate::client::fluent_builders::DescribeRulesPackages) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`rules_package_arns(Vec<String>)`](crate::client::fluent_builders::DescribeRulesPackages::rules_package_arns) / [`set_rules_package_arns(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeRulesPackages::set_rules_package_arns): <p>The ARN that specifies the rules package that you want to describe.</p>
    ///   - [`locale(Locale)`](crate::client::fluent_builders::DescribeRulesPackages::locale) / [`set_locale(Option<Locale>)`](crate::client::fluent_builders::DescribeRulesPackages::set_locale): <p>The locale that you want to translate a rules package description into.</p>
    /// - On success, responds with [`DescribeRulesPackagesOutput`](crate::output::DescribeRulesPackagesOutput) with field(s):
    ///   - [`rules_packages(Option<Vec<RulesPackage>>)`](crate::output::DescribeRulesPackagesOutput::rules_packages): <p>Information about the rules package.</p>
    ///   - [`failed_items(Option<HashMap<String, FailedItemDetails>>)`](crate::output::DescribeRulesPackagesOutput::failed_items): <p>Rules package details that cannot be described. An error code is provided for each failed item.</p>
    /// - On failure, responds with [`SdkError<DescribeRulesPackagesError>`](crate::error::DescribeRulesPackagesError)
    pub fn describe_rules_packages(&self) -> fluent_builders::DescribeRulesPackages {
        fluent_builders::DescribeRulesPackages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAssessmentReport`](crate::client::fluent_builders::GetAssessmentReport) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_run_arn(impl Into<String>)`](crate::client::fluent_builders::GetAssessmentReport::assessment_run_arn) / [`set_assessment_run_arn(Option<String>)`](crate::client::fluent_builders::GetAssessmentReport::set_assessment_run_arn): <p>The ARN that specifies the assessment run for which you want to generate a report.</p>
    ///   - [`report_file_format(ReportFileFormat)`](crate::client::fluent_builders::GetAssessmentReport::report_file_format) / [`set_report_file_format(Option<ReportFileFormat>)`](crate::client::fluent_builders::GetAssessmentReport::set_report_file_format): <p>Specifies the file format (html or pdf) of the assessment report that you want to generate.</p>
    ///   - [`report_type(ReportType)`](crate::client::fluent_builders::GetAssessmentReport::report_type) / [`set_report_type(Option<ReportType>)`](crate::client::fluent_builders::GetAssessmentReport::set_report_type): <p>Specifies the type of the assessment report that you want to generate. There are two types of assessment reports: a finding report and a full report. For more information, see <a href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_reports.html">Assessment Reports</a>. </p>
    /// - On success, responds with [`GetAssessmentReportOutput`](crate::output::GetAssessmentReportOutput) with field(s):
    ///   - [`status(Option<ReportStatus>)`](crate::output::GetAssessmentReportOutput::status): <p>Specifies the status of the request to generate an assessment report. </p>
    ///   - [`url(Option<String>)`](crate::output::GetAssessmentReportOutput::url): <p>Specifies the URL where you can find the generated assessment report. This parameter is only returned if the report is successfully generated.</p>
    /// - On failure, responds with [`SdkError<GetAssessmentReportError>`](crate::error::GetAssessmentReportError)
    pub fn get_assessment_report(&self) -> fluent_builders::GetAssessmentReport {
        fluent_builders::GetAssessmentReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetExclusionsPreview`](crate::client::fluent_builders::GetExclusionsPreview) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetExclusionsPreview::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_template_arn(impl Into<String>)`](crate::client::fluent_builders::GetExclusionsPreview::assessment_template_arn) / [`set_assessment_template_arn(Option<String>)`](crate::client::fluent_builders::GetExclusionsPreview::set_assessment_template_arn): <p>The ARN that specifies the assessment template for which the exclusions preview was requested.</p>
    ///   - [`preview_token(impl Into<String>)`](crate::client::fluent_builders::GetExclusionsPreview::preview_token) / [`set_preview_token(Option<String>)`](crate::client::fluent_builders::GetExclusionsPreview::set_preview_token): <p>The unique identifier associated of the exclusions preview.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetExclusionsPreview::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetExclusionsPreview::set_next_token): <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the GetExclusionsPreviewRequest action. Subsequent calls to the action fill nextToken in the request with the value of nextToken from the previous response to continue listing data.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetExclusionsPreview::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetExclusionsPreview::set_max_results): <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 100. The maximum value is 500.</p>
    ///   - [`locale(Locale)`](crate::client::fluent_builders::GetExclusionsPreview::locale) / [`set_locale(Option<Locale>)`](crate::client::fluent_builders::GetExclusionsPreview::set_locale): <p>The locale into which you want to translate the exclusion's title, description, and recommendation.</p>
    /// - On success, responds with [`GetExclusionsPreviewOutput`](crate::output::GetExclusionsPreviewOutput) with field(s):
    ///   - [`preview_status(Option<PreviewStatus>)`](crate::output::GetExclusionsPreviewOutput::preview_status): <p>Specifies the status of the request to generate an exclusions preview.</p>
    ///   - [`exclusion_previews(Option<Vec<ExclusionPreview>>)`](crate::output::GetExclusionsPreviewOutput::exclusion_previews): <p>Information about the exclusions included in the preview.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetExclusionsPreviewOutput::next_token): <p>When a response is generated, if there is more data to be listed, this parameters is present in the response and contains the value to use for the nextToken parameter in a subsequent pagination request. If there is no more data to be listed, this parameter is set to null.</p>
    /// - On failure, responds with [`SdkError<GetExclusionsPreviewError>`](crate::error::GetExclusionsPreviewError)
    pub fn get_exclusions_preview(&self) -> fluent_builders::GetExclusionsPreview {
        fluent_builders::GetExclusionsPreview::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetTelemetryMetadata`](crate::client::fluent_builders::GetTelemetryMetadata) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_run_arn(impl Into<String>)`](crate::client::fluent_builders::GetTelemetryMetadata::assessment_run_arn) / [`set_assessment_run_arn(Option<String>)`](crate::client::fluent_builders::GetTelemetryMetadata::set_assessment_run_arn): <p>The ARN that specifies the assessment run that has the telemetry data that you want to obtain.</p>
    /// - On success, responds with [`GetTelemetryMetadataOutput`](crate::output::GetTelemetryMetadataOutput) with field(s):
    ///   - [`telemetry_metadata(Option<Vec<TelemetryMetadata>>)`](crate::output::GetTelemetryMetadataOutput::telemetry_metadata): <p>Telemetry details.</p>
    /// - On failure, responds with [`SdkError<GetTelemetryMetadataError>`](crate::error::GetTelemetryMetadataError)
    pub fn get_telemetry_metadata(&self) -> fluent_builders::GetTelemetryMetadata {
        fluent_builders::GetTelemetryMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAssessmentRunAgents`](crate::client::fluent_builders::ListAssessmentRunAgents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAssessmentRunAgents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_run_arn(impl Into<String>)`](crate::client::fluent_builders::ListAssessmentRunAgents::assessment_run_arn) / [`set_assessment_run_arn(Option<String>)`](crate::client::fluent_builders::ListAssessmentRunAgents::set_assessment_run_arn): <p>The ARN that specifies the assessment run whose agents you want to list.</p>
    ///   - [`filter(AgentFilter)`](crate::client::fluent_builders::ListAssessmentRunAgents::filter) / [`set_filter(Option<AgentFilter>)`](crate::client::fluent_builders::ListAssessmentRunAgents::set_filter): <p>You can use this parameter to specify a subset of data to be included in the action's response.</p>  <p>For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAssessmentRunAgents::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAssessmentRunAgents::set_next_token): <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>ListAssessmentRunAgents</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAssessmentRunAgents::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAssessmentRunAgents::set_max_results): <p>You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 10. The maximum value is 500.</p>
    /// - On success, responds with [`ListAssessmentRunAgentsOutput`](crate::output::ListAssessmentRunAgentsOutput) with field(s):
    ///   - [`assessment_run_agents(Option<Vec<AssessmentRunAgent>>)`](crate::output::ListAssessmentRunAgentsOutput::assessment_run_agents): <p>A list of ARNs that specifies the agents returned by the action.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAssessmentRunAgentsOutput::next_token): <p> When a response is generated, if there is more data to be listed, this parameter is present in the response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there is no more data to be listed, this parameter is set to null.</p>
    /// - On failure, responds with [`SdkError<ListAssessmentRunAgentsError>`](crate::error::ListAssessmentRunAgentsError)
    pub fn list_assessment_run_agents(&self) -> fluent_builders::ListAssessmentRunAgents {
        fluent_builders::ListAssessmentRunAgents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAssessmentRuns`](crate::client::fluent_builders::ListAssessmentRuns) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAssessmentRuns::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_template_arns(Vec<String>)`](crate::client::fluent_builders::ListAssessmentRuns::assessment_template_arns) / [`set_assessment_template_arns(Option<Vec<String>>)`](crate::client::fluent_builders::ListAssessmentRuns::set_assessment_template_arns): <p>The ARNs that specify the assessment templates whose assessment runs you want to list.</p>
    ///   - [`filter(AssessmentRunFilter)`](crate::client::fluent_builders::ListAssessmentRuns::filter) / [`set_filter(Option<AssessmentRunFilter>)`](crate::client::fluent_builders::ListAssessmentRuns::set_filter): <p>You can use this parameter to specify a subset of data to be included in the action's response.</p>  <p>For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAssessmentRuns::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAssessmentRuns::set_next_token): <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>ListAssessmentRuns</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAssessmentRuns::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAssessmentRuns::set_max_results): <p>You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 10. The maximum value is 500.</p>
    /// - On success, responds with [`ListAssessmentRunsOutput`](crate::output::ListAssessmentRunsOutput) with field(s):
    ///   - [`assessment_run_arns(Option<Vec<String>>)`](crate::output::ListAssessmentRunsOutput::assessment_run_arns): <p>A list of ARNs that specifies the assessment runs that are returned by the action.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAssessmentRunsOutput::next_token): <p> When a response is generated, if there is more data to be listed, this parameter is present in the response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there is no more data to be listed, this parameter is set to null.</p>
    /// - On failure, responds with [`SdkError<ListAssessmentRunsError>`](crate::error::ListAssessmentRunsError)
    pub fn list_assessment_runs(&self) -> fluent_builders::ListAssessmentRuns {
        fluent_builders::ListAssessmentRuns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAssessmentTargets`](crate::client::fluent_builders::ListAssessmentTargets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAssessmentTargets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter(AssessmentTargetFilter)`](crate::client::fluent_builders::ListAssessmentTargets::filter) / [`set_filter(Option<AssessmentTargetFilter>)`](crate::client::fluent_builders::ListAssessmentTargets::set_filter): <p>You can use this parameter to specify a subset of data to be included in the action's response.</p>  <p>For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAssessmentTargets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAssessmentTargets::set_next_token): <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>ListAssessmentTargets</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAssessmentTargets::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAssessmentTargets::set_max_results): <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>
    /// - On success, responds with [`ListAssessmentTargetsOutput`](crate::output::ListAssessmentTargetsOutput) with field(s):
    ///   - [`assessment_target_arns(Option<Vec<String>>)`](crate::output::ListAssessmentTargetsOutput::assessment_target_arns): <p>A list of ARNs that specifies the assessment targets that are returned by the action.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAssessmentTargetsOutput::next_token): <p> When a response is generated, if there is more data to be listed, this parameter is present in the response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there is no more data to be listed, this parameter is set to null.</p>
    /// - On failure, responds with [`SdkError<ListAssessmentTargetsError>`](crate::error::ListAssessmentTargetsError)
    pub fn list_assessment_targets(&self) -> fluent_builders::ListAssessmentTargets {
        fluent_builders::ListAssessmentTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAssessmentTemplates`](crate::client::fluent_builders::ListAssessmentTemplates) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAssessmentTemplates::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_target_arns(Vec<String>)`](crate::client::fluent_builders::ListAssessmentTemplates::assessment_target_arns) / [`set_assessment_target_arns(Option<Vec<String>>)`](crate::client::fluent_builders::ListAssessmentTemplates::set_assessment_target_arns): <p>A list of ARNs that specifies the assessment targets whose assessment templates you want to list.</p>
    ///   - [`filter(AssessmentTemplateFilter)`](crate::client::fluent_builders::ListAssessmentTemplates::filter) / [`set_filter(Option<AssessmentTemplateFilter>)`](crate::client::fluent_builders::ListAssessmentTemplates::set_filter): <p>You can use this parameter to specify a subset of data to be included in the action's response.</p>  <p>For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAssessmentTemplates::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAssessmentTemplates::set_next_token): <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>ListAssessmentTemplates</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAssessmentTemplates::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAssessmentTemplates::set_max_results): <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>
    /// - On success, responds with [`ListAssessmentTemplatesOutput`](crate::output::ListAssessmentTemplatesOutput) with field(s):
    ///   - [`assessment_template_arns(Option<Vec<String>>)`](crate::output::ListAssessmentTemplatesOutput::assessment_template_arns): <p>A list of ARNs that specifies the assessment templates returned by the action.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAssessmentTemplatesOutput::next_token): <p> When a response is generated, if there is more data to be listed, this parameter is present in the response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there is no more data to be listed, this parameter is set to null.</p>
    /// - On failure, responds with [`SdkError<ListAssessmentTemplatesError>`](crate::error::ListAssessmentTemplatesError)
    pub fn list_assessment_templates(&self) -> fluent_builders::ListAssessmentTemplates {
        fluent_builders::ListAssessmentTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEventSubscriptions`](crate::client::fluent_builders::ListEventSubscriptions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListEventSubscriptions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListEventSubscriptions::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListEventSubscriptions::set_resource_arn): <p>The ARN of the assessment template for which you want to list the existing event subscriptions.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListEventSubscriptions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListEventSubscriptions::set_next_token): <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>ListEventSubscriptions</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListEventSubscriptions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListEventSubscriptions::set_max_results): <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>
    /// - On success, responds with [`ListEventSubscriptionsOutput`](crate::output::ListEventSubscriptionsOutput) with field(s):
    ///   - [`subscriptions(Option<Vec<Subscription>>)`](crate::output::ListEventSubscriptionsOutput::subscriptions): <p>Details of the returned event subscriptions.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListEventSubscriptionsOutput::next_token): <p> When a response is generated, if there is more data to be listed, this parameter is present in the response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there is no more data to be listed, this parameter is set to null.</p>
    /// - On failure, responds with [`SdkError<ListEventSubscriptionsError>`](crate::error::ListEventSubscriptionsError)
    pub fn list_event_subscriptions(&self) -> fluent_builders::ListEventSubscriptions {
        fluent_builders::ListEventSubscriptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListExclusions`](crate::client::fluent_builders::ListExclusions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListExclusions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_run_arn(impl Into<String>)`](crate::client::fluent_builders::ListExclusions::assessment_run_arn) / [`set_assessment_run_arn(Option<String>)`](crate::client::fluent_builders::ListExclusions::set_assessment_run_arn): <p>The ARN of the assessment run that generated the exclusions that you want to list.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListExclusions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListExclusions::set_next_token): <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the ListExclusionsRequest action. Subsequent calls to the action fill nextToken in the request with the value of nextToken from the previous response to continue listing data.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListExclusions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListExclusions::set_max_results): <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 100. The maximum value is 500.</p>
    /// - On success, responds with [`ListExclusionsOutput`](crate::output::ListExclusionsOutput) with field(s):
    ///   - [`exclusion_arns(Option<Vec<String>>)`](crate::output::ListExclusionsOutput::exclusion_arns): <p>A list of exclusions' ARNs returned by the action.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListExclusionsOutput::next_token): <p>When a response is generated, if there is more data to be listed, this parameters is present in the response and contains the value to use for the nextToken parameter in a subsequent pagination request. If there is no more data to be listed, this parameter is set to null.</p>
    /// - On failure, responds with [`SdkError<ListExclusionsError>`](crate::error::ListExclusionsError)
    pub fn list_exclusions(&self) -> fluent_builders::ListExclusions {
        fluent_builders::ListExclusions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFindings`](crate::client::fluent_builders::ListFindings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFindings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_run_arns(Vec<String>)`](crate::client::fluent_builders::ListFindings::assessment_run_arns) / [`set_assessment_run_arns(Option<Vec<String>>)`](crate::client::fluent_builders::ListFindings::set_assessment_run_arns): <p>The ARNs of the assessment runs that generate the findings that you want to list.</p>
    ///   - [`filter(FindingFilter)`](crate::client::fluent_builders::ListFindings::filter) / [`set_filter(Option<FindingFilter>)`](crate::client::fluent_builders::ListFindings::set_filter): <p>You can use this parameter to specify a subset of data to be included in the action's response.</p>  <p>For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFindings::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFindings::set_next_token): <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>ListFindings</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFindings::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListFindings::set_max_results): <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>
    /// - On success, responds with [`ListFindingsOutput`](crate::output::ListFindingsOutput) with field(s):
    ///   - [`finding_arns(Option<Vec<String>>)`](crate::output::ListFindingsOutput::finding_arns): <p>A list of ARNs that specifies the findings returned by the action.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListFindingsOutput::next_token): <p> When a response is generated, if there is more data to be listed, this parameter is present in the response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there is no more data to be listed, this parameter is set to null.</p>
    /// - On failure, responds with [`SdkError<ListFindingsError>`](crate::error::ListFindingsError)
    pub fn list_findings(&self) -> fluent_builders::ListFindings {
        fluent_builders::ListFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRulesPackages`](crate::client::fluent_builders::ListRulesPackages) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRulesPackages::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRulesPackages::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRulesPackages::set_next_token): <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>ListRulesPackages</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListRulesPackages::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListRulesPackages::set_max_results): <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>
    /// - On success, responds with [`ListRulesPackagesOutput`](crate::output::ListRulesPackagesOutput) with field(s):
    ///   - [`rules_package_arns(Option<Vec<String>>)`](crate::output::ListRulesPackagesOutput::rules_package_arns): <p>The list of ARNs that specifies the rules packages returned by the action.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListRulesPackagesOutput::next_token): <p> When a response is generated, if there is more data to be listed, this parameter is present in the response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there is no more data to be listed, this parameter is set to null.</p>
    /// - On failure, responds with [`SdkError<ListRulesPackagesError>`](crate::error::ListRulesPackagesError)
    pub fn list_rules_packages(&self) -> fluent_builders::ListRulesPackages {
        fluent_builders::ListRulesPackages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The ARN that specifies the assessment template whose tags you want to list.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>A collection of key and value pairs.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PreviewAgents`](crate::client::fluent_builders::PreviewAgents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::PreviewAgents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`preview_agents_arn(impl Into<String>)`](crate::client::fluent_builders::PreviewAgents::preview_agents_arn) / [`set_preview_agents_arn(Option<String>)`](crate::client::fluent_builders::PreviewAgents::set_preview_agents_arn): <p>The ARN of the assessment target whose agents you want to preview.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::PreviewAgents::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::PreviewAgents::set_next_token): <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>PreviewAgents</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::PreviewAgents::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::PreviewAgents::set_max_results): <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>
    /// - On success, responds with [`PreviewAgentsOutput`](crate::output::PreviewAgentsOutput) with field(s):
    ///   - [`agent_previews(Option<Vec<AgentPreview>>)`](crate::output::PreviewAgentsOutput::agent_previews): <p>The resulting list of agents.</p>
    ///   - [`next_token(Option<String>)`](crate::output::PreviewAgentsOutput::next_token): <p> When a response is generated, if there is more data to be listed, this parameter is present in the response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there is no more data to be listed, this parameter is set to null.</p>
    /// - On failure, responds with [`SdkError<PreviewAgentsError>`](crate::error::PreviewAgentsError)
    pub fn preview_agents(&self) -> fluent_builders::PreviewAgents {
        fluent_builders::PreviewAgents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterCrossAccountAccessRole`](crate::client::fluent_builders::RegisterCrossAccountAccessRole) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::RegisterCrossAccountAccessRole::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::RegisterCrossAccountAccessRole::set_role_arn): <p>The ARN of the IAM role that grants Amazon Inspector access to AWS Services needed to perform security assessments. </p>
    /// - On success, responds with [`RegisterCrossAccountAccessRoleOutput`](crate::output::RegisterCrossAccountAccessRoleOutput)

    /// - On failure, responds with [`SdkError<RegisterCrossAccountAccessRoleError>`](crate::error::RegisterCrossAccountAccessRoleError)
    pub fn register_cross_account_access_role(
        &self,
    ) -> fluent_builders::RegisterCrossAccountAccessRole {
        fluent_builders::RegisterCrossAccountAccessRole::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveAttributesFromFindings`](crate::client::fluent_builders::RemoveAttributesFromFindings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`finding_arns(Vec<String>)`](crate::client::fluent_builders::RemoveAttributesFromFindings::finding_arns) / [`set_finding_arns(Option<Vec<String>>)`](crate::client::fluent_builders::RemoveAttributesFromFindings::set_finding_arns): <p>The ARNs that specify the findings that you want to remove attributes from.</p>
    ///   - [`attribute_keys(Vec<String>)`](crate::client::fluent_builders::RemoveAttributesFromFindings::attribute_keys) / [`set_attribute_keys(Option<Vec<String>>)`](crate::client::fluent_builders::RemoveAttributesFromFindings::set_attribute_keys): <p>The array of attribute keys that you want to remove from specified findings.</p>
    /// - On success, responds with [`RemoveAttributesFromFindingsOutput`](crate::output::RemoveAttributesFromFindingsOutput) with field(s):
    ///   - [`failed_items(Option<HashMap<String, FailedItemDetails>>)`](crate::output::RemoveAttributesFromFindingsOutput::failed_items): <p>Attributes details that cannot be described. An error code is provided for each failed item.</p>
    /// - On failure, responds with [`SdkError<RemoveAttributesFromFindingsError>`](crate::error::RemoveAttributesFromFindingsError)
    pub fn remove_attributes_from_findings(&self) -> fluent_builders::RemoveAttributesFromFindings {
        fluent_builders::RemoveAttributesFromFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SetTagsForResource`](crate::client::fluent_builders::SetTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::SetTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::SetTagsForResource::set_resource_arn): <p>The ARN of the assessment template that you want to set tags to.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::SetTagsForResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::SetTagsForResource::set_tags): <p>A collection of key and value pairs that you want to set to the assessment template.</p>
    /// - On success, responds with [`SetTagsForResourceOutput`](crate::output::SetTagsForResourceOutput)

    /// - On failure, responds with [`SdkError<SetTagsForResourceError>`](crate::error::SetTagsForResourceError)
    pub fn set_tags_for_resource(&self) -> fluent_builders::SetTagsForResource {
        fluent_builders::SetTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartAssessmentRun`](crate::client::fluent_builders::StartAssessmentRun) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_template_arn(impl Into<String>)`](crate::client::fluent_builders::StartAssessmentRun::assessment_template_arn) / [`set_assessment_template_arn(Option<String>)`](crate::client::fluent_builders::StartAssessmentRun::set_assessment_template_arn): <p>The ARN of the assessment template of the assessment run that you want to start.</p>
    ///   - [`assessment_run_name(impl Into<String>)`](crate::client::fluent_builders::StartAssessmentRun::assessment_run_name) / [`set_assessment_run_name(Option<String>)`](crate::client::fluent_builders::StartAssessmentRun::set_assessment_run_name): <p>You can specify the name for the assessment run. The name must be unique for the assessment template whose ARN is used to start the assessment run.</p>
    /// - On success, responds with [`StartAssessmentRunOutput`](crate::output::StartAssessmentRunOutput) with field(s):
    ///   - [`assessment_run_arn(Option<String>)`](crate::output::StartAssessmentRunOutput::assessment_run_arn): <p>The ARN of the assessment run that has been started.</p>
    /// - On failure, responds with [`SdkError<StartAssessmentRunError>`](crate::error::StartAssessmentRunError)
    pub fn start_assessment_run(&self) -> fluent_builders::StartAssessmentRun {
        fluent_builders::StartAssessmentRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopAssessmentRun`](crate::client::fluent_builders::StopAssessmentRun) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_run_arn(impl Into<String>)`](crate::client::fluent_builders::StopAssessmentRun::assessment_run_arn) / [`set_assessment_run_arn(Option<String>)`](crate::client::fluent_builders::StopAssessmentRun::set_assessment_run_arn): <p>The ARN of the assessment run that you want to stop.</p>
    ///   - [`stop_action(StopAction)`](crate::client::fluent_builders::StopAssessmentRun::stop_action) / [`set_stop_action(Option<StopAction>)`](crate::client::fluent_builders::StopAssessmentRun::set_stop_action): <p>An input option that can be set to either START_EVALUATION or SKIP_EVALUATION. START_EVALUATION (the default value), stops the AWS agent from collecting data and begins the results evaluation and the findings generation process. SKIP_EVALUATION cancels the assessment run immediately, after which no findings are generated.</p>
    /// - On success, responds with [`StopAssessmentRunOutput`](crate::output::StopAssessmentRunOutput)

    /// - On failure, responds with [`SdkError<StopAssessmentRunError>`](crate::error::StopAssessmentRunError)
    pub fn stop_assessment_run(&self) -> fluent_builders::StopAssessmentRun {
        fluent_builders::StopAssessmentRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SubscribeToEvent`](crate::client::fluent_builders::SubscribeToEvent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::SubscribeToEvent::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::SubscribeToEvent::set_resource_arn): <p>The ARN of the assessment template that is used during the event for which you want to receive SNS notifications.</p>
    ///   - [`event(InspectorEvent)`](crate::client::fluent_builders::SubscribeToEvent::event) / [`set_event(Option<InspectorEvent>)`](crate::client::fluent_builders::SubscribeToEvent::set_event): <p>The event for which you want to receive SNS notifications.</p>
    ///   - [`topic_arn(impl Into<String>)`](crate::client::fluent_builders::SubscribeToEvent::topic_arn) / [`set_topic_arn(Option<String>)`](crate::client::fluent_builders::SubscribeToEvent::set_topic_arn): <p>The ARN of the SNS topic to which the SNS notifications are sent.</p>
    /// - On success, responds with [`SubscribeToEventOutput`](crate::output::SubscribeToEventOutput)

    /// - On failure, responds with [`SdkError<SubscribeToEventError>`](crate::error::SubscribeToEventError)
    pub fn subscribe_to_event(&self) -> fluent_builders::SubscribeToEvent {
        fluent_builders::SubscribeToEvent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UnsubscribeFromEvent`](crate::client::fluent_builders::UnsubscribeFromEvent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UnsubscribeFromEvent::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UnsubscribeFromEvent::set_resource_arn): <p>The ARN of the assessment template that is used during the event for which you want to stop receiving SNS notifications.</p>
    ///   - [`event(InspectorEvent)`](crate::client::fluent_builders::UnsubscribeFromEvent::event) / [`set_event(Option<InspectorEvent>)`](crate::client::fluent_builders::UnsubscribeFromEvent::set_event): <p>The event for which you want to stop receiving SNS notifications.</p>
    ///   - [`topic_arn(impl Into<String>)`](crate::client::fluent_builders::UnsubscribeFromEvent::topic_arn) / [`set_topic_arn(Option<String>)`](crate::client::fluent_builders::UnsubscribeFromEvent::set_topic_arn): <p>The ARN of the SNS topic to which SNS notifications are sent.</p>
    /// - On success, responds with [`UnsubscribeFromEventOutput`](crate::output::UnsubscribeFromEventOutput)

    /// - On failure, responds with [`SdkError<UnsubscribeFromEventError>`](crate::error::UnsubscribeFromEventError)
    pub fn unsubscribe_from_event(&self) -> fluent_builders::UnsubscribeFromEvent {
        fluent_builders::UnsubscribeFromEvent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAssessmentTarget`](crate::client::fluent_builders::UpdateAssessmentTarget) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_target_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateAssessmentTarget::assessment_target_arn) / [`set_assessment_target_arn(Option<String>)`](crate::client::fluent_builders::UpdateAssessmentTarget::set_assessment_target_arn): <p>The ARN of the assessment target that you want to update.</p>
    ///   - [`assessment_target_name(impl Into<String>)`](crate::client::fluent_builders::UpdateAssessmentTarget::assessment_target_name) / [`set_assessment_target_name(Option<String>)`](crate::client::fluent_builders::UpdateAssessmentTarget::set_assessment_target_name): <p>The name of the assessment target that you want to update.</p>
    ///   - [`resource_group_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateAssessmentTarget::resource_group_arn) / [`set_resource_group_arn(Option<String>)`](crate::client::fluent_builders::UpdateAssessmentTarget::set_resource_group_arn): <p>The ARN of the resource group that is used to specify the new resource group to associate with the assessment target.</p>
    /// - On success, responds with [`UpdateAssessmentTargetOutput`](crate::output::UpdateAssessmentTargetOutput)

    /// - On failure, responds with [`SdkError<UpdateAssessmentTargetError>`](crate::error::UpdateAssessmentTargetError)
    pub fn update_assessment_target(&self) -> fluent_builders::UpdateAssessmentTarget {
        fluent_builders::UpdateAssessmentTarget::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddAttributesToFindings`.
    ///
    /// <p>Assigns attributes (key and value pairs) to the findings that are specified by the ARNs of the findings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddAttributesToFindings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_attributes_to_findings_input::Builder,
    }
    impl AddAttributesToFindings {
        /// Creates a new `AddAttributesToFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddAttributesToFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::AddAttributesToFindingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `findingArns`.
        ///
        /// To override the contents of this collection use [`set_finding_arns`](Self::set_finding_arns).
        ///
        /// <p>The ARNs that specify the findings that you want to assign attributes to.</p>
        pub fn finding_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.finding_arns(input.into());
            self
        }
        /// <p>The ARNs that specify the findings that you want to assign attributes to.</p>
        pub fn set_finding_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_finding_arns(input);
            self
        }
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The array of attributes that you want to assign to specified findings.</p>
        pub fn attributes(mut self, input: crate::model::Attribute) -> Self {
            self.inner = self.inner.attributes(input);
            self
        }
        /// <p>The array of attributes that you want to assign to specified findings.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAssessmentTarget`.
    ///
    /// <p>Creates a new assessment target using the ARN of the resource group that is generated by <code>CreateResourceGroup</code>. If resourceGroupArn is not specified, all EC2 instances in the current AWS account and region are included in the assessment target. If the <a href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_slr.html">service-linked role</a> isn’t already registered, this action also creates and registers a service-linked role to grant Amazon Inspector access to AWS Services needed to perform security assessments. You can create up to 50 assessment targets per AWS account. You can run up to 500 concurrent agents per AWS account. For more information, see <a href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html"> Amazon Inspector Assessment Targets</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAssessmentTarget {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_assessment_target_input::Builder,
    }
    impl CreateAssessmentTarget {
        /// Creates a new `CreateAssessmentTarget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAssessmentTargetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAssessmentTargetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user-defined name that identifies the assessment target that you want to create. The name must be unique within the AWS account.</p>
        pub fn assessment_target_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_target_name(input.into());
            self
        }
        /// <p>The user-defined name that identifies the assessment target that you want to create. The name must be unique within the AWS account.</p>
        pub fn set_assessment_target_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_target_name(input);
            self
        }
        /// <p>The ARN that specifies the resource group that is used to create the assessment target. If resourceGroupArn is not specified, all EC2 instances in the current AWS account and region are included in the assessment target.</p>
        pub fn resource_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_arn(input.into());
            self
        }
        /// <p>The ARN that specifies the resource group that is used to create the assessment target. If resourceGroupArn is not specified, all EC2 instances in the current AWS account and region are included in the assessment target.</p>
        pub fn set_resource_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAssessmentTemplate`.
    ///
    /// <p>Creates an assessment template for the assessment target that is specified by the ARN of the assessment target. If the <a href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_slr.html">service-linked role</a> isn’t already registered, this action also creates and registers a service-linked role to grant Amazon Inspector access to AWS Services needed to perform security assessments.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAssessmentTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_assessment_template_input::Builder,
    }
    impl CreateAssessmentTemplate {
        /// Creates a new `CreateAssessmentTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAssessmentTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAssessmentTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN that specifies the assessment target for which you want to create the assessment template.</p>
        pub fn assessment_target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_target_arn(input.into());
            self
        }
        /// <p>The ARN that specifies the assessment target for which you want to create the assessment template.</p>
        pub fn set_assessment_target_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_target_arn(input);
            self
        }
        /// <p>The user-defined name that identifies the assessment template that you want to create. You can create several assessment templates for an assessment target. The names of the assessment templates that correspond to a particular assessment target must be unique.</p>
        pub fn assessment_template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_template_name(input.into());
            self
        }
        /// <p>The user-defined name that identifies the assessment template that you want to create. You can create several assessment templates for an assessment target. The names of the assessment templates that correspond to a particular assessment target must be unique.</p>
        pub fn set_assessment_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_template_name(input);
            self
        }
        /// <p>The duration of the assessment run in seconds.</p>
        pub fn duration_in_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.duration_in_seconds(input);
            self
        }
        /// <p>The duration of the assessment run in seconds.</p>
        pub fn set_duration_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_duration_in_seconds(input);
            self
        }
        /// Appends an item to `rulesPackageArns`.
        ///
        /// To override the contents of this collection use [`set_rules_package_arns`](Self::set_rules_package_arns).
        ///
        /// <p>The ARNs that specify the rules packages that you want to attach to the assessment template.</p>
        pub fn rules_package_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rules_package_arns(input.into());
            self
        }
        /// <p>The ARNs that specify the rules packages that you want to attach to the assessment template.</p>
        pub fn set_rules_package_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_rules_package_arns(input);
            self
        }
        /// Appends an item to `userAttributesForFindings`.
        ///
        /// To override the contents of this collection use [`set_user_attributes_for_findings`](Self::set_user_attributes_for_findings).
        ///
        /// <p>The user-defined attributes that are assigned to every finding that is generated by the assessment run that uses this assessment template. An attribute is a key and value pair (an <code>Attribute</code> object). Within an assessment template, each key must be unique.</p>
        pub fn user_attributes_for_findings(mut self, input: crate::model::Attribute) -> Self {
            self.inner = self.inner.user_attributes_for_findings(input);
            self
        }
        /// <p>The user-defined attributes that are assigned to every finding that is generated by the assessment run that uses this assessment template. An attribute is a key and value pair (an <code>Attribute</code> object). Within an assessment template, each key must be unique.</p>
        pub fn set_user_attributes_for_findings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.inner = self.inner.set_user_attributes_for_findings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateExclusionsPreview`.
    ///
    /// <p>Starts the generation of an exclusions preview for the specified assessment template. The exclusions preview lists the potential exclusions (ExclusionPreview) that Inspector can detect before it runs the assessment. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateExclusionsPreview {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_exclusions_preview_input::Builder,
    }
    impl CreateExclusionsPreview {
        /// Creates a new `CreateExclusionsPreview`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateExclusionsPreviewOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateExclusionsPreviewError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN that specifies the assessment template for which you want to create an exclusions preview.</p>
        pub fn assessment_template_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_template_arn(input.into());
            self
        }
        /// <p>The ARN that specifies the assessment template for which you want to create an exclusions preview.</p>
        pub fn set_assessment_template_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_template_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResourceGroup`.
    ///
    /// <p>Creates a resource group using the specified set of tags (key and value pairs) that are used to select the EC2 instances to be included in an Amazon Inspector assessment target. The created resource group is then used to create an Amazon Inspector assessment target. For more information, see <code>CreateAssessmentTarget</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateResourceGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_resource_group_input::Builder,
    }
    impl CreateResourceGroup {
        /// Creates a new `CreateResourceGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResourceGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResourceGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `resourceGroupTags`.
        ///
        /// To override the contents of this collection use [`set_resource_group_tags`](Self::set_resource_group_tags).
        ///
        /// <p>A collection of keys and an array of possible values, '[{"key":"key1","values":["Value1","Value2"]},{"key":"Key2","values":["Value3"]}]'.</p>
        /// <p>For example,'[{"key":"Name","values":["TestEC2Instance"]}]'.</p>
        pub fn resource_group_tags(mut self, input: crate::model::ResourceGroupTag) -> Self {
            self.inner = self.inner.resource_group_tags(input);
            self
        }
        /// <p>A collection of keys and an array of possible values, '[{"key":"key1","values":["Value1","Value2"]},{"key":"Key2","values":["Value3"]}]'.</p>
        /// <p>For example,'[{"key":"Name","values":["TestEC2Instance"]}]'.</p>
        pub fn set_resource_group_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceGroupTag>>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAssessmentRun`.
    ///
    /// <p>Deletes the assessment run that is specified by the ARN of the assessment run.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAssessmentRun {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_assessment_run_input::Builder,
    }
    impl DeleteAssessmentRun {
        /// Creates a new `DeleteAssessmentRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAssessmentRunOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAssessmentRunError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN that specifies the assessment run that you want to delete.</p>
        pub fn assessment_run_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_run_arn(input.into());
            self
        }
        /// <p>The ARN that specifies the assessment run that you want to delete.</p>
        pub fn set_assessment_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_run_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAssessmentTarget`.
    ///
    /// <p>Deletes the assessment target that is specified by the ARN of the assessment target.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAssessmentTarget {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_assessment_target_input::Builder,
    }
    impl DeleteAssessmentTarget {
        /// Creates a new `DeleteAssessmentTarget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAssessmentTargetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAssessmentTargetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN that specifies the assessment target that you want to delete.</p>
        pub fn assessment_target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_target_arn(input.into());
            self
        }
        /// <p>The ARN that specifies the assessment target that you want to delete.</p>
        pub fn set_assessment_target_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_target_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAssessmentTemplate`.
    ///
    /// <p>Deletes the assessment template that is specified by the ARN of the assessment template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAssessmentTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_assessment_template_input::Builder,
    }
    impl DeleteAssessmentTemplate {
        /// Creates a new `DeleteAssessmentTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAssessmentTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAssessmentTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN that specifies the assessment template that you want to delete.</p>
        pub fn assessment_template_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_template_arn(input.into());
            self
        }
        /// <p>The ARN that specifies the assessment template that you want to delete.</p>
        pub fn set_assessment_template_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_template_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAssessmentRuns`.
    ///
    /// <p>Describes the assessment runs that are specified by the ARNs of the assessment runs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAssessmentRuns {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_assessment_runs_input::Builder,
    }
    impl DescribeAssessmentRuns {
        /// Creates a new `DescribeAssessmentRuns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAssessmentRunsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAssessmentRunsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `assessmentRunArns`.
        ///
        /// To override the contents of this collection use [`set_assessment_run_arns`](Self::set_assessment_run_arns).
        ///
        /// <p>The ARN that specifies the assessment run that you want to describe.</p>
        pub fn assessment_run_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_run_arns(input.into());
            self
        }
        /// <p>The ARN that specifies the assessment run that you want to describe.</p>
        pub fn set_assessment_run_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_assessment_run_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAssessmentTargets`.
    ///
    /// <p>Describes the assessment targets that are specified by the ARNs of the assessment targets.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAssessmentTargets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_assessment_targets_input::Builder,
    }
    impl DescribeAssessmentTargets {
        /// Creates a new `DescribeAssessmentTargets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAssessmentTargetsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAssessmentTargetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `assessmentTargetArns`.
        ///
        /// To override the contents of this collection use [`set_assessment_target_arns`](Self::set_assessment_target_arns).
        ///
        /// <p>The ARNs that specifies the assessment targets that you want to describe.</p>
        pub fn assessment_target_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_target_arns(input.into());
            self
        }
        /// <p>The ARNs that specifies the assessment targets that you want to describe.</p>
        pub fn set_assessment_target_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_assessment_target_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAssessmentTemplates`.
    ///
    /// <p>Describes the assessment templates that are specified by the ARNs of the assessment templates.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAssessmentTemplates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_assessment_templates_input::Builder,
    }
    impl DescribeAssessmentTemplates {
        /// Creates a new `DescribeAssessmentTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAssessmentTemplatesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAssessmentTemplatesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `assessmentTemplateArns`.
        ///
        /// To override the contents of this collection use [`set_assessment_template_arns`](Self::set_assessment_template_arns).
        ///
        #[allow(missing_docs)] // documentation missing in model
        pub fn assessment_template_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_template_arns(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_assessment_template_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_assessment_template_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCrossAccountAccessRole`.
    ///
    /// <p>Describes the IAM role that enables Amazon Inspector to access your AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCrossAccountAccessRole {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_cross_account_access_role_input::Builder,
    }
    impl DescribeCrossAccountAccessRole {
        /// Creates a new `DescribeCrossAccountAccessRole`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCrossAccountAccessRoleOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCrossAccountAccessRoleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeExclusions`.
    ///
    /// <p>Describes the exclusions that are specified by the exclusions' ARNs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeExclusions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_exclusions_input::Builder,
    }
    impl DescribeExclusions {
        /// Creates a new `DescribeExclusions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeExclusionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeExclusionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `exclusionArns`.
        ///
        /// To override the contents of this collection use [`set_exclusion_arns`](Self::set_exclusion_arns).
        ///
        /// <p>The list of ARNs that specify the exclusions that you want to describe.</p>
        pub fn exclusion_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.exclusion_arns(input.into());
            self
        }
        /// <p>The list of ARNs that specify the exclusions that you want to describe.</p>
        pub fn set_exclusion_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_exclusion_arns(input);
            self
        }
        /// <p>The locale into which you want to translate the exclusion's title, description, and recommendation.</p>
        pub fn locale(mut self, input: crate::model::Locale) -> Self {
            self.inner = self.inner.locale(input);
            self
        }
        /// <p>The locale into which you want to translate the exclusion's title, description, and recommendation.</p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::Locale>) -> Self {
            self.inner = self.inner.set_locale(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFindings`.
    ///
    /// <p>Describes the findings that are specified by the ARNs of the findings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeFindings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_findings_input::Builder,
    }
    impl DescribeFindings {
        /// Creates a new `DescribeFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFindingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `findingArns`.
        ///
        /// To override the contents of this collection use [`set_finding_arns`](Self::set_finding_arns).
        ///
        /// <p>The ARN that specifies the finding that you want to describe.</p>
        pub fn finding_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.finding_arns(input.into());
            self
        }
        /// <p>The ARN that specifies the finding that you want to describe.</p>
        pub fn set_finding_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_finding_arns(input);
            self
        }
        /// <p>The locale into which you want to translate a finding description, recommendation, and the short description that identifies the finding.</p>
        pub fn locale(mut self, input: crate::model::Locale) -> Self {
            self.inner = self.inner.locale(input);
            self
        }
        /// <p>The locale into which you want to translate a finding description, recommendation, and the short description that identifies the finding.</p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::Locale>) -> Self {
            self.inner = self.inner.set_locale(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeResourceGroups`.
    ///
    /// <p>Describes the resource groups that are specified by the ARNs of the resource groups.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeResourceGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_resource_groups_input::Builder,
    }
    impl DescribeResourceGroups {
        /// Creates a new `DescribeResourceGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeResourceGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeResourceGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `resourceGroupArns`.
        ///
        /// To override the contents of this collection use [`set_resource_group_arns`](Self::set_resource_group_arns).
        ///
        /// <p>The ARN that specifies the resource group that you want to describe.</p>
        pub fn resource_group_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_arns(input.into());
            self
        }
        /// <p>The ARN that specifies the resource group that you want to describe.</p>
        pub fn set_resource_group_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRulesPackages`.
    ///
    /// <p>Describes the rules packages that are specified by the ARNs of the rules packages.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRulesPackages {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_rules_packages_input::Builder,
    }
    impl DescribeRulesPackages {
        /// Creates a new `DescribeRulesPackages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRulesPackagesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRulesPackagesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `rulesPackageArns`.
        ///
        /// To override the contents of this collection use [`set_rules_package_arns`](Self::set_rules_package_arns).
        ///
        /// <p>The ARN that specifies the rules package that you want to describe.</p>
        pub fn rules_package_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rules_package_arns(input.into());
            self
        }
        /// <p>The ARN that specifies the rules package that you want to describe.</p>
        pub fn set_rules_package_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_rules_package_arns(input);
            self
        }
        /// <p>The locale that you want to translate a rules package description into.</p>
        pub fn locale(mut self, input: crate::model::Locale) -> Self {
            self.inner = self.inner.locale(input);
            self
        }
        /// <p>The locale that you want to translate a rules package description into.</p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::Locale>) -> Self {
            self.inner = self.inner.set_locale(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAssessmentReport`.
    ///
    /// <p>Produces an assessment report that includes detailed and comprehensive results of a specified assessment run. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAssessmentReport {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_assessment_report_input::Builder,
    }
    impl GetAssessmentReport {
        /// Creates a new `GetAssessmentReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAssessmentReportOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAssessmentReportError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN that specifies the assessment run for which you want to generate a report.</p>
        pub fn assessment_run_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_run_arn(input.into());
            self
        }
        /// <p>The ARN that specifies the assessment run for which you want to generate a report.</p>
        pub fn set_assessment_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_run_arn(input);
            self
        }
        /// <p>Specifies the file format (html or pdf) of the assessment report that you want to generate.</p>
        pub fn report_file_format(mut self, input: crate::model::ReportFileFormat) -> Self {
            self.inner = self.inner.report_file_format(input);
            self
        }
        /// <p>Specifies the file format (html or pdf) of the assessment report that you want to generate.</p>
        pub fn set_report_file_format(
            mut self,
            input: std::option::Option<crate::model::ReportFileFormat>,
        ) -> Self {
            self.inner = self.inner.set_report_file_format(input);
            self
        }
        /// <p>Specifies the type of the assessment report that you want to generate. There are two types of assessment reports: a finding report and a full report. For more information, see <a href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_reports.html">Assessment Reports</a>. </p>
        pub fn report_type(mut self, input: crate::model::ReportType) -> Self {
            self.inner = self.inner.report_type(input);
            self
        }
        /// <p>Specifies the type of the assessment report that you want to generate. There are two types of assessment reports: a finding report and a full report. For more information, see <a href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_reports.html">Assessment Reports</a>. </p>
        pub fn set_report_type(
            mut self,
            input: std::option::Option<crate::model::ReportType>,
        ) -> Self {
            self.inner = self.inner.set_report_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetExclusionsPreview`.
    ///
    /// <p>Retrieves the exclusions preview (a list of ExclusionPreview objects) specified by the preview token. You can obtain the preview token by running the CreateExclusionsPreview API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetExclusionsPreview {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_exclusions_preview_input::Builder,
    }
    impl GetExclusionsPreview {
        /// Creates a new `GetExclusionsPreview`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetExclusionsPreviewOutput,
            aws_smithy_http::result::SdkError<crate::error::GetExclusionsPreviewError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetExclusionsPreviewPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetExclusionsPreviewPaginator {
            crate::paginator::GetExclusionsPreviewPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN that specifies the assessment template for which the exclusions preview was requested.</p>
        pub fn assessment_template_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_template_arn(input.into());
            self
        }
        /// <p>The ARN that specifies the assessment template for which the exclusions preview was requested.</p>
        pub fn set_assessment_template_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_template_arn(input);
            self
        }
        /// <p>The unique identifier associated of the exclusions preview.</p>
        pub fn preview_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preview_token(input.into());
            self
        }
        /// <p>The unique identifier associated of the exclusions preview.</p>
        pub fn set_preview_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preview_token(input);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the GetExclusionsPreviewRequest action. Subsequent calls to the action fill nextToken in the request with the value of nextToken from the previous response to continue listing data.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the GetExclusionsPreviewRequest action. Subsequent calls to the action fill nextToken in the request with the value of nextToken from the previous response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 100. The maximum value is 500.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 100. The maximum value is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The locale into which you want to translate the exclusion's title, description, and recommendation.</p>
        pub fn locale(mut self, input: crate::model::Locale) -> Self {
            self.inner = self.inner.locale(input);
            self
        }
        /// <p>The locale into which you want to translate the exclusion's title, description, and recommendation.</p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::Locale>) -> Self {
            self.inner = self.inner.set_locale(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTelemetryMetadata`.
    ///
    /// <p>Information about the data that is collected for the specified assessment run.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTelemetryMetadata {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_telemetry_metadata_input::Builder,
    }
    impl GetTelemetryMetadata {
        /// Creates a new `GetTelemetryMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTelemetryMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTelemetryMetadataError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN that specifies the assessment run that has the telemetry data that you want to obtain.</p>
        pub fn assessment_run_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_run_arn(input.into());
            self
        }
        /// <p>The ARN that specifies the assessment run that has the telemetry data that you want to obtain.</p>
        pub fn set_assessment_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_run_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssessmentRunAgents`.
    ///
    /// <p>Lists the agents of the assessment runs that are specified by the ARNs of the assessment runs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAssessmentRunAgents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_assessment_run_agents_input::Builder,
    }
    impl ListAssessmentRunAgents {
        /// Creates a new `ListAssessmentRunAgents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssessmentRunAgentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssessmentRunAgentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAssessmentRunAgentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAssessmentRunAgentsPaginator {
            crate::paginator::ListAssessmentRunAgentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN that specifies the assessment run whose agents you want to list.</p>
        pub fn assessment_run_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_run_arn(input.into());
            self
        }
        /// <p>The ARN that specifies the assessment run whose agents you want to list.</p>
        pub fn set_assessment_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_run_arn(input);
            self
        }
        /// <p>You can use this parameter to specify a subset of data to be included in the action's response.</p>
        /// <p>For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.</p>
        pub fn filter(mut self, input: crate::model::AgentFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>You can use this parameter to specify a subset of data to be included in the action's response.</p>
        /// <p>For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.</p>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::AgentFilter>) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>ListAssessmentRunAgents</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>ListAssessmentRunAgents</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 10. The maximum value is 500.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 10. The maximum value is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssessmentRuns`.
    ///
    /// <p>Lists the assessment runs that correspond to the assessment templates that are specified by the ARNs of the assessment templates.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAssessmentRuns {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_assessment_runs_input::Builder,
    }
    impl ListAssessmentRuns {
        /// Creates a new `ListAssessmentRuns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssessmentRunsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssessmentRunsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAssessmentRunsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAssessmentRunsPaginator {
            crate::paginator::ListAssessmentRunsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `assessmentTemplateArns`.
        ///
        /// To override the contents of this collection use [`set_assessment_template_arns`](Self::set_assessment_template_arns).
        ///
        /// <p>The ARNs that specify the assessment templates whose assessment runs you want to list.</p>
        pub fn assessment_template_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_template_arns(input.into());
            self
        }
        /// <p>The ARNs that specify the assessment templates whose assessment runs you want to list.</p>
        pub fn set_assessment_template_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_assessment_template_arns(input);
            self
        }
        /// <p>You can use this parameter to specify a subset of data to be included in the action's response.</p>
        /// <p>For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.</p>
        pub fn filter(mut self, input: crate::model::AssessmentRunFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>You can use this parameter to specify a subset of data to be included in the action's response.</p>
        /// <p>For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::AssessmentRunFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>ListAssessmentRuns</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>ListAssessmentRuns</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 10. The maximum value is 500.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 10. The maximum value is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssessmentTargets`.
    ///
    /// <p>Lists the ARNs of the assessment targets within this AWS account. For more information about assessment targets, see <a href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html">Amazon Inspector Assessment Targets</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAssessmentTargets {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_assessment_targets_input::Builder,
    }
    impl ListAssessmentTargets {
        /// Creates a new `ListAssessmentTargets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssessmentTargetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssessmentTargetsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAssessmentTargetsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAssessmentTargetsPaginator {
            crate::paginator::ListAssessmentTargetsPaginator::new(self.handle, self.inner)
        }
        /// <p>You can use this parameter to specify a subset of data to be included in the action's response.</p>
        /// <p>For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.</p>
        pub fn filter(mut self, input: crate::model::AssessmentTargetFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>You can use this parameter to specify a subset of data to be included in the action's response.</p>
        /// <p>For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::AssessmentTargetFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>ListAssessmentTargets</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>ListAssessmentTargets</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssessmentTemplates`.
    ///
    /// <p>Lists the assessment templates that correspond to the assessment targets that are specified by the ARNs of the assessment targets.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAssessmentTemplates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_assessment_templates_input::Builder,
    }
    impl ListAssessmentTemplates {
        /// Creates a new `ListAssessmentTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssessmentTemplatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssessmentTemplatesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAssessmentTemplatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAssessmentTemplatesPaginator {
            crate::paginator::ListAssessmentTemplatesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `assessmentTargetArns`.
        ///
        /// To override the contents of this collection use [`set_assessment_target_arns`](Self::set_assessment_target_arns).
        ///
        /// <p>A list of ARNs that specifies the assessment targets whose assessment templates you want to list.</p>
        pub fn assessment_target_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_target_arns(input.into());
            self
        }
        /// <p>A list of ARNs that specifies the assessment targets whose assessment templates you want to list.</p>
        pub fn set_assessment_target_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_assessment_target_arns(input);
            self
        }
        /// <p>You can use this parameter to specify a subset of data to be included in the action's response.</p>
        /// <p>For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.</p>
        pub fn filter(mut self, input: crate::model::AssessmentTemplateFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>You can use this parameter to specify a subset of data to be included in the action's response.</p>
        /// <p>For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::AssessmentTemplateFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>ListAssessmentTemplates</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>ListAssessmentTemplates</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEventSubscriptions`.
    ///
    /// <p>Lists all the event subscriptions for the assessment template that is specified by the ARN of the assessment template. For more information, see <code>SubscribeToEvent</code> and <code>UnsubscribeFromEvent</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEventSubscriptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_event_subscriptions_input::Builder,
    }
    impl ListEventSubscriptions {
        /// Creates a new `ListEventSubscriptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEventSubscriptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEventSubscriptionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListEventSubscriptionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListEventSubscriptionsPaginator {
            crate::paginator::ListEventSubscriptionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the assessment template for which you want to list the existing event subscriptions.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the assessment template for which you want to list the existing event subscriptions.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>ListEventSubscriptions</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>ListEventSubscriptions</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListExclusions`.
    ///
    /// <p>List exclusions that are generated by the assessment run.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListExclusions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_exclusions_input::Builder,
    }
    impl ListExclusions {
        /// Creates a new `ListExclusions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListExclusionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListExclusionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListExclusionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListExclusionsPaginator {
            crate::paginator::ListExclusionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the assessment run that generated the exclusions that you want to list.</p>
        pub fn assessment_run_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_run_arn(input.into());
            self
        }
        /// <p>The ARN of the assessment run that generated the exclusions that you want to list.</p>
        pub fn set_assessment_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_run_arn(input);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the ListExclusionsRequest action. Subsequent calls to the action fill nextToken in the request with the value of nextToken from the previous response to continue listing data.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the ListExclusionsRequest action. Subsequent calls to the action fill nextToken in the request with the value of nextToken from the previous response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 100. The maximum value is 500.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 100. The maximum value is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFindings`.
    ///
    /// <p>Lists findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFindings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_findings_input::Builder,
    }
    impl ListFindings {
        /// Creates a new `ListFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFindingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFindingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFindingsPaginator {
            crate::paginator::ListFindingsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `assessmentRunArns`.
        ///
        /// To override the contents of this collection use [`set_assessment_run_arns`](Self::set_assessment_run_arns).
        ///
        /// <p>The ARNs of the assessment runs that generate the findings that you want to list.</p>
        pub fn assessment_run_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_run_arns(input.into());
            self
        }
        /// <p>The ARNs of the assessment runs that generate the findings that you want to list.</p>
        pub fn set_assessment_run_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_assessment_run_arns(input);
            self
        }
        /// <p>You can use this parameter to specify a subset of data to be included in the action's response.</p>
        /// <p>For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.</p>
        pub fn filter(mut self, input: crate::model::FindingFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>You can use this parameter to specify a subset of data to be included in the action's response.</p>
        /// <p>For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::FindingFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>ListFindings</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>ListFindings</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRulesPackages`.
    ///
    /// <p>Lists all available Amazon Inspector rules packages.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRulesPackages {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_rules_packages_input::Builder,
    }
    impl ListRulesPackages {
        /// Creates a new `ListRulesPackages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRulesPackagesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRulesPackagesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRulesPackagesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListRulesPackagesPaginator {
            crate::paginator::ListRulesPackagesPaginator::new(self.handle, self.inner)
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>ListRulesPackages</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>ListRulesPackages</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists all tags associated with an assessment template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN that specifies the assessment template whose tags you want to list.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN that specifies the assessment template whose tags you want to list.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PreviewAgents`.
    ///
    /// <p>Previews the agents installed on the EC2 instances that are part of the specified assessment target.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PreviewAgents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::preview_agents_input::Builder,
    }
    impl PreviewAgents {
        /// Creates a new `PreviewAgents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PreviewAgentsOutput,
            aws_smithy_http::result::SdkError<crate::error::PreviewAgentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::PreviewAgentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::PreviewAgentsPaginator {
            crate::paginator::PreviewAgentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ARN of the assessment target whose agents you want to preview.</p>
        pub fn preview_agents_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preview_agents_arn(input.into());
            self
        }
        /// <p>The ARN of the assessment target whose agents you want to preview.</p>
        pub fn set_preview_agents_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preview_agents_arn(input);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>PreviewAgents</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the <b>PreviewAgents</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the value of <b>NextToken</b> from the previous response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterCrossAccountAccessRole`.
    ///
    /// <p>Registers the IAM role that grants Amazon Inspector access to AWS Services needed to perform security assessments.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterCrossAccountAccessRole {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::register_cross_account_access_role_input::Builder,
    }
    impl RegisterCrossAccountAccessRole {
        /// Creates a new `RegisterCrossAccountAccessRole`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterCrossAccountAccessRoleOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterCrossAccountAccessRoleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the IAM role that grants Amazon Inspector access to AWS Services needed to perform security assessments. </p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The ARN of the IAM role that grants Amazon Inspector access to AWS Services needed to perform security assessments. </p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveAttributesFromFindings`.
    ///
    /// <p>Removes entire attributes (key and value pairs) from the findings that are specified by the ARNs of the findings where an attribute with the specified key exists.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveAttributesFromFindings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_attributes_from_findings_input::Builder,
    }
    impl RemoveAttributesFromFindings {
        /// Creates a new `RemoveAttributesFromFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveAttributesFromFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveAttributesFromFindingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `findingArns`.
        ///
        /// To override the contents of this collection use [`set_finding_arns`](Self::set_finding_arns).
        ///
        /// <p>The ARNs that specify the findings that you want to remove attributes from.</p>
        pub fn finding_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.finding_arns(input.into());
            self
        }
        /// <p>The ARNs that specify the findings that you want to remove attributes from.</p>
        pub fn set_finding_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_finding_arns(input);
            self
        }
        /// Appends an item to `attributeKeys`.
        ///
        /// To override the contents of this collection use [`set_attribute_keys`](Self::set_attribute_keys).
        ///
        /// <p>The array of attribute keys that you want to remove from specified findings.</p>
        pub fn attribute_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attribute_keys(input.into());
            self
        }
        /// <p>The array of attribute keys that you want to remove from specified findings.</p>
        pub fn set_attribute_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_attribute_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetTagsForResource`.
    ///
    /// <p>Sets tags (key and value pairs) to the assessment template that is specified by the ARN of the assessment template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SetTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::set_tags_for_resource_input::Builder,
    }
    impl SetTagsForResource {
        /// Creates a new `SetTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::SetTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the assessment template that you want to set tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the assessment template that you want to set tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs that you want to set to the assessment template.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A collection of key and value pairs that you want to set to the assessment template.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartAssessmentRun`.
    ///
    /// <p>Starts the assessment run specified by the ARN of the assessment template. For this API to function properly, you must not exceed the limit of running up to 500 concurrent agents per AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartAssessmentRun {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_assessment_run_input::Builder,
    }
    impl StartAssessmentRun {
        /// Creates a new `StartAssessmentRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartAssessmentRunOutput,
            aws_smithy_http::result::SdkError<crate::error::StartAssessmentRunError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the assessment template of the assessment run that you want to start.</p>
        pub fn assessment_template_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_template_arn(input.into());
            self
        }
        /// <p>The ARN of the assessment template of the assessment run that you want to start.</p>
        pub fn set_assessment_template_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_template_arn(input);
            self
        }
        /// <p>You can specify the name for the assessment run. The name must be unique for the assessment template whose ARN is used to start the assessment run.</p>
        pub fn assessment_run_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_run_name(input.into());
            self
        }
        /// <p>You can specify the name for the assessment run. The name must be unique for the assessment template whose ARN is used to start the assessment run.</p>
        pub fn set_assessment_run_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_run_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopAssessmentRun`.
    ///
    /// <p>Stops the assessment run that is specified by the ARN of the assessment run.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopAssessmentRun {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_assessment_run_input::Builder,
    }
    impl StopAssessmentRun {
        /// Creates a new `StopAssessmentRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopAssessmentRunOutput,
            aws_smithy_http::result::SdkError<crate::error::StopAssessmentRunError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the assessment run that you want to stop.</p>
        pub fn assessment_run_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_run_arn(input.into());
            self
        }
        /// <p>The ARN of the assessment run that you want to stop.</p>
        pub fn set_assessment_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_run_arn(input);
            self
        }
        /// <p>An input option that can be set to either START_EVALUATION or SKIP_EVALUATION. START_EVALUATION (the default value), stops the AWS agent from collecting data and begins the results evaluation and the findings generation process. SKIP_EVALUATION cancels the assessment run immediately, after which no findings are generated.</p>
        pub fn stop_action(mut self, input: crate::model::StopAction) -> Self {
            self.inner = self.inner.stop_action(input);
            self
        }
        /// <p>An input option that can be set to either START_EVALUATION or SKIP_EVALUATION. START_EVALUATION (the default value), stops the AWS agent from collecting data and begins the results evaluation and the findings generation process. SKIP_EVALUATION cancels the assessment run immediately, after which no findings are generated.</p>
        pub fn set_stop_action(
            mut self,
            input: std::option::Option<crate::model::StopAction>,
        ) -> Self {
            self.inner = self.inner.set_stop_action(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SubscribeToEvent`.
    ///
    /// <p>Enables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SubscribeToEvent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::subscribe_to_event_input::Builder,
    }
    impl SubscribeToEvent {
        /// Creates a new `SubscribeToEvent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SubscribeToEventOutput,
            aws_smithy_http::result::SdkError<crate::error::SubscribeToEventError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the assessment template that is used during the event for which you want to receive SNS notifications.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the assessment template that is used during the event for which you want to receive SNS notifications.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The event for which you want to receive SNS notifications.</p>
        pub fn event(mut self, input: crate::model::InspectorEvent) -> Self {
            self.inner = self.inner.event(input);
            self
        }
        /// <p>The event for which you want to receive SNS notifications.</p>
        pub fn set_event(
            mut self,
            input: std::option::Option<crate::model::InspectorEvent>,
        ) -> Self {
            self.inner = self.inner.set_event(input);
            self
        }
        /// <p>The ARN of the SNS topic to which the SNS notifications are sent.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.topic_arn(input.into());
            self
        }
        /// <p>The ARN of the SNS topic to which the SNS notifications are sent.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_topic_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UnsubscribeFromEvent`.
    ///
    /// <p>Disables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UnsubscribeFromEvent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::unsubscribe_from_event_input::Builder,
    }
    impl UnsubscribeFromEvent {
        /// Creates a new `UnsubscribeFromEvent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UnsubscribeFromEventOutput,
            aws_smithy_http::result::SdkError<crate::error::UnsubscribeFromEventError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the assessment template that is used during the event for which you want to stop receiving SNS notifications.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the assessment template that is used during the event for which you want to stop receiving SNS notifications.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The event for which you want to stop receiving SNS notifications.</p>
        pub fn event(mut self, input: crate::model::InspectorEvent) -> Self {
            self.inner = self.inner.event(input);
            self
        }
        /// <p>The event for which you want to stop receiving SNS notifications.</p>
        pub fn set_event(
            mut self,
            input: std::option::Option<crate::model::InspectorEvent>,
        ) -> Self {
            self.inner = self.inner.set_event(input);
            self
        }
        /// <p>The ARN of the SNS topic to which SNS notifications are sent.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.topic_arn(input.into());
            self
        }
        /// <p>The ARN of the SNS topic to which SNS notifications are sent.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_topic_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAssessmentTarget`.
    ///
    /// <p>Updates the assessment target that is specified by the ARN of the assessment target.</p>
    /// <p>If resourceGroupArn is not specified, all EC2 instances in the current AWS account and region are included in the assessment target.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAssessmentTarget {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_assessment_target_input::Builder,
    }
    impl UpdateAssessmentTarget {
        /// Creates a new `UpdateAssessmentTarget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAssessmentTargetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAssessmentTargetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the assessment target that you want to update.</p>
        pub fn assessment_target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_target_arn(input.into());
            self
        }
        /// <p>The ARN of the assessment target that you want to update.</p>
        pub fn set_assessment_target_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_target_arn(input);
            self
        }
        /// <p>The name of the assessment target that you want to update.</p>
        pub fn assessment_target_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_target_name(input.into());
            self
        }
        /// <p>The name of the assessment target that you want to update.</p>
        pub fn set_assessment_target_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_target_name(input);
            self
        }
        /// <p>The ARN of the resource group that is used to specify the new resource group to associate with the assessment target.</p>
        pub fn resource_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_arn(input.into());
            self
        }
        /// <p>The ARN of the resource group that is used to specify the new resource group to associate with the assessment target.</p>
        pub fn set_resource_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_arn(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
