// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `InspectorService`.
///
/// This client allows ergonomic access to a `InspectorService`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AddAttributesToFindings` operation.
    ///
    /// See [`AddAttributesToFindings`](crate::client::fluent_builders::AddAttributesToFindings) for more information about the
    /// operation and its arguments.
    pub fn add_attributes_to_findings(&self) -> fluent_builders::AddAttributesToFindings<C, M, R> {
        fluent_builders::AddAttributesToFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAssessmentTarget` operation.
    ///
    /// See [`CreateAssessmentTarget`](crate::client::fluent_builders::CreateAssessmentTarget) for more information about the
    /// operation and its arguments.
    pub fn create_assessment_target(&self) -> fluent_builders::CreateAssessmentTarget<C, M, R> {
        fluent_builders::CreateAssessmentTarget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAssessmentTemplate` operation.
    ///
    /// See [`CreateAssessmentTemplate`](crate::client::fluent_builders::CreateAssessmentTemplate) for more information about the
    /// operation and its arguments.
    pub fn create_assessment_template(&self) -> fluent_builders::CreateAssessmentTemplate<C, M, R> {
        fluent_builders::CreateAssessmentTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateExclusionsPreview` operation.
    ///
    /// See [`CreateExclusionsPreview`](crate::client::fluent_builders::CreateExclusionsPreview) for more information about the
    /// operation and its arguments.
    pub fn create_exclusions_preview(&self) -> fluent_builders::CreateExclusionsPreview<C, M, R> {
        fluent_builders::CreateExclusionsPreview::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateResourceGroup` operation.
    ///
    /// See [`CreateResourceGroup`](crate::client::fluent_builders::CreateResourceGroup) for more information about the
    /// operation and its arguments.
    pub fn create_resource_group(&self) -> fluent_builders::CreateResourceGroup<C, M, R> {
        fluent_builders::CreateResourceGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAssessmentRun` operation.
    ///
    /// See [`DeleteAssessmentRun`](crate::client::fluent_builders::DeleteAssessmentRun) for more information about the
    /// operation and its arguments.
    pub fn delete_assessment_run(&self) -> fluent_builders::DeleteAssessmentRun<C, M, R> {
        fluent_builders::DeleteAssessmentRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAssessmentTarget` operation.
    ///
    /// See [`DeleteAssessmentTarget`](crate::client::fluent_builders::DeleteAssessmentTarget) for more information about the
    /// operation and its arguments.
    pub fn delete_assessment_target(&self) -> fluent_builders::DeleteAssessmentTarget<C, M, R> {
        fluent_builders::DeleteAssessmentTarget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAssessmentTemplate` operation.
    ///
    /// See [`DeleteAssessmentTemplate`](crate::client::fluent_builders::DeleteAssessmentTemplate) for more information about the
    /// operation and its arguments.
    pub fn delete_assessment_template(&self) -> fluent_builders::DeleteAssessmentTemplate<C, M, R> {
        fluent_builders::DeleteAssessmentTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAssessmentRuns` operation.
    ///
    /// See [`DescribeAssessmentRuns`](crate::client::fluent_builders::DescribeAssessmentRuns) for more information about the
    /// operation and its arguments.
    pub fn describe_assessment_runs(&self) -> fluent_builders::DescribeAssessmentRuns<C, M, R> {
        fluent_builders::DescribeAssessmentRuns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAssessmentTargets` operation.
    ///
    /// See [`DescribeAssessmentTargets`](crate::client::fluent_builders::DescribeAssessmentTargets) for more information about the
    /// operation and its arguments.
    pub fn describe_assessment_targets(
        &self,
    ) -> fluent_builders::DescribeAssessmentTargets<C, M, R> {
        fluent_builders::DescribeAssessmentTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAssessmentTemplates` operation.
    ///
    /// See [`DescribeAssessmentTemplates`](crate::client::fluent_builders::DescribeAssessmentTemplates) for more information about the
    /// operation and its arguments.
    pub fn describe_assessment_templates(
        &self,
    ) -> fluent_builders::DescribeAssessmentTemplates<C, M, R> {
        fluent_builders::DescribeAssessmentTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCrossAccountAccessRole` operation.
    ///
    /// See [`DescribeCrossAccountAccessRole`](crate::client::fluent_builders::DescribeCrossAccountAccessRole) for more information about the
    /// operation and its arguments.
    pub fn describe_cross_account_access_role(
        &self,
    ) -> fluent_builders::DescribeCrossAccountAccessRole<C, M, R> {
        fluent_builders::DescribeCrossAccountAccessRole::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeExclusions` operation.
    ///
    /// See [`DescribeExclusions`](crate::client::fluent_builders::DescribeExclusions) for more information about the
    /// operation and its arguments.
    pub fn describe_exclusions(&self) -> fluent_builders::DescribeExclusions<C, M, R> {
        fluent_builders::DescribeExclusions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFindings` operation.
    ///
    /// See [`DescribeFindings`](crate::client::fluent_builders::DescribeFindings) for more information about the
    /// operation and its arguments.
    pub fn describe_findings(&self) -> fluent_builders::DescribeFindings<C, M, R> {
        fluent_builders::DescribeFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeResourceGroups` operation.
    ///
    /// See [`DescribeResourceGroups`](crate::client::fluent_builders::DescribeResourceGroups) for more information about the
    /// operation and its arguments.
    pub fn describe_resource_groups(&self) -> fluent_builders::DescribeResourceGroups<C, M, R> {
        fluent_builders::DescribeResourceGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRulesPackages` operation.
    ///
    /// See [`DescribeRulesPackages`](crate::client::fluent_builders::DescribeRulesPackages) for more information about the
    /// operation and its arguments.
    pub fn describe_rules_packages(&self) -> fluent_builders::DescribeRulesPackages<C, M, R> {
        fluent_builders::DescribeRulesPackages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAssessmentReport` operation.
    ///
    /// See [`GetAssessmentReport`](crate::client::fluent_builders::GetAssessmentReport) for more information about the
    /// operation and its arguments.
    pub fn get_assessment_report(&self) -> fluent_builders::GetAssessmentReport<C, M, R> {
        fluent_builders::GetAssessmentReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetExclusionsPreview` operation.
    ///
    /// See [`GetExclusionsPreview`](crate::client::fluent_builders::GetExclusionsPreview) for more information about the
    /// operation and its arguments.
    pub fn get_exclusions_preview(&self) -> fluent_builders::GetExclusionsPreview<C, M, R> {
        fluent_builders::GetExclusionsPreview::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTelemetryMetadata` operation.
    ///
    /// See [`GetTelemetryMetadata`](crate::client::fluent_builders::GetTelemetryMetadata) for more information about the
    /// operation and its arguments.
    pub fn get_telemetry_metadata(&self) -> fluent_builders::GetTelemetryMetadata<C, M, R> {
        fluent_builders::GetTelemetryMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAssessmentRunAgents` operation.
    ///
    /// See [`ListAssessmentRunAgents`](crate::client::fluent_builders::ListAssessmentRunAgents) for more information about the
    /// operation and its arguments.
    pub fn list_assessment_run_agents(&self) -> fluent_builders::ListAssessmentRunAgents<C, M, R> {
        fluent_builders::ListAssessmentRunAgents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAssessmentRuns` operation.
    ///
    /// See [`ListAssessmentRuns`](crate::client::fluent_builders::ListAssessmentRuns) for more information about the
    /// operation and its arguments.
    pub fn list_assessment_runs(&self) -> fluent_builders::ListAssessmentRuns<C, M, R> {
        fluent_builders::ListAssessmentRuns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAssessmentTargets` operation.
    ///
    /// See [`ListAssessmentTargets`](crate::client::fluent_builders::ListAssessmentTargets) for more information about the
    /// operation and its arguments.
    pub fn list_assessment_targets(&self) -> fluent_builders::ListAssessmentTargets<C, M, R> {
        fluent_builders::ListAssessmentTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAssessmentTemplates` operation.
    ///
    /// See [`ListAssessmentTemplates`](crate::client::fluent_builders::ListAssessmentTemplates) for more information about the
    /// operation and its arguments.
    pub fn list_assessment_templates(&self) -> fluent_builders::ListAssessmentTemplates<C, M, R> {
        fluent_builders::ListAssessmentTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEventSubscriptions` operation.
    ///
    /// See [`ListEventSubscriptions`](crate::client::fluent_builders::ListEventSubscriptions) for more information about the
    /// operation and its arguments.
    pub fn list_event_subscriptions(&self) -> fluent_builders::ListEventSubscriptions<C, M, R> {
        fluent_builders::ListEventSubscriptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListExclusions` operation.
    ///
    /// See [`ListExclusions`](crate::client::fluent_builders::ListExclusions) for more information about the
    /// operation and its arguments.
    pub fn list_exclusions(&self) -> fluent_builders::ListExclusions<C, M, R> {
        fluent_builders::ListExclusions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFindings` operation.
    ///
    /// See [`ListFindings`](crate::client::fluent_builders::ListFindings) for more information about the
    /// operation and its arguments.
    pub fn list_findings(&self) -> fluent_builders::ListFindings<C, M, R> {
        fluent_builders::ListFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRulesPackages` operation.
    ///
    /// See [`ListRulesPackages`](crate::client::fluent_builders::ListRulesPackages) for more information about the
    /// operation and its arguments.
    pub fn list_rules_packages(&self) -> fluent_builders::ListRulesPackages<C, M, R> {
        fluent_builders::ListRulesPackages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PreviewAgents` operation.
    ///
    /// See [`PreviewAgents`](crate::client::fluent_builders::PreviewAgents) for more information about the
    /// operation and its arguments.
    pub fn preview_agents(&self) -> fluent_builders::PreviewAgents<C, M, R> {
        fluent_builders::PreviewAgents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterCrossAccountAccessRole` operation.
    ///
    /// See [`RegisterCrossAccountAccessRole`](crate::client::fluent_builders::RegisterCrossAccountAccessRole) for more information about the
    /// operation and its arguments.
    pub fn register_cross_account_access_role(
        &self,
    ) -> fluent_builders::RegisterCrossAccountAccessRole<C, M, R> {
        fluent_builders::RegisterCrossAccountAccessRole::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveAttributesFromFindings` operation.
    ///
    /// See [`RemoveAttributesFromFindings`](crate::client::fluent_builders::RemoveAttributesFromFindings) for more information about the
    /// operation and its arguments.
    pub fn remove_attributes_from_findings(
        &self,
    ) -> fluent_builders::RemoveAttributesFromFindings<C, M, R> {
        fluent_builders::RemoveAttributesFromFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetTagsForResource` operation.
    ///
    /// See [`SetTagsForResource`](crate::client::fluent_builders::SetTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn set_tags_for_resource(&self) -> fluent_builders::SetTagsForResource<C, M, R> {
        fluent_builders::SetTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartAssessmentRun` operation.
    ///
    /// See [`StartAssessmentRun`](crate::client::fluent_builders::StartAssessmentRun) for more information about the
    /// operation and its arguments.
    pub fn start_assessment_run(&self) -> fluent_builders::StartAssessmentRun<C, M, R> {
        fluent_builders::StartAssessmentRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopAssessmentRun` operation.
    ///
    /// See [`StopAssessmentRun`](crate::client::fluent_builders::StopAssessmentRun) for more information about the
    /// operation and its arguments.
    pub fn stop_assessment_run(&self) -> fluent_builders::StopAssessmentRun<C, M, R> {
        fluent_builders::StopAssessmentRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SubscribeToEvent` operation.
    ///
    /// See [`SubscribeToEvent`](crate::client::fluent_builders::SubscribeToEvent) for more information about the
    /// operation and its arguments.
    pub fn subscribe_to_event(&self) -> fluent_builders::SubscribeToEvent<C, M, R> {
        fluent_builders::SubscribeToEvent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UnsubscribeFromEvent` operation.
    ///
    /// See [`UnsubscribeFromEvent`](crate::client::fluent_builders::UnsubscribeFromEvent) for more information about the
    /// operation and its arguments.
    pub fn unsubscribe_from_event(&self) -> fluent_builders::UnsubscribeFromEvent<C, M, R> {
        fluent_builders::UnsubscribeFromEvent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAssessmentTarget` operation.
    ///
    /// See [`UpdateAssessmentTarget`](crate::client::fluent_builders::UpdateAssessmentTarget) for more information about the
    /// operation and its arguments.
    pub fn update_assessment_target(&self) -> fluent_builders::UpdateAssessmentTarget<C, M, R> {
        fluent_builders::UpdateAssessmentTarget::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddAttributesToFindings`.
    ///
    /// <p>Assigns attributes (key and value pairs) to the findings that are specified by the
    /// ARNs of the findings.</p>
    #[derive(std::fmt::Debug)]
    pub struct AddAttributesToFindings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_attributes_to_findings_input::Builder,
    }
    impl<C, M, R> AddAttributesToFindings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddAttributesToFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddAttributesToFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::AddAttributesToFindingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddAttributesToFindingsInputOperationOutputAlias,
                crate::output::AddAttributesToFindingsOutput,
                crate::error::AddAttributesToFindingsError,
                crate::input::AddAttributesToFindingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `findingArns`.
        ///
        /// To override the contents of this collection use [`set_finding_arns`](Self::set_finding_arns).
        ///
        /// <p>The ARNs that specify the findings that you want to assign attributes to.</p>
        pub fn finding_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.finding_arns(inp);
            self
        }
        /// <p>The ARNs that specify the findings that you want to assign attributes to.</p>
        pub fn set_finding_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_finding_arns(input);
            self
        }
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The array of attributes that you want to assign to specified findings.</p>
        pub fn attributes(mut self, inp: impl Into<crate::model::Attribute>) -> Self {
            self.inner = self.inner.attributes(inp);
            self
        }
        /// <p>The array of attributes that you want to assign to specified findings.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAssessmentTarget`.
    ///
    /// <p>Creates a new assessment target using the ARN of the resource group that is generated
    /// by <a>CreateResourceGroup</a>. If resourceGroupArn is not specified, all EC2
    /// instances in the current AWS account and region are included in the assessment target. If
    /// the <a href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_slr.html">service-linked role</a> isn’t already registered, this action also creates and
    /// registers a service-linked role to grant Amazon Inspector access to AWS Services needed to
    /// perform security assessments. You can create up to 50 assessment targets per AWS account.
    /// You can run up to 500 concurrent agents per AWS account. For more information, see <a href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html">
    /// Amazon Inspector Assessment Targets</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAssessmentTarget<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_assessment_target_input::Builder,
    }
    impl<C, M, R> CreateAssessmentTarget<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAssessmentTarget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAssessmentTargetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAssessmentTargetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAssessmentTargetInputOperationOutputAlias,
                crate::output::CreateAssessmentTargetOutput,
                crate::error::CreateAssessmentTargetError,
                crate::input::CreateAssessmentTargetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user-defined name that identifies the assessment target that you want to create.
        /// The name must be unique within the AWS account.</p>
        pub fn assessment_target_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_target_name(inp);
            self
        }
        /// <p>The user-defined name that identifies the assessment target that you want to create.
        /// The name must be unique within the AWS account.</p>
        pub fn set_assessment_target_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_target_name(input);
            self
        }
        /// <p>The ARN that specifies the resource group that is used to create the assessment
        /// target. If resourceGroupArn is not specified, all EC2 instances in the current AWS account
        /// and region are included in the assessment target.</p>
        pub fn resource_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_arn(inp);
            self
        }
        /// <p>The ARN that specifies the resource group that is used to create the assessment
        /// target. If resourceGroupArn is not specified, all EC2 instances in the current AWS account
        /// and region are included in the assessment target.</p>
        pub fn set_resource_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAssessmentTemplate`.
    ///
    /// <p>Creates an assessment template for the assessment target that is specified by the ARN
    /// of the assessment target. If the <a href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_slr.html">service-linked role</a> isn’t already registered, this action also creates and
    /// registers a service-linked role to grant Amazon Inspector access to AWS Services needed to
    /// perform security assessments.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAssessmentTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_assessment_template_input::Builder,
    }
    impl<C, M, R> CreateAssessmentTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAssessmentTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAssessmentTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAssessmentTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAssessmentTemplateInputOperationOutputAlias,
                crate::output::CreateAssessmentTemplateOutput,
                crate::error::CreateAssessmentTemplateError,
                crate::input::CreateAssessmentTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN that specifies the assessment target for which you want to create the
        /// assessment template.</p>
        pub fn assessment_target_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_target_arn(inp);
            self
        }
        /// <p>The ARN that specifies the assessment target for which you want to create the
        /// assessment template.</p>
        pub fn set_assessment_target_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_target_arn(input);
            self
        }
        /// <p>The user-defined name that identifies the assessment template that you want to
        /// create. You can create several assessment templates for an assessment target. The names of
        /// the assessment templates that correspond to a particular assessment target must be
        /// unique.</p>
        pub fn assessment_template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_template_name(inp);
            self
        }
        /// <p>The user-defined name that identifies the assessment template that you want to
        /// create. You can create several assessment templates for an assessment target. The names of
        /// the assessment templates that correspond to a particular assessment target must be
        /// unique.</p>
        pub fn set_assessment_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_template_name(input);
            self
        }
        /// <p>The duration of the assessment run in seconds.</p>
        pub fn duration_in_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.duration_in_seconds(inp);
            self
        }
        /// <p>The duration of the assessment run in seconds.</p>
        pub fn set_duration_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_duration_in_seconds(input);
            self
        }
        /// Appends an item to `rulesPackageArns`.
        ///
        /// To override the contents of this collection use [`set_rules_package_arns`](Self::set_rules_package_arns).
        ///
        /// <p>The ARNs that specify the rules packages that you want to attach to the assessment
        /// template.</p>
        pub fn rules_package_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rules_package_arns(inp);
            self
        }
        /// <p>The ARNs that specify the rules packages that you want to attach to the assessment
        /// template.</p>
        pub fn set_rules_package_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_rules_package_arns(input);
            self
        }
        /// Appends an item to `userAttributesForFindings`.
        ///
        /// To override the contents of this collection use [`set_user_attributes_for_findings`](Self::set_user_attributes_for_findings).
        ///
        /// <p>The user-defined attributes that are assigned to every finding that is generated by
        /// the assessment run that uses this assessment template. An attribute is a key and value pair
        /// (an <a>Attribute</a> object). Within an assessment template, each key must be
        /// unique.</p>
        pub fn user_attributes_for_findings(
            mut self,
            inp: impl Into<crate::model::Attribute>,
        ) -> Self {
            self.inner = self.inner.user_attributes_for_findings(inp);
            self
        }
        /// <p>The user-defined attributes that are assigned to every finding that is generated by
        /// the assessment run that uses this assessment template. An attribute is a key and value pair
        /// (an <a>Attribute</a> object). Within an assessment template, each key must be
        /// unique.</p>
        pub fn set_user_attributes_for_findings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Attribute>>,
        ) -> Self {
            self.inner = self.inner.set_user_attributes_for_findings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateExclusionsPreview`.
    ///
    /// <p>Starts the generation of an exclusions preview for the specified assessment template.
    /// The exclusions preview lists the potential exclusions (ExclusionPreview) that Inspector can
    /// detect before it runs the assessment. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateExclusionsPreview<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_exclusions_preview_input::Builder,
    }
    impl<C, M, R> CreateExclusionsPreview<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateExclusionsPreview`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateExclusionsPreviewOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateExclusionsPreviewError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateExclusionsPreviewInputOperationOutputAlias,
                crate::output::CreateExclusionsPreviewOutput,
                crate::error::CreateExclusionsPreviewError,
                crate::input::CreateExclusionsPreviewInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN that specifies the assessment template for which you want to create an
        /// exclusions preview.</p>
        pub fn assessment_template_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_template_arn(inp);
            self
        }
        /// <p>The ARN that specifies the assessment template for which you want to create an
        /// exclusions preview.</p>
        pub fn set_assessment_template_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_template_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResourceGroup`.
    ///
    /// <p>Creates a resource group using the specified set of tags (key and value pairs) that
    /// are used to select the EC2 instances to be included in an Amazon Inspector assessment
    /// target. The created resource group is then used to create an Amazon Inspector assessment
    /// target. For more information, see <a>CreateAssessmentTarget</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateResourceGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_resource_group_input::Builder,
    }
    impl<C, M, R> CreateResourceGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateResourceGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResourceGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResourceGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateResourceGroupInputOperationOutputAlias,
                crate::output::CreateResourceGroupOutput,
                crate::error::CreateResourceGroupError,
                crate::input::CreateResourceGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `resourceGroupTags`.
        ///
        /// To override the contents of this collection use [`set_resource_group_tags`](Self::set_resource_group_tags).
        ///
        /// <p>A collection of keys and an array of possible values,
        /// '[{"key":"key1","values":["Value1","Value2"]},{"key":"Key2","values":["Value3"]}]'.</p>
        /// <p>For example,'[{"key":"Name","values":["TestEC2Instance"]}]'.</p>
        pub fn resource_group_tags(
            mut self,
            inp: impl Into<crate::model::ResourceGroupTag>,
        ) -> Self {
            self.inner = self.inner.resource_group_tags(inp);
            self
        }
        /// <p>A collection of keys and an array of possible values,
        /// '[{"key":"key1","values":["Value1","Value2"]},{"key":"Key2","values":["Value3"]}]'.</p>
        /// <p>For example,'[{"key":"Name","values":["TestEC2Instance"]}]'.</p>
        pub fn set_resource_group_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceGroupTag>>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAssessmentRun`.
    ///
    /// <p>Deletes the assessment run that is specified by the ARN of the assessment
    /// run.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAssessmentRun<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_assessment_run_input::Builder,
    }
    impl<C, M, R> DeleteAssessmentRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAssessmentRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAssessmentRunOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAssessmentRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAssessmentRunInputOperationOutputAlias,
                crate::output::DeleteAssessmentRunOutput,
                crate::error::DeleteAssessmentRunError,
                crate::input::DeleteAssessmentRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN that specifies the assessment run that you want to delete.</p>
        pub fn assessment_run_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_run_arn(inp);
            self
        }
        /// <p>The ARN that specifies the assessment run that you want to delete.</p>
        pub fn set_assessment_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_run_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAssessmentTarget`.
    ///
    /// <p>Deletes the assessment target that is specified by the ARN of the assessment
    /// target.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAssessmentTarget<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_assessment_target_input::Builder,
    }
    impl<C, M, R> DeleteAssessmentTarget<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAssessmentTarget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAssessmentTargetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAssessmentTargetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAssessmentTargetInputOperationOutputAlias,
                crate::output::DeleteAssessmentTargetOutput,
                crate::error::DeleteAssessmentTargetError,
                crate::input::DeleteAssessmentTargetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN that specifies the assessment target that you want to delete.</p>
        pub fn assessment_target_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_target_arn(inp);
            self
        }
        /// <p>The ARN that specifies the assessment target that you want to delete.</p>
        pub fn set_assessment_target_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_target_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAssessmentTemplate`.
    ///
    /// <p>Deletes the assessment template that is specified by the ARN of the assessment
    /// template.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAssessmentTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_assessment_template_input::Builder,
    }
    impl<C, M, R> DeleteAssessmentTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAssessmentTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAssessmentTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAssessmentTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAssessmentTemplateInputOperationOutputAlias,
                crate::output::DeleteAssessmentTemplateOutput,
                crate::error::DeleteAssessmentTemplateError,
                crate::input::DeleteAssessmentTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN that specifies the assessment template that you want to delete.</p>
        pub fn assessment_template_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_template_arn(inp);
            self
        }
        /// <p>The ARN that specifies the assessment template that you want to delete.</p>
        pub fn set_assessment_template_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_template_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAssessmentRuns`.
    ///
    /// <p>Describes the assessment runs that are specified by the ARNs of the assessment
    /// runs.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAssessmentRuns<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_assessment_runs_input::Builder,
    }
    impl<C, M, R> DescribeAssessmentRuns<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAssessmentRuns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAssessmentRunsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAssessmentRunsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAssessmentRunsInputOperationOutputAlias,
                crate::output::DescribeAssessmentRunsOutput,
                crate::error::DescribeAssessmentRunsError,
                crate::input::DescribeAssessmentRunsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `assessmentRunArns`.
        ///
        /// To override the contents of this collection use [`set_assessment_run_arns`](Self::set_assessment_run_arns).
        ///
        /// <p>The ARN that specifies the assessment run that you want to describe.</p>
        pub fn assessment_run_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_run_arns(inp);
            self
        }
        /// <p>The ARN that specifies the assessment run that you want to describe.</p>
        pub fn set_assessment_run_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_assessment_run_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAssessmentTargets`.
    ///
    /// <p>Describes the assessment targets that are specified by the ARNs of the assessment
    /// targets.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAssessmentTargets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_assessment_targets_input::Builder,
    }
    impl<C, M, R> DescribeAssessmentTargets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAssessmentTargets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAssessmentTargetsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAssessmentTargetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAssessmentTargetsInputOperationOutputAlias,
                crate::output::DescribeAssessmentTargetsOutput,
                crate::error::DescribeAssessmentTargetsError,
                crate::input::DescribeAssessmentTargetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `assessmentTargetArns`.
        ///
        /// To override the contents of this collection use [`set_assessment_target_arns`](Self::set_assessment_target_arns).
        ///
        /// <p>The ARNs that specifies the assessment targets that you want to describe.</p>
        pub fn assessment_target_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_target_arns(inp);
            self
        }
        /// <p>The ARNs that specifies the assessment targets that you want to describe.</p>
        pub fn set_assessment_target_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_assessment_target_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAssessmentTemplates`.
    ///
    /// <p>Describes the assessment templates that are specified by the ARNs of the assessment
    /// templates.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAssessmentTemplates<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_assessment_templates_input::Builder,
    }
    impl<C, M, R> DescribeAssessmentTemplates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAssessmentTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAssessmentTemplatesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAssessmentTemplatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAssessmentTemplatesInputOperationOutputAlias,
                crate::output::DescribeAssessmentTemplatesOutput,
                crate::error::DescribeAssessmentTemplatesError,
                crate::input::DescribeAssessmentTemplatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `assessmentTemplateArns`.
        ///
        /// To override the contents of this collection use [`set_assessment_template_arns`](Self::set_assessment_template_arns).
        ///
        #[allow(missing_docs)] // documentation missing in model
        pub fn assessment_template_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_template_arns(inp);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_assessment_template_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_assessment_template_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCrossAccountAccessRole`.
    ///
    /// <p>Describes the IAM role that enables Amazon Inspector to access your AWS
    /// account.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeCrossAccountAccessRole<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_cross_account_access_role_input::Builder,
    }
    impl<C, M, R> DescribeCrossAccountAccessRole<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCrossAccountAccessRole`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCrossAccountAccessRoleOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCrossAccountAccessRoleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCrossAccountAccessRoleInputOperationOutputAlias,
                crate::output::DescribeCrossAccountAccessRoleOutput,
                crate::error::DescribeCrossAccountAccessRoleError,
                crate::input::DescribeCrossAccountAccessRoleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeExclusions`.
    ///
    /// <p>Describes the exclusions that are specified by the exclusions' ARNs.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeExclusions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_exclusions_input::Builder,
    }
    impl<C, M, R> DescribeExclusions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeExclusions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeExclusionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeExclusionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeExclusionsInputOperationOutputAlias,
                crate::output::DescribeExclusionsOutput,
                crate::error::DescribeExclusionsError,
                crate::input::DescribeExclusionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `exclusionArns`.
        ///
        /// To override the contents of this collection use [`set_exclusion_arns`](Self::set_exclusion_arns).
        ///
        /// <p>The list of ARNs that specify the exclusions that you want to describe.</p>
        pub fn exclusion_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.exclusion_arns(inp);
            self
        }
        /// <p>The list of ARNs that specify the exclusions that you want to describe.</p>
        pub fn set_exclusion_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_exclusion_arns(input);
            self
        }
        /// <p>The locale into which you want to translate the exclusion's title, description, and
        /// recommendation.</p>
        pub fn locale(mut self, inp: crate::model::Locale) -> Self {
            self.inner = self.inner.locale(inp);
            self
        }
        /// <p>The locale into which you want to translate the exclusion's title, description, and
        /// recommendation.</p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::Locale>) -> Self {
            self.inner = self.inner.set_locale(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFindings`.
    ///
    /// <p>Describes the findings that are specified by the ARNs of the findings.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeFindings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_findings_input::Builder,
    }
    impl<C, M, R> DescribeFindings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFindingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFindingsInputOperationOutputAlias,
                crate::output::DescribeFindingsOutput,
                crate::error::DescribeFindingsError,
                crate::input::DescribeFindingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `findingArns`.
        ///
        /// To override the contents of this collection use [`set_finding_arns`](Self::set_finding_arns).
        ///
        /// <p>The ARN that specifies the finding that you want to describe.</p>
        pub fn finding_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.finding_arns(inp);
            self
        }
        /// <p>The ARN that specifies the finding that you want to describe.</p>
        pub fn set_finding_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_finding_arns(input);
            self
        }
        /// <p>The locale into which you want to translate a finding description, recommendation,
        /// and the short description that identifies the finding.</p>
        pub fn locale(mut self, inp: crate::model::Locale) -> Self {
            self.inner = self.inner.locale(inp);
            self
        }
        /// <p>The locale into which you want to translate a finding description, recommendation,
        /// and the short description that identifies the finding.</p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::Locale>) -> Self {
            self.inner = self.inner.set_locale(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeResourceGroups`.
    ///
    /// <p>Describes the resource groups that are specified by the ARNs of the resource
    /// groups.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeResourceGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_resource_groups_input::Builder,
    }
    impl<C, M, R> DescribeResourceGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeResourceGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeResourceGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeResourceGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeResourceGroupsInputOperationOutputAlias,
                crate::output::DescribeResourceGroupsOutput,
                crate::error::DescribeResourceGroupsError,
                crate::input::DescribeResourceGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `resourceGroupArns`.
        ///
        /// To override the contents of this collection use [`set_resource_group_arns`](Self::set_resource_group_arns).
        ///
        /// <p>The ARN that specifies the resource group that you want to describe.</p>
        pub fn resource_group_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_arns(inp);
            self
        }
        /// <p>The ARN that specifies the resource group that you want to describe.</p>
        pub fn set_resource_group_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRulesPackages`.
    ///
    /// <p>Describes the rules packages that are specified by the ARNs of the rules
    /// packages.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeRulesPackages<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_rules_packages_input::Builder,
    }
    impl<C, M, R> DescribeRulesPackages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRulesPackages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRulesPackagesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRulesPackagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRulesPackagesInputOperationOutputAlias,
                crate::output::DescribeRulesPackagesOutput,
                crate::error::DescribeRulesPackagesError,
                crate::input::DescribeRulesPackagesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `rulesPackageArns`.
        ///
        /// To override the contents of this collection use [`set_rules_package_arns`](Self::set_rules_package_arns).
        ///
        /// <p>The ARN that specifies the rules package that you want to describe.</p>
        pub fn rules_package_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rules_package_arns(inp);
            self
        }
        /// <p>The ARN that specifies the rules package that you want to describe.</p>
        pub fn set_rules_package_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_rules_package_arns(input);
            self
        }
        /// <p>The locale that you want to translate a rules package description into.</p>
        pub fn locale(mut self, inp: crate::model::Locale) -> Self {
            self.inner = self.inner.locale(inp);
            self
        }
        /// <p>The locale that you want to translate a rules package description into.</p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::Locale>) -> Self {
            self.inner = self.inner.set_locale(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAssessmentReport`.
    ///
    /// <p>Produces an assessment report that includes detailed and comprehensive results of a
    /// specified assessment run. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetAssessmentReport<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_assessment_report_input::Builder,
    }
    impl<C, M, R> GetAssessmentReport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAssessmentReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAssessmentReportOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAssessmentReportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAssessmentReportInputOperationOutputAlias,
                crate::output::GetAssessmentReportOutput,
                crate::error::GetAssessmentReportError,
                crate::input::GetAssessmentReportInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN that specifies the assessment run for which you want to generate a
        /// report.</p>
        pub fn assessment_run_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_run_arn(inp);
            self
        }
        /// <p>The ARN that specifies the assessment run for which you want to generate a
        /// report.</p>
        pub fn set_assessment_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_run_arn(input);
            self
        }
        /// <p>Specifies the file format (html or pdf) of the assessment report that you want to
        /// generate.</p>
        pub fn report_file_format(mut self, inp: crate::model::ReportFileFormat) -> Self {
            self.inner = self.inner.report_file_format(inp);
            self
        }
        /// <p>Specifies the file format (html or pdf) of the assessment report that you want to
        /// generate.</p>
        pub fn set_report_file_format(
            mut self,
            input: std::option::Option<crate::model::ReportFileFormat>,
        ) -> Self {
            self.inner = self.inner.set_report_file_format(input);
            self
        }
        /// <p>Specifies the type of the assessment report that you want to generate. There are two
        /// types of assessment reports: a finding report and a full report. For more information, see
        /// <a href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_reports.html">Assessment Reports</a>. </p>
        pub fn report_type(mut self, inp: crate::model::ReportType) -> Self {
            self.inner = self.inner.report_type(inp);
            self
        }
        /// <p>Specifies the type of the assessment report that you want to generate. There are two
        /// types of assessment reports: a finding report and a full report. For more information, see
        /// <a href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_reports.html">Assessment Reports</a>. </p>
        pub fn set_report_type(
            mut self,
            input: std::option::Option<crate::model::ReportType>,
        ) -> Self {
            self.inner = self.inner.set_report_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetExclusionsPreview`.
    ///
    /// <p>Retrieves the exclusions preview (a list of ExclusionPreview objects) specified by
    /// the preview token. You can obtain the preview token by running the CreateExclusionsPreview
    /// API.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetExclusionsPreview<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_exclusions_preview_input::Builder,
    }
    impl<C, M, R> GetExclusionsPreview<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetExclusionsPreview`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetExclusionsPreviewOutput,
            aws_smithy_http::result::SdkError<crate::error::GetExclusionsPreviewError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetExclusionsPreviewInputOperationOutputAlias,
                crate::output::GetExclusionsPreviewOutput,
                crate::error::GetExclusionsPreviewError,
                crate::input::GetExclusionsPreviewInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN that specifies the assessment template for which the exclusions preview was
        /// requested.</p>
        pub fn assessment_template_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_template_arn(inp);
            self
        }
        /// <p>The ARN that specifies the assessment template for which the exclusions preview was
        /// requested.</p>
        pub fn set_assessment_template_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_template_arn(input);
            self
        }
        /// <p>The unique identifier associated of the exclusions preview.</p>
        pub fn preview_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preview_token(inp);
            self
        }
        /// <p>The unique identifier associated of the exclusions preview.</p>
        pub fn set_preview_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preview_token(input);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the GetExclusionsPreviewRequest action. Subsequent calls to
        /// the action fill nextToken in the request with the value of nextToken from the previous
        /// response to continue listing data.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the GetExclusionsPreviewRequest action. Subsequent calls to
        /// the action fill nextToken in the request with the value of nextToken from the previous
        /// response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 100. The maximum value is 500.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 100. The maximum value is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The locale into which you want to translate the exclusion's title, description, and
        /// recommendation.</p>
        pub fn locale(mut self, inp: crate::model::Locale) -> Self {
            self.inner = self.inner.locale(inp);
            self
        }
        /// <p>The locale into which you want to translate the exclusion's title, description, and
        /// recommendation.</p>
        pub fn set_locale(mut self, input: std::option::Option<crate::model::Locale>) -> Self {
            self.inner = self.inner.set_locale(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTelemetryMetadata`.
    ///
    /// <p>Information about the data that is collected for the specified assessment
    /// run.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetTelemetryMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_telemetry_metadata_input::Builder,
    }
    impl<C, M, R> GetTelemetryMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTelemetryMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTelemetryMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTelemetryMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTelemetryMetadataInputOperationOutputAlias,
                crate::output::GetTelemetryMetadataOutput,
                crate::error::GetTelemetryMetadataError,
                crate::input::GetTelemetryMetadataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN that specifies the assessment run that has the telemetry data that you want
        /// to obtain.</p>
        pub fn assessment_run_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_run_arn(inp);
            self
        }
        /// <p>The ARN that specifies the assessment run that has the telemetry data that you want
        /// to obtain.</p>
        pub fn set_assessment_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_run_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssessmentRunAgents`.
    ///
    /// <p>Lists the agents of the assessment runs that are specified by the ARNs of the
    /// assessment runs.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAssessmentRunAgents<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_assessment_run_agents_input::Builder,
    }
    impl<C, M, R> ListAssessmentRunAgents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAssessmentRunAgents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssessmentRunAgentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssessmentRunAgentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAssessmentRunAgentsInputOperationOutputAlias,
                crate::output::ListAssessmentRunAgentsOutput,
                crate::error::ListAssessmentRunAgentsError,
                crate::input::ListAssessmentRunAgentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN that specifies the assessment run whose agents you want to list.</p>
        pub fn assessment_run_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_run_arn(inp);
            self
        }
        /// <p>The ARN that specifies the assessment run whose agents you want to list.</p>
        pub fn set_assessment_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_run_arn(input);
            self
        }
        /// <p>You can use this parameter to specify a subset of data to be included in the action's
        /// response.</p>
        /// <p>For a record to match a filter, all specified filter attributes must match. When
        /// multiple values are specified for a filter attribute, any of the values can
        /// match.</p>
        pub fn filter(mut self, inp: crate::model::AgentFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>You can use this parameter to specify a subset of data to be included in the action's
        /// response.</p>
        /// <p>For a record to match a filter, all specified filter attributes must match. When
        /// multiple values are specified for a filter attribute, any of the values can
        /// match.</p>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::AgentFilter>) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>ListAssessmentRunAgents</b>
        /// action. Subsequent calls to the action fill <b>nextToken</b> in
        /// the request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>ListAssessmentRunAgents</b>
        /// action. Subsequent calls to the action fill <b>nextToken</b> in
        /// the request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items that you want in
        /// the response. The default value is 10. The maximum value is 500.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items that you want in
        /// the response. The default value is 10. The maximum value is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssessmentRuns`.
    ///
    /// <p>Lists the assessment runs that correspond to the assessment templates that are
    /// specified by the ARNs of the assessment templates.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAssessmentRuns<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_assessment_runs_input::Builder,
    }
    impl<C, M, R> ListAssessmentRuns<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAssessmentRuns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssessmentRunsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssessmentRunsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAssessmentRunsInputOperationOutputAlias,
                crate::output::ListAssessmentRunsOutput,
                crate::error::ListAssessmentRunsError,
                crate::input::ListAssessmentRunsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `assessmentTemplateArns`.
        ///
        /// To override the contents of this collection use [`set_assessment_template_arns`](Self::set_assessment_template_arns).
        ///
        /// <p>The ARNs that specify the assessment templates whose assessment runs you want to
        /// list.</p>
        pub fn assessment_template_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_template_arns(inp);
            self
        }
        /// <p>The ARNs that specify the assessment templates whose assessment runs you want to
        /// list.</p>
        pub fn set_assessment_template_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_assessment_template_arns(input);
            self
        }
        /// <p>You can use this parameter to specify a subset of data to be included in the action's
        /// response.</p>
        /// <p>For a record to match a filter, all specified filter attributes must match. When
        /// multiple values are specified for a filter attribute, any of the values can
        /// match.</p>
        pub fn filter(mut self, inp: crate::model::AssessmentRunFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>You can use this parameter to specify a subset of data to be included in the action's
        /// response.</p>
        /// <p>For a record to match a filter, all specified filter attributes must match. When
        /// multiple values are specified for a filter attribute, any of the values can
        /// match.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::AssessmentRunFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>ListAssessmentRuns</b>
        /// action. Subsequent calls to the action fill <b>nextToken</b> in
        /// the request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>ListAssessmentRuns</b>
        /// action. Subsequent calls to the action fill <b>nextToken</b> in
        /// the request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items that you want in
        /// the response. The default value is 10. The maximum value is 500.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items that you want in
        /// the response. The default value is 10. The maximum value is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssessmentTargets`.
    ///
    /// <p>Lists the ARNs of the assessment targets within this AWS account. For more
    /// information about assessment targets, see <a href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html">Amazon Inspector Assessment
    /// Targets</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAssessmentTargets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_assessment_targets_input::Builder,
    }
    impl<C, M, R> ListAssessmentTargets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAssessmentTargets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssessmentTargetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssessmentTargetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAssessmentTargetsInputOperationOutputAlias,
                crate::output::ListAssessmentTargetsOutput,
                crate::error::ListAssessmentTargetsError,
                crate::input::ListAssessmentTargetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>You can use this parameter to specify a subset of data to be included in the action's
        /// response.</p>
        /// <p>For a record to match a filter, all specified filter attributes must match. When
        /// multiple values are specified for a filter attribute, any of the values can
        /// match.</p>
        pub fn filter(mut self, inp: crate::model::AssessmentTargetFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>You can use this parameter to specify a subset of data to be included in the action's
        /// response.</p>
        /// <p>For a record to match a filter, all specified filter attributes must match. When
        /// multiple values are specified for a filter attribute, any of the values can
        /// match.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::AssessmentTargetFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>ListAssessmentTargets</b>
        /// action. Subsequent calls to the action fill <b>nextToken</b> in
        /// the request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>ListAssessmentTargets</b>
        /// action. Subsequent calls to the action fill <b>nextToken</b> in
        /// the request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 10. The maximum value is 500.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 10. The maximum value is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssessmentTemplates`.
    ///
    /// <p>Lists the assessment templates that correspond to the assessment targets that are
    /// specified by the ARNs of the assessment targets.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAssessmentTemplates<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_assessment_templates_input::Builder,
    }
    impl<C, M, R> ListAssessmentTemplates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAssessmentTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssessmentTemplatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssessmentTemplatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAssessmentTemplatesInputOperationOutputAlias,
                crate::output::ListAssessmentTemplatesOutput,
                crate::error::ListAssessmentTemplatesError,
                crate::input::ListAssessmentTemplatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `assessmentTargetArns`.
        ///
        /// To override the contents of this collection use [`set_assessment_target_arns`](Self::set_assessment_target_arns).
        ///
        /// <p>A list of ARNs that specifies the assessment targets whose assessment templates you
        /// want to list.</p>
        pub fn assessment_target_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_target_arns(inp);
            self
        }
        /// <p>A list of ARNs that specifies the assessment targets whose assessment templates you
        /// want to list.</p>
        pub fn set_assessment_target_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_assessment_target_arns(input);
            self
        }
        /// <p>You can use this parameter to specify a subset of data to be included in the action's
        /// response.</p>
        /// <p>For a record to match a filter, all specified filter attributes must match. When
        /// multiple values are specified for a filter attribute, any of the values can
        /// match.</p>
        pub fn filter(mut self, inp: crate::model::AssessmentTemplateFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>You can use this parameter to specify a subset of data to be included in the action's
        /// response.</p>
        /// <p>For a record to match a filter, all specified filter attributes must match. When
        /// multiple values are specified for a filter attribute, any of the values can
        /// match.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::AssessmentTemplateFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>ListAssessmentTemplates</b>
        /// action. Subsequent calls to the action fill <b>nextToken</b> in
        /// the request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>ListAssessmentTemplates</b>
        /// action. Subsequent calls to the action fill <b>nextToken</b> in
        /// the request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 10. The maximum value is 500.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 10. The maximum value is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEventSubscriptions`.
    ///
    /// <p>Lists all the event subscriptions for the assessment template that is specified by
    /// the ARN of the assessment template. For more information, see <a>SubscribeToEvent</a> and <a>UnsubscribeFromEvent</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListEventSubscriptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_event_subscriptions_input::Builder,
    }
    impl<C, M, R> ListEventSubscriptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEventSubscriptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEventSubscriptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEventSubscriptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEventSubscriptionsInputOperationOutputAlias,
                crate::output::ListEventSubscriptionsOutput,
                crate::error::ListEventSubscriptionsError,
                crate::input::ListEventSubscriptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the assessment template for which you want to list the existing event
        /// subscriptions.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the assessment template for which you want to list the existing event
        /// subscriptions.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>ListEventSubscriptions</b>
        /// action. Subsequent calls to the action fill <b>nextToken</b> in
        /// the request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>ListEventSubscriptions</b>
        /// action. Subsequent calls to the action fill <b>nextToken</b> in
        /// the request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 10. The maximum value is 500.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 10. The maximum value is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListExclusions`.
    ///
    /// <p>List exclusions that are generated by the assessment run.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListExclusions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_exclusions_input::Builder,
    }
    impl<C, M, R> ListExclusions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListExclusions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListExclusionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListExclusionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListExclusionsInputOperationOutputAlias,
                crate::output::ListExclusionsOutput,
                crate::error::ListExclusionsError,
                crate::input::ListExclusionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the assessment run that generated the exclusions that you want to
        /// list.</p>
        pub fn assessment_run_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_run_arn(inp);
            self
        }
        /// <p>The ARN of the assessment run that generated the exclusions that you want to
        /// list.</p>
        pub fn set_assessment_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_run_arn(input);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the ListExclusionsRequest action. Subsequent calls to the
        /// action fill nextToken in the request with the value of nextToken from the previous response
        /// to continue listing data.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the ListExclusionsRequest action. Subsequent calls to the
        /// action fill nextToken in the request with the value of nextToken from the previous response
        /// to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 100. The maximum value is 500.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 100. The maximum value is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFindings`.
    ///
    /// <p>Lists findings that are generated by the assessment runs that are specified by the
    /// ARNs of the assessment runs.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListFindings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_findings_input::Builder,
    }
    impl<C, M, R> ListFindings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFindingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFindingsInputOperationOutputAlias,
                crate::output::ListFindingsOutput,
                crate::error::ListFindingsError,
                crate::input::ListFindingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `assessmentRunArns`.
        ///
        /// To override the contents of this collection use [`set_assessment_run_arns`](Self::set_assessment_run_arns).
        ///
        /// <p>The ARNs of the assessment runs that generate the findings that you want to
        /// list.</p>
        pub fn assessment_run_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_run_arns(inp);
            self
        }
        /// <p>The ARNs of the assessment runs that generate the findings that you want to
        /// list.</p>
        pub fn set_assessment_run_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_assessment_run_arns(input);
            self
        }
        /// <p>You can use this parameter to specify a subset of data to be included in the action's
        /// response.</p>
        /// <p>For a record to match a filter, all specified filter attributes must match. When
        /// multiple values are specified for a filter attribute, any of the values can
        /// match.</p>
        pub fn filter(mut self, inp: crate::model::FindingFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>You can use this parameter to specify a subset of data to be included in the action's
        /// response.</p>
        /// <p>For a record to match a filter, all specified filter attributes must match. When
        /// multiple values are specified for a filter attribute, any of the values can
        /// match.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::FindingFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>ListFindings</b> action.
        /// Subsequent calls to the action fill <b>nextToken</b> in the
        /// request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>ListFindings</b> action.
        /// Subsequent calls to the action fill <b>nextToken</b> in the
        /// request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 10. The maximum value is 500.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 10. The maximum value is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRulesPackages`.
    ///
    /// <p>Lists all available Amazon Inspector rules packages.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRulesPackages<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_rules_packages_input::Builder,
    }
    impl<C, M, R> ListRulesPackages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRulesPackages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRulesPackagesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRulesPackagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRulesPackagesInputOperationOutputAlias,
                crate::output::ListRulesPackagesOutput,
                crate::error::ListRulesPackagesError,
                crate::input::ListRulesPackagesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>ListRulesPackages</b>
        /// action. Subsequent calls to the action fill <b>nextToken</b> in
        /// the request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>ListRulesPackages</b>
        /// action. Subsequent calls to the action fill <b>nextToken</b> in
        /// the request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 10. The maximum value is 500.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 10. The maximum value is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists all tags associated with an assessment template.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN that specifies the assessment template whose tags you want to list.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN that specifies the assessment template whose tags you want to list.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PreviewAgents`.
    ///
    /// <p>Previews the agents installed on the EC2 instances that are part of the specified
    /// assessment target.</p>
    #[derive(std::fmt::Debug)]
    pub struct PreviewAgents<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::preview_agents_input::Builder,
    }
    impl<C, M, R> PreviewAgents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PreviewAgents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PreviewAgentsOutput,
            aws_smithy_http::result::SdkError<crate::error::PreviewAgentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PreviewAgentsInputOperationOutputAlias,
                crate::output::PreviewAgentsOutput,
                crate::error::PreviewAgentsError,
                crate::input::PreviewAgentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the assessment target whose agents you want to preview.</p>
        pub fn preview_agents_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preview_agents_arn(inp);
            self
        }
        /// <p>The ARN of the assessment target whose agents you want to preview.</p>
        pub fn set_preview_agents_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preview_agents_arn(input);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>PreviewAgents</b> action.
        /// Subsequent calls to the action fill <b>nextToken</b> in the
        /// request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter
        /// to null on your first call to the <b>PreviewAgents</b> action.
        /// Subsequent calls to the action fill <b>nextToken</b> in the
        /// request with the value of <b>NextToken</b> from the previous
        /// response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 10. The maximum value is 500.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 10. The maximum value is 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterCrossAccountAccessRole`.
    ///
    /// <p>Registers the IAM role that grants Amazon Inspector access to AWS Services needed to
    /// perform security assessments.</p>
    #[derive(std::fmt::Debug)]
    pub struct RegisterCrossAccountAccessRole<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_cross_account_access_role_input::Builder,
    }
    impl<C, M, R> RegisterCrossAccountAccessRole<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterCrossAccountAccessRole`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterCrossAccountAccessRoleOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterCrossAccountAccessRoleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterCrossAccountAccessRoleInputOperationOutputAlias,
                crate::output::RegisterCrossAccountAccessRoleOutput,
                crate::error::RegisterCrossAccountAccessRoleError,
                crate::input::RegisterCrossAccountAccessRoleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the IAM role that grants Amazon Inspector access to AWS Services needed to
        /// perform security assessments. </p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The ARN of the IAM role that grants Amazon Inspector access to AWS Services needed to
        /// perform security assessments. </p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveAttributesFromFindings`.
    ///
    /// <p>Removes entire attributes (key and value pairs) from the findings that are specified
    /// by the ARNs of the findings where an attribute with the specified key exists.</p>
    #[derive(std::fmt::Debug)]
    pub struct RemoveAttributesFromFindings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_attributes_from_findings_input::Builder,
    }
    impl<C, M, R> RemoveAttributesFromFindings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveAttributesFromFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveAttributesFromFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveAttributesFromFindingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveAttributesFromFindingsInputOperationOutputAlias,
                crate::output::RemoveAttributesFromFindingsOutput,
                crate::error::RemoveAttributesFromFindingsError,
                crate::input::RemoveAttributesFromFindingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `findingArns`.
        ///
        /// To override the contents of this collection use [`set_finding_arns`](Self::set_finding_arns).
        ///
        /// <p>The ARNs that specify the findings that you want to remove attributes from.</p>
        pub fn finding_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.finding_arns(inp);
            self
        }
        /// <p>The ARNs that specify the findings that you want to remove attributes from.</p>
        pub fn set_finding_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_finding_arns(input);
            self
        }
        /// Appends an item to `attributeKeys`.
        ///
        /// To override the contents of this collection use [`set_attribute_keys`](Self::set_attribute_keys).
        ///
        /// <p>The array of attribute keys that you want to remove from specified
        /// findings.</p>
        pub fn attribute_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attribute_keys(inp);
            self
        }
        /// <p>The array of attribute keys that you want to remove from specified
        /// findings.</p>
        pub fn set_attribute_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_attribute_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetTagsForResource`.
    ///
    /// <p>Sets tags (key and value pairs) to the assessment template that is specified by the
    /// ARN of the assessment template.</p>
    #[derive(std::fmt::Debug)]
    pub struct SetTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_tags_for_resource_input::Builder,
    }
    impl<C, M, R> SetTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::SetTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetTagsForResourceInputOperationOutputAlias,
                crate::output::SetTagsForResourceOutput,
                crate::error::SetTagsForResourceError,
                crate::input::SetTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the assessment template that you want to set tags to.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the assessment template that you want to set tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of key and value pairs that you want to set to the assessment
        /// template.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A collection of key and value pairs that you want to set to the assessment
        /// template.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartAssessmentRun`.
    ///
    /// <p>Starts the assessment run specified by the ARN of the assessment template. For this
    /// API to function properly, you must not exceed the limit of running up to 500 concurrent
    /// agents per AWS account.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartAssessmentRun<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_assessment_run_input::Builder,
    }
    impl<C, M, R> StartAssessmentRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartAssessmentRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartAssessmentRunOutput,
            aws_smithy_http::result::SdkError<crate::error::StartAssessmentRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartAssessmentRunInputOperationOutputAlias,
                crate::output::StartAssessmentRunOutput,
                crate::error::StartAssessmentRunError,
                crate::input::StartAssessmentRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the assessment template of the assessment run that you want to
        /// start.</p>
        pub fn assessment_template_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_template_arn(inp);
            self
        }
        /// <p>The ARN of the assessment template of the assessment run that you want to
        /// start.</p>
        pub fn set_assessment_template_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_template_arn(input);
            self
        }
        /// <p>You can specify the name for the assessment run. The name must be unique for the
        /// assessment template whose ARN is used to start the assessment run.</p>
        pub fn assessment_run_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_run_name(inp);
            self
        }
        /// <p>You can specify the name for the assessment run. The name must be unique for the
        /// assessment template whose ARN is used to start the assessment run.</p>
        pub fn set_assessment_run_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_run_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopAssessmentRun`.
    ///
    /// <p>Stops the assessment run that is specified by the ARN of the assessment
    /// run.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopAssessmentRun<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_assessment_run_input::Builder,
    }
    impl<C, M, R> StopAssessmentRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopAssessmentRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopAssessmentRunOutput,
            aws_smithy_http::result::SdkError<crate::error::StopAssessmentRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopAssessmentRunInputOperationOutputAlias,
                crate::output::StopAssessmentRunOutput,
                crate::error::StopAssessmentRunError,
                crate::input::StopAssessmentRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the assessment run that you want to stop.</p>
        pub fn assessment_run_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_run_arn(inp);
            self
        }
        /// <p>The ARN of the assessment run that you want to stop.</p>
        pub fn set_assessment_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_run_arn(input);
            self
        }
        /// <p>An input option that can be set to either START_EVALUATION or SKIP_EVALUATION.
        /// START_EVALUATION (the default value), stops the AWS agent from collecting data and begins
        /// the results evaluation and the findings generation process. SKIP_EVALUATION cancels the
        /// assessment run immediately, after which no findings are generated.</p>
        pub fn stop_action(mut self, inp: crate::model::StopAction) -> Self {
            self.inner = self.inner.stop_action(inp);
            self
        }
        /// <p>An input option that can be set to either START_EVALUATION or SKIP_EVALUATION.
        /// START_EVALUATION (the default value), stops the AWS agent from collecting data and begins
        /// the results evaluation and the findings generation process. SKIP_EVALUATION cancels the
        /// assessment run immediately, after which no findings are generated.</p>
        pub fn set_stop_action(
            mut self,
            input: std::option::Option<crate::model::StopAction>,
        ) -> Self {
            self.inner = self.inner.set_stop_action(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SubscribeToEvent`.
    ///
    /// <p>Enables the process of sending Amazon Simple Notification Service (SNS) notifications
    /// about a specified event to a specified SNS topic.</p>
    #[derive(std::fmt::Debug)]
    pub struct SubscribeToEvent<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::subscribe_to_event_input::Builder,
    }
    impl<C, M, R> SubscribeToEvent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SubscribeToEvent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SubscribeToEventOutput,
            aws_smithy_http::result::SdkError<crate::error::SubscribeToEventError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SubscribeToEventInputOperationOutputAlias,
                crate::output::SubscribeToEventOutput,
                crate::error::SubscribeToEventError,
                crate::input::SubscribeToEventInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the assessment template that is used during the event for which you want
        /// to receive SNS notifications.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the assessment template that is used during the event for which you want
        /// to receive SNS notifications.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The event for which you want to receive SNS notifications.</p>
        pub fn event(mut self, inp: crate::model::InspectorEvent) -> Self {
            self.inner = self.inner.event(inp);
            self
        }
        /// <p>The event for which you want to receive SNS notifications.</p>
        pub fn set_event(
            mut self,
            input: std::option::Option<crate::model::InspectorEvent>,
        ) -> Self {
            self.inner = self.inner.set_event(input);
            self
        }
        /// <p>The ARN of the SNS topic to which the SNS notifications are sent.</p>
        pub fn topic_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.topic_arn(inp);
            self
        }
        /// <p>The ARN of the SNS topic to which the SNS notifications are sent.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_topic_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UnsubscribeFromEvent`.
    ///
    /// <p>Disables the process of sending Amazon Simple Notification Service (SNS)
    /// notifications about a specified event to a specified SNS topic.</p>
    #[derive(std::fmt::Debug)]
    pub struct UnsubscribeFromEvent<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::unsubscribe_from_event_input::Builder,
    }
    impl<C, M, R> UnsubscribeFromEvent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UnsubscribeFromEvent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UnsubscribeFromEventOutput,
            aws_smithy_http::result::SdkError<crate::error::UnsubscribeFromEventError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UnsubscribeFromEventInputOperationOutputAlias,
                crate::output::UnsubscribeFromEventOutput,
                crate::error::UnsubscribeFromEventError,
                crate::input::UnsubscribeFromEventInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the assessment template that is used during the event for which you want
        /// to stop receiving SNS notifications.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the assessment template that is used during the event for which you want
        /// to stop receiving SNS notifications.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The event for which you want to stop receiving SNS notifications.</p>
        pub fn event(mut self, inp: crate::model::InspectorEvent) -> Self {
            self.inner = self.inner.event(inp);
            self
        }
        /// <p>The event for which you want to stop receiving SNS notifications.</p>
        pub fn set_event(
            mut self,
            input: std::option::Option<crate::model::InspectorEvent>,
        ) -> Self {
            self.inner = self.inner.set_event(input);
            self
        }
        /// <p>The ARN of the SNS topic to which SNS notifications are sent.</p>
        pub fn topic_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.topic_arn(inp);
            self
        }
        /// <p>The ARN of the SNS topic to which SNS notifications are sent.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_topic_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAssessmentTarget`.
    ///
    /// <p>Updates the assessment target that is specified by the ARN of the assessment
    /// target.</p>
    /// <p>If resourceGroupArn is not specified, all EC2 instances in the current AWS account
    /// and region are included in the assessment target.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAssessmentTarget<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_assessment_target_input::Builder,
    }
    impl<C, M, R> UpdateAssessmentTarget<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAssessmentTarget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAssessmentTargetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAssessmentTargetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAssessmentTargetInputOperationOutputAlias,
                crate::output::UpdateAssessmentTargetOutput,
                crate::error::UpdateAssessmentTargetError,
                crate::input::UpdateAssessmentTargetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the assessment target that you want to update.</p>
        pub fn assessment_target_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_target_arn(inp);
            self
        }
        /// <p>The ARN of the assessment target that you want to update.</p>
        pub fn set_assessment_target_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_target_arn(input);
            self
        }
        /// <p>The name of the assessment target that you want to update.</p>
        pub fn assessment_target_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_target_name(inp);
            self
        }
        /// <p>The name of the assessment target that you want to update.</p>
        pub fn set_assessment_target_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_target_name(input);
            self
        }
        /// <p>The ARN of the resource group that is used to specify the new resource group to
        /// associate with the assessment target.</p>
        pub fn resource_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_group_arn(inp);
            self
        }
        /// <p>The ARN of the resource group that is used to specify the new resource group to
        /// associate with the assessment target.</p>
        pub fn set_resource_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_group_arn(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
