// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CancelImageCreation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_image_creation`](crate::client::Client::cancel_image_creation).
///
/// See [`crate::client::fluent_builders::CancelImageCreation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelImageCreation {
    _private: (),
}
impl CancelImageCreation {
    /// Creates a new builder-style object to manufacture [`CancelImageCreationInput`](crate::input::CancelImageCreationInput)
    pub fn builder() -> crate::input::cancel_image_creation_input::Builder {
        crate::input::cancel_image_creation_input::Builder::default()
    }
    /// Creates a new `CancelImageCreation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelImageCreation {
    type Output = std::result::Result<
        crate::output::CancelImageCreationOutput,
        crate::error::CancelImageCreationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_image_creation_error(response)
        } else {
            crate::operation_deser::parse_cancel_image_creation_response(response)
        }
    }
}

/// Operation shape for `CreateComponent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_component`](crate::client::Client::create_component).
///
/// See [`crate::client::fluent_builders::CreateComponent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateComponent {
    _private: (),
}
impl CreateComponent {
    /// Creates a new builder-style object to manufacture [`CreateComponentInput`](crate::input::CreateComponentInput)
    pub fn builder() -> crate::input::create_component_input::Builder {
        crate::input::create_component_input::Builder::default()
    }
    /// Creates a new `CreateComponent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateComponent {
    type Output = std::result::Result<
        crate::output::CreateComponentOutput,
        crate::error::CreateComponentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_component_error(response)
        } else {
            crate::operation_deser::parse_create_component_response(response)
        }
    }
}

/// Operation shape for `CreateContainerRecipe`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_container_recipe`](crate::client::Client::create_container_recipe).
///
/// See [`crate::client::fluent_builders::CreateContainerRecipe`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateContainerRecipe {
    _private: (),
}
impl CreateContainerRecipe {
    /// Creates a new builder-style object to manufacture [`CreateContainerRecipeInput`](crate::input::CreateContainerRecipeInput)
    pub fn builder() -> crate::input::create_container_recipe_input::Builder {
        crate::input::create_container_recipe_input::Builder::default()
    }
    /// Creates a new `CreateContainerRecipe` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateContainerRecipe {
    type Output = std::result::Result<
        crate::output::CreateContainerRecipeOutput,
        crate::error::CreateContainerRecipeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_container_recipe_error(response)
        } else {
            crate::operation_deser::parse_create_container_recipe_response(response)
        }
    }
}

/// Operation shape for `CreateDistributionConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_distribution_configuration`](crate::client::Client::create_distribution_configuration).
///
/// See [`crate::client::fluent_builders::CreateDistributionConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDistributionConfiguration {
    _private: (),
}
impl CreateDistributionConfiguration {
    /// Creates a new builder-style object to manufacture [`CreateDistributionConfigurationInput`](crate::input::CreateDistributionConfigurationInput)
    pub fn builder() -> crate::input::create_distribution_configuration_input::Builder {
        crate::input::create_distribution_configuration_input::Builder::default()
    }
    /// Creates a new `CreateDistributionConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDistributionConfiguration {
    type Output = std::result::Result<
        crate::output::CreateDistributionConfigurationOutput,
        crate::error::CreateDistributionConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_distribution_configuration_error(response)
        } else {
            crate::operation_deser::parse_create_distribution_configuration_response(response)
        }
    }
}

/// Operation shape for `CreateImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_image`](crate::client::Client::create_image).
///
/// See [`crate::client::fluent_builders::CreateImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateImage {
    _private: (),
}
impl CreateImage {
    /// Creates a new builder-style object to manufacture [`CreateImageInput`](crate::input::CreateImageInput)
    pub fn builder() -> crate::input::create_image_input::Builder {
        crate::input::create_image_input::Builder::default()
    }
    /// Creates a new `CreateImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateImage {
    type Output =
        std::result::Result<crate::output::CreateImageOutput, crate::error::CreateImageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_image_error(response)
        } else {
            crate::operation_deser::parse_create_image_response(response)
        }
    }
}

/// Operation shape for `CreateImagePipeline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_image_pipeline`](crate::client::Client::create_image_pipeline).
///
/// See [`crate::client::fluent_builders::CreateImagePipeline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateImagePipeline {
    _private: (),
}
impl CreateImagePipeline {
    /// Creates a new builder-style object to manufacture [`CreateImagePipelineInput`](crate::input::CreateImagePipelineInput)
    pub fn builder() -> crate::input::create_image_pipeline_input::Builder {
        crate::input::create_image_pipeline_input::Builder::default()
    }
    /// Creates a new `CreateImagePipeline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateImagePipeline {
    type Output = std::result::Result<
        crate::output::CreateImagePipelineOutput,
        crate::error::CreateImagePipelineError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_image_pipeline_error(response)
        } else {
            crate::operation_deser::parse_create_image_pipeline_response(response)
        }
    }
}

/// Operation shape for `CreateImageRecipe`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_image_recipe`](crate::client::Client::create_image_recipe).
///
/// See [`crate::client::fluent_builders::CreateImageRecipe`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateImageRecipe {
    _private: (),
}
impl CreateImageRecipe {
    /// Creates a new builder-style object to manufacture [`CreateImageRecipeInput`](crate::input::CreateImageRecipeInput)
    pub fn builder() -> crate::input::create_image_recipe_input::Builder {
        crate::input::create_image_recipe_input::Builder::default()
    }
    /// Creates a new `CreateImageRecipe` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateImageRecipe {
    type Output = std::result::Result<
        crate::output::CreateImageRecipeOutput,
        crate::error::CreateImageRecipeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_image_recipe_error(response)
        } else {
            crate::operation_deser::parse_create_image_recipe_response(response)
        }
    }
}

/// Operation shape for `CreateInfrastructureConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_infrastructure_configuration`](crate::client::Client::create_infrastructure_configuration).
///
/// See [`crate::client::fluent_builders::CreateInfrastructureConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateInfrastructureConfiguration {
    _private: (),
}
impl CreateInfrastructureConfiguration {
    /// Creates a new builder-style object to manufacture [`CreateInfrastructureConfigurationInput`](crate::input::CreateInfrastructureConfigurationInput)
    pub fn builder() -> crate::input::create_infrastructure_configuration_input::Builder {
        crate::input::create_infrastructure_configuration_input::Builder::default()
    }
    /// Creates a new `CreateInfrastructureConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateInfrastructureConfiguration {
    type Output = std::result::Result<
        crate::output::CreateInfrastructureConfigurationOutput,
        crate::error::CreateInfrastructureConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_infrastructure_configuration_error(response)
        } else {
            crate::operation_deser::parse_create_infrastructure_configuration_response(response)
        }
    }
}

/// Operation shape for `DeleteComponent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_component`](crate::client::Client::delete_component).
///
/// See [`crate::client::fluent_builders::DeleteComponent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteComponent {
    _private: (),
}
impl DeleteComponent {
    /// Creates a new builder-style object to manufacture [`DeleteComponentInput`](crate::input::DeleteComponentInput)
    pub fn builder() -> crate::input::delete_component_input::Builder {
        crate::input::delete_component_input::Builder::default()
    }
    /// Creates a new `DeleteComponent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteComponent {
    type Output = std::result::Result<
        crate::output::DeleteComponentOutput,
        crate::error::DeleteComponentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_component_error(response)
        } else {
            crate::operation_deser::parse_delete_component_response(response)
        }
    }
}

/// Operation shape for `DeleteContainerRecipe`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_container_recipe`](crate::client::Client::delete_container_recipe).
///
/// See [`crate::client::fluent_builders::DeleteContainerRecipe`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteContainerRecipe {
    _private: (),
}
impl DeleteContainerRecipe {
    /// Creates a new builder-style object to manufacture [`DeleteContainerRecipeInput`](crate::input::DeleteContainerRecipeInput)
    pub fn builder() -> crate::input::delete_container_recipe_input::Builder {
        crate::input::delete_container_recipe_input::Builder::default()
    }
    /// Creates a new `DeleteContainerRecipe` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteContainerRecipe {
    type Output = std::result::Result<
        crate::output::DeleteContainerRecipeOutput,
        crate::error::DeleteContainerRecipeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_container_recipe_error(response)
        } else {
            crate::operation_deser::parse_delete_container_recipe_response(response)
        }
    }
}

/// Operation shape for `DeleteDistributionConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_distribution_configuration`](crate::client::Client::delete_distribution_configuration).
///
/// See [`crate::client::fluent_builders::DeleteDistributionConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDistributionConfiguration {
    _private: (),
}
impl DeleteDistributionConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteDistributionConfigurationInput`](crate::input::DeleteDistributionConfigurationInput)
    pub fn builder() -> crate::input::delete_distribution_configuration_input::Builder {
        crate::input::delete_distribution_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteDistributionConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDistributionConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteDistributionConfigurationOutput,
        crate::error::DeleteDistributionConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_distribution_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_distribution_configuration_response(response)
        }
    }
}

/// Operation shape for `DeleteImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_image`](crate::client::Client::delete_image).
///
/// See [`crate::client::fluent_builders::DeleteImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteImage {
    _private: (),
}
impl DeleteImage {
    /// Creates a new builder-style object to manufacture [`DeleteImageInput`](crate::input::DeleteImageInput)
    pub fn builder() -> crate::input::delete_image_input::Builder {
        crate::input::delete_image_input::Builder::default()
    }
    /// Creates a new `DeleteImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteImage {
    type Output =
        std::result::Result<crate::output::DeleteImageOutput, crate::error::DeleteImageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_image_error(response)
        } else {
            crate::operation_deser::parse_delete_image_response(response)
        }
    }
}

/// Operation shape for `DeleteImagePipeline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_image_pipeline`](crate::client::Client::delete_image_pipeline).
///
/// See [`crate::client::fluent_builders::DeleteImagePipeline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteImagePipeline {
    _private: (),
}
impl DeleteImagePipeline {
    /// Creates a new builder-style object to manufacture [`DeleteImagePipelineInput`](crate::input::DeleteImagePipelineInput)
    pub fn builder() -> crate::input::delete_image_pipeline_input::Builder {
        crate::input::delete_image_pipeline_input::Builder::default()
    }
    /// Creates a new `DeleteImagePipeline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteImagePipeline {
    type Output = std::result::Result<
        crate::output::DeleteImagePipelineOutput,
        crate::error::DeleteImagePipelineError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_image_pipeline_error(response)
        } else {
            crate::operation_deser::parse_delete_image_pipeline_response(response)
        }
    }
}

/// Operation shape for `DeleteImageRecipe`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_image_recipe`](crate::client::Client::delete_image_recipe).
///
/// See [`crate::client::fluent_builders::DeleteImageRecipe`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteImageRecipe {
    _private: (),
}
impl DeleteImageRecipe {
    /// Creates a new builder-style object to manufacture [`DeleteImageRecipeInput`](crate::input::DeleteImageRecipeInput)
    pub fn builder() -> crate::input::delete_image_recipe_input::Builder {
        crate::input::delete_image_recipe_input::Builder::default()
    }
    /// Creates a new `DeleteImageRecipe` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteImageRecipe {
    type Output = std::result::Result<
        crate::output::DeleteImageRecipeOutput,
        crate::error::DeleteImageRecipeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_image_recipe_error(response)
        } else {
            crate::operation_deser::parse_delete_image_recipe_response(response)
        }
    }
}

/// Operation shape for `DeleteInfrastructureConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_infrastructure_configuration`](crate::client::Client::delete_infrastructure_configuration).
///
/// See [`crate::client::fluent_builders::DeleteInfrastructureConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteInfrastructureConfiguration {
    _private: (),
}
impl DeleteInfrastructureConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteInfrastructureConfigurationInput`](crate::input::DeleteInfrastructureConfigurationInput)
    pub fn builder() -> crate::input::delete_infrastructure_configuration_input::Builder {
        crate::input::delete_infrastructure_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteInfrastructureConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteInfrastructureConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteInfrastructureConfigurationOutput,
        crate::error::DeleteInfrastructureConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_infrastructure_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_infrastructure_configuration_response(response)
        }
    }
}

/// Operation shape for `GetComponent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_component`](crate::client::Client::get_component).
///
/// See [`crate::client::fluent_builders::GetComponent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetComponent {
    _private: (),
}
impl GetComponent {
    /// Creates a new builder-style object to manufacture [`GetComponentInput`](crate::input::GetComponentInput)
    pub fn builder() -> crate::input::get_component_input::Builder {
        crate::input::get_component_input::Builder::default()
    }
    /// Creates a new `GetComponent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetComponent {
    type Output =
        std::result::Result<crate::output::GetComponentOutput, crate::error::GetComponentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_component_error(response)
        } else {
            crate::operation_deser::parse_get_component_response(response)
        }
    }
}

/// Operation shape for `GetComponentPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_component_policy`](crate::client::Client::get_component_policy).
///
/// See [`crate::client::fluent_builders::GetComponentPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetComponentPolicy {
    _private: (),
}
impl GetComponentPolicy {
    /// Creates a new builder-style object to manufacture [`GetComponentPolicyInput`](crate::input::GetComponentPolicyInput)
    pub fn builder() -> crate::input::get_component_policy_input::Builder {
        crate::input::get_component_policy_input::Builder::default()
    }
    /// Creates a new `GetComponentPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetComponentPolicy {
    type Output = std::result::Result<
        crate::output::GetComponentPolicyOutput,
        crate::error::GetComponentPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_component_policy_error(response)
        } else {
            crate::operation_deser::parse_get_component_policy_response(response)
        }
    }
}

/// Operation shape for `GetContainerRecipe`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_container_recipe`](crate::client::Client::get_container_recipe).
///
/// See [`crate::client::fluent_builders::GetContainerRecipe`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetContainerRecipe {
    _private: (),
}
impl GetContainerRecipe {
    /// Creates a new builder-style object to manufacture [`GetContainerRecipeInput`](crate::input::GetContainerRecipeInput)
    pub fn builder() -> crate::input::get_container_recipe_input::Builder {
        crate::input::get_container_recipe_input::Builder::default()
    }
    /// Creates a new `GetContainerRecipe` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetContainerRecipe {
    type Output = std::result::Result<
        crate::output::GetContainerRecipeOutput,
        crate::error::GetContainerRecipeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_container_recipe_error(response)
        } else {
            crate::operation_deser::parse_get_container_recipe_response(response)
        }
    }
}

/// Operation shape for `GetContainerRecipePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_container_recipe_policy`](crate::client::Client::get_container_recipe_policy).
///
/// See [`crate::client::fluent_builders::GetContainerRecipePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetContainerRecipePolicy {
    _private: (),
}
impl GetContainerRecipePolicy {
    /// Creates a new builder-style object to manufacture [`GetContainerRecipePolicyInput`](crate::input::GetContainerRecipePolicyInput)
    pub fn builder() -> crate::input::get_container_recipe_policy_input::Builder {
        crate::input::get_container_recipe_policy_input::Builder::default()
    }
    /// Creates a new `GetContainerRecipePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetContainerRecipePolicy {
    type Output = std::result::Result<
        crate::output::GetContainerRecipePolicyOutput,
        crate::error::GetContainerRecipePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_container_recipe_policy_error(response)
        } else {
            crate::operation_deser::parse_get_container_recipe_policy_response(response)
        }
    }
}

/// Operation shape for `GetDistributionConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_distribution_configuration`](crate::client::Client::get_distribution_configuration).
///
/// See [`crate::client::fluent_builders::GetDistributionConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDistributionConfiguration {
    _private: (),
}
impl GetDistributionConfiguration {
    /// Creates a new builder-style object to manufacture [`GetDistributionConfigurationInput`](crate::input::GetDistributionConfigurationInput)
    pub fn builder() -> crate::input::get_distribution_configuration_input::Builder {
        crate::input::get_distribution_configuration_input::Builder::default()
    }
    /// Creates a new `GetDistributionConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDistributionConfiguration {
    type Output = std::result::Result<
        crate::output::GetDistributionConfigurationOutput,
        crate::error::GetDistributionConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_distribution_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_distribution_configuration_response(response)
        }
    }
}

/// Operation shape for `GetImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_image`](crate::client::Client::get_image).
///
/// See [`crate::client::fluent_builders::GetImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetImage {
    _private: (),
}
impl GetImage {
    /// Creates a new builder-style object to manufacture [`GetImageInput`](crate::input::GetImageInput)
    pub fn builder() -> crate::input::get_image_input::Builder {
        crate::input::get_image_input::Builder::default()
    }
    /// Creates a new `GetImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetImage {
    type Output = std::result::Result<crate::output::GetImageOutput, crate::error::GetImageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_image_error(response)
        } else {
            crate::operation_deser::parse_get_image_response(response)
        }
    }
}

/// Operation shape for `GetImagePipeline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_image_pipeline`](crate::client::Client::get_image_pipeline).
///
/// See [`crate::client::fluent_builders::GetImagePipeline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetImagePipeline {
    _private: (),
}
impl GetImagePipeline {
    /// Creates a new builder-style object to manufacture [`GetImagePipelineInput`](crate::input::GetImagePipelineInput)
    pub fn builder() -> crate::input::get_image_pipeline_input::Builder {
        crate::input::get_image_pipeline_input::Builder::default()
    }
    /// Creates a new `GetImagePipeline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetImagePipeline {
    type Output = std::result::Result<
        crate::output::GetImagePipelineOutput,
        crate::error::GetImagePipelineError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_image_pipeline_error(response)
        } else {
            crate::operation_deser::parse_get_image_pipeline_response(response)
        }
    }
}

/// Operation shape for `GetImagePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_image_policy`](crate::client::Client::get_image_policy).
///
/// See [`crate::client::fluent_builders::GetImagePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetImagePolicy {
    _private: (),
}
impl GetImagePolicy {
    /// Creates a new builder-style object to manufacture [`GetImagePolicyInput`](crate::input::GetImagePolicyInput)
    pub fn builder() -> crate::input::get_image_policy_input::Builder {
        crate::input::get_image_policy_input::Builder::default()
    }
    /// Creates a new `GetImagePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetImagePolicy {
    type Output =
        std::result::Result<crate::output::GetImagePolicyOutput, crate::error::GetImagePolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_image_policy_error(response)
        } else {
            crate::operation_deser::parse_get_image_policy_response(response)
        }
    }
}

/// Operation shape for `GetImageRecipe`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_image_recipe`](crate::client::Client::get_image_recipe).
///
/// See [`crate::client::fluent_builders::GetImageRecipe`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetImageRecipe {
    _private: (),
}
impl GetImageRecipe {
    /// Creates a new builder-style object to manufacture [`GetImageRecipeInput`](crate::input::GetImageRecipeInput)
    pub fn builder() -> crate::input::get_image_recipe_input::Builder {
        crate::input::get_image_recipe_input::Builder::default()
    }
    /// Creates a new `GetImageRecipe` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetImageRecipe {
    type Output =
        std::result::Result<crate::output::GetImageRecipeOutput, crate::error::GetImageRecipeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_image_recipe_error(response)
        } else {
            crate::operation_deser::parse_get_image_recipe_response(response)
        }
    }
}

/// Operation shape for `GetImageRecipePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_image_recipe_policy`](crate::client::Client::get_image_recipe_policy).
///
/// See [`crate::client::fluent_builders::GetImageRecipePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetImageRecipePolicy {
    _private: (),
}
impl GetImageRecipePolicy {
    /// Creates a new builder-style object to manufacture [`GetImageRecipePolicyInput`](crate::input::GetImageRecipePolicyInput)
    pub fn builder() -> crate::input::get_image_recipe_policy_input::Builder {
        crate::input::get_image_recipe_policy_input::Builder::default()
    }
    /// Creates a new `GetImageRecipePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetImageRecipePolicy {
    type Output = std::result::Result<
        crate::output::GetImageRecipePolicyOutput,
        crate::error::GetImageRecipePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_image_recipe_policy_error(response)
        } else {
            crate::operation_deser::parse_get_image_recipe_policy_response(response)
        }
    }
}

/// Operation shape for `GetInfrastructureConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_infrastructure_configuration`](crate::client::Client::get_infrastructure_configuration).
///
/// See [`crate::client::fluent_builders::GetInfrastructureConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetInfrastructureConfiguration {
    _private: (),
}
impl GetInfrastructureConfiguration {
    /// Creates a new builder-style object to manufacture [`GetInfrastructureConfigurationInput`](crate::input::GetInfrastructureConfigurationInput)
    pub fn builder() -> crate::input::get_infrastructure_configuration_input::Builder {
        crate::input::get_infrastructure_configuration_input::Builder::default()
    }
    /// Creates a new `GetInfrastructureConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetInfrastructureConfiguration {
    type Output = std::result::Result<
        crate::output::GetInfrastructureConfigurationOutput,
        crate::error::GetInfrastructureConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_infrastructure_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_infrastructure_configuration_response(response)
        }
    }
}

/// Operation shape for `ImportComponent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`import_component`](crate::client::Client::import_component).
///
/// See [`crate::client::fluent_builders::ImportComponent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ImportComponent {
    _private: (),
}
impl ImportComponent {
    /// Creates a new builder-style object to manufacture [`ImportComponentInput`](crate::input::ImportComponentInput)
    pub fn builder() -> crate::input::import_component_input::Builder {
        crate::input::import_component_input::Builder::default()
    }
    /// Creates a new `ImportComponent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ImportComponent {
    type Output = std::result::Result<
        crate::output::ImportComponentOutput,
        crate::error::ImportComponentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_import_component_error(response)
        } else {
            crate::operation_deser::parse_import_component_response(response)
        }
    }
}

/// Operation shape for `ImportVmImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`import_vm_image`](crate::client::Client::import_vm_image).
///
/// See [`crate::client::fluent_builders::ImportVmImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ImportVmImage {
    _private: (),
}
impl ImportVmImage {
    /// Creates a new builder-style object to manufacture [`ImportVmImageInput`](crate::input::ImportVmImageInput)
    pub fn builder() -> crate::input::import_vm_image_input::Builder {
        crate::input::import_vm_image_input::Builder::default()
    }
    /// Creates a new `ImportVmImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ImportVmImage {
    type Output =
        std::result::Result<crate::output::ImportVmImageOutput, crate::error::ImportVmImageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_import_vm_image_error(response)
        } else {
            crate::operation_deser::parse_import_vm_image_response(response)
        }
    }
}

/// Operation shape for `ListComponentBuildVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_component_build_versions`](crate::client::Client::list_component_build_versions).
///
/// See [`crate::client::fluent_builders::ListComponentBuildVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListComponentBuildVersions {
    _private: (),
}
impl ListComponentBuildVersions {
    /// Creates a new builder-style object to manufacture [`ListComponentBuildVersionsInput`](crate::input::ListComponentBuildVersionsInput)
    pub fn builder() -> crate::input::list_component_build_versions_input::Builder {
        crate::input::list_component_build_versions_input::Builder::default()
    }
    /// Creates a new `ListComponentBuildVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListComponentBuildVersions {
    type Output = std::result::Result<
        crate::output::ListComponentBuildVersionsOutput,
        crate::error::ListComponentBuildVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_component_build_versions_error(response)
        } else {
            crate::operation_deser::parse_list_component_build_versions_response(response)
        }
    }
}

/// Operation shape for `ListComponents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_components`](crate::client::Client::list_components).
///
/// See [`crate::client::fluent_builders::ListComponents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListComponents {
    _private: (),
}
impl ListComponents {
    /// Creates a new builder-style object to manufacture [`ListComponentsInput`](crate::input::ListComponentsInput)
    pub fn builder() -> crate::input::list_components_input::Builder {
        crate::input::list_components_input::Builder::default()
    }
    /// Creates a new `ListComponents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListComponents {
    type Output =
        std::result::Result<crate::output::ListComponentsOutput, crate::error::ListComponentsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_components_error(response)
        } else {
            crate::operation_deser::parse_list_components_response(response)
        }
    }
}

/// Operation shape for `ListContainerRecipes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_container_recipes`](crate::client::Client::list_container_recipes).
///
/// See [`crate::client::fluent_builders::ListContainerRecipes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListContainerRecipes {
    _private: (),
}
impl ListContainerRecipes {
    /// Creates a new builder-style object to manufacture [`ListContainerRecipesInput`](crate::input::ListContainerRecipesInput)
    pub fn builder() -> crate::input::list_container_recipes_input::Builder {
        crate::input::list_container_recipes_input::Builder::default()
    }
    /// Creates a new `ListContainerRecipes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListContainerRecipes {
    type Output = std::result::Result<
        crate::output::ListContainerRecipesOutput,
        crate::error::ListContainerRecipesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_container_recipes_error(response)
        } else {
            crate::operation_deser::parse_list_container_recipes_response(response)
        }
    }
}

/// Operation shape for `ListDistributionConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_distribution_configurations`](crate::client::Client::list_distribution_configurations).
///
/// See [`crate::client::fluent_builders::ListDistributionConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDistributionConfigurations {
    _private: (),
}
impl ListDistributionConfigurations {
    /// Creates a new builder-style object to manufacture [`ListDistributionConfigurationsInput`](crate::input::ListDistributionConfigurationsInput)
    pub fn builder() -> crate::input::list_distribution_configurations_input::Builder {
        crate::input::list_distribution_configurations_input::Builder::default()
    }
    /// Creates a new `ListDistributionConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDistributionConfigurations {
    type Output = std::result::Result<
        crate::output::ListDistributionConfigurationsOutput,
        crate::error::ListDistributionConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_distribution_configurations_error(response)
        } else {
            crate::operation_deser::parse_list_distribution_configurations_response(response)
        }
    }
}

/// Operation shape for `ListImageBuildVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_image_build_versions`](crate::client::Client::list_image_build_versions).
///
/// See [`crate::client::fluent_builders::ListImageBuildVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListImageBuildVersions {
    _private: (),
}
impl ListImageBuildVersions {
    /// Creates a new builder-style object to manufacture [`ListImageBuildVersionsInput`](crate::input::ListImageBuildVersionsInput)
    pub fn builder() -> crate::input::list_image_build_versions_input::Builder {
        crate::input::list_image_build_versions_input::Builder::default()
    }
    /// Creates a new `ListImageBuildVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListImageBuildVersions {
    type Output = std::result::Result<
        crate::output::ListImageBuildVersionsOutput,
        crate::error::ListImageBuildVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_image_build_versions_error(response)
        } else {
            crate::operation_deser::parse_list_image_build_versions_response(response)
        }
    }
}

/// Operation shape for `ListImagePackages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_image_packages`](crate::client::Client::list_image_packages).
///
/// See [`crate::client::fluent_builders::ListImagePackages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListImagePackages {
    _private: (),
}
impl ListImagePackages {
    /// Creates a new builder-style object to manufacture [`ListImagePackagesInput`](crate::input::ListImagePackagesInput)
    pub fn builder() -> crate::input::list_image_packages_input::Builder {
        crate::input::list_image_packages_input::Builder::default()
    }
    /// Creates a new `ListImagePackages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListImagePackages {
    type Output = std::result::Result<
        crate::output::ListImagePackagesOutput,
        crate::error::ListImagePackagesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_image_packages_error(response)
        } else {
            crate::operation_deser::parse_list_image_packages_response(response)
        }
    }
}

/// Operation shape for `ListImagePipelineImages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_image_pipeline_images`](crate::client::Client::list_image_pipeline_images).
///
/// See [`crate::client::fluent_builders::ListImagePipelineImages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListImagePipelineImages {
    _private: (),
}
impl ListImagePipelineImages {
    /// Creates a new builder-style object to manufacture [`ListImagePipelineImagesInput`](crate::input::ListImagePipelineImagesInput)
    pub fn builder() -> crate::input::list_image_pipeline_images_input::Builder {
        crate::input::list_image_pipeline_images_input::Builder::default()
    }
    /// Creates a new `ListImagePipelineImages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListImagePipelineImages {
    type Output = std::result::Result<
        crate::output::ListImagePipelineImagesOutput,
        crate::error::ListImagePipelineImagesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_image_pipeline_images_error(response)
        } else {
            crate::operation_deser::parse_list_image_pipeline_images_response(response)
        }
    }
}

/// Operation shape for `ListImagePipelines`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_image_pipelines`](crate::client::Client::list_image_pipelines).
///
/// See [`crate::client::fluent_builders::ListImagePipelines`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListImagePipelines {
    _private: (),
}
impl ListImagePipelines {
    /// Creates a new builder-style object to manufacture [`ListImagePipelinesInput`](crate::input::ListImagePipelinesInput)
    pub fn builder() -> crate::input::list_image_pipelines_input::Builder {
        crate::input::list_image_pipelines_input::Builder::default()
    }
    /// Creates a new `ListImagePipelines` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListImagePipelines {
    type Output = std::result::Result<
        crate::output::ListImagePipelinesOutput,
        crate::error::ListImagePipelinesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_image_pipelines_error(response)
        } else {
            crate::operation_deser::parse_list_image_pipelines_response(response)
        }
    }
}

/// Operation shape for `ListImageRecipes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_image_recipes`](crate::client::Client::list_image_recipes).
///
/// See [`crate::client::fluent_builders::ListImageRecipes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListImageRecipes {
    _private: (),
}
impl ListImageRecipes {
    /// Creates a new builder-style object to manufacture [`ListImageRecipesInput`](crate::input::ListImageRecipesInput)
    pub fn builder() -> crate::input::list_image_recipes_input::Builder {
        crate::input::list_image_recipes_input::Builder::default()
    }
    /// Creates a new `ListImageRecipes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListImageRecipes {
    type Output = std::result::Result<
        crate::output::ListImageRecipesOutput,
        crate::error::ListImageRecipesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_image_recipes_error(response)
        } else {
            crate::operation_deser::parse_list_image_recipes_response(response)
        }
    }
}

/// Operation shape for `ListImages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_images`](crate::client::Client::list_images).
///
/// See [`crate::client::fluent_builders::ListImages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListImages {
    _private: (),
}
impl ListImages {
    /// Creates a new builder-style object to manufacture [`ListImagesInput`](crate::input::ListImagesInput)
    pub fn builder() -> crate::input::list_images_input::Builder {
        crate::input::list_images_input::Builder::default()
    }
    /// Creates a new `ListImages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListImages {
    type Output =
        std::result::Result<crate::output::ListImagesOutput, crate::error::ListImagesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_images_error(response)
        } else {
            crate::operation_deser::parse_list_images_response(response)
        }
    }
}

/// Operation shape for `ListInfrastructureConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_infrastructure_configurations`](crate::client::Client::list_infrastructure_configurations).
///
/// See [`crate::client::fluent_builders::ListInfrastructureConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListInfrastructureConfigurations {
    _private: (),
}
impl ListInfrastructureConfigurations {
    /// Creates a new builder-style object to manufacture [`ListInfrastructureConfigurationsInput`](crate::input::ListInfrastructureConfigurationsInput)
    pub fn builder() -> crate::input::list_infrastructure_configurations_input::Builder {
        crate::input::list_infrastructure_configurations_input::Builder::default()
    }
    /// Creates a new `ListInfrastructureConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListInfrastructureConfigurations {
    type Output = std::result::Result<
        crate::output::ListInfrastructureConfigurationsOutput,
        crate::error::ListInfrastructureConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_infrastructure_configurations_error(response)
        } else {
            crate::operation_deser::parse_list_infrastructure_configurations_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `PutComponentPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_component_policy`](crate::client::Client::put_component_policy).
///
/// See [`crate::client::fluent_builders::PutComponentPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutComponentPolicy {
    _private: (),
}
impl PutComponentPolicy {
    /// Creates a new builder-style object to manufacture [`PutComponentPolicyInput`](crate::input::PutComponentPolicyInput)
    pub fn builder() -> crate::input::put_component_policy_input::Builder {
        crate::input::put_component_policy_input::Builder::default()
    }
    /// Creates a new `PutComponentPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutComponentPolicy {
    type Output = std::result::Result<
        crate::output::PutComponentPolicyOutput,
        crate::error::PutComponentPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_component_policy_error(response)
        } else {
            crate::operation_deser::parse_put_component_policy_response(response)
        }
    }
}

/// Operation shape for `PutContainerRecipePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_container_recipe_policy`](crate::client::Client::put_container_recipe_policy).
///
/// See [`crate::client::fluent_builders::PutContainerRecipePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutContainerRecipePolicy {
    _private: (),
}
impl PutContainerRecipePolicy {
    /// Creates a new builder-style object to manufacture [`PutContainerRecipePolicyInput`](crate::input::PutContainerRecipePolicyInput)
    pub fn builder() -> crate::input::put_container_recipe_policy_input::Builder {
        crate::input::put_container_recipe_policy_input::Builder::default()
    }
    /// Creates a new `PutContainerRecipePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutContainerRecipePolicy {
    type Output = std::result::Result<
        crate::output::PutContainerRecipePolicyOutput,
        crate::error::PutContainerRecipePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_container_recipe_policy_error(response)
        } else {
            crate::operation_deser::parse_put_container_recipe_policy_response(response)
        }
    }
}

/// Operation shape for `PutImagePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_image_policy`](crate::client::Client::put_image_policy).
///
/// See [`crate::client::fluent_builders::PutImagePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutImagePolicy {
    _private: (),
}
impl PutImagePolicy {
    /// Creates a new builder-style object to manufacture [`PutImagePolicyInput`](crate::input::PutImagePolicyInput)
    pub fn builder() -> crate::input::put_image_policy_input::Builder {
        crate::input::put_image_policy_input::Builder::default()
    }
    /// Creates a new `PutImagePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutImagePolicy {
    type Output =
        std::result::Result<crate::output::PutImagePolicyOutput, crate::error::PutImagePolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_image_policy_error(response)
        } else {
            crate::operation_deser::parse_put_image_policy_response(response)
        }
    }
}

/// Operation shape for `PutImageRecipePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_image_recipe_policy`](crate::client::Client::put_image_recipe_policy).
///
/// See [`crate::client::fluent_builders::PutImageRecipePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutImageRecipePolicy {
    _private: (),
}
impl PutImageRecipePolicy {
    /// Creates a new builder-style object to manufacture [`PutImageRecipePolicyInput`](crate::input::PutImageRecipePolicyInput)
    pub fn builder() -> crate::input::put_image_recipe_policy_input::Builder {
        crate::input::put_image_recipe_policy_input::Builder::default()
    }
    /// Creates a new `PutImageRecipePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutImageRecipePolicy {
    type Output = std::result::Result<
        crate::output::PutImageRecipePolicyOutput,
        crate::error::PutImageRecipePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_image_recipe_policy_error(response)
        } else {
            crate::operation_deser::parse_put_image_recipe_policy_response(response)
        }
    }
}

/// Operation shape for `StartImagePipelineExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_image_pipeline_execution`](crate::client::Client::start_image_pipeline_execution).
///
/// See [`crate::client::fluent_builders::StartImagePipelineExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartImagePipelineExecution {
    _private: (),
}
impl StartImagePipelineExecution {
    /// Creates a new builder-style object to manufacture [`StartImagePipelineExecutionInput`](crate::input::StartImagePipelineExecutionInput)
    pub fn builder() -> crate::input::start_image_pipeline_execution_input::Builder {
        crate::input::start_image_pipeline_execution_input::Builder::default()
    }
    /// Creates a new `StartImagePipelineExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartImagePipelineExecution {
    type Output = std::result::Result<
        crate::output::StartImagePipelineExecutionOutput,
        crate::error::StartImagePipelineExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_image_pipeline_execution_error(response)
        } else {
            crate::operation_deser::parse_start_image_pipeline_execution_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateDistributionConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_distribution_configuration`](crate::client::Client::update_distribution_configuration).
///
/// See [`crate::client::fluent_builders::UpdateDistributionConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDistributionConfiguration {
    _private: (),
}
impl UpdateDistributionConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateDistributionConfigurationInput`](crate::input::UpdateDistributionConfigurationInput)
    pub fn builder() -> crate::input::update_distribution_configuration_input::Builder {
        crate::input::update_distribution_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateDistributionConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDistributionConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateDistributionConfigurationOutput,
        crate::error::UpdateDistributionConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_distribution_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_distribution_configuration_response(response)
        }
    }
}

/// Operation shape for `UpdateImagePipeline`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_image_pipeline`](crate::client::Client::update_image_pipeline).
///
/// See [`crate::client::fluent_builders::UpdateImagePipeline`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateImagePipeline {
    _private: (),
}
impl UpdateImagePipeline {
    /// Creates a new builder-style object to manufacture [`UpdateImagePipelineInput`](crate::input::UpdateImagePipelineInput)
    pub fn builder() -> crate::input::update_image_pipeline_input::Builder {
        crate::input::update_image_pipeline_input::Builder::default()
    }
    /// Creates a new `UpdateImagePipeline` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateImagePipeline {
    type Output = std::result::Result<
        crate::output::UpdateImagePipelineOutput,
        crate::error::UpdateImagePipelineError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_image_pipeline_error(response)
        } else {
            crate::operation_deser::parse_update_image_pipeline_response(response)
        }
    }
}

/// Operation shape for `UpdateInfrastructureConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_infrastructure_configuration`](crate::client::Client::update_infrastructure_configuration).
///
/// See [`crate::client::fluent_builders::UpdateInfrastructureConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateInfrastructureConfiguration {
    _private: (),
}
impl UpdateInfrastructureConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateInfrastructureConfigurationInput`](crate::input::UpdateInfrastructureConfigurationInput)
    pub fn builder() -> crate::input::update_infrastructure_configuration_input::Builder {
        crate::input::update_infrastructure_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateInfrastructureConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateInfrastructureConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateInfrastructureConfigurationOutput,
        crate::error::UpdateInfrastructureConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_infrastructure_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_infrastructure_configuration_response(response)
        }
    }
}
