// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for EC2 Image Builder
///
/// Client for invoking operations on EC2 Image Builder. Each operation on EC2 Image Builder is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_imagebuilder::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operationname>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_imagebuilder::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_imagebuilder::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CancelImageCreation` operation.
    ///
    /// See [`CancelImageCreation`](crate::client::fluent_builders::CancelImageCreation) for more information about the
    /// operation and its arguments.
    pub fn cancel_image_creation(&self) -> fluent_builders::CancelImageCreation<C, M, R> {
        fluent_builders::CancelImageCreation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateComponent` operation.
    ///
    /// See [`CreateComponent`](crate::client::fluent_builders::CreateComponent) for more information about the
    /// operation and its arguments.
    pub fn create_component(&self) -> fluent_builders::CreateComponent<C, M, R> {
        fluent_builders::CreateComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateContainerRecipe` operation.
    ///
    /// See [`CreateContainerRecipe`](crate::client::fluent_builders::CreateContainerRecipe) for more information about the
    /// operation and its arguments.
    pub fn create_container_recipe(&self) -> fluent_builders::CreateContainerRecipe<C, M, R> {
        fluent_builders::CreateContainerRecipe::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDistributionConfiguration` operation.
    ///
    /// See [`CreateDistributionConfiguration`](crate::client::fluent_builders::CreateDistributionConfiguration) for more information about the
    /// operation and its arguments.
    pub fn create_distribution_configuration(
        &self,
    ) -> fluent_builders::CreateDistributionConfiguration<C, M, R> {
        fluent_builders::CreateDistributionConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateImage` operation.
    ///
    /// See [`CreateImage`](crate::client::fluent_builders::CreateImage) for more information about the
    /// operation and its arguments.
    pub fn create_image(&self) -> fluent_builders::CreateImage<C, M, R> {
        fluent_builders::CreateImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateImagePipeline` operation.
    ///
    /// See [`CreateImagePipeline`](crate::client::fluent_builders::CreateImagePipeline) for more information about the
    /// operation and its arguments.
    pub fn create_image_pipeline(&self) -> fluent_builders::CreateImagePipeline<C, M, R> {
        fluent_builders::CreateImagePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateImageRecipe` operation.
    ///
    /// See [`CreateImageRecipe`](crate::client::fluent_builders::CreateImageRecipe) for more information about the
    /// operation and its arguments.
    pub fn create_image_recipe(&self) -> fluent_builders::CreateImageRecipe<C, M, R> {
        fluent_builders::CreateImageRecipe::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateInfrastructureConfiguration` operation.
    ///
    /// See [`CreateInfrastructureConfiguration`](crate::client::fluent_builders::CreateInfrastructureConfiguration) for more information about the
    /// operation and its arguments.
    pub fn create_infrastructure_configuration(
        &self,
    ) -> fluent_builders::CreateInfrastructureConfiguration<C, M, R> {
        fluent_builders::CreateInfrastructureConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteComponent` operation.
    ///
    /// See [`DeleteComponent`](crate::client::fluent_builders::DeleteComponent) for more information about the
    /// operation and its arguments.
    pub fn delete_component(&self) -> fluent_builders::DeleteComponent<C, M, R> {
        fluent_builders::DeleteComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteContainerRecipe` operation.
    ///
    /// See [`DeleteContainerRecipe`](crate::client::fluent_builders::DeleteContainerRecipe) for more information about the
    /// operation and its arguments.
    pub fn delete_container_recipe(&self) -> fluent_builders::DeleteContainerRecipe<C, M, R> {
        fluent_builders::DeleteContainerRecipe::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDistributionConfiguration` operation.
    ///
    /// See [`DeleteDistributionConfiguration`](crate::client::fluent_builders::DeleteDistributionConfiguration) for more information about the
    /// operation and its arguments.
    pub fn delete_distribution_configuration(
        &self,
    ) -> fluent_builders::DeleteDistributionConfiguration<C, M, R> {
        fluent_builders::DeleteDistributionConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteImage` operation.
    ///
    /// See [`DeleteImage`](crate::client::fluent_builders::DeleteImage) for more information about the
    /// operation and its arguments.
    pub fn delete_image(&self) -> fluent_builders::DeleteImage<C, M, R> {
        fluent_builders::DeleteImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteImagePipeline` operation.
    ///
    /// See [`DeleteImagePipeline`](crate::client::fluent_builders::DeleteImagePipeline) for more information about the
    /// operation and its arguments.
    pub fn delete_image_pipeline(&self) -> fluent_builders::DeleteImagePipeline<C, M, R> {
        fluent_builders::DeleteImagePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteImageRecipe` operation.
    ///
    /// See [`DeleteImageRecipe`](crate::client::fluent_builders::DeleteImageRecipe) for more information about the
    /// operation and its arguments.
    pub fn delete_image_recipe(&self) -> fluent_builders::DeleteImageRecipe<C, M, R> {
        fluent_builders::DeleteImageRecipe::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteInfrastructureConfiguration` operation.
    ///
    /// See [`DeleteInfrastructureConfiguration`](crate::client::fluent_builders::DeleteInfrastructureConfiguration) for more information about the
    /// operation and its arguments.
    pub fn delete_infrastructure_configuration(
        &self,
    ) -> fluent_builders::DeleteInfrastructureConfiguration<C, M, R> {
        fluent_builders::DeleteInfrastructureConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetComponent` operation.
    ///
    /// See [`GetComponent`](crate::client::fluent_builders::GetComponent) for more information about the
    /// operation and its arguments.
    pub fn get_component(&self) -> fluent_builders::GetComponent<C, M, R> {
        fluent_builders::GetComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetComponentPolicy` operation.
    ///
    /// See [`GetComponentPolicy`](crate::client::fluent_builders::GetComponentPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_component_policy(&self) -> fluent_builders::GetComponentPolicy<C, M, R> {
        fluent_builders::GetComponentPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetContainerRecipe` operation.
    ///
    /// See [`GetContainerRecipe`](crate::client::fluent_builders::GetContainerRecipe) for more information about the
    /// operation and its arguments.
    pub fn get_container_recipe(&self) -> fluent_builders::GetContainerRecipe<C, M, R> {
        fluent_builders::GetContainerRecipe::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetContainerRecipePolicy` operation.
    ///
    /// See [`GetContainerRecipePolicy`](crate::client::fluent_builders::GetContainerRecipePolicy) for more information about the
    /// operation and its arguments.
    pub fn get_container_recipe_policy(
        &self,
    ) -> fluent_builders::GetContainerRecipePolicy<C, M, R> {
        fluent_builders::GetContainerRecipePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDistributionConfiguration` operation.
    ///
    /// See [`GetDistributionConfiguration`](crate::client::fluent_builders::GetDistributionConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_distribution_configuration(
        &self,
    ) -> fluent_builders::GetDistributionConfiguration<C, M, R> {
        fluent_builders::GetDistributionConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetImage` operation.
    ///
    /// See [`GetImage`](crate::client::fluent_builders::GetImage) for more information about the
    /// operation and its arguments.
    pub fn get_image(&self) -> fluent_builders::GetImage<C, M, R> {
        fluent_builders::GetImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetImagePipeline` operation.
    ///
    /// See [`GetImagePipeline`](crate::client::fluent_builders::GetImagePipeline) for more information about the
    /// operation and its arguments.
    pub fn get_image_pipeline(&self) -> fluent_builders::GetImagePipeline<C, M, R> {
        fluent_builders::GetImagePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetImagePolicy` operation.
    ///
    /// See [`GetImagePolicy`](crate::client::fluent_builders::GetImagePolicy) for more information about the
    /// operation and its arguments.
    pub fn get_image_policy(&self) -> fluent_builders::GetImagePolicy<C, M, R> {
        fluent_builders::GetImagePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetImageRecipe` operation.
    ///
    /// See [`GetImageRecipe`](crate::client::fluent_builders::GetImageRecipe) for more information about the
    /// operation and its arguments.
    pub fn get_image_recipe(&self) -> fluent_builders::GetImageRecipe<C, M, R> {
        fluent_builders::GetImageRecipe::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetImageRecipePolicy` operation.
    ///
    /// See [`GetImageRecipePolicy`](crate::client::fluent_builders::GetImageRecipePolicy) for more information about the
    /// operation and its arguments.
    pub fn get_image_recipe_policy(&self) -> fluent_builders::GetImageRecipePolicy<C, M, R> {
        fluent_builders::GetImageRecipePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetInfrastructureConfiguration` operation.
    ///
    /// See [`GetInfrastructureConfiguration`](crate::client::fluent_builders::GetInfrastructureConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_infrastructure_configuration(
        &self,
    ) -> fluent_builders::GetInfrastructureConfiguration<C, M, R> {
        fluent_builders::GetInfrastructureConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ImportComponent` operation.
    ///
    /// See [`ImportComponent`](crate::client::fluent_builders::ImportComponent) for more information about the
    /// operation and its arguments.
    pub fn import_component(&self) -> fluent_builders::ImportComponent<C, M, R> {
        fluent_builders::ImportComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListComponentBuildVersions` operation.
    ///
    /// See [`ListComponentBuildVersions`](crate::client::fluent_builders::ListComponentBuildVersions) for more information about the
    /// operation and its arguments.
    pub fn list_component_build_versions(
        &self,
    ) -> fluent_builders::ListComponentBuildVersions<C, M, R> {
        fluent_builders::ListComponentBuildVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListComponents` operation.
    ///
    /// See [`ListComponents`](crate::client::fluent_builders::ListComponents) for more information about the
    /// operation and its arguments.
    pub fn list_components(&self) -> fluent_builders::ListComponents<C, M, R> {
        fluent_builders::ListComponents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListContainerRecipes` operation.
    ///
    /// See [`ListContainerRecipes`](crate::client::fluent_builders::ListContainerRecipes) for more information about the
    /// operation and its arguments.
    pub fn list_container_recipes(&self) -> fluent_builders::ListContainerRecipes<C, M, R> {
        fluent_builders::ListContainerRecipes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDistributionConfigurations` operation.
    ///
    /// See [`ListDistributionConfigurations`](crate::client::fluent_builders::ListDistributionConfigurations) for more information about the
    /// operation and its arguments.
    pub fn list_distribution_configurations(
        &self,
    ) -> fluent_builders::ListDistributionConfigurations<C, M, R> {
        fluent_builders::ListDistributionConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListImageBuildVersions` operation.
    ///
    /// See [`ListImageBuildVersions`](crate::client::fluent_builders::ListImageBuildVersions) for more information about the
    /// operation and its arguments.
    pub fn list_image_build_versions(&self) -> fluent_builders::ListImageBuildVersions<C, M, R> {
        fluent_builders::ListImageBuildVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListImagePackages` operation.
    ///
    /// See [`ListImagePackages`](crate::client::fluent_builders::ListImagePackages) for more information about the
    /// operation and its arguments.
    pub fn list_image_packages(&self) -> fluent_builders::ListImagePackages<C, M, R> {
        fluent_builders::ListImagePackages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListImagePipelineImages` operation.
    ///
    /// See [`ListImagePipelineImages`](crate::client::fluent_builders::ListImagePipelineImages) for more information about the
    /// operation and its arguments.
    pub fn list_image_pipeline_images(&self) -> fluent_builders::ListImagePipelineImages<C, M, R> {
        fluent_builders::ListImagePipelineImages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListImagePipelines` operation.
    ///
    /// See [`ListImagePipelines`](crate::client::fluent_builders::ListImagePipelines) for more information about the
    /// operation and its arguments.
    pub fn list_image_pipelines(&self) -> fluent_builders::ListImagePipelines<C, M, R> {
        fluent_builders::ListImagePipelines::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListImageRecipes` operation.
    ///
    /// See [`ListImageRecipes`](crate::client::fluent_builders::ListImageRecipes) for more information about the
    /// operation and its arguments.
    pub fn list_image_recipes(&self) -> fluent_builders::ListImageRecipes<C, M, R> {
        fluent_builders::ListImageRecipes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListImages` operation.
    ///
    /// See [`ListImages`](crate::client::fluent_builders::ListImages) for more information about the
    /// operation and its arguments.
    pub fn list_images(&self) -> fluent_builders::ListImages<C, M, R> {
        fluent_builders::ListImages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListInfrastructureConfigurations` operation.
    ///
    /// See [`ListInfrastructureConfigurations`](crate::client::fluent_builders::ListInfrastructureConfigurations) for more information about the
    /// operation and its arguments.
    pub fn list_infrastructure_configurations(
        &self,
    ) -> fluent_builders::ListInfrastructureConfigurations<C, M, R> {
        fluent_builders::ListInfrastructureConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutComponentPolicy` operation.
    ///
    /// See [`PutComponentPolicy`](crate::client::fluent_builders::PutComponentPolicy) for more information about the
    /// operation and its arguments.
    pub fn put_component_policy(&self) -> fluent_builders::PutComponentPolicy<C, M, R> {
        fluent_builders::PutComponentPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutContainerRecipePolicy` operation.
    ///
    /// See [`PutContainerRecipePolicy`](crate::client::fluent_builders::PutContainerRecipePolicy) for more information about the
    /// operation and its arguments.
    pub fn put_container_recipe_policy(
        &self,
    ) -> fluent_builders::PutContainerRecipePolicy<C, M, R> {
        fluent_builders::PutContainerRecipePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutImagePolicy` operation.
    ///
    /// See [`PutImagePolicy`](crate::client::fluent_builders::PutImagePolicy) for more information about the
    /// operation and its arguments.
    pub fn put_image_policy(&self) -> fluent_builders::PutImagePolicy<C, M, R> {
        fluent_builders::PutImagePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutImageRecipePolicy` operation.
    ///
    /// See [`PutImageRecipePolicy`](crate::client::fluent_builders::PutImageRecipePolicy) for more information about the
    /// operation and its arguments.
    pub fn put_image_recipe_policy(&self) -> fluent_builders::PutImageRecipePolicy<C, M, R> {
        fluent_builders::PutImageRecipePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartImagePipelineExecution` operation.
    ///
    /// See [`StartImagePipelineExecution`](crate::client::fluent_builders::StartImagePipelineExecution) for more information about the
    /// operation and its arguments.
    pub fn start_image_pipeline_execution(
        &self,
    ) -> fluent_builders::StartImagePipelineExecution<C, M, R> {
        fluent_builders::StartImagePipelineExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDistributionConfiguration` operation.
    ///
    /// See [`UpdateDistributionConfiguration`](crate::client::fluent_builders::UpdateDistributionConfiguration) for more information about the
    /// operation and its arguments.
    pub fn update_distribution_configuration(
        &self,
    ) -> fluent_builders::UpdateDistributionConfiguration<C, M, R> {
        fluent_builders::UpdateDistributionConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateImagePipeline` operation.
    ///
    /// See [`UpdateImagePipeline`](crate::client::fluent_builders::UpdateImagePipeline) for more information about the
    /// operation and its arguments.
    pub fn update_image_pipeline(&self) -> fluent_builders::UpdateImagePipeline<C, M, R> {
        fluent_builders::UpdateImagePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateInfrastructureConfiguration` operation.
    ///
    /// See [`UpdateInfrastructureConfiguration`](crate::client::fluent_builders::UpdateInfrastructureConfiguration) for more information about the
    /// operation and its arguments.
    pub fn update_infrastructure_configuration(
        &self,
    ) -> fluent_builders::UpdateInfrastructureConfiguration<C, M, R> {
        fluent_builders::UpdateInfrastructureConfiguration::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CancelImageCreation`.
    ///
    /// <p>CancelImageCreation cancels the creation of Image. This operation can only be used on
    /// images in a non-terminal state.</p>
    #[derive(std::fmt::Debug)]
    pub struct CancelImageCreation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_image_creation_input::Builder,
    }
    impl<C, M, R> CancelImageCreation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelImageCreation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelImageCreationOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelImageCreationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelImageCreationInputOperationOutputAlias,
                crate::output::CancelImageCreationOutput,
                crate::error::CancelImageCreationError,
                crate::input::CancelImageCreationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the image whose creation you want to cancel.</p>
        pub fn image_build_version_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_build_version_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image whose creation you want to cancel.</p>
        pub fn set_image_build_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_build_version_arn(input);
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateComponent`.
    ///
    /// <p>Creates a new component that can be used to build, validate, test, and assess your
    /// image.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateComponent<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_component_input::Builder,
    }
    impl<C, M, R> CreateComponent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateComponentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateComponentInputOperationOutputAlias,
                crate::output::CreateComponentOutput,
                crate::error::CreateComponentError,
                crate::input::CreateComponentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the component.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The semantic version of the component. This version follows the semantic version syntax.</p>
        /// <note>
        /// <p>The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
        /// You can assign values for the first three, and can filter on all of them.</p>
        /// <p>
        /// <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including
        /// zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
        /// build number to the fourth node.</p>
        /// <p>
        /// <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for
        /// the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
        /// a date, such as 2021.01.01.</p>
        /// </note>
        pub fn semantic_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.semantic_version(inp);
            self
        }
        /// <p>The semantic version of the component. This version follows the semantic version syntax.</p>
        /// <note>
        /// <p>The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
        /// You can assign values for the first three, and can filter on all of them.</p>
        /// <p>
        /// <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including
        /// zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
        /// build number to the fourth node.</p>
        /// <p>
        /// <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for
        /// the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
        /// a date, such as 2021.01.01.</p>
        /// </note>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_semantic_version(input);
            self
        }
        /// <p>The description of the component. Describes the contents of the component.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the component. Describes the contents of the component.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The change description of the component. Describes what change has been made in this
        /// version, or what makes this version different from other versions of this component.</p>
        pub fn change_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_description(inp);
            self
        }
        /// <p>The change description of the component. Describes what change has been made in this
        /// version, or what makes this version different from other versions of this component.</p>
        pub fn set_change_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_change_description(input);
            self
        }
        /// <p>The platform of the component.</p>
        pub fn platform(mut self, inp: crate::model::Platform) -> Self {
            self.inner = self.inner.platform(inp);
            self
        }
        /// <p>The platform of the component.</p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.inner = self.inner.set_platform(input);
            self
        }
        /// Appends an item to `supportedOsVersions`.
        ///
        /// To override the contents of this collection use [`set_supported_os_versions`](Self::set_supported_os_versions).
        ///
        /// <p> The operating system (OS) version supported by the component. If the OS information is
        /// available, a prefix match is performed against the base image OS version during image recipe
        /// creation.</p>
        pub fn supported_os_versions(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.supported_os_versions(inp);
            self
        }
        /// <p> The operating system (OS) version supported by the component. If the OS information is
        /// available, a prefix match is performed against the base image OS version during image recipe
        /// creation.</p>
        pub fn set_supported_os_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_supported_os_versions(input);
            self
        }
        /// <p>The data of the component. Used to specify the data inline. Either <code>data</code> or
        /// <code>uri</code> can be used to specify the data within the component.</p>
        pub fn data(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data(inp);
            self
        }
        /// <p>The data of the component. Used to specify the data inline. Either <code>data</code> or
        /// <code>uri</code> can be used to specify the data within the component.</p>
        pub fn set_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data(input);
            self
        }
        /// <p>The uri of the component. Must be an Amazon S3 URL and the requester must have permission to
        /// access the Amazon S3 bucket. If you use Amazon S3, you can specify component content up to your service
        /// quota. Either <code>data</code> or <code>uri</code> can be used to specify the data within the
        /// component.</p>
        pub fn uri(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.uri(inp);
            self
        }
        /// <p>The uri of the component. Must be an Amazon S3 URL and the requester must have permission to
        /// access the Amazon S3 bucket. If you use Amazon S3, you can specify component content up to your service
        /// quota. Either <code>data</code> or <code>uri</code> can be used to specify the data within the
        /// component.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_uri(input);
            self
        }
        /// <p>The ID of the KMS key that should be used to encrypt this component.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The ID of the KMS key that should be used to encrypt this component.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags of the component.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags of the component.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The idempotency token of the component.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>The idempotency token of the component.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateContainerRecipe`.
    ///
    /// <p>Creates a new container recipe. Container recipes define how images are configured, tested, and assessed.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateContainerRecipe<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_container_recipe_input::Builder,
    }
    impl<C, M, R> CreateContainerRecipe<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateContainerRecipe`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateContainerRecipeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateContainerRecipeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateContainerRecipeInputOperationOutputAlias,
                crate::output::CreateContainerRecipeOutput,
                crate::error::CreateContainerRecipeError,
                crate::input::CreateContainerRecipeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of container to create.</p>
        pub fn container_type(mut self, inp: crate::model::ContainerType) -> Self {
            self.inner = self.inner.container_type(inp);
            self
        }
        /// <p>The type of container to create.</p>
        pub fn set_container_type(
            mut self,
            input: std::option::Option<crate::model::ContainerType>,
        ) -> Self {
            self.inner = self.inner.set_container_type(input);
            self
        }
        /// <p>The name of the container recipe.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the container recipe.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the container recipe.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the container recipe.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The semantic version of the container recipe. This version follows the semantic version syntax.</p>
        /// <note>
        /// <p>The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
        /// You can assign values for the first three, and can filter on all of them.</p>
        /// <p>
        /// <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including
        /// zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
        /// build number to the fourth node.</p>
        /// <p>
        /// <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for
        /// the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
        /// a date, such as 2021.01.01.</p>
        /// </note>
        pub fn semantic_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.semantic_version(inp);
            self
        }
        /// <p>The semantic version of the container recipe. This version follows the semantic version syntax.</p>
        /// <note>
        /// <p>The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
        /// You can assign values for the first three, and can filter on all of them.</p>
        /// <p>
        /// <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including
        /// zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
        /// build number to the fourth node.</p>
        /// <p>
        /// <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for
        /// the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
        /// a date, such as 2021.01.01.</p>
        /// </note>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_semantic_version(input);
            self
        }
        /// Appends an item to `components`.
        ///
        /// To override the contents of this collection use [`set_components`](Self::set_components).
        ///
        /// <p>Components for build and test that are included in the container recipe.</p>
        pub fn components(mut self, inp: impl Into<crate::model::ComponentConfiguration>) -> Self {
            self.inner = self.inner.components(inp);
            self
        }
        /// <p>Components for build and test that are included in the container recipe.</p>
        pub fn set_components(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComponentConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_components(input);
            self
        }
        /// <p>A group of options that can be used to configure an instance for building and testing container images.</p>
        pub fn instance_configuration(mut self, inp: crate::model::InstanceConfiguration) -> Self {
            self.inner = self.inner.instance_configuration(inp);
            self
        }
        /// <p>A group of options that can be used to configure an instance for building and testing container images.</p>
        pub fn set_instance_configuration(
            mut self,
            input: std::option::Option<crate::model::InstanceConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_instance_configuration(input);
            self
        }
        /// <p>The Dockerfile template used to build your image as an inline data blob.</p>
        pub fn dockerfile_template_data(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dockerfile_template_data(inp);
            self
        }
        /// <p>The Dockerfile template used to build your image as an inline data blob.</p>
        pub fn set_dockerfile_template_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dockerfile_template_data(input);
            self
        }
        /// <p>The Amazon S3 URI for the Dockerfile that will be used to build your container image.</p>
        pub fn dockerfile_template_uri(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dockerfile_template_uri(inp);
            self
        }
        /// <p>The Amazon S3 URI for the Dockerfile that will be used to build your container image.</p>
        pub fn set_dockerfile_template_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dockerfile_template_uri(input);
            self
        }
        /// <p>Specifies the operating system platform when you use a custom base image.</p>
        pub fn platform_override(mut self, inp: crate::model::Platform) -> Self {
            self.inner = self.inner.platform_override(inp);
            self
        }
        /// <p>Specifies the operating system platform when you use a custom base image.</p>
        pub fn set_platform_override(
            mut self,
            input: std::option::Option<crate::model::Platform>,
        ) -> Self {
            self.inner = self.inner.set_platform_override(input);
            self
        }
        /// <p>Specifies the operating system version for the base image.</p>
        pub fn image_os_version_override(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_os_version_override(inp);
            self
        }
        /// <p>Specifies the operating system version for the base image.</p>
        pub fn set_image_os_version_override(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_os_version_override(input);
            self
        }
        /// <p>The base image for the container recipe.</p>
        pub fn parent_image(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_image(inp);
            self
        }
        /// <p>The base image for the container recipe.</p>
        pub fn set_parent_image(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_parent_image(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags that are attached to the container recipe.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Tags that are attached to the container recipe.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The working directory for use during build and test workflows.</p>
        pub fn working_directory(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.working_directory(inp);
            self
        }
        /// <p>The working directory for use during build and test workflows.</p>
        pub fn set_working_directory(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_working_directory(input);
            self
        }
        /// <p>The destination repository for the container image.</p>
        pub fn target_repository(mut self, inp: crate::model::TargetContainerRepository) -> Self {
            self.inner = self.inner.target_repository(inp);
            self
        }
        /// <p>The destination repository for the container image.</p>
        pub fn set_target_repository(
            mut self,
            input: std::option::Option<crate::model::TargetContainerRepository>,
        ) -> Self {
            self.inner = self.inner.set_target_repository(input);
            self
        }
        /// <p>Identifies which KMS key is used to encrypt the container image.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>Identifies which KMS key is used to encrypt the container image.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>The client token used to make this request idempotent.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>The client token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDistributionConfiguration`.
    ///
    /// <p>Creates a new distribution configuration. Distribution configurations define and configure
    /// the outputs of your pipeline.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDistributionConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_distribution_configuration_input::Builder,
    }
    impl<C, M, R> CreateDistributionConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDistributionConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDistributionConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDistributionConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDistributionConfigurationInputOperationOutputAlias,
                crate::output::CreateDistributionConfigurationOutput,
                crate::error::CreateDistributionConfigurationError,
                crate::input::CreateDistributionConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the distribution configuration.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p> The name of the distribution configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p> The description of the distribution configuration.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p> The description of the distribution configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `distributions`.
        ///
        /// To override the contents of this collection use [`set_distributions`](Self::set_distributions).
        ///
        /// <p> The distributions of the distribution configuration.</p>
        pub fn distributions(mut self, inp: impl Into<crate::model::Distribution>) -> Self {
            self.inner = self.inner.distributions(inp);
            self
        }
        /// <p> The distributions of the distribution configuration.</p>
        pub fn set_distributions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Distribution>>,
        ) -> Self {
            self.inner = self.inner.set_distributions(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags of the distribution configuration.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p> The tags of the distribution configuration.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p> The idempotency token of the distribution configuration.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p> The idempotency token of the distribution configuration.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateImage`.
    ///
    /// <p> Creates a new image. This request will create a new image along with all of the
    /// configured output resources defined in the distribution configuration. You must specify
    /// exactly one recipe for your image, using either a ContainerRecipeArn or an ImageRecipeArn.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateImage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_image_input::Builder,
    }
    impl<C, M, R> CreateImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateImageOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateImageInputOperationOutputAlias,
                crate::output::CreateImageOutput,
                crate::error::CreateImageError,
                crate::input::CreateImageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) of the image recipe that defines how images are
        /// configured, tested, and assessed.</p>
        pub fn image_recipe_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_recipe_arn(inp);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the image recipe that defines how images are
        /// configured, tested, and assessed.</p>
        pub fn set_image_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_recipe_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe that defines how images are configured and tested.</p>
        pub fn container_recipe_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_recipe_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe that defines how images are configured and tested.</p>
        pub fn set_container_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_recipe_arn(input);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the distribution configuration that defines and
        /// configures the outputs of your pipeline.</p>
        pub fn distribution_configuration_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.distribution_configuration_arn(inp);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the distribution configuration that defines and
        /// configures the outputs of your pipeline.</p>
        pub fn set_distribution_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_configuration_arn(input);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the infrastructure configuration that defines the
        /// environment in which your image will be built and tested.</p>
        pub fn infrastructure_configuration_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.infrastructure_configuration_arn(inp);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the infrastructure configuration that defines the
        /// environment in which your image will be built and tested.</p>
        pub fn set_infrastructure_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_infrastructure_configuration_arn(input);
            self
        }
        /// <p> The image tests configuration of the image.</p>
        pub fn image_tests_configuration(
            mut self,
            inp: crate::model::ImageTestsConfiguration,
        ) -> Self {
            self.inner = self.inner.image_tests_configuration(inp);
            self
        }
        /// <p> The image tests configuration of the image.</p>
        pub fn set_image_tests_configuration(
            mut self,
            input: std::option::Option<crate::model::ImageTestsConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_image_tests_configuration(input);
            self
        }
        /// <p> Collects additional information about the image being created, including the operating
        /// system (OS) version and package list. This information is used to enhance the overall
        /// experience of using EC2 Image Builder. Enabled by default.</p>
        pub fn enhanced_image_metadata_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.enhanced_image_metadata_enabled(inp);
            self
        }
        /// <p> Collects additional information about the image being created, including the operating
        /// system (OS) version and package list. This information is used to enhance the overall
        /// experience of using EC2 Image Builder. Enabled by default.</p>
        pub fn set_enhanced_image_metadata_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enhanced_image_metadata_enabled(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags of the image.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p> The tags of the image.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p> The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p> The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateImagePipeline`.
    ///
    /// <p> Creates a new image pipeline. Image pipelines enable you to automate the creation and
    /// distribution of images.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateImagePipeline<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_image_pipeline_input::Builder,
    }
    impl<C, M, R> CreateImagePipeline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateImagePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateImagePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateImagePipelineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateImagePipelineInputOperationOutputAlias,
                crate::output::CreateImagePipelineOutput,
                crate::error::CreateImagePipelineError,
                crate::input::CreateImagePipelineInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the image pipeline.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p> The name of the image pipeline.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p> The description of the image pipeline.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p> The description of the image pipeline.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the image recipe that will be used to configure images
        /// created by this image pipeline.</p>
        pub fn image_recipe_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_recipe_arn(inp);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the image recipe that will be used to configure images
        /// created by this image pipeline.</p>
        pub fn set_image_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_recipe_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe that is used to configure images created by this container pipeline.</p>
        pub fn container_recipe_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_recipe_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe that is used to configure images created by this container pipeline.</p>
        pub fn set_container_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_recipe_arn(input);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to
        /// build images created by this image pipeline.</p>
        pub fn infrastructure_configuration_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.infrastructure_configuration_arn(inp);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to
        /// build images created by this image pipeline.</p>
        pub fn set_infrastructure_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_infrastructure_configuration_arn(input);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the distribution configuration that will be used to
        /// configure and distribute images created by this image pipeline.</p>
        pub fn distribution_configuration_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.distribution_configuration_arn(inp);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the distribution configuration that will be used to
        /// configure and distribute images created by this image pipeline.</p>
        pub fn set_distribution_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_configuration_arn(input);
            self
        }
        /// <p> The image test configuration of the image pipeline.</p>
        pub fn image_tests_configuration(
            mut self,
            inp: crate::model::ImageTestsConfiguration,
        ) -> Self {
            self.inner = self.inner.image_tests_configuration(inp);
            self
        }
        /// <p> The image test configuration of the image pipeline.</p>
        pub fn set_image_tests_configuration(
            mut self,
            input: std::option::Option<crate::model::ImageTestsConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_image_tests_configuration(input);
            self
        }
        /// <p> Collects additional information about the image being created, including the operating
        /// system (OS) version and package list. This information is used to enhance the overall
        /// experience of using EC2 Image Builder. Enabled by default.</p>
        pub fn enhanced_image_metadata_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.enhanced_image_metadata_enabled(inp);
            self
        }
        /// <p> Collects additional information about the image being created, including the operating
        /// system (OS) version and package list. This information is used to enhance the overall
        /// experience of using EC2 Image Builder. Enabled by default.</p>
        pub fn set_enhanced_image_metadata_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enhanced_image_metadata_enabled(input);
            self
        }
        /// <p> The schedule of the image pipeline.</p>
        pub fn schedule(mut self, inp: crate::model::Schedule) -> Self {
            self.inner = self.inner.schedule(inp);
            self
        }
        /// <p> The schedule of the image pipeline.</p>
        pub fn set_schedule(mut self, input: std::option::Option<crate::model::Schedule>) -> Self {
            self.inner = self.inner.set_schedule(input);
            self
        }
        /// <p> The status of the image pipeline.</p>
        pub fn status(mut self, inp: crate::model::PipelineStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p> The status of the image pipeline.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PipelineStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags of the image pipeline.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p> The tags of the image pipeline.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p> The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p> The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateImageRecipe`.
    ///
    /// <p> Creates a new image recipe. Image recipes define how images are configured, tested, and
    /// assessed.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateImageRecipe<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_image_recipe_input::Builder,
    }
    impl<C, M, R> CreateImageRecipe<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateImageRecipe`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateImageRecipeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateImageRecipeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateImageRecipeInputOperationOutputAlias,
                crate::output::CreateImageRecipeOutput,
                crate::error::CreateImageRecipeError,
                crate::input::CreateImageRecipeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the image recipe.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p> The name of the image recipe.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p> The description of the image recipe.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p> The description of the image recipe.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The semantic version of the image recipe. This version follows the semantic version syntax.</p>
        /// <note>
        /// <p>The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
        /// You can assign values for the first three, and can filter on all of them.</p>
        /// <p>
        /// <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including
        /// zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
        /// build number to the fourth node.</p>
        /// <p>
        /// <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for
        /// the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
        /// a date, such as 2021.01.01.</p>
        /// </note>
        pub fn semantic_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.semantic_version(inp);
            self
        }
        /// <p>The semantic version of the image recipe. This version follows the semantic version syntax.</p>
        /// <note>
        /// <p>The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
        /// You can assign values for the first three, and can filter on all of them.</p>
        /// <p>
        /// <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including
        /// zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
        /// build number to the fourth node.</p>
        /// <p>
        /// <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for
        /// the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
        /// a date, such as 2021.01.01.</p>
        /// </note>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_semantic_version(input);
            self
        }
        /// Appends an item to `components`.
        ///
        /// To override the contents of this collection use [`set_components`](Self::set_components).
        ///
        /// <p>The components of the image recipe.</p>
        pub fn components(mut self, inp: impl Into<crate::model::ComponentConfiguration>) -> Self {
            self.inner = self.inner.components(inp);
            self
        }
        /// <p>The components of the image recipe.</p>
        pub fn set_components(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComponentConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_components(input);
            self
        }
        /// <p>The base image of the image recipe. The value of the string can be the ARN of the base
        /// image or an AMI ID. The format for the ARN follows this example:
        /// <code>arn:aws:imagebuilder:us-west-2:aws:image/windows-server-2016-english-full-base-x86/x.x.x</code>.
        /// You can provide the specific version that you want to use, or you can use a wildcard in
        /// all of the fields. If you enter an AMI ID for the string value, you must have access to the AMI,
        /// and the AMI must be in the same Region in which you are using Image Builder.</p>
        pub fn parent_image(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_image(inp);
            self
        }
        /// <p>The base image of the image recipe. The value of the string can be the ARN of the base
        /// image or an AMI ID. The format for the ARN follows this example:
        /// <code>arn:aws:imagebuilder:us-west-2:aws:image/windows-server-2016-english-full-base-x86/x.x.x</code>.
        /// You can provide the specific version that you want to use, or you can use a wildcard in
        /// all of the fields. If you enter an AMI ID for the string value, you must have access to the AMI,
        /// and the AMI must be in the same Region in which you are using Image Builder.</p>
        pub fn set_parent_image(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_parent_image(input);
            self
        }
        /// Appends an item to `blockDeviceMappings`.
        ///
        /// To override the contents of this collection use [`set_block_device_mappings`](Self::set_block_device_mappings).
        ///
        /// <p>The block device mappings of the image recipe.</p>
        pub fn block_device_mappings(
            mut self,
            inp: impl Into<crate::model::InstanceBlockDeviceMapping>,
        ) -> Self {
            self.inner = self.inner.block_device_mappings(inp);
            self
        }
        /// <p>The block device mappings of the image recipe.</p>
        pub fn set_block_device_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceBlockDeviceMapping>>,
        ) -> Self {
            self.inner = self.inner.set_block_device_mappings(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags of the image recipe.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p> The tags of the image recipe.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The working directory used during build and test workflows.</p>
        pub fn working_directory(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.working_directory(inp);
            self
        }
        /// <p>The working directory used during build and test workflows.</p>
        pub fn set_working_directory(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_working_directory(input);
            self
        }
        /// <p>Specify additional settings and launch scripts for your build instances.</p>
        pub fn additional_instance_configuration(
            mut self,
            inp: crate::model::AdditionalInstanceConfiguration,
        ) -> Self {
            self.inner = self.inner.additional_instance_configuration(inp);
            self
        }
        /// <p>Specify additional settings and launch scripts for your build instances.</p>
        pub fn set_additional_instance_configuration(
            mut self,
            input: std::option::Option<crate::model::AdditionalInstanceConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_additional_instance_configuration(input);
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateInfrastructureConfiguration`.
    ///
    /// <p> Creates a new infrastructure configuration. An infrastructure configuration defines the
    /// environment in which your image will be built and tested.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateInfrastructureConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_infrastructure_configuration_input::Builder,
    }
    impl<C, M, R> CreateInfrastructureConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateInfrastructureConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateInfrastructureConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateInfrastructureConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateInfrastructureConfigurationInputOperationOutputAlias,
                crate::output::CreateInfrastructureConfigurationOutput,
                crate::error::CreateInfrastructureConfigurationError,
                crate::input::CreateInfrastructureConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the infrastructure configuration.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the infrastructure configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the infrastructure configuration.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the infrastructure configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `instanceTypes`.
        ///
        /// To override the contents of this collection use [`set_instance_types`](Self::set_instance_types).
        ///
        /// <p>The instance types of the infrastructure configuration. You can specify one or more
        /// instance types to use for this build. The service will pick one of these instance types based
        /// on availability.</p>
        pub fn instance_types(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_types(inp);
            self
        }
        /// <p>The instance types of the infrastructure configuration. You can specify one or more
        /// instance types to use for this build. The service will pick one of these instance types based
        /// on availability.</p>
        pub fn set_instance_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_instance_types(input);
            self
        }
        /// <p>The instance profile to associate with the instance used to customize your Amazon EC2 AMI.</p>
        pub fn instance_profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_profile_name(inp);
            self
        }
        /// <p>The instance profile to associate with the instance used to customize your Amazon EC2 AMI.</p>
        pub fn set_instance_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_profile_name(input);
            self
        }
        /// Appends an item to `securityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.</p>
        pub fn security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_ids(inp);
            self
        }
        /// <p>The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_ids(input);
            self
        }
        /// <p>The subnet ID in which to place the instance used to customize your Amazon EC2 AMI.</p>
        pub fn subnet_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_id(inp);
            self
        }
        /// <p>The subnet ID in which to place the instance used to customize your Amazon EC2 AMI.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subnet_id(input);
            self
        }
        /// <p>The logging configuration of the infrastructure configuration.</p>
        pub fn logging(mut self, inp: crate::model::Logging) -> Self {
            self.inner = self.inner.logging(inp);
            self
        }
        /// <p>The logging configuration of the infrastructure configuration.</p>
        pub fn set_logging(mut self, input: std::option::Option<crate::model::Logging>) -> Self {
            self.inner = self.inner.set_logging(input);
            self
        }
        /// <p>The key pair of the infrastructure configuration. You can use this to log on to and debug
        /// the instance used to create your image.</p>
        pub fn key_pair(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_pair(inp);
            self
        }
        /// <p>The key pair of the infrastructure configuration. You can use this to log on to and debug
        /// the instance used to create your image.</p>
        pub fn set_key_pair(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_pair(input);
            self
        }
        /// <p>The terminate instance on failure setting of the infrastructure configuration. Set to
        /// false if you want Image Builder to retain the instance used to configure your AMI if the build
        /// or test phase of your workflow fails.</p>
        pub fn terminate_instance_on_failure(mut self, inp: bool) -> Self {
            self.inner = self.inner.terminate_instance_on_failure(inp);
            self
        }
        /// <p>The terminate instance on failure setting of the infrastructure configuration. Set to
        /// false if you want Image Builder to retain the instance used to configure your AMI if the build
        /// or test phase of your workflow fails.</p>
        pub fn set_terminate_instance_on_failure(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_terminate_instance_on_failure(input);
            self
        }
        /// <p>The SNS topic on which to send image build events.</p>
        pub fn sns_topic_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_arn(inp);
            self
        }
        /// <p>The SNS topic on which to send image build events.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_arn(input);
            self
        }
        /// Adds a key-value pair to `resourceTags`.
        ///
        /// To override the contents of this collection use [`set_resource_tags`](Self::set_resource_tags).
        ///
        /// <p>The tags attached to the resource created by Image Builder.</p>
        pub fn resource_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.resource_tags(k, v);
            self
        }
        /// <p>The tags attached to the resource created by Image Builder.</p>
        pub fn set_resource_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_resource_tags(input);
            self
        }
        /// <p>The instance metadata options that you can set for the HTTP requests that
        /// pipeline builds use to launch EC2 build and test instances.</p>
        pub fn instance_metadata_options(
            mut self,
            inp: crate::model::InstanceMetadataOptions,
        ) -> Self {
            self.inner = self.inner.instance_metadata_options(inp);
            self
        }
        /// <p>The instance metadata options that you can set for the HTTP requests that
        /// pipeline builds use to launch EC2 build and test instances.</p>
        pub fn set_instance_metadata_options(
            mut self,
            input: std::option::Option<crate::model::InstanceMetadataOptions>,
        ) -> Self {
            self.inner = self.inner.set_instance_metadata_options(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags of the infrastructure configuration.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags of the infrastructure configuration.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteComponent`.
    ///
    /// <p> Deletes a component build version.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteComponent<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_component_input::Builder,
    }
    impl<C, M, R> DeleteComponent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteComponentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteComponentInputOperationOutputAlias,
                crate::output::DeleteComponentOutput,
                crate::error::DeleteComponentError,
                crate::input::DeleteComponentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the component build version to delete.</p>
        pub fn component_build_version_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_build_version_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the component build version to delete.</p>
        pub fn set_component_build_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_build_version_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteContainerRecipe`.
    ///
    /// <p>Deletes a container recipe.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteContainerRecipe<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_container_recipe_input::Builder,
    }
    impl<C, M, R> DeleteContainerRecipe<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteContainerRecipe`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteContainerRecipeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteContainerRecipeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteContainerRecipeInputOperationOutputAlias,
                crate::output::DeleteContainerRecipeOutput,
                crate::error::DeleteContainerRecipeError,
                crate::input::DeleteContainerRecipeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe to delete.</p>
        pub fn container_recipe_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_recipe_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe to delete.</p>
        pub fn set_container_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_recipe_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDistributionConfiguration`.
    ///
    /// <p> Deletes a distribution configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDistributionConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_distribution_configuration_input::Builder,
    }
    impl<C, M, R> DeleteDistributionConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDistributionConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDistributionConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDistributionConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDistributionConfigurationInputOperationOutputAlias,
                crate::output::DeleteDistributionConfigurationOutput,
                crate::error::DeleteDistributionConfigurationError,
                crate::input::DeleteDistributionConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration to delete.</p>
        pub fn distribution_configuration_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.distribution_configuration_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration to delete.</p>
        pub fn set_distribution_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_configuration_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteImage`.
    ///
    /// <p>Deletes an Image Builder image resource. This does not delete any EC2 AMIs or ECR container images
    /// that are created during the image build process. You must clean those up separately,
    /// using the appropriate Amazon EC2 or Amazon ECR console actions, or API or CLI commands.</p>
    /// <ul>
    /// <li>
    /// <p>To deregister an EC2 Linux AMI, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/deregister-ami.html">Deregister
    /// your Linux AMI</a> in the <i>
    /// <i>Amazon EC2 User Guide</i>
    /// </i>.</p>
    /// </li>
    /// <li>
    /// <p>To deregister an EC2 Windows AMI, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/deregister-ami.html">Deregister
    /// your Windows AMI</a> in the <i>
    /// <i>Amazon EC2 Windows Guide</i>
    /// </i>.</p>
    /// </li>
    /// <li>
    /// <p>To delete a container image from Amazon ECR, see <a href="https://docs.aws.amazon.com/https:/docs.aws.amazon.comAmazonECR/latest/userguide/delete_image.html">Deleting
    /// an image</a> in the <i>Amazon ECR User Guide</i>.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DeleteImage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_image_input::Builder,
    }
    impl<C, M, R> DeleteImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteImageOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteImageInputOperationOutputAlias,
                crate::output::DeleteImageOutput,
                crate::error::DeleteImageError,
                crate::input::DeleteImageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Image Builder image resource to delete.</p>
        pub fn image_build_version_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_build_version_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Image Builder image resource to delete.</p>
        pub fn set_image_build_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_build_version_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteImagePipeline`.
    ///
    /// <p> Deletes an image pipeline.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteImagePipeline<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_image_pipeline_input::Builder,
    }
    impl<C, M, R> DeleteImagePipeline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteImagePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteImagePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteImagePipelineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteImagePipelineInputOperationOutputAlias,
                crate::output::DeleteImagePipelineOutput,
                crate::error::DeleteImagePipelineError,
                crate::input::DeleteImagePipelineInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline to delete.</p>
        pub fn image_pipeline_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_pipeline_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline to delete.</p>
        pub fn set_image_pipeline_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_pipeline_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteImageRecipe`.
    ///
    /// <p> Deletes an image recipe.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteImageRecipe<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_image_recipe_input::Builder,
    }
    impl<C, M, R> DeleteImageRecipe<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteImageRecipe`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteImageRecipeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteImageRecipeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteImageRecipeInputOperationOutputAlias,
                crate::output::DeleteImageRecipeOutput,
                crate::error::DeleteImageRecipeError,
                crate::input::DeleteImageRecipeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe to delete.</p>
        pub fn image_recipe_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_recipe_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe to delete.</p>
        pub fn set_image_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_recipe_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteInfrastructureConfiguration`.
    ///
    /// <p> Deletes an infrastructure configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteInfrastructureConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_infrastructure_configuration_input::Builder,
    }
    impl<C, M, R> DeleteInfrastructureConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteInfrastructureConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInfrastructureConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteInfrastructureConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteInfrastructureConfigurationInputOperationOutputAlias,
                crate::output::DeleteInfrastructureConfigurationOutput,
                crate::error::DeleteInfrastructureConfigurationError,
                crate::input::DeleteInfrastructureConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration to delete.</p>
        pub fn infrastructure_configuration_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.infrastructure_configuration_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration to delete.</p>
        pub fn set_infrastructure_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_infrastructure_configuration_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetComponent`.
    ///
    /// <p> Gets a component object.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetComponent<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_component_input::Builder,
    }
    impl<C, M, R> GetComponent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetComponentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetComponentInputOperationOutputAlias,
                crate::output::GetComponentOutput,
                crate::error::GetComponentError,
                crate::input::GetComponentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the component that you want to retrieve. Regex requires
        /// "/\d+$" suffix.</p>
        pub fn component_build_version_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_build_version_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the component that you want to retrieve. Regex requires
        /// "/\d+$" suffix.</p>
        pub fn set_component_build_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_build_version_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetComponentPolicy`.
    ///
    /// <p> Gets a component policy.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetComponentPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_component_policy_input::Builder,
    }
    impl<C, M, R> GetComponentPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetComponentPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetComponentPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetComponentPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetComponentPolicyInputOperationOutputAlias,
                crate::output::GetComponentPolicyOutput,
                crate::error::GetComponentPolicyError,
                crate::input::GetComponentPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the component whose policy you want to retrieve.</p>
        pub fn component_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the component whose policy you want to retrieve.</p>
        pub fn set_component_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetContainerRecipe`.
    ///
    /// <p>Retrieves a container recipe.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetContainerRecipe<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_container_recipe_input::Builder,
    }
    impl<C, M, R> GetContainerRecipe<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetContainerRecipe`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContainerRecipeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContainerRecipeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetContainerRecipeInputOperationOutputAlias,
                crate::output::GetContainerRecipeOutput,
                crate::error::GetContainerRecipeError,
                crate::input::GetContainerRecipeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe to retrieve.</p>
        pub fn container_recipe_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_recipe_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe to retrieve.</p>
        pub fn set_container_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_recipe_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetContainerRecipePolicy`.
    ///
    /// <p>Retrieves the policy for a container recipe.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetContainerRecipePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_container_recipe_policy_input::Builder,
    }
    impl<C, M, R> GetContainerRecipePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetContainerRecipePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContainerRecipePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContainerRecipePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetContainerRecipePolicyInputOperationOutputAlias,
                crate::output::GetContainerRecipePolicyOutput,
                crate::error::GetContainerRecipePolicyError,
                crate::input::GetContainerRecipePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe for the policy being requested.</p>
        pub fn container_recipe_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_recipe_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe for the policy being requested.</p>
        pub fn set_container_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_recipe_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDistributionConfiguration`.
    ///
    /// <p> Gets a distribution configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDistributionConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_distribution_configuration_input::Builder,
    }
    impl<C, M, R> GetDistributionConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDistributionConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDistributionConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDistributionConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDistributionConfigurationInputOperationOutputAlias,
                crate::output::GetDistributionConfigurationOutput,
                crate::error::GetDistributionConfigurationError,
                crate::input::GetDistributionConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration that you want to
        /// retrieve.</p>
        pub fn distribution_configuration_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.distribution_configuration_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration that you want to
        /// retrieve.</p>
        pub fn set_distribution_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_configuration_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetImage`.
    ///
    /// <p> Gets an image.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetImage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_image_input::Builder,
    }
    impl<C, M, R> GetImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetImageOutput,
            aws_smithy_http::result::SdkError<crate::error::GetImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetImageInputOperationOutputAlias,
                crate::output::GetImageOutput,
                crate::error::GetImageError,
                crate::input::GetImageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the image that you want to retrieve.</p>
        pub fn image_build_version_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_build_version_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image that you want to retrieve.</p>
        pub fn set_image_build_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_build_version_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetImagePipeline`.
    ///
    /// <p> Gets an image pipeline.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetImagePipeline<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_image_pipeline_input::Builder,
    }
    impl<C, M, R> GetImagePipeline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetImagePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetImagePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::GetImagePipelineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetImagePipelineInputOperationOutputAlias,
                crate::output::GetImagePipelineOutput,
                crate::error::GetImagePipelineError,
                crate::input::GetImagePipelineInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline that you want to retrieve.</p>
        pub fn image_pipeline_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_pipeline_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline that you want to retrieve.</p>
        pub fn set_image_pipeline_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_pipeline_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetImagePolicy`.
    ///
    /// <p> Gets an image policy.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetImagePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_image_policy_input::Builder,
    }
    impl<C, M, R> GetImagePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetImagePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetImagePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetImagePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetImagePolicyInputOperationOutputAlias,
                crate::output::GetImagePolicyOutput,
                crate::error::GetImagePolicyError,
                crate::input::GetImagePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the image whose policy you want to retrieve.</p>
        pub fn image_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image whose policy you want to retrieve.</p>
        pub fn set_image_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetImageRecipe`.
    ///
    /// <p> Gets an image recipe.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetImageRecipe<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_image_recipe_input::Builder,
    }
    impl<C, M, R> GetImageRecipe<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetImageRecipe`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetImageRecipeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetImageRecipeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetImageRecipeInputOperationOutputAlias,
                crate::output::GetImageRecipeOutput,
                crate::error::GetImageRecipeError,
                crate::input::GetImageRecipeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe that you want to retrieve.</p>
        pub fn image_recipe_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_recipe_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe that you want to retrieve.</p>
        pub fn set_image_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_recipe_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetImageRecipePolicy`.
    ///
    /// <p> Gets an image recipe policy.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetImageRecipePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_image_recipe_policy_input::Builder,
    }
    impl<C, M, R> GetImageRecipePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetImageRecipePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetImageRecipePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetImageRecipePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetImageRecipePolicyInputOperationOutputAlias,
                crate::output::GetImageRecipePolicyOutput,
                crate::error::GetImageRecipePolicyError,
                crate::input::GetImageRecipePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe whose policy you want to retrieve.</p>
        pub fn image_recipe_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_recipe_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe whose policy you want to retrieve.</p>
        pub fn set_image_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_recipe_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInfrastructureConfiguration`.
    ///
    /// <p> Gets an infrastructure configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetInfrastructureConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_infrastructure_configuration_input::Builder,
    }
    impl<C, M, R> GetInfrastructureConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInfrastructureConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInfrastructureConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInfrastructureConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInfrastructureConfigurationInputOperationOutputAlias,
                crate::output::GetInfrastructureConfigurationOutput,
                crate::error::GetInfrastructureConfigurationError,
                crate::input::GetInfrastructureConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that you want to
        /// retrieve.</p>
        pub fn infrastructure_configuration_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.infrastructure_configuration_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that you want to
        /// retrieve.</p>
        pub fn set_infrastructure_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_infrastructure_configuration_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportComponent`.
    ///
    /// <p>Imports a component and transforms its data into a component document.</p>
    #[derive(std::fmt::Debug)]
    pub struct ImportComponent<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::import_component_input::Builder,
    }
    impl<C, M, R> ImportComponent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ImportComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportComponentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ImportComponentInputOperationOutputAlias,
                crate::output::ImportComponentOutput,
                crate::error::ImportComponentError,
                crate::input::ImportComponentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the component.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p> The name of the component.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The semantic version of the component. This version follows the semantic version syntax.</p>
        /// <note>
        /// <p>The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
        /// You can assign values for the first three, and can filter on all of them.</p>
        /// <p>
        /// <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x)
        /// to specify the most recent versions or nodes when selecting the base image or components for your
        /// recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be
        /// wildcards.</p>
        /// </note>
        pub fn semantic_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.semantic_version(inp);
            self
        }
        /// <p>The semantic version of the component. This version follows the semantic version syntax.</p>
        /// <note>
        /// <p>The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
        /// You can assign values for the first three, and can filter on all of them.</p>
        /// <p>
        /// <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x)
        /// to specify the most recent versions or nodes when selecting the base image or components for your
        /// recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be
        /// wildcards.</p>
        /// </note>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_semantic_version(input);
            self
        }
        /// <p>The description of the component. Describes the contents of the component.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the component. Describes the contents of the component.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The change description of the component. Describes what change has been made in this
        /// version, or what makes this version different from other versions of this component.</p>
        pub fn change_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_description(inp);
            self
        }
        /// <p>The change description of the component. Describes what change has been made in this
        /// version, or what makes this version different from other versions of this component.</p>
        pub fn set_change_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_change_description(input);
            self
        }
        /// <p>The type of the component denotes whether the component is used to build the image, or only
        /// to test it.</p>
        pub fn r#type(mut self, inp: crate::model::ComponentType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of the component denotes whether the component is used to build the image, or only
        /// to test it.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ComponentType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The format of the resource that you want to import as a component.</p>
        pub fn format(mut self, inp: crate::model::ComponentFormat) -> Self {
            self.inner = self.inner.format(inp);
            self
        }
        /// <p>The format of the resource that you want to import as a component.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::ComponentFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p>The platform of the component.</p>
        pub fn platform(mut self, inp: crate::model::Platform) -> Self {
            self.inner = self.inner.platform(inp);
            self
        }
        /// <p>The platform of the component.</p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.inner = self.inner.set_platform(input);
            self
        }
        /// <p>The data of the component. Used to specify the data inline. Either <code>data</code> or
        /// <code>uri</code> can be used to specify the data within the component.</p>
        pub fn data(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data(inp);
            self
        }
        /// <p>The data of the component. Used to specify the data inline. Either <code>data</code> or
        /// <code>uri</code> can be used to specify the data within the component.</p>
        pub fn set_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data(input);
            self
        }
        /// <p>The uri of the component. Must be an Amazon S3 URL and the requester must have permission to
        /// access the Amazon S3 bucket. If you use Amazon S3, you can specify component content up to your service
        /// quota. Either <code>data</code> or <code>uri</code> can be used to specify the data within the
        /// component.</p>
        pub fn uri(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.uri(inp);
            self
        }
        /// <p>The uri of the component. Must be an Amazon S3 URL and the requester must have permission to
        /// access the Amazon S3 bucket. If you use Amazon S3, you can specify component content up to your service
        /// quota. Either <code>data</code> or <code>uri</code> can be used to specify the data within the
        /// component.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_uri(input);
            self
        }
        /// <p>The ID of the KMS key that should be used to encrypt this component.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The ID of the KMS key that should be used to encrypt this component.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags of the component.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags of the component.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The idempotency token of the component.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>The idempotency token of the component.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListComponentBuildVersions`.
    ///
    /// <p> Returns the list of component build versions for the specified semantic version.</p>
    /// <note>
    /// <p>The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
    /// You can assign values for the first three, and can filter on all of them.</p>
    /// <p>
    /// <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x)
    /// to specify the most recent versions or nodes when selecting the base image or components for your
    /// recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be
    /// wildcards.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListComponentBuildVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_component_build_versions_input::Builder,
    }
    impl<C, M, R> ListComponentBuildVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListComponentBuildVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListComponentBuildVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListComponentBuildVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListComponentBuildVersionsInputOperationOutputAlias,
                crate::output::ListComponentBuildVersionsOutput,
                crate::error::ListComponentBuildVersionsError,
                crate::input::ListComponentBuildVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The component version Amazon Resource Name (ARN) whose versions you want to list.</p>
        pub fn component_version_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_version_arn(inp);
            self
        }
        /// <p>The component version Amazon Resource Name (ARN) whose versions you want to list.</p>
        pub fn set_component_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_version_arn(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously
        /// truncated response.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously
        /// truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListComponents`.
    ///
    /// <p>Returns the list of component build versions for the specified semantic version.</p>
    /// <note>
    /// <p>The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
    /// You can assign values for the first three, and can filter on all of them.</p>
    /// <p>
    /// <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x)
    /// to specify the most recent versions or nodes when selecting the base image or components for your
    /// recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be
    /// wildcards.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListComponents<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_components_input::Builder,
    }
    impl<C, M, R> ListComponents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListComponents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListComponentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListComponentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListComponentsInputOperationOutputAlias,
                crate::output::ListComponentsOutput,
                crate::error::ListComponentsError,
                crate::input::ListComponentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The owner defines which components you want to list. By default, this request will only
        /// show components owned by your account. You can use this field to specify if you want to view
        /// components owned by yourself, by Amazon, or those components that have been shared with you by
        /// other customers.</p>
        pub fn owner(mut self, inp: crate::model::Ownership) -> Self {
            self.inner = self.inner.owner(inp);
            self
        }
        /// <p>The owner defines which components you want to list. By default, this request will only
        /// show components owned by your account. You can use this field to specify if you want to view
        /// components owned by yourself, by Amazon, or those components that have been shared with you by
        /// other customers.</p>
        pub fn set_owner(mut self, input: std::option::Option<crate::model::Ownership>) -> Self {
            self.inner = self.inner.set_owner(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>description</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>name</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>platform</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>supportedOsVersion</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>type</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>version</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>description</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>name</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>platform</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>supportedOsVersion</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>type</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>version</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Returns the list of component build versions for the specified name.</p>
        pub fn by_name(mut self, inp: bool) -> Self {
            self.inner = self.inner.by_name(inp);
            self
        }
        /// <p>Returns the list of component build versions for the specified name.</p>
        pub fn set_by_name(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_by_name(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously
        /// truncated response.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously
        /// truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListContainerRecipes`.
    ///
    /// <p>Returns a list of container recipes.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListContainerRecipes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_container_recipes_input::Builder,
    }
    impl<C, M, R> ListContainerRecipes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListContainerRecipes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListContainerRecipesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListContainerRecipesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListContainerRecipesInputOperationOutputAlias,
                crate::output::ListContainerRecipesOutput,
                crate::error::ListContainerRecipesError,
                crate::input::ListContainerRecipesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Returns container recipes belonging to the specified owner, that have been shared with you. You can omit this field to return container recipes belonging to your account.</p>
        pub fn owner(mut self, inp: crate::model::Ownership) -> Self {
            self.inner = self.inner.owner(inp);
            self
        }
        /// <p>Returns container recipes belonging to the specified owner, that have been shared with you. You can omit this field to return container recipes belonging to your account.</p>
        pub fn set_owner(mut self, input: std::option::Option<crate::model::Ownership>) -> Self {
            self.inner = self.inner.set_owner(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>containerType</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>name</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>parentImage</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>platform</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>containerType</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>name</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>parentImage</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>platform</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of results to return in the list.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in the list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Provides a token for pagination, which determines where to begin the next set of results when the current set reaches the maximum for one request.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Provides a token for pagination, which determines where to begin the next set of results when the current set reaches the maximum for one request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDistributionConfigurations`.
    ///
    /// <p>Returns a list of distribution configurations.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDistributionConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_distribution_configurations_input::Builder,
    }
    impl<C, M, R> ListDistributionConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDistributionConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDistributionConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDistributionConfigurationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDistributionConfigurationsInputOperationOutputAlias,
                crate::output::ListDistributionConfigurationsOutput,
                crate::error::ListDistributionConfigurationsError,
                crate::input::ListDistributionConfigurationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>You can filter on <code>name</code> to streamline results.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>You can filter on <code>name</code> to streamline results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously
        /// truncated response.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously
        /// truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListImageBuildVersions`.
    ///
    /// <p> Returns a list of image build versions.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListImageBuildVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_image_build_versions_input::Builder,
    }
    impl<C, M, R> ListImageBuildVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListImageBuildVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListImageBuildVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListImageBuildVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListImageBuildVersionsInputOperationOutputAlias,
                crate::output::ListImageBuildVersionsOutput,
                crate::error::ListImageBuildVersionsError,
                crate::input::ListImageBuildVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the image whose build versions you want to retrieve.</p>
        pub fn image_version_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_version_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image whose build versions you want to retrieve.</p>
        pub fn set_image_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_version_arn(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>name</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>osVersion</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>platform</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>type</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>version</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>name</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>osVersion</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>platform</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>type</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>version</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously
        /// truncated response.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously
        /// truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListImagePackages`.
    ///
    /// <p>List the Packages that are associated with an Image Build Version, as determined by Amazon Web Services Systems Manager Inventory at build time.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListImagePackages<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_image_packages_input::Builder,
    }
    impl<C, M, R> ListImagePackages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListImagePackages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListImagePackagesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListImagePackagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListImagePackagesInputOperationOutputAlias,
                crate::output::ListImagePackagesOutput,
                crate::error::ListImagePackagesError,
                crate::input::ListImagePackagesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Filter results for the ListImagePackages request by the Image Build Version ARN</p>
        pub fn image_build_version_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_build_version_arn(inp);
            self
        }
        /// <p>Filter results for the ListImagePackages request by the Image Build Version ARN</p>
        pub fn set_image_build_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_build_version_arn(input);
            self
        }
        /// <p>The maxiumum number of results to return from the ListImagePackages request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maxiumum number of results to return from the ListImagePackages request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListImagePipelineImages`.
    ///
    /// <p> Returns a list of images created by the specified pipeline.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListImagePipelineImages<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_image_pipeline_images_input::Builder,
    }
    impl<C, M, R> ListImagePipelineImages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListImagePipelineImages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListImagePipelineImagesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListImagePipelineImagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListImagePipelineImagesInputOperationOutputAlias,
                crate::output::ListImagePipelineImagesOutput,
                crate::error::ListImagePipelineImagesError,
                crate::input::ListImagePipelineImagesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline whose images you want to view.</p>
        pub fn image_pipeline_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_pipeline_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline whose images you want to view.</p>
        pub fn set_image_pipeline_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_pipeline_arn(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>name</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>version</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>name</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>version</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously
        /// truncated response.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously
        /// truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListImagePipelines`.
    ///
    /// <p>Returns a list of image pipelines.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListImagePipelines<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_image_pipelines_input::Builder,
    }
    impl<C, M, R> ListImagePipelines<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListImagePipelines`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListImagePipelinesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListImagePipelinesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListImagePipelinesInputOperationOutputAlias,
                crate::output::ListImagePipelinesOutput,
                crate::error::ListImagePipelinesError,
                crate::input::ListImagePipelinesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>description</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>distributionConfigurationArn</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>imageRecipeArn</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>infrastructureConfigurationArn</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>name</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>status</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>description</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>distributionConfigurationArn</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>imageRecipeArn</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>infrastructureConfigurationArn</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>name</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>status</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously
        /// truncated response.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously
        /// truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListImageRecipes`.
    ///
    /// <p> Returns a list of image recipes.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListImageRecipes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_image_recipes_input::Builder,
    }
    impl<C, M, R> ListImageRecipes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListImageRecipes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListImageRecipesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListImageRecipesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListImageRecipesInputOperationOutputAlias,
                crate::output::ListImageRecipesOutput,
                crate::error::ListImageRecipesError,
                crate::input::ListImageRecipesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The owner defines which image recipes you want to list. By default, this request will only
        /// show image recipes owned by your account. You can use this field to specify if you want to
        /// view image recipes owned by yourself, by Amazon, or those image recipes that have been shared
        /// with you by other customers.</p>
        pub fn owner(mut self, inp: crate::model::Ownership) -> Self {
            self.inner = self.inner.owner(inp);
            self
        }
        /// <p>The owner defines which image recipes you want to list. By default, this request will only
        /// show image recipes owned by your account. You can use this field to specify if you want to
        /// view image recipes owned by yourself, by Amazon, or those image recipes that have been shared
        /// with you by other customers.</p>
        pub fn set_owner(mut self, input: std::option::Option<crate::model::Ownership>) -> Self {
            self.inner = self.inner.set_owner(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>name</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>parentImage</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>platform</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>name</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>parentImage</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>platform</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously
        /// truncated response.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously
        /// truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListImages`.
    ///
    /// <p> Returns the list of images that you have access to.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListImages<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_images_input::Builder,
    }
    impl<C, M, R> ListImages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListImages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListImagesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListImagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListImagesInputOperationOutputAlias,
                crate::output::ListImagesOutput,
                crate::error::ListImagesError,
                crate::input::ListImagesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The owner defines which images you want to list. By default, this request will only show
        /// images owned by your account. You can use this field to specify if you want to view images
        /// owned by yourself, by Amazon, or those images that have been shared with you by other
        /// customers.</p>
        pub fn owner(mut self, inp: crate::model::Ownership) -> Self {
            self.inner = self.inner.owner(inp);
            self
        }
        /// <p>The owner defines which images you want to list. By default, this request will only show
        /// images owned by your account. You can use this field to specify if you want to view images
        /// owned by yourself, by Amazon, or those images that have been shared with you by other
        /// customers.</p>
        pub fn set_owner(mut self, input: std::option::Option<crate::model::Ownership>) -> Self {
            self.inner = self.inner.set_owner(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>name</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>osVersion</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>platform</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>type</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>version</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>name</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>osVersion</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>platform</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>type</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>version</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Requests a list of images with a specific recipe name.</p>
        pub fn by_name(mut self, inp: bool) -> Self {
            self.inner = self.inner.by_name(inp);
            self
        }
        /// <p>Requests a list of images with a specific recipe name.</p>
        pub fn set_by_name(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_by_name(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously
        /// truncated response.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously
        /// truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Includes deprecated images in the response list.</p>
        pub fn include_deprecated(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_deprecated(inp);
            self
        }
        /// <p>Includes deprecated images in the response list.</p>
        pub fn set_include_deprecated(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_deprecated(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInfrastructureConfigurations`.
    ///
    /// <p> Returns a list of infrastructure configurations.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListInfrastructureConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_infrastructure_configurations_input::Builder,
    }
    impl<C, M, R> ListInfrastructureConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListInfrastructureConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInfrastructureConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInfrastructureConfigurationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListInfrastructureConfigurationsInputOperationOutputAlias,
                crate::output::ListInfrastructureConfigurationsOutput,
                crate::error::ListInfrastructureConfigurationsError,
                crate::input::ListInfrastructureConfigurationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>You can filter on <code>name</code> to streamline results.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>You can filter on <code>name</code> to streamline results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously
        /// truncated response.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously
        /// truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p> Returns the list of tags for the specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags you want to retrieve.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags you want to retrieve.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutComponentPolicy`.
    ///
    /// <p> Applies a policy to a component. We recommend that you call the RAM API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a> to share resources. If you call the Image Builder API
    /// <code>PutComponentPolicy</code>, you must also call the RAM API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html">PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to
    /// all principals with whom the resource is shared.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutComponentPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_component_policy_input::Builder,
    }
    impl<C, M, R> PutComponentPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutComponentPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutComponentPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutComponentPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutComponentPolicyInputOperationOutputAlias,
                crate::output::PutComponentPolicyOutput,
                crate::error::PutComponentPolicyError,
                crate::input::PutComponentPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the component that this policy should be applied to.</p>
        pub fn component_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the component that this policy should be applied to.</p>
        pub fn set_component_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_arn(input);
            self
        }
        /// <p>The policy to apply.</p>
        pub fn policy(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(inp);
            self
        }
        /// <p>The policy to apply.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutContainerRecipePolicy`.
    ///
    /// <p>Applies a policy to a container image. We recommend that you call the RAM API CreateResourceShare (https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you call the Image Builder API <code>PutContainerImagePolicy</code>, you must also call the RAM API PromoteResourceShareCreatedFromPolicy (https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for the resource to be visible to all principals with whom the resource is shared.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutContainerRecipePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_container_recipe_policy_input::Builder,
    }
    impl<C, M, R> PutContainerRecipePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutContainerRecipePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutContainerRecipePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutContainerRecipePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutContainerRecipePolicyInputOperationOutputAlias,
                crate::output::PutContainerRecipePolicyOutput,
                crate::error::PutContainerRecipePolicyError,
                crate::input::PutContainerRecipePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe that this policy should be applied to.</p>
        pub fn container_recipe_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_recipe_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe that this policy should be applied to.</p>
        pub fn set_container_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_recipe_arn(input);
            self
        }
        /// <p>The policy to apply to the container recipe.</p>
        pub fn policy(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(inp);
            self
        }
        /// <p>The policy to apply to the container recipe.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutImagePolicy`.
    ///
    /// <p>Applies a policy to an image. We recommend that you call the RAM API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a> to share resources. If you call the Image Builder API
    /// <code>PutImagePolicy</code>, you must also call the RAM API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html">PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to
    /// all principals with whom the resource is shared.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutImagePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_image_policy_input::Builder,
    }
    impl<C, M, R> PutImagePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutImagePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutImagePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutImagePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutImagePolicyInputOperationOutputAlias,
                crate::output::PutImagePolicyOutput,
                crate::error::PutImagePolicyError,
                crate::input::PutImagePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the image that this policy should be applied to.</p>
        pub fn image_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image that this policy should be applied to.</p>
        pub fn set_image_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_arn(input);
            self
        }
        /// <p>The policy to apply.</p>
        pub fn policy(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(inp);
            self
        }
        /// <p>The policy to apply.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutImageRecipePolicy`.
    ///
    /// <p> Applies a policy to an image recipe. We recommend that you call the RAM API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a> to share resources. If you call the Image Builder API
    /// <code>PutImageRecipePolicy</code>, you must also call the RAM API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html">PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to
    /// all principals with whom the resource is shared.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutImageRecipePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_image_recipe_policy_input::Builder,
    }
    impl<C, M, R> PutImageRecipePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutImageRecipePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutImageRecipePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutImageRecipePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutImageRecipePolicyInputOperationOutputAlias,
                crate::output::PutImageRecipePolicyOutput,
                crate::error::PutImageRecipePolicyError,
                crate::input::PutImageRecipePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe that this policy should be applied to.</p>
        pub fn image_recipe_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_recipe_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe that this policy should be applied to.</p>
        pub fn set_image_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_recipe_arn(input);
            self
        }
        /// <p>The policy to apply.</p>
        pub fn policy(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(inp);
            self
        }
        /// <p>The policy to apply.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartImagePipelineExecution`.
    ///
    /// <p> Manually triggers a pipeline to create an image.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartImagePipelineExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_image_pipeline_execution_input::Builder,
    }
    impl<C, M, R> StartImagePipelineExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartImagePipelineExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartImagePipelineExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartImagePipelineExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartImagePipelineExecutionInputOperationOutputAlias,
                crate::output::StartImagePipelineExecutionOutput,
                crate::error::StartImagePipelineExecutionError,
                crate::input::StartImagePipelineExecutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline that you want to manually invoke.</p>
        pub fn image_pipeline_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_pipeline_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline that you want to manually invoke.</p>
        pub fn set_image_pipeline_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_pipeline_arn(input);
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p> Adds a tag to a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to tag.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags to apply to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p> Removes a tag from a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to untag.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to untag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys to remove from the resource.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The tag keys to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDistributionConfiguration`.
    ///
    /// <p> Updates a new distribution configuration. Distribution configurations define and
    /// configure the outputs of your pipeline.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDistributionConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_distribution_configuration_input::Builder,
    }
    impl<C, M, R> UpdateDistributionConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDistributionConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDistributionConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDistributionConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDistributionConfigurationInputOperationOutputAlias,
                crate::output::UpdateDistributionConfigurationOutput,
                crate::error::UpdateDistributionConfigurationError,
                crate::input::UpdateDistributionConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration that you want to update.</p>
        pub fn distribution_configuration_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.distribution_configuration_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration that you want to update.</p>
        pub fn set_distribution_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_configuration_arn(input);
            self
        }
        /// <p>The description of the distribution configuration.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the distribution configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `distributions`.
        ///
        /// To override the contents of this collection use [`set_distributions`](Self::set_distributions).
        ///
        /// <p>The distributions of the distribution configuration.</p>
        pub fn distributions(mut self, inp: impl Into<crate::model::Distribution>) -> Self {
            self.inner = self.inner.distributions(inp);
            self
        }
        /// <p>The distributions of the distribution configuration.</p>
        pub fn set_distributions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Distribution>>,
        ) -> Self {
            self.inner = self.inner.set_distributions(input);
            self
        }
        /// <p>The idempotency token of the distribution configuration.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>The idempotency token of the distribution configuration.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateImagePipeline`.
    ///
    /// <p> Updates an image pipeline. Image pipelines enable you to automate the creation and
    /// distribution of images.</p>
    /// <note>
    /// <p>UpdateImagePipeline does not support selective updates for the pipeline.
    /// You must specify all of the required properties in the update request, not just
    /// the properties that have changed.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct UpdateImagePipeline<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_image_pipeline_input::Builder,
    }
    impl<C, M, R> UpdateImagePipeline<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateImagePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateImagePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateImagePipelineError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateImagePipelineInputOperationOutputAlias,
                crate::output::UpdateImagePipelineOutput,
                crate::error::UpdateImagePipelineError,
                crate::input::UpdateImagePipelineInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline that you want to update.</p>
        pub fn image_pipeline_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_pipeline_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline that you want to update.</p>
        pub fn set_image_pipeline_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_pipeline_arn(input);
            self
        }
        /// <p>The description of the image pipeline.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the image pipeline.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe that will be used to configure images
        /// updated by this image pipeline.</p>
        pub fn image_recipe_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_recipe_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe that will be used to configure images
        /// updated by this image pipeline.</p>
        pub fn set_image_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_recipe_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container pipeline to update.</p>
        pub fn container_recipe_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_recipe_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container pipeline to update.</p>
        pub fn set_container_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_recipe_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to
        /// build images updated by this image pipeline.</p>
        pub fn infrastructure_configuration_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.infrastructure_configuration_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to
        /// build images updated by this image pipeline.</p>
        pub fn set_infrastructure_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_infrastructure_configuration_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration that will be used to
        /// configure and distribute images updated by this image pipeline.</p>
        pub fn distribution_configuration_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.distribution_configuration_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration that will be used to
        /// configure and distribute images updated by this image pipeline.</p>
        pub fn set_distribution_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_configuration_arn(input);
            self
        }
        /// <p>The image test configuration of the image pipeline.</p>
        pub fn image_tests_configuration(
            mut self,
            inp: crate::model::ImageTestsConfiguration,
        ) -> Self {
            self.inner = self.inner.image_tests_configuration(inp);
            self
        }
        /// <p>The image test configuration of the image pipeline.</p>
        pub fn set_image_tests_configuration(
            mut self,
            input: std::option::Option<crate::model::ImageTestsConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_image_tests_configuration(input);
            self
        }
        /// <p> Collects additional information about the image being created, including the operating
        /// system (OS) version and package list. This information is used to enhance the overall
        /// experience of using EC2 Image Builder. Enabled by default.</p>
        pub fn enhanced_image_metadata_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.enhanced_image_metadata_enabled(inp);
            self
        }
        /// <p> Collects additional information about the image being created, including the operating
        /// system (OS) version and package list. This information is used to enhance the overall
        /// experience of using EC2 Image Builder. Enabled by default.</p>
        pub fn set_enhanced_image_metadata_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enhanced_image_metadata_enabled(input);
            self
        }
        /// <p>The schedule of the image pipeline.</p>
        pub fn schedule(mut self, inp: crate::model::Schedule) -> Self {
            self.inner = self.inner.schedule(inp);
            self
        }
        /// <p>The schedule of the image pipeline.</p>
        pub fn set_schedule(mut self, input: std::option::Option<crate::model::Schedule>) -> Self {
            self.inner = self.inner.set_schedule(input);
            self
        }
        /// <p>The status of the image pipeline.</p>
        pub fn status(mut self, inp: crate::model::PipelineStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>The status of the image pipeline.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PipelineStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateInfrastructureConfiguration`.
    ///
    /// <p> Updates a new infrastructure configuration. An infrastructure configuration defines the
    /// environment in which your image will be built and tested.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateInfrastructureConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_infrastructure_configuration_input::Builder,
    }
    impl<C, M, R> UpdateInfrastructureConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateInfrastructureConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateInfrastructureConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateInfrastructureConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateInfrastructureConfigurationInputOperationOutputAlias,
                crate::output::UpdateInfrastructureConfigurationOutput,
                crate::error::UpdateInfrastructureConfigurationError,
                crate::input::UpdateInfrastructureConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that you want to
        /// update.</p>
        pub fn infrastructure_configuration_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.infrastructure_configuration_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that you want to
        /// update.</p>
        pub fn set_infrastructure_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_infrastructure_configuration_arn(input);
            self
        }
        /// <p>The description of the infrastructure configuration.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the infrastructure configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `instanceTypes`.
        ///
        /// To override the contents of this collection use [`set_instance_types`](Self::set_instance_types).
        ///
        /// <p>The instance types of the infrastructure configuration. You can specify one or more
        /// instance types to use for this build. The service will pick one of these instance types based
        /// on availability.</p>
        pub fn instance_types(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_types(inp);
            self
        }
        /// <p>The instance types of the infrastructure configuration. You can specify one or more
        /// instance types to use for this build. The service will pick one of these instance types based
        /// on availability.</p>
        pub fn set_instance_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_instance_types(input);
            self
        }
        /// <p>The instance profile to associate with the instance used to customize your Amazon EC2 AMI.</p>
        pub fn instance_profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_profile_name(inp);
            self
        }
        /// <p>The instance profile to associate with the instance used to customize your Amazon EC2 AMI.</p>
        pub fn set_instance_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_profile_name(input);
            self
        }
        /// Appends an item to `securityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.</p>
        pub fn security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_ids(inp);
            self
        }
        /// <p>The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_ids(input);
            self
        }
        /// <p>The subnet ID to place the instance used to customize your Amazon EC2 AMI in.</p>
        pub fn subnet_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_id(inp);
            self
        }
        /// <p>The subnet ID to place the instance used to customize your Amazon EC2 AMI in.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subnet_id(input);
            self
        }
        /// <p>The logging configuration of the infrastructure configuration.</p>
        pub fn logging(mut self, inp: crate::model::Logging) -> Self {
            self.inner = self.inner.logging(inp);
            self
        }
        /// <p>The logging configuration of the infrastructure configuration.</p>
        pub fn set_logging(mut self, input: std::option::Option<crate::model::Logging>) -> Self {
            self.inner = self.inner.set_logging(input);
            self
        }
        /// <p>The key pair of the infrastructure configuration. You can use this to log on to and debug
        /// the instance used to create your image.</p>
        pub fn key_pair(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_pair(inp);
            self
        }
        /// <p>The key pair of the infrastructure configuration. You can use this to log on to and debug
        /// the instance used to create your image.</p>
        pub fn set_key_pair(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_pair(input);
            self
        }
        /// <p>The terminate instance on failure setting of the infrastructure configuration. Set to
        /// false if you want Image Builder to retain the instance used to configure your AMI if the build
        /// or test phase of your workflow fails.</p>
        pub fn terminate_instance_on_failure(mut self, inp: bool) -> Self {
            self.inner = self.inner.terminate_instance_on_failure(inp);
            self
        }
        /// <p>The terminate instance on failure setting of the infrastructure configuration. Set to
        /// false if you want Image Builder to retain the instance used to configure your AMI if the build
        /// or test phase of your workflow fails.</p>
        pub fn set_terminate_instance_on_failure(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_terminate_instance_on_failure(input);
            self
        }
        /// <p>The SNS topic on which to send image build events.</p>
        pub fn sns_topic_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_arn(inp);
            self
        }
        /// <p>The SNS topic on which to send image build events.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_arn(input);
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `resourceTags`.
        ///
        /// To override the contents of this collection use [`set_resource_tags`](Self::set_resource_tags).
        ///
        /// <p>The tags attached to the resource created by Image Builder.</p>
        pub fn resource_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.resource_tags(k, v);
            self
        }
        /// <p>The tags attached to the resource created by Image Builder.</p>
        pub fn set_resource_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_resource_tags(input);
            self
        }
        /// <p>The instance metadata options that you can set for the HTTP requests that pipeline builds
        /// use to launch EC2 build and test instances. For more information about instance metadata
        /// options, see one of the following links:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-options.html">Configure
        /// the instance metadata options</a> in the <i>
        /// <i>Amazon EC2 User Guide</i>
        /// </i>
        /// for Linux instances.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/configuring-instance-metadata-options.html">Configure
        /// the instance metadata options</a> in the <i>
        /// <i>Amazon EC2 Windows Guide</i>
        /// </i>
        /// for Windows instances.</p>
        /// </li>
        /// </ul>
        pub fn instance_metadata_options(
            mut self,
            inp: crate::model::InstanceMetadataOptions,
        ) -> Self {
            self.inner = self.inner.instance_metadata_options(inp);
            self
        }
        /// <p>The instance metadata options that you can set for the HTTP requests that pipeline builds
        /// use to launch EC2 build and test instances. For more information about instance metadata
        /// options, see one of the following links:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-options.html">Configure
        /// the instance metadata options</a> in the <i>
        /// <i>Amazon EC2 User Guide</i>
        /// </i>
        /// for Linux instances.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/configuring-instance-metadata-options.html">Configure
        /// the instance metadata options</a> in the <i>
        /// <i>Amazon EC2 Windows Guide</i>
        /// </i>
        /// for Windows instances.</p>
        /// </li>
        /// </ul>
        pub fn set_instance_metadata_options(
            mut self,
            input: std::option::Option<crate::model::InstanceMetadataOptions>,
        ) -> Self {
            self.inner = self.inner.set_instance_metadata_options(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
