// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CancelImageCreationInput`](crate::input::CancelImageCreationInput)
pub mod cancel_image_creation_input {
    /// A builder for [`CancelImageCreationInput`](crate::input::CancelImageCreationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_build_version_arn: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the image whose creation you want to cancel.</p>
        pub fn image_build_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_build_version_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image whose creation you want to cancel.</p>
        pub fn set_image_build_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_build_version_arn = input;
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelImageCreationInput`](crate::input::CancelImageCreationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelImageCreationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelImageCreationInput {
                image_build_version_arn: self.image_build_version_arn,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelImageCreationInputOperationOutputAlias = crate::operation::CancelImageCreation;
#[doc(hidden)]
pub type CancelImageCreationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelImageCreationInput {
    /// Consumes the builder and constructs an Operation<[`CancelImageCreation`](crate::operation::CancelImageCreation)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelImageCreation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CancelImageCreationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/CancelImageCreation").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CancelImageCreationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_cancel_image_creation(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelImageCreation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelImageCreation",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CancelImageCreationInput`](crate::input::CancelImageCreationInput)
    pub fn builder() -> crate::input::cancel_image_creation_input::Builder {
        crate::input::cancel_image_creation_input::Builder::default()
    }
}

/// See [`CreateComponentInput`](crate::input::CreateComponentInput)
pub mod create_component_input {
    /// A builder for [`CreateComponentInput`](crate::input::CreateComponentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) semantic_version: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) change_description: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<crate::model::Platform>,
        pub(crate) supported_os_versions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) data: std::option::Option<std::string::String>,
        pub(crate) uri: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the component.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The semantic version of the component. This version follows the semantic version syntax.</p> <note>
        /// <p>The semantic version has four nodes: <major>
        /// .
        /// <minor>
        /// .
        /// <patch>
        /// /
        /// <build>
        /// . You can assign values for the first three, and can filter on all of them.
        /// </build>
        /// </patch>
        /// </minor>
        /// </major></p>
        /// <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p>
        /// <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p>
        /// </note>
        pub fn semantic_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.semantic_version = Some(input.into());
            self
        }
        /// <p>The semantic version of the component. This version follows the semantic version syntax.</p> <note>
        /// <p>The semantic version has four nodes: <major>
        /// .
        /// <minor>
        /// .
        /// <patch>
        /// /
        /// <build>
        /// . You can assign values for the first three, and can filter on all of them.
        /// </build>
        /// </patch>
        /// </minor>
        /// </major></p>
        /// <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p>
        /// <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p>
        /// </note>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.semantic_version = input;
            self
        }
        /// <p>The description of the component. Describes the contents of the component.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the component. Describes the contents of the component.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The change description of the component. Describes what change has been made in this version, or what makes this version different from other versions of this component.</p>
        pub fn change_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_description = Some(input.into());
            self
        }
        /// <p>The change description of the component. Describes what change has been made in this version, or what makes this version different from other versions of this component.</p>
        pub fn set_change_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.change_description = input;
            self
        }
        /// <p>The platform of the component.</p>
        pub fn platform(mut self, input: crate::model::Platform) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p>The platform of the component.</p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.platform = input;
            self
        }
        /// Appends an item to `supported_os_versions`.
        ///
        /// To override the contents of this collection use [`set_supported_os_versions`](Self::set_supported_os_versions).
        ///
        /// <p> The operating system (OS) version supported by the component. If the OS information is available, a prefix match is performed against the base image OS version during image recipe creation.</p>
        pub fn supported_os_versions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.supported_os_versions.unwrap_or_default();
            v.push(input.into());
            self.supported_os_versions = Some(v);
            self
        }
        /// <p> The operating system (OS) version supported by the component. If the OS information is available, a prefix match is performed against the base image OS version during image recipe creation.</p>
        pub fn set_supported_os_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_os_versions = input;
            self
        }
        /// <p>Component <code>data</code> contains inline YAML document content for the component. Alternatively, you can specify the <code>uri</code> of a YAML document file stored in Amazon S3. However, you cannot specify both properties.</p>
        pub fn data(mut self, input: impl Into<std::string::String>) -> Self {
            self.data = Some(input.into());
            self
        }
        /// <p>Component <code>data</code> contains inline YAML document content for the component. Alternatively, you can specify the <code>uri</code> of a YAML document file stored in Amazon S3. However, you cannot specify both properties.</p>
        pub fn set_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data = input;
            self
        }
        /// <p>The <code>uri</code> of a YAML component document file. This must be an S3 URL (<code>s3://bucket/key</code>), and the requester must have permission to access the S3 bucket it points to. If you use Amazon S3, you can specify component content up to your service quota.</p>
        /// <p>Alternatively, you can specify the YAML document inline, using the component <code>data</code> property. You cannot specify both properties.</p>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.uri = Some(input.into());
            self
        }
        /// <p>The <code>uri</code> of a YAML component document file. This must be an S3 URL (<code>s3://bucket/key</code>), and the requester must have permission to access the S3 bucket it points to. If you use Amazon S3, you can specify component content up to your service quota.</p>
        /// <p>Alternatively, you can specify the YAML document inline, using the component <code>data</code> property. You cannot specify both properties.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uri = input;
            self
        }
        /// <p>The ID of the KMS key that should be used to encrypt this component.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the KMS key that should be used to encrypt this component.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags of the component.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags of the component.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The idempotency token of the component.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The idempotency token of the component.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateComponentInput`](crate::input::CreateComponentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateComponentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateComponentInput {
                name: self.name,
                semantic_version: self.semantic_version,
                description: self.description,
                change_description: self.change_description,
                platform: self.platform,
                supported_os_versions: self.supported_os_versions,
                data: self.data,
                uri: self.uri,
                kms_key_id: self.kms_key_id,
                tags: self.tags,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateComponentInputOperationOutputAlias = crate::operation::CreateComponent;
#[doc(hidden)]
pub type CreateComponentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateComponentInput {
    /// Consumes the builder and constructs an Operation<[`CreateComponent`](crate::operation::CreateComponent)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateComponent,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateComponentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/CreateComponent").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateComponentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_component(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateComponent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateComponent",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateComponentInput`](crate::input::CreateComponentInput)
    pub fn builder() -> crate::input::create_component_input::Builder {
        crate::input::create_component_input::Builder::default()
    }
}

/// See [`CreateContainerRecipeInput`](crate::input::CreateContainerRecipeInput)
pub mod create_container_recipe_input {
    /// A builder for [`CreateContainerRecipeInput`](crate::input::CreateContainerRecipeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_type: std::option::Option<crate::model::ContainerType>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) semantic_version: std::option::Option<std::string::String>,
        pub(crate) components:
            std::option::Option<std::vec::Vec<crate::model::ComponentConfiguration>>,
        pub(crate) instance_configuration: std::option::Option<crate::model::InstanceConfiguration>,
        pub(crate) dockerfile_template_data: std::option::Option<std::string::String>,
        pub(crate) dockerfile_template_uri: std::option::Option<std::string::String>,
        pub(crate) platform_override: std::option::Option<crate::model::Platform>,
        pub(crate) image_os_version_override: std::option::Option<std::string::String>,
        pub(crate) parent_image: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) working_directory: std::option::Option<std::string::String>,
        pub(crate) target_repository: std::option::Option<crate::model::TargetContainerRepository>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of container to create.</p>
        pub fn container_type(mut self, input: crate::model::ContainerType) -> Self {
            self.container_type = Some(input);
            self
        }
        /// <p>The type of container to create.</p>
        pub fn set_container_type(
            mut self,
            input: std::option::Option<crate::model::ContainerType>,
        ) -> Self {
            self.container_type = input;
            self
        }
        /// <p>The name of the container recipe.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the container recipe.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the container recipe.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the container recipe.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The semantic version of the container recipe. This version follows the semantic version syntax.</p> <note>
        /// <p>The semantic version has four nodes: <major>
        /// .
        /// <minor>
        /// .
        /// <patch>
        /// /
        /// <build>
        /// . You can assign values for the first three, and can filter on all of them.
        /// </build>
        /// </patch>
        /// </minor>
        /// </major></p>
        /// <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p>
        /// <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p>
        /// </note>
        pub fn semantic_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.semantic_version = Some(input.into());
            self
        }
        /// <p>The semantic version of the container recipe. This version follows the semantic version syntax.</p> <note>
        /// <p>The semantic version has four nodes: <major>
        /// .
        /// <minor>
        /// .
        /// <patch>
        /// /
        /// <build>
        /// . You can assign values for the first three, and can filter on all of them.
        /// </build>
        /// </patch>
        /// </minor>
        /// </major></p>
        /// <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p>
        /// <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p>
        /// </note>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.semantic_version = input;
            self
        }
        /// Appends an item to `components`.
        ///
        /// To override the contents of this collection use [`set_components`](Self::set_components).
        ///
        /// <p>Components for build and test that are included in the container recipe.</p>
        pub fn components(mut self, input: crate::model::ComponentConfiguration) -> Self {
            let mut v = self.components.unwrap_or_default();
            v.push(input);
            self.components = Some(v);
            self
        }
        /// <p>Components for build and test that are included in the container recipe.</p>
        pub fn set_components(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComponentConfiguration>>,
        ) -> Self {
            self.components = input;
            self
        }
        /// <p>A group of options that can be used to configure an instance for building and testing container images.</p>
        pub fn instance_configuration(
            mut self,
            input: crate::model::InstanceConfiguration,
        ) -> Self {
            self.instance_configuration = Some(input);
            self
        }
        /// <p>A group of options that can be used to configure an instance for building and testing container images.</p>
        pub fn set_instance_configuration(
            mut self,
            input: std::option::Option<crate::model::InstanceConfiguration>,
        ) -> Self {
            self.instance_configuration = input;
            self
        }
        /// <p>The Dockerfile template used to build your image as an inline data blob.</p>
        pub fn dockerfile_template_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.dockerfile_template_data = Some(input.into());
            self
        }
        /// <p>The Dockerfile template used to build your image as an inline data blob.</p>
        pub fn set_dockerfile_template_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dockerfile_template_data = input;
            self
        }
        /// <p>The Amazon S3 URI for the Dockerfile that will be used to build your container image.</p>
        pub fn dockerfile_template_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.dockerfile_template_uri = Some(input.into());
            self
        }
        /// <p>The Amazon S3 URI for the Dockerfile that will be used to build your container image.</p>
        pub fn set_dockerfile_template_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dockerfile_template_uri = input;
            self
        }
        /// <p>Specifies the operating system platform when you use a custom base image.</p>
        pub fn platform_override(mut self, input: crate::model::Platform) -> Self {
            self.platform_override = Some(input);
            self
        }
        /// <p>Specifies the operating system platform when you use a custom base image.</p>
        pub fn set_platform_override(
            mut self,
            input: std::option::Option<crate::model::Platform>,
        ) -> Self {
            self.platform_override = input;
            self
        }
        /// <p>Specifies the operating system version for the base image.</p>
        pub fn image_os_version_override(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_os_version_override = Some(input.into());
            self
        }
        /// <p>Specifies the operating system version for the base image.</p>
        pub fn set_image_os_version_override(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_os_version_override = input;
            self
        }
        /// <p>The base image for the container recipe.</p>
        pub fn parent_image(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_image = Some(input.into());
            self
        }
        /// <p>The base image for the container recipe.</p>
        pub fn set_parent_image(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parent_image = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags that are attached to the container recipe.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags that are attached to the container recipe.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The working directory for use during build and test workflows.</p>
        pub fn working_directory(mut self, input: impl Into<std::string::String>) -> Self {
            self.working_directory = Some(input.into());
            self
        }
        /// <p>The working directory for use during build and test workflows.</p>
        pub fn set_working_directory(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.working_directory = input;
            self
        }
        /// <p>The destination repository for the container image.</p>
        pub fn target_repository(mut self, input: crate::model::TargetContainerRepository) -> Self {
            self.target_repository = Some(input);
            self
        }
        /// <p>The destination repository for the container image.</p>
        pub fn set_target_repository(
            mut self,
            input: std::option::Option<crate::model::TargetContainerRepository>,
        ) -> Self {
            self.target_repository = input;
            self
        }
        /// <p>Identifies which KMS key is used to encrypt the container image.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>Identifies which KMS key is used to encrypt the container image.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The client token used to make this request idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The client token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateContainerRecipeInput`](crate::input::CreateContainerRecipeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateContainerRecipeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateContainerRecipeInput {
                container_type: self.container_type,
                name: self.name,
                description: self.description,
                semantic_version: self.semantic_version,
                components: self.components,
                instance_configuration: self.instance_configuration,
                dockerfile_template_data: self.dockerfile_template_data,
                dockerfile_template_uri: self.dockerfile_template_uri,
                platform_override: self.platform_override,
                image_os_version_override: self.image_os_version_override,
                parent_image: self.parent_image,
                tags: self.tags,
                working_directory: self.working_directory,
                target_repository: self.target_repository,
                kms_key_id: self.kms_key_id,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateContainerRecipeInputOperationOutputAlias = crate::operation::CreateContainerRecipe;
#[doc(hidden)]
pub type CreateContainerRecipeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateContainerRecipeInput {
    /// Consumes the builder and constructs an Operation<[`CreateContainerRecipe`](crate::operation::CreateContainerRecipe)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateContainerRecipe,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateContainerRecipeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/CreateContainerRecipe").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateContainerRecipeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_container_recipe(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateContainerRecipe::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateContainerRecipe",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateContainerRecipeInput`](crate::input::CreateContainerRecipeInput)
    pub fn builder() -> crate::input::create_container_recipe_input::Builder {
        crate::input::create_container_recipe_input::Builder::default()
    }
}

/// See [`CreateDistributionConfigurationInput`](crate::input::CreateDistributionConfigurationInput)
pub mod create_distribution_configuration_input {
    /// A builder for [`CreateDistributionConfigurationInput`](crate::input::CreateDistributionConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) distributions: std::option::Option<std::vec::Vec<crate::model::Distribution>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the distribution configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the distribution configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The description of the distribution configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The description of the distribution configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `distributions`.
        ///
        /// To override the contents of this collection use [`set_distributions`](Self::set_distributions).
        ///
        /// <p> The distributions of the distribution configuration.</p>
        pub fn distributions(mut self, input: crate::model::Distribution) -> Self {
            let mut v = self.distributions.unwrap_or_default();
            v.push(input);
            self.distributions = Some(v);
            self
        }
        /// <p> The distributions of the distribution configuration.</p>
        pub fn set_distributions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Distribution>>,
        ) -> Self {
            self.distributions = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags of the distribution configuration.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> The tags of the distribution configuration.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p> The idempotency token of the distribution configuration.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p> The idempotency token of the distribution configuration.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDistributionConfigurationInput`](crate::input::CreateDistributionConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDistributionConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDistributionConfigurationInput {
                name: self.name,
                description: self.description,
                distributions: self.distributions,
                tags: self.tags,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDistributionConfigurationInputOperationOutputAlias =
    crate::operation::CreateDistributionConfiguration;
#[doc(hidden)]
pub type CreateDistributionConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateDistributionConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`CreateDistributionConfiguration`](crate::operation::CreateDistributionConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDistributionConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDistributionConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/CreateDistributionConfiguration")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDistributionConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_distribution_configuration(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDistributionConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDistributionConfiguration",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDistributionConfigurationInput`](crate::input::CreateDistributionConfigurationInput)
    pub fn builder() -> crate::input::create_distribution_configuration_input::Builder {
        crate::input::create_distribution_configuration_input::Builder::default()
    }
}

/// See [`CreateImageInput`](crate::input::CreateImageInput)
pub mod create_image_input {
    /// A builder for [`CreateImageInput`](crate::input::CreateImageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_recipe_arn: std::option::Option<std::string::String>,
        pub(crate) container_recipe_arn: std::option::Option<std::string::String>,
        pub(crate) distribution_configuration_arn: std::option::Option<std::string::String>,
        pub(crate) infrastructure_configuration_arn: std::option::Option<std::string::String>,
        pub(crate) image_tests_configuration:
            std::option::Option<crate::model::ImageTestsConfiguration>,
        pub(crate) enhanced_image_metadata_enabled: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the image recipe that defines how images are configured, tested, and assessed.</p>
        pub fn image_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_recipe_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the image recipe that defines how images are configured, tested, and assessed.</p>
        pub fn set_image_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_recipe_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe that defines how images are configured and tested.</p>
        pub fn container_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_recipe_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe that defines how images are configured and tested.</p>
        pub fn set_container_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_recipe_arn = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the distribution configuration that defines and configures the outputs of your pipeline.</p>
        pub fn distribution_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.distribution_configuration_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the distribution configuration that defines and configures the outputs of your pipeline.</p>
        pub fn set_distribution_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.distribution_configuration_arn = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the infrastructure configuration that defines the environment in which your image will be built and tested.</p>
        pub fn infrastructure_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.infrastructure_configuration_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the infrastructure configuration that defines the environment in which your image will be built and tested.</p>
        pub fn set_infrastructure_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.infrastructure_configuration_arn = input;
            self
        }
        /// <p> The image tests configuration of the image.</p>
        pub fn image_tests_configuration(
            mut self,
            input: crate::model::ImageTestsConfiguration,
        ) -> Self {
            self.image_tests_configuration = Some(input);
            self
        }
        /// <p> The image tests configuration of the image.</p>
        pub fn set_image_tests_configuration(
            mut self,
            input: std::option::Option<crate::model::ImageTestsConfiguration>,
        ) -> Self {
            self.image_tests_configuration = input;
            self
        }
        /// <p> Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.</p>
        pub fn enhanced_image_metadata_enabled(mut self, input: bool) -> Self {
            self.enhanced_image_metadata_enabled = Some(input);
            self
        }
        /// <p> Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.</p>
        pub fn set_enhanced_image_metadata_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enhanced_image_metadata_enabled = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags of the image.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> The tags of the image.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p> The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p> The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateImageInput`](crate::input::CreateImageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateImageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateImageInput {
                image_recipe_arn: self.image_recipe_arn,
                container_recipe_arn: self.container_recipe_arn,
                distribution_configuration_arn: self.distribution_configuration_arn,
                infrastructure_configuration_arn: self.infrastructure_configuration_arn,
                image_tests_configuration: self.image_tests_configuration,
                enhanced_image_metadata_enabled: self.enhanced_image_metadata_enabled,
                tags: self.tags,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateImageInputOperationOutputAlias = crate::operation::CreateImage;
#[doc(hidden)]
pub type CreateImageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateImageInput {
    /// Consumes the builder and constructs an Operation<[`CreateImage`](crate::operation::CreateImage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateImage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateImageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/CreateImage").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateImageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_image(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateImage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateImage",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateImageInput`](crate::input::CreateImageInput)
    pub fn builder() -> crate::input::create_image_input::Builder {
        crate::input::create_image_input::Builder::default()
    }
}

/// See [`CreateImagePipelineInput`](crate::input::CreateImagePipelineInput)
pub mod create_image_pipeline_input {
    /// A builder for [`CreateImagePipelineInput`](crate::input::CreateImagePipelineInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) image_recipe_arn: std::option::Option<std::string::String>,
        pub(crate) container_recipe_arn: std::option::Option<std::string::String>,
        pub(crate) infrastructure_configuration_arn: std::option::Option<std::string::String>,
        pub(crate) distribution_configuration_arn: std::option::Option<std::string::String>,
        pub(crate) image_tests_configuration:
            std::option::Option<crate::model::ImageTestsConfiguration>,
        pub(crate) enhanced_image_metadata_enabled: std::option::Option<bool>,
        pub(crate) schedule: std::option::Option<crate::model::Schedule>,
        pub(crate) status: std::option::Option<crate::model::PipelineStatus>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the image pipeline.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the image pipeline.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The description of the image pipeline.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The description of the image pipeline.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the image recipe that will be used to configure images created by this image pipeline.</p>
        pub fn image_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_recipe_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the image recipe that will be used to configure images created by this image pipeline.</p>
        pub fn set_image_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_recipe_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe that is used to configure images created by this container pipeline.</p>
        pub fn container_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_recipe_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe that is used to configure images created by this container pipeline.</p>
        pub fn set_container_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_recipe_arn = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to build images created by this image pipeline.</p>
        pub fn infrastructure_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.infrastructure_configuration_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to build images created by this image pipeline.</p>
        pub fn set_infrastructure_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.infrastructure_configuration_arn = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the distribution configuration that will be used to configure and distribute images created by this image pipeline.</p>
        pub fn distribution_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.distribution_configuration_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the distribution configuration that will be used to configure and distribute images created by this image pipeline.</p>
        pub fn set_distribution_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.distribution_configuration_arn = input;
            self
        }
        /// <p> The image test configuration of the image pipeline.</p>
        pub fn image_tests_configuration(
            mut self,
            input: crate::model::ImageTestsConfiguration,
        ) -> Self {
            self.image_tests_configuration = Some(input);
            self
        }
        /// <p> The image test configuration of the image pipeline.</p>
        pub fn set_image_tests_configuration(
            mut self,
            input: std::option::Option<crate::model::ImageTestsConfiguration>,
        ) -> Self {
            self.image_tests_configuration = input;
            self
        }
        /// <p> Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.</p>
        pub fn enhanced_image_metadata_enabled(mut self, input: bool) -> Self {
            self.enhanced_image_metadata_enabled = Some(input);
            self
        }
        /// <p> Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.</p>
        pub fn set_enhanced_image_metadata_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enhanced_image_metadata_enabled = input;
            self
        }
        /// <p> The schedule of the image pipeline.</p>
        pub fn schedule(mut self, input: crate::model::Schedule) -> Self {
            self.schedule = Some(input);
            self
        }
        /// <p> The schedule of the image pipeline.</p>
        pub fn set_schedule(mut self, input: std::option::Option<crate::model::Schedule>) -> Self {
            self.schedule = input;
            self
        }
        /// <p> The status of the image pipeline.</p>
        pub fn status(mut self, input: crate::model::PipelineStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The status of the image pipeline.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PipelineStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags of the image pipeline.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> The tags of the image pipeline.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p> The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p> The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateImagePipelineInput`](crate::input::CreateImagePipelineInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateImagePipelineInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateImagePipelineInput {
                name: self.name,
                description: self.description,
                image_recipe_arn: self.image_recipe_arn,
                container_recipe_arn: self.container_recipe_arn,
                infrastructure_configuration_arn: self.infrastructure_configuration_arn,
                distribution_configuration_arn: self.distribution_configuration_arn,
                image_tests_configuration: self.image_tests_configuration,
                enhanced_image_metadata_enabled: self.enhanced_image_metadata_enabled,
                schedule: self.schedule,
                status: self.status,
                tags: self.tags,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateImagePipelineInputOperationOutputAlias = crate::operation::CreateImagePipeline;
#[doc(hidden)]
pub type CreateImagePipelineInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateImagePipelineInput {
    /// Consumes the builder and constructs an Operation<[`CreateImagePipeline`](crate::operation::CreateImagePipeline)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateImagePipeline,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateImagePipelineInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/CreateImagePipeline").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateImagePipelineInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_image_pipeline(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateImagePipeline::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateImagePipeline",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateImagePipelineInput`](crate::input::CreateImagePipelineInput)
    pub fn builder() -> crate::input::create_image_pipeline_input::Builder {
        crate::input::create_image_pipeline_input::Builder::default()
    }
}

/// See [`CreateImageRecipeInput`](crate::input::CreateImageRecipeInput)
pub mod create_image_recipe_input {
    /// A builder for [`CreateImageRecipeInput`](crate::input::CreateImageRecipeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) semantic_version: std::option::Option<std::string::String>,
        pub(crate) components:
            std::option::Option<std::vec::Vec<crate::model::ComponentConfiguration>>,
        pub(crate) parent_image: std::option::Option<std::string::String>,
        pub(crate) block_device_mappings:
            std::option::Option<std::vec::Vec<crate::model::InstanceBlockDeviceMapping>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) working_directory: std::option::Option<std::string::String>,
        pub(crate) additional_instance_configuration:
            std::option::Option<crate::model::AdditionalInstanceConfiguration>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the image recipe.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the image recipe.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The description of the image recipe.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The description of the image recipe.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The semantic version of the image recipe. This version follows the semantic version syntax.</p> <note>
        /// <p>The semantic version has four nodes: <major>
        /// .
        /// <minor>
        /// .
        /// <patch>
        /// /
        /// <build>
        /// . You can assign values for the first three, and can filter on all of them.
        /// </build>
        /// </patch>
        /// </minor>
        /// </major></p>
        /// <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p>
        /// <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p>
        /// </note>
        pub fn semantic_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.semantic_version = Some(input.into());
            self
        }
        /// <p>The semantic version of the image recipe. This version follows the semantic version syntax.</p> <note>
        /// <p>The semantic version has four nodes: <major>
        /// .
        /// <minor>
        /// .
        /// <patch>
        /// /
        /// <build>
        /// . You can assign values for the first three, and can filter on all of them.
        /// </build>
        /// </patch>
        /// </minor>
        /// </major></p>
        /// <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p>
        /// <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p>
        /// </note>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.semantic_version = input;
            self
        }
        /// Appends an item to `components`.
        ///
        /// To override the contents of this collection use [`set_components`](Self::set_components).
        ///
        /// <p>The components of the image recipe.</p>
        pub fn components(mut self, input: crate::model::ComponentConfiguration) -> Self {
            let mut v = self.components.unwrap_or_default();
            v.push(input);
            self.components = Some(v);
            self
        }
        /// <p>The components of the image recipe.</p>
        pub fn set_components(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComponentConfiguration>>,
        ) -> Self {
            self.components = input;
            self
        }
        /// <p>The base image of the image recipe. The value of the string can be the ARN of the base image or an AMI ID. The format for the ARN follows this example: <code>arn:aws:imagebuilder:us-west-2:aws:image/windows-server-2016-english-full-base-x86/x.x.x</code>. You can provide the specific version that you want to use, or you can use a wildcard in all of the fields. If you enter an AMI ID for the string value, you must have access to the AMI, and the AMI must be in the same Region in which you are using Image Builder.</p>
        pub fn parent_image(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_image = Some(input.into());
            self
        }
        /// <p>The base image of the image recipe. The value of the string can be the ARN of the base image or an AMI ID. The format for the ARN follows this example: <code>arn:aws:imagebuilder:us-west-2:aws:image/windows-server-2016-english-full-base-x86/x.x.x</code>. You can provide the specific version that you want to use, or you can use a wildcard in all of the fields. If you enter an AMI ID for the string value, you must have access to the AMI, and the AMI must be in the same Region in which you are using Image Builder.</p>
        pub fn set_parent_image(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parent_image = input;
            self
        }
        /// Appends an item to `block_device_mappings`.
        ///
        /// To override the contents of this collection use [`set_block_device_mappings`](Self::set_block_device_mappings).
        ///
        /// <p>The block device mappings of the image recipe.</p>
        pub fn block_device_mappings(
            mut self,
            input: crate::model::InstanceBlockDeviceMapping,
        ) -> Self {
            let mut v = self.block_device_mappings.unwrap_or_default();
            v.push(input);
            self.block_device_mappings = Some(v);
            self
        }
        /// <p>The block device mappings of the image recipe.</p>
        pub fn set_block_device_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceBlockDeviceMapping>>,
        ) -> Self {
            self.block_device_mappings = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags of the image recipe.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> The tags of the image recipe.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The working directory used during build and test workflows.</p>
        pub fn working_directory(mut self, input: impl Into<std::string::String>) -> Self {
            self.working_directory = Some(input.into());
            self
        }
        /// <p>The working directory used during build and test workflows.</p>
        pub fn set_working_directory(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.working_directory = input;
            self
        }
        /// <p>Specify additional settings and launch scripts for your build instances.</p>
        pub fn additional_instance_configuration(
            mut self,
            input: crate::model::AdditionalInstanceConfiguration,
        ) -> Self {
            self.additional_instance_configuration = Some(input);
            self
        }
        /// <p>Specify additional settings and launch scripts for your build instances.</p>
        pub fn set_additional_instance_configuration(
            mut self,
            input: std::option::Option<crate::model::AdditionalInstanceConfiguration>,
        ) -> Self {
            self.additional_instance_configuration = input;
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateImageRecipeInput`](crate::input::CreateImageRecipeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateImageRecipeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateImageRecipeInput {
                name: self.name,
                description: self.description,
                semantic_version: self.semantic_version,
                components: self.components,
                parent_image: self.parent_image,
                block_device_mappings: self.block_device_mappings,
                tags: self.tags,
                working_directory: self.working_directory,
                additional_instance_configuration: self.additional_instance_configuration,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateImageRecipeInputOperationOutputAlias = crate::operation::CreateImageRecipe;
#[doc(hidden)]
pub type CreateImageRecipeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateImageRecipeInput {
    /// Consumes the builder and constructs an Operation<[`CreateImageRecipe`](crate::operation::CreateImageRecipe)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateImageRecipe,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateImageRecipeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/CreateImageRecipe").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateImageRecipeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_image_recipe(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateImageRecipe::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateImageRecipe",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateImageRecipeInput`](crate::input::CreateImageRecipeInput)
    pub fn builder() -> crate::input::create_image_recipe_input::Builder {
        crate::input::create_image_recipe_input::Builder::default()
    }
}

/// See [`CreateInfrastructureConfigurationInput`](crate::input::CreateInfrastructureConfigurationInput)
pub mod create_infrastructure_configuration_input {
    /// A builder for [`CreateInfrastructureConfigurationInput`](crate::input::CreateInfrastructureConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) instance_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) instance_profile_name: std::option::Option<std::string::String>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) logging: std::option::Option<crate::model::Logging>,
        pub(crate) key_pair: std::option::Option<std::string::String>,
        pub(crate) terminate_instance_on_failure: std::option::Option<bool>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) resource_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) instance_metadata_options:
            std::option::Option<crate::model::InstanceMetadataOptions>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the infrastructure configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the infrastructure configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the infrastructure configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the infrastructure configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `instance_types`.
        ///
        /// To override the contents of this collection use [`set_instance_types`](Self::set_instance_types).
        ///
        /// <p>The instance types of the infrastructure configuration. You can specify one or more instance types to use for this build. The service will pick one of these instance types based on availability.</p>
        pub fn instance_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_types.unwrap_or_default();
            v.push(input.into());
            self.instance_types = Some(v);
            self
        }
        /// <p>The instance types of the infrastructure configuration. You can specify one or more instance types to use for this build. The service will pick one of these instance types based on availability.</p>
        pub fn set_instance_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_types = input;
            self
        }
        /// <p>The instance profile to associate with the instance used to customize your Amazon EC2 AMI.</p>
        pub fn instance_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_profile_name = Some(input.into());
            self
        }
        /// <p>The instance profile to associate with the instance used to customize your Amazon EC2 AMI.</p>
        pub fn set_instance_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_profile_name = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// <p>The subnet ID in which to place the instance used to customize your Amazon EC2 AMI.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The subnet ID in which to place the instance used to customize your Amazon EC2 AMI.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>The logging configuration of the infrastructure configuration.</p>
        pub fn logging(mut self, input: crate::model::Logging) -> Self {
            self.logging = Some(input);
            self
        }
        /// <p>The logging configuration of the infrastructure configuration.</p>
        pub fn set_logging(mut self, input: std::option::Option<crate::model::Logging>) -> Self {
            self.logging = input;
            self
        }
        /// <p>The key pair of the infrastructure configuration. You can use this to log on to and debug the instance used to create your image.</p>
        pub fn key_pair(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_pair = Some(input.into());
            self
        }
        /// <p>The key pair of the infrastructure configuration. You can use this to log on to and debug the instance used to create your image.</p>
        pub fn set_key_pair(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_pair = input;
            self
        }
        /// <p>The terminate instance on failure setting of the infrastructure configuration. Set to false if you want Image Builder to retain the instance used to configure your AMI if the build or test phase of your workflow fails.</p>
        pub fn terminate_instance_on_failure(mut self, input: bool) -> Self {
            self.terminate_instance_on_failure = Some(input);
            self
        }
        /// <p>The terminate instance on failure setting of the infrastructure configuration. Set to false if you want Image Builder to retain the instance used to configure your AMI if the build or test phase of your workflow fails.</p>
        pub fn set_terminate_instance_on_failure(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.terminate_instance_on_failure = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the SNS topic to which we send image build event notifications.</p> <note>
        /// <p>EC2 Image Builder is unable to send notifications to SNS topics that are encrypted using keys from other accounts. The key that is used to encrypt the SNS topic must reside in the account that the Image Builder service runs under.</p>
        /// </note>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the SNS topic to which we send image build event notifications.</p> <note>
        /// <p>EC2 Image Builder is unable to send notifications to SNS topics that are encrypted using keys from other accounts. The key that is used to encrypt the SNS topic must reside in the account that the Image Builder service runs under.</p>
        /// </note>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// Adds a key-value pair to `resource_tags`.
        ///
        /// To override the contents of this collection use [`set_resource_tags`](Self::set_resource_tags).
        ///
        /// <p>The tags attached to the resource created by Image Builder.</p>
        pub fn resource_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.resource_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.resource_tags = Some(hash_map);
            self
        }
        /// <p>The tags attached to the resource created by Image Builder.</p>
        pub fn set_resource_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.resource_tags = input;
            self
        }
        /// <p>The instance metadata options that you can set for the HTTP requests that pipeline builds use to launch EC2 build and test instances.</p>
        pub fn instance_metadata_options(
            mut self,
            input: crate::model::InstanceMetadataOptions,
        ) -> Self {
            self.instance_metadata_options = Some(input);
            self
        }
        /// <p>The instance metadata options that you can set for the HTTP requests that pipeline builds use to launch EC2 build and test instances.</p>
        pub fn set_instance_metadata_options(
            mut self,
            input: std::option::Option<crate::model::InstanceMetadataOptions>,
        ) -> Self {
            self.instance_metadata_options = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags of the infrastructure configuration.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags of the infrastructure configuration.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateInfrastructureConfigurationInput`](crate::input::CreateInfrastructureConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateInfrastructureConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateInfrastructureConfigurationInput {
                name: self.name,
                description: self.description,
                instance_types: self.instance_types,
                instance_profile_name: self.instance_profile_name,
                security_group_ids: self.security_group_ids,
                subnet_id: self.subnet_id,
                logging: self.logging,
                key_pair: self.key_pair,
                terminate_instance_on_failure: self.terminate_instance_on_failure,
                sns_topic_arn: self.sns_topic_arn,
                resource_tags: self.resource_tags,
                instance_metadata_options: self.instance_metadata_options,
                tags: self.tags,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateInfrastructureConfigurationInputOperationOutputAlias =
    crate::operation::CreateInfrastructureConfiguration;
#[doc(hidden)]
pub type CreateInfrastructureConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateInfrastructureConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`CreateInfrastructureConfiguration`](crate::operation::CreateInfrastructureConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateInfrastructureConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateInfrastructureConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/CreateInfrastructureConfiguration")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateInfrastructureConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_infrastructure_configuration(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateInfrastructureConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateInfrastructureConfiguration",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateInfrastructureConfigurationInput`](crate::input::CreateInfrastructureConfigurationInput)
    pub fn builder() -> crate::input::create_infrastructure_configuration_input::Builder {
        crate::input::create_infrastructure_configuration_input::Builder::default()
    }
}

/// See [`DeleteComponentInput`](crate::input::DeleteComponentInput)
pub mod delete_component_input {
    /// A builder for [`DeleteComponentInput`](crate::input::DeleteComponentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) component_build_version_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the component build version to delete.</p>
        pub fn component_build_version_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.component_build_version_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the component build version to delete.</p>
        pub fn set_component_build_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_build_version_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteComponentInput`](crate::input::DeleteComponentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteComponentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteComponentInput {
                component_build_version_arn: self.component_build_version_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteComponentInputOperationOutputAlias = crate::operation::DeleteComponent;
#[doc(hidden)]
pub type DeleteComponentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteComponentInput {
    /// Consumes the builder and constructs an Operation<[`DeleteComponent`](crate::operation::DeleteComponent)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteComponent,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteComponentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/DeleteComponent").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteComponentInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_1) = &_input.component_build_version_arn {
                    query.push_kv(
                        "componentBuildVersionArn",
                        &aws_smithy_http::query::fmt_string(&inner_1),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteComponentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteComponent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteComponent",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteComponentInput`](crate::input::DeleteComponentInput)
    pub fn builder() -> crate::input::delete_component_input::Builder {
        crate::input::delete_component_input::Builder::default()
    }
}

/// See [`DeleteContainerRecipeInput`](crate::input::DeleteContainerRecipeInput)
pub mod delete_container_recipe_input {
    /// A builder for [`DeleteContainerRecipeInput`](crate::input::DeleteContainerRecipeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_recipe_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the container recipe to delete.</p>
        pub fn container_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_recipe_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe to delete.</p>
        pub fn set_container_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_recipe_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteContainerRecipeInput`](crate::input::DeleteContainerRecipeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteContainerRecipeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteContainerRecipeInput {
                container_recipe_arn: self.container_recipe_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteContainerRecipeInputOperationOutputAlias = crate::operation::DeleteContainerRecipe;
#[doc(hidden)]
pub type DeleteContainerRecipeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteContainerRecipeInput {
    /// Consumes the builder and constructs an Operation<[`DeleteContainerRecipe`](crate::operation::DeleteContainerRecipe)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteContainerRecipe,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteContainerRecipeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/DeleteContainerRecipe").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteContainerRecipeInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_2) = &_input.container_recipe_arn {
                    query.push_kv(
                        "containerRecipeArn",
                        &aws_smithy_http::query::fmt_string(&inner_2),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteContainerRecipeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteContainerRecipe::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteContainerRecipe",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteContainerRecipeInput`](crate::input::DeleteContainerRecipeInput)
    pub fn builder() -> crate::input::delete_container_recipe_input::Builder {
        crate::input::delete_container_recipe_input::Builder::default()
    }
}

/// See [`DeleteDistributionConfigurationInput`](crate::input::DeleteDistributionConfigurationInput)
pub mod delete_distribution_configuration_input {
    /// A builder for [`DeleteDistributionConfigurationInput`](crate::input::DeleteDistributionConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution_configuration_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration to delete.</p>
        pub fn distribution_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.distribution_configuration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration to delete.</p>
        pub fn set_distribution_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.distribution_configuration_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDistributionConfigurationInput`](crate::input::DeleteDistributionConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDistributionConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDistributionConfigurationInput {
                distribution_configuration_arn: self.distribution_configuration_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDistributionConfigurationInputOperationOutputAlias =
    crate::operation::DeleteDistributionConfiguration;
#[doc(hidden)]
pub type DeleteDistributionConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDistributionConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDistributionConfiguration`](crate::operation::DeleteDistributionConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDistributionConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDistributionConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/DeleteDistributionConfiguration")
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteDistributionConfigurationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_3) = &_input.distribution_configuration_arn {
                    query.push_kv(
                        "distributionConfigurationArn",
                        &aws_smithy_http::query::fmt_string(&inner_3),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDistributionConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDistributionConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDistributionConfiguration",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDistributionConfigurationInput`](crate::input::DeleteDistributionConfigurationInput)
    pub fn builder() -> crate::input::delete_distribution_configuration_input::Builder {
        crate::input::delete_distribution_configuration_input::Builder::default()
    }
}

/// See [`DeleteImageInput`](crate::input::DeleteImageInput)
pub mod delete_image_input {
    /// A builder for [`DeleteImageInput`](crate::input::DeleteImageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_build_version_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Image Builder image resource to delete.</p>
        pub fn image_build_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_build_version_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Image Builder image resource to delete.</p>
        pub fn set_image_build_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_build_version_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteImageInput`](crate::input::DeleteImageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteImageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteImageInput {
                image_build_version_arn: self.image_build_version_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteImageInputOperationOutputAlias = crate::operation::DeleteImage;
#[doc(hidden)]
pub type DeleteImageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteImageInput {
    /// Consumes the builder and constructs an Operation<[`DeleteImage`](crate::operation::DeleteImage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteImage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteImageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/DeleteImage").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteImageInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_4) = &_input.image_build_version_arn {
                    query.push_kv(
                        "imageBuildVersionArn",
                        &aws_smithy_http::query::fmt_string(&inner_4),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteImageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteImage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteImage",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteImageInput`](crate::input::DeleteImageInput)
    pub fn builder() -> crate::input::delete_image_input::Builder {
        crate::input::delete_image_input::Builder::default()
    }
}

/// See [`DeleteImagePipelineInput`](crate::input::DeleteImagePipelineInput)
pub mod delete_image_pipeline_input {
    /// A builder for [`DeleteImagePipelineInput`](crate::input::DeleteImagePipelineInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_pipeline_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the image pipeline to delete.</p>
        pub fn image_pipeline_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_pipeline_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline to delete.</p>
        pub fn set_image_pipeline_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_pipeline_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteImagePipelineInput`](crate::input::DeleteImagePipelineInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteImagePipelineInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteImagePipelineInput {
                image_pipeline_arn: self.image_pipeline_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteImagePipelineInputOperationOutputAlias = crate::operation::DeleteImagePipeline;
#[doc(hidden)]
pub type DeleteImagePipelineInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteImagePipelineInput {
    /// Consumes the builder and constructs an Operation<[`DeleteImagePipeline`](crate::operation::DeleteImagePipeline)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteImagePipeline,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteImagePipelineInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/DeleteImagePipeline").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteImagePipelineInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_5) = &_input.image_pipeline_arn {
                    query.push_kv(
                        "imagePipelineArn",
                        &aws_smithy_http::query::fmt_string(&inner_5),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteImagePipelineInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteImagePipeline::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteImagePipeline",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteImagePipelineInput`](crate::input::DeleteImagePipelineInput)
    pub fn builder() -> crate::input::delete_image_pipeline_input::Builder {
        crate::input::delete_image_pipeline_input::Builder::default()
    }
}

/// See [`DeleteImageRecipeInput`](crate::input::DeleteImageRecipeInput)
pub mod delete_image_recipe_input {
    /// A builder for [`DeleteImageRecipeInput`](crate::input::DeleteImageRecipeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_recipe_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the image recipe to delete.</p>
        pub fn image_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_recipe_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe to delete.</p>
        pub fn set_image_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_recipe_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteImageRecipeInput`](crate::input::DeleteImageRecipeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteImageRecipeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteImageRecipeInput {
                image_recipe_arn: self.image_recipe_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteImageRecipeInputOperationOutputAlias = crate::operation::DeleteImageRecipe;
#[doc(hidden)]
pub type DeleteImageRecipeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteImageRecipeInput {
    /// Consumes the builder and constructs an Operation<[`DeleteImageRecipe`](crate::operation::DeleteImageRecipe)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteImageRecipe,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteImageRecipeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/DeleteImageRecipe").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteImageRecipeInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_6) = &_input.image_recipe_arn {
                    query.push_kv(
                        "imageRecipeArn",
                        &aws_smithy_http::query::fmt_string(&inner_6),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteImageRecipeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteImageRecipe::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteImageRecipe",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteImageRecipeInput`](crate::input::DeleteImageRecipeInput)
    pub fn builder() -> crate::input::delete_image_recipe_input::Builder {
        crate::input::delete_image_recipe_input::Builder::default()
    }
}

/// See [`DeleteInfrastructureConfigurationInput`](crate::input::DeleteInfrastructureConfigurationInput)
pub mod delete_infrastructure_configuration_input {
    /// A builder for [`DeleteInfrastructureConfigurationInput`](crate::input::DeleteInfrastructureConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) infrastructure_configuration_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration to delete.</p>
        pub fn infrastructure_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.infrastructure_configuration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration to delete.</p>
        pub fn set_infrastructure_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.infrastructure_configuration_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteInfrastructureConfigurationInput`](crate::input::DeleteInfrastructureConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteInfrastructureConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteInfrastructureConfigurationInput {
                infrastructure_configuration_arn: self.infrastructure_configuration_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteInfrastructureConfigurationInputOperationOutputAlias =
    crate::operation::DeleteInfrastructureConfiguration;
#[doc(hidden)]
pub type DeleteInfrastructureConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteInfrastructureConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteInfrastructureConfiguration`](crate::operation::DeleteInfrastructureConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteInfrastructureConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteInfrastructureConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/DeleteInfrastructureConfiguration")
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteInfrastructureConfigurationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_7) = &_input.infrastructure_configuration_arn {
                    query.push_kv(
                        "infrastructureConfigurationArn",
                        &aws_smithy_http::query::fmt_string(&inner_7),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteInfrastructureConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteInfrastructureConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteInfrastructureConfiguration",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteInfrastructureConfigurationInput`](crate::input::DeleteInfrastructureConfigurationInput)
    pub fn builder() -> crate::input::delete_infrastructure_configuration_input::Builder {
        crate::input::delete_infrastructure_configuration_input::Builder::default()
    }
}

/// See [`GetComponentInput`](crate::input::GetComponentInput)
pub mod get_component_input {
    /// A builder for [`GetComponentInput`](crate::input::GetComponentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) component_build_version_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the component that you want to retrieve. Regex requires "/\d+$" suffix.</p>
        pub fn component_build_version_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.component_build_version_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the component that you want to retrieve. Regex requires "/\d+$" suffix.</p>
        pub fn set_component_build_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_build_version_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetComponentInput`](crate::input::GetComponentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetComponentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetComponentInput {
                component_build_version_arn: self.component_build_version_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetComponentInputOperationOutputAlias = crate::operation::GetComponent;
#[doc(hidden)]
pub type GetComponentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetComponentInput {
    /// Consumes the builder and constructs an Operation<[`GetComponent`](crate::operation::GetComponent)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetComponent,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetComponentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/GetComponent").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetComponentInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_8) = &_input.component_build_version_arn {
                    query.push_kv(
                        "componentBuildVersionArn",
                        &aws_smithy_http::query::fmt_string(&inner_8),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetComponentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetComponent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetComponent",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetComponentInput`](crate::input::GetComponentInput)
    pub fn builder() -> crate::input::get_component_input::Builder {
        crate::input::get_component_input::Builder::default()
    }
}

/// See [`GetComponentPolicyInput`](crate::input::GetComponentPolicyInput)
pub mod get_component_policy_input {
    /// A builder for [`GetComponentPolicyInput`](crate::input::GetComponentPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) component_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the component whose policy you want to retrieve.</p>
        pub fn component_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the component whose policy you want to retrieve.</p>
        pub fn set_component_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetComponentPolicyInput`](crate::input::GetComponentPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetComponentPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetComponentPolicyInput {
                component_arn: self.component_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetComponentPolicyInputOperationOutputAlias = crate::operation::GetComponentPolicy;
#[doc(hidden)]
pub type GetComponentPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetComponentPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetComponentPolicy`](crate::operation::GetComponentPolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetComponentPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetComponentPolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/GetComponentPolicy").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetComponentPolicyInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_9) = &_input.component_arn {
                    query.push_kv(
                        "componentArn",
                        &aws_smithy_http::query::fmt_string(&inner_9),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetComponentPolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetComponentPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetComponentPolicy",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetComponentPolicyInput`](crate::input::GetComponentPolicyInput)
    pub fn builder() -> crate::input::get_component_policy_input::Builder {
        crate::input::get_component_policy_input::Builder::default()
    }
}

/// See [`GetContainerRecipeInput`](crate::input::GetContainerRecipeInput)
pub mod get_container_recipe_input {
    /// A builder for [`GetContainerRecipeInput`](crate::input::GetContainerRecipeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_recipe_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the container recipe to retrieve.</p>
        pub fn container_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_recipe_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe to retrieve.</p>
        pub fn set_container_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_recipe_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetContainerRecipeInput`](crate::input::GetContainerRecipeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetContainerRecipeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetContainerRecipeInput {
                container_recipe_arn: self.container_recipe_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetContainerRecipeInputOperationOutputAlias = crate::operation::GetContainerRecipe;
#[doc(hidden)]
pub type GetContainerRecipeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetContainerRecipeInput {
    /// Consumes the builder and constructs an Operation<[`GetContainerRecipe`](crate::operation::GetContainerRecipe)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetContainerRecipe,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetContainerRecipeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/GetContainerRecipe").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetContainerRecipeInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_10) = &_input.container_recipe_arn {
                    query.push_kv(
                        "containerRecipeArn",
                        &aws_smithy_http::query::fmt_string(&inner_10),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetContainerRecipeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetContainerRecipe::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetContainerRecipe",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetContainerRecipeInput`](crate::input::GetContainerRecipeInput)
    pub fn builder() -> crate::input::get_container_recipe_input::Builder {
        crate::input::get_container_recipe_input::Builder::default()
    }
}

/// See [`GetContainerRecipePolicyInput`](crate::input::GetContainerRecipePolicyInput)
pub mod get_container_recipe_policy_input {
    /// A builder for [`GetContainerRecipePolicyInput`](crate::input::GetContainerRecipePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_recipe_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the container recipe for the policy being requested.</p>
        pub fn container_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_recipe_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe for the policy being requested.</p>
        pub fn set_container_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_recipe_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetContainerRecipePolicyInput`](crate::input::GetContainerRecipePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetContainerRecipePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetContainerRecipePolicyInput {
                container_recipe_arn: self.container_recipe_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetContainerRecipePolicyInputOperationOutputAlias =
    crate::operation::GetContainerRecipePolicy;
#[doc(hidden)]
pub type GetContainerRecipePolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetContainerRecipePolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetContainerRecipePolicy`](crate::operation::GetContainerRecipePolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetContainerRecipePolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetContainerRecipePolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/GetContainerRecipePolicy").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetContainerRecipePolicyInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_11) = &_input.container_recipe_arn {
                    query.push_kv(
                        "containerRecipeArn",
                        &aws_smithy_http::query::fmt_string(&inner_11),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetContainerRecipePolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetContainerRecipePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetContainerRecipePolicy",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetContainerRecipePolicyInput`](crate::input::GetContainerRecipePolicyInput)
    pub fn builder() -> crate::input::get_container_recipe_policy_input::Builder {
        crate::input::get_container_recipe_policy_input::Builder::default()
    }
}

/// See [`GetDistributionConfigurationInput`](crate::input::GetDistributionConfigurationInput)
pub mod get_distribution_configuration_input {
    /// A builder for [`GetDistributionConfigurationInput`](crate::input::GetDistributionConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution_configuration_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration that you want to retrieve.</p>
        pub fn distribution_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.distribution_configuration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration that you want to retrieve.</p>
        pub fn set_distribution_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.distribution_configuration_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDistributionConfigurationInput`](crate::input::GetDistributionConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDistributionConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDistributionConfigurationInput {
                distribution_configuration_arn: self.distribution_configuration_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDistributionConfigurationInputOperationOutputAlias =
    crate::operation::GetDistributionConfiguration;
#[doc(hidden)]
pub type GetDistributionConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetDistributionConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetDistributionConfiguration`](crate::operation::GetDistributionConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDistributionConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDistributionConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/GetDistributionConfiguration").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetDistributionConfigurationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_12) = &_input.distribution_configuration_arn {
                    query.push_kv(
                        "distributionConfigurationArn",
                        &aws_smithy_http::query::fmt_string(&inner_12),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDistributionConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDistributionConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDistributionConfiguration",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDistributionConfigurationInput`](crate::input::GetDistributionConfigurationInput)
    pub fn builder() -> crate::input::get_distribution_configuration_input::Builder {
        crate::input::get_distribution_configuration_input::Builder::default()
    }
}

/// See [`GetImageInput`](crate::input::GetImageInput)
pub mod get_image_input {
    /// A builder for [`GetImageInput`](crate::input::GetImageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_build_version_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the image that you want to retrieve.</p>
        pub fn image_build_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_build_version_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image that you want to retrieve.</p>
        pub fn set_image_build_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_build_version_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetImageInput`](crate::input::GetImageInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetImageInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetImageInput {
                image_build_version_arn: self.image_build_version_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetImageInputOperationOutputAlias = crate::operation::GetImage;
#[doc(hidden)]
pub type GetImageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetImageInput {
    /// Consumes the builder and constructs an Operation<[`GetImage`](crate::operation::GetImage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetImage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetImageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/GetImage").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetImageInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_13) = &_input.image_build_version_arn {
                    query.push_kv(
                        "imageBuildVersionArn",
                        &aws_smithy_http::query::fmt_string(&inner_13),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetImageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetImage::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetImage",
                    "imagebuilder",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetImageInput`](crate::input::GetImageInput)
    pub fn builder() -> crate::input::get_image_input::Builder {
        crate::input::get_image_input::Builder::default()
    }
}

/// See [`GetImagePipelineInput`](crate::input::GetImagePipelineInput)
pub mod get_image_pipeline_input {
    /// A builder for [`GetImagePipelineInput`](crate::input::GetImagePipelineInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_pipeline_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the image pipeline that you want to retrieve.</p>
        pub fn image_pipeline_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_pipeline_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline that you want to retrieve.</p>
        pub fn set_image_pipeline_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_pipeline_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetImagePipelineInput`](crate::input::GetImagePipelineInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetImagePipelineInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetImagePipelineInput {
                image_pipeline_arn: self.image_pipeline_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetImagePipelineInputOperationOutputAlias = crate::operation::GetImagePipeline;
#[doc(hidden)]
pub type GetImagePipelineInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetImagePipelineInput {
    /// Consumes the builder and constructs an Operation<[`GetImagePipeline`](crate::operation::GetImagePipeline)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetImagePipeline,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetImagePipelineInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/GetImagePipeline").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetImagePipelineInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_14) = &_input.image_pipeline_arn {
                    query.push_kv(
                        "imagePipelineArn",
                        &aws_smithy_http::query::fmt_string(&inner_14),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetImagePipelineInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetImagePipeline::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetImagePipeline",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetImagePipelineInput`](crate::input::GetImagePipelineInput)
    pub fn builder() -> crate::input::get_image_pipeline_input::Builder {
        crate::input::get_image_pipeline_input::Builder::default()
    }
}

/// See [`GetImagePolicyInput`](crate::input::GetImagePolicyInput)
pub mod get_image_policy_input {
    /// A builder for [`GetImagePolicyInput`](crate::input::GetImagePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the image whose policy you want to retrieve.</p>
        pub fn image_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image whose policy you want to retrieve.</p>
        pub fn set_image_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetImagePolicyInput`](crate::input::GetImagePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetImagePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetImagePolicyInput {
                image_arn: self.image_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetImagePolicyInputOperationOutputAlias = crate::operation::GetImagePolicy;
#[doc(hidden)]
pub type GetImagePolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetImagePolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetImagePolicy`](crate::operation::GetImagePolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetImagePolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetImagePolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/GetImagePolicy").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetImagePolicyInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_15) = &_input.image_arn {
                    query.push_kv("imageArn", &aws_smithy_http::query::fmt_string(&inner_15));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetImagePolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetImagePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetImagePolicy",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetImagePolicyInput`](crate::input::GetImagePolicyInput)
    pub fn builder() -> crate::input::get_image_policy_input::Builder {
        crate::input::get_image_policy_input::Builder::default()
    }
}

/// See [`GetImageRecipeInput`](crate::input::GetImageRecipeInput)
pub mod get_image_recipe_input {
    /// A builder for [`GetImageRecipeInput`](crate::input::GetImageRecipeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_recipe_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the image recipe that you want to retrieve.</p>
        pub fn image_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_recipe_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe that you want to retrieve.</p>
        pub fn set_image_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_recipe_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetImageRecipeInput`](crate::input::GetImageRecipeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetImageRecipeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetImageRecipeInput {
                image_recipe_arn: self.image_recipe_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetImageRecipeInputOperationOutputAlias = crate::operation::GetImageRecipe;
#[doc(hidden)]
pub type GetImageRecipeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetImageRecipeInput {
    /// Consumes the builder and constructs an Operation<[`GetImageRecipe`](crate::operation::GetImageRecipe)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetImageRecipe,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetImageRecipeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/GetImageRecipe").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetImageRecipeInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_16) = &_input.image_recipe_arn {
                    query.push_kv(
                        "imageRecipeArn",
                        &aws_smithy_http::query::fmt_string(&inner_16),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetImageRecipeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetImageRecipe::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetImageRecipe",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetImageRecipeInput`](crate::input::GetImageRecipeInput)
    pub fn builder() -> crate::input::get_image_recipe_input::Builder {
        crate::input::get_image_recipe_input::Builder::default()
    }
}

/// See [`GetImageRecipePolicyInput`](crate::input::GetImageRecipePolicyInput)
pub mod get_image_recipe_policy_input {
    /// A builder for [`GetImageRecipePolicyInput`](crate::input::GetImageRecipePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_recipe_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the image recipe whose policy you want to retrieve.</p>
        pub fn image_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_recipe_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe whose policy you want to retrieve.</p>
        pub fn set_image_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_recipe_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetImageRecipePolicyInput`](crate::input::GetImageRecipePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetImageRecipePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetImageRecipePolicyInput {
                image_recipe_arn: self.image_recipe_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetImageRecipePolicyInputOperationOutputAlias = crate::operation::GetImageRecipePolicy;
#[doc(hidden)]
pub type GetImageRecipePolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetImageRecipePolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetImageRecipePolicy`](crate::operation::GetImageRecipePolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetImageRecipePolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetImageRecipePolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/GetImageRecipePolicy").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetImageRecipePolicyInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_17) = &_input.image_recipe_arn {
                    query.push_kv(
                        "imageRecipeArn",
                        &aws_smithy_http::query::fmt_string(&inner_17),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetImageRecipePolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetImageRecipePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetImageRecipePolicy",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetImageRecipePolicyInput`](crate::input::GetImageRecipePolicyInput)
    pub fn builder() -> crate::input::get_image_recipe_policy_input::Builder {
        crate::input::get_image_recipe_policy_input::Builder::default()
    }
}

/// See [`GetInfrastructureConfigurationInput`](crate::input::GetInfrastructureConfigurationInput)
pub mod get_infrastructure_configuration_input {
    /// A builder for [`GetInfrastructureConfigurationInput`](crate::input::GetInfrastructureConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) infrastructure_configuration_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that you want to retrieve.</p>
        pub fn infrastructure_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.infrastructure_configuration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that you want to retrieve.</p>
        pub fn set_infrastructure_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.infrastructure_configuration_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInfrastructureConfigurationInput`](crate::input::GetInfrastructureConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetInfrastructureConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetInfrastructureConfigurationInput {
                infrastructure_configuration_arn: self.infrastructure_configuration_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetInfrastructureConfigurationInputOperationOutputAlias =
    crate::operation::GetInfrastructureConfiguration;
#[doc(hidden)]
pub type GetInfrastructureConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetInfrastructureConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetInfrastructureConfiguration`](crate::operation::GetInfrastructureConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetInfrastructureConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetInfrastructureConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/GetInfrastructureConfiguration")
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetInfrastructureConfigurationInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_18) = &_input.infrastructure_configuration_arn {
                    query.push_kv(
                        "infrastructureConfigurationArn",
                        &aws_smithy_http::query::fmt_string(&inner_18),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetInfrastructureConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetInfrastructureConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetInfrastructureConfiguration",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetInfrastructureConfigurationInput`](crate::input::GetInfrastructureConfigurationInput)
    pub fn builder() -> crate::input::get_infrastructure_configuration_input::Builder {
        crate::input::get_infrastructure_configuration_input::Builder::default()
    }
}

/// See [`ImportComponentInput`](crate::input::ImportComponentInput)
pub mod import_component_input {
    /// A builder for [`ImportComponentInput`](crate::input::ImportComponentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) semantic_version: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) change_description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ComponentType>,
        pub(crate) format: std::option::Option<crate::model::ComponentFormat>,
        pub(crate) platform: std::option::Option<crate::model::Platform>,
        pub(crate) data: std::option::Option<std::string::String>,
        pub(crate) uri: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the component.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the component.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The semantic version of the component. This version follows the semantic version syntax.</p> <note>
        /// <p>The semantic version has four nodes: <major>
        /// .
        /// <minor>
        /// .
        /// <patch>
        /// /
        /// <build>
        /// . You can assign values for the first three, and can filter on all of them.
        /// </build>
        /// </patch>
        /// </minor>
        /// </major></p>
        /// <p> <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.</p>
        /// </note>
        pub fn semantic_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.semantic_version = Some(input.into());
            self
        }
        /// <p>The semantic version of the component. This version follows the semantic version syntax.</p> <note>
        /// <p>The semantic version has four nodes: <major>
        /// .
        /// <minor>
        /// .
        /// <patch>
        /// /
        /// <build>
        /// . You can assign values for the first three, and can filter on all of them.
        /// </build>
        /// </patch>
        /// </minor>
        /// </major></p>
        /// <p> <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.</p>
        /// </note>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.semantic_version = input;
            self
        }
        /// <p>The description of the component. Describes the contents of the component.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the component. Describes the contents of the component.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The change description of the component. Describes what change has been made in this version, or what makes this version different from other versions of this component.</p>
        pub fn change_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_description = Some(input.into());
            self
        }
        /// <p>The change description of the component. Describes what change has been made in this version, or what makes this version different from other versions of this component.</p>
        pub fn set_change_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.change_description = input;
            self
        }
        /// <p>The type of the component denotes whether the component is used to build the image, or only to test it.</p>
        pub fn r#type(mut self, input: crate::model::ComponentType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the component denotes whether the component is used to build the image, or only to test it.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ComponentType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The format of the resource that you want to import as a component.</p>
        pub fn format(mut self, input: crate::model::ComponentFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>The format of the resource that you want to import as a component.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::ComponentFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>The platform of the component.</p>
        pub fn platform(mut self, input: crate::model::Platform) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p>The platform of the component.</p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.platform = input;
            self
        }
        /// <p>The data of the component. Used to specify the data inline. Either <code>data</code> or <code>uri</code> can be used to specify the data within the component.</p>
        pub fn data(mut self, input: impl Into<std::string::String>) -> Self {
            self.data = Some(input.into());
            self
        }
        /// <p>The data of the component. Used to specify the data inline. Either <code>data</code> or <code>uri</code> can be used to specify the data within the component.</p>
        pub fn set_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data = input;
            self
        }
        /// <p>The uri of the component. Must be an Amazon S3 URL and the requester must have permission to access the Amazon S3 bucket. If you use Amazon S3, you can specify component content up to your service quota. Either <code>data</code> or <code>uri</code> can be used to specify the data within the component.</p>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.uri = Some(input.into());
            self
        }
        /// <p>The uri of the component. Must be an Amazon S3 URL and the requester must have permission to access the Amazon S3 bucket. If you use Amazon S3, you can specify component content up to your service quota. Either <code>data</code> or <code>uri</code> can be used to specify the data within the component.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uri = input;
            self
        }
        /// <p>The ID of the KMS key that should be used to encrypt this component.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the KMS key that should be used to encrypt this component.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags of the component.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags of the component.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The idempotency token of the component.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The idempotency token of the component.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportComponentInput`](crate::input::ImportComponentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ImportComponentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ImportComponentInput {
                name: self.name,
                semantic_version: self.semantic_version,
                description: self.description,
                change_description: self.change_description,
                r#type: self.r#type,
                format: self.format,
                platform: self.platform,
                data: self.data,
                uri: self.uri,
                kms_key_id: self.kms_key_id,
                tags: self.tags,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ImportComponentInputOperationOutputAlias = crate::operation::ImportComponent;
#[doc(hidden)]
pub type ImportComponentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ImportComponentInput {
    /// Consumes the builder and constructs an Operation<[`ImportComponent`](crate::operation::ImportComponent)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ImportComponent,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::ImportComponentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/ImportComponent").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ImportComponentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_import_component(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ImportComponent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ImportComponent",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ImportComponentInput`](crate::input::ImportComponentInput)
    pub fn builder() -> crate::input::import_component_input::Builder {
        crate::input::import_component_input::Builder::default()
    }
}

/// See [`ImportVmImageInput`](crate::input::ImportVmImageInput)
pub mod import_vm_image_input {
    /// A builder for [`ImportVmImageInput`](crate::input::ImportVmImageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) semantic_version: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<crate::model::Platform>,
        pub(crate) os_version: std::option::Option<std::string::String>,
        pub(crate) vm_import_task_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the base image that is created by the import process.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the base image that is created by the import process.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The semantic version to attach to the base image that was created during the import process. This version follows the semantic version syntax.</p> <note>
        /// <p>The semantic version has four nodes: <major>
        /// .
        /// <minor>
        /// .
        /// <patch>
        /// /
        /// <build>
        /// . You can assign values for the first three, and can filter on all of them.
        /// </build>
        /// </patch>
        /// </minor>
        /// </major></p>
        /// <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p>
        /// <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p>
        /// </note>
        pub fn semantic_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.semantic_version = Some(input.into());
            self
        }
        /// <p>The semantic version to attach to the base image that was created during the import process. This version follows the semantic version syntax.</p> <note>
        /// <p>The semantic version has four nodes: <major>
        /// .
        /// <minor>
        /// .
        /// <patch>
        /// /
        /// <build>
        /// . You can assign values for the first three, and can filter on all of them.
        /// </build>
        /// </patch>
        /// </minor>
        /// </major></p>
        /// <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p>
        /// <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p>
        /// </note>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.semantic_version = input;
            self
        }
        /// <p>The description for the base image that is created by the import process.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the base image that is created by the import process.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The operating system platform for the imported VM.</p>
        pub fn platform(mut self, input: crate::model::Platform) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p>The operating system platform for the imported VM.</p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.platform = input;
            self
        }
        /// <p>The operating system version for the imported VM.</p>
        pub fn os_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.os_version = Some(input.into());
            self
        }
        /// <p>The operating system version for the imported VM.</p>
        pub fn set_os_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.os_version = input;
            self
        }
        /// <p>The <code>importTaskId</code> (API) or <code>ImportTaskId</code> (CLI) from the Amazon EC2 VM import process. Image Builder retrieves information from the import process to pull in the AMI that is created from the VM source as the base image for your recipe.</p>
        pub fn vm_import_task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vm_import_task_id = Some(input.into());
            self
        }
        /// <p>The <code>importTaskId</code> (API) or <code>ImportTaskId</code> (CLI) from the Amazon EC2 VM import process. Image Builder retrieves information from the import process to pull in the AMI that is created from the VM source as the base image for your recipe.</p>
        pub fn set_vm_import_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vm_import_task_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags that are attached to the import resources.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags that are attached to the import resources.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportVmImageInput`](crate::input::ImportVmImageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ImportVmImageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ImportVmImageInput {
                name: self.name,
                semantic_version: self.semantic_version,
                description: self.description,
                platform: self.platform,
                os_version: self.os_version,
                vm_import_task_id: self.vm_import_task_id,
                tags: self.tags,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ImportVmImageInputOperationOutputAlias = crate::operation::ImportVmImage;
#[doc(hidden)]
pub type ImportVmImageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ImportVmImageInput {
    /// Consumes the builder and constructs an Operation<[`ImportVmImage`](crate::operation::ImportVmImage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ImportVmImage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::ImportVmImageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/ImportVmImage").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ImportVmImageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_import_vm_image(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ImportVmImage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ImportVmImage",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ImportVmImageInput`](crate::input::ImportVmImageInput)
    pub fn builder() -> crate::input::import_vm_image_input::Builder {
        crate::input::import_vm_image_input::Builder::default()
    }
}

/// See [`ListComponentBuildVersionsInput`](crate::input::ListComponentBuildVersionsInput)
pub mod list_component_build_versions_input {
    /// A builder for [`ListComponentBuildVersionsInput`](crate::input::ListComponentBuildVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) component_version_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The component version Amazon Resource Name (ARN) whose versions you want to list.</p>
        pub fn component_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_version_arn = Some(input.into());
            self
        }
        /// <p>The component version Amazon Resource Name (ARN) whose versions you want to list.</p>
        pub fn set_component_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_version_arn = input;
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListComponentBuildVersionsInput`](crate::input::ListComponentBuildVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListComponentBuildVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListComponentBuildVersionsInput {
                component_version_arn: self.component_version_arn,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListComponentBuildVersionsInputOperationOutputAlias =
    crate::operation::ListComponentBuildVersions;
#[doc(hidden)]
pub type ListComponentBuildVersionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListComponentBuildVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListComponentBuildVersions`](crate::operation::ListComponentBuildVersions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListComponentBuildVersions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListComponentBuildVersionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/ListComponentBuildVersions").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListComponentBuildVersionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_component_build_versions(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListComponentBuildVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListComponentBuildVersions",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListComponentBuildVersionsInput`](crate::input::ListComponentBuildVersionsInput)
    pub fn builder() -> crate::input::list_component_build_versions_input::Builder {
        crate::input::list_component_build_versions_input::Builder::default()
    }
}

/// See [`ListComponentsInput`](crate::input::ListComponentsInput)
pub mod list_components_input {
    /// A builder for [`ListComponentsInput`](crate::input::ListComponentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner: std::option::Option<crate::model::Ownership>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) by_name: std::option::Option<bool>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The owner defines which components you want to list. By default, this request will only show components owned by your account. You can use this field to specify if you want to view components owned by yourself, by Amazon, or those components that have been shared with you by other customers.</p>
        pub fn owner(mut self, input: crate::model::Ownership) -> Self {
            self.owner = Some(input);
            self
        }
        /// <p>The owner defines which components you want to list. By default, this request will only show components owned by your account. You can use this field to specify if you want to view components owned by yourself, by Amazon, or those components that have been shared with you by other customers.</p>
        pub fn set_owner(mut self, input: std::option::Option<crate::model::Ownership>) -> Self {
            self.owner = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li> <p> <code>description</code> </p> </li>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>platform</code> </p> </li>
        /// <li> <p> <code>supportedOsVersion</code> </p> </li>
        /// <li> <p> <code>type</code> </p> </li>
        /// <li> <p> <code>version</code> </p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li> <p> <code>description</code> </p> </li>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>platform</code> </p> </li>
        /// <li> <p> <code>supportedOsVersion</code> </p> </li>
        /// <li> <p> <code>type</code> </p> </li>
        /// <li> <p> <code>version</code> </p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>Returns the list of component build versions for the specified name.</p>
        pub fn by_name(mut self, input: bool) -> Self {
            self.by_name = Some(input);
            self
        }
        /// <p>Returns the list of component build versions for the specified name.</p>
        pub fn set_by_name(mut self, input: std::option::Option<bool>) -> Self {
            self.by_name = input;
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListComponentsInput`](crate::input::ListComponentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListComponentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListComponentsInput {
                owner: self.owner,
                filters: self.filters,
                by_name: self.by_name.unwrap_or_default(),
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListComponentsInputOperationOutputAlias = crate::operation::ListComponents;
#[doc(hidden)]
pub type ListComponentsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListComponentsInput {
    /// Consumes the builder and constructs an Operation<[`ListComponents`](crate::operation::ListComponents)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListComponents,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListComponentsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/ListComponents").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListComponentsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_components(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListComponents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListComponents",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListComponentsInput`](crate::input::ListComponentsInput)
    pub fn builder() -> crate::input::list_components_input::Builder {
        crate::input::list_components_input::Builder::default()
    }
}

/// See [`ListContainerRecipesInput`](crate::input::ListContainerRecipesInput)
pub mod list_container_recipes_input {
    /// A builder for [`ListContainerRecipesInput`](crate::input::ListContainerRecipesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner: std::option::Option<crate::model::Ownership>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Returns container recipes belonging to the specified owner, that have been shared with you. You can omit this field to return container recipes belonging to your account.</p>
        pub fn owner(mut self, input: crate::model::Ownership) -> Self {
            self.owner = Some(input);
            self
        }
        /// <p>Returns container recipes belonging to the specified owner, that have been shared with you. You can omit this field to return container recipes belonging to your account.</p>
        pub fn set_owner(mut self, input: std::option::Option<crate::model::Ownership>) -> Self {
            self.owner = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li> <p> <code>containerType</code> </p> </li>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>parentImage</code> </p> </li>
        /// <li> <p> <code>platform</code> </p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li> <p> <code>containerType</code> </p> </li>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>parentImage</code> </p> </li>
        /// <li> <p> <code>platform</code> </p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of results to return in the list.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in the list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Provides a token for pagination, which determines where to begin the next set of results when the current set reaches the maximum for one request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Provides a token for pagination, which determines where to begin the next set of results when the current set reaches the maximum for one request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListContainerRecipesInput`](crate::input::ListContainerRecipesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListContainerRecipesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListContainerRecipesInput {
                owner: self.owner,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListContainerRecipesInputOperationOutputAlias = crate::operation::ListContainerRecipes;
#[doc(hidden)]
pub type ListContainerRecipesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListContainerRecipesInput {
    /// Consumes the builder and constructs an Operation<[`ListContainerRecipes`](crate::operation::ListContainerRecipes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListContainerRecipes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListContainerRecipesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/ListContainerRecipes").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListContainerRecipesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_container_recipes(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListContainerRecipes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListContainerRecipes",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListContainerRecipesInput`](crate::input::ListContainerRecipesInput)
    pub fn builder() -> crate::input::list_container_recipes_input::Builder {
        crate::input::list_container_recipes_input::Builder::default()
    }
}

/// See [`ListDistributionConfigurationsInput`](crate::input::ListDistributionConfigurationsInput)
pub mod list_distribution_configurations_input {
    /// A builder for [`ListDistributionConfigurationsInput`](crate::input::ListDistributionConfigurationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>You can filter on <code>name</code> to streamline results.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>You can filter on <code>name</code> to streamline results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDistributionConfigurationsInput`](crate::input::ListDistributionConfigurationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDistributionConfigurationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDistributionConfigurationsInput {
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDistributionConfigurationsInputOperationOutputAlias =
    crate::operation::ListDistributionConfigurations;
#[doc(hidden)]
pub type ListDistributionConfigurationsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListDistributionConfigurationsInput {
    /// Consumes the builder and constructs an Operation<[`ListDistributionConfigurations`](crate::operation::ListDistributionConfigurations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDistributionConfigurations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListDistributionConfigurationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/ListDistributionConfigurations")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListDistributionConfigurationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_distribution_configurations(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDistributionConfigurations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDistributionConfigurations",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListDistributionConfigurationsInput`](crate::input::ListDistributionConfigurationsInput)
    pub fn builder() -> crate::input::list_distribution_configurations_input::Builder {
        crate::input::list_distribution_configurations_input::Builder::default()
    }
}

/// See [`ListImageBuildVersionsInput`](crate::input::ListImageBuildVersionsInput)
pub mod list_image_build_versions_input {
    /// A builder for [`ListImageBuildVersionsInput`](crate::input::ListImageBuildVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_version_arn: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the image whose build versions you want to retrieve.</p>
        pub fn image_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_version_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image whose build versions you want to retrieve.</p>
        pub fn set_image_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_version_arn = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>osVersion</code> </p> </li>
        /// <li> <p> <code>platform</code> </p> </li>
        /// <li> <p> <code>type</code> </p> </li>
        /// <li> <p> <code>version</code> </p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>osVersion</code> </p> </li>
        /// <li> <p> <code>platform</code> </p> </li>
        /// <li> <p> <code>type</code> </p> </li>
        /// <li> <p> <code>version</code> </p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListImageBuildVersionsInput`](crate::input::ListImageBuildVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListImageBuildVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListImageBuildVersionsInput {
                image_version_arn: self.image_version_arn,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListImageBuildVersionsInputOperationOutputAlias = crate::operation::ListImageBuildVersions;
#[doc(hidden)]
pub type ListImageBuildVersionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListImageBuildVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListImageBuildVersions`](crate::operation::ListImageBuildVersions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListImageBuildVersions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListImageBuildVersionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/ListImageBuildVersions").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListImageBuildVersionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_image_build_versions(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListImageBuildVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListImageBuildVersions",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListImageBuildVersionsInput`](crate::input::ListImageBuildVersionsInput)
    pub fn builder() -> crate::input::list_image_build_versions_input::Builder {
        crate::input::list_image_build_versions_input::Builder::default()
    }
}

/// See [`ListImagePackagesInput`](crate::input::ListImagePackagesInput)
pub mod list_image_packages_input {
    /// A builder for [`ListImagePackagesInput`](crate::input::ListImagePackagesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_build_version_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Filter results for the ListImagePackages request by the Image Build Version ARN</p>
        pub fn image_build_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_build_version_arn = Some(input.into());
            self
        }
        /// <p>Filter results for the ListImagePackages request by the Image Build Version ARN</p>
        pub fn set_image_build_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_build_version_arn = input;
            self
        }
        /// <p>The maxiumum number of results to return from the ListImagePackages request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maxiumum number of results to return from the ListImagePackages request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListImagePackagesInput`](crate::input::ListImagePackagesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListImagePackagesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListImagePackagesInput {
                image_build_version_arn: self.image_build_version_arn,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListImagePackagesInputOperationOutputAlias = crate::operation::ListImagePackages;
#[doc(hidden)]
pub type ListImagePackagesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListImagePackagesInput {
    /// Consumes the builder and constructs an Operation<[`ListImagePackages`](crate::operation::ListImagePackages)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListImagePackages,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListImagePackagesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/ListImagePackages").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListImagePackagesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_image_packages(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListImagePackages::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListImagePackages",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListImagePackagesInput`](crate::input::ListImagePackagesInput)
    pub fn builder() -> crate::input::list_image_packages_input::Builder {
        crate::input::list_image_packages_input::Builder::default()
    }
}

/// See [`ListImagePipelineImagesInput`](crate::input::ListImagePipelineImagesInput)
pub mod list_image_pipeline_images_input {
    /// A builder for [`ListImagePipelineImagesInput`](crate::input::ListImagePipelineImagesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_pipeline_arn: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the image pipeline whose images you want to view.</p>
        pub fn image_pipeline_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_pipeline_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline whose images you want to view.</p>
        pub fn set_image_pipeline_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_pipeline_arn = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>version</code> </p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>version</code> </p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListImagePipelineImagesInput`](crate::input::ListImagePipelineImagesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListImagePipelineImagesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListImagePipelineImagesInput {
                image_pipeline_arn: self.image_pipeline_arn,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListImagePipelineImagesInputOperationOutputAlias =
    crate::operation::ListImagePipelineImages;
#[doc(hidden)]
pub type ListImagePipelineImagesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListImagePipelineImagesInput {
    /// Consumes the builder and constructs an Operation<[`ListImagePipelineImages`](crate::operation::ListImagePipelineImages)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListImagePipelineImages,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListImagePipelineImagesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/ListImagePipelineImages").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListImagePipelineImagesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_image_pipeline_images(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListImagePipelineImages::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListImagePipelineImages",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListImagePipelineImagesInput`](crate::input::ListImagePipelineImagesInput)
    pub fn builder() -> crate::input::list_image_pipeline_images_input::Builder {
        crate::input::list_image_pipeline_images_input::Builder::default()
    }
}

/// See [`ListImagePipelinesInput`](crate::input::ListImagePipelinesInput)
pub mod list_image_pipelines_input {
    /// A builder for [`ListImagePipelinesInput`](crate::input::ListImagePipelinesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li> <p> <code>description</code> </p> </li>
        /// <li> <p> <code>distributionConfigurationArn</code> </p> </li>
        /// <li> <p> <code>imageRecipeArn</code> </p> </li>
        /// <li> <p> <code>infrastructureConfigurationArn</code> </p> </li>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>status</code> </p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li> <p> <code>description</code> </p> </li>
        /// <li> <p> <code>distributionConfigurationArn</code> </p> </li>
        /// <li> <p> <code>imageRecipeArn</code> </p> </li>
        /// <li> <p> <code>infrastructureConfigurationArn</code> </p> </li>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>status</code> </p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListImagePipelinesInput`](crate::input::ListImagePipelinesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListImagePipelinesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListImagePipelinesInput {
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListImagePipelinesInputOperationOutputAlias = crate::operation::ListImagePipelines;
#[doc(hidden)]
pub type ListImagePipelinesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListImagePipelinesInput {
    /// Consumes the builder and constructs an Operation<[`ListImagePipelines`](crate::operation::ListImagePipelines)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListImagePipelines,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListImagePipelinesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/ListImagePipelines").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListImagePipelinesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_image_pipelines(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListImagePipelines::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListImagePipelines",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListImagePipelinesInput`](crate::input::ListImagePipelinesInput)
    pub fn builder() -> crate::input::list_image_pipelines_input::Builder {
        crate::input::list_image_pipelines_input::Builder::default()
    }
}

/// See [`ListImageRecipesInput`](crate::input::ListImageRecipesInput)
pub mod list_image_recipes_input {
    /// A builder for [`ListImageRecipesInput`](crate::input::ListImageRecipesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner: std::option::Option<crate::model::Ownership>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The owner defines which image recipes you want to list. By default, this request will only show image recipes owned by your account. You can use this field to specify if you want to view image recipes owned by yourself, by Amazon, or those image recipes that have been shared with you by other customers.</p>
        pub fn owner(mut self, input: crate::model::Ownership) -> Self {
            self.owner = Some(input);
            self
        }
        /// <p>The owner defines which image recipes you want to list. By default, this request will only show image recipes owned by your account. You can use this field to specify if you want to view image recipes owned by yourself, by Amazon, or those image recipes that have been shared with you by other customers.</p>
        pub fn set_owner(mut self, input: std::option::Option<crate::model::Ownership>) -> Self {
            self.owner = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>parentImage</code> </p> </li>
        /// <li> <p> <code>platform</code> </p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>parentImage</code> </p> </li>
        /// <li> <p> <code>platform</code> </p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListImageRecipesInput`](crate::input::ListImageRecipesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListImageRecipesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListImageRecipesInput {
                owner: self.owner,
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListImageRecipesInputOperationOutputAlias = crate::operation::ListImageRecipes;
#[doc(hidden)]
pub type ListImageRecipesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListImageRecipesInput {
    /// Consumes the builder and constructs an Operation<[`ListImageRecipes`](crate::operation::ListImageRecipes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListImageRecipes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListImageRecipesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/ListImageRecipes").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListImageRecipesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_image_recipes(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListImageRecipes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListImageRecipes",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListImageRecipesInput`](crate::input::ListImageRecipesInput)
    pub fn builder() -> crate::input::list_image_recipes_input::Builder {
        crate::input::list_image_recipes_input::Builder::default()
    }
}

/// See [`ListImagesInput`](crate::input::ListImagesInput)
pub mod list_images_input {
    /// A builder for [`ListImagesInput`](crate::input::ListImagesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner: std::option::Option<crate::model::Ownership>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) by_name: std::option::Option<bool>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) include_deprecated: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The owner defines which images you want to list. By default, this request will only show images owned by your account. You can use this field to specify if you want to view images owned by yourself, by Amazon, or those images that have been shared with you by other customers.</p>
        pub fn owner(mut self, input: crate::model::Ownership) -> Self {
            self.owner = Some(input);
            self
        }
        /// <p>The owner defines which images you want to list. By default, this request will only show images owned by your account. You can use this field to specify if you want to view images owned by yourself, by Amazon, or those images that have been shared with you by other customers.</p>
        pub fn set_owner(mut self, input: std::option::Option<crate::model::Ownership>) -> Self {
            self.owner = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>osVersion</code> </p> </li>
        /// <li> <p> <code>platform</code> </p> </li>
        /// <li> <p> <code>type</code> </p> </li>
        /// <li> <p> <code>version</code> </p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>osVersion</code> </p> </li>
        /// <li> <p> <code>platform</code> </p> </li>
        /// <li> <p> <code>type</code> </p> </li>
        /// <li> <p> <code>version</code> </p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>Requests a list of images with a specific recipe name.</p>
        pub fn by_name(mut self, input: bool) -> Self {
            self.by_name = Some(input);
            self
        }
        /// <p>Requests a list of images with a specific recipe name.</p>
        pub fn set_by_name(mut self, input: std::option::Option<bool>) -> Self {
            self.by_name = input;
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Includes deprecated images in the response list.</p>
        pub fn include_deprecated(mut self, input: bool) -> Self {
            self.include_deprecated = Some(input);
            self
        }
        /// <p>Includes deprecated images in the response list.</p>
        pub fn set_include_deprecated(mut self, input: std::option::Option<bool>) -> Self {
            self.include_deprecated = input;
            self
        }
        /// Consumes the builder and constructs a [`ListImagesInput`](crate::input::ListImagesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListImagesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListImagesInput {
                owner: self.owner,
                filters: self.filters,
                by_name: self.by_name.unwrap_or_default(),
                max_results: self.max_results,
                next_token: self.next_token,
                include_deprecated: self.include_deprecated,
            })
        }
    }
}
#[doc(hidden)]
pub type ListImagesInputOperationOutputAlias = crate::operation::ListImages;
#[doc(hidden)]
pub type ListImagesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListImagesInput {
    /// Consumes the builder and constructs an Operation<[`ListImages`](crate::operation::ListImages)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListImages,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListImagesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/ListImages").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListImagesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_images(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListImages::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListImages",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListImagesInput`](crate::input::ListImagesInput)
    pub fn builder() -> crate::input::list_images_input::Builder {
        crate::input::list_images_input::Builder::default()
    }
}

/// See [`ListInfrastructureConfigurationsInput`](crate::input::ListInfrastructureConfigurationsInput)
pub mod list_infrastructure_configurations_input {
    /// A builder for [`ListInfrastructureConfigurationsInput`](crate::input::ListInfrastructureConfigurationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>You can filter on <code>name</code> to streamline results.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>You can filter on <code>name</code> to streamline results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInfrastructureConfigurationsInput`](crate::input::ListInfrastructureConfigurationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListInfrastructureConfigurationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListInfrastructureConfigurationsInput {
                filters: self.filters,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListInfrastructureConfigurationsInputOperationOutputAlias =
    crate::operation::ListInfrastructureConfigurations;
#[doc(hidden)]
pub type ListInfrastructureConfigurationsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListInfrastructureConfigurationsInput {
    /// Consumes the builder and constructs an Operation<[`ListInfrastructureConfigurations`](crate::operation::ListInfrastructureConfigurations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListInfrastructureConfigurations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListInfrastructureConfigurationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/ListInfrastructureConfigurations")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListInfrastructureConfigurationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_infrastructure_configurations(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListInfrastructureConfigurations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListInfrastructureConfigurations",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListInfrastructureConfigurationsInput`](crate::input::ListInfrastructureConfigurationsInput)
    pub fn builder() -> crate::input::list_infrastructure_configurations_input::Builder {
        crate::input::list_infrastructure_configurations_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags you want to retrieve.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags you want to retrieve.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_19 = &_input.resource_arn;
                let input_19 = input_19.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_19, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`PutComponentPolicyInput`](crate::input::PutComponentPolicyInput)
pub mod put_component_policy_input {
    /// A builder for [`PutComponentPolicyInput`](crate::input::PutComponentPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) component_arn: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the component that this policy should be applied to.</p>
        pub fn component_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the component that this policy should be applied to.</p>
        pub fn set_component_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_arn = input;
            self
        }
        /// <p>The policy to apply.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The policy to apply.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`PutComponentPolicyInput`](crate::input::PutComponentPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutComponentPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutComponentPolicyInput {
                component_arn: self.component_arn,
                policy: self.policy,
            })
        }
    }
}
#[doc(hidden)]
pub type PutComponentPolicyInputOperationOutputAlias = crate::operation::PutComponentPolicy;
#[doc(hidden)]
pub type PutComponentPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutComponentPolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutComponentPolicy`](crate::operation::PutComponentPolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutComponentPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutComponentPolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/PutComponentPolicy").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutComponentPolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_component_policy(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutComponentPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutComponentPolicy",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutComponentPolicyInput`](crate::input::PutComponentPolicyInput)
    pub fn builder() -> crate::input::put_component_policy_input::Builder {
        crate::input::put_component_policy_input::Builder::default()
    }
}

/// See [`PutContainerRecipePolicyInput`](crate::input::PutContainerRecipePolicyInput)
pub mod put_container_recipe_policy_input {
    /// A builder for [`PutContainerRecipePolicyInput`](crate::input::PutContainerRecipePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_recipe_arn: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the container recipe that this policy should be applied to.</p>
        pub fn container_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_recipe_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe that this policy should be applied to.</p>
        pub fn set_container_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_recipe_arn = input;
            self
        }
        /// <p>The policy to apply to the container recipe.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The policy to apply to the container recipe.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`PutContainerRecipePolicyInput`](crate::input::PutContainerRecipePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutContainerRecipePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutContainerRecipePolicyInput {
                container_recipe_arn: self.container_recipe_arn,
                policy: self.policy,
            })
        }
    }
}
#[doc(hidden)]
pub type PutContainerRecipePolicyInputOperationOutputAlias =
    crate::operation::PutContainerRecipePolicy;
#[doc(hidden)]
pub type PutContainerRecipePolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutContainerRecipePolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutContainerRecipePolicy`](crate::operation::PutContainerRecipePolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutContainerRecipePolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutContainerRecipePolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/PutContainerRecipePolicy").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutContainerRecipePolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_container_recipe_policy(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutContainerRecipePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutContainerRecipePolicy",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutContainerRecipePolicyInput`](crate::input::PutContainerRecipePolicyInput)
    pub fn builder() -> crate::input::put_container_recipe_policy_input::Builder {
        crate::input::put_container_recipe_policy_input::Builder::default()
    }
}

/// See [`PutImagePolicyInput`](crate::input::PutImagePolicyInput)
pub mod put_image_policy_input {
    /// A builder for [`PutImagePolicyInput`](crate::input::PutImagePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_arn: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the image that this policy should be applied to.</p>
        pub fn image_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image that this policy should be applied to.</p>
        pub fn set_image_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_arn = input;
            self
        }
        /// <p>The policy to apply.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The policy to apply.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`PutImagePolicyInput`](crate::input::PutImagePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutImagePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutImagePolicyInput {
                image_arn: self.image_arn,
                policy: self.policy,
            })
        }
    }
}
#[doc(hidden)]
pub type PutImagePolicyInputOperationOutputAlias = crate::operation::PutImagePolicy;
#[doc(hidden)]
pub type PutImagePolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutImagePolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutImagePolicy`](crate::operation::PutImagePolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutImagePolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutImagePolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/PutImagePolicy").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutImagePolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_image_policy(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutImagePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutImagePolicy",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutImagePolicyInput`](crate::input::PutImagePolicyInput)
    pub fn builder() -> crate::input::put_image_policy_input::Builder {
        crate::input::put_image_policy_input::Builder::default()
    }
}

/// See [`PutImageRecipePolicyInput`](crate::input::PutImageRecipePolicyInput)
pub mod put_image_recipe_policy_input {
    /// A builder for [`PutImageRecipePolicyInput`](crate::input::PutImageRecipePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_recipe_arn: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the image recipe that this policy should be applied to.</p>
        pub fn image_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_recipe_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe that this policy should be applied to.</p>
        pub fn set_image_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_recipe_arn = input;
            self
        }
        /// <p>The policy to apply.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The policy to apply.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`PutImageRecipePolicyInput`](crate::input::PutImageRecipePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutImageRecipePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutImageRecipePolicyInput {
                image_recipe_arn: self.image_recipe_arn,
                policy: self.policy,
            })
        }
    }
}
#[doc(hidden)]
pub type PutImageRecipePolicyInputOperationOutputAlias = crate::operation::PutImageRecipePolicy;
#[doc(hidden)]
pub type PutImageRecipePolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutImageRecipePolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutImageRecipePolicy`](crate::operation::PutImageRecipePolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutImageRecipePolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutImageRecipePolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/PutImageRecipePolicy").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutImageRecipePolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_image_recipe_policy(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutImageRecipePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutImageRecipePolicy",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutImageRecipePolicyInput`](crate::input::PutImageRecipePolicyInput)
    pub fn builder() -> crate::input::put_image_recipe_policy_input::Builder {
        crate::input::put_image_recipe_policy_input::Builder::default()
    }
}

/// See [`StartImagePipelineExecutionInput`](crate::input::StartImagePipelineExecutionInput)
pub mod start_image_pipeline_execution_input {
    /// A builder for [`StartImagePipelineExecutionInput`](crate::input::StartImagePipelineExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_pipeline_arn: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the image pipeline that you want to manually invoke.</p>
        pub fn image_pipeline_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_pipeline_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline that you want to manually invoke.</p>
        pub fn set_image_pipeline_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_pipeline_arn = input;
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`StartImagePipelineExecutionInput`](crate::input::StartImagePipelineExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartImagePipelineExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartImagePipelineExecutionInput {
                image_pipeline_arn: self.image_pipeline_arn,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type StartImagePipelineExecutionInputOperationOutputAlias =
    crate::operation::StartImagePipelineExecution;
#[doc(hidden)]
pub type StartImagePipelineExecutionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartImagePipelineExecutionInput {
    /// Consumes the builder and constructs an Operation<[`StartImagePipelineExecution`](crate::operation::StartImagePipelineExecution)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartImagePipelineExecution,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::StartImagePipelineExecutionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/StartImagePipelineExecution").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StartImagePipelineExecutionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_image_pipeline_execution(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartImagePipelineExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartImagePipelineExecution",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StartImagePipelineExecutionInput`](crate::input::StartImagePipelineExecutionInput)
    pub fn builder() -> crate::input::start_image_pipeline_execution_input::Builder {
        crate::input::start_image_pipeline_execution_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to apply to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_20 = &_input.resource_arn;
                let input_20 = input_20.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_20, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to untag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to untag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tag keys to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UntagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_21 = &_input.resource_arn;
                let input_21 = input_21.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_21, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UntagResourceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_22) = &_input.tag_keys {
                    for inner_23 in inner_22 {
                        query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_23));
                    }
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UntagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateDistributionConfigurationInput`](crate::input::UpdateDistributionConfigurationInput)
pub mod update_distribution_configuration_input {
    /// A builder for [`UpdateDistributionConfigurationInput`](crate::input::UpdateDistributionConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution_configuration_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) distributions: std::option::Option<std::vec::Vec<crate::model::Distribution>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration that you want to update.</p>
        pub fn distribution_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.distribution_configuration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration that you want to update.</p>
        pub fn set_distribution_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.distribution_configuration_arn = input;
            self
        }
        /// <p>The description of the distribution configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the distribution configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `distributions`.
        ///
        /// To override the contents of this collection use [`set_distributions`](Self::set_distributions).
        ///
        /// <p>The distributions of the distribution configuration.</p>
        pub fn distributions(mut self, input: crate::model::Distribution) -> Self {
            let mut v = self.distributions.unwrap_or_default();
            v.push(input);
            self.distributions = Some(v);
            self
        }
        /// <p>The distributions of the distribution configuration.</p>
        pub fn set_distributions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Distribution>>,
        ) -> Self {
            self.distributions = input;
            self
        }
        /// <p>The idempotency token of the distribution configuration.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The idempotency token of the distribution configuration.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDistributionConfigurationInput`](crate::input::UpdateDistributionConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDistributionConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDistributionConfigurationInput {
                distribution_configuration_arn: self.distribution_configuration_arn,
                description: self.description,
                distributions: self.distributions,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDistributionConfigurationInputOperationOutputAlias =
    crate::operation::UpdateDistributionConfiguration;
#[doc(hidden)]
pub type UpdateDistributionConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateDistributionConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDistributionConfiguration`](crate::operation::UpdateDistributionConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDistributionConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateDistributionConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/UpdateDistributionConfiguration")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateDistributionConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_distribution_configuration(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDistributionConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDistributionConfiguration",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateDistributionConfigurationInput`](crate::input::UpdateDistributionConfigurationInput)
    pub fn builder() -> crate::input::update_distribution_configuration_input::Builder {
        crate::input::update_distribution_configuration_input::Builder::default()
    }
}

/// See [`UpdateImagePipelineInput`](crate::input::UpdateImagePipelineInput)
pub mod update_image_pipeline_input {
    /// A builder for [`UpdateImagePipelineInput`](crate::input::UpdateImagePipelineInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_pipeline_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) image_recipe_arn: std::option::Option<std::string::String>,
        pub(crate) container_recipe_arn: std::option::Option<std::string::String>,
        pub(crate) infrastructure_configuration_arn: std::option::Option<std::string::String>,
        pub(crate) distribution_configuration_arn: std::option::Option<std::string::String>,
        pub(crate) image_tests_configuration:
            std::option::Option<crate::model::ImageTestsConfiguration>,
        pub(crate) enhanced_image_metadata_enabled: std::option::Option<bool>,
        pub(crate) schedule: std::option::Option<crate::model::Schedule>,
        pub(crate) status: std::option::Option<crate::model::PipelineStatus>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the image pipeline that you want to update.</p>
        pub fn image_pipeline_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_pipeline_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline that you want to update.</p>
        pub fn set_image_pipeline_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_pipeline_arn = input;
            self
        }
        /// <p>The description of the image pipeline.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the image pipeline.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe that will be used to configure images updated by this image pipeline.</p>
        pub fn image_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_recipe_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe that will be used to configure images updated by this image pipeline.</p>
        pub fn set_image_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_recipe_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container pipeline to update.</p>
        pub fn container_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_recipe_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container pipeline to update.</p>
        pub fn set_container_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_recipe_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to build images updated by this image pipeline.</p>
        pub fn infrastructure_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.infrastructure_configuration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to build images updated by this image pipeline.</p>
        pub fn set_infrastructure_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.infrastructure_configuration_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration that will be used to configure and distribute images updated by this image pipeline.</p>
        pub fn distribution_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.distribution_configuration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration that will be used to configure and distribute images updated by this image pipeline.</p>
        pub fn set_distribution_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.distribution_configuration_arn = input;
            self
        }
        /// <p>The image test configuration of the image pipeline.</p>
        pub fn image_tests_configuration(
            mut self,
            input: crate::model::ImageTestsConfiguration,
        ) -> Self {
            self.image_tests_configuration = Some(input);
            self
        }
        /// <p>The image test configuration of the image pipeline.</p>
        pub fn set_image_tests_configuration(
            mut self,
            input: std::option::Option<crate::model::ImageTestsConfiguration>,
        ) -> Self {
            self.image_tests_configuration = input;
            self
        }
        /// <p> Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.</p>
        pub fn enhanced_image_metadata_enabled(mut self, input: bool) -> Self {
            self.enhanced_image_metadata_enabled = Some(input);
            self
        }
        /// <p> Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.</p>
        pub fn set_enhanced_image_metadata_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enhanced_image_metadata_enabled = input;
            self
        }
        /// <p>The schedule of the image pipeline.</p>
        pub fn schedule(mut self, input: crate::model::Schedule) -> Self {
            self.schedule = Some(input);
            self
        }
        /// <p>The schedule of the image pipeline.</p>
        pub fn set_schedule(mut self, input: std::option::Option<crate::model::Schedule>) -> Self {
            self.schedule = input;
            self
        }
        /// <p>The status of the image pipeline.</p>
        pub fn status(mut self, input: crate::model::PipelineStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the image pipeline.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PipelineStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateImagePipelineInput`](crate::input::UpdateImagePipelineInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateImagePipelineInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateImagePipelineInput {
                image_pipeline_arn: self.image_pipeline_arn,
                description: self.description,
                image_recipe_arn: self.image_recipe_arn,
                container_recipe_arn: self.container_recipe_arn,
                infrastructure_configuration_arn: self.infrastructure_configuration_arn,
                distribution_configuration_arn: self.distribution_configuration_arn,
                image_tests_configuration: self.image_tests_configuration,
                enhanced_image_metadata_enabled: self.enhanced_image_metadata_enabled,
                schedule: self.schedule,
                status: self.status,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateImagePipelineInputOperationOutputAlias = crate::operation::UpdateImagePipeline;
#[doc(hidden)]
pub type UpdateImagePipelineInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateImagePipelineInput {
    /// Consumes the builder and constructs an Operation<[`UpdateImagePipeline`](crate::operation::UpdateImagePipeline)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateImagePipeline,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateImagePipelineInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/UpdateImagePipeline").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateImagePipelineInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_image_pipeline(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateImagePipeline::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateImagePipeline",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateImagePipelineInput`](crate::input::UpdateImagePipelineInput)
    pub fn builder() -> crate::input::update_image_pipeline_input::Builder {
        crate::input::update_image_pipeline_input::Builder::default()
    }
}

/// See [`UpdateInfrastructureConfigurationInput`](crate::input::UpdateInfrastructureConfigurationInput)
pub mod update_infrastructure_configuration_input {
    /// A builder for [`UpdateInfrastructureConfigurationInput`](crate::input::UpdateInfrastructureConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) infrastructure_configuration_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) instance_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) instance_profile_name: std::option::Option<std::string::String>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) logging: std::option::Option<crate::model::Logging>,
        pub(crate) key_pair: std::option::Option<std::string::String>,
        pub(crate) terminate_instance_on_failure: std::option::Option<bool>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) resource_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) instance_metadata_options:
            std::option::Option<crate::model::InstanceMetadataOptions>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that you want to update.</p>
        pub fn infrastructure_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.infrastructure_configuration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that you want to update.</p>
        pub fn set_infrastructure_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.infrastructure_configuration_arn = input;
            self
        }
        /// <p>The description of the infrastructure configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the infrastructure configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `instance_types`.
        ///
        /// To override the contents of this collection use [`set_instance_types`](Self::set_instance_types).
        ///
        /// <p>The instance types of the infrastructure configuration. You can specify one or more instance types to use for this build. The service will pick one of these instance types based on availability.</p>
        pub fn instance_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_types.unwrap_or_default();
            v.push(input.into());
            self.instance_types = Some(v);
            self
        }
        /// <p>The instance types of the infrastructure configuration. You can specify one or more instance types to use for this build. The service will pick one of these instance types based on availability.</p>
        pub fn set_instance_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_types = input;
            self
        }
        /// <p>The instance profile to associate with the instance used to customize your Amazon EC2 AMI.</p>
        pub fn instance_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_profile_name = Some(input.into());
            self
        }
        /// <p>The instance profile to associate with the instance used to customize your Amazon EC2 AMI.</p>
        pub fn set_instance_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_profile_name = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// <p>The subnet ID to place the instance used to customize your Amazon EC2 AMI in.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The subnet ID to place the instance used to customize your Amazon EC2 AMI in.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>The logging configuration of the infrastructure configuration.</p>
        pub fn logging(mut self, input: crate::model::Logging) -> Self {
            self.logging = Some(input);
            self
        }
        /// <p>The logging configuration of the infrastructure configuration.</p>
        pub fn set_logging(mut self, input: std::option::Option<crate::model::Logging>) -> Self {
            self.logging = input;
            self
        }
        /// <p>The key pair of the infrastructure configuration. You can use this to log on to and debug the instance used to create your image.</p>
        pub fn key_pair(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_pair = Some(input.into());
            self
        }
        /// <p>The key pair of the infrastructure configuration. You can use this to log on to and debug the instance used to create your image.</p>
        pub fn set_key_pair(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_pair = input;
            self
        }
        /// <p>The terminate instance on failure setting of the infrastructure configuration. Set to false if you want Image Builder to retain the instance used to configure your AMI if the build or test phase of your workflow fails.</p>
        pub fn terminate_instance_on_failure(mut self, input: bool) -> Self {
            self.terminate_instance_on_failure = Some(input);
            self
        }
        /// <p>The terminate instance on failure setting of the infrastructure configuration. Set to false if you want Image Builder to retain the instance used to configure your AMI if the build or test phase of your workflow fails.</p>
        pub fn set_terminate_instance_on_failure(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.terminate_instance_on_failure = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the SNS topic to which we send image build event notifications.</p> <note>
        /// <p>EC2 Image Builder is unable to send notifications to SNS topics that are encrypted using keys from other accounts. The key that is used to encrypt the SNS topic must reside in the account that the Image Builder service runs under.</p>
        /// </note>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the SNS topic to which we send image build event notifications.</p> <note>
        /// <p>EC2 Image Builder is unable to send notifications to SNS topics that are encrypted using keys from other accounts. The key that is used to encrypt the SNS topic must reside in the account that the Image Builder service runs under.</p>
        /// </note>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Adds a key-value pair to `resource_tags`.
        ///
        /// To override the contents of this collection use [`set_resource_tags`](Self::set_resource_tags).
        ///
        /// <p>The tags attached to the resource created by Image Builder.</p>
        pub fn resource_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.resource_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.resource_tags = Some(hash_map);
            self
        }
        /// <p>The tags attached to the resource created by Image Builder.</p>
        pub fn set_resource_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.resource_tags = input;
            self
        }
        /// <p>The instance metadata options that you can set for the HTTP requests that pipeline builds use to launch EC2 build and test instances. For more information about instance metadata options, see one of the following links:</p>
        /// <ul>
        /// <li> <p> <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-options.html">Configure the instance metadata options</a> in the <i> <i>Amazon EC2 User Guide</i> </i> for Linux instances.</p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/configuring-instance-metadata-options.html">Configure the instance metadata options</a> in the <i> <i>Amazon EC2 Windows Guide</i> </i> for Windows instances.</p> </li>
        /// </ul>
        pub fn instance_metadata_options(
            mut self,
            input: crate::model::InstanceMetadataOptions,
        ) -> Self {
            self.instance_metadata_options = Some(input);
            self
        }
        /// <p>The instance metadata options that you can set for the HTTP requests that pipeline builds use to launch EC2 build and test instances. For more information about instance metadata options, see one of the following links:</p>
        /// <ul>
        /// <li> <p> <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-options.html">Configure the instance metadata options</a> in the <i> <i>Amazon EC2 User Guide</i> </i> for Linux instances.</p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/configuring-instance-metadata-options.html">Configure the instance metadata options</a> in the <i> <i>Amazon EC2 Windows Guide</i> </i> for Windows instances.</p> </li>
        /// </ul>
        pub fn set_instance_metadata_options(
            mut self,
            input: std::option::Option<crate::model::InstanceMetadataOptions>,
        ) -> Self {
            self.instance_metadata_options = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateInfrastructureConfigurationInput`](crate::input::UpdateInfrastructureConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateInfrastructureConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateInfrastructureConfigurationInput {
                infrastructure_configuration_arn: self.infrastructure_configuration_arn,
                description: self.description,
                instance_types: self.instance_types,
                instance_profile_name: self.instance_profile_name,
                security_group_ids: self.security_group_ids,
                subnet_id: self.subnet_id,
                logging: self.logging,
                key_pair: self.key_pair,
                terminate_instance_on_failure: self.terminate_instance_on_failure,
                sns_topic_arn: self.sns_topic_arn,
                client_token: self.client_token,
                resource_tags: self.resource_tags,
                instance_metadata_options: self.instance_metadata_options,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateInfrastructureConfigurationInputOperationOutputAlias =
    crate::operation::UpdateInfrastructureConfiguration;
#[doc(hidden)]
pub type UpdateInfrastructureConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateInfrastructureConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateInfrastructureConfiguration`](crate::operation::UpdateInfrastructureConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateInfrastructureConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateInfrastructureConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/UpdateInfrastructureConfiguration")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateInfrastructureConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_infrastructure_configuration(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateInfrastructureConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateInfrastructureConfiguration",
            "imagebuilder",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateInfrastructureConfigurationInput`](crate::input::UpdateInfrastructureConfigurationInput)
    pub fn builder() -> crate::input::update_infrastructure_configuration_input::Builder {
        crate::input::update_infrastructure_configuration_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateInfrastructureConfigurationInput {
    /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that you want to update.</p>
    pub infrastructure_configuration_arn: std::option::Option<std::string::String>,
    /// <p>The description of the infrastructure configuration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The instance types of the infrastructure configuration. You can specify one or more instance types to use for this build. The service will pick one of these instance types based on availability.</p>
    pub instance_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The instance profile to associate with the instance used to customize your Amazon EC2 AMI.</p>
    pub instance_profile_name: std::option::Option<std::string::String>,
    /// <p>The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The subnet ID to place the instance used to customize your Amazon EC2 AMI in.</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>The logging configuration of the infrastructure configuration.</p>
    pub logging: std::option::Option<crate::model::Logging>,
    /// <p>The key pair of the infrastructure configuration. You can use this to log on to and debug the instance used to create your image.</p>
    pub key_pair: std::option::Option<std::string::String>,
    /// <p>The terminate instance on failure setting of the infrastructure configuration. Set to false if you want Image Builder to retain the instance used to configure your AMI if the build or test phase of your workflow fails.</p>
    pub terminate_instance_on_failure: std::option::Option<bool>,
    /// <p>The Amazon Resource Name (ARN) for the SNS topic to which we send image build event notifications.</p> <note>
    /// <p>EC2 Image Builder is unable to send notifications to SNS topics that are encrypted using keys from other accounts. The key that is used to encrypt the SNS topic must reside in the account that the Image Builder service runs under.</p>
    /// </note>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>The idempotency token used to make this request idempotent.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The tags attached to the resource created by Image Builder.</p>
    pub resource_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The instance metadata options that you can set for the HTTP requests that pipeline builds use to launch EC2 build and test instances. For more information about instance metadata options, see one of the following links:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-options.html">Configure the instance metadata options</a> in the <i> <i>Amazon EC2 User Guide</i> </i> for Linux instances.</p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/configuring-instance-metadata-options.html">Configure the instance metadata options</a> in the <i> <i>Amazon EC2 Windows Guide</i> </i> for Windows instances.</p> </li>
    /// </ul>
    pub instance_metadata_options: std::option::Option<crate::model::InstanceMetadataOptions>,
}
impl UpdateInfrastructureConfigurationInput {
    /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that you want to update.</p>
    pub fn infrastructure_configuration_arn(&self) -> std::option::Option<&str> {
        self.infrastructure_configuration_arn.as_deref()
    }
    /// <p>The description of the infrastructure configuration.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The instance types of the infrastructure configuration. You can specify one or more instance types to use for this build. The service will pick one of these instance types based on availability.</p>
    pub fn instance_types(&self) -> std::option::Option<&[std::string::String]> {
        self.instance_types.as_deref()
    }
    /// <p>The instance profile to associate with the instance used to customize your Amazon EC2 AMI.</p>
    pub fn instance_profile_name(&self) -> std::option::Option<&str> {
        self.instance_profile_name.as_deref()
    }
    /// <p>The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
    /// <p>The subnet ID to place the instance used to customize your Amazon EC2 AMI in.</p>
    pub fn subnet_id(&self) -> std::option::Option<&str> {
        self.subnet_id.as_deref()
    }
    /// <p>The logging configuration of the infrastructure configuration.</p>
    pub fn logging(&self) -> std::option::Option<&crate::model::Logging> {
        self.logging.as_ref()
    }
    /// <p>The key pair of the infrastructure configuration. You can use this to log on to and debug the instance used to create your image.</p>
    pub fn key_pair(&self) -> std::option::Option<&str> {
        self.key_pair.as_deref()
    }
    /// <p>The terminate instance on failure setting of the infrastructure configuration. Set to false if you want Image Builder to retain the instance used to configure your AMI if the build or test phase of your workflow fails.</p>
    pub fn terminate_instance_on_failure(&self) -> std::option::Option<bool> {
        self.terminate_instance_on_failure
    }
    /// <p>The Amazon Resource Name (ARN) for the SNS topic to which we send image build event notifications.</p> <note>
    /// <p>EC2 Image Builder is unable to send notifications to SNS topics that are encrypted using keys from other accounts. The key that is used to encrypt the SNS topic must reside in the account that the Image Builder service runs under.</p>
    /// </note>
    pub fn sns_topic_arn(&self) -> std::option::Option<&str> {
        self.sns_topic_arn.as_deref()
    }
    /// <p>The idempotency token used to make this request idempotent.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The tags attached to the resource created by Image Builder.</p>
    pub fn resource_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.resource_tags.as_ref()
    }
    /// <p>The instance metadata options that you can set for the HTTP requests that pipeline builds use to launch EC2 build and test instances. For more information about instance metadata options, see one of the following links:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-options.html">Configure the instance metadata options</a> in the <i> <i>Amazon EC2 User Guide</i> </i> for Linux instances.</p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/configuring-instance-metadata-options.html">Configure the instance metadata options</a> in the <i> <i>Amazon EC2 Windows Guide</i> </i> for Windows instances.</p> </li>
    /// </ul>
    pub fn instance_metadata_options(
        &self,
    ) -> std::option::Option<&crate::model::InstanceMetadataOptions> {
        self.instance_metadata_options.as_ref()
    }
}
impl std::fmt::Debug for UpdateInfrastructureConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateInfrastructureConfigurationInput");
        formatter.field(
            "infrastructure_configuration_arn",
            &self.infrastructure_configuration_arn,
        );
        formatter.field("description", &self.description);
        formatter.field("instance_types", &self.instance_types);
        formatter.field("instance_profile_name", &self.instance_profile_name);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("logging", &self.logging);
        formatter.field("key_pair", &self.key_pair);
        formatter.field(
            "terminate_instance_on_failure",
            &self.terminate_instance_on_failure,
        );
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field("client_token", &self.client_token);
        formatter.field("resource_tags", &self.resource_tags);
        formatter.field("instance_metadata_options", &self.instance_metadata_options);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateImagePipelineInput {
    /// <p>The Amazon Resource Name (ARN) of the image pipeline that you want to update.</p>
    pub image_pipeline_arn: std::option::Option<std::string::String>,
    /// <p>The description of the image pipeline.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the image recipe that will be used to configure images updated by this image pipeline.</p>
    pub image_recipe_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the container pipeline to update.</p>
    pub container_recipe_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to build images updated by this image pipeline.</p>
    pub infrastructure_configuration_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the distribution configuration that will be used to configure and distribute images updated by this image pipeline.</p>
    pub distribution_configuration_arn: std::option::Option<std::string::String>,
    /// <p>The image test configuration of the image pipeline.</p>
    pub image_tests_configuration: std::option::Option<crate::model::ImageTestsConfiguration>,
    /// <p> Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.</p>
    pub enhanced_image_metadata_enabled: std::option::Option<bool>,
    /// <p>The schedule of the image pipeline.</p>
    pub schedule: std::option::Option<crate::model::Schedule>,
    /// <p>The status of the image pipeline.</p>
    pub status: std::option::Option<crate::model::PipelineStatus>,
    /// <p>The idempotency token used to make this request idempotent.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl UpdateImagePipelineInput {
    /// <p>The Amazon Resource Name (ARN) of the image pipeline that you want to update.</p>
    pub fn image_pipeline_arn(&self) -> std::option::Option<&str> {
        self.image_pipeline_arn.as_deref()
    }
    /// <p>The description of the image pipeline.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the image recipe that will be used to configure images updated by this image pipeline.</p>
    pub fn image_recipe_arn(&self) -> std::option::Option<&str> {
        self.image_recipe_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the container pipeline to update.</p>
    pub fn container_recipe_arn(&self) -> std::option::Option<&str> {
        self.container_recipe_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to build images updated by this image pipeline.</p>
    pub fn infrastructure_configuration_arn(&self) -> std::option::Option<&str> {
        self.infrastructure_configuration_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the distribution configuration that will be used to configure and distribute images updated by this image pipeline.</p>
    pub fn distribution_configuration_arn(&self) -> std::option::Option<&str> {
        self.distribution_configuration_arn.as_deref()
    }
    /// <p>The image test configuration of the image pipeline.</p>
    pub fn image_tests_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ImageTestsConfiguration> {
        self.image_tests_configuration.as_ref()
    }
    /// <p> Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.</p>
    pub fn enhanced_image_metadata_enabled(&self) -> std::option::Option<bool> {
        self.enhanced_image_metadata_enabled
    }
    /// <p>The schedule of the image pipeline.</p>
    pub fn schedule(&self) -> std::option::Option<&crate::model::Schedule> {
        self.schedule.as_ref()
    }
    /// <p>The status of the image pipeline.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::PipelineStatus> {
        self.status.as_ref()
    }
    /// <p>The idempotency token used to make this request idempotent.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateImagePipelineInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateImagePipelineInput");
        formatter.field("image_pipeline_arn", &self.image_pipeline_arn);
        formatter.field("description", &self.description);
        formatter.field("image_recipe_arn", &self.image_recipe_arn);
        formatter.field("container_recipe_arn", &self.container_recipe_arn);
        formatter.field(
            "infrastructure_configuration_arn",
            &self.infrastructure_configuration_arn,
        );
        formatter.field(
            "distribution_configuration_arn",
            &self.distribution_configuration_arn,
        );
        formatter.field("image_tests_configuration", &self.image_tests_configuration);
        formatter.field(
            "enhanced_image_metadata_enabled",
            &self.enhanced_image_metadata_enabled,
        );
        formatter.field("schedule", &self.schedule);
        formatter.field("status", &self.status);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDistributionConfigurationInput {
    /// <p>The Amazon Resource Name (ARN) of the distribution configuration that you want to update.</p>
    pub distribution_configuration_arn: std::option::Option<std::string::String>,
    /// <p>The description of the distribution configuration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The distributions of the distribution configuration.</p>
    pub distributions: std::option::Option<std::vec::Vec<crate::model::Distribution>>,
    /// <p>The idempotency token of the distribution configuration.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl UpdateDistributionConfigurationInput {
    /// <p>The Amazon Resource Name (ARN) of the distribution configuration that you want to update.</p>
    pub fn distribution_configuration_arn(&self) -> std::option::Option<&str> {
        self.distribution_configuration_arn.as_deref()
    }
    /// <p>The description of the distribution configuration.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The distributions of the distribution configuration.</p>
    pub fn distributions(&self) -> std::option::Option<&[crate::model::Distribution]> {
        self.distributions.as_deref()
    }
    /// <p>The idempotency token of the distribution configuration.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateDistributionConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDistributionConfigurationInput");
        formatter.field(
            "distribution_configuration_arn",
            &self.distribution_configuration_arn,
        );
        formatter.field("description", &self.description);
        formatter.field("distributions", &self.distributions);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource that you want to untag.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tag keys to remove from the resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource that you want to untag.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tag keys to remove from the resource.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource that you want to tag.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags to apply to the resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource that you want to tag.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tags to apply to the resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartImagePipelineExecutionInput {
    /// <p>The Amazon Resource Name (ARN) of the image pipeline that you want to manually invoke.</p>
    pub image_pipeline_arn: std::option::Option<std::string::String>,
    /// <p>The idempotency token used to make this request idempotent.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl StartImagePipelineExecutionInput {
    /// <p>The Amazon Resource Name (ARN) of the image pipeline that you want to manually invoke.</p>
    pub fn image_pipeline_arn(&self) -> std::option::Option<&str> {
        self.image_pipeline_arn.as_deref()
    }
    /// <p>The idempotency token used to make this request idempotent.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for StartImagePipelineExecutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartImagePipelineExecutionInput");
        formatter.field("image_pipeline_arn", &self.image_pipeline_arn);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutImageRecipePolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the image recipe that this policy should be applied to.</p>
    pub image_recipe_arn: std::option::Option<std::string::String>,
    /// <p>The policy to apply.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl PutImageRecipePolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the image recipe that this policy should be applied to.</p>
    pub fn image_recipe_arn(&self) -> std::option::Option<&str> {
        self.image_recipe_arn.as_deref()
    }
    /// <p>The policy to apply.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for PutImageRecipePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutImageRecipePolicyInput");
        formatter.field("image_recipe_arn", &self.image_recipe_arn);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutImagePolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the image that this policy should be applied to.</p>
    pub image_arn: std::option::Option<std::string::String>,
    /// <p>The policy to apply.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl PutImagePolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the image that this policy should be applied to.</p>
    pub fn image_arn(&self) -> std::option::Option<&str> {
        self.image_arn.as_deref()
    }
    /// <p>The policy to apply.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for PutImagePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutImagePolicyInput");
        formatter.field("image_arn", &self.image_arn);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutContainerRecipePolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the container recipe that this policy should be applied to.</p>
    pub container_recipe_arn: std::option::Option<std::string::String>,
    /// <p>The policy to apply to the container recipe.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl PutContainerRecipePolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the container recipe that this policy should be applied to.</p>
    pub fn container_recipe_arn(&self) -> std::option::Option<&str> {
        self.container_recipe_arn.as_deref()
    }
    /// <p>The policy to apply to the container recipe.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for PutContainerRecipePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutContainerRecipePolicyInput");
        formatter.field("container_recipe_arn", &self.container_recipe_arn);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutComponentPolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the component that this policy should be applied to.</p>
    pub component_arn: std::option::Option<std::string::String>,
    /// <p>The policy to apply.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl PutComponentPolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the component that this policy should be applied to.</p>
    pub fn component_arn(&self) -> std::option::Option<&str> {
        self.component_arn.as_deref()
    }
    /// <p>The policy to apply.</p>
    pub fn policy(&self) -> std::option::Option<&str> {
        self.policy.as_deref()
    }
}
impl std::fmt::Debug for PutComponentPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutComponentPolicyInput");
        formatter.field("component_arn", &self.component_arn);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource whose tags you want to retrieve.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource whose tags you want to retrieve.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInfrastructureConfigurationsInput {
    /// <p>You can filter on <code>name</code> to streamline results.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The maximum items to return in a request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListInfrastructureConfigurationsInput {
    /// <p>You can filter on <code>name</code> to streamline results.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p>The maximum items to return in a request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListInfrastructureConfigurationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInfrastructureConfigurationsInput");
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListImagesInput {
    /// <p>The owner defines which images you want to list. By default, this request will only show images owned by your account. You can use this field to specify if you want to view images owned by yourself, by Amazon, or those images that have been shared with you by other customers.</p>
    pub owner: std::option::Option<crate::model::Ownership>,
    /// <p>Use the following filters to streamline results:</p>
    /// <ul>
    /// <li> <p> <code>name</code> </p> </li>
    /// <li> <p> <code>osVersion</code> </p> </li>
    /// <li> <p> <code>platform</code> </p> </li>
    /// <li> <p> <code>type</code> </p> </li>
    /// <li> <p> <code>version</code> </p> </li>
    /// </ul>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>Requests a list of images with a specific recipe name.</p>
    pub by_name: bool,
    /// <p>The maximum items to return in a request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Includes deprecated images in the response list.</p>
    pub include_deprecated: std::option::Option<bool>,
}
impl ListImagesInput {
    /// <p>The owner defines which images you want to list. By default, this request will only show images owned by your account. You can use this field to specify if you want to view images owned by yourself, by Amazon, or those images that have been shared with you by other customers.</p>
    pub fn owner(&self) -> std::option::Option<&crate::model::Ownership> {
        self.owner.as_ref()
    }
    /// <p>Use the following filters to streamline results:</p>
    /// <ul>
    /// <li> <p> <code>name</code> </p> </li>
    /// <li> <p> <code>osVersion</code> </p> </li>
    /// <li> <p> <code>platform</code> </p> </li>
    /// <li> <p> <code>type</code> </p> </li>
    /// <li> <p> <code>version</code> </p> </li>
    /// </ul>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p>Requests a list of images with a specific recipe name.</p>
    pub fn by_name(&self) -> bool {
        self.by_name
    }
    /// <p>The maximum items to return in a request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Includes deprecated images in the response list.</p>
    pub fn include_deprecated(&self) -> std::option::Option<bool> {
        self.include_deprecated
    }
}
impl std::fmt::Debug for ListImagesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListImagesInput");
        formatter.field("owner", &self.owner);
        formatter.field("filters", &self.filters);
        formatter.field("by_name", &self.by_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("include_deprecated", &self.include_deprecated);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListImageRecipesInput {
    /// <p>The owner defines which image recipes you want to list. By default, this request will only show image recipes owned by your account. You can use this field to specify if you want to view image recipes owned by yourself, by Amazon, or those image recipes that have been shared with you by other customers.</p>
    pub owner: std::option::Option<crate::model::Ownership>,
    /// <p>Use the following filters to streamline results:</p>
    /// <ul>
    /// <li> <p> <code>name</code> </p> </li>
    /// <li> <p> <code>parentImage</code> </p> </li>
    /// <li> <p> <code>platform</code> </p> </li>
    /// </ul>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The maximum items to return in a request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListImageRecipesInput {
    /// <p>The owner defines which image recipes you want to list. By default, this request will only show image recipes owned by your account. You can use this field to specify if you want to view image recipes owned by yourself, by Amazon, or those image recipes that have been shared with you by other customers.</p>
    pub fn owner(&self) -> std::option::Option<&crate::model::Ownership> {
        self.owner.as_ref()
    }
    /// <p>Use the following filters to streamline results:</p>
    /// <ul>
    /// <li> <p> <code>name</code> </p> </li>
    /// <li> <p> <code>parentImage</code> </p> </li>
    /// <li> <p> <code>platform</code> </p> </li>
    /// </ul>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p>The maximum items to return in a request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListImageRecipesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListImageRecipesInput");
        formatter.field("owner", &self.owner);
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListImagePipelinesInput {
    /// <p>Use the following filters to streamline results:</p>
    /// <ul>
    /// <li> <p> <code>description</code> </p> </li>
    /// <li> <p> <code>distributionConfigurationArn</code> </p> </li>
    /// <li> <p> <code>imageRecipeArn</code> </p> </li>
    /// <li> <p> <code>infrastructureConfigurationArn</code> </p> </li>
    /// <li> <p> <code>name</code> </p> </li>
    /// <li> <p> <code>status</code> </p> </li>
    /// </ul>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The maximum items to return in a request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListImagePipelinesInput {
    /// <p>Use the following filters to streamline results:</p>
    /// <ul>
    /// <li> <p> <code>description</code> </p> </li>
    /// <li> <p> <code>distributionConfigurationArn</code> </p> </li>
    /// <li> <p> <code>imageRecipeArn</code> </p> </li>
    /// <li> <p> <code>infrastructureConfigurationArn</code> </p> </li>
    /// <li> <p> <code>name</code> </p> </li>
    /// <li> <p> <code>status</code> </p> </li>
    /// </ul>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p>The maximum items to return in a request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListImagePipelinesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListImagePipelinesInput");
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListImagePipelineImagesInput {
    /// <p>The Amazon Resource Name (ARN) of the image pipeline whose images you want to view.</p>
    pub image_pipeline_arn: std::option::Option<std::string::String>,
    /// <p>Use the following filters to streamline results:</p>
    /// <ul>
    /// <li> <p> <code>name</code> </p> </li>
    /// <li> <p> <code>version</code> </p> </li>
    /// </ul>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The maximum items to return in a request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListImagePipelineImagesInput {
    /// <p>The Amazon Resource Name (ARN) of the image pipeline whose images you want to view.</p>
    pub fn image_pipeline_arn(&self) -> std::option::Option<&str> {
        self.image_pipeline_arn.as_deref()
    }
    /// <p>Use the following filters to streamline results:</p>
    /// <ul>
    /// <li> <p> <code>name</code> </p> </li>
    /// <li> <p> <code>version</code> </p> </li>
    /// </ul>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p>The maximum items to return in a request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListImagePipelineImagesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListImagePipelineImagesInput");
        formatter.field("image_pipeline_arn", &self.image_pipeline_arn);
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListImagePackagesInput {
    /// <p>Filter results for the ListImagePackages request by the Image Build Version ARN</p>
    pub image_build_version_arn: std::option::Option<std::string::String>,
    /// <p>The maxiumum number of results to return from the ListImagePackages request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListImagePackagesInput {
    /// <p>Filter results for the ListImagePackages request by the Image Build Version ARN</p>
    pub fn image_build_version_arn(&self) -> std::option::Option<&str> {
        self.image_build_version_arn.as_deref()
    }
    /// <p>The maxiumum number of results to return from the ListImagePackages request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListImagePackagesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListImagePackagesInput");
        formatter.field("image_build_version_arn", &self.image_build_version_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListImageBuildVersionsInput {
    /// <p>The Amazon Resource Name (ARN) of the image whose build versions you want to retrieve.</p>
    pub image_version_arn: std::option::Option<std::string::String>,
    /// <p>Use the following filters to streamline results:</p>
    /// <ul>
    /// <li> <p> <code>name</code> </p> </li>
    /// <li> <p> <code>osVersion</code> </p> </li>
    /// <li> <p> <code>platform</code> </p> </li>
    /// <li> <p> <code>type</code> </p> </li>
    /// <li> <p> <code>version</code> </p> </li>
    /// </ul>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The maximum items to return in a request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListImageBuildVersionsInput {
    /// <p>The Amazon Resource Name (ARN) of the image whose build versions you want to retrieve.</p>
    pub fn image_version_arn(&self) -> std::option::Option<&str> {
        self.image_version_arn.as_deref()
    }
    /// <p>Use the following filters to streamline results:</p>
    /// <ul>
    /// <li> <p> <code>name</code> </p> </li>
    /// <li> <p> <code>osVersion</code> </p> </li>
    /// <li> <p> <code>platform</code> </p> </li>
    /// <li> <p> <code>type</code> </p> </li>
    /// <li> <p> <code>version</code> </p> </li>
    /// </ul>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p>The maximum items to return in a request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListImageBuildVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListImageBuildVersionsInput");
        formatter.field("image_version_arn", &self.image_version_arn);
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDistributionConfigurationsInput {
    /// <p>You can filter on <code>name</code> to streamline results.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The maximum items to return in a request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDistributionConfigurationsInput {
    /// <p>You can filter on <code>name</code> to streamline results.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p>The maximum items to return in a request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDistributionConfigurationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDistributionConfigurationsInput");
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListContainerRecipesInput {
    /// <p>Returns container recipes belonging to the specified owner, that have been shared with you. You can omit this field to return container recipes belonging to your account.</p>
    pub owner: std::option::Option<crate::model::Ownership>,
    /// <p>Use the following filters to streamline results:</p>
    /// <ul>
    /// <li> <p> <code>containerType</code> </p> </li>
    /// <li> <p> <code>name</code> </p> </li>
    /// <li> <p> <code>parentImage</code> </p> </li>
    /// <li> <p> <code>platform</code> </p> </li>
    /// </ul>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The maximum number of results to return in the list.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Provides a token for pagination, which determines where to begin the next set of results when the current set reaches the maximum for one request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListContainerRecipesInput {
    /// <p>Returns container recipes belonging to the specified owner, that have been shared with you. You can omit this field to return container recipes belonging to your account.</p>
    pub fn owner(&self) -> std::option::Option<&crate::model::Ownership> {
        self.owner.as_ref()
    }
    /// <p>Use the following filters to streamline results:</p>
    /// <ul>
    /// <li> <p> <code>containerType</code> </p> </li>
    /// <li> <p> <code>name</code> </p> </li>
    /// <li> <p> <code>parentImage</code> </p> </li>
    /// <li> <p> <code>platform</code> </p> </li>
    /// </ul>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p>The maximum number of results to return in the list.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Provides a token for pagination, which determines where to begin the next set of results when the current set reaches the maximum for one request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListContainerRecipesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListContainerRecipesInput");
        formatter.field("owner", &self.owner);
        formatter.field("filters", &self.filters);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListComponentsInput {
    /// <p>The owner defines which components you want to list. By default, this request will only show components owned by your account. You can use this field to specify if you want to view components owned by yourself, by Amazon, or those components that have been shared with you by other customers.</p>
    pub owner: std::option::Option<crate::model::Ownership>,
    /// <p>Use the following filters to streamline results:</p>
    /// <ul>
    /// <li> <p> <code>description</code> </p> </li>
    /// <li> <p> <code>name</code> </p> </li>
    /// <li> <p> <code>platform</code> </p> </li>
    /// <li> <p> <code>supportedOsVersion</code> </p> </li>
    /// <li> <p> <code>type</code> </p> </li>
    /// <li> <p> <code>version</code> </p> </li>
    /// </ul>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>Returns the list of component build versions for the specified name.</p>
    pub by_name: bool,
    /// <p>The maximum items to return in a request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListComponentsInput {
    /// <p>The owner defines which components you want to list. By default, this request will only show components owned by your account. You can use this field to specify if you want to view components owned by yourself, by Amazon, or those components that have been shared with you by other customers.</p>
    pub fn owner(&self) -> std::option::Option<&crate::model::Ownership> {
        self.owner.as_ref()
    }
    /// <p>Use the following filters to streamline results:</p>
    /// <ul>
    /// <li> <p> <code>description</code> </p> </li>
    /// <li> <p> <code>name</code> </p> </li>
    /// <li> <p> <code>platform</code> </p> </li>
    /// <li> <p> <code>supportedOsVersion</code> </p> </li>
    /// <li> <p> <code>type</code> </p> </li>
    /// <li> <p> <code>version</code> </p> </li>
    /// </ul>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p>Returns the list of component build versions for the specified name.</p>
    pub fn by_name(&self) -> bool {
        self.by_name
    }
    /// <p>The maximum items to return in a request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListComponentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListComponentsInput");
        formatter.field("owner", &self.owner);
        formatter.field("filters", &self.filters);
        formatter.field("by_name", &self.by_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListComponentBuildVersionsInput {
    /// <p>The component version Amazon Resource Name (ARN) whose versions you want to list.</p>
    pub component_version_arn: std::option::Option<std::string::String>,
    /// <p>The maximum items to return in a request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListComponentBuildVersionsInput {
    /// <p>The component version Amazon Resource Name (ARN) whose versions you want to list.</p>
    pub fn component_version_arn(&self) -> std::option::Option<&str> {
        self.component_version_arn.as_deref()
    }
    /// <p>The maximum items to return in a request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListComponentBuildVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListComponentBuildVersionsInput");
        formatter.field("component_version_arn", &self.component_version_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportVmImageInput {
    /// <p>The name of the base image that is created by the import process.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The semantic version to attach to the base image that was created during the import process. This version follows the semantic version syntax.</p> <note>
    /// <p>The semantic version has four nodes: <major>
    /// .
    /// <minor>
    /// .
    /// <patch>
    /// /
    /// <build>
    /// . You can assign values for the first three, and can filter on all of them.
    /// </build>
    /// </patch>
    /// </minor>
    /// </major></p>
    /// <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p>
    /// <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p>
    /// </note>
    pub semantic_version: std::option::Option<std::string::String>,
    /// <p>The description for the base image that is created by the import process.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The operating system platform for the imported VM.</p>
    pub platform: std::option::Option<crate::model::Platform>,
    /// <p>The operating system version for the imported VM.</p>
    pub os_version: std::option::Option<std::string::String>,
    /// <p>The <code>importTaskId</code> (API) or <code>ImportTaskId</code> (CLI) from the Amazon EC2 VM import process. Image Builder retrieves information from the import process to pull in the AMI that is created from the VM source as the base image for your recipe.</p>
    pub vm_import_task_id: std::option::Option<std::string::String>,
    /// <p>Tags that are attached to the import resources.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl ImportVmImageInput {
    /// <p>The name of the base image that is created by the import process.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The semantic version to attach to the base image that was created during the import process. This version follows the semantic version syntax.</p> <note>
    /// <p>The semantic version has four nodes: <major>
    /// .
    /// <minor>
    /// .
    /// <patch>
    /// /
    /// <build>
    /// . You can assign values for the first three, and can filter on all of them.
    /// </build>
    /// </patch>
    /// </minor>
    /// </major></p>
    /// <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p>
    /// <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p>
    /// </note>
    pub fn semantic_version(&self) -> std::option::Option<&str> {
        self.semantic_version.as_deref()
    }
    /// <p>The description for the base image that is created by the import process.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The operating system platform for the imported VM.</p>
    pub fn platform(&self) -> std::option::Option<&crate::model::Platform> {
        self.platform.as_ref()
    }
    /// <p>The operating system version for the imported VM.</p>
    pub fn os_version(&self) -> std::option::Option<&str> {
        self.os_version.as_deref()
    }
    /// <p>The <code>importTaskId</code> (API) or <code>ImportTaskId</code> (CLI) from the Amazon EC2 VM import process. Image Builder retrieves information from the import process to pull in the AMI that is created from the VM source as the base image for your recipe.</p>
    pub fn vm_import_task_id(&self) -> std::option::Option<&str> {
        self.vm_import_task_id.as_deref()
    }
    /// <p>Tags that are attached to the import resources.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for ImportVmImageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportVmImageInput");
        formatter.field("name", &self.name);
        formatter.field("semantic_version", &self.semantic_version);
        formatter.field("description", &self.description);
        formatter.field("platform", &self.platform);
        formatter.field("os_version", &self.os_version);
        formatter.field("vm_import_task_id", &self.vm_import_task_id);
        formatter.field("tags", &self.tags);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportComponentInput {
    /// <p> The name of the component.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The semantic version of the component. This version follows the semantic version syntax.</p> <note>
    /// <p>The semantic version has four nodes: <major>
    /// .
    /// <minor>
    /// .
    /// <patch>
    /// /
    /// <build>
    /// . You can assign values for the first three, and can filter on all of them.
    /// </build>
    /// </patch>
    /// </minor>
    /// </major></p>
    /// <p> <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.</p>
    /// </note>
    pub semantic_version: std::option::Option<std::string::String>,
    /// <p>The description of the component. Describes the contents of the component.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The change description of the component. Describes what change has been made in this version, or what makes this version different from other versions of this component.</p>
    pub change_description: std::option::Option<std::string::String>,
    /// <p>The type of the component denotes whether the component is used to build the image, or only to test it.</p>
    pub r#type: std::option::Option<crate::model::ComponentType>,
    /// <p>The format of the resource that you want to import as a component.</p>
    pub format: std::option::Option<crate::model::ComponentFormat>,
    /// <p>The platform of the component.</p>
    pub platform: std::option::Option<crate::model::Platform>,
    /// <p>The data of the component. Used to specify the data inline. Either <code>data</code> or <code>uri</code> can be used to specify the data within the component.</p>
    pub data: std::option::Option<std::string::String>,
    /// <p>The uri of the component. Must be an Amazon S3 URL and the requester must have permission to access the Amazon S3 bucket. If you use Amazon S3, you can specify component content up to your service quota. Either <code>data</code> or <code>uri</code> can be used to specify the data within the component.</p>
    pub uri: std::option::Option<std::string::String>,
    /// <p>The ID of the KMS key that should be used to encrypt this component.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The tags of the component.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The idempotency token of the component.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl ImportComponentInput {
    /// <p> The name of the component.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The semantic version of the component. This version follows the semantic version syntax.</p> <note>
    /// <p>The semantic version has four nodes: <major>
    /// .
    /// <minor>
    /// .
    /// <patch>
    /// /
    /// <build>
    /// . You can assign values for the first three, and can filter on all of them.
    /// </build>
    /// </patch>
    /// </minor>
    /// </major></p>
    /// <p> <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.</p>
    /// </note>
    pub fn semantic_version(&self) -> std::option::Option<&str> {
        self.semantic_version.as_deref()
    }
    /// <p>The description of the component. Describes the contents of the component.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The change description of the component. Describes what change has been made in this version, or what makes this version different from other versions of this component.</p>
    pub fn change_description(&self) -> std::option::Option<&str> {
        self.change_description.as_deref()
    }
    /// <p>The type of the component denotes whether the component is used to build the image, or only to test it.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ComponentType> {
        self.r#type.as_ref()
    }
    /// <p>The format of the resource that you want to import as a component.</p>
    pub fn format(&self) -> std::option::Option<&crate::model::ComponentFormat> {
        self.format.as_ref()
    }
    /// <p>The platform of the component.</p>
    pub fn platform(&self) -> std::option::Option<&crate::model::Platform> {
        self.platform.as_ref()
    }
    /// <p>The data of the component. Used to specify the data inline. Either <code>data</code> or <code>uri</code> can be used to specify the data within the component.</p>
    pub fn data(&self) -> std::option::Option<&str> {
        self.data.as_deref()
    }
    /// <p>The uri of the component. Must be an Amazon S3 URL and the requester must have permission to access the Amazon S3 bucket. If you use Amazon S3, you can specify component content up to your service quota. Either <code>data</code> or <code>uri</code> can be used to specify the data within the component.</p>
    pub fn uri(&self) -> std::option::Option<&str> {
        self.uri.as_deref()
    }
    /// <p>The ID of the KMS key that should be used to encrypt this component.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The tags of the component.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The idempotency token of the component.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for ImportComponentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportComponentInput");
        formatter.field("name", &self.name);
        formatter.field("semantic_version", &self.semantic_version);
        formatter.field("description", &self.description);
        formatter.field("change_description", &self.change_description);
        formatter.field("r#type", &self.r#type);
        formatter.field("format", &self.format);
        formatter.field("platform", &self.platform);
        formatter.field("data", &self.data);
        formatter.field("uri", &self.uri);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("tags", &self.tags);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

/// <p> GetInfrastructureConfiguration request object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInfrastructureConfigurationInput {
    /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that you want to retrieve.</p>
    pub infrastructure_configuration_arn: std::option::Option<std::string::String>,
}
impl GetInfrastructureConfigurationInput {
    /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that you want to retrieve.</p>
    pub fn infrastructure_configuration_arn(&self) -> std::option::Option<&str> {
        self.infrastructure_configuration_arn.as_deref()
    }
}
impl std::fmt::Debug for GetInfrastructureConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInfrastructureConfigurationInput");
        formatter.field(
            "infrastructure_configuration_arn",
            &self.infrastructure_configuration_arn,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetImageRecipePolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the image recipe whose policy you want to retrieve.</p>
    pub image_recipe_arn: std::option::Option<std::string::String>,
}
impl GetImageRecipePolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the image recipe whose policy you want to retrieve.</p>
    pub fn image_recipe_arn(&self) -> std::option::Option<&str> {
        self.image_recipe_arn.as_deref()
    }
}
impl std::fmt::Debug for GetImageRecipePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetImageRecipePolicyInput");
        formatter.field("image_recipe_arn", &self.image_recipe_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetImageRecipeInput {
    /// <p>The Amazon Resource Name (ARN) of the image recipe that you want to retrieve.</p>
    pub image_recipe_arn: std::option::Option<std::string::String>,
}
impl GetImageRecipeInput {
    /// <p>The Amazon Resource Name (ARN) of the image recipe that you want to retrieve.</p>
    pub fn image_recipe_arn(&self) -> std::option::Option<&str> {
        self.image_recipe_arn.as_deref()
    }
}
impl std::fmt::Debug for GetImageRecipeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetImageRecipeInput");
        formatter.field("image_recipe_arn", &self.image_recipe_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetImagePolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the image whose policy you want to retrieve.</p>
    pub image_arn: std::option::Option<std::string::String>,
}
impl GetImagePolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the image whose policy you want to retrieve.</p>
    pub fn image_arn(&self) -> std::option::Option<&str> {
        self.image_arn.as_deref()
    }
}
impl std::fmt::Debug for GetImagePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetImagePolicyInput");
        formatter.field("image_arn", &self.image_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetImagePipelineInput {
    /// <p>The Amazon Resource Name (ARN) of the image pipeline that you want to retrieve.</p>
    pub image_pipeline_arn: std::option::Option<std::string::String>,
}
impl GetImagePipelineInput {
    /// <p>The Amazon Resource Name (ARN) of the image pipeline that you want to retrieve.</p>
    pub fn image_pipeline_arn(&self) -> std::option::Option<&str> {
        self.image_pipeline_arn.as_deref()
    }
}
impl std::fmt::Debug for GetImagePipelineInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetImagePipelineInput");
        formatter.field("image_pipeline_arn", &self.image_pipeline_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetImageInput {
    /// <p>The Amazon Resource Name (ARN) of the image that you want to retrieve.</p>
    pub image_build_version_arn: std::option::Option<std::string::String>,
}
impl GetImageInput {
    /// <p>The Amazon Resource Name (ARN) of the image that you want to retrieve.</p>
    pub fn image_build_version_arn(&self) -> std::option::Option<&str> {
        self.image_build_version_arn.as_deref()
    }
}
impl std::fmt::Debug for GetImageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetImageInput");
        formatter.field("image_build_version_arn", &self.image_build_version_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDistributionConfigurationInput {
    /// <p>The Amazon Resource Name (ARN) of the distribution configuration that you want to retrieve.</p>
    pub distribution_configuration_arn: std::option::Option<std::string::String>,
}
impl GetDistributionConfigurationInput {
    /// <p>The Amazon Resource Name (ARN) of the distribution configuration that you want to retrieve.</p>
    pub fn distribution_configuration_arn(&self) -> std::option::Option<&str> {
        self.distribution_configuration_arn.as_deref()
    }
}
impl std::fmt::Debug for GetDistributionConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDistributionConfigurationInput");
        formatter.field(
            "distribution_configuration_arn",
            &self.distribution_configuration_arn,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetContainerRecipePolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the container recipe for the policy being requested.</p>
    pub container_recipe_arn: std::option::Option<std::string::String>,
}
impl GetContainerRecipePolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the container recipe for the policy being requested.</p>
    pub fn container_recipe_arn(&self) -> std::option::Option<&str> {
        self.container_recipe_arn.as_deref()
    }
}
impl std::fmt::Debug for GetContainerRecipePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetContainerRecipePolicyInput");
        formatter.field("container_recipe_arn", &self.container_recipe_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetContainerRecipeInput {
    /// <p>The Amazon Resource Name (ARN) of the container recipe to retrieve.</p>
    pub container_recipe_arn: std::option::Option<std::string::String>,
}
impl GetContainerRecipeInput {
    /// <p>The Amazon Resource Name (ARN) of the container recipe to retrieve.</p>
    pub fn container_recipe_arn(&self) -> std::option::Option<&str> {
        self.container_recipe_arn.as_deref()
    }
}
impl std::fmt::Debug for GetContainerRecipeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetContainerRecipeInput");
        formatter.field("container_recipe_arn", &self.container_recipe_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetComponentPolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the component whose policy you want to retrieve.</p>
    pub component_arn: std::option::Option<std::string::String>,
}
impl GetComponentPolicyInput {
    /// <p>The Amazon Resource Name (ARN) of the component whose policy you want to retrieve.</p>
    pub fn component_arn(&self) -> std::option::Option<&str> {
        self.component_arn.as_deref()
    }
}
impl std::fmt::Debug for GetComponentPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetComponentPolicyInput");
        formatter.field("component_arn", &self.component_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetComponentInput {
    /// <p>The Amazon Resource Name (ARN) of the component that you want to retrieve. Regex requires "/\d+$" suffix.</p>
    pub component_build_version_arn: std::option::Option<std::string::String>,
}
impl GetComponentInput {
    /// <p>The Amazon Resource Name (ARN) of the component that you want to retrieve. Regex requires "/\d+$" suffix.</p>
    pub fn component_build_version_arn(&self) -> std::option::Option<&str> {
        self.component_build_version_arn.as_deref()
    }
}
impl std::fmt::Debug for GetComponentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetComponentInput");
        formatter.field(
            "component_build_version_arn",
            &self.component_build_version_arn,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteInfrastructureConfigurationInput {
    /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration to delete.</p>
    pub infrastructure_configuration_arn: std::option::Option<std::string::String>,
}
impl DeleteInfrastructureConfigurationInput {
    /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration to delete.</p>
    pub fn infrastructure_configuration_arn(&self) -> std::option::Option<&str> {
        self.infrastructure_configuration_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteInfrastructureConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteInfrastructureConfigurationInput");
        formatter.field(
            "infrastructure_configuration_arn",
            &self.infrastructure_configuration_arn,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteImageRecipeInput {
    /// <p>The Amazon Resource Name (ARN) of the image recipe to delete.</p>
    pub image_recipe_arn: std::option::Option<std::string::String>,
}
impl DeleteImageRecipeInput {
    /// <p>The Amazon Resource Name (ARN) of the image recipe to delete.</p>
    pub fn image_recipe_arn(&self) -> std::option::Option<&str> {
        self.image_recipe_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteImageRecipeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteImageRecipeInput");
        formatter.field("image_recipe_arn", &self.image_recipe_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteImagePipelineInput {
    /// <p>The Amazon Resource Name (ARN) of the image pipeline to delete.</p>
    pub image_pipeline_arn: std::option::Option<std::string::String>,
}
impl DeleteImagePipelineInput {
    /// <p>The Amazon Resource Name (ARN) of the image pipeline to delete.</p>
    pub fn image_pipeline_arn(&self) -> std::option::Option<&str> {
        self.image_pipeline_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteImagePipelineInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteImagePipelineInput");
        formatter.field("image_pipeline_arn", &self.image_pipeline_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteImageInput {
    /// <p>The Amazon Resource Name (ARN) of the Image Builder image resource to delete.</p>
    pub image_build_version_arn: std::option::Option<std::string::String>,
}
impl DeleteImageInput {
    /// <p>The Amazon Resource Name (ARN) of the Image Builder image resource to delete.</p>
    pub fn image_build_version_arn(&self) -> std::option::Option<&str> {
        self.image_build_version_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteImageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteImageInput");
        formatter.field("image_build_version_arn", &self.image_build_version_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDistributionConfigurationInput {
    /// <p>The Amazon Resource Name (ARN) of the distribution configuration to delete.</p>
    pub distribution_configuration_arn: std::option::Option<std::string::String>,
}
impl DeleteDistributionConfigurationInput {
    /// <p>The Amazon Resource Name (ARN) of the distribution configuration to delete.</p>
    pub fn distribution_configuration_arn(&self) -> std::option::Option<&str> {
        self.distribution_configuration_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteDistributionConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDistributionConfigurationInput");
        formatter.field(
            "distribution_configuration_arn",
            &self.distribution_configuration_arn,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteContainerRecipeInput {
    /// <p>The Amazon Resource Name (ARN) of the container recipe to delete.</p>
    pub container_recipe_arn: std::option::Option<std::string::String>,
}
impl DeleteContainerRecipeInput {
    /// <p>The Amazon Resource Name (ARN) of the container recipe to delete.</p>
    pub fn container_recipe_arn(&self) -> std::option::Option<&str> {
        self.container_recipe_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteContainerRecipeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteContainerRecipeInput");
        formatter.field("container_recipe_arn", &self.container_recipe_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteComponentInput {
    /// <p>The Amazon Resource Name (ARN) of the component build version to delete.</p>
    pub component_build_version_arn: std::option::Option<std::string::String>,
}
impl DeleteComponentInput {
    /// <p>The Amazon Resource Name (ARN) of the component build version to delete.</p>
    pub fn component_build_version_arn(&self) -> std::option::Option<&str> {
        self.component_build_version_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteComponentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteComponentInput");
        formatter.field(
            "component_build_version_arn",
            &self.component_build_version_arn,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateInfrastructureConfigurationInput {
    /// <p>The name of the infrastructure configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the infrastructure configuration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The instance types of the infrastructure configuration. You can specify one or more instance types to use for this build. The service will pick one of these instance types based on availability.</p>
    pub instance_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The instance profile to associate with the instance used to customize your Amazon EC2 AMI.</p>
    pub instance_profile_name: std::option::Option<std::string::String>,
    /// <p>The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The subnet ID in which to place the instance used to customize your Amazon EC2 AMI.</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>The logging configuration of the infrastructure configuration.</p>
    pub logging: std::option::Option<crate::model::Logging>,
    /// <p>The key pair of the infrastructure configuration. You can use this to log on to and debug the instance used to create your image.</p>
    pub key_pair: std::option::Option<std::string::String>,
    /// <p>The terminate instance on failure setting of the infrastructure configuration. Set to false if you want Image Builder to retain the instance used to configure your AMI if the build or test phase of your workflow fails.</p>
    pub terminate_instance_on_failure: std::option::Option<bool>,
    /// <p>The Amazon Resource Name (ARN) for the SNS topic to which we send image build event notifications.</p> <note>
    /// <p>EC2 Image Builder is unable to send notifications to SNS topics that are encrypted using keys from other accounts. The key that is used to encrypt the SNS topic must reside in the account that the Image Builder service runs under.</p>
    /// </note>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>The tags attached to the resource created by Image Builder.</p>
    pub resource_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The instance metadata options that you can set for the HTTP requests that pipeline builds use to launch EC2 build and test instances.</p>
    pub instance_metadata_options: std::option::Option<crate::model::InstanceMetadataOptions>,
    /// <p>The tags of the infrastructure configuration.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The idempotency token used to make this request idempotent.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateInfrastructureConfigurationInput {
    /// <p>The name of the infrastructure configuration.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the infrastructure configuration.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The instance types of the infrastructure configuration. You can specify one or more instance types to use for this build. The service will pick one of these instance types based on availability.</p>
    pub fn instance_types(&self) -> std::option::Option<&[std::string::String]> {
        self.instance_types.as_deref()
    }
    /// <p>The instance profile to associate with the instance used to customize your Amazon EC2 AMI.</p>
    pub fn instance_profile_name(&self) -> std::option::Option<&str> {
        self.instance_profile_name.as_deref()
    }
    /// <p>The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
    /// <p>The subnet ID in which to place the instance used to customize your Amazon EC2 AMI.</p>
    pub fn subnet_id(&self) -> std::option::Option<&str> {
        self.subnet_id.as_deref()
    }
    /// <p>The logging configuration of the infrastructure configuration.</p>
    pub fn logging(&self) -> std::option::Option<&crate::model::Logging> {
        self.logging.as_ref()
    }
    /// <p>The key pair of the infrastructure configuration. You can use this to log on to and debug the instance used to create your image.</p>
    pub fn key_pair(&self) -> std::option::Option<&str> {
        self.key_pair.as_deref()
    }
    /// <p>The terminate instance on failure setting of the infrastructure configuration. Set to false if you want Image Builder to retain the instance used to configure your AMI if the build or test phase of your workflow fails.</p>
    pub fn terminate_instance_on_failure(&self) -> std::option::Option<bool> {
        self.terminate_instance_on_failure
    }
    /// <p>The Amazon Resource Name (ARN) for the SNS topic to which we send image build event notifications.</p> <note>
    /// <p>EC2 Image Builder is unable to send notifications to SNS topics that are encrypted using keys from other accounts. The key that is used to encrypt the SNS topic must reside in the account that the Image Builder service runs under.</p>
    /// </note>
    pub fn sns_topic_arn(&self) -> std::option::Option<&str> {
        self.sns_topic_arn.as_deref()
    }
    /// <p>The tags attached to the resource created by Image Builder.</p>
    pub fn resource_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.resource_tags.as_ref()
    }
    /// <p>The instance metadata options that you can set for the HTTP requests that pipeline builds use to launch EC2 build and test instances.</p>
    pub fn instance_metadata_options(
        &self,
    ) -> std::option::Option<&crate::model::InstanceMetadataOptions> {
        self.instance_metadata_options.as_ref()
    }
    /// <p>The tags of the infrastructure configuration.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The idempotency token used to make this request idempotent.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateInfrastructureConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateInfrastructureConfigurationInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("instance_types", &self.instance_types);
        formatter.field("instance_profile_name", &self.instance_profile_name);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("logging", &self.logging);
        formatter.field("key_pair", &self.key_pair);
        formatter.field(
            "terminate_instance_on_failure",
            &self.terminate_instance_on_failure,
        );
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field("resource_tags", &self.resource_tags);
        formatter.field("instance_metadata_options", &self.instance_metadata_options);
        formatter.field("tags", &self.tags);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateImageRecipeInput {
    /// <p> The name of the image recipe.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The description of the image recipe.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The semantic version of the image recipe. This version follows the semantic version syntax.</p> <note>
    /// <p>The semantic version has four nodes: <major>
    /// .
    /// <minor>
    /// .
    /// <patch>
    /// /
    /// <build>
    /// . You can assign values for the first three, and can filter on all of them.
    /// </build>
    /// </patch>
    /// </minor>
    /// </major></p>
    /// <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p>
    /// <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p>
    /// </note>
    pub semantic_version: std::option::Option<std::string::String>,
    /// <p>The components of the image recipe.</p>
    pub components: std::option::Option<std::vec::Vec<crate::model::ComponentConfiguration>>,
    /// <p>The base image of the image recipe. The value of the string can be the ARN of the base image or an AMI ID. The format for the ARN follows this example: <code>arn:aws:imagebuilder:us-west-2:aws:image/windows-server-2016-english-full-base-x86/x.x.x</code>. You can provide the specific version that you want to use, or you can use a wildcard in all of the fields. If you enter an AMI ID for the string value, you must have access to the AMI, and the AMI must be in the same Region in which you are using Image Builder.</p>
    pub parent_image: std::option::Option<std::string::String>,
    /// <p>The block device mappings of the image recipe.</p>
    pub block_device_mappings:
        std::option::Option<std::vec::Vec<crate::model::InstanceBlockDeviceMapping>>,
    /// <p> The tags of the image recipe.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The working directory used during build and test workflows.</p>
    pub working_directory: std::option::Option<std::string::String>,
    /// <p>Specify additional settings and launch scripts for your build instances.</p>
    pub additional_instance_configuration:
        std::option::Option<crate::model::AdditionalInstanceConfiguration>,
    /// <p>The idempotency token used to make this request idempotent.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateImageRecipeInput {
    /// <p> The name of the image recipe.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> The description of the image recipe.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The semantic version of the image recipe. This version follows the semantic version syntax.</p> <note>
    /// <p>The semantic version has four nodes: <major>
    /// .
    /// <minor>
    /// .
    /// <patch>
    /// /
    /// <build>
    /// . You can assign values for the first three, and can filter on all of them.
    /// </build>
    /// </patch>
    /// </minor>
    /// </major></p>
    /// <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p>
    /// <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p>
    /// </note>
    pub fn semantic_version(&self) -> std::option::Option<&str> {
        self.semantic_version.as_deref()
    }
    /// <p>The components of the image recipe.</p>
    pub fn components(&self) -> std::option::Option<&[crate::model::ComponentConfiguration]> {
        self.components.as_deref()
    }
    /// <p>The base image of the image recipe. The value of the string can be the ARN of the base image or an AMI ID. The format for the ARN follows this example: <code>arn:aws:imagebuilder:us-west-2:aws:image/windows-server-2016-english-full-base-x86/x.x.x</code>. You can provide the specific version that you want to use, or you can use a wildcard in all of the fields. If you enter an AMI ID for the string value, you must have access to the AMI, and the AMI must be in the same Region in which you are using Image Builder.</p>
    pub fn parent_image(&self) -> std::option::Option<&str> {
        self.parent_image.as_deref()
    }
    /// <p>The block device mappings of the image recipe.</p>
    pub fn block_device_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::InstanceBlockDeviceMapping]> {
        self.block_device_mappings.as_deref()
    }
    /// <p> The tags of the image recipe.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The working directory used during build and test workflows.</p>
    pub fn working_directory(&self) -> std::option::Option<&str> {
        self.working_directory.as_deref()
    }
    /// <p>Specify additional settings and launch scripts for your build instances.</p>
    pub fn additional_instance_configuration(
        &self,
    ) -> std::option::Option<&crate::model::AdditionalInstanceConfiguration> {
        self.additional_instance_configuration.as_ref()
    }
    /// <p>The idempotency token used to make this request idempotent.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateImageRecipeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateImageRecipeInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("semantic_version", &self.semantic_version);
        formatter.field("components", &self.components);
        formatter.field("parent_image", &self.parent_image);
        formatter.field("block_device_mappings", &self.block_device_mappings);
        formatter.field("tags", &self.tags);
        formatter.field("working_directory", &self.working_directory);
        formatter.field(
            "additional_instance_configuration",
            &self.additional_instance_configuration,
        );
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateImagePipelineInput {
    /// <p> The name of the image pipeline.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The description of the image pipeline.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) of the image recipe that will be used to configure images created by this image pipeline.</p>
    pub image_recipe_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the container recipe that is used to configure images created by this container pipeline.</p>
    pub container_recipe_arn: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to build images created by this image pipeline.</p>
    pub infrastructure_configuration_arn: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) of the distribution configuration that will be used to configure and distribute images created by this image pipeline.</p>
    pub distribution_configuration_arn: std::option::Option<std::string::String>,
    /// <p> The image test configuration of the image pipeline.</p>
    pub image_tests_configuration: std::option::Option<crate::model::ImageTestsConfiguration>,
    /// <p> Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.</p>
    pub enhanced_image_metadata_enabled: std::option::Option<bool>,
    /// <p> The schedule of the image pipeline.</p>
    pub schedule: std::option::Option<crate::model::Schedule>,
    /// <p> The status of the image pipeline.</p>
    pub status: std::option::Option<crate::model::PipelineStatus>,
    /// <p> The tags of the image pipeline.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p> The idempotency token used to make this request idempotent.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateImagePipelineInput {
    /// <p> The name of the image pipeline.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> The description of the image pipeline.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) of the image recipe that will be used to configure images created by this image pipeline.</p>
    pub fn image_recipe_arn(&self) -> std::option::Option<&str> {
        self.image_recipe_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the container recipe that is used to configure images created by this container pipeline.</p>
    pub fn container_recipe_arn(&self) -> std::option::Option<&str> {
        self.container_recipe_arn.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to build images created by this image pipeline.</p>
    pub fn infrastructure_configuration_arn(&self) -> std::option::Option<&str> {
        self.infrastructure_configuration_arn.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) of the distribution configuration that will be used to configure and distribute images created by this image pipeline.</p>
    pub fn distribution_configuration_arn(&self) -> std::option::Option<&str> {
        self.distribution_configuration_arn.as_deref()
    }
    /// <p> The image test configuration of the image pipeline.</p>
    pub fn image_tests_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ImageTestsConfiguration> {
        self.image_tests_configuration.as_ref()
    }
    /// <p> Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.</p>
    pub fn enhanced_image_metadata_enabled(&self) -> std::option::Option<bool> {
        self.enhanced_image_metadata_enabled
    }
    /// <p> The schedule of the image pipeline.</p>
    pub fn schedule(&self) -> std::option::Option<&crate::model::Schedule> {
        self.schedule.as_ref()
    }
    /// <p> The status of the image pipeline.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::PipelineStatus> {
        self.status.as_ref()
    }
    /// <p> The tags of the image pipeline.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p> The idempotency token used to make this request idempotent.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateImagePipelineInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateImagePipelineInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("image_recipe_arn", &self.image_recipe_arn);
        formatter.field("container_recipe_arn", &self.container_recipe_arn);
        formatter.field(
            "infrastructure_configuration_arn",
            &self.infrastructure_configuration_arn,
        );
        formatter.field(
            "distribution_configuration_arn",
            &self.distribution_configuration_arn,
        );
        formatter.field("image_tests_configuration", &self.image_tests_configuration);
        formatter.field(
            "enhanced_image_metadata_enabled",
            &self.enhanced_image_metadata_enabled,
        );
        formatter.field("schedule", &self.schedule);
        formatter.field("status", &self.status);
        formatter.field("tags", &self.tags);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateImageInput {
    /// <p> The Amazon Resource Name (ARN) of the image recipe that defines how images are configured, tested, and assessed.</p>
    pub image_recipe_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the container recipe that defines how images are configured and tested.</p>
    pub container_recipe_arn: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) of the distribution configuration that defines and configures the outputs of your pipeline.</p>
    pub distribution_configuration_arn: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) of the infrastructure configuration that defines the environment in which your image will be built and tested.</p>
    pub infrastructure_configuration_arn: std::option::Option<std::string::String>,
    /// <p> The image tests configuration of the image.</p>
    pub image_tests_configuration: std::option::Option<crate::model::ImageTestsConfiguration>,
    /// <p> Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.</p>
    pub enhanced_image_metadata_enabled: std::option::Option<bool>,
    /// <p> The tags of the image.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p> The idempotency token used to make this request idempotent.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateImageInput {
    /// <p> The Amazon Resource Name (ARN) of the image recipe that defines how images are configured, tested, and assessed.</p>
    pub fn image_recipe_arn(&self) -> std::option::Option<&str> {
        self.image_recipe_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the container recipe that defines how images are configured and tested.</p>
    pub fn container_recipe_arn(&self) -> std::option::Option<&str> {
        self.container_recipe_arn.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) of the distribution configuration that defines and configures the outputs of your pipeline.</p>
    pub fn distribution_configuration_arn(&self) -> std::option::Option<&str> {
        self.distribution_configuration_arn.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) of the infrastructure configuration that defines the environment in which your image will be built and tested.</p>
    pub fn infrastructure_configuration_arn(&self) -> std::option::Option<&str> {
        self.infrastructure_configuration_arn.as_deref()
    }
    /// <p> The image tests configuration of the image.</p>
    pub fn image_tests_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ImageTestsConfiguration> {
        self.image_tests_configuration.as_ref()
    }
    /// <p> Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.</p>
    pub fn enhanced_image_metadata_enabled(&self) -> std::option::Option<bool> {
        self.enhanced_image_metadata_enabled
    }
    /// <p> The tags of the image.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p> The idempotency token used to make this request idempotent.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateImageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateImageInput");
        formatter.field("image_recipe_arn", &self.image_recipe_arn);
        formatter.field("container_recipe_arn", &self.container_recipe_arn);
        formatter.field(
            "distribution_configuration_arn",
            &self.distribution_configuration_arn,
        );
        formatter.field(
            "infrastructure_configuration_arn",
            &self.infrastructure_configuration_arn,
        );
        formatter.field("image_tests_configuration", &self.image_tests_configuration);
        formatter.field(
            "enhanced_image_metadata_enabled",
            &self.enhanced_image_metadata_enabled,
        );
        formatter.field("tags", &self.tags);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDistributionConfigurationInput {
    /// <p> The name of the distribution configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The description of the distribution configuration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The distributions of the distribution configuration.</p>
    pub distributions: std::option::Option<std::vec::Vec<crate::model::Distribution>>,
    /// <p> The tags of the distribution configuration.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p> The idempotency token of the distribution configuration.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateDistributionConfigurationInput {
    /// <p> The name of the distribution configuration.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> The description of the distribution configuration.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> The distributions of the distribution configuration.</p>
    pub fn distributions(&self) -> std::option::Option<&[crate::model::Distribution]> {
        self.distributions.as_deref()
    }
    /// <p> The tags of the distribution configuration.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p> The idempotency token of the distribution configuration.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateDistributionConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDistributionConfigurationInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("distributions", &self.distributions);
        formatter.field("tags", &self.tags);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateContainerRecipeInput {
    /// <p>The type of container to create.</p>
    pub container_type: std::option::Option<crate::model::ContainerType>,
    /// <p>The name of the container recipe.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the container recipe.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The semantic version of the container recipe. This version follows the semantic version syntax.</p> <note>
    /// <p>The semantic version has four nodes: <major>
    /// .
    /// <minor>
    /// .
    /// <patch>
    /// /
    /// <build>
    /// . You can assign values for the first three, and can filter on all of them.
    /// </build>
    /// </patch>
    /// </minor>
    /// </major></p>
    /// <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p>
    /// <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p>
    /// </note>
    pub semantic_version: std::option::Option<std::string::String>,
    /// <p>Components for build and test that are included in the container recipe.</p>
    pub components: std::option::Option<std::vec::Vec<crate::model::ComponentConfiguration>>,
    /// <p>A group of options that can be used to configure an instance for building and testing container images.</p>
    pub instance_configuration: std::option::Option<crate::model::InstanceConfiguration>,
    /// <p>The Dockerfile template used to build your image as an inline data blob.</p>
    pub dockerfile_template_data: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 URI for the Dockerfile that will be used to build your container image.</p>
    pub dockerfile_template_uri: std::option::Option<std::string::String>,
    /// <p>Specifies the operating system platform when you use a custom base image.</p>
    pub platform_override: std::option::Option<crate::model::Platform>,
    /// <p>Specifies the operating system version for the base image.</p>
    pub image_os_version_override: std::option::Option<std::string::String>,
    /// <p>The base image for the container recipe.</p>
    pub parent_image: std::option::Option<std::string::String>,
    /// <p>Tags that are attached to the container recipe.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The working directory for use during build and test workflows.</p>
    pub working_directory: std::option::Option<std::string::String>,
    /// <p>The destination repository for the container image.</p>
    pub target_repository: std::option::Option<crate::model::TargetContainerRepository>,
    /// <p>Identifies which KMS key is used to encrypt the container image.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The client token used to make this request idempotent.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateContainerRecipeInput {
    /// <p>The type of container to create.</p>
    pub fn container_type(&self) -> std::option::Option<&crate::model::ContainerType> {
        self.container_type.as_ref()
    }
    /// <p>The name of the container recipe.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the container recipe.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The semantic version of the container recipe. This version follows the semantic version syntax.</p> <note>
    /// <p>The semantic version has four nodes: <major>
    /// .
    /// <minor>
    /// .
    /// <patch>
    /// /
    /// <build>
    /// . You can assign values for the first three, and can filter on all of them.
    /// </build>
    /// </patch>
    /// </minor>
    /// </major></p>
    /// <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p>
    /// <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p>
    /// </note>
    pub fn semantic_version(&self) -> std::option::Option<&str> {
        self.semantic_version.as_deref()
    }
    /// <p>Components for build and test that are included in the container recipe.</p>
    pub fn components(&self) -> std::option::Option<&[crate::model::ComponentConfiguration]> {
        self.components.as_deref()
    }
    /// <p>A group of options that can be used to configure an instance for building and testing container images.</p>
    pub fn instance_configuration(
        &self,
    ) -> std::option::Option<&crate::model::InstanceConfiguration> {
        self.instance_configuration.as_ref()
    }
    /// <p>The Dockerfile template used to build your image as an inline data blob.</p>
    pub fn dockerfile_template_data(&self) -> std::option::Option<&str> {
        self.dockerfile_template_data.as_deref()
    }
    /// <p>The Amazon S3 URI for the Dockerfile that will be used to build your container image.</p>
    pub fn dockerfile_template_uri(&self) -> std::option::Option<&str> {
        self.dockerfile_template_uri.as_deref()
    }
    /// <p>Specifies the operating system platform when you use a custom base image.</p>
    pub fn platform_override(&self) -> std::option::Option<&crate::model::Platform> {
        self.platform_override.as_ref()
    }
    /// <p>Specifies the operating system version for the base image.</p>
    pub fn image_os_version_override(&self) -> std::option::Option<&str> {
        self.image_os_version_override.as_deref()
    }
    /// <p>The base image for the container recipe.</p>
    pub fn parent_image(&self) -> std::option::Option<&str> {
        self.parent_image.as_deref()
    }
    /// <p>Tags that are attached to the container recipe.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The working directory for use during build and test workflows.</p>
    pub fn working_directory(&self) -> std::option::Option<&str> {
        self.working_directory.as_deref()
    }
    /// <p>The destination repository for the container image.</p>
    pub fn target_repository(
        &self,
    ) -> std::option::Option<&crate::model::TargetContainerRepository> {
        self.target_repository.as_ref()
    }
    /// <p>Identifies which KMS key is used to encrypt the container image.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The client token used to make this request idempotent.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateContainerRecipeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateContainerRecipeInput");
        formatter.field("container_type", &self.container_type);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("semantic_version", &self.semantic_version);
        formatter.field("components", &self.components);
        formatter.field("instance_configuration", &self.instance_configuration);
        formatter.field("dockerfile_template_data", &self.dockerfile_template_data);
        formatter.field("dockerfile_template_uri", &self.dockerfile_template_uri);
        formatter.field("platform_override", &self.platform_override);
        formatter.field("image_os_version_override", &self.image_os_version_override);
        formatter.field("parent_image", &self.parent_image);
        formatter.field("tags", &self.tags);
        formatter.field("working_directory", &self.working_directory);
        formatter.field("target_repository", &self.target_repository);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateComponentInput {
    /// <p>The name of the component.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The semantic version of the component. This version follows the semantic version syntax.</p> <note>
    /// <p>The semantic version has four nodes: <major>
    /// .
    /// <minor>
    /// .
    /// <patch>
    /// /
    /// <build>
    /// . You can assign values for the first three, and can filter on all of them.
    /// </build>
    /// </patch>
    /// </minor>
    /// </major></p>
    /// <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p>
    /// <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p>
    /// </note>
    pub semantic_version: std::option::Option<std::string::String>,
    /// <p>The description of the component. Describes the contents of the component.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The change description of the component. Describes what change has been made in this version, or what makes this version different from other versions of this component.</p>
    pub change_description: std::option::Option<std::string::String>,
    /// <p>The platform of the component.</p>
    pub platform: std::option::Option<crate::model::Platform>,
    /// <p> The operating system (OS) version supported by the component. If the OS information is available, a prefix match is performed against the base image OS version during image recipe creation.</p>
    pub supported_os_versions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Component <code>data</code> contains inline YAML document content for the component. Alternatively, you can specify the <code>uri</code> of a YAML document file stored in Amazon S3. However, you cannot specify both properties.</p>
    pub data: std::option::Option<std::string::String>,
    /// <p>The <code>uri</code> of a YAML component document file. This must be an S3 URL (<code>s3://bucket/key</code>), and the requester must have permission to access the S3 bucket it points to. If you use Amazon S3, you can specify component content up to your service quota.</p>
    /// <p>Alternatively, you can specify the YAML document inline, using the component <code>data</code> property. You cannot specify both properties.</p>
    pub uri: std::option::Option<std::string::String>,
    /// <p>The ID of the KMS key that should be used to encrypt this component.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The tags of the component.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The idempotency token of the component.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateComponentInput {
    /// <p>The name of the component.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The semantic version of the component. This version follows the semantic version syntax.</p> <note>
    /// <p>The semantic version has four nodes: <major>
    /// .
    /// <minor>
    /// .
    /// <patch>
    /// /
    /// <build>
    /// . You can assign values for the first three, and can filter on all of them.
    /// </build>
    /// </patch>
    /// </minor>
    /// </major></p>
    /// <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p>
    /// <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p>
    /// </note>
    pub fn semantic_version(&self) -> std::option::Option<&str> {
        self.semantic_version.as_deref()
    }
    /// <p>The description of the component. Describes the contents of the component.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The change description of the component. Describes what change has been made in this version, or what makes this version different from other versions of this component.</p>
    pub fn change_description(&self) -> std::option::Option<&str> {
        self.change_description.as_deref()
    }
    /// <p>The platform of the component.</p>
    pub fn platform(&self) -> std::option::Option<&crate::model::Platform> {
        self.platform.as_ref()
    }
    /// <p> The operating system (OS) version supported by the component. If the OS information is available, a prefix match is performed against the base image OS version during image recipe creation.</p>
    pub fn supported_os_versions(&self) -> std::option::Option<&[std::string::String]> {
        self.supported_os_versions.as_deref()
    }
    /// <p>Component <code>data</code> contains inline YAML document content for the component. Alternatively, you can specify the <code>uri</code> of a YAML document file stored in Amazon S3. However, you cannot specify both properties.</p>
    pub fn data(&self) -> std::option::Option<&str> {
        self.data.as_deref()
    }
    /// <p>The <code>uri</code> of a YAML component document file. This must be an S3 URL (<code>s3://bucket/key</code>), and the requester must have permission to access the S3 bucket it points to. If you use Amazon S3, you can specify component content up to your service quota.</p>
    /// <p>Alternatively, you can specify the YAML document inline, using the component <code>data</code> property. You cannot specify both properties.</p>
    pub fn uri(&self) -> std::option::Option<&str> {
        self.uri.as_deref()
    }
    /// <p>The ID of the KMS key that should be used to encrypt this component.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The tags of the component.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The idempotency token of the component.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateComponentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateComponentInput");
        formatter.field("name", &self.name);
        formatter.field("semantic_version", &self.semantic_version);
        formatter.field("description", &self.description);
        formatter.field("change_description", &self.change_description);
        formatter.field("platform", &self.platform);
        formatter.field("supported_os_versions", &self.supported_os_versions);
        formatter.field("data", &self.data);
        formatter.field("uri", &self.uri);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("tags", &self.tags);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelImageCreationInput {
    /// <p>The Amazon Resource Name (ARN) of the image whose creation you want to cancel.</p>
    pub image_build_version_arn: std::option::Option<std::string::String>,
    /// <p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CancelImageCreationInput {
    /// <p>The Amazon Resource Name (ARN) of the image whose creation you want to cancel.</p>
    pub fn image_build_version_arn(&self) -> std::option::Option<&str> {
        self.image_build_version_arn.as_deref()
    }
    /// <p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CancelImageCreationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelImageCreationInput");
        formatter.field("image_build_version_arn", &self.image_build_version_arn);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}
