// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for EC2 Image Builder
///
/// Client for invoking operations on EC2 Image Builder. Each operation on EC2 Image Builder is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_imagebuilder::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_imagebuilder::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_imagebuilder::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CancelImageCreation`](crate::client::fluent_builders::CancelImageCreation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`image_build_version_arn(impl Into<String>)`](crate::client::fluent_builders::CancelImageCreation::image_build_version_arn) / [`set_image_build_version_arn(Option<String>)`](crate::client::fluent_builders::CancelImageCreation::set_image_build_version_arn): <p>The Amazon Resource Name (ARN) of the image whose creation you want to cancel.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CancelImageCreation::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CancelImageCreation::set_client_token): <p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>
    /// - On success, responds with [`CancelImageCreationOutput`](crate::output::CancelImageCreationOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::CancelImageCreationOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`client_token(Option<String>)`](crate::output::CancelImageCreationOutput::client_token): <p>The idempotency token that was used for this request.</p>
    ///   - [`image_build_version_arn(Option<String>)`](crate::output::CancelImageCreationOutput::image_build_version_arn): <p>The Amazon Resource Name (ARN) of the image whose creation has been cancelled.</p>
    /// - On failure, responds with [`SdkError<CancelImageCreationError>`](crate::error::CancelImageCreationError)
    pub fn cancel_image_creation(&self) -> fluent_builders::CancelImageCreation {
        fluent_builders::CancelImageCreation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateComponent`](crate::client::fluent_builders::CreateComponent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateComponent::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateComponent::set_name): <p>The name of the component.</p>
    ///   - [`semantic_version(impl Into<String>)`](crate::client::fluent_builders::CreateComponent::semantic_version) / [`set_semantic_version(Option<String>)`](crate::client::fluent_builders::CreateComponent::set_semantic_version): <p>The semantic version of the component. This version follows the semantic version syntax.</p> <note>   <p>The semantic version has four nodes: <major>    .    <minor>     .     <patch>      /      <build>       . You can assign values for the first three, and can filter on all of them.      </build>     </patch>    </minor>   </major></p>   <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p>   <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p>  </note>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateComponent::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateComponent::set_description): <p>The description of the component. Describes the contents of the component.</p>
    ///   - [`change_description(impl Into<String>)`](crate::client::fluent_builders::CreateComponent::change_description) / [`set_change_description(Option<String>)`](crate::client::fluent_builders::CreateComponent::set_change_description): <p>The change description of the component. Describes what change has been made in this version, or what makes this version different from other versions of this component.</p>
    ///   - [`platform(Platform)`](crate::client::fluent_builders::CreateComponent::platform) / [`set_platform(Option<Platform>)`](crate::client::fluent_builders::CreateComponent::set_platform): <p>The platform of the component.</p>
    ///   - [`supported_os_versions(Vec<String>)`](crate::client::fluent_builders::CreateComponent::supported_os_versions) / [`set_supported_os_versions(Option<Vec<String>>)`](crate::client::fluent_builders::CreateComponent::set_supported_os_versions): <p> The operating system (OS) version supported by the component. If the OS information is available, a prefix match is performed against the base image OS version during image recipe creation.</p>
    ///   - [`data(impl Into<String>)`](crate::client::fluent_builders::CreateComponent::data) / [`set_data(Option<String>)`](crate::client::fluent_builders::CreateComponent::set_data): <p>Component <code>data</code> contains inline YAML document content for the component. Alternatively, you can specify the <code>uri</code> of a YAML document file stored in Amazon S3. However, you cannot specify both properties.</p>
    ///   - [`uri(impl Into<String>)`](crate::client::fluent_builders::CreateComponent::uri) / [`set_uri(Option<String>)`](crate::client::fluent_builders::CreateComponent::set_uri): <p>The <code>uri</code> of a YAML component document file. This must be an S3 URL (<code>s3://bucket/key</code>), and the requester must have permission to access the S3 bucket it points to. If you use Amazon S3, you can specify component content up to your service quota.</p>  <p>Alternatively, you can specify the YAML document inline, using the component <code>data</code> property. You cannot specify both properties.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateComponent::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateComponent::set_kms_key_id): <p>The ID of the KMS key that should be used to encrypt this component.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateComponent::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateComponent::set_tags): <p>The tags of the component.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateComponent::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateComponent::set_client_token): <p>The idempotency token of the component.</p>
    /// - On success, responds with [`CreateComponentOutput`](crate::output::CreateComponentOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::CreateComponentOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`client_token(Option<String>)`](crate::output::CreateComponentOutput::client_token): <p>The idempotency token used to make this request idempotent.</p>
    ///   - [`component_build_version_arn(Option<String>)`](crate::output::CreateComponentOutput::component_build_version_arn): <p>The Amazon Resource Name (ARN) of the component that was created by this request.</p>
    /// - On failure, responds with [`SdkError<CreateComponentError>`](crate::error::CreateComponentError)
    pub fn create_component(&self) -> fluent_builders::CreateComponent {
        fluent_builders::CreateComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateContainerRecipe`](crate::client::fluent_builders::CreateContainerRecipe) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`container_type(ContainerType)`](crate::client::fluent_builders::CreateContainerRecipe::container_type) / [`set_container_type(Option<ContainerType>)`](crate::client::fluent_builders::CreateContainerRecipe::set_container_type): <p>The type of container to create.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateContainerRecipe::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateContainerRecipe::set_name): <p>The name of the container recipe.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateContainerRecipe::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateContainerRecipe::set_description): <p>The description of the container recipe.</p>
    ///   - [`semantic_version(impl Into<String>)`](crate::client::fluent_builders::CreateContainerRecipe::semantic_version) / [`set_semantic_version(Option<String>)`](crate::client::fluent_builders::CreateContainerRecipe::set_semantic_version): <p>The semantic version of the container recipe. This version follows the semantic version syntax.</p> <note>   <p>The semantic version has four nodes: <major>    .    <minor>     .     <patch>      /      <build>       . You can assign values for the first three, and can filter on all of them.      </build>     </patch>    </minor>   </major></p>   <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p>   <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p>  </note>
    ///   - [`components(Vec<ComponentConfiguration>)`](crate::client::fluent_builders::CreateContainerRecipe::components) / [`set_components(Option<Vec<ComponentConfiguration>>)`](crate::client::fluent_builders::CreateContainerRecipe::set_components): <p>Components for build and test that are included in the container recipe.</p>
    ///   - [`instance_configuration(InstanceConfiguration)`](crate::client::fluent_builders::CreateContainerRecipe::instance_configuration) / [`set_instance_configuration(Option<InstanceConfiguration>)`](crate::client::fluent_builders::CreateContainerRecipe::set_instance_configuration): <p>A group of options that can be used to configure an instance for building and testing container images.</p>
    ///   - [`dockerfile_template_data(impl Into<String>)`](crate::client::fluent_builders::CreateContainerRecipe::dockerfile_template_data) / [`set_dockerfile_template_data(Option<String>)`](crate::client::fluent_builders::CreateContainerRecipe::set_dockerfile_template_data): <p>The Dockerfile template used to build your image as an inline data blob.</p>
    ///   - [`dockerfile_template_uri(impl Into<String>)`](crate::client::fluent_builders::CreateContainerRecipe::dockerfile_template_uri) / [`set_dockerfile_template_uri(Option<String>)`](crate::client::fluent_builders::CreateContainerRecipe::set_dockerfile_template_uri): <p>The Amazon S3 URI for the Dockerfile that will be used to build your container image.</p>
    ///   - [`platform_override(Platform)`](crate::client::fluent_builders::CreateContainerRecipe::platform_override) / [`set_platform_override(Option<Platform>)`](crate::client::fluent_builders::CreateContainerRecipe::set_platform_override): <p>Specifies the operating system platform when you use a custom base image.</p>
    ///   - [`image_os_version_override(impl Into<String>)`](crate::client::fluent_builders::CreateContainerRecipe::image_os_version_override) / [`set_image_os_version_override(Option<String>)`](crate::client::fluent_builders::CreateContainerRecipe::set_image_os_version_override): <p>Specifies the operating system version for the base image.</p>
    ///   - [`parent_image(impl Into<String>)`](crate::client::fluent_builders::CreateContainerRecipe::parent_image) / [`set_parent_image(Option<String>)`](crate::client::fluent_builders::CreateContainerRecipe::set_parent_image): <p>The base image for the container recipe.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateContainerRecipe::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateContainerRecipe::set_tags): <p>Tags that are attached to the container recipe.</p>
    ///   - [`working_directory(impl Into<String>)`](crate::client::fluent_builders::CreateContainerRecipe::working_directory) / [`set_working_directory(Option<String>)`](crate::client::fluent_builders::CreateContainerRecipe::set_working_directory): <p>The working directory for use during build and test workflows.</p>
    ///   - [`target_repository(TargetContainerRepository)`](crate::client::fluent_builders::CreateContainerRecipe::target_repository) / [`set_target_repository(Option<TargetContainerRepository>)`](crate::client::fluent_builders::CreateContainerRecipe::set_target_repository): <p>The destination repository for the container image.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateContainerRecipe::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateContainerRecipe::set_kms_key_id): <p>Identifies which KMS key is used to encrypt the container image.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateContainerRecipe::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateContainerRecipe::set_client_token): <p>The client token used to make this request idempotent.</p>
    /// - On success, responds with [`CreateContainerRecipeOutput`](crate::output::CreateContainerRecipeOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::CreateContainerRecipeOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`client_token(Option<String>)`](crate::output::CreateContainerRecipeOutput::client_token): <p>The client token used to make this request idempotent.</p>
    ///   - [`container_recipe_arn(Option<String>)`](crate::output::CreateContainerRecipeOutput::container_recipe_arn): <p>Returns the Amazon Resource Name (ARN) of the container recipe that the request created.</p>
    /// - On failure, responds with [`SdkError<CreateContainerRecipeError>`](crate::error::CreateContainerRecipeError)
    pub fn create_container_recipe(&self) -> fluent_builders::CreateContainerRecipe {
        fluent_builders::CreateContainerRecipe::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDistributionConfiguration`](crate::client::fluent_builders::CreateDistributionConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateDistributionConfiguration::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateDistributionConfiguration::set_name): <p> The name of the distribution configuration.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateDistributionConfiguration::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateDistributionConfiguration::set_description): <p> The description of the distribution configuration.</p>
    ///   - [`distributions(Vec<Distribution>)`](crate::client::fluent_builders::CreateDistributionConfiguration::distributions) / [`set_distributions(Option<Vec<Distribution>>)`](crate::client::fluent_builders::CreateDistributionConfiguration::set_distributions): <p> The distributions of the distribution configuration.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateDistributionConfiguration::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateDistributionConfiguration::set_tags): <p> The tags of the distribution configuration.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateDistributionConfiguration::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateDistributionConfiguration::set_client_token): <p> The idempotency token of the distribution configuration.</p>
    /// - On success, responds with [`CreateDistributionConfigurationOutput`](crate::output::CreateDistributionConfigurationOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::CreateDistributionConfigurationOutput::request_id): <p> The request ID that uniquely identifies this request.</p>
    ///   - [`client_token(Option<String>)`](crate::output::CreateDistributionConfigurationOutput::client_token): <p> The idempotency token used to make this request idempotent.</p>
    ///   - [`distribution_configuration_arn(Option<String>)`](crate::output::CreateDistributionConfigurationOutput::distribution_configuration_arn): <p> The Amazon Resource Name (ARN) of the distribution configuration that was created by this request.</p>
    /// - On failure, responds with [`SdkError<CreateDistributionConfigurationError>`](crate::error::CreateDistributionConfigurationError)
    pub fn create_distribution_configuration(
        &self,
    ) -> fluent_builders::CreateDistributionConfiguration {
        fluent_builders::CreateDistributionConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateImage`](crate::client::fluent_builders::CreateImage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`image_recipe_arn(impl Into<String>)`](crate::client::fluent_builders::CreateImage::image_recipe_arn) / [`set_image_recipe_arn(Option<String>)`](crate::client::fluent_builders::CreateImage::set_image_recipe_arn): <p> The Amazon Resource Name (ARN) of the image recipe that defines how images are configured, tested, and assessed.</p>
    ///   - [`container_recipe_arn(impl Into<String>)`](crate::client::fluent_builders::CreateImage::container_recipe_arn) / [`set_container_recipe_arn(Option<String>)`](crate::client::fluent_builders::CreateImage::set_container_recipe_arn): <p>The Amazon Resource Name (ARN) of the container recipe that defines how images are configured and tested.</p>
    ///   - [`distribution_configuration_arn(impl Into<String>)`](crate::client::fluent_builders::CreateImage::distribution_configuration_arn) / [`set_distribution_configuration_arn(Option<String>)`](crate::client::fluent_builders::CreateImage::set_distribution_configuration_arn): <p> The Amazon Resource Name (ARN) of the distribution configuration that defines and configures the outputs of your pipeline.</p>
    ///   - [`infrastructure_configuration_arn(impl Into<String>)`](crate::client::fluent_builders::CreateImage::infrastructure_configuration_arn) / [`set_infrastructure_configuration_arn(Option<String>)`](crate::client::fluent_builders::CreateImage::set_infrastructure_configuration_arn): <p> The Amazon Resource Name (ARN) of the infrastructure configuration that defines the environment in which your image will be built and tested.</p>
    ///   - [`image_tests_configuration(ImageTestsConfiguration)`](crate::client::fluent_builders::CreateImage::image_tests_configuration) / [`set_image_tests_configuration(Option<ImageTestsConfiguration>)`](crate::client::fluent_builders::CreateImage::set_image_tests_configuration): <p> The image tests configuration of the image.</p>
    ///   - [`enhanced_image_metadata_enabled(bool)`](crate::client::fluent_builders::CreateImage::enhanced_image_metadata_enabled) / [`set_enhanced_image_metadata_enabled(Option<bool>)`](crate::client::fluent_builders::CreateImage::set_enhanced_image_metadata_enabled): <p> Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateImage::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateImage::set_tags): <p> The tags of the image.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateImage::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateImage::set_client_token): <p> The idempotency token used to make this request idempotent.</p>
    /// - On success, responds with [`CreateImageOutput`](crate::output::CreateImageOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::CreateImageOutput::request_id): <p> The request ID that uniquely identifies this request.</p>
    ///   - [`client_token(Option<String>)`](crate::output::CreateImageOutput::client_token): <p> The idempotency token used to make this request idempotent.</p>
    ///   - [`image_build_version_arn(Option<String>)`](crate::output::CreateImageOutput::image_build_version_arn): <p> The Amazon Resource Name (ARN) of the image that was created by this request.</p>
    /// - On failure, responds with [`SdkError<CreateImageError>`](crate::error::CreateImageError)
    pub fn create_image(&self) -> fluent_builders::CreateImage {
        fluent_builders::CreateImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateImagePipeline`](crate::client::fluent_builders::CreateImagePipeline) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateImagePipeline::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateImagePipeline::set_name): <p> The name of the image pipeline.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateImagePipeline::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateImagePipeline::set_description): <p> The description of the image pipeline.</p>
    ///   - [`image_recipe_arn(impl Into<String>)`](crate::client::fluent_builders::CreateImagePipeline::image_recipe_arn) / [`set_image_recipe_arn(Option<String>)`](crate::client::fluent_builders::CreateImagePipeline::set_image_recipe_arn): <p> The Amazon Resource Name (ARN) of the image recipe that will be used to configure images created by this image pipeline.</p>
    ///   - [`container_recipe_arn(impl Into<String>)`](crate::client::fluent_builders::CreateImagePipeline::container_recipe_arn) / [`set_container_recipe_arn(Option<String>)`](crate::client::fluent_builders::CreateImagePipeline::set_container_recipe_arn): <p>The Amazon Resource Name (ARN) of the container recipe that is used to configure images created by this container pipeline.</p>
    ///   - [`infrastructure_configuration_arn(impl Into<String>)`](crate::client::fluent_builders::CreateImagePipeline::infrastructure_configuration_arn) / [`set_infrastructure_configuration_arn(Option<String>)`](crate::client::fluent_builders::CreateImagePipeline::set_infrastructure_configuration_arn): <p> The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to build images created by this image pipeline.</p>
    ///   - [`distribution_configuration_arn(impl Into<String>)`](crate::client::fluent_builders::CreateImagePipeline::distribution_configuration_arn) / [`set_distribution_configuration_arn(Option<String>)`](crate::client::fluent_builders::CreateImagePipeline::set_distribution_configuration_arn): <p> The Amazon Resource Name (ARN) of the distribution configuration that will be used to configure and distribute images created by this image pipeline.</p>
    ///   - [`image_tests_configuration(ImageTestsConfiguration)`](crate::client::fluent_builders::CreateImagePipeline::image_tests_configuration) / [`set_image_tests_configuration(Option<ImageTestsConfiguration>)`](crate::client::fluent_builders::CreateImagePipeline::set_image_tests_configuration): <p> The image test configuration of the image pipeline.</p>
    ///   - [`enhanced_image_metadata_enabled(bool)`](crate::client::fluent_builders::CreateImagePipeline::enhanced_image_metadata_enabled) / [`set_enhanced_image_metadata_enabled(Option<bool>)`](crate::client::fluent_builders::CreateImagePipeline::set_enhanced_image_metadata_enabled): <p> Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.</p>
    ///   - [`schedule(Schedule)`](crate::client::fluent_builders::CreateImagePipeline::schedule) / [`set_schedule(Option<Schedule>)`](crate::client::fluent_builders::CreateImagePipeline::set_schedule): <p> The schedule of the image pipeline.</p>
    ///   - [`status(PipelineStatus)`](crate::client::fluent_builders::CreateImagePipeline::status) / [`set_status(Option<PipelineStatus>)`](crate::client::fluent_builders::CreateImagePipeline::set_status): <p> The status of the image pipeline.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateImagePipeline::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateImagePipeline::set_tags): <p> The tags of the image pipeline.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateImagePipeline::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateImagePipeline::set_client_token): <p> The idempotency token used to make this request idempotent.</p>
    /// - On success, responds with [`CreateImagePipelineOutput`](crate::output::CreateImagePipelineOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::CreateImagePipelineOutput::request_id): <p> The request ID that uniquely identifies this request.</p>
    ///   - [`client_token(Option<String>)`](crate::output::CreateImagePipelineOutput::client_token): <p> The idempotency token used to make this request idempotent.</p>
    ///   - [`image_pipeline_arn(Option<String>)`](crate::output::CreateImagePipelineOutput::image_pipeline_arn): <p> The Amazon Resource Name (ARN) of the image pipeline that was created by this request.</p>
    /// - On failure, responds with [`SdkError<CreateImagePipelineError>`](crate::error::CreateImagePipelineError)
    pub fn create_image_pipeline(&self) -> fluent_builders::CreateImagePipeline {
        fluent_builders::CreateImagePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateImageRecipe`](crate::client::fluent_builders::CreateImageRecipe) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateImageRecipe::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateImageRecipe::set_name): <p> The name of the image recipe.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateImageRecipe::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateImageRecipe::set_description): <p> The description of the image recipe.</p>
    ///   - [`semantic_version(impl Into<String>)`](crate::client::fluent_builders::CreateImageRecipe::semantic_version) / [`set_semantic_version(Option<String>)`](crate::client::fluent_builders::CreateImageRecipe::set_semantic_version): <p>The semantic version of the image recipe. This version follows the semantic version syntax.</p> <note>   <p>The semantic version has four nodes: <major>    .    <minor>     .     <patch>      /      <build>       . You can assign values for the first three, and can filter on all of them.      </build>     </patch>    </minor>   </major></p>   <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p>   <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p>  </note>
    ///   - [`components(Vec<ComponentConfiguration>)`](crate::client::fluent_builders::CreateImageRecipe::components) / [`set_components(Option<Vec<ComponentConfiguration>>)`](crate::client::fluent_builders::CreateImageRecipe::set_components): <p>The components of the image recipe.</p>
    ///   - [`parent_image(impl Into<String>)`](crate::client::fluent_builders::CreateImageRecipe::parent_image) / [`set_parent_image(Option<String>)`](crate::client::fluent_builders::CreateImageRecipe::set_parent_image): <p>The base image of the image recipe. The value of the string can be the ARN of the base image or an AMI ID. The format for the ARN follows this example: <code>arn:aws:imagebuilder:us-west-2:aws:image/windows-server-2016-english-full-base-x86/x.x.x</code>. You can provide the specific version that you want to use, or you can use a wildcard in all of the fields. If you enter an AMI ID for the string value, you must have access to the AMI, and the AMI must be in the same Region in which you are using Image Builder.</p>
    ///   - [`block_device_mappings(Vec<InstanceBlockDeviceMapping>)`](crate::client::fluent_builders::CreateImageRecipe::block_device_mappings) / [`set_block_device_mappings(Option<Vec<InstanceBlockDeviceMapping>>)`](crate::client::fluent_builders::CreateImageRecipe::set_block_device_mappings): <p>The block device mappings of the image recipe.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateImageRecipe::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateImageRecipe::set_tags): <p> The tags of the image recipe.</p>
    ///   - [`working_directory(impl Into<String>)`](crate::client::fluent_builders::CreateImageRecipe::working_directory) / [`set_working_directory(Option<String>)`](crate::client::fluent_builders::CreateImageRecipe::set_working_directory): <p>The working directory used during build and test workflows.</p>
    ///   - [`additional_instance_configuration(AdditionalInstanceConfiguration)`](crate::client::fluent_builders::CreateImageRecipe::additional_instance_configuration) / [`set_additional_instance_configuration(Option<AdditionalInstanceConfiguration>)`](crate::client::fluent_builders::CreateImageRecipe::set_additional_instance_configuration): <p>Specify additional settings and launch scripts for your build instances.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateImageRecipe::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateImageRecipe::set_client_token): <p>The idempotency token used to make this request idempotent.</p>
    /// - On success, responds with [`CreateImageRecipeOutput`](crate::output::CreateImageRecipeOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::CreateImageRecipeOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`client_token(Option<String>)`](crate::output::CreateImageRecipeOutput::client_token): <p>The idempotency token used to make this request idempotent.</p>
    ///   - [`image_recipe_arn(Option<String>)`](crate::output::CreateImageRecipeOutput::image_recipe_arn): <p>The Amazon Resource Name (ARN) of the image recipe that was created by this request.</p>
    /// - On failure, responds with [`SdkError<CreateImageRecipeError>`](crate::error::CreateImageRecipeError)
    pub fn create_image_recipe(&self) -> fluent_builders::CreateImageRecipe {
        fluent_builders::CreateImageRecipe::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateInfrastructureConfiguration`](crate::client::fluent_builders::CreateInfrastructureConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateInfrastructureConfiguration::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateInfrastructureConfiguration::set_name): <p>The name of the infrastructure configuration.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateInfrastructureConfiguration::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateInfrastructureConfiguration::set_description): <p>The description of the infrastructure configuration.</p>
    ///   - [`instance_types(Vec<String>)`](crate::client::fluent_builders::CreateInfrastructureConfiguration::instance_types) / [`set_instance_types(Option<Vec<String>>)`](crate::client::fluent_builders::CreateInfrastructureConfiguration::set_instance_types): <p>The instance types of the infrastructure configuration. You can specify one or more instance types to use for this build. The service will pick one of these instance types based on availability.</p>
    ///   - [`instance_profile_name(impl Into<String>)`](crate::client::fluent_builders::CreateInfrastructureConfiguration::instance_profile_name) / [`set_instance_profile_name(Option<String>)`](crate::client::fluent_builders::CreateInfrastructureConfiguration::set_instance_profile_name): <p>The instance profile to associate with the instance used to customize your Amazon EC2 AMI.</p>
    ///   - [`security_group_ids(Vec<String>)`](crate::client::fluent_builders::CreateInfrastructureConfiguration::security_group_ids) / [`set_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateInfrastructureConfiguration::set_security_group_ids): <p>The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.</p>
    ///   - [`subnet_id(impl Into<String>)`](crate::client::fluent_builders::CreateInfrastructureConfiguration::subnet_id) / [`set_subnet_id(Option<String>)`](crate::client::fluent_builders::CreateInfrastructureConfiguration::set_subnet_id): <p>The subnet ID in which to place the instance used to customize your Amazon EC2 AMI.</p>
    ///   - [`logging(Logging)`](crate::client::fluent_builders::CreateInfrastructureConfiguration::logging) / [`set_logging(Option<Logging>)`](crate::client::fluent_builders::CreateInfrastructureConfiguration::set_logging): <p>The logging configuration of the infrastructure configuration.</p>
    ///   - [`key_pair(impl Into<String>)`](crate::client::fluent_builders::CreateInfrastructureConfiguration::key_pair) / [`set_key_pair(Option<String>)`](crate::client::fluent_builders::CreateInfrastructureConfiguration::set_key_pair): <p>The key pair of the infrastructure configuration. You can use this to log on to and debug the instance used to create your image.</p>
    ///   - [`terminate_instance_on_failure(bool)`](crate::client::fluent_builders::CreateInfrastructureConfiguration::terminate_instance_on_failure) / [`set_terminate_instance_on_failure(Option<bool>)`](crate::client::fluent_builders::CreateInfrastructureConfiguration::set_terminate_instance_on_failure): <p>The terminate instance on failure setting of the infrastructure configuration. Set to false if you want Image Builder to retain the instance used to configure your AMI if the build or test phase of your workflow fails.</p>
    ///   - [`sns_topic_arn(impl Into<String>)`](crate::client::fluent_builders::CreateInfrastructureConfiguration::sns_topic_arn) / [`set_sns_topic_arn(Option<String>)`](crate::client::fluent_builders::CreateInfrastructureConfiguration::set_sns_topic_arn): <p>The Amazon Resource Name (ARN) for the SNS topic to which we send image build event notifications.</p> <note>   <p>EC2 Image Builder is unable to send notifications to SNS topics that are encrypted using keys from other accounts. The key that is used to encrypt the SNS topic must reside in the account that the Image Builder service runs under.</p>  </note>
    ///   - [`resource_tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateInfrastructureConfiguration::resource_tags) / [`set_resource_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateInfrastructureConfiguration::set_resource_tags): <p>The tags attached to the resource created by Image Builder.</p>
    ///   - [`instance_metadata_options(InstanceMetadataOptions)`](crate::client::fluent_builders::CreateInfrastructureConfiguration::instance_metadata_options) / [`set_instance_metadata_options(Option<InstanceMetadataOptions>)`](crate::client::fluent_builders::CreateInfrastructureConfiguration::set_instance_metadata_options): <p>The instance metadata options that you can set for the HTTP requests that pipeline builds use to launch EC2 build and test instances.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateInfrastructureConfiguration::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateInfrastructureConfiguration::set_tags): <p>The tags of the infrastructure configuration.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateInfrastructureConfiguration::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateInfrastructureConfiguration::set_client_token): <p>The idempotency token used to make this request idempotent.</p>
    /// - On success, responds with [`CreateInfrastructureConfigurationOutput`](crate::output::CreateInfrastructureConfigurationOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::CreateInfrastructureConfigurationOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`client_token(Option<String>)`](crate::output::CreateInfrastructureConfigurationOutput::client_token): <p>The idempotency token used to make this request idempotent.</p>
    ///   - [`infrastructure_configuration_arn(Option<String>)`](crate::output::CreateInfrastructureConfigurationOutput::infrastructure_configuration_arn): <p>The Amazon Resource Name (ARN) of the infrastructure configuration that was created by this request.</p>
    /// - On failure, responds with [`SdkError<CreateInfrastructureConfigurationError>`](crate::error::CreateInfrastructureConfigurationError)
    pub fn create_infrastructure_configuration(
        &self,
    ) -> fluent_builders::CreateInfrastructureConfiguration {
        fluent_builders::CreateInfrastructureConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteComponent`](crate::client::fluent_builders::DeleteComponent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`component_build_version_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteComponent::component_build_version_arn) / [`set_component_build_version_arn(Option<String>)`](crate::client::fluent_builders::DeleteComponent::set_component_build_version_arn): <p>The Amazon Resource Name (ARN) of the component build version to delete.</p>
    /// - On success, responds with [`DeleteComponentOutput`](crate::output::DeleteComponentOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::DeleteComponentOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`component_build_version_arn(Option<String>)`](crate::output::DeleteComponentOutput::component_build_version_arn): <p>The Amazon Resource Name (ARN) of the component build version that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteComponentError>`](crate::error::DeleteComponentError)
    pub fn delete_component(&self) -> fluent_builders::DeleteComponent {
        fluent_builders::DeleteComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteContainerRecipe`](crate::client::fluent_builders::DeleteContainerRecipe) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`container_recipe_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteContainerRecipe::container_recipe_arn) / [`set_container_recipe_arn(Option<String>)`](crate::client::fluent_builders::DeleteContainerRecipe::set_container_recipe_arn): <p>The Amazon Resource Name (ARN) of the container recipe to delete.</p>
    /// - On success, responds with [`DeleteContainerRecipeOutput`](crate::output::DeleteContainerRecipeOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::DeleteContainerRecipeOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`container_recipe_arn(Option<String>)`](crate::output::DeleteContainerRecipeOutput::container_recipe_arn): <p>The Amazon Resource Name (ARN) of the container recipe that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteContainerRecipeError>`](crate::error::DeleteContainerRecipeError)
    pub fn delete_container_recipe(&self) -> fluent_builders::DeleteContainerRecipe {
        fluent_builders::DeleteContainerRecipe::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDistributionConfiguration`](crate::client::fluent_builders::DeleteDistributionConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`distribution_configuration_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteDistributionConfiguration::distribution_configuration_arn) / [`set_distribution_configuration_arn(Option<String>)`](crate::client::fluent_builders::DeleteDistributionConfiguration::set_distribution_configuration_arn): <p>The Amazon Resource Name (ARN) of the distribution configuration to delete.</p>
    /// - On success, responds with [`DeleteDistributionConfigurationOutput`](crate::output::DeleteDistributionConfigurationOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::DeleteDistributionConfigurationOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`distribution_configuration_arn(Option<String>)`](crate::output::DeleteDistributionConfigurationOutput::distribution_configuration_arn): <p>The Amazon Resource Name (ARN) of the distribution configuration that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteDistributionConfigurationError>`](crate::error::DeleteDistributionConfigurationError)
    pub fn delete_distribution_configuration(
        &self,
    ) -> fluent_builders::DeleteDistributionConfiguration {
        fluent_builders::DeleteDistributionConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteImage`](crate::client::fluent_builders::DeleteImage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`image_build_version_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteImage::image_build_version_arn) / [`set_image_build_version_arn(Option<String>)`](crate::client::fluent_builders::DeleteImage::set_image_build_version_arn): <p>The Amazon Resource Name (ARN) of the Image Builder image resource to delete.</p>
    /// - On success, responds with [`DeleteImageOutput`](crate::output::DeleteImageOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::DeleteImageOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`image_build_version_arn(Option<String>)`](crate::output::DeleteImageOutput::image_build_version_arn): <p>The Amazon Resource Name (ARN) of the Image Builder image resource that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteImageError>`](crate::error::DeleteImageError)
    pub fn delete_image(&self) -> fluent_builders::DeleteImage {
        fluent_builders::DeleteImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteImagePipeline`](crate::client::fluent_builders::DeleteImagePipeline) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`image_pipeline_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteImagePipeline::image_pipeline_arn) / [`set_image_pipeline_arn(Option<String>)`](crate::client::fluent_builders::DeleteImagePipeline::set_image_pipeline_arn): <p>The Amazon Resource Name (ARN) of the image pipeline to delete.</p>
    /// - On success, responds with [`DeleteImagePipelineOutput`](crate::output::DeleteImagePipelineOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::DeleteImagePipelineOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`image_pipeline_arn(Option<String>)`](crate::output::DeleteImagePipelineOutput::image_pipeline_arn): <p>The Amazon Resource Name (ARN) of the image pipeline that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteImagePipelineError>`](crate::error::DeleteImagePipelineError)
    pub fn delete_image_pipeline(&self) -> fluent_builders::DeleteImagePipeline {
        fluent_builders::DeleteImagePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteImageRecipe`](crate::client::fluent_builders::DeleteImageRecipe) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`image_recipe_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteImageRecipe::image_recipe_arn) / [`set_image_recipe_arn(Option<String>)`](crate::client::fluent_builders::DeleteImageRecipe::set_image_recipe_arn): <p>The Amazon Resource Name (ARN) of the image recipe to delete.</p>
    /// - On success, responds with [`DeleteImageRecipeOutput`](crate::output::DeleteImageRecipeOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::DeleteImageRecipeOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`image_recipe_arn(Option<String>)`](crate::output::DeleteImageRecipeOutput::image_recipe_arn): <p>The Amazon Resource Name (ARN) of the image recipe that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteImageRecipeError>`](crate::error::DeleteImageRecipeError)
    pub fn delete_image_recipe(&self) -> fluent_builders::DeleteImageRecipe {
        fluent_builders::DeleteImageRecipe::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteInfrastructureConfiguration`](crate::client::fluent_builders::DeleteInfrastructureConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`infrastructure_configuration_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteInfrastructureConfiguration::infrastructure_configuration_arn) / [`set_infrastructure_configuration_arn(Option<String>)`](crate::client::fluent_builders::DeleteInfrastructureConfiguration::set_infrastructure_configuration_arn): <p>The Amazon Resource Name (ARN) of the infrastructure configuration to delete.</p>
    /// - On success, responds with [`DeleteInfrastructureConfigurationOutput`](crate::output::DeleteInfrastructureConfigurationOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::DeleteInfrastructureConfigurationOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`infrastructure_configuration_arn(Option<String>)`](crate::output::DeleteInfrastructureConfigurationOutput::infrastructure_configuration_arn): <p>The Amazon Resource Name (ARN) of the infrastructure configuration that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteInfrastructureConfigurationError>`](crate::error::DeleteInfrastructureConfigurationError)
    pub fn delete_infrastructure_configuration(
        &self,
    ) -> fluent_builders::DeleteInfrastructureConfiguration {
        fluent_builders::DeleteInfrastructureConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetComponent`](crate::client::fluent_builders::GetComponent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`component_build_version_arn(impl Into<String>)`](crate::client::fluent_builders::GetComponent::component_build_version_arn) / [`set_component_build_version_arn(Option<String>)`](crate::client::fluent_builders::GetComponent::set_component_build_version_arn): <p>The Amazon Resource Name (ARN) of the component that you want to retrieve. Regex requires "/\d+$" suffix.</p>
    /// - On success, responds with [`GetComponentOutput`](crate::output::GetComponentOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::GetComponentOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`component(Option<Component>)`](crate::output::GetComponentOutput::component): <p>The component object associated with the specified ARN.</p>
    /// - On failure, responds with [`SdkError<GetComponentError>`](crate::error::GetComponentError)
    pub fn get_component(&self) -> fluent_builders::GetComponent {
        fluent_builders::GetComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetComponentPolicy`](crate::client::fluent_builders::GetComponentPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`component_arn(impl Into<String>)`](crate::client::fluent_builders::GetComponentPolicy::component_arn) / [`set_component_arn(Option<String>)`](crate::client::fluent_builders::GetComponentPolicy::set_component_arn): <p>The Amazon Resource Name (ARN) of the component whose policy you want to retrieve.</p>
    /// - On success, responds with [`GetComponentPolicyOutput`](crate::output::GetComponentPolicyOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::GetComponentPolicyOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`policy(Option<String>)`](crate::output::GetComponentPolicyOutput::policy): <p>The component policy.</p>
    /// - On failure, responds with [`SdkError<GetComponentPolicyError>`](crate::error::GetComponentPolicyError)
    pub fn get_component_policy(&self) -> fluent_builders::GetComponentPolicy {
        fluent_builders::GetComponentPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetContainerRecipe`](crate::client::fluent_builders::GetContainerRecipe) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`container_recipe_arn(impl Into<String>)`](crate::client::fluent_builders::GetContainerRecipe::container_recipe_arn) / [`set_container_recipe_arn(Option<String>)`](crate::client::fluent_builders::GetContainerRecipe::set_container_recipe_arn): <p>The Amazon Resource Name (ARN) of the container recipe to retrieve.</p>
    /// - On success, responds with [`GetContainerRecipeOutput`](crate::output::GetContainerRecipeOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::GetContainerRecipeOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`container_recipe(Option<ContainerRecipe>)`](crate::output::GetContainerRecipeOutput::container_recipe): <p>The container recipe object that is returned.</p>
    /// - On failure, responds with [`SdkError<GetContainerRecipeError>`](crate::error::GetContainerRecipeError)
    pub fn get_container_recipe(&self) -> fluent_builders::GetContainerRecipe {
        fluent_builders::GetContainerRecipe::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetContainerRecipePolicy`](crate::client::fluent_builders::GetContainerRecipePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`container_recipe_arn(impl Into<String>)`](crate::client::fluent_builders::GetContainerRecipePolicy::container_recipe_arn) / [`set_container_recipe_arn(Option<String>)`](crate::client::fluent_builders::GetContainerRecipePolicy::set_container_recipe_arn): <p>The Amazon Resource Name (ARN) of the container recipe for the policy being requested.</p>
    /// - On success, responds with [`GetContainerRecipePolicyOutput`](crate::output::GetContainerRecipePolicyOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::GetContainerRecipePolicyOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`policy(Option<String>)`](crate::output::GetContainerRecipePolicyOutput::policy): <p>The container recipe policy object that is returned.</p>
    /// - On failure, responds with [`SdkError<GetContainerRecipePolicyError>`](crate::error::GetContainerRecipePolicyError)
    pub fn get_container_recipe_policy(&self) -> fluent_builders::GetContainerRecipePolicy {
        fluent_builders::GetContainerRecipePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDistributionConfiguration`](crate::client::fluent_builders::GetDistributionConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`distribution_configuration_arn(impl Into<String>)`](crate::client::fluent_builders::GetDistributionConfiguration::distribution_configuration_arn) / [`set_distribution_configuration_arn(Option<String>)`](crate::client::fluent_builders::GetDistributionConfiguration::set_distribution_configuration_arn): <p>The Amazon Resource Name (ARN) of the distribution configuration that you want to retrieve.</p>
    /// - On success, responds with [`GetDistributionConfigurationOutput`](crate::output::GetDistributionConfigurationOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::GetDistributionConfigurationOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`distribution_configuration(Option<DistributionConfiguration>)`](crate::output::GetDistributionConfigurationOutput::distribution_configuration): <p>The distribution configuration object.</p>
    /// - On failure, responds with [`SdkError<GetDistributionConfigurationError>`](crate::error::GetDistributionConfigurationError)
    pub fn get_distribution_configuration(&self) -> fluent_builders::GetDistributionConfiguration {
        fluent_builders::GetDistributionConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetImage`](crate::client::fluent_builders::GetImage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`image_build_version_arn(impl Into<String>)`](crate::client::fluent_builders::GetImage::image_build_version_arn) / [`set_image_build_version_arn(Option<String>)`](crate::client::fluent_builders::GetImage::set_image_build_version_arn): <p>The Amazon Resource Name (ARN) of the image that you want to retrieve.</p>
    /// - On success, responds with [`GetImageOutput`](crate::output::GetImageOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::GetImageOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`image(Option<Image>)`](crate::output::GetImageOutput::image): <p>The image object.</p>
    /// - On failure, responds with [`SdkError<GetImageError>`](crate::error::GetImageError)
    pub fn get_image(&self) -> fluent_builders::GetImage {
        fluent_builders::GetImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetImagePipeline`](crate::client::fluent_builders::GetImagePipeline) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`image_pipeline_arn(impl Into<String>)`](crate::client::fluent_builders::GetImagePipeline::image_pipeline_arn) / [`set_image_pipeline_arn(Option<String>)`](crate::client::fluent_builders::GetImagePipeline::set_image_pipeline_arn): <p>The Amazon Resource Name (ARN) of the image pipeline that you want to retrieve.</p>
    /// - On success, responds with [`GetImagePipelineOutput`](crate::output::GetImagePipelineOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::GetImagePipelineOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`image_pipeline(Option<ImagePipeline>)`](crate::output::GetImagePipelineOutput::image_pipeline): <p>The image pipeline object.</p>
    /// - On failure, responds with [`SdkError<GetImagePipelineError>`](crate::error::GetImagePipelineError)
    pub fn get_image_pipeline(&self) -> fluent_builders::GetImagePipeline {
        fluent_builders::GetImagePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetImagePolicy`](crate::client::fluent_builders::GetImagePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`image_arn(impl Into<String>)`](crate::client::fluent_builders::GetImagePolicy::image_arn) / [`set_image_arn(Option<String>)`](crate::client::fluent_builders::GetImagePolicy::set_image_arn): <p>The Amazon Resource Name (ARN) of the image whose policy you want to retrieve.</p>
    /// - On success, responds with [`GetImagePolicyOutput`](crate::output::GetImagePolicyOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::GetImagePolicyOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`policy(Option<String>)`](crate::output::GetImagePolicyOutput::policy): <p>The image policy object.</p>
    /// - On failure, responds with [`SdkError<GetImagePolicyError>`](crate::error::GetImagePolicyError)
    pub fn get_image_policy(&self) -> fluent_builders::GetImagePolicy {
        fluent_builders::GetImagePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetImageRecipe`](crate::client::fluent_builders::GetImageRecipe) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`image_recipe_arn(impl Into<String>)`](crate::client::fluent_builders::GetImageRecipe::image_recipe_arn) / [`set_image_recipe_arn(Option<String>)`](crate::client::fluent_builders::GetImageRecipe::set_image_recipe_arn): <p>The Amazon Resource Name (ARN) of the image recipe that you want to retrieve.</p>
    /// - On success, responds with [`GetImageRecipeOutput`](crate::output::GetImageRecipeOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::GetImageRecipeOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`image_recipe(Option<ImageRecipe>)`](crate::output::GetImageRecipeOutput::image_recipe): <p>The image recipe object.</p>
    /// - On failure, responds with [`SdkError<GetImageRecipeError>`](crate::error::GetImageRecipeError)
    pub fn get_image_recipe(&self) -> fluent_builders::GetImageRecipe {
        fluent_builders::GetImageRecipe::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetImageRecipePolicy`](crate::client::fluent_builders::GetImageRecipePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`image_recipe_arn(impl Into<String>)`](crate::client::fluent_builders::GetImageRecipePolicy::image_recipe_arn) / [`set_image_recipe_arn(Option<String>)`](crate::client::fluent_builders::GetImageRecipePolicy::set_image_recipe_arn): <p>The Amazon Resource Name (ARN) of the image recipe whose policy you want to retrieve.</p>
    /// - On success, responds with [`GetImageRecipePolicyOutput`](crate::output::GetImageRecipePolicyOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::GetImageRecipePolicyOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`policy(Option<String>)`](crate::output::GetImageRecipePolicyOutput::policy): <p>The image recipe policy object.</p>
    /// - On failure, responds with [`SdkError<GetImageRecipePolicyError>`](crate::error::GetImageRecipePolicyError)
    pub fn get_image_recipe_policy(&self) -> fluent_builders::GetImageRecipePolicy {
        fluent_builders::GetImageRecipePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetInfrastructureConfiguration`](crate::client::fluent_builders::GetInfrastructureConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`infrastructure_configuration_arn(impl Into<String>)`](crate::client::fluent_builders::GetInfrastructureConfiguration::infrastructure_configuration_arn) / [`set_infrastructure_configuration_arn(Option<String>)`](crate::client::fluent_builders::GetInfrastructureConfiguration::set_infrastructure_configuration_arn): <p>The Amazon Resource Name (ARN) of the infrastructure configuration that you want to retrieve.</p>
    /// - On success, responds with [`GetInfrastructureConfigurationOutput`](crate::output::GetInfrastructureConfigurationOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::GetInfrastructureConfigurationOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`infrastructure_configuration(Option<InfrastructureConfiguration>)`](crate::output::GetInfrastructureConfigurationOutput::infrastructure_configuration): <p>The infrastructure configuration object.</p>
    /// - On failure, responds with [`SdkError<GetInfrastructureConfigurationError>`](crate::error::GetInfrastructureConfigurationError)
    pub fn get_infrastructure_configuration(
        &self,
    ) -> fluent_builders::GetInfrastructureConfiguration {
        fluent_builders::GetInfrastructureConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ImportComponent`](crate::client::fluent_builders::ImportComponent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::ImportComponent::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::ImportComponent::set_name): <p> The name of the component.</p>
    ///   - [`semantic_version(impl Into<String>)`](crate::client::fluent_builders::ImportComponent::semantic_version) / [`set_semantic_version(Option<String>)`](crate::client::fluent_builders::ImportComponent::set_semantic_version): <p>The semantic version of the component. This version follows the semantic version syntax.</p> <note>   <p>The semantic version has four nodes: <major>    .    <minor>     .     <patch>      /      <build>       . You can assign values for the first three, and can filter on all of them.      </build>     </patch>    </minor>   </major></p>   <p> <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.</p>  </note>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::ImportComponent::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::ImportComponent::set_description): <p>The description of the component. Describes the contents of the component.</p>
    ///   - [`change_description(impl Into<String>)`](crate::client::fluent_builders::ImportComponent::change_description) / [`set_change_description(Option<String>)`](crate::client::fluent_builders::ImportComponent::set_change_description): <p>The change description of the component. Describes what change has been made in this version, or what makes this version different from other versions of this component.</p>
    ///   - [`r#type(ComponentType)`](crate::client::fluent_builders::ImportComponent::type) / [`set_type(Option<ComponentType>)`](crate::client::fluent_builders::ImportComponent::set_type): <p>The type of the component denotes whether the component is used to build the image, or only to test it.</p>
    ///   - [`format(ComponentFormat)`](crate::client::fluent_builders::ImportComponent::format) / [`set_format(Option<ComponentFormat>)`](crate::client::fluent_builders::ImportComponent::set_format): <p>The format of the resource that you want to import as a component.</p>
    ///   - [`platform(Platform)`](crate::client::fluent_builders::ImportComponent::platform) / [`set_platform(Option<Platform>)`](crate::client::fluent_builders::ImportComponent::set_platform): <p>The platform of the component.</p>
    ///   - [`data(impl Into<String>)`](crate::client::fluent_builders::ImportComponent::data) / [`set_data(Option<String>)`](crate::client::fluent_builders::ImportComponent::set_data): <p>The data of the component. Used to specify the data inline. Either <code>data</code> or <code>uri</code> can be used to specify the data within the component.</p>
    ///   - [`uri(impl Into<String>)`](crate::client::fluent_builders::ImportComponent::uri) / [`set_uri(Option<String>)`](crate::client::fluent_builders::ImportComponent::set_uri): <p>The uri of the component. Must be an Amazon S3 URL and the requester must have permission to access the Amazon S3 bucket. If you use Amazon S3, you can specify component content up to your service quota. Either <code>data</code> or <code>uri</code> can be used to specify the data within the component.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::ImportComponent::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::ImportComponent::set_kms_key_id): <p>The ID of the KMS key that should be used to encrypt this component.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::ImportComponent::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::ImportComponent::set_tags): <p>The tags of the component.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::ImportComponent::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::ImportComponent::set_client_token): <p>The idempotency token of the component.</p>
    /// - On success, responds with [`ImportComponentOutput`](crate::output::ImportComponentOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::ImportComponentOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`client_token(Option<String>)`](crate::output::ImportComponentOutput::client_token): <p>The idempotency token used to make this request idempotent.</p>
    ///   - [`component_build_version_arn(Option<String>)`](crate::output::ImportComponentOutput::component_build_version_arn): <p>The Amazon Resource Name (ARN) of the imported component.</p>
    /// - On failure, responds with [`SdkError<ImportComponentError>`](crate::error::ImportComponentError)
    pub fn import_component(&self) -> fluent_builders::ImportComponent {
        fluent_builders::ImportComponent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ImportVmImage`](crate::client::fluent_builders::ImportVmImage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::ImportVmImage::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::ImportVmImage::set_name): <p>The name of the base image that is created by the import process.</p>
    ///   - [`semantic_version(impl Into<String>)`](crate::client::fluent_builders::ImportVmImage::semantic_version) / [`set_semantic_version(Option<String>)`](crate::client::fluent_builders::ImportVmImage::set_semantic_version): <p>The semantic version to attach to the base image that was created during the import process. This version follows the semantic version syntax.</p> <note>   <p>The semantic version has four nodes: <major>    .    <minor>     .     <patch>      /      <build>       . You can assign values for the first three, and can filter on all of them.      </build>     </patch>    </minor>   </major></p>   <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p>   <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p>  </note>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::ImportVmImage::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::ImportVmImage::set_description): <p>The description for the base image that is created by the import process.</p>
    ///   - [`platform(Platform)`](crate::client::fluent_builders::ImportVmImage::platform) / [`set_platform(Option<Platform>)`](crate::client::fluent_builders::ImportVmImage::set_platform): <p>The operating system platform for the imported VM.</p>
    ///   - [`os_version(impl Into<String>)`](crate::client::fluent_builders::ImportVmImage::os_version) / [`set_os_version(Option<String>)`](crate::client::fluent_builders::ImportVmImage::set_os_version): <p>The operating system version for the imported VM.</p>
    ///   - [`vm_import_task_id(impl Into<String>)`](crate::client::fluent_builders::ImportVmImage::vm_import_task_id) / [`set_vm_import_task_id(Option<String>)`](crate::client::fluent_builders::ImportVmImage::set_vm_import_task_id): <p>The <code>importTaskId</code> (API) or <code>ImportTaskId</code> (CLI) from the Amazon EC2 VM import process. Image Builder retrieves information from the import process to pull in the AMI that is created from the VM source as the base image for your recipe.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::ImportVmImage::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::ImportVmImage::set_tags): <p>Tags that are attached to the import resources.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::ImportVmImage::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::ImportVmImage::set_client_token): <p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>
    /// - On success, responds with [`ImportVmImageOutput`](crate::output::ImportVmImageOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::ImportVmImageOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`image_arn(Option<String>)`](crate::output::ImportVmImageOutput::image_arn): <p>The Amazon Resource Name (ARN) of the AMI that was created during the VM import process. This AMI is used as the base image for the recipe that imported the VM.</p>
    ///   - [`client_token(Option<String>)`](crate::output::ImportVmImageOutput::client_token): <p>The idempotency token that was used for this request.</p>
    /// - On failure, responds with [`SdkError<ImportVmImageError>`](crate::error::ImportVmImageError)
    pub fn import_vm_image(&self) -> fluent_builders::ImportVmImage {
        fluent_builders::ImportVmImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListComponentBuildVersions`](crate::client::fluent_builders::ListComponentBuildVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListComponentBuildVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`component_version_arn(impl Into<String>)`](crate::client::fluent_builders::ListComponentBuildVersions::component_version_arn) / [`set_component_version_arn(Option<String>)`](crate::client::fluent_builders::ListComponentBuildVersions::set_component_version_arn): <p>The component version Amazon Resource Name (ARN) whose versions you want to list.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListComponentBuildVersions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListComponentBuildVersions::set_max_results): <p>The maximum items to return in a request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListComponentBuildVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListComponentBuildVersions::set_next_token): <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    /// - On success, responds with [`ListComponentBuildVersionsOutput`](crate::output::ListComponentBuildVersionsOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::ListComponentBuildVersionsOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`component_summary_list(Option<Vec<ComponentSummary>>)`](crate::output::ListComponentBuildVersionsOutput::component_summary_list): <p>The list of component summaries for the specified semantic version.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListComponentBuildVersionsOutput::next_token): <p>The next token used for paginated responses. When this is not empty, there are additional elements that the service has not included in this request. Use this token with the next request to retrieve additional objects.</p>
    /// - On failure, responds with [`SdkError<ListComponentBuildVersionsError>`](crate::error::ListComponentBuildVersionsError)
    pub fn list_component_build_versions(&self) -> fluent_builders::ListComponentBuildVersions {
        fluent_builders::ListComponentBuildVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListComponents`](crate::client::fluent_builders::ListComponents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListComponents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`owner(Ownership)`](crate::client::fluent_builders::ListComponents::owner) / [`set_owner(Option<Ownership>)`](crate::client::fluent_builders::ListComponents::set_owner): <p>The owner defines which components you want to list. By default, this request will only show components owned by your account. You can use this field to specify if you want to view components owned by yourself, by Amazon, or those components that have been shared with you by other customers.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::ListComponents::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::ListComponents::set_filters): <p>Use the following filters to streamline results:</p>  <ul>   <li> <p> <code>description</code> </p> </li>   <li> <p> <code>name</code> </p> </li>   <li> <p> <code>platform</code> </p> </li>   <li> <p> <code>supportedOsVersion</code> </p> </li>   <li> <p> <code>type</code> </p> </li>   <li> <p> <code>version</code> </p> </li>  </ul>
    ///   - [`by_name(bool)`](crate::client::fluent_builders::ListComponents::by_name) / [`set_by_name(bool)`](crate::client::fluent_builders::ListComponents::set_by_name): <p>Returns the list of component build versions for the specified name.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListComponents::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListComponents::set_max_results): <p>The maximum items to return in a request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListComponents::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListComponents::set_next_token): <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    /// - On success, responds with [`ListComponentsOutput`](crate::output::ListComponentsOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::ListComponentsOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`component_version_list(Option<Vec<ComponentVersion>>)`](crate::output::ListComponentsOutput::component_version_list): <p>The list of component semantic versions.</p> <note>   <p>The semantic version has four nodes: <major>    .    <minor>     .     <patch>      /      <build>       . You can assign values for the first three, and can filter on all of them.      </build>     </patch>    </minor>   </major></p>  </note>
    ///   - [`next_token(Option<String>)`](crate::output::ListComponentsOutput::next_token): <p>The next token used for paginated responses. When this is not empty, there are additional elements that the service has not included in this request. Use this token with the next request to retrieve additional objects.</p>
    /// - On failure, responds with [`SdkError<ListComponentsError>`](crate::error::ListComponentsError)
    pub fn list_components(&self) -> fluent_builders::ListComponents {
        fluent_builders::ListComponents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListContainerRecipes`](crate::client::fluent_builders::ListContainerRecipes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListContainerRecipes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`owner(Ownership)`](crate::client::fluent_builders::ListContainerRecipes::owner) / [`set_owner(Option<Ownership>)`](crate::client::fluent_builders::ListContainerRecipes::set_owner): <p>Returns container recipes belonging to the specified owner, that have been shared with you. You can omit this field to return container recipes belonging to your account.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::ListContainerRecipes::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::ListContainerRecipes::set_filters): <p>Use the following filters to streamline results:</p>  <ul>   <li> <p> <code>containerType</code> </p> </li>   <li> <p> <code>name</code> </p> </li>   <li> <p> <code>parentImage</code> </p> </li>   <li> <p> <code>platform</code> </p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListContainerRecipes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListContainerRecipes::set_max_results): <p>The maximum number of results to return in the list.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListContainerRecipes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListContainerRecipes::set_next_token): <p>Provides a token for pagination, which determines where to begin the next set of results when the current set reaches the maximum for one request.</p>
    /// - On success, responds with [`ListContainerRecipesOutput`](crate::output::ListContainerRecipesOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::ListContainerRecipesOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`container_recipe_summary_list(Option<Vec<ContainerRecipeSummary>>)`](crate::output::ListContainerRecipesOutput::container_recipe_summary_list): <p>The list of container recipes returned for the request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListContainerRecipesOutput::next_token): <p>The next token field is used for paginated responses. When this is not empty, there are additional container recipes that the service has not included in this response. Use this token with the next request to retrieve additional list items.</p>
    /// - On failure, responds with [`SdkError<ListContainerRecipesError>`](crate::error::ListContainerRecipesError)
    pub fn list_container_recipes(&self) -> fluent_builders::ListContainerRecipes {
        fluent_builders::ListContainerRecipes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDistributionConfigurations`](crate::client::fluent_builders::ListDistributionConfigurations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDistributionConfigurations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::ListDistributionConfigurations::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::ListDistributionConfigurations::set_filters): <p>You can filter on <code>name</code> to streamline results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDistributionConfigurations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDistributionConfigurations::set_max_results): <p>The maximum items to return in a request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDistributionConfigurations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDistributionConfigurations::set_next_token): <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    /// - On success, responds with [`ListDistributionConfigurationsOutput`](crate::output::ListDistributionConfigurationsOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::ListDistributionConfigurationsOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`distribution_configuration_summary_list(Option<Vec<DistributionConfigurationSummary>>)`](crate::output::ListDistributionConfigurationsOutput::distribution_configuration_summary_list): <p>The list of distributions.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDistributionConfigurationsOutput::next_token): <p>The next token used for paginated responses. When this is not empty, there are additional elements that the service has not included in this request. Use this token with the next request to retrieve additional objects.</p>
    /// - On failure, responds with [`SdkError<ListDistributionConfigurationsError>`](crate::error::ListDistributionConfigurationsError)
    pub fn list_distribution_configurations(
        &self,
    ) -> fluent_builders::ListDistributionConfigurations {
        fluent_builders::ListDistributionConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListImageBuildVersions`](crate::client::fluent_builders::ListImageBuildVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListImageBuildVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`image_version_arn(impl Into<String>)`](crate::client::fluent_builders::ListImageBuildVersions::image_version_arn) / [`set_image_version_arn(Option<String>)`](crate::client::fluent_builders::ListImageBuildVersions::set_image_version_arn): <p>The Amazon Resource Name (ARN) of the image whose build versions you want to retrieve.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::ListImageBuildVersions::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::ListImageBuildVersions::set_filters): <p>Use the following filters to streamline results:</p>  <ul>   <li> <p> <code>name</code> </p> </li>   <li> <p> <code>osVersion</code> </p> </li>   <li> <p> <code>platform</code> </p> </li>   <li> <p> <code>type</code> </p> </li>   <li> <p> <code>version</code> </p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListImageBuildVersions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListImageBuildVersions::set_max_results): <p>The maximum items to return in a request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListImageBuildVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListImageBuildVersions::set_next_token): <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    /// - On success, responds with [`ListImageBuildVersionsOutput`](crate::output::ListImageBuildVersionsOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::ListImageBuildVersionsOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`image_summary_list(Option<Vec<ImageSummary>>)`](crate::output::ListImageBuildVersionsOutput::image_summary_list): <p>The list of image build versions.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListImageBuildVersionsOutput::next_token): <p>The next token used for paginated responses. When this is not empty, there are additional elements that the service has not included in this request. Use this token with the next request to retrieve additional objects.</p>
    /// - On failure, responds with [`SdkError<ListImageBuildVersionsError>`](crate::error::ListImageBuildVersionsError)
    pub fn list_image_build_versions(&self) -> fluent_builders::ListImageBuildVersions {
        fluent_builders::ListImageBuildVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListImagePackages`](crate::client::fluent_builders::ListImagePackages) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListImagePackages::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`image_build_version_arn(impl Into<String>)`](crate::client::fluent_builders::ListImagePackages::image_build_version_arn) / [`set_image_build_version_arn(Option<String>)`](crate::client::fluent_builders::ListImagePackages::set_image_build_version_arn): <p>Filter results for the ListImagePackages request by the Image Build Version ARN</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListImagePackages::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListImagePackages::set_max_results): <p>The maxiumum number of results to return from the ListImagePackages request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListImagePackages::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListImagePackages::set_next_token): <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    /// - On success, responds with [`ListImagePackagesOutput`](crate::output::ListImagePackagesOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::ListImagePackagesOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`image_package_list(Option<Vec<ImagePackage>>)`](crate::output::ListImagePackagesOutput::image_package_list): <p>The list of Image Packages returned in the response.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListImagePackagesOutput::next_token): <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    /// - On failure, responds with [`SdkError<ListImagePackagesError>`](crate::error::ListImagePackagesError)
    pub fn list_image_packages(&self) -> fluent_builders::ListImagePackages {
        fluent_builders::ListImagePackages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListImagePipelineImages`](crate::client::fluent_builders::ListImagePipelineImages) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListImagePipelineImages::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`image_pipeline_arn(impl Into<String>)`](crate::client::fluent_builders::ListImagePipelineImages::image_pipeline_arn) / [`set_image_pipeline_arn(Option<String>)`](crate::client::fluent_builders::ListImagePipelineImages::set_image_pipeline_arn): <p>The Amazon Resource Name (ARN) of the image pipeline whose images you want to view.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::ListImagePipelineImages::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::ListImagePipelineImages::set_filters): <p>Use the following filters to streamline results:</p>  <ul>   <li> <p> <code>name</code> </p> </li>   <li> <p> <code>version</code> </p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListImagePipelineImages::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListImagePipelineImages::set_max_results): <p>The maximum items to return in a request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListImagePipelineImages::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListImagePipelineImages::set_next_token): <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    /// - On success, responds with [`ListImagePipelineImagesOutput`](crate::output::ListImagePipelineImagesOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::ListImagePipelineImagesOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`image_summary_list(Option<Vec<ImageSummary>>)`](crate::output::ListImagePipelineImagesOutput::image_summary_list): <p>The list of images built by this pipeline.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListImagePipelineImagesOutput::next_token): <p>The next token used for paginated responses. When this is not empty, there are additional elements that the service has not included in this request. Use this token with the next request to retrieve additional objects.</p>
    /// - On failure, responds with [`SdkError<ListImagePipelineImagesError>`](crate::error::ListImagePipelineImagesError)
    pub fn list_image_pipeline_images(&self) -> fluent_builders::ListImagePipelineImages {
        fluent_builders::ListImagePipelineImages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListImagePipelines`](crate::client::fluent_builders::ListImagePipelines) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListImagePipelines::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::ListImagePipelines::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::ListImagePipelines::set_filters): <p>Use the following filters to streamline results:</p>  <ul>   <li> <p> <code>description</code> </p> </li>   <li> <p> <code>distributionConfigurationArn</code> </p> </li>   <li> <p> <code>imageRecipeArn</code> </p> </li>   <li> <p> <code>infrastructureConfigurationArn</code> </p> </li>   <li> <p> <code>name</code> </p> </li>   <li> <p> <code>status</code> </p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListImagePipelines::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListImagePipelines::set_max_results): <p>The maximum items to return in a request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListImagePipelines::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListImagePipelines::set_next_token): <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    /// - On success, responds with [`ListImagePipelinesOutput`](crate::output::ListImagePipelinesOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::ListImagePipelinesOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`image_pipeline_list(Option<Vec<ImagePipeline>>)`](crate::output::ListImagePipelinesOutput::image_pipeline_list): <p>The list of image pipelines.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListImagePipelinesOutput::next_token): <p>The next token used for paginated responses. When this is not empty, there are additional elements that the service has not included in this request. Use this token with the next request to retrieve additional objects.</p>
    /// - On failure, responds with [`SdkError<ListImagePipelinesError>`](crate::error::ListImagePipelinesError)
    pub fn list_image_pipelines(&self) -> fluent_builders::ListImagePipelines {
        fluent_builders::ListImagePipelines::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListImageRecipes`](crate::client::fluent_builders::ListImageRecipes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListImageRecipes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`owner(Ownership)`](crate::client::fluent_builders::ListImageRecipes::owner) / [`set_owner(Option<Ownership>)`](crate::client::fluent_builders::ListImageRecipes::set_owner): <p>The owner defines which image recipes you want to list. By default, this request will only show image recipes owned by your account. You can use this field to specify if you want to view image recipes owned by yourself, by Amazon, or those image recipes that have been shared with you by other customers.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::ListImageRecipes::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::ListImageRecipes::set_filters): <p>Use the following filters to streamline results:</p>  <ul>   <li> <p> <code>name</code> </p> </li>   <li> <p> <code>parentImage</code> </p> </li>   <li> <p> <code>platform</code> </p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListImageRecipes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListImageRecipes::set_max_results): <p>The maximum items to return in a request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListImageRecipes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListImageRecipes::set_next_token): <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    /// - On success, responds with [`ListImageRecipesOutput`](crate::output::ListImageRecipesOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::ListImageRecipesOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`image_recipe_summary_list(Option<Vec<ImageRecipeSummary>>)`](crate::output::ListImageRecipesOutput::image_recipe_summary_list): <p>The list of image pipelines.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListImageRecipesOutput::next_token): <p>The next token used for paginated responses. When this is not empty, there are additional elements that the service has not included in this request. Use this token with the next request to retrieve additional objects.</p>
    /// - On failure, responds with [`SdkError<ListImageRecipesError>`](crate::error::ListImageRecipesError)
    pub fn list_image_recipes(&self) -> fluent_builders::ListImageRecipes {
        fluent_builders::ListImageRecipes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListImages`](crate::client::fluent_builders::ListImages) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListImages::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`owner(Ownership)`](crate::client::fluent_builders::ListImages::owner) / [`set_owner(Option<Ownership>)`](crate::client::fluent_builders::ListImages::set_owner): <p>The owner defines which images you want to list. By default, this request will only show images owned by your account. You can use this field to specify if you want to view images owned by yourself, by Amazon, or those images that have been shared with you by other customers.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::ListImages::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::ListImages::set_filters): <p>Use the following filters to streamline results:</p>  <ul>   <li> <p> <code>name</code> </p> </li>   <li> <p> <code>osVersion</code> </p> </li>   <li> <p> <code>platform</code> </p> </li>   <li> <p> <code>type</code> </p> </li>   <li> <p> <code>version</code> </p> </li>  </ul>
    ///   - [`by_name(bool)`](crate::client::fluent_builders::ListImages::by_name) / [`set_by_name(bool)`](crate::client::fluent_builders::ListImages::set_by_name): <p>Requests a list of images with a specific recipe name.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListImages::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListImages::set_max_results): <p>The maximum items to return in a request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListImages::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListImages::set_next_token): <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    ///   - [`include_deprecated(bool)`](crate::client::fluent_builders::ListImages::include_deprecated) / [`set_include_deprecated(Option<bool>)`](crate::client::fluent_builders::ListImages::set_include_deprecated): <p>Includes deprecated images in the response list.</p>
    /// - On success, responds with [`ListImagesOutput`](crate::output::ListImagesOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::ListImagesOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`image_version_list(Option<Vec<ImageVersion>>)`](crate::output::ListImagesOutput::image_version_list): <p>The list of image semantic versions.</p> <note>   <p>The semantic version has four nodes: <major>    .    <minor>     .     <patch>      /      <build>       . You can assign values for the first three, and can filter on all of them.      </build>     </patch>    </minor>   </major></p>   <p> <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.</p>  </note>
    ///   - [`next_token(Option<String>)`](crate::output::ListImagesOutput::next_token): <p>The next token used for paginated responses. When this is not empty, there are additional elements that the service has not included in this request. Use this token with the next request to retrieve additional objects.</p>
    /// - On failure, responds with [`SdkError<ListImagesError>`](crate::error::ListImagesError)
    pub fn list_images(&self) -> fluent_builders::ListImages {
        fluent_builders::ListImages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListInfrastructureConfigurations`](crate::client::fluent_builders::ListInfrastructureConfigurations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListInfrastructureConfigurations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::ListInfrastructureConfigurations::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::ListInfrastructureConfigurations::set_filters): <p>You can filter on <code>name</code> to streamline results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListInfrastructureConfigurations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListInfrastructureConfigurations::set_max_results): <p>The maximum items to return in a request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListInfrastructureConfigurations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListInfrastructureConfigurations::set_next_token): <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    /// - On success, responds with [`ListInfrastructureConfigurationsOutput`](crate::output::ListInfrastructureConfigurationsOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::ListInfrastructureConfigurationsOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`infrastructure_configuration_summary_list(Option<Vec<InfrastructureConfigurationSummary>>)`](crate::output::ListInfrastructureConfigurationsOutput::infrastructure_configuration_summary_list): <p>The list of infrastructure configurations.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListInfrastructureConfigurationsOutput::next_token): <p>The next token used for paginated responses. When this is not empty, there are additional elements that the service has not included in this request. Use this token with the next request to retrieve additional objects.</p>
    /// - On failure, responds with [`SdkError<ListInfrastructureConfigurationsError>`](crate::error::ListInfrastructureConfigurationsError)
    pub fn list_infrastructure_configurations(
        &self,
    ) -> fluent_builders::ListInfrastructureConfigurations {
        fluent_builders::ListInfrastructureConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource whose tags you want to retrieve.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags for the specified resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutComponentPolicy`](crate::client::fluent_builders::PutComponentPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`component_arn(impl Into<String>)`](crate::client::fluent_builders::PutComponentPolicy::component_arn) / [`set_component_arn(Option<String>)`](crate::client::fluent_builders::PutComponentPolicy::set_component_arn): <p>The Amazon Resource Name (ARN) of the component that this policy should be applied to.</p>
    ///   - [`policy(impl Into<String>)`](crate::client::fluent_builders::PutComponentPolicy::policy) / [`set_policy(Option<String>)`](crate::client::fluent_builders::PutComponentPolicy::set_policy): <p>The policy to apply.</p>
    /// - On success, responds with [`PutComponentPolicyOutput`](crate::output::PutComponentPolicyOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::PutComponentPolicyOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`component_arn(Option<String>)`](crate::output::PutComponentPolicyOutput::component_arn): <p>The Amazon Resource Name (ARN) of the component that this policy was applied to.</p>
    /// - On failure, responds with [`SdkError<PutComponentPolicyError>`](crate::error::PutComponentPolicyError)
    pub fn put_component_policy(&self) -> fluent_builders::PutComponentPolicy {
        fluent_builders::PutComponentPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutContainerRecipePolicy`](crate::client::fluent_builders::PutContainerRecipePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`container_recipe_arn(impl Into<String>)`](crate::client::fluent_builders::PutContainerRecipePolicy::container_recipe_arn) / [`set_container_recipe_arn(Option<String>)`](crate::client::fluent_builders::PutContainerRecipePolicy::set_container_recipe_arn): <p>The Amazon Resource Name (ARN) of the container recipe that this policy should be applied to.</p>
    ///   - [`policy(impl Into<String>)`](crate::client::fluent_builders::PutContainerRecipePolicy::policy) / [`set_policy(Option<String>)`](crate::client::fluent_builders::PutContainerRecipePolicy::set_policy): <p>The policy to apply to the container recipe.</p>
    /// - On success, responds with [`PutContainerRecipePolicyOutput`](crate::output::PutContainerRecipePolicyOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::PutContainerRecipePolicyOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`container_recipe_arn(Option<String>)`](crate::output::PutContainerRecipePolicyOutput::container_recipe_arn): <p>The Amazon Resource Name (ARN) of the container recipe that this policy was applied to.</p>
    /// - On failure, responds with [`SdkError<PutContainerRecipePolicyError>`](crate::error::PutContainerRecipePolicyError)
    pub fn put_container_recipe_policy(&self) -> fluent_builders::PutContainerRecipePolicy {
        fluent_builders::PutContainerRecipePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutImagePolicy`](crate::client::fluent_builders::PutImagePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`image_arn(impl Into<String>)`](crate::client::fluent_builders::PutImagePolicy::image_arn) / [`set_image_arn(Option<String>)`](crate::client::fluent_builders::PutImagePolicy::set_image_arn): <p>The Amazon Resource Name (ARN) of the image that this policy should be applied to.</p>
    ///   - [`policy(impl Into<String>)`](crate::client::fluent_builders::PutImagePolicy::policy) / [`set_policy(Option<String>)`](crate::client::fluent_builders::PutImagePolicy::set_policy): <p>The policy to apply.</p>
    /// - On success, responds with [`PutImagePolicyOutput`](crate::output::PutImagePolicyOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::PutImagePolicyOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`image_arn(Option<String>)`](crate::output::PutImagePolicyOutput::image_arn): <p>The Amazon Resource Name (ARN) of the image that this policy was applied to.</p>
    /// - On failure, responds with [`SdkError<PutImagePolicyError>`](crate::error::PutImagePolicyError)
    pub fn put_image_policy(&self) -> fluent_builders::PutImagePolicy {
        fluent_builders::PutImagePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutImageRecipePolicy`](crate::client::fluent_builders::PutImageRecipePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`image_recipe_arn(impl Into<String>)`](crate::client::fluent_builders::PutImageRecipePolicy::image_recipe_arn) / [`set_image_recipe_arn(Option<String>)`](crate::client::fluent_builders::PutImageRecipePolicy::set_image_recipe_arn): <p>The Amazon Resource Name (ARN) of the image recipe that this policy should be applied to.</p>
    ///   - [`policy(impl Into<String>)`](crate::client::fluent_builders::PutImageRecipePolicy::policy) / [`set_policy(Option<String>)`](crate::client::fluent_builders::PutImageRecipePolicy::set_policy): <p>The policy to apply.</p>
    /// - On success, responds with [`PutImageRecipePolicyOutput`](crate::output::PutImageRecipePolicyOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::PutImageRecipePolicyOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`image_recipe_arn(Option<String>)`](crate::output::PutImageRecipePolicyOutput::image_recipe_arn): <p>The Amazon Resource Name (ARN) of the image recipe that this policy was applied to.</p>
    /// - On failure, responds with [`SdkError<PutImageRecipePolicyError>`](crate::error::PutImageRecipePolicyError)
    pub fn put_image_recipe_policy(&self) -> fluent_builders::PutImageRecipePolicy {
        fluent_builders::PutImageRecipePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartImagePipelineExecution`](crate::client::fluent_builders::StartImagePipelineExecution) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`image_pipeline_arn(impl Into<String>)`](crate::client::fluent_builders::StartImagePipelineExecution::image_pipeline_arn) / [`set_image_pipeline_arn(Option<String>)`](crate::client::fluent_builders::StartImagePipelineExecution::set_image_pipeline_arn): <p>The Amazon Resource Name (ARN) of the image pipeline that you want to manually invoke.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::StartImagePipelineExecution::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::StartImagePipelineExecution::set_client_token): <p>The idempotency token used to make this request idempotent.</p>
    /// - On success, responds with [`StartImagePipelineExecutionOutput`](crate::output::StartImagePipelineExecutionOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::StartImagePipelineExecutionOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`client_token(Option<String>)`](crate::output::StartImagePipelineExecutionOutput::client_token): <p>The idempotency token used to make this request idempotent.</p>
    ///   - [`image_build_version_arn(Option<String>)`](crate::output::StartImagePipelineExecutionOutput::image_build_version_arn): <p>The Amazon Resource Name (ARN) of the image that was created by this request.</p>
    /// - On failure, responds with [`SdkError<StartImagePipelineExecutionError>`](crate::error::StartImagePipelineExecutionError)
    pub fn start_image_pipeline_execution(&self) -> fluent_builders::StartImagePipelineExecution {
        fluent_builders::StartImagePipelineExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource that you want to tag.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags to apply to the resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource that you want to untag.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The tag keys to remove from the resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDistributionConfiguration`](crate::client::fluent_builders::UpdateDistributionConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`distribution_configuration_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateDistributionConfiguration::distribution_configuration_arn) / [`set_distribution_configuration_arn(Option<String>)`](crate::client::fluent_builders::UpdateDistributionConfiguration::set_distribution_configuration_arn): <p>The Amazon Resource Name (ARN) of the distribution configuration that you want to update.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateDistributionConfiguration::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateDistributionConfiguration::set_description): <p>The description of the distribution configuration.</p>
    ///   - [`distributions(Vec<Distribution>)`](crate::client::fluent_builders::UpdateDistributionConfiguration::distributions) / [`set_distributions(Option<Vec<Distribution>>)`](crate::client::fluent_builders::UpdateDistributionConfiguration::set_distributions): <p>The distributions of the distribution configuration.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateDistributionConfiguration::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateDistributionConfiguration::set_client_token): <p>The idempotency token of the distribution configuration.</p>
    /// - On success, responds with [`UpdateDistributionConfigurationOutput`](crate::output::UpdateDistributionConfigurationOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::UpdateDistributionConfigurationOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`client_token(Option<String>)`](crate::output::UpdateDistributionConfigurationOutput::client_token): <p>The idempotency token used to make this request idempotent.</p>
    ///   - [`distribution_configuration_arn(Option<String>)`](crate::output::UpdateDistributionConfigurationOutput::distribution_configuration_arn): <p>The Amazon Resource Name (ARN) of the distribution configuration that was updated by this request.</p>
    /// - On failure, responds with [`SdkError<UpdateDistributionConfigurationError>`](crate::error::UpdateDistributionConfigurationError)
    pub fn update_distribution_configuration(
        &self,
    ) -> fluent_builders::UpdateDistributionConfiguration {
        fluent_builders::UpdateDistributionConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateImagePipeline`](crate::client::fluent_builders::UpdateImagePipeline) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`image_pipeline_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateImagePipeline::image_pipeline_arn) / [`set_image_pipeline_arn(Option<String>)`](crate::client::fluent_builders::UpdateImagePipeline::set_image_pipeline_arn): <p>The Amazon Resource Name (ARN) of the image pipeline that you want to update.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateImagePipeline::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateImagePipeline::set_description): <p>The description of the image pipeline.</p>
    ///   - [`image_recipe_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateImagePipeline::image_recipe_arn) / [`set_image_recipe_arn(Option<String>)`](crate::client::fluent_builders::UpdateImagePipeline::set_image_recipe_arn): <p>The Amazon Resource Name (ARN) of the image recipe that will be used to configure images updated by this image pipeline.</p>
    ///   - [`container_recipe_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateImagePipeline::container_recipe_arn) / [`set_container_recipe_arn(Option<String>)`](crate::client::fluent_builders::UpdateImagePipeline::set_container_recipe_arn): <p>The Amazon Resource Name (ARN) of the container pipeline to update.</p>
    ///   - [`infrastructure_configuration_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateImagePipeline::infrastructure_configuration_arn) / [`set_infrastructure_configuration_arn(Option<String>)`](crate::client::fluent_builders::UpdateImagePipeline::set_infrastructure_configuration_arn): <p>The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to build images updated by this image pipeline.</p>
    ///   - [`distribution_configuration_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateImagePipeline::distribution_configuration_arn) / [`set_distribution_configuration_arn(Option<String>)`](crate::client::fluent_builders::UpdateImagePipeline::set_distribution_configuration_arn): <p>The Amazon Resource Name (ARN) of the distribution configuration that will be used to configure and distribute images updated by this image pipeline.</p>
    ///   - [`image_tests_configuration(ImageTestsConfiguration)`](crate::client::fluent_builders::UpdateImagePipeline::image_tests_configuration) / [`set_image_tests_configuration(Option<ImageTestsConfiguration>)`](crate::client::fluent_builders::UpdateImagePipeline::set_image_tests_configuration): <p>The image test configuration of the image pipeline.</p>
    ///   - [`enhanced_image_metadata_enabled(bool)`](crate::client::fluent_builders::UpdateImagePipeline::enhanced_image_metadata_enabled) / [`set_enhanced_image_metadata_enabled(Option<bool>)`](crate::client::fluent_builders::UpdateImagePipeline::set_enhanced_image_metadata_enabled): <p> Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.</p>
    ///   - [`schedule(Schedule)`](crate::client::fluent_builders::UpdateImagePipeline::schedule) / [`set_schedule(Option<Schedule>)`](crate::client::fluent_builders::UpdateImagePipeline::set_schedule): <p>The schedule of the image pipeline.</p>
    ///   - [`status(PipelineStatus)`](crate::client::fluent_builders::UpdateImagePipeline::status) / [`set_status(Option<PipelineStatus>)`](crate::client::fluent_builders::UpdateImagePipeline::set_status): <p>The status of the image pipeline.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateImagePipeline::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateImagePipeline::set_client_token): <p>The idempotency token used to make this request idempotent.</p>
    /// - On success, responds with [`UpdateImagePipelineOutput`](crate::output::UpdateImagePipelineOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::UpdateImagePipelineOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`client_token(Option<String>)`](crate::output::UpdateImagePipelineOutput::client_token): <p>The idempotency token used to make this request idempotent.</p>
    ///   - [`image_pipeline_arn(Option<String>)`](crate::output::UpdateImagePipelineOutput::image_pipeline_arn): <p>The Amazon Resource Name (ARN) of the image pipeline that was updated by this request.</p>
    /// - On failure, responds with [`SdkError<UpdateImagePipelineError>`](crate::error::UpdateImagePipelineError)
    pub fn update_image_pipeline(&self) -> fluent_builders::UpdateImagePipeline {
        fluent_builders::UpdateImagePipeline::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateInfrastructureConfiguration`](crate::client::fluent_builders::UpdateInfrastructureConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`infrastructure_configuration_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateInfrastructureConfiguration::infrastructure_configuration_arn) / [`set_infrastructure_configuration_arn(Option<String>)`](crate::client::fluent_builders::UpdateInfrastructureConfiguration::set_infrastructure_configuration_arn): <p>The Amazon Resource Name (ARN) of the infrastructure configuration that you want to update.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateInfrastructureConfiguration::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateInfrastructureConfiguration::set_description): <p>The description of the infrastructure configuration.</p>
    ///   - [`instance_types(Vec<String>)`](crate::client::fluent_builders::UpdateInfrastructureConfiguration::instance_types) / [`set_instance_types(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateInfrastructureConfiguration::set_instance_types): <p>The instance types of the infrastructure configuration. You can specify one or more instance types to use for this build. The service will pick one of these instance types based on availability.</p>
    ///   - [`instance_profile_name(impl Into<String>)`](crate::client::fluent_builders::UpdateInfrastructureConfiguration::instance_profile_name) / [`set_instance_profile_name(Option<String>)`](crate::client::fluent_builders::UpdateInfrastructureConfiguration::set_instance_profile_name): <p>The instance profile to associate with the instance used to customize your Amazon EC2 AMI.</p>
    ///   - [`security_group_ids(Vec<String>)`](crate::client::fluent_builders::UpdateInfrastructureConfiguration::security_group_ids) / [`set_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateInfrastructureConfiguration::set_security_group_ids): <p>The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.</p>
    ///   - [`subnet_id(impl Into<String>)`](crate::client::fluent_builders::UpdateInfrastructureConfiguration::subnet_id) / [`set_subnet_id(Option<String>)`](crate::client::fluent_builders::UpdateInfrastructureConfiguration::set_subnet_id): <p>The subnet ID to place the instance used to customize your Amazon EC2 AMI in.</p>
    ///   - [`logging(Logging)`](crate::client::fluent_builders::UpdateInfrastructureConfiguration::logging) / [`set_logging(Option<Logging>)`](crate::client::fluent_builders::UpdateInfrastructureConfiguration::set_logging): <p>The logging configuration of the infrastructure configuration.</p>
    ///   - [`key_pair(impl Into<String>)`](crate::client::fluent_builders::UpdateInfrastructureConfiguration::key_pair) / [`set_key_pair(Option<String>)`](crate::client::fluent_builders::UpdateInfrastructureConfiguration::set_key_pair): <p>The key pair of the infrastructure configuration. You can use this to log on to and debug the instance used to create your image.</p>
    ///   - [`terminate_instance_on_failure(bool)`](crate::client::fluent_builders::UpdateInfrastructureConfiguration::terminate_instance_on_failure) / [`set_terminate_instance_on_failure(Option<bool>)`](crate::client::fluent_builders::UpdateInfrastructureConfiguration::set_terminate_instance_on_failure): <p>The terminate instance on failure setting of the infrastructure configuration. Set to false if you want Image Builder to retain the instance used to configure your AMI if the build or test phase of your workflow fails.</p>
    ///   - [`sns_topic_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateInfrastructureConfiguration::sns_topic_arn) / [`set_sns_topic_arn(Option<String>)`](crate::client::fluent_builders::UpdateInfrastructureConfiguration::set_sns_topic_arn): <p>The Amazon Resource Name (ARN) for the SNS topic to which we send image build event notifications.</p> <note>   <p>EC2 Image Builder is unable to send notifications to SNS topics that are encrypted using keys from other accounts. The key that is used to encrypt the SNS topic must reside in the account that the Image Builder service runs under.</p>  </note>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateInfrastructureConfiguration::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateInfrastructureConfiguration::set_client_token): <p>The idempotency token used to make this request idempotent.</p>
    ///   - [`resource_tags(HashMap<String, String>)`](crate::client::fluent_builders::UpdateInfrastructureConfiguration::resource_tags) / [`set_resource_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateInfrastructureConfiguration::set_resource_tags): <p>The tags attached to the resource created by Image Builder.</p>
    ///   - [`instance_metadata_options(InstanceMetadataOptions)`](crate::client::fluent_builders::UpdateInfrastructureConfiguration::instance_metadata_options) / [`set_instance_metadata_options(Option<InstanceMetadataOptions>)`](crate::client::fluent_builders::UpdateInfrastructureConfiguration::set_instance_metadata_options): <p>The instance metadata options that you can set for the HTTP requests that pipeline builds use to launch EC2 build and test instances. For more information about instance metadata options, see one of the following links:</p>  <ul>   <li> <p> <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-options.html">Configure the instance metadata options</a> in the <i> <i>Amazon EC2 User Guide</i> </i> for Linux instances.</p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/configuring-instance-metadata-options.html">Configure the instance metadata options</a> in the <i> <i>Amazon EC2 Windows Guide</i> </i> for Windows instances.</p> </li>  </ul>
    /// - On success, responds with [`UpdateInfrastructureConfigurationOutput`](crate::output::UpdateInfrastructureConfigurationOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::output::UpdateInfrastructureConfigurationOutput::request_id): <p>The request ID that uniquely identifies this request.</p>
    ///   - [`client_token(Option<String>)`](crate::output::UpdateInfrastructureConfigurationOutput::client_token): <p>The idempotency token used to make this request idempotent.</p>
    ///   - [`infrastructure_configuration_arn(Option<String>)`](crate::output::UpdateInfrastructureConfigurationOutput::infrastructure_configuration_arn): <p>The Amazon Resource Name (ARN) of the infrastructure configuration that was updated by this request.</p>
    /// - On failure, responds with [`SdkError<UpdateInfrastructureConfigurationError>`](crate::error::UpdateInfrastructureConfigurationError)
    pub fn update_infrastructure_configuration(
        &self,
    ) -> fluent_builders::UpdateInfrastructureConfiguration {
        fluent_builders::UpdateInfrastructureConfiguration::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CancelImageCreation`.
    ///
    /// <p>CancelImageCreation cancels the creation of Image. This operation can only be used on images in a non-terminal state.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelImageCreation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_image_creation_input::Builder,
    }
    impl CancelImageCreation {
        /// Creates a new `CancelImageCreation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelImageCreationOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelImageCreationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the image whose creation you want to cancel.</p>
        pub fn image_build_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_build_version_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image whose creation you want to cancel.</p>
        pub fn set_image_build_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_build_version_arn(input);
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateComponent`.
    ///
    /// <p>Creates a new component that can be used to build, validate, test, and assess your image. The component is based on a YAML document that you specify using exactly one of the following methods:</p>
    /// <ul>
    /// <li> <p>Inline, using the <code>data</code> property in the request body.</p> </li>
    /// <li> <p>A URL that points to a YAML document file stored in Amazon S3, using the <code>uri</code> property in the request body.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateComponent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_component_input::Builder,
    }
    impl CreateComponent {
        /// Creates a new `CreateComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateComponentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the component.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The semantic version of the component. This version follows the semantic version syntax.</p> <note>
        /// <p>The semantic version has four nodes: <major>
        /// .
        /// <minor>
        /// .
        /// <patch>
        /// /
        /// <build>
        /// . You can assign values for the first three, and can filter on all of them.
        /// </build>
        /// </patch>
        /// </minor>
        /// </major></p>
        /// <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p>
        /// <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p>
        /// </note>
        pub fn semantic_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.semantic_version(input.into());
            self
        }
        /// <p>The semantic version of the component. This version follows the semantic version syntax.</p> <note>
        /// <p>The semantic version has four nodes: <major>
        /// .
        /// <minor>
        /// .
        /// <patch>
        /// /
        /// <build>
        /// . You can assign values for the first three, and can filter on all of them.
        /// </build>
        /// </patch>
        /// </minor>
        /// </major></p>
        /// <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p>
        /// <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p>
        /// </note>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_semantic_version(input);
            self
        }
        /// <p>The description of the component. Describes the contents of the component.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the component. Describes the contents of the component.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The change description of the component. Describes what change has been made in this version, or what makes this version different from other versions of this component.</p>
        pub fn change_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_description(input.into());
            self
        }
        /// <p>The change description of the component. Describes what change has been made in this version, or what makes this version different from other versions of this component.</p>
        pub fn set_change_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_change_description(input);
            self
        }
        /// <p>The platform of the component.</p>
        pub fn platform(mut self, input: crate::model::Platform) -> Self {
            self.inner = self.inner.platform(input);
            self
        }
        /// <p>The platform of the component.</p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.inner = self.inner.set_platform(input);
            self
        }
        /// Appends an item to `supportedOsVersions`.
        ///
        /// To override the contents of this collection use [`set_supported_os_versions`](Self::set_supported_os_versions).
        ///
        /// <p> The operating system (OS) version supported by the component. If the OS information is available, a prefix match is performed against the base image OS version during image recipe creation.</p>
        pub fn supported_os_versions(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.supported_os_versions(input.into());
            self
        }
        /// <p> The operating system (OS) version supported by the component. If the OS information is available, a prefix match is performed against the base image OS version during image recipe creation.</p>
        pub fn set_supported_os_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_supported_os_versions(input);
            self
        }
        /// <p>Component <code>data</code> contains inline YAML document content for the component. Alternatively, you can specify the <code>uri</code> of a YAML document file stored in Amazon S3. However, you cannot specify both properties.</p>
        pub fn data(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data(input.into());
            self
        }
        /// <p>Component <code>data</code> contains inline YAML document content for the component. Alternatively, you can specify the <code>uri</code> of a YAML document file stored in Amazon S3. However, you cannot specify both properties.</p>
        pub fn set_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data(input);
            self
        }
        /// <p>The <code>uri</code> of a YAML component document file. This must be an S3 URL (<code>s3://bucket/key</code>), and the requester must have permission to access the S3 bucket it points to. If you use Amazon S3, you can specify component content up to your service quota.</p>
        /// <p>Alternatively, you can specify the YAML document inline, using the component <code>data</code> property. You cannot specify both properties.</p>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.uri(input.into());
            self
        }
        /// <p>The <code>uri</code> of a YAML component document file. This must be an S3 URL (<code>s3://bucket/key</code>), and the requester must have permission to access the S3 bucket it points to. If you use Amazon S3, you can specify component content up to your service quota.</p>
        /// <p>Alternatively, you can specify the YAML document inline, using the component <code>data</code> property. You cannot specify both properties.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_uri(input);
            self
        }
        /// <p>The ID of the KMS key that should be used to encrypt this component.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The ID of the KMS key that should be used to encrypt this component.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags of the component.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags of the component.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The idempotency token of the component.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The idempotency token of the component.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateContainerRecipe`.
    ///
    /// <p>Creates a new container recipe. Container recipes define how images are configured, tested, and assessed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateContainerRecipe {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_container_recipe_input::Builder,
    }
    impl CreateContainerRecipe {
        /// Creates a new `CreateContainerRecipe`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateContainerRecipeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateContainerRecipeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of container to create.</p>
        pub fn container_type(mut self, input: crate::model::ContainerType) -> Self {
            self.inner = self.inner.container_type(input);
            self
        }
        /// <p>The type of container to create.</p>
        pub fn set_container_type(
            mut self,
            input: std::option::Option<crate::model::ContainerType>,
        ) -> Self {
            self.inner = self.inner.set_container_type(input);
            self
        }
        /// <p>The name of the container recipe.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the container recipe.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the container recipe.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the container recipe.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The semantic version of the container recipe. This version follows the semantic version syntax.</p> <note>
        /// <p>The semantic version has four nodes: <major>
        /// .
        /// <minor>
        /// .
        /// <patch>
        /// /
        /// <build>
        /// . You can assign values for the first three, and can filter on all of them.
        /// </build>
        /// </patch>
        /// </minor>
        /// </major></p>
        /// <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p>
        /// <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p>
        /// </note>
        pub fn semantic_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.semantic_version(input.into());
            self
        }
        /// <p>The semantic version of the container recipe. This version follows the semantic version syntax.</p> <note>
        /// <p>The semantic version has four nodes: <major>
        /// .
        /// <minor>
        /// .
        /// <patch>
        /// /
        /// <build>
        /// . You can assign values for the first three, and can filter on all of them.
        /// </build>
        /// </patch>
        /// </minor>
        /// </major></p>
        /// <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p>
        /// <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p>
        /// </note>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_semantic_version(input);
            self
        }
        /// Appends an item to `components`.
        ///
        /// To override the contents of this collection use [`set_components`](Self::set_components).
        ///
        /// <p>Components for build and test that are included in the container recipe.</p>
        pub fn components(mut self, input: crate::model::ComponentConfiguration) -> Self {
            self.inner = self.inner.components(input);
            self
        }
        /// <p>Components for build and test that are included in the container recipe.</p>
        pub fn set_components(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComponentConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_components(input);
            self
        }
        /// <p>A group of options that can be used to configure an instance for building and testing container images.</p>
        pub fn instance_configuration(
            mut self,
            input: crate::model::InstanceConfiguration,
        ) -> Self {
            self.inner = self.inner.instance_configuration(input);
            self
        }
        /// <p>A group of options that can be used to configure an instance for building and testing container images.</p>
        pub fn set_instance_configuration(
            mut self,
            input: std::option::Option<crate::model::InstanceConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_instance_configuration(input);
            self
        }
        /// <p>The Dockerfile template used to build your image as an inline data blob.</p>
        pub fn dockerfile_template_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dockerfile_template_data(input.into());
            self
        }
        /// <p>The Dockerfile template used to build your image as an inline data blob.</p>
        pub fn set_dockerfile_template_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dockerfile_template_data(input);
            self
        }
        /// <p>The Amazon S3 URI for the Dockerfile that will be used to build your container image.</p>
        pub fn dockerfile_template_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dockerfile_template_uri(input.into());
            self
        }
        /// <p>The Amazon S3 URI for the Dockerfile that will be used to build your container image.</p>
        pub fn set_dockerfile_template_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dockerfile_template_uri(input);
            self
        }
        /// <p>Specifies the operating system platform when you use a custom base image.</p>
        pub fn platform_override(mut self, input: crate::model::Platform) -> Self {
            self.inner = self.inner.platform_override(input);
            self
        }
        /// <p>Specifies the operating system platform when you use a custom base image.</p>
        pub fn set_platform_override(
            mut self,
            input: std::option::Option<crate::model::Platform>,
        ) -> Self {
            self.inner = self.inner.set_platform_override(input);
            self
        }
        /// <p>Specifies the operating system version for the base image.</p>
        pub fn image_os_version_override(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_os_version_override(input.into());
            self
        }
        /// <p>Specifies the operating system version for the base image.</p>
        pub fn set_image_os_version_override(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_os_version_override(input);
            self
        }
        /// <p>The base image for the container recipe.</p>
        pub fn parent_image(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_image(input.into());
            self
        }
        /// <p>The base image for the container recipe.</p>
        pub fn set_parent_image(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_parent_image(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags that are attached to the container recipe.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Tags that are attached to the container recipe.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The working directory for use during build and test workflows.</p>
        pub fn working_directory(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.working_directory(input.into());
            self
        }
        /// <p>The working directory for use during build and test workflows.</p>
        pub fn set_working_directory(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_working_directory(input);
            self
        }
        /// <p>The destination repository for the container image.</p>
        pub fn target_repository(mut self, input: crate::model::TargetContainerRepository) -> Self {
            self.inner = self.inner.target_repository(input);
            self
        }
        /// <p>The destination repository for the container image.</p>
        pub fn set_target_repository(
            mut self,
            input: std::option::Option<crate::model::TargetContainerRepository>,
        ) -> Self {
            self.inner = self.inner.set_target_repository(input);
            self
        }
        /// <p>Identifies which KMS key is used to encrypt the container image.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>Identifies which KMS key is used to encrypt the container image.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>The client token used to make this request idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The client token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDistributionConfiguration`.
    ///
    /// <p>Creates a new distribution configuration. Distribution configurations define and configure the outputs of your pipeline.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDistributionConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_distribution_configuration_input::Builder,
    }
    impl CreateDistributionConfiguration {
        /// Creates a new `CreateDistributionConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDistributionConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDistributionConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the distribution configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p> The name of the distribution configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p> The description of the distribution configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p> The description of the distribution configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `distributions`.
        ///
        /// To override the contents of this collection use [`set_distributions`](Self::set_distributions).
        ///
        /// <p> The distributions of the distribution configuration.</p>
        pub fn distributions(mut self, input: crate::model::Distribution) -> Self {
            self.inner = self.inner.distributions(input);
            self
        }
        /// <p> The distributions of the distribution configuration.</p>
        pub fn set_distributions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Distribution>>,
        ) -> Self {
            self.inner = self.inner.set_distributions(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags of the distribution configuration.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p> The tags of the distribution configuration.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p> The idempotency token of the distribution configuration.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p> The idempotency token of the distribution configuration.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateImage`.
    ///
    /// <p> Creates a new image. This request will create a new image along with all of the configured output resources defined in the distribution configuration. You must specify exactly one recipe for your image, using either a ContainerRecipeArn or an ImageRecipeArn.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateImage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_image_input::Builder,
    }
    impl CreateImage {
        /// Creates a new `CreateImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateImageOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateImageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) of the image recipe that defines how images are configured, tested, and assessed.</p>
        pub fn image_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_recipe_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the image recipe that defines how images are configured, tested, and assessed.</p>
        pub fn set_image_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_recipe_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe that defines how images are configured and tested.</p>
        pub fn container_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_recipe_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe that defines how images are configured and tested.</p>
        pub fn set_container_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_recipe_arn(input);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the distribution configuration that defines and configures the outputs of your pipeline.</p>
        pub fn distribution_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.distribution_configuration_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the distribution configuration that defines and configures the outputs of your pipeline.</p>
        pub fn set_distribution_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_configuration_arn(input);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the infrastructure configuration that defines the environment in which your image will be built and tested.</p>
        pub fn infrastructure_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.infrastructure_configuration_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the infrastructure configuration that defines the environment in which your image will be built and tested.</p>
        pub fn set_infrastructure_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_infrastructure_configuration_arn(input);
            self
        }
        /// <p> The image tests configuration of the image.</p>
        pub fn image_tests_configuration(
            mut self,
            input: crate::model::ImageTestsConfiguration,
        ) -> Self {
            self.inner = self.inner.image_tests_configuration(input);
            self
        }
        /// <p> The image tests configuration of the image.</p>
        pub fn set_image_tests_configuration(
            mut self,
            input: std::option::Option<crate::model::ImageTestsConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_image_tests_configuration(input);
            self
        }
        /// <p> Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.</p>
        pub fn enhanced_image_metadata_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.enhanced_image_metadata_enabled(input);
            self
        }
        /// <p> Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.</p>
        pub fn set_enhanced_image_metadata_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enhanced_image_metadata_enabled(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags of the image.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p> The tags of the image.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p> The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p> The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateImagePipeline`.
    ///
    /// <p> Creates a new image pipeline. Image pipelines enable you to automate the creation and distribution of images.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateImagePipeline {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_image_pipeline_input::Builder,
    }
    impl CreateImagePipeline {
        /// Creates a new `CreateImagePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateImagePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateImagePipelineError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the image pipeline.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p> The name of the image pipeline.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p> The description of the image pipeline.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p> The description of the image pipeline.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the image recipe that will be used to configure images created by this image pipeline.</p>
        pub fn image_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_recipe_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the image recipe that will be used to configure images created by this image pipeline.</p>
        pub fn set_image_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_recipe_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe that is used to configure images created by this container pipeline.</p>
        pub fn container_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_recipe_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe that is used to configure images created by this container pipeline.</p>
        pub fn set_container_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_recipe_arn(input);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to build images created by this image pipeline.</p>
        pub fn infrastructure_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.infrastructure_configuration_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to build images created by this image pipeline.</p>
        pub fn set_infrastructure_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_infrastructure_configuration_arn(input);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the distribution configuration that will be used to configure and distribute images created by this image pipeline.</p>
        pub fn distribution_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.distribution_configuration_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the distribution configuration that will be used to configure and distribute images created by this image pipeline.</p>
        pub fn set_distribution_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_configuration_arn(input);
            self
        }
        /// <p> The image test configuration of the image pipeline.</p>
        pub fn image_tests_configuration(
            mut self,
            input: crate::model::ImageTestsConfiguration,
        ) -> Self {
            self.inner = self.inner.image_tests_configuration(input);
            self
        }
        /// <p> The image test configuration of the image pipeline.</p>
        pub fn set_image_tests_configuration(
            mut self,
            input: std::option::Option<crate::model::ImageTestsConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_image_tests_configuration(input);
            self
        }
        /// <p> Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.</p>
        pub fn enhanced_image_metadata_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.enhanced_image_metadata_enabled(input);
            self
        }
        /// <p> Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.</p>
        pub fn set_enhanced_image_metadata_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enhanced_image_metadata_enabled(input);
            self
        }
        /// <p> The schedule of the image pipeline.</p>
        pub fn schedule(mut self, input: crate::model::Schedule) -> Self {
            self.inner = self.inner.schedule(input);
            self
        }
        /// <p> The schedule of the image pipeline.</p>
        pub fn set_schedule(mut self, input: std::option::Option<crate::model::Schedule>) -> Self {
            self.inner = self.inner.set_schedule(input);
            self
        }
        /// <p> The status of the image pipeline.</p>
        pub fn status(mut self, input: crate::model::PipelineStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p> The status of the image pipeline.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PipelineStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags of the image pipeline.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p> The tags of the image pipeline.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p> The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p> The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateImageRecipe`.
    ///
    /// <p> Creates a new image recipe. Image recipes define how images are configured, tested, and assessed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateImageRecipe {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_image_recipe_input::Builder,
    }
    impl CreateImageRecipe {
        /// Creates a new `CreateImageRecipe`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateImageRecipeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateImageRecipeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the image recipe.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p> The name of the image recipe.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p> The description of the image recipe.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p> The description of the image recipe.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The semantic version of the image recipe. This version follows the semantic version syntax.</p> <note>
        /// <p>The semantic version has four nodes: <major>
        /// .
        /// <minor>
        /// .
        /// <patch>
        /// /
        /// <build>
        /// . You can assign values for the first three, and can filter on all of them.
        /// </build>
        /// </patch>
        /// </minor>
        /// </major></p>
        /// <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p>
        /// <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p>
        /// </note>
        pub fn semantic_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.semantic_version(input.into());
            self
        }
        /// <p>The semantic version of the image recipe. This version follows the semantic version syntax.</p> <note>
        /// <p>The semantic version has four nodes: <major>
        /// .
        /// <minor>
        /// .
        /// <patch>
        /// /
        /// <build>
        /// . You can assign values for the first three, and can filter on all of them.
        /// </build>
        /// </patch>
        /// </minor>
        /// </major></p>
        /// <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p>
        /// <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p>
        /// </note>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_semantic_version(input);
            self
        }
        /// Appends an item to `components`.
        ///
        /// To override the contents of this collection use [`set_components`](Self::set_components).
        ///
        /// <p>The components of the image recipe.</p>
        pub fn components(mut self, input: crate::model::ComponentConfiguration) -> Self {
            self.inner = self.inner.components(input);
            self
        }
        /// <p>The components of the image recipe.</p>
        pub fn set_components(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComponentConfiguration>>,
        ) -> Self {
            self.inner = self.inner.set_components(input);
            self
        }
        /// <p>The base image of the image recipe. The value of the string can be the ARN of the base image or an AMI ID. The format for the ARN follows this example: <code>arn:aws:imagebuilder:us-west-2:aws:image/windows-server-2016-english-full-base-x86/x.x.x</code>. You can provide the specific version that you want to use, or you can use a wildcard in all of the fields. If you enter an AMI ID for the string value, you must have access to the AMI, and the AMI must be in the same Region in which you are using Image Builder.</p>
        pub fn parent_image(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_image(input.into());
            self
        }
        /// <p>The base image of the image recipe. The value of the string can be the ARN of the base image or an AMI ID. The format for the ARN follows this example: <code>arn:aws:imagebuilder:us-west-2:aws:image/windows-server-2016-english-full-base-x86/x.x.x</code>. You can provide the specific version that you want to use, or you can use a wildcard in all of the fields. If you enter an AMI ID for the string value, you must have access to the AMI, and the AMI must be in the same Region in which you are using Image Builder.</p>
        pub fn set_parent_image(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_parent_image(input);
            self
        }
        /// Appends an item to `blockDeviceMappings`.
        ///
        /// To override the contents of this collection use [`set_block_device_mappings`](Self::set_block_device_mappings).
        ///
        /// <p>The block device mappings of the image recipe.</p>
        pub fn block_device_mappings(
            mut self,
            input: crate::model::InstanceBlockDeviceMapping,
        ) -> Self {
            self.inner = self.inner.block_device_mappings(input);
            self
        }
        /// <p>The block device mappings of the image recipe.</p>
        pub fn set_block_device_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceBlockDeviceMapping>>,
        ) -> Self {
            self.inner = self.inner.set_block_device_mappings(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags of the image recipe.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p> The tags of the image recipe.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The working directory used during build and test workflows.</p>
        pub fn working_directory(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.working_directory(input.into());
            self
        }
        /// <p>The working directory used during build and test workflows.</p>
        pub fn set_working_directory(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_working_directory(input);
            self
        }
        /// <p>Specify additional settings and launch scripts for your build instances.</p>
        pub fn additional_instance_configuration(
            mut self,
            input: crate::model::AdditionalInstanceConfiguration,
        ) -> Self {
            self.inner = self.inner.additional_instance_configuration(input);
            self
        }
        /// <p>Specify additional settings and launch scripts for your build instances.</p>
        pub fn set_additional_instance_configuration(
            mut self,
            input: std::option::Option<crate::model::AdditionalInstanceConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_additional_instance_configuration(input);
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateInfrastructureConfiguration`.
    ///
    /// <p> Creates a new infrastructure configuration. An infrastructure configuration defines the environment in which your image will be built and tested.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateInfrastructureConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_infrastructure_configuration_input::Builder,
    }
    impl CreateInfrastructureConfiguration {
        /// Creates a new `CreateInfrastructureConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateInfrastructureConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateInfrastructureConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the infrastructure configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the infrastructure configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the infrastructure configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the infrastructure configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `instanceTypes`.
        ///
        /// To override the contents of this collection use [`set_instance_types`](Self::set_instance_types).
        ///
        /// <p>The instance types of the infrastructure configuration. You can specify one or more instance types to use for this build. The service will pick one of these instance types based on availability.</p>
        pub fn instance_types(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_types(input.into());
            self
        }
        /// <p>The instance types of the infrastructure configuration. You can specify one or more instance types to use for this build. The service will pick one of these instance types based on availability.</p>
        pub fn set_instance_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_instance_types(input);
            self
        }
        /// <p>The instance profile to associate with the instance used to customize your Amazon EC2 AMI.</p>
        pub fn instance_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_profile_name(input.into());
            self
        }
        /// <p>The instance profile to associate with the instance used to customize your Amazon EC2 AMI.</p>
        pub fn set_instance_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_profile_name(input);
            self
        }
        /// Appends an item to `securityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_ids(input.into());
            self
        }
        /// <p>The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_ids(input);
            self
        }
        /// <p>The subnet ID in which to place the instance used to customize your Amazon EC2 AMI.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_id(input.into());
            self
        }
        /// <p>The subnet ID in which to place the instance used to customize your Amazon EC2 AMI.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subnet_id(input);
            self
        }
        /// <p>The logging configuration of the infrastructure configuration.</p>
        pub fn logging(mut self, input: crate::model::Logging) -> Self {
            self.inner = self.inner.logging(input);
            self
        }
        /// <p>The logging configuration of the infrastructure configuration.</p>
        pub fn set_logging(mut self, input: std::option::Option<crate::model::Logging>) -> Self {
            self.inner = self.inner.set_logging(input);
            self
        }
        /// <p>The key pair of the infrastructure configuration. You can use this to log on to and debug the instance used to create your image.</p>
        pub fn key_pair(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_pair(input.into());
            self
        }
        /// <p>The key pair of the infrastructure configuration. You can use this to log on to and debug the instance used to create your image.</p>
        pub fn set_key_pair(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_pair(input);
            self
        }
        /// <p>The terminate instance on failure setting of the infrastructure configuration. Set to false if you want Image Builder to retain the instance used to configure your AMI if the build or test phase of your workflow fails.</p>
        pub fn terminate_instance_on_failure(mut self, input: bool) -> Self {
            self.inner = self.inner.terminate_instance_on_failure(input);
            self
        }
        /// <p>The terminate instance on failure setting of the infrastructure configuration. Set to false if you want Image Builder to retain the instance used to configure your AMI if the build or test phase of your workflow fails.</p>
        pub fn set_terminate_instance_on_failure(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_terminate_instance_on_failure(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the SNS topic to which we send image build event notifications.</p> <note>
        /// <p>EC2 Image Builder is unable to send notifications to SNS topics that are encrypted using keys from other accounts. The key that is used to encrypt the SNS topic must reside in the account that the Image Builder service runs under.</p>
        /// </note>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the SNS topic to which we send image build event notifications.</p> <note>
        /// <p>EC2 Image Builder is unable to send notifications to SNS topics that are encrypted using keys from other accounts. The key that is used to encrypt the SNS topic must reside in the account that the Image Builder service runs under.</p>
        /// </note>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_arn(input);
            self
        }
        /// Adds a key-value pair to `resourceTags`.
        ///
        /// To override the contents of this collection use [`set_resource_tags`](Self::set_resource_tags).
        ///
        /// <p>The tags attached to the resource created by Image Builder.</p>
        pub fn resource_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.resource_tags(k.into(), v.into());
            self
        }
        /// <p>The tags attached to the resource created by Image Builder.</p>
        pub fn set_resource_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_resource_tags(input);
            self
        }
        /// <p>The instance metadata options that you can set for the HTTP requests that pipeline builds use to launch EC2 build and test instances.</p>
        pub fn instance_metadata_options(
            mut self,
            input: crate::model::InstanceMetadataOptions,
        ) -> Self {
            self.inner = self.inner.instance_metadata_options(input);
            self
        }
        /// <p>The instance metadata options that you can set for the HTTP requests that pipeline builds use to launch EC2 build and test instances.</p>
        pub fn set_instance_metadata_options(
            mut self,
            input: std::option::Option<crate::model::InstanceMetadataOptions>,
        ) -> Self {
            self.inner = self.inner.set_instance_metadata_options(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags of the infrastructure configuration.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags of the infrastructure configuration.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteComponent`.
    ///
    /// <p> Deletes a component build version.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteComponent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_component_input::Builder,
    }
    impl DeleteComponent {
        /// Creates a new `DeleteComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteComponentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the component build version to delete.</p>
        pub fn component_build_version_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.component_build_version_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the component build version to delete.</p>
        pub fn set_component_build_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_build_version_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteContainerRecipe`.
    ///
    /// <p>Deletes a container recipe.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteContainerRecipe {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_container_recipe_input::Builder,
    }
    impl DeleteContainerRecipe {
        /// Creates a new `DeleteContainerRecipe`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteContainerRecipeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteContainerRecipeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe to delete.</p>
        pub fn container_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_recipe_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe to delete.</p>
        pub fn set_container_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_recipe_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDistributionConfiguration`.
    ///
    /// <p> Deletes a distribution configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDistributionConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_distribution_configuration_input::Builder,
    }
    impl DeleteDistributionConfiguration {
        /// Creates a new `DeleteDistributionConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDistributionConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDistributionConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration to delete.</p>
        pub fn distribution_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.distribution_configuration_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration to delete.</p>
        pub fn set_distribution_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_configuration_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteImage`.
    ///
    /// <p>Deletes an Image Builder image resource. This does not delete any EC2 AMIs or ECR container images that are created during the image build process. You must clean those up separately, using the appropriate Amazon EC2 or Amazon ECR console actions, or API or CLI commands.</p>
    /// <ul>
    /// <li> <p>To deregister an EC2 Linux AMI, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/deregister-ami.html">Deregister your Linux AMI</a> in the <i> <i>Amazon EC2 User Guide</i> </i>.</p> </li>
    /// <li> <p>To deregister an EC2 Windows AMI, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/deregister-ami.html">Deregister your Windows AMI</a> in the <i> <i>Amazon EC2 Windows Guide</i> </i>.</p> </li>
    /// <li> <p>To delete a container image from Amazon ECR, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/delete_image.html">Deleting an image</a> in the <i>Amazon ECR User Guide</i>.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteImage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_image_input::Builder,
    }
    impl DeleteImage {
        /// Creates a new `DeleteImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteImageOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteImageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Image Builder image resource to delete.</p>
        pub fn image_build_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_build_version_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Image Builder image resource to delete.</p>
        pub fn set_image_build_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_build_version_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteImagePipeline`.
    ///
    /// <p> Deletes an image pipeline.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteImagePipeline {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_image_pipeline_input::Builder,
    }
    impl DeleteImagePipeline {
        /// Creates a new `DeleteImagePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteImagePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteImagePipelineError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline to delete.</p>
        pub fn image_pipeline_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_pipeline_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline to delete.</p>
        pub fn set_image_pipeline_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_pipeline_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteImageRecipe`.
    ///
    /// <p> Deletes an image recipe.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteImageRecipe {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_image_recipe_input::Builder,
    }
    impl DeleteImageRecipe {
        /// Creates a new `DeleteImageRecipe`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteImageRecipeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteImageRecipeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe to delete.</p>
        pub fn image_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_recipe_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe to delete.</p>
        pub fn set_image_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_recipe_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteInfrastructureConfiguration`.
    ///
    /// <p> Deletes an infrastructure configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteInfrastructureConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_infrastructure_configuration_input::Builder,
    }
    impl DeleteInfrastructureConfiguration {
        /// Creates a new `DeleteInfrastructureConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInfrastructureConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteInfrastructureConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration to delete.</p>
        pub fn infrastructure_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.infrastructure_configuration_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration to delete.</p>
        pub fn set_infrastructure_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_infrastructure_configuration_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetComponent`.
    ///
    /// <p> Gets a component object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetComponent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_component_input::Builder,
    }
    impl GetComponent {
        /// Creates a new `GetComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetComponentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the component that you want to retrieve. Regex requires "/\d+$" suffix.</p>
        pub fn component_build_version_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.component_build_version_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the component that you want to retrieve. Regex requires "/\d+$" suffix.</p>
        pub fn set_component_build_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_build_version_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetComponentPolicy`.
    ///
    /// <p> Gets a component policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetComponentPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_component_policy_input::Builder,
    }
    impl GetComponentPolicy {
        /// Creates a new `GetComponentPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetComponentPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetComponentPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the component whose policy you want to retrieve.</p>
        pub fn component_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the component whose policy you want to retrieve.</p>
        pub fn set_component_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetContainerRecipe`.
    ///
    /// <p>Retrieves a container recipe.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetContainerRecipe {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_container_recipe_input::Builder,
    }
    impl GetContainerRecipe {
        /// Creates a new `GetContainerRecipe`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContainerRecipeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContainerRecipeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe to retrieve.</p>
        pub fn container_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_recipe_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe to retrieve.</p>
        pub fn set_container_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_recipe_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetContainerRecipePolicy`.
    ///
    /// <p>Retrieves the policy for a container recipe.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetContainerRecipePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_container_recipe_policy_input::Builder,
    }
    impl GetContainerRecipePolicy {
        /// Creates a new `GetContainerRecipePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContainerRecipePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContainerRecipePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe for the policy being requested.</p>
        pub fn container_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_recipe_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe for the policy being requested.</p>
        pub fn set_container_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_recipe_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDistributionConfiguration`.
    ///
    /// <p> Gets a distribution configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDistributionConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_distribution_configuration_input::Builder,
    }
    impl GetDistributionConfiguration {
        /// Creates a new `GetDistributionConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDistributionConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDistributionConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration that you want to retrieve.</p>
        pub fn distribution_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.distribution_configuration_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration that you want to retrieve.</p>
        pub fn set_distribution_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_configuration_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetImage`.
    ///
    /// <p> Gets an image.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetImage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_image_input::Builder,
    }
    impl GetImage {
        /// Creates a new `GetImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetImageOutput,
            aws_smithy_http::result::SdkError<crate::error::GetImageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the image that you want to retrieve.</p>
        pub fn image_build_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_build_version_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image that you want to retrieve.</p>
        pub fn set_image_build_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_build_version_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetImagePipeline`.
    ///
    /// <p> Gets an image pipeline.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetImagePipeline {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_image_pipeline_input::Builder,
    }
    impl GetImagePipeline {
        /// Creates a new `GetImagePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetImagePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::GetImagePipelineError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline that you want to retrieve.</p>
        pub fn image_pipeline_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_pipeline_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline that you want to retrieve.</p>
        pub fn set_image_pipeline_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_pipeline_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetImagePolicy`.
    ///
    /// <p> Gets an image policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetImagePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_image_policy_input::Builder,
    }
    impl GetImagePolicy {
        /// Creates a new `GetImagePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetImagePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetImagePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the image whose policy you want to retrieve.</p>
        pub fn image_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image whose policy you want to retrieve.</p>
        pub fn set_image_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetImageRecipe`.
    ///
    /// <p> Gets an image recipe.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetImageRecipe {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_image_recipe_input::Builder,
    }
    impl GetImageRecipe {
        /// Creates a new `GetImageRecipe`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetImageRecipeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetImageRecipeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe that you want to retrieve.</p>
        pub fn image_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_recipe_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe that you want to retrieve.</p>
        pub fn set_image_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_recipe_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetImageRecipePolicy`.
    ///
    /// <p> Gets an image recipe policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetImageRecipePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_image_recipe_policy_input::Builder,
    }
    impl GetImageRecipePolicy {
        /// Creates a new `GetImageRecipePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetImageRecipePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetImageRecipePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe whose policy you want to retrieve.</p>
        pub fn image_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_recipe_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe whose policy you want to retrieve.</p>
        pub fn set_image_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_recipe_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInfrastructureConfiguration`.
    ///
    /// <p> Gets an infrastructure configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetInfrastructureConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_infrastructure_configuration_input::Builder,
    }
    impl GetInfrastructureConfiguration {
        /// Creates a new `GetInfrastructureConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInfrastructureConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInfrastructureConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that you want to retrieve.</p>
        pub fn infrastructure_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.infrastructure_configuration_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that you want to retrieve.</p>
        pub fn set_infrastructure_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_infrastructure_configuration_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportComponent`.
    ///
    /// <p>Imports a component and transforms its data into a component document.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ImportComponent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::import_component_input::Builder,
    }
    impl ImportComponent {
        /// Creates a new `ImportComponent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportComponentOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportComponentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the component.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p> The name of the component.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The semantic version of the component. This version follows the semantic version syntax.</p> <note>
        /// <p>The semantic version has four nodes: <major>
        /// .
        /// <minor>
        /// .
        /// <patch>
        /// /
        /// <build>
        /// . You can assign values for the first three, and can filter on all of them.
        /// </build>
        /// </patch>
        /// </minor>
        /// </major></p>
        /// <p> <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.</p>
        /// </note>
        pub fn semantic_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.semantic_version(input.into());
            self
        }
        /// <p>The semantic version of the component. This version follows the semantic version syntax.</p> <note>
        /// <p>The semantic version has four nodes: <major>
        /// .
        /// <minor>
        /// .
        /// <patch>
        /// /
        /// <build>
        /// . You can assign values for the first three, and can filter on all of them.
        /// </build>
        /// </patch>
        /// </minor>
        /// </major></p>
        /// <p> <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.</p>
        /// </note>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_semantic_version(input);
            self
        }
        /// <p>The description of the component. Describes the contents of the component.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the component. Describes the contents of the component.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The change description of the component. Describes what change has been made in this version, or what makes this version different from other versions of this component.</p>
        pub fn change_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_description(input.into());
            self
        }
        /// <p>The change description of the component. Describes what change has been made in this version, or what makes this version different from other versions of this component.</p>
        pub fn set_change_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_change_description(input);
            self
        }
        /// <p>The type of the component denotes whether the component is used to build the image, or only to test it.</p>
        pub fn r#type(mut self, input: crate::model::ComponentType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of the component denotes whether the component is used to build the image, or only to test it.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ComponentType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The format of the resource that you want to import as a component.</p>
        pub fn format(mut self, input: crate::model::ComponentFormat) -> Self {
            self.inner = self.inner.format(input);
            self
        }
        /// <p>The format of the resource that you want to import as a component.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::ComponentFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p>The platform of the component.</p>
        pub fn platform(mut self, input: crate::model::Platform) -> Self {
            self.inner = self.inner.platform(input);
            self
        }
        /// <p>The platform of the component.</p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.inner = self.inner.set_platform(input);
            self
        }
        /// <p>The data of the component. Used to specify the data inline. Either <code>data</code> or <code>uri</code> can be used to specify the data within the component.</p>
        pub fn data(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data(input.into());
            self
        }
        /// <p>The data of the component. Used to specify the data inline. Either <code>data</code> or <code>uri</code> can be used to specify the data within the component.</p>
        pub fn set_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data(input);
            self
        }
        /// <p>The uri of the component. Must be an Amazon S3 URL and the requester must have permission to access the Amazon S3 bucket. If you use Amazon S3, you can specify component content up to your service quota. Either <code>data</code> or <code>uri</code> can be used to specify the data within the component.</p>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.uri(input.into());
            self
        }
        /// <p>The uri of the component. Must be an Amazon S3 URL and the requester must have permission to access the Amazon S3 bucket. If you use Amazon S3, you can specify component content up to your service quota. Either <code>data</code> or <code>uri</code> can be used to specify the data within the component.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_uri(input);
            self
        }
        /// <p>The ID of the KMS key that should be used to encrypt this component.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The ID of the KMS key that should be used to encrypt this component.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags of the component.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags of the component.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The idempotency token of the component.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The idempotency token of the component.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportVmImage`.
    ///
    /// <p>When you export your virtual machine (VM) from its virtualization environment, that process creates a set of one or more disk container files that act as snapshots of your VM’s environment, settings, and data. The Amazon EC2 API <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportImage.html">ImportImage</a> action uses those files to import your VM and create an AMI. To import using the CLI command, see <a href="https://docs.aws.amazon.com/cli/latest/reference/ec2/import-image.html">import-image</a> </p>
    /// <p>You can reference the task ID from the VM import to pull in the AMI that the import created as the base image for your Image Builder recipe.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ImportVmImage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::import_vm_image_input::Builder,
    }
    impl ImportVmImage {
        /// Creates a new `ImportVmImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportVmImageOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportVmImageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the base image that is created by the import process.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the base image that is created by the import process.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The semantic version to attach to the base image that was created during the import process. This version follows the semantic version syntax.</p> <note>
        /// <p>The semantic version has four nodes: <major>
        /// .
        /// <minor>
        /// .
        /// <patch>
        /// /
        /// <build>
        /// . You can assign values for the first three, and can filter on all of them.
        /// </build>
        /// </patch>
        /// </minor>
        /// </major></p>
        /// <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p>
        /// <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p>
        /// </note>
        pub fn semantic_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.semantic_version(input.into());
            self
        }
        /// <p>The semantic version to attach to the base image that was created during the import process. This version follows the semantic version syntax.</p> <note>
        /// <p>The semantic version has four nodes: <major>
        /// .
        /// <minor>
        /// .
        /// <patch>
        /// /
        /// <build>
        /// . You can assign values for the first three, and can filter on all of them.
        /// </build>
        /// </patch>
        /// </minor>
        /// </major></p>
        /// <p> <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the build number to the fourth node.</p>
        /// <p> <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or a date, such as 2021.01.01.</p>
        /// </note>
        pub fn set_semantic_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_semantic_version(input);
            self
        }
        /// <p>The description for the base image that is created by the import process.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description for the base image that is created by the import process.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The operating system platform for the imported VM.</p>
        pub fn platform(mut self, input: crate::model::Platform) -> Self {
            self.inner = self.inner.platform(input);
            self
        }
        /// <p>The operating system platform for the imported VM.</p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.inner = self.inner.set_platform(input);
            self
        }
        /// <p>The operating system version for the imported VM.</p>
        pub fn os_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.os_version(input.into());
            self
        }
        /// <p>The operating system version for the imported VM.</p>
        pub fn set_os_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_os_version(input);
            self
        }
        /// <p>The <code>importTaskId</code> (API) or <code>ImportTaskId</code> (CLI) from the Amazon EC2 VM import process. Image Builder retrieves information from the import process to pull in the AMI that is created from the VM source as the base image for your recipe.</p>
        pub fn vm_import_task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vm_import_task_id(input.into());
            self
        }
        /// <p>The <code>importTaskId</code> (API) or <code>ImportTaskId</code> (CLI) from the Amazon EC2 VM import process. Image Builder retrieves information from the import process to pull in the AMI that is created from the VM source as the base image for your recipe.</p>
        pub fn set_vm_import_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vm_import_task_id(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags that are attached to the import resources.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Tags that are attached to the import resources.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon EC2 API Reference</i>.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListComponentBuildVersions`.
    ///
    /// <p> Returns the list of component build versions for the specified semantic version.</p> <note>
    /// <p>The semantic version has four nodes: <major>
    /// .
    /// <minor>
    /// .
    /// <patch>
    /// /
    /// <build>
    /// . You can assign values for the first three, and can filter on all of them.
    /// </build>
    /// </patch>
    /// </minor>
    /// </major></p>
    /// <p> <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListComponentBuildVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_component_build_versions_input::Builder,
    }
    impl ListComponentBuildVersions {
        /// Creates a new `ListComponentBuildVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListComponentBuildVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListComponentBuildVersionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListComponentBuildVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListComponentBuildVersionsPaginator {
            crate::paginator::ListComponentBuildVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The component version Amazon Resource Name (ARN) whose versions you want to list.</p>
        pub fn component_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_version_arn(input.into());
            self
        }
        /// <p>The component version Amazon Resource Name (ARN) whose versions you want to list.</p>
        pub fn set_component_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_version_arn(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListComponents`.
    ///
    /// <p>Returns the list of component build versions for the specified semantic version.</p> <note>
    /// <p>The semantic version has four nodes: <major>
    /// .
    /// <minor>
    /// .
    /// <patch>
    /// /
    /// <build>
    /// . You can assign values for the first three, and can filter on all of them.
    /// </build>
    /// </patch>
    /// </minor>
    /// </major></p>
    /// <p> <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x) to specify the most recent versions or nodes when selecting the base image or components for your recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be wildcards.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListComponents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_components_input::Builder,
    }
    impl ListComponents {
        /// Creates a new `ListComponents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListComponentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListComponentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListComponentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListComponentsPaginator {
            crate::paginator::ListComponentsPaginator::new(self.handle, self.inner)
        }
        /// <p>The owner defines which components you want to list. By default, this request will only show components owned by your account. You can use this field to specify if you want to view components owned by yourself, by Amazon, or those components that have been shared with you by other customers.</p>
        pub fn owner(mut self, input: crate::model::Ownership) -> Self {
            self.inner = self.inner.owner(input);
            self
        }
        /// <p>The owner defines which components you want to list. By default, this request will only show components owned by your account. You can use this field to specify if you want to view components owned by yourself, by Amazon, or those components that have been shared with you by other customers.</p>
        pub fn set_owner(mut self, input: std::option::Option<crate::model::Ownership>) -> Self {
            self.inner = self.inner.set_owner(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li> <p> <code>description</code> </p> </li>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>platform</code> </p> </li>
        /// <li> <p> <code>supportedOsVersion</code> </p> </li>
        /// <li> <p> <code>type</code> </p> </li>
        /// <li> <p> <code>version</code> </p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li> <p> <code>description</code> </p> </li>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>platform</code> </p> </li>
        /// <li> <p> <code>supportedOsVersion</code> </p> </li>
        /// <li> <p> <code>type</code> </p> </li>
        /// <li> <p> <code>version</code> </p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Returns the list of component build versions for the specified name.</p>
        pub fn by_name(mut self, input: bool) -> Self {
            self.inner = self.inner.by_name(input);
            self
        }
        /// <p>Returns the list of component build versions for the specified name.</p>
        pub fn set_by_name(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_by_name(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListContainerRecipes`.
    ///
    /// <p>Returns a list of container recipes.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListContainerRecipes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_container_recipes_input::Builder,
    }
    impl ListContainerRecipes {
        /// Creates a new `ListContainerRecipes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListContainerRecipesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListContainerRecipesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListContainerRecipesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListContainerRecipesPaginator {
            crate::paginator::ListContainerRecipesPaginator::new(self.handle, self.inner)
        }
        /// <p>Returns container recipes belonging to the specified owner, that have been shared with you. You can omit this field to return container recipes belonging to your account.</p>
        pub fn owner(mut self, input: crate::model::Ownership) -> Self {
            self.inner = self.inner.owner(input);
            self
        }
        /// <p>Returns container recipes belonging to the specified owner, that have been shared with you. You can omit this field to return container recipes belonging to your account.</p>
        pub fn set_owner(mut self, input: std::option::Option<crate::model::Ownership>) -> Self {
            self.inner = self.inner.set_owner(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li> <p> <code>containerType</code> </p> </li>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>parentImage</code> </p> </li>
        /// <li> <p> <code>platform</code> </p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li> <p> <code>containerType</code> </p> </li>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>parentImage</code> </p> </li>
        /// <li> <p> <code>platform</code> </p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of results to return in the list.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return in the list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Provides a token for pagination, which determines where to begin the next set of results when the current set reaches the maximum for one request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Provides a token for pagination, which determines where to begin the next set of results when the current set reaches the maximum for one request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDistributionConfigurations`.
    ///
    /// <p>Returns a list of distribution configurations.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDistributionConfigurations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_distribution_configurations_input::Builder,
    }
    impl ListDistributionConfigurations {
        /// Creates a new `ListDistributionConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDistributionConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDistributionConfigurationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDistributionConfigurationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDistributionConfigurationsPaginator {
            crate::paginator::ListDistributionConfigurationsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>You can filter on <code>name</code> to streamline results.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>You can filter on <code>name</code> to streamline results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListImageBuildVersions`.
    ///
    /// <p> Returns a list of image build versions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListImageBuildVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_image_build_versions_input::Builder,
    }
    impl ListImageBuildVersions {
        /// Creates a new `ListImageBuildVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListImageBuildVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListImageBuildVersionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListImageBuildVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListImageBuildVersionsPaginator {
            crate::paginator::ListImageBuildVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the image whose build versions you want to retrieve.</p>
        pub fn image_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_version_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image whose build versions you want to retrieve.</p>
        pub fn set_image_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_version_arn(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>osVersion</code> </p> </li>
        /// <li> <p> <code>platform</code> </p> </li>
        /// <li> <p> <code>type</code> </p> </li>
        /// <li> <p> <code>version</code> </p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>osVersion</code> </p> </li>
        /// <li> <p> <code>platform</code> </p> </li>
        /// <li> <p> <code>type</code> </p> </li>
        /// <li> <p> <code>version</code> </p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListImagePackages`.
    ///
    /// <p>List the Packages that are associated with an Image Build Version, as determined by Amazon Web Services Systems Manager Inventory at build time.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListImagePackages {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_image_packages_input::Builder,
    }
    impl ListImagePackages {
        /// Creates a new `ListImagePackages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListImagePackagesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListImagePackagesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListImagePackagesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListImagePackagesPaginator {
            crate::paginator::ListImagePackagesPaginator::new(self.handle, self.inner)
        }
        /// <p>Filter results for the ListImagePackages request by the Image Build Version ARN</p>
        pub fn image_build_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_build_version_arn(input.into());
            self
        }
        /// <p>Filter results for the ListImagePackages request by the Image Build Version ARN</p>
        pub fn set_image_build_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_build_version_arn(input);
            self
        }
        /// <p>The maxiumum number of results to return from the ListImagePackages request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maxiumum number of results to return from the ListImagePackages request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListImagePipelineImages`.
    ///
    /// <p> Returns a list of images created by the specified pipeline.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListImagePipelineImages {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_image_pipeline_images_input::Builder,
    }
    impl ListImagePipelineImages {
        /// Creates a new `ListImagePipelineImages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListImagePipelineImagesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListImagePipelineImagesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListImagePipelineImagesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListImagePipelineImagesPaginator {
            crate::paginator::ListImagePipelineImagesPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline whose images you want to view.</p>
        pub fn image_pipeline_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_pipeline_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline whose images you want to view.</p>
        pub fn set_image_pipeline_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_pipeline_arn(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>version</code> </p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>version</code> </p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListImagePipelines`.
    ///
    /// <p>Returns a list of image pipelines.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListImagePipelines {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_image_pipelines_input::Builder,
    }
    impl ListImagePipelines {
        /// Creates a new `ListImagePipelines`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListImagePipelinesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListImagePipelinesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListImagePipelinesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListImagePipelinesPaginator {
            crate::paginator::ListImagePipelinesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li> <p> <code>description</code> </p> </li>
        /// <li> <p> <code>distributionConfigurationArn</code> </p> </li>
        /// <li> <p> <code>imageRecipeArn</code> </p> </li>
        /// <li> <p> <code>infrastructureConfigurationArn</code> </p> </li>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>status</code> </p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li> <p> <code>description</code> </p> </li>
        /// <li> <p> <code>distributionConfigurationArn</code> </p> </li>
        /// <li> <p> <code>imageRecipeArn</code> </p> </li>
        /// <li> <p> <code>infrastructureConfigurationArn</code> </p> </li>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>status</code> </p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListImageRecipes`.
    ///
    /// <p> Returns a list of image recipes.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListImageRecipes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_image_recipes_input::Builder,
    }
    impl ListImageRecipes {
        /// Creates a new `ListImageRecipes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListImageRecipesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListImageRecipesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListImageRecipesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListImageRecipesPaginator {
            crate::paginator::ListImageRecipesPaginator::new(self.handle, self.inner)
        }
        /// <p>The owner defines which image recipes you want to list. By default, this request will only show image recipes owned by your account. You can use this field to specify if you want to view image recipes owned by yourself, by Amazon, or those image recipes that have been shared with you by other customers.</p>
        pub fn owner(mut self, input: crate::model::Ownership) -> Self {
            self.inner = self.inner.owner(input);
            self
        }
        /// <p>The owner defines which image recipes you want to list. By default, this request will only show image recipes owned by your account. You can use this field to specify if you want to view image recipes owned by yourself, by Amazon, or those image recipes that have been shared with you by other customers.</p>
        pub fn set_owner(mut self, input: std::option::Option<crate::model::Ownership>) -> Self {
            self.inner = self.inner.set_owner(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>parentImage</code> </p> </li>
        /// <li> <p> <code>platform</code> </p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>parentImage</code> </p> </li>
        /// <li> <p> <code>platform</code> </p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListImages`.
    ///
    /// <p> Returns the list of images that you have access to.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListImages {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_images_input::Builder,
    }
    impl ListImages {
        /// Creates a new `ListImages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListImagesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListImagesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListImagesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListImagesPaginator {
            crate::paginator::ListImagesPaginator::new(self.handle, self.inner)
        }
        /// <p>The owner defines which images you want to list. By default, this request will only show images owned by your account. You can use this field to specify if you want to view images owned by yourself, by Amazon, or those images that have been shared with you by other customers.</p>
        pub fn owner(mut self, input: crate::model::Ownership) -> Self {
            self.inner = self.inner.owner(input);
            self
        }
        /// <p>The owner defines which images you want to list. By default, this request will only show images owned by your account. You can use this field to specify if you want to view images owned by yourself, by Amazon, or those images that have been shared with you by other customers.</p>
        pub fn set_owner(mut self, input: std::option::Option<crate::model::Ownership>) -> Self {
            self.inner = self.inner.set_owner(input);
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>osVersion</code> </p> </li>
        /// <li> <p> <code>platform</code> </p> </li>
        /// <li> <p> <code>type</code> </p> </li>
        /// <li> <p> <code>version</code> </p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Use the following filters to streamline results:</p>
        /// <ul>
        /// <li> <p> <code>name</code> </p> </li>
        /// <li> <p> <code>osVersion</code> </p> </li>
        /// <li> <p> <code>platform</code> </p> </li>
        /// <li> <p> <code>type</code> </p> </li>
        /// <li> <p> <code>version</code> </p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Requests a list of images with a specific recipe name.</p>
        pub fn by_name(mut self, input: bool) -> Self {
            self.inner = self.inner.by_name(input);
            self
        }
        /// <p>Requests a list of images with a specific recipe name.</p>
        pub fn set_by_name(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_by_name(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Includes deprecated images in the response list.</p>
        pub fn include_deprecated(mut self, input: bool) -> Self {
            self.inner = self.inner.include_deprecated(input);
            self
        }
        /// <p>Includes deprecated images in the response list.</p>
        pub fn set_include_deprecated(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_deprecated(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInfrastructureConfigurations`.
    ///
    /// <p> Returns a list of infrastructure configurations.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListInfrastructureConfigurations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_infrastructure_configurations_input::Builder,
    }
    impl ListInfrastructureConfigurations {
        /// Creates a new `ListInfrastructureConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInfrastructureConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInfrastructureConfigurationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListInfrastructureConfigurationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListInfrastructureConfigurationsPaginator {
            crate::paginator::ListInfrastructureConfigurationsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>You can filter on <code>name</code> to streamline results.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>You can filter on <code>name</code> to streamline results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum items to return in a request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p> Returns the list of tags for the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags you want to retrieve.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags you want to retrieve.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutComponentPolicy`.
    ///
    /// <p> Applies a policy to a component. We recommend that you call the RAM API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a> to share resources. If you call the Image Builder API <code>PutComponentPolicy</code>, you must also call the RAM API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html">PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to all principals with whom the resource is shared.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutComponentPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_component_policy_input::Builder,
    }
    impl PutComponentPolicy {
        /// Creates a new `PutComponentPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutComponentPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutComponentPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the component that this policy should be applied to.</p>
        pub fn component_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.component_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the component that this policy should be applied to.</p>
        pub fn set_component_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_component_arn(input);
            self
        }
        /// <p>The policy to apply.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p>The policy to apply.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutContainerRecipePolicy`.
    ///
    /// <p>Applies a policy to a container image. We recommend that you call the RAM API CreateResourceShare (https://docs.aws.amazon.com//ram/latest/APIReference/API_CreateResourceShare.html) to share resources. If you call the Image Builder API <code>PutContainerImagePolicy</code>, you must also call the RAM API PromoteResourceShareCreatedFromPolicy (https://docs.aws.amazon.com//ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html) in order for the resource to be visible to all principals with whom the resource is shared.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutContainerRecipePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_container_recipe_policy_input::Builder,
    }
    impl PutContainerRecipePolicy {
        /// Creates a new `PutContainerRecipePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutContainerRecipePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutContainerRecipePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe that this policy should be applied to.</p>
        pub fn container_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_recipe_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe that this policy should be applied to.</p>
        pub fn set_container_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_recipe_arn(input);
            self
        }
        /// <p>The policy to apply to the container recipe.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p>The policy to apply to the container recipe.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutImagePolicy`.
    ///
    /// <p>Applies a policy to an image. We recommend that you call the RAM API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a> to share resources. If you call the Image Builder API <code>PutImagePolicy</code>, you must also call the RAM API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html">PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to all principals with whom the resource is shared.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutImagePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_image_policy_input::Builder,
    }
    impl PutImagePolicy {
        /// Creates a new `PutImagePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutImagePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutImagePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the image that this policy should be applied to.</p>
        pub fn image_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image that this policy should be applied to.</p>
        pub fn set_image_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_arn(input);
            self
        }
        /// <p>The policy to apply.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p>The policy to apply.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutImageRecipePolicy`.
    ///
    /// <p> Applies a policy to an image recipe. We recommend that you call the RAM API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html">CreateResourceShare</a> to share resources. If you call the Image Builder API <code>PutImageRecipePolicy</code>, you must also call the RAM API <a href="https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html">PromoteResourceShareCreatedFromPolicy</a> in order for the resource to be visible to all principals with whom the resource is shared.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutImageRecipePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_image_recipe_policy_input::Builder,
    }
    impl PutImageRecipePolicy {
        /// Creates a new `PutImageRecipePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutImageRecipePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutImageRecipePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe that this policy should be applied to.</p>
        pub fn image_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_recipe_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe that this policy should be applied to.</p>
        pub fn set_image_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_recipe_arn(input);
            self
        }
        /// <p>The policy to apply.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p>The policy to apply.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartImagePipelineExecution`.
    ///
    /// <p> Manually triggers a pipeline to create an image.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartImagePipelineExecution {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_image_pipeline_execution_input::Builder,
    }
    impl StartImagePipelineExecution {
        /// Creates a new `StartImagePipelineExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartImagePipelineExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartImagePipelineExecutionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline that you want to manually invoke.</p>
        pub fn image_pipeline_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_pipeline_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline that you want to manually invoke.</p>
        pub fn set_image_pipeline_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_pipeline_arn(input);
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p> Adds a tag to a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to tag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to apply to the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to apply to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p> Removes a tag from a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to untag.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to untag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag keys to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDistributionConfiguration`.
    ///
    /// <p> Updates a new distribution configuration. Distribution configurations define and configure the outputs of your pipeline.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDistributionConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_distribution_configuration_input::Builder,
    }
    impl UpdateDistributionConfiguration {
        /// Creates a new `UpdateDistributionConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDistributionConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDistributionConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration that you want to update.</p>
        pub fn distribution_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.distribution_configuration_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration that you want to update.</p>
        pub fn set_distribution_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_configuration_arn(input);
            self
        }
        /// <p>The description of the distribution configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the distribution configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `distributions`.
        ///
        /// To override the contents of this collection use [`set_distributions`](Self::set_distributions).
        ///
        /// <p>The distributions of the distribution configuration.</p>
        pub fn distributions(mut self, input: crate::model::Distribution) -> Self {
            self.inner = self.inner.distributions(input);
            self
        }
        /// <p>The distributions of the distribution configuration.</p>
        pub fn set_distributions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Distribution>>,
        ) -> Self {
            self.inner = self.inner.set_distributions(input);
            self
        }
        /// <p>The idempotency token of the distribution configuration.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The idempotency token of the distribution configuration.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateImagePipeline`.
    ///
    /// <p> Updates an image pipeline. Image pipelines enable you to automate the creation and distribution of images.</p> <note>
    /// <p>UpdateImagePipeline does not support selective updates for the pipeline. You must specify all of the required properties in the update request, not just the properties that have changed.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateImagePipeline {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_image_pipeline_input::Builder,
    }
    impl UpdateImagePipeline {
        /// Creates a new `UpdateImagePipeline`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateImagePipelineOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateImagePipelineError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline that you want to update.</p>
        pub fn image_pipeline_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_pipeline_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline that you want to update.</p>
        pub fn set_image_pipeline_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_pipeline_arn(input);
            self
        }
        /// <p>The description of the image pipeline.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the image pipeline.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe that will be used to configure images updated by this image pipeline.</p>
        pub fn image_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_recipe_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe that will be used to configure images updated by this image pipeline.</p>
        pub fn set_image_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_recipe_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container pipeline to update.</p>
        pub fn container_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_recipe_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container pipeline to update.</p>
        pub fn set_container_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_recipe_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to build images updated by this image pipeline.</p>
        pub fn infrastructure_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.infrastructure_configuration_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that will be used to build images updated by this image pipeline.</p>
        pub fn set_infrastructure_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_infrastructure_configuration_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration that will be used to configure and distribute images updated by this image pipeline.</p>
        pub fn distribution_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.distribution_configuration_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration that will be used to configure and distribute images updated by this image pipeline.</p>
        pub fn set_distribution_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_configuration_arn(input);
            self
        }
        /// <p>The image test configuration of the image pipeline.</p>
        pub fn image_tests_configuration(
            mut self,
            input: crate::model::ImageTestsConfiguration,
        ) -> Self {
            self.inner = self.inner.image_tests_configuration(input);
            self
        }
        /// <p>The image test configuration of the image pipeline.</p>
        pub fn set_image_tests_configuration(
            mut self,
            input: std::option::Option<crate::model::ImageTestsConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_image_tests_configuration(input);
            self
        }
        /// <p> Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.</p>
        pub fn enhanced_image_metadata_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.enhanced_image_metadata_enabled(input);
            self
        }
        /// <p> Collects additional information about the image being created, including the operating system (OS) version and package list. This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.</p>
        pub fn set_enhanced_image_metadata_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enhanced_image_metadata_enabled(input);
            self
        }
        /// <p>The schedule of the image pipeline.</p>
        pub fn schedule(mut self, input: crate::model::Schedule) -> Self {
            self.inner = self.inner.schedule(input);
            self
        }
        /// <p>The schedule of the image pipeline.</p>
        pub fn set_schedule(mut self, input: std::option::Option<crate::model::Schedule>) -> Self {
            self.inner = self.inner.set_schedule(input);
            self
        }
        /// <p>The status of the image pipeline.</p>
        pub fn status(mut self, input: crate::model::PipelineStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The status of the image pipeline.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PipelineStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateInfrastructureConfiguration`.
    ///
    /// <p> Updates a new infrastructure configuration. An infrastructure configuration defines the environment in which your image will be built and tested.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateInfrastructureConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_infrastructure_configuration_input::Builder,
    }
    impl UpdateInfrastructureConfiguration {
        /// Creates a new `UpdateInfrastructureConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateInfrastructureConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateInfrastructureConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that you want to update.</p>
        pub fn infrastructure_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.infrastructure_configuration_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that you want to update.</p>
        pub fn set_infrastructure_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_infrastructure_configuration_arn(input);
            self
        }
        /// <p>The description of the infrastructure configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the infrastructure configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `instanceTypes`.
        ///
        /// To override the contents of this collection use [`set_instance_types`](Self::set_instance_types).
        ///
        /// <p>The instance types of the infrastructure configuration. You can specify one or more instance types to use for this build. The service will pick one of these instance types based on availability.</p>
        pub fn instance_types(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_types(input.into());
            self
        }
        /// <p>The instance types of the infrastructure configuration. You can specify one or more instance types to use for this build. The service will pick one of these instance types based on availability.</p>
        pub fn set_instance_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_instance_types(input);
            self
        }
        /// <p>The instance profile to associate with the instance used to customize your Amazon EC2 AMI.</p>
        pub fn instance_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_profile_name(input.into());
            self
        }
        /// <p>The instance profile to associate with the instance used to customize your Amazon EC2 AMI.</p>
        pub fn set_instance_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_profile_name(input);
            self
        }
        /// Appends an item to `securityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_group_ids(input.into());
            self
        }
        /// <p>The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_group_ids(input);
            self
        }
        /// <p>The subnet ID to place the instance used to customize your Amazon EC2 AMI in.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_id(input.into());
            self
        }
        /// <p>The subnet ID to place the instance used to customize your Amazon EC2 AMI in.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_subnet_id(input);
            self
        }
        /// <p>The logging configuration of the infrastructure configuration.</p>
        pub fn logging(mut self, input: crate::model::Logging) -> Self {
            self.inner = self.inner.logging(input);
            self
        }
        /// <p>The logging configuration of the infrastructure configuration.</p>
        pub fn set_logging(mut self, input: std::option::Option<crate::model::Logging>) -> Self {
            self.inner = self.inner.set_logging(input);
            self
        }
        /// <p>The key pair of the infrastructure configuration. You can use this to log on to and debug the instance used to create your image.</p>
        pub fn key_pair(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_pair(input.into());
            self
        }
        /// <p>The key pair of the infrastructure configuration. You can use this to log on to and debug the instance used to create your image.</p>
        pub fn set_key_pair(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_pair(input);
            self
        }
        /// <p>The terminate instance on failure setting of the infrastructure configuration. Set to false if you want Image Builder to retain the instance used to configure your AMI if the build or test phase of your workflow fails.</p>
        pub fn terminate_instance_on_failure(mut self, input: bool) -> Self {
            self.inner = self.inner.terminate_instance_on_failure(input);
            self
        }
        /// <p>The terminate instance on failure setting of the infrastructure configuration. Set to false if you want Image Builder to retain the instance used to configure your AMI if the build or test phase of your workflow fails.</p>
        pub fn set_terminate_instance_on_failure(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_terminate_instance_on_failure(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the SNS topic to which we send image build event notifications.</p> <note>
        /// <p>EC2 Image Builder is unable to send notifications to SNS topics that are encrypted using keys from other accounts. The key that is used to encrypt the SNS topic must reside in the account that the Image Builder service runs under.</p>
        /// </note>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the SNS topic to which we send image build event notifications.</p> <note>
        /// <p>EC2 Image Builder is unable to send notifications to SNS topics that are encrypted using keys from other accounts. The key that is used to encrypt the SNS topic must reside in the account that the Image Builder service runs under.</p>
        /// </note>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_arn(input);
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `resourceTags`.
        ///
        /// To override the contents of this collection use [`set_resource_tags`](Self::set_resource_tags).
        ///
        /// <p>The tags attached to the resource created by Image Builder.</p>
        pub fn resource_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.resource_tags(k.into(), v.into());
            self
        }
        /// <p>The tags attached to the resource created by Image Builder.</p>
        pub fn set_resource_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_resource_tags(input);
            self
        }
        /// <p>The instance metadata options that you can set for the HTTP requests that pipeline builds use to launch EC2 build and test instances. For more information about instance metadata options, see one of the following links:</p>
        /// <ul>
        /// <li> <p> <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-options.html">Configure the instance metadata options</a> in the <i> <i>Amazon EC2 User Guide</i> </i> for Linux instances.</p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/configuring-instance-metadata-options.html">Configure the instance metadata options</a> in the <i> <i>Amazon EC2 Windows Guide</i> </i> for Windows instances.</p> </li>
        /// </ul>
        pub fn instance_metadata_options(
            mut self,
            input: crate::model::InstanceMetadataOptions,
        ) -> Self {
            self.inner = self.inner.instance_metadata_options(input);
            self
        }
        /// <p>The instance metadata options that you can set for the HTTP requests that pipeline builds use to launch EC2 build and test instances. For more information about instance metadata options, see one of the following links:</p>
        /// <ul>
        /// <li> <p> <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-options.html">Configure the instance metadata options</a> in the <i> <i>Amazon EC2 User Guide</i> </i> for Linux instances.</p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/configuring-instance-metadata-options.html">Configure the instance metadata options</a> in the <i> <i>Amazon EC2 Windows Guide</i> </i> for Windows instances.</p> </li>
        /// </ul>
        pub fn set_instance_metadata_options(
            mut self,
            input: std::option::Option<crate::model::InstanceMetadataOptions>,
        ) -> Self {
            self.inner = self.inner.set_instance_metadata_options(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
