// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>You have exceeded the permitted request rate for the specific operation.</p>
    CallRateLimitExceededException(crate::error::CallRateLimitExceededException),
    /// <p>These errors are usually caused by a client action, such as using an action or resource on
    /// behalf of a user that doesn't have permissions to use the action or resource, or specifying an
    /// invalid resource identifier.</p>
    ClientException(crate::error::ClientException),
    /// <p>You are not authorized to perform the requested operation.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>You have specified a client token for an operation using parameter values that differ from
    /// a previous request that used the same client token.</p>
    IdempotentParameterMismatchException(crate::error::IdempotentParameterMismatchException),
    /// <p>You have provided an invalid pagination token in your request.</p>
    InvalidPaginationTokenException(crate::error::InvalidPaginationTokenException),
    /// <p>You have specified two or more mutually exclusive parameters. Review the error message for
    /// details.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The specified parameter is invalid. Review the available parameters for the API
    /// request.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The value that you provided for the specified parameter is invalid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>You have made a request for an action that is not supported by the service.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Your version number is out of bounds or does not follow the required syntax.</p>
    InvalidVersionNumberException(crate::error::InvalidVersionNumberException),
    /// <p>The resource that you are trying to create already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>You have attempted to mutate or delete a resource with a dependency that prohibits this
    /// action. See the error message for more details.</p>
    ResourceDependencyException(crate::error::ResourceDependencyException),
    /// <p>The resource that you are trying to operate on is currently in use. Review the message
    /// details and retry later.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>At least one of the resources referenced by your request does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>This exception is thrown when the service encounters an unrecoverable exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>You have exceeded the number of permitted resources or operations for this service. For service quotas, see <a href="https://docs.aws.amazon.com/general/latest/gr/imagebuilder.html#limits_imagebuilder">EC2 Image Builder endpoints and quotas</a>.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The service is unable to process your request at this time.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::CallRateLimitExceededException(inner) => inner.fmt(f),
            Error::ClientException(inner) => inner.fmt(f),
            Error::ForbiddenException(inner) => inner.fmt(f),
            Error::IdempotentParameterMismatchException(inner) => inner.fmt(f),
            Error::InvalidPaginationTokenException(inner) => inner.fmt(f),
            Error::InvalidParameterCombinationException(inner) => inner.fmt(f),
            Error::InvalidParameterException(inner) => inner.fmt(f),
            Error::InvalidParameterValueException(inner) => inner.fmt(f),
            Error::InvalidRequestException(inner) => inner.fmt(f),
            Error::InvalidVersionNumberException(inner) => inner.fmt(f),
            Error::ResourceAlreadyExistsException(inner) => inner.fmt(f),
            Error::ResourceDependencyException(inner) => inner.fmt(f),
            Error::ResourceInUseException(inner) => inner.fmt(f),
            Error::ResourceNotFoundException(inner) => inner.fmt(f),
            Error::ServiceException(inner) => inner.fmt(f),
            Error::ServiceQuotaExceededException(inner) => inner.fmt(f),
            Error::ServiceUnavailableException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CancelImageCreationError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CancelImageCreationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CancelImageCreationErrorKind::CallRateLimitExceededException(inner) => Error::CallRateLimitExceededException(inner),
                crate::error::CancelImageCreationErrorKind::ClientException(inner) => Error::ClientException(inner),
                crate::error::CancelImageCreationErrorKind::ForbiddenException(inner) => Error::ForbiddenException(inner),
                crate::error::CancelImageCreationErrorKind::IdempotentParameterMismatchException(inner) => Error::IdempotentParameterMismatchException(inner),
                crate::error::CancelImageCreationErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::CancelImageCreationErrorKind::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
                crate::error::CancelImageCreationErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::CancelImageCreationErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::CancelImageCreationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateComponentError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateComponentError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateComponentErrorKind::CallRateLimitExceededException(inner) => {
                    Error::CallRateLimitExceededException(inner)
                }
                crate::error::CreateComponentErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::CreateComponentErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::CreateComponentErrorKind::IdempotentParameterMismatchException(
                    inner,
                ) => Error::IdempotentParameterMismatchException(inner),
                crate::error::CreateComponentErrorKind::InvalidParameterCombinationException(
                    inner,
                ) => Error::InvalidParameterCombinationException(inner),
                crate::error::CreateComponentErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::CreateComponentErrorKind::InvalidVersionNumberException(inner) => {
                    Error::InvalidVersionNumberException(inner)
                }
                crate::error::CreateComponentErrorKind::ResourceInUseException(inner) => {
                    Error::ResourceInUseException(inner)
                }
                crate::error::CreateComponentErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::CreateComponentErrorKind::ServiceQuotaExceededException(inner) => {
                    Error::ServiceQuotaExceededException(inner)
                }
                crate::error::CreateComponentErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::CreateComponentErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateContainerRecipeError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateContainerRecipeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateContainerRecipeErrorKind::CallRateLimitExceededException(inner) => Error::CallRateLimitExceededException(inner),
                crate::error::CreateContainerRecipeErrorKind::ClientException(inner) => Error::ClientException(inner),
                crate::error::CreateContainerRecipeErrorKind::ForbiddenException(inner) => Error::ForbiddenException(inner),
                crate::error::CreateContainerRecipeErrorKind::IdempotentParameterMismatchException(inner) => Error::IdempotentParameterMismatchException(inner),
                crate::error::CreateContainerRecipeErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::CreateContainerRecipeErrorKind::InvalidVersionNumberException(inner) => Error::InvalidVersionNumberException(inner),
                crate::error::CreateContainerRecipeErrorKind::ResourceAlreadyExistsException(inner) => Error::ResourceAlreadyExistsException(inner),
                crate::error::CreateContainerRecipeErrorKind::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
                crate::error::CreateContainerRecipeErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::CreateContainerRecipeErrorKind::ServiceQuotaExceededException(inner) => Error::ServiceQuotaExceededException(inner),
                crate::error::CreateContainerRecipeErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::CreateContainerRecipeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::CreateDistributionConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::CreateDistributionConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateDistributionConfigurationErrorKind::CallRateLimitExceededException(inner) => Error::CallRateLimitExceededException(inner),
                crate::error::CreateDistributionConfigurationErrorKind::ClientException(inner) => Error::ClientException(inner),
                crate::error::CreateDistributionConfigurationErrorKind::ForbiddenException(inner) => Error::ForbiddenException(inner),
                crate::error::CreateDistributionConfigurationErrorKind::IdempotentParameterMismatchException(inner) => Error::IdempotentParameterMismatchException(inner),
                crate::error::CreateDistributionConfigurationErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::CreateDistributionConfigurationErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::CreateDistributionConfigurationErrorKind::ResourceAlreadyExistsException(inner) => Error::ResourceAlreadyExistsException(inner),
                crate::error::CreateDistributionConfigurationErrorKind::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
                crate::error::CreateDistributionConfigurationErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::CreateDistributionConfigurationErrorKind::ServiceQuotaExceededException(inner) => Error::ServiceQuotaExceededException(inner),
                crate::error::CreateDistributionConfigurationErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::CreateDistributionConfigurationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateImageError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateImageError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateImageErrorKind::CallRateLimitExceededException(inner) => {
                    Error::CallRateLimitExceededException(inner)
                }
                crate::error::CreateImageErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::CreateImageErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::CreateImageErrorKind::IdempotentParameterMismatchException(inner) => {
                    Error::IdempotentParameterMismatchException(inner)
                }
                crate::error::CreateImageErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::CreateImageErrorKind::ResourceInUseException(inner) => {
                    Error::ResourceInUseException(inner)
                }
                crate::error::CreateImageErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::CreateImageErrorKind::ServiceQuotaExceededException(inner) => {
                    Error::ServiceQuotaExceededException(inner)
                }
                crate::error::CreateImageErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::CreateImageErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateImagePipelineError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateImagePipelineError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateImagePipelineErrorKind::CallRateLimitExceededException(inner) => Error::CallRateLimitExceededException(inner),
                crate::error::CreateImagePipelineErrorKind::ClientException(inner) => Error::ClientException(inner),
                crate::error::CreateImagePipelineErrorKind::ForbiddenException(inner) => Error::ForbiddenException(inner),
                crate::error::CreateImagePipelineErrorKind::IdempotentParameterMismatchException(inner) => Error::IdempotentParameterMismatchException(inner),
                crate::error::CreateImagePipelineErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::CreateImagePipelineErrorKind::ResourceAlreadyExistsException(inner) => Error::ResourceAlreadyExistsException(inner),
                crate::error::CreateImagePipelineErrorKind::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
                crate::error::CreateImagePipelineErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::CreateImagePipelineErrorKind::ServiceQuotaExceededException(inner) => Error::ServiceQuotaExceededException(inner),
                crate::error::CreateImagePipelineErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::CreateImagePipelineErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateImageRecipeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateImageRecipeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateImageRecipeErrorKind::CallRateLimitExceededException(inner) => {
                    Error::CallRateLimitExceededException(inner)
                }
                crate::error::CreateImageRecipeErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::CreateImageRecipeErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::CreateImageRecipeErrorKind::IdempotentParameterMismatchException(
                    inner,
                ) => Error::IdempotentParameterMismatchException(inner),
                crate::error::CreateImageRecipeErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::CreateImageRecipeErrorKind::InvalidVersionNumberException(inner) => {
                    Error::InvalidVersionNumberException(inner)
                }
                crate::error::CreateImageRecipeErrorKind::ResourceAlreadyExistsException(inner) => {
                    Error::ResourceAlreadyExistsException(inner)
                }
                crate::error::CreateImageRecipeErrorKind::ResourceInUseException(inner) => {
                    Error::ResourceInUseException(inner)
                }
                crate::error::CreateImageRecipeErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::CreateImageRecipeErrorKind::ServiceQuotaExceededException(inner) => {
                    Error::ServiceQuotaExceededException(inner)
                }
                crate::error::CreateImageRecipeErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::CreateImageRecipeErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::CreateInfrastructureConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::CreateInfrastructureConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateInfrastructureConfigurationErrorKind::CallRateLimitExceededException(inner) => Error::CallRateLimitExceededException(inner),
                crate::error::CreateInfrastructureConfigurationErrorKind::ClientException(inner) => Error::ClientException(inner),
                crate::error::CreateInfrastructureConfigurationErrorKind::ForbiddenException(inner) => Error::ForbiddenException(inner),
                crate::error::CreateInfrastructureConfigurationErrorKind::IdempotentParameterMismatchException(inner) => Error::IdempotentParameterMismatchException(inner),
                crate::error::CreateInfrastructureConfigurationErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::CreateInfrastructureConfigurationErrorKind::ResourceAlreadyExistsException(inner) => Error::ResourceAlreadyExistsException(inner),
                crate::error::CreateInfrastructureConfigurationErrorKind::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
                crate::error::CreateInfrastructureConfigurationErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::CreateInfrastructureConfigurationErrorKind::ServiceQuotaExceededException(inner) => Error::ServiceQuotaExceededException(inner),
                crate::error::CreateInfrastructureConfigurationErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::CreateInfrastructureConfigurationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteComponentError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteComponentError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteComponentErrorKind::CallRateLimitExceededException(inner) => {
                    Error::CallRateLimitExceededException(inner)
                }
                crate::error::DeleteComponentErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DeleteComponentErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::DeleteComponentErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::DeleteComponentErrorKind::ResourceDependencyException(inner) => {
                    Error::ResourceDependencyException(inner)
                }
                crate::error::DeleteComponentErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DeleteComponentErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::DeleteComponentErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteContainerRecipeError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteContainerRecipeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteContainerRecipeErrorKind::CallRateLimitExceededException(
                    inner,
                ) => Error::CallRateLimitExceededException(inner),
                crate::error::DeleteContainerRecipeErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DeleteContainerRecipeErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::DeleteContainerRecipeErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::DeleteContainerRecipeErrorKind::ResourceDependencyException(
                    inner,
                ) => Error::ResourceDependencyException(inner),
                crate::error::DeleteContainerRecipeErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DeleteContainerRecipeErrorKind::ServiceUnavailableException(
                    inner,
                ) => Error::ServiceUnavailableException(inner),
                crate::error::DeleteContainerRecipeErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DeleteDistributionConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeleteDistributionConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteDistributionConfigurationErrorKind::CallRateLimitExceededException(inner) => Error::CallRateLimitExceededException(inner),
                crate::error::DeleteDistributionConfigurationErrorKind::ClientException(inner) => Error::ClientException(inner),
                crate::error::DeleteDistributionConfigurationErrorKind::ForbiddenException(inner) => Error::ForbiddenException(inner),
                crate::error::DeleteDistributionConfigurationErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::DeleteDistributionConfigurationErrorKind::ResourceDependencyException(inner) => Error::ResourceDependencyException(inner),
                crate::error::DeleteDistributionConfigurationErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::DeleteDistributionConfigurationErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::DeleteDistributionConfigurationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteImageError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteImageError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteImageErrorKind::CallRateLimitExceededException(inner) => {
                    Error::CallRateLimitExceededException(inner)
                }
                crate::error::DeleteImageErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DeleteImageErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::DeleteImageErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::DeleteImageErrorKind::ResourceDependencyException(inner) => {
                    Error::ResourceDependencyException(inner)
                }
                crate::error::DeleteImageErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DeleteImageErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::DeleteImageErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteImagePipelineError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteImagePipelineError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteImagePipelineErrorKind::CallRateLimitExceededException(
                    inner,
                ) => Error::CallRateLimitExceededException(inner),
                crate::error::DeleteImagePipelineErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DeleteImagePipelineErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::DeleteImagePipelineErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::DeleteImagePipelineErrorKind::ResourceDependencyException(inner) => {
                    Error::ResourceDependencyException(inner)
                }
                crate::error::DeleteImagePipelineErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DeleteImagePipelineErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::DeleteImagePipelineErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteImageRecipeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteImageRecipeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteImageRecipeErrorKind::CallRateLimitExceededException(inner) => {
                    Error::CallRateLimitExceededException(inner)
                }
                crate::error::DeleteImageRecipeErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::DeleteImageRecipeErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::DeleteImageRecipeErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::DeleteImageRecipeErrorKind::ResourceDependencyException(inner) => {
                    Error::ResourceDependencyException(inner)
                }
                crate::error::DeleteImageRecipeErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DeleteImageRecipeErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::DeleteImageRecipeErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DeleteInfrastructureConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeleteInfrastructureConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteInfrastructureConfigurationErrorKind::CallRateLimitExceededException(inner) => Error::CallRateLimitExceededException(inner),
                crate::error::DeleteInfrastructureConfigurationErrorKind::ClientException(inner) => Error::ClientException(inner),
                crate::error::DeleteInfrastructureConfigurationErrorKind::ForbiddenException(inner) => Error::ForbiddenException(inner),
                crate::error::DeleteInfrastructureConfigurationErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::DeleteInfrastructureConfigurationErrorKind::ResourceDependencyException(inner) => Error::ResourceDependencyException(inner),
                crate::error::DeleteInfrastructureConfigurationErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::DeleteInfrastructureConfigurationErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::DeleteInfrastructureConfigurationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetComponentError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetComponentError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetComponentErrorKind::CallRateLimitExceededException(inner) => {
                    Error::CallRateLimitExceededException(inner)
                }
                crate::error::GetComponentErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::GetComponentErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::GetComponentErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::GetComponentErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetComponentErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::GetComponentErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetComponentPolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetComponentPolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetComponentPolicyErrorKind::CallRateLimitExceededException(
                    inner,
                ) => Error::CallRateLimitExceededException(inner),
                crate::error::GetComponentPolicyErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::GetComponentPolicyErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::GetComponentPolicyErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::GetComponentPolicyErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetComponentPolicyErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::GetComponentPolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetContainerRecipeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetContainerRecipeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetContainerRecipeErrorKind::CallRateLimitExceededException(
                    inner,
                ) => Error::CallRateLimitExceededException(inner),
                crate::error::GetContainerRecipeErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::GetContainerRecipeErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::GetContainerRecipeErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::GetContainerRecipeErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetContainerRecipeErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::GetContainerRecipeErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetContainerRecipePolicyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetContainerRecipePolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetContainerRecipePolicyErrorKind::CallRateLimitExceededException(
                    inner,
                ) => Error::CallRateLimitExceededException(inner),
                crate::error::GetContainerRecipePolicyErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::GetContainerRecipePolicyErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::GetContainerRecipePolicyErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::GetContainerRecipePolicyErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetContainerRecipePolicyErrorKind::ServiceUnavailableException(
                    inner,
                ) => Error::ServiceUnavailableException(inner),
                crate::error::GetContainerRecipePolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDistributionConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetDistributionConfigurationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetDistributionConfigurationErrorKind::CallRateLimitExceededException(inner) => Error::CallRateLimitExceededException(inner),
                crate::error::GetDistributionConfigurationErrorKind::ClientException(inner) => Error::ClientException(inner),
                crate::error::GetDistributionConfigurationErrorKind::ForbiddenException(inner) => Error::ForbiddenException(inner),
                crate::error::GetDistributionConfigurationErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::GetDistributionConfigurationErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::GetDistributionConfigurationErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::GetDistributionConfigurationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetImageError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetImageError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetImageErrorKind::CallRateLimitExceededException(inner) => {
                    Error::CallRateLimitExceededException(inner)
                }
                crate::error::GetImageErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::GetImageErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::GetImageErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::GetImageErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetImageErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::GetImageErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetImagePipelineError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetImagePipelineError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetImagePipelineErrorKind::CallRateLimitExceededException(inner) => {
                    Error::CallRateLimitExceededException(inner)
                }
                crate::error::GetImagePipelineErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::GetImagePipelineErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::GetImagePipelineErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::GetImagePipelineErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetImagePipelineErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::GetImagePipelineErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetImagePolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetImagePolicyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetImagePolicyErrorKind::CallRateLimitExceededException(inner) => {
                    Error::CallRateLimitExceededException(inner)
                }
                crate::error::GetImagePolicyErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::GetImagePolicyErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::GetImagePolicyErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::GetImagePolicyErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetImagePolicyErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::GetImagePolicyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetImageRecipeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetImageRecipeError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetImageRecipeErrorKind::CallRateLimitExceededException(inner) => {
                    Error::CallRateLimitExceededException(inner)
                }
                crate::error::GetImageRecipeErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::GetImageRecipeErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::GetImageRecipeErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::GetImageRecipeErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetImageRecipeErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::GetImageRecipeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetImageRecipePolicyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetImageRecipePolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetImageRecipePolicyErrorKind::CallRateLimitExceededException(
                    inner,
                ) => Error::CallRateLimitExceededException(inner),
                crate::error::GetImageRecipePolicyErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::GetImageRecipePolicyErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::GetImageRecipePolicyErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::GetImageRecipePolicyErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetImageRecipePolicyErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::GetImageRecipePolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GetInfrastructureConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetInfrastructureConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetInfrastructureConfigurationErrorKind::CallRateLimitExceededException(inner) => Error::CallRateLimitExceededException(inner),
                crate::error::GetInfrastructureConfigurationErrorKind::ClientException(inner) => Error::ClientException(inner),
                crate::error::GetInfrastructureConfigurationErrorKind::ForbiddenException(inner) => Error::ForbiddenException(inner),
                crate::error::GetInfrastructureConfigurationErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::GetInfrastructureConfigurationErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::GetInfrastructureConfigurationErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::GetInfrastructureConfigurationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ImportComponentError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ImportComponentError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ImportComponentErrorKind::CallRateLimitExceededException(inner) => {
                    Error::CallRateLimitExceededException(inner)
                }
                crate::error::ImportComponentErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::ImportComponentErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::ImportComponentErrorKind::IdempotentParameterMismatchException(
                    inner,
                ) => Error::IdempotentParameterMismatchException(inner),
                crate::error::ImportComponentErrorKind::InvalidParameterCombinationException(
                    inner,
                ) => Error::InvalidParameterCombinationException(inner),
                crate::error::ImportComponentErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::ImportComponentErrorKind::InvalidVersionNumberException(inner) => {
                    Error::InvalidVersionNumberException(inner)
                }
                crate::error::ImportComponentErrorKind::ResourceInUseException(inner) => {
                    Error::ResourceInUseException(inner)
                }
                crate::error::ImportComponentErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::ImportComponentErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::ImportComponentErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListComponentBuildVersionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListComponentBuildVersionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListComponentBuildVersionsErrorKind::CallRateLimitExceededException(inner) => Error::CallRateLimitExceededException(inner),
                crate::error::ListComponentBuildVersionsErrorKind::ClientException(inner) => Error::ClientException(inner),
                crate::error::ListComponentBuildVersionsErrorKind::ForbiddenException(inner) => Error::ForbiddenException(inner),
                crate::error::ListComponentBuildVersionsErrorKind::InvalidPaginationTokenException(inner) => Error::InvalidPaginationTokenException(inner),
                crate::error::ListComponentBuildVersionsErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::ListComponentBuildVersionsErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::ListComponentBuildVersionsErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::ListComponentBuildVersionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListComponentsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListComponentsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListComponentsErrorKind::CallRateLimitExceededException(inner) => {
                    Error::CallRateLimitExceededException(inner)
                }
                crate::error::ListComponentsErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::ListComponentsErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::ListComponentsErrorKind::InvalidPaginationTokenException(inner) => {
                    Error::InvalidPaginationTokenException(inner)
                }
                crate::error::ListComponentsErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::ListComponentsErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::ListComponentsErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::ListComponentsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListContainerRecipesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListContainerRecipesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListContainerRecipesErrorKind::CallRateLimitExceededException(
                    inner,
                ) => Error::CallRateLimitExceededException(inner),
                crate::error::ListContainerRecipesErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::ListContainerRecipesErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::ListContainerRecipesErrorKind::InvalidPaginationTokenException(
                    inner,
                ) => Error::InvalidPaginationTokenException(inner),
                crate::error::ListContainerRecipesErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::ListContainerRecipesErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::ListContainerRecipesErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::ListContainerRecipesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ListDistributionConfigurationsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListDistributionConfigurationsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListDistributionConfigurationsErrorKind::CallRateLimitExceededException(inner) => Error::CallRateLimitExceededException(inner),
                crate::error::ListDistributionConfigurationsErrorKind::ClientException(inner) => Error::ClientException(inner),
                crate::error::ListDistributionConfigurationsErrorKind::ForbiddenException(inner) => Error::ForbiddenException(inner),
                crate::error::ListDistributionConfigurationsErrorKind::InvalidPaginationTokenException(inner) => Error::InvalidPaginationTokenException(inner),
                crate::error::ListDistributionConfigurationsErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::ListDistributionConfigurationsErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::ListDistributionConfigurationsErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::ListDistributionConfigurationsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListImageBuildVersionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListImageBuildVersionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListImageBuildVersionsErrorKind::CallRateLimitExceededException(
                    inner,
                ) => Error::CallRateLimitExceededException(inner),
                crate::error::ListImageBuildVersionsErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::ListImageBuildVersionsErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::ListImageBuildVersionsErrorKind::InvalidPaginationTokenException(
                    inner,
                ) => Error::InvalidPaginationTokenException(inner),
                crate::error::ListImageBuildVersionsErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::ListImageBuildVersionsErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::ListImageBuildVersionsErrorKind::ServiceUnavailableException(
                    inner,
                ) => Error::ServiceUnavailableException(inner),
                crate::error::ListImageBuildVersionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListImagePackagesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListImagePackagesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListImagePackagesErrorKind::CallRateLimitExceededException(inner) => {
                    Error::CallRateLimitExceededException(inner)
                }
                crate::error::ListImagePackagesErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::ListImagePackagesErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::ListImagePackagesErrorKind::InvalidPaginationTokenException(
                    inner,
                ) => Error::InvalidPaginationTokenException(inner),
                crate::error::ListImagePackagesErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::ListImagePackagesErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListImagePackagesErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::ListImagePackagesErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::ListImagePackagesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListImagePipelineImagesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListImagePipelineImagesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListImagePipelineImagesErrorKind::CallRateLimitExceededException(
                    inner,
                ) => Error::CallRateLimitExceededException(inner),
                crate::error::ListImagePipelineImagesErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::ListImagePipelineImagesErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::ListImagePipelineImagesErrorKind::InvalidPaginationTokenException(
                    inner,
                ) => Error::InvalidPaginationTokenException(inner),
                crate::error::ListImagePipelineImagesErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::ListImagePipelineImagesErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::ListImagePipelineImagesErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::ListImagePipelineImagesErrorKind::ServiceUnavailableException(
                    inner,
                ) => Error::ServiceUnavailableException(inner),
                crate::error::ListImagePipelineImagesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListImagePipelinesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListImagePipelinesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListImagePipelinesErrorKind::CallRateLimitExceededException(
                    inner,
                ) => Error::CallRateLimitExceededException(inner),
                crate::error::ListImagePipelinesErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::ListImagePipelinesErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::ListImagePipelinesErrorKind::InvalidPaginationTokenException(
                    inner,
                ) => Error::InvalidPaginationTokenException(inner),
                crate::error::ListImagePipelinesErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::ListImagePipelinesErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::ListImagePipelinesErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::ListImagePipelinesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListImageRecipesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListImageRecipesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListImageRecipesErrorKind::CallRateLimitExceededException(inner) => {
                    Error::CallRateLimitExceededException(inner)
                }
                crate::error::ListImageRecipesErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::ListImageRecipesErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::ListImageRecipesErrorKind::InvalidPaginationTokenException(inner) => {
                    Error::InvalidPaginationTokenException(inner)
                }
                crate::error::ListImageRecipesErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::ListImageRecipesErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::ListImageRecipesErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::ListImageRecipesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListImagesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListImagesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListImagesErrorKind::CallRateLimitExceededException(inner) => {
                    Error::CallRateLimitExceededException(inner)
                }
                crate::error::ListImagesErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::ListImagesErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::ListImagesErrorKind::InvalidPaginationTokenException(inner) => {
                    Error::InvalidPaginationTokenException(inner)
                }
                crate::error::ListImagesErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::ListImagesErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::ListImagesErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::ListImagesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ListInfrastructureConfigurationsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListInfrastructureConfigurationsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListInfrastructureConfigurationsErrorKind::CallRateLimitExceededException(inner) => Error::CallRateLimitExceededException(inner),
                crate::error::ListInfrastructureConfigurationsErrorKind::ClientException(inner) => Error::ClientException(inner),
                crate::error::ListInfrastructureConfigurationsErrorKind::ForbiddenException(inner) => Error::ForbiddenException(inner),
                crate::error::ListInfrastructureConfigurationsErrorKind::InvalidPaginationTokenException(inner) => Error::InvalidPaginationTokenException(inner),
                crate::error::ListInfrastructureConfigurationsErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::ListInfrastructureConfigurationsErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::ListInfrastructureConfigurationsErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::ListInfrastructureConfigurationsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsForResourceErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutComponentPolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutComponentPolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutComponentPolicyErrorKind::CallRateLimitExceededException(
                    inner,
                ) => Error::CallRateLimitExceededException(inner),
                crate::error::PutComponentPolicyErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::PutComponentPolicyErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::PutComponentPolicyErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::PutComponentPolicyErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::PutComponentPolicyErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::PutComponentPolicyErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::PutComponentPolicyErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::PutComponentPolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutContainerRecipePolicyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutContainerRecipePolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutContainerRecipePolicyErrorKind::CallRateLimitExceededException(
                    inner,
                ) => Error::CallRateLimitExceededException(inner),
                crate::error::PutContainerRecipePolicyErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::PutContainerRecipePolicyErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::PutContainerRecipePolicyErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::PutContainerRecipePolicyErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::PutContainerRecipePolicyErrorKind::ResourceNotFoundException(
                    inner,
                ) => Error::ResourceNotFoundException(inner),
                crate::error::PutContainerRecipePolicyErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::PutContainerRecipePolicyErrorKind::ServiceUnavailableException(
                    inner,
                ) => Error::ServiceUnavailableException(inner),
                crate::error::PutContainerRecipePolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutImagePolicyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::PutImagePolicyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutImagePolicyErrorKind::CallRateLimitExceededException(inner) => {
                    Error::CallRateLimitExceededException(inner)
                }
                crate::error::PutImagePolicyErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::PutImagePolicyErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::PutImagePolicyErrorKind::InvalidParameterValueException(inner) => {
                    Error::InvalidParameterValueException(inner)
                }
                crate::error::PutImagePolicyErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::PutImagePolicyErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::PutImagePolicyErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::PutImagePolicyErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::PutImagePolicyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutImageRecipePolicyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutImageRecipePolicyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutImageRecipePolicyErrorKind::CallRateLimitExceededException(
                    inner,
                ) => Error::CallRateLimitExceededException(inner),
                crate::error::PutImageRecipePolicyErrorKind::ClientException(inner) => {
                    Error::ClientException(inner)
                }
                crate::error::PutImageRecipePolicyErrorKind::ForbiddenException(inner) => {
                    Error::ForbiddenException(inner)
                }
                crate::error::PutImageRecipePolicyErrorKind::InvalidParameterValueException(
                    inner,
                ) => Error::InvalidParameterValueException(inner),
                crate::error::PutImageRecipePolicyErrorKind::InvalidRequestException(inner) => {
                    Error::InvalidRequestException(inner)
                }
                crate::error::PutImageRecipePolicyErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::PutImageRecipePolicyErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::PutImageRecipePolicyErrorKind::ServiceUnavailableException(inner) => {
                    Error::ServiceUnavailableException(inner)
                }
                crate::error::PutImageRecipePolicyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartImagePipelineExecutionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartImagePipelineExecutionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartImagePipelineExecutionErrorKind::CallRateLimitExceededException(inner) => Error::CallRateLimitExceededException(inner),
                crate::error::StartImagePipelineExecutionErrorKind::ClientException(inner) => Error::ClientException(inner),
                crate::error::StartImagePipelineExecutionErrorKind::ForbiddenException(inner) => Error::ForbiddenException(inner),
                crate::error::StartImagePipelineExecutionErrorKind::IdempotentParameterMismatchException(inner) => Error::IdempotentParameterMismatchException(inner),
                crate::error::StartImagePipelineExecutionErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::StartImagePipelineExecutionErrorKind::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
                crate::error::StartImagePipelineExecutionErrorKind::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
                crate::error::StartImagePipelineExecutionErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::StartImagePipelineExecutionErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::StartImagePipelineExecutionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TagResourceErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::TagResourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::TagResourceErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::TagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UntagResourceErrorKind::InvalidParameterException(inner) => {
                    Error::InvalidParameterException(inner)
                }
                crate::error::UntagResourceErrorKind::ResourceNotFoundException(inner) => {
                    Error::ResourceNotFoundException(inner)
                }
                crate::error::UntagResourceErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::UntagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::UpdateDistributionConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::UpdateDistributionConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateDistributionConfigurationErrorKind::CallRateLimitExceededException(inner) => Error::CallRateLimitExceededException(inner),
                crate::error::UpdateDistributionConfigurationErrorKind::ClientException(inner) => Error::ClientException(inner),
                crate::error::UpdateDistributionConfigurationErrorKind::ForbiddenException(inner) => Error::ForbiddenException(inner),
                crate::error::UpdateDistributionConfigurationErrorKind::IdempotentParameterMismatchException(inner) => Error::IdempotentParameterMismatchException(inner),
                crate::error::UpdateDistributionConfigurationErrorKind::InvalidParameterCombinationException(inner) => Error::InvalidParameterCombinationException(inner),
                crate::error::UpdateDistributionConfigurationErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::UpdateDistributionConfigurationErrorKind::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
                crate::error::UpdateDistributionConfigurationErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::UpdateDistributionConfigurationErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::UpdateDistributionConfigurationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateImagePipelineError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateImagePipelineError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateImagePipelineErrorKind::CallRateLimitExceededException(inner) => Error::CallRateLimitExceededException(inner),
                crate::error::UpdateImagePipelineErrorKind::ClientException(inner) => Error::ClientException(inner),
                crate::error::UpdateImagePipelineErrorKind::ForbiddenException(inner) => Error::ForbiddenException(inner),
                crate::error::UpdateImagePipelineErrorKind::IdempotentParameterMismatchException(inner) => Error::IdempotentParameterMismatchException(inner),
                crate::error::UpdateImagePipelineErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::UpdateImagePipelineErrorKind::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
                crate::error::UpdateImagePipelineErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::UpdateImagePipelineErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::UpdateImagePipelineErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::UpdateInfrastructureConfigurationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::UpdateInfrastructureConfigurationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateInfrastructureConfigurationErrorKind::CallRateLimitExceededException(inner) => Error::CallRateLimitExceededException(inner),
                crate::error::UpdateInfrastructureConfigurationErrorKind::ClientException(inner) => Error::ClientException(inner),
                crate::error::UpdateInfrastructureConfigurationErrorKind::ForbiddenException(inner) => Error::ForbiddenException(inner),
                crate::error::UpdateInfrastructureConfigurationErrorKind::IdempotentParameterMismatchException(inner) => Error::IdempotentParameterMismatchException(inner),
                crate::error::UpdateInfrastructureConfigurationErrorKind::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
                crate::error::UpdateInfrastructureConfigurationErrorKind::ResourceInUseException(inner) => Error::ResourceInUseException(inner),
                crate::error::UpdateInfrastructureConfigurationErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::UpdateInfrastructureConfigurationErrorKind::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
                crate::error::UpdateInfrastructureConfigurationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
