// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateInfrastructureConfigurationOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The idempotency token used to make this request idempotent.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that was updated by
    /// this request.</p>
    pub infrastructure_configuration_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateInfrastructureConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateInfrastructureConfigurationOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("client_token", &self.client_token);
        formatter.field(
            "infrastructure_configuration_arn",
            &self.infrastructure_configuration_arn,
        );
        formatter.finish()
    }
}
/// See [`UpdateInfrastructureConfigurationOutput`](crate::output::UpdateInfrastructureConfigurationOutput)
pub mod update_infrastructure_configuration_output {
    /// A builder for [`UpdateInfrastructureConfigurationOutput`](crate::output::UpdateInfrastructureConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) infrastructure_configuration_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that was updated by
        /// this request.</p>
        pub fn infrastructure_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.infrastructure_configuration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that was updated by
        /// this request.</p>
        pub fn set_infrastructure_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.infrastructure_configuration_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateInfrastructureConfigurationOutput`](crate::output::UpdateInfrastructureConfigurationOutput)
        pub fn build(self) -> crate::output::UpdateInfrastructureConfigurationOutput {
            crate::output::UpdateInfrastructureConfigurationOutput {
                request_id: self.request_id,
                client_token: self.client_token,
                infrastructure_configuration_arn: self.infrastructure_configuration_arn,
            }
        }
    }
}
impl UpdateInfrastructureConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateInfrastructureConfigurationOutput`](crate::output::UpdateInfrastructureConfigurationOutput)
    pub fn builder() -> crate::output::update_infrastructure_configuration_output::Builder {
        crate::output::update_infrastructure_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateImagePipelineOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The idempotency token used to make this request idempotent.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the image pipeline that was updated by this request.</p>
    pub image_pipeline_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateImagePipelineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateImagePipelineOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("client_token", &self.client_token);
        formatter.field("image_pipeline_arn", &self.image_pipeline_arn);
        formatter.finish()
    }
}
/// See [`UpdateImagePipelineOutput`](crate::output::UpdateImagePipelineOutput)
pub mod update_image_pipeline_output {
    /// A builder for [`UpdateImagePipelineOutput`](crate::output::UpdateImagePipelineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) image_pipeline_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline that was updated by this request.</p>
        pub fn image_pipeline_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_pipeline_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline that was updated by this request.</p>
        pub fn set_image_pipeline_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_pipeline_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateImagePipelineOutput`](crate::output::UpdateImagePipelineOutput)
        pub fn build(self) -> crate::output::UpdateImagePipelineOutput {
            crate::output::UpdateImagePipelineOutput {
                request_id: self.request_id,
                client_token: self.client_token,
                image_pipeline_arn: self.image_pipeline_arn,
            }
        }
    }
}
impl UpdateImagePipelineOutput {
    /// Creates a new builder-style object to manufacture [`UpdateImagePipelineOutput`](crate::output::UpdateImagePipelineOutput)
    pub fn builder() -> crate::output::update_image_pipeline_output::Builder {
        crate::output::update_image_pipeline_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDistributionConfigurationOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The idempotency token used to make this request idempotent.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the distribution configuration that was updated by this
    /// request.</p>
    pub distribution_configuration_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateDistributionConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDistributionConfigurationOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("client_token", &self.client_token);
        formatter.field(
            "distribution_configuration_arn",
            &self.distribution_configuration_arn,
        );
        formatter.finish()
    }
}
/// See [`UpdateDistributionConfigurationOutput`](crate::output::UpdateDistributionConfigurationOutput)
pub mod update_distribution_configuration_output {
    /// A builder for [`UpdateDistributionConfigurationOutput`](crate::output::UpdateDistributionConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) distribution_configuration_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration that was updated by this
        /// request.</p>
        pub fn distribution_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.distribution_configuration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration that was updated by this
        /// request.</p>
        pub fn set_distribution_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.distribution_configuration_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDistributionConfigurationOutput`](crate::output::UpdateDistributionConfigurationOutput)
        pub fn build(self) -> crate::output::UpdateDistributionConfigurationOutput {
            crate::output::UpdateDistributionConfigurationOutput {
                request_id: self.request_id,
                client_token: self.client_token,
                distribution_configuration_arn: self.distribution_configuration_arn,
            }
        }
    }
}
impl UpdateDistributionConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDistributionConfigurationOutput`](crate::output::UpdateDistributionConfigurationOutput)
    pub fn builder() -> crate::output::update_distribution_configuration_output::Builder {
        crate::output::update_distribution_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartImagePipelineExecutionOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The idempotency token used to make this request idempotent.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the image that was created by this request.</p>
    pub image_build_version_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StartImagePipelineExecutionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartImagePipelineExecutionOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("client_token", &self.client_token);
        formatter.field("image_build_version_arn", &self.image_build_version_arn);
        formatter.finish()
    }
}
/// See [`StartImagePipelineExecutionOutput`](crate::output::StartImagePipelineExecutionOutput)
pub mod start_image_pipeline_execution_output {
    /// A builder for [`StartImagePipelineExecutionOutput`](crate::output::StartImagePipelineExecutionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) image_build_version_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image that was created by this request.</p>
        pub fn image_build_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_build_version_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image that was created by this request.</p>
        pub fn set_image_build_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_build_version_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`StartImagePipelineExecutionOutput`](crate::output::StartImagePipelineExecutionOutput)
        pub fn build(self) -> crate::output::StartImagePipelineExecutionOutput {
            crate::output::StartImagePipelineExecutionOutput {
                request_id: self.request_id,
                client_token: self.client_token,
                image_build_version_arn: self.image_build_version_arn,
            }
        }
    }
}
impl StartImagePipelineExecutionOutput {
    /// Creates a new builder-style object to manufacture [`StartImagePipelineExecutionOutput`](crate::output::StartImagePipelineExecutionOutput)
    pub fn builder() -> crate::output::start_image_pipeline_execution_output::Builder {
        crate::output::start_image_pipeline_execution_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutImageRecipePolicyOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the image recipe that this policy was applied to.</p>
    pub image_recipe_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PutImageRecipePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutImageRecipePolicyOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("image_recipe_arn", &self.image_recipe_arn);
        formatter.finish()
    }
}
/// See [`PutImageRecipePolicyOutput`](crate::output::PutImageRecipePolicyOutput)
pub mod put_image_recipe_policy_output {
    /// A builder for [`PutImageRecipePolicyOutput`](crate::output::PutImageRecipePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) image_recipe_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe that this policy was applied to.</p>
        pub fn image_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_recipe_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe that this policy was applied to.</p>
        pub fn set_image_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_recipe_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`PutImageRecipePolicyOutput`](crate::output::PutImageRecipePolicyOutput)
        pub fn build(self) -> crate::output::PutImageRecipePolicyOutput {
            crate::output::PutImageRecipePolicyOutput {
                request_id: self.request_id,
                image_recipe_arn: self.image_recipe_arn,
            }
        }
    }
}
impl PutImageRecipePolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutImageRecipePolicyOutput`](crate::output::PutImageRecipePolicyOutput)
    pub fn builder() -> crate::output::put_image_recipe_policy_output::Builder {
        crate::output::put_image_recipe_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutImagePolicyOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the image that this policy was applied to.</p>
    pub image_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PutImagePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutImagePolicyOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("image_arn", &self.image_arn);
        formatter.finish()
    }
}
/// See [`PutImagePolicyOutput`](crate::output::PutImagePolicyOutput)
pub mod put_image_policy_output {
    /// A builder for [`PutImagePolicyOutput`](crate::output::PutImagePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) image_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image that this policy was applied to.</p>
        pub fn image_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image that this policy was applied to.</p>
        pub fn set_image_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`PutImagePolicyOutput`](crate::output::PutImagePolicyOutput)
        pub fn build(self) -> crate::output::PutImagePolicyOutput {
            crate::output::PutImagePolicyOutput {
                request_id: self.request_id,
                image_arn: self.image_arn,
            }
        }
    }
}
impl PutImagePolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutImagePolicyOutput`](crate::output::PutImagePolicyOutput)
    pub fn builder() -> crate::output::put_image_policy_output::Builder {
        crate::output::put_image_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutContainerRecipePolicyOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the container recipe that this policy was applied to.</p>
    pub container_recipe_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PutContainerRecipePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutContainerRecipePolicyOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("container_recipe_arn", &self.container_recipe_arn);
        formatter.finish()
    }
}
/// See [`PutContainerRecipePolicyOutput`](crate::output::PutContainerRecipePolicyOutput)
pub mod put_container_recipe_policy_output {
    /// A builder for [`PutContainerRecipePolicyOutput`](crate::output::PutContainerRecipePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) container_recipe_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe that this policy was applied to.</p>
        pub fn container_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_recipe_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe that this policy was applied to.</p>
        pub fn set_container_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_recipe_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`PutContainerRecipePolicyOutput`](crate::output::PutContainerRecipePolicyOutput)
        pub fn build(self) -> crate::output::PutContainerRecipePolicyOutput {
            crate::output::PutContainerRecipePolicyOutput {
                request_id: self.request_id,
                container_recipe_arn: self.container_recipe_arn,
            }
        }
    }
}
impl PutContainerRecipePolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutContainerRecipePolicyOutput`](crate::output::PutContainerRecipePolicyOutput)
    pub fn builder() -> crate::output::put_container_recipe_policy_output::Builder {
        crate::output::put_container_recipe_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutComponentPolicyOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the component that this policy was applied to.</p>
    pub component_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PutComponentPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutComponentPolicyOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("component_arn", &self.component_arn);
        formatter.finish()
    }
}
/// See [`PutComponentPolicyOutput`](crate::output::PutComponentPolicyOutput)
pub mod put_component_policy_output {
    /// A builder for [`PutComponentPolicyOutput`](crate::output::PutComponentPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) component_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the component that this policy was applied to.</p>
        pub fn component_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the component that this policy was applied to.</p>
        pub fn set_component_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`PutComponentPolicyOutput`](crate::output::PutComponentPolicyOutput)
        pub fn build(self) -> crate::output::PutComponentPolicyOutput {
            crate::output::PutComponentPolicyOutput {
                request_id: self.request_id,
                component_arn: self.component_arn,
            }
        }
    }
}
impl PutComponentPolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutComponentPolicyOutput`](crate::output::PutComponentPolicyOutput)
    pub fn builder() -> crate::output::put_component_policy_output::Builder {
        crate::output::put_component_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The tags for the specified resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the specified resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags for the specified resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInfrastructureConfigurationsOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The list of infrastructure configurations.</p>
    pub infrastructure_configuration_summary_list:
        std::option::Option<std::vec::Vec<crate::model::InfrastructureConfigurationSummary>>,
    /// <p>The next token used for paginated responses. When this is not empty, there are additional
    /// elements that the service has not included in this request. Use this token with the next
    /// request to retrieve additional objects.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListInfrastructureConfigurationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInfrastructureConfigurationsOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field(
            "infrastructure_configuration_summary_list",
            &self.infrastructure_configuration_summary_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListInfrastructureConfigurationsOutput`](crate::output::ListInfrastructureConfigurationsOutput)
pub mod list_infrastructure_configurations_output {
    /// A builder for [`ListInfrastructureConfigurationsOutput`](crate::output::ListInfrastructureConfigurationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) infrastructure_configuration_summary_list:
            std::option::Option<std::vec::Vec<crate::model::InfrastructureConfigurationSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Appends an item to `infrastructure_configuration_summary_list`.
        ///
        /// To override the contents of this collection use [`set_infrastructure_configuration_summary_list`](Self::set_infrastructure_configuration_summary_list).
        ///
        /// <p>The list of infrastructure configurations.</p>
        pub fn infrastructure_configuration_summary_list(
            mut self,
            input: impl Into<crate::model::InfrastructureConfigurationSummary>,
        ) -> Self {
            let mut v = self
                .infrastructure_configuration_summary_list
                .unwrap_or_default();
            v.push(input.into());
            self.infrastructure_configuration_summary_list = Some(v);
            self
        }
        /// <p>The list of infrastructure configurations.</p>
        pub fn set_infrastructure_configuration_summary_list(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::InfrastructureConfigurationSummary>,
            >,
        ) -> Self {
            self.infrastructure_configuration_summary_list = input;
            self
        }
        /// <p>The next token used for paginated responses. When this is not empty, there are additional
        /// elements that the service has not included in this request. Use this token with the next
        /// request to retrieve additional objects.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next token used for paginated responses. When this is not empty, there are additional
        /// elements that the service has not included in this request. Use this token with the next
        /// request to retrieve additional objects.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInfrastructureConfigurationsOutput`](crate::output::ListInfrastructureConfigurationsOutput)
        pub fn build(self) -> crate::output::ListInfrastructureConfigurationsOutput {
            crate::output::ListInfrastructureConfigurationsOutput {
                request_id: self.request_id,
                infrastructure_configuration_summary_list: self
                    .infrastructure_configuration_summary_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListInfrastructureConfigurationsOutput {
    /// Creates a new builder-style object to manufacture [`ListInfrastructureConfigurationsOutput`](crate::output::ListInfrastructureConfigurationsOutput)
    pub fn builder() -> crate::output::list_infrastructure_configurations_output::Builder {
        crate::output::list_infrastructure_configurations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListImagesOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The list of image semantic versions.</p>
    /// <note>
    /// <p>The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
    /// You can assign values for the first three, and can filter on all of them.</p>
    /// <p>
    /// <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x)
    /// to specify the most recent versions or nodes when selecting the base image or components for your
    /// recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be
    /// wildcards.</p>
    /// </note>
    pub image_version_list: std::option::Option<std::vec::Vec<crate::model::ImageVersion>>,
    /// <p>The next token used for paginated responses. When this is not empty, there are additional
    /// elements that the service has not included in this request. Use this token with the next
    /// request to retrieve additional objects.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListImagesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListImagesOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("image_version_list", &self.image_version_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListImagesOutput`](crate::output::ListImagesOutput)
pub mod list_images_output {
    /// A builder for [`ListImagesOutput`](crate::output::ListImagesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) image_version_list:
            std::option::Option<std::vec::Vec<crate::model::ImageVersion>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Appends an item to `image_version_list`.
        ///
        /// To override the contents of this collection use [`set_image_version_list`](Self::set_image_version_list).
        ///
        /// <p>The list of image semantic versions.</p>
        /// <note>
        /// <p>The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
        /// You can assign values for the first three, and can filter on all of them.</p>
        /// <p>
        /// <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x)
        /// to specify the most recent versions or nodes when selecting the base image or components for your
        /// recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be
        /// wildcards.</p>
        /// </note>
        pub fn image_version_list(mut self, input: impl Into<crate::model::ImageVersion>) -> Self {
            let mut v = self.image_version_list.unwrap_or_default();
            v.push(input.into());
            self.image_version_list = Some(v);
            self
        }
        /// <p>The list of image semantic versions.</p>
        /// <note>
        /// <p>The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
        /// You can assign values for the first three, and can filter on all of them.</p>
        /// <p>
        /// <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x)
        /// to specify the most recent versions or nodes when selecting the base image or components for your
        /// recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be
        /// wildcards.</p>
        /// </note>
        pub fn set_image_version_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageVersion>>,
        ) -> Self {
            self.image_version_list = input;
            self
        }
        /// <p>The next token used for paginated responses. When this is not empty, there are additional
        /// elements that the service has not included in this request. Use this token with the next
        /// request to retrieve additional objects.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next token used for paginated responses. When this is not empty, there are additional
        /// elements that the service has not included in this request. Use this token with the next
        /// request to retrieve additional objects.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListImagesOutput`](crate::output::ListImagesOutput)
        pub fn build(self) -> crate::output::ListImagesOutput {
            crate::output::ListImagesOutput {
                request_id: self.request_id,
                image_version_list: self.image_version_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListImagesOutput {
    /// Creates a new builder-style object to manufacture [`ListImagesOutput`](crate::output::ListImagesOutput)
    pub fn builder() -> crate::output::list_images_output::Builder {
        crate::output::list_images_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListImageRecipesOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The list of image pipelines.</p>
    pub image_recipe_summary_list:
        std::option::Option<std::vec::Vec<crate::model::ImageRecipeSummary>>,
    /// <p>The next token used for paginated responses. When this is not empty, there are additional
    /// elements that the service has not included in this request. Use this token with the next
    /// request to retrieve additional objects.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListImageRecipesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListImageRecipesOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("image_recipe_summary_list", &self.image_recipe_summary_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListImageRecipesOutput`](crate::output::ListImageRecipesOutput)
pub mod list_image_recipes_output {
    /// A builder for [`ListImageRecipesOutput`](crate::output::ListImageRecipesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) image_recipe_summary_list:
            std::option::Option<std::vec::Vec<crate::model::ImageRecipeSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Appends an item to `image_recipe_summary_list`.
        ///
        /// To override the contents of this collection use [`set_image_recipe_summary_list`](Self::set_image_recipe_summary_list).
        ///
        /// <p>The list of image pipelines.</p>
        pub fn image_recipe_summary_list(
            mut self,
            input: impl Into<crate::model::ImageRecipeSummary>,
        ) -> Self {
            let mut v = self.image_recipe_summary_list.unwrap_or_default();
            v.push(input.into());
            self.image_recipe_summary_list = Some(v);
            self
        }
        /// <p>The list of image pipelines.</p>
        pub fn set_image_recipe_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageRecipeSummary>>,
        ) -> Self {
            self.image_recipe_summary_list = input;
            self
        }
        /// <p>The next token used for paginated responses. When this is not empty, there are additional
        /// elements that the service has not included in this request. Use this token with the next
        /// request to retrieve additional objects.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next token used for paginated responses. When this is not empty, there are additional
        /// elements that the service has not included in this request. Use this token with the next
        /// request to retrieve additional objects.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListImageRecipesOutput`](crate::output::ListImageRecipesOutput)
        pub fn build(self) -> crate::output::ListImageRecipesOutput {
            crate::output::ListImageRecipesOutput {
                request_id: self.request_id,
                image_recipe_summary_list: self.image_recipe_summary_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListImageRecipesOutput {
    /// Creates a new builder-style object to manufacture [`ListImageRecipesOutput`](crate::output::ListImageRecipesOutput)
    pub fn builder() -> crate::output::list_image_recipes_output::Builder {
        crate::output::list_image_recipes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListImagePipelinesOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The list of image pipelines.</p>
    pub image_pipeline_list: std::option::Option<std::vec::Vec<crate::model::ImagePipeline>>,
    /// <p>The next token used for paginated responses. When this is not empty, there are additional
    /// elements that the service has not included in this request. Use this token with the next
    /// request to retrieve additional objects.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListImagePipelinesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListImagePipelinesOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("image_pipeline_list", &self.image_pipeline_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListImagePipelinesOutput`](crate::output::ListImagePipelinesOutput)
pub mod list_image_pipelines_output {
    /// A builder for [`ListImagePipelinesOutput`](crate::output::ListImagePipelinesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) image_pipeline_list:
            std::option::Option<std::vec::Vec<crate::model::ImagePipeline>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Appends an item to `image_pipeline_list`.
        ///
        /// To override the contents of this collection use [`set_image_pipeline_list`](Self::set_image_pipeline_list).
        ///
        /// <p>The list of image pipelines.</p>
        pub fn image_pipeline_list(
            mut self,
            input: impl Into<crate::model::ImagePipeline>,
        ) -> Self {
            let mut v = self.image_pipeline_list.unwrap_or_default();
            v.push(input.into());
            self.image_pipeline_list = Some(v);
            self
        }
        /// <p>The list of image pipelines.</p>
        pub fn set_image_pipeline_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImagePipeline>>,
        ) -> Self {
            self.image_pipeline_list = input;
            self
        }
        /// <p>The next token used for paginated responses. When this is not empty, there are additional
        /// elements that the service has not included in this request. Use this token with the next
        /// request to retrieve additional objects.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next token used for paginated responses. When this is not empty, there are additional
        /// elements that the service has not included in this request. Use this token with the next
        /// request to retrieve additional objects.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListImagePipelinesOutput`](crate::output::ListImagePipelinesOutput)
        pub fn build(self) -> crate::output::ListImagePipelinesOutput {
            crate::output::ListImagePipelinesOutput {
                request_id: self.request_id,
                image_pipeline_list: self.image_pipeline_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListImagePipelinesOutput {
    /// Creates a new builder-style object to manufacture [`ListImagePipelinesOutput`](crate::output::ListImagePipelinesOutput)
    pub fn builder() -> crate::output::list_image_pipelines_output::Builder {
        crate::output::list_image_pipelines_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListImagePipelineImagesOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The list of images built by this pipeline.</p>
    pub image_summary_list: std::option::Option<std::vec::Vec<crate::model::ImageSummary>>,
    /// <p>The next token used for paginated responses. When this is not empty, there are additional
    /// elements that the service has not included in this request. Use this token with the next
    /// request to retrieve additional objects.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListImagePipelineImagesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListImagePipelineImagesOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("image_summary_list", &self.image_summary_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListImagePipelineImagesOutput`](crate::output::ListImagePipelineImagesOutput)
pub mod list_image_pipeline_images_output {
    /// A builder for [`ListImagePipelineImagesOutput`](crate::output::ListImagePipelineImagesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) image_summary_list:
            std::option::Option<std::vec::Vec<crate::model::ImageSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Appends an item to `image_summary_list`.
        ///
        /// To override the contents of this collection use [`set_image_summary_list`](Self::set_image_summary_list).
        ///
        /// <p>The list of images built by this pipeline.</p>
        pub fn image_summary_list(mut self, input: impl Into<crate::model::ImageSummary>) -> Self {
            let mut v = self.image_summary_list.unwrap_or_default();
            v.push(input.into());
            self.image_summary_list = Some(v);
            self
        }
        /// <p>The list of images built by this pipeline.</p>
        pub fn set_image_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageSummary>>,
        ) -> Self {
            self.image_summary_list = input;
            self
        }
        /// <p>The next token used for paginated responses. When this is not empty, there are additional
        /// elements that the service has not included in this request. Use this token with the next
        /// request to retrieve additional objects.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next token used for paginated responses. When this is not empty, there are additional
        /// elements that the service has not included in this request. Use this token with the next
        /// request to retrieve additional objects.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListImagePipelineImagesOutput`](crate::output::ListImagePipelineImagesOutput)
        pub fn build(self) -> crate::output::ListImagePipelineImagesOutput {
            crate::output::ListImagePipelineImagesOutput {
                request_id: self.request_id,
                image_summary_list: self.image_summary_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListImagePipelineImagesOutput {
    /// Creates a new builder-style object to manufacture [`ListImagePipelineImagesOutput`](crate::output::ListImagePipelineImagesOutput)
    pub fn builder() -> crate::output::list_image_pipeline_images_output::Builder {
        crate::output::list_image_pipeline_images_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListImagePackagesOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The list of Image Packages returned in the response.</p>
    pub image_package_list: std::option::Option<std::vec::Vec<crate::model::ImagePackage>>,
    /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListImagePackagesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListImagePackagesOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("image_package_list", &self.image_package_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListImagePackagesOutput`](crate::output::ListImagePackagesOutput)
pub mod list_image_packages_output {
    /// A builder for [`ListImagePackagesOutput`](crate::output::ListImagePackagesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) image_package_list:
            std::option::Option<std::vec::Vec<crate::model::ImagePackage>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Appends an item to `image_package_list`.
        ///
        /// To override the contents of this collection use [`set_image_package_list`](Self::set_image_package_list).
        ///
        /// <p>The list of Image Packages returned in the response.</p>
        pub fn image_package_list(mut self, input: impl Into<crate::model::ImagePackage>) -> Self {
            let mut v = self.image_package_list.unwrap_or_default();
            v.push(input.into());
            self.image_package_list = Some(v);
            self
        }
        /// <p>The list of Image Packages returned in the response.</p>
        pub fn set_image_package_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImagePackage>>,
        ) -> Self {
            self.image_package_list = input;
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to specify where to start paginating. This is the NextToken from a previously truncated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListImagePackagesOutput`](crate::output::ListImagePackagesOutput)
        pub fn build(self) -> crate::output::ListImagePackagesOutput {
            crate::output::ListImagePackagesOutput {
                request_id: self.request_id,
                image_package_list: self.image_package_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListImagePackagesOutput {
    /// Creates a new builder-style object to manufacture [`ListImagePackagesOutput`](crate::output::ListImagePackagesOutput)
    pub fn builder() -> crate::output::list_image_packages_output::Builder {
        crate::output::list_image_packages_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListImageBuildVersionsOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The list of image build versions.</p>
    pub image_summary_list: std::option::Option<std::vec::Vec<crate::model::ImageSummary>>,
    /// <p>The next token used for paginated responses. When this is not empty, there are additional
    /// elements that the service has not included in this request. Use this token with the next
    /// request to retrieve additional objects.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListImageBuildVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListImageBuildVersionsOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("image_summary_list", &self.image_summary_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListImageBuildVersionsOutput`](crate::output::ListImageBuildVersionsOutput)
pub mod list_image_build_versions_output {
    /// A builder for [`ListImageBuildVersionsOutput`](crate::output::ListImageBuildVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) image_summary_list:
            std::option::Option<std::vec::Vec<crate::model::ImageSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Appends an item to `image_summary_list`.
        ///
        /// To override the contents of this collection use [`set_image_summary_list`](Self::set_image_summary_list).
        ///
        /// <p>The list of image build versions.</p>
        pub fn image_summary_list(mut self, input: impl Into<crate::model::ImageSummary>) -> Self {
            let mut v = self.image_summary_list.unwrap_or_default();
            v.push(input.into());
            self.image_summary_list = Some(v);
            self
        }
        /// <p>The list of image build versions.</p>
        pub fn set_image_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageSummary>>,
        ) -> Self {
            self.image_summary_list = input;
            self
        }
        /// <p>The next token used for paginated responses. When this is not empty, there are additional
        /// elements that the service has not included in this request. Use this token with the next
        /// request to retrieve additional objects.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next token used for paginated responses. When this is not empty, there are additional
        /// elements that the service has not included in this request. Use this token with the next
        /// request to retrieve additional objects.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListImageBuildVersionsOutput`](crate::output::ListImageBuildVersionsOutput)
        pub fn build(self) -> crate::output::ListImageBuildVersionsOutput {
            crate::output::ListImageBuildVersionsOutput {
                request_id: self.request_id,
                image_summary_list: self.image_summary_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListImageBuildVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListImageBuildVersionsOutput`](crate::output::ListImageBuildVersionsOutput)
    pub fn builder() -> crate::output::list_image_build_versions_output::Builder {
        crate::output::list_image_build_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDistributionConfigurationsOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The list of distributions.</p>
    pub distribution_configuration_summary_list:
        std::option::Option<std::vec::Vec<crate::model::DistributionConfigurationSummary>>,
    /// <p>The next token used for paginated responses. When this is not empty, there are additional
    /// elements that the service has not included in this request. Use this token with the next
    /// request to retrieve additional objects.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListDistributionConfigurationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDistributionConfigurationsOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field(
            "distribution_configuration_summary_list",
            &self.distribution_configuration_summary_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDistributionConfigurationsOutput`](crate::output::ListDistributionConfigurationsOutput)
pub mod list_distribution_configurations_output {
    /// A builder for [`ListDistributionConfigurationsOutput`](crate::output::ListDistributionConfigurationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) distribution_configuration_summary_list:
            std::option::Option<std::vec::Vec<crate::model::DistributionConfigurationSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Appends an item to `distribution_configuration_summary_list`.
        ///
        /// To override the contents of this collection use [`set_distribution_configuration_summary_list`](Self::set_distribution_configuration_summary_list).
        ///
        /// <p>The list of distributions.</p>
        pub fn distribution_configuration_summary_list(
            mut self,
            input: impl Into<crate::model::DistributionConfigurationSummary>,
        ) -> Self {
            let mut v = self
                .distribution_configuration_summary_list
                .unwrap_or_default();
            v.push(input.into());
            self.distribution_configuration_summary_list = Some(v);
            self
        }
        /// <p>The list of distributions.</p>
        pub fn set_distribution_configuration_summary_list(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::DistributionConfigurationSummary>,
            >,
        ) -> Self {
            self.distribution_configuration_summary_list = input;
            self
        }
        /// <p>The next token used for paginated responses. When this is not empty, there are additional
        /// elements that the service has not included in this request. Use this token with the next
        /// request to retrieve additional objects.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next token used for paginated responses. When this is not empty, there are additional
        /// elements that the service has not included in this request. Use this token with the next
        /// request to retrieve additional objects.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDistributionConfigurationsOutput`](crate::output::ListDistributionConfigurationsOutput)
        pub fn build(self) -> crate::output::ListDistributionConfigurationsOutput {
            crate::output::ListDistributionConfigurationsOutput {
                request_id: self.request_id,
                distribution_configuration_summary_list: self
                    .distribution_configuration_summary_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDistributionConfigurationsOutput {
    /// Creates a new builder-style object to manufacture [`ListDistributionConfigurationsOutput`](crate::output::ListDistributionConfigurationsOutput)
    pub fn builder() -> crate::output::list_distribution_configurations_output::Builder {
        crate::output::list_distribution_configurations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListContainerRecipesOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The list of container recipes returned for the request.</p>
    pub container_recipe_summary_list:
        std::option::Option<std::vec::Vec<crate::model::ContainerRecipeSummary>>,
    /// <p>The next token field is used for paginated responses. When this is not empty, there are additional container recipes that the service has not included in this response. Use this token with the next request to retrieve additional list items.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListContainerRecipesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListContainerRecipesOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field(
            "container_recipe_summary_list",
            &self.container_recipe_summary_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListContainerRecipesOutput`](crate::output::ListContainerRecipesOutput)
pub mod list_container_recipes_output {
    /// A builder for [`ListContainerRecipesOutput`](crate::output::ListContainerRecipesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) container_recipe_summary_list:
            std::option::Option<std::vec::Vec<crate::model::ContainerRecipeSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Appends an item to `container_recipe_summary_list`.
        ///
        /// To override the contents of this collection use [`set_container_recipe_summary_list`](Self::set_container_recipe_summary_list).
        ///
        /// <p>The list of container recipes returned for the request.</p>
        pub fn container_recipe_summary_list(
            mut self,
            input: impl Into<crate::model::ContainerRecipeSummary>,
        ) -> Self {
            let mut v = self.container_recipe_summary_list.unwrap_or_default();
            v.push(input.into());
            self.container_recipe_summary_list = Some(v);
            self
        }
        /// <p>The list of container recipes returned for the request.</p>
        pub fn set_container_recipe_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContainerRecipeSummary>>,
        ) -> Self {
            self.container_recipe_summary_list = input;
            self
        }
        /// <p>The next token field is used for paginated responses. When this is not empty, there are additional container recipes that the service has not included in this response. Use this token with the next request to retrieve additional list items.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next token field is used for paginated responses. When this is not empty, there are additional container recipes that the service has not included in this response. Use this token with the next request to retrieve additional list items.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListContainerRecipesOutput`](crate::output::ListContainerRecipesOutput)
        pub fn build(self) -> crate::output::ListContainerRecipesOutput {
            crate::output::ListContainerRecipesOutput {
                request_id: self.request_id,
                container_recipe_summary_list: self.container_recipe_summary_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListContainerRecipesOutput {
    /// Creates a new builder-style object to manufacture [`ListContainerRecipesOutput`](crate::output::ListContainerRecipesOutput)
    pub fn builder() -> crate::output::list_container_recipes_output::Builder {
        crate::output::list_container_recipes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListComponentsOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The list of component semantic versions.</p>
    /// <note>
    /// <p>The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
    /// You can assign values for the first three, and can filter on all of them.</p>
    /// </note>
    pub component_version_list: std::option::Option<std::vec::Vec<crate::model::ComponentVersion>>,
    /// <p>The next token used for paginated responses. When this is not empty, there are additional
    /// elements that the service has not included in this request. Use this token with the next
    /// request to retrieve additional objects.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListComponentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListComponentsOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("component_version_list", &self.component_version_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListComponentsOutput`](crate::output::ListComponentsOutput)
pub mod list_components_output {
    /// A builder for [`ListComponentsOutput`](crate::output::ListComponentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) component_version_list:
            std::option::Option<std::vec::Vec<crate::model::ComponentVersion>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Appends an item to `component_version_list`.
        ///
        /// To override the contents of this collection use [`set_component_version_list`](Self::set_component_version_list).
        ///
        /// <p>The list of component semantic versions.</p>
        /// <note>
        /// <p>The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
        /// You can assign values for the first three, and can filter on all of them.</p>
        /// </note>
        pub fn component_version_list(
            mut self,
            input: impl Into<crate::model::ComponentVersion>,
        ) -> Self {
            let mut v = self.component_version_list.unwrap_or_default();
            v.push(input.into());
            self.component_version_list = Some(v);
            self
        }
        /// <p>The list of component semantic versions.</p>
        /// <note>
        /// <p>The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
        /// You can assign values for the first three, and can filter on all of them.</p>
        /// </note>
        pub fn set_component_version_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComponentVersion>>,
        ) -> Self {
            self.component_version_list = input;
            self
        }
        /// <p>The next token used for paginated responses. When this is not empty, there are additional
        /// elements that the service has not included in this request. Use this token with the next
        /// request to retrieve additional objects.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next token used for paginated responses. When this is not empty, there are additional
        /// elements that the service has not included in this request. Use this token with the next
        /// request to retrieve additional objects.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListComponentsOutput`](crate::output::ListComponentsOutput)
        pub fn build(self) -> crate::output::ListComponentsOutput {
            crate::output::ListComponentsOutput {
                request_id: self.request_id,
                component_version_list: self.component_version_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListComponentsOutput {
    /// Creates a new builder-style object to manufacture [`ListComponentsOutput`](crate::output::ListComponentsOutput)
    pub fn builder() -> crate::output::list_components_output::Builder {
        crate::output::list_components_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListComponentBuildVersionsOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The list of component summaries for the specified semantic version.</p>
    pub component_summary_list: std::option::Option<std::vec::Vec<crate::model::ComponentSummary>>,
    /// <p>The next token used for paginated responses. When this is not empty, there are additional
    /// elements that the service has not included in this request. Use this token with the next
    /// request to retrieve additional objects.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListComponentBuildVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListComponentBuildVersionsOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("component_summary_list", &self.component_summary_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListComponentBuildVersionsOutput`](crate::output::ListComponentBuildVersionsOutput)
pub mod list_component_build_versions_output {
    /// A builder for [`ListComponentBuildVersionsOutput`](crate::output::ListComponentBuildVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) component_summary_list:
            std::option::Option<std::vec::Vec<crate::model::ComponentSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// Appends an item to `component_summary_list`.
        ///
        /// To override the contents of this collection use [`set_component_summary_list`](Self::set_component_summary_list).
        ///
        /// <p>The list of component summaries for the specified semantic version.</p>
        pub fn component_summary_list(
            mut self,
            input: impl Into<crate::model::ComponentSummary>,
        ) -> Self {
            let mut v = self.component_summary_list.unwrap_or_default();
            v.push(input.into());
            self.component_summary_list = Some(v);
            self
        }
        /// <p>The list of component summaries for the specified semantic version.</p>
        pub fn set_component_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComponentSummary>>,
        ) -> Self {
            self.component_summary_list = input;
            self
        }
        /// <p>The next token used for paginated responses. When this is not empty, there are additional
        /// elements that the service has not included in this request. Use this token with the next
        /// request to retrieve additional objects.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The next token used for paginated responses. When this is not empty, there are additional
        /// elements that the service has not included in this request. Use this token with the next
        /// request to retrieve additional objects.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListComponentBuildVersionsOutput`](crate::output::ListComponentBuildVersionsOutput)
        pub fn build(self) -> crate::output::ListComponentBuildVersionsOutput {
            crate::output::ListComponentBuildVersionsOutput {
                request_id: self.request_id,
                component_summary_list: self.component_summary_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListComponentBuildVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListComponentBuildVersionsOutput`](crate::output::ListComponentBuildVersionsOutput)
    pub fn builder() -> crate::output::list_component_build_versions_output::Builder {
        crate::output::list_component_build_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportComponentOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The idempotency token used to make this request idempotent.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the imported component.</p>
    pub component_build_version_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ImportComponentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportComponentOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("client_token", &self.client_token);
        formatter.field(
            "component_build_version_arn",
            &self.component_build_version_arn,
        );
        formatter.finish()
    }
}
/// See [`ImportComponentOutput`](crate::output::ImportComponentOutput)
pub mod import_component_output {
    /// A builder for [`ImportComponentOutput`](crate::output::ImportComponentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) component_build_version_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the imported component.</p>
        pub fn component_build_version_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.component_build_version_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the imported component.</p>
        pub fn set_component_build_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_build_version_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportComponentOutput`](crate::output::ImportComponentOutput)
        pub fn build(self) -> crate::output::ImportComponentOutput {
            crate::output::ImportComponentOutput {
                request_id: self.request_id,
                client_token: self.client_token,
                component_build_version_arn: self.component_build_version_arn,
            }
        }
    }
}
impl ImportComponentOutput {
    /// Creates a new builder-style object to manufacture [`ImportComponentOutput`](crate::output::ImportComponentOutput)
    pub fn builder() -> crate::output::import_component_output::Builder {
        crate::output::import_component_output::Builder::default()
    }
}

/// <p>GetInfrastructureConfiguration response object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInfrastructureConfigurationOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The infrastructure configuration object.</p>
    pub infrastructure_configuration:
        std::option::Option<crate::model::InfrastructureConfiguration>,
}
impl std::fmt::Debug for GetInfrastructureConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInfrastructureConfigurationOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field(
            "infrastructure_configuration",
            &self.infrastructure_configuration,
        );
        formatter.finish()
    }
}
/// See [`GetInfrastructureConfigurationOutput`](crate::output::GetInfrastructureConfigurationOutput)
pub mod get_infrastructure_configuration_output {
    /// A builder for [`GetInfrastructureConfigurationOutput`](crate::output::GetInfrastructureConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) infrastructure_configuration:
            std::option::Option<crate::model::InfrastructureConfiguration>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The infrastructure configuration object.</p>
        pub fn infrastructure_configuration(
            mut self,
            input: crate::model::InfrastructureConfiguration,
        ) -> Self {
            self.infrastructure_configuration = Some(input);
            self
        }
        /// <p>The infrastructure configuration object.</p>
        pub fn set_infrastructure_configuration(
            mut self,
            input: std::option::Option<crate::model::InfrastructureConfiguration>,
        ) -> Self {
            self.infrastructure_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInfrastructureConfigurationOutput`](crate::output::GetInfrastructureConfigurationOutput)
        pub fn build(self) -> crate::output::GetInfrastructureConfigurationOutput {
            crate::output::GetInfrastructureConfigurationOutput {
                request_id: self.request_id,
                infrastructure_configuration: self.infrastructure_configuration,
            }
        }
    }
}
impl GetInfrastructureConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetInfrastructureConfigurationOutput`](crate::output::GetInfrastructureConfigurationOutput)
    pub fn builder() -> crate::output::get_infrastructure_configuration_output::Builder {
        crate::output::get_infrastructure_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetImageRecipePolicyOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The image recipe policy object.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetImageRecipePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetImageRecipePolicyOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`GetImageRecipePolicyOutput`](crate::output::GetImageRecipePolicyOutput)
pub mod get_image_recipe_policy_output {
    /// A builder for [`GetImageRecipePolicyOutput`](crate::output::GetImageRecipePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The image recipe policy object.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The image recipe policy object.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetImageRecipePolicyOutput`](crate::output::GetImageRecipePolicyOutput)
        pub fn build(self) -> crate::output::GetImageRecipePolicyOutput {
            crate::output::GetImageRecipePolicyOutput {
                request_id: self.request_id,
                policy: self.policy,
            }
        }
    }
}
impl GetImageRecipePolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetImageRecipePolicyOutput`](crate::output::GetImageRecipePolicyOutput)
    pub fn builder() -> crate::output::get_image_recipe_policy_output::Builder {
        crate::output::get_image_recipe_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetImageRecipeOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The image recipe object.</p>
    pub image_recipe: std::option::Option<crate::model::ImageRecipe>,
}
impl std::fmt::Debug for GetImageRecipeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetImageRecipeOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("image_recipe", &self.image_recipe);
        formatter.finish()
    }
}
/// See [`GetImageRecipeOutput`](crate::output::GetImageRecipeOutput)
pub mod get_image_recipe_output {
    /// A builder for [`GetImageRecipeOutput`](crate::output::GetImageRecipeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) image_recipe: std::option::Option<crate::model::ImageRecipe>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The image recipe object.</p>
        pub fn image_recipe(mut self, input: crate::model::ImageRecipe) -> Self {
            self.image_recipe = Some(input);
            self
        }
        /// <p>The image recipe object.</p>
        pub fn set_image_recipe(
            mut self,
            input: std::option::Option<crate::model::ImageRecipe>,
        ) -> Self {
            self.image_recipe = input;
            self
        }
        /// Consumes the builder and constructs a [`GetImageRecipeOutput`](crate::output::GetImageRecipeOutput)
        pub fn build(self) -> crate::output::GetImageRecipeOutput {
            crate::output::GetImageRecipeOutput {
                request_id: self.request_id,
                image_recipe: self.image_recipe,
            }
        }
    }
}
impl GetImageRecipeOutput {
    /// Creates a new builder-style object to manufacture [`GetImageRecipeOutput`](crate::output::GetImageRecipeOutput)
    pub fn builder() -> crate::output::get_image_recipe_output::Builder {
        crate::output::get_image_recipe_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetImagePolicyOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The image policy object.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetImagePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetImagePolicyOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`GetImagePolicyOutput`](crate::output::GetImagePolicyOutput)
pub mod get_image_policy_output {
    /// A builder for [`GetImagePolicyOutput`](crate::output::GetImagePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The image policy object.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The image policy object.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetImagePolicyOutput`](crate::output::GetImagePolicyOutput)
        pub fn build(self) -> crate::output::GetImagePolicyOutput {
            crate::output::GetImagePolicyOutput {
                request_id: self.request_id,
                policy: self.policy,
            }
        }
    }
}
impl GetImagePolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetImagePolicyOutput`](crate::output::GetImagePolicyOutput)
    pub fn builder() -> crate::output::get_image_policy_output::Builder {
        crate::output::get_image_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetImagePipelineOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The image pipeline object.</p>
    pub image_pipeline: std::option::Option<crate::model::ImagePipeline>,
}
impl std::fmt::Debug for GetImagePipelineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetImagePipelineOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("image_pipeline", &self.image_pipeline);
        formatter.finish()
    }
}
/// See [`GetImagePipelineOutput`](crate::output::GetImagePipelineOutput)
pub mod get_image_pipeline_output {
    /// A builder for [`GetImagePipelineOutput`](crate::output::GetImagePipelineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) image_pipeline: std::option::Option<crate::model::ImagePipeline>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The image pipeline object.</p>
        pub fn image_pipeline(mut self, input: crate::model::ImagePipeline) -> Self {
            self.image_pipeline = Some(input);
            self
        }
        /// <p>The image pipeline object.</p>
        pub fn set_image_pipeline(
            mut self,
            input: std::option::Option<crate::model::ImagePipeline>,
        ) -> Self {
            self.image_pipeline = input;
            self
        }
        /// Consumes the builder and constructs a [`GetImagePipelineOutput`](crate::output::GetImagePipelineOutput)
        pub fn build(self) -> crate::output::GetImagePipelineOutput {
            crate::output::GetImagePipelineOutput {
                request_id: self.request_id,
                image_pipeline: self.image_pipeline,
            }
        }
    }
}
impl GetImagePipelineOutput {
    /// Creates a new builder-style object to manufacture [`GetImagePipelineOutput`](crate::output::GetImagePipelineOutput)
    pub fn builder() -> crate::output::get_image_pipeline_output::Builder {
        crate::output::get_image_pipeline_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetImageOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The image object.</p>
    pub image: std::option::Option<crate::model::Image>,
}
impl std::fmt::Debug for GetImageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetImageOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("image", &self.image);
        formatter.finish()
    }
}
/// See [`GetImageOutput`](crate::output::GetImageOutput)
pub mod get_image_output {
    /// A builder for [`GetImageOutput`](crate::output::GetImageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) image: std::option::Option<crate::model::Image>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The image object.</p>
        pub fn image(mut self, input: crate::model::Image) -> Self {
            self.image = Some(input);
            self
        }
        /// <p>The image object.</p>
        pub fn set_image(mut self, input: std::option::Option<crate::model::Image>) -> Self {
            self.image = input;
            self
        }
        /// Consumes the builder and constructs a [`GetImageOutput`](crate::output::GetImageOutput)
        pub fn build(self) -> crate::output::GetImageOutput {
            crate::output::GetImageOutput {
                request_id: self.request_id,
                image: self.image,
            }
        }
    }
}
impl GetImageOutput {
    /// Creates a new builder-style object to manufacture [`GetImageOutput`](crate::output::GetImageOutput)
    pub fn builder() -> crate::output::get_image_output::Builder {
        crate::output::get_image_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDistributionConfigurationOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The distribution configuration object.</p>
    pub distribution_configuration: std::option::Option<crate::model::DistributionConfiguration>,
}
impl std::fmt::Debug for GetDistributionConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDistributionConfigurationOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field(
            "distribution_configuration",
            &self.distribution_configuration,
        );
        formatter.finish()
    }
}
/// See [`GetDistributionConfigurationOutput`](crate::output::GetDistributionConfigurationOutput)
pub mod get_distribution_configuration_output {
    /// A builder for [`GetDistributionConfigurationOutput`](crate::output::GetDistributionConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) distribution_configuration:
            std::option::Option<crate::model::DistributionConfiguration>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The distribution configuration object.</p>
        pub fn distribution_configuration(
            mut self,
            input: crate::model::DistributionConfiguration,
        ) -> Self {
            self.distribution_configuration = Some(input);
            self
        }
        /// <p>The distribution configuration object.</p>
        pub fn set_distribution_configuration(
            mut self,
            input: std::option::Option<crate::model::DistributionConfiguration>,
        ) -> Self {
            self.distribution_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDistributionConfigurationOutput`](crate::output::GetDistributionConfigurationOutput)
        pub fn build(self) -> crate::output::GetDistributionConfigurationOutput {
            crate::output::GetDistributionConfigurationOutput {
                request_id: self.request_id,
                distribution_configuration: self.distribution_configuration,
            }
        }
    }
}
impl GetDistributionConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`GetDistributionConfigurationOutput`](crate::output::GetDistributionConfigurationOutput)
    pub fn builder() -> crate::output::get_distribution_configuration_output::Builder {
        crate::output::get_distribution_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetContainerRecipePolicyOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The container recipe policy object that is returned.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetContainerRecipePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetContainerRecipePolicyOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`GetContainerRecipePolicyOutput`](crate::output::GetContainerRecipePolicyOutput)
pub mod get_container_recipe_policy_output {
    /// A builder for [`GetContainerRecipePolicyOutput`](crate::output::GetContainerRecipePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The container recipe policy object that is returned.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The container recipe policy object that is returned.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetContainerRecipePolicyOutput`](crate::output::GetContainerRecipePolicyOutput)
        pub fn build(self) -> crate::output::GetContainerRecipePolicyOutput {
            crate::output::GetContainerRecipePolicyOutput {
                request_id: self.request_id,
                policy: self.policy,
            }
        }
    }
}
impl GetContainerRecipePolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetContainerRecipePolicyOutput`](crate::output::GetContainerRecipePolicyOutput)
    pub fn builder() -> crate::output::get_container_recipe_policy_output::Builder {
        crate::output::get_container_recipe_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetContainerRecipeOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The container recipe object that is returned.</p>
    pub container_recipe: std::option::Option<crate::model::ContainerRecipe>,
}
impl std::fmt::Debug for GetContainerRecipeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetContainerRecipeOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("container_recipe", &self.container_recipe);
        formatter.finish()
    }
}
/// See [`GetContainerRecipeOutput`](crate::output::GetContainerRecipeOutput)
pub mod get_container_recipe_output {
    /// A builder for [`GetContainerRecipeOutput`](crate::output::GetContainerRecipeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) container_recipe: std::option::Option<crate::model::ContainerRecipe>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The container recipe object that is returned.</p>
        pub fn container_recipe(mut self, input: crate::model::ContainerRecipe) -> Self {
            self.container_recipe = Some(input);
            self
        }
        /// <p>The container recipe object that is returned.</p>
        pub fn set_container_recipe(
            mut self,
            input: std::option::Option<crate::model::ContainerRecipe>,
        ) -> Self {
            self.container_recipe = input;
            self
        }
        /// Consumes the builder and constructs a [`GetContainerRecipeOutput`](crate::output::GetContainerRecipeOutput)
        pub fn build(self) -> crate::output::GetContainerRecipeOutput {
            crate::output::GetContainerRecipeOutput {
                request_id: self.request_id,
                container_recipe: self.container_recipe,
            }
        }
    }
}
impl GetContainerRecipeOutput {
    /// Creates a new builder-style object to manufacture [`GetContainerRecipeOutput`](crate::output::GetContainerRecipeOutput)
    pub fn builder() -> crate::output::get_container_recipe_output::Builder {
        crate::output::get_container_recipe_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetComponentPolicyOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The component policy.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetComponentPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetComponentPolicyOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`GetComponentPolicyOutput`](crate::output::GetComponentPolicyOutput)
pub mod get_component_policy_output {
    /// A builder for [`GetComponentPolicyOutput`](crate::output::GetComponentPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The component policy.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The component policy.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetComponentPolicyOutput`](crate::output::GetComponentPolicyOutput)
        pub fn build(self) -> crate::output::GetComponentPolicyOutput {
            crate::output::GetComponentPolicyOutput {
                request_id: self.request_id,
                policy: self.policy,
            }
        }
    }
}
impl GetComponentPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetComponentPolicyOutput`](crate::output::GetComponentPolicyOutput)
    pub fn builder() -> crate::output::get_component_policy_output::Builder {
        crate::output::get_component_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetComponentOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The component object associated with the specified ARN.</p>
    pub component: std::option::Option<crate::model::Component>,
}
impl std::fmt::Debug for GetComponentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetComponentOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("component", &self.component);
        formatter.finish()
    }
}
/// See [`GetComponentOutput`](crate::output::GetComponentOutput)
pub mod get_component_output {
    /// A builder for [`GetComponentOutput`](crate::output::GetComponentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) component: std::option::Option<crate::model::Component>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The component object associated with the specified ARN.</p>
        pub fn component(mut self, input: crate::model::Component) -> Self {
            self.component = Some(input);
            self
        }
        /// <p>The component object associated with the specified ARN.</p>
        pub fn set_component(
            mut self,
            input: std::option::Option<crate::model::Component>,
        ) -> Self {
            self.component = input;
            self
        }
        /// Consumes the builder and constructs a [`GetComponentOutput`](crate::output::GetComponentOutput)
        pub fn build(self) -> crate::output::GetComponentOutput {
            crate::output::GetComponentOutput {
                request_id: self.request_id,
                component: self.component,
            }
        }
    }
}
impl GetComponentOutput {
    /// Creates a new builder-style object to manufacture [`GetComponentOutput`](crate::output::GetComponentOutput)
    pub fn builder() -> crate::output::get_component_output::Builder {
        crate::output::get_component_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteInfrastructureConfigurationOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that was deleted.</p>
    pub infrastructure_configuration_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteInfrastructureConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteInfrastructureConfigurationOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field(
            "infrastructure_configuration_arn",
            &self.infrastructure_configuration_arn,
        );
        formatter.finish()
    }
}
/// See [`DeleteInfrastructureConfigurationOutput`](crate::output::DeleteInfrastructureConfigurationOutput)
pub mod delete_infrastructure_configuration_output {
    /// A builder for [`DeleteInfrastructureConfigurationOutput`](crate::output::DeleteInfrastructureConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) infrastructure_configuration_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that was deleted.</p>
        pub fn infrastructure_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.infrastructure_configuration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that was deleted.</p>
        pub fn set_infrastructure_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.infrastructure_configuration_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteInfrastructureConfigurationOutput`](crate::output::DeleteInfrastructureConfigurationOutput)
        pub fn build(self) -> crate::output::DeleteInfrastructureConfigurationOutput {
            crate::output::DeleteInfrastructureConfigurationOutput {
                request_id: self.request_id,
                infrastructure_configuration_arn: self.infrastructure_configuration_arn,
            }
        }
    }
}
impl DeleteInfrastructureConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteInfrastructureConfigurationOutput`](crate::output::DeleteInfrastructureConfigurationOutput)
    pub fn builder() -> crate::output::delete_infrastructure_configuration_output::Builder {
        crate::output::delete_infrastructure_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteImageRecipeOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the image recipe that was deleted.</p>
    pub image_recipe_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteImageRecipeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteImageRecipeOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("image_recipe_arn", &self.image_recipe_arn);
        formatter.finish()
    }
}
/// See [`DeleteImageRecipeOutput`](crate::output::DeleteImageRecipeOutput)
pub mod delete_image_recipe_output {
    /// A builder for [`DeleteImageRecipeOutput`](crate::output::DeleteImageRecipeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) image_recipe_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe that was deleted.</p>
        pub fn image_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_recipe_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe that was deleted.</p>
        pub fn set_image_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_recipe_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteImageRecipeOutput`](crate::output::DeleteImageRecipeOutput)
        pub fn build(self) -> crate::output::DeleteImageRecipeOutput {
            crate::output::DeleteImageRecipeOutput {
                request_id: self.request_id,
                image_recipe_arn: self.image_recipe_arn,
            }
        }
    }
}
impl DeleteImageRecipeOutput {
    /// Creates a new builder-style object to manufacture [`DeleteImageRecipeOutput`](crate::output::DeleteImageRecipeOutput)
    pub fn builder() -> crate::output::delete_image_recipe_output::Builder {
        crate::output::delete_image_recipe_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteImagePipelineOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the image pipeline that was deleted.</p>
    pub image_pipeline_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteImagePipelineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteImagePipelineOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("image_pipeline_arn", &self.image_pipeline_arn);
        formatter.finish()
    }
}
/// See [`DeleteImagePipelineOutput`](crate::output::DeleteImagePipelineOutput)
pub mod delete_image_pipeline_output {
    /// A builder for [`DeleteImagePipelineOutput`](crate::output::DeleteImagePipelineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) image_pipeline_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline that was deleted.</p>
        pub fn image_pipeline_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_pipeline_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline that was deleted.</p>
        pub fn set_image_pipeline_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_pipeline_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteImagePipelineOutput`](crate::output::DeleteImagePipelineOutput)
        pub fn build(self) -> crate::output::DeleteImagePipelineOutput {
            crate::output::DeleteImagePipelineOutput {
                request_id: self.request_id,
                image_pipeline_arn: self.image_pipeline_arn,
            }
        }
    }
}
impl DeleteImagePipelineOutput {
    /// Creates a new builder-style object to manufacture [`DeleteImagePipelineOutput`](crate::output::DeleteImagePipelineOutput)
    pub fn builder() -> crate::output::delete_image_pipeline_output::Builder {
        crate::output::delete_image_pipeline_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteImageOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Image Builder image resource that was deleted.</p>
    pub image_build_version_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteImageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteImageOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("image_build_version_arn", &self.image_build_version_arn);
        formatter.finish()
    }
}
/// See [`DeleteImageOutput`](crate::output::DeleteImageOutput)
pub mod delete_image_output {
    /// A builder for [`DeleteImageOutput`](crate::output::DeleteImageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) image_build_version_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Image Builder image resource that was deleted.</p>
        pub fn image_build_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_build_version_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Image Builder image resource that was deleted.</p>
        pub fn set_image_build_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_build_version_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteImageOutput`](crate::output::DeleteImageOutput)
        pub fn build(self) -> crate::output::DeleteImageOutput {
            crate::output::DeleteImageOutput {
                request_id: self.request_id,
                image_build_version_arn: self.image_build_version_arn,
            }
        }
    }
}
impl DeleteImageOutput {
    /// Creates a new builder-style object to manufacture [`DeleteImageOutput`](crate::output::DeleteImageOutput)
    pub fn builder() -> crate::output::delete_image_output::Builder {
        crate::output::delete_image_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDistributionConfigurationOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the distribution configuration that was deleted.</p>
    pub distribution_configuration_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteDistributionConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDistributionConfigurationOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field(
            "distribution_configuration_arn",
            &self.distribution_configuration_arn,
        );
        formatter.finish()
    }
}
/// See [`DeleteDistributionConfigurationOutput`](crate::output::DeleteDistributionConfigurationOutput)
pub mod delete_distribution_configuration_output {
    /// A builder for [`DeleteDistributionConfigurationOutput`](crate::output::DeleteDistributionConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) distribution_configuration_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration that was deleted.</p>
        pub fn distribution_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.distribution_configuration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration that was deleted.</p>
        pub fn set_distribution_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.distribution_configuration_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDistributionConfigurationOutput`](crate::output::DeleteDistributionConfigurationOutput)
        pub fn build(self) -> crate::output::DeleteDistributionConfigurationOutput {
            crate::output::DeleteDistributionConfigurationOutput {
                request_id: self.request_id,
                distribution_configuration_arn: self.distribution_configuration_arn,
            }
        }
    }
}
impl DeleteDistributionConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDistributionConfigurationOutput`](crate::output::DeleteDistributionConfigurationOutput)
    pub fn builder() -> crate::output::delete_distribution_configuration_output::Builder {
        crate::output::delete_distribution_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteContainerRecipeOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the container recipe that was deleted.</p>
    pub container_recipe_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteContainerRecipeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteContainerRecipeOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("container_recipe_arn", &self.container_recipe_arn);
        formatter.finish()
    }
}
/// See [`DeleteContainerRecipeOutput`](crate::output::DeleteContainerRecipeOutput)
pub mod delete_container_recipe_output {
    /// A builder for [`DeleteContainerRecipeOutput`](crate::output::DeleteContainerRecipeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) container_recipe_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe that was deleted.</p>
        pub fn container_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_recipe_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe that was deleted.</p>
        pub fn set_container_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_recipe_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteContainerRecipeOutput`](crate::output::DeleteContainerRecipeOutput)
        pub fn build(self) -> crate::output::DeleteContainerRecipeOutput {
            crate::output::DeleteContainerRecipeOutput {
                request_id: self.request_id,
                container_recipe_arn: self.container_recipe_arn,
            }
        }
    }
}
impl DeleteContainerRecipeOutput {
    /// Creates a new builder-style object to manufacture [`DeleteContainerRecipeOutput`](crate::output::DeleteContainerRecipeOutput)
    pub fn builder() -> crate::output::delete_container_recipe_output::Builder {
        crate::output::delete_container_recipe_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteComponentOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the component build version that was deleted.</p>
    pub component_build_version_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteComponentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteComponentOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field(
            "component_build_version_arn",
            &self.component_build_version_arn,
        );
        formatter.finish()
    }
}
/// See [`DeleteComponentOutput`](crate::output::DeleteComponentOutput)
pub mod delete_component_output {
    /// A builder for [`DeleteComponentOutput`](crate::output::DeleteComponentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) component_build_version_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the component build version that was deleted.</p>
        pub fn component_build_version_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.component_build_version_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the component build version that was deleted.</p>
        pub fn set_component_build_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_build_version_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteComponentOutput`](crate::output::DeleteComponentOutput)
        pub fn build(self) -> crate::output::DeleteComponentOutput {
            crate::output::DeleteComponentOutput {
                request_id: self.request_id,
                component_build_version_arn: self.component_build_version_arn,
            }
        }
    }
}
impl DeleteComponentOutput {
    /// Creates a new builder-style object to manufacture [`DeleteComponentOutput`](crate::output::DeleteComponentOutput)
    pub fn builder() -> crate::output::delete_component_output::Builder {
        crate::output::delete_component_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateInfrastructureConfigurationOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The idempotency token used to make this request idempotent.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that was created by
    /// this request.</p>
    pub infrastructure_configuration_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateInfrastructureConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateInfrastructureConfigurationOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("client_token", &self.client_token);
        formatter.field(
            "infrastructure_configuration_arn",
            &self.infrastructure_configuration_arn,
        );
        formatter.finish()
    }
}
/// See [`CreateInfrastructureConfigurationOutput`](crate::output::CreateInfrastructureConfigurationOutput)
pub mod create_infrastructure_configuration_output {
    /// A builder for [`CreateInfrastructureConfigurationOutput`](crate::output::CreateInfrastructureConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) infrastructure_configuration_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that was created by
        /// this request.</p>
        pub fn infrastructure_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.infrastructure_configuration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration that was created by
        /// this request.</p>
        pub fn set_infrastructure_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.infrastructure_configuration_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateInfrastructureConfigurationOutput`](crate::output::CreateInfrastructureConfigurationOutput)
        pub fn build(self) -> crate::output::CreateInfrastructureConfigurationOutput {
            crate::output::CreateInfrastructureConfigurationOutput {
                request_id: self.request_id,
                client_token: self.client_token,
                infrastructure_configuration_arn: self.infrastructure_configuration_arn,
            }
        }
    }
}
impl CreateInfrastructureConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`CreateInfrastructureConfigurationOutput`](crate::output::CreateInfrastructureConfigurationOutput)
    pub fn builder() -> crate::output::create_infrastructure_configuration_output::Builder {
        crate::output::create_infrastructure_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateImageRecipeOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The idempotency token used to make this request idempotent.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the image recipe that was created by this request.</p>
    pub image_recipe_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateImageRecipeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateImageRecipeOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("client_token", &self.client_token);
        formatter.field("image_recipe_arn", &self.image_recipe_arn);
        formatter.finish()
    }
}
/// See [`CreateImageRecipeOutput`](crate::output::CreateImageRecipeOutput)
pub mod create_image_recipe_output {
    /// A builder for [`CreateImageRecipeOutput`](crate::output::CreateImageRecipeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) image_recipe_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe that was created by this request.</p>
        pub fn image_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_recipe_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe that was created by this request.</p>
        pub fn set_image_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_recipe_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateImageRecipeOutput`](crate::output::CreateImageRecipeOutput)
        pub fn build(self) -> crate::output::CreateImageRecipeOutput {
            crate::output::CreateImageRecipeOutput {
                request_id: self.request_id,
                client_token: self.client_token,
                image_recipe_arn: self.image_recipe_arn,
            }
        }
    }
}
impl CreateImageRecipeOutput {
    /// Creates a new builder-style object to manufacture [`CreateImageRecipeOutput`](crate::output::CreateImageRecipeOutput)
    pub fn builder() -> crate::output::create_image_recipe_output::Builder {
        crate::output::create_image_recipe_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateImagePipelineOutput {
    /// <p> The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p> The idempotency token used to make this request idempotent.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) of the image pipeline that was created by this request.</p>
    pub image_pipeline_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateImagePipelineOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateImagePipelineOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("client_token", &self.client_token);
        formatter.field("image_pipeline_arn", &self.image_pipeline_arn);
        formatter.finish()
    }
}
/// See [`CreateImagePipelineOutput`](crate::output::CreateImagePipelineOutput)
pub mod create_image_pipeline_output {
    /// A builder for [`CreateImagePipelineOutput`](crate::output::CreateImagePipelineOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) image_pipeline_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p> The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p> The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p> The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the image pipeline that was created by this request.</p>
        pub fn image_pipeline_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_pipeline_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the image pipeline that was created by this request.</p>
        pub fn set_image_pipeline_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_pipeline_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateImagePipelineOutput`](crate::output::CreateImagePipelineOutput)
        pub fn build(self) -> crate::output::CreateImagePipelineOutput {
            crate::output::CreateImagePipelineOutput {
                request_id: self.request_id,
                client_token: self.client_token,
                image_pipeline_arn: self.image_pipeline_arn,
            }
        }
    }
}
impl CreateImagePipelineOutput {
    /// Creates a new builder-style object to manufacture [`CreateImagePipelineOutput`](crate::output::CreateImagePipelineOutput)
    pub fn builder() -> crate::output::create_image_pipeline_output::Builder {
        crate::output::create_image_pipeline_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateImageOutput {
    /// <p> The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p> The idempotency token used to make this request idempotent.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) of the image that was created by this request.</p>
    pub image_build_version_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateImageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateImageOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("client_token", &self.client_token);
        formatter.field("image_build_version_arn", &self.image_build_version_arn);
        formatter.finish()
    }
}
/// See [`CreateImageOutput`](crate::output::CreateImageOutput)
pub mod create_image_output {
    /// A builder for [`CreateImageOutput`](crate::output::CreateImageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) image_build_version_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p> The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p> The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p> The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the image that was created by this request.</p>
        pub fn image_build_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_build_version_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the image that was created by this request.</p>
        pub fn set_image_build_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_build_version_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateImageOutput`](crate::output::CreateImageOutput)
        pub fn build(self) -> crate::output::CreateImageOutput {
            crate::output::CreateImageOutput {
                request_id: self.request_id,
                client_token: self.client_token,
                image_build_version_arn: self.image_build_version_arn,
            }
        }
    }
}
impl CreateImageOutput {
    /// Creates a new builder-style object to manufacture [`CreateImageOutput`](crate::output::CreateImageOutput)
    pub fn builder() -> crate::output::create_image_output::Builder {
        crate::output::create_image_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDistributionConfigurationOutput {
    /// <p> The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p> The idempotency token used to make this request idempotent.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) of the distribution configuration that was created by this
    /// request.</p>
    pub distribution_configuration_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateDistributionConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDistributionConfigurationOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("client_token", &self.client_token);
        formatter.field(
            "distribution_configuration_arn",
            &self.distribution_configuration_arn,
        );
        formatter.finish()
    }
}
/// See [`CreateDistributionConfigurationOutput`](crate::output::CreateDistributionConfigurationOutput)
pub mod create_distribution_configuration_output {
    /// A builder for [`CreateDistributionConfigurationOutput`](crate::output::CreateDistributionConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) distribution_configuration_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p> The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p> The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p> The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the distribution configuration that was created by this
        /// request.</p>
        pub fn distribution_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.distribution_configuration_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the distribution configuration that was created by this
        /// request.</p>
        pub fn set_distribution_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.distribution_configuration_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDistributionConfigurationOutput`](crate::output::CreateDistributionConfigurationOutput)
        pub fn build(self) -> crate::output::CreateDistributionConfigurationOutput {
            crate::output::CreateDistributionConfigurationOutput {
                request_id: self.request_id,
                client_token: self.client_token,
                distribution_configuration_arn: self.distribution_configuration_arn,
            }
        }
    }
}
impl CreateDistributionConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`CreateDistributionConfigurationOutput`](crate::output::CreateDistributionConfigurationOutput)
    pub fn builder() -> crate::output::create_distribution_configuration_output::Builder {
        crate::output::create_distribution_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateContainerRecipeOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The client token used to make this request idempotent.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>Returns the Amazon Resource Name (ARN) of the container recipe that the request created.</p>
    pub container_recipe_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateContainerRecipeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateContainerRecipeOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("client_token", &self.client_token);
        formatter.field("container_recipe_arn", &self.container_recipe_arn);
        formatter.finish()
    }
}
/// See [`CreateContainerRecipeOutput`](crate::output::CreateContainerRecipeOutput)
pub mod create_container_recipe_output {
    /// A builder for [`CreateContainerRecipeOutput`](crate::output::CreateContainerRecipeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) container_recipe_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The client token used to make this request idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The client token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>Returns the Amazon Resource Name (ARN) of the container recipe that the request created.</p>
        pub fn container_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_recipe_arn = Some(input.into());
            self
        }
        /// <p>Returns the Amazon Resource Name (ARN) of the container recipe that the request created.</p>
        pub fn set_container_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_recipe_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateContainerRecipeOutput`](crate::output::CreateContainerRecipeOutput)
        pub fn build(self) -> crate::output::CreateContainerRecipeOutput {
            crate::output::CreateContainerRecipeOutput {
                request_id: self.request_id,
                client_token: self.client_token,
                container_recipe_arn: self.container_recipe_arn,
            }
        }
    }
}
impl CreateContainerRecipeOutput {
    /// Creates a new builder-style object to manufacture [`CreateContainerRecipeOutput`](crate::output::CreateContainerRecipeOutput)
    pub fn builder() -> crate::output::create_container_recipe_output::Builder {
        crate::output::create_container_recipe_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateComponentOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The idempotency token used to make this request idempotent.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the component that was created by this request.</p>
    pub component_build_version_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateComponentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateComponentOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("client_token", &self.client_token);
        formatter.field(
            "component_build_version_arn",
            &self.component_build_version_arn,
        );
        formatter.finish()
    }
}
/// See [`CreateComponentOutput`](crate::output::CreateComponentOutput)
pub mod create_component_output {
    /// A builder for [`CreateComponentOutput`](crate::output::CreateComponentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) component_build_version_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the component that was created by this request.</p>
        pub fn component_build_version_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.component_build_version_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the component that was created by this request.</p>
        pub fn set_component_build_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_build_version_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateComponentOutput`](crate::output::CreateComponentOutput)
        pub fn build(self) -> crate::output::CreateComponentOutput {
            crate::output::CreateComponentOutput {
                request_id: self.request_id,
                client_token: self.client_token,
                component_build_version_arn: self.component_build_version_arn,
            }
        }
    }
}
impl CreateComponentOutput {
    /// Creates a new builder-style object to manufacture [`CreateComponentOutput`](crate::output::CreateComponentOutput)
    pub fn builder() -> crate::output::create_component_output::Builder {
        crate::output::create_component_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelImageCreationOutput {
    /// <p>The request ID that uniquely identifies this request.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>The idempotency token used to make this request idempotent.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the image whose creation has been cancelled.</p>
    pub image_build_version_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CancelImageCreationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelImageCreationOutput");
        formatter.field("request_id", &self.request_id);
        formatter.field("client_token", &self.client_token);
        formatter.field("image_build_version_arn", &self.image_build_version_arn);
        formatter.finish()
    }
}
/// See [`CancelImageCreationOutput`](crate::output::CancelImageCreationOutput)
pub mod cancel_image_creation_output {
    /// A builder for [`CancelImageCreationOutput`](crate::output::CancelImageCreationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) image_build_version_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The request ID that uniquely identifies this request.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The idempotency token used to make this request idempotent.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image whose creation has been cancelled.</p>
        pub fn image_build_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_build_version_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image whose creation has been cancelled.</p>
        pub fn set_image_build_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_build_version_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelImageCreationOutput`](crate::output::CancelImageCreationOutput)
        pub fn build(self) -> crate::output::CancelImageCreationOutput {
            crate::output::CancelImageCreationOutput {
                request_id: self.request_id,
                client_token: self.client_token,
                image_build_version_arn: self.image_build_version_arn,
            }
        }
    }
}
impl CancelImageCreationOutput {
    /// Creates a new builder-style object to manufacture [`CancelImageCreationOutput`](crate::output::CancelImageCreationOutput)
    pub fn builder() -> crate::output::cancel_image_creation_output::Builder {
        crate::output::cancel_image_creation_output::Builder::default()
    }
}
