// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The instance metadata options that apply to the HTTP requests that
/// pipeline builds use to launch EC2 build and test instances. For more
/// information about instance metadata options, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-options.html">Configure
/// the instance metadata options</a> in the <i>
/// <i>Amazon EC2 User Guide</i>
/// </i>
/// for Linux instances, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/configuring-instance-metadata-options.html">Configure
/// the instance metadata options</a> in the <i>
/// <i>Amazon EC2 Windows Guide</i>
/// </i>
/// for Windows instances.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceMetadataOptions {
    /// <p>Indicates whether a signed token header is required for instance metadata retrieval requests.
    /// The values affect the response as follows:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>required</b> – When you retrieve the
    /// IAM role credentials, version 2.0 credentials are returned in all cases.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>optional</b> – You can include a signed token header
    /// in your request to retrieve instance metadata, or you can leave it out. If you
    /// include it, version 2.0 credentials are returned for the IAM role. Otherwise,
    /// version 1.0 credentials are returned.</p>
    /// </li>
    /// </ul>
    /// <p>The default setting is <b>optional</b>.</p>
    pub http_tokens: std::option::Option<std::string::String>,
    /// <p>Limit the number of hops that an instance metadata request can traverse to reach its
    /// destination.</p>
    pub http_put_response_hop_limit: std::option::Option<i32>,
}
impl std::fmt::Debug for InstanceMetadataOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceMetadataOptions");
        formatter.field("http_tokens", &self.http_tokens);
        formatter.field(
            "http_put_response_hop_limit",
            &self.http_put_response_hop_limit,
        );
        formatter.finish()
    }
}
/// See [`InstanceMetadataOptions`](crate::model::InstanceMetadataOptions)
pub mod instance_metadata_options {
    /// A builder for [`InstanceMetadataOptions`](crate::model::InstanceMetadataOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) http_tokens: std::option::Option<std::string::String>,
        pub(crate) http_put_response_hop_limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Indicates whether a signed token header is required for instance metadata retrieval requests.
        /// The values affect the response as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>required</b> – When you retrieve the
        /// IAM role credentials, version 2.0 credentials are returned in all cases.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>optional</b> – You can include a signed token header
        /// in your request to retrieve instance metadata, or you can leave it out. If you
        /// include it, version 2.0 credentials are returned for the IAM role. Otherwise,
        /// version 1.0 credentials are returned.</p>
        /// </li>
        /// </ul>
        /// <p>The default setting is <b>optional</b>.</p>
        pub fn http_tokens(mut self, input: impl Into<std::string::String>) -> Self {
            self.http_tokens = Some(input.into());
            self
        }
        /// <p>Indicates whether a signed token header is required for instance metadata retrieval requests.
        /// The values affect the response as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>required</b> – When you retrieve the
        /// IAM role credentials, version 2.0 credentials are returned in all cases.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>optional</b> – You can include a signed token header
        /// in your request to retrieve instance metadata, or you can leave it out. If you
        /// include it, version 2.0 credentials are returned for the IAM role. Otherwise,
        /// version 1.0 credentials are returned.</p>
        /// </li>
        /// </ul>
        /// <p>The default setting is <b>optional</b>.</p>
        pub fn set_http_tokens(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.http_tokens = input;
            self
        }
        /// <p>Limit the number of hops that an instance metadata request can traverse to reach its
        /// destination.</p>
        pub fn http_put_response_hop_limit(mut self, input: i32) -> Self {
            self.http_put_response_hop_limit = Some(input);
            self
        }
        /// <p>Limit the number of hops that an instance metadata request can traverse to reach its
        /// destination.</p>
        pub fn set_http_put_response_hop_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.http_put_response_hop_limit = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceMetadataOptions`](crate::model::InstanceMetadataOptions)
        pub fn build(self) -> crate::model::InstanceMetadataOptions {
            crate::model::InstanceMetadataOptions {
                http_tokens: self.http_tokens,
                http_put_response_hop_limit: self.http_put_response_hop_limit,
            }
        }
    }
}
impl InstanceMetadataOptions {
    /// Creates a new builder-style object to manufacture [`InstanceMetadataOptions`](crate::model::InstanceMetadataOptions)
    pub fn builder() -> crate::model::instance_metadata_options::Builder {
        crate::model::instance_metadata_options::Builder::default()
    }
}

/// <p>Logging configuration defines where Image Builder uploads your logs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Logging {
    /// <p>The Amazon S3 logging configuration.</p>
    pub s3_logs: std::option::Option<crate::model::S3Logs>,
}
impl std::fmt::Debug for Logging {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Logging");
        formatter.field("s3_logs", &self.s3_logs);
        formatter.finish()
    }
}
/// See [`Logging`](crate::model::Logging)
pub mod logging {
    /// A builder for [`Logging`](crate::model::Logging)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_logs: std::option::Option<crate::model::S3Logs>,
    }
    impl Builder {
        /// <p>The Amazon S3 logging configuration.</p>
        pub fn s3_logs(mut self, input: crate::model::S3Logs) -> Self {
            self.s3_logs = Some(input);
            self
        }
        /// <p>The Amazon S3 logging configuration.</p>
        pub fn set_s3_logs(mut self, input: std::option::Option<crate::model::S3Logs>) -> Self {
            self.s3_logs = input;
            self
        }
        /// Consumes the builder and constructs a [`Logging`](crate::model::Logging)
        pub fn build(self) -> crate::model::Logging {
            crate::model::Logging {
                s3_logs: self.s3_logs,
            }
        }
    }
}
impl Logging {
    /// Creates a new builder-style object to manufacture [`Logging`](crate::model::Logging)
    pub fn builder() -> crate::model::logging::Builder {
        crate::model::logging::Builder::default()
    }
}

/// <p>Amazon S3 logging configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Logs {
    /// <p>The Amazon S3 bucket in which to store the logs.</p>
    pub s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 path in which to store the logs.</p>
    pub s3_key_prefix: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for S3Logs {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Logs");
        formatter.field("s3_bucket_name", &self.s3_bucket_name);
        formatter.field("s3_key_prefix", &self.s3_key_prefix);
        formatter.finish()
    }
}
/// See [`S3Logs`](crate::model::S3Logs)
pub mod s3_logs {
    /// A builder for [`S3Logs`](crate::model::S3Logs)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) s3_key_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon S3 bucket in which to store the logs.</p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_name = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket in which to store the logs.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_name = input;
            self
        }
        /// <p>The Amazon S3 path in which to store the logs.</p>
        pub fn s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key_prefix = Some(input.into());
            self
        }
        /// <p>The Amazon S3 path in which to store the logs.</p>
        pub fn set_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_key_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Logs`](crate::model::S3Logs)
        pub fn build(self) -> crate::model::S3Logs {
            crate::model::S3Logs {
                s3_bucket_name: self.s3_bucket_name,
                s3_key_prefix: self.s3_key_prefix,
            }
        }
    }
}
impl S3Logs {
    /// Creates a new builder-style object to manufacture [`S3Logs`](crate::model::S3Logs)
    pub fn builder() -> crate::model::s3_logs::Builder {
        crate::model::s3_logs::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PipelineStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PipelineStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => PipelineStatus::Disabled,
            "ENABLED" => PipelineStatus::Enabled,
            other => PipelineStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PipelineStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PipelineStatus::from(s))
    }
}
impl PipelineStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PipelineStatus::Disabled => "DISABLED",
            PipelineStatus::Enabled => "ENABLED",
            PipelineStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for PipelineStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A schedule configures how often and when a pipeline will automatically create a new image.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Schedule {
    /// <p>The cron expression determines how often EC2 Image Builder evaluates your
    /// <code>pipelineExecutionStartCondition</code>.</p>
    /// <p>For information on how to format a cron expression in Image Builder, see <a href="https://docs.aws.amazon.com/imagebuilder/latest/userguide/image-builder-cron.html">Use cron
    /// expressions in EC2 Image Builder</a>.</p>
    pub schedule_expression: std::option::Option<std::string::String>,
    /// <p>The timezone that applies to the scheduling expression. For example, "Etc/UTC",
    /// "America/Los_Angeles" in the <a href="https://www.joda.org/joda-time/timezones.html">IANA
    /// timezone format</a>. If not specified this defaults to UTC.</p>
    pub timezone: std::option::Option<std::string::String>,
    /// <p>The condition configures when the pipeline should trigger a new image build. When the
    /// <code>pipelineExecutionStartCondition</code> is set to
    /// <code>EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE</code>, and you use semantic version
    /// filters on the base image or components in your image recipe, EC2 Image Builder will build a
    /// new image only when there are new versions of the image or components in your recipe that
    /// match the semantic version filter. When it is set to <code>EXPRESSION_MATCH_ONLY</code>, it
    /// will build a new image every time the CRON expression matches the current time. For semantic
    /// version syntax, see <a href="https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_CreateComponent.html">CreateComponent</a> in the <i> EC2 Image Builder API
    /// Reference</i>.</p>
    pub pipeline_execution_start_condition:
        std::option::Option<crate::model::PipelineExecutionStartCondition>,
}
impl std::fmt::Debug for Schedule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Schedule");
        formatter.field("schedule_expression", &self.schedule_expression);
        formatter.field("timezone", &self.timezone);
        formatter.field(
            "pipeline_execution_start_condition",
            &self.pipeline_execution_start_condition,
        );
        formatter.finish()
    }
}
/// See [`Schedule`](crate::model::Schedule)
pub mod schedule {
    /// A builder for [`Schedule`](crate::model::Schedule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schedule_expression: std::option::Option<std::string::String>,
        pub(crate) timezone: std::option::Option<std::string::String>,
        pub(crate) pipeline_execution_start_condition:
            std::option::Option<crate::model::PipelineExecutionStartCondition>,
    }
    impl Builder {
        /// <p>The cron expression determines how often EC2 Image Builder evaluates your
        /// <code>pipelineExecutionStartCondition</code>.</p>
        /// <p>For information on how to format a cron expression in Image Builder, see <a href="https://docs.aws.amazon.com/imagebuilder/latest/userguide/image-builder-cron.html">Use cron
        /// expressions in EC2 Image Builder</a>.</p>
        pub fn schedule_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_expression = Some(input.into());
            self
        }
        /// <p>The cron expression determines how often EC2 Image Builder evaluates your
        /// <code>pipelineExecutionStartCondition</code>.</p>
        /// <p>For information on how to format a cron expression in Image Builder, see <a href="https://docs.aws.amazon.com/imagebuilder/latest/userguide/image-builder-cron.html">Use cron
        /// expressions in EC2 Image Builder</a>.</p>
        pub fn set_schedule_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_expression = input;
            self
        }
        /// <p>The timezone that applies to the scheduling expression. For example, "Etc/UTC",
        /// "America/Los_Angeles" in the <a href="https://www.joda.org/joda-time/timezones.html">IANA
        /// timezone format</a>. If not specified this defaults to UTC.</p>
        pub fn timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.timezone = Some(input.into());
            self
        }
        /// <p>The timezone that applies to the scheduling expression. For example, "Etc/UTC",
        /// "America/Los_Angeles" in the <a href="https://www.joda.org/joda-time/timezones.html">IANA
        /// timezone format</a>. If not specified this defaults to UTC.</p>
        pub fn set_timezone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timezone = input;
            self
        }
        /// <p>The condition configures when the pipeline should trigger a new image build. When the
        /// <code>pipelineExecutionStartCondition</code> is set to
        /// <code>EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE</code>, and you use semantic version
        /// filters on the base image or components in your image recipe, EC2 Image Builder will build a
        /// new image only when there are new versions of the image or components in your recipe that
        /// match the semantic version filter. When it is set to <code>EXPRESSION_MATCH_ONLY</code>, it
        /// will build a new image every time the CRON expression matches the current time. For semantic
        /// version syntax, see <a href="https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_CreateComponent.html">CreateComponent</a> in the <i> EC2 Image Builder API
        /// Reference</i>.</p>
        pub fn pipeline_execution_start_condition(
            mut self,
            input: crate::model::PipelineExecutionStartCondition,
        ) -> Self {
            self.pipeline_execution_start_condition = Some(input);
            self
        }
        /// <p>The condition configures when the pipeline should trigger a new image build. When the
        /// <code>pipelineExecutionStartCondition</code> is set to
        /// <code>EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE</code>, and you use semantic version
        /// filters on the base image or components in your image recipe, EC2 Image Builder will build a
        /// new image only when there are new versions of the image or components in your recipe that
        /// match the semantic version filter. When it is set to <code>EXPRESSION_MATCH_ONLY</code>, it
        /// will build a new image every time the CRON expression matches the current time. For semantic
        /// version syntax, see <a href="https://docs.aws.amazon.com/imagebuilder/latest/APIReference/API_CreateComponent.html">CreateComponent</a> in the <i> EC2 Image Builder API
        /// Reference</i>.</p>
        pub fn set_pipeline_execution_start_condition(
            mut self,
            input: std::option::Option<crate::model::PipelineExecutionStartCondition>,
        ) -> Self {
            self.pipeline_execution_start_condition = input;
            self
        }
        /// Consumes the builder and constructs a [`Schedule`](crate::model::Schedule)
        pub fn build(self) -> crate::model::Schedule {
            crate::model::Schedule {
                schedule_expression: self.schedule_expression,
                timezone: self.timezone,
                pipeline_execution_start_condition: self.pipeline_execution_start_condition,
            }
        }
    }
}
impl Schedule {
    /// Creates a new builder-style object to manufacture [`Schedule`](crate::model::Schedule)
    pub fn builder() -> crate::model::schedule::Builder {
        crate::model::schedule::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PipelineExecutionStartCondition {
    #[allow(missing_docs)] // documentation missing in model
    ExpressionMatchAndDependencyUpdatesAvailable,
    #[allow(missing_docs)] // documentation missing in model
    ExpressionMatchOnly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PipelineExecutionStartCondition {
    fn from(s: &str) -> Self {
        match s {
            "EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE" => {
                PipelineExecutionStartCondition::ExpressionMatchAndDependencyUpdatesAvailable
            }
            "EXPRESSION_MATCH_ONLY" => PipelineExecutionStartCondition::ExpressionMatchOnly,
            other => PipelineExecutionStartCondition::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PipelineExecutionStartCondition {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PipelineExecutionStartCondition::from(s))
    }
}
impl PipelineExecutionStartCondition {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PipelineExecutionStartCondition::ExpressionMatchAndDependencyUpdatesAvailable => {
                "EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE"
            }
            PipelineExecutionStartCondition::ExpressionMatchOnly => "EXPRESSION_MATCH_ONLY",
            PipelineExecutionStartCondition::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE",
            "EXPRESSION_MATCH_ONLY",
        ]
    }
}
impl AsRef<str> for PipelineExecutionStartCondition {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Image tests configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageTestsConfiguration {
    /// <p>Defines if tests should be executed when building this image.</p>
    pub image_tests_enabled: std::option::Option<bool>,
    /// <p>The maximum time in minutes that tests are permitted to run.</p>
    pub timeout_minutes: std::option::Option<i32>,
}
impl std::fmt::Debug for ImageTestsConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageTestsConfiguration");
        formatter.field("image_tests_enabled", &self.image_tests_enabled);
        formatter.field("timeout_minutes", &self.timeout_minutes);
        formatter.finish()
    }
}
/// See [`ImageTestsConfiguration`](crate::model::ImageTestsConfiguration)
pub mod image_tests_configuration {
    /// A builder for [`ImageTestsConfiguration`](crate::model::ImageTestsConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_tests_enabled: std::option::Option<bool>,
        pub(crate) timeout_minutes: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Defines if tests should be executed when building this image.</p>
        pub fn image_tests_enabled(mut self, input: bool) -> Self {
            self.image_tests_enabled = Some(input);
            self
        }
        /// <p>Defines if tests should be executed when building this image.</p>
        pub fn set_image_tests_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.image_tests_enabled = input;
            self
        }
        /// <p>The maximum time in minutes that tests are permitted to run.</p>
        pub fn timeout_minutes(mut self, input: i32) -> Self {
            self.timeout_minutes = Some(input);
            self
        }
        /// <p>The maximum time in minutes that tests are permitted to run.</p>
        pub fn set_timeout_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_minutes = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageTestsConfiguration`](crate::model::ImageTestsConfiguration)
        pub fn build(self) -> crate::model::ImageTestsConfiguration {
            crate::model::ImageTestsConfiguration {
                image_tests_enabled: self.image_tests_enabled,
                timeout_minutes: self.timeout_minutes,
            }
        }
    }
}
impl ImageTestsConfiguration {
    /// Creates a new builder-style object to manufacture [`ImageTestsConfiguration`](crate::model::ImageTestsConfiguration)
    pub fn builder() -> crate::model::image_tests_configuration::Builder {
        crate::model::image_tests_configuration::Builder::default()
    }
}

/// <p> Defines the settings for a specific Region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Distribution {
    /// <p>The target Region.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The specific AMI settings; for example, launch permissions or AMI tags.</p>
    pub ami_distribution_configuration:
        std::option::Option<crate::model::AmiDistributionConfiguration>,
    /// <p>Container distribution settings for encryption, licensing, and sharing
    /// in a specific Region.</p>
    pub container_distribution_configuration:
        std::option::Option<crate::model::ContainerDistributionConfiguration>,
    /// <p>The License Manager Configuration to associate with the AMI in the specified
    /// Region.</p>
    pub license_configuration_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A group of launchTemplateConfiguration settings that apply to image distribution
    /// for specified accounts.</p>
    pub launch_template_configurations:
        std::option::Option<std::vec::Vec<crate::model::LaunchTemplateConfiguration>>,
}
impl std::fmt::Debug for Distribution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Distribution");
        formatter.field("region", &self.region);
        formatter.field(
            "ami_distribution_configuration",
            &self.ami_distribution_configuration,
        );
        formatter.field(
            "container_distribution_configuration",
            &self.container_distribution_configuration,
        );
        formatter.field(
            "license_configuration_arns",
            &self.license_configuration_arns,
        );
        formatter.field(
            "launch_template_configurations",
            &self.launch_template_configurations,
        );
        formatter.finish()
    }
}
/// See [`Distribution`](crate::model::Distribution)
pub mod distribution {
    /// A builder for [`Distribution`](crate::model::Distribution)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) ami_distribution_configuration:
            std::option::Option<crate::model::AmiDistributionConfiguration>,
        pub(crate) container_distribution_configuration:
            std::option::Option<crate::model::ContainerDistributionConfiguration>,
        pub(crate) license_configuration_arns:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) launch_template_configurations:
            std::option::Option<std::vec::Vec<crate::model::LaunchTemplateConfiguration>>,
    }
    impl Builder {
        /// <p>The target Region.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The target Region.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The specific AMI settings; for example, launch permissions or AMI tags.</p>
        pub fn ami_distribution_configuration(
            mut self,
            input: crate::model::AmiDistributionConfiguration,
        ) -> Self {
            self.ami_distribution_configuration = Some(input);
            self
        }
        /// <p>The specific AMI settings; for example, launch permissions or AMI tags.</p>
        pub fn set_ami_distribution_configuration(
            mut self,
            input: std::option::Option<crate::model::AmiDistributionConfiguration>,
        ) -> Self {
            self.ami_distribution_configuration = input;
            self
        }
        /// <p>Container distribution settings for encryption, licensing, and sharing
        /// in a specific Region.</p>
        pub fn container_distribution_configuration(
            mut self,
            input: crate::model::ContainerDistributionConfiguration,
        ) -> Self {
            self.container_distribution_configuration = Some(input);
            self
        }
        /// <p>Container distribution settings for encryption, licensing, and sharing
        /// in a specific Region.</p>
        pub fn set_container_distribution_configuration(
            mut self,
            input: std::option::Option<crate::model::ContainerDistributionConfiguration>,
        ) -> Self {
            self.container_distribution_configuration = input;
            self
        }
        /// Appends an item to `license_configuration_arns`.
        ///
        /// To override the contents of this collection use [`set_license_configuration_arns`](Self::set_license_configuration_arns).
        ///
        /// <p>The License Manager Configuration to associate with the AMI in the specified
        /// Region.</p>
        pub fn license_configuration_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.license_configuration_arns.unwrap_or_default();
            v.push(input.into());
            self.license_configuration_arns = Some(v);
            self
        }
        /// <p>The License Manager Configuration to associate with the AMI in the specified
        /// Region.</p>
        pub fn set_license_configuration_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.license_configuration_arns = input;
            self
        }
        /// Appends an item to `launch_template_configurations`.
        ///
        /// To override the contents of this collection use [`set_launch_template_configurations`](Self::set_launch_template_configurations).
        ///
        /// <p>A group of launchTemplateConfiguration settings that apply to image distribution
        /// for specified accounts.</p>
        pub fn launch_template_configurations(
            mut self,
            input: impl Into<crate::model::LaunchTemplateConfiguration>,
        ) -> Self {
            let mut v = self.launch_template_configurations.unwrap_or_default();
            v.push(input.into());
            self.launch_template_configurations = Some(v);
            self
        }
        /// <p>A group of launchTemplateConfiguration settings that apply to image distribution
        /// for specified accounts.</p>
        pub fn set_launch_template_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LaunchTemplateConfiguration>>,
        ) -> Self {
            self.launch_template_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`Distribution`](crate::model::Distribution)
        pub fn build(self) -> crate::model::Distribution {
            crate::model::Distribution {
                region: self.region,
                ami_distribution_configuration: self.ami_distribution_configuration,
                container_distribution_configuration: self.container_distribution_configuration,
                license_configuration_arns: self.license_configuration_arns,
                launch_template_configurations: self.launch_template_configurations,
            }
        }
    }
}
impl Distribution {
    /// Creates a new builder-style object to manufacture [`Distribution`](crate::model::Distribution)
    pub fn builder() -> crate::model::distribution::Builder {
        crate::model::distribution::Builder::default()
    }
}

/// <p>Identifies an Amazon EC2 launch template to use for a specific account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LaunchTemplateConfiguration {
    /// <p>Identifies the Amazon EC2 launch template to use.</p>
    pub launch_template_id: std::option::Option<std::string::String>,
    /// <p>The account ID that this configuration applies to.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>Set the specified Amazon EC2 launch template as the default launch template for the specified account.</p>
    pub set_default_version: bool,
}
impl std::fmt::Debug for LaunchTemplateConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LaunchTemplateConfiguration");
        formatter.field("launch_template_id", &self.launch_template_id);
        formatter.field("account_id", &self.account_id);
        formatter.field("set_default_version", &self.set_default_version);
        formatter.finish()
    }
}
/// See [`LaunchTemplateConfiguration`](crate::model::LaunchTemplateConfiguration)
pub mod launch_template_configuration {
    /// A builder for [`LaunchTemplateConfiguration`](crate::model::LaunchTemplateConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) launch_template_id: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) set_default_version: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Identifies the Amazon EC2 launch template to use.</p>
        pub fn launch_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_template_id = Some(input.into());
            self
        }
        /// <p>Identifies the Amazon EC2 launch template to use.</p>
        pub fn set_launch_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_template_id = input;
            self
        }
        /// <p>The account ID that this configuration applies to.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID that this configuration applies to.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>Set the specified Amazon EC2 launch template as the default launch template for the specified account.</p>
        pub fn set_default_version(mut self, input: bool) -> Self {
            self.set_default_version = Some(input);
            self
        }
        /// <p>Set the specified Amazon EC2 launch template as the default launch template for the specified account.</p>
        pub fn set_set_default_version(mut self, input: std::option::Option<bool>) -> Self {
            self.set_default_version = input;
            self
        }
        /// Consumes the builder and constructs a [`LaunchTemplateConfiguration`](crate::model::LaunchTemplateConfiguration)
        pub fn build(self) -> crate::model::LaunchTemplateConfiguration {
            crate::model::LaunchTemplateConfiguration {
                launch_template_id: self.launch_template_id,
                account_id: self.account_id,
                set_default_version: self.set_default_version.unwrap_or_default(),
            }
        }
    }
}
impl LaunchTemplateConfiguration {
    /// Creates a new builder-style object to manufacture [`LaunchTemplateConfiguration`](crate::model::LaunchTemplateConfiguration)
    pub fn builder() -> crate::model::launch_template_configuration::Builder {
        crate::model::launch_template_configuration::Builder::default()
    }
}

/// <p>Container distribution settings for encryption, licensing, and sharing in a specific Region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContainerDistributionConfiguration {
    /// <p>The description of the container distribution configuration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Tags that are attached to the container distribution configuration.</p>
    pub container_tags: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The destination repository for the container distribution configuration.</p>
    pub target_repository: std::option::Option<crate::model::TargetContainerRepository>,
}
impl std::fmt::Debug for ContainerDistributionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContainerDistributionConfiguration");
        formatter.field("description", &self.description);
        formatter.field("container_tags", &self.container_tags);
        formatter.field("target_repository", &self.target_repository);
        formatter.finish()
    }
}
/// See [`ContainerDistributionConfiguration`](crate::model::ContainerDistributionConfiguration)
pub mod container_distribution_configuration {
    /// A builder for [`ContainerDistributionConfiguration`](crate::model::ContainerDistributionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) container_tags: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) target_repository: std::option::Option<crate::model::TargetContainerRepository>,
    }
    impl Builder {
        /// <p>The description of the container distribution configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the container distribution configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `container_tags`.
        ///
        /// To override the contents of this collection use [`set_container_tags`](Self::set_container_tags).
        ///
        /// <p>Tags that are attached to the container distribution configuration.</p>
        pub fn container_tags(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.container_tags.unwrap_or_default();
            v.push(input.into());
            self.container_tags = Some(v);
            self
        }
        /// <p>Tags that are attached to the container distribution configuration.</p>
        pub fn set_container_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.container_tags = input;
            self
        }
        /// <p>The destination repository for the container distribution configuration.</p>
        pub fn target_repository(mut self, input: crate::model::TargetContainerRepository) -> Self {
            self.target_repository = Some(input);
            self
        }
        /// <p>The destination repository for the container distribution configuration.</p>
        pub fn set_target_repository(
            mut self,
            input: std::option::Option<crate::model::TargetContainerRepository>,
        ) -> Self {
            self.target_repository = input;
            self
        }
        /// Consumes the builder and constructs a [`ContainerDistributionConfiguration`](crate::model::ContainerDistributionConfiguration)
        pub fn build(self) -> crate::model::ContainerDistributionConfiguration {
            crate::model::ContainerDistributionConfiguration {
                description: self.description,
                container_tags: self.container_tags,
                target_repository: self.target_repository,
            }
        }
    }
}
impl ContainerDistributionConfiguration {
    /// Creates a new builder-style object to manufacture [`ContainerDistributionConfiguration`](crate::model::ContainerDistributionConfiguration)
    pub fn builder() -> crate::model::container_distribution_configuration::Builder {
        crate::model::container_distribution_configuration::Builder::default()
    }
}

/// <p>The container repository where the output container image is stored.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TargetContainerRepository {
    /// <p>Specifies the service in which this image was registered.</p>
    pub service: std::option::Option<crate::model::ContainerRepositoryService>,
    /// <p>The name of the container repository where the output container image is stored. This name is prefixed by the repository location.</p>
    pub repository_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TargetContainerRepository {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TargetContainerRepository");
        formatter.field("service", &self.service);
        formatter.field("repository_name", &self.repository_name);
        formatter.finish()
    }
}
/// See [`TargetContainerRepository`](crate::model::TargetContainerRepository)
pub mod target_container_repository {
    /// A builder for [`TargetContainerRepository`](crate::model::TargetContainerRepository)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service: std::option::Option<crate::model::ContainerRepositoryService>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the service in which this image was registered.</p>
        pub fn service(mut self, input: crate::model::ContainerRepositoryService) -> Self {
            self.service = Some(input);
            self
        }
        /// <p>Specifies the service in which this image was registered.</p>
        pub fn set_service(
            mut self,
            input: std::option::Option<crate::model::ContainerRepositoryService>,
        ) -> Self {
            self.service = input;
            self
        }
        /// <p>The name of the container repository where the output container image is stored. This name is prefixed by the repository location.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the container repository where the output container image is stored. This name is prefixed by the repository location.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// Consumes the builder and constructs a [`TargetContainerRepository`](crate::model::TargetContainerRepository)
        pub fn build(self) -> crate::model::TargetContainerRepository {
            crate::model::TargetContainerRepository {
                service: self.service,
                repository_name: self.repository_name,
            }
        }
    }
}
impl TargetContainerRepository {
    /// Creates a new builder-style object to manufacture [`TargetContainerRepository`](crate::model::TargetContainerRepository)
    pub fn builder() -> crate::model::target_container_repository::Builder {
        crate::model::target_container_repository::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContainerRepositoryService {
    #[allow(missing_docs)] // documentation missing in model
    Ecr,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContainerRepositoryService {
    fn from(s: &str) -> Self {
        match s {
            "ECR" => ContainerRepositoryService::Ecr,
            other => ContainerRepositoryService::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContainerRepositoryService {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContainerRepositoryService::from(s))
    }
}
impl ContainerRepositoryService {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContainerRepositoryService::Ecr => "ECR",
            ContainerRepositoryService::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ECR"]
    }
}
impl AsRef<str> for ContainerRepositoryService {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Define and configure the output AMIs of the pipeline.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AmiDistributionConfiguration {
    /// <p>The name of the output AMI.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the distribution configuration. Minimum and maximum length are in characters.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The ID of an account to which you want to distribute an image.</p>
    pub target_account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The tags to apply to AMIs distributed to this Region.</p>
    pub ami_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The KMS key identifier used to encrypt the distributed image.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p> Launch permissions can be used to configure which Amazon Web Services accounts can use the AMI to launch
    /// instances.</p>
    pub launch_permission: std::option::Option<crate::model::LaunchPermissionConfiguration>,
}
impl std::fmt::Debug for AmiDistributionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AmiDistributionConfiguration");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("target_account_ids", &self.target_account_ids);
        formatter.field("ami_tags", &self.ami_tags);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("launch_permission", &self.launch_permission);
        formatter.finish()
    }
}
/// See [`AmiDistributionConfiguration`](crate::model::AmiDistributionConfiguration)
pub mod ami_distribution_configuration {
    /// A builder for [`AmiDistributionConfiguration`](crate::model::AmiDistributionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) target_account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) ami_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) launch_permission:
            std::option::Option<crate::model::LaunchPermissionConfiguration>,
    }
    impl Builder {
        /// <p>The name of the output AMI.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the output AMI.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the distribution configuration. Minimum and maximum length are in characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the distribution configuration. Minimum and maximum length are in characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `target_account_ids`.
        ///
        /// To override the contents of this collection use [`set_target_account_ids`](Self::set_target_account_ids).
        ///
        /// <p>The ID of an account to which you want to distribute an image.</p>
        pub fn target_account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.target_account_ids.unwrap_or_default();
            v.push(input.into());
            self.target_account_ids = Some(v);
            self
        }
        /// <p>The ID of an account to which you want to distribute an image.</p>
        pub fn set_target_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.target_account_ids = input;
            self
        }
        /// Adds a key-value pair to `ami_tags`.
        ///
        /// To override the contents of this collection use [`set_ami_tags`](Self::set_ami_tags).
        ///
        /// <p>The tags to apply to AMIs distributed to this Region.</p>
        pub fn ami_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.ami_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.ami_tags = Some(hash_map);
            self
        }
        /// <p>The tags to apply to AMIs distributed to this Region.</p>
        pub fn set_ami_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.ami_tags = input;
            self
        }
        /// <p>The KMS key identifier used to encrypt the distributed image.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The KMS key identifier used to encrypt the distributed image.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p> Launch permissions can be used to configure which Amazon Web Services accounts can use the AMI to launch
        /// instances.</p>
        pub fn launch_permission(
            mut self,
            input: crate::model::LaunchPermissionConfiguration,
        ) -> Self {
            self.launch_permission = Some(input);
            self
        }
        /// <p> Launch permissions can be used to configure which Amazon Web Services accounts can use the AMI to launch
        /// instances.</p>
        pub fn set_launch_permission(
            mut self,
            input: std::option::Option<crate::model::LaunchPermissionConfiguration>,
        ) -> Self {
            self.launch_permission = input;
            self
        }
        /// Consumes the builder and constructs a [`AmiDistributionConfiguration`](crate::model::AmiDistributionConfiguration)
        pub fn build(self) -> crate::model::AmiDistributionConfiguration {
            crate::model::AmiDistributionConfiguration {
                name: self.name,
                description: self.description,
                target_account_ids: self.target_account_ids,
                ami_tags: self.ami_tags,
                kms_key_id: self.kms_key_id,
                launch_permission: self.launch_permission,
            }
        }
    }
}
impl AmiDistributionConfiguration {
    /// Creates a new builder-style object to manufacture [`AmiDistributionConfiguration`](crate::model::AmiDistributionConfiguration)
    pub fn builder() -> crate::model::ami_distribution_configuration::Builder {
        crate::model::ami_distribution_configuration::Builder::default()
    }
}

/// <p>Describes the configuration for a launch permission. The launch permission modification request is sent to the
/// <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyImageAttribute.html">Amazon EC2 ModifyImageAttribute</a>
/// API on behalf of the user for each Region they have selected to distribute the AMI. To make an AMI public,
/// set the launch permission authorized accounts to <code>all</code>. See the examples for making an AMI public at
/// <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyImageAttribute.html">Amazon EC2 ModifyImageAttribute</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LaunchPermissionConfiguration {
    /// <p>The Amazon Web Services account ID.</p>
    pub user_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the group.</p>
    pub user_groups: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for LaunchPermissionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LaunchPermissionConfiguration");
        formatter.field("user_ids", &self.user_ids);
        formatter.field("user_groups", &self.user_groups);
        formatter.finish()
    }
}
/// See [`LaunchPermissionConfiguration`](crate::model::LaunchPermissionConfiguration)
pub mod launch_permission_configuration {
    /// A builder for [`LaunchPermissionConfiguration`](crate::model::LaunchPermissionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) user_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `user_ids`.
        ///
        /// To override the contents of this collection use [`set_user_ids`](Self::set_user_ids).
        ///
        /// <p>The Amazon Web Services account ID.</p>
        pub fn user_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_ids.unwrap_or_default();
            v.push(input.into());
            self.user_ids = Some(v);
            self
        }
        /// <p>The Amazon Web Services account ID.</p>
        pub fn set_user_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_ids = input;
            self
        }
        /// Appends an item to `user_groups`.
        ///
        /// To override the contents of this collection use [`set_user_groups`](Self::set_user_groups).
        ///
        /// <p>The name of the group.</p>
        pub fn user_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.user_groups.unwrap_or_default();
            v.push(input.into());
            self.user_groups = Some(v);
            self
        }
        /// <p>The name of the group.</p>
        pub fn set_user_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.user_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`LaunchPermissionConfiguration`](crate::model::LaunchPermissionConfiguration)
        pub fn build(self) -> crate::model::LaunchPermissionConfiguration {
            crate::model::LaunchPermissionConfiguration {
                user_ids: self.user_ids,
                user_groups: self.user_groups,
            }
        }
    }
}
impl LaunchPermissionConfiguration {
    /// Creates a new builder-style object to manufacture [`LaunchPermissionConfiguration`](crate::model::LaunchPermissionConfiguration)
    pub fn builder() -> crate::model::launch_permission_configuration::Builder {
        crate::model::launch_permission_configuration::Builder::default()
    }
}

/// <p>The infrastructure used when building Amazon EC2 AMIs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InfrastructureConfigurationSummary {
    /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the infrastructure configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the infrastructure configuration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date on which the infrastructure configuration was created.</p>
    pub date_created: std::option::Option<std::string::String>,
    /// <p>The date on which the infrastructure configuration was last updated.</p>
    pub date_updated: std::option::Option<std::string::String>,
    /// <p>The tags attached to the image created by Image Builder.</p>
    pub resource_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The tags of the infrastructure configuration.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The instance types of the infrastructure configuration.</p>
    pub instance_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The instance profile of the infrastructure configuration.</p>
    pub instance_profile_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InfrastructureConfigurationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InfrastructureConfigurationSummary");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("date_created", &self.date_created);
        formatter.field("date_updated", &self.date_updated);
        formatter.field("resource_tags", &self.resource_tags);
        formatter.field("tags", &self.tags);
        formatter.field("instance_types", &self.instance_types);
        formatter.field("instance_profile_name", &self.instance_profile_name);
        formatter.finish()
    }
}
/// See [`InfrastructureConfigurationSummary`](crate::model::InfrastructureConfigurationSummary)
pub mod infrastructure_configuration_summary {
    /// A builder for [`InfrastructureConfigurationSummary`](crate::model::InfrastructureConfigurationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) date_created: std::option::Option<std::string::String>,
        pub(crate) date_updated: std::option::Option<std::string::String>,
        pub(crate) resource_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) instance_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) instance_profile_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the infrastructure configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the infrastructure configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the infrastructure configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the infrastructure configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date on which the infrastructure configuration was created.</p>
        pub fn date_created(mut self, input: impl Into<std::string::String>) -> Self {
            self.date_created = Some(input.into());
            self
        }
        /// <p>The date on which the infrastructure configuration was created.</p>
        pub fn set_date_created(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.date_created = input;
            self
        }
        /// <p>The date on which the infrastructure configuration was last updated.</p>
        pub fn date_updated(mut self, input: impl Into<std::string::String>) -> Self {
            self.date_updated = Some(input.into());
            self
        }
        /// <p>The date on which the infrastructure configuration was last updated.</p>
        pub fn set_date_updated(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.date_updated = input;
            self
        }
        /// Adds a key-value pair to `resource_tags`.
        ///
        /// To override the contents of this collection use [`set_resource_tags`](Self::set_resource_tags).
        ///
        /// <p>The tags attached to the image created by Image Builder.</p>
        pub fn resource_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.resource_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.resource_tags = Some(hash_map);
            self
        }
        /// <p>The tags attached to the image created by Image Builder.</p>
        pub fn set_resource_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.resource_tags = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags of the infrastructure configuration.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags of the infrastructure configuration.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `instance_types`.
        ///
        /// To override the contents of this collection use [`set_instance_types`](Self::set_instance_types).
        ///
        /// <p>The instance types of the infrastructure configuration.</p>
        pub fn instance_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_types.unwrap_or_default();
            v.push(input.into());
            self.instance_types = Some(v);
            self
        }
        /// <p>The instance types of the infrastructure configuration.</p>
        pub fn set_instance_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_types = input;
            self
        }
        /// <p>The instance profile of the infrastructure configuration.</p>
        pub fn instance_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_profile_name = Some(input.into());
            self
        }
        /// <p>The instance profile of the infrastructure configuration.</p>
        pub fn set_instance_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_profile_name = input;
            self
        }
        /// Consumes the builder and constructs a [`InfrastructureConfigurationSummary`](crate::model::InfrastructureConfigurationSummary)
        pub fn build(self) -> crate::model::InfrastructureConfigurationSummary {
            crate::model::InfrastructureConfigurationSummary {
                arn: self.arn,
                name: self.name,
                description: self.description,
                date_created: self.date_created,
                date_updated: self.date_updated,
                resource_tags: self.resource_tags,
                tags: self.tags,
                instance_types: self.instance_types,
                instance_profile_name: self.instance_profile_name,
            }
        }
    }
}
impl InfrastructureConfigurationSummary {
    /// Creates a new builder-style object to manufacture [`InfrastructureConfigurationSummary`](crate::model::InfrastructureConfigurationSummary)
    pub fn builder() -> crate::model::infrastructure_configuration_summary::Builder {
        crate::model::infrastructure_configuration_summary::Builder::default()
    }
}

/// <p>A filter name and value pair that is used to return a more specific list of results from a
/// list operation. Filters can be used to match a set of resources by specific criteria, such as
/// tags, attributes, or IDs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Filter {
    /// <p>The name of the filter. Filter names are case-sensitive.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The filter values. Filter values are case-sensitive.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for Filter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Filter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`Filter`](crate::model::Filter)
pub mod filter {
    /// A builder for [`Filter`](crate::model::Filter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the filter. Filter names are case-sensitive.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the filter. Filter names are case-sensitive.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The filter values. Filter values are case-sensitive.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The filter values. Filter values are case-sensitive.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`Filter`](crate::model::Filter)
        pub fn build(self) -> crate::model::Filter {
            crate::model::Filter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl Filter {
    /// Creates a new builder-style object to manufacture [`Filter`](crate::model::Filter)
    pub fn builder() -> crate::model::filter::Builder {
        crate::model::filter::Builder::default()
    }
}

/// <p>The defining characteristics of a specific version of an Image Builder image.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageVersion {
    /// <p>The Amazon Resource Name (ARN) of a specific version of an Image Builder image.</p>
    /// <note>
    /// <p>Semantic versioning is included in each object's Amazon Resource Name (ARN),
    /// at the level that applies to that object as follows:</p>
    /// <ol>
    /// <li>
    /// <p>Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are
    /// either left off entirely, or they are specified as wildcards, for example: x.x.x.</p>
    /// </li>
    /// <li>
    /// <p>Version ARNs have only the first three nodes: <major>.<minor>.<patch></p>
    /// </li>
    /// <li>
    /// <p>Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.</p>
    /// </li>
    /// </ol>
    /// </note>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of this specific version of an Image Builder image.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Specifies whether this image is an AMI or a container image.</p>
    pub r#type: std::option::Option<crate::model::ImageType>,
    /// <p>Details for a specific version of an Image Builder image. This version follows the semantic version syntax.</p>
    /// <note>
    /// <p>The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
    /// You can assign values for the first three, and can filter on all of them.</p>
    /// <p>
    /// <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including
    /// zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
    /// build number to the fourth node.</p>
    /// <p>
    /// <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for
    /// the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
    /// a date, such as 2021.01.01.</p>
    /// <p>
    /// <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x)
    /// to specify the most recent versions or nodes when selecting the base image or components for your
    /// recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be
    /// wildcards.</p>
    /// </note>
    pub version: std::option::Option<std::string::String>,
    /// <p>The platform of the image version, for example "Windows" or "Linux".</p>
    pub platform: std::option::Option<crate::model::Platform>,
    /// <p>The operating system version of the Amazon EC2 build instance. For example, Amazon Linux 2, Ubuntu 18, or
    /// Microsoft Windows Server 2019.</p>
    pub os_version: std::option::Option<std::string::String>,
    /// <p>The owner of the image version.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>The date on which this specific version of the Image Builder image was created.</p>
    pub date_created: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ImageVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageVersion");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("version", &self.version);
        formatter.field("platform", &self.platform);
        formatter.field("os_version", &self.os_version);
        formatter.field("owner", &self.owner);
        formatter.field("date_created", &self.date_created);
        formatter.finish()
    }
}
/// See [`ImageVersion`](crate::model::ImageVersion)
pub mod image_version {
    /// A builder for [`ImageVersion`](crate::model::ImageVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ImageType>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<crate::model::Platform>,
        pub(crate) os_version: std::option::Option<std::string::String>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) date_created: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of a specific version of an Image Builder image.</p>
        /// <note>
        /// <p>Semantic versioning is included in each object's Amazon Resource Name (ARN),
        /// at the level that applies to that object as follows:</p>
        /// <ol>
        /// <li>
        /// <p>Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are
        /// either left off entirely, or they are specified as wildcards, for example: x.x.x.</p>
        /// </li>
        /// <li>
        /// <p>Version ARNs have only the first three nodes: <major>.<minor>.<patch></p>
        /// </li>
        /// <li>
        /// <p>Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.</p>
        /// </li>
        /// </ol>
        /// </note>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a specific version of an Image Builder image.</p>
        /// <note>
        /// <p>Semantic versioning is included in each object's Amazon Resource Name (ARN),
        /// at the level that applies to that object as follows:</p>
        /// <ol>
        /// <li>
        /// <p>Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are
        /// either left off entirely, or they are specified as wildcards, for example: x.x.x.</p>
        /// </li>
        /// <li>
        /// <p>Version ARNs have only the first three nodes: <major>.<minor>.<patch></p>
        /// </li>
        /// <li>
        /// <p>Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.</p>
        /// </li>
        /// </ol>
        /// </note>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of this specific version of an Image Builder image.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of this specific version of an Image Builder image.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Specifies whether this image is an AMI or a container image.</p>
        pub fn r#type(mut self, input: crate::model::ImageType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Specifies whether this image is an AMI or a container image.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ImageType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Details for a specific version of an Image Builder image. This version follows the semantic version syntax.</p>
        /// <note>
        /// <p>The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
        /// You can assign values for the first three, and can filter on all of them.</p>
        /// <p>
        /// <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including
        /// zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
        /// build number to the fourth node.</p>
        /// <p>
        /// <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for
        /// the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
        /// a date, such as 2021.01.01.</p>
        /// <p>
        /// <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x)
        /// to specify the most recent versions or nodes when selecting the base image or components for your
        /// recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be
        /// wildcards.</p>
        /// </note>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>Details for a specific version of an Image Builder image. This version follows the semantic version syntax.</p>
        /// <note>
        /// <p>The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
        /// You can assign values for the first three, and can filter on all of them.</p>
        /// <p>
        /// <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including
        /// zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
        /// build number to the fourth node.</p>
        /// <p>
        /// <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for
        /// the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
        /// a date, such as 2021.01.01.</p>
        /// <p>
        /// <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x)
        /// to specify the most recent versions or nodes when selecting the base image or components for your
        /// recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be
        /// wildcards.</p>
        /// </note>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The platform of the image version, for example "Windows" or "Linux".</p>
        pub fn platform(mut self, input: crate::model::Platform) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p>The platform of the image version, for example "Windows" or "Linux".</p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.platform = input;
            self
        }
        /// <p>The operating system version of the Amazon EC2 build instance. For example, Amazon Linux 2, Ubuntu 18, or
        /// Microsoft Windows Server 2019.</p>
        pub fn os_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.os_version = Some(input.into());
            self
        }
        /// <p>The operating system version of the Amazon EC2 build instance. For example, Amazon Linux 2, Ubuntu 18, or
        /// Microsoft Windows Server 2019.</p>
        pub fn set_os_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.os_version = input;
            self
        }
        /// <p>The owner of the image version.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>The owner of the image version.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>The date on which this specific version of the Image Builder image was created.</p>
        pub fn date_created(mut self, input: impl Into<std::string::String>) -> Self {
            self.date_created = Some(input.into());
            self
        }
        /// <p>The date on which this specific version of the Image Builder image was created.</p>
        pub fn set_date_created(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.date_created = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageVersion`](crate::model::ImageVersion)
        pub fn build(self) -> crate::model::ImageVersion {
            crate::model::ImageVersion {
                arn: self.arn,
                name: self.name,
                r#type: self.r#type,
                version: self.version,
                platform: self.platform,
                os_version: self.os_version,
                owner: self.owner,
                date_created: self.date_created,
            }
        }
    }
}
impl ImageVersion {
    /// Creates a new builder-style object to manufacture [`ImageVersion`](crate::model::ImageVersion)
    pub fn builder() -> crate::model::image_version::Builder {
        crate::model::image_version::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Platform {
    #[allow(missing_docs)] // documentation missing in model
    Linux,
    #[allow(missing_docs)] // documentation missing in model
    Windows,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Platform {
    fn from(s: &str) -> Self {
        match s {
            "Linux" => Platform::Linux,
            "Windows" => Platform::Windows,
            other => Platform::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Platform {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Platform::from(s))
    }
}
impl Platform {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Platform::Linux => "Linux",
            Platform::Windows => "Windows",
            Platform::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Linux", "Windows"]
    }
}
impl AsRef<str> for Platform {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ImageType {
    #[allow(missing_docs)] // documentation missing in model
    Ami,
    #[allow(missing_docs)] // documentation missing in model
    Docker,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ImageType {
    fn from(s: &str) -> Self {
        match s {
            "AMI" => ImageType::Ami,
            "DOCKER" => ImageType::Docker,
            other => ImageType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ImageType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ImageType::from(s))
    }
}
impl ImageType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ImageType::Ami => "AMI",
            ImageType::Docker => "DOCKER",
            ImageType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AMI", "DOCKER"]
    }
}
impl AsRef<str> for ImageType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// _Note: `Ownership::Self` has been renamed to `::SelfValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Ownership {
    #[allow(missing_docs)] // documentation missing in model
    Amazon,
    /// _Note: `::Self` has been renamed to `::SelfValue`._
    SelfValue,
    #[allow(missing_docs)] // documentation missing in model
    Shared,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Ownership {
    fn from(s: &str) -> Self {
        match s {
            "Amazon" => Ownership::Amazon,
            "Self" => Ownership::SelfValue,
            "Shared" => Ownership::Shared,
            other => Ownership::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Ownership {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Ownership::from(s))
    }
}
impl Ownership {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Ownership::Amazon => "Amazon",
            Ownership::SelfValue => "Self",
            Ownership::Shared => "Shared",
            Ownership::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Amazon", "Self", "Shared"]
    }
}
impl AsRef<str> for Ownership {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A summary of an image recipe.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageRecipeSummary {
    /// <p>The Amazon Resource Name (ARN) of the image recipe.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the image recipe.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The platform of the image recipe.</p>
    pub platform: std::option::Option<crate::model::Platform>,
    /// <p>The owner of the image recipe.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>The base image of the image recipe.</p>
    pub parent_image: std::option::Option<std::string::String>,
    /// <p>The date on which this image recipe was created.</p>
    pub date_created: std::option::Option<std::string::String>,
    /// <p>The tags of the image recipe.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ImageRecipeSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageRecipeSummary");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("platform", &self.platform);
        formatter.field("owner", &self.owner);
        formatter.field("parent_image", &self.parent_image);
        formatter.field("date_created", &self.date_created);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ImageRecipeSummary`](crate::model::ImageRecipeSummary)
pub mod image_recipe_summary {
    /// A builder for [`ImageRecipeSummary`](crate::model::ImageRecipeSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<crate::model::Platform>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) parent_image: std::option::Option<std::string::String>,
        pub(crate) date_created: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the image recipe.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the image recipe.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the image recipe.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The platform of the image recipe.</p>
        pub fn platform(mut self, input: crate::model::Platform) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p>The platform of the image recipe.</p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.platform = input;
            self
        }
        /// <p>The owner of the image recipe.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>The owner of the image recipe.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>The base image of the image recipe.</p>
        pub fn parent_image(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_image = Some(input.into());
            self
        }
        /// <p>The base image of the image recipe.</p>
        pub fn set_parent_image(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parent_image = input;
            self
        }
        /// <p>The date on which this image recipe was created.</p>
        pub fn date_created(mut self, input: impl Into<std::string::String>) -> Self {
            self.date_created = Some(input.into());
            self
        }
        /// <p>The date on which this image recipe was created.</p>
        pub fn set_date_created(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.date_created = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags of the image recipe.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags of the image recipe.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageRecipeSummary`](crate::model::ImageRecipeSummary)
        pub fn build(self) -> crate::model::ImageRecipeSummary {
            crate::model::ImageRecipeSummary {
                arn: self.arn,
                name: self.name,
                platform: self.platform,
                owner: self.owner,
                parent_image: self.parent_image,
                date_created: self.date_created,
                tags: self.tags,
            }
        }
    }
}
impl ImageRecipeSummary {
    /// Creates a new builder-style object to manufacture [`ImageRecipeSummary`](crate::model::ImageRecipeSummary)
    pub fn builder() -> crate::model::image_recipe_summary::Builder {
        crate::model::image_recipe_summary::Builder::default()
    }
}

/// <p>Details of an image pipeline.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImagePipeline {
    /// <p>The Amazon Resource Name (ARN) of the image pipeline.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the image pipeline.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the image pipeline.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The platform of the image pipeline.</p>
    pub platform: std::option::Option<crate::model::Platform>,
    /// <p> Collects additional information about the image being created, including the operating
    /// system (OS) version and package list. This information is used to enhance the overall
    /// experience of using EC2 Image Builder. Enabled by default.</p>
    pub enhanced_image_metadata_enabled: std::option::Option<bool>,
    /// <p>The Amazon Resource Name (ARN) of the image recipe associated with this image
    /// pipeline.</p>
    pub image_recipe_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the container recipe that is used for this pipeline.</p>
    pub container_recipe_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration associated with this
    /// image pipeline.</p>
    pub infrastructure_configuration_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the distribution configuration associated with this
    /// image pipeline.</p>
    pub distribution_configuration_arn: std::option::Option<std::string::String>,
    /// <p>The image tests configuration of the image pipeline.</p>
    pub image_tests_configuration: std::option::Option<crate::model::ImageTestsConfiguration>,
    /// <p>The schedule of the image pipeline.</p>
    pub schedule: std::option::Option<crate::model::Schedule>,
    /// <p>The status of the image pipeline.</p>
    pub status: std::option::Option<crate::model::PipelineStatus>,
    /// <p>The date on which this image pipeline was created.</p>
    pub date_created: std::option::Option<std::string::String>,
    /// <p>The date on which this image pipeline was last updated.</p>
    pub date_updated: std::option::Option<std::string::String>,
    /// <p>The date on which this image pipeline was last run.</p>
    pub date_last_run: std::option::Option<std::string::String>,
    /// <p>The date on which this image pipeline will next be run.</p>
    pub date_next_run: std::option::Option<std::string::String>,
    /// <p>The tags of this image pipeline.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ImagePipeline {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImagePipeline");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("platform", &self.platform);
        formatter.field(
            "enhanced_image_metadata_enabled",
            &self.enhanced_image_metadata_enabled,
        );
        formatter.field("image_recipe_arn", &self.image_recipe_arn);
        formatter.field("container_recipe_arn", &self.container_recipe_arn);
        formatter.field(
            "infrastructure_configuration_arn",
            &self.infrastructure_configuration_arn,
        );
        formatter.field(
            "distribution_configuration_arn",
            &self.distribution_configuration_arn,
        );
        formatter.field("image_tests_configuration", &self.image_tests_configuration);
        formatter.field("schedule", &self.schedule);
        formatter.field("status", &self.status);
        formatter.field("date_created", &self.date_created);
        formatter.field("date_updated", &self.date_updated);
        formatter.field("date_last_run", &self.date_last_run);
        formatter.field("date_next_run", &self.date_next_run);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ImagePipeline`](crate::model::ImagePipeline)
pub mod image_pipeline {
    /// A builder for [`ImagePipeline`](crate::model::ImagePipeline)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<crate::model::Platform>,
        pub(crate) enhanced_image_metadata_enabled: std::option::Option<bool>,
        pub(crate) image_recipe_arn: std::option::Option<std::string::String>,
        pub(crate) container_recipe_arn: std::option::Option<std::string::String>,
        pub(crate) infrastructure_configuration_arn: std::option::Option<std::string::String>,
        pub(crate) distribution_configuration_arn: std::option::Option<std::string::String>,
        pub(crate) image_tests_configuration:
            std::option::Option<crate::model::ImageTestsConfiguration>,
        pub(crate) schedule: std::option::Option<crate::model::Schedule>,
        pub(crate) status: std::option::Option<crate::model::PipelineStatus>,
        pub(crate) date_created: std::option::Option<std::string::String>,
        pub(crate) date_updated: std::option::Option<std::string::String>,
        pub(crate) date_last_run: std::option::Option<std::string::String>,
        pub(crate) date_next_run: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the image pipeline.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the image pipeline.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the image pipeline.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the image pipeline.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the image pipeline.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The platform of the image pipeline.</p>
        pub fn platform(mut self, input: crate::model::Platform) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p>The platform of the image pipeline.</p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.platform = input;
            self
        }
        /// <p> Collects additional information about the image being created, including the operating
        /// system (OS) version and package list. This information is used to enhance the overall
        /// experience of using EC2 Image Builder. Enabled by default.</p>
        pub fn enhanced_image_metadata_enabled(mut self, input: bool) -> Self {
            self.enhanced_image_metadata_enabled = Some(input);
            self
        }
        /// <p> Collects additional information about the image being created, including the operating
        /// system (OS) version and package list. This information is used to enhance the overall
        /// experience of using EC2 Image Builder. Enabled by default.</p>
        pub fn set_enhanced_image_metadata_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enhanced_image_metadata_enabled = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe associated with this image
        /// pipeline.</p>
        pub fn image_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_recipe_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe associated with this image
        /// pipeline.</p>
        pub fn set_image_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_recipe_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe that is used for this pipeline.</p>
        pub fn container_recipe_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_recipe_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe that is used for this pipeline.</p>
        pub fn set_container_recipe_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_recipe_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration associated with this
        /// image pipeline.</p>
        pub fn infrastructure_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.infrastructure_configuration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration associated with this
        /// image pipeline.</p>
        pub fn set_infrastructure_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.infrastructure_configuration_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration associated with this
        /// image pipeline.</p>
        pub fn distribution_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.distribution_configuration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration associated with this
        /// image pipeline.</p>
        pub fn set_distribution_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.distribution_configuration_arn = input;
            self
        }
        /// <p>The image tests configuration of the image pipeline.</p>
        pub fn image_tests_configuration(
            mut self,
            input: crate::model::ImageTestsConfiguration,
        ) -> Self {
            self.image_tests_configuration = Some(input);
            self
        }
        /// <p>The image tests configuration of the image pipeline.</p>
        pub fn set_image_tests_configuration(
            mut self,
            input: std::option::Option<crate::model::ImageTestsConfiguration>,
        ) -> Self {
            self.image_tests_configuration = input;
            self
        }
        /// <p>The schedule of the image pipeline.</p>
        pub fn schedule(mut self, input: crate::model::Schedule) -> Self {
            self.schedule = Some(input);
            self
        }
        /// <p>The schedule of the image pipeline.</p>
        pub fn set_schedule(mut self, input: std::option::Option<crate::model::Schedule>) -> Self {
            self.schedule = input;
            self
        }
        /// <p>The status of the image pipeline.</p>
        pub fn status(mut self, input: crate::model::PipelineStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the image pipeline.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PipelineStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The date on which this image pipeline was created.</p>
        pub fn date_created(mut self, input: impl Into<std::string::String>) -> Self {
            self.date_created = Some(input.into());
            self
        }
        /// <p>The date on which this image pipeline was created.</p>
        pub fn set_date_created(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.date_created = input;
            self
        }
        /// <p>The date on which this image pipeline was last updated.</p>
        pub fn date_updated(mut self, input: impl Into<std::string::String>) -> Self {
            self.date_updated = Some(input.into());
            self
        }
        /// <p>The date on which this image pipeline was last updated.</p>
        pub fn set_date_updated(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.date_updated = input;
            self
        }
        /// <p>The date on which this image pipeline was last run.</p>
        pub fn date_last_run(mut self, input: impl Into<std::string::String>) -> Self {
            self.date_last_run = Some(input.into());
            self
        }
        /// <p>The date on which this image pipeline was last run.</p>
        pub fn set_date_last_run(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.date_last_run = input;
            self
        }
        /// <p>The date on which this image pipeline will next be run.</p>
        pub fn date_next_run(mut self, input: impl Into<std::string::String>) -> Self {
            self.date_next_run = Some(input.into());
            self
        }
        /// <p>The date on which this image pipeline will next be run.</p>
        pub fn set_date_next_run(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.date_next_run = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags of this image pipeline.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags of this image pipeline.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ImagePipeline`](crate::model::ImagePipeline)
        pub fn build(self) -> crate::model::ImagePipeline {
            crate::model::ImagePipeline {
                arn: self.arn,
                name: self.name,
                description: self.description,
                platform: self.platform,
                enhanced_image_metadata_enabled: self.enhanced_image_metadata_enabled,
                image_recipe_arn: self.image_recipe_arn,
                container_recipe_arn: self.container_recipe_arn,
                infrastructure_configuration_arn: self.infrastructure_configuration_arn,
                distribution_configuration_arn: self.distribution_configuration_arn,
                image_tests_configuration: self.image_tests_configuration,
                schedule: self.schedule,
                status: self.status,
                date_created: self.date_created,
                date_updated: self.date_updated,
                date_last_run: self.date_last_run,
                date_next_run: self.date_next_run,
                tags: self.tags,
            }
        }
    }
}
impl ImagePipeline {
    /// Creates a new builder-style object to manufacture [`ImagePipeline`](crate::model::ImagePipeline)
    pub fn builder() -> crate::model::image_pipeline::Builder {
        crate::model::image_pipeline::Builder::default()
    }
}

/// <p>An image summary.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageSummary {
    /// <p>The Amazon Resource Name (ARN) of the image.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the image.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Specifies whether this is an AMI or container image.</p>
    pub r#type: std::option::Option<crate::model::ImageType>,
    /// <p>The version of the image.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The platform of the image.</p>
    pub platform: std::option::Option<crate::model::Platform>,
    /// <p>The operating system version of the instance. For example, Amazon Linux 2, Ubuntu 18, or
    /// Microsoft Windows Server 2019.</p>
    pub os_version: std::option::Option<std::string::String>,
    /// <p>The state of the image.</p>
    pub state: std::option::Option<crate::model::ImageState>,
    /// <p>The owner of the image.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>The date on which this image was created.</p>
    pub date_created: std::option::Option<std::string::String>,
    /// <p>The output resources produced when creating this image.</p>
    pub output_resources: std::option::Option<crate::model::OutputResources>,
    /// <p>The tags of the image.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ImageSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageSummary");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("version", &self.version);
        formatter.field("platform", &self.platform);
        formatter.field("os_version", &self.os_version);
        formatter.field("state", &self.state);
        formatter.field("owner", &self.owner);
        formatter.field("date_created", &self.date_created);
        formatter.field("output_resources", &self.output_resources);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ImageSummary`](crate::model::ImageSummary)
pub mod image_summary {
    /// A builder for [`ImageSummary`](crate::model::ImageSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ImageType>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<crate::model::Platform>,
        pub(crate) os_version: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ImageState>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) date_created: std::option::Option<std::string::String>,
        pub(crate) output_resources: std::option::Option<crate::model::OutputResources>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the image.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the image.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the image.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Specifies whether this is an AMI or container image.</p>
        pub fn r#type(mut self, input: crate::model::ImageType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Specifies whether this is an AMI or container image.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ImageType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The version of the image.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the image.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The platform of the image.</p>
        pub fn platform(mut self, input: crate::model::Platform) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p>The platform of the image.</p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.platform = input;
            self
        }
        /// <p>The operating system version of the instance. For example, Amazon Linux 2, Ubuntu 18, or
        /// Microsoft Windows Server 2019.</p>
        pub fn os_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.os_version = Some(input.into());
            self
        }
        /// <p>The operating system version of the instance. For example, Amazon Linux 2, Ubuntu 18, or
        /// Microsoft Windows Server 2019.</p>
        pub fn set_os_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.os_version = input;
            self
        }
        /// <p>The state of the image.</p>
        pub fn state(mut self, input: crate::model::ImageState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the image.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::ImageState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The owner of the image.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>The owner of the image.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>The date on which this image was created.</p>
        pub fn date_created(mut self, input: impl Into<std::string::String>) -> Self {
            self.date_created = Some(input.into());
            self
        }
        /// <p>The date on which this image was created.</p>
        pub fn set_date_created(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.date_created = input;
            self
        }
        /// <p>The output resources produced when creating this image.</p>
        pub fn output_resources(mut self, input: crate::model::OutputResources) -> Self {
            self.output_resources = Some(input);
            self
        }
        /// <p>The output resources produced when creating this image.</p>
        pub fn set_output_resources(
            mut self,
            input: std::option::Option<crate::model::OutputResources>,
        ) -> Self {
            self.output_resources = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags of the image.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags of the image.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageSummary`](crate::model::ImageSummary)
        pub fn build(self) -> crate::model::ImageSummary {
            crate::model::ImageSummary {
                arn: self.arn,
                name: self.name,
                r#type: self.r#type,
                version: self.version,
                platform: self.platform,
                os_version: self.os_version,
                state: self.state,
                owner: self.owner,
                date_created: self.date_created,
                output_resources: self.output_resources,
                tags: self.tags,
            }
        }
    }
}
impl ImageSummary {
    /// Creates a new builder-style object to manufacture [`ImageSummary`](crate::model::ImageSummary)
    pub fn builder() -> crate::model::image_summary::Builder {
        crate::model::image_summary::Builder::default()
    }
}

/// <p>The resources produced by this image.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutputResources {
    /// <p>The Amazon EC2 AMIs created by this image.</p>
    pub amis: std::option::Option<std::vec::Vec<crate::model::Ami>>,
    /// <p>Container images that the pipeline has generated and stored in the output repository.</p>
    pub containers: std::option::Option<std::vec::Vec<crate::model::Container>>,
}
impl std::fmt::Debug for OutputResources {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutputResources");
        formatter.field("amis", &self.amis);
        formatter.field("containers", &self.containers);
        formatter.finish()
    }
}
/// See [`OutputResources`](crate::model::OutputResources)
pub mod output_resources {
    /// A builder for [`OutputResources`](crate::model::OutputResources)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amis: std::option::Option<std::vec::Vec<crate::model::Ami>>,
        pub(crate) containers: std::option::Option<std::vec::Vec<crate::model::Container>>,
    }
    impl Builder {
        /// Appends an item to `amis`.
        ///
        /// To override the contents of this collection use [`set_amis`](Self::set_amis).
        ///
        /// <p>The Amazon EC2 AMIs created by this image.</p>
        pub fn amis(mut self, input: impl Into<crate::model::Ami>) -> Self {
            let mut v = self.amis.unwrap_or_default();
            v.push(input.into());
            self.amis = Some(v);
            self
        }
        /// <p>The Amazon EC2 AMIs created by this image.</p>
        pub fn set_amis(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Ami>>,
        ) -> Self {
            self.amis = input;
            self
        }
        /// Appends an item to `containers`.
        ///
        /// To override the contents of this collection use [`set_containers`](Self::set_containers).
        ///
        /// <p>Container images that the pipeline has generated and stored in the output repository.</p>
        pub fn containers(mut self, input: impl Into<crate::model::Container>) -> Self {
            let mut v = self.containers.unwrap_or_default();
            v.push(input.into());
            self.containers = Some(v);
            self
        }
        /// <p>Container images that the pipeline has generated and stored in the output repository.</p>
        pub fn set_containers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Container>>,
        ) -> Self {
            self.containers = input;
            self
        }
        /// Consumes the builder and constructs a [`OutputResources`](crate::model::OutputResources)
        pub fn build(self) -> crate::model::OutputResources {
            crate::model::OutputResources {
                amis: self.amis,
                containers: self.containers,
            }
        }
    }
}
impl OutputResources {
    /// Creates a new builder-style object to manufacture [`OutputResources`](crate::model::OutputResources)
    pub fn builder() -> crate::model::output_resources::Builder {
        crate::model::output_resources::Builder::default()
    }
}

/// <p>A container encapsulates the runtime environment for an application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Container {
    /// <p>Containers and container images are Region-specific. This is the Region context for the container.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>A list of URIs for containers created in the context Region.</p>
    pub image_uris: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for Container {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Container");
        formatter.field("region", &self.region);
        formatter.field("image_uris", &self.image_uris);
        formatter.finish()
    }
}
/// See [`Container`](crate::model::Container)
pub mod container {
    /// A builder for [`Container`](crate::model::Container)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) image_uris: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Containers and container images are Region-specific. This is the Region context for the container.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>Containers and container images are Region-specific. This is the Region context for the container.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// Appends an item to `image_uris`.
        ///
        /// To override the contents of this collection use [`set_image_uris`](Self::set_image_uris).
        ///
        /// <p>A list of URIs for containers created in the context Region.</p>
        pub fn image_uris(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.image_uris.unwrap_or_default();
            v.push(input.into());
            self.image_uris = Some(v);
            self
        }
        /// <p>A list of URIs for containers created in the context Region.</p>
        pub fn set_image_uris(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.image_uris = input;
            self
        }
        /// Consumes the builder and constructs a [`Container`](crate::model::Container)
        pub fn build(self) -> crate::model::Container {
            crate::model::Container {
                region: self.region,
                image_uris: self.image_uris,
            }
        }
    }
}
impl Container {
    /// Creates a new builder-style object to manufacture [`Container`](crate::model::Container)
    pub fn builder() -> crate::model::container::Builder {
        crate::model::container::Builder::default()
    }
}

/// <p> Details of an Amazon EC2 AMI.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ami {
    /// <p>The Amazon Web Services Region of the Amazon EC2 AMI.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The AMI ID of the Amazon EC2 AMI.</p>
    pub image: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon EC2 AMI.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the Amazon EC2 AMI. Minimum and maximum length are in characters.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p> Image state shows the image status and the reason for that status.</p>
    pub state: std::option::Option<crate::model::ImageState>,
    /// <p>The account ID of the owner of the AMI.</p>
    pub account_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Ami {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ami");
        formatter.field("region", &self.region);
        formatter.field("image", &self.image);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("state", &self.state);
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}
/// See [`Ami`](crate::model::Ami)
pub mod ami {
    /// A builder for [`Ami`](crate::model::Ami)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) image: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ImageState>,
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services Region of the Amazon EC2 AMI.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region of the Amazon EC2 AMI.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The AMI ID of the Amazon EC2 AMI.</p>
        pub fn image(mut self, input: impl Into<std::string::String>) -> Self {
            self.image = Some(input.into());
            self
        }
        /// <p>The AMI ID of the Amazon EC2 AMI.</p>
        pub fn set_image(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image = input;
            self
        }
        /// <p>The name of the Amazon EC2 AMI.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon EC2 AMI.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the Amazon EC2 AMI. Minimum and maximum length are in characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the Amazon EC2 AMI. Minimum and maximum length are in characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> Image state shows the image status and the reason for that status.</p>
        pub fn state(mut self, input: crate::model::ImageState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p> Image state shows the image status and the reason for that status.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::ImageState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The account ID of the owner of the AMI.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID of the owner of the AMI.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Ami`](crate::model::Ami)
        pub fn build(self) -> crate::model::Ami {
            crate::model::Ami {
                region: self.region,
                image: self.image,
                name: self.name,
                description: self.description,
                state: self.state,
                account_id: self.account_id,
            }
        }
    }
}
impl Ami {
    /// Creates a new builder-style object to manufacture [`Ami`](crate::model::Ami)
    pub fn builder() -> crate::model::ami::Builder {
        crate::model::ami::Builder::default()
    }
}

/// <p> Image state shows the image status and the reason for that status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageState {
    /// <p>The status of the image.</p>
    pub status: std::option::Option<crate::model::ImageStatus>,
    /// <p>The reason for the image's status.</p>
    pub reason: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ImageState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageState");
        formatter.field("status", &self.status);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
/// See [`ImageState`](crate::model::ImageState)
pub mod image_state {
    /// A builder for [`ImageState`](crate::model::ImageState)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::ImageStatus>,
        pub(crate) reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The status of the image.</p>
        pub fn status(mut self, input: crate::model::ImageStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the image.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::ImageStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>The reason for the image's status.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>The reason for the image's status.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageState`](crate::model::ImageState)
        pub fn build(self) -> crate::model::ImageState {
            crate::model::ImageState {
                status: self.status,
                reason: self.reason,
            }
        }
    }
}
impl ImageState {
    /// Creates a new builder-style object to manufacture [`ImageState`](crate::model::ImageState)
    pub fn builder() -> crate::model::image_state::Builder {
        crate::model::image_state::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ImageStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Building,
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deprecated,
    #[allow(missing_docs)] // documentation missing in model
    Distributing,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Integrating,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Testing,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ImageStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => ImageStatus::Available,
            "BUILDING" => ImageStatus::Building,
            "CANCELLED" => ImageStatus::Cancelled,
            "CREATING" => ImageStatus::Creating,
            "DELETED" => ImageStatus::Deleted,
            "DEPRECATED" => ImageStatus::Deprecated,
            "DISTRIBUTING" => ImageStatus::Distributing,
            "FAILED" => ImageStatus::Failed,
            "INTEGRATING" => ImageStatus::Integrating,
            "PENDING" => ImageStatus::Pending,
            "TESTING" => ImageStatus::Testing,
            other => ImageStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ImageStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ImageStatus::from(s))
    }
}
impl ImageStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ImageStatus::Available => "AVAILABLE",
            ImageStatus::Building => "BUILDING",
            ImageStatus::Cancelled => "CANCELLED",
            ImageStatus::Creating => "CREATING",
            ImageStatus::Deleted => "DELETED",
            ImageStatus::Deprecated => "DEPRECATED",
            ImageStatus::Distributing => "DISTRIBUTING",
            ImageStatus::Failed => "FAILED",
            ImageStatus::Integrating => "INTEGRATING",
            ImageStatus::Pending => "PENDING",
            ImageStatus::Testing => "TESTING",
            ImageStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AVAILABLE",
            "BUILDING",
            "CANCELLED",
            "CREATING",
            "DELETED",
            "DEPRECATED",
            "DISTRIBUTING",
            "FAILED",
            "INTEGRATING",
            "PENDING",
            "TESTING",
        ]
    }
}
impl AsRef<str> for ImageStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a package installed on an Image Builder image.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImagePackage {
    /// <p>The name of the package as reported to the operating system package manager.</p>
    pub package_name: std::option::Option<std::string::String>,
    /// <p>The version of the package as reported to the operating system package manager.</p>
    pub package_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ImagePackage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImagePackage");
        formatter.field("package_name", &self.package_name);
        formatter.field("package_version", &self.package_version);
        formatter.finish()
    }
}
/// See [`ImagePackage`](crate::model::ImagePackage)
pub mod image_package {
    /// A builder for [`ImagePackage`](crate::model::ImagePackage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_name: std::option::Option<std::string::String>,
        pub(crate) package_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the package as reported to the operating system package manager.</p>
        pub fn package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_name = Some(input.into());
            self
        }
        /// <p>The name of the package as reported to the operating system package manager.</p>
        pub fn set_package_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_name = input;
            self
        }
        /// <p>The version of the package as reported to the operating system package manager.</p>
        pub fn package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_version = Some(input.into());
            self
        }
        /// <p>The version of the package as reported to the operating system package manager.</p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.package_version = input;
            self
        }
        /// Consumes the builder and constructs a [`ImagePackage`](crate::model::ImagePackage)
        pub fn build(self) -> crate::model::ImagePackage {
            crate::model::ImagePackage {
                package_name: self.package_name,
                package_version: self.package_version,
            }
        }
    }
}
impl ImagePackage {
    /// Creates a new builder-style object to manufacture [`ImagePackage`](crate::model::ImagePackage)
    pub fn builder() -> crate::model::image_package::Builder {
        crate::model::image_package::Builder::default()
    }
}

/// <p>A high-level overview of a distribution configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DistributionConfigurationSummary {
    /// <p>The Amazon Resource Name (ARN) of the distribution configuration.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the distribution configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the distribution configuration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date on which the distribution configuration was created.</p>
    pub date_created: std::option::Option<std::string::String>,
    /// <p>The date on which the distribution configuration was updated.</p>
    pub date_updated: std::option::Option<std::string::String>,
    /// <p>The tags associated with the distribution configuration.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A list of Regions where the container image is distributed to.</p>
    pub regions: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for DistributionConfigurationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DistributionConfigurationSummary");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("date_created", &self.date_created);
        formatter.field("date_updated", &self.date_updated);
        formatter.field("tags", &self.tags);
        formatter.field("regions", &self.regions);
        formatter.finish()
    }
}
/// See [`DistributionConfigurationSummary`](crate::model::DistributionConfigurationSummary)
pub mod distribution_configuration_summary {
    /// A builder for [`DistributionConfigurationSummary`](crate::model::DistributionConfigurationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) date_created: std::option::Option<std::string::String>,
        pub(crate) date_updated: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) regions: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the distribution configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the distribution configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the distribution configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the distribution configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date on which the distribution configuration was created.</p>
        pub fn date_created(mut self, input: impl Into<std::string::String>) -> Self {
            self.date_created = Some(input.into());
            self
        }
        /// <p>The date on which the distribution configuration was created.</p>
        pub fn set_date_created(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.date_created = input;
            self
        }
        /// <p>The date on which the distribution configuration was updated.</p>
        pub fn date_updated(mut self, input: impl Into<std::string::String>) -> Self {
            self.date_updated = Some(input.into());
            self
        }
        /// <p>The date on which the distribution configuration was updated.</p>
        pub fn set_date_updated(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.date_updated = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the distribution configuration.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags associated with the distribution configuration.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `regions`.
        ///
        /// To override the contents of this collection use [`set_regions`](Self::set_regions).
        ///
        /// <p>A list of Regions where the container image is distributed to.</p>
        pub fn regions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.regions.unwrap_or_default();
            v.push(input.into());
            self.regions = Some(v);
            self
        }
        /// <p>A list of Regions where the container image is distributed to.</p>
        pub fn set_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.regions = input;
            self
        }
        /// Consumes the builder and constructs a [`DistributionConfigurationSummary`](crate::model::DistributionConfigurationSummary)
        pub fn build(self) -> crate::model::DistributionConfigurationSummary {
            crate::model::DistributionConfigurationSummary {
                arn: self.arn,
                name: self.name,
                description: self.description,
                date_created: self.date_created,
                date_updated: self.date_updated,
                tags: self.tags,
                regions: self.regions,
            }
        }
    }
}
impl DistributionConfigurationSummary {
    /// Creates a new builder-style object to manufacture [`DistributionConfigurationSummary`](crate::model::DistributionConfigurationSummary)
    pub fn builder() -> crate::model::distribution_configuration_summary::Builder {
        crate::model::distribution_configuration_summary::Builder::default()
    }
}

/// <p>A summary of a container recipe</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContainerRecipeSummary {
    /// <p>The Amazon Resource Name (ARN) of the container recipe.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Specifies the type of container, such as "Docker".</p>
    pub container_type: std::option::Option<crate::model::ContainerType>,
    /// <p>The name of the container recipe.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The system platform for the container, such as Windows or Linux.</p>
    pub platform: std::option::Option<crate::model::Platform>,
    /// <p>The owner of the container recipe.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>The base image for the container recipe.</p>
    pub parent_image: std::option::Option<std::string::String>,
    /// <p>The date when this container recipe was created.</p>
    pub date_created: std::option::Option<std::string::String>,
    /// <p>Tags that are attached to the container recipe.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ContainerRecipeSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContainerRecipeSummary");
        formatter.field("arn", &self.arn);
        formatter.field("container_type", &self.container_type);
        formatter.field("name", &self.name);
        formatter.field("platform", &self.platform);
        formatter.field("owner", &self.owner);
        formatter.field("parent_image", &self.parent_image);
        formatter.field("date_created", &self.date_created);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ContainerRecipeSummary`](crate::model::ContainerRecipeSummary)
pub mod container_recipe_summary {
    /// A builder for [`ContainerRecipeSummary`](crate::model::ContainerRecipeSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) container_type: std::option::Option<crate::model::ContainerType>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<crate::model::Platform>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) parent_image: std::option::Option<std::string::String>,
        pub(crate) date_created: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the container recipe.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Specifies the type of container, such as "Docker".</p>
        pub fn container_type(mut self, input: crate::model::ContainerType) -> Self {
            self.container_type = Some(input);
            self
        }
        /// <p>Specifies the type of container, such as "Docker".</p>
        pub fn set_container_type(
            mut self,
            input: std::option::Option<crate::model::ContainerType>,
        ) -> Self {
            self.container_type = input;
            self
        }
        /// <p>The name of the container recipe.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the container recipe.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The system platform for the container, such as Windows or Linux.</p>
        pub fn platform(mut self, input: crate::model::Platform) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p>The system platform for the container, such as Windows or Linux.</p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.platform = input;
            self
        }
        /// <p>The owner of the container recipe.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>The owner of the container recipe.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>The base image for the container recipe.</p>
        pub fn parent_image(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_image = Some(input.into());
            self
        }
        /// <p>The base image for the container recipe.</p>
        pub fn set_parent_image(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parent_image = input;
            self
        }
        /// <p>The date when this container recipe was created.</p>
        pub fn date_created(mut self, input: impl Into<std::string::String>) -> Self {
            self.date_created = Some(input.into());
            self
        }
        /// <p>The date when this container recipe was created.</p>
        pub fn set_date_created(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.date_created = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags that are attached to the container recipe.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags that are attached to the container recipe.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ContainerRecipeSummary`](crate::model::ContainerRecipeSummary)
        pub fn build(self) -> crate::model::ContainerRecipeSummary {
            crate::model::ContainerRecipeSummary {
                arn: self.arn,
                container_type: self.container_type,
                name: self.name,
                platform: self.platform,
                owner: self.owner,
                parent_image: self.parent_image,
                date_created: self.date_created,
                tags: self.tags,
            }
        }
    }
}
impl ContainerRecipeSummary {
    /// Creates a new builder-style object to manufacture [`ContainerRecipeSummary`](crate::model::ContainerRecipeSummary)
    pub fn builder() -> crate::model::container_recipe_summary::Builder {
        crate::model::container_recipe_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContainerType {
    #[allow(missing_docs)] // documentation missing in model
    Docker,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContainerType {
    fn from(s: &str) -> Self {
        match s {
            "DOCKER" => ContainerType::Docker,
            other => ContainerType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContainerType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContainerType::from(s))
    }
}
impl ContainerType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContainerType::Docker => "DOCKER",
            ContainerType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DOCKER"]
    }
}
impl AsRef<str> for ContainerType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The defining characteristics of a specific version of an Amazon Web Services TOE component.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComponentVersion {
    /// <p>The Amazon Resource Name (ARN) of the component.</p>
    /// <note>
    /// <p>Semantic versioning is included in each object's Amazon Resource Name (ARN),
    /// at the level that applies to that object as follows:</p>
    /// <ol>
    /// <li>
    /// <p>Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are
    /// either left off entirely, or they are specified as wildcards, for example: x.x.x.</p>
    /// </li>
    /// <li>
    /// <p>Version ARNs have only the first three nodes: <major>.<minor>.<patch></p>
    /// </li>
    /// <li>
    /// <p>Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.</p>
    /// </li>
    /// </ol>
    /// </note>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the component.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The semantic version of the component.</p>
    /// <note>
    /// <p>The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
    /// You can assign values for the first three, and can filter on all of them.</p>
    /// <p>
    /// <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including
    /// zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
    /// build number to the fourth node.</p>
    /// <p>
    /// <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for
    /// the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
    /// a date, such as 2021.01.01.</p>
    /// <p>
    /// <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x)
    /// to specify the most recent versions or nodes when selecting the base image or components for your
    /// recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be
    /// wildcards.</p>
    /// </note>
    pub version: std::option::Option<std::string::String>,
    /// <p>The description of the component.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The platform of the component.</p>
    pub platform: std::option::Option<crate::model::Platform>,
    /// <p>he operating system (OS) version supported by the component. If the OS information is
    /// available, a prefix match is performed against the base image OS version during image recipe
    /// creation.</p>
    pub supported_os_versions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The type of the component denotes whether the component is used to build the image or only
    /// to test it.</p>
    pub r#type: std::option::Option<crate::model::ComponentType>,
    /// <p>The owner of the component.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>The date that the component was created.</p>
    pub date_created: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ComponentVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComponentVersion");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.field("description", &self.description);
        formatter.field("platform", &self.platform);
        formatter.field("supported_os_versions", &self.supported_os_versions);
        formatter.field("r#type", &self.r#type);
        formatter.field("owner", &self.owner);
        formatter.field("date_created", &self.date_created);
        formatter.finish()
    }
}
/// See [`ComponentVersion`](crate::model::ComponentVersion)
pub mod component_version {
    /// A builder for [`ComponentVersion`](crate::model::ComponentVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<crate::model::Platform>,
        pub(crate) supported_os_versions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) r#type: std::option::Option<crate::model::ComponentType>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) date_created: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the component.</p>
        /// <note>
        /// <p>Semantic versioning is included in each object's Amazon Resource Name (ARN),
        /// at the level that applies to that object as follows:</p>
        /// <ol>
        /// <li>
        /// <p>Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are
        /// either left off entirely, or they are specified as wildcards, for example: x.x.x.</p>
        /// </li>
        /// <li>
        /// <p>Version ARNs have only the first three nodes: <major>.<minor>.<patch></p>
        /// </li>
        /// <li>
        /// <p>Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.</p>
        /// </li>
        /// </ol>
        /// </note>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the component.</p>
        /// <note>
        /// <p>Semantic versioning is included in each object's Amazon Resource Name (ARN),
        /// at the level that applies to that object as follows:</p>
        /// <ol>
        /// <li>
        /// <p>Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are
        /// either left off entirely, or they are specified as wildcards, for example: x.x.x.</p>
        /// </li>
        /// <li>
        /// <p>Version ARNs have only the first three nodes: <major>.<minor>.<patch></p>
        /// </li>
        /// <li>
        /// <p>Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.</p>
        /// </li>
        /// </ol>
        /// </note>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the component.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The semantic version of the component.</p>
        /// <note>
        /// <p>The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
        /// You can assign values for the first three, and can filter on all of them.</p>
        /// <p>
        /// <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including
        /// zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
        /// build number to the fourth node.</p>
        /// <p>
        /// <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for
        /// the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
        /// a date, such as 2021.01.01.</p>
        /// <p>
        /// <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x)
        /// to specify the most recent versions or nodes when selecting the base image or components for your
        /// recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be
        /// wildcards.</p>
        /// </note>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The semantic version of the component.</p>
        /// <note>
        /// <p>The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
        /// You can assign values for the first three, and can filter on all of them.</p>
        /// <p>
        /// <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including
        /// zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
        /// build number to the fourth node.</p>
        /// <p>
        /// <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for
        /// the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
        /// a date, such as 2021.01.01.</p>
        /// <p>
        /// <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x)
        /// to specify the most recent versions or nodes when selecting the base image or components for your
        /// recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be
        /// wildcards.</p>
        /// </note>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The description of the component.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the component.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The platform of the component.</p>
        pub fn platform(mut self, input: crate::model::Platform) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p>The platform of the component.</p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.platform = input;
            self
        }
        /// Appends an item to `supported_os_versions`.
        ///
        /// To override the contents of this collection use [`set_supported_os_versions`](Self::set_supported_os_versions).
        ///
        /// <p>he operating system (OS) version supported by the component. If the OS information is
        /// available, a prefix match is performed against the base image OS version during image recipe
        /// creation.</p>
        pub fn supported_os_versions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.supported_os_versions.unwrap_or_default();
            v.push(input.into());
            self.supported_os_versions = Some(v);
            self
        }
        /// <p>he operating system (OS) version supported by the component. If the OS information is
        /// available, a prefix match is performed against the base image OS version during image recipe
        /// creation.</p>
        pub fn set_supported_os_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_os_versions = input;
            self
        }
        /// <p>The type of the component denotes whether the component is used to build the image or only
        /// to test it.</p>
        pub fn r#type(mut self, input: crate::model::ComponentType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the component denotes whether the component is used to build the image or only
        /// to test it.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ComponentType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The owner of the component.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>The owner of the component.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>The date that the component was created.</p>
        pub fn date_created(mut self, input: impl Into<std::string::String>) -> Self {
            self.date_created = Some(input.into());
            self
        }
        /// <p>The date that the component was created.</p>
        pub fn set_date_created(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.date_created = input;
            self
        }
        /// Consumes the builder and constructs a [`ComponentVersion`](crate::model::ComponentVersion)
        pub fn build(self) -> crate::model::ComponentVersion {
            crate::model::ComponentVersion {
                arn: self.arn,
                name: self.name,
                version: self.version,
                description: self.description,
                platform: self.platform,
                supported_os_versions: self.supported_os_versions,
                r#type: self.r#type,
                owner: self.owner,
                date_created: self.date_created,
            }
        }
    }
}
impl ComponentVersion {
    /// Creates a new builder-style object to manufacture [`ComponentVersion`](crate::model::ComponentVersion)
    pub fn builder() -> crate::model::component_version::Builder {
        crate::model::component_version::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComponentType {
    #[allow(missing_docs)] // documentation missing in model
    Build,
    #[allow(missing_docs)] // documentation missing in model
    Test,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComponentType {
    fn from(s: &str) -> Self {
        match s {
            "BUILD" => ComponentType::Build,
            "TEST" => ComponentType::Test,
            other => ComponentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComponentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComponentType::from(s))
    }
}
impl ComponentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComponentType::Build => "BUILD",
            ComponentType::Test => "TEST",
            ComponentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BUILD", "TEST"]
    }
}
impl AsRef<str> for ComponentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A high-level summary of a component.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComponentSummary {
    /// <p>The Amazon Resource Name (ARN) of the component.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the component.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the component.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The platform of the component.</p>
    pub platform: std::option::Option<crate::model::Platform>,
    /// <p>The operating system (OS) version supported by the component. If the OS information is
    /// available, a prefix match is performed against the base image OS version during image recipe
    /// creation.</p>
    pub supported_os_versions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Describes the current status of the component.</p>
    pub state: std::option::Option<crate::model::ComponentState>,
    /// <p>The type of the component denotes whether the component is used to build the image or only
    /// to test it.</p>
    pub r#type: std::option::Option<crate::model::ComponentType>,
    /// <p>The owner of the component.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>The description of the component.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The change description of the component.</p>
    pub change_description: std::option::Option<std::string::String>,
    /// <p>The date that the component was created.</p>
    pub date_created: std::option::Option<std::string::String>,
    /// <p>The tags associated with the component.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ComponentSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComponentSummary");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.field("platform", &self.platform);
        formatter.field("supported_os_versions", &self.supported_os_versions);
        formatter.field("state", &self.state);
        formatter.field("r#type", &self.r#type);
        formatter.field("owner", &self.owner);
        formatter.field("description", &self.description);
        formatter.field("change_description", &self.change_description);
        formatter.field("date_created", &self.date_created);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ComponentSummary`](crate::model::ComponentSummary)
pub mod component_summary {
    /// A builder for [`ComponentSummary`](crate::model::ComponentSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<crate::model::Platform>,
        pub(crate) supported_os_versions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) state: std::option::Option<crate::model::ComponentState>,
        pub(crate) r#type: std::option::Option<crate::model::ComponentType>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) change_description: std::option::Option<std::string::String>,
        pub(crate) date_created: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the component.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the component.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the component.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the component.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the component.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The platform of the component.</p>
        pub fn platform(mut self, input: crate::model::Platform) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p>The platform of the component.</p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.platform = input;
            self
        }
        /// Appends an item to `supported_os_versions`.
        ///
        /// To override the contents of this collection use [`set_supported_os_versions`](Self::set_supported_os_versions).
        ///
        /// <p>The operating system (OS) version supported by the component. If the OS information is
        /// available, a prefix match is performed against the base image OS version during image recipe
        /// creation.</p>
        pub fn supported_os_versions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.supported_os_versions.unwrap_or_default();
            v.push(input.into());
            self.supported_os_versions = Some(v);
            self
        }
        /// <p>The operating system (OS) version supported by the component. If the OS information is
        /// available, a prefix match is performed against the base image OS version during image recipe
        /// creation.</p>
        pub fn set_supported_os_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_os_versions = input;
            self
        }
        /// <p>Describes the current status of the component.</p>
        pub fn state(mut self, input: crate::model::ComponentState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>Describes the current status of the component.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ComponentState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The type of the component denotes whether the component is used to build the image or only
        /// to test it.</p>
        pub fn r#type(mut self, input: crate::model::ComponentType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the component denotes whether the component is used to build the image or only
        /// to test it.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ComponentType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The owner of the component.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>The owner of the component.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>The description of the component.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the component.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The change description of the component.</p>
        pub fn change_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_description = Some(input.into());
            self
        }
        /// <p>The change description of the component.</p>
        pub fn set_change_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.change_description = input;
            self
        }
        /// <p>The date that the component was created.</p>
        pub fn date_created(mut self, input: impl Into<std::string::String>) -> Self {
            self.date_created = Some(input.into());
            self
        }
        /// <p>The date that the component was created.</p>
        pub fn set_date_created(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.date_created = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the component.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags associated with the component.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ComponentSummary`](crate::model::ComponentSummary)
        pub fn build(self) -> crate::model::ComponentSummary {
            crate::model::ComponentSummary {
                arn: self.arn,
                name: self.name,
                version: self.version,
                platform: self.platform,
                supported_os_versions: self.supported_os_versions,
                state: self.state,
                r#type: self.r#type,
                owner: self.owner,
                description: self.description,
                change_description: self.change_description,
                date_created: self.date_created,
                tags: self.tags,
            }
        }
    }
}
impl ComponentSummary {
    /// Creates a new builder-style object to manufacture [`ComponentSummary`](crate::model::ComponentSummary)
    pub fn builder() -> crate::model::component_summary::Builder {
        crate::model::component_summary::Builder::default()
    }
}

/// <p>A group of fields that describe the current status of components
/// that are no longer active.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComponentState {
    /// <p>The current state of the component.</p>
    pub status: std::option::Option<crate::model::ComponentStatus>,
    /// <p>Describes how or why the component changed state.</p>
    pub reason: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ComponentState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComponentState");
        formatter.field("status", &self.status);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
/// See [`ComponentState`](crate::model::ComponentState)
pub mod component_state {
    /// A builder for [`ComponentState`](crate::model::ComponentState)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::ComponentStatus>,
        pub(crate) reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The current state of the component.</p>
        pub fn status(mut self, input: crate::model::ComponentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current state of the component.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ComponentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Describes how or why the component changed state.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>Describes how or why the component changed state.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`ComponentState`](crate::model::ComponentState)
        pub fn build(self) -> crate::model::ComponentState {
            crate::model::ComponentState {
                status: self.status,
                reason: self.reason,
            }
        }
    }
}
impl ComponentState {
    /// Creates a new builder-style object to manufacture [`ComponentState`](crate::model::ComponentState)
    pub fn builder() -> crate::model::component_state::Builder {
        crate::model::component_state::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComponentStatus {
    #[allow(missing_docs)] // documentation missing in model
    Deprecated,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComponentStatus {
    fn from(s: &str) -> Self {
        match s {
            "DEPRECATED" => ComponentStatus::Deprecated,
            other => ComponentStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComponentStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComponentStatus::from(s))
    }
}
impl ComponentStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComponentStatus::Deprecated => "DEPRECATED",
            ComponentStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEPRECATED"]
    }
}
impl AsRef<str> for ComponentStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComponentFormat {
    #[allow(missing_docs)] // documentation missing in model
    Shell,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComponentFormat {
    fn from(s: &str) -> Self {
        match s {
            "SHELL" => ComponentFormat::Shell,
            other => ComponentFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComponentFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComponentFormat::from(s))
    }
}
impl ComponentFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComponentFormat::Shell => "SHELL",
            ComponentFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SHELL"]
    }
}
impl AsRef<str> for ComponentFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details of the infrastructure configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InfrastructureConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the infrastructure configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the infrastructure configuration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The instance types of the infrastructure configuration.</p>
    pub instance_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The instance profile of the infrastructure configuration.</p>
    pub instance_profile_name: std::option::Option<std::string::String>,
    /// <p>The security group IDs of the infrastructure configuration.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The subnet ID of the infrastructure configuration.</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>The logging configuration of the infrastructure configuration.</p>
    pub logging: std::option::Option<crate::model::Logging>,
    /// <p>The Amazon EC2 key pair of the infrastructure configuration.</p>
    pub key_pair: std::option::Option<std::string::String>,
    /// <p>The terminate instance on failure configuration of the infrastructure
    /// configuration.</p>
    pub terminate_instance_on_failure: std::option::Option<bool>,
    /// <p>The SNS topic Amazon Resource Name (ARN) of the infrastructure configuration.</p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>The date on which the infrastructure configuration was created.</p>
    pub date_created: std::option::Option<std::string::String>,
    /// <p>The date on which the infrastructure configuration was last updated.</p>
    pub date_updated: std::option::Option<std::string::String>,
    /// <p>The tags attached to the resource created by Image Builder.</p>
    pub resource_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The instance metadata option settings for the infrastructure configuration.</p>
    pub instance_metadata_options: std::option::Option<crate::model::InstanceMetadataOptions>,
    /// <p>The tags of the infrastructure configuration.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for InfrastructureConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InfrastructureConfiguration");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("instance_types", &self.instance_types);
        formatter.field("instance_profile_name", &self.instance_profile_name);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("logging", &self.logging);
        formatter.field("key_pair", &self.key_pair);
        formatter.field(
            "terminate_instance_on_failure",
            &self.terminate_instance_on_failure,
        );
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field("date_created", &self.date_created);
        formatter.field("date_updated", &self.date_updated);
        formatter.field("resource_tags", &self.resource_tags);
        formatter.field("instance_metadata_options", &self.instance_metadata_options);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`InfrastructureConfiguration`](crate::model::InfrastructureConfiguration)
pub mod infrastructure_configuration {
    /// A builder for [`InfrastructureConfiguration`](crate::model::InfrastructureConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) instance_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) instance_profile_name: std::option::Option<std::string::String>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) logging: std::option::Option<crate::model::Logging>,
        pub(crate) key_pair: std::option::Option<std::string::String>,
        pub(crate) terminate_instance_on_failure: std::option::Option<bool>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) date_created: std::option::Option<std::string::String>,
        pub(crate) date_updated: std::option::Option<std::string::String>,
        pub(crate) resource_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) instance_metadata_options:
            std::option::Option<crate::model::InstanceMetadataOptions>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the infrastructure configuration.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the infrastructure configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the infrastructure configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the infrastructure configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the infrastructure configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `instance_types`.
        ///
        /// To override the contents of this collection use [`set_instance_types`](Self::set_instance_types).
        ///
        /// <p>The instance types of the infrastructure configuration.</p>
        pub fn instance_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_types.unwrap_or_default();
            v.push(input.into());
            self.instance_types = Some(v);
            self
        }
        /// <p>The instance types of the infrastructure configuration.</p>
        pub fn set_instance_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_types = input;
            self
        }
        /// <p>The instance profile of the infrastructure configuration.</p>
        pub fn instance_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_profile_name = Some(input.into());
            self
        }
        /// <p>The instance profile of the infrastructure configuration.</p>
        pub fn set_instance_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_profile_name = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The security group IDs of the infrastructure configuration.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>The security group IDs of the infrastructure configuration.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// <p>The subnet ID of the infrastructure configuration.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The subnet ID of the infrastructure configuration.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>The logging configuration of the infrastructure configuration.</p>
        pub fn logging(mut self, input: crate::model::Logging) -> Self {
            self.logging = Some(input);
            self
        }
        /// <p>The logging configuration of the infrastructure configuration.</p>
        pub fn set_logging(mut self, input: std::option::Option<crate::model::Logging>) -> Self {
            self.logging = input;
            self
        }
        /// <p>The Amazon EC2 key pair of the infrastructure configuration.</p>
        pub fn key_pair(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_pair = Some(input.into());
            self
        }
        /// <p>The Amazon EC2 key pair of the infrastructure configuration.</p>
        pub fn set_key_pair(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_pair = input;
            self
        }
        /// <p>The terminate instance on failure configuration of the infrastructure
        /// configuration.</p>
        pub fn terminate_instance_on_failure(mut self, input: bool) -> Self {
            self.terminate_instance_on_failure = Some(input);
            self
        }
        /// <p>The terminate instance on failure configuration of the infrastructure
        /// configuration.</p>
        pub fn set_terminate_instance_on_failure(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.terminate_instance_on_failure = input;
            self
        }
        /// <p>The SNS topic Amazon Resource Name (ARN) of the infrastructure configuration.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>The SNS topic Amazon Resource Name (ARN) of the infrastructure configuration.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// <p>The date on which the infrastructure configuration was created.</p>
        pub fn date_created(mut self, input: impl Into<std::string::String>) -> Self {
            self.date_created = Some(input.into());
            self
        }
        /// <p>The date on which the infrastructure configuration was created.</p>
        pub fn set_date_created(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.date_created = input;
            self
        }
        /// <p>The date on which the infrastructure configuration was last updated.</p>
        pub fn date_updated(mut self, input: impl Into<std::string::String>) -> Self {
            self.date_updated = Some(input.into());
            self
        }
        /// <p>The date on which the infrastructure configuration was last updated.</p>
        pub fn set_date_updated(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.date_updated = input;
            self
        }
        /// Adds a key-value pair to `resource_tags`.
        ///
        /// To override the contents of this collection use [`set_resource_tags`](Self::set_resource_tags).
        ///
        /// <p>The tags attached to the resource created by Image Builder.</p>
        pub fn resource_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.resource_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.resource_tags = Some(hash_map);
            self
        }
        /// <p>The tags attached to the resource created by Image Builder.</p>
        pub fn set_resource_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.resource_tags = input;
            self
        }
        /// <p>The instance metadata option settings for the infrastructure configuration.</p>
        pub fn instance_metadata_options(
            mut self,
            input: crate::model::InstanceMetadataOptions,
        ) -> Self {
            self.instance_metadata_options = Some(input);
            self
        }
        /// <p>The instance metadata option settings for the infrastructure configuration.</p>
        pub fn set_instance_metadata_options(
            mut self,
            input: std::option::Option<crate::model::InstanceMetadataOptions>,
        ) -> Self {
            self.instance_metadata_options = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags of the infrastructure configuration.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags of the infrastructure configuration.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`InfrastructureConfiguration`](crate::model::InfrastructureConfiguration)
        pub fn build(self) -> crate::model::InfrastructureConfiguration {
            crate::model::InfrastructureConfiguration {
                arn: self.arn,
                name: self.name,
                description: self.description,
                instance_types: self.instance_types,
                instance_profile_name: self.instance_profile_name,
                security_group_ids: self.security_group_ids,
                subnet_id: self.subnet_id,
                logging: self.logging,
                key_pair: self.key_pair,
                terminate_instance_on_failure: self.terminate_instance_on_failure,
                sns_topic_arn: self.sns_topic_arn,
                date_created: self.date_created,
                date_updated: self.date_updated,
                resource_tags: self.resource_tags,
                instance_metadata_options: self.instance_metadata_options,
                tags: self.tags,
            }
        }
    }
}
impl InfrastructureConfiguration {
    /// Creates a new builder-style object to manufacture [`InfrastructureConfiguration`](crate::model::InfrastructureConfiguration)
    pub fn builder() -> crate::model::infrastructure_configuration::Builder {
        crate::model::infrastructure_configuration::Builder::default()
    }
}

/// <p>An image recipe.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageRecipe {
    /// <p>The Amazon Resource Name (ARN) of the image recipe.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Specifies which type of image is created by the recipe - an AMI or a
    /// container image.</p>
    pub r#type: std::option::Option<crate::model::ImageType>,
    /// <p>The name of the image recipe.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the image recipe.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The platform of the image recipe.</p>
    pub platform: std::option::Option<crate::model::Platform>,
    /// <p>The owner of the image recipe.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>The version of the image recipe.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The components of the image recipe.</p>
    pub components: std::option::Option<std::vec::Vec<crate::model::ComponentConfiguration>>,
    /// <p>The base image of the image recipe.</p>
    pub parent_image: std::option::Option<std::string::String>,
    /// <p>The block device mappings to apply when creating images from this recipe.</p>
    pub block_device_mappings:
        std::option::Option<std::vec::Vec<crate::model::InstanceBlockDeviceMapping>>,
    /// <p>The date on which this image recipe was created.</p>
    pub date_created: std::option::Option<std::string::String>,
    /// <p>The tags of the image recipe.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The working directory to be used during build and test workflows.</p>
    pub working_directory: std::option::Option<std::string::String>,
    /// <p>Before you create a new AMI, Image Builder launches temporary Amazon EC2 instances to
    /// build and test your image configuration. Instance configuration adds a layer
    /// of control over those instances. You can define settings and add scripts to
    /// run when an instance is launched from your AMI.</p>
    pub additional_instance_configuration:
        std::option::Option<crate::model::AdditionalInstanceConfiguration>,
}
impl std::fmt::Debug for ImageRecipe {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageRecipe");
        formatter.field("arn", &self.arn);
        formatter.field("r#type", &self.r#type);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("platform", &self.platform);
        formatter.field("owner", &self.owner);
        formatter.field("version", &self.version);
        formatter.field("components", &self.components);
        formatter.field("parent_image", &self.parent_image);
        formatter.field("block_device_mappings", &self.block_device_mappings);
        formatter.field("date_created", &self.date_created);
        formatter.field("tags", &self.tags);
        formatter.field("working_directory", &self.working_directory);
        formatter.field(
            "additional_instance_configuration",
            &self.additional_instance_configuration,
        );
        formatter.finish()
    }
}
/// See [`ImageRecipe`](crate::model::ImageRecipe)
pub mod image_recipe {
    /// A builder for [`ImageRecipe`](crate::model::ImageRecipe)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ImageType>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<crate::model::Platform>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) components:
            std::option::Option<std::vec::Vec<crate::model::ComponentConfiguration>>,
        pub(crate) parent_image: std::option::Option<std::string::String>,
        pub(crate) block_device_mappings:
            std::option::Option<std::vec::Vec<crate::model::InstanceBlockDeviceMapping>>,
        pub(crate) date_created: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) working_directory: std::option::Option<std::string::String>,
        pub(crate) additional_instance_configuration:
            std::option::Option<crate::model::AdditionalInstanceConfiguration>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the image recipe.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image recipe.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Specifies which type of image is created by the recipe - an AMI or a
        /// container image.</p>
        pub fn r#type(mut self, input: crate::model::ImageType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Specifies which type of image is created by the recipe - an AMI or a
        /// container image.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ImageType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The name of the image recipe.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the image recipe.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the image recipe.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the image recipe.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The platform of the image recipe.</p>
        pub fn platform(mut self, input: crate::model::Platform) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p>The platform of the image recipe.</p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.platform = input;
            self
        }
        /// <p>The owner of the image recipe.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>The owner of the image recipe.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>The version of the image recipe.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the image recipe.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Appends an item to `components`.
        ///
        /// To override the contents of this collection use [`set_components`](Self::set_components).
        ///
        /// <p>The components of the image recipe.</p>
        pub fn components(
            mut self,
            input: impl Into<crate::model::ComponentConfiguration>,
        ) -> Self {
            let mut v = self.components.unwrap_or_default();
            v.push(input.into());
            self.components = Some(v);
            self
        }
        /// <p>The components of the image recipe.</p>
        pub fn set_components(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComponentConfiguration>>,
        ) -> Self {
            self.components = input;
            self
        }
        /// <p>The base image of the image recipe.</p>
        pub fn parent_image(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_image = Some(input.into());
            self
        }
        /// <p>The base image of the image recipe.</p>
        pub fn set_parent_image(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parent_image = input;
            self
        }
        /// Appends an item to `block_device_mappings`.
        ///
        /// To override the contents of this collection use [`set_block_device_mappings`](Self::set_block_device_mappings).
        ///
        /// <p>The block device mappings to apply when creating images from this recipe.</p>
        pub fn block_device_mappings(
            mut self,
            input: impl Into<crate::model::InstanceBlockDeviceMapping>,
        ) -> Self {
            let mut v = self.block_device_mappings.unwrap_or_default();
            v.push(input.into());
            self.block_device_mappings = Some(v);
            self
        }
        /// <p>The block device mappings to apply when creating images from this recipe.</p>
        pub fn set_block_device_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceBlockDeviceMapping>>,
        ) -> Self {
            self.block_device_mappings = input;
            self
        }
        /// <p>The date on which this image recipe was created.</p>
        pub fn date_created(mut self, input: impl Into<std::string::String>) -> Self {
            self.date_created = Some(input.into());
            self
        }
        /// <p>The date on which this image recipe was created.</p>
        pub fn set_date_created(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.date_created = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags of the image recipe.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags of the image recipe.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The working directory to be used during build and test workflows.</p>
        pub fn working_directory(mut self, input: impl Into<std::string::String>) -> Self {
            self.working_directory = Some(input.into());
            self
        }
        /// <p>The working directory to be used during build and test workflows.</p>
        pub fn set_working_directory(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.working_directory = input;
            self
        }
        /// <p>Before you create a new AMI, Image Builder launches temporary Amazon EC2 instances to
        /// build and test your image configuration. Instance configuration adds a layer
        /// of control over those instances. You can define settings and add scripts to
        /// run when an instance is launched from your AMI.</p>
        pub fn additional_instance_configuration(
            mut self,
            input: crate::model::AdditionalInstanceConfiguration,
        ) -> Self {
            self.additional_instance_configuration = Some(input);
            self
        }
        /// <p>Before you create a new AMI, Image Builder launches temporary Amazon EC2 instances to
        /// build and test your image configuration. Instance configuration adds a layer
        /// of control over those instances. You can define settings and add scripts to
        /// run when an instance is launched from your AMI.</p>
        pub fn set_additional_instance_configuration(
            mut self,
            input: std::option::Option<crate::model::AdditionalInstanceConfiguration>,
        ) -> Self {
            self.additional_instance_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageRecipe`](crate::model::ImageRecipe)
        pub fn build(self) -> crate::model::ImageRecipe {
            crate::model::ImageRecipe {
                arn: self.arn,
                r#type: self.r#type,
                name: self.name,
                description: self.description,
                platform: self.platform,
                owner: self.owner,
                version: self.version,
                components: self.components,
                parent_image: self.parent_image,
                block_device_mappings: self.block_device_mappings,
                date_created: self.date_created,
                tags: self.tags,
                working_directory: self.working_directory,
                additional_instance_configuration: self.additional_instance_configuration,
            }
        }
    }
}
impl ImageRecipe {
    /// Creates a new builder-style object to manufacture [`ImageRecipe`](crate::model::ImageRecipe)
    pub fn builder() -> crate::model::image_recipe::Builder {
        crate::model::image_recipe::Builder::default()
    }
}

/// <p>In addition to your infrastruction configuration, these settings provide an extra layer of
/// control over your build instances. For instances where Image Builder installs the Systems Manager agent,
/// you can choose whether to keep it for the AMI that you create. You can also specify commands
/// to run on launch for all of your build instances.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdditionalInstanceConfiguration {
    /// <p>Contains settings for the Systems Manager agent on your build instance.</p>
    pub systems_manager_agent: std::option::Option<crate::model::SystemsManagerAgent>,
    /// <p>Use this property to provide commands or a command script to run when you launch
    /// your build instance.</p>
    /// <note>
    /// <p>The userDataOverride property replaces any commands that Image Builder might have added to ensure
    /// that Systems Manager is installed on your Linux build instance. If you override the user data,
    /// make sure that you add commands to install Systems Manager, if it is not pre-installed on your
    /// base image.</p>
    /// </note>
    pub user_data_override: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AdditionalInstanceConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdditionalInstanceConfiguration");
        formatter.field("systems_manager_agent", &self.systems_manager_agent);
        formatter.field("user_data_override", &self.user_data_override);
        formatter.finish()
    }
}
/// See [`AdditionalInstanceConfiguration`](crate::model::AdditionalInstanceConfiguration)
pub mod additional_instance_configuration {
    /// A builder for [`AdditionalInstanceConfiguration`](crate::model::AdditionalInstanceConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) systems_manager_agent: std::option::Option<crate::model::SystemsManagerAgent>,
        pub(crate) user_data_override: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Contains settings for the Systems Manager agent on your build instance.</p>
        pub fn systems_manager_agent(mut self, input: crate::model::SystemsManagerAgent) -> Self {
            self.systems_manager_agent = Some(input);
            self
        }
        /// <p>Contains settings for the Systems Manager agent on your build instance.</p>
        pub fn set_systems_manager_agent(
            mut self,
            input: std::option::Option<crate::model::SystemsManagerAgent>,
        ) -> Self {
            self.systems_manager_agent = input;
            self
        }
        /// <p>Use this property to provide commands or a command script to run when you launch
        /// your build instance.</p>
        /// <note>
        /// <p>The userDataOverride property replaces any commands that Image Builder might have added to ensure
        /// that Systems Manager is installed on your Linux build instance. If you override the user data,
        /// make sure that you add commands to install Systems Manager, if it is not pre-installed on your
        /// base image.</p>
        /// </note>
        pub fn user_data_override(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_data_override = Some(input.into());
            self
        }
        /// <p>Use this property to provide commands or a command script to run when you launch
        /// your build instance.</p>
        /// <note>
        /// <p>The userDataOverride property replaces any commands that Image Builder might have added to ensure
        /// that Systems Manager is installed on your Linux build instance. If you override the user data,
        /// make sure that you add commands to install Systems Manager, if it is not pre-installed on your
        /// base image.</p>
        /// </note>
        pub fn set_user_data_override(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.user_data_override = input;
            self
        }
        /// Consumes the builder and constructs a [`AdditionalInstanceConfiguration`](crate::model::AdditionalInstanceConfiguration)
        pub fn build(self) -> crate::model::AdditionalInstanceConfiguration {
            crate::model::AdditionalInstanceConfiguration {
                systems_manager_agent: self.systems_manager_agent,
                user_data_override: self.user_data_override,
            }
        }
    }
}
impl AdditionalInstanceConfiguration {
    /// Creates a new builder-style object to manufacture [`AdditionalInstanceConfiguration`](crate::model::AdditionalInstanceConfiguration)
    pub fn builder() -> crate::model::additional_instance_configuration::Builder {
        crate::model::additional_instance_configuration::Builder::default()
    }
}

/// <p>Contains settings for the Systems Manager agent on your build instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SystemsManagerAgent {
    /// <p>Controls whether the Systems Manager agent is removed from your final build image, prior to creating
    /// the new AMI. If this is set to true, then the agent is removed from the final image. If it's
    /// set to false, then the agent is left in, so that it is included in the new AMI. The default
    /// value is false.</p>
    pub uninstall_after_build: std::option::Option<bool>,
}
impl std::fmt::Debug for SystemsManagerAgent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SystemsManagerAgent");
        formatter.field("uninstall_after_build", &self.uninstall_after_build);
        formatter.finish()
    }
}
/// See [`SystemsManagerAgent`](crate::model::SystemsManagerAgent)
pub mod systems_manager_agent {
    /// A builder for [`SystemsManagerAgent`](crate::model::SystemsManagerAgent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) uninstall_after_build: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Controls whether the Systems Manager agent is removed from your final build image, prior to creating
        /// the new AMI. If this is set to true, then the agent is removed from the final image. If it's
        /// set to false, then the agent is left in, so that it is included in the new AMI. The default
        /// value is false.</p>
        pub fn uninstall_after_build(mut self, input: bool) -> Self {
            self.uninstall_after_build = Some(input);
            self
        }
        /// <p>Controls whether the Systems Manager agent is removed from your final build image, prior to creating
        /// the new AMI. If this is set to true, then the agent is removed from the final image. If it's
        /// set to false, then the agent is left in, so that it is included in the new AMI. The default
        /// value is false.</p>
        pub fn set_uninstall_after_build(mut self, input: std::option::Option<bool>) -> Self {
            self.uninstall_after_build = input;
            self
        }
        /// Consumes the builder and constructs a [`SystemsManagerAgent`](crate::model::SystemsManagerAgent)
        pub fn build(self) -> crate::model::SystemsManagerAgent {
            crate::model::SystemsManagerAgent {
                uninstall_after_build: self.uninstall_after_build,
            }
        }
    }
}
impl SystemsManagerAgent {
    /// Creates a new builder-style object to manufacture [`SystemsManagerAgent`](crate::model::SystemsManagerAgent)
    pub fn builder() -> crate::model::systems_manager_agent::Builder {
        crate::model::systems_manager_agent::Builder::default()
    }
}

/// <p>Defines block device mappings for the instance used to configure your image.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceBlockDeviceMapping {
    /// <p>The device to which these mappings apply.</p>
    pub device_name: std::option::Option<std::string::String>,
    /// <p>Use to manage Amazon EBS-specific configuration for this mapping.</p>
    pub ebs: std::option::Option<crate::model::EbsInstanceBlockDeviceSpecification>,
    /// <p>Use to manage instance ephemeral devices.</p>
    pub virtual_name: std::option::Option<std::string::String>,
    /// <p>Use to remove a mapping from the base image.</p>
    pub no_device: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InstanceBlockDeviceMapping {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceBlockDeviceMapping");
        formatter.field("device_name", &self.device_name);
        formatter.field("ebs", &self.ebs);
        formatter.field("virtual_name", &self.virtual_name);
        formatter.field("no_device", &self.no_device);
        formatter.finish()
    }
}
/// See [`InstanceBlockDeviceMapping`](crate::model::InstanceBlockDeviceMapping)
pub mod instance_block_device_mapping {
    /// A builder for [`InstanceBlockDeviceMapping`](crate::model::InstanceBlockDeviceMapping)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_name: std::option::Option<std::string::String>,
        pub(crate) ebs: std::option::Option<crate::model::EbsInstanceBlockDeviceSpecification>,
        pub(crate) virtual_name: std::option::Option<std::string::String>,
        pub(crate) no_device: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The device to which these mappings apply.</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>The device to which these mappings apply.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// <p>Use to manage Amazon EBS-specific configuration for this mapping.</p>
        pub fn ebs(mut self, input: crate::model::EbsInstanceBlockDeviceSpecification) -> Self {
            self.ebs = Some(input);
            self
        }
        /// <p>Use to manage Amazon EBS-specific configuration for this mapping.</p>
        pub fn set_ebs(
            mut self,
            input: std::option::Option<crate::model::EbsInstanceBlockDeviceSpecification>,
        ) -> Self {
            self.ebs = input;
            self
        }
        /// <p>Use to manage instance ephemeral devices.</p>
        pub fn virtual_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_name = Some(input.into());
            self
        }
        /// <p>Use to manage instance ephemeral devices.</p>
        pub fn set_virtual_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.virtual_name = input;
            self
        }
        /// <p>Use to remove a mapping from the base image.</p>
        pub fn no_device(mut self, input: impl Into<std::string::String>) -> Self {
            self.no_device = Some(input.into());
            self
        }
        /// <p>Use to remove a mapping from the base image.</p>
        pub fn set_no_device(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.no_device = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceBlockDeviceMapping`](crate::model::InstanceBlockDeviceMapping)
        pub fn build(self) -> crate::model::InstanceBlockDeviceMapping {
            crate::model::InstanceBlockDeviceMapping {
                device_name: self.device_name,
                ebs: self.ebs,
                virtual_name: self.virtual_name,
                no_device: self.no_device,
            }
        }
    }
}
impl InstanceBlockDeviceMapping {
    /// Creates a new builder-style object to manufacture [`InstanceBlockDeviceMapping`](crate::model::InstanceBlockDeviceMapping)
    pub fn builder() -> crate::model::instance_block_device_mapping::Builder {
        crate::model::instance_block_device_mapping::Builder::default()
    }
}

/// <p>Amazon EBS-specific block device mapping specifications.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EbsInstanceBlockDeviceSpecification {
    /// <p>Use to configure device encryption.</p>
    pub encrypted: std::option::Option<bool>,
    /// <p>Use to configure delete on termination of the associated device.</p>
    pub delete_on_termination: std::option::Option<bool>,
    /// <p>Use to configure device IOPS.</p>
    pub iops: std::option::Option<i32>,
    /// <p>Use to configure the KMS key to use when encrypting the device.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The snapshot that defines the device contents.</p>
    pub snapshot_id: std::option::Option<std::string::String>,
    /// <p>Use to override the device's volume size.</p>
    pub volume_size: std::option::Option<i32>,
    /// <p>Use to override the device's volume type.</p>
    pub volume_type: std::option::Option<crate::model::EbsVolumeType>,
    /// <p>
    /// <b>For GP3 volumes only</b> –
    /// The throughput in MiB/s that the volume supports. </p>
    pub throughput: std::option::Option<i32>,
}
impl std::fmt::Debug for EbsInstanceBlockDeviceSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EbsInstanceBlockDeviceSpecification");
        formatter.field("encrypted", &self.encrypted);
        formatter.field("delete_on_termination", &self.delete_on_termination);
        formatter.field("iops", &self.iops);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("snapshot_id", &self.snapshot_id);
        formatter.field("volume_size", &self.volume_size);
        formatter.field("volume_type", &self.volume_type);
        formatter.field("throughput", &self.throughput);
        formatter.finish()
    }
}
/// See [`EbsInstanceBlockDeviceSpecification`](crate::model::EbsInstanceBlockDeviceSpecification)
pub mod ebs_instance_block_device_specification {
    /// A builder for [`EbsInstanceBlockDeviceSpecification`](crate::model::EbsInstanceBlockDeviceSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encrypted: std::option::Option<bool>,
        pub(crate) delete_on_termination: std::option::Option<bool>,
        pub(crate) iops: std::option::Option<i32>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
        pub(crate) volume_size: std::option::Option<i32>,
        pub(crate) volume_type: std::option::Option<crate::model::EbsVolumeType>,
        pub(crate) throughput: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Use to configure device encryption.</p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.encrypted = Some(input);
            self
        }
        /// <p>Use to configure device encryption.</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.encrypted = input;
            self
        }
        /// <p>Use to configure delete on termination of the associated device.</p>
        pub fn delete_on_termination(mut self, input: bool) -> Self {
            self.delete_on_termination = Some(input);
            self
        }
        /// <p>Use to configure delete on termination of the associated device.</p>
        pub fn set_delete_on_termination(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_on_termination = input;
            self
        }
        /// <p>Use to configure device IOPS.</p>
        pub fn iops(mut self, input: i32) -> Self {
            self.iops = Some(input);
            self
        }
        /// <p>Use to configure device IOPS.</p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.iops = input;
            self
        }
        /// <p>Use to configure the KMS key to use when encrypting the device.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>Use to configure the KMS key to use when encrypting the device.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The snapshot that defines the device contents.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The snapshot that defines the device contents.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// <p>Use to override the device's volume size.</p>
        pub fn volume_size(mut self, input: i32) -> Self {
            self.volume_size = Some(input);
            self
        }
        /// <p>Use to override the device's volume size.</p>
        pub fn set_volume_size(mut self, input: std::option::Option<i32>) -> Self {
            self.volume_size = input;
            self
        }
        /// <p>Use to override the device's volume type.</p>
        pub fn volume_type(mut self, input: crate::model::EbsVolumeType) -> Self {
            self.volume_type = Some(input);
            self
        }
        /// <p>Use to override the device's volume type.</p>
        pub fn set_volume_type(
            mut self,
            input: std::option::Option<crate::model::EbsVolumeType>,
        ) -> Self {
            self.volume_type = input;
            self
        }
        /// <p>
        /// <b>For GP3 volumes only</b> –
        /// The throughput in MiB/s that the volume supports. </p>
        pub fn throughput(mut self, input: i32) -> Self {
            self.throughput = Some(input);
            self
        }
        /// <p>
        /// <b>For GP3 volumes only</b> –
        /// The throughput in MiB/s that the volume supports. </p>
        pub fn set_throughput(mut self, input: std::option::Option<i32>) -> Self {
            self.throughput = input;
            self
        }
        /// Consumes the builder and constructs a [`EbsInstanceBlockDeviceSpecification`](crate::model::EbsInstanceBlockDeviceSpecification)
        pub fn build(self) -> crate::model::EbsInstanceBlockDeviceSpecification {
            crate::model::EbsInstanceBlockDeviceSpecification {
                encrypted: self.encrypted,
                delete_on_termination: self.delete_on_termination,
                iops: self.iops,
                kms_key_id: self.kms_key_id,
                snapshot_id: self.snapshot_id,
                volume_size: self.volume_size,
                volume_type: self.volume_type,
                throughput: self.throughput,
            }
        }
    }
}
impl EbsInstanceBlockDeviceSpecification {
    /// Creates a new builder-style object to manufacture [`EbsInstanceBlockDeviceSpecification`](crate::model::EbsInstanceBlockDeviceSpecification)
    pub fn builder() -> crate::model::ebs_instance_block_device_specification::Builder {
        crate::model::ebs_instance_block_device_specification::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EbsVolumeType {
    #[allow(missing_docs)] // documentation missing in model
    Gp2,
    #[allow(missing_docs)] // documentation missing in model
    Gp3,
    #[allow(missing_docs)] // documentation missing in model
    Io1,
    #[allow(missing_docs)] // documentation missing in model
    Io2,
    #[allow(missing_docs)] // documentation missing in model
    Sc1,
    #[allow(missing_docs)] // documentation missing in model
    St1,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EbsVolumeType {
    fn from(s: &str) -> Self {
        match s {
            "gp2" => EbsVolumeType::Gp2,
            "gp3" => EbsVolumeType::Gp3,
            "io1" => EbsVolumeType::Io1,
            "io2" => EbsVolumeType::Io2,
            "sc1" => EbsVolumeType::Sc1,
            "st1" => EbsVolumeType::St1,
            "standard" => EbsVolumeType::Standard,
            other => EbsVolumeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EbsVolumeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EbsVolumeType::from(s))
    }
}
impl EbsVolumeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EbsVolumeType::Gp2 => "gp2",
            EbsVolumeType::Gp3 => "gp3",
            EbsVolumeType::Io1 => "io1",
            EbsVolumeType::Io2 => "io2",
            EbsVolumeType::Sc1 => "sc1",
            EbsVolumeType::St1 => "st1",
            EbsVolumeType::Standard => "standard",
            EbsVolumeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["gp2", "gp3", "io1", "io2", "sc1", "st1", "standard"]
    }
}
impl AsRef<str> for EbsVolumeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Configuration details of the component.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComponentConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the component.</p>
    pub component_arn: std::option::Option<std::string::String>,
    /// <p>A group of parameter settings that are used to configure the component for a specific recipe.</p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::ComponentParameter>>,
}
impl std::fmt::Debug for ComponentConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComponentConfiguration");
        formatter.field("component_arn", &self.component_arn);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}
/// See [`ComponentConfiguration`](crate::model::ComponentConfiguration)
pub mod component_configuration {
    /// A builder for [`ComponentConfiguration`](crate::model::ComponentConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) component_arn: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::ComponentParameter>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the component.</p>
        pub fn component_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.component_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the component.</p>
        pub fn set_component_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.component_arn = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A group of parameter settings that are used to configure the component for a specific recipe.</p>
        pub fn parameters(mut self, input: impl Into<crate::model::ComponentParameter>) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input.into());
            self.parameters = Some(v);
            self
        }
        /// <p>A group of parameter settings that are used to configure the component for a specific recipe.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComponentParameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`ComponentConfiguration`](crate::model::ComponentConfiguration)
        pub fn build(self) -> crate::model::ComponentConfiguration {
            crate::model::ComponentConfiguration {
                component_arn: self.component_arn,
                parameters: self.parameters,
            }
        }
    }
}
impl ComponentConfiguration {
    /// Creates a new builder-style object to manufacture [`ComponentConfiguration`](crate::model::ComponentConfiguration)
    pub fn builder() -> crate::model::component_configuration::Builder {
        crate::model::component_configuration::Builder::default()
    }
}

/// <p>Contains a key/value pair that sets the named component parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComponentParameter {
    /// <p>The name of the component parameter to set.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Sets the value for the named component parameter.</p>
    pub value: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for ComponentParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComponentParameter");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`ComponentParameter`](crate::model::ComponentParameter)
pub mod component_parameter {
    /// A builder for [`ComponentParameter`](crate::model::ComponentParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the component parameter to set.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the component parameter to set.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `value`.
        ///
        /// To override the contents of this collection use [`set_value`](Self::set_value).
        ///
        /// <p>Sets the value for the named component parameter.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.value.unwrap_or_default();
            v.push(input.into());
            self.value = Some(v);
            self
        }
        /// <p>Sets the value for the named component parameter.</p>
        pub fn set_value(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`ComponentParameter`](crate::model::ComponentParameter)
        pub fn build(self) -> crate::model::ComponentParameter {
            crate::model::ComponentParameter {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl ComponentParameter {
    /// Creates a new builder-style object to manufacture [`ComponentParameter`](crate::model::ComponentParameter)
    pub fn builder() -> crate::model::component_parameter::Builder {
        crate::model::component_parameter::Builder::default()
    }
}

/// <p>An Image Builder image. You must specify exactly one recipe for the image – either
/// a container recipe (<code>containerRecipe</code>), which creates a container
/// image, or an image recipe (<code>imageRecipe</code>), which creates an AMI.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Image {
    /// <p>The Amazon Resource Name (ARN) of the image.</p>
    /// <note>
    /// <p>Semantic versioning is included in each object's Amazon Resource Name (ARN),
    /// at the level that applies to that object as follows:</p>
    /// <ol>
    /// <li>
    /// <p>Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are
    /// either left off entirely, or they are specified as wildcards, for example: x.x.x.</p>
    /// </li>
    /// <li>
    /// <p>Version ARNs have only the first three nodes: <major>.<minor>.<patch></p>
    /// </li>
    /// <li>
    /// <p>Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.</p>
    /// </li>
    /// </ol>
    /// </note>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Specifies whether this is an AMI or container image.</p>
    pub r#type: std::option::Option<crate::model::ImageType>,
    /// <p>The name of the image.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The semantic version of the image.</p>
    /// <note>
    /// <p>The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
    /// You can assign values for the first three, and can filter on all of them.</p>
    /// <p>
    /// <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including
    /// zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
    /// build number to the fourth node.</p>
    /// <p>
    /// <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for
    /// the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
    /// a date, such as 2021.01.01.</p>
    /// <p>
    /// <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x)
    /// to specify the most recent versions or nodes when selecting the base image or components for your
    /// recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be
    /// wildcards.</p>
    /// </note>
    pub version: std::option::Option<std::string::String>,
    /// <p>The platform of the image.</p>
    pub platform: std::option::Option<crate::model::Platform>,
    /// <p> Collects additional information about the image being created, including the operating
    /// system (OS) version and package list. This information is used to enhance the overall
    /// experience of using EC2 Image Builder. Enabled by default.</p>
    pub enhanced_image_metadata_enabled: std::option::Option<bool>,
    /// <p>The operating system version of the instance. For example, Amazon Linux 2, Ubuntu 18, or
    /// Microsoft Windows Server 2019.</p>
    pub os_version: std::option::Option<std::string::String>,
    /// <p>The state of the image.</p>
    pub state: std::option::Option<crate::model::ImageState>,
    /// <p>The image recipe used when creating the image.</p>
    pub image_recipe: std::option::Option<crate::model::ImageRecipe>,
    /// <p>The recipe that is used to create an Image Builder container image.</p>
    pub container_recipe: std::option::Option<crate::model::ContainerRecipe>,
    /// <p>The name of the image pipeline that created this image.</p>
    pub source_pipeline_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the image pipeline that created this image.</p>
    pub source_pipeline_arn: std::option::Option<std::string::String>,
    /// <p>The infrastructure used when creating this image.</p>
    pub infrastructure_configuration:
        std::option::Option<crate::model::InfrastructureConfiguration>,
    /// <p>The distribution configuration used when creating this image.</p>
    pub distribution_configuration: std::option::Option<crate::model::DistributionConfiguration>,
    /// <p>The image tests configuration used when creating this image.</p>
    pub image_tests_configuration: std::option::Option<crate::model::ImageTestsConfiguration>,
    /// <p>The date on which this image was created.</p>
    pub date_created: std::option::Option<std::string::String>,
    /// <p>The output resources produced when creating this image.</p>
    pub output_resources: std::option::Option<crate::model::OutputResources>,
    /// <p>The tags of the image.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for Image {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Image");
        formatter.field("arn", &self.arn);
        formatter.field("r#type", &self.r#type);
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.field("platform", &self.platform);
        formatter.field(
            "enhanced_image_metadata_enabled",
            &self.enhanced_image_metadata_enabled,
        );
        formatter.field("os_version", &self.os_version);
        formatter.field("state", &self.state);
        formatter.field("image_recipe", &self.image_recipe);
        formatter.field("container_recipe", &self.container_recipe);
        formatter.field("source_pipeline_name", &self.source_pipeline_name);
        formatter.field("source_pipeline_arn", &self.source_pipeline_arn);
        formatter.field(
            "infrastructure_configuration",
            &self.infrastructure_configuration,
        );
        formatter.field(
            "distribution_configuration",
            &self.distribution_configuration,
        );
        formatter.field("image_tests_configuration", &self.image_tests_configuration);
        formatter.field("date_created", &self.date_created);
        formatter.field("output_resources", &self.output_resources);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Image`](crate::model::Image)
pub mod image {
    /// A builder for [`Image`](crate::model::Image)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ImageType>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<crate::model::Platform>,
        pub(crate) enhanced_image_metadata_enabled: std::option::Option<bool>,
        pub(crate) os_version: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ImageState>,
        pub(crate) image_recipe: std::option::Option<crate::model::ImageRecipe>,
        pub(crate) container_recipe: std::option::Option<crate::model::ContainerRecipe>,
        pub(crate) source_pipeline_name: std::option::Option<std::string::String>,
        pub(crate) source_pipeline_arn: std::option::Option<std::string::String>,
        pub(crate) infrastructure_configuration:
            std::option::Option<crate::model::InfrastructureConfiguration>,
        pub(crate) distribution_configuration:
            std::option::Option<crate::model::DistributionConfiguration>,
        pub(crate) image_tests_configuration:
            std::option::Option<crate::model::ImageTestsConfiguration>,
        pub(crate) date_created: std::option::Option<std::string::String>,
        pub(crate) output_resources: std::option::Option<crate::model::OutputResources>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the image.</p>
        /// <note>
        /// <p>Semantic versioning is included in each object's Amazon Resource Name (ARN),
        /// at the level that applies to that object as follows:</p>
        /// <ol>
        /// <li>
        /// <p>Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are
        /// either left off entirely, or they are specified as wildcards, for example: x.x.x.</p>
        /// </li>
        /// <li>
        /// <p>Version ARNs have only the first three nodes: <major>.<minor>.<patch></p>
        /// </li>
        /// <li>
        /// <p>Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.</p>
        /// </li>
        /// </ol>
        /// </note>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image.</p>
        /// <note>
        /// <p>Semantic versioning is included in each object's Amazon Resource Name (ARN),
        /// at the level that applies to that object as follows:</p>
        /// <ol>
        /// <li>
        /// <p>Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are
        /// either left off entirely, or they are specified as wildcards, for example: x.x.x.</p>
        /// </li>
        /// <li>
        /// <p>Version ARNs have only the first three nodes: <major>.<minor>.<patch></p>
        /// </li>
        /// <li>
        /// <p>Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.</p>
        /// </li>
        /// </ol>
        /// </note>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Specifies whether this is an AMI or container image.</p>
        pub fn r#type(mut self, input: crate::model::ImageType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Specifies whether this is an AMI or container image.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ImageType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The name of the image.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the image.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The semantic version of the image.</p>
        /// <note>
        /// <p>The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
        /// You can assign values for the first three, and can filter on all of them.</p>
        /// <p>
        /// <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including
        /// zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
        /// build number to the fourth node.</p>
        /// <p>
        /// <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for
        /// the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
        /// a date, such as 2021.01.01.</p>
        /// <p>
        /// <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x)
        /// to specify the most recent versions or nodes when selecting the base image or components for your
        /// recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be
        /// wildcards.</p>
        /// </note>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The semantic version of the image.</p>
        /// <note>
        /// <p>The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
        /// You can assign values for the first three, and can filter on all of them.</p>
        /// <p>
        /// <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including
        /// zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
        /// build number to the fourth node.</p>
        /// <p>
        /// <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for
        /// the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
        /// a date, such as 2021.01.01.</p>
        /// <p>
        /// <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x)
        /// to specify the most recent versions or nodes when selecting the base image or components for your
        /// recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be
        /// wildcards.</p>
        /// </note>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The platform of the image.</p>
        pub fn platform(mut self, input: crate::model::Platform) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p>The platform of the image.</p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.platform = input;
            self
        }
        /// <p> Collects additional information about the image being created, including the operating
        /// system (OS) version and package list. This information is used to enhance the overall
        /// experience of using EC2 Image Builder. Enabled by default.</p>
        pub fn enhanced_image_metadata_enabled(mut self, input: bool) -> Self {
            self.enhanced_image_metadata_enabled = Some(input);
            self
        }
        /// <p> Collects additional information about the image being created, including the operating
        /// system (OS) version and package list. This information is used to enhance the overall
        /// experience of using EC2 Image Builder. Enabled by default.</p>
        pub fn set_enhanced_image_metadata_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enhanced_image_metadata_enabled = input;
            self
        }
        /// <p>The operating system version of the instance. For example, Amazon Linux 2, Ubuntu 18, or
        /// Microsoft Windows Server 2019.</p>
        pub fn os_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.os_version = Some(input.into());
            self
        }
        /// <p>The operating system version of the instance. For example, Amazon Linux 2, Ubuntu 18, or
        /// Microsoft Windows Server 2019.</p>
        pub fn set_os_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.os_version = input;
            self
        }
        /// <p>The state of the image.</p>
        pub fn state(mut self, input: crate::model::ImageState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the image.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::ImageState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The image recipe used when creating the image.</p>
        pub fn image_recipe(mut self, input: crate::model::ImageRecipe) -> Self {
            self.image_recipe = Some(input);
            self
        }
        /// <p>The image recipe used when creating the image.</p>
        pub fn set_image_recipe(
            mut self,
            input: std::option::Option<crate::model::ImageRecipe>,
        ) -> Self {
            self.image_recipe = input;
            self
        }
        /// <p>The recipe that is used to create an Image Builder container image.</p>
        pub fn container_recipe(mut self, input: crate::model::ContainerRecipe) -> Self {
            self.container_recipe = Some(input);
            self
        }
        /// <p>The recipe that is used to create an Image Builder container image.</p>
        pub fn set_container_recipe(
            mut self,
            input: std::option::Option<crate::model::ContainerRecipe>,
        ) -> Self {
            self.container_recipe = input;
            self
        }
        /// <p>The name of the image pipeline that created this image.</p>
        pub fn source_pipeline_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_pipeline_name = Some(input.into());
            self
        }
        /// <p>The name of the image pipeline that created this image.</p>
        pub fn set_source_pipeline_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_pipeline_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline that created this image.</p>
        pub fn source_pipeline_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_pipeline_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the image pipeline that created this image.</p>
        pub fn set_source_pipeline_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_pipeline_arn = input;
            self
        }
        /// <p>The infrastructure used when creating this image.</p>
        pub fn infrastructure_configuration(
            mut self,
            input: crate::model::InfrastructureConfiguration,
        ) -> Self {
            self.infrastructure_configuration = Some(input);
            self
        }
        /// <p>The infrastructure used when creating this image.</p>
        pub fn set_infrastructure_configuration(
            mut self,
            input: std::option::Option<crate::model::InfrastructureConfiguration>,
        ) -> Self {
            self.infrastructure_configuration = input;
            self
        }
        /// <p>The distribution configuration used when creating this image.</p>
        pub fn distribution_configuration(
            mut self,
            input: crate::model::DistributionConfiguration,
        ) -> Self {
            self.distribution_configuration = Some(input);
            self
        }
        /// <p>The distribution configuration used when creating this image.</p>
        pub fn set_distribution_configuration(
            mut self,
            input: std::option::Option<crate::model::DistributionConfiguration>,
        ) -> Self {
            self.distribution_configuration = input;
            self
        }
        /// <p>The image tests configuration used when creating this image.</p>
        pub fn image_tests_configuration(
            mut self,
            input: crate::model::ImageTestsConfiguration,
        ) -> Self {
            self.image_tests_configuration = Some(input);
            self
        }
        /// <p>The image tests configuration used when creating this image.</p>
        pub fn set_image_tests_configuration(
            mut self,
            input: std::option::Option<crate::model::ImageTestsConfiguration>,
        ) -> Self {
            self.image_tests_configuration = input;
            self
        }
        /// <p>The date on which this image was created.</p>
        pub fn date_created(mut self, input: impl Into<std::string::String>) -> Self {
            self.date_created = Some(input.into());
            self
        }
        /// <p>The date on which this image was created.</p>
        pub fn set_date_created(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.date_created = input;
            self
        }
        /// <p>The output resources produced when creating this image.</p>
        pub fn output_resources(mut self, input: crate::model::OutputResources) -> Self {
            self.output_resources = Some(input);
            self
        }
        /// <p>The output resources produced when creating this image.</p>
        pub fn set_output_resources(
            mut self,
            input: std::option::Option<crate::model::OutputResources>,
        ) -> Self {
            self.output_resources = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags of the image.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags of the image.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Image`](crate::model::Image)
        pub fn build(self) -> crate::model::Image {
            crate::model::Image {
                arn: self.arn,
                r#type: self.r#type,
                name: self.name,
                version: self.version,
                platform: self.platform,
                enhanced_image_metadata_enabled: self.enhanced_image_metadata_enabled,
                os_version: self.os_version,
                state: self.state,
                image_recipe: self.image_recipe,
                container_recipe: self.container_recipe,
                source_pipeline_name: self.source_pipeline_name,
                source_pipeline_arn: self.source_pipeline_arn,
                infrastructure_configuration: self.infrastructure_configuration,
                distribution_configuration: self.distribution_configuration,
                image_tests_configuration: self.image_tests_configuration,
                date_created: self.date_created,
                output_resources: self.output_resources,
                tags: self.tags,
            }
        }
    }
}
impl Image {
    /// Creates a new builder-style object to manufacture [`Image`](crate::model::Image)
    pub fn builder() -> crate::model::image::Builder {
        crate::model::image::Builder::default()
    }
}

/// <p>A distribution configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DistributionConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the distribution configuration.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the distribution configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the distribution configuration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The distribution objects that apply Region-specific
    /// settings for the deployment of the image to targeted Regions.</p>
    pub distributions: std::option::Option<std::vec::Vec<crate::model::Distribution>>,
    /// <p>The maximum duration in minutes for this distribution configuration.</p>
    pub timeout_minutes: std::option::Option<i32>,
    /// <p>The date on which this distribution configuration was created.</p>
    pub date_created: std::option::Option<std::string::String>,
    /// <p>The date on which this distribution configuration was last updated.</p>
    pub date_updated: std::option::Option<std::string::String>,
    /// <p>The tags of the distribution configuration.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for DistributionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DistributionConfiguration");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("distributions", &self.distributions);
        formatter.field("timeout_minutes", &self.timeout_minutes);
        formatter.field("date_created", &self.date_created);
        formatter.field("date_updated", &self.date_updated);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DistributionConfiguration`](crate::model::DistributionConfiguration)
pub mod distribution_configuration {
    /// A builder for [`DistributionConfiguration`](crate::model::DistributionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) distributions: std::option::Option<std::vec::Vec<crate::model::Distribution>>,
        pub(crate) timeout_minutes: std::option::Option<i32>,
        pub(crate) date_created: std::option::Option<std::string::String>,
        pub(crate) date_updated: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the distribution configuration.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the distribution configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the distribution configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the distribution configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the distribution configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `distributions`.
        ///
        /// To override the contents of this collection use [`set_distributions`](Self::set_distributions).
        ///
        /// <p>The distribution objects that apply Region-specific
        /// settings for the deployment of the image to targeted Regions.</p>
        pub fn distributions(mut self, input: impl Into<crate::model::Distribution>) -> Self {
            let mut v = self.distributions.unwrap_or_default();
            v.push(input.into());
            self.distributions = Some(v);
            self
        }
        /// <p>The distribution objects that apply Region-specific
        /// settings for the deployment of the image to targeted Regions.</p>
        pub fn set_distributions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Distribution>>,
        ) -> Self {
            self.distributions = input;
            self
        }
        /// <p>The maximum duration in minutes for this distribution configuration.</p>
        pub fn timeout_minutes(mut self, input: i32) -> Self {
            self.timeout_minutes = Some(input);
            self
        }
        /// <p>The maximum duration in minutes for this distribution configuration.</p>
        pub fn set_timeout_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_minutes = input;
            self
        }
        /// <p>The date on which this distribution configuration was created.</p>
        pub fn date_created(mut self, input: impl Into<std::string::String>) -> Self {
            self.date_created = Some(input.into());
            self
        }
        /// <p>The date on which this distribution configuration was created.</p>
        pub fn set_date_created(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.date_created = input;
            self
        }
        /// <p>The date on which this distribution configuration was last updated.</p>
        pub fn date_updated(mut self, input: impl Into<std::string::String>) -> Self {
            self.date_updated = Some(input.into());
            self
        }
        /// <p>The date on which this distribution configuration was last updated.</p>
        pub fn set_date_updated(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.date_updated = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags of the distribution configuration.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags of the distribution configuration.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DistributionConfiguration`](crate::model::DistributionConfiguration)
        pub fn build(self) -> crate::model::DistributionConfiguration {
            crate::model::DistributionConfiguration {
                arn: self.arn,
                name: self.name,
                description: self.description,
                distributions: self.distributions,
                timeout_minutes: self.timeout_minutes,
                date_created: self.date_created,
                date_updated: self.date_updated,
                tags: self.tags,
            }
        }
    }
}
impl DistributionConfiguration {
    /// Creates a new builder-style object to manufacture [`DistributionConfiguration`](crate::model::DistributionConfiguration)
    pub fn builder() -> crate::model::distribution_configuration::Builder {
        crate::model::distribution_configuration::Builder::default()
    }
}

/// <p>A container recipe.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContainerRecipe {
    /// <p>The Amazon Resource Name (ARN) of the container recipe.</p>
    /// <note>
    /// <p>Semantic versioning is included in each object's Amazon Resource Name (ARN),
    /// at the level that applies to that object as follows:</p>
    /// <ol>
    /// <li>
    /// <p>Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are
    /// either left off entirely, or they are specified as wildcards, for example: x.x.x.</p>
    /// </li>
    /// <li>
    /// <p>Version ARNs have only the first three nodes: <major>.<minor>.<patch></p>
    /// </li>
    /// <li>
    /// <p>Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.</p>
    /// </li>
    /// </ol>
    /// </note>
    pub arn: std::option::Option<std::string::String>,
    /// <p>Specifies the type of container, such as Docker.</p>
    pub container_type: std::option::Option<crate::model::ContainerType>,
    /// <p>The name of the container recipe.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the container recipe.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The system platform for the container, such as Windows or Linux.</p>
    pub platform: std::option::Option<crate::model::Platform>,
    /// <p>The owner of the container recipe.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>The semantic version of the container recipe.</p>
    /// <note>
    /// <p>The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
    /// You can assign values for the first three, and can filter on all of them.</p>
    /// <p>
    /// <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including
    /// zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
    /// build number to the fourth node.</p>
    /// <p>
    /// <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for
    /// the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
    /// a date, such as 2021.01.01.</p>
    /// <p>
    /// <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x)
    /// to specify the most recent versions or nodes when selecting the base image or components for your
    /// recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be
    /// wildcards.</p>
    /// </note>
    pub version: std::option::Option<std::string::String>,
    /// <p>Components for build and test that are included in the container recipe.</p>
    pub components: std::option::Option<std::vec::Vec<crate::model::ComponentConfiguration>>,
    /// <p>A group of options that can be used to configure an instance for building and testing container images.</p>
    pub instance_configuration: std::option::Option<crate::model::InstanceConfiguration>,
    /// <p>Dockerfiles are text documents that are used to build Docker containers, and ensure that they contain all of the elements required by the application running inside. The template data consists of contextual variables where Image Builder places build information or scripts, based on your container image recipe.</p>
    pub dockerfile_template_data: std::option::Option<std::string::String>,
    /// <p>Identifies which KMS key is used to encrypt the container image for distribution to the target Region.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>A flag that indicates if the target container is encrypted.</p>
    pub encrypted: std::option::Option<bool>,
    /// <p>The base image for the container recipe.</p>
    pub parent_image: std::option::Option<std::string::String>,
    /// <p>The date when this container recipe was created.</p>
    pub date_created: std::option::Option<std::string::String>,
    /// <p>Tags that are attached to the container recipe.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The working directory for use during build and test workflows.</p>
    pub working_directory: std::option::Option<std::string::String>,
    /// <p>The destination repository for the container image.</p>
    pub target_repository: std::option::Option<crate::model::TargetContainerRepository>,
}
impl std::fmt::Debug for ContainerRecipe {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContainerRecipe");
        formatter.field("arn", &self.arn);
        formatter.field("container_type", &self.container_type);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("platform", &self.platform);
        formatter.field("owner", &self.owner);
        formatter.field("version", &self.version);
        formatter.field("components", &self.components);
        formatter.field("instance_configuration", &self.instance_configuration);
        formatter.field("dockerfile_template_data", &self.dockerfile_template_data);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("encrypted", &self.encrypted);
        formatter.field("parent_image", &self.parent_image);
        formatter.field("date_created", &self.date_created);
        formatter.field("tags", &self.tags);
        formatter.field("working_directory", &self.working_directory);
        formatter.field("target_repository", &self.target_repository);
        formatter.finish()
    }
}
/// See [`ContainerRecipe`](crate::model::ContainerRecipe)
pub mod container_recipe {
    /// A builder for [`ContainerRecipe`](crate::model::ContainerRecipe)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) container_type: std::option::Option<crate::model::ContainerType>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<crate::model::Platform>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) components:
            std::option::Option<std::vec::Vec<crate::model::ComponentConfiguration>>,
        pub(crate) instance_configuration: std::option::Option<crate::model::InstanceConfiguration>,
        pub(crate) dockerfile_template_data: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) encrypted: std::option::Option<bool>,
        pub(crate) parent_image: std::option::Option<std::string::String>,
        pub(crate) date_created: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) working_directory: std::option::Option<std::string::String>,
        pub(crate) target_repository: std::option::Option<crate::model::TargetContainerRepository>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the container recipe.</p>
        /// <note>
        /// <p>Semantic versioning is included in each object's Amazon Resource Name (ARN),
        /// at the level that applies to that object as follows:</p>
        /// <ol>
        /// <li>
        /// <p>Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are
        /// either left off entirely, or they are specified as wildcards, for example: x.x.x.</p>
        /// </li>
        /// <li>
        /// <p>Version ARNs have only the first three nodes: <major>.<minor>.<patch></p>
        /// </li>
        /// <li>
        /// <p>Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.</p>
        /// </li>
        /// </ol>
        /// </note>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container recipe.</p>
        /// <note>
        /// <p>Semantic versioning is included in each object's Amazon Resource Name (ARN),
        /// at the level that applies to that object as follows:</p>
        /// <ol>
        /// <li>
        /// <p>Versionless ARNs and Name ARNs do not include specific values in any of the nodes. The nodes are
        /// either left off entirely, or they are specified as wildcards, for example: x.x.x.</p>
        /// </li>
        /// <li>
        /// <p>Version ARNs have only the first three nodes: <major>.<minor>.<patch></p>
        /// </li>
        /// <li>
        /// <p>Build version ARNs have all four nodes, and point to a specific build for a specific version of an object.</p>
        /// </li>
        /// </ol>
        /// </note>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>Specifies the type of container, such as Docker.</p>
        pub fn container_type(mut self, input: crate::model::ContainerType) -> Self {
            self.container_type = Some(input);
            self
        }
        /// <p>Specifies the type of container, such as Docker.</p>
        pub fn set_container_type(
            mut self,
            input: std::option::Option<crate::model::ContainerType>,
        ) -> Self {
            self.container_type = input;
            self
        }
        /// <p>The name of the container recipe.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the container recipe.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the container recipe.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the container recipe.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The system platform for the container, such as Windows or Linux.</p>
        pub fn platform(mut self, input: crate::model::Platform) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p>The system platform for the container, such as Windows or Linux.</p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.platform = input;
            self
        }
        /// <p>The owner of the container recipe.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>The owner of the container recipe.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>The semantic version of the container recipe.</p>
        /// <note>
        /// <p>The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
        /// You can assign values for the first three, and can filter on all of them.</p>
        /// <p>
        /// <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including
        /// zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
        /// build number to the fourth node.</p>
        /// <p>
        /// <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for
        /// the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
        /// a date, such as 2021.01.01.</p>
        /// <p>
        /// <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x)
        /// to specify the most recent versions or nodes when selecting the base image or components for your
        /// recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be
        /// wildcards.</p>
        /// </note>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The semantic version of the container recipe.</p>
        /// <note>
        /// <p>The semantic version has four nodes: <major>.<minor>.<patch>/<build>.
        /// You can assign values for the first three, and can filter on all of them.</p>
        /// <p>
        /// <b>Assignment:</b> For the first three nodes you can assign any positive integer value, including
        /// zero, with an upper limit of 2^30-1, or 1073741823 for each node. Image Builder automatically assigns the
        /// build number to the fourth node.</p>
        /// <p>
        /// <b>Patterns:</b> You can use any numeric pattern that adheres to the assignment requirements for
        /// the nodes that you can assign. For example, you might choose a software version pattern, such as 1.0.0, or
        /// a date, such as 2021.01.01.</p>
        /// <p>
        /// <b>Filtering:</b> With semantic versioning, you have the flexibility to use wildcards (x)
        /// to specify the most recent versions or nodes when selecting the base image or components for your
        /// recipe. When you use a wildcard in any node, all nodes to the right of the first wildcard must also be
        /// wildcards.</p>
        /// </note>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Appends an item to `components`.
        ///
        /// To override the contents of this collection use [`set_components`](Self::set_components).
        ///
        /// <p>Components for build and test that are included in the container recipe.</p>
        pub fn components(
            mut self,
            input: impl Into<crate::model::ComponentConfiguration>,
        ) -> Self {
            let mut v = self.components.unwrap_or_default();
            v.push(input.into());
            self.components = Some(v);
            self
        }
        /// <p>Components for build and test that are included in the container recipe.</p>
        pub fn set_components(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComponentConfiguration>>,
        ) -> Self {
            self.components = input;
            self
        }
        /// <p>A group of options that can be used to configure an instance for building and testing container images.</p>
        pub fn instance_configuration(
            mut self,
            input: crate::model::InstanceConfiguration,
        ) -> Self {
            self.instance_configuration = Some(input);
            self
        }
        /// <p>A group of options that can be used to configure an instance for building and testing container images.</p>
        pub fn set_instance_configuration(
            mut self,
            input: std::option::Option<crate::model::InstanceConfiguration>,
        ) -> Self {
            self.instance_configuration = input;
            self
        }
        /// <p>Dockerfiles are text documents that are used to build Docker containers, and ensure that they contain all of the elements required by the application running inside. The template data consists of contextual variables where Image Builder places build information or scripts, based on your container image recipe.</p>
        pub fn dockerfile_template_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.dockerfile_template_data = Some(input.into());
            self
        }
        /// <p>Dockerfiles are text documents that are used to build Docker containers, and ensure that they contain all of the elements required by the application running inside. The template data consists of contextual variables where Image Builder places build information or scripts, based on your container image recipe.</p>
        pub fn set_dockerfile_template_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dockerfile_template_data = input;
            self
        }
        /// <p>Identifies which KMS key is used to encrypt the container image for distribution to the target Region.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>Identifies which KMS key is used to encrypt the container image for distribution to the target Region.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>A flag that indicates if the target container is encrypted.</p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.encrypted = Some(input);
            self
        }
        /// <p>A flag that indicates if the target container is encrypted.</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.encrypted = input;
            self
        }
        /// <p>The base image for the container recipe.</p>
        pub fn parent_image(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_image = Some(input.into());
            self
        }
        /// <p>The base image for the container recipe.</p>
        pub fn set_parent_image(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.parent_image = input;
            self
        }
        /// <p>The date when this container recipe was created.</p>
        pub fn date_created(mut self, input: impl Into<std::string::String>) -> Self {
            self.date_created = Some(input.into());
            self
        }
        /// <p>The date when this container recipe was created.</p>
        pub fn set_date_created(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.date_created = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags that are attached to the container recipe.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags that are attached to the container recipe.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The working directory for use during build and test workflows.</p>
        pub fn working_directory(mut self, input: impl Into<std::string::String>) -> Self {
            self.working_directory = Some(input.into());
            self
        }
        /// <p>The working directory for use during build and test workflows.</p>
        pub fn set_working_directory(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.working_directory = input;
            self
        }
        /// <p>The destination repository for the container image.</p>
        pub fn target_repository(mut self, input: crate::model::TargetContainerRepository) -> Self {
            self.target_repository = Some(input);
            self
        }
        /// <p>The destination repository for the container image.</p>
        pub fn set_target_repository(
            mut self,
            input: std::option::Option<crate::model::TargetContainerRepository>,
        ) -> Self {
            self.target_repository = input;
            self
        }
        /// Consumes the builder and constructs a [`ContainerRecipe`](crate::model::ContainerRecipe)
        pub fn build(self) -> crate::model::ContainerRecipe {
            crate::model::ContainerRecipe {
                arn: self.arn,
                container_type: self.container_type,
                name: self.name,
                description: self.description,
                platform: self.platform,
                owner: self.owner,
                version: self.version,
                components: self.components,
                instance_configuration: self.instance_configuration,
                dockerfile_template_data: self.dockerfile_template_data,
                kms_key_id: self.kms_key_id,
                encrypted: self.encrypted,
                parent_image: self.parent_image,
                date_created: self.date_created,
                tags: self.tags,
                working_directory: self.working_directory,
                target_repository: self.target_repository,
            }
        }
    }
}
impl ContainerRecipe {
    /// Creates a new builder-style object to manufacture [`ContainerRecipe`](crate::model::ContainerRecipe)
    pub fn builder() -> crate::model::container_recipe::Builder {
        crate::model::container_recipe::Builder::default()
    }
}

/// <p>Defines a custom base AMI and block device mapping configurations of an instance
/// used for building and testing container images.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceConfiguration {
    /// <p>The AMI ID to use as the base image for a container build and test instance. If not specified,
    /// Image Builder will use the appropriate ECS-optimized AMI as a base image.</p>
    pub image: std::option::Option<std::string::String>,
    /// <p>Defines the block devices to attach for building an instance from this Image Builder AMI.</p>
    pub block_device_mappings:
        std::option::Option<std::vec::Vec<crate::model::InstanceBlockDeviceMapping>>,
}
impl std::fmt::Debug for InstanceConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceConfiguration");
        formatter.field("image", &self.image);
        formatter.field("block_device_mappings", &self.block_device_mappings);
        formatter.finish()
    }
}
/// See [`InstanceConfiguration`](crate::model::InstanceConfiguration)
pub mod instance_configuration {
    /// A builder for [`InstanceConfiguration`](crate::model::InstanceConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image: std::option::Option<std::string::String>,
        pub(crate) block_device_mappings:
            std::option::Option<std::vec::Vec<crate::model::InstanceBlockDeviceMapping>>,
    }
    impl Builder {
        /// <p>The AMI ID to use as the base image for a container build and test instance. If not specified,
        /// Image Builder will use the appropriate ECS-optimized AMI as a base image.</p>
        pub fn image(mut self, input: impl Into<std::string::String>) -> Self {
            self.image = Some(input.into());
            self
        }
        /// <p>The AMI ID to use as the base image for a container build and test instance. If not specified,
        /// Image Builder will use the appropriate ECS-optimized AMI as a base image.</p>
        pub fn set_image(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image = input;
            self
        }
        /// Appends an item to `block_device_mappings`.
        ///
        /// To override the contents of this collection use [`set_block_device_mappings`](Self::set_block_device_mappings).
        ///
        /// <p>Defines the block devices to attach for building an instance from this Image Builder AMI.</p>
        pub fn block_device_mappings(
            mut self,
            input: impl Into<crate::model::InstanceBlockDeviceMapping>,
        ) -> Self {
            let mut v = self.block_device_mappings.unwrap_or_default();
            v.push(input.into());
            self.block_device_mappings = Some(v);
            self
        }
        /// <p>Defines the block devices to attach for building an instance from this Image Builder AMI.</p>
        pub fn set_block_device_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceBlockDeviceMapping>>,
        ) -> Self {
            self.block_device_mappings = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceConfiguration`](crate::model::InstanceConfiguration)
        pub fn build(self) -> crate::model::InstanceConfiguration {
            crate::model::InstanceConfiguration {
                image: self.image,
                block_device_mappings: self.block_device_mappings,
            }
        }
    }
}
impl InstanceConfiguration {
    /// Creates a new builder-style object to manufacture [`InstanceConfiguration`](crate::model::InstanceConfiguration)
    pub fn builder() -> crate::model::instance_configuration::Builder {
        crate::model::instance_configuration::Builder::default()
    }
}

/// <p>A detailed view of a component.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Component {
    /// <p>The Amazon Resource Name (ARN) of the component.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the component.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the component.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The description of the component.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The change description of the component.</p>
    pub change_description: std::option::Option<std::string::String>,
    /// <p>The type of the component denotes whether the component is used to build the image or only
    /// to test it.</p>
    pub r#type: std::option::Option<crate::model::ComponentType>,
    /// <p>The platform of the component.</p>
    pub platform: std::option::Option<crate::model::Platform>,
    /// <p>The operating system (OS) version supported by the component. If the OS information is
    /// available, a prefix match is performed against the base image OS version during image recipe
    /// creation.</p>
    pub supported_os_versions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Describes the current status of the component. This is used for
    /// components that are no longer active.</p>
    pub state: std::option::Option<crate::model::ComponentState>,
    /// <p>Contains parameter details for each of the parameters that are defined for the component.</p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::ComponentParameterDetail>>,
    /// <p>The owner of the component.</p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>The data of the component.</p>
    pub data: std::option::Option<std::string::String>,
    /// <p>The KMS key identifier used to encrypt the component.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The encryption status of the component.</p>
    pub encrypted: std::option::Option<bool>,
    /// <p>The date that the component was created.</p>
    pub date_created: std::option::Option<std::string::String>,
    /// <p>The tags associated with the component.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for Component {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Component");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("version", &self.version);
        formatter.field("description", &self.description);
        formatter.field("change_description", &self.change_description);
        formatter.field("r#type", &self.r#type);
        formatter.field("platform", &self.platform);
        formatter.field("supported_os_versions", &self.supported_os_versions);
        formatter.field("state", &self.state);
        formatter.field("parameters", &self.parameters);
        formatter.field("owner", &self.owner);
        formatter.field("data", &self.data);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("encrypted", &self.encrypted);
        formatter.field("date_created", &self.date_created);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Component`](crate::model::Component)
pub mod component {
    /// A builder for [`Component`](crate::model::Component)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) change_description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ComponentType>,
        pub(crate) platform: std::option::Option<crate::model::Platform>,
        pub(crate) supported_os_versions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) state: std::option::Option<crate::model::ComponentState>,
        pub(crate) parameters:
            std::option::Option<std::vec::Vec<crate::model::ComponentParameterDetail>>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) data: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) encrypted: std::option::Option<bool>,
        pub(crate) date_created: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the component.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the component.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the component.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the component.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the component.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the component.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The description of the component.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the component.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The change description of the component.</p>
        pub fn change_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_description = Some(input.into());
            self
        }
        /// <p>The change description of the component.</p>
        pub fn set_change_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.change_description = input;
            self
        }
        /// <p>The type of the component denotes whether the component is used to build the image or only
        /// to test it.</p>
        pub fn r#type(mut self, input: crate::model::ComponentType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the component denotes whether the component is used to build the image or only
        /// to test it.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ComponentType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The platform of the component.</p>
        pub fn platform(mut self, input: crate::model::Platform) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p>The platform of the component.</p>
        pub fn set_platform(mut self, input: std::option::Option<crate::model::Platform>) -> Self {
            self.platform = input;
            self
        }
        /// Appends an item to `supported_os_versions`.
        ///
        /// To override the contents of this collection use [`set_supported_os_versions`](Self::set_supported_os_versions).
        ///
        /// <p>The operating system (OS) version supported by the component. If the OS information is
        /// available, a prefix match is performed against the base image OS version during image recipe
        /// creation.</p>
        pub fn supported_os_versions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.supported_os_versions.unwrap_or_default();
            v.push(input.into());
            self.supported_os_versions = Some(v);
            self
        }
        /// <p>The operating system (OS) version supported by the component. If the OS information is
        /// available, a prefix match is performed against the base image OS version during image recipe
        /// creation.</p>
        pub fn set_supported_os_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_os_versions = input;
            self
        }
        /// <p>Describes the current status of the component. This is used for
        /// components that are no longer active.</p>
        pub fn state(mut self, input: crate::model::ComponentState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>Describes the current status of the component. This is used for
        /// components that are no longer active.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ComponentState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>Contains parameter details for each of the parameters that are defined for the component.</p>
        pub fn parameters(
            mut self,
            input: impl Into<crate::model::ComponentParameterDetail>,
        ) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input.into());
            self.parameters = Some(v);
            self
        }
        /// <p>Contains parameter details for each of the parameters that are defined for the component.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ComponentParameterDetail>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>The owner of the component.</p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>The owner of the component.</p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>The data of the component.</p>
        pub fn data(mut self, input: impl Into<std::string::String>) -> Self {
            self.data = Some(input.into());
            self
        }
        /// <p>The data of the component.</p>
        pub fn set_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data = input;
            self
        }
        /// <p>The KMS key identifier used to encrypt the component.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The KMS key identifier used to encrypt the component.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The encryption status of the component.</p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.encrypted = Some(input);
            self
        }
        /// <p>The encryption status of the component.</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.encrypted = input;
            self
        }
        /// <p>The date that the component was created.</p>
        pub fn date_created(mut self, input: impl Into<std::string::String>) -> Self {
            self.date_created = Some(input.into());
            self
        }
        /// <p>The date that the component was created.</p>
        pub fn set_date_created(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.date_created = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the component.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags associated with the component.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Component`](crate::model::Component)
        pub fn build(self) -> crate::model::Component {
            crate::model::Component {
                arn: self.arn,
                name: self.name,
                version: self.version,
                description: self.description,
                change_description: self.change_description,
                r#type: self.r#type,
                platform: self.platform,
                supported_os_versions: self.supported_os_versions,
                state: self.state,
                parameters: self.parameters,
                owner: self.owner,
                data: self.data,
                kms_key_id: self.kms_key_id,
                encrypted: self.encrypted,
                date_created: self.date_created,
                tags: self.tags,
            }
        }
    }
}
impl Component {
    /// Creates a new builder-style object to manufacture [`Component`](crate::model::Component)
    pub fn builder() -> crate::model::component::Builder {
        crate::model::component::Builder::default()
    }
}

/// <p>Defines a parameter that is used to provide configuration details for the component.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComponentParameterDetail {
    /// <p>The name of this input parameter.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of input this parameter provides. The currently supported value is "string".</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The default value of this parameter if no input is provided.</p>
    pub default_value: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Describes this parameter.</p>
    pub description: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ComponentParameterDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComponentParameterDetail");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("default_value", &self.default_value);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`ComponentParameterDetail`](crate::model::ComponentParameterDetail)
pub mod component_parameter_detail {
    /// A builder for [`ComponentParameterDetail`](crate::model::ComponentParameterDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) default_value: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of this input parameter.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of this input parameter.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of input this parameter provides. The currently supported value is "string".</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of input this parameter provides. The currently supported value is "string".</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `default_value`.
        ///
        /// To override the contents of this collection use [`set_default_value`](Self::set_default_value).
        ///
        /// <p>The default value of this parameter if no input is provided.</p>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.default_value.unwrap_or_default();
            v.push(input.into());
            self.default_value = Some(v);
            self
        }
        /// <p>The default value of this parameter if no input is provided.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// <p>Describes this parameter.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Describes this parameter.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`ComponentParameterDetail`](crate::model::ComponentParameterDetail)
        pub fn build(self) -> crate::model::ComponentParameterDetail {
            crate::model::ComponentParameterDetail {
                name: self.name,
                r#type: self.r#type,
                default_value: self.default_value,
                description: self.description,
            }
        }
    }
}
impl ComponentParameterDetail {
    /// Creates a new builder-style object to manufacture [`ComponentParameterDetail`](crate::model::ComponentParameterDetail)
    pub fn builder() -> crate::model::component_parameter_detail::Builder {
        crate::model::component_parameter_detail::Builder::default()
    }
}
