// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Contains the response to a successful <code>UploadSSHPublicKey</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UploadSshPublicKeyOutput {
    /// <p>Contains information about the SSH public key.</p>
    pub ssh_public_key: std::option::Option<crate::model::SshPublicKey>,
}
impl UploadSshPublicKeyOutput {
    /// <p>Contains information about the SSH public key.</p>
    pub fn ssh_public_key(&self) -> std::option::Option<&crate::model::SshPublicKey> {
        self.ssh_public_key.as_ref()
    }
}
impl std::fmt::Debug for UploadSshPublicKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UploadSshPublicKeyOutput");
        formatter.field("ssh_public_key", &self.ssh_public_key);
        formatter.finish()
    }
}
/// See [`UploadSshPublicKeyOutput`](crate::output::UploadSshPublicKeyOutput)
pub mod upload_ssh_public_key_output {
    /// A builder for [`UploadSshPublicKeyOutput`](crate::output::UploadSshPublicKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ssh_public_key: std::option::Option<crate::model::SshPublicKey>,
    }
    impl Builder {
        /// <p>Contains information about the SSH public key.</p>
        pub fn ssh_public_key(mut self, input: crate::model::SshPublicKey) -> Self {
            self.ssh_public_key = Some(input);
            self
        }
        /// <p>Contains information about the SSH public key.</p>
        pub fn set_ssh_public_key(
            mut self,
            input: std::option::Option<crate::model::SshPublicKey>,
        ) -> Self {
            self.ssh_public_key = input;
            self
        }
        /// Consumes the builder and constructs a [`UploadSshPublicKeyOutput`](crate::output::UploadSshPublicKeyOutput)
        pub fn build(self) -> crate::output::UploadSshPublicKeyOutput {
            crate::output::UploadSshPublicKeyOutput {
                ssh_public_key: self.ssh_public_key,
            }
        }
    }
}
impl UploadSshPublicKeyOutput {
    /// Creates a new builder-style object to manufacture [`UploadSshPublicKeyOutput`](crate::output::UploadSshPublicKeyOutput)
    pub fn builder() -> crate::output::upload_ssh_public_key_output::Builder {
        crate::output::upload_ssh_public_key_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>UploadSigningCertificate</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UploadSigningCertificateOutput {
    /// <p>Information about the certificate.</p>
    pub certificate: std::option::Option<crate::model::SigningCertificate>,
}
impl UploadSigningCertificateOutput {
    /// <p>Information about the certificate.</p>
    pub fn certificate(&self) -> std::option::Option<&crate::model::SigningCertificate> {
        self.certificate.as_ref()
    }
}
impl std::fmt::Debug for UploadSigningCertificateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UploadSigningCertificateOutput");
        formatter.field("certificate", &self.certificate);
        formatter.finish()
    }
}
/// See [`UploadSigningCertificateOutput`](crate::output::UploadSigningCertificateOutput)
pub mod upload_signing_certificate_output {
    /// A builder for [`UploadSigningCertificateOutput`](crate::output::UploadSigningCertificateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate: std::option::Option<crate::model::SigningCertificate>,
    }
    impl Builder {
        /// <p>Information about the certificate.</p>
        pub fn certificate(mut self, input: crate::model::SigningCertificate) -> Self {
            self.certificate = Some(input);
            self
        }
        /// <p>Information about the certificate.</p>
        pub fn set_certificate(
            mut self,
            input: std::option::Option<crate::model::SigningCertificate>,
        ) -> Self {
            self.certificate = input;
            self
        }
        /// Consumes the builder and constructs a [`UploadSigningCertificateOutput`](crate::output::UploadSigningCertificateOutput)
        pub fn build(self) -> crate::output::UploadSigningCertificateOutput {
            crate::output::UploadSigningCertificateOutput {
                certificate: self.certificate,
            }
        }
    }
}
impl UploadSigningCertificateOutput {
    /// Creates a new builder-style object to manufacture [`UploadSigningCertificateOutput`](crate::output::UploadSigningCertificateOutput)
    pub fn builder() -> crate::output::upload_signing_certificate_output::Builder {
        crate::output::upload_signing_certificate_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>UploadServerCertificate</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UploadServerCertificateOutput {
    /// <p>The meta information of the uploaded server certificate without its certificate body, certificate chain, and private key.</p>
    pub server_certificate_metadata: std::option::Option<crate::model::ServerCertificateMetadata>,
    /// <p>A list of tags that are attached to the new IAM server certificate. The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl UploadServerCertificateOutput {
    /// <p>The meta information of the uploaded server certificate without its certificate body, certificate chain, and private key.</p>
    pub fn server_certificate_metadata(
        &self,
    ) -> std::option::Option<&crate::model::ServerCertificateMetadata> {
        self.server_certificate_metadata.as_ref()
    }
    /// <p>A list of tags that are attached to the new IAM server certificate. The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for UploadServerCertificateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UploadServerCertificateOutput");
        formatter.field(
            "server_certificate_metadata",
            &self.server_certificate_metadata,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`UploadServerCertificateOutput`](crate::output::UploadServerCertificateOutput)
pub mod upload_server_certificate_output {
    /// A builder for [`UploadServerCertificateOutput`](crate::output::UploadServerCertificateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_certificate_metadata:
            std::option::Option<crate::model::ServerCertificateMetadata>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The meta information of the uploaded server certificate without its certificate body, certificate chain, and private key.</p>
        pub fn server_certificate_metadata(
            mut self,
            input: crate::model::ServerCertificateMetadata,
        ) -> Self {
            self.server_certificate_metadata = Some(input);
            self
        }
        /// <p>The meta information of the uploaded server certificate without its certificate body, certificate chain, and private key.</p>
        pub fn set_server_certificate_metadata(
            mut self,
            input: std::option::Option<crate::model::ServerCertificateMetadata>,
        ) -> Self {
            self.server_certificate_metadata = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that are attached to the new IAM server certificate. The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags that are attached to the new IAM server certificate. The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UploadServerCertificateOutput`](crate::output::UploadServerCertificateOutput)
        pub fn build(self) -> crate::output::UploadServerCertificateOutput {
            crate::output::UploadServerCertificateOutput {
                server_certificate_metadata: self.server_certificate_metadata,
                tags: self.tags,
            }
        }
    }
}
impl UploadServerCertificateOutput {
    /// Creates a new builder-style object to manufacture [`UploadServerCertificateOutput`](crate::output::UploadServerCertificateOutput)
    pub fn builder() -> crate::output::upload_server_certificate_output::Builder {
        crate::output::upload_server_certificate_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateUserOutput {}
impl std::fmt::Debug for UpdateUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateUserOutput");
        formatter.finish()
    }
}
/// See [`UpdateUserOutput`](crate::output::UpdateUserOutput)
pub mod update_user_output {
    /// A builder for [`UpdateUserOutput`](crate::output::UpdateUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateUserOutput`](crate::output::UpdateUserOutput)
        pub fn build(self) -> crate::output::UpdateUserOutput {
            crate::output::UpdateUserOutput {}
        }
    }
}
impl UpdateUserOutput {
    /// Creates a new builder-style object to manufacture [`UpdateUserOutput`](crate::output::UpdateUserOutput)
    pub fn builder() -> crate::output::update_user_output::Builder {
        crate::output::update_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSshPublicKeyOutput {}
impl std::fmt::Debug for UpdateSshPublicKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSshPublicKeyOutput");
        formatter.finish()
    }
}
/// See [`UpdateSshPublicKeyOutput`](crate::output::UpdateSshPublicKeyOutput)
pub mod update_ssh_public_key_output {
    /// A builder for [`UpdateSshPublicKeyOutput`](crate::output::UpdateSshPublicKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateSshPublicKeyOutput`](crate::output::UpdateSshPublicKeyOutput)
        pub fn build(self) -> crate::output::UpdateSshPublicKeyOutput {
            crate::output::UpdateSshPublicKeyOutput {}
        }
    }
}
impl UpdateSshPublicKeyOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSshPublicKeyOutput`](crate::output::UpdateSshPublicKeyOutput)
    pub fn builder() -> crate::output::update_ssh_public_key_output::Builder {
        crate::output::update_ssh_public_key_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSigningCertificateOutput {}
impl std::fmt::Debug for UpdateSigningCertificateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSigningCertificateOutput");
        formatter.finish()
    }
}
/// See [`UpdateSigningCertificateOutput`](crate::output::UpdateSigningCertificateOutput)
pub mod update_signing_certificate_output {
    /// A builder for [`UpdateSigningCertificateOutput`](crate::output::UpdateSigningCertificateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateSigningCertificateOutput`](crate::output::UpdateSigningCertificateOutput)
        pub fn build(self) -> crate::output::UpdateSigningCertificateOutput {
            crate::output::UpdateSigningCertificateOutput {}
        }
    }
}
impl UpdateSigningCertificateOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSigningCertificateOutput`](crate::output::UpdateSigningCertificateOutput)
    pub fn builder() -> crate::output::update_signing_certificate_output::Builder {
        crate::output::update_signing_certificate_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateServiceSpecificCredentialOutput {}
impl std::fmt::Debug for UpdateServiceSpecificCredentialOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateServiceSpecificCredentialOutput");
        formatter.finish()
    }
}
/// See [`UpdateServiceSpecificCredentialOutput`](crate::output::UpdateServiceSpecificCredentialOutput)
pub mod update_service_specific_credential_output {
    /// A builder for [`UpdateServiceSpecificCredentialOutput`](crate::output::UpdateServiceSpecificCredentialOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateServiceSpecificCredentialOutput`](crate::output::UpdateServiceSpecificCredentialOutput)
        pub fn build(self) -> crate::output::UpdateServiceSpecificCredentialOutput {
            crate::output::UpdateServiceSpecificCredentialOutput {}
        }
    }
}
impl UpdateServiceSpecificCredentialOutput {
    /// Creates a new builder-style object to manufacture [`UpdateServiceSpecificCredentialOutput`](crate::output::UpdateServiceSpecificCredentialOutput)
    pub fn builder() -> crate::output::update_service_specific_credential_output::Builder {
        crate::output::update_service_specific_credential_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateServerCertificateOutput {}
impl std::fmt::Debug for UpdateServerCertificateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateServerCertificateOutput");
        formatter.finish()
    }
}
/// See [`UpdateServerCertificateOutput`](crate::output::UpdateServerCertificateOutput)
pub mod update_server_certificate_output {
    /// A builder for [`UpdateServerCertificateOutput`](crate::output::UpdateServerCertificateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateServerCertificateOutput`](crate::output::UpdateServerCertificateOutput)
        pub fn build(self) -> crate::output::UpdateServerCertificateOutput {
            crate::output::UpdateServerCertificateOutput {}
        }
    }
}
impl UpdateServerCertificateOutput {
    /// Creates a new builder-style object to manufacture [`UpdateServerCertificateOutput`](crate::output::UpdateServerCertificateOutput)
    pub fn builder() -> crate::output::update_server_certificate_output::Builder {
        crate::output::update_server_certificate_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>UpdateSAMLProvider</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSamlProviderOutput {
    /// <p>The Amazon Resource Name (ARN) of the SAML provider that was updated.</p>
    pub saml_provider_arn: std::option::Option<std::string::String>,
}
impl UpdateSamlProviderOutput {
    /// <p>The Amazon Resource Name (ARN) of the SAML provider that was updated.</p>
    pub fn saml_provider_arn(&self) -> std::option::Option<&str> {
        self.saml_provider_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateSamlProviderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSamlProviderOutput");
        formatter.field("saml_provider_arn", &self.saml_provider_arn);
        formatter.finish()
    }
}
/// See [`UpdateSamlProviderOutput`](crate::output::UpdateSamlProviderOutput)
pub mod update_saml_provider_output {
    /// A builder for [`UpdateSamlProviderOutput`](crate::output::UpdateSamlProviderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) saml_provider_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the SAML provider that was updated.</p>
        pub fn saml_provider_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.saml_provider_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SAML provider that was updated.</p>
        pub fn set_saml_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.saml_provider_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSamlProviderOutput`](crate::output::UpdateSamlProviderOutput)
        pub fn build(self) -> crate::output::UpdateSamlProviderOutput {
            crate::output::UpdateSamlProviderOutput {
                saml_provider_arn: self.saml_provider_arn,
            }
        }
    }
}
impl UpdateSamlProviderOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSamlProviderOutput`](crate::output::UpdateSamlProviderOutput)
    pub fn builder() -> crate::output::update_saml_provider_output::Builder {
        crate::output::update_saml_provider_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRoleDescriptionOutput {
    /// <p>A structure that contains details about the modified role.</p>
    pub role: std::option::Option<crate::model::Role>,
}
impl UpdateRoleDescriptionOutput {
    /// <p>A structure that contains details about the modified role.</p>
    pub fn role(&self) -> std::option::Option<&crate::model::Role> {
        self.role.as_ref()
    }
}
impl std::fmt::Debug for UpdateRoleDescriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRoleDescriptionOutput");
        formatter.field("role", &self.role);
        formatter.finish()
    }
}
/// See [`UpdateRoleDescriptionOutput`](crate::output::UpdateRoleDescriptionOutput)
pub mod update_role_description_output {
    /// A builder for [`UpdateRoleDescriptionOutput`](crate::output::UpdateRoleDescriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role: std::option::Option<crate::model::Role>,
    }
    impl Builder {
        /// <p>A structure that contains details about the modified role.</p>
        pub fn role(mut self, input: crate::model::Role) -> Self {
            self.role = Some(input);
            self
        }
        /// <p>A structure that contains details about the modified role.</p>
        pub fn set_role(mut self, input: std::option::Option<crate::model::Role>) -> Self {
            self.role = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRoleDescriptionOutput`](crate::output::UpdateRoleDescriptionOutput)
        pub fn build(self) -> crate::output::UpdateRoleDescriptionOutput {
            crate::output::UpdateRoleDescriptionOutput { role: self.role }
        }
    }
}
impl UpdateRoleDescriptionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRoleDescriptionOutput`](crate::output::UpdateRoleDescriptionOutput)
    pub fn builder() -> crate::output::update_role_description_output::Builder {
        crate::output::update_role_description_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRoleOutput {}
impl std::fmt::Debug for UpdateRoleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRoleOutput");
        formatter.finish()
    }
}
/// See [`UpdateRoleOutput`](crate::output::UpdateRoleOutput)
pub mod update_role_output {
    /// A builder for [`UpdateRoleOutput`](crate::output::UpdateRoleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateRoleOutput`](crate::output::UpdateRoleOutput)
        pub fn build(self) -> crate::output::UpdateRoleOutput {
            crate::output::UpdateRoleOutput {}
        }
    }
}
impl UpdateRoleOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRoleOutput`](crate::output::UpdateRoleOutput)
    pub fn builder() -> crate::output::update_role_output::Builder {
        crate::output::update_role_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateOpenIdConnectProviderThumbprintOutput {}
impl std::fmt::Debug for UpdateOpenIdConnectProviderThumbprintOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateOpenIdConnectProviderThumbprintOutput");
        formatter.finish()
    }
}
/// See [`UpdateOpenIdConnectProviderThumbprintOutput`](crate::output::UpdateOpenIdConnectProviderThumbprintOutput)
pub mod update_open_id_connect_provider_thumbprint_output {
    /// A builder for [`UpdateOpenIdConnectProviderThumbprintOutput`](crate::output::UpdateOpenIdConnectProviderThumbprintOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateOpenIdConnectProviderThumbprintOutput`](crate::output::UpdateOpenIdConnectProviderThumbprintOutput)
        pub fn build(self) -> crate::output::UpdateOpenIdConnectProviderThumbprintOutput {
            crate::output::UpdateOpenIdConnectProviderThumbprintOutput {}
        }
    }
}
impl UpdateOpenIdConnectProviderThumbprintOutput {
    /// Creates a new builder-style object to manufacture [`UpdateOpenIdConnectProviderThumbprintOutput`](crate::output::UpdateOpenIdConnectProviderThumbprintOutput)
    pub fn builder() -> crate::output::update_open_id_connect_provider_thumbprint_output::Builder {
        crate::output::update_open_id_connect_provider_thumbprint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLoginProfileOutput {}
impl std::fmt::Debug for UpdateLoginProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLoginProfileOutput");
        formatter.finish()
    }
}
/// See [`UpdateLoginProfileOutput`](crate::output::UpdateLoginProfileOutput)
pub mod update_login_profile_output {
    /// A builder for [`UpdateLoginProfileOutput`](crate::output::UpdateLoginProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateLoginProfileOutput`](crate::output::UpdateLoginProfileOutput)
        pub fn build(self) -> crate::output::UpdateLoginProfileOutput {
            crate::output::UpdateLoginProfileOutput {}
        }
    }
}
impl UpdateLoginProfileOutput {
    /// Creates a new builder-style object to manufacture [`UpdateLoginProfileOutput`](crate::output::UpdateLoginProfileOutput)
    pub fn builder() -> crate::output::update_login_profile_output::Builder {
        crate::output::update_login_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGroupOutput {}
impl std::fmt::Debug for UpdateGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGroupOutput");
        formatter.finish()
    }
}
/// See [`UpdateGroupOutput`](crate::output::UpdateGroupOutput)
pub mod update_group_output {
    /// A builder for [`UpdateGroupOutput`](crate::output::UpdateGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateGroupOutput`](crate::output::UpdateGroupOutput)
        pub fn build(self) -> crate::output::UpdateGroupOutput {
            crate::output::UpdateGroupOutput {}
        }
    }
}
impl UpdateGroupOutput {
    /// Creates a new builder-style object to manufacture [`UpdateGroupOutput`](crate::output::UpdateGroupOutput)
    pub fn builder() -> crate::output::update_group_output::Builder {
        crate::output::update_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAssumeRolePolicyOutput {}
impl std::fmt::Debug for UpdateAssumeRolePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAssumeRolePolicyOutput");
        formatter.finish()
    }
}
/// See [`UpdateAssumeRolePolicyOutput`](crate::output::UpdateAssumeRolePolicyOutput)
pub mod update_assume_role_policy_output {
    /// A builder for [`UpdateAssumeRolePolicyOutput`](crate::output::UpdateAssumeRolePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateAssumeRolePolicyOutput`](crate::output::UpdateAssumeRolePolicyOutput)
        pub fn build(self) -> crate::output::UpdateAssumeRolePolicyOutput {
            crate::output::UpdateAssumeRolePolicyOutput {}
        }
    }
}
impl UpdateAssumeRolePolicyOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAssumeRolePolicyOutput`](crate::output::UpdateAssumeRolePolicyOutput)
    pub fn builder() -> crate::output::update_assume_role_policy_output::Builder {
        crate::output::update_assume_role_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAccountPasswordPolicyOutput {}
impl std::fmt::Debug for UpdateAccountPasswordPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAccountPasswordPolicyOutput");
        formatter.finish()
    }
}
/// See [`UpdateAccountPasswordPolicyOutput`](crate::output::UpdateAccountPasswordPolicyOutput)
pub mod update_account_password_policy_output {
    /// A builder for [`UpdateAccountPasswordPolicyOutput`](crate::output::UpdateAccountPasswordPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateAccountPasswordPolicyOutput`](crate::output::UpdateAccountPasswordPolicyOutput)
        pub fn build(self) -> crate::output::UpdateAccountPasswordPolicyOutput {
            crate::output::UpdateAccountPasswordPolicyOutput {}
        }
    }
}
impl UpdateAccountPasswordPolicyOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAccountPasswordPolicyOutput`](crate::output::UpdateAccountPasswordPolicyOutput)
    pub fn builder() -> crate::output::update_account_password_policy_output::Builder {
        crate::output::update_account_password_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAccessKeyOutput {}
impl std::fmt::Debug for UpdateAccessKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAccessKeyOutput");
        formatter.finish()
    }
}
/// See [`UpdateAccessKeyOutput`](crate::output::UpdateAccessKeyOutput)
pub mod update_access_key_output {
    /// A builder for [`UpdateAccessKeyOutput`](crate::output::UpdateAccessKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateAccessKeyOutput`](crate::output::UpdateAccessKeyOutput)
        pub fn build(self) -> crate::output::UpdateAccessKeyOutput {
            crate::output::UpdateAccessKeyOutput {}
        }
    }
}
impl UpdateAccessKeyOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAccessKeyOutput`](crate::output::UpdateAccessKeyOutput)
    pub fn builder() -> crate::output::update_access_key_output::Builder {
        crate::output::update_access_key_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagUserOutput {}
impl std::fmt::Debug for UntagUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagUserOutput");
        formatter.finish()
    }
}
/// See [`UntagUserOutput`](crate::output::UntagUserOutput)
pub mod untag_user_output {
    /// A builder for [`UntagUserOutput`](crate::output::UntagUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagUserOutput`](crate::output::UntagUserOutput)
        pub fn build(self) -> crate::output::UntagUserOutput {
            crate::output::UntagUserOutput {}
        }
    }
}
impl UntagUserOutput {
    /// Creates a new builder-style object to manufacture [`UntagUserOutput`](crate::output::UntagUserOutput)
    pub fn builder() -> crate::output::untag_user_output::Builder {
        crate::output::untag_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagServerCertificateOutput {}
impl std::fmt::Debug for UntagServerCertificateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagServerCertificateOutput");
        formatter.finish()
    }
}
/// See [`UntagServerCertificateOutput`](crate::output::UntagServerCertificateOutput)
pub mod untag_server_certificate_output {
    /// A builder for [`UntagServerCertificateOutput`](crate::output::UntagServerCertificateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagServerCertificateOutput`](crate::output::UntagServerCertificateOutput)
        pub fn build(self) -> crate::output::UntagServerCertificateOutput {
            crate::output::UntagServerCertificateOutput {}
        }
    }
}
impl UntagServerCertificateOutput {
    /// Creates a new builder-style object to manufacture [`UntagServerCertificateOutput`](crate::output::UntagServerCertificateOutput)
    pub fn builder() -> crate::output::untag_server_certificate_output::Builder {
        crate::output::untag_server_certificate_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagSamlProviderOutput {}
impl std::fmt::Debug for UntagSamlProviderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagSamlProviderOutput");
        formatter.finish()
    }
}
/// See [`UntagSamlProviderOutput`](crate::output::UntagSamlProviderOutput)
pub mod untag_saml_provider_output {
    /// A builder for [`UntagSamlProviderOutput`](crate::output::UntagSamlProviderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagSamlProviderOutput`](crate::output::UntagSamlProviderOutput)
        pub fn build(self) -> crate::output::UntagSamlProviderOutput {
            crate::output::UntagSamlProviderOutput {}
        }
    }
}
impl UntagSamlProviderOutput {
    /// Creates a new builder-style object to manufacture [`UntagSamlProviderOutput`](crate::output::UntagSamlProviderOutput)
    pub fn builder() -> crate::output::untag_saml_provider_output::Builder {
        crate::output::untag_saml_provider_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagRoleOutput {}
impl std::fmt::Debug for UntagRoleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagRoleOutput");
        formatter.finish()
    }
}
/// See [`UntagRoleOutput`](crate::output::UntagRoleOutput)
pub mod untag_role_output {
    /// A builder for [`UntagRoleOutput`](crate::output::UntagRoleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagRoleOutput`](crate::output::UntagRoleOutput)
        pub fn build(self) -> crate::output::UntagRoleOutput {
            crate::output::UntagRoleOutput {}
        }
    }
}
impl UntagRoleOutput {
    /// Creates a new builder-style object to manufacture [`UntagRoleOutput`](crate::output::UntagRoleOutput)
    pub fn builder() -> crate::output::untag_role_output::Builder {
        crate::output::untag_role_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagPolicyOutput {}
impl std::fmt::Debug for UntagPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagPolicyOutput");
        formatter.finish()
    }
}
/// See [`UntagPolicyOutput`](crate::output::UntagPolicyOutput)
pub mod untag_policy_output {
    /// A builder for [`UntagPolicyOutput`](crate::output::UntagPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagPolicyOutput`](crate::output::UntagPolicyOutput)
        pub fn build(self) -> crate::output::UntagPolicyOutput {
            crate::output::UntagPolicyOutput {}
        }
    }
}
impl UntagPolicyOutput {
    /// Creates a new builder-style object to manufacture [`UntagPolicyOutput`](crate::output::UntagPolicyOutput)
    pub fn builder() -> crate::output::untag_policy_output::Builder {
        crate::output::untag_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagOpenIdConnectProviderOutput {}
impl std::fmt::Debug for UntagOpenIdConnectProviderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagOpenIdConnectProviderOutput");
        formatter.finish()
    }
}
/// See [`UntagOpenIdConnectProviderOutput`](crate::output::UntagOpenIdConnectProviderOutput)
pub mod untag_open_id_connect_provider_output {
    /// A builder for [`UntagOpenIdConnectProviderOutput`](crate::output::UntagOpenIdConnectProviderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagOpenIdConnectProviderOutput`](crate::output::UntagOpenIdConnectProviderOutput)
        pub fn build(self) -> crate::output::UntagOpenIdConnectProviderOutput {
            crate::output::UntagOpenIdConnectProviderOutput {}
        }
    }
}
impl UntagOpenIdConnectProviderOutput {
    /// Creates a new builder-style object to manufacture [`UntagOpenIdConnectProviderOutput`](crate::output::UntagOpenIdConnectProviderOutput)
    pub fn builder() -> crate::output::untag_open_id_connect_provider_output::Builder {
        crate::output::untag_open_id_connect_provider_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagMfaDeviceOutput {}
impl std::fmt::Debug for UntagMfaDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagMfaDeviceOutput");
        formatter.finish()
    }
}
/// See [`UntagMfaDeviceOutput`](crate::output::UntagMfaDeviceOutput)
pub mod untag_mfa_device_output {
    /// A builder for [`UntagMfaDeviceOutput`](crate::output::UntagMfaDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagMfaDeviceOutput`](crate::output::UntagMfaDeviceOutput)
        pub fn build(self) -> crate::output::UntagMfaDeviceOutput {
            crate::output::UntagMfaDeviceOutput {}
        }
    }
}
impl UntagMfaDeviceOutput {
    /// Creates a new builder-style object to manufacture [`UntagMfaDeviceOutput`](crate::output::UntagMfaDeviceOutput)
    pub fn builder() -> crate::output::untag_mfa_device_output::Builder {
        crate::output::untag_mfa_device_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagInstanceProfileOutput {}
impl std::fmt::Debug for UntagInstanceProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagInstanceProfileOutput");
        formatter.finish()
    }
}
/// See [`UntagInstanceProfileOutput`](crate::output::UntagInstanceProfileOutput)
pub mod untag_instance_profile_output {
    /// A builder for [`UntagInstanceProfileOutput`](crate::output::UntagInstanceProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagInstanceProfileOutput`](crate::output::UntagInstanceProfileOutput)
        pub fn build(self) -> crate::output::UntagInstanceProfileOutput {
            crate::output::UntagInstanceProfileOutput {}
        }
    }
}
impl UntagInstanceProfileOutput {
    /// Creates a new builder-style object to manufacture [`UntagInstanceProfileOutput`](crate::output::UntagInstanceProfileOutput)
    pub fn builder() -> crate::output::untag_instance_profile_output::Builder {
        crate::output::untag_instance_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagUserOutput {}
impl std::fmt::Debug for TagUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagUserOutput");
        formatter.finish()
    }
}
/// See [`TagUserOutput`](crate::output::TagUserOutput)
pub mod tag_user_output {
    /// A builder for [`TagUserOutput`](crate::output::TagUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagUserOutput`](crate::output::TagUserOutput)
        pub fn build(self) -> crate::output::TagUserOutput {
            crate::output::TagUserOutput {}
        }
    }
}
impl TagUserOutput {
    /// Creates a new builder-style object to manufacture [`TagUserOutput`](crate::output::TagUserOutput)
    pub fn builder() -> crate::output::tag_user_output::Builder {
        crate::output::tag_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagServerCertificateOutput {}
impl std::fmt::Debug for TagServerCertificateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagServerCertificateOutput");
        formatter.finish()
    }
}
/// See [`TagServerCertificateOutput`](crate::output::TagServerCertificateOutput)
pub mod tag_server_certificate_output {
    /// A builder for [`TagServerCertificateOutput`](crate::output::TagServerCertificateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagServerCertificateOutput`](crate::output::TagServerCertificateOutput)
        pub fn build(self) -> crate::output::TagServerCertificateOutput {
            crate::output::TagServerCertificateOutput {}
        }
    }
}
impl TagServerCertificateOutput {
    /// Creates a new builder-style object to manufacture [`TagServerCertificateOutput`](crate::output::TagServerCertificateOutput)
    pub fn builder() -> crate::output::tag_server_certificate_output::Builder {
        crate::output::tag_server_certificate_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagSamlProviderOutput {}
impl std::fmt::Debug for TagSamlProviderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagSamlProviderOutput");
        formatter.finish()
    }
}
/// See [`TagSamlProviderOutput`](crate::output::TagSamlProviderOutput)
pub mod tag_saml_provider_output {
    /// A builder for [`TagSamlProviderOutput`](crate::output::TagSamlProviderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagSamlProviderOutput`](crate::output::TagSamlProviderOutput)
        pub fn build(self) -> crate::output::TagSamlProviderOutput {
            crate::output::TagSamlProviderOutput {}
        }
    }
}
impl TagSamlProviderOutput {
    /// Creates a new builder-style object to manufacture [`TagSamlProviderOutput`](crate::output::TagSamlProviderOutput)
    pub fn builder() -> crate::output::tag_saml_provider_output::Builder {
        crate::output::tag_saml_provider_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagRoleOutput {}
impl std::fmt::Debug for TagRoleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagRoleOutput");
        formatter.finish()
    }
}
/// See [`TagRoleOutput`](crate::output::TagRoleOutput)
pub mod tag_role_output {
    /// A builder for [`TagRoleOutput`](crate::output::TagRoleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagRoleOutput`](crate::output::TagRoleOutput)
        pub fn build(self) -> crate::output::TagRoleOutput {
            crate::output::TagRoleOutput {}
        }
    }
}
impl TagRoleOutput {
    /// Creates a new builder-style object to manufacture [`TagRoleOutput`](crate::output::TagRoleOutput)
    pub fn builder() -> crate::output::tag_role_output::Builder {
        crate::output::tag_role_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagPolicyOutput {}
impl std::fmt::Debug for TagPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagPolicyOutput");
        formatter.finish()
    }
}
/// See [`TagPolicyOutput`](crate::output::TagPolicyOutput)
pub mod tag_policy_output {
    /// A builder for [`TagPolicyOutput`](crate::output::TagPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagPolicyOutput`](crate::output::TagPolicyOutput)
        pub fn build(self) -> crate::output::TagPolicyOutput {
            crate::output::TagPolicyOutput {}
        }
    }
}
impl TagPolicyOutput {
    /// Creates a new builder-style object to manufacture [`TagPolicyOutput`](crate::output::TagPolicyOutput)
    pub fn builder() -> crate::output::tag_policy_output::Builder {
        crate::output::tag_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagOpenIdConnectProviderOutput {}
impl std::fmt::Debug for TagOpenIdConnectProviderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagOpenIdConnectProviderOutput");
        formatter.finish()
    }
}
/// See [`TagOpenIdConnectProviderOutput`](crate::output::TagOpenIdConnectProviderOutput)
pub mod tag_open_id_connect_provider_output {
    /// A builder for [`TagOpenIdConnectProviderOutput`](crate::output::TagOpenIdConnectProviderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagOpenIdConnectProviderOutput`](crate::output::TagOpenIdConnectProviderOutput)
        pub fn build(self) -> crate::output::TagOpenIdConnectProviderOutput {
            crate::output::TagOpenIdConnectProviderOutput {}
        }
    }
}
impl TagOpenIdConnectProviderOutput {
    /// Creates a new builder-style object to manufacture [`TagOpenIdConnectProviderOutput`](crate::output::TagOpenIdConnectProviderOutput)
    pub fn builder() -> crate::output::tag_open_id_connect_provider_output::Builder {
        crate::output::tag_open_id_connect_provider_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagMfaDeviceOutput {}
impl std::fmt::Debug for TagMfaDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagMfaDeviceOutput");
        formatter.finish()
    }
}
/// See [`TagMfaDeviceOutput`](crate::output::TagMfaDeviceOutput)
pub mod tag_mfa_device_output {
    /// A builder for [`TagMfaDeviceOutput`](crate::output::TagMfaDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagMfaDeviceOutput`](crate::output::TagMfaDeviceOutput)
        pub fn build(self) -> crate::output::TagMfaDeviceOutput {
            crate::output::TagMfaDeviceOutput {}
        }
    }
}
impl TagMfaDeviceOutput {
    /// Creates a new builder-style object to manufacture [`TagMfaDeviceOutput`](crate::output::TagMfaDeviceOutput)
    pub fn builder() -> crate::output::tag_mfa_device_output::Builder {
        crate::output::tag_mfa_device_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagInstanceProfileOutput {}
impl std::fmt::Debug for TagInstanceProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagInstanceProfileOutput");
        formatter.finish()
    }
}
/// See [`TagInstanceProfileOutput`](crate::output::TagInstanceProfileOutput)
pub mod tag_instance_profile_output {
    /// A builder for [`TagInstanceProfileOutput`](crate::output::TagInstanceProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagInstanceProfileOutput`](crate::output::TagInstanceProfileOutput)
        pub fn build(self) -> crate::output::TagInstanceProfileOutput {
            crate::output::TagInstanceProfileOutput {}
        }
    }
}
impl TagInstanceProfileOutput {
    /// Creates a new builder-style object to manufacture [`TagInstanceProfileOutput`](crate::output::TagInstanceProfileOutput)
    pub fn builder() -> crate::output::tag_instance_profile_output::Builder {
        crate::output::tag_instance_profile_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>SimulatePrincipalPolicy</code> or <code>SimulateCustomPolicy</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SimulatePrincipalPolicyOutput {
    /// <p>The results of the simulation.</p>
    pub evaluation_results: std::option::Option<std::vec::Vec<crate::model::EvaluationResult>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl SimulatePrincipalPolicyOutput {
    /// <p>The results of the simulation.</p>
    pub fn evaluation_results(&self) -> std::option::Option<&[crate::model::EvaluationResult]> {
        self.evaluation_results.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for SimulatePrincipalPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SimulatePrincipalPolicyOutput");
        formatter.field("evaluation_results", &self.evaluation_results);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`SimulatePrincipalPolicyOutput`](crate::output::SimulatePrincipalPolicyOutput)
pub mod simulate_principal_policy_output {
    /// A builder for [`SimulatePrincipalPolicyOutput`](crate::output::SimulatePrincipalPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) evaluation_results:
            std::option::Option<std::vec::Vec<crate::model::EvaluationResult>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `evaluation_results`.
        ///
        /// To override the contents of this collection use [`set_evaluation_results`](Self::set_evaluation_results).
        ///
        /// <p>The results of the simulation.</p>
        pub fn evaluation_results(mut self, input: crate::model::EvaluationResult) -> Self {
            let mut v = self.evaluation_results.unwrap_or_default();
            v.push(input);
            self.evaluation_results = Some(v);
            self
        }
        /// <p>The results of the simulation.</p>
        pub fn set_evaluation_results(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EvaluationResult>>,
        ) -> Self {
            self.evaluation_results = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`SimulatePrincipalPolicyOutput`](crate::output::SimulatePrincipalPolicyOutput)
        pub fn build(self) -> crate::output::SimulatePrincipalPolicyOutput {
            crate::output::SimulatePrincipalPolicyOutput {
                evaluation_results: self.evaluation_results,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl SimulatePrincipalPolicyOutput {
    /// Creates a new builder-style object to manufacture [`SimulatePrincipalPolicyOutput`](crate::output::SimulatePrincipalPolicyOutput)
    pub fn builder() -> crate::output::simulate_principal_policy_output::Builder {
        crate::output::simulate_principal_policy_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>SimulatePrincipalPolicy</code> or <code>SimulateCustomPolicy</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SimulateCustomPolicyOutput {
    /// <p>The results of the simulation.</p>
    pub evaluation_results: std::option::Option<std::vec::Vec<crate::model::EvaluationResult>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl SimulateCustomPolicyOutput {
    /// <p>The results of the simulation.</p>
    pub fn evaluation_results(&self) -> std::option::Option<&[crate::model::EvaluationResult]> {
        self.evaluation_results.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for SimulateCustomPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SimulateCustomPolicyOutput");
        formatter.field("evaluation_results", &self.evaluation_results);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`SimulateCustomPolicyOutput`](crate::output::SimulateCustomPolicyOutput)
pub mod simulate_custom_policy_output {
    /// A builder for [`SimulateCustomPolicyOutput`](crate::output::SimulateCustomPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) evaluation_results:
            std::option::Option<std::vec::Vec<crate::model::EvaluationResult>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `evaluation_results`.
        ///
        /// To override the contents of this collection use [`set_evaluation_results`](Self::set_evaluation_results).
        ///
        /// <p>The results of the simulation.</p>
        pub fn evaluation_results(mut self, input: crate::model::EvaluationResult) -> Self {
            let mut v = self.evaluation_results.unwrap_or_default();
            v.push(input);
            self.evaluation_results = Some(v);
            self
        }
        /// <p>The results of the simulation.</p>
        pub fn set_evaluation_results(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EvaluationResult>>,
        ) -> Self {
            self.evaluation_results = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`SimulateCustomPolicyOutput`](crate::output::SimulateCustomPolicyOutput)
        pub fn build(self) -> crate::output::SimulateCustomPolicyOutput {
            crate::output::SimulateCustomPolicyOutput {
                evaluation_results: self.evaluation_results,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl SimulateCustomPolicyOutput {
    /// Creates a new builder-style object to manufacture [`SimulateCustomPolicyOutput`](crate::output::SimulateCustomPolicyOutput)
    pub fn builder() -> crate::output::simulate_custom_policy_output::Builder {
        crate::output::simulate_custom_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetSecurityTokenServicePreferencesOutput {}
impl std::fmt::Debug for SetSecurityTokenServicePreferencesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetSecurityTokenServicePreferencesOutput");
        formatter.finish()
    }
}
/// See [`SetSecurityTokenServicePreferencesOutput`](crate::output::SetSecurityTokenServicePreferencesOutput)
pub mod set_security_token_service_preferences_output {
    /// A builder for [`SetSecurityTokenServicePreferencesOutput`](crate::output::SetSecurityTokenServicePreferencesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SetSecurityTokenServicePreferencesOutput`](crate::output::SetSecurityTokenServicePreferencesOutput)
        pub fn build(self) -> crate::output::SetSecurityTokenServicePreferencesOutput {
            crate::output::SetSecurityTokenServicePreferencesOutput {}
        }
    }
}
impl SetSecurityTokenServicePreferencesOutput {
    /// Creates a new builder-style object to manufacture [`SetSecurityTokenServicePreferencesOutput`](crate::output::SetSecurityTokenServicePreferencesOutput)
    pub fn builder() -> crate::output::set_security_token_service_preferences_output::Builder {
        crate::output::set_security_token_service_preferences_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetDefaultPolicyVersionOutput {}
impl std::fmt::Debug for SetDefaultPolicyVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetDefaultPolicyVersionOutput");
        formatter.finish()
    }
}
/// See [`SetDefaultPolicyVersionOutput`](crate::output::SetDefaultPolicyVersionOutput)
pub mod set_default_policy_version_output {
    /// A builder for [`SetDefaultPolicyVersionOutput`](crate::output::SetDefaultPolicyVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`SetDefaultPolicyVersionOutput`](crate::output::SetDefaultPolicyVersionOutput)
        pub fn build(self) -> crate::output::SetDefaultPolicyVersionOutput {
            crate::output::SetDefaultPolicyVersionOutput {}
        }
    }
}
impl SetDefaultPolicyVersionOutput {
    /// Creates a new builder-style object to manufacture [`SetDefaultPolicyVersionOutput`](crate::output::SetDefaultPolicyVersionOutput)
    pub fn builder() -> crate::output::set_default_policy_version_output::Builder {
        crate::output::set_default_policy_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResyncMfaDeviceOutput {}
impl std::fmt::Debug for ResyncMfaDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResyncMfaDeviceOutput");
        formatter.finish()
    }
}
/// See [`ResyncMfaDeviceOutput`](crate::output::ResyncMfaDeviceOutput)
pub mod resync_mfa_device_output {
    /// A builder for [`ResyncMfaDeviceOutput`](crate::output::ResyncMfaDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ResyncMfaDeviceOutput`](crate::output::ResyncMfaDeviceOutput)
        pub fn build(self) -> crate::output::ResyncMfaDeviceOutput {
            crate::output::ResyncMfaDeviceOutput {}
        }
    }
}
impl ResyncMfaDeviceOutput {
    /// Creates a new builder-style object to manufacture [`ResyncMfaDeviceOutput`](crate::output::ResyncMfaDeviceOutput)
    pub fn builder() -> crate::output::resync_mfa_device_output::Builder {
        crate::output::resync_mfa_device_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResetServiceSpecificCredentialOutput {
    /// <p>A structure with details about the updated service-specific credential, including the new password.</p> <important>
    /// <p>This is the <b>only</b> time that you can access the password. You cannot recover the password later, but you can reset it again.</p>
    /// </important>
    pub service_specific_credential: std::option::Option<crate::model::ServiceSpecificCredential>,
}
impl ResetServiceSpecificCredentialOutput {
    /// <p>A structure with details about the updated service-specific credential, including the new password.</p> <important>
    /// <p>This is the <b>only</b> time that you can access the password. You cannot recover the password later, but you can reset it again.</p>
    /// </important>
    pub fn service_specific_credential(
        &self,
    ) -> std::option::Option<&crate::model::ServiceSpecificCredential> {
        self.service_specific_credential.as_ref()
    }
}
impl std::fmt::Debug for ResetServiceSpecificCredentialOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResetServiceSpecificCredentialOutput");
        formatter.field(
            "service_specific_credential",
            &self.service_specific_credential,
        );
        formatter.finish()
    }
}
/// See [`ResetServiceSpecificCredentialOutput`](crate::output::ResetServiceSpecificCredentialOutput)
pub mod reset_service_specific_credential_output {
    /// A builder for [`ResetServiceSpecificCredentialOutput`](crate::output::ResetServiceSpecificCredentialOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_specific_credential:
            std::option::Option<crate::model::ServiceSpecificCredential>,
    }
    impl Builder {
        /// <p>A structure with details about the updated service-specific credential, including the new password.</p> <important>
        /// <p>This is the <b>only</b> time that you can access the password. You cannot recover the password later, but you can reset it again.</p>
        /// </important>
        pub fn service_specific_credential(
            mut self,
            input: crate::model::ServiceSpecificCredential,
        ) -> Self {
            self.service_specific_credential = Some(input);
            self
        }
        /// <p>A structure with details about the updated service-specific credential, including the new password.</p> <important>
        /// <p>This is the <b>only</b> time that you can access the password. You cannot recover the password later, but you can reset it again.</p>
        /// </important>
        pub fn set_service_specific_credential(
            mut self,
            input: std::option::Option<crate::model::ServiceSpecificCredential>,
        ) -> Self {
            self.service_specific_credential = input;
            self
        }
        /// Consumes the builder and constructs a [`ResetServiceSpecificCredentialOutput`](crate::output::ResetServiceSpecificCredentialOutput)
        pub fn build(self) -> crate::output::ResetServiceSpecificCredentialOutput {
            crate::output::ResetServiceSpecificCredentialOutput {
                service_specific_credential: self.service_specific_credential,
            }
        }
    }
}
impl ResetServiceSpecificCredentialOutput {
    /// Creates a new builder-style object to manufacture [`ResetServiceSpecificCredentialOutput`](crate::output::ResetServiceSpecificCredentialOutput)
    pub fn builder() -> crate::output::reset_service_specific_credential_output::Builder {
        crate::output::reset_service_specific_credential_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveUserFromGroupOutput {}
impl std::fmt::Debug for RemoveUserFromGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveUserFromGroupOutput");
        formatter.finish()
    }
}
/// See [`RemoveUserFromGroupOutput`](crate::output::RemoveUserFromGroupOutput)
pub mod remove_user_from_group_output {
    /// A builder for [`RemoveUserFromGroupOutput`](crate::output::RemoveUserFromGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemoveUserFromGroupOutput`](crate::output::RemoveUserFromGroupOutput)
        pub fn build(self) -> crate::output::RemoveUserFromGroupOutput {
            crate::output::RemoveUserFromGroupOutput {}
        }
    }
}
impl RemoveUserFromGroupOutput {
    /// Creates a new builder-style object to manufacture [`RemoveUserFromGroupOutput`](crate::output::RemoveUserFromGroupOutput)
    pub fn builder() -> crate::output::remove_user_from_group_output::Builder {
        crate::output::remove_user_from_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveRoleFromInstanceProfileOutput {}
impl std::fmt::Debug for RemoveRoleFromInstanceProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveRoleFromInstanceProfileOutput");
        formatter.finish()
    }
}
/// See [`RemoveRoleFromInstanceProfileOutput`](crate::output::RemoveRoleFromInstanceProfileOutput)
pub mod remove_role_from_instance_profile_output {
    /// A builder for [`RemoveRoleFromInstanceProfileOutput`](crate::output::RemoveRoleFromInstanceProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemoveRoleFromInstanceProfileOutput`](crate::output::RemoveRoleFromInstanceProfileOutput)
        pub fn build(self) -> crate::output::RemoveRoleFromInstanceProfileOutput {
            crate::output::RemoveRoleFromInstanceProfileOutput {}
        }
    }
}
impl RemoveRoleFromInstanceProfileOutput {
    /// Creates a new builder-style object to manufacture [`RemoveRoleFromInstanceProfileOutput`](crate::output::RemoveRoleFromInstanceProfileOutput)
    pub fn builder() -> crate::output::remove_role_from_instance_profile_output::Builder {
        crate::output::remove_role_from_instance_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveClientIdFromOpenIdConnectProviderOutput {}
impl std::fmt::Debug for RemoveClientIdFromOpenIdConnectProviderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveClientIdFromOpenIdConnectProviderOutput");
        formatter.finish()
    }
}
/// See [`RemoveClientIdFromOpenIdConnectProviderOutput`](crate::output::RemoveClientIdFromOpenIdConnectProviderOutput)
pub mod remove_client_id_from_open_id_connect_provider_output {
    /// A builder for [`RemoveClientIdFromOpenIdConnectProviderOutput`](crate::output::RemoveClientIdFromOpenIdConnectProviderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemoveClientIdFromOpenIdConnectProviderOutput`](crate::output::RemoveClientIdFromOpenIdConnectProviderOutput)
        pub fn build(self) -> crate::output::RemoveClientIdFromOpenIdConnectProviderOutput {
            crate::output::RemoveClientIdFromOpenIdConnectProviderOutput {}
        }
    }
}
impl RemoveClientIdFromOpenIdConnectProviderOutput {
    /// Creates a new builder-style object to manufacture [`RemoveClientIdFromOpenIdConnectProviderOutput`](crate::output::RemoveClientIdFromOpenIdConnectProviderOutput)
    pub fn builder() -> crate::output::remove_client_id_from_open_id_connect_provider_output::Builder
    {
        crate::output::remove_client_id_from_open_id_connect_provider_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutUserPolicyOutput {}
impl std::fmt::Debug for PutUserPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutUserPolicyOutput");
        formatter.finish()
    }
}
/// See [`PutUserPolicyOutput`](crate::output::PutUserPolicyOutput)
pub mod put_user_policy_output {
    /// A builder for [`PutUserPolicyOutput`](crate::output::PutUserPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutUserPolicyOutput`](crate::output::PutUserPolicyOutput)
        pub fn build(self) -> crate::output::PutUserPolicyOutput {
            crate::output::PutUserPolicyOutput {}
        }
    }
}
impl PutUserPolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutUserPolicyOutput`](crate::output::PutUserPolicyOutput)
    pub fn builder() -> crate::output::put_user_policy_output::Builder {
        crate::output::put_user_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutUserPermissionsBoundaryOutput {}
impl std::fmt::Debug for PutUserPermissionsBoundaryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutUserPermissionsBoundaryOutput");
        formatter.finish()
    }
}
/// See [`PutUserPermissionsBoundaryOutput`](crate::output::PutUserPermissionsBoundaryOutput)
pub mod put_user_permissions_boundary_output {
    /// A builder for [`PutUserPermissionsBoundaryOutput`](crate::output::PutUserPermissionsBoundaryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutUserPermissionsBoundaryOutput`](crate::output::PutUserPermissionsBoundaryOutput)
        pub fn build(self) -> crate::output::PutUserPermissionsBoundaryOutput {
            crate::output::PutUserPermissionsBoundaryOutput {}
        }
    }
}
impl PutUserPermissionsBoundaryOutput {
    /// Creates a new builder-style object to manufacture [`PutUserPermissionsBoundaryOutput`](crate::output::PutUserPermissionsBoundaryOutput)
    pub fn builder() -> crate::output::put_user_permissions_boundary_output::Builder {
        crate::output::put_user_permissions_boundary_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRolePolicyOutput {}
impl std::fmt::Debug for PutRolePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRolePolicyOutput");
        formatter.finish()
    }
}
/// See [`PutRolePolicyOutput`](crate::output::PutRolePolicyOutput)
pub mod put_role_policy_output {
    /// A builder for [`PutRolePolicyOutput`](crate::output::PutRolePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutRolePolicyOutput`](crate::output::PutRolePolicyOutput)
        pub fn build(self) -> crate::output::PutRolePolicyOutput {
            crate::output::PutRolePolicyOutput {}
        }
    }
}
impl PutRolePolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutRolePolicyOutput`](crate::output::PutRolePolicyOutput)
    pub fn builder() -> crate::output::put_role_policy_output::Builder {
        crate::output::put_role_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRolePermissionsBoundaryOutput {}
impl std::fmt::Debug for PutRolePermissionsBoundaryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRolePermissionsBoundaryOutput");
        formatter.finish()
    }
}
/// See [`PutRolePermissionsBoundaryOutput`](crate::output::PutRolePermissionsBoundaryOutput)
pub mod put_role_permissions_boundary_output {
    /// A builder for [`PutRolePermissionsBoundaryOutput`](crate::output::PutRolePermissionsBoundaryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutRolePermissionsBoundaryOutput`](crate::output::PutRolePermissionsBoundaryOutput)
        pub fn build(self) -> crate::output::PutRolePermissionsBoundaryOutput {
            crate::output::PutRolePermissionsBoundaryOutput {}
        }
    }
}
impl PutRolePermissionsBoundaryOutput {
    /// Creates a new builder-style object to manufacture [`PutRolePermissionsBoundaryOutput`](crate::output::PutRolePermissionsBoundaryOutput)
    pub fn builder() -> crate::output::put_role_permissions_boundary_output::Builder {
        crate::output::put_role_permissions_boundary_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutGroupPolicyOutput {}
impl std::fmt::Debug for PutGroupPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutGroupPolicyOutput");
        formatter.finish()
    }
}
/// See [`PutGroupPolicyOutput`](crate::output::PutGroupPolicyOutput)
pub mod put_group_policy_output {
    /// A builder for [`PutGroupPolicyOutput`](crate::output::PutGroupPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutGroupPolicyOutput`](crate::output::PutGroupPolicyOutput)
        pub fn build(self) -> crate::output::PutGroupPolicyOutput {
            crate::output::PutGroupPolicyOutput {}
        }
    }
}
impl PutGroupPolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutGroupPolicyOutput`](crate::output::PutGroupPolicyOutput)
    pub fn builder() -> crate::output::put_group_policy_output::Builder {
        crate::output::put_group_policy_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>ListVirtualMFADevices</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListVirtualMfaDevicesOutput {
    /// <p> The list of virtual MFA devices in the current account that match the <code>AssignmentStatus</code> value that was passed in the request.</p>
    pub virtual_mfa_devices: std::option::Option<std::vec::Vec<crate::model::VirtualMfaDevice>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListVirtualMfaDevicesOutput {
    /// <p> The list of virtual MFA devices in the current account that match the <code>AssignmentStatus</code> value that was passed in the request.</p>
    pub fn virtual_mfa_devices(&self) -> std::option::Option<&[crate::model::VirtualMfaDevice]> {
        self.virtual_mfa_devices.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListVirtualMfaDevicesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListVirtualMfaDevicesOutput");
        formatter.field("virtual_mfa_devices", &self.virtual_mfa_devices);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListVirtualMfaDevicesOutput`](crate::output::ListVirtualMfaDevicesOutput)
pub mod list_virtual_mfa_devices_output {
    /// A builder for [`ListVirtualMfaDevicesOutput`](crate::output::ListVirtualMfaDevicesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_mfa_devices:
            std::option::Option<std::vec::Vec<crate::model::VirtualMfaDevice>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `virtual_mfa_devices`.
        ///
        /// To override the contents of this collection use [`set_virtual_mfa_devices`](Self::set_virtual_mfa_devices).
        ///
        /// <p> The list of virtual MFA devices in the current account that match the <code>AssignmentStatus</code> value that was passed in the request.</p>
        pub fn virtual_mfa_devices(mut self, input: crate::model::VirtualMfaDevice) -> Self {
            let mut v = self.virtual_mfa_devices.unwrap_or_default();
            v.push(input);
            self.virtual_mfa_devices = Some(v);
            self
        }
        /// <p> The list of virtual MFA devices in the current account that match the <code>AssignmentStatus</code> value that was passed in the request.</p>
        pub fn set_virtual_mfa_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VirtualMfaDevice>>,
        ) -> Self {
            self.virtual_mfa_devices = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListVirtualMfaDevicesOutput`](crate::output::ListVirtualMfaDevicesOutput)
        pub fn build(self) -> crate::output::ListVirtualMfaDevicesOutput {
            crate::output::ListVirtualMfaDevicesOutput {
                virtual_mfa_devices: self.virtual_mfa_devices,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl ListVirtualMfaDevicesOutput {
    /// Creates a new builder-style object to manufacture [`ListVirtualMfaDevicesOutput`](crate::output::ListVirtualMfaDevicesOutput)
    pub fn builder() -> crate::output::list_virtual_mfa_devices_output::Builder {
        crate::output::list_virtual_mfa_devices_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListUserTagsOutput {
    /// <p>The list of tags that are currently attached to the user. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListUserTagsOutput {
    /// <p>The list of tags that are currently attached to the user. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListUserTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListUserTagsOutput");
        formatter.field("tags", &self.tags);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListUserTagsOutput`](crate::output::ListUserTagsOutput)
pub mod list_user_tags_output {
    /// A builder for [`ListUserTagsOutput`](crate::output::ListUserTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags that are currently attached to the user. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The list of tags that are currently attached to the user. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUserTagsOutput`](crate::output::ListUserTagsOutput)
        pub fn build(self) -> crate::output::ListUserTagsOutput {
            crate::output::ListUserTagsOutput {
                tags: self.tags,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl ListUserTagsOutput {
    /// Creates a new builder-style object to manufacture [`ListUserTagsOutput`](crate::output::ListUserTagsOutput)
    pub fn builder() -> crate::output::list_user_tags_output::Builder {
        crate::output::list_user_tags_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>ListUsers</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListUsersOutput {
    /// <p>A list of users.</p>
    pub users: std::option::Option<std::vec::Vec<crate::model::User>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListUsersOutput {
    /// <p>A list of users.</p>
    pub fn users(&self) -> std::option::Option<&[crate::model::User]> {
        self.users.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListUsersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListUsersOutput");
        formatter.field("users", &self.users);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListUsersOutput`](crate::output::ListUsersOutput)
pub mod list_users_output {
    /// A builder for [`ListUsersOutput`](crate::output::ListUsersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) users: std::option::Option<std::vec::Vec<crate::model::User>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `users`.
        ///
        /// To override the contents of this collection use [`set_users`](Self::set_users).
        ///
        /// <p>A list of users.</p>
        pub fn users(mut self, input: crate::model::User) -> Self {
            let mut v = self.users.unwrap_or_default();
            v.push(input);
            self.users = Some(v);
            self
        }
        /// <p>A list of users.</p>
        pub fn set_users(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::User>>,
        ) -> Self {
            self.users = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUsersOutput`](crate::output::ListUsersOutput)
        pub fn build(self) -> crate::output::ListUsersOutput {
            crate::output::ListUsersOutput {
                users: self.users,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl ListUsersOutput {
    /// Creates a new builder-style object to manufacture [`ListUsersOutput`](crate::output::ListUsersOutput)
    pub fn builder() -> crate::output::list_users_output::Builder {
        crate::output::list_users_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>ListUserPolicies</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListUserPoliciesOutput {
    /// <p>A list of policy names.</p>
    pub policy_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListUserPoliciesOutput {
    /// <p>A list of policy names.</p>
    pub fn policy_names(&self) -> std::option::Option<&[std::string::String]> {
        self.policy_names.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListUserPoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListUserPoliciesOutput");
        formatter.field("policy_names", &self.policy_names);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListUserPoliciesOutput`](crate::output::ListUserPoliciesOutput)
pub mod list_user_policies_output {
    /// A builder for [`ListUserPoliciesOutput`](crate::output::ListUserPoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `policy_names`.
        ///
        /// To override the contents of this collection use [`set_policy_names`](Self::set_policy_names).
        ///
        /// <p>A list of policy names.</p>
        pub fn policy_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.policy_names.unwrap_or_default();
            v.push(input.into());
            self.policy_names = Some(v);
            self
        }
        /// <p>A list of policy names.</p>
        pub fn set_policy_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.policy_names = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUserPoliciesOutput`](crate::output::ListUserPoliciesOutput)
        pub fn build(self) -> crate::output::ListUserPoliciesOutput {
            crate::output::ListUserPoliciesOutput {
                policy_names: self.policy_names,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl ListUserPoliciesOutput {
    /// Creates a new builder-style object to manufacture [`ListUserPoliciesOutput`](crate::output::ListUserPoliciesOutput)
    pub fn builder() -> crate::output::list_user_policies_output::Builder {
        crate::output::list_user_policies_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>ListSSHPublicKeys</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSshPublicKeysOutput {
    /// <p>A list of the SSH public keys assigned to IAM user.</p>
    pub ssh_public_keys: std::option::Option<std::vec::Vec<crate::model::SshPublicKeyMetadata>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListSshPublicKeysOutput {
    /// <p>A list of the SSH public keys assigned to IAM user.</p>
    pub fn ssh_public_keys(&self) -> std::option::Option<&[crate::model::SshPublicKeyMetadata]> {
        self.ssh_public_keys.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListSshPublicKeysOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSshPublicKeysOutput");
        formatter.field("ssh_public_keys", &self.ssh_public_keys);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListSshPublicKeysOutput`](crate::output::ListSshPublicKeysOutput)
pub mod list_ssh_public_keys_output {
    /// A builder for [`ListSshPublicKeysOutput`](crate::output::ListSshPublicKeysOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ssh_public_keys:
            std::option::Option<std::vec::Vec<crate::model::SshPublicKeyMetadata>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `ssh_public_keys`.
        ///
        /// To override the contents of this collection use [`set_ssh_public_keys`](Self::set_ssh_public_keys).
        ///
        /// <p>A list of the SSH public keys assigned to IAM user.</p>
        pub fn ssh_public_keys(mut self, input: crate::model::SshPublicKeyMetadata) -> Self {
            let mut v = self.ssh_public_keys.unwrap_or_default();
            v.push(input);
            self.ssh_public_keys = Some(v);
            self
        }
        /// <p>A list of the SSH public keys assigned to IAM user.</p>
        pub fn set_ssh_public_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SshPublicKeyMetadata>>,
        ) -> Self {
            self.ssh_public_keys = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSshPublicKeysOutput`](crate::output::ListSshPublicKeysOutput)
        pub fn build(self) -> crate::output::ListSshPublicKeysOutput {
            crate::output::ListSshPublicKeysOutput {
                ssh_public_keys: self.ssh_public_keys,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl ListSshPublicKeysOutput {
    /// Creates a new builder-style object to manufacture [`ListSshPublicKeysOutput`](crate::output::ListSshPublicKeysOutput)
    pub fn builder() -> crate::output::list_ssh_public_keys_output::Builder {
        crate::output::list_ssh_public_keys_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>ListSigningCertificates</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSigningCertificatesOutput {
    /// <p>A list of the user's signing certificate information.</p>
    pub certificates: std::option::Option<std::vec::Vec<crate::model::SigningCertificate>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListSigningCertificatesOutput {
    /// <p>A list of the user's signing certificate information.</p>
    pub fn certificates(&self) -> std::option::Option<&[crate::model::SigningCertificate]> {
        self.certificates.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListSigningCertificatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSigningCertificatesOutput");
        formatter.field("certificates", &self.certificates);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListSigningCertificatesOutput`](crate::output::ListSigningCertificatesOutput)
pub mod list_signing_certificates_output {
    /// A builder for [`ListSigningCertificatesOutput`](crate::output::ListSigningCertificatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificates:
            std::option::Option<std::vec::Vec<crate::model::SigningCertificate>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `certificates`.
        ///
        /// To override the contents of this collection use [`set_certificates`](Self::set_certificates).
        ///
        /// <p>A list of the user's signing certificate information.</p>
        pub fn certificates(mut self, input: crate::model::SigningCertificate) -> Self {
            let mut v = self.certificates.unwrap_or_default();
            v.push(input);
            self.certificates = Some(v);
            self
        }
        /// <p>A list of the user's signing certificate information.</p>
        pub fn set_certificates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SigningCertificate>>,
        ) -> Self {
            self.certificates = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSigningCertificatesOutput`](crate::output::ListSigningCertificatesOutput)
        pub fn build(self) -> crate::output::ListSigningCertificatesOutput {
            crate::output::ListSigningCertificatesOutput {
                certificates: self.certificates,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl ListSigningCertificatesOutput {
    /// Creates a new builder-style object to manufacture [`ListSigningCertificatesOutput`](crate::output::ListSigningCertificatesOutput)
    pub fn builder() -> crate::output::list_signing_certificates_output::Builder {
        crate::output::list_signing_certificates_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListServiceSpecificCredentialsOutput {
    /// <p>A list of structures that each contain details about a service-specific credential.</p>
    pub service_specific_credentials:
        std::option::Option<std::vec::Vec<crate::model::ServiceSpecificCredentialMetadata>>,
}
impl ListServiceSpecificCredentialsOutput {
    /// <p>A list of structures that each contain details about a service-specific credential.</p>
    pub fn service_specific_credentials(
        &self,
    ) -> std::option::Option<&[crate::model::ServiceSpecificCredentialMetadata]> {
        self.service_specific_credentials.as_deref()
    }
}
impl std::fmt::Debug for ListServiceSpecificCredentialsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListServiceSpecificCredentialsOutput");
        formatter.field(
            "service_specific_credentials",
            &self.service_specific_credentials,
        );
        formatter.finish()
    }
}
/// See [`ListServiceSpecificCredentialsOutput`](crate::output::ListServiceSpecificCredentialsOutput)
pub mod list_service_specific_credentials_output {
    /// A builder for [`ListServiceSpecificCredentialsOutput`](crate::output::ListServiceSpecificCredentialsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_specific_credentials:
            std::option::Option<std::vec::Vec<crate::model::ServiceSpecificCredentialMetadata>>,
    }
    impl Builder {
        /// Appends an item to `service_specific_credentials`.
        ///
        /// To override the contents of this collection use [`set_service_specific_credentials`](Self::set_service_specific_credentials).
        ///
        /// <p>A list of structures that each contain details about a service-specific credential.</p>
        pub fn service_specific_credentials(
            mut self,
            input: crate::model::ServiceSpecificCredentialMetadata,
        ) -> Self {
            let mut v = self.service_specific_credentials.unwrap_or_default();
            v.push(input);
            self.service_specific_credentials = Some(v);
            self
        }
        /// <p>A list of structures that each contain details about a service-specific credential.</p>
        pub fn set_service_specific_credentials(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ServiceSpecificCredentialMetadata>,
            >,
        ) -> Self {
            self.service_specific_credentials = input;
            self
        }
        /// Consumes the builder and constructs a [`ListServiceSpecificCredentialsOutput`](crate::output::ListServiceSpecificCredentialsOutput)
        pub fn build(self) -> crate::output::ListServiceSpecificCredentialsOutput {
            crate::output::ListServiceSpecificCredentialsOutput {
                service_specific_credentials: self.service_specific_credentials,
            }
        }
    }
}
impl ListServiceSpecificCredentialsOutput {
    /// Creates a new builder-style object to manufacture [`ListServiceSpecificCredentialsOutput`](crate::output::ListServiceSpecificCredentialsOutput)
    pub fn builder() -> crate::output::list_service_specific_credentials_output::Builder {
        crate::output::list_service_specific_credentials_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListServerCertificateTagsOutput {
    /// <p>The list of tags that are currently attached to the IAM server certificate. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListServerCertificateTagsOutput {
    /// <p>The list of tags that are currently attached to the IAM server certificate. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListServerCertificateTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListServerCertificateTagsOutput");
        formatter.field("tags", &self.tags);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListServerCertificateTagsOutput`](crate::output::ListServerCertificateTagsOutput)
pub mod list_server_certificate_tags_output {
    /// A builder for [`ListServerCertificateTagsOutput`](crate::output::ListServerCertificateTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags that are currently attached to the IAM server certificate. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The list of tags that are currently attached to the IAM server certificate. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListServerCertificateTagsOutput`](crate::output::ListServerCertificateTagsOutput)
        pub fn build(self) -> crate::output::ListServerCertificateTagsOutput {
            crate::output::ListServerCertificateTagsOutput {
                tags: self.tags,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl ListServerCertificateTagsOutput {
    /// Creates a new builder-style object to manufacture [`ListServerCertificateTagsOutput`](crate::output::ListServerCertificateTagsOutput)
    pub fn builder() -> crate::output::list_server_certificate_tags_output::Builder {
        crate::output::list_server_certificate_tags_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>ListServerCertificates</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListServerCertificatesOutput {
    /// <p>A list of server certificates.</p>
    pub server_certificate_metadata_list:
        std::option::Option<std::vec::Vec<crate::model::ServerCertificateMetadata>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListServerCertificatesOutput {
    /// <p>A list of server certificates.</p>
    pub fn server_certificate_metadata_list(
        &self,
    ) -> std::option::Option<&[crate::model::ServerCertificateMetadata]> {
        self.server_certificate_metadata_list.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListServerCertificatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListServerCertificatesOutput");
        formatter.field(
            "server_certificate_metadata_list",
            &self.server_certificate_metadata_list,
        );
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListServerCertificatesOutput`](crate::output::ListServerCertificatesOutput)
pub mod list_server_certificates_output {
    /// A builder for [`ListServerCertificatesOutput`](crate::output::ListServerCertificatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_certificate_metadata_list:
            std::option::Option<std::vec::Vec<crate::model::ServerCertificateMetadata>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `server_certificate_metadata_list`.
        ///
        /// To override the contents of this collection use [`set_server_certificate_metadata_list`](Self::set_server_certificate_metadata_list).
        ///
        /// <p>A list of server certificates.</p>
        pub fn server_certificate_metadata_list(
            mut self,
            input: crate::model::ServerCertificateMetadata,
        ) -> Self {
            let mut v = self.server_certificate_metadata_list.unwrap_or_default();
            v.push(input);
            self.server_certificate_metadata_list = Some(v);
            self
        }
        /// <p>A list of server certificates.</p>
        pub fn set_server_certificate_metadata_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServerCertificateMetadata>>,
        ) -> Self {
            self.server_certificate_metadata_list = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListServerCertificatesOutput`](crate::output::ListServerCertificatesOutput)
        pub fn build(self) -> crate::output::ListServerCertificatesOutput {
            crate::output::ListServerCertificatesOutput {
                server_certificate_metadata_list: self.server_certificate_metadata_list,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl ListServerCertificatesOutput {
    /// Creates a new builder-style object to manufacture [`ListServerCertificatesOutput`](crate::output::ListServerCertificatesOutput)
    pub fn builder() -> crate::output::list_server_certificates_output::Builder {
        crate::output::list_server_certificates_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSamlProviderTagsOutput {
    /// <p>The list of tags that are currently attached to the Security Assertion Markup Language (SAML) identity provider. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListSamlProviderTagsOutput {
    /// <p>The list of tags that are currently attached to the Security Assertion Markup Language (SAML) identity provider. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListSamlProviderTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSamlProviderTagsOutput");
        formatter.field("tags", &self.tags);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListSamlProviderTagsOutput`](crate::output::ListSamlProviderTagsOutput)
pub mod list_saml_provider_tags_output {
    /// A builder for [`ListSamlProviderTagsOutput`](crate::output::ListSamlProviderTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags that are currently attached to the Security Assertion Markup Language (SAML) identity provider. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The list of tags that are currently attached to the Security Assertion Markup Language (SAML) identity provider. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSamlProviderTagsOutput`](crate::output::ListSamlProviderTagsOutput)
        pub fn build(self) -> crate::output::ListSamlProviderTagsOutput {
            crate::output::ListSamlProviderTagsOutput {
                tags: self.tags,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl ListSamlProviderTagsOutput {
    /// Creates a new builder-style object to manufacture [`ListSamlProviderTagsOutput`](crate::output::ListSamlProviderTagsOutput)
    pub fn builder() -> crate::output::list_saml_provider_tags_output::Builder {
        crate::output::list_saml_provider_tags_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>ListSAMLProviders</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSamlProvidersOutput {
    /// <p>The list of SAML provider resource objects defined in IAM for this Amazon Web Services account.</p>
    pub saml_provider_list: std::option::Option<std::vec::Vec<crate::model::SamlProviderListEntry>>,
}
impl ListSamlProvidersOutput {
    /// <p>The list of SAML provider resource objects defined in IAM for this Amazon Web Services account.</p>
    pub fn saml_provider_list(
        &self,
    ) -> std::option::Option<&[crate::model::SamlProviderListEntry]> {
        self.saml_provider_list.as_deref()
    }
}
impl std::fmt::Debug for ListSamlProvidersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSamlProvidersOutput");
        formatter.field("saml_provider_list", &self.saml_provider_list);
        formatter.finish()
    }
}
/// See [`ListSamlProvidersOutput`](crate::output::ListSamlProvidersOutput)
pub mod list_saml_providers_output {
    /// A builder for [`ListSamlProvidersOutput`](crate::output::ListSamlProvidersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) saml_provider_list:
            std::option::Option<std::vec::Vec<crate::model::SamlProviderListEntry>>,
    }
    impl Builder {
        /// Appends an item to `saml_provider_list`.
        ///
        /// To override the contents of this collection use [`set_saml_provider_list`](Self::set_saml_provider_list).
        ///
        /// <p>The list of SAML provider resource objects defined in IAM for this Amazon Web Services account.</p>
        pub fn saml_provider_list(mut self, input: crate::model::SamlProviderListEntry) -> Self {
            let mut v = self.saml_provider_list.unwrap_or_default();
            v.push(input);
            self.saml_provider_list = Some(v);
            self
        }
        /// <p>The list of SAML provider resource objects defined in IAM for this Amazon Web Services account.</p>
        pub fn set_saml_provider_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SamlProviderListEntry>>,
        ) -> Self {
            self.saml_provider_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSamlProvidersOutput`](crate::output::ListSamlProvidersOutput)
        pub fn build(self) -> crate::output::ListSamlProvidersOutput {
            crate::output::ListSamlProvidersOutput {
                saml_provider_list: self.saml_provider_list,
            }
        }
    }
}
impl ListSamlProvidersOutput {
    /// Creates a new builder-style object to manufacture [`ListSamlProvidersOutput`](crate::output::ListSamlProvidersOutput)
    pub fn builder() -> crate::output::list_saml_providers_output::Builder {
        crate::output::list_saml_providers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRoleTagsOutput {
    /// <p>The list of tags that are currently attached to the role. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListRoleTagsOutput {
    /// <p>The list of tags that are currently attached to the role. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListRoleTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRoleTagsOutput");
        formatter.field("tags", &self.tags);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListRoleTagsOutput`](crate::output::ListRoleTagsOutput)
pub mod list_role_tags_output {
    /// A builder for [`ListRoleTagsOutput`](crate::output::ListRoleTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags that are currently attached to the role. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The list of tags that are currently attached to the role. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRoleTagsOutput`](crate::output::ListRoleTagsOutput)
        pub fn build(self) -> crate::output::ListRoleTagsOutput {
            crate::output::ListRoleTagsOutput {
                tags: self.tags,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl ListRoleTagsOutput {
    /// Creates a new builder-style object to manufacture [`ListRoleTagsOutput`](crate::output::ListRoleTagsOutput)
    pub fn builder() -> crate::output::list_role_tags_output::Builder {
        crate::output::list_role_tags_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>ListRoles</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRolesOutput {
    /// <p>A list of roles.</p>
    pub roles: std::option::Option<std::vec::Vec<crate::model::Role>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListRolesOutput {
    /// <p>A list of roles.</p>
    pub fn roles(&self) -> std::option::Option<&[crate::model::Role]> {
        self.roles.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListRolesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRolesOutput");
        formatter.field("roles", &self.roles);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListRolesOutput`](crate::output::ListRolesOutput)
pub mod list_roles_output {
    /// A builder for [`ListRolesOutput`](crate::output::ListRolesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) roles: std::option::Option<std::vec::Vec<crate::model::Role>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `roles`.
        ///
        /// To override the contents of this collection use [`set_roles`](Self::set_roles).
        ///
        /// <p>A list of roles.</p>
        pub fn roles(mut self, input: crate::model::Role) -> Self {
            let mut v = self.roles.unwrap_or_default();
            v.push(input);
            self.roles = Some(v);
            self
        }
        /// <p>A list of roles.</p>
        pub fn set_roles(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Role>>,
        ) -> Self {
            self.roles = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRolesOutput`](crate::output::ListRolesOutput)
        pub fn build(self) -> crate::output::ListRolesOutput {
            crate::output::ListRolesOutput {
                roles: self.roles,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl ListRolesOutput {
    /// Creates a new builder-style object to manufacture [`ListRolesOutput`](crate::output::ListRolesOutput)
    pub fn builder() -> crate::output::list_roles_output::Builder {
        crate::output::list_roles_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>ListRolePolicies</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRolePoliciesOutput {
    /// <p>A list of policy names.</p>
    pub policy_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListRolePoliciesOutput {
    /// <p>A list of policy names.</p>
    pub fn policy_names(&self) -> std::option::Option<&[std::string::String]> {
        self.policy_names.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListRolePoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRolePoliciesOutput");
        formatter.field("policy_names", &self.policy_names);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListRolePoliciesOutput`](crate::output::ListRolePoliciesOutput)
pub mod list_role_policies_output {
    /// A builder for [`ListRolePoliciesOutput`](crate::output::ListRolePoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `policy_names`.
        ///
        /// To override the contents of this collection use [`set_policy_names`](Self::set_policy_names).
        ///
        /// <p>A list of policy names.</p>
        pub fn policy_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.policy_names.unwrap_or_default();
            v.push(input.into());
            self.policy_names = Some(v);
            self
        }
        /// <p>A list of policy names.</p>
        pub fn set_policy_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.policy_names = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRolePoliciesOutput`](crate::output::ListRolePoliciesOutput)
        pub fn build(self) -> crate::output::ListRolePoliciesOutput {
            crate::output::ListRolePoliciesOutput {
                policy_names: self.policy_names,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl ListRolePoliciesOutput {
    /// Creates a new builder-style object to manufacture [`ListRolePoliciesOutput`](crate::output::ListRolePoliciesOutput)
    pub fn builder() -> crate::output::list_role_policies_output::Builder {
        crate::output::list_role_policies_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>ListPolicyVersions</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPolicyVersionsOutput {
    /// <p>A list of policy versions.</p>
    /// <p>For more information about managed policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed policies</a> in the <i>IAM User Guide</i>.</p>
    pub versions: std::option::Option<std::vec::Vec<crate::model::PolicyVersion>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListPolicyVersionsOutput {
    /// <p>A list of policy versions.</p>
    /// <p>For more information about managed policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed policies</a> in the <i>IAM User Guide</i>.</p>
    pub fn versions(&self) -> std::option::Option<&[crate::model::PolicyVersion]> {
        self.versions.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListPolicyVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPolicyVersionsOutput");
        formatter.field("versions", &self.versions);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListPolicyVersionsOutput`](crate::output::ListPolicyVersionsOutput)
pub mod list_policy_versions_output {
    /// A builder for [`ListPolicyVersionsOutput`](crate::output::ListPolicyVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) versions: std::option::Option<std::vec::Vec<crate::model::PolicyVersion>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `versions`.
        ///
        /// To override the contents of this collection use [`set_versions`](Self::set_versions).
        ///
        /// <p>A list of policy versions.</p>
        /// <p>For more information about managed policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed policies</a> in the <i>IAM User Guide</i>.</p>
        pub fn versions(mut self, input: crate::model::PolicyVersion) -> Self {
            let mut v = self.versions.unwrap_or_default();
            v.push(input);
            self.versions = Some(v);
            self
        }
        /// <p>A list of policy versions.</p>
        /// <p>For more information about managed policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed policies</a> in the <i>IAM User Guide</i>.</p>
        pub fn set_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PolicyVersion>>,
        ) -> Self {
            self.versions = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPolicyVersionsOutput`](crate::output::ListPolicyVersionsOutput)
        pub fn build(self) -> crate::output::ListPolicyVersionsOutput {
            crate::output::ListPolicyVersionsOutput {
                versions: self.versions,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl ListPolicyVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListPolicyVersionsOutput`](crate::output::ListPolicyVersionsOutput)
    pub fn builder() -> crate::output::list_policy_versions_output::Builder {
        crate::output::list_policy_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPolicyTagsOutput {
    /// <p>The list of tags that are currently attached to the IAM customer managed policy. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListPolicyTagsOutput {
    /// <p>The list of tags that are currently attached to the IAM customer managed policy. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListPolicyTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPolicyTagsOutput");
        formatter.field("tags", &self.tags);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListPolicyTagsOutput`](crate::output::ListPolicyTagsOutput)
pub mod list_policy_tags_output {
    /// A builder for [`ListPolicyTagsOutput`](crate::output::ListPolicyTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags that are currently attached to the IAM customer managed policy. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The list of tags that are currently attached to the IAM customer managed policy. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPolicyTagsOutput`](crate::output::ListPolicyTagsOutput)
        pub fn build(self) -> crate::output::ListPolicyTagsOutput {
            crate::output::ListPolicyTagsOutput {
                tags: self.tags,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl ListPolicyTagsOutput {
    /// Creates a new builder-style object to manufacture [`ListPolicyTagsOutput`](crate::output::ListPolicyTagsOutput)
    pub fn builder() -> crate::output::list_policy_tags_output::Builder {
        crate::output::list_policy_tags_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPoliciesGrantingServiceAccessOutput {
    /// <p>A&nbsp;<code>ListPoliciesGrantingServiceAccess</code> object that contains details about the permissions policies attached to the specified identity (user, group, or role).</p>
    pub policies_granting_service_access:
        std::option::Option<std::vec::Vec<crate::model::ListPoliciesGrantingServiceAccessEntry>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListPoliciesGrantingServiceAccessOutput {
    /// <p>A&nbsp;<code>ListPoliciesGrantingServiceAccess</code> object that contains details about the permissions policies attached to the specified identity (user, group, or role).</p>
    pub fn policies_granting_service_access(
        &self,
    ) -> std::option::Option<&[crate::model::ListPoliciesGrantingServiceAccessEntry]> {
        self.policies_granting_service_access.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListPoliciesGrantingServiceAccessOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPoliciesGrantingServiceAccessOutput");
        formatter.field(
            "policies_granting_service_access",
            &self.policies_granting_service_access,
        );
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListPoliciesGrantingServiceAccessOutput`](crate::output::ListPoliciesGrantingServiceAccessOutput)
pub mod list_policies_granting_service_access_output {
    /// A builder for [`ListPoliciesGrantingServiceAccessOutput`](crate::output::ListPoliciesGrantingServiceAccessOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policies_granting_service_access: std::option::Option<
            std::vec::Vec<crate::model::ListPoliciesGrantingServiceAccessEntry>,
        >,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `policies_granting_service_access`.
        ///
        /// To override the contents of this collection use [`set_policies_granting_service_access`](Self::set_policies_granting_service_access).
        ///
        /// <p>A&nbsp;<code>ListPoliciesGrantingServiceAccess</code> object that contains details about the permissions policies attached to the specified identity (user, group, or role).</p>
        pub fn policies_granting_service_access(
            mut self,
            input: crate::model::ListPoliciesGrantingServiceAccessEntry,
        ) -> Self {
            let mut v = self.policies_granting_service_access.unwrap_or_default();
            v.push(input);
            self.policies_granting_service_access = Some(v);
            self
        }
        /// <p>A&nbsp;<code>ListPoliciesGrantingServiceAccess</code> object that contains details about the permissions policies attached to the specified identity (user, group, or role).</p>
        pub fn set_policies_granting_service_access(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ListPoliciesGrantingServiceAccessEntry>,
            >,
        ) -> Self {
            self.policies_granting_service_access = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPoliciesGrantingServiceAccessOutput`](crate::output::ListPoliciesGrantingServiceAccessOutput)
        pub fn build(self) -> crate::output::ListPoliciesGrantingServiceAccessOutput {
            crate::output::ListPoliciesGrantingServiceAccessOutput {
                policies_granting_service_access: self.policies_granting_service_access,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl ListPoliciesGrantingServiceAccessOutput {
    /// Creates a new builder-style object to manufacture [`ListPoliciesGrantingServiceAccessOutput`](crate::output::ListPoliciesGrantingServiceAccessOutput)
    pub fn builder() -> crate::output::list_policies_granting_service_access_output::Builder {
        crate::output::list_policies_granting_service_access_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>ListPolicies</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPoliciesOutput {
    /// <p>A list of policies.</p>
    pub policies: std::option::Option<std::vec::Vec<crate::model::Policy>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListPoliciesOutput {
    /// <p>A list of policies.</p>
    pub fn policies(&self) -> std::option::Option<&[crate::model::Policy]> {
        self.policies.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListPoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPoliciesOutput");
        formatter.field("policies", &self.policies);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListPoliciesOutput`](crate::output::ListPoliciesOutput)
pub mod list_policies_output {
    /// A builder for [`ListPoliciesOutput`](crate::output::ListPoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policies: std::option::Option<std::vec::Vec<crate::model::Policy>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `policies`.
        ///
        /// To override the contents of this collection use [`set_policies`](Self::set_policies).
        ///
        /// <p>A list of policies.</p>
        pub fn policies(mut self, input: crate::model::Policy) -> Self {
            let mut v = self.policies.unwrap_or_default();
            v.push(input);
            self.policies = Some(v);
            self
        }
        /// <p>A list of policies.</p>
        pub fn set_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Policy>>,
        ) -> Self {
            self.policies = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPoliciesOutput`](crate::output::ListPoliciesOutput)
        pub fn build(self) -> crate::output::ListPoliciesOutput {
            crate::output::ListPoliciesOutput {
                policies: self.policies,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl ListPoliciesOutput {
    /// Creates a new builder-style object to manufacture [`ListPoliciesOutput`](crate::output::ListPoliciesOutput)
    pub fn builder() -> crate::output::list_policies_output::Builder {
        crate::output::list_policies_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOpenIdConnectProviderTagsOutput {
    /// <p>The list of tags that are currently attached to the OpenID Connect (OIDC) identity provider. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListOpenIdConnectProviderTagsOutput {
    /// <p>The list of tags that are currently attached to the OpenID Connect (OIDC) identity provider. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListOpenIdConnectProviderTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOpenIdConnectProviderTagsOutput");
        formatter.field("tags", &self.tags);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListOpenIdConnectProviderTagsOutput`](crate::output::ListOpenIdConnectProviderTagsOutput)
pub mod list_open_id_connect_provider_tags_output {
    /// A builder for [`ListOpenIdConnectProviderTagsOutput`](crate::output::ListOpenIdConnectProviderTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags that are currently attached to the OpenID Connect (OIDC) identity provider. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The list of tags that are currently attached to the OpenID Connect (OIDC) identity provider. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOpenIdConnectProviderTagsOutput`](crate::output::ListOpenIdConnectProviderTagsOutput)
        pub fn build(self) -> crate::output::ListOpenIdConnectProviderTagsOutput {
            crate::output::ListOpenIdConnectProviderTagsOutput {
                tags: self.tags,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl ListOpenIdConnectProviderTagsOutput {
    /// Creates a new builder-style object to manufacture [`ListOpenIdConnectProviderTagsOutput`](crate::output::ListOpenIdConnectProviderTagsOutput)
    pub fn builder() -> crate::output::list_open_id_connect_provider_tags_output::Builder {
        crate::output::list_open_id_connect_provider_tags_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>ListOpenIDConnectProviders</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOpenIdConnectProvidersOutput {
    /// <p>The list of IAM OIDC provider resource objects defined in the Amazon Web Services account.</p>
    pub open_id_connect_provider_list:
        std::option::Option<std::vec::Vec<crate::model::OpenIdConnectProviderListEntry>>,
}
impl ListOpenIdConnectProvidersOutput {
    /// <p>The list of IAM OIDC provider resource objects defined in the Amazon Web Services account.</p>
    pub fn open_id_connect_provider_list(
        &self,
    ) -> std::option::Option<&[crate::model::OpenIdConnectProviderListEntry]> {
        self.open_id_connect_provider_list.as_deref()
    }
}
impl std::fmt::Debug for ListOpenIdConnectProvidersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOpenIdConnectProvidersOutput");
        formatter.field(
            "open_id_connect_provider_list",
            &self.open_id_connect_provider_list,
        );
        formatter.finish()
    }
}
/// See [`ListOpenIdConnectProvidersOutput`](crate::output::ListOpenIdConnectProvidersOutput)
pub mod list_open_id_connect_providers_output {
    /// A builder for [`ListOpenIdConnectProvidersOutput`](crate::output::ListOpenIdConnectProvidersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) open_id_connect_provider_list:
            std::option::Option<std::vec::Vec<crate::model::OpenIdConnectProviderListEntry>>,
    }
    impl Builder {
        /// Appends an item to `open_id_connect_provider_list`.
        ///
        /// To override the contents of this collection use [`set_open_id_connect_provider_list`](Self::set_open_id_connect_provider_list).
        ///
        /// <p>The list of IAM OIDC provider resource objects defined in the Amazon Web Services account.</p>
        pub fn open_id_connect_provider_list(
            mut self,
            input: crate::model::OpenIdConnectProviderListEntry,
        ) -> Self {
            let mut v = self.open_id_connect_provider_list.unwrap_or_default();
            v.push(input);
            self.open_id_connect_provider_list = Some(v);
            self
        }
        /// <p>The list of IAM OIDC provider resource objects defined in the Amazon Web Services account.</p>
        pub fn set_open_id_connect_provider_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OpenIdConnectProviderListEntry>>,
        ) -> Self {
            self.open_id_connect_provider_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOpenIdConnectProvidersOutput`](crate::output::ListOpenIdConnectProvidersOutput)
        pub fn build(self) -> crate::output::ListOpenIdConnectProvidersOutput {
            crate::output::ListOpenIdConnectProvidersOutput {
                open_id_connect_provider_list: self.open_id_connect_provider_list,
            }
        }
    }
}
impl ListOpenIdConnectProvidersOutput {
    /// Creates a new builder-style object to manufacture [`ListOpenIdConnectProvidersOutput`](crate::output::ListOpenIdConnectProvidersOutput)
    pub fn builder() -> crate::output::list_open_id_connect_providers_output::Builder {
        crate::output::list_open_id_connect_providers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMfaDeviceTagsOutput {
    /// <p>The list of tags that are currently attached to the virtual MFA device. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListMfaDeviceTagsOutput {
    /// <p>The list of tags that are currently attached to the virtual MFA device. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListMfaDeviceTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMfaDeviceTagsOutput");
        formatter.field("tags", &self.tags);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListMfaDeviceTagsOutput`](crate::output::ListMfaDeviceTagsOutput)
pub mod list_mfa_device_tags_output {
    /// A builder for [`ListMfaDeviceTagsOutput`](crate::output::ListMfaDeviceTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags that are currently attached to the virtual MFA device. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The list of tags that are currently attached to the virtual MFA device. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMfaDeviceTagsOutput`](crate::output::ListMfaDeviceTagsOutput)
        pub fn build(self) -> crate::output::ListMfaDeviceTagsOutput {
            crate::output::ListMfaDeviceTagsOutput {
                tags: self.tags,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl ListMfaDeviceTagsOutput {
    /// Creates a new builder-style object to manufacture [`ListMfaDeviceTagsOutput`](crate::output::ListMfaDeviceTagsOutput)
    pub fn builder() -> crate::output::list_mfa_device_tags_output::Builder {
        crate::output::list_mfa_device_tags_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>ListMFADevices</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMfaDevicesOutput {
    /// <p>A list of MFA devices.</p>
    pub mfa_devices: std::option::Option<std::vec::Vec<crate::model::MfaDevice>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListMfaDevicesOutput {
    /// <p>A list of MFA devices.</p>
    pub fn mfa_devices(&self) -> std::option::Option<&[crate::model::MfaDevice]> {
        self.mfa_devices.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListMfaDevicesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMfaDevicesOutput");
        formatter.field("mfa_devices", &self.mfa_devices);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListMfaDevicesOutput`](crate::output::ListMfaDevicesOutput)
pub mod list_mfa_devices_output {
    /// A builder for [`ListMfaDevicesOutput`](crate::output::ListMfaDevicesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mfa_devices: std::option::Option<std::vec::Vec<crate::model::MfaDevice>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `mfa_devices`.
        ///
        /// To override the contents of this collection use [`set_mfa_devices`](Self::set_mfa_devices).
        ///
        /// <p>A list of MFA devices.</p>
        pub fn mfa_devices(mut self, input: crate::model::MfaDevice) -> Self {
            let mut v = self.mfa_devices.unwrap_or_default();
            v.push(input);
            self.mfa_devices = Some(v);
            self
        }
        /// <p>A list of MFA devices.</p>
        pub fn set_mfa_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MfaDevice>>,
        ) -> Self {
            self.mfa_devices = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMfaDevicesOutput`](crate::output::ListMfaDevicesOutput)
        pub fn build(self) -> crate::output::ListMfaDevicesOutput {
            crate::output::ListMfaDevicesOutput {
                mfa_devices: self.mfa_devices,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl ListMfaDevicesOutput {
    /// Creates a new builder-style object to manufacture [`ListMfaDevicesOutput`](crate::output::ListMfaDevicesOutput)
    pub fn builder() -> crate::output::list_mfa_devices_output::Builder {
        crate::output::list_mfa_devices_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInstanceProfileTagsOutput {
    /// <p>The list of tags that are currently attached to the IAM instance profile. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListInstanceProfileTagsOutput {
    /// <p>The list of tags that are currently attached to the IAM instance profile. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListInstanceProfileTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInstanceProfileTagsOutput");
        formatter.field("tags", &self.tags);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListInstanceProfileTagsOutput`](crate::output::ListInstanceProfileTagsOutput)
pub mod list_instance_profile_tags_output {
    /// A builder for [`ListInstanceProfileTagsOutput`](crate::output::ListInstanceProfileTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags that are currently attached to the IAM instance profile. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The list of tags that are currently attached to the IAM instance profile. Each tag consists of a key name and an associated value. If no tags are attached to the specified resource, the response contains an empty list.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInstanceProfileTagsOutput`](crate::output::ListInstanceProfileTagsOutput)
        pub fn build(self) -> crate::output::ListInstanceProfileTagsOutput {
            crate::output::ListInstanceProfileTagsOutput {
                tags: self.tags,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl ListInstanceProfileTagsOutput {
    /// Creates a new builder-style object to manufacture [`ListInstanceProfileTagsOutput`](crate::output::ListInstanceProfileTagsOutput)
    pub fn builder() -> crate::output::list_instance_profile_tags_output::Builder {
        crate::output::list_instance_profile_tags_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>ListInstanceProfilesForRole</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInstanceProfilesForRoleOutput {
    /// <p>A list of instance profiles.</p>
    pub instance_profiles: std::option::Option<std::vec::Vec<crate::model::InstanceProfile>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListInstanceProfilesForRoleOutput {
    /// <p>A list of instance profiles.</p>
    pub fn instance_profiles(&self) -> std::option::Option<&[crate::model::InstanceProfile]> {
        self.instance_profiles.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListInstanceProfilesForRoleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInstanceProfilesForRoleOutput");
        formatter.field("instance_profiles", &self.instance_profiles);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListInstanceProfilesForRoleOutput`](crate::output::ListInstanceProfilesForRoleOutput)
pub mod list_instance_profiles_for_role_output {
    /// A builder for [`ListInstanceProfilesForRoleOutput`](crate::output::ListInstanceProfilesForRoleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_profiles:
            std::option::Option<std::vec::Vec<crate::model::InstanceProfile>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `instance_profiles`.
        ///
        /// To override the contents of this collection use [`set_instance_profiles`](Self::set_instance_profiles).
        ///
        /// <p>A list of instance profiles.</p>
        pub fn instance_profiles(mut self, input: crate::model::InstanceProfile) -> Self {
            let mut v = self.instance_profiles.unwrap_or_default();
            v.push(input);
            self.instance_profiles = Some(v);
            self
        }
        /// <p>A list of instance profiles.</p>
        pub fn set_instance_profiles(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceProfile>>,
        ) -> Self {
            self.instance_profiles = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInstanceProfilesForRoleOutput`](crate::output::ListInstanceProfilesForRoleOutput)
        pub fn build(self) -> crate::output::ListInstanceProfilesForRoleOutput {
            crate::output::ListInstanceProfilesForRoleOutput {
                instance_profiles: self.instance_profiles,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl ListInstanceProfilesForRoleOutput {
    /// Creates a new builder-style object to manufacture [`ListInstanceProfilesForRoleOutput`](crate::output::ListInstanceProfilesForRoleOutput)
    pub fn builder() -> crate::output::list_instance_profiles_for_role_output::Builder {
        crate::output::list_instance_profiles_for_role_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>ListInstanceProfiles</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInstanceProfilesOutput {
    /// <p>A list of instance profiles.</p>
    pub instance_profiles: std::option::Option<std::vec::Vec<crate::model::InstanceProfile>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListInstanceProfilesOutput {
    /// <p>A list of instance profiles.</p>
    pub fn instance_profiles(&self) -> std::option::Option<&[crate::model::InstanceProfile]> {
        self.instance_profiles.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListInstanceProfilesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInstanceProfilesOutput");
        formatter.field("instance_profiles", &self.instance_profiles);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListInstanceProfilesOutput`](crate::output::ListInstanceProfilesOutput)
pub mod list_instance_profiles_output {
    /// A builder for [`ListInstanceProfilesOutput`](crate::output::ListInstanceProfilesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_profiles:
            std::option::Option<std::vec::Vec<crate::model::InstanceProfile>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `instance_profiles`.
        ///
        /// To override the contents of this collection use [`set_instance_profiles`](Self::set_instance_profiles).
        ///
        /// <p>A list of instance profiles.</p>
        pub fn instance_profiles(mut self, input: crate::model::InstanceProfile) -> Self {
            let mut v = self.instance_profiles.unwrap_or_default();
            v.push(input);
            self.instance_profiles = Some(v);
            self
        }
        /// <p>A list of instance profiles.</p>
        pub fn set_instance_profiles(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceProfile>>,
        ) -> Self {
            self.instance_profiles = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInstanceProfilesOutput`](crate::output::ListInstanceProfilesOutput)
        pub fn build(self) -> crate::output::ListInstanceProfilesOutput {
            crate::output::ListInstanceProfilesOutput {
                instance_profiles: self.instance_profiles,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl ListInstanceProfilesOutput {
    /// Creates a new builder-style object to manufacture [`ListInstanceProfilesOutput`](crate::output::ListInstanceProfilesOutput)
    pub fn builder() -> crate::output::list_instance_profiles_output::Builder {
        crate::output::list_instance_profiles_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>ListGroupsForUser</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGroupsForUserOutput {
    /// <p>A list of groups.</p>
    pub groups: std::option::Option<std::vec::Vec<crate::model::Group>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListGroupsForUserOutput {
    /// <p>A list of groups.</p>
    pub fn groups(&self) -> std::option::Option<&[crate::model::Group]> {
        self.groups.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListGroupsForUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGroupsForUserOutput");
        formatter.field("groups", &self.groups);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListGroupsForUserOutput`](crate::output::ListGroupsForUserOutput)
pub mod list_groups_for_user_output {
    /// A builder for [`ListGroupsForUserOutput`](crate::output::ListGroupsForUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) groups: std::option::Option<std::vec::Vec<crate::model::Group>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>A list of groups.</p>
        pub fn groups(mut self, input: crate::model::Group) -> Self {
            let mut v = self.groups.unwrap_or_default();
            v.push(input);
            self.groups = Some(v);
            self
        }
        /// <p>A list of groups.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Group>>,
        ) -> Self {
            self.groups = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGroupsForUserOutput`](crate::output::ListGroupsForUserOutput)
        pub fn build(self) -> crate::output::ListGroupsForUserOutput {
            crate::output::ListGroupsForUserOutput {
                groups: self.groups,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl ListGroupsForUserOutput {
    /// Creates a new builder-style object to manufacture [`ListGroupsForUserOutput`](crate::output::ListGroupsForUserOutput)
    pub fn builder() -> crate::output::list_groups_for_user_output::Builder {
        crate::output::list_groups_for_user_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>ListGroups</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGroupsOutput {
    /// <p>A list of groups.</p>
    pub groups: std::option::Option<std::vec::Vec<crate::model::Group>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListGroupsOutput {
    /// <p>A list of groups.</p>
    pub fn groups(&self) -> std::option::Option<&[crate::model::Group]> {
        self.groups.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGroupsOutput");
        formatter.field("groups", &self.groups);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListGroupsOutput`](crate::output::ListGroupsOutput)
pub mod list_groups_output {
    /// A builder for [`ListGroupsOutput`](crate::output::ListGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) groups: std::option::Option<std::vec::Vec<crate::model::Group>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>A list of groups.</p>
        pub fn groups(mut self, input: crate::model::Group) -> Self {
            let mut v = self.groups.unwrap_or_default();
            v.push(input);
            self.groups = Some(v);
            self
        }
        /// <p>A list of groups.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Group>>,
        ) -> Self {
            self.groups = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGroupsOutput`](crate::output::ListGroupsOutput)
        pub fn build(self) -> crate::output::ListGroupsOutput {
            crate::output::ListGroupsOutput {
                groups: self.groups,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl ListGroupsOutput {
    /// Creates a new builder-style object to manufacture [`ListGroupsOutput`](crate::output::ListGroupsOutput)
    pub fn builder() -> crate::output::list_groups_output::Builder {
        crate::output::list_groups_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>ListGroupPolicies</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGroupPoliciesOutput {
    /// <p>A list of policy names.</p>
    /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub policy_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListGroupPoliciesOutput {
    /// <p>A list of policy names.</p>
    /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
    pub fn policy_names(&self) -> std::option::Option<&[std::string::String]> {
        self.policy_names.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListGroupPoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGroupPoliciesOutput");
        formatter.field("policy_names", &self.policy_names);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListGroupPoliciesOutput`](crate::output::ListGroupPoliciesOutput)
pub mod list_group_policies_output {
    /// A builder for [`ListGroupPoliciesOutput`](crate::output::ListGroupPoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `policy_names`.
        ///
        /// To override the contents of this collection use [`set_policy_names`](Self::set_policy_names).
        ///
        /// <p>A list of policy names.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn policy_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.policy_names.unwrap_or_default();
            v.push(input.into());
            self.policy_names = Some(v);
            self
        }
        /// <p>A list of policy names.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_policy_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.policy_names = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGroupPoliciesOutput`](crate::output::ListGroupPoliciesOutput)
        pub fn build(self) -> crate::output::ListGroupPoliciesOutput {
            crate::output::ListGroupPoliciesOutput {
                policy_names: self.policy_names,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl ListGroupPoliciesOutput {
    /// Creates a new builder-style object to manufacture [`ListGroupPoliciesOutput`](crate::output::ListGroupPoliciesOutput)
    pub fn builder() -> crate::output::list_group_policies_output::Builder {
        crate::output::list_group_policies_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>ListEntitiesForPolicy</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEntitiesForPolicyOutput {
    /// <p>A list of IAM groups that the policy is attached to.</p>
    pub policy_groups: std::option::Option<std::vec::Vec<crate::model::PolicyGroup>>,
    /// <p>A list of IAM users that the policy is attached to.</p>
    pub policy_users: std::option::Option<std::vec::Vec<crate::model::PolicyUser>>,
    /// <p>A list of IAM roles that the policy is attached to.</p>
    pub policy_roles: std::option::Option<std::vec::Vec<crate::model::PolicyRole>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListEntitiesForPolicyOutput {
    /// <p>A list of IAM groups that the policy is attached to.</p>
    pub fn policy_groups(&self) -> std::option::Option<&[crate::model::PolicyGroup]> {
        self.policy_groups.as_deref()
    }
    /// <p>A list of IAM users that the policy is attached to.</p>
    pub fn policy_users(&self) -> std::option::Option<&[crate::model::PolicyUser]> {
        self.policy_users.as_deref()
    }
    /// <p>A list of IAM roles that the policy is attached to.</p>
    pub fn policy_roles(&self) -> std::option::Option<&[crate::model::PolicyRole]> {
        self.policy_roles.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListEntitiesForPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEntitiesForPolicyOutput");
        formatter.field("policy_groups", &self.policy_groups);
        formatter.field("policy_users", &self.policy_users);
        formatter.field("policy_roles", &self.policy_roles);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListEntitiesForPolicyOutput`](crate::output::ListEntitiesForPolicyOutput)
pub mod list_entities_for_policy_output {
    /// A builder for [`ListEntitiesForPolicyOutput`](crate::output::ListEntitiesForPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_groups: std::option::Option<std::vec::Vec<crate::model::PolicyGroup>>,
        pub(crate) policy_users: std::option::Option<std::vec::Vec<crate::model::PolicyUser>>,
        pub(crate) policy_roles: std::option::Option<std::vec::Vec<crate::model::PolicyRole>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `policy_groups`.
        ///
        /// To override the contents of this collection use [`set_policy_groups`](Self::set_policy_groups).
        ///
        /// <p>A list of IAM groups that the policy is attached to.</p>
        pub fn policy_groups(mut self, input: crate::model::PolicyGroup) -> Self {
            let mut v = self.policy_groups.unwrap_or_default();
            v.push(input);
            self.policy_groups = Some(v);
            self
        }
        /// <p>A list of IAM groups that the policy is attached to.</p>
        pub fn set_policy_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PolicyGroup>>,
        ) -> Self {
            self.policy_groups = input;
            self
        }
        /// Appends an item to `policy_users`.
        ///
        /// To override the contents of this collection use [`set_policy_users`](Self::set_policy_users).
        ///
        /// <p>A list of IAM users that the policy is attached to.</p>
        pub fn policy_users(mut self, input: crate::model::PolicyUser) -> Self {
            let mut v = self.policy_users.unwrap_or_default();
            v.push(input);
            self.policy_users = Some(v);
            self
        }
        /// <p>A list of IAM users that the policy is attached to.</p>
        pub fn set_policy_users(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PolicyUser>>,
        ) -> Self {
            self.policy_users = input;
            self
        }
        /// Appends an item to `policy_roles`.
        ///
        /// To override the contents of this collection use [`set_policy_roles`](Self::set_policy_roles).
        ///
        /// <p>A list of IAM roles that the policy is attached to.</p>
        pub fn policy_roles(mut self, input: crate::model::PolicyRole) -> Self {
            let mut v = self.policy_roles.unwrap_or_default();
            v.push(input);
            self.policy_roles = Some(v);
            self
        }
        /// <p>A list of IAM roles that the policy is attached to.</p>
        pub fn set_policy_roles(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PolicyRole>>,
        ) -> Self {
            self.policy_roles = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEntitiesForPolicyOutput`](crate::output::ListEntitiesForPolicyOutput)
        pub fn build(self) -> crate::output::ListEntitiesForPolicyOutput {
            crate::output::ListEntitiesForPolicyOutput {
                policy_groups: self.policy_groups,
                policy_users: self.policy_users,
                policy_roles: self.policy_roles,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl ListEntitiesForPolicyOutput {
    /// Creates a new builder-style object to manufacture [`ListEntitiesForPolicyOutput`](crate::output::ListEntitiesForPolicyOutput)
    pub fn builder() -> crate::output::list_entities_for_policy_output::Builder {
        crate::output::list_entities_for_policy_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>ListAttachedUserPolicies</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAttachedUserPoliciesOutput {
    /// <p>A list of the attached policies.</p>
    pub attached_policies: std::option::Option<std::vec::Vec<crate::model::AttachedPolicy>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListAttachedUserPoliciesOutput {
    /// <p>A list of the attached policies.</p>
    pub fn attached_policies(&self) -> std::option::Option<&[crate::model::AttachedPolicy]> {
        self.attached_policies.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListAttachedUserPoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAttachedUserPoliciesOutput");
        formatter.field("attached_policies", &self.attached_policies);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListAttachedUserPoliciesOutput`](crate::output::ListAttachedUserPoliciesOutput)
pub mod list_attached_user_policies_output {
    /// A builder for [`ListAttachedUserPoliciesOutput`](crate::output::ListAttachedUserPoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attached_policies:
            std::option::Option<std::vec::Vec<crate::model::AttachedPolicy>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `attached_policies`.
        ///
        /// To override the contents of this collection use [`set_attached_policies`](Self::set_attached_policies).
        ///
        /// <p>A list of the attached policies.</p>
        pub fn attached_policies(mut self, input: crate::model::AttachedPolicy) -> Self {
            let mut v = self.attached_policies.unwrap_or_default();
            v.push(input);
            self.attached_policies = Some(v);
            self
        }
        /// <p>A list of the attached policies.</p>
        pub fn set_attached_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttachedPolicy>>,
        ) -> Self {
            self.attached_policies = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAttachedUserPoliciesOutput`](crate::output::ListAttachedUserPoliciesOutput)
        pub fn build(self) -> crate::output::ListAttachedUserPoliciesOutput {
            crate::output::ListAttachedUserPoliciesOutput {
                attached_policies: self.attached_policies,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl ListAttachedUserPoliciesOutput {
    /// Creates a new builder-style object to manufacture [`ListAttachedUserPoliciesOutput`](crate::output::ListAttachedUserPoliciesOutput)
    pub fn builder() -> crate::output::list_attached_user_policies_output::Builder {
        crate::output::list_attached_user_policies_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>ListAttachedRolePolicies</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAttachedRolePoliciesOutput {
    /// <p>A list of the attached policies.</p>
    pub attached_policies: std::option::Option<std::vec::Vec<crate::model::AttachedPolicy>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListAttachedRolePoliciesOutput {
    /// <p>A list of the attached policies.</p>
    pub fn attached_policies(&self) -> std::option::Option<&[crate::model::AttachedPolicy]> {
        self.attached_policies.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListAttachedRolePoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAttachedRolePoliciesOutput");
        formatter.field("attached_policies", &self.attached_policies);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListAttachedRolePoliciesOutput`](crate::output::ListAttachedRolePoliciesOutput)
pub mod list_attached_role_policies_output {
    /// A builder for [`ListAttachedRolePoliciesOutput`](crate::output::ListAttachedRolePoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attached_policies:
            std::option::Option<std::vec::Vec<crate::model::AttachedPolicy>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `attached_policies`.
        ///
        /// To override the contents of this collection use [`set_attached_policies`](Self::set_attached_policies).
        ///
        /// <p>A list of the attached policies.</p>
        pub fn attached_policies(mut self, input: crate::model::AttachedPolicy) -> Self {
            let mut v = self.attached_policies.unwrap_or_default();
            v.push(input);
            self.attached_policies = Some(v);
            self
        }
        /// <p>A list of the attached policies.</p>
        pub fn set_attached_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttachedPolicy>>,
        ) -> Self {
            self.attached_policies = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAttachedRolePoliciesOutput`](crate::output::ListAttachedRolePoliciesOutput)
        pub fn build(self) -> crate::output::ListAttachedRolePoliciesOutput {
            crate::output::ListAttachedRolePoliciesOutput {
                attached_policies: self.attached_policies,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl ListAttachedRolePoliciesOutput {
    /// Creates a new builder-style object to manufacture [`ListAttachedRolePoliciesOutput`](crate::output::ListAttachedRolePoliciesOutput)
    pub fn builder() -> crate::output::list_attached_role_policies_output::Builder {
        crate::output::list_attached_role_policies_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>ListAttachedGroupPolicies</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAttachedGroupPoliciesOutput {
    /// <p>A list of the attached policies.</p>
    pub attached_policies: std::option::Option<std::vec::Vec<crate::model::AttachedPolicy>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListAttachedGroupPoliciesOutput {
    /// <p>A list of the attached policies.</p>
    pub fn attached_policies(&self) -> std::option::Option<&[crate::model::AttachedPolicy]> {
        self.attached_policies.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListAttachedGroupPoliciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAttachedGroupPoliciesOutput");
        formatter.field("attached_policies", &self.attached_policies);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListAttachedGroupPoliciesOutput`](crate::output::ListAttachedGroupPoliciesOutput)
pub mod list_attached_group_policies_output {
    /// A builder for [`ListAttachedGroupPoliciesOutput`](crate::output::ListAttachedGroupPoliciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attached_policies:
            std::option::Option<std::vec::Vec<crate::model::AttachedPolicy>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `attached_policies`.
        ///
        /// To override the contents of this collection use [`set_attached_policies`](Self::set_attached_policies).
        ///
        /// <p>A list of the attached policies.</p>
        pub fn attached_policies(mut self, input: crate::model::AttachedPolicy) -> Self {
            let mut v = self.attached_policies.unwrap_or_default();
            v.push(input);
            self.attached_policies = Some(v);
            self
        }
        /// <p>A list of the attached policies.</p>
        pub fn set_attached_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttachedPolicy>>,
        ) -> Self {
            self.attached_policies = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAttachedGroupPoliciesOutput`](crate::output::ListAttachedGroupPoliciesOutput)
        pub fn build(self) -> crate::output::ListAttachedGroupPoliciesOutput {
            crate::output::ListAttachedGroupPoliciesOutput {
                attached_policies: self.attached_policies,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl ListAttachedGroupPoliciesOutput {
    /// Creates a new builder-style object to manufacture [`ListAttachedGroupPoliciesOutput`](crate::output::ListAttachedGroupPoliciesOutput)
    pub fn builder() -> crate::output::list_attached_group_policies_output::Builder {
        crate::output::list_attached_group_policies_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>ListAccountAliases</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAccountAliasesOutput {
    /// <p>A list of aliases associated with the account. Amazon Web Services supports only one alias per account.</p>
    pub account_aliases: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListAccountAliasesOutput {
    /// <p>A list of aliases associated with the account. Amazon Web Services supports only one alias per account.</p>
    pub fn account_aliases(&self) -> std::option::Option<&[std::string::String]> {
        self.account_aliases.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListAccountAliasesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAccountAliasesOutput");
        formatter.field("account_aliases", &self.account_aliases);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListAccountAliasesOutput`](crate::output::ListAccountAliasesOutput)
pub mod list_account_aliases_output {
    /// A builder for [`ListAccountAliasesOutput`](crate::output::ListAccountAliasesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_aliases: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `account_aliases`.
        ///
        /// To override the contents of this collection use [`set_account_aliases`](Self::set_account_aliases).
        ///
        /// <p>A list of aliases associated with the account. Amazon Web Services supports only one alias per account.</p>
        pub fn account_aliases(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_aliases.unwrap_or_default();
            v.push(input.into());
            self.account_aliases = Some(v);
            self
        }
        /// <p>A list of aliases associated with the account. Amazon Web Services supports only one alias per account.</p>
        pub fn set_account_aliases(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_aliases = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccountAliasesOutput`](crate::output::ListAccountAliasesOutput)
        pub fn build(self) -> crate::output::ListAccountAliasesOutput {
            crate::output::ListAccountAliasesOutput {
                account_aliases: self.account_aliases,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl ListAccountAliasesOutput {
    /// Creates a new builder-style object to manufacture [`ListAccountAliasesOutput`](crate::output::ListAccountAliasesOutput)
    pub fn builder() -> crate::output::list_account_aliases_output::Builder {
        crate::output::list_account_aliases_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>ListAccessKeys</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAccessKeysOutput {
    /// <p>A list of objects containing metadata about the access keys.</p>
    pub access_key_metadata: std::option::Option<std::vec::Vec<crate::model::AccessKeyMetadata>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl ListAccessKeysOutput {
    /// <p>A list of objects containing metadata about the access keys.</p>
    pub fn access_key_metadata(&self) -> std::option::Option<&[crate::model::AccessKeyMetadata]> {
        self.access_key_metadata.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for ListAccessKeysOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAccessKeysOutput");
        formatter.field("access_key_metadata", &self.access_key_metadata);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`ListAccessKeysOutput`](crate::output::ListAccessKeysOutput)
pub mod list_access_keys_output {
    /// A builder for [`ListAccessKeysOutput`](crate::output::ListAccessKeysOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_key_metadata:
            std::option::Option<std::vec::Vec<crate::model::AccessKeyMetadata>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `access_key_metadata`.
        ///
        /// To override the contents of this collection use [`set_access_key_metadata`](Self::set_access_key_metadata).
        ///
        /// <p>A list of objects containing metadata about the access keys.</p>
        pub fn access_key_metadata(mut self, input: crate::model::AccessKeyMetadata) -> Self {
            let mut v = self.access_key_metadata.unwrap_or_default();
            v.push(input);
            self.access_key_metadata = Some(v);
            self
        }
        /// <p>A list of objects containing metadata about the access keys.</p>
        pub fn set_access_key_metadata(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccessKeyMetadata>>,
        ) -> Self {
            self.access_key_metadata = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccessKeysOutput`](crate::output::ListAccessKeysOutput)
        pub fn build(self) -> crate::output::ListAccessKeysOutput {
            crate::output::ListAccessKeysOutput {
                access_key_metadata: self.access_key_metadata,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl ListAccessKeysOutput {
    /// Creates a new builder-style object to manufacture [`ListAccessKeysOutput`](crate::output::ListAccessKeysOutput)
    pub fn builder() -> crate::output::list_access_keys_output::Builder {
        crate::output::list_access_keys_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>GetUserPolicy</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUserPolicyOutput {
    /// <p>The user the policy is associated with.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The name of the policy.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The policy document.</p>
    /// <p>IAM stores policies in JSON format. However, resources that were created using CloudFormation templates can be formatted in YAML. CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.</p>
    pub policy_document: std::option::Option<std::string::String>,
}
impl GetUserPolicyOutput {
    /// <p>The user the policy is associated with.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The name of the policy.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The policy document.</p>
    /// <p>IAM stores policies in JSON format. However, resources that were created using CloudFormation templates can be formatted in YAML. CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.</p>
    pub fn policy_document(&self) -> std::option::Option<&str> {
        self.policy_document.as_deref()
    }
}
impl std::fmt::Debug for GetUserPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUserPolicyOutput");
        formatter.field("user_name", &self.user_name);
        formatter.field("policy_name", &self.policy_name);
        formatter.field("policy_document", &self.policy_document);
        formatter.finish()
    }
}
/// See [`GetUserPolicyOutput`](crate::output::GetUserPolicyOutput)
pub mod get_user_policy_output {
    /// A builder for [`GetUserPolicyOutput`](crate::output::GetUserPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy_document: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user the policy is associated with.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The user the policy is associated with.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The name of the policy.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The policy document.</p>
        /// <p>IAM stores policies in JSON format. However, resources that were created using CloudFormation templates can be formatted in YAML. CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.</p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_document = Some(input.into());
            self
        }
        /// <p>The policy document.</p>
        /// <p>IAM stores policies in JSON format. However, resources that were created using CloudFormation templates can be formatted in YAML. CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.</p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_document = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUserPolicyOutput`](crate::output::GetUserPolicyOutput)
        pub fn build(self) -> crate::output::GetUserPolicyOutput {
            crate::output::GetUserPolicyOutput {
                user_name: self.user_name,
                policy_name: self.policy_name,
                policy_document: self.policy_document,
            }
        }
    }
}
impl GetUserPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetUserPolicyOutput`](crate::output::GetUserPolicyOutput)
    pub fn builder() -> crate::output::get_user_policy_output::Builder {
        crate::output::get_user_policy_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>GetUser</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUserOutput {
    /// <p>A structure containing details about the IAM user.</p> <important>
    /// <p>Due to a service issue, password last used data does not include password use from May 3, 2018 22:50 PDT to May 23, 2018 14:08 PDT. This affects <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_finding-unused.html">last sign-in</a> dates shown in the IAM console and password last used dates in the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_getting-report.html">IAM credential report</a>, and returned by this operation. If users signed in during the affected time, the password last used date that is returned is the date the user last signed in before May 3, 2018. For users that signed in after May 23, 2018 14:08 PDT, the returned password last used date is accurate.</p>
    /// <p>You can use password last used information to identify unused credentials for deletion. For example, you might delete users who did not sign in to Amazon Web Services in the last 90 days. In cases like this, we recommend that you adjust your evaluation window to include dates after May 23, 2018. Alternatively, if your users use access keys to access Amazon Web Services programmatically you can refer to access key last used information because it is accurate for all dates. </p>
    /// </important>
    pub user: std::option::Option<crate::model::User>,
}
impl GetUserOutput {
    /// <p>A structure containing details about the IAM user.</p> <important>
    /// <p>Due to a service issue, password last used data does not include password use from May 3, 2018 22:50 PDT to May 23, 2018 14:08 PDT. This affects <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_finding-unused.html">last sign-in</a> dates shown in the IAM console and password last used dates in the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_getting-report.html">IAM credential report</a>, and returned by this operation. If users signed in during the affected time, the password last used date that is returned is the date the user last signed in before May 3, 2018. For users that signed in after May 23, 2018 14:08 PDT, the returned password last used date is accurate.</p>
    /// <p>You can use password last used information to identify unused credentials for deletion. For example, you might delete users who did not sign in to Amazon Web Services in the last 90 days. In cases like this, we recommend that you adjust your evaluation window to include dates after May 23, 2018. Alternatively, if your users use access keys to access Amazon Web Services programmatically you can refer to access key last used information because it is accurate for all dates. </p>
    /// </important>
    pub fn user(&self) -> std::option::Option<&crate::model::User> {
        self.user.as_ref()
    }
}
impl std::fmt::Debug for GetUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUserOutput");
        formatter.field("user", &self.user);
        formatter.finish()
    }
}
/// See [`GetUserOutput`](crate::output::GetUserOutput)
pub mod get_user_output {
    /// A builder for [`GetUserOutput`](crate::output::GetUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user: std::option::Option<crate::model::User>,
    }
    impl Builder {
        /// <p>A structure containing details about the IAM user.</p> <important>
        /// <p>Due to a service issue, password last used data does not include password use from May 3, 2018 22:50 PDT to May 23, 2018 14:08 PDT. This affects <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_finding-unused.html">last sign-in</a> dates shown in the IAM console and password last used dates in the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_getting-report.html">IAM credential report</a>, and returned by this operation. If users signed in during the affected time, the password last used date that is returned is the date the user last signed in before May 3, 2018. For users that signed in after May 23, 2018 14:08 PDT, the returned password last used date is accurate.</p>
        /// <p>You can use password last used information to identify unused credentials for deletion. For example, you might delete users who did not sign in to Amazon Web Services in the last 90 days. In cases like this, we recommend that you adjust your evaluation window to include dates after May 23, 2018. Alternatively, if your users use access keys to access Amazon Web Services programmatically you can refer to access key last used information because it is accurate for all dates. </p>
        /// </important>
        pub fn user(mut self, input: crate::model::User) -> Self {
            self.user = Some(input);
            self
        }
        /// <p>A structure containing details about the IAM user.</p> <important>
        /// <p>Due to a service issue, password last used data does not include password use from May 3, 2018 22:50 PDT to May 23, 2018 14:08 PDT. This affects <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_finding-unused.html">last sign-in</a> dates shown in the IAM console and password last used dates in the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_getting-report.html">IAM credential report</a>, and returned by this operation. If users signed in during the affected time, the password last used date that is returned is the date the user last signed in before May 3, 2018. For users that signed in after May 23, 2018 14:08 PDT, the returned password last used date is accurate.</p>
        /// <p>You can use password last used information to identify unused credentials for deletion. For example, you might delete users who did not sign in to Amazon Web Services in the last 90 days. In cases like this, we recommend that you adjust your evaluation window to include dates after May 23, 2018. Alternatively, if your users use access keys to access Amazon Web Services programmatically you can refer to access key last used information because it is accurate for all dates. </p>
        /// </important>
        pub fn set_user(mut self, input: std::option::Option<crate::model::User>) -> Self {
            self.user = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUserOutput`](crate::output::GetUserOutput)
        pub fn build(self) -> crate::output::GetUserOutput {
            crate::output::GetUserOutput { user: self.user }
        }
    }
}
impl GetUserOutput {
    /// Creates a new builder-style object to manufacture [`GetUserOutput`](crate::output::GetUserOutput)
    pub fn builder() -> crate::output::get_user_output::Builder {
        crate::output::get_user_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>GetSSHPublicKey</code> request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSshPublicKeyOutput {
    /// <p>A structure containing details about the SSH public key.</p>
    pub ssh_public_key: std::option::Option<crate::model::SshPublicKey>,
}
impl GetSshPublicKeyOutput {
    /// <p>A structure containing details about the SSH public key.</p>
    pub fn ssh_public_key(&self) -> std::option::Option<&crate::model::SshPublicKey> {
        self.ssh_public_key.as_ref()
    }
}
impl std::fmt::Debug for GetSshPublicKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSshPublicKeyOutput");
        formatter.field("ssh_public_key", &self.ssh_public_key);
        formatter.finish()
    }
}
/// See [`GetSshPublicKeyOutput`](crate::output::GetSshPublicKeyOutput)
pub mod get_ssh_public_key_output {
    /// A builder for [`GetSshPublicKeyOutput`](crate::output::GetSshPublicKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ssh_public_key: std::option::Option<crate::model::SshPublicKey>,
    }
    impl Builder {
        /// <p>A structure containing details about the SSH public key.</p>
        pub fn ssh_public_key(mut self, input: crate::model::SshPublicKey) -> Self {
            self.ssh_public_key = Some(input);
            self
        }
        /// <p>A structure containing details about the SSH public key.</p>
        pub fn set_ssh_public_key(
            mut self,
            input: std::option::Option<crate::model::SshPublicKey>,
        ) -> Self {
            self.ssh_public_key = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSshPublicKeyOutput`](crate::output::GetSshPublicKeyOutput)
        pub fn build(self) -> crate::output::GetSshPublicKeyOutput {
            crate::output::GetSshPublicKeyOutput {
                ssh_public_key: self.ssh_public_key,
            }
        }
    }
}
impl GetSshPublicKeyOutput {
    /// Creates a new builder-style object to manufacture [`GetSshPublicKeyOutput`](crate::output::GetSshPublicKeyOutput)
    pub fn builder() -> crate::output::get_ssh_public_key_output::Builder {
        crate::output::get_ssh_public_key_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetServiceLinkedRoleDeletionStatusOutput {
    /// <p>The status of the deletion.</p>
    pub status: std::option::Option<crate::model::DeletionTaskStatusType>,
    /// <p>An object that contains details about the reason the deletion failed.</p>
    pub reason: std::option::Option<crate::model::DeletionTaskFailureReasonType>,
}
impl GetServiceLinkedRoleDeletionStatusOutput {
    /// <p>The status of the deletion.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DeletionTaskStatusType> {
        self.status.as_ref()
    }
    /// <p>An object that contains details about the reason the deletion failed.</p>
    pub fn reason(&self) -> std::option::Option<&crate::model::DeletionTaskFailureReasonType> {
        self.reason.as_ref()
    }
}
impl std::fmt::Debug for GetServiceLinkedRoleDeletionStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetServiceLinkedRoleDeletionStatusOutput");
        formatter.field("status", &self.status);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
/// See [`GetServiceLinkedRoleDeletionStatusOutput`](crate::output::GetServiceLinkedRoleDeletionStatusOutput)
pub mod get_service_linked_role_deletion_status_output {
    /// A builder for [`GetServiceLinkedRoleDeletionStatusOutput`](crate::output::GetServiceLinkedRoleDeletionStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::DeletionTaskStatusType>,
        pub(crate) reason: std::option::Option<crate::model::DeletionTaskFailureReasonType>,
    }
    impl Builder {
        /// <p>The status of the deletion.</p>
        pub fn status(mut self, input: crate::model::DeletionTaskStatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the deletion.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DeletionTaskStatusType>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>An object that contains details about the reason the deletion failed.</p>
        pub fn reason(mut self, input: crate::model::DeletionTaskFailureReasonType) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>An object that contains details about the reason the deletion failed.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::DeletionTaskFailureReasonType>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`GetServiceLinkedRoleDeletionStatusOutput`](crate::output::GetServiceLinkedRoleDeletionStatusOutput)
        pub fn build(self) -> crate::output::GetServiceLinkedRoleDeletionStatusOutput {
            crate::output::GetServiceLinkedRoleDeletionStatusOutput {
                status: self.status,
                reason: self.reason,
            }
        }
    }
}
impl GetServiceLinkedRoleDeletionStatusOutput {
    /// Creates a new builder-style object to manufacture [`GetServiceLinkedRoleDeletionStatusOutput`](crate::output::GetServiceLinkedRoleDeletionStatusOutput)
    pub fn builder() -> crate::output::get_service_linked_role_deletion_status_output::Builder {
        crate::output::get_service_linked_role_deletion_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetServiceLastAccessedDetailsWithEntitiesOutput {
    /// <p>The status of the job.</p>
    pub job_status: std::option::Option<crate::model::JobStatusType>,
    /// <p>The date and time, in&nbsp;<a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the report job was created.</p>
    pub job_creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time, in&nbsp;<a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the generated report job was completed or failed.</p>
    /// <p>This field is null if the job is still in progress, as indicated by a job status value of <code>IN_PROGRESS</code>.</p>
    pub job_completion_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>An&nbsp;<code>EntityDetailsList</code> object that contains details about when an IAM entity (user or role) used group or policy permissions in an attempt to access the specified Amazon Web Services service.</p>
    pub entity_details_list: std::option::Option<std::vec::Vec<crate::model::EntityDetails>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>An object that contains details about the reason the operation failed.</p>
    pub error: std::option::Option<crate::model::ErrorDetails>,
}
impl GetServiceLastAccessedDetailsWithEntitiesOutput {
    /// <p>The status of the job.</p>
    pub fn job_status(&self) -> std::option::Option<&crate::model::JobStatusType> {
        self.job_status.as_ref()
    }
    /// <p>The date and time, in&nbsp;<a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the report job was created.</p>
    pub fn job_creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.job_creation_date.as_ref()
    }
    /// <p>The date and time, in&nbsp;<a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the generated report job was completed or failed.</p>
    /// <p>This field is null if the job is still in progress, as indicated by a job status value of <code>IN_PROGRESS</code>.</p>
    pub fn job_completion_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.job_completion_date.as_ref()
    }
    /// <p>An&nbsp;<code>EntityDetailsList</code> object that contains details about when an IAM entity (user or role) used group or policy permissions in an attempt to access the specified Amazon Web Services service.</p>
    pub fn entity_details_list(&self) -> std::option::Option<&[crate::model::EntityDetails]> {
        self.entity_details_list.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>An object that contains details about the reason the operation failed.</p>
    pub fn error(&self) -> std::option::Option<&crate::model::ErrorDetails> {
        self.error.as_ref()
    }
}
impl std::fmt::Debug for GetServiceLastAccessedDetailsWithEntitiesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetServiceLastAccessedDetailsWithEntitiesOutput");
        formatter.field("job_status", &self.job_status);
        formatter.field("job_creation_date", &self.job_creation_date);
        formatter.field("job_completion_date", &self.job_completion_date);
        formatter.field("entity_details_list", &self.entity_details_list);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
/// See [`GetServiceLastAccessedDetailsWithEntitiesOutput`](crate::output::GetServiceLastAccessedDetailsWithEntitiesOutput)
pub mod get_service_last_accessed_details_with_entities_output {
    /// A builder for [`GetServiceLastAccessedDetailsWithEntitiesOutput`](crate::output::GetServiceLastAccessedDetailsWithEntitiesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_status: std::option::Option<crate::model::JobStatusType>,
        pub(crate) job_creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) job_completion_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) entity_details_list:
            std::option::Option<std::vec::Vec<crate::model::EntityDetails>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<crate::model::ErrorDetails>,
    }
    impl Builder {
        /// <p>The status of the job.</p>
        pub fn job_status(mut self, input: crate::model::JobStatusType) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>The status of the job.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatusType>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>The date and time, in&nbsp;<a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the report job was created.</p>
        pub fn job_creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.job_creation_date = Some(input);
            self
        }
        /// <p>The date and time, in&nbsp;<a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the report job was created.</p>
        pub fn set_job_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.job_creation_date = input;
            self
        }
        /// <p>The date and time, in&nbsp;<a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the generated report job was completed or failed.</p>
        /// <p>This field is null if the job is still in progress, as indicated by a job status value of <code>IN_PROGRESS</code>.</p>
        pub fn job_completion_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.job_completion_date = Some(input);
            self
        }
        /// <p>The date and time, in&nbsp;<a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the generated report job was completed or failed.</p>
        /// <p>This field is null if the job is still in progress, as indicated by a job status value of <code>IN_PROGRESS</code>.</p>
        pub fn set_job_completion_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.job_completion_date = input;
            self
        }
        /// Appends an item to `entity_details_list`.
        ///
        /// To override the contents of this collection use [`set_entity_details_list`](Self::set_entity_details_list).
        ///
        /// <p>An&nbsp;<code>EntityDetailsList</code> object that contains details about when an IAM entity (user or role) used group or policy permissions in an attempt to access the specified Amazon Web Services service.</p>
        pub fn entity_details_list(mut self, input: crate::model::EntityDetails) -> Self {
            let mut v = self.entity_details_list.unwrap_or_default();
            v.push(input);
            self.entity_details_list = Some(v);
            self
        }
        /// <p>An&nbsp;<code>EntityDetailsList</code> object that contains details about when an IAM entity (user or role) used group or policy permissions in an attempt to access the specified Amazon Web Services service.</p>
        pub fn set_entity_details_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EntityDetails>>,
        ) -> Self {
            self.entity_details_list = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>An object that contains details about the reason the operation failed.</p>
        pub fn error(mut self, input: crate::model::ErrorDetails) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>An object that contains details about the reason the operation failed.</p>
        pub fn set_error(mut self, input: std::option::Option<crate::model::ErrorDetails>) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`GetServiceLastAccessedDetailsWithEntitiesOutput`](crate::output::GetServiceLastAccessedDetailsWithEntitiesOutput)
        pub fn build(self) -> crate::output::GetServiceLastAccessedDetailsWithEntitiesOutput {
            crate::output::GetServiceLastAccessedDetailsWithEntitiesOutput {
                job_status: self.job_status,
                job_creation_date: self.job_creation_date,
                job_completion_date: self.job_completion_date,
                entity_details_list: self.entity_details_list,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
                error: self.error,
            }
        }
    }
}
impl GetServiceLastAccessedDetailsWithEntitiesOutput {
    /// Creates a new builder-style object to manufacture [`GetServiceLastAccessedDetailsWithEntitiesOutput`](crate::output::GetServiceLastAccessedDetailsWithEntitiesOutput)
    pub fn builder(
    ) -> crate::output::get_service_last_accessed_details_with_entities_output::Builder {
        crate::output::get_service_last_accessed_details_with_entities_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetServiceLastAccessedDetailsOutput {
    /// <p>The status of the job.</p>
    pub job_status: std::option::Option<crate::model::JobStatusType>,
    /// <p>The type of job. Service jobs return information about when each service was last accessed. Action jobs also include information about when tracked actions within the service were last accessed.</p>
    pub job_type: std::option::Option<crate::model::AccessAdvisorUsageGranularityType>,
    /// <p>The date and time, in&nbsp;<a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the report job was created.</p>
    pub job_creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> A&nbsp;<code>ServiceLastAccessed</code> object that contains details about the most recent attempt to access the service.</p>
    pub services_last_accessed:
        std::option::Option<std::vec::Vec<crate::model::ServiceLastAccessed>>,
    /// <p>The date and time, in&nbsp;<a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the generated report job was completed or failed.</p>
    /// <p>This field is null if the job is still in progress, as indicated by a job status value of <code>IN_PROGRESS</code>.</p>
    pub job_completion_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>An object that contains details about the reason the operation failed.</p>
    pub error: std::option::Option<crate::model::ErrorDetails>,
}
impl GetServiceLastAccessedDetailsOutput {
    /// <p>The status of the job.</p>
    pub fn job_status(&self) -> std::option::Option<&crate::model::JobStatusType> {
        self.job_status.as_ref()
    }
    /// <p>The type of job. Service jobs return information about when each service was last accessed. Action jobs also include information about when tracked actions within the service were last accessed.</p>
    pub fn job_type(
        &self,
    ) -> std::option::Option<&crate::model::AccessAdvisorUsageGranularityType> {
        self.job_type.as_ref()
    }
    /// <p>The date and time, in&nbsp;<a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the report job was created.</p>
    pub fn job_creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.job_creation_date.as_ref()
    }
    /// <p> A&nbsp;<code>ServiceLastAccessed</code> object that contains details about the most recent attempt to access the service.</p>
    pub fn services_last_accessed(
        &self,
    ) -> std::option::Option<&[crate::model::ServiceLastAccessed]> {
        self.services_last_accessed.as_deref()
    }
    /// <p>The date and time, in&nbsp;<a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the generated report job was completed or failed.</p>
    /// <p>This field is null if the job is still in progress, as indicated by a job status value of <code>IN_PROGRESS</code>.</p>
    pub fn job_completion_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.job_completion_date.as_ref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>An object that contains details about the reason the operation failed.</p>
    pub fn error(&self) -> std::option::Option<&crate::model::ErrorDetails> {
        self.error.as_ref()
    }
}
impl std::fmt::Debug for GetServiceLastAccessedDetailsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetServiceLastAccessedDetailsOutput");
        formatter.field("job_status", &self.job_status);
        formatter.field("job_type", &self.job_type);
        formatter.field("job_creation_date", &self.job_creation_date);
        formatter.field("services_last_accessed", &self.services_last_accessed);
        formatter.field("job_completion_date", &self.job_completion_date);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
/// See [`GetServiceLastAccessedDetailsOutput`](crate::output::GetServiceLastAccessedDetailsOutput)
pub mod get_service_last_accessed_details_output {
    /// A builder for [`GetServiceLastAccessedDetailsOutput`](crate::output::GetServiceLastAccessedDetailsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_status: std::option::Option<crate::model::JobStatusType>,
        pub(crate) job_type: std::option::Option<crate::model::AccessAdvisorUsageGranularityType>,
        pub(crate) job_creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) services_last_accessed:
            std::option::Option<std::vec::Vec<crate::model::ServiceLastAccessed>>,
        pub(crate) job_completion_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<crate::model::ErrorDetails>,
    }
    impl Builder {
        /// <p>The status of the job.</p>
        pub fn job_status(mut self, input: crate::model::JobStatusType) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>The status of the job.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatusType>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>The type of job. Service jobs return information about when each service was last accessed. Action jobs also include information about when tracked actions within the service were last accessed.</p>
        pub fn job_type(mut self, input: crate::model::AccessAdvisorUsageGranularityType) -> Self {
            self.job_type = Some(input);
            self
        }
        /// <p>The type of job. Service jobs return information about when each service was last accessed. Action jobs also include information about when tracked actions within the service were last accessed.</p>
        pub fn set_job_type(
            mut self,
            input: std::option::Option<crate::model::AccessAdvisorUsageGranularityType>,
        ) -> Self {
            self.job_type = input;
            self
        }
        /// <p>The date and time, in&nbsp;<a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the report job was created.</p>
        pub fn job_creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.job_creation_date = Some(input);
            self
        }
        /// <p>The date and time, in&nbsp;<a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the report job was created.</p>
        pub fn set_job_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.job_creation_date = input;
            self
        }
        /// Appends an item to `services_last_accessed`.
        ///
        /// To override the contents of this collection use [`set_services_last_accessed`](Self::set_services_last_accessed).
        ///
        /// <p> A&nbsp;<code>ServiceLastAccessed</code> object that contains details about the most recent attempt to access the service.</p>
        pub fn services_last_accessed(mut self, input: crate::model::ServiceLastAccessed) -> Self {
            let mut v = self.services_last_accessed.unwrap_or_default();
            v.push(input);
            self.services_last_accessed = Some(v);
            self
        }
        /// <p> A&nbsp;<code>ServiceLastAccessed</code> object that contains details about the most recent attempt to access the service.</p>
        pub fn set_services_last_accessed(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceLastAccessed>>,
        ) -> Self {
            self.services_last_accessed = input;
            self
        }
        /// <p>The date and time, in&nbsp;<a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the generated report job was completed or failed.</p>
        /// <p>This field is null if the job is still in progress, as indicated by a job status value of <code>IN_PROGRESS</code>.</p>
        pub fn job_completion_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.job_completion_date = Some(input);
            self
        }
        /// <p>The date and time, in&nbsp;<a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the generated report job was completed or failed.</p>
        /// <p>This field is null if the job is still in progress, as indicated by a job status value of <code>IN_PROGRESS</code>.</p>
        pub fn set_job_completion_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.job_completion_date = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>An object that contains details about the reason the operation failed.</p>
        pub fn error(mut self, input: crate::model::ErrorDetails) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>An object that contains details about the reason the operation failed.</p>
        pub fn set_error(mut self, input: std::option::Option<crate::model::ErrorDetails>) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`GetServiceLastAccessedDetailsOutput`](crate::output::GetServiceLastAccessedDetailsOutput)
        pub fn build(self) -> crate::output::GetServiceLastAccessedDetailsOutput {
            crate::output::GetServiceLastAccessedDetailsOutput {
                job_status: self.job_status,
                job_type: self.job_type,
                job_creation_date: self.job_creation_date,
                services_last_accessed: self.services_last_accessed,
                job_completion_date: self.job_completion_date,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
                error: self.error,
            }
        }
    }
}
impl GetServiceLastAccessedDetailsOutput {
    /// Creates a new builder-style object to manufacture [`GetServiceLastAccessedDetailsOutput`](crate::output::GetServiceLastAccessedDetailsOutput)
    pub fn builder() -> crate::output::get_service_last_accessed_details_output::Builder {
        crate::output::get_service_last_accessed_details_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>GetServerCertificate</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetServerCertificateOutput {
    /// <p>A structure containing details about the server certificate.</p>
    pub server_certificate: std::option::Option<crate::model::ServerCertificate>,
}
impl GetServerCertificateOutput {
    /// <p>A structure containing details about the server certificate.</p>
    pub fn server_certificate(&self) -> std::option::Option<&crate::model::ServerCertificate> {
        self.server_certificate.as_ref()
    }
}
impl std::fmt::Debug for GetServerCertificateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetServerCertificateOutput");
        formatter.field("server_certificate", &self.server_certificate);
        formatter.finish()
    }
}
/// See [`GetServerCertificateOutput`](crate::output::GetServerCertificateOutput)
pub mod get_server_certificate_output {
    /// A builder for [`GetServerCertificateOutput`](crate::output::GetServerCertificateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_certificate: std::option::Option<crate::model::ServerCertificate>,
    }
    impl Builder {
        /// <p>A structure containing details about the server certificate.</p>
        pub fn server_certificate(mut self, input: crate::model::ServerCertificate) -> Self {
            self.server_certificate = Some(input);
            self
        }
        /// <p>A structure containing details about the server certificate.</p>
        pub fn set_server_certificate(
            mut self,
            input: std::option::Option<crate::model::ServerCertificate>,
        ) -> Self {
            self.server_certificate = input;
            self
        }
        /// Consumes the builder and constructs a [`GetServerCertificateOutput`](crate::output::GetServerCertificateOutput)
        pub fn build(self) -> crate::output::GetServerCertificateOutput {
            crate::output::GetServerCertificateOutput {
                server_certificate: self.server_certificate,
            }
        }
    }
}
impl GetServerCertificateOutput {
    /// Creates a new builder-style object to manufacture [`GetServerCertificateOutput`](crate::output::GetServerCertificateOutput)
    pub fn builder() -> crate::output::get_server_certificate_output::Builder {
        crate::output::get_server_certificate_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>GetSAMLProvider</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSamlProviderOutput {
    /// <p>The XML metadata document that includes information about an identity provider.</p>
    pub saml_metadata_document: std::option::Option<std::string::String>,
    /// <p>The date and time when the SAML provider was created.</p>
    pub create_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The expiration date and time for the SAML provider.</p>
    pub valid_until: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A list of tags that are attached to the specified IAM SAML provider. The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl GetSamlProviderOutput {
    /// <p>The XML metadata document that includes information about an identity provider.</p>
    pub fn saml_metadata_document(&self) -> std::option::Option<&str> {
        self.saml_metadata_document.as_deref()
    }
    /// <p>The date and time when the SAML provider was created.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_date.as_ref()
    }
    /// <p>The expiration date and time for the SAML provider.</p>
    pub fn valid_until(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.valid_until.as_ref()
    }
    /// <p>A list of tags that are attached to the specified IAM SAML provider. The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for GetSamlProviderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSamlProviderOutput");
        formatter.field("saml_metadata_document", &self.saml_metadata_document);
        formatter.field("create_date", &self.create_date);
        formatter.field("valid_until", &self.valid_until);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetSamlProviderOutput`](crate::output::GetSamlProviderOutput)
pub mod get_saml_provider_output {
    /// A builder for [`GetSamlProviderOutput`](crate::output::GetSamlProviderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) saml_metadata_document: std::option::Option<std::string::String>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) valid_until: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The XML metadata document that includes information about an identity provider.</p>
        pub fn saml_metadata_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.saml_metadata_document = Some(input.into());
            self
        }
        /// <p>The XML metadata document that includes information about an identity provider.</p>
        pub fn set_saml_metadata_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.saml_metadata_document = input;
            self
        }
        /// <p>The date and time when the SAML provider was created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time when the SAML provider was created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// <p>The expiration date and time for the SAML provider.</p>
        pub fn valid_until(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.valid_until = Some(input);
            self
        }
        /// <p>The expiration date and time for the SAML provider.</p>
        pub fn set_valid_until(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.valid_until = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that are attached to the specified IAM SAML provider. The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags that are attached to the specified IAM SAML provider. The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSamlProviderOutput`](crate::output::GetSamlProviderOutput)
        pub fn build(self) -> crate::output::GetSamlProviderOutput {
            crate::output::GetSamlProviderOutput {
                saml_metadata_document: self.saml_metadata_document,
                create_date: self.create_date,
                valid_until: self.valid_until,
                tags: self.tags,
            }
        }
    }
}
impl GetSamlProviderOutput {
    /// Creates a new builder-style object to manufacture [`GetSamlProviderOutput`](crate::output::GetSamlProviderOutput)
    pub fn builder() -> crate::output::get_saml_provider_output::Builder {
        crate::output::get_saml_provider_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>GetRolePolicy</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRolePolicyOutput {
    /// <p>The role the policy is associated with.</p>
    pub role_name: std::option::Option<std::string::String>,
    /// <p>The name of the policy.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The policy document.</p>
    /// <p>IAM stores policies in JSON format. However, resources that were created using CloudFormation templates can be formatted in YAML. CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.</p>
    pub policy_document: std::option::Option<std::string::String>,
}
impl GetRolePolicyOutput {
    /// <p>The role the policy is associated with.</p>
    pub fn role_name(&self) -> std::option::Option<&str> {
        self.role_name.as_deref()
    }
    /// <p>The name of the policy.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The policy document.</p>
    /// <p>IAM stores policies in JSON format. However, resources that were created using CloudFormation templates can be formatted in YAML. CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.</p>
    pub fn policy_document(&self) -> std::option::Option<&str> {
        self.policy_document.as_deref()
    }
}
impl std::fmt::Debug for GetRolePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRolePolicyOutput");
        formatter.field("role_name", &self.role_name);
        formatter.field("policy_name", &self.policy_name);
        formatter.field("policy_document", &self.policy_document);
        formatter.finish()
    }
}
/// See [`GetRolePolicyOutput`](crate::output::GetRolePolicyOutput)
pub mod get_role_policy_output {
    /// A builder for [`GetRolePolicyOutput`](crate::output::GetRolePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_name: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy_document: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The role the policy is associated with.</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>The role the policy is associated with.</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// <p>The name of the policy.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The policy document.</p>
        /// <p>IAM stores policies in JSON format. However, resources that were created using CloudFormation templates can be formatted in YAML. CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.</p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_document = Some(input.into());
            self
        }
        /// <p>The policy document.</p>
        /// <p>IAM stores policies in JSON format. However, resources that were created using CloudFormation templates can be formatted in YAML. CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.</p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_document = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRolePolicyOutput`](crate::output::GetRolePolicyOutput)
        pub fn build(self) -> crate::output::GetRolePolicyOutput {
            crate::output::GetRolePolicyOutput {
                role_name: self.role_name,
                policy_name: self.policy_name,
                policy_document: self.policy_document,
            }
        }
    }
}
impl GetRolePolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetRolePolicyOutput`](crate::output::GetRolePolicyOutput)
    pub fn builder() -> crate::output::get_role_policy_output::Builder {
        crate::output::get_role_policy_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>GetRole</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRoleOutput {
    /// <p>A structure containing details about the IAM role.</p>
    pub role: std::option::Option<crate::model::Role>,
}
impl GetRoleOutput {
    /// <p>A structure containing details about the IAM role.</p>
    pub fn role(&self) -> std::option::Option<&crate::model::Role> {
        self.role.as_ref()
    }
}
impl std::fmt::Debug for GetRoleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRoleOutput");
        formatter.field("role", &self.role);
        formatter.finish()
    }
}
/// See [`GetRoleOutput`](crate::output::GetRoleOutput)
pub mod get_role_output {
    /// A builder for [`GetRoleOutput`](crate::output::GetRoleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role: std::option::Option<crate::model::Role>,
    }
    impl Builder {
        /// <p>A structure containing details about the IAM role.</p>
        pub fn role(mut self, input: crate::model::Role) -> Self {
            self.role = Some(input);
            self
        }
        /// <p>A structure containing details about the IAM role.</p>
        pub fn set_role(mut self, input: std::option::Option<crate::model::Role>) -> Self {
            self.role = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRoleOutput`](crate::output::GetRoleOutput)
        pub fn build(self) -> crate::output::GetRoleOutput {
            crate::output::GetRoleOutput { role: self.role }
        }
    }
}
impl GetRoleOutput {
    /// Creates a new builder-style object to manufacture [`GetRoleOutput`](crate::output::GetRoleOutput)
    pub fn builder() -> crate::output::get_role_output::Builder {
        crate::output::get_role_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>GetPolicyVersion</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPolicyVersionOutput {
    /// <p>A structure containing details about the policy version.</p>
    pub policy_version: std::option::Option<crate::model::PolicyVersion>,
}
impl GetPolicyVersionOutput {
    /// <p>A structure containing details about the policy version.</p>
    pub fn policy_version(&self) -> std::option::Option<&crate::model::PolicyVersion> {
        self.policy_version.as_ref()
    }
}
impl std::fmt::Debug for GetPolicyVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPolicyVersionOutput");
        formatter.field("policy_version", &self.policy_version);
        formatter.finish()
    }
}
/// See [`GetPolicyVersionOutput`](crate::output::GetPolicyVersionOutput)
pub mod get_policy_version_output {
    /// A builder for [`GetPolicyVersionOutput`](crate::output::GetPolicyVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_version: std::option::Option<crate::model::PolicyVersion>,
    }
    impl Builder {
        /// <p>A structure containing details about the policy version.</p>
        pub fn policy_version(mut self, input: crate::model::PolicyVersion) -> Self {
            self.policy_version = Some(input);
            self
        }
        /// <p>A structure containing details about the policy version.</p>
        pub fn set_policy_version(
            mut self,
            input: std::option::Option<crate::model::PolicyVersion>,
        ) -> Self {
            self.policy_version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPolicyVersionOutput`](crate::output::GetPolicyVersionOutput)
        pub fn build(self) -> crate::output::GetPolicyVersionOutput {
            crate::output::GetPolicyVersionOutput {
                policy_version: self.policy_version,
            }
        }
    }
}
impl GetPolicyVersionOutput {
    /// Creates a new builder-style object to manufacture [`GetPolicyVersionOutput`](crate::output::GetPolicyVersionOutput)
    pub fn builder() -> crate::output::get_policy_version_output::Builder {
        crate::output::get_policy_version_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>GetPolicy</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPolicyOutput {
    /// <p>A structure containing details about the policy.</p>
    pub policy: std::option::Option<crate::model::Policy>,
}
impl GetPolicyOutput {
    /// <p>A structure containing details about the policy.</p>
    pub fn policy(&self) -> std::option::Option<&crate::model::Policy> {
        self.policy.as_ref()
    }
}
impl std::fmt::Debug for GetPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`GetPolicyOutput`](crate::output::GetPolicyOutput)
pub mod get_policy_output {
    /// A builder for [`GetPolicyOutput`](crate::output::GetPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<crate::model::Policy>,
    }
    impl Builder {
        /// <p>A structure containing details about the policy.</p>
        pub fn policy(mut self, input: crate::model::Policy) -> Self {
            self.policy = Some(input);
            self
        }
        /// <p>A structure containing details about the policy.</p>
        pub fn set_policy(mut self, input: std::option::Option<crate::model::Policy>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPolicyOutput`](crate::output::GetPolicyOutput)
        pub fn build(self) -> crate::output::GetPolicyOutput {
            crate::output::GetPolicyOutput {
                policy: self.policy,
            }
        }
    }
}
impl GetPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetPolicyOutput`](crate::output::GetPolicyOutput)
    pub fn builder() -> crate::output::get_policy_output::Builder {
        crate::output::get_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOrganizationsAccessReportOutput {
    /// <p>The status of the job.</p>
    pub job_status: std::option::Option<crate::model::JobStatusType>,
    /// <p>The date and time, in&nbsp;<a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the report job was created.</p>
    pub job_creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time, in&nbsp;<a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the generated report job was completed or failed.</p>
    /// <p>This field is null if the job is still in progress, as indicated by a job status value of <code>IN_PROGRESS</code>.</p>
    pub job_completion_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The number of services that the applicable SCPs allow account principals to access.</p>
    pub number_of_services_accessible: std::option::Option<i32>,
    /// <p>The number of services that account principals are allowed but did not attempt to access.</p>
    pub number_of_services_not_accessed: std::option::Option<i32>,
    /// <p>An&nbsp;object that contains details about the most recent attempt to access the service.</p>
    pub access_details: std::option::Option<std::vec::Vec<crate::model::AccessDetail>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Contains information about the reason that the operation failed.</p>
    /// <p>This data type is used as a response element in the <code>GetOrganizationsAccessReport</code>, <code>GetServiceLastAccessedDetails</code>, and <code>GetServiceLastAccessedDetailsWithEntities</code> operations.</p>
    pub error_details: std::option::Option<crate::model::ErrorDetails>,
}
impl GetOrganizationsAccessReportOutput {
    /// <p>The status of the job.</p>
    pub fn job_status(&self) -> std::option::Option<&crate::model::JobStatusType> {
        self.job_status.as_ref()
    }
    /// <p>The date and time, in&nbsp;<a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the report job was created.</p>
    pub fn job_creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.job_creation_date.as_ref()
    }
    /// <p>The date and time, in&nbsp;<a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the generated report job was completed or failed.</p>
    /// <p>This field is null if the job is still in progress, as indicated by a job status value of <code>IN_PROGRESS</code>.</p>
    pub fn job_completion_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.job_completion_date.as_ref()
    }
    /// <p>The number of services that the applicable SCPs allow account principals to access.</p>
    pub fn number_of_services_accessible(&self) -> std::option::Option<i32> {
        self.number_of_services_accessible
    }
    /// <p>The number of services that account principals are allowed but did not attempt to access.</p>
    pub fn number_of_services_not_accessed(&self) -> std::option::Option<i32> {
        self.number_of_services_not_accessed
    }
    /// <p>An&nbsp;object that contains details about the most recent attempt to access the service.</p>
    pub fn access_details(&self) -> std::option::Option<&[crate::model::AccessDetail]> {
        self.access_details.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Contains information about the reason that the operation failed.</p>
    /// <p>This data type is used as a response element in the <code>GetOrganizationsAccessReport</code>, <code>GetServiceLastAccessedDetails</code>, and <code>GetServiceLastAccessedDetailsWithEntities</code> operations.</p>
    pub fn error_details(&self) -> std::option::Option<&crate::model::ErrorDetails> {
        self.error_details.as_ref()
    }
}
impl std::fmt::Debug for GetOrganizationsAccessReportOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOrganizationsAccessReportOutput");
        formatter.field("job_status", &self.job_status);
        formatter.field("job_creation_date", &self.job_creation_date);
        formatter.field("job_completion_date", &self.job_completion_date);
        formatter.field(
            "number_of_services_accessible",
            &self.number_of_services_accessible,
        );
        formatter.field(
            "number_of_services_not_accessed",
            &self.number_of_services_not_accessed,
        );
        formatter.field("access_details", &self.access_details);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.field("error_details", &self.error_details);
        formatter.finish()
    }
}
/// See [`GetOrganizationsAccessReportOutput`](crate::output::GetOrganizationsAccessReportOutput)
pub mod get_organizations_access_report_output {
    /// A builder for [`GetOrganizationsAccessReportOutput`](crate::output::GetOrganizationsAccessReportOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_status: std::option::Option<crate::model::JobStatusType>,
        pub(crate) job_creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) job_completion_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) number_of_services_accessible: std::option::Option<i32>,
        pub(crate) number_of_services_not_accessed: std::option::Option<i32>,
        pub(crate) access_details: std::option::Option<std::vec::Vec<crate::model::AccessDetail>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) error_details: std::option::Option<crate::model::ErrorDetails>,
    }
    impl Builder {
        /// <p>The status of the job.</p>
        pub fn job_status(mut self, input: crate::model::JobStatusType) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>The status of the job.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatusType>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>The date and time, in&nbsp;<a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the report job was created.</p>
        pub fn job_creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.job_creation_date = Some(input);
            self
        }
        /// <p>The date and time, in&nbsp;<a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the report job was created.</p>
        pub fn set_job_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.job_creation_date = input;
            self
        }
        /// <p>The date and time, in&nbsp;<a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the generated report job was completed or failed.</p>
        /// <p>This field is null if the job is still in progress, as indicated by a job status value of <code>IN_PROGRESS</code>.</p>
        pub fn job_completion_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.job_completion_date = Some(input);
            self
        }
        /// <p>The date and time, in&nbsp;<a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the generated report job was completed or failed.</p>
        /// <p>This field is null if the job is still in progress, as indicated by a job status value of <code>IN_PROGRESS</code>.</p>
        pub fn set_job_completion_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.job_completion_date = input;
            self
        }
        /// <p>The number of services that the applicable SCPs allow account principals to access.</p>
        pub fn number_of_services_accessible(mut self, input: i32) -> Self {
            self.number_of_services_accessible = Some(input);
            self
        }
        /// <p>The number of services that the applicable SCPs allow account principals to access.</p>
        pub fn set_number_of_services_accessible(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.number_of_services_accessible = input;
            self
        }
        /// <p>The number of services that account principals are allowed but did not attempt to access.</p>
        pub fn number_of_services_not_accessed(mut self, input: i32) -> Self {
            self.number_of_services_not_accessed = Some(input);
            self
        }
        /// <p>The number of services that account principals are allowed but did not attempt to access.</p>
        pub fn set_number_of_services_not_accessed(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.number_of_services_not_accessed = input;
            self
        }
        /// Appends an item to `access_details`.
        ///
        /// To override the contents of this collection use [`set_access_details`](Self::set_access_details).
        ///
        /// <p>An&nbsp;object that contains details about the most recent attempt to access the service.</p>
        pub fn access_details(mut self, input: crate::model::AccessDetail) -> Self {
            let mut v = self.access_details.unwrap_or_default();
            v.push(input);
            self.access_details = Some(v);
            self
        }
        /// <p>An&nbsp;object that contains details about the most recent attempt to access the service.</p>
        pub fn set_access_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccessDetail>>,
        ) -> Self {
            self.access_details = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Contains information about the reason that the operation failed.</p>
        /// <p>This data type is used as a response element in the <code>GetOrganizationsAccessReport</code>, <code>GetServiceLastAccessedDetails</code>, and <code>GetServiceLastAccessedDetailsWithEntities</code> operations.</p>
        pub fn error_details(mut self, input: crate::model::ErrorDetails) -> Self {
            self.error_details = Some(input);
            self
        }
        /// <p>Contains information about the reason that the operation failed.</p>
        /// <p>This data type is used as a response element in the <code>GetOrganizationsAccessReport</code>, <code>GetServiceLastAccessedDetails</code>, and <code>GetServiceLastAccessedDetailsWithEntities</code> operations.</p>
        pub fn set_error_details(
            mut self,
            input: std::option::Option<crate::model::ErrorDetails>,
        ) -> Self {
            self.error_details = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOrganizationsAccessReportOutput`](crate::output::GetOrganizationsAccessReportOutput)
        pub fn build(self) -> crate::output::GetOrganizationsAccessReportOutput {
            crate::output::GetOrganizationsAccessReportOutput {
                job_status: self.job_status,
                job_creation_date: self.job_creation_date,
                job_completion_date: self.job_completion_date,
                number_of_services_accessible: self.number_of_services_accessible,
                number_of_services_not_accessed: self.number_of_services_not_accessed,
                access_details: self.access_details,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
                error_details: self.error_details,
            }
        }
    }
}
impl GetOrganizationsAccessReportOutput {
    /// Creates a new builder-style object to manufacture [`GetOrganizationsAccessReportOutput`](crate::output::GetOrganizationsAccessReportOutput)
    pub fn builder() -> crate::output::get_organizations_access_report_output::Builder {
        crate::output::get_organizations_access_report_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>GetOpenIDConnectProvider</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOpenIdConnectProviderOutput {
    /// <p>The URL that the IAM OIDC provider resource object is associated with. For more information, see <code>CreateOpenIDConnectProvider</code>.</p>
    pub url: std::option::Option<std::string::String>,
    /// <p>A list of client IDs (also known as audiences) that are associated with the specified IAM OIDC provider resource object. For more information, see <code>CreateOpenIDConnectProvider</code>.</p>
    pub client_id_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of certificate thumbprints that are associated with the specified IAM OIDC provider resource object. For more information, see <code>CreateOpenIDConnectProvider</code>. </p>
    pub thumbprint_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The date and time when the IAM OIDC provider resource object was created in the Amazon Web Services account.</p>
    pub create_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A list of tags that are attached to the specified IAM OIDC provider. The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl GetOpenIdConnectProviderOutput {
    /// <p>The URL that the IAM OIDC provider resource object is associated with. For more information, see <code>CreateOpenIDConnectProvider</code>.</p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
    /// <p>A list of client IDs (also known as audiences) that are associated with the specified IAM OIDC provider resource object. For more information, see <code>CreateOpenIDConnectProvider</code>.</p>
    pub fn client_id_list(&self) -> std::option::Option<&[std::string::String]> {
        self.client_id_list.as_deref()
    }
    /// <p>A list of certificate thumbprints that are associated with the specified IAM OIDC provider resource object. For more information, see <code>CreateOpenIDConnectProvider</code>. </p>
    pub fn thumbprint_list(&self) -> std::option::Option<&[std::string::String]> {
        self.thumbprint_list.as_deref()
    }
    /// <p>The date and time when the IAM OIDC provider resource object was created in the Amazon Web Services account.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_date.as_ref()
    }
    /// <p>A list of tags that are attached to the specified IAM OIDC provider. The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for GetOpenIdConnectProviderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOpenIdConnectProviderOutput");
        formatter.field("url", &self.url);
        formatter.field("client_id_list", &self.client_id_list);
        formatter.field("thumbprint_list", &self.thumbprint_list);
        formatter.field("create_date", &self.create_date);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetOpenIdConnectProviderOutput`](crate::output::GetOpenIdConnectProviderOutput)
pub mod get_open_id_connect_provider_output {
    /// A builder for [`GetOpenIdConnectProviderOutput`](crate::output::GetOpenIdConnectProviderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) client_id_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) thumbprint_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The URL that the IAM OIDC provider resource object is associated with. For more information, see <code>CreateOpenIDConnectProvider</code>.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The URL that the IAM OIDC provider resource object is associated with. For more information, see <code>CreateOpenIDConnectProvider</code>.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Appends an item to `client_id_list`.
        ///
        /// To override the contents of this collection use [`set_client_id_list`](Self::set_client_id_list).
        ///
        /// <p>A list of client IDs (also known as audiences) that are associated with the specified IAM OIDC provider resource object. For more information, see <code>CreateOpenIDConnectProvider</code>.</p>
        pub fn client_id_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.client_id_list.unwrap_or_default();
            v.push(input.into());
            self.client_id_list = Some(v);
            self
        }
        /// <p>A list of client IDs (also known as audiences) that are associated with the specified IAM OIDC provider resource object. For more information, see <code>CreateOpenIDConnectProvider</code>.</p>
        pub fn set_client_id_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.client_id_list = input;
            self
        }
        /// Appends an item to `thumbprint_list`.
        ///
        /// To override the contents of this collection use [`set_thumbprint_list`](Self::set_thumbprint_list).
        ///
        /// <p>A list of certificate thumbprints that are associated with the specified IAM OIDC provider resource object. For more information, see <code>CreateOpenIDConnectProvider</code>. </p>
        pub fn thumbprint_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.thumbprint_list.unwrap_or_default();
            v.push(input.into());
            self.thumbprint_list = Some(v);
            self
        }
        /// <p>A list of certificate thumbprints that are associated with the specified IAM OIDC provider resource object. For more information, see <code>CreateOpenIDConnectProvider</code>. </p>
        pub fn set_thumbprint_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.thumbprint_list = input;
            self
        }
        /// <p>The date and time when the IAM OIDC provider resource object was created in the Amazon Web Services account.</p>
        pub fn create_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time when the IAM OIDC provider resource object was created in the Amazon Web Services account.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that are attached to the specified IAM OIDC provider. The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags that are attached to the specified IAM OIDC provider. The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOpenIdConnectProviderOutput`](crate::output::GetOpenIdConnectProviderOutput)
        pub fn build(self) -> crate::output::GetOpenIdConnectProviderOutput {
            crate::output::GetOpenIdConnectProviderOutput {
                url: self.url,
                client_id_list: self.client_id_list,
                thumbprint_list: self.thumbprint_list,
                create_date: self.create_date,
                tags: self.tags,
            }
        }
    }
}
impl GetOpenIdConnectProviderOutput {
    /// Creates a new builder-style object to manufacture [`GetOpenIdConnectProviderOutput`](crate::output::GetOpenIdConnectProviderOutput)
    pub fn builder() -> crate::output::get_open_id_connect_provider_output::Builder {
        crate::output::get_open_id_connect_provider_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>GetLoginProfile</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLoginProfileOutput {
    /// <p>A structure containing the user name and the profile creation date for the user.</p>
    pub login_profile: std::option::Option<crate::model::LoginProfile>,
}
impl GetLoginProfileOutput {
    /// <p>A structure containing the user name and the profile creation date for the user.</p>
    pub fn login_profile(&self) -> std::option::Option<&crate::model::LoginProfile> {
        self.login_profile.as_ref()
    }
}
impl std::fmt::Debug for GetLoginProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLoginProfileOutput");
        formatter.field("login_profile", &self.login_profile);
        formatter.finish()
    }
}
/// See [`GetLoginProfileOutput`](crate::output::GetLoginProfileOutput)
pub mod get_login_profile_output {
    /// A builder for [`GetLoginProfileOutput`](crate::output::GetLoginProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) login_profile: std::option::Option<crate::model::LoginProfile>,
    }
    impl Builder {
        /// <p>A structure containing the user name and the profile creation date for the user.</p>
        pub fn login_profile(mut self, input: crate::model::LoginProfile) -> Self {
            self.login_profile = Some(input);
            self
        }
        /// <p>A structure containing the user name and the profile creation date for the user.</p>
        pub fn set_login_profile(
            mut self,
            input: std::option::Option<crate::model::LoginProfile>,
        ) -> Self {
            self.login_profile = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLoginProfileOutput`](crate::output::GetLoginProfileOutput)
        pub fn build(self) -> crate::output::GetLoginProfileOutput {
            crate::output::GetLoginProfileOutput {
                login_profile: self.login_profile,
            }
        }
    }
}
impl GetLoginProfileOutput {
    /// Creates a new builder-style object to manufacture [`GetLoginProfileOutput`](crate::output::GetLoginProfileOutput)
    pub fn builder() -> crate::output::get_login_profile_output::Builder {
        crate::output::get_login_profile_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>GetInstanceProfile</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInstanceProfileOutput {
    /// <p>A structure containing details about the instance profile.</p>
    pub instance_profile: std::option::Option<crate::model::InstanceProfile>,
}
impl GetInstanceProfileOutput {
    /// <p>A structure containing details about the instance profile.</p>
    pub fn instance_profile(&self) -> std::option::Option<&crate::model::InstanceProfile> {
        self.instance_profile.as_ref()
    }
}
impl std::fmt::Debug for GetInstanceProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInstanceProfileOutput");
        formatter.field("instance_profile", &self.instance_profile);
        formatter.finish()
    }
}
/// See [`GetInstanceProfileOutput`](crate::output::GetInstanceProfileOutput)
pub mod get_instance_profile_output {
    /// A builder for [`GetInstanceProfileOutput`](crate::output::GetInstanceProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_profile: std::option::Option<crate::model::InstanceProfile>,
    }
    impl Builder {
        /// <p>A structure containing details about the instance profile.</p>
        pub fn instance_profile(mut self, input: crate::model::InstanceProfile) -> Self {
            self.instance_profile = Some(input);
            self
        }
        /// <p>A structure containing details about the instance profile.</p>
        pub fn set_instance_profile(
            mut self,
            input: std::option::Option<crate::model::InstanceProfile>,
        ) -> Self {
            self.instance_profile = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInstanceProfileOutput`](crate::output::GetInstanceProfileOutput)
        pub fn build(self) -> crate::output::GetInstanceProfileOutput {
            crate::output::GetInstanceProfileOutput {
                instance_profile: self.instance_profile,
            }
        }
    }
}
impl GetInstanceProfileOutput {
    /// Creates a new builder-style object to manufacture [`GetInstanceProfileOutput`](crate::output::GetInstanceProfileOutput)
    pub fn builder() -> crate::output::get_instance_profile_output::Builder {
        crate::output::get_instance_profile_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>GetGroupPolicy</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGroupPolicyOutput {
    /// <p>The group the policy is associated with.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>The name of the policy.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The policy document.</p>
    /// <p>IAM stores policies in JSON format. However, resources that were created using CloudFormation templates can be formatted in YAML. CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.</p>
    pub policy_document: std::option::Option<std::string::String>,
}
impl GetGroupPolicyOutput {
    /// <p>The group the policy is associated with.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p>The name of the policy.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The policy document.</p>
    /// <p>IAM stores policies in JSON format. However, resources that were created using CloudFormation templates can be formatted in YAML. CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.</p>
    pub fn policy_document(&self) -> std::option::Option<&str> {
        self.policy_document.as_deref()
    }
}
impl std::fmt::Debug for GetGroupPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGroupPolicyOutput");
        formatter.field("group_name", &self.group_name);
        formatter.field("policy_name", &self.policy_name);
        formatter.field("policy_document", &self.policy_document);
        formatter.finish()
    }
}
/// See [`GetGroupPolicyOutput`](crate::output::GetGroupPolicyOutput)
pub mod get_group_policy_output {
    /// A builder for [`GetGroupPolicyOutput`](crate::output::GetGroupPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy_document: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The group the policy is associated with.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The group the policy is associated with.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The name of the policy.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The policy document.</p>
        /// <p>IAM stores policies in JSON format. However, resources that were created using CloudFormation templates can be formatted in YAML. CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.</p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_document = Some(input.into());
            self
        }
        /// <p>The policy document.</p>
        /// <p>IAM stores policies in JSON format. However, resources that were created using CloudFormation templates can be formatted in YAML. CloudFormation always converts a YAML policy to JSON format before submitting it to IAM.</p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_document = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGroupPolicyOutput`](crate::output::GetGroupPolicyOutput)
        pub fn build(self) -> crate::output::GetGroupPolicyOutput {
            crate::output::GetGroupPolicyOutput {
                group_name: self.group_name,
                policy_name: self.policy_name,
                policy_document: self.policy_document,
            }
        }
    }
}
impl GetGroupPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetGroupPolicyOutput`](crate::output::GetGroupPolicyOutput)
    pub fn builder() -> crate::output::get_group_policy_output::Builder {
        crate::output::get_group_policy_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>GetGroup</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGroupOutput {
    /// <p>A structure that contains details about the group.</p>
    pub group: std::option::Option<crate::model::Group>,
    /// <p>A list of users in the group.</p>
    pub users: std::option::Option<std::vec::Vec<crate::model::User>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl GetGroupOutput {
    /// <p>A structure that contains details about the group.</p>
    pub fn group(&self) -> std::option::Option<&crate::model::Group> {
        self.group.as_ref()
    }
    /// <p>A list of users in the group.</p>
    pub fn users(&self) -> std::option::Option<&[crate::model::User]> {
        self.users.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for GetGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGroupOutput");
        formatter.field("group", &self.group);
        formatter.field("users", &self.users);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`GetGroupOutput`](crate::output::GetGroupOutput)
pub mod get_group_output {
    /// A builder for [`GetGroupOutput`](crate::output::GetGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group: std::option::Option<crate::model::Group>,
        pub(crate) users: std::option::Option<std::vec::Vec<crate::model::User>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A structure that contains details about the group.</p>
        pub fn group(mut self, input: crate::model::Group) -> Self {
            self.group = Some(input);
            self
        }
        /// <p>A structure that contains details about the group.</p>
        pub fn set_group(mut self, input: std::option::Option<crate::model::Group>) -> Self {
            self.group = input;
            self
        }
        /// Appends an item to `users`.
        ///
        /// To override the contents of this collection use [`set_users`](Self::set_users).
        ///
        /// <p>A list of users in the group.</p>
        pub fn users(mut self, input: crate::model::User) -> Self {
            let mut v = self.users.unwrap_or_default();
            v.push(input);
            self.users = Some(v);
            self
        }
        /// <p>A list of users in the group.</p>
        pub fn set_users(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::User>>,
        ) -> Self {
            self.users = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGroupOutput`](crate::output::GetGroupOutput)
        pub fn build(self) -> crate::output::GetGroupOutput {
            crate::output::GetGroupOutput {
                group: self.group,
                users: self.users,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl GetGroupOutput {
    /// Creates a new builder-style object to manufacture [`GetGroupOutput`](crate::output::GetGroupOutput)
    pub fn builder() -> crate::output::get_group_output::Builder {
        crate::output::get_group_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>GetCredentialReport</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCredentialReportOutput {
    /// <p>Contains the credential report. The report is Base64-encoded.</p>
    pub content: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The format (MIME type) of the credential report.</p>
    pub report_format: std::option::Option<crate::model::ReportFormatType>,
    /// <p> The date and time when the credential report was created, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>.</p>
    pub generated_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl GetCredentialReportOutput {
    /// <p>Contains the credential report. The report is Base64-encoded.</p>
    pub fn content(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.content.as_ref()
    }
    /// <p>The format (MIME type) of the credential report.</p>
    pub fn report_format(&self) -> std::option::Option<&crate::model::ReportFormatType> {
        self.report_format.as_ref()
    }
    /// <p> The date and time when the credential report was created, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>.</p>
    pub fn generated_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.generated_time.as_ref()
    }
}
impl std::fmt::Debug for GetCredentialReportOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCredentialReportOutput");
        formatter.field("content", &self.content);
        formatter.field("report_format", &self.report_format);
        formatter.field("generated_time", &self.generated_time);
        formatter.finish()
    }
}
/// See [`GetCredentialReportOutput`](crate::output::GetCredentialReportOutput)
pub mod get_credential_report_output {
    /// A builder for [`GetCredentialReportOutput`](crate::output::GetCredentialReportOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) report_format: std::option::Option<crate::model::ReportFormatType>,
        pub(crate) generated_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Contains the credential report. The report is Base64-encoded.</p>
        pub fn content(mut self, input: aws_smithy_types::Blob) -> Self {
            self.content = Some(input);
            self
        }
        /// <p>Contains the credential report. The report is Base64-encoded.</p>
        pub fn set_content(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.content = input;
            self
        }
        /// <p>The format (MIME type) of the credential report.</p>
        pub fn report_format(mut self, input: crate::model::ReportFormatType) -> Self {
            self.report_format = Some(input);
            self
        }
        /// <p>The format (MIME type) of the credential report.</p>
        pub fn set_report_format(
            mut self,
            input: std::option::Option<crate::model::ReportFormatType>,
        ) -> Self {
            self.report_format = input;
            self
        }
        /// <p> The date and time when the credential report was created, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>.</p>
        pub fn generated_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.generated_time = Some(input);
            self
        }
        /// <p> The date and time when the credential report was created, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>.</p>
        pub fn set_generated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.generated_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCredentialReportOutput`](crate::output::GetCredentialReportOutput)
        pub fn build(self) -> crate::output::GetCredentialReportOutput {
            crate::output::GetCredentialReportOutput {
                content: self.content,
                report_format: self.report_format,
                generated_time: self.generated_time,
            }
        }
    }
}
impl GetCredentialReportOutput {
    /// Creates a new builder-style object to manufacture [`GetCredentialReportOutput`](crate::output::GetCredentialReportOutput)
    pub fn builder() -> crate::output::get_credential_report_output::Builder {
        crate::output::get_credential_report_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>GetContextKeysForPrincipalPolicy</code> or <code>GetContextKeysForCustomPolicy</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetContextKeysForPrincipalPolicyOutput {
    /// <p>The list of context keys that are referenced in the input policies.</p>
    pub context_key_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GetContextKeysForPrincipalPolicyOutput {
    /// <p>The list of context keys that are referenced in the input policies.</p>
    pub fn context_key_names(&self) -> std::option::Option<&[std::string::String]> {
        self.context_key_names.as_deref()
    }
}
impl std::fmt::Debug for GetContextKeysForPrincipalPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetContextKeysForPrincipalPolicyOutput");
        formatter.field("context_key_names", &self.context_key_names);
        formatter.finish()
    }
}
/// See [`GetContextKeysForPrincipalPolicyOutput`](crate::output::GetContextKeysForPrincipalPolicyOutput)
pub mod get_context_keys_for_principal_policy_output {
    /// A builder for [`GetContextKeysForPrincipalPolicyOutput`](crate::output::GetContextKeysForPrincipalPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) context_key_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `context_key_names`.
        ///
        /// To override the contents of this collection use [`set_context_key_names`](Self::set_context_key_names).
        ///
        /// <p>The list of context keys that are referenced in the input policies.</p>
        pub fn context_key_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.context_key_names.unwrap_or_default();
            v.push(input.into());
            self.context_key_names = Some(v);
            self
        }
        /// <p>The list of context keys that are referenced in the input policies.</p>
        pub fn set_context_key_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.context_key_names = input;
            self
        }
        /// Consumes the builder and constructs a [`GetContextKeysForPrincipalPolicyOutput`](crate::output::GetContextKeysForPrincipalPolicyOutput)
        pub fn build(self) -> crate::output::GetContextKeysForPrincipalPolicyOutput {
            crate::output::GetContextKeysForPrincipalPolicyOutput {
                context_key_names: self.context_key_names,
            }
        }
    }
}
impl GetContextKeysForPrincipalPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetContextKeysForPrincipalPolicyOutput`](crate::output::GetContextKeysForPrincipalPolicyOutput)
    pub fn builder() -> crate::output::get_context_keys_for_principal_policy_output::Builder {
        crate::output::get_context_keys_for_principal_policy_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>GetContextKeysForPrincipalPolicy</code> or <code>GetContextKeysForCustomPolicy</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetContextKeysForCustomPolicyOutput {
    /// <p>The list of context keys that are referenced in the input policies.</p>
    pub context_key_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GetContextKeysForCustomPolicyOutput {
    /// <p>The list of context keys that are referenced in the input policies.</p>
    pub fn context_key_names(&self) -> std::option::Option<&[std::string::String]> {
        self.context_key_names.as_deref()
    }
}
impl std::fmt::Debug for GetContextKeysForCustomPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetContextKeysForCustomPolicyOutput");
        formatter.field("context_key_names", &self.context_key_names);
        formatter.finish()
    }
}
/// See [`GetContextKeysForCustomPolicyOutput`](crate::output::GetContextKeysForCustomPolicyOutput)
pub mod get_context_keys_for_custom_policy_output {
    /// A builder for [`GetContextKeysForCustomPolicyOutput`](crate::output::GetContextKeysForCustomPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) context_key_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `context_key_names`.
        ///
        /// To override the contents of this collection use [`set_context_key_names`](Self::set_context_key_names).
        ///
        /// <p>The list of context keys that are referenced in the input policies.</p>
        pub fn context_key_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.context_key_names.unwrap_or_default();
            v.push(input.into());
            self.context_key_names = Some(v);
            self
        }
        /// <p>The list of context keys that are referenced in the input policies.</p>
        pub fn set_context_key_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.context_key_names = input;
            self
        }
        /// Consumes the builder and constructs a [`GetContextKeysForCustomPolicyOutput`](crate::output::GetContextKeysForCustomPolicyOutput)
        pub fn build(self) -> crate::output::GetContextKeysForCustomPolicyOutput {
            crate::output::GetContextKeysForCustomPolicyOutput {
                context_key_names: self.context_key_names,
            }
        }
    }
}
impl GetContextKeysForCustomPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetContextKeysForCustomPolicyOutput`](crate::output::GetContextKeysForCustomPolicyOutput)
    pub fn builder() -> crate::output::get_context_keys_for_custom_policy_output::Builder {
        crate::output::get_context_keys_for_custom_policy_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>GetAccountSummary</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccountSummaryOutput {
    /// <p>A set of key–value pairs containing information about IAM entity usage and IAM quotas.</p>
    pub summary_map:
        std::option::Option<std::collections::HashMap<crate::model::SummaryKeyType, i32>>,
}
impl GetAccountSummaryOutput {
    /// <p>A set of key–value pairs containing information about IAM entity usage and IAM quotas.</p>
    pub fn summary_map(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<crate::model::SummaryKeyType, i32>> {
        self.summary_map.as_ref()
    }
}
impl std::fmt::Debug for GetAccountSummaryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccountSummaryOutput");
        formatter.field("summary_map", &self.summary_map);
        formatter.finish()
    }
}
/// See [`GetAccountSummaryOutput`](crate::output::GetAccountSummaryOutput)
pub mod get_account_summary_output {
    /// A builder for [`GetAccountSummaryOutput`](crate::output::GetAccountSummaryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) summary_map:
            std::option::Option<std::collections::HashMap<crate::model::SummaryKeyType, i32>>,
    }
    impl Builder {
        /// Adds a key-value pair to `summary_map`.
        ///
        /// To override the contents of this collection use [`set_summary_map`](Self::set_summary_map).
        ///
        /// <p>A set of key–value pairs containing information about IAM entity usage and IAM quotas.</p>
        pub fn summary_map(mut self, k: crate::model::SummaryKeyType, v: i32) -> Self {
            let mut hash_map = self.summary_map.unwrap_or_default();
            hash_map.insert(k, v);
            self.summary_map = Some(hash_map);
            self
        }
        /// <p>A set of key–value pairs containing information about IAM entity usage and IAM quotas.</p>
        pub fn set_summary_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::SummaryKeyType, i32>,
            >,
        ) -> Self {
            self.summary_map = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccountSummaryOutput`](crate::output::GetAccountSummaryOutput)
        pub fn build(self) -> crate::output::GetAccountSummaryOutput {
            crate::output::GetAccountSummaryOutput {
                summary_map: self.summary_map,
            }
        }
    }
}
impl GetAccountSummaryOutput {
    /// Creates a new builder-style object to manufacture [`GetAccountSummaryOutput`](crate::output::GetAccountSummaryOutput)
    pub fn builder() -> crate::output::get_account_summary_output::Builder {
        crate::output::get_account_summary_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>GetAccountPasswordPolicy</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccountPasswordPolicyOutput {
    /// <p>A structure that contains details about the account's password policy.</p>
    pub password_policy: std::option::Option<crate::model::PasswordPolicy>,
}
impl GetAccountPasswordPolicyOutput {
    /// <p>A structure that contains details about the account's password policy.</p>
    pub fn password_policy(&self) -> std::option::Option<&crate::model::PasswordPolicy> {
        self.password_policy.as_ref()
    }
}
impl std::fmt::Debug for GetAccountPasswordPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccountPasswordPolicyOutput");
        formatter.field("password_policy", &self.password_policy);
        formatter.finish()
    }
}
/// See [`GetAccountPasswordPolicyOutput`](crate::output::GetAccountPasswordPolicyOutput)
pub mod get_account_password_policy_output {
    /// A builder for [`GetAccountPasswordPolicyOutput`](crate::output::GetAccountPasswordPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) password_policy: std::option::Option<crate::model::PasswordPolicy>,
    }
    impl Builder {
        /// <p>A structure that contains details about the account's password policy.</p>
        pub fn password_policy(mut self, input: crate::model::PasswordPolicy) -> Self {
            self.password_policy = Some(input);
            self
        }
        /// <p>A structure that contains details about the account's password policy.</p>
        pub fn set_password_policy(
            mut self,
            input: std::option::Option<crate::model::PasswordPolicy>,
        ) -> Self {
            self.password_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccountPasswordPolicyOutput`](crate::output::GetAccountPasswordPolicyOutput)
        pub fn build(self) -> crate::output::GetAccountPasswordPolicyOutput {
            crate::output::GetAccountPasswordPolicyOutput {
                password_policy: self.password_policy,
            }
        }
    }
}
impl GetAccountPasswordPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetAccountPasswordPolicyOutput`](crate::output::GetAccountPasswordPolicyOutput)
    pub fn builder() -> crate::output::get_account_password_policy_output::Builder {
        crate::output::get_account_password_policy_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>GetAccountAuthorizationDetails</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccountAuthorizationDetailsOutput {
    /// <p>A list containing information about IAM users.</p>
    pub user_detail_list: std::option::Option<std::vec::Vec<crate::model::UserDetail>>,
    /// <p>A list containing information about IAM groups.</p>
    pub group_detail_list: std::option::Option<std::vec::Vec<crate::model::GroupDetail>>,
    /// <p>A list containing information about IAM roles.</p>
    pub role_detail_list: std::option::Option<std::vec::Vec<crate::model::RoleDetail>>,
    /// <p>A list containing information about managed policies.</p>
    pub policies: std::option::Option<std::vec::Vec<crate::model::ManagedPolicyDetail>>,
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub is_truncated: bool,
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl GetAccountAuthorizationDetailsOutput {
    /// <p>A list containing information about IAM users.</p>
    pub fn user_detail_list(&self) -> std::option::Option<&[crate::model::UserDetail]> {
        self.user_detail_list.as_deref()
    }
    /// <p>A list containing information about IAM groups.</p>
    pub fn group_detail_list(&self) -> std::option::Option<&[crate::model::GroupDetail]> {
        self.group_detail_list.as_deref()
    }
    /// <p>A list containing information about IAM roles.</p>
    pub fn role_detail_list(&self) -> std::option::Option<&[crate::model::RoleDetail]> {
        self.role_detail_list.as_deref()
    }
    /// <p>A list containing information about managed policies.</p>
    pub fn policies(&self) -> std::option::Option<&[crate::model::ManagedPolicyDetail]> {
        self.policies.as_deref()
    }
    /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
    pub fn is_truncated(&self) -> bool {
        self.is_truncated
    }
    /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for GetAccountAuthorizationDetailsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccountAuthorizationDetailsOutput");
        formatter.field("user_detail_list", &self.user_detail_list);
        formatter.field("group_detail_list", &self.group_detail_list);
        formatter.field("role_detail_list", &self.role_detail_list);
        formatter.field("policies", &self.policies);
        formatter.field("is_truncated", &self.is_truncated);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`GetAccountAuthorizationDetailsOutput`](crate::output::GetAccountAuthorizationDetailsOutput)
pub mod get_account_authorization_details_output {
    /// A builder for [`GetAccountAuthorizationDetailsOutput`](crate::output::GetAccountAuthorizationDetailsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_detail_list: std::option::Option<std::vec::Vec<crate::model::UserDetail>>,
        pub(crate) group_detail_list: std::option::Option<std::vec::Vec<crate::model::GroupDetail>>,
        pub(crate) role_detail_list: std::option::Option<std::vec::Vec<crate::model::RoleDetail>>,
        pub(crate) policies: std::option::Option<std::vec::Vec<crate::model::ManagedPolicyDetail>>,
        pub(crate) is_truncated: std::option::Option<bool>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `user_detail_list`.
        ///
        /// To override the contents of this collection use [`set_user_detail_list`](Self::set_user_detail_list).
        ///
        /// <p>A list containing information about IAM users.</p>
        pub fn user_detail_list(mut self, input: crate::model::UserDetail) -> Self {
            let mut v = self.user_detail_list.unwrap_or_default();
            v.push(input);
            self.user_detail_list = Some(v);
            self
        }
        /// <p>A list containing information about IAM users.</p>
        pub fn set_user_detail_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserDetail>>,
        ) -> Self {
            self.user_detail_list = input;
            self
        }
        /// Appends an item to `group_detail_list`.
        ///
        /// To override the contents of this collection use [`set_group_detail_list`](Self::set_group_detail_list).
        ///
        /// <p>A list containing information about IAM groups.</p>
        pub fn group_detail_list(mut self, input: crate::model::GroupDetail) -> Self {
            let mut v = self.group_detail_list.unwrap_or_default();
            v.push(input);
            self.group_detail_list = Some(v);
            self
        }
        /// <p>A list containing information about IAM groups.</p>
        pub fn set_group_detail_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupDetail>>,
        ) -> Self {
            self.group_detail_list = input;
            self
        }
        /// Appends an item to `role_detail_list`.
        ///
        /// To override the contents of this collection use [`set_role_detail_list`](Self::set_role_detail_list).
        ///
        /// <p>A list containing information about IAM roles.</p>
        pub fn role_detail_list(mut self, input: crate::model::RoleDetail) -> Self {
            let mut v = self.role_detail_list.unwrap_or_default();
            v.push(input);
            self.role_detail_list = Some(v);
            self
        }
        /// <p>A list containing information about IAM roles.</p>
        pub fn set_role_detail_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RoleDetail>>,
        ) -> Self {
            self.role_detail_list = input;
            self
        }
        /// Appends an item to `policies`.
        ///
        /// To override the contents of this collection use [`set_policies`](Self::set_policies).
        ///
        /// <p>A list containing information about managed policies.</p>
        pub fn policies(mut self, input: crate::model::ManagedPolicyDetail) -> Self {
            let mut v = self.policies.unwrap_or_default();
            v.push(input);
            self.policies = Some(v);
            self
        }
        /// <p>A list containing information about managed policies.</p>
        pub fn set_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ManagedPolicyDetail>>,
        ) -> Self {
            self.policies = input;
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn is_truncated(mut self, input: bool) -> Self {
            self.is_truncated = Some(input);
            self
        }
        /// <p>A flag that indicates whether there are more items to return. If your results were truncated, you can make a subsequent pagination request using the <code>Marker</code> request parameter to retrieve more items. Note that IAM might return fewer than the <code>MaxItems</code> number of results even when there are more results available. We recommend that you check <code>IsTruncated</code> after every call to ensure that you receive all your results.</p>
        pub fn set_is_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.is_truncated = input;
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>When <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value to use for the <code>Marker</code> parameter in a subsequent pagination request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccountAuthorizationDetailsOutput`](crate::output::GetAccountAuthorizationDetailsOutput)
        pub fn build(self) -> crate::output::GetAccountAuthorizationDetailsOutput {
            crate::output::GetAccountAuthorizationDetailsOutput {
                user_detail_list: self.user_detail_list,
                group_detail_list: self.group_detail_list,
                role_detail_list: self.role_detail_list,
                policies: self.policies,
                is_truncated: self.is_truncated.unwrap_or_default(),
                marker: self.marker,
            }
        }
    }
}
impl GetAccountAuthorizationDetailsOutput {
    /// Creates a new builder-style object to manufacture [`GetAccountAuthorizationDetailsOutput`](crate::output::GetAccountAuthorizationDetailsOutput)
    pub fn builder() -> crate::output::get_account_authorization_details_output::Builder {
        crate::output::get_account_authorization_details_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>GetAccessKeyLastUsed</code> request. It is also returned as a member of the <code>AccessKeyMetaData</code> structure returned by the <code>ListAccessKeys</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccessKeyLastUsedOutput {
    /// <p>The name of the IAM user that owns this access key.</p>
    /// <p></p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>Contains information about the last time the access key was used.</p>
    pub access_key_last_used: std::option::Option<crate::model::AccessKeyLastUsed>,
}
impl GetAccessKeyLastUsedOutput {
    /// <p>The name of the IAM user that owns this access key.</p>
    /// <p></p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>Contains information about the last time the access key was used.</p>
    pub fn access_key_last_used(&self) -> std::option::Option<&crate::model::AccessKeyLastUsed> {
        self.access_key_last_used.as_ref()
    }
}
impl std::fmt::Debug for GetAccessKeyLastUsedOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccessKeyLastUsedOutput");
        formatter.field("user_name", &self.user_name);
        formatter.field("access_key_last_used", &self.access_key_last_used);
        formatter.finish()
    }
}
/// See [`GetAccessKeyLastUsedOutput`](crate::output::GetAccessKeyLastUsedOutput)
pub mod get_access_key_last_used_output {
    /// A builder for [`GetAccessKeyLastUsedOutput`](crate::output::GetAccessKeyLastUsedOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) access_key_last_used: std::option::Option<crate::model::AccessKeyLastUsed>,
    }
    impl Builder {
        /// <p>The name of the IAM user that owns this access key.</p>
        /// <p></p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM user that owns this access key.</p>
        /// <p></p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>Contains information about the last time the access key was used.</p>
        pub fn access_key_last_used(mut self, input: crate::model::AccessKeyLastUsed) -> Self {
            self.access_key_last_used = Some(input);
            self
        }
        /// <p>Contains information about the last time the access key was used.</p>
        pub fn set_access_key_last_used(
            mut self,
            input: std::option::Option<crate::model::AccessKeyLastUsed>,
        ) -> Self {
            self.access_key_last_used = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccessKeyLastUsedOutput`](crate::output::GetAccessKeyLastUsedOutput)
        pub fn build(self) -> crate::output::GetAccessKeyLastUsedOutput {
            crate::output::GetAccessKeyLastUsedOutput {
                user_name: self.user_name,
                access_key_last_used: self.access_key_last_used,
            }
        }
    }
}
impl GetAccessKeyLastUsedOutput {
    /// Creates a new builder-style object to manufacture [`GetAccessKeyLastUsedOutput`](crate::output::GetAccessKeyLastUsedOutput)
    pub fn builder() -> crate::output::get_access_key_last_used_output::Builder {
        crate::output::get_access_key_last_used_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GenerateServiceLastAccessedDetailsOutput {
    /// <p>The <code>JobId</code> that you can use in the <code>GetServiceLastAccessedDetails</code> or <code>GetServiceLastAccessedDetailsWithEntities</code> operations. The <code>JobId</code> returned by <code>GenerateServiceLastAccessedDetail</code> must be used by the same role within a session, or by the same user when used to call <code>GetServiceLastAccessedDetail</code>.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl GenerateServiceLastAccessedDetailsOutput {
    /// <p>The <code>JobId</code> that you can use in the <code>GetServiceLastAccessedDetails</code> or <code>GetServiceLastAccessedDetailsWithEntities</code> operations. The <code>JobId</code> returned by <code>GenerateServiceLastAccessedDetail</code> must be used by the same role within a session, or by the same user when used to call <code>GetServiceLastAccessedDetail</code>.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for GenerateServiceLastAccessedDetailsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GenerateServiceLastAccessedDetailsOutput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}
/// See [`GenerateServiceLastAccessedDetailsOutput`](crate::output::GenerateServiceLastAccessedDetailsOutput)
pub mod generate_service_last_accessed_details_output {
    /// A builder for [`GenerateServiceLastAccessedDetailsOutput`](crate::output::GenerateServiceLastAccessedDetailsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>JobId</code> that you can use in the <code>GetServiceLastAccessedDetails</code> or <code>GetServiceLastAccessedDetailsWithEntities</code> operations. The <code>JobId</code> returned by <code>GenerateServiceLastAccessedDetail</code> must be used by the same role within a session, or by the same user when used to call <code>GetServiceLastAccessedDetail</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The <code>JobId</code> that you can use in the <code>GetServiceLastAccessedDetails</code> or <code>GetServiceLastAccessedDetailsWithEntities</code> operations. The <code>JobId</code> returned by <code>GenerateServiceLastAccessedDetail</code> must be used by the same role within a session, or by the same user when used to call <code>GetServiceLastAccessedDetail</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GenerateServiceLastAccessedDetailsOutput`](crate::output::GenerateServiceLastAccessedDetailsOutput)
        pub fn build(self) -> crate::output::GenerateServiceLastAccessedDetailsOutput {
            crate::output::GenerateServiceLastAccessedDetailsOutput {
                job_id: self.job_id,
            }
        }
    }
}
impl GenerateServiceLastAccessedDetailsOutput {
    /// Creates a new builder-style object to manufacture [`GenerateServiceLastAccessedDetailsOutput`](crate::output::GenerateServiceLastAccessedDetailsOutput)
    pub fn builder() -> crate::output::generate_service_last_accessed_details_output::Builder {
        crate::output::generate_service_last_accessed_details_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GenerateOrganizationsAccessReportOutput {
    /// <p>The job identifier that you can use in the <code>GetOrganizationsAccessReport</code> operation.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl GenerateOrganizationsAccessReportOutput {
    /// <p>The job identifier that you can use in the <code>GetOrganizationsAccessReport</code> operation.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for GenerateOrganizationsAccessReportOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GenerateOrganizationsAccessReportOutput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}
/// See [`GenerateOrganizationsAccessReportOutput`](crate::output::GenerateOrganizationsAccessReportOutput)
pub mod generate_organizations_access_report_output {
    /// A builder for [`GenerateOrganizationsAccessReportOutput`](crate::output::GenerateOrganizationsAccessReportOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The job identifier that you can use in the <code>GetOrganizationsAccessReport</code> operation.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The job identifier that you can use in the <code>GetOrganizationsAccessReport</code> operation.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GenerateOrganizationsAccessReportOutput`](crate::output::GenerateOrganizationsAccessReportOutput)
        pub fn build(self) -> crate::output::GenerateOrganizationsAccessReportOutput {
            crate::output::GenerateOrganizationsAccessReportOutput {
                job_id: self.job_id,
            }
        }
    }
}
impl GenerateOrganizationsAccessReportOutput {
    /// Creates a new builder-style object to manufacture [`GenerateOrganizationsAccessReportOutput`](crate::output::GenerateOrganizationsAccessReportOutput)
    pub fn builder() -> crate::output::generate_organizations_access_report_output::Builder {
        crate::output::generate_organizations_access_report_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>GenerateCredentialReport</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GenerateCredentialReportOutput {
    /// <p>Information about the state of the credential report.</p>
    pub state: std::option::Option<crate::model::ReportStateType>,
    /// <p>Information about the credential report.</p>
    pub description: std::option::Option<std::string::String>,
}
impl GenerateCredentialReportOutput {
    /// <p>Information about the state of the credential report.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::ReportStateType> {
        self.state.as_ref()
    }
    /// <p>Information about the credential report.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for GenerateCredentialReportOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GenerateCredentialReportOutput");
        formatter.field("state", &self.state);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`GenerateCredentialReportOutput`](crate::output::GenerateCredentialReportOutput)
pub mod generate_credential_report_output {
    /// A builder for [`GenerateCredentialReportOutput`](crate::output::GenerateCredentialReportOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::ReportStateType>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information about the state of the credential report.</p>
        pub fn state(mut self, input: crate::model::ReportStateType) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>Information about the state of the credential report.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ReportStateType>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>Information about the credential report.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Information about the credential report.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`GenerateCredentialReportOutput`](crate::output::GenerateCredentialReportOutput)
        pub fn build(self) -> crate::output::GenerateCredentialReportOutput {
            crate::output::GenerateCredentialReportOutput {
                state: self.state,
                description: self.description,
            }
        }
    }
}
impl GenerateCredentialReportOutput {
    /// Creates a new builder-style object to manufacture [`GenerateCredentialReportOutput`](crate::output::GenerateCredentialReportOutput)
    pub fn builder() -> crate::output::generate_credential_report_output::Builder {
        crate::output::generate_credential_report_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableMfaDeviceOutput {}
impl std::fmt::Debug for EnableMfaDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableMfaDeviceOutput");
        formatter.finish()
    }
}
/// See [`EnableMfaDeviceOutput`](crate::output::EnableMfaDeviceOutput)
pub mod enable_mfa_device_output {
    /// A builder for [`EnableMfaDeviceOutput`](crate::output::EnableMfaDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`EnableMfaDeviceOutput`](crate::output::EnableMfaDeviceOutput)
        pub fn build(self) -> crate::output::EnableMfaDeviceOutput {
            crate::output::EnableMfaDeviceOutput {}
        }
    }
}
impl EnableMfaDeviceOutput {
    /// Creates a new builder-style object to manufacture [`EnableMfaDeviceOutput`](crate::output::EnableMfaDeviceOutput)
    pub fn builder() -> crate::output::enable_mfa_device_output::Builder {
        crate::output::enable_mfa_device_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetachUserPolicyOutput {}
impl std::fmt::Debug for DetachUserPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetachUserPolicyOutput");
        formatter.finish()
    }
}
/// See [`DetachUserPolicyOutput`](crate::output::DetachUserPolicyOutput)
pub mod detach_user_policy_output {
    /// A builder for [`DetachUserPolicyOutput`](crate::output::DetachUserPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DetachUserPolicyOutput`](crate::output::DetachUserPolicyOutput)
        pub fn build(self) -> crate::output::DetachUserPolicyOutput {
            crate::output::DetachUserPolicyOutput {}
        }
    }
}
impl DetachUserPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DetachUserPolicyOutput`](crate::output::DetachUserPolicyOutput)
    pub fn builder() -> crate::output::detach_user_policy_output::Builder {
        crate::output::detach_user_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetachRolePolicyOutput {}
impl std::fmt::Debug for DetachRolePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetachRolePolicyOutput");
        formatter.finish()
    }
}
/// See [`DetachRolePolicyOutput`](crate::output::DetachRolePolicyOutput)
pub mod detach_role_policy_output {
    /// A builder for [`DetachRolePolicyOutput`](crate::output::DetachRolePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DetachRolePolicyOutput`](crate::output::DetachRolePolicyOutput)
        pub fn build(self) -> crate::output::DetachRolePolicyOutput {
            crate::output::DetachRolePolicyOutput {}
        }
    }
}
impl DetachRolePolicyOutput {
    /// Creates a new builder-style object to manufacture [`DetachRolePolicyOutput`](crate::output::DetachRolePolicyOutput)
    pub fn builder() -> crate::output::detach_role_policy_output::Builder {
        crate::output::detach_role_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetachGroupPolicyOutput {}
impl std::fmt::Debug for DetachGroupPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetachGroupPolicyOutput");
        formatter.finish()
    }
}
/// See [`DetachGroupPolicyOutput`](crate::output::DetachGroupPolicyOutput)
pub mod detach_group_policy_output {
    /// A builder for [`DetachGroupPolicyOutput`](crate::output::DetachGroupPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DetachGroupPolicyOutput`](crate::output::DetachGroupPolicyOutput)
        pub fn build(self) -> crate::output::DetachGroupPolicyOutput {
            crate::output::DetachGroupPolicyOutput {}
        }
    }
}
impl DetachGroupPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DetachGroupPolicyOutput`](crate::output::DetachGroupPolicyOutput)
    pub fn builder() -> crate::output::detach_group_policy_output::Builder {
        crate::output::detach_group_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVirtualMfaDeviceOutput {}
impl std::fmt::Debug for DeleteVirtualMfaDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVirtualMfaDeviceOutput");
        formatter.finish()
    }
}
/// See [`DeleteVirtualMfaDeviceOutput`](crate::output::DeleteVirtualMfaDeviceOutput)
pub mod delete_virtual_mfa_device_output {
    /// A builder for [`DeleteVirtualMfaDeviceOutput`](crate::output::DeleteVirtualMfaDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteVirtualMfaDeviceOutput`](crate::output::DeleteVirtualMfaDeviceOutput)
        pub fn build(self) -> crate::output::DeleteVirtualMfaDeviceOutput {
            crate::output::DeleteVirtualMfaDeviceOutput {}
        }
    }
}
impl DeleteVirtualMfaDeviceOutput {
    /// Creates a new builder-style object to manufacture [`DeleteVirtualMfaDeviceOutput`](crate::output::DeleteVirtualMfaDeviceOutput)
    pub fn builder() -> crate::output::delete_virtual_mfa_device_output::Builder {
        crate::output::delete_virtual_mfa_device_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUserPolicyOutput {}
impl std::fmt::Debug for DeleteUserPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUserPolicyOutput");
        formatter.finish()
    }
}
/// See [`DeleteUserPolicyOutput`](crate::output::DeleteUserPolicyOutput)
pub mod delete_user_policy_output {
    /// A builder for [`DeleteUserPolicyOutput`](crate::output::DeleteUserPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteUserPolicyOutput`](crate::output::DeleteUserPolicyOutput)
        pub fn build(self) -> crate::output::DeleteUserPolicyOutput {
            crate::output::DeleteUserPolicyOutput {}
        }
    }
}
impl DeleteUserPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteUserPolicyOutput`](crate::output::DeleteUserPolicyOutput)
    pub fn builder() -> crate::output::delete_user_policy_output::Builder {
        crate::output::delete_user_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUserPermissionsBoundaryOutput {}
impl std::fmt::Debug for DeleteUserPermissionsBoundaryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUserPermissionsBoundaryOutput");
        formatter.finish()
    }
}
/// See [`DeleteUserPermissionsBoundaryOutput`](crate::output::DeleteUserPermissionsBoundaryOutput)
pub mod delete_user_permissions_boundary_output {
    /// A builder for [`DeleteUserPermissionsBoundaryOutput`](crate::output::DeleteUserPermissionsBoundaryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteUserPermissionsBoundaryOutput`](crate::output::DeleteUserPermissionsBoundaryOutput)
        pub fn build(self) -> crate::output::DeleteUserPermissionsBoundaryOutput {
            crate::output::DeleteUserPermissionsBoundaryOutput {}
        }
    }
}
impl DeleteUserPermissionsBoundaryOutput {
    /// Creates a new builder-style object to manufacture [`DeleteUserPermissionsBoundaryOutput`](crate::output::DeleteUserPermissionsBoundaryOutput)
    pub fn builder() -> crate::output::delete_user_permissions_boundary_output::Builder {
        crate::output::delete_user_permissions_boundary_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUserOutput {}
impl std::fmt::Debug for DeleteUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUserOutput");
        formatter.finish()
    }
}
/// See [`DeleteUserOutput`](crate::output::DeleteUserOutput)
pub mod delete_user_output {
    /// A builder for [`DeleteUserOutput`](crate::output::DeleteUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteUserOutput`](crate::output::DeleteUserOutput)
        pub fn build(self) -> crate::output::DeleteUserOutput {
            crate::output::DeleteUserOutput {}
        }
    }
}
impl DeleteUserOutput {
    /// Creates a new builder-style object to manufacture [`DeleteUserOutput`](crate::output::DeleteUserOutput)
    pub fn builder() -> crate::output::delete_user_output::Builder {
        crate::output::delete_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSshPublicKeyOutput {}
impl std::fmt::Debug for DeleteSshPublicKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSshPublicKeyOutput");
        formatter.finish()
    }
}
/// See [`DeleteSshPublicKeyOutput`](crate::output::DeleteSshPublicKeyOutput)
pub mod delete_ssh_public_key_output {
    /// A builder for [`DeleteSshPublicKeyOutput`](crate::output::DeleteSshPublicKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteSshPublicKeyOutput`](crate::output::DeleteSshPublicKeyOutput)
        pub fn build(self) -> crate::output::DeleteSshPublicKeyOutput {
            crate::output::DeleteSshPublicKeyOutput {}
        }
    }
}
impl DeleteSshPublicKeyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSshPublicKeyOutput`](crate::output::DeleteSshPublicKeyOutput)
    pub fn builder() -> crate::output::delete_ssh_public_key_output::Builder {
        crate::output::delete_ssh_public_key_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSigningCertificateOutput {}
impl std::fmt::Debug for DeleteSigningCertificateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSigningCertificateOutput");
        formatter.finish()
    }
}
/// See [`DeleteSigningCertificateOutput`](crate::output::DeleteSigningCertificateOutput)
pub mod delete_signing_certificate_output {
    /// A builder for [`DeleteSigningCertificateOutput`](crate::output::DeleteSigningCertificateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteSigningCertificateOutput`](crate::output::DeleteSigningCertificateOutput)
        pub fn build(self) -> crate::output::DeleteSigningCertificateOutput {
            crate::output::DeleteSigningCertificateOutput {}
        }
    }
}
impl DeleteSigningCertificateOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSigningCertificateOutput`](crate::output::DeleteSigningCertificateOutput)
    pub fn builder() -> crate::output::delete_signing_certificate_output::Builder {
        crate::output::delete_signing_certificate_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteServiceSpecificCredentialOutput {}
impl std::fmt::Debug for DeleteServiceSpecificCredentialOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteServiceSpecificCredentialOutput");
        formatter.finish()
    }
}
/// See [`DeleteServiceSpecificCredentialOutput`](crate::output::DeleteServiceSpecificCredentialOutput)
pub mod delete_service_specific_credential_output {
    /// A builder for [`DeleteServiceSpecificCredentialOutput`](crate::output::DeleteServiceSpecificCredentialOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteServiceSpecificCredentialOutput`](crate::output::DeleteServiceSpecificCredentialOutput)
        pub fn build(self) -> crate::output::DeleteServiceSpecificCredentialOutput {
            crate::output::DeleteServiceSpecificCredentialOutput {}
        }
    }
}
impl DeleteServiceSpecificCredentialOutput {
    /// Creates a new builder-style object to manufacture [`DeleteServiceSpecificCredentialOutput`](crate::output::DeleteServiceSpecificCredentialOutput)
    pub fn builder() -> crate::output::delete_service_specific_credential_output::Builder {
        crate::output::delete_service_specific_credential_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteServiceLinkedRoleOutput {
    /// <p>The deletion task identifier that you can use to check the status of the deletion. This identifier is returned in the format <code>task/aws-service-role/
    /// <service-principal-name>
    /// /
    /// <role-name>
    /// /
    /// <task-uuid></task-uuid>
    /// </role-name>
    /// </service-principal-name></code>.</p>
    pub deletion_task_id: std::option::Option<std::string::String>,
}
impl DeleteServiceLinkedRoleOutput {
    /// <p>The deletion task identifier that you can use to check the status of the deletion. This identifier is returned in the format <code>task/aws-service-role/
    /// <service-principal-name>
    /// /
    /// <role-name>
    /// /
    /// <task-uuid></task-uuid>
    /// </role-name>
    /// </service-principal-name></code>.</p>
    pub fn deletion_task_id(&self) -> std::option::Option<&str> {
        self.deletion_task_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteServiceLinkedRoleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteServiceLinkedRoleOutput");
        formatter.field("deletion_task_id", &self.deletion_task_id);
        formatter.finish()
    }
}
/// See [`DeleteServiceLinkedRoleOutput`](crate::output::DeleteServiceLinkedRoleOutput)
pub mod delete_service_linked_role_output {
    /// A builder for [`DeleteServiceLinkedRoleOutput`](crate::output::DeleteServiceLinkedRoleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deletion_task_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The deletion task identifier that you can use to check the status of the deletion. This identifier is returned in the format <code>task/aws-service-role/
        /// <service-principal-name>
        /// /
        /// <role-name>
        /// /
        /// <task-uuid></task-uuid>
        /// </role-name>
        /// </service-principal-name></code>.</p>
        pub fn deletion_task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deletion_task_id = Some(input.into());
            self
        }
        /// <p>The deletion task identifier that you can use to check the status of the deletion. This identifier is returned in the format <code>task/aws-service-role/
        /// <service-principal-name>
        /// /
        /// <role-name>
        /// /
        /// <task-uuid></task-uuid>
        /// </role-name>
        /// </service-principal-name></code>.</p>
        pub fn set_deletion_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deletion_task_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteServiceLinkedRoleOutput`](crate::output::DeleteServiceLinkedRoleOutput)
        pub fn build(self) -> crate::output::DeleteServiceLinkedRoleOutput {
            crate::output::DeleteServiceLinkedRoleOutput {
                deletion_task_id: self.deletion_task_id,
            }
        }
    }
}
impl DeleteServiceLinkedRoleOutput {
    /// Creates a new builder-style object to manufacture [`DeleteServiceLinkedRoleOutput`](crate::output::DeleteServiceLinkedRoleOutput)
    pub fn builder() -> crate::output::delete_service_linked_role_output::Builder {
        crate::output::delete_service_linked_role_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteServerCertificateOutput {}
impl std::fmt::Debug for DeleteServerCertificateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteServerCertificateOutput");
        formatter.finish()
    }
}
/// See [`DeleteServerCertificateOutput`](crate::output::DeleteServerCertificateOutput)
pub mod delete_server_certificate_output {
    /// A builder for [`DeleteServerCertificateOutput`](crate::output::DeleteServerCertificateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteServerCertificateOutput`](crate::output::DeleteServerCertificateOutput)
        pub fn build(self) -> crate::output::DeleteServerCertificateOutput {
            crate::output::DeleteServerCertificateOutput {}
        }
    }
}
impl DeleteServerCertificateOutput {
    /// Creates a new builder-style object to manufacture [`DeleteServerCertificateOutput`](crate::output::DeleteServerCertificateOutput)
    pub fn builder() -> crate::output::delete_server_certificate_output::Builder {
        crate::output::delete_server_certificate_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSamlProviderOutput {}
impl std::fmt::Debug for DeleteSamlProviderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSamlProviderOutput");
        formatter.finish()
    }
}
/// See [`DeleteSamlProviderOutput`](crate::output::DeleteSamlProviderOutput)
pub mod delete_saml_provider_output {
    /// A builder for [`DeleteSamlProviderOutput`](crate::output::DeleteSamlProviderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteSamlProviderOutput`](crate::output::DeleteSamlProviderOutput)
        pub fn build(self) -> crate::output::DeleteSamlProviderOutput {
            crate::output::DeleteSamlProviderOutput {}
        }
    }
}
impl DeleteSamlProviderOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSamlProviderOutput`](crate::output::DeleteSamlProviderOutput)
    pub fn builder() -> crate::output::delete_saml_provider_output::Builder {
        crate::output::delete_saml_provider_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRolePolicyOutput {}
impl std::fmt::Debug for DeleteRolePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRolePolicyOutput");
        formatter.finish()
    }
}
/// See [`DeleteRolePolicyOutput`](crate::output::DeleteRolePolicyOutput)
pub mod delete_role_policy_output {
    /// A builder for [`DeleteRolePolicyOutput`](crate::output::DeleteRolePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteRolePolicyOutput`](crate::output::DeleteRolePolicyOutput)
        pub fn build(self) -> crate::output::DeleteRolePolicyOutput {
            crate::output::DeleteRolePolicyOutput {}
        }
    }
}
impl DeleteRolePolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRolePolicyOutput`](crate::output::DeleteRolePolicyOutput)
    pub fn builder() -> crate::output::delete_role_policy_output::Builder {
        crate::output::delete_role_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRolePermissionsBoundaryOutput {}
impl std::fmt::Debug for DeleteRolePermissionsBoundaryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRolePermissionsBoundaryOutput");
        formatter.finish()
    }
}
/// See [`DeleteRolePermissionsBoundaryOutput`](crate::output::DeleteRolePermissionsBoundaryOutput)
pub mod delete_role_permissions_boundary_output {
    /// A builder for [`DeleteRolePermissionsBoundaryOutput`](crate::output::DeleteRolePermissionsBoundaryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteRolePermissionsBoundaryOutput`](crate::output::DeleteRolePermissionsBoundaryOutput)
        pub fn build(self) -> crate::output::DeleteRolePermissionsBoundaryOutput {
            crate::output::DeleteRolePermissionsBoundaryOutput {}
        }
    }
}
impl DeleteRolePermissionsBoundaryOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRolePermissionsBoundaryOutput`](crate::output::DeleteRolePermissionsBoundaryOutput)
    pub fn builder() -> crate::output::delete_role_permissions_boundary_output::Builder {
        crate::output::delete_role_permissions_boundary_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRoleOutput {}
impl std::fmt::Debug for DeleteRoleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRoleOutput");
        formatter.finish()
    }
}
/// See [`DeleteRoleOutput`](crate::output::DeleteRoleOutput)
pub mod delete_role_output {
    /// A builder for [`DeleteRoleOutput`](crate::output::DeleteRoleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteRoleOutput`](crate::output::DeleteRoleOutput)
        pub fn build(self) -> crate::output::DeleteRoleOutput {
            crate::output::DeleteRoleOutput {}
        }
    }
}
impl DeleteRoleOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRoleOutput`](crate::output::DeleteRoleOutput)
    pub fn builder() -> crate::output::delete_role_output::Builder {
        crate::output::delete_role_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePolicyVersionOutput {}
impl std::fmt::Debug for DeletePolicyVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePolicyVersionOutput");
        formatter.finish()
    }
}
/// See [`DeletePolicyVersionOutput`](crate::output::DeletePolicyVersionOutput)
pub mod delete_policy_version_output {
    /// A builder for [`DeletePolicyVersionOutput`](crate::output::DeletePolicyVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeletePolicyVersionOutput`](crate::output::DeletePolicyVersionOutput)
        pub fn build(self) -> crate::output::DeletePolicyVersionOutput {
            crate::output::DeletePolicyVersionOutput {}
        }
    }
}
impl DeletePolicyVersionOutput {
    /// Creates a new builder-style object to manufacture [`DeletePolicyVersionOutput`](crate::output::DeletePolicyVersionOutput)
    pub fn builder() -> crate::output::delete_policy_version_output::Builder {
        crate::output::delete_policy_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePolicyOutput {}
impl std::fmt::Debug for DeletePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePolicyOutput");
        formatter.finish()
    }
}
/// See [`DeletePolicyOutput`](crate::output::DeletePolicyOutput)
pub mod delete_policy_output {
    /// A builder for [`DeletePolicyOutput`](crate::output::DeletePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeletePolicyOutput`](crate::output::DeletePolicyOutput)
        pub fn build(self) -> crate::output::DeletePolicyOutput {
            crate::output::DeletePolicyOutput {}
        }
    }
}
impl DeletePolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeletePolicyOutput`](crate::output::DeletePolicyOutput)
    pub fn builder() -> crate::output::delete_policy_output::Builder {
        crate::output::delete_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteOpenIdConnectProviderOutput {}
impl std::fmt::Debug for DeleteOpenIdConnectProviderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteOpenIdConnectProviderOutput");
        formatter.finish()
    }
}
/// See [`DeleteOpenIdConnectProviderOutput`](crate::output::DeleteOpenIdConnectProviderOutput)
pub mod delete_open_id_connect_provider_output {
    /// A builder for [`DeleteOpenIdConnectProviderOutput`](crate::output::DeleteOpenIdConnectProviderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteOpenIdConnectProviderOutput`](crate::output::DeleteOpenIdConnectProviderOutput)
        pub fn build(self) -> crate::output::DeleteOpenIdConnectProviderOutput {
            crate::output::DeleteOpenIdConnectProviderOutput {}
        }
    }
}
impl DeleteOpenIdConnectProviderOutput {
    /// Creates a new builder-style object to manufacture [`DeleteOpenIdConnectProviderOutput`](crate::output::DeleteOpenIdConnectProviderOutput)
    pub fn builder() -> crate::output::delete_open_id_connect_provider_output::Builder {
        crate::output::delete_open_id_connect_provider_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLoginProfileOutput {}
impl std::fmt::Debug for DeleteLoginProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLoginProfileOutput");
        formatter.finish()
    }
}
/// See [`DeleteLoginProfileOutput`](crate::output::DeleteLoginProfileOutput)
pub mod delete_login_profile_output {
    /// A builder for [`DeleteLoginProfileOutput`](crate::output::DeleteLoginProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteLoginProfileOutput`](crate::output::DeleteLoginProfileOutput)
        pub fn build(self) -> crate::output::DeleteLoginProfileOutput {
            crate::output::DeleteLoginProfileOutput {}
        }
    }
}
impl DeleteLoginProfileOutput {
    /// Creates a new builder-style object to manufacture [`DeleteLoginProfileOutput`](crate::output::DeleteLoginProfileOutput)
    pub fn builder() -> crate::output::delete_login_profile_output::Builder {
        crate::output::delete_login_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteInstanceProfileOutput {}
impl std::fmt::Debug for DeleteInstanceProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteInstanceProfileOutput");
        formatter.finish()
    }
}
/// See [`DeleteInstanceProfileOutput`](crate::output::DeleteInstanceProfileOutput)
pub mod delete_instance_profile_output {
    /// A builder for [`DeleteInstanceProfileOutput`](crate::output::DeleteInstanceProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteInstanceProfileOutput`](crate::output::DeleteInstanceProfileOutput)
        pub fn build(self) -> crate::output::DeleteInstanceProfileOutput {
            crate::output::DeleteInstanceProfileOutput {}
        }
    }
}
impl DeleteInstanceProfileOutput {
    /// Creates a new builder-style object to manufacture [`DeleteInstanceProfileOutput`](crate::output::DeleteInstanceProfileOutput)
    pub fn builder() -> crate::output::delete_instance_profile_output::Builder {
        crate::output::delete_instance_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGroupPolicyOutput {}
impl std::fmt::Debug for DeleteGroupPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGroupPolicyOutput");
        formatter.finish()
    }
}
/// See [`DeleteGroupPolicyOutput`](crate::output::DeleteGroupPolicyOutput)
pub mod delete_group_policy_output {
    /// A builder for [`DeleteGroupPolicyOutput`](crate::output::DeleteGroupPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteGroupPolicyOutput`](crate::output::DeleteGroupPolicyOutput)
        pub fn build(self) -> crate::output::DeleteGroupPolicyOutput {
            crate::output::DeleteGroupPolicyOutput {}
        }
    }
}
impl DeleteGroupPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteGroupPolicyOutput`](crate::output::DeleteGroupPolicyOutput)
    pub fn builder() -> crate::output::delete_group_policy_output::Builder {
        crate::output::delete_group_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGroupOutput {}
impl std::fmt::Debug for DeleteGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGroupOutput");
        formatter.finish()
    }
}
/// See [`DeleteGroupOutput`](crate::output::DeleteGroupOutput)
pub mod delete_group_output {
    /// A builder for [`DeleteGroupOutput`](crate::output::DeleteGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteGroupOutput`](crate::output::DeleteGroupOutput)
        pub fn build(self) -> crate::output::DeleteGroupOutput {
            crate::output::DeleteGroupOutput {}
        }
    }
}
impl DeleteGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteGroupOutput`](crate::output::DeleteGroupOutput)
    pub fn builder() -> crate::output::delete_group_output::Builder {
        crate::output::delete_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAccountPasswordPolicyOutput {}
impl std::fmt::Debug for DeleteAccountPasswordPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAccountPasswordPolicyOutput");
        formatter.finish()
    }
}
/// See [`DeleteAccountPasswordPolicyOutput`](crate::output::DeleteAccountPasswordPolicyOutput)
pub mod delete_account_password_policy_output {
    /// A builder for [`DeleteAccountPasswordPolicyOutput`](crate::output::DeleteAccountPasswordPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAccountPasswordPolicyOutput`](crate::output::DeleteAccountPasswordPolicyOutput)
        pub fn build(self) -> crate::output::DeleteAccountPasswordPolicyOutput {
            crate::output::DeleteAccountPasswordPolicyOutput {}
        }
    }
}
impl DeleteAccountPasswordPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAccountPasswordPolicyOutput`](crate::output::DeleteAccountPasswordPolicyOutput)
    pub fn builder() -> crate::output::delete_account_password_policy_output::Builder {
        crate::output::delete_account_password_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAccountAliasOutput {}
impl std::fmt::Debug for DeleteAccountAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAccountAliasOutput");
        formatter.finish()
    }
}
/// See [`DeleteAccountAliasOutput`](crate::output::DeleteAccountAliasOutput)
pub mod delete_account_alias_output {
    /// A builder for [`DeleteAccountAliasOutput`](crate::output::DeleteAccountAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAccountAliasOutput`](crate::output::DeleteAccountAliasOutput)
        pub fn build(self) -> crate::output::DeleteAccountAliasOutput {
            crate::output::DeleteAccountAliasOutput {}
        }
    }
}
impl DeleteAccountAliasOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAccountAliasOutput`](crate::output::DeleteAccountAliasOutput)
    pub fn builder() -> crate::output::delete_account_alias_output::Builder {
        crate::output::delete_account_alias_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAccessKeyOutput {}
impl std::fmt::Debug for DeleteAccessKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAccessKeyOutput");
        formatter.finish()
    }
}
/// See [`DeleteAccessKeyOutput`](crate::output::DeleteAccessKeyOutput)
pub mod delete_access_key_output {
    /// A builder for [`DeleteAccessKeyOutput`](crate::output::DeleteAccessKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAccessKeyOutput`](crate::output::DeleteAccessKeyOutput)
        pub fn build(self) -> crate::output::DeleteAccessKeyOutput {
            crate::output::DeleteAccessKeyOutput {}
        }
    }
}
impl DeleteAccessKeyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAccessKeyOutput`](crate::output::DeleteAccessKeyOutput)
    pub fn builder() -> crate::output::delete_access_key_output::Builder {
        crate::output::delete_access_key_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeactivateMfaDeviceOutput {}
impl std::fmt::Debug for DeactivateMfaDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeactivateMfaDeviceOutput");
        formatter.finish()
    }
}
/// See [`DeactivateMfaDeviceOutput`](crate::output::DeactivateMfaDeviceOutput)
pub mod deactivate_mfa_device_output {
    /// A builder for [`DeactivateMfaDeviceOutput`](crate::output::DeactivateMfaDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeactivateMfaDeviceOutput`](crate::output::DeactivateMfaDeviceOutput)
        pub fn build(self) -> crate::output::DeactivateMfaDeviceOutput {
            crate::output::DeactivateMfaDeviceOutput {}
        }
    }
}
impl DeactivateMfaDeviceOutput {
    /// Creates a new builder-style object to manufacture [`DeactivateMfaDeviceOutput`](crate::output::DeactivateMfaDeviceOutput)
    pub fn builder() -> crate::output::deactivate_mfa_device_output::Builder {
        crate::output::deactivate_mfa_device_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>CreateVirtualMFADevice</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateVirtualMfaDeviceOutput {
    /// <p>A structure containing details about the new virtual MFA device.</p>
    pub virtual_mfa_device: std::option::Option<crate::model::VirtualMfaDevice>,
}
impl CreateVirtualMfaDeviceOutput {
    /// <p>A structure containing details about the new virtual MFA device.</p>
    pub fn virtual_mfa_device(&self) -> std::option::Option<&crate::model::VirtualMfaDevice> {
        self.virtual_mfa_device.as_ref()
    }
}
impl std::fmt::Debug for CreateVirtualMfaDeviceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateVirtualMfaDeviceOutput");
        formatter.field("virtual_mfa_device", &self.virtual_mfa_device);
        formatter.finish()
    }
}
/// See [`CreateVirtualMfaDeviceOutput`](crate::output::CreateVirtualMfaDeviceOutput)
pub mod create_virtual_mfa_device_output {
    /// A builder for [`CreateVirtualMfaDeviceOutput`](crate::output::CreateVirtualMfaDeviceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_mfa_device: std::option::Option<crate::model::VirtualMfaDevice>,
    }
    impl Builder {
        /// <p>A structure containing details about the new virtual MFA device.</p>
        pub fn virtual_mfa_device(mut self, input: crate::model::VirtualMfaDevice) -> Self {
            self.virtual_mfa_device = Some(input);
            self
        }
        /// <p>A structure containing details about the new virtual MFA device.</p>
        pub fn set_virtual_mfa_device(
            mut self,
            input: std::option::Option<crate::model::VirtualMfaDevice>,
        ) -> Self {
            self.virtual_mfa_device = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVirtualMfaDeviceOutput`](crate::output::CreateVirtualMfaDeviceOutput)
        pub fn build(self) -> crate::output::CreateVirtualMfaDeviceOutput {
            crate::output::CreateVirtualMfaDeviceOutput {
                virtual_mfa_device: self.virtual_mfa_device,
            }
        }
    }
}
impl CreateVirtualMfaDeviceOutput {
    /// Creates a new builder-style object to manufacture [`CreateVirtualMfaDeviceOutput`](crate::output::CreateVirtualMfaDeviceOutput)
    pub fn builder() -> crate::output::create_virtual_mfa_device_output::Builder {
        crate::output::create_virtual_mfa_device_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>CreateUser</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUserOutput {
    /// <p>A structure with details about the new IAM user.</p>
    pub user: std::option::Option<crate::model::User>,
}
impl CreateUserOutput {
    /// <p>A structure with details about the new IAM user.</p>
    pub fn user(&self) -> std::option::Option<&crate::model::User> {
        self.user.as_ref()
    }
}
impl std::fmt::Debug for CreateUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUserOutput");
        formatter.field("user", &self.user);
        formatter.finish()
    }
}
/// See [`CreateUserOutput`](crate::output::CreateUserOutput)
pub mod create_user_output {
    /// A builder for [`CreateUserOutput`](crate::output::CreateUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user: std::option::Option<crate::model::User>,
    }
    impl Builder {
        /// <p>A structure with details about the new IAM user.</p>
        pub fn user(mut self, input: crate::model::User) -> Self {
            self.user = Some(input);
            self
        }
        /// <p>A structure with details about the new IAM user.</p>
        pub fn set_user(mut self, input: std::option::Option<crate::model::User>) -> Self {
            self.user = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserOutput`](crate::output::CreateUserOutput)
        pub fn build(self) -> crate::output::CreateUserOutput {
            crate::output::CreateUserOutput { user: self.user }
        }
    }
}
impl CreateUserOutput {
    /// Creates a new builder-style object to manufacture [`CreateUserOutput`](crate::output::CreateUserOutput)
    pub fn builder() -> crate::output::create_user_output::Builder {
        crate::output::create_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateServiceSpecificCredentialOutput {
    /// <p>A structure that contains information about the newly created service-specific credential.</p> <important>
    /// <p>This is the only time that the password for this credential set is available. It cannot be recovered later. Instead, you must reset the password with <code>ResetServiceSpecificCredential</code>.</p>
    /// </important>
    pub service_specific_credential: std::option::Option<crate::model::ServiceSpecificCredential>,
}
impl CreateServiceSpecificCredentialOutput {
    /// <p>A structure that contains information about the newly created service-specific credential.</p> <important>
    /// <p>This is the only time that the password for this credential set is available. It cannot be recovered later. Instead, you must reset the password with <code>ResetServiceSpecificCredential</code>.</p>
    /// </important>
    pub fn service_specific_credential(
        &self,
    ) -> std::option::Option<&crate::model::ServiceSpecificCredential> {
        self.service_specific_credential.as_ref()
    }
}
impl std::fmt::Debug for CreateServiceSpecificCredentialOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateServiceSpecificCredentialOutput");
        formatter.field(
            "service_specific_credential",
            &self.service_specific_credential,
        );
        formatter.finish()
    }
}
/// See [`CreateServiceSpecificCredentialOutput`](crate::output::CreateServiceSpecificCredentialOutput)
pub mod create_service_specific_credential_output {
    /// A builder for [`CreateServiceSpecificCredentialOutput`](crate::output::CreateServiceSpecificCredentialOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_specific_credential:
            std::option::Option<crate::model::ServiceSpecificCredential>,
    }
    impl Builder {
        /// <p>A structure that contains information about the newly created service-specific credential.</p> <important>
        /// <p>This is the only time that the password for this credential set is available. It cannot be recovered later. Instead, you must reset the password with <code>ResetServiceSpecificCredential</code>.</p>
        /// </important>
        pub fn service_specific_credential(
            mut self,
            input: crate::model::ServiceSpecificCredential,
        ) -> Self {
            self.service_specific_credential = Some(input);
            self
        }
        /// <p>A structure that contains information about the newly created service-specific credential.</p> <important>
        /// <p>This is the only time that the password for this credential set is available. It cannot be recovered later. Instead, you must reset the password with <code>ResetServiceSpecificCredential</code>.</p>
        /// </important>
        pub fn set_service_specific_credential(
            mut self,
            input: std::option::Option<crate::model::ServiceSpecificCredential>,
        ) -> Self {
            self.service_specific_credential = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateServiceSpecificCredentialOutput`](crate::output::CreateServiceSpecificCredentialOutput)
        pub fn build(self) -> crate::output::CreateServiceSpecificCredentialOutput {
            crate::output::CreateServiceSpecificCredentialOutput {
                service_specific_credential: self.service_specific_credential,
            }
        }
    }
}
impl CreateServiceSpecificCredentialOutput {
    /// Creates a new builder-style object to manufacture [`CreateServiceSpecificCredentialOutput`](crate::output::CreateServiceSpecificCredentialOutput)
    pub fn builder() -> crate::output::create_service_specific_credential_output::Builder {
        crate::output::create_service_specific_credential_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateServiceLinkedRoleOutput {
    /// <p>A <code>Role</code> object that contains details about the newly created role.</p>
    pub role: std::option::Option<crate::model::Role>,
}
impl CreateServiceLinkedRoleOutput {
    /// <p>A <code>Role</code> object that contains details about the newly created role.</p>
    pub fn role(&self) -> std::option::Option<&crate::model::Role> {
        self.role.as_ref()
    }
}
impl std::fmt::Debug for CreateServiceLinkedRoleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateServiceLinkedRoleOutput");
        formatter.field("role", &self.role);
        formatter.finish()
    }
}
/// See [`CreateServiceLinkedRoleOutput`](crate::output::CreateServiceLinkedRoleOutput)
pub mod create_service_linked_role_output {
    /// A builder for [`CreateServiceLinkedRoleOutput`](crate::output::CreateServiceLinkedRoleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role: std::option::Option<crate::model::Role>,
    }
    impl Builder {
        /// <p>A <code>Role</code> object that contains details about the newly created role.</p>
        pub fn role(mut self, input: crate::model::Role) -> Self {
            self.role = Some(input);
            self
        }
        /// <p>A <code>Role</code> object that contains details about the newly created role.</p>
        pub fn set_role(mut self, input: std::option::Option<crate::model::Role>) -> Self {
            self.role = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateServiceLinkedRoleOutput`](crate::output::CreateServiceLinkedRoleOutput)
        pub fn build(self) -> crate::output::CreateServiceLinkedRoleOutput {
            crate::output::CreateServiceLinkedRoleOutput { role: self.role }
        }
    }
}
impl CreateServiceLinkedRoleOutput {
    /// Creates a new builder-style object to manufacture [`CreateServiceLinkedRoleOutput`](crate::output::CreateServiceLinkedRoleOutput)
    pub fn builder() -> crate::output::create_service_linked_role_output::Builder {
        crate::output::create_service_linked_role_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>CreateSAMLProvider</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSamlProviderOutput {
    /// <p>The Amazon Resource Name (ARN) of the new SAML provider resource in IAM.</p>
    pub saml_provider_arn: std::option::Option<std::string::String>,
    /// <p>A list of tags that are attached to the new IAM SAML provider. The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateSamlProviderOutput {
    /// <p>The Amazon Resource Name (ARN) of the new SAML provider resource in IAM.</p>
    pub fn saml_provider_arn(&self) -> std::option::Option<&str> {
        self.saml_provider_arn.as_deref()
    }
    /// <p>A list of tags that are attached to the new IAM SAML provider. The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateSamlProviderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSamlProviderOutput");
        formatter.field("saml_provider_arn", &self.saml_provider_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreateSamlProviderOutput`](crate::output::CreateSamlProviderOutput)
pub mod create_saml_provider_output {
    /// A builder for [`CreateSamlProviderOutput`](crate::output::CreateSamlProviderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) saml_provider_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the new SAML provider resource in IAM.</p>
        pub fn saml_provider_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.saml_provider_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the new SAML provider resource in IAM.</p>
        pub fn set_saml_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.saml_provider_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that are attached to the new IAM SAML provider. The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags that are attached to the new IAM SAML provider. The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSamlProviderOutput`](crate::output::CreateSamlProviderOutput)
        pub fn build(self) -> crate::output::CreateSamlProviderOutput {
            crate::output::CreateSamlProviderOutput {
                saml_provider_arn: self.saml_provider_arn,
                tags: self.tags,
            }
        }
    }
}
impl CreateSamlProviderOutput {
    /// Creates a new builder-style object to manufacture [`CreateSamlProviderOutput`](crate::output::CreateSamlProviderOutput)
    pub fn builder() -> crate::output::create_saml_provider_output::Builder {
        crate::output::create_saml_provider_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>CreateRole</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRoleOutput {
    /// <p>A structure containing details about the new role.</p>
    pub role: std::option::Option<crate::model::Role>,
}
impl CreateRoleOutput {
    /// <p>A structure containing details about the new role.</p>
    pub fn role(&self) -> std::option::Option<&crate::model::Role> {
        self.role.as_ref()
    }
}
impl std::fmt::Debug for CreateRoleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRoleOutput");
        formatter.field("role", &self.role);
        formatter.finish()
    }
}
/// See [`CreateRoleOutput`](crate::output::CreateRoleOutput)
pub mod create_role_output {
    /// A builder for [`CreateRoleOutput`](crate::output::CreateRoleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role: std::option::Option<crate::model::Role>,
    }
    impl Builder {
        /// <p>A structure containing details about the new role.</p>
        pub fn role(mut self, input: crate::model::Role) -> Self {
            self.role = Some(input);
            self
        }
        /// <p>A structure containing details about the new role.</p>
        pub fn set_role(mut self, input: std::option::Option<crate::model::Role>) -> Self {
            self.role = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRoleOutput`](crate::output::CreateRoleOutput)
        pub fn build(self) -> crate::output::CreateRoleOutput {
            crate::output::CreateRoleOutput { role: self.role }
        }
    }
}
impl CreateRoleOutput {
    /// Creates a new builder-style object to manufacture [`CreateRoleOutput`](crate::output::CreateRoleOutput)
    pub fn builder() -> crate::output::create_role_output::Builder {
        crate::output::create_role_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>CreatePolicyVersion</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePolicyVersionOutput {
    /// <p>A structure containing details about the new policy version.</p>
    pub policy_version: std::option::Option<crate::model::PolicyVersion>,
}
impl CreatePolicyVersionOutput {
    /// <p>A structure containing details about the new policy version.</p>
    pub fn policy_version(&self) -> std::option::Option<&crate::model::PolicyVersion> {
        self.policy_version.as_ref()
    }
}
impl std::fmt::Debug for CreatePolicyVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePolicyVersionOutput");
        formatter.field("policy_version", &self.policy_version);
        formatter.finish()
    }
}
/// See [`CreatePolicyVersionOutput`](crate::output::CreatePolicyVersionOutput)
pub mod create_policy_version_output {
    /// A builder for [`CreatePolicyVersionOutput`](crate::output::CreatePolicyVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_version: std::option::Option<crate::model::PolicyVersion>,
    }
    impl Builder {
        /// <p>A structure containing details about the new policy version.</p>
        pub fn policy_version(mut self, input: crate::model::PolicyVersion) -> Self {
            self.policy_version = Some(input);
            self
        }
        /// <p>A structure containing details about the new policy version.</p>
        pub fn set_policy_version(
            mut self,
            input: std::option::Option<crate::model::PolicyVersion>,
        ) -> Self {
            self.policy_version = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePolicyVersionOutput`](crate::output::CreatePolicyVersionOutput)
        pub fn build(self) -> crate::output::CreatePolicyVersionOutput {
            crate::output::CreatePolicyVersionOutput {
                policy_version: self.policy_version,
            }
        }
    }
}
impl CreatePolicyVersionOutput {
    /// Creates a new builder-style object to manufacture [`CreatePolicyVersionOutput`](crate::output::CreatePolicyVersionOutput)
    pub fn builder() -> crate::output::create_policy_version_output::Builder {
        crate::output::create_policy_version_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>CreatePolicy</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePolicyOutput {
    /// <p>A structure containing details about the new policy.</p>
    pub policy: std::option::Option<crate::model::Policy>,
}
impl CreatePolicyOutput {
    /// <p>A structure containing details about the new policy.</p>
    pub fn policy(&self) -> std::option::Option<&crate::model::Policy> {
        self.policy.as_ref()
    }
}
impl std::fmt::Debug for CreatePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`CreatePolicyOutput`](crate::output::CreatePolicyOutput)
pub mod create_policy_output {
    /// A builder for [`CreatePolicyOutput`](crate::output::CreatePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<crate::model::Policy>,
    }
    impl Builder {
        /// <p>A structure containing details about the new policy.</p>
        pub fn policy(mut self, input: crate::model::Policy) -> Self {
            self.policy = Some(input);
            self
        }
        /// <p>A structure containing details about the new policy.</p>
        pub fn set_policy(mut self, input: std::option::Option<crate::model::Policy>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePolicyOutput`](crate::output::CreatePolicyOutput)
        pub fn build(self) -> crate::output::CreatePolicyOutput {
            crate::output::CreatePolicyOutput {
                policy: self.policy,
            }
        }
    }
}
impl CreatePolicyOutput {
    /// Creates a new builder-style object to manufacture [`CreatePolicyOutput`](crate::output::CreatePolicyOutput)
    pub fn builder() -> crate::output::create_policy_output::Builder {
        crate::output::create_policy_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>CreateOpenIDConnectProvider</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateOpenIdConnectProviderOutput {
    /// <p>The Amazon Resource Name (ARN) of the new IAM OpenID Connect provider that is created. For more information, see <code>OpenIDConnectProviderListEntry</code>. </p>
    pub open_id_connect_provider_arn: std::option::Option<std::string::String>,
    /// <p>A list of tags that are attached to the new IAM OIDC provider. The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateOpenIdConnectProviderOutput {
    /// <p>The Amazon Resource Name (ARN) of the new IAM OpenID Connect provider that is created. For more information, see <code>OpenIDConnectProviderListEntry</code>. </p>
    pub fn open_id_connect_provider_arn(&self) -> std::option::Option<&str> {
        self.open_id_connect_provider_arn.as_deref()
    }
    /// <p>A list of tags that are attached to the new IAM OIDC provider. The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateOpenIdConnectProviderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateOpenIdConnectProviderOutput");
        formatter.field(
            "open_id_connect_provider_arn",
            &self.open_id_connect_provider_arn,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreateOpenIdConnectProviderOutput`](crate::output::CreateOpenIdConnectProviderOutput)
pub mod create_open_id_connect_provider_output {
    /// A builder for [`CreateOpenIdConnectProviderOutput`](crate::output::CreateOpenIdConnectProviderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) open_id_connect_provider_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the new IAM OpenID Connect provider that is created. For more information, see <code>OpenIDConnectProviderListEntry</code>. </p>
        pub fn open_id_connect_provider_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.open_id_connect_provider_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the new IAM OpenID Connect provider that is created. For more information, see <code>OpenIDConnectProviderListEntry</code>. </p>
        pub fn set_open_id_connect_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.open_id_connect_provider_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that are attached to the new IAM OIDC provider. The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags that are attached to the new IAM OIDC provider. The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <i>IAM User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateOpenIdConnectProviderOutput`](crate::output::CreateOpenIdConnectProviderOutput)
        pub fn build(self) -> crate::output::CreateOpenIdConnectProviderOutput {
            crate::output::CreateOpenIdConnectProviderOutput {
                open_id_connect_provider_arn: self.open_id_connect_provider_arn,
                tags: self.tags,
            }
        }
    }
}
impl CreateOpenIdConnectProviderOutput {
    /// Creates a new builder-style object to manufacture [`CreateOpenIdConnectProviderOutput`](crate::output::CreateOpenIdConnectProviderOutput)
    pub fn builder() -> crate::output::create_open_id_connect_provider_output::Builder {
        crate::output::create_open_id_connect_provider_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>CreateLoginProfile</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLoginProfileOutput {
    /// <p>A structure containing the user name and password create date.</p>
    pub login_profile: std::option::Option<crate::model::LoginProfile>,
}
impl CreateLoginProfileOutput {
    /// <p>A structure containing the user name and password create date.</p>
    pub fn login_profile(&self) -> std::option::Option<&crate::model::LoginProfile> {
        self.login_profile.as_ref()
    }
}
impl std::fmt::Debug for CreateLoginProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLoginProfileOutput");
        formatter.field("login_profile", &self.login_profile);
        formatter.finish()
    }
}
/// See [`CreateLoginProfileOutput`](crate::output::CreateLoginProfileOutput)
pub mod create_login_profile_output {
    /// A builder for [`CreateLoginProfileOutput`](crate::output::CreateLoginProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) login_profile: std::option::Option<crate::model::LoginProfile>,
    }
    impl Builder {
        /// <p>A structure containing the user name and password create date.</p>
        pub fn login_profile(mut self, input: crate::model::LoginProfile) -> Self {
            self.login_profile = Some(input);
            self
        }
        /// <p>A structure containing the user name and password create date.</p>
        pub fn set_login_profile(
            mut self,
            input: std::option::Option<crate::model::LoginProfile>,
        ) -> Self {
            self.login_profile = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLoginProfileOutput`](crate::output::CreateLoginProfileOutput)
        pub fn build(self) -> crate::output::CreateLoginProfileOutput {
            crate::output::CreateLoginProfileOutput {
                login_profile: self.login_profile,
            }
        }
    }
}
impl CreateLoginProfileOutput {
    /// Creates a new builder-style object to manufacture [`CreateLoginProfileOutput`](crate::output::CreateLoginProfileOutput)
    pub fn builder() -> crate::output::create_login_profile_output::Builder {
        crate::output::create_login_profile_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>CreateInstanceProfile</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateInstanceProfileOutput {
    /// <p>A structure containing details about the new instance profile.</p>
    pub instance_profile: std::option::Option<crate::model::InstanceProfile>,
}
impl CreateInstanceProfileOutput {
    /// <p>A structure containing details about the new instance profile.</p>
    pub fn instance_profile(&self) -> std::option::Option<&crate::model::InstanceProfile> {
        self.instance_profile.as_ref()
    }
}
impl std::fmt::Debug for CreateInstanceProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateInstanceProfileOutput");
        formatter.field("instance_profile", &self.instance_profile);
        formatter.finish()
    }
}
/// See [`CreateInstanceProfileOutput`](crate::output::CreateInstanceProfileOutput)
pub mod create_instance_profile_output {
    /// A builder for [`CreateInstanceProfileOutput`](crate::output::CreateInstanceProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_profile: std::option::Option<crate::model::InstanceProfile>,
    }
    impl Builder {
        /// <p>A structure containing details about the new instance profile.</p>
        pub fn instance_profile(mut self, input: crate::model::InstanceProfile) -> Self {
            self.instance_profile = Some(input);
            self
        }
        /// <p>A structure containing details about the new instance profile.</p>
        pub fn set_instance_profile(
            mut self,
            input: std::option::Option<crate::model::InstanceProfile>,
        ) -> Self {
            self.instance_profile = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateInstanceProfileOutput`](crate::output::CreateInstanceProfileOutput)
        pub fn build(self) -> crate::output::CreateInstanceProfileOutput {
            crate::output::CreateInstanceProfileOutput {
                instance_profile: self.instance_profile,
            }
        }
    }
}
impl CreateInstanceProfileOutput {
    /// Creates a new builder-style object to manufacture [`CreateInstanceProfileOutput`](crate::output::CreateInstanceProfileOutput)
    pub fn builder() -> crate::output::create_instance_profile_output::Builder {
        crate::output::create_instance_profile_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>CreateGroup</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGroupOutput {
    /// <p>A structure containing details about the new group.</p>
    pub group: std::option::Option<crate::model::Group>,
}
impl CreateGroupOutput {
    /// <p>A structure containing details about the new group.</p>
    pub fn group(&self) -> std::option::Option<&crate::model::Group> {
        self.group.as_ref()
    }
}
impl std::fmt::Debug for CreateGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGroupOutput");
        formatter.field("group", &self.group);
        formatter.finish()
    }
}
/// See [`CreateGroupOutput`](crate::output::CreateGroupOutput)
pub mod create_group_output {
    /// A builder for [`CreateGroupOutput`](crate::output::CreateGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group: std::option::Option<crate::model::Group>,
    }
    impl Builder {
        /// <p>A structure containing details about the new group.</p>
        pub fn group(mut self, input: crate::model::Group) -> Self {
            self.group = Some(input);
            self
        }
        /// <p>A structure containing details about the new group.</p>
        pub fn set_group(mut self, input: std::option::Option<crate::model::Group>) -> Self {
            self.group = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGroupOutput`](crate::output::CreateGroupOutput)
        pub fn build(self) -> crate::output::CreateGroupOutput {
            crate::output::CreateGroupOutput { group: self.group }
        }
    }
}
impl CreateGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateGroupOutput`](crate::output::CreateGroupOutput)
    pub fn builder() -> crate::output::create_group_output::Builder {
        crate::output::create_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAccountAliasOutput {}
impl std::fmt::Debug for CreateAccountAliasOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAccountAliasOutput");
        formatter.finish()
    }
}
/// See [`CreateAccountAliasOutput`](crate::output::CreateAccountAliasOutput)
pub mod create_account_alias_output {
    /// A builder for [`CreateAccountAliasOutput`](crate::output::CreateAccountAliasOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateAccountAliasOutput`](crate::output::CreateAccountAliasOutput)
        pub fn build(self) -> crate::output::CreateAccountAliasOutput {
            crate::output::CreateAccountAliasOutput {}
        }
    }
}
impl CreateAccountAliasOutput {
    /// Creates a new builder-style object to manufacture [`CreateAccountAliasOutput`](crate::output::CreateAccountAliasOutput)
    pub fn builder() -> crate::output::create_account_alias_output::Builder {
        crate::output::create_account_alias_output::Builder::default()
    }
}

/// <p>Contains the response to a successful <code>CreateAccessKey</code> request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAccessKeyOutput {
    /// <p>A structure with details about the access key.</p>
    pub access_key: std::option::Option<crate::model::AccessKey>,
}
impl CreateAccessKeyOutput {
    /// <p>A structure with details about the access key.</p>
    pub fn access_key(&self) -> std::option::Option<&crate::model::AccessKey> {
        self.access_key.as_ref()
    }
}
impl std::fmt::Debug for CreateAccessKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAccessKeyOutput");
        formatter.field("access_key", &self.access_key);
        formatter.finish()
    }
}
/// See [`CreateAccessKeyOutput`](crate::output::CreateAccessKeyOutput)
pub mod create_access_key_output {
    /// A builder for [`CreateAccessKeyOutput`](crate::output::CreateAccessKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_key: std::option::Option<crate::model::AccessKey>,
    }
    impl Builder {
        /// <p>A structure with details about the access key.</p>
        pub fn access_key(mut self, input: crate::model::AccessKey) -> Self {
            self.access_key = Some(input);
            self
        }
        /// <p>A structure with details about the access key.</p>
        pub fn set_access_key(
            mut self,
            input: std::option::Option<crate::model::AccessKey>,
        ) -> Self {
            self.access_key = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAccessKeyOutput`](crate::output::CreateAccessKeyOutput)
        pub fn build(self) -> crate::output::CreateAccessKeyOutput {
            crate::output::CreateAccessKeyOutput {
                access_key: self.access_key,
            }
        }
    }
}
impl CreateAccessKeyOutput {
    /// Creates a new builder-style object to manufacture [`CreateAccessKeyOutput`](crate::output::CreateAccessKeyOutput)
    pub fn builder() -> crate::output::create_access_key_output::Builder {
        crate::output::create_access_key_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChangePasswordOutput {}
impl std::fmt::Debug for ChangePasswordOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChangePasswordOutput");
        formatter.finish()
    }
}
/// See [`ChangePasswordOutput`](crate::output::ChangePasswordOutput)
pub mod change_password_output {
    /// A builder for [`ChangePasswordOutput`](crate::output::ChangePasswordOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ChangePasswordOutput`](crate::output::ChangePasswordOutput)
        pub fn build(self) -> crate::output::ChangePasswordOutput {
            crate::output::ChangePasswordOutput {}
        }
    }
}
impl ChangePasswordOutput {
    /// Creates a new builder-style object to manufacture [`ChangePasswordOutput`](crate::output::ChangePasswordOutput)
    pub fn builder() -> crate::output::change_password_output::Builder {
        crate::output::change_password_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachUserPolicyOutput {}
impl std::fmt::Debug for AttachUserPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachUserPolicyOutput");
        formatter.finish()
    }
}
/// See [`AttachUserPolicyOutput`](crate::output::AttachUserPolicyOutput)
pub mod attach_user_policy_output {
    /// A builder for [`AttachUserPolicyOutput`](crate::output::AttachUserPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AttachUserPolicyOutput`](crate::output::AttachUserPolicyOutput)
        pub fn build(self) -> crate::output::AttachUserPolicyOutput {
            crate::output::AttachUserPolicyOutput {}
        }
    }
}
impl AttachUserPolicyOutput {
    /// Creates a new builder-style object to manufacture [`AttachUserPolicyOutput`](crate::output::AttachUserPolicyOutput)
    pub fn builder() -> crate::output::attach_user_policy_output::Builder {
        crate::output::attach_user_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachRolePolicyOutput {}
impl std::fmt::Debug for AttachRolePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachRolePolicyOutput");
        formatter.finish()
    }
}
/// See [`AttachRolePolicyOutput`](crate::output::AttachRolePolicyOutput)
pub mod attach_role_policy_output {
    /// A builder for [`AttachRolePolicyOutput`](crate::output::AttachRolePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AttachRolePolicyOutput`](crate::output::AttachRolePolicyOutput)
        pub fn build(self) -> crate::output::AttachRolePolicyOutput {
            crate::output::AttachRolePolicyOutput {}
        }
    }
}
impl AttachRolePolicyOutput {
    /// Creates a new builder-style object to manufacture [`AttachRolePolicyOutput`](crate::output::AttachRolePolicyOutput)
    pub fn builder() -> crate::output::attach_role_policy_output::Builder {
        crate::output::attach_role_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachGroupPolicyOutput {}
impl std::fmt::Debug for AttachGroupPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachGroupPolicyOutput");
        formatter.finish()
    }
}
/// See [`AttachGroupPolicyOutput`](crate::output::AttachGroupPolicyOutput)
pub mod attach_group_policy_output {
    /// A builder for [`AttachGroupPolicyOutput`](crate::output::AttachGroupPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AttachGroupPolicyOutput`](crate::output::AttachGroupPolicyOutput)
        pub fn build(self) -> crate::output::AttachGroupPolicyOutput {
            crate::output::AttachGroupPolicyOutput {}
        }
    }
}
impl AttachGroupPolicyOutput {
    /// Creates a new builder-style object to manufacture [`AttachGroupPolicyOutput`](crate::output::AttachGroupPolicyOutput)
    pub fn builder() -> crate::output::attach_group_policy_output::Builder {
        crate::output::attach_group_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddUserToGroupOutput {}
impl std::fmt::Debug for AddUserToGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddUserToGroupOutput");
        formatter.finish()
    }
}
/// See [`AddUserToGroupOutput`](crate::output::AddUserToGroupOutput)
pub mod add_user_to_group_output {
    /// A builder for [`AddUserToGroupOutput`](crate::output::AddUserToGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AddUserToGroupOutput`](crate::output::AddUserToGroupOutput)
        pub fn build(self) -> crate::output::AddUserToGroupOutput {
            crate::output::AddUserToGroupOutput {}
        }
    }
}
impl AddUserToGroupOutput {
    /// Creates a new builder-style object to manufacture [`AddUserToGroupOutput`](crate::output::AddUserToGroupOutput)
    pub fn builder() -> crate::output::add_user_to_group_output::Builder {
        crate::output::add_user_to_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddRoleToInstanceProfileOutput {}
impl std::fmt::Debug for AddRoleToInstanceProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddRoleToInstanceProfileOutput");
        formatter.finish()
    }
}
/// See [`AddRoleToInstanceProfileOutput`](crate::output::AddRoleToInstanceProfileOutput)
pub mod add_role_to_instance_profile_output {
    /// A builder for [`AddRoleToInstanceProfileOutput`](crate::output::AddRoleToInstanceProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AddRoleToInstanceProfileOutput`](crate::output::AddRoleToInstanceProfileOutput)
        pub fn build(self) -> crate::output::AddRoleToInstanceProfileOutput {
            crate::output::AddRoleToInstanceProfileOutput {}
        }
    }
}
impl AddRoleToInstanceProfileOutput {
    /// Creates a new builder-style object to manufacture [`AddRoleToInstanceProfileOutput`](crate::output::AddRoleToInstanceProfileOutput)
    pub fn builder() -> crate::output::add_role_to_instance_profile_output::Builder {
        crate::output::add_role_to_instance_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddClientIdToOpenIdConnectProviderOutput {}
impl std::fmt::Debug for AddClientIdToOpenIdConnectProviderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddClientIdToOpenIdConnectProviderOutput");
        formatter.finish()
    }
}
/// See [`AddClientIdToOpenIdConnectProviderOutput`](crate::output::AddClientIdToOpenIdConnectProviderOutput)
pub mod add_client_id_to_open_id_connect_provider_output {
    /// A builder for [`AddClientIdToOpenIdConnectProviderOutput`](crate::output::AddClientIdToOpenIdConnectProviderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AddClientIdToOpenIdConnectProviderOutput`](crate::output::AddClientIdToOpenIdConnectProviderOutput)
        pub fn build(self) -> crate::output::AddClientIdToOpenIdConnectProviderOutput {
            crate::output::AddClientIdToOpenIdConnectProviderOutput {}
        }
    }
}
impl AddClientIdToOpenIdConnectProviderOutput {
    /// Creates a new builder-style object to manufacture [`AddClientIdToOpenIdConnectProviderOutput`](crate::output::AddClientIdToOpenIdConnectProviderOutput)
    pub fn builder() -> crate::output::add_client_id_to_open_id_connect_provider_output::Builder {
        crate::output::add_client_id_to_open_id_connect_provider_output::Builder::default()
    }
}
