// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_client_id_to_open_id_connect_provider_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AddClientIdToOpenIdConnectProviderOutput,
    crate::error::AddClientIDToOpenIDConnectProviderError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddClientIDToOpenIDConnectProviderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AddClientIDToOpenIDConnectProviderError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::AddClientIDToOpenIDConnectProviderError {
            meta: generic,
            kind: crate::error::AddClientIDToOpenIDConnectProviderErrorKind::InvalidInputException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_input_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AddClientIDToOpenIDConnectProviderError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "LimitExceeded" => crate::error::AddClientIDToOpenIDConnectProviderError {
            meta: generic,
            kind: crate::error::AddClientIDToOpenIDConnectProviderErrorKind::LimitExceededException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::limit_exceeded_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AddClientIDToOpenIDConnectProviderError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "NoSuchEntity" => crate::error::AddClientIDToOpenIDConnectProviderError {
            meta: generic,
            kind: crate::error::AddClientIDToOpenIDConnectProviderErrorKind::NoSuchEntityException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::no_such_entity_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AddClientIDToOpenIDConnectProviderError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ServiceFailure" => crate::error::AddClientIDToOpenIDConnectProviderError {
            meta: generic,
            kind:
                crate::error::AddClientIDToOpenIDConnectProviderErrorKind::ServiceFailureException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::service_failure_exception::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AddClientIDToOpenIDConnectProviderError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::AddClientIDToOpenIDConnectProviderError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_client_id_to_open_id_connect_provider_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AddClientIdToOpenIdConnectProviderOutput,
    crate::error::AddClientIDToOpenIDConnectProviderError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::add_client_id_to_open_id_connect_provider_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_role_to_instance_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AddRoleToInstanceProfileOutput,
    crate::error::AddRoleToInstanceProfileError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddRoleToInstanceProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AddRoleToInstanceProfileError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "EntityAlreadyExists" => crate::error::AddRoleToInstanceProfileError {
            meta: generic,
            kind: crate::error::AddRoleToInstanceProfileErrorKind::EntityAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_entity_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AddRoleToInstanceProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::AddRoleToInstanceProfileError {
            meta: generic,
            kind: crate::error::AddRoleToInstanceProfileErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AddRoleToInstanceProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::AddRoleToInstanceProfileError {
            meta: generic,
            kind: crate::error::AddRoleToInstanceProfileErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AddRoleToInstanceProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::AddRoleToInstanceProfileError {
            meta: generic,
            kind: crate::error::AddRoleToInstanceProfileErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AddRoleToInstanceProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnmodifiableEntity" => crate::error::AddRoleToInstanceProfileError {
            meta: generic,
            kind: crate::error::AddRoleToInstanceProfileErrorKind::UnmodifiableEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unmodifiable_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unmodifiable_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AddRoleToInstanceProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AddRoleToInstanceProfileError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_role_to_instance_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AddRoleToInstanceProfileOutput,
    crate::error::AddRoleToInstanceProfileError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::add_role_to_instance_profile_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_user_to_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddUserToGroupOutput, crate::error::AddUserToGroupError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddUserToGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AddUserToGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceeded" => crate::error::AddUserToGroupError {
            meta: generic,
            kind: crate::error::AddUserToGroupErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AddUserToGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::AddUserToGroupError {
            meta: generic,
            kind: crate::error::AddUserToGroupErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AddUserToGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::AddUserToGroupError {
            meta: generic,
            kind: crate::error::AddUserToGroupErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AddUserToGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AddUserToGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_user_to_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddUserToGroupOutput, crate::error::AddUserToGroupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::add_user_to_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_attach_group_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AttachGroupPolicyOutput, crate::error::AttachGroupPolicyError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AttachGroupPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AttachGroupPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::AttachGroupPolicyError {
            meta: generic,
            kind: crate::error::AttachGroupPolicyErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AttachGroupPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::AttachGroupPolicyError {
            meta: generic,
            kind: crate::error::AttachGroupPolicyErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AttachGroupPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::AttachGroupPolicyError {
            meta: generic,
            kind: crate::error::AttachGroupPolicyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AttachGroupPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PolicyNotAttachable" => crate::error::AttachGroupPolicyError {
            meta: generic,
            kind: crate::error::AttachGroupPolicyErrorKind::PolicyNotAttachableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::policy_not_attachable_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_policy_not_attachable_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AttachGroupPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::AttachGroupPolicyError {
            meta: generic,
            kind: crate::error::AttachGroupPolicyErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AttachGroupPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AttachGroupPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_attach_group_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AttachGroupPolicyOutput, crate::error::AttachGroupPolicyError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::attach_group_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_attach_role_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AttachRolePolicyOutput, crate::error::AttachRolePolicyError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AttachRolePolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AttachRolePolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::AttachRolePolicyError {
            meta: generic,
            kind: crate::error::AttachRolePolicyErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AttachRolePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::AttachRolePolicyError {
            meta: generic,
            kind: crate::error::AttachRolePolicyErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AttachRolePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::AttachRolePolicyError {
            meta: generic,
            kind: crate::error::AttachRolePolicyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AttachRolePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PolicyNotAttachable" => crate::error::AttachRolePolicyError {
            meta: generic,
            kind: crate::error::AttachRolePolicyErrorKind::PolicyNotAttachableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::policy_not_attachable_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_policy_not_attachable_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AttachRolePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::AttachRolePolicyError {
            meta: generic,
            kind: crate::error::AttachRolePolicyErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AttachRolePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnmodifiableEntity" => crate::error::AttachRolePolicyError {
            meta: generic,
            kind: crate::error::AttachRolePolicyErrorKind::UnmodifiableEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unmodifiable_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unmodifiable_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AttachRolePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AttachRolePolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_attach_role_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AttachRolePolicyOutput, crate::error::AttachRolePolicyError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::attach_role_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_attach_user_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AttachUserPolicyOutput, crate::error::AttachUserPolicyError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AttachUserPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AttachUserPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::AttachUserPolicyError {
            meta: generic,
            kind: crate::error::AttachUserPolicyErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AttachUserPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::AttachUserPolicyError {
            meta: generic,
            kind: crate::error::AttachUserPolicyErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AttachUserPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::AttachUserPolicyError {
            meta: generic,
            kind: crate::error::AttachUserPolicyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AttachUserPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PolicyNotAttachable" => crate::error::AttachUserPolicyError {
            meta: generic,
            kind: crate::error::AttachUserPolicyErrorKind::PolicyNotAttachableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::policy_not_attachable_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_policy_not_attachable_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AttachUserPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::AttachUserPolicyError {
            meta: generic,
            kind: crate::error::AttachUserPolicyErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::AttachUserPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AttachUserPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_attach_user_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AttachUserPolicyOutput, crate::error::AttachUserPolicyError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::attach_user_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_change_password_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ChangePasswordOutput, crate::error::ChangePasswordError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ChangePasswordError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ChangePasswordError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "EntityTemporarilyUnmodifiable" => crate::error::ChangePasswordError {
            meta: generic,
            kind: crate::error::ChangePasswordErrorKind::EntityTemporarilyUnmodifiableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_temporarily_unmodifiable_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_entity_temporarily_unmodifiable_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ChangePasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidUserType" => crate::error::ChangePasswordError {
            meta: generic,
            kind: crate::error::ChangePasswordErrorKind::InvalidUserTypeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_user_type_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_user_type_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ChangePasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::ChangePasswordError {
            meta: generic,
            kind: crate::error::ChangePasswordErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ChangePasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::ChangePasswordError {
            meta: generic,
            kind: crate::error::ChangePasswordErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ChangePasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PasswordPolicyViolation" => crate::error::ChangePasswordError {
            meta: generic,
            kind: crate::error::ChangePasswordErrorKind::PasswordPolicyViolationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::password_policy_violation_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_password_policy_violation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ChangePasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::ChangePasswordError {
            meta: generic,
            kind: crate::error::ChangePasswordErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ChangePasswordError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ChangePasswordError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_change_password_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ChangePasswordOutput, crate::error::ChangePasswordError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::change_password_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_access_key_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAccessKeyOutput, crate::error::CreateAccessKeyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateAccessKeyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateAccessKeyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceeded" => crate::error::CreateAccessKeyError {
            meta: generic,
            kind: crate::error::CreateAccessKeyErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateAccessKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::CreateAccessKeyError {
            meta: generic,
            kind: crate::error::CreateAccessKeyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateAccessKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::CreateAccessKeyError {
            meta: generic,
            kind: crate::error::CreateAccessKeyErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateAccessKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateAccessKeyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_access_key_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateAccessKeyOutput, crate::error::CreateAccessKeyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_access_key_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_access_key(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateAccessKeyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_account_alias_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateAccountAliasOutput,
    crate::error::CreateAccountAliasError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateAccountAliasError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateAccountAliasError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "EntityAlreadyExists" => crate::error::CreateAccountAliasError {
            meta: generic,
            kind: crate::error::CreateAccountAliasErrorKind::EntityAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_entity_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateAccountAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::CreateAccountAliasError {
            meta: generic,
            kind: crate::error::CreateAccountAliasErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateAccountAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::CreateAccountAliasError {
            meta: generic,
            kind: crate::error::CreateAccountAliasErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateAccountAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateAccountAliasError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_account_alias_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateAccountAliasOutput,
    crate::error::CreateAccountAliasError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_account_alias_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateGroupOutput, crate::error::CreateGroupError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "EntityAlreadyExists" => crate::error::CreateGroupError {
            meta: generic,
            kind: crate::error::CreateGroupErrorKind::EntityAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_entity_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::CreateGroupError {
            meta: generic,
            kind: crate::error::CreateGroupErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::CreateGroupError {
            meta: generic,
            kind: crate::error::CreateGroupErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::CreateGroupError {
            meta: generic,
            kind: crate::error::CreateGroupErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateGroupOutput, crate::error::CreateGroupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_instance_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateInstanceProfileOutput,
    crate::error::CreateInstanceProfileError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateInstanceProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateInstanceProfileError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModification" => crate::error::CreateInstanceProfileError {
            meta: generic,
            kind: crate::error::CreateInstanceProfileErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_concurrent_modification_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateInstanceProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EntityAlreadyExists" => crate::error::CreateInstanceProfileError {
            meta: generic,
            kind: crate::error::CreateInstanceProfileErrorKind::EntityAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_entity_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateInstanceProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInput" => crate::error::CreateInstanceProfileError {
            meta: generic,
            kind: crate::error::CreateInstanceProfileErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateInstanceProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::CreateInstanceProfileError {
            meta: generic,
            kind: crate::error::CreateInstanceProfileErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateInstanceProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::CreateInstanceProfileError {
            meta: generic,
            kind: crate::error::CreateInstanceProfileErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateInstanceProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateInstanceProfileError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_instance_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateInstanceProfileOutput,
    crate::error::CreateInstanceProfileError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_instance_profile_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_instance_profile(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateInstanceProfileError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_login_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateLoginProfileOutput,
    crate::error::CreateLoginProfileError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateLoginProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateLoginProfileError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "EntityAlreadyExists" => crate::error::CreateLoginProfileError {
            meta: generic,
            kind: crate::error::CreateLoginProfileErrorKind::EntityAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_entity_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoginProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::CreateLoginProfileError {
            meta: generic,
            kind: crate::error::CreateLoginProfileErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoginProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::CreateLoginProfileError {
            meta: generic,
            kind: crate::error::CreateLoginProfileErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoginProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PasswordPolicyViolation" => crate::error::CreateLoginProfileError {
            meta: generic,
            kind: crate::error::CreateLoginProfileErrorKind::PasswordPolicyViolationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::password_policy_violation_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_password_policy_violation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoginProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::CreateLoginProfileError {
            meta: generic,
            kind: crate::error::CreateLoginProfileErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateLoginProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateLoginProfileError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_login_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateLoginProfileOutput,
    crate::error::CreateLoginProfileError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_login_profile_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_login_profile(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateLoginProfileError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_open_id_connect_provider_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateOpenIdConnectProviderOutput,
    crate::error::CreateOpenIDConnectProviderError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateOpenIDConnectProviderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateOpenIDConnectProviderError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModification" => crate::error::CreateOpenIDConnectProviderError {
            meta: generic,
            kind:
                crate::error::CreateOpenIDConnectProviderErrorKind::ConcurrentModificationException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::concurrent_modification_exception::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_concurrent_modification_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateOpenIDConnectProviderError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "EntityAlreadyExists" => crate::error::CreateOpenIDConnectProviderError {
            meta: generic,
            kind: crate::error::CreateOpenIDConnectProviderErrorKind::EntityAlreadyExistsException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::entity_already_exists_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_entity_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateOpenIDConnectProviderError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidInput" => crate::error::CreateOpenIDConnectProviderError {
            meta: generic,
            kind: crate::error::CreateOpenIDConnectProviderErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateOpenIDConnectProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::CreateOpenIDConnectProviderError {
            meta: generic,
            kind: crate::error::CreateOpenIDConnectProviderErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateOpenIDConnectProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::CreateOpenIDConnectProviderError {
            meta: generic,
            kind: crate::error::CreateOpenIDConnectProviderErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateOpenIDConnectProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateOpenIDConnectProviderError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_open_id_connect_provider_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateOpenIdConnectProviderOutput,
    crate::error::CreateOpenIDConnectProviderError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_open_id_connect_provider_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_open_id_connect_provider(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateOpenIDConnectProviderError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreatePolicyOutput, crate::error::CreatePolicyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreatePolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreatePolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModification" => crate::error::CreatePolicyError {
            meta: generic,
            kind: crate::error::CreatePolicyErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_concurrent_modification_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreatePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EntityAlreadyExists" => crate::error::CreatePolicyError {
            meta: generic,
            kind: crate::error::CreatePolicyErrorKind::EntityAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_entity_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreatePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInput" => crate::error::CreatePolicyError {
            meta: generic,
            kind: crate::error::CreatePolicyErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreatePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::CreatePolicyError {
            meta: generic,
            kind: crate::error::CreatePolicyErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreatePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MalformedPolicyDocument" => crate::error::CreatePolicyError {
            meta: generic,
            kind: crate::error::CreatePolicyErrorKind::MalformedPolicyDocumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::malformed_policy_document_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_malformed_policy_document_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreatePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::CreatePolicyError {
            meta: generic,
            kind: crate::error::CreatePolicyErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreatePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreatePolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreatePolicyOutput, crate::error::CreatePolicyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_policy_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreatePolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_policy_version_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreatePolicyVersionOutput,
    crate::error::CreatePolicyVersionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreatePolicyVersionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreatePolicyVersionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::CreatePolicyVersionError {
            meta: generic,
            kind: crate::error::CreatePolicyVersionErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreatePolicyVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::CreatePolicyVersionError {
            meta: generic,
            kind: crate::error::CreatePolicyVersionErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreatePolicyVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MalformedPolicyDocument" => crate::error::CreatePolicyVersionError {
            meta: generic,
            kind: crate::error::CreatePolicyVersionErrorKind::MalformedPolicyDocumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::malformed_policy_document_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_malformed_policy_document_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreatePolicyVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::CreatePolicyVersionError {
            meta: generic,
            kind: crate::error::CreatePolicyVersionErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreatePolicyVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::CreatePolicyVersionError {
            meta: generic,
            kind: crate::error::CreatePolicyVersionErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreatePolicyVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreatePolicyVersionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_policy_version_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreatePolicyVersionOutput,
    crate::error::CreatePolicyVersionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_policy_version_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_policy_version(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreatePolicyVersionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_role_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateRoleOutput, crate::error::CreateRoleError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateRoleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateRoleError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModification" => crate::error::CreateRoleError {
            meta: generic,
            kind: crate::error::CreateRoleErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_concurrent_modification_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EntityAlreadyExists" => crate::error::CreateRoleError {
            meta: generic,
            kind: crate::error::CreateRoleErrorKind::EntityAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_entity_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInput" => crate::error::CreateRoleError {
            meta: generic,
            kind: crate::error::CreateRoleErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::CreateRoleError {
            meta: generic,
            kind: crate::error::CreateRoleErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MalformedPolicyDocument" => crate::error::CreateRoleError {
            meta: generic,
            kind: crate::error::CreateRoleErrorKind::MalformedPolicyDocumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::malformed_policy_document_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_malformed_policy_document_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::CreateRoleError {
            meta: generic,
            kind: crate::error::CreateRoleErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateRoleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_role_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateRoleOutput, crate::error::CreateRoleError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_role_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_role(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateRoleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_saml_provider_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateSamlProviderOutput,
    crate::error::CreateSAMLProviderError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateSAMLProviderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateSAMLProviderError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModification" => crate::error::CreateSAMLProviderError {
            meta: generic,
            kind: crate::error::CreateSAMLProviderErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_concurrent_modification_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSAMLProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EntityAlreadyExists" => crate::error::CreateSAMLProviderError {
            meta: generic,
            kind: crate::error::CreateSAMLProviderErrorKind::EntityAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_entity_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSAMLProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInput" => crate::error::CreateSAMLProviderError {
            meta: generic,
            kind: crate::error::CreateSAMLProviderErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSAMLProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::CreateSAMLProviderError {
            meta: generic,
            kind: crate::error::CreateSAMLProviderErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSAMLProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::CreateSAMLProviderError {
            meta: generic,
            kind: crate::error::CreateSAMLProviderErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateSAMLProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateSAMLProviderError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_saml_provider_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateSamlProviderOutput,
    crate::error::CreateSAMLProviderError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_saml_provider_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_saml_provider(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateSAMLProviderError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_service_linked_role_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateServiceLinkedRoleOutput,
    crate::error::CreateServiceLinkedRoleError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateServiceLinkedRoleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateServiceLinkedRoleError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::CreateServiceLinkedRoleError {
            meta: generic,
            kind: crate::error::CreateServiceLinkedRoleErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateServiceLinkedRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::CreateServiceLinkedRoleError {
            meta: generic,
            kind: crate::error::CreateServiceLinkedRoleErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateServiceLinkedRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::CreateServiceLinkedRoleError {
            meta: generic,
            kind: crate::error::CreateServiceLinkedRoleErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateServiceLinkedRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::CreateServiceLinkedRoleError {
            meta: generic,
            kind: crate::error::CreateServiceLinkedRoleErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateServiceLinkedRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateServiceLinkedRoleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_service_linked_role_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateServiceLinkedRoleOutput,
    crate::error::CreateServiceLinkedRoleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_service_linked_role_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_service_linked_role(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateServiceLinkedRoleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_service_specific_credential_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateServiceSpecificCredentialOutput,
    crate::error::CreateServiceSpecificCredentialError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateServiceSpecificCredentialError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateServiceSpecificCredentialError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceeded" => crate::error::CreateServiceSpecificCredentialError {
            meta: generic,
            kind: crate::error::CreateServiceSpecificCredentialErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateServiceSpecificCredentialError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::CreateServiceSpecificCredentialError {
            meta: generic,
            kind: crate::error::CreateServiceSpecificCredentialErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateServiceSpecificCredentialError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotSupportedService" => crate::error::CreateServiceSpecificCredentialError {
            meta: generic,
            kind:
                crate::error::CreateServiceSpecificCredentialErrorKind::ServiceNotSupportedException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::service_not_supported_exception::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_service_not_supported_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateServiceSpecificCredentialError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::CreateServiceSpecificCredentialError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_service_specific_credential_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateServiceSpecificCredentialOutput,
    crate::error::CreateServiceSpecificCredentialError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::create_service_specific_credential_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_create_service_specific_credential(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::CreateServiceSpecificCredentialError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_user_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateUserOutput, crate::error::CreateUserError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateUserError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateUserError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModification" => crate::error::CreateUserError {
            meta: generic,
            kind: crate::error::CreateUserErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_concurrent_modification_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EntityAlreadyExists" => crate::error::CreateUserError {
            meta: generic,
            kind: crate::error::CreateUserErrorKind::EntityAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_entity_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInput" => crate::error::CreateUserError {
            meta: generic,
            kind: crate::error::CreateUserErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::CreateUserError {
            meta: generic,
            kind: crate::error::CreateUserErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::CreateUserError {
            meta: generic,
            kind: crate::error::CreateUserErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::CreateUserError {
            meta: generic,
            kind: crate::error::CreateUserErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateUserError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_user_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateUserOutput, crate::error::CreateUserError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_user_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_user(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateUserError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_virtual_mfa_device_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateVirtualMfaDeviceOutput,
    crate::error::CreateVirtualMFADeviceError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateVirtualMFADeviceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateVirtualMFADeviceError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModification" => crate::error::CreateVirtualMFADeviceError {
            meta: generic,
            kind: crate::error::CreateVirtualMFADeviceErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_concurrent_modification_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateVirtualMFADeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EntityAlreadyExists" => crate::error::CreateVirtualMFADeviceError {
            meta: generic,
            kind: crate::error::CreateVirtualMFADeviceErrorKind::EntityAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_entity_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateVirtualMFADeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInput" => crate::error::CreateVirtualMFADeviceError {
            meta: generic,
            kind: crate::error::CreateVirtualMFADeviceErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateVirtualMFADeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::CreateVirtualMFADeviceError {
            meta: generic,
            kind: crate::error::CreateVirtualMFADeviceErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateVirtualMFADeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::CreateVirtualMFADeviceError {
            meta: generic,
            kind: crate::error::CreateVirtualMFADeviceErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateVirtualMFADeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateVirtualMFADeviceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_virtual_mfa_device_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateVirtualMfaDeviceOutput,
    crate::error::CreateVirtualMFADeviceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_virtual_mfa_device_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_virtual_mfa_device(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateVirtualMFADeviceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deactivate_mfa_device_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeactivateMfaDeviceOutput,
    crate::error::DeactivateMFADeviceError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeactivateMFADeviceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeactivateMFADeviceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "EntityTemporarilyUnmodifiable" => crate::error::DeactivateMFADeviceError {
            meta: generic,
            kind:
                crate::error::DeactivateMFADeviceErrorKind::EntityTemporarilyUnmodifiableException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::entity_temporarily_unmodifiable_exception::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_entity_temporarily_unmodifiable_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeactivateMFADeviceError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "LimitExceeded" => crate::error::DeactivateMFADeviceError {
            meta: generic,
            kind: crate::error::DeactivateMFADeviceErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeactivateMFADeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::DeactivateMFADeviceError {
            meta: generic,
            kind: crate::error::DeactivateMFADeviceErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeactivateMFADeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::DeactivateMFADeviceError {
            meta: generic,
            kind: crate::error::DeactivateMFADeviceErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeactivateMFADeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeactivateMFADeviceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deactivate_mfa_device_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeactivateMfaDeviceOutput,
    crate::error::DeactivateMFADeviceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::deactivate_mfa_device_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_access_key_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAccessKeyOutput, crate::error::DeleteAccessKeyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAccessKeyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteAccessKeyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceeded" => crate::error::DeleteAccessKeyError {
            meta: generic,
            kind: crate::error::DeleteAccessKeyErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteAccessKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::DeleteAccessKeyError {
            meta: generic,
            kind: crate::error::DeleteAccessKeyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteAccessKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::DeleteAccessKeyError {
            meta: generic,
            kind: crate::error::DeleteAccessKeyErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteAccessKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteAccessKeyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_access_key_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAccessKeyOutput, crate::error::DeleteAccessKeyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_access_key_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_account_alias_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAccountAliasOutput,
    crate::error::DeleteAccountAliasError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAccountAliasError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteAccountAliasError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceeded" => crate::error::DeleteAccountAliasError {
            meta: generic,
            kind: crate::error::DeleteAccountAliasErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteAccountAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::DeleteAccountAliasError {
            meta: generic,
            kind: crate::error::DeleteAccountAliasErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteAccountAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::DeleteAccountAliasError {
            meta: generic,
            kind: crate::error::DeleteAccountAliasErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteAccountAliasError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteAccountAliasError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_account_alias_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAccountAliasOutput,
    crate::error::DeleteAccountAliasError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_account_alias_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_account_password_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAccountPasswordPolicyOutput,
    crate::error::DeleteAccountPasswordPolicyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAccountPasswordPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteAccountPasswordPolicyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceeded" => crate::error::DeleteAccountPasswordPolicyError {
            meta: generic,
            kind: crate::error::DeleteAccountPasswordPolicyErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteAccountPasswordPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::DeleteAccountPasswordPolicyError {
            meta: generic,
            kind: crate::error::DeleteAccountPasswordPolicyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteAccountPasswordPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::DeleteAccountPasswordPolicyError {
            meta: generic,
            kind: crate::error::DeleteAccountPasswordPolicyErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteAccountPasswordPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteAccountPasswordPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_account_password_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAccountPasswordPolicyOutput,
    crate::error::DeleteAccountPasswordPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_account_password_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteGroupOutput, crate::error::DeleteGroupError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DeleteConflict" => crate::error::DeleteGroupError {
            meta: generic,
            kind: crate::error::DeleteGroupErrorKind::DeleteConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::delete_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_delete_conflict_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::DeleteGroupError {
            meta: generic,
            kind: crate::error::DeleteGroupErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::DeleteGroupError {
            meta: generic,
            kind: crate::error::DeleteGroupErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::DeleteGroupError {
            meta: generic,
            kind: crate::error::DeleteGroupErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteGroupOutput, crate::error::DeleteGroupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_group_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteGroupPolicyOutput, crate::error::DeleteGroupPolicyError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteGroupPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteGroupPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceeded" => crate::error::DeleteGroupPolicyError {
            meta: generic,
            kind: crate::error::DeleteGroupPolicyErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteGroupPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::DeleteGroupPolicyError {
            meta: generic,
            kind: crate::error::DeleteGroupPolicyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteGroupPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::DeleteGroupPolicyError {
            meta: generic,
            kind: crate::error::DeleteGroupPolicyErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteGroupPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteGroupPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_group_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteGroupPolicyOutput, crate::error::DeleteGroupPolicyError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_group_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_instance_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteInstanceProfileOutput,
    crate::error::DeleteInstanceProfileError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteInstanceProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteInstanceProfileError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DeleteConflict" => crate::error::DeleteInstanceProfileError {
            meta: generic,
            kind: crate::error::DeleteInstanceProfileErrorKind::DeleteConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::delete_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_delete_conflict_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteInstanceProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::DeleteInstanceProfileError {
            meta: generic,
            kind: crate::error::DeleteInstanceProfileErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteInstanceProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::DeleteInstanceProfileError {
            meta: generic,
            kind: crate::error::DeleteInstanceProfileErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteInstanceProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::DeleteInstanceProfileError {
            meta: generic,
            kind: crate::error::DeleteInstanceProfileErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteInstanceProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteInstanceProfileError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_instance_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteInstanceProfileOutput,
    crate::error::DeleteInstanceProfileError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_instance_profile_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_login_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteLoginProfileOutput,
    crate::error::DeleteLoginProfileError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteLoginProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteLoginProfileError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "EntityTemporarilyUnmodifiable" => crate::error::DeleteLoginProfileError {
            meta: generic,
            kind: crate::error::DeleteLoginProfileErrorKind::EntityTemporarilyUnmodifiableException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::entity_temporarily_unmodifiable_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_entity_temporarily_unmodifiable_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoginProfileError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "LimitExceeded" => crate::error::DeleteLoginProfileError {
            meta: generic,
            kind: crate::error::DeleteLoginProfileErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoginProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::DeleteLoginProfileError {
            meta: generic,
            kind: crate::error::DeleteLoginProfileErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoginProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::DeleteLoginProfileError {
            meta: generic,
            kind: crate::error::DeleteLoginProfileErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoginProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteLoginProfileError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_login_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteLoginProfileOutput,
    crate::error::DeleteLoginProfileError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_login_profile_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_open_id_connect_provider_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteOpenIdConnectProviderOutput,
    crate::error::DeleteOpenIDConnectProviderError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteOpenIDConnectProviderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteOpenIDConnectProviderError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::DeleteOpenIDConnectProviderError {
            meta: generic,
            kind: crate::error::DeleteOpenIDConnectProviderErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteOpenIDConnectProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::DeleteOpenIDConnectProviderError {
            meta: generic,
            kind: crate::error::DeleteOpenIDConnectProviderErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteOpenIDConnectProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::DeleteOpenIDConnectProviderError {
            meta: generic,
            kind: crate::error::DeleteOpenIDConnectProviderErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteOpenIDConnectProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteOpenIDConnectProviderError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_open_id_connect_provider_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteOpenIdConnectProviderOutput,
    crate::error::DeleteOpenIDConnectProviderError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_open_id_connect_provider_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeletePolicyOutput, crate::error::DeletePolicyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeletePolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeletePolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DeleteConflict" => crate::error::DeletePolicyError {
            meta: generic,
            kind: crate::error::DeletePolicyErrorKind::DeleteConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::delete_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_delete_conflict_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeletePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInput" => crate::error::DeletePolicyError {
            meta: generic,
            kind: crate::error::DeletePolicyErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeletePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::DeletePolicyError {
            meta: generic,
            kind: crate::error::DeletePolicyErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeletePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::DeletePolicyError {
            meta: generic,
            kind: crate::error::DeletePolicyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeletePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::DeletePolicyError {
            meta: generic,
            kind: crate::error::DeletePolicyErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeletePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeletePolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeletePolicyOutput, crate::error::DeletePolicyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_policy_version_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeletePolicyVersionOutput,
    crate::error::DeletePolicyVersionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeletePolicyVersionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeletePolicyVersionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DeleteConflict" => crate::error::DeletePolicyVersionError {
            meta: generic,
            kind: crate::error::DeletePolicyVersionErrorKind::DeleteConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::delete_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_delete_conflict_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeletePolicyVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInput" => crate::error::DeletePolicyVersionError {
            meta: generic,
            kind: crate::error::DeletePolicyVersionErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeletePolicyVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::DeletePolicyVersionError {
            meta: generic,
            kind: crate::error::DeletePolicyVersionErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeletePolicyVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::DeletePolicyVersionError {
            meta: generic,
            kind: crate::error::DeletePolicyVersionErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeletePolicyVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::DeletePolicyVersionError {
            meta: generic,
            kind: crate::error::DeletePolicyVersionErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeletePolicyVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeletePolicyVersionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_policy_version_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeletePolicyVersionOutput,
    crate::error::DeletePolicyVersionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_policy_version_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_role_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteRoleOutput, crate::error::DeleteRoleError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteRoleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteRoleError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModification" => crate::error::DeleteRoleError {
            meta: generic,
            kind: crate::error::DeleteRoleErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_concurrent_modification_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DeleteConflict" => crate::error::DeleteRoleError {
            meta: generic,
            kind: crate::error::DeleteRoleErrorKind::DeleteConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::delete_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_delete_conflict_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::DeleteRoleError {
            meta: generic,
            kind: crate::error::DeleteRoleErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::DeleteRoleError {
            meta: generic,
            kind: crate::error::DeleteRoleErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::DeleteRoleError {
            meta: generic,
            kind: crate::error::DeleteRoleErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnmodifiableEntity" => crate::error::DeleteRoleError {
            meta: generic,
            kind: crate::error::DeleteRoleErrorKind::UnmodifiableEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unmodifiable_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unmodifiable_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteRoleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_role_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteRoleOutput, crate::error::DeleteRoleError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_role_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_role_permissions_boundary_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteRolePermissionsBoundaryOutput,
    crate::error::DeleteRolePermissionsBoundaryError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteRolePermissionsBoundaryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteRolePermissionsBoundaryError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::DeleteRolePermissionsBoundaryError {
            meta: generic,
            kind: crate::error::DeleteRolePermissionsBoundaryErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteRolePermissionsBoundaryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::DeleteRolePermissionsBoundaryError {
            meta: generic,
            kind: crate::error::DeleteRolePermissionsBoundaryErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteRolePermissionsBoundaryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnmodifiableEntity" => crate::error::DeleteRolePermissionsBoundaryError {
            meta: generic,
            kind: crate::error::DeleteRolePermissionsBoundaryErrorKind::UnmodifiableEntityException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::unmodifiable_entity_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_unmodifiable_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteRolePermissionsBoundaryError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DeleteRolePermissionsBoundaryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_role_permissions_boundary_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteRolePermissionsBoundaryOutput,
    crate::error::DeleteRolePermissionsBoundaryError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_role_permissions_boundary_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_role_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteRolePolicyOutput, crate::error::DeleteRolePolicyError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteRolePolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteRolePolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceeded" => crate::error::DeleteRolePolicyError {
            meta: generic,
            kind: crate::error::DeleteRolePolicyErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteRolePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::DeleteRolePolicyError {
            meta: generic,
            kind: crate::error::DeleteRolePolicyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteRolePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::DeleteRolePolicyError {
            meta: generic,
            kind: crate::error::DeleteRolePolicyErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteRolePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnmodifiableEntity" => crate::error::DeleteRolePolicyError {
            meta: generic,
            kind: crate::error::DeleteRolePolicyErrorKind::UnmodifiableEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unmodifiable_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unmodifiable_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteRolePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteRolePolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_role_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteRolePolicyOutput, crate::error::DeleteRolePolicyError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_role_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_saml_provider_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteSamlProviderOutput,
    crate::error::DeleteSAMLProviderError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteSAMLProviderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteSAMLProviderError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::DeleteSAMLProviderError {
            meta: generic,
            kind: crate::error::DeleteSAMLProviderErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteSAMLProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::DeleteSAMLProviderError {
            meta: generic,
            kind: crate::error::DeleteSAMLProviderErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteSAMLProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::DeleteSAMLProviderError {
            meta: generic,
            kind: crate::error::DeleteSAMLProviderErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteSAMLProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::DeleteSAMLProviderError {
            meta: generic,
            kind: crate::error::DeleteSAMLProviderErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteSAMLProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteSAMLProviderError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_saml_provider_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteSamlProviderOutput,
    crate::error::DeleteSAMLProviderError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_saml_provider_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_server_certificate_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteServerCertificateOutput,
    crate::error::DeleteServerCertificateError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteServerCertificateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteServerCertificateError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DeleteConflict" => crate::error::DeleteServerCertificateError {
            meta: generic,
            kind: crate::error::DeleteServerCertificateErrorKind::DeleteConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::delete_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_delete_conflict_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteServerCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::DeleteServerCertificateError {
            meta: generic,
            kind: crate::error::DeleteServerCertificateErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteServerCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::DeleteServerCertificateError {
            meta: generic,
            kind: crate::error::DeleteServerCertificateErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteServerCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::DeleteServerCertificateError {
            meta: generic,
            kind: crate::error::DeleteServerCertificateErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteServerCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteServerCertificateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_server_certificate_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteServerCertificateOutput,
    crate::error::DeleteServerCertificateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_server_certificate_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_service_linked_role_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteServiceLinkedRoleOutput,
    crate::error::DeleteServiceLinkedRoleError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteServiceLinkedRoleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteServiceLinkedRoleError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceeded" => crate::error::DeleteServiceLinkedRoleError {
            meta: generic,
            kind: crate::error::DeleteServiceLinkedRoleErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteServiceLinkedRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::DeleteServiceLinkedRoleError {
            meta: generic,
            kind: crate::error::DeleteServiceLinkedRoleErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteServiceLinkedRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::DeleteServiceLinkedRoleError {
            meta: generic,
            kind: crate::error::DeleteServiceLinkedRoleErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteServiceLinkedRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteServiceLinkedRoleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_service_linked_role_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteServiceLinkedRoleOutput,
    crate::error::DeleteServiceLinkedRoleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_service_linked_role_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_service_linked_role(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteServiceLinkedRoleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_service_specific_credential_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteServiceSpecificCredentialOutput,
    crate::error::DeleteServiceSpecificCredentialError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteServiceSpecificCredentialError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteServiceSpecificCredentialError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::DeleteServiceSpecificCredentialError {
            meta: generic,
            kind: crate::error::DeleteServiceSpecificCredentialErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteServiceSpecificCredentialError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteServiceSpecificCredentialError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_service_specific_credential_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteServiceSpecificCredentialOutput,
    crate::error::DeleteServiceSpecificCredentialError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_service_specific_credential_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_signing_certificate_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteSigningCertificateOutput,
    crate::error::DeleteSigningCertificateError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteSigningCertificateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteSigningCertificateError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceeded" => crate::error::DeleteSigningCertificateError {
            meta: generic,
            kind: crate::error::DeleteSigningCertificateErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteSigningCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::DeleteSigningCertificateError {
            meta: generic,
            kind: crate::error::DeleteSigningCertificateErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteSigningCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::DeleteSigningCertificateError {
            meta: generic,
            kind: crate::error::DeleteSigningCertificateErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteSigningCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteSigningCertificateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_signing_certificate_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteSigningCertificateOutput,
    crate::error::DeleteSigningCertificateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_signing_certificate_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_ssh_public_key_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteSshPublicKeyOutput,
    crate::error::DeleteSSHPublicKeyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteSSHPublicKeyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteSSHPublicKeyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::DeleteSSHPublicKeyError {
            meta: generic,
            kind: crate::error::DeleteSSHPublicKeyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteSSHPublicKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteSSHPublicKeyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_ssh_public_key_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteSshPublicKeyOutput,
    crate::error::DeleteSSHPublicKeyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_ssh_public_key_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_user_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteUserOutput, crate::error::DeleteUserError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteUserError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteUserError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModification" => crate::error::DeleteUserError {
            meta: generic,
            kind: crate::error::DeleteUserErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_concurrent_modification_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DeleteConflict" => crate::error::DeleteUserError {
            meta: generic,
            kind: crate::error::DeleteUserErrorKind::DeleteConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::delete_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_delete_conflict_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::DeleteUserError {
            meta: generic,
            kind: crate::error::DeleteUserErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::DeleteUserError {
            meta: generic,
            kind: crate::error::DeleteUserErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::DeleteUserError {
            meta: generic,
            kind: crate::error::DeleteUserErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteUserError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_user_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteUserOutput, crate::error::DeleteUserError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_user_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_user_permissions_boundary_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteUserPermissionsBoundaryOutput,
    crate::error::DeleteUserPermissionsBoundaryError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteUserPermissionsBoundaryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteUserPermissionsBoundaryError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::DeleteUserPermissionsBoundaryError {
            meta: generic,
            kind: crate::error::DeleteUserPermissionsBoundaryErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserPermissionsBoundaryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::DeleteUserPermissionsBoundaryError {
            meta: generic,
            kind: crate::error::DeleteUserPermissionsBoundaryErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserPermissionsBoundaryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteUserPermissionsBoundaryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_user_permissions_boundary_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteUserPermissionsBoundaryOutput,
    crate::error::DeleteUserPermissionsBoundaryError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_user_permissions_boundary_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_user_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteUserPolicyOutput, crate::error::DeleteUserPolicyError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteUserPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteUserPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceeded" => crate::error::DeleteUserPolicyError {
            meta: generic,
            kind: crate::error::DeleteUserPolicyErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::DeleteUserPolicyError {
            meta: generic,
            kind: crate::error::DeleteUserPolicyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::DeleteUserPolicyError {
            meta: generic,
            kind: crate::error::DeleteUserPolicyErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteUserPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteUserPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_user_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteUserPolicyOutput, crate::error::DeleteUserPolicyError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_user_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_virtual_mfa_device_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteVirtualMfaDeviceOutput,
    crate::error::DeleteVirtualMFADeviceError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteVirtualMFADeviceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteVirtualMFADeviceError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DeleteConflict" => crate::error::DeleteVirtualMFADeviceError {
            meta: generic,
            kind: crate::error::DeleteVirtualMFADeviceErrorKind::DeleteConflictException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::delete_conflict_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_delete_conflict_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteVirtualMFADeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::DeleteVirtualMFADeviceError {
            meta: generic,
            kind: crate::error::DeleteVirtualMFADeviceErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteVirtualMFADeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::DeleteVirtualMFADeviceError {
            meta: generic,
            kind: crate::error::DeleteVirtualMFADeviceErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteVirtualMFADeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::DeleteVirtualMFADeviceError {
            meta: generic,
            kind: crate::error::DeleteVirtualMFADeviceErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteVirtualMFADeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteVirtualMFADeviceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_virtual_mfa_device_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteVirtualMfaDeviceOutput,
    crate::error::DeleteVirtualMFADeviceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_virtual_mfa_device_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detach_group_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DetachGroupPolicyOutput, crate::error::DetachGroupPolicyError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DetachGroupPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DetachGroupPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::DetachGroupPolicyError {
            meta: generic,
            kind: crate::error::DetachGroupPolicyErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DetachGroupPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::DetachGroupPolicyError {
            meta: generic,
            kind: crate::error::DetachGroupPolicyErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DetachGroupPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::DetachGroupPolicyError {
            meta: generic,
            kind: crate::error::DetachGroupPolicyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DetachGroupPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::DetachGroupPolicyError {
            meta: generic,
            kind: crate::error::DetachGroupPolicyErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DetachGroupPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DetachGroupPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detach_group_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DetachGroupPolicyOutput, crate::error::DetachGroupPolicyError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::detach_group_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detach_role_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DetachRolePolicyOutput, crate::error::DetachRolePolicyError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DetachRolePolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DetachRolePolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::DetachRolePolicyError {
            meta: generic,
            kind: crate::error::DetachRolePolicyErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DetachRolePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::DetachRolePolicyError {
            meta: generic,
            kind: crate::error::DetachRolePolicyErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DetachRolePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::DetachRolePolicyError {
            meta: generic,
            kind: crate::error::DetachRolePolicyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DetachRolePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::DetachRolePolicyError {
            meta: generic,
            kind: crate::error::DetachRolePolicyErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DetachRolePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnmodifiableEntity" => crate::error::DetachRolePolicyError {
            meta: generic,
            kind: crate::error::DetachRolePolicyErrorKind::UnmodifiableEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unmodifiable_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unmodifiable_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DetachRolePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DetachRolePolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detach_role_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DetachRolePolicyOutput, crate::error::DetachRolePolicyError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::detach_role_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detach_user_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DetachUserPolicyOutput, crate::error::DetachUserPolicyError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DetachUserPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DetachUserPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::DetachUserPolicyError {
            meta: generic,
            kind: crate::error::DetachUserPolicyErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DetachUserPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::DetachUserPolicyError {
            meta: generic,
            kind: crate::error::DetachUserPolicyErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DetachUserPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::DetachUserPolicyError {
            meta: generic,
            kind: crate::error::DetachUserPolicyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DetachUserPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::DetachUserPolicyError {
            meta: generic,
            kind: crate::error::DetachUserPolicyErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DetachUserPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DetachUserPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detach_user_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DetachUserPolicyOutput, crate::error::DetachUserPolicyError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::detach_user_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_mfa_device_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::EnableMfaDeviceOutput, crate::error::EnableMFADeviceError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::EnableMFADeviceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::EnableMFADeviceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "EntityAlreadyExists" => crate::error::EnableMFADeviceError {
            meta: generic,
            kind: crate::error::EnableMFADeviceErrorKind::EntityAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_entity_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::EnableMFADeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EntityTemporarilyUnmodifiable" => crate::error::EnableMFADeviceError {
            meta: generic,
            kind: crate::error::EnableMFADeviceErrorKind::EntityTemporarilyUnmodifiableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_temporarily_unmodifiable_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_entity_temporarily_unmodifiable_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::EnableMFADeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidAuthenticationCode" => crate::error::EnableMFADeviceError {
            meta: generic,
            kind: crate::error::EnableMFADeviceErrorKind::InvalidAuthenticationCodeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_authentication_code_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_authentication_code_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::EnableMFADeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::EnableMFADeviceError {
            meta: generic,
            kind: crate::error::EnableMFADeviceErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::EnableMFADeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::EnableMFADeviceError {
            meta: generic,
            kind: crate::error::EnableMFADeviceErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::EnableMFADeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::EnableMFADeviceError {
            meta: generic,
            kind: crate::error::EnableMFADeviceErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::EnableMFADeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::EnableMFADeviceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_mfa_device_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::EnableMfaDeviceOutput, crate::error::EnableMFADeviceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::enable_mfa_device_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_generate_credential_report_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GenerateCredentialReportOutput,
    crate::error::GenerateCredentialReportError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GenerateCredentialReportError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GenerateCredentialReportError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceeded" => crate::error::GenerateCredentialReportError {
            meta: generic,
            kind: crate::error::GenerateCredentialReportErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GenerateCredentialReportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::GenerateCredentialReportError {
            meta: generic,
            kind: crate::error::GenerateCredentialReportErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GenerateCredentialReportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GenerateCredentialReportError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_generate_credential_report_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GenerateCredentialReportOutput,
    crate::error::GenerateCredentialReportError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::generate_credential_report_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_generate_credential_report(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GenerateCredentialReportError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_generate_organizations_access_report_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GenerateOrganizationsAccessReportOutput,
    crate::error::GenerateOrganizationsAccessReportError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GenerateOrganizationsAccessReportError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GenerateOrganizationsAccessReportError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ReportGenerationLimitExceeded" => crate::error::GenerateOrganizationsAccessReportError { meta: generic, kind: crate::error::GenerateOrganizationsAccessReportErrorKind::ReportGenerationLimitExceededException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::report_generation_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_report_generation_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GenerateOrganizationsAccessReportError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::GenerateOrganizationsAccessReportError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_generate_organizations_access_report_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GenerateOrganizationsAccessReportOutput,
    crate::error::GenerateOrganizationsAccessReportError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::generate_organizations_access_report_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_generate_organizations_access_report(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GenerateOrganizationsAccessReportError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_generate_service_last_accessed_details_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GenerateServiceLastAccessedDetailsOutput,
    crate::error::GenerateServiceLastAccessedDetailsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GenerateServiceLastAccessedDetailsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GenerateServiceLastAccessedDetailsError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::GenerateServiceLastAccessedDetailsError {
            meta: generic,
            kind: crate::error::GenerateServiceLastAccessedDetailsErrorKind::InvalidInputException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_input_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GenerateServiceLastAccessedDetailsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "NoSuchEntity" => crate::error::GenerateServiceLastAccessedDetailsError {
            meta: generic,
            kind: crate::error::GenerateServiceLastAccessedDetailsErrorKind::NoSuchEntityException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::no_such_entity_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GenerateServiceLastAccessedDetailsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::GenerateServiceLastAccessedDetailsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_generate_service_last_accessed_details_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GenerateServiceLastAccessedDetailsOutput,
    crate::error::GenerateServiceLastAccessedDetailsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::generate_service_last_accessed_details_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_generate_service_last_accessed_details(response.body().as_ref(), output).map_err(crate::error::GenerateServiceLastAccessedDetailsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_access_key_last_used_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAccessKeyLastUsedOutput,
    crate::error::GetAccessKeyLastUsedError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAccessKeyLastUsedError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetAccessKeyLastUsedError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::GetAccessKeyLastUsedError {
            meta: generic,
            kind: crate::error::GetAccessKeyLastUsedErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetAccessKeyLastUsedError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetAccessKeyLastUsedError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_access_key_last_used_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAccessKeyLastUsedOutput,
    crate::error::GetAccessKeyLastUsedError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_access_key_last_used_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_access_key_last_used(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetAccessKeyLastUsedError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_account_authorization_details_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAccountAuthorizationDetailsOutput,
    crate::error::GetAccountAuthorizationDetailsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAccountAuthorizationDetailsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetAccountAuthorizationDetailsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ServiceFailure" => crate::error::GetAccountAuthorizationDetailsError {
            meta: generic,
            kind: crate::error::GetAccountAuthorizationDetailsErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetAccountAuthorizationDetailsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetAccountAuthorizationDetailsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_account_authorization_details_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAccountAuthorizationDetailsOutput,
    crate::error::GetAccountAuthorizationDetailsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_account_authorization_details_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_get_account_authorization_details(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetAccountAuthorizationDetailsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_account_password_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAccountPasswordPolicyOutput,
    crate::error::GetAccountPasswordPolicyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAccountPasswordPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetAccountPasswordPolicyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::GetAccountPasswordPolicyError {
            meta: generic,
            kind: crate::error::GetAccountPasswordPolicyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetAccountPasswordPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::GetAccountPasswordPolicyError {
            meta: generic,
            kind: crate::error::GetAccountPasswordPolicyErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetAccountPasswordPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetAccountPasswordPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_account_password_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAccountPasswordPolicyOutput,
    crate::error::GetAccountPasswordPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_account_password_policy_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_account_password_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetAccountPasswordPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_account_summary_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetAccountSummaryOutput, crate::error::GetAccountSummaryError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAccountSummaryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetAccountSummaryError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ServiceFailure" => crate::error::GetAccountSummaryError {
            meta: generic,
            kind: crate::error::GetAccountSummaryErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetAccountSummaryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetAccountSummaryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_account_summary_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetAccountSummaryOutput, crate::error::GetAccountSummaryError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_account_summary_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_account_summary(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetAccountSummaryError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_context_keys_for_custom_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetContextKeysForCustomPolicyOutput,
    crate::error::GetContextKeysForCustomPolicyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetContextKeysForCustomPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetContextKeysForCustomPolicyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::GetContextKeysForCustomPolicyError {
            meta: generic,
            kind: crate::error::GetContextKeysForCustomPolicyErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetContextKeysForCustomPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetContextKeysForCustomPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_context_keys_for_custom_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetContextKeysForCustomPolicyOutput,
    crate::error::GetContextKeysForCustomPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_context_keys_for_custom_policy_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_get_context_keys_for_custom_policy(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetContextKeysForCustomPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_context_keys_for_principal_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetContextKeysForPrincipalPolicyOutput,
    crate::error::GetContextKeysForPrincipalPolicyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetContextKeysForPrincipalPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetContextKeysForPrincipalPolicyError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::GetContextKeysForPrincipalPolicyError {
            meta: generic,
            kind: crate::error::GetContextKeysForPrincipalPolicyErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetContextKeysForPrincipalPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::GetContextKeysForPrincipalPolicyError {
            meta: generic,
            kind: crate::error::GetContextKeysForPrincipalPolicyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetContextKeysForPrincipalPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetContextKeysForPrincipalPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_context_keys_for_principal_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetContextKeysForPrincipalPolicyOutput,
    crate::error::GetContextKeysForPrincipalPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_context_keys_for_principal_policy_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_context_keys_for_principal_policy(response.body().as_ref(), output).map_err(crate::error::GetContextKeysForPrincipalPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_credential_report_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetCredentialReportOutput,
    crate::error::GetCredentialReportError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetCredentialReportError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetCredentialReportError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ReportExpired" => crate::error::GetCredentialReportError {
            meta: generic,
            kind: crate::error::GetCredentialReportErrorKind::CredentialReportExpiredException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::credential_report_expired_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_credential_report_expired_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetCredentialReportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ReportNotPresent" => {
            crate::error::GetCredentialReportError {
                meta: generic,
                kind:
                    crate::error::GetCredentialReportErrorKind::CredentialReportNotPresentException(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::credential_report_not_present_exception::Builder::default();
                                let _ = response;
                                output = crate::xml_deser::deser_structure_crate_error_credential_report_not_present_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetCredentialReportError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "ReportInProgress" => crate::error::GetCredentialReportError {
            meta: generic,
            kind: crate::error::GetCredentialReportErrorKind::CredentialReportNotReadyException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::credential_report_not_ready_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_credential_report_not_ready_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetCredentialReportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::GetCredentialReportError {
            meta: generic,
            kind: crate::error::GetCredentialReportErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetCredentialReportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetCredentialReportError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_credential_report_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetCredentialReportOutput,
    crate::error::GetCredentialReportError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_credential_report_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_credential_report(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetCredentialReportError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetGroupOutput, crate::error::GetGroupError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::GetGroupError {
            meta: generic,
            kind: crate::error::GetGroupErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::GetGroupError {
            meta: generic,
            kind: crate::error::GetGroupErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetGroupOutput, crate::error::GetGroupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_group_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetGroupPolicyOutput, crate::error::GetGroupPolicyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetGroupPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetGroupPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::GetGroupPolicyError {
            meta: generic,
            kind: crate::error::GetGroupPolicyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetGroupPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::GetGroupPolicyError {
            meta: generic,
            kind: crate::error::GetGroupPolicyErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetGroupPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetGroupPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_group_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetGroupPolicyOutput, crate::error::GetGroupPolicyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_group_policy_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_group_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetGroupPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_instance_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetInstanceProfileOutput,
    crate::error::GetInstanceProfileError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetInstanceProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetInstanceProfileError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::GetInstanceProfileError {
            meta: generic,
            kind: crate::error::GetInstanceProfileErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::GetInstanceProfileError {
            meta: generic,
            kind: crate::error::GetInstanceProfileErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetInstanceProfileError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_instance_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetInstanceProfileOutput,
    crate::error::GetInstanceProfileError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_instance_profile_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_instance_profile(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetInstanceProfileError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_login_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetLoginProfileOutput, crate::error::GetLoginProfileError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetLoginProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetLoginProfileError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::GetLoginProfileError {
            meta: generic,
            kind: crate::error::GetLoginProfileErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetLoginProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::GetLoginProfileError {
            meta: generic,
            kind: crate::error::GetLoginProfileErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetLoginProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetLoginProfileError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_login_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetLoginProfileOutput, crate::error::GetLoginProfileError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_login_profile_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_login_profile(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetLoginProfileError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_open_id_connect_provider_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetOpenIdConnectProviderOutput,
    crate::error::GetOpenIDConnectProviderError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetOpenIDConnectProviderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetOpenIDConnectProviderError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::GetOpenIDConnectProviderError {
            meta: generic,
            kind: crate::error::GetOpenIDConnectProviderErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetOpenIDConnectProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::GetOpenIDConnectProviderError {
            meta: generic,
            kind: crate::error::GetOpenIDConnectProviderErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetOpenIDConnectProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::GetOpenIDConnectProviderError {
            meta: generic,
            kind: crate::error::GetOpenIDConnectProviderErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetOpenIDConnectProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetOpenIDConnectProviderError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_open_id_connect_provider_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetOpenIdConnectProviderOutput,
    crate::error::GetOpenIDConnectProviderError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_open_id_connect_provider_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_open_id_connect_provider(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetOpenIDConnectProviderError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_organizations_access_report_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetOrganizationsAccessReportOutput,
    crate::error::GetOrganizationsAccessReportError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetOrganizationsAccessReportError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetOrganizationsAccessReportError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::GetOrganizationsAccessReportError {
            meta: generic,
            kind: crate::error::GetOrganizationsAccessReportErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetOrganizationsAccessReportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetOrganizationsAccessReportError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_organizations_access_report_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetOrganizationsAccessReportOutput,
    crate::error::GetOrganizationsAccessReportError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_organizations_access_report_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_organizations_access_report(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetOrganizationsAccessReportError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetPolicyOutput, crate::error::GetPolicyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::GetPolicyError {
            meta: generic,
            kind: crate::error::GetPolicyErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::GetPolicyError {
            meta: generic,
            kind: crate::error::GetPolicyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::GetPolicyError {
            meta: generic,
            kind: crate::error::GetPolicyErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetPolicyOutput, crate::error::GetPolicyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_policy_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_policy_version_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetPolicyVersionOutput, crate::error::GetPolicyVersionError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetPolicyVersionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetPolicyVersionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::GetPolicyVersionError {
            meta: generic,
            kind: crate::error::GetPolicyVersionErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetPolicyVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::GetPolicyVersionError {
            meta: generic,
            kind: crate::error::GetPolicyVersionErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetPolicyVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::GetPolicyVersionError {
            meta: generic,
            kind: crate::error::GetPolicyVersionErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetPolicyVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetPolicyVersionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_policy_version_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetPolicyVersionOutput, crate::error::GetPolicyVersionError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_policy_version_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_policy_version(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetPolicyVersionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_role_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRoleOutput, crate::error::GetRoleError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRoleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetRoleError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::GetRoleError {
            meta: generic,
            kind: crate::error::GetRoleErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::GetRoleError {
            meta: generic,
            kind: crate::error::GetRoleErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetRoleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_role_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRoleOutput, crate::error::GetRoleError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_role_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_role(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetRoleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_role_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRolePolicyOutput, crate::error::GetRolePolicyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRolePolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetRolePolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::GetRolePolicyError {
            meta: generic,
            kind: crate::error::GetRolePolicyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetRolePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::GetRolePolicyError {
            meta: generic,
            kind: crate::error::GetRolePolicyErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetRolePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetRolePolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_role_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRolePolicyOutput, crate::error::GetRolePolicyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_role_policy_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_role_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetRolePolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_saml_provider_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetSamlProviderOutput, crate::error::GetSAMLProviderError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetSAMLProviderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetSAMLProviderError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::GetSAMLProviderError {
            meta: generic,
            kind: crate::error::GetSAMLProviderErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetSAMLProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::GetSAMLProviderError {
            meta: generic,
            kind: crate::error::GetSAMLProviderErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetSAMLProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::GetSAMLProviderError {
            meta: generic,
            kind: crate::error::GetSAMLProviderErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetSAMLProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetSAMLProviderError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_saml_provider_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetSamlProviderOutput, crate::error::GetSAMLProviderError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_saml_provider_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_saml_provider(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetSAMLProviderError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_server_certificate_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetServerCertificateOutput,
    crate::error::GetServerCertificateError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetServerCertificateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetServerCertificateError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::GetServerCertificateError {
            meta: generic,
            kind: crate::error::GetServerCertificateErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetServerCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::GetServerCertificateError {
            meta: generic,
            kind: crate::error::GetServerCertificateErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetServerCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetServerCertificateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_server_certificate_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetServerCertificateOutput,
    crate::error::GetServerCertificateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_server_certificate_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_server_certificate(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetServerCertificateError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_service_last_accessed_details_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetServiceLastAccessedDetailsOutput,
    crate::error::GetServiceLastAccessedDetailsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetServiceLastAccessedDetailsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetServiceLastAccessedDetailsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::GetServiceLastAccessedDetailsError {
            meta: generic,
            kind: crate::error::GetServiceLastAccessedDetailsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetServiceLastAccessedDetailsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::GetServiceLastAccessedDetailsError {
            meta: generic,
            kind: crate::error::GetServiceLastAccessedDetailsErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetServiceLastAccessedDetailsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetServiceLastAccessedDetailsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_service_last_accessed_details_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetServiceLastAccessedDetailsOutput,
    crate::error::GetServiceLastAccessedDetailsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_service_last_accessed_details_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_get_service_last_accessed_details(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetServiceLastAccessedDetailsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_service_last_accessed_details_with_entities_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetServiceLastAccessedDetailsWithEntitiesOutput,
    crate::error::GetServiceLastAccessedDetailsWithEntitiesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetServiceLastAccessedDetailsWithEntitiesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::GetServiceLastAccessedDetailsWithEntitiesError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::GetServiceLastAccessedDetailsWithEntitiesError { meta: generic, kind: crate::error::GetServiceLastAccessedDetailsWithEntitiesErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetServiceLastAccessedDetailsWithEntitiesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchEntity" => crate::error::GetServiceLastAccessedDetailsWithEntitiesError { meta: generic, kind: crate::error::GetServiceLastAccessedDetailsWithEntitiesErrorKind::NoSuchEntityException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetServiceLastAccessedDetailsWithEntitiesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::GetServiceLastAccessedDetailsWithEntitiesError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_service_last_accessed_details_with_entities_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetServiceLastAccessedDetailsWithEntitiesOutput,
    crate::error::GetServiceLastAccessedDetailsWithEntitiesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_service_last_accessed_details_with_entities_output::Builder::default(
            );
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_service_last_accessed_details_with_entities(response.body().as_ref(), output).map_err(crate::error::GetServiceLastAccessedDetailsWithEntitiesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_service_linked_role_deletion_status_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetServiceLinkedRoleDeletionStatusOutput,
    crate::error::GetServiceLinkedRoleDeletionStatusError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetServiceLinkedRoleDeletionStatusError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetServiceLinkedRoleDeletionStatusError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::GetServiceLinkedRoleDeletionStatusError {
            meta: generic,
            kind: crate::error::GetServiceLinkedRoleDeletionStatusErrorKind::InvalidInputException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_input_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetServiceLinkedRoleDeletionStatusError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "NoSuchEntity" => crate::error::GetServiceLinkedRoleDeletionStatusError {
            meta: generic,
            kind: crate::error::GetServiceLinkedRoleDeletionStatusErrorKind::NoSuchEntityException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::no_such_entity_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetServiceLinkedRoleDeletionStatusError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ServiceFailure" => crate::error::GetServiceLinkedRoleDeletionStatusError {
            meta: generic,
            kind:
                crate::error::GetServiceLinkedRoleDeletionStatusErrorKind::ServiceFailureException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::service_failure_exception::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetServiceLinkedRoleDeletionStatusError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::GetServiceLinkedRoleDeletionStatusError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_service_linked_role_deletion_status_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetServiceLinkedRoleDeletionStatusOutput,
    crate::error::GetServiceLinkedRoleDeletionStatusError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_service_linked_role_deletion_status_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_service_linked_role_deletion_status(response.body().as_ref(), output).map_err(crate::error::GetServiceLinkedRoleDeletionStatusError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_ssh_public_key_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetSshPublicKeyOutput, crate::error::GetSSHPublicKeyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetSSHPublicKeyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetSSHPublicKeyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::GetSSHPublicKeyError {
            meta: generic,
            kind: crate::error::GetSSHPublicKeyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetSSHPublicKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnrecognizedPublicKeyEncoding" => crate::error::GetSSHPublicKeyError {
            meta: generic,
            kind: crate::error::GetSSHPublicKeyErrorKind::UnrecognizedPublicKeyEncodingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unrecognized_public_key_encoding_exception::Builder::default(
                        );
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unrecognized_public_key_encoding_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetSSHPublicKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetSSHPublicKeyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_ssh_public_key_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetSshPublicKeyOutput, crate::error::GetSSHPublicKeyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_ssh_public_key_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_ssh_public_key(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetSSHPublicKeyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_user_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetUserOutput, crate::error::GetUserError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetUserError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetUserError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::GetUserError {
            meta: generic,
            kind: crate::error::GetUserErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::GetUserError {
            meta: generic,
            kind: crate::error::GetUserErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetUserError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_user_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetUserOutput, crate::error::GetUserError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_user_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_user(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetUserError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_user_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetUserPolicyOutput, crate::error::GetUserPolicyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetUserPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetUserPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::GetUserPolicyError {
            meta: generic,
            kind: crate::error::GetUserPolicyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetUserPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::GetUserPolicyError {
            meta: generic,
            kind: crate::error::GetUserPolicyErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetUserPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetUserPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_user_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetUserPolicyOutput, crate::error::GetUserPolicyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_user_policy_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_user_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetUserPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_access_keys_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListAccessKeysOutput, crate::error::ListAccessKeysError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListAccessKeysError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListAccessKeysError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::ListAccessKeysError {
            meta: generic,
            kind: crate::error::ListAccessKeysErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListAccessKeysError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::ListAccessKeysError {
            meta: generic,
            kind: crate::error::ListAccessKeysErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListAccessKeysError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListAccessKeysError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_access_keys_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListAccessKeysOutput, crate::error::ListAccessKeysError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_access_keys_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_access_keys(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListAccessKeysError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_account_aliases_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAccountAliasesOutput,
    crate::error::ListAccountAliasesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListAccountAliasesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListAccountAliasesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ServiceFailure" => crate::error::ListAccountAliasesError {
            meta: generic,
            kind: crate::error::ListAccountAliasesErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListAccountAliasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListAccountAliasesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_account_aliases_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAccountAliasesOutput,
    crate::error::ListAccountAliasesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_account_aliases_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_account_aliases(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListAccountAliasesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_attached_group_policies_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAttachedGroupPoliciesOutput,
    crate::error::ListAttachedGroupPoliciesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListAttachedGroupPoliciesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListAttachedGroupPoliciesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::ListAttachedGroupPoliciesError {
            meta: generic,
            kind: crate::error::ListAttachedGroupPoliciesErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListAttachedGroupPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::ListAttachedGroupPoliciesError {
            meta: generic,
            kind: crate::error::ListAttachedGroupPoliciesErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListAttachedGroupPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::ListAttachedGroupPoliciesError {
            meta: generic,
            kind: crate::error::ListAttachedGroupPoliciesErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListAttachedGroupPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListAttachedGroupPoliciesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_attached_group_policies_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAttachedGroupPoliciesOutput,
    crate::error::ListAttachedGroupPoliciesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_attached_group_policies_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_attached_group_policies(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListAttachedGroupPoliciesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_attached_role_policies_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAttachedRolePoliciesOutput,
    crate::error::ListAttachedRolePoliciesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListAttachedRolePoliciesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListAttachedRolePoliciesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::ListAttachedRolePoliciesError {
            meta: generic,
            kind: crate::error::ListAttachedRolePoliciesErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListAttachedRolePoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::ListAttachedRolePoliciesError {
            meta: generic,
            kind: crate::error::ListAttachedRolePoliciesErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListAttachedRolePoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::ListAttachedRolePoliciesError {
            meta: generic,
            kind: crate::error::ListAttachedRolePoliciesErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListAttachedRolePoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListAttachedRolePoliciesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_attached_role_policies_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAttachedRolePoliciesOutput,
    crate::error::ListAttachedRolePoliciesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_attached_role_policies_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_attached_role_policies(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListAttachedRolePoliciesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_attached_user_policies_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAttachedUserPoliciesOutput,
    crate::error::ListAttachedUserPoliciesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListAttachedUserPoliciesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListAttachedUserPoliciesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::ListAttachedUserPoliciesError {
            meta: generic,
            kind: crate::error::ListAttachedUserPoliciesErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListAttachedUserPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::ListAttachedUserPoliciesError {
            meta: generic,
            kind: crate::error::ListAttachedUserPoliciesErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListAttachedUserPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::ListAttachedUserPoliciesError {
            meta: generic,
            kind: crate::error::ListAttachedUserPoliciesErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListAttachedUserPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListAttachedUserPoliciesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_attached_user_policies_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListAttachedUserPoliciesOutput,
    crate::error::ListAttachedUserPoliciesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_attached_user_policies_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_attached_user_policies(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListAttachedUserPoliciesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_entities_for_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListEntitiesForPolicyOutput,
    crate::error::ListEntitiesForPolicyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListEntitiesForPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListEntitiesForPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::ListEntitiesForPolicyError {
            meta: generic,
            kind: crate::error::ListEntitiesForPolicyErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListEntitiesForPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::ListEntitiesForPolicyError {
            meta: generic,
            kind: crate::error::ListEntitiesForPolicyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListEntitiesForPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::ListEntitiesForPolicyError {
            meta: generic,
            kind: crate::error::ListEntitiesForPolicyErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListEntitiesForPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListEntitiesForPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_entities_for_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListEntitiesForPolicyOutput,
    crate::error::ListEntitiesForPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_entities_for_policy_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_entities_for_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListEntitiesForPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_group_policies_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListGroupPoliciesOutput, crate::error::ListGroupPoliciesError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListGroupPoliciesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListGroupPoliciesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::ListGroupPoliciesError {
            meta: generic,
            kind: crate::error::ListGroupPoliciesErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListGroupPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::ListGroupPoliciesError {
            meta: generic,
            kind: crate::error::ListGroupPoliciesErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListGroupPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListGroupPoliciesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_group_policies_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListGroupPoliciesOutput, crate::error::ListGroupPoliciesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_group_policies_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_group_policies(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListGroupPoliciesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListGroupsOutput, crate::error::ListGroupsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListGroupsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ServiceFailure" => crate::error::ListGroupsError {
            meta: generic,
            kind: crate::error::ListGroupsErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListGroupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListGroupsOutput, crate::error::ListGroupsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_groups_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_groups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_groups_for_user_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListGroupsForUserOutput, crate::error::ListGroupsForUserError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListGroupsForUserError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListGroupsForUserError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::ListGroupsForUserError {
            meta: generic,
            kind: crate::error::ListGroupsForUserErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListGroupsForUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::ListGroupsForUserError {
            meta: generic,
            kind: crate::error::ListGroupsForUserErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListGroupsForUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListGroupsForUserError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_groups_for_user_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListGroupsForUserOutput, crate::error::ListGroupsForUserError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_groups_for_user_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_groups_for_user(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListGroupsForUserError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_instance_profiles_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListInstanceProfilesOutput,
    crate::error::ListInstanceProfilesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListInstanceProfilesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListInstanceProfilesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ServiceFailure" => crate::error::ListInstanceProfilesError {
            meta: generic,
            kind: crate::error::ListInstanceProfilesErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListInstanceProfilesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListInstanceProfilesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_instance_profiles_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListInstanceProfilesOutput,
    crate::error::ListInstanceProfilesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_instance_profiles_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_instance_profiles(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListInstanceProfilesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_instance_profiles_for_role_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListInstanceProfilesForRoleOutput,
    crate::error::ListInstanceProfilesForRoleError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListInstanceProfilesForRoleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListInstanceProfilesForRoleError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::ListInstanceProfilesForRoleError {
            meta: generic,
            kind: crate::error::ListInstanceProfilesForRoleErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListInstanceProfilesForRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::ListInstanceProfilesForRoleError {
            meta: generic,
            kind: crate::error::ListInstanceProfilesForRoleErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListInstanceProfilesForRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListInstanceProfilesForRoleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_instance_profiles_for_role_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListInstanceProfilesForRoleOutput,
    crate::error::ListInstanceProfilesForRoleError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_instance_profiles_for_role_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_instance_profiles_for_role(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListInstanceProfilesForRoleError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_instance_profile_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListInstanceProfileTagsOutput,
    crate::error::ListInstanceProfileTagsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListInstanceProfileTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListInstanceProfileTagsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::ListInstanceProfileTagsError {
            meta: generic,
            kind: crate::error::ListInstanceProfileTagsErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListInstanceProfileTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::ListInstanceProfileTagsError {
            meta: generic,
            kind: crate::error::ListInstanceProfileTagsErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListInstanceProfileTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListInstanceProfileTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_instance_profile_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListInstanceProfileTagsOutput,
    crate::error::ListInstanceProfileTagsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_instance_profile_tags_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_instance_profile_tags(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListInstanceProfileTagsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_mfa_devices_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListMfaDevicesOutput, crate::error::ListMFADevicesError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListMFADevicesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListMFADevicesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::ListMFADevicesError {
            meta: generic,
            kind: crate::error::ListMFADevicesErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListMFADevicesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::ListMFADevicesError {
            meta: generic,
            kind: crate::error::ListMFADevicesErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListMFADevicesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListMFADevicesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_mfa_devices_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListMfaDevicesOutput, crate::error::ListMFADevicesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_mfa_devices_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_mfa_devices(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListMFADevicesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_mfa_device_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListMfaDeviceTagsOutput, crate::error::ListMFADeviceTagsError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListMFADeviceTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListMFADeviceTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::ListMFADeviceTagsError {
            meta: generic,
            kind: crate::error::ListMFADeviceTagsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListMFADeviceTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::ListMFADeviceTagsError {
            meta: generic,
            kind: crate::error::ListMFADeviceTagsErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListMFADeviceTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::ListMFADeviceTagsError {
            meta: generic,
            kind: crate::error::ListMFADeviceTagsErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListMFADeviceTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListMFADeviceTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_mfa_device_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListMfaDeviceTagsOutput, crate::error::ListMFADeviceTagsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_mfa_device_tags_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_mfa_device_tags(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListMFADeviceTagsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_open_id_connect_providers_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListOpenIdConnectProvidersOutput,
    crate::error::ListOpenIDConnectProvidersError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListOpenIDConnectProvidersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListOpenIDConnectProvidersError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ServiceFailure" => crate::error::ListOpenIDConnectProvidersError {
            meta: generic,
            kind: crate::error::ListOpenIDConnectProvidersErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListOpenIDConnectProvidersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListOpenIDConnectProvidersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_open_id_connect_providers_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListOpenIdConnectProvidersOutput,
    crate::error::ListOpenIDConnectProvidersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_open_id_connect_providers_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_open_id_connect_providers(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListOpenIDConnectProvidersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_open_id_connect_provider_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListOpenIdConnectProviderTagsOutput,
    crate::error::ListOpenIDConnectProviderTagsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListOpenIDConnectProviderTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListOpenIDConnectProviderTagsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::ListOpenIDConnectProviderTagsError {
            meta: generic,
            kind: crate::error::ListOpenIDConnectProviderTagsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListOpenIDConnectProviderTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::ListOpenIDConnectProviderTagsError {
            meta: generic,
            kind: crate::error::ListOpenIDConnectProviderTagsErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListOpenIDConnectProviderTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::ListOpenIDConnectProviderTagsError {
            meta: generic,
            kind: crate::error::ListOpenIDConnectProviderTagsErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListOpenIDConnectProviderTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListOpenIDConnectProviderTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_open_id_connect_provider_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListOpenIdConnectProviderTagsOutput,
    crate::error::ListOpenIDConnectProviderTagsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_open_id_connect_provider_tags_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_list_open_id_connect_provider_tags(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListOpenIDConnectProviderTagsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_policies_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListPoliciesOutput, crate::error::ListPoliciesError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPoliciesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListPoliciesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ServiceFailure" => crate::error::ListPoliciesError {
            meta: generic,
            kind: crate::error::ListPoliciesErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListPoliciesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_policies_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListPoliciesOutput, crate::error::ListPoliciesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_policies_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_policies(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListPoliciesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_policies_granting_service_access_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPoliciesGrantingServiceAccessOutput,
    crate::error::ListPoliciesGrantingServiceAccessError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPoliciesGrantingServiceAccessError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListPoliciesGrantingServiceAccessError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::ListPoliciesGrantingServiceAccessError {
            meta: generic,
            kind: crate::error::ListPoliciesGrantingServiceAccessErrorKind::InvalidInputException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_input_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListPoliciesGrantingServiceAccessError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "NoSuchEntity" => crate::error::ListPoliciesGrantingServiceAccessError {
            meta: generic,
            kind: crate::error::ListPoliciesGrantingServiceAccessErrorKind::NoSuchEntityException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::no_such_entity_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListPoliciesGrantingServiceAccessError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::ListPoliciesGrantingServiceAccessError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_policies_granting_service_access_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPoliciesGrantingServiceAccessOutput,
    crate::error::ListPoliciesGrantingServiceAccessError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_policies_granting_service_access_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_policies_granting_service_access(response.body().as_ref(), output).map_err(crate::error::ListPoliciesGrantingServiceAccessError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_policy_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListPolicyTagsOutput, crate::error::ListPolicyTagsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPolicyTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListPolicyTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::ListPolicyTagsError {
            meta: generic,
            kind: crate::error::ListPolicyTagsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListPolicyTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::ListPolicyTagsError {
            meta: generic,
            kind: crate::error::ListPolicyTagsErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListPolicyTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::ListPolicyTagsError {
            meta: generic,
            kind: crate::error::ListPolicyTagsErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListPolicyTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListPolicyTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_policy_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListPolicyTagsOutput, crate::error::ListPolicyTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_policy_tags_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_policy_tags(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListPolicyTagsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_policy_versions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPolicyVersionsOutput,
    crate::error::ListPolicyVersionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListPolicyVersionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListPolicyVersionsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::ListPolicyVersionsError {
            meta: generic,
            kind: crate::error::ListPolicyVersionsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListPolicyVersionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::ListPolicyVersionsError {
            meta: generic,
            kind: crate::error::ListPolicyVersionsErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListPolicyVersionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::ListPolicyVersionsError {
            meta: generic,
            kind: crate::error::ListPolicyVersionsErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListPolicyVersionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListPolicyVersionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_policy_versions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListPolicyVersionsOutput,
    crate::error::ListPolicyVersionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_policy_versions_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_policy_versions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListPolicyVersionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_role_policies_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListRolePoliciesOutput, crate::error::ListRolePoliciesError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListRolePoliciesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListRolePoliciesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::ListRolePoliciesError {
            meta: generic,
            kind: crate::error::ListRolePoliciesErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListRolePoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::ListRolePoliciesError {
            meta: generic,
            kind: crate::error::ListRolePoliciesErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListRolePoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListRolePoliciesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_role_policies_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListRolePoliciesOutput, crate::error::ListRolePoliciesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_role_policies_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_role_policies(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListRolePoliciesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_roles_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListRolesOutput, crate::error::ListRolesError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListRolesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListRolesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ServiceFailure" => crate::error::ListRolesError {
            meta: generic,
            kind: crate::error::ListRolesErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListRolesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListRolesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_roles_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListRolesOutput, crate::error::ListRolesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_roles_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_roles(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListRolesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_role_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListRoleTagsOutput, crate::error::ListRoleTagsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListRoleTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListRoleTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::ListRoleTagsError {
            meta: generic,
            kind: crate::error::ListRoleTagsErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListRoleTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::ListRoleTagsError {
            meta: generic,
            kind: crate::error::ListRoleTagsErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListRoleTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListRoleTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_role_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListRoleTagsOutput, crate::error::ListRoleTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_role_tags_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_role_tags(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListRoleTagsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_saml_providers_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListSamlProvidersOutput, crate::error::ListSAMLProvidersError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListSAMLProvidersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListSAMLProvidersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ServiceFailure" => crate::error::ListSAMLProvidersError {
            meta: generic,
            kind: crate::error::ListSAMLProvidersErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListSAMLProvidersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListSAMLProvidersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_saml_providers_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListSamlProvidersOutput, crate::error::ListSAMLProvidersError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_saml_providers_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_saml_providers(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListSAMLProvidersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_saml_provider_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSamlProviderTagsOutput,
    crate::error::ListSAMLProviderTagsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListSAMLProviderTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListSAMLProviderTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::ListSAMLProviderTagsError {
            meta: generic,
            kind: crate::error::ListSAMLProviderTagsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListSAMLProviderTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::ListSAMLProviderTagsError {
            meta: generic,
            kind: crate::error::ListSAMLProviderTagsErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListSAMLProviderTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::ListSAMLProviderTagsError {
            meta: generic,
            kind: crate::error::ListSAMLProviderTagsErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListSAMLProviderTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListSAMLProviderTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_saml_provider_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSamlProviderTagsOutput,
    crate::error::ListSAMLProviderTagsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_saml_provider_tags_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_saml_provider_tags(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListSAMLProviderTagsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_server_certificates_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListServerCertificatesOutput,
    crate::error::ListServerCertificatesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListServerCertificatesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListServerCertificatesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ServiceFailure" => crate::error::ListServerCertificatesError {
            meta: generic,
            kind: crate::error::ListServerCertificatesErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListServerCertificatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListServerCertificatesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_server_certificates_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListServerCertificatesOutput,
    crate::error::ListServerCertificatesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_server_certificates_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_server_certificates(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListServerCertificatesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_server_certificate_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListServerCertificateTagsOutput,
    crate::error::ListServerCertificateTagsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListServerCertificateTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListServerCertificateTagsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::ListServerCertificateTagsError {
            meta: generic,
            kind: crate::error::ListServerCertificateTagsErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListServerCertificateTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::ListServerCertificateTagsError {
            meta: generic,
            kind: crate::error::ListServerCertificateTagsErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListServerCertificateTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListServerCertificateTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_server_certificate_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListServerCertificateTagsOutput,
    crate::error::ListServerCertificateTagsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_server_certificate_tags_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_server_certificate_tags(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListServerCertificateTagsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_service_specific_credentials_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListServiceSpecificCredentialsOutput,
    crate::error::ListServiceSpecificCredentialsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListServiceSpecificCredentialsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListServiceSpecificCredentialsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::ListServiceSpecificCredentialsError {
            meta: generic,
            kind: crate::error::ListServiceSpecificCredentialsErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListServiceSpecificCredentialsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotSupportedService" => crate::error::ListServiceSpecificCredentialsError {
            meta: generic,
            kind:
                crate::error::ListServiceSpecificCredentialsErrorKind::ServiceNotSupportedException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::service_not_supported_exception::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_service_not_supported_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListServiceSpecificCredentialsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::ListServiceSpecificCredentialsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_service_specific_credentials_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListServiceSpecificCredentialsOutput,
    crate::error::ListServiceSpecificCredentialsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::list_service_specific_credentials_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_list_service_specific_credentials(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ListServiceSpecificCredentialsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_signing_certificates_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSigningCertificatesOutput,
    crate::error::ListSigningCertificatesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListSigningCertificatesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListSigningCertificatesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::ListSigningCertificatesError {
            meta: generic,
            kind: crate::error::ListSigningCertificatesErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListSigningCertificatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::ListSigningCertificatesError {
            meta: generic,
            kind: crate::error::ListSigningCertificatesErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListSigningCertificatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListSigningCertificatesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_signing_certificates_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListSigningCertificatesOutput,
    crate::error::ListSigningCertificatesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_signing_certificates_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_signing_certificates(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListSigningCertificatesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_ssh_public_keys_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListSshPublicKeysOutput, crate::error::ListSSHPublicKeysError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListSSHPublicKeysError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListSSHPublicKeysError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::ListSSHPublicKeysError {
            meta: generic,
            kind: crate::error::ListSSHPublicKeysErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListSSHPublicKeysError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListSSHPublicKeysError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_ssh_public_keys_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListSshPublicKeysOutput, crate::error::ListSSHPublicKeysError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_ssh_public_keys_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_ssh_public_keys(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListSSHPublicKeysError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_user_policies_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListUserPoliciesOutput, crate::error::ListUserPoliciesError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListUserPoliciesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListUserPoliciesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::ListUserPoliciesError {
            meta: generic,
            kind: crate::error::ListUserPoliciesErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListUserPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::ListUserPoliciesError {
            meta: generic,
            kind: crate::error::ListUserPoliciesErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListUserPoliciesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListUserPoliciesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_user_policies_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListUserPoliciesOutput, crate::error::ListUserPoliciesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_user_policies_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_user_policies(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListUserPoliciesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_users_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListUsersOutput, crate::error::ListUsersError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListUsersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListUsersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ServiceFailure" => crate::error::ListUsersError {
            meta: generic,
            kind: crate::error::ListUsersErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListUsersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListUsersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_users_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListUsersOutput, crate::error::ListUsersError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_users_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_users(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListUsersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_user_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListUserTagsOutput, crate::error::ListUserTagsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListUserTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListUserTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::ListUserTagsError {
            meta: generic,
            kind: crate::error::ListUserTagsErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListUserTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::ListUserTagsError {
            meta: generic,
            kind: crate::error::ListUserTagsErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListUserTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListUserTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_user_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListUserTagsOutput, crate::error::ListUserTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_user_tags_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_user_tags(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListUserTagsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_virtual_mfa_devices_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListVirtualMfaDevicesOutput,
    crate::error::ListVirtualMFADevicesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListVirtualMFADevicesError::unhandled)?;
    Err(crate::error::ListVirtualMFADevicesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_virtual_mfa_devices_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListVirtualMfaDevicesOutput,
    crate::error::ListVirtualMFADevicesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_virtual_mfa_devices_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_virtual_mfa_devices(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListVirtualMFADevicesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_group_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutGroupPolicyOutput, crate::error::PutGroupPolicyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutGroupPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutGroupPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceeded" => crate::error::PutGroupPolicyError {
            meta: generic,
            kind: crate::error::PutGroupPolicyErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutGroupPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MalformedPolicyDocument" => crate::error::PutGroupPolicyError {
            meta: generic,
            kind: crate::error::PutGroupPolicyErrorKind::MalformedPolicyDocumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::malformed_policy_document_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_malformed_policy_document_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutGroupPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::PutGroupPolicyError {
            meta: generic,
            kind: crate::error::PutGroupPolicyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutGroupPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::PutGroupPolicyError {
            meta: generic,
            kind: crate::error::PutGroupPolicyErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutGroupPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutGroupPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_group_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutGroupPolicyOutput, crate::error::PutGroupPolicyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_group_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_role_permissions_boundary_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutRolePermissionsBoundaryOutput,
    crate::error::PutRolePermissionsBoundaryError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutRolePermissionsBoundaryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::PutRolePermissionsBoundaryError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::PutRolePermissionsBoundaryError {
            meta: generic,
            kind: crate::error::PutRolePermissionsBoundaryErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutRolePermissionsBoundaryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::PutRolePermissionsBoundaryError {
            meta: generic,
            kind: crate::error::PutRolePermissionsBoundaryErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutRolePermissionsBoundaryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PolicyNotAttachable" => crate::error::PutRolePermissionsBoundaryError {
            meta: generic,
            kind: crate::error::PutRolePermissionsBoundaryErrorKind::PolicyNotAttachableException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::policy_not_attachable_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_policy_not_attachable_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutRolePermissionsBoundaryError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ServiceFailure" => crate::error::PutRolePermissionsBoundaryError {
            meta: generic,
            kind: crate::error::PutRolePermissionsBoundaryErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutRolePermissionsBoundaryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnmodifiableEntity" => crate::error::PutRolePermissionsBoundaryError {
            meta: generic,
            kind: crate::error::PutRolePermissionsBoundaryErrorKind::UnmodifiableEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unmodifiable_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unmodifiable_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutRolePermissionsBoundaryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutRolePermissionsBoundaryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_role_permissions_boundary_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutRolePermissionsBoundaryOutput,
    crate::error::PutRolePermissionsBoundaryError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_role_permissions_boundary_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_role_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutRolePolicyOutput, crate::error::PutRolePolicyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutRolePolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutRolePolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceeded" => crate::error::PutRolePolicyError {
            meta: generic,
            kind: crate::error::PutRolePolicyErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutRolePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MalformedPolicyDocument" => crate::error::PutRolePolicyError {
            meta: generic,
            kind: crate::error::PutRolePolicyErrorKind::MalformedPolicyDocumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::malformed_policy_document_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_malformed_policy_document_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutRolePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::PutRolePolicyError {
            meta: generic,
            kind: crate::error::PutRolePolicyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutRolePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::PutRolePolicyError {
            meta: generic,
            kind: crate::error::PutRolePolicyErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutRolePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnmodifiableEntity" => crate::error::PutRolePolicyError {
            meta: generic,
            kind: crate::error::PutRolePolicyErrorKind::UnmodifiableEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unmodifiable_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unmodifiable_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutRolePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutRolePolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_role_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutRolePolicyOutput, crate::error::PutRolePolicyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_role_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_user_permissions_boundary_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutUserPermissionsBoundaryOutput,
    crate::error::PutUserPermissionsBoundaryError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutUserPermissionsBoundaryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::PutUserPermissionsBoundaryError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::PutUserPermissionsBoundaryError {
            meta: generic,
            kind: crate::error::PutUserPermissionsBoundaryErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutUserPermissionsBoundaryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::PutUserPermissionsBoundaryError {
            meta: generic,
            kind: crate::error::PutUserPermissionsBoundaryErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutUserPermissionsBoundaryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PolicyNotAttachable" => crate::error::PutUserPermissionsBoundaryError {
            meta: generic,
            kind: crate::error::PutUserPermissionsBoundaryErrorKind::PolicyNotAttachableException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::policy_not_attachable_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_policy_not_attachable_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutUserPermissionsBoundaryError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ServiceFailure" => crate::error::PutUserPermissionsBoundaryError {
            meta: generic,
            kind: crate::error::PutUserPermissionsBoundaryErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutUserPermissionsBoundaryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutUserPermissionsBoundaryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_user_permissions_boundary_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutUserPermissionsBoundaryOutput,
    crate::error::PutUserPermissionsBoundaryError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_user_permissions_boundary_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_user_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutUserPolicyOutput, crate::error::PutUserPolicyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutUserPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutUserPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceeded" => crate::error::PutUserPolicyError {
            meta: generic,
            kind: crate::error::PutUserPolicyErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutUserPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MalformedPolicyDocument" => crate::error::PutUserPolicyError {
            meta: generic,
            kind: crate::error::PutUserPolicyErrorKind::MalformedPolicyDocumentException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::malformed_policy_document_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_malformed_policy_document_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutUserPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::PutUserPolicyError {
            meta: generic,
            kind: crate::error::PutUserPolicyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutUserPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::PutUserPolicyError {
            meta: generic,
            kind: crate::error::PutUserPolicyErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutUserPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutUserPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_user_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutUserPolicyOutput, crate::error::PutUserPolicyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_user_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_client_id_from_open_id_connect_provider_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveClientIdFromOpenIdConnectProviderOutput,
    crate::error::RemoveClientIDFromOpenIDConnectProviderError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RemoveClientIDFromOpenIDConnectProviderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::RemoveClientIDFromOpenIDConnectProviderError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::RemoveClientIDFromOpenIDConnectProviderError { meta: generic, kind: crate::error::RemoveClientIDFromOpenIDConnectProviderErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveClientIDFromOpenIDConnectProviderError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchEntity" => crate::error::RemoveClientIDFromOpenIDConnectProviderError { meta: generic, kind: crate::error::RemoveClientIDFromOpenIDConnectProviderErrorKind::NoSuchEntityException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveClientIDFromOpenIDConnectProviderError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceFailure" => crate::error::RemoveClientIDFromOpenIDConnectProviderError { meta: generic, kind: crate::error::RemoveClientIDFromOpenIDConnectProviderErrorKind::ServiceFailureException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveClientIDFromOpenIDConnectProviderError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::RemoveClientIDFromOpenIDConnectProviderError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_client_id_from_open_id_connect_provider_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveClientIdFromOpenIdConnectProviderOutput,
    crate::error::RemoveClientIDFromOpenIDConnectProviderError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::remove_client_id_from_open_id_connect_provider_output::Builder::default(
            );
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_role_from_instance_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveRoleFromInstanceProfileOutput,
    crate::error::RemoveRoleFromInstanceProfileError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RemoveRoleFromInstanceProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RemoveRoleFromInstanceProfileError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceeded" => crate::error::RemoveRoleFromInstanceProfileError {
            meta: generic,
            kind: crate::error::RemoveRoleFromInstanceProfileErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveRoleFromInstanceProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::RemoveRoleFromInstanceProfileError {
            meta: generic,
            kind: crate::error::RemoveRoleFromInstanceProfileErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveRoleFromInstanceProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::RemoveRoleFromInstanceProfileError {
            meta: generic,
            kind: crate::error::RemoveRoleFromInstanceProfileErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveRoleFromInstanceProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnmodifiableEntity" => crate::error::RemoveRoleFromInstanceProfileError {
            meta: generic,
            kind: crate::error::RemoveRoleFromInstanceProfileErrorKind::UnmodifiableEntityException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::unmodifiable_entity_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_unmodifiable_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveRoleFromInstanceProfileError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::RemoveRoleFromInstanceProfileError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_role_from_instance_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveRoleFromInstanceProfileOutput,
    crate::error::RemoveRoleFromInstanceProfileError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::remove_role_from_instance_profile_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_user_from_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveUserFromGroupOutput,
    crate::error::RemoveUserFromGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RemoveUserFromGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RemoveUserFromGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceeded" => crate::error::RemoveUserFromGroupError {
            meta: generic,
            kind: crate::error::RemoveUserFromGroupErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveUserFromGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::RemoveUserFromGroupError {
            meta: generic,
            kind: crate::error::RemoveUserFromGroupErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveUserFromGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::RemoveUserFromGroupError {
            meta: generic,
            kind: crate::error::RemoveUserFromGroupErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveUserFromGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RemoveUserFromGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_user_from_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveUserFromGroupOutput,
    crate::error::RemoveUserFromGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::remove_user_from_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reset_service_specific_credential_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ResetServiceSpecificCredentialOutput,
    crate::error::ResetServiceSpecificCredentialError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ResetServiceSpecificCredentialError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ResetServiceSpecificCredentialError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::ResetServiceSpecificCredentialError {
            meta: generic,
            kind: crate::error::ResetServiceSpecificCredentialErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ResetServiceSpecificCredentialError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ResetServiceSpecificCredentialError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reset_service_specific_credential_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ResetServiceSpecificCredentialOutput,
    crate::error::ResetServiceSpecificCredentialError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::reset_service_specific_credential_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_reset_service_specific_credential(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ResetServiceSpecificCredentialError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_resync_mfa_device_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ResyncMfaDeviceOutput, crate::error::ResyncMFADeviceError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ResyncMFADeviceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ResyncMFADeviceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidAuthenticationCode" => crate::error::ResyncMFADeviceError {
            meta: generic,
            kind: crate::error::ResyncMFADeviceErrorKind::InvalidAuthenticationCodeException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_authentication_code_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_authentication_code_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ResyncMFADeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::ResyncMFADeviceError {
            meta: generic,
            kind: crate::error::ResyncMFADeviceErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ResyncMFADeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::ResyncMFADeviceError {
            meta: generic,
            kind: crate::error::ResyncMFADeviceErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ResyncMFADeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::ResyncMFADeviceError {
            meta: generic,
            kind: crate::error::ResyncMFADeviceErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ResyncMFADeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ResyncMFADeviceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_resync_mfa_device_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ResyncMfaDeviceOutput, crate::error::ResyncMFADeviceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::resync_mfa_device_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_default_policy_version_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetDefaultPolicyVersionOutput,
    crate::error::SetDefaultPolicyVersionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetDefaultPolicyVersionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::SetDefaultPolicyVersionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::SetDefaultPolicyVersionError {
            meta: generic,
            kind: crate::error::SetDefaultPolicyVersionErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetDefaultPolicyVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::SetDefaultPolicyVersionError {
            meta: generic,
            kind: crate::error::SetDefaultPolicyVersionErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetDefaultPolicyVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::SetDefaultPolicyVersionError {
            meta: generic,
            kind: crate::error::SetDefaultPolicyVersionErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetDefaultPolicyVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::SetDefaultPolicyVersionError {
            meta: generic,
            kind: crate::error::SetDefaultPolicyVersionErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetDefaultPolicyVersionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SetDefaultPolicyVersionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_default_policy_version_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetDefaultPolicyVersionOutput,
    crate::error::SetDefaultPolicyVersionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_default_policy_version_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_security_token_service_preferences_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetSecurityTokenServicePreferencesOutput,
    crate::error::SetSecurityTokenServicePreferencesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetSecurityTokenServicePreferencesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::SetSecurityTokenServicePreferencesError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ServiceFailure" => crate::error::SetSecurityTokenServicePreferencesError {
            meta: generic,
            kind:
                crate::error::SetSecurityTokenServicePreferencesErrorKind::ServiceFailureException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::service_failure_exception::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SetSecurityTokenServicePreferencesError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::SetSecurityTokenServicePreferencesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_security_token_service_preferences_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetSecurityTokenServicePreferencesOutput,
    crate::error::SetSecurityTokenServicePreferencesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::set_security_token_service_preferences_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_simulate_custom_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SimulateCustomPolicyOutput,
    crate::error::SimulateCustomPolicyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SimulateCustomPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SimulateCustomPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::SimulateCustomPolicyError {
            meta: generic,
            kind: crate::error::SimulateCustomPolicyErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SimulateCustomPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PolicyEvaluation" => crate::error::SimulateCustomPolicyError {
            meta: generic,
            kind: crate::error::SimulateCustomPolicyErrorKind::PolicyEvaluationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::policy_evaluation_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_policy_evaluation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SimulateCustomPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SimulateCustomPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_simulate_custom_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SimulateCustomPolicyOutput,
    crate::error::SimulateCustomPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::simulate_custom_policy_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_simulate_custom_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SimulateCustomPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_simulate_principal_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SimulatePrincipalPolicyOutput,
    crate::error::SimulatePrincipalPolicyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SimulatePrincipalPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::SimulatePrincipalPolicyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::SimulatePrincipalPolicyError {
            meta: generic,
            kind: crate::error::SimulatePrincipalPolicyErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SimulatePrincipalPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::SimulatePrincipalPolicyError {
            meta: generic,
            kind: crate::error::SimulatePrincipalPolicyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SimulatePrincipalPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PolicyEvaluation" => crate::error::SimulatePrincipalPolicyError {
            meta: generic,
            kind: crate::error::SimulatePrincipalPolicyErrorKind::PolicyEvaluationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::policy_evaluation_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_policy_evaluation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::SimulatePrincipalPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SimulatePrincipalPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_simulate_principal_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SimulatePrincipalPolicyOutput,
    crate::error::SimulatePrincipalPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::simulate_principal_policy_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_simulate_principal_policy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SimulatePrincipalPolicyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_instance_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::TagInstanceProfileOutput,
    crate::error::TagInstanceProfileError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagInstanceProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagInstanceProfileError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModification" => crate::error::TagInstanceProfileError {
            meta: generic,
            kind: crate::error::TagInstanceProfileErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_concurrent_modification_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagInstanceProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInput" => crate::error::TagInstanceProfileError {
            meta: generic,
            kind: crate::error::TagInstanceProfileErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagInstanceProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::TagInstanceProfileError {
            meta: generic,
            kind: crate::error::TagInstanceProfileErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagInstanceProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::TagInstanceProfileError {
            meta: generic,
            kind: crate::error::TagInstanceProfileErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagInstanceProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::TagInstanceProfileError {
            meta: generic,
            kind: crate::error::TagInstanceProfileErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagInstanceProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagInstanceProfileError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_instance_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::TagInstanceProfileOutput,
    crate::error::TagInstanceProfileError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_instance_profile_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_mfa_device_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagMfaDeviceOutput, crate::error::TagMFADeviceError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagMFADeviceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagMFADeviceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModification" => crate::error::TagMFADeviceError {
            meta: generic,
            kind: crate::error::TagMFADeviceErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_concurrent_modification_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagMFADeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInput" => crate::error::TagMFADeviceError {
            meta: generic,
            kind: crate::error::TagMFADeviceErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagMFADeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::TagMFADeviceError {
            meta: generic,
            kind: crate::error::TagMFADeviceErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagMFADeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::TagMFADeviceError {
            meta: generic,
            kind: crate::error::TagMFADeviceErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagMFADeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::TagMFADeviceError {
            meta: generic,
            kind: crate::error::TagMFADeviceErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagMFADeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagMFADeviceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_mfa_device_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagMfaDeviceOutput, crate::error::TagMFADeviceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_mfa_device_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_open_id_connect_provider_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::TagOpenIdConnectProviderOutput,
    crate::error::TagOpenIDConnectProviderError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagOpenIDConnectProviderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::TagOpenIDConnectProviderError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModification" => crate::error::TagOpenIDConnectProviderError {
            meta: generic,
            kind: crate::error::TagOpenIDConnectProviderErrorKind::ConcurrentModificationException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::concurrent_modification_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_concurrent_modification_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagOpenIDConnectProviderError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidInput" => crate::error::TagOpenIDConnectProviderError {
            meta: generic,
            kind: crate::error::TagOpenIDConnectProviderErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagOpenIDConnectProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::TagOpenIDConnectProviderError {
            meta: generic,
            kind: crate::error::TagOpenIDConnectProviderErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagOpenIDConnectProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::TagOpenIDConnectProviderError {
            meta: generic,
            kind: crate::error::TagOpenIDConnectProviderErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagOpenIDConnectProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::TagOpenIDConnectProviderError {
            meta: generic,
            kind: crate::error::TagOpenIDConnectProviderErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagOpenIDConnectProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagOpenIDConnectProviderError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_open_id_connect_provider_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::TagOpenIdConnectProviderOutput,
    crate::error::TagOpenIDConnectProviderError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_open_id_connect_provider_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagPolicyOutput, crate::error::TagPolicyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModification" => crate::error::TagPolicyError {
            meta: generic,
            kind: crate::error::TagPolicyErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_concurrent_modification_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInput" => crate::error::TagPolicyError {
            meta: generic,
            kind: crate::error::TagPolicyErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::TagPolicyError {
            meta: generic,
            kind: crate::error::TagPolicyErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::TagPolicyError {
            meta: generic,
            kind: crate::error::TagPolicyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::TagPolicyError {
            meta: generic,
            kind: crate::error::TagPolicyErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagPolicyOutput, crate::error::TagPolicyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_role_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagRoleOutput, crate::error::TagRoleError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagRoleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagRoleError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModification" => crate::error::TagRoleError {
            meta: generic,
            kind: crate::error::TagRoleErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_concurrent_modification_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInput" => crate::error::TagRoleError {
            meta: generic,
            kind: crate::error::TagRoleErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::TagRoleError {
            meta: generic,
            kind: crate::error::TagRoleErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::TagRoleError {
            meta: generic,
            kind: crate::error::TagRoleErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::TagRoleError {
            meta: generic,
            kind: crate::error::TagRoleErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagRoleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_role_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagRoleOutput, crate::error::TagRoleError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_role_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_saml_provider_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagSamlProviderOutput, crate::error::TagSAMLProviderError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagSAMLProviderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagSAMLProviderError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModification" => crate::error::TagSAMLProviderError {
            meta: generic,
            kind: crate::error::TagSAMLProviderErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_concurrent_modification_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagSAMLProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInput" => crate::error::TagSAMLProviderError {
            meta: generic,
            kind: crate::error::TagSAMLProviderErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagSAMLProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::TagSAMLProviderError {
            meta: generic,
            kind: crate::error::TagSAMLProviderErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagSAMLProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::TagSAMLProviderError {
            meta: generic,
            kind: crate::error::TagSAMLProviderErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagSAMLProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::TagSAMLProviderError {
            meta: generic,
            kind: crate::error::TagSAMLProviderErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagSAMLProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagSAMLProviderError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_saml_provider_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagSamlProviderOutput, crate::error::TagSAMLProviderError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_saml_provider_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_server_certificate_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::TagServerCertificateOutput,
    crate::error::TagServerCertificateError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagServerCertificateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagServerCertificateError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModification" => crate::error::TagServerCertificateError {
            meta: generic,
            kind: crate::error::TagServerCertificateErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_concurrent_modification_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagServerCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInput" => crate::error::TagServerCertificateError {
            meta: generic,
            kind: crate::error::TagServerCertificateErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagServerCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::TagServerCertificateError {
            meta: generic,
            kind: crate::error::TagServerCertificateErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagServerCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::TagServerCertificateError {
            meta: generic,
            kind: crate::error::TagServerCertificateErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagServerCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::TagServerCertificateError {
            meta: generic,
            kind: crate::error::TagServerCertificateErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagServerCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagServerCertificateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_server_certificate_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::TagServerCertificateOutput,
    crate::error::TagServerCertificateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_server_certificate_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_user_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagUserOutput, crate::error::TagUserError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagUserError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagUserError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModification" => crate::error::TagUserError {
            meta: generic,
            kind: crate::error::TagUserErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_concurrent_modification_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInput" => crate::error::TagUserError {
            meta: generic,
            kind: crate::error::TagUserErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::TagUserError {
            meta: generic,
            kind: crate::error::TagUserErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::TagUserError {
            meta: generic,
            kind: crate::error::TagUserErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::TagUserError {
            meta: generic,
            kind: crate::error::TagUserErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagUserError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_user_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagUserOutput, crate::error::TagUserError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_user_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_instance_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UntagInstanceProfileOutput,
    crate::error::UntagInstanceProfileError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagInstanceProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagInstanceProfileError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModification" => crate::error::UntagInstanceProfileError {
            meta: generic,
            kind: crate::error::UntagInstanceProfileErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_concurrent_modification_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagInstanceProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInput" => crate::error::UntagInstanceProfileError {
            meta: generic,
            kind: crate::error::UntagInstanceProfileErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagInstanceProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::UntagInstanceProfileError {
            meta: generic,
            kind: crate::error::UntagInstanceProfileErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagInstanceProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::UntagInstanceProfileError {
            meta: generic,
            kind: crate::error::UntagInstanceProfileErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagInstanceProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagInstanceProfileError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_instance_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UntagInstanceProfileOutput,
    crate::error::UntagInstanceProfileError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_instance_profile_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_mfa_device_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagMfaDeviceOutput, crate::error::UntagMFADeviceError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagMFADeviceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagMFADeviceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModification" => crate::error::UntagMFADeviceError {
            meta: generic,
            kind: crate::error::UntagMFADeviceErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_concurrent_modification_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagMFADeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInput" => crate::error::UntagMFADeviceError {
            meta: generic,
            kind: crate::error::UntagMFADeviceErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagMFADeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::UntagMFADeviceError {
            meta: generic,
            kind: crate::error::UntagMFADeviceErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagMFADeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::UntagMFADeviceError {
            meta: generic,
            kind: crate::error::UntagMFADeviceErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagMFADeviceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagMFADeviceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_mfa_device_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagMfaDeviceOutput, crate::error::UntagMFADeviceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_mfa_device_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_open_id_connect_provider_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UntagOpenIdConnectProviderOutput,
    crate::error::UntagOpenIDConnectProviderError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagOpenIDConnectProviderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UntagOpenIDConnectProviderError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModification" => crate::error::UntagOpenIDConnectProviderError {
            meta: generic,
            kind:
                crate::error::UntagOpenIDConnectProviderErrorKind::ConcurrentModificationException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::concurrent_modification_exception::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_concurrent_modification_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagOpenIDConnectProviderError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidInput" => crate::error::UntagOpenIDConnectProviderError {
            meta: generic,
            kind: crate::error::UntagOpenIDConnectProviderErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagOpenIDConnectProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::UntagOpenIDConnectProviderError {
            meta: generic,
            kind: crate::error::UntagOpenIDConnectProviderErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagOpenIDConnectProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::UntagOpenIDConnectProviderError {
            meta: generic,
            kind: crate::error::UntagOpenIDConnectProviderErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagOpenIDConnectProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagOpenIDConnectProviderError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_open_id_connect_provider_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UntagOpenIdConnectProviderOutput,
    crate::error::UntagOpenIDConnectProviderError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_open_id_connect_provider_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagPolicyOutput, crate::error::UntagPolicyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagPolicyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModification" => crate::error::UntagPolicyError {
            meta: generic,
            kind: crate::error::UntagPolicyErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_concurrent_modification_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInput" => crate::error::UntagPolicyError {
            meta: generic,
            kind: crate::error::UntagPolicyErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::UntagPolicyError {
            meta: generic,
            kind: crate::error::UntagPolicyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::UntagPolicyError {
            meta: generic,
            kind: crate::error::UntagPolicyErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagPolicyOutput, crate::error::UntagPolicyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_role_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagRoleOutput, crate::error::UntagRoleError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagRoleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagRoleError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModification" => crate::error::UntagRoleError {
            meta: generic,
            kind: crate::error::UntagRoleErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_concurrent_modification_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::UntagRoleError {
            meta: generic,
            kind: crate::error::UntagRoleErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::UntagRoleError {
            meta: generic,
            kind: crate::error::UntagRoleErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagRoleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_role_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagRoleOutput, crate::error::UntagRoleError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_role_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_saml_provider_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagSamlProviderOutput, crate::error::UntagSAMLProviderError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagSAMLProviderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagSAMLProviderError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModification" => crate::error::UntagSAMLProviderError {
            meta: generic,
            kind: crate::error::UntagSAMLProviderErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_concurrent_modification_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagSAMLProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInput" => crate::error::UntagSAMLProviderError {
            meta: generic,
            kind: crate::error::UntagSAMLProviderErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagSAMLProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::UntagSAMLProviderError {
            meta: generic,
            kind: crate::error::UntagSAMLProviderErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagSAMLProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::UntagSAMLProviderError {
            meta: generic,
            kind: crate::error::UntagSAMLProviderErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagSAMLProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagSAMLProviderError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_saml_provider_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagSamlProviderOutput, crate::error::UntagSAMLProviderError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_saml_provider_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_server_certificate_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UntagServerCertificateOutput,
    crate::error::UntagServerCertificateError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagServerCertificateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UntagServerCertificateError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModification" => crate::error::UntagServerCertificateError {
            meta: generic,
            kind: crate::error::UntagServerCertificateErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_concurrent_modification_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagServerCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInput" => crate::error::UntagServerCertificateError {
            meta: generic,
            kind: crate::error::UntagServerCertificateErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagServerCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::UntagServerCertificateError {
            meta: generic,
            kind: crate::error::UntagServerCertificateErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagServerCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::UntagServerCertificateError {
            meta: generic,
            kind: crate::error::UntagServerCertificateErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagServerCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagServerCertificateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_server_certificate_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UntagServerCertificateOutput,
    crate::error::UntagServerCertificateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_server_certificate_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_user_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagUserOutput, crate::error::UntagUserError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagUserError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagUserError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModification" => crate::error::UntagUserError {
            meta: generic,
            kind: crate::error::UntagUserErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_concurrent_modification_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::UntagUserError {
            meta: generic,
            kind: crate::error::UntagUserErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::UntagUserError {
            meta: generic,
            kind: crate::error::UntagUserErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagUserError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_user_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagUserOutput, crate::error::UntagUserError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_user_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_access_key_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateAccessKeyOutput, crate::error::UpdateAccessKeyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateAccessKeyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateAccessKeyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceeded" => crate::error::UpdateAccessKeyError {
            meta: generic,
            kind: crate::error::UpdateAccessKeyErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateAccessKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::UpdateAccessKeyError {
            meta: generic,
            kind: crate::error::UpdateAccessKeyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateAccessKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::UpdateAccessKeyError {
            meta: generic,
            kind: crate::error::UpdateAccessKeyErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateAccessKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateAccessKeyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_access_key_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateAccessKeyOutput, crate::error::UpdateAccessKeyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_access_key_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_account_password_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateAccountPasswordPolicyOutput,
    crate::error::UpdateAccountPasswordPolicyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateAccountPasswordPolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateAccountPasswordPolicyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceeded" => crate::error::UpdateAccountPasswordPolicyError {
            meta: generic,
            kind: crate::error::UpdateAccountPasswordPolicyErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateAccountPasswordPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MalformedPolicyDocument" => crate::error::UpdateAccountPasswordPolicyError {
            meta: generic,
            kind:
                crate::error::UpdateAccountPasswordPolicyErrorKind::MalformedPolicyDocumentException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::malformed_policy_document_exception::Builder::default(
                                );
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_malformed_policy_document_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateAccountPasswordPolicyError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "NoSuchEntity" => crate::error::UpdateAccountPasswordPolicyError {
            meta: generic,
            kind: crate::error::UpdateAccountPasswordPolicyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateAccountPasswordPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::UpdateAccountPasswordPolicyError {
            meta: generic,
            kind: crate::error::UpdateAccountPasswordPolicyErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateAccountPasswordPolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateAccountPasswordPolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_account_password_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateAccountPasswordPolicyOutput,
    crate::error::UpdateAccountPasswordPolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_account_password_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_assume_role_policy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateAssumeRolePolicyOutput,
    crate::error::UpdateAssumeRolePolicyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateAssumeRolePolicyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateAssumeRolePolicyError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceeded" => crate::error::UpdateAssumeRolePolicyError {
            meta: generic,
            kind: crate::error::UpdateAssumeRolePolicyErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateAssumeRolePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MalformedPolicyDocument" => crate::error::UpdateAssumeRolePolicyError {
            meta: generic,
            kind: crate::error::UpdateAssumeRolePolicyErrorKind::MalformedPolicyDocumentException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::malformed_policy_document_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_malformed_policy_document_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateAssumeRolePolicyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "NoSuchEntity" => crate::error::UpdateAssumeRolePolicyError {
            meta: generic,
            kind: crate::error::UpdateAssumeRolePolicyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateAssumeRolePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::UpdateAssumeRolePolicyError {
            meta: generic,
            kind: crate::error::UpdateAssumeRolePolicyErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateAssumeRolePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnmodifiableEntity" => crate::error::UpdateAssumeRolePolicyError {
            meta: generic,
            kind: crate::error::UpdateAssumeRolePolicyErrorKind::UnmodifiableEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unmodifiable_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unmodifiable_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateAssumeRolePolicyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateAssumeRolePolicyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_assume_role_policy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateAssumeRolePolicyOutput,
    crate::error::UpdateAssumeRolePolicyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_assume_role_policy_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateGroupOutput, crate::error::UpdateGroupError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "EntityAlreadyExists" => crate::error::UpdateGroupError {
            meta: generic,
            kind: crate::error::UpdateGroupErrorKind::EntityAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_entity_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::UpdateGroupError {
            meta: generic,
            kind: crate::error::UpdateGroupErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::UpdateGroupError {
            meta: generic,
            kind: crate::error::UpdateGroupErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::UpdateGroupError {
            meta: generic,
            kind: crate::error::UpdateGroupErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateGroupOutput, crate::error::UpdateGroupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_login_profile_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateLoginProfileOutput,
    crate::error::UpdateLoginProfileError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateLoginProfileError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateLoginProfileError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "EntityTemporarilyUnmodifiable" => crate::error::UpdateLoginProfileError {
            meta: generic,
            kind: crate::error::UpdateLoginProfileErrorKind::EntityTemporarilyUnmodifiableException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::entity_temporarily_unmodifiable_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_entity_temporarily_unmodifiable_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateLoginProfileError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "LimitExceeded" => crate::error::UpdateLoginProfileError {
            meta: generic,
            kind: crate::error::UpdateLoginProfileErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateLoginProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::UpdateLoginProfileError {
            meta: generic,
            kind: crate::error::UpdateLoginProfileErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateLoginProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PasswordPolicyViolation" => crate::error::UpdateLoginProfileError {
            meta: generic,
            kind: crate::error::UpdateLoginProfileErrorKind::PasswordPolicyViolationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::password_policy_violation_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_password_policy_violation_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateLoginProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::UpdateLoginProfileError {
            meta: generic,
            kind: crate::error::UpdateLoginProfileErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateLoginProfileError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateLoginProfileError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_login_profile_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateLoginProfileOutput,
    crate::error::UpdateLoginProfileError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_login_profile_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_open_id_connect_provider_thumbprint_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateOpenIdConnectProviderThumbprintOutput,
    crate::error::UpdateOpenIDConnectProviderThumbprintError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateOpenIDConnectProviderThumbprintError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::UpdateOpenIDConnectProviderThumbprintError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::UpdateOpenIDConnectProviderThumbprintError { meta: generic, kind: crate::error::UpdateOpenIDConnectProviderThumbprintErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateOpenIDConnectProviderThumbprintError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NoSuchEntity" => crate::error::UpdateOpenIDConnectProviderThumbprintError { meta: generic, kind: crate::error::UpdateOpenIDConnectProviderThumbprintErrorKind::NoSuchEntityException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateOpenIDConnectProviderThumbprintError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceFailure" => crate::error::UpdateOpenIDConnectProviderThumbprintError { meta: generic, kind: crate::error::UpdateOpenIDConnectProviderThumbprintErrorKind::ServiceFailureException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateOpenIDConnectProviderThumbprintError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::UpdateOpenIDConnectProviderThumbprintError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_open_id_connect_provider_thumbprint_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateOpenIdConnectProviderThumbprintOutput,
    crate::error::UpdateOpenIDConnectProviderThumbprintError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::update_open_id_connect_provider_thumbprint_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_role_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateRoleOutput, crate::error::UpdateRoleError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateRoleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateRoleError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::UpdateRoleError {
            meta: generic,
            kind: crate::error::UpdateRoleErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::UpdateRoleError {
            meta: generic,
            kind: crate::error::UpdateRoleErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnmodifiableEntity" => crate::error::UpdateRoleError {
            meta: generic,
            kind: crate::error::UpdateRoleErrorKind::UnmodifiableEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unmodifiable_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unmodifiable_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateRoleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateRoleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_role_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateRoleOutput, crate::error::UpdateRoleError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_role_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_role_description_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateRoleDescriptionOutput,
    crate::error::UpdateRoleDescriptionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateRoleDescriptionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateRoleDescriptionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::UpdateRoleDescriptionError {
            meta: generic,
            kind: crate::error::UpdateRoleDescriptionErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateRoleDescriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::UpdateRoleDescriptionError {
            meta: generic,
            kind: crate::error::UpdateRoleDescriptionErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateRoleDescriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnmodifiableEntity" => crate::error::UpdateRoleDescriptionError {
            meta: generic,
            kind: crate::error::UpdateRoleDescriptionErrorKind::UnmodifiableEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unmodifiable_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_unmodifiable_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateRoleDescriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateRoleDescriptionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_role_description_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateRoleDescriptionOutput,
    crate::error::UpdateRoleDescriptionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_role_description_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_update_role_description(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateRoleDescriptionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_saml_provider_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateSamlProviderOutput,
    crate::error::UpdateSAMLProviderError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateSAMLProviderError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateSAMLProviderError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidInput" => crate::error::UpdateSAMLProviderError {
            meta: generic,
            kind: crate::error::UpdateSAMLProviderErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateSAMLProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::UpdateSAMLProviderError {
            meta: generic,
            kind: crate::error::UpdateSAMLProviderErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateSAMLProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::UpdateSAMLProviderError {
            meta: generic,
            kind: crate::error::UpdateSAMLProviderErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateSAMLProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::UpdateSAMLProviderError {
            meta: generic,
            kind: crate::error::UpdateSAMLProviderErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateSAMLProviderError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateSAMLProviderError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_saml_provider_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateSamlProviderOutput,
    crate::error::UpdateSAMLProviderError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_saml_provider_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_update_saml_provider(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateSAMLProviderError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_server_certificate_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateServerCertificateOutput,
    crate::error::UpdateServerCertificateError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateServerCertificateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateServerCertificateError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "EntityAlreadyExists" => crate::error::UpdateServerCertificateError {
            meta: generic,
            kind: crate::error::UpdateServerCertificateErrorKind::EntityAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_entity_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateServerCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::UpdateServerCertificateError {
            meta: generic,
            kind: crate::error::UpdateServerCertificateErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateServerCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::UpdateServerCertificateError {
            meta: generic,
            kind: crate::error::UpdateServerCertificateErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateServerCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::UpdateServerCertificateError {
            meta: generic,
            kind: crate::error::UpdateServerCertificateErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateServerCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateServerCertificateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_server_certificate_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateServerCertificateOutput,
    crate::error::UpdateServerCertificateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_server_certificate_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_service_specific_credential_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateServiceSpecificCredentialOutput,
    crate::error::UpdateServiceSpecificCredentialError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateServiceSpecificCredentialError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateServiceSpecificCredentialError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::UpdateServiceSpecificCredentialError {
            meta: generic,
            kind: crate::error::UpdateServiceSpecificCredentialErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateServiceSpecificCredentialError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateServiceSpecificCredentialError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_service_specific_credential_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateServiceSpecificCredentialOutput,
    crate::error::UpdateServiceSpecificCredentialError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::update_service_specific_credential_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_signing_certificate_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateSigningCertificateOutput,
    crate::error::UpdateSigningCertificateError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateSigningCertificateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateSigningCertificateError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceeded" => crate::error::UpdateSigningCertificateError {
            meta: generic,
            kind: crate::error::UpdateSigningCertificateErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateSigningCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::UpdateSigningCertificateError {
            meta: generic,
            kind: crate::error::UpdateSigningCertificateErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateSigningCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::UpdateSigningCertificateError {
            meta: generic,
            kind: crate::error::UpdateSigningCertificateErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateSigningCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateSigningCertificateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_signing_certificate_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateSigningCertificateOutput,
    crate::error::UpdateSigningCertificateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_signing_certificate_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_ssh_public_key_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateSshPublicKeyOutput,
    crate::error::UpdateSSHPublicKeyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateSSHPublicKeyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateSSHPublicKeyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NoSuchEntity" => crate::error::UpdateSSHPublicKeyError {
            meta: generic,
            kind: crate::error::UpdateSSHPublicKeyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateSSHPublicKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateSSHPublicKeyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_ssh_public_key_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateSshPublicKeyOutput,
    crate::error::UpdateSSHPublicKeyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_ssh_public_key_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_user_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateUserOutput, crate::error::UpdateUserError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateUserError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateUserError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModification" => crate::error::UpdateUserError {
            meta: generic,
            kind: crate::error::UpdateUserErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_concurrent_modification_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EntityAlreadyExists" => crate::error::UpdateUserError {
            meta: generic,
            kind: crate::error::UpdateUserErrorKind::EntityAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_entity_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EntityTemporarilyUnmodifiable" => {
            crate::error::UpdateUserError {
                meta: generic,
                kind: crate::error::UpdateUserErrorKind::EntityTemporarilyUnmodifiableException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::entity_temporarily_unmodifiable_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_entity_temporarily_unmodifiable_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "LimitExceeded" => crate::error::UpdateUserError {
            meta: generic,
            kind: crate::error::UpdateUserErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::UpdateUserError {
            meta: generic,
            kind: crate::error::UpdateUserErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::UpdateUserError {
            meta: generic,
            kind: crate::error::UpdateUserErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UpdateUserError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateUserError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_user_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateUserOutput, crate::error::UpdateUserError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_user_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_upload_server_certificate_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UploadServerCertificateOutput,
    crate::error::UploadServerCertificateError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UploadServerCertificateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UploadServerCertificateError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModification" => crate::error::UploadServerCertificateError {
            meta: generic,
            kind: crate::error::UploadServerCertificateErrorKind::ConcurrentModificationException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::concurrent_modification_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_concurrent_modification_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UploadServerCertificateError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "EntityAlreadyExists" => crate::error::UploadServerCertificateError {
            meta: generic,
            kind: crate::error::UploadServerCertificateErrorKind::EntityAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_entity_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UploadServerCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInput" => crate::error::UploadServerCertificateError {
            meta: generic,
            kind: crate::error::UploadServerCertificateErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_input_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UploadServerCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KeyPairMismatch" => crate::error::UploadServerCertificateError {
            meta: generic,
            kind: crate::error::UploadServerCertificateErrorKind::KeyPairMismatchException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::key_pair_mismatch_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_key_pair_mismatch_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UploadServerCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::UploadServerCertificateError {
            meta: generic,
            kind: crate::error::UploadServerCertificateErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UploadServerCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MalformedCertificate" => crate::error::UploadServerCertificateError {
            meta: generic,
            kind: crate::error::UploadServerCertificateErrorKind::MalformedCertificateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::malformed_certificate_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_malformed_certificate_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UploadServerCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::UploadServerCertificateError {
            meta: generic,
            kind: crate::error::UploadServerCertificateErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UploadServerCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UploadServerCertificateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_upload_server_certificate_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UploadServerCertificateOutput,
    crate::error::UploadServerCertificateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::upload_server_certificate_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_upload_server_certificate(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UploadServerCertificateError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_upload_signing_certificate_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UploadSigningCertificateOutput,
    crate::error::UploadSigningCertificateError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UploadSigningCertificateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UploadSigningCertificateError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DuplicateCertificate" => crate::error::UploadSigningCertificateError {
            meta: generic,
            kind: crate::error::UploadSigningCertificateErrorKind::DuplicateCertificateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::duplicate_certificate_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_duplicate_certificate_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UploadSigningCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "EntityAlreadyExists" => crate::error::UploadSigningCertificateError {
            meta: generic,
            kind: crate::error::UploadSigningCertificateErrorKind::EntityAlreadyExistsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::entity_already_exists_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_entity_already_exists_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UploadSigningCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidCertificate" => crate::error::UploadSigningCertificateError {
            meta: generic,
            kind: crate::error::UploadSigningCertificateErrorKind::InvalidCertificateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_certificate_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_certificate_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UploadSigningCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::UploadSigningCertificateError {
            meta: generic,
            kind: crate::error::UploadSigningCertificateErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UploadSigningCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MalformedCertificate" => crate::error::UploadSigningCertificateError {
            meta: generic,
            kind: crate::error::UploadSigningCertificateErrorKind::MalformedCertificateException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::malformed_certificate_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_malformed_certificate_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UploadSigningCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::UploadSigningCertificateError {
            meta: generic,
            kind: crate::error::UploadSigningCertificateErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UploadSigningCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceFailure" => crate::error::UploadSigningCertificateError {
            meta: generic,
            kind: crate::error::UploadSigningCertificateErrorKind::ServiceFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::service_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_service_failure_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UploadSigningCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UploadSigningCertificateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_upload_signing_certificate_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UploadSigningCertificateOutput,
    crate::error::UploadSigningCertificateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::upload_signing_certificate_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_upload_signing_certificate(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UploadSigningCertificateError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_upload_ssh_public_key_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UploadSshPublicKeyOutput,
    crate::error::UploadSSHPublicKeyError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UploadSSHPublicKeyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UploadSSHPublicKeyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DuplicateSSHPublicKey" => crate::error::UploadSSHPublicKeyError {
            meta: generic,
            kind: crate::error::UploadSSHPublicKeyErrorKind::DuplicateSshPublicKeyException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::duplicate_ssh_public_key_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_duplicate_ssh_public_key_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UploadSSHPublicKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidPublicKey" => crate::error::UploadSSHPublicKeyError {
            meta: generic,
            kind: crate::error::UploadSSHPublicKeyErrorKind::InvalidPublicKeyException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_public_key_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_public_key_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UploadSSHPublicKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceeded" => crate::error::UploadSSHPublicKeyError {
            meta: generic,
            kind: crate::error::UploadSSHPublicKeyErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UploadSSHPublicKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NoSuchEntity" => crate::error::UploadSSHPublicKeyError {
            meta: generic,
            kind: crate::error::UploadSSHPublicKeyErrorKind::NoSuchEntityException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::no_such_entity_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_no_such_entity_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UploadSSHPublicKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnrecognizedPublicKeyEncoding" => crate::error::UploadSSHPublicKeyError {
            meta: generic,
            kind: crate::error::UploadSSHPublicKeyErrorKind::UnrecognizedPublicKeyEncodingException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::unrecognized_public_key_encoding_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_unrecognized_public_key_encoding_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UploadSSHPublicKeyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::UploadSSHPublicKeyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_upload_ssh_public_key_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UploadSshPublicKeyOutput,
    crate::error::UploadSSHPublicKeyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::upload_ssh_public_key_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_upload_ssh_public_key(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UploadSSHPublicKeyError::unhandled)?;
        output.build()
    })
}
