// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AWSIdentityManagementV20100508`.
///
/// This client allows ergonomic access to a `AWSIdentityManagementV20100508`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AddClientIDToOpenIDConnectProvider` operation.
    ///
    /// See [`AddClientIDToOpenIDConnectProvider`](crate::client::fluent_builders::AddClientIDToOpenIDConnectProvider) for more information about the
    /// operation and its arguments.
    pub fn add_client_id_to_open_id_connect_provider(
        &self,
    ) -> fluent_builders::AddClientIDToOpenIDConnectProvider<C, M, R> {
        fluent_builders::AddClientIDToOpenIDConnectProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AddRoleToInstanceProfile` operation.
    ///
    /// See [`AddRoleToInstanceProfile`](crate::client::fluent_builders::AddRoleToInstanceProfile) for more information about the
    /// operation and its arguments.
    pub fn add_role_to_instance_profile(
        &self,
    ) -> fluent_builders::AddRoleToInstanceProfile<C, M, R> {
        fluent_builders::AddRoleToInstanceProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AddUserToGroup` operation.
    ///
    /// See [`AddUserToGroup`](crate::client::fluent_builders::AddUserToGroup) for more information about the
    /// operation and its arguments.
    pub fn add_user_to_group(&self) -> fluent_builders::AddUserToGroup<C, M, R> {
        fluent_builders::AddUserToGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AttachGroupPolicy` operation.
    ///
    /// See [`AttachGroupPolicy`](crate::client::fluent_builders::AttachGroupPolicy) for more information about the
    /// operation and its arguments.
    pub fn attach_group_policy(&self) -> fluent_builders::AttachGroupPolicy<C, M, R> {
        fluent_builders::AttachGroupPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AttachRolePolicy` operation.
    ///
    /// See [`AttachRolePolicy`](crate::client::fluent_builders::AttachRolePolicy) for more information about the
    /// operation and its arguments.
    pub fn attach_role_policy(&self) -> fluent_builders::AttachRolePolicy<C, M, R> {
        fluent_builders::AttachRolePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AttachUserPolicy` operation.
    ///
    /// See [`AttachUserPolicy`](crate::client::fluent_builders::AttachUserPolicy) for more information about the
    /// operation and its arguments.
    pub fn attach_user_policy(&self) -> fluent_builders::AttachUserPolicy<C, M, R> {
        fluent_builders::AttachUserPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ChangePassword` operation.
    ///
    /// See [`ChangePassword`](crate::client::fluent_builders::ChangePassword) for more information about the
    /// operation and its arguments.
    pub fn change_password(&self) -> fluent_builders::ChangePassword<C, M, R> {
        fluent_builders::ChangePassword::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAccessKey` operation.
    ///
    /// See [`CreateAccessKey`](crate::client::fluent_builders::CreateAccessKey) for more information about the
    /// operation and its arguments.
    pub fn create_access_key(&self) -> fluent_builders::CreateAccessKey<C, M, R> {
        fluent_builders::CreateAccessKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAccountAlias` operation.
    ///
    /// See [`CreateAccountAlias`](crate::client::fluent_builders::CreateAccountAlias) for more information about the
    /// operation and its arguments.
    pub fn create_account_alias(&self) -> fluent_builders::CreateAccountAlias<C, M, R> {
        fluent_builders::CreateAccountAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateGroup` operation.
    ///
    /// See [`CreateGroup`](crate::client::fluent_builders::CreateGroup) for more information about the
    /// operation and its arguments.
    pub fn create_group(&self) -> fluent_builders::CreateGroup<C, M, R> {
        fluent_builders::CreateGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateInstanceProfile` operation.
    ///
    /// See [`CreateInstanceProfile`](crate::client::fluent_builders::CreateInstanceProfile) for more information about the
    /// operation and its arguments.
    pub fn create_instance_profile(&self) -> fluent_builders::CreateInstanceProfile<C, M, R> {
        fluent_builders::CreateInstanceProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLoginProfile` operation.
    ///
    /// See [`CreateLoginProfile`](crate::client::fluent_builders::CreateLoginProfile) for more information about the
    /// operation and its arguments.
    pub fn create_login_profile(&self) -> fluent_builders::CreateLoginProfile<C, M, R> {
        fluent_builders::CreateLoginProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateOpenIDConnectProvider` operation.
    ///
    /// See [`CreateOpenIDConnectProvider`](crate::client::fluent_builders::CreateOpenIDConnectProvider) for more information about the
    /// operation and its arguments.
    pub fn create_open_id_connect_provider(
        &self,
    ) -> fluent_builders::CreateOpenIDConnectProvider<C, M, R> {
        fluent_builders::CreateOpenIDConnectProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePolicy` operation.
    ///
    /// See [`CreatePolicy`](crate::client::fluent_builders::CreatePolicy) for more information about the
    /// operation and its arguments.
    pub fn create_policy(&self) -> fluent_builders::CreatePolicy<C, M, R> {
        fluent_builders::CreatePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePolicyVersion` operation.
    ///
    /// See [`CreatePolicyVersion`](crate::client::fluent_builders::CreatePolicyVersion) for more information about the
    /// operation and its arguments.
    pub fn create_policy_version(&self) -> fluent_builders::CreatePolicyVersion<C, M, R> {
        fluent_builders::CreatePolicyVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRole` operation.
    ///
    /// See [`CreateRole`](crate::client::fluent_builders::CreateRole) for more information about the
    /// operation and its arguments.
    pub fn create_role(&self) -> fluent_builders::CreateRole<C, M, R> {
        fluent_builders::CreateRole::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSAMLProvider` operation.
    ///
    /// See [`CreateSAMLProvider`](crate::client::fluent_builders::CreateSAMLProvider) for more information about the
    /// operation and its arguments.
    pub fn create_saml_provider(&self) -> fluent_builders::CreateSAMLProvider<C, M, R> {
        fluent_builders::CreateSAMLProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateServiceLinkedRole` operation.
    ///
    /// See [`CreateServiceLinkedRole`](crate::client::fluent_builders::CreateServiceLinkedRole) for more information about the
    /// operation and its arguments.
    pub fn create_service_linked_role(&self) -> fluent_builders::CreateServiceLinkedRole<C, M, R> {
        fluent_builders::CreateServiceLinkedRole::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateServiceSpecificCredential` operation.
    ///
    /// See [`CreateServiceSpecificCredential`](crate::client::fluent_builders::CreateServiceSpecificCredential) for more information about the
    /// operation and its arguments.
    pub fn create_service_specific_credential(
        &self,
    ) -> fluent_builders::CreateServiceSpecificCredential<C, M, R> {
        fluent_builders::CreateServiceSpecificCredential::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateUser` operation.
    ///
    /// See [`CreateUser`](crate::client::fluent_builders::CreateUser) for more information about the
    /// operation and its arguments.
    pub fn create_user(&self) -> fluent_builders::CreateUser<C, M, R> {
        fluent_builders::CreateUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateVirtualMFADevice` operation.
    ///
    /// See [`CreateVirtualMFADevice`](crate::client::fluent_builders::CreateVirtualMFADevice) for more information about the
    /// operation and its arguments.
    pub fn create_virtual_mfa_device(&self) -> fluent_builders::CreateVirtualMFADevice<C, M, R> {
        fluent_builders::CreateVirtualMFADevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeactivateMFADevice` operation.
    ///
    /// See [`DeactivateMFADevice`](crate::client::fluent_builders::DeactivateMFADevice) for more information about the
    /// operation and its arguments.
    pub fn deactivate_mfa_device(&self) -> fluent_builders::DeactivateMFADevice<C, M, R> {
        fluent_builders::DeactivateMFADevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAccessKey` operation.
    ///
    /// See [`DeleteAccessKey`](crate::client::fluent_builders::DeleteAccessKey) for more information about the
    /// operation and its arguments.
    pub fn delete_access_key(&self) -> fluent_builders::DeleteAccessKey<C, M, R> {
        fluent_builders::DeleteAccessKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAccountAlias` operation.
    ///
    /// See [`DeleteAccountAlias`](crate::client::fluent_builders::DeleteAccountAlias) for more information about the
    /// operation and its arguments.
    pub fn delete_account_alias(&self) -> fluent_builders::DeleteAccountAlias<C, M, R> {
        fluent_builders::DeleteAccountAlias::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAccountPasswordPolicy` operation.
    ///
    /// See [`DeleteAccountPasswordPolicy`](crate::client::fluent_builders::DeleteAccountPasswordPolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_account_password_policy(
        &self,
    ) -> fluent_builders::DeleteAccountPasswordPolicy<C, M, R> {
        fluent_builders::DeleteAccountPasswordPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteGroup` operation.
    ///
    /// See [`DeleteGroup`](crate::client::fluent_builders::DeleteGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_group(&self) -> fluent_builders::DeleteGroup<C, M, R> {
        fluent_builders::DeleteGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteGroupPolicy` operation.
    ///
    /// See [`DeleteGroupPolicy`](crate::client::fluent_builders::DeleteGroupPolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_group_policy(&self) -> fluent_builders::DeleteGroupPolicy<C, M, R> {
        fluent_builders::DeleteGroupPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteInstanceProfile` operation.
    ///
    /// See [`DeleteInstanceProfile`](crate::client::fluent_builders::DeleteInstanceProfile) for more information about the
    /// operation and its arguments.
    pub fn delete_instance_profile(&self) -> fluent_builders::DeleteInstanceProfile<C, M, R> {
        fluent_builders::DeleteInstanceProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLoginProfile` operation.
    ///
    /// See [`DeleteLoginProfile`](crate::client::fluent_builders::DeleteLoginProfile) for more information about the
    /// operation and its arguments.
    pub fn delete_login_profile(&self) -> fluent_builders::DeleteLoginProfile<C, M, R> {
        fluent_builders::DeleteLoginProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteOpenIDConnectProvider` operation.
    ///
    /// See [`DeleteOpenIDConnectProvider`](crate::client::fluent_builders::DeleteOpenIDConnectProvider) for more information about the
    /// operation and its arguments.
    pub fn delete_open_id_connect_provider(
        &self,
    ) -> fluent_builders::DeleteOpenIDConnectProvider<C, M, R> {
        fluent_builders::DeleteOpenIDConnectProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePolicy` operation.
    ///
    /// See [`DeletePolicy`](crate::client::fluent_builders::DeletePolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_policy(&self) -> fluent_builders::DeletePolicy<C, M, R> {
        fluent_builders::DeletePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePolicyVersion` operation.
    ///
    /// See [`DeletePolicyVersion`](crate::client::fluent_builders::DeletePolicyVersion) for more information about the
    /// operation and its arguments.
    pub fn delete_policy_version(&self) -> fluent_builders::DeletePolicyVersion<C, M, R> {
        fluent_builders::DeletePolicyVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRole` operation.
    ///
    /// See [`DeleteRole`](crate::client::fluent_builders::DeleteRole) for more information about the
    /// operation and its arguments.
    pub fn delete_role(&self) -> fluent_builders::DeleteRole<C, M, R> {
        fluent_builders::DeleteRole::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRolePermissionsBoundary` operation.
    ///
    /// See [`DeleteRolePermissionsBoundary`](crate::client::fluent_builders::DeleteRolePermissionsBoundary) for more information about the
    /// operation and its arguments.
    pub fn delete_role_permissions_boundary(
        &self,
    ) -> fluent_builders::DeleteRolePermissionsBoundary<C, M, R> {
        fluent_builders::DeleteRolePermissionsBoundary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRolePolicy` operation.
    ///
    /// See [`DeleteRolePolicy`](crate::client::fluent_builders::DeleteRolePolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_role_policy(&self) -> fluent_builders::DeleteRolePolicy<C, M, R> {
        fluent_builders::DeleteRolePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSAMLProvider` operation.
    ///
    /// See [`DeleteSAMLProvider`](crate::client::fluent_builders::DeleteSAMLProvider) for more information about the
    /// operation and its arguments.
    pub fn delete_saml_provider(&self) -> fluent_builders::DeleteSAMLProvider<C, M, R> {
        fluent_builders::DeleteSAMLProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteServerCertificate` operation.
    ///
    /// See [`DeleteServerCertificate`](crate::client::fluent_builders::DeleteServerCertificate) for more information about the
    /// operation and its arguments.
    pub fn delete_server_certificate(&self) -> fluent_builders::DeleteServerCertificate<C, M, R> {
        fluent_builders::DeleteServerCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteServiceLinkedRole` operation.
    ///
    /// See [`DeleteServiceLinkedRole`](crate::client::fluent_builders::DeleteServiceLinkedRole) for more information about the
    /// operation and its arguments.
    pub fn delete_service_linked_role(&self) -> fluent_builders::DeleteServiceLinkedRole<C, M, R> {
        fluent_builders::DeleteServiceLinkedRole::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteServiceSpecificCredential` operation.
    ///
    /// See [`DeleteServiceSpecificCredential`](crate::client::fluent_builders::DeleteServiceSpecificCredential) for more information about the
    /// operation and its arguments.
    pub fn delete_service_specific_credential(
        &self,
    ) -> fluent_builders::DeleteServiceSpecificCredential<C, M, R> {
        fluent_builders::DeleteServiceSpecificCredential::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSigningCertificate` operation.
    ///
    /// See [`DeleteSigningCertificate`](crate::client::fluent_builders::DeleteSigningCertificate) for more information about the
    /// operation and its arguments.
    pub fn delete_signing_certificate(&self) -> fluent_builders::DeleteSigningCertificate<C, M, R> {
        fluent_builders::DeleteSigningCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSSHPublicKey` operation.
    ///
    /// See [`DeleteSSHPublicKey`](crate::client::fluent_builders::DeleteSSHPublicKey) for more information about the
    /// operation and its arguments.
    pub fn delete_ssh_public_key(&self) -> fluent_builders::DeleteSSHPublicKey<C, M, R> {
        fluent_builders::DeleteSSHPublicKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteUser` operation.
    ///
    /// See [`DeleteUser`](crate::client::fluent_builders::DeleteUser) for more information about the
    /// operation and its arguments.
    pub fn delete_user(&self) -> fluent_builders::DeleteUser<C, M, R> {
        fluent_builders::DeleteUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteUserPermissionsBoundary` operation.
    ///
    /// See [`DeleteUserPermissionsBoundary`](crate::client::fluent_builders::DeleteUserPermissionsBoundary) for more information about the
    /// operation and its arguments.
    pub fn delete_user_permissions_boundary(
        &self,
    ) -> fluent_builders::DeleteUserPermissionsBoundary<C, M, R> {
        fluent_builders::DeleteUserPermissionsBoundary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteUserPolicy` operation.
    ///
    /// See [`DeleteUserPolicy`](crate::client::fluent_builders::DeleteUserPolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_user_policy(&self) -> fluent_builders::DeleteUserPolicy<C, M, R> {
        fluent_builders::DeleteUserPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteVirtualMFADevice` operation.
    ///
    /// See [`DeleteVirtualMFADevice`](crate::client::fluent_builders::DeleteVirtualMFADevice) for more information about the
    /// operation and its arguments.
    pub fn delete_virtual_mfa_device(&self) -> fluent_builders::DeleteVirtualMFADevice<C, M, R> {
        fluent_builders::DeleteVirtualMFADevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetachGroupPolicy` operation.
    ///
    /// See [`DetachGroupPolicy`](crate::client::fluent_builders::DetachGroupPolicy) for more information about the
    /// operation and its arguments.
    pub fn detach_group_policy(&self) -> fluent_builders::DetachGroupPolicy<C, M, R> {
        fluent_builders::DetachGroupPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetachRolePolicy` operation.
    ///
    /// See [`DetachRolePolicy`](crate::client::fluent_builders::DetachRolePolicy) for more information about the
    /// operation and its arguments.
    pub fn detach_role_policy(&self) -> fluent_builders::DetachRolePolicy<C, M, R> {
        fluent_builders::DetachRolePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetachUserPolicy` operation.
    ///
    /// See [`DetachUserPolicy`](crate::client::fluent_builders::DetachUserPolicy) for more information about the
    /// operation and its arguments.
    pub fn detach_user_policy(&self) -> fluent_builders::DetachUserPolicy<C, M, R> {
        fluent_builders::DetachUserPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableMFADevice` operation.
    ///
    /// See [`EnableMFADevice`](crate::client::fluent_builders::EnableMFADevice) for more information about the
    /// operation and its arguments.
    pub fn enable_mfa_device(&self) -> fluent_builders::EnableMFADevice<C, M, R> {
        fluent_builders::EnableMFADevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GenerateCredentialReport` operation.
    ///
    /// See [`GenerateCredentialReport`](crate::client::fluent_builders::GenerateCredentialReport) for more information about the
    /// operation and its arguments.
    pub fn generate_credential_report(&self) -> fluent_builders::GenerateCredentialReport<C, M, R> {
        fluent_builders::GenerateCredentialReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GenerateOrganizationsAccessReport` operation.
    ///
    /// See [`GenerateOrganizationsAccessReport`](crate::client::fluent_builders::GenerateOrganizationsAccessReport) for more information about the
    /// operation and its arguments.
    pub fn generate_organizations_access_report(
        &self,
    ) -> fluent_builders::GenerateOrganizationsAccessReport<C, M, R> {
        fluent_builders::GenerateOrganizationsAccessReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GenerateServiceLastAccessedDetails` operation.
    ///
    /// See [`GenerateServiceLastAccessedDetails`](crate::client::fluent_builders::GenerateServiceLastAccessedDetails) for more information about the
    /// operation and its arguments.
    pub fn generate_service_last_accessed_details(
        &self,
    ) -> fluent_builders::GenerateServiceLastAccessedDetails<C, M, R> {
        fluent_builders::GenerateServiceLastAccessedDetails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAccessKeyLastUsed` operation.
    ///
    /// See [`GetAccessKeyLastUsed`](crate::client::fluent_builders::GetAccessKeyLastUsed) for more information about the
    /// operation and its arguments.
    pub fn get_access_key_last_used(&self) -> fluent_builders::GetAccessKeyLastUsed<C, M, R> {
        fluent_builders::GetAccessKeyLastUsed::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAccountAuthorizationDetails` operation.
    ///
    /// See [`GetAccountAuthorizationDetails`](crate::client::fluent_builders::GetAccountAuthorizationDetails) for more information about the
    /// operation and its arguments.
    pub fn get_account_authorization_details(
        &self,
    ) -> fluent_builders::GetAccountAuthorizationDetails<C, M, R> {
        fluent_builders::GetAccountAuthorizationDetails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAccountPasswordPolicy` operation.
    ///
    /// See [`GetAccountPasswordPolicy`](crate::client::fluent_builders::GetAccountPasswordPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_account_password_policy(
        &self,
    ) -> fluent_builders::GetAccountPasswordPolicy<C, M, R> {
        fluent_builders::GetAccountPasswordPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAccountSummary` operation.
    ///
    /// See [`GetAccountSummary`](crate::client::fluent_builders::GetAccountSummary) for more information about the
    /// operation and its arguments.
    pub fn get_account_summary(&self) -> fluent_builders::GetAccountSummary<C, M, R> {
        fluent_builders::GetAccountSummary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetContextKeysForCustomPolicy` operation.
    ///
    /// See [`GetContextKeysForCustomPolicy`](crate::client::fluent_builders::GetContextKeysForCustomPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_context_keys_for_custom_policy(
        &self,
    ) -> fluent_builders::GetContextKeysForCustomPolicy<C, M, R> {
        fluent_builders::GetContextKeysForCustomPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetContextKeysForPrincipalPolicy` operation.
    ///
    /// See [`GetContextKeysForPrincipalPolicy`](crate::client::fluent_builders::GetContextKeysForPrincipalPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_context_keys_for_principal_policy(
        &self,
    ) -> fluent_builders::GetContextKeysForPrincipalPolicy<C, M, R> {
        fluent_builders::GetContextKeysForPrincipalPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCredentialReport` operation.
    ///
    /// See [`GetCredentialReport`](crate::client::fluent_builders::GetCredentialReport) for more information about the
    /// operation and its arguments.
    pub fn get_credential_report(&self) -> fluent_builders::GetCredentialReport<C, M, R> {
        fluent_builders::GetCredentialReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetGroup` operation.
    ///
    /// See [`GetGroup`](crate::client::fluent_builders::GetGroup) for more information about the
    /// operation and its arguments.
    pub fn get_group(&self) -> fluent_builders::GetGroup<C, M, R> {
        fluent_builders::GetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetGroupPolicy` operation.
    ///
    /// See [`GetGroupPolicy`](crate::client::fluent_builders::GetGroupPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_group_policy(&self) -> fluent_builders::GetGroupPolicy<C, M, R> {
        fluent_builders::GetGroupPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetInstanceProfile` operation.
    ///
    /// See [`GetInstanceProfile`](crate::client::fluent_builders::GetInstanceProfile) for more information about the
    /// operation and its arguments.
    pub fn get_instance_profile(&self) -> fluent_builders::GetInstanceProfile<C, M, R> {
        fluent_builders::GetInstanceProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLoginProfile` operation.
    ///
    /// See [`GetLoginProfile`](crate::client::fluent_builders::GetLoginProfile) for more information about the
    /// operation and its arguments.
    pub fn get_login_profile(&self) -> fluent_builders::GetLoginProfile<C, M, R> {
        fluent_builders::GetLoginProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetOpenIDConnectProvider` operation.
    ///
    /// See [`GetOpenIDConnectProvider`](crate::client::fluent_builders::GetOpenIDConnectProvider) for more information about the
    /// operation and its arguments.
    pub fn get_open_id_connect_provider(
        &self,
    ) -> fluent_builders::GetOpenIDConnectProvider<C, M, R> {
        fluent_builders::GetOpenIDConnectProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetOrganizationsAccessReport` operation.
    ///
    /// See [`GetOrganizationsAccessReport`](crate::client::fluent_builders::GetOrganizationsAccessReport) for more information about the
    /// operation and its arguments.
    pub fn get_organizations_access_report(
        &self,
    ) -> fluent_builders::GetOrganizationsAccessReport<C, M, R> {
        fluent_builders::GetOrganizationsAccessReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPolicy` operation.
    ///
    /// See [`GetPolicy`](crate::client::fluent_builders::GetPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_policy(&self) -> fluent_builders::GetPolicy<C, M, R> {
        fluent_builders::GetPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPolicyVersion` operation.
    ///
    /// See [`GetPolicyVersion`](crate::client::fluent_builders::GetPolicyVersion) for more information about the
    /// operation and its arguments.
    pub fn get_policy_version(&self) -> fluent_builders::GetPolicyVersion<C, M, R> {
        fluent_builders::GetPolicyVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRole` operation.
    ///
    /// See [`GetRole`](crate::client::fluent_builders::GetRole) for more information about the
    /// operation and its arguments.
    pub fn get_role(&self) -> fluent_builders::GetRole<C, M, R> {
        fluent_builders::GetRole::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRolePolicy` operation.
    ///
    /// See [`GetRolePolicy`](crate::client::fluent_builders::GetRolePolicy) for more information about the
    /// operation and its arguments.
    pub fn get_role_policy(&self) -> fluent_builders::GetRolePolicy<C, M, R> {
        fluent_builders::GetRolePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSAMLProvider` operation.
    ///
    /// See [`GetSAMLProvider`](crate::client::fluent_builders::GetSAMLProvider) for more information about the
    /// operation and its arguments.
    pub fn get_saml_provider(&self) -> fluent_builders::GetSAMLProvider<C, M, R> {
        fluent_builders::GetSAMLProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetServerCertificate` operation.
    ///
    /// See [`GetServerCertificate`](crate::client::fluent_builders::GetServerCertificate) for more information about the
    /// operation and its arguments.
    pub fn get_server_certificate(&self) -> fluent_builders::GetServerCertificate<C, M, R> {
        fluent_builders::GetServerCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetServiceLastAccessedDetails` operation.
    ///
    /// See [`GetServiceLastAccessedDetails`](crate::client::fluent_builders::GetServiceLastAccessedDetails) for more information about the
    /// operation and its arguments.
    pub fn get_service_last_accessed_details(
        &self,
    ) -> fluent_builders::GetServiceLastAccessedDetails<C, M, R> {
        fluent_builders::GetServiceLastAccessedDetails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetServiceLastAccessedDetailsWithEntities` operation.
    ///
    /// See [`GetServiceLastAccessedDetailsWithEntities`](crate::client::fluent_builders::GetServiceLastAccessedDetailsWithEntities) for more information about the
    /// operation and its arguments.
    pub fn get_service_last_accessed_details_with_entities(
        &self,
    ) -> fluent_builders::GetServiceLastAccessedDetailsWithEntities<C, M, R> {
        fluent_builders::GetServiceLastAccessedDetailsWithEntities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetServiceLinkedRoleDeletionStatus` operation.
    ///
    /// See [`GetServiceLinkedRoleDeletionStatus`](crate::client::fluent_builders::GetServiceLinkedRoleDeletionStatus) for more information about the
    /// operation and its arguments.
    pub fn get_service_linked_role_deletion_status(
        &self,
    ) -> fluent_builders::GetServiceLinkedRoleDeletionStatus<C, M, R> {
        fluent_builders::GetServiceLinkedRoleDeletionStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSSHPublicKey` operation.
    ///
    /// See [`GetSSHPublicKey`](crate::client::fluent_builders::GetSSHPublicKey) for more information about the
    /// operation and its arguments.
    pub fn get_ssh_public_key(&self) -> fluent_builders::GetSSHPublicKey<C, M, R> {
        fluent_builders::GetSSHPublicKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetUser` operation.
    ///
    /// See [`GetUser`](crate::client::fluent_builders::GetUser) for more information about the
    /// operation and its arguments.
    pub fn get_user(&self) -> fluent_builders::GetUser<C, M, R> {
        fluent_builders::GetUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetUserPolicy` operation.
    ///
    /// See [`GetUserPolicy`](crate::client::fluent_builders::GetUserPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_user_policy(&self) -> fluent_builders::GetUserPolicy<C, M, R> {
        fluent_builders::GetUserPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAccessKeys` operation.
    ///
    /// See [`ListAccessKeys`](crate::client::fluent_builders::ListAccessKeys) for more information about the
    /// operation and its arguments.
    pub fn list_access_keys(&self) -> fluent_builders::ListAccessKeys<C, M, R> {
        fluent_builders::ListAccessKeys::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAccountAliases` operation.
    ///
    /// See [`ListAccountAliases`](crate::client::fluent_builders::ListAccountAliases) for more information about the
    /// operation and its arguments.
    pub fn list_account_aliases(&self) -> fluent_builders::ListAccountAliases<C, M, R> {
        fluent_builders::ListAccountAliases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAttachedGroupPolicies` operation.
    ///
    /// See [`ListAttachedGroupPolicies`](crate::client::fluent_builders::ListAttachedGroupPolicies) for more information about the
    /// operation and its arguments.
    pub fn list_attached_group_policies(
        &self,
    ) -> fluent_builders::ListAttachedGroupPolicies<C, M, R> {
        fluent_builders::ListAttachedGroupPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAttachedRolePolicies` operation.
    ///
    /// See [`ListAttachedRolePolicies`](crate::client::fluent_builders::ListAttachedRolePolicies) for more information about the
    /// operation and its arguments.
    pub fn list_attached_role_policies(
        &self,
    ) -> fluent_builders::ListAttachedRolePolicies<C, M, R> {
        fluent_builders::ListAttachedRolePolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAttachedUserPolicies` operation.
    ///
    /// See [`ListAttachedUserPolicies`](crate::client::fluent_builders::ListAttachedUserPolicies) for more information about the
    /// operation and its arguments.
    pub fn list_attached_user_policies(
        &self,
    ) -> fluent_builders::ListAttachedUserPolicies<C, M, R> {
        fluent_builders::ListAttachedUserPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEntitiesForPolicy` operation.
    ///
    /// See [`ListEntitiesForPolicy`](crate::client::fluent_builders::ListEntitiesForPolicy) for more information about the
    /// operation and its arguments.
    pub fn list_entities_for_policy(&self) -> fluent_builders::ListEntitiesForPolicy<C, M, R> {
        fluent_builders::ListEntitiesForPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListGroupPolicies` operation.
    ///
    /// See [`ListGroupPolicies`](crate::client::fluent_builders::ListGroupPolicies) for more information about the
    /// operation and its arguments.
    pub fn list_group_policies(&self) -> fluent_builders::ListGroupPolicies<C, M, R> {
        fluent_builders::ListGroupPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListGroups` operation.
    ///
    /// See [`ListGroups`](crate::client::fluent_builders::ListGroups) for more information about the
    /// operation and its arguments.
    pub fn list_groups(&self) -> fluent_builders::ListGroups<C, M, R> {
        fluent_builders::ListGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListGroupsForUser` operation.
    ///
    /// See [`ListGroupsForUser`](crate::client::fluent_builders::ListGroupsForUser) for more information about the
    /// operation and its arguments.
    pub fn list_groups_for_user(&self) -> fluent_builders::ListGroupsForUser<C, M, R> {
        fluent_builders::ListGroupsForUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListInstanceProfiles` operation.
    ///
    /// See [`ListInstanceProfiles`](crate::client::fluent_builders::ListInstanceProfiles) for more information about the
    /// operation and its arguments.
    pub fn list_instance_profiles(&self) -> fluent_builders::ListInstanceProfiles<C, M, R> {
        fluent_builders::ListInstanceProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListInstanceProfilesForRole` operation.
    ///
    /// See [`ListInstanceProfilesForRole`](crate::client::fluent_builders::ListInstanceProfilesForRole) for more information about the
    /// operation and its arguments.
    pub fn list_instance_profiles_for_role(
        &self,
    ) -> fluent_builders::ListInstanceProfilesForRole<C, M, R> {
        fluent_builders::ListInstanceProfilesForRole::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListInstanceProfileTags` operation.
    ///
    /// See [`ListInstanceProfileTags`](crate::client::fluent_builders::ListInstanceProfileTags) for more information about the
    /// operation and its arguments.
    pub fn list_instance_profile_tags(&self) -> fluent_builders::ListInstanceProfileTags<C, M, R> {
        fluent_builders::ListInstanceProfileTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListMFADevices` operation.
    ///
    /// See [`ListMFADevices`](crate::client::fluent_builders::ListMFADevices) for more information about the
    /// operation and its arguments.
    pub fn list_mfa_devices(&self) -> fluent_builders::ListMFADevices<C, M, R> {
        fluent_builders::ListMFADevices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListMFADeviceTags` operation.
    ///
    /// See [`ListMFADeviceTags`](crate::client::fluent_builders::ListMFADeviceTags) for more information about the
    /// operation and its arguments.
    pub fn list_mfa_device_tags(&self) -> fluent_builders::ListMFADeviceTags<C, M, R> {
        fluent_builders::ListMFADeviceTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListOpenIDConnectProviders` operation.
    ///
    /// See [`ListOpenIDConnectProviders`](crate::client::fluent_builders::ListOpenIDConnectProviders) for more information about the
    /// operation and its arguments.
    pub fn list_open_id_connect_providers(
        &self,
    ) -> fluent_builders::ListOpenIDConnectProviders<C, M, R> {
        fluent_builders::ListOpenIDConnectProviders::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListOpenIDConnectProviderTags` operation.
    ///
    /// See [`ListOpenIDConnectProviderTags`](crate::client::fluent_builders::ListOpenIDConnectProviderTags) for more information about the
    /// operation and its arguments.
    pub fn list_open_id_connect_provider_tags(
        &self,
    ) -> fluent_builders::ListOpenIDConnectProviderTags<C, M, R> {
        fluent_builders::ListOpenIDConnectProviderTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPolicies` operation.
    ///
    /// See [`ListPolicies`](crate::client::fluent_builders::ListPolicies) for more information about the
    /// operation and its arguments.
    pub fn list_policies(&self) -> fluent_builders::ListPolicies<C, M, R> {
        fluent_builders::ListPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPoliciesGrantingServiceAccess` operation.
    ///
    /// See [`ListPoliciesGrantingServiceAccess`](crate::client::fluent_builders::ListPoliciesGrantingServiceAccess) for more information about the
    /// operation and its arguments.
    pub fn list_policies_granting_service_access(
        &self,
    ) -> fluent_builders::ListPoliciesGrantingServiceAccess<C, M, R> {
        fluent_builders::ListPoliciesGrantingServiceAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPolicyTags` operation.
    ///
    /// See [`ListPolicyTags`](crate::client::fluent_builders::ListPolicyTags) for more information about the
    /// operation and its arguments.
    pub fn list_policy_tags(&self) -> fluent_builders::ListPolicyTags<C, M, R> {
        fluent_builders::ListPolicyTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPolicyVersions` operation.
    ///
    /// See [`ListPolicyVersions`](crate::client::fluent_builders::ListPolicyVersions) for more information about the
    /// operation and its arguments.
    pub fn list_policy_versions(&self) -> fluent_builders::ListPolicyVersions<C, M, R> {
        fluent_builders::ListPolicyVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRolePolicies` operation.
    ///
    /// See [`ListRolePolicies`](crate::client::fluent_builders::ListRolePolicies) for more information about the
    /// operation and its arguments.
    pub fn list_role_policies(&self) -> fluent_builders::ListRolePolicies<C, M, R> {
        fluent_builders::ListRolePolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRoles` operation.
    ///
    /// See [`ListRoles`](crate::client::fluent_builders::ListRoles) for more information about the
    /// operation and its arguments.
    pub fn list_roles(&self) -> fluent_builders::ListRoles<C, M, R> {
        fluent_builders::ListRoles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRoleTags` operation.
    ///
    /// See [`ListRoleTags`](crate::client::fluent_builders::ListRoleTags) for more information about the
    /// operation and its arguments.
    pub fn list_role_tags(&self) -> fluent_builders::ListRoleTags<C, M, R> {
        fluent_builders::ListRoleTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSAMLProviders` operation.
    ///
    /// See [`ListSAMLProviders`](crate::client::fluent_builders::ListSAMLProviders) for more information about the
    /// operation and its arguments.
    pub fn list_saml_providers(&self) -> fluent_builders::ListSAMLProviders<C, M, R> {
        fluent_builders::ListSAMLProviders::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSAMLProviderTags` operation.
    ///
    /// See [`ListSAMLProviderTags`](crate::client::fluent_builders::ListSAMLProviderTags) for more information about the
    /// operation and its arguments.
    pub fn list_saml_provider_tags(&self) -> fluent_builders::ListSAMLProviderTags<C, M, R> {
        fluent_builders::ListSAMLProviderTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListServerCertificates` operation.
    ///
    /// See [`ListServerCertificates`](crate::client::fluent_builders::ListServerCertificates) for more information about the
    /// operation and its arguments.
    pub fn list_server_certificates(&self) -> fluent_builders::ListServerCertificates<C, M, R> {
        fluent_builders::ListServerCertificates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListServerCertificateTags` operation.
    ///
    /// See [`ListServerCertificateTags`](crate::client::fluent_builders::ListServerCertificateTags) for more information about the
    /// operation and its arguments.
    pub fn list_server_certificate_tags(
        &self,
    ) -> fluent_builders::ListServerCertificateTags<C, M, R> {
        fluent_builders::ListServerCertificateTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListServiceSpecificCredentials` operation.
    ///
    /// See [`ListServiceSpecificCredentials`](crate::client::fluent_builders::ListServiceSpecificCredentials) for more information about the
    /// operation and its arguments.
    pub fn list_service_specific_credentials(
        &self,
    ) -> fluent_builders::ListServiceSpecificCredentials<C, M, R> {
        fluent_builders::ListServiceSpecificCredentials::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSigningCertificates` operation.
    ///
    /// See [`ListSigningCertificates`](crate::client::fluent_builders::ListSigningCertificates) for more information about the
    /// operation and its arguments.
    pub fn list_signing_certificates(&self) -> fluent_builders::ListSigningCertificates<C, M, R> {
        fluent_builders::ListSigningCertificates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSSHPublicKeys` operation.
    ///
    /// See [`ListSSHPublicKeys`](crate::client::fluent_builders::ListSSHPublicKeys) for more information about the
    /// operation and its arguments.
    pub fn list_ssh_public_keys(&self) -> fluent_builders::ListSSHPublicKeys<C, M, R> {
        fluent_builders::ListSSHPublicKeys::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListUserPolicies` operation.
    ///
    /// See [`ListUserPolicies`](crate::client::fluent_builders::ListUserPolicies) for more information about the
    /// operation and its arguments.
    pub fn list_user_policies(&self) -> fluent_builders::ListUserPolicies<C, M, R> {
        fluent_builders::ListUserPolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListUsers` operation.
    ///
    /// See [`ListUsers`](crate::client::fluent_builders::ListUsers) for more information about the
    /// operation and its arguments.
    pub fn list_users(&self) -> fluent_builders::ListUsers<C, M, R> {
        fluent_builders::ListUsers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListUserTags` operation.
    ///
    /// See [`ListUserTags`](crate::client::fluent_builders::ListUserTags) for more information about the
    /// operation and its arguments.
    pub fn list_user_tags(&self) -> fluent_builders::ListUserTags<C, M, R> {
        fluent_builders::ListUserTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListVirtualMFADevices` operation.
    ///
    /// See [`ListVirtualMFADevices`](crate::client::fluent_builders::ListVirtualMFADevices) for more information about the
    /// operation and its arguments.
    pub fn list_virtual_mfa_devices(&self) -> fluent_builders::ListVirtualMFADevices<C, M, R> {
        fluent_builders::ListVirtualMFADevices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutGroupPolicy` operation.
    ///
    /// See [`PutGroupPolicy`](crate::client::fluent_builders::PutGroupPolicy) for more information about the
    /// operation and its arguments.
    pub fn put_group_policy(&self) -> fluent_builders::PutGroupPolicy<C, M, R> {
        fluent_builders::PutGroupPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutRolePermissionsBoundary` operation.
    ///
    /// See [`PutRolePermissionsBoundary`](crate::client::fluent_builders::PutRolePermissionsBoundary) for more information about the
    /// operation and its arguments.
    pub fn put_role_permissions_boundary(
        &self,
    ) -> fluent_builders::PutRolePermissionsBoundary<C, M, R> {
        fluent_builders::PutRolePermissionsBoundary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutRolePolicy` operation.
    ///
    /// See [`PutRolePolicy`](crate::client::fluent_builders::PutRolePolicy) for more information about the
    /// operation and its arguments.
    pub fn put_role_policy(&self) -> fluent_builders::PutRolePolicy<C, M, R> {
        fluent_builders::PutRolePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutUserPermissionsBoundary` operation.
    ///
    /// See [`PutUserPermissionsBoundary`](crate::client::fluent_builders::PutUserPermissionsBoundary) for more information about the
    /// operation and its arguments.
    pub fn put_user_permissions_boundary(
        &self,
    ) -> fluent_builders::PutUserPermissionsBoundary<C, M, R> {
        fluent_builders::PutUserPermissionsBoundary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutUserPolicy` operation.
    ///
    /// See [`PutUserPolicy`](crate::client::fluent_builders::PutUserPolicy) for more information about the
    /// operation and its arguments.
    pub fn put_user_policy(&self) -> fluent_builders::PutUserPolicy<C, M, R> {
        fluent_builders::PutUserPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveClientIDFromOpenIDConnectProvider` operation.
    ///
    /// See [`RemoveClientIDFromOpenIDConnectProvider`](crate::client::fluent_builders::RemoveClientIDFromOpenIDConnectProvider) for more information about the
    /// operation and its arguments.
    pub fn remove_client_id_from_open_id_connect_provider(
        &self,
    ) -> fluent_builders::RemoveClientIDFromOpenIDConnectProvider<C, M, R> {
        fluent_builders::RemoveClientIDFromOpenIDConnectProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveRoleFromInstanceProfile` operation.
    ///
    /// See [`RemoveRoleFromInstanceProfile`](crate::client::fluent_builders::RemoveRoleFromInstanceProfile) for more information about the
    /// operation and its arguments.
    pub fn remove_role_from_instance_profile(
        &self,
    ) -> fluent_builders::RemoveRoleFromInstanceProfile<C, M, R> {
        fluent_builders::RemoveRoleFromInstanceProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveUserFromGroup` operation.
    ///
    /// See [`RemoveUserFromGroup`](crate::client::fluent_builders::RemoveUserFromGroup) for more information about the
    /// operation and its arguments.
    pub fn remove_user_from_group(&self) -> fluent_builders::RemoveUserFromGroup<C, M, R> {
        fluent_builders::RemoveUserFromGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResetServiceSpecificCredential` operation.
    ///
    /// See [`ResetServiceSpecificCredential`](crate::client::fluent_builders::ResetServiceSpecificCredential) for more information about the
    /// operation and its arguments.
    pub fn reset_service_specific_credential(
        &self,
    ) -> fluent_builders::ResetServiceSpecificCredential<C, M, R> {
        fluent_builders::ResetServiceSpecificCredential::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResyncMFADevice` operation.
    ///
    /// See [`ResyncMFADevice`](crate::client::fluent_builders::ResyncMFADevice) for more information about the
    /// operation and its arguments.
    pub fn resync_mfa_device(&self) -> fluent_builders::ResyncMFADevice<C, M, R> {
        fluent_builders::ResyncMFADevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetDefaultPolicyVersion` operation.
    ///
    /// See [`SetDefaultPolicyVersion`](crate::client::fluent_builders::SetDefaultPolicyVersion) for more information about the
    /// operation and its arguments.
    pub fn set_default_policy_version(&self) -> fluent_builders::SetDefaultPolicyVersion<C, M, R> {
        fluent_builders::SetDefaultPolicyVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetSecurityTokenServicePreferences` operation.
    ///
    /// See [`SetSecurityTokenServicePreferences`](crate::client::fluent_builders::SetSecurityTokenServicePreferences) for more information about the
    /// operation and its arguments.
    pub fn set_security_token_service_preferences(
        &self,
    ) -> fluent_builders::SetSecurityTokenServicePreferences<C, M, R> {
        fluent_builders::SetSecurityTokenServicePreferences::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SimulateCustomPolicy` operation.
    ///
    /// See [`SimulateCustomPolicy`](crate::client::fluent_builders::SimulateCustomPolicy) for more information about the
    /// operation and its arguments.
    pub fn simulate_custom_policy(&self) -> fluent_builders::SimulateCustomPolicy<C, M, R> {
        fluent_builders::SimulateCustomPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SimulatePrincipalPolicy` operation.
    ///
    /// See [`SimulatePrincipalPolicy`](crate::client::fluent_builders::SimulatePrincipalPolicy) for more information about the
    /// operation and its arguments.
    pub fn simulate_principal_policy(&self) -> fluent_builders::SimulatePrincipalPolicy<C, M, R> {
        fluent_builders::SimulatePrincipalPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagInstanceProfile` operation.
    ///
    /// See [`TagInstanceProfile`](crate::client::fluent_builders::TagInstanceProfile) for more information about the
    /// operation and its arguments.
    pub fn tag_instance_profile(&self) -> fluent_builders::TagInstanceProfile<C, M, R> {
        fluent_builders::TagInstanceProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagMFADevice` operation.
    ///
    /// See [`TagMFADevice`](crate::client::fluent_builders::TagMFADevice) for more information about the
    /// operation and its arguments.
    pub fn tag_mfa_device(&self) -> fluent_builders::TagMFADevice<C, M, R> {
        fluent_builders::TagMFADevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagOpenIDConnectProvider` operation.
    ///
    /// See [`TagOpenIDConnectProvider`](crate::client::fluent_builders::TagOpenIDConnectProvider) for more information about the
    /// operation and its arguments.
    pub fn tag_open_id_connect_provider(
        &self,
    ) -> fluent_builders::TagOpenIDConnectProvider<C, M, R> {
        fluent_builders::TagOpenIDConnectProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagPolicy` operation.
    ///
    /// See [`TagPolicy`](crate::client::fluent_builders::TagPolicy) for more information about the
    /// operation and its arguments.
    pub fn tag_policy(&self) -> fluent_builders::TagPolicy<C, M, R> {
        fluent_builders::TagPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagRole` operation.
    ///
    /// See [`TagRole`](crate::client::fluent_builders::TagRole) for more information about the
    /// operation and its arguments.
    pub fn tag_role(&self) -> fluent_builders::TagRole<C, M, R> {
        fluent_builders::TagRole::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagSAMLProvider` operation.
    ///
    /// See [`TagSAMLProvider`](crate::client::fluent_builders::TagSAMLProvider) for more information about the
    /// operation and its arguments.
    pub fn tag_saml_provider(&self) -> fluent_builders::TagSAMLProvider<C, M, R> {
        fluent_builders::TagSAMLProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagServerCertificate` operation.
    ///
    /// See [`TagServerCertificate`](crate::client::fluent_builders::TagServerCertificate) for more information about the
    /// operation and its arguments.
    pub fn tag_server_certificate(&self) -> fluent_builders::TagServerCertificate<C, M, R> {
        fluent_builders::TagServerCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagUser` operation.
    ///
    /// See [`TagUser`](crate::client::fluent_builders::TagUser) for more information about the
    /// operation and its arguments.
    pub fn tag_user(&self) -> fluent_builders::TagUser<C, M, R> {
        fluent_builders::TagUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagInstanceProfile` operation.
    ///
    /// See [`UntagInstanceProfile`](crate::client::fluent_builders::UntagInstanceProfile) for more information about the
    /// operation and its arguments.
    pub fn untag_instance_profile(&self) -> fluent_builders::UntagInstanceProfile<C, M, R> {
        fluent_builders::UntagInstanceProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagMFADevice` operation.
    ///
    /// See [`UntagMFADevice`](crate::client::fluent_builders::UntagMFADevice) for more information about the
    /// operation and its arguments.
    pub fn untag_mfa_device(&self) -> fluent_builders::UntagMFADevice<C, M, R> {
        fluent_builders::UntagMFADevice::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagOpenIDConnectProvider` operation.
    ///
    /// See [`UntagOpenIDConnectProvider`](crate::client::fluent_builders::UntagOpenIDConnectProvider) for more information about the
    /// operation and its arguments.
    pub fn untag_open_id_connect_provider(
        &self,
    ) -> fluent_builders::UntagOpenIDConnectProvider<C, M, R> {
        fluent_builders::UntagOpenIDConnectProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagPolicy` operation.
    ///
    /// See [`UntagPolicy`](crate::client::fluent_builders::UntagPolicy) for more information about the
    /// operation and its arguments.
    pub fn untag_policy(&self) -> fluent_builders::UntagPolicy<C, M, R> {
        fluent_builders::UntagPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagRole` operation.
    ///
    /// See [`UntagRole`](crate::client::fluent_builders::UntagRole) for more information about the
    /// operation and its arguments.
    pub fn untag_role(&self) -> fluent_builders::UntagRole<C, M, R> {
        fluent_builders::UntagRole::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagSAMLProvider` operation.
    ///
    /// See [`UntagSAMLProvider`](crate::client::fluent_builders::UntagSAMLProvider) for more information about the
    /// operation and its arguments.
    pub fn untag_saml_provider(&self) -> fluent_builders::UntagSAMLProvider<C, M, R> {
        fluent_builders::UntagSAMLProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagServerCertificate` operation.
    ///
    /// See [`UntagServerCertificate`](crate::client::fluent_builders::UntagServerCertificate) for more information about the
    /// operation and its arguments.
    pub fn untag_server_certificate(&self) -> fluent_builders::UntagServerCertificate<C, M, R> {
        fluent_builders::UntagServerCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagUser` operation.
    ///
    /// See [`UntagUser`](crate::client::fluent_builders::UntagUser) for more information about the
    /// operation and its arguments.
    pub fn untag_user(&self) -> fluent_builders::UntagUser<C, M, R> {
        fluent_builders::UntagUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAccessKey` operation.
    ///
    /// See [`UpdateAccessKey`](crate::client::fluent_builders::UpdateAccessKey) for more information about the
    /// operation and its arguments.
    pub fn update_access_key(&self) -> fluent_builders::UpdateAccessKey<C, M, R> {
        fluent_builders::UpdateAccessKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAccountPasswordPolicy` operation.
    ///
    /// See [`UpdateAccountPasswordPolicy`](crate::client::fluent_builders::UpdateAccountPasswordPolicy) for more information about the
    /// operation and its arguments.
    pub fn update_account_password_policy(
        &self,
    ) -> fluent_builders::UpdateAccountPasswordPolicy<C, M, R> {
        fluent_builders::UpdateAccountPasswordPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAssumeRolePolicy` operation.
    ///
    /// See [`UpdateAssumeRolePolicy`](crate::client::fluent_builders::UpdateAssumeRolePolicy) for more information about the
    /// operation and its arguments.
    pub fn update_assume_role_policy(&self) -> fluent_builders::UpdateAssumeRolePolicy<C, M, R> {
        fluent_builders::UpdateAssumeRolePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateGroup` operation.
    ///
    /// See [`UpdateGroup`](crate::client::fluent_builders::UpdateGroup) for more information about the
    /// operation and its arguments.
    pub fn update_group(&self) -> fluent_builders::UpdateGroup<C, M, R> {
        fluent_builders::UpdateGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateLoginProfile` operation.
    ///
    /// See [`UpdateLoginProfile`](crate::client::fluent_builders::UpdateLoginProfile) for more information about the
    /// operation and its arguments.
    pub fn update_login_profile(&self) -> fluent_builders::UpdateLoginProfile<C, M, R> {
        fluent_builders::UpdateLoginProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateOpenIDConnectProviderThumbprint` operation.
    ///
    /// See [`UpdateOpenIDConnectProviderThumbprint`](crate::client::fluent_builders::UpdateOpenIDConnectProviderThumbprint) for more information about the
    /// operation and its arguments.
    pub fn update_open_id_connect_provider_thumbprint(
        &self,
    ) -> fluent_builders::UpdateOpenIDConnectProviderThumbprint<C, M, R> {
        fluent_builders::UpdateOpenIDConnectProviderThumbprint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRole` operation.
    ///
    /// See [`UpdateRole`](crate::client::fluent_builders::UpdateRole) for more information about the
    /// operation and its arguments.
    pub fn update_role(&self) -> fluent_builders::UpdateRole<C, M, R> {
        fluent_builders::UpdateRole::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRoleDescription` operation.
    ///
    /// See [`UpdateRoleDescription`](crate::client::fluent_builders::UpdateRoleDescription) for more information about the
    /// operation and its arguments.
    pub fn update_role_description(&self) -> fluent_builders::UpdateRoleDescription<C, M, R> {
        fluent_builders::UpdateRoleDescription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSAMLProvider` operation.
    ///
    /// See [`UpdateSAMLProvider`](crate::client::fluent_builders::UpdateSAMLProvider) for more information about the
    /// operation and its arguments.
    pub fn update_saml_provider(&self) -> fluent_builders::UpdateSAMLProvider<C, M, R> {
        fluent_builders::UpdateSAMLProvider::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateServerCertificate` operation.
    ///
    /// See [`UpdateServerCertificate`](crate::client::fluent_builders::UpdateServerCertificate) for more information about the
    /// operation and its arguments.
    pub fn update_server_certificate(&self) -> fluent_builders::UpdateServerCertificate<C, M, R> {
        fluent_builders::UpdateServerCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateServiceSpecificCredential` operation.
    ///
    /// See [`UpdateServiceSpecificCredential`](crate::client::fluent_builders::UpdateServiceSpecificCredential) for more information about the
    /// operation and its arguments.
    pub fn update_service_specific_credential(
        &self,
    ) -> fluent_builders::UpdateServiceSpecificCredential<C, M, R> {
        fluent_builders::UpdateServiceSpecificCredential::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSigningCertificate` operation.
    ///
    /// See [`UpdateSigningCertificate`](crate::client::fluent_builders::UpdateSigningCertificate) for more information about the
    /// operation and its arguments.
    pub fn update_signing_certificate(&self) -> fluent_builders::UpdateSigningCertificate<C, M, R> {
        fluent_builders::UpdateSigningCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSSHPublicKey` operation.
    ///
    /// See [`UpdateSSHPublicKey`](crate::client::fluent_builders::UpdateSSHPublicKey) for more information about the
    /// operation and its arguments.
    pub fn update_ssh_public_key(&self) -> fluent_builders::UpdateSSHPublicKey<C, M, R> {
        fluent_builders::UpdateSSHPublicKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateUser` operation.
    ///
    /// See [`UpdateUser`](crate::client::fluent_builders::UpdateUser) for more information about the
    /// operation and its arguments.
    pub fn update_user(&self) -> fluent_builders::UpdateUser<C, M, R> {
        fluent_builders::UpdateUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UploadServerCertificate` operation.
    ///
    /// See [`UploadServerCertificate`](crate::client::fluent_builders::UploadServerCertificate) for more information about the
    /// operation and its arguments.
    pub fn upload_server_certificate(&self) -> fluent_builders::UploadServerCertificate<C, M, R> {
        fluent_builders::UploadServerCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UploadSigningCertificate` operation.
    ///
    /// See [`UploadSigningCertificate`](crate::client::fluent_builders::UploadSigningCertificate) for more information about the
    /// operation and its arguments.
    pub fn upload_signing_certificate(&self) -> fluent_builders::UploadSigningCertificate<C, M, R> {
        fluent_builders::UploadSigningCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UploadSSHPublicKey` operation.
    ///
    /// See [`UploadSSHPublicKey`](crate::client::fluent_builders::UploadSSHPublicKey) for more information about the
    /// operation and its arguments.
    pub fn upload_ssh_public_key(&self) -> fluent_builders::UploadSSHPublicKey<C, M, R> {
        fluent_builders::UploadSSHPublicKey::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddClientIDToOpenIDConnectProvider`.
    ///
    /// <p>Adds a new client ID (also known as audience) to the list of client IDs already
    /// registered for the specified IAM OpenID Connect (OIDC) provider resource.</p>
    /// <p>This operation is idempotent; it does not fail or return an error if you add an
    /// existing client ID to the provider.</p>
    #[derive(std::fmt::Debug)]
    pub struct AddClientIDToOpenIDConnectProvider<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_client_id_to_open_id_connect_provider_input::Builder,
    }
    impl<C, M, R> AddClientIDToOpenIDConnectProvider<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddClientIDToOpenIDConnectProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddClientIdToOpenIdConnectProviderOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AddClientIDToOpenIDConnectProviderError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddClientIdToOpenIdConnectProviderInputOperationOutputAlias,
                crate::output::AddClientIdToOpenIdConnectProviderOutput,
                crate::error::AddClientIDToOpenIDConnectProviderError,
                crate::input::AddClientIdToOpenIdConnectProviderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM OpenID Connect (OIDC) provider resource to
        /// add the client ID to. You can get a list of OIDC provider ARNs by using the <a>ListOpenIDConnectProviders</a> operation.</p>
        pub fn open_id_connect_provider_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.open_id_connect_provider_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM OpenID Connect (OIDC) provider resource to
        /// add the client ID to. You can get a list of OIDC provider ARNs by using the <a>ListOpenIDConnectProviders</a> operation.</p>
        pub fn set_open_id_connect_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_open_id_connect_provider_arn(input);
            self
        }
        /// <p>The client ID (also known as audience) to add to the IAM OpenID Connect provider
        /// resource.</p>
        pub fn client_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_id(inp);
            self
        }
        /// <p>The client ID (also known as audience) to add to the IAM OpenID Connect provider
        /// resource.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddRoleToInstanceProfile`.
    ///
    /// <p>Adds the specified IAM role to the specified instance profile. An instance profile
    /// can contain only one role, and this quota cannot be increased. You can remove the
    /// existing role and then add a different role to an instance profile. You must then wait
    /// for the change to appear across all of Amazon Web Services because of <a href="https://en.wikipedia.org/wiki/Eventual_consistency">eventual
    /// consistency</a>. To force the change, you must <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateIamInstanceProfile.html">disassociate the instance profile</a> and then <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateIamInstanceProfile.html">associate the
    /// instance profile</a>, or you can stop your instance and then restart it.</p>
    /// <note>
    /// <p>The caller of this operation must be granted the <code>PassRole</code> permission
    /// on the IAM role by a permissions policy.</p>
    /// </note>
    /// <p>For more information about roles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with roles</a>. For more
    /// information about instance profiles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About instance
    /// profiles</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct AddRoleToInstanceProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_role_to_instance_profile_input::Builder,
    }
    impl<C, M, R> AddRoleToInstanceProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddRoleToInstanceProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddRoleToInstanceProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::AddRoleToInstanceProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddRoleToInstanceProfileInputOperationOutputAlias,
                crate::output::AddRoleToInstanceProfileOutput,
                crate::error::AddRoleToInstanceProfileError,
                crate::input::AddRoleToInstanceProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the instance profile to update.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn instance_profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_profile_name(inp);
            self
        }
        /// <p>The name of the instance profile to update.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_instance_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_profile_name(input);
            self
        }
        /// <p>The name of the role to add.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_name(inp);
            self
        }
        /// <p>The name of the role to add.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddUserToGroup`.
    ///
    /// <p>Adds the specified user to the specified group.</p>
    #[derive(std::fmt::Debug)]
    pub struct AddUserToGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_user_to_group_input::Builder,
    }
    impl<C, M, R> AddUserToGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddUserToGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddUserToGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::AddUserToGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddUserToGroupInputOperationOutputAlias,
                crate::output::AddUserToGroupOutput,
                crate::error::AddUserToGroupError,
                crate::input::AddUserToGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the group to update.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>The name of the group to update.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The name of the user to add.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the user to add.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachGroupPolicy`.
    ///
    /// <p>Attaches the specified managed policy to the specified IAM group.</p>
    /// <p>You use this operation to attach a managed policy to a group. To embed an inline
    /// policy in a group, use <a>PutGroupPolicy</a>.</p>
    /// <p>As a best practice, you can validate your IAM policies.
    /// To learn more, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM policies</a>
    /// in the <i>IAM User Guide</i>.</p>
    /// <p>For more information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
    /// policies</a> in the <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct AttachGroupPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::attach_group_policy_input::Builder,
    }
    impl<C, M, R> AttachGroupPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AttachGroupPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachGroupPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachGroupPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AttachGroupPolicyInputOperationOutputAlias,
                crate::output::AttachGroupPolicyOutput,
                crate::error::AttachGroupPolicyError,
                crate::input::AttachGroupPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name (friendly name, not ARN) of the group to attach the policy to.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>The name (friendly name, not ARN) of the group to attach the policy to.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to attach.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn policy_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to attach.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachRolePolicy`.
    ///
    /// <p>Attaches the specified managed policy to the specified IAM role. When you attach a
    /// managed policy to a role, the managed policy becomes part of the role's permission
    /// (access) policy.</p>
    /// <note>
    /// <p>You cannot use a managed policy as the role's trust policy. The role's trust
    /// policy is created at the same time as the role, using <a>CreateRole</a>.
    /// You can update a role's trust policy using <a>UpdateAssumeRolePolicy</a>.</p>
    /// </note>
    /// <p>Use this operation to attach a <i>managed</i> policy to a role. To embed
    /// an inline policy in a role, use <a>PutRolePolicy</a>. For more information
    /// about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
    /// policies</a> in the <i>IAM User Guide</i>.</p>
    /// <p>As a best practice, you can validate your IAM policies.
    /// To learn more, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM policies</a>
    /// in the <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct AttachRolePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::attach_role_policy_input::Builder,
    }
    impl<C, M, R> AttachRolePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AttachRolePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachRolePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachRolePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AttachRolePolicyInputOperationOutputAlias,
                crate::output::AttachRolePolicyOutput,
                crate::error::AttachRolePolicyError,
                crate::input::AttachRolePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name (friendly name, not ARN) of the role to attach the policy to.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_name(inp);
            self
        }
        /// <p>The name (friendly name, not ARN) of the role to attach the policy to.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to attach.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn policy_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to attach.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachUserPolicy`.
    ///
    /// <p>Attaches the specified managed policy to the specified user.</p>
    /// <p>You use this operation to attach a <i>managed</i> policy to a user. To
    /// embed an inline policy in a user, use <a>PutUserPolicy</a>.</p>
    /// <p>As a best practice, you can validate your IAM policies.
    /// To learn more, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM policies</a>
    /// in the <i>IAM User Guide</i>.</p>
    /// <p>For more information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
    /// policies</a> in the <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct AttachUserPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::attach_user_policy_input::Builder,
    }
    impl<C, M, R> AttachUserPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AttachUserPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachUserPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachUserPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AttachUserPolicyInputOperationOutputAlias,
                crate::output::AttachUserPolicyOutput,
                crate::error::AttachUserPolicyError,
                crate::input::AttachUserPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name (friendly name, not ARN) of the IAM user to attach the policy to.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name (friendly name, not ARN) of the IAM user to attach the policy to.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to attach.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn policy_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to attach.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ChangePassword`.
    ///
    /// <p>Changes the password of the IAM user who is calling this operation. This operation
    ///
    /// can be performed using the CLI, the Amazon Web Services API, or the <b>My
    /// Security Credentials</b> page in the Amazon Web Services Management Console. The Amazon Web Services account root user
    /// password is not affected by this operation.</p>
    /// <p>Use <a>UpdateLoginProfile</a> to use the CLI, the Amazon Web Services API, or the
    /// <b>Users</b> page in the IAM console to change the
    /// password for any IAM user. For more information about modifying passwords, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html">Managing
    /// passwords</a> in the <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ChangePassword<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::change_password_input::Builder,
    }
    impl<C, M, R> ChangePassword<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ChangePassword`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ChangePasswordOutput,
            aws_smithy_http::result::SdkError<crate::error::ChangePasswordError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ChangePasswordInputOperationOutputAlias,
                crate::output::ChangePasswordOutput,
                crate::error::ChangePasswordError,
                crate::input::ChangePasswordInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The IAM user's current password.</p>
        pub fn old_password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.old_password(inp);
            self
        }
        /// <p>The IAM user's current password.</p>
        pub fn set_old_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_old_password(input);
            self
        }
        /// <p>The new password. The new password must conform to the Amazon Web Services account's password
        /// policy, if one exists.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// that is used to validate this parameter is a string of characters. That string can include almost any printable
        /// ASCII character from the space (<code>\u0020</code>) through the end of the ASCII character range (<code>\u00FF</code>).
        /// You can also include the tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)
        /// characters. Any of these characters are valid in a password. However, many tools, such
        /// as the Amazon Web Services Management Console, might restrict the ability to type certain characters because they have
        /// special meaning within that tool.</p>
        pub fn new_password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_password(inp);
            self
        }
        /// <p>The new password. The new password must conform to the Amazon Web Services account's password
        /// policy, if one exists.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// that is used to validate this parameter is a string of characters. That string can include almost any printable
        /// ASCII character from the space (<code>\u0020</code>) through the end of the ASCII character range (<code>\u00FF</code>).
        /// You can also include the tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)
        /// characters. Any of these characters are valid in a password. However, many tools, such
        /// as the Amazon Web Services Management Console, might restrict the ability to type certain characters because they have
        /// special meaning within that tool.</p>
        pub fn set_new_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_new_password(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAccessKey`.
    ///
    /// <p> Creates a new Amazon Web Services secret access key and corresponding Amazon Web Services access key ID for the
    /// specified user. The default status for new keys is <code>Active</code>.</p>
    /// <p>If you do not specify a user name, IAM determines the user name implicitly based on
    /// the Amazon Web Services access key ID signing the request. This operation works for access keys under
    /// the Amazon Web Services account. Consequently, you can use this operation to manage Amazon Web Services account root
    /// user credentials. This is true even if the Amazon Web Services account has no associated users.</p>
    /// <p> For information about quotas on the number of keys you can create, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS
    /// quotas</a> in the <i>IAM User Guide</i>.</p>
    /// <important>
    /// <p>To ensure the security of your Amazon Web Services account, the secret access key is accessible
    /// only during key and user creation. You must save the key (for example, in a text
    /// file) if you want to be able to access it again. If a secret key is lost, you can
    /// delete the access keys for the associated user and then create new keys.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct CreateAccessKey<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_access_key_input::Builder,
    }
    impl<C, M, R> CreateAccessKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAccessKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAccessKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAccessKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAccessKeyInputOperationOutputAlias,
                crate::output::CreateAccessKeyOutput,
                crate::error::CreateAccessKeyError,
                crate::input::CreateAccessKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IAM user that the new key will belong to.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the IAM user that the new key will belong to.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAccountAlias`.
    ///
    /// <p>Creates an alias for your Amazon Web Services account. For information about using an Amazon Web Services account
    /// alias, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html">Using an
    /// alias for your Amazon Web Services account ID</a> in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAccountAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_account_alias_input::Builder,
    }
    impl<C, M, R> CreateAccountAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAccountAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAccountAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAccountAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAccountAliasInputOperationOutputAlias,
                crate::output::CreateAccountAliasOutput,
                crate::error::CreateAccountAliasError,
                crate::input::CreateAccountAliasInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account alias to create.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of
        /// lowercase letters, digits, and dashes. You cannot start or finish with a dash, nor can you have
        /// two dashes in a row.</p>
        pub fn account_alias(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_alias(inp);
            self
        }
        /// <p>The account alias to create.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of
        /// lowercase letters, digits, and dashes. You cannot start or finish with a dash, nor can you have
        /// two dashes in a row.</p>
        pub fn set_account_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_account_alias(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGroup`.
    ///
    /// <p>Creates a new group.</p>
    /// <p> For information about the number of groups you can create, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS
    /// quotas</a> in the <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_group_input::Builder,
    }
    impl<C, M, R> CreateGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateGroupInputOperationOutputAlias,
                crate::output::CreateGroupOutput,
                crate::error::CreateGroupError,
                crate::input::CreateGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The path to the group. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path(inp);
            self
        }
        /// <p> The path to the group. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path(input);
            self
        }
        /// <p>The name of the group to create. Do not include the path in this value.</p>
        /// <p>IAM user, group, role, and policy names must be unique within the account. Names are
        /// not distinguished by case. For example, you cannot create resources named both
        /// "MyResource" and "myresource".</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>The name of the group to create. Do not include the path in this value.</p>
        /// <p>IAM user, group, role, and policy names must be unique within the account. Names are
        /// not distinguished by case. For example, you cannot create resources named both
        /// "MyResource" and "myresource".</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateInstanceProfile`.
    ///
    /// <p> Creates a new instance profile. For information about instance profiles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html">Using
    /// roles for applications on Amazon EC2</a> in the
    /// <i>IAM User Guide</i>, and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-roles-for-amazon-ec2.html#ec2-instance-profile">Instance profiles</a> in the <i>Amazon EC2 User Guide</i>.</p>
    /// <p> For information about the number of instance profiles you can create, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM object
    /// quotas</a> in the <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateInstanceProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_instance_profile_input::Builder,
    }
    impl<C, M, R> CreateInstanceProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateInstanceProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateInstanceProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateInstanceProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateInstanceProfileInputOperationOutputAlias,
                crate::output::CreateInstanceProfileOutput,
                crate::error::CreateInstanceProfileError,
                crate::input::CreateInstanceProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the instance profile to create.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn instance_profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_profile_name(inp);
            self
        }
        /// <p>The name of the instance profile to create.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_instance_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_profile_name(input);
            self
        }
        /// <p> The path to the instance profile. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// Identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path(inp);
            self
        }
        /// <p> The path to the instance profile. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// Identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you want to attach to the newly created IAM instance profile.
        /// Each tag consists of a key name and an associated value. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
        /// fails and the resource is not created.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags that you want to attach to the newly created IAM instance profile.
        /// Each tag consists of a key name and an associated value. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
        /// fails and the resource is not created.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLoginProfile`.
    ///
    /// <p>Creates a password for the specified IAM user. A password allows an IAM user to
    /// access Amazon Web Services services through the Amazon Web Services Management Console.</p>
    /// <p>You can use the CLI, the Amazon Web Services API, or the <b>Users</b> page in the IAM console to create a password for any IAM user.
    /// Use <a>ChangePassword</a> to update your own existing password in the
    /// <b>My Security Credentials</b> page in the
    /// Amazon Web Services Management Console.</p>
    /// <p>For more information about managing passwords, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html">Managing passwords</a> in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateLoginProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_login_profile_input::Builder,
    }
    impl<C, M, R> CreateLoginProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLoginProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLoginProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLoginProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLoginProfileInputOperationOutputAlias,
                crate::output::CreateLoginProfileOutput,
                crate::error::CreateLoginProfileError,
                crate::input::CreateLoginProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IAM user to create a password for. The user must already
        /// exist.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the IAM user to create a password for. The user must already
        /// exist.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The new password for the user.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// that is used to validate this parameter is a string of characters. That string can include almost any printable
        /// ASCII character from the space (<code>\u0020</code>) through the end of the ASCII character range (<code>\u00FF</code>).
        /// You can also include the tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)
        /// characters. Any of these characters are valid in a password. However, many tools, such
        /// as the Amazon Web Services Management Console, might restrict the ability to type certain characters because they have
        /// special meaning within that tool.</p>
        pub fn password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(inp);
            self
        }
        /// <p>The new password for the user.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// that is used to validate this parameter is a string of characters. That string can include almost any printable
        /// ASCII character from the space (<code>\u0020</code>) through the end of the ASCII character range (<code>\u00FF</code>).
        /// You can also include the tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)
        /// characters. Any of these characters are valid in a password. However, many tools, such
        /// as the Amazon Web Services Management Console, might restrict the ability to type certain characters because they have
        /// special meaning within that tool.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// <p>Specifies whether the user is required to set a new password on next sign-in.</p>
        pub fn password_reset_required(mut self, inp: bool) -> Self {
            self.inner = self.inner.password_reset_required(inp);
            self
        }
        /// <p>Specifies whether the user is required to set a new password on next sign-in.</p>
        pub fn set_password_reset_required(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_password_reset_required(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateOpenIDConnectProvider`.
    ///
    /// <p>Creates an IAM entity to describe an identity provider (IdP) that supports <a href="http://openid.net/connect/">OpenID Connect (OIDC)</a>.</p>
    /// <p>The OIDC provider that you create with this operation can be used as a principal in a
    /// role's trust policy. Such a policy establishes a trust relationship between Amazon Web Services and
    /// the OIDC provider.</p>
    /// <p>If you are using an OIDC identity provider from Google, Facebook, or Amazon Cognito, you don't
    /// need to create a separate IAM identity provider. These OIDC identity providers are
    /// already built-in to Amazon Web Services and are available for your use. Instead, you can move directly
    /// to creating new roles using your identity provider. To learn more, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-idp_oidc.html">Creating
    /// a role for web identity or OpenID connect federation</a> in the <i>IAM
    /// User Guide</i>.</p>
    /// <p>When you create the IAM OIDC provider, you specify the following:</p>
    /// <ul>
    /// <li>
    /// <p>The URL of the OIDC identity provider (IdP) to trust</p>
    /// </li>
    /// <li>
    /// <p>A list of client IDs (also known as audiences) that identify the application
    /// or applications  allowed to authenticate using the OIDC provider</p>
    /// </li>
    /// <li>
    /// <p>A list of thumbprints of one or more server certificates that the IdP
    /// uses</p>
    /// </li>
    /// </ul>
    /// <p>You get all of this information from the OIDC IdP you want to use to access
    /// Amazon Web Services.</p>
    /// <note>
    /// <p>Amazon Web Services secures communication with some OIDC identity providers (IdPs) through our
    /// library of trusted certificate authorities (CAs) instead of using a certificate
    /// thumbprint to verify your IdP server certificate. These OIDC IdPs include Google, and
    /// those that use an Amazon S3 bucket to host a JSON Web Key Set (JWKS) endpoint. In these
    /// cases, your legacy thumbprint remains in your configuration, but is no longer used for validation.</p>
    /// </note>
    /// <note>
    /// <p>The trust for the OIDC provider is derived from the IAM provider that this
    /// operation creates. Therefore, it is best to limit access to the <a>CreateOpenIDConnectProvider</a> operation to highly privileged
    /// users.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateOpenIDConnectProvider<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_open_id_connect_provider_input::Builder,
    }
    impl<C, M, R> CreateOpenIDConnectProvider<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateOpenIDConnectProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateOpenIdConnectProviderOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateOpenIDConnectProviderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateOpenIdConnectProviderInputOperationOutputAlias,
                crate::output::CreateOpenIdConnectProviderOutput,
                crate::error::CreateOpenIDConnectProviderError,
                crate::input::CreateOpenIdConnectProviderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The URL of the identity provider. The URL must begin with <code>https://</code> and
        /// should correspond to the <code>iss</code> claim in the provider's OpenID Connect ID
        /// tokens. Per the OIDC standard, path components are allowed but query parameters are not.
        /// Typically the URL consists of only a hostname, like
        /// <code>https://server.example.org</code> or <code>https://example.com</code>. The URL
        /// should not contain a port number. </p>
        /// <p>You cannot register the same provider multiple times in a single Amazon Web Services account. If you
        /// try to submit a URL that has already been used for an OpenID Connect provider in the
        /// Amazon Web Services account, you will get an error.</p>
        pub fn url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.url(inp);
            self
        }
        /// <p>The URL of the identity provider. The URL must begin with <code>https://</code> and
        /// should correspond to the <code>iss</code> claim in the provider's OpenID Connect ID
        /// tokens. Per the OIDC standard, path components are allowed but query parameters are not.
        /// Typically the URL consists of only a hostname, like
        /// <code>https://server.example.org</code> or <code>https://example.com</code>. The URL
        /// should not contain a port number. </p>
        /// <p>You cannot register the same provider multiple times in a single Amazon Web Services account. If you
        /// try to submit a URL that has already been used for an OpenID Connect provider in the
        /// Amazon Web Services account, you will get an error.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_url(input);
            self
        }
        /// Appends an item to `ClientIDList`.
        ///
        /// To override the contents of this collection use [`set_client_id_list`](Self::set_client_id_list).
        ///
        /// <p>Provides a list of client IDs, also known as audiences. When a mobile or web app registers
        /// with an OpenID Connect provider, they establish a value that identifies the application.
        /// This is the value that's sent as the <code>client_id</code> parameter on OAuth
        /// requests.</p>
        /// <p>You can register multiple client IDs with the same provider. For example, you might
        /// have multiple applications that use the same OIDC provider. You cannot register more
        /// than 100 client IDs with a single IAM OIDC provider.</p>
        /// <p>There is no defined format for a client ID. The
        /// <code>CreateOpenIDConnectProviderRequest</code> operation accepts client IDs up to
        /// 255 characters long.</p>
        pub fn client_id_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_id_list(inp);
            self
        }
        /// <p>Provides a list of client IDs, also known as audiences. When a mobile or web app registers
        /// with an OpenID Connect provider, they establish a value that identifies the application.
        /// This is the value that's sent as the <code>client_id</code> parameter on OAuth
        /// requests.</p>
        /// <p>You can register multiple client IDs with the same provider. For example, you might
        /// have multiple applications that use the same OIDC provider. You cannot register more
        /// than 100 client IDs with a single IAM OIDC provider.</p>
        /// <p>There is no defined format for a client ID. The
        /// <code>CreateOpenIDConnectProviderRequest</code> operation accepts client IDs up to
        /// 255 characters long.</p>
        pub fn set_client_id_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_client_id_list(input);
            self
        }
        /// Appends an item to `ThumbprintList`.
        ///
        /// To override the contents of this collection use [`set_thumbprint_list`](Self::set_thumbprint_list).
        ///
        /// <p>A list of server certificate thumbprints for the OpenID Connect (OIDC) identity
        /// provider's server certificates. Typically this list includes only one entry. However,
        /// IAM lets you have up to five thumbprints for an OIDC provider. This lets you maintain
        /// multiple thumbprints if the identity provider is rotating certificates.</p>
        /// <p>The server certificate thumbprint is the hex-encoded SHA-1 hash value of the X.509
        /// certificate used by the domain where the OpenID Connect provider makes its keys
        /// available. It is always a 40-character string.</p>
        /// <p>You must provide at least one thumbprint when creating an IAM OIDC provider. For
        /// example, assume that the OIDC provider is <code>server.example.com</code> and the
        /// provider stores its keys at https://keys.server.example.com/openid-connect. In that
        /// case, the thumbprint string would be the hex-encoded SHA-1 hash value of the certificate
        /// used by <code>https://keys.server.example.com.</code>
        /// </p>
        /// <p>For more information about obtaining the OIDC provider thumbprint, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/identity-providers-oidc-obtain-thumbprint.html">Obtaining the
        /// thumbprint for an OpenID Connect provider</a> in the <i>IAM User
        /// Guide</i>.</p>
        pub fn thumbprint_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.thumbprint_list(inp);
            self
        }
        /// <p>A list of server certificate thumbprints for the OpenID Connect (OIDC) identity
        /// provider's server certificates. Typically this list includes only one entry. However,
        /// IAM lets you have up to five thumbprints for an OIDC provider. This lets you maintain
        /// multiple thumbprints if the identity provider is rotating certificates.</p>
        /// <p>The server certificate thumbprint is the hex-encoded SHA-1 hash value of the X.509
        /// certificate used by the domain where the OpenID Connect provider makes its keys
        /// available. It is always a 40-character string.</p>
        /// <p>You must provide at least one thumbprint when creating an IAM OIDC provider. For
        /// example, assume that the OIDC provider is <code>server.example.com</code> and the
        /// provider stores its keys at https://keys.server.example.com/openid-connect. In that
        /// case, the thumbprint string would be the hex-encoded SHA-1 hash value of the certificate
        /// used by <code>https://keys.server.example.com.</code>
        /// </p>
        /// <p>For more information about obtaining the OIDC provider thumbprint, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/identity-providers-oidc-obtain-thumbprint.html">Obtaining the
        /// thumbprint for an OpenID Connect provider</a> in the <i>IAM User
        /// Guide</i>.</p>
        pub fn set_thumbprint_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_thumbprint_list(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you want to attach to the new IAM OpenID Connect (OIDC) provider.
        /// Each tag consists of a key name and an associated value. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
        /// fails and the resource is not created.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags that you want to attach to the new IAM OpenID Connect (OIDC) provider.
        /// Each tag consists of a key name and an associated value. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
        /// fails and the resource is not created.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePolicy`.
    ///
    /// <p>Creates a new managed policy for your Amazon Web Services account.</p>
    /// <p>This operation creates a policy version with a version identifier of <code>v1</code>
    /// and sets v1 as the policy's default version. For more information about policy versions,
    /// see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed policies</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// <p>As a best practice, you can validate your IAM policies.
    /// To learn more, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_policy-validator.html">Validating IAM policies</a>
    /// in the <i>IAM User Guide</i>.</p>
    /// <p>For more information about managed policies in general, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed
    /// policies and inline policies</a> in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreatePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_policy_input::Builder,
    }
    impl<C, M, R> CreatePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePolicyInputOperationOutputAlias,
                crate::output::CreatePolicyOutput,
                crate::error::CreatePolicyError,
                crate::input::CreatePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The friendly name of the policy.</p>
        /// <p>IAM user, group, role, and policy names must be unique within the account. Names are
        /// not distinguished by case. For example, you cannot create resources named both
        /// "MyResource" and "myresource".</p>
        pub fn policy_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(inp);
            self
        }
        /// <p>The friendly name of the policy.</p>
        /// <p>IAM user, group, role, and policy names must be unique within the account. Names are
        /// not distinguished by case. For example, you cannot create resources named both
        /// "MyResource" and "myresource".</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The path for the policy.</p>
        /// <p>For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        /// <note>
        /// <p>You cannot use an asterisk (*) in the path name.</p>
        /// </note>
        pub fn path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path(inp);
            self
        }
        /// <p>The path for the policy.</p>
        /// <p>For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        /// <note>
        /// <p>You cannot use an asterisk (*) in the path name.</p>
        /// </note>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path(input);
            self
        }
        /// <p>The JSON policy document that you want to use as the content for the new
        /// policy.</p>
        /// <p>You must provide policies in JSON format in IAM. However, for CloudFormation
        /// templates formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to JSON format before submitting it to
        ///
        /// IAM.</p>
        /// <p>The maximum length of the policy document that you can pass in this operation,
        /// including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length">IAM and STS character quotas</a>.</p>
        /// <p>To learn more about JSON policy grammar, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_grammar.html">Grammar of the IAM JSON
        /// policy language</a> in the <i>IAM User Guide</i>. </p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn policy_document(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_document(inp);
            self
        }
        /// <p>The JSON policy document that you want to use as the content for the new
        /// policy.</p>
        /// <p>You must provide policies in JSON format in IAM. However, for CloudFormation
        /// templates formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to JSON format before submitting it to
        ///
        /// IAM.</p>
        /// <p>The maximum length of the policy document that you can pass in this operation,
        /// including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length">IAM and STS character quotas</a>.</p>
        /// <p>To learn more about JSON policy grammar, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_grammar.html">Grammar of the IAM JSON
        /// policy language</a> in the <i>IAM User Guide</i>. </p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_document(input);
            self
        }
        /// <p>A friendly description of the policy.</p>
        /// <p>Typically used to store information about the permissions defined in the policy. For
        /// example, "Grants access to production DynamoDB tables."</p>
        /// <p>The policy description is immutable. After a value is assigned, it cannot be
        /// changed.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A friendly description of the policy.</p>
        /// <p>Typically used to store information about the permissions defined in the policy. For
        /// example, "Grants access to production DynamoDB tables."</p>
        /// <p>The policy description is immutable. After a value is assigned, it cannot be
        /// changed.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you want to attach to the new IAM customer managed policy.
        /// Each tag consists of a key name and an associated value. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
        /// fails and the resource is not created.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags that you want to attach to the new IAM customer managed policy.
        /// Each tag consists of a key name and an associated value. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
        /// fails and the resource is not created.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePolicyVersion`.
    ///
    /// <p>Creates a new version of the specified managed policy. To update a managed policy, you
    /// create a new policy version. A managed policy can have up to five versions. If the
    /// policy has five versions, you must delete an existing version using <a>DeletePolicyVersion</a> before you create a new version.</p>
    /// <p>Optionally, you can set the new version as the policy's default version. The default
    /// version is the version that is in effect for the IAM users, groups, and roles to which
    /// the policy is attached.</p>
    /// <p>For more information about managed policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
    /// policies</a> in the <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreatePolicyVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_policy_version_input::Builder,
    }
    impl<C, M, R> CreatePolicyVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePolicyVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePolicyVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePolicyVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePolicyVersionInputOperationOutputAlias,
                crate::output::CreatePolicyVersionOutput,
                crate::error::CreatePolicyVersionError,
                crate::input::CreatePolicyVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy to which you want to add a new
        /// version.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn policy_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy to which you want to add a new
        /// version.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_arn(input);
            self
        }
        /// <p>The JSON policy document that you want to use as the content for this new version of
        /// the policy.</p>
        /// <p>You must provide policies in JSON format in IAM. However, for CloudFormation
        /// templates formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to JSON format before submitting it to
        /// IAM.</p>
        /// <p>The maximum length of the policy document that you can pass in this operation,
        /// including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length">IAM and STS character quotas</a>.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn policy_document(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_document(inp);
            self
        }
        /// <p>The JSON policy document that you want to use as the content for this new version of
        /// the policy.</p>
        /// <p>You must provide policies in JSON format in IAM. However, for CloudFormation
        /// templates formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to JSON format before submitting it to
        /// IAM.</p>
        /// <p>The maximum length of the policy document that you can pass in this operation,
        /// including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length">IAM and STS character quotas</a>.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_document(input);
            self
        }
        /// <p>Specifies whether to set this version as the policy's default version.</p>
        /// <p>When this parameter is <code>true</code>, the new policy version becomes the operative
        /// version. That is, it becomes the version that is in effect for the IAM users, groups,
        /// and roles that the policy is attached to.</p>
        /// <p>For more information about managed policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
        /// policies</a> in the <i>IAM User Guide</i>.</p>
        pub fn set_as_default(mut self, inp: bool) -> Self {
            self.inner = self.inner.set_as_default(inp);
            self
        }
        /// <p>Specifies whether to set this version as the policy's default version.</p>
        /// <p>When this parameter is <code>true</code>, the new policy version becomes the operative
        /// version. That is, it becomes the version that is in effect for the IAM users, groups,
        /// and roles that the policy is attached to.</p>
        /// <p>For more information about managed policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
        /// policies</a> in the <i>IAM User Guide</i>.</p>
        pub fn set_set_as_default(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_set_as_default(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRole`.
    ///
    /// <p>Creates a new role for your Amazon Web Services account. For more information about roles, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">IAM
    /// roles</a>. For information about quotas for role names and the number of roles
    /// you can create, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRole<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_role_input::Builder,
    }
    impl<C, M, R> CreateRole<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRole`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRoleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRoleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRoleInputOperationOutputAlias,
                crate::output::CreateRoleOutput,
                crate::error::CreateRoleError,
                crate::input::CreateRoleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The path to the role. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// Identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path(inp);
            self
        }
        /// <p> The path to the role. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// Identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path(input);
            self
        }
        /// <p>The name of the role to create.</p>
        /// <p>IAM user, group, role, and policy names must be unique within the account. Names are
        /// not distinguished by case. For example, you cannot create resources named both
        /// "MyResource" and "myresource".</p>
        pub fn role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_name(inp);
            self
        }
        /// <p>The name of the role to create.</p>
        /// <p>IAM user, group, role, and policy names must be unique within the account. Names are
        /// not distinguished by case. For example, you cannot create resources named both
        /// "MyResource" and "myresource".</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_name(input);
            self
        }
        /// <p>The trust relationship policy document that grants an entity permission to assume the
        /// role.</p>
        /// <p>In IAM, you must provide a JSON policy that has been converted to a string. However,
        /// for CloudFormation templates formatted in YAML, you can provide the policy in JSON
        /// or YAML format. CloudFormation always converts a YAML policy to JSON format before
        /// submitting it to IAM.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        /// <p> Upon success, the response includes the same trust policy in JSON format.</p>
        pub fn assume_role_policy_document(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assume_role_policy_document(inp);
            self
        }
        /// <p>The trust relationship policy document that grants an entity permission to assume the
        /// role.</p>
        /// <p>In IAM, you must provide a JSON policy that has been converted to a string. However,
        /// for CloudFormation templates formatted in YAML, you can provide the policy in JSON
        /// or YAML format. CloudFormation always converts a YAML policy to JSON format before
        /// submitting it to IAM.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        /// <p> Upon success, the response includes the same trust policy in JSON format.</p>
        pub fn set_assume_role_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assume_role_policy_document(input);
            self
        }
        /// <p>A description of the role.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the role.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The maximum session duration (in seconds) that you want to set for the specified role.
        /// If you do not specify a value for this setting, the default maximum of one hour is
        /// applied. This setting can have a value from 1 hour to 12 hours.</p>
        /// <p>Anyone who assumes the role from the  or API can use the
        /// <code>DurationSeconds</code> API parameter or the <code>duration-seconds</code> CLI
        /// parameter to request a longer session. The <code>MaxSessionDuration</code> setting
        /// determines the maximum duration that can be requested using the
        /// <code>DurationSeconds</code> parameter. If users don't specify a value for the
        /// <code>DurationSeconds</code> parameter, their security credentials are valid for one
        /// hour by default. This applies when you use the <code>AssumeRole*</code> API operations
        /// or the <code>assume-role*</code> CLI operations but does not apply when you use those
        /// operations to create a console URL. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html">Using IAM
        /// roles</a> in the <i>IAM User Guide</i>.</p>
        pub fn max_session_duration(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_session_duration(inp);
            self
        }
        /// <p>The maximum session duration (in seconds) that you want to set for the specified role.
        /// If you do not specify a value for this setting, the default maximum of one hour is
        /// applied. This setting can have a value from 1 hour to 12 hours.</p>
        /// <p>Anyone who assumes the role from the  or API can use the
        /// <code>DurationSeconds</code> API parameter or the <code>duration-seconds</code> CLI
        /// parameter to request a longer session. The <code>MaxSessionDuration</code> setting
        /// determines the maximum duration that can be requested using the
        /// <code>DurationSeconds</code> parameter. If users don't specify a value for the
        /// <code>DurationSeconds</code> parameter, their security credentials are valid for one
        /// hour by default. This applies when you use the <code>AssumeRole*</code> API operations
        /// or the <code>assume-role*</code> CLI operations but does not apply when you use those
        /// operations to create a console URL. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html">Using IAM
        /// roles</a> in the <i>IAM User Guide</i>.</p>
        pub fn set_max_session_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_session_duration(input);
            self
        }
        /// <p>The ARN of the policy that is used to set the permissions boundary for the
        /// role.</p>
        pub fn permissions_boundary(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permissions_boundary(inp);
            self
        }
        /// <p>The ARN of the policy that is used to set the permissions boundary for the
        /// role.</p>
        pub fn set_permissions_boundary(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permissions_boundary(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you want to attach to the new role. Each tag consists of a key name and an associated value.
        /// For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
        /// fails and the resource is not created.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags that you want to attach to the new role. Each tag consists of a key name and an associated value.
        /// For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
        /// fails and the resource is not created.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSAMLProvider`.
    ///
    /// <p>Creates an IAM resource that describes an identity provider (IdP) that supports SAML
    /// 2.0.</p>
    /// <p>The SAML provider resource that you create with this operation can be used as a
    /// principal in an IAM role's trust policy. Such a policy can enable federated users who
    /// sign in using the SAML IdP to assume the role. You can create an IAM role that
    /// supports Web-based single sign-on (SSO) to the Amazon Web Services Management Console or one that supports API access
    /// to Amazon Web Services.</p>
    /// <p>When you create the SAML provider resource, you upload a SAML metadata document that
    /// you get from your IdP. That document includes the issuer's name, expiration information,
    /// and keys that can be used to validate the SAML authentication response (assertions) that
    /// the IdP sends. You must generate the metadata document using the identity management
    /// software that is used as your organization's IdP.</p>
    /// <note>
    /// <p> This operation requires <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.</p>
    /// </note>
    /// <p> For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-saml.html">Enabling SAML 2.0
    /// federated users to access the Amazon Web Services Management Console</a> and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html">About SAML 2.0-based
    /// federation</a> in the <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateSAMLProvider<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_saml_provider_input::Builder,
    }
    impl<C, M, R> CreateSAMLProvider<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSAMLProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSamlProviderOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSAMLProviderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSamlProviderInputOperationOutputAlias,
                crate::output::CreateSamlProviderOutput,
                crate::error::CreateSAMLProviderError,
                crate::input::CreateSamlProviderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An XML document generated by an identity provider (IdP) that supports SAML 2.0. The
        /// document includes the issuer's name, expiration information, and keys that can be used
        /// to validate the SAML authentication response (assertions) that are received from the
        /// IdP. You must generate the metadata document using the identity management software that
        /// is used as your organization's IdP.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html">About SAML 2.0-based
        /// federation</a> in the <i>IAM User Guide</i>
        /// </p>
        pub fn saml_metadata_document(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.saml_metadata_document(inp);
            self
        }
        /// <p>An XML document generated by an identity provider (IdP) that supports SAML 2.0. The
        /// document includes the issuer's name, expiration information, and keys that can be used
        /// to validate the SAML authentication response (assertions) that are received from the
        /// IdP. You must generate the metadata document using the identity management software that
        /// is used as your organization's IdP.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html">About SAML 2.0-based
        /// federation</a> in the <i>IAM User Guide</i>
        /// </p>
        pub fn set_saml_metadata_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_saml_metadata_document(input);
            self
        }
        /// <p>The name of the provider to create.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the provider to create.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you want to attach to the new IAM SAML provider.
        /// Each tag consists of a key name and an associated value. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
        /// fails and the resource is not created.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags that you want to attach to the new IAM SAML provider.
        /// Each tag consists of a key name and an associated value. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
        /// fails and the resource is not created.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateServiceLinkedRole`.
    ///
    /// <p>Creates an IAM role that is linked to a specific Amazon Web Services service. The service controls
    /// the attached policies and when the role can be deleted. This helps ensure that the
    /// service is not broken by an unexpectedly changed or deleted role, which could put your
    /// Amazon Web Services resources into an unknown state. Allowing the service to control the role helps
    /// improve service stability and proper cleanup when a service and its role are no longer
    /// needed. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html">Using service-linked
    /// roles</a> in the <i>IAM User Guide</i>. </p>
    /// <p>To attach a policy to this service-linked role, you must make the request using the
    /// Amazon Web Services service that depends on this role.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateServiceLinkedRole<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_service_linked_role_input::Builder,
    }
    impl<C, M, R> CreateServiceLinkedRole<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateServiceLinkedRole`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateServiceLinkedRoleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateServiceLinkedRoleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateServiceLinkedRoleInputOperationOutputAlias,
                crate::output::CreateServiceLinkedRoleOutput,
                crate::error::CreateServiceLinkedRoleError,
                crate::input::CreateServiceLinkedRoleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The service principal for the Amazon Web Services service to which this role is attached. You use a
        /// string similar to a URL but without the http:// in front. For example:
        /// <code>elasticbeanstalk.amazonaws.com</code>. </p>
        /// <p>Service principals are unique and case-sensitive. To find the exact service principal
        /// for your service-linked role, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-services-that-work-with-iam.html">Amazon Web Services services
        /// that work with IAM</a> in the <i>IAM User Guide</i>. Look for
        /// the services that have <b>Yes </b>in the <b>Service-Linked Role</b> column. Choose the <b>Yes</b> link to view the service-linked role documentation for that
        /// service.</p>
        pub fn aws_service_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_service_name(inp);
            self
        }
        /// <p>The service principal for the Amazon Web Services service to which this role is attached. You use a
        /// string similar to a URL but without the http:// in front. For example:
        /// <code>elasticbeanstalk.amazonaws.com</code>. </p>
        /// <p>Service principals are unique and case-sensitive. To find the exact service principal
        /// for your service-linked role, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-services-that-work-with-iam.html">Amazon Web Services services
        /// that work with IAM</a> in the <i>IAM User Guide</i>. Look for
        /// the services that have <b>Yes </b>in the <b>Service-Linked Role</b> column. Choose the <b>Yes</b> link to view the service-linked role documentation for that
        /// service.</p>
        pub fn set_aws_service_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_service_name(input);
            self
        }
        /// <p>The description of the role.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the role.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p></p>
        /// <p>A string that you provide, which is combined with the service-provided prefix to form
        /// the complete role name. If you make multiple requests for the same service, then you
        /// must supply a different <code>CustomSuffix</code> for each request. Otherwise the
        /// request fails with a duplicate role name error. For example, you could add
        /// <code>-1</code> or <code>-debug</code> to the suffix.</p>
        /// <p>Some services do not support the <code>CustomSuffix</code> parameter. If you provide
        /// an optional suffix and the operation fails, try the operation again without the
        /// suffix.</p>
        pub fn custom_suffix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_suffix(inp);
            self
        }
        /// <p></p>
        /// <p>A string that you provide, which is combined with the service-provided prefix to form
        /// the complete role name. If you make multiple requests for the same service, then you
        /// must supply a different <code>CustomSuffix</code> for each request. Otherwise the
        /// request fails with a duplicate role name error. For example, you could add
        /// <code>-1</code> or <code>-debug</code> to the suffix.</p>
        /// <p>Some services do not support the <code>CustomSuffix</code> parameter. If you provide
        /// an optional suffix and the operation fails, try the operation again without the
        /// suffix.</p>
        pub fn set_custom_suffix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_suffix(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateServiceSpecificCredential`.
    ///
    /// <p>Generates a set of credentials consisting of a user name and password that can be used
    /// to access the service specified in the request. These credentials are generated by
    /// IAM, and can be used only for the specified service. </p>
    /// <p>You can have a maximum of two sets of service-specific credentials for each supported
    /// service per user.</p>
    /// <p>You can create service-specific credentials for CodeCommit and Amazon Keyspaces (for Apache
    /// Cassandra).</p>
    /// <p>You can reset the password to a new service-generated value by calling <a>ResetServiceSpecificCredential</a>.</p>
    /// <p>For more information about service-specific credentials, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_ssh-keys.html">Using IAM
    /// with CodeCommit: Git credentials, SSH keys, and Amazon Web Services access keys</a> in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateServiceSpecificCredential<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_service_specific_credential_input::Builder,
    }
    impl<C, M, R> CreateServiceSpecificCredential<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateServiceSpecificCredential`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateServiceSpecificCredentialOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateServiceSpecificCredentialError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateServiceSpecificCredentialInputOperationOutputAlias,
                crate::output::CreateServiceSpecificCredentialOutput,
                crate::error::CreateServiceSpecificCredentialError,
                crate::input::CreateServiceSpecificCredentialInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IAM user that is to be associated with the credentials. The new
        /// service-specific credentials have the same permissions as the associated user except
        /// that they can be used only to access the specified service.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the IAM user that is to be associated with the credentials. The new
        /// service-specific credentials have the same permissions as the associated user except
        /// that they can be used only to access the specified service.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The name of the Amazon Web Services service that is to be associated with the credentials. The
        /// service you specify here is the only service that can be accessed using these
        /// credentials.</p>
        pub fn service_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_name(inp);
            self
        }
        /// <p>The name of the Amazon Web Services service that is to be associated with the credentials. The
        /// service you specify here is the only service that can be accessed using these
        /// credentials.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUser`.
    ///
    /// <p>Creates a new IAM user for your Amazon Web Services account.</p>
    /// <p> For information about quotas for the number of IAM users you can create, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS
    /// quotas</a> in the <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_user_input::Builder,
    }
    impl<C, M, R> CreateUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUserOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUserInputOperationOutputAlias,
                crate::output::CreateUserOutput,
                crate::error::CreateUserError,
                crate::input::CreateUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The path for the user name. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path(inp);
            self
        }
        /// <p> The path for the user name. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path(input);
            self
        }
        /// <p>The name of the user to create.</p>
        /// <p>IAM user, group, role, and policy names must be unique within the account. Names are
        /// not distinguished by case. For example, you cannot create resources named both
        /// "MyResource" and "myresource".</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the user to create.</p>
        /// <p>IAM user, group, role, and policy names must be unique within the account. Names are
        /// not distinguished by case. For example, you cannot create resources named both
        /// "MyResource" and "myresource".</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The ARN of the policy that is used to set the permissions boundary for the
        /// user.</p>
        pub fn permissions_boundary(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permissions_boundary(inp);
            self
        }
        /// <p>The ARN of the policy that is used to set the permissions boundary for the
        /// user.</p>
        pub fn set_permissions_boundary(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permissions_boundary(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you want to attach to the new user. Each tag consists of a key name and an associated value.
        /// For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
        /// fails and the resource is not created.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags that you want to attach to the new user. Each tag consists of a key name and an associated value.
        /// For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
        /// fails and the resource is not created.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateVirtualMFADevice`.
    ///
    /// <p>Creates a new virtual MFA device for the Amazon Web Services account. After creating the virtual
    /// MFA, use <a>EnableMFADevice</a> to attach the MFA device to an IAM user.
    /// For more information about creating and working with virtual MFA devices, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html">Using a virtual MFA
    /// device</a> in the <i>IAM User Guide</i>.</p>
    /// <p>For information about the maximum number of MFA devices you can create, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS
    /// quotas</a> in the <i>IAM User Guide</i>.</p>
    /// <important>
    /// <p>The seed information contained in the QR code and the Base32 string should be
    /// treated like any other secret access information. In other words, protect the seed
    /// information as you would your Amazon Web Services access keys or your passwords. After you
    /// provision your virtual device, you should ensure that the information is destroyed
    /// following secure procedures.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct CreateVirtualMFADevice<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_virtual_mfa_device_input::Builder,
    }
    impl<C, M, R> CreateVirtualMFADevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateVirtualMFADevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateVirtualMfaDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateVirtualMFADeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateVirtualMfaDeviceInputOperationOutputAlias,
                crate::output::CreateVirtualMfaDeviceOutput,
                crate::error::CreateVirtualMFADeviceError,
                crate::input::CreateVirtualMfaDeviceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The path for the virtual MFA device. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path(inp);
            self
        }
        /// <p> The path for the virtual MFA device. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path(input);
            self
        }
        /// <p>The name of the virtual MFA device. Use with path to uniquely identify a virtual MFA
        /// device.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn virtual_mfa_device_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_mfa_device_name(inp);
            self
        }
        /// <p>The name of the virtual MFA device. Use with path to uniquely identify a virtual MFA
        /// device.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_virtual_mfa_device_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_mfa_device_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you want to attach to the new IAM virtual MFA device.
        /// Each tag consists of a key name and an associated value. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
        /// fails and the resource is not created.</p>
        /// </note>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tags that you want to attach to the new IAM virtual MFA device.
        /// Each tag consists of a key name and an associated value. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
        /// fails and the resource is not created.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeactivateMFADevice`.
    ///
    /// <p>Deactivates the specified MFA device and removes it from association with the user
    /// name for which it was originally enabled.</p>
    /// <p>For more information about creating and working with virtual MFA devices, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html">Enabling a virtual
    /// multi-factor authentication (MFA) device</a> in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeactivateMFADevice<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deactivate_mfa_device_input::Builder,
    }
    impl<C, M, R> DeactivateMFADevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeactivateMFADevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeactivateMfaDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeactivateMFADeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeactivateMfaDeviceInputOperationOutputAlias,
                crate::output::DeactivateMfaDeviceOutput,
                crate::error::DeactivateMFADeviceError,
                crate::input::DeactivateMfaDeviceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user whose MFA device you want to deactivate.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the user whose MFA device you want to deactivate.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The serial number that uniquely identifies the MFA device. For virtual MFA devices,
        /// the serial number is the device ARN.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of upper and lowercase alphanumeric characters with no spaces. You can also include any of the
        /// following characters: =,.@:/-</p>
        pub fn serial_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.serial_number(inp);
            self
        }
        /// <p>The serial number that uniquely identifies the MFA device. For virtual MFA devices,
        /// the serial number is the device ARN.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of upper and lowercase alphanumeric characters with no spaces. You can also include any of the
        /// following characters: =,.@:/-</p>
        pub fn set_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_serial_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAccessKey`.
    ///
    /// <p>Deletes the access key pair associated with the specified IAM user.</p>
    /// <p>If you do not specify a user name, IAM determines the user name implicitly based on
    /// the Amazon Web Services access key ID signing the request. This operation works for access keys under
    /// the Amazon Web Services account. Consequently, you can use this operation to manage Amazon Web Services account root
    /// user credentials even if the Amazon Web Services account has no associated users.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAccessKey<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_access_key_input::Builder,
    }
    impl<C, M, R> DeleteAccessKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAccessKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAccessKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAccessKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAccessKeyInputOperationOutputAlias,
                crate::output::DeleteAccessKeyOutput,
                crate::error::DeleteAccessKeyError,
                crate::input::DeleteAccessKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user whose access key pair you want to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the user whose access key pair you want to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The access key ID for the access key ID and secret access key you want to
        /// delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can
        /// consist of any upper or lowercased letter or digit.</p>
        pub fn access_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_key_id(inp);
            self
        }
        /// <p>The access key ID for the access key ID and secret access key you want to
        /// delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can
        /// consist of any upper or lowercased letter or digit.</p>
        pub fn set_access_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_key_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAccountAlias`.
    ///
    /// <p> Deletes the specified Amazon Web Services account alias. For information about using an Amazon Web Services
    /// account alias, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html">Using an alias for your Amazon Web Services account ID</a> in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAccountAlias<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_account_alias_input::Builder,
    }
    impl<C, M, R> DeleteAccountAlias<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAccountAlias`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAccountAliasOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAccountAliasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAccountAliasInputOperationOutputAlias,
                crate::output::DeleteAccountAliasOutput,
                crate::error::DeleteAccountAliasError,
                crate::input::DeleteAccountAliasInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the account alias to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of
        /// lowercase letters, digits, and dashes. You cannot start or finish with a dash, nor can you have
        /// two dashes in a row.</p>
        pub fn account_alias(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_alias(inp);
            self
        }
        /// <p>The name of the account alias to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of
        /// lowercase letters, digits, and dashes. You cannot start or finish with a dash, nor can you have
        /// two dashes in a row.</p>
        pub fn set_account_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_account_alias(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAccountPasswordPolicy`.
    ///
    /// <p>Deletes the password policy for the Amazon Web Services account. There are no parameters.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAccountPasswordPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_account_password_policy_input::Builder,
    }
    impl<C, M, R> DeleteAccountPasswordPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAccountPasswordPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAccountPasswordPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAccountPasswordPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAccountPasswordPolicyInputOperationOutputAlias,
                crate::output::DeleteAccountPasswordPolicyOutput,
                crate::error::DeleteAccountPasswordPolicyError,
                crate::input::DeleteAccountPasswordPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DeleteGroup`.
    ///
    /// <p>Deletes the specified IAM group. The group must not contain any users or have any
    /// attached policies.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_group_input::Builder,
    }
    impl<C, M, R> DeleteGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteGroupInputOperationOutputAlias,
                crate::output::DeleteGroupOutput,
                crate::error::DeleteGroupError,
                crate::input::DeleteGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IAM group to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>The name of the IAM group to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGroupPolicy`.
    ///
    /// <p>Deletes the specified inline policy that is embedded in the specified IAM
    /// group.</p>
    /// <p>A group can also have managed policies attached to it. To detach a managed policy from
    /// a group, use <a>DetachGroupPolicy</a>. For more information about policies,
    /// refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
    /// policies</a> in the <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteGroupPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_group_policy_input::Builder,
    }
    impl<C, M, R> DeleteGroupPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteGroupPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGroupPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGroupPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteGroupPolicyInputOperationOutputAlias,
                crate::output::DeleteGroupPolicyOutput,
                crate::error::DeleteGroupPolicyError,
                crate::input::DeleteGroupPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name (friendly name, not ARN) identifying the group that the policy is embedded
        /// in.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>The name (friendly name, not ARN) identifying the group that the policy is embedded
        /// in.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The name identifying the policy document to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn policy_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(inp);
            self
        }
        /// <p>The name identifying the policy document to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteInstanceProfile`.
    ///
    /// <p>Deletes the specified instance profile. The instance profile must not have an
    /// associated role.</p>
    /// <important>
    /// <p>Make sure that you do not have any Amazon EC2 instances running with the instance
    /// profile you are about to delete. Deleting a role or instance profile that is
    /// associated with a running instance will break any applications running on the
    /// instance.</p>
    /// </important>
    /// <p>For more information about instance profiles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About instance
    /// profiles</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteInstanceProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_instance_profile_input::Builder,
    }
    impl<C, M, R> DeleteInstanceProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteInstanceProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInstanceProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteInstanceProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteInstanceProfileInputOperationOutputAlias,
                crate::output::DeleteInstanceProfileOutput,
                crate::error::DeleteInstanceProfileError,
                crate::input::DeleteInstanceProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the instance profile to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn instance_profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_profile_name(inp);
            self
        }
        /// <p>The name of the instance profile to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_instance_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_profile_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLoginProfile`.
    ///
    /// <p>Deletes the password for the specified IAM user, which terminates the user's ability
    /// to access Amazon Web Services services through the Amazon Web Services Management Console.</p>
    /// <p>You can use the CLI, the Amazon Web Services API, or the <b>Users</b> page in the IAM console to delete a password for any IAM user.
    /// You can use <a>ChangePassword</a> to update, but not delete, your own
    /// password in the <b>My Security Credentials</b> page in the
    /// Amazon Web Services Management Console.</p>
    /// <important>
    /// <p> Deleting a user's password does not prevent a user from accessing Amazon Web Services through
    /// the command line interface or the API. To prevent all user access, you must also
    /// either make any access keys inactive or delete them. For more information about
    /// making keys inactive or deleting them, see <a>UpdateAccessKey</a> and
    /// <a>DeleteAccessKey</a>. </p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct DeleteLoginProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_login_profile_input::Builder,
    }
    impl<C, M, R> DeleteLoginProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLoginProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLoginProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLoginProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLoginProfileInputOperationOutputAlias,
                crate::output::DeleteLoginProfileOutput,
                crate::error::DeleteLoginProfileError,
                crate::input::DeleteLoginProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user whose password you want to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the user whose password you want to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteOpenIDConnectProvider`.
    ///
    /// <p>Deletes an OpenID Connect identity provider (IdP) resource object in IAM.</p>
    /// <p>Deleting an IAM OIDC provider resource does not update any roles that reference the
    /// provider as a principal in their trust policies. Any attempt to assume a role that
    /// references a deleted provider fails.</p>
    /// <p>This operation is idempotent; it does not fail or return an error if you call the
    /// operation for a provider that does not exist.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteOpenIDConnectProvider<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_open_id_connect_provider_input::Builder,
    }
    impl<C, M, R> DeleteOpenIDConnectProvider<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteOpenIDConnectProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteOpenIdConnectProviderOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteOpenIDConnectProviderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteOpenIdConnectProviderInputOperationOutputAlias,
                crate::output::DeleteOpenIdConnectProviderOutput,
                crate::error::DeleteOpenIDConnectProviderError,
                crate::input::DeleteOpenIdConnectProviderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM OpenID Connect provider resource object to
        /// delete. You can get a list of OpenID Connect provider resource ARNs by using the <a>ListOpenIDConnectProviders</a> operation.</p>
        pub fn open_id_connect_provider_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.open_id_connect_provider_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM OpenID Connect provider resource object to
        /// delete. You can get a list of OpenID Connect provider resource ARNs by using the <a>ListOpenIDConnectProviders</a> operation.</p>
        pub fn set_open_id_connect_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_open_id_connect_provider_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePolicy`.
    ///
    /// <p>Deletes the specified managed policy.</p>
    /// <p>Before you can delete a managed policy, you must first detach the policy from all
    /// users, groups, and roles that it is attached to. In addition, you must delete all the
    /// policy's versions. The following steps describe the process for deleting a managed
    /// policy:</p>
    /// <ul>
    /// <li>
    /// <p>Detach the policy from all users, groups, and roles that the policy is
    /// attached to, using <a>DetachUserPolicy</a>, <a>DetachGroupPolicy</a>, or <a>DetachRolePolicy</a>. To
    /// list all the users, groups, and roles that a policy is attached to, use <a>ListEntitiesForPolicy</a>.</p>
    /// </li>
    /// <li>
    /// <p>Delete all versions of the policy using <a>DeletePolicyVersion</a>.
    /// To list the policy's versions, use <a>ListPolicyVersions</a>. You
    /// cannot use <a>DeletePolicyVersion</a> to delete the version that is
    /// marked as the default version. You delete the policy's default version in the
    /// next step of the process.</p>
    /// </li>
    /// <li>
    /// <p>Delete the policy (this automatically deletes the policy's default version)
    /// using this operation.</p>
    /// </li>
    /// </ul>
    /// <p>For information about managed policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
    /// policies</a> in the <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeletePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_policy_input::Builder,
    }
    impl<C, M, R> DeletePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePolicyInputOperationOutputAlias,
                crate::output::DeletePolicyOutput,
                crate::error::DeletePolicyError,
                crate::input::DeletePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to delete.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn policy_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to delete.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePolicyVersion`.
    ///
    /// <p>Deletes the specified version from the specified managed policy.</p>
    /// <p>You cannot delete the default version from a policy using this operation. To delete
    /// the default version from a policy, use <a>DeletePolicy</a>. To find out which
    /// version of a policy is marked as the default version, use <a>ListPolicyVersions</a>.</p>
    /// <p>For information about versions for managed policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
    /// policies</a> in the <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeletePolicyVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_policy_version_input::Builder,
    }
    impl<C, M, R> DeletePolicyVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePolicyVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePolicyVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePolicyVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePolicyVersionInputOperationOutputAlias,
                crate::output::DeletePolicyVersionOutput,
                crate::error::DeletePolicyVersionError,
                crate::input::DeletePolicyVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy from which you want to delete a
        /// version.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn policy_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy from which you want to delete a
        /// version.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_arn(input);
            self
        }
        /// <p>The policy version to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that
        /// consists of the lowercase letter 'v' followed by one or two digits, and optionally
        /// followed by a period '.' and a string of letters and digits.</p>
        /// <p>For more information about managed policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
        /// policies</a> in the <i>IAM User Guide</i>.</p>
        pub fn version_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(inp);
            self
        }
        /// <p>The policy version to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that
        /// consists of the lowercase letter 'v' followed by one or two digits, and optionally
        /// followed by a period '.' and a string of letters and digits.</p>
        /// <p>For more information about managed policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
        /// policies</a> in the <i>IAM User Guide</i>.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRole`.
    ///
    /// <p>Deletes the specified role. The role must not have any policies attached. For more
    /// information about roles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with roles</a>.</p>
    /// <important>
    /// <p>Make sure that you do not have any Amazon EC2 instances running with the role you
    /// are about to delete. Deleting a role or instance profile that is associated with a
    /// running instance will break any applications running on the instance.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRole<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_role_input::Builder,
    }
    impl<C, M, R> DeleteRole<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRole`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRoleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRoleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRoleInputOperationOutputAlias,
                crate::output::DeleteRoleOutput,
                crate::error::DeleteRoleError,
                crate::input::DeleteRoleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the role to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_name(inp);
            self
        }
        /// <p>The name of the role to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRolePermissionsBoundary`.
    ///
    /// <p>Deletes the permissions boundary for the specified IAM role. </p>
    /// <important>
    /// <p>Deleting the permissions boundary for a role might increase its permissions. For
    /// example, it might allow anyone who assumes the role to perform all the actions
    /// granted in its permissions policies. </p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRolePermissionsBoundary<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_role_permissions_boundary_input::Builder,
    }
    impl<C, M, R> DeleteRolePermissionsBoundary<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRolePermissionsBoundary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRolePermissionsBoundaryOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRolePermissionsBoundaryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRolePermissionsBoundaryInputOperationOutputAlias,
                crate::output::DeleteRolePermissionsBoundaryOutput,
                crate::error::DeleteRolePermissionsBoundaryError,
                crate::input::DeleteRolePermissionsBoundaryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name (friendly name, not ARN) of the IAM role from which you want to remove the
        /// permissions boundary.</p>
        pub fn role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_name(inp);
            self
        }
        /// <p>The name (friendly name, not ARN) of the IAM role from which you want to remove the
        /// permissions boundary.</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRolePolicy`.
    ///
    /// <p>Deletes the specified inline policy that is embedded in the specified IAM
    /// role.</p>
    /// <p>A role can also have managed policies attached to it. To detach a managed policy from
    /// a role, use <a>DetachRolePolicy</a>. For more information about policies,
    /// refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
    /// policies</a> in the <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRolePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_role_policy_input::Builder,
    }
    impl<C, M, R> DeleteRolePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRolePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRolePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRolePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRolePolicyInputOperationOutputAlias,
                crate::output::DeleteRolePolicyOutput,
                crate::error::DeleteRolePolicyError,
                crate::input::DeleteRolePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name (friendly name, not ARN) identifying the role that the policy is embedded
        /// in.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_name(inp);
            self
        }
        /// <p>The name (friendly name, not ARN) identifying the role that the policy is embedded
        /// in.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_name(input);
            self
        }
        /// <p>The name of the inline policy to delete from the specified IAM role.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn policy_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(inp);
            self
        }
        /// <p>The name of the inline policy to delete from the specified IAM role.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSAMLProvider`.
    ///
    /// <p>Deletes a SAML provider resource in IAM.</p>
    /// <p>Deleting the provider resource from IAM does not update any roles that reference the
    /// SAML provider resource's ARN as a principal in their trust policies. Any attempt to
    /// assume a role that references a non-existent provider resource ARN fails.</p>
    /// <note>
    /// <p> This operation requires <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSAMLProvider<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_saml_provider_input::Builder,
    }
    impl<C, M, R> DeleteSAMLProvider<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSAMLProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSamlProviderOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSAMLProviderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSamlProviderInputOperationOutputAlias,
                crate::output::DeleteSamlProviderOutput,
                crate::error::DeleteSAMLProviderError,
                crate::input::DeleteSamlProviderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the SAML provider to delete.</p>
        pub fn saml_provider_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.saml_provider_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SAML provider to delete.</p>
        pub fn set_saml_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_saml_provider_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteServerCertificate`.
    ///
    /// <p>Deletes the specified server certificate.</p>
    /// <p>For more information about working with server certificates, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working
    /// with server certificates</a> in the <i>IAM User Guide</i>. This
    /// topic also includes a list of Amazon Web Services services that can use the server certificates that
    /// you manage with IAM.</p>
    /// <important>
    /// <p> If you are using a server certificate with Elastic Load Balancing, deleting the
    /// certificate could have implications for your application. If Elastic Load Balancing
    /// doesn't detect the deletion of bound certificates, it may continue to use the
    /// certificates. This could cause Elastic Load Balancing to stop accepting traffic. We
    /// recommend that you remove the reference to the certificate from Elastic Load
    /// Balancing before using this command to delete the certificate. For more information,
    /// see <a href="https://docs.aws.amazon.com/ElasticLoadBalancing/latest/APIReference/API_DeleteLoadBalancerListeners.html">DeleteLoadBalancerListeners</a> in the <i>Elastic Load Balancing API
    /// Reference</i>.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct DeleteServerCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_server_certificate_input::Builder,
    }
    impl<C, M, R> DeleteServerCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteServerCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteServerCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteServerCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteServerCertificateInputOperationOutputAlias,
                crate::output::DeleteServerCertificateOutput,
                crate::error::DeleteServerCertificateError,
                crate::input::DeleteServerCertificateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the server certificate you want to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn server_certificate_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_certificate_name(inp);
            self
        }
        /// <p>The name of the server certificate you want to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_server_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_server_certificate_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteServiceLinkedRole`.
    ///
    /// <p>Submits a service-linked role deletion request and returns a
    /// <code>DeletionTaskId</code>, which you can use to check the status of the deletion.
    /// Before you call this operation, confirm that the role has no active sessions and that
    /// any resources used by the role in the linked service are deleted. If you call this
    /// operation more than once for the same service-linked role and an earlier deletion task
    /// is not complete, then the <code>DeletionTaskId</code> of the earlier request is
    /// returned.</p>
    /// <p>If you submit a deletion request for a service-linked role whose linked service is
    /// still accessing a resource, then the deletion task fails. If it fails, the <a>GetServiceLinkedRoleDeletionStatus</a> operation returns the reason for the
    /// failure, usually including the resources that must be deleted. To delete the
    /// service-linked role, you must first remove those resources from the linked service and
    /// then submit the deletion request again. Resources are specific to the service that is
    /// linked to the role. For more information about removing resources from a service, see
    /// the <a href="http://docs.aws.amazon.com/">Amazon Web Services documentation</a> for your
    /// service.</p>
    /// <p>For more information about service-linked roles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role">Roles terms and concepts: Amazon Web Services service-linked role</a> in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteServiceLinkedRole<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_service_linked_role_input::Builder,
    }
    impl<C, M, R> DeleteServiceLinkedRole<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteServiceLinkedRole`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteServiceLinkedRoleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteServiceLinkedRoleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteServiceLinkedRoleInputOperationOutputAlias,
                crate::output::DeleteServiceLinkedRoleOutput,
                crate::error::DeleteServiceLinkedRoleError,
                crate::input::DeleteServiceLinkedRoleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the service-linked role to be deleted.</p>
        pub fn role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_name(inp);
            self
        }
        /// <p>The name of the service-linked role to be deleted.</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteServiceSpecificCredential`.
    ///
    /// <p>Deletes the specified service-specific credential.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteServiceSpecificCredential<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_service_specific_credential_input::Builder,
    }
    impl<C, M, R> DeleteServiceSpecificCredential<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteServiceSpecificCredential`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteServiceSpecificCredentialOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteServiceSpecificCredentialError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteServiceSpecificCredentialInputOperationOutputAlias,
                crate::output::DeleteServiceSpecificCredentialOutput,
                crate::error::DeleteServiceSpecificCredentialError,
                crate::input::DeleteServiceSpecificCredentialInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IAM user associated with the service-specific credential. If this
        /// value is not specified, then the operation assumes the user whose credentials are used
        /// to call the operation.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the IAM user associated with the service-specific credential. If this
        /// value is not specified, then the operation assumes the user whose credentials are used
        /// to call the operation.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The unique identifier of the service-specific credential. You can get this value by
        /// calling <a>ListServiceSpecificCredentials</a>.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can
        /// consist of any upper or lowercased letter or digit.</p>
        pub fn service_specific_credential_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.service_specific_credential_id(inp);
            self
        }
        /// <p>The unique identifier of the service-specific credential. You can get this value by
        /// calling <a>ListServiceSpecificCredentials</a>.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can
        /// consist of any upper or lowercased letter or digit.</p>
        pub fn set_service_specific_credential_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_specific_credential_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSigningCertificate`.
    ///
    /// <p>Deletes a signing certificate associated with the specified IAM user.</p>
    /// <p>If you do not specify a user name, IAM determines the user name implicitly based on
    /// the Amazon Web Services access key ID signing the request. This operation works for access keys under
    /// the Amazon Web Services account. Consequently, you can use this operation to manage Amazon Web Services account root
    /// user credentials even if the Amazon Web Services account has no associated IAM users.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSigningCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_signing_certificate_input::Builder,
    }
    impl<C, M, R> DeleteSigningCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSigningCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSigningCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSigningCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSigningCertificateInputOperationOutputAlias,
                crate::output::DeleteSigningCertificateOutput,
                crate::error::DeleteSigningCertificateError,
                crate::input::DeleteSigningCertificateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user the signing certificate belongs to.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the user the signing certificate belongs to.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The ID of the signing certificate to delete.</p>
        /// <p>The format of this parameter, as described by its <a href="http://wikipedia.org/wiki/regex">regex</a> pattern, is a string of
        /// characters that can be upper- or lower-cased letters or digits.</p>
        pub fn certificate_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_id(inp);
            self
        }
        /// <p>The ID of the signing certificate to delete.</p>
        /// <p>The format of this parameter, as described by its <a href="http://wikipedia.org/wiki/regex">regex</a> pattern, is a string of
        /// characters that can be upper- or lower-cased letters or digits.</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSSHPublicKey`.
    ///
    /// <p>Deletes the specified SSH public key.</p>
    /// <p>The SSH public key deleted by this operation is used only for authenticating the
    /// associated IAM user to an CodeCommit repository. For more information about using SSH keys
    /// to authenticate to an CodeCommit repository, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up CodeCommit for
    /// SSH connections</a> in the <i>CodeCommit User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSSHPublicKey<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_ssh_public_key_input::Builder,
    }
    impl<C, M, R> DeleteSSHPublicKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSSHPublicKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSshPublicKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSSHPublicKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSshPublicKeyInputOperationOutputAlias,
                crate::output::DeleteSshPublicKeyOutput,
                crate::error::DeleteSSHPublicKeyError,
                crate::input::DeleteSshPublicKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IAM user associated with the SSH public key.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the IAM user associated with the SSH public key.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The unique identifier for the SSH public key.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can
        /// consist of any upper or lowercased letter or digit.</p>
        pub fn ssh_public_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ssh_public_key_id(inp);
            self
        }
        /// <p>The unique identifier for the SSH public key.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can
        /// consist of any upper or lowercased letter or digit.</p>
        pub fn set_ssh_public_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ssh_public_key_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUser`.
    ///
    /// <p>Deletes the specified IAM user. Unlike the Amazon Web Services Management Console, when you delete a user
    /// programmatically, you must delete the items attached to the user manually, or the
    /// deletion fails. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_manage.html#id_users_deleting_cli">Deleting an IAM
    /// user</a>. Before attempting to delete a user, remove the following items:</p>
    /// <ul>
    /// <li>
    /// <p>Password (<a>DeleteLoginProfile</a>)</p>
    /// </li>
    /// <li>
    /// <p>Access keys (<a>DeleteAccessKey</a>)</p>
    /// </li>
    /// <li>
    /// <p>Signing certificate (<a>DeleteSigningCertificate</a>)</p>
    /// </li>
    /// <li>
    /// <p>SSH public key (<a>DeleteSSHPublicKey</a>)</p>
    /// </li>
    /// <li>
    /// <p>Git credentials (<a>DeleteServiceSpecificCredential</a>)</p>
    /// </li>
    /// <li>
    /// <p>Multi-factor authentication (MFA) device (<a>DeactivateMFADevice</a>, <a>DeleteVirtualMFADevice</a>)</p>
    /// </li>
    /// <li>
    /// <p>Inline policies (<a>DeleteUserPolicy</a>)</p>
    /// </li>
    /// <li>
    /// <p>Attached managed policies (<a>DetachUserPolicy</a>)</p>
    /// </li>
    /// <li>
    /// <p>Group memberships (<a>RemoveUserFromGroup</a>)</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DeleteUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_input::Builder,
    }
    impl<C, M, R> DeleteUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserInputOperationOutputAlias,
                crate::output::DeleteUserOutput,
                crate::error::DeleteUserError,
                crate::input::DeleteUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the user to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUserPermissionsBoundary`.
    ///
    /// <p>Deletes the permissions boundary for the specified IAM user.</p>
    /// <important>
    /// <p>Deleting the permissions boundary for a user might increase its permissions by
    /// allowing the user to perform all the actions granted in its permissions policies.
    /// </p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct DeleteUserPermissionsBoundary<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_permissions_boundary_input::Builder,
    }
    impl<C, M, R> DeleteUserPermissionsBoundary<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUserPermissionsBoundary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserPermissionsBoundaryOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserPermissionsBoundaryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserPermissionsBoundaryInputOperationOutputAlias,
                crate::output::DeleteUserPermissionsBoundaryOutput,
                crate::error::DeleteUserPermissionsBoundaryError,
                crate::input::DeleteUserPermissionsBoundaryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name (friendly name, not ARN) of the IAM user from which you want to remove the
        /// permissions boundary.</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name (friendly name, not ARN) of the IAM user from which you want to remove the
        /// permissions boundary.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUserPolicy`.
    ///
    /// <p>Deletes the specified inline policy that is embedded in the specified IAM
    /// user.</p>
    /// <p>A user can also have managed policies attached to it. To detach a managed policy from
    /// a user, use <a>DetachUserPolicy</a>. For more information about policies,
    /// refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
    /// policies</a> in the <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteUserPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_policy_input::Builder,
    }
    impl<C, M, R> DeleteUserPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUserPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserPolicyInputOperationOutputAlias,
                crate::output::DeleteUserPolicyOutput,
                crate::error::DeleteUserPolicyError,
                crate::input::DeleteUserPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name (friendly name, not ARN) identifying the user that the policy is embedded
        /// in.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name (friendly name, not ARN) identifying the user that the policy is embedded
        /// in.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The name identifying the policy document to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn policy_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(inp);
            self
        }
        /// <p>The name identifying the policy document to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVirtualMFADevice`.
    ///
    /// <p>Deletes a virtual MFA device.</p>
    /// <note>
    /// <p> You must deactivate a user's virtual MFA device before you can delete it. For
    /// information about deactivating MFA devices, see <a>DeactivateMFADevice</a>. </p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteVirtualMFADevice<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_virtual_mfa_device_input::Builder,
    }
    impl<C, M, R> DeleteVirtualMFADevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVirtualMFADevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVirtualMfaDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVirtualMFADeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVirtualMfaDeviceInputOperationOutputAlias,
                crate::output::DeleteVirtualMfaDeviceOutput,
                crate::error::DeleteVirtualMFADeviceError,
                crate::input::DeleteVirtualMfaDeviceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The serial number that uniquely identifies the MFA device. For virtual MFA devices,
        /// the serial number is the same as the ARN.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of upper and lowercase alphanumeric characters with no spaces. You can also include any of the
        /// following characters: =,.@:/-</p>
        pub fn serial_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.serial_number(inp);
            self
        }
        /// <p>The serial number that uniquely identifies the MFA device. For virtual MFA devices,
        /// the serial number is the same as the ARN.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of upper and lowercase alphanumeric characters with no spaces. You can also include any of the
        /// following characters: =,.@:/-</p>
        pub fn set_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_serial_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetachGroupPolicy`.
    ///
    /// <p>Removes the specified managed policy from the specified IAM group.</p>
    /// <p>A group can also have inline policies embedded with it. To delete an inline policy,
    /// use <a>DeleteGroupPolicy</a>. For information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed
    /// policies and inline policies</a> in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DetachGroupPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detach_group_policy_input::Builder,
    }
    impl<C, M, R> DetachGroupPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetachGroupPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetachGroupPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DetachGroupPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetachGroupPolicyInputOperationOutputAlias,
                crate::output::DetachGroupPolicyOutput,
                crate::error::DetachGroupPolicyError,
                crate::input::DetachGroupPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name (friendly name, not ARN) of the IAM group to detach the policy from.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>The name (friendly name, not ARN) of the IAM group to detach the policy from.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to detach.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn policy_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to detach.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetachRolePolicy`.
    ///
    /// <p>Removes the specified managed policy from the specified role.</p>
    /// <p>A role can also have inline policies embedded with it. To delete an inline policy, use
    /// <a>DeleteRolePolicy</a>. For information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed
    /// policies and inline policies</a> in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DetachRolePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detach_role_policy_input::Builder,
    }
    impl<C, M, R> DetachRolePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetachRolePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetachRolePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DetachRolePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetachRolePolicyInputOperationOutputAlias,
                crate::output::DetachRolePolicyOutput,
                crate::error::DetachRolePolicyError,
                crate::input::DetachRolePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name (friendly name, not ARN) of the IAM role to detach the policy from.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_name(inp);
            self
        }
        /// <p>The name (friendly name, not ARN) of the IAM role to detach the policy from.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to detach.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn policy_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to detach.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetachUserPolicy`.
    ///
    /// <p>Removes the specified managed policy from the specified user.</p>
    /// <p>A user can also have inline policies embedded with it. To delete an inline policy, use
    /// <a>DeleteUserPolicy</a>. For information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed
    /// policies and inline policies</a> in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DetachUserPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detach_user_policy_input::Builder,
    }
    impl<C, M, R> DetachUserPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetachUserPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetachUserPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DetachUserPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetachUserPolicyInputOperationOutputAlias,
                crate::output::DetachUserPolicyOutput,
                crate::error::DetachUserPolicyError,
                crate::input::DetachUserPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name (friendly name, not ARN) of the IAM user to detach the policy from.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name (friendly name, not ARN) of the IAM user to detach the policy from.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to detach.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn policy_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to detach.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableMFADevice`.
    ///
    /// <p>Enables the specified MFA device and associates it with the specified IAM user. When
    /// enabled, the MFA device is required for every subsequent login by the IAM user
    /// associated with the device.</p>
    #[derive(std::fmt::Debug)]
    pub struct EnableMFADevice<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_mfa_device_input::Builder,
    }
    impl<C, M, R> EnableMFADevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableMFADevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableMfaDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableMFADeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableMfaDeviceInputOperationOutputAlias,
                crate::output::EnableMfaDeviceOutput,
                crate::error::EnableMFADeviceError,
                crate::input::EnableMfaDeviceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IAM user for whom you want to enable the MFA device.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the IAM user for whom you want to enable the MFA device.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The serial number that uniquely identifies the MFA device. For virtual MFA devices,
        /// the serial number is the device ARN.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of upper and lowercase alphanumeric characters with no spaces. You can also include any of the
        /// following characters: =,.@:/-</p>
        pub fn serial_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.serial_number(inp);
            self
        }
        /// <p>The serial number that uniquely identifies the MFA device. For virtual MFA devices,
        /// the serial number is the device ARN.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of upper and lowercase alphanumeric characters with no spaces. You can also include any of the
        /// following characters: =,.@:/-</p>
        pub fn set_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_serial_number(input);
            self
        }
        /// <p>An authentication code emitted by the device. </p>
        /// <p>The format for this parameter is a string of six digits.</p>
        /// <important>
        /// <p>Submit your request immediately after generating the authentication codes. If you
        /// generate the codes and then wait too long to submit the request, the MFA device
        /// successfully associates with the user but the MFA device becomes out of sync. This
        /// happens because time-based one-time passwords (TOTP) expire after a short period of
        /// time. If this happens, you can <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa_sync.html">resync the
        /// device</a>.</p>
        /// </important>
        pub fn authentication_code1(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_code1(inp);
            self
        }
        /// <p>An authentication code emitted by the device. </p>
        /// <p>The format for this parameter is a string of six digits.</p>
        /// <important>
        /// <p>Submit your request immediately after generating the authentication codes. If you
        /// generate the codes and then wait too long to submit the request, the MFA device
        /// successfully associates with the user but the MFA device becomes out of sync. This
        /// happens because time-based one-time passwords (TOTP) expire after a short period of
        /// time. If this happens, you can <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa_sync.html">resync the
        /// device</a>.</p>
        /// </important>
        pub fn set_authentication_code1(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_code1(input);
            self
        }
        /// <p>A subsequent authentication code emitted by the device.</p>
        /// <p>The format for this parameter is a string of six digits.</p>
        /// <important>
        /// <p>Submit your request immediately after generating the authentication codes. If you
        /// generate the codes and then wait too long to submit the request, the MFA device
        /// successfully associates with the user but the MFA device becomes out of sync. This
        /// happens because time-based one-time passwords (TOTP) expire after a short period of
        /// time. If this happens, you can <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa_sync.html">resync the
        /// device</a>.</p>
        /// </important>
        pub fn authentication_code2(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_code2(inp);
            self
        }
        /// <p>A subsequent authentication code emitted by the device.</p>
        /// <p>The format for this parameter is a string of six digits.</p>
        /// <important>
        /// <p>Submit your request immediately after generating the authentication codes. If you
        /// generate the codes and then wait too long to submit the request, the MFA device
        /// successfully associates with the user but the MFA device becomes out of sync. This
        /// happens because time-based one-time passwords (TOTP) expire after a short period of
        /// time. If this happens, you can <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa_sync.html">resync the
        /// device</a>.</p>
        /// </important>
        pub fn set_authentication_code2(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_code2(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GenerateCredentialReport`.
    ///
    /// <p> Generates a credential report for the Amazon Web Services account. For more information about the
    /// credential report, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting credential reports</a> in
    /// the <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GenerateCredentialReport<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::generate_credential_report_input::Builder,
    }
    impl<C, M, R> GenerateCredentialReport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GenerateCredentialReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GenerateCredentialReportOutput,
            aws_smithy_http::result::SdkError<crate::error::GenerateCredentialReportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GenerateCredentialReportInputOperationOutputAlias,
                crate::output::GenerateCredentialReportOutput,
                crate::error::GenerateCredentialReportError,
                crate::input::GenerateCredentialReportInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GenerateOrganizationsAccessReport`.
    ///
    /// <p>Generates a report for service last accessed data for Organizations. You can generate a
    /// report for any entities (organization root, organizational unit, or account) or policies
    /// in your organization.</p>
    /// <p>To call this operation, you must be signed in using your Organizations management account
    /// credentials. You can use your long-term IAM user or root user credentials, or
    /// temporary credentials from assuming an IAM role. SCPs must be enabled for your
    /// organization root. You must have the required IAM and Organizations permissions. For more
    /// information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Refining permissions using
    /// service last accessed data</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// <p>You can generate a service last accessed data report for entities by specifying only
    /// the entity's path. This data includes a list of services that are allowed by any service
    /// control policies (SCPs) that apply to the entity.</p>
    /// <p>You can generate a service last accessed data report for a policy by specifying an
    /// entity's path and an optional Organizations policy ID. This data includes a list of services that
    /// are allowed by the specified SCP.</p>
    /// <p>For each service in both report types, the data includes the most recent account
    /// activity that the policy allows to account principals in the entity or the entity's
    /// children. For important information about the data, reporting period, permissions
    /// required, troubleshooting, and supported Regions see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing permissions using
    /// service last accessed data</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// <important>
    /// <p>The data includes all attempts to access Amazon Web Services, not just the successful ones. This
    /// includes all attempts that were made using the Amazon Web Services Management Console, the Amazon Web Services API through any
    /// of the SDKs, or any of the command line tools. An unexpected entry in the service
    /// last accessed data does not mean that an account has been compromised, because the
    /// request might have been denied. Refer to your CloudTrail logs as the authoritative
    /// source for information about all API calls and whether they were successful or
    /// denied access. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/cloudtrail-integration.html">Logging IAM events with
    /// CloudTrail</a> in the <i>IAM User Guide</i>.</p>
    /// </important>
    /// <p>This operation returns a <code>JobId</code>. Use this parameter in the <code>
    /// <a>GetOrganizationsAccessReport</a>
    /// </code> operation to check the status of
    /// the report generation. To check the status of this request, use the <code>JobId</code>
    /// parameter in the <code>
    /// <a>GetOrganizationsAccessReport</a>
    /// </code> operation
    /// and test the <code>JobStatus</code> response parameter. When the job is complete, you
    /// can retrieve the report.</p>
    /// <p>To generate a service last accessed data report for entities, specify an entity path
    /// without specifying the optional Organizations policy ID. The type of entity that you specify
    /// determines the data returned in the report.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Root</b> – When you specify the
    /// organizations root as the entity, the resulting report lists all of the services
    /// allowed by SCPs that are attached to your root. For each service, the report
    /// includes data for all accounts in your organization except the
    /// management account, because the management account is not limited by SCPs.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>OU</b> – When you specify an
    /// organizational unit (OU) as the entity, the resulting report lists all of the
    /// services allowed by SCPs that are attached to the OU and its parents. For each
    /// service, the report includes data for all accounts in the OU or its children.
    /// This data excludes the management account, because the management account is not
    /// limited by SCPs.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>management account</b> – When you specify the
    /// management account, the resulting report lists all Amazon Web Services services, because the
    /// management account is not limited by SCPs. For each service, the report includes
    /// data for only the management account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Account</b> – When you specify another
    /// account as the entity, the resulting report lists all of the services allowed by
    /// SCPs that are attached to the account and its parents. For each service, the
    /// report includes data for only the specified account.</p>
    /// </li>
    /// </ul>
    /// <p>To generate a service last accessed data report for policies, specify an entity path
    /// and the optional Organizations policy ID. The type of entity that you specify determines the data
    /// returned for each service.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Root</b> – When you specify the root
    /// entity and a policy ID, the resulting report lists all of the services that are
    /// allowed by the specified SCP. For each service, the report includes data for all
    /// accounts in your organization to which the SCP applies. This data excludes the
    /// management account, because the management account is not limited by SCPs. If the
    /// SCP is not attached to any entities in the organization, then the report will
    /// return a list of services with no data.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>OU</b> – When you specify an OU entity and
    /// a policy ID, the resulting report lists all of the services that are allowed by
    /// the specified SCP. For each service, the report includes data for all accounts
    /// in the OU or its children to which the SCP applies. This means that other
    /// accounts outside the OU that are affected by the SCP might not be included in
    /// the data. This data excludes the management account, because the
    /// management account is not limited by SCPs. If the SCP is not attached to the OU
    /// or one of its children, the report will return a list of services with no
    /// data.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>management account</b> – When you specify the
    /// management account, the resulting report lists all Amazon Web Services services, because the
    /// management account is not limited by SCPs. If you specify a policy ID in the CLI
    /// or API, the policy is ignored. For each service, the report includes data for
    /// only the management account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Account</b> – When you specify another
    /// account entity and a policy ID, the resulting report lists all of the services
    /// that are allowed by the specified SCP. For each service, the report includes
    /// data for only the specified account. This means that other accounts in the
    /// organization that are affected by the SCP might not be included in the data. If
    /// the SCP is not attached to the account, the report will return a list of
    /// services with no data.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>Service last accessed data does not use other policy types when determining
    /// whether a principal could access a service. These other policy types include
    /// identity-based policies, resource-based policies, access control lists, IAM
    /// permissions boundaries, and STS assume role policies. It only applies SCP logic.
    /// For more about the evaluation of policy types, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics">Evaluating policies</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// </note>
    /// <p>For more information about service last accessed data, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing policy scope by
    /// viewing user activity</a> in the <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GenerateOrganizationsAccessReport<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::generate_organizations_access_report_input::Builder,
    }
    impl<C, M, R> GenerateOrganizationsAccessReport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GenerateOrganizationsAccessReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GenerateOrganizationsAccessReportOutput,
            aws_smithy_http::result::SdkError<crate::error::GenerateOrganizationsAccessReportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GenerateOrganizationsAccessReportInputOperationOutputAlias,
                crate::output::GenerateOrganizationsAccessReportOutput,
                crate::error::GenerateOrganizationsAccessReportError,
                crate::input::GenerateOrganizationsAccessReportInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The path of the Organizations entity (root, OU, or account). You can build an entity path
        /// using the known structure of your organization. For example, assume that your account ID
        /// is <code>123456789012</code> and its parent OU ID is <code>ou-rge0-awsabcde</code>. The
        /// organization root ID is <code>r-f6g7h8i9j0example</code> and your organization ID is
        /// <code>o-a1b2c3d4e5</code>. Your entity path is
        /// <code>o-a1b2c3d4e5/r-f6g7h8i9j0example/ou-rge0-awsabcde/123456789012</code>.</p>
        pub fn entity_path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_path(inp);
            self
        }
        /// <p>The path of the Organizations entity (root, OU, or account). You can build an entity path
        /// using the known structure of your organization. For example, assume that your account ID
        /// is <code>123456789012</code> and its parent OU ID is <code>ou-rge0-awsabcde</code>. The
        /// organization root ID is <code>r-f6g7h8i9j0example</code> and your organization ID is
        /// <code>o-a1b2c3d4e5</code>. Your entity path is
        /// <code>o-a1b2c3d4e5/r-f6g7h8i9j0example/ou-rge0-awsabcde/123456789012</code>.</p>
        pub fn set_entity_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_path(input);
            self
        }
        /// <p>The identifier of the Organizations service control policy (SCP). This parameter is
        /// optional.</p>
        /// <p>This ID is used to generate information about when an account principal that is
        /// limited by the SCP attempted to access an Amazon Web Services service.</p>
        pub fn organizations_policy_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.organizations_policy_id(inp);
            self
        }
        /// <p>The identifier of the Organizations service control policy (SCP). This parameter is
        /// optional.</p>
        /// <p>This ID is used to generate information about when an account principal that is
        /// limited by the SCP attempted to access an Amazon Web Services service.</p>
        pub fn set_organizations_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_organizations_policy_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GenerateServiceLastAccessedDetails`.
    ///
    /// <p>Generates a report that includes details about when an IAM resource (user, group,
    /// role, or policy) was last used in an attempt to access Amazon Web Services services. Recent activity
    /// usually appears within four hours. IAM reports activity for the last 365 days, or less
    /// if your Region began supporting this feature within the last year. For more information,
    /// see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period">Regions where data is tracked</a>.</p>
    /// <important>
    /// <p>The service last accessed data includes all attempts to access an Amazon Web Services API, not
    /// just the successful ones. This includes all attempts that were made using the
    /// Amazon Web Services Management Console, the Amazon Web Services API through any of the SDKs, or any of the command line tools.
    /// An unexpected entry in the service last accessed data does not mean that your
    /// account has been compromised, because the request might have been denied. Refer to
    /// your CloudTrail logs as the authoritative source for information about all API calls
    /// and whether they were successful or denied access. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/cloudtrail-integration.html">Logging
    /// IAM events with CloudTrail</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// </important>
    /// <p>The <code>GenerateServiceLastAccessedDetails</code> operation returns a
    /// <code>JobId</code>. Use this parameter in the following operations to retrieve the
    /// following details from your report: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a>GetServiceLastAccessedDetails</a> – Use this operation
    /// for users, groups, roles, or policies to list every Amazon Web Services service that the
    /// resource could access using permissions policies. For each service, the response
    /// includes information about the most recent access attempt.</p>
    /// <p>The <code>JobId</code> returned by
    /// <code>GenerateServiceLastAccessedDetail</code> must be used by the same role
    /// within a session, or by the same user when used to call
    /// <code>GetServiceLastAccessedDetail</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <a>GetServiceLastAccessedDetailsWithEntities</a> – Use this
    /// operation for groups and policies to list information about the associated
    /// entities (users or roles) that attempted to access a specific Amazon Web Services service.
    /// </p>
    /// </li>
    /// </ul>
    /// <p>To check the status of the <code>GenerateServiceLastAccessedDetails</code> request,
    /// use the <code>JobId</code> parameter in the same operations and test the
    /// <code>JobStatus</code> response parameter.</p>
    /// <p>For additional information about the permissions policies that allow an identity
    /// (user, group, or role) to access specific services, use the <a>ListPoliciesGrantingServiceAccess</a> operation.</p>
    /// <note>
    /// <p>Service last accessed data does not use other policy types when determining
    /// whether a resource could access a service. These other policy types include
    /// resource-based policies, access control lists, Organizations policies, IAM
    /// permissions boundaries, and STS assume role policies. It only applies
    /// permissions policy logic. For more about the evaluation of policy types, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics">Evaluating policies</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// </note>
    /// <p>For more information about service and action last accessed data, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing permissions using service last accessed data</a> in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GenerateServiceLastAccessedDetails<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::generate_service_last_accessed_details_input::Builder,
    }
    impl<C, M, R> GenerateServiceLastAccessedDetails<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GenerateServiceLastAccessedDetails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GenerateServiceLastAccessedDetailsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GenerateServiceLastAccessedDetailsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GenerateServiceLastAccessedDetailsInputOperationOutputAlias,
                crate::output::GenerateServiceLastAccessedDetailsOutput,
                crate::error::GenerateServiceLastAccessedDetailsError,
                crate::input::GenerateServiceLastAccessedDetailsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the IAM resource (user, group, role, or managed policy) used to generate
        /// information about when the resource was last used in an attempt to access an Amazon Web Services
        /// service.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The ARN of the IAM resource (user, group, role, or managed policy) used to generate
        /// information about when the resource was last used in an attempt to access an Amazon Web Services
        /// service.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>The level of detail that you want to generate. You can specify whether you want to
        /// generate information about the last attempt to access services or actions. If you
        /// specify service-level granularity, this operation generates only service data. If you
        /// specify action-level granularity, it generates service and action data. If you don't
        /// include this optional parameter, the operation generates service data.</p>
        pub fn granularity(mut self, inp: crate::model::AccessAdvisorUsageGranularityType) -> Self {
            self.inner = self.inner.granularity(inp);
            self
        }
        /// <p>The level of detail that you want to generate. You can specify whether you want to
        /// generate information about the last attempt to access services or actions. If you
        /// specify service-level granularity, this operation generates only service data. If you
        /// specify action-level granularity, it generates service and action data. If you don't
        /// include this optional parameter, the operation generates service data.</p>
        pub fn set_granularity(
            mut self,
            input: std::option::Option<crate::model::AccessAdvisorUsageGranularityType>,
        ) -> Self {
            self.inner = self.inner.set_granularity(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccessKeyLastUsed`.
    ///
    /// <p>Retrieves information about when the specified access key was last used. The
    /// information includes the date and time of last use, along with the Amazon Web Services service and
    /// Region that were specified in the last request made with that key.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAccessKeyLastUsed<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_access_key_last_used_input::Builder,
    }
    impl<C, M, R> GetAccessKeyLastUsed<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAccessKeyLastUsed`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccessKeyLastUsedOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccessKeyLastUsedError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAccessKeyLastUsedInputOperationOutputAlias,
                crate::output::GetAccessKeyLastUsedOutput,
                crate::error::GetAccessKeyLastUsedError,
                crate::input::GetAccessKeyLastUsedInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of an access key.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can
        /// consist of any upper or lowercased letter or digit.</p>
        pub fn access_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_key_id(inp);
            self
        }
        /// <p>The identifier of an access key.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can
        /// consist of any upper or lowercased letter or digit.</p>
        pub fn set_access_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_key_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccountAuthorizationDetails`.
    ///
    /// <p>Retrieves information about all IAM users, groups, roles, and policies in your Amazon Web Services
    /// account, including their relationships to one another. Use this operation to obtain a
    /// snapshot of the configuration of IAM permissions (users, groups, roles, and policies)
    /// in your account.</p>
    /// <note>
    /// <p>Policies returned by this operation are URL-encoded compliant
    /// with <a href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL
    /// decoding method to convert the policy back to plain JSON text. For example, if you use Java, you
    /// can use the <code>decode</code> method of the <code>java.net.URLDecoder</code> utility class in
    /// the Java SDK. Other languages and SDKs provide similar functionality.</p>
    /// </note>
    /// <p>You can optionally filter the results using the <code>Filter</code> parameter. You can
    /// paginate the results using the <code>MaxItems</code> and <code>Marker</code>
    /// parameters.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAccountAuthorizationDetails<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_account_authorization_details_input::Builder,
    }
    impl<C, M, R> GetAccountAuthorizationDetails<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAccountAuthorizationDetails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccountAuthorizationDetailsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccountAuthorizationDetailsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAccountAuthorizationDetailsInputOperationOutputAlias,
                crate::output::GetAccountAuthorizationDetailsOutput,
                crate::error::GetAccountAuthorizationDetailsError,
                crate::input::GetAccountAuthorizationDetailsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filter`.
        ///
        /// To override the contents of this collection use [`set_filter`](Self::set_filter).
        ///
        /// <p>A list of entity types used to filter the results. Only the entities that match the
        /// types you specify are included in the output. Use the value
        /// <code>LocalManagedPolicy</code> to include customer managed policies.</p>
        /// <p>The format for this parameter is a comma-separated (if more than one) list of strings.
        /// Each string value in the list must be one of the valid values listed below.</p>
        pub fn filter(mut self, inp: impl Into<crate::model::EntityType>) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>A list of entity types used to filter the results. Only the entities that match the
        /// types you specify are included in the output. Use the value
        /// <code>LocalManagedPolicy</code> to include customer managed policies.</p>
        /// <p>The format for this parameter is a comma-separated (if more than one) list of strings.
        /// Each string value in the list must be one of the valid values listed below.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EntityType>>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccountPasswordPolicy`.
    ///
    /// <p>Retrieves the password policy for the Amazon Web Services account. This tells you the complexity
    /// requirements and mandatory rotation periods for the IAM user passwords in your account.
    /// For more information about using a password policy, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingPasswordPolicies.html">Managing an IAM password
    /// policy</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAccountPasswordPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_account_password_policy_input::Builder,
    }
    impl<C, M, R> GetAccountPasswordPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAccountPasswordPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccountPasswordPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccountPasswordPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAccountPasswordPolicyInputOperationOutputAlias,
                crate::output::GetAccountPasswordPolicyOutput,
                crate::error::GetAccountPasswordPolicyError,
                crate::input::GetAccountPasswordPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetAccountSummary`.
    ///
    /// <p>Retrieves information about IAM entity usage and IAM quotas in the Amazon Web Services
    /// account.</p>
    /// <p> For information about IAM quotas, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAccountSummary<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_account_summary_input::Builder,
    }
    impl<C, M, R> GetAccountSummary<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAccountSummary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccountSummaryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccountSummaryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAccountSummaryInputOperationOutputAlias,
                crate::output::GetAccountSummaryOutput,
                crate::error::GetAccountSummaryError,
                crate::input::GetAccountSummaryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetContextKeysForCustomPolicy`.
    ///
    /// <p>Gets a list of all of the context keys referenced in the input policies. The policies
    /// are supplied as a list of one or more strings. To get the context keys from policies
    /// associated with an IAM user, group, or role, use <a>GetContextKeysForPrincipalPolicy</a>.</p>
    /// <p>Context keys are variables maintained by Amazon Web Services and its services that provide details
    /// about the context of an API query request. Context keys can be evaluated by testing
    /// against a value specified in an IAM policy. Use
    /// <code>GetContextKeysForCustomPolicy</code> to understand what key names and values
    /// you must supply when you call <a>SimulateCustomPolicy</a>. Note that all
    /// parameters are shown in unencoded form here for clarity but must be URL encoded to be
    /// included as a part of a real HTML request.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetContextKeysForCustomPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_context_keys_for_custom_policy_input::Builder,
    }
    impl<C, M, R> GetContextKeysForCustomPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetContextKeysForCustomPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContextKeysForCustomPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContextKeysForCustomPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetContextKeysForCustomPolicyInputOperationOutputAlias,
                crate::output::GetContextKeysForCustomPolicyOutput,
                crate::error::GetContextKeysForCustomPolicyError,
                crate::input::GetContextKeysForCustomPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `PolicyInputList`.
        ///
        /// To override the contents of this collection use [`set_policy_input_list`](Self::set_policy_input_list).
        ///
        /// <p>A list of policies for which you want the list of context keys referenced in those
        /// policies. Each document is specified as a string containing the complete, valid JSON
        /// text of an IAM policy.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn policy_input_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_input_list(inp);
            self
        }
        /// <p>A list of policies for which you want the list of context keys referenced in those
        /// policies. Each document is specified as a string containing the complete, valid JSON
        /// text of an IAM policy.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn set_policy_input_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_policy_input_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetContextKeysForPrincipalPolicy`.
    ///
    /// <p>Gets a list of all of the context keys referenced in all the IAM policies that are
    /// attached to the specified IAM entity. The entity can be an IAM user, group, or role.
    /// If you specify a user, then the request also includes all of the policies attached to
    /// groups that the user is a member of.</p>
    /// <p>You can optionally include a list of one or more additional policies, specified as
    /// strings. If you want to include <i>only</i> a list of policies by string,
    /// use <a>GetContextKeysForCustomPolicy</a> instead.</p>
    /// <p>
    /// <b>Note:</b> This operation discloses information about the
    /// permissions granted to other users. If you do not want users to see other user's
    /// permissions, then consider allowing them to use <a>GetContextKeysForCustomPolicy</a> instead.</p>
    /// <p>Context keys are variables maintained by Amazon Web Services and its services that provide details
    /// about the context of an API query request. Context keys can be evaluated by testing
    /// against a value in an IAM policy. Use <a>GetContextKeysForPrincipalPolicy</a> to understand what key names and values you must supply when you call <a>SimulatePrincipalPolicy</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetContextKeysForPrincipalPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_context_keys_for_principal_policy_input::Builder,
    }
    impl<C, M, R> GetContextKeysForPrincipalPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetContextKeysForPrincipalPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContextKeysForPrincipalPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContextKeysForPrincipalPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetContextKeysForPrincipalPolicyInputOperationOutputAlias,
                crate::output::GetContextKeysForPrincipalPolicyOutput,
                crate::error::GetContextKeysForPrincipalPolicyError,
                crate::input::GetContextKeysForPrincipalPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of a user, group, or role whose policies contain the context keys that you
        /// want listed. If you specify a user, the list includes context keys that are found in all
        /// policies that are attached to the user. The list also includes all groups that the user
        /// is a member of. If you pick a group or a role, then it includes only those context keys
        /// that are found in policies attached to that entity. Note that all parameters are shown
        /// in unencoded form here for clarity, but must be URL encoded to be included as a part of
        /// a real HTML request.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn policy_source_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_source_arn(inp);
            self
        }
        /// <p>The ARN of a user, group, or role whose policies contain the context keys that you
        /// want listed. If you specify a user, the list includes context keys that are found in all
        /// policies that are attached to the user. The list also includes all groups that the user
        /// is a member of. If you pick a group or a role, then it includes only those context keys
        /// that are found in policies attached to that entity. Note that all parameters are shown
        /// in unencoded form here for clarity, but must be URL encoded to be included as a part of
        /// a real HTML request.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_policy_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_source_arn(input);
            self
        }
        /// Appends an item to `PolicyInputList`.
        ///
        /// To override the contents of this collection use [`set_policy_input_list`](Self::set_policy_input_list).
        ///
        /// <p>An optional list of additional policies for which you want the list of context keys
        /// that are referenced.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn policy_input_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_input_list(inp);
            self
        }
        /// <p>An optional list of additional policies for which you want the list of context keys
        /// that are referenced.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn set_policy_input_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_policy_input_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCredentialReport`.
    ///
    /// <p> Retrieves a credential report for the Amazon Web Services account. For more information about the
    /// credential report, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting credential reports</a> in
    /// the <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetCredentialReport<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_credential_report_input::Builder,
    }
    impl<C, M, R> GetCredentialReport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCredentialReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCredentialReportOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCredentialReportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCredentialReportInputOperationOutputAlias,
                crate::output::GetCredentialReportOutput,
                crate::error::GetCredentialReportError,
                crate::input::GetCredentialReportInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetGroup`.
    ///
    /// <p> Returns a list of IAM users that are in the specified IAM group. You can paginate
    /// the results using the <code>MaxItems</code> and <code>Marker</code> parameters.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_group_input::Builder,
    }
    impl<C, M, R> GetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetGroupInputOperationOutputAlias,
                crate::output::GetGroupOutput,
                crate::error::GetGroupError,
                crate::input::GetGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the group.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>The name of the group.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGroupPolicy`.
    ///
    /// <p>Retrieves the specified inline policy document that is embedded in the specified IAM
    /// group.</p>
    /// <note>
    /// <p>Policies returned by this operation are URL-encoded compliant
    /// with <a href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL
    /// decoding method to convert the policy back to plain JSON text. For example, if you use Java, you
    /// can use the <code>decode</code> method of the <code>java.net.URLDecoder</code> utility class in
    /// the Java SDK. Other languages and SDKs provide similar functionality.</p>
    /// </note>
    /// <p>An IAM group can also have managed policies attached to it. To retrieve a managed
    /// policy document that is attached to a group, use <a>GetPolicy</a> to
    /// determine the policy's default version, then use <a>GetPolicyVersion</a> to
    /// retrieve the policy document.</p>
    /// <p>For more information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
    /// policies</a> in the <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetGroupPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_group_policy_input::Builder,
    }
    impl<C, M, R> GetGroupPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetGroupPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGroupPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGroupPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetGroupPolicyInputOperationOutputAlias,
                crate::output::GetGroupPolicyOutput,
                crate::error::GetGroupPolicyError,
                crate::input::GetGroupPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the group the policy is associated with.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>The name of the group the policy is associated with.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The name of the policy document to get.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn policy_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(inp);
            self
        }
        /// <p>The name of the policy document to get.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInstanceProfile`.
    ///
    /// <p> Retrieves information about the specified instance profile, including the instance
    /// profile's path, GUID, ARN, and role. For more information about instance profiles, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About
    /// instance profiles</a> in the <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetInstanceProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_instance_profile_input::Builder,
    }
    impl<C, M, R> GetInstanceProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInstanceProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInstanceProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInstanceProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInstanceProfileInputOperationOutputAlias,
                crate::output::GetInstanceProfileOutput,
                crate::error::GetInstanceProfileError,
                crate::input::GetInstanceProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the instance profile to get information about.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn instance_profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_profile_name(inp);
            self
        }
        /// <p>The name of the instance profile to get information about.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_instance_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_profile_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLoginProfile`.
    ///
    /// <p>Retrieves the user name for the specified IAM user. A login profile is created when
    /// you create a password for the user to access the Amazon Web Services Management Console. If the user does not exist
    /// or does not have a password, the operation returns a 404 (<code>NoSuchEntity</code>)
    /// error.</p>
    /// <p>If you create an IAM user with access to the console, the <code>CreateDate</code>
    /// reflects the date you created the initial password for the user.</p>
    /// <p>If you create an IAM user with programmatic access, and then later add a password
    /// for the user to access the Amazon Web Services Management Console, the <code>CreateDate</code> reflects the initial
    /// password creation date. A user with programmatic access does not have a login profile
    /// unless you create a password for the user to access the Amazon Web Services Management Console.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetLoginProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_login_profile_input::Builder,
    }
    impl<C, M, R> GetLoginProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLoginProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLoginProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLoginProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLoginProfileInputOperationOutputAlias,
                crate::output::GetLoginProfileOutput,
                crate::error::GetLoginProfileError,
                crate::input::GetLoginProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user whose login profile you want to retrieve.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the user whose login profile you want to retrieve.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOpenIDConnectProvider`.
    ///
    /// <p>Returns information about the specified OpenID Connect (OIDC) provider resource object
    /// in IAM.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetOpenIDConnectProvider<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_open_id_connect_provider_input::Builder,
    }
    impl<C, M, R> GetOpenIDConnectProvider<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetOpenIDConnectProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOpenIdConnectProviderOutput,
            aws_smithy_http::result::SdkError<crate::error::GetOpenIDConnectProviderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetOpenIdConnectProviderInputOperationOutputAlias,
                crate::output::GetOpenIdConnectProviderOutput,
                crate::error::GetOpenIDConnectProviderError,
                crate::input::GetOpenIdConnectProviderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the OIDC provider resource object in IAM to get
        /// information for. You can get a list of OIDC provider resource ARNs by using the <a>ListOpenIDConnectProviders</a> operation.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn open_id_connect_provider_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.open_id_connect_provider_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the OIDC provider resource object in IAM to get
        /// information for. You can get a list of OIDC provider resource ARNs by using the <a>ListOpenIDConnectProviders</a> operation.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_open_id_connect_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_open_id_connect_provider_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOrganizationsAccessReport`.
    ///
    /// <p>Retrieves the service last accessed data report for Organizations that was previously
    /// generated using the <code>
    /// <a>GenerateOrganizationsAccessReport</a>
    /// </code>
    /// operation. This operation retrieves the status of your report job and the report
    /// contents.</p>
    /// <p>Depending on the parameters that you passed when you generated the report, the data
    /// returned could include different information. For details, see <a>GenerateOrganizationsAccessReport</a>.</p>
    /// <p>To call this operation, you must be signed in to the management account in your
    /// organization. SCPs must be enabled for your organization root. You must have permissions
    /// to perform this operation. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Refining permissions using
    /// service last accessed data</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// <p>For each service that principals in an account (root users, IAM users, or IAM
    /// roles) could access using SCPs, the operation returns details about the most recent
    /// access attempt. If there was no attempt, the service is listed without details about the
    /// most recent attempt to access the service. If the operation fails, it returns the reason
    /// that it failed.</p>
    /// <p>By default, the list is sorted by service namespace.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetOrganizationsAccessReport<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_organizations_access_report_input::Builder,
    }
    impl<C, M, R> GetOrganizationsAccessReport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetOrganizationsAccessReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOrganizationsAccessReportOutput,
            aws_smithy_http::result::SdkError<crate::error::GetOrganizationsAccessReportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetOrganizationsAccessReportInputOperationOutputAlias,
                crate::output::GetOrganizationsAccessReportOutput,
                crate::error::GetOrganizationsAccessReportError,
                crate::input::GetOrganizationsAccessReportInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the request generated by the <a>GenerateOrganizationsAccessReport</a> operation.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The identifier of the request generated by the <a>GenerateOrganizationsAccessReport</a> operation.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The key that is used to sort the results. If you choose the namespace key, the results
        /// are returned in alphabetical order. If you choose the time key, the results are sorted
        /// numerically by the date and time.</p>
        pub fn sort_key(mut self, inp: crate::model::SortKeyType) -> Self {
            self.inner = self.inner.sort_key(inp);
            self
        }
        /// <p>The key that is used to sort the results. If you choose the namespace key, the results
        /// are returned in alphabetical order. If you choose the time key, the results are sorted
        /// numerically by the date and time.</p>
        pub fn set_sort_key(
            mut self,
            input: std::option::Option<crate::model::SortKeyType>,
        ) -> Self {
            self.inner = self.inner.set_sort_key(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPolicy`.
    ///
    /// <p>Retrieves information about the specified managed policy, including the policy's
    /// default version and the total number of IAM users, groups, and roles to which the
    /// policy is attached. To retrieve the list of the specific users, groups, and roles that
    /// the policy is attached to, use <a>ListEntitiesForPolicy</a>. This operation
    /// returns metadata about the policy. To retrieve the actual policy document for a specific
    /// version of the policy, use <a>GetPolicyVersion</a>.</p>
    /// <p>This operation retrieves information about managed policies. To retrieve information
    /// about an inline policy that is embedded with an IAM user, group, or role, use <a>GetUserPolicy</a>, <a>GetGroupPolicy</a>, or <a>GetRolePolicy</a>.</p>
    /// <p>For more information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
    /// policies</a> in the <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_policy_input::Builder,
    }
    impl<C, M, R> GetPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPolicyInputOperationOutputAlias,
                crate::output::GetPolicyOutput,
                crate::error::GetPolicyError,
                crate::input::GetPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the managed policy that you want information
        /// about.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn policy_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the managed policy that you want information
        /// about.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPolicyVersion`.
    ///
    /// <p>Retrieves information about the specified version of the specified managed policy,
    /// including the policy document.</p>
    /// <note>
    /// <p>Policies returned by this operation are URL-encoded compliant
    /// with <a href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL
    /// decoding method to convert the policy back to plain JSON text. For example, if you use Java, you
    /// can use the <code>decode</code> method of the <code>java.net.URLDecoder</code> utility class in
    /// the Java SDK. Other languages and SDKs provide similar functionality.</p>
    /// </note>
    /// <p>To list the available versions for a policy, use <a>ListPolicyVersions</a>.</p>
    /// <p>This operation retrieves information about managed policies. To retrieve information
    /// about an inline policy that is embedded in a user, group, or role, use <a>GetUserPolicy</a>, <a>GetGroupPolicy</a>, or <a>GetRolePolicy</a>.</p>
    /// <p>For more information about the types of policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
    /// policies</a> in the <i>IAM User Guide</i>.</p>
    /// <p>For more information about managed policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
    /// policies</a> in the <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetPolicyVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_policy_version_input::Builder,
    }
    impl<C, M, R> GetPolicyVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPolicyVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPolicyVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPolicyVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPolicyVersionInputOperationOutputAlias,
                crate::output::GetPolicyVersionOutput,
                crate::error::GetPolicyVersionError,
                crate::input::GetPolicyVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the managed policy that you want information
        /// about.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn policy_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the managed policy that you want information
        /// about.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_arn(input);
            self
        }
        /// <p>Identifies the policy version to retrieve.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that
        /// consists of the lowercase letter 'v' followed by one or two digits, and optionally
        /// followed by a period '.' and a string of letters and digits.</p>
        pub fn version_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(inp);
            self
        }
        /// <p>Identifies the policy version to retrieve.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that
        /// consists of the lowercase letter 'v' followed by one or two digits, and optionally
        /// followed by a period '.' and a string of letters and digits.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRole`.
    ///
    /// <p>Retrieves information about the specified role, including the role's path, GUID, ARN,
    /// and the role's trust policy that grants permission to assume the role. For more
    /// information about roles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with roles</a>.</p>
    /// <note>
    /// <p>Policies returned by this operation are URL-encoded compliant
    /// with <a href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL
    /// decoding method to convert the policy back to plain JSON text. For example, if you use Java, you
    /// can use the <code>decode</code> method of the <code>java.net.URLDecoder</code> utility class in
    /// the Java SDK. Other languages and SDKs provide similar functionality.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetRole<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_role_input::Builder,
    }
    impl<C, M, R> GetRole<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRole`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRoleOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRoleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRoleInputOperationOutputAlias,
                crate::output::GetRoleOutput,
                crate::error::GetRoleError,
                crate::input::GetRoleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IAM role to get information about.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_name(inp);
            self
        }
        /// <p>The name of the IAM role to get information about.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRolePolicy`.
    ///
    /// <p>Retrieves the specified inline policy document that is embedded with the specified
    /// IAM role.</p>
    /// <note>
    /// <p>Policies returned by this operation are URL-encoded compliant
    /// with <a href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL
    /// decoding method to convert the policy back to plain JSON text. For example, if you use Java, you
    /// can use the <code>decode</code> method of the <code>java.net.URLDecoder</code> utility class in
    /// the Java SDK. Other languages and SDKs provide similar functionality.</p>
    /// </note>
    /// <p>An IAM role can also have managed policies attached to it. To retrieve a managed
    /// policy document that is attached to a role, use <a>GetPolicy</a> to determine
    /// the policy's default version, then use <a>GetPolicyVersion</a> to retrieve
    /// the policy document.</p>
    /// <p>For more information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
    /// policies</a> in the <i>IAM User Guide</i>.</p>
    /// <p>For more information about roles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html">Using roles to delegate permissions and
    /// federate identities</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRolePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_role_policy_input::Builder,
    }
    impl<C, M, R> GetRolePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRolePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRolePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRolePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRolePolicyInputOperationOutputAlias,
                crate::output::GetRolePolicyOutput,
                crate::error::GetRolePolicyError,
                crate::input::GetRolePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the role associated with the policy.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_name(inp);
            self
        }
        /// <p>The name of the role associated with the policy.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_name(input);
            self
        }
        /// <p>The name of the policy document to get.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn policy_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(inp);
            self
        }
        /// <p>The name of the policy document to get.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSAMLProvider`.
    ///
    /// <p>Returns the SAML provider metadocument that was uploaded when the IAM SAML provider
    /// resource object was created or updated.</p>
    /// <note>
    /// <p>This operation requires <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetSAMLProvider<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_saml_provider_input::Builder,
    }
    impl<C, M, R> GetSAMLProvider<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSAMLProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSamlProviderOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSAMLProviderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSamlProviderInputOperationOutputAlias,
                crate::output::GetSamlProviderOutput,
                crate::error::GetSAMLProviderError,
                crate::input::GetSamlProviderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the SAML provider resource object in IAM to get
        /// information about.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn saml_provider_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.saml_provider_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SAML provider resource object in IAM to get
        /// information about.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_saml_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_saml_provider_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetServerCertificate`.
    ///
    /// <p>Retrieves information about the specified server certificate stored in IAM.</p>
    /// <p>For more information about working with server certificates, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working
    /// with server certificates</a> in the <i>IAM User Guide</i>. This
    /// topic includes a list of Amazon Web Services services that can use the server certificates that you
    /// manage with IAM.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetServerCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_server_certificate_input::Builder,
    }
    impl<C, M, R> GetServerCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetServerCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServerCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetServerCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetServerCertificateInputOperationOutputAlias,
                crate::output::GetServerCertificateOutput,
                crate::error::GetServerCertificateError,
                crate::input::GetServerCertificateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the server certificate you want to retrieve information about.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn server_certificate_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_certificate_name(inp);
            self
        }
        /// <p>The name of the server certificate you want to retrieve information about.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_server_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_server_certificate_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetServiceLastAccessedDetails`.
    ///
    /// <p>Retrieves a service last accessed report that was created using the
    /// <code>GenerateServiceLastAccessedDetails</code> operation. You can use the
    /// <code>JobId</code> parameter in <code>GetServiceLastAccessedDetails</code> to
    /// retrieve the status of your report job. When the report is complete, you can retrieve
    /// the generated report. The report includes a list of Amazon Web Services services that the resource
    /// (user, group, role, or managed policy) can access.</p>
    /// <note>
    /// <p>Service last accessed data does not use other policy types when determining
    /// whether a resource could access a service. These other policy types include
    /// resource-based policies, access control lists, Organizations policies, IAM
    /// permissions boundaries, and STS assume role policies. It only applies
    /// permissions policy logic. For more about the evaluation of policy types, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics">Evaluating policies</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// </note>
    /// <p>For each service that the resource could access using permissions policies, the
    /// operation returns details about the most recent access attempt. If there was no attempt,
    /// the service is listed without details about the most recent attempt to access the
    /// service. If the operation fails, the <code>GetServiceLastAccessedDetails</code>
    /// operation returns the reason that it failed.</p>
    /// <p>The <code>GetServiceLastAccessedDetails</code> operation returns a list of services.
    /// This list includes the number of entities that have attempted to access the service and
    /// the date and time of the last attempt. It also returns the ARN of the following entity,
    /// depending on the resource ARN that you used to generate the report:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>User</b> – Returns the user ARN that you
    /// used to generate the report</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Group</b> – Returns the ARN of the group
    /// member (user) that last attempted to access the service</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Role</b> – Returns the role ARN that you
    /// used to generate the report</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Policy</b> – Returns the ARN of the user
    /// or role that last used the policy to attempt to access the service</p>
    /// </li>
    /// </ul>
    /// <p>By default, the list is sorted by service namespace.</p>
    /// <p>If you specified <code>ACTION_LEVEL</code> granularity when you generated the report,
    /// this operation returns service and action last accessed data. This includes the most
    /// recent access attempt for each tracked action within a service. Otherwise, this
    /// operation returns only service data.</p>
    /// <p>For more information about service and action last accessed data, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing permissions using service last accessed data</a> in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetServiceLastAccessedDetails<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_service_last_accessed_details_input::Builder,
    }
    impl<C, M, R> GetServiceLastAccessedDetails<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetServiceLastAccessedDetails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServiceLastAccessedDetailsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetServiceLastAccessedDetailsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetServiceLastAccessedDetailsInputOperationOutputAlias,
                crate::output::GetServiceLastAccessedDetailsOutput,
                crate::error::GetServiceLastAccessedDetailsError,
                crate::input::GetServiceLastAccessedDetailsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the request generated by the <a>GenerateServiceLastAccessedDetails</a> operation. The <code>JobId</code>
        /// returned by <code>GenerateServiceLastAccessedDetail</code> must be used by the same role
        /// within a session, or by the same user when used to call
        /// <code>GetServiceLastAccessedDetail</code>.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The ID of the request generated by the <a>GenerateServiceLastAccessedDetails</a> operation. The <code>JobId</code>
        /// returned by <code>GenerateServiceLastAccessedDetail</code> must be used by the same role
        /// within a session, or by the same user when used to call
        /// <code>GetServiceLastAccessedDetail</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetServiceLastAccessedDetailsWithEntities`.
    ///
    /// <p>After you generate a group or policy report using the
    /// <code>GenerateServiceLastAccessedDetails</code> operation, you can use the
    /// <code>JobId</code> parameter in
    /// <code>GetServiceLastAccessedDetailsWithEntities</code>. This operation retrieves the
    /// status of your report job and a list of entities that could have used group or policy
    /// permissions to access the specified service.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Group</b> – For a group report, this
    /// operation returns a list of users in the group that could have used the group’s
    /// policies in an attempt to access the service.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Policy</b> – For a policy report, this
    /// operation returns a list of entities (users or roles) that could have used the
    /// policy in an attempt to access the service.</p>
    /// </li>
    /// </ul>
    /// <p>You can also use this operation for user or role reports to retrieve details about
    /// those entities.</p>
    /// <p>If the operation fails, the <code>GetServiceLastAccessedDetailsWithEntities</code>
    /// operation returns the reason that it failed.</p>
    /// <p>By default, the list of associated entities is sorted by date, with the most recent
    /// access listed first.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetServiceLastAccessedDetailsWithEntities<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_service_last_accessed_details_with_entities_input::Builder,
    }
    impl<C, M, R> GetServiceLastAccessedDetailsWithEntities<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetServiceLastAccessedDetailsWithEntities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServiceLastAccessedDetailsWithEntitiesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetServiceLastAccessedDetailsWithEntitiesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetServiceLastAccessedDetailsWithEntitiesInputOperationOutputAlias,
                crate::output::GetServiceLastAccessedDetailsWithEntitiesOutput,
                crate::error::GetServiceLastAccessedDetailsWithEntitiesError,
                crate::input::GetServiceLastAccessedDetailsWithEntitiesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the request generated by the <code>GenerateServiceLastAccessedDetails</code>
        /// operation.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The ID of the request generated by the <code>GenerateServiceLastAccessedDetails</code>
        /// operation.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The service namespace for an Amazon Web Services service. Provide the service namespace to learn
        /// when the IAM entity last attempted to access the specified service.</p>
        /// <p>To learn the service namespace for a service, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html">Actions, resources, and condition keys for Amazon Web Services services</a> in the
        /// <i>IAM User Guide</i>. Choose the name of the service to view
        /// details for that service. In the first paragraph, find the service prefix. For example,
        /// <code>(service prefix: a4b)</code>. For more information about service namespaces,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces">Amazon Web Services
        /// service namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn service_namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_namespace(inp);
            self
        }
        /// <p>The service namespace for an Amazon Web Services service. Provide the service namespace to learn
        /// when the IAM entity last attempted to access the specified service.</p>
        /// <p>To learn the service namespace for a service, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html">Actions, resources, and condition keys for Amazon Web Services services</a> in the
        /// <i>IAM User Guide</i>. Choose the name of the service to view
        /// details for that service. In the first paragraph, find the service prefix. For example,
        /// <code>(service prefix: a4b)</code>. For more information about service namespaces,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces">Amazon Web Services
        /// service namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_service_namespace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_namespace(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetServiceLinkedRoleDeletionStatus`.
    ///
    /// <p>Retrieves the status of your service-linked role deletion. After you use <a>DeleteServiceLinkedRole</a> to submit a service-linked role for deletion,
    /// you can use the <code>DeletionTaskId</code> parameter in
    /// <code>GetServiceLinkedRoleDeletionStatus</code> to check the status of the deletion.
    /// If the deletion fails, this operation returns the reason that it failed, if that
    /// information is returned by the service.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetServiceLinkedRoleDeletionStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_service_linked_role_deletion_status_input::Builder,
    }
    impl<C, M, R> GetServiceLinkedRoleDeletionStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetServiceLinkedRoleDeletionStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServiceLinkedRoleDeletionStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetServiceLinkedRoleDeletionStatusError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetServiceLinkedRoleDeletionStatusInputOperationOutputAlias,
                crate::output::GetServiceLinkedRoleDeletionStatusOutput,
                crate::error::GetServiceLinkedRoleDeletionStatusError,
                crate::input::GetServiceLinkedRoleDeletionStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The deletion task identifier. This identifier is returned by the <a>DeleteServiceLinkedRole</a> operation in the format
        /// <code>task/aws-service-role/<service-principal-name>/<role-name>/<task-uuid></code>.</p>
        pub fn deletion_task_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.deletion_task_id(inp);
            self
        }
        /// <p>The deletion task identifier. This identifier is returned by the <a>DeleteServiceLinkedRole</a> operation in the format
        /// <code>task/aws-service-role/<service-principal-name>/<role-name>/<task-uuid></code>.</p>
        pub fn set_deletion_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_deletion_task_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSSHPublicKey`.
    ///
    /// <p>Retrieves the specified SSH public key, including metadata about the key.</p>
    /// <p>The SSH public key retrieved by this operation is used only for authenticating the
    /// associated IAM user to an CodeCommit repository. For more information about using SSH keys
    /// to authenticate to an CodeCommit repository, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up CodeCommit for SSH
    /// connections</a> in the <i>CodeCommit User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSSHPublicKey<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_ssh_public_key_input::Builder,
    }
    impl<C, M, R> GetSSHPublicKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSSHPublicKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSshPublicKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSSHPublicKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSshPublicKeyInputOperationOutputAlias,
                crate::output::GetSshPublicKeyOutput,
                crate::error::GetSSHPublicKeyError,
                crate::input::GetSshPublicKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IAM user associated with the SSH public key.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the IAM user associated with the SSH public key.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The unique identifier for the SSH public key.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can
        /// consist of any upper or lowercased letter or digit.</p>
        pub fn ssh_public_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ssh_public_key_id(inp);
            self
        }
        /// <p>The unique identifier for the SSH public key.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can
        /// consist of any upper or lowercased letter or digit.</p>
        pub fn set_ssh_public_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ssh_public_key_id(input);
            self
        }
        /// <p>Specifies the public key encoding format to use in the response. To retrieve the
        /// public key in ssh-rsa format, use <code>SSH</code>. To retrieve the public key in PEM
        /// format, use <code>PEM</code>.</p>
        pub fn encoding(mut self, inp: crate::model::EncodingType) -> Self {
            self.inner = self.inner.encoding(inp);
            self
        }
        /// <p>Specifies the public key encoding format to use in the response. To retrieve the
        /// public key in ssh-rsa format, use <code>SSH</code>. To retrieve the public key in PEM
        /// format, use <code>PEM</code>.</p>
        pub fn set_encoding(
            mut self,
            input: std::option::Option<crate::model::EncodingType>,
        ) -> Self {
            self.inner = self.inner.set_encoding(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUser`.
    ///
    /// <p>Retrieves information about the specified IAM user, including the user's creation
    /// date, path, unique ID, and ARN.</p>
    /// <p>If you do not specify a user name, IAM determines the user name implicitly based on
    /// the Amazon Web Services access key ID used to sign the request to this operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_user_input::Builder,
    }
    impl<C, M, R> GetUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUserOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUserInputOperationOutputAlias,
                crate::output::GetUserOutput,
                crate::error::GetUserError,
                crate::input::GetUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user to get information about.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to the user making the
        /// request. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the user to get information about.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to the user making the
        /// request. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUserPolicy`.
    ///
    /// <p>Retrieves the specified inline policy document that is embedded in the specified IAM
    /// user.</p>
    /// <note>
    /// <p>Policies returned by this operation are URL-encoded compliant
    /// with <a href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL
    /// decoding method to convert the policy back to plain JSON text. For example, if you use Java, you
    /// can use the <code>decode</code> method of the <code>java.net.URLDecoder</code> utility class in
    /// the Java SDK. Other languages and SDKs provide similar functionality.</p>
    /// </note>
    /// <p>An IAM user can also have managed policies attached to it. To retrieve a managed
    /// policy document that is attached to a user, use <a>GetPolicy</a> to determine
    /// the policy's default version. Then use <a>GetPolicyVersion</a> to retrieve
    /// the policy document.</p>
    /// <p>For more information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
    /// policies</a> in the <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetUserPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_user_policy_input::Builder,
    }
    impl<C, M, R> GetUserPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUserPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUserPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUserPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUserPolicyInputOperationOutputAlias,
                crate::output::GetUserPolicyOutput,
                crate::error::GetUserPolicyError,
                crate::input::GetUserPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user who the policy is associated with.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the user who the policy is associated with.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The name of the policy document to get.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn policy_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(inp);
            self
        }
        /// <p>The name of the policy document to get.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccessKeys`.
    ///
    /// <p>Returns information about the access key IDs associated with the specified IAM user.
    /// If there is none, the operation returns an empty list.</p>
    /// <p>Although each user is limited to a small number of keys, you can still paginate the
    /// results using the <code>MaxItems</code> and <code>Marker</code> parameters.</p>
    /// <p>If the <code>UserName</code> field is not specified, the user name is determined
    /// implicitly based on the Amazon Web Services access key ID used to sign the request. This operation
    /// works for access keys under the Amazon Web Services account. Consequently, you can use this operation
    /// to manage Amazon Web Services account root user credentials even if the Amazon Web Services account has no
    /// associated users.</p>
    /// <note>
    /// <p>To ensure the security of your Amazon Web Services account, the secret access key is accessible
    /// only during key and user creation.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListAccessKeys<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_access_keys_input::Builder,
    }
    impl<C, M, R> ListAccessKeys<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAccessKeys`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccessKeysOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAccessKeysError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAccessKeysInputOperationOutputAlias,
                crate::output::ListAccessKeysOutput,
                crate::error::ListAccessKeysError,
                crate::input::ListAccessKeysInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the user.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccountAliases`.
    ///
    /// <p>Lists the account alias associated with the Amazon Web Services account (Note: you can have only
    /// one). For information about using an Amazon Web Services account alias, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html">Using an alias for your
    /// Amazon Web Services account ID</a> in the <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAccountAliases<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_account_aliases_input::Builder,
    }
    impl<C, M, R> ListAccountAliases<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAccountAliases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccountAliasesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAccountAliasesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAccountAliasesInputOperationOutputAlias,
                crate::output::ListAccountAliasesOutput,
                crate::error::ListAccountAliasesError,
                crate::input::ListAccountAliasesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAttachedGroupPolicies`.
    ///
    /// <p>Lists all managed policies that are attached to the specified IAM group.</p>
    /// <p>An IAM group can also have inline policies embedded with it. To list the inline
    /// policies for a group, use <a>ListGroupPolicies</a>. For information about
    /// policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
    /// policies</a> in the <i>IAM User Guide</i>.</p>
    /// <p>You can paginate the results using the <code>MaxItems</code> and <code>Marker</code>
    /// parameters. You can use the <code>PathPrefix</code> parameter to limit the list of
    /// policies to only those matching the specified path prefix. If there are no policies
    /// attached to the specified group (or none that match the specified path prefix), the
    /// operation returns an empty list.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAttachedGroupPolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_attached_group_policies_input::Builder,
    }
    impl<C, M, R> ListAttachedGroupPolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAttachedGroupPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAttachedGroupPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAttachedGroupPoliciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAttachedGroupPoliciesInputOperationOutputAlias,
                crate::output::ListAttachedGroupPoliciesOutput,
                crate::error::ListAttachedGroupPoliciesError,
                crate::input::ListAttachedGroupPoliciesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name (friendly name, not ARN) of the group to list attached policies for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>The name (friendly name, not ARN) of the group to list attached policies for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The path prefix for filtering the results. This parameter is optional. If it is not
        /// included, it defaults to a slash (/), listing all policies.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn path_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path_prefix(inp);
            self
        }
        /// <p>The path prefix for filtering the results. This parameter is optional. If it is not
        /// included, it defaults to a slash (/), listing all policies.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn set_path_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path_prefix(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAttachedRolePolicies`.
    ///
    /// <p>Lists all managed policies that are attached to the specified IAM role.</p>
    /// <p>An IAM role can also have inline policies embedded with it. To list the inline
    /// policies for a role, use <a>ListRolePolicies</a>. For information about
    /// policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
    /// policies</a> in the <i>IAM User Guide</i>.</p>
    /// <p>You can paginate the results using the <code>MaxItems</code> and <code>Marker</code>
    /// parameters. You can use the <code>PathPrefix</code> parameter to limit the list of
    /// policies to only those matching the specified path prefix. If there are no policies
    /// attached to the specified role (or none that match the specified path prefix), the
    /// operation returns an empty list.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAttachedRolePolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_attached_role_policies_input::Builder,
    }
    impl<C, M, R> ListAttachedRolePolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAttachedRolePolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAttachedRolePoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAttachedRolePoliciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAttachedRolePoliciesInputOperationOutputAlias,
                crate::output::ListAttachedRolePoliciesOutput,
                crate::error::ListAttachedRolePoliciesError,
                crate::input::ListAttachedRolePoliciesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name (friendly name, not ARN) of the role to list attached policies for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_name(inp);
            self
        }
        /// <p>The name (friendly name, not ARN) of the role to list attached policies for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_name(input);
            self
        }
        /// <p>The path prefix for filtering the results. This parameter is optional. If it is not
        /// included, it defaults to a slash (/), listing all policies.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn path_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path_prefix(inp);
            self
        }
        /// <p>The path prefix for filtering the results. This parameter is optional. If it is not
        /// included, it defaults to a slash (/), listing all policies.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn set_path_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path_prefix(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAttachedUserPolicies`.
    ///
    /// <p>Lists all managed policies that are attached to the specified IAM user.</p>
    /// <p>An IAM user can also have inline policies embedded with it. To list the inline
    /// policies for a user, use <a>ListUserPolicies</a>. For information about
    /// policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
    /// policies</a> in the <i>IAM User Guide</i>.</p>
    /// <p>You can paginate the results using the <code>MaxItems</code> and <code>Marker</code>
    /// parameters. You can use the <code>PathPrefix</code> parameter to limit the list of
    /// policies to only those matching the specified path prefix. If there are no policies
    /// attached to the specified group (or none that match the specified path prefix), the
    /// operation returns an empty list.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAttachedUserPolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_attached_user_policies_input::Builder,
    }
    impl<C, M, R> ListAttachedUserPolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAttachedUserPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAttachedUserPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAttachedUserPoliciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAttachedUserPoliciesInputOperationOutputAlias,
                crate::output::ListAttachedUserPoliciesOutput,
                crate::error::ListAttachedUserPoliciesError,
                crate::input::ListAttachedUserPoliciesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name (friendly name, not ARN) of the user to list attached policies for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name (friendly name, not ARN) of the user to list attached policies for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The path prefix for filtering the results. This parameter is optional. If it is not
        /// included, it defaults to a slash (/), listing all policies.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn path_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path_prefix(inp);
            self
        }
        /// <p>The path prefix for filtering the results. This parameter is optional. If it is not
        /// included, it defaults to a slash (/), listing all policies.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn set_path_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path_prefix(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEntitiesForPolicy`.
    ///
    /// <p>Lists all IAM users, groups, and roles that the specified managed policy is attached
    /// to.</p>
    /// <p>You can use the optional <code>EntityFilter</code> parameter to limit the results to a
    /// particular type of entity (users, groups, or roles). For example, to list only the roles
    /// that are attached to the specified policy, set <code>EntityFilter</code> to
    /// <code>Role</code>.</p>
    /// <p>You can paginate the results using the <code>MaxItems</code> and <code>Marker</code>
    /// parameters.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListEntitiesForPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_entities_for_policy_input::Builder,
    }
    impl<C, M, R> ListEntitiesForPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEntitiesForPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEntitiesForPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEntitiesForPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEntitiesForPolicyInputOperationOutputAlias,
                crate::output::ListEntitiesForPolicyOutput,
                crate::error::ListEntitiesForPolicyError,
                crate::input::ListEntitiesForPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy for which you want the
        /// versions.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn policy_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy for which you want the
        /// versions.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_arn(input);
            self
        }
        /// <p>The entity type to use for filtering the results.</p>
        /// <p>For example, when <code>EntityFilter</code> is <code>Role</code>, only the roles that
        /// are attached to the specified policy are returned. This parameter is optional. If it is
        /// not included, all attached entities (users, groups, and roles) are returned. The
        /// argument for this parameter must be one of the valid values listed below.</p>
        pub fn entity_filter(mut self, inp: crate::model::EntityType) -> Self {
            self.inner = self.inner.entity_filter(inp);
            self
        }
        /// <p>The entity type to use for filtering the results.</p>
        /// <p>For example, when <code>EntityFilter</code> is <code>Role</code>, only the roles that
        /// are attached to the specified policy are returned. This parameter is optional. If it is
        /// not included, all attached entities (users, groups, and roles) are returned. The
        /// argument for this parameter must be one of the valid values listed below.</p>
        pub fn set_entity_filter(
            mut self,
            input: std::option::Option<crate::model::EntityType>,
        ) -> Self {
            self.inner = self.inner.set_entity_filter(input);
            self
        }
        /// <p>The path prefix for filtering the results. This parameter is optional. If it is not
        /// included, it defaults to a slash (/), listing all entities.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn path_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path_prefix(inp);
            self
        }
        /// <p>The path prefix for filtering the results. This parameter is optional. If it is not
        /// included, it defaults to a slash (/), listing all entities.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn set_path_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path_prefix(input);
            self
        }
        /// <p>The policy usage method to use for filtering the results.</p>
        /// <p>To list only permissions policies,
        /// set <code>PolicyUsageFilter</code> to <code>PermissionsPolicy</code>. To list only
        /// the policies used to set permissions boundaries, set the value
        /// to <code>PermissionsBoundary</code>.</p>
        /// <p>This parameter is optional. If it is not included, all policies are returned. </p>
        pub fn policy_usage_filter(mut self, inp: crate::model::PolicyUsageType) -> Self {
            self.inner = self.inner.policy_usage_filter(inp);
            self
        }
        /// <p>The policy usage method to use for filtering the results.</p>
        /// <p>To list only permissions policies,
        /// set <code>PolicyUsageFilter</code> to <code>PermissionsPolicy</code>. To list only
        /// the policies used to set permissions boundaries, set the value
        /// to <code>PermissionsBoundary</code>.</p>
        /// <p>This parameter is optional. If it is not included, all policies are returned. </p>
        pub fn set_policy_usage_filter(
            mut self,
            input: std::option::Option<crate::model::PolicyUsageType>,
        ) -> Self {
            self.inner = self.inner.set_policy_usage_filter(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGroupPolicies`.
    ///
    /// <p>Lists the names of the inline policies that are embedded in the specified IAM
    /// group.</p>
    /// <p>An IAM group can also have managed policies attached to it. To list the managed
    /// policies that are attached to a group, use <a>ListAttachedGroupPolicies</a>.
    /// For more information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
    /// policies</a> in the <i>IAM User Guide</i>.</p>
    /// <p>You can paginate the results using the <code>MaxItems</code> and <code>Marker</code>
    /// parameters. If there are no inline policies embedded with the specified group, the
    /// operation returns an empty list.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListGroupPolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_group_policies_input::Builder,
    }
    impl<C, M, R> ListGroupPolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListGroupPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGroupPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGroupPoliciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListGroupPoliciesInputOperationOutputAlias,
                crate::output::ListGroupPoliciesOutput,
                crate::error::ListGroupPoliciesError,
                crate::input::ListGroupPoliciesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the group to list policies for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>The name of the group to list policies for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGroups`.
    ///
    /// <p>Lists the IAM groups that have the specified path prefix.</p>
    /// <p> You can paginate the results using the <code>MaxItems</code> and <code>Marker</code>
    /// parameters.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_groups_input::Builder,
    }
    impl<C, M, R> ListGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListGroupsInputOperationOutputAlias,
                crate::output::ListGroupsOutput,
                crate::error::ListGroupsError,
                crate::input::ListGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The path prefix for filtering the results. For example, the prefix
        /// <code>/division_abc/subdivision_xyz/</code> gets all groups whose path starts with
        /// <code>/division_abc/subdivision_xyz/</code>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/), listing
        /// all groups. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn path_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path_prefix(inp);
            self
        }
        /// <p> The path prefix for filtering the results. For example, the prefix
        /// <code>/division_abc/subdivision_xyz/</code> gets all groups whose path starts with
        /// <code>/division_abc/subdivision_xyz/</code>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/), listing
        /// all groups. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn set_path_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path_prefix(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGroupsForUser`.
    ///
    /// <p>Lists the IAM groups that the specified IAM user belongs to.</p>
    /// <p>You can paginate the results using the <code>MaxItems</code> and <code>Marker</code>
    /// parameters.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListGroupsForUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_groups_for_user_input::Builder,
    }
    impl<C, M, R> ListGroupsForUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListGroupsForUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGroupsForUserOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGroupsForUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListGroupsForUserInputOperationOutputAlias,
                crate::output::ListGroupsForUserOutput,
                crate::error::ListGroupsForUserError,
                crate::input::ListGroupsForUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user to list groups for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the user to list groups for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInstanceProfiles`.
    ///
    /// <p>Lists the instance profiles that have the specified path prefix. If there are none,
    /// the operation returns an empty list. For more information about instance profiles, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About
    /// instance profiles</a>.</p>
    /// <note>
    /// <p>IAM resource-listing operations return a subset of the available
    /// attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for an instance profile, see <a>GetInstanceProfile</a>.</p>
    /// </note>
    /// <p>You can paginate the results using the <code>MaxItems</code> and <code>Marker</code>
    /// parameters.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListInstanceProfiles<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_instance_profiles_input::Builder,
    }
    impl<C, M, R> ListInstanceProfiles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListInstanceProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInstanceProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInstanceProfilesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListInstanceProfilesInputOperationOutputAlias,
                crate::output::ListInstanceProfilesOutput,
                crate::error::ListInstanceProfilesError,
                crate::input::ListInstanceProfilesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The path prefix for filtering the results. For example, the prefix
        /// <code>/application_abc/component_xyz/</code> gets all instance profiles whose path
        /// starts with <code>/application_abc/component_xyz/</code>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/), listing
        /// all instance profiles. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn path_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path_prefix(inp);
            self
        }
        /// <p> The path prefix for filtering the results. For example, the prefix
        /// <code>/application_abc/component_xyz/</code> gets all instance profiles whose path
        /// starts with <code>/application_abc/component_xyz/</code>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/), listing
        /// all instance profiles. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn set_path_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path_prefix(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInstanceProfilesForRole`.
    ///
    /// <p>Lists the instance profiles that have the specified associated IAM role. If there
    /// are none, the operation returns an empty list. For more information about instance
    /// profiles, go to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About instance
    /// profiles</a>.</p>
    /// <p>You can paginate the results using the <code>MaxItems</code> and <code>Marker</code>
    /// parameters.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListInstanceProfilesForRole<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_instance_profiles_for_role_input::Builder,
    }
    impl<C, M, R> ListInstanceProfilesForRole<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListInstanceProfilesForRole`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInstanceProfilesForRoleOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInstanceProfilesForRoleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListInstanceProfilesForRoleInputOperationOutputAlias,
                crate::output::ListInstanceProfilesForRoleOutput,
                crate::error::ListInstanceProfilesForRoleError,
                crate::input::ListInstanceProfilesForRoleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the role to list instance profiles for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_name(inp);
            self
        }
        /// <p>The name of the role to list instance profiles for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_name(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInstanceProfileTags`.
    ///
    /// <p>Lists the tags that are attached to the specified IAM instance profile. The returned list of tags is sorted by tag key.
    /// For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListInstanceProfileTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_instance_profile_tags_input::Builder,
    }
    impl<C, M, R> ListInstanceProfileTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListInstanceProfileTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInstanceProfileTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInstanceProfileTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListInstanceProfileTagsInputOperationOutputAlias,
                crate::output::ListInstanceProfileTagsOutput,
                crate::error::ListInstanceProfileTagsError,
                crate::input::ListInstanceProfileTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IAM instance profile whose tags you want to see.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn instance_profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_profile_name(inp);
            self
        }
        /// <p>The name of the IAM instance profile whose tags you want to see.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_instance_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_profile_name(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMFADevices`.
    ///
    /// <p>Lists the MFA devices for an IAM user. If the request includes a IAM user name,
    /// then this operation lists all the MFA devices associated with the specified user. If you
    /// do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services
    /// access key ID signing the request for this operation.</p>
    /// <p>You can paginate the results using the <code>MaxItems</code> and <code>Marker</code>
    /// parameters.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListMFADevices<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_mfa_devices_input::Builder,
    }
    impl<C, M, R> ListMFADevices<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMFADevices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMfaDevicesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMFADevicesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMfaDevicesInputOperationOutputAlias,
                crate::output::ListMfaDevicesOutput,
                crate::error::ListMFADevicesError,
                crate::input::ListMfaDevicesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user whose MFA devices you want to list.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the user whose MFA devices you want to list.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMFADeviceTags`.
    ///
    /// <p>Lists the tags that are attached to the specified IAM virtual multi-factor authentication (MFA) device. The returned list of tags is
    /// sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListMFADeviceTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_mfa_device_tags_input::Builder,
    }
    impl<C, M, R> ListMFADeviceTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMFADeviceTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMfaDeviceTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMFADeviceTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMfaDeviceTagsInputOperationOutputAlias,
                crate::output::ListMfaDeviceTagsOutput,
                crate::error::ListMFADeviceTagsError,
                crate::input::ListMfaDeviceTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the IAM virtual MFA device whose tags you want to see.
        /// For virtual MFA devices, the serial number is the same as the ARN.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn serial_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.serial_number(inp);
            self
        }
        /// <p>The unique identifier for the IAM virtual MFA device whose tags you want to see.
        /// For virtual MFA devices, the serial number is the same as the ARN.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_serial_number(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOpenIDConnectProviders`.
    ///
    /// <p>Lists information about the IAM OpenID Connect (OIDC) provider resource objects
    /// defined in the Amazon Web Services account.</p>
    /// <note>
    /// <p>IAM resource-listing operations return a subset of the available
    /// attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for an OIDC provider, see <a>GetOpenIDConnectProvider</a>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListOpenIDConnectProviders<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_open_id_connect_providers_input::Builder,
    }
    impl<C, M, R> ListOpenIDConnectProviders<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListOpenIDConnectProviders`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOpenIdConnectProvidersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOpenIDConnectProvidersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListOpenIdConnectProvidersInputOperationOutputAlias,
                crate::output::ListOpenIdConnectProvidersOutput,
                crate::error::ListOpenIDConnectProvidersError,
                crate::input::ListOpenIdConnectProvidersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ListOpenIDConnectProviderTags`.
    ///
    /// <p>Lists the tags that are attached to the specified OpenID Connect (OIDC)-compatible
    /// identity provider. The returned list of tags is sorted by tag key. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html">About web identity
    /// federation</a>.</p>
    /// <p>For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListOpenIDConnectProviderTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_open_id_connect_provider_tags_input::Builder,
    }
    impl<C, M, R> ListOpenIDConnectProviderTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListOpenIDConnectProviderTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOpenIdConnectProviderTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOpenIDConnectProviderTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListOpenIdConnectProviderTagsInputOperationOutputAlias,
                crate::output::ListOpenIdConnectProviderTagsOutput,
                crate::error::ListOpenIDConnectProviderTagsError,
                crate::input::ListOpenIdConnectProviderTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the OpenID Connect (OIDC) identity provider whose tags you want to
        /// see.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn open_id_connect_provider_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.open_id_connect_provider_arn(inp);
            self
        }
        /// <p>The ARN of the OpenID Connect (OIDC) identity provider whose tags you want to
        /// see.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_open_id_connect_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_open_id_connect_provider_arn(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPolicies`.
    ///
    /// <p>Lists all the managed policies that are available in your Amazon Web Services account, including
    /// your own customer-defined managed policies and all Amazon Web Services managed policies.</p>
    /// <p>You can filter the list of policies that is returned using the optional
    /// <code>OnlyAttached</code>, <code>Scope</code>, and <code>PathPrefix</code>
    /// parameters. For example, to list only the customer managed policies in your Amazon Web Services
    /// account, set <code>Scope</code> to <code>Local</code>. To list only Amazon Web Services managed
    /// policies, set <code>Scope</code> to <code>AWS</code>.</p>
    /// <p>You can paginate the results using the <code>MaxItems</code> and <code>Marker</code>
    /// parameters.</p>
    /// <p>For more information about managed policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
    /// policies</a> in the <i>IAM User Guide</i>.</p>
    /// <note>
    /// <p>IAM resource-listing operations return a subset of the available
    /// attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for a customer manged policy, see
    /// <a>GetPolicy</a>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListPolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_policies_input::Builder,
    }
    impl<C, M, R> ListPolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPoliciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPoliciesInputOperationOutputAlias,
                crate::output::ListPoliciesOutput,
                crate::error::ListPoliciesError,
                crate::input::ListPoliciesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The scope to use for filtering the results.</p>
        /// <p>To list only Amazon Web Services managed policies, set <code>Scope</code> to <code>AWS</code>. To
        /// list only the customer managed policies in your Amazon Web Services account, set <code>Scope</code> to
        /// <code>Local</code>.</p>
        /// <p>This parameter is optional. If it is not included, or if it is set to
        /// <code>All</code>, all policies are returned.</p>
        pub fn scope(mut self, inp: crate::model::PolicyScopeType) -> Self {
            self.inner = self.inner.scope(inp);
            self
        }
        /// <p>The scope to use for filtering the results.</p>
        /// <p>To list only Amazon Web Services managed policies, set <code>Scope</code> to <code>AWS</code>. To
        /// list only the customer managed policies in your Amazon Web Services account, set <code>Scope</code> to
        /// <code>Local</code>.</p>
        /// <p>This parameter is optional. If it is not included, or if it is set to
        /// <code>All</code>, all policies are returned.</p>
        pub fn set_scope(
            mut self,
            input: std::option::Option<crate::model::PolicyScopeType>,
        ) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>A flag to filter the results to only the attached policies.</p>
        /// <p>When <code>OnlyAttached</code> is <code>true</code>, the returned list contains only
        /// the policies that are attached to an IAM user, group, or role. When
        /// <code>OnlyAttached</code> is <code>false</code>, or when the parameter is not
        /// included, all policies are returned.</p>
        pub fn only_attached(mut self, inp: bool) -> Self {
            self.inner = self.inner.only_attached(inp);
            self
        }
        /// <p>A flag to filter the results to only the attached policies.</p>
        /// <p>When <code>OnlyAttached</code> is <code>true</code>, the returned list contains only
        /// the policies that are attached to an IAM user, group, or role. When
        /// <code>OnlyAttached</code> is <code>false</code>, or when the parameter is not
        /// included, all policies are returned.</p>
        pub fn set_only_attached(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_only_attached(input);
            self
        }
        /// <p>The path prefix for filtering the results. This parameter is optional. If it is not
        /// included, it defaults to a slash (/), listing all policies. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn path_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path_prefix(inp);
            self
        }
        /// <p>The path prefix for filtering the results. This parameter is optional. If it is not
        /// included, it defaults to a slash (/), listing all policies. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn set_path_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path_prefix(input);
            self
        }
        /// <p>The policy usage method to use for filtering the results.</p>
        /// <p>To list only permissions policies,
        /// set <code>PolicyUsageFilter</code> to <code>PermissionsPolicy</code>. To list only
        /// the policies used to set permissions boundaries, set the value
        /// to <code>PermissionsBoundary</code>.</p>
        /// <p>This parameter is optional. If it is not included, all policies are returned. </p>
        pub fn policy_usage_filter(mut self, inp: crate::model::PolicyUsageType) -> Self {
            self.inner = self.inner.policy_usage_filter(inp);
            self
        }
        /// <p>The policy usage method to use for filtering the results.</p>
        /// <p>To list only permissions policies,
        /// set <code>PolicyUsageFilter</code> to <code>PermissionsPolicy</code>. To list only
        /// the policies used to set permissions boundaries, set the value
        /// to <code>PermissionsBoundary</code>.</p>
        /// <p>This parameter is optional. If it is not included, all policies are returned. </p>
        pub fn set_policy_usage_filter(
            mut self,
            input: std::option::Option<crate::model::PolicyUsageType>,
        ) -> Self {
            self.inner = self.inner.set_policy_usage_filter(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPoliciesGrantingServiceAccess`.
    ///
    /// <p>Retrieves a list of policies that the IAM identity (user, group, or role) can use to
    /// access each specified service.</p>
    /// <note>
    /// <p>This operation does not use other policy types when determining whether a resource
    /// could access a service. These other policy types include resource-based policies,
    /// access control lists, Organizations policies, IAM permissions boundaries, and
    /// STS assume role policies. It only applies permissions policy logic. For more
    /// about the evaluation of policy types, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics">Evaluating policies</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// </note>
    /// <p>The list of policies returned by the operation depends on the ARN of the identity that
    /// you provide.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>User</b> – The list of policies includes
    /// the managed and inline policies that are attached to the user directly. The list
    /// also includes any additional managed and inline policies that are attached to
    /// the group to which the user belongs. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Group</b> – The list of policies includes
    /// only the managed and inline policies that are attached to the group directly.
    /// Policies that are attached to the group’s user are not included.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Role</b> – The list of policies includes
    /// only the managed and inline policies that are attached to the role.</p>
    /// </li>
    /// </ul>
    /// <p>For each managed policy, this operation returns the ARN and policy name. For each
    /// inline policy, it returns the policy name and the entity to which it is attached. Inline
    /// policies do not have an ARN. For more information about these policy types, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed policies and inline policies</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// <p>Policies that are attached to users and roles as permissions boundaries are not
    /// returned. To view which managed policy is currently used to set the permissions boundary
    /// for a user or role, use the <a>GetUser</a> or <a>GetRole</a>
    /// operations.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPoliciesGrantingServiceAccess<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_policies_granting_service_access_input::Builder,
    }
    impl<C, M, R> ListPoliciesGrantingServiceAccess<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPoliciesGrantingServiceAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPoliciesGrantingServiceAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPoliciesGrantingServiceAccessError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPoliciesGrantingServiceAccessInputOperationOutputAlias,
                crate::output::ListPoliciesGrantingServiceAccessOutput,
                crate::error::ListPoliciesGrantingServiceAccessError,
                crate::input::ListPoliciesGrantingServiceAccessInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The ARN of the IAM identity (user, group, or role) whose policies you want to
        /// list.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The ARN of the IAM identity (user, group, or role) whose policies you want to
        /// list.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// Appends an item to `ServiceNamespaces`.
        ///
        /// To override the contents of this collection use [`set_service_namespaces`](Self::set_service_namespaces).
        ///
        /// <p>The service namespace for the Amazon Web Services services whose policies you want to list.</p>
        /// <p>To learn the service namespace for a service, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html">Actions, resources, and condition keys for Amazon Web Services services</a> in the
        /// <i>IAM User Guide</i>. Choose the name of the service to view
        /// details for that service. In the first paragraph, find the service prefix. For example,
        /// <code>(service prefix: a4b)</code>. For more information about service namespaces,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces">Amazon Web Services
        /// service namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn service_namespaces(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_namespaces(inp);
            self
        }
        /// <p>The service namespace for the Amazon Web Services services whose policies you want to list.</p>
        /// <p>To learn the service namespace for a service, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html">Actions, resources, and condition keys for Amazon Web Services services</a> in the
        /// <i>IAM User Guide</i>. Choose the name of the service to view
        /// details for that service. In the first paragraph, find the service prefix. For example,
        /// <code>(service prefix: a4b)</code>. For more information about service namespaces,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces">Amazon Web Services
        /// service namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_service_namespaces(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_service_namespaces(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPolicyTags`.
    ///
    /// <p>Lists the tags that are attached to the specified IAM customer managed policy.
    /// The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPolicyTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_policy_tags_input::Builder,
    }
    impl<C, M, R> ListPolicyTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPolicyTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPolicyTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPolicyTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPolicyTagsInputOperationOutputAlias,
                crate::output::ListPolicyTagsOutput,
                crate::error::ListPolicyTagsError,
                crate::input::ListPolicyTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the IAM customer managed policy whose tags you want to see.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn policy_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_arn(inp);
            self
        }
        /// <p>The ARN of the IAM customer managed policy whose tags you want to see.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_arn(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPolicyVersions`.
    ///
    /// <p>Lists information about the versions of the specified managed policy, including the
    /// version that is currently set as the policy's default version.</p>
    /// <p>For more information about managed policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
    /// policies</a> in the <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPolicyVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_policy_versions_input::Builder,
    }
    impl<C, M, R> ListPolicyVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPolicyVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPolicyVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPolicyVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPolicyVersionsInputOperationOutputAlias,
                crate::output::ListPolicyVersionsOutput,
                crate::error::ListPolicyVersionsError,
                crate::input::ListPolicyVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy for which you want the
        /// versions.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn policy_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy for which you want the
        /// versions.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_arn(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRolePolicies`.
    ///
    /// <p>Lists the names of the inline policies that are embedded in the specified IAM
    /// role.</p>
    /// <p>An IAM role can also have managed policies attached to it. To list the managed
    /// policies that are attached to a role, use <a>ListAttachedRolePolicies</a>.
    /// For more information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
    /// policies</a> in the <i>IAM User Guide</i>.</p>
    /// <p>You can paginate the results using the <code>MaxItems</code> and <code>Marker</code>
    /// parameters. If there are no inline policies embedded with the specified role, the
    /// operation returns an empty list.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRolePolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_role_policies_input::Builder,
    }
    impl<C, M, R> ListRolePolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRolePolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRolePoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRolePoliciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRolePoliciesInputOperationOutputAlias,
                crate::output::ListRolePoliciesOutput,
                crate::error::ListRolePoliciesError,
                crate::input::ListRolePoliciesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the role to list policies for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_name(inp);
            self
        }
        /// <p>The name of the role to list policies for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_name(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRoles`.
    ///
    /// <p>Lists the IAM roles that have the specified path prefix. If there are none, the
    /// operation returns an empty list. For more information about roles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with
    /// roles</a>.</p>
    /// <note>
    /// <p>IAM resource-listing operations return a subset of the available
    /// attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for a role, see <a>GetRole</a>.</p>
    /// </note>
    /// <p>You can paginate the results using the <code>MaxItems</code> and <code>Marker</code>
    /// parameters.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRoles<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_roles_input::Builder,
    }
    impl<C, M, R> ListRoles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRoles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRolesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRolesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRolesInputOperationOutputAlias,
                crate::output::ListRolesOutput,
                crate::error::ListRolesError,
                crate::input::ListRolesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The path prefix for filtering the results. For example, the prefix
        /// <code>/application_abc/component_xyz/</code> gets all roles whose path starts with
        /// <code>/application_abc/component_xyz/</code>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/), listing
        /// all roles. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn path_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path_prefix(inp);
            self
        }
        /// <p> The path prefix for filtering the results. For example, the prefix
        /// <code>/application_abc/component_xyz/</code> gets all roles whose path starts with
        /// <code>/application_abc/component_xyz/</code>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/), listing
        /// all roles. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn set_path_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path_prefix(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRoleTags`.
    ///
    /// <p>Lists the tags that are attached to the specified role. The returned list of tags is
    /// sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRoleTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_role_tags_input::Builder,
    }
    impl<C, M, R> ListRoleTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRoleTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRoleTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRoleTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRoleTagsInputOperationOutputAlias,
                crate::output::ListRoleTagsOutput,
                crate::error::ListRoleTagsError,
                crate::input::ListRoleTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IAM role for which you want to see the list of tags.</p>
        /// <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_name(inp);
            self
        }
        /// <p>The name of the IAM role for which you want to see the list of tags.</p>
        /// <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_name(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSAMLProviders`.
    ///
    /// <p>Lists the SAML provider resource objects defined in IAM in the account.
    /// IAM resource-listing operations return a subset of the available
    /// attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for a SAML provider, see <a>GetSAMLProvider</a>.</p>
    /// <important>
    /// <p> This operation requires <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct ListSAMLProviders<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_saml_providers_input::Builder,
    }
    impl<C, M, R> ListSAMLProviders<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSAMLProviders`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSamlProvidersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSAMLProvidersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSamlProvidersInputOperationOutputAlias,
                crate::output::ListSamlProvidersOutput,
                crate::error::ListSAMLProvidersError,
                crate::input::ListSamlProvidersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ListSAMLProviderTags`.
    ///
    /// <p>Lists the tags that are attached to the specified Security Assertion Markup Language
    /// (SAML) identity provider. The returned list of tags is sorted by tag key. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html">About SAML 2.0-based
    /// federation</a>.</p>
    /// <p>For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSAMLProviderTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_saml_provider_tags_input::Builder,
    }
    impl<C, M, R> ListSAMLProviderTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSAMLProviderTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSamlProviderTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSAMLProviderTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSamlProviderTagsInputOperationOutputAlias,
                crate::output::ListSamlProviderTagsOutput,
                crate::error::ListSAMLProviderTagsError,
                crate::input::ListSamlProviderTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the Security Assertion Markup Language (SAML) identity provider whose tags
        /// you want to see.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn saml_provider_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.saml_provider_arn(inp);
            self
        }
        /// <p>The ARN of the Security Assertion Markup Language (SAML) identity provider whose tags
        /// you want to see.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_saml_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_saml_provider_arn(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServerCertificates`.
    ///
    /// <p>Lists the server certificates stored in IAM that have the specified path prefix. If
    /// none exist, the operation returns an empty list.</p>
    /// <p> You can paginate the results using the <code>MaxItems</code> and <code>Marker</code>
    /// parameters.</p>
    /// <p>For more information about working with server certificates, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working
    /// with server certificates</a> in the <i>IAM User Guide</i>. This
    /// topic also includes a list of Amazon Web Services services that can use the server certificates that
    /// you manage with IAM.</p>
    /// <note>
    /// <p>IAM resource-listing operations return a subset of the available
    /// attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for a servercertificate, see <a>GetServerCertificate</a>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListServerCertificates<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_server_certificates_input::Builder,
    }
    impl<C, M, R> ListServerCertificates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListServerCertificates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServerCertificatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListServerCertificatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListServerCertificatesInputOperationOutputAlias,
                crate::output::ListServerCertificatesOutput,
                crate::error::ListServerCertificatesError,
                crate::input::ListServerCertificatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The path prefix for filtering the results. For example:
        /// <code>/company/servercerts</code> would get all server certificates for which the
        /// path starts with <code>/company/servercerts</code>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/), listing
        /// all server certificates. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn path_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path_prefix(inp);
            self
        }
        /// <p> The path prefix for filtering the results. For example:
        /// <code>/company/servercerts</code> would get all server certificates for which the
        /// path starts with <code>/company/servercerts</code>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/), listing
        /// all server certificates. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn set_path_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path_prefix(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServerCertificateTags`.
    ///
    /// <p>Lists the tags that are attached to the specified IAM server certificate. The
    /// returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// <note>
    /// <p>For certificates in a Region supported by Certificate Manager (ACM), we
    /// recommend that you don't use IAM server certificates. Instead, use ACM to provision,
    /// manage, and deploy your server certificates. For more information about IAM server
    /// certificates, <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
    /// certificates</a> in the <i>IAM User Guide</i>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListServerCertificateTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_server_certificate_tags_input::Builder,
    }
    impl<C, M, R> ListServerCertificateTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListServerCertificateTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServerCertificateTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListServerCertificateTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListServerCertificateTagsInputOperationOutputAlias,
                crate::output::ListServerCertificateTagsOutput,
                crate::error::ListServerCertificateTagsError,
                crate::input::ListServerCertificateTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IAM server certificate whose tags you want to see.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn server_certificate_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_certificate_name(inp);
            self
        }
        /// <p>The name of the IAM server certificate whose tags you want to see.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_server_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_server_certificate_name(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServiceSpecificCredentials`.
    ///
    /// <p>Returns information about the service-specific credentials associated with the
    /// specified IAM user. If none exists, the operation returns an empty list. The
    /// service-specific credentials returned by this operation are used only for authenticating
    /// the IAM user to a specific service. For more information about using service-specific
    /// credentials to authenticate to an Amazon Web Services service, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-gc.html">Set up service-specific credentials</a>
    /// in the CodeCommit User Guide.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListServiceSpecificCredentials<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_service_specific_credentials_input::Builder,
    }
    impl<C, M, R> ListServiceSpecificCredentials<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListServiceSpecificCredentials`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServiceSpecificCredentialsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListServiceSpecificCredentialsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListServiceSpecificCredentialsInputOperationOutputAlias,
                crate::output::ListServiceSpecificCredentialsOutput,
                crate::error::ListServiceSpecificCredentialsError,
                crate::input::ListServiceSpecificCredentialsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user whose service-specific credentials you want information about. If
        /// this value is not specified, then the operation assumes the user whose credentials are
        /// used to call the operation.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the user whose service-specific credentials you want information about. If
        /// this value is not specified, then the operation assumes the user whose credentials are
        /// used to call the operation.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>Filters the returned results to only those for the specified Amazon Web Services service. If not
        /// specified, then Amazon Web Services returns service-specific credentials for all services.</p>
        pub fn service_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_name(inp);
            self
        }
        /// <p>Filters the returned results to only those for the specified Amazon Web Services service. If not
        /// specified, then Amazon Web Services returns service-specific credentials for all services.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSigningCertificates`.
    ///
    /// <p>Returns information about the signing certificates associated with the specified IAM
    /// user. If none exists, the operation returns an empty list.</p>
    /// <p>Although each user is limited to a small number of signing certificates, you can still
    /// paginate the results using the <code>MaxItems</code> and <code>Marker</code>
    /// parameters.</p>
    /// <p>If the <code>UserName</code> field is not specified, the user name is determined
    /// implicitly based on the Amazon Web Services access key ID used to sign the request for this operation.
    /// This operation works for access keys under the Amazon Web Services account. Consequently, you can use
    /// this operation to manage Amazon Web Services account root user credentials even if the Amazon Web Services account
    /// has no associated users.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSigningCertificates<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_signing_certificates_input::Builder,
    }
    impl<C, M, R> ListSigningCertificates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSigningCertificates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSigningCertificatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSigningCertificatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSigningCertificatesInputOperationOutputAlias,
                crate::output::ListSigningCertificatesOutput,
                crate::error::ListSigningCertificatesError,
                crate::input::ListSigningCertificatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IAM user whose signing certificates you want to examine.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the IAM user whose signing certificates you want to examine.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSSHPublicKeys`.
    ///
    /// <p>Returns information about the SSH public keys associated with the specified IAM
    /// user. If none exists, the operation returns an empty list.</p>
    /// <p>The SSH public keys returned by this operation are used only for authenticating the
    /// IAM user to an CodeCommit repository. For more information about using SSH keys to
    /// authenticate to an CodeCommit repository, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up CodeCommit for
    /// SSH connections</a> in the <i>CodeCommit User Guide</i>.</p>
    /// <p>Although each user is limited to a small number of keys, you can still paginate the
    /// results using the <code>MaxItems</code> and <code>Marker</code> parameters.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSSHPublicKeys<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_ssh_public_keys_input::Builder,
    }
    impl<C, M, R> ListSSHPublicKeys<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSSHPublicKeys`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSshPublicKeysOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSSHPublicKeysError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSshPublicKeysInputOperationOutputAlias,
                crate::output::ListSshPublicKeysOutput,
                crate::error::ListSSHPublicKeysError,
                crate::input::ListSshPublicKeysInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IAM user to list SSH public keys for. If none is specified, the
        /// <code>UserName</code> field is determined implicitly based on the Amazon Web Services access key
        /// used to sign the request.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the IAM user to list SSH public keys for. If none is specified, the
        /// <code>UserName</code> field is determined implicitly based on the Amazon Web Services access key
        /// used to sign the request.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUserPolicies`.
    ///
    /// <p>Lists the names of the inline policies embedded in the specified IAM user.</p>
    /// <p>An IAM user can also have managed policies attached to it. To list the managed
    /// policies that are attached to a user, use <a>ListAttachedUserPolicies</a>.
    /// For more information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
    /// policies</a> in the <i>IAM User Guide</i>.</p>
    /// <p>You can paginate the results using the <code>MaxItems</code> and <code>Marker</code>
    /// parameters. If there are no inline policies embedded with the specified user, the
    /// operation returns an empty list.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListUserPolicies<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_user_policies_input::Builder,
    }
    impl<C, M, R> ListUserPolicies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUserPolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUserPoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUserPoliciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUserPoliciesInputOperationOutputAlias,
                crate::output::ListUserPoliciesOutput,
                crate::error::ListUserPoliciesError,
                crate::input::ListUserPoliciesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user to list policies for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the user to list policies for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUsers`.
    ///
    /// <p>Lists the IAM users that have the specified path prefix. If no path prefix is
    /// specified, the operation returns all users in the Amazon Web Services account. If there are none, the
    /// operation returns an empty list.</p>
    /// <note>
    /// <p>IAM resource-listing operations return a subset of the available
    /// attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for a user, see <a>GetUser</a>.</p>
    /// </note>
    /// <p>You can paginate the results using the <code>MaxItems</code> and <code>Marker</code>
    /// parameters.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListUsers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_users_input::Builder,
    }
    impl<C, M, R> ListUsers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUsers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUsersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUsersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUsersInputOperationOutputAlias,
                crate::output::ListUsersOutput,
                crate::error::ListUsersError,
                crate::input::ListUsersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The path prefix for filtering the results. For example:
        /// <code>/division_abc/subdivision_xyz/</code>, which would get all user names whose
        /// path starts with <code>/division_abc/subdivision_xyz/</code>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/), listing
        /// all user names. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn path_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.path_prefix(inp);
            self
        }
        /// <p> The path prefix for filtering the results. For example:
        /// <code>/division_abc/subdivision_xyz/</code>, which would get all user names whose
        /// path starts with <code>/division_abc/subdivision_xyz/</code>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/), listing
        /// all user names. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn set_path_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_path_prefix(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUserTags`.
    ///
    /// <p>Lists the tags that are attached to the specified IAM user. The returned list of tags is sorted by tag key. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListUserTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_user_tags_input::Builder,
    }
    impl<C, M, R> ListUserTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUserTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUserTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUserTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUserTagsInputOperationOutputAlias,
                crate::output::ListUserTagsOutput,
                crate::error::ListUserTagsError,
                crate::input::ListUserTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IAM user whose tags you want to see.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the IAM user whose tags you want to see.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVirtualMFADevices`.
    ///
    /// <p>Lists the virtual MFA devices defined in the Amazon Web Services account by assignment status. If
    /// you do not specify an assignment status, the operation returns a list of all virtual MFA
    /// devices. Assignment status can be <code>Assigned</code>, <code>Unassigned</code>, or
    /// <code>Any</code>.</p>
    /// <note>
    /// <p>IAM resource-listing operations return a subset of the available
    /// attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for a virtual MFA device, see
    /// <a>ListVirtualMFADevices</a>.</p>
    /// </note>
    /// <p>You can paginate the results using the <code>MaxItems</code> and <code>Marker</code>
    /// parameters.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListVirtualMFADevices<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_virtual_mfa_devices_input::Builder,
    }
    impl<C, M, R> ListVirtualMFADevices<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListVirtualMFADevices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVirtualMfaDevicesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVirtualMFADevicesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListVirtualMfaDevicesInputOperationOutputAlias,
                crate::output::ListVirtualMfaDevicesOutput,
                crate::error::ListVirtualMFADevicesError,
                crate::input::ListVirtualMfaDevicesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The status (<code>Unassigned</code> or <code>Assigned</code>) of the devices to list.
        /// If you do not specify an <code>AssignmentStatus</code>, the operation defaults to
        /// <code>Any</code>, which lists both assigned and unassigned virtual MFA
        /// devices.,</p>
        pub fn assignment_status(mut self, inp: crate::model::AssignmentStatusType) -> Self {
            self.inner = self.inner.assignment_status(inp);
            self
        }
        /// <p> The status (<code>Unassigned</code> or <code>Assigned</code>) of the devices to list.
        /// If you do not specify an <code>AssignmentStatus</code>, the operation defaults to
        /// <code>Any</code>, which lists both assigned and unassigned virtual MFA
        /// devices.,</p>
        pub fn set_assignment_status(
            mut self,
            input: std::option::Option<crate::model::AssignmentStatusType>,
        ) -> Self {
            self.inner = self.inner.set_assignment_status(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutGroupPolicy`.
    ///
    /// <p>Adds or updates an inline policy document that is embedded in the specified IAM
    /// group.</p>
    /// <p>A user can also have managed policies attached to it. To attach a managed policy to a
    /// group, use <a>AttachGroupPolicy</a>. To create a new managed policy, use
    /// <a>CreatePolicy</a>. For information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed
    /// policies and inline policies</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// <p>For information about the maximum number of inline policies that you can embed in a
    /// group, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the <i>IAM User Guide</i>.</p>
    /// <note>
    /// <p>Because policy documents can be large, you should use POST rather than GET when
    /// calling <code>PutGroupPolicy</code>. For general information about using the Query
    /// API with IAM, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html">Making query requests</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct PutGroupPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_group_policy_input::Builder,
    }
    impl<C, M, R> PutGroupPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutGroupPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutGroupPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutGroupPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutGroupPolicyInputOperationOutputAlias,
                crate::output::PutGroupPolicyOutput,
                crate::error::PutGroupPolicyError,
                crate::input::PutGroupPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the group to associate the policy with.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-.</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>The name of the group to associate the policy with.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The name of the policy document.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn policy_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(inp);
            self
        }
        /// <p>The name of the policy document.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The policy document.</p>
        ///
        /// <p>You must provide policies in JSON format in IAM. However, for CloudFormation
        /// templates formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to JSON format before submitting it to
        /// =            IAM.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn policy_document(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_document(inp);
            self
        }
        /// <p>The policy document.</p>
        ///
        /// <p>You must provide policies in JSON format in IAM. However, for CloudFormation
        /// templates formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to JSON format before submitting it to
        /// =            IAM.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_document(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutRolePermissionsBoundary`.
    ///
    /// <p>Adds or updates the policy that is specified as the IAM role's permissions boundary.
    /// You can use an Amazon Web Services managed policy or a customer managed policy to set the boundary for
    /// a role. Use the boundary to control the maximum permissions that the role can have.
    /// Setting a permissions boundary is an advanced feature that can affect the permissions
    /// for the role.</p>
    /// <p>You cannot set the boundary for a service-linked role. </p>
    /// <important>
    /// <p>Policies used as permissions boundaries do not provide permissions. You must also
    /// attach a permissions policy to the role. To learn how the effective permissions for
    /// a role are evaluated, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html">IAM JSON policy
    /// evaluation logic</a> in the IAM User Guide. </p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct PutRolePermissionsBoundary<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_role_permissions_boundary_input::Builder,
    }
    impl<C, M, R> PutRolePermissionsBoundary<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutRolePermissionsBoundary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutRolePermissionsBoundaryOutput,
            aws_smithy_http::result::SdkError<crate::error::PutRolePermissionsBoundaryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutRolePermissionsBoundaryInputOperationOutputAlias,
                crate::output::PutRolePermissionsBoundaryOutput,
                crate::error::PutRolePermissionsBoundaryError,
                crate::input::PutRolePermissionsBoundaryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name (friendly name, not ARN) of the IAM role for which you want to set the
        /// permissions boundary.</p>
        pub fn role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_name(inp);
            self
        }
        /// <p>The name (friendly name, not ARN) of the IAM role for which you want to set the
        /// permissions boundary.</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_name(input);
            self
        }
        /// <p>The ARN of the policy that is used to set the permissions boundary for the
        /// role.</p>
        pub fn permissions_boundary(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permissions_boundary(inp);
            self
        }
        /// <p>The ARN of the policy that is used to set the permissions boundary for the
        /// role.</p>
        pub fn set_permissions_boundary(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permissions_boundary(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutRolePolicy`.
    ///
    /// <p>Adds or updates an inline policy document that is embedded in the specified IAM
    /// role.</p>
    /// <p>When you embed an inline policy in a role, the inline policy is used as part of the
    /// role's access (permissions) policy. The role's trust policy is created at the same time
    /// as the role, using <a>CreateRole</a>. You can update a role's trust policy
    /// using <a>UpdateAssumeRolePolicy</a>. For more information about IAM roles,
    /// see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html">Using roles to
    /// delegate permissions and federate identities</a>.</p>
    /// <p>A role can also have a managed policy attached to it. To attach a managed policy to a
    /// role, use <a>AttachRolePolicy</a>. To create a new managed policy, use <a>CreatePolicy</a>. For information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed
    /// policies and inline policies</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// <p>For information about the maximum number of inline policies that you can embed with a
    /// role, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the <i>IAM User Guide</i>.</p>
    /// <note>
    /// <p>Because policy documents can be large, you should use POST rather than GET when
    /// calling <code>PutRolePolicy</code>. For general information about using the Query
    /// API with IAM, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html">Making query requests</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct PutRolePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_role_policy_input::Builder,
    }
    impl<C, M, R> PutRolePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutRolePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutRolePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutRolePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutRolePolicyInputOperationOutputAlias,
                crate::output::PutRolePolicyOutput,
                crate::error::PutRolePolicyError,
                crate::input::PutRolePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the role to associate the policy with.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_name(inp);
            self
        }
        /// <p>The name of the role to associate the policy with.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_name(input);
            self
        }
        /// <p>The name of the policy document.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn policy_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(inp);
            self
        }
        /// <p>The name of the policy document.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The policy document.</p>
        /// <p>You must provide policies in JSON format in IAM. However, for CloudFormation
        /// templates formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to JSON format before submitting it to
        /// IAM.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn policy_document(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_document(inp);
            self
        }
        /// <p>The policy document.</p>
        /// <p>You must provide policies in JSON format in IAM. However, for CloudFormation
        /// templates formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to JSON format before submitting it to
        /// IAM.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_document(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutUserPermissionsBoundary`.
    ///
    /// <p>Adds or updates the policy that is specified as the IAM user's permissions boundary.
    /// You can use an Amazon Web Services managed policy or a customer managed policy to set the boundary for
    /// a user. Use the boundary to control the maximum permissions that the user can have.
    /// Setting a permissions boundary is an advanced feature that can affect the permissions
    /// for the user.</p>
    /// <important>
    /// <p>Policies that are used as permissions boundaries do not provide permissions. You
    /// must also attach a permissions policy to the user. To learn how the effective
    /// permissions for a user are evaluated, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html">IAM JSON policy
    /// evaluation logic</a> in the IAM User Guide. </p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct PutUserPermissionsBoundary<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_user_permissions_boundary_input::Builder,
    }
    impl<C, M, R> PutUserPermissionsBoundary<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutUserPermissionsBoundary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutUserPermissionsBoundaryOutput,
            aws_smithy_http::result::SdkError<crate::error::PutUserPermissionsBoundaryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutUserPermissionsBoundaryInputOperationOutputAlias,
                crate::output::PutUserPermissionsBoundaryOutput,
                crate::error::PutUserPermissionsBoundaryError,
                crate::input::PutUserPermissionsBoundaryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name (friendly name, not ARN) of the IAM user for which you want to set the
        /// permissions boundary.</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name (friendly name, not ARN) of the IAM user for which you want to set the
        /// permissions boundary.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The ARN of the policy that is used to set the permissions boundary for the
        /// user.</p>
        pub fn permissions_boundary(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permissions_boundary(inp);
            self
        }
        /// <p>The ARN of the policy that is used to set the permissions boundary for the
        /// user.</p>
        pub fn set_permissions_boundary(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_permissions_boundary(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutUserPolicy`.
    ///
    /// <p>Adds or updates an inline policy document that is embedded in the specified IAM
    /// user.</p>
    /// <p>An IAM user can also have a managed policy attached to it. To attach a managed
    /// policy to a user, use <a>AttachUserPolicy</a>. To create a new managed
    /// policy, use <a>CreatePolicy</a>. For information about policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed
    /// policies and inline policies</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// <p>For information about the maximum number of inline policies that you can embed in a
    /// user, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS quotas</a> in the <i>IAM User Guide</i>.</p>
    /// <note>
    /// <p>Because policy documents can be large, you should use POST rather than GET when
    /// calling <code>PutUserPolicy</code>. For general information about using the Query
    /// API with IAM, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html">Making query requests</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct PutUserPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_user_policy_input::Builder,
    }
    impl<C, M, R> PutUserPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutUserPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutUserPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutUserPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutUserPolicyInputOperationOutputAlias,
                crate::output::PutUserPolicyOutput,
                crate::error::PutUserPolicyError,
                crate::input::PutUserPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user to associate the policy with.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the user to associate the policy with.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The name of the policy document.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn policy_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(inp);
            self
        }
        /// <p>The name of the policy document.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>The policy document.</p>
        ///
        /// <p>You must provide policies in JSON format in IAM. However, for CloudFormation
        /// templates formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to JSON format before submitting it to
        /// IAM.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn policy_document(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_document(inp);
            self
        }
        /// <p>The policy document.</p>
        ///
        /// <p>You must provide policies in JSON format in IAM. However, for CloudFormation
        /// templates formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to JSON format before submitting it to
        /// IAM.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_document(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveClientIDFromOpenIDConnectProvider`.
    ///
    /// <p>Removes the specified client ID (also known as audience) from the list of client IDs
    /// registered for the specified IAM OpenID Connect (OIDC) provider resource
    /// object.</p>
    /// <p>This operation is idempotent; it does not fail or return an error if you try to remove
    /// a client ID that does not exist.</p>
    #[derive(std::fmt::Debug)]
    pub struct RemoveClientIDFromOpenIDConnectProvider<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_client_id_from_open_id_connect_provider_input::Builder,
    }
    impl<C, M, R> RemoveClientIDFromOpenIDConnectProvider<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveClientIDFromOpenIDConnectProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveClientIdFromOpenIdConnectProviderOutput,
            aws_smithy_http::result::SdkError<
                crate::error::RemoveClientIDFromOpenIDConnectProviderError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveClientIdFromOpenIdConnectProviderInputOperationOutputAlias,
                crate::output::RemoveClientIdFromOpenIdConnectProviderOutput,
                crate::error::RemoveClientIDFromOpenIDConnectProviderError,
                crate::input::RemoveClientIdFromOpenIdConnectProviderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM OIDC provider resource to remove the
        /// client ID from. You can get a list of OIDC provider ARNs by using the <a>ListOpenIDConnectProviders</a> operation.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn open_id_connect_provider_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.open_id_connect_provider_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM OIDC provider resource to remove the
        /// client ID from. You can get a list of OIDC provider ARNs by using the <a>ListOpenIDConnectProviders</a> operation.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_open_id_connect_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_open_id_connect_provider_arn(input);
            self
        }
        /// <p>The client ID (also known as audience) to remove from the IAM OIDC provider
        /// resource. For more information about client IDs, see <a>CreateOpenIDConnectProvider</a>.</p>
        pub fn client_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_id(inp);
            self
        }
        /// <p>The client ID (also known as audience) to remove from the IAM OIDC provider
        /// resource. For more information about client IDs, see <a>CreateOpenIDConnectProvider</a>.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveRoleFromInstanceProfile`.
    ///
    /// <p>Removes the specified IAM role from the specified EC2 instance profile.</p>
    /// <important>
    /// <p>Make sure that you do not have any Amazon EC2 instances running with the role you
    /// are about to remove from the instance profile. Removing a role from an instance
    /// profile that is associated with a running instance might break any applications
    /// running on the instance.</p>
    /// </important>
    /// <p> For more information about IAM roles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with roles</a>. For more
    /// information about instance profiles, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About instance
    /// profiles</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct RemoveRoleFromInstanceProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_role_from_instance_profile_input::Builder,
    }
    impl<C, M, R> RemoveRoleFromInstanceProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveRoleFromInstanceProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveRoleFromInstanceProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveRoleFromInstanceProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveRoleFromInstanceProfileInputOperationOutputAlias,
                crate::output::RemoveRoleFromInstanceProfileOutput,
                crate::error::RemoveRoleFromInstanceProfileError,
                crate::input::RemoveRoleFromInstanceProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the instance profile to update.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn instance_profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_profile_name(inp);
            self
        }
        /// <p>The name of the instance profile to update.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_instance_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_profile_name(input);
            self
        }
        /// <p>The name of the role to remove.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_name(inp);
            self
        }
        /// <p>The name of the role to remove.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveUserFromGroup`.
    ///
    /// <p>Removes the specified user from the specified group.</p>
    #[derive(std::fmt::Debug)]
    pub struct RemoveUserFromGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_user_from_group_input::Builder,
    }
    impl<C, M, R> RemoveUserFromGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveUserFromGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveUserFromGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveUserFromGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveUserFromGroupInputOperationOutputAlias,
                crate::output::RemoveUserFromGroupOutput,
                crate::error::RemoveUserFromGroupError,
                crate::input::RemoveUserFromGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the group to update.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.group_name(inp);
            self
        }
        /// <p>The name of the group to update.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_group_name(input);
            self
        }
        /// <p>The name of the user to remove.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the user to remove.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResetServiceSpecificCredential`.
    ///
    /// <p>Resets the password for a service-specific credential. The new password is Amazon Web Services
    /// generated and cryptographically strong. It cannot be configured by the user. Resetting
    /// the password immediately invalidates the previous password associated with this
    /// user.</p>
    #[derive(std::fmt::Debug)]
    pub struct ResetServiceSpecificCredential<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reset_service_specific_credential_input::Builder,
    }
    impl<C, M, R> ResetServiceSpecificCredential<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResetServiceSpecificCredential`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResetServiceSpecificCredentialOutput,
            aws_smithy_http::result::SdkError<crate::error::ResetServiceSpecificCredentialError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResetServiceSpecificCredentialInputOperationOutputAlias,
                crate::output::ResetServiceSpecificCredentialOutput,
                crate::error::ResetServiceSpecificCredentialError,
                crate::input::ResetServiceSpecificCredentialInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IAM user associated with the service-specific credential. If this
        /// value is not specified, then the operation assumes the user whose credentials are used
        /// to call the operation.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the IAM user associated with the service-specific credential. If this
        /// value is not specified, then the operation assumes the user whose credentials are used
        /// to call the operation.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The unique identifier of the service-specific credential.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can
        /// consist of any upper or lowercased letter or digit.</p>
        pub fn service_specific_credential_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.service_specific_credential_id(inp);
            self
        }
        /// <p>The unique identifier of the service-specific credential.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can
        /// consist of any upper or lowercased letter or digit.</p>
        pub fn set_service_specific_credential_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_specific_credential_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResyncMFADevice`.
    ///
    /// <p>Synchronizes the specified MFA device with its IAM resource object on the Amazon Web Services
    /// servers.</p>
    /// <p>For more information about creating and working with virtual MFA devices, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html">Using a virtual MFA
    /// device</a> in the <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ResyncMFADevice<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::resync_mfa_device_input::Builder,
    }
    impl<C, M, R> ResyncMFADevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResyncMFADevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResyncMfaDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::ResyncMFADeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResyncMfaDeviceInputOperationOutputAlias,
                crate::output::ResyncMfaDeviceOutput,
                crate::error::ResyncMFADeviceError,
                crate::input::ResyncMfaDeviceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user whose MFA device you want to resynchronize.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the user whose MFA device you want to resynchronize.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>Serial number that uniquely identifies the MFA device.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn serial_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.serial_number(inp);
            self
        }
        /// <p>Serial number that uniquely identifies the MFA device.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_serial_number(input);
            self
        }
        /// <p>An authentication code emitted by the device.</p>
        /// <p>The format for this parameter is a sequence of six digits.</p>
        pub fn authentication_code1(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_code1(inp);
            self
        }
        /// <p>An authentication code emitted by the device.</p>
        /// <p>The format for this parameter is a sequence of six digits.</p>
        pub fn set_authentication_code1(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_code1(input);
            self
        }
        /// <p>A subsequent authentication code emitted by the device.</p>
        /// <p>The format for this parameter is a sequence of six digits.</p>
        pub fn authentication_code2(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_code2(inp);
            self
        }
        /// <p>A subsequent authentication code emitted by the device.</p>
        /// <p>The format for this parameter is a sequence of six digits.</p>
        pub fn set_authentication_code2(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_code2(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetDefaultPolicyVersion`.
    ///
    /// <p>Sets the specified version of the specified policy as the policy's default (operative)
    /// version.</p>
    /// <p>This operation affects all users, groups, and roles that the policy is attached to. To
    /// list the users, groups, and roles that the policy is attached to, use <a>ListEntitiesForPolicy</a>.</p>
    /// <p>For information about managed policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
    /// policies</a> in the <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct SetDefaultPolicyVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_default_policy_version_input::Builder,
    }
    impl<C, M, R> SetDefaultPolicyVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetDefaultPolicyVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetDefaultPolicyVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::SetDefaultPolicyVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetDefaultPolicyVersionInputOperationOutputAlias,
                crate::output::SetDefaultPolicyVersionOutput,
                crate::error::SetDefaultPolicyVersionError,
                crate::input::SetDefaultPolicyVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy whose default version you want to
        /// set.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn policy_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy whose default version you want to
        /// set.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_arn(input);
            self
        }
        /// <p>The version of the policy to set as the default (operative) version.</p>
        /// <p>For more information about managed policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
        /// policies</a> in the <i>IAM User Guide</i>.</p>
        pub fn version_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version_id(inp);
            self
        }
        /// <p>The version of the policy to set as the default (operative) version.</p>
        /// <p>For more information about managed policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
        /// policies</a> in the <i>IAM User Guide</i>.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetSecurityTokenServicePreferences`.
    ///
    /// <p>Sets the specified version of the global endpoint token as the token version used for
    /// the Amazon Web Services account.</p>
    /// <p>By default, Security Token Service (STS) is available as a global service, and all STS requests
    /// go to a single endpoint at <code>https://sts.amazonaws.com</code>. Amazon Web Services recommends
    /// using Regional STS endpoints to reduce latency, build in redundancy, and increase
    /// session token availability. For information about Regional endpoints for STS, see
    /// <a href="https://docs.aws.amazon.com/general/latest/gr/sts.html">Security Token Service
    /// endpoints and quotas</a> in the <i>Amazon Web Services General Reference</i>.</p>
    /// <p>If you make an STS call to the global endpoint, the resulting session tokens might
    /// be valid in some Regions but not others. It depends on the version that is set in this
    /// operation. Version 1 tokens are valid only in Amazon Web Services Regions that are
    /// available by default. These tokens do not work in manually enabled Regions, such as Asia
    /// Pacific (Hong Kong). Version 2 tokens are valid in all Regions. However, version 2
    /// tokens are longer and might affect systems where you temporarily store tokens. For
    /// information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and
    /// deactivating STS in an Amazon Web Services Region</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// <p>To view the current session token version, see the
    /// <code>GlobalEndpointTokenVersion</code> entry in the response of the <a>GetAccountSummary</a> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct SetSecurityTokenServicePreferences<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_security_token_service_preferences_input::Builder,
    }
    impl<C, M, R> SetSecurityTokenServicePreferences<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetSecurityTokenServicePreferences`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetSecurityTokenServicePreferencesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::SetSecurityTokenServicePreferencesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetSecurityTokenServicePreferencesInputOperationOutputAlias,
                crate::output::SetSecurityTokenServicePreferencesOutput,
                crate::error::SetSecurityTokenServicePreferencesError,
                crate::input::SetSecurityTokenServicePreferencesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The version of the global endpoint token. Version 1 tokens are valid only in Amazon Web Services Regions that are available by default. These tokens do not work in
        /// manually enabled Regions, such as Asia Pacific (Hong Kong). Version 2 tokens are valid
        /// in all Regions. However, version 2 tokens are longer and might affect systems where you
        /// temporarily store tokens.</p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and
        /// deactivating STS in an Amazon Web Services Region</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn global_endpoint_token_version(
            mut self,
            inp: crate::model::GlobalEndpointTokenVersion,
        ) -> Self {
            self.inner = self.inner.global_endpoint_token_version(inp);
            self
        }
        /// <p>The version of the global endpoint token. Version 1 tokens are valid only in Amazon Web Services Regions that are available by default. These tokens do not work in
        /// manually enabled Regions, such as Asia Pacific (Hong Kong). Version 2 tokens are valid
        /// in all Regions. However, version 2 tokens are longer and might affect systems where you
        /// temporarily store tokens.</p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and
        /// deactivating STS in an Amazon Web Services Region</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn set_global_endpoint_token_version(
            mut self,
            input: std::option::Option<crate::model::GlobalEndpointTokenVersion>,
        ) -> Self {
            self.inner = self.inner.set_global_endpoint_token_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SimulateCustomPolicy`.
    ///
    /// <p>Simulate how a set of IAM policies and optionally a resource-based policy works with
    /// a list of API operations and Amazon Web Services resources to determine the policies' effective
    /// permissions. The policies are provided as strings.</p>
    /// <p>The simulation does not perform the API operations; it only checks the authorization
    /// to determine if the simulated policies allow or deny the operations. You can simulate
    /// resources that don't exist in your account.</p>
    /// <p>If you want to simulate existing policies that are attached to an IAM user, group,
    /// or role, use <a>SimulatePrincipalPolicy</a> instead.</p>
    /// <p>Context keys are variables that are maintained by Amazon Web Services and its services and which
    /// provide details about the context of an API query request. You can use the
    /// <code>Condition</code> element of an IAM policy to evaluate context keys. To get
    /// the list of context keys that the policies require for correct simulation, use <a>GetContextKeysForCustomPolicy</a>.</p>
    /// <p>If the output is long, you can use <code>MaxItems</code> and <code>Marker</code>
    /// parameters to paginate the results.</p>
    /// <p>For more information about using the policy simulator, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_testing-policies.html">Testing IAM policies
    /// with the IAM policy simulator </a>in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct SimulateCustomPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::simulate_custom_policy_input::Builder,
    }
    impl<C, M, R> SimulateCustomPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SimulateCustomPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SimulateCustomPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::SimulateCustomPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SimulateCustomPolicyInputOperationOutputAlias,
                crate::output::SimulateCustomPolicyOutput,
                crate::error::SimulateCustomPolicyError,
                crate::input::SimulateCustomPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `PolicyInputList`.
        ///
        /// To override the contents of this collection use [`set_policy_input_list`](Self::set_policy_input_list).
        ///
        /// <p>A list of policy documents to include in the simulation. Each document is specified as
        /// a string containing the complete, valid JSON text of an IAM policy. Do not include any
        /// resource-based policies in this parameter. Any resource-based policy must be submitted
        /// with the <code>ResourcePolicy</code> parameter. The policies cannot be "scope-down"
        /// policies, such as you could include in a call to <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetFederationToken.html">GetFederationToken</a> or one of
        /// the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_AssumeRole.html">AssumeRole</a> API operations. In other words, do not use policies designed to
        /// restrict what a user can do while using the temporary credentials.</p>
        /// <p>The maximum length of the policy document that you can pass in this operation,
        /// including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length">IAM and STS character quotas</a>.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn policy_input_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_input_list(inp);
            self
        }
        /// <p>A list of policy documents to include in the simulation. Each document is specified as
        /// a string containing the complete, valid JSON text of an IAM policy. Do not include any
        /// resource-based policies in this parameter. Any resource-based policy must be submitted
        /// with the <code>ResourcePolicy</code> parameter. The policies cannot be "scope-down"
        /// policies, such as you could include in a call to <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetFederationToken.html">GetFederationToken</a> or one of
        /// the <a href="https://docs.aws.amazon.com/IAM/latest/APIReference/API_AssumeRole.html">AssumeRole</a> API operations. In other words, do not use policies designed to
        /// restrict what a user can do while using the temporary credentials.</p>
        /// <p>The maximum length of the policy document that you can pass in this operation,
        /// including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length">IAM and STS character quotas</a>.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn set_policy_input_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_policy_input_list(input);
            self
        }
        /// Appends an item to `PermissionsBoundaryPolicyInputList`.
        ///
        /// To override the contents of this collection use [`set_permissions_boundary_policy_input_list`](Self::set_permissions_boundary_policy_input_list).
        ///
        /// <p>The IAM permissions boundary policy to simulate. The permissions boundary sets the
        /// maximum permissions that an IAM entity can have. You can input only one permissions
        /// boundary when you pass a policy to this operation. For more information about
        /// permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
        /// entities</a> in the <i>IAM User Guide</i>. The policy input is
        /// specified as a string that contains the complete, valid JSON text of a permissions
        /// boundary policy.</p>
        /// <p>The maximum length of the policy document that you can pass in this operation,
        /// including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length">IAM and STS character quotas</a>.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn permissions_boundary_policy_input_list(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.permissions_boundary_policy_input_list(inp);
            self
        }
        /// <p>The IAM permissions boundary policy to simulate. The permissions boundary sets the
        /// maximum permissions that an IAM entity can have. You can input only one permissions
        /// boundary when you pass a policy to this operation. For more information about
        /// permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
        /// entities</a> in the <i>IAM User Guide</i>. The policy input is
        /// specified as a string that contains the complete, valid JSON text of a permissions
        /// boundary policy.</p>
        /// <p>The maximum length of the policy document that you can pass in this operation,
        /// including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length">IAM and STS character quotas</a>.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn set_permissions_boundary_policy_input_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_permissions_boundary_policy_input_list(input);
            self
        }
        /// Appends an item to `ActionNames`.
        ///
        /// To override the contents of this collection use [`set_action_names`](Self::set_action_names).
        ///
        /// <p>A list of names of API operations to evaluate in the simulation. Each operation is
        /// evaluated against each resource. Each operation must include the service identifier,
        /// such as <code>iam:CreateUser</code>. This operation does not support using wildcards (*)
        /// in an action name.</p>
        pub fn action_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_names(inp);
            self
        }
        /// <p>A list of names of API operations to evaluate in the simulation. Each operation is
        /// evaluated against each resource. Each operation must include the service identifier,
        /// such as <code>iam:CreateUser</code>. This operation does not support using wildcards (*)
        /// in an action name.</p>
        pub fn set_action_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_action_names(input);
            self
        }
        /// Appends an item to `ResourceArns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>A list of ARNs of Amazon Web Services resources to include in the simulation. If this parameter is
        /// not provided, then the value defaults to <code>*</code> (all resources). Each API in the
        /// <code>ActionNames</code> parameter is evaluated for each resource in this list. The
        /// simulation determines the access result (allowed or denied) of each combination and
        /// reports it in the response. You can simulate resources that don't exist in your
        /// account.</p>
        /// <p>The simulation does not automatically retrieve policies for the specified resources.
        /// If you want to include a resource policy in the simulation, then you must include the
        /// policy as a string in the <code>ResourcePolicy</code> parameter.</p>
        /// <p>If you include a <code>ResourcePolicy</code>, then it must be applicable to all of the
        /// resources included in the simulation or you receive an invalid input error.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn resource_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arns(inp);
            self
        }
        /// <p>A list of ARNs of Amazon Web Services resources to include in the simulation. If this parameter is
        /// not provided, then the value defaults to <code>*</code> (all resources). Each API in the
        /// <code>ActionNames</code> parameter is evaluated for each resource in this list. The
        /// simulation determines the access result (allowed or denied) of each combination and
        /// reports it in the response. You can simulate resources that don't exist in your
        /// account.</p>
        /// <p>The simulation does not automatically retrieve policies for the specified resources.
        /// If you want to include a resource policy in the simulation, then you must include the
        /// policy as a string in the <code>ResourcePolicy</code> parameter.</p>
        /// <p>If you include a <code>ResourcePolicy</code>, then it must be applicable to all of the
        /// resources included in the simulation or you receive an invalid input error.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_arns(input);
            self
        }
        /// <p>A resource-based policy to include in the simulation provided as a string. Each
        /// resource in the simulation is treated as if it had this policy attached. You can include
        /// only one resource-based policy in a simulation.</p>
        /// <p>The maximum length of the policy document that you can pass in this operation,
        /// including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length">IAM and STS character quotas</a>.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn resource_policy(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_policy(inp);
            self
        }
        /// <p>A resource-based policy to include in the simulation provided as a string. Each
        /// resource in the simulation is treated as if it had this policy attached. You can include
        /// only one resource-based policy in a simulation.</p>
        /// <p>The maximum length of the policy document that you can pass in this operation,
        /// including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length">IAM and STS character quotas</a>.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn set_resource_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_policy(input);
            self
        }
        /// <p>An ARN representing the Amazon Web Services account ID that specifies the owner of any simulated
        /// resource that does not identify its owner in the resource ARN. Examples of resource ARNs
        /// include an S3 bucket or object. If <code>ResourceOwner</code> is specified, it is also
        /// used as the account owner of any <code>ResourcePolicy</code> included in the simulation.
        /// If the <code>ResourceOwner</code> parameter is not specified, then the owner of the
        /// resources and the resource policy defaults to the account of the identity provided in
        /// <code>CallerArn</code>. This parameter is required only if you specify a
        /// resource-based policy and account that owns the resource is different from the account
        /// that owns the simulated calling user <code>CallerArn</code>.</p>
        /// <p>The ARN for an account uses the following syntax:
        /// <code>arn:aws:iam::<i>AWS-account-ID</i>:root</code>. For example,
        /// to represent the account with the 112233445566 ID, use the following ARN:
        /// <code>arn:aws:iam::112233445566-ID:root</code>. </p>
        pub fn resource_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_owner(inp);
            self
        }
        /// <p>An ARN representing the Amazon Web Services account ID that specifies the owner of any simulated
        /// resource that does not identify its owner in the resource ARN. Examples of resource ARNs
        /// include an S3 bucket or object. If <code>ResourceOwner</code> is specified, it is also
        /// used as the account owner of any <code>ResourcePolicy</code> included in the simulation.
        /// If the <code>ResourceOwner</code> parameter is not specified, then the owner of the
        /// resources and the resource policy defaults to the account of the identity provided in
        /// <code>CallerArn</code>. This parameter is required only if you specify a
        /// resource-based policy and account that owns the resource is different from the account
        /// that owns the simulated calling user <code>CallerArn</code>.</p>
        /// <p>The ARN for an account uses the following syntax:
        /// <code>arn:aws:iam::<i>AWS-account-ID</i>:root</code>. For example,
        /// to represent the account with the 112233445566 ID, use the following ARN:
        /// <code>arn:aws:iam::112233445566-ID:root</code>. </p>
        pub fn set_resource_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_owner(input);
            self
        }
        /// <p>The ARN of the IAM user that you want to use as the simulated caller of the API
        /// operations. <code>CallerArn</code> is required if you include a
        /// <code>ResourcePolicy</code> so that the policy's <code>Principal</code> element has
        /// a value to use in evaluating the policy.</p>
        /// <p>You can specify only the ARN of an IAM user. You cannot specify the ARN of an
        /// assumed role, federated user, or a service principal.</p>
        pub fn caller_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.caller_arn(inp);
            self
        }
        /// <p>The ARN of the IAM user that you want to use as the simulated caller of the API
        /// operations. <code>CallerArn</code> is required if you include a
        /// <code>ResourcePolicy</code> so that the policy's <code>Principal</code> element has
        /// a value to use in evaluating the policy.</p>
        /// <p>You can specify only the ARN of an IAM user. You cannot specify the ARN of an
        /// assumed role, federated user, or a service principal.</p>
        pub fn set_caller_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_caller_arn(input);
            self
        }
        /// Appends an item to `ContextEntries`.
        ///
        /// To override the contents of this collection use [`set_context_entries`](Self::set_context_entries).
        ///
        /// <p>A list of context keys and corresponding values for the simulation to use. Whenever a
        /// context key is evaluated in one of the simulated IAM permissions policies, the
        /// corresponding value is supplied.</p>
        pub fn context_entries(mut self, inp: impl Into<crate::model::ContextEntry>) -> Self {
            self.inner = self.inner.context_entries(inp);
            self
        }
        /// <p>A list of context keys and corresponding values for the simulation to use. Whenever a
        /// context key is evaluated in one of the simulated IAM permissions policies, the
        /// corresponding value is supplied.</p>
        pub fn set_context_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContextEntry>>,
        ) -> Self {
            self.inner = self.inner.set_context_entries(input);
            self
        }
        /// <p>Specifies the type of simulation to run. Different API operations that support
        /// resource-based policies require different combinations of resources. By specifying the
        /// type of simulation to run, you enable the policy simulator to enforce the presence of
        /// the required resources to ensure reliable simulation results. If your simulation does
        /// not match one of the following scenarios, then you can omit this parameter. The
        /// following list shows each of the supported scenario values and the resources that you
        /// must define to run the simulation.</p>
        /// <p>Each of the EC2 scenarios requires that you specify instance, image, and
        /// security-group resources. If your scenario includes an EBS volume, then you must specify
        /// that volume as a resource. If the EC2 scenario includes VPC, then you must supply the
        /// network-interface resource. If it includes an IP subnet, then you must specify the
        /// subnet resource. For more information on the EC2 scenario options, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported platforms</a> in the <i>Amazon EC2 User
        /// Guide</i>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>EC2-Classic-InstanceStore</b>
        /// </p>
        /// <p>instance, image, security-group</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>EC2-Classic-EBS</b>
        /// </p>
        /// <p>instance, image, security-group, volume</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>EC2-VPC-InstanceStore</b>
        /// </p>
        /// <p>instance, image, security-group, network-interface</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>EC2-VPC-InstanceStore-Subnet</b>
        /// </p>
        /// <p>instance, image, security-group, network-interface, subnet</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>EC2-VPC-EBS</b>
        /// </p>
        /// <p>instance, image, security-group, network-interface, volume</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>EC2-VPC-EBS-Subnet</b>
        /// </p>
        /// <p>instance, image, security-group, network-interface, subnet, volume</p>
        /// </li>
        /// </ul>
        pub fn resource_handling_option(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_handling_option(inp);
            self
        }
        /// <p>Specifies the type of simulation to run. Different API operations that support
        /// resource-based policies require different combinations of resources. By specifying the
        /// type of simulation to run, you enable the policy simulator to enforce the presence of
        /// the required resources to ensure reliable simulation results. If your simulation does
        /// not match one of the following scenarios, then you can omit this parameter. The
        /// following list shows each of the supported scenario values and the resources that you
        /// must define to run the simulation.</p>
        /// <p>Each of the EC2 scenarios requires that you specify instance, image, and
        /// security-group resources. If your scenario includes an EBS volume, then you must specify
        /// that volume as a resource. If the EC2 scenario includes VPC, then you must supply the
        /// network-interface resource. If it includes an IP subnet, then you must specify the
        /// subnet resource. For more information on the EC2 scenario options, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported platforms</a> in the <i>Amazon EC2 User
        /// Guide</i>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>EC2-Classic-InstanceStore</b>
        /// </p>
        /// <p>instance, image, security-group</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>EC2-Classic-EBS</b>
        /// </p>
        /// <p>instance, image, security-group, volume</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>EC2-VPC-InstanceStore</b>
        /// </p>
        /// <p>instance, image, security-group, network-interface</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>EC2-VPC-InstanceStore-Subnet</b>
        /// </p>
        /// <p>instance, image, security-group, network-interface, subnet</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>EC2-VPC-EBS</b>
        /// </p>
        /// <p>instance, image, security-group, network-interface, volume</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>EC2-VPC-EBS-Subnet</b>
        /// </p>
        /// <p>instance, image, security-group, network-interface, subnet, volume</p>
        /// </li>
        /// </ul>
        pub fn set_resource_handling_option(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_handling_option(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SimulatePrincipalPolicy`.
    ///
    /// <p>Simulate how a set of IAM policies attached to an IAM entity works with a list of
    /// API operations and Amazon Web Services resources to determine the policies' effective permissions. The
    /// entity can be an IAM user, group, or role. If you specify a user, then the simulation
    /// also includes all of the policies that are attached to groups that the user belongs to.
    /// You can simulate resources that don't exist in your account.</p>
    /// <p>You can optionally include a list of one or more additional policies specified as
    /// strings to include in the simulation. If you want to simulate only policies specified as
    /// strings, use <a>SimulateCustomPolicy</a> instead.</p>
    /// <p>You can also optionally include one resource-based policy to be evaluated with each of
    /// the resources included in the simulation.</p>
    /// <p>The simulation does not perform the API operations; it only checks the authorization
    /// to determine if the simulated policies allow or deny the operations.</p>
    /// <p>
    /// <b>Note:</b> This operation discloses information about the
    /// permissions granted to other users. If you do not want users to see other user's
    /// permissions, then consider allowing them to use <a>SimulateCustomPolicy</a>
    /// instead.</p>
    /// <p>Context keys are variables maintained by Amazon Web Services and its services that provide details
    /// about the context of an API query request. You can use the <code>Condition</code>
    /// element of an IAM policy to evaluate context keys. To get the list of context keys
    /// that the policies require for correct simulation, use <a>GetContextKeysForPrincipalPolicy</a>.</p>
    /// <p>If the output is long, you can use the <code>MaxItems</code> and <code>Marker</code>
    /// parameters to paginate the results.</p>
    /// <p>For more information about using the policy simulator, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_testing-policies.html">Testing IAM policies
    /// with the IAM policy simulator </a>in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct SimulatePrincipalPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::simulate_principal_policy_input::Builder,
    }
    impl<C, M, R> SimulatePrincipalPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SimulatePrincipalPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SimulatePrincipalPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::SimulatePrincipalPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SimulatePrincipalPolicyInputOperationOutputAlias,
                crate::output::SimulatePrincipalPolicyOutput,
                crate::error::SimulatePrincipalPolicyError,
                crate::input::SimulatePrincipalPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of a user, group, or role whose policies you want to
        /// include in the simulation. If you specify a user, group, or role, the simulation
        /// includes all policies that are associated with that entity. If you specify a user, the
        /// simulation also includes all policies that are attached to any groups the user belongs
        /// to.</p>
        /// <p>The maximum length of the policy document that you can pass in this operation,
        /// including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length">IAM and STS character quotas</a>.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn policy_source_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_source_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a user, group, or role whose policies you want to
        /// include in the simulation. If you specify a user, group, or role, the simulation
        /// includes all policies that are associated with that entity. If you specify a user, the
        /// simulation also includes all policies that are attached to any groups the user belongs
        /// to.</p>
        /// <p>The maximum length of the policy document that you can pass in this operation,
        /// including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length">IAM and STS character quotas</a>.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_policy_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_source_arn(input);
            self
        }
        /// Appends an item to `PolicyInputList`.
        ///
        /// To override the contents of this collection use [`set_policy_input_list`](Self::set_policy_input_list).
        ///
        /// <p>An optional list of additional policy documents to include in the simulation. Each
        /// document is specified as a string containing the complete, valid JSON text of an IAM
        /// policy.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn policy_input_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_input_list(inp);
            self
        }
        /// <p>An optional list of additional policy documents to include in the simulation. Each
        /// document is specified as a string containing the complete, valid JSON text of an IAM
        /// policy.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn set_policy_input_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_policy_input_list(input);
            self
        }
        /// Appends an item to `PermissionsBoundaryPolicyInputList`.
        ///
        /// To override the contents of this collection use [`set_permissions_boundary_policy_input_list`](Self::set_permissions_boundary_policy_input_list).
        ///
        /// <p>The IAM permissions boundary policy to simulate. The permissions boundary sets the
        /// maximum permissions that the entity can have. You can input only one permissions
        /// boundary when you pass a policy to this operation. An IAM entity can only have one
        /// permissions boundary in effect at a time. For example, if a permissions boundary is
        /// attached to an entity and you pass in a different permissions boundary policy using this
        /// parameter, then the new permissions boundary policy is used for the simulation. For more
        /// information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
        /// entities</a> in the <i>IAM User Guide</i>. The policy input is
        /// specified as a string containing the complete, valid JSON text of a permissions boundary
        /// policy.</p>
        /// <p>The maximum length of the policy document that you can pass in this operation,
        /// including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length">IAM and STS character quotas</a>.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn permissions_boundary_policy_input_list(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.permissions_boundary_policy_input_list(inp);
            self
        }
        /// <p>The IAM permissions boundary policy to simulate. The permissions boundary sets the
        /// maximum permissions that the entity can have. You can input only one permissions
        /// boundary when you pass a policy to this operation. An IAM entity can only have one
        /// permissions boundary in effect at a time. For example, if a permissions boundary is
        /// attached to an entity and you pass in a different permissions boundary policy using this
        /// parameter, then the new permissions boundary policy is used for the simulation. For more
        /// information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
        /// entities</a> in the <i>IAM User Guide</i>. The policy input is
        /// specified as a string containing the complete, valid JSON text of a permissions boundary
        /// policy.</p>
        /// <p>The maximum length of the policy document that you can pass in this operation,
        /// including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length">IAM and STS character quotas</a>.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn set_permissions_boundary_policy_input_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_permissions_boundary_policy_input_list(input);
            self
        }
        /// Appends an item to `ActionNames`.
        ///
        /// To override the contents of this collection use [`set_action_names`](Self::set_action_names).
        ///
        /// <p>A list of names of API operations to evaluate in the simulation. Each operation is
        /// evaluated for each resource. Each operation must include the service identifier, such as
        /// <code>iam:CreateUser</code>.</p>
        pub fn action_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_names(inp);
            self
        }
        /// <p>A list of names of API operations to evaluate in the simulation. Each operation is
        /// evaluated for each resource. Each operation must include the service identifier, such as
        /// <code>iam:CreateUser</code>.</p>
        pub fn set_action_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_action_names(input);
            self
        }
        /// Appends an item to `ResourceArns`.
        ///
        /// To override the contents of this collection use [`set_resource_arns`](Self::set_resource_arns).
        ///
        /// <p>A list of ARNs of Amazon Web Services resources to include in the simulation. If this parameter is
        /// not provided, then the value defaults to <code>*</code> (all resources). Each API in the
        /// <code>ActionNames</code> parameter is evaluated for each resource in this list. The
        /// simulation determines the access result (allowed or denied) of each combination and
        /// reports it in the response. You can simulate resources that don't exist in your
        /// account.</p>
        /// <p>The simulation does not automatically retrieve policies for the specified resources.
        /// If you want to include a resource policy in the simulation, then you must include the
        /// policy as a string in the <code>ResourcePolicy</code> parameter.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn resource_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arns(inp);
            self
        }
        /// <p>A list of ARNs of Amazon Web Services resources to include in the simulation. If this parameter is
        /// not provided, then the value defaults to <code>*</code> (all resources). Each API in the
        /// <code>ActionNames</code> parameter is evaluated for each resource in this list. The
        /// simulation determines the access result (allowed or denied) of each combination and
        /// reports it in the response. You can simulate resources that don't exist in your
        /// account.</p>
        /// <p>The simulation does not automatically retrieve policies for the specified resources.
        /// If you want to include a resource policy in the simulation, then you must include the
        /// policy as a string in the <code>ResourcePolicy</code> parameter.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_resource_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_arns(input);
            self
        }
        /// <p>A resource-based policy to include in the simulation provided as a string. Each
        /// resource in the simulation is treated as if it had this policy attached. You can include
        /// only one resource-based policy in a simulation.</p>
        /// <p>The maximum length of the policy document that you can pass in this operation,
        /// including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length">IAM and STS character quotas</a>.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn resource_policy(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_policy(inp);
            self
        }
        /// <p>A resource-based policy to include in the simulation provided as a string. Each
        /// resource in the simulation is treated as if it had this policy attached. You can include
        /// only one resource-based policy in a simulation.</p>
        /// <p>The maximum length of the policy document that you can pass in this operation,
        /// including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length">IAM and STS character quotas</a>.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn set_resource_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_policy(input);
            self
        }
        /// <p>An Amazon Web Services account ID that specifies the owner of any simulated resource that does not
        /// identify its owner in the resource ARN. Examples of resource ARNs include an S3 bucket
        /// or object. If <code>ResourceOwner</code> is specified, it is also used as the account
        /// owner of any <code>ResourcePolicy</code> included in the simulation. If the
        /// <code>ResourceOwner</code> parameter is not specified, then the owner of the
        /// resources and the resource policy defaults to the account of the identity provided in
        /// <code>CallerArn</code>. This parameter is required only if you specify a
        /// resource-based policy and account that owns the resource is different from the account
        /// that owns the simulated calling user <code>CallerArn</code>.</p>
        pub fn resource_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_owner(inp);
            self
        }
        /// <p>An Amazon Web Services account ID that specifies the owner of any simulated resource that does not
        /// identify its owner in the resource ARN. Examples of resource ARNs include an S3 bucket
        /// or object. If <code>ResourceOwner</code> is specified, it is also used as the account
        /// owner of any <code>ResourcePolicy</code> included in the simulation. If the
        /// <code>ResourceOwner</code> parameter is not specified, then the owner of the
        /// resources and the resource policy defaults to the account of the identity provided in
        /// <code>CallerArn</code>. This parameter is required only if you specify a
        /// resource-based policy and account that owns the resource is different from the account
        /// that owns the simulated calling user <code>CallerArn</code>.</p>
        pub fn set_resource_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_owner(input);
            self
        }
        /// <p>The ARN of the IAM user that you want to specify as the simulated caller of the API
        /// operations. If you do not specify a <code>CallerArn</code>, it defaults to the ARN of
        /// the user that you specify in <code>PolicySourceArn</code>, if you specified a user. If
        /// you include both a <code>PolicySourceArn</code> (for example,
        /// <code>arn:aws:iam::123456789012:user/David</code>) and a <code>CallerArn</code> (for
        /// example, <code>arn:aws:iam::123456789012:user/Bob</code>), the result is that you
        /// simulate calling the API operations as Bob, as if Bob had David's policies.</p>
        /// <p>You can specify only the ARN of an IAM user. You cannot specify the ARN of an
        /// assumed role, federated user, or a service principal.</p>
        /// <p>
        /// <code>CallerArn</code> is required if you include a <code>ResourcePolicy</code> and
        /// the <code>PolicySourceArn</code> is not the ARN for an IAM user. This is required so
        /// that the resource-based policy's <code>Principal</code> element has a value to use in
        /// evaluating the policy.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn caller_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.caller_arn(inp);
            self
        }
        /// <p>The ARN of the IAM user that you want to specify as the simulated caller of the API
        /// operations. If you do not specify a <code>CallerArn</code>, it defaults to the ARN of
        /// the user that you specify in <code>PolicySourceArn</code>, if you specified a user. If
        /// you include both a <code>PolicySourceArn</code> (for example,
        /// <code>arn:aws:iam::123456789012:user/David</code>) and a <code>CallerArn</code> (for
        /// example, <code>arn:aws:iam::123456789012:user/Bob</code>), the result is that you
        /// simulate calling the API operations as Bob, as if Bob had David's policies.</p>
        /// <p>You can specify only the ARN of an IAM user. You cannot specify the ARN of an
        /// assumed role, federated user, or a service principal.</p>
        /// <p>
        /// <code>CallerArn</code> is required if you include a <code>ResourcePolicy</code> and
        /// the <code>PolicySourceArn</code> is not the ARN for an IAM user. This is required so
        /// that the resource-based policy's <code>Principal</code> element has a value to use in
        /// evaluating the policy.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_caller_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_caller_arn(input);
            self
        }
        /// Appends an item to `ContextEntries`.
        ///
        /// To override the contents of this collection use [`set_context_entries`](Self::set_context_entries).
        ///
        /// <p>A list of context keys and corresponding values for the simulation to use. Whenever a
        /// context key is evaluated in one of the simulated IAM permissions policies, the
        /// corresponding value is supplied.</p>
        pub fn context_entries(mut self, inp: impl Into<crate::model::ContextEntry>) -> Self {
            self.inner = self.inner.context_entries(inp);
            self
        }
        /// <p>A list of context keys and corresponding values for the simulation to use. Whenever a
        /// context key is evaluated in one of the simulated IAM permissions policies, the
        /// corresponding value is supplied.</p>
        pub fn set_context_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContextEntry>>,
        ) -> Self {
            self.inner = self.inner.set_context_entries(input);
            self
        }
        /// <p>Specifies the type of simulation to run. Different API operations that support
        /// resource-based policies require different combinations of resources. By specifying the
        /// type of simulation to run, you enable the policy simulator to enforce the presence of
        /// the required resources to ensure reliable simulation results. If your simulation does
        /// not match one of the following scenarios, then you can omit this parameter. The
        /// following list shows each of the supported scenario values and the resources that you
        /// must define to run the simulation.</p>
        /// <p>Each of the EC2 scenarios requires that you specify instance, image, and security
        /// group resources. If your scenario includes an EBS volume, then you must specify that
        /// volume as a resource. If the EC2 scenario includes VPC, then you must supply the network
        /// interface resource. If it includes an IP subnet, then you must specify the subnet
        /// resource. For more information on the EC2 scenario options, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported platforms</a> in the <i>Amazon EC2 User
        /// Guide</i>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>EC2-Classic-InstanceStore</b>
        /// </p>
        /// <p>instance, image, security group</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>EC2-Classic-EBS</b>
        /// </p>
        /// <p>instance, image, security group, volume</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>EC2-VPC-InstanceStore</b>
        /// </p>
        /// <p>instance, image, security group, network interface</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>EC2-VPC-InstanceStore-Subnet</b>
        /// </p>
        /// <p>instance, image, security group, network interface, subnet</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>EC2-VPC-EBS</b>
        /// </p>
        /// <p>instance, image, security group, network interface, volume</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>EC2-VPC-EBS-Subnet</b>
        /// </p>
        /// <p>instance, image, security group, network interface, subnet, volume</p>
        /// </li>
        /// </ul>
        pub fn resource_handling_option(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_handling_option(inp);
            self
        }
        /// <p>Specifies the type of simulation to run. Different API operations that support
        /// resource-based policies require different combinations of resources. By specifying the
        /// type of simulation to run, you enable the policy simulator to enforce the presence of
        /// the required resources to ensure reliable simulation results. If your simulation does
        /// not match one of the following scenarios, then you can omit this parameter. The
        /// following list shows each of the supported scenario values and the resources that you
        /// must define to run the simulation.</p>
        /// <p>Each of the EC2 scenarios requires that you specify instance, image, and security
        /// group resources. If your scenario includes an EBS volume, then you must specify that
        /// volume as a resource. If the EC2 scenario includes VPC, then you must supply the network
        /// interface resource. If it includes an IP subnet, then you must specify the subnet
        /// resource. For more information on the EC2 scenario options, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported platforms</a> in the <i>Amazon EC2 User
        /// Guide</i>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>EC2-Classic-InstanceStore</b>
        /// </p>
        /// <p>instance, image, security group</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>EC2-Classic-EBS</b>
        /// </p>
        /// <p>instance, image, security group, volume</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>EC2-VPC-InstanceStore</b>
        /// </p>
        /// <p>instance, image, security group, network interface</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>EC2-VPC-InstanceStore-Subnet</b>
        /// </p>
        /// <p>instance, image, security group, network interface, subnet</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>EC2-VPC-EBS</b>
        /// </p>
        /// <p>instance, image, security group, network interface, volume</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>EC2-VPC-EBS-Subnet</b>
        /// </p>
        /// <p>instance, image, security group, network interface, subnet, volume</p>
        /// </li>
        /// </ul>
        pub fn set_resource_handling_option(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_handling_option(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_items(inp);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_items(input);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagInstanceProfile`.
    ///
    /// <p>Adds one or more tags to an IAM instance profile. If a tag with the same key name
    /// already exists, then that tag is overwritten with the new value.</p>
    /// <p>Each tag consists of a key name and an associated value. By assigning tags to your resources, you can do the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Administrative grouping and discovery</b> - Attach
    /// tags to resources to aid in organization and search. For example, you could search for all
    /// resources with the key name <i>Project</i> and the value
    /// <i>MyImportantProject</i>. Or search for all resources with the key name
    /// <i>Cost Center</i> and the value <i>41200</i>. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Access control</b> - Include tags in IAM user-based
    /// and resource-based policies. You can use tags to restrict access to only an IAM instance
    /// profile that has a specified tag attached. For examples of policies that show how to use
    /// tags to control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access using IAM tags</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <ul>
    /// <li>
    /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
    /// fails and the resource is not created. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services always interprets the tag <code>Value</code> as a single string. If you
    /// need to store an array, you can store comma-separated values in the string. However, you
    /// must interpret the value in your code.</p>
    /// </li>
    /// </ul>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct TagInstanceProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_instance_profile_input::Builder,
    }
    impl<C, M, R> TagInstanceProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagInstanceProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagInstanceProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::TagInstanceProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagInstanceProfileInputOperationOutputAlias,
                crate::output::TagInstanceProfileOutput,
                crate::error::TagInstanceProfileError,
                crate::input::TagInstanceProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IAM instance profile to which you want to add tags.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn instance_profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_profile_name(inp);
            self
        }
        /// <p>The name of the IAM instance profile to which you want to add tags.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_instance_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_profile_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags that you want to attach to the IAM instance profile.
        /// Each tag consists of a key name and an associated value.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The list of tags that you want to attach to the IAM instance profile.
        /// Each tag consists of a key name and an associated value.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagMFADevice`.
    ///
    /// <p>Adds one or more tags to an IAM virtual multi-factor authentication (MFA) device. If
    /// a tag with the same key name already exists, then that tag is overwritten with the new
    /// value.</p>
    /// <p>A tag consists of a key name and an associated value. By assigning tags to your
    /// resources, you can do the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Administrative grouping and discovery</b> - Attach
    /// tags to resources to aid in organization and search. For example, you could search for all
    /// resources with the key name <i>Project</i> and the value
    /// <i>MyImportantProject</i>. Or search for all resources with the key name
    /// <i>Cost Center</i> and the value <i>41200</i>. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Access control</b> - Include tags in IAM user-based
    /// and resource-based policies. You can use tags to restrict access to only an IAM virtual
    /// MFA device that has a specified tag attached. For examples of policies that show how to
    /// use tags to control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access using IAM tags</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <ul>
    /// <li>
    /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
    /// fails and the resource is not created. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services always interprets the tag <code>Value</code> as a single string. If you
    /// need to store an array, you can store comma-separated values in the string. However, you
    /// must interpret the value in your code.</p>
    /// </li>
    /// </ul>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct TagMFADevice<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_mfa_device_input::Builder,
    }
    impl<C, M, R> TagMFADevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagMFADevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagMfaDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagMFADeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagMfaDeviceInputOperationOutputAlias,
                crate::output::TagMfaDeviceOutput,
                crate::error::TagMFADeviceError,
                crate::input::TagMfaDeviceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the IAM virtual MFA device to which you want to add tags.
        /// For virtual MFA devices, the serial number is the same as the ARN.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn serial_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.serial_number(inp);
            self
        }
        /// <p>The unique identifier for the IAM virtual MFA device to which you want to add tags.
        /// For virtual MFA devices, the serial number is the same as the ARN.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_serial_number(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags that you want to attach to the IAM virtual MFA device.
        /// Each tag consists of a key name and an associated value.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The list of tags that you want to attach to the IAM virtual MFA device.
        /// Each tag consists of a key name and an associated value.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagOpenIDConnectProvider`.
    ///
    /// <p>Adds one or more tags to an OpenID Connect (OIDC)-compatible identity provider. For
    /// more information about these providers, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html">About web identity federation</a>. If
    /// a tag with the same key name already exists, then that tag is overwritten with the new
    /// value.</p>
    /// <p>A tag consists of a key name and an associated value. By assigning tags to your
    /// resources, you can do the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Administrative grouping and discovery</b> - Attach
    /// tags to resources to aid in organization and search. For example, you could search for all
    /// resources with the key name <i>Project</i> and the value
    /// <i>MyImportantProject</i>. Or search for all resources with the key name
    /// <i>Cost Center</i> and the value <i>41200</i>. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Access control</b> - Include tags in IAM user-based
    /// and resource-based policies. You can use tags to restrict access to only an OIDC provider
    /// that has a specified tag attached. For examples of policies that show how to use tags to
    /// control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access using IAM tags</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <ul>
    /// <li>
    /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
    /// fails and the resource is not created. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services always interprets the tag <code>Value</code> as a single string. If you
    /// need to store an array, you can store comma-separated values in the string. However, you
    /// must interpret the value in your code.</p>
    /// </li>
    /// </ul>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct TagOpenIDConnectProvider<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_open_id_connect_provider_input::Builder,
    }
    impl<C, M, R> TagOpenIDConnectProvider<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagOpenIDConnectProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagOpenIdConnectProviderOutput,
            aws_smithy_http::result::SdkError<crate::error::TagOpenIDConnectProviderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagOpenIdConnectProviderInputOperationOutputAlias,
                crate::output::TagOpenIdConnectProviderOutput,
                crate::error::TagOpenIDConnectProviderError,
                crate::input::TagOpenIdConnectProviderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the OIDC identity provider in IAM to which you want to add tags.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn open_id_connect_provider_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.open_id_connect_provider_arn(inp);
            self
        }
        /// <p>The ARN of the OIDC identity provider in IAM to which you want to add tags.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_open_id_connect_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_open_id_connect_provider_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags that you want to attach to the OIDC identity provider in IAM.
        /// Each tag consists of a key name and an associated value.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The list of tags that you want to attach to the OIDC identity provider in IAM.
        /// Each tag consists of a key name and an associated value.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagPolicy`.
    ///
    /// <p>Adds one or more tags to an IAM customer managed policy. If a tag with the same key
    /// name already exists, then that tag is overwritten with the new value.</p>
    /// <p>A tag consists of a key name and an associated value. By assigning tags to your
    /// resources, you can do the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Administrative grouping and discovery</b> - Attach
    /// tags to resources to aid in organization and search. For example, you could search for all
    /// resources with the key name <i>Project</i> and the value
    /// <i>MyImportantProject</i>. Or search for all resources with the key name
    /// <i>Cost Center</i> and the value <i>41200</i>. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Access control</b> - Include tags in IAM user-based
    /// and resource-based policies. You can use tags to restrict access to only an IAM customer
    /// managed policy that has a specified tag attached. For examples of policies that show how
    /// to use tags to control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access using IAM tags</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <ul>
    /// <li>
    /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
    /// fails and the resource is not created. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services always interprets the tag <code>Value</code> as a single string. If you
    /// need to store an array, you can store comma-separated values in the string. However, you
    /// must interpret the value in your code.</p>
    /// </li>
    /// </ul>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct TagPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_policy_input::Builder,
    }
    impl<C, M, R> TagPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::TagPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagPolicyInputOperationOutputAlias,
                crate::output::TagPolicyOutput,
                crate::error::TagPolicyError,
                crate::input::TagPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the IAM customer managed policy to which you want to add tags.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn policy_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_arn(inp);
            self
        }
        /// <p>The ARN of the IAM customer managed policy to which you want to add tags.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags that you want to attach to the IAM customer managed policy.
        /// Each tag consists of a key name and an associated value.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The list of tags that you want to attach to the IAM customer managed policy.
        /// Each tag consists of a key name and an associated value.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagRole`.
    ///
    /// <p>Adds one or more tags to an IAM role. The role can be a regular role or a
    /// service-linked role. If a tag with the same key name already exists, then that tag is
    /// overwritten with the new value.</p>
    /// <p>A tag consists of a key name and an associated value. By assigning tags to your
    /// resources, you can do the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Administrative grouping and discovery</b> - Attach
    /// tags to resources to aid in organization and search. For example, you could search for all
    /// resources with the key name <i>Project</i> and the value
    /// <i>MyImportantProject</i>. Or search for all resources with the key name
    /// <i>Cost Center</i> and the value <i>41200</i>. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Access control</b> - Include tags in IAM user-based
    /// and resource-based policies. You can use tags to restrict access to only an IAM role
    /// that has a specified tag attached. You can also restrict access to only those resources
    /// that have a certain tag attached. For examples of policies that show how to use tags to
    /// control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access using IAM tags</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Cost allocation</b> - Use tags to help track which
    /// individuals and teams are using which Amazon Web Services resources.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <ul>
    /// <li>
    /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
    /// fails and the resource is not created. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services always interprets the tag <code>Value</code> as a single string. If you
    /// need to store an array, you can store comma-separated values in the string. However, you
    /// must interpret the value in your code.</p>
    /// </li>
    /// </ul>
    /// </note>
    /// <p>For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM identities</a> in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagRole<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_role_input::Builder,
    }
    impl<C, M, R> TagRole<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagRole`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagRoleOutput,
            aws_smithy_http::result::SdkError<crate::error::TagRoleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagRoleInputOperationOutputAlias,
                crate::output::TagRoleOutput,
                crate::error::TagRoleError,
                crate::input::TagRoleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IAM role to which you want to add tags.</p>
        /// <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_name(inp);
            self
        }
        /// <p>The name of the IAM role to which you want to add tags.</p>
        /// <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags that you want to attach to the IAM role. Each tag consists of a key name and an associated value.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The list of tags that you want to attach to the IAM role. Each tag consists of a key name and an associated value.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagSAMLProvider`.
    ///
    /// <p>Adds one or more tags to a Security Assertion Markup Language (SAML) identity provider.
    /// For more information about these providers, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html">About SAML 2.0-based federation </a>.
    /// If a tag with the same key name already exists, then that tag is overwritten with the new
    /// value.</p>
    /// <p>A tag consists of a key name and an associated value. By assigning tags to your
    /// resources, you can do the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Administrative grouping and discovery</b> - Attach
    /// tags to resources to aid in organization and search. For example, you could search for all
    /// resources with the key name <i>Project</i> and the value
    /// <i>MyImportantProject</i>. Or search for all resources with the key name
    /// <i>Cost Center</i> and the value <i>41200</i>. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Access control</b> - Include tags in IAM user-based
    /// and resource-based policies. You can use tags to restrict access to only a SAML identity
    /// provider that has a specified tag attached. For examples of policies that show how to use
    /// tags to control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access using IAM tags</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <ul>
    /// <li>
    /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
    /// fails and the resource is not created. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services always interprets the tag <code>Value</code> as a single string. If you
    /// need to store an array, you can store comma-separated values in the string. However, you
    /// must interpret the value in your code.</p>
    /// </li>
    /// </ul>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct TagSAMLProvider<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_saml_provider_input::Builder,
    }
    impl<C, M, R> TagSAMLProvider<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagSAMLProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagSamlProviderOutput,
            aws_smithy_http::result::SdkError<crate::error::TagSAMLProviderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagSamlProviderInputOperationOutputAlias,
                crate::output::TagSamlProviderOutput,
                crate::error::TagSAMLProviderError,
                crate::input::TagSamlProviderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SAML identity provider in IAM to which you want to add tags.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn saml_provider_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.saml_provider_arn(inp);
            self
        }
        /// <p>The ARN of the SAML identity provider in IAM to which you want to add tags.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_saml_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_saml_provider_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags that you want to attach to the SAML identity provider in IAM.
        /// Each tag consists of a key name and an associated value.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The list of tags that you want to attach to the SAML identity provider in IAM.
        /// Each tag consists of a key name and an associated value.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagServerCertificate`.
    ///
    /// <p>Adds one or more tags to an IAM server certificate. If a tag with the same key name
    /// already exists, then that tag is overwritten with the new value.</p>
    /// <note>
    /// <p>For certificates in a Region supported by Certificate Manager (ACM), we
    /// recommend that you don't use IAM server certificates. Instead, use ACM to provision,
    /// manage, and deploy your server certificates. For more information about IAM server
    /// certificates, <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
    /// certificates</a> in the <i>IAM User Guide</i>.</p>
    /// </note>
    /// <p>A tag consists of a key name and an associated value. By assigning tags to your
    /// resources, you can do the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Administrative grouping and discovery</b> - Attach
    /// tags to resources to aid in organization and search. For example, you could search for all
    /// resources with the key name <i>Project</i> and the value
    /// <i>MyImportantProject</i>. Or search for all resources with the key name
    /// <i>Cost Center</i> and the value <i>41200</i>. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Access control</b> - Include tags in IAM user-based
    /// and resource-based policies. You can use tags to restrict access to only a server
    /// certificate that has a specified tag attached. For examples of policies that show how to
    /// use tags to control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access using IAM tags</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Cost allocation</b> - Use tags to help track which
    /// individuals and teams are using which Amazon Web Services resources.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <ul>
    /// <li>
    /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
    /// fails and the resource is not created. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services always interprets the tag <code>Value</code> as a single string. If you
    /// need to store an array, you can store comma-separated values in the string. However, you
    /// must interpret the value in your code.</p>
    /// </li>
    /// </ul>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct TagServerCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_server_certificate_input::Builder,
    }
    impl<C, M, R> TagServerCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagServerCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagServerCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::TagServerCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagServerCertificateInputOperationOutputAlias,
                crate::output::TagServerCertificateOutput,
                crate::error::TagServerCertificateError,
                crate::input::TagServerCertificateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IAM server certificate to which you want to add tags.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn server_certificate_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_certificate_name(inp);
            self
        }
        /// <p>The name of the IAM server certificate to which you want to add tags.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_server_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_server_certificate_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags that you want to attach to the IAM server certificate.
        /// Each tag consists of a key name and an associated value.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The list of tags that you want to attach to the IAM server certificate.
        /// Each tag consists of a key name and an associated value.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagUser`.
    ///
    /// <p>Adds one or more tags to an IAM user. If a tag with the same key name already exists,
    /// then that tag is overwritten with the new value.</p>
    /// <p>A tag consists of a key name and an associated value. By assigning tags to your
    /// resources, you can do the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Administrative grouping and discovery</b> - Attach
    /// tags to resources to aid in organization and search. For example, you could search for all
    /// resources with the key name <i>Project</i> and the value
    /// <i>MyImportantProject</i>. Or search for all resources with the key name
    /// <i>Cost Center</i> and the value <i>41200</i>. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Access control</b> - Include tags in IAM user-based
    /// and resource-based policies. You can use tags to restrict access to only an IAM
    /// requesting user that has a specified tag attached. You can also restrict access to only
    /// those resources that have a certain tag attached. For examples of policies that show how
    /// to use tags to control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control access using IAM tags</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>Cost allocation</b> - Use tags to help track which
    /// individuals and teams are using which Amazon Web Services resources.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <ul>
    /// <li>
    /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
    /// fails and the resource is not created. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// </li>
    /// <li>
    /// <p>Amazon Web Services always interprets the tag <code>Value</code> as a single string. If you
    /// need to store an array, you can store comma-separated values in the string. However, you
    /// must interpret the value in your code.</p>
    /// </li>
    /// </ul>
    /// </note>
    /// <p>For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM identities</a> in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_user_input::Builder,
    }
    impl<C, M, R> TagUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagUserOutput,
            aws_smithy_http::result::SdkError<crate::error::TagUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagUserInputOperationOutputAlias,
                crate::output::TagUserOutput,
                crate::error::TagUserError,
                crate::input::TagUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IAM user to which you want to add tags.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the IAM user to which you want to add tags.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags that you want to attach to the IAM user. Each tag consists of a key name and an associated value.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The list of tags that you want to attach to the IAM user. Each tag consists of a key name and an associated value.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagInstanceProfile`.
    ///
    /// <p>Removes the specified tags from the IAM instance profile. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagInstanceProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_instance_profile_input::Builder,
    }
    impl<C, M, R> UntagInstanceProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagInstanceProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagInstanceProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagInstanceProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagInstanceProfileInputOperationOutputAlias,
                crate::output::UntagInstanceProfileOutput,
                crate::error::UntagInstanceProfileError,
                crate::input::UntagInstanceProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IAM instance profile from which you want to remove tags.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn instance_profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_profile_name(inp);
            self
        }
        /// <p>The name of the IAM instance profile from which you want to remove tags.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_instance_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_profile_name(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of key names as a simple array of strings. The tags with matching keys are
        /// removed from the specified instance profile.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A list of key names as a simple array of strings. The tags with matching keys are
        /// removed from the specified instance profile.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagMFADevice`.
    ///
    /// <p>Removes the specified tags from the IAM virtual multi-factor authentication (MFA)
    /// device. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagMFADevice<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_mfa_device_input::Builder,
    }
    impl<C, M, R> UntagMFADevice<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagMFADevice`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagMfaDeviceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagMFADeviceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagMfaDeviceInputOperationOutputAlias,
                crate::output::UntagMfaDeviceOutput,
                crate::error::UntagMFADeviceError,
                crate::input::UntagMfaDeviceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the IAM virtual MFA device from which you want to remove
        /// tags. For virtual MFA devices, the serial number is the same as the ARN.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn serial_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.serial_number(inp);
            self
        }
        /// <p>The unique identifier for the IAM virtual MFA device from which you want to remove
        /// tags. For virtual MFA devices, the serial number is the same as the ARN.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_serial_number(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of key names as a simple array of strings. The tags with matching keys are
        /// removed from the specified instance profile.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A list of key names as a simple array of strings. The tags with matching keys are
        /// removed from the specified instance profile.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagOpenIDConnectProvider`.
    ///
    /// <p>Removes the specified tags from the specified OpenID Connect (OIDC)-compatible identity
    /// provider in IAM. For more information about OIDC providers, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html">About web identity federation</a>.
    /// For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagOpenIDConnectProvider<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_open_id_connect_provider_input::Builder,
    }
    impl<C, M, R> UntagOpenIDConnectProvider<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagOpenIDConnectProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagOpenIdConnectProviderOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagOpenIDConnectProviderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagOpenIdConnectProviderInputOperationOutputAlias,
                crate::output::UntagOpenIdConnectProviderOutput,
                crate::error::UntagOpenIDConnectProviderError,
                crate::input::UntagOpenIdConnectProviderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the OIDC provider in IAM from which you want to remove tags.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn open_id_connect_provider_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.open_id_connect_provider_arn(inp);
            self
        }
        /// <p>The ARN of the OIDC provider in IAM from which you want to remove tags.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_open_id_connect_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_open_id_connect_provider_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of key names as a simple array of strings. The tags with matching keys are
        /// removed from the specified OIDC provider.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A list of key names as a simple array of strings. The tags with matching keys are
        /// removed from the specified OIDC provider.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagPolicy`.
    ///
    /// <p>Removes the specified tags from the customer managed policy. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_policy_input::Builder,
    }
    impl<C, M, R> UntagPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagPolicyInputOperationOutputAlias,
                crate::output::UntagPolicyOutput,
                crate::error::UntagPolicyError,
                crate::input::UntagPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the IAM customer managed policy from which you want to remove
        /// tags.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn policy_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_arn(inp);
            self
        }
        /// <p>The ARN of the IAM customer managed policy from which you want to remove
        /// tags.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of key names as a simple array of strings. The tags with matching keys are
        /// removed from the specified policy.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A list of key names as a simple array of strings. The tags with matching keys are
        /// removed from the specified policy.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagRole`.
    ///
    /// <p>Removes the specified tags from the role. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagRole<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_role_input::Builder,
    }
    impl<C, M, R> UntagRole<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagRole`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagRoleOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagRoleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagRoleInputOperationOutputAlias,
                crate::output::UntagRoleOutput,
                crate::error::UntagRoleError,
                crate::input::UntagRoleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IAM role from which you want to remove tags.</p>
        /// <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn role_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_name(inp);
            self
        }
        /// <p>The name of the IAM role from which you want to remove tags.</p>
        /// <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_name(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of key names as a simple array of strings. The tags with matching keys are
        /// removed from the specified role.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A list of key names as a simple array of strings. The tags with matching keys are
        /// removed from the specified role.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagSAMLProvider`.
    ///
    /// <p>Removes the specified tags from the specified Security Assertion Markup Language (SAML)
    /// identity provider in IAM. For more information about these providers, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html">About web identity
    /// federation</a>. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagSAMLProvider<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_saml_provider_input::Builder,
    }
    impl<C, M, R> UntagSAMLProvider<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagSAMLProvider`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagSamlProviderOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagSAMLProviderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagSamlProviderInputOperationOutputAlias,
                crate::output::UntagSamlProviderOutput,
                crate::error::UntagSAMLProviderError,
                crate::input::UntagSamlProviderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the SAML identity provider in IAM from which you want to remove
        /// tags.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn saml_provider_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.saml_provider_arn(inp);
            self
        }
        /// <p>The ARN of the SAML identity provider in IAM from which you want to remove
        /// tags.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_saml_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_saml_provider_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of key names as a simple array of strings. The tags with matching keys are
        /// removed from the specified SAML identity provider.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A list of key names as a simple array of strings. The tags with matching keys are
        /// removed from the specified SAML identity provider.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagServerCertificate`.
    ///
    /// <p>Removes the specified tags from the IAM server certificate.
    /// For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// <note>
    /// <p>For certificates in a Region supported by Certificate Manager (ACM), we
    /// recommend that you don't use IAM server certificates. Instead, use ACM to provision,
    /// manage, and deploy your server certificates. For more information about IAM server
    /// certificates, <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with server
    /// certificates</a> in the <i>IAM User Guide</i>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct UntagServerCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_server_certificate_input::Builder,
    }
    impl<C, M, R> UntagServerCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagServerCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagServerCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagServerCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagServerCertificateInputOperationOutputAlias,
                crate::output::UntagServerCertificateOutput,
                crate::error::UntagServerCertificateError,
                crate::input::UntagServerCertificateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IAM server certificate from which you want to remove tags.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn server_certificate_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_certificate_name(inp);
            self
        }
        /// <p>The name of the IAM server certificate from which you want to remove tags.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_server_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_server_certificate_name(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of key names as a simple array of strings. The tags with matching keys are
        /// removed from the specified IAM server certificate.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A list of key names as a simple array of strings. The tags with matching keys are
        /// removed from the specified IAM server certificate.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagUser`.
    ///
    /// <p>Removes the specified tags from the user. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_user_input::Builder,
    }
    impl<C, M, R> UntagUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagUserOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagUserInputOperationOutputAlias,
                crate::output::UntagUserOutput,
                crate::error::UntagUserError,
                crate::input::UntagUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the IAM user from which you want to remove tags.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the IAM user from which you want to remove tags.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of key names as a simple array of strings. The tags with matching keys are
        /// removed from the specified user.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A list of key names as a simple array of strings. The tags with matching keys are
        /// removed from the specified user.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAccessKey`.
    ///
    /// <p>Changes the status of the specified access key from Active to Inactive, or vice versa.
    /// This operation can be used to disable a user's key as part of a key rotation
    /// workflow.</p>
    /// <p>If the <code>UserName</code> is not specified, the user name is determined implicitly
    /// based on the Amazon Web Services access key ID used to sign the request. This operation works for
    /// access keys under the Amazon Web Services account. Consequently, you can use this operation to manage
    /// Amazon Web Services account root user credentials even if the Amazon Web Services account has no associated
    /// users.</p>
    /// <p>For information about rotating keys, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/ManagingCredentials.html">Managing keys and certificates</a>
    /// in the <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAccessKey<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_access_key_input::Builder,
    }
    impl<C, M, R> UpdateAccessKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAccessKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAccessKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAccessKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAccessKeyInputOperationOutputAlias,
                crate::output::UpdateAccessKeyOutput,
                crate::error::UpdateAccessKeyError,
                crate::input::UpdateAccessKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user whose key you want to update.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The name of the user whose key you want to update.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The access key ID of the secret access key you want to update.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can
        /// consist of any upper or lowercased letter or digit.</p>
        pub fn access_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_key_id(inp);
            self
        }
        /// <p>The access key ID of the secret access key you want to update.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can
        /// consist of any upper or lowercased letter or digit.</p>
        pub fn set_access_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_key_id(input);
            self
        }
        /// <p> The status you want to assign to the secret access key. <code>Active</code> means
        /// that the key can be used for programmatic calls to Amazon Web Services, while <code>Inactive</code>
        /// means that the key cannot be used.</p>
        pub fn status(mut self, inp: crate::model::StatusType) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p> The status you want to assign to the secret access key. <code>Active</code> means
        /// that the key can be used for programmatic calls to Amazon Web Services, while <code>Inactive</code>
        /// means that the key cannot be used.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::StatusType>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAccountPasswordPolicy`.
    ///
    /// <p>Updates the password policy settings for the Amazon Web Services account.</p>
    /// <note>
    /// <ul>
    /// <li>
    /// <p>This operation does not support partial updates. No parameters are
    /// required, but if you do not specify a parameter, that parameter's value
    /// reverts to its default value. See the <b>Request
    /// Parameters</b> section for each parameter's default value. Also
    /// note that some parameters do not allow the default parameter to be
    /// explicitly set. Instead, to invoke the default value, do not include that
    /// parameter when you invoke the operation.</p>
    /// </li>
    /// </ul>
    /// </note>
    /// <p> For more information about using a password policy, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingPasswordPolicies.html">Managing an IAM password
    /// policy</a> in the <i>IAM User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAccountPasswordPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_account_password_policy_input::Builder,
    }
    impl<C, M, R> UpdateAccountPasswordPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAccountPasswordPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAccountPasswordPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAccountPasswordPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAccountPasswordPolicyInputOperationOutputAlias,
                crate::output::UpdateAccountPasswordPolicyOutput,
                crate::error::UpdateAccountPasswordPolicyError,
                crate::input::UpdateAccountPasswordPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The minimum number of characters allowed in an IAM user password.</p>
        /// <p>If you do not specify a value for this parameter, then the operation uses the default
        /// value of <code>6</code>.</p>
        pub fn minimum_password_length(mut self, inp: i32) -> Self {
            self.inner = self.inner.minimum_password_length(inp);
            self
        }
        /// <p>The minimum number of characters allowed in an IAM user password.</p>
        /// <p>If you do not specify a value for this parameter, then the operation uses the default
        /// value of <code>6</code>.</p>
        pub fn set_minimum_password_length(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_minimum_password_length(input);
            self
        }
        /// <p>Specifies whether IAM user passwords must contain at least one of the following
        /// non-alphanumeric characters:</p>
        /// <p>! @ # $ % ^ & * ( ) _ + - = [ ] { } | '</p>
        /// <p>If you do not specify a value for this parameter, then the operation uses the default
        /// value of <code>false</code>. The result is that passwords do not require at least one
        /// symbol character.</p>
        pub fn require_symbols(mut self, inp: bool) -> Self {
            self.inner = self.inner.require_symbols(inp);
            self
        }
        /// <p>Specifies whether IAM user passwords must contain at least one of the following
        /// non-alphanumeric characters:</p>
        /// <p>! @ # $ % ^ & * ( ) _ + - = [ ] { } | '</p>
        /// <p>If you do not specify a value for this parameter, then the operation uses the default
        /// value of <code>false</code>. The result is that passwords do not require at least one
        /// symbol character.</p>
        pub fn set_require_symbols(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_require_symbols(input);
            self
        }
        /// <p>Specifies whether IAM user passwords must contain at least one numeric character (0
        /// to 9).</p>
        /// <p>If you do not specify a value for this parameter, then the operation uses the default
        /// value of <code>false</code>. The result is that passwords do not require at least one
        /// numeric character.</p>
        pub fn require_numbers(mut self, inp: bool) -> Self {
            self.inner = self.inner.require_numbers(inp);
            self
        }
        /// <p>Specifies whether IAM user passwords must contain at least one numeric character (0
        /// to 9).</p>
        /// <p>If you do not specify a value for this parameter, then the operation uses the default
        /// value of <code>false</code>. The result is that passwords do not require at least one
        /// numeric character.</p>
        pub fn set_require_numbers(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_require_numbers(input);
            self
        }
        /// <p>Specifies whether IAM user passwords must contain at least one uppercase character
        /// from the ISO basic Latin alphabet (A to Z).</p>
        /// <p>If you do not specify a value for this parameter, then the operation uses the default
        /// value of <code>false</code>. The result is that passwords do not require at least one
        /// uppercase character.</p>
        pub fn require_uppercase_characters(mut self, inp: bool) -> Self {
            self.inner = self.inner.require_uppercase_characters(inp);
            self
        }
        /// <p>Specifies whether IAM user passwords must contain at least one uppercase character
        /// from the ISO basic Latin alphabet (A to Z).</p>
        /// <p>If you do not specify a value for this parameter, then the operation uses the default
        /// value of <code>false</code>. The result is that passwords do not require at least one
        /// uppercase character.</p>
        pub fn set_require_uppercase_characters(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_require_uppercase_characters(input);
            self
        }
        /// <p>Specifies whether IAM user passwords must contain at least one lowercase character
        /// from the ISO basic Latin alphabet (a to z).</p>
        /// <p>If you do not specify a value for this parameter, then the operation uses the default
        /// value of <code>false</code>. The result is that passwords do not require at least one
        /// lowercase character.</p>
        pub fn require_lowercase_characters(mut self, inp: bool) -> Self {
            self.inner = self.inner.require_lowercase_characters(inp);
            self
        }
        /// <p>Specifies whether IAM user passwords must contain at least one lowercase character
        /// from the ISO basic Latin alphabet (a to z).</p>
        /// <p>If you do not specify a value for this parameter, then the operation uses the default
        /// value of <code>false</code>. The result is that passwords do not require at least one
        /// lowercase character.</p>
        pub fn set_require_lowercase_characters(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_require_lowercase_characters(input);
            self
        }
        /// <p> Allows all IAM users in your account to use the Amazon Web Services Management Console to change their own
        /// passwords. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/HowToPwdIAMUser.html">Letting IAM users change their own
        /// passwords</a> in the <i>IAM User Guide</i>.</p>
        /// <p>If you do not specify a value for this parameter, then the operation uses the default
        /// value of <code>false</code>. The result is that IAM users in the account do