// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub fn parse_http_generic_error(
    response: &http::Response<bytes::Bytes>,
) -> Result<aws_smithy_types::Error, aws_smithy_xml::decode::XmlError> {
    crate::rest_xml_wrapped_errors::parse_generic_error(response.body().as_ref())
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_input_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_input_exception::Builder,
) -> Result<crate::error::invalid_input_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.iam#InvalidInputException$message */ =>  {
                let var_1 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_1);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_limit_exceeded_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::limit_exceeded_exception::Builder,
) -> Result<crate::error::limit_exceeded_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.iam#LimitExceededException$message */ =>  {
                let var_2 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_2);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_no_such_entity_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::no_such_entity_exception::Builder,
) -> Result<crate::error::no_such_entity_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.iam#NoSuchEntityException$message */ =>  {
                let var_3 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_3);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_service_failure_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::service_failure_exception::Builder,
) -> Result<crate::error::service_failure_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.iam#ServiceFailureException$message */ =>  {
                let var_4 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_4);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_entity_already_exists_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::entity_already_exists_exception::Builder,
) -> Result<crate::error::entity_already_exists_exception::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.iam#EntityAlreadyExistsException$message */ =>  {
                let var_5 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_5);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_unmodifiable_entity_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::unmodifiable_entity_exception::Builder,
) -> Result<crate::error::unmodifiable_entity_exception::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.iam#UnmodifiableEntityException$message */ =>  {
                let var_6 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_6);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_policy_not_attachable_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::policy_not_attachable_exception::Builder,
) -> Result<crate::error::policy_not_attachable_exception::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.iam#PolicyNotAttachableException$message */ =>  {
                let var_7 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_7);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_entity_temporarily_unmodifiable_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::entity_temporarily_unmodifiable_exception::Builder,
) -> Result<
    crate::error::entity_temporarily_unmodifiable_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.iam#EntityTemporarilyUnmodifiableException$message */ =>  {
                let var_8 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_8);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_user_type_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_user_type_exception::Builder,
) -> Result<crate::error::invalid_user_type_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.iam#InvalidUserTypeException$message */ =>  {
                let var_9 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_9);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_password_policy_violation_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::password_policy_violation_exception::Builder,
) -> Result<
    crate::error::password_policy_violation_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.iam#PasswordPolicyViolationException$message */ =>  {
                let var_10 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_10);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_access_key(
    inp: &[u8],
    mut builder: crate::output::create_access_key_output::Builder,
) -> Result<crate::output::create_access_key_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateAccessKeyResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateAccessKeyResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateAccessKeyResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateAccessKeyResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("AccessKey") /* AccessKey com.amazonaws.iam.synthetic#CreateAccessKeyOutput$AccessKey */ =>  {
                let var_11 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_access_key(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_access_key(var_11);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateAccessKeyResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_group(
    inp: &[u8],
    mut builder: crate::output::create_group_output::Builder,
) -> Result<crate::output::create_group_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateGroupResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateGroupResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateGroupResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateGroupResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Group") /* Group com.amazonaws.iam.synthetic#CreateGroupOutput$Group */ =>  {
                let var_12 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_group(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_group(var_12);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateGroupResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_concurrent_modification_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::concurrent_modification_exception::Builder,
) -> Result<
    crate::error::concurrent_modification_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.iam#ConcurrentModificationException$message */ =>  {
                let var_13 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_13);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_instance_profile(
    inp: &[u8],
    mut builder: crate::output::create_instance_profile_output::Builder,
) -> Result<crate::output::create_instance_profile_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateInstanceProfileResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateInstanceProfileResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateInstanceProfileResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateInstanceProfileResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("InstanceProfile") /* InstanceProfile com.amazonaws.iam.synthetic#CreateInstanceProfileOutput$InstanceProfile */ =>  {
                let var_14 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_instance_profile(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instance_profile(var_14);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateInstanceProfileResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_login_profile(
    inp: &[u8],
    mut builder: crate::output::create_login_profile_output::Builder,
) -> Result<crate::output::create_login_profile_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateLoginProfileResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateLoginProfileResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateLoginProfileResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateLoginProfileResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("LoginProfile") /* LoginProfile com.amazonaws.iam.synthetic#CreateLoginProfileOutput$LoginProfile */ =>  {
                let var_15 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_login_profile(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_login_profile(var_15);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateLoginProfileResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_open_id_connect_provider(
    inp: &[u8],
    mut builder: crate::output::create_open_id_connect_provider_output::Builder,
) -> Result<
    crate::output::create_open_id_connect_provider_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateOpenIDConnectProviderResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateOpenIDConnectProviderResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateOpenIDConnectProviderResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateOpenIDConnectProviderResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("OpenIDConnectProviderArn") /* OpenIDConnectProviderArn com.amazonaws.iam.synthetic#CreateOpenIDConnectProviderOutput$OpenIDConnectProviderArn */ =>  {
                let var_16 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_open_id_connect_provider_arn(var_16);
            }
            ,
            s if s.matches("Tags") /* Tags com.amazonaws.iam.synthetic#CreateOpenIDConnectProviderOutput$Tags */ =>  {
                let var_17 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_tag_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_17);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateOpenIDConnectProviderResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_malformed_policy_document_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::malformed_policy_document_exception::Builder,
) -> Result<
    crate::error::malformed_policy_document_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.iam#MalformedPolicyDocumentException$message */ =>  {
                let var_18 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_18);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_policy(
    inp: &[u8],
    mut builder: crate::output::create_policy_output::Builder,
) -> Result<crate::output::create_policy_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreatePolicyResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreatePolicyResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreatePolicyResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreatePolicyResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Policy") /* Policy com.amazonaws.iam.synthetic#CreatePolicyOutput$Policy */ =>  {
                let var_19 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_policy(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_policy(var_19);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreatePolicyResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_policy_version(
    inp: &[u8],
    mut builder: crate::output::create_policy_version_output::Builder,
) -> Result<crate::output::create_policy_version_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreatePolicyVersionResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreatePolicyVersionResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreatePolicyVersionResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreatePolicyVersionResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("PolicyVersion") /* PolicyVersion com.amazonaws.iam.synthetic#CreatePolicyVersionOutput$PolicyVersion */ =>  {
                let var_20 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_policy_version(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_policy_version(var_20);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreatePolicyVersionResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_role(
    inp: &[u8],
    mut builder: crate::output::create_role_output::Builder,
) -> Result<crate::output::create_role_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateRoleResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateRoleResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateRoleResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateRoleResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Role") /* Role com.amazonaws.iam.synthetic#CreateRoleOutput$Role */ =>  {
                let var_21 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_role(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_role(var_21);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateRoleResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_saml_provider(
    inp: &[u8],
    mut builder: crate::output::create_saml_provider_output::Builder,
) -> Result<crate::output::create_saml_provider_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateSAMLProviderResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateSAMLProviderResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateSAMLProviderResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateSAMLProviderResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("SAMLProviderArn") /* SAMLProviderArn com.amazonaws.iam.synthetic#CreateSAMLProviderOutput$SAMLProviderArn */ =>  {
                let var_22 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_saml_provider_arn(var_22);
            }
            ,
            s if s.matches("Tags") /* Tags com.amazonaws.iam.synthetic#CreateSAMLProviderOutput$Tags */ =>  {
                let var_23 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_tag_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_23);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateSAMLProviderResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_service_linked_role(
    inp: &[u8],
    mut builder: crate::output::create_service_linked_role_output::Builder,
) -> Result<
    crate::output::create_service_linked_role_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateServiceLinkedRoleResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateServiceLinkedRoleResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateServiceLinkedRoleResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateServiceLinkedRoleResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Role") /* Role com.amazonaws.iam.synthetic#CreateServiceLinkedRoleOutput$Role */ =>  {
                let var_24 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_role(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_role(var_24);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateServiceLinkedRoleResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_service_not_supported_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::service_not_supported_exception::Builder,
) -> Result<crate::error::service_not_supported_exception::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.iam#ServiceNotSupportedException$message */ =>  {
                let var_25 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_25);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_service_specific_credential(
    inp: &[u8],
    mut builder: crate::output::create_service_specific_credential_output::Builder,
) -> Result<
    crate::output::create_service_specific_credential_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateServiceSpecificCredentialResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateServiceSpecificCredentialResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateServiceSpecificCredentialResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateServiceSpecificCredentialResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ServiceSpecificCredential") /* ServiceSpecificCredential com.amazonaws.iam.synthetic#CreateServiceSpecificCredentialOutput$ServiceSpecificCredential */ =>  {
                let var_26 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_service_specific_credential(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_service_specific_credential(var_26);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateServiceSpecificCredentialResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_user(
    inp: &[u8],
    mut builder: crate::output::create_user_output::Builder,
) -> Result<crate::output::create_user_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateUserResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateUserResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateUserResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateUserResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("User") /* User com.amazonaws.iam.synthetic#CreateUserOutput$User */ =>  {
                let var_27 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_user(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_user(var_27);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateUserResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_create_virtual_mfa_device(
    inp: &[u8],
    mut builder: crate::output::create_virtual_mfa_device_output::Builder,
) -> Result<
    crate::output::create_virtual_mfa_device_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("CreateVirtualMFADeviceResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected CreateVirtualMFADeviceResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("CreateVirtualMFADeviceResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected CreateVirtualMFADeviceResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("VirtualMFADevice") /* VirtualMFADevice com.amazonaws.iam.synthetic#CreateVirtualMFADeviceOutput$VirtualMFADevice */ =>  {
                let var_28 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_virtual_mfa_device(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_virtual_mfa_device(var_28);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected CreateVirtualMFADeviceResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_delete_conflict_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::delete_conflict_exception::Builder,
) -> Result<crate::error::delete_conflict_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.iam#DeleteConflictException$message */ =>  {
                let var_29 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_29);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_service_linked_role(
    inp: &[u8],
    mut builder: crate::output::delete_service_linked_role_output::Builder,
) -> Result<
    crate::output::delete_service_linked_role_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteServiceLinkedRoleResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteServiceLinkedRoleResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DeleteServiceLinkedRoleResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DeleteServiceLinkedRoleResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("DeletionTaskId") /* DeletionTaskId com.amazonaws.iam.synthetic#DeleteServiceLinkedRoleOutput$DeletionTaskId */ =>  {
                let var_30 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_deletion_task_id(var_30);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DeleteServiceLinkedRoleResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_authentication_code_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_authentication_code_exception::Builder,
) -> Result<
    crate::error::invalid_authentication_code_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.iam#InvalidAuthenticationCodeException$message */ =>  {
                let var_31 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_31);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_generate_credential_report(
    inp: &[u8],
    mut builder: crate::output::generate_credential_report_output::Builder,
) -> Result<
    crate::output::generate_credential_report_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GenerateCredentialReportResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GenerateCredentialReportResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GenerateCredentialReportResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GenerateCredentialReportResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("State") /* State com.amazonaws.iam.synthetic#GenerateCredentialReportOutput$State */ =>  {
                let var_32 =
                    Some(
                        Result::<crate::model::ReportStateType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ReportStateType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_state(var_32);
            }
            ,
            s if s.matches("Description") /* Description com.amazonaws.iam.synthetic#GenerateCredentialReportOutput$Description */ =>  {
                let var_33 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_description(var_33);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GenerateCredentialReportResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_report_generation_limit_exceeded_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::report_generation_limit_exceeded_exception::Builder,
) -> Result<
    crate::error::report_generation_limit_exceeded_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.iam#ReportGenerationLimitExceededException$message */ =>  {
                let var_34 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_34);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_generate_organizations_access_report(
    inp: &[u8],
    mut builder: crate::output::generate_organizations_access_report_output::Builder,
) -> Result<
    crate::output::generate_organizations_access_report_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GenerateOrganizationsAccessReportResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GenerateOrganizationsAccessReportResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GenerateOrganizationsAccessReportResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GenerateOrganizationsAccessReportResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("JobId") /* JobId com.amazonaws.iam.synthetic#GenerateOrganizationsAccessReportOutput$JobId */ =>  {
                let var_35 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_job_id(var_35);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GenerateOrganizationsAccessReportResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_generate_service_last_accessed_details(
    inp: &[u8],
    mut builder: crate::output::generate_service_last_accessed_details_output::Builder,
) -> Result<
    crate::output::generate_service_last_accessed_details_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GenerateServiceLastAccessedDetailsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GenerateServiceLastAccessedDetailsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GenerateServiceLastAccessedDetailsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GenerateServiceLastAccessedDetailsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("JobId") /* JobId com.amazonaws.iam.synthetic#GenerateServiceLastAccessedDetailsOutput$JobId */ =>  {
                let var_36 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_job_id(var_36);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GenerateServiceLastAccessedDetailsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_access_key_last_used(
    inp: &[u8],
    mut builder: crate::output::get_access_key_last_used_output::Builder,
) -> Result<crate::output::get_access_key_last_used_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetAccessKeyLastUsedResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetAccessKeyLastUsedResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetAccessKeyLastUsedResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetAccessKeyLastUsedResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("UserName") /* UserName com.amazonaws.iam.synthetic#GetAccessKeyLastUsedOutput$UserName */ =>  {
                let var_37 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_user_name(var_37);
            }
            ,
            s if s.matches("AccessKeyLastUsed") /* AccessKeyLastUsed com.amazonaws.iam.synthetic#GetAccessKeyLastUsedOutput$AccessKeyLastUsed */ =>  {
                let var_38 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_access_key_last_used(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_access_key_last_used(var_38);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetAccessKeyLastUsedResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_account_authorization_details(
    inp: &[u8],
    mut builder: crate::output::get_account_authorization_details_output::Builder,
) -> Result<
    crate::output::get_account_authorization_details_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetAccountAuthorizationDetailsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetAccountAuthorizationDetailsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetAccountAuthorizationDetailsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetAccountAuthorizationDetailsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("UserDetailList") /* UserDetailList com.amazonaws.iam.synthetic#GetAccountAuthorizationDetailsOutput$UserDetailList */ =>  {
                let var_39 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_user_detail_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_user_detail_list(var_39);
            }
            ,
            s if s.matches("GroupDetailList") /* GroupDetailList com.amazonaws.iam.synthetic#GetAccountAuthorizationDetailsOutput$GroupDetailList */ =>  {
                let var_40 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_group_detail_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_group_detail_list(var_40);
            }
            ,
            s if s.matches("RoleDetailList") /* RoleDetailList com.amazonaws.iam.synthetic#GetAccountAuthorizationDetailsOutput$RoleDetailList */ =>  {
                let var_41 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_role_detail_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_role_detail_list(var_41);
            }
            ,
            s if s.matches("Policies") /* Policies com.amazonaws.iam.synthetic#GetAccountAuthorizationDetailsOutput$Policies */ =>  {
                let var_42 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_managed_policy_detail_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_policies(var_42);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#GetAccountAuthorizationDetailsOutput$IsTruncated */ =>  {
                let var_43 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_43);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#GetAccountAuthorizationDetailsOutput$Marker */ =>  {
                let var_44 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_44);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetAccountAuthorizationDetailsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_account_password_policy(
    inp: &[u8],
    mut builder: crate::output::get_account_password_policy_output::Builder,
) -> Result<
    crate::output::get_account_password_policy_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetAccountPasswordPolicyResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetAccountPasswordPolicyResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetAccountPasswordPolicyResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetAccountPasswordPolicyResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("PasswordPolicy") /* PasswordPolicy com.amazonaws.iam.synthetic#GetAccountPasswordPolicyOutput$PasswordPolicy */ =>  {
                let var_45 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_password_policy(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_password_policy(var_45);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetAccountPasswordPolicyResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_account_summary(
    inp: &[u8],
    mut builder: crate::output::get_account_summary_output::Builder,
) -> Result<crate::output::get_account_summary_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetAccountSummaryResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetAccountSummaryResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetAccountSummaryResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetAccountSummaryResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("SummaryMap") /* SummaryMap com.amazonaws.iam.synthetic#GetAccountSummaryOutput$SummaryMap */ =>  {
                let var_46 =
                    Some(
                        crate::xml_deser::deser_map_com_amazonaws_iam_summary_map_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_summary_map(var_46);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetAccountSummaryResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_context_keys_for_custom_policy(
    inp: &[u8],
    mut builder: crate::output::get_context_keys_for_custom_policy_output::Builder,
) -> Result<
    crate::output::get_context_keys_for_custom_policy_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetContextKeysForCustomPolicyResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetContextKeysForCustomPolicyResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetContextKeysForCustomPolicyResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetContextKeysForCustomPolicyResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ContextKeyNames") /* ContextKeyNames com.amazonaws.iam.synthetic#GetContextKeysForCustomPolicyOutput$ContextKeyNames */ =>  {
                let var_47 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_context_key_names_result_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_context_key_names(var_47);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetContextKeysForCustomPolicyResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_context_keys_for_principal_policy(
    inp: &[u8],
    mut builder: crate::output::get_context_keys_for_principal_policy_output::Builder,
) -> Result<
    crate::output::get_context_keys_for_principal_policy_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetContextKeysForPrincipalPolicyResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetContextKeysForPrincipalPolicyResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetContextKeysForPrincipalPolicyResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetContextKeysForPrincipalPolicyResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ContextKeyNames") /* ContextKeyNames com.amazonaws.iam.synthetic#GetContextKeysForPrincipalPolicyOutput$ContextKeyNames */ =>  {
                let var_48 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_context_key_names_result_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_context_key_names(var_48);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetContextKeysForPrincipalPolicyResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_credential_report_expired_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::credential_report_expired_exception::Builder,
) -> Result<
    crate::error::credential_report_expired_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.iam#CredentialReportExpiredException$message */ =>  {
                let var_49 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_49);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_credential_report_not_present_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::credential_report_not_present_exception::Builder,
) -> Result<
    crate::error::credential_report_not_present_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.iam#CredentialReportNotPresentException$message */ =>  {
                let var_50 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_50);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_credential_report_not_ready_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::credential_report_not_ready_exception::Builder,
) -> Result<
    crate::error::credential_report_not_ready_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.iam#CredentialReportNotReadyException$message */ =>  {
                let var_51 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_51);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_credential_report(
    inp: &[u8],
    mut builder: crate::output::get_credential_report_output::Builder,
) -> Result<crate::output::get_credential_report_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetCredentialReportResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetCredentialReportResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetCredentialReportResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetCredentialReportResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Content") /* Content com.amazonaws.iam.synthetic#GetCredentialReportOutput$Content */ =>  {
                let var_52 =
                    Some(
                        aws_smithy_types::base64::decode(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        )
                        .map_err(|err|aws_smithy_xml::decode::XmlError::custom(format!("invalid base64: {:?}", err))).map(aws_smithy_types::Blob::new)
                        ?
                    )
                ;
                builder = builder.set_content(var_52);
            }
            ,
            s if s.matches("ReportFormat") /* ReportFormat com.amazonaws.iam.synthetic#GetCredentialReportOutput$ReportFormat */ =>  {
                let var_53 =
                    Some(
                        Result::<crate::model::ReportFormatType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ReportFormatType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_report_format(var_53);
            }
            ,
            s if s.matches("GeneratedTime") /* GeneratedTime com.amazonaws.iam.synthetic#GetCredentialReportOutput$GeneratedTime */ =>  {
                let var_54 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_generated_time(var_54);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetCredentialReportResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_group(
    inp: &[u8],
    mut builder: crate::output::get_group_output::Builder,
) -> Result<crate::output::get_group_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetGroupResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetGroupResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetGroupResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetGroupResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Group") /* Group com.amazonaws.iam.synthetic#GetGroupOutput$Group */ =>  {
                let var_55 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_group(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_group(var_55);
            }
            ,
            s if s.matches("Users") /* Users com.amazonaws.iam.synthetic#GetGroupOutput$Users */ =>  {
                let var_56 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_user_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_users(var_56);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#GetGroupOutput$IsTruncated */ =>  {
                let var_57 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_57);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#GetGroupOutput$Marker */ =>  {
                let var_58 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_58);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetGroupResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_group_policy(
    inp: &[u8],
    mut builder: crate::output::get_group_policy_output::Builder,
) -> Result<crate::output::get_group_policy_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetGroupPolicyResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetGroupPolicyResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetGroupPolicyResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetGroupPolicyResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("GroupName") /* GroupName com.amazonaws.iam.synthetic#GetGroupPolicyOutput$GroupName */ =>  {
                let var_59 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_group_name(var_59);
            }
            ,
            s if s.matches("PolicyName") /* PolicyName com.amazonaws.iam.synthetic#GetGroupPolicyOutput$PolicyName */ =>  {
                let var_60 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_policy_name(var_60);
            }
            ,
            s if s.matches("PolicyDocument") /* PolicyDocument com.amazonaws.iam.synthetic#GetGroupPolicyOutput$PolicyDocument */ =>  {
                let var_61 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_policy_document(var_61);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetGroupPolicyResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_instance_profile(
    inp: &[u8],
    mut builder: crate::output::get_instance_profile_output::Builder,
) -> Result<crate::output::get_instance_profile_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetInstanceProfileResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetInstanceProfileResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetInstanceProfileResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetInstanceProfileResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("InstanceProfile") /* InstanceProfile com.amazonaws.iam.synthetic#GetInstanceProfileOutput$InstanceProfile */ =>  {
                let var_62 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_instance_profile(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instance_profile(var_62);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetInstanceProfileResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_login_profile(
    inp: &[u8],
    mut builder: crate::output::get_login_profile_output::Builder,
) -> Result<crate::output::get_login_profile_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetLoginProfileResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetLoginProfileResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetLoginProfileResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetLoginProfileResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("LoginProfile") /* LoginProfile com.amazonaws.iam.synthetic#GetLoginProfileOutput$LoginProfile */ =>  {
                let var_63 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_login_profile(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_login_profile(var_63);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetLoginProfileResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_open_id_connect_provider(
    inp: &[u8],
    mut builder: crate::output::get_open_id_connect_provider_output::Builder,
) -> Result<
    crate::output::get_open_id_connect_provider_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetOpenIDConnectProviderResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetOpenIDConnectProviderResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetOpenIDConnectProviderResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetOpenIDConnectProviderResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Url") /* Url com.amazonaws.iam.synthetic#GetOpenIDConnectProviderOutput$Url */ =>  {
                let var_64 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_url(var_64);
            }
            ,
            s if s.matches("ClientIDList") /* ClientIDList com.amazonaws.iam.synthetic#GetOpenIDConnectProviderOutput$ClientIDList */ =>  {
                let var_65 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_client_id_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_client_id_list(var_65);
            }
            ,
            s if s.matches("ThumbprintList") /* ThumbprintList com.amazonaws.iam.synthetic#GetOpenIDConnectProviderOutput$ThumbprintList */ =>  {
                let var_66 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_thumbprint_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_thumbprint_list(var_66);
            }
            ,
            s if s.matches("CreateDate") /* CreateDate com.amazonaws.iam.synthetic#GetOpenIDConnectProviderOutput$CreateDate */ =>  {
                let var_67 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_create_date(var_67);
            }
            ,
            s if s.matches("Tags") /* Tags com.amazonaws.iam.synthetic#GetOpenIDConnectProviderOutput$Tags */ =>  {
                let var_68 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_tag_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_68);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetOpenIDConnectProviderResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_organizations_access_report(
    inp: &[u8],
    mut builder: crate::output::get_organizations_access_report_output::Builder,
) -> Result<
    crate::output::get_organizations_access_report_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetOrganizationsAccessReportResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetOrganizationsAccessReportResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetOrganizationsAccessReportResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetOrganizationsAccessReportResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("JobStatus") /* JobStatus com.amazonaws.iam.synthetic#GetOrganizationsAccessReportOutput$JobStatus */ =>  {
                let var_69 =
                    Some(
                        Result::<crate::model::JobStatusType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::JobStatusType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_job_status(var_69);
            }
            ,
            s if s.matches("JobCreationDate") /* JobCreationDate com.amazonaws.iam.synthetic#GetOrganizationsAccessReportOutput$JobCreationDate */ =>  {
                let var_70 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_job_creation_date(var_70);
            }
            ,
            s if s.matches("JobCompletionDate") /* JobCompletionDate com.amazonaws.iam.synthetic#GetOrganizationsAccessReportOutput$JobCompletionDate */ =>  {
                let var_71 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_job_completion_date(var_71);
            }
            ,
            s if s.matches("NumberOfServicesAccessible") /* NumberOfServicesAccessible com.amazonaws.iam.synthetic#GetOrganizationsAccessReportOutput$NumberOfServicesAccessible */ =>  {
                let var_72 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.iam#integerType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_number_of_services_accessible(var_72);
            }
            ,
            s if s.matches("NumberOfServicesNotAccessed") /* NumberOfServicesNotAccessed com.amazonaws.iam.synthetic#GetOrganizationsAccessReportOutput$NumberOfServicesNotAccessed */ =>  {
                let var_73 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.iam#integerType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_number_of_services_not_accessed(var_73);
            }
            ,
            s if s.matches("AccessDetails") /* AccessDetails com.amazonaws.iam.synthetic#GetOrganizationsAccessReportOutput$AccessDetails */ =>  {
                let var_74 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_access_details(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_access_details(var_74);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#GetOrganizationsAccessReportOutput$IsTruncated */ =>  {
                let var_75 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_75);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#GetOrganizationsAccessReportOutput$Marker */ =>  {
                let var_76 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_76);
            }
            ,
            s if s.matches("ErrorDetails") /* ErrorDetails com.amazonaws.iam.synthetic#GetOrganizationsAccessReportOutput$ErrorDetails */ =>  {
                let var_77 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_error_details(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_error_details(var_77);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetOrganizationsAccessReportResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_policy(
    inp: &[u8],
    mut builder: crate::output::get_policy_output::Builder,
) -> Result<crate::output::get_policy_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetPolicyResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetPolicyResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetPolicyResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetPolicyResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Policy") /* Policy com.amazonaws.iam.synthetic#GetPolicyOutput$Policy */ =>  {
                let var_78 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_policy(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_policy(var_78);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetPolicyResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_policy_version(
    inp: &[u8],
    mut builder: crate::output::get_policy_version_output::Builder,
) -> Result<crate::output::get_policy_version_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetPolicyVersionResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetPolicyVersionResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetPolicyVersionResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetPolicyVersionResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("PolicyVersion") /* PolicyVersion com.amazonaws.iam.synthetic#GetPolicyVersionOutput$PolicyVersion */ =>  {
                let var_79 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_policy_version(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_policy_version(var_79);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetPolicyVersionResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_role(
    inp: &[u8],
    mut builder: crate::output::get_role_output::Builder,
) -> Result<crate::output::get_role_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetRoleResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetRoleResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetRoleResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetRoleResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Role") /* Role com.amazonaws.iam.synthetic#GetRoleOutput$Role */ =>  {
                let var_80 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_role(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_role(var_80);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetRoleResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_role_policy(
    inp: &[u8],
    mut builder: crate::output::get_role_policy_output::Builder,
) -> Result<crate::output::get_role_policy_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetRolePolicyResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetRolePolicyResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetRolePolicyResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetRolePolicyResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("RoleName") /* RoleName com.amazonaws.iam.synthetic#GetRolePolicyOutput$RoleName */ =>  {
                let var_81 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_role_name(var_81);
            }
            ,
            s if s.matches("PolicyName") /* PolicyName com.amazonaws.iam.synthetic#GetRolePolicyOutput$PolicyName */ =>  {
                let var_82 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_policy_name(var_82);
            }
            ,
            s if s.matches("PolicyDocument") /* PolicyDocument com.amazonaws.iam.synthetic#GetRolePolicyOutput$PolicyDocument */ =>  {
                let var_83 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_policy_document(var_83);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetRolePolicyResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_saml_provider(
    inp: &[u8],
    mut builder: crate::output::get_saml_provider_output::Builder,
) -> Result<crate::output::get_saml_provider_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetSAMLProviderResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetSAMLProviderResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetSAMLProviderResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetSAMLProviderResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("SAMLMetadataDocument") /* SAMLMetadataDocument com.amazonaws.iam.synthetic#GetSAMLProviderOutput$SAMLMetadataDocument */ =>  {
                let var_84 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_saml_metadata_document(var_84);
            }
            ,
            s if s.matches("CreateDate") /* CreateDate com.amazonaws.iam.synthetic#GetSAMLProviderOutput$CreateDate */ =>  {
                let var_85 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_create_date(var_85);
            }
            ,
            s if s.matches("ValidUntil") /* ValidUntil com.amazonaws.iam.synthetic#GetSAMLProviderOutput$ValidUntil */ =>  {
                let var_86 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_valid_until(var_86);
            }
            ,
            s if s.matches("Tags") /* Tags com.amazonaws.iam.synthetic#GetSAMLProviderOutput$Tags */ =>  {
                let var_87 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_tag_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_87);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetSAMLProviderResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_server_certificate(
    inp: &[u8],
    mut builder: crate::output::get_server_certificate_output::Builder,
) -> Result<crate::output::get_server_certificate_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetServerCertificateResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetServerCertificateResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetServerCertificateResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetServerCertificateResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ServerCertificate") /* ServerCertificate com.amazonaws.iam.synthetic#GetServerCertificateOutput$ServerCertificate */ =>  {
                let var_88 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_server_certificate(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_server_certificate(var_88);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetServerCertificateResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_service_last_accessed_details(
    inp: &[u8],
    mut builder: crate::output::get_service_last_accessed_details_output::Builder,
) -> Result<
    crate::output::get_service_last_accessed_details_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetServiceLastAccessedDetailsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetServiceLastAccessedDetailsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetServiceLastAccessedDetailsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetServiceLastAccessedDetailsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("JobStatus") /* JobStatus com.amazonaws.iam.synthetic#GetServiceLastAccessedDetailsOutput$JobStatus */ =>  {
                let var_89 =
                    Some(
                        Result::<crate::model::JobStatusType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::JobStatusType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_job_status(var_89);
            }
            ,
            s if s.matches("JobType") /* JobType com.amazonaws.iam.synthetic#GetServiceLastAccessedDetailsOutput$JobType */ =>  {
                let var_90 =
                    Some(
                        Result::<crate::model::AccessAdvisorUsageGranularityType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::AccessAdvisorUsageGranularityType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_job_type(var_90);
            }
            ,
            s if s.matches("JobCreationDate") /* JobCreationDate com.amazonaws.iam.synthetic#GetServiceLastAccessedDetailsOutput$JobCreationDate */ =>  {
                let var_91 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_job_creation_date(var_91);
            }
            ,
            s if s.matches("ServicesLastAccessed") /* ServicesLastAccessed com.amazonaws.iam.synthetic#GetServiceLastAccessedDetailsOutput$ServicesLastAccessed */ =>  {
                let var_92 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_services_last_accessed(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_services_last_accessed(var_92);
            }
            ,
            s if s.matches("JobCompletionDate") /* JobCompletionDate com.amazonaws.iam.synthetic#GetServiceLastAccessedDetailsOutput$JobCompletionDate */ =>  {
                let var_93 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_job_completion_date(var_93);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#GetServiceLastAccessedDetailsOutput$IsTruncated */ =>  {
                let var_94 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_94);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#GetServiceLastAccessedDetailsOutput$Marker */ =>  {
                let var_95 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_95);
            }
            ,
            s if s.matches("Error") /* Error com.amazonaws.iam.synthetic#GetServiceLastAccessedDetailsOutput$Error */ =>  {
                let var_96 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_error_details(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_error(var_96);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetServiceLastAccessedDetailsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_service_last_accessed_details_with_entities(
    inp: &[u8],
    mut builder: crate::output::get_service_last_accessed_details_with_entities_output::Builder,
) -> Result<
    crate::output::get_service_last_accessed_details_with_entities_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetServiceLastAccessedDetailsWithEntitiesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetServiceLastAccessedDetailsWithEntitiesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetServiceLastAccessedDetailsWithEntitiesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetServiceLastAccessedDetailsWithEntitiesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("JobStatus") /* JobStatus com.amazonaws.iam.synthetic#GetServiceLastAccessedDetailsWithEntitiesOutput$JobStatus */ =>  {
                let var_97 =
                    Some(
                        Result::<crate::model::JobStatusType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::JobStatusType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_job_status(var_97);
            }
            ,
            s if s.matches("JobCreationDate") /* JobCreationDate com.amazonaws.iam.synthetic#GetServiceLastAccessedDetailsWithEntitiesOutput$JobCreationDate */ =>  {
                let var_98 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_job_creation_date(var_98);
            }
            ,
            s if s.matches("JobCompletionDate") /* JobCompletionDate com.amazonaws.iam.synthetic#GetServiceLastAccessedDetailsWithEntitiesOutput$JobCompletionDate */ =>  {
                let var_99 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_job_completion_date(var_99);
            }
            ,
            s if s.matches("EntityDetailsList") /* EntityDetailsList com.amazonaws.iam.synthetic#GetServiceLastAccessedDetailsWithEntitiesOutput$EntityDetailsList */ =>  {
                let var_100 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_entity_details_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_entity_details_list(var_100);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#GetServiceLastAccessedDetailsWithEntitiesOutput$IsTruncated */ =>  {
                let var_101 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_101);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#GetServiceLastAccessedDetailsWithEntitiesOutput$Marker */ =>  {
                let var_102 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_102);
            }
            ,
            s if s.matches("Error") /* Error com.amazonaws.iam.synthetic#GetServiceLastAccessedDetailsWithEntitiesOutput$Error */ =>  {
                let var_103 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_error_details(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_error(var_103);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetServiceLastAccessedDetailsWithEntitiesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_service_linked_role_deletion_status(
    inp: &[u8],
    mut builder: crate::output::get_service_linked_role_deletion_status_output::Builder,
) -> Result<
    crate::output::get_service_linked_role_deletion_status_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetServiceLinkedRoleDeletionStatusResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetServiceLinkedRoleDeletionStatusResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetServiceLinkedRoleDeletionStatusResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetServiceLinkedRoleDeletionStatusResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Status") /* Status com.amazonaws.iam.synthetic#GetServiceLinkedRoleDeletionStatusOutput$Status */ =>  {
                let var_104 =
                    Some(
                        Result::<crate::model::DeletionTaskStatusType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::DeletionTaskStatusType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_104);
            }
            ,
            s if s.matches("Reason") /* Reason com.amazonaws.iam.synthetic#GetServiceLinkedRoleDeletionStatusOutput$Reason */ =>  {
                let var_105 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_deletion_task_failure_reason_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_reason(var_105);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetServiceLinkedRoleDeletionStatusResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_unrecognized_public_key_encoding_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::unrecognized_public_key_encoding_exception::Builder,
) -> Result<
    crate::error::unrecognized_public_key_encoding_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.iam#UnrecognizedPublicKeyEncodingException$message */ =>  {
                let var_106 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_106);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_ssh_public_key(
    inp: &[u8],
    mut builder: crate::output::get_ssh_public_key_output::Builder,
) -> Result<crate::output::get_ssh_public_key_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetSSHPublicKeyResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetSSHPublicKeyResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetSSHPublicKeyResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetSSHPublicKeyResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("SSHPublicKey") /* SSHPublicKey com.amazonaws.iam.synthetic#GetSSHPublicKeyOutput$SSHPublicKey */ =>  {
                let var_107 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_ssh_public_key(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ssh_public_key(var_107);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetSSHPublicKeyResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_user(
    inp: &[u8],
    mut builder: crate::output::get_user_output::Builder,
) -> Result<crate::output::get_user_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetUserResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetUserResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetUserResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetUserResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("User") /* User com.amazonaws.iam.synthetic#GetUserOutput$User */ =>  {
                let var_108 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_user(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_user(var_108);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetUserResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_user_policy(
    inp: &[u8],
    mut builder: crate::output::get_user_policy_output::Builder,
) -> Result<crate::output::get_user_policy_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetUserPolicyResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetUserPolicyResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetUserPolicyResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetUserPolicyResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("UserName") /* UserName com.amazonaws.iam.synthetic#GetUserPolicyOutput$UserName */ =>  {
                let var_109 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_user_name(var_109);
            }
            ,
            s if s.matches("PolicyName") /* PolicyName com.amazonaws.iam.synthetic#GetUserPolicyOutput$PolicyName */ =>  {
                let var_110 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_policy_name(var_110);
            }
            ,
            s if s.matches("PolicyDocument") /* PolicyDocument com.amazonaws.iam.synthetic#GetUserPolicyOutput$PolicyDocument */ =>  {
                let var_111 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_policy_document(var_111);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetUserPolicyResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_access_keys(
    inp: &[u8],
    mut builder: crate::output::list_access_keys_output::Builder,
) -> Result<crate::output::list_access_keys_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListAccessKeysResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListAccessKeysResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListAccessKeysResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListAccessKeysResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("AccessKeyMetadata") /* AccessKeyMetadata com.amazonaws.iam.synthetic#ListAccessKeysOutput$AccessKeyMetadata */ =>  {
                let var_112 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_access_key_metadata_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_access_key_metadata(var_112);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#ListAccessKeysOutput$IsTruncated */ =>  {
                let var_113 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_113);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#ListAccessKeysOutput$Marker */ =>  {
                let var_114 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_114);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListAccessKeysResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_account_aliases(
    inp: &[u8],
    mut builder: crate::output::list_account_aliases_output::Builder,
) -> Result<crate::output::list_account_aliases_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListAccountAliasesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListAccountAliasesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListAccountAliasesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListAccountAliasesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("AccountAliases") /* AccountAliases com.amazonaws.iam.synthetic#ListAccountAliasesOutput$AccountAliases */ =>  {
                let var_115 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_account_alias_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_account_aliases(var_115);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#ListAccountAliasesOutput$IsTruncated */ =>  {
                let var_116 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_116);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#ListAccountAliasesOutput$Marker */ =>  {
                let var_117 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_117);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListAccountAliasesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_attached_group_policies(
    inp: &[u8],
    mut builder: crate::output::list_attached_group_policies_output::Builder,
) -> Result<
    crate::output::list_attached_group_policies_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListAttachedGroupPoliciesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListAttachedGroupPoliciesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListAttachedGroupPoliciesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListAttachedGroupPoliciesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("AttachedPolicies") /* AttachedPolicies com.amazonaws.iam.synthetic#ListAttachedGroupPoliciesOutput$AttachedPolicies */ =>  {
                let var_118 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_attached_policies_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_attached_policies(var_118);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#ListAttachedGroupPoliciesOutput$IsTruncated */ =>  {
                let var_119 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_119);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#ListAttachedGroupPoliciesOutput$Marker */ =>  {
                let var_120 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_120);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListAttachedGroupPoliciesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_attached_role_policies(
    inp: &[u8],
    mut builder: crate::output::list_attached_role_policies_output::Builder,
) -> Result<
    crate::output::list_attached_role_policies_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListAttachedRolePoliciesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListAttachedRolePoliciesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListAttachedRolePoliciesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListAttachedRolePoliciesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("AttachedPolicies") /* AttachedPolicies com.amazonaws.iam.synthetic#ListAttachedRolePoliciesOutput$AttachedPolicies */ =>  {
                let var_121 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_attached_policies_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_attached_policies(var_121);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#ListAttachedRolePoliciesOutput$IsTruncated */ =>  {
                let var_122 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_122);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#ListAttachedRolePoliciesOutput$Marker */ =>  {
                let var_123 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_123);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListAttachedRolePoliciesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_attached_user_policies(
    inp: &[u8],
    mut builder: crate::output::list_attached_user_policies_output::Builder,
) -> Result<
    crate::output::list_attached_user_policies_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListAttachedUserPoliciesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListAttachedUserPoliciesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListAttachedUserPoliciesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListAttachedUserPoliciesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("AttachedPolicies") /* AttachedPolicies com.amazonaws.iam.synthetic#ListAttachedUserPoliciesOutput$AttachedPolicies */ =>  {
                let var_124 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_attached_policies_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_attached_policies(var_124);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#ListAttachedUserPoliciesOutput$IsTruncated */ =>  {
                let var_125 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_125);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#ListAttachedUserPoliciesOutput$Marker */ =>  {
                let var_126 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_126);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListAttachedUserPoliciesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_entities_for_policy(
    inp: &[u8],
    mut builder: crate::output::list_entities_for_policy_output::Builder,
) -> Result<crate::output::list_entities_for_policy_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListEntitiesForPolicyResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListEntitiesForPolicyResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListEntitiesForPolicyResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListEntitiesForPolicyResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("PolicyGroups") /* PolicyGroups com.amazonaws.iam.synthetic#ListEntitiesForPolicyOutput$PolicyGroups */ =>  {
                let var_127 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_policy_group_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_policy_groups(var_127);
            }
            ,
            s if s.matches("PolicyUsers") /* PolicyUsers com.amazonaws.iam.synthetic#ListEntitiesForPolicyOutput$PolicyUsers */ =>  {
                let var_128 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_policy_user_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_policy_users(var_128);
            }
            ,
            s if s.matches("PolicyRoles") /* PolicyRoles com.amazonaws.iam.synthetic#ListEntitiesForPolicyOutput$PolicyRoles */ =>  {
                let var_129 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_policy_role_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_policy_roles(var_129);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#ListEntitiesForPolicyOutput$IsTruncated */ =>  {
                let var_130 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_130);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#ListEntitiesForPolicyOutput$Marker */ =>  {
                let var_131 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_131);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListEntitiesForPolicyResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_group_policies(
    inp: &[u8],
    mut builder: crate::output::list_group_policies_output::Builder,
) -> Result<crate::output::list_group_policies_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListGroupPoliciesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListGroupPoliciesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListGroupPoliciesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListGroupPoliciesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("PolicyNames") /* PolicyNames com.amazonaws.iam.synthetic#ListGroupPoliciesOutput$PolicyNames */ =>  {
                let var_132 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_policy_name_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_policy_names(var_132);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#ListGroupPoliciesOutput$IsTruncated */ =>  {
                let var_133 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_133);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#ListGroupPoliciesOutput$Marker */ =>  {
                let var_134 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_134);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListGroupPoliciesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_groups(
    inp: &[u8],
    mut builder: crate::output::list_groups_output::Builder,
) -> Result<crate::output::list_groups_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListGroupsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListGroupsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListGroupsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListGroupsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Groups") /* Groups com.amazonaws.iam.synthetic#ListGroupsOutput$Groups */ =>  {
                let var_135 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_group_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_groups(var_135);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#ListGroupsOutput$IsTruncated */ =>  {
                let var_136 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_136);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#ListGroupsOutput$Marker */ =>  {
                let var_137 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_137);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListGroupsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_groups_for_user(
    inp: &[u8],
    mut builder: crate::output::list_groups_for_user_output::Builder,
) -> Result<crate::output::list_groups_for_user_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListGroupsForUserResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListGroupsForUserResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListGroupsForUserResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListGroupsForUserResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Groups") /* Groups com.amazonaws.iam.synthetic#ListGroupsForUserOutput$Groups */ =>  {
                let var_138 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_group_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_groups(var_138);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#ListGroupsForUserOutput$IsTruncated */ =>  {
                let var_139 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_139);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#ListGroupsForUserOutput$Marker */ =>  {
                let var_140 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_140);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListGroupsForUserResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_instance_profiles(
    inp: &[u8],
    mut builder: crate::output::list_instance_profiles_output::Builder,
) -> Result<crate::output::list_instance_profiles_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListInstanceProfilesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListInstanceProfilesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListInstanceProfilesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListInstanceProfilesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("InstanceProfiles") /* InstanceProfiles com.amazonaws.iam.synthetic#ListInstanceProfilesOutput$InstanceProfiles */ =>  {
                let var_141 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_instance_profile_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instance_profiles(var_141);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#ListInstanceProfilesOutput$IsTruncated */ =>  {
                let var_142 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_142);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#ListInstanceProfilesOutput$Marker */ =>  {
                let var_143 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_143);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListInstanceProfilesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_instance_profiles_for_role(
    inp: &[u8],
    mut builder: crate::output::list_instance_profiles_for_role_output::Builder,
) -> Result<
    crate::output::list_instance_profiles_for_role_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListInstanceProfilesForRoleResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListInstanceProfilesForRoleResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListInstanceProfilesForRoleResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListInstanceProfilesForRoleResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("InstanceProfiles") /* InstanceProfiles com.amazonaws.iam.synthetic#ListInstanceProfilesForRoleOutput$InstanceProfiles */ =>  {
                let var_144 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_instance_profile_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instance_profiles(var_144);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#ListInstanceProfilesForRoleOutput$IsTruncated */ =>  {
                let var_145 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_145);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#ListInstanceProfilesForRoleOutput$Marker */ =>  {
                let var_146 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_146);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListInstanceProfilesForRoleResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_instance_profile_tags(
    inp: &[u8],
    mut builder: crate::output::list_instance_profile_tags_output::Builder,
) -> Result<
    crate::output::list_instance_profile_tags_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListInstanceProfileTagsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListInstanceProfileTagsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListInstanceProfileTagsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListInstanceProfileTagsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Tags") /* Tags com.amazonaws.iam.synthetic#ListInstanceProfileTagsOutput$Tags */ =>  {
                let var_147 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_tag_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_147);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#ListInstanceProfileTagsOutput$IsTruncated */ =>  {
                let var_148 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_148);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#ListInstanceProfileTagsOutput$Marker */ =>  {
                let var_149 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_149);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListInstanceProfileTagsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_mfa_devices(
    inp: &[u8],
    mut builder: crate::output::list_mfa_devices_output::Builder,
) -> Result<crate::output::list_mfa_devices_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListMFADevicesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListMFADevicesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListMFADevicesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListMFADevicesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("MFADevices") /* MFADevices com.amazonaws.iam.synthetic#ListMFADevicesOutput$MFADevices */ =>  {
                let var_150 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_mfa_device_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_mfa_devices(var_150);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#ListMFADevicesOutput$IsTruncated */ =>  {
                let var_151 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_151);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#ListMFADevicesOutput$Marker */ =>  {
                let var_152 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_152);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListMFADevicesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_mfa_device_tags(
    inp: &[u8],
    mut builder: crate::output::list_mfa_device_tags_output::Builder,
) -> Result<crate::output::list_mfa_device_tags_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListMFADeviceTagsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListMFADeviceTagsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListMFADeviceTagsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListMFADeviceTagsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Tags") /* Tags com.amazonaws.iam.synthetic#ListMFADeviceTagsOutput$Tags */ =>  {
                let var_153 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_tag_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_153);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#ListMFADeviceTagsOutput$IsTruncated */ =>  {
                let var_154 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_154);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#ListMFADeviceTagsOutput$Marker */ =>  {
                let var_155 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_155);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListMFADeviceTagsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_open_id_connect_providers(
    inp: &[u8],
    mut builder: crate::output::list_open_id_connect_providers_output::Builder,
) -> Result<
    crate::output::list_open_id_connect_providers_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListOpenIDConnectProvidersResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListOpenIDConnectProvidersResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListOpenIDConnectProvidersResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListOpenIDConnectProvidersResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("OpenIDConnectProviderList") /* OpenIDConnectProviderList com.amazonaws.iam.synthetic#ListOpenIDConnectProvidersOutput$OpenIDConnectProviderList */ =>  {
                let var_156 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_open_id_connect_provider_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_open_id_connect_provider_list(var_156);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListOpenIDConnectProvidersResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_open_id_connect_provider_tags(
    inp: &[u8],
    mut builder: crate::output::list_open_id_connect_provider_tags_output::Builder,
) -> Result<
    crate::output::list_open_id_connect_provider_tags_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListOpenIDConnectProviderTagsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListOpenIDConnectProviderTagsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListOpenIDConnectProviderTagsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListOpenIDConnectProviderTagsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Tags") /* Tags com.amazonaws.iam.synthetic#ListOpenIDConnectProviderTagsOutput$Tags */ =>  {
                let var_157 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_tag_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_157);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#ListOpenIDConnectProviderTagsOutput$IsTruncated */ =>  {
                let var_158 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_158);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#ListOpenIDConnectProviderTagsOutput$Marker */ =>  {
                let var_159 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_159);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListOpenIDConnectProviderTagsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_policies(
    inp: &[u8],
    mut builder: crate::output::list_policies_output::Builder,
) -> Result<crate::output::list_policies_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListPoliciesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListPoliciesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListPoliciesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListPoliciesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Policies") /* Policies com.amazonaws.iam.synthetic#ListPoliciesOutput$Policies */ =>  {
                let var_160 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_policy_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_policies(var_160);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#ListPoliciesOutput$IsTruncated */ =>  {
                let var_161 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_161);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#ListPoliciesOutput$Marker */ =>  {
                let var_162 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_162);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListPoliciesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_policies_granting_service_access(
    inp: &[u8],
    mut builder: crate::output::list_policies_granting_service_access_output::Builder,
) -> Result<
    crate::output::list_policies_granting_service_access_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListPoliciesGrantingServiceAccessResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListPoliciesGrantingServiceAccessResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListPoliciesGrantingServiceAccessResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListPoliciesGrantingServiceAccessResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("PoliciesGrantingServiceAccess") /* PoliciesGrantingServiceAccess com.amazonaws.iam.synthetic#ListPoliciesGrantingServiceAccessOutput$PoliciesGrantingServiceAccess */ =>  {
                let var_163 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_list_policy_granting_service_access_response_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_policies_granting_service_access(var_163);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#ListPoliciesGrantingServiceAccessOutput$IsTruncated */ =>  {
                let var_164 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_164);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#ListPoliciesGrantingServiceAccessOutput$Marker */ =>  {
                let var_165 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_165);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListPoliciesGrantingServiceAccessResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_policy_tags(
    inp: &[u8],
    mut builder: crate::output::list_policy_tags_output::Builder,
) -> Result<crate::output::list_policy_tags_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListPolicyTagsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListPolicyTagsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListPolicyTagsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListPolicyTagsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Tags") /* Tags com.amazonaws.iam.synthetic#ListPolicyTagsOutput$Tags */ =>  {
                let var_166 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_tag_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_166);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#ListPolicyTagsOutput$IsTruncated */ =>  {
                let var_167 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_167);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#ListPolicyTagsOutput$Marker */ =>  {
                let var_168 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_168);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListPolicyTagsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_policy_versions(
    inp: &[u8],
    mut builder: crate::output::list_policy_versions_output::Builder,
) -> Result<crate::output::list_policy_versions_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListPolicyVersionsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListPolicyVersionsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListPolicyVersionsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListPolicyVersionsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Versions") /* Versions com.amazonaws.iam.synthetic#ListPolicyVersionsOutput$Versions */ =>  {
                let var_169 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_policy_document_version_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_versions(var_169);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#ListPolicyVersionsOutput$IsTruncated */ =>  {
                let var_170 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_170);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#ListPolicyVersionsOutput$Marker */ =>  {
                let var_171 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_171);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListPolicyVersionsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_role_policies(
    inp: &[u8],
    mut builder: crate::output::list_role_policies_output::Builder,
) -> Result<crate::output::list_role_policies_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListRolePoliciesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListRolePoliciesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListRolePoliciesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListRolePoliciesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("PolicyNames") /* PolicyNames com.amazonaws.iam.synthetic#ListRolePoliciesOutput$PolicyNames */ =>  {
                let var_172 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_policy_name_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_policy_names(var_172);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#ListRolePoliciesOutput$IsTruncated */ =>  {
                let var_173 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_173);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#ListRolePoliciesOutput$Marker */ =>  {
                let var_174 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_174);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListRolePoliciesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_roles(
    inp: &[u8],
    mut builder: crate::output::list_roles_output::Builder,
) -> Result<crate::output::list_roles_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListRolesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListRolesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListRolesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListRolesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Roles") /* Roles com.amazonaws.iam.synthetic#ListRolesOutput$Roles */ =>  {
                let var_175 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_role_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_roles(var_175);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#ListRolesOutput$IsTruncated */ =>  {
                let var_176 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_176);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#ListRolesOutput$Marker */ =>  {
                let var_177 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_177);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListRolesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_role_tags(
    inp: &[u8],
    mut builder: crate::output::list_role_tags_output::Builder,
) -> Result<crate::output::list_role_tags_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListRoleTagsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListRoleTagsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListRoleTagsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListRoleTagsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Tags") /* Tags com.amazonaws.iam.synthetic#ListRoleTagsOutput$Tags */ =>  {
                let var_178 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_tag_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_178);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#ListRoleTagsOutput$IsTruncated */ =>  {
                let var_179 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_179);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#ListRoleTagsOutput$Marker */ =>  {
                let var_180 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_180);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListRoleTagsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_saml_providers(
    inp: &[u8],
    mut builder: crate::output::list_saml_providers_output::Builder,
) -> Result<crate::output::list_saml_providers_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListSAMLProvidersResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListSAMLProvidersResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListSAMLProvidersResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListSAMLProvidersResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("SAMLProviderList") /* SAMLProviderList com.amazonaws.iam.synthetic#ListSAMLProvidersOutput$SAMLProviderList */ =>  {
                let var_181 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_saml_provider_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_saml_provider_list(var_181);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListSAMLProvidersResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_saml_provider_tags(
    inp: &[u8],
    mut builder: crate::output::list_saml_provider_tags_output::Builder,
) -> Result<crate::output::list_saml_provider_tags_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListSAMLProviderTagsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListSAMLProviderTagsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListSAMLProviderTagsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListSAMLProviderTagsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Tags") /* Tags com.amazonaws.iam.synthetic#ListSAMLProviderTagsOutput$Tags */ =>  {
                let var_182 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_tag_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_182);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#ListSAMLProviderTagsOutput$IsTruncated */ =>  {
                let var_183 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_183);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#ListSAMLProviderTagsOutput$Marker */ =>  {
                let var_184 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_184);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListSAMLProviderTagsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_server_certificates(
    inp: &[u8],
    mut builder: crate::output::list_server_certificates_output::Builder,
) -> Result<crate::output::list_server_certificates_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListServerCertificatesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListServerCertificatesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListServerCertificatesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListServerCertificatesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ServerCertificateMetadataList") /* ServerCertificateMetadataList com.amazonaws.iam.synthetic#ListServerCertificatesOutput$ServerCertificateMetadataList */ =>  {
                let var_185 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_server_certificate_metadata_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_server_certificate_metadata_list(var_185);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#ListServerCertificatesOutput$IsTruncated */ =>  {
                let var_186 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_186);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#ListServerCertificatesOutput$Marker */ =>  {
                let var_187 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_187);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListServerCertificatesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_server_certificate_tags(
    inp: &[u8],
    mut builder: crate::output::list_server_certificate_tags_output::Builder,
) -> Result<
    crate::output::list_server_certificate_tags_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListServerCertificateTagsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListServerCertificateTagsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListServerCertificateTagsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListServerCertificateTagsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Tags") /* Tags com.amazonaws.iam.synthetic#ListServerCertificateTagsOutput$Tags */ =>  {
                let var_188 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_tag_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_188);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#ListServerCertificateTagsOutput$IsTruncated */ =>  {
                let var_189 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_189);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#ListServerCertificateTagsOutput$Marker */ =>  {
                let var_190 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_190);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListServerCertificateTagsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_service_specific_credentials(
    inp: &[u8],
    mut builder: crate::output::list_service_specific_credentials_output::Builder,
) -> Result<
    crate::output::list_service_specific_credentials_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListServiceSpecificCredentialsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListServiceSpecificCredentialsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListServiceSpecificCredentialsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListServiceSpecificCredentialsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ServiceSpecificCredentials") /* ServiceSpecificCredentials com.amazonaws.iam.synthetic#ListServiceSpecificCredentialsOutput$ServiceSpecificCredentials */ =>  {
                let var_191 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_service_specific_credentials_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_service_specific_credentials(var_191);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListServiceSpecificCredentialsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_signing_certificates(
    inp: &[u8],
    mut builder: crate::output::list_signing_certificates_output::Builder,
) -> Result<
    crate::output::list_signing_certificates_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListSigningCertificatesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListSigningCertificatesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListSigningCertificatesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListSigningCertificatesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Certificates") /* Certificates com.amazonaws.iam.synthetic#ListSigningCertificatesOutput$Certificates */ =>  {
                let var_192 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_certificate_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_certificates(var_192);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#ListSigningCertificatesOutput$IsTruncated */ =>  {
                let var_193 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_193);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#ListSigningCertificatesOutput$Marker */ =>  {
                let var_194 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_194);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListSigningCertificatesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_ssh_public_keys(
    inp: &[u8],
    mut builder: crate::output::list_ssh_public_keys_output::Builder,
) -> Result<crate::output::list_ssh_public_keys_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListSSHPublicKeysResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListSSHPublicKeysResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListSSHPublicKeysResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListSSHPublicKeysResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("SSHPublicKeys") /* SSHPublicKeys com.amazonaws.iam.synthetic#ListSSHPublicKeysOutput$SSHPublicKeys */ =>  {
                let var_195 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_ssh_public_key_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ssh_public_keys(var_195);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#ListSSHPublicKeysOutput$IsTruncated */ =>  {
                let var_196 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_196);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#ListSSHPublicKeysOutput$Marker */ =>  {
                let var_197 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_197);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListSSHPublicKeysResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_user_policies(
    inp: &[u8],
    mut builder: crate::output::list_user_policies_output::Builder,
) -> Result<crate::output::list_user_policies_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListUserPoliciesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListUserPoliciesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListUserPoliciesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListUserPoliciesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("PolicyNames") /* PolicyNames com.amazonaws.iam.synthetic#ListUserPoliciesOutput$PolicyNames */ =>  {
                let var_198 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_policy_name_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_policy_names(var_198);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#ListUserPoliciesOutput$IsTruncated */ =>  {
                let var_199 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_199);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#ListUserPoliciesOutput$Marker */ =>  {
                let var_200 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_200);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListUserPoliciesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_users(
    inp: &[u8],
    mut builder: crate::output::list_users_output::Builder,
) -> Result<crate::output::list_users_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListUsersResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListUsersResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListUsersResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListUsersResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Users") /* Users com.amazonaws.iam.synthetic#ListUsersOutput$Users */ =>  {
                let var_201 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_user_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_users(var_201);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#ListUsersOutput$IsTruncated */ =>  {
                let var_202 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_202);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#ListUsersOutput$Marker */ =>  {
                let var_203 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_203);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListUsersResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_user_tags(
    inp: &[u8],
    mut builder: crate::output::list_user_tags_output::Builder,
) -> Result<crate::output::list_user_tags_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListUserTagsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListUserTagsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListUserTagsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListUserTagsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Tags") /* Tags com.amazonaws.iam.synthetic#ListUserTagsOutput$Tags */ =>  {
                let var_204 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_tag_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_204);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#ListUserTagsOutput$IsTruncated */ =>  {
                let var_205 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_205);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#ListUserTagsOutput$Marker */ =>  {
                let var_206 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_206);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListUserTagsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_virtual_mfa_devices(
    inp: &[u8],
    mut builder: crate::output::list_virtual_mfa_devices_output::Builder,
) -> Result<crate::output::list_virtual_mfa_devices_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListVirtualMFADevicesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListVirtualMFADevicesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListVirtualMFADevicesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListVirtualMFADevicesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("VirtualMFADevices") /* VirtualMFADevices com.amazonaws.iam.synthetic#ListVirtualMFADevicesOutput$VirtualMFADevices */ =>  {
                let var_207 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_virtual_mfa_device_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_virtual_mfa_devices(var_207);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#ListVirtualMFADevicesOutput$IsTruncated */ =>  {
                let var_208 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_208);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#ListVirtualMFADevicesOutput$Marker */ =>  {
                let var_209 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_209);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListVirtualMFADevicesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_reset_service_specific_credential(
    inp: &[u8],
    mut builder: crate::output::reset_service_specific_credential_output::Builder,
) -> Result<
    crate::output::reset_service_specific_credential_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ResetServiceSpecificCredentialResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ResetServiceSpecificCredentialResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ResetServiceSpecificCredentialResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ResetServiceSpecificCredentialResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ServiceSpecificCredential") /* ServiceSpecificCredential com.amazonaws.iam.synthetic#ResetServiceSpecificCredentialOutput$ServiceSpecificCredential */ =>  {
                let var_210 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_service_specific_credential(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_service_specific_credential(var_210);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ResetServiceSpecificCredentialResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_policy_evaluation_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::policy_evaluation_exception::Builder,
) -> Result<crate::error::policy_evaluation_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.iam#PolicyEvaluationException$message */ =>  {
                let var_211 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_211);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_simulate_custom_policy(
    inp: &[u8],
    mut builder: crate::output::simulate_custom_policy_output::Builder,
) -> Result<crate::output::simulate_custom_policy_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("SimulateCustomPolicyResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected SimulateCustomPolicyResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("SimulateCustomPolicyResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected SimulateCustomPolicyResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("EvaluationResults") /* EvaluationResults com.amazonaws.iam.synthetic#SimulateCustomPolicyOutput$EvaluationResults */ =>  {
                let var_212 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_evaluation_results_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_evaluation_results(var_212);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#SimulateCustomPolicyOutput$IsTruncated */ =>  {
                let var_213 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_213);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#SimulateCustomPolicyOutput$Marker */ =>  {
                let var_214 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_214);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected SimulateCustomPolicyResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_simulate_principal_policy(
    inp: &[u8],
    mut builder: crate::output::simulate_principal_policy_output::Builder,
) -> Result<
    crate::output::simulate_principal_policy_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("SimulatePrincipalPolicyResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected SimulatePrincipalPolicyResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("SimulatePrincipalPolicyResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected SimulatePrincipalPolicyResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("EvaluationResults") /* EvaluationResults com.amazonaws.iam.synthetic#SimulatePrincipalPolicyOutput$EvaluationResults */ =>  {
                let var_215 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_evaluation_results_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_evaluation_results(var_215);
            }
            ,
            s if s.matches("IsTruncated") /* IsTruncated com.amazonaws.iam.synthetic#SimulatePrincipalPolicyOutput$IsTruncated */ =>  {
                let var_216 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_truncated(var_216);
            }
            ,
            s if s.matches("Marker") /* Marker com.amazonaws.iam.synthetic#SimulatePrincipalPolicyOutput$Marker */ =>  {
                let var_217 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_marker(var_217);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected SimulatePrincipalPolicyResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_update_role_description(
    inp: &[u8],
    mut builder: crate::output::update_role_description_output::Builder,
) -> Result<crate::output::update_role_description_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("UpdateRoleDescriptionResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected UpdateRoleDescriptionResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("UpdateRoleDescriptionResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected UpdateRoleDescriptionResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Role") /* Role com.amazonaws.iam.synthetic#UpdateRoleDescriptionOutput$Role */ =>  {
                let var_218 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_role(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_role(var_218);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected UpdateRoleDescriptionResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_update_saml_provider(
    inp: &[u8],
    mut builder: crate::output::update_saml_provider_output::Builder,
) -> Result<crate::output::update_saml_provider_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("UpdateSAMLProviderResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected UpdateSAMLProviderResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("UpdateSAMLProviderResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected UpdateSAMLProviderResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("SAMLProviderArn") /* SAMLProviderArn com.amazonaws.iam.synthetic#UpdateSAMLProviderOutput$SAMLProviderArn */ =>  {
                let var_219 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_saml_provider_arn(var_219);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected UpdateSAMLProviderResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_key_pair_mismatch_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::key_pair_mismatch_exception::Builder,
) -> Result<crate::error::key_pair_mismatch_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.iam#KeyPairMismatchException$message */ =>  {
                let var_220 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_220);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_malformed_certificate_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::malformed_certificate_exception::Builder,
) -> Result<crate::error::malformed_certificate_exception::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.iam#MalformedCertificateException$message */ =>  {
                let var_221 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_221);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_upload_server_certificate(
    inp: &[u8],
    mut builder: crate::output::upload_server_certificate_output::Builder,
) -> Result<
    crate::output::upload_server_certificate_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("UploadServerCertificateResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected UploadServerCertificateResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("UploadServerCertificateResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected UploadServerCertificateResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("ServerCertificateMetadata") /* ServerCertificateMetadata com.amazonaws.iam.synthetic#UploadServerCertificateOutput$ServerCertificateMetadata */ =>  {
                let var_222 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_server_certificate_metadata(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_server_certificate_metadata(var_222);
            }
            ,
            s if s.matches("Tags") /* Tags com.amazonaws.iam.synthetic#UploadServerCertificateOutput$Tags */ =>  {
                let var_223 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_tag_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_223);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected UploadServerCertificateResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_duplicate_certificate_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::duplicate_certificate_exception::Builder,
) -> Result<crate::error::duplicate_certificate_exception::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.iam#DuplicateCertificateException$message */ =>  {
                let var_224 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_224);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_certificate_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_certificate_exception::Builder,
) -> Result<crate::error::invalid_certificate_exception::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.iam#InvalidCertificateException$message */ =>  {
                let var_225 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_225);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_upload_signing_certificate(
    inp: &[u8],
    mut builder: crate::output::upload_signing_certificate_output::Builder,
) -> Result<
    crate::output::upload_signing_certificate_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("UploadSigningCertificateResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected UploadSigningCertificateResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("UploadSigningCertificateResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected UploadSigningCertificateResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Certificate") /* Certificate com.amazonaws.iam.synthetic#UploadSigningCertificateOutput$Certificate */ =>  {
                let var_226 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_signing_certificate(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_certificate(var_226);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected UploadSigningCertificateResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_duplicate_ssh_public_key_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::duplicate_ssh_public_key_exception::Builder,
) -> Result<
    crate::error::duplicate_ssh_public_key_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.iam#DuplicateSSHPublicKeyException$message */ =>  {
                let var_227 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_227);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_public_key_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_public_key_exception::Builder,
) -> Result<crate::error::invalid_public_key_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.iam#InvalidPublicKeyException$message */ =>  {
                let var_228 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_228);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_upload_ssh_public_key(
    inp: &[u8],
    mut builder: crate::output::upload_ssh_public_key_output::Builder,
) -> Result<crate::output::upload_ssh_public_key_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("UploadSSHPublicKeyResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected UploadSSHPublicKeyResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("UploadSSHPublicKeyResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected UploadSSHPublicKeyResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("SSHPublicKey") /* SSHPublicKey com.amazonaws.iam.synthetic#UploadSSHPublicKeyOutput$SSHPublicKey */ =>  {
                let var_229 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_ssh_public_key(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ssh_public_key(var_229);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected UploadSSHPublicKeyResult tag",
        ));
    };
    Ok(builder)
}

pub fn deser_structure_crate_model_access_key(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AccessKey, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AccessKey::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("UserName") /* UserName com.amazonaws.iam#AccessKey$UserName */ =>  {
                let var_230 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_user_name(var_230);
            }
            ,
            s if s.matches("AccessKeyId") /* AccessKeyId com.amazonaws.iam#AccessKey$AccessKeyId */ =>  {
                let var_231 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_access_key_id(var_231);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.iam#AccessKey$Status */ =>  {
                let var_232 =
                    Some(
                        Result::<crate::model::StatusType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::StatusType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_232);
            }
            ,
            s if s.matches("SecretAccessKey") /* SecretAccessKey com.amazonaws.iam#AccessKey$SecretAccessKey */ =>  {
                let var_233 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_secret_access_key(var_233);
            }
            ,
            s if s.matches("CreateDate") /* CreateDate com.amazonaws.iam#AccessKey$CreateDate */ =>  {
                let var_234 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_create_date(var_234);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_group(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Group, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Group::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Path") /* Path com.amazonaws.iam#Group$Path */ =>  {
                let var_235 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_path(var_235);
            }
            ,
            s if s.matches("GroupName") /* GroupName com.amazonaws.iam#Group$GroupName */ =>  {
                let var_236 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_group_name(var_236);
            }
            ,
            s if s.matches("GroupId") /* GroupId com.amazonaws.iam#Group$GroupId */ =>  {
                let var_237 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_group_id(var_237);
            }
            ,
            s if s.matches("Arn") /* Arn com.amazonaws.iam#Group$Arn */ =>  {
                let var_238 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_arn(var_238);
            }
            ,
            s if s.matches("CreateDate") /* CreateDate com.amazonaws.iam#Group$CreateDate */ =>  {
                let var_239 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_create_date(var_239);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_instance_profile(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::InstanceProfile, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::InstanceProfile::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Path") /* Path com.amazonaws.iam#InstanceProfile$Path */ =>  {
                let var_240 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_path(var_240);
            }
            ,
            s if s.matches("InstanceProfileName") /* InstanceProfileName com.amazonaws.iam#InstanceProfile$InstanceProfileName */ =>  {
                let var_241 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_instance_profile_name(var_241);
            }
            ,
            s if s.matches("InstanceProfileId") /* InstanceProfileId com.amazonaws.iam#InstanceProfile$InstanceProfileId */ =>  {
                let var_242 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_instance_profile_id(var_242);
            }
            ,
            s if s.matches("Arn") /* Arn com.amazonaws.iam#InstanceProfile$Arn */ =>  {
                let var_243 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_arn(var_243);
            }
            ,
            s if s.matches("CreateDate") /* CreateDate com.amazonaws.iam#InstanceProfile$CreateDate */ =>  {
                let var_244 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_create_date(var_244);
            }
            ,
            s if s.matches("Roles") /* Roles com.amazonaws.iam#InstanceProfile$Roles */ =>  {
                let var_245 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_role_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_roles(var_245);
            }
            ,
            s if s.matches("Tags") /* Tags com.amazonaws.iam#InstanceProfile$Tags */ =>  {
                let var_246 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_tag_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_246);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_login_profile(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::LoginProfile, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::LoginProfile::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("UserName") /* UserName com.amazonaws.iam#LoginProfile$UserName */ =>  {
                let var_247 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_user_name(var_247);
            }
            ,
            s if s.matches("CreateDate") /* CreateDate com.amazonaws.iam#LoginProfile$CreateDate */ =>  {
                let var_248 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_create_date(var_248);
            }
            ,
            s if s.matches("PasswordResetRequired") /* PasswordResetRequired com.amazonaws.iam#LoginProfile$PasswordResetRequired */ =>  {
                let var_249 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_password_reset_required(var_249);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_iam_tag_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::Tag>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#tagListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_tag(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_policy(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Policy, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Policy::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("PolicyName") /* PolicyName com.amazonaws.iam#Policy$PolicyName */ =>  {
                let var_250 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_policy_name(var_250);
            }
            ,
            s if s.matches("PolicyId") /* PolicyId com.amazonaws.iam#Policy$PolicyId */ =>  {
                let var_251 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_policy_id(var_251);
            }
            ,
            s if s.matches("Arn") /* Arn com.amazonaws.iam#Policy$Arn */ =>  {
                let var_252 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_arn(var_252);
            }
            ,
            s if s.matches("Path") /* Path com.amazonaws.iam#Policy$Path */ =>  {
                let var_253 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_path(var_253);
            }
            ,
            s if s.matches("DefaultVersionId") /* DefaultVersionId com.amazonaws.iam#Policy$DefaultVersionId */ =>  {
                let var_254 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_default_version_id(var_254);
            }
            ,
            s if s.matches("AttachmentCount") /* AttachmentCount com.amazonaws.iam#Policy$AttachmentCount */ =>  {
                let var_255 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.iam#attachmentCountType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_attachment_count(var_255);
            }
            ,
            s if s.matches("PermissionsBoundaryUsageCount") /* PermissionsBoundaryUsageCount com.amazonaws.iam#Policy$PermissionsBoundaryUsageCount */ =>  {
                let var_256 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.iam#attachmentCountType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_permissions_boundary_usage_count(var_256);
            }
            ,
            s if s.matches("IsAttachable") /* IsAttachable com.amazonaws.iam#Policy$IsAttachable */ =>  {
                let var_257 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_attachable(var_257);
            }
            ,
            s if s.matches("Description") /* Description com.amazonaws.iam#Policy$Description */ =>  {
                let var_258 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_description(var_258);
            }
            ,
            s if s.matches("CreateDate") /* CreateDate com.amazonaws.iam#Policy$CreateDate */ =>  {
                let var_259 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_create_date(var_259);
            }
            ,
            s if s.matches("UpdateDate") /* UpdateDate com.amazonaws.iam#Policy$UpdateDate */ =>  {
                let var_260 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_update_date(var_260);
            }
            ,
            s if s.matches("Tags") /* Tags com.amazonaws.iam#Policy$Tags */ =>  {
                let var_261 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_tag_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_261);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_policy_version(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::PolicyVersion, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::PolicyVersion::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Document") /* Document com.amazonaws.iam#PolicyVersion$Document */ =>  {
                let var_262 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_document(var_262);
            }
            ,
            s if s.matches("VersionId") /* VersionId com.amazonaws.iam#PolicyVersion$VersionId */ =>  {
                let var_263 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_version_id(var_263);
            }
            ,
            s if s.matches("IsDefaultVersion") /* IsDefaultVersion com.amazonaws.iam#PolicyVersion$IsDefaultVersion */ =>  {
                let var_264 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_default_version(var_264);
            }
            ,
            s if s.matches("CreateDate") /* CreateDate com.amazonaws.iam#PolicyVersion$CreateDate */ =>  {
                let var_265 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_create_date(var_265);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_role(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Role, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Role::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Path") /* Path com.amazonaws.iam#Role$Path */ =>  {
                let var_266 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_path(var_266);
            }
            ,
            s if s.matches("RoleName") /* RoleName com.amazonaws.iam#Role$RoleName */ =>  {
                let var_267 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_role_name(var_267);
            }
            ,
            s if s.matches("RoleId") /* RoleId com.amazonaws.iam#Role$RoleId */ =>  {
                let var_268 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_role_id(var_268);
            }
            ,
            s if s.matches("Arn") /* Arn com.amazonaws.iam#Role$Arn */ =>  {
                let var_269 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_arn(var_269);
            }
            ,
            s if s.matches("CreateDate") /* CreateDate com.amazonaws.iam#Role$CreateDate */ =>  {
                let var_270 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_create_date(var_270);
            }
            ,
            s if s.matches("AssumeRolePolicyDocument") /* AssumeRolePolicyDocument com.amazonaws.iam#Role$AssumeRolePolicyDocument */ =>  {
                let var_271 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_assume_role_policy_document(var_271);
            }
            ,
            s if s.matches("Description") /* Description com.amazonaws.iam#Role$Description */ =>  {
                let var_272 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_description(var_272);
            }
            ,
            s if s.matches("MaxSessionDuration") /* MaxSessionDuration com.amazonaws.iam#Role$MaxSessionDuration */ =>  {
                let var_273 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.iam#roleMaxSessionDurationType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_max_session_duration(var_273);
            }
            ,
            s if s.matches("PermissionsBoundary") /* PermissionsBoundary com.amazonaws.iam#Role$PermissionsBoundary */ =>  {
                let var_274 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_attached_permissions_boundary(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_permissions_boundary(var_274);
            }
            ,
            s if s.matches("Tags") /* Tags com.amazonaws.iam#Role$Tags */ =>  {
                let var_275 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_tag_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_275);
            }
            ,
            s if s.matches("RoleLastUsed") /* RoleLastUsed com.amazonaws.iam#Role$RoleLastUsed */ =>  {
                let var_276 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_role_last_used(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_role_last_used(var_276);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_service_specific_credential(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ServiceSpecificCredential, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ServiceSpecificCredential::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("CreateDate") /* CreateDate com.amazonaws.iam#ServiceSpecificCredential$CreateDate */ =>  {
                let var_277 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_create_date(var_277);
            }
            ,
            s if s.matches("ServiceName") /* ServiceName com.amazonaws.iam#ServiceSpecificCredential$ServiceName */ =>  {
                let var_278 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_service_name(var_278);
            }
            ,
            s if s.matches("ServiceUserName") /* ServiceUserName com.amazonaws.iam#ServiceSpecificCredential$ServiceUserName */ =>  {
                let var_279 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_service_user_name(var_279);
            }
            ,
            s if s.matches("ServicePassword") /* ServicePassword com.amazonaws.iam#ServiceSpecificCredential$ServicePassword */ =>  {
                let var_280 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_service_password(var_280);
            }
            ,
            s if s.matches("ServiceSpecificCredentialId") /* ServiceSpecificCredentialId com.amazonaws.iam#ServiceSpecificCredential$ServiceSpecificCredentialId */ =>  {
                let var_281 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_service_specific_credential_id(var_281);
            }
            ,
            s if s.matches("UserName") /* UserName com.amazonaws.iam#ServiceSpecificCredential$UserName */ =>  {
                let var_282 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_user_name(var_282);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.iam#ServiceSpecificCredential$Status */ =>  {
                let var_283 =
                    Some(
                        Result::<crate::model::StatusType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::StatusType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_283);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_user(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::User, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::User::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Path") /* Path com.amazonaws.iam#User$Path */ =>  {
                let var_284 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_path(var_284);
            }
            ,
            s if s.matches("UserName") /* UserName com.amazonaws.iam#User$UserName */ =>  {
                let var_285 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_user_name(var_285);
            }
            ,
            s if s.matches("UserId") /* UserId com.amazonaws.iam#User$UserId */ =>  {
                let var_286 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_user_id(var_286);
            }
            ,
            s if s.matches("Arn") /* Arn com.amazonaws.iam#User$Arn */ =>  {
                let var_287 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_arn(var_287);
            }
            ,
            s if s.matches("CreateDate") /* CreateDate com.amazonaws.iam#User$CreateDate */ =>  {
                let var_288 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_create_date(var_288);
            }
            ,
            s if s.matches("PasswordLastUsed") /* PasswordLastUsed com.amazonaws.iam#User$PasswordLastUsed */ =>  {
                let var_289 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_password_last_used(var_289);
            }
            ,
            s if s.matches("PermissionsBoundary") /* PermissionsBoundary com.amazonaws.iam#User$PermissionsBoundary */ =>  {
                let var_290 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_attached_permissions_boundary(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_permissions_boundary(var_290);
            }
            ,
            s if s.matches("Tags") /* Tags com.amazonaws.iam#User$Tags */ =>  {
                let var_291 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_tag_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_291);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_virtual_mfa_device(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::VirtualMfaDevice, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::VirtualMfaDevice::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("SerialNumber") /* SerialNumber com.amazonaws.iam#VirtualMFADevice$SerialNumber */ =>  {
                let var_292 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_serial_number(var_292);
            }
            ,
            s if s.matches("Base32StringSeed") /* Base32StringSeed com.amazonaws.iam#VirtualMFADevice$Base32StringSeed */ =>  {
                let var_293 =
                    Some(
                        aws_smithy_types::base64::decode(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        )
                        .map_err(|err|aws_smithy_xml::decode::XmlError::custom(format!("invalid base64: {:?}", err))).map(aws_smithy_types::Blob::new)
                        ?
                    )
                ;
                builder = builder.set_base32_string_seed(var_293);
            }
            ,
            s if s.matches("QRCodePNG") /* QRCodePNG com.amazonaws.iam#VirtualMFADevice$QRCodePNG */ =>  {
                let var_294 =
                    Some(
                        aws_smithy_types::base64::decode(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        )
                        .map_err(|err|aws_smithy_xml::decode::XmlError::custom(format!("invalid base64: {:?}", err))).map(aws_smithy_types::Blob::new)
                        ?
                    )
                ;
                builder = builder.set_qr_code_png(var_294);
            }
            ,
            s if s.matches("User") /* User com.amazonaws.iam#VirtualMFADevice$User */ =>  {
                let var_295 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_user(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_user(var_295);
            }
            ,
            s if s.matches("EnableDate") /* EnableDate com.amazonaws.iam#VirtualMFADevice$EnableDate */ =>  {
                let var_296 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_enable_date(var_296);
            }
            ,
            s if s.matches("Tags") /* Tags com.amazonaws.iam#VirtualMFADevice$Tags */ =>  {
                let var_297 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_tag_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_297);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_access_key_last_used(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AccessKeyLastUsed, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AccessKeyLastUsed::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("LastUsedDate") /* LastUsedDate com.amazonaws.iam#AccessKeyLastUsed$LastUsedDate */ =>  {
                let var_298 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_last_used_date(var_298);
            }
            ,
            s if s.matches("ServiceName") /* ServiceName com.amazonaws.iam#AccessKeyLastUsed$ServiceName */ =>  {
                let var_299 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_service_name(var_299);
            }
            ,
            s if s.matches("Region") /* Region com.amazonaws.iam#AccessKeyLastUsed$Region */ =>  {
                let var_300 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_region(var_300);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_iam_user_detail_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::UserDetail>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#userDetailListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_user_detail(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_group_detail_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::GroupDetail>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#groupDetailListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_group_detail(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_role_detail_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::RoleDetail>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#roleDetailListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_role_detail(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_managed_policy_detail_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::ManagedPolicyDetail>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#ManagedPolicyDetailListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_managed_policy_detail(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_password_policy(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::PasswordPolicy, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::PasswordPolicy::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("MinimumPasswordLength") /* MinimumPasswordLength com.amazonaws.iam#PasswordPolicy$MinimumPasswordLength */ =>  {
                let var_301 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.iam#minimumPasswordLengthType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_minimum_password_length(var_301);
            }
            ,
            s if s.matches("RequireSymbols") /* RequireSymbols com.amazonaws.iam#PasswordPolicy$RequireSymbols */ =>  {
                let var_302 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_require_symbols(var_302);
            }
            ,
            s if s.matches("RequireNumbers") /* RequireNumbers com.amazonaws.iam#PasswordPolicy$RequireNumbers */ =>  {
                let var_303 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_require_numbers(var_303);
            }
            ,
            s if s.matches("RequireUppercaseCharacters") /* RequireUppercaseCharacters com.amazonaws.iam#PasswordPolicy$RequireUppercaseCharacters */ =>  {
                let var_304 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_require_uppercase_characters(var_304);
            }
            ,
            s if s.matches("RequireLowercaseCharacters") /* RequireLowercaseCharacters com.amazonaws.iam#PasswordPolicy$RequireLowercaseCharacters */ =>  {
                let var_305 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_require_lowercase_characters(var_305);
            }
            ,
            s if s.matches("AllowUsersToChangePassword") /* AllowUsersToChangePassword com.amazonaws.iam#PasswordPolicy$AllowUsersToChangePassword */ =>  {
                let var_306 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_allow_users_to_change_password(var_306);
            }
            ,
            s if s.matches("ExpirePasswords") /* ExpirePasswords com.amazonaws.iam#PasswordPolicy$ExpirePasswords */ =>  {
                let var_307 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_expire_passwords(var_307);
            }
            ,
            s if s.matches("MaxPasswordAge") /* MaxPasswordAge com.amazonaws.iam#PasswordPolicy$MaxPasswordAge */ =>  {
                let var_308 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.iam#maxPasswordAgeType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_max_password_age(var_308);
            }
            ,
            s if s.matches("PasswordReusePrevention") /* PasswordReusePrevention com.amazonaws.iam#PasswordPolicy$PasswordReusePrevention */ =>  {
                let var_309 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.iam#passwordReusePreventionType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_password_reuse_prevention(var_309);
            }
            ,
            s if s.matches("HardExpiry") /* HardExpiry com.amazonaws.iam#PasswordPolicy$HardExpiry */ =>  {
                let var_310 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanObjectType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_hard_expiry(var_310);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_map_com_amazonaws_iam_summary_map_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::collections::HashMap<crate::model::SummaryKeyType, i32>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::collections::HashMap::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("entry") => {
                crate::xml_deser::deser_map_com_amazonaws_iam_summary_map_type_entry(
                    &mut tag, &mut out,
                )?;
            }
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_context_key_names_result_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#ContextKeyNamesResultListType$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_user_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::User>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#userListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_user(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_client_id_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#clientIDListType$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_thumbprint_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#thumbprintListType$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_access_details(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::AccessDetail>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#AccessDetails$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_access_detail(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_error_details(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ErrorDetails, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ErrorDetails::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Message") /* Message com.amazonaws.iam#ErrorDetails$Message */ =>  {
                let var_311 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_311);
            }
            ,
            s if s.matches("Code") /* Code com.amazonaws.iam#ErrorDetails$Code */ =>  {
                let var_312 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_code(var_312);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_server_certificate(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ServerCertificate, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ServerCertificate::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ServerCertificateMetadata") /* ServerCertificateMetadata com.amazonaws.iam#ServerCertificate$ServerCertificateMetadata */ =>  {
                let var_313 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_server_certificate_metadata(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_server_certificate_metadata(var_313);
            }
            ,
            s if s.matches("CertificateBody") /* CertificateBody com.amazonaws.iam#ServerCertificate$CertificateBody */ =>  {
                let var_314 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_certificate_body(var_314);
            }
            ,
            s if s.matches("CertificateChain") /* CertificateChain com.amazonaws.iam#ServerCertificate$CertificateChain */ =>  {
                let var_315 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_certificate_chain(var_315);
            }
            ,
            s if s.matches("Tags") /* Tags com.amazonaws.iam#ServerCertificate$Tags */ =>  {
                let var_316 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_tag_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_316);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_iam_services_last_accessed(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::ServiceLastAccessed>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#ServicesLastAccessed$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_service_last_accessed(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_entity_details_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::EntityDetails>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#entityDetailsListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_entity_details(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_deletion_task_failure_reason_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::DeletionTaskFailureReasonType, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::DeletionTaskFailureReasonType::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Reason") /* Reason com.amazonaws.iam#DeletionTaskFailureReasonType$Reason */ =>  {
                let var_317 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_reason(var_317);
            }
            ,
            s if s.matches("RoleUsageList") /* RoleUsageList com.amazonaws.iam#DeletionTaskFailureReasonType$RoleUsageList */ =>  {
                let var_318 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_role_usage_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_role_usage_list(var_318);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_ssh_public_key(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::SshPublicKey, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::SshPublicKey::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("UserName") /* UserName com.amazonaws.iam#SSHPublicKey$UserName */ =>  {
                let var_319 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_user_name(var_319);
            }
            ,
            s if s.matches("SSHPublicKeyId") /* SSHPublicKeyId com.amazonaws.iam#SSHPublicKey$SSHPublicKeyId */ =>  {
                let var_320 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_ssh_public_key_id(var_320);
            }
            ,
            s if s.matches("Fingerprint") /* Fingerprint com.amazonaws.iam#SSHPublicKey$Fingerprint */ =>  {
                let var_321 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_fingerprint(var_321);
            }
            ,
            s if s.matches("SSHPublicKeyBody") /* SSHPublicKeyBody com.amazonaws.iam#SSHPublicKey$SSHPublicKeyBody */ =>  {
                let var_322 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_ssh_public_key_body(var_322);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.iam#SSHPublicKey$Status */ =>  {
                let var_323 =
                    Some(
                        Result::<crate::model::StatusType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::StatusType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_323);
            }
            ,
            s if s.matches("UploadDate") /* UploadDate com.amazonaws.iam#SSHPublicKey$UploadDate */ =>  {
                let var_324 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_upload_date(var_324);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_iam_access_key_metadata_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::AccessKeyMetadata>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#accessKeyMetadataListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_access_key_metadata(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_account_alias_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#accountAliasListType$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_attached_policies_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::AttachedPolicy>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#attachedPoliciesListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_attached_policy(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_policy_group_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::PolicyGroup>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#PolicyGroupListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_policy_group(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_policy_user_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::PolicyUser>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#PolicyUserListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_policy_user(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_policy_role_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::PolicyRole>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#PolicyRoleListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_policy_role(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_policy_name_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#policyNameListType$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_group_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::Group>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#groupListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_group(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_instance_profile_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::InstanceProfile>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#instanceProfileListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_instance_profile(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_mfa_device_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::MfaDevice>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#mfaDeviceListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_mfa_device(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_open_id_connect_provider_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::vec::Vec<crate::model::OpenIdConnectProviderListEntry>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#OpenIDConnectProviderListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_open_id_connect_provider_list_entry(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_policy_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::Policy>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#policyListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_policy(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_list_policy_granting_service_access_response_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::vec::Vec<crate::model::ListPoliciesGrantingServiceAccessEntry>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#listPolicyGrantingServiceAccessResponseListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_list_policies_granting_service_access_entry(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_policy_document_version_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::PolicyVersion>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#policyDocumentVersionListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_policy_version(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_role_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::Role>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#roleListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_role(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_saml_provider_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::SamlProviderListEntry>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#SAMLProviderListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_saml_provider_list_entry(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_server_certificate_metadata_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::ServerCertificateMetadata>, aws_smithy_xml::decode::XmlError>
{
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#serverCertificateMetadataListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_server_certificate_metadata(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_service_specific_credentials_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::vec::Vec<crate::model::ServiceSpecificCredentialMetadata>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#ServiceSpecificCredentialsListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_service_specific_credential_metadata(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_certificate_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::SigningCertificate>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#certificateListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_signing_certificate(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_ssh_public_key_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::SshPublicKeyMetadata>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#SSHPublicKeyListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_ssh_public_key_metadata(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_virtual_mfa_device_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::VirtualMfaDevice>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#virtualMFADeviceListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_virtual_mfa_device(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_evaluation_results_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::EvaluationResult>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#EvaluationResultsListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_evaluation_result(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_server_certificate_metadata(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ServerCertificateMetadata, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ServerCertificateMetadata::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Path") /* Path com.amazonaws.iam#ServerCertificateMetadata$Path */ =>  {
                let var_325 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_path(var_325);
            }
            ,
            s if s.matches("ServerCertificateName") /* ServerCertificateName com.amazonaws.iam#ServerCertificateMetadata$ServerCertificateName */ =>  {
                let var_326 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_server_certificate_name(var_326);
            }
            ,
            s if s.matches("ServerCertificateId") /* ServerCertificateId com.amazonaws.iam#ServerCertificateMetadata$ServerCertificateId */ =>  {
                let var_327 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_server_certificate_id(var_327);
            }
            ,
            s if s.matches("Arn") /* Arn com.amazonaws.iam#ServerCertificateMetadata$Arn */ =>  {
                let var_328 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_arn(var_328);
            }
            ,
            s if s.matches("UploadDate") /* UploadDate com.amazonaws.iam#ServerCertificateMetadata$UploadDate */ =>  {
                let var_329 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_upload_date(var_329);
            }
            ,
            s if s.matches("Expiration") /* Expiration com.amazonaws.iam#ServerCertificateMetadata$Expiration */ =>  {
                let var_330 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_expiration(var_330);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_signing_certificate(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::SigningCertificate, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::SigningCertificate::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("UserName") /* UserName com.amazonaws.iam#SigningCertificate$UserName */ =>  {
                let var_331 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_user_name(var_331);
            }
            ,
            s if s.matches("CertificateId") /* CertificateId com.amazonaws.iam#SigningCertificate$CertificateId */ =>  {
                let var_332 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_certificate_id(var_332);
            }
            ,
            s if s.matches("CertificateBody") /* CertificateBody com.amazonaws.iam#SigningCertificate$CertificateBody */ =>  {
                let var_333 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_certificate_body(var_333);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.iam#SigningCertificate$Status */ =>  {
                let var_334 =
                    Some(
                        Result::<crate::model::StatusType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::StatusType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_334);
            }
            ,
            s if s.matches("UploadDate") /* UploadDate com.amazonaws.iam#SigningCertificate$UploadDate */ =>  {
                let var_335 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_upload_date(var_335);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_tag(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Tag, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Tag::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Key") /* Key com.amazonaws.iam#Tag$Key */ =>  {
                let var_336 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_key(var_336);
            }
            ,
            s if s.matches("Value") /* Value com.amazonaws.iam#Tag$Value */ =>  {
                let var_337 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_value(var_337);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_attached_permissions_boundary(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AttachedPermissionsBoundary, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AttachedPermissionsBoundary::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("PermissionsBoundaryType") /* PermissionsBoundaryType com.amazonaws.iam#AttachedPermissionsBoundary$PermissionsBoundaryType */ =>  {
                let var_338 =
                    Some(
                        Result::<crate::model::PermissionsBoundaryAttachmentType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::PermissionsBoundaryAttachmentType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_permissions_boundary_type(var_338);
            }
            ,
            s if s.matches("PermissionsBoundaryArn") /* PermissionsBoundaryArn com.amazonaws.iam#AttachedPermissionsBoundary$PermissionsBoundaryArn */ =>  {
                let var_339 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_permissions_boundary_arn(var_339);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_role_last_used(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::RoleLastUsed, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::RoleLastUsed::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("LastUsedDate") /* LastUsedDate com.amazonaws.iam#RoleLastUsed$LastUsedDate */ =>  {
                let var_340 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_last_used_date(var_340);
            }
            ,
            s if s.matches("Region") /* Region com.amazonaws.iam#RoleLastUsed$Region */ =>  {
                let var_341 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_region(var_341);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_user_detail(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::UserDetail, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::UserDetail::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Path") /* Path com.amazonaws.iam#UserDetail$Path */ =>  {
                let var_342 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_path(var_342);
            }
            ,
            s if s.matches("UserName") /* UserName com.amazonaws.iam#UserDetail$UserName */ =>  {
                let var_343 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_user_name(var_343);
            }
            ,
            s if s.matches("UserId") /* UserId com.amazonaws.iam#UserDetail$UserId */ =>  {
                let var_344 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_user_id(var_344);
            }
            ,
            s if s.matches("Arn") /* Arn com.amazonaws.iam#UserDetail$Arn */ =>  {
                let var_345 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_arn(var_345);
            }
            ,
            s if s.matches("CreateDate") /* CreateDate com.amazonaws.iam#UserDetail$CreateDate */ =>  {
                let var_346 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_create_date(var_346);
            }
            ,
            s if s.matches("UserPolicyList") /* UserPolicyList com.amazonaws.iam#UserDetail$UserPolicyList */ =>  {
                let var_347 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_policy_detail_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_user_policy_list(var_347);
            }
            ,
            s if s.matches("GroupList") /* GroupList com.amazonaws.iam#UserDetail$GroupList */ =>  {
                let var_348 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_group_name_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_group_list(var_348);
            }
            ,
            s if s.matches("AttachedManagedPolicies") /* AttachedManagedPolicies com.amazonaws.iam#UserDetail$AttachedManagedPolicies */ =>  {
                let var_349 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_attached_policies_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_attached_managed_policies(var_349);
            }
            ,
            s if s.matches("PermissionsBoundary") /* PermissionsBoundary com.amazonaws.iam#UserDetail$PermissionsBoundary */ =>  {
                let var_350 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_attached_permissions_boundary(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_permissions_boundary(var_350);
            }
            ,
            s if s.matches("Tags") /* Tags com.amazonaws.iam#UserDetail$Tags */ =>  {
                let var_351 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_tag_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_351);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_group_detail(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::GroupDetail, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::GroupDetail::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Path") /* Path com.amazonaws.iam#GroupDetail$Path */ =>  {
                let var_352 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_path(var_352);
            }
            ,
            s if s.matches("GroupName") /* GroupName com.amazonaws.iam#GroupDetail$GroupName */ =>  {
                let var_353 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_group_name(var_353);
            }
            ,
            s if s.matches("GroupId") /* GroupId com.amazonaws.iam#GroupDetail$GroupId */ =>  {
                let var_354 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_group_id(var_354);
            }
            ,
            s if s.matches("Arn") /* Arn com.amazonaws.iam#GroupDetail$Arn */ =>  {
                let var_355 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_arn(var_355);
            }
            ,
            s if s.matches("CreateDate") /* CreateDate com.amazonaws.iam#GroupDetail$CreateDate */ =>  {
                let var_356 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_create_date(var_356);
            }
            ,
            s if s.matches("GroupPolicyList") /* GroupPolicyList com.amazonaws.iam#GroupDetail$GroupPolicyList */ =>  {
                let var_357 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_policy_detail_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_group_policy_list(var_357);
            }
            ,
            s if s.matches("AttachedManagedPolicies") /* AttachedManagedPolicies com.amazonaws.iam#GroupDetail$AttachedManagedPolicies */ =>  {
                let var_358 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_attached_policies_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_attached_managed_policies(var_358);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_role_detail(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::RoleDetail, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::RoleDetail::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Path") /* Path com.amazonaws.iam#RoleDetail$Path */ =>  {
                let var_359 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_path(var_359);
            }
            ,
            s if s.matches("RoleName") /* RoleName com.amazonaws.iam#RoleDetail$RoleName */ =>  {
                let var_360 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_role_name(var_360);
            }
            ,
            s if s.matches("RoleId") /* RoleId com.amazonaws.iam#RoleDetail$RoleId */ =>  {
                let var_361 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_role_id(var_361);
            }
            ,
            s if s.matches("Arn") /* Arn com.amazonaws.iam#RoleDetail$Arn */ =>  {
                let var_362 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_arn(var_362);
            }
            ,
            s if s.matches("CreateDate") /* CreateDate com.amazonaws.iam#RoleDetail$CreateDate */ =>  {
                let var_363 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_create_date(var_363);
            }
            ,
            s if s.matches("AssumeRolePolicyDocument") /* AssumeRolePolicyDocument com.amazonaws.iam#RoleDetail$AssumeRolePolicyDocument */ =>  {
                let var_364 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_assume_role_policy_document(var_364);
            }
            ,
            s if s.matches("InstanceProfileList") /* InstanceProfileList com.amazonaws.iam#RoleDetail$InstanceProfileList */ =>  {
                let var_365 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_instance_profile_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_instance_profile_list(var_365);
            }
            ,
            s if s.matches("RolePolicyList") /* RolePolicyList com.amazonaws.iam#RoleDetail$RolePolicyList */ =>  {
                let var_366 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_policy_detail_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_role_policy_list(var_366);
            }
            ,
            s if s.matches("AttachedManagedPolicies") /* AttachedManagedPolicies com.amazonaws.iam#RoleDetail$AttachedManagedPolicies */ =>  {
                let var_367 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_attached_policies_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_attached_managed_policies(var_367);
            }
            ,
            s if s.matches("PermissionsBoundary") /* PermissionsBoundary com.amazonaws.iam#RoleDetail$PermissionsBoundary */ =>  {
                let var_368 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_attached_permissions_boundary(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_permissions_boundary(var_368);
            }
            ,
            s if s.matches("Tags") /* Tags com.amazonaws.iam#RoleDetail$Tags */ =>  {
                let var_369 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_tag_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_369);
            }
            ,
            s if s.matches("RoleLastUsed") /* RoleLastUsed com.amazonaws.iam#RoleDetail$RoleLastUsed */ =>  {
                let var_370 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_role_last_used(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_role_last_used(var_370);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_managed_policy_detail(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ManagedPolicyDetail, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ManagedPolicyDetail::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("PolicyName") /* PolicyName com.amazonaws.iam#ManagedPolicyDetail$PolicyName */ =>  {
                let var_371 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_policy_name(var_371);
            }
            ,
            s if s.matches("PolicyId") /* PolicyId com.amazonaws.iam#ManagedPolicyDetail$PolicyId */ =>  {
                let var_372 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_policy_id(var_372);
            }
            ,
            s if s.matches("Arn") /* Arn com.amazonaws.iam#ManagedPolicyDetail$Arn */ =>  {
                let var_373 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_arn(var_373);
            }
            ,
            s if s.matches("Path") /* Path com.amazonaws.iam#ManagedPolicyDetail$Path */ =>  {
                let var_374 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_path(var_374);
            }
            ,
            s if s.matches("DefaultVersionId") /* DefaultVersionId com.amazonaws.iam#ManagedPolicyDetail$DefaultVersionId */ =>  {
                let var_375 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_default_version_id(var_375);
            }
            ,
            s if s.matches("AttachmentCount") /* AttachmentCount com.amazonaws.iam#ManagedPolicyDetail$AttachmentCount */ =>  {
                let var_376 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.iam#attachmentCountType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_attachment_count(var_376);
            }
            ,
            s if s.matches("PermissionsBoundaryUsageCount") /* PermissionsBoundaryUsageCount com.amazonaws.iam#ManagedPolicyDetail$PermissionsBoundaryUsageCount */ =>  {
                let var_377 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.iam#attachmentCountType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_permissions_boundary_usage_count(var_377);
            }
            ,
            s if s.matches("IsAttachable") /* IsAttachable com.amazonaws.iam#ManagedPolicyDetail$IsAttachable */ =>  {
                let var_378 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_is_attachable(var_378);
            }
            ,
            s if s.matches("Description") /* Description com.amazonaws.iam#ManagedPolicyDetail$Description */ =>  {
                let var_379 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_description(var_379);
            }
            ,
            s if s.matches("CreateDate") /* CreateDate com.amazonaws.iam#ManagedPolicyDetail$CreateDate */ =>  {
                let var_380 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_create_date(var_380);
            }
            ,
            s if s.matches("UpdateDate") /* UpdateDate com.amazonaws.iam#ManagedPolicyDetail$UpdateDate */ =>  {
                let var_381 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_update_date(var_381);
            }
            ,
            s if s.matches("PolicyVersionList") /* PolicyVersionList com.amazonaws.iam#ManagedPolicyDetail$PolicyVersionList */ =>  {
                let var_382 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_policy_document_version_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_policy_version_list(var_382);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_map_com_amazonaws_iam_summary_map_type_entry(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
    out: &mut std::collections::HashMap<crate::model::SummaryKeyType, i32>,
) -> Result<(), aws_smithy_xml::decode::XmlError> {
    let mut k: Option<crate::model::SummaryKeyType> = None;
    let mut v: Option<i32> = None;
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("key") /* key com.amazonaws.iam#summaryMapType$key */ =>  {
                k = Some(
                    Result::<crate::model::SummaryKeyType, aws_smithy_xml::decode::XmlError>::Ok(
                        crate::model::SummaryKeyType::from(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        )
                    )
                    ?
                )
            }
            ,
            s if s.matches("value") /* value com.amazonaws.iam#summaryMapType$value */ =>  {
                v = Some(
                     {
                        <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.iam#summaryValueType`)"))
                    }
                    ?
                )
            }
            ,
            _ => {}
        }
    }
    let k = k.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("missing key map entry"))?;
    let v = v.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("missing value map entry"))?;
    out.insert(k, v);
    Ok(())
}

pub fn deser_structure_crate_model_access_detail(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AccessDetail, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AccessDetail::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ServiceName") /* ServiceName com.amazonaws.iam#AccessDetail$ServiceName */ =>  {
                let var_383 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_service_name(var_383);
            }
            ,
            s if s.matches("ServiceNamespace") /* ServiceNamespace com.amazonaws.iam#AccessDetail$ServiceNamespace */ =>  {
                let var_384 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_service_namespace(var_384);
            }
            ,
            s if s.matches("Region") /* Region com.amazonaws.iam#AccessDetail$Region */ =>  {
                let var_385 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_region(var_385);
            }
            ,
            s if s.matches("EntityPath") /* EntityPath com.amazonaws.iam#AccessDetail$EntityPath */ =>  {
                let var_386 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_entity_path(var_386);
            }
            ,
            s if s.matches("LastAuthenticatedTime") /* LastAuthenticatedTime com.amazonaws.iam#AccessDetail$LastAuthenticatedTime */ =>  {
                let var_387 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_last_authenticated_time(var_387);
            }
            ,
            s if s.matches("TotalAuthenticatedEntities") /* TotalAuthenticatedEntities com.amazonaws.iam#AccessDetail$TotalAuthenticatedEntities */ =>  {
                let var_388 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.iam#integerType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_total_authenticated_entities(var_388);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_service_last_accessed(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ServiceLastAccessed, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ServiceLastAccessed::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ServiceName") /* ServiceName com.amazonaws.iam#ServiceLastAccessed$ServiceName */ =>  {
                let var_389 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_service_name(var_389);
            }
            ,
            s if s.matches("LastAuthenticated") /* LastAuthenticated com.amazonaws.iam#ServiceLastAccessed$LastAuthenticated */ =>  {
                let var_390 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_last_authenticated(var_390);
            }
            ,
            s if s.matches("ServiceNamespace") /* ServiceNamespace com.amazonaws.iam#ServiceLastAccessed$ServiceNamespace */ =>  {
                let var_391 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_service_namespace(var_391);
            }
            ,
            s if s.matches("LastAuthenticatedEntity") /* LastAuthenticatedEntity com.amazonaws.iam#ServiceLastAccessed$LastAuthenticatedEntity */ =>  {
                let var_392 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_last_authenticated_entity(var_392);
            }
            ,
            s if s.matches("LastAuthenticatedRegion") /* LastAuthenticatedRegion com.amazonaws.iam#ServiceLastAccessed$LastAuthenticatedRegion */ =>  {
                let var_393 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_last_authenticated_region(var_393);
            }
            ,
            s if s.matches("TotalAuthenticatedEntities") /* TotalAuthenticatedEntities com.amazonaws.iam#ServiceLastAccessed$TotalAuthenticatedEntities */ =>  {
                let var_394 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.iam#integerType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_total_authenticated_entities(var_394);
            }
            ,
            s if s.matches("TrackedActionsLastAccessed") /* TrackedActionsLastAccessed com.amazonaws.iam#ServiceLastAccessed$TrackedActionsLastAccessed */ =>  {
                let var_395 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_tracked_actions_last_accessed(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tracked_actions_last_accessed(var_395);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_entity_details(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::EntityDetails, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::EntityDetails::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("EntityInfo") /* EntityInfo com.amazonaws.iam#EntityDetails$EntityInfo */ =>  {
                let var_396 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_entity_info(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_entity_info(var_396);
            }
            ,
            s if s.matches("LastAuthenticated") /* LastAuthenticated com.amazonaws.iam#EntityDetails$LastAuthenticated */ =>  {
                let var_397 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_last_authenticated(var_397);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_iam_role_usage_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::RoleUsageType>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#RoleUsageListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_role_usage_type(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_access_key_metadata(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AccessKeyMetadata, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AccessKeyMetadata::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("UserName") /* UserName com.amazonaws.iam#AccessKeyMetadata$UserName */ =>  {
                let var_398 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_user_name(var_398);
            }
            ,
            s if s.matches("AccessKeyId") /* AccessKeyId com.amazonaws.iam#AccessKeyMetadata$AccessKeyId */ =>  {
                let var_399 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_access_key_id(var_399);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.iam#AccessKeyMetadata$Status */ =>  {
                let var_400 =
                    Some(
                        Result::<crate::model::StatusType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::StatusType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_400);
            }
            ,
            s if s.matches("CreateDate") /* CreateDate com.amazonaws.iam#AccessKeyMetadata$CreateDate */ =>  {
                let var_401 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_create_date(var_401);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_attached_policy(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AttachedPolicy, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AttachedPolicy::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("PolicyName") /* PolicyName com.amazonaws.iam#AttachedPolicy$PolicyName */ =>  {
                let var_402 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_policy_name(var_402);
            }
            ,
            s if s.matches("PolicyArn") /* PolicyArn com.amazonaws.iam#AttachedPolicy$PolicyArn */ =>  {
                let var_403 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_policy_arn(var_403);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_policy_group(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::PolicyGroup, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::PolicyGroup::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("GroupName") /* GroupName com.amazonaws.iam#PolicyGroup$GroupName */ =>  {
                let var_404 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_group_name(var_404);
            }
            ,
            s if s.matches("GroupId") /* GroupId com.amazonaws.iam#PolicyGroup$GroupId */ =>  {
                let var_405 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_group_id(var_405);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_policy_user(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::PolicyUser, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::PolicyUser::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("UserName") /* UserName com.amazonaws.iam#PolicyUser$UserName */ =>  {
                let var_406 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_user_name(var_406);
            }
            ,
            s if s.matches("UserId") /* UserId com.amazonaws.iam#PolicyUser$UserId */ =>  {
                let var_407 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_user_id(var_407);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_policy_role(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::PolicyRole, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::PolicyRole::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("RoleName") /* RoleName com.amazonaws.iam#PolicyRole$RoleName */ =>  {
                let var_408 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_role_name(var_408);
            }
            ,
            s if s.matches("RoleId") /* RoleId com.amazonaws.iam#PolicyRole$RoleId */ =>  {
                let var_409 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_role_id(var_409);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_mfa_device(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::MfaDevice, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::MfaDevice::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("UserName") /* UserName com.amazonaws.iam#MFADevice$UserName */ =>  {
                let var_410 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_user_name(var_410);
            }
            ,
            s if s.matches("SerialNumber") /* SerialNumber com.amazonaws.iam#MFADevice$SerialNumber */ =>  {
                let var_411 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_serial_number(var_411);
            }
            ,
            s if s.matches("EnableDate") /* EnableDate com.amazonaws.iam#MFADevice$EnableDate */ =>  {
                let var_412 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_enable_date(var_412);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_open_id_connect_provider_list_entry(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::OpenIdConnectProviderListEntry, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::OpenIdConnectProviderListEntry::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Arn") /* Arn com.amazonaws.iam#OpenIDConnectProviderListEntry$Arn */ =>  {
                let var_413 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_arn(var_413);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_list_policies_granting_service_access_entry(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ListPoliciesGrantingServiceAccessEntry, aws_smithy_xml::decode::XmlError>
{
    #[allow(unused_mut)]
    let mut builder = crate::model::ListPoliciesGrantingServiceAccessEntry::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ServiceNamespace") /* ServiceNamespace com.amazonaws.iam#ListPoliciesGrantingServiceAccessEntry$ServiceNamespace */ =>  {
                let var_414 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_service_namespace(var_414);
            }
            ,
            s if s.matches("Policies") /* Policies com.amazonaws.iam#ListPoliciesGrantingServiceAccessEntry$Policies */ =>  {
                let var_415 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_policy_granting_service_access_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_policies(var_415);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_saml_provider_list_entry(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::SamlProviderListEntry, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::SamlProviderListEntry::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Arn") /* Arn com.amazonaws.iam#SAMLProviderListEntry$Arn */ =>  {
                let var_416 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_arn(var_416);
            }
            ,
            s if s.matches("ValidUntil") /* ValidUntil com.amazonaws.iam#SAMLProviderListEntry$ValidUntil */ =>  {
                let var_417 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_valid_until(var_417);
            }
            ,
            s if s.matches("CreateDate") /* CreateDate com.amazonaws.iam#SAMLProviderListEntry$CreateDate */ =>  {
                let var_418 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_create_date(var_418);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_service_specific_credential_metadata(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ServiceSpecificCredentialMetadata, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ServiceSpecificCredentialMetadata::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("UserName") /* UserName com.amazonaws.iam#ServiceSpecificCredentialMetadata$UserName */ =>  {
                let var_419 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_user_name(var_419);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.iam#ServiceSpecificCredentialMetadata$Status */ =>  {
                let var_420 =
                    Some(
                        Result::<crate::model::StatusType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::StatusType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_420);
            }
            ,
            s if s.matches("ServiceUserName") /* ServiceUserName com.amazonaws.iam#ServiceSpecificCredentialMetadata$ServiceUserName */ =>  {
                let var_421 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_service_user_name(var_421);
            }
            ,
            s if s.matches("CreateDate") /* CreateDate com.amazonaws.iam#ServiceSpecificCredentialMetadata$CreateDate */ =>  {
                let var_422 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_create_date(var_422);
            }
            ,
            s if s.matches("ServiceSpecificCredentialId") /* ServiceSpecificCredentialId com.amazonaws.iam#ServiceSpecificCredentialMetadata$ServiceSpecificCredentialId */ =>  {
                let var_423 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_service_specific_credential_id(var_423);
            }
            ,
            s if s.matches("ServiceName") /* ServiceName com.amazonaws.iam#ServiceSpecificCredentialMetadata$ServiceName */ =>  {
                let var_424 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_service_name(var_424);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_ssh_public_key_metadata(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::SshPublicKeyMetadata, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::SshPublicKeyMetadata::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("UserName") /* UserName com.amazonaws.iam#SSHPublicKeyMetadata$UserName */ =>  {
                let var_425 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_user_name(var_425);
            }
            ,
            s if s.matches("SSHPublicKeyId") /* SSHPublicKeyId com.amazonaws.iam#SSHPublicKeyMetadata$SSHPublicKeyId */ =>  {
                let var_426 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_ssh_public_key_id(var_426);
            }
            ,
            s if s.matches("Status") /* Status com.amazonaws.iam#SSHPublicKeyMetadata$Status */ =>  {
                let var_427 =
                    Some(
                        Result::<crate::model::StatusType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::StatusType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status(var_427);
            }
            ,
            s if s.matches("UploadDate") /* UploadDate com.amazonaws.iam#SSHPublicKeyMetadata$UploadDate */ =>  {
                let var_428 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_upload_date(var_428);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_evaluation_result(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::EvaluationResult, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::EvaluationResult::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("EvalActionName") /* EvalActionName com.amazonaws.iam#EvaluationResult$EvalActionName */ =>  {
                let var_429 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_eval_action_name(var_429);
            }
            ,
            s if s.matches("EvalResourceName") /* EvalResourceName com.amazonaws.iam#EvaluationResult$EvalResourceName */ =>  {
                let var_430 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_eval_resource_name(var_430);
            }
            ,
            s if s.matches("EvalDecision") /* EvalDecision com.amazonaws.iam#EvaluationResult$EvalDecision */ =>  {
                let var_431 =
                    Some(
                        Result::<crate::model::PolicyEvaluationDecisionType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::PolicyEvaluationDecisionType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_eval_decision(var_431);
            }
            ,
            s if s.matches("MatchedStatements") /* MatchedStatements com.amazonaws.iam#EvaluationResult$MatchedStatements */ =>  {
                let var_432 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_statement_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_matched_statements(var_432);
            }
            ,
            s if s.matches("MissingContextValues") /* MissingContextValues com.amazonaws.iam#EvaluationResult$MissingContextValues */ =>  {
                let var_433 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_context_key_names_result_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_missing_context_values(var_433);
            }
            ,
            s if s.matches("OrganizationsDecisionDetail") /* OrganizationsDecisionDetail com.amazonaws.iam#EvaluationResult$OrganizationsDecisionDetail */ =>  {
                let var_434 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_organizations_decision_detail(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_organizations_decision_detail(var_434);
            }
            ,
            s if s.matches("PermissionsBoundaryDecisionDetail") /* PermissionsBoundaryDecisionDetail com.amazonaws.iam#EvaluationResult$PermissionsBoundaryDecisionDetail */ =>  {
                let var_435 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_permissions_boundary_decision_detail(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_permissions_boundary_decision_detail(var_435);
            }
            ,
            s if s.matches("EvalDecisionDetails") /* EvalDecisionDetails com.amazonaws.iam#EvaluationResult$EvalDecisionDetails */ =>  {
                let var_436 =
                    Some(
                        crate::xml_deser::deser_map_com_amazonaws_iam_eval_decision_details_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_eval_decision_details(var_436);
            }
            ,
            s if s.matches("ResourceSpecificResults") /* ResourceSpecificResults com.amazonaws.iam#EvaluationResult$ResourceSpecificResults */ =>  {
                let var_437 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_resource_specific_result_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_resource_specific_results(var_437);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_iam_policy_detail_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::PolicyDetail>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#policyDetailListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_policy_detail(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_group_name_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#groupNameListType$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_tracked_actions_last_accessed(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::TrackedActionLastAccessed>, aws_smithy_xml::decode::XmlError>
{
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#TrackedActionsLastAccessed$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_tracked_action_last_accessed(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_entity_info(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::EntityInfo, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::EntityInfo::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Arn") /* Arn com.amazonaws.iam#EntityInfo$Arn */ =>  {
                let var_438 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_arn(var_438);
            }
            ,
            s if s.matches("Name") /* Name com.amazonaws.iam#EntityInfo$Name */ =>  {
                let var_439 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_439);
            }
            ,
            s if s.matches("Type") /* Type com.amazonaws.iam#EntityInfo$Type */ =>  {
                let var_440 =
                    Some(
                        Result::<crate::model::PolicyOwnerEntityType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::PolicyOwnerEntityType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_type(var_440);
            }
            ,
            s if s.matches("Id") /* Id com.amazonaws.iam#EntityInfo$Id */ =>  {
                let var_441 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_id(var_441);
            }
            ,
            s if s.matches("Path") /* Path com.amazonaws.iam#EntityInfo$Path */ =>  {
                let var_442 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_path(var_442);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_role_usage_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::RoleUsageType, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::RoleUsageType::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Region") /* Region com.amazonaws.iam#RoleUsageType$Region */ =>  {
                let var_443 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_region(var_443);
            }
            ,
            s if s.matches("Resources") /* Resources com.amazonaws.iam#RoleUsageType$Resources */ =>  {
                let var_444 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_arn_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_resources(var_444);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_iam_policy_granting_service_access_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::vec::Vec<crate::model::PolicyGrantingServiceAccess>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#policyGrantingServiceAccessListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_policy_granting_service_access(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_statement_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::Statement>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#StatementListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_statement(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_organizations_decision_detail(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::OrganizationsDecisionDetail, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::OrganizationsDecisionDetail::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("AllowedByOrganizations") /* AllowedByOrganizations com.amazonaws.iam#OrganizationsDecisionDetail$AllowedByOrganizations */ =>  {
                let var_445 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_allowed_by_organizations(var_445);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_permissions_boundary_decision_detail(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::PermissionsBoundaryDecisionDetail, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::PermissionsBoundaryDecisionDetail::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("AllowedByPermissionsBoundary") /* AllowedByPermissionsBoundary com.amazonaws.iam#PermissionsBoundaryDecisionDetail$AllowedByPermissionsBoundary */ =>  {
                let var_446 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.iam#booleanType`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_allowed_by_permissions_boundary(var_446);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_map_com_amazonaws_iam_eval_decision_details_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::collections::HashMap<std::string::String, crate::model::PolicyEvaluationDecisionType>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::collections::HashMap::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("entry") => {
                crate::xml_deser::deser_map_com_amazonaws_iam_eval_decision_details_type_entry(
                    &mut tag, &mut out,
                )?;
            }
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_iam_resource_specific_result_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::ResourceSpecificResult>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#ResourceSpecificResultListType$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_resource_specific_result(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_policy_detail(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::PolicyDetail, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::PolicyDetail::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("PolicyName") /* PolicyName com.amazonaws.iam#PolicyDetail$PolicyName */ =>  {
                let var_447 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_policy_name(var_447);
            }
            ,
            s if s.matches("PolicyDocument") /* PolicyDocument com.amazonaws.iam#PolicyDetail$PolicyDocument */ =>  {
                let var_448 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_policy_document(var_448);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_tracked_action_last_accessed(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::TrackedActionLastAccessed, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::TrackedActionLastAccessed::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ActionName") /* ActionName com.amazonaws.iam#TrackedActionLastAccessed$ActionName */ =>  {
                let var_449 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_action_name(var_449);
            }
            ,
            s if s.matches("LastAccessedEntity") /* LastAccessedEntity com.amazonaws.iam#TrackedActionLastAccessed$LastAccessedEntity */ =>  {
                let var_450 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_last_accessed_entity(var_450);
            }
            ,
            s if s.matches("LastAccessedTime") /* LastAccessedTime com.amazonaws.iam#TrackedActionLastAccessed$LastAccessedTime */ =>  {
                let var_451 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.iam#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_last_accessed_time(var_451);
            }
            ,
            s if s.matches("LastAccessedRegion") /* LastAccessedRegion com.amazonaws.iam#TrackedActionLastAccessed$LastAccessedRegion */ =>  {
                let var_452 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_last_accessed_region(var_452);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_iam_arn_list_type(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.iam#ArnListType$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_policy_granting_service_access(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::PolicyGrantingServiceAccess, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::PolicyGrantingServiceAccess::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("PolicyName") /* PolicyName com.amazonaws.iam#PolicyGrantingServiceAccess$PolicyName */ =>  {
                let var_453 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_policy_name(var_453);
            }
            ,
            s if s.matches("PolicyType") /* PolicyType com.amazonaws.iam#PolicyGrantingServiceAccess$PolicyType */ =>  {
                let var_454 =
                    Some(
                        Result::<crate::model::PolicyType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::PolicyType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_policy_type(var_454);
            }
            ,
            s if s.matches("PolicyArn") /* PolicyArn com.amazonaws.iam#PolicyGrantingServiceAccess$PolicyArn */ =>  {
                let var_455 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_policy_arn(var_455);
            }
            ,
            s if s.matches("EntityType") /* EntityType com.amazonaws.iam#PolicyGrantingServiceAccess$EntityType */ =>  {
                let var_456 =
                    Some(
                        Result::<crate::model::PolicyOwnerEntityType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::PolicyOwnerEntityType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_entity_type(var_456);
            }
            ,
            s if s.matches("EntityName") /* EntityName com.amazonaws.iam#PolicyGrantingServiceAccess$EntityName */ =>  {
                let var_457 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_entity_name(var_457);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_statement(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Statement, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Statement::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("SourcePolicyId") /* SourcePolicyId com.amazonaws.iam#Statement$SourcePolicyId */ =>  {
                let var_458 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_source_policy_id(var_458);
            }
            ,
            s if s.matches("SourcePolicyType") /* SourcePolicyType com.amazonaws.iam#Statement$SourcePolicyType */ =>  {
                let var_459 =
                    Some(
                        Result::<crate::model::PolicySourceType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::PolicySourceType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_source_policy_type(var_459);
            }
            ,
            s if s.matches("StartPosition") /* StartPosition com.amazonaws.iam#Statement$StartPosition */ =>  {
                let var_460 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_position(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_start_position(var_460);
            }
            ,
            s if s.matches("EndPosition") /* EndPosition com.amazonaws.iam#Statement$EndPosition */ =>  {
                let var_461 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_position(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_end_position(var_461);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_map_com_amazonaws_iam_eval_decision_details_type_entry(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
    out: &mut std::collections::HashMap<
        std::string::String,
        crate::model::PolicyEvaluationDecisionType,
    >,
) -> Result<(), aws_smithy_xml::decode::XmlError> {
    let mut k: Option<std::string::String> = None;
    let mut v: Option<crate::model::PolicyEvaluationDecisionType> = None;
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("key") /* key com.amazonaws.iam#EvalDecisionDetailsType$key */ =>  {
                k = Some(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                )
            }
            ,
            s if s.matches("value") /* value com.amazonaws.iam#EvalDecisionDetailsType$value */ =>  {
                v = Some(
                    Result::<crate::model::PolicyEvaluationDecisionType, aws_smithy_xml::decode::XmlError>::Ok(
                        crate::model::PolicyEvaluationDecisionType::from(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        )
                    )
                    ?
                )
            }
            ,
            _ => {}
        }
    }
    let k = k.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("missing key map entry"))?;
    let v = v.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("missing value map entry"))?;
    out.insert(k, v);
    Ok(())
}

pub fn deser_structure_crate_model_resource_specific_result(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::ResourceSpecificResult, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::ResourceSpecificResult::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("EvalResourceName") /* EvalResourceName com.amazonaws.iam#ResourceSpecificResult$EvalResourceName */ =>  {
                let var_462 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_eval_resource_name(var_462);
            }
            ,
            s if s.matches("EvalResourceDecision") /* EvalResourceDecision com.amazonaws.iam#ResourceSpecificResult$EvalResourceDecision */ =>  {
                let var_463 =
                    Some(
                        Result::<crate::model::PolicyEvaluationDecisionType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::PolicyEvaluationDecisionType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_eval_resource_decision(var_463);
            }
            ,
            s if s.matches("MatchedStatements") /* MatchedStatements com.amazonaws.iam#ResourceSpecificResult$MatchedStatements */ =>  {
                let var_464 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_statement_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_matched_statements(var_464);
            }
            ,
            s if s.matches("MissingContextValues") /* MissingContextValues com.amazonaws.iam#ResourceSpecificResult$MissingContextValues */ =>  {
                let var_465 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_iam_context_key_names_result_list_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_missing_context_values(var_465);
            }
            ,
            s if s.matches("EvalDecisionDetails") /* EvalDecisionDetails com.amazonaws.iam#ResourceSpecificResult$EvalDecisionDetails */ =>  {
                let var_466 =
                    Some(
                        crate::xml_deser::deser_map_com_amazonaws_iam_eval_decision_details_type(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_eval_decision_details(var_466);
            }
            ,
            s if s.matches("PermissionsBoundaryDecisionDetail") /* PermissionsBoundaryDecisionDetail com.amazonaws.iam#ResourceSpecificResult$PermissionsBoundaryDecisionDetail */ =>  {
                let var_467 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_permissions_boundary_decision_detail(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_permissions_boundary_decision_detail(var_467);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_position(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Position, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Position::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Line") /* Line com.amazonaws.iam#Position$Line */ =>  {
                let var_468 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.iam#LineNumber`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_line(var_468);
            }
            ,
            s if s.matches("Column") /* Column com.amazonaws.iam#Position$Column */ =>  {
                let var_469 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.iam#ColumnNumber`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_column(var_469);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}
