// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Contains information about an SSH public key.</p>
/// <p>This data type is used as a response element in the <a>GetSSHPublicKey</a>
/// and <a>UploadSSHPublicKey</a> operations. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SshPublicKey {
    /// <p>The name of the IAM user associated with the SSH public key.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the SSH public key.</p>
    pub ssh_public_key_id: std::option::Option<std::string::String>,
    /// <p>The MD5 message digest of the SSH public key.</p>
    pub fingerprint: std::option::Option<std::string::String>,
    /// <p>The SSH public key.</p>
    pub ssh_public_key_body: std::option::Option<std::string::String>,
    /// <p>The status of the SSH public key. <code>Active</code> means that the key can be used for
    /// authentication with an CodeCommit repository. <code>Inactive</code> means that the key
    /// cannot be used.</p>
    pub status: std::option::Option<crate::model::StatusType>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the SSH public key was uploaded.</p>
    pub upload_date: std::option::Option<aws_smithy_types::Instant>,
}
impl SshPublicKey {
    /// <p>The name of the IAM user associated with the SSH public key.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The unique identifier for the SSH public key.</p>
    pub fn ssh_public_key_id(&self) -> std::option::Option<&str> {
        self.ssh_public_key_id.as_deref()
    }
    /// <p>The MD5 message digest of the SSH public key.</p>
    pub fn fingerprint(&self) -> std::option::Option<&str> {
        self.fingerprint.as_deref()
    }
    /// <p>The SSH public key.</p>
    pub fn ssh_public_key_body(&self) -> std::option::Option<&str> {
        self.ssh_public_key_body.as_deref()
    }
    /// <p>The status of the SSH public key. <code>Active</code> means that the key can be used for
    /// authentication with an CodeCommit repository. <code>Inactive</code> means that the key
    /// cannot be used.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::StatusType> {
        self.status.as_ref()
    }
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the SSH public key was uploaded.</p>
    pub fn upload_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.upload_date.as_ref()
    }
}
impl std::fmt::Debug for SshPublicKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SshPublicKey");
        formatter.field("user_name", &self.user_name);
        formatter.field("ssh_public_key_id", &self.ssh_public_key_id);
        formatter.field("fingerprint", &self.fingerprint);
        formatter.field("ssh_public_key_body", &self.ssh_public_key_body);
        formatter.field("status", &self.status);
        formatter.field("upload_date", &self.upload_date);
        formatter.finish()
    }
}
/// See [`SshPublicKey`](crate::model::SshPublicKey)
pub mod ssh_public_key {
    /// A builder for [`SshPublicKey`](crate::model::SshPublicKey)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) ssh_public_key_id: std::option::Option<std::string::String>,
        pub(crate) fingerprint: std::option::Option<std::string::String>,
        pub(crate) ssh_public_key_body: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::StatusType>,
        pub(crate) upload_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the IAM user associated with the SSH public key.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM user associated with the SSH public key.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The unique identifier for the SSH public key.</p>
        pub fn ssh_public_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_public_key_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the SSH public key.</p>
        pub fn set_ssh_public_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssh_public_key_id = input;
            self
        }
        /// <p>The MD5 message digest of the SSH public key.</p>
        pub fn fingerprint(mut self, input: impl Into<std::string::String>) -> Self {
            self.fingerprint = Some(input.into());
            self
        }
        /// <p>The MD5 message digest of the SSH public key.</p>
        pub fn set_fingerprint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fingerprint = input;
            self
        }
        /// <p>The SSH public key.</p>
        pub fn ssh_public_key_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_public_key_body = Some(input.into());
            self
        }
        /// <p>The SSH public key.</p>
        pub fn set_ssh_public_key_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssh_public_key_body = input;
            self
        }
        /// <p>The status of the SSH public key. <code>Active</code> means that the key can be used for
        /// authentication with an CodeCommit repository. <code>Inactive</code> means that the key
        /// cannot be used.</p>
        pub fn status(mut self, input: crate::model::StatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the SSH public key. <code>Active</code> means that the key can be used for
        /// authentication with an CodeCommit repository. <code>Inactive</code> means that the key
        /// cannot be used.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::StatusType>) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the SSH public key was uploaded.</p>
        pub fn upload_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.upload_date = Some(input);
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the SSH public key was uploaded.</p>
        pub fn set_upload_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.upload_date = input;
            self
        }
        /// Consumes the builder and constructs a [`SshPublicKey`](crate::model::SshPublicKey)
        pub fn build(self) -> crate::model::SshPublicKey {
            crate::model::SshPublicKey {
                user_name: self.user_name,
                ssh_public_key_id: self.ssh_public_key_id,
                fingerprint: self.fingerprint,
                ssh_public_key_body: self.ssh_public_key_body,
                status: self.status,
                upload_date: self.upload_date,
            }
        }
    }
}
impl SshPublicKey {
    /// Creates a new builder-style object to manufacture [`SshPublicKey`](crate::model::SshPublicKey)
    pub fn builder() -> crate::model::ssh_public_key::Builder {
        crate::model::ssh_public_key::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StatusType {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StatusType {
    fn from(s: &str) -> Self {
        match s {
            "Active" => StatusType::Active,
            "Inactive" => StatusType::Inactive,
            other => StatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StatusType::from(s))
    }
}
impl StatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StatusType::Active => "Active",
            StatusType::Inactive => "Inactive",
            StatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Active", "Inactive"]
    }
}
impl AsRef<str> for StatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about an X.509 signing certificate.</p>
/// <p>This data type is used as a response element in the <a>UploadSigningCertificate</a> and <a>ListSigningCertificates</a>
/// operations. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SigningCertificate {
    /// <p>The name of the user the signing certificate is associated with.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The ID for the signing certificate.</p>
    pub certificate_id: std::option::Option<std::string::String>,
    /// <p>The contents of the signing certificate.</p>
    pub certificate_body: std::option::Option<std::string::String>,
    /// <p>The status of the signing certificate. <code>Active</code> means that the key is valid
    /// for API calls, while <code>Inactive</code> means it is not.</p>
    pub status: std::option::Option<crate::model::StatusType>,
    /// <p>The date when the signing certificate was uploaded.</p>
    pub upload_date: std::option::Option<aws_smithy_types::Instant>,
}
impl SigningCertificate {
    /// <p>The name of the user the signing certificate is associated with.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The ID for the signing certificate.</p>
    pub fn certificate_id(&self) -> std::option::Option<&str> {
        self.certificate_id.as_deref()
    }
    /// <p>The contents of the signing certificate.</p>
    pub fn certificate_body(&self) -> std::option::Option<&str> {
        self.certificate_body.as_deref()
    }
    /// <p>The status of the signing certificate. <code>Active</code> means that the key is valid
    /// for API calls, while <code>Inactive</code> means it is not.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::StatusType> {
        self.status.as_ref()
    }
    /// <p>The date when the signing certificate was uploaded.</p>
    pub fn upload_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.upload_date.as_ref()
    }
}
impl std::fmt::Debug for SigningCertificate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SigningCertificate");
        formatter.field("user_name", &self.user_name);
        formatter.field("certificate_id", &self.certificate_id);
        formatter.field("certificate_body", &self.certificate_body);
        formatter.field("status", &self.status);
        formatter.field("upload_date", &self.upload_date);
        formatter.finish()
    }
}
/// See [`SigningCertificate`](crate::model::SigningCertificate)
pub mod signing_certificate {
    /// A builder for [`SigningCertificate`](crate::model::SigningCertificate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) certificate_id: std::option::Option<std::string::String>,
        pub(crate) certificate_body: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::StatusType>,
        pub(crate) upload_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the user the signing certificate is associated with.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the user the signing certificate is associated with.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The ID for the signing certificate.</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_id = Some(input.into());
            self
        }
        /// <p>The ID for the signing certificate.</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_id = input;
            self
        }
        /// <p>The contents of the signing certificate.</p>
        pub fn certificate_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_body = Some(input.into());
            self
        }
        /// <p>The contents of the signing certificate.</p>
        pub fn set_certificate_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_body = input;
            self
        }
        /// <p>The status of the signing certificate. <code>Active</code> means that the key is valid
        /// for API calls, while <code>Inactive</code> means it is not.</p>
        pub fn status(mut self, input: crate::model::StatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the signing certificate. <code>Active</code> means that the key is valid
        /// for API calls, while <code>Inactive</code> means it is not.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::StatusType>) -> Self {
            self.status = input;
            self
        }
        /// <p>The date when the signing certificate was uploaded.</p>
        pub fn upload_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.upload_date = Some(input);
            self
        }
        /// <p>The date when the signing certificate was uploaded.</p>
        pub fn set_upload_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.upload_date = input;
            self
        }
        /// Consumes the builder and constructs a [`SigningCertificate`](crate::model::SigningCertificate)
        pub fn build(self) -> crate::model::SigningCertificate {
            crate::model::SigningCertificate {
                user_name: self.user_name,
                certificate_id: self.certificate_id,
                certificate_body: self.certificate_body,
                status: self.status,
                upload_date: self.upload_date,
            }
        }
    }
}
impl SigningCertificate {
    /// Creates a new builder-style object to manufacture [`SigningCertificate`](crate::model::SigningCertificate)
    pub fn builder() -> crate::model::signing_certificate::Builder {
        crate::model::signing_certificate::Builder::default()
    }
}

/// <p>A structure that represents user-provided metadata that can be associated with an IAM
/// resource. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
/// <i>IAM User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key name that can be used to look up or retrieve the associated value. For example,
    /// <code>Department</code> or <code>Cost Center</code> are common choices.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value associated with this tag. For example, tags with a key name of
    /// <code>Department</code> could have values such as <code>Human Resources</code>,
    /// <code>Accounting</code>, and <code>Support</code>. Tags with a key name of <code>Cost
    /// Center</code> might have values that consist of the number associated with the different
    /// cost centers in your company. Typically, many resources have tags with the same key name but
    /// with different values.</p>
    /// <note>
    /// <p>Amazon Web Services always interprets the tag <code>Value</code> as a single string. If you need to
    /// store an array, you can store comma-separated values in the string. However, you must
    /// interpret the value in your code.</p>
    /// </note>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key name that can be used to look up or retrieve the associated value. For example,
    /// <code>Department</code> or <code>Cost Center</code> are common choices.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value associated with this tag. For example, tags with a key name of
    /// <code>Department</code> could have values such as <code>Human Resources</code>,
    /// <code>Accounting</code>, and <code>Support</code>. Tags with a key name of <code>Cost
    /// Center</code> might have values that consist of the number associated with the different
    /// cost centers in your company. Typically, many resources have tags with the same key name but
    /// with different values.</p>
    /// <note>
    /// <p>Amazon Web Services always interprets the tag <code>Value</code> as a single string. If you need to
    /// store an array, you can store comma-separated values in the string. However, you must
    /// interpret the value in your code.</p>
    /// </note>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key name that can be used to look up or retrieve the associated value. For example,
        /// <code>Department</code> or <code>Cost Center</code> are common choices.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key name that can be used to look up or retrieve the associated value. For example,
        /// <code>Department</code> or <code>Cost Center</code> are common choices.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value associated with this tag. For example, tags with a key name of
        /// <code>Department</code> could have values such as <code>Human Resources</code>,
        /// <code>Accounting</code>, and <code>Support</code>. Tags with a key name of <code>Cost
        /// Center</code> might have values that consist of the number associated with the different
        /// cost centers in your company. Typically, many resources have tags with the same key name but
        /// with different values.</p>
        /// <note>
        /// <p>Amazon Web Services always interprets the tag <code>Value</code> as a single string. If you need to
        /// store an array, you can store comma-separated values in the string. However, you must
        /// interpret the value in your code.</p>
        /// </note>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value associated with this tag. For example, tags with a key name of
        /// <code>Department</code> could have values such as <code>Human Resources</code>,
        /// <code>Accounting</code>, and <code>Support</code>. Tags with a key name of <code>Cost
        /// Center</code> might have values that consist of the number associated with the different
        /// cost centers in your company. Typically, many resources have tags with the same key name but
        /// with different values.</p>
        /// <note>
        /// <p>Amazon Web Services always interprets the tag <code>Value</code> as a single string. If you need to
        /// store an array, you can store comma-separated values in the string. However, you must
        /// interpret the value in your code.</p>
        /// </note>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Contains information about a server certificate without its certificate body,
/// certificate chain, and private key.</p>
/// <p> This data type is used as a response element in the <a>UploadServerCertificate</a> and <a>ListServerCertificates</a>
/// operations. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServerCertificateMetadata {
    /// <p> The path to the server certificate. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
    /// identifiers</a> in the <i>IAM User Guide</i>. </p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The name that identifies the server certificate.</p>
    pub server_certificate_name: std::option::Option<std::string::String>,
    /// <p> The stable and unique string identifying the server certificate. For more information
    /// about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>. </p>
    pub server_certificate_id: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) specifying the server certificate. For more information
    /// about ARNs and how to use them in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
    /// <i>IAM User Guide</i>. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The date when the server certificate was uploaded.</p>
    pub upload_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date on which the certificate is set to expire.</p>
    pub expiration: std::option::Option<aws_smithy_types::Instant>,
}
impl ServerCertificateMetadata {
    /// <p> The path to the server certificate. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
    /// identifiers</a> in the <i>IAM User Guide</i>. </p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>The name that identifies the server certificate.</p>
    pub fn server_certificate_name(&self) -> std::option::Option<&str> {
        self.server_certificate_name.as_deref()
    }
    /// <p> The stable and unique string identifying the server certificate. For more information
    /// about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>. </p>
    pub fn server_certificate_id(&self) -> std::option::Option<&str> {
        self.server_certificate_id.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) specifying the server certificate. For more information
    /// about ARNs and how to use them in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
    /// <i>IAM User Guide</i>. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The date when the server certificate was uploaded.</p>
    pub fn upload_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.upload_date.as_ref()
    }
    /// <p>The date on which the certificate is set to expire.</p>
    pub fn expiration(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.expiration.as_ref()
    }
}
impl std::fmt::Debug for ServerCertificateMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServerCertificateMetadata");
        formatter.field("path", &self.path);
        formatter.field("server_certificate_name", &self.server_certificate_name);
        formatter.field("server_certificate_id", &self.server_certificate_id);
        formatter.field("arn", &self.arn);
        formatter.field("upload_date", &self.upload_date);
        formatter.field("expiration", &self.expiration);
        formatter.finish()
    }
}
/// See [`ServerCertificateMetadata`](crate::model::ServerCertificateMetadata)
pub mod server_certificate_metadata {
    /// A builder for [`ServerCertificateMetadata`](crate::model::ServerCertificateMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) server_certificate_name: std::option::Option<std::string::String>,
        pub(crate) server_certificate_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) upload_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) expiration: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p> The path to the server certificate. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>. </p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p> The path to the server certificate. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>. </p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The name that identifies the server certificate.</p>
        pub fn server_certificate_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_certificate_name = Some(input.into());
            self
        }
        /// <p>The name that identifies the server certificate.</p>
        pub fn set_server_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.server_certificate_name = input;
            self
        }
        /// <p> The stable and unique string identifying the server certificate. For more information
        /// about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>. </p>
        pub fn server_certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_certificate_id = Some(input.into());
            self
        }
        /// <p> The stable and unique string identifying the server certificate. For more information
        /// about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>. </p>
        pub fn set_server_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.server_certificate_id = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) specifying the server certificate. For more information
        /// about ARNs and how to use them in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i>. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) specifying the server certificate. For more information
        /// about ARNs and how to use them in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i>. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The date when the server certificate was uploaded.</p>
        pub fn upload_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.upload_date = Some(input);
            self
        }
        /// <p>The date when the server certificate was uploaded.</p>
        pub fn set_upload_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.upload_date = input;
            self
        }
        /// <p>The date on which the certificate is set to expire.</p>
        pub fn expiration(mut self, input: aws_smithy_types::Instant) -> Self {
            self.expiration = Some(input);
            self
        }
        /// <p>The date on which the certificate is set to expire.</p>
        pub fn set_expiration(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.expiration = input;
            self
        }
        /// Consumes the builder and constructs a [`ServerCertificateMetadata`](crate::model::ServerCertificateMetadata)
        pub fn build(self) -> crate::model::ServerCertificateMetadata {
            crate::model::ServerCertificateMetadata {
                path: self.path,
                server_certificate_name: self.server_certificate_name,
                server_certificate_id: self.server_certificate_id,
                arn: self.arn,
                upload_date: self.upload_date,
                expiration: self.expiration,
            }
        }
    }
}
impl ServerCertificateMetadata {
    /// Creates a new builder-style object to manufacture [`ServerCertificateMetadata`](crate::model::ServerCertificateMetadata)
    pub fn builder() -> crate::model::server_certificate_metadata::Builder {
        crate::model::server_certificate_metadata::Builder::default()
    }
}

/// <p>Contains information about an IAM role. This structure is returned as a response
/// element in several API operations that interact with roles.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Role {
    /// <p> The path to the role. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
    /// <i>IAM User Guide</i>. </p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The friendly name that identifies the role.</p>
    pub role_name: std::option::Option<std::string::String>,
    /// <p> The stable and unique string identifying the role. For more information about IDs, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
    /// identifiers</a> in the <i>IAM User Guide</i>. </p>
    pub role_id: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) specifying the role. For more information about ARNs and
    /// how to use them in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
    /// <i>IAM User Guide</i> guide. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the role was created.</p>
    pub create_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The policy that grants an entity permission to assume the role.</p>
    pub assume_role_policy_document: std::option::Option<std::string::String>,
    /// <p>A description of the role that you provide.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The maximum session duration (in seconds) for the specified role. Anyone who uses the
    /// CLI, or API to assume the role can specify the duration using the optional
    /// <code>DurationSeconds</code> API parameter or <code>duration-seconds</code> CLI
    /// parameter.</p>
    pub max_session_duration: std::option::Option<i32>,
    /// <p>The ARN of the policy used to set the permissions boundary for the role.</p>
    /// <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
    /// identities </a> in the <i>IAM User Guide</i>.</p>
    pub permissions_boundary: std::option::Option<crate::model::AttachedPermissionsBoundary>,
    /// <p>A list of tags that are attached to the role. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Contains information about the last time that an IAM role was used. This includes the
    /// date and time and the Region in which the role was last used. Activity is only reported for
    /// the trailing 400 days. This period can be shorter if your Region began supporting these
    /// features within the last year. The role might have been used more than 400 days ago. For
    /// more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period">Regions where data is tracked</a> in the <i>IAM User
    /// Guide</i>.</p>
    pub role_last_used: std::option::Option<crate::model::RoleLastUsed>,
}
impl Role {
    /// <p> The path to the role. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
    /// <i>IAM User Guide</i>. </p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>The friendly name that identifies the role.</p>
    pub fn role_name(&self) -> std::option::Option<&str> {
        self.role_name.as_deref()
    }
    /// <p> The stable and unique string identifying the role. For more information about IDs, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
    /// identifiers</a> in the <i>IAM User Guide</i>. </p>
    pub fn role_id(&self) -> std::option::Option<&str> {
        self.role_id.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) specifying the role. For more information about ARNs and
    /// how to use them in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
    /// <i>IAM User Guide</i> guide. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the role was created.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_date.as_ref()
    }
    /// <p>The policy that grants an entity permission to assume the role.</p>
    pub fn assume_role_policy_document(&self) -> std::option::Option<&str> {
        self.assume_role_policy_document.as_deref()
    }
    /// <p>A description of the role that you provide.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The maximum session duration (in seconds) for the specified role. Anyone who uses the
    /// CLI, or API to assume the role can specify the duration using the optional
    /// <code>DurationSeconds</code> API parameter or <code>duration-seconds</code> CLI
    /// parameter.</p>
    pub fn max_session_duration(&self) -> std::option::Option<i32> {
        self.max_session_duration
    }
    /// <p>The ARN of the policy used to set the permissions boundary for the role.</p>
    /// <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
    /// identities </a> in the <i>IAM User Guide</i>.</p>
    pub fn permissions_boundary(
        &self,
    ) -> std::option::Option<&crate::model::AttachedPermissionsBoundary> {
        self.permissions_boundary.as_ref()
    }
    /// <p>A list of tags that are attached to the role. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>Contains information about the last time that an IAM role was used. This includes the
    /// date and time and the Region in which the role was last used. Activity is only reported for
    /// the trailing 400 days. This period can be shorter if your Region began supporting these
    /// features within the last year. The role might have been used more than 400 days ago. For
    /// more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period">Regions where data is tracked</a> in the <i>IAM User
    /// Guide</i>.</p>
    pub fn role_last_used(&self) -> std::option::Option<&crate::model::RoleLastUsed> {
        self.role_last_used.as_ref()
    }
}
impl std::fmt::Debug for Role {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Role");
        formatter.field("path", &self.path);
        formatter.field("role_name", &self.role_name);
        formatter.field("role_id", &self.role_id);
        formatter.field("arn", &self.arn);
        formatter.field("create_date", &self.create_date);
        formatter.field(
            "assume_role_policy_document",
            &self.assume_role_policy_document,
        );
        formatter.field("description", &self.description);
        formatter.field("max_session_duration", &self.max_session_duration);
        formatter.field("permissions_boundary", &self.permissions_boundary);
        formatter.field("tags", &self.tags);
        formatter.field("role_last_used", &self.role_last_used);
        formatter.finish()
    }
}
/// See [`Role`](crate::model::Role)
pub mod role {
    /// A builder for [`Role`](crate::model::Role)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) role_name: std::option::Option<std::string::String>,
        pub(crate) role_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) assume_role_policy_document: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) max_session_duration: std::option::Option<i32>,
        pub(crate) permissions_boundary:
            std::option::Option<crate::model::AttachedPermissionsBoundary>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) role_last_used: std::option::Option<crate::model::RoleLastUsed>,
    }
    impl Builder {
        /// <p> The path to the role. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i>. </p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p> The path to the role. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i>. </p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The friendly name that identifies the role.</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>The friendly name that identifies the role.</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// <p> The stable and unique string identifying the role. For more information about IDs, see
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>. </p>
        pub fn role_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_id = Some(input.into());
            self
        }
        /// <p> The stable and unique string identifying the role. For more information about IDs, see
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>. </p>
        pub fn set_role_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_id = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) specifying the role. For more information about ARNs and
        /// how to use them in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i> guide. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) specifying the role. For more information about ARNs and
        /// how to use them in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i> guide. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the role was created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the role was created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// <p>The policy that grants an entity permission to assume the role.</p>
        pub fn assume_role_policy_document(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.assume_role_policy_document = Some(input.into());
            self
        }
        /// <p>The policy that grants an entity permission to assume the role.</p>
        pub fn set_assume_role_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assume_role_policy_document = input;
            self
        }
        /// <p>A description of the role that you provide.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the role that you provide.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The maximum session duration (in seconds) for the specified role. Anyone who uses the
        /// CLI, or API to assume the role can specify the duration using the optional
        /// <code>DurationSeconds</code> API parameter or <code>duration-seconds</code> CLI
        /// parameter.</p>
        pub fn max_session_duration(mut self, input: i32) -> Self {
            self.max_session_duration = Some(input);
            self
        }
        /// <p>The maximum session duration (in seconds) for the specified role. Anyone who uses the
        /// CLI, or API to assume the role can specify the duration using the optional
        /// <code>DurationSeconds</code> API parameter or <code>duration-seconds</code> CLI
        /// parameter.</p>
        pub fn set_max_session_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.max_session_duration = input;
            self
        }
        /// <p>The ARN of the policy used to set the permissions boundary for the role.</p>
        /// <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
        /// identities </a> in the <i>IAM User Guide</i>.</p>
        pub fn permissions_boundary(
            mut self,
            input: crate::model::AttachedPermissionsBoundary,
        ) -> Self {
            self.permissions_boundary = Some(input);
            self
        }
        /// <p>The ARN of the policy used to set the permissions boundary for the role.</p>
        /// <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
        /// identities </a> in the <i>IAM User Guide</i>.</p>
        pub fn set_permissions_boundary(
            mut self,
            input: std::option::Option<crate::model::AttachedPermissionsBoundary>,
        ) -> Self {
            self.permissions_boundary = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that are attached to the role. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags that are attached to the role. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Contains information about the last time that an IAM role was used. This includes the
        /// date and time and the Region in which the role was last used. Activity is only reported for
        /// the trailing 400 days. This period can be shorter if your Region began supporting these
        /// features within the last year. The role might have been used more than 400 days ago. For
        /// more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period">Regions where data is tracked</a> in the <i>IAM User
        /// Guide</i>.</p>
        pub fn role_last_used(mut self, input: crate::model::RoleLastUsed) -> Self {
            self.role_last_used = Some(input);
            self
        }
        /// <p>Contains information about the last time that an IAM role was used. This includes the
        /// date and time and the Region in which the role was last used. Activity is only reported for
        /// the trailing 400 days. This period can be shorter if your Region began supporting these
        /// features within the last year. The role might have been used more than 400 days ago. For
        /// more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period">Regions where data is tracked</a> in the <i>IAM User
        /// Guide</i>.</p>
        pub fn set_role_last_used(
            mut self,
            input: std::option::Option<crate::model::RoleLastUsed>,
        ) -> Self {
            self.role_last_used = input;
            self
        }
        /// Consumes the builder and constructs a [`Role`](crate::model::Role)
        pub fn build(self) -> crate::model::Role {
            crate::model::Role {
                path: self.path,
                role_name: self.role_name,
                role_id: self.role_id,
                arn: self.arn,
                create_date: self.create_date,
                assume_role_policy_document: self.assume_role_policy_document,
                description: self.description,
                max_session_duration: self.max_session_duration,
                permissions_boundary: self.permissions_boundary,
                tags: self.tags,
                role_last_used: self.role_last_used,
            }
        }
    }
}
impl Role {
    /// Creates a new builder-style object to manufacture [`Role`](crate::model::Role)
    pub fn builder() -> crate::model::role::Builder {
        crate::model::role::Builder::default()
    }
}

/// <p>Contains information about the last time that an IAM role was used. This includes the
/// date and time and the Region in which the role was last used. Activity is only reported for
/// the trailing 400 days. This period can be shorter if your Region began supporting these
/// features within the last year. The role might have been used more than 400 days ago. For
/// more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period">Regions where data is tracked</a> in the <i>IAM User
/// Guide</i>.</p>
/// <p>This data type is returned as a response element in the <a>GetRole</a> and
/// <a>GetAccountAuthorizationDetails</a> operations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RoleLastUsed {
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a> that the role was last used.</p>
    /// <p>This field is null if the role has not been used within the IAM tracking period. For
    /// more information about the tracking period, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period">Regions where data is tracked</a> in the <i>IAM User Guide</i>. </p>
    pub last_used_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The name of the Amazon Web Services Region in which the role was last used.</p>
    pub region: std::option::Option<std::string::String>,
}
impl RoleLastUsed {
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a> that the role was last used.</p>
    /// <p>This field is null if the role has not been used within the IAM tracking period. For
    /// more information about the tracking period, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period">Regions where data is tracked</a> in the <i>IAM User Guide</i>. </p>
    pub fn last_used_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_used_date.as_ref()
    }
    /// <p>The name of the Amazon Web Services Region in which the role was last used.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
}
impl std::fmt::Debug for RoleLastUsed {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RoleLastUsed");
        formatter.field("last_used_date", &self.last_used_date);
        formatter.field("region", &self.region);
        formatter.finish()
    }
}
/// See [`RoleLastUsed`](crate::model::RoleLastUsed)
pub mod role_last_used {
    /// A builder for [`RoleLastUsed`](crate::model::RoleLastUsed)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) last_used_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a> that the role was last used.</p>
        /// <p>This field is null if the role has not been used within the IAM tracking period. For
        /// more information about the tracking period, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period">Regions where data is tracked</a> in the <i>IAM User Guide</i>. </p>
        pub fn last_used_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_used_date = Some(input);
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a> that the role was last used.</p>
        /// <p>This field is null if the role has not been used within the IAM tracking period. For
        /// more information about the tracking period, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period">Regions where data is tracked</a> in the <i>IAM User Guide</i>. </p>
        pub fn set_last_used_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_used_date = input;
            self
        }
        /// <p>The name of the Amazon Web Services Region in which the role was last used.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Web Services Region in which the role was last used.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// Consumes the builder and constructs a [`RoleLastUsed`](crate::model::RoleLastUsed)
        pub fn build(self) -> crate::model::RoleLastUsed {
            crate::model::RoleLastUsed {
                last_used_date: self.last_used_date,
                region: self.region,
            }
        }
    }
}
impl RoleLastUsed {
    /// Creates a new builder-style object to manufacture [`RoleLastUsed`](crate::model::RoleLastUsed)
    pub fn builder() -> crate::model::role_last_used::Builder {
        crate::model::role_last_used::Builder::default()
    }
}

/// <p>Contains information about an attached permissions boundary.</p>
/// <p>An attached permissions boundary is a managed policy that has been attached to a user or
/// role to set the permissions boundary.</p>
/// <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
/// identities </a> in the <i>IAM User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachedPermissionsBoundary {
    /// <p> The permissions boundary usage type that indicates what type of IAM resource is used
    /// as the permissions boundary for an entity. This data type can only have a value of
    /// <code>Policy</code>.</p>
    pub permissions_boundary_type:
        std::option::Option<crate::model::PermissionsBoundaryAttachmentType>,
    /// <p> The ARN of the policy used to set the permissions boundary for the user or role.</p>
    pub permissions_boundary_arn: std::option::Option<std::string::String>,
}
impl AttachedPermissionsBoundary {
    /// <p> The permissions boundary usage type that indicates what type of IAM resource is used
    /// as the permissions boundary for an entity. This data type can only have a value of
    /// <code>Policy</code>.</p>
    pub fn permissions_boundary_type(
        &self,
    ) -> std::option::Option<&crate::model::PermissionsBoundaryAttachmentType> {
        self.permissions_boundary_type.as_ref()
    }
    /// <p> The ARN of the policy used to set the permissions boundary for the user or role.</p>
    pub fn permissions_boundary_arn(&self) -> std::option::Option<&str> {
        self.permissions_boundary_arn.as_deref()
    }
}
impl std::fmt::Debug for AttachedPermissionsBoundary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachedPermissionsBoundary");
        formatter.field("permissions_boundary_type", &self.permissions_boundary_type);
        formatter.field("permissions_boundary_arn", &self.permissions_boundary_arn);
        formatter.finish()
    }
}
/// See [`AttachedPermissionsBoundary`](crate::model::AttachedPermissionsBoundary)
pub mod attached_permissions_boundary {
    /// A builder for [`AttachedPermissionsBoundary`](crate::model::AttachedPermissionsBoundary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) permissions_boundary_type:
            std::option::Option<crate::model::PermissionsBoundaryAttachmentType>,
        pub(crate) permissions_boundary_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The permissions boundary usage type that indicates what type of IAM resource is used
        /// as the permissions boundary for an entity. This data type can only have a value of
        /// <code>Policy</code>.</p>
        pub fn permissions_boundary_type(
            mut self,
            input: crate::model::PermissionsBoundaryAttachmentType,
        ) -> Self {
            self.permissions_boundary_type = Some(input);
            self
        }
        /// <p> The permissions boundary usage type that indicates what type of IAM resource is used
        /// as the permissions boundary for an entity. This data type can only have a value of
        /// <code>Policy</code>.</p>
        pub fn set_permissions_boundary_type(
            mut self,
            input: std::option::Option<crate::model::PermissionsBoundaryAttachmentType>,
        ) -> Self {
            self.permissions_boundary_type = input;
            self
        }
        /// <p> The ARN of the policy used to set the permissions boundary for the user or role.</p>
        pub fn permissions_boundary_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.permissions_boundary_arn = Some(input.into());
            self
        }
        /// <p> The ARN of the policy used to set the permissions boundary for the user or role.</p>
        pub fn set_permissions_boundary_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permissions_boundary_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachedPermissionsBoundary`](crate::model::AttachedPermissionsBoundary)
        pub fn build(self) -> crate::model::AttachedPermissionsBoundary {
            crate::model::AttachedPermissionsBoundary {
                permissions_boundary_type: self.permissions_boundary_type,
                permissions_boundary_arn: self.permissions_boundary_arn,
            }
        }
    }
}
impl AttachedPermissionsBoundary {
    /// Creates a new builder-style object to manufacture [`AttachedPermissionsBoundary`](crate::model::AttachedPermissionsBoundary)
    pub fn builder() -> crate::model::attached_permissions_boundary::Builder {
        crate::model::attached_permissions_boundary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PermissionsBoundaryAttachmentType {
    #[allow(missing_docs)] // documentation missing in model
    Policy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PermissionsBoundaryAttachmentType {
    fn from(s: &str) -> Self {
        match s {
            "PermissionsBoundaryPolicy" => PermissionsBoundaryAttachmentType::Policy,
            other => PermissionsBoundaryAttachmentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PermissionsBoundaryAttachmentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PermissionsBoundaryAttachmentType::from(s))
    }
}
impl PermissionsBoundaryAttachmentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PermissionsBoundaryAttachmentType::Policy => "PermissionsBoundaryPolicy",
            PermissionsBoundaryAttachmentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PermissionsBoundaryPolicy"]
    }
}
impl AsRef<str> for PermissionsBoundaryAttachmentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the results of a simulation.</p>
/// <p>This data type is used by the return parameter of <code>
/// <a>SimulateCustomPolicy</a>
/// </code> and <code>
/// <a>SimulatePrincipalPolicy</a>
/// </code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EvaluationResult {
    /// <p>The name of the API operation tested on the indicated resource.</p>
    pub eval_action_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the resource that the indicated API operation was tested on.</p>
    pub eval_resource_name: std::option::Option<std::string::String>,
    /// <p>The result of the simulation.</p>
    pub eval_decision: std::option::Option<crate::model::PolicyEvaluationDecisionType>,
    /// <p>A list of the statements in the input policies that determine the result for this
    /// scenario. Remember that even if multiple statements allow the operation on the resource, if
    /// only one statement denies that operation, then the explicit deny overrides any allow. In
    /// addition, the deny statement is the only entry included in the result.</p>
    pub matched_statements: std::option::Option<std::vec::Vec<crate::model::Statement>>,
    /// <p>A list of context keys that are required by the included input policies but that were
    /// not provided by one of the input parameters. This list is used when the resource in a
    /// simulation is "*", either explicitly, or when the <code>ResourceArns</code> parameter
    /// blank. If you include a list of resources, then any missing context values are instead
    /// included under the <code>ResourceSpecificResults</code> section. To discover the context
    /// keys used by a set of policies, you can call <a>GetContextKeysForCustomPolicy</a> or <a>GetContextKeysForPrincipalPolicy</a>.</p>
    pub missing_context_values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A structure that details how Organizations and its service control policies affect the results of
    /// the simulation. Only applies if the simulated user's account is part of an
    /// organization.</p>
    pub organizations_decision_detail:
        std::option::Option<crate::model::OrganizationsDecisionDetail>,
    /// <p>Contains information about the effect that a permissions boundary has on a policy
    /// simulation when the boundary is applied to an IAM entity.</p>
    pub permissions_boundary_decision_detail:
        std::option::Option<crate::model::PermissionsBoundaryDecisionDetail>,
    /// <p>Additional details about the results of the cross-account evaluation decision. This
    /// parameter is populated for only cross-account simulations. It contains a brief summary of
    /// how each policy type contributes to the final evaluation decision.</p>
    /// <p>If the simulation evaluates policies within the same account and includes a resource
    /// ARN, then the parameter is present but the response is empty. If the simulation evaluates
    /// policies within the same account and specifies all resources (<code>*</code>), then the
    /// parameter is not returned.</p>
    /// <p>When you make a cross-account request, Amazon Web Services evaluates the request in the trusting
    /// account and the trusted account. The request is allowed only if both evaluations return
    /// <code>true</code>. For more information about how policies are evaluated, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics">Evaluating policies within a single account</a>.</p>
    /// <p>If an Organizations SCP included in the evaluation denies access, the simulation ends. In
    /// this case, policy evaluation does not proceed any further and this parameter is not
    /// returned.</p>
    pub eval_decision_details: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::PolicyEvaluationDecisionType>,
    >,
    /// <p>The individual results of the simulation of the API operation specified in
    /// EvalActionName on each resource.</p>
    pub resource_specific_results:
        std::option::Option<std::vec::Vec<crate::model::ResourceSpecificResult>>,
}
impl EvaluationResult {
    /// <p>The name of the API operation tested on the indicated resource.</p>
    pub fn eval_action_name(&self) -> std::option::Option<&str> {
        self.eval_action_name.as_deref()
    }
    /// <p>The ARN of the resource that the indicated API operation was tested on.</p>
    pub fn eval_resource_name(&self) -> std::option::Option<&str> {
        self.eval_resource_name.as_deref()
    }
    /// <p>The result of the simulation.</p>
    pub fn eval_decision(
        &self,
    ) -> std::option::Option<&crate::model::PolicyEvaluationDecisionType> {
        self.eval_decision.as_ref()
    }
    /// <p>A list of the statements in the input policies that determine the result for this
    /// scenario. Remember that even if multiple statements allow the operation on the resource, if
    /// only one statement denies that operation, then the explicit deny overrides any allow. In
    /// addition, the deny statement is the only entry included in the result.</p>
    pub fn matched_statements(&self) -> std::option::Option<&[crate::model::Statement]> {
        self.matched_statements.as_deref()
    }
    /// <p>A list of context keys that are required by the included input policies but that were
    /// not provided by one of the input parameters. This list is used when the resource in a
    /// simulation is "*", either explicitly, or when the <code>ResourceArns</code> parameter
    /// blank. If you include a list of resources, then any missing context values are instead
    /// included under the <code>ResourceSpecificResults</code> section. To discover the context
    /// keys used by a set of policies, you can call <a>GetContextKeysForCustomPolicy</a> or <a>GetContextKeysForPrincipalPolicy</a>.</p>
    pub fn missing_context_values(&self) -> std::option::Option<&[std::string::String]> {
        self.missing_context_values.as_deref()
    }
    /// <p>A structure that details how Organizations and its service control policies affect the results of
    /// the simulation. Only applies if the simulated user's account is part of an
    /// organization.</p>
    pub fn organizations_decision_detail(
        &self,
    ) -> std::option::Option<&crate::model::OrganizationsDecisionDetail> {
        self.organizations_decision_detail.as_ref()
    }
    /// <p>Contains information about the effect that a permissions boundary has on a policy
    /// simulation when the boundary is applied to an IAM entity.</p>
    pub fn permissions_boundary_decision_detail(
        &self,
    ) -> std::option::Option<&crate::model::PermissionsBoundaryDecisionDetail> {
        self.permissions_boundary_decision_detail.as_ref()
    }
    /// <p>Additional details about the results of the cross-account evaluation decision. This
    /// parameter is populated for only cross-account simulations. It contains a brief summary of
    /// how each policy type contributes to the final evaluation decision.</p>
    /// <p>If the simulation evaluates policies within the same account and includes a resource
    /// ARN, then the parameter is present but the response is empty. If the simulation evaluates
    /// policies within the same account and specifies all resources (<code>*</code>), then the
    /// parameter is not returned.</p>
    /// <p>When you make a cross-account request, Amazon Web Services evaluates the request in the trusting
    /// account and the trusted account. The request is allowed only if both evaluations return
    /// <code>true</code>. For more information about how policies are evaluated, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics">Evaluating policies within a single account</a>.</p>
    /// <p>If an Organizations SCP included in the evaluation denies access, the simulation ends. In
    /// this case, policy evaluation does not proceed any further and this parameter is not
    /// returned.</p>
    pub fn eval_decision_details(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::PolicyEvaluationDecisionType>,
    > {
        self.eval_decision_details.as_ref()
    }
    /// <p>The individual results of the simulation of the API operation specified in
    /// EvalActionName on each resource.</p>
    pub fn resource_specific_results(
        &self,
    ) -> std::option::Option<&[crate::model::ResourceSpecificResult]> {
        self.resource_specific_results.as_deref()
    }
}
impl std::fmt::Debug for EvaluationResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EvaluationResult");
        formatter.field("eval_action_name", &self.eval_action_name);
        formatter.field("eval_resource_name", &self.eval_resource_name);
        formatter.field("eval_decision", &self.eval_decision);
        formatter.field("matched_statements", &self.matched_statements);
        formatter.field("missing_context_values", &self.missing_context_values);
        formatter.field(
            "organizations_decision_detail",
            &self.organizations_decision_detail,
        );
        formatter.field(
            "permissions_boundary_decision_detail",
            &self.permissions_boundary_decision_detail,
        );
        formatter.field("eval_decision_details", &self.eval_decision_details);
        formatter.field("resource_specific_results", &self.resource_specific_results);
        formatter.finish()
    }
}
/// See [`EvaluationResult`](crate::model::EvaluationResult)
pub mod evaluation_result {
    /// A builder for [`EvaluationResult`](crate::model::EvaluationResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) eval_action_name: std::option::Option<std::string::String>,
        pub(crate) eval_resource_name: std::option::Option<std::string::String>,
        pub(crate) eval_decision: std::option::Option<crate::model::PolicyEvaluationDecisionType>,
        pub(crate) matched_statements: std::option::Option<std::vec::Vec<crate::model::Statement>>,
        pub(crate) missing_context_values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) organizations_decision_detail:
            std::option::Option<crate::model::OrganizationsDecisionDetail>,
        pub(crate) permissions_boundary_decision_detail:
            std::option::Option<crate::model::PermissionsBoundaryDecisionDetail>,
        pub(crate) eval_decision_details: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                crate::model::PolicyEvaluationDecisionType,
            >,
        >,
        pub(crate) resource_specific_results:
            std::option::Option<std::vec::Vec<crate::model::ResourceSpecificResult>>,
    }
    impl Builder {
        /// <p>The name of the API operation tested on the indicated resource.</p>
        pub fn eval_action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.eval_action_name = Some(input.into());
            self
        }
        /// <p>The name of the API operation tested on the indicated resource.</p>
        pub fn set_eval_action_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.eval_action_name = input;
            self
        }
        /// <p>The ARN of the resource that the indicated API operation was tested on.</p>
        pub fn eval_resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.eval_resource_name = Some(input.into());
            self
        }
        /// <p>The ARN of the resource that the indicated API operation was tested on.</p>
        pub fn set_eval_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.eval_resource_name = input;
            self
        }
        /// <p>The result of the simulation.</p>
        pub fn eval_decision(mut self, input: crate::model::PolicyEvaluationDecisionType) -> Self {
            self.eval_decision = Some(input);
            self
        }
        /// <p>The result of the simulation.</p>
        pub fn set_eval_decision(
            mut self,
            input: std::option::Option<crate::model::PolicyEvaluationDecisionType>,
        ) -> Self {
            self.eval_decision = input;
            self
        }
        /// Appends an item to `matched_statements`.
        ///
        /// To override the contents of this collection use [`set_matched_statements`](Self::set_matched_statements).
        ///
        /// <p>A list of the statements in the input policies that determine the result for this
        /// scenario. Remember that even if multiple statements allow the operation on the resource, if
        /// only one statement denies that operation, then the explicit deny overrides any allow. In
        /// addition, the deny statement is the only entry included in the result.</p>
        pub fn matched_statements(mut self, input: impl Into<crate::model::Statement>) -> Self {
            let mut v = self.matched_statements.unwrap_or_default();
            v.push(input.into());
            self.matched_statements = Some(v);
            self
        }
        /// <p>A list of the statements in the input policies that determine the result for this
        /// scenario. Remember that even if multiple statements allow the operation on the resource, if
        /// only one statement denies that operation, then the explicit deny overrides any allow. In
        /// addition, the deny statement is the only entry included in the result.</p>
        pub fn set_matched_statements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Statement>>,
        ) -> Self {
            self.matched_statements = input;
            self
        }
        /// Appends an item to `missing_context_values`.
        ///
        /// To override the contents of this collection use [`set_missing_context_values`](Self::set_missing_context_values).
        ///
        /// <p>A list of context keys that are required by the included input policies but that were
        /// not provided by one of the input parameters. This list is used when the resource in a
        /// simulation is "*", either explicitly, or when the <code>ResourceArns</code> parameter
        /// blank. If you include a list of resources, then any missing context values are instead
        /// included under the <code>ResourceSpecificResults</code> section. To discover the context
        /// keys used by a set of policies, you can call <a>GetContextKeysForCustomPolicy</a> or <a>GetContextKeysForPrincipalPolicy</a>.</p>
        pub fn missing_context_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.missing_context_values.unwrap_or_default();
            v.push(input.into());
            self.missing_context_values = Some(v);
            self
        }
        /// <p>A list of context keys that are required by the included input policies but that were
        /// not provided by one of the input parameters. This list is used when the resource in a
        /// simulation is "*", either explicitly, or when the <code>ResourceArns</code> parameter
        /// blank. If you include a list of resources, then any missing context values are instead
        /// included under the <code>ResourceSpecificResults</code> section. To discover the context
        /// keys used by a set of policies, you can call <a>GetContextKeysForCustomPolicy</a> or <a>GetContextKeysForPrincipalPolicy</a>.</p>
        pub fn set_missing_context_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.missing_context_values = input;
            self
        }
        /// <p>A structure that details how Organizations and its service control policies affect the results of
        /// the simulation. Only applies if the simulated user's account is part of an
        /// organization.</p>
        pub fn organizations_decision_detail(
            mut self,
            input: crate::model::OrganizationsDecisionDetail,
        ) -> Self {
            self.organizations_decision_detail = Some(input);
            self
        }
        /// <p>A structure that details how Organizations and its service control policies affect the results of
        /// the simulation. Only applies if the simulated user's account is part of an
        /// organization.</p>
        pub fn set_organizations_decision_detail(
            mut self,
            input: std::option::Option<crate::model::OrganizationsDecisionDetail>,
        ) -> Self {
            self.organizations_decision_detail = input;
            self
        }
        /// <p>Contains information about the effect that a permissions boundary has on a policy
        /// simulation when the boundary is applied to an IAM entity.</p>
        pub fn permissions_boundary_decision_detail(
            mut self,
            input: crate::model::PermissionsBoundaryDecisionDetail,
        ) -> Self {
            self.permissions_boundary_decision_detail = Some(input);
            self
        }
        /// <p>Contains information about the effect that a permissions boundary has on a policy
        /// simulation when the boundary is applied to an IAM entity.</p>
        pub fn set_permissions_boundary_decision_detail(
            mut self,
            input: std::option::Option<crate::model::PermissionsBoundaryDecisionDetail>,
        ) -> Self {
            self.permissions_boundary_decision_detail = input;
            self
        }
        /// Adds a key-value pair to `eval_decision_details`.
        ///
        /// To override the contents of this collection use [`set_eval_decision_details`](Self::set_eval_decision_details).
        ///
        /// <p>Additional details about the results of the cross-account evaluation decision. This
        /// parameter is populated for only cross-account simulations. It contains a brief summary of
        /// how each policy type contributes to the final evaluation decision.</p>
        /// <p>If the simulation evaluates policies within the same account and includes a resource
        /// ARN, then the parameter is present but the response is empty. If the simulation evaluates
        /// policies within the same account and specifies all resources (<code>*</code>), then the
        /// parameter is not returned.</p>
        /// <p>When you make a cross-account request, Amazon Web Services evaluates the request in the trusting
        /// account and the trusted account. The request is allowed only if both evaluations return
        /// <code>true</code>. For more information about how policies are evaluated, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics">Evaluating policies within a single account</a>.</p>
        /// <p>If an Organizations SCP included in the evaluation denies access, the simulation ends. In
        /// this case, policy evaluation does not proceed any further and this parameter is not
        /// returned.</p>
        pub fn eval_decision_details(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::PolicyEvaluationDecisionType>,
        ) -> Self {
            let mut hash_map = self.eval_decision_details.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.eval_decision_details = Some(hash_map);
            self
        }
        /// <p>Additional details about the results of the cross-account evaluation decision. This
        /// parameter is populated for only cross-account simulations. It contains a brief summary of
        /// how each policy type contributes to the final evaluation decision.</p>
        /// <p>If the simulation evaluates policies within the same account and includes a resource
        /// ARN, then the parameter is present but the response is empty. If the simulation evaluates
        /// policies within the same account and specifies all resources (<code>*</code>), then the
        /// parameter is not returned.</p>
        /// <p>When you make a cross-account request, Amazon Web Services evaluates the request in the trusting
        /// account and the trusted account. The request is allowed only if both evaluations return
        /// <code>true</code>. For more information about how policies are evaluated, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics">Evaluating policies within a single account</a>.</p>
        /// <p>If an Organizations SCP included in the evaluation denies access, the simulation ends. In
        /// this case, policy evaluation does not proceed any further and this parameter is not
        /// returned.</p>
        pub fn set_eval_decision_details(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::PolicyEvaluationDecisionType,
                >,
            >,
        ) -> Self {
            self.eval_decision_details = input;
            self
        }
        /// Appends an item to `resource_specific_results`.
        ///
        /// To override the contents of this collection use [`set_resource_specific_results`](Self::set_resource_specific_results).
        ///
        /// <p>The individual results of the simulation of the API operation specified in
        /// EvalActionName on each resource.</p>
        pub fn resource_specific_results(
            mut self,
            input: impl Into<crate::model::ResourceSpecificResult>,
        ) -> Self {
            let mut v = self.resource_specific_results.unwrap_or_default();
            v.push(input.into());
            self.resource_specific_results = Some(v);
            self
        }
        /// <p>The individual results of the simulation of the API operation specified in
        /// EvalActionName on each resource.</p>
        pub fn set_resource_specific_results(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceSpecificResult>>,
        ) -> Self {
            self.resource_specific_results = input;
            self
        }
        /// Consumes the builder and constructs a [`EvaluationResult`](crate::model::EvaluationResult)
        pub fn build(self) -> crate::model::EvaluationResult {
            crate::model::EvaluationResult {
                eval_action_name: self.eval_action_name,
                eval_resource_name: self.eval_resource_name,
                eval_decision: self.eval_decision,
                matched_statements: self.matched_statements,
                missing_context_values: self.missing_context_values,
                organizations_decision_detail: self.organizations_decision_detail,
                permissions_boundary_decision_detail: self.permissions_boundary_decision_detail,
                eval_decision_details: self.eval_decision_details,
                resource_specific_results: self.resource_specific_results,
            }
        }
    }
}
impl EvaluationResult {
    /// Creates a new builder-style object to manufacture [`EvaluationResult`](crate::model::EvaluationResult)
    pub fn builder() -> crate::model::evaluation_result::Builder {
        crate::model::evaluation_result::Builder::default()
    }
}

/// <p>Contains the result of the simulation of a single API operation call on a single
/// resource.</p>
/// <p>This data type is used by a member of the <a>EvaluationResult</a> data
/// type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceSpecificResult {
    /// <p>The name of the simulated resource, in Amazon Resource Name (ARN) format.</p>
    pub eval_resource_name: std::option::Option<std::string::String>,
    /// <p>The result of the simulation of the simulated API operation on the resource specified in
    /// <code>EvalResourceName</code>.</p>
    pub eval_resource_decision: std::option::Option<crate::model::PolicyEvaluationDecisionType>,
    /// <p>A list of the statements in the input policies that determine the result for this part
    /// of the simulation. Remember that even if multiple statements allow the operation on the
    /// resource, if <i>any</i> statement denies that operation, then the explicit
    /// deny overrides any allow. In addition, the deny statement is the only entry included in the
    /// result.</p>
    pub matched_statements: std::option::Option<std::vec::Vec<crate::model::Statement>>,
    /// <p>A list of context keys that are required by the included input policies but that were
    /// not provided by one of the input parameters. This list is used when a list of ARNs is
    /// included in the <code>ResourceArns</code> parameter instead of "*". If you do not specify
    /// individual resources, by setting <code>ResourceArns</code> to "*" or by not including the
    /// <code>ResourceArns</code> parameter, then any missing context values are instead
    /// included under the <code>EvaluationResults</code> section. To discover the context keys
    /// used by a set of policies, you can call <a>GetContextKeysForCustomPolicy</a> or
    /// <a>GetContextKeysForPrincipalPolicy</a>.</p>
    pub missing_context_values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Additional details about the results of the evaluation decision on a single resource.
    /// This parameter is returned only for cross-account simulations. This parameter explains how
    /// each policy type contributes to the resource-specific evaluation decision.</p>
    pub eval_decision_details: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::PolicyEvaluationDecisionType>,
    >,
    /// <p>Contains information about the effect that a permissions boundary has on a policy
    /// simulation when that boundary is applied to an IAM entity.</p>
    pub permissions_boundary_decision_detail:
        std::option::Option<crate::model::PermissionsBoundaryDecisionDetail>,
}
impl ResourceSpecificResult {
    /// <p>The name of the simulated resource, in Amazon Resource Name (ARN) format.</p>
    pub fn eval_resource_name(&self) -> std::option::Option<&str> {
        self.eval_resource_name.as_deref()
    }
    /// <p>The result of the simulation of the simulated API operation on the resource specified in
    /// <code>EvalResourceName</code>.</p>
    pub fn eval_resource_decision(
        &self,
    ) -> std::option::Option<&crate::model::PolicyEvaluationDecisionType> {
        self.eval_resource_decision.as_ref()
    }
    /// <p>A list of the statements in the input policies that determine the result for this part
    /// of the simulation. Remember that even if multiple statements allow the operation on the
    /// resource, if <i>any</i> statement denies that operation, then the explicit
    /// deny overrides any allow. In addition, the deny statement is the only entry included in the
    /// result.</p>
    pub fn matched_statements(&self) -> std::option::Option<&[crate::model::Statement]> {
        self.matched_statements.as_deref()
    }
    /// <p>A list of context keys that are required by the included input policies but that were
    /// not provided by one of the input parameters. This list is used when a list of ARNs is
    /// included in the <code>ResourceArns</code> parameter instead of "*". If you do not specify
    /// individual resources, by setting <code>ResourceArns</code> to "*" or by not including the
    /// <code>ResourceArns</code> parameter, then any missing context values are instead
    /// included under the <code>EvaluationResults</code> section. To discover the context keys
    /// used by a set of policies, you can call <a>GetContextKeysForCustomPolicy</a> or
    /// <a>GetContextKeysForPrincipalPolicy</a>.</p>
    pub fn missing_context_values(&self) -> std::option::Option<&[std::string::String]> {
        self.missing_context_values.as_deref()
    }
    /// <p>Additional details about the results of the evaluation decision on a single resource.
    /// This parameter is returned only for cross-account simulations. This parameter explains how
    /// each policy type contributes to the resource-specific evaluation decision.</p>
    pub fn eval_decision_details(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::PolicyEvaluationDecisionType>,
    > {
        self.eval_decision_details.as_ref()
    }
    /// <p>Contains information about the effect that a permissions boundary has on a policy
    /// simulation when that boundary is applied to an IAM entity.</p>
    pub fn permissions_boundary_decision_detail(
        &self,
    ) -> std::option::Option<&crate::model::PermissionsBoundaryDecisionDetail> {
        self.permissions_boundary_decision_detail.as_ref()
    }
}
impl std::fmt::Debug for ResourceSpecificResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceSpecificResult");
        formatter.field("eval_resource_name", &self.eval_resource_name);
        formatter.field("eval_resource_decision", &self.eval_resource_decision);
        formatter.field("matched_statements", &self.matched_statements);
        formatter.field("missing_context_values", &self.missing_context_values);
        formatter.field("eval_decision_details", &self.eval_decision_details);
        formatter.field(
            "permissions_boundary_decision_detail",
            &self.permissions_boundary_decision_detail,
        );
        formatter.finish()
    }
}
/// See [`ResourceSpecificResult`](crate::model::ResourceSpecificResult)
pub mod resource_specific_result {
    /// A builder for [`ResourceSpecificResult`](crate::model::ResourceSpecificResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) eval_resource_name: std::option::Option<std::string::String>,
        pub(crate) eval_resource_decision:
            std::option::Option<crate::model::PolicyEvaluationDecisionType>,
        pub(crate) matched_statements: std::option::Option<std::vec::Vec<crate::model::Statement>>,
        pub(crate) missing_context_values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) eval_decision_details: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                crate::model::PolicyEvaluationDecisionType,
            >,
        >,
        pub(crate) permissions_boundary_decision_detail:
            std::option::Option<crate::model::PermissionsBoundaryDecisionDetail>,
    }
    impl Builder {
        /// <p>The name of the simulated resource, in Amazon Resource Name (ARN) format.</p>
        pub fn eval_resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.eval_resource_name = Some(input.into());
            self
        }
        /// <p>The name of the simulated resource, in Amazon Resource Name (ARN) format.</p>
        pub fn set_eval_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.eval_resource_name = input;
            self
        }
        /// <p>The result of the simulation of the simulated API operation on the resource specified in
        /// <code>EvalResourceName</code>.</p>
        pub fn eval_resource_decision(
            mut self,
            input: crate::model::PolicyEvaluationDecisionType,
        ) -> Self {
            self.eval_resource_decision = Some(input);
            self
        }
        /// <p>The result of the simulation of the simulated API operation on the resource specified in
        /// <code>EvalResourceName</code>.</p>
        pub fn set_eval_resource_decision(
            mut self,
            input: std::option::Option<crate::model::PolicyEvaluationDecisionType>,
        ) -> Self {
            self.eval_resource_decision = input;
            self
        }
        /// Appends an item to `matched_statements`.
        ///
        /// To override the contents of this collection use [`set_matched_statements`](Self::set_matched_statements).
        ///
        /// <p>A list of the statements in the input policies that determine the result for this part
        /// of the simulation. Remember that even if multiple statements allow the operation on the
        /// resource, if <i>any</i> statement denies that operation, then the explicit
        /// deny overrides any allow. In addition, the deny statement is the only entry included in the
        /// result.</p>
        pub fn matched_statements(mut self, input: impl Into<crate::model::Statement>) -> Self {
            let mut v = self.matched_statements.unwrap_or_default();
            v.push(input.into());
            self.matched_statements = Some(v);
            self
        }
        /// <p>A list of the statements in the input policies that determine the result for this part
        /// of the simulation. Remember that even if multiple statements allow the operation on the
        /// resource, if <i>any</i> statement denies that operation, then the explicit
        /// deny overrides any allow. In addition, the deny statement is the only entry included in the
        /// result.</p>
        pub fn set_matched_statements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Statement>>,
        ) -> Self {
            self.matched_statements = input;
            self
        }
        /// Appends an item to `missing_context_values`.
        ///
        /// To override the contents of this collection use [`set_missing_context_values`](Self::set_missing_context_values).
        ///
        /// <p>A list of context keys that are required by the included input policies but that were
        /// not provided by one of the input parameters. This list is used when a list of ARNs is
        /// included in the <code>ResourceArns</code> parameter instead of "*". If you do not specify
        /// individual resources, by setting <code>ResourceArns</code> to "*" or by not including the
        /// <code>ResourceArns</code> parameter, then any missing context values are instead
        /// included under the <code>EvaluationResults</code> section. To discover the context keys
        /// used by a set of policies, you can call <a>GetContextKeysForCustomPolicy</a> or
        /// <a>GetContextKeysForPrincipalPolicy</a>.</p>
        pub fn missing_context_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.missing_context_values.unwrap_or_default();
            v.push(input.into());
            self.missing_context_values = Some(v);
            self
        }
        /// <p>A list of context keys that are required by the included input policies but that were
        /// not provided by one of the input parameters. This list is used when a list of ARNs is
        /// included in the <code>ResourceArns</code> parameter instead of "*". If you do not specify
        /// individual resources, by setting <code>ResourceArns</code> to "*" or by not including the
        /// <code>ResourceArns</code> parameter, then any missing context values are instead
        /// included under the <code>EvaluationResults</code> section. To discover the context keys
        /// used by a set of policies, you can call <a>GetContextKeysForCustomPolicy</a> or
        /// <a>GetContextKeysForPrincipalPolicy</a>.</p>
        pub fn set_missing_context_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.missing_context_values = input;
            self
        }
        /// Adds a key-value pair to `eval_decision_details`.
        ///
        /// To override the contents of this collection use [`set_eval_decision_details`](Self::set_eval_decision_details).
        ///
        /// <p>Additional details about the results of the evaluation decision on a single resource.
        /// This parameter is returned only for cross-account simulations. This parameter explains how
        /// each policy type contributes to the resource-specific evaluation decision.</p>
        pub fn eval_decision_details(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::PolicyEvaluationDecisionType>,
        ) -> Self {
            let mut hash_map = self.eval_decision_details.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.eval_decision_details = Some(hash_map);
            self
        }
        /// <p>Additional details about the results of the evaluation decision on a single resource.
        /// This parameter is returned only for cross-account simulations. This parameter explains how
        /// each policy type contributes to the resource-specific evaluation decision.</p>
        pub fn set_eval_decision_details(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::PolicyEvaluationDecisionType,
                >,
            >,
        ) -> Self {
            self.eval_decision_details = input;
            self
        }
        /// <p>Contains information about the effect that a permissions boundary has on a policy
        /// simulation when that boundary is applied to an IAM entity.</p>
        pub fn permissions_boundary_decision_detail(
            mut self,
            input: crate::model::PermissionsBoundaryDecisionDetail,
        ) -> Self {
            self.permissions_boundary_decision_detail = Some(input);
            self
        }
        /// <p>Contains information about the effect that a permissions boundary has on a policy
        /// simulation when that boundary is applied to an IAM entity.</p>
        pub fn set_permissions_boundary_decision_detail(
            mut self,
            input: std::option::Option<crate::model::PermissionsBoundaryDecisionDetail>,
        ) -> Self {
            self.permissions_boundary_decision_detail = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceSpecificResult`](crate::model::ResourceSpecificResult)
        pub fn build(self) -> crate::model::ResourceSpecificResult {
            crate::model::ResourceSpecificResult {
                eval_resource_name: self.eval_resource_name,
                eval_resource_decision: self.eval_resource_decision,
                matched_statements: self.matched_statements,
                missing_context_values: self.missing_context_values,
                eval_decision_details: self.eval_decision_details,
                permissions_boundary_decision_detail: self.permissions_boundary_decision_detail,
            }
        }
    }
}
impl ResourceSpecificResult {
    /// Creates a new builder-style object to manufacture [`ResourceSpecificResult`](crate::model::ResourceSpecificResult)
    pub fn builder() -> crate::model::resource_specific_result::Builder {
        crate::model::resource_specific_result::Builder::default()
    }
}

/// <p>Contains information about the effect that a permissions boundary has on a policy
/// simulation when the boundary is applied to an IAM entity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PermissionsBoundaryDecisionDetail {
    /// <p>Specifies whether an action is allowed by a permissions boundary that is applied to an
    /// IAM entity (user or role). A value of <code>true</code> means that the permissions
    /// boundary does not deny the action. This means that the policy includes an
    /// <code>Allow</code> statement that matches the request. In this case, if an
    /// identity-based policy also allows the action, the request is allowed. A value of
    /// <code>false</code> means that either the requested action is not allowed (implicitly
    /// denied) or that the action is explicitly denied by the permissions boundary. In both of
    /// these cases, the action is not allowed, regardless of the identity-based policy.</p>
    pub allowed_by_permissions_boundary: bool,
}
impl PermissionsBoundaryDecisionDetail {
    /// <p>Specifies whether an action is allowed by a permissions boundary that is applied to an
    /// IAM entity (user or role). A value of <code>true</code> means that the permissions
    /// boundary does not deny the action. This means that the policy includes an
    /// <code>Allow</code> statement that matches the request. In this case, if an
    /// identity-based policy also allows the action, the request is allowed. A value of
    /// <code>false</code> means that either the requested action is not allowed (implicitly
    /// denied) or that the action is explicitly denied by the permissions boundary. In both of
    /// these cases, the action is not allowed, regardless of the identity-based policy.</p>
    pub fn allowed_by_permissions_boundary(&self) -> bool {
        self.allowed_by_permissions_boundary
    }
}
impl std::fmt::Debug for PermissionsBoundaryDecisionDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PermissionsBoundaryDecisionDetail");
        formatter.field(
            "allowed_by_permissions_boundary",
            &self.allowed_by_permissions_boundary,
        );
        formatter.finish()
    }
}
/// See [`PermissionsBoundaryDecisionDetail`](crate::model::PermissionsBoundaryDecisionDetail)
pub mod permissions_boundary_decision_detail {
    /// A builder for [`PermissionsBoundaryDecisionDetail`](crate::model::PermissionsBoundaryDecisionDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allowed_by_permissions_boundary: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies whether an action is allowed by a permissions boundary that is applied to an
        /// IAM entity (user or role). A value of <code>true</code> means that the permissions
        /// boundary does not deny the action. This means that the policy includes an
        /// <code>Allow</code> statement that matches the request. In this case, if an
        /// identity-based policy also allows the action, the request is allowed. A value of
        /// <code>false</code> means that either the requested action is not allowed (implicitly
        /// denied) or that the action is explicitly denied by the permissions boundary. In both of
        /// these cases, the action is not allowed, regardless of the identity-based policy.</p>
        pub fn allowed_by_permissions_boundary(mut self, input: bool) -> Self {
            self.allowed_by_permissions_boundary = Some(input);
            self
        }
        /// <p>Specifies whether an action is allowed by a permissions boundary that is applied to an
        /// IAM entity (user or role). A value of <code>true</code> means that the permissions
        /// boundary does not deny the action. This means that the policy includes an
        /// <code>Allow</code> statement that matches the request. In this case, if an
        /// identity-based policy also allows the action, the request is allowed. A value of
        /// <code>false</code> means that either the requested action is not allowed (implicitly
        /// denied) or that the action is explicitly denied by the permissions boundary. In both of
        /// these cases, the action is not allowed, regardless of the identity-based policy.</p>
        pub fn set_allowed_by_permissions_boundary(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.allowed_by_permissions_boundary = input;
            self
        }
        /// Consumes the builder and constructs a [`PermissionsBoundaryDecisionDetail`](crate::model::PermissionsBoundaryDecisionDetail)
        pub fn build(self) -> crate::model::PermissionsBoundaryDecisionDetail {
            crate::model::PermissionsBoundaryDecisionDetail {
                allowed_by_permissions_boundary: self
                    .allowed_by_permissions_boundary
                    .unwrap_or_default(),
            }
        }
    }
}
impl PermissionsBoundaryDecisionDetail {
    /// Creates a new builder-style object to manufacture [`PermissionsBoundaryDecisionDetail`](crate::model::PermissionsBoundaryDecisionDetail)
    pub fn builder() -> crate::model::permissions_boundary_decision_detail::Builder {
        crate::model::permissions_boundary_decision_detail::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PolicyEvaluationDecisionType {
    #[allow(missing_docs)] // documentation missing in model
    Allowed,
    #[allow(missing_docs)] // documentation missing in model
    ExplicitDeny,
    #[allow(missing_docs)] // documentation missing in model
    ImplicitDeny,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PolicyEvaluationDecisionType {
    fn from(s: &str) -> Self {
        match s {
            "allowed" => PolicyEvaluationDecisionType::Allowed,
            "explicitDeny" => PolicyEvaluationDecisionType::ExplicitDeny,
            "implicitDeny" => PolicyEvaluationDecisionType::ImplicitDeny,
            other => PolicyEvaluationDecisionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PolicyEvaluationDecisionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PolicyEvaluationDecisionType::from(s))
    }
}
impl PolicyEvaluationDecisionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PolicyEvaluationDecisionType::Allowed => "allowed",
            PolicyEvaluationDecisionType::ExplicitDeny => "explicitDeny",
            PolicyEvaluationDecisionType::ImplicitDeny => "implicitDeny",
            PolicyEvaluationDecisionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["allowed", "explicitDeny", "implicitDeny"]
    }
}
impl AsRef<str> for PolicyEvaluationDecisionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains a reference to a <code>Statement</code> element in a policy document that
/// determines the result of the simulation.</p>
/// <p>This data type is used by the <code>MatchedStatements</code> member of the <code>
/// <a>EvaluationResult</a>
/// </code> type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Statement {
    /// <p>The identifier of the policy that was provided as an input.</p>
    pub source_policy_id: std::option::Option<std::string::String>,
    /// <p>The type of the policy.</p>
    pub source_policy_type: std::option::Option<crate::model::PolicySourceType>,
    /// <p>The row and column of the beginning of the <code>Statement</code> in an IAM
    /// policy.</p>
    pub start_position: std::option::Option<crate::model::Position>,
    /// <p>The row and column of the end of a <code>Statement</code> in an IAM policy.</p>
    pub end_position: std::option::Option<crate::model::Position>,
}
impl Statement {
    /// <p>The identifier of the policy that was provided as an input.</p>
    pub fn source_policy_id(&self) -> std::option::Option<&str> {
        self.source_policy_id.as_deref()
    }
    /// <p>The type of the policy.</p>
    pub fn source_policy_type(&self) -> std::option::Option<&crate::model::PolicySourceType> {
        self.source_policy_type.as_ref()
    }
    /// <p>The row and column of the beginning of the <code>Statement</code> in an IAM
    /// policy.</p>
    pub fn start_position(&self) -> std::option::Option<&crate::model::Position> {
        self.start_position.as_ref()
    }
    /// <p>The row and column of the end of a <code>Statement</code> in an IAM policy.</p>
    pub fn end_position(&self) -> std::option::Option<&crate::model::Position> {
        self.end_position.as_ref()
    }
}
impl std::fmt::Debug for Statement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Statement");
        formatter.field("source_policy_id", &self.source_policy_id);
        formatter.field("source_policy_type", &self.source_policy_type);
        formatter.field("start_position", &self.start_position);
        formatter.field("end_position", &self.end_position);
        formatter.finish()
    }
}
/// See [`Statement`](crate::model::Statement)
pub mod statement {
    /// A builder for [`Statement`](crate::model::Statement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_policy_id: std::option::Option<std::string::String>,
        pub(crate) source_policy_type: std::option::Option<crate::model::PolicySourceType>,
        pub(crate) start_position: std::option::Option<crate::model::Position>,
        pub(crate) end_position: std::option::Option<crate::model::Position>,
    }
    impl Builder {
        /// <p>The identifier of the policy that was provided as an input.</p>
        pub fn source_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_policy_id = Some(input.into());
            self
        }
        /// <p>The identifier of the policy that was provided as an input.</p>
        pub fn set_source_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_policy_id = input;
            self
        }
        /// <p>The type of the policy.</p>
        pub fn source_policy_type(mut self, input: crate::model::PolicySourceType) -> Self {
            self.source_policy_type = Some(input);
            self
        }
        /// <p>The type of the policy.</p>
        pub fn set_source_policy_type(
            mut self,
            input: std::option::Option<crate::model::PolicySourceType>,
        ) -> Self {
            self.source_policy_type = input;
            self
        }
        /// <p>The row and column of the beginning of the <code>Statement</code> in an IAM
        /// policy.</p>
        pub fn start_position(mut self, input: crate::model::Position) -> Self {
            self.start_position = Some(input);
            self
        }
        /// <p>The row and column of the beginning of the <code>Statement</code> in an IAM
        /// policy.</p>
        pub fn set_start_position(
            mut self,
            input: std::option::Option<crate::model::Position>,
        ) -> Self {
            self.start_position = input;
            self
        }
        /// <p>The row and column of the end of a <code>Statement</code> in an IAM policy.</p>
        pub fn end_position(mut self, input: crate::model::Position) -> Self {
            self.end_position = Some(input);
            self
        }
        /// <p>The row and column of the end of a <code>Statement</code> in an IAM policy.</p>
        pub fn set_end_position(
            mut self,
            input: std::option::Option<crate::model::Position>,
        ) -> Self {
            self.end_position = input;
            self
        }
        /// Consumes the builder and constructs a [`Statement`](crate::model::Statement)
        pub fn build(self) -> crate::model::Statement {
            crate::model::Statement {
                source_policy_id: self.source_policy_id,
                source_policy_type: self.source_policy_type,
                start_position: self.start_position,
                end_position: self.end_position,
            }
        }
    }
}
impl Statement {
    /// Creates a new builder-style object to manufacture [`Statement`](crate::model::Statement)
    pub fn builder() -> crate::model::statement::Builder {
        crate::model::statement::Builder::default()
    }
}

/// <p>Contains the row and column of a location of a <code>Statement</code> element in a
/// policy document.</p>
/// <p>This data type is used as a member of the <code>
/// <a>Statement</a>
/// </code> type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Position {
    /// <p>The line containing the specified position in the document.</p>
    pub line: i32,
    /// <p>The column in the line containing the specified position in the document.</p>
    pub column: i32,
}
impl Position {
    /// <p>The line containing the specified position in the document.</p>
    pub fn line(&self) -> i32 {
        self.line
    }
    /// <p>The column in the line containing the specified position in the document.</p>
    pub fn column(&self) -> i32 {
        self.column
    }
}
impl std::fmt::Debug for Position {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Position");
        formatter.field("line", &self.line);
        formatter.field("column", &self.column);
        formatter.finish()
    }
}
/// See [`Position`](crate::model::Position)
pub mod position {
    /// A builder for [`Position`](crate::model::Position)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) line: std::option::Option<i32>,
        pub(crate) column: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The line containing the specified position in the document.</p>
        pub fn line(mut self, input: i32) -> Self {
            self.line = Some(input);
            self
        }
        /// <p>The line containing the specified position in the document.</p>
        pub fn set_line(mut self, input: std::option::Option<i32>) -> Self {
            self.line = input;
            self
        }
        /// <p>The column in the line containing the specified position in the document.</p>
        pub fn column(mut self, input: i32) -> Self {
            self.column = Some(input);
            self
        }
        /// <p>The column in the line containing the specified position in the document.</p>
        pub fn set_column(mut self, input: std::option::Option<i32>) -> Self {
            self.column = input;
            self
        }
        /// Consumes the builder and constructs a [`Position`](crate::model::Position)
        pub fn build(self) -> crate::model::Position {
            crate::model::Position {
                line: self.line.unwrap_or_default(),
                column: self.column.unwrap_or_default(),
            }
        }
    }
}
impl Position {
    /// Creates a new builder-style object to manufacture [`Position`](crate::model::Position)
    pub fn builder() -> crate::model::position::Builder {
        crate::model::position::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PolicySourceType {
    #[allow(missing_docs)] // documentation missing in model
    AwsManaged,
    #[allow(missing_docs)] // documentation missing in model
    Group,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Resource,
    #[allow(missing_docs)] // documentation missing in model
    Role,
    #[allow(missing_docs)] // documentation missing in model
    User,
    #[allow(missing_docs)] // documentation missing in model
    UserManaged,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PolicySourceType {
    fn from(s: &str) -> Self {
        match s {
            "aws-managed" => PolicySourceType::AwsManaged,
            "group" => PolicySourceType::Group,
            "none" => PolicySourceType::None,
            "resource" => PolicySourceType::Resource,
            "role" => PolicySourceType::Role,
            "user" => PolicySourceType::User,
            "user-managed" => PolicySourceType::UserManaged,
            other => PolicySourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PolicySourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PolicySourceType::from(s))
    }
}
impl PolicySourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PolicySourceType::AwsManaged => "aws-managed",
            PolicySourceType::Group => "group",
            PolicySourceType::None => "none",
            PolicySourceType::Resource => "resource",
            PolicySourceType::Role => "role",
            PolicySourceType::User => "user",
            PolicySourceType::UserManaged => "user-managed",
            PolicySourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "aws-managed",
            "group",
            "none",
            "resource",
            "role",
            "user",
            "user-managed",
        ]
    }
}
impl AsRef<str> for PolicySourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the effect that Organizations has on a policy simulation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationsDecisionDetail {
    /// <p>Specifies whether the simulated operation is allowed by the Organizations service control
    /// policies that impact the simulated user's account.</p>
    pub allowed_by_organizations: bool,
}
impl OrganizationsDecisionDetail {
    /// <p>Specifies whether the simulated operation is allowed by the Organizations service control
    /// policies that impact the simulated user's account.</p>
    pub fn allowed_by_organizations(&self) -> bool {
        self.allowed_by_organizations
    }
}
impl std::fmt::Debug for OrganizationsDecisionDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationsDecisionDetail");
        formatter.field("allowed_by_organizations", &self.allowed_by_organizations);
        formatter.finish()
    }
}
/// See [`OrganizationsDecisionDetail`](crate::model::OrganizationsDecisionDetail)
pub mod organizations_decision_detail {
    /// A builder for [`OrganizationsDecisionDetail`](crate::model::OrganizationsDecisionDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allowed_by_organizations: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies whether the simulated operation is allowed by the Organizations service control
        /// policies that impact the simulated user's account.</p>
        pub fn allowed_by_organizations(mut self, input: bool) -> Self {
            self.allowed_by_organizations = Some(input);
            self
        }
        /// <p>Specifies whether the simulated operation is allowed by the Organizations service control
        /// policies that impact the simulated user's account.</p>
        pub fn set_allowed_by_organizations(mut self, input: std::option::Option<bool>) -> Self {
            self.allowed_by_organizations = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationsDecisionDetail`](crate::model::OrganizationsDecisionDetail)
        pub fn build(self) -> crate::model::OrganizationsDecisionDetail {
            crate::model::OrganizationsDecisionDetail {
                allowed_by_organizations: self.allowed_by_organizations.unwrap_or_default(),
            }
        }
    }
}
impl OrganizationsDecisionDetail {
    /// Creates a new builder-style object to manufacture [`OrganizationsDecisionDetail`](crate::model::OrganizationsDecisionDetail)
    pub fn builder() -> crate::model::organizations_decision_detail::Builder {
        crate::model::organizations_decision_detail::Builder::default()
    }
}

/// <p>Contains information about a condition context key. It includes the name of the key and
/// specifies the value (or values, if the context key supports multiple values) to use in the
/// simulation. This information is used when evaluating the <code>Condition</code> elements of
/// the input policies.</p>
/// <p>This data type is used as an input parameter to <a>SimulateCustomPolicy</a> and <a>SimulatePrincipalPolicy</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContextEntry {
    /// <p>The full name of a condition context key, including the service prefix. For example,
    /// <code>aws:SourceIp</code> or <code>s3:VersionId</code>.</p>
    pub context_key_name: std::option::Option<std::string::String>,
    /// <p>The value (or values, if the condition context key supports multiple values) to provide
    /// to the simulation when the key is referenced by a <code>Condition</code> element in an
    /// input policy.</p>
    pub context_key_values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The data type of the value (or values) specified in the <code>ContextKeyValues</code>
    /// parameter.</p>
    pub context_key_type: std::option::Option<crate::model::ContextKeyTypeEnum>,
}
impl ContextEntry {
    /// <p>The full name of a condition context key, including the service prefix. For example,
    /// <code>aws:SourceIp</code> or <code>s3:VersionId</code>.</p>
    pub fn context_key_name(&self) -> std::option::Option<&str> {
        self.context_key_name.as_deref()
    }
    /// <p>The value (or values, if the condition context key supports multiple values) to provide
    /// to the simulation when the key is referenced by a <code>Condition</code> element in an
    /// input policy.</p>
    pub fn context_key_values(&self) -> std::option::Option<&[std::string::String]> {
        self.context_key_values.as_deref()
    }
    /// <p>The data type of the value (or values) specified in the <code>ContextKeyValues</code>
    /// parameter.</p>
    pub fn context_key_type(&self) -> std::option::Option<&crate::model::ContextKeyTypeEnum> {
        self.context_key_type.as_ref()
    }
}
impl std::fmt::Debug for ContextEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContextEntry");
        formatter.field("context_key_name", &self.context_key_name);
        formatter.field("context_key_values", &self.context_key_values);
        formatter.field("context_key_type", &self.context_key_type);
        formatter.finish()
    }
}
/// See [`ContextEntry`](crate::model::ContextEntry)
pub mod context_entry {
    /// A builder for [`ContextEntry`](crate::model::ContextEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) context_key_name: std::option::Option<std::string::String>,
        pub(crate) context_key_values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) context_key_type: std::option::Option<crate::model::ContextKeyTypeEnum>,
    }
    impl Builder {
        /// <p>The full name of a condition context key, including the service prefix. For example,
        /// <code>aws:SourceIp</code> or <code>s3:VersionId</code>.</p>
        pub fn context_key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.context_key_name = Some(input.into());
            self
        }
        /// <p>The full name of a condition context key, including the service prefix. For example,
        /// <code>aws:SourceIp</code> or <code>s3:VersionId</code>.</p>
        pub fn set_context_key_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.context_key_name = input;
            self
        }
        /// Appends an item to `context_key_values`.
        ///
        /// To override the contents of this collection use [`set_context_key_values`](Self::set_context_key_values).
        ///
        /// <p>The value (or values, if the condition context key supports multiple values) to provide
        /// to the simulation when the key is referenced by a <code>Condition</code> element in an
        /// input policy.</p>
        pub fn context_key_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.context_key_values.unwrap_or_default();
            v.push(input.into());
            self.context_key_values = Some(v);
            self
        }
        /// <p>The value (or values, if the condition context key supports multiple values) to provide
        /// to the simulation when the key is referenced by a <code>Condition</code> element in an
        /// input policy.</p>
        pub fn set_context_key_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.context_key_values = input;
            self
        }
        /// <p>The data type of the value (or values) specified in the <code>ContextKeyValues</code>
        /// parameter.</p>
        pub fn context_key_type(mut self, input: crate::model::ContextKeyTypeEnum) -> Self {
            self.context_key_type = Some(input);
            self
        }
        /// <p>The data type of the value (or values) specified in the <code>ContextKeyValues</code>
        /// parameter.</p>
        pub fn set_context_key_type(
            mut self,
            input: std::option::Option<crate::model::ContextKeyTypeEnum>,
        ) -> Self {
            self.context_key_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ContextEntry`](crate::model::ContextEntry)
        pub fn build(self) -> crate::model::ContextEntry {
            crate::model::ContextEntry {
                context_key_name: self.context_key_name,
                context_key_values: self.context_key_values,
                context_key_type: self.context_key_type,
            }
        }
    }
}
impl ContextEntry {
    /// Creates a new builder-style object to manufacture [`ContextEntry`](crate::model::ContextEntry)
    pub fn builder() -> crate::model::context_entry::Builder {
        crate::model::context_entry::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContextKeyTypeEnum {
    #[allow(missing_docs)] // documentation missing in model
    Binary,
    #[allow(missing_docs)] // documentation missing in model
    BinaryList,
    #[allow(missing_docs)] // documentation missing in model
    Boolean,
    #[allow(missing_docs)] // documentation missing in model
    BooleanList,
    #[allow(missing_docs)] // documentation missing in model
    Date,
    #[allow(missing_docs)] // documentation missing in model
    DateList,
    #[allow(missing_docs)] // documentation missing in model
    Ip,
    #[allow(missing_docs)] // documentation missing in model
    IpList,
    #[allow(missing_docs)] // documentation missing in model
    Numeric,
    #[allow(missing_docs)] // documentation missing in model
    NumericList,
    #[allow(missing_docs)] // documentation missing in model
    String,
    #[allow(missing_docs)] // documentation missing in model
    StringList,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContextKeyTypeEnum {
    fn from(s: &str) -> Self {
        match s {
            "binary" => ContextKeyTypeEnum::Binary,
            "binaryList" => ContextKeyTypeEnum::BinaryList,
            "boolean" => ContextKeyTypeEnum::Boolean,
            "booleanList" => ContextKeyTypeEnum::BooleanList,
            "date" => ContextKeyTypeEnum::Date,
            "dateList" => ContextKeyTypeEnum::DateList,
            "ip" => ContextKeyTypeEnum::Ip,
            "ipList" => ContextKeyTypeEnum::IpList,
            "numeric" => ContextKeyTypeEnum::Numeric,
            "numericList" => ContextKeyTypeEnum::NumericList,
            "string" => ContextKeyTypeEnum::String,
            "stringList" => ContextKeyTypeEnum::StringList,
            other => ContextKeyTypeEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContextKeyTypeEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContextKeyTypeEnum::from(s))
    }
}
impl ContextKeyTypeEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContextKeyTypeEnum::Binary => "binary",
            ContextKeyTypeEnum::BinaryList => "binaryList",
            ContextKeyTypeEnum::Boolean => "boolean",
            ContextKeyTypeEnum::BooleanList => "booleanList",
            ContextKeyTypeEnum::Date => "date",
            ContextKeyTypeEnum::DateList => "dateList",
            ContextKeyTypeEnum::Ip => "ip",
            ContextKeyTypeEnum::IpList => "ipList",
            ContextKeyTypeEnum::Numeric => "numeric",
            ContextKeyTypeEnum::NumericList => "numericList",
            ContextKeyTypeEnum::String => "string",
            ContextKeyTypeEnum::StringList => "stringList",
            ContextKeyTypeEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "binary",
            "binaryList",
            "boolean",
            "booleanList",
            "date",
            "dateList",
            "ip",
            "ipList",
            "numeric",
            "numericList",
            "string",
            "stringList",
        ]
    }
}
impl AsRef<str> for ContextKeyTypeEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GlobalEndpointTokenVersion {
    #[allow(missing_docs)] // documentation missing in model
    V1Token,
    #[allow(missing_docs)] // documentation missing in model
    V2Token,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GlobalEndpointTokenVersion {
    fn from(s: &str) -> Self {
        match s {
            "v1Token" => GlobalEndpointTokenVersion::V1Token,
            "v2Token" => GlobalEndpointTokenVersion::V2Token,
            other => GlobalEndpointTokenVersion::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GlobalEndpointTokenVersion {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GlobalEndpointTokenVersion::from(s))
    }
}
impl GlobalEndpointTokenVersion {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GlobalEndpointTokenVersion::V1Token => "v1Token",
            GlobalEndpointTokenVersion::V2Token => "v2Token",
            GlobalEndpointTokenVersion::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["v1Token", "v2Token"]
    }
}
impl AsRef<str> for GlobalEndpointTokenVersion {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the details of a service-specific credential.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceSpecificCredential {
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the service-specific credential were created.</p>
    pub create_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The name of the service associated with the service-specific credential.</p>
    pub service_name: std::option::Option<std::string::String>,
    /// <p>The generated user name for the service-specific credential. This value is generated by
    /// combining the IAM user's name combined with the ID number of the Amazon Web Services account, as in
    /// <code>jane-at-123456789012</code>, for example. This value cannot be configured by the
    /// user.</p>
    pub service_user_name: std::option::Option<std::string::String>,
    /// <p>The generated password for the service-specific credential.</p>
    pub service_password: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the service-specific credential.</p>
    pub service_specific_credential_id: std::option::Option<std::string::String>,
    /// <p>The name of the IAM user associated with the service-specific credential.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The status of the service-specific credential. <code>Active</code> means that the key is
    /// valid for API calls, while <code>Inactive</code> means it is not.</p>
    pub status: std::option::Option<crate::model::StatusType>,
}
impl ServiceSpecificCredential {
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the service-specific credential were created.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_date.as_ref()
    }
    /// <p>The name of the service associated with the service-specific credential.</p>
    pub fn service_name(&self) -> std::option::Option<&str> {
        self.service_name.as_deref()
    }
    /// <p>The generated user name for the service-specific credential. This value is generated by
    /// combining the IAM user's name combined with the ID number of the Amazon Web Services account, as in
    /// <code>jane-at-123456789012</code>, for example. This value cannot be configured by the
    /// user.</p>
    pub fn service_user_name(&self) -> std::option::Option<&str> {
        self.service_user_name.as_deref()
    }
    /// <p>The generated password for the service-specific credential.</p>
    pub fn service_password(&self) -> std::option::Option<&str> {
        self.service_password.as_deref()
    }
    /// <p>The unique identifier for the service-specific credential.</p>
    pub fn service_specific_credential_id(&self) -> std::option::Option<&str> {
        self.service_specific_credential_id.as_deref()
    }
    /// <p>The name of the IAM user associated with the service-specific credential.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The status of the service-specific credential. <code>Active</code> means that the key is
    /// valid for API calls, while <code>Inactive</code> means it is not.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::StatusType> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for ServiceSpecificCredential {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceSpecificCredential");
        formatter.field("create_date", &self.create_date);
        formatter.field("service_name", &self.service_name);
        formatter.field("service_user_name", &self.service_user_name);
        formatter.field("service_password", &"*** Sensitive Data Redacted ***");
        formatter.field(
            "service_specific_credential_id",
            &self.service_specific_credential_id,
        );
        formatter.field("user_name", &self.user_name);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ServiceSpecificCredential`](crate::model::ServiceSpecificCredential)
pub mod service_specific_credential {
    /// A builder for [`ServiceSpecificCredential`](crate::model::ServiceSpecificCredential)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) create_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) service_user_name: std::option::Option<std::string::String>,
        pub(crate) service_password: std::option::Option<std::string::String>,
        pub(crate) service_specific_credential_id: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::StatusType>,
    }
    impl Builder {
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the service-specific credential were created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the service-specific credential were created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// <p>The name of the service associated with the service-specific credential.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of the service associated with the service-specific credential.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// <p>The generated user name for the service-specific credential. This value is generated by
        /// combining the IAM user's name combined with the ID number of the Amazon Web Services account, as in
        /// <code>jane-at-123456789012</code>, for example. This value cannot be configured by the
        /// user.</p>
        pub fn service_user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_user_name = Some(input.into());
            self
        }
        /// <p>The generated user name for the service-specific credential. This value is generated by
        /// combining the IAM user's name combined with the ID number of the Amazon Web Services account, as in
        /// <code>jane-at-123456789012</code>, for example. This value cannot be configured by the
        /// user.</p>
        pub fn set_service_user_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_user_name = input;
            self
        }
        /// <p>The generated password for the service-specific credential.</p>
        pub fn service_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_password = Some(input.into());
            self
        }
        /// <p>The generated password for the service-specific credential.</p>
        pub fn set_service_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_password = input;
            self
        }
        /// <p>The unique identifier for the service-specific credential.</p>
        pub fn service_specific_credential_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.service_specific_credential_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the service-specific credential.</p>
        pub fn set_service_specific_credential_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_specific_credential_id = input;
            self
        }
        /// <p>The name of the IAM user associated with the service-specific credential.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM user associated with the service-specific credential.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The status of the service-specific credential. <code>Active</code> means that the key is
        /// valid for API calls, while <code>Inactive</code> means it is not.</p>
        pub fn status(mut self, input: crate::model::StatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the service-specific credential. <code>Active</code> means that the key is
        /// valid for API calls, while <code>Inactive</code> means it is not.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::StatusType>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceSpecificCredential`](crate::model::ServiceSpecificCredential)
        pub fn build(self) -> crate::model::ServiceSpecificCredential {
            crate::model::ServiceSpecificCredential {
                create_date: self.create_date,
                service_name: self.service_name,
                service_user_name: self.service_user_name,
                service_password: self.service_password,
                service_specific_credential_id: self.service_specific_credential_id,
                user_name: self.user_name,
                status: self.status,
            }
        }
    }
}
impl ServiceSpecificCredential {
    /// Creates a new builder-style object to manufacture [`ServiceSpecificCredential`](crate::model::ServiceSpecificCredential)
    pub fn builder() -> crate::model::service_specific_credential::Builder {
        crate::model::service_specific_credential::Builder::default()
    }
}

/// <p>Contains information about a virtual MFA device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VirtualMfaDevice {
    /// <p>The serial number associated with <code>VirtualMFADevice</code>.</p>
    pub serial_number: std::option::Option<std::string::String>,
    /// <p> The base32 seed defined as specified in <a href="https://tools.ietf.org/html/rfc3548.txt">RFC3548</a>. The <code>Base32StringSeed</code> is base64-encoded. </p>
    pub base32_string_seed: std::option::Option<aws_smithy_types::Blob>,
    /// <p> A QR code PNG image that encodes
    /// <code>otpauth://totp/$virtualMFADeviceName@$AccountName?secret=$Base32String</code>
    /// where <code>$virtualMFADeviceName</code> is one of the create call arguments.
    /// <code>AccountName</code> is the user name if set (otherwise, the account ID otherwise),
    /// and <code>Base32String</code> is the seed in base32 format. The <code>Base32String</code>
    /// value is base64-encoded. </p>
    pub qr_code_png: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The IAM user associated with this virtual MFA device.</p>
    pub user: std::option::Option<crate::model::User>,
    /// <p>The date and time on which the virtual MFA device was enabled.</p>
    pub enable_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A list of tags that are attached to the virtual MFA device. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl VirtualMfaDevice {
    /// <p>The serial number associated with <code>VirtualMFADevice</code>.</p>
    pub fn serial_number(&self) -> std::option::Option<&str> {
        self.serial_number.as_deref()
    }
    /// <p> The base32 seed defined as specified in <a href="https://tools.ietf.org/html/rfc3548.txt">RFC3548</a>. The <code>Base32StringSeed</code> is base64-encoded. </p>
    pub fn base32_string_seed(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.base32_string_seed.as_ref()
    }
    /// <p> A QR code PNG image that encodes
    /// <code>otpauth://totp/$virtualMFADeviceName@$AccountName?secret=$Base32String</code>
    /// where <code>$virtualMFADeviceName</code> is one of the create call arguments.
    /// <code>AccountName</code> is the user name if set (otherwise, the account ID otherwise),
    /// and <code>Base32String</code> is the seed in base32 format. The <code>Base32String</code>
    /// value is base64-encoded. </p>
    pub fn qr_code_png(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.qr_code_png.as_ref()
    }
    /// <p>The IAM user associated with this virtual MFA device.</p>
    pub fn user(&self) -> std::option::Option<&crate::model::User> {
        self.user.as_ref()
    }
    /// <p>The date and time on which the virtual MFA device was enabled.</p>
    pub fn enable_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.enable_date.as_ref()
    }
    /// <p>A list of tags that are attached to the virtual MFA device. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for VirtualMfaDevice {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VirtualMfaDevice");
        formatter.field("serial_number", &self.serial_number);
        formatter.field("base32_string_seed", &"*** Sensitive Data Redacted ***");
        formatter.field("qr_code_png", &"*** Sensitive Data Redacted ***");
        formatter.field("user", &self.user);
        formatter.field("enable_date", &self.enable_date);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`VirtualMfaDevice`](crate::model::VirtualMfaDevice)
pub mod virtual_mfa_device {
    /// A builder for [`VirtualMfaDevice`](crate::model::VirtualMfaDevice)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) serial_number: std::option::Option<std::string::String>,
        pub(crate) base32_string_seed: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) qr_code_png: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) user: std::option::Option<crate::model::User>,
        pub(crate) enable_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The serial number associated with <code>VirtualMFADevice</code>.</p>
        pub fn serial_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.serial_number = Some(input.into());
            self
        }
        /// <p>The serial number associated with <code>VirtualMFADevice</code>.</p>
        pub fn set_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.serial_number = input;
            self
        }
        /// <p> The base32 seed defined as specified in <a href="https://tools.ietf.org/html/rfc3548.txt">RFC3548</a>. The <code>Base32StringSeed</code> is base64-encoded. </p>
        pub fn base32_string_seed(mut self, input: aws_smithy_types::Blob) -> Self {
            self.base32_string_seed = Some(input);
            self
        }
        /// <p> The base32 seed defined as specified in <a href="https://tools.ietf.org/html/rfc3548.txt">RFC3548</a>. The <code>Base32StringSeed</code> is base64-encoded. </p>
        pub fn set_base32_string_seed(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.base32_string_seed = input;
            self
        }
        /// <p> A QR code PNG image that encodes
        /// <code>otpauth://totp/$virtualMFADeviceName@$AccountName?secret=$Base32String</code>
        /// where <code>$virtualMFADeviceName</code> is one of the create call arguments.
        /// <code>AccountName</code> is the user name if set (otherwise, the account ID otherwise),
        /// and <code>Base32String</code> is the seed in base32 format. The <code>Base32String</code>
        /// value is base64-encoded. </p>
        pub fn qr_code_png(mut self, input: aws_smithy_types::Blob) -> Self {
            self.qr_code_png = Some(input);
            self
        }
        /// <p> A QR code PNG image that encodes
        /// <code>otpauth://totp/$virtualMFADeviceName@$AccountName?secret=$Base32String</code>
        /// where <code>$virtualMFADeviceName</code> is one of the create call arguments.
        /// <code>AccountName</code> is the user name if set (otherwise, the account ID otherwise),
        /// and <code>Base32String</code> is the seed in base32 format. The <code>Base32String</code>
        /// value is base64-encoded. </p>
        pub fn set_qr_code_png(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.qr_code_png = input;
            self
        }
        /// <p>The IAM user associated with this virtual MFA device.</p>
        pub fn user(mut self, input: crate::model::User) -> Self {
            self.user = Some(input);
            self
        }
        /// <p>The IAM user associated with this virtual MFA device.</p>
        pub fn set_user(mut self, input: std::option::Option<crate::model::User>) -> Self {
            self.user = input;
            self
        }
        /// <p>The date and time on which the virtual MFA device was enabled.</p>
        pub fn enable_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.enable_date = Some(input);
            self
        }
        /// <p>The date and time on which the virtual MFA device was enabled.</p>
        pub fn set_enable_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.enable_date = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that are attached to the virtual MFA device. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags that are attached to the virtual MFA device. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`VirtualMfaDevice`](crate::model::VirtualMfaDevice)
        pub fn build(self) -> crate::model::VirtualMfaDevice {
            crate::model::VirtualMfaDevice {
                serial_number: self.serial_number,
                base32_string_seed: self.base32_string_seed,
                qr_code_png: self.qr_code_png,
                user: self.user,
                enable_date: self.enable_date,
                tags: self.tags,
            }
        }
    }
}
impl VirtualMfaDevice {
    /// Creates a new builder-style object to manufacture [`VirtualMfaDevice`](crate::model::VirtualMfaDevice)
    pub fn builder() -> crate::model::virtual_mfa_device::Builder {
        crate::model::virtual_mfa_device::Builder::default()
    }
}

/// <p>Contains information about an IAM user entity.</p>
/// <p>This data type is used as a response element in the following operations:</p>
/// <ul>
/// <li>
/// <p>
/// <a>CreateUser</a>
/// </p>
/// </li>
/// <li>
/// <p>
/// <a>GetUser</a>
/// </p>
/// </li>
/// <li>
/// <p>
/// <a>ListUsers</a>
/// </p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct User {
    /// <p>The path to the user. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// <p>The ARN of the policy used to set the permissions boundary for the user.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The friendly name identifying the user.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The stable and unique string identifying the user. For more information about IDs, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
    /// identifiers</a> in the <i>IAM User Guide</i>.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) that identifies the user. For more information about ARNs
    /// and how to use ARNs in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the
    /// <i>IAM User Guide</i>. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the user was created.</p>
    pub create_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the user's password was last used to sign in to an Amazon Web Services website. For
    /// a list of Amazon Web Services websites that capture a user's last sign-in time, see the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Credential
    /// reports</a> topic in the <i>IAM User Guide</i>. If a password is
    /// used more than once in a five-minute span, only the first use is returned in this field. If
    /// the field is null (no value), then it indicates that they never signed in with a password.
    /// This can be because:</p>
    /// <ul>
    /// <li>
    /// <p>The user never had a password.</p>
    /// </li>
    /// <li>
    /// <p>A password exists but has not been used since IAM started tracking this
    /// information on October 20, 2014.</p>
    /// </li>
    /// </ul>
    /// <p>A null value does not mean that the user <i>never</i> had a password.
    /// Also, if the user does not currently have a password but had one in the past, then this
    /// field contains the date and time the most recent password was used.</p>
    /// <p>This value is returned only in the <a>GetUser</a> and <a>ListUsers</a> operations. </p>
    pub password_last_used: std::option::Option<aws_smithy_types::Instant>,
    /// <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
    /// identities </a> in the <i>IAM User Guide</i>.</p>
    pub permissions_boundary: std::option::Option<crate::model::AttachedPermissionsBoundary>,
    /// <p>A list of tags that are associated with the user. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl User {
    /// <p>The path to the user. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
    /// <i>IAM User Guide</i>.</p>
    /// <p>The ARN of the policy used to set the permissions boundary for the user.</p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>The friendly name identifying the user.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The stable and unique string identifying the user. For more information about IDs, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
    /// identifiers</a> in the <i>IAM User Guide</i>.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) that identifies the user. For more information about ARNs
    /// and how to use ARNs in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the
    /// <i>IAM User Guide</i>. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the user was created.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_date.as_ref()
    }
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the user's password was last used to sign in to an Amazon Web Services website. For
    /// a list of Amazon Web Services websites that capture a user's last sign-in time, see the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Credential
    /// reports</a> topic in the <i>IAM User Guide</i>. If a password is
    /// used more than once in a five-minute span, only the first use is returned in this field. If
    /// the field is null (no value), then it indicates that they never signed in with a password.
    /// This can be because:</p>
    /// <ul>
    /// <li>
    /// <p>The user never had a password.</p>
    /// </li>
    /// <li>
    /// <p>A password exists but has not been used since IAM started tracking this
    /// information on October 20, 2014.</p>
    /// </li>
    /// </ul>
    /// <p>A null value does not mean that the user <i>never</i> had a password.
    /// Also, if the user does not currently have a password but had one in the past, then this
    /// field contains the date and time the most recent password was used.</p>
    /// <p>This value is returned only in the <a>GetUser</a> and <a>ListUsers</a> operations. </p>
    pub fn password_last_used(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.password_last_used.as_ref()
    }
    /// <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
    /// identities </a> in the <i>IAM User Guide</i>.</p>
    pub fn permissions_boundary(
        &self,
    ) -> std::option::Option<&crate::model::AttachedPermissionsBoundary> {
        self.permissions_boundary.as_ref()
    }
    /// <p>A list of tags that are associated with the user. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for User {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("User");
        formatter.field("path", &self.path);
        formatter.field("user_name", &self.user_name);
        formatter.field("user_id", &self.user_id);
        formatter.field("arn", &self.arn);
        formatter.field("create_date", &self.create_date);
        formatter.field("password_last_used", &self.password_last_used);
        formatter.field("permissions_boundary", &self.permissions_boundary);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`User`](crate::model::User)
pub mod user {
    /// A builder for [`User`](crate::model::User)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) password_last_used: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) permissions_boundary:
            std::option::Option<crate::model::AttachedPermissionsBoundary>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The path to the user. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <p>The ARN of the policy used to set the permissions boundary for the user.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The path to the user. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <p>The ARN of the policy used to set the permissions boundary for the user.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The friendly name identifying the user.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The friendly name identifying the user.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The stable and unique string identifying the user. For more information about IDs, see
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The stable and unique string identifying the user. For more information about IDs, see
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the user. For more information about ARNs
        /// and how to use ARNs in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the
        /// <i>IAM User Guide</i>. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the user. For more information about ARNs
        /// and how to use ARNs in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the
        /// <i>IAM User Guide</i>. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the user was created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the user was created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the user's password was last used to sign in to an Amazon Web Services website. For
        /// a list of Amazon Web Services websites that capture a user's last sign-in time, see the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Credential
        /// reports</a> topic in the <i>IAM User Guide</i>. If a password is
        /// used more than once in a five-minute span, only the first use is returned in this field. If
        /// the field is null (no value), then it indicates that they never signed in with a password.
        /// This can be because:</p>
        /// <ul>
        /// <li>
        /// <p>The user never had a password.</p>
        /// </li>
        /// <li>
        /// <p>A password exists but has not been used since IAM started tracking this
        /// information on October 20, 2014.</p>
        /// </li>
        /// </ul>
        /// <p>A null value does not mean that the user <i>never</i> had a password.
        /// Also, if the user does not currently have a password but had one in the past, then this
        /// field contains the date and time the most recent password was used.</p>
        /// <p>This value is returned only in the <a>GetUser</a> and <a>ListUsers</a> operations. </p>
        pub fn password_last_used(mut self, input: aws_smithy_types::Instant) -> Self {
            self.password_last_used = Some(input);
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the user's password was last used to sign in to an Amazon Web Services website. For
        /// a list of Amazon Web Services websites that capture a user's last sign-in time, see the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Credential
        /// reports</a> topic in the <i>IAM User Guide</i>. If a password is
        /// used more than once in a five-minute span, only the first use is returned in this field. If
        /// the field is null (no value), then it indicates that they never signed in with a password.
        /// This can be because:</p>
        /// <ul>
        /// <li>
        /// <p>The user never had a password.</p>
        /// </li>
        /// <li>
        /// <p>A password exists but has not been used since IAM started tracking this
        /// information on October 20, 2014.</p>
        /// </li>
        /// </ul>
        /// <p>A null value does not mean that the user <i>never</i> had a password.
        /// Also, if the user does not currently have a password but had one in the past, then this
        /// field contains the date and time the most recent password was used.</p>
        /// <p>This value is returned only in the <a>GetUser</a> and <a>ListUsers</a> operations. </p>
        pub fn set_password_last_used(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.password_last_used = input;
            self
        }
        /// <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
        /// identities </a> in the <i>IAM User Guide</i>.</p>
        pub fn permissions_boundary(
            mut self,
            input: crate::model::AttachedPermissionsBoundary,
        ) -> Self {
            self.permissions_boundary = Some(input);
            self
        }
        /// <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
        /// identities </a> in the <i>IAM User Guide</i>.</p>
        pub fn set_permissions_boundary(
            mut self,
            input: std::option::Option<crate::model::AttachedPermissionsBoundary>,
        ) -> Self {
            self.permissions_boundary = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that are associated with the user. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags that are associated with the user. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`User`](crate::model::User)
        pub fn build(self) -> crate::model::User {
            crate::model::User {
                path: self.path,
                user_name: self.user_name,
                user_id: self.user_id,
                arn: self.arn,
                create_date: self.create_date,
                password_last_used: self.password_last_used,
                permissions_boundary: self.permissions_boundary,
                tags: self.tags,
            }
        }
    }
}
impl User {
    /// Creates a new builder-style object to manufacture [`User`](crate::model::User)
    pub fn builder() -> crate::model::user::Builder {
        crate::model::user::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AssignmentStatusType {
    #[allow(missing_docs)] // documentation missing in model
    Any,
    #[allow(missing_docs)] // documentation missing in model
    Assigned,
    #[allow(missing_docs)] // documentation missing in model
    Unassigned,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AssignmentStatusType {
    fn from(s: &str) -> Self {
        match s {
            "Any" => AssignmentStatusType::Any,
            "Assigned" => AssignmentStatusType::Assigned,
            "Unassigned" => AssignmentStatusType::Unassigned,
            other => AssignmentStatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AssignmentStatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AssignmentStatusType::from(s))
    }
}
impl AssignmentStatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AssignmentStatusType::Any => "Any",
            AssignmentStatusType::Assigned => "Assigned",
            AssignmentStatusType::Unassigned => "Unassigned",
            AssignmentStatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Any", "Assigned", "Unassigned"]
    }
}
impl AsRef<str> for AssignmentStatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about an SSH public key, without the key's body or
/// fingerprint.</p>
/// <p>This data type is used as a response element in the <a>ListSSHPublicKeys</a>
/// operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SshPublicKeyMetadata {
    /// <p>The name of the IAM user associated with the SSH public key.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the SSH public key.</p>
    pub ssh_public_key_id: std::option::Option<std::string::String>,
    /// <p>The status of the SSH public key. <code>Active</code> means that the key can be used for
    /// authentication with an CodeCommit repository. <code>Inactive</code> means that the key
    /// cannot be used.</p>
    pub status: std::option::Option<crate::model::StatusType>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the SSH public key was uploaded.</p>
    pub upload_date: std::option::Option<aws_smithy_types::Instant>,
}
impl SshPublicKeyMetadata {
    /// <p>The name of the IAM user associated with the SSH public key.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The unique identifier for the SSH public key.</p>
    pub fn ssh_public_key_id(&self) -> std::option::Option<&str> {
        self.ssh_public_key_id.as_deref()
    }
    /// <p>The status of the SSH public key. <code>Active</code> means that the key can be used for
    /// authentication with an CodeCommit repository. <code>Inactive</code> means that the key
    /// cannot be used.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::StatusType> {
        self.status.as_ref()
    }
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the SSH public key was uploaded.</p>
    pub fn upload_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.upload_date.as_ref()
    }
}
impl std::fmt::Debug for SshPublicKeyMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SshPublicKeyMetadata");
        formatter.field("user_name", &self.user_name);
        formatter.field("ssh_public_key_id", &self.ssh_public_key_id);
        formatter.field("status", &self.status);
        formatter.field("upload_date", &self.upload_date);
        formatter.finish()
    }
}
/// See [`SshPublicKeyMetadata`](crate::model::SshPublicKeyMetadata)
pub mod ssh_public_key_metadata {
    /// A builder for [`SshPublicKeyMetadata`](crate::model::SshPublicKeyMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) ssh_public_key_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::StatusType>,
        pub(crate) upload_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the IAM user associated with the SSH public key.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM user associated with the SSH public key.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The unique identifier for the SSH public key.</p>
        pub fn ssh_public_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_public_key_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the SSH public key.</p>
        pub fn set_ssh_public_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssh_public_key_id = input;
            self
        }
        /// <p>The status of the SSH public key. <code>Active</code> means that the key can be used for
        /// authentication with an CodeCommit repository. <code>Inactive</code> means that the key
        /// cannot be used.</p>
        pub fn status(mut self, input: crate::model::StatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the SSH public key. <code>Active</code> means that the key can be used for
        /// authentication with an CodeCommit repository. <code>Inactive</code> means that the key
        /// cannot be used.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::StatusType>) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the SSH public key was uploaded.</p>
        pub fn upload_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.upload_date = Some(input);
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the SSH public key was uploaded.</p>
        pub fn set_upload_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.upload_date = input;
            self
        }
        /// Consumes the builder and constructs a [`SshPublicKeyMetadata`](crate::model::SshPublicKeyMetadata)
        pub fn build(self) -> crate::model::SshPublicKeyMetadata {
            crate::model::SshPublicKeyMetadata {
                user_name: self.user_name,
                ssh_public_key_id: self.ssh_public_key_id,
                status: self.status,
                upload_date: self.upload_date,
            }
        }
    }
}
impl SshPublicKeyMetadata {
    /// Creates a new builder-style object to manufacture [`SshPublicKeyMetadata`](crate::model::SshPublicKeyMetadata)
    pub fn builder() -> crate::model::ssh_public_key_metadata::Builder {
        crate::model::ssh_public_key_metadata::Builder::default()
    }
}

/// <p>Contains additional details about a service-specific credential.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceSpecificCredentialMetadata {
    /// <p>The name of the IAM user associated with the service-specific credential.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The status of the service-specific credential. <code>Active</code> means that the key is
    /// valid for API calls, while <code>Inactive</code> means it is not.</p>
    pub status: std::option::Option<crate::model::StatusType>,
    /// <p>The generated user name for the service-specific credential.</p>
    pub service_user_name: std::option::Option<std::string::String>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the service-specific credential were created.</p>
    pub create_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The unique identifier for the service-specific credential.</p>
    pub service_specific_credential_id: std::option::Option<std::string::String>,
    /// <p>The name of the service associated with the service-specific credential.</p>
    pub service_name: std::option::Option<std::string::String>,
}
impl ServiceSpecificCredentialMetadata {
    /// <p>The name of the IAM user associated with the service-specific credential.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The status of the service-specific credential. <code>Active</code> means that the key is
    /// valid for API calls, while <code>Inactive</code> means it is not.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::StatusType> {
        self.status.as_ref()
    }
    /// <p>The generated user name for the service-specific credential.</p>
    pub fn service_user_name(&self) -> std::option::Option<&str> {
        self.service_user_name.as_deref()
    }
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the service-specific credential were created.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_date.as_ref()
    }
    /// <p>The unique identifier for the service-specific credential.</p>
    pub fn service_specific_credential_id(&self) -> std::option::Option<&str> {
        self.service_specific_credential_id.as_deref()
    }
    /// <p>The name of the service associated with the service-specific credential.</p>
    pub fn service_name(&self) -> std::option::Option<&str> {
        self.service_name.as_deref()
    }
}
impl std::fmt::Debug for ServiceSpecificCredentialMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceSpecificCredentialMetadata");
        formatter.field("user_name", &self.user_name);
        formatter.field("status", &self.status);
        formatter.field("service_user_name", &self.service_user_name);
        formatter.field("create_date", &self.create_date);
        formatter.field(
            "service_specific_credential_id",
            &self.service_specific_credential_id,
        );
        formatter.field("service_name", &self.service_name);
        formatter.finish()
    }
}
/// See [`ServiceSpecificCredentialMetadata`](crate::model::ServiceSpecificCredentialMetadata)
pub mod service_specific_credential_metadata {
    /// A builder for [`ServiceSpecificCredentialMetadata`](crate::model::ServiceSpecificCredentialMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::StatusType>,
        pub(crate) service_user_name: std::option::Option<std::string::String>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) service_specific_credential_id: std::option::Option<std::string::String>,
        pub(crate) service_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the IAM user associated with the service-specific credential.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM user associated with the service-specific credential.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The status of the service-specific credential. <code>Active</code> means that the key is
        /// valid for API calls, while <code>Inactive</code> means it is not.</p>
        pub fn status(mut self, input: crate::model::StatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the service-specific credential. <code>Active</code> means that the key is
        /// valid for API calls, while <code>Inactive</code> means it is not.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::StatusType>) -> Self {
            self.status = input;
            self
        }
        /// <p>The generated user name for the service-specific credential.</p>
        pub fn service_user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_user_name = Some(input.into());
            self
        }
        /// <p>The generated user name for the service-specific credential.</p>
        pub fn set_service_user_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_user_name = input;
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the service-specific credential were created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the service-specific credential were created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// <p>The unique identifier for the service-specific credential.</p>
        pub fn service_specific_credential_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.service_specific_credential_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the service-specific credential.</p>
        pub fn set_service_specific_credential_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_specific_credential_id = input;
            self
        }
        /// <p>The name of the service associated with the service-specific credential.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of the service associated with the service-specific credential.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceSpecificCredentialMetadata`](crate::model::ServiceSpecificCredentialMetadata)
        pub fn build(self) -> crate::model::ServiceSpecificCredentialMetadata {
            crate::model::ServiceSpecificCredentialMetadata {
                user_name: self.user_name,
                status: self.status,
                service_user_name: self.service_user_name,
                create_date: self.create_date,
                service_specific_credential_id: self.service_specific_credential_id,
                service_name: self.service_name,
            }
        }
    }
}
impl ServiceSpecificCredentialMetadata {
    /// Creates a new builder-style object to manufacture [`ServiceSpecificCredentialMetadata`](crate::model::ServiceSpecificCredentialMetadata)
    pub fn builder() -> crate::model::service_specific_credential_metadata::Builder {
        crate::model::service_specific_credential_metadata::Builder::default()
    }
}

/// <p>Contains the list of SAML providers for this account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SamlProviderListEntry {
    /// <p>The Amazon Resource Name (ARN) of the SAML provider.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The expiration date and time for the SAML provider.</p>
    pub valid_until: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time when the SAML provider was created.</p>
    pub create_date: std::option::Option<aws_smithy_types::Instant>,
}
impl SamlProviderListEntry {
    /// <p>The Amazon Resource Name (ARN) of the SAML provider.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The expiration date and time for the SAML provider.</p>
    pub fn valid_until(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.valid_until.as_ref()
    }
    /// <p>The date and time when the SAML provider was created.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_date.as_ref()
    }
}
impl std::fmt::Debug for SamlProviderListEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SamlProviderListEntry");
        formatter.field("arn", &self.arn);
        formatter.field("valid_until", &self.valid_until);
        formatter.field("create_date", &self.create_date);
        formatter.finish()
    }
}
/// See [`SamlProviderListEntry`](crate::model::SamlProviderListEntry)
pub mod saml_provider_list_entry {
    /// A builder for [`SamlProviderListEntry`](crate::model::SamlProviderListEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) valid_until: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the SAML provider.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SAML provider.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The expiration date and time for the SAML provider.</p>
        pub fn valid_until(mut self, input: aws_smithy_types::Instant) -> Self {
            self.valid_until = Some(input);
            self
        }
        /// <p>The expiration date and time for the SAML provider.</p>
        pub fn set_valid_until(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.valid_until = input;
            self
        }
        /// <p>The date and time when the SAML provider was created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time when the SAML provider was created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// Consumes the builder and constructs a [`SamlProviderListEntry`](crate::model::SamlProviderListEntry)
        pub fn build(self) -> crate::model::SamlProviderListEntry {
            crate::model::SamlProviderListEntry {
                arn: self.arn,
                valid_until: self.valid_until,
                create_date: self.create_date,
            }
        }
    }
}
impl SamlProviderListEntry {
    /// Creates a new builder-style object to manufacture [`SamlProviderListEntry`](crate::model::SamlProviderListEntry)
    pub fn builder() -> crate::model::saml_provider_list_entry::Builder {
        crate::model::saml_provider_list_entry::Builder::default()
    }
}

/// <p>Contains information about a version of a managed policy.</p>
/// <p>This data type is used as a response element in the <a>CreatePolicyVersion</a>, <a>GetPolicyVersion</a>, <a>ListPolicyVersions</a>, and <a>GetAccountAuthorizationDetails</a> operations. </p>
/// <p>For more information about managed policies, refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
/// policies</a> in the <i>IAM User Guide</i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyVersion {
    /// <p>The policy document.</p>
    /// <p>The policy document is returned in the response to the <a>GetPolicyVersion</a> and <a>GetAccountAuthorizationDetails</a> operations. It is not returned in
    /// the response to the <a>CreatePolicyVersion</a> or <a>ListPolicyVersions</a> operations. </p>
    /// <p>The policy document returned in this structure is URL-encoded compliant with <a href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding
    /// method to convert the policy back to plain JSON text. For example, if you use Java, you can
    /// use the <code>decode</code> method of the <code>java.net.URLDecoder</code> utility class in
    /// the Java SDK. Other languages and SDKs provide similar functionality.</p>
    pub document: std::option::Option<std::string::String>,
    /// <p>The identifier for the policy version.</p>
    /// <p>Policy version identifiers always begin with <code>v</code> (always lowercase). When a
    /// policy is created, the first policy version is <code>v1</code>. </p>
    pub version_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the policy version is set as the policy's default version.</p>
    pub is_default_version: bool,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the policy version was created.</p>
    pub create_date: std::option::Option<aws_smithy_types::Instant>,
}
impl PolicyVersion {
    /// <p>The policy document.</p>
    /// <p>The policy document is returned in the response to the <a>GetPolicyVersion</a> and <a>GetAccountAuthorizationDetails</a> operations. It is not returned in
    /// the response to the <a>CreatePolicyVersion</a> or <a>ListPolicyVersions</a> operations. </p>
    /// <p>The policy document returned in this structure is URL-encoded compliant with <a href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding
    /// method to convert the policy back to plain JSON text. For example, if you use Java, you can
    /// use the <code>decode</code> method of the <code>java.net.URLDecoder</code> utility class in
    /// the Java SDK. Other languages and SDKs provide similar functionality.</p>
    pub fn document(&self) -> std::option::Option<&str> {
        self.document.as_deref()
    }
    /// <p>The identifier for the policy version.</p>
    /// <p>Policy version identifiers always begin with <code>v</code> (always lowercase). When a
    /// policy is created, the first policy version is <code>v1</code>. </p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
    /// <p>Specifies whether the policy version is set as the policy's default version.</p>
    pub fn is_default_version(&self) -> bool {
        self.is_default_version
    }
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the policy version was created.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_date.as_ref()
    }
}
impl std::fmt::Debug for PolicyVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyVersion");
        formatter.field("document", &self.document);
        formatter.field("version_id", &self.version_id);
        formatter.field("is_default_version", &self.is_default_version);
        formatter.field("create_date", &self.create_date);
        formatter.finish()
    }
}
/// See [`PolicyVersion`](crate::model::PolicyVersion)
pub mod policy_version {
    /// A builder for [`PolicyVersion`](crate::model::PolicyVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) document: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
        pub(crate) is_default_version: std::option::Option<bool>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The policy document.</p>
        /// <p>The policy document is returned in the response to the <a>GetPolicyVersion</a> and <a>GetAccountAuthorizationDetails</a> operations. It is not returned in
        /// the response to the <a>CreatePolicyVersion</a> or <a>ListPolicyVersions</a> operations. </p>
        /// <p>The policy document returned in this structure is URL-encoded compliant with <a href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding
        /// method to convert the policy back to plain JSON text. For example, if you use Java, you can
        /// use the <code>decode</code> method of the <code>java.net.URLDecoder</code> utility class in
        /// the Java SDK. Other languages and SDKs provide similar functionality.</p>
        pub fn document(mut self, input: impl Into<std::string::String>) -> Self {
            self.document = Some(input.into());
            self
        }
        /// <p>The policy document.</p>
        /// <p>The policy document is returned in the response to the <a>GetPolicyVersion</a> and <a>GetAccountAuthorizationDetails</a> operations. It is not returned in
        /// the response to the <a>CreatePolicyVersion</a> or <a>ListPolicyVersions</a> operations. </p>
        /// <p>The policy document returned in this structure is URL-encoded compliant with <a href="https://tools.ietf.org/html/rfc3986">RFC 3986</a>. You can use a URL decoding
        /// method to convert the policy back to plain JSON text. For example, if you use Java, you can
        /// use the <code>decode</code> method of the <code>java.net.URLDecoder</code> utility class in
        /// the Java SDK. Other languages and SDKs provide similar functionality.</p>
        pub fn set_document(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document = input;
            self
        }
        /// <p>The identifier for the policy version.</p>
        /// <p>Policy version identifiers always begin with <code>v</code> (always lowercase). When a
        /// policy is created, the first policy version is <code>v1</code>. </p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The identifier for the policy version.</p>
        /// <p>Policy version identifiers always begin with <code>v</code> (always lowercase). When a
        /// policy is created, the first policy version is <code>v1</code>. </p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// <p>Specifies whether the policy version is set as the policy's default version.</p>
        pub fn is_default_version(mut self, input: bool) -> Self {
            self.is_default_version = Some(input);
            self
        }
        /// <p>Specifies whether the policy version is set as the policy's default version.</p>
        pub fn set_is_default_version(mut self, input: std::option::Option<bool>) -> Self {
            self.is_default_version = input;
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the policy version was created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the policy version was created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyVersion`](crate::model::PolicyVersion)
        pub fn build(self) -> crate::model::PolicyVersion {
            crate::model::PolicyVersion {
                document: self.document,
                version_id: self.version_id,
                is_default_version: self.is_default_version.unwrap_or_default(),
                create_date: self.create_date,
            }
        }
    }
}
impl PolicyVersion {
    /// Creates a new builder-style object to manufacture [`PolicyVersion`](crate::model::PolicyVersion)
    pub fn builder() -> crate::model::policy_version::Builder {
        crate::model::policy_version::Builder::default()
    }
}

/// <p>Contains details about the permissions policies that are attached to the specified
/// identity (user, group, or role).</p>
/// <p>This data type is used as a response element in the <a>ListPoliciesGrantingServiceAccess</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPoliciesGrantingServiceAccessEntry {
    /// <p>The namespace of the service that was accessed.</p>
    /// <p>To learn the service namespace of a service, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html">Actions, resources, and condition keys for Amazon Web Services services</a> in the
    /// <i>Service Authorization Reference</i>. Choose the name of the service to
    /// view details for that service. In the first paragraph, find the service prefix. For
    /// example, <code>(service prefix: a4b)</code>. For more information about service namespaces,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces">Amazon Web Services
    /// service namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub service_namespace: std::option::Option<std::string::String>,
    /// <p>The <code>PoliciesGrantingServiceAccess</code> object that contains details about the
    /// policy.</p>
    pub policies: std::option::Option<std::vec::Vec<crate::model::PolicyGrantingServiceAccess>>,
}
impl ListPoliciesGrantingServiceAccessEntry {
    /// <p>The namespace of the service that was accessed.</p>
    /// <p>To learn the service namespace of a service, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html">Actions, resources, and condition keys for Amazon Web Services services</a> in the
    /// <i>Service Authorization Reference</i>. Choose the name of the service to
    /// view details for that service. In the first paragraph, find the service prefix. For
    /// example, <code>(service prefix: a4b)</code>. For more information about service namespaces,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces">Amazon Web Services
    /// service namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn service_namespace(&self) -> std::option::Option<&str> {
        self.service_namespace.as_deref()
    }
    /// <p>The <code>PoliciesGrantingServiceAccess</code> object that contains details about the
    /// policy.</p>
    pub fn policies(&self) -> std::option::Option<&[crate::model::PolicyGrantingServiceAccess]> {
        self.policies.as_deref()
    }
}
impl std::fmt::Debug for ListPoliciesGrantingServiceAccessEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPoliciesGrantingServiceAccessEntry");
        formatter.field("service_namespace", &self.service_namespace);
        formatter.field("policies", &self.policies);
        formatter.finish()
    }
}
/// See [`ListPoliciesGrantingServiceAccessEntry`](crate::model::ListPoliciesGrantingServiceAccessEntry)
pub mod list_policies_granting_service_access_entry {
    /// A builder for [`ListPoliciesGrantingServiceAccessEntry`](crate::model::ListPoliciesGrantingServiceAccessEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_namespace: std::option::Option<std::string::String>,
        pub(crate) policies:
            std::option::Option<std::vec::Vec<crate::model::PolicyGrantingServiceAccess>>,
    }
    impl Builder {
        /// <p>The namespace of the service that was accessed.</p>
        /// <p>To learn the service namespace of a service, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html">Actions, resources, and condition keys for Amazon Web Services services</a> in the
        /// <i>Service Authorization Reference</i>. Choose the name of the service to
        /// view details for that service. In the first paragraph, find the service prefix. For
        /// example, <code>(service prefix: a4b)</code>. For more information about service namespaces,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces">Amazon Web Services
        /// service namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn service_namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_namespace = Some(input.into());
            self
        }
        /// <p>The namespace of the service that was accessed.</p>
        /// <p>To learn the service namespace of a service, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html">Actions, resources, and condition keys for Amazon Web Services services</a> in the
        /// <i>Service Authorization Reference</i>. Choose the name of the service to
        /// view details for that service. In the first paragraph, find the service prefix. For
        /// example, <code>(service prefix: a4b)</code>. For more information about service namespaces,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces">Amazon Web Services
        /// service namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_service_namespace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_namespace = input;
            self
        }
        /// Appends an item to `policies`.
        ///
        /// To override the contents of this collection use [`set_policies`](Self::set_policies).
        ///
        /// <p>The <code>PoliciesGrantingServiceAccess</code> object that contains details about the
        /// policy.</p>
        pub fn policies(
            mut self,
            input: impl Into<crate::model::PolicyGrantingServiceAccess>,
        ) -> Self {
            let mut v = self.policies.unwrap_or_default();
            v.push(input.into());
            self.policies = Some(v);
            self
        }
        /// <p>The <code>PoliciesGrantingServiceAccess</code> object that contains details about the
        /// policy.</p>
        pub fn set_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PolicyGrantingServiceAccess>>,
        ) -> Self {
            self.policies = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPoliciesGrantingServiceAccessEntry`](crate::model::ListPoliciesGrantingServiceAccessEntry)
        pub fn build(self) -> crate::model::ListPoliciesGrantingServiceAccessEntry {
            crate::model::ListPoliciesGrantingServiceAccessEntry {
                service_namespace: self.service_namespace,
                policies: self.policies,
            }
        }
    }
}
impl ListPoliciesGrantingServiceAccessEntry {
    /// Creates a new builder-style object to manufacture [`ListPoliciesGrantingServiceAccessEntry`](crate::model::ListPoliciesGrantingServiceAccessEntry)
    pub fn builder() -> crate::model::list_policies_granting_service_access_entry::Builder {
        crate::model::list_policies_granting_service_access_entry::Builder::default()
    }
}

/// <p>Contains details about the permissions policies that are attached to the specified
/// identity (user, group, or role).</p>
/// <p>This data type is an element of the <a>ListPoliciesGrantingServiceAccessEntry</a> object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyGrantingServiceAccess {
    /// <p>The policy name.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The policy type. For more information about these policy types, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed
    /// policies and inline policies</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub policy_type: std::option::Option<crate::model::PolicyType>,
    /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
    /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
    /// the <i>Amazon Web Services General Reference</i>. </p>
    pub policy_arn: std::option::Option<std::string::String>,
    /// <p>The type of entity (user or role) that used the policy to access the service to which
    /// the inline policy is attached.</p>
    /// <p>This field is null for managed policies. For more information about these policy types,
    /// see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed policies and inline policies</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub entity_type: std::option::Option<crate::model::PolicyOwnerEntityType>,
    /// <p>The name of the entity (user or role) to which the inline policy is attached.</p>
    /// <p>This field is null for managed policies. For more information about these policy types,
    /// see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed policies and inline policies</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub entity_name: std::option::Option<std::string::String>,
}
impl PolicyGrantingServiceAccess {
    /// <p>The policy name.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The policy type. For more information about these policy types, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed
    /// policies and inline policies</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub fn policy_type(&self) -> std::option::Option<&crate::model::PolicyType> {
        self.policy_type.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
    /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
    /// the <i>Amazon Web Services General Reference</i>. </p>
    pub fn policy_arn(&self) -> std::option::Option<&str> {
        self.policy_arn.as_deref()
    }
    /// <p>The type of entity (user or role) that used the policy to access the service to which
    /// the inline policy is attached.</p>
    /// <p>This field is null for managed policies. For more information about these policy types,
    /// see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed policies and inline policies</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub fn entity_type(&self) -> std::option::Option<&crate::model::PolicyOwnerEntityType> {
        self.entity_type.as_ref()
    }
    /// <p>The name of the entity (user or role) to which the inline policy is attached.</p>
    /// <p>This field is null for managed policies. For more information about these policy types,
    /// see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed policies and inline policies</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub fn entity_name(&self) -> std::option::Option<&str> {
        self.entity_name.as_deref()
    }
}
impl std::fmt::Debug for PolicyGrantingServiceAccess {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyGrantingServiceAccess");
        formatter.field("policy_name", &self.policy_name);
        formatter.field("policy_type", &self.policy_type);
        formatter.field("policy_arn", &self.policy_arn);
        formatter.field("entity_type", &self.entity_type);
        formatter.field("entity_name", &self.entity_name);
        formatter.finish()
    }
}
/// See [`PolicyGrantingServiceAccess`](crate::model::PolicyGrantingServiceAccess)
pub mod policy_granting_service_access {
    /// A builder for [`PolicyGrantingServiceAccess`](crate::model::PolicyGrantingServiceAccess)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy_type: std::option::Option<crate::model::PolicyType>,
        pub(crate) policy_arn: std::option::Option<std::string::String>,
        pub(crate) entity_type: std::option::Option<crate::model::PolicyOwnerEntityType>,
        pub(crate) entity_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The policy name.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The policy name.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The policy type. For more information about these policy types, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed
        /// policies and inline policies</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn policy_type(mut self, input: crate::model::PolicyType) -> Self {
            self.policy_type = Some(input);
            self
        }
        /// <p>The policy type. For more information about these policy types, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed
        /// policies and inline policies</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn set_policy_type(
            mut self,
            input: std::option::Option<crate::model::PolicyType>,
        ) -> Self {
            self.policy_type = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
        /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
        /// the <i>Amazon Web Services General Reference</i>. </p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
        /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
        /// the <i>Amazon Web Services General Reference</i>. </p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// <p>The type of entity (user or role) that used the policy to access the service to which
        /// the inline policy is attached.</p>
        /// <p>This field is null for managed policies. For more information about these policy types,
        /// see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed policies and inline policies</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn entity_type(mut self, input: crate::model::PolicyOwnerEntityType) -> Self {
            self.entity_type = Some(input);
            self
        }
        /// <p>The type of entity (user or role) that used the policy to access the service to which
        /// the inline policy is attached.</p>
        /// <p>This field is null for managed policies. For more information about these policy types,
        /// see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed policies and inline policies</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn set_entity_type(
            mut self,
            input: std::option::Option<crate::model::PolicyOwnerEntityType>,
        ) -> Self {
            self.entity_type = input;
            self
        }
        /// <p>The name of the entity (user or role) to which the inline policy is attached.</p>
        /// <p>This field is null for managed policies. For more information about these policy types,
        /// see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed policies and inline policies</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn entity_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_name = Some(input.into());
            self
        }
        /// <p>The name of the entity (user or role) to which the inline policy is attached.</p>
        /// <p>This field is null for managed policies. For more information about these policy types,
        /// see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed policies and inline policies</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn set_entity_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_name = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyGrantingServiceAccess`](crate::model::PolicyGrantingServiceAccess)
        pub fn build(self) -> crate::model::PolicyGrantingServiceAccess {
            crate::model::PolicyGrantingServiceAccess {
                policy_name: self.policy_name,
                policy_type: self.policy_type,
                policy_arn: self.policy_arn,
                entity_type: self.entity_type,
                entity_name: self.entity_name,
            }
        }
    }
}
impl PolicyGrantingServiceAccess {
    /// Creates a new builder-style object to manufacture [`PolicyGrantingServiceAccess`](crate::model::PolicyGrantingServiceAccess)
    pub fn builder() -> crate::model::policy_granting_service_access::Builder {
        crate::model::policy_granting_service_access::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PolicyOwnerEntityType {
    #[allow(missing_docs)] // documentation missing in model
    Group,
    #[allow(missing_docs)] // documentation missing in model
    Role,
    #[allow(missing_docs)] // documentation missing in model
    User,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PolicyOwnerEntityType {
    fn from(s: &str) -> Self {
        match s {
            "GROUP" => PolicyOwnerEntityType::Group,
            "ROLE" => PolicyOwnerEntityType::Role,
            "USER" => PolicyOwnerEntityType::User,
            other => PolicyOwnerEntityType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PolicyOwnerEntityType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PolicyOwnerEntityType::from(s))
    }
}
impl PolicyOwnerEntityType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PolicyOwnerEntityType::Group => "GROUP",
            PolicyOwnerEntityType::Role => "ROLE",
            PolicyOwnerEntityType::User => "USER",
            PolicyOwnerEntityType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GROUP", "ROLE", "USER"]
    }
}
impl AsRef<str> for PolicyOwnerEntityType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PolicyType {
    #[allow(missing_docs)] // documentation missing in model
    Inline,
    #[allow(missing_docs)] // documentation missing in model
    Managed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PolicyType {
    fn from(s: &str) -> Self {
        match s {
            "INLINE" => PolicyType::Inline,
            "MANAGED" => PolicyType::Managed,
            other => PolicyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PolicyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PolicyType::from(s))
    }
}
impl PolicyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PolicyType::Inline => "INLINE",
            PolicyType::Managed => "MANAGED",
            PolicyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INLINE", "MANAGED"]
    }
}
impl AsRef<str> for PolicyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a managed policy.</p>
/// <p>This data type is used as a response element in the <a>CreatePolicy</a>,
/// <a>GetPolicy</a>, and <a>ListPolicies</a> operations. </p>
/// <p>For more information about managed policies, refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
/// policies</a> in the <i>IAM User Guide</i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Policy {
    /// <p>The friendly name (not ARN) identifying the policy.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The stable and unique string identifying the policy.</p>
    /// <p>For more information about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub policy_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
    /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
    /// the <i>Amazon Web Services General Reference</i>. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The path to the policy.</p>
    /// <p>For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The identifier for the version of the policy that is set as the default version.</p>
    pub default_version_id: std::option::Option<std::string::String>,
    /// <p>The number of entities (users, groups, and roles) that the policy is attached to.</p>
    pub attachment_count: std::option::Option<i32>,
    /// <p>The number of entities (users and roles) for which the policy is used to set the
    /// permissions boundary. </p>
    /// <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
    /// identities </a> in the <i>IAM User Guide</i>.</p>
    pub permissions_boundary_usage_count: std::option::Option<i32>,
    /// <p>Specifies whether the policy can be attached to an IAM user, group, or role.</p>
    pub is_attachable: bool,
    /// <p>A friendly description of the policy.</p>
    /// <p>This element is included in the response to the <a>GetPolicy</a> operation.
    /// It is not included in the response to the <a>ListPolicies</a> operation. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the policy was created.</p>
    pub create_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the policy was last updated.</p>
    /// <p>When a policy has only one version, this field contains the date and time when the
    /// policy was created. When a policy has more than one version, this field contains the date
    /// and time when the most recent policy version was created.</p>
    pub update_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A list of tags that are attached to the instance profile. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl Policy {
    /// <p>The friendly name (not ARN) identifying the policy.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The stable and unique string identifying the policy.</p>
    /// <p>For more information about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub fn policy_id(&self) -> std::option::Option<&str> {
        self.policy_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
    /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
    /// the <i>Amazon Web Services General Reference</i>. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The path to the policy.</p>
    /// <p>For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>The identifier for the version of the policy that is set as the default version.</p>
    pub fn default_version_id(&self) -> std::option::Option<&str> {
        self.default_version_id.as_deref()
    }
    /// <p>The number of entities (users, groups, and roles) that the policy is attached to.</p>
    pub fn attachment_count(&self) -> std::option::Option<i32> {
        self.attachment_count
    }
    /// <p>The number of entities (users and roles) for which the policy is used to set the
    /// permissions boundary. </p>
    /// <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
    /// identities </a> in the <i>IAM User Guide</i>.</p>
    pub fn permissions_boundary_usage_count(&self) -> std::option::Option<i32> {
        self.permissions_boundary_usage_count
    }
    /// <p>Specifies whether the policy can be attached to an IAM user, group, or role.</p>
    pub fn is_attachable(&self) -> bool {
        self.is_attachable
    }
    /// <p>A friendly description of the policy.</p>
    /// <p>This element is included in the response to the <a>GetPolicy</a> operation.
    /// It is not included in the response to the <a>ListPolicies</a> operation. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the policy was created.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_date.as_ref()
    }
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the policy was last updated.</p>
    /// <p>When a policy has only one version, this field contains the date and time when the
    /// policy was created. When a policy has more than one version, this field contains the date
    /// and time when the most recent policy version was created.</p>
    pub fn update_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.update_date.as_ref()
    }
    /// <p>A list of tags that are attached to the instance profile. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for Policy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Policy");
        formatter.field("policy_name", &self.policy_name);
        formatter.field("policy_id", &self.policy_id);
        formatter.field("arn", &self.arn);
        formatter.field("path", &self.path);
        formatter.field("default_version_id", &self.default_version_id);
        formatter.field("attachment_count", &self.attachment_count);
        formatter.field(
            "permissions_boundary_usage_count",
            &self.permissions_boundary_usage_count,
        );
        formatter.field("is_attachable", &self.is_attachable);
        formatter.field("description", &self.description);
        formatter.field("create_date", &self.create_date);
        formatter.field("update_date", &self.update_date);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Policy`](crate::model::Policy)
pub mod policy {
    /// A builder for [`Policy`](crate::model::Policy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) default_version_id: std::option::Option<std::string::String>,
        pub(crate) attachment_count: std::option::Option<i32>,
        pub(crate) permissions_boundary_usage_count: std::option::Option<i32>,
        pub(crate) is_attachable: std::option::Option<bool>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) update_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The friendly name (not ARN) identifying the policy.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The friendly name (not ARN) identifying the policy.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The stable and unique string identifying the policy.</p>
        /// <p>For more information about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_id = Some(input.into());
            self
        }
        /// <p>The stable and unique string identifying the policy.</p>
        /// <p>For more information about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
        /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
        /// the <i>Amazon Web Services General Reference</i>. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
        /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
        /// the <i>Amazon Web Services General Reference</i>. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The path to the policy.</p>
        /// <p>For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The path to the policy.</p>
        /// <p>For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The identifier for the version of the policy that is set as the default version.</p>
        pub fn default_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_version_id = Some(input.into());
            self
        }
        /// <p>The identifier for the version of the policy that is set as the default version.</p>
        pub fn set_default_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_version_id = input;
            self
        }
        /// <p>The number of entities (users, groups, and roles) that the policy is attached to.</p>
        pub fn attachment_count(mut self, input: i32) -> Self {
            self.attachment_count = Some(input);
            self
        }
        /// <p>The number of entities (users, groups, and roles) that the policy is attached to.</p>
        pub fn set_attachment_count(mut self, input: std::option::Option<i32>) -> Self {
            self.attachment_count = input;
            self
        }
        /// <p>The number of entities (users and roles) for which the policy is used to set the
        /// permissions boundary. </p>
        /// <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
        /// identities </a> in the <i>IAM User Guide</i>.</p>
        pub fn permissions_boundary_usage_count(mut self, input: i32) -> Self {
            self.permissions_boundary_usage_count = Some(input);
            self
        }
        /// <p>The number of entities (users and roles) for which the policy is used to set the
        /// permissions boundary. </p>
        /// <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
        /// identities </a> in the <i>IAM User Guide</i>.</p>
        pub fn set_permissions_boundary_usage_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.permissions_boundary_usage_count = input;
            self
        }
        /// <p>Specifies whether the policy can be attached to an IAM user, group, or role.</p>
        pub fn is_attachable(mut self, input: bool) -> Self {
            self.is_attachable = Some(input);
            self
        }
        /// <p>Specifies whether the policy can be attached to an IAM user, group, or role.</p>
        pub fn set_is_attachable(mut self, input: std::option::Option<bool>) -> Self {
            self.is_attachable = input;
            self
        }
        /// <p>A friendly description of the policy.</p>
        /// <p>This element is included in the response to the <a>GetPolicy</a> operation.
        /// It is not included in the response to the <a>ListPolicies</a> operation. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A friendly description of the policy.</p>
        /// <p>This element is included in the response to the <a>GetPolicy</a> operation.
        /// It is not included in the response to the <a>ListPolicies</a> operation. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the policy was created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the policy was created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the policy was last updated.</p>
        /// <p>When a policy has only one version, this field contains the date and time when the
        /// policy was created. When a policy has more than one version, this field contains the date
        /// and time when the most recent policy version was created.</p>
        pub fn update_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.update_date = Some(input);
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the policy was last updated.</p>
        /// <p>When a policy has only one version, this field contains the date and time when the
        /// policy was created. When a policy has more than one version, this field contains the date
        /// and time when the most recent policy version was created.</p>
        pub fn set_update_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.update_date = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that are attached to the instance profile. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags that are attached to the instance profile. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Policy`](crate::model::Policy)
        pub fn build(self) -> crate::model::Policy {
            crate::model::Policy {
                policy_name: self.policy_name,
                policy_id: self.policy_id,
                arn: self.arn,
                path: self.path,
                default_version_id: self.default_version_id,
                attachment_count: self.attachment_count,
                permissions_boundary_usage_count: self.permissions_boundary_usage_count,
                is_attachable: self.is_attachable.unwrap_or_default(),
                description: self.description,
                create_date: self.create_date,
                update_date: self.update_date,
                tags: self.tags,
            }
        }
    }
}
impl Policy {
    /// Creates a new builder-style object to manufacture [`Policy`](crate::model::Policy)
    pub fn builder() -> crate::model::policy::Builder {
        crate::model::policy::Builder::default()
    }
}

/// <p>The policy usage type that indicates whether the policy is used as a permissions policy
/// or as the permissions boundary for an entity.</p>
/// <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
/// identities </a> in the <i>IAM User Guide</i>.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PolicyUsageType {
    #[allow(missing_docs)] // documentation missing in model
    PermissionsBoundary,
    #[allow(missing_docs)] // documentation missing in model
    PermissionsPolicy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PolicyUsageType {
    fn from(s: &str) -> Self {
        match s {
            "PermissionsBoundary" => PolicyUsageType::PermissionsBoundary,
            "PermissionsPolicy" => PolicyUsageType::PermissionsPolicy,
            other => PolicyUsageType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PolicyUsageType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PolicyUsageType::from(s))
    }
}
impl PolicyUsageType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PolicyUsageType::PermissionsBoundary => "PermissionsBoundary",
            PolicyUsageType::PermissionsPolicy => "PermissionsPolicy",
            PolicyUsageType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PermissionsBoundary", "PermissionsPolicy"]
    }
}
impl AsRef<str> for PolicyUsageType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PolicyScopeType {
    #[allow(missing_docs)] // documentation missing in model
    Aws,
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Local,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PolicyScopeType {
    fn from(s: &str) -> Self {
        match s {
            "AWS" => PolicyScopeType::Aws,
            "All" => PolicyScopeType::All,
            "Local" => PolicyScopeType::Local,
            other => PolicyScopeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PolicyScopeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PolicyScopeType::from(s))
    }
}
impl PolicyScopeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PolicyScopeType::Aws => "AWS",
            PolicyScopeType::All => "All",
            PolicyScopeType::Local => "Local",
            PolicyScopeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS", "All", "Local"]
    }
}
impl AsRef<str> for PolicyScopeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the Amazon Resource Name (ARN) for an IAM OpenID Connect provider.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpenIdConnectProviderListEntry {
    /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
    /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
    /// the <i>Amazon Web Services General Reference</i>. </p>
    pub arn: std::option::Option<std::string::String>,
}
impl OpenIdConnectProviderListEntry {
    /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
    /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
    /// the <i>Amazon Web Services General Reference</i>. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for OpenIdConnectProviderListEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpenIdConnectProviderListEntry");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`OpenIdConnectProviderListEntry`](crate::model::OpenIdConnectProviderListEntry)
pub mod open_id_connect_provider_list_entry {
    /// A builder for [`OpenIdConnectProviderListEntry`](crate::model::OpenIdConnectProviderListEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
        /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
        /// the <i>Amazon Web Services General Reference</i>. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
        /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
        /// the <i>Amazon Web Services General Reference</i>. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`OpenIdConnectProviderListEntry`](crate::model::OpenIdConnectProviderListEntry)
        pub fn build(self) -> crate::model::OpenIdConnectProviderListEntry {
            crate::model::OpenIdConnectProviderListEntry { arn: self.arn }
        }
    }
}
impl OpenIdConnectProviderListEntry {
    /// Creates a new builder-style object to manufacture [`OpenIdConnectProviderListEntry`](crate::model::OpenIdConnectProviderListEntry)
    pub fn builder() -> crate::model::open_id_connect_provider_list_entry::Builder {
        crate::model::open_id_connect_provider_list_entry::Builder::default()
    }
}

/// <p>Contains information about an MFA device.</p>
/// <p>This data type is used as a response element in the <a>ListMFADevices</a>
/// operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MfaDevice {
    /// <p>The user with whom the MFA device is associated.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The serial number that uniquely identifies the MFA device. For virtual MFA devices, the
    /// serial number is the device ARN.</p>
    pub serial_number: std::option::Option<std::string::String>,
    /// <p>The date when the MFA device was enabled for the user.</p>
    pub enable_date: std::option::Option<aws_smithy_types::Instant>,
}
impl MfaDevice {
    /// <p>The user with whom the MFA device is associated.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The serial number that uniquely identifies the MFA device. For virtual MFA devices, the
    /// serial number is the device ARN.</p>
    pub fn serial_number(&self) -> std::option::Option<&str> {
        self.serial_number.as_deref()
    }
    /// <p>The date when the MFA device was enabled for the user.</p>
    pub fn enable_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.enable_date.as_ref()
    }
}
impl std::fmt::Debug for MfaDevice {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MfaDevice");
        formatter.field("user_name", &self.user_name);
        formatter.field("serial_number", &self.serial_number);
        formatter.field("enable_date", &self.enable_date);
        formatter.finish()
    }
}
/// See [`MfaDevice`](crate::model::MfaDevice)
pub mod mfa_device {
    /// A builder for [`MfaDevice`](crate::model::MfaDevice)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) serial_number: std::option::Option<std::string::String>,
        pub(crate) enable_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The user with whom the MFA device is associated.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The user with whom the MFA device is associated.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The serial number that uniquely identifies the MFA device. For virtual MFA devices, the
        /// serial number is the device ARN.</p>
        pub fn serial_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.serial_number = Some(input.into());
            self
        }
        /// <p>The serial number that uniquely identifies the MFA device. For virtual MFA devices, the
        /// serial number is the device ARN.</p>
        pub fn set_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.serial_number = input;
            self
        }
        /// <p>The date when the MFA device was enabled for the user.</p>
        pub fn enable_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.enable_date = Some(input);
            self
        }
        /// <p>The date when the MFA device was enabled for the user.</p>
        pub fn set_enable_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.enable_date = input;
            self
        }
        /// Consumes the builder and constructs a [`MfaDevice`](crate::model::MfaDevice)
        pub fn build(self) -> crate::model::MfaDevice {
            crate::model::MfaDevice {
                user_name: self.user_name,
                serial_number: self.serial_number,
                enable_date: self.enable_date,
            }
        }
    }
}
impl MfaDevice {
    /// Creates a new builder-style object to manufacture [`MfaDevice`](crate::model::MfaDevice)
    pub fn builder() -> crate::model::mfa_device::Builder {
        crate::model::mfa_device::Builder::default()
    }
}

/// <p>Contains information about an instance profile.</p>
/// <p>This data type is used as a response element in the following operations:</p>
/// <ul>
/// <li>
/// <p>
/// <a>CreateInstanceProfile</a>
/// </p>
/// </li>
/// <li>
/// <p>
/// <a>GetInstanceProfile</a>
/// </p>
/// </li>
/// <li>
/// <p>
/// <a>ListInstanceProfiles</a>
/// </p>
/// </li>
/// <li>
/// <p>
/// <a>ListInstanceProfilesForRole</a>
/// </p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceProfile {
    /// <p> The path to the instance profile. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
    /// identifiers</a> in the <i>IAM User Guide</i>. </p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The name identifying the instance profile.</p>
    pub instance_profile_name: std::option::Option<std::string::String>,
    /// <p> The stable and unique string identifying the instance profile. For more information
    /// about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>. </p>
    pub instance_profile_id: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) specifying the instance profile. For more information
    /// about ARNs and how to use them in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
    /// <i>IAM User Guide</i>. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The date when the instance profile was created.</p>
    pub create_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The role associated with the instance profile.</p>
    pub roles: std::option::Option<std::vec::Vec<crate::model::Role>>,
    /// <p>A list of tags that are attached to the instance profile. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl InstanceProfile {
    /// <p> The path to the instance profile. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
    /// identifiers</a> in the <i>IAM User Guide</i>. </p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>The name identifying the instance profile.</p>
    pub fn instance_profile_name(&self) -> std::option::Option<&str> {
        self.instance_profile_name.as_deref()
    }
    /// <p> The stable and unique string identifying the instance profile. For more information
    /// about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>. </p>
    pub fn instance_profile_id(&self) -> std::option::Option<&str> {
        self.instance_profile_id.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) specifying the instance profile. For more information
    /// about ARNs and how to use them in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
    /// <i>IAM User Guide</i>. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The date when the instance profile was created.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_date.as_ref()
    }
    /// <p>The role associated with the instance profile.</p>
    pub fn roles(&self) -> std::option::Option<&[crate::model::Role]> {
        self.roles.as_deref()
    }
    /// <p>A list of tags that are attached to the instance profile. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for InstanceProfile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceProfile");
        formatter.field("path", &self.path);
        formatter.field("instance_profile_name", &self.instance_profile_name);
        formatter.field("instance_profile_id", &self.instance_profile_id);
        formatter.field("arn", &self.arn);
        formatter.field("create_date", &self.create_date);
        formatter.field("roles", &self.roles);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`InstanceProfile`](crate::model::InstanceProfile)
pub mod instance_profile {
    /// A builder for [`InstanceProfile`](crate::model::InstanceProfile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) instance_profile_name: std::option::Option<std::string::String>,
        pub(crate) instance_profile_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) roles: std::option::Option<std::vec::Vec<crate::model::Role>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p> The path to the instance profile. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>. </p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p> The path to the instance profile. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>. </p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The name identifying the instance profile.</p>
        pub fn instance_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_profile_name = Some(input.into());
            self
        }
        /// <p>The name identifying the instance profile.</p>
        pub fn set_instance_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_profile_name = input;
            self
        }
        /// <p> The stable and unique string identifying the instance profile. For more information
        /// about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>. </p>
        pub fn instance_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_profile_id = Some(input.into());
            self
        }
        /// <p> The stable and unique string identifying the instance profile. For more information
        /// about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the <i>IAM User Guide</i>. </p>
        pub fn set_instance_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_profile_id = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) specifying the instance profile. For more information
        /// about ARNs and how to use them in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i>. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) specifying the instance profile. For more information
        /// about ARNs and how to use them in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i>. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The date when the instance profile was created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date when the instance profile was created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// Appends an item to `roles`.
        ///
        /// To override the contents of this collection use [`set_roles`](Self::set_roles).
        ///
        /// <p>The role associated with the instance profile.</p>
        pub fn roles(mut self, input: impl Into<crate::model::Role>) -> Self {
            let mut v = self.roles.unwrap_or_default();
            v.push(input.into());
            self.roles = Some(v);
            self
        }
        /// <p>The role associated with the instance profile.</p>
        pub fn set_roles(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Role>>,
        ) -> Self {
            self.roles = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that are attached to the instance profile. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags that are attached to the instance profile. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceProfile`](crate::model::InstanceProfile)
        pub fn build(self) -> crate::model::InstanceProfile {
            crate::model::InstanceProfile {
                path: self.path,
                instance_profile_name: self.instance_profile_name,
                instance_profile_id: self.instance_profile_id,
                arn: self.arn,
                create_date: self.create_date,
                roles: self.roles,
                tags: self.tags,
            }
        }
    }
}
impl InstanceProfile {
    /// Creates a new builder-style object to manufacture [`InstanceProfile`](crate::model::InstanceProfile)
    pub fn builder() -> crate::model::instance_profile::Builder {
        crate::model::instance_profile::Builder::default()
    }
}

/// <p>Contains information about an IAM group entity.</p>
/// <p>This data type is used as a response element in the following operations:</p>
/// <ul>
/// <li>
/// <p>
/// <a>CreateGroup</a>
/// </p>
/// </li>
/// <li>
/// <p>
/// <a>GetGroup</a>
/// </p>
/// </li>
/// <li>
/// <p>
/// <a>ListGroups</a>
/// </p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Group {
    /// <p>The path to the group. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
    /// <i>IAM User Guide</i>. </p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The friendly name that identifies the group.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p> The stable and unique string identifying the group. For more information about IDs, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
    /// identifiers</a> in the <i>IAM User Guide</i>. </p>
    pub group_id: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) specifying the group. For more information about ARNs
    /// and how to use them in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
    /// <i>IAM User Guide</i>. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the group was created.</p>
    pub create_date: std::option::Option<aws_smithy_types::Instant>,
}
impl Group {
    /// <p>The path to the group. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
    /// <i>IAM User Guide</i>. </p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>The friendly name that identifies the group.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p> The stable and unique string identifying the group. For more information about IDs, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
    /// identifiers</a> in the <i>IAM User Guide</i>. </p>
    pub fn group_id(&self) -> std::option::Option<&str> {
        self.group_id.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) specifying the group. For more information about ARNs
    /// and how to use them in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
    /// <i>IAM User Guide</i>. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the group was created.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_date.as_ref()
    }
}
impl std::fmt::Debug for Group {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Group");
        formatter.field("path", &self.path);
        formatter.field("group_name", &self.group_name);
        formatter.field("group_id", &self.group_id);
        formatter.field("arn", &self.arn);
        formatter.field("create_date", &self.create_date);
        formatter.finish()
    }
}
/// See [`Group`](crate::model::Group)
pub mod group {
    /// A builder for [`Group`](crate::model::Group)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) group_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The path to the group. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i>. </p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The path to the group. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i>. </p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The friendly name that identifies the group.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The friendly name that identifies the group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p> The stable and unique string identifying the group. For more information about IDs, see
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>. </p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// <p> The stable and unique string identifying the group. For more information about IDs, see
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>. </p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) specifying the group. For more information about ARNs
        /// and how to use them in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i>. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) specifying the group. For more information about ARNs
        /// and how to use them in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i>. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the group was created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the group was created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// Consumes the builder and constructs a [`Group`](crate::model::Group)
        pub fn build(self) -> crate::model::Group {
            crate::model::Group {
                path: self.path,
                group_name: self.group_name,
                group_id: self.group_id,
                arn: self.arn,
                create_date: self.create_date,
            }
        }
    }
}
impl Group {
    /// Creates a new builder-style object to manufacture [`Group`](crate::model::Group)
    pub fn builder() -> crate::model::group::Builder {
        crate::model::group::Builder::default()
    }
}

/// <p>Contains information about a role that a managed policy is attached to.</p>
/// <p>This data type is used as a response element in the <a>ListEntitiesForPolicy</a> operation. </p>
/// <p>For more information about managed policies, refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
/// policies</a> in the <i>IAM User Guide</i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyRole {
    /// <p>The name (friendly name, not ARN) identifying the role.</p>
    pub role_name: std::option::Option<std::string::String>,
    /// <p>The stable and unique string identifying the role. For more information about IDs, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM
    /// identifiers</a> in the <i>IAM User Guide</i>.</p>
    pub role_id: std::option::Option<std::string::String>,
}
impl PolicyRole {
    /// <p>The name (friendly name, not ARN) identifying the role.</p>
    pub fn role_name(&self) -> std::option::Option<&str> {
        self.role_name.as_deref()
    }
    /// <p>The stable and unique string identifying the role. For more information about IDs, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM
    /// identifiers</a> in the <i>IAM User Guide</i>.</p>
    pub fn role_id(&self) -> std::option::Option<&str> {
        self.role_id.as_deref()
    }
}
impl std::fmt::Debug for PolicyRole {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyRole");
        formatter.field("role_name", &self.role_name);
        formatter.field("role_id", &self.role_id);
        formatter.finish()
    }
}
/// See [`PolicyRole`](crate::model::PolicyRole)
pub mod policy_role {
    /// A builder for [`PolicyRole`](crate::model::PolicyRole)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_name: std::option::Option<std::string::String>,
        pub(crate) role_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name (friendly name, not ARN) identifying the role.</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>The name (friendly name, not ARN) identifying the role.</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// <p>The stable and unique string identifying the role. For more information about IDs, see
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>.</p>
        pub fn role_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_id = Some(input.into());
            self
        }
        /// <p>The stable and unique string identifying the role. For more information about IDs, see
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>.</p>
        pub fn set_role_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyRole`](crate::model::PolicyRole)
        pub fn build(self) -> crate::model::PolicyRole {
            crate::model::PolicyRole {
                role_name: self.role_name,
                role_id: self.role_id,
            }
        }
    }
}
impl PolicyRole {
    /// Creates a new builder-style object to manufacture [`PolicyRole`](crate::model::PolicyRole)
    pub fn builder() -> crate::model::policy_role::Builder {
        crate::model::policy_role::Builder::default()
    }
}

/// <p>Contains information about a user that a managed policy is attached to.</p>
/// <p>This data type is used as a response element in the <a>ListEntitiesForPolicy</a> operation. </p>
/// <p>For more information about managed policies, refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
/// policies</a> in the <i>IAM User Guide</i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyUser {
    /// <p>The name (friendly name, not ARN) identifying the user.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The stable and unique string identifying the user. For more information about IDs, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM
    /// identifiers</a> in the <i>IAM User Guide</i>.</p>
    pub user_id: std::option::Option<std::string::String>,
}
impl PolicyUser {
    /// <p>The name (friendly name, not ARN) identifying the user.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The stable and unique string identifying the user. For more information about IDs, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM
    /// identifiers</a> in the <i>IAM User Guide</i>.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
}
impl std::fmt::Debug for PolicyUser {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyUser");
        formatter.field("user_name", &self.user_name);
        formatter.field("user_id", &self.user_id);
        formatter.finish()
    }
}
/// See [`PolicyUser`](crate::model::PolicyUser)
pub mod policy_user {
    /// A builder for [`PolicyUser`](crate::model::PolicyUser)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name (friendly name, not ARN) identifying the user.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name (friendly name, not ARN) identifying the user.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The stable and unique string identifying the user. For more information about IDs, see
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The stable and unique string identifying the user. For more information about IDs, see
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyUser`](crate::model::PolicyUser)
        pub fn build(self) -> crate::model::PolicyUser {
            crate::model::PolicyUser {
                user_name: self.user_name,
                user_id: self.user_id,
            }
        }
    }
}
impl PolicyUser {
    /// Creates a new builder-style object to manufacture [`PolicyUser`](crate::model::PolicyUser)
    pub fn builder() -> crate::model::policy_user::Builder {
        crate::model::policy_user::Builder::default()
    }
}

/// <p>Contains information about a group that a managed policy is attached to.</p>
/// <p>This data type is used as a response element in the <a>ListEntitiesForPolicy</a> operation. </p>
/// <p>For more information about managed policies, refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
/// policies</a> in the <i>IAM User Guide</i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyGroup {
    /// <p>The name (friendly name, not ARN) identifying the group.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>The stable and unique string identifying the group. For more information about IDs, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM
    /// identifiers</a> in the <i>IAM User Guide</i>.</p>
    pub group_id: std::option::Option<std::string::String>,
}
impl PolicyGroup {
    /// <p>The name (friendly name, not ARN) identifying the group.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p>The stable and unique string identifying the group. For more information about IDs, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM
    /// identifiers</a> in the <i>IAM User Guide</i>.</p>
    pub fn group_id(&self) -> std::option::Option<&str> {
        self.group_id.as_deref()
    }
}
impl std::fmt::Debug for PolicyGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyGroup");
        formatter.field("group_name", &self.group_name);
        formatter.field("group_id", &self.group_id);
        formatter.finish()
    }
}
/// See [`PolicyGroup`](crate::model::PolicyGroup)
pub mod policy_group {
    /// A builder for [`PolicyGroup`](crate::model::PolicyGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name (friendly name, not ARN) identifying the group.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name (friendly name, not ARN) identifying the group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The stable and unique string identifying the group. For more information about IDs, see
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// <p>The stable and unique string identifying the group. For more information about IDs, see
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyGroup`](crate::model::PolicyGroup)
        pub fn build(self) -> crate::model::PolicyGroup {
            crate::model::PolicyGroup {
                group_name: self.group_name,
                group_id: self.group_id,
            }
        }
    }
}
impl PolicyGroup {
    /// Creates a new builder-style object to manufacture [`PolicyGroup`](crate::model::PolicyGroup)
    pub fn builder() -> crate::model::policy_group::Builder {
        crate::model::policy_group::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EntityType {
    #[allow(missing_docs)] // documentation missing in model
    AwsManagedPolicy,
    #[allow(missing_docs)] // documentation missing in model
    Group,
    #[allow(missing_docs)] // documentation missing in model
    LocalManagedPolicy,
    #[allow(missing_docs)] // documentation missing in model
    Role,
    #[allow(missing_docs)] // documentation missing in model
    User,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EntityType {
    fn from(s: &str) -> Self {
        match s {
            "AWSManagedPolicy" => EntityType::AwsManagedPolicy,
            "Group" => EntityType::Group,
            "LocalManagedPolicy" => EntityType::LocalManagedPolicy,
            "Role" => EntityType::Role,
            "User" => EntityType::User,
            other => EntityType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EntityType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EntityType::from(s))
    }
}
impl EntityType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EntityType::AwsManagedPolicy => "AWSManagedPolicy",
            EntityType::Group => "Group",
            EntityType::LocalManagedPolicy => "LocalManagedPolicy",
            EntityType::Role => "Role",
            EntityType::User => "User",
            EntityType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AWSManagedPolicy",
            "Group",
            "LocalManagedPolicy",
            "Role",
            "User",
        ]
    }
}
impl AsRef<str> for EntityType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about an attached policy.</p>
/// <p>An attached policy is a managed policy that has been attached to a user, group, or role.
/// This data type is used as a response element in the <a>ListAttachedGroupPolicies</a>, <a>ListAttachedRolePolicies</a>, <a>ListAttachedUserPolicies</a>, and <a>GetAccountAuthorizationDetails</a> operations. </p>
/// <p>For more information about managed policies, refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
/// policies</a> in the <i>IAM User Guide</i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachedPolicy {
    /// <p>The friendly name of the attached policy.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
    /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
    /// the <i>Amazon Web Services General Reference</i>. </p>
    pub policy_arn: std::option::Option<std::string::String>,
}
impl AttachedPolicy {
    /// <p>The friendly name of the attached policy.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
    /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
    /// the <i>Amazon Web Services General Reference</i>. </p>
    pub fn policy_arn(&self) -> std::option::Option<&str> {
        self.policy_arn.as_deref()
    }
}
impl std::fmt::Debug for AttachedPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachedPolicy");
        formatter.field("policy_name", &self.policy_name);
        formatter.field("policy_arn", &self.policy_arn);
        formatter.finish()
    }
}
/// See [`AttachedPolicy`](crate::model::AttachedPolicy)
pub mod attached_policy {
    /// A builder for [`AttachedPolicy`](crate::model::AttachedPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The friendly name of the attached policy.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The friendly name of the attached policy.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
        /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
        /// the <i>Amazon Web Services General Reference</i>. </p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
        /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
        /// the <i>Amazon Web Services General Reference</i>. </p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachedPolicy`](crate::model::AttachedPolicy)
        pub fn build(self) -> crate::model::AttachedPolicy {
            crate::model::AttachedPolicy {
                policy_name: self.policy_name,
                policy_arn: self.policy_arn,
            }
        }
    }
}
impl AttachedPolicy {
    /// Creates a new builder-style object to manufacture [`AttachedPolicy`](crate::model::AttachedPolicy)
    pub fn builder() -> crate::model::attached_policy::Builder {
        crate::model::attached_policy::Builder::default()
    }
}

/// <p>Contains information about an Amazon Web Services access key, without its secret key.</p>
/// <p>This data type is used as a response element in the <a>ListAccessKeys</a>
/// operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessKeyMetadata {
    /// <p>The name of the IAM user that the key is associated with.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The ID for this access key.</p>
    pub access_key_id: std::option::Option<std::string::String>,
    /// <p>The status of the access key. <code>Active</code> means that the key is valid for API
    /// calls; <code>Inactive</code> means it is not.</p>
    pub status: std::option::Option<crate::model::StatusType>,
    /// <p>The date when the access key was created.</p>
    pub create_date: std::option::Option<aws_smithy_types::Instant>,
}
impl AccessKeyMetadata {
    /// <p>The name of the IAM user that the key is associated with.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The ID for this access key.</p>
    pub fn access_key_id(&self) -> std::option::Option<&str> {
        self.access_key_id.as_deref()
    }
    /// <p>The status of the access key. <code>Active</code> means that the key is valid for API
    /// calls; <code>Inactive</code> means it is not.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::StatusType> {
        self.status.as_ref()
    }
    /// <p>The date when the access key was created.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_date.as_ref()
    }
}
impl std::fmt::Debug for AccessKeyMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessKeyMetadata");
        formatter.field("user_name", &self.user_name);
        formatter.field("access_key_id", &self.access_key_id);
        formatter.field("status", &self.status);
        formatter.field("create_date", &self.create_date);
        formatter.finish()
    }
}
/// See [`AccessKeyMetadata`](crate::model::AccessKeyMetadata)
pub mod access_key_metadata {
    /// A builder for [`AccessKeyMetadata`](crate::model::AccessKeyMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) access_key_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::StatusType>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the IAM user that the key is associated with.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM user that the key is associated with.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The ID for this access key.</p>
        pub fn access_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_key_id = Some(input.into());
            self
        }
        /// <p>The ID for this access key.</p>
        pub fn set_access_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_key_id = input;
            self
        }
        /// <p>The status of the access key. <code>Active</code> means that the key is valid for API
        /// calls; <code>Inactive</code> means it is not.</p>
        pub fn status(mut self, input: crate::model::StatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the access key. <code>Active</code> means that the key is valid for API
        /// calls; <code>Inactive</code> means it is not.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::StatusType>) -> Self {
            self.status = input;
            self
        }
        /// <p>The date when the access key was created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date when the access key was created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessKeyMetadata`](crate::model::AccessKeyMetadata)
        pub fn build(self) -> crate::model::AccessKeyMetadata {
            crate::model::AccessKeyMetadata {
                user_name: self.user_name,
                access_key_id: self.access_key_id,
                status: self.status,
                create_date: self.create_date,
            }
        }
    }
}
impl AccessKeyMetadata {
    /// Creates a new builder-style object to manufacture [`AccessKeyMetadata`](crate::model::AccessKeyMetadata)
    pub fn builder() -> crate::model::access_key_metadata::Builder {
        crate::model::access_key_metadata::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EncodingType {
    #[allow(missing_docs)] // documentation missing in model
    Pem,
    #[allow(missing_docs)] // documentation missing in model
    Ssh,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EncodingType {
    fn from(s: &str) -> Self {
        match s {
            "PEM" => EncodingType::Pem,
            "SSH" => EncodingType::Ssh,
            other => EncodingType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EncodingType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EncodingType::from(s))
    }
}
impl EncodingType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EncodingType::Pem => "PEM",
            EncodingType::Ssh => "SSH",
            EncodingType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PEM", "SSH"]
    }
}
impl AsRef<str> for EncodingType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The reason that the service-linked role deletion failed.</p>
/// <p>This data type is used as a response element in the <a>GetServiceLinkedRoleDeletionStatus</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletionTaskFailureReasonType {
    /// <p>A short description of the reason that the service-linked role deletion failed.</p>
    pub reason: std::option::Option<std::string::String>,
    /// <p>A list of objects that contains details about the service-linked role deletion failure,
    /// if that information is returned by the service. If the service-linked role has active
    /// sessions or if any resources that were used by the role have not been deleted from the
    /// linked service, the role can't be deleted. This parameter includes a list of the resources
    /// that are associated with the role and the Region in which the resources are being
    /// used.</p>
    pub role_usage_list: std::option::Option<std::vec::Vec<crate::model::RoleUsageType>>,
}
impl DeletionTaskFailureReasonType {
    /// <p>A short description of the reason that the service-linked role deletion failed.</p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
    /// <p>A list of objects that contains details about the service-linked role deletion failure,
    /// if that information is returned by the service. If the service-linked role has active
    /// sessions or if any resources that were used by the role have not been deleted from the
    /// linked service, the role can't be deleted. This parameter includes a list of the resources
    /// that are associated with the role and the Region in which the resources are being
    /// used.</p>
    pub fn role_usage_list(&self) -> std::option::Option<&[crate::model::RoleUsageType]> {
        self.role_usage_list.as_deref()
    }
}
impl std::fmt::Debug for DeletionTaskFailureReasonType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletionTaskFailureReasonType");
        formatter.field("reason", &self.reason);
        formatter.field("role_usage_list", &self.role_usage_list);
        formatter.finish()
    }
}
/// See [`DeletionTaskFailureReasonType`](crate::model::DeletionTaskFailureReasonType)
pub mod deletion_task_failure_reason_type {
    /// A builder for [`DeletionTaskFailureReasonType`](crate::model::DeletionTaskFailureReasonType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reason: std::option::Option<std::string::String>,
        pub(crate) role_usage_list: std::option::Option<std::vec::Vec<crate::model::RoleUsageType>>,
    }
    impl Builder {
        /// <p>A short description of the reason that the service-linked role deletion failed.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>A short description of the reason that the service-linked role deletion failed.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Appends an item to `role_usage_list`.
        ///
        /// To override the contents of this collection use [`set_role_usage_list`](Self::set_role_usage_list).
        ///
        /// <p>A list of objects that contains details about the service-linked role deletion failure,
        /// if that information is returned by the service. If the service-linked role has active
        /// sessions or if any resources that were used by the role have not been deleted from the
        /// linked service, the role can't be deleted. This parameter includes a list of the resources
        /// that are associated with the role and the Region in which the resources are being
        /// used.</p>
        pub fn role_usage_list(mut self, input: impl Into<crate::model::RoleUsageType>) -> Self {
            let mut v = self.role_usage_list.unwrap_or_default();
            v.push(input.into());
            self.role_usage_list = Some(v);
            self
        }
        /// <p>A list of objects that contains details about the service-linked role deletion failure,
        /// if that information is returned by the service. If the service-linked role has active
        /// sessions or if any resources that were used by the role have not been deleted from the
        /// linked service, the role can't be deleted. This parameter includes a list of the resources
        /// that are associated with the role and the Region in which the resources are being
        /// used.</p>
        pub fn set_role_usage_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RoleUsageType>>,
        ) -> Self {
            self.role_usage_list = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletionTaskFailureReasonType`](crate::model::DeletionTaskFailureReasonType)
        pub fn build(self) -> crate::model::DeletionTaskFailureReasonType {
            crate::model::DeletionTaskFailureReasonType {
                reason: self.reason,
                role_usage_list: self.role_usage_list,
            }
        }
    }
}
impl DeletionTaskFailureReasonType {
    /// Creates a new builder-style object to manufacture [`DeletionTaskFailureReasonType`](crate::model::DeletionTaskFailureReasonType)
    pub fn builder() -> crate::model::deletion_task_failure_reason_type::Builder {
        crate::model::deletion_task_failure_reason_type::Builder::default()
    }
}

/// <p>An object that contains details about how a service-linked role is used, if that
/// information is returned by the service.</p>
/// <p>This data type is used as a response element in the <a>GetServiceLinkedRoleDeletionStatus</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RoleUsageType {
    /// <p>The name of the Region where the service-linked role is being used.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The name of the resource that is using the service-linked role.</p>
    pub resources: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl RoleUsageType {
    /// <p>The name of the Region where the service-linked role is being used.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>The name of the resource that is using the service-linked role.</p>
    pub fn resources(&self) -> std::option::Option<&[std::string::String]> {
        self.resources.as_deref()
    }
}
impl std::fmt::Debug for RoleUsageType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RoleUsageType");
        formatter.field("region", &self.region);
        formatter.field("resources", &self.resources);
        formatter.finish()
    }
}
/// See [`RoleUsageType`](crate::model::RoleUsageType)
pub mod role_usage_type {
    /// A builder for [`RoleUsageType`](crate::model::RoleUsageType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) resources: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the Region where the service-linked role is being used.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The name of the Region where the service-linked role is being used.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>The name of the resource that is using the service-linked role.</p>
        pub fn resources(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input.into());
            self.resources = Some(v);
            self
        }
        /// <p>The name of the resource that is using the service-linked role.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// Consumes the builder and constructs a [`RoleUsageType`](crate::model::RoleUsageType)
        pub fn build(self) -> crate::model::RoleUsageType {
            crate::model::RoleUsageType {
                region: self.region,
                resources: self.resources,
            }
        }
    }
}
impl RoleUsageType {
    /// Creates a new builder-style object to manufacture [`RoleUsageType`](crate::model::RoleUsageType)
    pub fn builder() -> crate::model::role_usage_type::Builder {
        crate::model::role_usage_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeletionTaskStatusType {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    NotStarted,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeletionTaskStatusType {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => DeletionTaskStatusType::Failed,
            "IN_PROGRESS" => DeletionTaskStatusType::InProgress,
            "NOT_STARTED" => DeletionTaskStatusType::NotStarted,
            "SUCCEEDED" => DeletionTaskStatusType::Succeeded,
            other => DeletionTaskStatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeletionTaskStatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeletionTaskStatusType::from(s))
    }
}
impl DeletionTaskStatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeletionTaskStatusType::Failed => "FAILED",
            DeletionTaskStatusType::InProgress => "IN_PROGRESS",
            DeletionTaskStatusType::NotStarted => "NOT_STARTED",
            DeletionTaskStatusType::Succeeded => "SUCCEEDED",
            DeletionTaskStatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "IN_PROGRESS", "NOT_STARTED", "SUCCEEDED"]
    }
}
impl AsRef<str> for DeletionTaskStatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the reason that the operation failed.</p>
/// <p>This data type is used as a response element in the <a>GetOrganizationsAccessReport</a>, <a>GetServiceLastAccessedDetails</a>, and <a>GetServiceLastAccessedDetailsWithEntities</a> operations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ErrorDetails {
    /// <p>Detailed information about the reason that the operation failed.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The error code associated with the operation failure.</p>
    pub code: std::option::Option<std::string::String>,
}
impl ErrorDetails {
    /// <p>Detailed information about the reason that the operation failed.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The error code associated with the operation failure.</p>
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
}
impl std::fmt::Debug for ErrorDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ErrorDetails");
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
/// See [`ErrorDetails`](crate::model::ErrorDetails)
pub mod error_details {
    /// A builder for [`ErrorDetails`](crate::model::ErrorDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Detailed information about the reason that the operation failed.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Detailed information about the reason that the operation failed.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The error code associated with the operation failure.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The error code associated with the operation failure.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`ErrorDetails`](crate::model::ErrorDetails)
        pub fn build(self) -> crate::model::ErrorDetails {
            crate::model::ErrorDetails {
                message: self.message,
                code: self.code,
            }
        }
    }
}
impl ErrorDetails {
    /// Creates a new builder-style object to manufacture [`ErrorDetails`](crate::model::ErrorDetails)
    pub fn builder() -> crate::model::error_details::Builder {
        crate::model::error_details::Builder::default()
    }
}

/// <p>An object that contains details about when the IAM entities (users or roles) were last
/// used in an attempt to access the specified Amazon Web Services service.</p>
/// <p>This data type is a response element in the <a>GetServiceLastAccessedDetailsWithEntities</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntityDetails {
    /// <p>The <code>EntityInfo</code> object that contains details about the entity (user or
    /// role).</p>
    pub entity_info: std::option::Option<crate::model::EntityInfo>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the authenticated entity last attempted to access Amazon Web Services. Amazon Web Services does
    /// not report unauthenticated requests.</p>
    /// <p>This field is null if no IAM entities attempted to access the service within the
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
    pub last_authenticated: std::option::Option<aws_smithy_types::Instant>,
}
impl EntityDetails {
    /// <p>The <code>EntityInfo</code> object that contains details about the entity (user or
    /// role).</p>
    pub fn entity_info(&self) -> std::option::Option<&crate::model::EntityInfo> {
        self.entity_info.as_ref()
    }
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the authenticated entity last attempted to access Amazon Web Services. Amazon Web Services does
    /// not report unauthenticated requests.</p>
    /// <p>This field is null if no IAM entities attempted to access the service within the
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
    pub fn last_authenticated(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_authenticated.as_ref()
    }
}
impl std::fmt::Debug for EntityDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntityDetails");
        formatter.field("entity_info", &self.entity_info);
        formatter.field("last_authenticated", &self.last_authenticated);
        formatter.finish()
    }
}
/// See [`EntityDetails`](crate::model::EntityDetails)
pub mod entity_details {
    /// A builder for [`EntityDetails`](crate::model::EntityDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entity_info: std::option::Option<crate::model::EntityInfo>,
        pub(crate) last_authenticated: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The <code>EntityInfo</code> object that contains details about the entity (user or
        /// role).</p>
        pub fn entity_info(mut self, input: crate::model::EntityInfo) -> Self {
            self.entity_info = Some(input);
            self
        }
        /// <p>The <code>EntityInfo</code> object that contains details about the entity (user or
        /// role).</p>
        pub fn set_entity_info(
            mut self,
            input: std::option::Option<crate::model::EntityInfo>,
        ) -> Self {
            self.entity_info = input;
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the authenticated entity last attempted to access Amazon Web Services. Amazon Web Services does
        /// not report unauthenticated requests.</p>
        /// <p>This field is null if no IAM entities attempted to access the service within the
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
        pub fn last_authenticated(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_authenticated = Some(input);
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the authenticated entity last attempted to access Amazon Web Services. Amazon Web Services does
        /// not report unauthenticated requests.</p>
        /// <p>This field is null if no IAM entities attempted to access the service within the
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
        pub fn set_last_authenticated(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_authenticated = input;
            self
        }
        /// Consumes the builder and constructs a [`EntityDetails`](crate::model::EntityDetails)
        pub fn build(self) -> crate::model::EntityDetails {
            crate::model::EntityDetails {
                entity_info: self.entity_info,
                last_authenticated: self.last_authenticated,
            }
        }
    }
}
impl EntityDetails {
    /// Creates a new builder-style object to manufacture [`EntityDetails`](crate::model::EntityDetails)
    pub fn builder() -> crate::model::entity_details::Builder {
        crate::model::entity_details::Builder::default()
    }
}

/// <p>Contains details about the specified entity (user or role).</p>
/// <p>This data type is an element of the <a>EntityDetails</a> object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntityInfo {
    /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
    /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
    /// the <i>Amazon Web Services General Reference</i>. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the entity (user or role).</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of entity (user or role).</p>
    pub r#type: std::option::Option<crate::model::PolicyOwnerEntityType>,
    /// <p>The identifier of the entity (user or role).</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The path to the entity (user or role). For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
    /// identifiers</a> in the <i>IAM User Guide</i>. </p>
    pub path: std::option::Option<std::string::String>,
}
impl EntityInfo {
    /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
    /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
    /// the <i>Amazon Web Services General Reference</i>. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the entity (user or role).</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of entity (user or role).</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::PolicyOwnerEntityType> {
        self.r#type.as_ref()
    }
    /// <p>The identifier of the entity (user or role).</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The path to the entity (user or role). For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
    /// identifiers</a> in the <i>IAM User Guide</i>. </p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
}
impl std::fmt::Debug for EntityInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntityInfo");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("id", &self.id);
        formatter.field("path", &self.path);
        formatter.finish()
    }
}
/// See [`EntityInfo`](crate::model::EntityInfo)
pub mod entity_info {
    /// A builder for [`EntityInfo`](crate::model::EntityInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::PolicyOwnerEntityType>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
        /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
        /// the <i>Amazon Web Services General Reference</i>. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
        /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
        /// the <i>Amazon Web Services General Reference</i>. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the entity (user or role).</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the entity (user or role).</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of entity (user or role).</p>
        pub fn r#type(mut self, input: crate::model::PolicyOwnerEntityType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of entity (user or role).</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::PolicyOwnerEntityType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The identifier of the entity (user or role).</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the entity (user or role).</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The path to the entity (user or role). For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>. </p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The path to the entity (user or role). For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>. </p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// Consumes the builder and constructs a [`EntityInfo`](crate::model::EntityInfo)
        pub fn build(self) -> crate::model::EntityInfo {
            crate::model::EntityInfo {
                arn: self.arn,
                name: self.name,
                r#type: self.r#type,
                id: self.id,
                path: self.path,
            }
        }
    }
}
impl EntityInfo {
    /// Creates a new builder-style object to manufacture [`EntityInfo`](crate::model::EntityInfo)
    pub fn builder() -> crate::model::entity_info::Builder {
        crate::model::entity_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobStatusType {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobStatusType {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => JobStatusType::Completed,
            "FAILED" => JobStatusType::Failed,
            "IN_PROGRESS" => JobStatusType::InProgress,
            other => JobStatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobStatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobStatusType::from(s))
    }
}
impl JobStatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobStatusType::Completed => "COMPLETED",
            JobStatusType::Failed => "FAILED",
            JobStatusType::InProgress => "IN_PROGRESS",
            JobStatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETED", "FAILED", "IN_PROGRESS"]
    }
}
impl AsRef<str> for JobStatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains details about the most recent attempt to access the service.</p>
/// <p>This data type is used as a response element in the <a>GetServiceLastAccessedDetails</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceLastAccessed {
    /// <p>The name of the service in which access was attempted.</p>
    pub service_name: std::option::Option<std::string::String>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when an authenticated entity most recently attempted to access the
    /// service. Amazon Web Services does not report unauthenticated requests.</p>
    /// <p>This field is null if no IAM entities attempted to access the service within the
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
    pub last_authenticated: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The namespace of the service in which access was attempted.</p>
    /// <p>To learn the service namespace of a service, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html">Actions, resources, and condition keys for Amazon Web Services services</a> in the
    /// <i>Service Authorization Reference</i>. Choose the name of the service to
    /// view details for that service. In the first paragraph, find the service prefix. For
    /// example, <code>(service prefix: a4b)</code>. For more information about service namespaces,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces">Amazon Web Services
    /// Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub service_namespace: std::option::Option<std::string::String>,
    /// <p>The ARN of the authenticated entity (user or role) that last attempted to access the
    /// service. Amazon Web Services does not report unauthenticated requests.</p>
    /// <p>This field is null if no IAM entities attempted to access the service within the
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
    pub last_authenticated_entity: std::option::Option<std::string::String>,
    /// <p>The Region from which the authenticated entity (user or role) last attempted to access
    /// the service. Amazon Web Services does not report unauthenticated requests.</p>
    /// <p>This field is null if no IAM entities attempted to access the service within the
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
    pub last_authenticated_region: std::option::Option<std::string::String>,
    /// <p>The total number of authenticated principals (root user, IAM users, or IAM roles)
    /// that have attempted to access the service.</p>
    /// <p>This field is null if no principals attempted to access the service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
    pub total_authenticated_entities: std::option::Option<i32>,
    /// <p>An object that contains details about the most recent attempt to access a tracked action
    /// within the service.</p>
    /// <p>This field is null if there no tracked actions or if the principal did not use the
    /// tracked actions within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>. This field is also null if the report was generated at the
    /// service level and not the action level. For more information, see the
    /// <code>Granularity</code> field in <a>GenerateServiceLastAccessedDetails</a>.</p>
    pub tracked_actions_last_accessed:
        std::option::Option<std::vec::Vec<crate::model::TrackedActionLastAccessed>>,
}
impl ServiceLastAccessed {
    /// <p>The name of the service in which access was attempted.</p>
    pub fn service_name(&self) -> std::option::Option<&str> {
        self.service_name.as_deref()
    }
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when an authenticated entity most recently attempted to access the
    /// service. Amazon Web Services does not report unauthenticated requests.</p>
    /// <p>This field is null if no IAM entities attempted to access the service within the
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
    pub fn last_authenticated(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_authenticated.as_ref()
    }
    /// <p>The namespace of the service in which access was attempted.</p>
    /// <p>To learn the service namespace of a service, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html">Actions, resources, and condition keys for Amazon Web Services services</a> in the
    /// <i>Service Authorization Reference</i>. Choose the name of the service to
    /// view details for that service. In the first paragraph, find the service prefix. For
    /// example, <code>(service prefix: a4b)</code>. For more information about service namespaces,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces">Amazon Web Services
    /// Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn service_namespace(&self) -> std::option::Option<&str> {
        self.service_namespace.as_deref()
    }
    /// <p>The ARN of the authenticated entity (user or role) that last attempted to access the
    /// service. Amazon Web Services does not report unauthenticated requests.</p>
    /// <p>This field is null if no IAM entities attempted to access the service within the
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
    pub fn last_authenticated_entity(&self) -> std::option::Option<&str> {
        self.last_authenticated_entity.as_deref()
    }
    /// <p>The Region from which the authenticated entity (user or role) last attempted to access
    /// the service. Amazon Web Services does not report unauthenticated requests.</p>
    /// <p>This field is null if no IAM entities attempted to access the service within the
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
    pub fn last_authenticated_region(&self) -> std::option::Option<&str> {
        self.last_authenticated_region.as_deref()
    }
    /// <p>The total number of authenticated principals (root user, IAM users, or IAM roles)
    /// that have attempted to access the service.</p>
    /// <p>This field is null if no principals attempted to access the service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
    pub fn total_authenticated_entities(&self) -> std::option::Option<i32> {
        self.total_authenticated_entities
    }
    /// <p>An object that contains details about the most recent attempt to access a tracked action
    /// within the service.</p>
    /// <p>This field is null if there no tracked actions or if the principal did not use the
    /// tracked actions within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>. This field is also null if the report was generated at the
    /// service level and not the action level. For more information, see the
    /// <code>Granularity</code> field in <a>GenerateServiceLastAccessedDetails</a>.</p>
    pub fn tracked_actions_last_accessed(
        &self,
    ) -> std::option::Option<&[crate::model::TrackedActionLastAccessed]> {
        self.tracked_actions_last_accessed.as_deref()
    }
}
impl std::fmt::Debug for ServiceLastAccessed {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceLastAccessed");
        formatter.field("service_name", &self.service_name);
        formatter.field("last_authenticated", &self.last_authenticated);
        formatter.field("service_namespace", &self.service_namespace);
        formatter.field("last_authenticated_entity", &self.last_authenticated_entity);
        formatter.field("last_authenticated_region", &self.last_authenticated_region);
        formatter.field(
            "total_authenticated_entities",
            &self.total_authenticated_entities,
        );
        formatter.field(
            "tracked_actions_last_accessed",
            &self.tracked_actions_last_accessed,
        );
        formatter.finish()
    }
}
/// See [`ServiceLastAccessed`](crate::model::ServiceLastAccessed)
pub mod service_last_accessed {
    /// A builder for [`ServiceLastAccessed`](crate::model::ServiceLastAccessed)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) last_authenticated: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) service_namespace: std::option::Option<std::string::String>,
        pub(crate) last_authenticated_entity: std::option::Option<std::string::String>,
        pub(crate) last_authenticated_region: std::option::Option<std::string::String>,
        pub(crate) total_authenticated_entities: std::option::Option<i32>,
        pub(crate) tracked_actions_last_accessed:
            std::option::Option<std::vec::Vec<crate::model::TrackedActionLastAccessed>>,
    }
    impl Builder {
        /// <p>The name of the service in which access was attempted.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of the service in which access was attempted.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when an authenticated entity most recently attempted to access the
        /// service. Amazon Web Services does not report unauthenticated requests.</p>
        /// <p>This field is null if no IAM entities attempted to access the service within the
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
        pub fn last_authenticated(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_authenticated = Some(input);
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when an authenticated entity most recently attempted to access the
        /// service. Amazon Web Services does not report unauthenticated requests.</p>
        /// <p>This field is null if no IAM entities attempted to access the service within the
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
        pub fn set_last_authenticated(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_authenticated = input;
            self
        }
        /// <p>The namespace of the service in which access was attempted.</p>
        /// <p>To learn the service namespace of a service, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html">Actions, resources, and condition keys for Amazon Web Services services</a> in the
        /// <i>Service Authorization Reference</i>. Choose the name of the service to
        /// view details for that service. In the first paragraph, find the service prefix. For
        /// example, <code>(service prefix: a4b)</code>. For more information about service namespaces,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces">Amazon Web Services
        /// Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn service_namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_namespace = Some(input.into());
            self
        }
        /// <p>The namespace of the service in which access was attempted.</p>
        /// <p>To learn the service namespace of a service, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html">Actions, resources, and condition keys for Amazon Web Services services</a> in the
        /// <i>Service Authorization Reference</i>. Choose the name of the service to
        /// view details for that service. In the first paragraph, find the service prefix. For
        /// example, <code>(service prefix: a4b)</code>. For more information about service namespaces,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces">Amazon Web Services
        /// Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_service_namespace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_namespace = input;
            self
        }
        /// <p>The ARN of the authenticated entity (user or role) that last attempted to access the
        /// service. Amazon Web Services does not report unauthenticated requests.</p>
        /// <p>This field is null if no IAM entities attempted to access the service within the
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
        pub fn last_authenticated_entity(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_authenticated_entity = Some(input.into());
            self
        }
        /// <p>The ARN of the authenticated entity (user or role) that last attempted to access the
        /// service. Amazon Web Services does not report unauthenticated requests.</p>
        /// <p>This field is null if no IAM entities attempted to access the service within the
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
        pub fn set_last_authenticated_entity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_authenticated_entity = input;
            self
        }
        /// <p>The Region from which the authenticated entity (user or role) last attempted to access
        /// the service. Amazon Web Services does not report unauthenticated requests.</p>
        /// <p>This field is null if no IAM entities attempted to access the service within the
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
        pub fn last_authenticated_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_authenticated_region = Some(input.into());
            self
        }
        /// <p>The Region from which the authenticated entity (user or role) last attempted to access
        /// the service. Amazon Web Services does not report unauthenticated requests.</p>
        /// <p>This field is null if no IAM entities attempted to access the service within the
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
        pub fn set_last_authenticated_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_authenticated_region = input;
            self
        }
        /// <p>The total number of authenticated principals (root user, IAM users, or IAM roles)
        /// that have attempted to access the service.</p>
        /// <p>This field is null if no principals attempted to access the service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
        pub fn total_authenticated_entities(mut self, input: i32) -> Self {
            self.total_authenticated_entities = Some(input);
            self
        }
        /// <p>The total number of authenticated principals (root user, IAM users, or IAM roles)
        /// that have attempted to access the service.</p>
        /// <p>This field is null if no principals attempted to access the service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
        pub fn set_total_authenticated_entities(mut self, input: std::option::Option<i32>) -> Self {
            self.total_authenticated_entities = input;
            self
        }
        /// Appends an item to `tracked_actions_last_accessed`.
        ///
        /// To override the contents of this collection use [`set_tracked_actions_last_accessed`](Self::set_tracked_actions_last_accessed).
        ///
        /// <p>An object that contains details about the most recent attempt to access a tracked action
        /// within the service.</p>
        /// <p>This field is null if there no tracked actions or if the principal did not use the
        /// tracked actions within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>. This field is also null if the report was generated at the
        /// service level and not the action level. For more information, see the
        /// <code>Granularity</code> field in <a>GenerateServiceLastAccessedDetails</a>.</p>
        pub fn tracked_actions_last_accessed(
            mut self,
            input: impl Into<crate::model::TrackedActionLastAccessed>,
        ) -> Self {
            let mut v = self.tracked_actions_last_accessed.unwrap_or_default();
            v.push(input.into());
            self.tracked_actions_last_accessed = Some(v);
            self
        }
        /// <p>An object that contains details about the most recent attempt to access a tracked action
        /// within the service.</p>
        /// <p>This field is null if there no tracked actions or if the principal did not use the
        /// tracked actions within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>. This field is also null if the report was generated at the
        /// service level and not the action level. For more information, see the
        /// <code>Granularity</code> field in <a>GenerateServiceLastAccessedDetails</a>.</p>
        pub fn set_tracked_actions_last_accessed(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TrackedActionLastAccessed>>,
        ) -> Self {
            self.tracked_actions_last_accessed = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceLastAccessed`](crate::model::ServiceLastAccessed)
        pub fn build(self) -> crate::model::ServiceLastAccessed {
            crate::model::ServiceLastAccessed {
                service_name: self.service_name,
                last_authenticated: self.last_authenticated,
                service_namespace: self.service_namespace,
                last_authenticated_entity: self.last_authenticated_entity,
                last_authenticated_region: self.last_authenticated_region,
                total_authenticated_entities: self.total_authenticated_entities,
                tracked_actions_last_accessed: self.tracked_actions_last_accessed,
            }
        }
    }
}
impl ServiceLastAccessed {
    /// Creates a new builder-style object to manufacture [`ServiceLastAccessed`](crate::model::ServiceLastAccessed)
    pub fn builder() -> crate::model::service_last_accessed::Builder {
        crate::model::service_last_accessed::Builder::default()
    }
}

/// <p>Contains details about the most recent attempt to access an action within the service.</p>
/// <p>This data type is used as a response element in the <a>GetServiceLastAccessedDetails</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TrackedActionLastAccessed {
    /// <p>The name of the tracked action to which access was attempted. Tracked actions are
    /// actions that report activity to IAM.</p>
    pub action_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
    /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
    /// the <i>Amazon Web Services General Reference</i>. </p>
    pub last_accessed_entity: std::option::Option<std::string::String>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when an authenticated entity most recently attempted to access the
    /// tracked service. Amazon Web Services does not report unauthenticated requests.</p>
    /// <p>This field is null if no IAM entities attempted to access the service within the
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
    pub last_accessed_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Region from which the authenticated entity (user or role) last attempted to access
    /// the tracked action. Amazon Web Services does not report unauthenticated requests.</p>
    /// <p>This field is null if no IAM entities attempted to access the service within the
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
    pub last_accessed_region: std::option::Option<std::string::String>,
}
impl TrackedActionLastAccessed {
    /// <p>The name of the tracked action to which access was attempted. Tracked actions are
    /// actions that report activity to IAM.</p>
    pub fn action_name(&self) -> std::option::Option<&str> {
        self.action_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
    /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
    /// the <i>Amazon Web Services General Reference</i>. </p>
    pub fn last_accessed_entity(&self) -> std::option::Option<&str> {
        self.last_accessed_entity.as_deref()
    }
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when an authenticated entity most recently attempted to access the
    /// tracked service. Amazon Web Services does not report unauthenticated requests.</p>
    /// <p>This field is null if no IAM entities attempted to access the service within the
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
    pub fn last_accessed_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_accessed_time.as_ref()
    }
    /// <p>The Region from which the authenticated entity (user or role) last attempted to access
    /// the tracked action. Amazon Web Services does not report unauthenticated requests.</p>
    /// <p>This field is null if no IAM entities attempted to access the service within the
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
    pub fn last_accessed_region(&self) -> std::option::Option<&str> {
        self.last_accessed_region.as_deref()
    }
}
impl std::fmt::Debug for TrackedActionLastAccessed {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TrackedActionLastAccessed");
        formatter.field("action_name", &self.action_name);
        formatter.field("last_accessed_entity", &self.last_accessed_entity);
        formatter.field("last_accessed_time", &self.last_accessed_time);
        formatter.field("last_accessed_region", &self.last_accessed_region);
        formatter.finish()
    }
}
/// See [`TrackedActionLastAccessed`](crate::model::TrackedActionLastAccessed)
pub mod tracked_action_last_accessed {
    /// A builder for [`TrackedActionLastAccessed`](crate::model::TrackedActionLastAccessed)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_name: std::option::Option<std::string::String>,
        pub(crate) last_accessed_entity: std::option::Option<std::string::String>,
        pub(crate) last_accessed_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_accessed_region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the tracked action to which access was attempted. Tracked actions are
        /// actions that report activity to IAM.</p>
        pub fn action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_name = Some(input.into());
            self
        }
        /// <p>The name of the tracked action to which access was attempted. Tracked actions are
        /// actions that report activity to IAM.</p>
        pub fn set_action_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
        /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
        /// the <i>Amazon Web Services General Reference</i>. </p>
        pub fn last_accessed_entity(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_accessed_entity = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
        /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
        /// the <i>Amazon Web Services General Reference</i>. </p>
        pub fn set_last_accessed_entity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_accessed_entity = input;
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when an authenticated entity most recently attempted to access the
        /// tracked service. Amazon Web Services does not report unauthenticated requests.</p>
        /// <p>This field is null if no IAM entities attempted to access the service within the
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
        pub fn last_accessed_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_accessed_time = Some(input);
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when an authenticated entity most recently attempted to access the
        /// tracked service. Amazon Web Services does not report unauthenticated requests.</p>
        /// <p>This field is null if no IAM entities attempted to access the service within the
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
        pub fn set_last_accessed_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_accessed_time = input;
            self
        }
        /// <p>The Region from which the authenticated entity (user or role) last attempted to access
        /// the tracked action. Amazon Web Services does not report unauthenticated requests.</p>
        /// <p>This field is null if no IAM entities attempted to access the service within the
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
        pub fn last_accessed_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_accessed_region = Some(input.into());
            self
        }
        /// <p>The Region from which the authenticated entity (user or role) last attempted to access
        /// the tracked action. Amazon Web Services does not report unauthenticated requests.</p>
        /// <p>This field is null if no IAM entities attempted to access the service within the
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
        pub fn set_last_accessed_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_accessed_region = input;
            self
        }
        /// Consumes the builder and constructs a [`TrackedActionLastAccessed`](crate::model::TrackedActionLastAccessed)
        pub fn build(self) -> crate::model::TrackedActionLastAccessed {
            crate::model::TrackedActionLastAccessed {
                action_name: self.action_name,
                last_accessed_entity: self.last_accessed_entity,
                last_accessed_time: self.last_accessed_time,
                last_accessed_region: self.last_accessed_region,
            }
        }
    }
}
impl TrackedActionLastAccessed {
    /// Creates a new builder-style object to manufacture [`TrackedActionLastAccessed`](crate::model::TrackedActionLastAccessed)
    pub fn builder() -> crate::model::tracked_action_last_accessed::Builder {
        crate::model::tracked_action_last_accessed::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AccessAdvisorUsageGranularityType {
    #[allow(missing_docs)] // documentation missing in model
    ActionLevel,
    #[allow(missing_docs)] // documentation missing in model
    ServiceLevel,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AccessAdvisorUsageGranularityType {
    fn from(s: &str) -> Self {
        match s {
            "ACTION_LEVEL" => AccessAdvisorUsageGranularityType::ActionLevel,
            "SERVICE_LEVEL" => AccessAdvisorUsageGranularityType::ServiceLevel,
            other => AccessAdvisorUsageGranularityType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AccessAdvisorUsageGranularityType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AccessAdvisorUsageGranularityType::from(s))
    }
}
impl AccessAdvisorUsageGranularityType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AccessAdvisorUsageGranularityType::ActionLevel => "ACTION_LEVEL",
            AccessAdvisorUsageGranularityType::ServiceLevel => "SERVICE_LEVEL",
            AccessAdvisorUsageGranularityType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTION_LEVEL", "SERVICE_LEVEL"]
    }
}
impl AsRef<str> for AccessAdvisorUsageGranularityType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a server certificate.</p>
/// <p> This data type is used as a response element in the <a>GetServerCertificate</a> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServerCertificate {
    /// <p>The meta information of the server certificate, such as its name, path, ID, and
    /// ARN.</p>
    pub server_certificate_metadata: std::option::Option<crate::model::ServerCertificateMetadata>,
    /// <p>The contents of the public key certificate.</p>
    pub certificate_body: std::option::Option<std::string::String>,
    /// <p>The contents of the public key certificate chain.</p>
    pub certificate_chain: std::option::Option<std::string::String>,
    /// <p>A list of tags that are attached to the server certificate. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ServerCertificate {
    /// <p>The meta information of the server certificate, such as its name, path, ID, and
    /// ARN.</p>
    pub fn server_certificate_metadata(
        &self,
    ) -> std::option::Option<&crate::model::ServerCertificateMetadata> {
        self.server_certificate_metadata.as_ref()
    }
    /// <p>The contents of the public key certificate.</p>
    pub fn certificate_body(&self) -> std::option::Option<&str> {
        self.certificate_body.as_deref()
    }
    /// <p>The contents of the public key certificate chain.</p>
    pub fn certificate_chain(&self) -> std::option::Option<&str> {
        self.certificate_chain.as_deref()
    }
    /// <p>A list of tags that are attached to the server certificate. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ServerCertificate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServerCertificate");
        formatter.field(
            "server_certificate_metadata",
            &self.server_certificate_metadata,
        );
        formatter.field("certificate_body", &self.certificate_body);
        formatter.field("certificate_chain", &self.certificate_chain);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ServerCertificate`](crate::model::ServerCertificate)
pub mod server_certificate {
    /// A builder for [`ServerCertificate`](crate::model::ServerCertificate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_certificate_metadata:
            std::option::Option<crate::model::ServerCertificateMetadata>,
        pub(crate) certificate_body: std::option::Option<std::string::String>,
        pub(crate) certificate_chain: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The meta information of the server certificate, such as its name, path, ID, and
        /// ARN.</p>
        pub fn server_certificate_metadata(
            mut self,
            input: crate::model::ServerCertificateMetadata,
        ) -> Self {
            self.server_certificate_metadata = Some(input);
            self
        }
        /// <p>The meta information of the server certificate, such as its name, path, ID, and
        /// ARN.</p>
        pub fn set_server_certificate_metadata(
            mut self,
            input: std::option::Option<crate::model::ServerCertificateMetadata>,
        ) -> Self {
            self.server_certificate_metadata = input;
            self
        }
        /// <p>The contents of the public key certificate.</p>
        pub fn certificate_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_body = Some(input.into());
            self
        }
        /// <p>The contents of the public key certificate.</p>
        pub fn set_certificate_body(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_body = input;
            self
        }
        /// <p>The contents of the public key certificate chain.</p>
        pub fn certificate_chain(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_chain = Some(input.into());
            self
        }
        /// <p>The contents of the public key certificate chain.</p>
        pub fn set_certificate_chain(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_chain = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that are attached to the server certificate. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags that are attached to the server certificate. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ServerCertificate`](crate::model::ServerCertificate)
        pub fn build(self) -> crate::model::ServerCertificate {
            crate::model::ServerCertificate {
                server_certificate_metadata: self.server_certificate_metadata,
                certificate_body: self.certificate_body,
                certificate_chain: self.certificate_chain,
                tags: self.tags,
            }
        }
    }
}
impl ServerCertificate {
    /// Creates a new builder-style object to manufacture [`ServerCertificate`](crate::model::ServerCertificate)
    pub fn builder() -> crate::model::server_certificate::Builder {
        crate::model::server_certificate::Builder::default()
    }
}

/// <p>An object that contains details about when a principal in the reported Organizations entity
/// last attempted to access an Amazon Web Services service. A principal can be an IAM user, an IAM role,
/// or the Amazon Web Services account root user within the reported Organizations entity.</p>
/// <p>This data type is a response element in the <a>GetOrganizationsAccessReport</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDetail {
    /// <p>The name of the service in which access was attempted.</p>
    pub service_name: std::option::Option<std::string::String>,
    /// <p>The namespace of the service in which access was attempted.</p>
    /// <p>To learn the service namespace of a service, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html">Actions, resources, and condition keys for Amazon Web Services services</a> in the
    /// <i>Service Authorization Reference</i>. Choose the name of the service to
    /// view details for that service. In the first paragraph, find the service prefix. For
    /// example, <code>(service prefix: a4b)</code>. For more information about service namespaces,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces">Amazon Web Services
    /// service namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub service_namespace: std::option::Option<std::string::String>,
    /// <p>The Region where the last service access attempt occurred.</p>
    /// <p>This field is null if no principals in the reported Organizations entity attempted to access the
    /// service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The path of the Organizations entity (root, organizational unit, or account) from which an
    /// authenticated principal last attempted to access the service. Amazon Web Services does not report
    /// unauthenticated requests.</p>
    /// <p>This field is null if no principals (IAM users, IAM roles, or root users) in the
    /// reported Organizations entity attempted to access the service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
    pub entity_path: std::option::Option<std::string::String>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when an authenticated principal most recently attempted to access the
    /// service. Amazon Web Services does not report unauthenticated requests.</p>
    /// <p>This field is null if no principals in the reported Organizations entity attempted to access the
    /// service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
    pub last_authenticated_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The number of accounts with authenticated principals (root users, IAM users, and IAM
    /// roles) that attempted to access the service in the reporting period.</p>
    pub total_authenticated_entities: std::option::Option<i32>,
}
impl AccessDetail {
    /// <p>The name of the service in which access was attempted.</p>
    pub fn service_name(&self) -> std::option::Option<&str> {
        self.service_name.as_deref()
    }
    /// <p>The namespace of the service in which access was attempted.</p>
    /// <p>To learn the service namespace of a service, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html">Actions, resources, and condition keys for Amazon Web Services services</a> in the
    /// <i>Service Authorization Reference</i>. Choose the name of the service to
    /// view details for that service. In the first paragraph, find the service prefix. For
    /// example, <code>(service prefix: a4b)</code>. For more information about service namespaces,
    /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces">Amazon Web Services
    /// service namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
    pub fn service_namespace(&self) -> std::option::Option<&str> {
        self.service_namespace.as_deref()
    }
    /// <p>The Region where the last service access attempt occurred.</p>
    /// <p>This field is null if no principals in the reported Organizations entity attempted to access the
    /// service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>The path of the Organizations entity (root, organizational unit, or account) from which an
    /// authenticated principal last attempted to access the service. Amazon Web Services does not report
    /// unauthenticated requests.</p>
    /// <p>This field is null if no principals (IAM users, IAM roles, or root users) in the
    /// reported Organizations entity attempted to access the service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
    pub fn entity_path(&self) -> std::option::Option<&str> {
        self.entity_path.as_deref()
    }
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when an authenticated principal most recently attempted to access the
    /// service. Amazon Web Services does not report unauthenticated requests.</p>
    /// <p>This field is null if no principals in the reported Organizations entity attempted to access the
    /// service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
    pub fn last_authenticated_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_authenticated_time.as_ref()
    }
    /// <p>The number of accounts with authenticated principals (root users, IAM users, and IAM
    /// roles) that attempted to access the service in the reporting period.</p>
    pub fn total_authenticated_entities(&self) -> std::option::Option<i32> {
        self.total_authenticated_entities
    }
}
impl std::fmt::Debug for AccessDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDetail");
        formatter.field("service_name", &self.service_name);
        formatter.field("service_namespace", &self.service_namespace);
        formatter.field("region", &self.region);
        formatter.field("entity_path", &self.entity_path);
        formatter.field("last_authenticated_time", &self.last_authenticated_time);
        formatter.field(
            "total_authenticated_entities",
            &self.total_authenticated_entities,
        );
        formatter.finish()
    }
}
/// See [`AccessDetail`](crate::model::AccessDetail)
pub mod access_detail {
    /// A builder for [`AccessDetail`](crate::model::AccessDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) service_namespace: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) entity_path: std::option::Option<std::string::String>,
        pub(crate) last_authenticated_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) total_authenticated_entities: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the service in which access was attempted.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of the service in which access was attempted.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// <p>The namespace of the service in which access was attempted.</p>
        /// <p>To learn the service namespace of a service, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html">Actions, resources, and condition keys for Amazon Web Services services</a> in the
        /// <i>Service Authorization Reference</i>. Choose the name of the service to
        /// view details for that service. In the first paragraph, find the service prefix. For
        /// example, <code>(service prefix: a4b)</code>. For more information about service namespaces,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces">Amazon Web Services
        /// service namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn service_namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_namespace = Some(input.into());
            self
        }
        /// <p>The namespace of the service in which access was attempted.</p>
        /// <p>To learn the service namespace of a service, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html">Actions, resources, and condition keys for Amazon Web Services services</a> in the
        /// <i>Service Authorization Reference</i>. Choose the name of the service to
        /// view details for that service. In the first paragraph, find the service prefix. For
        /// example, <code>(service prefix: a4b)</code>. For more information about service namespaces,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces">Amazon Web Services
        /// service namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_service_namespace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_namespace = input;
            self
        }
        /// <p>The Region where the last service access attempt occurred.</p>
        /// <p>This field is null if no principals in the reported Organizations entity attempted to access the
        /// service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Region where the last service access attempt occurred.</p>
        /// <p>This field is null if no principals in the reported Organizations entity attempted to access the
        /// service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The path of the Organizations entity (root, organizational unit, or account) from which an
        /// authenticated principal last attempted to access the service. Amazon Web Services does not report
        /// unauthenticated requests.</p>
        /// <p>This field is null if no principals (IAM users, IAM roles, or root users) in the
        /// reported Organizations entity attempted to access the service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
        pub fn entity_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_path = Some(input.into());
            self
        }
        /// <p>The path of the Organizations entity (root, organizational unit, or account) from which an
        /// authenticated principal last attempted to access the service. Amazon Web Services does not report
        /// unauthenticated requests.</p>
        /// <p>This field is null if no principals (IAM users, IAM roles, or root users) in the
        /// reported Organizations entity attempted to access the service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
        pub fn set_entity_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_path = input;
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when an authenticated principal most recently attempted to access the
        /// service. Amazon Web Services does not report unauthenticated requests.</p>
        /// <p>This field is null if no principals in the reported Organizations entity attempted to access the
        /// service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
        pub fn last_authenticated_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_authenticated_time = Some(input);
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when an authenticated principal most recently attempted to access the
        /// service. Amazon Web Services does not report unauthenticated requests.</p>
        /// <p>This field is null if no principals in the reported Organizations entity attempted to access the
        /// service within the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period">reporting period</a>.</p>
        pub fn set_last_authenticated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_authenticated_time = input;
            self
        }
        /// <p>The number of accounts with authenticated principals (root users, IAM users, and IAM
        /// roles) that attempted to access the service in the reporting period.</p>
        pub fn total_authenticated_entities(mut self, input: i32) -> Self {
            self.total_authenticated_entities = Some(input);
            self
        }
        /// <p>The number of accounts with authenticated principals (root users, IAM users, and IAM
        /// roles) that attempted to access the service in the reporting period.</p>
        pub fn set_total_authenticated_entities(mut self, input: std::option::Option<i32>) -> Self {
            self.total_authenticated_entities = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDetail`](crate::model::AccessDetail)
        pub fn build(self) -> crate::model::AccessDetail {
            crate::model::AccessDetail {
                service_name: self.service_name,
                service_namespace: self.service_namespace,
                region: self.region,
                entity_path: self.entity_path,
                last_authenticated_time: self.last_authenticated_time,
                total_authenticated_entities: self.total_authenticated_entities,
            }
        }
    }
}
impl AccessDetail {
    /// Creates a new builder-style object to manufacture [`AccessDetail`](crate::model::AccessDetail)
    pub fn builder() -> crate::model::access_detail::Builder {
        crate::model::access_detail::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SortKeyType {
    #[allow(missing_docs)] // documentation missing in model
    LastAuthenticatedTimeAscending,
    #[allow(missing_docs)] // documentation missing in model
    LastAuthenticatedTimeDescending,
    #[allow(missing_docs)] // documentation missing in model
    ServiceNamespaceAscending,
    #[allow(missing_docs)] // documentation missing in model
    ServiceNamespaceDescending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SortKeyType {
    fn from(s: &str) -> Self {
        match s {
            "LAST_AUTHENTICATED_TIME_ASCENDING" => SortKeyType::LastAuthenticatedTimeAscending,
            "LAST_AUTHENTICATED_TIME_DESCENDING" => SortKeyType::LastAuthenticatedTimeDescending,
            "SERVICE_NAMESPACE_ASCENDING" => SortKeyType::ServiceNamespaceAscending,
            "SERVICE_NAMESPACE_DESCENDING" => SortKeyType::ServiceNamespaceDescending,
            other => SortKeyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SortKeyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SortKeyType::from(s))
    }
}
impl SortKeyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SortKeyType::LastAuthenticatedTimeAscending => "LAST_AUTHENTICATED_TIME_ASCENDING",
            SortKeyType::LastAuthenticatedTimeDescending => "LAST_AUTHENTICATED_TIME_DESCENDING",
            SortKeyType::ServiceNamespaceAscending => "SERVICE_NAMESPACE_ASCENDING",
            SortKeyType::ServiceNamespaceDescending => "SERVICE_NAMESPACE_DESCENDING",
            SortKeyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "LAST_AUTHENTICATED_TIME_ASCENDING",
            "LAST_AUTHENTICATED_TIME_DESCENDING",
            "SERVICE_NAMESPACE_ASCENDING",
            "SERVICE_NAMESPACE_DESCENDING",
        ]
    }
}
impl AsRef<str> for SortKeyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the user name and password create date for a user.</p>
/// <p> This data type is used as a response element in the <a>CreateLoginProfile</a> and <a>GetLoginProfile</a> operations. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoginProfile {
    /// <p>The name of the user, which can be used for signing in to the Amazon Web Services Management Console.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The date when the password for the user was created.</p>
    pub create_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Specifies whether the user is required to set a new password on next sign-in.</p>
    pub password_reset_required: bool,
}
impl LoginProfile {
    /// <p>The name of the user, which can be used for signing in to the Amazon Web Services Management Console.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The date when the password for the user was created.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_date.as_ref()
    }
    /// <p>Specifies whether the user is required to set a new password on next sign-in.</p>
    pub fn password_reset_required(&self) -> bool {
        self.password_reset_required
    }
}
impl std::fmt::Debug for LoginProfile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoginProfile");
        formatter.field("user_name", &self.user_name);
        formatter.field("create_date", &self.create_date);
        formatter.field("password_reset_required", &self.password_reset_required);
        formatter.finish()
    }
}
/// See [`LoginProfile`](crate::model::LoginProfile)
pub mod login_profile {
    /// A builder for [`LoginProfile`](crate::model::LoginProfile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) password_reset_required: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the user, which can be used for signing in to the Amazon Web Services Management Console.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the user, which can be used for signing in to the Amazon Web Services Management Console.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The date when the password for the user was created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date when the password for the user was created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// <p>Specifies whether the user is required to set a new password on next sign-in.</p>
        pub fn password_reset_required(mut self, input: bool) -> Self {
            self.password_reset_required = Some(input);
            self
        }
        /// <p>Specifies whether the user is required to set a new password on next sign-in.</p>
        pub fn set_password_reset_required(mut self, input: std::option::Option<bool>) -> Self {
            self.password_reset_required = input;
            self
        }
        /// Consumes the builder and constructs a [`LoginProfile`](crate::model::LoginProfile)
        pub fn build(self) -> crate::model::LoginProfile {
            crate::model::LoginProfile {
                user_name: self.user_name,
                create_date: self.create_date,
                password_reset_required: self.password_reset_required.unwrap_or_default(),
            }
        }
    }
}
impl LoginProfile {
    /// Creates a new builder-style object to manufacture [`LoginProfile`](crate::model::LoginProfile)
    pub fn builder() -> crate::model::login_profile::Builder {
        crate::model::login_profile::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReportFormatType {
    #[allow(missing_docs)] // documentation missing in model
    TextCsv,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReportFormatType {
    fn from(s: &str) -> Self {
        match s {
            "text/csv" => ReportFormatType::TextCsv,
            other => ReportFormatType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReportFormatType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReportFormatType::from(s))
    }
}
impl ReportFormatType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReportFormatType::TextCsv => "text/csv",
            ReportFormatType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["text/csv"]
    }
}
impl AsRef<str> for ReportFormatType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SummaryKeyType {
    #[allow(missing_docs)] // documentation missing in model
    AccessKeysPerUserQuota,
    #[allow(missing_docs)] // documentation missing in model
    AccountAccessKeysPresent,
    #[allow(missing_docs)] // documentation missing in model
    AccountMfaEnabled,
    #[allow(missing_docs)] // documentation missing in model
    AccountSigningCertificatesPresent,
    #[allow(missing_docs)] // documentation missing in model
    AttachedPoliciesPerGroupQuota,
    #[allow(missing_docs)] // documentation missing in model
    AttachedPoliciesPerRoleQuota,
    #[allow(missing_docs)] // documentation missing in model
    AttachedPoliciesPerUserQuota,
    #[allow(missing_docs)] // documentation missing in model
    GlobalEndpointTokenVersion,
    #[allow(missing_docs)] // documentation missing in model
    GroupPolicySizeQuota,
    #[allow(missing_docs)] // documentation missing in model
    Groups,
    #[allow(missing_docs)] // documentation missing in model
    GroupsPerUserQuota,
    #[allow(missing_docs)] // documentation missing in model
    GroupsQuota,
    #[allow(missing_docs)] // documentation missing in model
    MfaDevices,
    #[allow(missing_docs)] // documentation missing in model
    MfaDevicesInUse,
    #[allow(missing_docs)] // documentation missing in model
    Policies,
    #[allow(missing_docs)] // documentation missing in model
    PoliciesQuota,
    #[allow(missing_docs)] // documentation missing in model
    PolicySizeQuota,
    #[allow(missing_docs)] // documentation missing in model
    PolicyVersionsInUse,
    #[allow(missing_docs)] // documentation missing in model
    PolicyVersionsInUseQuota,
    #[allow(missing_docs)] // documentation missing in model
    ServerCertificates,
    #[allow(missing_docs)] // documentation missing in model
    ServerCertificatesQuota,
    #[allow(missing_docs)] // documentation missing in model
    SigningCertificatesPerUserQuota,
    #[allow(missing_docs)] // documentation missing in model
    UserPolicySizeQuota,
    #[allow(missing_docs)] // documentation missing in model
    Users,
    #[allow(missing_docs)] // documentation missing in model
    UsersQuota,
    #[allow(missing_docs)] // documentation missing in model
    VersionsPerPolicyQuota,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SummaryKeyType {
    fn from(s: &str) -> Self {
        match s {
            "AccessKeysPerUserQuota" => SummaryKeyType::AccessKeysPerUserQuota,
            "AccountAccessKeysPresent" => SummaryKeyType::AccountAccessKeysPresent,
            "AccountMFAEnabled" => SummaryKeyType::AccountMfaEnabled,
            "AccountSigningCertificatesPresent" => {
                SummaryKeyType::AccountSigningCertificatesPresent
            }
            "AttachedPoliciesPerGroupQuota" => SummaryKeyType::AttachedPoliciesPerGroupQuota,
            "AttachedPoliciesPerRoleQuota" => SummaryKeyType::AttachedPoliciesPerRoleQuota,
            "AttachedPoliciesPerUserQuota" => SummaryKeyType::AttachedPoliciesPerUserQuota,
            "GlobalEndpointTokenVersion" => SummaryKeyType::GlobalEndpointTokenVersion,
            "GroupPolicySizeQuota" => SummaryKeyType::GroupPolicySizeQuota,
            "Groups" => SummaryKeyType::Groups,
            "GroupsPerUserQuota" => SummaryKeyType::GroupsPerUserQuota,
            "GroupsQuota" => SummaryKeyType::GroupsQuota,
            "MFADevices" => SummaryKeyType::MfaDevices,
            "MFADevicesInUse" => SummaryKeyType::MfaDevicesInUse,
            "Policies" => SummaryKeyType::Policies,
            "PoliciesQuota" => SummaryKeyType::PoliciesQuota,
            "PolicySizeQuota" => SummaryKeyType::PolicySizeQuota,
            "PolicyVersionsInUse" => SummaryKeyType::PolicyVersionsInUse,
            "PolicyVersionsInUseQuota" => SummaryKeyType::PolicyVersionsInUseQuota,
            "ServerCertificates" => SummaryKeyType::ServerCertificates,
            "ServerCertificatesQuota" => SummaryKeyType::ServerCertificatesQuota,
            "SigningCertificatesPerUserQuota" => SummaryKeyType::SigningCertificatesPerUserQuota,
            "UserPolicySizeQuota" => SummaryKeyType::UserPolicySizeQuota,
            "Users" => SummaryKeyType::Users,
            "UsersQuota" => SummaryKeyType::UsersQuota,
            "VersionsPerPolicyQuota" => SummaryKeyType::VersionsPerPolicyQuota,
            other => SummaryKeyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SummaryKeyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SummaryKeyType::from(s))
    }
}
impl SummaryKeyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SummaryKeyType::AccessKeysPerUserQuota => "AccessKeysPerUserQuota",
            SummaryKeyType::AccountAccessKeysPresent => "AccountAccessKeysPresent",
            SummaryKeyType::AccountMfaEnabled => "AccountMFAEnabled",
            SummaryKeyType::AccountSigningCertificatesPresent => {
                "AccountSigningCertificatesPresent"
            }
            SummaryKeyType::AttachedPoliciesPerGroupQuota => "AttachedPoliciesPerGroupQuota",
            SummaryKeyType::AttachedPoliciesPerRoleQuota => "AttachedPoliciesPerRoleQuota",
            SummaryKeyType::AttachedPoliciesPerUserQuota => "AttachedPoliciesPerUserQuota",
            SummaryKeyType::GlobalEndpointTokenVersion => "GlobalEndpointTokenVersion",
            SummaryKeyType::GroupPolicySizeQuota => "GroupPolicySizeQuota",
            SummaryKeyType::Groups => "Groups",
            SummaryKeyType::GroupsPerUserQuota => "GroupsPerUserQuota",
            SummaryKeyType::GroupsQuota => "GroupsQuota",
            SummaryKeyType::MfaDevices => "MFADevices",
            SummaryKeyType::MfaDevicesInUse => "MFADevicesInUse",
            SummaryKeyType::Policies => "Policies",
            SummaryKeyType::PoliciesQuota => "PoliciesQuota",
            SummaryKeyType::PolicySizeQuota => "PolicySizeQuota",
            SummaryKeyType::PolicyVersionsInUse => "PolicyVersionsInUse",
            SummaryKeyType::PolicyVersionsInUseQuota => "PolicyVersionsInUseQuota",
            SummaryKeyType::ServerCertificates => "ServerCertificates",
            SummaryKeyType::ServerCertificatesQuota => "ServerCertificatesQuota",
            SummaryKeyType::SigningCertificatesPerUserQuota => "SigningCertificatesPerUserQuota",
            SummaryKeyType::UserPolicySizeQuota => "UserPolicySizeQuota",
            SummaryKeyType::Users => "Users",
            SummaryKeyType::UsersQuota => "UsersQuota",
            SummaryKeyType::VersionsPerPolicyQuota => "VersionsPerPolicyQuota",
            SummaryKeyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AccessKeysPerUserQuota",
            "AccountAccessKeysPresent",
            "AccountMFAEnabled",
            "AccountSigningCertificatesPresent",
            "AttachedPoliciesPerGroupQuota",
            "AttachedPoliciesPerRoleQuota",
            "AttachedPoliciesPerUserQuota",
            "GlobalEndpointTokenVersion",
            "GroupPolicySizeQuota",
            "Groups",
            "GroupsPerUserQuota",
            "GroupsQuota",
            "MFADevices",
            "MFADevicesInUse",
            "Policies",
            "PoliciesQuota",
            "PolicySizeQuota",
            "PolicyVersionsInUse",
            "PolicyVersionsInUseQuota",
            "ServerCertificates",
            "ServerCertificatesQuota",
            "SigningCertificatesPerUserQuota",
            "UserPolicySizeQuota",
            "Users",
            "UsersQuota",
            "VersionsPerPolicyQuota",
        ]
    }
}
impl AsRef<str> for SummaryKeyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the account password policy.</p>
/// <p> This data type is used as a response element in the <a>GetAccountPasswordPolicy</a> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PasswordPolicy {
    /// <p>Minimum length to require for IAM user passwords.</p>
    pub minimum_password_length: std::option::Option<i32>,
    /// <p>Specifies whether IAM user passwords must contain at least one of the following symbols:</p>
    /// <p>! @ # $ % ^ & * ( ) _ + - = [ ] { } | '</p>
    pub require_symbols: bool,
    /// <p>Specifies whether IAM user passwords must contain at least one numeric character (0 to 9).</p>
    pub require_numbers: bool,
    /// <p>Specifies whether IAM user passwords must contain at least one uppercase character (A to Z).</p>
    pub require_uppercase_characters: bool,
    /// <p>Specifies whether IAM user passwords must contain at least one lowercase character (a to z).</p>
    pub require_lowercase_characters: bool,
    /// <p>Specifies whether IAM users are allowed to change their own password.</p>
    pub allow_users_to_change_password: bool,
    /// <p>Indicates whether passwords in the account expire. Returns true if
    /// <code>MaxPasswordAge</code> contains a value greater than 0. Returns false if
    /// MaxPasswordAge is 0 or not present.</p>
    pub expire_passwords: bool,
    /// <p>The number of days that an IAM user password is valid.</p>
    pub max_password_age: std::option::Option<i32>,
    /// <p>Specifies the number of previous passwords that IAM users are prevented from
    /// reusing.</p>
    pub password_reuse_prevention: std::option::Option<i32>,
    /// <p>Specifies whether IAM users are prevented from setting a new password after their
    /// password has expired.</p>
    pub hard_expiry: std::option::Option<bool>,
}
impl PasswordPolicy {
    /// <p>Minimum length to require for IAM user passwords.</p>
    pub fn minimum_password_length(&self) -> std::option::Option<i32> {
        self.minimum_password_length
    }
    /// <p>Specifies whether IAM user passwords must contain at least one of the following symbols:</p>
    /// <p>! @ # $ % ^ & * ( ) _ + - = [ ] { } | '</p>
    pub fn require_symbols(&self) -> bool {
        self.require_symbols
    }
    /// <p>Specifies whether IAM user passwords must contain at least one numeric character (0 to 9).</p>
    pub fn require_numbers(&self) -> bool {
        self.require_numbers
    }
    /// <p>Specifies whether IAM user passwords must contain at least one uppercase character (A to Z).</p>
    pub fn require_uppercase_characters(&self) -> bool {
        self.require_uppercase_characters
    }
    /// <p>Specifies whether IAM user passwords must contain at least one lowercase character (a to z).</p>
    pub fn require_lowercase_characters(&self) -> bool {
        self.require_lowercase_characters
    }
    /// <p>Specifies whether IAM users are allowed to change their own password.</p>
    pub fn allow_users_to_change_password(&self) -> bool {
        self.allow_users_to_change_password
    }
    /// <p>Indicates whether passwords in the account expire. Returns true if
    /// <code>MaxPasswordAge</code> contains a value greater than 0. Returns false if
    /// MaxPasswordAge is 0 or not present.</p>
    pub fn expire_passwords(&self) -> bool {
        self.expire_passwords
    }
    /// <p>The number of days that an IAM user password is valid.</p>
    pub fn max_password_age(&self) -> std::option::Option<i32> {
        self.max_password_age
    }
    /// <p>Specifies the number of previous passwords that IAM users are prevented from
    /// reusing.</p>
    pub fn password_reuse_prevention(&self) -> std::option::Option<i32> {
        self.password_reuse_prevention
    }
    /// <p>Specifies whether IAM users are prevented from setting a new password after their
    /// password has expired.</p>
    pub fn hard_expiry(&self) -> std::option::Option<bool> {
        self.hard_expiry
    }
}
impl std::fmt::Debug for PasswordPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PasswordPolicy");
        formatter.field("minimum_password_length", &self.minimum_password_length);
        formatter.field("require_symbols", &self.require_symbols);
        formatter.field("require_numbers", &self.require_numbers);
        formatter.field(
            "require_uppercase_characters",
            &self.require_uppercase_characters,
        );
        formatter.field(
            "require_lowercase_characters",
            &self.require_lowercase_characters,
        );
        formatter.field(
            "allow_users_to_change_password",
            &self.allow_users_to_change_password,
        );
        formatter.field("expire_passwords", &self.expire_passwords);
        formatter.field("max_password_age", &self.max_password_age);
        formatter.field("password_reuse_prevention", &self.password_reuse_prevention);
        formatter.field("hard_expiry", &self.hard_expiry);
        formatter.finish()
    }
}
/// See [`PasswordPolicy`](crate::model::PasswordPolicy)
pub mod password_policy {
    /// A builder for [`PasswordPolicy`](crate::model::PasswordPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) minimum_password_length: std::option::Option<i32>,
        pub(crate) require_symbols: std::option::Option<bool>,
        pub(crate) require_numbers: std::option::Option<bool>,
        pub(crate) require_uppercase_characters: std::option::Option<bool>,
        pub(crate) require_lowercase_characters: std::option::Option<bool>,
        pub(crate) allow_users_to_change_password: std::option::Option<bool>,
        pub(crate) expire_passwords: std::option::Option<bool>,
        pub(crate) max_password_age: std::option::Option<i32>,
        pub(crate) password_reuse_prevention: std::option::Option<i32>,
        pub(crate) hard_expiry: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Minimum length to require for IAM user passwords.</p>
        pub fn minimum_password_length(mut self, input: i32) -> Self {
            self.minimum_password_length = Some(input);
            self
        }
        /// <p>Minimum length to require for IAM user passwords.</p>
        pub fn set_minimum_password_length(mut self, input: std::option::Option<i32>) -> Self {
            self.minimum_password_length = input;
            self
        }
        /// <p>Specifies whether IAM user passwords must contain at least one of the following symbols:</p>
        /// <p>! @ # $ % ^ & * ( ) _ + - = [ ] { } | '</p>
        pub fn require_symbols(mut self, input: bool) -> Self {
            self.require_symbols = Some(input);
            self
        }
        /// <p>Specifies whether IAM user passwords must contain at least one of the following symbols:</p>
        /// <p>! @ # $ % ^ & * ( ) _ + - = [ ] { } | '</p>
        pub fn set_require_symbols(mut self, input: std::option::Option<bool>) -> Self {
            self.require_symbols = input;
            self
        }
        /// <p>Specifies whether IAM user passwords must contain at least one numeric character (0 to 9).</p>
        pub fn require_numbers(mut self, input: bool) -> Self {
            self.require_numbers = Some(input);
            self
        }
        /// <p>Specifies whether IAM user passwords must contain at least one numeric character (0 to 9).</p>
        pub fn set_require_numbers(mut self, input: std::option::Option<bool>) -> Self {
            self.require_numbers = input;
            self
        }
        /// <p>Specifies whether IAM user passwords must contain at least one uppercase character (A to Z).</p>
        pub fn require_uppercase_characters(mut self, input: bool) -> Self {
            self.require_uppercase_characters = Some(input);
            self
        }
        /// <p>Specifies whether IAM user passwords must contain at least one uppercase character (A to Z).</p>
        pub fn set_require_uppercase_characters(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.require_uppercase_characters = input;
            self
        }
        /// <p>Specifies whether IAM user passwords must contain at least one lowercase character (a to z).</p>
        pub fn require_lowercase_characters(mut self, input: bool) -> Self {
            self.require_lowercase_characters = Some(input);
            self
        }
        /// <p>Specifies whether IAM user passwords must contain at least one lowercase character (a to z).</p>
        pub fn set_require_lowercase_characters(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.require_lowercase_characters = input;
            self
        }
        /// <p>Specifies whether IAM users are allowed to change their own password.</p>
        pub fn allow_users_to_change_password(mut self, input: bool) -> Self {
            self.allow_users_to_change_password = Some(input);
            self
        }
        /// <p>Specifies whether IAM users are allowed to change their own password.</p>
        pub fn set_allow_users_to_change_password(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.allow_users_to_change_password = input;
            self
        }
        /// <p>Indicates whether passwords in the account expire. Returns true if
        /// <code>MaxPasswordAge</code> contains a value greater than 0. Returns false if
        /// MaxPasswordAge is 0 or not present.</p>
        pub fn expire_passwords(mut self, input: bool) -> Self {
            self.expire_passwords = Some(input);
            self
        }
        /// <p>Indicates whether passwords in the account expire. Returns true if
        /// <code>MaxPasswordAge</code> contains a value greater than 0. Returns false if
        /// MaxPasswordAge is 0 or not present.</p>
        pub fn set_expire_passwords(mut self, input: std::option::Option<bool>) -> Self {
            self.expire_passwords = input;
            self
        }
        /// <p>The number of days that an IAM user password is valid.</p>
        pub fn max_password_age(mut self, input: i32) -> Self {
            self.max_password_age = Some(input);
            self
        }
        /// <p>The number of days that an IAM user password is valid.</p>
        pub fn set_max_password_age(mut self, input: std::option::Option<i32>) -> Self {
            self.max_password_age = input;
            self
        }
        /// <p>Specifies the number of previous passwords that IAM users are prevented from
        /// reusing.</p>
        pub fn password_reuse_prevention(mut self, input: i32) -> Self {
            self.password_reuse_prevention = Some(input);
            self
        }
        /// <p>Specifies the number of previous passwords that IAM users are prevented from
        /// reusing.</p>
        pub fn set_password_reuse_prevention(mut self, input: std::option::Option<i32>) -> Self {
            self.password_reuse_prevention = input;
            self
        }
        /// <p>Specifies whether IAM users are prevented from setting a new password after their
        /// password has expired.</p>
        pub fn hard_expiry(mut self, input: bool) -> Self {
            self.hard_expiry = Some(input);
            self
        }
        /// <p>Specifies whether IAM users are prevented from setting a new password after their
        /// password has expired.</p>
        pub fn set_hard_expiry(mut self, input: std::option::Option<bool>) -> Self {
            self.hard_expiry = input;
            self
        }
        /// Consumes the builder and constructs a [`PasswordPolicy`](crate::model::PasswordPolicy)
        pub fn build(self) -> crate::model::PasswordPolicy {
            crate::model::PasswordPolicy {
                minimum_password_length: self.minimum_password_length,
                require_symbols: self.require_symbols.unwrap_or_default(),
                require_numbers: self.require_numbers.unwrap_or_default(),
                require_uppercase_characters: self.require_uppercase_characters.unwrap_or_default(),
                require_lowercase_characters: self.require_lowercase_characters.unwrap_or_default(),
                allow_users_to_change_password: self
                    .allow_users_to_change_password
                    .unwrap_or_default(),
                expire_passwords: self.expire_passwords.unwrap_or_default(),
                max_password_age: self.max_password_age,
                password_reuse_prevention: self.password_reuse_prevention,
                hard_expiry: self.hard_expiry,
            }
        }
    }
}
impl PasswordPolicy {
    /// Creates a new builder-style object to manufacture [`PasswordPolicy`](crate::model::PasswordPolicy)
    pub fn builder() -> crate::model::password_policy::Builder {
        crate::model::password_policy::Builder::default()
    }
}

/// <p>Contains information about a managed policy, including the policy's ARN, versions, and
/// the number of principal entities (users, groups, and roles) that the policy is attached
/// to.</p>
/// <p>This data type is used as a response element in the <a>GetAccountAuthorizationDetails</a> operation.</p>
/// <p>For more information about managed policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed policies and inline
/// policies</a> in the <i>IAM User Guide</i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ManagedPolicyDetail {
    /// <p>The friendly name (not ARN) identifying the policy.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The stable and unique string identifying the policy.</p>
    /// <p>For more information about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub policy_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
    /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
    /// the <i>Amazon Web Services General Reference</i>. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The path to the policy.</p>
    /// <p>For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The identifier for the version of the policy that is set as the default (operative)
    /// version.</p>
    /// <p>For more information about policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
    /// policies</a> in the <i>IAM User Guide</i>. </p>
    pub default_version_id: std::option::Option<std::string::String>,
    /// <p>The number of principal entities (users, groups, and roles) that the policy is attached
    /// to.</p>
    pub attachment_count: std::option::Option<i32>,
    /// <p>The number of entities (users and roles) for which the policy is used as the permissions
    /// boundary. </p>
    /// <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
    /// identities </a> in the <i>IAM User Guide</i>.</p>
    pub permissions_boundary_usage_count: std::option::Option<i32>,
    /// <p>Specifies whether the policy can be attached to an IAM user, group, or role.</p>
    pub is_attachable: bool,
    /// <p>A friendly description of the policy.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the policy was created.</p>
    pub create_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the policy was last updated.</p>
    /// <p>When a policy has only one version, this field contains the date and time when the
    /// policy was created. When a policy has more than one version, this field contains the date
    /// and time when the most recent policy version was created.</p>
    pub update_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A list containing information about the versions of the policy.</p>
    pub policy_version_list: std::option::Option<std::vec::Vec<crate::model::PolicyVersion>>,
}
impl ManagedPolicyDetail {
    /// <p>The friendly name (not ARN) identifying the policy.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The stable and unique string identifying the policy.</p>
    /// <p>For more information about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub fn policy_id(&self) -> std::option::Option<&str> {
        self.policy_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
    /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
    /// the <i>Amazon Web Services General Reference</i>. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The path to the policy.</p>
    /// <p>For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>The identifier for the version of the policy that is set as the default (operative)
    /// version.</p>
    /// <p>For more information about policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
    /// policies</a> in the <i>IAM User Guide</i>. </p>
    pub fn default_version_id(&self) -> std::option::Option<&str> {
        self.default_version_id.as_deref()
    }
    /// <p>The number of principal entities (users, groups, and roles) that the policy is attached
    /// to.</p>
    pub fn attachment_count(&self) -> std::option::Option<i32> {
        self.attachment_count
    }
    /// <p>The number of entities (users and roles) for which the policy is used as the permissions
    /// boundary. </p>
    /// <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
    /// identities </a> in the <i>IAM User Guide</i>.</p>
    pub fn permissions_boundary_usage_count(&self) -> std::option::Option<i32> {
        self.permissions_boundary_usage_count
    }
    /// <p>Specifies whether the policy can be attached to an IAM user, group, or role.</p>
    pub fn is_attachable(&self) -> bool {
        self.is_attachable
    }
    /// <p>A friendly description of the policy.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the policy was created.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_date.as_ref()
    }
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the policy was last updated.</p>
    /// <p>When a policy has only one version, this field contains the date and time when the
    /// policy was created. When a policy has more than one version, this field contains the date
    /// and time when the most recent policy version was created.</p>
    pub fn update_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.update_date.as_ref()
    }
    /// <p>A list containing information about the versions of the policy.</p>
    pub fn policy_version_list(&self) -> std::option::Option<&[crate::model::PolicyVersion]> {
        self.policy_version_list.as_deref()
    }
}
impl std::fmt::Debug for ManagedPolicyDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ManagedPolicyDetail");
        formatter.field("policy_name", &self.policy_name);
        formatter.field("policy_id", &self.policy_id);
        formatter.field("arn", &self.arn);
        formatter.field("path", &self.path);
        formatter.field("default_version_id", &self.default_version_id);
        formatter.field("attachment_count", &self.attachment_count);
        formatter.field(
            "permissions_boundary_usage_count",
            &self.permissions_boundary_usage_count,
        );
        formatter.field("is_attachable", &self.is_attachable);
        formatter.field("description", &self.description);
        formatter.field("create_date", &self.create_date);
        formatter.field("update_date", &self.update_date);
        formatter.field("policy_version_list", &self.policy_version_list);
        formatter.finish()
    }
}
/// See [`ManagedPolicyDetail`](crate::model::ManagedPolicyDetail)
pub mod managed_policy_detail {
    /// A builder for [`ManagedPolicyDetail`](crate::model::ManagedPolicyDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) default_version_id: std::option::Option<std::string::String>,
        pub(crate) attachment_count: std::option::Option<i32>,
        pub(crate) permissions_boundary_usage_count: std::option::Option<i32>,
        pub(crate) is_attachable: std::option::Option<bool>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) update_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) policy_version_list:
            std::option::Option<std::vec::Vec<crate::model::PolicyVersion>>,
    }
    impl Builder {
        /// <p>The friendly name (not ARN) identifying the policy.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The friendly name (not ARN) identifying the policy.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The stable and unique string identifying the policy.</p>
        /// <p>For more information about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_id = Some(input.into());
            self
        }
        /// <p>The stable and unique string identifying the policy.</p>
        /// <p>For more information about IDs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn set_policy_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
        /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
        /// the <i>Amazon Web Services General Reference</i>. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
        /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
        /// the <i>Amazon Web Services General Reference</i>. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The path to the policy.</p>
        /// <p>For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The path to the policy.</p>
        /// <p>For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The identifier for the version of the policy that is set as the default (operative)
        /// version.</p>
        /// <p>For more information about policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
        /// policies</a> in the <i>IAM User Guide</i>. </p>
        pub fn default_version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_version_id = Some(input.into());
            self
        }
        /// <p>The identifier for the version of the policy that is set as the default (operative)
        /// version.</p>
        /// <p>For more information about policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
        /// policies</a> in the <i>IAM User Guide</i>. </p>
        pub fn set_default_version_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_version_id = input;
            self
        }
        /// <p>The number of principal entities (users, groups, and roles) that the policy is attached
        /// to.</p>
        pub fn attachment_count(mut self, input: i32) -> Self {
            self.attachment_count = Some(input);
            self
        }
        /// <p>The number of principal entities (users, groups, and roles) that the policy is attached
        /// to.</p>
        pub fn set_attachment_count(mut self, input: std::option::Option<i32>) -> Self {
            self.attachment_count = input;
            self
        }
        /// <p>The number of entities (users and roles) for which the policy is used as the permissions
        /// boundary. </p>
        /// <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
        /// identities </a> in the <i>IAM User Guide</i>.</p>
        pub fn permissions_boundary_usage_count(mut self, input: i32) -> Self {
            self.permissions_boundary_usage_count = Some(input);
            self
        }
        /// <p>The number of entities (users and roles) for which the policy is used as the permissions
        /// boundary. </p>
        /// <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
        /// identities </a> in the <i>IAM User Guide</i>.</p>
        pub fn set_permissions_boundary_usage_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.permissions_boundary_usage_count = input;
            self
        }
        /// <p>Specifies whether the policy can be attached to an IAM user, group, or role.</p>
        pub fn is_attachable(mut self, input: bool) -> Self {
            self.is_attachable = Some(input);
            self
        }
        /// <p>Specifies whether the policy can be attached to an IAM user, group, or role.</p>
        pub fn set_is_attachable(mut self, input: std::option::Option<bool>) -> Self {
            self.is_attachable = input;
            self
        }
        /// <p>A friendly description of the policy.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A friendly description of the policy.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the policy was created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the policy was created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the policy was last updated.</p>
        /// <p>When a policy has only one version, this field contains the date and time when the
        /// policy was created. When a policy has more than one version, this field contains the date
        /// and time when the most recent policy version was created.</p>
        pub fn update_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.update_date = Some(input);
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the policy was last updated.</p>
        /// <p>When a policy has only one version, this field contains the date and time when the
        /// policy was created. When a policy has more than one version, this field contains the date
        /// and time when the most recent policy version was created.</p>
        pub fn set_update_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.update_date = input;
            self
        }
        /// Appends an item to `policy_version_list`.
        ///
        /// To override the contents of this collection use [`set_policy_version_list`](Self::set_policy_version_list).
        ///
        /// <p>A list containing information about the versions of the policy.</p>
        pub fn policy_version_list(
            mut self,
            input: impl Into<crate::model::PolicyVersion>,
        ) -> Self {
            let mut v = self.policy_version_list.unwrap_or_default();
            v.push(input.into());
            self.policy_version_list = Some(v);
            self
        }
        /// <p>A list containing information about the versions of the policy.</p>
        pub fn set_policy_version_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PolicyVersion>>,
        ) -> Self {
            self.policy_version_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ManagedPolicyDetail`](crate::model::ManagedPolicyDetail)
        pub fn build(self) -> crate::model::ManagedPolicyDetail {
            crate::model::ManagedPolicyDetail {
                policy_name: self.policy_name,
                policy_id: self.policy_id,
                arn: self.arn,
                path: self.path,
                default_version_id: self.default_version_id,
                attachment_count: self.attachment_count,
                permissions_boundary_usage_count: self.permissions_boundary_usage_count,
                is_attachable: self.is_attachable.unwrap_or_default(),
                description: self.description,
                create_date: self.create_date,
                update_date: self.update_date,
                policy_version_list: self.policy_version_list,
            }
        }
    }
}
impl ManagedPolicyDetail {
    /// Creates a new builder-style object to manufacture [`ManagedPolicyDetail`](crate::model::ManagedPolicyDetail)
    pub fn builder() -> crate::model::managed_policy_detail::Builder {
        crate::model::managed_policy_detail::Builder::default()
    }
}

/// <p>Contains information about an IAM role, including all of the role's policies.</p>
/// <p>This data type is used as a response element in the <a>GetAccountAuthorizationDetails</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RoleDetail {
    /// <p>The path to the role. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The friendly name that identifies the role.</p>
    pub role_name: std::option::Option<std::string::String>,
    /// <p>The stable and unique string identifying the role. For more information about IDs, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
    /// identifiers</a> in the <i>IAM User Guide</i>.</p>
    pub role_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
    /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
    /// the <i>Amazon Web Services General Reference</i>. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the role was created.</p>
    pub create_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The trust policy that grants permission to assume the role.</p>
    pub assume_role_policy_document: std::option::Option<std::string::String>,
    /// <p>A list of instance profiles that contain this role.</p>
    pub instance_profile_list: std::option::Option<std::vec::Vec<crate::model::InstanceProfile>>,
    /// <p>A list of inline policies embedded in the role. These policies are the role's access
    /// (permissions) policies.</p>
    pub role_policy_list: std::option::Option<std::vec::Vec<crate::model::PolicyDetail>>,
    /// <p>A list of managed policies attached to the role. These policies are the role's access
    /// (permissions) policies.</p>
    pub attached_managed_policies: std::option::Option<std::vec::Vec<crate::model::AttachedPolicy>>,
    /// <p>The ARN of the policy used to set the permissions boundary for the role.</p>
    /// <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
    /// identities </a> in the <i>IAM User Guide</i>.</p>
    pub permissions_boundary: std::option::Option<crate::model::AttachedPermissionsBoundary>,
    /// <p>A list of tags that are attached to the role. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Contains information about the last time that an IAM role was used. This includes the
    /// date and time and the Region in which the role was last used. Activity is only reported for
    /// the trailing 400 days. This period can be shorter if your Region began supporting these
    /// features within the last year. The role might have been used more than 400 days ago. For
    /// more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period">Regions where data is tracked</a> in the <i>IAM User
    /// Guide</i>.</p>
    pub role_last_used: std::option::Option<crate::model::RoleLastUsed>,
}
impl RoleDetail {
    /// <p>The path to the role. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>The friendly name that identifies the role.</p>
    pub fn role_name(&self) -> std::option::Option<&str> {
        self.role_name.as_deref()
    }
    /// <p>The stable and unique string identifying the role. For more information about IDs, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
    /// identifiers</a> in the <i>IAM User Guide</i>.</p>
    pub fn role_id(&self) -> std::option::Option<&str> {
        self.role_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
    /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
    /// the <i>Amazon Web Services General Reference</i>. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the role was created.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_date.as_ref()
    }
    /// <p>The trust policy that grants permission to assume the role.</p>
    pub fn assume_role_policy_document(&self) -> std::option::Option<&str> {
        self.assume_role_policy_document.as_deref()
    }
    /// <p>A list of instance profiles that contain this role.</p>
    pub fn instance_profile_list(&self) -> std::option::Option<&[crate::model::InstanceProfile]> {
        self.instance_profile_list.as_deref()
    }
    /// <p>A list of inline policies embedded in the role. These policies are the role's access
    /// (permissions) policies.</p>
    pub fn role_policy_list(&self) -> std::option::Option<&[crate::model::PolicyDetail]> {
        self.role_policy_list.as_deref()
    }
    /// <p>A list of managed policies attached to the role. These policies are the role's access
    /// (permissions) policies.</p>
    pub fn attached_managed_policies(
        &self,
    ) -> std::option::Option<&[crate::model::AttachedPolicy]> {
        self.attached_managed_policies.as_deref()
    }
    /// <p>The ARN of the policy used to set the permissions boundary for the role.</p>
    /// <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
    /// identities </a> in the <i>IAM User Guide</i>.</p>
    pub fn permissions_boundary(
        &self,
    ) -> std::option::Option<&crate::model::AttachedPermissionsBoundary> {
        self.permissions_boundary.as_ref()
    }
    /// <p>A list of tags that are attached to the role. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>Contains information about the last time that an IAM role was used. This includes the
    /// date and time and the Region in which the role was last used. Activity is only reported for
    /// the trailing 400 days. This period can be shorter if your Region began supporting these
    /// features within the last year. The role might have been used more than 400 days ago. For
    /// more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period">Regions where data is tracked</a> in the <i>IAM User
    /// Guide</i>.</p>
    pub fn role_last_used(&self) -> std::option::Option<&crate::model::RoleLastUsed> {
        self.role_last_used.as_ref()
    }
}
impl std::fmt::Debug for RoleDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RoleDetail");
        formatter.field("path", &self.path);
        formatter.field("role_name", &self.role_name);
        formatter.field("role_id", &self.role_id);
        formatter.field("arn", &self.arn);
        formatter.field("create_date", &self.create_date);
        formatter.field(
            "assume_role_policy_document",
            &self.assume_role_policy_document,
        );
        formatter.field("instance_profile_list", &self.instance_profile_list);
        formatter.field("role_policy_list", &self.role_policy_list);
        formatter.field("attached_managed_policies", &self.attached_managed_policies);
        formatter.field("permissions_boundary", &self.permissions_boundary);
        formatter.field("tags", &self.tags);
        formatter.field("role_last_used", &self.role_last_used);
        formatter.finish()
    }
}
/// See [`RoleDetail`](crate::model::RoleDetail)
pub mod role_detail {
    /// A builder for [`RoleDetail`](crate::model::RoleDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) role_name: std::option::Option<std::string::String>,
        pub(crate) role_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) assume_role_policy_document: std::option::Option<std::string::String>,
        pub(crate) instance_profile_list:
            std::option::Option<std::vec::Vec<crate::model::InstanceProfile>>,
        pub(crate) role_policy_list: std::option::Option<std::vec::Vec<crate::model::PolicyDetail>>,
        pub(crate) attached_managed_policies:
            std::option::Option<std::vec::Vec<crate::model::AttachedPolicy>>,
        pub(crate) permissions_boundary:
            std::option::Option<crate::model::AttachedPermissionsBoundary>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) role_last_used: std::option::Option<crate::model::RoleLastUsed>,
    }
    impl Builder {
        /// <p>The path to the role. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The path to the role. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The friendly name that identifies the role.</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>The friendly name that identifies the role.</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// <p>The stable and unique string identifying the role. For more information about IDs, see
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>.</p>
        pub fn role_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_id = Some(input.into());
            self
        }
        /// <p>The stable and unique string identifying the role. For more information about IDs, see
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>.</p>
        pub fn set_role_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
        /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
        /// the <i>Amazon Web Services General Reference</i>. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
        /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
        /// the <i>Amazon Web Services General Reference</i>. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the role was created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the role was created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// <p>The trust policy that grants permission to assume the role.</p>
        pub fn assume_role_policy_document(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.assume_role_policy_document = Some(input.into());
            self
        }
        /// <p>The trust policy that grants permission to assume the role.</p>
        pub fn set_assume_role_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assume_role_policy_document = input;
            self
        }
        /// Appends an item to `instance_profile_list`.
        ///
        /// To override the contents of this collection use [`set_instance_profile_list`](Self::set_instance_profile_list).
        ///
        /// <p>A list of instance profiles that contain this role.</p>
        pub fn instance_profile_list(
            mut self,
            input: impl Into<crate::model::InstanceProfile>,
        ) -> Self {
            let mut v = self.instance_profile_list.unwrap_or_default();
            v.push(input.into());
            self.instance_profile_list = Some(v);
            self
        }
        /// <p>A list of instance profiles that contain this role.</p>
        pub fn set_instance_profile_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceProfile>>,
        ) -> Self {
            self.instance_profile_list = input;
            self
        }
        /// Appends an item to `role_policy_list`.
        ///
        /// To override the contents of this collection use [`set_role_policy_list`](Self::set_role_policy_list).
        ///
        /// <p>A list of inline policies embedded in the role. These policies are the role's access
        /// (permissions) policies.</p>
        pub fn role_policy_list(mut self, input: impl Into<crate::model::PolicyDetail>) -> Self {
            let mut v = self.role_policy_list.unwrap_or_default();
            v.push(input.into());
            self.role_policy_list = Some(v);
            self
        }
        /// <p>A list of inline policies embedded in the role. These policies are the role's access
        /// (permissions) policies.</p>
        pub fn set_role_policy_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PolicyDetail>>,
        ) -> Self {
            self.role_policy_list = input;
            self
        }
        /// Appends an item to `attached_managed_policies`.
        ///
        /// To override the contents of this collection use [`set_attached_managed_policies`](Self::set_attached_managed_policies).
        ///
        /// <p>A list of managed policies attached to the role. These policies are the role's access
        /// (permissions) policies.</p>
        pub fn attached_managed_policies(
            mut self,
            input: impl Into<crate::model::AttachedPolicy>,
        ) -> Self {
            let mut v = self.attached_managed_policies.unwrap_or_default();
            v.push(input.into());
            self.attached_managed_policies = Some(v);
            self
        }
        /// <p>A list of managed policies attached to the role. These policies are the role's access
        /// (permissions) policies.</p>
        pub fn set_attached_managed_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttachedPolicy>>,
        ) -> Self {
            self.attached_managed_policies = input;
            self
        }
        /// <p>The ARN of the policy used to set the permissions boundary for the role.</p>
        /// <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
        /// identities </a> in the <i>IAM User Guide</i>.</p>
        pub fn permissions_boundary(
            mut self,
            input: crate::model::AttachedPermissionsBoundary,
        ) -> Self {
            self.permissions_boundary = Some(input);
            self
        }
        /// <p>The ARN of the policy used to set the permissions boundary for the role.</p>
        /// <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
        /// identities </a> in the <i>IAM User Guide</i>.</p>
        pub fn set_permissions_boundary(
            mut self,
            input: std::option::Option<crate::model::AttachedPermissionsBoundary>,
        ) -> Self {
            self.permissions_boundary = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that are attached to the role. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags that are attached to the role. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Contains information about the last time that an IAM role was used. This includes the
        /// date and time and the Region in which the role was last used. Activity is only reported for
        /// the trailing 400 days. This period can be shorter if your Region began supporting these
        /// features within the last year. The role might have been used more than 400 days ago. For
        /// more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period">Regions where data is tracked</a> in the <i>IAM User
        /// Guide</i>.</p>
        pub fn role_last_used(mut self, input: crate::model::RoleLastUsed) -> Self {
            self.role_last_used = Some(input);
            self
        }
        /// <p>Contains information about the last time that an IAM role was used. This includes the
        /// date and time and the Region in which the role was last used. Activity is only reported for
        /// the trailing 400 days. This period can be shorter if your Region began supporting these
        /// features within the last year. The role might have been used more than 400 days ago. For
        /// more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period">Regions where data is tracked</a> in the <i>IAM User
        /// Guide</i>.</p>
        pub fn set_role_last_used(
            mut self,
            input: std::option::Option<crate::model::RoleLastUsed>,
        ) -> Self {
            self.role_last_used = input;
            self
        }
        /// Consumes the builder and constructs a [`RoleDetail`](crate::model::RoleDetail)
        pub fn build(self) -> crate::model::RoleDetail {
            crate::model::RoleDetail {
                path: self.path,
                role_name: self.role_name,
                role_id: self.role_id,
                arn: self.arn,
                create_date: self.create_date,
                assume_role_policy_document: self.assume_role_policy_document,
                instance_profile_list: self.instance_profile_list,
                role_policy_list: self.role_policy_list,
                attached_managed_policies: self.attached_managed_policies,
                permissions_boundary: self.permissions_boundary,
                tags: self.tags,
                role_last_used: self.role_last_used,
            }
        }
    }
}
impl RoleDetail {
    /// Creates a new builder-style object to manufacture [`RoleDetail`](crate::model::RoleDetail)
    pub fn builder() -> crate::model::role_detail::Builder {
        crate::model::role_detail::Builder::default()
    }
}

/// <p>Contains information about an IAM policy, including the policy document.</p>
/// <p>This data type is used as a response element in the <a>GetAccountAuthorizationDetails</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyDetail {
    /// <p>The name of the policy.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The policy document.</p>
    pub policy_document: std::option::Option<std::string::String>,
}
impl PolicyDetail {
    /// <p>The name of the policy.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The policy document.</p>
    pub fn policy_document(&self) -> std::option::Option<&str> {
        self.policy_document.as_deref()
    }
}
impl std::fmt::Debug for PolicyDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyDetail");
        formatter.field("policy_name", &self.policy_name);
        formatter.field("policy_document", &self.policy_document);
        formatter.finish()
    }
}
/// See [`PolicyDetail`](crate::model::PolicyDetail)
pub mod policy_detail {
    /// A builder for [`PolicyDetail`](crate::model::PolicyDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy_document: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the policy.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The policy document.</p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_document = Some(input.into());
            self
        }
        /// <p>The policy document.</p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_document = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyDetail`](crate::model::PolicyDetail)
        pub fn build(self) -> crate::model::PolicyDetail {
            crate::model::PolicyDetail {
                policy_name: self.policy_name,
                policy_document: self.policy_document,
            }
        }
    }
}
impl PolicyDetail {
    /// Creates a new builder-style object to manufacture [`PolicyDetail`](crate::model::PolicyDetail)
    pub fn builder() -> crate::model::policy_detail::Builder {
        crate::model::policy_detail::Builder::default()
    }
}

/// <p>Contains information about an IAM group, including all of the group's policies.</p>
/// <p>This data type is used as a response element in the <a>GetAccountAuthorizationDetails</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GroupDetail {
    /// <p>The path to the group. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The friendly name that identifies the group.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>The stable and unique string identifying the group. For more information about IDs, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
    /// identifiers</a> in the <i>IAM User Guide</i>.</p>
    pub group_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
    /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
    /// the <i>Amazon Web Services General Reference</i>. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the group was created.</p>
    pub create_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A list of the inline policies embedded in the group.</p>
    pub group_policy_list: std::option::Option<std::vec::Vec<crate::model::PolicyDetail>>,
    /// <p>A list of the managed policies attached to the group.</p>
    pub attached_managed_policies: std::option::Option<std::vec::Vec<crate::model::AttachedPolicy>>,
}
impl GroupDetail {
    /// <p>The path to the group. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>The friendly name that identifies the group.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p>The stable and unique string identifying the group. For more information about IDs, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
    /// identifiers</a> in the <i>IAM User Guide</i>.</p>
    pub fn group_id(&self) -> std::option::Option<&str> {
        self.group_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
    /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
    /// the <i>Amazon Web Services General Reference</i>. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the group was created.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_date.as_ref()
    }
    /// <p>A list of the inline policies embedded in the group.</p>
    pub fn group_policy_list(&self) -> std::option::Option<&[crate::model::PolicyDetail]> {
        self.group_policy_list.as_deref()
    }
    /// <p>A list of the managed policies attached to the group.</p>
    pub fn attached_managed_policies(
        &self,
    ) -> std::option::Option<&[crate::model::AttachedPolicy]> {
        self.attached_managed_policies.as_deref()
    }
}
impl std::fmt::Debug for GroupDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GroupDetail");
        formatter.field("path", &self.path);
        formatter.field("group_name", &self.group_name);
        formatter.field("group_id", &self.group_id);
        formatter.field("arn", &self.arn);
        formatter.field("create_date", &self.create_date);
        formatter.field("group_policy_list", &self.group_policy_list);
        formatter.field("attached_managed_policies", &self.attached_managed_policies);
        formatter.finish()
    }
}
/// See [`GroupDetail`](crate::model::GroupDetail)
pub mod group_detail {
    /// A builder for [`GroupDetail`](crate::model::GroupDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) group_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) group_policy_list:
            std::option::Option<std::vec::Vec<crate::model::PolicyDetail>>,
        pub(crate) attached_managed_policies:
            std::option::Option<std::vec::Vec<crate::model::AttachedPolicy>>,
    }
    impl Builder {
        /// <p>The path to the group. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The path to the group. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The friendly name that identifies the group.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The friendly name that identifies the group.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The stable and unique string identifying the group. For more information about IDs, see
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>.</p>
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// <p>The stable and unique string identifying the group. For more information about IDs, see
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>.</p>
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
        /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
        /// the <i>Amazon Web Services General Reference</i>. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
        /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
        /// the <i>Amazon Web Services General Reference</i>. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the group was created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the group was created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// Appends an item to `group_policy_list`.
        ///
        /// To override the contents of this collection use [`set_group_policy_list`](Self::set_group_policy_list).
        ///
        /// <p>A list of the inline policies embedded in the group.</p>
        pub fn group_policy_list(mut self, input: impl Into<crate::model::PolicyDetail>) -> Self {
            let mut v = self.group_policy_list.unwrap_or_default();
            v.push(input.into());
            self.group_policy_list = Some(v);
            self
        }
        /// <p>A list of the inline policies embedded in the group.</p>
        pub fn set_group_policy_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PolicyDetail>>,
        ) -> Self {
            self.group_policy_list = input;
            self
        }
        /// Appends an item to `attached_managed_policies`.
        ///
        /// To override the contents of this collection use [`set_attached_managed_policies`](Self::set_attached_managed_policies).
        ///
        /// <p>A list of the managed policies attached to the group.</p>
        pub fn attached_managed_policies(
            mut self,
            input: impl Into<crate::model::AttachedPolicy>,
        ) -> Self {
            let mut v = self.attached_managed_policies.unwrap_or_default();
            v.push(input.into());
            self.attached_managed_policies = Some(v);
            self
        }
        /// <p>A list of the managed policies attached to the group.</p>
        pub fn set_attached_managed_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttachedPolicy>>,
        ) -> Self {
            self.attached_managed_policies = input;
            self
        }
        /// Consumes the builder and constructs a [`GroupDetail`](crate::model::GroupDetail)
        pub fn build(self) -> crate::model::GroupDetail {
            crate::model::GroupDetail {
                path: self.path,
                group_name: self.group_name,
                group_id: self.group_id,
                arn: self.arn,
                create_date: self.create_date,
                group_policy_list: self.group_policy_list,
                attached_managed_policies: self.attached_managed_policies,
            }
        }
    }
}
impl GroupDetail {
    /// Creates a new builder-style object to manufacture [`GroupDetail`](crate::model::GroupDetail)
    pub fn builder() -> crate::model::group_detail::Builder {
        crate::model::group_detail::Builder::default()
    }
}

/// <p>Contains information about an IAM user, including all the user's policies and all the
/// IAM groups the user is in.</p>
/// <p>This data type is used as a response element in the <a>GetAccountAuthorizationDetails</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserDetail {
    /// <p>The path to the user. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The friendly name identifying the user.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The stable and unique string identifying the user. For more information about IDs, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
    /// identifiers</a> in the <i>IAM User Guide</i>.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
    /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
    /// the <i>Amazon Web Services General Reference</i>. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the user was created.</p>
    pub create_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A list of the inline policies embedded in the user.</p>
    pub user_policy_list: std::option::Option<std::vec::Vec<crate::model::PolicyDetail>>,
    /// <p>A list of IAM groups that the user is in.</p>
    pub group_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of the managed policies attached to the user.</p>
    pub attached_managed_policies: std::option::Option<std::vec::Vec<crate::model::AttachedPolicy>>,
    /// <p>The ARN of the policy used to set the permissions boundary for the user.</p>
    /// <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
    /// identities </a> in the <i>IAM User Guide</i>.</p>
    pub permissions_boundary: std::option::Option<crate::model::AttachedPermissionsBoundary>,
    /// <p>A list of tags that are associated with the user. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl UserDetail {
    /// <p>The path to the user. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>The friendly name identifying the user.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The stable and unique string identifying the user. For more information about IDs, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
    /// identifiers</a> in the <i>IAM User Guide</i>.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
    /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
    /// the <i>Amazon Web Services General Reference</i>. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the user was created.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_date.as_ref()
    }
    /// <p>A list of the inline policies embedded in the user.</p>
    pub fn user_policy_list(&self) -> std::option::Option<&[crate::model::PolicyDetail]> {
        self.user_policy_list.as_deref()
    }
    /// <p>A list of IAM groups that the user is in.</p>
    pub fn group_list(&self) -> std::option::Option<&[std::string::String]> {
        self.group_list.as_deref()
    }
    /// <p>A list of the managed policies attached to the user.</p>
    pub fn attached_managed_policies(
        &self,
    ) -> std::option::Option<&[crate::model::AttachedPolicy]> {
        self.attached_managed_policies.as_deref()
    }
    /// <p>The ARN of the policy used to set the permissions boundary for the user.</p>
    /// <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
    /// identities </a> in the <i>IAM User Guide</i>.</p>
    pub fn permissions_boundary(
        &self,
    ) -> std::option::Option<&crate::model::AttachedPermissionsBoundary> {
        self.permissions_boundary.as_ref()
    }
    /// <p>A list of tags that are associated with the user. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
    /// <i>IAM User Guide</i>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for UserDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserDetail");
        formatter.field("path", &self.path);
        formatter.field("user_name", &self.user_name);
        formatter.field("user_id", &self.user_id);
        formatter.field("arn", &self.arn);
        formatter.field("create_date", &self.create_date);
        formatter.field("user_policy_list", &self.user_policy_list);
        formatter.field("group_list", &self.group_list);
        formatter.field("attached_managed_policies", &self.attached_managed_policies);
        formatter.field("permissions_boundary", &self.permissions_boundary);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`UserDetail`](crate::model::UserDetail)
pub mod user_detail {
    /// A builder for [`UserDetail`](crate::model::UserDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) user_policy_list: std::option::Option<std::vec::Vec<crate::model::PolicyDetail>>,
        pub(crate) group_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) attached_managed_policies:
            std::option::Option<std::vec::Vec<crate::model::AttachedPolicy>>,
        pub(crate) permissions_boundary:
            std::option::Option<crate::model::AttachedPermissionsBoundary>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The path to the user. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The path to the user. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The friendly name identifying the user.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The friendly name identifying the user.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The stable and unique string identifying the user. For more information about IDs, see
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The stable and unique string identifying the user. For more information about IDs, see
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
        /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
        /// the <i>Amazon Web Services General Reference</i>. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN). ARNs are unique identifiers for Amazon Web Services resources.</p>
        /// <p>For more information about ARNs, go to <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in
        /// the <i>Amazon Web Services General Reference</i>. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the user was created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the user was created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// Appends an item to `user_policy_list`.
        ///
        /// To override the contents of this collection use [`set_user_policy_list`](Self::set_user_policy_list).
        ///
        /// <p>A list of the inline policies embedded in the user.</p>
        pub fn user_policy_list(mut self, input: impl Into<crate::model::PolicyDetail>) -> Self {
            let mut v = self.user_policy_list.unwrap_or_default();
            v.push(input.into());
            self.user_policy_list = Some(v);
            self
        }
        /// <p>A list of the inline policies embedded in the user.</p>
        pub fn set_user_policy_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PolicyDetail>>,
        ) -> Self {
            self.user_policy_list = input;
            self
        }
        /// Appends an item to `group_list`.
        ///
        /// To override the contents of this collection use [`set_group_list`](Self::set_group_list).
        ///
        /// <p>A list of IAM groups that the user is in.</p>
        pub fn group_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.group_list.unwrap_or_default();
            v.push(input.into());
            self.group_list = Some(v);
            self
        }
        /// <p>A list of IAM groups that the user is in.</p>
        pub fn set_group_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.group_list = input;
            self
        }
        /// Appends an item to `attached_managed_policies`.
        ///
        /// To override the contents of this collection use [`set_attached_managed_policies`](Self::set_attached_managed_policies).
        ///
        /// <p>A list of the managed policies attached to the user.</p>
        pub fn attached_managed_policies(
            mut self,
            input: impl Into<crate::model::AttachedPolicy>,
        ) -> Self {
            let mut v = self.attached_managed_policies.unwrap_or_default();
            v.push(input.into());
            self.attached_managed_policies = Some(v);
            self
        }
        /// <p>A list of the managed policies attached to the user.</p>
        pub fn set_attached_managed_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttachedPolicy>>,
        ) -> Self {
            self.attached_managed_policies = input;
            self
        }
        /// <p>The ARN of the policy used to set the permissions boundary for the user.</p>
        /// <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
        /// identities </a> in the <i>IAM User Guide</i>.</p>
        pub fn permissions_boundary(
            mut self,
            input: crate::model::AttachedPermissionsBoundary,
        ) -> Self {
            self.permissions_boundary = Some(input);
            self
        }
        /// <p>The ARN of the policy used to set the permissions boundary for the user.</p>
        /// <p>For more information about permissions boundaries, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM
        /// identities </a> in the <i>IAM User Guide</i>.</p>
        pub fn set_permissions_boundary(
            mut self,
            input: std::option::Option<crate::model::AttachedPermissionsBoundary>,
        ) -> Self {
            self.permissions_boundary = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that are associated with the user. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags that are associated with the user. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UserDetail`](crate::model::UserDetail)
        pub fn build(self) -> crate::model::UserDetail {
            crate::model::UserDetail {
                path: self.path,
                user_name: self.user_name,
                user_id: self.user_id,
                arn: self.arn,
                create_date: self.create_date,
                user_policy_list: self.user_policy_list,
                group_list: self.group_list,
                attached_managed_policies: self.attached_managed_policies,
                permissions_boundary: self.permissions_boundary,
                tags: self.tags,
            }
        }
    }
}
impl UserDetail {
    /// Creates a new builder-style object to manufacture [`UserDetail`](crate::model::UserDetail)
    pub fn builder() -> crate::model::user_detail::Builder {
        crate::model::user_detail::Builder::default()
    }
}

/// <p>Contains information about the last time an Amazon Web Services access key was used since IAM began
/// tracking this information on April 22, 2015.</p>
/// <p>This data type is used as a response element in the <a>GetAccessKeyLastUsed</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessKeyLastUsed {
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the access key was most recently used. This field is null in the
    /// following situations:</p>
    /// <ul>
    /// <li>
    /// <p>The user does not have an access key.</p>
    /// </li>
    /// <li>
    /// <p>An access key exists but has not been used since IAM began tracking this
    /// information.</p>
    /// </li>
    /// <li>
    /// <p>There is no sign-in data associated with the user.</p>
    /// </li>
    /// </ul>
    pub last_used_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The name of the Amazon Web Services service with which this access key was most recently used. The value
    /// of this field is "N/A" in the following situations:</p>
    /// <ul>
    /// <li>
    /// <p>The user does not have an access key.</p>
    /// </li>
    /// <li>
    /// <p>An access key exists but has not been used since IAM started tracking this
    /// information.</p>
    /// </li>
    /// <li>
    /// <p>There is no sign-in data associated with the user.</p>
    /// </li>
    /// </ul>
    pub service_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region where this access key was most recently used. The value for this field is
    /// "N/A" in the following situations:</p>
    /// <ul>
    /// <li>
    /// <p>The user does not have an access key.</p>
    /// </li>
    /// <li>
    /// <p>An access key exists but has not been used since IAM began tracking this
    /// information.</p>
    /// </li>
    /// <li>
    /// <p>There is no sign-in data associated with the user.</p>
    /// </li>
    /// </ul>
    /// <p>For more information about Amazon Web Services Regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and endpoints</a> in the Amazon Web Services
    /// General Reference.</p>
    pub region: std::option::Option<std::string::String>,
}
impl AccessKeyLastUsed {
    /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
    /// format</a>, when the access key was most recently used. This field is null in the
    /// following situations:</p>
    /// <ul>
    /// <li>
    /// <p>The user does not have an access key.</p>
    /// </li>
    /// <li>
    /// <p>An access key exists but has not been used since IAM began tracking this
    /// information.</p>
    /// </li>
    /// <li>
    /// <p>There is no sign-in data associated with the user.</p>
    /// </li>
    /// </ul>
    pub fn last_used_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_used_date.as_ref()
    }
    /// <p>The name of the Amazon Web Services service with which this access key was most recently used. The value
    /// of this field is "N/A" in the following situations:</p>
    /// <ul>
    /// <li>
    /// <p>The user does not have an access key.</p>
    /// </li>
    /// <li>
    /// <p>An access key exists but has not been used since IAM started tracking this
    /// information.</p>
    /// </li>
    /// <li>
    /// <p>There is no sign-in data associated with the user.</p>
    /// </li>
    /// </ul>
    pub fn service_name(&self) -> std::option::Option<&str> {
        self.service_name.as_deref()
    }
    /// <p>The Amazon Web Services Region where this access key was most recently used. The value for this field is
    /// "N/A" in the following situations:</p>
    /// <ul>
    /// <li>
    /// <p>The user does not have an access key.</p>
    /// </li>
    /// <li>
    /// <p>An access key exists but has not been used since IAM began tracking this
    /// information.</p>
    /// </li>
    /// <li>
    /// <p>There is no sign-in data associated with the user.</p>
    /// </li>
    /// </ul>
    /// <p>For more information about Amazon Web Services Regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and endpoints</a> in the Amazon Web Services
    /// General Reference.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
}
impl std::fmt::Debug for AccessKeyLastUsed {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessKeyLastUsed");
        formatter.field("last_used_date", &self.last_used_date);
        formatter.field("service_name", &self.service_name);
        formatter.field("region", &self.region);
        formatter.finish()
    }
}
/// See [`AccessKeyLastUsed`](crate::model::AccessKeyLastUsed)
pub mod access_key_last_used {
    /// A builder for [`AccessKeyLastUsed`](crate::model::AccessKeyLastUsed)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) last_used_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the access key was most recently used. This field is null in the
        /// following situations:</p>
        /// <ul>
        /// <li>
        /// <p>The user does not have an access key.</p>
        /// </li>
        /// <li>
        /// <p>An access key exists but has not been used since IAM began tracking this
        /// information.</p>
        /// </li>
        /// <li>
        /// <p>There is no sign-in data associated with the user.</p>
        /// </li>
        /// </ul>
        pub fn last_used_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_used_date = Some(input);
            self
        }
        /// <p>The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time
        /// format</a>, when the access key was most recently used. This field is null in the
        /// following situations:</p>
        /// <ul>
        /// <li>
        /// <p>The user does not have an access key.</p>
        /// </li>
        /// <li>
        /// <p>An access key exists but has not been used since IAM began tracking this
        /// information.</p>
        /// </li>
        /// <li>
        /// <p>There is no sign-in data associated with the user.</p>
        /// </li>
        /// </ul>
        pub fn set_last_used_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_used_date = input;
            self
        }
        /// <p>The name of the Amazon Web Services service with which this access key was most recently used. The value
        /// of this field is "N/A" in the following situations:</p>
        /// <ul>
        /// <li>
        /// <p>The user does not have an access key.</p>
        /// </li>
        /// <li>
        /// <p>An access key exists but has not been used since IAM started tracking this
        /// information.</p>
        /// </li>
        /// <li>
        /// <p>There is no sign-in data associated with the user.</p>
        /// </li>
        /// </ul>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Web Services service with which this access key was most recently used. The value
        /// of this field is "N/A" in the following situations:</p>
        /// <ul>
        /// <li>
        /// <p>The user does not have an access key.</p>
        /// </li>
        /// <li>
        /// <p>An access key exists but has not been used since IAM started tracking this
        /// information.</p>
        /// </li>
        /// <li>
        /// <p>There is no sign-in data associated with the user.</p>
        /// </li>
        /// </ul>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// <p>The Amazon Web Services Region where this access key was most recently used. The value for this field is
        /// "N/A" in the following situations:</p>
        /// <ul>
        /// <li>
        /// <p>The user does not have an access key.</p>
        /// </li>
        /// <li>
        /// <p>An access key exists but has not been used since IAM began tracking this
        /// information.</p>
        /// </li>
        /// <li>
        /// <p>There is no sign-in data associated with the user.</p>
        /// </li>
        /// </ul>
        /// <p>For more information about Amazon Web Services Regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and endpoints</a> in the Amazon Web Services
        /// General Reference.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region where this access key was most recently used. The value for this field is
        /// "N/A" in the following situations:</p>
        /// <ul>
        /// <li>
        /// <p>The user does not have an access key.</p>
        /// </li>
        /// <li>
        /// <p>An access key exists but has not been used since IAM began tracking this
        /// information.</p>
        /// </li>
        /// <li>
        /// <p>There is no sign-in data associated with the user.</p>
        /// </li>
        /// </ul>
        /// <p>For more information about Amazon Web Services Regions, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and endpoints</a> in the Amazon Web Services
        /// General Reference.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessKeyLastUsed`](crate::model::AccessKeyLastUsed)
        pub fn build(self) -> crate::model::AccessKeyLastUsed {
            crate::model::AccessKeyLastUsed {
                last_used_date: self.last_used_date,
                service_name: self.service_name,
                region: self.region,
            }
        }
    }
}
impl AccessKeyLastUsed {
    /// Creates a new builder-style object to manufacture [`AccessKeyLastUsed`](crate::model::AccessKeyLastUsed)
    pub fn builder() -> crate::model::access_key_last_used::Builder {
        crate::model::access_key_last_used::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReportStateType {
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    Inprogress,
    #[allow(missing_docs)] // documentation missing in model
    Started,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReportStateType {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETE" => ReportStateType::Complete,
            "INPROGRESS" => ReportStateType::Inprogress,
            "STARTED" => ReportStateType::Started,
            other => ReportStateType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReportStateType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReportStateType::from(s))
    }
}
impl ReportStateType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReportStateType::Complete => "COMPLETE",
            ReportStateType::Inprogress => "INPROGRESS",
            ReportStateType::Started => "STARTED",
            ReportStateType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETE", "INPROGRESS", "STARTED"]
    }
}
impl AsRef<str> for ReportStateType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about an Amazon Web Services access key.</p>
/// <p> This data type is used as a response element in the <a>CreateAccessKey</a>
/// and <a>ListAccessKeys</a> operations. </p>
/// <note>
/// <p>The <code>SecretAccessKey</code> value is returned only in response to <a>CreateAccessKey</a>. You can get a secret access key only when you first
/// create an access key; you cannot recover the secret access key later. If you lose a
/// secret access key, you must create a new access key.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessKey {
    /// <p>The name of the IAM user that the access key is associated with.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The ID for this access key.</p>
    pub access_key_id: std::option::Option<std::string::String>,
    /// <p>The status of the access key. <code>Active</code> means that the key is valid for API
    /// calls, while <code>Inactive</code> means it is not. </p>
    pub status: std::option::Option<crate::model::StatusType>,
    /// <p>The secret key used to sign requests.</p>
    pub secret_access_key: std::option::Option<std::string::String>,
    /// <p>The date when the access key was created.</p>
    pub create_date: std::option::Option<aws_smithy_types::Instant>,
}
impl AccessKey {
    /// <p>The name of the IAM user that the access key is associated with.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The ID for this access key.</p>
    pub fn access_key_id(&self) -> std::option::Option<&str> {
        self.access_key_id.as_deref()
    }
    /// <p>The status of the access key. <code>Active</code> means that the key is valid for API
    /// calls, while <code>Inactive</code> means it is not. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::StatusType> {
        self.status.as_ref()
    }
    /// <p>The secret key used to sign requests.</p>
    pub fn secret_access_key(&self) -> std::option::Option<&str> {
        self.secret_access_key.as_deref()
    }
    /// <p>The date when the access key was created.</p>
    pub fn create_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_date.as_ref()
    }
}
impl std::fmt::Debug for AccessKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessKey");
        formatter.field("user_name", &self.user_name);
        formatter.field("access_key_id", &self.access_key_id);
        formatter.field("status", &self.status);
        formatter.field("secret_access_key", &"*** Sensitive Data Redacted ***");
        formatter.field("create_date", &self.create_date);
        formatter.finish()
    }
}
/// See [`AccessKey`](crate::model::AccessKey)
pub mod access_key {
    /// A builder for [`AccessKey`](crate::model::AccessKey)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) access_key_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::StatusType>,
        pub(crate) secret_access_key: std::option::Option<std::string::String>,
        pub(crate) create_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the IAM user that the access key is associated with.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM user that the access key is associated with.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The ID for this access key.</p>
        pub fn access_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_key_id = Some(input.into());
            self
        }
        /// <p>The ID for this access key.</p>
        pub fn set_access_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_key_id = input;
            self
        }
        /// <p>The status of the access key. <code>Active</code> means that the key is valid for API
        /// calls, while <code>Inactive</code> means it is not. </p>
        pub fn status(mut self, input: crate::model::StatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the access key. <code>Active</code> means that the key is valid for API
        /// calls, while <code>Inactive</code> means it is not. </p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::StatusType>) -> Self {
            self.status = input;
            self
        }
        /// <p>The secret key used to sign requests.</p>
        pub fn secret_access_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_access_key = Some(input.into());
            self
        }
        /// <p>The secret key used to sign requests.</p>
        pub fn set_secret_access_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secret_access_key = input;
            self
        }
        /// <p>The date when the access key was created.</p>
        pub fn create_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_date = Some(input);
            self
        }
        /// <p>The date when the access key was created.</p>
        pub fn set_create_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_date = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessKey`](crate::model::AccessKey)
        pub fn build(self) -> crate::model::AccessKey {
            crate::model::AccessKey {
                user_name: self.user_name,
                access_key_id: self.access_key_id,
                status: self.status,
                secret_access_key: self.secret_access_key,
                create_date: self.create_date,
            }
        }
    }
}
impl AccessKey {
    /// Creates a new builder-style object to manufacture [`AccessKey`](crate::model::AccessKey)
    pub fn builder() -> crate::model::access_key::Builder {
        crate::model::access_key::Builder::default()
    }
}
