// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AddClientIDToOpenIDConnectProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddClientIDToOpenIDConnectProviderError {
    /// Kind of error that occurred.
    pub kind: AddClientIDToOpenIDConnectProviderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddClientIDToOpenIDConnectProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddClientIDToOpenIDConnectProviderErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddClientIDToOpenIDConnectProviderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddClientIDToOpenIDConnectProviderErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            AddClientIDToOpenIDConnectProviderErrorKind::LimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            AddClientIDToOpenIDConnectProviderErrorKind::NoSuchEntityException(_inner) => {
                _inner.fmt(f)
            }
            AddClientIDToOpenIDConnectProviderErrorKind::ServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            AddClientIDToOpenIDConnectProviderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddClientIDToOpenIDConnectProviderError {
    fn code(&self) -> Option<&str> {
        AddClientIDToOpenIDConnectProviderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddClientIDToOpenIDConnectProviderError {
    /// Creates a new `AddClientIDToOpenIDConnectProviderError`.
    pub fn new(
        kind: AddClientIDToOpenIDConnectProviderErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddClientIDToOpenIDConnectProviderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddClientIDToOpenIDConnectProviderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddClientIDToOpenIDConnectProviderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddClientIDToOpenIDConnectProviderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddClientIDToOpenIDConnectProviderErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddClientIDToOpenIDConnectProviderErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `AddClientIDToOpenIDConnectProviderErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddClientIDToOpenIDConnectProviderErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AddClientIDToOpenIDConnectProviderErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddClientIDToOpenIDConnectProviderErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `AddClientIDToOpenIDConnectProviderErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddClientIDToOpenIDConnectProviderErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for AddClientIDToOpenIDConnectProviderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddClientIDToOpenIDConnectProviderErrorKind::InvalidInputException(_inner) => {
                Some(_inner)
            }
            AddClientIDToOpenIDConnectProviderErrorKind::LimitExceededException(_inner) => {
                Some(_inner)
            }
            AddClientIDToOpenIDConnectProviderErrorKind::NoSuchEntityException(_inner) => {
                Some(_inner)
            }
            AddClientIDToOpenIDConnectProviderErrorKind::ServiceFailureException(_inner) => {
                Some(_inner)
            }
            AddClientIDToOpenIDConnectProviderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AddRoleToInstanceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddRoleToInstanceProfileError {
    /// Kind of error that occurred.
    pub kind: AddRoleToInstanceProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddRoleToInstanceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddRoleToInstanceProfileErrorKind {
    /// <p>The request was rejected because it attempted to create a resource that already
    /// exists.</p>
    EntityAlreadyExistsException(crate::error::EntityAlreadyExistsException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The request was rejected because only the service that depends on the service-linked role
    /// can modify or delete the role on your behalf. The error message includes the name of the
    /// service that depends on this service-linked role. You must request the change through that
    /// service.</p>
    UnmodifiableEntityException(crate::error::UnmodifiableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddRoleToInstanceProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddRoleToInstanceProfileErrorKind::EntityAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            AddRoleToInstanceProfileErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AddRoleToInstanceProfileErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            AddRoleToInstanceProfileErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            AddRoleToInstanceProfileErrorKind::UnmodifiableEntityException(_inner) => _inner.fmt(f),
            AddRoleToInstanceProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddRoleToInstanceProfileError {
    fn code(&self) -> Option<&str> {
        AddRoleToInstanceProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddRoleToInstanceProfileError {
    /// Creates a new `AddRoleToInstanceProfileError`.
    pub fn new(kind: AddRoleToInstanceProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddRoleToInstanceProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddRoleToInstanceProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddRoleToInstanceProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddRoleToInstanceProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddRoleToInstanceProfileErrorKind::EntityAlreadyExistsException`.
    pub fn is_entity_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddRoleToInstanceProfileErrorKind::EntityAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `AddRoleToInstanceProfileErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddRoleToInstanceProfileErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AddRoleToInstanceProfileErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddRoleToInstanceProfileErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `AddRoleToInstanceProfileErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddRoleToInstanceProfileErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `AddRoleToInstanceProfileErrorKind::UnmodifiableEntityException`.
    pub fn is_unmodifiable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddRoleToInstanceProfileErrorKind::UnmodifiableEntityException(_)
        )
    }
}
impl std::error::Error for AddRoleToInstanceProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddRoleToInstanceProfileErrorKind::EntityAlreadyExistsException(_inner) => Some(_inner),
            AddRoleToInstanceProfileErrorKind::LimitExceededException(_inner) => Some(_inner),
            AddRoleToInstanceProfileErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            AddRoleToInstanceProfileErrorKind::ServiceFailureException(_inner) => Some(_inner),
            AddRoleToInstanceProfileErrorKind::UnmodifiableEntityException(_inner) => Some(_inner),
            AddRoleToInstanceProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AddUserToGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddUserToGroupError {
    /// Kind of error that occurred.
    pub kind: AddUserToGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddUserToGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddUserToGroupErrorKind {
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddUserToGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddUserToGroupErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AddUserToGroupErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            AddUserToGroupErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            AddUserToGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddUserToGroupError {
    fn code(&self) -> Option<&str> {
        AddUserToGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddUserToGroupError {
    /// Creates a new `AddUserToGroupError`.
    pub fn new(kind: AddUserToGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddUserToGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddUserToGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddUserToGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddUserToGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddUserToGroupErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddUserToGroupErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AddUserToGroupErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddUserToGroupErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `AddUserToGroupErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddUserToGroupErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for AddUserToGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddUserToGroupErrorKind::LimitExceededException(_inner) => Some(_inner),
            AddUserToGroupErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            AddUserToGroupErrorKind::ServiceFailureException(_inner) => Some(_inner),
            AddUserToGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AttachGroupPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AttachGroupPolicyError {
    /// Kind of error that occurred.
    pub kind: AttachGroupPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AttachGroupPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AttachGroupPolicyErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request failed because Amazon Web Services service role policies can only be attached to the
    /// service-linked role for that service.</p>
    PolicyNotAttachableException(crate::error::PolicyNotAttachableException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AttachGroupPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AttachGroupPolicyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            AttachGroupPolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AttachGroupPolicyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            AttachGroupPolicyErrorKind::PolicyNotAttachableException(_inner) => _inner.fmt(f),
            AttachGroupPolicyErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            AttachGroupPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AttachGroupPolicyError {
    fn code(&self) -> Option<&str> {
        AttachGroupPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AttachGroupPolicyError {
    /// Creates a new `AttachGroupPolicyError`.
    pub fn new(kind: AttachGroupPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AttachGroupPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AttachGroupPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AttachGroupPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AttachGroupPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AttachGroupPolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachGroupPolicyErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachGroupPolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachGroupPolicyErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachGroupPolicyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachGroupPolicyErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachGroupPolicyErrorKind::PolicyNotAttachableException`.
    pub fn is_policy_not_attachable_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachGroupPolicyErrorKind::PolicyNotAttachableException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachGroupPolicyErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachGroupPolicyErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for AttachGroupPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AttachGroupPolicyErrorKind::InvalidInputException(_inner) => Some(_inner),
            AttachGroupPolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            AttachGroupPolicyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            AttachGroupPolicyErrorKind::PolicyNotAttachableException(_inner) => Some(_inner),
            AttachGroupPolicyErrorKind::ServiceFailureException(_inner) => Some(_inner),
            AttachGroupPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AttachRolePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AttachRolePolicyError {
    /// Kind of error that occurred.
    pub kind: AttachRolePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AttachRolePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AttachRolePolicyErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request failed because Amazon Web Services service role policies can only be attached to the
    /// service-linked role for that service.</p>
    PolicyNotAttachableException(crate::error::PolicyNotAttachableException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The request was rejected because only the service that depends on the service-linked role
    /// can modify or delete the role on your behalf. The error message includes the name of the
    /// service that depends on this service-linked role. You must request the change through that
    /// service.</p>
    UnmodifiableEntityException(crate::error::UnmodifiableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AttachRolePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AttachRolePolicyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            AttachRolePolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AttachRolePolicyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            AttachRolePolicyErrorKind::PolicyNotAttachableException(_inner) => _inner.fmt(f),
            AttachRolePolicyErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            AttachRolePolicyErrorKind::UnmodifiableEntityException(_inner) => _inner.fmt(f),
            AttachRolePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AttachRolePolicyError {
    fn code(&self) -> Option<&str> {
        AttachRolePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AttachRolePolicyError {
    /// Creates a new `AttachRolePolicyError`.
    pub fn new(kind: AttachRolePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AttachRolePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AttachRolePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AttachRolePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AttachRolePolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AttachRolePolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachRolePolicyErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachRolePolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachRolePolicyErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachRolePolicyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachRolePolicyErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachRolePolicyErrorKind::PolicyNotAttachableException`.
    pub fn is_policy_not_attachable_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachRolePolicyErrorKind::PolicyNotAttachableException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachRolePolicyErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachRolePolicyErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachRolePolicyErrorKind::UnmodifiableEntityException`.
    pub fn is_unmodifiable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachRolePolicyErrorKind::UnmodifiableEntityException(_)
        )
    }
}
impl std::error::Error for AttachRolePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AttachRolePolicyErrorKind::InvalidInputException(_inner) => Some(_inner),
            AttachRolePolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            AttachRolePolicyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            AttachRolePolicyErrorKind::PolicyNotAttachableException(_inner) => Some(_inner),
            AttachRolePolicyErrorKind::ServiceFailureException(_inner) => Some(_inner),
            AttachRolePolicyErrorKind::UnmodifiableEntityException(_inner) => Some(_inner),
            AttachRolePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AttachUserPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AttachUserPolicyError {
    /// Kind of error that occurred.
    pub kind: AttachUserPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AttachUserPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AttachUserPolicyErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request failed because Amazon Web Services service role policies can only be attached to the
    /// service-linked role for that service.</p>
    PolicyNotAttachableException(crate::error::PolicyNotAttachableException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AttachUserPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AttachUserPolicyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            AttachUserPolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AttachUserPolicyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            AttachUserPolicyErrorKind::PolicyNotAttachableException(_inner) => _inner.fmt(f),
            AttachUserPolicyErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            AttachUserPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AttachUserPolicyError {
    fn code(&self) -> Option<&str> {
        AttachUserPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AttachUserPolicyError {
    /// Creates a new `AttachUserPolicyError`.
    pub fn new(kind: AttachUserPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AttachUserPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AttachUserPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AttachUserPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AttachUserPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AttachUserPolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachUserPolicyErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachUserPolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachUserPolicyErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachUserPolicyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachUserPolicyErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachUserPolicyErrorKind::PolicyNotAttachableException`.
    pub fn is_policy_not_attachable_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachUserPolicyErrorKind::PolicyNotAttachableException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachUserPolicyErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachUserPolicyErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for AttachUserPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AttachUserPolicyErrorKind::InvalidInputException(_inner) => Some(_inner),
            AttachUserPolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            AttachUserPolicyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            AttachUserPolicyErrorKind::PolicyNotAttachableException(_inner) => Some(_inner),
            AttachUserPolicyErrorKind::ServiceFailureException(_inner) => Some(_inner),
            AttachUserPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ChangePassword` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ChangePasswordError {
    /// Kind of error that occurred.
    pub kind: ChangePasswordErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ChangePassword` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ChangePasswordErrorKind {
    /// <p>The request was rejected because it referenced an entity that is temporarily unmodifiable,
    /// such as a user name that was deleted and then recreated. The error indicates that the request
    /// is likely to succeed if you try again after waiting several minutes. The error message
    /// describes the entity.</p>
    EntityTemporarilyUnmodifiableException(crate::error::EntityTemporarilyUnmodifiableException),
    /// <p>The request was rejected because the type of user for the transaction was
    /// incorrect.</p>
    InvalidUserTypeException(crate::error::InvalidUserTypeException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request was rejected because the provided password did not meet the requirements
    /// imposed by the account password policy.</p>
    PasswordPolicyViolationException(crate::error::PasswordPolicyViolationException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ChangePasswordError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ChangePasswordErrorKind::EntityTemporarilyUnmodifiableException(_inner) => {
                _inner.fmt(f)
            }
            ChangePasswordErrorKind::InvalidUserTypeException(_inner) => _inner.fmt(f),
            ChangePasswordErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ChangePasswordErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ChangePasswordErrorKind::PasswordPolicyViolationException(_inner) => _inner.fmt(f),
            ChangePasswordErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ChangePasswordErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ChangePasswordError {
    fn code(&self) -> Option<&str> {
        ChangePasswordError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ChangePasswordError {
    /// Creates a new `ChangePasswordError`.
    pub fn new(kind: ChangePasswordErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ChangePasswordError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ChangePasswordErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ChangePasswordError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ChangePasswordErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ChangePasswordErrorKind::EntityTemporarilyUnmodifiableException`.
    pub fn is_entity_temporarily_unmodifiable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ChangePasswordErrorKind::EntityTemporarilyUnmodifiableException(_)
        )
    }
    /// Returns `true` if the error kind is `ChangePasswordErrorKind::InvalidUserTypeException`.
    pub fn is_invalid_user_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            ChangePasswordErrorKind::InvalidUserTypeException(_)
        )
    }
    /// Returns `true` if the error kind is `ChangePasswordErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ChangePasswordErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ChangePasswordErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ChangePasswordErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `ChangePasswordErrorKind::PasswordPolicyViolationException`.
    pub fn is_password_policy_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ChangePasswordErrorKind::PasswordPolicyViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `ChangePasswordErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ChangePasswordErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for ChangePasswordError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ChangePasswordErrorKind::EntityTemporarilyUnmodifiableException(_inner) => Some(_inner),
            ChangePasswordErrorKind::InvalidUserTypeException(_inner) => Some(_inner),
            ChangePasswordErrorKind::LimitExceededException(_inner) => Some(_inner),
            ChangePasswordErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ChangePasswordErrorKind::PasswordPolicyViolationException(_inner) => Some(_inner),
            ChangePasswordErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ChangePasswordErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAccessKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAccessKeyError {
    /// Kind of error that occurred.
    pub kind: CreateAccessKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAccessKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAccessKeyErrorKind {
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAccessKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAccessKeyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateAccessKeyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            CreateAccessKeyErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateAccessKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAccessKeyError {
    fn code(&self) -> Option<&str> {
        CreateAccessKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAccessKeyError {
    /// Creates a new `CreateAccessKeyError`.
    pub fn new(kind: CreateAccessKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAccessKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAccessKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAccessKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAccessKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAccessKeyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccessKeyErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccessKeyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccessKeyErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccessKeyErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccessKeyErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for CreateAccessKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAccessKeyErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateAccessKeyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            CreateAccessKeyErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateAccessKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAccountAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAccountAliasError {
    /// Kind of error that occurred.
    pub kind: CreateAccountAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAccountAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAccountAliasErrorKind {
    /// <p>The request was rejected because it attempted to create a resource that already
    /// exists.</p>
    EntityAlreadyExistsException(crate::error::EntityAlreadyExistsException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAccountAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAccountAliasErrorKind::EntityAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateAccountAliasErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateAccountAliasErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateAccountAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAccountAliasError {
    fn code(&self) -> Option<&str> {
        CreateAccountAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAccountAliasError {
    /// Creates a new `CreateAccountAliasError`.
    pub fn new(kind: CreateAccountAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAccountAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAccountAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAccountAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAccountAliasErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAccountAliasErrorKind::EntityAlreadyExistsException`.
    pub fn is_entity_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccountAliasErrorKind::EntityAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccountAliasErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccountAliasErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAccountAliasErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAccountAliasErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for CreateAccountAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAccountAliasErrorKind::EntityAlreadyExistsException(_inner) => Some(_inner),
            CreateAccountAliasErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateAccountAliasErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateAccountAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateGroupError {
    /// Kind of error that occurred.
    pub kind: CreateGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateGroupErrorKind {
    /// <p>The request was rejected because it attempted to create a resource that already
    /// exists.</p>
    EntityAlreadyExistsException(crate::error::EntityAlreadyExistsException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateGroupErrorKind::EntityAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateGroupError {
    fn code(&self) -> Option<&str> {
        CreateGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateGroupError {
    /// Creates a new `CreateGroupError`.
    pub fn new(kind: CreateGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateGroupErrorKind::EntityAlreadyExistsException`.
    pub fn is_entity_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGroupErrorKind::EntityAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGroupErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateGroupErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateGroupErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(&self.kind, CreateGroupErrorKind::NoSuchEntityException(_))
    }
    /// Returns `true` if the error kind is `CreateGroupErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, CreateGroupErrorKind::ServiceFailureException(_))
    }
}
impl std::error::Error for CreateGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateGroupErrorKind::EntityAlreadyExistsException(_inner) => Some(_inner),
            CreateGroupErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateGroupErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            CreateGroupErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateInstanceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateInstanceProfileError {
    /// Kind of error that occurred.
    pub kind: CreateInstanceProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateInstanceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateInstanceProfileErrorKind {
    /// <p>The request was rejected because multiple requests to change this object were submitted
    /// simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request was rejected because it attempted to create a resource that already
    /// exists.</p>
    EntityAlreadyExistsException(crate::error::EntityAlreadyExistsException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateInstanceProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateInstanceProfileErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            CreateInstanceProfileErrorKind::EntityAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateInstanceProfileErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateInstanceProfileErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateInstanceProfileErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateInstanceProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateInstanceProfileError {
    fn code(&self) -> Option<&str> {
        CreateInstanceProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateInstanceProfileError {
    /// Creates a new `CreateInstanceProfileError`.
    pub fn new(kind: CreateInstanceProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateInstanceProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateInstanceProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateInstanceProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateInstanceProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateInstanceProfileErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstanceProfileErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInstanceProfileErrorKind::EntityAlreadyExistsException`.
    pub fn is_entity_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstanceProfileErrorKind::EntityAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInstanceProfileErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstanceProfileErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInstanceProfileErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstanceProfileErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInstanceProfileErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstanceProfileErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for CreateInstanceProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateInstanceProfileErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateInstanceProfileErrorKind::EntityAlreadyExistsException(_inner) => Some(_inner),
            CreateInstanceProfileErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateInstanceProfileErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateInstanceProfileErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateInstanceProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLoginProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLoginProfileError {
    /// Kind of error that occurred.
    pub kind: CreateLoginProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLoginProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLoginProfileErrorKind {
    /// <p>The request was rejected because it attempted to create a resource that already
    /// exists.</p>
    EntityAlreadyExistsException(crate::error::EntityAlreadyExistsException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request was rejected because the provided password did not meet the requirements
    /// imposed by the account password policy.</p>
    PasswordPolicyViolationException(crate::error::PasswordPolicyViolationException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLoginProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLoginProfileErrorKind::EntityAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateLoginProfileErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateLoginProfileErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            CreateLoginProfileErrorKind::PasswordPolicyViolationException(_inner) => _inner.fmt(f),
            CreateLoginProfileErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateLoginProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLoginProfileError {
    fn code(&self) -> Option<&str> {
        CreateLoginProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLoginProfileError {
    /// Creates a new `CreateLoginProfileError`.
    pub fn new(kind: CreateLoginProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLoginProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLoginProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLoginProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLoginProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateLoginProfileErrorKind::EntityAlreadyExistsException`.
    pub fn is_entity_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoginProfileErrorKind::EntityAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoginProfileErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoginProfileErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoginProfileErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoginProfileErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoginProfileErrorKind::PasswordPolicyViolationException`.
    pub fn is_password_policy_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoginProfileErrorKind::PasswordPolicyViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoginProfileErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoginProfileErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for CreateLoginProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLoginProfileErrorKind::EntityAlreadyExistsException(_inner) => Some(_inner),
            CreateLoginProfileErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateLoginProfileErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            CreateLoginProfileErrorKind::PasswordPolicyViolationException(_inner) => Some(_inner),
            CreateLoginProfileErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateLoginProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateOpenIDConnectProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateOpenIDConnectProviderError {
    /// Kind of error that occurred.
    pub kind: CreateOpenIDConnectProviderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateOpenIDConnectProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateOpenIDConnectProviderErrorKind {
    /// <p>The request was rejected because multiple requests to change this object were submitted
    /// simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request was rejected because it attempted to create a resource that already
    /// exists.</p>
    EntityAlreadyExistsException(crate::error::EntityAlreadyExistsException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateOpenIDConnectProviderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateOpenIDConnectProviderErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            CreateOpenIDConnectProviderErrorKind::EntityAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            CreateOpenIDConnectProviderErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateOpenIDConnectProviderErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateOpenIDConnectProviderErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateOpenIDConnectProviderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateOpenIDConnectProviderError {
    fn code(&self) -> Option<&str> {
        CreateOpenIDConnectProviderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateOpenIDConnectProviderError {
    /// Creates a new `CreateOpenIDConnectProviderError`.
    pub fn new(kind: CreateOpenIDConnectProviderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateOpenIDConnectProviderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateOpenIDConnectProviderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateOpenIDConnectProviderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateOpenIDConnectProviderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateOpenIDConnectProviderErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOpenIDConnectProviderErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOpenIDConnectProviderErrorKind::EntityAlreadyExistsException`.
    pub fn is_entity_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOpenIDConnectProviderErrorKind::EntityAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOpenIDConnectProviderErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOpenIDConnectProviderErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOpenIDConnectProviderErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOpenIDConnectProviderErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOpenIDConnectProviderErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateOpenIDConnectProviderErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for CreateOpenIDConnectProviderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateOpenIDConnectProviderErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            CreateOpenIDConnectProviderErrorKind::EntityAlreadyExistsException(_inner) => {
                Some(_inner)
            }
            CreateOpenIDConnectProviderErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateOpenIDConnectProviderErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateOpenIDConnectProviderErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateOpenIDConnectProviderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePolicyError {
    /// Kind of error that occurred.
    pub kind: CreatePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePolicyErrorKind {
    /// <p>The request was rejected because multiple requests to change this object were submitted
    /// simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request was rejected because it attempted to create a resource that already
    /// exists.</p>
    EntityAlreadyExistsException(crate::error::EntityAlreadyExistsException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because the policy document was malformed. The error message
    /// describes the specific error.</p>
    MalformedPolicyDocumentException(crate::error::MalformedPolicyDocumentException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePolicyErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreatePolicyErrorKind::EntityAlreadyExistsException(_inner) => _inner.fmt(f),
            CreatePolicyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreatePolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreatePolicyErrorKind::MalformedPolicyDocumentException(_inner) => _inner.fmt(f),
            CreatePolicyErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreatePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePolicyError {
    fn code(&self) -> Option<&str> {
        CreatePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePolicyError {
    /// Creates a new `CreatePolicyError`.
    pub fn new(kind: CreatePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePolicyErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePolicyErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePolicyErrorKind::EntityAlreadyExistsException`.
    pub fn is_entity_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePolicyErrorKind::EntityAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, CreatePolicyErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `CreatePolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreatePolicyErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreatePolicyErrorKind::MalformedPolicyDocumentException`.
    pub fn is_malformed_policy_document_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePolicyErrorKind::MalformedPolicyDocumentException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePolicyErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePolicyErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for CreatePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePolicyErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreatePolicyErrorKind::EntityAlreadyExistsException(_inner) => Some(_inner),
            CreatePolicyErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreatePolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreatePolicyErrorKind::MalformedPolicyDocumentException(_inner) => Some(_inner),
            CreatePolicyErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreatePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePolicyVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePolicyVersionError {
    /// Kind of error that occurred.
    pub kind: CreatePolicyVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePolicyVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePolicyVersionErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because the policy document was malformed. The error message
    /// describes the specific error.</p>
    MalformedPolicyDocumentException(crate::error::MalformedPolicyDocumentException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePolicyVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePolicyVersionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreatePolicyVersionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreatePolicyVersionErrorKind::MalformedPolicyDocumentException(_inner) => _inner.fmt(f),
            CreatePolicyVersionErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            CreatePolicyVersionErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreatePolicyVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePolicyVersionError {
    fn code(&self) -> Option<&str> {
        CreatePolicyVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePolicyVersionError {
    /// Creates a new `CreatePolicyVersionError`.
    pub fn new(kind: CreatePolicyVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePolicyVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePolicyVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePolicyVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePolicyVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePolicyVersionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePolicyVersionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePolicyVersionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePolicyVersionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePolicyVersionErrorKind::MalformedPolicyDocumentException`.
    pub fn is_malformed_policy_document_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePolicyVersionErrorKind::MalformedPolicyDocumentException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePolicyVersionErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePolicyVersionErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePolicyVersionErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePolicyVersionErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for CreatePolicyVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePolicyVersionErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreatePolicyVersionErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreatePolicyVersionErrorKind::MalformedPolicyDocumentException(_inner) => Some(_inner),
            CreatePolicyVersionErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            CreatePolicyVersionErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreatePolicyVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRoleError {
    /// Kind of error that occurred.
    pub kind: CreateRoleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRoleErrorKind {
    /// <p>The request was rejected because multiple requests to change this object were submitted
    /// simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request was rejected because it attempted to create a resource that already
    /// exists.</p>
    EntityAlreadyExistsException(crate::error::EntityAlreadyExistsException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because the policy document was malformed. The error message
    /// describes the specific error.</p>
    MalformedPolicyDocumentException(crate::error::MalformedPolicyDocumentException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRoleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRoleErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateRoleErrorKind::EntityAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateRoleErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateRoleErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateRoleErrorKind::MalformedPolicyDocumentException(_inner) => _inner.fmt(f),
            CreateRoleErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateRoleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRoleError {
    fn code(&self) -> Option<&str> {
        CreateRoleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRoleError {
    /// Creates a new `CreateRoleError`.
    pub fn new(kind: CreateRoleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRoleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRoleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRoleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRoleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRoleErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoleErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRoleErrorKind::EntityAlreadyExistsException`.
    pub fn is_entity_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoleErrorKind::EntityAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRoleErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, CreateRoleErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `CreateRoleErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateRoleErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateRoleErrorKind::MalformedPolicyDocumentException`.
    pub fn is_malformed_policy_document_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoleErrorKind::MalformedPolicyDocumentException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRoleErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, CreateRoleErrorKind::ServiceFailureException(_))
    }
}
impl std::error::Error for CreateRoleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRoleErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateRoleErrorKind::EntityAlreadyExistsException(_inner) => Some(_inner),
            CreateRoleErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateRoleErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateRoleErrorKind::MalformedPolicyDocumentException(_inner) => Some(_inner),
            CreateRoleErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateRoleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSAMLProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSAMLProviderError {
    /// Kind of error that occurred.
    pub kind: CreateSAMLProviderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSAMLProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSAMLProviderErrorKind {
    /// <p>The request was rejected because multiple requests to change this object were submitted
    /// simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request was rejected because it attempted to create a resource that already
    /// exists.</p>
    EntityAlreadyExistsException(crate::error::EntityAlreadyExistsException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSAMLProviderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSAMLProviderErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateSAMLProviderErrorKind::EntityAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateSAMLProviderErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateSAMLProviderErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateSAMLProviderErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateSAMLProviderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSAMLProviderError {
    fn code(&self) -> Option<&str> {
        CreateSAMLProviderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSAMLProviderError {
    /// Creates a new `CreateSAMLProviderError`.
    pub fn new(kind: CreateSAMLProviderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSAMLProviderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSAMLProviderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSAMLProviderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSAMLProviderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSAMLProviderErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSAMLProviderErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSAMLProviderErrorKind::EntityAlreadyExistsException`.
    pub fn is_entity_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSAMLProviderErrorKind::EntityAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSAMLProviderErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSAMLProviderErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSAMLProviderErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSAMLProviderErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSAMLProviderErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSAMLProviderErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for CreateSAMLProviderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSAMLProviderErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateSAMLProviderErrorKind::EntityAlreadyExistsException(_inner) => Some(_inner),
            CreateSAMLProviderErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateSAMLProviderErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateSAMLProviderErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateSAMLProviderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateServiceLinkedRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateServiceLinkedRoleError {
    /// Kind of error that occurred.
    pub kind: CreateServiceLinkedRoleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateServiceLinkedRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateServiceLinkedRoleErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateServiceLinkedRoleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateServiceLinkedRoleErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateServiceLinkedRoleErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateServiceLinkedRoleErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            CreateServiceLinkedRoleErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateServiceLinkedRoleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateServiceLinkedRoleError {
    fn code(&self) -> Option<&str> {
        CreateServiceLinkedRoleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateServiceLinkedRoleError {
    /// Creates a new `CreateServiceLinkedRoleError`.
    pub fn new(kind: CreateServiceLinkedRoleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateServiceLinkedRoleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateServiceLinkedRoleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateServiceLinkedRoleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateServiceLinkedRoleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateServiceLinkedRoleErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceLinkedRoleErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServiceLinkedRoleErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceLinkedRoleErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServiceLinkedRoleErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceLinkedRoleErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServiceLinkedRoleErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceLinkedRoleErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for CreateServiceLinkedRoleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateServiceLinkedRoleErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateServiceLinkedRoleErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateServiceLinkedRoleErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            CreateServiceLinkedRoleErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateServiceLinkedRoleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateServiceSpecificCredential` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateServiceSpecificCredentialError {
    /// Kind of error that occurred.
    pub kind: CreateServiceSpecificCredentialErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateServiceSpecificCredential` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateServiceSpecificCredentialErrorKind {
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The specified service does not support service-specific credentials.</p>
    ServiceNotSupportedException(crate::error::ServiceNotSupportedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateServiceSpecificCredentialError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateServiceSpecificCredentialErrorKind::LimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateServiceSpecificCredentialErrorKind::NoSuchEntityException(_inner) => {
                _inner.fmt(f)
            }
            CreateServiceSpecificCredentialErrorKind::ServiceNotSupportedException(_inner) => {
                _inner.fmt(f)
            }
            CreateServiceSpecificCredentialErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateServiceSpecificCredentialError {
    fn code(&self) -> Option<&str> {
        CreateServiceSpecificCredentialError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateServiceSpecificCredentialError {
    /// Creates a new `CreateServiceSpecificCredentialError`.
    pub fn new(
        kind: CreateServiceSpecificCredentialErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateServiceSpecificCredentialError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateServiceSpecificCredentialErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateServiceSpecificCredentialError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateServiceSpecificCredentialErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateServiceSpecificCredentialErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceSpecificCredentialErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServiceSpecificCredentialErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceSpecificCredentialErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateServiceSpecificCredentialErrorKind::ServiceNotSupportedException`.
    pub fn is_service_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceSpecificCredentialErrorKind::ServiceNotSupportedException(_)
        )
    }
}
impl std::error::Error for CreateServiceSpecificCredentialError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateServiceSpecificCredentialErrorKind::LimitExceededException(_inner) => {
                Some(_inner)
            }
            CreateServiceSpecificCredentialErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            CreateServiceSpecificCredentialErrorKind::ServiceNotSupportedException(_inner) => {
                Some(_inner)
            }
            CreateServiceSpecificCredentialErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateUserError {
    /// Kind of error that occurred.
    pub kind: CreateUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateUserErrorKind {
    /// <p>The request was rejected because multiple requests to change this object were submitted
    /// simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request was rejected because it attempted to create a resource that already
    /// exists.</p>
    EntityAlreadyExistsException(crate::error::EntityAlreadyExistsException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateUserErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::EntityAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateUserError {
    fn code(&self) -> Option<&str> {
        CreateUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateUserError {
    /// Creates a new `CreateUserError`.
    pub fn new(kind: CreateUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateUserErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::EntityAlreadyExistsException`.
    pub fn is_entity_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserErrorKind::EntityAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::NoSuchEntityException(_))
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::ServiceFailureException(_))
    }
}
impl std::error::Error for CreateUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateUserErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateUserErrorKind::EntityAlreadyExistsException(_inner) => Some(_inner),
            CreateUserErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateUserErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateUserErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            CreateUserErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateVirtualMFADevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateVirtualMFADeviceError {
    /// Kind of error that occurred.
    pub kind: CreateVirtualMFADeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateVirtualMFADevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateVirtualMFADeviceErrorKind {
    /// <p>The request was rejected because multiple requests to change this object were submitted
    /// simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request was rejected because it attempted to create a resource that already
    /// exists.</p>
    EntityAlreadyExistsException(crate::error::EntityAlreadyExistsException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateVirtualMFADeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateVirtualMFADeviceErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            CreateVirtualMFADeviceErrorKind::EntityAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateVirtualMFADeviceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateVirtualMFADeviceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateVirtualMFADeviceErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            CreateVirtualMFADeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateVirtualMFADeviceError {
    fn code(&self) -> Option<&str> {
        CreateVirtualMFADeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateVirtualMFADeviceError {
    /// Creates a new `CreateVirtualMFADeviceError`.
    pub fn new(kind: CreateVirtualMFADeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateVirtualMFADeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateVirtualMFADeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateVirtualMFADeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateVirtualMFADeviceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateVirtualMFADeviceErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualMFADeviceErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVirtualMFADeviceErrorKind::EntityAlreadyExistsException`.
    pub fn is_entity_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualMFADeviceErrorKind::EntityAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVirtualMFADeviceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualMFADeviceErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVirtualMFADeviceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualMFADeviceErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVirtualMFADeviceErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualMFADeviceErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for CreateVirtualMFADeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateVirtualMFADeviceErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            CreateVirtualMFADeviceErrorKind::EntityAlreadyExistsException(_inner) => Some(_inner),
            CreateVirtualMFADeviceErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateVirtualMFADeviceErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateVirtualMFADeviceErrorKind::ServiceFailureException(_inner) => Some(_inner),
            CreateVirtualMFADeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeactivateMFADevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeactivateMFADeviceError {
    /// Kind of error that occurred.
    pub kind: DeactivateMFADeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeactivateMFADevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeactivateMFADeviceErrorKind {
    /// <p>The request was rejected because it referenced an entity that is temporarily unmodifiable,
    /// such as a user name that was deleted and then recreated. The error indicates that the request
    /// is likely to succeed if you try again after waiting several minutes. The error message
    /// describes the entity.</p>
    EntityTemporarilyUnmodifiableException(crate::error::EntityTemporarilyUnmodifiableException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeactivateMFADeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeactivateMFADeviceErrorKind::EntityTemporarilyUnmodifiableException(_inner) => {
                _inner.fmt(f)
            }
            DeactivateMFADeviceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeactivateMFADeviceErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            DeactivateMFADeviceErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeactivateMFADeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeactivateMFADeviceError {
    fn code(&self) -> Option<&str> {
        DeactivateMFADeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeactivateMFADeviceError {
    /// Creates a new `DeactivateMFADeviceError`.
    pub fn new(kind: DeactivateMFADeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeactivateMFADeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeactivateMFADeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeactivateMFADeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeactivateMFADeviceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeactivateMFADeviceErrorKind::EntityTemporarilyUnmodifiableException`.
    pub fn is_entity_temporarily_unmodifiable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeactivateMFADeviceErrorKind::EntityTemporarilyUnmodifiableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeactivateMFADeviceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeactivateMFADeviceErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeactivateMFADeviceErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeactivateMFADeviceErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeactivateMFADeviceErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeactivateMFADeviceErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for DeactivateMFADeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeactivateMFADeviceErrorKind::EntityTemporarilyUnmodifiableException(_inner) => {
                Some(_inner)
            }
            DeactivateMFADeviceErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeactivateMFADeviceErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            DeactivateMFADeviceErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeactivateMFADeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAccessKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAccessKeyError {
    /// Kind of error that occurred.
    pub kind: DeleteAccessKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAccessKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAccessKeyErrorKind {
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAccessKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAccessKeyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteAccessKeyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            DeleteAccessKeyErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteAccessKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAccessKeyError {
    fn code(&self) -> Option<&str> {
        DeleteAccessKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAccessKeyError {
    /// Creates a new `DeleteAccessKeyError`.
    pub fn new(kind: DeleteAccessKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAccessKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAccessKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAccessKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAccessKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAccessKeyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccessKeyErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAccessKeyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccessKeyErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAccessKeyErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccessKeyErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for DeleteAccessKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAccessKeyErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteAccessKeyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            DeleteAccessKeyErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteAccessKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAccountAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAccountAliasError {
    /// Kind of error that occurred.
    pub kind: DeleteAccountAliasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAccountAlias` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAccountAliasErrorKind {
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAccountAliasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAccountAliasErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteAccountAliasErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            DeleteAccountAliasErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteAccountAliasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAccountAliasError {
    fn code(&self) -> Option<&str> {
        DeleteAccountAliasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAccountAliasError {
    /// Creates a new `DeleteAccountAliasError`.
    pub fn new(kind: DeleteAccountAliasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAccountAliasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAccountAliasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAccountAliasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAccountAliasErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAccountAliasErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccountAliasErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAccountAliasErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccountAliasErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAccountAliasErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccountAliasErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for DeleteAccountAliasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAccountAliasErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteAccountAliasErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            DeleteAccountAliasErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteAccountAliasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAccountPasswordPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAccountPasswordPolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteAccountPasswordPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAccountPasswordPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAccountPasswordPolicyErrorKind {
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAccountPasswordPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAccountPasswordPolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteAccountPasswordPolicyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            DeleteAccountPasswordPolicyErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteAccountPasswordPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAccountPasswordPolicyError {
    fn code(&self) -> Option<&str> {
        DeleteAccountPasswordPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAccountPasswordPolicyError {
    /// Creates a new `DeleteAccountPasswordPolicyError`.
    pub fn new(kind: DeleteAccountPasswordPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAccountPasswordPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAccountPasswordPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAccountPasswordPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAccountPasswordPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAccountPasswordPolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccountPasswordPolicyErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAccountPasswordPolicyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccountPasswordPolicyErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAccountPasswordPolicyErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAccountPasswordPolicyErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for DeleteAccountPasswordPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAccountPasswordPolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteAccountPasswordPolicyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            DeleteAccountPasswordPolicyErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteAccountPasswordPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteGroupErrorKind {
    /// <p>The request was rejected because it attempted to delete a resource that has attached
    /// subordinate entities. The error message describes these entities.</p>
    DeleteConflictException(crate::error::DeleteConflictException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteGroupErrorKind::DeleteConflictException(_inner) => _inner.fmt(f),
            DeleteGroupErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteGroupErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            DeleteGroupErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteGroupError {
    fn code(&self) -> Option<&str> {
        DeleteGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteGroupError {
    /// Creates a new `DeleteGroupError`.
    pub fn new(kind: DeleteGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteGroupErrorKind::DeleteConflictException`.
    pub fn is_delete_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteGroupErrorKind::DeleteConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteGroupErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, DeleteGroupErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `DeleteGroupErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(&self.kind, DeleteGroupErrorKind::NoSuchEntityException(_))
    }
    /// Returns `true` if the error kind is `DeleteGroupErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, DeleteGroupErrorKind::ServiceFailureException(_))
    }
}
impl std::error::Error for DeleteGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteGroupErrorKind::DeleteConflictException(_inner) => Some(_inner),
            DeleteGroupErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteGroupErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            DeleteGroupErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteGroupPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteGroupPolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteGroupPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteGroupPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteGroupPolicyErrorKind {
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteGroupPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteGroupPolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteGroupPolicyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            DeleteGroupPolicyErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteGroupPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteGroupPolicyError {
    fn code(&self) -> Option<&str> {
        DeleteGroupPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteGroupPolicyError {
    /// Creates a new `DeleteGroupPolicyError`.
    pub fn new(kind: DeleteGroupPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteGroupPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteGroupPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteGroupPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteGroupPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteGroupPolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGroupPolicyErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGroupPolicyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGroupPolicyErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGroupPolicyErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGroupPolicyErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for DeleteGroupPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteGroupPolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteGroupPolicyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            DeleteGroupPolicyErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteGroupPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteInstanceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteInstanceProfileError {
    /// Kind of error that occurred.
    pub kind: DeleteInstanceProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteInstanceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteInstanceProfileErrorKind {
    /// <p>The request was rejected because it attempted to delete a resource that has attached
    /// subordinate entities. The error message describes these entities.</p>
    DeleteConflictException(crate::error::DeleteConflictException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteInstanceProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteInstanceProfileErrorKind::DeleteConflictException(_inner) => _inner.fmt(f),
            DeleteInstanceProfileErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteInstanceProfileErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            DeleteInstanceProfileErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteInstanceProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteInstanceProfileError {
    fn code(&self) -> Option<&str> {
        DeleteInstanceProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteInstanceProfileError {
    /// Creates a new `DeleteInstanceProfileError`.
    pub fn new(kind: DeleteInstanceProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteInstanceProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteInstanceProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteInstanceProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteInstanceProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteInstanceProfileErrorKind::DeleteConflictException`.
    pub fn is_delete_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInstanceProfileErrorKind::DeleteConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInstanceProfileErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInstanceProfileErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInstanceProfileErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInstanceProfileErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInstanceProfileErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInstanceProfileErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for DeleteInstanceProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteInstanceProfileErrorKind::DeleteConflictException(_inner) => Some(_inner),
            DeleteInstanceProfileErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteInstanceProfileErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            DeleteInstanceProfileErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteInstanceProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteLoginProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteLoginProfileError {
    /// Kind of error that occurred.
    pub kind: DeleteLoginProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteLoginProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteLoginProfileErrorKind {
    /// <p>The request was rejected because it referenced an entity that is temporarily unmodifiable,
    /// such as a user name that was deleted and then recreated. The error indicates that the request
    /// is likely to succeed if you try again after waiting several minutes. The error message
    /// describes the entity.</p>
    EntityTemporarilyUnmodifiableException(crate::error::EntityTemporarilyUnmodifiableException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteLoginProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteLoginProfileErrorKind::EntityTemporarilyUnmodifiableException(_inner) => {
                _inner.fmt(f)
            }
            DeleteLoginProfileErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteLoginProfileErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            DeleteLoginProfileErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteLoginProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteLoginProfileError {
    fn code(&self) -> Option<&str> {
        DeleteLoginProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteLoginProfileError {
    /// Creates a new `DeleteLoginProfileError`.
    pub fn new(kind: DeleteLoginProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteLoginProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteLoginProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteLoginProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteLoginProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteLoginProfileErrorKind::EntityTemporarilyUnmodifiableException`.
    pub fn is_entity_temporarily_unmodifiable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLoginProfileErrorKind::EntityTemporarilyUnmodifiableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLoginProfileErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLoginProfileErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLoginProfileErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLoginProfileErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLoginProfileErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLoginProfileErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for DeleteLoginProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteLoginProfileErrorKind::EntityTemporarilyUnmodifiableException(_inner) => {
                Some(_inner)
            }
            DeleteLoginProfileErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteLoginProfileErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            DeleteLoginProfileErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteLoginProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteOpenIDConnectProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteOpenIDConnectProviderError {
    /// Kind of error that occurred.
    pub kind: DeleteOpenIDConnectProviderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteOpenIDConnectProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteOpenIDConnectProviderErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteOpenIDConnectProviderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteOpenIDConnectProviderErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteOpenIDConnectProviderErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            DeleteOpenIDConnectProviderErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteOpenIDConnectProviderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteOpenIDConnectProviderError {
    fn code(&self) -> Option<&str> {
        DeleteOpenIDConnectProviderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteOpenIDConnectProviderError {
    /// Creates a new `DeleteOpenIDConnectProviderError`.
    pub fn new(kind: DeleteOpenIDConnectProviderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteOpenIDConnectProviderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteOpenIDConnectProviderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteOpenIDConnectProviderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteOpenIDConnectProviderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteOpenIDConnectProviderErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOpenIDConnectProviderErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOpenIDConnectProviderErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOpenIDConnectProviderErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOpenIDConnectProviderErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOpenIDConnectProviderErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for DeleteOpenIDConnectProviderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteOpenIDConnectProviderErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteOpenIDConnectProviderErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            DeleteOpenIDConnectProviderErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteOpenIDConnectProviderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePolicyError {
    /// Kind of error that occurred.
    pub kind: DeletePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePolicyErrorKind {
    /// <p>The request was rejected because it attempted to delete a resource that has attached
    /// subordinate entities. The error message describes these entities.</p>
    DeleteConflictException(crate::error::DeleteConflictException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePolicyErrorKind::DeleteConflictException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePolicyError {
    fn code(&self) -> Option<&str> {
        DeletePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePolicyError {
    /// Creates a new `DeletePolicyError`.
    pub fn new(kind: DeletePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::DeleteConflictException`.
    pub fn is_delete_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyErrorKind::DeleteConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, DeletePolicyErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, DeletePolicyErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(&self.kind, DeletePolicyErrorKind::NoSuchEntityException(_))
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for DeletePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePolicyErrorKind::DeleteConflictException(_inner) => Some(_inner),
            DeletePolicyErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeletePolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeletePolicyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            DeletePolicyErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeletePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePolicyVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePolicyVersionError {
    /// Kind of error that occurred.
    pub kind: DeletePolicyVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePolicyVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePolicyVersionErrorKind {
    /// <p>The request was rejected because it attempted to delete a resource that has attached
    /// subordinate entities. The error message describes these entities.</p>
    DeleteConflictException(crate::error::DeleteConflictException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePolicyVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePolicyVersionErrorKind::DeleteConflictException(_inner) => _inner.fmt(f),
            DeletePolicyVersionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeletePolicyVersionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeletePolicyVersionErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            DeletePolicyVersionErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeletePolicyVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePolicyVersionError {
    fn code(&self) -> Option<&str> {
        DeletePolicyVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePolicyVersionError {
    /// Creates a new `DeletePolicyVersionError`.
    pub fn new(kind: DeletePolicyVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePolicyVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePolicyVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePolicyVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePolicyVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePolicyVersionErrorKind::DeleteConflictException`.
    pub fn is_delete_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyVersionErrorKind::DeleteConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePolicyVersionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyVersionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePolicyVersionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyVersionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePolicyVersionErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyVersionErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePolicyVersionErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyVersionErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for DeletePolicyVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePolicyVersionErrorKind::DeleteConflictException(_inner) => Some(_inner),
            DeletePolicyVersionErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeletePolicyVersionErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeletePolicyVersionErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            DeletePolicyVersionErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeletePolicyVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRoleError {
    /// Kind of error that occurred.
    pub kind: DeleteRoleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRoleErrorKind {
    /// <p>The request was rejected because multiple requests to change this object were submitted
    /// simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request was rejected because it attempted to delete a resource that has attached
    /// subordinate entities. The error message describes these entities.</p>
    DeleteConflictException(crate::error::DeleteConflictException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The request was rejected because only the service that depends on the service-linked role
    /// can modify or delete the role on your behalf. The error message includes the name of the
    /// service that depends on this service-linked role. You must request the change through that
    /// service.</p>
    UnmodifiableEntityException(crate::error::UnmodifiableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRoleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRoleErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteRoleErrorKind::DeleteConflictException(_inner) => _inner.fmt(f),
            DeleteRoleErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteRoleErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            DeleteRoleErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteRoleErrorKind::UnmodifiableEntityException(_inner) => _inner.fmt(f),
            DeleteRoleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRoleError {
    fn code(&self) -> Option<&str> {
        DeleteRoleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRoleError {
    /// Creates a new `DeleteRoleError`.
    pub fn new(kind: DeleteRoleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRoleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRoleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRoleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRoleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRoleErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRoleErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRoleErrorKind::DeleteConflictException`.
    pub fn is_delete_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteRoleErrorKind::DeleteConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteRoleErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, DeleteRoleErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `DeleteRoleErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(&self.kind, DeleteRoleErrorKind::NoSuchEntityException(_))
    }
    /// Returns `true` if the error kind is `DeleteRoleErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, DeleteRoleErrorKind::ServiceFailureException(_))
    }
    /// Returns `true` if the error kind is `DeleteRoleErrorKind::UnmodifiableEntityException`.
    pub fn is_unmodifiable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRoleErrorKind::UnmodifiableEntityException(_)
        )
    }
}
impl std::error::Error for DeleteRoleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRoleErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteRoleErrorKind::DeleteConflictException(_inner) => Some(_inner),
            DeleteRoleErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteRoleErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            DeleteRoleErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteRoleErrorKind::UnmodifiableEntityException(_inner) => Some(_inner),
            DeleteRoleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRolePermissionsBoundary` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRolePermissionsBoundaryError {
    /// Kind of error that occurred.
    pub kind: DeleteRolePermissionsBoundaryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRolePermissionsBoundary` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRolePermissionsBoundaryErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The request was rejected because only the service that depends on the service-linked role
    /// can modify or delete the role on your behalf. The error message includes the name of the
    /// service that depends on this service-linked role. You must request the change through that
    /// service.</p>
    UnmodifiableEntityException(crate::error::UnmodifiableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRolePermissionsBoundaryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRolePermissionsBoundaryErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            DeleteRolePermissionsBoundaryErrorKind::ServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            DeleteRolePermissionsBoundaryErrorKind::UnmodifiableEntityException(_inner) => {
                _inner.fmt(f)
            }
            DeleteRolePermissionsBoundaryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRolePermissionsBoundaryError {
    fn code(&self) -> Option<&str> {
        DeleteRolePermissionsBoundaryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRolePermissionsBoundaryError {
    /// Creates a new `DeleteRolePermissionsBoundaryError`.
    pub fn new(
        kind: DeleteRolePermissionsBoundaryErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRolePermissionsBoundaryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRolePermissionsBoundaryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRolePermissionsBoundaryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRolePermissionsBoundaryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRolePermissionsBoundaryErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRolePermissionsBoundaryErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRolePermissionsBoundaryErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRolePermissionsBoundaryErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRolePermissionsBoundaryErrorKind::UnmodifiableEntityException`.
    pub fn is_unmodifiable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRolePermissionsBoundaryErrorKind::UnmodifiableEntityException(_)
        )
    }
}
impl std::error::Error for DeleteRolePermissionsBoundaryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRolePermissionsBoundaryErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            DeleteRolePermissionsBoundaryErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteRolePermissionsBoundaryErrorKind::UnmodifiableEntityException(_inner) => {
                Some(_inner)
            }
            DeleteRolePermissionsBoundaryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRolePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRolePolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteRolePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRolePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRolePolicyErrorKind {
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The request was rejected because only the service that depends on the service-linked role
    /// can modify or delete the role on your behalf. The error message includes the name of the
    /// service that depends on this service-linked role. You must request the change through that
    /// service.</p>
    UnmodifiableEntityException(crate::error::UnmodifiableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRolePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRolePolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteRolePolicyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            DeleteRolePolicyErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteRolePolicyErrorKind::UnmodifiableEntityException(_inner) => _inner.fmt(f),
            DeleteRolePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRolePolicyError {
    fn code(&self) -> Option<&str> {
        DeleteRolePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRolePolicyError {
    /// Creates a new `DeleteRolePolicyError`.
    pub fn new(kind: DeleteRolePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRolePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRolePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRolePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRolePolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRolePolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRolePolicyErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRolePolicyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRolePolicyErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRolePolicyErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRolePolicyErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRolePolicyErrorKind::UnmodifiableEntityException`.
    pub fn is_unmodifiable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRolePolicyErrorKind::UnmodifiableEntityException(_)
        )
    }
}
impl std::error::Error for DeleteRolePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRolePolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteRolePolicyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            DeleteRolePolicyErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteRolePolicyErrorKind::UnmodifiableEntityException(_inner) => Some(_inner),
            DeleteRolePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSAMLProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSAMLProviderError {
    /// Kind of error that occurred.
    pub kind: DeleteSAMLProviderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSAMLProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSAMLProviderErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSAMLProviderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSAMLProviderErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteSAMLProviderErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteSAMLProviderErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            DeleteSAMLProviderErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteSAMLProviderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSAMLProviderError {
    fn code(&self) -> Option<&str> {
        DeleteSAMLProviderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSAMLProviderError {
    /// Creates a new `DeleteSAMLProviderError`.
    pub fn new(kind: DeleteSAMLProviderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSAMLProviderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSAMLProviderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSAMLProviderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSAMLProviderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSAMLProviderErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSAMLProviderErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSAMLProviderErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSAMLProviderErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSAMLProviderErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSAMLProviderErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSAMLProviderErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSAMLProviderErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for DeleteSAMLProviderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSAMLProviderErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteSAMLProviderErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteSAMLProviderErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            DeleteSAMLProviderErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteSAMLProviderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteServerCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteServerCertificateError {
    /// Kind of error that occurred.
    pub kind: DeleteServerCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteServerCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteServerCertificateErrorKind {
    /// <p>The request was rejected because it attempted to delete a resource that has attached
    /// subordinate entities. The error message describes these entities.</p>
    DeleteConflictException(crate::error::DeleteConflictException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteServerCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteServerCertificateErrorKind::DeleteConflictException(_inner) => _inner.fmt(f),
            DeleteServerCertificateErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteServerCertificateErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            DeleteServerCertificateErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteServerCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteServerCertificateError {
    fn code(&self) -> Option<&str> {
        DeleteServerCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteServerCertificateError {
    /// Creates a new `DeleteServerCertificateError`.
    pub fn new(kind: DeleteServerCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteServerCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteServerCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteServerCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteServerCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteServerCertificateErrorKind::DeleteConflictException`.
    pub fn is_delete_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServerCertificateErrorKind::DeleteConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServerCertificateErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServerCertificateErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServerCertificateErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServerCertificateErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServerCertificateErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServerCertificateErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for DeleteServerCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteServerCertificateErrorKind::DeleteConflictException(_inner) => Some(_inner),
            DeleteServerCertificateErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteServerCertificateErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            DeleteServerCertificateErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteServerCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteServiceLinkedRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteServiceLinkedRoleError {
    /// Kind of error that occurred.
    pub kind: DeleteServiceLinkedRoleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteServiceLinkedRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteServiceLinkedRoleErrorKind {
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteServiceLinkedRoleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteServiceLinkedRoleErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteServiceLinkedRoleErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            DeleteServiceLinkedRoleErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteServiceLinkedRoleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteServiceLinkedRoleError {
    fn code(&self) -> Option<&str> {
        DeleteServiceLinkedRoleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteServiceLinkedRoleError {
    /// Creates a new `DeleteServiceLinkedRoleError`.
    pub fn new(kind: DeleteServiceLinkedRoleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteServiceLinkedRoleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteServiceLinkedRoleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteServiceLinkedRoleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteServiceLinkedRoleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteServiceLinkedRoleErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceLinkedRoleErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServiceLinkedRoleErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceLinkedRoleErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteServiceLinkedRoleErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceLinkedRoleErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for DeleteServiceLinkedRoleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteServiceLinkedRoleErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteServiceLinkedRoleErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            DeleteServiceLinkedRoleErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteServiceLinkedRoleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteServiceSpecificCredential` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteServiceSpecificCredentialError {
    /// Kind of error that occurred.
    pub kind: DeleteServiceSpecificCredentialErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteServiceSpecificCredential` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteServiceSpecificCredentialErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteServiceSpecificCredentialError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteServiceSpecificCredentialErrorKind::NoSuchEntityException(_inner) => {
                _inner.fmt(f)
            }
            DeleteServiceSpecificCredentialErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteServiceSpecificCredentialError {
    fn code(&self) -> Option<&str> {
        DeleteServiceSpecificCredentialError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteServiceSpecificCredentialError {
    /// Creates a new `DeleteServiceSpecificCredentialError`.
    pub fn new(
        kind: DeleteServiceSpecificCredentialErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteServiceSpecificCredentialError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteServiceSpecificCredentialErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteServiceSpecificCredentialError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteServiceSpecificCredentialErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteServiceSpecificCredentialErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceSpecificCredentialErrorKind::NoSuchEntityException(_)
        )
    }
}
impl std::error::Error for DeleteServiceSpecificCredentialError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteServiceSpecificCredentialErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            DeleteServiceSpecificCredentialErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSigningCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSigningCertificateError {
    /// Kind of error that occurred.
    pub kind: DeleteSigningCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSigningCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSigningCertificateErrorKind {
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSigningCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSigningCertificateErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteSigningCertificateErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            DeleteSigningCertificateErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteSigningCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSigningCertificateError {
    fn code(&self) -> Option<&str> {
        DeleteSigningCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSigningCertificateError {
    /// Creates a new `DeleteSigningCertificateError`.
    pub fn new(kind: DeleteSigningCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSigningCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSigningCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSigningCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSigningCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSigningCertificateErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSigningCertificateErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSigningCertificateErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSigningCertificateErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSigningCertificateErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSigningCertificateErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for DeleteSigningCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSigningCertificateErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteSigningCertificateErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            DeleteSigningCertificateErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteSigningCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSSHPublicKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSSHPublicKeyError {
    /// Kind of error that occurred.
    pub kind: DeleteSSHPublicKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSSHPublicKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSSHPublicKeyErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSSHPublicKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSSHPublicKeyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            DeleteSSHPublicKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSSHPublicKeyError {
    fn code(&self) -> Option<&str> {
        DeleteSSHPublicKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSSHPublicKeyError {
    /// Creates a new `DeleteSSHPublicKeyError`.
    pub fn new(kind: DeleteSSHPublicKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSSHPublicKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSSHPublicKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSSHPublicKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSSHPublicKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSSHPublicKeyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSSHPublicKeyErrorKind::NoSuchEntityException(_)
        )
    }
}
impl std::error::Error for DeleteSSHPublicKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSSHPublicKeyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            DeleteSSHPublicKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteUserError {
    /// Kind of error that occurred.
    pub kind: DeleteUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteUserErrorKind {
    /// <p>The request was rejected because multiple requests to change this object were submitted
    /// simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request was rejected because it attempted to delete a resource that has attached
    /// subordinate entities. The error message describes these entities.</p>
    DeleteConflictException(crate::error::DeleteConflictException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteUserErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::DeleteConflictException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteUserError {
    fn code(&self) -> Option<&str> {
        DeleteUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteUserError {
    /// Creates a new `DeleteUserError`.
    pub fn new(kind: DeleteUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteUserErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::DeleteConflictException`.
    pub fn is_delete_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteUserErrorKind::DeleteConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, DeleteUserErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(&self.kind, DeleteUserErrorKind::NoSuchEntityException(_))
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, DeleteUserErrorKind::ServiceFailureException(_))
    }
}
impl std::error::Error for DeleteUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteUserErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteUserErrorKind::DeleteConflictException(_inner) => Some(_inner),
            DeleteUserErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteUserErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            DeleteUserErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteUserPermissionsBoundary` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteUserPermissionsBoundaryError {
    /// Kind of error that occurred.
    pub kind: DeleteUserPermissionsBoundaryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteUserPermissionsBoundary` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteUserPermissionsBoundaryErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteUserPermissionsBoundaryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteUserPermissionsBoundaryErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            DeleteUserPermissionsBoundaryErrorKind::ServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            DeleteUserPermissionsBoundaryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteUserPermissionsBoundaryError {
    fn code(&self) -> Option<&str> {
        DeleteUserPermissionsBoundaryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteUserPermissionsBoundaryError {
    /// Creates a new `DeleteUserPermissionsBoundaryError`.
    pub fn new(
        kind: DeleteUserPermissionsBoundaryErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteUserPermissionsBoundaryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteUserPermissionsBoundaryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteUserPermissionsBoundaryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteUserPermissionsBoundaryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteUserPermissionsBoundaryErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserPermissionsBoundaryErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserPermissionsBoundaryErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserPermissionsBoundaryErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for DeleteUserPermissionsBoundaryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteUserPermissionsBoundaryErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            DeleteUserPermissionsBoundaryErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteUserPermissionsBoundaryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteUserPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteUserPolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteUserPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteUserPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteUserPolicyErrorKind {
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteUserPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteUserPolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteUserPolicyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            DeleteUserPolicyErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteUserPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteUserPolicyError {
    fn code(&self) -> Option<&str> {
        DeleteUserPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteUserPolicyError {
    /// Creates a new `DeleteUserPolicyError`.
    pub fn new(kind: DeleteUserPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteUserPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteUserPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteUserPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteUserPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteUserPolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserPolicyErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserPolicyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserPolicyErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserPolicyErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserPolicyErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for DeleteUserPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteUserPolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteUserPolicyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            DeleteUserPolicyErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteUserPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteVirtualMFADevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteVirtualMFADeviceError {
    /// Kind of error that occurred.
    pub kind: DeleteVirtualMFADeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteVirtualMFADevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteVirtualMFADeviceErrorKind {
    /// <p>The request was rejected because it attempted to delete a resource that has attached
    /// subordinate entities. The error message describes these entities.</p>
    DeleteConflictException(crate::error::DeleteConflictException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteVirtualMFADeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteVirtualMFADeviceErrorKind::DeleteConflictException(_inner) => _inner.fmt(f),
            DeleteVirtualMFADeviceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteVirtualMFADeviceErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            DeleteVirtualMFADeviceErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DeleteVirtualMFADeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteVirtualMFADeviceError {
    fn code(&self) -> Option<&str> {
        DeleteVirtualMFADeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteVirtualMFADeviceError {
    /// Creates a new `DeleteVirtualMFADeviceError`.
    pub fn new(kind: DeleteVirtualMFADeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteVirtualMFADeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteVirtualMFADeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteVirtualMFADeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteVirtualMFADeviceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteVirtualMFADeviceErrorKind::DeleteConflictException`.
    pub fn is_delete_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualMFADeviceErrorKind::DeleteConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVirtualMFADeviceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualMFADeviceErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVirtualMFADeviceErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualMFADeviceErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVirtualMFADeviceErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualMFADeviceErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for DeleteVirtualMFADeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteVirtualMFADeviceErrorKind::DeleteConflictException(_inner) => Some(_inner),
            DeleteVirtualMFADeviceErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteVirtualMFADeviceErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            DeleteVirtualMFADeviceErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DeleteVirtualMFADeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetachGroupPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetachGroupPolicyError {
    /// Kind of error that occurred.
    pub kind: DetachGroupPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetachGroupPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetachGroupPolicyErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetachGroupPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetachGroupPolicyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DetachGroupPolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DetachGroupPolicyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            DetachGroupPolicyErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DetachGroupPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetachGroupPolicyError {
    fn code(&self) -> Option<&str> {
        DetachGroupPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetachGroupPolicyError {
    /// Creates a new `DetachGroupPolicyError`.
    pub fn new(kind: DetachGroupPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetachGroupPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetachGroupPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetachGroupPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetachGroupPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DetachGroupPolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachGroupPolicyErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachGroupPolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachGroupPolicyErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachGroupPolicyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachGroupPolicyErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachGroupPolicyErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachGroupPolicyErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for DetachGroupPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetachGroupPolicyErrorKind::InvalidInputException(_inner) => Some(_inner),
            DetachGroupPolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            DetachGroupPolicyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            DetachGroupPolicyErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DetachGroupPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetachRolePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetachRolePolicyError {
    /// Kind of error that occurred.
    pub kind: DetachRolePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetachRolePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetachRolePolicyErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The request was rejected because only the service that depends on the service-linked role
    /// can modify or delete the role on your behalf. The error message includes the name of the
    /// service that depends on this service-linked role. You must request the change through that
    /// service.</p>
    UnmodifiableEntityException(crate::error::UnmodifiableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetachRolePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetachRolePolicyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DetachRolePolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DetachRolePolicyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            DetachRolePolicyErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DetachRolePolicyErrorKind::UnmodifiableEntityException(_inner) => _inner.fmt(f),
            DetachRolePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetachRolePolicyError {
    fn code(&self) -> Option<&str> {
        DetachRolePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetachRolePolicyError {
    /// Creates a new `DetachRolePolicyError`.
    pub fn new(kind: DetachRolePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetachRolePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetachRolePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetachRolePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetachRolePolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DetachRolePolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachRolePolicyErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachRolePolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachRolePolicyErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachRolePolicyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachRolePolicyErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachRolePolicyErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachRolePolicyErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachRolePolicyErrorKind::UnmodifiableEntityException`.
    pub fn is_unmodifiable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachRolePolicyErrorKind::UnmodifiableEntityException(_)
        )
    }
}
impl std::error::Error for DetachRolePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetachRolePolicyErrorKind::InvalidInputException(_inner) => Some(_inner),
            DetachRolePolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            DetachRolePolicyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            DetachRolePolicyErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DetachRolePolicyErrorKind::UnmodifiableEntityException(_inner) => Some(_inner),
            DetachRolePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetachUserPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetachUserPolicyError {
    /// Kind of error that occurred.
    pub kind: DetachUserPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetachUserPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetachUserPolicyErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetachUserPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetachUserPolicyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DetachUserPolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DetachUserPolicyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            DetachUserPolicyErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            DetachUserPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetachUserPolicyError {
    fn code(&self) -> Option<&str> {
        DetachUserPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetachUserPolicyError {
    /// Creates a new `DetachUserPolicyError`.
    pub fn new(kind: DetachUserPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetachUserPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetachUserPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetachUserPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetachUserPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DetachUserPolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachUserPolicyErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachUserPolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachUserPolicyErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachUserPolicyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachUserPolicyErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachUserPolicyErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachUserPolicyErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for DetachUserPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetachUserPolicyErrorKind::InvalidInputException(_inner) => Some(_inner),
            DetachUserPolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            DetachUserPolicyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            DetachUserPolicyErrorKind::ServiceFailureException(_inner) => Some(_inner),
            DetachUserPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableMFADevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableMFADeviceError {
    /// Kind of error that occurred.
    pub kind: EnableMFADeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableMFADevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableMFADeviceErrorKind {
    /// <p>The request was rejected because it attempted to create a resource that already
    /// exists.</p>
    EntityAlreadyExistsException(crate::error::EntityAlreadyExistsException),
    /// <p>The request was rejected because it referenced an entity that is temporarily unmodifiable,
    /// such as a user name that was deleted and then recreated. The error indicates that the request
    /// is likely to succeed if you try again after waiting several minutes. The error message
    /// describes the entity.</p>
    EntityTemporarilyUnmodifiableException(crate::error::EntityTemporarilyUnmodifiableException),
    /// <p>The request was rejected because the authentication code was not recognized. The error
    /// message describes the specific error.</p>
    InvalidAuthenticationCodeException(crate::error::InvalidAuthenticationCodeException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableMFADeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableMFADeviceErrorKind::EntityAlreadyExistsException(_inner) => _inner.fmt(f),
            EnableMFADeviceErrorKind::EntityTemporarilyUnmodifiableException(_inner) => {
                _inner.fmt(f)
            }
            EnableMFADeviceErrorKind::InvalidAuthenticationCodeException(_inner) => _inner.fmt(f),
            EnableMFADeviceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            EnableMFADeviceErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            EnableMFADeviceErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            EnableMFADeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableMFADeviceError {
    fn code(&self) -> Option<&str> {
        EnableMFADeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableMFADeviceError {
    /// Creates a new `EnableMFADeviceError`.
    pub fn new(kind: EnableMFADeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableMFADeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableMFADeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableMFADeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableMFADeviceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableMFADeviceErrorKind::EntityAlreadyExistsException`.
    pub fn is_entity_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableMFADeviceErrorKind::EntityAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableMFADeviceErrorKind::EntityTemporarilyUnmodifiableException`.
    pub fn is_entity_temporarily_unmodifiable_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableMFADeviceErrorKind::EntityTemporarilyUnmodifiableException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableMFADeviceErrorKind::InvalidAuthenticationCodeException`.
    pub fn is_invalid_authentication_code_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableMFADeviceErrorKind::InvalidAuthenticationCodeException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableMFADeviceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableMFADeviceErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableMFADeviceErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableMFADeviceErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableMFADeviceErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableMFADeviceErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for EnableMFADeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableMFADeviceErrorKind::EntityAlreadyExistsException(_inner) => Some(_inner),
            EnableMFADeviceErrorKind::EntityTemporarilyUnmodifiableException(_inner) => {
                Some(_inner)
            }
            EnableMFADeviceErrorKind::InvalidAuthenticationCodeException(_inner) => Some(_inner),
            EnableMFADeviceErrorKind::LimitExceededException(_inner) => Some(_inner),
            EnableMFADeviceErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            EnableMFADeviceErrorKind::ServiceFailureException(_inner) => Some(_inner),
            EnableMFADeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GenerateCredentialReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GenerateCredentialReportError {
    /// Kind of error that occurred.
    pub kind: GenerateCredentialReportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GenerateCredentialReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GenerateCredentialReportErrorKind {
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GenerateCredentialReportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GenerateCredentialReportErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GenerateCredentialReportErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GenerateCredentialReportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GenerateCredentialReportError {
    fn code(&self) -> Option<&str> {
        GenerateCredentialReportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GenerateCredentialReportError {
    /// Creates a new `GenerateCredentialReportError`.
    pub fn new(kind: GenerateCredentialReportErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GenerateCredentialReportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GenerateCredentialReportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GenerateCredentialReportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GenerateCredentialReportErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GenerateCredentialReportErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateCredentialReportErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateCredentialReportErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateCredentialReportErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for GenerateCredentialReportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GenerateCredentialReportErrorKind::LimitExceededException(_inner) => Some(_inner),
            GenerateCredentialReportErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GenerateCredentialReportErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GenerateOrganizationsAccessReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GenerateOrganizationsAccessReportError {
    /// Kind of error that occurred.
    pub kind: GenerateOrganizationsAccessReportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GenerateOrganizationsAccessReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GenerateOrganizationsAccessReportErrorKind {
    /// <p>The request failed because the maximum number of concurrent requests for this account are
    /// already running.</p>
    ReportGenerationLimitExceededException(crate::error::ReportGenerationLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GenerateOrganizationsAccessReportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GenerateOrganizationsAccessReportErrorKind::ReportGenerationLimitExceededException(
                _inner,
            ) => _inner.fmt(f),
            GenerateOrganizationsAccessReportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GenerateOrganizationsAccessReportError {
    fn code(&self) -> Option<&str> {
        GenerateOrganizationsAccessReportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GenerateOrganizationsAccessReportError {
    /// Creates a new `GenerateOrganizationsAccessReportError`.
    pub fn new(
        kind: GenerateOrganizationsAccessReportErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GenerateOrganizationsAccessReportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GenerateOrganizationsAccessReportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GenerateOrganizationsAccessReportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GenerateOrganizationsAccessReportErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GenerateOrganizationsAccessReportErrorKind::ReportGenerationLimitExceededException`.
    pub fn is_report_generation_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateOrganizationsAccessReportErrorKind::ReportGenerationLimitExceededException(_)
        )
    }
}
impl std::error::Error for GenerateOrganizationsAccessReportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GenerateOrganizationsAccessReportErrorKind::ReportGenerationLimitExceededException(
                _inner,
            ) => Some(_inner),
            GenerateOrganizationsAccessReportErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GenerateServiceLastAccessedDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GenerateServiceLastAccessedDetailsError {
    /// Kind of error that occurred.
    pub kind: GenerateServiceLastAccessedDetailsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GenerateServiceLastAccessedDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GenerateServiceLastAccessedDetailsErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GenerateServiceLastAccessedDetailsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GenerateServiceLastAccessedDetailsErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            GenerateServiceLastAccessedDetailsErrorKind::NoSuchEntityException(_inner) => {
                _inner.fmt(f)
            }
            GenerateServiceLastAccessedDetailsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GenerateServiceLastAccessedDetailsError {
    fn code(&self) -> Option<&str> {
        GenerateServiceLastAccessedDetailsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GenerateServiceLastAccessedDetailsError {
    /// Creates a new `GenerateServiceLastAccessedDetailsError`.
    pub fn new(
        kind: GenerateServiceLastAccessedDetailsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GenerateServiceLastAccessedDetailsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GenerateServiceLastAccessedDetailsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GenerateServiceLastAccessedDetailsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GenerateServiceLastAccessedDetailsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GenerateServiceLastAccessedDetailsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateServiceLastAccessedDetailsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GenerateServiceLastAccessedDetailsErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            GenerateServiceLastAccessedDetailsErrorKind::NoSuchEntityException(_)
        )
    }
}
impl std::error::Error for GenerateServiceLastAccessedDetailsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GenerateServiceLastAccessedDetailsErrorKind::InvalidInputException(_inner) => {
                Some(_inner)
            }
            GenerateServiceLastAccessedDetailsErrorKind::NoSuchEntityException(_inner) => {
                Some(_inner)
            }
            GenerateServiceLastAccessedDetailsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAccessKeyLastUsed` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAccessKeyLastUsedError {
    /// Kind of error that occurred.
    pub kind: GetAccessKeyLastUsedErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAccessKeyLastUsed` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAccessKeyLastUsedErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAccessKeyLastUsedError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAccessKeyLastUsedErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            GetAccessKeyLastUsedErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAccessKeyLastUsedError {
    fn code(&self) -> Option<&str> {
        GetAccessKeyLastUsedError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAccessKeyLastUsedError {
    /// Creates a new `GetAccessKeyLastUsedError`.
    pub fn new(kind: GetAccessKeyLastUsedErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAccessKeyLastUsedError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAccessKeyLastUsedErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAccessKeyLastUsedError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAccessKeyLastUsedErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAccessKeyLastUsedErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccessKeyLastUsedErrorKind::NoSuchEntityException(_)
        )
    }
}
impl std::error::Error for GetAccessKeyLastUsedError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAccessKeyLastUsedErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            GetAccessKeyLastUsedErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAccountAuthorizationDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAccountAuthorizationDetailsError {
    /// Kind of error that occurred.
    pub kind: GetAccountAuthorizationDetailsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAccountAuthorizationDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAccountAuthorizationDetailsErrorKind {
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAccountAuthorizationDetailsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAccountAuthorizationDetailsErrorKind::ServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            GetAccountAuthorizationDetailsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAccountAuthorizationDetailsError {
    fn code(&self) -> Option<&str> {
        GetAccountAuthorizationDetailsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAccountAuthorizationDetailsError {
    /// Creates a new `GetAccountAuthorizationDetailsError`.
    pub fn new(
        kind: GetAccountAuthorizationDetailsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAccountAuthorizationDetailsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAccountAuthorizationDetailsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAccountAuthorizationDetailsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAccountAuthorizationDetailsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAccountAuthorizationDetailsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccountAuthorizationDetailsErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for GetAccountAuthorizationDetailsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAccountAuthorizationDetailsErrorKind::ServiceFailureException(_inner) => {
                Some(_inner)
            }
            GetAccountAuthorizationDetailsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAccountPasswordPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAccountPasswordPolicyError {
    /// Kind of error that occurred.
    pub kind: GetAccountPasswordPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAccountPasswordPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAccountPasswordPolicyErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAccountPasswordPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAccountPasswordPolicyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            GetAccountPasswordPolicyErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetAccountPasswordPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAccountPasswordPolicyError {
    fn code(&self) -> Option<&str> {
        GetAccountPasswordPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAccountPasswordPolicyError {
    /// Creates a new `GetAccountPasswordPolicyError`.
    pub fn new(kind: GetAccountPasswordPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAccountPasswordPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAccountPasswordPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAccountPasswordPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAccountPasswordPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAccountPasswordPolicyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccountPasswordPolicyErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAccountPasswordPolicyErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccountPasswordPolicyErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for GetAccountPasswordPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAccountPasswordPolicyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            GetAccountPasswordPolicyErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetAccountPasswordPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAccountSummary` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAccountSummaryError {
    /// Kind of error that occurred.
    pub kind: GetAccountSummaryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAccountSummary` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAccountSummaryErrorKind {
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAccountSummaryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAccountSummaryErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetAccountSummaryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAccountSummaryError {
    fn code(&self) -> Option<&str> {
        GetAccountSummaryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAccountSummaryError {
    /// Creates a new `GetAccountSummaryError`.
    pub fn new(kind: GetAccountSummaryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAccountSummaryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAccountSummaryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAccountSummaryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAccountSummaryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAccountSummaryErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccountSummaryErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for GetAccountSummaryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAccountSummaryErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetAccountSummaryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetContextKeysForCustomPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetContextKeysForCustomPolicyError {
    /// Kind of error that occurred.
    pub kind: GetContextKeysForCustomPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetContextKeysForCustomPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetContextKeysForCustomPolicyErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetContextKeysForCustomPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetContextKeysForCustomPolicyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetContextKeysForCustomPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetContextKeysForCustomPolicyError {
    fn code(&self) -> Option<&str> {
        GetContextKeysForCustomPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetContextKeysForCustomPolicyError {
    /// Creates a new `GetContextKeysForCustomPolicyError`.
    pub fn new(
        kind: GetContextKeysForCustomPolicyErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetContextKeysForCustomPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetContextKeysForCustomPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetContextKeysForCustomPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetContextKeysForCustomPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetContextKeysForCustomPolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContextKeysForCustomPolicyErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for GetContextKeysForCustomPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetContextKeysForCustomPolicyErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetContextKeysForCustomPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetContextKeysForPrincipalPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetContextKeysForPrincipalPolicyError {
    /// Kind of error that occurred.
    pub kind: GetContextKeysForPrincipalPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetContextKeysForPrincipalPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetContextKeysForPrincipalPolicyErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetContextKeysForPrincipalPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetContextKeysForPrincipalPolicyErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            GetContextKeysForPrincipalPolicyErrorKind::NoSuchEntityException(_inner) => {
                _inner.fmt(f)
            }
            GetContextKeysForPrincipalPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetContextKeysForPrincipalPolicyError {
    fn code(&self) -> Option<&str> {
        GetContextKeysForPrincipalPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetContextKeysForPrincipalPolicyError {
    /// Creates a new `GetContextKeysForPrincipalPolicyError`.
    pub fn new(
        kind: GetContextKeysForPrincipalPolicyErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetContextKeysForPrincipalPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetContextKeysForPrincipalPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetContextKeysForPrincipalPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetContextKeysForPrincipalPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetContextKeysForPrincipalPolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContextKeysForPrincipalPolicyErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContextKeysForPrincipalPolicyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContextKeysForPrincipalPolicyErrorKind::NoSuchEntityException(_)
        )
    }
}
impl std::error::Error for GetContextKeysForPrincipalPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetContextKeysForPrincipalPolicyErrorKind::InvalidInputException(_inner) => {
                Some(_inner)
            }
            GetContextKeysForPrincipalPolicyErrorKind::NoSuchEntityException(_inner) => {
                Some(_inner)
            }
            GetContextKeysForPrincipalPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCredentialReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCredentialReportError {
    /// Kind of error that occurred.
    pub kind: GetCredentialReportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCredentialReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCredentialReportErrorKind {
    /// <p>The request was rejected because the most recent credential report has expired. To
    /// generate a new credential report, use <a>GenerateCredentialReport</a>. For more
    /// information about credential report expiration, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting credential reports</a> in the
    /// <i>IAM User Guide</i>.</p>
    CredentialReportExpiredException(crate::error::CredentialReportExpiredException),
    /// <p>The request was rejected because the credential report does not exist. To generate a
    /// credential report, use <a>GenerateCredentialReport</a>.</p>
    CredentialReportNotPresentException(crate::error::CredentialReportNotPresentException),
    /// <p>The request was rejected because the credential report is still being generated.</p>
    CredentialReportNotReadyException(crate::error::CredentialReportNotReadyException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCredentialReportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCredentialReportErrorKind::CredentialReportExpiredException(_inner) => _inner.fmt(f),
            GetCredentialReportErrorKind::CredentialReportNotPresentException(_inner) => {
                _inner.fmt(f)
            }
            GetCredentialReportErrorKind::CredentialReportNotReadyException(_inner) => {
                _inner.fmt(f)
            }
            GetCredentialReportErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetCredentialReportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCredentialReportError {
    fn code(&self) -> Option<&str> {
        GetCredentialReportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCredentialReportError {
    /// Creates a new `GetCredentialReportError`.
    pub fn new(kind: GetCredentialReportErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCredentialReportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCredentialReportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCredentialReportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCredentialReportErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCredentialReportErrorKind::CredentialReportExpiredException`.
    pub fn is_credential_report_expired_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCredentialReportErrorKind::CredentialReportExpiredException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCredentialReportErrorKind::CredentialReportNotPresentException`.
    pub fn is_credential_report_not_present_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCredentialReportErrorKind::CredentialReportNotPresentException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCredentialReportErrorKind::CredentialReportNotReadyException`.
    pub fn is_credential_report_not_ready_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCredentialReportErrorKind::CredentialReportNotReadyException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCredentialReportErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCredentialReportErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for GetCredentialReportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCredentialReportErrorKind::CredentialReportExpiredException(_inner) => Some(_inner),
            GetCredentialReportErrorKind::CredentialReportNotPresentException(_inner) => {
                Some(_inner)
            }
            GetCredentialReportErrorKind::CredentialReportNotReadyException(_inner) => Some(_inner),
            GetCredentialReportErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetCredentialReportErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetGroupError {
    /// Kind of error that occurred.
    pub kind: GetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetGroupErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetGroupErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            GetGroupErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetGroupError {
    fn code(&self) -> Option<&str> {
        GetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetGroupError {
    /// Creates a new `GetGroupError`.
    pub fn new(kind: GetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetGroupErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(&self.kind, GetGroupErrorKind::NoSuchEntityException(_))
    }
    /// Returns `true` if the error kind is `GetGroupErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, GetGroupErrorKind::ServiceFailureException(_))
    }
}
impl std::error::Error for GetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetGroupErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            GetGroupErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetGroupPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetGroupPolicyError {
    /// Kind of error that occurred.
    pub kind: GetGroupPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetGroupPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetGroupPolicyErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetGroupPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetGroupPolicyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            GetGroupPolicyErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetGroupPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetGroupPolicyError {
    fn code(&self) -> Option<&str> {
        GetGroupPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetGroupPolicyError {
    /// Creates a new `GetGroupPolicyError`.
    pub fn new(kind: GetGroupPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetGroupPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetGroupPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetGroupPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetGroupPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetGroupPolicyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGroupPolicyErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `GetGroupPolicyErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGroupPolicyErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for GetGroupPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetGroupPolicyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            GetGroupPolicyErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetGroupPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetInstanceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetInstanceProfileError {
    /// Kind of error that occurred.
    pub kind: GetInstanceProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetInstanceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetInstanceProfileErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetInstanceProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetInstanceProfileErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            GetInstanceProfileErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetInstanceProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetInstanceProfileError {
    fn code(&self) -> Option<&str> {
        GetInstanceProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetInstanceProfileError {
    /// Creates a new `GetInstanceProfileError`.
    pub fn new(kind: GetInstanceProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetInstanceProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetInstanceProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetInstanceProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetInstanceProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetInstanceProfileErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceProfileErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceProfileErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceProfileErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for GetInstanceProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetInstanceProfileErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            GetInstanceProfileErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetInstanceProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLoginProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLoginProfileError {
    /// Kind of error that occurred.
    pub kind: GetLoginProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLoginProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLoginProfileErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLoginProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLoginProfileErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            GetLoginProfileErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetLoginProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLoginProfileError {
    fn code(&self) -> Option<&str> {
        GetLoginProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLoginProfileError {
    /// Creates a new `GetLoginProfileError`.
    pub fn new(kind: GetLoginProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLoginProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLoginProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLoginProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLoginProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetLoginProfileErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoginProfileErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLoginProfileErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoginProfileErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for GetLoginProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLoginProfileErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            GetLoginProfileErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetLoginProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetOpenIDConnectProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetOpenIDConnectProviderError {
    /// Kind of error that occurred.
    pub kind: GetOpenIDConnectProviderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetOpenIDConnectProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetOpenIDConnectProviderErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetOpenIDConnectProviderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetOpenIDConnectProviderErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetOpenIDConnectProviderErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            GetOpenIDConnectProviderErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetOpenIDConnectProviderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetOpenIDConnectProviderError {
    fn code(&self) -> Option<&str> {
        GetOpenIDConnectProviderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetOpenIDConnectProviderError {
    /// Creates a new `GetOpenIDConnectProviderError`.
    pub fn new(kind: GetOpenIDConnectProviderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetOpenIDConnectProviderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetOpenIDConnectProviderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetOpenIDConnectProviderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetOpenIDConnectProviderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetOpenIDConnectProviderErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOpenIDConnectProviderErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetOpenIDConnectProviderErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOpenIDConnectProviderErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `GetOpenIDConnectProviderErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOpenIDConnectProviderErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for GetOpenIDConnectProviderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetOpenIDConnectProviderErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetOpenIDConnectProviderErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            GetOpenIDConnectProviderErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetOpenIDConnectProviderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetOrganizationsAccessReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetOrganizationsAccessReportError {
    /// Kind of error that occurred.
    pub kind: GetOrganizationsAccessReportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetOrganizationsAccessReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetOrganizationsAccessReportErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetOrganizationsAccessReportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetOrganizationsAccessReportErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            GetOrganizationsAccessReportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetOrganizationsAccessReportError {
    fn code(&self) -> Option<&str> {
        GetOrganizationsAccessReportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetOrganizationsAccessReportError {
    /// Creates a new `GetOrganizationsAccessReportError`.
    pub fn new(kind: GetOrganizationsAccessReportErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetOrganizationsAccessReportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetOrganizationsAccessReportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetOrganizationsAccessReportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetOrganizationsAccessReportErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetOrganizationsAccessReportErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOrganizationsAccessReportErrorKind::NoSuchEntityException(_)
        )
    }
}
impl std::error::Error for GetOrganizationsAccessReportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetOrganizationsAccessReportErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            GetOrganizationsAccessReportErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPolicyError {
    /// Kind of error that occurred.
    pub kind: GetPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPolicyErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPolicyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetPolicyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            GetPolicyErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPolicyError {
    fn code(&self) -> Option<&str> {
        GetPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPolicyError {
    /// Creates a new `GetPolicyError`.
    pub fn new(kind: GetPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetPolicyErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetPolicyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(&self.kind, GetPolicyErrorKind::NoSuchEntityException(_))
    }
    /// Returns `true` if the error kind is `GetPolicyErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, GetPolicyErrorKind::ServiceFailureException(_))
    }
}
impl std::error::Error for GetPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPolicyErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetPolicyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            GetPolicyErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPolicyVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPolicyVersionError {
    /// Kind of error that occurred.
    pub kind: GetPolicyVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPolicyVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPolicyVersionErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPolicyVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPolicyVersionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetPolicyVersionErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            GetPolicyVersionErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetPolicyVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPolicyVersionError {
    fn code(&self) -> Option<&str> {
        GetPolicyVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPolicyVersionError {
    /// Creates a new `GetPolicyVersionError`.
    pub fn new(kind: GetPolicyVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPolicyVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPolicyVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPolicyVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPolicyVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPolicyVersionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPolicyVersionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPolicyVersionErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPolicyVersionErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPolicyVersionErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPolicyVersionErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for GetPolicyVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPolicyVersionErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetPolicyVersionErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            GetPolicyVersionErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetPolicyVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRoleError {
    /// Kind of error that occurred.
    pub kind: GetRoleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRoleErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRoleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRoleErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            GetRoleErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetRoleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRoleError {
    fn code(&self) -> Option<&str> {
        GetRoleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRoleError {
    /// Creates a new `GetRoleError`.
    pub fn new(kind: GetRoleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRoleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRoleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRoleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRoleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRoleErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(&self.kind, GetRoleErrorKind::NoSuchEntityException(_))
    }
    /// Returns `true` if the error kind is `GetRoleErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, GetRoleErrorKind::ServiceFailureException(_))
    }
}
impl std::error::Error for GetRoleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRoleErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            GetRoleErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetRoleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRolePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRolePolicyError {
    /// Kind of error that occurred.
    pub kind: GetRolePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRolePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRolePolicyErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRolePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRolePolicyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            GetRolePolicyErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetRolePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRolePolicyError {
    fn code(&self) -> Option<&str> {
        GetRolePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRolePolicyError {
    /// Creates a new `GetRolePolicyError`.
    pub fn new(kind: GetRolePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRolePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRolePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRolePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRolePolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRolePolicyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(&self.kind, GetRolePolicyErrorKind::NoSuchEntityException(_))
    }
    /// Returns `true` if the error kind is `GetRolePolicyErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRolePolicyErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for GetRolePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRolePolicyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            GetRolePolicyErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetRolePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSAMLProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSAMLProviderError {
    /// Kind of error that occurred.
    pub kind: GetSAMLProviderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSAMLProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSAMLProviderErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSAMLProviderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSAMLProviderErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetSAMLProviderErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            GetSAMLProviderErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetSAMLProviderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSAMLProviderError {
    fn code(&self) -> Option<&str> {
        GetSAMLProviderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSAMLProviderError {
    /// Creates a new `GetSAMLProviderError`.
    pub fn new(kind: GetSAMLProviderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSAMLProviderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSAMLProviderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSAMLProviderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSAMLProviderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSAMLProviderErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSAMLProviderErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSAMLProviderErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSAMLProviderErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSAMLProviderErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSAMLProviderErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for GetSAMLProviderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSAMLProviderErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetSAMLProviderErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            GetSAMLProviderErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetSAMLProviderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetServerCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetServerCertificateError {
    /// Kind of error that occurred.
    pub kind: GetServerCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetServerCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetServerCertificateErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetServerCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetServerCertificateErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            GetServerCertificateErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetServerCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetServerCertificateError {
    fn code(&self) -> Option<&str> {
        GetServerCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetServerCertificateError {
    /// Creates a new `GetServerCertificateError`.
    pub fn new(kind: GetServerCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetServerCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetServerCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetServerCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetServerCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetServerCertificateErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServerCertificateErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServerCertificateErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServerCertificateErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for GetServerCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetServerCertificateErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            GetServerCertificateErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetServerCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetServiceLastAccessedDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetServiceLastAccessedDetailsError {
    /// Kind of error that occurred.
    pub kind: GetServiceLastAccessedDetailsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetServiceLastAccessedDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetServiceLastAccessedDetailsErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetServiceLastAccessedDetailsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetServiceLastAccessedDetailsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetServiceLastAccessedDetailsErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            GetServiceLastAccessedDetailsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetServiceLastAccessedDetailsError {
    fn code(&self) -> Option<&str> {
        GetServiceLastAccessedDetailsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetServiceLastAccessedDetailsError {
    /// Creates a new `GetServiceLastAccessedDetailsError`.
    pub fn new(
        kind: GetServiceLastAccessedDetailsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetServiceLastAccessedDetailsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetServiceLastAccessedDetailsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetServiceLastAccessedDetailsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetServiceLastAccessedDetailsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetServiceLastAccessedDetailsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceLastAccessedDetailsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceLastAccessedDetailsErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceLastAccessedDetailsErrorKind::NoSuchEntityException(_)
        )
    }
}
impl std::error::Error for GetServiceLastAccessedDetailsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetServiceLastAccessedDetailsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetServiceLastAccessedDetailsErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            GetServiceLastAccessedDetailsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetServiceLastAccessedDetailsWithEntities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetServiceLastAccessedDetailsWithEntitiesError {
    /// Kind of error that occurred.
    pub kind: GetServiceLastAccessedDetailsWithEntitiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetServiceLastAccessedDetailsWithEntities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetServiceLastAccessedDetailsWithEntitiesErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetServiceLastAccessedDetailsWithEntitiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetServiceLastAccessedDetailsWithEntitiesErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            GetServiceLastAccessedDetailsWithEntitiesErrorKind::NoSuchEntityException(_inner) => {
                _inner.fmt(f)
            }
            GetServiceLastAccessedDetailsWithEntitiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetServiceLastAccessedDetailsWithEntitiesError {
    fn code(&self) -> Option<&str> {
        GetServiceLastAccessedDetailsWithEntitiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetServiceLastAccessedDetailsWithEntitiesError {
    /// Creates a new `GetServiceLastAccessedDetailsWithEntitiesError`.
    pub fn new(
        kind: GetServiceLastAccessedDetailsWithEntitiesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetServiceLastAccessedDetailsWithEntitiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetServiceLastAccessedDetailsWithEntitiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetServiceLastAccessedDetailsWithEntitiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetServiceLastAccessedDetailsWithEntitiesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetServiceLastAccessedDetailsWithEntitiesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceLastAccessedDetailsWithEntitiesErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceLastAccessedDetailsWithEntitiesErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceLastAccessedDetailsWithEntitiesErrorKind::NoSuchEntityException(_)
        )
    }
}
impl std::error::Error for GetServiceLastAccessedDetailsWithEntitiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetServiceLastAccessedDetailsWithEntitiesErrorKind::InvalidInputException(_inner) => {
                Some(_inner)
            }
            GetServiceLastAccessedDetailsWithEntitiesErrorKind::NoSuchEntityException(_inner) => {
                Some(_inner)
            }
            GetServiceLastAccessedDetailsWithEntitiesErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetServiceLinkedRoleDeletionStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetServiceLinkedRoleDeletionStatusError {
    /// Kind of error that occurred.
    pub kind: GetServiceLinkedRoleDeletionStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetServiceLinkedRoleDeletionStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetServiceLinkedRoleDeletionStatusErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetServiceLinkedRoleDeletionStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetServiceLinkedRoleDeletionStatusErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            GetServiceLinkedRoleDeletionStatusErrorKind::NoSuchEntityException(_inner) => {
                _inner.fmt(f)
            }
            GetServiceLinkedRoleDeletionStatusErrorKind::ServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            GetServiceLinkedRoleDeletionStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetServiceLinkedRoleDeletionStatusError {
    fn code(&self) -> Option<&str> {
        GetServiceLinkedRoleDeletionStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetServiceLinkedRoleDeletionStatusError {
    /// Creates a new `GetServiceLinkedRoleDeletionStatusError`.
    pub fn new(
        kind: GetServiceLinkedRoleDeletionStatusErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetServiceLinkedRoleDeletionStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetServiceLinkedRoleDeletionStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetServiceLinkedRoleDeletionStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetServiceLinkedRoleDeletionStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetServiceLinkedRoleDeletionStatusErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceLinkedRoleDeletionStatusErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceLinkedRoleDeletionStatusErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceLinkedRoleDeletionStatusErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceLinkedRoleDeletionStatusErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceLinkedRoleDeletionStatusErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for GetServiceLinkedRoleDeletionStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetServiceLinkedRoleDeletionStatusErrorKind::InvalidInputException(_inner) => {
                Some(_inner)
            }
            GetServiceLinkedRoleDeletionStatusErrorKind::NoSuchEntityException(_inner) => {
                Some(_inner)
            }
            GetServiceLinkedRoleDeletionStatusErrorKind::ServiceFailureException(_inner) => {
                Some(_inner)
            }
            GetServiceLinkedRoleDeletionStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSSHPublicKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSSHPublicKeyError {
    /// Kind of error that occurred.
    pub kind: GetSSHPublicKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSSHPublicKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSSHPublicKeyErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request was rejected because the public key encoding format is unsupported or
    /// unrecognized.</p>
    UnrecognizedPublicKeyEncodingException(crate::error::UnrecognizedPublicKeyEncodingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSSHPublicKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSSHPublicKeyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            GetSSHPublicKeyErrorKind::UnrecognizedPublicKeyEncodingException(_inner) => {
                _inner.fmt(f)
            }
            GetSSHPublicKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSSHPublicKeyError {
    fn code(&self) -> Option<&str> {
        GetSSHPublicKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSSHPublicKeyError {
    /// Creates a new `GetSSHPublicKeyError`.
    pub fn new(kind: GetSSHPublicKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSSHPublicKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSSHPublicKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSSHPublicKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSSHPublicKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSSHPublicKeyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSSHPublicKeyErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSSHPublicKeyErrorKind::UnrecognizedPublicKeyEncodingException`.
    pub fn is_unrecognized_public_key_encoding_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSSHPublicKeyErrorKind::UnrecognizedPublicKeyEncodingException(_)
        )
    }
}
impl std::error::Error for GetSSHPublicKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSSHPublicKeyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            GetSSHPublicKeyErrorKind::UnrecognizedPublicKeyEncodingException(_inner) => {
                Some(_inner)
            }
            GetSSHPublicKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetUserError {
    /// Kind of error that occurred.
    pub kind: GetUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetUserErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetUserErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            GetUserErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetUserError {
    fn code(&self) -> Option<&str> {
        GetUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetUserError {
    /// Creates a new `GetUserError`.
    pub fn new(kind: GetUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetUserErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetUserErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(&self.kind, GetUserErrorKind::NoSuchEntityException(_))
    }
    /// Returns `true` if the error kind is `GetUserErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, GetUserErrorKind::ServiceFailureException(_))
    }
}
impl std::error::Error for GetUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetUserErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            GetUserErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetUserPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetUserPolicyError {
    /// Kind of error that occurred.
    pub kind: GetUserPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetUserPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetUserPolicyErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetUserPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetUserPolicyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            GetUserPolicyErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            GetUserPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetUserPolicyError {
    fn code(&self) -> Option<&str> {
        GetUserPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetUserPolicyError {
    /// Creates a new `GetUserPolicyError`.
    pub fn new(kind: GetUserPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetUserPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetUserPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetUserPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetUserPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetUserPolicyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(&self.kind, GetUserPolicyErrorKind::NoSuchEntityException(_))
    }
    /// Returns `true` if the error kind is `GetUserPolicyErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUserPolicyErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for GetUserPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetUserPolicyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            GetUserPolicyErrorKind::ServiceFailureException(_inner) => Some(_inner),
            GetUserPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAccessKeys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAccessKeysError {
    /// Kind of error that occurred.
    pub kind: ListAccessKeysErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAccessKeys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAccessKeysErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAccessKeysError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAccessKeysErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ListAccessKeysErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListAccessKeysErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAccessKeysError {
    fn code(&self) -> Option<&str> {
        ListAccessKeysError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAccessKeysError {
    /// Creates a new `ListAccessKeysError`.
    pub fn new(kind: ListAccessKeysErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAccessKeysError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAccessKeysErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAccessKeysError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAccessKeysErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAccessKeysErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccessKeysErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAccessKeysErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccessKeysErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for ListAccessKeysError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAccessKeysErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ListAccessKeysErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListAccessKeysErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAccountAliases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAccountAliasesError {
    /// Kind of error that occurred.
    pub kind: ListAccountAliasesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAccountAliases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAccountAliasesErrorKind {
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAccountAliasesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAccountAliasesErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListAccountAliasesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAccountAliasesError {
    fn code(&self) -> Option<&str> {
        ListAccountAliasesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAccountAliasesError {
    /// Creates a new `ListAccountAliasesError`.
    pub fn new(kind: ListAccountAliasesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAccountAliasesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAccountAliasesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAccountAliasesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAccountAliasesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAccountAliasesErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountAliasesErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for ListAccountAliasesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAccountAliasesErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListAccountAliasesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAttachedGroupPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAttachedGroupPoliciesError {
    /// Kind of error that occurred.
    pub kind: ListAttachedGroupPoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAttachedGroupPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAttachedGroupPoliciesErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAttachedGroupPoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAttachedGroupPoliciesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListAttachedGroupPoliciesErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ListAttachedGroupPoliciesErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListAttachedGroupPoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAttachedGroupPoliciesError {
    fn code(&self) -> Option<&str> {
        ListAttachedGroupPoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAttachedGroupPoliciesError {
    /// Creates a new `ListAttachedGroupPoliciesError`.
    pub fn new(kind: ListAttachedGroupPoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAttachedGroupPoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAttachedGroupPoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAttachedGroupPoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAttachedGroupPoliciesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAttachedGroupPoliciesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttachedGroupPoliciesErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAttachedGroupPoliciesErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttachedGroupPoliciesErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAttachedGroupPoliciesErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttachedGroupPoliciesErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for ListAttachedGroupPoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAttachedGroupPoliciesErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListAttachedGroupPoliciesErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ListAttachedGroupPoliciesErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListAttachedGroupPoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAttachedRolePolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAttachedRolePoliciesError {
    /// Kind of error that occurred.
    pub kind: ListAttachedRolePoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAttachedRolePolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAttachedRolePoliciesErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAttachedRolePoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAttachedRolePoliciesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListAttachedRolePoliciesErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ListAttachedRolePoliciesErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListAttachedRolePoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAttachedRolePoliciesError {
    fn code(&self) -> Option<&str> {
        ListAttachedRolePoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAttachedRolePoliciesError {
    /// Creates a new `ListAttachedRolePoliciesError`.
    pub fn new(kind: ListAttachedRolePoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAttachedRolePoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAttachedRolePoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAttachedRolePoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAttachedRolePoliciesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAttachedRolePoliciesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttachedRolePoliciesErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAttachedRolePoliciesErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttachedRolePoliciesErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAttachedRolePoliciesErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttachedRolePoliciesErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for ListAttachedRolePoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAttachedRolePoliciesErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListAttachedRolePoliciesErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ListAttachedRolePoliciesErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListAttachedRolePoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAttachedUserPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAttachedUserPoliciesError {
    /// Kind of error that occurred.
    pub kind: ListAttachedUserPoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAttachedUserPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAttachedUserPoliciesErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAttachedUserPoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAttachedUserPoliciesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListAttachedUserPoliciesErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ListAttachedUserPoliciesErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListAttachedUserPoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAttachedUserPoliciesError {
    fn code(&self) -> Option<&str> {
        ListAttachedUserPoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAttachedUserPoliciesError {
    /// Creates a new `ListAttachedUserPoliciesError`.
    pub fn new(kind: ListAttachedUserPoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAttachedUserPoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAttachedUserPoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAttachedUserPoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAttachedUserPoliciesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAttachedUserPoliciesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttachedUserPoliciesErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAttachedUserPoliciesErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttachedUserPoliciesErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAttachedUserPoliciesErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAttachedUserPoliciesErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for ListAttachedUserPoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAttachedUserPoliciesErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListAttachedUserPoliciesErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ListAttachedUserPoliciesErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListAttachedUserPoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEntitiesForPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEntitiesForPolicyError {
    /// Kind of error that occurred.
    pub kind: ListEntitiesForPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEntitiesForPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEntitiesForPolicyErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEntitiesForPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEntitiesForPolicyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListEntitiesForPolicyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ListEntitiesForPolicyErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListEntitiesForPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEntitiesForPolicyError {
    fn code(&self) -> Option<&str> {
        ListEntitiesForPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEntitiesForPolicyError {
    /// Creates a new `ListEntitiesForPolicyError`.
    pub fn new(kind: ListEntitiesForPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEntitiesForPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEntitiesForPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEntitiesForPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEntitiesForPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEntitiesForPolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEntitiesForPolicyErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEntitiesForPolicyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEntitiesForPolicyErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEntitiesForPolicyErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEntitiesForPolicyErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for ListEntitiesForPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEntitiesForPolicyErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListEntitiesForPolicyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ListEntitiesForPolicyErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListEntitiesForPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListGroupPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListGroupPoliciesError {
    /// Kind of error that occurred.
    pub kind: ListGroupPoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListGroupPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListGroupPoliciesErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListGroupPoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListGroupPoliciesErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ListGroupPoliciesErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListGroupPoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListGroupPoliciesError {
    fn code(&self) -> Option<&str> {
        ListGroupPoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListGroupPoliciesError {
    /// Creates a new `ListGroupPoliciesError`.
    pub fn new(kind: ListGroupPoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListGroupPoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListGroupPoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListGroupPoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListGroupPoliciesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListGroupPoliciesErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupPoliciesErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGroupPoliciesErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupPoliciesErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for ListGroupPoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListGroupPoliciesErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ListGroupPoliciesErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListGroupPoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListGroupsError {
    /// Kind of error that occurred.
    pub kind: ListGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListGroupsErrorKind {
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListGroupsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListGroupsError {
    fn code(&self) -> Option<&str> {
        ListGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListGroupsError {
    /// Creates a new `ListGroupsError`.
    pub fn new(kind: ListGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListGroupsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListGroupsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, ListGroupsErrorKind::ServiceFailureException(_))
    }
}
impl std::error::Error for ListGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListGroupsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListGroupsForUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListGroupsForUserError {
    /// Kind of error that occurred.
    pub kind: ListGroupsForUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListGroupsForUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListGroupsForUserErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListGroupsForUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListGroupsForUserErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ListGroupsForUserErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListGroupsForUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListGroupsForUserError {
    fn code(&self) -> Option<&str> {
        ListGroupsForUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListGroupsForUserError {
    /// Creates a new `ListGroupsForUserError`.
    pub fn new(kind: ListGroupsForUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListGroupsForUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListGroupsForUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListGroupsForUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListGroupsForUserErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListGroupsForUserErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupsForUserErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGroupsForUserErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGroupsForUserErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for ListGroupsForUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListGroupsForUserErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ListGroupsForUserErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListGroupsForUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListInstanceProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListInstanceProfilesError {
    /// Kind of error that occurred.
    pub kind: ListInstanceProfilesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListInstanceProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListInstanceProfilesErrorKind {
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListInstanceProfilesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListInstanceProfilesErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListInstanceProfilesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListInstanceProfilesError {
    fn code(&self) -> Option<&str> {
        ListInstanceProfilesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListInstanceProfilesError {
    /// Creates a new `ListInstanceProfilesError`.
    pub fn new(kind: ListInstanceProfilesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListInstanceProfilesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListInstanceProfilesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListInstanceProfilesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListInstanceProfilesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListInstanceProfilesErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstanceProfilesErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for ListInstanceProfilesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListInstanceProfilesErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListInstanceProfilesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListInstanceProfilesForRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListInstanceProfilesForRoleError {
    /// Kind of error that occurred.
    pub kind: ListInstanceProfilesForRoleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListInstanceProfilesForRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListInstanceProfilesForRoleErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListInstanceProfilesForRoleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListInstanceProfilesForRoleErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ListInstanceProfilesForRoleErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListInstanceProfilesForRoleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListInstanceProfilesForRoleError {
    fn code(&self) -> Option<&str> {
        ListInstanceProfilesForRoleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListInstanceProfilesForRoleError {
    /// Creates a new `ListInstanceProfilesForRoleError`.
    pub fn new(kind: ListInstanceProfilesForRoleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListInstanceProfilesForRoleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListInstanceProfilesForRoleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListInstanceProfilesForRoleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListInstanceProfilesForRoleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListInstanceProfilesForRoleErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstanceProfilesForRoleErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInstanceProfilesForRoleErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstanceProfilesForRoleErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for ListInstanceProfilesForRoleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListInstanceProfilesForRoleErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ListInstanceProfilesForRoleErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListInstanceProfilesForRoleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListInstanceProfileTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListInstanceProfileTagsError {
    /// Kind of error that occurred.
    pub kind: ListInstanceProfileTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListInstanceProfileTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListInstanceProfileTagsErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListInstanceProfileTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListInstanceProfileTagsErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ListInstanceProfileTagsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListInstanceProfileTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListInstanceProfileTagsError {
    fn code(&self) -> Option<&str> {
        ListInstanceProfileTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListInstanceProfileTagsError {
    /// Creates a new `ListInstanceProfileTagsError`.
    pub fn new(kind: ListInstanceProfileTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListInstanceProfileTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListInstanceProfileTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListInstanceProfileTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListInstanceProfileTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListInstanceProfileTagsErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstanceProfileTagsErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInstanceProfileTagsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstanceProfileTagsErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for ListInstanceProfileTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListInstanceProfileTagsErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ListInstanceProfileTagsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListInstanceProfileTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListMFADevices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListMFADevicesError {
    /// Kind of error that occurred.
    pub kind: ListMFADevicesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListMFADevices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListMFADevicesErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListMFADevicesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListMFADevicesErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ListMFADevicesErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListMFADevicesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListMFADevicesError {
    fn code(&self) -> Option<&str> {
        ListMFADevicesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListMFADevicesError {
    /// Creates a new `ListMFADevicesError`.
    pub fn new(kind: ListMFADevicesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListMFADevicesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListMFADevicesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListMFADevicesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListMFADevicesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListMFADevicesErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMFADevicesErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMFADevicesErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMFADevicesErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for ListMFADevicesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListMFADevicesErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ListMFADevicesErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListMFADevicesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListMFADeviceTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListMFADeviceTagsError {
    /// Kind of error that occurred.
    pub kind: ListMFADeviceTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListMFADeviceTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListMFADeviceTagsErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListMFADeviceTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListMFADeviceTagsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListMFADeviceTagsErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ListMFADeviceTagsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListMFADeviceTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListMFADeviceTagsError {
    fn code(&self) -> Option<&str> {
        ListMFADeviceTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListMFADeviceTagsError {
    /// Creates a new `ListMFADeviceTagsError`.
    pub fn new(kind: ListMFADeviceTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListMFADeviceTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListMFADeviceTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListMFADeviceTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListMFADeviceTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListMFADeviceTagsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMFADeviceTagsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMFADeviceTagsErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMFADeviceTagsErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMFADeviceTagsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMFADeviceTagsErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for ListMFADeviceTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListMFADeviceTagsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListMFADeviceTagsErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ListMFADeviceTagsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListMFADeviceTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListOpenIDConnectProviders` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListOpenIDConnectProvidersError {
    /// Kind of error that occurred.
    pub kind: ListOpenIDConnectProvidersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListOpenIDConnectProviders` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListOpenIDConnectProvidersErrorKind {
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListOpenIDConnectProvidersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListOpenIDConnectProvidersErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListOpenIDConnectProvidersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListOpenIDConnectProvidersError {
    fn code(&self) -> Option<&str> {
        ListOpenIDConnectProvidersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListOpenIDConnectProvidersError {
    /// Creates a new `ListOpenIDConnectProvidersError`.
    pub fn new(kind: ListOpenIDConnectProvidersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListOpenIDConnectProvidersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListOpenIDConnectProvidersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListOpenIDConnectProvidersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListOpenIDConnectProvidersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListOpenIDConnectProvidersErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOpenIDConnectProvidersErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for ListOpenIDConnectProvidersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListOpenIDConnectProvidersErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListOpenIDConnectProvidersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListOpenIDConnectProviderTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListOpenIDConnectProviderTagsError {
    /// Kind of error that occurred.
    pub kind: ListOpenIDConnectProviderTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListOpenIDConnectProviderTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListOpenIDConnectProviderTagsErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListOpenIDConnectProviderTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListOpenIDConnectProviderTagsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListOpenIDConnectProviderTagsErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ListOpenIDConnectProviderTagsErrorKind::ServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            ListOpenIDConnectProviderTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListOpenIDConnectProviderTagsError {
    fn code(&self) -> Option<&str> {
        ListOpenIDConnectProviderTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListOpenIDConnectProviderTagsError {
    /// Creates a new `ListOpenIDConnectProviderTagsError`.
    pub fn new(
        kind: ListOpenIDConnectProviderTagsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListOpenIDConnectProviderTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListOpenIDConnectProviderTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListOpenIDConnectProviderTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListOpenIDConnectProviderTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListOpenIDConnectProviderTagsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOpenIDConnectProviderTagsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListOpenIDConnectProviderTagsErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOpenIDConnectProviderTagsErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `ListOpenIDConnectProviderTagsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOpenIDConnectProviderTagsErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for ListOpenIDConnectProviderTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListOpenIDConnectProviderTagsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListOpenIDConnectProviderTagsErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ListOpenIDConnectProviderTagsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListOpenIDConnectProviderTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPoliciesError {
    /// Kind of error that occurred.
    pub kind: ListPoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPoliciesErrorKind {
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPoliciesErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListPoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPoliciesError {
    fn code(&self) -> Option<&str> {
        ListPoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPoliciesError {
    /// Creates a new `ListPoliciesError`.
    pub fn new(kind: ListPoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPoliciesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPoliciesErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPoliciesErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for ListPoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPoliciesErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListPoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPoliciesGrantingServiceAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPoliciesGrantingServiceAccessError {
    /// Kind of error that occurred.
    pub kind: ListPoliciesGrantingServiceAccessErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPoliciesGrantingServiceAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPoliciesGrantingServiceAccessErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPoliciesGrantingServiceAccessError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPoliciesGrantingServiceAccessErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            ListPoliciesGrantingServiceAccessErrorKind::NoSuchEntityException(_inner) => {
                _inner.fmt(f)
            }
            ListPoliciesGrantingServiceAccessErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPoliciesGrantingServiceAccessError {
    fn code(&self) -> Option<&str> {
        ListPoliciesGrantingServiceAccessError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPoliciesGrantingServiceAccessError {
    /// Creates a new `ListPoliciesGrantingServiceAccessError`.
    pub fn new(
        kind: ListPoliciesGrantingServiceAccessErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPoliciesGrantingServiceAccessError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPoliciesGrantingServiceAccessErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPoliciesGrantingServiceAccessError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPoliciesGrantingServiceAccessErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPoliciesGrantingServiceAccessErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPoliciesGrantingServiceAccessErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPoliciesGrantingServiceAccessErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPoliciesGrantingServiceAccessErrorKind::NoSuchEntityException(_)
        )
    }
}
impl std::error::Error for ListPoliciesGrantingServiceAccessError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPoliciesGrantingServiceAccessErrorKind::InvalidInputException(_inner) => {
                Some(_inner)
            }
            ListPoliciesGrantingServiceAccessErrorKind::NoSuchEntityException(_inner) => {
                Some(_inner)
            }
            ListPoliciesGrantingServiceAccessErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPolicyTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPolicyTagsError {
    /// Kind of error that occurred.
    pub kind: ListPolicyTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPolicyTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPolicyTagsErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPolicyTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPolicyTagsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListPolicyTagsErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ListPolicyTagsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListPolicyTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPolicyTagsError {
    fn code(&self) -> Option<&str> {
        ListPolicyTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPolicyTagsError {
    /// Creates a new `ListPolicyTagsError`.
    pub fn new(kind: ListPolicyTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPolicyTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPolicyTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPolicyTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPolicyTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPolicyTagsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPolicyTagsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPolicyTagsErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPolicyTagsErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPolicyTagsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPolicyTagsErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for ListPolicyTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPolicyTagsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListPolicyTagsErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ListPolicyTagsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListPolicyTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPolicyVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPolicyVersionsError {
    /// Kind of error that occurred.
    pub kind: ListPolicyVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPolicyVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPolicyVersionsErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPolicyVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPolicyVersionsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListPolicyVersionsErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ListPolicyVersionsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListPolicyVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPolicyVersionsError {
    fn code(&self) -> Option<&str> {
        ListPolicyVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPolicyVersionsError {
    /// Creates a new `ListPolicyVersionsError`.
    pub fn new(kind: ListPolicyVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPolicyVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPolicyVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPolicyVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPolicyVersionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPolicyVersionsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPolicyVersionsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPolicyVersionsErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPolicyVersionsErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPolicyVersionsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPolicyVersionsErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for ListPolicyVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPolicyVersionsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListPolicyVersionsErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ListPolicyVersionsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListPolicyVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRolePolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRolePoliciesError {
    /// Kind of error that occurred.
    pub kind: ListRolePoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRolePolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRolePoliciesErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRolePoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRolePoliciesErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ListRolePoliciesErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListRolePoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRolePoliciesError {
    fn code(&self) -> Option<&str> {
        ListRolePoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRolePoliciesError {
    /// Creates a new `ListRolePoliciesError`.
    pub fn new(kind: ListRolePoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRolePoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRolePoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRolePoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRolePoliciesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRolePoliciesErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRolePoliciesErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRolePoliciesErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRolePoliciesErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for ListRolePoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRolePoliciesErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ListRolePoliciesErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListRolePoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRoles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRolesError {
    /// Kind of error that occurred.
    pub kind: ListRolesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRoles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRolesErrorKind {
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRolesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRolesErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListRolesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRolesError {
    fn code(&self) -> Option<&str> {
        ListRolesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRolesError {
    /// Creates a new `ListRolesError`.
    pub fn new(kind: ListRolesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRolesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRolesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRolesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRolesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRolesErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, ListRolesErrorKind::ServiceFailureException(_))
    }
}
impl std::error::Error for ListRolesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRolesErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListRolesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRoleTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRoleTagsError {
    /// Kind of error that occurred.
    pub kind: ListRoleTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRoleTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRoleTagsErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRoleTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRoleTagsErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ListRoleTagsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListRoleTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRoleTagsError {
    fn code(&self) -> Option<&str> {
        ListRoleTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRoleTagsError {
    /// Creates a new `ListRoleTagsError`.
    pub fn new(kind: ListRoleTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRoleTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRoleTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRoleTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRoleTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRoleTagsErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(&self.kind, ListRoleTagsErrorKind::NoSuchEntityException(_))
    }
    /// Returns `true` if the error kind is `ListRoleTagsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoleTagsErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for ListRoleTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRoleTagsErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ListRoleTagsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListRoleTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSAMLProviders` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSAMLProvidersError {
    /// Kind of error that occurred.
    pub kind: ListSAMLProvidersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSAMLProviders` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSAMLProvidersErrorKind {
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSAMLProvidersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSAMLProvidersErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListSAMLProvidersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSAMLProvidersError {
    fn code(&self) -> Option<&str> {
        ListSAMLProvidersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSAMLProvidersError {
    /// Creates a new `ListSAMLProvidersError`.
    pub fn new(kind: ListSAMLProvidersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSAMLProvidersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSAMLProvidersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSAMLProvidersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSAMLProvidersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSAMLProvidersErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSAMLProvidersErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for ListSAMLProvidersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSAMLProvidersErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListSAMLProvidersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSAMLProviderTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSAMLProviderTagsError {
    /// Kind of error that occurred.
    pub kind: ListSAMLProviderTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSAMLProviderTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSAMLProviderTagsErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSAMLProviderTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSAMLProviderTagsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListSAMLProviderTagsErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ListSAMLProviderTagsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListSAMLProviderTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSAMLProviderTagsError {
    fn code(&self) -> Option<&str> {
        ListSAMLProviderTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSAMLProviderTagsError {
    /// Creates a new `ListSAMLProviderTagsError`.
    pub fn new(kind: ListSAMLProviderTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSAMLProviderTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSAMLProviderTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSAMLProviderTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSAMLProviderTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSAMLProviderTagsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSAMLProviderTagsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSAMLProviderTagsErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSAMLProviderTagsErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSAMLProviderTagsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSAMLProviderTagsErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for ListSAMLProviderTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSAMLProviderTagsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListSAMLProviderTagsErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ListSAMLProviderTagsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListSAMLProviderTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListServerCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListServerCertificatesError {
    /// Kind of error that occurred.
    pub kind: ListServerCertificatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListServerCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListServerCertificatesErrorKind {
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListServerCertificatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListServerCertificatesErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListServerCertificatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListServerCertificatesError {
    fn code(&self) -> Option<&str> {
        ListServerCertificatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListServerCertificatesError {
    /// Creates a new `ListServerCertificatesError`.
    pub fn new(kind: ListServerCertificatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListServerCertificatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListServerCertificatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListServerCertificatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListServerCertificatesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListServerCertificatesErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServerCertificatesErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for ListServerCertificatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListServerCertificatesErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListServerCertificatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListServerCertificateTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListServerCertificateTagsError {
    /// Kind of error that occurred.
    pub kind: ListServerCertificateTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListServerCertificateTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListServerCertificateTagsErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListServerCertificateTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListServerCertificateTagsErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ListServerCertificateTagsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListServerCertificateTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListServerCertificateTagsError {
    fn code(&self) -> Option<&str> {
        ListServerCertificateTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListServerCertificateTagsError {
    /// Creates a new `ListServerCertificateTagsError`.
    pub fn new(kind: ListServerCertificateTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListServerCertificateTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListServerCertificateTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListServerCertificateTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListServerCertificateTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListServerCertificateTagsErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServerCertificateTagsErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServerCertificateTagsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServerCertificateTagsErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for ListServerCertificateTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListServerCertificateTagsErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ListServerCertificateTagsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListServerCertificateTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListServiceSpecificCredentials` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListServiceSpecificCredentialsError {
    /// Kind of error that occurred.
    pub kind: ListServiceSpecificCredentialsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListServiceSpecificCredentials` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListServiceSpecificCredentialsErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The specified service does not support service-specific credentials.</p>
    ServiceNotSupportedException(crate::error::ServiceNotSupportedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListServiceSpecificCredentialsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListServiceSpecificCredentialsErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ListServiceSpecificCredentialsErrorKind::ServiceNotSupportedException(_inner) => {
                _inner.fmt(f)
            }
            ListServiceSpecificCredentialsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListServiceSpecificCredentialsError {
    fn code(&self) -> Option<&str> {
        ListServiceSpecificCredentialsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListServiceSpecificCredentialsError {
    /// Creates a new `ListServiceSpecificCredentialsError`.
    pub fn new(
        kind: ListServiceSpecificCredentialsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListServiceSpecificCredentialsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListServiceSpecificCredentialsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListServiceSpecificCredentialsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListServiceSpecificCredentialsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListServiceSpecificCredentialsErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceSpecificCredentialsErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `ListServiceSpecificCredentialsErrorKind::ServiceNotSupportedException`.
    pub fn is_service_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServiceSpecificCredentialsErrorKind::ServiceNotSupportedException(_)
        )
    }
}
impl std::error::Error for ListServiceSpecificCredentialsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListServiceSpecificCredentialsErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ListServiceSpecificCredentialsErrorKind::ServiceNotSupportedException(_inner) => {
                Some(_inner)
            }
            ListServiceSpecificCredentialsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSigningCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSigningCertificatesError {
    /// Kind of error that occurred.
    pub kind: ListSigningCertificatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSigningCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSigningCertificatesErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSigningCertificatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSigningCertificatesErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ListSigningCertificatesErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListSigningCertificatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSigningCertificatesError {
    fn code(&self) -> Option<&str> {
        ListSigningCertificatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSigningCertificatesError {
    /// Creates a new `ListSigningCertificatesError`.
    pub fn new(kind: ListSigningCertificatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSigningCertificatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSigningCertificatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSigningCertificatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSigningCertificatesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSigningCertificatesErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSigningCertificatesErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSigningCertificatesErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSigningCertificatesErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for ListSigningCertificatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSigningCertificatesErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ListSigningCertificatesErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListSigningCertificatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSSHPublicKeys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSSHPublicKeysError {
    /// Kind of error that occurred.
    pub kind: ListSSHPublicKeysErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSSHPublicKeys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSSHPublicKeysErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSSHPublicKeysError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSSHPublicKeysErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ListSSHPublicKeysErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSSHPublicKeysError {
    fn code(&self) -> Option<&str> {
        ListSSHPublicKeysError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSSHPublicKeysError {
    /// Creates a new `ListSSHPublicKeysError`.
    pub fn new(kind: ListSSHPublicKeysErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSSHPublicKeysError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSSHPublicKeysErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSSHPublicKeysError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSSHPublicKeysErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSSHPublicKeysErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSSHPublicKeysErrorKind::NoSuchEntityException(_)
        )
    }
}
impl std::error::Error for ListSSHPublicKeysError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSSHPublicKeysErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ListSSHPublicKeysErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListUserPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListUserPoliciesError {
    /// Kind of error that occurred.
    pub kind: ListUserPoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListUserPolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListUserPoliciesErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListUserPoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListUserPoliciesErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ListUserPoliciesErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListUserPoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListUserPoliciesError {
    fn code(&self) -> Option<&str> {
        ListUserPoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListUserPoliciesError {
    /// Creates a new `ListUserPoliciesError`.
    pub fn new(kind: ListUserPoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListUserPoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListUserPoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListUserPoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListUserPoliciesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListUserPoliciesErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserPoliciesErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUserPoliciesErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserPoliciesErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for ListUserPoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListUserPoliciesErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ListUserPoliciesErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListUserPoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListUsersError {
    /// Kind of error that occurred.
    pub kind: ListUsersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListUsersErrorKind {
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListUsersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListUsersErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListUsersError {
    fn code(&self) -> Option<&str> {
        ListUsersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListUsersError {
    /// Creates a new `ListUsersError`.
    pub fn new(kind: ListUsersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListUsersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListUsersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListUsersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListUsersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::ServiceFailureException(_))
    }
}
impl std::error::Error for ListUsersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListUsersErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListUsersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListUserTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListUserTagsError {
    /// Kind of error that occurred.
    pub kind: ListUserTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListUserTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListUserTagsErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListUserTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListUserTagsErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ListUserTagsErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ListUserTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListUserTagsError {
    fn code(&self) -> Option<&str> {
        ListUserTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListUserTagsError {
    /// Creates a new `ListUserTagsError`.
    pub fn new(kind: ListUserTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListUserTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListUserTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListUserTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListUserTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListUserTagsErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(&self.kind, ListUserTagsErrorKind::NoSuchEntityException(_))
    }
    /// Returns `true` if the error kind is `ListUserTagsErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserTagsErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for ListUserTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListUserTagsErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ListUserTagsErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ListUserTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListVirtualMFADevices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListVirtualMFADevicesError {
    /// Kind of error that occurred.
    pub kind: ListVirtualMFADevicesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListVirtualMFADevices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListVirtualMFADevicesErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListVirtualMFADevicesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListVirtualMFADevicesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListVirtualMFADevicesError {
    fn code(&self) -> Option<&str> {
        ListVirtualMFADevicesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListVirtualMFADevicesError {
    /// Creates a new `ListVirtualMFADevicesError`.
    pub fn new(kind: ListVirtualMFADevicesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListVirtualMFADevicesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListVirtualMFADevicesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListVirtualMFADevicesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListVirtualMFADevicesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListVirtualMFADevicesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListVirtualMFADevicesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutGroupPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutGroupPolicyError {
    /// Kind of error that occurred.
    pub kind: PutGroupPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutGroupPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutGroupPolicyErrorKind {
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because the policy document was malformed. The error message
    /// describes the specific error.</p>
    MalformedPolicyDocumentException(crate::error::MalformedPolicyDocumentException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutGroupPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutGroupPolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutGroupPolicyErrorKind::MalformedPolicyDocumentException(_inner) => _inner.fmt(f),
            PutGroupPolicyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            PutGroupPolicyErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            PutGroupPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutGroupPolicyError {
    fn code(&self) -> Option<&str> {
        PutGroupPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutGroupPolicyError {
    /// Creates a new `PutGroupPolicyError`.
    pub fn new(kind: PutGroupPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutGroupPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutGroupPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutGroupPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutGroupPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutGroupPolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutGroupPolicyErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutGroupPolicyErrorKind::MalformedPolicyDocumentException`.
    pub fn is_malformed_policy_document_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutGroupPolicyErrorKind::MalformedPolicyDocumentException(_)
        )
    }
    /// Returns `true` if the error kind is `PutGroupPolicyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutGroupPolicyErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `PutGroupPolicyErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutGroupPolicyErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for PutGroupPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutGroupPolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutGroupPolicyErrorKind::MalformedPolicyDocumentException(_inner) => Some(_inner),
            PutGroupPolicyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            PutGroupPolicyErrorKind::ServiceFailureException(_inner) => Some(_inner),
            PutGroupPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutRolePermissionsBoundary` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutRolePermissionsBoundaryError {
    /// Kind of error that occurred.
    pub kind: PutRolePermissionsBoundaryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutRolePermissionsBoundary` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutRolePermissionsBoundaryErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request failed because Amazon Web Services service role policies can only be attached to the
    /// service-linked role for that service.</p>
    PolicyNotAttachableException(crate::error::PolicyNotAttachableException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The request was rejected because only the service that depends on the service-linked role
    /// can modify or delete the role on your behalf. The error message includes the name of the
    /// service that depends on this service-linked role. You must request the change through that
    /// service.</p>
    UnmodifiableEntityException(crate::error::UnmodifiableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutRolePermissionsBoundaryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutRolePermissionsBoundaryErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            PutRolePermissionsBoundaryErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            PutRolePermissionsBoundaryErrorKind::PolicyNotAttachableException(_inner) => {
                _inner.fmt(f)
            }
            PutRolePermissionsBoundaryErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            PutRolePermissionsBoundaryErrorKind::UnmodifiableEntityException(_inner) => {
                _inner.fmt(f)
            }
            PutRolePermissionsBoundaryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutRolePermissionsBoundaryError {
    fn code(&self) -> Option<&str> {
        PutRolePermissionsBoundaryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutRolePermissionsBoundaryError {
    /// Creates a new `PutRolePermissionsBoundaryError`.
    pub fn new(kind: PutRolePermissionsBoundaryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutRolePermissionsBoundaryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutRolePermissionsBoundaryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutRolePermissionsBoundaryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutRolePermissionsBoundaryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutRolePermissionsBoundaryErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRolePermissionsBoundaryErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRolePermissionsBoundaryErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRolePermissionsBoundaryErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRolePermissionsBoundaryErrorKind::PolicyNotAttachableException`.
    pub fn is_policy_not_attachable_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRolePermissionsBoundaryErrorKind::PolicyNotAttachableException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRolePermissionsBoundaryErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRolePermissionsBoundaryErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRolePermissionsBoundaryErrorKind::UnmodifiableEntityException`.
    pub fn is_unmodifiable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRolePermissionsBoundaryErrorKind::UnmodifiableEntityException(_)
        )
    }
}
impl std::error::Error for PutRolePermissionsBoundaryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutRolePermissionsBoundaryErrorKind::InvalidInputException(_inner) => Some(_inner),
            PutRolePermissionsBoundaryErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            PutRolePermissionsBoundaryErrorKind::PolicyNotAttachableException(_inner) => {
                Some(_inner)
            }
            PutRolePermissionsBoundaryErrorKind::ServiceFailureException(_inner) => Some(_inner),
            PutRolePermissionsBoundaryErrorKind::UnmodifiableEntityException(_inner) => {
                Some(_inner)
            }
            PutRolePermissionsBoundaryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutRolePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutRolePolicyError {
    /// Kind of error that occurred.
    pub kind: PutRolePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutRolePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutRolePolicyErrorKind {
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because the policy document was malformed. The error message
    /// describes the specific error.</p>
    MalformedPolicyDocumentException(crate::error::MalformedPolicyDocumentException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The request was rejected because only the service that depends on the service-linked role
    /// can modify or delete the role on your behalf. The error message includes the name of the
    /// service that depends on this service-linked role. You must request the change through that
    /// service.</p>
    UnmodifiableEntityException(crate::error::UnmodifiableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutRolePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutRolePolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutRolePolicyErrorKind::MalformedPolicyDocumentException(_inner) => _inner.fmt(f),
            PutRolePolicyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            PutRolePolicyErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            PutRolePolicyErrorKind::UnmodifiableEntityException(_inner) => _inner.fmt(f),
            PutRolePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutRolePolicyError {
    fn code(&self) -> Option<&str> {
        PutRolePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutRolePolicyError {
    /// Creates a new `PutRolePolicyError`.
    pub fn new(kind: PutRolePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutRolePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutRolePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutRolePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutRolePolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutRolePolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRolePolicyErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRolePolicyErrorKind::MalformedPolicyDocumentException`.
    pub fn is_malformed_policy_document_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRolePolicyErrorKind::MalformedPolicyDocumentException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRolePolicyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(&self.kind, PutRolePolicyErrorKind::NoSuchEntityException(_))
    }
    /// Returns `true` if the error kind is `PutRolePolicyErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRolePolicyErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRolePolicyErrorKind::UnmodifiableEntityException`.
    pub fn is_unmodifiable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRolePolicyErrorKind::UnmodifiableEntityException(_)
        )
    }
}
impl std::error::Error for PutRolePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutRolePolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutRolePolicyErrorKind::MalformedPolicyDocumentException(_inner) => Some(_inner),
            PutRolePolicyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            PutRolePolicyErrorKind::ServiceFailureException(_inner) => Some(_inner),
            PutRolePolicyErrorKind::UnmodifiableEntityException(_inner) => Some(_inner),
            PutRolePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutUserPermissionsBoundary` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutUserPermissionsBoundaryError {
    /// Kind of error that occurred.
    pub kind: PutUserPermissionsBoundaryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutUserPermissionsBoundary` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutUserPermissionsBoundaryErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request failed because Amazon Web Services service role policies can only be attached to the
    /// service-linked role for that service.</p>
    PolicyNotAttachableException(crate::error::PolicyNotAttachableException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutUserPermissionsBoundaryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutUserPermissionsBoundaryErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            PutUserPermissionsBoundaryErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            PutUserPermissionsBoundaryErrorKind::PolicyNotAttachableException(_inner) => {
                _inner.fmt(f)
            }
            PutUserPermissionsBoundaryErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            PutUserPermissionsBoundaryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutUserPermissionsBoundaryError {
    fn code(&self) -> Option<&str> {
        PutUserPermissionsBoundaryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutUserPermissionsBoundaryError {
    /// Creates a new `PutUserPermissionsBoundaryError`.
    pub fn new(kind: PutUserPermissionsBoundaryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutUserPermissionsBoundaryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutUserPermissionsBoundaryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutUserPermissionsBoundaryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutUserPermissionsBoundaryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutUserPermissionsBoundaryErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutUserPermissionsBoundaryErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `PutUserPermissionsBoundaryErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutUserPermissionsBoundaryErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `PutUserPermissionsBoundaryErrorKind::PolicyNotAttachableException`.
    pub fn is_policy_not_attachable_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutUserPermissionsBoundaryErrorKind::PolicyNotAttachableException(_)
        )
    }
    /// Returns `true` if the error kind is `PutUserPermissionsBoundaryErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutUserPermissionsBoundaryErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for PutUserPermissionsBoundaryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutUserPermissionsBoundaryErrorKind::InvalidInputException(_inner) => Some(_inner),
            PutUserPermissionsBoundaryErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            PutUserPermissionsBoundaryErrorKind::PolicyNotAttachableException(_inner) => {
                Some(_inner)
            }
            PutUserPermissionsBoundaryErrorKind::ServiceFailureException(_inner) => Some(_inner),
            PutUserPermissionsBoundaryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutUserPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutUserPolicyError {
    /// Kind of error that occurred.
    pub kind: PutUserPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutUserPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutUserPolicyErrorKind {
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because the policy document was malformed. The error message
    /// describes the specific error.</p>
    MalformedPolicyDocumentException(crate::error::MalformedPolicyDocumentException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutUserPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutUserPolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutUserPolicyErrorKind::MalformedPolicyDocumentException(_inner) => _inner.fmt(f),
            PutUserPolicyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            PutUserPolicyErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            PutUserPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutUserPolicyError {
    fn code(&self) -> Option<&str> {
        PutUserPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutUserPolicyError {
    /// Creates a new `PutUserPolicyError`.
    pub fn new(kind: PutUserPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutUserPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutUserPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutUserPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutUserPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutUserPolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutUserPolicyErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutUserPolicyErrorKind::MalformedPolicyDocumentException`.
    pub fn is_malformed_policy_document_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutUserPolicyErrorKind::MalformedPolicyDocumentException(_)
        )
    }
    /// Returns `true` if the error kind is `PutUserPolicyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(&self.kind, PutUserPolicyErrorKind::NoSuchEntityException(_))
    }
    /// Returns `true` if the error kind is `PutUserPolicyErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutUserPolicyErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for PutUserPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutUserPolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutUserPolicyErrorKind::MalformedPolicyDocumentException(_inner) => Some(_inner),
            PutUserPolicyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            PutUserPolicyErrorKind::ServiceFailureException(_inner) => Some(_inner),
            PutUserPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveClientIDFromOpenIDConnectProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveClientIDFromOpenIDConnectProviderError {
    /// Kind of error that occurred.
    pub kind: RemoveClientIDFromOpenIDConnectProviderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveClientIDFromOpenIDConnectProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveClientIDFromOpenIDConnectProviderErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveClientIDFromOpenIDConnectProviderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveClientIDFromOpenIDConnectProviderErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            RemoveClientIDFromOpenIDConnectProviderErrorKind::NoSuchEntityException(_inner) => {
                _inner.fmt(f)
            }
            RemoveClientIDFromOpenIDConnectProviderErrorKind::ServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            RemoveClientIDFromOpenIDConnectProviderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveClientIDFromOpenIDConnectProviderError {
    fn code(&self) -> Option<&str> {
        RemoveClientIDFromOpenIDConnectProviderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveClientIDFromOpenIDConnectProviderError {
    /// Creates a new `RemoveClientIDFromOpenIDConnectProviderError`.
    pub fn new(
        kind: RemoveClientIDFromOpenIDConnectProviderErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveClientIDFromOpenIDConnectProviderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveClientIDFromOpenIDConnectProviderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveClientIDFromOpenIDConnectProviderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveClientIDFromOpenIDConnectProviderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveClientIDFromOpenIDConnectProviderErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveClientIDFromOpenIDConnectProviderErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveClientIDFromOpenIDConnectProviderErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveClientIDFromOpenIDConnectProviderErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveClientIDFromOpenIDConnectProviderErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveClientIDFromOpenIDConnectProviderErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for RemoveClientIDFromOpenIDConnectProviderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveClientIDFromOpenIDConnectProviderErrorKind::InvalidInputException(_inner) => {
                Some(_inner)
            }
            RemoveClientIDFromOpenIDConnectProviderErrorKind::NoSuchEntityException(_inner) => {
                Some(_inner)
            }
            RemoveClientIDFromOpenIDConnectProviderErrorKind::ServiceFailureException(_inner) => {
                Some(_inner)
            }
            RemoveClientIDFromOpenIDConnectProviderErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `RemoveRoleFromInstanceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveRoleFromInstanceProfileError {
    /// Kind of error that occurred.
    pub kind: RemoveRoleFromInstanceProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveRoleFromInstanceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveRoleFromInstanceProfileErrorKind {
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The request was rejected because only the service that depends on the service-linked role
    /// can modify or delete the role on your behalf. The error message includes the name of the
    /// service that depends on this service-linked role. You must request the change through that
    /// service.</p>
    UnmodifiableEntityException(crate::error::UnmodifiableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveRoleFromInstanceProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveRoleFromInstanceProfileErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            RemoveRoleFromInstanceProfileErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            RemoveRoleFromInstanceProfileErrorKind::ServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            RemoveRoleFromInstanceProfileErrorKind::UnmodifiableEntityException(_inner) => {
                _inner.fmt(f)
            }
            RemoveRoleFromInstanceProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveRoleFromInstanceProfileError {
    fn code(&self) -> Option<&str> {
        RemoveRoleFromInstanceProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveRoleFromInstanceProfileError {
    /// Creates a new `RemoveRoleFromInstanceProfileError`.
    pub fn new(
        kind: RemoveRoleFromInstanceProfileErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveRoleFromInstanceProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveRoleFromInstanceProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveRoleFromInstanceProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveRoleFromInstanceProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveRoleFromInstanceProfileErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveRoleFromInstanceProfileErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveRoleFromInstanceProfileErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveRoleFromInstanceProfileErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveRoleFromInstanceProfileErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveRoleFromInstanceProfileErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveRoleFromInstanceProfileErrorKind::UnmodifiableEntityException`.
    pub fn is_unmodifiable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveRoleFromInstanceProfileErrorKind::UnmodifiableEntityException(_)
        )
    }
}
impl std::error::Error for RemoveRoleFromInstanceProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveRoleFromInstanceProfileErrorKind::LimitExceededException(_inner) => Some(_inner),
            RemoveRoleFromInstanceProfileErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            RemoveRoleFromInstanceProfileErrorKind::ServiceFailureException(_inner) => Some(_inner),
            RemoveRoleFromInstanceProfileErrorKind::UnmodifiableEntityException(_inner) => {
                Some(_inner)
            }
            RemoveRoleFromInstanceProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveUserFromGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveUserFromGroupError {
    /// Kind of error that occurred.
    pub kind: RemoveUserFromGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveUserFromGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveUserFromGroupErrorKind {
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveUserFromGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveUserFromGroupErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            RemoveUserFromGroupErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            RemoveUserFromGroupErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            RemoveUserFromGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveUserFromGroupError {
    fn code(&self) -> Option<&str> {
        RemoveUserFromGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveUserFromGroupError {
    /// Creates a new `RemoveUserFromGroupError`.
    pub fn new(kind: RemoveUserFromGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveUserFromGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveUserFromGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveUserFromGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveUserFromGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveUserFromGroupErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveUserFromGroupErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveUserFromGroupErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveUserFromGroupErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveUserFromGroupErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveUserFromGroupErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for RemoveUserFromGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveUserFromGroupErrorKind::LimitExceededException(_inner) => Some(_inner),
            RemoveUserFromGroupErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            RemoveUserFromGroupErrorKind::ServiceFailureException(_inner) => Some(_inner),
            RemoveUserFromGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResetServiceSpecificCredential` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResetServiceSpecificCredentialError {
    /// Kind of error that occurred.
    pub kind: ResetServiceSpecificCredentialErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResetServiceSpecificCredential` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResetServiceSpecificCredentialErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResetServiceSpecificCredentialError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResetServiceSpecificCredentialErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ResetServiceSpecificCredentialErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResetServiceSpecificCredentialError {
    fn code(&self) -> Option<&str> {
        ResetServiceSpecificCredentialError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResetServiceSpecificCredentialError {
    /// Creates a new `ResetServiceSpecificCredentialError`.
    pub fn new(
        kind: ResetServiceSpecificCredentialErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResetServiceSpecificCredentialError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResetServiceSpecificCredentialErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResetServiceSpecificCredentialError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResetServiceSpecificCredentialErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ResetServiceSpecificCredentialErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetServiceSpecificCredentialErrorKind::NoSuchEntityException(_)
        )
    }
}
impl std::error::Error for ResetServiceSpecificCredentialError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResetServiceSpecificCredentialErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ResetServiceSpecificCredentialErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResyncMFADevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResyncMFADeviceError {
    /// Kind of error that occurred.
    pub kind: ResyncMFADeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResyncMFADevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResyncMFADeviceErrorKind {
    /// <p>The request was rejected because the authentication code was not recognized. The error
    /// message describes the specific error.</p>
    InvalidAuthenticationCodeException(crate::error::InvalidAuthenticationCodeException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResyncMFADeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResyncMFADeviceErrorKind::InvalidAuthenticationCodeException(_inner) => _inner.fmt(f),
            ResyncMFADeviceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ResyncMFADeviceErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            ResyncMFADeviceErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            ResyncMFADeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResyncMFADeviceError {
    fn code(&self) -> Option<&str> {
        ResyncMFADeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResyncMFADeviceError {
    /// Creates a new `ResyncMFADeviceError`.
    pub fn new(kind: ResyncMFADeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResyncMFADeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResyncMFADeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResyncMFADeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResyncMFADeviceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ResyncMFADeviceErrorKind::InvalidAuthenticationCodeException`.
    pub fn is_invalid_authentication_code_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResyncMFADeviceErrorKind::InvalidAuthenticationCodeException(_)
        )
    }
    /// Returns `true` if the error kind is `ResyncMFADeviceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResyncMFADeviceErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ResyncMFADeviceErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResyncMFADeviceErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `ResyncMFADeviceErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResyncMFADeviceErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for ResyncMFADeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResyncMFADeviceErrorKind::InvalidAuthenticationCodeException(_inner) => Some(_inner),
            ResyncMFADeviceErrorKind::LimitExceededException(_inner) => Some(_inner),
            ResyncMFADeviceErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            ResyncMFADeviceErrorKind::ServiceFailureException(_inner) => Some(_inner),
            ResyncMFADeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetDefaultPolicyVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetDefaultPolicyVersionError {
    /// Kind of error that occurred.
    pub kind: SetDefaultPolicyVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetDefaultPolicyVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetDefaultPolicyVersionErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetDefaultPolicyVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetDefaultPolicyVersionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            SetDefaultPolicyVersionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            SetDefaultPolicyVersionErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            SetDefaultPolicyVersionErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            SetDefaultPolicyVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetDefaultPolicyVersionError {
    fn code(&self) -> Option<&str> {
        SetDefaultPolicyVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetDefaultPolicyVersionError {
    /// Creates a new `SetDefaultPolicyVersionError`.
    pub fn new(kind: SetDefaultPolicyVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetDefaultPolicyVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetDefaultPolicyVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetDefaultPolicyVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetDefaultPolicyVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetDefaultPolicyVersionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetDefaultPolicyVersionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `SetDefaultPolicyVersionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetDefaultPolicyVersionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `SetDefaultPolicyVersionErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetDefaultPolicyVersionErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `SetDefaultPolicyVersionErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetDefaultPolicyVersionErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for SetDefaultPolicyVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetDefaultPolicyVersionErrorKind::InvalidInputException(_inner) => Some(_inner),
            SetDefaultPolicyVersionErrorKind::LimitExceededException(_inner) => Some(_inner),
            SetDefaultPolicyVersionErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            SetDefaultPolicyVersionErrorKind::ServiceFailureException(_inner) => Some(_inner),
            SetDefaultPolicyVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetSecurityTokenServicePreferences` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetSecurityTokenServicePreferencesError {
    /// Kind of error that occurred.
    pub kind: SetSecurityTokenServicePreferencesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetSecurityTokenServicePreferences` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetSecurityTokenServicePreferencesErrorKind {
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetSecurityTokenServicePreferencesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetSecurityTokenServicePreferencesErrorKind::ServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            SetSecurityTokenServicePreferencesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetSecurityTokenServicePreferencesError {
    fn code(&self) -> Option<&str> {
        SetSecurityTokenServicePreferencesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetSecurityTokenServicePreferencesError {
    /// Creates a new `SetSecurityTokenServicePreferencesError`.
    pub fn new(
        kind: SetSecurityTokenServicePreferencesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetSecurityTokenServicePreferencesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetSecurityTokenServicePreferencesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetSecurityTokenServicePreferencesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetSecurityTokenServicePreferencesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetSecurityTokenServicePreferencesErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetSecurityTokenServicePreferencesErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for SetSecurityTokenServicePreferencesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetSecurityTokenServicePreferencesErrorKind::ServiceFailureException(_inner) => {
                Some(_inner)
            }
            SetSecurityTokenServicePreferencesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SimulateCustomPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SimulateCustomPolicyError {
    /// Kind of error that occurred.
    pub kind: SimulateCustomPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SimulateCustomPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SimulateCustomPolicyErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request failed because a provided policy could not be successfully evaluated. An
    /// additional detailed message indicates the source of the failure.</p>
    PolicyEvaluationException(crate::error::PolicyEvaluationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SimulateCustomPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SimulateCustomPolicyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            SimulateCustomPolicyErrorKind::PolicyEvaluationException(_inner) => _inner.fmt(f),
            SimulateCustomPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SimulateCustomPolicyError {
    fn code(&self) -> Option<&str> {
        SimulateCustomPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SimulateCustomPolicyError {
    /// Creates a new `SimulateCustomPolicyError`.
    pub fn new(kind: SimulateCustomPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SimulateCustomPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SimulateCustomPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SimulateCustomPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SimulateCustomPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SimulateCustomPolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            SimulateCustomPolicyErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `SimulateCustomPolicyErrorKind::PolicyEvaluationException`.
    pub fn is_policy_evaluation_exception(&self) -> bool {
        matches!(
            &self.kind,
            SimulateCustomPolicyErrorKind::PolicyEvaluationException(_)
        )
    }
}
impl std::error::Error for SimulateCustomPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SimulateCustomPolicyErrorKind::InvalidInputException(_inner) => Some(_inner),
            SimulateCustomPolicyErrorKind::PolicyEvaluationException(_inner) => Some(_inner),
            SimulateCustomPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SimulatePrincipalPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SimulatePrincipalPolicyError {
    /// Kind of error that occurred.
    pub kind: SimulatePrincipalPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SimulatePrincipalPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SimulatePrincipalPolicyErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request failed because a provided policy could not be successfully evaluated. An
    /// additional detailed message indicates the source of the failure.</p>
    PolicyEvaluationException(crate::error::PolicyEvaluationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SimulatePrincipalPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SimulatePrincipalPolicyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            SimulatePrincipalPolicyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            SimulatePrincipalPolicyErrorKind::PolicyEvaluationException(_inner) => _inner.fmt(f),
            SimulatePrincipalPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SimulatePrincipalPolicyError {
    fn code(&self) -> Option<&str> {
        SimulatePrincipalPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SimulatePrincipalPolicyError {
    /// Creates a new `SimulatePrincipalPolicyError`.
    pub fn new(kind: SimulatePrincipalPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SimulatePrincipalPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SimulatePrincipalPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SimulatePrincipalPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SimulatePrincipalPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SimulatePrincipalPolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            SimulatePrincipalPolicyErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `SimulatePrincipalPolicyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            SimulatePrincipalPolicyErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `SimulatePrincipalPolicyErrorKind::PolicyEvaluationException`.
    pub fn is_policy_evaluation_exception(&self) -> bool {
        matches!(
            &self.kind,
            SimulatePrincipalPolicyErrorKind::PolicyEvaluationException(_)
        )
    }
}
impl std::error::Error for SimulatePrincipalPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SimulatePrincipalPolicyErrorKind::InvalidInputException(_inner) => Some(_inner),
            SimulatePrincipalPolicyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            SimulatePrincipalPolicyErrorKind::PolicyEvaluationException(_inner) => Some(_inner),
            SimulatePrincipalPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagInstanceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagInstanceProfileError {
    /// Kind of error that occurred.
    pub kind: TagInstanceProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagInstanceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagInstanceProfileErrorKind {
    /// <p>The request was rejected because multiple requests to change this object were submitted
    /// simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagInstanceProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagInstanceProfileErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            TagInstanceProfileErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            TagInstanceProfileErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            TagInstanceProfileErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            TagInstanceProfileErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            TagInstanceProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagInstanceProfileError {
    fn code(&self) -> Option<&str> {
        TagInstanceProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagInstanceProfileError {
    /// Creates a new `TagInstanceProfileError`.
    pub fn new(kind: TagInstanceProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagInstanceProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagInstanceProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagInstanceProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagInstanceProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagInstanceProfileErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagInstanceProfileErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `TagInstanceProfileErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagInstanceProfileErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `TagInstanceProfileErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagInstanceProfileErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `TagInstanceProfileErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagInstanceProfileErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `TagInstanceProfileErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagInstanceProfileErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for TagInstanceProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagInstanceProfileErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            TagInstanceProfileErrorKind::InvalidInputException(_inner) => Some(_inner),
            TagInstanceProfileErrorKind::LimitExceededException(_inner) => Some(_inner),
            TagInstanceProfileErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            TagInstanceProfileErrorKind::ServiceFailureException(_inner) => Some(_inner),
            TagInstanceProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagMFADevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagMFADeviceError {
    /// Kind of error that occurred.
    pub kind: TagMFADeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagMFADevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagMFADeviceErrorKind {
    /// <p>The request was rejected because multiple requests to change this object were submitted
    /// simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagMFADeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagMFADeviceErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            TagMFADeviceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            TagMFADeviceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            TagMFADeviceErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            TagMFADeviceErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            TagMFADeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagMFADeviceError {
    fn code(&self) -> Option<&str> {
        TagMFADeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagMFADeviceError {
    /// Creates a new `TagMFADeviceError`.
    pub fn new(kind: TagMFADeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagMFADeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagMFADeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagMFADeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagMFADeviceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagMFADeviceErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagMFADeviceErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `TagMFADeviceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, TagMFADeviceErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `TagMFADeviceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, TagMFADeviceErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `TagMFADeviceErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(&self.kind, TagMFADeviceErrorKind::NoSuchEntityException(_))
    }
    /// Returns `true` if the error kind is `TagMFADeviceErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagMFADeviceErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for TagMFADeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagMFADeviceErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            TagMFADeviceErrorKind::InvalidInputException(_inner) => Some(_inner),
            TagMFADeviceErrorKind::LimitExceededException(_inner) => Some(_inner),
            TagMFADeviceErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            TagMFADeviceErrorKind::ServiceFailureException(_inner) => Some(_inner),
            TagMFADeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagOpenIDConnectProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagOpenIDConnectProviderError {
    /// Kind of error that occurred.
    pub kind: TagOpenIDConnectProviderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagOpenIDConnectProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagOpenIDConnectProviderErrorKind {
    /// <p>The request was rejected because multiple requests to change this object were submitted
    /// simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagOpenIDConnectProviderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagOpenIDConnectProviderErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            TagOpenIDConnectProviderErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            TagOpenIDConnectProviderErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            TagOpenIDConnectProviderErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            TagOpenIDConnectProviderErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            TagOpenIDConnectProviderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagOpenIDConnectProviderError {
    fn code(&self) -> Option<&str> {
        TagOpenIDConnectProviderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagOpenIDConnectProviderError {
    /// Creates a new `TagOpenIDConnectProviderError`.
    pub fn new(kind: TagOpenIDConnectProviderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagOpenIDConnectProviderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagOpenIDConnectProviderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagOpenIDConnectProviderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagOpenIDConnectProviderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagOpenIDConnectProviderErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagOpenIDConnectProviderErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `TagOpenIDConnectProviderErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagOpenIDConnectProviderErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `TagOpenIDConnectProviderErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagOpenIDConnectProviderErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `TagOpenIDConnectProviderErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagOpenIDConnectProviderErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `TagOpenIDConnectProviderErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagOpenIDConnectProviderErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for TagOpenIDConnectProviderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagOpenIDConnectProviderErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            TagOpenIDConnectProviderErrorKind::InvalidInputException(_inner) => Some(_inner),
            TagOpenIDConnectProviderErrorKind::LimitExceededException(_inner) => Some(_inner),
            TagOpenIDConnectProviderErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            TagOpenIDConnectProviderErrorKind::ServiceFailureException(_inner) => Some(_inner),
            TagOpenIDConnectProviderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagPolicyError {
    /// Kind of error that occurred.
    pub kind: TagPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagPolicyErrorKind {
    /// <p>The request was rejected because multiple requests to change this object were submitted
    /// simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagPolicyErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            TagPolicyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            TagPolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            TagPolicyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            TagPolicyErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            TagPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagPolicyError {
    fn code(&self) -> Option<&str> {
        TagPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagPolicyError {
    /// Creates a new `TagPolicyError`.
    pub fn new(kind: TagPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagPolicyErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagPolicyErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `TagPolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, TagPolicyErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `TagPolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, TagPolicyErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `TagPolicyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(&self.kind, TagPolicyErrorKind::NoSuchEntityException(_))
    }
    /// Returns `true` if the error kind is `TagPolicyErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, TagPolicyErrorKind::ServiceFailureException(_))
    }
}
impl std::error::Error for TagPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagPolicyErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            TagPolicyErrorKind::InvalidInputException(_inner) => Some(_inner),
            TagPolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            TagPolicyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            TagPolicyErrorKind::ServiceFailureException(_inner) => Some(_inner),
            TagPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagRoleError {
    /// Kind of error that occurred.
    pub kind: TagRoleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagRoleErrorKind {
    /// <p>The request was rejected because multiple requests to change this object were submitted
    /// simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagRoleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagRoleErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            TagRoleErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            TagRoleErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            TagRoleErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            TagRoleErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            TagRoleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagRoleError {
    fn code(&self) -> Option<&str> {
        TagRoleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagRoleError {
    /// Creates a new `TagRoleError`.
    pub fn new(kind: TagRoleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagRoleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagRoleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagRoleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagRoleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagRoleErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagRoleErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `TagRoleErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, TagRoleErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `TagRoleErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, TagRoleErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `TagRoleErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(&self.kind, TagRoleErrorKind::NoSuchEntityException(_))
    }
    /// Returns `true` if the error kind is `TagRoleErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, TagRoleErrorKind::ServiceFailureException(_))
    }
}
impl std::error::Error for TagRoleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagRoleErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            TagRoleErrorKind::InvalidInputException(_inner) => Some(_inner),
            TagRoleErrorKind::LimitExceededException(_inner) => Some(_inner),
            TagRoleErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            TagRoleErrorKind::ServiceFailureException(_inner) => Some(_inner),
            TagRoleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagSAMLProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagSAMLProviderError {
    /// Kind of error that occurred.
    pub kind: TagSAMLProviderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagSAMLProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagSAMLProviderErrorKind {
    /// <p>The request was rejected because multiple requests to change this object were submitted
    /// simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagSAMLProviderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagSAMLProviderErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            TagSAMLProviderErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            TagSAMLProviderErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            TagSAMLProviderErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            TagSAMLProviderErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            TagSAMLProviderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagSAMLProviderError {
    fn code(&self) -> Option<&str> {
        TagSAMLProviderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagSAMLProviderError {
    /// Creates a new `TagSAMLProviderError`.
    pub fn new(kind: TagSAMLProviderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagSAMLProviderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagSAMLProviderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagSAMLProviderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagSAMLProviderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagSAMLProviderErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagSAMLProviderErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `TagSAMLProviderErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagSAMLProviderErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `TagSAMLProviderErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagSAMLProviderErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `TagSAMLProviderErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagSAMLProviderErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `TagSAMLProviderErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagSAMLProviderErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for TagSAMLProviderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagSAMLProviderErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            TagSAMLProviderErrorKind::InvalidInputException(_inner) => Some(_inner),
            TagSAMLProviderErrorKind::LimitExceededException(_inner) => Some(_inner),
            TagSAMLProviderErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            TagSAMLProviderErrorKind::ServiceFailureException(_inner) => Some(_inner),
            TagSAMLProviderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagServerCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagServerCertificateError {
    /// Kind of error that occurred.
    pub kind: TagServerCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagServerCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagServerCertificateErrorKind {
    /// <p>The request was rejected because multiple requests to change this object were submitted
    /// simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagServerCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagServerCertificateErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            TagServerCertificateErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            TagServerCertificateErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            TagServerCertificateErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            TagServerCertificateErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            TagServerCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagServerCertificateError {
    fn code(&self) -> Option<&str> {
        TagServerCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagServerCertificateError {
    /// Creates a new `TagServerCertificateError`.
    pub fn new(kind: TagServerCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagServerCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagServerCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagServerCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagServerCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagServerCertificateErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagServerCertificateErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `TagServerCertificateErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagServerCertificateErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `TagServerCertificateErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagServerCertificateErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `TagServerCertificateErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagServerCertificateErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `TagServerCertificateErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagServerCertificateErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for TagServerCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagServerCertificateErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            TagServerCertificateErrorKind::InvalidInputException(_inner) => Some(_inner),
            TagServerCertificateErrorKind::LimitExceededException(_inner) => Some(_inner),
            TagServerCertificateErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            TagServerCertificateErrorKind::ServiceFailureException(_inner) => Some(_inner),
            TagServerCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagUserError {
    /// Kind of error that occurred.
    pub kind: TagUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagUserErrorKind {
    /// <p>The request was rejected because multiple requests to change this object were submitted
    /// simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagUserErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            TagUserErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            TagUserErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            TagUserErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            TagUserErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            TagUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagUserError {
    fn code(&self) -> Option<&str> {
        TagUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagUserError {
    /// Creates a new `TagUserError`.
    pub fn new(kind: TagUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagUserErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagUserErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagUserErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `TagUserErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, TagUserErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `TagUserErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, TagUserErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `TagUserErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(&self.kind, TagUserErrorKind::NoSuchEntityException(_))
    }
    /// Returns `true` if the error kind is `TagUserErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, TagUserErrorKind::ServiceFailureException(_))
    }
}
impl std::error::Error for TagUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagUserErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            TagUserErrorKind::InvalidInputException(_inner) => Some(_inner),
            TagUserErrorKind::LimitExceededException(_inner) => Some(_inner),
            TagUserErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            TagUserErrorKind::ServiceFailureException(_inner) => Some(_inner),
            TagUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagInstanceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagInstanceProfileError {
    /// Kind of error that occurred.
    pub kind: UntagInstanceProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagInstanceProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagInstanceProfileErrorKind {
    /// <p>The request was rejected because multiple requests to change this object were submitted
    /// simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagInstanceProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagInstanceProfileErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UntagInstanceProfileErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UntagInstanceProfileErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            UntagInstanceProfileErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            UntagInstanceProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagInstanceProfileError {
    fn code(&self) -> Option<&str> {
        UntagInstanceProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagInstanceProfileError {
    /// Creates a new `UntagInstanceProfileError`.
    pub fn new(kind: UntagInstanceProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagInstanceProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagInstanceProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagInstanceProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagInstanceProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagInstanceProfileErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagInstanceProfileErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagInstanceProfileErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagInstanceProfileErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagInstanceProfileErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagInstanceProfileErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagInstanceProfileErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagInstanceProfileErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for UntagInstanceProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagInstanceProfileErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UntagInstanceProfileErrorKind::InvalidInputException(_inner) => Some(_inner),
            UntagInstanceProfileErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            UntagInstanceProfileErrorKind::ServiceFailureException(_inner) => Some(_inner),
            UntagInstanceProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagMFADevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagMFADeviceError {
    /// Kind of error that occurred.
    pub kind: UntagMFADeviceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagMFADevice` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagMFADeviceErrorKind {
    /// <p>The request was rejected because multiple requests to change this object were submitted
    /// simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagMFADeviceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagMFADeviceErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UntagMFADeviceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UntagMFADeviceErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            UntagMFADeviceErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            UntagMFADeviceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagMFADeviceError {
    fn code(&self) -> Option<&str> {
        UntagMFADeviceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagMFADeviceError {
    /// Creates a new `UntagMFADeviceError`.
    pub fn new(kind: UntagMFADeviceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagMFADeviceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagMFADeviceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagMFADeviceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagMFADeviceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagMFADeviceErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagMFADeviceErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagMFADeviceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagMFADeviceErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagMFADeviceErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagMFADeviceErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagMFADeviceErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagMFADeviceErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for UntagMFADeviceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagMFADeviceErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UntagMFADeviceErrorKind::InvalidInputException(_inner) => Some(_inner),
            UntagMFADeviceErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            UntagMFADeviceErrorKind::ServiceFailureException(_inner) => Some(_inner),
            UntagMFADeviceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagOpenIDConnectProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagOpenIDConnectProviderError {
    /// Kind of error that occurred.
    pub kind: UntagOpenIDConnectProviderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagOpenIDConnectProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagOpenIDConnectProviderErrorKind {
    /// <p>The request was rejected because multiple requests to change this object were submitted
    /// simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagOpenIDConnectProviderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagOpenIDConnectProviderErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            UntagOpenIDConnectProviderErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UntagOpenIDConnectProviderErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            UntagOpenIDConnectProviderErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            UntagOpenIDConnectProviderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagOpenIDConnectProviderError {
    fn code(&self) -> Option<&str> {
        UntagOpenIDConnectProviderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagOpenIDConnectProviderError {
    /// Creates a new `UntagOpenIDConnectProviderError`.
    pub fn new(kind: UntagOpenIDConnectProviderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagOpenIDConnectProviderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagOpenIDConnectProviderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagOpenIDConnectProviderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagOpenIDConnectProviderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagOpenIDConnectProviderErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagOpenIDConnectProviderErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagOpenIDConnectProviderErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagOpenIDConnectProviderErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagOpenIDConnectProviderErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagOpenIDConnectProviderErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagOpenIDConnectProviderErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagOpenIDConnectProviderErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for UntagOpenIDConnectProviderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagOpenIDConnectProviderErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            UntagOpenIDConnectProviderErrorKind::InvalidInputException(_inner) => Some(_inner),
            UntagOpenIDConnectProviderErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            UntagOpenIDConnectProviderErrorKind::ServiceFailureException(_inner) => Some(_inner),
            UntagOpenIDConnectProviderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagPolicyError {
    /// Kind of error that occurred.
    pub kind: UntagPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagPolicyErrorKind {
    /// <p>The request was rejected because multiple requests to change this object were submitted
    /// simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagPolicyErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UntagPolicyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UntagPolicyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            UntagPolicyErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            UntagPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagPolicyError {
    fn code(&self) -> Option<&str> {
        UntagPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagPolicyError {
    /// Creates a new `UntagPolicyError`.
    pub fn new(kind: UntagPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagPolicyErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagPolicyErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagPolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, UntagPolicyErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `UntagPolicyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(&self.kind, UntagPolicyErrorKind::NoSuchEntityException(_))
    }
    /// Returns `true` if the error kind is `UntagPolicyErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, UntagPolicyErrorKind::ServiceFailureException(_))
    }
}
impl std::error::Error for UntagPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagPolicyErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UntagPolicyErrorKind::InvalidInputException(_inner) => Some(_inner),
            UntagPolicyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            UntagPolicyErrorKind::ServiceFailureException(_inner) => Some(_inner),
            UntagPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagRoleError {
    /// Kind of error that occurred.
    pub kind: UntagRoleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagRoleErrorKind {
    /// <p>The request was rejected because multiple requests to change this object were submitted
    /// simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagRoleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagRoleErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UntagRoleErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            UntagRoleErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            UntagRoleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagRoleError {
    fn code(&self) -> Option<&str> {
        UntagRoleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagRoleError {
    /// Creates a new `UntagRoleError`.
    pub fn new(kind: UntagRoleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagRoleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagRoleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagRoleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagRoleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagRoleErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagRoleErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagRoleErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(&self.kind, UntagRoleErrorKind::NoSuchEntityException(_))
    }
    /// Returns `true` if the error kind is `UntagRoleErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, UntagRoleErrorKind::ServiceFailureException(_))
    }
}
impl std::error::Error for UntagRoleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagRoleErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UntagRoleErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            UntagRoleErrorKind::ServiceFailureException(_inner) => Some(_inner),
            UntagRoleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagSAMLProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagSAMLProviderError {
    /// Kind of error that occurred.
    pub kind: UntagSAMLProviderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagSAMLProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagSAMLProviderErrorKind {
    /// <p>The request was rejected because multiple requests to change this object were submitted
    /// simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagSAMLProviderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagSAMLProviderErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UntagSAMLProviderErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UntagSAMLProviderErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            UntagSAMLProviderErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            UntagSAMLProviderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagSAMLProviderError {
    fn code(&self) -> Option<&str> {
        UntagSAMLProviderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagSAMLProviderError {
    /// Creates a new `UntagSAMLProviderError`.
    pub fn new(kind: UntagSAMLProviderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagSAMLProviderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagSAMLProviderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagSAMLProviderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagSAMLProviderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagSAMLProviderErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagSAMLProviderErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagSAMLProviderErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagSAMLProviderErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagSAMLProviderErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagSAMLProviderErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagSAMLProviderErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagSAMLProviderErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for UntagSAMLProviderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagSAMLProviderErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UntagSAMLProviderErrorKind::InvalidInputException(_inner) => Some(_inner),
            UntagSAMLProviderErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            UntagSAMLProviderErrorKind::ServiceFailureException(_inner) => Some(_inner),
            UntagSAMLProviderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagServerCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagServerCertificateError {
    /// Kind of error that occurred.
    pub kind: UntagServerCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagServerCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagServerCertificateErrorKind {
    /// <p>The request was rejected because multiple requests to change this object were submitted
    /// simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagServerCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagServerCertificateErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            UntagServerCertificateErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UntagServerCertificateErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            UntagServerCertificateErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            UntagServerCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagServerCertificateError {
    fn code(&self) -> Option<&str> {
        UntagServerCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagServerCertificateError {
    /// Creates a new `UntagServerCertificateError`.
    pub fn new(kind: UntagServerCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagServerCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagServerCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagServerCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagServerCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagServerCertificateErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagServerCertificateErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagServerCertificateErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagServerCertificateErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagServerCertificateErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagServerCertificateErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagServerCertificateErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagServerCertificateErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for UntagServerCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagServerCertificateErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            UntagServerCertificateErrorKind::InvalidInputException(_inner) => Some(_inner),
            UntagServerCertificateErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            UntagServerCertificateErrorKind::ServiceFailureException(_inner) => Some(_inner),
            UntagServerCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagUserError {
    /// Kind of error that occurred.
    pub kind: UntagUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagUserErrorKind {
    /// <p>The request was rejected because multiple requests to change this object were submitted
    /// simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagUserErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UntagUserErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            UntagUserErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            UntagUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagUserError {
    fn code(&self) -> Option<&str> {
        UntagUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagUserError {
    /// Creates a new `UntagUserError`.
    pub fn new(kind: UntagUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagUserErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagUserErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagUserErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagUserErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(&self.kind, UntagUserErrorKind::NoSuchEntityException(_))
    }
    /// Returns `true` if the error kind is `UntagUserErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, UntagUserErrorKind::ServiceFailureException(_))
    }
}
impl std::error::Error for UntagUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagUserErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UntagUserErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            UntagUserErrorKind::ServiceFailureException(_inner) => Some(_inner),
            UntagUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAccessKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAccessKeyError {
    /// Kind of error that occurred.
    pub kind: UpdateAccessKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAccessKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAccessKeyErrorKind {
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAccessKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAccessKeyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateAccessKeyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            UpdateAccessKeyErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            UpdateAccessKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAccessKeyError {
    fn code(&self) -> Option<&str> {
        UpdateAccessKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAccessKeyError {
    /// Creates a new `UpdateAccessKeyError`.
    pub fn new(kind: UpdateAccessKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAccessKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAccessKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAccessKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAccessKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAccessKeyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccessKeyErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAccessKeyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccessKeyErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAccessKeyErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccessKeyErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for UpdateAccessKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAccessKeyErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateAccessKeyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            UpdateAccessKeyErrorKind::ServiceFailureException(_inner) => Some(_inner),
            UpdateAccessKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAccountPasswordPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAccountPasswordPolicyError {
    /// Kind of error that occurred.
    pub kind: UpdateAccountPasswordPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAccountPasswordPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAccountPasswordPolicyErrorKind {
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because the policy document was malformed. The error message
    /// describes the specific error.</p>
    MalformedPolicyDocumentException(crate::error::MalformedPolicyDocumentException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAccountPasswordPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAccountPasswordPolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateAccountPasswordPolicyErrorKind::MalformedPolicyDocumentException(_inner) => {
                _inner.fmt(f)
            }
            UpdateAccountPasswordPolicyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            UpdateAccountPasswordPolicyErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            UpdateAccountPasswordPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAccountPasswordPolicyError {
    fn code(&self) -> Option<&str> {
        UpdateAccountPasswordPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAccountPasswordPolicyError {
    /// Creates a new `UpdateAccountPasswordPolicyError`.
    pub fn new(kind: UpdateAccountPasswordPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAccountPasswordPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAccountPasswordPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAccountPasswordPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAccountPasswordPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAccountPasswordPolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccountPasswordPolicyErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAccountPasswordPolicyErrorKind::MalformedPolicyDocumentException`.
    pub fn is_malformed_policy_document_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccountPasswordPolicyErrorKind::MalformedPolicyDocumentException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAccountPasswordPolicyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccountPasswordPolicyErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAccountPasswordPolicyErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAccountPasswordPolicyErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for UpdateAccountPasswordPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAccountPasswordPolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateAccountPasswordPolicyErrorKind::MalformedPolicyDocumentException(_inner) => {
                Some(_inner)
            }
            UpdateAccountPasswordPolicyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            UpdateAccountPasswordPolicyErrorKind::ServiceFailureException(_inner) => Some(_inner),
            UpdateAccountPasswordPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAssumeRolePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAssumeRolePolicyError {
    /// Kind of error that occurred.
    pub kind: UpdateAssumeRolePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAssumeRolePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAssumeRolePolicyErrorKind {
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because the policy document was malformed. The error message
    /// describes the specific error.</p>
    MalformedPolicyDocumentException(crate::error::MalformedPolicyDocumentException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The request was rejected because only the service that depends on the service-linked role
    /// can modify or delete the role on your behalf. The error message includes the name of the
    /// service that depends on this service-linked role. You must request the change through that
    /// service.</p>
    UnmodifiableEntityException(crate::error::UnmodifiableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAssumeRolePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAssumeRolePolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateAssumeRolePolicyErrorKind::MalformedPolicyDocumentException(_inner) => {
                _inner.fmt(f)
            }
            UpdateAssumeRolePolicyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            UpdateAssumeRolePolicyErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            UpdateAssumeRolePolicyErrorKind::UnmodifiableEntityException(_inner) => _inner.fmt(f),
            UpdateAssumeRolePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAssumeRolePolicyError {
    fn code(&self) -> Option<&str> {
        UpdateAssumeRolePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAssumeRolePolicyError {
    /// Creates a new `UpdateAssumeRolePolicyError`.
    pub fn new(kind: UpdateAssumeRolePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAssumeRolePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAssumeRolePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAssumeRolePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAssumeRolePolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAssumeRolePolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssumeRolePolicyErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssumeRolePolicyErrorKind::MalformedPolicyDocumentException`.
    pub fn is_malformed_policy_document_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssumeRolePolicyErrorKind::MalformedPolicyDocumentException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssumeRolePolicyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssumeRolePolicyErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssumeRolePolicyErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssumeRolePolicyErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssumeRolePolicyErrorKind::UnmodifiableEntityException`.
    pub fn is_unmodifiable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssumeRolePolicyErrorKind::UnmodifiableEntityException(_)
        )
    }
}
impl std::error::Error for UpdateAssumeRolePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAssumeRolePolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateAssumeRolePolicyErrorKind::MalformedPolicyDocumentException(_inner) => {
                Some(_inner)
            }
            UpdateAssumeRolePolicyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            UpdateAssumeRolePolicyErrorKind::ServiceFailureException(_inner) => Some(_inner),
            UpdateAssumeRolePolicyErrorKind::UnmodifiableEntityException(_inner) => Some(_inner),
            UpdateAssumeRolePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateGroupError {
    /// Kind of error that occurred.
    pub kind: UpdateGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateGroupErrorKind {
    /// <p>The request was rejected because it attempted to create a resource that already
    /// exists.</p>
    EntityAlreadyExistsException(crate::error::EntityAlreadyExistsException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateGroupErrorKind::EntityAlreadyExistsException(_inner) => _inner.fmt(f),
            UpdateGroupErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateGroupErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            UpdateGroupErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            UpdateGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateGroupError {
    fn code(&self) -> Option<&str> {
        UpdateGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateGroupError {
    /// Creates a new `UpdateGroupError`.
    pub fn new(kind: UpdateGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateGroupErrorKind::EntityAlreadyExistsException`.
    pub fn is_entity_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGroupErrorKind::EntityAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGroupErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, UpdateGroupErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `UpdateGroupErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(&self.kind, UpdateGroupErrorKind::NoSuchEntityException(_))
    }
    /// Returns `true` if the error kind is `UpdateGroupErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, UpdateGroupErrorKind::ServiceFailureException(_))
    }
}
impl std::error::Error for UpdateGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateGroupErrorKind::EntityAlreadyExistsException(_inner) => Some(_inner),
            UpdateGroupErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateGroupErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            UpdateGroupErrorKind::ServiceFailureException(_inner) => Some(_inner),
            UpdateGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateLoginProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateLoginProfileError {
    /// Kind of error that occurred.
    pub kind: UpdateLoginProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateLoginProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateLoginProfileErrorKind {
    /// <p>The request was rejected because it referenced an entity that is temporarily unmodifiable,
    /// such as a user name that was deleted and then recreated. The error indicates that the request
    /// is likely to succeed if you try again after waiting several minutes. The error message
    /// describes the entity.</p>
    EntityTemporarilyUnmodifiableException(crate::error::EntityTemporarilyUnmodifiableException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request was rejected because the provided password did not meet the requirements
    /// imposed by the account password policy.</p>
    PasswordPolicyViolationException(crate::error::PasswordPolicyViolationException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateLoginProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateLoginProfileErrorKind::EntityTemporarilyUnmodifiableException(_inner) => {
                _inner.fmt(f)
            }
            UpdateLoginProfileErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateLoginProfileErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            UpdateLoginProfileErrorKind::PasswordPolicyViolationException(_inner) => _inner.fmt(f),
            UpdateLoginProfileErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            UpdateLoginProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateLoginProfileError {
    fn code(&self) -> Option<&str> {
        UpdateLoginProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateLoginProfileError {
    /// Creates a new `UpdateLoginProfileError`.
    pub fn new(kind: UpdateLoginProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateLoginProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateLoginProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateLoginProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateLoginProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateLoginProfileErrorKind::EntityTemporarilyUnmodifiableException`.
    pub fn is_entity_temporarily_unmodifiable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLoginProfileErrorKind::EntityTemporarilyUnmodifiableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLoginProfileErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLoginProfileErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLoginProfileErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLoginProfileErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLoginProfileErrorKind::PasswordPolicyViolationException`.
    pub fn is_password_policy_violation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLoginProfileErrorKind::PasswordPolicyViolationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLoginProfileErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLoginProfileErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for UpdateLoginProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateLoginProfileErrorKind::EntityTemporarilyUnmodifiableException(_inner) => {
                Some(_inner)
            }
            UpdateLoginProfileErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateLoginProfileErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            UpdateLoginProfileErrorKind::PasswordPolicyViolationException(_inner) => Some(_inner),
            UpdateLoginProfileErrorKind::ServiceFailureException(_inner) => Some(_inner),
            UpdateLoginProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateOpenIDConnectProviderThumbprint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateOpenIDConnectProviderThumbprintError {
    /// Kind of error that occurred.
    pub kind: UpdateOpenIDConnectProviderThumbprintErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateOpenIDConnectProviderThumbprint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateOpenIDConnectProviderThumbprintErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateOpenIDConnectProviderThumbprintError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateOpenIDConnectProviderThumbprintErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            UpdateOpenIDConnectProviderThumbprintErrorKind::NoSuchEntityException(_inner) => {
                _inner.fmt(f)
            }
            UpdateOpenIDConnectProviderThumbprintErrorKind::ServiceFailureException(_inner) => {
                _inner.fmt(f)
            }
            UpdateOpenIDConnectProviderThumbprintErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateOpenIDConnectProviderThumbprintError {
    fn code(&self) -> Option<&str> {
        UpdateOpenIDConnectProviderThumbprintError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateOpenIDConnectProviderThumbprintError {
    /// Creates a new `UpdateOpenIDConnectProviderThumbprintError`.
    pub fn new(
        kind: UpdateOpenIDConnectProviderThumbprintErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateOpenIDConnectProviderThumbprintError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateOpenIDConnectProviderThumbprintErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateOpenIDConnectProviderThumbprintError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateOpenIDConnectProviderThumbprintErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateOpenIDConnectProviderThumbprintErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOpenIDConnectProviderThumbprintErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOpenIDConnectProviderThumbprintErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOpenIDConnectProviderThumbprintErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOpenIDConnectProviderThumbprintErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOpenIDConnectProviderThumbprintErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for UpdateOpenIDConnectProviderThumbprintError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateOpenIDConnectProviderThumbprintErrorKind::InvalidInputException(_inner) => {
                Some(_inner)
            }
            UpdateOpenIDConnectProviderThumbprintErrorKind::NoSuchEntityException(_inner) => {
                Some(_inner)
            }
            UpdateOpenIDConnectProviderThumbprintErrorKind::ServiceFailureException(_inner) => {
                Some(_inner)
            }
            UpdateOpenIDConnectProviderThumbprintErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `UpdateRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRoleError {
    /// Kind of error that occurred.
    pub kind: UpdateRoleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRole` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRoleErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The request was rejected because only the service that depends on the service-linked role
    /// can modify or delete the role on your behalf. The error message includes the name of the
    /// service that depends on this service-linked role. You must request the change through that
    /// service.</p>
    UnmodifiableEntityException(crate::error::UnmodifiableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRoleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRoleErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            UpdateRoleErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            UpdateRoleErrorKind::UnmodifiableEntityException(_inner) => _inner.fmt(f),
            UpdateRoleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRoleError {
    fn code(&self) -> Option<&str> {
        UpdateRoleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRoleError {
    /// Creates a new `UpdateRoleError`.
    pub fn new(kind: UpdateRoleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRoleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRoleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRoleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRoleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateRoleErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(&self.kind, UpdateRoleErrorKind::NoSuchEntityException(_))
    }
    /// Returns `true` if the error kind is `UpdateRoleErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, UpdateRoleErrorKind::ServiceFailureException(_))
    }
    /// Returns `true` if the error kind is `UpdateRoleErrorKind::UnmodifiableEntityException`.
    pub fn is_unmodifiable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoleErrorKind::UnmodifiableEntityException(_)
        )
    }
}
impl std::error::Error for UpdateRoleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRoleErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            UpdateRoleErrorKind::ServiceFailureException(_inner) => Some(_inner),
            UpdateRoleErrorKind::UnmodifiableEntityException(_inner) => Some(_inner),
            UpdateRoleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRoleDescription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRoleDescriptionError {
    /// Kind of error that occurred.
    pub kind: UpdateRoleDescriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRoleDescription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRoleDescriptionErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// <p>The request was rejected because only the service that depends on the service-linked role
    /// can modify or delete the role on your behalf. The error message includes the name of the
    /// service that depends on this service-linked role. You must request the change through that
    /// service.</p>
    UnmodifiableEntityException(crate::error::UnmodifiableEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRoleDescriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRoleDescriptionErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            UpdateRoleDescriptionErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            UpdateRoleDescriptionErrorKind::UnmodifiableEntityException(_inner) => _inner.fmt(f),
            UpdateRoleDescriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRoleDescriptionError {
    fn code(&self) -> Option<&str> {
        UpdateRoleDescriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRoleDescriptionError {
    /// Creates a new `UpdateRoleDescriptionError`.
    pub fn new(kind: UpdateRoleDescriptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRoleDescriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRoleDescriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRoleDescriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRoleDescriptionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateRoleDescriptionErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoleDescriptionErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoleDescriptionErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoleDescriptionErrorKind::ServiceFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoleDescriptionErrorKind::UnmodifiableEntityException`.
    pub fn is_unmodifiable_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoleDescriptionErrorKind::UnmodifiableEntityException(_)
        )
    }
}
impl std::error::Error for UpdateRoleDescriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRoleDescriptionErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            UpdateRoleDescriptionErrorKind::ServiceFailureException(_inner) => Some(_inner),
            UpdateRoleDescriptionErrorKind::UnmodifiableEntityException(_inner) => Some(_inner),
            UpdateRoleDescriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSAMLProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSAMLProviderError {
    /// Kind of error that occurred.
    pub kind: UpdateSAMLProviderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSAMLProvider` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSAMLProviderErrorKind {
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSAMLProviderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSAMLProviderErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateSAMLProviderErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateSAMLProviderErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            UpdateSAMLProviderErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            UpdateSAMLProviderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSAMLProviderError {
    fn code(&self) -> Option<&str> {
        UpdateSAMLProviderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSAMLProviderError {
    /// Creates a new `UpdateSAMLProviderError`.
    pub fn new(kind: UpdateSAMLProviderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSAMLProviderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSAMLProviderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSAMLProviderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSAMLProviderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateSAMLProviderErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSAMLProviderErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSAMLProviderErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSAMLProviderErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSAMLProviderErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSAMLProviderErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSAMLProviderErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSAMLProviderErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for UpdateSAMLProviderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSAMLProviderErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateSAMLProviderErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateSAMLProviderErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            UpdateSAMLProviderErrorKind::ServiceFailureException(_inner) => Some(_inner),
            UpdateSAMLProviderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateServerCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateServerCertificateError {
    /// Kind of error that occurred.
    pub kind: UpdateServerCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateServerCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateServerCertificateErrorKind {
    /// <p>The request was rejected because it attempted to create a resource that already
    /// exists.</p>
    EntityAlreadyExistsException(crate::error::EntityAlreadyExistsException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateServerCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateServerCertificateErrorKind::EntityAlreadyExistsException(_inner) => _inner.fmt(f),
            UpdateServerCertificateErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateServerCertificateErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            UpdateServerCertificateErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            UpdateServerCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateServerCertificateError {
    fn code(&self) -> Option<&str> {
        UpdateServerCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateServerCertificateError {
    /// Creates a new `UpdateServerCertificateError`.
    pub fn new(kind: UpdateServerCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateServerCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateServerCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateServerCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateServerCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateServerCertificateErrorKind::EntityAlreadyExistsException`.
    pub fn is_entity_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServerCertificateErrorKind::EntityAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServerCertificateErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServerCertificateErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServerCertificateErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServerCertificateErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServerCertificateErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServerCertificateErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for UpdateServerCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateServerCertificateErrorKind::EntityAlreadyExistsException(_inner) => Some(_inner),
            UpdateServerCertificateErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateServerCertificateErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            UpdateServerCertificateErrorKind::ServiceFailureException(_inner) => Some(_inner),
            UpdateServerCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateServiceSpecificCredential` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateServiceSpecificCredentialError {
    /// Kind of error that occurred.
    pub kind: UpdateServiceSpecificCredentialErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateServiceSpecificCredential` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateServiceSpecificCredentialErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateServiceSpecificCredentialError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateServiceSpecificCredentialErrorKind::NoSuchEntityException(_inner) => {
                _inner.fmt(f)
            }
            UpdateServiceSpecificCredentialErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateServiceSpecificCredentialError {
    fn code(&self) -> Option<&str> {
        UpdateServiceSpecificCredentialError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateServiceSpecificCredentialError {
    /// Creates a new `UpdateServiceSpecificCredentialError`.
    pub fn new(
        kind: UpdateServiceSpecificCredentialErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateServiceSpecificCredentialError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateServiceSpecificCredentialErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateServiceSpecificCredentialError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateServiceSpecificCredentialErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateServiceSpecificCredentialErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceSpecificCredentialErrorKind::NoSuchEntityException(_)
        )
    }
}
impl std::error::Error for UpdateServiceSpecificCredentialError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateServiceSpecificCredentialErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            UpdateServiceSpecificCredentialErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSigningCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSigningCertificateError {
    /// Kind of error that occurred.
    pub kind: UpdateSigningCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSigningCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSigningCertificateErrorKind {
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSigningCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSigningCertificateErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateSigningCertificateErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            UpdateSigningCertificateErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            UpdateSigningCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSigningCertificateError {
    fn code(&self) -> Option<&str> {
        UpdateSigningCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSigningCertificateError {
    /// Creates a new `UpdateSigningCertificateError`.
    pub fn new(kind: UpdateSigningCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSigningCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSigningCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSigningCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSigningCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateSigningCertificateErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSigningCertificateErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSigningCertificateErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSigningCertificateErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSigningCertificateErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSigningCertificateErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for UpdateSigningCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSigningCertificateErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateSigningCertificateErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            UpdateSigningCertificateErrorKind::ServiceFailureException(_inner) => Some(_inner),
            UpdateSigningCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSSHPublicKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSSHPublicKeyError {
    /// Kind of error that occurred.
    pub kind: UpdateSSHPublicKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSSHPublicKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSSHPublicKeyErrorKind {
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSSHPublicKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSSHPublicKeyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            UpdateSSHPublicKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSSHPublicKeyError {
    fn code(&self) -> Option<&str> {
        UpdateSSHPublicKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSSHPublicKeyError {
    /// Creates a new `UpdateSSHPublicKeyError`.
    pub fn new(kind: UpdateSSHPublicKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSSHPublicKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSSHPublicKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSSHPublicKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSSHPublicKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateSSHPublicKeyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSSHPublicKeyErrorKind::NoSuchEntityException(_)
        )
    }
}
impl std::error::Error for UpdateSSHPublicKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSSHPublicKeyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            UpdateSSHPublicKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateUserError {
    /// Kind of error that occurred.
    pub kind: UpdateUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateUserErrorKind {
    /// <p>The request was rejected because multiple requests to change this object were submitted
    /// simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request was rejected because it attempted to create a resource that already
    /// exists.</p>
    EntityAlreadyExistsException(crate::error::EntityAlreadyExistsException),
    /// <p>The request was rejected because it referenced an entity that is temporarily unmodifiable,
    /// such as a user name that was deleted and then recreated. The error indicates that the request
    /// is likely to succeed if you try again after waiting several minutes. The error message
    /// describes the entity.</p>
    EntityTemporarilyUnmodifiableException(crate::error::EntityTemporarilyUnmodifiableException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateUserErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::EntityAlreadyExistsException(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::EntityTemporarilyUnmodifiableException(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            UpdateUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateUserError {
    fn code(&self) -> Option<&str> {
        UpdateUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateUserError {
    /// Creates a new `UpdateUserError`.
    pub fn new(kind: UpdateUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateUserErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateUserErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserErrorKind::EntityAlreadyExistsException`.
    pub fn is_entity_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserErrorKind::EntityAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserErrorKind::EntityTemporarilyUnmodifiableException`.
    pub fn is_entity_temporarily_unmodifiable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserErrorKind::EntityTemporarilyUnmodifiableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, UpdateUserErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `UpdateUserErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(&self.kind, UpdateUserErrorKind::NoSuchEntityException(_))
    }
    /// Returns `true` if the error kind is `UpdateUserErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(&self.kind, UpdateUserErrorKind::ServiceFailureException(_))
    }
}
impl std::error::Error for UpdateUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateUserErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateUserErrorKind::EntityAlreadyExistsException(_inner) => Some(_inner),
            UpdateUserErrorKind::EntityTemporarilyUnmodifiableException(_inner) => Some(_inner),
            UpdateUserErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateUserErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            UpdateUserErrorKind::ServiceFailureException(_inner) => Some(_inner),
            UpdateUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UploadServerCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UploadServerCertificateError {
    /// Kind of error that occurred.
    pub kind: UploadServerCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UploadServerCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UploadServerCertificateErrorKind {
    /// <p>The request was rejected because multiple requests to change this object were submitted
    /// simultaneously. Wait a few minutes and submit your request again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The request was rejected because it attempted to create a resource that already
    /// exists.</p>
    EntityAlreadyExistsException(crate::error::EntityAlreadyExistsException),
    /// <p>The request was rejected because an invalid or out-of-range value was supplied for an
    /// input parameter.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The request was rejected because the public key certificate and the private key do not
    /// match.</p>
    KeyPairMismatchException(crate::error::KeyPairMismatchException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because the certificate was malformed or expired. The error
    /// message describes the specific error.</p>
    MalformedCertificateException(crate::error::MalformedCertificateException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UploadServerCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UploadServerCertificateErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            UploadServerCertificateErrorKind::EntityAlreadyExistsException(_inner) => _inner.fmt(f),
            UploadServerCertificateErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UploadServerCertificateErrorKind::KeyPairMismatchException(_inner) => _inner.fmt(f),
            UploadServerCertificateErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UploadServerCertificateErrorKind::MalformedCertificateException(_inner) => {
                _inner.fmt(f)
            }
            UploadServerCertificateErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            UploadServerCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UploadServerCertificateError {
    fn code(&self) -> Option<&str> {
        UploadServerCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UploadServerCertificateError {
    /// Creates a new `UploadServerCertificateError`.
    pub fn new(kind: UploadServerCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UploadServerCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UploadServerCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UploadServerCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UploadServerCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UploadServerCertificateErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadServerCertificateErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadServerCertificateErrorKind::EntityAlreadyExistsException`.
    pub fn is_entity_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadServerCertificateErrorKind::EntityAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadServerCertificateErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadServerCertificateErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadServerCertificateErrorKind::KeyPairMismatchException`.
    pub fn is_key_pair_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadServerCertificateErrorKind::KeyPairMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadServerCertificateErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadServerCertificateErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadServerCertificateErrorKind::MalformedCertificateException`.
    pub fn is_malformed_certificate_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadServerCertificateErrorKind::MalformedCertificateException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadServerCertificateErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadServerCertificateErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for UploadServerCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UploadServerCertificateErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            UploadServerCertificateErrorKind::EntityAlreadyExistsException(_inner) => Some(_inner),
            UploadServerCertificateErrorKind::InvalidInputException(_inner) => Some(_inner),
            UploadServerCertificateErrorKind::KeyPairMismatchException(_inner) => Some(_inner),
            UploadServerCertificateErrorKind::LimitExceededException(_inner) => Some(_inner),
            UploadServerCertificateErrorKind::MalformedCertificateException(_inner) => Some(_inner),
            UploadServerCertificateErrorKind::ServiceFailureException(_inner) => Some(_inner),
            UploadServerCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UploadSigningCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UploadSigningCertificateError {
    /// Kind of error that occurred.
    pub kind: UploadSigningCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UploadSigningCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UploadSigningCertificateErrorKind {
    /// <p>The request was rejected because the same certificate is associated with an IAM user in
    /// the account.</p>
    DuplicateCertificateException(crate::error::DuplicateCertificateException),
    /// <p>The request was rejected because it attempted to create a resource that already
    /// exists.</p>
    EntityAlreadyExistsException(crate::error::EntityAlreadyExistsException),
    /// <p>The request was rejected because the certificate is invalid.</p>
    InvalidCertificateException(crate::error::InvalidCertificateException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because the certificate was malformed or expired. The error
    /// message describes the specific error.</p>
    MalformedCertificateException(crate::error::MalformedCertificateException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request processing has failed because of an unknown error, exception or
    /// failure.</p>
    ServiceFailureException(crate::error::ServiceFailureException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UploadSigningCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UploadSigningCertificateErrorKind::DuplicateCertificateException(_inner) => {
                _inner.fmt(f)
            }
            UploadSigningCertificateErrorKind::EntityAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            UploadSigningCertificateErrorKind::InvalidCertificateException(_inner) => _inner.fmt(f),
            UploadSigningCertificateErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UploadSigningCertificateErrorKind::MalformedCertificateException(_inner) => {
                _inner.fmt(f)
            }
            UploadSigningCertificateErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            UploadSigningCertificateErrorKind::ServiceFailureException(_inner) => _inner.fmt(f),
            UploadSigningCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UploadSigningCertificateError {
    fn code(&self) -> Option<&str> {
        UploadSigningCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UploadSigningCertificateError {
    /// Creates a new `UploadSigningCertificateError`.
    pub fn new(kind: UploadSigningCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UploadSigningCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UploadSigningCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UploadSigningCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UploadSigningCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UploadSigningCertificateErrorKind::DuplicateCertificateException`.
    pub fn is_duplicate_certificate_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadSigningCertificateErrorKind::DuplicateCertificateException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadSigningCertificateErrorKind::EntityAlreadyExistsException`.
    pub fn is_entity_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadSigningCertificateErrorKind::EntityAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadSigningCertificateErrorKind::InvalidCertificateException`.
    pub fn is_invalid_certificate_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadSigningCertificateErrorKind::InvalidCertificateException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadSigningCertificateErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadSigningCertificateErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadSigningCertificateErrorKind::MalformedCertificateException`.
    pub fn is_malformed_certificate_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadSigningCertificateErrorKind::MalformedCertificateException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadSigningCertificateErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadSigningCertificateErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadSigningCertificateErrorKind::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadSigningCertificateErrorKind::ServiceFailureException(_)
        )
    }
}
impl std::error::Error for UploadSigningCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UploadSigningCertificateErrorKind::DuplicateCertificateException(_inner) => {
                Some(_inner)
            }
            UploadSigningCertificateErrorKind::EntityAlreadyExistsException(_inner) => Some(_inner),
            UploadSigningCertificateErrorKind::InvalidCertificateException(_inner) => Some(_inner),
            UploadSigningCertificateErrorKind::LimitExceededException(_inner) => Some(_inner),
            UploadSigningCertificateErrorKind::MalformedCertificateException(_inner) => {
                Some(_inner)
            }
            UploadSigningCertificateErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            UploadSigningCertificateErrorKind::ServiceFailureException(_inner) => Some(_inner),
            UploadSigningCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UploadSSHPublicKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UploadSSHPublicKeyError {
    /// Kind of error that occurred.
    pub kind: UploadSSHPublicKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UploadSSHPublicKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UploadSSHPublicKeyErrorKind {
    /// <p>The request was rejected because the SSH public key is already associated with the
    /// specified IAM user.</p>
    DuplicateSshPublicKeyException(crate::error::DuplicateSshPublicKeyException),
    /// <p>The request was rejected because the public key is malformed or otherwise invalid.</p>
    InvalidPublicKeyException(crate::error::InvalidPublicKeyException),
    /// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
    /// account limits. The error message describes the limit exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The request was rejected because it referenced a resource entity that does not exist. The
    /// error message describes the resource.</p>
    NoSuchEntityException(crate::error::NoSuchEntityException),
    /// <p>The request was rejected because the public key encoding format is unsupported or
    /// unrecognized.</p>
    UnrecognizedPublicKeyEncodingException(crate::error::UnrecognizedPublicKeyEncodingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UploadSSHPublicKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UploadSSHPublicKeyErrorKind::DuplicateSshPublicKeyException(_inner) => _inner.fmt(f),
            UploadSSHPublicKeyErrorKind::InvalidPublicKeyException(_inner) => _inner.fmt(f),
            UploadSSHPublicKeyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UploadSSHPublicKeyErrorKind::NoSuchEntityException(_inner) => _inner.fmt(f),
            UploadSSHPublicKeyErrorKind::UnrecognizedPublicKeyEncodingException(_inner) => {
                _inner.fmt(f)
            }
            UploadSSHPublicKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UploadSSHPublicKeyError {
    fn code(&self) -> Option<&str> {
        UploadSSHPublicKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UploadSSHPublicKeyError {
    /// Creates a new `UploadSSHPublicKeyError`.
    pub fn new(kind: UploadSSHPublicKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UploadSSHPublicKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UploadSSHPublicKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UploadSSHPublicKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UploadSSHPublicKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UploadSSHPublicKeyErrorKind::DuplicateSshPublicKeyException`.
    pub fn is_duplicate_ssh_public_key_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadSSHPublicKeyErrorKind::DuplicateSshPublicKeyException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadSSHPublicKeyErrorKind::InvalidPublicKeyException`.
    pub fn is_invalid_public_key_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadSSHPublicKeyErrorKind::InvalidPublicKeyException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadSSHPublicKeyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadSSHPublicKeyErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadSSHPublicKeyErrorKind::NoSuchEntityException`.
    pub fn is_no_such_entity_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadSSHPublicKeyErrorKind::NoSuchEntityException(_)
        )
    }
    /// Returns `true` if the error kind is `UploadSSHPublicKeyErrorKind::UnrecognizedPublicKeyEncodingException`.
    pub fn is_unrecognized_public_key_encoding_exception(&self) -> bool {
        matches!(
            &self.kind,
            UploadSSHPublicKeyErrorKind::UnrecognizedPublicKeyEncodingException(_)
        )
    }
}
impl std::error::Error for UploadSSHPublicKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UploadSSHPublicKeyErrorKind::DuplicateSshPublicKeyException(_inner) => Some(_inner),
            UploadSSHPublicKeyErrorKind::InvalidPublicKeyException(_inner) => Some(_inner),
            UploadSSHPublicKeyErrorKind::LimitExceededException(_inner) => Some(_inner),
            UploadSSHPublicKeyErrorKind::NoSuchEntityException(_inner) => Some(_inner),
            UploadSSHPublicKeyErrorKind::UnrecognizedPublicKeyEncodingException(_inner) => {
                Some(_inner)
            }
            UploadSSHPublicKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The request was rejected because the public key encoding format is unsupported or
/// unrecognized.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnrecognizedPublicKeyEncodingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnrecognizedPublicKeyEncodingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnrecognizedPublicKeyEncodingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnrecognizedPublicKeyEncodingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnrecognizedPublicKeyEncodingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnrecognizedPublicKeyEncodingException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnrecognizedPublicKeyEncodingException {}
/// See [`UnrecognizedPublicKeyEncodingException`](crate::error::UnrecognizedPublicKeyEncodingException)
pub mod unrecognized_public_key_encoding_exception {
    /// A builder for [`UnrecognizedPublicKeyEncodingException`](crate::error::UnrecognizedPublicKeyEncodingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnrecognizedPublicKeyEncodingException`](crate::error::UnrecognizedPublicKeyEncodingException)
        pub fn build(self) -> crate::error::UnrecognizedPublicKeyEncodingException {
            crate::error::UnrecognizedPublicKeyEncodingException {
                message: self.message,
            }
        }
    }
}
impl UnrecognizedPublicKeyEncodingException {
    /// Creates a new builder-style object to manufacture [`UnrecognizedPublicKeyEncodingException`](crate::error::UnrecognizedPublicKeyEncodingException)
    pub fn builder() -> crate::error::unrecognized_public_key_encoding_exception::Builder {
        crate::error::unrecognized_public_key_encoding_exception::Builder::default()
    }
}

/// <p>The request was rejected because it referenced a resource entity that does not exist. The
/// error message describes the resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoSuchEntityException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoSuchEntityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoSuchEntityException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoSuchEntityException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoSuchEntityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoSuchEntityException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoSuchEntityException {}
/// See [`NoSuchEntityException`](crate::error::NoSuchEntityException)
pub mod no_such_entity_exception {
    /// A builder for [`NoSuchEntityException`](crate::error::NoSuchEntityException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoSuchEntityException`](crate::error::NoSuchEntityException)
        pub fn build(self) -> crate::error::NoSuchEntityException {
            crate::error::NoSuchEntityException {
                message: self.message,
            }
        }
    }
}
impl NoSuchEntityException {
    /// Creates a new builder-style object to manufacture [`NoSuchEntityException`](crate::error::NoSuchEntityException)
    pub fn builder() -> crate::error::no_such_entity_exception::Builder {
        crate::error::no_such_entity_exception::Builder::default()
    }
}

/// <p>The request was rejected because it attempted to create resources beyond the current Amazon Web Services
/// account limits. The error message describes the limit exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>The request was rejected because the public key is malformed or otherwise invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidPublicKeyException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidPublicKeyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidPublicKeyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidPublicKeyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidPublicKeyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidPublicKeyException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidPublicKeyException {}
/// See [`InvalidPublicKeyException`](crate::error::InvalidPublicKeyException)
pub mod invalid_public_key_exception {
    /// A builder for [`InvalidPublicKeyException`](crate::error::InvalidPublicKeyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidPublicKeyException`](crate::error::InvalidPublicKeyException)
        pub fn build(self) -> crate::error::InvalidPublicKeyException {
            crate::error::InvalidPublicKeyException {
                message: self.message,
            }
        }
    }
}
impl InvalidPublicKeyException {
    /// Creates a new builder-style object to manufacture [`InvalidPublicKeyException`](crate::error::InvalidPublicKeyException)
    pub fn builder() -> crate::error::invalid_public_key_exception::Builder {
        crate::error::invalid_public_key_exception::Builder::default()
    }
}

/// <p>The request was rejected because the SSH public key is already associated with the
/// specified IAM user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DuplicateSshPublicKeyException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DuplicateSshPublicKeyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DuplicateSshPublicKeyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DuplicateSshPublicKeyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DuplicateSshPublicKeyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DuplicateSshPublicKeyException [DuplicateSSHPublicKeyException]"
        )?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for DuplicateSshPublicKeyException {}
/// See [`DuplicateSshPublicKeyException`](crate::error::DuplicateSshPublicKeyException)
pub mod duplicate_ssh_public_key_exception {
    /// A builder for [`DuplicateSshPublicKeyException`](crate::error::DuplicateSshPublicKeyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DuplicateSshPublicKeyException`](crate::error::DuplicateSshPublicKeyException)
        pub fn build(self) -> crate::error::DuplicateSshPublicKeyException {
            crate::error::DuplicateSshPublicKeyException {
                message: self.message,
            }
        }
    }
}
impl DuplicateSshPublicKeyException {
    /// Creates a new builder-style object to manufacture [`DuplicateSshPublicKeyException`](crate::error::DuplicateSshPublicKeyException)
    pub fn builder() -> crate::error::duplicate_ssh_public_key_exception::Builder {
        crate::error::duplicate_ssh_public_key_exception::Builder::default()
    }
}

/// <p>The request processing has failed because of an unknown error, exception or
/// failure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceFailureException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceFailureException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceFailureException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceFailureException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceFailureException {}
/// See [`ServiceFailureException`](crate::error::ServiceFailureException)
pub mod service_failure_exception {
    /// A builder for [`ServiceFailureException`](crate::error::ServiceFailureException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceFailureException`](crate::error::ServiceFailureException)
        pub fn build(self) -> crate::error::ServiceFailureException {
            crate::error::ServiceFailureException {
                message: self.message,
            }
        }
    }
}
impl ServiceFailureException {
    /// Creates a new builder-style object to manufacture [`ServiceFailureException`](crate::error::ServiceFailureException)
    pub fn builder() -> crate::error::service_failure_exception::Builder {
        crate::error::service_failure_exception::Builder::default()
    }
}

/// <p>The request was rejected because the certificate was malformed or expired. The error
/// message describes the specific error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MalformedCertificateException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MalformedCertificateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MalformedCertificateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MalformedCertificateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MalformedCertificateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MalformedCertificateException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for MalformedCertificateException {}
/// See [`MalformedCertificateException`](crate::error::MalformedCertificateException)
pub mod malformed_certificate_exception {
    /// A builder for [`MalformedCertificateException`](crate::error::MalformedCertificateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MalformedCertificateException`](crate::error::MalformedCertificateException)
        pub fn build(self) -> crate::error::MalformedCertificateException {
            crate::error::MalformedCertificateException {
                message: self.message,
            }
        }
    }
}
impl MalformedCertificateException {
    /// Creates a new builder-style object to manufacture [`MalformedCertificateException`](crate::error::MalformedCertificateException)
    pub fn builder() -> crate::error::malformed_certificate_exception::Builder {
        crate::error::malformed_certificate_exception::Builder::default()
    }
}

/// <p>The request was rejected because the certificate is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidCertificateException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidCertificateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidCertificateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidCertificateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidCertificateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidCertificateException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidCertificateException {}
/// See [`InvalidCertificateException`](crate::error::InvalidCertificateException)
pub mod invalid_certificate_exception {
    /// A builder for [`InvalidCertificateException`](crate::error::InvalidCertificateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidCertificateException`](crate::error::InvalidCertificateException)
        pub fn build(self) -> crate::error::InvalidCertificateException {
            crate::error::InvalidCertificateException {
                message: self.message,
            }
        }
    }
}
impl InvalidCertificateException {
    /// Creates a new builder-style object to manufacture [`InvalidCertificateException`](crate::error::InvalidCertificateException)
    pub fn builder() -> crate::error::invalid_certificate_exception::Builder {
        crate::error::invalid_certificate_exception::Builder::default()
    }
}

/// <p>The request was rejected because it attempted to create a resource that already
/// exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntityAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EntityAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntityAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EntityAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EntityAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EntityAlreadyExistsException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for EntityAlreadyExistsException {}
/// See [`EntityAlreadyExistsException`](crate::error::EntityAlreadyExistsException)
pub mod entity_already_exists_exception {
    /// A builder for [`EntityAlreadyExistsException`](crate::error::EntityAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EntityAlreadyExistsException`](crate::error::EntityAlreadyExistsException)
        pub fn build(self) -> crate::error::EntityAlreadyExistsException {
            crate::error::EntityAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl EntityAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`EntityAlreadyExistsException`](crate::error::EntityAlreadyExistsException)
    pub fn builder() -> crate::error::entity_already_exists_exception::Builder {
        crate::error::entity_already_exists_exception::Builder::default()
    }
}

/// <p>The request was rejected because the same certificate is associated with an IAM user in
/// the account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DuplicateCertificateException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DuplicateCertificateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DuplicateCertificateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DuplicateCertificateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DuplicateCertificateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DuplicateCertificateException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for DuplicateCertificateException {}
/// See [`DuplicateCertificateException`](crate::error::DuplicateCertificateException)
pub mod duplicate_certificate_exception {
    /// A builder for [`DuplicateCertificateException`](crate::error::DuplicateCertificateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DuplicateCertificateException`](crate::error::DuplicateCertificateException)
        pub fn build(self) -> crate::error::DuplicateCertificateException {
            crate::error::DuplicateCertificateException {
                message: self.message,
            }
        }
    }
}
impl DuplicateCertificateException {
    /// Creates a new builder-style object to manufacture [`DuplicateCertificateException`](crate::error::DuplicateCertificateException)
    pub fn builder() -> crate::error::duplicate_certificate_exception::Builder {
        crate::error::duplicate_certificate_exception::Builder::default()
    }
}

/// <p>The request was rejected because the public key certificate and the private key do not
/// match.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KeyPairMismatchException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KeyPairMismatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KeyPairMismatchException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KeyPairMismatchException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KeyPairMismatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KeyPairMismatchException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for KeyPairMismatchException {}
/// See [`KeyPairMismatchException`](crate::error::KeyPairMismatchException)
pub mod key_pair_mismatch_exception {
    /// A builder for [`KeyPairMismatchException`](crate::error::KeyPairMismatchException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KeyPairMismatchException`](crate::error::KeyPairMismatchException)
        pub fn build(self) -> crate::error::KeyPairMismatchException {
            crate::error::KeyPairMismatchException {
                message: self.message,
            }
        }
    }
}
impl KeyPairMismatchException {
    /// Creates a new builder-style object to manufacture [`KeyPairMismatchException`](crate::error::KeyPairMismatchException)
    pub fn builder() -> crate::error::key_pair_mismatch_exception::Builder {
        crate::error::key_pair_mismatch_exception::Builder::default()
    }
}

/// <p>The request was rejected because an invalid or out-of-range value was supplied for an
/// input parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidInputException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidInputException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidInputException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidInputException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidInputException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidInputException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidInputException {}
/// See [`InvalidInputException`](crate::error::InvalidInputException)
pub mod invalid_input_exception {
    /// A builder for [`InvalidInputException`](crate::error::InvalidInputException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidInputException`](crate::error::InvalidInputException)
        pub fn build(self) -> crate::error::InvalidInputException {
            crate::error::InvalidInputException {
                message: self.message,
            }
        }
    }
}
impl InvalidInputException {
    /// Creates a new builder-style object to manufacture [`InvalidInputException`](crate::error::InvalidInputException)
    pub fn builder() -> crate::error::invalid_input_exception::Builder {
        crate::error::invalid_input_exception::Builder::default()
    }
}

/// <p>The request was rejected because multiple requests to change this object were submitted
/// simultaneously. Wait a few minutes and submit your request again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConcurrentModificationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConcurrentModificationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConcurrentModificationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConcurrentModificationException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConcurrentModificationException {}
/// See [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
pub mod concurrent_modification_exception {
    /// A builder for [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
        pub fn build(self) -> crate::error::ConcurrentModificationException {
            crate::error::ConcurrentModificationException {
                message: self.message,
            }
        }
    }
}
impl ConcurrentModificationException {
    /// Creates a new builder-style object to manufacture [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    pub fn builder() -> crate::error::concurrent_modification_exception::Builder {
        crate::error::concurrent_modification_exception::Builder::default()
    }
}

/// <p>The request was rejected because it referenced an entity that is temporarily unmodifiable,
/// such as a user name that was deleted and then recreated. The error indicates that the request
/// is likely to succeed if you try again after waiting several minutes. The error message
/// describes the entity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntityTemporarilyUnmodifiableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EntityTemporarilyUnmodifiableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntityTemporarilyUnmodifiableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EntityTemporarilyUnmodifiableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EntityTemporarilyUnmodifiableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EntityTemporarilyUnmodifiableException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for EntityTemporarilyUnmodifiableException {}
/// See [`EntityTemporarilyUnmodifiableException`](crate::error::EntityTemporarilyUnmodifiableException)
pub mod entity_temporarily_unmodifiable_exception {
    /// A builder for [`EntityTemporarilyUnmodifiableException`](crate::error::EntityTemporarilyUnmodifiableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EntityTemporarilyUnmodifiableException`](crate::error::EntityTemporarilyUnmodifiableException)
        pub fn build(self) -> crate::error::EntityTemporarilyUnmodifiableException {
            crate::error::EntityTemporarilyUnmodifiableException {
                message: self.message,
            }
        }
    }
}
impl EntityTemporarilyUnmodifiableException {
    /// Creates a new builder-style object to manufacture [`EntityTemporarilyUnmodifiableException`](crate::error::EntityTemporarilyUnmodifiableException)
    pub fn builder() -> crate::error::entity_temporarily_unmodifiable_exception::Builder {
        crate::error::entity_temporarily_unmodifiable_exception::Builder::default()
    }
}

/// <p>The request was rejected because only the service that depends on the service-linked role
/// can modify or delete the role on your behalf. The error message includes the name of the
/// service that depends on this service-linked role. You must request the change through that
/// service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnmodifiableEntityException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnmodifiableEntityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnmodifiableEntityException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnmodifiableEntityException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnmodifiableEntityException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnmodifiableEntityException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnmodifiableEntityException {}
/// See [`UnmodifiableEntityException`](crate::error::UnmodifiableEntityException)
pub mod unmodifiable_entity_exception {
    /// A builder for [`UnmodifiableEntityException`](crate::error::UnmodifiableEntityException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnmodifiableEntityException`](crate::error::UnmodifiableEntityException)
        pub fn build(self) -> crate::error::UnmodifiableEntityException {
            crate::error::UnmodifiableEntityException {
                message: self.message,
            }
        }
    }
}
impl UnmodifiableEntityException {
    /// Creates a new builder-style object to manufacture [`UnmodifiableEntityException`](crate::error::UnmodifiableEntityException)
    pub fn builder() -> crate::error::unmodifiable_entity_exception::Builder {
        crate::error::unmodifiable_entity_exception::Builder::default()
    }
}

/// <p>The request was rejected because the provided password did not meet the requirements
/// imposed by the account password policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PasswordPolicyViolationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PasswordPolicyViolationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PasswordPolicyViolationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PasswordPolicyViolationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PasswordPolicyViolationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PasswordPolicyViolationException")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for PasswordPolicyViolationException {}
/// See [`PasswordPolicyViolationException`](crate::error::PasswordPolicyViolationException)
pub mod password_policy_violation_exception {
    /// A builder for [`PasswordPolicyViolationException`](crate::error::PasswordPolicyViolationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PasswordPolicyViolationException`](crate::error::PasswordPolicyViolationException)
        pub fn build(self) -> crate::error::PasswordPolicyViolationException {
            crate::error::PasswordPolicyViolationException {
                message: self.message,
            }
        }
    }
}
impl PasswordPolicyViolationException {
    /// Creates a new builder-style object to manufacture [`PasswordPolicyViolationException`](crate::error::PasswordPolicyViolationException)
    pub fn builder() -> crate::error::password_policy_violation_exception::Builder {
        crate::error::password_policy_violation_exception::Builder::default()
    }
}

/// <p>The request was rejected because the policy document was malformed. The error message
/// describes the specific error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MalformedPolicyDocumentException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MalformedPolicyDocumentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MalformedPolicyDocumentException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MalformedPolicyDocumentException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MalformedPolicyDocumentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MalformedPolicyDocumentException")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for MalformedPolicyDocumentException {}
/// See [`MalformedPolicyDocumentException`](crate::error::MalformedPolicyDocumentException)
pub mod malformed_policy_document_exception {
    /// A builder for [`MalformedPolicyDocumentException`](crate::error::MalformedPolicyDocumentException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MalformedPolicyDocumentException`](crate::error::MalformedPolicyDocumentException)
        pub fn build(self) -> crate::error::MalformedPolicyDocumentException {
            crate::error::MalformedPolicyDocumentException {
                message: self.message,
            }
        }
    }
}
impl MalformedPolicyDocumentException {
    /// Creates a new builder-style object to manufacture [`MalformedPolicyDocumentException`](crate::error::MalformedPolicyDocumentException)
    pub fn builder() -> crate::error::malformed_policy_document_exception::Builder {
        crate::error::malformed_policy_document_exception::Builder::default()
    }
}

/// <p>The request failed because a provided policy could not be successfully evaluated. An
/// additional detailed message indicates the source of the failure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyEvaluationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PolicyEvaluationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyEvaluationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PolicyEvaluationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PolicyEvaluationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PolicyEvaluationException")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for PolicyEvaluationException {}
/// See [`PolicyEvaluationException`](crate::error::PolicyEvaluationException)
pub mod policy_evaluation_exception {
    /// A builder for [`PolicyEvaluationException`](crate::error::PolicyEvaluationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyEvaluationException`](crate::error::PolicyEvaluationException)
        pub fn build(self) -> crate::error::PolicyEvaluationException {
            crate::error::PolicyEvaluationException {
                message: self.message,
            }
        }
    }
}
impl PolicyEvaluationException {
    /// Creates a new builder-style object to manufacture [`PolicyEvaluationException`](crate::error::PolicyEvaluationException)
    pub fn builder() -> crate::error::policy_evaluation_exception::Builder {
        crate::error::policy_evaluation_exception::Builder::default()
    }
}

/// <p>The request was rejected because the authentication code was not recognized. The error
/// message describes the specific error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidAuthenticationCodeException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidAuthenticationCodeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidAuthenticationCodeException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidAuthenticationCodeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidAuthenticationCodeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidAuthenticationCodeException")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidAuthenticationCodeException {}
/// See [`InvalidAuthenticationCodeException`](crate::error::InvalidAuthenticationCodeException)
pub mod invalid_authentication_code_exception {
    /// A builder for [`InvalidAuthenticationCodeException`](crate::error::InvalidAuthenticationCodeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidAuthenticationCodeException`](crate::error::InvalidAuthenticationCodeException)
        pub fn build(self) -> crate::error::InvalidAuthenticationCodeException {
            crate::error::InvalidAuthenticationCodeException {
                message: self.message,
            }
        }
    }
}
impl InvalidAuthenticationCodeException {
    /// Creates a new builder-style object to manufacture [`InvalidAuthenticationCodeException`](crate::error::InvalidAuthenticationCodeException)
    pub fn builder() -> crate::error::invalid_authentication_code_exception::Builder {
        crate::error::invalid_authentication_code_exception::Builder::default()
    }
}

/// <p>The request failed because Amazon Web Services service role policies can only be attached to the
/// service-linked role for that service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyNotAttachableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PolicyNotAttachableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyNotAttachableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PolicyNotAttachableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PolicyNotAttachableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PolicyNotAttachableException")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for PolicyNotAttachableException {}
/// See [`PolicyNotAttachableException`](crate::error::PolicyNotAttachableException)
pub mod policy_not_attachable_exception {
    /// A builder for [`PolicyNotAttachableException`](crate::error::PolicyNotAttachableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyNotAttachableException`](crate::error::PolicyNotAttachableException)
        pub fn build(self) -> crate::error::PolicyNotAttachableException {
            crate::error::PolicyNotAttachableException {
                message: self.message,
            }
        }
    }
}
impl PolicyNotAttachableException {
    /// Creates a new builder-style object to manufacture [`PolicyNotAttachableException`](crate::error::PolicyNotAttachableException)
    pub fn builder() -> crate::error::policy_not_attachable_exception::Builder {
        crate::error::policy_not_attachable_exception::Builder::default()
    }
}

/// <p>The specified service does not support service-specific credentials.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceNotSupportedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceNotSupportedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceNotSupportedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceNotSupportedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceNotSupportedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceNotSupportedException")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceNotSupportedException {}
/// See [`ServiceNotSupportedException`](crate::error::ServiceNotSupportedException)
pub mod service_not_supported_exception {
    /// A builder for [`ServiceNotSupportedException`](crate::error::ServiceNotSupportedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceNotSupportedException`](crate::error::ServiceNotSupportedException)
        pub fn build(self) -> crate::error::ServiceNotSupportedException {
            crate::error::ServiceNotSupportedException {
                message: self.message,
            }
        }
    }
}
impl ServiceNotSupportedException {
    /// Creates a new builder-style object to manufacture [`ServiceNotSupportedException`](crate::error::ServiceNotSupportedException)
    pub fn builder() -> crate::error::service_not_supported_exception::Builder {
        crate::error::service_not_supported_exception::Builder::default()
    }
}

/// <p>The request was rejected because the credential report is still being generated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CredentialReportNotReadyException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CredentialReportNotReadyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CredentialReportNotReadyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CredentialReportNotReadyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CredentialReportNotReadyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CredentialReportNotReadyException")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for CredentialReportNotReadyException {}
/// See [`CredentialReportNotReadyException`](crate::error::CredentialReportNotReadyException)
pub mod credential_report_not_ready_exception {
    /// A builder for [`CredentialReportNotReadyException`](crate::error::CredentialReportNotReadyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CredentialReportNotReadyException`](crate::error::CredentialReportNotReadyException)
        pub fn build(self) -> crate::error::CredentialReportNotReadyException {
            crate::error::CredentialReportNotReadyException {
                message: self.message,
            }
        }
    }
}
impl CredentialReportNotReadyException {
    /// Creates a new builder-style object to manufacture [`CredentialReportNotReadyException`](crate::error::CredentialReportNotReadyException)
    pub fn builder() -> crate::error::credential_report_not_ready_exception::Builder {
        crate::error::credential_report_not_ready_exception::Builder::default()
    }
}

/// <p>The request was rejected because the credential report does not exist. To generate a
/// credential report, use <a>GenerateCredentialReport</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CredentialReportNotPresentException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CredentialReportNotPresentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CredentialReportNotPresentException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CredentialReportNotPresentException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CredentialReportNotPresentException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CredentialReportNotPresentException")?;
        if let Some(inner_23) = &self.message {
            write!(f, ": {}", inner_23)?;
        }
        Ok(())
    }
}
impl std::error::Error for CredentialReportNotPresentException {}
/// See [`CredentialReportNotPresentException`](crate::error::CredentialReportNotPresentException)
pub mod credential_report_not_present_exception {
    /// A builder for [`CredentialReportNotPresentException`](crate::error::CredentialReportNotPresentException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CredentialReportNotPresentException`](crate::error::CredentialReportNotPresentException)
        pub fn build(self) -> crate::error::CredentialReportNotPresentException {
            crate::error::CredentialReportNotPresentException {
                message: self.message,
            }
        }
    }
}
impl CredentialReportNotPresentException {
    /// Creates a new builder-style object to manufacture [`CredentialReportNotPresentException`](crate::error::CredentialReportNotPresentException)
    pub fn builder() -> crate::error::credential_report_not_present_exception::Builder {
        crate::error::credential_report_not_present_exception::Builder::default()
    }
}

/// <p>The request was rejected because the most recent credential report has expired. To
/// generate a new credential report, use <a>GenerateCredentialReport</a>. For more
/// information about credential report expiration, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting credential reports</a> in the
/// <i>IAM User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CredentialReportExpiredException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CredentialReportExpiredException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CredentialReportExpiredException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CredentialReportExpiredException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CredentialReportExpiredException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CredentialReportExpiredException")?;
        if let Some(inner_24) = &self.message {
            write!(f, ": {}", inner_24)?;
        }
        Ok(())
    }
}
impl std::error::Error for CredentialReportExpiredException {}
/// See [`CredentialReportExpiredException`](crate::error::CredentialReportExpiredException)
pub mod credential_report_expired_exception {
    /// A builder for [`CredentialReportExpiredException`](crate::error::CredentialReportExpiredException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CredentialReportExpiredException`](crate::error::CredentialReportExpiredException)
        pub fn build(self) -> crate::error::CredentialReportExpiredException {
            crate::error::CredentialReportExpiredException {
                message: self.message,
            }
        }
    }
}
impl CredentialReportExpiredException {
    /// Creates a new builder-style object to manufacture [`CredentialReportExpiredException`](crate::error::CredentialReportExpiredException)
    pub fn builder() -> crate::error::credential_report_expired_exception::Builder {
        crate::error::credential_report_expired_exception::Builder::default()
    }
}

/// <p>The request failed because the maximum number of concurrent requests for this account are
/// already running.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReportGenerationLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ReportGenerationLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReportGenerationLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ReportGenerationLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ReportGenerationLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ReportGenerationLimitExceededException")?;
        if let Some(inner_25) = &self.message {
            write!(f, ": {}", inner_25)?;
        }
        Ok(())
    }
}
impl std::error::Error for ReportGenerationLimitExceededException {}
/// See [`ReportGenerationLimitExceededException`](crate::error::ReportGenerationLimitExceededException)
pub mod report_generation_limit_exceeded_exception {
    /// A builder for [`ReportGenerationLimitExceededException`](crate::error::ReportGenerationLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ReportGenerationLimitExceededException`](crate::error::ReportGenerationLimitExceededException)
        pub fn build(self) -> crate::error::ReportGenerationLimitExceededException {
            crate::error::ReportGenerationLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl ReportGenerationLimitExceededException {
    /// Creates a new builder-style object to manufacture [`ReportGenerationLimitExceededException`](crate::error::ReportGenerationLimitExceededException)
    pub fn builder() -> crate::error::report_generation_limit_exceeded_exception::Builder {
        crate::error::report_generation_limit_exceeded_exception::Builder::default()
    }
}

/// <p>The request was rejected because it attempted to delete a resource that has attached
/// subordinate entities. The error message describes these entities.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DeleteConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DeleteConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DeleteConflictException")?;
        if let Some(inner_26) = &self.message {
            write!(f, ": {}", inner_26)?;
        }
        Ok(())
    }
}
impl std::error::Error for DeleteConflictException {}
/// See [`DeleteConflictException`](crate::error::DeleteConflictException)
pub mod delete_conflict_exception {
    /// A builder for [`DeleteConflictException`](crate::error::DeleteConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConflictException`](crate::error::DeleteConflictException)
        pub fn build(self) -> crate::error::DeleteConflictException {
            crate::error::DeleteConflictException {
                message: self.message,
            }
        }
    }
}
impl DeleteConflictException {
    /// Creates a new builder-style object to manufacture [`DeleteConflictException`](crate::error::DeleteConflictException)
    pub fn builder() -> crate::error::delete_conflict_exception::Builder {
        crate::error::delete_conflict_exception::Builder::default()
    }
}

/// <p>The request was rejected because the type of user for the transaction was
/// incorrect.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidUserTypeException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidUserTypeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidUserTypeException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidUserTypeException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidUserTypeException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidUserTypeException")?;
        if let Some(inner_27) = &self.message {
            write!(f, ": {}", inner_27)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidUserTypeException {}
/// See [`InvalidUserTypeException`](crate::error::InvalidUserTypeException)
pub mod invalid_user_type_exception {
    /// A builder for [`InvalidUserTypeException`](crate::error::InvalidUserTypeException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidUserTypeException`](crate::error::InvalidUserTypeException)
        pub fn build(self) -> crate::error::InvalidUserTypeException {
            crate::error::InvalidUserTypeException {
                message: self.message,
            }
        }
    }
}
impl InvalidUserTypeException {
    /// Creates a new builder-style object to manufacture [`InvalidUserTypeException`](crate::error::InvalidUserTypeException)
    pub fn builder() -> crate::error::invalid_user_type_exception::Builder {
        crate::error::invalid_user_type_exception::Builder::default()
    }
}
