// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AddClientIdToOpenIdConnectProviderInput`](crate::input::AddClientIdToOpenIdConnectProviderInput)
pub mod add_client_id_to_open_id_connect_provider_input {
    /// A builder for [`AddClientIdToOpenIdConnectProviderInput`](crate::input::AddClientIdToOpenIdConnectProviderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) open_id_connect_provider_arn: std::option::Option<std::string::String>,
        pub(crate) client_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the IAM OpenID Connect (OIDC) provider resource to
        /// add the client ID to. You can get a list of OIDC provider ARNs by using the <a>ListOpenIDConnectProviders</a> operation.</p>
        pub fn open_id_connect_provider_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.open_id_connect_provider_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM OpenID Connect (OIDC) provider resource to
        /// add the client ID to. You can get a list of OIDC provider ARNs by using the <a>ListOpenIDConnectProviders</a> operation.</p>
        pub fn set_open_id_connect_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.open_id_connect_provider_arn = input;
            self
        }
        /// <p>The client ID (also known as audience) to add to the IAM OpenID Connect provider
        /// resource.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The client ID (also known as audience) to add to the IAM OpenID Connect provider
        /// resource.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AddClientIdToOpenIdConnectProviderInput`](crate::input::AddClientIdToOpenIdConnectProviderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddClientIdToOpenIdConnectProviderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddClientIdToOpenIdConnectProviderInput {
                open_id_connect_provider_arn: self.open_id_connect_provider_arn,
                client_id: self.client_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AddClientIdToOpenIdConnectProviderInputOperationOutputAlias =
    crate::operation::AddClientIDToOpenIDConnectProvider;
#[doc(hidden)]
pub type AddClientIdToOpenIdConnectProviderInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddClientIdToOpenIdConnectProviderInput {
    /// Consumes the builder and constructs an Operation<[`AddClientIDToOpenIDConnectProvider`](crate::operation::AddClientIDToOpenIDConnectProvider)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddClientIDToOpenIDConnectProvider,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddClientIdToOpenIdConnectProviderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddClientIdToOpenIdConnectProviderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddClientIdToOpenIdConnectProviderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_client_id_to_open_id_connect_provider(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddClientIDToOpenIDConnectProvider::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddClientIDToOpenIDConnectProvider",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddClientIdToOpenIdConnectProviderInput`](crate::input::AddClientIdToOpenIdConnectProviderInput)
    pub fn builder() -> crate::input::add_client_id_to_open_id_connect_provider_input::Builder {
        crate::input::add_client_id_to_open_id_connect_provider_input::Builder::default()
    }
}

/// See [`AddRoleToInstanceProfileInput`](crate::input::AddRoleToInstanceProfileInput)
pub mod add_role_to_instance_profile_input {
    /// A builder for [`AddRoleToInstanceProfileInput`](crate::input::AddRoleToInstanceProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_profile_name: std::option::Option<std::string::String>,
        pub(crate) role_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the instance profile to update.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn instance_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_profile_name = Some(input.into());
            self
        }
        /// <p>The name of the instance profile to update.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_instance_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_profile_name = input;
            self
        }
        /// <p>The name of the role to add.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>The name of the role to add.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AddRoleToInstanceProfileInput`](crate::input::AddRoleToInstanceProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddRoleToInstanceProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddRoleToInstanceProfileInput {
                instance_profile_name: self.instance_profile_name,
                role_name: self.role_name,
            })
        }
    }
}
#[doc(hidden)]
pub type AddRoleToInstanceProfileInputOperationOutputAlias =
    crate::operation::AddRoleToInstanceProfile;
#[doc(hidden)]
pub type AddRoleToInstanceProfileInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddRoleToInstanceProfileInput {
    /// Consumes the builder and constructs an Operation<[`AddRoleToInstanceProfile`](crate::operation::AddRoleToInstanceProfile)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddRoleToInstanceProfile,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddRoleToInstanceProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddRoleToInstanceProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddRoleToInstanceProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_role_to_instance_profile(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddRoleToInstanceProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddRoleToInstanceProfile",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddRoleToInstanceProfileInput`](crate::input::AddRoleToInstanceProfileInput)
    pub fn builder() -> crate::input::add_role_to_instance_profile_input::Builder {
        crate::input::add_role_to_instance_profile_input::Builder::default()
    }
}

/// See [`AddUserToGroupInput`](crate::input::AddUserToGroupInput)
pub mod add_user_to_group_input {
    /// A builder for [`AddUserToGroupInput`](crate::input::AddUserToGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the group to update.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the group to update.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The name of the user to add.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the user to add.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AddUserToGroupInput`](crate::input::AddUserToGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddUserToGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddUserToGroupInput {
                group_name: self.group_name,
                user_name: self.user_name,
            })
        }
    }
}
#[doc(hidden)]
pub type AddUserToGroupInputOperationOutputAlias = crate::operation::AddUserToGroup;
#[doc(hidden)]
pub type AddUserToGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddUserToGroupInput {
    /// Consumes the builder and constructs an Operation<[`AddUserToGroup`](crate::operation::AddUserToGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddUserToGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddUserToGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddUserToGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddUserToGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_user_to_group(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddUserToGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddUserToGroup",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddUserToGroupInput`](crate::input::AddUserToGroupInput)
    pub fn builder() -> crate::input::add_user_to_group_input::Builder {
        crate::input::add_user_to_group_input::Builder::default()
    }
}

/// See [`AttachGroupPolicyInput`](crate::input::AttachGroupPolicyInput)
pub mod attach_group_policy_input {
    /// A builder for [`AttachGroupPolicyInput`](crate::input::AttachGroupPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) policy_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name (friendly name, not ARN) of the group to attach the policy to.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name (friendly name, not ARN) of the group to attach the policy to.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to attach.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to attach.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachGroupPolicyInput`](crate::input::AttachGroupPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AttachGroupPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AttachGroupPolicyInput {
                group_name: self.group_name,
                policy_arn: self.policy_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type AttachGroupPolicyInputOperationOutputAlias = crate::operation::AttachGroupPolicy;
#[doc(hidden)]
pub type AttachGroupPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AttachGroupPolicyInput {
    /// Consumes the builder and constructs an Operation<[`AttachGroupPolicy`](crate::operation::AttachGroupPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AttachGroupPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AttachGroupPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AttachGroupPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AttachGroupPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_attach_group_policy(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AttachGroupPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AttachGroupPolicy",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AttachGroupPolicyInput`](crate::input::AttachGroupPolicyInput)
    pub fn builder() -> crate::input::attach_group_policy_input::Builder {
        crate::input::attach_group_policy_input::Builder::default()
    }
}

/// See [`AttachRolePolicyInput`](crate::input::AttachRolePolicyInput)
pub mod attach_role_policy_input {
    /// A builder for [`AttachRolePolicyInput`](crate::input::AttachRolePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_name: std::option::Option<std::string::String>,
        pub(crate) policy_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name (friendly name, not ARN) of the role to attach the policy to.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>The name (friendly name, not ARN) of the role to attach the policy to.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to attach.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to attach.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachRolePolicyInput`](crate::input::AttachRolePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AttachRolePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AttachRolePolicyInput {
                role_name: self.role_name,
                policy_arn: self.policy_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type AttachRolePolicyInputOperationOutputAlias = crate::operation::AttachRolePolicy;
#[doc(hidden)]
pub type AttachRolePolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AttachRolePolicyInput {
    /// Consumes the builder and constructs an Operation<[`AttachRolePolicy`](crate::operation::AttachRolePolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AttachRolePolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AttachRolePolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AttachRolePolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AttachRolePolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_attach_role_policy(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AttachRolePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AttachRolePolicy",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AttachRolePolicyInput`](crate::input::AttachRolePolicyInput)
    pub fn builder() -> crate::input::attach_role_policy_input::Builder {
        crate::input::attach_role_policy_input::Builder::default()
    }
}

/// See [`AttachUserPolicyInput`](crate::input::AttachUserPolicyInput)
pub mod attach_user_policy_input {
    /// A builder for [`AttachUserPolicyInput`](crate::input::AttachUserPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) policy_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name (friendly name, not ARN) of the IAM user to attach the policy to.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name (friendly name, not ARN) of the IAM user to attach the policy to.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to attach.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to attach.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachUserPolicyInput`](crate::input::AttachUserPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AttachUserPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AttachUserPolicyInput {
                user_name: self.user_name,
                policy_arn: self.policy_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type AttachUserPolicyInputOperationOutputAlias = crate::operation::AttachUserPolicy;
#[doc(hidden)]
pub type AttachUserPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AttachUserPolicyInput {
    /// Consumes the builder and constructs an Operation<[`AttachUserPolicy`](crate::operation::AttachUserPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AttachUserPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AttachUserPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AttachUserPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AttachUserPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_attach_user_policy(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AttachUserPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AttachUserPolicy",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AttachUserPolicyInput`](crate::input::AttachUserPolicyInput)
    pub fn builder() -> crate::input::attach_user_policy_input::Builder {
        crate::input::attach_user_policy_input::Builder::default()
    }
}

/// See [`ChangePasswordInput`](crate::input::ChangePasswordInput)
pub mod change_password_input {
    /// A builder for [`ChangePasswordInput`](crate::input::ChangePasswordInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) old_password: std::option::Option<std::string::String>,
        pub(crate) new_password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The IAM user's current password.</p>
        pub fn old_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.old_password = Some(input.into());
            self
        }
        /// <p>The IAM user's current password.</p>
        pub fn set_old_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.old_password = input;
            self
        }
        /// <p>The new password. The new password must conform to the Amazon Web Services account's password
        /// policy, if one exists.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// that is used to validate this parameter is a string of characters. That string can include almost any printable
        /// ASCII character from the space (<code>\u0020</code>) through the end of the ASCII character range (<code>\u00FF</code>).
        /// You can also include the tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)
        /// characters. Any of these characters are valid in a password. However, many tools, such
        /// as the Amazon Web Services Management Console, might restrict the ability to type certain characters because they have
        /// special meaning within that tool.</p>
        pub fn new_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.new_password = Some(input.into());
            self
        }
        /// <p>The new password. The new password must conform to the Amazon Web Services account's password
        /// policy, if one exists.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// that is used to validate this parameter is a string of characters. That string can include almost any printable
        /// ASCII character from the space (<code>\u0020</code>) through the end of the ASCII character range (<code>\u00FF</code>).
        /// You can also include the tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)
        /// characters. Any of these characters are valid in a password. However, many tools, such
        /// as the Amazon Web Services Management Console, might restrict the ability to type certain characters because they have
        /// special meaning within that tool.</p>
        pub fn set_new_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.new_password = input;
            self
        }
        /// Consumes the builder and constructs a [`ChangePasswordInput`](crate::input::ChangePasswordInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ChangePasswordInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ChangePasswordInput {
                old_password: self.old_password,
                new_password: self.new_password,
            })
        }
    }
}
#[doc(hidden)]
pub type ChangePasswordInputOperationOutputAlias = crate::operation::ChangePassword;
#[doc(hidden)]
pub type ChangePasswordInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ChangePasswordInput {
    /// Consumes the builder and constructs an Operation<[`ChangePassword`](crate::operation::ChangePassword)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ChangePassword,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ChangePasswordInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ChangePasswordInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ChangePasswordInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_change_password(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ChangePassword::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ChangePassword",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ChangePasswordInput`](crate::input::ChangePasswordInput)
    pub fn builder() -> crate::input::change_password_input::Builder {
        crate::input::change_password_input::Builder::default()
    }
}

/// See [`CreateAccessKeyInput`](crate::input::CreateAccessKeyInput)
pub mod create_access_key_input {
    /// A builder for [`CreateAccessKeyInput`](crate::input::CreateAccessKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the IAM user that the new key will belong to.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM user that the new key will belong to.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAccessKeyInput`](crate::input::CreateAccessKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAccessKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAccessKeyInput {
                user_name: self.user_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAccessKeyInputOperationOutputAlias = crate::operation::CreateAccessKey;
#[doc(hidden)]
pub type CreateAccessKeyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateAccessKeyInput {
    /// Consumes the builder and constructs an Operation<[`CreateAccessKey`](crate::operation::CreateAccessKey)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAccessKey,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAccessKeyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAccessKeyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAccessKeyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_access_key(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAccessKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAccessKey",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAccessKeyInput`](crate::input::CreateAccessKeyInput)
    pub fn builder() -> crate::input::create_access_key_input::Builder {
        crate::input::create_access_key_input::Builder::default()
    }
}

/// See [`CreateAccountAliasInput`](crate::input::CreateAccountAliasInput)
pub mod create_account_alias_input {
    /// A builder for [`CreateAccountAliasInput`](crate::input::CreateAccountAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_alias: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account alias to create.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of
        /// lowercase letters, digits, and dashes. You cannot start or finish with a dash, nor can you have
        /// two dashes in a row.</p>
        pub fn account_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_alias = Some(input.into());
            self
        }
        /// <p>The account alias to create.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of
        /// lowercase letters, digits, and dashes. You cannot start or finish with a dash, nor can you have
        /// two dashes in a row.</p>
        pub fn set_account_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.account_alias = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAccountAliasInput`](crate::input::CreateAccountAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAccountAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAccountAliasInput {
                account_alias: self.account_alias,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAccountAliasInputOperationOutputAlias = crate::operation::CreateAccountAlias;
#[doc(hidden)]
pub type CreateAccountAliasInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateAccountAliasInput {
    /// Consumes the builder and constructs an Operation<[`CreateAccountAlias`](crate::operation::CreateAccountAlias)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAccountAlias,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAccountAliasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAccountAliasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAccountAliasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_account_alias(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAccountAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAccountAlias",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAccountAliasInput`](crate::input::CreateAccountAliasInput)
    pub fn builder() -> crate::input::create_account_alias_input::Builder {
        crate::input::create_account_alias_input::Builder::default()
    }
}

/// See [`CreateGroupInput`](crate::input::CreateGroupInput)
pub mod create_group_input {
    /// A builder for [`CreateGroupInput`](crate::input::CreateGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The path to the group. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p> The path to the group. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The name of the group to create. Do not include the path in this value.</p>
        /// <p>IAM user, group, role, and policy names must be unique within the account. Names are
        /// not distinguished by case. For example, you cannot create resources named both
        /// "MyResource" and "myresource".</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the group to create. Do not include the path in this value.</p>
        /// <p>IAM user, group, role, and policy names must be unique within the account. Names are
        /// not distinguished by case. For example, you cannot create resources named both
        /// "MyResource" and "myresource".</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGroupInput`](crate::input::CreateGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateGroupInput {
                path: self.path,
                group_name: self.group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateGroupInputOperationOutputAlias = crate::operation::CreateGroup;
#[doc(hidden)]
pub type CreateGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateGroup`](crate::operation::CreateGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_group(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateGroup",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateGroupInput`](crate::input::CreateGroupInput)
    pub fn builder() -> crate::input::create_group_input::Builder {
        crate::input::create_group_input::Builder::default()
    }
}

/// See [`CreateInstanceProfileInput`](crate::input::CreateInstanceProfileInput)
pub mod create_instance_profile_input {
    /// A builder for [`CreateInstanceProfileInput`](crate::input::CreateInstanceProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_profile_name: std::option::Option<std::string::String>,
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the instance profile to create.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn instance_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_profile_name = Some(input.into());
            self
        }
        /// <p>The name of the instance profile to create.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_instance_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_profile_name = input;
            self
        }
        /// <p> The path to the instance profile. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// Identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p> The path to the instance profile. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// Identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you want to attach to the newly created IAM instance profile.
        /// Each tag consists of a key name and an associated value. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
        /// fails and the resource is not created.</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags that you want to attach to the newly created IAM instance profile.
        /// Each tag consists of a key name and an associated value. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
        /// fails and the resource is not created.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateInstanceProfileInput`](crate::input::CreateInstanceProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateInstanceProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateInstanceProfileInput {
                instance_profile_name: self.instance_profile_name,
                path: self.path,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateInstanceProfileInputOperationOutputAlias = crate::operation::CreateInstanceProfile;
#[doc(hidden)]
pub type CreateInstanceProfileInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateInstanceProfileInput {
    /// Consumes the builder and constructs an Operation<[`CreateInstanceProfile`](crate::operation::CreateInstanceProfile)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateInstanceProfile,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateInstanceProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateInstanceProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateInstanceProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_instance_profile(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateInstanceProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateInstanceProfile",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateInstanceProfileInput`](crate::input::CreateInstanceProfileInput)
    pub fn builder() -> crate::input::create_instance_profile_input::Builder {
        crate::input::create_instance_profile_input::Builder::default()
    }
}

/// See [`CreateLoginProfileInput`](crate::input::CreateLoginProfileInput)
pub mod create_login_profile_input {
    /// A builder for [`CreateLoginProfileInput`](crate::input::CreateLoginProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) password_reset_required: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the IAM user to create a password for. The user must already
        /// exist.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM user to create a password for. The user must already
        /// exist.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The new password for the user.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// that is used to validate this parameter is a string of characters. That string can include almost any printable
        /// ASCII character from the space (<code>\u0020</code>) through the end of the ASCII character range (<code>\u00FF</code>).
        /// You can also include the tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)
        /// characters. Any of these characters are valid in a password. However, many tools, such
        /// as the Amazon Web Services Management Console, might restrict the ability to type certain characters because they have
        /// special meaning within that tool.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>The new password for the user.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// that is used to validate this parameter is a string of characters. That string can include almost any printable
        /// ASCII character from the space (<code>\u0020</code>) through the end of the ASCII character range (<code>\u00FF</code>).
        /// You can also include the tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)
        /// characters. Any of these characters are valid in a password. However, many tools, such
        /// as the Amazon Web Services Management Console, might restrict the ability to type certain characters because they have
        /// special meaning within that tool.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p>Specifies whether the user is required to set a new password on next sign-in.</p>
        pub fn password_reset_required(mut self, input: bool) -> Self {
            self.password_reset_required = Some(input);
            self
        }
        /// <p>Specifies whether the user is required to set a new password on next sign-in.</p>
        pub fn set_password_reset_required(mut self, input: std::option::Option<bool>) -> Self {
            self.password_reset_required = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLoginProfileInput`](crate::input::CreateLoginProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLoginProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLoginProfileInput {
                user_name: self.user_name,
                password: self.password,
                password_reset_required: self.password_reset_required.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLoginProfileInputOperationOutputAlias = crate::operation::CreateLoginProfile;
#[doc(hidden)]
pub type CreateLoginProfileInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateLoginProfileInput {
    /// Consumes the builder and constructs an Operation<[`CreateLoginProfile`](crate::operation::CreateLoginProfile)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLoginProfile,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateLoginProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateLoginProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateLoginProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_login_profile(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLoginProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLoginProfile",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateLoginProfileInput`](crate::input::CreateLoginProfileInput)
    pub fn builder() -> crate::input::create_login_profile_input::Builder {
        crate::input::create_login_profile_input::Builder::default()
    }
}

/// See [`CreateOpenIdConnectProviderInput`](crate::input::CreateOpenIdConnectProviderInput)
pub mod create_open_id_connect_provider_input {
    /// A builder for [`CreateOpenIdConnectProviderInput`](crate::input::CreateOpenIdConnectProviderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) client_id_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) thumbprint_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The URL of the identity provider. The URL must begin with <code>https://</code> and
        /// should correspond to the <code>iss</code> claim in the provider's OpenID Connect ID
        /// tokens. Per the OIDC standard, path components are allowed but query parameters are not.
        /// Typically the URL consists of only a hostname, like
        /// <code>https://server.example.org</code> or <code>https://example.com</code>. The URL
        /// should not contain a port number. </p>
        /// <p>You cannot register the same provider multiple times in a single Amazon Web Services account. If you
        /// try to submit a URL that has already been used for an OpenID Connect provider in the
        /// Amazon Web Services account, you will get an error.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The URL of the identity provider. The URL must begin with <code>https://</code> and
        /// should correspond to the <code>iss</code> claim in the provider's OpenID Connect ID
        /// tokens. Per the OIDC standard, path components are allowed but query parameters are not.
        /// Typically the URL consists of only a hostname, like
        /// <code>https://server.example.org</code> or <code>https://example.com</code>. The URL
        /// should not contain a port number. </p>
        /// <p>You cannot register the same provider multiple times in a single Amazon Web Services account. If you
        /// try to submit a URL that has already been used for an OpenID Connect provider in the
        /// Amazon Web Services account, you will get an error.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Appends an item to `client_id_list`.
        ///
        /// To override the contents of this collection use [`set_client_id_list`](Self::set_client_id_list).
        ///
        /// <p>Provides a list of client IDs, also known as audiences. When a mobile or web app registers
        /// with an OpenID Connect provider, they establish a value that identifies the application.
        /// This is the value that's sent as the <code>client_id</code> parameter on OAuth
        /// requests.</p>
        /// <p>You can register multiple client IDs with the same provider. For example, you might
        /// have multiple applications that use the same OIDC provider. You cannot register more
        /// than 100 client IDs with a single IAM OIDC provider.</p>
        /// <p>There is no defined format for a client ID. The
        /// <code>CreateOpenIDConnectProviderRequest</code> operation accepts client IDs up to
        /// 255 characters long.</p>
        pub fn client_id_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.client_id_list.unwrap_or_default();
            v.push(input.into());
            self.client_id_list = Some(v);
            self
        }
        /// <p>Provides a list of client IDs, also known as audiences. When a mobile or web app registers
        /// with an OpenID Connect provider, they establish a value that identifies the application.
        /// This is the value that's sent as the <code>client_id</code> parameter on OAuth
        /// requests.</p>
        /// <p>You can register multiple client IDs with the same provider. For example, you might
        /// have multiple applications that use the same OIDC provider. You cannot register more
        /// than 100 client IDs with a single IAM OIDC provider.</p>
        /// <p>There is no defined format for a client ID. The
        /// <code>CreateOpenIDConnectProviderRequest</code> operation accepts client IDs up to
        /// 255 characters long.</p>
        pub fn set_client_id_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.client_id_list = input;
            self
        }
        /// Appends an item to `thumbprint_list`.
        ///
        /// To override the contents of this collection use [`set_thumbprint_list`](Self::set_thumbprint_list).
        ///
        /// <p>A list of server certificate thumbprints for the OpenID Connect (OIDC) identity
        /// provider's server certificates. Typically this list includes only one entry. However,
        /// IAM lets you have up to five thumbprints for an OIDC provider. This lets you maintain
        /// multiple thumbprints if the identity provider is rotating certificates.</p>
        /// <p>The server certificate thumbprint is the hex-encoded SHA-1 hash value of the X.509
        /// certificate used by the domain where the OpenID Connect provider makes its keys
        /// available. It is always a 40-character string.</p>
        /// <p>You must provide at least one thumbprint when creating an IAM OIDC provider. For
        /// example, assume that the OIDC provider is <code>server.example.com</code> and the
        /// provider stores its keys at https://keys.server.example.com/openid-connect. In that
        /// case, the thumbprint string would be the hex-encoded SHA-1 hash value of the certificate
        /// used by <code>https://keys.server.example.com.</code>
        /// </p>
        /// <p>For more information about obtaining the OIDC provider thumbprint, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/identity-providers-oidc-obtain-thumbprint.html">Obtaining the
        /// thumbprint for an OpenID Connect provider</a> in the <i>IAM User
        /// Guide</i>.</p>
        pub fn thumbprint_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.thumbprint_list.unwrap_or_default();
            v.push(input.into());
            self.thumbprint_list = Some(v);
            self
        }
        /// <p>A list of server certificate thumbprints for the OpenID Connect (OIDC) identity
        /// provider's server certificates. Typically this list includes only one entry. However,
        /// IAM lets you have up to five thumbprints for an OIDC provider. This lets you maintain
        /// multiple thumbprints if the identity provider is rotating certificates.</p>
        /// <p>The server certificate thumbprint is the hex-encoded SHA-1 hash value of the X.509
        /// certificate used by the domain where the OpenID Connect provider makes its keys
        /// available. It is always a 40-character string.</p>
        /// <p>You must provide at least one thumbprint when creating an IAM OIDC provider. For
        /// example, assume that the OIDC provider is <code>server.example.com</code> and the
        /// provider stores its keys at https://keys.server.example.com/openid-connect. In that
        /// case, the thumbprint string would be the hex-encoded SHA-1 hash value of the certificate
        /// used by <code>https://keys.server.example.com.</code>
        /// </p>
        /// <p>For more information about obtaining the OIDC provider thumbprint, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/identity-providers-oidc-obtain-thumbprint.html">Obtaining the
        /// thumbprint for an OpenID Connect provider</a> in the <i>IAM User
        /// Guide</i>.</p>
        pub fn set_thumbprint_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.thumbprint_list = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you want to attach to the new IAM OpenID Connect (OIDC) provider.
        /// Each tag consists of a key name and an associated value. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
        /// fails and the resource is not created.</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags that you want to attach to the new IAM OpenID Connect (OIDC) provider.
        /// Each tag consists of a key name and an associated value. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
        /// fails and the resource is not created.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateOpenIdConnectProviderInput`](crate::input::CreateOpenIdConnectProviderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateOpenIdConnectProviderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateOpenIdConnectProviderInput {
                url: self.url,
                client_id_list: self.client_id_list,
                thumbprint_list: self.thumbprint_list,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateOpenIdConnectProviderInputOperationOutputAlias =
    crate::operation::CreateOpenIDConnectProvider;
#[doc(hidden)]
pub type CreateOpenIdConnectProviderInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateOpenIdConnectProviderInput {
    /// Consumes the builder and constructs an Operation<[`CreateOpenIDConnectProvider`](crate::operation::CreateOpenIDConnectProvider)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateOpenIDConnectProvider,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateOpenIdConnectProviderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateOpenIdConnectProviderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateOpenIdConnectProviderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_open_id_connect_provider(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateOpenIDConnectProvider::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateOpenIDConnectProvider",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateOpenIdConnectProviderInput`](crate::input::CreateOpenIdConnectProviderInput)
    pub fn builder() -> crate::input::create_open_id_connect_provider_input::Builder {
        crate::input::create_open_id_connect_provider_input::Builder::default()
    }
}

/// See [`CreatePolicyInput`](crate::input::CreatePolicyInput)
pub mod create_policy_input {
    /// A builder for [`CreatePolicyInput`](crate::input::CreatePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) policy_document: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The friendly name of the policy.</p>
        /// <p>IAM user, group, role, and policy names must be unique within the account. Names are
        /// not distinguished by case. For example, you cannot create resources named both
        /// "MyResource" and "myresource".</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The friendly name of the policy.</p>
        /// <p>IAM user, group, role, and policy names must be unique within the account. Names are
        /// not distinguished by case. For example, you cannot create resources named both
        /// "MyResource" and "myresource".</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The path for the policy.</p>
        /// <p>For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        /// <note>
        /// <p>You cannot use an asterisk (*) in the path name.</p>
        /// </note>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The path for the policy.</p>
        /// <p>For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM identifiers</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        /// <note>
        /// <p>You cannot use an asterisk (*) in the path name.</p>
        /// </note>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The JSON policy document that you want to use as the content for the new
        /// policy.</p>
        /// <p>You must provide policies in JSON format in IAM. However, for CloudFormation
        /// templates formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to JSON format before submitting it to
        ///
        /// IAM.</p>
        /// <p>The maximum length of the policy document that you can pass in this operation,
        /// including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length">IAM and STS character quotas</a>.</p>
        /// <p>To learn more about JSON policy grammar, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_grammar.html">Grammar of the IAM JSON
        /// policy language</a> in the <i>IAM User Guide</i>. </p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_document = Some(input.into());
            self
        }
        /// <p>The JSON policy document that you want to use as the content for the new
        /// policy.</p>
        /// <p>You must provide policies in JSON format in IAM. However, for CloudFormation
        /// templates formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to JSON format before submitting it to
        ///
        /// IAM.</p>
        /// <p>The maximum length of the policy document that you can pass in this operation,
        /// including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length">IAM and STS character quotas</a>.</p>
        /// <p>To learn more about JSON policy grammar, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_grammar.html">Grammar of the IAM JSON
        /// policy language</a> in the <i>IAM User Guide</i>. </p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_document = input;
            self
        }
        /// <p>A friendly description of the policy.</p>
        /// <p>Typically used to store information about the permissions defined in the policy. For
        /// example, "Grants access to production DynamoDB tables."</p>
        /// <p>The policy description is immutable. After a value is assigned, it cannot be
        /// changed.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A friendly description of the policy.</p>
        /// <p>Typically used to store information about the permissions defined in the policy. For
        /// example, "Grants access to production DynamoDB tables."</p>
        /// <p>The policy description is immutable. After a value is assigned, it cannot be
        /// changed.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you want to attach to the new IAM customer managed policy.
        /// Each tag consists of a key name and an associated value. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
        /// fails and the resource is not created.</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags that you want to attach to the new IAM customer managed policy.
        /// Each tag consists of a key name and an associated value. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
        /// fails and the resource is not created.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePolicyInput`](crate::input::CreatePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePolicyInput {
                policy_name: self.policy_name,
                path: self.path,
                policy_document: self.policy_document,
                description: self.description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePolicyInputOperationOutputAlias = crate::operation::CreatePolicy;
#[doc(hidden)]
pub type CreatePolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreatePolicyInput {
    /// Consumes the builder and constructs an Operation<[`CreatePolicy`](crate::operation::CreatePolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreatePolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreatePolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreatePolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_policy(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePolicy",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreatePolicyInput`](crate::input::CreatePolicyInput)
    pub fn builder() -> crate::input::create_policy_input::Builder {
        crate::input::create_policy_input::Builder::default()
    }
}

/// See [`CreatePolicyVersionInput`](crate::input::CreatePolicyVersionInput)
pub mod create_policy_version_input {
    /// A builder for [`CreatePolicyVersionInput`](crate::input::CreatePolicyVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_arn: std::option::Option<std::string::String>,
        pub(crate) policy_document: std::option::Option<std::string::String>,
        pub(crate) set_as_default: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the IAM policy to which you want to add a new
        /// version.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy to which you want to add a new
        /// version.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// <p>The JSON policy document that you want to use as the content for this new version of
        /// the policy.</p>
        /// <p>You must provide policies in JSON format in IAM. However, for CloudFormation
        /// templates formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to JSON format before submitting it to
        /// IAM.</p>
        /// <p>The maximum length of the policy document that you can pass in this operation,
        /// including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length">IAM and STS character quotas</a>.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_document = Some(input.into());
            self
        }
        /// <p>The JSON policy document that you want to use as the content for this new version of
        /// the policy.</p>
        /// <p>You must provide policies in JSON format in IAM. However, for CloudFormation
        /// templates formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to JSON format before submitting it to
        /// IAM.</p>
        /// <p>The maximum length of the policy document that you can pass in this operation,
        /// including whitespace, is listed below. To view the maximum character counts of a managed policy with no whitespaces, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length">IAM and STS character quotas</a>.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_document = input;
            self
        }
        /// <p>Specifies whether to set this version as the policy's default version.</p>
        /// <p>When this parameter is <code>true</code>, the new policy version becomes the operative
        /// version. That is, it becomes the version that is in effect for the IAM users, groups,
        /// and roles that the policy is attached to.</p>
        /// <p>For more information about managed policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
        /// policies</a> in the <i>IAM User Guide</i>.</p>
        pub fn set_as_default(mut self, input: bool) -> Self {
            self.set_as_default = Some(input);
            self
        }
        /// <p>Specifies whether to set this version as the policy's default version.</p>
        /// <p>When this parameter is <code>true</code>, the new policy version becomes the operative
        /// version. That is, it becomes the version that is in effect for the IAM users, groups,
        /// and roles that the policy is attached to.</p>
        /// <p>For more information about managed policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
        /// policies</a> in the <i>IAM User Guide</i>.</p>
        pub fn set_set_as_default(mut self, input: std::option::Option<bool>) -> Self {
            self.set_as_default = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePolicyVersionInput`](crate::input::CreatePolicyVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePolicyVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePolicyVersionInput {
                policy_arn: self.policy_arn,
                policy_document: self.policy_document,
                set_as_default: self.set_as_default.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePolicyVersionInputOperationOutputAlias = crate::operation::CreatePolicyVersion;
#[doc(hidden)]
pub type CreatePolicyVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreatePolicyVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreatePolicyVersion`](crate::operation::CreatePolicyVersion)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePolicyVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreatePolicyVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreatePolicyVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreatePolicyVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_policy_version(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePolicyVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePolicyVersion",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreatePolicyVersionInput`](crate::input::CreatePolicyVersionInput)
    pub fn builder() -> crate::input::create_policy_version_input::Builder {
        crate::input::create_policy_version_input::Builder::default()
    }
}

/// See [`CreateRoleInput`](crate::input::CreateRoleInput)
pub mod create_role_input {
    /// A builder for [`CreateRoleInput`](crate::input::CreateRoleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) role_name: std::option::Option<std::string::String>,
        pub(crate) assume_role_policy_document: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) max_session_duration: std::option::Option<i32>,
        pub(crate) permissions_boundary: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p> The path to the role. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// Identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p> The path to the role. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// Identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The name of the role to create.</p>
        /// <p>IAM user, group, role, and policy names must be unique within the account. Names are
        /// not distinguished by case. For example, you cannot create resources named both
        /// "MyResource" and "myresource".</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>The name of the role to create.</p>
        /// <p>IAM user, group, role, and policy names must be unique within the account. Names are
        /// not distinguished by case. For example, you cannot create resources named both
        /// "MyResource" and "myresource".</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// <p>The trust relationship policy document that grants an entity permission to assume the
        /// role.</p>
        /// <p>In IAM, you must provide a JSON policy that has been converted to a string. However,
        /// for CloudFormation templates formatted in YAML, you can provide the policy in JSON
        /// or YAML format. CloudFormation always converts a YAML policy to JSON format before
        /// submitting it to IAM.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        /// <p> Upon success, the response includes the same trust policy in JSON format.</p>
        pub fn assume_role_policy_document(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.assume_role_policy_document = Some(input.into());
            self
        }
        /// <p>The trust relationship policy document that grants an entity permission to assume the
        /// role.</p>
        /// <p>In IAM, you must provide a JSON policy that has been converted to a string. However,
        /// for CloudFormation templates formatted in YAML, you can provide the policy in JSON
        /// or YAML format. CloudFormation always converts a YAML policy to JSON format before
        /// submitting it to IAM.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        /// <p> Upon success, the response includes the same trust policy in JSON format.</p>
        pub fn set_assume_role_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assume_role_policy_document = input;
            self
        }
        /// <p>A description of the role.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the role.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The maximum session duration (in seconds) that you want to set for the specified role.
        /// If you do not specify a value for this setting, the default maximum of one hour is
        /// applied. This setting can have a value from 1 hour to 12 hours.</p>
        /// <p>Anyone who assumes the role from the  or API can use the
        /// <code>DurationSeconds</code> API parameter or the <code>duration-seconds</code> CLI
        /// parameter to request a longer session. The <code>MaxSessionDuration</code> setting
        /// determines the maximum duration that can be requested using the
        /// <code>DurationSeconds</code> parameter. If users don't specify a value for the
        /// <code>DurationSeconds</code> parameter, their security credentials are valid for one
        /// hour by default. This applies when you use the <code>AssumeRole*</code> API operations
        /// or the <code>assume-role*</code> CLI operations but does not apply when you use those
        /// operations to create a console URL. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html">Using IAM
        /// roles</a> in the <i>IAM User Guide</i>.</p>
        pub fn max_session_duration(mut self, input: i32) -> Self {
            self.max_session_duration = Some(input);
            self
        }
        /// <p>The maximum session duration (in seconds) that you want to set for the specified role.
        /// If you do not specify a value for this setting, the default maximum of one hour is
        /// applied. This setting can have a value from 1 hour to 12 hours.</p>
        /// <p>Anyone who assumes the role from the  or API can use the
        /// <code>DurationSeconds</code> API parameter or the <code>duration-seconds</code> CLI
        /// parameter to request a longer session. The <code>MaxSessionDuration</code> setting
        /// determines the maximum duration that can be requested using the
        /// <code>DurationSeconds</code> parameter. If users don't specify a value for the
        /// <code>DurationSeconds</code> parameter, their security credentials are valid for one
        /// hour by default. This applies when you use the <code>AssumeRole*</code> API operations
        /// or the <code>assume-role*</code> CLI operations but does not apply when you use those
        /// operations to create a console URL. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html">Using IAM
        /// roles</a> in the <i>IAM User Guide</i>.</p>
        pub fn set_max_session_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.max_session_duration = input;
            self
        }
        /// <p>The ARN of the policy that is used to set the permissions boundary for the
        /// role.</p>
        pub fn permissions_boundary(mut self, input: impl Into<std::string::String>) -> Self {
            self.permissions_boundary = Some(input.into());
            self
        }
        /// <p>The ARN of the policy that is used to set the permissions boundary for the
        /// role.</p>
        pub fn set_permissions_boundary(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permissions_boundary = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you want to attach to the new role. Each tag consists of a key name and an associated value.
        /// For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
        /// fails and the resource is not created.</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags that you want to attach to the new role. Each tag consists of a key name and an associated value.
        /// For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
        /// fails and the resource is not created.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRoleInput`](crate::input::CreateRoleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRoleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRoleInput {
                path: self.path,
                role_name: self.role_name,
                assume_role_policy_document: self.assume_role_policy_document,
                description: self.description,
                max_session_duration: self.max_session_duration,
                permissions_boundary: self.permissions_boundary,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRoleInputOperationOutputAlias = crate::operation::CreateRole;
#[doc(hidden)]
pub type CreateRoleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateRoleInput {
    /// Consumes the builder and constructs an Operation<[`CreateRole`](crate::operation::CreateRole)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRole,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateRoleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateRoleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateRoleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_role(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRole::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRole",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateRoleInput`](crate::input::CreateRoleInput)
    pub fn builder() -> crate::input::create_role_input::Builder {
        crate::input::create_role_input::Builder::default()
    }
}

/// See [`CreateSamlProviderInput`](crate::input::CreateSamlProviderInput)
pub mod create_saml_provider_input {
    /// A builder for [`CreateSamlProviderInput`](crate::input::CreateSamlProviderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) saml_metadata_document: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>An XML document generated by an identity provider (IdP) that supports SAML 2.0. The
        /// document includes the issuer's name, expiration information, and keys that can be used
        /// to validate the SAML authentication response (assertions) that are received from the
        /// IdP. You must generate the metadata document using the identity management software that
        /// is used as your organization's IdP.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html">About SAML 2.0-based
        /// federation</a> in the <i>IAM User Guide</i>
        /// </p>
        pub fn saml_metadata_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.saml_metadata_document = Some(input.into());
            self
        }
        /// <p>An XML document generated by an identity provider (IdP) that supports SAML 2.0. The
        /// document includes the issuer's name, expiration information, and keys that can be used
        /// to validate the SAML authentication response (assertions) that are received from the
        /// IdP. You must generate the metadata document using the identity management software that
        /// is used as your organization's IdP.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html">About SAML 2.0-based
        /// federation</a> in the <i>IAM User Guide</i>
        /// </p>
        pub fn set_saml_metadata_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.saml_metadata_document = input;
            self
        }
        /// <p>The name of the provider to create.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the provider to create.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you want to attach to the new IAM SAML provider.
        /// Each tag consists of a key name and an associated value. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
        /// fails and the resource is not created.</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags that you want to attach to the new IAM SAML provider.
        /// Each tag consists of a key name and an associated value. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
        /// fails and the resource is not created.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSamlProviderInput`](crate::input::CreateSamlProviderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSamlProviderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSamlProviderInput {
                saml_metadata_document: self.saml_metadata_document,
                name: self.name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSamlProviderInputOperationOutputAlias = crate::operation::CreateSAMLProvider;
#[doc(hidden)]
pub type CreateSamlProviderInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateSamlProviderInput {
    /// Consumes the builder and constructs an Operation<[`CreateSAMLProvider`](crate::operation::CreateSAMLProvider)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSAMLProvider,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSamlProviderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSamlProviderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSamlProviderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_saml_provider(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSAMLProvider::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSAMLProvider",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSamlProviderInput`](crate::input::CreateSamlProviderInput)
    pub fn builder() -> crate::input::create_saml_provider_input::Builder {
        crate::input::create_saml_provider_input::Builder::default()
    }
}

/// See [`CreateServiceLinkedRoleInput`](crate::input::CreateServiceLinkedRoleInput)
pub mod create_service_linked_role_input {
    /// A builder for [`CreateServiceLinkedRoleInput`](crate::input::CreateServiceLinkedRoleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_service_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) custom_suffix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The service principal for the Amazon Web Services service to which this role is attached. You use a
        /// string similar to a URL but without the http:// in front. For example:
        /// <code>elasticbeanstalk.amazonaws.com</code>. </p>
        /// <p>Service principals are unique and case-sensitive. To find the exact service principal
        /// for your service-linked role, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-services-that-work-with-iam.html">Amazon Web Services services
        /// that work with IAM</a> in the <i>IAM User Guide</i>. Look for
        /// the services that have <b>Yes </b>in the <b>Service-Linked Role</b> column. Choose the <b>Yes</b> link to view the service-linked role documentation for that
        /// service.</p>
        pub fn aws_service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_service_name = Some(input.into());
            self
        }
        /// <p>The service principal for the Amazon Web Services service to which this role is attached. You use a
        /// string similar to a URL but without the http:// in front. For example:
        /// <code>elasticbeanstalk.amazonaws.com</code>. </p>
        /// <p>Service principals are unique and case-sensitive. To find the exact service principal
        /// for your service-linked role, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-services-that-work-with-iam.html">Amazon Web Services services
        /// that work with IAM</a> in the <i>IAM User Guide</i>. Look for
        /// the services that have <b>Yes </b>in the <b>Service-Linked Role</b> column. Choose the <b>Yes</b> link to view the service-linked role documentation for that
        /// service.</p>
        pub fn set_aws_service_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_service_name = input;
            self
        }
        /// <p>The description of the role.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the role.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p></p>
        /// <p>A string that you provide, which is combined with the service-provided prefix to form
        /// the complete role name. If you make multiple requests for the same service, then you
        /// must supply a different <code>CustomSuffix</code> for each request. Otherwise the
        /// request fails with a duplicate role name error. For example, you could add
        /// <code>-1</code> or <code>-debug</code> to the suffix.</p>
        /// <p>Some services do not support the <code>CustomSuffix</code> parameter. If you provide
        /// an optional suffix and the operation fails, try the operation again without the
        /// suffix.</p>
        pub fn custom_suffix(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_suffix = Some(input.into());
            self
        }
        /// <p></p>
        /// <p>A string that you provide, which is combined with the service-provided prefix to form
        /// the complete role name. If you make multiple requests for the same service, then you
        /// must supply a different <code>CustomSuffix</code> for each request. Otherwise the
        /// request fails with a duplicate role name error. For example, you could add
        /// <code>-1</code> or <code>-debug</code> to the suffix.</p>
        /// <p>Some services do not support the <code>CustomSuffix</code> parameter. If you provide
        /// an optional suffix and the operation fails, try the operation again without the
        /// suffix.</p>
        pub fn set_custom_suffix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_suffix = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateServiceLinkedRoleInput`](crate::input::CreateServiceLinkedRoleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateServiceLinkedRoleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateServiceLinkedRoleInput {
                aws_service_name: self.aws_service_name,
                description: self.description,
                custom_suffix: self.custom_suffix,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateServiceLinkedRoleInputOperationOutputAlias =
    crate::operation::CreateServiceLinkedRole;
#[doc(hidden)]
pub type CreateServiceLinkedRoleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateServiceLinkedRoleInput {
    /// Consumes the builder and constructs an Operation<[`CreateServiceLinkedRole`](crate::operation::CreateServiceLinkedRole)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateServiceLinkedRole,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateServiceLinkedRoleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateServiceLinkedRoleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateServiceLinkedRoleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_service_linked_role(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateServiceLinkedRole::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateServiceLinkedRole",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateServiceLinkedRoleInput`](crate::input::CreateServiceLinkedRoleInput)
    pub fn builder() -> crate::input::create_service_linked_role_input::Builder {
        crate::input::create_service_linked_role_input::Builder::default()
    }
}

/// See [`CreateServiceSpecificCredentialInput`](crate::input::CreateServiceSpecificCredentialInput)
pub mod create_service_specific_credential_input {
    /// A builder for [`CreateServiceSpecificCredentialInput`](crate::input::CreateServiceSpecificCredentialInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) service_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the IAM user that is to be associated with the credentials. The new
        /// service-specific credentials have the same permissions as the associated user except
        /// that they can be used only to access the specified service.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM user that is to be associated with the credentials. The new
        /// service-specific credentials have the same permissions as the associated user except
        /// that they can be used only to access the specified service.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The name of the Amazon Web Services service that is to be associated with the credentials. The
        /// service you specify here is the only service that can be accessed using these
        /// credentials.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Web Services service that is to be associated with the credentials. The
        /// service you specify here is the only service that can be accessed using these
        /// credentials.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateServiceSpecificCredentialInput`](crate::input::CreateServiceSpecificCredentialInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateServiceSpecificCredentialInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateServiceSpecificCredentialInput {
                user_name: self.user_name,
                service_name: self.service_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateServiceSpecificCredentialInputOperationOutputAlias =
    crate::operation::CreateServiceSpecificCredential;
#[doc(hidden)]
pub type CreateServiceSpecificCredentialInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateServiceSpecificCredentialInput {
    /// Consumes the builder and constructs an Operation<[`CreateServiceSpecificCredential`](crate::operation::CreateServiceSpecificCredential)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateServiceSpecificCredential,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateServiceSpecificCredentialInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateServiceSpecificCredentialInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateServiceSpecificCredentialInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_service_specific_credential(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateServiceSpecificCredential::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateServiceSpecificCredential",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateServiceSpecificCredentialInput`](crate::input::CreateServiceSpecificCredentialInput)
    pub fn builder() -> crate::input::create_service_specific_credential_input::Builder {
        crate::input::create_service_specific_credential_input::Builder::default()
    }
}

/// See [`CreateUserInput`](crate::input::CreateUserInput)
pub mod create_user_input {
    /// A builder for [`CreateUserInput`](crate::input::CreateUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) permissions_boundary: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p> The path for the user name. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p> The path for the user name. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The name of the user to create.</p>
        /// <p>IAM user, group, role, and policy names must be unique within the account. Names are
        /// not distinguished by case. For example, you cannot create resources named both
        /// "MyResource" and "myresource".</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the user to create.</p>
        /// <p>IAM user, group, role, and policy names must be unique within the account. Names are
        /// not distinguished by case. For example, you cannot create resources named both
        /// "MyResource" and "myresource".</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The ARN of the policy that is used to set the permissions boundary for the
        /// user.</p>
        pub fn permissions_boundary(mut self, input: impl Into<std::string::String>) -> Self {
            self.permissions_boundary = Some(input.into());
            self
        }
        /// <p>The ARN of the policy that is used to set the permissions boundary for the
        /// user.</p>
        pub fn set_permissions_boundary(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permissions_boundary = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you want to attach to the new user. Each tag consists of a key name and an associated value.
        /// For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
        /// fails and the resource is not created.</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags that you want to attach to the new user. Each tag consists of a key name and an associated value.
        /// For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
        /// fails and the resource is not created.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserInput`](crate::input::CreateUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUserInput {
                path: self.path,
                user_name: self.user_name,
                permissions_boundary: self.permissions_boundary,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateUserInputOperationOutputAlias = crate::operation::CreateUser;
#[doc(hidden)]
pub type CreateUserInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateUserInput {
    /// Consumes the builder and constructs an Operation<[`CreateUser`](crate::operation::CreateUser)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUser,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_user(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUser",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateUserInput`](crate::input::CreateUserInput)
    pub fn builder() -> crate::input::create_user_input::Builder {
        crate::input::create_user_input::Builder::default()
    }
}

/// See [`CreateVirtualMfaDeviceInput`](crate::input::CreateVirtualMfaDeviceInput)
pub mod create_virtual_mfa_device_input {
    /// A builder for [`CreateVirtualMfaDeviceInput`](crate::input::CreateVirtualMfaDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) virtual_mfa_device_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p> The path for the virtual MFA device. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p> The path for the virtual MFA device. For more information about paths, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM
        /// identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/).</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The name of the virtual MFA device. Use with path to uniquely identify a virtual MFA
        /// device.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn virtual_mfa_device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_mfa_device_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual MFA device. Use with path to uniquely identify a virtual MFA
        /// device.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_virtual_mfa_device_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_mfa_device_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags that you want to attach to the new IAM virtual MFA device.
        /// Each tag consists of a key name and an associated value. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
        /// fails and the resource is not created.</p>
        /// </note>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags that you want to attach to the new IAM virtual MFA device.
        /// Each tag consists of a key name and an associated value. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the
        /// <i>IAM User Guide</i>.</p>
        /// <note>
        /// <p>If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request
        /// fails and the resource is not created.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVirtualMfaDeviceInput`](crate::input::CreateVirtualMfaDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateVirtualMfaDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateVirtualMfaDeviceInput {
                path: self.path,
                virtual_mfa_device_name: self.virtual_mfa_device_name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateVirtualMfaDeviceInputOperationOutputAlias = crate::operation::CreateVirtualMFADevice;
#[doc(hidden)]
pub type CreateVirtualMfaDeviceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateVirtualMfaDeviceInput {
    /// Consumes the builder and constructs an Operation<[`CreateVirtualMFADevice`](crate::operation::CreateVirtualMFADevice)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateVirtualMFADevice,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateVirtualMfaDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateVirtualMfaDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateVirtualMfaDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_virtual_mfa_device(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateVirtualMFADevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateVirtualMFADevice",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateVirtualMfaDeviceInput`](crate::input::CreateVirtualMfaDeviceInput)
    pub fn builder() -> crate::input::create_virtual_mfa_device_input::Builder {
        crate::input::create_virtual_mfa_device_input::Builder::default()
    }
}

/// See [`DeactivateMfaDeviceInput`](crate::input::DeactivateMfaDeviceInput)
pub mod deactivate_mfa_device_input {
    /// A builder for [`DeactivateMfaDeviceInput`](crate::input::DeactivateMfaDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) serial_number: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the user whose MFA device you want to deactivate.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the user whose MFA device you want to deactivate.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The serial number that uniquely identifies the MFA device. For virtual MFA devices,
        /// the serial number is the device ARN.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of upper and lowercase alphanumeric characters with no spaces. You can also include any of the
        /// following characters: =,.@:/-</p>
        pub fn serial_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.serial_number = Some(input.into());
            self
        }
        /// <p>The serial number that uniquely identifies the MFA device. For virtual MFA devices,
        /// the serial number is the device ARN.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of upper and lowercase alphanumeric characters with no spaces. You can also include any of the
        /// following characters: =,.@:/-</p>
        pub fn set_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.serial_number = input;
            self
        }
        /// Consumes the builder and constructs a [`DeactivateMfaDeviceInput`](crate::input::DeactivateMfaDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeactivateMfaDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeactivateMfaDeviceInput {
                user_name: self.user_name,
                serial_number: self.serial_number,
            })
        }
    }
}
#[doc(hidden)]
pub type DeactivateMfaDeviceInputOperationOutputAlias = crate::operation::DeactivateMFADevice;
#[doc(hidden)]
pub type DeactivateMfaDeviceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeactivateMfaDeviceInput {
    /// Consumes the builder and constructs an Operation<[`DeactivateMFADevice`](crate::operation::DeactivateMFADevice)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeactivateMFADevice,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeactivateMfaDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeactivateMfaDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeactivateMfaDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deactivate_mfa_device(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeactivateMFADevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeactivateMFADevice",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeactivateMfaDeviceInput`](crate::input::DeactivateMfaDeviceInput)
    pub fn builder() -> crate::input::deactivate_mfa_device_input::Builder {
        crate::input::deactivate_mfa_device_input::Builder::default()
    }
}

/// See [`DeleteAccessKeyInput`](crate::input::DeleteAccessKeyInput)
pub mod delete_access_key_input {
    /// A builder for [`DeleteAccessKeyInput`](crate::input::DeleteAccessKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) access_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the user whose access key pair you want to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the user whose access key pair you want to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The access key ID for the access key ID and secret access key you want to
        /// delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can
        /// consist of any upper or lowercased letter or digit.</p>
        pub fn access_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_key_id = Some(input.into());
            self
        }
        /// <p>The access key ID for the access key ID and secret access key you want to
        /// delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can
        /// consist of any upper or lowercased letter or digit.</p>
        pub fn set_access_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAccessKeyInput`](crate::input::DeleteAccessKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAccessKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAccessKeyInput {
                user_name: self.user_name,
                access_key_id: self.access_key_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAccessKeyInputOperationOutputAlias = crate::operation::DeleteAccessKey;
#[doc(hidden)]
pub type DeleteAccessKeyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAccessKeyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAccessKey`](crate::operation::DeleteAccessKey)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAccessKey,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAccessKeyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAccessKeyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAccessKeyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_access_key(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAccessKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAccessKey",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAccessKeyInput`](crate::input::DeleteAccessKeyInput)
    pub fn builder() -> crate::input::delete_access_key_input::Builder {
        crate::input::delete_access_key_input::Builder::default()
    }
}

/// See [`DeleteAccountAliasInput`](crate::input::DeleteAccountAliasInput)
pub mod delete_account_alias_input {
    /// A builder for [`DeleteAccountAliasInput`](crate::input::DeleteAccountAliasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_alias: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the account alias to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of
        /// lowercase letters, digits, and dashes. You cannot start or finish with a dash, nor can you have
        /// two dashes in a row.</p>
        pub fn account_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_alias = Some(input.into());
            self
        }
        /// <p>The name of the account alias to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of
        /// lowercase letters, digits, and dashes. You cannot start or finish with a dash, nor can you have
        /// two dashes in a row.</p>
        pub fn set_account_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.account_alias = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAccountAliasInput`](crate::input::DeleteAccountAliasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAccountAliasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAccountAliasInput {
                account_alias: self.account_alias,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAccountAliasInputOperationOutputAlias = crate::operation::DeleteAccountAlias;
#[doc(hidden)]
pub type DeleteAccountAliasInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAccountAliasInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAccountAlias`](crate::operation::DeleteAccountAlias)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAccountAlias,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAccountAliasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAccountAliasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAccountAliasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_account_alias(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAccountAlias::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAccountAlias",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAccountAliasInput`](crate::input::DeleteAccountAliasInput)
    pub fn builder() -> crate::input::delete_account_alias_input::Builder {
        crate::input::delete_account_alias_input::Builder::default()
    }
}

/// See [`DeleteAccountPasswordPolicyInput`](crate::input::DeleteAccountPasswordPolicyInput)
pub mod delete_account_password_policy_input {
    /// A builder for [`DeleteAccountPasswordPolicyInput`](crate::input::DeleteAccountPasswordPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAccountPasswordPolicyInput`](crate::input::DeleteAccountPasswordPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAccountPasswordPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAccountPasswordPolicyInput {})
        }
    }
}
#[doc(hidden)]
pub type DeleteAccountPasswordPolicyInputOperationOutputAlias =
    crate::operation::DeleteAccountPasswordPolicy;
#[doc(hidden)]
pub type DeleteAccountPasswordPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAccountPasswordPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAccountPasswordPolicy`](crate::operation::DeleteAccountPasswordPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAccountPasswordPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAccountPasswordPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAccountPasswordPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAccountPasswordPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_account_password_policy(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAccountPasswordPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAccountPasswordPolicy",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAccountPasswordPolicyInput`](crate::input::DeleteAccountPasswordPolicyInput)
    pub fn builder() -> crate::input::delete_account_password_policy_input::Builder {
        crate::input::delete_account_password_policy_input::Builder::default()
    }
}

/// See [`DeleteGroupInput`](crate::input::DeleteGroupInput)
pub mod delete_group_input {
    /// A builder for [`DeleteGroupInput`](crate::input::DeleteGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the IAM group to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM group to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGroupInput`](crate::input::DeleteGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteGroupInput {
                group_name: self.group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteGroupInputOperationOutputAlias = crate::operation::DeleteGroup;
#[doc(hidden)]
pub type DeleteGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteGroup`](crate::operation::DeleteGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_group(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteGroup",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteGroupInput`](crate::input::DeleteGroupInput)
    pub fn builder() -> crate::input::delete_group_input::Builder {
        crate::input::delete_group_input::Builder::default()
    }
}

/// See [`DeleteGroupPolicyInput`](crate::input::DeleteGroupPolicyInput)
pub mod delete_group_policy_input {
    /// A builder for [`DeleteGroupPolicyInput`](crate::input::DeleteGroupPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name (friendly name, not ARN) identifying the group that the policy is embedded
        /// in.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name (friendly name, not ARN) identifying the group that the policy is embedded
        /// in.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The name identifying the policy document to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name identifying the policy document to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGroupPolicyInput`](crate::input::DeleteGroupPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteGroupPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteGroupPolicyInput {
                group_name: self.group_name,
                policy_name: self.policy_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteGroupPolicyInputOperationOutputAlias = crate::operation::DeleteGroupPolicy;
#[doc(hidden)]
pub type DeleteGroupPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteGroupPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteGroupPolicy`](crate::operation::DeleteGroupPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteGroupPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteGroupPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteGroupPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteGroupPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_group_policy(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteGroupPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteGroupPolicy",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteGroupPolicyInput`](crate::input::DeleteGroupPolicyInput)
    pub fn builder() -> crate::input::delete_group_policy_input::Builder {
        crate::input::delete_group_policy_input::Builder::default()
    }
}

/// See [`DeleteInstanceProfileInput`](crate::input::DeleteInstanceProfileInput)
pub mod delete_instance_profile_input {
    /// A builder for [`DeleteInstanceProfileInput`](crate::input::DeleteInstanceProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_profile_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the instance profile to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn instance_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_profile_name = Some(input.into());
            self
        }
        /// <p>The name of the instance profile to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_instance_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_profile_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteInstanceProfileInput`](crate::input::DeleteInstanceProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteInstanceProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteInstanceProfileInput {
                instance_profile_name: self.instance_profile_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteInstanceProfileInputOperationOutputAlias = crate::operation::DeleteInstanceProfile;
#[doc(hidden)]
pub type DeleteInstanceProfileInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteInstanceProfileInput {
    /// Consumes the builder and constructs an Operation<[`DeleteInstanceProfile`](crate::operation::DeleteInstanceProfile)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteInstanceProfile,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteInstanceProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteInstanceProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteInstanceProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_instance_profile(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteInstanceProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteInstanceProfile",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteInstanceProfileInput`](crate::input::DeleteInstanceProfileInput)
    pub fn builder() -> crate::input::delete_instance_profile_input::Builder {
        crate::input::delete_instance_profile_input::Builder::default()
    }
}

/// See [`DeleteLoginProfileInput`](crate::input::DeleteLoginProfileInput)
pub mod delete_login_profile_input {
    /// A builder for [`DeleteLoginProfileInput`](crate::input::DeleteLoginProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the user whose password you want to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the user whose password you want to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLoginProfileInput`](crate::input::DeleteLoginProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteLoginProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteLoginProfileInput {
                user_name: self.user_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteLoginProfileInputOperationOutputAlias = crate::operation::DeleteLoginProfile;
#[doc(hidden)]
pub type DeleteLoginProfileInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteLoginProfileInput {
    /// Consumes the builder and constructs an Operation<[`DeleteLoginProfile`](crate::operation::DeleteLoginProfile)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteLoginProfile,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteLoginProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteLoginProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteLoginProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_login_profile(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteLoginProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteLoginProfile",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteLoginProfileInput`](crate::input::DeleteLoginProfileInput)
    pub fn builder() -> crate::input::delete_login_profile_input::Builder {
        crate::input::delete_login_profile_input::Builder::default()
    }
}

/// See [`DeleteOpenIdConnectProviderInput`](crate::input::DeleteOpenIdConnectProviderInput)
pub mod delete_open_id_connect_provider_input {
    /// A builder for [`DeleteOpenIdConnectProviderInput`](crate::input::DeleteOpenIdConnectProviderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) open_id_connect_provider_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the IAM OpenID Connect provider resource object to
        /// delete. You can get a list of OpenID Connect provider resource ARNs by using the <a>ListOpenIDConnectProviders</a> operation.</p>
        pub fn open_id_connect_provider_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.open_id_connect_provider_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM OpenID Connect provider resource object to
        /// delete. You can get a list of OpenID Connect provider resource ARNs by using the <a>ListOpenIDConnectProviders</a> operation.</p>
        pub fn set_open_id_connect_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.open_id_connect_provider_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteOpenIdConnectProviderInput`](crate::input::DeleteOpenIdConnectProviderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteOpenIdConnectProviderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteOpenIdConnectProviderInput {
                open_id_connect_provider_arn: self.open_id_connect_provider_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteOpenIdConnectProviderInputOperationOutputAlias =
    crate::operation::DeleteOpenIDConnectProvider;
#[doc(hidden)]
pub type DeleteOpenIdConnectProviderInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteOpenIdConnectProviderInput {
    /// Consumes the builder and constructs an Operation<[`DeleteOpenIDConnectProvider`](crate::operation::DeleteOpenIDConnectProvider)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteOpenIDConnectProvider,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteOpenIdConnectProviderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteOpenIdConnectProviderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteOpenIdConnectProviderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_open_id_connect_provider(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteOpenIDConnectProvider::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteOpenIDConnectProvider",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteOpenIdConnectProviderInput`](crate::input::DeleteOpenIdConnectProviderInput)
    pub fn builder() -> crate::input::delete_open_id_connect_provider_input::Builder {
        crate::input::delete_open_id_connect_provider_input::Builder::default()
    }
}

/// See [`DeletePolicyInput`](crate::input::DeletePolicyInput)
pub mod delete_policy_input {
    /// A builder for [`DeletePolicyInput`](crate::input::DeletePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to delete.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to delete.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePolicyInput`](crate::input::DeletePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePolicyInput {
                policy_arn: self.policy_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePolicyInputOperationOutputAlias = crate::operation::DeletePolicy;
#[doc(hidden)]
pub type DeletePolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeletePolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeletePolicy`](crate::operation::DeletePolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeletePolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeletePolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeletePolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_policy(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePolicy",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeletePolicyInput`](crate::input::DeletePolicyInput)
    pub fn builder() -> crate::input::delete_policy_input::Builder {
        crate::input::delete_policy_input::Builder::default()
    }
}

/// See [`DeletePolicyVersionInput`](crate::input::DeletePolicyVersionInput)
pub mod delete_policy_version_input {
    /// A builder for [`DeletePolicyVersionInput`](crate::input::DeletePolicyVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_arn: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the IAM policy from which you want to delete a
        /// version.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy from which you want to delete a
        /// version.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// <p>The policy version to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that
        /// consists of the lowercase letter 'v' followed by one or two digits, and optionally
        /// followed by a period '.' and a string of letters and digits.</p>
        /// <p>For more information about managed policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
        /// policies</a> in the <i>IAM User Guide</i>.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The policy version to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that
        /// consists of the lowercase letter 'v' followed by one or two digits, and optionally
        /// followed by a period '.' and a string of letters and digits.</p>
        /// <p>For more information about managed policy versions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for managed
        /// policies</a> in the <i>IAM User Guide</i>.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePolicyVersionInput`](crate::input::DeletePolicyVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePolicyVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePolicyVersionInput {
                policy_arn: self.policy_arn,
                version_id: self.version_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePolicyVersionInputOperationOutputAlias = crate::operation::DeletePolicyVersion;
#[doc(hidden)]
pub type DeletePolicyVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeletePolicyVersionInput {
    /// Consumes the builder and constructs an Operation<[`DeletePolicyVersion`](crate::operation::DeletePolicyVersion)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePolicyVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeletePolicyVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeletePolicyVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeletePolicyVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_policy_version(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePolicyVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePolicyVersion",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeletePolicyVersionInput`](crate::input::DeletePolicyVersionInput)
    pub fn builder() -> crate::input::delete_policy_version_input::Builder {
        crate::input::delete_policy_version_input::Builder::default()
    }
}

/// See [`DeleteRoleInput`](crate::input::DeleteRoleInput)
pub mod delete_role_input {
    /// A builder for [`DeleteRoleInput`](crate::input::DeleteRoleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the role to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>The name of the role to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRoleInput`](crate::input::DeleteRoleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRoleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRoleInput {
                role_name: self.role_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRoleInputOperationOutputAlias = crate::operation::DeleteRole;
#[doc(hidden)]
pub type DeleteRoleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteRoleInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRole`](crate::operation::DeleteRole)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRole,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRoleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRoleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRoleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_role(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRole::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRole",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRoleInput`](crate::input::DeleteRoleInput)
    pub fn builder() -> crate::input::delete_role_input::Builder {
        crate::input::delete_role_input::Builder::default()
    }
}

/// See [`DeleteRolePermissionsBoundaryInput`](crate::input::DeleteRolePermissionsBoundaryInput)
pub mod delete_role_permissions_boundary_input {
    /// A builder for [`DeleteRolePermissionsBoundaryInput`](crate::input::DeleteRolePermissionsBoundaryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name (friendly name, not ARN) of the IAM role from which you want to remove the
        /// permissions boundary.</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>The name (friendly name, not ARN) of the IAM role from which you want to remove the
        /// permissions boundary.</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRolePermissionsBoundaryInput`](crate::input::DeleteRolePermissionsBoundaryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRolePermissionsBoundaryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRolePermissionsBoundaryInput {
                role_name: self.role_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRolePermissionsBoundaryInputOperationOutputAlias =
    crate::operation::DeleteRolePermissionsBoundary;
#[doc(hidden)]
pub type DeleteRolePermissionsBoundaryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteRolePermissionsBoundaryInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRolePermissionsBoundary`](crate::operation::DeleteRolePermissionsBoundary)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRolePermissionsBoundary,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRolePermissionsBoundaryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRolePermissionsBoundaryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRolePermissionsBoundaryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_role_permissions_boundary(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRolePermissionsBoundary::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRolePermissionsBoundary",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRolePermissionsBoundaryInput`](crate::input::DeleteRolePermissionsBoundaryInput)
    pub fn builder() -> crate::input::delete_role_permissions_boundary_input::Builder {
        crate::input::delete_role_permissions_boundary_input::Builder::default()
    }
}

/// See [`DeleteRolePolicyInput`](crate::input::DeleteRolePolicyInput)
pub mod delete_role_policy_input {
    /// A builder for [`DeleteRolePolicyInput`](crate::input::DeleteRolePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_name: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name (friendly name, not ARN) identifying the role that the policy is embedded
        /// in.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>The name (friendly name, not ARN) identifying the role that the policy is embedded
        /// in.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// <p>The name of the inline policy to delete from the specified IAM role.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the inline policy to delete from the specified IAM role.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRolePolicyInput`](crate::input::DeleteRolePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRolePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRolePolicyInput {
                role_name: self.role_name,
                policy_name: self.policy_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRolePolicyInputOperationOutputAlias = crate::operation::DeleteRolePolicy;
#[doc(hidden)]
pub type DeleteRolePolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteRolePolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRolePolicy`](crate::operation::DeleteRolePolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRolePolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRolePolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRolePolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRolePolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_role_policy(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRolePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRolePolicy",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRolePolicyInput`](crate::input::DeleteRolePolicyInput)
    pub fn builder() -> crate::input::delete_role_policy_input::Builder {
        crate::input::delete_role_policy_input::Builder::default()
    }
}

/// See [`DeleteSamlProviderInput`](crate::input::DeleteSamlProviderInput)
pub mod delete_saml_provider_input {
    /// A builder for [`DeleteSamlProviderInput`](crate::input::DeleteSamlProviderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) saml_provider_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the SAML provider to delete.</p>
        pub fn saml_provider_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.saml_provider_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SAML provider to delete.</p>
        pub fn set_saml_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.saml_provider_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSamlProviderInput`](crate::input::DeleteSamlProviderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSamlProviderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSamlProviderInput {
                saml_provider_arn: self.saml_provider_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSamlProviderInputOperationOutputAlias = crate::operation::DeleteSAMLProvider;
#[doc(hidden)]
pub type DeleteSamlProviderInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteSamlProviderInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSAMLProvider`](crate::operation::DeleteSAMLProvider)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSAMLProvider,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSamlProviderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSamlProviderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSamlProviderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_saml_provider(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSAMLProvider::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSAMLProvider",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSamlProviderInput`](crate::input::DeleteSamlProviderInput)
    pub fn builder() -> crate::input::delete_saml_provider_input::Builder {
        crate::input::delete_saml_provider_input::Builder::default()
    }
}

/// See [`DeleteServerCertificateInput`](crate::input::DeleteServerCertificateInput)
pub mod delete_server_certificate_input {
    /// A builder for [`DeleteServerCertificateInput`](crate::input::DeleteServerCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_certificate_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the server certificate you want to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn server_certificate_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_certificate_name = Some(input.into());
            self
        }
        /// <p>The name of the server certificate you want to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_server_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.server_certificate_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteServerCertificateInput`](crate::input::DeleteServerCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteServerCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteServerCertificateInput {
                server_certificate_name: self.server_certificate_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteServerCertificateInputOperationOutputAlias =
    crate::operation::DeleteServerCertificate;
#[doc(hidden)]
pub type DeleteServerCertificateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteServerCertificateInput {
    /// Consumes the builder and constructs an Operation<[`DeleteServerCertificate`](crate::operation::DeleteServerCertificate)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteServerCertificate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteServerCertificateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteServerCertificateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteServerCertificateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_server_certificate(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteServerCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteServerCertificate",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteServerCertificateInput`](crate::input::DeleteServerCertificateInput)
    pub fn builder() -> crate::input::delete_server_certificate_input::Builder {
        crate::input::delete_server_certificate_input::Builder::default()
    }
}

/// See [`DeleteServiceLinkedRoleInput`](crate::input::DeleteServiceLinkedRoleInput)
pub mod delete_service_linked_role_input {
    /// A builder for [`DeleteServiceLinkedRoleInput`](crate::input::DeleteServiceLinkedRoleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the service-linked role to be deleted.</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>The name of the service-linked role to be deleted.</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteServiceLinkedRoleInput`](crate::input::DeleteServiceLinkedRoleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteServiceLinkedRoleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteServiceLinkedRoleInput {
                role_name: self.role_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteServiceLinkedRoleInputOperationOutputAlias =
    crate::operation::DeleteServiceLinkedRole;
#[doc(hidden)]
pub type DeleteServiceLinkedRoleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteServiceLinkedRoleInput {
    /// Consumes the builder and constructs an Operation<[`DeleteServiceLinkedRole`](crate::operation::DeleteServiceLinkedRole)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteServiceLinkedRole,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteServiceLinkedRoleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteServiceLinkedRoleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteServiceLinkedRoleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_service_linked_role(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteServiceLinkedRole::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteServiceLinkedRole",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteServiceLinkedRoleInput`](crate::input::DeleteServiceLinkedRoleInput)
    pub fn builder() -> crate::input::delete_service_linked_role_input::Builder {
        crate::input::delete_service_linked_role_input::Builder::default()
    }
}

/// See [`DeleteServiceSpecificCredentialInput`](crate::input::DeleteServiceSpecificCredentialInput)
pub mod delete_service_specific_credential_input {
    /// A builder for [`DeleteServiceSpecificCredentialInput`](crate::input::DeleteServiceSpecificCredentialInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) service_specific_credential_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the IAM user associated with the service-specific credential. If this
        /// value is not specified, then the operation assumes the user whose credentials are used
        /// to call the operation.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM user associated with the service-specific credential. If this
        /// value is not specified, then the operation assumes the user whose credentials are used
        /// to call the operation.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The unique identifier of the service-specific credential. You can get this value by
        /// calling <a>ListServiceSpecificCredentials</a>.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can
        /// consist of any upper or lowercased letter or digit.</p>
        pub fn service_specific_credential_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.service_specific_credential_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the service-specific credential. You can get this value by
        /// calling <a>ListServiceSpecificCredentials</a>.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can
        /// consist of any upper or lowercased letter or digit.</p>
        pub fn set_service_specific_credential_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_specific_credential_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteServiceSpecificCredentialInput`](crate::input::DeleteServiceSpecificCredentialInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteServiceSpecificCredentialInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteServiceSpecificCredentialInput {
                user_name: self.user_name,
                service_specific_credential_id: self.service_specific_credential_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteServiceSpecificCredentialInputOperationOutputAlias =
    crate::operation::DeleteServiceSpecificCredential;
#[doc(hidden)]
pub type DeleteServiceSpecificCredentialInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteServiceSpecificCredentialInput {
    /// Consumes the builder and constructs an Operation<[`DeleteServiceSpecificCredential`](crate::operation::DeleteServiceSpecificCredential)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteServiceSpecificCredential,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteServiceSpecificCredentialInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteServiceSpecificCredentialInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteServiceSpecificCredentialInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_service_specific_credential(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteServiceSpecificCredential::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteServiceSpecificCredential",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteServiceSpecificCredentialInput`](crate::input::DeleteServiceSpecificCredentialInput)
    pub fn builder() -> crate::input::delete_service_specific_credential_input::Builder {
        crate::input::delete_service_specific_credential_input::Builder::default()
    }
}

/// See [`DeleteSigningCertificateInput`](crate::input::DeleteSigningCertificateInput)
pub mod delete_signing_certificate_input {
    /// A builder for [`DeleteSigningCertificateInput`](crate::input::DeleteSigningCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) certificate_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the user the signing certificate belongs to.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the user the signing certificate belongs to.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The ID of the signing certificate to delete.</p>
        /// <p>The format of this parameter, as described by its <a href="http://wikipedia.org/wiki/regex">regex</a> pattern, is a string of
        /// characters that can be upper- or lower-cased letters or digits.</p>
        pub fn certificate_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_id = Some(input.into());
            self
        }
        /// <p>The ID of the signing certificate to delete.</p>
        /// <p>The format of this parameter, as described by its <a href="http://wikipedia.org/wiki/regex">regex</a> pattern, is a string of
        /// characters that can be upper- or lower-cased letters or digits.</p>
        pub fn set_certificate_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSigningCertificateInput`](crate::input::DeleteSigningCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSigningCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSigningCertificateInput {
                user_name: self.user_name,
                certificate_id: self.certificate_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSigningCertificateInputOperationOutputAlias =
    crate::operation::DeleteSigningCertificate;
#[doc(hidden)]
pub type DeleteSigningCertificateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteSigningCertificateInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSigningCertificate`](crate::operation::DeleteSigningCertificate)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSigningCertificate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSigningCertificateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSigningCertificateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSigningCertificateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_signing_certificate(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSigningCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSigningCertificate",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSigningCertificateInput`](crate::input::DeleteSigningCertificateInput)
    pub fn builder() -> crate::input::delete_signing_certificate_input::Builder {
        crate::input::delete_signing_certificate_input::Builder::default()
    }
}

/// See [`DeleteSshPublicKeyInput`](crate::input::DeleteSshPublicKeyInput)
pub mod delete_ssh_public_key_input {
    /// A builder for [`DeleteSshPublicKeyInput`](crate::input::DeleteSshPublicKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) ssh_public_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the IAM user associated with the SSH public key.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM user associated with the SSH public key.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The unique identifier for the SSH public key.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can
        /// consist of any upper or lowercased letter or digit.</p>
        pub fn ssh_public_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_public_key_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the SSH public key.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can
        /// consist of any upper or lowercased letter or digit.</p>
        pub fn set_ssh_public_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssh_public_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSshPublicKeyInput`](crate::input::DeleteSshPublicKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSshPublicKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSshPublicKeyInput {
                user_name: self.user_name,
                ssh_public_key_id: self.ssh_public_key_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSshPublicKeyInputOperationOutputAlias = crate::operation::DeleteSSHPublicKey;
#[doc(hidden)]
pub type DeleteSshPublicKeyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteSshPublicKeyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSSHPublicKey`](crate::operation::DeleteSSHPublicKey)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSSHPublicKey,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSshPublicKeyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSshPublicKeyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSshPublicKeyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_ssh_public_key(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSSHPublicKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSSHPublicKey",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSshPublicKeyInput`](crate::input::DeleteSshPublicKeyInput)
    pub fn builder() -> crate::input::delete_ssh_public_key_input::Builder {
        crate::input::delete_ssh_public_key_input::Builder::default()
    }
}

/// See [`DeleteUserInput`](crate::input::DeleteUserInput)
pub mod delete_user_input {
    /// A builder for [`DeleteUserInput`](crate::input::DeleteUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the user to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the user to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUserInput`](crate::input::DeleteUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUserInput {
                user_name: self.user_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUserInputOperationOutputAlias = crate::operation::DeleteUser;
#[doc(hidden)]
pub type DeleteUserInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteUserInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUser`](crate::operation::DeleteUser)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUser,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_user(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUser",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteUserInput`](crate::input::DeleteUserInput)
    pub fn builder() -> crate::input::delete_user_input::Builder {
        crate::input::delete_user_input::Builder::default()
    }
}

/// See [`DeleteUserPermissionsBoundaryInput`](crate::input::DeleteUserPermissionsBoundaryInput)
pub mod delete_user_permissions_boundary_input {
    /// A builder for [`DeleteUserPermissionsBoundaryInput`](crate::input::DeleteUserPermissionsBoundaryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name (friendly name, not ARN) of the IAM user from which you want to remove the
        /// permissions boundary.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name (friendly name, not ARN) of the IAM user from which you want to remove the
        /// permissions boundary.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUserPermissionsBoundaryInput`](crate::input::DeleteUserPermissionsBoundaryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUserPermissionsBoundaryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUserPermissionsBoundaryInput {
                user_name: self.user_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUserPermissionsBoundaryInputOperationOutputAlias =
    crate::operation::DeleteUserPermissionsBoundary;
#[doc(hidden)]
pub type DeleteUserPermissionsBoundaryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteUserPermissionsBoundaryInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUserPermissionsBoundary`](crate::operation::DeleteUserPermissionsBoundary)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUserPermissionsBoundary,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteUserPermissionsBoundaryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteUserPermissionsBoundaryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteUserPermissionsBoundaryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_user_permissions_boundary(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUserPermissionsBoundary::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUserPermissionsBoundary",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteUserPermissionsBoundaryInput`](crate::input::DeleteUserPermissionsBoundaryInput)
    pub fn builder() -> crate::input::delete_user_permissions_boundary_input::Builder {
        crate::input::delete_user_permissions_boundary_input::Builder::default()
    }
}

/// See [`DeleteUserPolicyInput`](crate::input::DeleteUserPolicyInput)
pub mod delete_user_policy_input {
    /// A builder for [`DeleteUserPolicyInput`](crate::input::DeleteUserPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name (friendly name, not ARN) identifying the user that the policy is embedded
        /// in.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name (friendly name, not ARN) identifying the user that the policy is embedded
        /// in.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The name identifying the policy document to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name identifying the policy document to delete.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUserPolicyInput`](crate::input::DeleteUserPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUserPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUserPolicyInput {
                user_name: self.user_name,
                policy_name: self.policy_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUserPolicyInputOperationOutputAlias = crate::operation::DeleteUserPolicy;
#[doc(hidden)]
pub type DeleteUserPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteUserPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUserPolicy`](crate::operation::DeleteUserPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUserPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteUserPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteUserPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteUserPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_user_policy(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUserPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUserPolicy",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteUserPolicyInput`](crate::input::DeleteUserPolicyInput)
    pub fn builder() -> crate::input::delete_user_policy_input::Builder {
        crate::input::delete_user_policy_input::Builder::default()
    }
}

/// See [`DeleteVirtualMfaDeviceInput`](crate::input::DeleteVirtualMfaDeviceInput)
pub mod delete_virtual_mfa_device_input {
    /// A builder for [`DeleteVirtualMfaDeviceInput`](crate::input::DeleteVirtualMfaDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) serial_number: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The serial number that uniquely identifies the MFA device. For virtual MFA devices,
        /// the serial number is the same as the ARN.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of upper and lowercase alphanumeric characters with no spaces. You can also include any of the
        /// following characters: =,.@:/-</p>
        pub fn serial_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.serial_number = Some(input.into());
            self
        }
        /// <p>The serial number that uniquely identifies the MFA device. For virtual MFA devices,
        /// the serial number is the same as the ARN.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of upper and lowercase alphanumeric characters with no spaces. You can also include any of the
        /// following characters: =,.@:/-</p>
        pub fn set_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.serial_number = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVirtualMfaDeviceInput`](crate::input::DeleteVirtualMfaDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVirtualMfaDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteVirtualMfaDeviceInput {
                serial_number: self.serial_number,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteVirtualMfaDeviceInputOperationOutputAlias = crate::operation::DeleteVirtualMFADevice;
#[doc(hidden)]
pub type DeleteVirtualMfaDeviceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteVirtualMfaDeviceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVirtualMFADevice`](crate::operation::DeleteVirtualMFADevice)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVirtualMFADevice,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteVirtualMfaDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteVirtualMfaDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteVirtualMfaDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_virtual_mfa_device(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVirtualMFADevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVirtualMFADevice",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteVirtualMfaDeviceInput`](crate::input::DeleteVirtualMfaDeviceInput)
    pub fn builder() -> crate::input::delete_virtual_mfa_device_input::Builder {
        crate::input::delete_virtual_mfa_device_input::Builder::default()
    }
}

/// See [`DetachGroupPolicyInput`](crate::input::DetachGroupPolicyInput)
pub mod detach_group_policy_input {
    /// A builder for [`DetachGroupPolicyInput`](crate::input::DetachGroupPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) policy_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name (friendly name, not ARN) of the IAM group to detach the policy from.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name (friendly name, not ARN) of the IAM group to detach the policy from.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to detach.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to detach.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DetachGroupPolicyInput`](crate::input::DetachGroupPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetachGroupPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetachGroupPolicyInput {
                group_name: self.group_name,
                policy_arn: self.policy_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DetachGroupPolicyInputOperationOutputAlias = crate::operation::DetachGroupPolicy;
#[doc(hidden)]
pub type DetachGroupPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DetachGroupPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DetachGroupPolicy`](crate::operation::DetachGroupPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetachGroupPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DetachGroupPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DetachGroupPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DetachGroupPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_detach_group_policy(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetachGroupPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetachGroupPolicy",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DetachGroupPolicyInput`](crate::input::DetachGroupPolicyInput)
    pub fn builder() -> crate::input::detach_group_policy_input::Builder {
        crate::input::detach_group_policy_input::Builder::default()
    }
}

/// See [`DetachRolePolicyInput`](crate::input::DetachRolePolicyInput)
pub mod detach_role_policy_input {
    /// A builder for [`DetachRolePolicyInput`](crate::input::DetachRolePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_name: std::option::Option<std::string::String>,
        pub(crate) policy_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name (friendly name, not ARN) of the IAM role to detach the policy from.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>The name (friendly name, not ARN) of the IAM role to detach the policy from.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to detach.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to detach.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DetachRolePolicyInput`](crate::input::DetachRolePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetachRolePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetachRolePolicyInput {
                role_name: self.role_name,
                policy_arn: self.policy_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DetachRolePolicyInputOperationOutputAlias = crate::operation::DetachRolePolicy;
#[doc(hidden)]
pub type DetachRolePolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DetachRolePolicyInput {
    /// Consumes the builder and constructs an Operation<[`DetachRolePolicy`](crate::operation::DetachRolePolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetachRolePolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DetachRolePolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DetachRolePolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DetachRolePolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_detach_role_policy(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetachRolePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetachRolePolicy",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DetachRolePolicyInput`](crate::input::DetachRolePolicyInput)
    pub fn builder() -> crate::input::detach_role_policy_input::Builder {
        crate::input::detach_role_policy_input::Builder::default()
    }
}

/// See [`DetachUserPolicyInput`](crate::input::DetachUserPolicyInput)
pub mod detach_user_policy_input {
    /// A builder for [`DetachUserPolicyInput`](crate::input::DetachUserPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) policy_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name (friendly name, not ARN) of the IAM user to detach the policy from.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name (friendly name, not ARN) of the IAM user to detach the policy from.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to detach.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy you want to detach.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DetachUserPolicyInput`](crate::input::DetachUserPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetachUserPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetachUserPolicyInput {
                user_name: self.user_name,
                policy_arn: self.policy_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DetachUserPolicyInputOperationOutputAlias = crate::operation::DetachUserPolicy;
#[doc(hidden)]
pub type DetachUserPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DetachUserPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DetachUserPolicy`](crate::operation::DetachUserPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetachUserPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DetachUserPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DetachUserPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DetachUserPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_detach_user_policy(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetachUserPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetachUserPolicy",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DetachUserPolicyInput`](crate::input::DetachUserPolicyInput)
    pub fn builder() -> crate::input::detach_user_policy_input::Builder {
        crate::input::detach_user_policy_input::Builder::default()
    }
}

/// See [`EnableMfaDeviceInput`](crate::input::EnableMfaDeviceInput)
pub mod enable_mfa_device_input {
    /// A builder for [`EnableMfaDeviceInput`](crate::input::EnableMfaDeviceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) serial_number: std::option::Option<std::string::String>,
        pub(crate) authentication_code1: std::option::Option<std::string::String>,
        pub(crate) authentication_code2: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the IAM user for whom you want to enable the MFA device.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM user for whom you want to enable the MFA device.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The serial number that uniquely identifies the MFA device. For virtual MFA devices,
        /// the serial number is the device ARN.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of upper and lowercase alphanumeric characters with no spaces. You can also include any of the
        /// following characters: =,.@:/-</p>
        pub fn serial_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.serial_number = Some(input.into());
            self
        }
        /// <p>The serial number that uniquely identifies the MFA device. For virtual MFA devices,
        /// the serial number is the device ARN.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of upper and lowercase alphanumeric characters with no spaces. You can also include any of the
        /// following characters: =,.@:/-</p>
        pub fn set_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.serial_number = input;
            self
        }
        /// <p>An authentication code emitted by the device. </p>
        /// <p>The format for this parameter is a string of six digits.</p>
        /// <important>
        /// <p>Submit your request immediately after generating the authentication codes. If you
        /// generate the codes and then wait too long to submit the request, the MFA device
        /// successfully associates with the user but the MFA device becomes out of sync. This
        /// happens because time-based one-time passwords (TOTP) expire after a short period of
        /// time. If this happens, you can <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa_sync.html">resync the
        /// device</a>.</p>
        /// </important>
        pub fn authentication_code1(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_code1 = Some(input.into());
            self
        }
        /// <p>An authentication code emitted by the device. </p>
        /// <p>The format for this parameter is a string of six digits.</p>
        /// <important>
        /// <p>Submit your request immediately after generating the authentication codes. If you
        /// generate the codes and then wait too long to submit the request, the MFA device
        /// successfully associates with the user but the MFA device becomes out of sync. This
        /// happens because time-based one-time passwords (TOTP) expire after a short period of
        /// time. If this happens, you can <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa_sync.html">resync the
        /// device</a>.</p>
        /// </important>
        pub fn set_authentication_code1(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_code1 = input;
            self
        }
        /// <p>A subsequent authentication code emitted by the device.</p>
        /// <p>The format for this parameter is a string of six digits.</p>
        /// <important>
        /// <p>Submit your request immediately after generating the authentication codes. If you
        /// generate the codes and then wait too long to submit the request, the MFA device
        /// successfully associates with the user but the MFA device becomes out of sync. This
        /// happens because time-based one-time passwords (TOTP) expire after a short period of
        /// time. If this happens, you can <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa_sync.html">resync the
        /// device</a>.</p>
        /// </important>
        pub fn authentication_code2(mut self, input: impl Into<std::string::String>) -> Self {
            self.authentication_code2 = Some(input.into());
            self
        }
        /// <p>A subsequent authentication code emitted by the device.</p>
        /// <p>The format for this parameter is a string of six digits.</p>
        /// <important>
        /// <p>Submit your request immediately after generating the authentication codes. If you
        /// generate the codes and then wait too long to submit the request, the MFA device
        /// successfully associates with the user but the MFA device becomes out of sync. This
        /// happens because time-based one-time passwords (TOTP) expire after a short period of
        /// time. If this happens, you can <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa_sync.html">resync the
        /// device</a>.</p>
        /// </important>
        pub fn set_authentication_code2(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_code2 = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableMfaDeviceInput`](crate::input::EnableMfaDeviceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnableMfaDeviceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnableMfaDeviceInput {
                user_name: self.user_name,
                serial_number: self.serial_number,
                authentication_code1: self.authentication_code1,
                authentication_code2: self.authentication_code2,
            })
        }
    }
}
#[doc(hidden)]
pub type EnableMfaDeviceInputOperationOutputAlias = crate::operation::EnableMFADevice;
#[doc(hidden)]
pub type EnableMfaDeviceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl EnableMfaDeviceInput {
    /// Consumes the builder and constructs an Operation<[`EnableMFADevice`](crate::operation::EnableMFADevice)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnableMFADevice,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::EnableMfaDeviceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::EnableMfaDeviceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::EnableMfaDeviceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_enable_mfa_device(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnableMFADevice::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnableMFADevice",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`EnableMfaDeviceInput`](crate::input::EnableMfaDeviceInput)
    pub fn builder() -> crate::input::enable_mfa_device_input::Builder {
        crate::input::enable_mfa_device_input::Builder::default()
    }
}

/// See [`GenerateCredentialReportInput`](crate::input::GenerateCredentialReportInput)
pub mod generate_credential_report_input {
    /// A builder for [`GenerateCredentialReportInput`](crate::input::GenerateCredentialReportInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GenerateCredentialReportInput`](crate::input::GenerateCredentialReportInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GenerateCredentialReportInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GenerateCredentialReportInput {})
        }
    }
}
#[doc(hidden)]
pub type GenerateCredentialReportInputOperationOutputAlias =
    crate::operation::GenerateCredentialReport;
#[doc(hidden)]
pub type GenerateCredentialReportInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GenerateCredentialReportInput {
    /// Consumes the builder and constructs an Operation<[`GenerateCredentialReport`](crate::operation::GenerateCredentialReport)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GenerateCredentialReport,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GenerateCredentialReportInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GenerateCredentialReportInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GenerateCredentialReportInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_generate_credential_report(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GenerateCredentialReport::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GenerateCredentialReport",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GenerateCredentialReportInput`](crate::input::GenerateCredentialReportInput)
    pub fn builder() -> crate::input::generate_credential_report_input::Builder {
        crate::input::generate_credential_report_input::Builder::default()
    }
}

/// See [`GenerateOrganizationsAccessReportInput`](crate::input::GenerateOrganizationsAccessReportInput)
pub mod generate_organizations_access_report_input {
    /// A builder for [`GenerateOrganizationsAccessReportInput`](crate::input::GenerateOrganizationsAccessReportInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entity_path: std::option::Option<std::string::String>,
        pub(crate) organizations_policy_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The path of the Organizations entity (root, OU, or account). You can build an entity path
        /// using the known structure of your organization. For example, assume that your account ID
        /// is <code>123456789012</code> and its parent OU ID is <code>ou-rge0-awsabcde</code>. The
        /// organization root ID is <code>r-f6g7h8i9j0example</code> and your organization ID is
        /// <code>o-a1b2c3d4e5</code>. Your entity path is
        /// <code>o-a1b2c3d4e5/r-f6g7h8i9j0example/ou-rge0-awsabcde/123456789012</code>.</p>
        pub fn entity_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_path = Some(input.into());
            self
        }
        /// <p>The path of the Organizations entity (root, OU, or account). You can build an entity path
        /// using the known structure of your organization. For example, assume that your account ID
        /// is <code>123456789012</code> and its parent OU ID is <code>ou-rge0-awsabcde</code>. The
        /// organization root ID is <code>r-f6g7h8i9j0example</code> and your organization ID is
        /// <code>o-a1b2c3d4e5</code>. Your entity path is
        /// <code>o-a1b2c3d4e5/r-f6g7h8i9j0example/ou-rge0-awsabcde/123456789012</code>.</p>
        pub fn set_entity_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_path = input;
            self
        }
        /// <p>The identifier of the Organizations service control policy (SCP). This parameter is
        /// optional.</p>
        /// <p>This ID is used to generate information about when an account principal that is
        /// limited by the SCP attempted to access an Amazon Web Services service.</p>
        pub fn organizations_policy_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organizations_policy_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Organizations service control policy (SCP). This parameter is
        /// optional.</p>
        /// <p>This ID is used to generate information about when an account principal that is
        /// limited by the SCP attempted to access an Amazon Web Services service.</p>
        pub fn set_organizations_policy_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organizations_policy_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GenerateOrganizationsAccessReportInput`](crate::input::GenerateOrganizationsAccessReportInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GenerateOrganizationsAccessReportInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GenerateOrganizationsAccessReportInput {
                entity_path: self.entity_path,
                organizations_policy_id: self.organizations_policy_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GenerateOrganizationsAccessReportInputOperationOutputAlias =
    crate::operation::GenerateOrganizationsAccessReport;
#[doc(hidden)]
pub type GenerateOrganizationsAccessReportInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GenerateOrganizationsAccessReportInput {
    /// Consumes the builder and constructs an Operation<[`GenerateOrganizationsAccessReport`](crate::operation::GenerateOrganizationsAccessReport)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GenerateOrganizationsAccessReport,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GenerateOrganizationsAccessReportInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GenerateOrganizationsAccessReportInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GenerateOrganizationsAccessReportInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_generate_organizations_access_report(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GenerateOrganizationsAccessReport::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GenerateOrganizationsAccessReport",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GenerateOrganizationsAccessReportInput`](crate::input::GenerateOrganizationsAccessReportInput)
    pub fn builder() -> crate::input::generate_organizations_access_report_input::Builder {
        crate::input::generate_organizations_access_report_input::Builder::default()
    }
}

/// See [`GenerateServiceLastAccessedDetailsInput`](crate::input::GenerateServiceLastAccessedDetailsInput)
pub mod generate_service_last_accessed_details_input {
    /// A builder for [`GenerateServiceLastAccessedDetailsInput`](crate::input::GenerateServiceLastAccessedDetailsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) granularity:
            std::option::Option<crate::model::AccessAdvisorUsageGranularityType>,
    }
    impl Builder {
        /// <p>The ARN of the IAM resource (user, group, role, or managed policy) used to generate
        /// information about when the resource was last used in an attempt to access an Amazon Web Services
        /// service.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM resource (user, group, role, or managed policy) used to generate
        /// information about when the resource was last used in an attempt to access an Amazon Web Services
        /// service.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The level of detail that you want to generate. You can specify whether you want to
        /// generate information about the last attempt to access services or actions. If you
        /// specify service-level granularity, this operation generates only service data. If you
        /// specify action-level granularity, it generates service and action data. If you don't
        /// include this optional parameter, the operation generates service data.</p>
        pub fn granularity(
            mut self,
            input: crate::model::AccessAdvisorUsageGranularityType,
        ) -> Self {
            self.granularity = Some(input);
            self
        }
        /// <p>The level of detail that you want to generate. You can specify whether you want to
        /// generate information about the last attempt to access services or actions. If you
        /// specify service-level granularity, this operation generates only service data. If you
        /// specify action-level granularity, it generates service and action data. If you don't
        /// include this optional parameter, the operation generates service data.</p>
        pub fn set_granularity(
            mut self,
            input: std::option::Option<crate::model::AccessAdvisorUsageGranularityType>,
        ) -> Self {
            self.granularity = input;
            self
        }
        /// Consumes the builder and constructs a [`GenerateServiceLastAccessedDetailsInput`](crate::input::GenerateServiceLastAccessedDetailsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GenerateServiceLastAccessedDetailsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GenerateServiceLastAccessedDetailsInput {
                arn: self.arn,
                granularity: self.granularity,
            })
        }
    }
}
#[doc(hidden)]
pub type GenerateServiceLastAccessedDetailsInputOperationOutputAlias =
    crate::operation::GenerateServiceLastAccessedDetails;
#[doc(hidden)]
pub type GenerateServiceLastAccessedDetailsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GenerateServiceLastAccessedDetailsInput {
    /// Consumes the builder and constructs an Operation<[`GenerateServiceLastAccessedDetails`](crate::operation::GenerateServiceLastAccessedDetails)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GenerateServiceLastAccessedDetails,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GenerateServiceLastAccessedDetailsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GenerateServiceLastAccessedDetailsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GenerateServiceLastAccessedDetailsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_generate_service_last_accessed_details(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GenerateServiceLastAccessedDetails::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GenerateServiceLastAccessedDetails",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GenerateServiceLastAccessedDetailsInput`](crate::input::GenerateServiceLastAccessedDetailsInput)
    pub fn builder() -> crate::input::generate_service_last_accessed_details_input::Builder {
        crate::input::generate_service_last_accessed_details_input::Builder::default()
    }
}

/// See [`GetAccessKeyLastUsedInput`](crate::input::GetAccessKeyLastUsedInput)
pub mod get_access_key_last_used_input {
    /// A builder for [`GetAccessKeyLastUsedInput`](crate::input::GetAccessKeyLastUsedInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of an access key.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can
        /// consist of any upper or lowercased letter or digit.</p>
        pub fn access_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_key_id = Some(input.into());
            self
        }
        /// <p>The identifier of an access key.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can
        /// consist of any upper or lowercased letter or digit.</p>
        pub fn set_access_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccessKeyLastUsedInput`](crate::input::GetAccessKeyLastUsedInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAccessKeyLastUsedInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAccessKeyLastUsedInput {
                access_key_id: self.access_key_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAccessKeyLastUsedInputOperationOutputAlias = crate::operation::GetAccessKeyLastUsed;
#[doc(hidden)]
pub type GetAccessKeyLastUsedInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAccessKeyLastUsedInput {
    /// Consumes the builder and constructs an Operation<[`GetAccessKeyLastUsed`](crate::operation::GetAccessKeyLastUsed)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAccessKeyLastUsed,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAccessKeyLastUsedInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAccessKeyLastUsedInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAccessKeyLastUsedInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_access_key_last_used(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAccessKeyLastUsed::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAccessKeyLastUsed",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAccessKeyLastUsedInput`](crate::input::GetAccessKeyLastUsedInput)
    pub fn builder() -> crate::input::get_access_key_last_used_input::Builder {
        crate::input::get_access_key_last_used_input::Builder::default()
    }
}

/// See [`GetAccountAuthorizationDetailsInput`](crate::input::GetAccountAuthorizationDetailsInput)
pub mod get_account_authorization_details_input {
    /// A builder for [`GetAccountAuthorizationDetailsInput`](crate::input::GetAccountAuthorizationDetailsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter: std::option::Option<std::vec::Vec<crate::model::EntityType>>,
        pub(crate) max_items: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filter`.
        ///
        /// To override the contents of this collection use [`set_filter`](Self::set_filter).
        ///
        /// <p>A list of entity types used to filter the results. Only the entities that match the
        /// types you specify are included in the output. Use the value
        /// <code>LocalManagedPolicy</code> to include customer managed policies.</p>
        /// <p>The format for this parameter is a comma-separated (if more than one) list of strings.
        /// Each string value in the list must be one of the valid values listed below.</p>
        pub fn filter(mut self, input: impl Into<crate::model::EntityType>) -> Self {
            let mut v = self.filter.unwrap_or_default();
            v.push(input.into());
            self.filter = Some(v);
            self
        }
        /// <p>A list of entity types used to filter the results. Only the entities that match the
        /// types you specify are included in the output. Use the value
        /// <code>LocalManagedPolicy</code> to include customer managed policies.</p>
        /// <p>The format for this parameter is a comma-separated (if more than one) list of strings.
        /// Each string value in the list must be one of the valid values listed below.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EntityType>>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccountAuthorizationDetailsInput`](crate::input::GetAccountAuthorizationDetailsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAccountAuthorizationDetailsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAccountAuthorizationDetailsInput {
                filter: self.filter,
                max_items: self.max_items,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAccountAuthorizationDetailsInputOperationOutputAlias =
    crate::operation::GetAccountAuthorizationDetails;
#[doc(hidden)]
pub type GetAccountAuthorizationDetailsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAccountAuthorizationDetailsInput {
    /// Consumes the builder and constructs an Operation<[`GetAccountAuthorizationDetails`](crate::operation::GetAccountAuthorizationDetails)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAccountAuthorizationDetails,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAccountAuthorizationDetailsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAccountAuthorizationDetailsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAccountAuthorizationDetailsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_account_authorization_details(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAccountAuthorizationDetails::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAccountAuthorizationDetails",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAccountAuthorizationDetailsInput`](crate::input::GetAccountAuthorizationDetailsInput)
    pub fn builder() -> crate::input::get_account_authorization_details_input::Builder {
        crate::input::get_account_authorization_details_input::Builder::default()
    }
}

/// See [`GetAccountPasswordPolicyInput`](crate::input::GetAccountPasswordPolicyInput)
pub mod get_account_password_policy_input {
    /// A builder for [`GetAccountPasswordPolicyInput`](crate::input::GetAccountPasswordPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetAccountPasswordPolicyInput`](crate::input::GetAccountPasswordPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAccountPasswordPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAccountPasswordPolicyInput {})
        }
    }
}
#[doc(hidden)]
pub type GetAccountPasswordPolicyInputOperationOutputAlias =
    crate::operation::GetAccountPasswordPolicy;
#[doc(hidden)]
pub type GetAccountPasswordPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAccountPasswordPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetAccountPasswordPolicy`](crate::operation::GetAccountPasswordPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAccountPasswordPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAccountPasswordPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAccountPasswordPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAccountPasswordPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_account_password_policy(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAccountPasswordPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAccountPasswordPolicy",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAccountPasswordPolicyInput`](crate::input::GetAccountPasswordPolicyInput)
    pub fn builder() -> crate::input::get_account_password_policy_input::Builder {
        crate::input::get_account_password_policy_input::Builder::default()
    }
}

/// See [`GetAccountSummaryInput`](crate::input::GetAccountSummaryInput)
pub mod get_account_summary_input {
    /// A builder for [`GetAccountSummaryInput`](crate::input::GetAccountSummaryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetAccountSummaryInput`](crate::input::GetAccountSummaryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAccountSummaryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAccountSummaryInput {})
        }
    }
}
#[doc(hidden)]
pub type GetAccountSummaryInputOperationOutputAlias = crate::operation::GetAccountSummary;
#[doc(hidden)]
pub type GetAccountSummaryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAccountSummaryInput {
    /// Consumes the builder and constructs an Operation<[`GetAccountSummary`](crate::operation::GetAccountSummary)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAccountSummary,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAccountSummaryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAccountSummaryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAccountSummaryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_account_summary(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAccountSummary::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAccountSummary",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAccountSummaryInput`](crate::input::GetAccountSummaryInput)
    pub fn builder() -> crate::input::get_account_summary_input::Builder {
        crate::input::get_account_summary_input::Builder::default()
    }
}

/// See [`GetContextKeysForCustomPolicyInput`](crate::input::GetContextKeysForCustomPolicyInput)
pub mod get_context_keys_for_custom_policy_input {
    /// A builder for [`GetContextKeysForCustomPolicyInput`](crate::input::GetContextKeysForCustomPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_input_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `policy_input_list`.
        ///
        /// To override the contents of this collection use [`set_policy_input_list`](Self::set_policy_input_list).
        ///
        /// <p>A list of policies for which you want the list of context keys referenced in those
        /// policies. Each document is specified as a string containing the complete, valid JSON
        /// text of an IAM policy.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn policy_input_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.policy_input_list.unwrap_or_default();
            v.push(input.into());
            self.policy_input_list = Some(v);
            self
        }
        /// <p>A list of policies for which you want the list of context keys referenced in those
        /// policies. Each document is specified as a string containing the complete, valid JSON
        /// text of an IAM policy.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn set_policy_input_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.policy_input_list = input;
            self
        }
        /// Consumes the builder and constructs a [`GetContextKeysForCustomPolicyInput`](crate::input::GetContextKeysForCustomPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetContextKeysForCustomPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetContextKeysForCustomPolicyInput {
                policy_input_list: self.policy_input_list,
            })
        }
    }
}
#[doc(hidden)]
pub type GetContextKeysForCustomPolicyInputOperationOutputAlias =
    crate::operation::GetContextKeysForCustomPolicy;
#[doc(hidden)]
pub type GetContextKeysForCustomPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetContextKeysForCustomPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetContextKeysForCustomPolicy`](crate::operation::GetContextKeysForCustomPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetContextKeysForCustomPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetContextKeysForCustomPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetContextKeysForCustomPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetContextKeysForCustomPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_context_keys_for_custom_policy(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetContextKeysForCustomPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetContextKeysForCustomPolicy",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetContextKeysForCustomPolicyInput`](crate::input::GetContextKeysForCustomPolicyInput)
    pub fn builder() -> crate::input::get_context_keys_for_custom_policy_input::Builder {
        crate::input::get_context_keys_for_custom_policy_input::Builder::default()
    }
}

/// See [`GetContextKeysForPrincipalPolicyInput`](crate::input::GetContextKeysForPrincipalPolicyInput)
pub mod get_context_keys_for_principal_policy_input {
    /// A builder for [`GetContextKeysForPrincipalPolicyInput`](crate::input::GetContextKeysForPrincipalPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_source_arn: std::option::Option<std::string::String>,
        pub(crate) policy_input_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of a user, group, or role whose policies contain the context keys that you
        /// want listed. If you specify a user, the list includes context keys that are found in all
        /// policies that are attached to the user. The list also includes all groups that the user
        /// is a member of. If you pick a group or a role, then it includes only those context keys
        /// that are found in policies attached to that entity. Note that all parameters are shown
        /// in unencoded form here for clarity, but must be URL encoded to be included as a part of
        /// a real HTML request.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn policy_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_source_arn = Some(input.into());
            self
        }
        /// <p>The ARN of a user, group, or role whose policies contain the context keys that you
        /// want listed. If you specify a user, the list includes context keys that are found in all
        /// policies that are attached to the user. The list also includes all groups that the user
        /// is a member of. If you pick a group or a role, then it includes only those context keys
        /// that are found in policies attached to that entity. Note that all parameters are shown
        /// in unencoded form here for clarity, but must be URL encoded to be included as a part of
        /// a real HTML request.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_policy_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_source_arn = input;
            self
        }
        /// Appends an item to `policy_input_list`.
        ///
        /// To override the contents of this collection use [`set_policy_input_list`](Self::set_policy_input_list).
        ///
        /// <p>An optional list of additional policies for which you want the list of context keys
        /// that are referenced.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn policy_input_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.policy_input_list.unwrap_or_default();
            v.push(input.into());
            self.policy_input_list = Some(v);
            self
        }
        /// <p>An optional list of additional policies for which you want the list of context keys
        /// that are referenced.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn set_policy_input_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.policy_input_list = input;
            self
        }
        /// Consumes the builder and constructs a [`GetContextKeysForPrincipalPolicyInput`](crate::input::GetContextKeysForPrincipalPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetContextKeysForPrincipalPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetContextKeysForPrincipalPolicyInput {
                policy_source_arn: self.policy_source_arn,
                policy_input_list: self.policy_input_list,
            })
        }
    }
}
#[doc(hidden)]
pub type GetContextKeysForPrincipalPolicyInputOperationOutputAlias =
    crate::operation::GetContextKeysForPrincipalPolicy;
#[doc(hidden)]
pub type GetContextKeysForPrincipalPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetContextKeysForPrincipalPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetContextKeysForPrincipalPolicy`](crate::operation::GetContextKeysForPrincipalPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetContextKeysForPrincipalPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetContextKeysForPrincipalPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetContextKeysForPrincipalPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetContextKeysForPrincipalPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_context_keys_for_principal_policy(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetContextKeysForPrincipalPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetContextKeysForPrincipalPolicy",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetContextKeysForPrincipalPolicyInput`](crate::input::GetContextKeysForPrincipalPolicyInput)
    pub fn builder() -> crate::input::get_context_keys_for_principal_policy_input::Builder {
        crate::input::get_context_keys_for_principal_policy_input::Builder::default()
    }
}

/// See [`GetCredentialReportInput`](crate::input::GetCredentialReportInput)
pub mod get_credential_report_input {
    /// A builder for [`GetCredentialReportInput`](crate::input::GetCredentialReportInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetCredentialReportInput`](crate::input::GetCredentialReportInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCredentialReportInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCredentialReportInput {})
        }
    }
}
#[doc(hidden)]
pub type GetCredentialReportInputOperationOutputAlias = crate::operation::GetCredentialReport;
#[doc(hidden)]
pub type GetCredentialReportInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetCredentialReportInput {
    /// Consumes the builder and constructs an Operation<[`GetCredentialReport`](crate::operation::GetCredentialReport)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCredentialReport,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCredentialReportInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCredentialReportInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCredentialReportInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_credential_report(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCredentialReport::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCredentialReport",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCredentialReportInput`](crate::input::GetCredentialReportInput)
    pub fn builder() -> crate::input::get_credential_report_input::Builder {
        crate::input::get_credential_report_input::Builder::default()
    }
}

/// See [`GetGroupInput`](crate::input::GetGroupInput)
pub mod get_group_input {
    /// A builder for [`GetGroupInput`](crate::input::GetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the group.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the group.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGroupInput`](crate::input::GetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetGroupInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetGroupInput {
                group_name: self.group_name,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type GetGroupInputOperationOutputAlias = crate::operation::GetGroup;
#[doc(hidden)]
pub type GetGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetGroupInput {
    /// Consumes the builder and constructs an Operation<[`GetGroup`](crate::operation::GetGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_group(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetGroup::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new("GetGroup", "iam"));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetGroupInput`](crate::input::GetGroupInput)
    pub fn builder() -> crate::input::get_group_input::Builder {
        crate::input::get_group_input::Builder::default()
    }
}

/// See [`GetGroupPolicyInput`](crate::input::GetGroupPolicyInput)
pub mod get_group_policy_input {
    /// A builder for [`GetGroupPolicyInput`](crate::input::GetGroupPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the group the policy is associated with.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the group the policy is associated with.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The name of the policy document to get.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy document to get.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGroupPolicyInput`](crate::input::GetGroupPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetGroupPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetGroupPolicyInput {
                group_name: self.group_name,
                policy_name: self.policy_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetGroupPolicyInputOperationOutputAlias = crate::operation::GetGroupPolicy;
#[doc(hidden)]
pub type GetGroupPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetGroupPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetGroupPolicy`](crate::operation::GetGroupPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetGroupPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetGroupPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetGroupPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetGroupPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_group_policy(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetGroupPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetGroupPolicy",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetGroupPolicyInput`](crate::input::GetGroupPolicyInput)
    pub fn builder() -> crate::input::get_group_policy_input::Builder {
        crate::input::get_group_policy_input::Builder::default()
    }
}

/// See [`GetInstanceProfileInput`](crate::input::GetInstanceProfileInput)
pub mod get_instance_profile_input {
    /// A builder for [`GetInstanceProfileInput`](crate::input::GetInstanceProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_profile_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the instance profile to get information about.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn instance_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_profile_name = Some(input.into());
            self
        }
        /// <p>The name of the instance profile to get information about.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_instance_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_profile_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInstanceProfileInput`](crate::input::GetInstanceProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetInstanceProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetInstanceProfileInput {
                instance_profile_name: self.instance_profile_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetInstanceProfileInputOperationOutputAlias = crate::operation::GetInstanceProfile;
#[doc(hidden)]
pub type GetInstanceProfileInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetInstanceProfileInput {
    /// Consumes the builder and constructs an Operation<[`GetInstanceProfile`](crate::operation::GetInstanceProfile)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetInstanceProfile,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetInstanceProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetInstanceProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetInstanceProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_instance_profile(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetInstanceProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetInstanceProfile",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetInstanceProfileInput`](crate::input::GetInstanceProfileInput)
    pub fn builder() -> crate::input::get_instance_profile_input::Builder {
        crate::input::get_instance_profile_input::Builder::default()
    }
}

/// See [`GetLoginProfileInput`](crate::input::GetLoginProfileInput)
pub mod get_login_profile_input {
    /// A builder for [`GetLoginProfileInput`](crate::input::GetLoginProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the user whose login profile you want to retrieve.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the user whose login profile you want to retrieve.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLoginProfileInput`](crate::input::GetLoginProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetLoginProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetLoginProfileInput {
                user_name: self.user_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetLoginProfileInputOperationOutputAlias = crate::operation::GetLoginProfile;
#[doc(hidden)]
pub type GetLoginProfileInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetLoginProfileInput {
    /// Consumes the builder and constructs an Operation<[`GetLoginProfile`](crate::operation::GetLoginProfile)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLoginProfile,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetLoginProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetLoginProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetLoginProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_login_profile(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetLoginProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetLoginProfile",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetLoginProfileInput`](crate::input::GetLoginProfileInput)
    pub fn builder() -> crate::input::get_login_profile_input::Builder {
        crate::input::get_login_profile_input::Builder::default()
    }
}

/// See [`GetOpenIdConnectProviderInput`](crate::input::GetOpenIdConnectProviderInput)
pub mod get_open_id_connect_provider_input {
    /// A builder for [`GetOpenIdConnectProviderInput`](crate::input::GetOpenIdConnectProviderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) open_id_connect_provider_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the OIDC provider resource object in IAM to get
        /// information for. You can get a list of OIDC provider resource ARNs by using the <a>ListOpenIDConnectProviders</a> operation.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn open_id_connect_provider_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.open_id_connect_provider_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the OIDC provider resource object in IAM to get
        /// information for. You can get a list of OIDC provider resource ARNs by using the <a>ListOpenIDConnectProviders</a> operation.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_open_id_connect_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.open_id_connect_provider_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOpenIdConnectProviderInput`](crate::input::GetOpenIdConnectProviderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetOpenIdConnectProviderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetOpenIdConnectProviderInput {
                open_id_connect_provider_arn: self.open_id_connect_provider_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetOpenIdConnectProviderInputOperationOutputAlias =
    crate::operation::GetOpenIDConnectProvider;
#[doc(hidden)]
pub type GetOpenIdConnectProviderInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetOpenIdConnectProviderInput {
    /// Consumes the builder and constructs an Operation<[`GetOpenIDConnectProvider`](crate::operation::GetOpenIDConnectProvider)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetOpenIDConnectProvider,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetOpenIdConnectProviderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetOpenIdConnectProviderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetOpenIdConnectProviderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_open_id_connect_provider(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetOpenIDConnectProvider::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetOpenIDConnectProvider",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetOpenIdConnectProviderInput`](crate::input::GetOpenIdConnectProviderInput)
    pub fn builder() -> crate::input::get_open_id_connect_provider_input::Builder {
        crate::input::get_open_id_connect_provider_input::Builder::default()
    }
}

/// See [`GetOrganizationsAccessReportInput`](crate::input::GetOrganizationsAccessReportInput)
pub mod get_organizations_access_report_input {
    /// A builder for [`GetOrganizationsAccessReportInput`](crate::input::GetOrganizationsAccessReportInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) sort_key: std::option::Option<crate::model::SortKeyType>,
    }
    impl Builder {
        /// <p>The identifier of the request generated by the <a>GenerateOrganizationsAccessReport</a> operation.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The identifier of the request generated by the <a>GenerateOrganizationsAccessReport</a> operation.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The key that is used to sort the results. If you choose the namespace key, the results
        /// are returned in alphabetical order. If you choose the time key, the results are sorted
        /// numerically by the date and time.</p>
        pub fn sort_key(mut self, input: crate::model::SortKeyType) -> Self {
            self.sort_key = Some(input);
            self
        }
        /// <p>The key that is used to sort the results. If you choose the namespace key, the results
        /// are returned in alphabetical order. If you choose the time key, the results are sorted
        /// numerically by the date and time.</p>
        pub fn set_sort_key(
            mut self,
            input: std::option::Option<crate::model::SortKeyType>,
        ) -> Self {
            self.sort_key = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOrganizationsAccessReportInput`](crate::input::GetOrganizationsAccessReportInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetOrganizationsAccessReportInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetOrganizationsAccessReportInput {
                job_id: self.job_id,
                max_items: self.max_items,
                marker: self.marker,
                sort_key: self.sort_key,
            })
        }
    }
}
#[doc(hidden)]
pub type GetOrganizationsAccessReportInputOperationOutputAlias =
    crate::operation::GetOrganizationsAccessReport;
#[doc(hidden)]
pub type GetOrganizationsAccessReportInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetOrganizationsAccessReportInput {
    /// Consumes the builder and constructs an Operation<[`GetOrganizationsAccessReport`](crate::operation::GetOrganizationsAccessReport)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetOrganizationsAccessReport,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetOrganizationsAccessReportInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetOrganizationsAccessReportInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetOrganizationsAccessReportInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_organizations_access_report(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetOrganizationsAccessReport::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetOrganizationsAccessReport",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetOrganizationsAccessReportInput`](crate::input::GetOrganizationsAccessReportInput)
    pub fn builder() -> crate::input::get_organizations_access_report_input::Builder {
        crate::input::get_organizations_access_report_input::Builder::default()
    }
}

/// See [`GetPolicyInput`](crate::input::GetPolicyInput)
pub mod get_policy_input {
    /// A builder for [`GetPolicyInput`](crate::input::GetPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the managed policy that you want information
        /// about.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the managed policy that you want information
        /// about.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPolicyInput`](crate::input::GetPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetPolicyInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetPolicyInput {
                policy_arn: self.policy_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPolicyInputOperationOutputAlias = crate::operation::GetPolicy;
#[doc(hidden)]
pub type GetPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetPolicy`](crate::operation::GetPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_policy(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetPolicy::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetPolicy",
                    "iam",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetPolicyInput`](crate::input::GetPolicyInput)
    pub fn builder() -> crate::input::get_policy_input::Builder {
        crate::input::get_policy_input::Builder::default()
    }
}

/// See [`GetPolicyVersionInput`](crate::input::GetPolicyVersionInput)
pub mod get_policy_version_input {
    /// A builder for [`GetPolicyVersionInput`](crate::input::GetPolicyVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_arn: std::option::Option<std::string::String>,
        pub(crate) version_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the managed policy that you want information
        /// about.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the managed policy that you want information
        /// about.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// <p>Identifies the policy version to retrieve.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that
        /// consists of the lowercase letter 'v' followed by one or two digits, and optionally
        /// followed by a period '.' and a string of letters and digits.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>Identifies the policy version to retrieve.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that
        /// consists of the lowercase letter 'v' followed by one or two digits, and optionally
        /// followed by a period '.' and a string of letters and digits.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPolicyVersionInput`](crate::input::GetPolicyVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPolicyVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPolicyVersionInput {
                policy_arn: self.policy_arn,
                version_id: self.version_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPolicyVersionInputOperationOutputAlias = crate::operation::GetPolicyVersion;
#[doc(hidden)]
pub type GetPolicyVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetPolicyVersionInput {
    /// Consumes the builder and constructs an Operation<[`GetPolicyVersion`](crate::operation::GetPolicyVersion)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPolicyVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetPolicyVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetPolicyVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetPolicyVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_policy_version(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPolicyVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPolicyVersion",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetPolicyVersionInput`](crate::input::GetPolicyVersionInput)
    pub fn builder() -> crate::input::get_policy_version_input::Builder {
        crate::input::get_policy_version_input::Builder::default()
    }
}

/// See [`GetRoleInput`](crate::input::GetRoleInput)
pub mod get_role_input {
    /// A builder for [`GetRoleInput`](crate::input::GetRoleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the IAM role to get information about.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM role to get information about.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRoleInput`](crate::input::GetRoleInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetRoleInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetRoleInput {
                role_name: self.role_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRoleInputOperationOutputAlias = crate::operation::GetRole;
#[doc(hidden)]
pub type GetRoleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetRoleInput {
    /// Consumes the builder and constructs an Operation<[`GetRole`](crate::operation::GetRole)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRole,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRoleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRoleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRoleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_role(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetRole::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new("GetRole", "iam"));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRoleInput`](crate::input::GetRoleInput)
    pub fn builder() -> crate::input::get_role_input::Builder {
        crate::input::get_role_input::Builder::default()
    }
}

/// See [`GetRolePolicyInput`](crate::input::GetRolePolicyInput)
pub mod get_role_policy_input {
    /// A builder for [`GetRolePolicyInput`](crate::input::GetRolePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_name: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the role associated with the policy.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>The name of the role associated with the policy.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// <p>The name of the policy document to get.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy document to get.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRolePolicyInput`](crate::input::GetRolePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRolePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRolePolicyInput {
                role_name: self.role_name,
                policy_name: self.policy_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRolePolicyInputOperationOutputAlias = crate::operation::GetRolePolicy;
#[doc(hidden)]
pub type GetRolePolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetRolePolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetRolePolicy`](crate::operation::GetRolePolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRolePolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRolePolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRolePolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRolePolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_role_policy(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRolePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRolePolicy",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRolePolicyInput`](crate::input::GetRolePolicyInput)
    pub fn builder() -> crate::input::get_role_policy_input::Builder {
        crate::input::get_role_policy_input::Builder::default()
    }
}

/// See [`GetSamlProviderInput`](crate::input::GetSamlProviderInput)
pub mod get_saml_provider_input {
    /// A builder for [`GetSamlProviderInput`](crate::input::GetSamlProviderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) saml_provider_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the SAML provider resource object in IAM to get
        /// information about.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn saml_provider_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.saml_provider_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SAML provider resource object in IAM to get
        /// information about.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_saml_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.saml_provider_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSamlProviderInput`](crate::input::GetSamlProviderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSamlProviderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSamlProviderInput {
                saml_provider_arn: self.saml_provider_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSamlProviderInputOperationOutputAlias = crate::operation::GetSAMLProvider;
#[doc(hidden)]
pub type GetSamlProviderInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSamlProviderInput {
    /// Consumes the builder and constructs an Operation<[`GetSAMLProvider`](crate::operation::GetSAMLProvider)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSAMLProvider,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSamlProviderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSamlProviderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSamlProviderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_saml_provider(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSAMLProvider::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSAMLProvider",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSamlProviderInput`](crate::input::GetSamlProviderInput)
    pub fn builder() -> crate::input::get_saml_provider_input::Builder {
        crate::input::get_saml_provider_input::Builder::default()
    }
}

/// See [`GetServerCertificateInput`](crate::input::GetServerCertificateInput)
pub mod get_server_certificate_input {
    /// A builder for [`GetServerCertificateInput`](crate::input::GetServerCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_certificate_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the server certificate you want to retrieve information about.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn server_certificate_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_certificate_name = Some(input.into());
            self
        }
        /// <p>The name of the server certificate you want to retrieve information about.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_server_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.server_certificate_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetServerCertificateInput`](crate::input::GetServerCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetServerCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetServerCertificateInput {
                server_certificate_name: self.server_certificate_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetServerCertificateInputOperationOutputAlias = crate::operation::GetServerCertificate;
#[doc(hidden)]
pub type GetServerCertificateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetServerCertificateInput {
    /// Consumes the builder and constructs an Operation<[`GetServerCertificate`](crate::operation::GetServerCertificate)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetServerCertificate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetServerCertificateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetServerCertificateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetServerCertificateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_server_certificate(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetServerCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetServerCertificate",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetServerCertificateInput`](crate::input::GetServerCertificateInput)
    pub fn builder() -> crate::input::get_server_certificate_input::Builder {
        crate::input::get_server_certificate_input::Builder::default()
    }
}

/// See [`GetServiceLastAccessedDetailsInput`](crate::input::GetServiceLastAccessedDetailsInput)
pub mod get_service_last_accessed_details_input {
    /// A builder for [`GetServiceLastAccessedDetailsInput`](crate::input::GetServiceLastAccessedDetailsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the request generated by the <a>GenerateServiceLastAccessedDetails</a> operation. The <code>JobId</code>
        /// returned by <code>GenerateServiceLastAccessedDetail</code> must be used by the same role
        /// within a session, or by the same user when used to call
        /// <code>GetServiceLastAccessedDetail</code>.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID of the request generated by the <a>GenerateServiceLastAccessedDetails</a> operation. The <code>JobId</code>
        /// returned by <code>GenerateServiceLastAccessedDetail</code> must be used by the same role
        /// within a session, or by the same user when used to call
        /// <code>GetServiceLastAccessedDetail</code>.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`GetServiceLastAccessedDetailsInput`](crate::input::GetServiceLastAccessedDetailsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetServiceLastAccessedDetailsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetServiceLastAccessedDetailsInput {
                job_id: self.job_id,
                max_items: self.max_items,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type GetServiceLastAccessedDetailsInputOperationOutputAlias =
    crate::operation::GetServiceLastAccessedDetails;
#[doc(hidden)]
pub type GetServiceLastAccessedDetailsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetServiceLastAccessedDetailsInput {
    /// Consumes the builder and constructs an Operation<[`GetServiceLastAccessedDetails`](crate::operation::GetServiceLastAccessedDetails)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetServiceLastAccessedDetails,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetServiceLastAccessedDetailsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetServiceLastAccessedDetailsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetServiceLastAccessedDetailsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_service_last_accessed_details(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetServiceLastAccessedDetails::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetServiceLastAccessedDetails",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetServiceLastAccessedDetailsInput`](crate::input::GetServiceLastAccessedDetailsInput)
    pub fn builder() -> crate::input::get_service_last_accessed_details_input::Builder {
        crate::input::get_service_last_accessed_details_input::Builder::default()
    }
}

/// See [`GetServiceLastAccessedDetailsWithEntitiesInput`](crate::input::GetServiceLastAccessedDetailsWithEntitiesInput)
pub mod get_service_last_accessed_details_with_entities_input {
    /// A builder for [`GetServiceLastAccessedDetailsWithEntitiesInput`](crate::input::GetServiceLastAccessedDetailsWithEntitiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) service_namespace: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the request generated by the <code>GenerateServiceLastAccessedDetails</code>
        /// operation.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID of the request generated by the <code>GenerateServiceLastAccessedDetails</code>
        /// operation.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The service namespace for an Amazon Web Services service. Provide the service namespace to learn
        /// when the IAM entity last attempted to access the specified service.</p>
        /// <p>To learn the service namespace for a service, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html">Actions, resources, and condition keys for Amazon Web Services services</a> in the
        /// <i>IAM User Guide</i>. Choose the name of the service to view
        /// details for that service. In the first paragraph, find the service prefix. For example,
        /// <code>(service prefix: a4b)</code>. For more information about service namespaces,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces">Amazon Web Services
        /// service namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn service_namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_namespace = Some(input.into());
            self
        }
        /// <p>The service namespace for an Amazon Web Services service. Provide the service namespace to learn
        /// when the IAM entity last attempted to access the specified service.</p>
        /// <p>To learn the service namespace for a service, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html">Actions, resources, and condition keys for Amazon Web Services services</a> in the
        /// <i>IAM User Guide</i>. Choose the name of the service to view
        /// details for that service. In the first paragraph, find the service prefix. For example,
        /// <code>(service prefix: a4b)</code>. For more information about service namespaces,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces">Amazon Web Services
        /// service namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_service_namespace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_namespace = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`GetServiceLastAccessedDetailsWithEntitiesInput`](crate::input::GetServiceLastAccessedDetailsWithEntitiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetServiceLastAccessedDetailsWithEntitiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::GetServiceLastAccessedDetailsWithEntitiesInput {
                    job_id: self.job_id,
                    service_namespace: self.service_namespace,
                    max_items: self.max_items,
                    marker: self.marker,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type GetServiceLastAccessedDetailsWithEntitiesInputOperationOutputAlias =
    crate::operation::GetServiceLastAccessedDetailsWithEntities;
#[doc(hidden)]
pub type GetServiceLastAccessedDetailsWithEntitiesInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl GetServiceLastAccessedDetailsWithEntitiesInput {
    /// Consumes the builder and constructs an Operation<[`GetServiceLastAccessedDetailsWithEntities`](crate::operation::GetServiceLastAccessedDetailsWithEntities)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetServiceLastAccessedDetailsWithEntities,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetServiceLastAccessedDetailsWithEntitiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetServiceLastAccessedDetailsWithEntitiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetServiceLastAccessedDetailsWithEntitiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_service_last_accessed_details_with_entities(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetServiceLastAccessedDetailsWithEntities::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetServiceLastAccessedDetailsWithEntities",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetServiceLastAccessedDetailsWithEntitiesInput`](crate::input::GetServiceLastAccessedDetailsWithEntitiesInput)
    pub fn builder() -> crate::input::get_service_last_accessed_details_with_entities_input::Builder
    {
        crate::input::get_service_last_accessed_details_with_entities_input::Builder::default()
    }
}

/// See [`GetServiceLinkedRoleDeletionStatusInput`](crate::input::GetServiceLinkedRoleDeletionStatusInput)
pub mod get_service_linked_role_deletion_status_input {
    /// A builder for [`GetServiceLinkedRoleDeletionStatusInput`](crate::input::GetServiceLinkedRoleDeletionStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deletion_task_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The deletion task identifier. This identifier is returned by the <a>DeleteServiceLinkedRole</a> operation in the format
        /// <code>task/aws-service-role/<service-principal-name>/<role-name>/<task-uuid></code>.</p>
        pub fn deletion_task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.deletion_task_id = Some(input.into());
            self
        }
        /// <p>The deletion task identifier. This identifier is returned by the <a>DeleteServiceLinkedRole</a> operation in the format
        /// <code>task/aws-service-role/<service-principal-name>/<role-name>/<task-uuid></code>.</p>
        pub fn set_deletion_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deletion_task_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetServiceLinkedRoleDeletionStatusInput`](crate::input::GetServiceLinkedRoleDeletionStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetServiceLinkedRoleDeletionStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetServiceLinkedRoleDeletionStatusInput {
                deletion_task_id: self.deletion_task_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetServiceLinkedRoleDeletionStatusInputOperationOutputAlias =
    crate::operation::GetServiceLinkedRoleDeletionStatus;
#[doc(hidden)]
pub type GetServiceLinkedRoleDeletionStatusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetServiceLinkedRoleDeletionStatusInput {
    /// Consumes the builder and constructs an Operation<[`GetServiceLinkedRoleDeletionStatus`](crate::operation::GetServiceLinkedRoleDeletionStatus)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetServiceLinkedRoleDeletionStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetServiceLinkedRoleDeletionStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetServiceLinkedRoleDeletionStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetServiceLinkedRoleDeletionStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_service_linked_role_deletion_status(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetServiceLinkedRoleDeletionStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetServiceLinkedRoleDeletionStatus",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetServiceLinkedRoleDeletionStatusInput`](crate::input::GetServiceLinkedRoleDeletionStatusInput)
    pub fn builder() -> crate::input::get_service_linked_role_deletion_status_input::Builder {
        crate::input::get_service_linked_role_deletion_status_input::Builder::default()
    }
}

/// See [`GetSshPublicKeyInput`](crate::input::GetSshPublicKeyInput)
pub mod get_ssh_public_key_input {
    /// A builder for [`GetSshPublicKeyInput`](crate::input::GetSshPublicKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) ssh_public_key_id: std::option::Option<std::string::String>,
        pub(crate) encoding: std::option::Option<crate::model::EncodingType>,
    }
    impl Builder {
        /// <p>The name of the IAM user associated with the SSH public key.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM user associated with the SSH public key.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The unique identifier for the SSH public key.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can
        /// consist of any upper or lowercased letter or digit.</p>
        pub fn ssh_public_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_public_key_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the SSH public key.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that can
        /// consist of any upper or lowercased letter or digit.</p>
        pub fn set_ssh_public_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssh_public_key_id = input;
            self
        }
        /// <p>Specifies the public key encoding format to use in the response. To retrieve the
        /// public key in ssh-rsa format, use <code>SSH</code>. To retrieve the public key in PEM
        /// format, use <code>PEM</code>.</p>
        pub fn encoding(mut self, input: crate::model::EncodingType) -> Self {
            self.encoding = Some(input);
            self
        }
        /// <p>Specifies the public key encoding format to use in the response. To retrieve the
        /// public key in ssh-rsa format, use <code>SSH</code>. To retrieve the public key in PEM
        /// format, use <code>PEM</code>.</p>
        pub fn set_encoding(
            mut self,
            input: std::option::Option<crate::model::EncodingType>,
        ) -> Self {
            self.encoding = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSshPublicKeyInput`](crate::input::GetSshPublicKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSshPublicKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSshPublicKeyInput {
                user_name: self.user_name,
                ssh_public_key_id: self.ssh_public_key_id,
                encoding: self.encoding,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSshPublicKeyInputOperationOutputAlias = crate::operation::GetSSHPublicKey;
#[doc(hidden)]
pub type GetSshPublicKeyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSshPublicKeyInput {
    /// Consumes the builder and constructs an Operation<[`GetSSHPublicKey`](crate::operation::GetSSHPublicKey)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSSHPublicKey,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSshPublicKeyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSshPublicKeyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSshPublicKeyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_ssh_public_key(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSSHPublicKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSSHPublicKey",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSshPublicKeyInput`](crate::input::GetSshPublicKeyInput)
    pub fn builder() -> crate::input::get_ssh_public_key_input::Builder {
        crate::input::get_ssh_public_key_input::Builder::default()
    }
}

/// See [`GetUserInput`](crate::input::GetUserInput)
pub mod get_user_input {
    /// A builder for [`GetUserInput`](crate::input::GetUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the user to get information about.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to the user making the
        /// request. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the user to get information about.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to the user making the
        /// request. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUserInput`](crate::input::GetUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetUserInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetUserInput {
                user_name: self.user_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetUserInputOperationOutputAlias = crate::operation::GetUser;
#[doc(hidden)]
pub type GetUserInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetUserInput {
    /// Consumes the builder and constructs an Operation<[`GetUser`](crate::operation::GetUser)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetUser,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_user(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetUser::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new("GetUser", "iam"));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetUserInput`](crate::input::GetUserInput)
    pub fn builder() -> crate::input::get_user_input::Builder {
        crate::input::get_user_input::Builder::default()
    }
}

/// See [`GetUserPolicyInput`](crate::input::GetUserPolicyInput)
pub mod get_user_policy_input {
    /// A builder for [`GetUserPolicyInput`](crate::input::GetUserPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the user who the policy is associated with.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the user who the policy is associated with.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The name of the policy document to get.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy document to get.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUserPolicyInput`](crate::input::GetUserPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetUserPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetUserPolicyInput {
                user_name: self.user_name,
                policy_name: self.policy_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetUserPolicyInputOperationOutputAlias = crate::operation::GetUserPolicy;
#[doc(hidden)]
pub type GetUserPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetUserPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetUserPolicy`](crate::operation::GetUserPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetUserPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetUserPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetUserPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetUserPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_user_policy(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetUserPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetUserPolicy",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetUserPolicyInput`](crate::input::GetUserPolicyInput)
    pub fn builder() -> crate::input::get_user_policy_input::Builder {
        crate::input::get_user_policy_input::Builder::default()
    }
}

/// See [`ListAccessKeysInput`](crate::input::ListAccessKeysInput)
pub mod list_access_keys_input {
    /// A builder for [`ListAccessKeysInput`](crate::input::ListAccessKeysInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the user.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the user.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccessKeysInput`](crate::input::ListAccessKeysInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAccessKeysInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAccessKeysInput {
                user_name: self.user_name,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAccessKeysInputOperationOutputAlias = crate::operation::ListAccessKeys;
#[doc(hidden)]
pub type ListAccessKeysInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAccessKeysInput {
    /// Consumes the builder and constructs an Operation<[`ListAccessKeys`](crate::operation::ListAccessKeys)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAccessKeys,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAccessKeysInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAccessKeysInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAccessKeysInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_access_keys(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAccessKeys::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAccessKeys",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAccessKeysInput`](crate::input::ListAccessKeysInput)
    pub fn builder() -> crate::input::list_access_keys_input::Builder {
        crate::input::list_access_keys_input::Builder::default()
    }
}

/// See [`ListAccountAliasesInput`](crate::input::ListAccountAliasesInput)
pub mod list_account_aliases_input {
    /// A builder for [`ListAccountAliasesInput`](crate::input::ListAccountAliasesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccountAliasesInput`](crate::input::ListAccountAliasesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAccountAliasesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAccountAliasesInput {
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAccountAliasesInputOperationOutputAlias = crate::operation::ListAccountAliases;
#[doc(hidden)]
pub type ListAccountAliasesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAccountAliasesInput {
    /// Consumes the builder and constructs an Operation<[`ListAccountAliases`](crate::operation::ListAccountAliases)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAccountAliases,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAccountAliasesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAccountAliasesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAccountAliasesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_account_aliases(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAccountAliases::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAccountAliases",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAccountAliasesInput`](crate::input::ListAccountAliasesInput)
    pub fn builder() -> crate::input::list_account_aliases_input::Builder {
        crate::input::list_account_aliases_input::Builder::default()
    }
}

/// See [`ListAttachedGroupPoliciesInput`](crate::input::ListAttachedGroupPoliciesInput)
pub mod list_attached_group_policies_input {
    /// A builder for [`ListAttachedGroupPoliciesInput`](crate::input::ListAttachedGroupPoliciesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) path_prefix: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name (friendly name, not ARN) of the group to list attached policies for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name (friendly name, not ARN) of the group to list attached policies for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The path prefix for filtering the results. This parameter is optional. If it is not
        /// included, it defaults to a slash (/), listing all policies.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn path_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.path_prefix = Some(input.into());
            self
        }
        /// <p>The path prefix for filtering the results. This parameter is optional. If it is not
        /// included, it defaults to a slash (/), listing all policies.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn set_path_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path_prefix = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAttachedGroupPoliciesInput`](crate::input::ListAttachedGroupPoliciesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAttachedGroupPoliciesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAttachedGroupPoliciesInput {
                group_name: self.group_name,
                path_prefix: self.path_prefix,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAttachedGroupPoliciesInputOperationOutputAlias =
    crate::operation::ListAttachedGroupPolicies;
#[doc(hidden)]
pub type ListAttachedGroupPoliciesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAttachedGroupPoliciesInput {
    /// Consumes the builder and constructs an Operation<[`ListAttachedGroupPolicies`](crate::operation::ListAttachedGroupPolicies)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAttachedGroupPolicies,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAttachedGroupPoliciesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAttachedGroupPoliciesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAttachedGroupPoliciesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_attached_group_policies(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAttachedGroupPolicies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAttachedGroupPolicies",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAttachedGroupPoliciesInput`](crate::input::ListAttachedGroupPoliciesInput)
    pub fn builder() -> crate::input::list_attached_group_policies_input::Builder {
        crate::input::list_attached_group_policies_input::Builder::default()
    }
}

/// See [`ListAttachedRolePoliciesInput`](crate::input::ListAttachedRolePoliciesInput)
pub mod list_attached_role_policies_input {
    /// A builder for [`ListAttachedRolePoliciesInput`](crate::input::ListAttachedRolePoliciesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_name: std::option::Option<std::string::String>,
        pub(crate) path_prefix: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name (friendly name, not ARN) of the role to list attached policies for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>The name (friendly name, not ARN) of the role to list attached policies for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// <p>The path prefix for filtering the results. This parameter is optional. If it is not
        /// included, it defaults to a slash (/), listing all policies.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn path_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.path_prefix = Some(input.into());
            self
        }
        /// <p>The path prefix for filtering the results. This parameter is optional. If it is not
        /// included, it defaults to a slash (/), listing all policies.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn set_path_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path_prefix = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAttachedRolePoliciesInput`](crate::input::ListAttachedRolePoliciesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAttachedRolePoliciesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAttachedRolePoliciesInput {
                role_name: self.role_name,
                path_prefix: self.path_prefix,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAttachedRolePoliciesInputOperationOutputAlias =
    crate::operation::ListAttachedRolePolicies;
#[doc(hidden)]
pub type ListAttachedRolePoliciesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAttachedRolePoliciesInput {
    /// Consumes the builder and constructs an Operation<[`ListAttachedRolePolicies`](crate::operation::ListAttachedRolePolicies)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAttachedRolePolicies,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAttachedRolePoliciesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAttachedRolePoliciesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAttachedRolePoliciesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_attached_role_policies(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAttachedRolePolicies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAttachedRolePolicies",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAttachedRolePoliciesInput`](crate::input::ListAttachedRolePoliciesInput)
    pub fn builder() -> crate::input::list_attached_role_policies_input::Builder {
        crate::input::list_attached_role_policies_input::Builder::default()
    }
}

/// See [`ListAttachedUserPoliciesInput`](crate::input::ListAttachedUserPoliciesInput)
pub mod list_attached_user_policies_input {
    /// A builder for [`ListAttachedUserPoliciesInput`](crate::input::ListAttachedUserPoliciesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) path_prefix: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name (friendly name, not ARN) of the user to list attached policies for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name (friendly name, not ARN) of the user to list attached policies for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The path prefix for filtering the results. This parameter is optional. If it is not
        /// included, it defaults to a slash (/), listing all policies.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn path_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.path_prefix = Some(input.into());
            self
        }
        /// <p>The path prefix for filtering the results. This parameter is optional. If it is not
        /// included, it defaults to a slash (/), listing all policies.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn set_path_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path_prefix = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAttachedUserPoliciesInput`](crate::input::ListAttachedUserPoliciesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAttachedUserPoliciesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAttachedUserPoliciesInput {
                user_name: self.user_name,
                path_prefix: self.path_prefix,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAttachedUserPoliciesInputOperationOutputAlias =
    crate::operation::ListAttachedUserPolicies;
#[doc(hidden)]
pub type ListAttachedUserPoliciesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAttachedUserPoliciesInput {
    /// Consumes the builder and constructs an Operation<[`ListAttachedUserPolicies`](crate::operation::ListAttachedUserPolicies)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAttachedUserPolicies,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAttachedUserPoliciesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAttachedUserPoliciesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAttachedUserPoliciesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_attached_user_policies(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAttachedUserPolicies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAttachedUserPolicies",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAttachedUserPoliciesInput`](crate::input::ListAttachedUserPoliciesInput)
    pub fn builder() -> crate::input::list_attached_user_policies_input::Builder {
        crate::input::list_attached_user_policies_input::Builder::default()
    }
}

/// See [`ListEntitiesForPolicyInput`](crate::input::ListEntitiesForPolicyInput)
pub mod list_entities_for_policy_input {
    /// A builder for [`ListEntitiesForPolicyInput`](crate::input::ListEntitiesForPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_arn: std::option::Option<std::string::String>,
        pub(crate) entity_filter: std::option::Option<crate::model::EntityType>,
        pub(crate) path_prefix: std::option::Option<std::string::String>,
        pub(crate) policy_usage_filter: std::option::Option<crate::model::PolicyUsageType>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the IAM policy for which you want the
        /// versions.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy for which you want the
        /// versions.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// <p>The entity type to use for filtering the results.</p>
        /// <p>For example, when <code>EntityFilter</code> is <code>Role</code>, only the roles that
        /// are attached to the specified policy are returned. This parameter is optional. If it is
        /// not included, all attached entities (users, groups, and roles) are returned. The
        /// argument for this parameter must be one of the valid values listed below.</p>
        pub fn entity_filter(mut self, input: crate::model::EntityType) -> Self {
            self.entity_filter = Some(input);
            self
        }
        /// <p>The entity type to use for filtering the results.</p>
        /// <p>For example, when <code>EntityFilter</code> is <code>Role</code>, only the roles that
        /// are attached to the specified policy are returned. This parameter is optional. If it is
        /// not included, all attached entities (users, groups, and roles) are returned. The
        /// argument for this parameter must be one of the valid values listed below.</p>
        pub fn set_entity_filter(
            mut self,
            input: std::option::Option<crate::model::EntityType>,
        ) -> Self {
            self.entity_filter = input;
            self
        }
        /// <p>The path prefix for filtering the results. This parameter is optional. If it is not
        /// included, it defaults to a slash (/), listing all entities.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn path_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.path_prefix = Some(input.into());
            self
        }
        /// <p>The path prefix for filtering the results. This parameter is optional. If it is not
        /// included, it defaults to a slash (/), listing all entities.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn set_path_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path_prefix = input;
            self
        }
        /// <p>The policy usage method to use for filtering the results.</p>
        /// <p>To list only permissions policies,
        /// set <code>PolicyUsageFilter</code> to <code>PermissionsPolicy</code>. To list only
        /// the policies used to set permissions boundaries, set the value
        /// to <code>PermissionsBoundary</code>.</p>
        /// <p>This parameter is optional. If it is not included, all policies are returned. </p>
        pub fn policy_usage_filter(mut self, input: crate::model::PolicyUsageType) -> Self {
            self.policy_usage_filter = Some(input);
            self
        }
        /// <p>The policy usage method to use for filtering the results.</p>
        /// <p>To list only permissions policies,
        /// set <code>PolicyUsageFilter</code> to <code>PermissionsPolicy</code>. To list only
        /// the policies used to set permissions boundaries, set the value
        /// to <code>PermissionsBoundary</code>.</p>
        /// <p>This parameter is optional. If it is not included, all policies are returned. </p>
        pub fn set_policy_usage_filter(
            mut self,
            input: std::option::Option<crate::model::PolicyUsageType>,
        ) -> Self {
            self.policy_usage_filter = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEntitiesForPolicyInput`](crate::input::ListEntitiesForPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEntitiesForPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEntitiesForPolicyInput {
                policy_arn: self.policy_arn,
                entity_filter: self.entity_filter,
                path_prefix: self.path_prefix,
                policy_usage_filter: self.policy_usage_filter,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEntitiesForPolicyInputOperationOutputAlias = crate::operation::ListEntitiesForPolicy;
#[doc(hidden)]
pub type ListEntitiesForPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListEntitiesForPolicyInput {
    /// Consumes the builder and constructs an Operation<[`ListEntitiesForPolicy`](crate::operation::ListEntitiesForPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEntitiesForPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListEntitiesForPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListEntitiesForPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListEntitiesForPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_entities_for_policy(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEntitiesForPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEntitiesForPolicy",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListEntitiesForPolicyInput`](crate::input::ListEntitiesForPolicyInput)
    pub fn builder() -> crate::input::list_entities_for_policy_input::Builder {
        crate::input::list_entities_for_policy_input::Builder::default()
    }
}

/// See [`ListGroupPoliciesInput`](crate::input::ListGroupPoliciesInput)
pub mod list_group_policies_input {
    /// A builder for [`ListGroupPoliciesInput`](crate::input::ListGroupPoliciesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the group to list policies for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the group to list policies for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGroupPoliciesInput`](crate::input::ListGroupPoliciesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListGroupPoliciesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListGroupPoliciesInput {
                group_name: self.group_name,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListGroupPoliciesInputOperationOutputAlias = crate::operation::ListGroupPolicies;
#[doc(hidden)]
pub type ListGroupPoliciesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListGroupPoliciesInput {
    /// Consumes the builder and constructs an Operation<[`ListGroupPolicies`](crate::operation::ListGroupPolicies)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListGroupPolicies,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListGroupPoliciesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListGroupPoliciesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListGroupPoliciesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_group_policies(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListGroupPolicies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListGroupPolicies",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListGroupPoliciesInput`](crate::input::ListGroupPoliciesInput)
    pub fn builder() -> crate::input::list_group_policies_input::Builder {
        crate::input::list_group_policies_input::Builder::default()
    }
}

/// See [`ListGroupsInput`](crate::input::ListGroupsInput)
pub mod list_groups_input {
    /// A builder for [`ListGroupsInput`](crate::input::ListGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path_prefix: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The path prefix for filtering the results. For example, the prefix
        /// <code>/division_abc/subdivision_xyz/</code> gets all groups whose path starts with
        /// <code>/division_abc/subdivision_xyz/</code>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/), listing
        /// all groups. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn path_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.path_prefix = Some(input.into());
            self
        }
        /// <p> The path prefix for filtering the results. For example, the prefix
        /// <code>/division_abc/subdivision_xyz/</code> gets all groups whose path starts with
        /// <code>/division_abc/subdivision_xyz/</code>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/), listing
        /// all groups. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn set_path_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path_prefix = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGroupsInput`](crate::input::ListGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListGroupsInput {
                path_prefix: self.path_prefix,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListGroupsInputOperationOutputAlias = crate::operation::ListGroups;
#[doc(hidden)]
pub type ListGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListGroupsInput {
    /// Consumes the builder and constructs an Operation<[`ListGroups`](crate::operation::ListGroups)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_groups(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListGroups",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListGroupsInput`](crate::input::ListGroupsInput)
    pub fn builder() -> crate::input::list_groups_input::Builder {
        crate::input::list_groups_input::Builder::default()
    }
}

/// See [`ListGroupsForUserInput`](crate::input::ListGroupsForUserInput)
pub mod list_groups_for_user_input {
    /// A builder for [`ListGroupsForUserInput`](crate::input::ListGroupsForUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the user to list groups for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the user to list groups for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGroupsForUserInput`](crate::input::ListGroupsForUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListGroupsForUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListGroupsForUserInput {
                user_name: self.user_name,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListGroupsForUserInputOperationOutputAlias = crate::operation::ListGroupsForUser;
#[doc(hidden)]
pub type ListGroupsForUserInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListGroupsForUserInput {
    /// Consumes the builder and constructs an Operation<[`ListGroupsForUser`](crate::operation::ListGroupsForUser)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListGroupsForUser,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListGroupsForUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListGroupsForUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListGroupsForUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_groups_for_user(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListGroupsForUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListGroupsForUser",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListGroupsForUserInput`](crate::input::ListGroupsForUserInput)
    pub fn builder() -> crate::input::list_groups_for_user_input::Builder {
        crate::input::list_groups_for_user_input::Builder::default()
    }
}

/// See [`ListInstanceProfilesInput`](crate::input::ListInstanceProfilesInput)
pub mod list_instance_profiles_input {
    /// A builder for [`ListInstanceProfilesInput`](crate::input::ListInstanceProfilesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path_prefix: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The path prefix for filtering the results. For example, the prefix
        /// <code>/application_abc/component_xyz/</code> gets all instance profiles whose path
        /// starts with <code>/application_abc/component_xyz/</code>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/), listing
        /// all instance profiles. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn path_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.path_prefix = Some(input.into());
            self
        }
        /// <p> The path prefix for filtering the results. For example, the prefix
        /// <code>/application_abc/component_xyz/</code> gets all instance profiles whose path
        /// starts with <code>/application_abc/component_xyz/</code>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/), listing
        /// all instance profiles. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn set_path_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path_prefix = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInstanceProfilesInput`](crate::input::ListInstanceProfilesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListInstanceProfilesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListInstanceProfilesInput {
                path_prefix: self.path_prefix,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListInstanceProfilesInputOperationOutputAlias = crate::operation::ListInstanceProfiles;
#[doc(hidden)]
pub type ListInstanceProfilesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListInstanceProfilesInput {
    /// Consumes the builder and constructs an Operation<[`ListInstanceProfiles`](crate::operation::ListInstanceProfiles)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListInstanceProfiles,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListInstanceProfilesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListInstanceProfilesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListInstanceProfilesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_instance_profiles(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListInstanceProfiles::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListInstanceProfiles",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListInstanceProfilesInput`](crate::input::ListInstanceProfilesInput)
    pub fn builder() -> crate::input::list_instance_profiles_input::Builder {
        crate::input::list_instance_profiles_input::Builder::default()
    }
}

/// See [`ListInstanceProfilesForRoleInput`](crate::input::ListInstanceProfilesForRoleInput)
pub mod list_instance_profiles_for_role_input {
    /// A builder for [`ListInstanceProfilesForRoleInput`](crate::input::ListInstanceProfilesForRoleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_name: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the role to list instance profiles for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>The name of the role to list instance profiles for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInstanceProfilesForRoleInput`](crate::input::ListInstanceProfilesForRoleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListInstanceProfilesForRoleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListInstanceProfilesForRoleInput {
                role_name: self.role_name,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListInstanceProfilesForRoleInputOperationOutputAlias =
    crate::operation::ListInstanceProfilesForRole;
#[doc(hidden)]
pub type ListInstanceProfilesForRoleInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListInstanceProfilesForRoleInput {
    /// Consumes the builder and constructs an Operation<[`ListInstanceProfilesForRole`](crate::operation::ListInstanceProfilesForRole)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListInstanceProfilesForRole,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListInstanceProfilesForRoleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListInstanceProfilesForRoleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListInstanceProfilesForRoleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_instance_profiles_for_role(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListInstanceProfilesForRole::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListInstanceProfilesForRole",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListInstanceProfilesForRoleInput`](crate::input::ListInstanceProfilesForRoleInput)
    pub fn builder() -> crate::input::list_instance_profiles_for_role_input::Builder {
        crate::input::list_instance_profiles_for_role_input::Builder::default()
    }
}

/// See [`ListInstanceProfileTagsInput`](crate::input::ListInstanceProfileTagsInput)
pub mod list_instance_profile_tags_input {
    /// A builder for [`ListInstanceProfileTagsInput`](crate::input::ListInstanceProfileTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_profile_name: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the IAM instance profile whose tags you want to see.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn instance_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_profile_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM instance profile whose tags you want to see.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_instance_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_profile_name = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInstanceProfileTagsInput`](crate::input::ListInstanceProfileTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListInstanceProfileTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListInstanceProfileTagsInput {
                instance_profile_name: self.instance_profile_name,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListInstanceProfileTagsInputOperationOutputAlias =
    crate::operation::ListInstanceProfileTags;
#[doc(hidden)]
pub type ListInstanceProfileTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListInstanceProfileTagsInput {
    /// Consumes the builder and constructs an Operation<[`ListInstanceProfileTags`](crate::operation::ListInstanceProfileTags)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListInstanceProfileTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListInstanceProfileTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListInstanceProfileTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListInstanceProfileTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_instance_profile_tags(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListInstanceProfileTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListInstanceProfileTags",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListInstanceProfileTagsInput`](crate::input::ListInstanceProfileTagsInput)
    pub fn builder() -> crate::input::list_instance_profile_tags_input::Builder {
        crate::input::list_instance_profile_tags_input::Builder::default()
    }
}

/// See [`ListMfaDevicesInput`](crate::input::ListMfaDevicesInput)
pub mod list_mfa_devices_input {
    /// A builder for [`ListMfaDevicesInput`](crate::input::ListMfaDevicesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the user whose MFA devices you want to list.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the user whose MFA devices you want to list.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMfaDevicesInput`](crate::input::ListMfaDevicesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListMfaDevicesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListMfaDevicesInput {
                user_name: self.user_name,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListMfaDevicesInputOperationOutputAlias = crate::operation::ListMFADevices;
#[doc(hidden)]
pub type ListMfaDevicesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListMfaDevicesInput {
    /// Consumes the builder and constructs an Operation<[`ListMFADevices`](crate::operation::ListMFADevices)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListMFADevices,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListMfaDevicesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListMfaDevicesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListMfaDevicesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_mfa_devices(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListMFADevices::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListMFADevices",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListMfaDevicesInput`](crate::input::ListMfaDevicesInput)
    pub fn builder() -> crate::input::list_mfa_devices_input::Builder {
        crate::input::list_mfa_devices_input::Builder::default()
    }
}

/// See [`ListMfaDeviceTagsInput`](crate::input::ListMfaDeviceTagsInput)
pub mod list_mfa_device_tags_input {
    /// A builder for [`ListMfaDeviceTagsInput`](crate::input::ListMfaDeviceTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) serial_number: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier for the IAM virtual MFA device whose tags you want to see.
        /// For virtual MFA devices, the serial number is the same as the ARN.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn serial_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.serial_number = Some(input.into());
            self
        }
        /// <p>The unique identifier for the IAM virtual MFA device whose tags you want to see.
        /// For virtual MFA devices, the serial number is the same as the ARN.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.serial_number = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMfaDeviceTagsInput`](crate::input::ListMfaDeviceTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListMfaDeviceTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListMfaDeviceTagsInput {
                serial_number: self.serial_number,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListMfaDeviceTagsInputOperationOutputAlias = crate::operation::ListMFADeviceTags;
#[doc(hidden)]
pub type ListMfaDeviceTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListMfaDeviceTagsInput {
    /// Consumes the builder and constructs an Operation<[`ListMFADeviceTags`](crate::operation::ListMFADeviceTags)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListMFADeviceTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListMfaDeviceTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListMfaDeviceTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListMfaDeviceTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_mfa_device_tags(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListMFADeviceTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListMFADeviceTags",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListMfaDeviceTagsInput`](crate::input::ListMfaDeviceTagsInput)
    pub fn builder() -> crate::input::list_mfa_device_tags_input::Builder {
        crate::input::list_mfa_device_tags_input::Builder::default()
    }
}

/// See [`ListOpenIdConnectProvidersInput`](crate::input::ListOpenIdConnectProvidersInput)
pub mod list_open_id_connect_providers_input {
    /// A builder for [`ListOpenIdConnectProvidersInput`](crate::input::ListOpenIdConnectProvidersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ListOpenIdConnectProvidersInput`](crate::input::ListOpenIdConnectProvidersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListOpenIdConnectProvidersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListOpenIdConnectProvidersInput {})
        }
    }
}
#[doc(hidden)]
pub type ListOpenIdConnectProvidersInputOperationOutputAlias =
    crate::operation::ListOpenIDConnectProviders;
#[doc(hidden)]
pub type ListOpenIdConnectProvidersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListOpenIdConnectProvidersInput {
    /// Consumes the builder and constructs an Operation<[`ListOpenIDConnectProviders`](crate::operation::ListOpenIDConnectProviders)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListOpenIDConnectProviders,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListOpenIdConnectProvidersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListOpenIdConnectProvidersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListOpenIdConnectProvidersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_open_id_connect_providers(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListOpenIDConnectProviders::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListOpenIDConnectProviders",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListOpenIdConnectProvidersInput`](crate::input::ListOpenIdConnectProvidersInput)
    pub fn builder() -> crate::input::list_open_id_connect_providers_input::Builder {
        crate::input::list_open_id_connect_providers_input::Builder::default()
    }
}

/// See [`ListOpenIdConnectProviderTagsInput`](crate::input::ListOpenIdConnectProviderTagsInput)
pub mod list_open_id_connect_provider_tags_input {
    /// A builder for [`ListOpenIdConnectProviderTagsInput`](crate::input::ListOpenIdConnectProviderTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) open_id_connect_provider_arn: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ARN of the OpenID Connect (OIDC) identity provider whose tags you want to
        /// see.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn open_id_connect_provider_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.open_id_connect_provider_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the OpenID Connect (OIDC) identity provider whose tags you want to
        /// see.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_open_id_connect_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.open_id_connect_provider_arn = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOpenIdConnectProviderTagsInput`](crate::input::ListOpenIdConnectProviderTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListOpenIdConnectProviderTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListOpenIdConnectProviderTagsInput {
                open_id_connect_provider_arn: self.open_id_connect_provider_arn,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListOpenIdConnectProviderTagsInputOperationOutputAlias =
    crate::operation::ListOpenIDConnectProviderTags;
#[doc(hidden)]
pub type ListOpenIdConnectProviderTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListOpenIdConnectProviderTagsInput {
    /// Consumes the builder and constructs an Operation<[`ListOpenIDConnectProviderTags`](crate::operation::ListOpenIDConnectProviderTags)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListOpenIDConnectProviderTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListOpenIdConnectProviderTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListOpenIdConnectProviderTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListOpenIdConnectProviderTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_open_id_connect_provider_tags(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListOpenIDConnectProviderTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListOpenIDConnectProviderTags",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListOpenIdConnectProviderTagsInput`](crate::input::ListOpenIdConnectProviderTagsInput)
    pub fn builder() -> crate::input::list_open_id_connect_provider_tags_input::Builder {
        crate::input::list_open_id_connect_provider_tags_input::Builder::default()
    }
}

/// See [`ListPoliciesInput`](crate::input::ListPoliciesInput)
pub mod list_policies_input {
    /// A builder for [`ListPoliciesInput`](crate::input::ListPoliciesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scope: std::option::Option<crate::model::PolicyScopeType>,
        pub(crate) only_attached: std::option::Option<bool>,
        pub(crate) path_prefix: std::option::Option<std::string::String>,
        pub(crate) policy_usage_filter: std::option::Option<crate::model::PolicyUsageType>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The scope to use for filtering the results.</p>
        /// <p>To list only Amazon Web Services managed policies, set <code>Scope</code> to <code>AWS</code>. To
        /// list only the customer managed policies in your Amazon Web Services account, set <code>Scope</code> to
        /// <code>Local</code>.</p>
        /// <p>This parameter is optional. If it is not included, or if it is set to
        /// <code>All</code>, all policies are returned.</p>
        pub fn scope(mut self, input: crate::model::PolicyScopeType) -> Self {
            self.scope = Some(input);
            self
        }
        /// <p>The scope to use for filtering the results.</p>
        /// <p>To list only Amazon Web Services managed policies, set <code>Scope</code> to <code>AWS</code>. To
        /// list only the customer managed policies in your Amazon Web Services account, set <code>Scope</code> to
        /// <code>Local</code>.</p>
        /// <p>This parameter is optional. If it is not included, or if it is set to
        /// <code>All</code>, all policies are returned.</p>
        pub fn set_scope(
            mut self,
            input: std::option::Option<crate::model::PolicyScopeType>,
        ) -> Self {
            self.scope = input;
            self
        }
        /// <p>A flag to filter the results to only the attached policies.</p>
        /// <p>When <code>OnlyAttached</code> is <code>true</code>, the returned list contains only
        /// the policies that are attached to an IAM user, group, or role. When
        /// <code>OnlyAttached</code> is <code>false</code>, or when the parameter is not
        /// included, all policies are returned.</p>
        pub fn only_attached(mut self, input: bool) -> Self {
            self.only_attached = Some(input);
            self
        }
        /// <p>A flag to filter the results to only the attached policies.</p>
        /// <p>When <code>OnlyAttached</code> is <code>true</code>, the returned list contains only
        /// the policies that are attached to an IAM user, group, or role. When
        /// <code>OnlyAttached</code> is <code>false</code>, or when the parameter is not
        /// included, all policies are returned.</p>
        pub fn set_only_attached(mut self, input: std::option::Option<bool>) -> Self {
            self.only_attached = input;
            self
        }
        /// <p>The path prefix for filtering the results. This parameter is optional. If it is not
        /// included, it defaults to a slash (/), listing all policies. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn path_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.path_prefix = Some(input.into());
            self
        }
        /// <p>The path prefix for filtering the results. This parameter is optional. If it is not
        /// included, it defaults to a slash (/), listing all policies. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn set_path_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path_prefix = input;
            self
        }
        /// <p>The policy usage method to use for filtering the results.</p>
        /// <p>To list only permissions policies,
        /// set <code>PolicyUsageFilter</code> to <code>PermissionsPolicy</code>. To list only
        /// the policies used to set permissions boundaries, set the value
        /// to <code>PermissionsBoundary</code>.</p>
        /// <p>This parameter is optional. If it is not included, all policies are returned. </p>
        pub fn policy_usage_filter(mut self, input: crate::model::PolicyUsageType) -> Self {
            self.policy_usage_filter = Some(input);
            self
        }
        /// <p>The policy usage method to use for filtering the results.</p>
        /// <p>To list only permissions policies,
        /// set <code>PolicyUsageFilter</code> to <code>PermissionsPolicy</code>. To list only
        /// the policies used to set permissions boundaries, set the value
        /// to <code>PermissionsBoundary</code>.</p>
        /// <p>This parameter is optional. If it is not included, all policies are returned. </p>
        pub fn set_policy_usage_filter(
            mut self,
            input: std::option::Option<crate::model::PolicyUsageType>,
        ) -> Self {
            self.policy_usage_filter = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPoliciesInput`](crate::input::ListPoliciesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPoliciesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPoliciesInput {
                scope: self.scope,
                only_attached: self.only_attached.unwrap_or_default(),
                path_prefix: self.path_prefix,
                policy_usage_filter: self.policy_usage_filter,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPoliciesInputOperationOutputAlias = crate::operation::ListPolicies;
#[doc(hidden)]
pub type ListPoliciesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListPoliciesInput {
    /// Consumes the builder and constructs an Operation<[`ListPolicies`](crate::operation::ListPolicies)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPolicies,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPoliciesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPoliciesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPoliciesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_policies(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPolicies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPolicies",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPoliciesInput`](crate::input::ListPoliciesInput)
    pub fn builder() -> crate::input::list_policies_input::Builder {
        crate::input::list_policies_input::Builder::default()
    }
}

/// See [`ListPoliciesGrantingServiceAccessInput`](crate::input::ListPoliciesGrantingServiceAccessInput)
pub mod list_policies_granting_service_access_input {
    /// A builder for [`ListPoliciesGrantingServiceAccessInput`](crate::input::ListPoliciesGrantingServiceAccessInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) service_namespaces: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The ARN of the IAM identity (user, group, or role) whose policies you want to
        /// list.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM identity (user, group, or role) whose policies you want to
        /// list.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `service_namespaces`.
        ///
        /// To override the contents of this collection use [`set_service_namespaces`](Self::set_service_namespaces).
        ///
        /// <p>The service namespace for the Amazon Web Services services whose policies you want to list.</p>
        /// <p>To learn the service namespace for a service, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html">Actions, resources, and condition keys for Amazon Web Services services</a> in the
        /// <i>IAM User Guide</i>. Choose the name of the service to view
        /// details for that service. In the first paragraph, find the service prefix. For example,
        /// <code>(service prefix: a4b)</code>. For more information about service namespaces,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces">Amazon Web Services
        /// service namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn service_namespaces(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.service_namespaces.unwrap_or_default();
            v.push(input.into());
            self.service_namespaces = Some(v);
            self
        }
        /// <p>The service namespace for the Amazon Web Services services whose policies you want to list.</p>
        /// <p>To learn the service namespace for a service, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html">Actions, resources, and condition keys for Amazon Web Services services</a> in the
        /// <i>IAM User Guide</i>. Choose the name of the service to view
        /// details for that service. In the first paragraph, find the service prefix. For example,
        /// <code>(service prefix: a4b)</code>. For more information about service namespaces,
        /// see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces">Amazon Web Services
        /// service namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_service_namespaces(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.service_namespaces = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPoliciesGrantingServiceAccessInput`](crate::input::ListPoliciesGrantingServiceAccessInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPoliciesGrantingServiceAccessInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPoliciesGrantingServiceAccessInput {
                marker: self.marker,
                arn: self.arn,
                service_namespaces: self.service_namespaces,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPoliciesGrantingServiceAccessInputOperationOutputAlias =
    crate::operation::ListPoliciesGrantingServiceAccess;
#[doc(hidden)]
pub type ListPoliciesGrantingServiceAccessInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListPoliciesGrantingServiceAccessInput {
    /// Consumes the builder and constructs an Operation<[`ListPoliciesGrantingServiceAccess`](crate::operation::ListPoliciesGrantingServiceAccess)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPoliciesGrantingServiceAccess,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPoliciesGrantingServiceAccessInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPoliciesGrantingServiceAccessInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPoliciesGrantingServiceAccessInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_policies_granting_service_access(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPoliciesGrantingServiceAccess::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPoliciesGrantingServiceAccess",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPoliciesGrantingServiceAccessInput`](crate::input::ListPoliciesGrantingServiceAccessInput)
    pub fn builder() -> crate::input::list_policies_granting_service_access_input::Builder {
        crate::input::list_policies_granting_service_access_input::Builder::default()
    }
}

/// See [`ListPolicyTagsInput`](crate::input::ListPolicyTagsInput)
pub mod list_policy_tags_input {
    /// A builder for [`ListPolicyTagsInput`](crate::input::ListPolicyTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_arn: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ARN of the IAM customer managed policy whose tags you want to see.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM customer managed policy whose tags you want to see.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPolicyTagsInput`](crate::input::ListPolicyTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPolicyTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPolicyTagsInput {
                policy_arn: self.policy_arn,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPolicyTagsInputOperationOutputAlias = crate::operation::ListPolicyTags;
#[doc(hidden)]
pub type ListPolicyTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListPolicyTagsInput {
    /// Consumes the builder and constructs an Operation<[`ListPolicyTags`](crate::operation::ListPolicyTags)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPolicyTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPolicyTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPolicyTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPolicyTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_policy_tags(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPolicyTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPolicyTags",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPolicyTagsInput`](crate::input::ListPolicyTagsInput)
    pub fn builder() -> crate::input::list_policy_tags_input::Builder {
        crate::input::list_policy_tags_input::Builder::default()
    }
}

/// See [`ListPolicyVersionsInput`](crate::input::ListPolicyVersionsInput)
pub mod list_policy_versions_input {
    /// A builder for [`ListPolicyVersionsInput`](crate::input::ListPolicyVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_arn: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the IAM policy for which you want the
        /// versions.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM policy for which you want the
        /// versions.</p>
        /// <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPolicyVersionsInput`](crate::input::ListPolicyVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPolicyVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPolicyVersionsInput {
                policy_arn: self.policy_arn,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPolicyVersionsInputOperationOutputAlias = crate::operation::ListPolicyVersions;
#[doc(hidden)]
pub type ListPolicyVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListPolicyVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListPolicyVersions`](crate::operation::ListPolicyVersions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPolicyVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPolicyVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPolicyVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPolicyVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_policy_versions(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPolicyVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPolicyVersions",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPolicyVersionsInput`](crate::input::ListPolicyVersionsInput)
    pub fn builder() -> crate::input::list_policy_versions_input::Builder {
        crate::input::list_policy_versions_input::Builder::default()
    }
}

/// See [`ListRolePoliciesInput`](crate::input::ListRolePoliciesInput)
pub mod list_role_policies_input {
    /// A builder for [`ListRolePoliciesInput`](crate::input::ListRolePoliciesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_name: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the role to list policies for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>The name of the role to list policies for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRolePoliciesInput`](crate::input::ListRolePoliciesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRolePoliciesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRolePoliciesInput {
                role_name: self.role_name,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRolePoliciesInputOperationOutputAlias = crate::operation::ListRolePolicies;
#[doc(hidden)]
pub type ListRolePoliciesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListRolePoliciesInput {
    /// Consumes the builder and constructs an Operation<[`ListRolePolicies`](crate::operation::ListRolePolicies)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRolePolicies,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRolePoliciesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRolePoliciesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRolePoliciesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_role_policies(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRolePolicies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRolePolicies",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRolePoliciesInput`](crate::input::ListRolePoliciesInput)
    pub fn builder() -> crate::input::list_role_policies_input::Builder {
        crate::input::list_role_policies_input::Builder::default()
    }
}

/// See [`ListRolesInput`](crate::input::ListRolesInput)
pub mod list_roles_input {
    /// A builder for [`ListRolesInput`](crate::input::ListRolesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path_prefix: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The path prefix for filtering the results. For example, the prefix
        /// <code>/application_abc/component_xyz/</code> gets all roles whose path starts with
        /// <code>/application_abc/component_xyz/</code>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/), listing
        /// all roles. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn path_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.path_prefix = Some(input.into());
            self
        }
        /// <p> The path prefix for filtering the results. For example, the prefix
        /// <code>/application_abc/component_xyz/</code> gets all roles whose path starts with
        /// <code>/application_abc/component_xyz/</code>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/), listing
        /// all roles. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn set_path_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path_prefix = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRolesInput`](crate::input::ListRolesInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListRolesInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListRolesInput {
                path_prefix: self.path_prefix,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRolesInputOperationOutputAlias = crate::operation::ListRoles;
#[doc(hidden)]
pub type ListRolesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListRolesInput {
    /// Consumes the builder and constructs an Operation<[`ListRoles`](crate::operation::ListRoles)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRoles,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRolesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRolesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRolesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_roles(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListRoles::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListRoles",
                    "iam",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRolesInput`](crate::input::ListRolesInput)
    pub fn builder() -> crate::input::list_roles_input::Builder {
        crate::input::list_roles_input::Builder::default()
    }
}

/// See [`ListRoleTagsInput`](crate::input::ListRoleTagsInput)
pub mod list_role_tags_input {
    /// A builder for [`ListRoleTagsInput`](crate::input::ListRoleTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_name: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the IAM role for which you want to see the list of tags.</p>
        /// <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM role for which you want to see the list of tags.</p>
        /// <p>This parameter accepts (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters that consist of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRoleTagsInput`](crate::input::ListRoleTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRoleTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRoleTagsInput {
                role_name: self.role_name,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRoleTagsInputOperationOutputAlias = crate::operation::ListRoleTags;
#[doc(hidden)]
pub type ListRoleTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListRoleTagsInput {
    /// Consumes the builder and constructs an Operation<[`ListRoleTags`](crate::operation::ListRoleTags)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRoleTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRoleTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRoleTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRoleTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_role_tags(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRoleTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRoleTags",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRoleTagsInput`](crate::input::ListRoleTagsInput)
    pub fn builder() -> crate::input::list_role_tags_input::Builder {
        crate::input::list_role_tags_input::Builder::default()
    }
}

/// See [`ListSamlProvidersInput`](crate::input::ListSamlProvidersInput)
pub mod list_saml_providers_input {
    /// A builder for [`ListSamlProvidersInput`](crate::input::ListSamlProvidersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ListSamlProvidersInput`](crate::input::ListSamlProvidersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSamlProvidersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSamlProvidersInput {})
        }
    }
}
#[doc(hidden)]
pub type ListSamlProvidersInputOperationOutputAlias = crate::operation::ListSAMLProviders;
#[doc(hidden)]
pub type ListSamlProvidersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSamlProvidersInput {
    /// Consumes the builder and constructs an Operation<[`ListSAMLProviders`](crate::operation::ListSAMLProviders)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSAMLProviders,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSamlProvidersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSamlProvidersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSamlProvidersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_saml_providers(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSAMLProviders::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSAMLProviders",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSamlProvidersInput`](crate::input::ListSamlProvidersInput)
    pub fn builder() -> crate::input::list_saml_providers_input::Builder {
        crate::input::list_saml_providers_input::Builder::default()
    }
}

/// See [`ListSamlProviderTagsInput`](crate::input::ListSamlProviderTagsInput)
pub mod list_saml_provider_tags_input {
    /// A builder for [`ListSamlProviderTagsInput`](crate::input::ListSamlProviderTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) saml_provider_arn: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ARN of the Security Assertion Markup Language (SAML) identity provider whose tags
        /// you want to see.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn saml_provider_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.saml_provider_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Security Assertion Markup Language (SAML) identity provider whose tags
        /// you want to see.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_saml_provider_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.saml_provider_arn = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSamlProviderTagsInput`](crate::input::ListSamlProviderTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSamlProviderTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSamlProviderTagsInput {
                saml_provider_arn: self.saml_provider_arn,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSamlProviderTagsInputOperationOutputAlias = crate::operation::ListSAMLProviderTags;
#[doc(hidden)]
pub type ListSamlProviderTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSamlProviderTagsInput {
    /// Consumes the builder and constructs an Operation<[`ListSAMLProviderTags`](crate::operation::ListSAMLProviderTags)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSAMLProviderTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSamlProviderTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSamlProviderTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSamlProviderTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_saml_provider_tags(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSAMLProviderTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSAMLProviderTags",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSamlProviderTagsInput`](crate::input::ListSamlProviderTagsInput)
    pub fn builder() -> crate::input::list_saml_provider_tags_input::Builder {
        crate::input::list_saml_provider_tags_input::Builder::default()
    }
}

/// See [`ListServerCertificatesInput`](crate::input::ListServerCertificatesInput)
pub mod list_server_certificates_input {
    /// A builder for [`ListServerCertificatesInput`](crate::input::ListServerCertificatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path_prefix: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The path prefix for filtering the results. For example:
        /// <code>/company/servercerts</code> would get all server certificates for which the
        /// path starts with <code>/company/servercerts</code>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/), listing
        /// all server certificates. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn path_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.path_prefix = Some(input.into());
            self
        }
        /// <p> The path prefix for filtering the results. For example:
        /// <code>/company/servercerts</code> would get all server certificates for which the
        /// path starts with <code>/company/servercerts</code>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/), listing
        /// all server certificates. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn set_path_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path_prefix = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListServerCertificatesInput`](crate::input::ListServerCertificatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListServerCertificatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListServerCertificatesInput {
                path_prefix: self.path_prefix,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListServerCertificatesInputOperationOutputAlias = crate::operation::ListServerCertificates;
#[doc(hidden)]
pub type ListServerCertificatesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListServerCertificatesInput {
    /// Consumes the builder and constructs an Operation<[`ListServerCertificates`](crate::operation::ListServerCertificates)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListServerCertificates,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListServerCertificatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListServerCertificatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListServerCertificatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_server_certificates(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListServerCertificates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListServerCertificates",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListServerCertificatesInput`](crate::input::ListServerCertificatesInput)
    pub fn builder() -> crate::input::list_server_certificates_input::Builder {
        crate::input::list_server_certificates_input::Builder::default()
    }
}

/// See [`ListServerCertificateTagsInput`](crate::input::ListServerCertificateTagsInput)
pub mod list_server_certificate_tags_input {
    /// A builder for [`ListServerCertificateTagsInput`](crate::input::ListServerCertificateTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_certificate_name: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the IAM server certificate whose tags you want to see.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn server_certificate_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_certificate_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM server certificate whose tags you want to see.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_server_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.server_certificate_name = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListServerCertificateTagsInput`](crate::input::ListServerCertificateTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListServerCertificateTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListServerCertificateTagsInput {
                server_certificate_name: self.server_certificate_name,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListServerCertificateTagsInputOperationOutputAlias =
    crate::operation::ListServerCertificateTags;
#[doc(hidden)]
pub type ListServerCertificateTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListServerCertificateTagsInput {
    /// Consumes the builder and constructs an Operation<[`ListServerCertificateTags`](crate::operation::ListServerCertificateTags)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListServerCertificateTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListServerCertificateTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListServerCertificateTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListServerCertificateTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_server_certificate_tags(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListServerCertificateTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListServerCertificateTags",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListServerCertificateTagsInput`](crate::input::ListServerCertificateTagsInput)
    pub fn builder() -> crate::input::list_server_certificate_tags_input::Builder {
        crate::input::list_server_certificate_tags_input::Builder::default()
    }
}

/// See [`ListServiceSpecificCredentialsInput`](crate::input::ListServiceSpecificCredentialsInput)
pub mod list_service_specific_credentials_input {
    /// A builder for [`ListServiceSpecificCredentialsInput`](crate::input::ListServiceSpecificCredentialsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) service_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the user whose service-specific credentials you want information about. If
        /// this value is not specified, then the operation assumes the user whose credentials are
        /// used to call the operation.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the user whose service-specific credentials you want information about. If
        /// this value is not specified, then the operation assumes the user whose credentials are
        /// used to call the operation.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>Filters the returned results to only those for the specified Amazon Web Services service. If not
        /// specified, then Amazon Web Services returns service-specific credentials for all services.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>Filters the returned results to only those for the specified Amazon Web Services service. If not
        /// specified, then Amazon Web Services returns service-specific credentials for all services.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ListServiceSpecificCredentialsInput`](crate::input::ListServiceSpecificCredentialsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListServiceSpecificCredentialsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListServiceSpecificCredentialsInput {
                user_name: self.user_name,
                service_name: self.service_name,
            })
        }
    }
}
#[doc(hidden)]
pub type ListServiceSpecificCredentialsInputOperationOutputAlias =
    crate::operation::ListServiceSpecificCredentials;
#[doc(hidden)]
pub type ListServiceSpecificCredentialsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListServiceSpecificCredentialsInput {
    /// Consumes the builder and constructs an Operation<[`ListServiceSpecificCredentials`](crate::operation::ListServiceSpecificCredentials)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListServiceSpecificCredentials,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListServiceSpecificCredentialsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListServiceSpecificCredentialsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListServiceSpecificCredentialsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_service_specific_credentials(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListServiceSpecificCredentials::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListServiceSpecificCredentials",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListServiceSpecificCredentialsInput`](crate::input::ListServiceSpecificCredentialsInput)
    pub fn builder() -> crate::input::list_service_specific_credentials_input::Builder {
        crate::input::list_service_specific_credentials_input::Builder::default()
    }
}

/// See [`ListSigningCertificatesInput`](crate::input::ListSigningCertificatesInput)
pub mod list_signing_certificates_input {
    /// A builder for [`ListSigningCertificatesInput`](crate::input::ListSigningCertificatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the IAM user whose signing certificates you want to examine.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM user whose signing certificates you want to examine.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSigningCertificatesInput`](crate::input::ListSigningCertificatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSigningCertificatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSigningCertificatesInput {
                user_name: self.user_name,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSigningCertificatesInputOperationOutputAlias =
    crate::operation::ListSigningCertificates;
#[doc(hidden)]
pub type ListSigningCertificatesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSigningCertificatesInput {
    /// Consumes the builder and constructs an Operation<[`ListSigningCertificates`](crate::operation::ListSigningCertificates)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSigningCertificates,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSigningCertificatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSigningCertificatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSigningCertificatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_signing_certificates(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSigningCertificates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSigningCertificates",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSigningCertificatesInput`](crate::input::ListSigningCertificatesInput)
    pub fn builder() -> crate::input::list_signing_certificates_input::Builder {
        crate::input::list_signing_certificates_input::Builder::default()
    }
}

/// See [`ListSshPublicKeysInput`](crate::input::ListSshPublicKeysInput)
pub mod list_ssh_public_keys_input {
    /// A builder for [`ListSshPublicKeysInput`](crate::input::ListSshPublicKeysInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the IAM user to list SSH public keys for. If none is specified, the
        /// <code>UserName</code> field is determined implicitly based on the Amazon Web Services access key
        /// used to sign the request.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM user to list SSH public keys for. If none is specified, the
        /// <code>UserName</code> field is determined implicitly based on the Amazon Web Services access key
        /// used to sign the request.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSshPublicKeysInput`](crate::input::ListSshPublicKeysInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSshPublicKeysInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSshPublicKeysInput {
                user_name: self.user_name,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSshPublicKeysInputOperationOutputAlias = crate::operation::ListSSHPublicKeys;
#[doc(hidden)]
pub type ListSshPublicKeysInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListSshPublicKeysInput {
    /// Consumes the builder and constructs an Operation<[`ListSSHPublicKeys`](crate::operation::ListSSHPublicKeys)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSSHPublicKeys,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSshPublicKeysInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSshPublicKeysInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSshPublicKeysInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_ssh_public_keys(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSSHPublicKeys::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSSHPublicKeys",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSshPublicKeysInput`](crate::input::ListSshPublicKeysInput)
    pub fn builder() -> crate::input::list_ssh_public_keys_input::Builder {
        crate::input::list_ssh_public_keys_input::Builder::default()
    }
}

/// See [`ListUserPoliciesInput`](crate::input::ListUserPoliciesInput)
pub mod list_user_policies_input {
    /// A builder for [`ListUserPoliciesInput`](crate::input::ListUserPoliciesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the user to list policies for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the user to list policies for.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUserPoliciesInput`](crate::input::ListUserPoliciesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListUserPoliciesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListUserPoliciesInput {
                user_name: self.user_name,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListUserPoliciesInputOperationOutputAlias = crate::operation::ListUserPolicies;
#[doc(hidden)]
pub type ListUserPoliciesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListUserPoliciesInput {
    /// Consumes the builder and constructs an Operation<[`ListUserPolicies`](crate::operation::ListUserPolicies)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListUserPolicies,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListUserPoliciesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListUserPoliciesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListUserPoliciesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_user_policies(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListUserPolicies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListUserPolicies",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListUserPoliciesInput`](crate::input::ListUserPoliciesInput)
    pub fn builder() -> crate::input::list_user_policies_input::Builder {
        crate::input::list_user_policies_input::Builder::default()
    }
}

/// See [`ListUsersInput`](crate::input::ListUsersInput)
pub mod list_users_input {
    /// A builder for [`ListUsersInput`](crate::input::ListUsersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path_prefix: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The path prefix for filtering the results. For example:
        /// <code>/division_abc/subdivision_xyz/</code>, which would get all user names whose
        /// path starts with <code>/division_abc/subdivision_xyz/</code>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/), listing
        /// all user names. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn path_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.path_prefix = Some(input.into());
            self
        }
        /// <p> The path prefix for filtering the results. For example:
        /// <code>/division_abc/subdivision_xyz/</code>, which would get all user names whose
        /// path starts with <code>/division_abc/subdivision_xyz/</code>.</p>
        /// <p>This parameter is optional. If it is not included, it defaults to a slash (/), listing
        /// all user names. This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting
        /// of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
        /// In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
        /// most punctuation characters, digits, and upper and lowercased letters.</p>
        pub fn set_path_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path_prefix = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUsersInput`](crate::input::ListUsersInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListUsersInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListUsersInput {
                path_prefix: self.path_prefix,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListUsersInputOperationOutputAlias = crate::operation::ListUsers;
#[doc(hidden)]
pub type ListUsersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListUsersInput {
    /// Consumes the builder and constructs an Operation<[`ListUsers`](crate::operation::ListUsers)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListUsers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListUsersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListUsersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListUsersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_users(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListUsers::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListUsers",
                    "iam",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListUsersInput`](crate::input::ListUsersInput)
    pub fn builder() -> crate::input::list_users_input::Builder {
        crate::input::list_users_input::Builder::default()
    }
}

/// See [`ListUserTagsInput`](crate::input::ListUserTagsInput)
pub mod list_user_tags_input {
    /// A builder for [`ListUserTagsInput`](crate::input::ListUserTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the IAM user whose tags you want to see.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM user whose tags you want to see.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUserTagsInput`](crate::input::ListUserTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListUserTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListUserTagsInput {
                user_name: self.user_name,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListUserTagsInputOperationOutputAlias = crate::operation::ListUserTags;
#[doc(hidden)]
pub type ListUserTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListUserTagsInput {
    /// Consumes the builder and constructs an Operation<[`ListUserTags`](crate::operation::ListUserTags)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListUserTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListUserTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListUserTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListUserTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_user_tags(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListUserTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListUserTags",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListUserTagsInput`](crate::input::ListUserTagsInput)
    pub fn builder() -> crate::input::list_user_tags_input::Builder {
        crate::input::list_user_tags_input::Builder::default()
    }
}

/// See [`ListVirtualMfaDevicesInput`](crate::input::ListVirtualMfaDevicesInput)
pub mod list_virtual_mfa_devices_input {
    /// A builder for [`ListVirtualMfaDevicesInput`](crate::input::ListVirtualMfaDevicesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assignment_status: std::option::Option<crate::model::AssignmentStatusType>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_items: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The status (<code>Unassigned</code> or <code>Assigned</code>) of the devices to list.
        /// If you do not specify an <code>AssignmentStatus</code>, the operation defaults to
        /// <code>Any</code>, which lists both assigned and unassigned virtual MFA
        /// devices.,</p>
        pub fn assignment_status(mut self, input: crate::model::AssignmentStatusType) -> Self {
            self.assignment_status = Some(input);
            self
        }
        /// <p> The status (<code>Unassigned</code> or <code>Assigned</code>) of the devices to list.
        /// If you do not specify an <code>AssignmentStatus</code>, the operation defaults to
        /// <code>Any</code>, which lists both assigned and unassigned virtual MFA
        /// devices.,</p>
        pub fn set_assignment_status(
            mut self,
            input: std::option::Option<crate::model::AssignmentStatusType>,
        ) -> Self {
            self.assignment_status = input;
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Use this parameter only when paginating results and only after
        /// you receive a response indicating that the results are truncated. Set it to the value of the
        /// <code>Marker</code> element in the response that you received to indicate where the next call
        /// should start.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn max_items(mut self, input: i32) -> Self {
            self.max_items = Some(input);
            self
        }
        /// <p>Use this only when paginating results to indicate the
        /// maximum number of items you want in the response. If additional items exist beyond the maximum
        /// you specify, the <code>IsTruncated</code> response element is <code>true</code>.</p>
        /// <p>If you do not include this parameter, the number of items defaults to 100. Note that
        /// IAM might return fewer results, even when there are more results available. In that case, the
        /// <code>IsTruncated</code> response element returns <code>true</code>, and <code>Marker</code>
        /// contains a value to include in the subsequent call that tells the service where to continue
        /// from.</p>
        pub fn set_max_items(mut self, input: std::option::Option<i32>) -> Self {
            self.max_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ListVirtualMfaDevicesInput`](crate::input::ListVirtualMfaDevicesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListVirtualMfaDevicesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListVirtualMfaDevicesInput {
                assignment_status: self.assignment_status,
                marker: self.marker,
                max_items: self.max_items,
            })
        }
    }
}
#[doc(hidden)]
pub type ListVirtualMfaDevicesInputOperationOutputAlias = crate::operation::ListVirtualMFADevices;
#[doc(hidden)]
pub type ListVirtualMfaDevicesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListVirtualMfaDevicesInput {
    /// Consumes the builder and constructs an Operation<[`ListVirtualMFADevices`](crate::operation::ListVirtualMFADevices)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListVirtualMFADevices,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListVirtualMfaDevicesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListVirtualMfaDevicesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListVirtualMfaDevicesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_virtual_mfa_devices(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListVirtualMFADevices::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListVirtualMFADevices",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListVirtualMfaDevicesInput`](crate::input::ListVirtualMfaDevicesInput)
    pub fn builder() -> crate::input::list_virtual_mfa_devices_input::Builder {
        crate::input::list_virtual_mfa_devices_input::Builder::default()
    }
}

/// See [`PutGroupPolicyInput`](crate::input::PutGroupPolicyInput)
pub mod put_group_policy_input {
    /// A builder for [`PutGroupPolicyInput`](crate::input::PutGroupPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy_document: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the group to associate the policy with.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the group to associate the policy with.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The name of the policy document.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy document.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The policy document.</p>
        ///
        /// <p>You must provide policies in JSON format in IAM. However, for CloudFormation
        /// templates formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to JSON format before submitting it to
        /// =            IAM.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_document = Some(input.into());
            self
        }
        /// <p>The policy document.</p>
        ///
        /// <p>You must provide policies in JSON format in IAM. However, for CloudFormation
        /// templates formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to JSON format before submitting it to
        /// =            IAM.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_document = input;
            self
        }
        /// Consumes the builder and constructs a [`PutGroupPolicyInput`](crate::input::PutGroupPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutGroupPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutGroupPolicyInput {
                group_name: self.group_name,
                policy_name: self.policy_name,
                policy_document: self.policy_document,
            })
        }
    }
}
#[doc(hidden)]
pub type PutGroupPolicyInputOperationOutputAlias = crate::operation::PutGroupPolicy;
#[doc(hidden)]
pub type PutGroupPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutGroupPolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutGroupPolicy`](crate::operation::PutGroupPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutGroupPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutGroupPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutGroupPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutGroupPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_group_policy(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutGroupPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutGroupPolicy",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutGroupPolicyInput`](crate::input::PutGroupPolicyInput)
    pub fn builder() -> crate::input::put_group_policy_input::Builder {
        crate::input::put_group_policy_input::Builder::default()
    }
}

/// See [`PutRolePermissionsBoundaryInput`](crate::input::PutRolePermissionsBoundaryInput)
pub mod put_role_permissions_boundary_input {
    /// A builder for [`PutRolePermissionsBoundaryInput`](crate::input::PutRolePermissionsBoundaryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_name: std::option::Option<std::string::String>,
        pub(crate) permissions_boundary: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name (friendly name, not ARN) of the IAM role for which you want to set the
        /// permissions boundary.</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>The name (friendly name, not ARN) of the IAM role for which you want to set the
        /// permissions boundary.</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// <p>The ARN of the policy that is used to set the permissions boundary for the
        /// role.</p>
        pub fn permissions_boundary(mut self, input: impl Into<std::string::String>) -> Self {
            self.permissions_boundary = Some(input.into());
            self
        }
        /// <p>The ARN of the policy that is used to set the permissions boundary for the
        /// role.</p>
        pub fn set_permissions_boundary(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.permissions_boundary = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRolePermissionsBoundaryInput`](crate::input::PutRolePermissionsBoundaryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutRolePermissionsBoundaryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutRolePermissionsBoundaryInput {
                role_name: self.role_name,
                permissions_boundary: self.permissions_boundary,
            })
        }
    }
}
#[doc(hidden)]
pub type PutRolePermissionsBoundaryInputOperationOutputAlias =
    crate::operation::PutRolePermissionsBoundary;
#[doc(hidden)]
pub type PutRolePermissionsBoundaryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutRolePermissionsBoundaryInput {
    /// Consumes the builder and constructs an Operation<[`PutRolePermissionsBoundary`](crate::operation::PutRolePermissionsBoundary)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutRolePermissionsBoundary,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutRolePermissionsBoundaryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutRolePermissionsBoundaryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutRolePermissionsBoundaryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_role_permissions_boundary(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutRolePermissionsBoundary::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutRolePermissionsBoundary",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutRolePermissionsBoundaryInput`](crate::input::PutRolePermissionsBoundaryInput)
    pub fn builder() -> crate::input::put_role_permissions_boundary_input::Builder {
        crate::input::put_role_permissions_boundary_input::Builder::default()
    }
}

/// See [`PutRolePolicyInput`](crate::input::PutRolePolicyInput)
pub mod put_role_policy_input {
    /// A builder for [`PutRolePolicyInput`](crate::input::PutRolePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_name: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy_document: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the role to associate the policy with.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_name = Some(input.into());
            self
        }
        /// <p>The name of the role to associate the policy with.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_role_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_name = input;
            self
        }
        /// <p>The name of the policy document.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy document.</p>
        /// <p>This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of upper and lowercase alphanumeric
        /// characters with no spaces. You can also include any of the following characters: _+=,.@-</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The policy document.</p>
        /// <p>You must provide policies in JSON format in IAM. However, for CloudFormation
        /// templates formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to JSON format before submitting it to
        /// IAM.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_document = Some(input.into());
            self
        }
        /// <p>The policy document.</p>
        /// <p>You must provide policies in JSON format in IAM. However, for CloudFormation
        /// templates formatted in YAML, you can provide the policy in JSON or YAML format. CloudFormation always converts a YAML policy to JSON format before submitting it to
        /// IAM.</p>
        /// <p>The <a href="http://wikipedia.org/wiki/regex">regex pattern</a>
        /// used to validate this parameter is a string of characters consisting of the following:</p>
        /// <ul>
        /// <li>
        /// <p>Any printable ASCII
        /// character ranging from the space character (<code>\u0020</code>) through the end of the ASCII character range</p>
        /// </li>
        /// <li>
        /// <p>The printable characters in the Basic Latin and  Latin-1 Supplement character set
        /// (through <code>\u00FF</code>)</p>
        /// </li>
        /// <li>
        /// <p>The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and
        /// carriage return (<code>\u000D</code>)</p>
        /// </li>
        /// </ul>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_document = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRolePolicyInput`](crate::input::PutRolePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutRolePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutRolePolicyInput {
                role_name: self.role_name,
                policy_name: self.policy_name,
                policy_document: self.policy_document,
            })
        }
    }
}
#[doc(hidden)]
pub type PutRolePolicyInputOperationOutputAlias = crate::operation::PutRolePolicy;
#[doc(hidden)]
pub type PutRolePolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutRolePolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutRolePolicy`](crate::operation::PutRolePolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutRolePolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutRolePolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutRolePolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutRolePolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-www-form-urlencoded",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_put_role_policy(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutRolePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutRolePolicy",
            "iam",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            bu