// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`BatchCreateTableRowsInput`](crate::input::BatchCreateTableRowsInput)
pub mod batch_create_table_rows_input {
    /// A builder for [`BatchCreateTableRowsInput`](crate::input::BatchCreateTableRowsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workbook_id: std::option::Option<std::string::String>,
        pub(crate) table_id: std::option::Option<std::string::String>,
        pub(crate) rows_to_create: std::option::Option<std::vec::Vec<crate::model::CreateRowData>>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the workbook where the new rows are being added.</p>
        /// <p> If a workbook with the specified ID could not be found, this API throws ResourceNotFoundException. </p>
        pub fn workbook_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workbook_id = Some(input.into());
            self
        }
        /// <p>The ID of the workbook where the new rows are being added.</p>
        /// <p> If a workbook with the specified ID could not be found, this API throws ResourceNotFoundException. </p>
        pub fn set_workbook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workbook_id = input;
            self
        }
        /// <p>The ID of the table where the new rows are being added.</p>
        /// <p> If a table with the specified ID could not be found, this API throws ResourceNotFoundException. </p>
        pub fn table_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_id = Some(input.into());
            self
        }
        /// <p>The ID of the table where the new rows are being added.</p>
        /// <p> If a table with the specified ID could not be found, this API throws ResourceNotFoundException. </p>
        pub fn set_table_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_id = input;
            self
        }
        /// Appends an item to `rows_to_create`.
        ///
        /// To override the contents of this collection use [`set_rows_to_create`](Self::set_rows_to_create).
        ///
        /// <p> The list of rows to create at the end of the table. Each item in this list needs to have a batch item id to uniquely identify the element in the request and the cells to create for that row. You need to specify at least one item in this list. </p>
        /// <p> Note that if one of the column ids in any of the rows in the request does not exist in the table, then the request fails and no updates are made to the table. </p>
        pub fn rows_to_create(mut self, input: crate::model::CreateRowData) -> Self {
            let mut v = self.rows_to_create.unwrap_or_default();
            v.push(input);
            self.rows_to_create = Some(v);
            self
        }
        /// <p> The list of rows to create at the end of the table. Each item in this list needs to have a batch item id to uniquely identify the element in the request and the cells to create for that row. You need to specify at least one item in this list. </p>
        /// <p> Note that if one of the column ids in any of the rows in the request does not exist in the table, then the request fails and no updates are made to the table. </p>
        pub fn set_rows_to_create(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CreateRowData>>,
        ) -> Self {
            self.rows_to_create = input;
            self
        }
        /// <p> The request token for performing the batch create operation. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the operation again. </p>
        /// <p> Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p> The request token for performing the batch create operation. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the operation again. </p>
        /// <p> Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchCreateTableRowsInput`](crate::input::BatchCreateTableRowsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchCreateTableRowsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchCreateTableRowsInput {
                workbook_id: self.workbook_id,
                table_id: self.table_id,
                rows_to_create: self.rows_to_create,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchCreateTableRowsInputOperationOutputAlias = crate::operation::BatchCreateTableRows;
#[doc(hidden)]
pub type BatchCreateTableRowsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchCreateTableRowsInput {
    /// Consumes the builder and constructs an Operation<[`BatchCreateTableRows`](crate::operation::BatchCreateTableRows)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchCreateTableRows,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchCreateTableRowsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.workbook_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workbook_id",
                        details: "cannot be empty or unset",
                    })?;
            let workbook_id = aws_smithy_http::label::fmt_string(input_1, false);
            if workbook_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workbook_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_2 = &_input.table_id;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "table_id",
                        details: "cannot be empty or unset",
                    })?;
            let table_id = aws_smithy_http::label::fmt_string(input_2, false);
            if table_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "table_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workbooks/{workbookId}/tables/{tableId}/rows/batchcreate",
                workbookId = workbook_id,
                tableId = table_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchCreateTableRowsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchCreateTableRowsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_create_table_rows(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchCreateTableRows::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchCreateTableRows",
            "honeycode",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchCreateTableRowsInput`](crate::input::BatchCreateTableRowsInput)
    pub fn builder() -> crate::input::batch_create_table_rows_input::Builder {
        crate::input::batch_create_table_rows_input::Builder::default()
    }
}

/// See [`BatchDeleteTableRowsInput`](crate::input::BatchDeleteTableRowsInput)
pub mod batch_delete_table_rows_input {
    /// A builder for [`BatchDeleteTableRowsInput`](crate::input::BatchDeleteTableRowsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workbook_id: std::option::Option<std::string::String>,
        pub(crate) table_id: std::option::Option<std::string::String>,
        pub(crate) row_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the workbook where the rows are being deleted.</p>
        /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn workbook_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workbook_id = Some(input.into());
            self
        }
        /// <p>The ID of the workbook where the rows are being deleted.</p>
        /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn set_workbook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workbook_id = input;
            self
        }
        /// <p>The ID of the table where the rows are being deleted.</p>
        /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn table_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_id = Some(input.into());
            self
        }
        /// <p>The ID of the table where the rows are being deleted.</p>
        /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn set_table_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_id = input;
            self
        }
        /// Appends an item to `row_ids`.
        ///
        /// To override the contents of this collection use [`set_row_ids`](Self::set_row_ids).
        ///
        /// <p> The list of row ids to delete from the table. You need to specify at least one row id in this list. </p>
        /// <p> Note that if one of the row ids provided in the request does not exist in the table, then the request fails and no rows are deleted from the table. </p>
        pub fn row_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.row_ids.unwrap_or_default();
            v.push(input.into());
            self.row_ids = Some(v);
            self
        }
        /// <p> The list of row ids to delete from the table. You need to specify at least one row id in this list. </p>
        /// <p> Note that if one of the row ids provided in the request does not exist in the table, then the request fails and no rows are deleted from the table. </p>
        pub fn set_row_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.row_ids = input;
            self
        }
        /// <p> The request token for performing the delete action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the action again. </p>
        /// <p> Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p> The request token for performing the delete action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the action again. </p>
        /// <p> Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteTableRowsInput`](crate::input::BatchDeleteTableRowsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchDeleteTableRowsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchDeleteTableRowsInput {
                workbook_id: self.workbook_id,
                table_id: self.table_id,
                row_ids: self.row_ids,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchDeleteTableRowsInputOperationOutputAlias = crate::operation::BatchDeleteTableRows;
#[doc(hidden)]
pub type BatchDeleteTableRowsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchDeleteTableRowsInput {
    /// Consumes the builder and constructs an Operation<[`BatchDeleteTableRows`](crate::operation::BatchDeleteTableRows)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchDeleteTableRows,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchDeleteTableRowsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.workbook_id;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workbook_id",
                        details: "cannot be empty or unset",
                    })?;
            let workbook_id = aws_smithy_http::label::fmt_string(input_3, false);
            if workbook_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workbook_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_4 = &_input.table_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "table_id",
                        details: "cannot be empty or unset",
                    })?;
            let table_id = aws_smithy_http::label::fmt_string(input_4, false);
            if table_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "table_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workbooks/{workbookId}/tables/{tableId}/rows/batchdelete",
                workbookId = workbook_id,
                tableId = table_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchDeleteTableRowsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchDeleteTableRowsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_delete_table_rows(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchDeleteTableRows::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchDeleteTableRows",
            "honeycode",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchDeleteTableRowsInput`](crate::input::BatchDeleteTableRowsInput)
    pub fn builder() -> crate::input::batch_delete_table_rows_input::Builder {
        crate::input::batch_delete_table_rows_input::Builder::default()
    }
}

/// See [`BatchUpdateTableRowsInput`](crate::input::BatchUpdateTableRowsInput)
pub mod batch_update_table_rows_input {
    /// A builder for [`BatchUpdateTableRowsInput`](crate::input::BatchUpdateTableRowsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workbook_id: std::option::Option<std::string::String>,
        pub(crate) table_id: std::option::Option<std::string::String>,
        pub(crate) rows_to_update: std::option::Option<std::vec::Vec<crate::model::UpdateRowData>>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the workbook where the rows are being updated.</p>
        /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn workbook_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workbook_id = Some(input.into());
            self
        }
        /// <p>The ID of the workbook where the rows are being updated.</p>
        /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn set_workbook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workbook_id = input;
            self
        }
        /// <p>The ID of the table where the rows are being updated.</p>
        /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn table_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_id = Some(input.into());
            self
        }
        /// <p>The ID of the table where the rows are being updated.</p>
        /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn set_table_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_id = input;
            self
        }
        /// Appends an item to `rows_to_update`.
        ///
        /// To override the contents of this collection use [`set_rows_to_update`](Self::set_rows_to_update).
        ///
        /// <p> The list of rows to update in the table. Each item in this list needs to contain the row id to update along with the map of column id to cell values for each column in that row that needs to be updated. You need to specify at least one row in this list, and for each row, you need to specify at least one column to update. </p>
        /// <p> Note that if one of the row or column ids in the request does not exist in the table, then the request fails and no updates are made to the table. </p>
        pub fn rows_to_update(mut self, input: crate::model::UpdateRowData) -> Self {
            let mut v = self.rows_to_update.unwrap_or_default();
            v.push(input);
            self.rows_to_update = Some(v);
            self
        }
        /// <p> The list of rows to update in the table. Each item in this list needs to contain the row id to update along with the map of column id to cell values for each column in that row that needs to be updated. You need to specify at least one row in this list, and for each row, you need to specify at least one column to update. </p>
        /// <p> Note that if one of the row or column ids in the request does not exist in the table, then the request fails and no updates are made to the table. </p>
        pub fn set_rows_to_update(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpdateRowData>>,
        ) -> Self {
            self.rows_to_update = input;
            self
        }
        /// <p> The request token for performing the update action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the action again. </p>
        /// <p> Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p> The request token for performing the update action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the action again. </p>
        /// <p> Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchUpdateTableRowsInput`](crate::input::BatchUpdateTableRowsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchUpdateTableRowsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchUpdateTableRowsInput {
                workbook_id: self.workbook_id,
                table_id: self.table_id,
                rows_to_update: self.rows_to_update,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchUpdateTableRowsInputOperationOutputAlias = crate::operation::BatchUpdateTableRows;
#[doc(hidden)]
pub type BatchUpdateTableRowsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchUpdateTableRowsInput {
    /// Consumes the builder and constructs an Operation<[`BatchUpdateTableRows`](crate::operation::BatchUpdateTableRows)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchUpdateTableRows,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchUpdateTableRowsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.workbook_id;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workbook_id",
                        details: "cannot be empty or unset",
                    })?;
            let workbook_id = aws_smithy_http::label::fmt_string(input_5, false);
            if workbook_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workbook_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_6 = &_input.table_id;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "table_id",
                        details: "cannot be empty or unset",
                    })?;
            let table_id = aws_smithy_http::label::fmt_string(input_6, false);
            if table_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "table_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workbooks/{workbookId}/tables/{tableId}/rows/batchupdate",
                workbookId = workbook_id,
                tableId = table_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchUpdateTableRowsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchUpdateTableRowsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_update_table_rows(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchUpdateTableRows::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchUpdateTableRows",
            "honeycode",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchUpdateTableRowsInput`](crate::input::BatchUpdateTableRowsInput)
    pub fn builder() -> crate::input::batch_update_table_rows_input::Builder {
        crate::input::batch_update_table_rows_input::Builder::default()
    }
}

/// See [`BatchUpsertTableRowsInput`](crate::input::BatchUpsertTableRowsInput)
pub mod batch_upsert_table_rows_input {
    /// A builder for [`BatchUpsertTableRowsInput`](crate::input::BatchUpsertTableRowsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workbook_id: std::option::Option<std::string::String>,
        pub(crate) table_id: std::option::Option<std::string::String>,
        pub(crate) rows_to_upsert: std::option::Option<std::vec::Vec<crate::model::UpsertRowData>>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the workbook where the rows are being upserted.</p>
        /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn workbook_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workbook_id = Some(input.into());
            self
        }
        /// <p>The ID of the workbook where the rows are being upserted.</p>
        /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn set_workbook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workbook_id = input;
            self
        }
        /// <p>The ID of the table where the rows are being upserted.</p>
        /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn table_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_id = Some(input.into());
            self
        }
        /// <p>The ID of the table where the rows are being upserted.</p>
        /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn set_table_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_id = input;
            self
        }
        /// Appends an item to `rows_to_upsert`.
        ///
        /// To override the contents of this collection use [`set_rows_to_upsert`](Self::set_rows_to_upsert).
        ///
        /// <p> The list of rows to upsert in the table. Each item in this list needs to have a batch item id to uniquely identify the element in the request, a filter expression to find the rows to update for that element and the cell values to set for each column in the upserted rows. You need to specify at least one item in this list. </p>
        /// <p> Note that if one of the filter formulas in the request fails to evaluate because of an error or one of the column ids in any of the rows does not exist in the table, then the request fails and no updates are made to the table. </p>
        pub fn rows_to_upsert(mut self, input: crate::model::UpsertRowData) -> Self {
            let mut v = self.rows_to_upsert.unwrap_or_default();
            v.push(input);
            self.rows_to_upsert = Some(v);
            self
        }
        /// <p> The list of rows to upsert in the table. Each item in this list needs to have a batch item id to uniquely identify the element in the request, a filter expression to find the rows to update for that element and the cell values to set for each column in the upserted rows. You need to specify at least one item in this list. </p>
        /// <p> Note that if one of the filter formulas in the request fails to evaluate because of an error or one of the column ids in any of the rows does not exist in the table, then the request fails and no updates are made to the table. </p>
        pub fn set_rows_to_upsert(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpsertRowData>>,
        ) -> Self {
            self.rows_to_upsert = input;
            self
        }
        /// <p> The request token for performing the update action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the action again. </p>
        /// <p> Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p> The request token for performing the update action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the action again. </p>
        /// <p> Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchUpsertTableRowsInput`](crate::input::BatchUpsertTableRowsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchUpsertTableRowsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchUpsertTableRowsInput {
                workbook_id: self.workbook_id,
                table_id: self.table_id,
                rows_to_upsert: self.rows_to_upsert,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchUpsertTableRowsInputOperationOutputAlias = crate::operation::BatchUpsertTableRows;
#[doc(hidden)]
pub type BatchUpsertTableRowsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchUpsertTableRowsInput {
    /// Consumes the builder and constructs an Operation<[`BatchUpsertTableRows`](crate::operation::BatchUpsertTableRows)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchUpsertTableRows,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchUpsertTableRowsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.workbook_id;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workbook_id",
                        details: "cannot be empty or unset",
                    })?;
            let workbook_id = aws_smithy_http::label::fmt_string(input_7, false);
            if workbook_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workbook_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_8 = &_input.table_id;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "table_id",
                        details: "cannot be empty or unset",
                    })?;
            let table_id = aws_smithy_http::label::fmt_string(input_8, false);
            if table_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "table_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workbooks/{workbookId}/tables/{tableId}/rows/batchupsert",
                workbookId = workbook_id,
                tableId = table_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchUpsertTableRowsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchUpsertTableRowsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_upsert_table_rows(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchUpsertTableRows::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchUpsertTableRows",
            "honeycode",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchUpsertTableRowsInput`](crate::input::BatchUpsertTableRowsInput)
    pub fn builder() -> crate::input::batch_upsert_table_rows_input::Builder {
        crate::input::batch_upsert_table_rows_input::Builder::default()
    }
}

/// See [`DescribeTableDataImportJobInput`](crate::input::DescribeTableDataImportJobInput)
pub mod describe_table_data_import_job_input {
    /// A builder for [`DescribeTableDataImportJobInput`](crate::input::DescribeTableDataImportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workbook_id: std::option::Option<std::string::String>,
        pub(crate) table_id: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the workbook into which data was imported.</p>
        /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn workbook_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workbook_id = Some(input.into());
            self
        }
        /// <p>The ID of the workbook into which data was imported.</p>
        /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn set_workbook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workbook_id = input;
            self
        }
        /// <p>The ID of the table into which data was imported.</p>
        /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn table_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_id = Some(input.into());
            self
        }
        /// <p>The ID of the table into which data was imported.</p>
        /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn set_table_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_id = input;
            self
        }
        /// <p>The ID of the job that was returned by the StartTableDataImportJob request.</p>
        /// <p> If a job with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The ID of the job that was returned by the StartTableDataImportJob request.</p>
        /// <p> If a job with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTableDataImportJobInput`](crate::input::DescribeTableDataImportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTableDataImportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTableDataImportJobInput {
                workbook_id: self.workbook_id,
                table_id: self.table_id,
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTableDataImportJobInputOperationOutputAlias =
    crate::operation::DescribeTableDataImportJob;
#[doc(hidden)]
pub type DescribeTableDataImportJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeTableDataImportJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTableDataImportJob`](crate::operation::DescribeTableDataImportJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTableDataImportJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTableDataImportJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.workbook_id;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workbook_id",
                        details: "cannot be empty or unset",
                    })?;
            let workbook_id = aws_smithy_http::label::fmt_string(input_9, false);
            if workbook_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workbook_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_10 = &_input.table_id;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "table_id",
                        details: "cannot be empty or unset",
                    })?;
            let table_id = aws_smithy_http::label::fmt_string(input_10, false);
            if table_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "table_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_11 = &_input.job_id;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    })?;
            let job_id = aws_smithy_http::label::fmt_string(input_11, false);
            if job_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "job_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workbooks/{workbookId}/tables/{tableId}/import/{jobId}",
                workbookId = workbook_id,
                tableId = table_id,
                jobId = job_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTableDataImportJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTableDataImportJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTableDataImportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTableDataImportJob",
            "honeycode",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTableDataImportJobInput`](crate::input::DescribeTableDataImportJobInput)
    pub fn builder() -> crate::input::describe_table_data_import_job_input::Builder {
        crate::input::describe_table_data_import_job_input::Builder::default()
    }
}

/// See [`GetScreenDataInput`](crate::input::GetScreenDataInput)
pub mod get_screen_data_input {
    /// A builder for [`GetScreenDataInput`](crate::input::GetScreenDataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workbook_id: std::option::Option<std::string::String>,
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) screen_id: std::option::Option<std::string::String>,
        pub(crate) variables: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::VariableValue>,
        >,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the workbook that contains the screen.</p>
        pub fn workbook_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workbook_id = Some(input.into());
            self
        }
        /// <p>The ID of the workbook that contains the screen.</p>
        pub fn set_workbook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workbook_id = input;
            self
        }
        /// <p>The ID of the app that contains the screen.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The ID of the app that contains the screen.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The ID of the screen.</p>
        pub fn screen_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.screen_id = Some(input.into());
            self
        }
        /// <p>The ID of the screen.</p>
        pub fn set_screen_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.screen_id = input;
            self
        }
        /// Adds a key-value pair to `variables`.
        ///
        /// To override the contents of this collection use [`set_variables`](Self::set_variables).
        ///
        /// <p> Variables are optional and are needed only if the screen requires them to render correctly. Variables are specified as a map where the key is the name of the variable as defined on the screen. The value is an object which currently has only one property, rawValue, which holds the value of the variable to be passed to the screen. </p>
        pub fn variables(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::VariableValue,
        ) -> Self {
            let mut hash_map = self.variables.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.variables = Some(hash_map);
            self
        }
        /// <p> Variables are optional and are needed only if the screen requires them to render correctly. Variables are specified as a map where the key is the name of the variable as defined on the screen. The value is an object which currently has only one property, rawValue, which holds the value of the variable to be passed to the screen. </p>
        pub fn set_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::VariableValue>,
            >,
        ) -> Self {
            self.variables = input;
            self
        }
        /// <p> The number of results to be returned on a single page. Specify a number between 1 and 100. The maximum value is 100. </p>
        /// <p> This parameter is optional. If you don't specify this parameter, the default page size is 100. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> The number of results to be returned on a single page. Specify a number between 1 and 100. The maximum value is 100. </p>
        /// <p> This parameter is optional. If you don't specify this parameter, the default page size is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p> This parameter is optional. If a nextToken is not specified, the API returns the first page of data. </p>
        /// <p> Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> This parameter is optional. If a nextToken is not specified, the API returns the first page of data. </p>
        /// <p> Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetScreenDataInput`](crate::input::GetScreenDataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetScreenDataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetScreenDataInput {
                workbook_id: self.workbook_id,
                app_id: self.app_id,
                screen_id: self.screen_id,
                variables: self.variables,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetScreenDataInputOperationOutputAlias = crate::operation::GetScreenData;
#[doc(hidden)]
pub type GetScreenDataInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetScreenDataInput {
    /// Consumes the builder and constructs an Operation<[`GetScreenData`](crate::operation::GetScreenData)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetScreenData,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetScreenDataInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/screendata").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetScreenDataInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetScreenDataInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_screen_data(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetScreenData::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetScreenData",
            "honeycode",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetScreenDataInput`](crate::input::GetScreenDataInput)
    pub fn builder() -> crate::input::get_screen_data_input::Builder {
        crate::input::get_screen_data_input::Builder::default()
    }
}

/// See [`InvokeScreenAutomationInput`](crate::input::InvokeScreenAutomationInput)
pub mod invoke_screen_automation_input {
    /// A builder for [`InvokeScreenAutomationInput`](crate::input::InvokeScreenAutomationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workbook_id: std::option::Option<std::string::String>,
        pub(crate) app_id: std::option::Option<std::string::String>,
        pub(crate) screen_id: std::option::Option<std::string::String>,
        pub(crate) screen_automation_id: std::option::Option<std::string::String>,
        pub(crate) variables: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::VariableValue>,
        >,
        pub(crate) row_id: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the workbook that contains the screen automation.</p>
        pub fn workbook_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workbook_id = Some(input.into());
            self
        }
        /// <p>The ID of the workbook that contains the screen automation.</p>
        pub fn set_workbook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workbook_id = input;
            self
        }
        /// <p>The ID of the app that contains the screen automation.</p>
        pub fn app_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id = Some(input.into());
            self
        }
        /// <p>The ID of the app that contains the screen automation.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.app_id = input;
            self
        }
        /// <p>The ID of the screen that contains the screen automation.</p>
        pub fn screen_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.screen_id = Some(input.into());
            self
        }
        /// <p>The ID of the screen that contains the screen automation.</p>
        pub fn set_screen_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.screen_id = input;
            self
        }
        /// <p>The ID of the automation action to be performed.</p>
        pub fn screen_automation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.screen_automation_id = Some(input.into());
            self
        }
        /// <p>The ID of the automation action to be performed.</p>
        pub fn set_screen_automation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.screen_automation_id = input;
            self
        }
        /// Adds a key-value pair to `variables`.
        ///
        /// To override the contents of this collection use [`set_variables`](Self::set_variables).
        ///
        /// <p> Variables are specified as a map where the key is the name of the variable as defined on the screen. The value is an object which currently has only one property, rawValue, which holds the value of the variable to be passed to the screen. Any variables defined in a screen are required to be passed in the call. </p>
        pub fn variables(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::VariableValue,
        ) -> Self {
            let mut hash_map = self.variables.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.variables = Some(hash_map);
            self
        }
        /// <p> Variables are specified as a map where the key is the name of the variable as defined on the screen. The value is an object which currently has only one property, rawValue, which holds the value of the variable to be passed to the screen. Any variables defined in a screen are required to be passed in the call. </p>
        pub fn set_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::VariableValue>,
            >,
        ) -> Self {
            self.variables = input;
            self
        }
        /// <p> The row ID for the automation if the automation is defined inside a block with source or list. </p>
        pub fn row_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.row_id = Some(input.into());
            self
        }
        /// <p> The row ID for the automation if the automation is defined inside a block with source or list. </p>
        pub fn set_row_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.row_id = input;
            self
        }
        /// <p> The request token for performing the automation action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will return the response of the previous call rather than performing the action again. </p>
        /// <p> Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p> The request token for performing the automation action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will return the response of the previous call rather than performing the action again. </p>
        /// <p> Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`InvokeScreenAutomationInput`](crate::input::InvokeScreenAutomationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::InvokeScreenAutomationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::InvokeScreenAutomationInput {
                workbook_id: self.workbook_id,
                app_id: self.app_id,
                screen_id: self.screen_id,
                screen_automation_id: self.screen_automation_id,
                variables: self.variables,
                row_id: self.row_id,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type InvokeScreenAutomationInputOperationOutputAlias = crate::operation::InvokeScreenAutomation;
#[doc(hidden)]
pub type InvokeScreenAutomationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl InvokeScreenAutomationInput {
    /// Consumes the builder and constructs an Operation<[`InvokeScreenAutomation`](crate::operation::InvokeScreenAutomation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::InvokeScreenAutomation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::InvokeScreenAutomationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_12 = &_input.workbook_id;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workbook_id",
                        details: "cannot be empty or unset",
                    })?;
            let workbook_id = aws_smithy_http::label::fmt_string(input_12, false);
            if workbook_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workbook_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_13 = &_input.app_id;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "app_id",
                        details: "cannot be empty or unset",
                    })?;
            let app_id = aws_smithy_http::label::fmt_string(input_13, false);
            if app_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "app_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_14 = &_input.screen_id;
            let input_14 =
                input_14
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "screen_id",
                        details: "cannot be empty or unset",
                    })?;
            let screen_id = aws_smithy_http::label::fmt_string(input_14, false);
            if screen_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "screen_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_15 = &_input.screen_automation_id;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "screen_automation_id",
                        details: "cannot be empty or unset",
                    })?;
            let screen_automation_id = aws_smithy_http::label::fmt_string(input_15, false);
            if screen_automation_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "screen_automation_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/workbooks/{workbookId}/apps/{appId}/screens/{screenId}/automations/{screenAutomationId}", workbookId = workbook_id, appId = app_id, screenId = screen_id, screenAutomationId = screen_automation_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::InvokeScreenAutomationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::InvokeScreenAutomationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_invoke_screen_automation(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::InvokeScreenAutomation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "InvokeScreenAutomation",
            "honeycode",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`InvokeScreenAutomationInput`](crate::input::InvokeScreenAutomationInput)
    pub fn builder() -> crate::input::invoke_screen_automation_input::Builder {
        crate::input::invoke_screen_automation_input::Builder::default()
    }
}

/// See [`ListTableColumnsInput`](crate::input::ListTableColumnsInput)
pub mod list_table_columns_input {
    /// A builder for [`ListTableColumnsInput`](crate::input::ListTableColumnsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workbook_id: std::option::Option<std::string::String>,
        pub(crate) table_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the workbook that contains the table whose columns are being retrieved.</p>
        /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn workbook_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workbook_id = Some(input.into());
            self
        }
        /// <p>The ID of the workbook that contains the table whose columns are being retrieved.</p>
        /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn set_workbook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workbook_id = input;
            self
        }
        /// <p>The ID of the table whose columns are being retrieved.</p>
        /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn table_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_id = Some(input.into());
            self
        }
        /// <p>The ID of the table whose columns are being retrieved.</p>
        /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn set_table_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_id = input;
            self
        }
        /// <p> This parameter is optional. If a nextToken is not specified, the API returns the first page of data. </p>
        /// <p> Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> This parameter is optional. If a nextToken is not specified, the API returns the first page of data. </p>
        /// <p> Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTableColumnsInput`](crate::input::ListTableColumnsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTableColumnsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTableColumnsInput {
                workbook_id: self.workbook_id,
                table_id: self.table_id,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTableColumnsInputOperationOutputAlias = crate::operation::ListTableColumns;
#[doc(hidden)]
pub type ListTableColumnsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTableColumnsInput {
    /// Consumes the builder and constructs an Operation<[`ListTableColumns`](crate::operation::ListTableColumns)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTableColumns,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTableColumnsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_16 = &_input.workbook_id;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workbook_id",
                        details: "cannot be empty or unset",
                    })?;
            let workbook_id = aws_smithy_http::label::fmt_string(input_16, false);
            if workbook_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workbook_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_17 = &_input.table_id;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "table_id",
                        details: "cannot be empty or unset",
                    })?;
            let table_id = aws_smithy_http::label::fmt_string(input_17, false);
            if table_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "table_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workbooks/{workbookId}/tables/{tableId}/columns",
                workbookId = workbook_id,
                tableId = table_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListTableColumnsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_18) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_18));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTableColumnsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTableColumnsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTableColumns::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTableColumns",
            "honeycode",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTableColumnsInput`](crate::input::ListTableColumnsInput)
    pub fn builder() -> crate::input::list_table_columns_input::Builder {
        crate::input::list_table_columns_input::Builder::default()
    }
}

/// See [`ListTableRowsInput`](crate::input::ListTableRowsInput)
pub mod list_table_rows_input {
    /// A builder for [`ListTableRowsInput`](crate::input::ListTableRowsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workbook_id: std::option::Option<std::string::String>,
        pub(crate) table_id: std::option::Option<std::string::String>,
        pub(crate) row_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the workbook that contains the table whose rows are being retrieved.</p>
        /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn workbook_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workbook_id = Some(input.into());
            self
        }
        /// <p>The ID of the workbook that contains the table whose rows are being retrieved.</p>
        /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn set_workbook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workbook_id = input;
            self
        }
        /// <p>The ID of the table whose rows are being retrieved.</p>
        /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn table_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_id = Some(input.into());
            self
        }
        /// <p>The ID of the table whose rows are being retrieved.</p>
        /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn set_table_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_id = input;
            self
        }
        /// Appends an item to `row_ids`.
        ///
        /// To override the contents of this collection use [`set_row_ids`](Self::set_row_ids).
        ///
        /// <p> This parameter is optional. If one or more row ids are specified in this list, then only the specified row ids are returned in the result. If no row ids are specified here, then all the rows in the table are returned. </p>
        pub fn row_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.row_ids.unwrap_or_default();
            v.push(input.into());
            self.row_ids = Some(v);
            self
        }
        /// <p> This parameter is optional. If one or more row ids are specified in this list, then only the specified row ids are returned in the result. If no row ids are specified here, then all the rows in the table are returned. </p>
        pub fn set_row_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.row_ids = input;
            self
        }
        /// <p>The maximum number of rows to return in each page of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of rows to return in each page of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p> This parameter is optional. If a nextToken is not specified, the API returns the first page of data. </p>
        /// <p> Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> This parameter is optional. If a nextToken is not specified, the API returns the first page of data. </p>
        /// <p> Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTableRowsInput`](crate::input::ListTableRowsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTableRowsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTableRowsInput {
                workbook_id: self.workbook_id,
                table_id: self.table_id,
                row_ids: self.row_ids,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTableRowsInputOperationOutputAlias = crate::operation::ListTableRows;
#[doc(hidden)]
pub type ListTableRowsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTableRowsInput {
    /// Consumes the builder and constructs an Operation<[`ListTableRows`](crate::operation::ListTableRows)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTableRows,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTableRowsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_19 = &_input.workbook_id;
            let input_19 =
                input_19
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workbook_id",
                        details: "cannot be empty or unset",
                    })?;
            let workbook_id = aws_smithy_http::label::fmt_string(input_19, false);
            if workbook_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workbook_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_20 = &_input.table_id;
            let input_20 =
                input_20
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "table_id",
                        details: "cannot be empty or unset",
                    })?;
            let table_id = aws_smithy_http::label::fmt_string(input_20, false);
            if table_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "table_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workbooks/{workbookId}/tables/{tableId}/rows/list",
                workbookId = workbook_id,
                tableId = table_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTableRowsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTableRowsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_table_rows(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTableRows::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTableRows",
            "honeycode",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTableRowsInput`](crate::input::ListTableRowsInput)
    pub fn builder() -> crate::input::list_table_rows_input::Builder {
        crate::input::list_table_rows_input::Builder::default()
    }
}

/// See [`ListTablesInput`](crate::input::ListTablesInput)
pub mod list_tables_input {
    /// A builder for [`ListTablesInput`](crate::input::ListTablesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workbook_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the workbook whose tables are being retrieved.</p>
        /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn workbook_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workbook_id = Some(input.into());
            self
        }
        /// <p>The ID of the workbook whose tables are being retrieved.</p>
        /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn set_workbook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workbook_id = input;
            self
        }
        /// <p>The maximum number of tables to return in each page of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of tables to return in each page of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p> This parameter is optional. If a nextToken is not specified, the API returns the first page of data. </p>
        /// <p> Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> This parameter is optional. If a nextToken is not specified, the API returns the first page of data. </p>
        /// <p> Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTablesInput`](crate::input::ListTablesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTablesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTablesInput {
                workbook_id: self.workbook_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTablesInputOperationOutputAlias = crate::operation::ListTables;
#[doc(hidden)]
pub type ListTablesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTablesInput {
    /// Consumes the builder and constructs an Operation<[`ListTables`](crate::operation::ListTables)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTables,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTablesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_21 = &_input.workbook_id;
            let input_21 =
                input_21
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workbook_id",
                        details: "cannot be empty or unset",
                    })?;
            let workbook_id = aws_smithy_http::label::fmt_string(input_21, false);
            if workbook_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workbook_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workbooks/{workbookId}/tables",
                workbookId = workbook_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListTablesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_22) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_22).encode(),
                );
            }
            if let Some(inner_23) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_23));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTablesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTablesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTables::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTables",
            "honeycode",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTablesInput`](crate::input::ListTablesInput)
    pub fn builder() -> crate::input::list_tables_input::Builder {
        crate::input::list_tables_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource's Amazon Resource Name (ARN).</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The resource's Amazon Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_24 = &_input.resource_arn;
            let input_24 =
                input_24
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_24, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "honeycode",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`QueryTableRowsInput`](crate::input::QueryTableRowsInput)
pub mod query_table_rows_input {
    /// A builder for [`QueryTableRowsInput`](crate::input::QueryTableRowsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workbook_id: std::option::Option<std::string::String>,
        pub(crate) table_id: std::option::Option<std::string::String>,
        pub(crate) filter_formula: std::option::Option<crate::model::Filter>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the workbook whose table rows are being queried.</p>
        /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn workbook_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workbook_id = Some(input.into());
            self
        }
        /// <p>The ID of the workbook whose table rows are being queried.</p>
        /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn set_workbook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workbook_id = input;
            self
        }
        /// <p>The ID of the table whose rows are being queried.</p>
        /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn table_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_id = Some(input.into());
            self
        }
        /// <p>The ID of the table whose rows are being queried.</p>
        /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn set_table_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_id = input;
            self
        }
        /// <p>An object that represents a filter formula along with the id of the context row under which the filter function needs to evaluate.</p>
        pub fn filter_formula(mut self, input: crate::model::Filter) -> Self {
            self.filter_formula = Some(input);
            self
        }
        /// <p>An object that represents a filter formula along with the id of the context row under which the filter function needs to evaluate.</p>
        pub fn set_filter_formula(
            mut self,
            input: std::option::Option<crate::model::Filter>,
        ) -> Self {
            self.filter_formula = input;
            self
        }
        /// <p>The maximum number of rows to return in each page of the results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of rows to return in each page of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p> This parameter is optional. If a nextToken is not specified, the API returns the first page of data. </p>
        /// <p> Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> This parameter is optional. If a nextToken is not specified, the API returns the first page of data. </p>
        /// <p> Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryTableRowsInput`](crate::input::QueryTableRowsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::QueryTableRowsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::QueryTableRowsInput {
                workbook_id: self.workbook_id,
                table_id: self.table_id,
                filter_formula: self.filter_formula,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type QueryTableRowsInputOperationOutputAlias = crate::operation::QueryTableRows;
#[doc(hidden)]
pub type QueryTableRowsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl QueryTableRowsInput {
    /// Consumes the builder and constructs an Operation<[`QueryTableRows`](crate::operation::QueryTableRows)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::QueryTableRows,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::QueryTableRowsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_25 = &_input.workbook_id;
            let input_25 =
                input_25
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workbook_id",
                        details: "cannot be empty or unset",
                    })?;
            let workbook_id = aws_smithy_http::label::fmt_string(input_25, false);
            if workbook_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workbook_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_26 = &_input.table_id;
            let input_26 =
                input_26
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "table_id",
                        details: "cannot be empty or unset",
                    })?;
            let table_id = aws_smithy_http::label::fmt_string(input_26, false);
            if table_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "table_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workbooks/{workbookId}/tables/{tableId}/rows/query",
                workbookId = workbook_id,
                tableId = table_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::QueryTableRowsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::QueryTableRowsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_query_table_rows(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::QueryTableRows::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "QueryTableRows",
            "honeycode",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`QueryTableRowsInput`](crate::input::QueryTableRowsInput)
    pub fn builder() -> crate::input::query_table_rows_input::Builder {
        crate::input::query_table_rows_input::Builder::default()
    }
}

/// See [`StartTableDataImportJobInput`](crate::input::StartTableDataImportJobInput)
pub mod start_table_data_import_job_input {
    /// A builder for [`StartTableDataImportJobInput`](crate::input::StartTableDataImportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workbook_id: std::option::Option<std::string::String>,
        pub(crate) data_source: std::option::Option<crate::model::ImportDataSource>,
        pub(crate) data_format: std::option::Option<crate::model::ImportSourceDataFormat>,
        pub(crate) destination_table_id: std::option::Option<std::string::String>,
        pub(crate) import_options: std::option::Option<crate::model::ImportOptions>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the workbook where the rows are being imported.</p>
        /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn workbook_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workbook_id = Some(input.into());
            self
        }
        /// <p>The ID of the workbook where the rows are being imported.</p>
        /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn set_workbook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workbook_id = input;
            self
        }
        /// <p> The source of the data that is being imported. The size of source must be no larger than 100 MB. Source must have no more than 100,000 cells and no more than 1,000 rows. </p>
        pub fn data_source(mut self, input: crate::model::ImportDataSource) -> Self {
            self.data_source = Some(input);
            self
        }
        /// <p> The source of the data that is being imported. The size of source must be no larger than 100 MB. Source must have no more than 100,000 cells and no more than 1,000 rows. </p>
        pub fn set_data_source(
            mut self,
            input: std::option::Option<crate::model::ImportDataSource>,
        ) -> Self {
            self.data_source = input;
            self
        }
        /// <p> The format of the data that is being imported. Currently the only option supported is "DELIMITED_TEXT". </p>
        pub fn data_format(mut self, input: crate::model::ImportSourceDataFormat) -> Self {
            self.data_format = Some(input);
            self
        }
        /// <p> The format of the data that is being imported. Currently the only option supported is "DELIMITED_TEXT". </p>
        pub fn set_data_format(
            mut self,
            input: std::option::Option<crate::model::ImportSourceDataFormat>,
        ) -> Self {
            self.data_format = input;
            self
        }
        /// <p>The ID of the table where the rows are being imported.</p>
        /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn destination_table_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_table_id = Some(input.into());
            self
        }
        /// <p>The ID of the table where the rows are being imported.</p>
        /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
        pub fn set_destination_table_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_table_id = input;
            self
        }
        /// <p> The options for customizing this import request. </p>
        pub fn import_options(mut self, input: crate::model::ImportOptions) -> Self {
            self.import_options = Some(input);
            self
        }
        /// <p> The options for customizing this import request. </p>
        pub fn set_import_options(
            mut self,
            input: std::option::Option<crate::model::ImportOptions>,
        ) -> Self {
            self.import_options = input;
            self
        }
        /// <p> The request token for performing the update action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the action again. </p>
        /// <p> Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. </p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p> The request token for performing the update action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the action again. </p>
        /// <p> Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`StartTableDataImportJobInput`](crate::input::StartTableDataImportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartTableDataImportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartTableDataImportJobInput {
                workbook_id: self.workbook_id,
                data_source: self.data_source,
                data_format: self.data_format,
                destination_table_id: self.destination_table_id,
                import_options: self.import_options,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type StartTableDataImportJobInputOperationOutputAlias =
    crate::operation::StartTableDataImportJob;
#[doc(hidden)]
pub type StartTableDataImportJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartTableDataImportJobInput {
    /// Consumes the builder and constructs an Operation<[`StartTableDataImportJob`](crate::operation::StartTableDataImportJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartTableDataImportJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartTableDataImportJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_27 = &_input.workbook_id;
            let input_27 =
                input_27
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workbook_id",
                        details: "cannot be empty or unset",
                    })?;
            let workbook_id = aws_smithy_http::label::fmt_string(input_27, false);
            if workbook_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "workbook_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_28 = &_input.destination_table_id;
            let input_28 =
                input_28
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "destination_table_id",
                        details: "cannot be empty or unset",
                    })?;
            let destination_table_id = aws_smithy_http::label::fmt_string(input_28, false);
            if destination_table_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "destination_table_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/workbooks/{workbookId}/tables/{destinationTableId}/import",
                workbookId = workbook_id,
                destinationTableId = destination_table_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartTableDataImportJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartTableDataImportJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_table_data_import_job(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartTableDataImportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartTableDataImportJob",
            "honeycode",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartTableDataImportJobInput`](crate::input::StartTableDataImportJobInput)
    pub fn builder() -> crate::input::start_table_data_import_job_input::Builder {
        crate::input::start_table_data_import_job_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The resource's Amazon Resource Name (ARN).</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The resource's Amazon Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags to apply to the resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of tags to apply to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_29 = &_input.resource_arn;
            let input_29 =
                input_29
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_29, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "honeycode",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The resource's Amazon Resource Name (ARN).</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The resource's Amazon Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A list of tag keys to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_30 = &_input.resource_arn;
            let input_30 =
                input_30
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_30, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UntagResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_31) = &_input.tag_keys {
                for inner_32 in inner_31 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_32));
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "honeycode",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The resource's Amazon Resource Name (ARN).</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of tag keys to remove from the resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The resource's Amazon Resource Name (ARN).</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of tag keys to remove from the resource.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The resource's Amazon Resource Name (ARN).</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of tags to apply to the resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The resource's Amazon Resource Name (ARN).</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of tags to apply to the resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartTableDataImportJobInput {
    /// <p>The ID of the workbook where the rows are being imported.</p>
    /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub workbook_id: std::option::Option<std::string::String>,
    /// <p> The source of the data that is being imported. The size of source must be no larger than 100 MB. Source must have no more than 100,000 cells and no more than 1,000 rows. </p>
    pub data_source: std::option::Option<crate::model::ImportDataSource>,
    /// <p> The format of the data that is being imported. Currently the only option supported is "DELIMITED_TEXT". </p>
    pub data_format: std::option::Option<crate::model::ImportSourceDataFormat>,
    /// <p>The ID of the table where the rows are being imported.</p>
    /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub destination_table_id: std::option::Option<std::string::String>,
    /// <p> The options for customizing this import request. </p>
    pub import_options: std::option::Option<crate::model::ImportOptions>,
    /// <p> The request token for performing the update action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the action again. </p>
    /// <p> Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. </p>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl StartTableDataImportJobInput {
    /// <p>The ID of the workbook where the rows are being imported.</p>
    /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub fn workbook_id(&self) -> std::option::Option<&str> {
        self.workbook_id.as_deref()
    }
    /// <p> The source of the data that is being imported. The size of source must be no larger than 100 MB. Source must have no more than 100,000 cells and no more than 1,000 rows. </p>
    pub fn data_source(&self) -> std::option::Option<&crate::model::ImportDataSource> {
        self.data_source.as_ref()
    }
    /// <p> The format of the data that is being imported. Currently the only option supported is "DELIMITED_TEXT". </p>
    pub fn data_format(&self) -> std::option::Option<&crate::model::ImportSourceDataFormat> {
        self.data_format.as_ref()
    }
    /// <p>The ID of the table where the rows are being imported.</p>
    /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub fn destination_table_id(&self) -> std::option::Option<&str> {
        self.destination_table_id.as_deref()
    }
    /// <p> The options for customizing this import request. </p>
    pub fn import_options(&self) -> std::option::Option<&crate::model::ImportOptions> {
        self.import_options.as_ref()
    }
    /// <p> The request token for performing the update action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the action again. </p>
    /// <p> Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. </p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
}
impl std::fmt::Debug for StartTableDataImportJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartTableDataImportJobInput");
        formatter.field("workbook_id", &self.workbook_id);
        formatter.field("data_source", &self.data_source);
        formatter.field("data_format", &self.data_format);
        formatter.field("destination_table_id", &self.destination_table_id);
        formatter.field("import_options", &self.import_options);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryTableRowsInput {
    /// <p>The ID of the workbook whose table rows are being queried.</p>
    /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub workbook_id: std::option::Option<std::string::String>,
    /// <p>The ID of the table whose rows are being queried.</p>
    /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub table_id: std::option::Option<std::string::String>,
    /// <p>An object that represents a filter formula along with the id of the context row under which the filter function needs to evaluate.</p>
    pub filter_formula: std::option::Option<crate::model::Filter>,
    /// <p>The maximum number of rows to return in each page of the results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p> This parameter is optional. If a nextToken is not specified, the API returns the first page of data. </p>
    /// <p> Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl QueryTableRowsInput {
    /// <p>The ID of the workbook whose table rows are being queried.</p>
    /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub fn workbook_id(&self) -> std::option::Option<&str> {
        self.workbook_id.as_deref()
    }
    /// <p>The ID of the table whose rows are being queried.</p>
    /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub fn table_id(&self) -> std::option::Option<&str> {
        self.table_id.as_deref()
    }
    /// <p>An object that represents a filter formula along with the id of the context row under which the filter function needs to evaluate.</p>
    pub fn filter_formula(&self) -> std::option::Option<&crate::model::Filter> {
        self.filter_formula.as_ref()
    }
    /// <p>The maximum number of rows to return in each page of the results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p> This parameter is optional. If a nextToken is not specified, the API returns the first page of data. </p>
    /// <p> Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for QueryTableRowsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryTableRowsInput");
        formatter.field("workbook_id", &self.workbook_id);
        formatter.field("table_id", &self.table_id);
        formatter.field("filter_formula", &self.filter_formula);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The resource's Amazon Resource Name (ARN).</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The resource's Amazon Resource Name (ARN).</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTablesInput {
    /// <p>The ID of the workbook whose tables are being retrieved.</p>
    /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub workbook_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of tables to return in each page of the results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p> This parameter is optional. If a nextToken is not specified, the API returns the first page of data. </p>
    /// <p> Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTablesInput {
    /// <p>The ID of the workbook whose tables are being retrieved.</p>
    /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub fn workbook_id(&self) -> std::option::Option<&str> {
        self.workbook_id.as_deref()
    }
    /// <p>The maximum number of tables to return in each page of the results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p> This parameter is optional. If a nextToken is not specified, the API returns the first page of data. </p>
    /// <p> Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTablesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTablesInput");
        formatter.field("workbook_id", &self.workbook_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTableRowsInput {
    /// <p>The ID of the workbook that contains the table whose rows are being retrieved.</p>
    /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub workbook_id: std::option::Option<std::string::String>,
    /// <p>The ID of the table whose rows are being retrieved.</p>
    /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub table_id: std::option::Option<std::string::String>,
    /// <p> This parameter is optional. If one or more row ids are specified in this list, then only the specified row ids are returned in the result. If no row ids are specified here, then all the rows in the table are returned. </p>
    pub row_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum number of rows to return in each page of the results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p> This parameter is optional. If a nextToken is not specified, the API returns the first page of data. </p>
    /// <p> Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTableRowsInput {
    /// <p>The ID of the workbook that contains the table whose rows are being retrieved.</p>
    /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub fn workbook_id(&self) -> std::option::Option<&str> {
        self.workbook_id.as_deref()
    }
    /// <p>The ID of the table whose rows are being retrieved.</p>
    /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub fn table_id(&self) -> std::option::Option<&str> {
        self.table_id.as_deref()
    }
    /// <p> This parameter is optional. If one or more row ids are specified in this list, then only the specified row ids are returned in the result. If no row ids are specified here, then all the rows in the table are returned. </p>
    pub fn row_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.row_ids.as_deref()
    }
    /// <p>The maximum number of rows to return in each page of the results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p> This parameter is optional. If a nextToken is not specified, the API returns the first page of data. </p>
    /// <p> Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTableRowsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTableRowsInput");
        formatter.field("workbook_id", &self.workbook_id);
        formatter.field("table_id", &self.table_id);
        formatter.field("row_ids", &self.row_ids);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTableColumnsInput {
    /// <p>The ID of the workbook that contains the table whose columns are being retrieved.</p>
    /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub workbook_id: std::option::Option<std::string::String>,
    /// <p>The ID of the table whose columns are being retrieved.</p>
    /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub table_id: std::option::Option<std::string::String>,
    /// <p> This parameter is optional. If a nextToken is not specified, the API returns the first page of data. </p>
    /// <p> Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTableColumnsInput {
    /// <p>The ID of the workbook that contains the table whose columns are being retrieved.</p>
    /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub fn workbook_id(&self) -> std::option::Option<&str> {
        self.workbook_id.as_deref()
    }
    /// <p>The ID of the table whose columns are being retrieved.</p>
    /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub fn table_id(&self) -> std::option::Option<&str> {
        self.table_id.as_deref()
    }
    /// <p> This parameter is optional. If a nextToken is not specified, the API returns the first page of data. </p>
    /// <p> Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTableColumnsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTableColumnsInput");
        formatter.field("workbook_id", &self.workbook_id);
        formatter.field("table_id", &self.table_id);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvokeScreenAutomationInput {
    /// <p>The ID of the workbook that contains the screen automation.</p>
    pub workbook_id: std::option::Option<std::string::String>,
    /// <p>The ID of the app that contains the screen automation.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The ID of the screen that contains the screen automation.</p>
    pub screen_id: std::option::Option<std::string::String>,
    /// <p>The ID of the automation action to be performed.</p>
    pub screen_automation_id: std::option::Option<std::string::String>,
    /// <p> Variables are specified as a map where the key is the name of the variable as defined on the screen. The value is an object which currently has only one property, rawValue, which holds the value of the variable to be passed to the screen. Any variables defined in a screen are required to be passed in the call. </p>
    pub variables: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::VariableValue>,
    >,
    /// <p> The row ID for the automation if the automation is defined inside a block with source or list. </p>
    pub row_id: std::option::Option<std::string::String>,
    /// <p> The request token for performing the automation action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will return the response of the previous call rather than performing the action again. </p>
    /// <p> Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. </p>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl InvokeScreenAutomationInput {
    /// <p>The ID of the workbook that contains the screen automation.</p>
    pub fn workbook_id(&self) -> std::option::Option<&str> {
        self.workbook_id.as_deref()
    }
    /// <p>The ID of the app that contains the screen automation.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The ID of the screen that contains the screen automation.</p>
    pub fn screen_id(&self) -> std::option::Option<&str> {
        self.screen_id.as_deref()
    }
    /// <p>The ID of the automation action to be performed.</p>
    pub fn screen_automation_id(&self) -> std::option::Option<&str> {
        self.screen_automation_id.as_deref()
    }
    /// <p> Variables are specified as a map where the key is the name of the variable as defined on the screen. The value is an object which currently has only one property, rawValue, which holds the value of the variable to be passed to the screen. Any variables defined in a screen are required to be passed in the call. </p>
    pub fn variables(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::VariableValue>,
    > {
        self.variables.as_ref()
    }
    /// <p> The row ID for the automation if the automation is defined inside a block with source or list. </p>
    pub fn row_id(&self) -> std::option::Option<&str> {
        self.row_id.as_deref()
    }
    /// <p> The request token for performing the automation action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will return the response of the previous call rather than performing the action again. </p>
    /// <p> Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. </p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
}
impl std::fmt::Debug for InvokeScreenAutomationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvokeScreenAutomationInput");
        formatter.field("workbook_id", &self.workbook_id);
        formatter.field("app_id", &self.app_id);
        formatter.field("screen_id", &self.screen_id);
        formatter.field("screen_automation_id", &self.screen_automation_id);
        formatter.field("variables", &"*** Sensitive Data Redacted ***");
        formatter.field("row_id", &self.row_id);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetScreenDataInput {
    /// <p>The ID of the workbook that contains the screen.</p>
    pub workbook_id: std::option::Option<std::string::String>,
    /// <p>The ID of the app that contains the screen.</p>
    pub app_id: std::option::Option<std::string::String>,
    /// <p>The ID of the screen.</p>
    pub screen_id: std::option::Option<std::string::String>,
    /// <p> Variables are optional and are needed only if the screen requires them to render correctly. Variables are specified as a map where the key is the name of the variable as defined on the screen. The value is an object which currently has only one property, rawValue, which holds the value of the variable to be passed to the screen. </p>
    pub variables: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::VariableValue>,
    >,
    /// <p> The number of results to be returned on a single page. Specify a number between 1 and 100. The maximum value is 100. </p>
    /// <p> This parameter is optional. If you don't specify this parameter, the default page size is 100. </p>
    pub max_results: std::option::Option<i32>,
    /// <p> This parameter is optional. If a nextToken is not specified, the API returns the first page of data. </p>
    /// <p> Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetScreenDataInput {
    /// <p>The ID of the workbook that contains the screen.</p>
    pub fn workbook_id(&self) -> std::option::Option<&str> {
        self.workbook_id.as_deref()
    }
    /// <p>The ID of the app that contains the screen.</p>
    pub fn app_id(&self) -> std::option::Option<&str> {
        self.app_id.as_deref()
    }
    /// <p>The ID of the screen.</p>
    pub fn screen_id(&self) -> std::option::Option<&str> {
        self.screen_id.as_deref()
    }
    /// <p> Variables are optional and are needed only if the screen requires them to render correctly. Variables are specified as a map where the key is the name of the variable as defined on the screen. The value is an object which currently has only one property, rawValue, which holds the value of the variable to be passed to the screen. </p>
    pub fn variables(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::VariableValue>,
    > {
        self.variables.as_ref()
    }
    /// <p> The number of results to be returned on a single page. Specify a number between 1 and 100. The maximum value is 100. </p>
    /// <p> This parameter is optional. If you don't specify this parameter, the default page size is 100. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p> This parameter is optional. If a nextToken is not specified, the API returns the first page of data. </p>
    /// <p> Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API will throw ValidationException. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetScreenDataInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetScreenDataInput");
        formatter.field("workbook_id", &self.workbook_id);
        formatter.field("app_id", &self.app_id);
        formatter.field("screen_id", &self.screen_id);
        formatter.field("variables", &"*** Sensitive Data Redacted ***");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTableDataImportJobInput {
    /// <p>The ID of the workbook into which data was imported.</p>
    /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub workbook_id: std::option::Option<std::string::String>,
    /// <p>The ID of the table into which data was imported.</p>
    /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub table_id: std::option::Option<std::string::String>,
    /// <p>The ID of the job that was returned by the StartTableDataImportJob request.</p>
    /// <p> If a job with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub job_id: std::option::Option<std::string::String>,
}
impl DescribeTableDataImportJobInput {
    /// <p>The ID of the workbook into which data was imported.</p>
    /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub fn workbook_id(&self) -> std::option::Option<&str> {
        self.workbook_id.as_deref()
    }
    /// <p>The ID of the table into which data was imported.</p>
    /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub fn table_id(&self) -> std::option::Option<&str> {
        self.table_id.as_deref()
    }
    /// <p>The ID of the job that was returned by the StartTableDataImportJob request.</p>
    /// <p> If a job with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeTableDataImportJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTableDataImportJobInput");
        formatter.field("workbook_id", &self.workbook_id);
        formatter.field("table_id", &self.table_id);
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchUpsertTableRowsInput {
    /// <p>The ID of the workbook where the rows are being upserted.</p>
    /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub workbook_id: std::option::Option<std::string::String>,
    /// <p>The ID of the table where the rows are being upserted.</p>
    /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub table_id: std::option::Option<std::string::String>,
    /// <p> The list of rows to upsert in the table. Each item in this list needs to have a batch item id to uniquely identify the element in the request, a filter expression to find the rows to update for that element and the cell values to set for each column in the upserted rows. You need to specify at least one item in this list. </p>
    /// <p> Note that if one of the filter formulas in the request fails to evaluate because of an error or one of the column ids in any of the rows does not exist in the table, then the request fails and no updates are made to the table. </p>
    pub rows_to_upsert: std::option::Option<std::vec::Vec<crate::model::UpsertRowData>>,
    /// <p> The request token for performing the update action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the action again. </p>
    /// <p> Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. </p>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl BatchUpsertTableRowsInput {
    /// <p>The ID of the workbook where the rows are being upserted.</p>
    /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub fn workbook_id(&self) -> std::option::Option<&str> {
        self.workbook_id.as_deref()
    }
    /// <p>The ID of the table where the rows are being upserted.</p>
    /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub fn table_id(&self) -> std::option::Option<&str> {
        self.table_id.as_deref()
    }
    /// <p> The list of rows to upsert in the table. Each item in this list needs to have a batch item id to uniquely identify the element in the request, a filter expression to find the rows to update for that element and the cell values to set for each column in the upserted rows. You need to specify at least one item in this list. </p>
    /// <p> Note that if one of the filter formulas in the request fails to evaluate because of an error or one of the column ids in any of the rows does not exist in the table, then the request fails and no updates are made to the table. </p>
    pub fn rows_to_upsert(&self) -> std::option::Option<&[crate::model::UpsertRowData]> {
        self.rows_to_upsert.as_deref()
    }
    /// <p> The request token for performing the update action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the action again. </p>
    /// <p> Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. </p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
}
impl std::fmt::Debug for BatchUpsertTableRowsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchUpsertTableRowsInput");
        formatter.field("workbook_id", &self.workbook_id);
        formatter.field("table_id", &self.table_id);
        formatter.field("rows_to_upsert", &self.rows_to_upsert);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchUpdateTableRowsInput {
    /// <p>The ID of the workbook where the rows are being updated.</p>
    /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub workbook_id: std::option::Option<std::string::String>,
    /// <p>The ID of the table where the rows are being updated.</p>
    /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub table_id: std::option::Option<std::string::String>,
    /// <p> The list of rows to update in the table. Each item in this list needs to contain the row id to update along with the map of column id to cell values for each column in that row that needs to be updated. You need to specify at least one row in this list, and for each row, you need to specify at least one column to update. </p>
    /// <p> Note that if one of the row or column ids in the request does not exist in the table, then the request fails and no updates are made to the table. </p>
    pub rows_to_update: std::option::Option<std::vec::Vec<crate::model::UpdateRowData>>,
    /// <p> The request token for performing the update action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the action again. </p>
    /// <p> Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. </p>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl BatchUpdateTableRowsInput {
    /// <p>The ID of the workbook where the rows are being updated.</p>
    /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub fn workbook_id(&self) -> std::option::Option<&str> {
        self.workbook_id.as_deref()
    }
    /// <p>The ID of the table where the rows are being updated.</p>
    /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub fn table_id(&self) -> std::option::Option<&str> {
        self.table_id.as_deref()
    }
    /// <p> The list of rows to update in the table. Each item in this list needs to contain the row id to update along with the map of column id to cell values for each column in that row that needs to be updated. You need to specify at least one row in this list, and for each row, you need to specify at least one column to update. </p>
    /// <p> Note that if one of the row or column ids in the request does not exist in the table, then the request fails and no updates are made to the table. </p>
    pub fn rows_to_update(&self) -> std::option::Option<&[crate::model::UpdateRowData]> {
        self.rows_to_update.as_deref()
    }
    /// <p> The request token for performing the update action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the action again. </p>
    /// <p> Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. </p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
}
impl std::fmt::Debug for BatchUpdateTableRowsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchUpdateTableRowsInput");
        formatter.field("workbook_id", &self.workbook_id);
        formatter.field("table_id", &self.table_id);
        formatter.field("rows_to_update", &self.rows_to_update);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteTableRowsInput {
    /// <p>The ID of the workbook where the rows are being deleted.</p>
    /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub workbook_id: std::option::Option<std::string::String>,
    /// <p>The ID of the table where the rows are being deleted.</p>
    /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub table_id: std::option::Option<std::string::String>,
    /// <p> The list of row ids to delete from the table. You need to specify at least one row id in this list. </p>
    /// <p> Note that if one of the row ids provided in the request does not exist in the table, then the request fails and no rows are deleted from the table. </p>
    pub row_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> The request token for performing the delete action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the action again. </p>
    /// <p> Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. </p>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl BatchDeleteTableRowsInput {
    /// <p>The ID of the workbook where the rows are being deleted.</p>
    /// <p> If a workbook with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub fn workbook_id(&self) -> std::option::Option<&str> {
        self.workbook_id.as_deref()
    }
    /// <p>The ID of the table where the rows are being deleted.</p>
    /// <p> If a table with the specified id could not be found, this API throws ResourceNotFoundException. </p>
    pub fn table_id(&self) -> std::option::Option<&str> {
        self.table_id.as_deref()
    }
    /// <p> The list of row ids to delete from the table. You need to specify at least one row id in this list. </p>
    /// <p> Note that if one of the row ids provided in the request does not exist in the table, then the request fails and no rows are deleted from the table. </p>
    pub fn row_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.row_ids.as_deref()
    }
    /// <p> The request token for performing the delete action. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the action again. </p>
    /// <p> Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. </p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
}
impl std::fmt::Debug for BatchDeleteTableRowsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteTableRowsInput");
        formatter.field("workbook_id", &self.workbook_id);
        formatter.field("table_id", &self.table_id);
        formatter.field("row_ids", &self.row_ids);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchCreateTableRowsInput {
    /// <p>The ID of the workbook where the new rows are being added.</p>
    /// <p> If a workbook with the specified ID could not be found, this API throws ResourceNotFoundException. </p>
    pub workbook_id: std::option::Option<std::string::String>,
    /// <p>The ID of the table where the new rows are being added.</p>
    /// <p> If a table with the specified ID could not be found, this API throws ResourceNotFoundException. </p>
    pub table_id: std::option::Option<std::string::String>,
    /// <p> The list of rows to create at the end of the table. Each item in this list needs to have a batch item id to uniquely identify the element in the request and the cells to create for that row. You need to specify at least one item in this list. </p>
    /// <p> Note that if one of the column ids in any of the rows in the request does not exist in the table, then the request fails and no updates are made to the table. </p>
    pub rows_to_create: std::option::Option<std::vec::Vec<crate::model::CreateRowData>>,
    /// <p> The request token for performing the batch create operation. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the operation again. </p>
    /// <p> Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. </p>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl BatchCreateTableRowsInput {
    /// <p>The ID of the workbook where the new rows are being added.</p>
    /// <p> If a workbook with the specified ID could not be found, this API throws ResourceNotFoundException. </p>
    pub fn workbook_id(&self) -> std::option::Option<&str> {
        self.workbook_id.as_deref()
    }
    /// <p>The ID of the table where the new rows are being added.</p>
    /// <p> If a table with the specified ID could not be found, this API throws ResourceNotFoundException. </p>
    pub fn table_id(&self) -> std::option::Option<&str> {
        self.table_id.as_deref()
    }
    /// <p> The list of rows to create at the end of the table. Each item in this list needs to have a batch item id to uniquely identify the element in the request and the cells to create for that row. You need to specify at least one item in this list. </p>
    /// <p> Note that if one of the column ids in any of the rows in the request does not exist in the table, then the request fails and no updates are made to the table. </p>
    pub fn rows_to_create(&self) -> std::option::Option<&[crate::model::CreateRowData]> {
        self.rows_to_create.as_deref()
    }
    /// <p> The request token for performing the batch create operation. Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error like a failed network connection, you can retry the call with the same request token. The service ensures that if the first call using that request token is successfully performed, the second call will not perform the operation again. </p>
    /// <p> Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests spanning hours or days. </p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
}
impl std::fmt::Debug for BatchCreateTableRowsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchCreateTableRowsInput");
        formatter.field("workbook_id", &self.workbook_id);
        formatter.field("table_id", &self.table_id);
        formatter.field("rows_to_create", &self.rows_to_create);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}
