// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartTableDataImportJobOutput {
    /// <p> The id that is assigned to this import job. Future requests to find out the status of this import job need to send this id in the appropriate parameter in the request. </p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p> The status of the import job immediately after submitting the request. </p>
    pub job_status: std::option::Option<crate::model::TableDataImportJobStatus>,
}
impl StartTableDataImportJobOutput {
    /// <p> The id that is assigned to this import job. Future requests to find out the status of this import job need to send this id in the appropriate parameter in the request. </p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p> The status of the import job immediately after submitting the request. </p>
    pub fn job_status(&self) -> std::option::Option<&crate::model::TableDataImportJobStatus> {
        self.job_status.as_ref()
    }
}
impl std::fmt::Debug for StartTableDataImportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartTableDataImportJobOutput");
        formatter.field("job_id", &self.job_id);
        formatter.field("job_status", &self.job_status);
        formatter.finish()
    }
}
/// See [`StartTableDataImportJobOutput`](crate::output::StartTableDataImportJobOutput)
pub mod start_table_data_import_job_output {
    /// A builder for [`StartTableDataImportJobOutput`](crate::output::StartTableDataImportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::TableDataImportJobStatus>,
    }
    impl Builder {
        /// <p> The id that is assigned to this import job. Future requests to find out the status of this import job need to send this id in the appropriate parameter in the request. </p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p> The id that is assigned to this import job. Future requests to find out the status of this import job need to send this id in the appropriate parameter in the request. </p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p> The status of the import job immediately after submitting the request. </p>
        pub fn job_status(mut self, input: crate::model::TableDataImportJobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p> The status of the import job immediately after submitting the request. </p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::TableDataImportJobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// Consumes the builder and constructs a [`StartTableDataImportJobOutput`](crate::output::StartTableDataImportJobOutput)
        pub fn build(self) -> crate::output::StartTableDataImportJobOutput {
            crate::output::StartTableDataImportJobOutput {
                job_id: self.job_id,
                job_status: self.job_status,
            }
        }
    }
}
impl StartTableDataImportJobOutput {
    /// Creates a new builder-style object to manufacture [`StartTableDataImportJobOutput`](crate::output::StartTableDataImportJobOutput)
    pub fn builder() -> crate::output::start_table_data_import_job_output::Builder {
        crate::output::start_table_data_import_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryTableRowsOutput {
    /// <p> The list of columns in the table whose row data is returned in the result. </p>
    pub column_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> The list of rows in the table that match the query filter. </p>
    pub rows: std::option::Option<std::vec::Vec<crate::model::TableRow>>,
    /// <p> Provides the pagination token to load the next page if there are more results matching the request. If a pagination token is not present in the response, it means that all data matching the request has been loaded. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> Indicates the cursor of the workbook at which the data returned by this request is read. Workbook cursor keeps increasing with every update and the increments are not sequential. </p>
    pub workbook_cursor: i64,
}
impl QueryTableRowsOutput {
    /// <p> The list of columns in the table whose row data is returned in the result. </p>
    pub fn column_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.column_ids.as_deref()
    }
    /// <p> The list of rows in the table that match the query filter. </p>
    pub fn rows(&self) -> std::option::Option<&[crate::model::TableRow]> {
        self.rows.as_deref()
    }
    /// <p> Provides the pagination token to load the next page if there are more results matching the request. If a pagination token is not present in the response, it means that all data matching the request has been loaded. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p> Indicates the cursor of the workbook at which the data returned by this request is read. Workbook cursor keeps increasing with every update and the increments are not sequential. </p>
    pub fn workbook_cursor(&self) -> i64 {
        self.workbook_cursor
    }
}
impl std::fmt::Debug for QueryTableRowsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryTableRowsOutput");
        formatter.field("column_ids", &self.column_ids);
        formatter.field("rows", &self.rows);
        formatter.field("next_token", &self.next_token);
        formatter.field("workbook_cursor", &self.workbook_cursor);
        formatter.finish()
    }
}
/// See [`QueryTableRowsOutput`](crate::output::QueryTableRowsOutput)
pub mod query_table_rows_output {
    /// A builder for [`QueryTableRowsOutput`](crate::output::QueryTableRowsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) column_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) rows: std::option::Option<std::vec::Vec<crate::model::TableRow>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) workbook_cursor: std::option::Option<i64>,
    }
    impl Builder {
        /// Appends an item to `column_ids`.
        ///
        /// To override the contents of this collection use [`set_column_ids`](Self::set_column_ids).
        ///
        /// <p> The list of columns in the table whose row data is returned in the result. </p>
        pub fn column_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.column_ids.unwrap_or_default();
            v.push(input.into());
            self.column_ids = Some(v);
            self
        }
        /// <p> The list of columns in the table whose row data is returned in the result. </p>
        pub fn set_column_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.column_ids = input;
            self
        }
        /// Appends an item to `rows`.
        ///
        /// To override the contents of this collection use [`set_rows`](Self::set_rows).
        ///
        /// <p> The list of rows in the table that match the query filter. </p>
        pub fn rows(mut self, input: crate::model::TableRow) -> Self {
            let mut v = self.rows.unwrap_or_default();
            v.push(input);
            self.rows = Some(v);
            self
        }
        /// <p> The list of rows in the table that match the query filter. </p>
        pub fn set_rows(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TableRow>>,
        ) -> Self {
            self.rows = input;
            self
        }
        /// <p> Provides the pagination token to load the next page if there are more results matching the request. If a pagination token is not present in the response, it means that all data matching the request has been loaded. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> Provides the pagination token to load the next page if there are more results matching the request. If a pagination token is not present in the response, it means that all data matching the request has been loaded. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> Indicates the cursor of the workbook at which the data returned by this request is read. Workbook cursor keeps increasing with every update and the increments are not sequential. </p>
        pub fn workbook_cursor(mut self, input: i64) -> Self {
            self.workbook_cursor = Some(input);
            self
        }
        /// <p> Indicates the cursor of the workbook at which the data returned by this request is read. Workbook cursor keeps increasing with every update and the increments are not sequential. </p>
        pub fn set_workbook_cursor(mut self, input: std::option::Option<i64>) -> Self {
            self.workbook_cursor = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryTableRowsOutput`](crate::output::QueryTableRowsOutput)
        pub fn build(self) -> crate::output::QueryTableRowsOutput {
            crate::output::QueryTableRowsOutput {
                column_ids: self.column_ids,
                rows: self.rows,
                next_token: self.next_token,
                workbook_cursor: self.workbook_cursor.unwrap_or_default(),
            }
        }
    }
}
impl QueryTableRowsOutput {
    /// Creates a new builder-style object to manufacture [`QueryTableRowsOutput`](crate::output::QueryTableRowsOutput)
    pub fn builder() -> crate::output::query_table_rows_output::Builder {
        crate::output::query_table_rows_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTablesOutput {
    /// <p> The list of tables in the workbook. </p>
    pub tables: std::option::Option<std::vec::Vec<crate::model::Table>>,
    /// <p> Provides the pagination token to load the next page if there are more results matching the request. If a pagination token is not present in the response, it means that all data matching the request has been loaded. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> Indicates the cursor of the workbook at which the data returned by this request is read. Workbook cursor keeps increasing with every update and the increments are not sequential. </p>
    pub workbook_cursor: i64,
}
impl ListTablesOutput {
    /// <p> The list of tables in the workbook. </p>
    pub fn tables(&self) -> std::option::Option<&[crate::model::Table]> {
        self.tables.as_deref()
    }
    /// <p> Provides the pagination token to load the next page if there are more results matching the request. If a pagination token is not present in the response, it means that all data matching the request has been loaded. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p> Indicates the cursor of the workbook at which the data returned by this request is read. Workbook cursor keeps increasing with every update and the increments are not sequential. </p>
    pub fn workbook_cursor(&self) -> i64 {
        self.workbook_cursor
    }
}
impl std::fmt::Debug for ListTablesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTablesOutput");
        formatter.field("tables", &self.tables);
        formatter.field("next_token", &self.next_token);
        formatter.field("workbook_cursor", &self.workbook_cursor);
        formatter.finish()
    }
}
/// See [`ListTablesOutput`](crate::output::ListTablesOutput)
pub mod list_tables_output {
    /// A builder for [`ListTablesOutput`](crate::output::ListTablesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tables: std::option::Option<std::vec::Vec<crate::model::Table>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) workbook_cursor: std::option::Option<i64>,
    }
    impl Builder {
        /// Appends an item to `tables`.
        ///
        /// To override the contents of this collection use [`set_tables`](Self::set_tables).
        ///
        /// <p> The list of tables in the workbook. </p>
        pub fn tables(mut self, input: crate::model::Table) -> Self {
            let mut v = self.tables.unwrap_or_default();
            v.push(input);
            self.tables = Some(v);
            self
        }
        /// <p> The list of tables in the workbook. </p>
        pub fn set_tables(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Table>>,
        ) -> Self {
            self.tables = input;
            self
        }
        /// <p> Provides the pagination token to load the next page if there are more results matching the request. If a pagination token is not present in the response, it means that all data matching the request has been loaded. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> Provides the pagination token to load the next page if there are more results matching the request. If a pagination token is not present in the response, it means that all data matching the request has been loaded. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> Indicates the cursor of the workbook at which the data returned by this request is read. Workbook cursor keeps increasing with every update and the increments are not sequential. </p>
        pub fn workbook_cursor(mut self, input: i64) -> Self {
            self.workbook_cursor = Some(input);
            self
        }
        /// <p> Indicates the cursor of the workbook at which the data returned by this request is read. Workbook cursor keeps increasing with every update and the increments are not sequential. </p>
        pub fn set_workbook_cursor(mut self, input: std::option::Option<i64>) -> Self {
            self.workbook_cursor = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTablesOutput`](crate::output::ListTablesOutput)
        pub fn build(self) -> crate::output::ListTablesOutput {
            crate::output::ListTablesOutput {
                tables: self.tables,
                next_token: self.next_token,
                workbook_cursor: self.workbook_cursor.unwrap_or_default(),
            }
        }
    }
}
impl ListTablesOutput {
    /// Creates a new builder-style object to manufacture [`ListTablesOutput`](crate::output::ListTablesOutput)
    pub fn builder() -> crate::output::list_tables_output::Builder {
        crate::output::list_tables_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTableRowsOutput {
    /// <p> The list of columns in the table whose row data is returned in the result. </p>
    pub column_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> The list of rows in the table. Note that this result is paginated, so this list contains a maximum of 100 rows. </p>
    pub rows: std::option::Option<std::vec::Vec<crate::model::TableRow>>,
    /// <p> The list of row ids included in the request that were not found in the table. </p>
    pub row_ids_not_found: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> Provides the pagination token to load the next page if there are more results matching the request. If a pagination token is not present in the response, it means that all data matching the request has been loaded. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> Indicates the cursor of the workbook at which the data returned by this request is read. Workbook cursor keeps increasing with every update and the increments are not sequential. </p>
    pub workbook_cursor: i64,
}
impl ListTableRowsOutput {
    /// <p> The list of columns in the table whose row data is returned in the result. </p>
    pub fn column_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.column_ids.as_deref()
    }
    /// <p> The list of rows in the table. Note that this result is paginated, so this list contains a maximum of 100 rows. </p>
    pub fn rows(&self) -> std::option::Option<&[crate::model::TableRow]> {
        self.rows.as_deref()
    }
    /// <p> The list of row ids included in the request that were not found in the table. </p>
    pub fn row_ids_not_found(&self) -> std::option::Option<&[std::string::String]> {
        self.row_ids_not_found.as_deref()
    }
    /// <p> Provides the pagination token to load the next page if there are more results matching the request. If a pagination token is not present in the response, it means that all data matching the request has been loaded. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p> Indicates the cursor of the workbook at which the data returned by this request is read. Workbook cursor keeps increasing with every update and the increments are not sequential. </p>
    pub fn workbook_cursor(&self) -> i64 {
        self.workbook_cursor
    }
}
impl std::fmt::Debug for ListTableRowsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTableRowsOutput");
        formatter.field("column_ids", &self.column_ids);
        formatter.field("rows", &self.rows);
        formatter.field("row_ids_not_found", &self.row_ids_not_found);
        formatter.field("next_token", &self.next_token);
        formatter.field("workbook_cursor", &self.workbook_cursor);
        formatter.finish()
    }
}
/// See [`ListTableRowsOutput`](crate::output::ListTableRowsOutput)
pub mod list_table_rows_output {
    /// A builder for [`ListTableRowsOutput`](crate::output::ListTableRowsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) column_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) rows: std::option::Option<std::vec::Vec<crate::model::TableRow>>,
        pub(crate) row_ids_not_found: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) workbook_cursor: std::option::Option<i64>,
    }
    impl Builder {
        /// Appends an item to `column_ids`.
        ///
        /// To override the contents of this collection use [`set_column_ids`](Self::set_column_ids).
        ///
        /// <p> The list of columns in the table whose row data is returned in the result. </p>
        pub fn column_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.column_ids.unwrap_or_default();
            v.push(input.into());
            self.column_ids = Some(v);
            self
        }
        /// <p> The list of columns in the table whose row data is returned in the result. </p>
        pub fn set_column_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.column_ids = input;
            self
        }
        /// Appends an item to `rows`.
        ///
        /// To override the contents of this collection use [`set_rows`](Self::set_rows).
        ///
        /// <p> The list of rows in the table. Note that this result is paginated, so this list contains a maximum of 100 rows. </p>
        pub fn rows(mut self, input: crate::model::TableRow) -> Self {
            let mut v = self.rows.unwrap_or_default();
            v.push(input);
            self.rows = Some(v);
            self
        }
        /// <p> The list of rows in the table. Note that this result is paginated, so this list contains a maximum of 100 rows. </p>
        pub fn set_rows(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TableRow>>,
        ) -> Self {
            self.rows = input;
            self
        }
        /// Appends an item to `row_ids_not_found`.
        ///
        /// To override the contents of this collection use [`set_row_ids_not_found`](Self::set_row_ids_not_found).
        ///
        /// <p> The list of row ids included in the request that were not found in the table. </p>
        pub fn row_ids_not_found(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.row_ids_not_found.unwrap_or_default();
            v.push(input.into());
            self.row_ids_not_found = Some(v);
            self
        }
        /// <p> The list of row ids included in the request that were not found in the table. </p>
        pub fn set_row_ids_not_found(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.row_ids_not_found = input;
            self
        }
        /// <p> Provides the pagination token to load the next page if there are more results matching the request. If a pagination token is not present in the response, it means that all data matching the request has been loaded. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> Provides the pagination token to load the next page if there are more results matching the request. If a pagination token is not present in the response, it means that all data matching the request has been loaded. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> Indicates the cursor of the workbook at which the data returned by this request is read. Workbook cursor keeps increasing with every update and the increments are not sequential. </p>
        pub fn workbook_cursor(mut self, input: i64) -> Self {
            self.workbook_cursor = Some(input);
            self
        }
        /// <p> Indicates the cursor of the workbook at which the data returned by this request is read. Workbook cursor keeps increasing with every update and the increments are not sequential. </p>
        pub fn set_workbook_cursor(mut self, input: std::option::Option<i64>) -> Self {
            self.workbook_cursor = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTableRowsOutput`](crate::output::ListTableRowsOutput)
        pub fn build(self) -> crate::output::ListTableRowsOutput {
            crate::output::ListTableRowsOutput {
                column_ids: self.column_ids,
                rows: self.rows,
                row_ids_not_found: self.row_ids_not_found,
                next_token: self.next_token,
                workbook_cursor: self.workbook_cursor.unwrap_or_default(),
            }
        }
    }
}
impl ListTableRowsOutput {
    /// Creates a new builder-style object to manufacture [`ListTableRowsOutput`](crate::output::ListTableRowsOutput)
    pub fn builder() -> crate::output::list_table_rows_output::Builder {
        crate::output::list_table_rows_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTableColumnsOutput {
    /// <p> The list of columns in the table. </p>
    pub table_columns: std::option::Option<std::vec::Vec<crate::model::TableColumn>>,
    /// <p> Provides the pagination token to load the next page if there are more results matching the request. If a pagination token is not present in the response, it means that all data matching the request has been loaded. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> Indicates the cursor of the workbook at which the data returned by this request is read. Workbook cursor keeps increasing with every update and the increments are not sequential. </p>
    pub workbook_cursor: i64,
}
impl ListTableColumnsOutput {
    /// <p> The list of columns in the table. </p>
    pub fn table_columns(&self) -> std::option::Option<&[crate::model::TableColumn]> {
        self.table_columns.as_deref()
    }
    /// <p> Provides the pagination token to load the next page if there are more results matching the request. If a pagination token is not present in the response, it means that all data matching the request has been loaded. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p> Indicates the cursor of the workbook at which the data returned by this request is read. Workbook cursor keeps increasing with every update and the increments are not sequential. </p>
    pub fn workbook_cursor(&self) -> i64 {
        self.workbook_cursor
    }
}
impl std::fmt::Debug for ListTableColumnsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTableColumnsOutput");
        formatter.field("table_columns", &self.table_columns);
        formatter.field("next_token", &self.next_token);
        formatter.field("workbook_cursor", &self.workbook_cursor);
        formatter.finish()
    }
}
/// See [`ListTableColumnsOutput`](crate::output::ListTableColumnsOutput)
pub mod list_table_columns_output {
    /// A builder for [`ListTableColumnsOutput`](crate::output::ListTableColumnsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_columns: std::option::Option<std::vec::Vec<crate::model::TableColumn>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) workbook_cursor: std::option::Option<i64>,
    }
    impl Builder {
        /// Appends an item to `table_columns`.
        ///
        /// To override the contents of this collection use [`set_table_columns`](Self::set_table_columns).
        ///
        /// <p> The list of columns in the table. </p>
        pub fn table_columns(mut self, input: crate::model::TableColumn) -> Self {
            let mut v = self.table_columns.unwrap_or_default();
            v.push(input);
            self.table_columns = Some(v);
            self
        }
        /// <p> The list of columns in the table. </p>
        pub fn set_table_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TableColumn>>,
        ) -> Self {
            self.table_columns = input;
            self
        }
        /// <p> Provides the pagination token to load the next page if there are more results matching the request. If a pagination token is not present in the response, it means that all data matching the request has been loaded. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> Provides the pagination token to load the next page if there are more results matching the request. If a pagination token is not present in the response, it means that all data matching the request has been loaded. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> Indicates the cursor of the workbook at which the data returned by this request is read. Workbook cursor keeps increasing with every update and the increments are not sequential. </p>
        pub fn workbook_cursor(mut self, input: i64) -> Self {
            self.workbook_cursor = Some(input);
            self
        }
        /// <p> Indicates the cursor of the workbook at which the data returned by this request is read. Workbook cursor keeps increasing with every update and the increments are not sequential. </p>
        pub fn set_workbook_cursor(mut self, input: std::option::Option<i64>) -> Self {
            self.workbook_cursor = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTableColumnsOutput`](crate::output::ListTableColumnsOutput)
        pub fn build(self) -> crate::output::ListTableColumnsOutput {
            crate::output::ListTableColumnsOutput {
                table_columns: self.table_columns,
                next_token: self.next_token,
                workbook_cursor: self.workbook_cursor.unwrap_or_default(),
            }
        }
    }
}
impl ListTableColumnsOutput {
    /// Creates a new builder-style object to manufacture [`ListTableColumnsOutput`](crate::output::ListTableColumnsOutput)
    pub fn builder() -> crate::output::list_table_columns_output::Builder {
        crate::output::list_table_columns_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvokeScreenAutomationOutput {
    /// <p>The updated workbook cursor after performing the automation action.</p>
    pub workbook_cursor: i64,
}
impl InvokeScreenAutomationOutput {
    /// <p>The updated workbook cursor after performing the automation action.</p>
    pub fn workbook_cursor(&self) -> i64 {
        self.workbook_cursor
    }
}
impl std::fmt::Debug for InvokeScreenAutomationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvokeScreenAutomationOutput");
        formatter.field("workbook_cursor", &self.workbook_cursor);
        formatter.finish()
    }
}
/// See [`InvokeScreenAutomationOutput`](crate::output::InvokeScreenAutomationOutput)
pub mod invoke_screen_automation_output {
    /// A builder for [`InvokeScreenAutomationOutput`](crate::output::InvokeScreenAutomationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workbook_cursor: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The updated workbook cursor after performing the automation action.</p>
        pub fn workbook_cursor(mut self, input: i64) -> Self {
            self.workbook_cursor = Some(input);
            self
        }
        /// <p>The updated workbook cursor after performing the automation action.</p>
        pub fn set_workbook_cursor(mut self, input: std::option::Option<i64>) -> Self {
            self.workbook_cursor = input;
            self
        }
        /// Consumes the builder and constructs a [`InvokeScreenAutomationOutput`](crate::output::InvokeScreenAutomationOutput)
        pub fn build(self) -> crate::output::InvokeScreenAutomationOutput {
            crate::output::InvokeScreenAutomationOutput {
                workbook_cursor: self.workbook_cursor.unwrap_or_default(),
            }
        }
    }
}
impl InvokeScreenAutomationOutput {
    /// Creates a new builder-style object to manufacture [`InvokeScreenAutomationOutput`](crate::output::InvokeScreenAutomationOutput)
    pub fn builder() -> crate::output::invoke_screen_automation_output::Builder {
        crate::output::invoke_screen_automation_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetScreenDataOutput {
    /// <p>A map of all the rows on the screen keyed by block name.</p>
    pub results: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ResultSet>,
    >,
    /// <p> Indicates the cursor of the workbook at which the data returned by this workbook is read. Workbook cursor keeps increasing with every update and the increments are not sequential. </p>
    pub workbook_cursor: i64,
    /// <p> Provides the pagination token to load the next page if there are more results matching the request. If a pagination token is not present in the response, it means that all data matching the query has been loaded. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetScreenDataOutput {
    /// <p>A map of all the rows on the screen keyed by block name.</p>
    pub fn results(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, crate::model::ResultSet>>
    {
        self.results.as_ref()
    }
    /// <p> Indicates the cursor of the workbook at which the data returned by this workbook is read. Workbook cursor keeps increasing with every update and the increments are not sequential. </p>
    pub fn workbook_cursor(&self) -> i64 {
        self.workbook_cursor
    }
    /// <p> Provides the pagination token to load the next page if there are more results matching the request. If a pagination token is not present in the response, it means that all data matching the query has been loaded. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetScreenDataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetScreenDataOutput");
        formatter.field("results", &self.results);
        formatter.field("workbook_cursor", &self.workbook_cursor);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetScreenDataOutput`](crate::output::GetScreenDataOutput)
pub mod get_screen_data_output {
    /// A builder for [`GetScreenDataOutput`](crate::output::GetScreenDataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) results: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ResultSet>,
        >,
        pub(crate) workbook_cursor: std::option::Option<i64>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Adds a key-value pair to `results`.
        ///
        /// To override the contents of this collection use [`set_results`](Self::set_results).
        ///
        /// <p>A map of all the rows on the screen keyed by block name.</p>
        pub fn results(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ResultSet,
        ) -> Self {
            let mut hash_map = self.results.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.results = Some(hash_map);
            self
        }
        /// <p>A map of all the rows on the screen keyed by block name.</p>
        pub fn set_results(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ResultSet>,
            >,
        ) -> Self {
            self.results = input;
            self
        }
        /// <p> Indicates the cursor of the workbook at which the data returned by this workbook is read. Workbook cursor keeps increasing with every update and the increments are not sequential. </p>
        pub fn workbook_cursor(mut self, input: i64) -> Self {
            self.workbook_cursor = Some(input);
            self
        }
        /// <p> Indicates the cursor of the workbook at which the data returned by this workbook is read. Workbook cursor keeps increasing with every update and the increments are not sequential. </p>
        pub fn set_workbook_cursor(mut self, input: std::option::Option<i64>) -> Self {
            self.workbook_cursor = input;
            self
        }
        /// <p> Provides the pagination token to load the next page if there are more results matching the request. If a pagination token is not present in the response, it means that all data matching the query has been loaded. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> Provides the pagination token to load the next page if there are more results matching the request. If a pagination token is not present in the response, it means that all data matching the query has been loaded. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetScreenDataOutput`](crate::output::GetScreenDataOutput)
        pub fn build(self) -> crate::output::GetScreenDataOutput {
            crate::output::GetScreenDataOutput {
                results: self.results,
                workbook_cursor: self.workbook_cursor.unwrap_or_default(),
                next_token: self.next_token,
            }
        }
    }
}
impl GetScreenDataOutput {
    /// Creates a new builder-style object to manufacture [`GetScreenDataOutput`](crate::output::GetScreenDataOutput)
    pub fn builder() -> crate::output::get_screen_data_output::Builder {
        crate::output::get_screen_data_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTableDataImportJobOutput {
    /// <p> The current status of the import job. </p>
    pub job_status: std::option::Option<crate::model::TableDataImportJobStatus>,
    /// <p> A message providing more details about the current status of the import job. </p>
    pub message: std::option::Option<std::string::String>,
    /// <p> The metadata about the job that was submitted for import. </p>
    pub job_metadata: std::option::Option<crate::model::TableDataImportJobMetadata>,
}
impl DescribeTableDataImportJobOutput {
    /// <p> The current status of the import job. </p>
    pub fn job_status(&self) -> std::option::Option<&crate::model::TableDataImportJobStatus> {
        self.job_status.as_ref()
    }
    /// <p> A message providing more details about the current status of the import job. </p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p> The metadata about the job that was submitted for import. </p>
    pub fn job_metadata(&self) -> std::option::Option<&crate::model::TableDataImportJobMetadata> {
        self.job_metadata.as_ref()
    }
}
impl std::fmt::Debug for DescribeTableDataImportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTableDataImportJobOutput");
        formatter.field("job_status", &self.job_status);
        formatter.field("message", &self.message);
        formatter.field("job_metadata", &self.job_metadata);
        formatter.finish()
    }
}
/// See [`DescribeTableDataImportJobOutput`](crate::output::DescribeTableDataImportJobOutput)
pub mod describe_table_data_import_job_output {
    /// A builder for [`DescribeTableDataImportJobOutput`](crate::output::DescribeTableDataImportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_status: std::option::Option<crate::model::TableDataImportJobStatus>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) job_metadata: std::option::Option<crate::model::TableDataImportJobMetadata>,
    }
    impl Builder {
        /// <p> The current status of the import job. </p>
        pub fn job_status(mut self, input: crate::model::TableDataImportJobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p> The current status of the import job. </p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::TableDataImportJobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p> A message providing more details about the current status of the import job. </p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p> A message providing more details about the current status of the import job. </p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p> The metadata about the job that was submitted for import. </p>
        pub fn job_metadata(mut self, input: crate::model::TableDataImportJobMetadata) -> Self {
            self.job_metadata = Some(input);
            self
        }
        /// <p> The metadata about the job that was submitted for import. </p>
        pub fn set_job_metadata(
            mut self,
            input: std::option::Option<crate::model::TableDataImportJobMetadata>,
        ) -> Self {
            self.job_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTableDataImportJobOutput`](crate::output::DescribeTableDataImportJobOutput)
        pub fn build(self) -> crate::output::DescribeTableDataImportJobOutput {
            crate::output::DescribeTableDataImportJobOutput {
                job_status: self.job_status,
                message: self.message,
                job_metadata: self.job_metadata,
            }
        }
    }
}
impl DescribeTableDataImportJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTableDataImportJobOutput`](crate::output::DescribeTableDataImportJobOutput)
    pub fn builder() -> crate::output::describe_table_data_import_job_output::Builder {
        crate::output::describe_table_data_import_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchUpsertTableRowsOutput {
    /// <p> A map with the batch item id as the key and the result of the upsert operation as the value. The result of the upsert operation specifies whether existing rows were updated or a new row was appended, along with the list of row ids that were affected. </p>
    pub rows: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::UpsertRowsResult>,
    >,
    /// <p>The updated workbook cursor after updating or appending rows in the table.</p>
    pub workbook_cursor: i64,
    /// <p> The list of batch items in the request that could not be updated or appended in the table. Each element in this list contains one item from the request that could not be updated in the table along with the reason why that item could not be updated or appended. </p>
    pub failed_batch_items: std::option::Option<std::vec::Vec<crate::model::FailedBatchItem>>,
}
impl BatchUpsertTableRowsOutput {
    /// <p> A map with the batch item id as the key and the result of the upsert operation as the value. The result of the upsert operation specifies whether existing rows were updated or a new row was appended, along with the list of row ids that were affected. </p>
    pub fn rows(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::UpsertRowsResult>,
    > {
        self.rows.as_ref()
    }
    /// <p>The updated workbook cursor after updating or appending rows in the table.</p>
    pub fn workbook_cursor(&self) -> i64 {
        self.workbook_cursor
    }
    /// <p> The list of batch items in the request that could not be updated or appended in the table. Each element in this list contains one item from the request that could not be updated in the table along with the reason why that item could not be updated or appended. </p>
    pub fn failed_batch_items(&self) -> std::option::Option<&[crate::model::FailedBatchItem]> {
        self.failed_batch_items.as_deref()
    }
}
impl std::fmt::Debug for BatchUpsertTableRowsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchUpsertTableRowsOutput");
        formatter.field("rows", &self.rows);
        formatter.field("workbook_cursor", &self.workbook_cursor);
        formatter.field("failed_batch_items", &self.failed_batch_items);
        formatter.finish()
    }
}
/// See [`BatchUpsertTableRowsOutput`](crate::output::BatchUpsertTableRowsOutput)
pub mod batch_upsert_table_rows_output {
    /// A builder for [`BatchUpsertTableRowsOutput`](crate::output::BatchUpsertTableRowsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rows: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::UpsertRowsResult>,
        >,
        pub(crate) workbook_cursor: std::option::Option<i64>,
        pub(crate) failed_batch_items:
            std::option::Option<std::vec::Vec<crate::model::FailedBatchItem>>,
    }
    impl Builder {
        /// Adds a key-value pair to `rows`.
        ///
        /// To override the contents of this collection use [`set_rows`](Self::set_rows).
        ///
        /// <p> A map with the batch item id as the key and the result of the upsert operation as the value. The result of the upsert operation specifies whether existing rows were updated or a new row was appended, along with the list of row ids that were affected. </p>
        pub fn rows(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::UpsertRowsResult,
        ) -> Self {
            let mut hash_map = self.rows.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.rows = Some(hash_map);
            self
        }
        /// <p> A map with the batch item id as the key and the result of the upsert operation as the value. The result of the upsert operation specifies whether existing rows were updated or a new row was appended, along with the list of row ids that were affected. </p>
        pub fn set_rows(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::UpsertRowsResult>,
            >,
        ) -> Self {
            self.rows = input;
            self
        }
        /// <p>The updated workbook cursor after updating or appending rows in the table.</p>
        pub fn workbook_cursor(mut self, input: i64) -> Self {
            self.workbook_cursor = Some(input);
            self
        }
        /// <p>The updated workbook cursor after updating or appending rows in the table.</p>
        pub fn set_workbook_cursor(mut self, input: std::option::Option<i64>) -> Self {
            self.workbook_cursor = input;
            self
        }
        /// Appends an item to `failed_batch_items`.
        ///
        /// To override the contents of this collection use [`set_failed_batch_items`](Self::set_failed_batch_items).
        ///
        /// <p> The list of batch items in the request that could not be updated or appended in the table. Each element in this list contains one item from the request that could not be updated in the table along with the reason why that item could not be updated or appended. </p>
        pub fn failed_batch_items(mut self, input: crate::model::FailedBatchItem) -> Self {
            let mut v = self.failed_batch_items.unwrap_or_default();
            v.push(input);
            self.failed_batch_items = Some(v);
            self
        }
        /// <p> The list of batch items in the request that could not be updated or appended in the table. Each element in this list contains one item from the request that could not be updated in the table along with the reason why that item could not be updated or appended. </p>
        pub fn set_failed_batch_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FailedBatchItem>>,
        ) -> Self {
            self.failed_batch_items = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchUpsertTableRowsOutput`](crate::output::BatchUpsertTableRowsOutput)
        pub fn build(self) -> crate::output::BatchUpsertTableRowsOutput {
            crate::output::BatchUpsertTableRowsOutput {
                rows: self.rows,
                workbook_cursor: self.workbook_cursor.unwrap_or_default(),
                failed_batch_items: self.failed_batch_items,
            }
        }
    }
}
impl BatchUpsertTableRowsOutput {
    /// Creates a new builder-style object to manufacture [`BatchUpsertTableRowsOutput`](crate::output::BatchUpsertTableRowsOutput)
    pub fn builder() -> crate::output::batch_upsert_table_rows_output::Builder {
        crate::output::batch_upsert_table_rows_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchUpdateTableRowsOutput {
    /// <p>The updated workbook cursor after adding the new rows at the end of the table.</p>
    pub workbook_cursor: i64,
    /// <p> The list of batch items in the request that could not be updated in the table. Each element in this list contains one item from the request that could not be updated in the table along with the reason why that item could not be updated. </p>
    pub failed_batch_items: std::option::Option<std::vec::Vec<crate::model::FailedBatchItem>>,
}
impl BatchUpdateTableRowsOutput {
    /// <p>The updated workbook cursor after adding the new rows at the end of the table.</p>
    pub fn workbook_cursor(&self) -> i64 {
        self.workbook_cursor
    }
    /// <p> The list of batch items in the request that could not be updated in the table. Each element in this list contains one item from the request that could not be updated in the table along with the reason why that item could not be updated. </p>
    pub fn failed_batch_items(&self) -> std::option::Option<&[crate::model::FailedBatchItem]> {
        self.failed_batch_items.as_deref()
    }
}
impl std::fmt::Debug for BatchUpdateTableRowsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchUpdateTableRowsOutput");
        formatter.field("workbook_cursor", &self.workbook_cursor);
        formatter.field("failed_batch_items", &self.failed_batch_items);
        formatter.finish()
    }
}
/// See [`BatchUpdateTableRowsOutput`](crate::output::BatchUpdateTableRowsOutput)
pub mod batch_update_table_rows_output {
    /// A builder for [`BatchUpdateTableRowsOutput`](crate::output::BatchUpdateTableRowsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workbook_cursor: std::option::Option<i64>,
        pub(crate) failed_batch_items:
            std::option::Option<std::vec::Vec<crate::model::FailedBatchItem>>,
    }
    impl Builder {
        /// <p>The updated workbook cursor after adding the new rows at the end of the table.</p>
        pub fn workbook_cursor(mut self, input: i64) -> Self {
            self.workbook_cursor = Some(input);
            self
        }
        /// <p>The updated workbook cursor after adding the new rows at the end of the table.</p>
        pub fn set_workbook_cursor(mut self, input: std::option::Option<i64>) -> Self {
            self.workbook_cursor = input;
            self
        }
        /// Appends an item to `failed_batch_items`.
        ///
        /// To override the contents of this collection use [`set_failed_batch_items`](Self::set_failed_batch_items).
        ///
        /// <p> The list of batch items in the request that could not be updated in the table. Each element in this list contains one item from the request that could not be updated in the table along with the reason why that item could not be updated. </p>
        pub fn failed_batch_items(mut self, input: crate::model::FailedBatchItem) -> Self {
            let mut v = self.failed_batch_items.unwrap_or_default();
            v.push(input);
            self.failed_batch_items = Some(v);
            self
        }
        /// <p> The list of batch items in the request that could not be updated in the table. Each element in this list contains one item from the request that could not be updated in the table along with the reason why that item could not be updated. </p>
        pub fn set_failed_batch_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FailedBatchItem>>,
        ) -> Self {
            self.failed_batch_items = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchUpdateTableRowsOutput`](crate::output::BatchUpdateTableRowsOutput)
        pub fn build(self) -> crate::output::BatchUpdateTableRowsOutput {
            crate::output::BatchUpdateTableRowsOutput {
                workbook_cursor: self.workbook_cursor.unwrap_or_default(),
                failed_batch_items: self.failed_batch_items,
            }
        }
    }
}
impl BatchUpdateTableRowsOutput {
    /// Creates a new builder-style object to manufacture [`BatchUpdateTableRowsOutput`](crate::output::BatchUpdateTableRowsOutput)
    pub fn builder() -> crate::output::batch_update_table_rows_output::Builder {
        crate::output::batch_update_table_rows_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteTableRowsOutput {
    /// <p>The updated workbook cursor after deleting the rows from the table.</p>
    pub workbook_cursor: i64,
    /// <p> The list of row ids in the request that could not be deleted from the table. Each element in this list contains one row id from the request that could not be deleted along with the reason why that item could not be deleted. </p>
    pub failed_batch_items: std::option::Option<std::vec::Vec<crate::model::FailedBatchItem>>,
}
impl BatchDeleteTableRowsOutput {
    /// <p>The updated workbook cursor after deleting the rows from the table.</p>
    pub fn workbook_cursor(&self) -> i64 {
        self.workbook_cursor
    }
    /// <p> The list of row ids in the request that could not be deleted from the table. Each element in this list contains one row id from the request that could not be deleted along with the reason why that item could not be deleted. </p>
    pub fn failed_batch_items(&self) -> std::option::Option<&[crate::model::FailedBatchItem]> {
        self.failed_batch_items.as_deref()
    }
}
impl std::fmt::Debug for BatchDeleteTableRowsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteTableRowsOutput");
        formatter.field("workbook_cursor", &self.workbook_cursor);
        formatter.field("failed_batch_items", &self.failed_batch_items);
        formatter.finish()
    }
}
/// See [`BatchDeleteTableRowsOutput`](crate::output::BatchDeleteTableRowsOutput)
pub mod batch_delete_table_rows_output {
    /// A builder for [`BatchDeleteTableRowsOutput`](crate::output::BatchDeleteTableRowsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workbook_cursor: std::option::Option<i64>,
        pub(crate) failed_batch_items:
            std::option::Option<std::vec::Vec<crate::model::FailedBatchItem>>,
    }
    impl Builder {
        /// <p>The updated workbook cursor after deleting the rows from the table.</p>
        pub fn workbook_cursor(mut self, input: i64) -> Self {
            self.workbook_cursor = Some(input);
            self
        }
        /// <p>The updated workbook cursor after deleting the rows from the table.</p>
        pub fn set_workbook_cursor(mut self, input: std::option::Option<i64>) -> Self {
            self.workbook_cursor = input;
            self
        }
        /// Appends an item to `failed_batch_items`.
        ///
        /// To override the contents of this collection use [`set_failed_batch_items`](Self::set_failed_batch_items).
        ///
        /// <p> The list of row ids in the request that could not be deleted from the table. Each element in this list contains one row id from the request that could not be deleted along with the reason why that item could not be deleted. </p>
        pub fn failed_batch_items(mut self, input: crate::model::FailedBatchItem) -> Self {
            let mut v = self.failed_batch_items.unwrap_or_default();
            v.push(input);
            self.failed_batch_items = Some(v);
            self
        }
        /// <p> The list of row ids in the request that could not be deleted from the table. Each element in this list contains one row id from the request that could not be deleted along with the reason why that item could not be deleted. </p>
        pub fn set_failed_batch_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FailedBatchItem>>,
        ) -> Self {
            self.failed_batch_items = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteTableRowsOutput`](crate::output::BatchDeleteTableRowsOutput)
        pub fn build(self) -> crate::output::BatchDeleteTableRowsOutput {
            crate::output::BatchDeleteTableRowsOutput {
                workbook_cursor: self.workbook_cursor.unwrap_or_default(),
                failed_batch_items: self.failed_batch_items,
            }
        }
    }
}
impl BatchDeleteTableRowsOutput {
    /// Creates a new builder-style object to manufacture [`BatchDeleteTableRowsOutput`](crate::output::BatchDeleteTableRowsOutput)
    pub fn builder() -> crate::output::batch_delete_table_rows_output::Builder {
        crate::output::batch_delete_table_rows_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchCreateTableRowsOutput {
    /// <p>The updated workbook cursor after adding the new rows at the end of the table.</p>
    pub workbook_cursor: i64,
    /// <p>The map of batch item id to the row id that was created for that item.</p>
    pub created_rows:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p> The list of batch items in the request that could not be added to the table. Each element in this list contains one item from the request that could not be added to the table along with the reason why that item could not be added. </p>
    pub failed_batch_items: std::option::Option<std::vec::Vec<crate::model::FailedBatchItem>>,
}
impl BatchCreateTableRowsOutput {
    /// <p>The updated workbook cursor after adding the new rows at the end of the table.</p>
    pub fn workbook_cursor(&self) -> i64 {
        self.workbook_cursor
    }
    /// <p>The map of batch item id to the row id that was created for that item.</p>
    pub fn created_rows(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.created_rows.as_ref()
    }
    /// <p> The list of batch items in the request that could not be added to the table. Each element in this list contains one item from the request that could not be added to the table along with the reason why that item could not be added. </p>
    pub fn failed_batch_items(&self) -> std::option::Option<&[crate::model::FailedBatchItem]> {
        self.failed_batch_items.as_deref()
    }
}
impl std::fmt::Debug for BatchCreateTableRowsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchCreateTableRowsOutput");
        formatter.field("workbook_cursor", &self.workbook_cursor);
        formatter.field("created_rows", &self.created_rows);
        formatter.field("failed_batch_items", &self.failed_batch_items);
        formatter.finish()
    }
}
/// See [`BatchCreateTableRowsOutput`](crate::output::BatchCreateTableRowsOutput)
pub mod batch_create_table_rows_output {
    /// A builder for [`BatchCreateTableRowsOutput`](crate::output::BatchCreateTableRowsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) workbook_cursor: std::option::Option<i64>,
        pub(crate) created_rows: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) failed_batch_items:
            std::option::Option<std::vec::Vec<crate::model::FailedBatchItem>>,
    }
    impl Builder {
        /// <p>The updated workbook cursor after adding the new rows at the end of the table.</p>
        pub fn workbook_cursor(mut self, input: i64) -> Self {
            self.workbook_cursor = Some(input);
            self
        }
        /// <p>The updated workbook cursor after adding the new rows at the end of the table.</p>
        pub fn set_workbook_cursor(mut self, input: std::option::Option<i64>) -> Self {
            self.workbook_cursor = input;
            self
        }
        /// Adds a key-value pair to `created_rows`.
        ///
        /// To override the contents of this collection use [`set_created_rows`](Self::set_created_rows).
        ///
        /// <p>The map of batch item id to the row id that was created for that item.</p>
        pub fn created_rows(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.created_rows.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.created_rows = Some(hash_map);
            self
        }
        /// <p>The map of batch item id to the row id that was created for that item.</p>
        pub fn set_created_rows(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.created_rows = input;
            self
        }
        /// Appends an item to `failed_batch_items`.
        ///
        /// To override the contents of this collection use [`set_failed_batch_items`](Self::set_failed_batch_items).
        ///
        /// <p> The list of batch items in the request that could not be added to the table. Each element in this list contains one item from the request that could not be added to the table along with the reason why that item could not be added. </p>
        pub fn failed_batch_items(mut self, input: crate::model::FailedBatchItem) -> Self {
            let mut v = self.failed_batch_items.unwrap_or_default();
            v.push(input);
            self.failed_batch_items = Some(v);
            self
        }
        /// <p> The list of batch items in the request that could not be added to the table. Each element in this list contains one item from the request that could not be added to the table along with the reason why that item could not be added. </p>
        pub fn set_failed_batch_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FailedBatchItem>>,
        ) -> Self {
            self.failed_batch_items = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchCreateTableRowsOutput`](crate::output::BatchCreateTableRowsOutput)
        pub fn build(self) -> crate::output::BatchCreateTableRowsOutput {
            crate::output::BatchCreateTableRowsOutput {
                workbook_cursor: self.workbook_cursor.unwrap_or_default(),
                created_rows: self.created_rows,
                failed_batch_items: self.failed_batch_items,
            }
        }
    }
}
impl BatchCreateTableRowsOutput {
    /// Creates a new builder-style object to manufacture [`BatchCreateTableRowsOutput`](crate::output::BatchCreateTableRowsOutput)
    pub fn builder() -> crate::output::batch_create_table_rows_output::Builder {
        crate::output::batch_create_table_rows_output::Builder::default()
    }
}
