// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TableDataImportJobStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Submitted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TableDataImportJobStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => TableDataImportJobStatus::Completed,
            "FAILED" => TableDataImportJobStatus::Failed,
            "IN_PROGRESS" => TableDataImportJobStatus::InProgress,
            "SUBMITTED" => TableDataImportJobStatus::Submitted,
            other => TableDataImportJobStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TableDataImportJobStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TableDataImportJobStatus::from(s))
    }
}
impl TableDataImportJobStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TableDataImportJobStatus::Completed => "COMPLETED",
            TableDataImportJobStatus::Failed => "FAILED",
            TableDataImportJobStatus::InProgress => "IN_PROGRESS",
            TableDataImportJobStatus::Submitted => "SUBMITTED",
            TableDataImportJobStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETED", "FAILED", "IN_PROGRESS", "SUBMITTED"]
    }
}
impl AsRef<str> for TableDataImportJobStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that contains the options specified by the sumitter of the import request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportOptions {
    /// <p>Options relating to the destination of the import request.</p>
    pub destination_options: std::option::Option<crate::model::DestinationOptions>,
    /// <p>Options relating to parsing delimited text. Required if dataFormat is DELIMITED_TEXT.</p>
    pub delimited_text_options: std::option::Option<crate::model::DelimitedTextImportOptions>,
}
impl ImportOptions {
    /// <p>Options relating to the destination of the import request.</p>
    pub fn destination_options(&self) -> std::option::Option<&crate::model::DestinationOptions> {
        self.destination_options.as_ref()
    }
    /// <p>Options relating to parsing delimited text. Required if dataFormat is DELIMITED_TEXT.</p>
    pub fn delimited_text_options(
        &self,
    ) -> std::option::Option<&crate::model::DelimitedTextImportOptions> {
        self.delimited_text_options.as_ref()
    }
}
impl std::fmt::Debug for ImportOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportOptions");
        formatter.field("destination_options", &self.destination_options);
        formatter.field("delimited_text_options", &self.delimited_text_options);
        formatter.finish()
    }
}
/// See [`ImportOptions`](crate::model::ImportOptions)
pub mod import_options {
    /// A builder for [`ImportOptions`](crate::model::ImportOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_options: std::option::Option<crate::model::DestinationOptions>,
        pub(crate) delimited_text_options:
            std::option::Option<crate::model::DelimitedTextImportOptions>,
    }
    impl Builder {
        /// <p>Options relating to the destination of the import request.</p>
        pub fn destination_options(mut self, input: crate::model::DestinationOptions) -> Self {
            self.destination_options = Some(input);
            self
        }
        /// <p>Options relating to the destination of the import request.</p>
        pub fn set_destination_options(
            mut self,
            input: std::option::Option<crate::model::DestinationOptions>,
        ) -> Self {
            self.destination_options = input;
            self
        }
        /// <p>Options relating to parsing delimited text. Required if dataFormat is DELIMITED_TEXT.</p>
        pub fn delimited_text_options(
            mut self,
            input: crate::model::DelimitedTextImportOptions,
        ) -> Self {
            self.delimited_text_options = Some(input);
            self
        }
        /// <p>Options relating to parsing delimited text. Required if dataFormat is DELIMITED_TEXT.</p>
        pub fn set_delimited_text_options(
            mut self,
            input: std::option::Option<crate::model::DelimitedTextImportOptions>,
        ) -> Self {
            self.delimited_text_options = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportOptions`](crate::model::ImportOptions)
        pub fn build(self) -> crate::model::ImportOptions {
            crate::model::ImportOptions {
                destination_options: self.destination_options,
                delimited_text_options: self.delimited_text_options,
            }
        }
    }
}
impl ImportOptions {
    /// Creates a new builder-style object to manufacture [`ImportOptions`](crate::model::ImportOptions)
    pub fn builder() -> crate::model::import_options::Builder {
        crate::model::import_options::Builder::default()
    }
}

/// <p> An object that contains the options relating to parsing delimited text as part of an import request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DelimitedTextImportOptions {
    /// <p>The delimiter to use for separating columns in a single row of the input.</p>
    pub delimiter: std::option::Option<std::string::String>,
    /// <p>Indicates whether the input file has a header row at the top containing the column names.</p>
    pub has_header_row: bool,
    /// <p>A parameter to indicate whether empty rows should be ignored or be included in the import.</p>
    pub ignore_empty_rows: bool,
    /// <p>The encoding of the data in the input file.</p>
    pub data_character_encoding: std::option::Option<crate::model::ImportDataCharacterEncoding>,
}
impl DelimitedTextImportOptions {
    /// <p>The delimiter to use for separating columns in a single row of the input.</p>
    pub fn delimiter(&self) -> std::option::Option<&str> {
        self.delimiter.as_deref()
    }
    /// <p>Indicates whether the input file has a header row at the top containing the column names.</p>
    pub fn has_header_row(&self) -> bool {
        self.has_header_row
    }
    /// <p>A parameter to indicate whether empty rows should be ignored or be included in the import.</p>
    pub fn ignore_empty_rows(&self) -> bool {
        self.ignore_empty_rows
    }
    /// <p>The encoding of the data in the input file.</p>
    pub fn data_character_encoding(
        &self,
    ) -> std::option::Option<&crate::model::ImportDataCharacterEncoding> {
        self.data_character_encoding.as_ref()
    }
}
impl std::fmt::Debug for DelimitedTextImportOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DelimitedTextImportOptions");
        formatter.field("delimiter", &self.delimiter);
        formatter.field("has_header_row", &self.has_header_row);
        formatter.field("ignore_empty_rows", &self.ignore_empty_rows);
        formatter.field("data_character_encoding", &self.data_character_encoding);
        formatter.finish()
    }
}
/// See [`DelimitedTextImportOptions`](crate::model::DelimitedTextImportOptions)
pub mod delimited_text_import_options {
    /// A builder for [`DelimitedTextImportOptions`](crate::model::DelimitedTextImportOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delimiter: std::option::Option<std::string::String>,
        pub(crate) has_header_row: std::option::Option<bool>,
        pub(crate) ignore_empty_rows: std::option::Option<bool>,
        pub(crate) data_character_encoding:
            std::option::Option<crate::model::ImportDataCharacterEncoding>,
    }
    impl Builder {
        /// <p>The delimiter to use for separating columns in a single row of the input.</p>
        pub fn delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.delimiter = Some(input.into());
            self
        }
        /// <p>The delimiter to use for separating columns in a single row of the input.</p>
        pub fn set_delimiter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.delimiter = input;
            self
        }
        /// <p>Indicates whether the input file has a header row at the top containing the column names.</p>
        pub fn has_header_row(mut self, input: bool) -> Self {
            self.has_header_row = Some(input);
            self
        }
        /// <p>Indicates whether the input file has a header row at the top containing the column names.</p>
        pub fn set_has_header_row(mut self, input: std::option::Option<bool>) -> Self {
            self.has_header_row = input;
            self
        }
        /// <p>A parameter to indicate whether empty rows should be ignored or be included in the import.</p>
        pub fn ignore_empty_rows(mut self, input: bool) -> Self {
            self.ignore_empty_rows = Some(input);
            self
        }
        /// <p>A parameter to indicate whether empty rows should be ignored or be included in the import.</p>
        pub fn set_ignore_empty_rows(mut self, input: std::option::Option<bool>) -> Self {
            self.ignore_empty_rows = input;
            self
        }
        /// <p>The encoding of the data in the input file.</p>
        pub fn data_character_encoding(
            mut self,
            input: crate::model::ImportDataCharacterEncoding,
        ) -> Self {
            self.data_character_encoding = Some(input);
            self
        }
        /// <p>The encoding of the data in the input file.</p>
        pub fn set_data_character_encoding(
            mut self,
            input: std::option::Option<crate::model::ImportDataCharacterEncoding>,
        ) -> Self {
            self.data_character_encoding = input;
            self
        }
        /// Consumes the builder and constructs a [`DelimitedTextImportOptions`](crate::model::DelimitedTextImportOptions)
        pub fn build(self) -> crate::model::DelimitedTextImportOptions {
            crate::model::DelimitedTextImportOptions {
                delimiter: self.delimiter,
                has_header_row: self.has_header_row.unwrap_or_default(),
                ignore_empty_rows: self.ignore_empty_rows.unwrap_or_default(),
                data_character_encoding: self.data_character_encoding,
            }
        }
    }
}
impl DelimitedTextImportOptions {
    /// Creates a new builder-style object to manufacture [`DelimitedTextImportOptions`](crate::model::DelimitedTextImportOptions)
    pub fn builder() -> crate::model::delimited_text_import_options::Builder {
        crate::model::delimited_text_import_options::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ImportDataCharacterEncoding {
    #[allow(missing_docs)] // documentation missing in model
    Iso88591,
    #[allow(missing_docs)] // documentation missing in model
    UsAscii,
    #[allow(missing_docs)] // documentation missing in model
    Utf16,
    #[allow(missing_docs)] // documentation missing in model
    Utf16Be,
    #[allow(missing_docs)] // documentation missing in model
    Utf16Le,
    #[allow(missing_docs)] // documentation missing in model
    Utf8,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ImportDataCharacterEncoding {
    fn from(s: &str) -> Self {
        match s {
            "ISO-8859-1" => ImportDataCharacterEncoding::Iso88591,
            "US-ASCII" => ImportDataCharacterEncoding::UsAscii,
            "UTF-16" => ImportDataCharacterEncoding::Utf16,
            "UTF-16BE" => ImportDataCharacterEncoding::Utf16Be,
            "UTF-16LE" => ImportDataCharacterEncoding::Utf16Le,
            "UTF-8" => ImportDataCharacterEncoding::Utf8,
            other => ImportDataCharacterEncoding::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ImportDataCharacterEncoding {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ImportDataCharacterEncoding::from(s))
    }
}
impl ImportDataCharacterEncoding {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ImportDataCharacterEncoding::Iso88591 => "ISO-8859-1",
            ImportDataCharacterEncoding::UsAscii => "US-ASCII",
            ImportDataCharacterEncoding::Utf16 => "UTF-16",
            ImportDataCharacterEncoding::Utf16Be => "UTF-16BE",
            ImportDataCharacterEncoding::Utf16Le => "UTF-16LE",
            ImportDataCharacterEncoding::Utf8 => "UTF-8",
            ImportDataCharacterEncoding::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ISO-8859-1",
            "US-ASCII",
            "UTF-16",
            "UTF-16BE",
            "UTF-16LE",
            "UTF-8",
        ]
    }
}
impl AsRef<str> for ImportDataCharacterEncoding {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that contains the options relating to the destination of the import request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DestinationOptions {
    /// <p>A map of the column id to the import properties for each column.</p>
    pub column_map: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::SourceDataColumnProperties>,
    >,
}
impl DestinationOptions {
    /// <p>A map of the column id to the import properties for each column.</p>
    pub fn column_map(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::SourceDataColumnProperties>,
    > {
        self.column_map.as_ref()
    }
}
impl std::fmt::Debug for DestinationOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DestinationOptions");
        formatter.field("column_map", &self.column_map);
        formatter.finish()
    }
}
/// See [`DestinationOptions`](crate::model::DestinationOptions)
pub mod destination_options {
    /// A builder for [`DestinationOptions`](crate::model::DestinationOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) column_map: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                crate::model::SourceDataColumnProperties,
            >,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `column_map`.
        ///
        /// To override the contents of this collection use [`set_column_map`](Self::set_column_map).
        ///
        /// <p>A map of the column id to the import properties for each column.</p>
        pub fn column_map(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::SourceDataColumnProperties,
        ) -> Self {
            let mut hash_map = self.column_map.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.column_map = Some(hash_map);
            self
        }
        /// <p>A map of the column id to the import properties for each column.</p>
        pub fn set_column_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::SourceDataColumnProperties,
                >,
            >,
        ) -> Self {
            self.column_map = input;
            self
        }
        /// Consumes the builder and constructs a [`DestinationOptions`](crate::model::DestinationOptions)
        pub fn build(self) -> crate::model::DestinationOptions {
            crate::model::DestinationOptions {
                column_map: self.column_map,
            }
        }
    }
}
impl DestinationOptions {
    /// Creates a new builder-style object to manufacture [`DestinationOptions`](crate::model::DestinationOptions)
    pub fn builder() -> crate::model::destination_options::Builder {
        crate::model::destination_options::Builder::default()
    }
}

/// <p>An object that contains the properties for importing data to a specific column in a table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceDataColumnProperties {
    /// <p>The index of the column in the input file.</p>
    pub column_index: i32,
}
impl SourceDataColumnProperties {
    /// <p>The index of the column in the input file.</p>
    pub fn column_index(&self) -> i32 {
        self.column_index
    }
}
impl std::fmt::Debug for SourceDataColumnProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceDataColumnProperties");
        formatter.field("column_index", &self.column_index);
        formatter.finish()
    }
}
/// See [`SourceDataColumnProperties`](crate::model::SourceDataColumnProperties)
pub mod source_data_column_properties {
    /// A builder for [`SourceDataColumnProperties`](crate::model::SourceDataColumnProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) column_index: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The index of the column in the input file.</p>
        pub fn column_index(mut self, input: i32) -> Self {
            self.column_index = Some(input);
            self
        }
        /// <p>The index of the column in the input file.</p>
        pub fn set_column_index(mut self, input: std::option::Option<i32>) -> Self {
            self.column_index = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceDataColumnProperties`](crate::model::SourceDataColumnProperties)
        pub fn build(self) -> crate::model::SourceDataColumnProperties {
            crate::model::SourceDataColumnProperties {
                column_index: self.column_index.unwrap_or_default(),
            }
        }
    }
}
impl SourceDataColumnProperties {
    /// Creates a new builder-style object to manufacture [`SourceDataColumnProperties`](crate::model::SourceDataColumnProperties)
    pub fn builder() -> crate::model::source_data_column_properties::Builder {
        crate::model::source_data_column_properties::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ImportSourceDataFormat {
    #[allow(missing_docs)] // documentation missing in model
    DelimitedText,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ImportSourceDataFormat {
    fn from(s: &str) -> Self {
        match s {
            "DELIMITED_TEXT" => ImportSourceDataFormat::DelimitedText,
            other => ImportSourceDataFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ImportSourceDataFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ImportSourceDataFormat::from(s))
    }
}
impl ImportSourceDataFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ImportSourceDataFormat::DelimitedText => "DELIMITED_TEXT",
            ImportSourceDataFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELIMITED_TEXT"]
    }
}
impl AsRef<str> for ImportSourceDataFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object that has details about the source of the data that was submitted for import.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportDataSource {
    /// <p>The configuration parameters for the data source of the import</p>
    pub data_source_config: std::option::Option<crate::model::ImportDataSourceConfig>,
}
impl ImportDataSource {
    /// <p>The configuration parameters for the data source of the import</p>
    pub fn data_source_config(&self) -> std::option::Option<&crate::model::ImportDataSourceConfig> {
        self.data_source_config.as_ref()
    }
}
impl std::fmt::Debug for ImportDataSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportDataSource");
        formatter.field("data_source_config", &self.data_source_config);
        formatter.finish()
    }
}
/// See [`ImportDataSource`](crate::model::ImportDataSource)
pub mod import_data_source {
    /// A builder for [`ImportDataSource`](crate::model::ImportDataSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_source_config: std::option::Option<crate::model::ImportDataSourceConfig>,
    }
    impl Builder {
        /// <p>The configuration parameters for the data source of the import</p>
        pub fn data_source_config(mut self, input: crate::model::ImportDataSourceConfig) -> Self {
            self.data_source_config = Some(input);
            self
        }
        /// <p>The configuration parameters for the data source of the import</p>
        pub fn set_data_source_config(
            mut self,
            input: std::option::Option<crate::model::ImportDataSourceConfig>,
        ) -> Self {
            self.data_source_config = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportDataSource`](crate::model::ImportDataSource)
        pub fn build(self) -> crate::model::ImportDataSource {
            crate::model::ImportDataSource {
                data_source_config: self.data_source_config,
            }
        }
    }
}
impl ImportDataSource {
    /// Creates a new builder-style object to manufacture [`ImportDataSource`](crate::model::ImportDataSource)
    pub fn builder() -> crate::model::import_data_source::Builder {
        crate::model::import_data_source::Builder::default()
    }
}

/// <p> An object that contains the configuration parameters for the data source of an import request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportDataSourceConfig {
    /// <p> The URL from which source data will be downloaded for the import request. </p>
    pub data_source_url: std::option::Option<std::string::String>,
}
impl ImportDataSourceConfig {
    /// <p> The URL from which source data will be downloaded for the import request. </p>
    pub fn data_source_url(&self) -> std::option::Option<&str> {
        self.data_source_url.as_deref()
    }
}
impl std::fmt::Debug for ImportDataSourceConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportDataSourceConfig");
        formatter.field("data_source_url", &self.data_source_url);
        formatter.finish()
    }
}
/// See [`ImportDataSourceConfig`](crate::model::ImportDataSourceConfig)
pub mod import_data_source_config {
    /// A builder for [`ImportDataSourceConfig`](crate::model::ImportDataSourceConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_source_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The URL from which source data will be downloaded for the import request. </p>
        pub fn data_source_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_url = Some(input.into());
            self
        }
        /// <p> The URL from which source data will be downloaded for the import request. </p>
        pub fn set_data_source_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_url = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportDataSourceConfig`](crate::model::ImportDataSourceConfig)
        pub fn build(self) -> crate::model::ImportDataSourceConfig {
            crate::model::ImportDataSourceConfig {
                data_source_url: self.data_source_url,
            }
        }
    }
}
impl ImportDataSourceConfig {
    /// Creates a new builder-style object to manufacture [`ImportDataSourceConfig`](crate::model::ImportDataSourceConfig)
    pub fn builder() -> crate::model::import_data_source_config::Builder {
        crate::model::import_data_source_config::Builder::default()
    }
}

/// <p>An object that contains attributes about a single row in a table</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TableRow {
    /// <p>The id of the row in the table.</p>
    pub row_id: std::option::Option<std::string::String>,
    /// <p>A list of cells in the table row. The cells appear in the same order as the columns of the table. </p>
    pub cells: std::option::Option<std::vec::Vec<crate::model::Cell>>,
}
impl TableRow {
    /// <p>The id of the row in the table.</p>
    pub fn row_id(&self) -> std::option::Option<&str> {
        self.row_id.as_deref()
    }
    /// <p>A list of cells in the table row. The cells appear in the same order as the columns of the table. </p>
    pub fn cells(&self) -> std::option::Option<&[crate::model::Cell]> {
        self.cells.as_deref()
    }
}
impl std::fmt::Debug for TableRow {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TableRow");
        formatter.field("row_id", &self.row_id);
        formatter.field("cells", &self.cells);
        formatter.finish()
    }
}
/// See [`TableRow`](crate::model::TableRow)
pub mod table_row {
    /// A builder for [`TableRow`](crate::model::TableRow)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) row_id: std::option::Option<std::string::String>,
        pub(crate) cells: std::option::Option<std::vec::Vec<crate::model::Cell>>,
    }
    impl Builder {
        /// <p>The id of the row in the table.</p>
        pub fn row_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.row_id = Some(input.into());
            self
        }
        /// <p>The id of the row in the table.</p>
        pub fn set_row_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.row_id = input;
            self
        }
        /// Appends an item to `cells`.
        ///
        /// To override the contents of this collection use [`set_cells`](Self::set_cells).
        ///
        /// <p>A list of cells in the table row. The cells appear in the same order as the columns of the table. </p>
        pub fn cells(mut self, input: crate::model::Cell) -> Self {
            let mut v = self.cells.unwrap_or_default();
            v.push(input);
            self.cells = Some(v);
            self
        }
        /// <p>A list of cells in the table row. The cells appear in the same order as the columns of the table. </p>
        pub fn set_cells(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Cell>>,
        ) -> Self {
            self.cells = input;
            self
        }
        /// Consumes the builder and constructs a [`TableRow`](crate::model::TableRow)
        pub fn build(self) -> crate::model::TableRow {
            crate::model::TableRow {
                row_id: self.row_id,
                cells: self.cells,
            }
        }
    }
}
impl TableRow {
    /// Creates a new builder-style object to manufacture [`TableRow`](crate::model::TableRow)
    pub fn builder() -> crate::model::table_row::Builder {
        crate::model::table_row::Builder::default()
    }
}

/// <p>An object that represents a single cell in a table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Cell {
    /// <p> The formula contained in the cell. This field is empty if a cell does not have a formula. </p>
    pub formula: std::option::Option<std::string::String>,
    /// <p>The format of the cell. If this field is empty, then the format is either not specified in the workbook or the format is set to AUTO.</p>
    pub format: std::option::Option<crate::model::Format>,
    /// <p> The raw value of the data contained in the cell. The raw value depends on the format of the data in the cell. However the attribute in the API return value is always a string containing the raw value. </p>
    /// <p> Cells with format DATE, DATE_TIME or TIME have the raw value as a floating point number where the whole number represents the number of days since 1/1/1900 and the fractional part represents the fraction of the day since midnight. For example, a cell with date 11/3/2020 has the raw value "44138". A cell with the time 9:00 AM has the raw value "0.375" and a cell with date/time value of 11/3/2020 9:00 AM has the raw value "44138.375". Notice that even though the raw value is a number in all three cases, it is still represented as a string. </p>
    /// <p> Cells with format NUMBER, CURRENCY, PERCENTAGE and ACCOUNTING have the raw value of the data as the number representing the data being displayed. For example, the number 1.325 with two decimal places in the format will have it's raw value as "1.325" and formatted value as "1.33". A currency value for $10 will have the raw value as "10" and formatted value as "$10.00". A value representing 20% with two decimal places in the format will have its raw value as "0.2" and the formatted value as "20.00%". An accounting value of -$25 will have "-25" as the raw value and "$ (25.00)" as the formatted value. </p>
    /// <p> Cells with format TEXT will have the raw text as the raw value. For example, a cell with text "John Smith" will have "John Smith" as both the raw value and the formatted value. </p>
    /// <p> Cells with format CONTACT will have the name of the contact as a formatted value and the email address of the contact as the raw value. For example, a contact for John Smith will have "John Smith" as the formatted value and "john.smith@example.com" as the raw value. </p>
    /// <p> Cells with format ROWLINK (aka picklist) will have the first column of the linked row as the formatted value and the row id of the linked row as the raw value. For example, a cell containing a picklist to a table that displays task status might have "Completed" as the formatted value and "row:dfcefaee-5b37-4355-8f28-40c3e4ff5dd4/ca432b2f-b8eb-431d-9fb5-cbe0342f9f03" as the raw value. </p>
    /// <p> Cells with format AUTO or cells without any format that are auto-detected as one of the formats above will contain the raw and formatted values as mentioned above, based on the auto-detected formats. If there is no auto-detected format, the raw and formatted values will be the same as the data in the cell. </p>
    pub raw_value: std::option::Option<std::string::String>,
    /// <p> The formatted value of the cell. This is the value that you see displayed in the cell in the UI. </p>
    /// <p> Note that the formatted value of a cell is always represented as a string irrespective of the data that is stored in the cell. For example, if a cell contains a date, the formatted value of the cell is the string representation of the formatted date being shown in the cell in the UI. See details in the rawValue field below for how cells of different formats will have different raw and formatted values. </p>
    pub formatted_value: std::option::Option<std::string::String>,
}
impl Cell {
    /// <p> The formula contained in the cell. This field is empty if a cell does not have a formula. </p>
    pub fn formula(&self) -> std::option::Option<&str> {
        self.formula.as_deref()
    }
    /// <p>The format of the cell. If this field is empty, then the format is either not specified in the workbook or the format is set to AUTO.</p>
    pub fn format(&self) -> std::option::Option<&crate::model::Format> {
        self.format.as_ref()
    }
    /// <p> The raw value of the data contained in the cell. The raw value depends on the format of the data in the cell. However the attribute in the API return value is always a string containing the raw value. </p>
    /// <p> Cells with format DATE, DATE_TIME or TIME have the raw value as a floating point number where the whole number represents the number of days since 1/1/1900 and the fractional part represents the fraction of the day since midnight. For example, a cell with date 11/3/2020 has the raw value "44138". A cell with the time 9:00 AM has the raw value "0.375" and a cell with date/time value of 11/3/2020 9:00 AM has the raw value "44138.375". Notice that even though the raw value is a number in all three cases, it is still represented as a string. </p>
    /// <p> Cells with format NUMBER, CURRENCY, PERCENTAGE and ACCOUNTING have the raw value of the data as the number representing the data being displayed. For example, the number 1.325 with two decimal places in the format will have it's raw value as "1.325" and formatted value as "1.33". A currency value for $10 will have the raw value as "10" and formatted value as "$10.00". A value representing 20% with two decimal places in the format will have its raw value as "0.2" and the formatted value as "20.00%". An accounting value of -$25 will have "-25" as the raw value and "$ (25.00)" as the formatted value. </p>
    /// <p> Cells with format TEXT will have the raw text as the raw value. For example, a cell with text "John Smith" will have "John Smith" as both the raw value and the formatted value. </p>
    /// <p> Cells with format CONTACT will have the name of the contact as a formatted value and the email address of the contact as the raw value. For example, a contact for John Smith will have "John Smith" as the formatted value and "john.smith@example.com" as the raw value. </p>
    /// <p> Cells with format ROWLINK (aka picklist) will have the first column of the linked row as the formatted value and the row id of the linked row as the raw value. For example, a cell containing a picklist to a table that displays task status might have "Completed" as the formatted value and "row:dfcefaee-5b37-4355-8f28-40c3e4ff5dd4/ca432b2f-b8eb-431d-9fb5-cbe0342f9f03" as the raw value. </p>
    /// <p> Cells with format AUTO or cells without any format that are auto-detected as one of the formats above will contain the raw and formatted values as mentioned above, based on the auto-detected formats. If there is no auto-detected format, the raw and formatted values will be the same as the data in the cell. </p>
    pub fn raw_value(&self) -> std::option::Option<&str> {
        self.raw_value.as_deref()
    }
    /// <p> The formatted value of the cell. This is the value that you see displayed in the cell in the UI. </p>
    /// <p> Note that the formatted value of a cell is always represented as a string irrespective of the data that is stored in the cell. For example, if a cell contains a date, the formatted value of the cell is the string representation of the formatted date being shown in the cell in the UI. See details in the rawValue field below for how cells of different formats will have different raw and formatted values. </p>
    pub fn formatted_value(&self) -> std::option::Option<&str> {
        self.formatted_value.as_deref()
    }
}
impl std::fmt::Debug for Cell {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Cell");
        formatter.field("formula", &"*** Sensitive Data Redacted ***");
        formatter.field("format", &self.format);
        formatter.field("raw_value", &self.raw_value);
        formatter.field("formatted_value", &self.formatted_value);
        formatter.finish()
    }
}
/// See [`Cell`](crate::model::Cell)
pub mod cell {
    /// A builder for [`Cell`](crate::model::Cell)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) formula: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::Format>,
        pub(crate) raw_value: std::option::Option<std::string::String>,
        pub(crate) formatted_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The formula contained in the cell. This field is empty if a cell does not have a formula. </p>
        pub fn formula(mut self, input: impl Into<std::string::String>) -> Self {
            self.formula = Some(input.into());
            self
        }
        /// <p> The formula contained in the cell. This field is empty if a cell does not have a formula. </p>
        pub fn set_formula(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.formula = input;
            self
        }
        /// <p>The format of the cell. If this field is empty, then the format is either not specified in the workbook or the format is set to AUTO.</p>
        pub fn format(mut self, input: crate::model::Format) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>The format of the cell. If this field is empty, then the format is either not specified in the workbook or the format is set to AUTO.</p>
        pub fn set_format(mut self, input: std::option::Option<crate::model::Format>) -> Self {
            self.format = input;
            self
        }
        /// <p> The raw value of the data contained in the cell. The raw value depends on the format of the data in the cell. However the attribute in the API return value is always a string containing the raw value. </p>
        /// <p> Cells with format DATE, DATE_TIME or TIME have the raw value as a floating point number where the whole number represents the number of days since 1/1/1900 and the fractional part represents the fraction of the day since midnight. For example, a cell with date 11/3/2020 has the raw value "44138". A cell with the time 9:00 AM has the raw value "0.375" and a cell with date/time value of 11/3/2020 9:00 AM has the raw value "44138.375". Notice that even though the raw value is a number in all three cases, it is still represented as a string. </p>
        /// <p> Cells with format NUMBER, CURRENCY, PERCENTAGE and ACCOUNTING have the raw value of the data as the number representing the data being displayed. For example, the number 1.325 with two decimal places in the format will have it's raw value as "1.325" and formatted value as "1.33". A currency value for $10 will have the raw value as "10" and formatted value as "$10.00". A value representing 20% with two decimal places in the format will have its raw value as "0.2" and the formatted value as "20.00%". An accounting value of -$25 will have "-25" as the raw value and "$ (25.00)" as the formatted value. </p>
        /// <p> Cells with format TEXT will have the raw text as the raw value. For example, a cell with text "John Smith" will have "John Smith" as both the raw value and the formatted value. </p>
        /// <p> Cells with format CONTACT will have the name of the contact as a formatted value and the email address of the contact as the raw value. For example, a contact for John Smith will have "John Smith" as the formatted value and "john.smith@example.com" as the raw value. </p>
        /// <p> Cells with format ROWLINK (aka picklist) will have the first column of the linked row as the formatted value and the row id of the linked row as the raw value. For example, a cell containing a picklist to a table that displays task status might have "Completed" as the formatted value and "row:dfcefaee-5b37-4355-8f28-40c3e4ff5dd4/ca432b2f-b8eb-431d-9fb5-cbe0342f9f03" as the raw value. </p>
        /// <p> Cells with format AUTO or cells without any format that are auto-detected as one of the formats above will contain the raw and formatted values as mentioned above, based on the auto-detected formats. If there is no auto-detected format, the raw and formatted values will be the same as the data in the cell. </p>
        pub fn raw_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.raw_value = Some(input.into());
            self
        }
        /// <p> The raw value of the data contained in the cell. The raw value depends on the format of the data in the cell. However the attribute in the API return value is always a string containing the raw value. </p>
        /// <p> Cells with format DATE, DATE_TIME or TIME have the raw value as a floating point number where the whole number represents the number of days since 1/1/1900 and the fractional part represents the fraction of the day since midnight. For example, a cell with date 11/3/2020 has the raw value "44138". A cell with the time 9:00 AM has the raw value "0.375" and a cell with date/time value of 11/3/2020 9:00 AM has the raw value "44138.375". Notice that even though the raw value is a number in all three cases, it is still represented as a string. </p>
        /// <p> Cells with format NUMBER, CURRENCY, PERCENTAGE and ACCOUNTING have the raw value of the data as the number representing the data being displayed. For example, the number 1.325 with two decimal places in the format will have it's raw value as "1.325" and formatted value as "1.33". A currency value for $10 will have the raw value as "10" and formatted value as "$10.00". A value representing 20% with two decimal places in the format will have its raw value as "0.2" and the formatted value as "20.00%". An accounting value of -$25 will have "-25" as the raw value and "$ (25.00)" as the formatted value. </p>
        /// <p> Cells with format TEXT will have the raw text as the raw value. For example, a cell with text "John Smith" will have "John Smith" as both the raw value and the formatted value. </p>
        /// <p> Cells with format CONTACT will have the name of the contact as a formatted value and the email address of the contact as the raw value. For example, a contact for John Smith will have "John Smith" as the formatted value and "john.smith@example.com" as the raw value. </p>
        /// <p> Cells with format ROWLINK (aka picklist) will have the first column of the linked row as the formatted value and the row id of the linked row as the raw value. For example, a cell containing a picklist to a table that displays task status might have "Completed" as the formatted value and "row:dfcefaee-5b37-4355-8f28-40c3e4ff5dd4/ca432b2f-b8eb-431d-9fb5-cbe0342f9f03" as the raw value. </p>
        /// <p> Cells with format AUTO or cells without any format that are auto-detected as one of the formats above will contain the raw and formatted values as mentioned above, based on the auto-detected formats. If there is no auto-detected format, the raw and formatted values will be the same as the data in the cell. </p>
        pub fn set_raw_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.raw_value = input;
            self
        }
        /// <p> The formatted value of the cell. This is the value that you see displayed in the cell in the UI. </p>
        /// <p> Note that the formatted value of a cell is always represented as a string irrespective of the data that is stored in the cell. For example, if a cell contains a date, the formatted value of the cell is the string representation of the formatted date being shown in the cell in the UI. See details in the rawValue field below for how cells of different formats will have different raw and formatted values. </p>
        pub fn formatted_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.formatted_value = Some(input.into());
            self
        }
        /// <p> The formatted value of the cell. This is the value that you see displayed in the cell in the UI. </p>
        /// <p> Note that the formatted value of a cell is always represented as a string irrespective of the data that is stored in the cell. For example, if a cell contains a date, the formatted value of the cell is the string representation of the formatted date being shown in the cell in the UI. See details in the rawValue field below for how cells of different formats will have different raw and formatted values. </p>
        pub fn set_formatted_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.formatted_value = input;
            self
        }
        /// Consumes the builder and constructs a [`Cell`](crate::model::Cell)
        pub fn build(self) -> crate::model::Cell {
            crate::model::Cell {
                formula: self.formula,
                format: self.format,
                raw_value: self.raw_value,
                formatted_value: self.formatted_value,
            }
        }
    }
}
impl Cell {
    /// Creates a new builder-style object to manufacture [`Cell`](crate::model::Cell)
    pub fn builder() -> crate::model::cell::Builder {
        crate::model::cell::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Format {
    #[allow(missing_docs)] // documentation missing in model
    Accounting,
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    Contact,
    #[allow(missing_docs)] // documentation missing in model
    Currency,
    #[allow(missing_docs)] // documentation missing in model
    Date,
    #[allow(missing_docs)] // documentation missing in model
    DateTime,
    #[allow(missing_docs)] // documentation missing in model
    Number,
    #[allow(missing_docs)] // documentation missing in model
    Percentage,
    #[allow(missing_docs)] // documentation missing in model
    Rowlink,
    #[allow(missing_docs)] // documentation missing in model
    Text,
    #[allow(missing_docs)] // documentation missing in model
    Time,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Format {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNTING" => Format::Accounting,
            "AUTO" => Format::Auto,
            "CONTACT" => Format::Contact,
            "CURRENCY" => Format::Currency,
            "DATE" => Format::Date,
            "DATE_TIME" => Format::DateTime,
            "NUMBER" => Format::Number,
            "PERCENTAGE" => Format::Percentage,
            "ROWLINK" => Format::Rowlink,
            "TEXT" => Format::Text,
            "TIME" => Format::Time,
            other => Format::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Format {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Format::from(s))
    }
}
impl Format {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Format::Accounting => "ACCOUNTING",
            Format::Auto => "AUTO",
            Format::Contact => "CONTACT",
            Format::Currency => "CURRENCY",
            Format::Date => "DATE",
            Format::DateTime => "DATE_TIME",
            Format::Number => "NUMBER",
            Format::Percentage => "PERCENTAGE",
            Format::Rowlink => "ROWLINK",
            Format::Text => "TEXT",
            Format::Time => "TIME",
            Format::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCOUNTING",
            "AUTO",
            "CONTACT",
            "CURRENCY",
            "DATE",
            "DATE_TIME",
            "NUMBER",
            "PERCENTAGE",
            "ROWLINK",
            "TEXT",
            "TIME",
        ]
    }
}
impl AsRef<str> for Format {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> An object that represents a filter formula along with the id of the context row under which the filter function needs to evaluate. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Filter {
    /// <p> A formula representing a filter function that returns zero or more matching rows from a table. Valid formulas in this field return a list of rows from a table. The most common ways of writing a formula to return a list of rows are to use the FindRow() or Filter() functions. Any other formula that returns zero or more rows is also acceptable. For example, you can use a formula that points to a cell that contains a filter function. </p>
    pub formula: std::option::Option<std::string::String>,
    /// <p> The optional contextRowId attribute can be used to specify the row id of the context row if the filter formula contains unqualified references to table columns and needs a context row to evaluate them successfully. </p>
    pub context_row_id: std::option::Option<std::string::String>,
}
impl Filter {
    /// <p> A formula representing a filter function that returns zero or more matching rows from a table. Valid formulas in this field return a list of rows from a table. The most common ways of writing a formula to return a list of rows are to use the FindRow() or Filter() functions. Any other formula that returns zero or more rows is also acceptable. For example, you can use a formula that points to a cell that contains a filter function. </p>
    pub fn formula(&self) -> std::option::Option<&str> {
        self.formula.as_deref()
    }
    /// <p> The optional contextRowId attribute can be used to specify the row id of the context row if the filter formula contains unqualified references to table columns and needs a context row to evaluate them successfully. </p>
    pub fn context_row_id(&self) -> std::option::Option<&str> {
        self.context_row_id.as_deref()
    }
}
impl std::fmt::Debug for Filter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Filter");
        formatter.field("formula", &"*** Sensitive Data Redacted ***");
        formatter.field("context_row_id", &self.context_row_id);
        formatter.finish()
    }
}
/// See [`Filter`](crate::model::Filter)
pub mod filter {
    /// A builder for [`Filter`](crate::model::Filter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) formula: std::option::Option<std::string::String>,
        pub(crate) context_row_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> A formula representing a filter function that returns zero or more matching rows from a table. Valid formulas in this field return a list of rows from a table. The most common ways of writing a formula to return a list of rows are to use the FindRow() or Filter() functions. Any other formula that returns zero or more rows is also acceptable. For example, you can use a formula that points to a cell that contains a filter function. </p>
        pub fn formula(mut self, input: impl Into<std::string::String>) -> Self {
            self.formula = Some(input.into());
            self
        }
        /// <p> A formula representing a filter function that returns zero or more matching rows from a table. Valid formulas in this field return a list of rows from a table. The most common ways of writing a formula to return a list of rows are to use the FindRow() or Filter() functions. Any other formula that returns zero or more rows is also acceptable. For example, you can use a formula that points to a cell that contains a filter function. </p>
        pub fn set_formula(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.formula = input;
            self
        }
        /// <p> The optional contextRowId attribute can be used to specify the row id of the context row if the filter formula contains unqualified references to table columns and needs a context row to evaluate them successfully. </p>
        pub fn context_row_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.context_row_id = Some(input.into());
            self
        }
        /// <p> The optional contextRowId attribute can be used to specify the row id of the context row if the filter formula contains unqualified references to table columns and needs a context row to evaluate them successfully. </p>
        pub fn set_context_row_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.context_row_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Filter`](crate::model::Filter)
        pub fn build(self) -> crate::model::Filter {
            crate::model::Filter {
                formula: self.formula,
                context_row_id: self.context_row_id,
            }
        }
    }
}
impl Filter {
    /// Creates a new builder-style object to manufacture [`Filter`](crate::model::Filter)
    pub fn builder() -> crate::model::filter::Builder {
        crate::model::filter::Builder::default()
    }
}

/// <p>An object representing the properties of a table in a workbook.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Table {
    /// <p>The id of the table.</p>
    pub table_id: std::option::Option<std::string::String>,
    /// <p>The name of the table.</p>
    pub table_name: std::option::Option<std::string::String>,
}
impl Table {
    /// <p>The id of the table.</p>
    pub fn table_id(&self) -> std::option::Option<&str> {
        self.table_id.as_deref()
    }
    /// <p>The name of the table.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
}
impl std::fmt::Debug for Table {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Table");
        formatter.field("table_id", &self.table_id);
        formatter.field("table_name", &self.table_name);
        formatter.finish()
    }
}
/// See [`Table`](crate::model::Table)
pub mod table {
    /// A builder for [`Table`](crate::model::Table)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_id: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The id of the table.</p>
        pub fn table_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_id = Some(input.into());
            self
        }
        /// <p>The id of the table.</p>
        pub fn set_table_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_id = input;
            self
        }
        /// <p>The name of the table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// Consumes the builder and constructs a [`Table`](crate::model::Table)
        pub fn build(self) -> crate::model::Table {
            crate::model::Table {
                table_id: self.table_id,
                table_name: self.table_name,
            }
        }
    }
}
impl Table {
    /// Creates a new builder-style object to manufacture [`Table`](crate::model::Table)
    pub fn builder() -> crate::model::table::Builder {
        crate::model::table::Builder::default()
    }
}

/// <p>An object that contains attributes about a single column in a table</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TableColumn {
    /// <p>The id of the column in the table.</p>
    pub table_column_id: std::option::Option<std::string::String>,
    /// <p>The name of the column in the table.</p>
    pub table_column_name: std::option::Option<std::string::String>,
    /// <p> The column level format that is applied in the table. An empty value in this field means that the column format is the default value 'AUTO'. </p>
    pub format: std::option::Option<crate::model::Format>,
}
impl TableColumn {
    /// <p>The id of the column in the table.</p>
    pub fn table_column_id(&self) -> std::option::Option<&str> {
        self.table_column_id.as_deref()
    }
    /// <p>The name of the column in the table.</p>
    pub fn table_column_name(&self) -> std::option::Option<&str> {
        self.table_column_name.as_deref()
    }
    /// <p> The column level format that is applied in the table. An empty value in this field means that the column format is the default value 'AUTO'. </p>
    pub fn format(&self) -> std::option::Option<&crate::model::Format> {
        self.format.as_ref()
    }
}
impl std::fmt::Debug for TableColumn {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TableColumn");
        formatter.field("table_column_id", &self.table_column_id);
        formatter.field("table_column_name", &self.table_column_name);
        formatter.field("format", &self.format);
        formatter.finish()
    }
}
/// See [`TableColumn`](crate::model::TableColumn)
pub mod table_column {
    /// A builder for [`TableColumn`](crate::model::TableColumn)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_column_id: std::option::Option<std::string::String>,
        pub(crate) table_column_name: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::Format>,
    }
    impl Builder {
        /// <p>The id of the column in the table.</p>
        pub fn table_column_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_column_id = Some(input.into());
            self
        }
        /// <p>The id of the column in the table.</p>
        pub fn set_table_column_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.table_column_id = input;
            self
        }
        /// <p>The name of the column in the table.</p>
        pub fn table_column_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_column_name = Some(input.into());
            self
        }
        /// <p>The name of the column in the table.</p>
        pub fn set_table_column_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.table_column_name = input;
            self
        }
        /// <p> The column level format that is applied in the table. An empty value in this field means that the column format is the default value 'AUTO'. </p>
        pub fn format(mut self, input: crate::model::Format) -> Self {
            self.format = Some(input);
            self
        }
        /// <p> The column level format that is applied in the table. An empty value in this field means that the column format is the default value 'AUTO'. </p>
        pub fn set_format(mut self, input: std::option::Option<crate::model::Format>) -> Self {
            self.format = input;
            self
        }
        /// Consumes the builder and constructs a [`TableColumn`](crate::model::TableColumn)
        pub fn build(self) -> crate::model::TableColumn {
            crate::model::TableColumn {
                table_column_id: self.table_column_id,
                table_column_name: self.table_column_name,
                format: self.format,
            }
        }
    }
}
impl TableColumn {
    /// Creates a new builder-style object to manufacture [`TableColumn`](crate::model::TableColumn)
    pub fn builder() -> crate::model::table_column::Builder {
        crate::model::table_column::Builder::default()
    }
}

/// <p>The input variables to the app to be used by the InvokeScreenAutomation action request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VariableValue {
    /// <p>Raw value of the variable.</p>
    pub raw_value: std::option::Option<std::string::String>,
}
impl VariableValue {
    /// <p>Raw value of the variable.</p>
    pub fn raw_value(&self) -> std::option::Option<&str> {
        self.raw_value.as_deref()
    }
}
impl std::fmt::Debug for VariableValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VariableValue");
        formatter.field("raw_value", &self.raw_value);
        formatter.finish()
    }
}
/// See [`VariableValue`](crate::model::VariableValue)
pub mod variable_value {
    /// A builder for [`VariableValue`](crate::model::VariableValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) raw_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Raw value of the variable.</p>
        pub fn raw_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.raw_value = Some(input.into());
            self
        }
        /// <p>Raw value of the variable.</p>
        pub fn set_raw_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.raw_value = input;
            self
        }
        /// Consumes the builder and constructs a [`VariableValue`](crate::model::VariableValue)
        pub fn build(self) -> crate::model::VariableValue {
            crate::model::VariableValue {
                raw_value: self.raw_value,
            }
        }
    }
}
impl VariableValue {
    /// Creates a new builder-style object to manufacture [`VariableValue`](crate::model::VariableValue)
    pub fn builder() -> crate::model::variable_value::Builder {
        crate::model::variable_value::Builder::default()
    }
}

/// <p> ResultSet contains the results of the request for a single block or list defined on the screen. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResultSet {
    /// <p> List of headers for all the data cells in the block. The header identifies the name and default format of the data cell. Data cells appear in the same order in all rows as defined in the header. The names and formats are not repeated in the rows. If a particular row does not have a value for a data cell, a blank value is used. </p>
    /// <p> For example, a task list that displays the task name, due date and assigned person might have headers [ { "name": "Task Name"}, {"name": "Due Date", "format": "DATE"}, {"name": "Assigned", "format": "CONTACT"} ]. Every row in the result will have the task name as the first item, due date as the second item and assigned person as the third item. If a particular task does not have a due date, that row will still have a blank value in the second element and the assigned person will still be in the third element. </p>
    pub headers: std::option::Option<std::vec::Vec<crate::model::ColumnMetadata>>,
    /// <p> List of rows returned by the request. Each row has a row Id and a list of data cells in that row. The data cells will be present in the same order as they are defined in the header. </p>
    pub rows: std::option::Option<std::vec::Vec<crate::model::ResultRow>>,
}
impl ResultSet {
    /// <p> List of headers for all the data cells in the block. The header identifies the name and default format of the data cell. Data cells appear in the same order in all rows as defined in the header. The names and formats are not repeated in the rows. If a particular row does not have a value for a data cell, a blank value is used. </p>
    /// <p> For example, a task list that displays the task name, due date and assigned person might have headers [ { "name": "Task Name"}, {"name": "Due Date", "format": "DATE"}, {"name": "Assigned", "format": "CONTACT"} ]. Every row in the result will have the task name as the first item, due date as the second item and assigned person as the third item. If a particular task does not have a due date, that row will still have a blank value in the second element and the assigned person will still be in the third element. </p>
    pub fn headers(&self) -> std::option::Option<&[crate::model::ColumnMetadata]> {
        self.headers.as_deref()
    }
    /// <p> List of rows returned by the request. Each row has a row Id and a list of data cells in that row. The data cells will be present in the same order as they are defined in the header. </p>
    pub fn rows(&self) -> std::option::Option<&[crate::model::ResultRow]> {
        self.rows.as_deref()
    }
}
impl std::fmt::Debug for ResultSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResultSet");
        formatter.field("headers", &self.headers);
        formatter.field("rows", &self.rows);
        formatter.finish()
    }
}
/// See [`ResultSet`](crate::model::ResultSet)
pub mod result_set {
    /// A builder for [`ResultSet`](crate::model::ResultSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) headers: std::option::Option<std::vec::Vec<crate::model::ColumnMetadata>>,
        pub(crate) rows: std::option::Option<std::vec::Vec<crate::model::ResultRow>>,
    }
    impl Builder {
        /// Appends an item to `headers`.
        ///
        /// To override the contents of this collection use [`set_headers`](Self::set_headers).
        ///
        /// <p> List of headers for all the data cells in the block. The header identifies the name and default format of the data cell. Data cells appear in the same order in all rows as defined in the header. The names and formats are not repeated in the rows. If a particular row does not have a value for a data cell, a blank value is used. </p>
        /// <p> For example, a task list that displays the task name, due date and assigned person might have headers [ { "name": "Task Name"}, {"name": "Due Date", "format": "DATE"}, {"name": "Assigned", "format": "CONTACT"} ]. Every row in the result will have the task name as the first item, due date as the second item and assigned person as the third item. If a particular task does not have a due date, that row will still have a blank value in the second element and the assigned person will still be in the third element. </p>
        pub fn headers(mut self, input: crate::model::ColumnMetadata) -> Self {
            let mut v = self.headers.unwrap_or_default();
            v.push(input);
            self.headers = Some(v);
            self
        }
        /// <p> List of headers for all the data cells in the block. The header identifies the name and default format of the data cell. Data cells appear in the same order in all rows as defined in the header. The names and formats are not repeated in the rows. If a particular row does not have a value for a data cell, a blank value is used. </p>
        /// <p> For example, a task list that displays the task name, due date and assigned person might have headers [ { "name": "Task Name"}, {"name": "Due Date", "format": "DATE"}, {"name": "Assigned", "format": "CONTACT"} ]. Every row in the result will have the task name as the first item, due date as the second item and assigned person as the third item. If a particular task does not have a due date, that row will still have a blank value in the second element and the assigned person will still be in the third element. </p>
        pub fn set_headers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnMetadata>>,
        ) -> Self {
            self.headers = input;
            self
        }
        /// Appends an item to `rows`.
        ///
        /// To override the contents of this collection use [`set_rows`](Self::set_rows).
        ///
        /// <p> List of rows returned by the request. Each row has a row Id and a list of data cells in that row. The data cells will be present in the same order as they are defined in the header. </p>
        pub fn rows(mut self, input: crate::model::ResultRow) -> Self {
            let mut v = self.rows.unwrap_or_default();
            v.push(input);
            self.rows = Some(v);
            self
        }
        /// <p> List of rows returned by the request. Each row has a row Id and a list of data cells in that row. The data cells will be present in the same order as they are defined in the header. </p>
        pub fn set_rows(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResultRow>>,
        ) -> Self {
            self.rows = input;
            self
        }
        /// Consumes the builder and constructs a [`ResultSet`](crate::model::ResultSet)
        pub fn build(self) -> crate::model::ResultSet {
            crate::model::ResultSet {
                headers: self.headers,
                rows: self.rows,
            }
        }
    }
}
impl ResultSet {
    /// Creates a new builder-style object to manufacture [`ResultSet`](crate::model::ResultSet)
    pub fn builder() -> crate::model::result_set::Builder {
        crate::model::result_set::Builder::default()
    }
}

/// <p>A single row in the ResultSet.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResultRow {
    /// <p>The ID for a particular row.</p>
    pub row_id: std::option::Option<std::string::String>,
    /// <p>List of all the data cells in a row.</p>
    pub data_items: std::option::Option<std::vec::Vec<crate::model::DataItem>>,
}
impl ResultRow {
    /// <p>The ID for a particular row.</p>
    pub fn row_id(&self) -> std::option::Option<&str> {
        self.row_id.as_deref()
    }
    /// <p>List of all the data cells in a row.</p>
    pub fn data_items(&self) -> std::option::Option<&[crate::model::DataItem]> {
        self.data_items.as_deref()
    }
}
impl std::fmt::Debug for ResultRow {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResultRow");
        formatter.field("row_id", &self.row_id);
        formatter.field("data_items", &self.data_items);
        formatter.finish()
    }
}
/// See [`ResultRow`](crate::model::ResultRow)
pub mod result_row {
    /// A builder for [`ResultRow`](crate::model::ResultRow)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) row_id: std::option::Option<std::string::String>,
        pub(crate) data_items: std::option::Option<std::vec::Vec<crate::model::DataItem>>,
    }
    impl Builder {
        /// <p>The ID for a particular row.</p>
        pub fn row_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.row_id = Some(input.into());
            self
        }
        /// <p>The ID for a particular row.</p>
        pub fn set_row_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.row_id = input;
            self
        }
        /// Appends an item to `data_items`.
        ///
        /// To override the contents of this collection use [`set_data_items`](Self::set_data_items).
        ///
        /// <p>List of all the data cells in a row.</p>
        pub fn data_items(mut self, input: crate::model::DataItem) -> Self {
            let mut v = self.data_items.unwrap_or_default();
            v.push(input);
            self.data_items = Some(v);
            self
        }
        /// <p>List of all the data cells in a row.</p>
        pub fn set_data_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataItem>>,
        ) -> Self {
            self.data_items = input;
            self
        }
        /// Consumes the builder and constructs a [`ResultRow`](crate::model::ResultRow)
        pub fn build(self) -> crate::model::ResultRow {
            crate::model::ResultRow {
                row_id: self.row_id,
                data_items: self.data_items,
            }
        }
    }
}
impl ResultRow {
    /// Creates a new builder-style object to manufacture [`ResultRow`](crate::model::ResultRow)
    pub fn builder() -> crate::model::result_row::Builder {
        crate::model::result_row::Builder::default()
    }
}

/// <p>The data in a particular data cell defined on the screen.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataItem {
    /// <p> The overrideFormat is optional and is specified only if a particular row of data has a different format for the data than the default format defined on the screen or the table. </p>
    pub override_format: std::option::Option<crate::model::Format>,
    /// <p>The raw value of the data. e.g. jsmith@example.com</p>
    pub raw_value: std::option::Option<std::string::String>,
    /// <p>The formatted value of the data. e.g. John Smith.</p>
    pub formatted_value: std::option::Option<std::string::String>,
}
impl DataItem {
    /// <p> The overrideFormat is optional and is specified only if a particular row of data has a different format for the data than the default format defined on the screen or the table. </p>
    pub fn override_format(&self) -> std::option::Option<&crate::model::Format> {
        self.override_format.as_ref()
    }
    /// <p>The raw value of the data. e.g. jsmith@example.com</p>
    pub fn raw_value(&self) -> std::option::Option<&str> {
        self.raw_value.as_deref()
    }
    /// <p>The formatted value of the data. e.g. John Smith.</p>
    pub fn formatted_value(&self) -> std::option::Option<&str> {
        self.formatted_value.as_deref()
    }
}
impl std::fmt::Debug for DataItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataItem");
        formatter.field("override_format", &self.override_format);
        formatter.field("raw_value", &self.raw_value);
        formatter.field("formatted_value", &self.formatted_value);
        formatter.finish()
    }
}
/// See [`DataItem`](crate::model::DataItem)
pub mod data_item {
    /// A builder for [`DataItem`](crate::model::DataItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) override_format: std::option::Option<crate::model::Format>,
        pub(crate) raw_value: std::option::Option<std::string::String>,
        pub(crate) formatted_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The overrideFormat is optional and is specified only if a particular row of data has a different format for the data than the default format defined on the screen or the table. </p>
        pub fn override_format(mut self, input: crate::model::Format) -> Self {
            self.override_format = Some(input);
            self
        }
        /// <p> The overrideFormat is optional and is specified only if a particular row of data has a different format for the data than the default format defined on the screen or the table. </p>
        pub fn set_override_format(
            mut self,
            input: std::option::Option<crate::model::Format>,
        ) -> Self {
            self.override_format = input;
            self
        }
        /// <p>The raw value of the data. e.g. jsmith@example.com</p>
        pub fn raw_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.raw_value = Some(input.into());
            self
        }
        /// <p>The raw value of the data. e.g. jsmith@example.com</p>
        pub fn set_raw_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.raw_value = input;
            self
        }
        /// <p>The formatted value of the data. e.g. John Smith.</p>
        pub fn formatted_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.formatted_value = Some(input.into());
            self
        }
        /// <p>The formatted value of the data. e.g. John Smith.</p>
        pub fn set_formatted_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.formatted_value = input;
            self
        }
        /// Consumes the builder and constructs a [`DataItem`](crate::model::DataItem)
        pub fn build(self) -> crate::model::DataItem {
            crate::model::DataItem {
                override_format: self.override_format,
                raw_value: self.raw_value,
                formatted_value: self.formatted_value,
            }
        }
    }
}
impl DataItem {
    /// Creates a new builder-style object to manufacture [`DataItem`](crate::model::DataItem)
    pub fn builder() -> crate::model::data_item::Builder {
        crate::model::data_item::Builder::default()
    }
}

/// <p>Metadata for column in the table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ColumnMetadata {
    /// <p>The name of the column.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The format of the column.</p>
    pub format: std::option::Option<crate::model::Format>,
}
impl ColumnMetadata {
    /// <p>The name of the column.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The format of the column.</p>
    pub fn format(&self) -> std::option::Option<&crate::model::Format> {
        self.format.as_ref()
    }
}
impl std::fmt::Debug for ColumnMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ColumnMetadata");
        formatter.field("name", &"*** Sensitive Data Redacted ***");
        formatter.field("format", &self.format);
        formatter.finish()
    }
}
/// See [`ColumnMetadata`](crate::model::ColumnMetadata)
pub mod column_metadata {
    /// A builder for [`ColumnMetadata`](crate::model::ColumnMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::Format>,
    }
    impl Builder {
        /// <p>The name of the column.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the column.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The format of the column.</p>
        pub fn format(mut self, input: crate::model::Format) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>The format of the column.</p>
        pub fn set_format(mut self, input: std::option::Option<crate::model::Format>) -> Self {
            self.format = input;
            self
        }
        /// Consumes the builder and constructs a [`ColumnMetadata`](crate::model::ColumnMetadata)
        pub fn build(self) -> crate::model::ColumnMetadata {
            crate::model::ColumnMetadata {
                name: self.name,
                format: self.format,
            }
        }
    }
}
impl ColumnMetadata {
    /// Creates a new builder-style object to manufacture [`ColumnMetadata`](crate::model::ColumnMetadata)
    pub fn builder() -> crate::model::column_metadata::Builder {
        crate::model::column_metadata::Builder::default()
    }
}

/// <p>The metadata associated with the table data import job that was submitted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TableDataImportJobMetadata {
    /// <p>Details about the submitter of the import request.</p>
    pub submitter: std::option::Option<crate::model::ImportJobSubmitter>,
    /// <p>The timestamp when the job was submitted for import.</p>
    pub submit_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The options that was specified at the time of submitting the import request.</p>
    pub import_options: std::option::Option<crate::model::ImportOptions>,
    /// <p>The source of the data that was submitted for import.</p>
    pub data_source: std::option::Option<crate::model::ImportDataSource>,
}
impl TableDataImportJobMetadata {
    /// <p>Details about the submitter of the import request.</p>
    pub fn submitter(&self) -> std::option::Option<&crate::model::ImportJobSubmitter> {
        self.submitter.as_ref()
    }
    /// <p>The timestamp when the job was submitted for import.</p>
    pub fn submit_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.submit_time.as_ref()
    }
    /// <p>The options that was specified at the time of submitting the import request.</p>
    pub fn import_options(&self) -> std::option::Option<&crate::model::ImportOptions> {
        self.import_options.as_ref()
    }
    /// <p>The source of the data that was submitted for import.</p>
    pub fn data_source(&self) -> std::option::Option<&crate::model::ImportDataSource> {
        self.data_source.as_ref()
    }
}
impl std::fmt::Debug for TableDataImportJobMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TableDataImportJobMetadata");
        formatter.field("submitter", &self.submitter);
        formatter.field("submit_time", &self.submit_time);
        formatter.field("import_options", &self.import_options);
        formatter.field("data_source", &self.data_source);
        formatter.finish()
    }
}
/// See [`TableDataImportJobMetadata`](crate::model::TableDataImportJobMetadata)
pub mod table_data_import_job_metadata {
    /// A builder for [`TableDataImportJobMetadata`](crate::model::TableDataImportJobMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) submitter: std::option::Option<crate::model::ImportJobSubmitter>,
        pub(crate) submit_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) import_options: std::option::Option<crate::model::ImportOptions>,
        pub(crate) data_source: std::option::Option<crate::model::ImportDataSource>,
    }
    impl Builder {
        /// <p>Details about the submitter of the import request.</p>
        pub fn submitter(mut self, input: crate::model::ImportJobSubmitter) -> Self {
            self.submitter = Some(input);
            self
        }
        /// <p>Details about the submitter of the import request.</p>
        pub fn set_submitter(
            mut self,
            input: std::option::Option<crate::model::ImportJobSubmitter>,
        ) -> Self {
            self.submitter = input;
            self
        }
        /// <p>The timestamp when the job was submitted for import.</p>
        pub fn submit_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.submit_time = Some(input);
            self
        }
        /// <p>The timestamp when the job was submitted for import.</p>
        pub fn set_submit_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.submit_time = input;
            self
        }
        /// <p>The options that was specified at the time of submitting the import request.</p>
        pub fn import_options(mut self, input: crate::model::ImportOptions) -> Self {
            self.import_options = Some(input);
            self
        }
        /// <p>The options that was specified at the time of submitting the import request.</p>
        pub fn set_import_options(
            mut self,
            input: std::option::Option<crate::model::ImportOptions>,
        ) -> Self {
            self.import_options = input;
            self
        }
        /// <p>The source of the data that was submitted for import.</p>
        pub fn data_source(mut self, input: crate::model::ImportDataSource) -> Self {
            self.data_source = Some(input);
            self
        }
        /// <p>The source of the data that was submitted for import.</p>
        pub fn set_data_source(
            mut self,
            input: std::option::Option<crate::model::ImportDataSource>,
        ) -> Self {
            self.data_source = input;
            self
        }
        /// Consumes the builder and constructs a [`TableDataImportJobMetadata`](crate::model::TableDataImportJobMetadata)
        pub fn build(self) -> crate::model::TableDataImportJobMetadata {
            crate::model::TableDataImportJobMetadata {
                submitter: self.submitter,
                submit_time: self.submit_time,
                import_options: self.import_options,
                data_source: self.data_source,
            }
        }
    }
}
impl TableDataImportJobMetadata {
    /// Creates a new builder-style object to manufacture [`TableDataImportJobMetadata`](crate::model::TableDataImportJobMetadata)
    pub fn builder() -> crate::model::table_data_import_job_metadata::Builder {
        crate::model::table_data_import_job_metadata::Builder::default()
    }
}

/// <p>An object that contains the attributes of the submitter of the import job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportJobSubmitter {
    /// <p>The email id of the submitter of the import job, if available.</p>
    pub email: std::option::Option<std::string::String>,
    /// <p>The AWS user ARN of the submitter of the import job, if available.</p>
    pub user_arn: std::option::Option<std::string::String>,
}
impl ImportJobSubmitter {
    /// <p>The email id of the submitter of the import job, if available.</p>
    pub fn email(&self) -> std::option::Option<&str> {
        self.email.as_deref()
    }
    /// <p>The AWS user ARN of the submitter of the import job, if available.</p>
    pub fn user_arn(&self) -> std::option::Option<&str> {
        self.user_arn.as_deref()
    }
}
impl std::fmt::Debug for ImportJobSubmitter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportJobSubmitter");
        formatter.field("email", &"*** Sensitive Data Redacted ***");
        formatter.field("user_arn", &self.user_arn);
        formatter.finish()
    }
}
/// See [`ImportJobSubmitter`](crate::model::ImportJobSubmitter)
pub mod import_job_submitter {
    /// A builder for [`ImportJobSubmitter`](crate::model::ImportJobSubmitter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) email: std::option::Option<std::string::String>,
        pub(crate) user_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The email id of the submitter of the import job, if available.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The email id of the submitter of the import job, if available.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// <p>The AWS user ARN of the submitter of the import job, if available.</p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_arn = Some(input.into());
            self
        }
        /// <p>The AWS user ARN of the submitter of the import job, if available.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportJobSubmitter`](crate::model::ImportJobSubmitter)
        pub fn build(self) -> crate::model::ImportJobSubmitter {
            crate::model::ImportJobSubmitter {
                email: self.email,
                user_arn: self.user_arn,
            }
        }
    }
}
impl ImportJobSubmitter {
    /// Creates a new builder-style object to manufacture [`ImportJobSubmitter`](crate::model::ImportJobSubmitter)
    pub fn builder() -> crate::model::import_job_submitter::Builder {
        crate::model::import_job_submitter::Builder::default()
    }
}

/// <p> A single item in a batch that failed to perform the intended action because of an error preventing it from succeeding. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailedBatchItem {
    /// <p> The id of the batch item that failed. This is the batch item id for the BatchCreateTableRows and BatchUpsertTableRows operations and the row id for the BatchUpdateTableRows and BatchDeleteTableRows operations. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p> The error message that indicates why the batch item failed. </p>
    pub error_message: std::option::Option<std::string::String>,
}
impl FailedBatchItem {
    /// <p> The id of the batch item that failed. This is the batch item id for the BatchCreateTableRows and BatchUpsertTableRows operations and the row id for the BatchUpdateTableRows and BatchDeleteTableRows operations. </p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p> The error message that indicates why the batch item failed. </p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for FailedBatchItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailedBatchItem");
        formatter.field("id", &self.id);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`FailedBatchItem`](crate::model::FailedBatchItem)
pub mod failed_batch_item {
    /// A builder for [`FailedBatchItem`](crate::model::FailedBatchItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The id of the batch item that failed. This is the batch item id for the BatchCreateTableRows and BatchUpsertTableRows operations and the row id for the BatchUpdateTableRows and BatchDeleteTableRows operations. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The id of the batch item that failed. This is the batch item id for the BatchCreateTableRows and BatchUpsertTableRows operations and the row id for the BatchUpdateTableRows and BatchDeleteTableRows operations. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p> The error message that indicates why the batch item failed. </p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p> The error message that indicates why the batch item failed. </p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`FailedBatchItem`](crate::model::FailedBatchItem)
        pub fn build(self) -> crate::model::FailedBatchItem {
            crate::model::FailedBatchItem {
                id: self.id,
                error_message: self.error_message,
            }
        }
    }
}
impl FailedBatchItem {
    /// Creates a new builder-style object to manufacture [`FailedBatchItem`](crate::model::FailedBatchItem)
    pub fn builder() -> crate::model::failed_batch_item::Builder {
        crate::model::failed_batch_item::Builder::default()
    }
}

/// <p> An object that represents the result of a single upsert row request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpsertRowsResult {
    /// <p> The list of row ids that were changed as part of an upsert row operation. If the upsert resulted in an update, this list could potentially contain multiple rows that matched the filter and hence got updated. If the upsert resulted in an append, this list would only have the single row that was appended. </p>
    pub row_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> The result of the upsert action. </p>
    pub upsert_action: std::option::Option<crate::model::UpsertAction>,
}
impl UpsertRowsResult {
    /// <p> The list of row ids that were changed as part of an upsert row operation. If the upsert resulted in an update, this list could potentially contain multiple rows that matched the filter and hence got updated. If the upsert resulted in an append, this list would only have the single row that was appended. </p>
    pub fn row_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.row_ids.as_deref()
    }
    /// <p> The result of the upsert action. </p>
    pub fn upsert_action(&self) -> std::option::Option<&crate::model::UpsertAction> {
        self.upsert_action.as_ref()
    }
}
impl std::fmt::Debug for UpsertRowsResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpsertRowsResult");
        formatter.field("row_ids", &self.row_ids);
        formatter.field("upsert_action", &self.upsert_action);
        formatter.finish()
    }
}
/// See [`UpsertRowsResult`](crate::model::UpsertRowsResult)
pub mod upsert_rows_result {
    /// A builder for [`UpsertRowsResult`](crate::model::UpsertRowsResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) row_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) upsert_action: std::option::Option<crate::model::UpsertAction>,
    }
    impl Builder {
        /// Appends an item to `row_ids`.
        ///
        /// To override the contents of this collection use [`set_row_ids`](Self::set_row_ids).
        ///
        /// <p> The list of row ids that were changed as part of an upsert row operation. If the upsert resulted in an update, this list could potentially contain multiple rows that matched the filter and hence got updated. If the upsert resulted in an append, this list would only have the single row that was appended. </p>
        pub fn row_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.row_ids.unwrap_or_default();
            v.push(input.into());
            self.row_ids = Some(v);
            self
        }
        /// <p> The list of row ids that were changed as part of an upsert row operation. If the upsert resulted in an update, this list could potentially contain multiple rows that matched the filter and hence got updated. If the upsert resulted in an append, this list would only have the single row that was appended. </p>
        pub fn set_row_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.row_ids = input;
            self
        }
        /// <p> The result of the upsert action. </p>
        pub fn upsert_action(mut self, input: crate::model::UpsertAction) -> Self {
            self.upsert_action = Some(input);
            self
        }
        /// <p> The result of the upsert action. </p>
        pub fn set_upsert_action(
            mut self,
            input: std::option::Option<crate::model::UpsertAction>,
        ) -> Self {
            self.upsert_action = input;
            self
        }
        /// Consumes the builder and constructs a [`UpsertRowsResult`](crate::model::UpsertRowsResult)
        pub fn build(self) -> crate::model::UpsertRowsResult {
            crate::model::UpsertRowsResult {
                row_ids: self.row_ids,
                upsert_action: self.upsert_action,
            }
        }
    }
}
impl UpsertRowsResult {
    /// Creates a new builder-style object to manufacture [`UpsertRowsResult`](crate::model::UpsertRowsResult)
    pub fn builder() -> crate::model::upsert_rows_result::Builder {
        crate::model::upsert_rows_result::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UpsertAction {
    #[allow(missing_docs)] // documentation missing in model
    Appended,
    #[allow(missing_docs)] // documentation missing in model
    Updated,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UpsertAction {
    fn from(s: &str) -> Self {
        match s {
            "APPENDED" => UpsertAction::Appended,
            "UPDATED" => UpsertAction::Updated,
            other => UpsertAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UpsertAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UpsertAction::from(s))
    }
}
impl UpsertAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UpsertAction::Appended => "APPENDED",
            UpsertAction::Updated => "UPDATED",
            UpsertAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["APPENDED", "UPDATED"]
    }
}
impl AsRef<str> for UpsertAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Data needed to upsert rows in a table as part of a single item in the BatchUpsertTableRows request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpsertRowData {
    /// <p> An external identifier that represents a single item in the request that is being upserted as part of the BatchUpsertTableRows request. This can be any string that you can use to identify the item in the request. The BatchUpsertTableRows API puts the batch item id in the results to allow you to link data in the request to data in the results. </p>
    pub batch_item_id: std::option::Option<std::string::String>,
    /// <p> The filter formula to use to find existing matching rows to update. The formula needs to return zero or more rows. If the formula returns 0 rows, then a new row will be appended in the target table. If the formula returns one or more rows, then the returned rows will be updated. </p>
    /// <p> Note that the filter formula needs to return rows from the target table for the upsert operation to succeed. If the filter formula has a syntax error or it doesn't evaluate to zero or more rows in the target table for any one item in the input list, then the entire BatchUpsertTableRows request fails and no updates are made to the table. </p>
    pub filter: std::option::Option<crate::model::Filter>,
    /// <p> A map representing the cells to update for the matching rows or an appended row. The key is the column id of the cell and the value is the CellInput object that represents the data to set in that cell. </p>
    pub cells_to_update: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::CellInput>,
    >,
}
impl UpsertRowData {
    /// <p> An external identifier that represents a single item in the request that is being upserted as part of the BatchUpsertTableRows request. This can be any string that you can use to identify the item in the request. The BatchUpsertTableRows API puts the batch item id in the results to allow you to link data in the request to data in the results. </p>
    pub fn batch_item_id(&self) -> std::option::Option<&str> {
        self.batch_item_id.as_deref()
    }
    /// <p> The filter formula to use to find existing matching rows to update. The formula needs to return zero or more rows. If the formula returns 0 rows, then a new row will be appended in the target table. If the formula returns one or more rows, then the returned rows will be updated. </p>
    /// <p> Note that the filter formula needs to return rows from the target table for the upsert operation to succeed. If the filter formula has a syntax error or it doesn't evaluate to zero or more rows in the target table for any one item in the input list, then the entire BatchUpsertTableRows request fails and no updates are made to the table. </p>
    pub fn filter(&self) -> std::option::Option<&crate::model::Filter> {
        self.filter.as_ref()
    }
    /// <p> A map representing the cells to update for the matching rows or an appended row. The key is the column id of the cell and the value is the CellInput object that represents the data to set in that cell. </p>
    pub fn cells_to_update(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, crate::model::CellInput>>
    {
        self.cells_to_update.as_ref()
    }
}
impl std::fmt::Debug for UpsertRowData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpsertRowData");
        formatter.field("batch_item_id", &self.batch_item_id);
        formatter.field("filter", &self.filter);
        formatter.field("cells_to_update", &self.cells_to_update);
        formatter.finish()
    }
}
/// See [`UpsertRowData`](crate::model::UpsertRowData)
pub mod upsert_row_data {
    /// A builder for [`UpsertRowData`](crate::model::UpsertRowData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) batch_item_id: std::option::Option<std::string::String>,
        pub(crate) filter: std::option::Option<crate::model::Filter>,
        pub(crate) cells_to_update: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::CellInput>,
        >,
    }
    impl Builder {
        /// <p> An external identifier that represents a single item in the request that is being upserted as part of the BatchUpsertTableRows request. This can be any string that you can use to identify the item in the request. The BatchUpsertTableRows API puts the batch item id in the results to allow you to link data in the request to data in the results. </p>
        pub fn batch_item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.batch_item_id = Some(input.into());
            self
        }
        /// <p> An external identifier that represents a single item in the request that is being upserted as part of the BatchUpsertTableRows request. This can be any string that you can use to identify the item in the request. The BatchUpsertTableRows API puts the batch item id in the results to allow you to link data in the request to data in the results. </p>
        pub fn set_batch_item_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.batch_item_id = input;
            self
        }
        /// <p> The filter formula to use to find existing matching rows to update. The formula needs to return zero or more rows. If the formula returns 0 rows, then a new row will be appended in the target table. If the formula returns one or more rows, then the returned rows will be updated. </p>
        /// <p> Note that the filter formula needs to return rows from the target table for the upsert operation to succeed. If the filter formula has a syntax error or it doesn't evaluate to zero or more rows in the target table for any one item in the input list, then the entire BatchUpsertTableRows request fails and no updates are made to the table. </p>
        pub fn filter(mut self, input: crate::model::Filter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p> The filter formula to use to find existing matching rows to update. The formula needs to return zero or more rows. If the formula returns 0 rows, then a new row will be appended in the target table. If the formula returns one or more rows, then the returned rows will be updated. </p>
        /// <p> Note that the filter formula needs to return rows from the target table for the upsert operation to succeed. If the filter formula has a syntax error or it doesn't evaluate to zero or more rows in the target table for any one item in the input list, then the entire BatchUpsertTableRows request fails and no updates are made to the table. </p>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Filter>) -> Self {
            self.filter = input;
            self
        }
        /// Adds a key-value pair to `cells_to_update`.
        ///
        /// To override the contents of this collection use [`set_cells_to_update`](Self::set_cells_to_update).
        ///
        /// <p> A map representing the cells to update for the matching rows or an appended row. The key is the column id of the cell and the value is the CellInput object that represents the data to set in that cell. </p>
        pub fn cells_to_update(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::CellInput,
        ) -> Self {
            let mut hash_map = self.cells_to_update.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.cells_to_update = Some(hash_map);
            self
        }
        /// <p> A map representing the cells to update for the matching rows or an appended row. The key is the column id of the cell and the value is the CellInput object that represents the data to set in that cell. </p>
        pub fn set_cells_to_update(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::CellInput>,
            >,
        ) -> Self {
            self.cells_to_update = input;
            self
        }
        /// Consumes the builder and constructs a [`UpsertRowData`](crate::model::UpsertRowData)
        pub fn build(self) -> crate::model::UpsertRowData {
            crate::model::UpsertRowData {
                batch_item_id: self.batch_item_id,
                filter: self.filter,
                cells_to_update: self.cells_to_update,
            }
        }
    }
}
impl UpsertRowData {
    /// Creates a new builder-style object to manufacture [`UpsertRowData`](crate::model::UpsertRowData)
    pub fn builder() -> crate::model::upsert_row_data::Builder {
        crate::model::upsert_row_data::Builder::default()
    }
}

/// <p> CellInput object contains the data needed to create or update cells in a table. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CellInput {
    /// <p> Fact represents the data that is entered into a cell. This data can be free text or a formula. Formulas need to start with the equals (=) sign. </p>
    pub fact: std::option::Option<std::string::String>,
}
impl CellInput {
    /// <p> Fact represents the data that is entered into a cell. This data can be free text or a formula. Formulas need to start with the equals (=) sign. </p>
    pub fn fact(&self) -> std::option::Option<&str> {
        self.fact.as_deref()
    }
}
impl std::fmt::Debug for CellInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CellInput");
        formatter.field("fact", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`CellInput`](crate::model::CellInput)
pub mod cell_input {
    /// A builder for [`CellInput`](crate::model::CellInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fact: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> Fact represents the data that is entered into a cell. This data can be free text or a formula. Formulas need to start with the equals (=) sign. </p>
        pub fn fact(mut self, input: impl Into<std::string::String>) -> Self {
            self.fact = Some(input.into());
            self
        }
        /// <p> Fact represents the data that is entered into a cell. This data can be free text or a formula. Formulas need to start with the equals (=) sign. </p>
        pub fn set_fact(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fact = input;
            self
        }
        /// Consumes the builder and constructs a [`CellInput`](crate::model::CellInput)
        pub fn build(self) -> crate::model::CellInput {
            crate::model::CellInput { fact: self.fact }
        }
    }
}
impl CellInput {
    /// Creates a new builder-style object to manufacture [`CellInput`](crate::model::CellInput)
    pub fn builder() -> crate::model::cell_input::Builder {
        crate::model::cell_input::Builder::default()
    }
}

/// <p> Data needed to create a single row in a table as part of the BatchCreateTableRows request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRowData {
    /// <p> The id of the row that needs to be updated. </p>
    pub row_id: std::option::Option<std::string::String>,
    /// <p> A map representing the cells to update in the given row. The key is the column id of the cell and the value is the CellInput object that represents the data to set in that cell. </p>
    pub cells_to_update: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::CellInput>,
    >,
}
impl UpdateRowData {
    /// <p> The id of the row that needs to be updated. </p>
    pub fn row_id(&self) -> std::option::Option<&str> {
        self.row_id.as_deref()
    }
    /// <p> A map representing the cells to update in the given row. The key is the column id of the cell and the value is the CellInput object that represents the data to set in that cell. </p>
    pub fn cells_to_update(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, crate::model::CellInput>>
    {
        self.cells_to_update.as_ref()
    }
}
impl std::fmt::Debug for UpdateRowData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRowData");
        formatter.field("row_id", &self.row_id);
        formatter.field("cells_to_update", &self.cells_to_update);
        formatter.finish()
    }
}
/// See [`UpdateRowData`](crate::model::UpdateRowData)
pub mod update_row_data {
    /// A builder for [`UpdateRowData`](crate::model::UpdateRowData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) row_id: std::option::Option<std::string::String>,
        pub(crate) cells_to_update: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::CellInput>,
        >,
    }
    impl Builder {
        /// <p> The id of the row that needs to be updated. </p>
        pub fn row_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.row_id = Some(input.into());
            self
        }
        /// <p> The id of the row that needs to be updated. </p>
        pub fn set_row_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.row_id = input;
            self
        }
        /// Adds a key-value pair to `cells_to_update`.
        ///
        /// To override the contents of this collection use [`set_cells_to_update`](Self::set_cells_to_update).
        ///
        /// <p> A map representing the cells to update in the given row. The key is the column id of the cell and the value is the CellInput object that represents the data to set in that cell. </p>
        pub fn cells_to_update(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::CellInput,
        ) -> Self {
            let mut hash_map = self.cells_to_update.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.cells_to_update = Some(hash_map);
            self
        }
        /// <p> A map representing the cells to update in the given row. The key is the column id of the cell and the value is the CellInput object that represents the data to set in that cell. </p>
        pub fn set_cells_to_update(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::CellInput>,
            >,
        ) -> Self {
            self.cells_to_update = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRowData`](crate::model::UpdateRowData)
        pub fn build(self) -> crate::model::UpdateRowData {
            crate::model::UpdateRowData {
                row_id: self.row_id,
                cells_to_update: self.cells_to_update,
            }
        }
    }
}
impl UpdateRowData {
    /// Creates a new builder-style object to manufacture [`UpdateRowData`](crate::model::UpdateRowData)
    pub fn builder() -> crate::model::update_row_data::Builder {
        crate::model::update_row_data::Builder::default()
    }
}

/// <p> Data needed to create a single row in a table as part of the BatchCreateTableRows request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRowData {
    /// <p> An external identifier that represents the single row that is being created as part of the BatchCreateTableRows request. This can be any string that you can use to identify the row in the request. The BatchCreateTableRows API puts the batch item id in the results to allow you to link data in the request to data in the results. </p>
    pub batch_item_id: std::option::Option<std::string::String>,
    /// <p> A map representing the cells to create in the new row. The key is the column id of the cell and the value is the CellInput object that represents the data to set in that cell. </p>
    pub cells_to_create: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::CellInput>,
    >,
}
impl CreateRowData {
    /// <p> An external identifier that represents the single row that is being created as part of the BatchCreateTableRows request. This can be any string that you can use to identify the row in the request. The BatchCreateTableRows API puts the batch item id in the results to allow you to link data in the request to data in the results. </p>
    pub fn batch_item_id(&self) -> std::option::Option<&str> {
        self.batch_item_id.as_deref()
    }
    /// <p> A map representing the cells to create in the new row. The key is the column id of the cell and the value is the CellInput object that represents the data to set in that cell. </p>
    pub fn cells_to_create(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, crate::model::CellInput>>
    {
        self.cells_to_create.as_ref()
    }
}
impl std::fmt::Debug for CreateRowData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRowData");
        formatter.field("batch_item_id", &self.batch_item_id);
        formatter.field("cells_to_create", &self.cells_to_create);
        formatter.finish()
    }
}
/// See [`CreateRowData`](crate::model::CreateRowData)
pub mod create_row_data {
    /// A builder for [`CreateRowData`](crate::model::CreateRowData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) batch_item_id: std::option::Option<std::string::String>,
        pub(crate) cells_to_create: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::CellInput>,
        >,
    }
    impl Builder {
        /// <p> An external identifier that represents the single row that is being created as part of the BatchCreateTableRows request. This can be any string that you can use to identify the row in the request. The BatchCreateTableRows API puts the batch item id in the results to allow you to link data in the request to data in the results. </p>
        pub fn batch_item_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.batch_item_id = Some(input.into());
            self
        }
        /// <p> An external identifier that represents the single row that is being created as part of the BatchCreateTableRows request. This can be any string that you can use to identify the row in the request. The BatchCreateTableRows API puts the batch item id in the results to allow you to link data in the request to data in the results. </p>
        pub fn set_batch_item_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.batch_item_id = input;
            self
        }
        /// Adds a key-value pair to `cells_to_create`.
        ///
        /// To override the contents of this collection use [`set_cells_to_create`](Self::set_cells_to_create).
        ///
        /// <p> A map representing the cells to create in the new row. The key is the column id of the cell and the value is the CellInput object that represents the data to set in that cell. </p>
        pub fn cells_to_create(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::CellInput,
        ) -> Self {
            let mut hash_map = self.cells_to_create.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.cells_to_create = Some(hash_map);
            self
        }
        /// <p> A map representing the cells to create in the new row. The key is the column id of the cell and the value is the CellInput object that represents the data to set in that cell. </p>
        pub fn set_cells_to_create(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::CellInput>,
            >,
        ) -> Self {
            self.cells_to_create = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRowData`](crate::model::CreateRowData)
        pub fn build(self) -> crate::model::CreateRowData {
            crate::model::CreateRowData {
                batch_item_id: self.batch_item_id,
                cells_to_create: self.cells_to_create,
            }
        }
    }
}
impl CreateRowData {
    /// Creates a new builder-style object to manufacture [`CreateRowData`](crate::model::CreateRowData)
    pub fn builder() -> crate::model::create_row_data::Builder {
        crate::model::create_row_data::Builder::default()
    }
}
