// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for Amazon Honeycode
///
/// Client for invoking operations on Amazon Honeycode. Each operation on Amazon Honeycode is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_honeycode::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operationname>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_honeycode::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_honeycode::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `BatchCreateTableRows` operation.
    ///
    /// See [`BatchCreateTableRows`](crate::client::fluent_builders::BatchCreateTableRows) for more information about the
    /// operation and its arguments.
    pub fn batch_create_table_rows(&self) -> fluent_builders::BatchCreateTableRows<C, M, R> {
        fluent_builders::BatchCreateTableRows::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchDeleteTableRows` operation.
    ///
    /// See [`BatchDeleteTableRows`](crate::client::fluent_builders::BatchDeleteTableRows) for more information about the
    /// operation and its arguments.
    pub fn batch_delete_table_rows(&self) -> fluent_builders::BatchDeleteTableRows<C, M, R> {
        fluent_builders::BatchDeleteTableRows::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchUpdateTableRows` operation.
    ///
    /// See [`BatchUpdateTableRows`](crate::client::fluent_builders::BatchUpdateTableRows) for more information about the
    /// operation and its arguments.
    pub fn batch_update_table_rows(&self) -> fluent_builders::BatchUpdateTableRows<C, M, R> {
        fluent_builders::BatchUpdateTableRows::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchUpsertTableRows` operation.
    ///
    /// See [`BatchUpsertTableRows`](crate::client::fluent_builders::BatchUpsertTableRows) for more information about the
    /// operation and its arguments.
    pub fn batch_upsert_table_rows(&self) -> fluent_builders::BatchUpsertTableRows<C, M, R> {
        fluent_builders::BatchUpsertTableRows::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTableDataImportJob` operation.
    ///
    /// See [`DescribeTableDataImportJob`](crate::client::fluent_builders::DescribeTableDataImportJob) for more information about the
    /// operation and its arguments.
    pub fn describe_table_data_import_job(
        &self,
    ) -> fluent_builders::DescribeTableDataImportJob<C, M, R> {
        fluent_builders::DescribeTableDataImportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetScreenData` operation.
    ///
    /// See [`GetScreenData`](crate::client::fluent_builders::GetScreenData) for more information about the
    /// operation and its arguments.
    pub fn get_screen_data(&self) -> fluent_builders::GetScreenData<C, M, R> {
        fluent_builders::GetScreenData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `InvokeScreenAutomation` operation.
    ///
    /// See [`InvokeScreenAutomation`](crate::client::fluent_builders::InvokeScreenAutomation) for more information about the
    /// operation and its arguments.
    pub fn invoke_screen_automation(&self) -> fluent_builders::InvokeScreenAutomation<C, M, R> {
        fluent_builders::InvokeScreenAutomation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTableColumns` operation.
    ///
    /// See [`ListTableColumns`](crate::client::fluent_builders::ListTableColumns) for more information about the
    /// operation and its arguments.
    pub fn list_table_columns(&self) -> fluent_builders::ListTableColumns<C, M, R> {
        fluent_builders::ListTableColumns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTableRows` operation.
    ///
    /// See [`ListTableRows`](crate::client::fluent_builders::ListTableRows) for more information about the
    /// operation and its arguments.
    pub fn list_table_rows(&self) -> fluent_builders::ListTableRows<C, M, R> {
        fluent_builders::ListTableRows::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTables` operation.
    ///
    /// See [`ListTables`](crate::client::fluent_builders::ListTables) for more information about the
    /// operation and its arguments.
    pub fn list_tables(&self) -> fluent_builders::ListTables<C, M, R> {
        fluent_builders::ListTables::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `QueryTableRows` operation.
    ///
    /// See [`QueryTableRows`](crate::client::fluent_builders::QueryTableRows) for more information about the
    /// operation and its arguments.
    pub fn query_table_rows(&self) -> fluent_builders::QueryTableRows<C, M, R> {
        fluent_builders::QueryTableRows::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartTableDataImportJob` operation.
    ///
    /// See [`StartTableDataImportJob`](crate::client::fluent_builders::StartTableDataImportJob) for more information about the
    /// operation and its arguments.
    pub fn start_table_data_import_job(&self) -> fluent_builders::StartTableDataImportJob<C, M, R> {
        fluent_builders::StartTableDataImportJob::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchCreateTableRows`.
    ///
    /// <p>
    /// The BatchCreateTableRows API allows you to create one or more rows at the end of a table in a workbook.
    /// The API allows you to specify the values to set in some or all of the columns in the new rows.
    /// </p>
    /// <p>
    /// If a column is not explicitly set in a specific row, then the column level formula specified in the table
    /// will be applied to the new row. If there is no column level formula but the last row of the table has a
    /// formula, then that formula will be copied down to the new row. If there is no column level formula and
    /// no formula in the last row of the table, then that column will be left blank for the new rows.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct BatchCreateTableRows<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_create_table_rows_input::Builder,
    }
    impl<C, M, R> BatchCreateTableRows<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchCreateTableRows`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchCreateTableRowsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchCreateTableRowsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchCreateTableRowsInputOperationOutputAlias,
                crate::output::BatchCreateTableRowsOutput,
                crate::error::BatchCreateTableRowsError,
                crate::input::BatchCreateTableRowsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workbook where the new rows are being added.</p>
        /// <p>
        /// If a workbook with the specified ID could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn workbook_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workbook_id(inp);
            self
        }
        /// <p>The ID of the workbook where the new rows are being added.</p>
        /// <p>
        /// If a workbook with the specified ID could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn set_workbook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workbook_id(input);
            self
        }
        /// <p>The ID of the table where the new rows are being added.</p>
        /// <p>
        /// If a table with the specified ID could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn table_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_id(inp);
            self
        }
        /// <p>The ID of the table where the new rows are being added.</p>
        /// <p>
        /// If a table with the specified ID could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn set_table_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_id(input);
            self
        }
        /// Appends an item to `rowsToCreate`.
        ///
        /// To override the contents of this collection use [`set_rows_to_create`](Self::set_rows_to_create).
        ///
        /// <p>
        /// The list of rows to create at the end of the table. Each item in this list needs to have a batch item id
        /// to uniquely identify the element in the request and the cells to create for that row.
        /// You need to specify at least one item in this list.
        /// </p>
        /// <p>
        /// Note that if one of the column ids in any of the rows in the request does not exist in the table, then the
        /// request fails and no updates are made to the table.
        /// </p>
        pub fn rows_to_create(mut self, inp: impl Into<crate::model::CreateRowData>) -> Self {
            self.inner = self.inner.rows_to_create(inp);
            self
        }
        /// <p>
        /// The list of rows to create at the end of the table. Each item in this list needs to have a batch item id
        /// to uniquely identify the element in the request and the cells to create for that row.
        /// You need to specify at least one item in this list.
        /// </p>
        /// <p>
        /// Note that if one of the column ids in any of the rows in the request does not exist in the table, then the
        /// request fails and no updates are made to the table.
        /// </p>
        pub fn set_rows_to_create(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CreateRowData>>,
        ) -> Self {
            self.inner = self.inner.set_rows_to_create(input);
            self
        }
        /// <p>
        /// The request token for performing the batch create operation.
        /// Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error
        /// like a failed network connection, you can retry the call with the same request token. The service ensures
        /// that if the first call using that request token is successfully performed, the second call will not perform
        /// the operation again.
        /// </p>
        /// <p>
        /// Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests
        /// spanning hours or days.
        /// </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>
        /// The request token for performing the batch create operation.
        /// Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error
        /// like a failed network connection, you can retry the call with the same request token. The service ensures
        /// that if the first call using that request token is successfully performed, the second call will not perform
        /// the operation again.
        /// </p>
        /// <p>
        /// Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests
        /// spanning hours or days.
        /// </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDeleteTableRows`.
    ///
    /// <p>
    /// The BatchDeleteTableRows API allows you to delete one or more rows from a table in a workbook.
    /// You need to specify the ids of the rows that you want to delete from the table.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct BatchDeleteTableRows<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_delete_table_rows_input::Builder,
    }
    impl<C, M, R> BatchDeleteTableRows<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDeleteTableRows`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDeleteTableRowsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDeleteTableRowsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDeleteTableRowsInputOperationOutputAlias,
                crate::output::BatchDeleteTableRowsOutput,
                crate::error::BatchDeleteTableRowsError,
                crate::input::BatchDeleteTableRowsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workbook where the rows are being deleted.</p>
        /// <p>
        /// If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn workbook_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workbook_id(inp);
            self
        }
        /// <p>The ID of the workbook where the rows are being deleted.</p>
        /// <p>
        /// If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn set_workbook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workbook_id(input);
            self
        }
        /// <p>The ID of the table where the rows are being deleted.</p>
        /// <p>
        /// If a table with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn table_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_id(inp);
            self
        }
        /// <p>The ID of the table where the rows are being deleted.</p>
        /// <p>
        /// If a table with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn set_table_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_id(input);
            self
        }
        /// Appends an item to `rowIds`.
        ///
        /// To override the contents of this collection use [`set_row_ids`](Self::set_row_ids).
        ///
        /// <p>
        /// The list of row ids to delete from the table. You need to specify at least one row id in this list.
        /// </p>
        /// <p>
        /// Note that if one of the row ids provided in the request does not exist in the table, then the request fails
        /// and no rows are deleted from the table.
        /// </p>
        pub fn row_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.row_ids(inp);
            self
        }
        /// <p>
        /// The list of row ids to delete from the table. You need to specify at least one row id in this list.
        /// </p>
        /// <p>
        /// Note that if one of the row ids provided in the request does not exist in the table, then the request fails
        /// and no rows are deleted from the table.
        /// </p>
        pub fn set_row_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_row_ids(input);
            self
        }
        /// <p>
        /// The request token for performing the delete action.
        /// Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error
        /// like a failed network connection, you can retry the call with the same request token. The service ensures
        /// that if the first call using that request token is successfully performed, the second call will not perform
        /// the action again.
        /// </p>
        /// <p>
        /// Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests
        /// spanning hours or days.
        /// </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>
        /// The request token for performing the delete action.
        /// Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error
        /// like a failed network connection, you can retry the call with the same request token. The service ensures
        /// that if the first call using that request token is successfully performed, the second call will not perform
        /// the action again.
        /// </p>
        /// <p>
        /// Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests
        /// spanning hours or days.
        /// </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchUpdateTableRows`.
    ///
    /// <p>
    /// The BatchUpdateTableRows API allows you to update one or more rows in a table in a workbook.
    /// </p>
    /// <p>
    /// You can specify the values to set in some or all of the columns in the table for the specified
    /// rows.
    /// If a column is not explicitly specified in a particular row, then that column will not be updated
    /// for that row. To clear out the data in a specific cell, you need to set the value as an empty string
    /// ("").
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct BatchUpdateTableRows<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_update_table_rows_input::Builder,
    }
    impl<C, M, R> BatchUpdateTableRows<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchUpdateTableRows`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchUpdateTableRowsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchUpdateTableRowsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchUpdateTableRowsInputOperationOutputAlias,
                crate::output::BatchUpdateTableRowsOutput,
                crate::error::BatchUpdateTableRowsError,
                crate::input::BatchUpdateTableRowsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workbook where the rows are being updated.</p>
        /// <p>
        /// If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn workbook_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workbook_id(inp);
            self
        }
        /// <p>The ID of the workbook where the rows are being updated.</p>
        /// <p>
        /// If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn set_workbook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workbook_id(input);
            self
        }
        /// <p>The ID of the table where the rows are being updated.</p>
        /// <p>
        /// If a table with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn table_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_id(inp);
            self
        }
        /// <p>The ID of the table where the rows are being updated.</p>
        /// <p>
        /// If a table with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn set_table_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_id(input);
            self
        }
        /// Appends an item to `rowsToUpdate`.
        ///
        /// To override the contents of this collection use [`set_rows_to_update`](Self::set_rows_to_update).
        ///
        /// <p>
        /// The list of rows to update in the table. Each item in this list needs to contain the row id to update
        /// along with the map of column id to cell values for each column in that row that needs to be updated.
        /// You need to specify at least one row in this list, and for each row, you need to specify at least one
        /// column to update.
        /// </p>
        /// <p>
        /// Note that if one of the row or column ids in the request does not exist in the table, then the request fails
        /// and no updates are made to the table.
        /// </p>
        pub fn rows_to_update(mut self, inp: impl Into<crate::model::UpdateRowData>) -> Self {
            self.inner = self.inner.rows_to_update(inp);
            self
        }
        /// <p>
        /// The list of rows to update in the table. Each item in this list needs to contain the row id to update
        /// along with the map of column id to cell values for each column in that row that needs to be updated.
        /// You need to specify at least one row in this list, and for each row, you need to specify at least one
        /// column to update.
        /// </p>
        /// <p>
        /// Note that if one of the row or column ids in the request does not exist in the table, then the request fails
        /// and no updates are made to the table.
        /// </p>
        pub fn set_rows_to_update(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpdateRowData>>,
        ) -> Self {
            self.inner = self.inner.set_rows_to_update(input);
            self
        }
        /// <p>
        /// The request token for performing the update action.
        /// Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error
        /// like a failed network connection, you can retry the call with the same request token. The service ensures
        /// that if the first call using that request token is successfully performed, the second call will not perform
        /// the action again.
        /// </p>
        /// <p>
        /// Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests
        /// spanning hours or days.
        /// </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>
        /// The request token for performing the update action.
        /// Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error
        /// like a failed network connection, you can retry the call with the same request token. The service ensures
        /// that if the first call using that request token is successfully performed, the second call will not perform
        /// the action again.
        /// </p>
        /// <p>
        /// Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests
        /// spanning hours or days.
        /// </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchUpsertTableRows`.
    ///
    /// <p>
    /// The BatchUpsertTableRows API allows you to upsert one or more rows in a table. The upsert
    /// operation takes a filter expression as input and evaluates it to find matching rows on the destination
    /// table. If matching rows are found, it will update the cells in the matching rows to new values specified
    /// in the request. If no matching rows are found, a new row is added at the end of the table and the cells in
    /// that row are set to the new values specified in the request.
    /// </p>
    /// <p>
    /// You can specify the values to set in some or all of the columns in the table for the
    /// matching or newly appended rows. If a column is not explicitly specified for a particular row, then that
    /// column will not be updated for that row. To clear out the data in a specific cell, you need to set the value
    /// as an empty string ("").
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct BatchUpsertTableRows<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_upsert_table_rows_input::Builder,
    }
    impl<C, M, R> BatchUpsertTableRows<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchUpsertTableRows`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchUpsertTableRowsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchUpsertTableRowsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchUpsertTableRowsInputOperationOutputAlias,
                crate::output::BatchUpsertTableRowsOutput,
                crate::error::BatchUpsertTableRowsError,
                crate::input::BatchUpsertTableRowsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workbook where the rows are being upserted.</p>
        /// <p>
        /// If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn workbook_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workbook_id(inp);
            self
        }
        /// <p>The ID of the workbook where the rows are being upserted.</p>
        /// <p>
        /// If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn set_workbook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workbook_id(input);
            self
        }
        /// <p>The ID of the table where the rows are being upserted.</p>
        /// <p>
        /// If a table with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn table_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_id(inp);
            self
        }
        /// <p>The ID of the table where the rows are being upserted.</p>
        /// <p>
        /// If a table with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn set_table_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_id(input);
            self
        }
        /// Appends an item to `rowsToUpsert`.
        ///
        /// To override the contents of this collection use [`set_rows_to_upsert`](Self::set_rows_to_upsert).
        ///
        /// <p>
        /// The list of rows to upsert in the table. Each item in this list needs to have a batch item id to uniquely
        /// identify the element in the request, a filter expression to find the rows to update for that element
        /// and the cell values to set for each column in the upserted rows. You need to specify
        /// at least one item in this list.
        /// </p>
        /// <p>
        /// Note that if one of the filter formulas in the request fails to evaluate because of an error or one of the
        /// column ids in any of the rows does not exist in the table, then the request fails
        /// and no updates are made to the table.
        /// </p>
        pub fn rows_to_upsert(mut self, inp: impl Into<crate::model::UpsertRowData>) -> Self {
            self.inner = self.inner.rows_to_upsert(inp);
            self
        }
        /// <p>
        /// The list of rows to upsert in the table. Each item in this list needs to have a batch item id to uniquely
        /// identify the element in the request, a filter expression to find the rows to update for that element
        /// and the cell values to set for each column in the upserted rows. You need to specify
        /// at least one item in this list.
        /// </p>
        /// <p>
        /// Note that if one of the filter formulas in the request fails to evaluate because of an error or one of the
        /// column ids in any of the rows does not exist in the table, then the request fails
        /// and no updates are made to the table.
        /// </p>
        pub fn set_rows_to_upsert(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpsertRowData>>,
        ) -> Self {
            self.inner = self.inner.set_rows_to_upsert(input);
            self
        }
        /// <p>
        /// The request token for performing the update action.
        /// Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error
        /// like a failed network connection, you can retry the call with the same request token. The service ensures
        /// that if the first call using that request token is successfully performed, the second call will not perform
        /// the action again.
        /// </p>
        /// <p>
        /// Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests
        /// spanning hours or days.
        /// </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>
        /// The request token for performing the update action.
        /// Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error
        /// like a failed network connection, you can retry the call with the same request token. The service ensures
        /// that if the first call using that request token is successfully performed, the second call will not perform
        /// the action again.
        /// </p>
        /// <p>
        /// Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests
        /// spanning hours or days.
        /// </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTableDataImportJob`.
    ///
    /// <p>
    /// The DescribeTableDataImportJob API allows you to retrieve the status and details of a table data import job.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTableDataImportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_table_data_import_job_input::Builder,
    }
    impl<C, M, R> DescribeTableDataImportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTableDataImportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTableDataImportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTableDataImportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTableDataImportJobInputOperationOutputAlias,
                crate::output::DescribeTableDataImportJobOutput,
                crate::error::DescribeTableDataImportJobError,
                crate::input::DescribeTableDataImportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workbook into which data was imported.</p>
        /// <p>
        /// If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn workbook_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workbook_id(inp);
            self
        }
        /// <p>The ID of the workbook into which data was imported.</p>
        /// <p>
        /// If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn set_workbook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workbook_id(input);
            self
        }
        /// <p>The ID of the table into which data was imported.</p>
        /// <p>
        /// If a table with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn table_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_id(inp);
            self
        }
        /// <p>The ID of the table into which data was imported.</p>
        /// <p>
        /// If a table with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn set_table_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_id(input);
            self
        }
        /// <p>The ID of the job that was returned by the StartTableDataImportJob request.</p>
        /// <p>
        /// If a job with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The ID of the job that was returned by the StartTableDataImportJob request.</p>
        /// <p>
        /// If a job with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetScreenData`.
    ///
    /// <p>
    /// The GetScreenData API allows retrieval of data from a screen in a Honeycode app.
    /// The API allows setting local variables in the screen to filter, sort or otherwise affect what will be
    /// displayed on the screen.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetScreenData<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_screen_data_input::Builder,
    }
    impl<C, M, R> GetScreenData<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetScreenData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetScreenDataOutput,
            aws_smithy_http::result::SdkError<crate::error::GetScreenDataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetScreenDataInputOperationOutputAlias,
                crate::output::GetScreenDataOutput,
                crate::error::GetScreenDataError,
                crate::input::GetScreenDataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workbook that contains the screen.</p>
        pub fn workbook_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workbook_id(inp);
            self
        }
        /// <p>The ID of the workbook that contains the screen.</p>
        pub fn set_workbook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workbook_id(input);
            self
        }
        /// <p>The ID of the app that contains the screem.</p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p>The ID of the app that contains the screem.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The ID of the screen.</p>
        pub fn screen_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.screen_id(inp);
            self
        }
        /// <p>The ID of the screen.</p>
        pub fn set_screen_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_screen_id(input);
            self
        }
        /// Adds a key-value pair to `variables`.
        ///
        /// To override the contents of this collection use [`set_variables`](Self::set_variables).
        ///
        /// <p>
        /// Variables are optional and are needed only if the screen requires them to render correctly. Variables are
        /// specified as a map where the key is the name of the variable as defined on the screen. The value is an
        /// object which currently has only one property, rawValue, which holds the value of the variable to be passed
        /// to the screen.
        /// </p>
        pub fn variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::VariableValue>,
        ) -> Self {
            self.inner = self.inner.variables(k, v);
            self
        }
        /// <p>
        /// Variables are optional and are needed only if the screen requires them to render correctly. Variables are
        /// specified as a map where the key is the name of the variable as defined on the screen. The value is an
        /// object which currently has only one property, rawValue, which holds the value of the variable to be passed
        /// to the screen.
        /// </p>
        pub fn set_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::VariableValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_variables(input);
            self
        }
        /// <p>
        /// The number of results to be returned on a single page.
        /// Specify a number between 1 and 100. The maximum value is 100.
        /// </p>
        /// <p>
        /// This parameter is optional. If you don't specify this parameter, the default page size is 100.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// The number of results to be returned on a single page.
        /// Specify a number between 1 and 100. The maximum value is 100.
        /// </p>
        /// <p>
        /// This parameter is optional. If you don't specify this parameter, the default page size is 100.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>
        /// This parameter is optional. If a nextToken is not specified, the API returns the first page of data.
        /// </p>
        /// <p>
        /// Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API
        /// will throw ValidationException.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// This parameter is optional. If a nextToken is not specified, the API returns the first page of data.
        /// </p>
        /// <p>
        /// Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API
        /// will throw ValidationException.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `InvokeScreenAutomation`.
    ///
    /// <p>
    /// The InvokeScreenAutomation API allows invoking an action defined in a screen in a Honeycode app.
    /// The API allows setting local variables, which can then be used in the automation being invoked.
    /// This allows automating the Honeycode app interactions to write, update or delete data in the workbook.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct InvokeScreenAutomation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::invoke_screen_automation_input::Builder,
    }
    impl<C, M, R> InvokeScreenAutomation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `InvokeScreenAutomation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::InvokeScreenAutomationOutput,
            aws_smithy_http::result::SdkError<crate::error::InvokeScreenAutomationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::InvokeScreenAutomationInputOperationOutputAlias,
                crate::output::InvokeScreenAutomationOutput,
                crate::error::InvokeScreenAutomationError,
                crate::input::InvokeScreenAutomationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workbook that contains the screen automation.</p>
        pub fn workbook_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workbook_id(inp);
            self
        }
        /// <p>The ID of the workbook that contains the screen automation.</p>
        pub fn set_workbook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workbook_id(input);
            self
        }
        /// <p>The ID of the app that contains the screen automation.</p>
        pub fn app_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_id(inp);
            self
        }
        /// <p>The ID of the app that contains the screen automation.</p>
        pub fn set_app_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_app_id(input);
            self
        }
        /// <p>The ID of the screen that contains the screen automation.</p>
        pub fn screen_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.screen_id(inp);
            self
        }
        /// <p>The ID of the screen that contains the screen automation.</p>
        pub fn set_screen_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_screen_id(input);
            self
        }
        /// <p>The ID of the automation action to be performed.</p>
        pub fn screen_automation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.screen_automation_id(inp);
            self
        }
        /// <p>The ID of the automation action to be performed.</p>
        pub fn set_screen_automation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_screen_automation_id(input);
            self
        }
        /// Adds a key-value pair to `variables`.
        ///
        /// To override the contents of this collection use [`set_variables`](Self::set_variables).
        ///
        /// <p>
        /// Variables are specified as a map where the key is the name of the variable as defined on the screen. The value is an
        /// object which currently has only one property, rawValue, which holds the value of the variable to be passed
        /// to the screen. Any variables defined in a screen are required to be passed in the call.
        /// </p>
        pub fn variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::VariableValue>,
        ) -> Self {
            self.inner = self.inner.variables(k, v);
            self
        }
        /// <p>
        /// Variables are specified as a map where the key is the name of the variable as defined on the screen. The value is an
        /// object which currently has only one property, rawValue, which holds the value of the variable to be passed
        /// to the screen. Any variables defined in a screen are required to be passed in the call.
        /// </p>
        pub fn set_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::VariableValue>,
            >,
        ) -> Self {
            self.inner = self.inner.set_variables(input);
            self
        }
        /// <p>
        /// The row ID for the automation if the automation is defined inside a block with source or list.
        /// </p>
        pub fn row_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.row_id(inp);
            self
        }
        /// <p>
        /// The row ID for the automation if the automation is defined inside a block with source or list.
        /// </p>
        pub fn set_row_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_row_id(input);
            self
        }
        /// <p>
        /// The request token for performing the automation action.
        /// Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error
        /// like a failed network connection, you can retry the call with the same request token. The service ensures
        /// that if the first call using that request token is successfully performed, the second call will return the
        /// response of the previous call rather than performing the action again.
        /// </p>
        /// <p>
        /// Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests
        /// spanning hours or days.
        /// </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>
        /// The request token for performing the automation action.
        /// Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error
        /// like a failed network connection, you can retry the call with the same request token. The service ensures
        /// that if the first call using that request token is successfully performed, the second call will return the
        /// response of the previous call rather than performing the action again.
        /// </p>
        /// <p>
        /// Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests
        /// spanning hours or days.
        /// </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTableColumns`.
    ///
    /// <p>
    /// The ListTableColumns API allows you to retrieve a list of all the columns in a table in a workbook.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListTableColumns<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_table_columns_input::Builder,
    }
    impl<C, M, R> ListTableColumns<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTableColumns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTableColumnsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTableColumnsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTableColumnsInputOperationOutputAlias,
                crate::output::ListTableColumnsOutput,
                crate::error::ListTableColumnsError,
                crate::input::ListTableColumnsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workbook that contains the table whose columns are being retrieved.</p>
        /// <p>
        /// If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn workbook_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workbook_id(inp);
            self
        }
        /// <p>The ID of the workbook that contains the table whose columns are being retrieved.</p>
        /// <p>
        /// If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn set_workbook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workbook_id(input);
            self
        }
        /// <p>The ID of the table whose columns are being retrieved.</p>
        /// <p>
        /// If a table with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn table_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_id(inp);
            self
        }
        /// <p>The ID of the table whose columns are being retrieved.</p>
        /// <p>
        /// If a table with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn set_table_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_id(input);
            self
        }
        /// <p>
        /// This parameter is optional. If a nextToken is not specified, the API returns the first page of data.
        /// </p>
        /// <p>
        /// Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API
        /// will throw ValidationException.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// This parameter is optional. If a nextToken is not specified, the API returns the first page of data.
        /// </p>
        /// <p>
        /// Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API
        /// will throw ValidationException.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTableRows`.
    ///
    /// <p>
    /// The ListTableRows API allows you to retrieve a list of all the rows in a table in a workbook.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListTableRows<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_table_rows_input::Builder,
    }
    impl<C, M, R> ListTableRows<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTableRows`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTableRowsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTableRowsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTableRowsInputOperationOutputAlias,
                crate::output::ListTableRowsOutput,
                crate::error::ListTableRowsError,
                crate::input::ListTableRowsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workbook that contains the table whose rows are being retrieved.</p>
        /// <p>
        /// If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn workbook_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workbook_id(inp);
            self
        }
        /// <p>The ID of the workbook that contains the table whose rows are being retrieved.</p>
        /// <p>
        /// If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn set_workbook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workbook_id(input);
            self
        }
        /// <p>The ID of the table whose rows are being retrieved.</p>
        /// <p>
        /// If a table with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn table_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_id(inp);
            self
        }
        /// <p>The ID of the table whose rows are being retrieved.</p>
        /// <p>
        /// If a table with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn set_table_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_id(input);
            self
        }
        /// Appends an item to `rowIds`.
        ///
        /// To override the contents of this collection use [`set_row_ids`](Self::set_row_ids).
        ///
        /// <p>
        /// This parameter is optional. If one or more row ids are specified in this list, then only the specified
        /// row ids are returned in the result. If no row ids are specified here, then all the rows in the table are
        /// returned.
        /// </p>
        pub fn row_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.row_ids(inp);
            self
        }
        /// <p>
        /// This parameter is optional. If one or more row ids are specified in this list, then only the specified
        /// row ids are returned in the result. If no row ids are specified here, then all the rows in the table are
        /// returned.
        /// </p>
        pub fn set_row_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_row_ids(input);
            self
        }
        /// <p>The maximum number of rows to return in each page of the results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of rows to return in each page of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>
        /// This parameter is optional. If a nextToken is not specified, the API returns the first page of data.
        /// </p>
        /// <p>
        /// Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API
        /// will throw ValidationException.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// This parameter is optional. If a nextToken is not specified, the API returns the first page of data.
        /// </p>
        /// <p>
        /// Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API
        /// will throw ValidationException.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTables`.
    ///
    /// <p>
    /// The ListTables API allows you to retrieve a list of all the tables in a workbook.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListTables<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tables_input::Builder,
    }
    impl<C, M, R> ListTables<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTables`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTablesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTablesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTablesInputOperationOutputAlias,
                crate::output::ListTablesOutput,
                crate::error::ListTablesError,
                crate::input::ListTablesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workbook whose tables are being retrieved.</p>
        /// <p>
        /// If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn workbook_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workbook_id(inp);
            self
        }
        /// <p>The ID of the workbook whose tables are being retrieved.</p>
        /// <p>
        /// If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn set_workbook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workbook_id(input);
            self
        }
        /// <p>The maximum number of tables to return in each page of the results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of tables to return in each page of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>
        /// This parameter is optional. If a nextToken is not specified, the API returns the first page of data.
        /// </p>
        /// <p>
        /// Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API
        /// will throw ValidationException.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// This parameter is optional. If a nextToken is not specified, the API returns the first page of data.
        /// </p>
        /// <p>
        /// Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API
        /// will throw ValidationException.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `QueryTableRows`.
    ///
    /// <p>
    /// The QueryTableRows API allows you to use a filter formula to query for specific rows in a table.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct QueryTableRows<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::query_table_rows_input::Builder,
    }
    impl<C, M, R> QueryTableRows<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `QueryTableRows`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::QueryTableRowsOutput,
            aws_smithy_http::result::SdkError<crate::error::QueryTableRowsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::QueryTableRowsInputOperationOutputAlias,
                crate::output::QueryTableRowsOutput,
                crate::error::QueryTableRowsError,
                crate::input::QueryTableRowsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workbook whose table rows are being queried.</p>
        /// <p>
        /// If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn workbook_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workbook_id(inp);
            self
        }
        /// <p>The ID of the workbook whose table rows are being queried.</p>
        /// <p>
        /// If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn set_workbook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workbook_id(input);
            self
        }
        /// <p>The ID of the table whose rows are being queried.</p>
        /// <p>
        /// If a table with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn table_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_id(inp);
            self
        }
        /// <p>The ID of the table whose rows are being queried.</p>
        /// <p>
        /// If a table with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn set_table_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_id(input);
            self
        }
        /// <p>An object that represents a filter formula along with the id of the context row under which the filter
        /// function needs to evaluate.</p>
        pub fn filter_formula(mut self, inp: crate::model::Filter) -> Self {
            self.inner = self.inner.filter_formula(inp);
            self
        }
        /// <p>An object that represents a filter formula along with the id of the context row under which the filter
        /// function needs to evaluate.</p>
        pub fn set_filter_formula(
            mut self,
            input: std::option::Option<crate::model::Filter>,
        ) -> Self {
            self.inner = self.inner.set_filter_formula(input);
            self
        }
        /// <p>The maximum number of rows to return in each page of the results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of rows to return in each page of the results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>
        /// This parameter is optional. If a nextToken is not specified, the API returns the first page of data.
        /// </p>
        /// <p>
        /// Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API
        /// will throw ValidationException.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// This parameter is optional. If a nextToken is not specified, the API returns the first page of data.
        /// </p>
        /// <p>
        /// Pagination tokens expire after 1 hour. If you use a token that was returned more than an hour back, the API
        /// will throw ValidationException.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartTableDataImportJob`.
    ///
    /// <p>
    /// The StartTableDataImportJob API allows you to start an import job on a table. This API will only return
    /// the id of the job that was started. To find out the status of the import request, you need to call the
    /// DescribeTableDataImportJob API.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct StartTableDataImportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_table_data_import_job_input::Builder,
    }
    impl<C, M, R> StartTableDataImportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartTableDataImportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartTableDataImportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartTableDataImportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartTableDataImportJobInputOperationOutputAlias,
                crate::output::StartTableDataImportJobOutput,
                crate::error::StartTableDataImportJobError,
                crate::input::StartTableDataImportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the workbook where the rows are being imported.</p>
        /// <p>
        /// If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn workbook_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workbook_id(inp);
            self
        }
        /// <p>The ID of the workbook where the rows are being imported.</p>
        /// <p>
        /// If a workbook with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn set_workbook_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workbook_id(input);
            self
        }
        /// <p>
        /// The source of the data that is being imported. The size of source must be no larger than 100 MB.
        /// Source must have no more than 100,000 cells and no more than 1,000 rows.
        /// </p>
        pub fn data_source(mut self, inp: crate::model::ImportDataSource) -> Self {
            self.inner = self.inner.data_source(inp);
            self
        }
        /// <p>
        /// The source of the data that is being imported. The size of source must be no larger than 100 MB.
        /// Source must have no more than 100,000 cells and no more than 1,000 rows.
        /// </p>
        pub fn set_data_source(
            mut self,
            input: std::option::Option<crate::model::ImportDataSource>,
        ) -> Self {
            self.inner = self.inner.set_data_source(input);
            self
        }
        /// <p>
        /// The format of the data that is being imported. Currently the only option supported is "DELIMITED_TEXT".
        /// </p>
        pub fn data_format(mut self, inp: crate::model::ImportSourceDataFormat) -> Self {
            self.inner = self.inner.data_format(inp);
            self
        }
        /// <p>
        /// The format of the data that is being imported. Currently the only option supported is "DELIMITED_TEXT".
        /// </p>
        pub fn set_data_format(
            mut self,
            input: std::option::Option<crate::model::ImportSourceDataFormat>,
        ) -> Self {
            self.inner = self.inner.set_data_format(input);
            self
        }
        /// <p>The ID of the table where the rows are being imported.</p>
        /// <p>
        /// If a table with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn destination_table_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_table_id(inp);
            self
        }
        /// <p>The ID of the table where the rows are being imported.</p>
        /// <p>
        /// If a table with the specified id could not be found, this API throws ResourceNotFoundException.
        /// </p>
        pub fn set_destination_table_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_table_id(input);
            self
        }
        /// <p>
        /// The options for customizing this import request.
        /// </p>
        pub fn import_options(mut self, inp: crate::model::ImportOptions) -> Self {
            self.inner = self.inner.import_options(inp);
            self
        }
        /// <p>
        /// The options for customizing this import request.
        /// </p>
        pub fn set_import_options(
            mut self,
            input: std::option::Option<crate::model::ImportOptions>,
        ) -> Self {
            self.inner = self.inner.set_import_options(input);
            self
        }
        /// <p>
        /// The request token for performing the update action.
        /// Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error
        /// like a failed network connection, you can retry the call with the same request token. The service ensures
        /// that if the first call using that request token is successfully performed, the second call will not perform
        /// the action again.
        /// </p>
        /// <p>
        /// Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests
        /// spanning hours or days.
        /// </p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>
        /// The request token for performing the update action.
        /// Request tokens help to identify duplicate requests. If a call times out or fails due to a transient error
        /// like a failed network connection, you can retry the call with the same request token. The service ensures
        /// that if the first call using that request token is successfully performed, the second call will not perform
        /// the action again.
        /// </p>
        /// <p>
        /// Note that request tokens are valid only for a few minutes. You cannot use request tokens to dedupe requests
        /// spanning hours or days.
        /// </p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
