// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateFhirDatastoreInput`](crate::input::CreateFhirDatastoreInput)
pub mod create_fhir_datastore_input {
    /// A builder for [`CreateFhirDatastoreInput`](crate::input::CreateFhirDatastoreInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) datastore_name: std::option::Option<std::string::String>,
        pub(crate) datastore_type_version: std::option::Option<crate::model::FhirVersion>,
        pub(crate) sse_configuration: std::option::Option<crate::model::SseConfiguration>,
        pub(crate) preload_data_config: std::option::Option<crate::model::PreloadDataConfig>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The user generated name for the Data Store.</p>
        pub fn datastore_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.datastore_name = Some(input.into());
            self
        }
        /// <p>The user generated name for the Data Store.</p>
        pub fn set_datastore_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.datastore_name = input;
            self
        }
        /// <p>The FHIR version of the Data Store. The only supported version is R4.</p>
        pub fn datastore_type_version(mut self, input: crate::model::FhirVersion) -> Self {
            self.datastore_type_version = Some(input);
            self
        }
        /// <p>The FHIR version of the Data Store. The only supported version is R4.</p>
        pub fn set_datastore_type_version(
            mut self,
            input: std::option::Option<crate::model::FhirVersion>,
        ) -> Self {
            self.datastore_type_version = input;
            self
        }
        /// <p> The server-side encryption key configuration for a customer provided encryption key specified for creating a Data Store. </p>
        pub fn sse_configuration(mut self, input: crate::model::SseConfiguration) -> Self {
            self.sse_configuration = Some(input);
            self
        }
        /// <p> The server-side encryption key configuration for a customer provided encryption key specified for creating a Data Store. </p>
        pub fn set_sse_configuration(
            mut self,
            input: std::option::Option<crate::model::SseConfiguration>,
        ) -> Self {
            self.sse_configuration = input;
            self
        }
        /// <p>Optional parameter to preload data upon creation of the Data Store. Currently, the only supported preloaded data is synthetic data generated from Synthea.</p>
        pub fn preload_data_config(mut self, input: crate::model::PreloadDataConfig) -> Self {
            self.preload_data_config = Some(input);
            self
        }
        /// <p>Optional parameter to preload data upon creation of the Data Store. Currently, the only supported preloaded data is synthetic data generated from Synthea.</p>
        pub fn set_preload_data_config(
            mut self,
            input: std::option::Option<crate::model::PreloadDataConfig>,
        ) -> Self {
            self.preload_data_config = input;
            self
        }
        /// <p>Optional user provided token used for ensuring idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Optional user provided token used for ensuring idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> Resource tags that are applied to a Data Store when it is created. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p> Resource tags that are applied to a Data Store when it is created. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFhirDatastoreInput`](crate::input::CreateFhirDatastoreInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFhirDatastoreInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFhirDatastoreInput {
                datastore_name: self.datastore_name,
                datastore_type_version: self.datastore_type_version,
                sse_configuration: self.sse_configuration,
                preload_data_config: self.preload_data_config,
                client_token: self.client_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFhirDatastoreInputOperationOutputAlias = crate::operation::CreateFHIRDatastore;
#[doc(hidden)]
pub type CreateFhirDatastoreInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateFhirDatastoreInput {
    /// Consumes the builder and constructs an Operation<[`CreateFHIRDatastore`](crate::operation::CreateFHIRDatastore)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFHIRDatastore,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateFhirDatastoreInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateFhirDatastoreInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateFhirDatastoreInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "HealthLake.CreateFHIRDatastore",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_fhir_datastore(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFHIRDatastore::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFHIRDatastore",
            "healthlake",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateFhirDatastoreInput`](crate::input::CreateFhirDatastoreInput)
    pub fn builder() -> crate::input::create_fhir_datastore_input::Builder {
        crate::input::create_fhir_datastore_input::Builder::default()
    }
}

/// See [`DeleteFhirDatastoreInput`](crate::input::DeleteFhirDatastoreInput)
pub mod delete_fhir_datastore_input {
    /// A builder for [`DeleteFhirDatastoreInput`](crate::input::DeleteFhirDatastoreInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) datastore_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The AWS-generated ID for the Data Store to be deleted.</p>
        pub fn datastore_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.datastore_id = Some(input.into());
            self
        }
        /// <p> The AWS-generated ID for the Data Store to be deleted.</p>
        pub fn set_datastore_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.datastore_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFhirDatastoreInput`](crate::input::DeleteFhirDatastoreInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFhirDatastoreInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFhirDatastoreInput {
                datastore_id: self.datastore_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFhirDatastoreInputOperationOutputAlias = crate::operation::DeleteFHIRDatastore;
#[doc(hidden)]
pub type DeleteFhirDatastoreInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteFhirDatastoreInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFHIRDatastore`](crate::operation::DeleteFHIRDatastore)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFHIRDatastore,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteFhirDatastoreInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteFhirDatastoreInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteFhirDatastoreInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "HealthLake.DeleteFHIRDatastore",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_fhir_datastore(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFHIRDatastore::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFHIRDatastore",
            "healthlake",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteFhirDatastoreInput`](crate::input::DeleteFhirDatastoreInput)
    pub fn builder() -> crate::input::delete_fhir_datastore_input::Builder {
        crate::input::delete_fhir_datastore_input::Builder::default()
    }
}

/// See [`DescribeFhirDatastoreInput`](crate::input::DescribeFhirDatastoreInput)
pub mod describe_fhir_datastore_input {
    /// A builder for [`DescribeFhirDatastoreInput`](crate::input::DescribeFhirDatastoreInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) datastore_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AWS-generated Data Store id. This is part of the ‘CreateFHIRDatastore’ output.</p>
        pub fn datastore_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.datastore_id = Some(input.into());
            self
        }
        /// <p>The AWS-generated Data Store id. This is part of the ‘CreateFHIRDatastore’ output.</p>
        pub fn set_datastore_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.datastore_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFhirDatastoreInput`](crate::input::DescribeFhirDatastoreInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFhirDatastoreInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFhirDatastoreInput {
                datastore_id: self.datastore_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFhirDatastoreInputOperationOutputAlias = crate::operation::DescribeFHIRDatastore;
#[doc(hidden)]
pub type DescribeFhirDatastoreInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeFhirDatastoreInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFHIRDatastore`](crate::operation::DescribeFHIRDatastore)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFHIRDatastore,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeFhirDatastoreInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeFhirDatastoreInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeFhirDatastoreInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "HealthLake.DescribeFHIRDatastore",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_fhir_datastore(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFHIRDatastore::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFHIRDatastore",
            "healthlake",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeFhirDatastoreInput`](crate::input::DescribeFhirDatastoreInput)
    pub fn builder() -> crate::input::describe_fhir_datastore_input::Builder {
        crate::input::describe_fhir_datastore_input::Builder::default()
    }
}

/// See [`DescribeFhirExportJobInput`](crate::input::DescribeFhirExportJobInput)
pub mod describe_fhir_export_job_input {
    /// A builder for [`DescribeFhirExportJobInput`](crate::input::DescribeFhirExportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) datastore_id: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AWS generated ID for the Data Store from which files are being exported from for an export job.</p>
        pub fn datastore_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.datastore_id = Some(input.into());
            self
        }
        /// <p>The AWS generated ID for the Data Store from which files are being exported from for an export job.</p>
        pub fn set_datastore_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.datastore_id = input;
            self
        }
        /// <p>The AWS generated ID for an export job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The AWS generated ID for an export job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFhirExportJobInput`](crate::input::DescribeFhirExportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFhirExportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFhirExportJobInput {
                datastore_id: self.datastore_id,
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFhirExportJobInputOperationOutputAlias = crate::operation::DescribeFHIRExportJob;
#[doc(hidden)]
pub type DescribeFhirExportJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeFhirExportJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFHIRExportJob`](crate::operation::DescribeFHIRExportJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFHIRExportJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeFhirExportJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeFhirExportJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeFhirExportJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "HealthLake.DescribeFHIRExportJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_fhir_export_job(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFHIRExportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFHIRExportJob",
            "healthlake",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeFhirExportJobInput`](crate::input::DescribeFhirExportJobInput)
    pub fn builder() -> crate::input::describe_fhir_export_job_input::Builder {
        crate::input::describe_fhir_export_job_input::Builder::default()
    }
}

/// See [`DescribeFhirImportJobInput`](crate::input::DescribeFhirImportJobInput)
pub mod describe_fhir_import_job_input {
    /// A builder for [`DescribeFhirImportJobInput`](crate::input::DescribeFhirImportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) datastore_id: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AWS-generated ID of the Data Store.</p>
        pub fn datastore_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.datastore_id = Some(input.into());
            self
        }
        /// <p>The AWS-generated ID of the Data Store.</p>
        pub fn set_datastore_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.datastore_id = input;
            self
        }
        /// <p>The AWS-generated job ID.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The AWS-generated job ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFhirImportJobInput`](crate::input::DescribeFhirImportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFhirImportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFhirImportJobInput {
                datastore_id: self.datastore_id,
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFhirImportJobInputOperationOutputAlias = crate::operation::DescribeFHIRImportJob;
#[doc(hidden)]
pub type DescribeFhirImportJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeFhirImportJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFHIRImportJob`](crate::operation::DescribeFHIRImportJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFHIRImportJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeFhirImportJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeFhirImportJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeFhirImportJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "HealthLake.DescribeFHIRImportJob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_fhir_import_job(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFHIRImportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFHIRImportJob",
            "healthlake",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeFhirImportJobInput`](crate::input::DescribeFhirImportJobInput)
    pub fn builder() -> crate::input::describe_fhir_import_job_input::Builder {
        crate::input::describe_fhir_import_job_input::Builder::default()
    }
}

/// See [`ListFhirDatastoresInput`](crate::input::ListFhirDatastoresInput)
pub mod list_fhir_datastores_input {
    /// A builder for [`ListFhirDatastoresInput`](crate::input::ListFhirDatastoresInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter: std::option::Option<crate::model::DatastoreFilter>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Lists all filters associated with a FHIR Data Store request.</p>
        pub fn filter(mut self, input: crate::model::DatastoreFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Lists all filters associated with a FHIR Data Store request.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::DatastoreFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>Fetches the next page of Data Stores when results are paginated.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Fetches the next page of Data Stores when results are paginated.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of Data Stores returned in a single page of a ListFHIRDatastoresRequest call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of Data Stores returned in a single page of a ListFHIRDatastoresRequest call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFhirDatastoresInput`](crate::input::ListFhirDatastoresInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFhirDatastoresInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFhirDatastoresInput {
                filter: self.filter,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFhirDatastoresInputOperationOutputAlias = crate::operation::ListFHIRDatastores;
#[doc(hidden)]
pub type ListFhirDatastoresInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListFhirDatastoresInput {
    /// Consumes the builder and constructs an Operation<[`ListFHIRDatastores`](crate::operation::ListFHIRDatastores)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFHIRDatastores,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFhirDatastoresInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFhirDatastoresInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFhirDatastoresInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "HealthLake.ListFHIRDatastores",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_fhir_datastores(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFHIRDatastores::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFHIRDatastores",
            "healthlake",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFhirDatastoresInput`](crate::input::ListFhirDatastoresInput)
    pub fn builder() -> crate::input::list_fhir_datastores_input::Builder {
        crate::input::list_fhir_datastores_input::Builder::default()
    }
}

/// See [`ListFhirExportJobsInput`](crate::input::ListFhirExportJobsInput)
pub mod list_fhir_export_jobs_input {
    /// A builder for [`ListFhirExportJobsInput`](crate::input::ListFhirExportJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) datastore_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
        pub(crate) submitted_before: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) submitted_after: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p> This parameter limits the response to the export job with the specified Data Store ID. </p>
        pub fn datastore_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.datastore_id = Some(input.into());
            self
        }
        /// <p> This parameter limits the response to the export job with the specified Data Store ID. </p>
        pub fn set_datastore_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.datastore_id = input;
            self
        }
        /// <p> A pagination token used to identify the next page of results to return for a ListFHIRExportJobs query. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A pagination token used to identify the next page of results to return for a ListFHIRExportJobs query. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> This parameter limits the number of results returned for a ListFHIRExportJobs to a maximum quantity specified by the user. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> This parameter limits the number of results returned for a ListFHIRExportJobs to a maximum quantity specified by the user. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p> This parameter limits the response to the export job with the specified job name. </p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p> This parameter limits the response to the export job with the specified job name. </p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p> This parameter limits the response to the export jobs with the specified job status. </p>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p> This parameter limits the response to the export jobs with the specified job status. </p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p> This parameter limits the response to FHIR export jobs submitted before a user specified date. </p>
        pub fn submitted_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.submitted_before = Some(input);
            self
        }
        /// <p> This parameter limits the response to FHIR export jobs submitted before a user specified date. </p>
        pub fn set_submitted_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.submitted_before = input;
            self
        }
        /// <p> This parameter limits the response to FHIR export jobs submitted after a user specified date. </p>
        pub fn submitted_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.submitted_after = Some(input);
            self
        }
        /// <p> This parameter limits the response to FHIR export jobs submitted after a user specified date. </p>
        pub fn set_submitted_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.submitted_after = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFhirExportJobsInput`](crate::input::ListFhirExportJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFhirExportJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFhirExportJobsInput {
                datastore_id: self.datastore_id,
                next_token: self.next_token,
                max_results: self.max_results,
                job_name: self.job_name,
                job_status: self.job_status,
                submitted_before: self.submitted_before,
                submitted_after: self.submitted_after,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFhirExportJobsInputOperationOutputAlias = crate::operation::ListFHIRExportJobs;
#[doc(hidden)]
pub type ListFhirExportJobsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListFhirExportJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListFHIRExportJobs`](crate::operation::ListFHIRExportJobs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFHIRExportJobs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFhirExportJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFhirExportJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFhirExportJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "HealthLake.ListFHIRExportJobs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_fhir_export_jobs(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFHIRExportJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFHIRExportJobs",
            "healthlake",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFhirExportJobsInput`](crate::input::ListFhirExportJobsInput)
    pub fn builder() -> crate::input::list_fhir_export_jobs_input::Builder {
        crate::input::list_fhir_export_jobs_input::Builder::default()
    }
}

/// See [`ListFhirImportJobsInput`](crate::input::ListFhirImportJobsInput)
pub mod list_fhir_import_jobs_input {
    /// A builder for [`ListFhirImportJobsInput`](crate::input::ListFhirImportJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) datastore_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
        pub(crate) submitted_before: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) submitted_after: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p> This parameter limits the response to the import job with the specified Data Store ID. </p>
        pub fn datastore_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.datastore_id = Some(input.into());
            self
        }
        /// <p> This parameter limits the response to the import job with the specified Data Store ID. </p>
        pub fn set_datastore_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.datastore_id = input;
            self
        }
        /// <p> A pagination token used to identify the next page of results to return for a ListFHIRImportJobs query. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> A pagination token used to identify the next page of results to return for a ListFHIRImportJobs query. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> This parameter limits the number of results returned for a ListFHIRImportJobs to a maximum quantity specified by the user. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> This parameter limits the number of results returned for a ListFHIRImportJobs to a maximum quantity specified by the user. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p> This parameter limits the response to the import job with the specified job name. </p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p> This parameter limits the response to the import job with the specified job name. </p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p> This parameter limits the response to the import job with the specified job status. </p>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p> This parameter limits the response to the import job with the specified job status. </p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p> This parameter limits the response to FHIR import jobs submitted before a user specified date. </p>
        pub fn submitted_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.submitted_before = Some(input);
            self
        }
        /// <p> This parameter limits the response to FHIR import jobs submitted before a user specified date. </p>
        pub fn set_submitted_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.submitted_before = input;
            self
        }
        /// <p> This parameter limits the response to FHIR import jobs submitted after a user specified date. </p>
        pub fn submitted_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.submitted_after = Some(input);
            self
        }
        /// <p> This parameter limits the response to FHIR import jobs submitted after a user specified date. </p>
        pub fn set_submitted_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.submitted_after = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFhirImportJobsInput`](crate::input::ListFhirImportJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFhirImportJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFhirImportJobsInput {
                datastore_id: self.datastore_id,
                next_token: self.next_token,
                max_results: self.max_results,
                job_name: self.job_name,
                job_status: self.job_status,
                submitted_before: self.submitted_before,
                submitted_after: self.submitted_after,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFhirImportJobsInputOperationOutputAlias = crate::operation::ListFHIRImportJobs;
#[doc(hidden)]
pub type ListFhirImportJobsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListFhirImportJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListFHIRImportJobs`](crate::operation::ListFHIRImportJobs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFHIRImportJobs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFhirImportJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFhirImportJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFhirImportJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "HealthLake.ListFHIRImportJobs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_fhir_import_jobs(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFHIRImportJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFHIRImportJobs",
            "healthlake",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFhirImportJobsInput`](crate::input::ListFhirImportJobsInput)
    pub fn builder() -> crate::input::list_fhir_import_jobs_input::Builder {
        crate::input::list_fhir_import_jobs_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name(ARN) of the Data Store for which tags are being added. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name(ARN) of the Data Store for which tags are being added. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "HealthLake.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "healthlake",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`StartFhirExportJobInput`](crate::input::StartFhirExportJobInput)
pub mod start_fhir_export_job_input {
    /// A builder for [`StartFhirExportJobInput`](crate::input::StartFhirExportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) output_data_config: std::option::Option<crate::model::OutputDataConfig>,
        pub(crate) datastore_id: std::option::Option<std::string::String>,
        pub(crate) data_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user generated name for an export job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The user generated name for an export job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The output data configuration that was supplied when the export job was created.</p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.output_data_config = Some(input);
            self
        }
        /// <p>The output data configuration that was supplied when the export job was created.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.output_data_config = input;
            self
        }
        /// <p>The AWS generated ID for the Data Store from which files are being exported for an export job.</p>
        pub fn datastore_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.datastore_id = Some(input.into());
            self
        }
        /// <p>The AWS generated ID for the Data Store from which files are being exported for an export job.</p>
        pub fn set_datastore_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.datastore_id = input;
            self
        }
        /// <p>The Amazon Resource Name used during the initiation of the job.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name used during the initiation of the job.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_access_role_arn = input;
            self
        }
        /// <p>An optional user provided token used for ensuring idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>An optional user provided token used for ensuring idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`StartFhirExportJobInput`](crate::input::StartFhirExportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartFhirExportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartFhirExportJobInput {
                job_name: self.job_name,
                output_data_config: self.output_data_config,
                datastore_id: self.datastore_id,
                data_access_role_arn: self.data_access_role_arn,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type StartFhirExportJobInputOperationOutputAlias = crate::operation::StartFHIRExportJob;
#[doc(hidden)]
pub type StartFhirExportJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartFhirExportJobInput {
    /// Consumes the builder and constructs an Operation<[`StartFHIRExportJob`](crate::operation::StartFHIRExportJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartFHIRExportJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartFhirExportJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartFhirExportJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartFhirExportJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "HealthLake.StartFHIRExportJob",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_fhir_export_job(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartFHIRExportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartFHIRExportJob",
            "healthlake",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartFhirExportJobInput`](crate::input::StartFhirExportJobInput)
    pub fn builder() -> crate::input::start_fhir_export_job_input::Builder {
        crate::input::start_fhir_export_job_input::Builder::default()
    }
}

/// See [`StartFhirImportJobInput`](crate::input::StartFhirImportJobInput)
pub mod start_fhir_import_job_input {
    /// A builder for [`StartFhirImportJobInput`](crate::input::StartFhirImportJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) input_data_config: std::option::Option<crate::model::InputDataConfig>,
        pub(crate) job_output_data_config: std::option::Option<crate::model::OutputDataConfig>,
        pub(crate) datastore_id: std::option::Option<std::string::String>,
        pub(crate) data_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the FHIR Import job in the StartFHIRImport job request.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name of the FHIR Import job in the StartFHIRImport job request.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The input properties of the FHIR Import job in the StartFHIRImport job request.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.input_data_config = Some(input);
            self
        }
        /// <p>The input properties of the FHIR Import job in the StartFHIRImport job request.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.input_data_config = input;
            self
        }
        /// <p>The output data configuration that was supplied when the export job was created.</p>
        pub fn job_output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.job_output_data_config = Some(input);
            self
        }
        /// <p>The output data configuration that was supplied when the export job was created.</p>
        pub fn set_job_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.job_output_data_config = input;
            self
        }
        /// <p>The AWS-generated Data Store ID.</p>
        pub fn datastore_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.datastore_id = Some(input.into());
            self
        }
        /// <p>The AWS-generated Data Store ID.</p>
        pub fn set_datastore_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.datastore_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that gives Amazon HealthLake access permission.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that gives Amazon HealthLake access permission.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_access_role_arn = input;
            self
        }
        /// <p>Optional user provided token used for ensuring idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Optional user provided token used for ensuring idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`StartFhirImportJobInput`](crate::input::StartFhirImportJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartFhirImportJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartFhirImportJobInput {
                job_name: self.job_name,
                input_data_config: self.input_data_config,
                job_output_data_config: self.job_output_data_config,
                datastore_id: self.datastore_id,
                data_access_role_arn: self.data_access_role_arn,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type StartFhirImportJobInputOperationOutputAlias = crate::operation::StartFHIRImportJob;
#[doc(hidden)]
pub type StartFhirImportJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartFhirImportJobInput {
    /// Consumes the builder and constructs an Operation<[`StartFHIRImportJob`](crate::operation::StartFHIRImportJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartFHIRImportJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartFhirImportJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartFhirImportJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartFhirImportJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "HealthLake.StartFHIRImportJob",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_fhir_import_job(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartFHIRImportJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartFHIRImportJob",
            "healthlake",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartFhirImportJobInput`](crate::input::StartFhirImportJobInput)
    pub fn builder() -> crate::input::start_fhir_import_job_input::Builder {
        crate::input::start_fhir_import_job_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name(ARN)that gives Amazon HealthLake access to the Data Store which tags are being added to. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name(ARN)that gives Amazon HealthLake access to the Data Store which tags are being added to. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The user specified key and value pair tags being added to a Data Store. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p> The user specified key and value pair tags being added to a Data Store. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "HealthLake.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "healthlake",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p> "The Amazon Resource Name(ARN) of the Data Store for which tags are being removed </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p> "The Amazon Resource Name(ARN) of the Data Store for which tags are being removed </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p> The keys for the tags to be removed from the Healthlake Data Store. </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p> The keys for the tags to be removed from the Healthlake Data Store. </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.0",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "HealthLake.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "healthlake",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p> "The Amazon Resource Name(ARN) of the Data Store for which tags are being removed </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p> The keys for the tags to be removed from the Healthlake Data Store. </p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p> "The Amazon Resource Name(ARN) of the Data Store for which tags are being removed </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p> The keys for the tags to be removed from the Healthlake Data Store. </p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p> The Amazon Resource Name(ARN)that gives Amazon HealthLake access to the Data Store which tags are being added to. </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p> The user specified key and value pair tags being added to a Data Store. </p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p> The Amazon Resource Name(ARN)that gives Amazon HealthLake access to the Data Store which tags are being added to. </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p> The user specified key and value pair tags being added to a Data Store. </p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartFhirImportJobInput {
    /// <p>The name of the FHIR Import job in the StartFHIRImport job request.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The input properties of the FHIR Import job in the StartFHIRImport job request.</p>
    pub input_data_config: std::option::Option<crate::model::InputDataConfig>,
    /// <p>The output data configuration that was supplied when the export job was created.</p>
    pub job_output_data_config: std::option::Option<crate::model::OutputDataConfig>,
    /// <p>The AWS-generated Data Store ID.</p>
    pub datastore_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) that gives Amazon HealthLake access permission.</p>
    pub data_access_role_arn: std::option::Option<std::string::String>,
    /// <p>Optional user provided token used for ensuring idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl StartFhirImportJobInput {
    /// <p>The name of the FHIR Import job in the StartFHIRImport job request.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>The input properties of the FHIR Import job in the StartFHIRImport job request.</p>
    pub fn input_data_config(&self) -> std::option::Option<&crate::model::InputDataConfig> {
        self.input_data_config.as_ref()
    }
    /// <p>The output data configuration that was supplied when the export job was created.</p>
    pub fn job_output_data_config(&self) -> std::option::Option<&crate::model::OutputDataConfig> {
        self.job_output_data_config.as_ref()
    }
    /// <p>The AWS-generated Data Store ID.</p>
    pub fn datastore_id(&self) -> std::option::Option<&str> {
        self.datastore_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) that gives Amazon HealthLake access permission.</p>
    pub fn data_access_role_arn(&self) -> std::option::Option<&str> {
        self.data_access_role_arn.as_deref()
    }
    /// <p>Optional user provided token used for ensuring idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for StartFhirImportJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartFhirImportJobInput");
        formatter.field("job_name", &self.job_name);
        formatter.field("input_data_config", &self.input_data_config);
        formatter.field("job_output_data_config", &self.job_output_data_config);
        formatter.field("datastore_id", &self.datastore_id);
        formatter.field("data_access_role_arn", &self.data_access_role_arn);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartFhirExportJobInput {
    /// <p>The user generated name for an export job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The output data configuration that was supplied when the export job was created.</p>
    pub output_data_config: std::option::Option<crate::model::OutputDataConfig>,
    /// <p>The AWS generated ID for the Data Store from which files are being exported for an export job.</p>
    pub datastore_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name used during the initiation of the job.</p>
    pub data_access_role_arn: std::option::Option<std::string::String>,
    /// <p>An optional user provided token used for ensuring idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl StartFhirExportJobInput {
    /// <p>The user generated name for an export job.</p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>The output data configuration that was supplied when the export job was created.</p>
    pub fn output_data_config(&self) -> std::option::Option<&crate::model::OutputDataConfig> {
        self.output_data_config.as_ref()
    }
    /// <p>The AWS generated ID for the Data Store from which files are being exported for an export job.</p>
    pub fn datastore_id(&self) -> std::option::Option<&str> {
        self.datastore_id.as_deref()
    }
    /// <p>The Amazon Resource Name used during the initiation of the job.</p>
    pub fn data_access_role_arn(&self) -> std::option::Option<&str> {
        self.data_access_role_arn.as_deref()
    }
    /// <p>An optional user provided token used for ensuring idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for StartFhirExportJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartFhirExportJobInput");
        formatter.field("job_name", &self.job_name);
        formatter.field("output_data_config", &self.output_data_config);
        formatter.field("datastore_id", &self.datastore_id);
        formatter.field("data_access_role_arn", &self.data_access_role_arn);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p> The Amazon Resource Name(ARN) of the Data Store for which tags are being added. </p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p> The Amazon Resource Name(ARN) of the Data Store for which tags are being added. </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFhirImportJobsInput {
    /// <p> This parameter limits the response to the import job with the specified Data Store ID. </p>
    pub datastore_id: std::option::Option<std::string::String>,
    /// <p> A pagination token used to identify the next page of results to return for a ListFHIRImportJobs query. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> This parameter limits the number of results returned for a ListFHIRImportJobs to a maximum quantity specified by the user. </p>
    pub max_results: std::option::Option<i32>,
    /// <p> This parameter limits the response to the import job with the specified job name. </p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p> This parameter limits the response to the import job with the specified job status. </p>
    pub job_status: std::option::Option<crate::model::JobStatus>,
    /// <p> This parameter limits the response to FHIR import jobs submitted before a user specified date. </p>
    pub submitted_before: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> This parameter limits the response to FHIR import jobs submitted after a user specified date. </p>
    pub submitted_after: std::option::Option<aws_smithy_types::DateTime>,
}
impl ListFhirImportJobsInput {
    /// <p> This parameter limits the response to the import job with the specified Data Store ID. </p>
    pub fn datastore_id(&self) -> std::option::Option<&str> {
        self.datastore_id.as_deref()
    }
    /// <p> A pagination token used to identify the next page of results to return for a ListFHIRImportJobs query. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p> This parameter limits the number of results returned for a ListFHIRImportJobs to a maximum quantity specified by the user. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p> This parameter limits the response to the import job with the specified job name. </p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p> This parameter limits the response to the import job with the specified job status. </p>
    pub fn job_status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.job_status.as_ref()
    }
    /// <p> This parameter limits the response to FHIR import jobs submitted before a user specified date. </p>
    pub fn submitted_before(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.submitted_before.as_ref()
    }
    /// <p> This parameter limits the response to FHIR import jobs submitted after a user specified date. </p>
    pub fn submitted_after(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.submitted_after.as_ref()
    }
}
impl std::fmt::Debug for ListFhirImportJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFhirImportJobsInput");
        formatter.field("datastore_id", &self.datastore_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("job_name", &self.job_name);
        formatter.field("job_status", &self.job_status);
        formatter.field("submitted_before", &self.submitted_before);
        formatter.field("submitted_after", &self.submitted_after);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFhirExportJobsInput {
    /// <p> This parameter limits the response to the export job with the specified Data Store ID. </p>
    pub datastore_id: std::option::Option<std::string::String>,
    /// <p> A pagination token used to identify the next page of results to return for a ListFHIRExportJobs query. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> This parameter limits the number of results returned for a ListFHIRExportJobs to a maximum quantity specified by the user. </p>
    pub max_results: std::option::Option<i32>,
    /// <p> This parameter limits the response to the export job with the specified job name. </p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p> This parameter limits the response to the export jobs with the specified job status. </p>
    pub job_status: std::option::Option<crate::model::JobStatus>,
    /// <p> This parameter limits the response to FHIR export jobs submitted before a user specified date. </p>
    pub submitted_before: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> This parameter limits the response to FHIR export jobs submitted after a user specified date. </p>
    pub submitted_after: std::option::Option<aws_smithy_types::DateTime>,
}
impl ListFhirExportJobsInput {
    /// <p> This parameter limits the response to the export job with the specified Data Store ID. </p>
    pub fn datastore_id(&self) -> std::option::Option<&str> {
        self.datastore_id.as_deref()
    }
    /// <p> A pagination token used to identify the next page of results to return for a ListFHIRExportJobs query. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p> This parameter limits the number of results returned for a ListFHIRExportJobs to a maximum quantity specified by the user. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p> This parameter limits the response to the export job with the specified job name. </p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p> This parameter limits the response to the export jobs with the specified job status. </p>
    pub fn job_status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.job_status.as_ref()
    }
    /// <p> This parameter limits the response to FHIR export jobs submitted before a user specified date. </p>
    pub fn submitted_before(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.submitted_before.as_ref()
    }
    /// <p> This parameter limits the response to FHIR export jobs submitted after a user specified date. </p>
    pub fn submitted_after(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.submitted_after.as_ref()
    }
}
impl std::fmt::Debug for ListFhirExportJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFhirExportJobsInput");
        formatter.field("datastore_id", &self.datastore_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("job_name", &self.job_name);
        formatter.field("job_status", &self.job_status);
        formatter.field("submitted_before", &self.submitted_before);
        formatter.field("submitted_after", &self.submitted_after);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFhirDatastoresInput {
    /// <p>Lists all filters associated with a FHIR Data Store request.</p>
    pub filter: std::option::Option<crate::model::DatastoreFilter>,
    /// <p>Fetches the next page of Data Stores when results are paginated.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of Data Stores returned in a single page of a ListFHIRDatastoresRequest call.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListFhirDatastoresInput {
    /// <p>Lists all filters associated with a FHIR Data Store request.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::DatastoreFilter> {
        self.filter.as_ref()
    }
    /// <p>Fetches the next page of Data Stores when results are paginated.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of Data Stores returned in a single page of a ListFHIRDatastoresRequest call.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListFhirDatastoresInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFhirDatastoresInput");
        formatter.field("filter", &self.filter);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFhirImportJobInput {
    /// <p>The AWS-generated ID of the Data Store.</p>
    pub datastore_id: std::option::Option<std::string::String>,
    /// <p>The AWS-generated job ID.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl DescribeFhirImportJobInput {
    /// <p>The AWS-generated ID of the Data Store.</p>
    pub fn datastore_id(&self) -> std::option::Option<&str> {
        self.datastore_id.as_deref()
    }
    /// <p>The AWS-generated job ID.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeFhirImportJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFhirImportJobInput");
        formatter.field("datastore_id", &self.datastore_id);
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFhirExportJobInput {
    /// <p>The AWS generated ID for the Data Store from which files are being exported from for an export job.</p>
    pub datastore_id: std::option::Option<std::string::String>,
    /// <p>The AWS generated ID for an export job.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl DescribeFhirExportJobInput {
    /// <p>The AWS generated ID for the Data Store from which files are being exported from for an export job.</p>
    pub fn datastore_id(&self) -> std::option::Option<&str> {
        self.datastore_id.as_deref()
    }
    /// <p>The AWS generated ID for an export job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeFhirExportJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFhirExportJobInput");
        formatter.field("datastore_id", &self.datastore_id);
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFhirDatastoreInput {
    /// <p>The AWS-generated Data Store id. This is part of the ‘CreateFHIRDatastore’ output.</p>
    pub datastore_id: std::option::Option<std::string::String>,
}
impl DescribeFhirDatastoreInput {
    /// <p>The AWS-generated Data Store id. This is part of the ‘CreateFHIRDatastore’ output.</p>
    pub fn datastore_id(&self) -> std::option::Option<&str> {
        self.datastore_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeFhirDatastoreInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFhirDatastoreInput");
        formatter.field("datastore_id", &self.datastore_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFhirDatastoreInput {
    /// <p> The AWS-generated ID for the Data Store to be deleted.</p>
    pub datastore_id: std::option::Option<std::string::String>,
}
impl DeleteFhirDatastoreInput {
    /// <p> The AWS-generated ID for the Data Store to be deleted.</p>
    pub fn datastore_id(&self) -> std::option::Option<&str> {
        self.datastore_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteFhirDatastoreInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFhirDatastoreInput");
        formatter.field("datastore_id", &self.datastore_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFhirDatastoreInput {
    /// <p>The user generated name for the Data Store.</p>
    pub datastore_name: std::option::Option<std::string::String>,
    /// <p>The FHIR version of the Data Store. The only supported version is R4.</p>
    pub datastore_type_version: std::option::Option<crate::model::FhirVersion>,
    /// <p> The server-side encryption key configuration for a customer provided encryption key specified for creating a Data Store. </p>
    pub sse_configuration: std::option::Option<crate::model::SseConfiguration>,
    /// <p>Optional parameter to preload data upon creation of the Data Store. Currently, the only supported preloaded data is synthetic data generated from Synthea.</p>
    pub preload_data_config: std::option::Option<crate::model::PreloadDataConfig>,
    /// <p>Optional user provided token used for ensuring idempotency.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p> Resource tags that are applied to a Data Store when it is created. </p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateFhirDatastoreInput {
    /// <p>The user generated name for the Data Store.</p>
    pub fn datastore_name(&self) -> std::option::Option<&str> {
        self.datastore_name.as_deref()
    }
    /// <p>The FHIR version of the Data Store. The only supported version is R4.</p>
    pub fn datastore_type_version(&self) -> std::option::Option<&crate::model::FhirVersion> {
        self.datastore_type_version.as_ref()
    }
    /// <p> The server-side encryption key configuration for a customer provided encryption key specified for creating a Data Store. </p>
    pub fn sse_configuration(&self) -> std::option::Option<&crate::model::SseConfiguration> {
        self.sse_configuration.as_ref()
    }
    /// <p>Optional parameter to preload data upon creation of the Data Store. Currently, the only supported preloaded data is synthetic data generated from Synthea.</p>
    pub fn preload_data_config(&self) -> std::option::Option<&crate::model::PreloadDataConfig> {
        self.preload_data_config.as_ref()
    }
    /// <p>Optional user provided token used for ensuring idempotency.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p> Resource tags that are applied to a Data Store when it is created. </p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateFhirDatastoreInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFhirDatastoreInput");
        formatter.field("datastore_name", &self.datastore_name);
        formatter.field("datastore_type_version", &self.datastore_type_version);
        formatter.field("sse_configuration", &self.sse_configuration);
        formatter.field("preload_data_config", &self.preload_data_config);
        formatter.field("client_token", &self.client_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
