// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon HealthLake
///
/// Client for invoking operations on Amazon HealthLake. Each operation on Amazon HealthLake is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_healthlake::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_healthlake::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_healthlake::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`CreateFHIRDatastore`](crate::client::fluent_builders::CreateFHIRDatastore) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`datastore_name(impl Into<String>)`](crate::client::fluent_builders::CreateFHIRDatastore::datastore_name) / [`set_datastore_name(Option<String>)`](crate::client::fluent_builders::CreateFHIRDatastore::set_datastore_name): <p>The user generated name for the Data Store.</p>
    ///   - [`datastore_type_version(FhirVersion)`](crate::client::fluent_builders::CreateFHIRDatastore::datastore_type_version) / [`set_datastore_type_version(Option<FhirVersion>)`](crate::client::fluent_builders::CreateFHIRDatastore::set_datastore_type_version): <p>The FHIR version of the Data Store. The only supported version is R4.</p>
    ///   - [`sse_configuration(SseConfiguration)`](crate::client::fluent_builders::CreateFHIRDatastore::sse_configuration) / [`set_sse_configuration(Option<SseConfiguration>)`](crate::client::fluent_builders::CreateFHIRDatastore::set_sse_configuration): <p> The server-side encryption key configuration for a customer provided encryption key specified for creating a Data Store. </p>
    ///   - [`preload_data_config(PreloadDataConfig)`](crate::client::fluent_builders::CreateFHIRDatastore::preload_data_config) / [`set_preload_data_config(Option<PreloadDataConfig>)`](crate::client::fluent_builders::CreateFHIRDatastore::set_preload_data_config): <p>Optional parameter to preload data upon creation of the Data Store. Currently, the only supported preloaded data is synthetic data generated from Synthea.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateFHIRDatastore::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateFHIRDatastore::set_client_token): <p>Optional user provided token used for ensuring idempotency.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateFHIRDatastore::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateFHIRDatastore::set_tags): <p> Resource tags that are applied to a Data Store when it is created. </p>
    /// - On success, responds with [`CreateFhirDatastoreOutput`](crate::output::CreateFhirDatastoreOutput) with field(s):
    ///   - [`datastore_id(Option<String>)`](crate::output::CreateFhirDatastoreOutput::datastore_id): <p>The AWS-generated Data Store id. This id is in the output from the initial Data Store creation call.</p>
    ///   - [`datastore_arn(Option<String>)`](crate::output::CreateFhirDatastoreOutput::datastore_arn): <p>The datastore ARN is generated during the creation of the Data Store and can be found in the output from the initial Data Store creation call.</p>
    ///   - [`datastore_status(Option<DatastoreStatus>)`](crate::output::CreateFhirDatastoreOutput::datastore_status): <p>The status of the FHIR Data Store. Possible statuses are ‘CREATING’, ‘ACTIVE’, ‘DELETING’, ‘DELETED’.</p>
    ///   - [`datastore_endpoint(Option<String>)`](crate::output::CreateFhirDatastoreOutput::datastore_endpoint): <p>The AWS endpoint for the created Data Store. For preview, only US-east-1 endpoints are supported.</p>
    /// - On failure, responds with [`SdkError<CreateFHIRDatastoreError>`](crate::error::CreateFHIRDatastoreError)
    pub fn create_fhir_datastore(&self) -> fluent_builders::CreateFHIRDatastore<C, M, R> {
        fluent_builders::CreateFHIRDatastore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFHIRDatastore`](crate::client::fluent_builders::DeleteFHIRDatastore) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`datastore_id(impl Into<String>)`](crate::client::fluent_builders::DeleteFHIRDatastore::datastore_id) / [`set_datastore_id(Option<String>)`](crate::client::fluent_builders::DeleteFHIRDatastore::set_datastore_id): <p> The AWS-generated ID for the Data Store to be deleted.</p>
    /// - On success, responds with [`DeleteFhirDatastoreOutput`](crate::output::DeleteFhirDatastoreOutput) with field(s):
    ///   - [`datastore_id(Option<String>)`](crate::output::DeleteFhirDatastoreOutput::datastore_id): <p>The AWS-generated ID for the Data Store to be deleted.</p>
    ///   - [`datastore_arn(Option<String>)`](crate::output::DeleteFhirDatastoreOutput::datastore_arn): <p>The Amazon Resource Name (ARN) that gives Amazon HealthLake access permission.</p>
    ///   - [`datastore_status(Option<DatastoreStatus>)`](crate::output::DeleteFhirDatastoreOutput::datastore_status): <p>The status of the Data Store that the user has requested to be deleted. </p>
    ///   - [`datastore_endpoint(Option<String>)`](crate::output::DeleteFhirDatastoreOutput::datastore_endpoint): <p>The AWS endpoint for the Data Store the user has requested to be deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteFHIRDatastoreError>`](crate::error::DeleteFHIRDatastoreError)
    pub fn delete_fhir_datastore(&self) -> fluent_builders::DeleteFHIRDatastore<C, M, R> {
        fluent_builders::DeleteFHIRDatastore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFHIRDatastore`](crate::client::fluent_builders::DescribeFHIRDatastore) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`datastore_id(impl Into<String>)`](crate::client::fluent_builders::DescribeFHIRDatastore::datastore_id) / [`set_datastore_id(Option<String>)`](crate::client::fluent_builders::DescribeFHIRDatastore::set_datastore_id): <p>The AWS-generated Data Store id. This is part of the ‘CreateFHIRDatastore’ output.</p>
    /// - On success, responds with [`DescribeFhirDatastoreOutput`](crate::output::DescribeFhirDatastoreOutput) with field(s):
    ///   - [`datastore_properties(Option<DatastoreProperties>)`](crate::output::DescribeFhirDatastoreOutput::datastore_properties): <p>All properties associated with a Data Store, including the Data Store ID, Data Store ARN, Data Store name, Data Store status, created at, Data Store type version, and Data Store endpoint.</p>
    /// - On failure, responds with [`SdkError<DescribeFHIRDatastoreError>`](crate::error::DescribeFHIRDatastoreError)
    pub fn describe_fhir_datastore(&self) -> fluent_builders::DescribeFHIRDatastore<C, M, R> {
        fluent_builders::DescribeFHIRDatastore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFHIRExportJob`](crate::client::fluent_builders::DescribeFHIRExportJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`datastore_id(impl Into<String>)`](crate::client::fluent_builders::DescribeFHIRExportJob::datastore_id) / [`set_datastore_id(Option<String>)`](crate::client::fluent_builders::DescribeFHIRExportJob::set_datastore_id): <p>The AWS generated ID for the Data Store from which files are being exported from for an export job.</p>
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DescribeFHIRExportJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DescribeFHIRExportJob::set_job_id): <p>The AWS generated ID for an export job.</p>
    /// - On success, responds with [`DescribeFhirExportJobOutput`](crate::output::DescribeFhirExportJobOutput) with field(s):
    ///   - [`export_job_properties(Option<ExportJobProperties>)`](crate::output::DescribeFhirExportJobOutput::export_job_properties): <p>Displays the properties of the export job, including the ID, Arn, Name, and the status of the job. </p>
    /// - On failure, responds with [`SdkError<DescribeFHIRExportJobError>`](crate::error::DescribeFHIRExportJobError)
    pub fn describe_fhir_export_job(&self) -> fluent_builders::DescribeFHIRExportJob<C, M, R> {
        fluent_builders::DescribeFHIRExportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFHIRImportJob`](crate::client::fluent_builders::DescribeFHIRImportJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`datastore_id(impl Into<String>)`](crate::client::fluent_builders::DescribeFHIRImportJob::datastore_id) / [`set_datastore_id(Option<String>)`](crate::client::fluent_builders::DescribeFHIRImportJob::set_datastore_id): <p>The AWS-generated ID of the Data Store.</p>
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DescribeFHIRImportJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DescribeFHIRImportJob::set_job_id): <p>The AWS-generated job ID.</p>
    /// - On success, responds with [`DescribeFhirImportJobOutput`](crate::output::DescribeFhirImportJobOutput) with field(s):
    ///   - [`import_job_properties(Option<ImportJobProperties>)`](crate::output::DescribeFhirImportJobOutput::import_job_properties): <p>The properties of the Import job request, including the ID, ARN, name, and the status of the job.</p>
    /// - On failure, responds with [`SdkError<DescribeFHIRImportJobError>`](crate::error::DescribeFHIRImportJobError)
    pub fn describe_fhir_import_job(&self) -> fluent_builders::DescribeFHIRImportJob<C, M, R> {
        fluent_builders::DescribeFHIRImportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFHIRDatastores`](crate::client::fluent_builders::ListFHIRDatastores) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFHIRDatastores::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter(DatastoreFilter)`](crate::client::fluent_builders::ListFHIRDatastores::filter) / [`set_filter(Option<DatastoreFilter>)`](crate::client::fluent_builders::ListFHIRDatastores::set_filter): <p>Lists all filters associated with a FHIR Data Store request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFHIRDatastores::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFHIRDatastores::set_next_token): <p>Fetches the next page of Data Stores when results are paginated.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFHIRDatastores::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListFHIRDatastores::set_max_results): <p>The maximum number of Data Stores returned in a single page of a ListFHIRDatastoresRequest call.</p>
    /// - On success, responds with [`ListFhirDatastoresOutput`](crate::output::ListFhirDatastoresOutput) with field(s):
    ///   - [`datastore_properties_list(Option<Vec<DatastoreProperties>>)`](crate::output::ListFhirDatastoresOutput::datastore_properties_list): <p>All properties associated with the listed Data Stores.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListFhirDatastoresOutput::next_token): <p>Pagination token that can be used to retrieve the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListFHIRDatastoresError>`](crate::error::ListFHIRDatastoresError)
    pub fn list_fhir_datastores(&self) -> fluent_builders::ListFHIRDatastores<C, M, R> {
        fluent_builders::ListFHIRDatastores::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFHIRExportJobs`](crate::client::fluent_builders::ListFHIRExportJobs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFHIRExportJobs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`datastore_id(impl Into<String>)`](crate::client::fluent_builders::ListFHIRExportJobs::datastore_id) / [`set_datastore_id(Option<String>)`](crate::client::fluent_builders::ListFHIRExportJobs::set_datastore_id): <p> This parameter limits the response to the export job with the specified Data Store ID. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFHIRExportJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFHIRExportJobs::set_next_token): <p> A pagination token used to identify the next page of results to return for a ListFHIRExportJobs query. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFHIRExportJobs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListFHIRExportJobs::set_max_results): <p> This parameter limits the number of results returned for a ListFHIRExportJobs to a maximum quantity specified by the user. </p>
    ///   - [`job_name(impl Into<String>)`](crate::client::fluent_builders::ListFHIRExportJobs::job_name) / [`set_job_name(Option<String>)`](crate::client::fluent_builders::ListFHIRExportJobs::set_job_name): <p> This parameter limits the response to the export job with the specified job name. </p>
    ///   - [`job_status(JobStatus)`](crate::client::fluent_builders::ListFHIRExportJobs::job_status) / [`set_job_status(Option<JobStatus>)`](crate::client::fluent_builders::ListFHIRExportJobs::set_job_status): <p> This parameter limits the response to the export jobs with the specified job status. </p>
    ///   - [`submitted_before(DateTime)`](crate::client::fluent_builders::ListFHIRExportJobs::submitted_before) / [`set_submitted_before(Option<DateTime>)`](crate::client::fluent_builders::ListFHIRExportJobs::set_submitted_before): <p> This parameter limits the response to FHIR export jobs submitted before a user specified date. </p>
    ///   - [`submitted_after(DateTime)`](crate::client::fluent_builders::ListFHIRExportJobs::submitted_after) / [`set_submitted_after(Option<DateTime>)`](crate::client::fluent_builders::ListFHIRExportJobs::set_submitted_after): <p> This parameter limits the response to FHIR export jobs submitted after a user specified date. </p>
    /// - On success, responds with [`ListFhirExportJobsOutput`](crate::output::ListFhirExportJobsOutput) with field(s):
    ///   - [`export_job_properties_list(Option<Vec<ExportJobProperties>>)`](crate::output::ListFhirExportJobsOutput::export_job_properties_list): <p> The properties of listed FHIR export jobs, including the ID, ARN, name, and the status of the job. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListFhirExportJobsOutput::next_token): <p> A pagination token used to identify the next page of results to return for a ListFHIRExportJobs query. </p>
    /// - On failure, responds with [`SdkError<ListFHIRExportJobsError>`](crate::error::ListFHIRExportJobsError)
    pub fn list_fhir_export_jobs(&self) -> fluent_builders::ListFHIRExportJobs<C, M, R> {
        fluent_builders::ListFHIRExportJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFHIRImportJobs`](crate::client::fluent_builders::ListFHIRImportJobs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFHIRImportJobs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`datastore_id(impl Into<String>)`](crate::client::fluent_builders::ListFHIRImportJobs::datastore_id) / [`set_datastore_id(Option<String>)`](crate::client::fluent_builders::ListFHIRImportJobs::set_datastore_id): <p> This parameter limits the response to the import job with the specified Data Store ID. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFHIRImportJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFHIRImportJobs::set_next_token): <p> A pagination token used to identify the next page of results to return for a ListFHIRImportJobs query. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFHIRImportJobs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListFHIRImportJobs::set_max_results): <p> This parameter limits the number of results returned for a ListFHIRImportJobs to a maximum quantity specified by the user. </p>
    ///   - [`job_name(impl Into<String>)`](crate::client::fluent_builders::ListFHIRImportJobs::job_name) / [`set_job_name(Option<String>)`](crate::client::fluent_builders::ListFHIRImportJobs::set_job_name): <p> This parameter limits the response to the import job with the specified job name. </p>
    ///   - [`job_status(JobStatus)`](crate::client::fluent_builders::ListFHIRImportJobs::job_status) / [`set_job_status(Option<JobStatus>)`](crate::client::fluent_builders::ListFHIRImportJobs::set_job_status): <p> This parameter limits the response to the import job with the specified job status. </p>
    ///   - [`submitted_before(DateTime)`](crate::client::fluent_builders::ListFHIRImportJobs::submitted_before) / [`set_submitted_before(Option<DateTime>)`](crate::client::fluent_builders::ListFHIRImportJobs::set_submitted_before): <p> This parameter limits the response to FHIR import jobs submitted before a user specified date. </p>
    ///   - [`submitted_after(DateTime)`](crate::client::fluent_builders::ListFHIRImportJobs::submitted_after) / [`set_submitted_after(Option<DateTime>)`](crate::client::fluent_builders::ListFHIRImportJobs::set_submitted_after): <p> This parameter limits the response to FHIR import jobs submitted after a user specified date. </p>
    /// - On success, responds with [`ListFhirImportJobsOutput`](crate::output::ListFhirImportJobsOutput) with field(s):
    ///   - [`import_job_properties_list(Option<Vec<ImportJobProperties>>)`](crate::output::ListFhirImportJobsOutput::import_job_properties_list): <p> The properties of a listed FHIR import jobs, including the ID, ARN, name, and the status of the job. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListFhirImportJobsOutput::next_token): <p> A pagination token used to identify the next page of results to return for a ListFHIRImportJobs query. </p>
    /// - On failure, responds with [`SdkError<ListFHIRImportJobsError>`](crate::error::ListFHIRImportJobsError)
    pub fn list_fhir_import_jobs(&self) -> fluent_builders::ListFHIRImportJobs<C, M, R> {
        fluent_builders::ListFHIRImportJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p> The Amazon Resource Name(ARN) of the Data Store for which tags are being added. </p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p> Returns a list of tags associated with a Data Store. </p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartFHIRExportJob`](crate::client::fluent_builders::StartFHIRExportJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_name(impl Into<String>)`](crate::client::fluent_builders::StartFHIRExportJob::job_name) / [`set_job_name(Option<String>)`](crate::client::fluent_builders::StartFHIRExportJob::set_job_name): <p>The user generated name for an export job.</p>
    ///   - [`output_data_config(OutputDataConfig)`](crate::client::fluent_builders::StartFHIRExportJob::output_data_config) / [`set_output_data_config(Option<OutputDataConfig>)`](crate::client::fluent_builders::StartFHIRExportJob::set_output_data_config): <p>The output data configuration that was supplied when the export job was created.</p>
    ///   - [`datastore_id(impl Into<String>)`](crate::client::fluent_builders::StartFHIRExportJob::datastore_id) / [`set_datastore_id(Option<String>)`](crate::client::fluent_builders::StartFHIRExportJob::set_datastore_id): <p>The AWS generated ID for the Data Store from which files are being exported for an export job.</p>
    ///   - [`data_access_role_arn(impl Into<String>)`](crate::client::fluent_builders::StartFHIRExportJob::data_access_role_arn) / [`set_data_access_role_arn(Option<String>)`](crate::client::fluent_builders::StartFHIRExportJob::set_data_access_role_arn): <p>The Amazon Resource Name used during the initiation of the job.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::StartFHIRExportJob::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::StartFHIRExportJob::set_client_token): <p>An optional user provided token used for ensuring idempotency.</p>
    /// - On success, responds with [`StartFhirExportJobOutput`](crate::output::StartFhirExportJobOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StartFhirExportJobOutput::job_id): <p>The AWS generated ID for an export job.</p>
    ///   - [`job_status(Option<JobStatus>)`](crate::output::StartFhirExportJobOutput::job_status): <p>The status of a FHIR export job. Possible statuses are SUBMITTED, IN_PROGRESS, COMPLETED, or FAILED.</p>
    ///   - [`datastore_id(Option<String>)`](crate::output::StartFhirExportJobOutput::datastore_id): <p>The AWS generated ID for the Data Store from which files are being exported for an export job.</p>
    /// - On failure, responds with [`SdkError<StartFHIRExportJobError>`](crate::error::StartFHIRExportJobError)
    pub fn start_fhir_export_job(&self) -> fluent_builders::StartFHIRExportJob<C, M, R> {
        fluent_builders::StartFHIRExportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartFHIRImportJob`](crate::client::fluent_builders::StartFHIRImportJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_name(impl Into<String>)`](crate::client::fluent_builders::StartFHIRImportJob::job_name) / [`set_job_name(Option<String>)`](crate::client::fluent_builders::StartFHIRImportJob::set_job_name): <p>The name of the FHIR Import job in the StartFHIRImport job request.</p>
    ///   - [`input_data_config(InputDataConfig)`](crate::client::fluent_builders::StartFHIRImportJob::input_data_config) / [`set_input_data_config(Option<InputDataConfig>)`](crate::client::fluent_builders::StartFHIRImportJob::set_input_data_config): <p>The input properties of the FHIR Import job in the StartFHIRImport job request.</p>
    ///   - [`job_output_data_config(OutputDataConfig)`](crate::client::fluent_builders::StartFHIRImportJob::job_output_data_config) / [`set_job_output_data_config(Option<OutputDataConfig>)`](crate::client::fluent_builders::StartFHIRImportJob::set_job_output_data_config): <p>The output data configuration that was supplied when the export job was created.</p>
    ///   - [`datastore_id(impl Into<String>)`](crate::client::fluent_builders::StartFHIRImportJob::datastore_id) / [`set_datastore_id(Option<String>)`](crate::client::fluent_builders::StartFHIRImportJob::set_datastore_id): <p>The AWS-generated Data Store ID.</p>
    ///   - [`data_access_role_arn(impl Into<String>)`](crate::client::fluent_builders::StartFHIRImportJob::data_access_role_arn) / [`set_data_access_role_arn(Option<String>)`](crate::client::fluent_builders::StartFHIRImportJob::set_data_access_role_arn): <p>The Amazon Resource Name (ARN) that gives Amazon HealthLake access permission.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::StartFHIRImportJob::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::StartFHIRImportJob::set_client_token): <p>Optional user provided token used for ensuring idempotency.</p>
    /// - On success, responds with [`StartFhirImportJobOutput`](crate::output::StartFhirImportJobOutput) with field(s):
    ///   - [`job_id(Option<String>)`](crate::output::StartFhirImportJobOutput::job_id): <p>The AWS-generated job ID.</p>
    ///   - [`job_status(Option<JobStatus>)`](crate::output::StartFhirImportJobOutput::job_status): <p>The status of an import job.</p>
    ///   - [`datastore_id(Option<String>)`](crate::output::StartFhirImportJobOutput::datastore_id): <p>The AWS-generated Data Store ID.</p>
    /// - On failure, responds with [`SdkError<StartFHIRImportJobError>`](crate::error::StartFHIRImportJobError)
    pub fn start_fhir_import_job(&self) -> fluent_builders::StartFHIRImportJob<C, M, R> {
        fluent_builders::StartFHIRImportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p> The Amazon Resource Name(ARN)that gives Amazon HealthLake access to the Data Store which tags are being added to. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p> The user specified key and value pair tags being added to a Data Store. </p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p> "The Amazon Resource Name(ARN) of the Data Store for which tags are being removed </p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p> The keys for the tags to be removed from the Healthlake Data Store. </p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateFHIRDatastore`.
    ///
    /// <p>Creates a Data Store that can ingest and export FHIR formatted data.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFHIRDatastore<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_fhir_datastore_input::Builder,
    }
    impl<C, M, R> CreateFHIRDatastore<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFHIRDatastore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFhirDatastoreOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFHIRDatastoreError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFhirDatastoreInputOperationOutputAlias,
                crate::output::CreateFhirDatastoreOutput,
                crate::error::CreateFHIRDatastoreError,
                crate::input::CreateFhirDatastoreInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user generated name for the Data Store.</p>
        pub fn datastore_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.datastore_name(input.into());
            self
        }
        /// <p>The user generated name for the Data Store.</p>
        pub fn set_datastore_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_datastore_name(input);
            self
        }
        /// <p>The FHIR version of the Data Store. The only supported version is R4.</p>
        pub fn datastore_type_version(mut self, input: crate::model::FhirVersion) -> Self {
            self.inner = self.inner.datastore_type_version(input);
            self
        }
        /// <p>The FHIR version of the Data Store. The only supported version is R4.</p>
        pub fn set_datastore_type_version(
            mut self,
            input: std::option::Option<crate::model::FhirVersion>,
        ) -> Self {
            self.inner = self.inner.set_datastore_type_version(input);
            self
        }
        /// <p> The server-side encryption key configuration for a customer provided encryption key specified for creating a Data Store. </p>
        pub fn sse_configuration(mut self, input: crate::model::SseConfiguration) -> Self {
            self.inner = self.inner.sse_configuration(input);
            self
        }
        /// <p> The server-side encryption key configuration for a customer provided encryption key specified for creating a Data Store. </p>
        pub fn set_sse_configuration(
            mut self,
            input: std::option::Option<crate::model::SseConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_sse_configuration(input);
            self
        }
        /// <p>Optional parameter to preload data upon creation of the Data Store. Currently, the only supported preloaded data is synthetic data generated from Synthea.</p>
        pub fn preload_data_config(mut self, input: crate::model::PreloadDataConfig) -> Self {
            self.inner = self.inner.preload_data_config(input);
            self
        }
        /// <p>Optional parameter to preload data upon creation of the Data Store. Currently, the only supported preloaded data is synthetic data generated from Synthea.</p>
        pub fn set_preload_data_config(
            mut self,
            input: std::option::Option<crate::model::PreloadDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_preload_data_config(input);
            self
        }
        /// <p>Optional user provided token used for ensuring idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Optional user provided token used for ensuring idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> Resource tags that are applied to a Data Store when it is created. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p> Resource tags that are applied to a Data Store when it is created. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFHIRDatastore`.
    ///
    /// <p>Deletes a Data Store. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFHIRDatastore<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_fhir_datastore_input::Builder,
    }
    impl<C, M, R> DeleteFHIRDatastore<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFHIRDatastore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFhirDatastoreOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFHIRDatastoreError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFhirDatastoreInputOperationOutputAlias,
                crate::output::DeleteFhirDatastoreOutput,
                crate::error::DeleteFHIRDatastoreError,
                crate::input::DeleteFhirDatastoreInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The AWS-generated ID for the Data Store to be deleted.</p>
        pub fn datastore_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.datastore_id(input.into());
            self
        }
        /// <p> The AWS-generated ID for the Data Store to be deleted.</p>
        pub fn set_datastore_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_datastore_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFHIRDatastore`.
    ///
    /// <p>Gets the properties associated with the FHIR Data Store, including the Data Store ID, Data Store ARN, Data Store name, Data Store status, created at, Data Store type version, and Data Store endpoint.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeFHIRDatastore<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_fhir_datastore_input::Builder,
    }
    impl<C, M, R> DescribeFHIRDatastore<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFHIRDatastore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFhirDatastoreOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFHIRDatastoreError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFhirDatastoreInputOperationOutputAlias,
                crate::output::DescribeFhirDatastoreOutput,
                crate::error::DescribeFHIRDatastoreError,
                crate::input::DescribeFhirDatastoreInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS-generated Data Store id. This is part of the ‘CreateFHIRDatastore’ output.</p>
        pub fn datastore_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.datastore_id(input.into());
            self
        }
        /// <p>The AWS-generated Data Store id. This is part of the ‘CreateFHIRDatastore’ output.</p>
        pub fn set_datastore_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_datastore_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFHIRExportJob`.
    ///
    /// <p>Displays the properties of a FHIR export job, including the ID, ARN, name, and the status of the job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeFHIRExportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_fhir_export_job_input::Builder,
    }
    impl<C, M, R> DescribeFHIRExportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFHIRExportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFhirExportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFHIRExportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFhirExportJobInputOperationOutputAlias,
                crate::output::DescribeFhirExportJobOutput,
                crate::error::DescribeFHIRExportJobError,
                crate::input::DescribeFhirExportJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS generated ID for the Data Store from which files are being exported from for an export job.</p>
        pub fn datastore_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.datastore_id(input.into());
            self
        }
        /// <p>The AWS generated ID for the Data Store from which files are being exported from for an export job.</p>
        pub fn set_datastore_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_datastore_id(input);
            self
        }
        /// <p>The AWS generated ID for an export job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The AWS generated ID for an export job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFHIRImportJob`.
    ///
    /// <p>Displays the properties of a FHIR import job, including the ID, ARN, name, and the status of the job. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeFHIRImportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_fhir_import_job_input::Builder,
    }
    impl<C, M, R> DescribeFHIRImportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFHIRImportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFhirImportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFHIRImportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFhirImportJobInputOperationOutputAlias,
                crate::output::DescribeFhirImportJobOutput,
                crate::error::DescribeFHIRImportJobError,
                crate::input::DescribeFhirImportJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS-generated ID of the Data Store.</p>
        pub fn datastore_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.datastore_id(input.into());
            self
        }
        /// <p>The AWS-generated ID of the Data Store.</p>
        pub fn set_datastore_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_datastore_id(input);
            self
        }
        /// <p>The AWS-generated job ID.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The AWS-generated job ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFHIRDatastores`.
    ///
    /// <p>Lists all FHIR Data Stores that are in the user’s account, regardless of Data Store status.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFHIRDatastores<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_fhir_datastores_input::Builder,
    }
    impl<C, M, R> ListFHIRDatastores<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFHIRDatastores`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFhirDatastoresOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFHIRDatastoresError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFhirDatastoresInputOperationOutputAlias,
                crate::output::ListFhirDatastoresOutput,
                crate::error::ListFHIRDatastoresError,
                crate::input::ListFhirDatastoresInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFhirDatastoresPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFhirDatastoresPaginator<C, M, R> {
            crate::paginator::ListFhirDatastoresPaginator::new(self.handle, self.inner)
        }
        /// <p>Lists all filters associated with a FHIR Data Store request.</p>
        pub fn filter(mut self, input: crate::model::DatastoreFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Lists all filters associated with a FHIR Data Store request.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::DatastoreFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>Fetches the next page of Data Stores when results are paginated.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Fetches the next page of Data Stores when results are paginated.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of Data Stores returned in a single page of a ListFHIRDatastoresRequest call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of Data Stores returned in a single page of a ListFHIRDatastoresRequest call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFHIRExportJobs`.
    ///
    /// <p> Lists all FHIR export jobs associated with an account and their statuses. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFHIRExportJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_fhir_export_jobs_input::Builder,
    }
    impl<C, M, R> ListFHIRExportJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFHIRExportJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFhirExportJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFHIRExportJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFhirExportJobsInputOperationOutputAlias,
                crate::output::ListFhirExportJobsOutput,
                crate::error::ListFHIRExportJobsError,
                crate::input::ListFhirExportJobsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFhirExportJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFhirExportJobsPaginator<C, M, R> {
            crate::paginator::ListFhirExportJobsPaginator::new(self.handle, self.inner)
        }
        /// <p> This parameter limits the response to the export job with the specified Data Store ID. </p>
        pub fn datastore_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.datastore_id(input.into());
            self
        }
        /// <p> This parameter limits the response to the export job with the specified Data Store ID. </p>
        pub fn set_datastore_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_datastore_id(input);
            self
        }
        /// <p> A pagination token used to identify the next page of results to return for a ListFHIRExportJobs query. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> A pagination token used to identify the next page of results to return for a ListFHIRExportJobs query. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> This parameter limits the number of results returned for a ListFHIRExportJobs to a maximum quantity specified by the user. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> This parameter limits the number of results returned for a ListFHIRExportJobs to a maximum quantity specified by the user. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> This parameter limits the response to the export job with the specified job name. </p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(input.into());
            self
        }
        /// <p> This parameter limits the response to the export job with the specified job name. </p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p> This parameter limits the response to the export jobs with the specified job status. </p>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.inner = self.inner.job_status(input);
            self
        }
        /// <p> This parameter limits the response to the export jobs with the specified job status. </p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.inner = self.inner.set_job_status(input);
            self
        }
        /// <p> This parameter limits the response to FHIR export jobs submitted before a user specified date. </p>
        pub fn submitted_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.submitted_before(input);
            self
        }
        /// <p> This parameter limits the response to FHIR export jobs submitted before a user specified date. </p>
        pub fn set_submitted_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_submitted_before(input);
            self
        }
        /// <p> This parameter limits the response to FHIR export jobs submitted after a user specified date. </p>
        pub fn submitted_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.submitted_after(input);
            self
        }
        /// <p> This parameter limits the response to FHIR export jobs submitted after a user specified date. </p>
        pub fn set_submitted_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_submitted_after(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFHIRImportJobs`.
    ///
    /// <p> Lists all FHIR import jobs associated with an account and their statuses. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFHIRImportJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_fhir_import_jobs_input::Builder,
    }
    impl<C, M, R> ListFHIRImportJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFHIRImportJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFhirImportJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFHIRImportJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFhirImportJobsInputOperationOutputAlias,
                crate::output::ListFhirImportJobsOutput,
                crate::error::ListFHIRImportJobsError,
                crate::input::ListFhirImportJobsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFhirImportJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFhirImportJobsPaginator<C, M, R> {
            crate::paginator::ListFhirImportJobsPaginator::new(self.handle, self.inner)
        }
        /// <p> This parameter limits the response to the import job with the specified Data Store ID. </p>
        pub fn datastore_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.datastore_id(input.into());
            self
        }
        /// <p> This parameter limits the response to the import job with the specified Data Store ID. </p>
        pub fn set_datastore_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_datastore_id(input);
            self
        }
        /// <p> A pagination token used to identify the next page of results to return for a ListFHIRImportJobs query. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> A pagination token used to identify the next page of results to return for a ListFHIRImportJobs query. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> This parameter limits the number of results returned for a ListFHIRImportJobs to a maximum quantity specified by the user. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> This parameter limits the number of results returned for a ListFHIRImportJobs to a maximum quantity specified by the user. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> This parameter limits the response to the import job with the specified job name. </p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(input.into());
            self
        }
        /// <p> This parameter limits the response to the import job with the specified job name. </p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p> This parameter limits the response to the import job with the specified job status. </p>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.inner = self.inner.job_status(input);
            self
        }
        /// <p> This parameter limits the response to the import job with the specified job status. </p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.inner = self.inner.set_job_status(input);
            self
        }
        /// <p> This parameter limits the response to FHIR import jobs submitted before a user specified date. </p>
        pub fn submitted_before(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.submitted_before(input);
            self
        }
        /// <p> This parameter limits the response to FHIR import jobs submitted before a user specified date. </p>
        pub fn set_submitted_before(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_submitted_before(input);
            self
        }
        /// <p> This parameter limits the response to FHIR import jobs submitted after a user specified date. </p>
        pub fn submitted_after(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.submitted_after(input);
            self
        }
        /// <p> This parameter limits the response to FHIR import jobs submitted after a user specified date. </p>
        pub fn set_submitted_after(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_submitted_after(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p> Returns a list of all existing tags associated with a Data Store. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name(ARN) of the Data Store for which tags are being added. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name(ARN) of the Data Store for which tags are being added. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartFHIRExportJob`.
    ///
    /// <p>Begins a FHIR export job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartFHIRExportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_fhir_export_job_input::Builder,
    }
    impl<C, M, R> StartFHIRExportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartFHIRExportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartFhirExportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartFHIRExportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartFhirExportJobInputOperationOutputAlias,
                crate::output::StartFhirExportJobOutput,
                crate::error::StartFHIRExportJobError,
                crate::input::StartFhirExportJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user generated name for an export job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(input.into());
            self
        }
        /// <p>The user generated name for an export job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The output data configuration that was supplied when the export job was created.</p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.inner = self.inner.output_data_config(input);
            self
        }
        /// <p>The output data configuration that was supplied when the export job was created.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_data_config(input);
            self
        }
        /// <p>The AWS generated ID for the Data Store from which files are being exported for an export job.</p>
        pub fn datastore_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.datastore_id(input.into());
            self
        }
        /// <p>The AWS generated ID for the Data Store from which files are being exported for an export job.</p>
        pub fn set_datastore_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_datastore_id(input);
            self
        }
        /// <p>The Amazon Resource Name used during the initiation of the job.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name used during the initiation of the job.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
        /// <p>An optional user provided token used for ensuring idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>An optional user provided token used for ensuring idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartFHIRImportJob`.
    ///
    /// <p>Begins a FHIR Import job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartFHIRImportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_fhir_import_job_input::Builder,
    }
    impl<C, M, R> StartFHIRImportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartFHIRImportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartFhirImportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartFHIRImportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartFhirImportJobInputOperationOutputAlias,
                crate::output::StartFhirImportJobOutput,
                crate::error::StartFHIRImportJobError,
                crate::input::StartFhirImportJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the FHIR Import job in the StartFHIRImport job request.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(input.into());
            self
        }
        /// <p>The name of the FHIR Import job in the StartFHIRImport job request.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The input properties of the FHIR Import job in the StartFHIRImport job request.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.inner = self.inner.input_data_config(input);
            self
        }
        /// <p>The input properties of the FHIR Import job in the StartFHIRImport job request.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p>The output data configuration that was supplied when the export job was created.</p>
        pub fn job_output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.inner = self.inner.job_output_data_config(input);
            self
        }
        /// <p>The output data configuration that was supplied when the export job was created.</p>
        pub fn set_job_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_job_output_data_config(input);
            self
        }
        /// <p>The AWS-generated Data Store ID.</p>
        pub fn datastore_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.datastore_id(input.into());
            self
        }
        /// <p>The AWS-generated Data Store ID.</p>
        pub fn set_datastore_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_datastore_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that gives Amazon HealthLake access permission.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that gives Amazon HealthLake access permission.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
        /// <p>Optional user provided token used for ensuring idempotency.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Optional user provided token used for ensuring idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p> Adds a user specifed key and value tag to a Data Store. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name(ARN)that gives Amazon HealthLake access to the Data Store which tags are being added to. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name(ARN)that gives Amazon HealthLake access to the Data Store which tags are being added to. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The user specified key and value pair tags being added to a Data Store. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p> The user specified key and value pair tags being added to a Data Store. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p> Removes tags from a Data Store. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> "The Amazon Resource Name(ARN) of the Data Store for which tags are being removed </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p> "The Amazon Resource Name(ARN) of the Data Store for which tags are being removed </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p> The keys for the tags to be removed from the Healthlake Data Store. </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p> The keys for the tags to be removed from the Healthlake Data Store. </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
