// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartFhirImportJobOutput {
    /// <p>The AWS-generated job ID.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The status of an import job.</p>
    pub job_status: std::option::Option<crate::model::JobStatus>,
    /// <p>The AWS-generated Data Store ID.</p>
    pub datastore_id: std::option::Option<std::string::String>,
}
impl StartFhirImportJobOutput {
    /// <p>The AWS-generated job ID.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The status of an import job.</p>
    pub fn job_status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.job_status.as_ref()
    }
    /// <p>The AWS-generated Data Store ID.</p>
    pub fn datastore_id(&self) -> std::option::Option<&str> {
        self.datastore_id.as_deref()
    }
}
impl std::fmt::Debug for StartFhirImportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartFhirImportJobOutput");
        formatter.field("job_id", &self.job_id);
        formatter.field("job_status", &self.job_status);
        formatter.field("datastore_id", &self.datastore_id);
        formatter.finish()
    }
}
/// See [`StartFhirImportJobOutput`](crate::output::StartFhirImportJobOutput)
pub mod start_fhir_import_job_output {
    /// A builder for [`StartFhirImportJobOutput`](crate::output::StartFhirImportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
        pub(crate) datastore_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AWS-generated job ID.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The AWS-generated job ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The status of an import job.</p>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>The status of an import job.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>The AWS-generated Data Store ID.</p>
        pub fn datastore_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.datastore_id = Some(input.into());
            self
        }
        /// <p>The AWS-generated Data Store ID.</p>
        pub fn set_datastore_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.datastore_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartFhirImportJobOutput`](crate::output::StartFhirImportJobOutput)
        pub fn build(self) -> crate::output::StartFhirImportJobOutput {
            crate::output::StartFhirImportJobOutput {
                job_id: self.job_id,
                job_status: self.job_status,
                datastore_id: self.datastore_id,
            }
        }
    }
}
impl StartFhirImportJobOutput {
    /// Creates a new builder-style object to manufacture [`StartFhirImportJobOutput`](crate::output::StartFhirImportJobOutput)
    pub fn builder() -> crate::output::start_fhir_import_job_output::Builder {
        crate::output::start_fhir_import_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartFhirExportJobOutput {
    /// <p>The AWS generated ID for an export job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The status of a FHIR export job. Possible statuses are SUBMITTED, IN_PROGRESS, COMPLETED, or FAILED.</p>
    pub job_status: std::option::Option<crate::model::JobStatus>,
    /// <p>The AWS generated ID for the Data Store from which files are being exported for an export job.</p>
    pub datastore_id: std::option::Option<std::string::String>,
}
impl StartFhirExportJobOutput {
    /// <p>The AWS generated ID for an export job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The status of a FHIR export job. Possible statuses are SUBMITTED, IN_PROGRESS, COMPLETED, or FAILED.</p>
    pub fn job_status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.job_status.as_ref()
    }
    /// <p>The AWS generated ID for the Data Store from which files are being exported for an export job.</p>
    pub fn datastore_id(&self) -> std::option::Option<&str> {
        self.datastore_id.as_deref()
    }
}
impl std::fmt::Debug for StartFhirExportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartFhirExportJobOutput");
        formatter.field("job_id", &self.job_id);
        formatter.field("job_status", &self.job_status);
        formatter.field("datastore_id", &self.datastore_id);
        formatter.finish()
    }
}
/// See [`StartFhirExportJobOutput`](crate::output::StartFhirExportJobOutput)
pub mod start_fhir_export_job_output {
    /// A builder for [`StartFhirExportJobOutput`](crate::output::StartFhirExportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
        pub(crate) datastore_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AWS generated ID for an export job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The AWS generated ID for an export job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The status of a FHIR export job. Possible statuses are SUBMITTED, IN_PROGRESS, COMPLETED, or FAILED.</p>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>The status of a FHIR export job. Possible statuses are SUBMITTED, IN_PROGRESS, COMPLETED, or FAILED.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>The AWS generated ID for the Data Store from which files are being exported for an export job.</p>
        pub fn datastore_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.datastore_id = Some(input.into());
            self
        }
        /// <p>The AWS generated ID for the Data Store from which files are being exported for an export job.</p>
        pub fn set_datastore_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.datastore_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartFhirExportJobOutput`](crate::output::StartFhirExportJobOutput)
        pub fn build(self) -> crate::output::StartFhirExportJobOutput {
            crate::output::StartFhirExportJobOutput {
                job_id: self.job_id,
                job_status: self.job_status,
                datastore_id: self.datastore_id,
            }
        }
    }
}
impl StartFhirExportJobOutput {
    /// Creates a new builder-style object to manufacture [`StartFhirExportJobOutput`](crate::output::StartFhirExportJobOutput)
    pub fn builder() -> crate::output::start_fhir_export_job_output::Builder {
        crate::output::start_fhir_export_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>
    /// Returns a list of tags associated with a Data Store.
    /// </p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ListTagsForResourceOutput {
    /// <p>
    /// Returns a list of tags associated with a Data Store.
    /// </p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>
        /// Returns a list of tags associated with a Data Store.
        /// </p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>
        /// Returns a list of tags associated with a Data Store.
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFhirImportJobsOutput {
    /// <p>
    /// The properties of a listed FHIR import jobs, including the ID, ARN, name, and the status of the job.
    /// </p>
    pub import_job_properties_list:
        std::option::Option<std::vec::Vec<crate::model::ImportJobProperties>>,
    /// <p>
    /// A pagination token used to identify the next page of results to return for a ListFHIRImportJobs query.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFhirImportJobsOutput {
    /// <p>
    /// The properties of a listed FHIR import jobs, including the ID, ARN, name, and the status of the job.
    /// </p>
    pub fn import_job_properties_list(
        &self,
    ) -> std::option::Option<&[crate::model::ImportJobProperties]> {
        self.import_job_properties_list.as_deref()
    }
    /// <p>
    /// A pagination token used to identify the next page of results to return for a ListFHIRImportJobs query.
    /// </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFhirImportJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFhirImportJobsOutput");
        formatter.field(
            "import_job_properties_list",
            &self.import_job_properties_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListFhirImportJobsOutput`](crate::output::ListFhirImportJobsOutput)
pub mod list_fhir_import_jobs_output {
    /// A builder for [`ListFhirImportJobsOutput`](crate::output::ListFhirImportJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) import_job_properties_list:
            std::option::Option<std::vec::Vec<crate::model::ImportJobProperties>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `import_job_properties_list`.
        ///
        /// To override the contents of this collection use [`set_import_job_properties_list`](Self::set_import_job_properties_list).
        ///
        /// <p>
        /// The properties of a listed FHIR import jobs, including the ID, ARN, name, and the status of the job.
        /// </p>
        pub fn import_job_properties_list(
            mut self,
            input: impl Into<crate::model::ImportJobProperties>,
        ) -> Self {
            let mut v = self.import_job_properties_list.unwrap_or_default();
            v.push(input.into());
            self.import_job_properties_list = Some(v);
            self
        }
        /// <p>
        /// The properties of a listed FHIR import jobs, including the ID, ARN, name, and the status of the job.
        /// </p>
        pub fn set_import_job_properties_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImportJobProperties>>,
        ) -> Self {
            self.import_job_properties_list = input;
            self
        }
        /// <p>
        /// A pagination token used to identify the next page of results to return for a ListFHIRImportJobs query.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// A pagination token used to identify the next page of results to return for a ListFHIRImportJobs query.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFhirImportJobsOutput`](crate::output::ListFhirImportJobsOutput)
        pub fn build(self) -> crate::output::ListFhirImportJobsOutput {
            crate::output::ListFhirImportJobsOutput {
                import_job_properties_list: self.import_job_properties_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListFhirImportJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListFhirImportJobsOutput`](crate::output::ListFhirImportJobsOutput)
    pub fn builder() -> crate::output::list_fhir_import_jobs_output::Builder {
        crate::output::list_fhir_import_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFhirExportJobsOutput {
    /// <p>
    /// The properties of listed FHIR export jobs, including the ID, ARN, name, and the status of the job.
    /// </p>
    pub export_job_properties_list:
        std::option::Option<std::vec::Vec<crate::model::ExportJobProperties>>,
    /// <p>
    /// A pagination token used to identify the next page of results to return for a ListFHIRExportJobs query.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFhirExportJobsOutput {
    /// <p>
    /// The properties of listed FHIR export jobs, including the ID, ARN, name, and the status of the job.
    /// </p>
    pub fn export_job_properties_list(
        &self,
    ) -> std::option::Option<&[crate::model::ExportJobProperties]> {
        self.export_job_properties_list.as_deref()
    }
    /// <p>
    /// A pagination token used to identify the next page of results to return for a ListFHIRExportJobs query.
    /// </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFhirExportJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFhirExportJobsOutput");
        formatter.field(
            "export_job_properties_list",
            &self.export_job_properties_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListFhirExportJobsOutput`](crate::output::ListFhirExportJobsOutput)
pub mod list_fhir_export_jobs_output {
    /// A builder for [`ListFhirExportJobsOutput`](crate::output::ListFhirExportJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_job_properties_list:
            std::option::Option<std::vec::Vec<crate::model::ExportJobProperties>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `export_job_properties_list`.
        ///
        /// To override the contents of this collection use [`set_export_job_properties_list`](Self::set_export_job_properties_list).
        ///
        /// <p>
        /// The properties of listed FHIR export jobs, including the ID, ARN, name, and the status of the job.
        /// </p>
        pub fn export_job_properties_list(
            mut self,
            input: impl Into<crate::model::ExportJobProperties>,
        ) -> Self {
            let mut v = self.export_job_properties_list.unwrap_or_default();
            v.push(input.into());
            self.export_job_properties_list = Some(v);
            self
        }
        /// <p>
        /// The properties of listed FHIR export jobs, including the ID, ARN, name, and the status of the job.
        /// </p>
        pub fn set_export_job_properties_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExportJobProperties>>,
        ) -> Self {
            self.export_job_properties_list = input;
            self
        }
        /// <p>
        /// A pagination token used to identify the next page of results to return for a ListFHIRExportJobs query.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// A pagination token used to identify the next page of results to return for a ListFHIRExportJobs query.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFhirExportJobsOutput`](crate::output::ListFhirExportJobsOutput)
        pub fn build(self) -> crate::output::ListFhirExportJobsOutput {
            crate::output::ListFhirExportJobsOutput {
                export_job_properties_list: self.export_job_properties_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListFhirExportJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListFhirExportJobsOutput`](crate::output::ListFhirExportJobsOutput)
    pub fn builder() -> crate::output::list_fhir_export_jobs_output::Builder {
        crate::output::list_fhir_export_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFhirDatastoresOutput {
    /// <p>All properties associated with the listed Data Stores.</p>
    pub datastore_properties_list:
        std::option::Option<std::vec::Vec<crate::model::DatastoreProperties>>,
    /// <p>Pagination token that can be used to retrieve the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFhirDatastoresOutput {
    /// <p>All properties associated with the listed Data Stores.</p>
    pub fn datastore_properties_list(
        &self,
    ) -> std::option::Option<&[crate::model::DatastoreProperties]> {
        self.datastore_properties_list.as_deref()
    }
    /// <p>Pagination token that can be used to retrieve the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFhirDatastoresOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFhirDatastoresOutput");
        formatter.field("datastore_properties_list", &self.datastore_properties_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListFhirDatastoresOutput`](crate::output::ListFhirDatastoresOutput)
pub mod list_fhir_datastores_output {
    /// A builder for [`ListFhirDatastoresOutput`](crate::output::ListFhirDatastoresOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) datastore_properties_list:
            std::option::Option<std::vec::Vec<crate::model::DatastoreProperties>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `datastore_properties_list`.
        ///
        /// To override the contents of this collection use [`set_datastore_properties_list`](Self::set_datastore_properties_list).
        ///
        /// <p>All properties associated with the listed Data Stores.</p>
        pub fn datastore_properties_list(
            mut self,
            input: impl Into<crate::model::DatastoreProperties>,
        ) -> Self {
            let mut v = self.datastore_properties_list.unwrap_or_default();
            v.push(input.into());
            self.datastore_properties_list = Some(v);
            self
        }
        /// <p>All properties associated with the listed Data Stores.</p>
        pub fn set_datastore_properties_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DatastoreProperties>>,
        ) -> Self {
            self.datastore_properties_list = input;
            self
        }
        /// <p>Pagination token that can be used to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Pagination token that can be used to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFhirDatastoresOutput`](crate::output::ListFhirDatastoresOutput)
        pub fn build(self) -> crate::output::ListFhirDatastoresOutput {
            crate::output::ListFhirDatastoresOutput {
                datastore_properties_list: self.datastore_properties_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListFhirDatastoresOutput {
    /// Creates a new builder-style object to manufacture [`ListFhirDatastoresOutput`](crate::output::ListFhirDatastoresOutput)
    pub fn builder() -> crate::output::list_fhir_datastores_output::Builder {
        crate::output::list_fhir_datastores_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFhirImportJobOutput {
    /// <p>The properties of the Import job request, including the ID, ARN, name, and the status of the job.</p>
    pub import_job_properties: std::option::Option<crate::model::ImportJobProperties>,
}
impl DescribeFhirImportJobOutput {
    /// <p>The properties of the Import job request, including the ID, ARN, name, and the status of the job.</p>
    pub fn import_job_properties(&self) -> std::option::Option<&crate::model::ImportJobProperties> {
        self.import_job_properties.as_ref()
    }
}
impl std::fmt::Debug for DescribeFhirImportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFhirImportJobOutput");
        formatter.field("import_job_properties", &self.import_job_properties);
        formatter.finish()
    }
}
/// See [`DescribeFhirImportJobOutput`](crate::output::DescribeFhirImportJobOutput)
pub mod describe_fhir_import_job_output {
    /// A builder for [`DescribeFhirImportJobOutput`](crate::output::DescribeFhirImportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) import_job_properties: std::option::Option<crate::model::ImportJobProperties>,
    }
    impl Builder {
        /// <p>The properties of the Import job request, including the ID, ARN, name, and the status of the job.</p>
        pub fn import_job_properties(mut self, input: crate::model::ImportJobProperties) -> Self {
            self.import_job_properties = Some(input);
            self
        }
        /// <p>The properties of the Import job request, including the ID, ARN, name, and the status of the job.</p>
        pub fn set_import_job_properties(
            mut self,
            input: std::option::Option<crate::model::ImportJobProperties>,
        ) -> Self {
            self.import_job_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFhirImportJobOutput`](crate::output::DescribeFhirImportJobOutput)
        pub fn build(self) -> crate::output::DescribeFhirImportJobOutput {
            crate::output::DescribeFhirImportJobOutput {
                import_job_properties: self.import_job_properties,
            }
        }
    }
}
impl DescribeFhirImportJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFhirImportJobOutput`](crate::output::DescribeFhirImportJobOutput)
    pub fn builder() -> crate::output::describe_fhir_import_job_output::Builder {
        crate::output::describe_fhir_import_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFhirExportJobOutput {
    /// <p>Displays the properties of the export job, including the ID, Arn, Name, and the status of the job. </p>
    pub export_job_properties: std::option::Option<crate::model::ExportJobProperties>,
}
impl DescribeFhirExportJobOutput {
    /// <p>Displays the properties of the export job, including the ID, Arn, Name, and the status of the job. </p>
    pub fn export_job_properties(&self) -> std::option::Option<&crate::model::ExportJobProperties> {
        self.export_job_properties.as_ref()
    }
}
impl std::fmt::Debug for DescribeFhirExportJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFhirExportJobOutput");
        formatter.field("export_job_properties", &self.export_job_properties);
        formatter.finish()
    }
}
/// See [`DescribeFhirExportJobOutput`](crate::output::DescribeFhirExportJobOutput)
pub mod describe_fhir_export_job_output {
    /// A builder for [`DescribeFhirExportJobOutput`](crate::output::DescribeFhirExportJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_job_properties: std::option::Option<crate::model::ExportJobProperties>,
    }
    impl Builder {
        /// <p>Displays the properties of the export job, including the ID, Arn, Name, and the status of the job. </p>
        pub fn export_job_properties(mut self, input: crate::model::ExportJobProperties) -> Self {
            self.export_job_properties = Some(input);
            self
        }
        /// <p>Displays the properties of the export job, including the ID, Arn, Name, and the status of the job. </p>
        pub fn set_export_job_properties(
            mut self,
            input: std::option::Option<crate::model::ExportJobProperties>,
        ) -> Self {
            self.export_job_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFhirExportJobOutput`](crate::output::DescribeFhirExportJobOutput)
        pub fn build(self) -> crate::output::DescribeFhirExportJobOutput {
            crate::output::DescribeFhirExportJobOutput {
                export_job_properties: self.export_job_properties,
            }
        }
    }
}
impl DescribeFhirExportJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFhirExportJobOutput`](crate::output::DescribeFhirExportJobOutput)
    pub fn builder() -> crate::output::describe_fhir_export_job_output::Builder {
        crate::output::describe_fhir_export_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFhirDatastoreOutput {
    /// <p>All properties associated with a Data Store, including the Data Store ID, Data Store ARN,
    /// Data Store name, Data Store status, created at, Data Store type version, and Data Store
    /// endpoint.</p>
    pub datastore_properties: std::option::Option<crate::model::DatastoreProperties>,
}
impl DescribeFhirDatastoreOutput {
    /// <p>All properties associated with a Data Store, including the Data Store ID, Data Store ARN,
    /// Data Store name, Data Store status, created at, Data Store type version, and Data Store
    /// endpoint.</p>
    pub fn datastore_properties(&self) -> std::option::Option<&crate::model::DatastoreProperties> {
        self.datastore_properties.as_ref()
    }
}
impl std::fmt::Debug for DescribeFhirDatastoreOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFhirDatastoreOutput");
        formatter.field("datastore_properties", &self.datastore_properties);
        formatter.finish()
    }
}
/// See [`DescribeFhirDatastoreOutput`](crate::output::DescribeFhirDatastoreOutput)
pub mod describe_fhir_datastore_output {
    /// A builder for [`DescribeFhirDatastoreOutput`](crate::output::DescribeFhirDatastoreOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) datastore_properties: std::option::Option<crate::model::DatastoreProperties>,
    }
    impl Builder {
        /// <p>All properties associated with a Data Store, including the Data Store ID, Data Store ARN,
        /// Data Store name, Data Store status, created at, Data Store type version, and Data Store
        /// endpoint.</p>
        pub fn datastore_properties(mut self, input: crate::model::DatastoreProperties) -> Self {
            self.datastore_properties = Some(input);
            self
        }
        /// <p>All properties associated with a Data Store, including the Data Store ID, Data Store ARN,
        /// Data Store name, Data Store status, created at, Data Store type version, and Data Store
        /// endpoint.</p>
        pub fn set_datastore_properties(
            mut self,
            input: std::option::Option<crate::model::DatastoreProperties>,
        ) -> Self {
            self.datastore_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFhirDatastoreOutput`](crate::output::DescribeFhirDatastoreOutput)
        pub fn build(self) -> crate::output::DescribeFhirDatastoreOutput {
            crate::output::DescribeFhirDatastoreOutput {
                datastore_properties: self.datastore_properties,
            }
        }
    }
}
impl DescribeFhirDatastoreOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFhirDatastoreOutput`](crate::output::DescribeFhirDatastoreOutput)
    pub fn builder() -> crate::output::describe_fhir_datastore_output::Builder {
        crate::output::describe_fhir_datastore_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFhirDatastoreOutput {
    /// <p>The AWS-generated ID for the Data Store to be deleted.</p>
    pub datastore_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) that gives Amazon HealthLake access permission.</p>
    pub datastore_arn: std::option::Option<std::string::String>,
    /// <p>The status of the Data Store that the user has requested to be deleted.
    /// </p>
    pub datastore_status: std::option::Option<crate::model::DatastoreStatus>,
    /// <p>The AWS endpoint for the Data Store the user has requested to be deleted.</p>
    pub datastore_endpoint: std::option::Option<std::string::String>,
}
impl DeleteFhirDatastoreOutput {
    /// <p>The AWS-generated ID for the Data Store to be deleted.</p>
    pub fn datastore_id(&self) -> std::option::Option<&str> {
        self.datastore_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) that gives Amazon HealthLake access permission.</p>
    pub fn datastore_arn(&self) -> std::option::Option<&str> {
        self.datastore_arn.as_deref()
    }
    /// <p>The status of the Data Store that the user has requested to be deleted.
    /// </p>
    pub fn datastore_status(&self) -> std::option::Option<&crate::model::DatastoreStatus> {
        self.datastore_status.as_ref()
    }
    /// <p>The AWS endpoint for the Data Store the user has requested to be deleted.</p>
    pub fn datastore_endpoint(&self) -> std::option::Option<&str> {
        self.datastore_endpoint.as_deref()
    }
}
impl std::fmt::Debug for DeleteFhirDatastoreOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFhirDatastoreOutput");
        formatter.field("datastore_id", &self.datastore_id);
        formatter.field("datastore_arn", &self.datastore_arn);
        formatter.field("datastore_status", &self.datastore_status);
        formatter.field("datastore_endpoint", &self.datastore_endpoint);
        formatter.finish()
    }
}
/// See [`DeleteFhirDatastoreOutput`](crate::output::DeleteFhirDatastoreOutput)
pub mod delete_fhir_datastore_output {
    /// A builder for [`DeleteFhirDatastoreOutput`](crate::output::DeleteFhirDatastoreOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) datastore_id: std::option::Option<std::string::String>,
        pub(crate) datastore_arn: std::option::Option<std::string::String>,
        pub(crate) datastore_status: std::option::Option<crate::model::DatastoreStatus>,
        pub(crate) datastore_endpoint: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AWS-generated ID for the Data Store to be deleted.</p>
        pub fn datastore_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.datastore_id = Some(input.into());
            self
        }
        /// <p>The AWS-generated ID for the Data Store to be deleted.</p>
        pub fn set_datastore_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.datastore_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that gives Amazon HealthLake access permission.</p>
        pub fn datastore_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.datastore_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that gives Amazon HealthLake access permission.</p>
        pub fn set_datastore_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.datastore_arn = input;
            self
        }
        /// <p>The status of the Data Store that the user has requested to be deleted.
        /// </p>
        pub fn datastore_status(mut self, input: crate::model::DatastoreStatus) -> Self {
            self.datastore_status = Some(input);
            self
        }
        /// <p>The status of the Data Store that the user has requested to be deleted.
        /// </p>
        pub fn set_datastore_status(
            mut self,
            input: std::option::Option<crate::model::DatastoreStatus>,
        ) -> Self {
            self.datastore_status = input;
            self
        }
        /// <p>The AWS endpoint for the Data Store the user has requested to be deleted.</p>
        pub fn datastore_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.datastore_endpoint = Some(input.into());
            self
        }
        /// <p>The AWS endpoint for the Data Store the user has requested to be deleted.</p>
        pub fn set_datastore_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.datastore_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFhirDatastoreOutput`](crate::output::DeleteFhirDatastoreOutput)
        pub fn build(self) -> crate::output::DeleteFhirDatastoreOutput {
            crate::output::DeleteFhirDatastoreOutput {
                datastore_id: self.datastore_id,
                datastore_arn: self.datastore_arn,
                datastore_status: self.datastore_status,
                datastore_endpoint: self.datastore_endpoint,
            }
        }
    }
}
impl DeleteFhirDatastoreOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFhirDatastoreOutput`](crate::output::DeleteFhirDatastoreOutput)
    pub fn builder() -> crate::output::delete_fhir_datastore_output::Builder {
        crate::output::delete_fhir_datastore_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFhirDatastoreOutput {
    /// <p>The AWS-generated Data Store id. This id is in the output from the initial Data Store
    /// creation call.</p>
    pub datastore_id: std::option::Option<std::string::String>,
    /// <p>The datastore ARN is generated during the creation of the Data Store and can be found in
    /// the output from the initial Data Store creation call.</p>
    pub datastore_arn: std::option::Option<std::string::String>,
    /// <p>The status of the FHIR Data Store. Possible statuses are ‘CREATING’, ‘ACTIVE’, ‘DELETING’,
    /// ‘DELETED’.</p>
    pub datastore_status: std::option::Option<crate::model::DatastoreStatus>,
    /// <p>The AWS endpoint for the created Data Store. For preview, only US-east-1 endpoints are
    /// supported.</p>
    pub datastore_endpoint: std::option::Option<std::string::String>,
}
impl CreateFhirDatastoreOutput {
    /// <p>The AWS-generated Data Store id. This id is in the output from the initial Data Store
    /// creation call.</p>
    pub fn datastore_id(&self) -> std::option::Option<&str> {
        self.datastore_id.as_deref()
    }
    /// <p>The datastore ARN is generated during the creation of the Data Store and can be found in
    /// the output from the initial Data Store creation call.</p>
    pub fn datastore_arn(&self) -> std::option::Option<&str> {
        self.datastore_arn.as_deref()
    }
    /// <p>The status of the FHIR Data Store. Possible statuses are ‘CREATING’, ‘ACTIVE’, ‘DELETING’,
    /// ‘DELETED’.</p>
    pub fn datastore_status(&self) -> std::option::Option<&crate::model::DatastoreStatus> {
        self.datastore_status.as_ref()
    }
    /// <p>The AWS endpoint for the created Data Store. For preview, only US-east-1 endpoints are
    /// supported.</p>
    pub fn datastore_endpoint(&self) -> std::option::Option<&str> {
        self.datastore_endpoint.as_deref()
    }
}
impl std::fmt::Debug for CreateFhirDatastoreOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFhirDatastoreOutput");
        formatter.field("datastore_id", &self.datastore_id);
        formatter.field("datastore_arn", &self.datastore_arn);
        formatter.field("datastore_status", &self.datastore_status);
        formatter.field("datastore_endpoint", &self.datastore_endpoint);
        formatter.finish()
    }
}
/// See [`CreateFhirDatastoreOutput`](crate::output::CreateFhirDatastoreOutput)
pub mod create_fhir_datastore_output {
    /// A builder for [`CreateFhirDatastoreOutput`](crate::output::CreateFhirDatastoreOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) datastore_id: std::option::Option<std::string::String>,
        pub(crate) datastore_arn: std::option::Option<std::string::String>,
        pub(crate) datastore_status: std::option::Option<crate::model::DatastoreStatus>,
        pub(crate) datastore_endpoint: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AWS-generated Data Store id. This id is in the output from the initial Data Store
        /// creation call.</p>
        pub fn datastore_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.datastore_id = Some(input.into());
            self
        }
        /// <p>The AWS-generated Data Store id. This id is in the output from the initial Data Store
        /// creation call.</p>
        pub fn set_datastore_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.datastore_id = input;
            self
        }
        /// <p>The datastore ARN is generated during the creation of the Data Store and can be found in
        /// the output from the initial Data Store creation call.</p>
        pub fn datastore_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.datastore_arn = Some(input.into());
            self
        }
        /// <p>The datastore ARN is generated during the creation of the Data Store and can be found in
        /// the output from the initial Data Store creation call.</p>
        pub fn set_datastore_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.datastore_arn = input;
            self
        }
        /// <p>The status of the FHIR Data Store. Possible statuses are ‘CREATING’, ‘ACTIVE’, ‘DELETING’,
        /// ‘DELETED’.</p>
        pub fn datastore_status(mut self, input: crate::model::DatastoreStatus) -> Self {
            self.datastore_status = Some(input);
            self
        }
        /// <p>The status of the FHIR Data Store. Possible statuses are ‘CREATING’, ‘ACTIVE’, ‘DELETING’,
        /// ‘DELETED’.</p>
        pub fn set_datastore_status(
            mut self,
            input: std::option::Option<crate::model::DatastoreStatus>,
        ) -> Self {
            self.datastore_status = input;
            self
        }
        /// <p>The AWS endpoint for the created Data Store. For preview, only US-east-1 endpoints are
        /// supported.</p>
        pub fn datastore_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.datastore_endpoint = Some(input.into());
            self
        }
        /// <p>The AWS endpoint for the created Data Store. For preview, only US-east-1 endpoints are
        /// supported.</p>
        pub fn set_datastore_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.datastore_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFhirDatastoreOutput`](crate::output::CreateFhirDatastoreOutput)
        pub fn build(self) -> crate::output::CreateFhirDatastoreOutput {
            crate::output::CreateFhirDatastoreOutput {
                datastore_id: self.datastore_id,
                datastore_arn: self.datastore_arn,
                datastore_status: self.datastore_status,
                datastore_endpoint: self.datastore_endpoint,
            }
        }
    }
}
impl CreateFhirDatastoreOutput {
    /// Creates a new builder-style object to manufacture [`CreateFhirDatastoreOutput`](crate::output::CreateFhirDatastoreOutput)
    pub fn builder() -> crate::output::create_fhir_datastore_output::Builder {
        crate::output::create_fhir_datastore_output::Builder::default()
    }
}
