// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateFHIRDatastore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateFHIRDatastoreError {
    /// Kind of error that occurred.
    pub kind: CreateFHIRDatastoreErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateFHIRDatastore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateFHIRDatastoreErrorKind {
    /// <p>Access is denied. Your account is not authorized to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Unknown error occurs in the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The user has exceeded their maximum number of allowed calls to the given API. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input parameter was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateFHIRDatastoreError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateFHIRDatastoreErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateFHIRDatastoreErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateFHIRDatastoreErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateFHIRDatastoreErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateFHIRDatastoreErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateFHIRDatastoreError {
    fn code(&self) -> Option<&str> {
        CreateFHIRDatastoreError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateFHIRDatastoreError {
    /// Creates a new `CreateFHIRDatastoreError`.
    pub fn new(kind: CreateFHIRDatastoreErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateFHIRDatastoreError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateFHIRDatastoreErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateFHIRDatastoreError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateFHIRDatastoreErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateFHIRDatastoreErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFHIRDatastoreErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFHIRDatastoreErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFHIRDatastoreErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFHIRDatastoreErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFHIRDatastoreErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFHIRDatastoreErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFHIRDatastoreErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateFHIRDatastoreError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateFHIRDatastoreErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateFHIRDatastoreErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateFHIRDatastoreErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateFHIRDatastoreErrorKind::ValidationException(_inner) => Some(_inner),
            CreateFHIRDatastoreErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFHIRDatastore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFHIRDatastoreError {
    /// Kind of error that occurred.
    pub kind: DeleteFHIRDatastoreErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFHIRDatastore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFHIRDatastoreErrorKind {
    /// <p>Access is denied. Your account is not authorized to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Data Store is in a transition state and the user requested action can not be performed.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Unknown error occurs in the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The requested Data Store was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The user has exceeded their maximum number of allowed calls to the given API. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input parameter was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFHIRDatastoreError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFHIRDatastoreErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteFHIRDatastoreErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteFHIRDatastoreErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteFHIRDatastoreErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteFHIRDatastoreErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteFHIRDatastoreErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteFHIRDatastoreErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFHIRDatastoreError {
    fn code(&self) -> Option<&str> {
        DeleteFHIRDatastoreError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFHIRDatastoreError {
    /// Creates a new `DeleteFHIRDatastoreError`.
    pub fn new(kind: DeleteFHIRDatastoreErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFHIRDatastoreError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFHIRDatastoreErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFHIRDatastoreError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFHIRDatastoreErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFHIRDatastoreErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFHIRDatastoreErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFHIRDatastoreErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFHIRDatastoreErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFHIRDatastoreErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFHIRDatastoreErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFHIRDatastoreErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFHIRDatastoreErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFHIRDatastoreErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFHIRDatastoreErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFHIRDatastoreErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFHIRDatastoreErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteFHIRDatastoreError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFHIRDatastoreErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteFHIRDatastoreErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteFHIRDatastoreErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteFHIRDatastoreErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteFHIRDatastoreErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteFHIRDatastoreErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteFHIRDatastoreErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFHIRDatastore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFHIRDatastoreError {
    /// Kind of error that occurred.
    pub kind: DescribeFHIRDatastoreErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFHIRDatastore` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFHIRDatastoreErrorKind {
    /// <p>Unknown error occurs in the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The requested Data Store was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The user has exceeded their maximum number of allowed calls to the given API. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input parameter was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFHIRDatastoreError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFHIRDatastoreErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeFHIRDatastoreErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeFHIRDatastoreErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeFHIRDatastoreErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeFHIRDatastoreErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFHIRDatastoreError {
    fn code(&self) -> Option<&str> {
        DescribeFHIRDatastoreError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFHIRDatastoreError {
    /// Creates a new `DescribeFHIRDatastoreError`.
    pub fn new(kind: DescribeFHIRDatastoreErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFHIRDatastoreError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFHIRDatastoreErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFHIRDatastoreError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFHIRDatastoreErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFHIRDatastoreErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFHIRDatastoreErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFHIRDatastoreErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFHIRDatastoreErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFHIRDatastoreErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFHIRDatastoreErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFHIRDatastoreErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFHIRDatastoreErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeFHIRDatastoreError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFHIRDatastoreErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeFHIRDatastoreErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeFHIRDatastoreErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeFHIRDatastoreErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeFHIRDatastoreErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFHIRExportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFHIRExportJobError {
    /// Kind of error that occurred.
    pub kind: DescribeFHIRExportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFHIRExportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFHIRExportJobErrorKind {
    /// <p>Unknown error occurs in the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The requested Data Store was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The user has exceeded their maximum number of allowed calls to the given API. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input parameter was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFHIRExportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFHIRExportJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeFHIRExportJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeFHIRExportJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeFHIRExportJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeFHIRExportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFHIRExportJobError {
    fn code(&self) -> Option<&str> {
        DescribeFHIRExportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFHIRExportJobError {
    /// Creates a new `DescribeFHIRExportJobError`.
    pub fn new(kind: DescribeFHIRExportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFHIRExportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFHIRExportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFHIRExportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFHIRExportJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFHIRExportJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFHIRExportJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFHIRExportJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFHIRExportJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFHIRExportJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFHIRExportJobErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFHIRExportJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFHIRExportJobErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeFHIRExportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFHIRExportJobErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeFHIRExportJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeFHIRExportJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeFHIRExportJobErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeFHIRExportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFHIRImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFHIRImportJobError {
    /// Kind of error that occurred.
    pub kind: DescribeFHIRImportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFHIRImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFHIRImportJobErrorKind {
    /// <p>Unknown error occurs in the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The requested Data Store was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The user has exceeded their maximum number of allowed calls to the given API. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input parameter was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFHIRImportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFHIRImportJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeFHIRImportJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeFHIRImportJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeFHIRImportJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeFHIRImportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFHIRImportJobError {
    fn code(&self) -> Option<&str> {
        DescribeFHIRImportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFHIRImportJobError {
    /// Creates a new `DescribeFHIRImportJobError`.
    pub fn new(kind: DescribeFHIRImportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFHIRImportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFHIRImportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFHIRImportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFHIRImportJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFHIRImportJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFHIRImportJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFHIRImportJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFHIRImportJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFHIRImportJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFHIRImportJobErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFHIRImportJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFHIRImportJobErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeFHIRImportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFHIRImportJobErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeFHIRImportJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeFHIRImportJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeFHIRImportJobErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeFHIRImportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFHIRDatastores` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFHIRDatastoresError {
    /// Kind of error that occurred.
    pub kind: ListFHIRDatastoresErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFHIRDatastores` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFHIRDatastoresErrorKind {
    /// <p>Unknown error occurs in the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The user has exceeded their maximum number of allowed calls to the given API. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input parameter was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFHIRDatastoresError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFHIRDatastoresErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListFHIRDatastoresErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListFHIRDatastoresErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListFHIRDatastoresErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFHIRDatastoresError {
    fn code(&self) -> Option<&str> {
        ListFHIRDatastoresError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFHIRDatastoresError {
    /// Creates a new `ListFHIRDatastoresError`.
    pub fn new(kind: ListFHIRDatastoresErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFHIRDatastoresError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFHIRDatastoresErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFHIRDatastoresError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFHIRDatastoresErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFHIRDatastoresErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFHIRDatastoresErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFHIRDatastoresErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFHIRDatastoresErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFHIRDatastoresErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFHIRDatastoresErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListFHIRDatastoresError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFHIRDatastoresErrorKind::InternalServerException(_inner) => Some(_inner),
            ListFHIRDatastoresErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListFHIRDatastoresErrorKind::ValidationException(_inner) => Some(_inner),
            ListFHIRDatastoresErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFHIRExportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFHIRExportJobsError {
    /// Kind of error that occurred.
    pub kind: ListFHIRExportJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFHIRExportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFHIRExportJobsErrorKind {
    /// <p>Access is denied. Your account is not authorized to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Unknown error occurs in the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The requested Data Store was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The user has exceeded their maximum number of allowed calls to the given API. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input parameter was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFHIRExportJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFHIRExportJobsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListFHIRExportJobsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListFHIRExportJobsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListFHIRExportJobsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListFHIRExportJobsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListFHIRExportJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFHIRExportJobsError {
    fn code(&self) -> Option<&str> {
        ListFHIRExportJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFHIRExportJobsError {
    /// Creates a new `ListFHIRExportJobsError`.
    pub fn new(kind: ListFHIRExportJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFHIRExportJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFHIRExportJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFHIRExportJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFHIRExportJobsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFHIRExportJobsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFHIRExportJobsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFHIRExportJobsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFHIRExportJobsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFHIRExportJobsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFHIRExportJobsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFHIRExportJobsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFHIRExportJobsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFHIRExportJobsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFHIRExportJobsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListFHIRExportJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFHIRExportJobsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListFHIRExportJobsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListFHIRExportJobsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListFHIRExportJobsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListFHIRExportJobsErrorKind::ValidationException(_inner) => Some(_inner),
            ListFHIRExportJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFHIRImportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFHIRImportJobsError {
    /// Kind of error that occurred.
    pub kind: ListFHIRImportJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFHIRImportJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFHIRImportJobsErrorKind {
    /// <p>Access is denied. Your account is not authorized to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Unknown error occurs in the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The requested Data Store was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The user has exceeded their maximum number of allowed calls to the given API. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input parameter was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFHIRImportJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFHIRImportJobsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListFHIRImportJobsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListFHIRImportJobsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListFHIRImportJobsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListFHIRImportJobsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListFHIRImportJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFHIRImportJobsError {
    fn code(&self) -> Option<&str> {
        ListFHIRImportJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFHIRImportJobsError {
    /// Creates a new `ListFHIRImportJobsError`.
    pub fn new(kind: ListFHIRImportJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFHIRImportJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFHIRImportJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFHIRImportJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFHIRImportJobsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFHIRImportJobsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFHIRImportJobsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFHIRImportJobsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFHIRImportJobsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFHIRImportJobsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFHIRImportJobsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFHIRImportJobsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFHIRImportJobsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFHIRImportJobsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFHIRImportJobsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListFHIRImportJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFHIRImportJobsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListFHIRImportJobsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListFHIRImportJobsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListFHIRImportJobsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListFHIRImportJobsErrorKind::ValidationException(_inner) => Some(_inner),
            ListFHIRImportJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p> The requested Data Store was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The user input parameter was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartFHIRExportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartFHIRExportJobError {
    /// Kind of error that occurred.
    pub kind: StartFHIRExportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartFHIRExportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartFHIRExportJobErrorKind {
    /// <p>Access is denied. Your account is not authorized to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Unknown error occurs in the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The requested Data Store was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The user has exceeded their maximum number of allowed calls to the given API. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input parameter was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartFHIRExportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartFHIRExportJobErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StartFHIRExportJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartFHIRExportJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartFHIRExportJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StartFHIRExportJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StartFHIRExportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartFHIRExportJobError {
    fn code(&self) -> Option<&str> {
        StartFHIRExportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartFHIRExportJobError {
    /// Creates a new `StartFHIRExportJobError`.
    pub fn new(kind: StartFHIRExportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartFHIRExportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartFHIRExportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartFHIRExportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartFHIRExportJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartFHIRExportJobErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFHIRExportJobErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFHIRExportJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFHIRExportJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFHIRExportJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFHIRExportJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFHIRExportJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFHIRExportJobErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFHIRExportJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFHIRExportJobErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for StartFHIRExportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartFHIRExportJobErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StartFHIRExportJobErrorKind::InternalServerException(_inner) => Some(_inner),
            StartFHIRExportJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartFHIRExportJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            StartFHIRExportJobErrorKind::ValidationException(_inner) => Some(_inner),
            StartFHIRExportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartFHIRImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartFHIRImportJobError {
    /// Kind of error that occurred.
    pub kind: StartFHIRImportJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartFHIRImportJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartFHIRImportJobErrorKind {
    /// <p>Access is denied. Your account is not authorized to perform this operation.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Unknown error occurs in the service.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The requested Data Store was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The user has exceeded their maximum number of allowed calls to the given API. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>The user input parameter was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartFHIRImportJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartFHIRImportJobErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StartFHIRImportJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartFHIRImportJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartFHIRImportJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StartFHIRImportJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StartFHIRImportJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartFHIRImportJobError {
    fn code(&self) -> Option<&str> {
        StartFHIRImportJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartFHIRImportJobError {
    /// Creates a new `StartFHIRImportJobError`.
    pub fn new(kind: StartFHIRImportJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartFHIRImportJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartFHIRImportJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartFHIRImportJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartFHIRImportJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartFHIRImportJobErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFHIRImportJobErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFHIRImportJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFHIRImportJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFHIRImportJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFHIRImportJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFHIRImportJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFHIRImportJobErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFHIRImportJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFHIRImportJobErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for StartFHIRImportJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartFHIRImportJobErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StartFHIRImportJobErrorKind::InternalServerException(_inner) => Some(_inner),
            StartFHIRImportJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartFHIRImportJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            StartFHIRImportJobErrorKind::ValidationException(_inner) => Some(_inner),
            StartFHIRImportJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p> The requested Data Store was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The user input parameter was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p> The requested Data Store was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The user input parameter was invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The user input parameter was invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p> The requested Data Store was not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The user has exceeded their maximum number of allowed calls to the given API. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>Unknown error occurs in the service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>Access is denied. Your account is not authorized to perform this operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>The Data Store is in a transition state and the user requested action can not be performed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}
