// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>
/// A tag is a label consisting of a user-defined key and value. The form for tags is {"Key", "Value"}
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>
    /// The key portion of a tag. Tag keys are case sensitive.
    /// </p>
    pub key: std::option::Option<std::string::String>,
    /// <p>
    /// The value portion of tag. Tag values are case sensitive.
    /// </p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The key portion of a tag. Tag keys are case sensitive.
        /// </p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>
        /// The key portion of a tag. Tag keys are case sensitive.
        /// </p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>
        /// The value portion of tag. Tag values are case sensitive.
        /// </p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>
        /// The value portion of tag. Tag values are case sensitive.
        /// </p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    CompletedWithErrors,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Submitted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => JobStatus::Completed,
            "COMPLETED_WITH_ERRORS" => JobStatus::CompletedWithErrors,
            "FAILED" => JobStatus::Failed,
            "IN_PROGRESS" => JobStatus::InProgress,
            "SUBMITTED" => JobStatus::Submitted,
            other => JobStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobStatus::from(s))
    }
}
impl JobStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobStatus::Completed => "COMPLETED",
            JobStatus::CompletedWithErrors => "COMPLETED_WITH_ERRORS",
            JobStatus::Failed => "FAILED",
            JobStatus::InProgress => "IN_PROGRESS",
            JobStatus::Submitted => "SUBMITTED",
            JobStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "COMPLETED",
            "COMPLETED_WITH_ERRORS",
            "FAILED",
            "IN_PROGRESS",
            "SUBMITTED",
        ]
    }
}
impl AsRef<str> for JobStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The output data configuration that was supplied when the export job was created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum OutputDataConfig {
    /// <p>
    /// The output data configuration that was supplied when the export job was created.
    /// </p>
    S3Configuration(crate::model::S3Configuration),
}
impl OutputDataConfig {
    #[allow(irrefutable_let_patterns)]
    /// Tries to convert the enum instance into its [`OutputDataConfig`](crate::model::OutputDataConfig) variant.
    /// Returns `Err(&Self) if it can't be converted.`
    pub fn as_s3_configuration(
        &self,
    ) -> std::result::Result<&crate::model::S3Configuration, &Self> {
        if let OutputDataConfig::S3Configuration(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if the enum instance is the `OutputDataConfig` variant.
    pub fn is_s3_configuration(&self) -> bool {
        self.as_s3_configuration().is_ok()
    }
}

/// <p>
/// The configuration of the S3 bucket for either an import or export job. This includes assigning permissions for access.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Configuration {
    /// <p>
    /// The S3Uri is the user specified S3 location of the FHIR data to be imported into Amazon HealthLake.
    /// </p>
    pub s3_uri: std::option::Option<std::string::String>,
    /// <p>
    /// The KMS key ID used to access the S3 bucket.
    /// </p>
    pub kms_key_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for S3Configuration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Configuration");
        formatter.field("s3_uri", &self.s3_uri);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.finish()
    }
}
/// See [`S3Configuration`](crate::model::S3Configuration)
pub mod s3_configuration {
    /// A builder for [`S3Configuration`](crate::model::S3Configuration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_uri: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The S3Uri is the user specified S3 location of the FHIR data to be imported into Amazon HealthLake.
        /// </p>
        pub fn s3_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_uri = Some(input.into());
            self
        }
        /// <p>
        /// The S3Uri is the user specified S3 location of the FHIR data to be imported into Amazon HealthLake.
        /// </p>
        pub fn set_s3_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_uri = input;
            self
        }
        /// <p>
        /// The KMS key ID used to access the S3 bucket.
        /// </p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>
        /// The KMS key ID used to access the S3 bucket.
        /// </p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Configuration`](crate::model::S3Configuration)
        pub fn build(self) -> crate::model::S3Configuration {
            crate::model::S3Configuration {
                s3_uri: self.s3_uri,
                kms_key_id: self.kms_key_id,
            }
        }
    }
}
impl S3Configuration {
    /// Creates a new builder-style object to manufacture [`S3Configuration`](crate::model::S3Configuration)
    pub fn builder() -> crate::model::s3_configuration::Builder {
        crate::model::s3_configuration::Builder::default()
    }
}

/// <p> The input properties for an import job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum InputDataConfig {
    /// <p>The S3Uri is the user specified S3 location of the FHIR data to be imported into Amazon HealthLake. </p>
    S3Uri(std::string::String),
}
impl InputDataConfig {
    #[allow(irrefutable_let_patterns)]
    /// Tries to convert the enum instance into its [`InputDataConfig`](crate::model::InputDataConfig) variant.
    /// Returns `Err(&Self) if it can't be converted.`
    pub fn as_s3_uri(&self) -> std::result::Result<&std::string::String, &Self> {
        if let InputDataConfig::S3Uri(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if the enum instance is the `InputDataConfig` variant.
    pub fn is_s3_uri(&self) -> bool {
        self.as_s3_uri().is_ok()
    }
}

/// <p>Displays the properties of the import job, including the ID, Arn, Name, and the status of the Data Store.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportJobProperties {
    /// <p>The AWS-generated id number for the Import job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The user-generated name for an Import job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The job status for an Import job. Possible statuses are SUBMITTED, IN_PROGRESS, COMPLETED, FAILED.</p>
    pub job_status: std::option::Option<crate::model::JobStatus>,
    /// <p>The time that the Import job was submitted for processing.</p>
    pub submit_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the Import job was completed.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The datastore id used when the Import job was created. </p>
    pub datastore_id: std::option::Option<std::string::String>,
    /// <p>The input data configuration that was supplied when the Import job was created.</p>
    pub input_data_config: std::option::Option<crate::model::InputDataConfig>,
    /// <p>The output data configuration that was supplied when the export job was created.</p>
    pub job_output_data_config: std::option::Option<crate::model::OutputDataConfig>,
    /// <p>The Amazon Resource Name (ARN) that gives Amazon HealthLake access to your input data.</p>
    pub data_access_role_arn: std::option::Option<std::string::String>,
    /// <p>An explanation of any errors that may have occurred during the FHIR import job. </p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ImportJobProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportJobProperties");
        formatter.field("job_id", &self.job_id);
        formatter.field("job_name", &self.job_name);
        formatter.field("job_status", &self.job_status);
        formatter.field("submit_time", &self.submit_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("datastore_id", &self.datastore_id);
        formatter.field("input_data_config", &self.input_data_config);
        formatter.field("job_output_data_config", &self.job_output_data_config);
        formatter.field("data_access_role_arn", &self.data_access_role_arn);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ImportJobProperties`](crate::model::ImportJobProperties)
pub mod import_job_properties {
    /// A builder for [`ImportJobProperties`](crate::model::ImportJobProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
        pub(crate) submit_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) datastore_id: std::option::Option<std::string::String>,
        pub(crate) input_data_config: std::option::Option<crate::model::InputDataConfig>,
        pub(crate) job_output_data_config: std::option::Option<crate::model::OutputDataConfig>,
        pub(crate) data_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AWS-generated id number for the Import job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The AWS-generated id number for the Import job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The user-generated name for an Import job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The user-generated name for an Import job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The job status for an Import job. Possible statuses are SUBMITTED, IN_PROGRESS, COMPLETED, FAILED.</p>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>The job status for an Import job. Possible statuses are SUBMITTED, IN_PROGRESS, COMPLETED, FAILED.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>The time that the Import job was submitted for processing.</p>
        pub fn submit_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time = Some(input);
            self
        }
        /// <p>The time that the Import job was submitted for processing.</p>
        pub fn set_submit_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time = input;
            self
        }
        /// <p>The time that the Import job was completed.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The time that the Import job was completed.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The datastore id used when the Import job was created. </p>
        pub fn datastore_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.datastore_id = Some(input.into());
            self
        }
        /// <p>The datastore id used when the Import job was created. </p>
        pub fn set_datastore_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.datastore_id = input;
            self
        }
        /// <p>The input data configuration that was supplied when the Import job was created.</p>
        pub fn input_data_config(mut self, input: crate::model::InputDataConfig) -> Self {
            self.input_data_config = Some(input);
            self
        }
        /// <p>The input data configuration that was supplied when the Import job was created.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.input_data_config = input;
            self
        }
        /// <p>The output data configuration that was supplied when the export job was created.</p>
        pub fn job_output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.job_output_data_config = Some(input);
            self
        }
        /// <p>The output data configuration that was supplied when the export job was created.</p>
        pub fn set_job_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.job_output_data_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that gives Amazon HealthLake access to your input data.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that gives Amazon HealthLake access to your input data.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_access_role_arn = input;
            self
        }
        /// <p>An explanation of any errors that may have occurred during the FHIR import job. </p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>An explanation of any errors that may have occurred during the FHIR import job. </p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportJobProperties`](crate::model::ImportJobProperties)
        pub fn build(self) -> crate::model::ImportJobProperties {
            crate::model::ImportJobProperties {
                job_id: self.job_id,
                job_name: self.job_name,
                job_status: self.job_status,
                submit_time: self.submit_time,
                end_time: self.end_time,
                datastore_id: self.datastore_id,
                input_data_config: self.input_data_config,
                job_output_data_config: self.job_output_data_config,
                data_access_role_arn: self.data_access_role_arn,
                message: self.message,
            }
        }
    }
}
impl ImportJobProperties {
    /// Creates a new builder-style object to manufacture [`ImportJobProperties`](crate::model::ImportJobProperties)
    pub fn builder() -> crate::model::import_job_properties::Builder {
        crate::model::import_job_properties::Builder::default()
    }
}

/// <p>The properties of a FHIR export job, including the ID, ARN, name, and the status of the job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportJobProperties {
    /// <p>The AWS generated ID for an export job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The user generated name for an export job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The status of a FHIR export job. Possible statuses are SUBMITTED, IN_PROGRESS, COMPLETED, or FAILED.</p>
    pub job_status: std::option::Option<crate::model::JobStatus>,
    /// <p>The time an export job was initiated.</p>
    pub submit_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time an export job completed.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The AWS generated ID for the Data Store from which files are being exported for an export job.</p>
    pub datastore_id: std::option::Option<std::string::String>,
    /// <p>The output data configuration that was supplied when the export job was created.</p>
    pub output_data_config: std::option::Option<crate::model::OutputDataConfig>,
    /// <p>The Amazon Resource Name used during the initiation of the job.</p>
    pub data_access_role_arn: std::option::Option<std::string::String>,
    /// <p>An explanation of any errors that may have occurred during the export job.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ExportJobProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportJobProperties");
        formatter.field("job_id", &self.job_id);
        formatter.field("job_name", &self.job_name);
        formatter.field("job_status", &self.job_status);
        formatter.field("submit_time", &self.submit_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("datastore_id", &self.datastore_id);
        formatter.field("output_data_config", &self.output_data_config);
        formatter.field("data_access_role_arn", &self.data_access_role_arn);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ExportJobProperties`](crate::model::ExportJobProperties)
pub mod export_job_properties {
    /// A builder for [`ExportJobProperties`](crate::model::ExportJobProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
        pub(crate) submit_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) datastore_id: std::option::Option<std::string::String>,
        pub(crate) output_data_config: std::option::Option<crate::model::OutputDataConfig>,
        pub(crate) data_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AWS generated ID for an export job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The AWS generated ID for an export job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The user generated name for an export job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The user generated name for an export job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The status of a FHIR export job. Possible statuses are SUBMITTED, IN_PROGRESS, COMPLETED, or FAILED.</p>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>The status of a FHIR export job. Possible statuses are SUBMITTED, IN_PROGRESS, COMPLETED, or FAILED.</p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>The time an export job was initiated.</p>
        pub fn submit_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submit_time = Some(input);
            self
        }
        /// <p>The time an export job was initiated.</p>
        pub fn set_submit_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submit_time = input;
            self
        }
        /// <p>The time an export job completed.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The time an export job completed.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The AWS generated ID for the Data Store from which files are being exported for an export job.</p>
        pub fn datastore_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.datastore_id = Some(input.into());
            self
        }
        /// <p>The AWS generated ID for the Data Store from which files are being exported for an export job.</p>
        pub fn set_datastore_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.datastore_id = input;
            self
        }
        /// <p>The output data configuration that was supplied when the export job was created.</p>
        pub fn output_data_config(mut self, input: crate::model::OutputDataConfig) -> Self {
            self.output_data_config = Some(input);
            self
        }
        /// <p>The output data configuration that was supplied when the export job was created.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.output_data_config = input;
            self
        }
        /// <p>The Amazon Resource Name used during the initiation of the job.</p>
        pub fn data_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name used during the initiation of the job.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_access_role_arn = input;
            self
        }
        /// <p>An explanation of any errors that may have occurred during the export job.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>An explanation of any errors that may have occurred during the export job.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportJobProperties`](crate::model::ExportJobProperties)
        pub fn build(self) -> crate::model::ExportJobProperties {
            crate::model::ExportJobProperties {
                job_id: self.job_id,
                job_name: self.job_name,
                job_status: self.job_status,
                submit_time: self.submit_time,
                end_time: self.end_time,
                datastore_id: self.datastore_id,
                output_data_config: self.output_data_config,
                data_access_role_arn: self.data_access_role_arn,
                message: self.message,
            }
        }
    }
}
impl ExportJobProperties {
    /// Creates a new builder-style object to manufacture [`ExportJobProperties`](crate::model::ExportJobProperties)
    pub fn builder() -> crate::model::export_job_properties::Builder {
        crate::model::export_job_properties::Builder::default()
    }
}

/// <p>Displays the properties of the Data Store, including the ID, Arn, name, and the status of the Data Store.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatastoreProperties {
    /// <p>The AWS-generated ID number for the Data Store.</p>
    pub datastore_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name used in the creation of the Data Store.</p>
    pub datastore_arn: std::option::Option<std::string::String>,
    /// <p>The user-generated name for the Data Store.</p>
    pub datastore_name: std::option::Option<std::string::String>,
    /// <p>The status of the Data Store. Possible statuses are 'CREATING', 'ACTIVE', 'DELETING', or 'DELETED'.</p>
    pub datastore_status: std::option::Option<crate::model::DatastoreStatus>,
    /// <p>The time that a Data Store was created. </p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The FHIR version. Only R4 version data is supported.</p>
    pub datastore_type_version: std::option::Option<crate::model::FhirVersion>,
    /// <p>The AWS endpoint for the Data Store. Each Data Store will have it's own endpoint with Data Store ID in the endpoint URL.</p>
    pub datastore_endpoint: std::option::Option<std::string::String>,
    /// <p>
    /// The server-side encryption key configuration for a customer provided encryption key (CMK).
    /// </p>
    pub sse_configuration: std::option::Option<crate::model::SseConfiguration>,
    /// <p>The preloaded data configuration for the Data Store. Only data preloaded from Synthea is supported.</p>
    pub preload_data_config: std::option::Option<crate::model::PreloadDataConfig>,
}
impl std::fmt::Debug for DatastoreProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatastoreProperties");
        formatter.field("datastore_id", &self.datastore_id);
        formatter.field("datastore_arn", &self.datastore_arn);
        formatter.field("datastore_name", &self.datastore_name);
        formatter.field("datastore_status", &self.datastore_status);
        formatter.field("created_at", &self.created_at);
        formatter.field("datastore_type_version", &self.datastore_type_version);
        formatter.field("datastore_endpoint", &self.datastore_endpoint);
        formatter.field("sse_configuration", &self.sse_configuration);
        formatter.field("preload_data_config", &self.preload_data_config);
        formatter.finish()
    }
}
/// See [`DatastoreProperties`](crate::model::DatastoreProperties)
pub mod datastore_properties {
    /// A builder for [`DatastoreProperties`](crate::model::DatastoreProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) datastore_id: std::option::Option<std::string::String>,
        pub(crate) datastore_arn: std::option::Option<std::string::String>,
        pub(crate) datastore_name: std::option::Option<std::string::String>,
        pub(crate) datastore_status: std::option::Option<crate::model::DatastoreStatus>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) datastore_type_version: std::option::Option<crate::model::FhirVersion>,
        pub(crate) datastore_endpoint: std::option::Option<std::string::String>,
        pub(crate) sse_configuration: std::option::Option<crate::model::SseConfiguration>,
        pub(crate) preload_data_config: std::option::Option<crate::model::PreloadDataConfig>,
    }
    impl Builder {
        /// <p>The AWS-generated ID number for the Data Store.</p>
        pub fn datastore_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.datastore_id = Some(input.into());
            self
        }
        /// <p>The AWS-generated ID number for the Data Store.</p>
        pub fn set_datastore_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.datastore_id = input;
            self
        }
        /// <p>The Amazon Resource Name used in the creation of the Data Store.</p>
        pub fn datastore_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.datastore_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name used in the creation of the Data Store.</p>
        pub fn set_datastore_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.datastore_arn = input;
            self
        }
        /// <p>The user-generated name for the Data Store.</p>
        pub fn datastore_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.datastore_name = Some(input.into());
            self
        }
        /// <p>The user-generated name for the Data Store.</p>
        pub fn set_datastore_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.datastore_name = input;
            self
        }
        /// <p>The status of the Data Store. Possible statuses are 'CREATING', 'ACTIVE', 'DELETING', or 'DELETED'.</p>
        pub fn datastore_status(mut self, input: crate::model::DatastoreStatus) -> Self {
            self.datastore_status = Some(input);
            self
        }
        /// <p>The status of the Data Store. Possible statuses are 'CREATING', 'ACTIVE', 'DELETING', or 'DELETED'.</p>
        pub fn set_datastore_status(
            mut self,
            input: std::option::Option<crate::model::DatastoreStatus>,
        ) -> Self {
            self.datastore_status = input;
            self
        }
        /// <p>The time that a Data Store was created. </p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time that a Data Store was created. </p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The FHIR version. Only R4 version data is supported.</p>
        pub fn datastore_type_version(mut self, input: crate::model::FhirVersion) -> Self {
            self.datastore_type_version = Some(input);
            self
        }
        /// <p>The FHIR version. Only R4 version data is supported.</p>
        pub fn set_datastore_type_version(
            mut self,
            input: std::option::Option<crate::model::FhirVersion>,
        ) -> Self {
            self.datastore_type_version = input;
            self
        }
        /// <p>The AWS endpoint for the Data Store. Each Data Store will have it's own endpoint with Data Store ID in the endpoint URL.</p>
        pub fn datastore_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.datastore_endpoint = Some(input.into());
            self
        }
        /// <p>The AWS endpoint for the Data Store. Each Data Store will have it's own endpoint with Data Store ID in the endpoint URL.</p>
        pub fn set_datastore_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.datastore_endpoint = input;
            self
        }
        /// <p>
        /// The server-side encryption key configuration for a customer provided encryption key (CMK).
        /// </p>
        pub fn sse_configuration(mut self, input: crate::model::SseConfiguration) -> Self {
            self.sse_configuration = Some(input);
            self
        }
        /// <p>
        /// The server-side encryption key configuration for a customer provided encryption key (CMK).
        /// </p>
        pub fn set_sse_configuration(
            mut self,
            input: std::option::Option<crate::model::SseConfiguration>,
        ) -> Self {
            self.sse_configuration = input;
            self
        }
        /// <p>The preloaded data configuration for the Data Store. Only data preloaded from Synthea is supported.</p>
        pub fn preload_data_config(mut self, input: crate::model::PreloadDataConfig) -> Self {
            self.preload_data_config = Some(input);
            self
        }
        /// <p>The preloaded data configuration for the Data Store. Only data preloaded from Synthea is supported.</p>
        pub fn set_preload_data_config(
            mut self,
            input: std::option::Option<crate::model::PreloadDataConfig>,
        ) -> Self {
            self.preload_data_config = input;
            self
        }
        /// Consumes the builder and constructs a [`DatastoreProperties`](crate::model::DatastoreProperties)
        pub fn build(self) -> crate::model::DatastoreProperties {
            crate::model::DatastoreProperties {
                datastore_id: self.datastore_id,
                datastore_arn: self.datastore_arn,
                datastore_name: self.datastore_name,
                datastore_status: self.datastore_status,
                created_at: self.created_at,
                datastore_type_version: self.datastore_type_version,
                datastore_endpoint: self.datastore_endpoint,
                sse_configuration: self.sse_configuration,
                preload_data_config: self.preload_data_config,
            }
        }
    }
}
impl DatastoreProperties {
    /// Creates a new builder-style object to manufacture [`DatastoreProperties`](crate::model::DatastoreProperties)
    pub fn builder() -> crate::model::datastore_properties::Builder {
        crate::model::datastore_properties::Builder::default()
    }
}

/// <p> The input properties for the preloaded Data Store. Only data preloaded from Synthea is supported.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PreloadDataConfig {
    /// <p>The type of preloaded data. Only Synthea preloaded data is supported.</p>
    pub preload_data_type: std::option::Option<crate::model::PreloadDataType>,
}
impl std::fmt::Debug for PreloadDataConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PreloadDataConfig");
        formatter.field("preload_data_type", &self.preload_data_type);
        formatter.finish()
    }
}
/// See [`PreloadDataConfig`](crate::model::PreloadDataConfig)
pub mod preload_data_config {
    /// A builder for [`PreloadDataConfig`](crate::model::PreloadDataConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) preload_data_type: std::option::Option<crate::model::PreloadDataType>,
    }
    impl Builder {
        /// <p>The type of preloaded data. Only Synthea preloaded data is supported.</p>
        pub fn preload_data_type(mut self, input: crate::model::PreloadDataType) -> Self {
            self.preload_data_type = Some(input);
            self
        }
        /// <p>The type of preloaded data. Only Synthea preloaded data is supported.</p>
        pub fn set_preload_data_type(
            mut self,
            input: std::option::Option<crate::model::PreloadDataType>,
        ) -> Self {
            self.preload_data_type = input;
            self
        }
        /// Consumes the builder and constructs a [`PreloadDataConfig`](crate::model::PreloadDataConfig)
        pub fn build(self) -> crate::model::PreloadDataConfig {
            crate::model::PreloadDataConfig {
                preload_data_type: self.preload_data_type,
            }
        }
    }
}
impl PreloadDataConfig {
    /// Creates a new builder-style object to manufacture [`PreloadDataConfig`](crate::model::PreloadDataConfig)
    pub fn builder() -> crate::model::preload_data_config::Builder {
        crate::model::preload_data_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PreloadDataType {
    #[allow(missing_docs)] // documentation missing in model
    Synthea,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PreloadDataType {
    fn from(s: &str) -> Self {
        match s {
            "SYNTHEA" => PreloadDataType::Synthea,
            other => PreloadDataType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PreloadDataType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PreloadDataType::from(s))
    }
}
impl PreloadDataType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PreloadDataType::Synthea => "SYNTHEA",
            PreloadDataType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SYNTHEA"]
    }
}
impl AsRef<str> for PreloadDataType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// The server-side encryption key configuration for a customer provided encryption key.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SseConfiguration {
    /// <p>
    /// The KMS encryption configuration used to provide details for data encryption.
    /// </p>
    pub kms_encryption_config: std::option::Option<crate::model::KmsEncryptionConfig>,
}
impl std::fmt::Debug for SseConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SseConfiguration");
        formatter.field("kms_encryption_config", &self.kms_encryption_config);
        formatter.finish()
    }
}
/// See [`SseConfiguration`](crate::model::SseConfiguration)
pub mod sse_configuration {
    /// A builder for [`SseConfiguration`](crate::model::SseConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) kms_encryption_config: std::option::Option<crate::model::KmsEncryptionConfig>,
    }
    impl Builder {
        /// <p>
        /// The KMS encryption configuration used to provide details for data encryption.
        /// </p>
        pub fn kms_encryption_config(mut self, input: crate::model::KmsEncryptionConfig) -> Self {
            self.kms_encryption_config = Some(input);
            self
        }
        /// <p>
        /// The KMS encryption configuration used to provide details for data encryption.
        /// </p>
        pub fn set_kms_encryption_config(
            mut self,
            input: std::option::Option<crate::model::KmsEncryptionConfig>,
        ) -> Self {
            self.kms_encryption_config = input;
            self
        }
        /// Consumes the builder and constructs a [`SseConfiguration`](crate::model::SseConfiguration)
        pub fn build(self) -> crate::model::SseConfiguration {
            crate::model::SseConfiguration {
                kms_encryption_config: self.kms_encryption_config,
            }
        }
    }
}
impl SseConfiguration {
    /// Creates a new builder-style object to manufacture [`SseConfiguration`](crate::model::SseConfiguration)
    pub fn builder() -> crate::model::sse_configuration::Builder {
        crate::model::sse_configuration::Builder::default()
    }
}

/// <p>
/// The customer-managed-key(CMK) used when creating a Data Store. If a customer owned key is not specified, an AWS owned key will be used for encryption.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsEncryptionConfig {
    /// <p>
    /// The type of customer-managed-key(CMK) used for encyrption. The two types of supported CMKs are customer owned CMKs and AWS owned CMKs.
    /// </p>
    pub cmk_type: std::option::Option<crate::model::CmkType>,
    /// <p>
    /// The KMS encryption key id/alias used to encrypt the Data Store contents at rest.
    /// </p>
    pub kms_key_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KmsEncryptionConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsEncryptionConfig");
        formatter.field("cmk_type", &self.cmk_type);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.finish()
    }
}
/// See [`KmsEncryptionConfig`](crate::model::KmsEncryptionConfig)
pub mod kms_encryption_config {
    /// A builder for [`KmsEncryptionConfig`](crate::model::KmsEncryptionConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cmk_type: std::option::Option<crate::model::CmkType>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The type of customer-managed-key(CMK) used for encyrption. The two types of supported CMKs are customer owned CMKs and AWS owned CMKs.
        /// </p>
        pub fn cmk_type(mut self, input: crate::model::CmkType) -> Self {
            self.cmk_type = Some(input);
            self
        }
        /// <p>
        /// The type of customer-managed-key(CMK) used for encyrption. The two types of supported CMKs are customer owned CMKs and AWS owned CMKs.
        /// </p>
        pub fn set_cmk_type(mut self, input: std::option::Option<crate::model::CmkType>) -> Self {
            self.cmk_type = input;
            self
        }
        /// <p>
        /// The KMS encryption key id/alias used to encrypt the Data Store contents at rest.
        /// </p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>
        /// The KMS encryption key id/alias used to encrypt the Data Store contents at rest.
        /// </p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsEncryptionConfig`](crate::model::KmsEncryptionConfig)
        pub fn build(self) -> crate::model::KmsEncryptionConfig {
            crate::model::KmsEncryptionConfig {
                cmk_type: self.cmk_type,
                kms_key_id: self.kms_key_id,
            }
        }
    }
}
impl KmsEncryptionConfig {
    /// Creates a new builder-style object to manufacture [`KmsEncryptionConfig`](crate::model::KmsEncryptionConfig)
    pub fn builder() -> crate::model::kms_encryption_config::Builder {
        crate::model::kms_encryption_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CmkType {
    #[allow(missing_docs)] // documentation missing in model
    AoCmk,
    #[allow(missing_docs)] // documentation missing in model
    CmCmk,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CmkType {
    fn from(s: &str) -> Self {
        match s {
            "AWS_OWNED_KMS_KEY" => CmkType::AoCmk,
            "CUSTOMER_MANAGED_KMS_KEY" => CmkType::CmCmk,
            other => CmkType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CmkType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CmkType::from(s))
    }
}
impl CmkType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CmkType::AoCmk => "AWS_OWNED_KMS_KEY",
            CmkType::CmCmk => "CUSTOMER_MANAGED_KMS_KEY",
            CmkType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS_OWNED_KMS_KEY", "CUSTOMER_MANAGED_KMS_KEY"]
    }
}
impl AsRef<str> for CmkType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FhirVersion {
    #[allow(missing_docs)] // documentation missing in model
    R4,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FhirVersion {
    fn from(s: &str) -> Self {
        match s {
            "R4" => FhirVersion::R4,
            other => FhirVersion::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FhirVersion {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FhirVersion::from(s))
    }
}
impl FhirVersion {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FhirVersion::R4 => "R4",
            FhirVersion::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["R4"]
    }
}
impl AsRef<str> for FhirVersion {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DatastoreStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DatastoreStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => DatastoreStatus::Active,
            "CREATING" => DatastoreStatus::Creating,
            "DELETED" => DatastoreStatus::Deleted,
            "DELETING" => DatastoreStatus::Deleting,
            other => DatastoreStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DatastoreStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DatastoreStatus::from(s))
    }
}
impl DatastoreStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DatastoreStatus::Active => "ACTIVE",
            DatastoreStatus::Creating => "CREATING",
            DatastoreStatus::Deleted => "DELETED",
            DatastoreStatus::Deleting => "DELETING",
            DatastoreStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CREATING", "DELETED", "DELETING"]
    }
}
impl AsRef<str> for DatastoreStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The filters applied to Data Store query.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DatastoreFilter {
    /// <p>Allows the user to filter Data Store results by name.</p>
    pub datastore_name: std::option::Option<std::string::String>,
    /// <p>Allows the user to filter Data Store results by status.</p>
    pub datastore_status: std::option::Option<crate::model::DatastoreStatus>,
    /// <p>A filter that allows the user to set cutoff dates for records. All Data Stores created
    /// before the specified date will be included in the results. </p>
    pub created_before: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A filter that allows the user to set cutoff dates for records. All Data Stores created
    /// after the specified date will be included in the results.</p>
    pub created_after: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for DatastoreFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DatastoreFilter");
        formatter.field("datastore_name", &self.datastore_name);
        formatter.field("datastore_status", &self.datastore_status);
        formatter.field("created_before", &self.created_before);
        formatter.field("created_after", &self.created_after);
        formatter.finish()
    }
}
/// See [`DatastoreFilter`](crate::model::DatastoreFilter)
pub mod datastore_filter {
    /// A builder for [`DatastoreFilter`](crate::model::DatastoreFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) datastore_name: std::option::Option<std::string::String>,
        pub(crate) datastore_status: std::option::Option<crate::model::DatastoreStatus>,
        pub(crate) created_before: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_after: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>Allows the user to filter Data Store results by name.</p>
        pub fn datastore_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.datastore_name = Some(input.into());
            self
        }
        /// <p>Allows the user to filter Data Store results by name.</p>
        pub fn set_datastore_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.datastore_name = input;
            self
        }
        /// <p>Allows the user to filter Data Store results by status.</p>
        pub fn datastore_status(mut self, input: crate::model::DatastoreStatus) -> Self {
            self.datastore_status = Some(input);
            self
        }
        /// <p>Allows the user to filter Data Store results by status.</p>
        pub fn set_datastore_status(
            mut self,
            input: std::option::Option<crate::model::DatastoreStatus>,
        ) -> Self {
            self.datastore_status = input;
            self
        }
        /// <p>A filter that allows the user to set cutoff dates for records. All Data Stores created
        /// before the specified date will be included in the results. </p>
        pub fn created_before(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_before = Some(input);
            self
        }
        /// <p>A filter that allows the user to set cutoff dates for records. All Data Stores created
        /// before the specified date will be included in the results. </p>
        pub fn set_created_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_before = input;
            self
        }
        /// <p>A filter that allows the user to set cutoff dates for records. All Data Stores created
        /// after the specified date will be included in the results.</p>
        pub fn created_after(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_after = Some(input);
            self
        }
        /// <p>A filter that allows the user to set cutoff dates for records. All Data Stores created
        /// after the specified date will be included in the results.</p>
        pub fn set_created_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_after = input;
            self
        }
        /// Consumes the builder and constructs a [`DatastoreFilter`](crate::model::DatastoreFilter)
        pub fn build(self) -> crate::model::DatastoreFilter {
            crate::model::DatastoreFilter {
                datastore_name: self.datastore_name,
                datastore_status: self.datastore_status,
                created_before: self.created_before,
                created_after: self.created_after,
            }
        }
    }
}
impl DatastoreFilter {
    /// Creates a new builder-style object to manufacture [`DatastoreFilter`](crate::model::DatastoreFilter)
    pub fn builder() -> crate::model::datastore_filter::Builder {
        crate::model::datastore_filter::Builder::default()
    }
}
