// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `HealthLake`.
///
/// This client allows ergonomic access to a `HealthLake`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateFHIRDatastore` operation.
    ///
    /// See [`CreateFHIRDatastore`](crate::client::fluent_builders::CreateFHIRDatastore) for more information about the
    /// operation and its arguments.
    pub fn create_fhir_datastore(&self) -> fluent_builders::CreateFHIRDatastore<C, M, R> {
        fluent_builders::CreateFHIRDatastore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFHIRDatastore` operation.
    ///
    /// See [`DeleteFHIRDatastore`](crate::client::fluent_builders::DeleteFHIRDatastore) for more information about the
    /// operation and its arguments.
    pub fn delete_fhir_datastore(&self) -> fluent_builders::DeleteFHIRDatastore<C, M, R> {
        fluent_builders::DeleteFHIRDatastore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFHIRDatastore` operation.
    ///
    /// See [`DescribeFHIRDatastore`](crate::client::fluent_builders::DescribeFHIRDatastore) for more information about the
    /// operation and its arguments.
    pub fn describe_fhir_datastore(&self) -> fluent_builders::DescribeFHIRDatastore<C, M, R> {
        fluent_builders::DescribeFHIRDatastore::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFHIRExportJob` operation.
    ///
    /// See [`DescribeFHIRExportJob`](crate::client::fluent_builders::DescribeFHIRExportJob) for more information about the
    /// operation and its arguments.
    pub fn describe_fhir_export_job(&self) -> fluent_builders::DescribeFHIRExportJob<C, M, R> {
        fluent_builders::DescribeFHIRExportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFHIRImportJob` operation.
    ///
    /// See [`DescribeFHIRImportJob`](crate::client::fluent_builders::DescribeFHIRImportJob) for more information about the
    /// operation and its arguments.
    pub fn describe_fhir_import_job(&self) -> fluent_builders::DescribeFHIRImportJob<C, M, R> {
        fluent_builders::DescribeFHIRImportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFHIRDatastores` operation.
    ///
    /// See [`ListFHIRDatastores`](crate::client::fluent_builders::ListFHIRDatastores) for more information about the
    /// operation and its arguments.
    pub fn list_fhir_datastores(&self) -> fluent_builders::ListFHIRDatastores<C, M, R> {
        fluent_builders::ListFHIRDatastores::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFHIRExportJobs` operation.
    ///
    /// See [`ListFHIRExportJobs`](crate::client::fluent_builders::ListFHIRExportJobs) for more information about the
    /// operation and its arguments.
    pub fn list_fhir_export_jobs(&self) -> fluent_builders::ListFHIRExportJobs<C, M, R> {
        fluent_builders::ListFHIRExportJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFHIRImportJobs` operation.
    ///
    /// See [`ListFHIRImportJobs`](crate::client::fluent_builders::ListFHIRImportJobs) for more information about the
    /// operation and its arguments.
    pub fn list_fhir_import_jobs(&self) -> fluent_builders::ListFHIRImportJobs<C, M, R> {
        fluent_builders::ListFHIRImportJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartFHIRExportJob` operation.
    ///
    /// See [`StartFHIRExportJob`](crate::client::fluent_builders::StartFHIRExportJob) for more information about the
    /// operation and its arguments.
    pub fn start_fhir_export_job(&self) -> fluent_builders::StartFHIRExportJob<C, M, R> {
        fluent_builders::StartFHIRExportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartFHIRImportJob` operation.
    ///
    /// See [`StartFHIRImportJob`](crate::client::fluent_builders::StartFHIRImportJob) for more information about the
    /// operation and its arguments.
    pub fn start_fhir_import_job(&self) -> fluent_builders::StartFHIRImportJob<C, M, R> {
        fluent_builders::StartFHIRImportJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateFHIRDatastore`.
    ///
    /// <p>Creates a Data Store that can ingest and export FHIR formatted data.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateFHIRDatastore<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_fhir_datastore_input::Builder,
    }
    impl<C, M, R> CreateFHIRDatastore<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFHIRDatastore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFhirDatastoreOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFHIRDatastoreError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFhirDatastoreInputOperationOutputAlias,
                crate::output::CreateFhirDatastoreOutput,
                crate::error::CreateFHIRDatastoreError,
                crate::input::CreateFhirDatastoreInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The user generated name for the Data Store.</p>
        pub fn datastore_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.datastore_name(inp);
            self
        }
        /// <p>The user generated name for the Data Store.</p>
        pub fn set_datastore_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_datastore_name(input);
            self
        }
        /// <p>The FHIR version of the Data Store. The only supported version is R4.</p>
        pub fn datastore_type_version(mut self, inp: crate::model::FhirVersion) -> Self {
            self.inner = self.inner.datastore_type_version(inp);
            self
        }
        /// <p>The FHIR version of the Data Store. The only supported version is R4.</p>
        pub fn set_datastore_type_version(
            mut self,
            input: std::option::Option<crate::model::FhirVersion>,
        ) -> Self {
            self.inner = self.inner.set_datastore_type_version(input);
            self
        }
        /// <p>
        /// The server-side encryption key configuration for a customer provided encryption key specified for creating a Data Store.
        /// </p>
        pub fn sse_configuration(mut self, inp: crate::model::SseConfiguration) -> Self {
            self.inner = self.inner.sse_configuration(inp);
            self
        }
        /// <p>
        /// The server-side encryption key configuration for a customer provided encryption key specified for creating a Data Store.
        /// </p>
        pub fn set_sse_configuration(
            mut self,
            input: std::option::Option<crate::model::SseConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_sse_configuration(input);
            self
        }
        /// <p>Optional parameter to preload data upon creation of the Data Store. Currently, the only
        /// supported preloaded data is synthetic data generated from Synthea.</p>
        pub fn preload_data_config(mut self, inp: crate::model::PreloadDataConfig) -> Self {
            self.inner = self.inner.preload_data_config(inp);
            self
        }
        /// <p>Optional parameter to preload data upon creation of the Data Store. Currently, the only
        /// supported preloaded data is synthetic data generated from Synthea.</p>
        pub fn set_preload_data_config(
            mut self,
            input: std::option::Option<crate::model::PreloadDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_preload_data_config(input);
            self
        }
        /// <p>Optional user provided token used for ensuring idempotency.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Optional user provided token used for ensuring idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>
        /// Resource tags that are applied to a Data Store when it is created.
        /// </p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>
        /// Resource tags that are applied to a Data Store when it is created.
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFHIRDatastore`.
    ///
    /// <p>Deletes a Data Store. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteFHIRDatastore<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_fhir_datastore_input::Builder,
    }
    impl<C, M, R> DeleteFHIRDatastore<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFHIRDatastore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFhirDatastoreOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFHIRDatastoreError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFhirDatastoreInputOperationOutputAlias,
                crate::output::DeleteFhirDatastoreOutput,
                crate::error::DeleteFHIRDatastoreError,
                crate::input::DeleteFhirDatastoreInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p> The AWS-generated ID for the Data Store to be deleted.</p>
        pub fn datastore_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.datastore_id(inp);
            self
        }
        /// <p> The AWS-generated ID for the Data Store to be deleted.</p>
        pub fn set_datastore_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_datastore_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFHIRDatastore`.
    ///
    /// <p>Gets the properties associated with the FHIR Data Store, including the Data Store ID,
    /// Data Store ARN, Data Store name, Data Store status, created at, Data Store type version, and
    /// Data Store endpoint.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeFHIRDatastore<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_fhir_datastore_input::Builder,
    }
    impl<C, M, R> DescribeFHIRDatastore<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFHIRDatastore`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFhirDatastoreOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFHIRDatastoreError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFhirDatastoreInputOperationOutputAlias,
                crate::output::DescribeFhirDatastoreOutput,
                crate::error::DescribeFHIRDatastoreError,
                crate::input::DescribeFhirDatastoreInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS-generated Data Store id. This is part of the ‘CreateFHIRDatastore’ output.</p>
        pub fn datastore_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.datastore_id(inp);
            self
        }
        /// <p>The AWS-generated Data Store id. This is part of the ‘CreateFHIRDatastore’ output.</p>
        pub fn set_datastore_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_datastore_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFHIRExportJob`.
    ///
    /// <p>Displays the properties of a FHIR export job, including the ID, ARN, name, and the status of the job.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeFHIRExportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_fhir_export_job_input::Builder,
    }
    impl<C, M, R> DescribeFHIRExportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFHIRExportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFhirExportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFHIRExportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFhirExportJobInputOperationOutputAlias,
                crate::output::DescribeFhirExportJobOutput,
                crate::error::DescribeFHIRExportJobError,
                crate::input::DescribeFhirExportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS generated ID for the Data Store from which files are being exported from for an export job.</p>
        pub fn datastore_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.datastore_id(inp);
            self
        }
        /// <p>The AWS generated ID for the Data Store from which files are being exported from for an export job.</p>
        pub fn set_datastore_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_datastore_id(input);
            self
        }
        /// <p>The AWS generated ID for an export job.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The AWS generated ID for an export job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFHIRImportJob`.
    ///
    /// <p>Displays the properties of a FHIR import job, including the ID, ARN, name, and the status of the job. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeFHIRImportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_fhir_import_job_input::Builder,
    }
    impl<C, M, R> DescribeFHIRImportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFHIRImportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFhirImportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFHIRImportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFhirImportJobInputOperationOutputAlias,
                crate::output::DescribeFhirImportJobOutput,
                crate::error::DescribeFHIRImportJobError,
                crate::input::DescribeFhirImportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS-generated ID of the Data Store.</p>
        pub fn datastore_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.datastore_id(inp);
            self
        }
        /// <p>The AWS-generated ID of the Data Store.</p>
        pub fn set_datastore_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_datastore_id(input);
            self
        }
        /// <p>The AWS-generated job ID.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The AWS-generated job ID.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFHIRDatastores`.
    ///
    /// <p>Lists all FHIR Data Stores that are in the user’s account, regardless of Data Store
    /// status.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListFHIRDatastores<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_fhir_datastores_input::Builder,
    }
    impl<C, M, R> ListFHIRDatastores<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFHIRDatastores`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFhirDatastoresOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFHIRDatastoresError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFhirDatastoresInputOperationOutputAlias,
                crate::output::ListFhirDatastoresOutput,
                crate::error::ListFHIRDatastoresError,
                crate::input::ListFhirDatastoresInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Lists all filters associated with a FHIR Data Store request.</p>
        pub fn filter(mut self, inp: crate::model::DatastoreFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>Lists all filters associated with a FHIR Data Store request.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::DatastoreFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>Fetches the next page of Data Stores when results are paginated.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Fetches the next page of Data Stores when results are paginated.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of Data Stores returned in a single page of a
        /// ListFHIRDatastoresRequest call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of Data Stores returned in a single page of a
        /// ListFHIRDatastoresRequest call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFHIRExportJobs`.
    ///
    /// <p>
    /// Lists all FHIR export jobs associated with an account and their statuses.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListFHIRExportJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_fhir_export_jobs_input::Builder,
    }
    impl<C, M, R> ListFHIRExportJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFHIRExportJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFhirExportJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFHIRExportJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFhirExportJobsInputOperationOutputAlias,
                crate::output::ListFhirExportJobsOutput,
                crate::error::ListFHIRExportJobsError,
                crate::input::ListFhirExportJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// This parameter limits the response to the export job with the specified Data Store ID.
        /// </p>
        pub fn datastore_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.datastore_id(inp);
            self
        }
        /// <p>
        /// This parameter limits the response to the export job with the specified Data Store ID.
        /// </p>
        pub fn set_datastore_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_datastore_id(input);
            self
        }
        /// <p>
        /// A pagination token used to identify the next page of results to return for a ListFHIRExportJobs query.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// A pagination token used to identify the next page of results to return for a ListFHIRExportJobs query.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>
        /// This parameter limits the number of results returned for a ListFHIRExportJobs to a maximum quantity specified by the user.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// This parameter limits the number of results returned for a ListFHIRExportJobs to a maximum quantity specified by the user.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>
        /// This parameter limits the response to the export job with the specified job name.
        /// </p>
        pub fn job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(inp);
            self
        }
        /// <p>
        /// This parameter limits the response to the export job with the specified job name.
        /// </p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>
        /// This parameter limits the response to the export jobs with the specified job status.
        /// </p>
        pub fn job_status(mut self, inp: crate::model::JobStatus) -> Self {
            self.inner = self.inner.job_status(inp);
            self
        }
        /// <p>
        /// This parameter limits the response to the export jobs with the specified job status.
        /// </p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.inner = self.inner.set_job_status(input);
            self
        }
        /// <p>
        /// This parameter limits the response to FHIR export jobs submitted before a user specified date.
        /// </p>
        pub fn submitted_before(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.submitted_before(inp);
            self
        }
        /// <p>
        /// This parameter limits the response to FHIR export jobs submitted before a user specified date.
        /// </p>
        pub fn set_submitted_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_submitted_before(input);
            self
        }
        /// <p>
        /// This parameter limits the response to FHIR export jobs submitted after a user specified date.
        /// </p>
        pub fn submitted_after(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.submitted_after(inp);
            self
        }
        /// <p>
        /// This parameter limits the response to FHIR export jobs submitted after a user specified date.
        /// </p>
        pub fn set_submitted_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_submitted_after(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFHIRImportJobs`.
    ///
    /// <p>
    /// Lists all FHIR import jobs associated with an account and their statuses.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListFHIRImportJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_fhir_import_jobs_input::Builder,
    }
    impl<C, M, R> ListFHIRImportJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFHIRImportJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFhirImportJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFHIRImportJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFhirImportJobsInputOperationOutputAlias,
                crate::output::ListFhirImportJobsOutput,
                crate::error::ListFHIRImportJobsError,
                crate::input::ListFhirImportJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// This parameter limits the response to the import job with the specified Data Store ID.
        /// </p>
        pub fn datastore_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.datastore_id(inp);
            self
        }
        /// <p>
        /// This parameter limits the response to the import job with the specified Data Store ID.
        /// </p>
        pub fn set_datastore_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_datastore_id(input);
            self
        }
        /// <p>
        /// A pagination token used to identify the next page of results to return for a ListFHIRImportJobs query.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// A pagination token used to identify the next page of results to return for a ListFHIRImportJobs query.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>
        /// This parameter limits the number of results returned for a ListFHIRImportJobs to a maximum quantity specified by the user.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// This parameter limits the number of results returned for a ListFHIRImportJobs to a maximum quantity specified by the user.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>
        /// This parameter limits the response to the import job with the specified job name.
        /// </p>
        pub fn job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(inp);
            self
        }
        /// <p>
        /// This parameter limits the response to the import job with the specified job name.
        /// </p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>
        /// This parameter limits the response to the import job with the specified job status.
        /// </p>
        pub fn job_status(mut self, inp: crate::model::JobStatus) -> Self {
            self.inner = self.inner.job_status(inp);
            self
        }
        /// <p>
        /// This parameter limits the response to the import job with the specified job status.
        /// </p>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.inner = self.inner.set_job_status(input);
            self
        }
        /// <p>
        /// This parameter limits the response to FHIR import jobs submitted before a user specified date.
        /// </p>
        pub fn submitted_before(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.submitted_before(inp);
            self
        }
        /// <p>
        /// This parameter limits the response to FHIR import jobs submitted before a user specified date.
        /// </p>
        pub fn set_submitted_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_submitted_before(input);
            self
        }
        /// <p>
        /// This parameter limits the response to FHIR import jobs submitted after a user specified date.
        /// </p>
        pub fn submitted_after(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.submitted_after(inp);
            self
        }
        /// <p>
        /// This parameter limits the response to FHIR import jobs submitted after a user specified date.
        /// </p>
        pub fn set_submitted_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_submitted_after(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>
    /// Returns a list of all existing tags associated with a Data Store.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The Amazon Resource Name(ARN) of the Data Store for which tags are being added.
        /// </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>
        /// The Amazon Resource Name(ARN) of the Data Store for which tags are being added.
        /// </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartFHIRExportJob`.
    ///
    /// <p>Begins a FHIR export job.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartFHIRExportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_fhir_export_job_input::Builder,
    }
    impl<C, M, R> StartFHIRExportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartFHIRExportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartFhirExportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartFHIRExportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartFhirExportJobInputOperationOutputAlias,
                crate::output::StartFhirExportJobOutput,
                crate::error::StartFHIRExportJobError,
                crate::input::StartFhirExportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The user generated name for an export job.</p>
        pub fn job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(inp);
            self
        }
        /// <p>The user generated name for an export job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The output data configuration that was supplied when the export job was created.</p>
        pub fn output_data_config(mut self, inp: crate::model::OutputDataConfig) -> Self {
            self.inner = self.inner.output_data_config(inp);
            self
        }
        /// <p>The output data configuration that was supplied when the export job was created.</p>
        pub fn set_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_data_config(input);
            self
        }
        /// <p>The AWS generated ID for the Data Store from which files are being exported for an export job.</p>
        pub fn datastore_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.datastore_id(inp);
            self
        }
        /// <p>The AWS generated ID for the Data Store from which files are being exported for an export job.</p>
        pub fn set_datastore_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_datastore_id(input);
            self
        }
        /// <p>The Amazon Resource Name used during the initiation of the job.</p>
        pub fn data_access_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name used during the initiation of the job.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
        /// <p>An optional user provided token used for ensuring idempotency.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>An optional user provided token used for ensuring idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartFHIRImportJob`.
    ///
    /// <p>Begins a FHIR Import job.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartFHIRImportJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_fhir_import_job_input::Builder,
    }
    impl<C, M, R> StartFHIRImportJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartFHIRImportJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartFhirImportJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartFHIRImportJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartFhirImportJobInputOperationOutputAlias,
                crate::output::StartFhirImportJobOutput,
                crate::error::StartFHIRImportJobError,
                crate::input::StartFhirImportJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the FHIR Import job in the StartFHIRImport job request.</p>
        pub fn job_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(inp);
            self
        }
        /// <p>The name of the FHIR Import job in the StartFHIRImport job request.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The input properties of the FHIR Import job in the StartFHIRImport job request.</p>
        pub fn input_data_config(mut self, inp: crate::model::InputDataConfig) -> Self {
            self.inner = self.inner.input_data_config(inp);
            self
        }
        /// <p>The input properties of the FHIR Import job in the StartFHIRImport job request.</p>
        pub fn set_input_data_config(
            mut self,
            input: std::option::Option<crate::model::InputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_input_data_config(input);
            self
        }
        /// <p>The output data configuration that was supplied when the export job was created.</p>
        pub fn job_output_data_config(mut self, inp: crate::model::OutputDataConfig) -> Self {
            self.inner = self.inner.job_output_data_config(inp);
            self
        }
        /// <p>The output data configuration that was supplied when the export job was created.</p>
        pub fn set_job_output_data_config(
            mut self,
            input: std::option::Option<crate::model::OutputDataConfig>,
        ) -> Self {
            self.inner = self.inner.set_job_output_data_config(input);
            self
        }
        /// <p>The AWS-generated Data Store ID.</p>
        pub fn datastore_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.datastore_id(inp);
            self
        }
        /// <p>The AWS-generated Data Store ID.</p>
        pub fn set_datastore_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_datastore_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that gives Amazon HealthLake access permission.</p>
        pub fn data_access_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_access_role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) that gives Amazon HealthLake access permission.</p>
        pub fn set_data_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_access_role_arn(input);
            self
        }
        /// <p>Optional user provided token used for ensuring idempotency.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Optional user provided token used for ensuring idempotency.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>
    /// Adds a user specifed key and value tag to a Data Store.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The Amazon Resource Name(ARN)that gives Amazon HealthLake access to the Data Store which tags are being added to.
        /// </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>
        /// The Amazon Resource Name(ARN)that gives Amazon HealthLake access to the Data Store which tags are being added to.
        /// </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>
        /// The user specified key and value pair tags being added to a Data Store.
        /// </p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>
        /// The user specified key and value pair tags being added to a Data Store.
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>
    /// Removes tags from a Data Store.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// "The Amazon Resource Name(ARN) of the Data Store for which tags are being removed
        /// </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>
        /// "The Amazon Resource Name(ARN) of the Data Store for which tags are being removed
        /// </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>
        /// The keys for the tags to be removed from the Healthlake Data Store.
        /// </p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>
        /// The keys for the tags to be removed from the Healthlake Data Store.
        /// </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
