// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`DescribeAffectedAccountsForOrganizationInput`](crate::input::DescribeAffectedAccountsForOrganizationInput)
pub mod describe_affected_accounts_for_organization_input {
    /// A builder for [`DescribeAffectedAccountsForOrganizationInput`](crate::input::DescribeAffectedAccountsForOrganizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier for the event. The event ARN has the
        /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
        /// </code>
        /// format.</p>
        /// <p>For example, an event ARN might look like the following:</p>
        /// <p>
        /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
        /// </p>
        pub fn event_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_arn = Some(input.into());
            self
        }
        /// <p>The unique identifier for the event. The event ARN has the
        /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
        /// </code>
        /// format.</p>
        /// <p>For example, an event ARN might look like the following:</p>
        /// <p>
        /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
        /// </p>
        pub fn set_event_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_arn = input;
            self
        }
        /// <p>If the results of a search are large, only a portion of the
        /// results are returned, and a <code>nextToken</code> pagination token is returned in the response. To
        /// retrieve the next batch of results, reissue the search request and include the returned token.
        /// When all results have been returned, the response does not contain a pagination token value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the results of a search are large, only a portion of the
        /// results are returned, and a <code>nextToken</code> pagination token is returned in the response. To
        /// retrieve the next batch of results, reissue the search request and include the returned token.
        /// When all results have been returned, the response does not contain a pagination token value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAffectedAccountsForOrganizationInput`](crate::input::DescribeAffectedAccountsForOrganizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAffectedAccountsForOrganizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAffectedAccountsForOrganizationInput {
                event_arn: self.event_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAffectedAccountsForOrganizationInputOperationOutputAlias =
    crate::operation::DescribeAffectedAccountsForOrganization;
#[doc(hidden)]
pub type DescribeAffectedAccountsForOrganizationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeAffectedAccountsForOrganizationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAffectedAccountsForOrganization`](crate::operation::DescribeAffectedAccountsForOrganization)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAffectedAccountsForOrganization,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAffectedAccountsForOrganizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAffectedAccountsForOrganizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAffectedAccountsForOrganizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHealth_20160804.DescribeAffectedAccountsForOrganization",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_affected_accounts_for_organization(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAffectedAccountsForOrganization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAffectedAccountsForOrganization",
            "health",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAffectedAccountsForOrganizationInput`](crate::input::DescribeAffectedAccountsForOrganizationInput)
    pub fn builder() -> crate::input::describe_affected_accounts_for_organization_input::Builder {
        crate::input::describe_affected_accounts_for_organization_input::Builder::default()
    }
}

/// See [`DescribeAffectedEntitiesInput`](crate::input::DescribeAffectedEntitiesInput)
pub mod describe_affected_entities_input {
    /// A builder for [`DescribeAffectedEntitiesInput`](crate::input::DescribeAffectedEntitiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter: std::option::Option<crate::model::EntityFilter>,
        pub(crate) locale: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Values to narrow the results returned. At least one event ARN is required.</p>
        pub fn filter(mut self, input: crate::model::EntityFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Values to narrow the results returned. At least one event ARN is required.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::EntityFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
        pub fn locale(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale = Some(input.into());
            self
        }
        /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
        pub fn set_locale(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale = input;
            self
        }
        /// <p>If the results of a search are large, only a portion of the
        /// results are returned, and a <code>nextToken</code> pagination token is returned in the response. To
        /// retrieve the next batch of results, reissue the search request and include the returned token.
        /// When all results have been returned, the response does not contain a pagination token value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the results of a search are large, only a portion of the
        /// results are returned, and a <code>nextToken</code> pagination token is returned in the response. To
        /// retrieve the next batch of results, reissue the search request and include the returned token.
        /// When all results have been returned, the response does not contain a pagination token value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAffectedEntitiesInput`](crate::input::DescribeAffectedEntitiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAffectedEntitiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAffectedEntitiesInput {
                filter: self.filter,
                locale: self.locale,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAffectedEntitiesInputOperationOutputAlias =
    crate::operation::DescribeAffectedEntities;
#[doc(hidden)]
pub type DescribeAffectedEntitiesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAffectedEntitiesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAffectedEntities`](crate::operation::DescribeAffectedEntities)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAffectedEntities,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAffectedEntitiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAffectedEntitiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAffectedEntitiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHealth_20160804.DescribeAffectedEntities",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_affected_entities(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAffectedEntities::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAffectedEntities",
            "health",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAffectedEntitiesInput`](crate::input::DescribeAffectedEntitiesInput)
    pub fn builder() -> crate::input::describe_affected_entities_input::Builder {
        crate::input::describe_affected_entities_input::Builder::default()
    }
}

/// See [`DescribeAffectedEntitiesForOrganizationInput`](crate::input::DescribeAffectedEntitiesForOrganizationInput)
pub mod describe_affected_entities_for_organization_input {
    /// A builder for [`DescribeAffectedEntitiesForOrganizationInput`](crate::input::DescribeAffectedEntitiesForOrganizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_entity_filters:
            std::option::Option<std::vec::Vec<crate::model::EventAccountFilter>>,
        pub(crate) locale: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `organization_entity_filters`.
        ///
        /// To override the contents of this collection use [`set_organization_entity_filters`](Self::set_organization_entity_filters).
        ///
        /// <p>A JSON set of elements including the <code>awsAccountId</code> and the
        /// <code>eventArn</code>.</p>
        pub fn organization_entity_filters(
            mut self,
            input: impl Into<crate::model::EventAccountFilter>,
        ) -> Self {
            let mut v = self.organization_entity_filters.unwrap_or_default();
            v.push(input.into());
            self.organization_entity_filters = Some(v);
            self
        }
        /// <p>A JSON set of elements including the <code>awsAccountId</code> and the
        /// <code>eventArn</code>.</p>
        pub fn set_organization_entity_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventAccountFilter>>,
        ) -> Self {
            self.organization_entity_filters = input;
            self
        }
        /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
        pub fn locale(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale = Some(input.into());
            self
        }
        /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
        pub fn set_locale(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale = input;
            self
        }
        /// <p>If the results of a search are large, only a portion of the
        /// results are returned, and a <code>nextToken</code> pagination token is returned in the response. To
        /// retrieve the next batch of results, reissue the search request and include the returned token.
        /// When all results have been returned, the response does not contain a pagination token value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the results of a search are large, only a portion of the
        /// results are returned, and a <code>nextToken</code> pagination token is returned in the response. To
        /// retrieve the next batch of results, reissue the search request and include the returned token.
        /// When all results have been returned, the response does not contain a pagination token value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAffectedEntitiesForOrganizationInput`](crate::input::DescribeAffectedEntitiesForOrganizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAffectedEntitiesForOrganizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAffectedEntitiesForOrganizationInput {
                organization_entity_filters: self.organization_entity_filters,
                locale: self.locale,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAffectedEntitiesForOrganizationInputOperationOutputAlias =
    crate::operation::DescribeAffectedEntitiesForOrganization;
#[doc(hidden)]
pub type DescribeAffectedEntitiesForOrganizationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeAffectedEntitiesForOrganizationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAffectedEntitiesForOrganization`](crate::operation::DescribeAffectedEntitiesForOrganization)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAffectedEntitiesForOrganization,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAffectedEntitiesForOrganizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAffectedEntitiesForOrganizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAffectedEntitiesForOrganizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHealth_20160804.DescribeAffectedEntitiesForOrganization",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_affected_entities_for_organization(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAffectedEntitiesForOrganization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAffectedEntitiesForOrganization",
            "health",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAffectedEntitiesForOrganizationInput`](crate::input::DescribeAffectedEntitiesForOrganizationInput)
    pub fn builder() -> crate::input::describe_affected_entities_for_organization_input::Builder {
        crate::input::describe_affected_entities_for_organization_input::Builder::default()
    }
}

/// See [`DescribeEntityAggregatesInput`](crate::input::DescribeEntityAggregatesInput)
pub mod describe_entity_aggregates_input {
    /// A builder for [`DescribeEntityAggregatesInput`](crate::input::DescribeEntityAggregatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `event_arns`.
        ///
        /// To override the contents of this collection use [`set_event_arns`](Self::set_event_arns).
        ///
        /// <p>A list of event ARNs (unique identifiers). For example: <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
        /// </p>
        pub fn event_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_arns.unwrap_or_default();
            v.push(input.into());
            self.event_arns = Some(v);
            self
        }
        /// <p>A list of event ARNs (unique identifiers). For example: <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
        /// </p>
        pub fn set_event_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEntityAggregatesInput`](crate::input::DescribeEntityAggregatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEntityAggregatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEntityAggregatesInput {
                event_arns: self.event_arns,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEntityAggregatesInputOperationOutputAlias =
    crate::operation::DescribeEntityAggregates;
#[doc(hidden)]
pub type DescribeEntityAggregatesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEntityAggregatesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEntityAggregates`](crate::operation::DescribeEntityAggregates)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEntityAggregates,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEntityAggregatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEntityAggregatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEntityAggregatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHealth_20160804.DescribeEntityAggregates",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_entity_aggregates(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEntityAggregates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEntityAggregates",
            "health",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEntityAggregatesInput`](crate::input::DescribeEntityAggregatesInput)
    pub fn builder() -> crate::input::describe_entity_aggregates_input::Builder {
        crate::input::describe_entity_aggregates_input::Builder::default()
    }
}

/// See [`DescribeEventAggregatesInput`](crate::input::DescribeEventAggregatesInput)
pub mod describe_event_aggregates_input {
    /// A builder for [`DescribeEventAggregatesInput`](crate::input::DescribeEventAggregatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter: std::option::Option<crate::model::EventFilter>,
        pub(crate) aggregate_field: std::option::Option<crate::model::EventAggregateField>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Values to narrow the results returned.</p>
        pub fn filter(mut self, input: crate::model::EventFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Values to narrow the results returned.</p>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::EventFilter>) -> Self {
            self.filter = input;
            self
        }
        /// <p>The only currently supported value is <code>eventTypeCategory</code>.</p>
        pub fn aggregate_field(mut self, input: crate::model::EventAggregateField) -> Self {
            self.aggregate_field = Some(input);
            self
        }
        /// <p>The only currently supported value is <code>eventTypeCategory</code>.</p>
        pub fn set_aggregate_field(
            mut self,
            input: std::option::Option<crate::model::EventAggregateField>,
        ) -> Self {
            self.aggregate_field = input;
            self
        }
        /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If the results of a search are large, only a portion of the
        /// results are returned, and a <code>nextToken</code> pagination token is returned in the response. To
        /// retrieve the next batch of results, reissue the search request and include the returned token.
        /// When all results have been returned, the response does not contain a pagination token value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the results of a search are large, only a portion of the
        /// results are returned, and a <code>nextToken</code> pagination token is returned in the response. To
        /// retrieve the next batch of results, reissue the search request and include the returned token.
        /// When all results have been returned, the response does not contain a pagination token value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventAggregatesInput`](crate::input::DescribeEventAggregatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventAggregatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventAggregatesInput {
                filter: self.filter,
                aggregate_field: self.aggregate_field,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEventAggregatesInputOperationOutputAlias =
    crate::operation::DescribeEventAggregates;
#[doc(hidden)]
pub type DescribeEventAggregatesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEventAggregatesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEventAggregates`](crate::operation::DescribeEventAggregates)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEventAggregates,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEventAggregatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEventAggregatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEventAggregatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHealth_20160804.DescribeEventAggregates",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_event_aggregates(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEventAggregates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEventAggregates",
            "health",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventAggregatesInput`](crate::input::DescribeEventAggregatesInput)
    pub fn builder() -> crate::input::describe_event_aggregates_input::Builder {
        crate::input::describe_event_aggregates_input::Builder::default()
    }
}

/// See [`DescribeEventDetailsInput`](crate::input::DescribeEventDetailsInput)
pub mod describe_event_details_input {
    /// A builder for [`DescribeEventDetailsInput`](crate::input::DescribeEventDetailsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) locale: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `event_arns`.
        ///
        /// To override the contents of this collection use [`set_event_arns`](Self::set_event_arns).
        ///
        /// <p>A list of event ARNs (unique identifiers). For example: <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
        /// </p>
        pub fn event_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_arns.unwrap_or_default();
            v.push(input.into());
            self.event_arns = Some(v);
            self
        }
        /// <p>A list of event ARNs (unique identifiers). For example: <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
        /// </p>
        pub fn set_event_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_arns = input;
            self
        }
        /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
        pub fn locale(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale = Some(input.into());
            self
        }
        /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
        pub fn set_locale(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventDetailsInput`](crate::input::DescribeEventDetailsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventDetailsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventDetailsInput {
                event_arns: self.event_arns,
                locale: self.locale,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEventDetailsInputOperationOutputAlias = crate::operation::DescribeEventDetails;
#[doc(hidden)]
pub type DescribeEventDetailsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEventDetailsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEventDetails`](crate::operation::DescribeEventDetails)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEventDetails,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEventDetailsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEventDetailsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEventDetailsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHealth_20160804.DescribeEventDetails",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_event_details(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEventDetails::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEventDetails",
            "health",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventDetailsInput`](crate::input::DescribeEventDetailsInput)
    pub fn builder() -> crate::input::describe_event_details_input::Builder {
        crate::input::describe_event_details_input::Builder::default()
    }
}

/// See [`DescribeEventDetailsForOrganizationInput`](crate::input::DescribeEventDetailsForOrganizationInput)
pub mod describe_event_details_for_organization_input {
    /// A builder for [`DescribeEventDetailsForOrganizationInput`](crate::input::DescribeEventDetailsForOrganizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) organization_event_detail_filters:
            std::option::Option<std::vec::Vec<crate::model::EventAccountFilter>>,
        pub(crate) locale: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `organization_event_detail_filters`.
        ///
        /// To override the contents of this collection use [`set_organization_event_detail_filters`](Self::set_organization_event_detail_filters).
        ///
        /// <p>A set of JSON elements that includes the <code>awsAccountId</code> and the
        /// <code>eventArn</code>.</p>
        pub fn organization_event_detail_filters(
            mut self,
            input: impl Into<crate::model::EventAccountFilter>,
        ) -> Self {
            let mut v = self.organization_event_detail_filters.unwrap_or_default();
            v.push(input.into());
            self.organization_event_detail_filters = Some(v);
            self
        }
        /// <p>A set of JSON elements that includes the <code>awsAccountId</code> and the
        /// <code>eventArn</code>.</p>
        pub fn set_organization_event_detail_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventAccountFilter>>,
        ) -> Self {
            self.organization_event_detail_filters = input;
            self
        }
        /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
        pub fn locale(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale = Some(input.into());
            self
        }
        /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
        pub fn set_locale(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventDetailsForOrganizationInput`](crate::input::DescribeEventDetailsForOrganizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventDetailsForOrganizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventDetailsForOrganizationInput {
                organization_event_detail_filters: self.organization_event_detail_filters,
                locale: self.locale,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEventDetailsForOrganizationInputOperationOutputAlias =
    crate::operation::DescribeEventDetailsForOrganization;
#[doc(hidden)]
pub type DescribeEventDetailsForOrganizationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeEventDetailsForOrganizationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEventDetailsForOrganization`](crate::operation::DescribeEventDetailsForOrganization)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEventDetailsForOrganization,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEventDetailsForOrganizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEventDetailsForOrganizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEventDetailsForOrganizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHealth_20160804.DescribeEventDetailsForOrganization",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_event_details_for_organization(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEventDetailsForOrganization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEventDetailsForOrganization",
            "health",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventDetailsForOrganizationInput`](crate::input::DescribeEventDetailsForOrganizationInput)
    pub fn builder() -> crate::input::describe_event_details_for_organization_input::Builder {
        crate::input::describe_event_details_for_organization_input::Builder::default()
    }
}

/// See [`DescribeEventsInput`](crate::input::DescribeEventsInput)
pub mod describe_events_input {
    /// A builder for [`DescribeEventsInput`](crate::input::DescribeEventsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter: std::option::Option<crate::model::EventFilter>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) locale: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Values to narrow the results returned.</p>
        pub fn filter(mut self, input: crate::model::EventFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Values to narrow the results returned.</p>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::EventFilter>) -> Self {
            self.filter = input;
            self
        }
        /// <p>If the results of a search are large, only a portion of the
        /// results are returned, and a <code>nextToken</code> pagination token is returned in the response. To
        /// retrieve the next batch of results, reissue the search request and include the returned token.
        /// When all results have been returned, the response does not contain a pagination token value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the results of a search are large, only a portion of the
        /// results are returned, and a <code>nextToken</code> pagination token is returned in the response. To
        /// retrieve the next batch of results, reissue the search request and include the returned token.
        /// When all results have been returned, the response does not contain a pagination token value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
        pub fn locale(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale = Some(input.into());
            self
        }
        /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
        pub fn set_locale(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventsInput`](crate::input::DescribeEventsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventsInput {
                filter: self.filter,
                next_token: self.next_token,
                max_results: self.max_results,
                locale: self.locale,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEventsInputOperationOutputAlias = crate::operation::DescribeEvents;
#[doc(hidden)]
pub type DescribeEventsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEventsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEvents`](crate::operation::DescribeEvents)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEvents,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEventsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEventsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEventsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHealth_20160804.DescribeEvents",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_events(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEvents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEvents",
            "health",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventsInput`](crate::input::DescribeEventsInput)
    pub fn builder() -> crate::input::describe_events_input::Builder {
        crate::input::describe_events_input::Builder::default()
    }
}

/// See [`DescribeEventsForOrganizationInput`](crate::input::DescribeEventsForOrganizationInput)
pub mod describe_events_for_organization_input {
    /// A builder for [`DescribeEventsForOrganizationInput`](crate::input::DescribeEventsForOrganizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter: std::option::Option<crate::model::OrganizationEventFilter>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) locale: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Values to narrow the results returned.</p>
        pub fn filter(mut self, input: crate::model::OrganizationEventFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Values to narrow the results returned.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::OrganizationEventFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>If the results of a search are large, only a portion of the
        /// results are returned, and a <code>nextToken</code> pagination token is returned in the response. To
        /// retrieve the next batch of results, reissue the search request and include the returned token.
        /// When all results have been returned, the response does not contain a pagination token value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the results of a search are large, only a portion of the
        /// results are returned, and a <code>nextToken</code> pagination token is returned in the response. To
        /// retrieve the next batch of results, reissue the search request and include the returned token.
        /// When all results have been returned, the response does not contain a pagination token value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
        pub fn locale(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale = Some(input.into());
            self
        }
        /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
        pub fn set_locale(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventsForOrganizationInput`](crate::input::DescribeEventsForOrganizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventsForOrganizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventsForOrganizationInput {
                filter: self.filter,
                next_token: self.next_token,
                max_results: self.max_results,
                locale: self.locale,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEventsForOrganizationInputOperationOutputAlias =
    crate::operation::DescribeEventsForOrganization;
#[doc(hidden)]
pub type DescribeEventsForOrganizationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEventsForOrganizationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEventsForOrganization`](crate::operation::DescribeEventsForOrganization)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEventsForOrganization,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEventsForOrganizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEventsForOrganizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEventsForOrganizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHealth_20160804.DescribeEventsForOrganization",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_events_for_organization(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEventsForOrganization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEventsForOrganization",
            "health",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventsForOrganizationInput`](crate::input::DescribeEventsForOrganizationInput)
    pub fn builder() -> crate::input::describe_events_for_organization_input::Builder {
        crate::input::describe_events_for_organization_input::Builder::default()
    }
}

/// See [`DescribeEventTypesInput`](crate::input::DescribeEventTypesInput)
pub mod describe_event_types_input {
    /// A builder for [`DescribeEventTypesInput`](crate::input::DescribeEventTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter: std::option::Option<crate::model::EventTypeFilter>,
        pub(crate) locale: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Values to narrow the results returned.</p>
        pub fn filter(mut self, input: crate::model::EventTypeFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Values to narrow the results returned.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::EventTypeFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
        pub fn locale(mut self, input: impl Into<std::string::String>) -> Self {
            self.locale = Some(input.into());
            self
        }
        /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
        pub fn set_locale(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.locale = input;
            self
        }
        /// <p>If the results of a search are large, only a portion of the
        /// results are returned, and a <code>nextToken</code> pagination token is returned in the response. To
        /// retrieve the next batch of results, reissue the search request and include the returned token.
        /// When all results have been returned, the response does not contain a pagination token value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the results of a search are large, only a portion of the
        /// results are returned, and a <code>nextToken</code> pagination token is returned in the response. To
        /// retrieve the next batch of results, reissue the search request and include the returned token.
        /// When all results have been returned, the response does not contain a pagination token value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventTypesInput`](crate::input::DescribeEventTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventTypesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventTypesInput {
                filter: self.filter,
                locale: self.locale,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEventTypesInputOperationOutputAlias = crate::operation::DescribeEventTypes;
#[doc(hidden)]
pub type DescribeEventTypesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEventTypesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEventTypes`](crate::operation::DescribeEventTypes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEventTypes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEventTypesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEventTypesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEventTypesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHealth_20160804.DescribeEventTypes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_event_types(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEventTypes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEventTypes",
            "health",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventTypesInput`](crate::input::DescribeEventTypesInput)
    pub fn builder() -> crate::input::describe_event_types_input::Builder {
        crate::input::describe_event_types_input::Builder::default()
    }
}

/// See [`DescribeHealthServiceStatusForOrganizationInput`](crate::input::DescribeHealthServiceStatusForOrganizationInput)
pub mod describe_health_service_status_for_organization_input {
    /// A builder for [`DescribeHealthServiceStatusForOrganizationInput`](crate::input::DescribeHealthServiceStatusForOrganizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeHealthServiceStatusForOrganizationInput`](crate::input::DescribeHealthServiceStatusForOrganizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeHealthServiceStatusForOrganizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeHealthServiceStatusForOrganizationInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeHealthServiceStatusForOrganizationInputOperationOutputAlias =
    crate::operation::DescribeHealthServiceStatusForOrganization;
#[doc(hidden)]
pub type DescribeHealthServiceStatusForOrganizationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeHealthServiceStatusForOrganizationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeHealthServiceStatusForOrganization`](crate::operation::DescribeHealthServiceStatusForOrganization)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeHealthServiceStatusForOrganization,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeHealthServiceStatusForOrganizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeHealthServiceStatusForOrganizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeHealthServiceStatusForOrganizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHealth_20160804.DescribeHealthServiceStatusForOrganization",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_health_service_status_for_organization(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeHealthServiceStatusForOrganization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeHealthServiceStatusForOrganization",
            "health",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeHealthServiceStatusForOrganizationInput`](crate::input::DescribeHealthServiceStatusForOrganizationInput)
    pub fn builder() -> crate::input::describe_health_service_status_for_organization_input::Builder
    {
        crate::input::describe_health_service_status_for_organization_input::Builder::default()
    }
}

/// See [`DisableHealthServiceAccessForOrganizationInput`](crate::input::DisableHealthServiceAccessForOrganizationInput)
pub mod disable_health_service_access_for_organization_input {
    /// A builder for [`DisableHealthServiceAccessForOrganizationInput`](crate::input::DisableHealthServiceAccessForOrganizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisableHealthServiceAccessForOrganizationInput`](crate::input::DisableHealthServiceAccessForOrganizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisableHealthServiceAccessForOrganizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisableHealthServiceAccessForOrganizationInput {})
        }
    }
}
#[doc(hidden)]
pub type DisableHealthServiceAccessForOrganizationInputOperationOutputAlias =
    crate::operation::DisableHealthServiceAccessForOrganization;
#[doc(hidden)]
pub type DisableHealthServiceAccessForOrganizationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DisableHealthServiceAccessForOrganizationInput {
    /// Consumes the builder and constructs an Operation<[`DisableHealthServiceAccessForOrganization`](crate::operation::DisableHealthServiceAccessForOrganization)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisableHealthServiceAccessForOrganization,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisableHealthServiceAccessForOrganizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisableHealthServiceAccessForOrganizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisableHealthServiceAccessForOrganizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHealth_20160804.DisableHealthServiceAccessForOrganization",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disable_health_service_access_for_organization(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisableHealthServiceAccessForOrganization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisableHealthServiceAccessForOrganization",
            "health",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisableHealthServiceAccessForOrganizationInput`](crate::input::DisableHealthServiceAccessForOrganizationInput)
    pub fn builder() -> crate::input::disable_health_service_access_for_organization_input::Builder
    {
        crate::input::disable_health_service_access_for_organization_input::Builder::default()
    }
}

/// See [`EnableHealthServiceAccessForOrganizationInput`](crate::input::EnableHealthServiceAccessForOrganizationInput)
pub mod enable_health_service_access_for_organization_input {
    /// A builder for [`EnableHealthServiceAccessForOrganizationInput`](crate::input::EnableHealthServiceAccessForOrganizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`EnableHealthServiceAccessForOrganizationInput`](crate::input::EnableHealthServiceAccessForOrganizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnableHealthServiceAccessForOrganizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnableHealthServiceAccessForOrganizationInput {})
        }
    }
}
#[doc(hidden)]
pub type EnableHealthServiceAccessForOrganizationInputOperationOutputAlias =
    crate::operation::EnableHealthServiceAccessForOrganization;
#[doc(hidden)]
pub type EnableHealthServiceAccessForOrganizationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl EnableHealthServiceAccessForOrganizationInput {
    /// Consumes the builder and constructs an Operation<[`EnableHealthServiceAccessForOrganization`](crate::operation::EnableHealthServiceAccessForOrganization)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnableHealthServiceAccessForOrganization,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::EnableHealthServiceAccessForOrganizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::EnableHealthServiceAccessForOrganizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::EnableHealthServiceAccessForOrganizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSHealth_20160804.EnableHealthServiceAccessForOrganization",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_enable_health_service_access_for_organization(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnableHealthServiceAccessForOrganization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnableHealthServiceAccessForOrganization",
            "health",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`EnableHealthServiceAccessForOrganizationInput`](crate::input::EnableHealthServiceAccessForOrganizationInput)
    pub fn builder() -> crate::input::enable_health_service_access_for_organization_input::Builder {
        crate::input::enable_health_service_access_for_organization_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableHealthServiceAccessForOrganizationInput {}
impl std::fmt::Debug for EnableHealthServiceAccessForOrganizationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableHealthServiceAccessForOrganizationInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableHealthServiceAccessForOrganizationInput {}
impl std::fmt::Debug for DisableHealthServiceAccessForOrganizationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableHealthServiceAccessForOrganizationInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeHealthServiceStatusForOrganizationInput {}
impl std::fmt::Debug for DescribeHealthServiceStatusForOrganizationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeHealthServiceStatusForOrganizationInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventTypesInput {
    /// <p>Values to narrow the results returned.</p>
    pub filter: std::option::Option<crate::model::EventTypeFilter>,
    /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
    pub locale: std::option::Option<std::string::String>,
    /// <p>If the results of a search are large, only a portion of the
    /// results are returned, and a <code>nextToken</code> pagination token is returned in the response. To
    /// retrieve the next batch of results, reissue the search request and include the returned token.
    /// When all results have been returned, the response does not contain a pagination token value.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeEventTypesInput {
    /// <p>Values to narrow the results returned.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::EventTypeFilter> {
        self.filter.as_ref()
    }
    /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
    pub fn locale(&self) -> std::option::Option<&str> {
        self.locale.as_deref()
    }
    /// <p>If the results of a search are large, only a portion of the
    /// results are returned, and a <code>nextToken</code> pagination token is returned in the response. To
    /// retrieve the next batch of results, reissue the search request and include the returned token.
    /// When all results have been returned, the response does not contain a pagination token value.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeEventTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventTypesInput");
        formatter.field("filter", &self.filter);
        formatter.field("locale", &self.locale);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventsForOrganizationInput {
    /// <p>Values to narrow the results returned.</p>
    pub filter: std::option::Option<crate::model::OrganizationEventFilter>,
    /// <p>If the results of a search are large, only a portion of the
    /// results are returned, and a <code>nextToken</code> pagination token is returned in the response. To
    /// retrieve the next batch of results, reissue the search request and include the returned token.
    /// When all results have been returned, the response does not contain a pagination token value.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
    pub locale: std::option::Option<std::string::String>,
}
impl DescribeEventsForOrganizationInput {
    /// <p>Values to narrow the results returned.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::OrganizationEventFilter> {
        self.filter.as_ref()
    }
    /// <p>If the results of a search are large, only a portion of the
    /// results are returned, and a <code>nextToken</code> pagination token is returned in the response. To
    /// retrieve the next batch of results, reissue the search request and include the returned token.
    /// When all results have been returned, the response does not contain a pagination token value.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
    pub fn locale(&self) -> std::option::Option<&str> {
        self.locale.as_deref()
    }
}
impl std::fmt::Debug for DescribeEventsForOrganizationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventsForOrganizationInput");
        formatter.field("filter", &self.filter);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("locale", &self.locale);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventsInput {
    /// <p>Values to narrow the results returned.</p>
    pub filter: std::option::Option<crate::model::EventFilter>,
    /// <p>If the results of a search are large, only a portion of the
    /// results are returned, and a <code>nextToken</code> pagination token is returned in the response. To
    /// retrieve the next batch of results, reissue the search request and include the returned token.
    /// When all results have been returned, the response does not contain a pagination token value.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
    pub locale: std::option::Option<std::string::String>,
}
impl DescribeEventsInput {
    /// <p>Values to narrow the results returned.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::EventFilter> {
        self.filter.as_ref()
    }
    /// <p>If the results of a search are large, only a portion of the
    /// results are returned, and a <code>nextToken</code> pagination token is returned in the response. To
    /// retrieve the next batch of results, reissue the search request and include the returned token.
    /// When all results have been returned, the response does not contain a pagination token value.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
    pub fn locale(&self) -> std::option::Option<&str> {
        self.locale.as_deref()
    }
}
impl std::fmt::Debug for DescribeEventsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventsInput");
        formatter.field("filter", &self.filter);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("locale", &self.locale);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventDetailsForOrganizationInput {
    /// <p>A set of JSON elements that includes the <code>awsAccountId</code> and the
    /// <code>eventArn</code>.</p>
    pub organization_event_detail_filters:
        std::option::Option<std::vec::Vec<crate::model::EventAccountFilter>>,
    /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
    pub locale: std::option::Option<std::string::String>,
}
impl DescribeEventDetailsForOrganizationInput {
    /// <p>A set of JSON elements that includes the <code>awsAccountId</code> and the
    /// <code>eventArn</code>.</p>
    pub fn organization_event_detail_filters(
        &self,
    ) -> std::option::Option<&[crate::model::EventAccountFilter]> {
        self.organization_event_detail_filters.as_deref()
    }
    /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
    pub fn locale(&self) -> std::option::Option<&str> {
        self.locale.as_deref()
    }
}
impl std::fmt::Debug for DescribeEventDetailsForOrganizationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventDetailsForOrganizationInput");
        formatter.field(
            "organization_event_detail_filters",
            &self.organization_event_detail_filters,
        );
        formatter.field("locale", &self.locale);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventDetailsInput {
    /// <p>A list of event ARNs (unique identifiers). For example: <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
    /// </p>
    pub event_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
    pub locale: std::option::Option<std::string::String>,
}
impl DescribeEventDetailsInput {
    /// <p>A list of event ARNs (unique identifiers). For example: <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
    /// </p>
    pub fn event_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.event_arns.as_deref()
    }
    /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
    pub fn locale(&self) -> std::option::Option<&str> {
        self.locale.as_deref()
    }
}
impl std::fmt::Debug for DescribeEventDetailsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventDetailsInput");
        formatter.field("event_arns", &self.event_arns);
        formatter.field("locale", &self.locale);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventAggregatesInput {
    /// <p>Values to narrow the results returned.</p>
    pub filter: std::option::Option<crate::model::EventFilter>,
    /// <p>The only currently supported value is <code>eventTypeCategory</code>.</p>
    pub aggregate_field: std::option::Option<crate::model::EventAggregateField>,
    /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>If the results of a search are large, only a portion of the
    /// results are returned, and a <code>nextToken</code> pagination token is returned in the response. To
    /// retrieve the next batch of results, reissue the search request and include the returned token.
    /// When all results have been returned, the response does not contain a pagination token value.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeEventAggregatesInput {
    /// <p>Values to narrow the results returned.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::EventFilter> {
        self.filter.as_ref()
    }
    /// <p>The only currently supported value is <code>eventTypeCategory</code>.</p>
    pub fn aggregate_field(&self) -> std::option::Option<&crate::model::EventAggregateField> {
        self.aggregate_field.as_ref()
    }
    /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>If the results of a search are large, only a portion of the
    /// results are returned, and a <code>nextToken</code> pagination token is returned in the response. To
    /// retrieve the next batch of results, reissue the search request and include the returned token.
    /// When all results have been returned, the response does not contain a pagination token value.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeEventAggregatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventAggregatesInput");
        formatter.field("filter", &self.filter);
        formatter.field("aggregate_field", &self.aggregate_field);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEntityAggregatesInput {
    /// <p>A list of event ARNs (unique identifiers). For example: <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
    /// </p>
    pub event_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeEntityAggregatesInput {
    /// <p>A list of event ARNs (unique identifiers). For example: <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
    /// </p>
    pub fn event_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.event_arns.as_deref()
    }
}
impl std::fmt::Debug for DescribeEntityAggregatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEntityAggregatesInput");
        formatter.field("event_arns", &self.event_arns);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAffectedEntitiesForOrganizationInput {
    /// <p>A JSON set of elements including the <code>awsAccountId</code> and the
    /// <code>eventArn</code>.</p>
    pub organization_entity_filters:
        std::option::Option<std::vec::Vec<crate::model::EventAccountFilter>>,
    /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
    pub locale: std::option::Option<std::string::String>,
    /// <p>If the results of a search are large, only a portion of the
    /// results are returned, and a <code>nextToken</code> pagination token is returned in the response. To
    /// retrieve the next batch of results, reissue the search request and include the returned token.
    /// When all results have been returned, the response does not contain a pagination token value.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeAffectedEntitiesForOrganizationInput {
    /// <p>A JSON set of elements including the <code>awsAccountId</code> and the
    /// <code>eventArn</code>.</p>
    pub fn organization_entity_filters(
        &self,
    ) -> std::option::Option<&[crate::model::EventAccountFilter]> {
        self.organization_entity_filters.as_deref()
    }
    /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
    pub fn locale(&self) -> std::option::Option<&str> {
        self.locale.as_deref()
    }
    /// <p>If the results of a search are large, only a portion of the
    /// results are returned, and a <code>nextToken</code> pagination token is returned in the response. To
    /// retrieve the next batch of results, reissue the search request and include the returned token.
    /// When all results have been returned, the response does not contain a pagination token value.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeAffectedEntitiesForOrganizationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAffectedEntitiesForOrganizationInput");
        formatter.field(
            "organization_entity_filters",
            &self.organization_entity_filters,
        );
        formatter.field("locale", &self.locale);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAffectedEntitiesInput {
    /// <p>Values to narrow the results returned. At least one event ARN is required.</p>
    pub filter: std::option::Option<crate::model::EntityFilter>,
    /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
    pub locale: std::option::Option<std::string::String>,
    /// <p>If the results of a search are large, only a portion of the
    /// results are returned, and a <code>nextToken</code> pagination token is returned in the response. To
    /// retrieve the next batch of results, reissue the search request and include the returned token.
    /// When all results have been returned, the response does not contain a pagination token value.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeAffectedEntitiesInput {
    /// <p>Values to narrow the results returned. At least one event ARN is required.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::EntityFilter> {
        self.filter.as_ref()
    }
    /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
    pub fn locale(&self) -> std::option::Option<&str> {
        self.locale.as_deref()
    }
    /// <p>If the results of a search are large, only a portion of the
    /// results are returned, and a <code>nextToken</code> pagination token is returned in the response. To
    /// retrieve the next batch of results, reissue the search request and include the returned token.
    /// When all results have been returned, the response does not contain a pagination token value.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeAffectedEntitiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAffectedEntitiesInput");
        formatter.field("filter", &self.filter);
        formatter.field("locale", &self.locale);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAffectedAccountsForOrganizationInput {
    /// <p>The unique identifier for the event. The event ARN has the
    /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
    /// </code>
    /// format.</p>
    /// <p>For example, an event ARN might look like the following:</p>
    /// <p>
    /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
    /// </p>
    pub event_arn: std::option::Option<std::string::String>,
    /// <p>If the results of a search are large, only a portion of the
    /// results are returned, and a <code>nextToken</code> pagination token is returned in the response. To
    /// retrieve the next batch of results, reissue the search request and include the returned token.
    /// When all results have been returned, the response does not contain a pagination token value.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeAffectedAccountsForOrganizationInput {
    /// <p>The unique identifier for the event. The event ARN has the
    /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
    /// </code>
    /// format.</p>
    /// <p>For example, an event ARN might look like the following:</p>
    /// <p>
    /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
    /// </p>
    pub fn event_arn(&self) -> std::option::Option<&str> {
        self.event_arn.as_deref()
    }
    /// <p>If the results of a search are large, only a portion of the
    /// results are returned, and a <code>nextToken</code> pagination token is returned in the response. To
    /// retrieve the next batch of results, reissue the search request and include the returned token.
    /// When all results have been returned, the response does not contain a pagination token value.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeAffectedAccountsForOrganizationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAffectedAccountsForOrganizationInput");
        formatter.field("event_arn", &self.event_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}
