// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Health APIs and Notifications
///
/// Client for invoking operations on AWS Health APIs and Notifications. Each operation on AWS Health APIs and Notifications is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_health::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_health::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_health::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`DescribeAffectedAccountsForOrganization`](crate::client::fluent_builders::DescribeAffectedAccountsForOrganization) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeAffectedAccountsForOrganization::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`event_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeAffectedAccountsForOrganization::event_arn) / [`set_event_arn(Option<String>)`](crate::client::fluent_builders::DescribeAffectedAccountsForOrganization::set_event_arn): <p>The unique identifier for the event. The event ARN has the <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i> </code> format.</p>  <p>For example, an event ARN might look like the following:</p>  <p> <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code> </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeAffectedAccountsForOrganization::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeAffectedAccountsForOrganization::set_next_token): <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeAffectedAccountsForOrganization::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeAffectedAccountsForOrganization::set_max_results): <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
    /// - On success, responds with [`DescribeAffectedAccountsForOrganizationOutput`](crate::output::DescribeAffectedAccountsForOrganizationOutput) with field(s):
    ///   - [`affected_accounts(Option<Vec<String>>)`](crate::output::DescribeAffectedAccountsForOrganizationOutput::affected_accounts): <p>A JSON set of elements of the affected accounts.</p>
    ///   - [`event_scope_code(Option<EventScopeCode>)`](crate::output::DescribeAffectedAccountsForOrganizationOutput::event_scope_code): <p>This parameter specifies if the Health event is a public Amazon Web Services service event or an account-specific event.</p>  <ul>   <li> <p>If the <code>eventScopeCode</code> value is <code>PUBLIC</code>, then the <code>affectedAccounts</code> value is always empty.</p> </li>   <li> <p>If the <code>eventScopeCode</code> value is <code>ACCOUNT_SPECIFIC</code>, then the <code>affectedAccounts</code> value lists the affected Amazon Web Services accounts in your organization. For example, if an event affects a service such as Amazon Elastic Compute Cloud and you have Amazon Web Services accounts that use that service, those account IDs appear in the response.</p> </li>   <li> <p>If the <code>eventScopeCode</code> value is <code>NONE</code>, then the <code>eventArn</code> that you specified in the request is invalid or doesn't exist.</p> </li>  </ul>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeAffectedAccountsForOrganizationOutput::next_token): <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value.</p>
    /// - On failure, responds with [`SdkError<DescribeAffectedAccountsForOrganizationError>`](crate::error::DescribeAffectedAccountsForOrganizationError)
    pub fn describe_affected_accounts_for_organization(
        &self,
    ) -> fluent_builders::DescribeAffectedAccountsForOrganization {
        fluent_builders::DescribeAffectedAccountsForOrganization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAffectedEntities`](crate::client::fluent_builders::DescribeAffectedEntities) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeAffectedEntities::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter(EntityFilter)`](crate::client::fluent_builders::DescribeAffectedEntities::filter) / [`set_filter(Option<EntityFilter>)`](crate::client::fluent_builders::DescribeAffectedEntities::set_filter): <p>Values to narrow the results returned. At least one event ARN is required.</p>
    ///   - [`locale(impl Into<String>)`](crate::client::fluent_builders::DescribeAffectedEntities::locale) / [`set_locale(Option<String>)`](crate::client::fluent_builders::DescribeAffectedEntities::set_locale): <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeAffectedEntities::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeAffectedEntities::set_next_token): <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeAffectedEntities::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeAffectedEntities::set_max_results): <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
    /// - On success, responds with [`DescribeAffectedEntitiesOutput`](crate::output::DescribeAffectedEntitiesOutput) with field(s):
    ///   - [`entities(Option<Vec<AffectedEntity>>)`](crate::output::DescribeAffectedEntitiesOutput::entities): <p>The entities that match the filter criteria.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeAffectedEntitiesOutput::next_token): <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value.</p>
    /// - On failure, responds with [`SdkError<DescribeAffectedEntitiesError>`](crate::error::DescribeAffectedEntitiesError)
    pub fn describe_affected_entities(&self) -> fluent_builders::DescribeAffectedEntities {
        fluent_builders::DescribeAffectedEntities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAffectedEntitiesForOrganization`](crate::client::fluent_builders::DescribeAffectedEntitiesForOrganization) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeAffectedEntitiesForOrganization::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_entity_filters(Vec<EventAccountFilter>)`](crate::client::fluent_builders::DescribeAffectedEntitiesForOrganization::organization_entity_filters) / [`set_organization_entity_filters(Option<Vec<EventAccountFilter>>)`](crate::client::fluent_builders::DescribeAffectedEntitiesForOrganization::set_organization_entity_filters): <p>A JSON set of elements including the <code>awsAccountId</code> and the <code>eventArn</code>.</p>
    ///   - [`locale(impl Into<String>)`](crate::client::fluent_builders::DescribeAffectedEntitiesForOrganization::locale) / [`set_locale(Option<String>)`](crate::client::fluent_builders::DescribeAffectedEntitiesForOrganization::set_locale): <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeAffectedEntitiesForOrganization::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeAffectedEntitiesForOrganization::set_next_token): <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeAffectedEntitiesForOrganization::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeAffectedEntitiesForOrganization::set_max_results): <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
    /// - On success, responds with [`DescribeAffectedEntitiesForOrganizationOutput`](crate::output::DescribeAffectedEntitiesForOrganizationOutput) with field(s):
    ///   - [`entities(Option<Vec<AffectedEntity>>)`](crate::output::DescribeAffectedEntitiesForOrganizationOutput::entities): <p>A JSON set of elements including the <code>awsAccountId</code> and its <code>entityArn</code>, <code>entityValue</code> and its <code>entityArn</code>, <code>lastUpdatedTime</code>, and <code>statusCode</code>.</p>
    ///   - [`failed_set(Option<Vec<OrganizationAffectedEntitiesErrorItem>>)`](crate::output::DescribeAffectedEntitiesForOrganizationOutput::failed_set): <p>A JSON set of elements of the failed response, including the <code>awsAccountId</code>, <code>errorMessage</code>, <code>errorName</code>, and <code>eventArn</code>.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeAffectedEntitiesForOrganizationOutput::next_token): <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value.</p>
    /// - On failure, responds with [`SdkError<DescribeAffectedEntitiesForOrganizationError>`](crate::error::DescribeAffectedEntitiesForOrganizationError)
    pub fn describe_affected_entities_for_organization(
        &self,
    ) -> fluent_builders::DescribeAffectedEntitiesForOrganization {
        fluent_builders::DescribeAffectedEntitiesForOrganization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEntityAggregates`](crate::client::fluent_builders::DescribeEntityAggregates) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`event_arns(Vec<String>)`](crate::client::fluent_builders::DescribeEntityAggregates::event_arns) / [`set_event_arns(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeEntityAggregates::set_event_arns): <p>A list of event ARNs (unique identifiers). For example: <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code> </p>
    /// - On success, responds with [`DescribeEntityAggregatesOutput`](crate::output::DescribeEntityAggregatesOutput) with field(s):
    ///   - [`entity_aggregates(Option<Vec<EntityAggregate>>)`](crate::output::DescribeEntityAggregatesOutput::entity_aggregates): <p>The number of entities that are affected by each of the specified events.</p>
    /// - On failure, responds with [`SdkError<DescribeEntityAggregatesError>`](crate::error::DescribeEntityAggregatesError)
    pub fn describe_entity_aggregates(&self) -> fluent_builders::DescribeEntityAggregates {
        fluent_builders::DescribeEntityAggregates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEventAggregates`](crate::client::fluent_builders::DescribeEventAggregates) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeEventAggregates::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter(EventFilter)`](crate::client::fluent_builders::DescribeEventAggregates::filter) / [`set_filter(Option<EventFilter>)`](crate::client::fluent_builders::DescribeEventAggregates::set_filter): <p>Values to narrow the results returned.</p>
    ///   - [`aggregate_field(EventAggregateField)`](crate::client::fluent_builders::DescribeEventAggregates::aggregate_field) / [`set_aggregate_field(Option<EventAggregateField>)`](crate::client::fluent_builders::DescribeEventAggregates::set_aggregate_field): <p>The only currently supported value is <code>eventTypeCategory</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeEventAggregates::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeEventAggregates::set_max_results): <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeEventAggregates::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeEventAggregates::set_next_token): <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value.</p>
    /// - On success, responds with [`DescribeEventAggregatesOutput`](crate::output::DescribeEventAggregatesOutput) with field(s):
    ///   - [`event_aggregates(Option<Vec<EventAggregate>>)`](crate::output::DescribeEventAggregatesOutput::event_aggregates): <p>The number of events in each category that meet the optional filter criteria.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeEventAggregatesOutput::next_token): <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value.</p>
    /// - On failure, responds with [`SdkError<DescribeEventAggregatesError>`](crate::error::DescribeEventAggregatesError)
    pub fn describe_event_aggregates(&self) -> fluent_builders::DescribeEventAggregates {
        fluent_builders::DescribeEventAggregates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEventDetails`](crate::client::fluent_builders::DescribeEventDetails) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`event_arns(Vec<String>)`](crate::client::fluent_builders::DescribeEventDetails::event_arns) / [`set_event_arns(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeEventDetails::set_event_arns): <p>A list of event ARNs (unique identifiers). For example: <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code> </p>
    ///   - [`locale(impl Into<String>)`](crate::client::fluent_builders::DescribeEventDetails::locale) / [`set_locale(Option<String>)`](crate::client::fluent_builders::DescribeEventDetails::set_locale): <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
    /// - On success, responds with [`DescribeEventDetailsOutput`](crate::output::DescribeEventDetailsOutput) with field(s):
    ///   - [`successful_set(Option<Vec<EventDetails>>)`](crate::output::DescribeEventDetailsOutput::successful_set): <p>Information about the events that could be retrieved.</p>
    ///   - [`failed_set(Option<Vec<EventDetailsErrorItem>>)`](crate::output::DescribeEventDetailsOutput::failed_set): <p>Error messages for any events that could not be retrieved.</p>
    /// - On failure, responds with [`SdkError<DescribeEventDetailsError>`](crate::error::DescribeEventDetailsError)
    pub fn describe_event_details(&self) -> fluent_builders::DescribeEventDetails {
        fluent_builders::DescribeEventDetails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEventDetailsForOrganization`](crate::client::fluent_builders::DescribeEventDetailsForOrganization) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`organization_event_detail_filters(Vec<EventAccountFilter>)`](crate::client::fluent_builders::DescribeEventDetailsForOrganization::organization_event_detail_filters) / [`set_organization_event_detail_filters(Option<Vec<EventAccountFilter>>)`](crate::client::fluent_builders::DescribeEventDetailsForOrganization::set_organization_event_detail_filters): <p>A set of JSON elements that includes the <code>awsAccountId</code> and the <code>eventArn</code>.</p>
    ///   - [`locale(impl Into<String>)`](crate::client::fluent_builders::DescribeEventDetailsForOrganization::locale) / [`set_locale(Option<String>)`](crate::client::fluent_builders::DescribeEventDetailsForOrganization::set_locale): <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
    /// - On success, responds with [`DescribeEventDetailsForOrganizationOutput`](crate::output::DescribeEventDetailsForOrganizationOutput) with field(s):
    ///   - [`successful_set(Option<Vec<OrganizationEventDetails>>)`](crate::output::DescribeEventDetailsForOrganizationOutput::successful_set): <p>Information about the events that could be retrieved.</p>
    ///   - [`failed_set(Option<Vec<OrganizationEventDetailsErrorItem>>)`](crate::output::DescribeEventDetailsForOrganizationOutput::failed_set): <p>Error messages for any events that could not be retrieved.</p>
    /// - On failure, responds with [`SdkError<DescribeEventDetailsForOrganizationError>`](crate::error::DescribeEventDetailsForOrganizationError)
    pub fn describe_event_details_for_organization(
        &self,
    ) -> fluent_builders::DescribeEventDetailsForOrganization {
        fluent_builders::DescribeEventDetailsForOrganization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEvents`](crate::client::fluent_builders::DescribeEvents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeEvents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter(EventFilter)`](crate::client::fluent_builders::DescribeEvents::filter) / [`set_filter(Option<EventFilter>)`](crate::client::fluent_builders::DescribeEvents::set_filter): <p>Values to narrow the results returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeEvents::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeEvents::set_next_token): <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeEvents::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeEvents::set_max_results): <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
    ///   - [`locale(impl Into<String>)`](crate::client::fluent_builders::DescribeEvents::locale) / [`set_locale(Option<String>)`](crate::client::fluent_builders::DescribeEvents::set_locale): <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
    /// - On success, responds with [`DescribeEventsOutput`](crate::output::DescribeEventsOutput) with field(s):
    ///   - [`events(Option<Vec<Event>>)`](crate::output::DescribeEventsOutput::events): <p>The events that match the specified filter criteria.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeEventsOutput::next_token): <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value.</p>
    /// - On failure, responds with [`SdkError<DescribeEventsError>`](crate::error::DescribeEventsError)
    pub fn describe_events(&self) -> fluent_builders::DescribeEvents {
        fluent_builders::DescribeEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEventsForOrganization`](crate::client::fluent_builders::DescribeEventsForOrganization) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeEventsForOrganization::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter(OrganizationEventFilter)`](crate::client::fluent_builders::DescribeEventsForOrganization::filter) / [`set_filter(Option<OrganizationEventFilter>)`](crate::client::fluent_builders::DescribeEventsForOrganization::set_filter): <p>Values to narrow the results returned.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeEventsForOrganization::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeEventsForOrganization::set_next_token): <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeEventsForOrganization::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeEventsForOrganization::set_max_results): <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
    ///   - [`locale(impl Into<String>)`](crate::client::fluent_builders::DescribeEventsForOrganization::locale) / [`set_locale(Option<String>)`](crate::client::fluent_builders::DescribeEventsForOrganization::set_locale): <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
    /// - On success, responds with [`DescribeEventsForOrganizationOutput`](crate::output::DescribeEventsForOrganizationOutput) with field(s):
    ///   - [`events(Option<Vec<OrganizationEvent>>)`](crate::output::DescribeEventsForOrganizationOutput::events): <p>The events that match the specified filter criteria.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeEventsForOrganizationOutput::next_token): <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value.</p>
    /// - On failure, responds with [`SdkError<DescribeEventsForOrganizationError>`](crate::error::DescribeEventsForOrganizationError)
    pub fn describe_events_for_organization(
        &self,
    ) -> fluent_builders::DescribeEventsForOrganization {
        fluent_builders::DescribeEventsForOrganization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEventTypes`](crate::client::fluent_builders::DescribeEventTypes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeEventTypes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter(EventTypeFilter)`](crate::client::fluent_builders::DescribeEventTypes::filter) / [`set_filter(Option<EventTypeFilter>)`](crate::client::fluent_builders::DescribeEventTypes::set_filter): <p>Values to narrow the results returned.</p>
    ///   - [`locale(impl Into<String>)`](crate::client::fluent_builders::DescribeEventTypes::locale) / [`set_locale(Option<String>)`](crate::client::fluent_builders::DescribeEventTypes::set_locale): <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeEventTypes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeEventTypes::set_next_token): <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeEventTypes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeEventTypes::set_max_results): <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
    /// - On success, responds with [`DescribeEventTypesOutput`](crate::output::DescribeEventTypesOutput) with field(s):
    ///   - [`event_types(Option<Vec<EventType>>)`](crate::output::DescribeEventTypesOutput::event_types): <p>A list of event types that match the filter criteria. Event types have a category (<code>issue</code>, <code>accountNotification</code>, or <code>scheduledChange</code>), a service (for example, <code>EC2</code>, <code>RDS</code>, <code>DATAPIPELINE</code>, <code>BILLING</code>), and a code (in the format <code>AWS_<i>SERVICE</i>_<i>DESCRIPTION</i> </code>; for example, <code>AWS_EC2_SYSTEM_MAINTENANCE_EVENT</code>).</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeEventTypesOutput::next_token): <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value.</p>
    /// - On failure, responds with [`SdkError<DescribeEventTypesError>`](crate::error::DescribeEventTypesError)
    pub fn describe_event_types(&self) -> fluent_builders::DescribeEventTypes {
        fluent_builders::DescribeEventTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeHealthServiceStatusForOrganization`](crate::client::fluent_builders::DescribeHealthServiceStatusForOrganization) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeHealthServiceStatusForOrganization::send) it.

    /// - On success, responds with [`DescribeHealthServiceStatusForOrganizationOutput`](crate::output::DescribeHealthServiceStatusForOrganizationOutput) with field(s):
    ///   - [`health_service_access_status_for_organization(Option<String>)`](crate::output::DescribeHealthServiceStatusForOrganizationOutput::health_service_access_status_for_organization): <p>Information about the status of enabling or disabling the Health organizational view feature in your organization.</p>  <p>Valid values are <code>ENABLED | DISABLED | PENDING</code>. </p>
    /// - On failure, responds with [`SdkError<DescribeHealthServiceStatusForOrganizationError>`](crate::error::DescribeHealthServiceStatusForOrganizationError)
    pub fn describe_health_service_status_for_organization(
        &self,
    ) -> fluent_builders::DescribeHealthServiceStatusForOrganization {
        fluent_builders::DescribeHealthServiceStatusForOrganization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisableHealthServiceAccessForOrganization`](crate::client::fluent_builders::DisableHealthServiceAccessForOrganization) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DisableHealthServiceAccessForOrganization::send) it.

    /// - On success, responds with [`DisableHealthServiceAccessForOrganizationOutput`](crate::output::DisableHealthServiceAccessForOrganizationOutput)

    /// - On failure, responds with [`SdkError<DisableHealthServiceAccessForOrganizationError>`](crate::error::DisableHealthServiceAccessForOrganizationError)
    pub fn disable_health_service_access_for_organization(
        &self,
    ) -> fluent_builders::DisableHealthServiceAccessForOrganization {
        fluent_builders::DisableHealthServiceAccessForOrganization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EnableHealthServiceAccessForOrganization`](crate::client::fluent_builders::EnableHealthServiceAccessForOrganization) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::EnableHealthServiceAccessForOrganization::send) it.

    /// - On success, responds with [`EnableHealthServiceAccessForOrganizationOutput`](crate::output::EnableHealthServiceAccessForOrganizationOutput)

    /// - On failure, responds with [`SdkError<EnableHealthServiceAccessForOrganizationError>`](crate::error::EnableHealthServiceAccessForOrganizationError)
    pub fn enable_health_service_access_for_organization(
        &self,
    ) -> fluent_builders::EnableHealthServiceAccessForOrganization {
        fluent_builders::EnableHealthServiceAccessForOrganization::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `DescribeAffectedAccountsForOrganization`.
    ///
    /// <p>Returns a list of accounts in the organization from Organizations that are affected by the provided event. For more information about the different types of Health events, see <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_Event.html">Event</a>. </p>
    /// <p>Before you can call this operation, you must first enable Health to work with Organizations. To do this, call the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EnableHealthServiceAccessForOrganization.html">EnableHealthServiceAccessForOrganization</a> operation from your organization's management account.</p> <note>
    /// <p>This API operation uses pagination. Specify the <code>nextToken</code> parameter in the next request to return more results.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAffectedAccountsForOrganization {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_affected_accounts_for_organization_input::Builder,
    }
    impl DescribeAffectedAccountsForOrganization {
        /// Creates a new `DescribeAffectedAccountsForOrganization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAffectedAccountsForOrganizationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeAffectedAccountsForOrganizationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeAffectedAccountsForOrganizationPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeAffectedAccountsForOrganizationPaginator {
            crate::paginator::DescribeAffectedAccountsForOrganizationPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The unique identifier for the event. The event ARN has the <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i> </code> format.</p>
        /// <p>For example, an event ARN might look like the following:</p>
        /// <p> <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code> </p>
        pub fn event_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_arn(input.into());
            self
        }
        /// <p>The unique identifier for the event. The event ARN has the <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i> </code> format.</p>
        /// <p>For example, an event ARN might look like the following:</p>
        /// <p> <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code> </p>
        pub fn set_event_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_event_arn(input);
            self
        }
        /// <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAffectedEntities`.
    ///
    /// <p>Returns a list of entities that have been affected by the specified events, based on the specified filter criteria. Entities can refer to individual customer resources, groups of customer resources, or any other construct, depending on the Amazon Web Services service. Events that have impact beyond that of the affected entities, or where the extent of impact is unknown, include at least one entity indicating this.</p>
    /// <p>At least one event ARN is required.</p> <note>
    /// <ul>
    /// <li> <p>This API operation uses pagination. Specify the <code>nextToken</code> parameter in the next request to return more results.</p> </li>
    /// <li> <p>This operation supports resource-level permissions. You can use this operation to allow or deny access to specific Health events. For more information, see <a href="https://docs.aws.amazon.com/health/latest/ug/security_iam_id-based-policy-examples.html#resource-action-based-conditions">Resource- and action-based conditions</a> in the <i>Health User Guide</i>.</p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAffectedEntities {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_affected_entities_input::Builder,
    }
    impl DescribeAffectedEntities {
        /// Creates a new `DescribeAffectedEntities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAffectedEntitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAffectedEntitiesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeAffectedEntitiesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeAffectedEntitiesPaginator {
            crate::paginator::DescribeAffectedEntitiesPaginator::new(self.handle, self.inner)
        }
        /// <p>Values to narrow the results returned. At least one event ARN is required.</p>
        pub fn filter(mut self, input: crate::model::EntityFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Values to narrow the results returned. At least one event ARN is required.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::EntityFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
        pub fn locale(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale(input.into());
            self
        }
        /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
        pub fn set_locale(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale(input);
            self
        }
        /// <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAffectedEntitiesForOrganization`.
    ///
    /// <p>Returns a list of entities that have been affected by one or more events for one or more accounts in your organization in Organizations, based on the filter criteria. Entities can refer to individual customer resources, groups of customer resources, or any other construct, depending on the Amazon Web Services service.</p>
    /// <p>At least one event Amazon Resource Name (ARN) and account ID are required.</p>
    /// <p>Before you can call this operation, you must first enable Health to work with Organizations. To do this, call the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EnableHealthServiceAccessForOrganization.html">EnableHealthServiceAccessForOrganization</a> operation from your organization's management account.</p> <note>
    /// <ul>
    /// <li> <p>This API operation uses pagination. Specify the <code>nextToken</code> parameter in the next request to return more results.</p> </li>
    /// <li> <p>This operation doesn't support resource-level permissions. You can't use this operation to allow or deny access to specific Health events. For more information, see <a href="https://docs.aws.amazon.com/health/latest/ug/security_iam_id-based-policy-examples.html#resource-action-based-conditions">Resource- and action-based conditions</a> in the <i>Health User Guide</i>.</p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAffectedEntitiesForOrganization {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_affected_entities_for_organization_input::Builder,
    }
    impl DescribeAffectedEntitiesForOrganization {
        /// Creates a new `DescribeAffectedEntitiesForOrganization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAffectedEntitiesForOrganizationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeAffectedEntitiesForOrganizationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeAffectedEntitiesForOrganizationPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeAffectedEntitiesForOrganizationPaginator {
            crate::paginator::DescribeAffectedEntitiesForOrganizationPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// Appends an item to `organizationEntityFilters`.
        ///
        /// To override the contents of this collection use [`set_organization_entity_filters`](Self::set_organization_entity_filters).
        ///
        /// <p>A JSON set of elements including the <code>awsAccountId</code> and the <code>eventArn</code>.</p>
        pub fn organization_entity_filters(
            mut self,
            input: crate::model::EventAccountFilter,
        ) -> Self {
            self.inner = self.inner.organization_entity_filters(input);
            self
        }
        /// <p>A JSON set of elements including the <code>awsAccountId</code> and the <code>eventArn</code>.</p>
        pub fn set_organization_entity_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventAccountFilter>>,
        ) -> Self {
            self.inner = self.inner.set_organization_entity_filters(input);
            self
        }
        /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
        pub fn locale(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale(input.into());
            self
        }
        /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
        pub fn set_locale(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale(input);
            self
        }
        /// <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEntityAggregates`.
    ///
    /// <p>Returns the number of entities that are affected by each of the specified events.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEntityAggregates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_entity_aggregates_input::Builder,
    }
    impl DescribeEntityAggregates {
        /// Creates a new `DescribeEntityAggregates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEntityAggregatesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEntityAggregatesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `eventArns`.
        ///
        /// To override the contents of this collection use [`set_event_arns`](Self::set_event_arns).
        ///
        /// <p>A list of event ARNs (unique identifiers). For example: <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code> </p>
        pub fn event_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_arns(input.into());
            self
        }
        /// <p>A list of event ARNs (unique identifiers). For example: <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code> </p>
        pub fn set_event_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_event_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventAggregates`.
    ///
    /// <p>Returns the number of events of each event type (issue, scheduled change, and account notification). If no filter is specified, the counts of all events in each category are returned.</p> <note>
    /// <p>This API operation uses pagination. Specify the <code>nextToken</code> parameter in the next request to return more results.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEventAggregates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_event_aggregates_input::Builder,
    }
    impl DescribeEventAggregates {
        /// Creates a new `DescribeEventAggregates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventAggregatesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventAggregatesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeEventAggregatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeEventAggregatesPaginator {
            crate::paginator::DescribeEventAggregatesPaginator::new(self.handle, self.inner)
        }
        /// <p>Values to narrow the results returned.</p>
        pub fn filter(mut self, input: crate::model::EventFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Values to narrow the results returned.</p>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::EventFilter>) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>The only currently supported value is <code>eventTypeCategory</code>.</p>
        pub fn aggregate_field(mut self, input: crate::model::EventAggregateField) -> Self {
            self.inner = self.inner.aggregate_field(input);
            self
        }
        /// <p>The only currently supported value is <code>eventTypeCategory</code>.</p>
        pub fn set_aggregate_field(
            mut self,
            input: std::option::Option<crate::model::EventAggregateField>,
        ) -> Self {
            self.inner = self.inner.set_aggregate_field(input);
            self
        }
        /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventDetails`.
    ///
    /// <p>Returns detailed information about one or more specified events. Information includes standard event data (Amazon Web Services Region, service, and so on, as returned by <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEvents.html">DescribeEvents</a>), a detailed event description, and possible additional metadata that depends upon the nature of the event. Affected entities are not included. To retrieve the entities, use the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeAffectedEntities.html">DescribeAffectedEntities</a> operation.</p>
    /// <p>If a specified event can't be retrieved, an error message is returned for that event.</p> <note>
    /// <p>This operation supports resource-level permissions. You can use this operation to allow or deny access to specific Health events. For more information, see <a href="https://docs.aws.amazon.com/health/latest/ug/security_iam_id-based-policy-examples.html#resource-action-based-conditions">Resource- and action-based conditions</a> in the <i>Health User Guide</i>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEventDetails {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_event_details_input::Builder,
    }
    impl DescribeEventDetails {
        /// Creates a new `DescribeEventDetails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventDetailsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventDetailsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `eventArns`.
        ///
        /// To override the contents of this collection use [`set_event_arns`](Self::set_event_arns).
        ///
        /// <p>A list of event ARNs (unique identifiers). For example: <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code> </p>
        pub fn event_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_arns(input.into());
            self
        }
        /// <p>A list of event ARNs (unique identifiers). For example: <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code> </p>
        pub fn set_event_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_event_arns(input);
            self
        }
        /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
        pub fn locale(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale(input.into());
            self
        }
        /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
        pub fn set_locale(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventDetailsForOrganization`.
    ///
    /// <p>Returns detailed information about one or more specified events for one or more Amazon Web Services accounts in your organization. This information includes standard event data (such as the Amazon Web Services Region and service), an event description, and (depending on the event) possible metadata. This operation doesn't return affected entities, such as the resources related to the event. To return affected entities, use the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeAffectedEntitiesForOrganization.html">DescribeAffectedEntitiesForOrganization</a> operation.</p> <note>
    /// <p>Before you can call this operation, you must first enable Health to work with Organizations. To do this, call the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EnableHealthServiceAccessForOrganization.html">EnableHealthServiceAccessForOrganization</a> operation from your organization's management account.</p>
    /// </note>
    /// <p>When you call the <code>DescribeEventDetailsForOrganization</code> operation, specify the <code>organizationEventDetailFilters</code> object in the request. Depending on the Health event type, note the following differences:</p>
    /// <ul>
    /// <li> <p>To return event details for a public event, you must specify a null value for the <code>awsAccountId</code> parameter. If you specify an account ID for a public event, Health returns an error message because public events aren't specific to an account.</p> </li>
    /// <li> <p>To return event details for an event that is specific to an account in your organization, you must specify the <code>awsAccountId</code> parameter in the request. If you don't specify an account ID, Health returns an error message because the event is specific to an account in your organization. </p> </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_Event.html">Event</a>.</p> <note>
    /// <p>This operation doesn't support resource-level permissions. You can't use this operation to allow or deny access to specific Health events. For more information, see <a href="https://docs.aws.amazon.com/health/latest/ug/security_iam_id-based-policy-examples.html#resource-action-based-conditions">Resource- and action-based conditions</a> in the <i>Health User Guide</i>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEventDetailsForOrganization {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_event_details_for_organization_input::Builder,
    }
    impl DescribeEventDetailsForOrganization {
        /// Creates a new `DescribeEventDetailsForOrganization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventDetailsForOrganizationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeEventDetailsForOrganizationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `organizationEventDetailFilters`.
        ///
        /// To override the contents of this collection use [`set_organization_event_detail_filters`](Self::set_organization_event_detail_filters).
        ///
        /// <p>A set of JSON elements that includes the <code>awsAccountId</code> and the <code>eventArn</code>.</p>
        pub fn organization_event_detail_filters(
            mut self,
            input: crate::model::EventAccountFilter,
        ) -> Self {
            self.inner = self.inner.organization_event_detail_filters(input);
            self
        }
        /// <p>A set of JSON elements that includes the <code>awsAccountId</code> and the <code>eventArn</code>.</p>
        pub fn set_organization_event_detail_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventAccountFilter>>,
        ) -> Self {
            self.inner = self.inner.set_organization_event_detail_filters(input);
            self
        }
        /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
        pub fn locale(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale(input.into());
            self
        }
        /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
        pub fn set_locale(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEvents`.
    ///
    /// <p> Returns information about events that meet the specified filter criteria. Events are returned in a summary form and do not include the detailed description, any additional metadata that depends on the event type, or any affected resources. To retrieve that information, use the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventDetails.html">DescribeEventDetails</a> and <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeAffectedEntities.html">DescribeAffectedEntities</a> operations.</p>
    /// <p>If no filter criteria are specified, all events are returned. Results are sorted by <code>lastModifiedTime</code>, starting with the most recent event.</p> <note>
    /// <ul>
    /// <li> <p>When you call the <code>DescribeEvents</code> operation and specify an entity for the <code>entityValues</code> parameter, Health might return public events that aren't specific to that resource. For example, if you call <code>DescribeEvents</code> and specify an ID for an Amazon Elastic Compute Cloud (Amazon EC2) instance, Health might return events that aren't specific to that resource or service. To get events that are specific to a service, use the <code>services</code> parameter in the <code>filter</code> object. For more information, see <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_Event.html">Event</a>.</p> </li>
    /// <li> <p>This API operation uses pagination. Specify the <code>nextToken</code> parameter in the next request to return more results.</p> </li>
    /// </ul>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEvents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_events_input::Builder,
    }
    impl DescribeEvents {
        /// Creates a new `DescribeEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeEventsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeEventsPaginator {
            crate::paginator::DescribeEventsPaginator::new(self.handle, self.inner)
        }
        /// <p>Values to narrow the results returned.</p>
        pub fn filter(mut self, input: crate::model::EventFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Values to narrow the results returned.</p>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::EventFilter>) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
        pub fn locale(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale(input.into());
            self
        }
        /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
        pub fn set_locale(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventsForOrganization`.
    ///
    /// <p>Returns information about events across your organization in Organizations. You can use the<code>filters</code> parameter to specify the events that you want to return. Events are returned in a summary form and don't include the affected accounts, detailed description, any additional metadata that depends on the event type, or any affected resources. To retrieve that information, use the following operations:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeAffectedAccountsForOrganization.html">DescribeAffectedAccountsForOrganization</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventDetailsForOrganization.html">DescribeEventDetailsForOrganization</a> </p> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeAffectedEntitiesForOrganization.html">DescribeAffectedEntitiesForOrganization</a> </p> </li>
    /// </ul>
    /// <p>If you don't specify a <code>filter</code>, the <code>DescribeEventsForOrganizations</code> returns all events across your organization. Results are sorted by <code>lastModifiedTime</code>, starting with the most recent event. </p>
    /// <p>For more information about the different types of Health events, see <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_Event.html">Event</a>.</p>
    /// <p>Before you can call this operation, you must first enable Health to work with Organizations. To do this, call the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EnableHealthServiceAccessForOrganization.html">EnableHealthServiceAccessForOrganization</a> operation from your organization's management account.</p> <note>
    /// <p>This API operation uses pagination. Specify the <code>nextToken</code> parameter in the next request to return more results.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEventsForOrganization {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_events_for_organization_input::Builder,
    }
    impl DescribeEventsForOrganization {
        /// Creates a new `DescribeEventsForOrganization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventsForOrganizationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventsForOrganizationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeEventsForOrganizationPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeEventsForOrganizationPaginator {
            crate::paginator::DescribeEventsForOrganizationPaginator::new(self.handle, self.inner)
        }
        /// <p>Values to narrow the results returned.</p>
        pub fn filter(mut self, input: crate::model::OrganizationEventFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Values to narrow the results returned.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::OrganizationEventFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
        pub fn locale(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale(input.into());
            self
        }
        /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
        pub fn set_locale(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventTypes`.
    ///
    /// <p>Returns the event types that meet the specified filter criteria. You can use this API operation to find information about the Health event, such as the category, Amazon Web Services service, and event code. The metadata for each event appears in the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EventType.html">EventType</a> object. </p>
    /// <p>If you don't specify a filter criteria, the API operation returns all event types, in no particular order. </p> <note>
    /// <p>This API operation uses pagination. Specify the <code>nextToken</code> parameter in the next request to return more results.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEventTypes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_event_types_input::Builder,
    }
    impl DescribeEventTypes {
        /// Creates a new `DescribeEventTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventTypesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeEventTypesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeEventTypesPaginator {
            crate::paginator::DescribeEventTypesPaginator::new(self.handle, self.inner)
        }
        /// <p>Values to narrow the results returned.</p>
        pub fn filter(mut self, input: crate::model::EventTypeFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Values to narrow the results returned.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::EventTypeFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
        pub fn locale(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.locale(input.into());
            self
        }
        /// <p>The locale (language) to return information in. English (en) is the default and the only supported value at this time.</p>
        pub fn set_locale(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_locale(input);
            self
        }
        /// <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the results of a search are large, only a portion of the results are returned, and a <code>nextToken</code> pagination token is returned in the response. To retrieve the next batch of results, reissue the search request and include the returned token. When all results have been returned, the response does not contain a pagination token value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to return in one batch, between 10 and 100, inclusive.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeHealthServiceStatusForOrganization`.
    ///
    /// <p>This operation provides status information on enabling or disabling Health to work with your organization. To call this operation, you must sign in as an IAM user, assume an IAM role, or sign in as the root user (not recommended) in the organization's management account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeHealthServiceStatusForOrganization {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_health_service_status_for_organization_input::Builder,
    }
    impl DescribeHealthServiceStatusForOrganization {
        /// Creates a new `DescribeHealthServiceStatusForOrganization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeHealthServiceStatusForOrganizationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeHealthServiceStatusForOrganizationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DisableHealthServiceAccessForOrganization`.
    ///
    /// <p>Disables Health from working with Organizations. To call this operation, you must sign in as an Identity and Access Management (IAM) user, assume an IAM role, or sign in as the root user (not recommended) in the organization's management account. For more information, see <a href="https://docs.aws.amazon.com/health/latest/ug/aggregate-events.html">Aggregating Health events</a> in the <i>Health User Guide</i>.</p>
    /// <p>This operation doesn't remove the service-linked role from the management account in your organization. You must use the IAM console, API, or Command Line Interface (CLI) to remove the service-linked role. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html#delete-service-linked-role">Deleting a Service-Linked Role</a> in the <i>IAM User Guide</i>.</p> <note>
    /// <p>You can also disable the organizational feature by using the Organizations <a href="https://docs.aws.amazon.com/organizations/latest/APIReference/API_DisableAWSServiceAccess.html">DisableAWSServiceAccess</a> API operation. After you call this operation, Health stops aggregating events for all other Amazon Web Services accounts in your organization. If you call the Health API operations for organizational view, Health returns an error. Health continues to aggregate health events for your Amazon Web Services account.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableHealthServiceAccessForOrganization {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disable_health_service_access_for_organization_input::Builder,
    }
    impl DisableHealthServiceAccessForOrganization {
        /// Creates a new `DisableHealthServiceAccessForOrganization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableHealthServiceAccessForOrganizationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisableHealthServiceAccessForOrganizationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `EnableHealthServiceAccessForOrganization`.
    ///
    /// <p>Enables Health to work with Organizations. You can use the organizational view feature to aggregate events from all Amazon Web Services accounts in your organization in a centralized location. </p>
    /// <p>This operation also creates a service-linked role for the management account in the organization. </p> <note>
    /// <p>To call this operation, you must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>You must have a Business, Enterprise On-Ramp, or Enterprise Support plan from <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a> to use the Health API. If you call the Health API from an Amazon Web Services account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, you receive a <code>SubscriptionRequiredException</code> error.</p> </li>
    /// <li> <p>You must have permission to call this operation from the organization's management account. For example IAM policies, see <a href="https://docs.aws.amazon.com/health/latest/ug/security_iam_id-based-policy-examples.html">Health identity-based policy examples</a>.</p> </li>
    /// </ul>
    /// </note>
    /// <p>If you don't have the required support plan, you can instead use the Health console to enable the organizational view feature. For more information, see <a href="https://docs.aws.amazon.com/health/latest/ug/aggregate-events.html">Aggregating Health events</a> in the <i>Health User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableHealthServiceAccessForOrganization {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::enable_health_service_access_for_organization_input::Builder,
    }
    impl EnableHealthServiceAccessForOrganization {
        /// Creates a new `EnableHealthServiceAccessForOrganization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableHealthServiceAccessForOrganizationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::EnableHealthServiceAccessForOrganizationError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
