#![allow(clippy::module_inception)]
#![allow(clippy::upper_case_acronyms)]
#![allow(clippy::large_enum_variant)]
#![allow(clippy::wrong_self_convention)]
#![allow(clippy::should_implement_trait)]
#![allow(clippy::blacklisted_name)]
#![allow(clippy::vec_init_then_push)]
#![allow(rustdoc::bare_urls)]
#![warn(missing_docs)]
//! <fullname>Health</fullname>
//!
//! <p>The Health API provides programmatic access to the Health information that
//! appears in the <a href="https://phd.aws.amazon.com/phd/home#/">Personal Health Dashboard</a>. You
//! can use the API operations to get information about events that might affect your Amazon Web Services
//! services and resources.</p>
//! <note>
//! <ul>
//! <li>
//! <p>You must have a Business or Enterprise Support plan from <a href="http://aws.amazon.com/premiumsupport/">Amazon Web Services Support</a> to use the
//! Health API. If you call the Health API from an Amazon Web Services account that
//! doesn't have a Business or Enterprise Support plan, you receive a
//! <code>SubscriptionRequiredException</code> error.</p>
//! </li>
//! <li>
//! <p>You can use the Health endpoint health.us-east-1.amazonaws.com (HTTPS) to
//! call the Health API operations. Health supports a multi-Region
//! application architecture and has two regional endpoints in an active-passive
//! configuration. You can use the high availability endpoint example to determine
//! which Amazon Web Services Region is active, so that you can get the latest information from the
//! API. For more information, see <a href="https://docs.aws.amazon.com/health/latest/ug/health-api.html">Accessing the Health API</a> in the
//! <i>Health User Guide</i>.</p>
//! </li>
//! </ul>
//! </note>
//! <p>For authentication of requests, Health uses the <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing
//! Process</a>.</p>
//! <p>If your Amazon Web Services account is part of Organizations, you can use the Health organizational
//! view feature. This feature provides a centralized view of Health events across all
//! accounts in your organization. You can aggregate Health events in real time to
//! identify accounts in your organization that are affected by an operational event or get
//! notified of security vulnerabilities. Use the organizational view API operations to enable
//! this feature and return event information. For more information, see <a href="https://docs.aws.amazon.com/health/latest/ug/aggregate-events.html">Aggregating
//! Health events</a> in the <i>Health User Guide</i>.</p>
//! <note>
//! <p>When you use the Health API operations to return Health events, see the
//! following recommendations:</p>
//! <ul>
//! <li>
//! <p>Use the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_Event.html#AWSHealth-Type-Event-eventScopeCode">eventScopeCode</a> parameter to specify whether to return Health
//! events that are public or account-specific.</p>
//! </li>
//! <li>
//! <p>Use pagination to view all events from the response. For example, if you call
//! the <code>DescribeEventsForOrganization</code> operation to get all events in your
//! organization, you might receive several page results. Specify the
//! <code>nextToken</code> in the next request to return more results.</p>
//! </li>
//! </ul>
//! </note>

// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use error_meta::Error;

pub use config::Config;

mod aws_endpoint;
/// Client and fluent builders for calling the service.
#[cfg(feature = "client")]
pub mod client;
/// Configuration for the service.
pub mod config;
/// Errors that can occur when calling the service.
pub mod error;
mod error_meta;
/// Input structures for operations.
pub mod input;
mod json_deser;
mod json_errors;
mod json_ser;
/// Data structures used by operation inputs/outputs.
pub mod model;
mod no_credentials;
/// All operations that this crate can perform.
pub mod operation;
mod operation_deser;
mod operation_ser;
/// Output structures for operations.
pub mod output;
/// Crate version number.
pub static PKG_VERSION: &str = env!("CARGO_PKG_VERSION");
pub use aws_smithy_http::byte_stream::ByteStream;
pub use aws_smithy_http::result::SdkError;
pub use aws_smithy_types::Blob;
pub use aws_smithy_types::DateTime;
static API_METADATA: aws_http::user_agent::ApiMetadata =
    aws_http::user_agent::ApiMetadata::new("health", PKG_VERSION);
pub use aws_smithy_http::endpoint::Endpoint;
pub use aws_smithy_types::retry::RetryConfig;
pub use aws_types::app_name::AppName;
pub use aws_types::region::Region;
pub use aws_types::Credentials;
#[cfg(feature = "client")]
pub use client::Client;
