// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Contains the metadata about a type of event that is reported by AWS Health. The
/// <code>EventType</code> shows the category, service, and the event type code of the
/// event. For example, an <code>issue</code> might be the category, <code>EC2</code> the
/// service, and <code>AWS_EC2_SYSTEM_MAINTENANCE_EVENT</code> the event type code.</p>
/// <p>You can use the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventTypes.html">DescribeEventTypes</a> API operation to return this information
/// about an event.</p>
/// <p>You can also use the Amazon CloudWatch Events console to create a rule so that you can get notified or
/// take action when AWS Health delivers a specific event to your AWS account. For more
/// information, see <a href="https://docs.aws.amazon.com/health/latest/ug/cloudwatch-events-health.html">Monitor for AWS Health events with Amazon CloudWatch Events</a> in the
/// <i>AWS Health User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventType {
    /// <p>The AWS service that is affected by the event. For example, <code>EC2</code>, <code>RDS</code>.</p>
    pub service: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the event type. The format is <code>AWS_<i>SERVICE</i>_<i>DESCRIPTION</i>
    /// </code>; for example, <code>AWS_EC2_SYSTEM_MAINTENANCE_EVENT</code>.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>,
    /// or <code>accountNotification</code>).</p>
    pub category: std::option::Option<crate::model::EventTypeCategory>,
}
impl EventType {
    /// <p>The AWS service that is affected by the event. For example, <code>EC2</code>, <code>RDS</code>.</p>
    pub fn service(&self) -> std::option::Option<&str> {
        self.service.as_deref()
    }
    /// <p>The unique identifier for the event type. The format is <code>AWS_<i>SERVICE</i>_<i>DESCRIPTION</i>
    /// </code>; for example, <code>AWS_EC2_SYSTEM_MAINTENANCE_EVENT</code>.</p>
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>,
    /// or <code>accountNotification</code>).</p>
    pub fn category(&self) -> std::option::Option<&crate::model::EventTypeCategory> {
        self.category.as_ref()
    }
}
impl std::fmt::Debug for EventType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventType");
        formatter.field("service", &self.service);
        formatter.field("code", &self.code);
        formatter.field("category", &self.category);
        formatter.finish()
    }
}
/// See [`EventType`](crate::model::EventType)
pub mod event_type {
    /// A builder for [`EventType`](crate::model::EventType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) category: std::option::Option<crate::model::EventTypeCategory>,
    }
    impl Builder {
        /// <p>The AWS service that is affected by the event. For example, <code>EC2</code>, <code>RDS</code>.</p>
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.service = Some(input.into());
            self
        }
        /// <p>The AWS service that is affected by the event. For example, <code>EC2</code>, <code>RDS</code>.</p>
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service = input;
            self
        }
        /// <p>The unique identifier for the event type. The format is <code>AWS_<i>SERVICE</i>_<i>DESCRIPTION</i>
        /// </code>; for example, <code>AWS_EC2_SYSTEM_MAINTENANCE_EVENT</code>.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The unique identifier for the event type. The format is <code>AWS_<i>SERVICE</i>_<i>DESCRIPTION</i>
        /// </code>; for example, <code>AWS_EC2_SYSTEM_MAINTENANCE_EVENT</code>.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>,
        /// or <code>accountNotification</code>).</p>
        pub fn category(mut self, input: crate::model::EventTypeCategory) -> Self {
            self.category = Some(input);
            self
        }
        /// <p>A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>,
        /// or <code>accountNotification</code>).</p>
        pub fn set_category(
            mut self,
            input: std::option::Option<crate::model::EventTypeCategory>,
        ) -> Self {
            self.category = input;
            self
        }
        /// Consumes the builder and constructs a [`EventType`](crate::model::EventType)
        pub fn build(self) -> crate::model::EventType {
            crate::model::EventType {
                service: self.service,
                code: self.code,
                category: self.category,
            }
        }
    }
}
impl EventType {
    /// Creates a new builder-style object to manufacture [`EventType`](crate::model::EventType)
    pub fn builder() -> crate::model::event_type::Builder {
        crate::model::event_type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventTypeCategory {
    #[allow(missing_docs)] // documentation missing in model
    AccountNotification,
    #[allow(missing_docs)] // documentation missing in model
    Investigation,
    #[allow(missing_docs)] // documentation missing in model
    Issue,
    #[allow(missing_docs)] // documentation missing in model
    ScheduledChange,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventTypeCategory {
    fn from(s: &str) -> Self {
        match s {
            "accountNotification" => EventTypeCategory::AccountNotification,
            "investigation" => EventTypeCategory::Investigation,
            "issue" => EventTypeCategory::Issue,
            "scheduledChange" => EventTypeCategory::ScheduledChange,
            other => EventTypeCategory::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventTypeCategory {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventTypeCategory::from(s))
    }
}
impl EventTypeCategory {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventTypeCategory::AccountNotification => "accountNotification",
            EventTypeCategory::Investigation => "investigation",
            EventTypeCategory::Issue => "issue",
            EventTypeCategory::ScheduledChange => "scheduledChange",
            EventTypeCategory::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "accountNotification",
            "investigation",
            "issue",
            "scheduledChange",
        ]
    }
}
impl AsRef<str> for EventTypeCategory {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The values to use to filter results from the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventTypes.html">DescribeEventTypes</a>
/// operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventTypeFilter {
    /// <p>A list of event type codes.</p>
    pub event_type_codes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The AWS services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.</p>
    pub services: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>,
    /// or <code>accountNotification</code>).</p>
    pub event_type_categories: std::option::Option<std::vec::Vec<crate::model::EventTypeCategory>>,
}
impl EventTypeFilter {
    /// <p>A list of event type codes.</p>
    pub fn event_type_codes(&self) -> std::option::Option<&[std::string::String]> {
        self.event_type_codes.as_deref()
    }
    /// <p>The AWS services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.</p>
    pub fn services(&self) -> std::option::Option<&[std::string::String]> {
        self.services.as_deref()
    }
    /// <p>A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>,
    /// or <code>accountNotification</code>).</p>
    pub fn event_type_categories(&self) -> std::option::Option<&[crate::model::EventTypeCategory]> {
        self.event_type_categories.as_deref()
    }
}
impl std::fmt::Debug for EventTypeFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventTypeFilter");
        formatter.field("event_type_codes", &self.event_type_codes);
        formatter.field("services", &self.services);
        formatter.field("event_type_categories", &self.event_type_categories);
        formatter.finish()
    }
}
/// See [`EventTypeFilter`](crate::model::EventTypeFilter)
pub mod event_type_filter {
    /// A builder for [`EventTypeFilter`](crate::model::EventTypeFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_type_codes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) services: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) event_type_categories:
            std::option::Option<std::vec::Vec<crate::model::EventTypeCategory>>,
    }
    impl Builder {
        /// Appends an item to `event_type_codes`.
        ///
        /// To override the contents of this collection use [`set_event_type_codes`](Self::set_event_type_codes).
        ///
        /// <p>A list of event type codes.</p>
        pub fn event_type_codes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_type_codes.unwrap_or_default();
            v.push(input.into());
            self.event_type_codes = Some(v);
            self
        }
        /// <p>A list of event type codes.</p>
        pub fn set_event_type_codes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_type_codes = input;
            self
        }
        /// Appends an item to `services`.
        ///
        /// To override the contents of this collection use [`set_services`](Self::set_services).
        ///
        /// <p>The AWS services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.</p>
        pub fn services(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.services.unwrap_or_default();
            v.push(input.into());
            self.services = Some(v);
            self
        }
        /// <p>The AWS services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.</p>
        pub fn set_services(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.services = input;
            self
        }
        /// Appends an item to `event_type_categories`.
        ///
        /// To override the contents of this collection use [`set_event_type_categories`](Self::set_event_type_categories).
        ///
        /// <p>A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>,
        /// or <code>accountNotification</code>).</p>
        pub fn event_type_categories(
            mut self,
            input: impl Into<crate::model::EventTypeCategory>,
        ) -> Self {
            let mut v = self.event_type_categories.unwrap_or_default();
            v.push(input.into());
            self.event_type_categories = Some(v);
            self
        }
        /// <p>A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>,
        /// or <code>accountNotification</code>).</p>
        pub fn set_event_type_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventTypeCategory>>,
        ) -> Self {
            self.event_type_categories = input;
            self
        }
        /// Consumes the builder and constructs a [`EventTypeFilter`](crate::model::EventTypeFilter)
        pub fn build(self) -> crate::model::EventTypeFilter {
            crate::model::EventTypeFilter {
                event_type_codes: self.event_type_codes,
                services: self.services,
                event_type_categories: self.event_type_categories,
            }
        }
    }
}
impl EventTypeFilter {
    /// Creates a new builder-style object to manufacture [`EventTypeFilter`](crate::model::EventTypeFilter)
    pub fn builder() -> crate::model::event_type_filter::Builder {
        crate::model::event_type_filter::Builder::default()
    }
}

/// <p>Summary information about an event, returned by the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventsForOrganization.html">DescribeEventsForOrganization</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationEvent {
    /// <p>The unique identifier for the event. The event ARN has the
    /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
    /// </code>
    /// format.</p>
    /// <p>For example, an event ARN might look like the following:</p>
    /// <p>
    /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
    /// </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The AWS service that is affected by the event, such as EC2 and RDS.</p>
    pub service: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the event type. The format is
    /// <code>AWS_SERVICE_DESCRIPTION</code>. For example,
    /// <code>AWS_EC2_SYSTEM_MAINTENANCE_EVENT</code>.</p>
    pub event_type_code: std::option::Option<std::string::String>,
    /// <p>The category of the event type.</p>
    pub event_type_category: std::option::Option<crate::model::EventTypeCategory>,
    /// <p>This parameter specifies if the AWS Health event is a public AWS service event or an account-specific event.</p>
    /// <ul>
    /// <li>
    /// <p>If the <code>eventScopeCode</code> value is <code>PUBLIC</code>, then the
    /// <code>affectedAccounts</code> value is always empty.</p>
    /// </li>
    /// <li>
    /// <p>If the <code>eventScopeCode</code> value is <code>ACCOUNT_SPECIFIC</code>, then
    /// the <code>affectedAccounts</code> value lists the affected AWS accounts in your
    /// organization. For example, if an event affects a service such as Amazon Elastic Compute Cloud and you
    /// have AWS accounts that use that service, those account IDs appear in the
    /// response.</p>
    /// </li>
    /// <li>
    /// <p>If the <code>eventScopeCode</code> value is <code>NONE</code>, then the
    /// <code>eventArn</code> that you specified in the request is invalid or doesn't
    /// exist.</p>
    /// </li>
    /// </ul>
    pub event_scope_code: std::option::Option<crate::model::EventScopeCode>,
    /// <p>The AWS Region name of the event.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The date and time that the event began.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time that the event ended.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The most recent date and time that the event was updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The most recent status of the event. Possible values are <code>open</code>,
    /// <code>closed</code>, and <code>upcoming</code>.</p>
    pub status_code: std::option::Option<crate::model::EventStatusCode>,
}
impl OrganizationEvent {
    /// <p>The unique identifier for the event. The event ARN has the
    /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
    /// </code>
    /// format.</p>
    /// <p>For example, an event ARN might look like the following:</p>
    /// <p>
    /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
    /// </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The AWS service that is affected by the event, such as EC2 and RDS.</p>
    pub fn service(&self) -> std::option::Option<&str> {
        self.service.as_deref()
    }
    /// <p>The unique identifier for the event type. The format is
    /// <code>AWS_SERVICE_DESCRIPTION</code>. For example,
    /// <code>AWS_EC2_SYSTEM_MAINTENANCE_EVENT</code>.</p>
    pub fn event_type_code(&self) -> std::option::Option<&str> {
        self.event_type_code.as_deref()
    }
    /// <p>The category of the event type.</p>
    pub fn event_type_category(&self) -> std::option::Option<&crate::model::EventTypeCategory> {
        self.event_type_category.as_ref()
    }
    /// <p>This parameter specifies if the AWS Health event is a public AWS service event or an account-specific event.</p>
    /// <ul>
    /// <li>
    /// <p>If the <code>eventScopeCode</code> value is <code>PUBLIC</code>, then the
    /// <code>affectedAccounts</code> value is always empty.</p>
    /// </li>
    /// <li>
    /// <p>If the <code>eventScopeCode</code> value is <code>ACCOUNT_SPECIFIC</code>, then
    /// the <code>affectedAccounts</code> value lists the affected AWS accounts in your
    /// organization. For example, if an event affects a service such as Amazon Elastic Compute Cloud and you
    /// have AWS accounts that use that service, those account IDs appear in the
    /// response.</p>
    /// </li>
    /// <li>
    /// <p>If the <code>eventScopeCode</code> value is <code>NONE</code>, then the
    /// <code>eventArn</code> that you specified in the request is invalid or doesn't
    /// exist.</p>
    /// </li>
    /// </ul>
    pub fn event_scope_code(&self) -> std::option::Option<&crate::model::EventScopeCode> {
        self.event_scope_code.as_ref()
    }
    /// <p>The AWS Region name of the event.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>The date and time that the event began.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_time.as_ref()
    }
    /// <p>The date and time that the event ended.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
    /// <p>The most recent date and time that the event was updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_time.as_ref()
    }
    /// <p>The most recent status of the event. Possible values are <code>open</code>,
    /// <code>closed</code>, and <code>upcoming</code>.</p>
    pub fn status_code(&self) -> std::option::Option<&crate::model::EventStatusCode> {
        self.status_code.as_ref()
    }
}
impl std::fmt::Debug for OrganizationEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationEvent");
        formatter.field("arn", &self.arn);
        formatter.field("service", &self.service);
        formatter.field("event_type_code", &self.event_type_code);
        formatter.field("event_type_category", &self.event_type_category);
        formatter.field("event_scope_code", &self.event_scope_code);
        formatter.field("region", &self.region);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("status_code", &self.status_code);
        formatter.finish()
    }
}
/// See [`OrganizationEvent`](crate::model::OrganizationEvent)
pub mod organization_event {
    /// A builder for [`OrganizationEvent`](crate::model::OrganizationEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) service: std::option::Option<std::string::String>,
        pub(crate) event_type_code: std::option::Option<std::string::String>,
        pub(crate) event_type_category: std::option::Option<crate::model::EventTypeCategory>,
        pub(crate) event_scope_code: std::option::Option<crate::model::EventScopeCode>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status_code: std::option::Option<crate::model::EventStatusCode>,
    }
    impl Builder {
        /// <p>The unique identifier for the event. The event ARN has the
        /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
        /// </code>
        /// format.</p>
        /// <p>For example, an event ARN might look like the following:</p>
        /// <p>
        /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
        /// </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The unique identifier for the event. The event ARN has the
        /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
        /// </code>
        /// format.</p>
        /// <p>For example, an event ARN might look like the following:</p>
        /// <p>
        /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
        /// </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The AWS service that is affected by the event, such as EC2 and RDS.</p>
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.service = Some(input.into());
            self
        }
        /// <p>The AWS service that is affected by the event, such as EC2 and RDS.</p>
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service = input;
            self
        }
        /// <p>The unique identifier for the event type. The format is
        /// <code>AWS_SERVICE_DESCRIPTION</code>. For example,
        /// <code>AWS_EC2_SYSTEM_MAINTENANCE_EVENT</code>.</p>
        pub fn event_type_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_type_code = Some(input.into());
            self
        }
        /// <p>The unique identifier for the event type. The format is
        /// <code>AWS_SERVICE_DESCRIPTION</code>. For example,
        /// <code>AWS_EC2_SYSTEM_MAINTENANCE_EVENT</code>.</p>
        pub fn set_event_type_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_type_code = input;
            self
        }
        /// <p>The category of the event type.</p>
        pub fn event_type_category(mut self, input: crate::model::EventTypeCategory) -> Self {
            self.event_type_category = Some(input);
            self
        }
        /// <p>The category of the event type.</p>
        pub fn set_event_type_category(
            mut self,
            input: std::option::Option<crate::model::EventTypeCategory>,
        ) -> Self {
            self.event_type_category = input;
            self
        }
        /// <p>This parameter specifies if the AWS Health event is a public AWS service event or an account-specific event.</p>
        /// <ul>
        /// <li>
        /// <p>If the <code>eventScopeCode</code> value is <code>PUBLIC</code>, then the
        /// <code>affectedAccounts</code> value is always empty.</p>
        /// </li>
        /// <li>
        /// <p>If the <code>eventScopeCode</code> value is <code>ACCOUNT_SPECIFIC</code>, then
        /// the <code>affectedAccounts</code> value lists the affected AWS accounts in your
        /// organization. For example, if an event affects a service such as Amazon Elastic Compute Cloud and you
        /// have AWS accounts that use that service, those account IDs appear in the
        /// response.</p>
        /// </li>
        /// <li>
        /// <p>If the <code>eventScopeCode</code> value is <code>NONE</code>, then the
        /// <code>eventArn</code> that you specified in the request is invalid or doesn't
        /// exist.</p>
        /// </li>
        /// </ul>
        pub fn event_scope_code(mut self, input: crate::model::EventScopeCode) -> Self {
            self.event_scope_code = Some(input);
            self
        }
        /// <p>This parameter specifies if the AWS Health event is a public AWS service event or an account-specific event.</p>
        /// <ul>
        /// <li>
        /// <p>If the <code>eventScopeCode</code> value is <code>PUBLIC</code>, then the
        /// <code>affectedAccounts</code> value is always empty.</p>
        /// </li>
        /// <li>
        /// <p>If the <code>eventScopeCode</code> value is <code>ACCOUNT_SPECIFIC</code>, then
        /// the <code>affectedAccounts</code> value lists the affected AWS accounts in your
        /// organization. For example, if an event affects a service such as Amazon Elastic Compute Cloud and you
        /// have AWS accounts that use that service, those account IDs appear in the
        /// response.</p>
        /// </li>
        /// <li>
        /// <p>If the <code>eventScopeCode</code> value is <code>NONE</code>, then the
        /// <code>eventArn</code> that you specified in the request is invalid or doesn't
        /// exist.</p>
        /// </li>
        /// </ul>
        pub fn set_event_scope_code(
            mut self,
            input: std::option::Option<crate::model::EventScopeCode>,
        ) -> Self {
            self.event_scope_code = input;
            self
        }
        /// <p>The AWS Region name of the event.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The AWS Region name of the event.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The date and time that the event began.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The date and time that the event began.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The date and time that the event ended.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The date and time that the event ended.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The most recent date and time that the event was updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The most recent date and time that the event was updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>The most recent status of the event. Possible values are <code>open</code>,
        /// <code>closed</code>, and <code>upcoming</code>.</p>
        pub fn status_code(mut self, input: crate::model::EventStatusCode) -> Self {
            self.status_code = Some(input);
            self
        }
        /// <p>The most recent status of the event. Possible values are <code>open</code>,
        /// <code>closed</code>, and <code>upcoming</code>.</p>
        pub fn set_status_code(
            mut self,
            input: std::option::Option<crate::model::EventStatusCode>,
        ) -> Self {
            self.status_code = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationEvent`](crate::model::OrganizationEvent)
        pub fn build(self) -> crate::model::OrganizationEvent {
            crate::model::OrganizationEvent {
                arn: self.arn,
                service: self.service,
                event_type_code: self.event_type_code,
                event_type_category: self.event_type_category,
                event_scope_code: self.event_scope_code,
                region: self.region,
                start_time: self.start_time,
                end_time: self.end_time,
                last_updated_time: self.last_updated_time,
                status_code: self.status_code,
            }
        }
    }
}
impl OrganizationEvent {
    /// Creates a new builder-style object to manufacture [`OrganizationEvent`](crate::model::OrganizationEvent)
    pub fn builder() -> crate::model::organization_event::Builder {
        crate::model::organization_event::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventStatusCode {
    #[allow(missing_docs)] // documentation missing in model
    Closed,
    #[allow(missing_docs)] // documentation missing in model
    Open,
    #[allow(missing_docs)] // documentation missing in model
    Upcoming,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventStatusCode {
    fn from(s: &str) -> Self {
        match s {
            "closed" => EventStatusCode::Closed,
            "open" => EventStatusCode::Open,
            "upcoming" => EventStatusCode::Upcoming,
            other => EventStatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventStatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventStatusCode::from(s))
    }
}
impl EventStatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventStatusCode::Closed => "closed",
            EventStatusCode::Open => "open",
            EventStatusCode::Upcoming => "upcoming",
            EventStatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["closed", "open", "upcoming"]
    }
}
impl AsRef<str> for EventStatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventScopeCode {
    #[allow(missing_docs)] // documentation missing in model
    AccountSpecific,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Public,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventScopeCode {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT_SPECIFIC" => EventScopeCode::AccountSpecific,
            "NONE" => EventScopeCode::None,
            "PUBLIC" => EventScopeCode::Public,
            other => EventScopeCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventScopeCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventScopeCode::from(s))
    }
}
impl EventScopeCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventScopeCode::AccountSpecific => "ACCOUNT_SPECIFIC",
            EventScopeCode::None => "NONE",
            EventScopeCode::Public => "PUBLIC",
            EventScopeCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACCOUNT_SPECIFIC", "NONE", "PUBLIC"]
    }
}
impl AsRef<str> for EventScopeCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The values to filter results from the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventsForOrganization.html">DescribeEventsForOrganization</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationEventFilter {
    /// <p>A list of unique identifiers for event types. For example, <code>"AWS_EC2_SYSTEM_MAINTENANCE_EVENT","AWS_RDS_MAINTENANCE_SCHEDULED".</code>
    /// </p>
    pub event_type_codes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of 12-digit AWS account numbers that contains the affected entities.</p>
    pub aws_account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The AWS services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.</p>
    pub services: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of AWS Regions.</p>
    pub regions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A range of dates and times that is used by the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EventFilter.html">EventFilter</a> and <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EntityFilter.html">EntityFilter</a> objects. If <code>from</code> is set and <code>to</code> is set:
    /// match items where the timestamp (<code>startTime</code>, <code>endTime</code>, or
    /// <code>lastUpdatedTime</code>) is between <code>from</code> and <code>to</code>
    /// inclusive. If <code>from</code> is set and <code>to</code> is not set: match items where
    /// the timestamp value is equal to or after <code>from</code>. If <code>from</code> is not set
    /// and <code>to</code> is set: match items where the timestamp value is equal to or before
    /// <code>to</code>.</p>
    pub start_time: std::option::Option<crate::model::DateTimeRange>,
    /// <p>A range of dates and times that is used by the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EventFilter.html">EventFilter</a> and <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EntityFilter.html">EntityFilter</a> objects. If <code>from</code> is set and <code>to</code> is set:
    /// match items where the timestamp (<code>startTime</code>, <code>endTime</code>, or
    /// <code>lastUpdatedTime</code>) is between <code>from</code> and <code>to</code>
    /// inclusive. If <code>from</code> is set and <code>to</code> is not set: match items where
    /// the timestamp value is equal to or after <code>from</code>. If <code>from</code> is not set
    /// and <code>to</code> is set: match items where the timestamp value is equal to or before
    /// <code>to</code>.</p>
    pub end_time: std::option::Option<crate::model::DateTimeRange>,
    /// <p>A range of dates and times that is used by the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EventFilter.html">EventFilter</a> and <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EntityFilter.html">EntityFilter</a> objects. If <code>from</code> is set and <code>to</code> is set:
    /// match items where the timestamp (<code>startTime</code>, <code>endTime</code>, or
    /// <code>lastUpdatedTime</code>) is between <code>from</code> and <code>to</code>
    /// inclusive. If <code>from</code> is set and <code>to</code> is not set: match items where
    /// the timestamp value is equal to or after <code>from</code>. If <code>from</code> is not set
    /// and <code>to</code> is set: match items where the timestamp value is equal to or before
    /// <code>to</code>.</p>
    pub last_updated_time: std::option::Option<crate::model::DateTimeRange>,
    /// <p>A list of entity ARNs (unique identifiers).</p>
    pub entity_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of entity identifiers, such as EC2 instance IDs (i-34ab692e) or EBS volumes (vol-426ab23e).</p>
    pub entity_values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of event type category codes (issue, scheduledChange, or accountNotification).</p>
    pub event_type_categories: std::option::Option<std::vec::Vec<crate::model::EventTypeCategory>>,
    /// <p>A list of event status codes.</p>
    pub event_status_codes: std::option::Option<std::vec::Vec<crate::model::EventStatusCode>>,
}
impl OrganizationEventFilter {
    /// <p>A list of unique identifiers for event types. For example, <code>"AWS_EC2_SYSTEM_MAINTENANCE_EVENT","AWS_RDS_MAINTENANCE_SCHEDULED".</code>
    /// </p>
    pub fn event_type_codes(&self) -> std::option::Option<&[std::string::String]> {
        self.event_type_codes.as_deref()
    }
    /// <p>A list of 12-digit AWS account numbers that contains the affected entities.</p>
    pub fn aws_account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.aws_account_ids.as_deref()
    }
    /// <p>The AWS services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.</p>
    pub fn services(&self) -> std::option::Option<&[std::string::String]> {
        self.services.as_deref()
    }
    /// <p>A list of AWS Regions.</p>
    pub fn regions(&self) -> std::option::Option<&[std::string::String]> {
        self.regions.as_deref()
    }
    /// <p>A range of dates and times that is used by the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EventFilter.html">EventFilter</a> and <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EntityFilter.html">EntityFilter</a> objects. If <code>from</code> is set and <code>to</code> is set:
    /// match items where the timestamp (<code>startTime</code>, <code>endTime</code>, or
    /// <code>lastUpdatedTime</code>) is between <code>from</code> and <code>to</code>
    /// inclusive. If <code>from</code> is set and <code>to</code> is not set: match items where
    /// the timestamp value is equal to or after <code>from</code>. If <code>from</code> is not set
    /// and <code>to</code> is set: match items where the timestamp value is equal to or before
    /// <code>to</code>.</p>
    pub fn start_time(&self) -> std::option::Option<&crate::model::DateTimeRange> {
        self.start_time.as_ref()
    }
    /// <p>A range of dates and times that is used by the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EventFilter.html">EventFilter</a> and <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EntityFilter.html">EntityFilter</a> objects. If <code>from</code> is set and <code>to</code> is set:
    /// match items where the timestamp (<code>startTime</code>, <code>endTime</code>, or
    /// <code>lastUpdatedTime</code>) is between <code>from</code> and <code>to</code>
    /// inclusive. If <code>from</code> is set and <code>to</code> is not set: match items where
    /// the timestamp value is equal to or after <code>from</code>. If <code>from</code> is not set
    /// and <code>to</code> is set: match items where the timestamp value is equal to or before
    /// <code>to</code>.</p>
    pub fn end_time(&self) -> std::option::Option<&crate::model::DateTimeRange> {
        self.end_time.as_ref()
    }
    /// <p>A range of dates and times that is used by the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EventFilter.html">EventFilter</a> and <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EntityFilter.html">EntityFilter</a> objects. If <code>from</code> is set and <code>to</code> is set:
    /// match items where the timestamp (<code>startTime</code>, <code>endTime</code>, or
    /// <code>lastUpdatedTime</code>) is between <code>from</code> and <code>to</code>
    /// inclusive. If <code>from</code> is set and <code>to</code> is not set: match items where
    /// the timestamp value is equal to or after <code>from</code>. If <code>from</code> is not set
    /// and <code>to</code> is set: match items where the timestamp value is equal to or before
    /// <code>to</code>.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&crate::model::DateTimeRange> {
        self.last_updated_time.as_ref()
    }
    /// <p>A list of entity ARNs (unique identifiers).</p>
    pub fn entity_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.entity_arns.as_deref()
    }
    /// <p>A list of entity identifiers, such as EC2 instance IDs (i-34ab692e) or EBS volumes (vol-426ab23e).</p>
    pub fn entity_values(&self) -> std::option::Option<&[std::string::String]> {
        self.entity_values.as_deref()
    }
    /// <p>A list of event type category codes (issue, scheduledChange, or accountNotification).</p>
    pub fn event_type_categories(&self) -> std::option::Option<&[crate::model::EventTypeCategory]> {
        self.event_type_categories.as_deref()
    }
    /// <p>A list of event status codes.</p>
    pub fn event_status_codes(&self) -> std::option::Option<&[crate::model::EventStatusCode]> {
        self.event_status_codes.as_deref()
    }
}
impl std::fmt::Debug for OrganizationEventFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationEventFilter");
        formatter.field("event_type_codes", &self.event_type_codes);
        formatter.field("aws_account_ids", &self.aws_account_ids);
        formatter.field("services", &self.services);
        formatter.field("regions", &self.regions);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("entity_arns", &self.entity_arns);
        formatter.field("entity_values", &self.entity_values);
        formatter.field("event_type_categories", &self.event_type_categories);
        formatter.field("event_status_codes", &self.event_status_codes);
        formatter.finish()
    }
}
/// See [`OrganizationEventFilter`](crate::model::OrganizationEventFilter)
pub mod organization_event_filter {
    /// A builder for [`OrganizationEventFilter`](crate::model::OrganizationEventFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_type_codes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) aws_account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) services: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) regions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) start_time: std::option::Option<crate::model::DateTimeRange>,
        pub(crate) end_time: std::option::Option<crate::model::DateTimeRange>,
        pub(crate) last_updated_time: std::option::Option<crate::model::DateTimeRange>,
        pub(crate) entity_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) entity_values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) event_type_categories:
            std::option::Option<std::vec::Vec<crate::model::EventTypeCategory>>,
        pub(crate) event_status_codes:
            std::option::Option<std::vec::Vec<crate::model::EventStatusCode>>,
    }
    impl Builder {
        /// Appends an item to `event_type_codes`.
        ///
        /// To override the contents of this collection use [`set_event_type_codes`](Self::set_event_type_codes).
        ///
        /// <p>A list of unique identifiers for event types. For example, <code>"AWS_EC2_SYSTEM_MAINTENANCE_EVENT","AWS_RDS_MAINTENANCE_SCHEDULED".</code>
        /// </p>
        pub fn event_type_codes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_type_codes.unwrap_or_default();
            v.push(input.into());
            self.event_type_codes = Some(v);
            self
        }
        /// <p>A list of unique identifiers for event types. For example, <code>"AWS_EC2_SYSTEM_MAINTENANCE_EVENT","AWS_RDS_MAINTENANCE_SCHEDULED".</code>
        /// </p>
        pub fn set_event_type_codes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_type_codes = input;
            self
        }
        /// Appends an item to `aws_account_ids`.
        ///
        /// To override the contents of this collection use [`set_aws_account_ids`](Self::set_aws_account_ids).
        ///
        /// <p>A list of 12-digit AWS account numbers that contains the affected entities.</p>
        pub fn aws_account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.aws_account_ids.unwrap_or_default();
            v.push(input.into());
            self.aws_account_ids = Some(v);
            self
        }
        /// <p>A list of 12-digit AWS account numbers that contains the affected entities.</p>
        pub fn set_aws_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.aws_account_ids = input;
            self
        }
        /// Appends an item to `services`.
        ///
        /// To override the contents of this collection use [`set_services`](Self::set_services).
        ///
        /// <p>The AWS services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.</p>
        pub fn services(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.services.unwrap_or_default();
            v.push(input.into());
            self.services = Some(v);
            self
        }
        /// <p>The AWS services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.</p>
        pub fn set_services(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.services = input;
            self
        }
        /// Appends an item to `regions`.
        ///
        /// To override the contents of this collection use [`set_regions`](Self::set_regions).
        ///
        /// <p>A list of AWS Regions.</p>
        pub fn regions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.regions.unwrap_or_default();
            v.push(input.into());
            self.regions = Some(v);
            self
        }
        /// <p>A list of AWS Regions.</p>
        pub fn set_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.regions = input;
            self
        }
        /// <p>A range of dates and times that is used by the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EventFilter.html">EventFilter</a> and <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EntityFilter.html">EntityFilter</a> objects. If <code>from</code> is set and <code>to</code> is set:
        /// match items where the timestamp (<code>startTime</code>, <code>endTime</code>, or
        /// <code>lastUpdatedTime</code>) is between <code>from</code> and <code>to</code>
        /// inclusive. If <code>from</code> is set and <code>to</code> is not set: match items where
        /// the timestamp value is equal to or after <code>from</code>. If <code>from</code> is not set
        /// and <code>to</code> is set: match items where the timestamp value is equal to or before
        /// <code>to</code>.</p>
        pub fn start_time(mut self, input: crate::model::DateTimeRange) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>A range of dates and times that is used by the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EventFilter.html">EventFilter</a> and <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EntityFilter.html">EntityFilter</a> objects. If <code>from</code> is set and <code>to</code> is set:
        /// match items where the timestamp (<code>startTime</code>, <code>endTime</code>, or
        /// <code>lastUpdatedTime</code>) is between <code>from</code> and <code>to</code>
        /// inclusive. If <code>from</code> is set and <code>to</code> is not set: match items where
        /// the timestamp value is equal to or after <code>from</code>. If <code>from</code> is not set
        /// and <code>to</code> is set: match items where the timestamp value is equal to or before
        /// <code>to</code>.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<crate::model::DateTimeRange>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>A range of dates and times that is used by the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EventFilter.html">EventFilter</a> and <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EntityFilter.html">EntityFilter</a> objects. If <code>from</code> is set and <code>to</code> is set:
        /// match items where the timestamp (<code>startTime</code>, <code>endTime</code>, or
        /// <code>lastUpdatedTime</code>) is between <code>from</code> and <code>to</code>
        /// inclusive. If <code>from</code> is set and <code>to</code> is not set: match items where
        /// the timestamp value is equal to or after <code>from</code>. If <code>from</code> is not set
        /// and <code>to</code> is set: match items where the timestamp value is equal to or before
        /// <code>to</code>.</p>
        pub fn end_time(mut self, input: crate::model::DateTimeRange) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>A range of dates and times that is used by the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EventFilter.html">EventFilter</a> and <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EntityFilter.html">EntityFilter</a> objects. If <code>from</code> is set and <code>to</code> is set:
        /// match items where the timestamp (<code>startTime</code>, <code>endTime</code>, or
        /// <code>lastUpdatedTime</code>) is between <code>from</code> and <code>to</code>
        /// inclusive. If <code>from</code> is set and <code>to</code> is not set: match items where
        /// the timestamp value is equal to or after <code>from</code>. If <code>from</code> is not set
        /// and <code>to</code> is set: match items where the timestamp value is equal to or before
        /// <code>to</code>.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<crate::model::DateTimeRange>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>A range of dates and times that is used by the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EventFilter.html">EventFilter</a> and <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EntityFilter.html">EntityFilter</a> objects. If <code>from</code> is set and <code>to</code> is set:
        /// match items where the timestamp (<code>startTime</code>, <code>endTime</code>, or
        /// <code>lastUpdatedTime</code>) is between <code>from</code> and <code>to</code>
        /// inclusive. If <code>from</code> is set and <code>to</code> is not set: match items where
        /// the timestamp value is equal to or after <code>from</code>. If <code>from</code> is not set
        /// and <code>to</code> is set: match items where the timestamp value is equal to or before
        /// <code>to</code>.</p>
        pub fn last_updated_time(mut self, input: crate::model::DateTimeRange) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>A range of dates and times that is used by the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EventFilter.html">EventFilter</a> and <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EntityFilter.html">EntityFilter</a> objects. If <code>from</code> is set and <code>to</code> is set:
        /// match items where the timestamp (<code>startTime</code>, <code>endTime</code>, or
        /// <code>lastUpdatedTime</code>) is between <code>from</code> and <code>to</code>
        /// inclusive. If <code>from</code> is set and <code>to</code> is not set: match items where
        /// the timestamp value is equal to or after <code>from</code>. If <code>from</code> is not set
        /// and <code>to</code> is set: match items where the timestamp value is equal to or before
        /// <code>to</code>.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<crate::model::DateTimeRange>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// Appends an item to `entity_arns`.
        ///
        /// To override the contents of this collection use [`set_entity_arns`](Self::set_entity_arns).
        ///
        /// <p>A list of entity ARNs (unique identifiers).</p>
        pub fn entity_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.entity_arns.unwrap_or_default();
            v.push(input.into());
            self.entity_arns = Some(v);
            self
        }
        /// <p>A list of entity ARNs (unique identifiers).</p>
        pub fn set_entity_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.entity_arns = input;
            self
        }
        /// Appends an item to `entity_values`.
        ///
        /// To override the contents of this collection use [`set_entity_values`](Self::set_entity_values).
        ///
        /// <p>A list of entity identifiers, such as EC2 instance IDs (i-34ab692e) or EBS volumes (vol-426ab23e).</p>
        pub fn entity_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.entity_values.unwrap_or_default();
            v.push(input.into());
            self.entity_values = Some(v);
            self
        }
        /// <p>A list of entity identifiers, such as EC2 instance IDs (i-34ab692e) or EBS volumes (vol-426ab23e).</p>
        pub fn set_entity_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.entity_values = input;
            self
        }
        /// Appends an item to `event_type_categories`.
        ///
        /// To override the contents of this collection use [`set_event_type_categories`](Self::set_event_type_categories).
        ///
        /// <p>A list of event type category codes (issue, scheduledChange, or accountNotification).</p>
        pub fn event_type_categories(
            mut self,
            input: impl Into<crate::model::EventTypeCategory>,
        ) -> Self {
            let mut v = self.event_type_categories.unwrap_or_default();
            v.push(input.into());
            self.event_type_categories = Some(v);
            self
        }
        /// <p>A list of event type category codes (issue, scheduledChange, or accountNotification).</p>
        pub fn set_event_type_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventTypeCategory>>,
        ) -> Self {
            self.event_type_categories = input;
            self
        }
        /// Appends an item to `event_status_codes`.
        ///
        /// To override the contents of this collection use [`set_event_status_codes`](Self::set_event_status_codes).
        ///
        /// <p>A list of event status codes.</p>
        pub fn event_status_codes(
            mut self,
            input: impl Into<crate::model::EventStatusCode>,
        ) -> Self {
            let mut v = self.event_status_codes.unwrap_or_default();
            v.push(input.into());
            self.event_status_codes = Some(v);
            self
        }
        /// <p>A list of event status codes.</p>
        pub fn set_event_status_codes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventStatusCode>>,
        ) -> Self {
            self.event_status_codes = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationEventFilter`](crate::model::OrganizationEventFilter)
        pub fn build(self) -> crate::model::OrganizationEventFilter {
            crate::model::OrganizationEventFilter {
                event_type_codes: self.event_type_codes,
                aws_account_ids: self.aws_account_ids,
                services: self.services,
                regions: self.regions,
                start_time: self.start_time,
                end_time: self.end_time,
                last_updated_time: self.last_updated_time,
                entity_arns: self.entity_arns,
                entity_values: self.entity_values,
                event_type_categories: self.event_type_categories,
                event_status_codes: self.event_status_codes,
            }
        }
    }
}
impl OrganizationEventFilter {
    /// Creates a new builder-style object to manufacture [`OrganizationEventFilter`](crate::model::OrganizationEventFilter)
    pub fn builder() -> crate::model::organization_event_filter::Builder {
        crate::model::organization_event_filter::Builder::default()
    }
}

/// <p>A range of dates and times that is used by the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EventFilter.html">EventFilter</a> and <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EntityFilter.html">EntityFilter</a> objects. If <code>from</code> is set and <code>to</code> is set:
/// match items where the timestamp (<code>startTime</code>, <code>endTime</code>, or
/// <code>lastUpdatedTime</code>) is between <code>from</code> and <code>to</code>
/// inclusive. If <code>from</code> is set and <code>to</code> is not set: match items where
/// the timestamp value is equal to or after <code>from</code>. If <code>from</code> is not set
/// and <code>to</code> is set: match items where the timestamp value is equal to or before
/// <code>to</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DateTimeRange {
    /// <p>The starting date and time of a time range.</p>
    pub from: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The ending date and time of a time range.</p>
    pub to: std::option::Option<aws_smithy_types::Instant>,
}
impl DateTimeRange {
    /// <p>The starting date and time of a time range.</p>
    pub fn from(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.from.as_ref()
    }
    /// <p>The ending date and time of a time range.</p>
    pub fn to(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.to.as_ref()
    }
}
impl std::fmt::Debug for DateTimeRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DateTimeRange");
        formatter.field("from", &self.from);
        formatter.field("to", &self.to);
        formatter.finish()
    }
}
/// See [`DateTimeRange`](crate::model::DateTimeRange)
pub mod date_time_range {
    /// A builder for [`DateTimeRange`](crate::model::DateTimeRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) to: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The starting date and time of a time range.</p>
        pub fn from(mut self, input: aws_smithy_types::Instant) -> Self {
            self.from = Some(input);
            self
        }
        /// <p>The starting date and time of a time range.</p>
        pub fn set_from(mut self, input: std::option::Option<aws_smithy_types::Instant>) -> Self {
            self.from = input;
            self
        }
        /// <p>The ending date and time of a time range.</p>
        pub fn to(mut self, input: aws_smithy_types::Instant) -> Self {
            self.to = Some(input);
            self
        }
        /// <p>The ending date and time of a time range.</p>
        pub fn set_to(mut self, input: std::option::Option<aws_smithy_types::Instant>) -> Self {
            self.to = input;
            self
        }
        /// Consumes the builder and constructs a [`DateTimeRange`](crate::model::DateTimeRange)
        pub fn build(self) -> crate::model::DateTimeRange {
            crate::model::DateTimeRange {
                from: self.from,
                to: self.to,
            }
        }
    }
}
impl DateTimeRange {
    /// Creates a new builder-style object to manufacture [`DateTimeRange`](crate::model::DateTimeRange)
    pub fn builder() -> crate::model::date_time_range::Builder {
        crate::model::date_time_range::Builder::default()
    }
}

/// <p>Summary information about an AWS Health event.</p>
/// <p>AWS Health events can be public or account-specific:</p>
/// <ul>
/// <li>
/// <p>
/// <i>Public events</i> might be service events that are not specific
/// to an AWS account. For example, if there is an issue with an AWS Region,
/// AWS Health provides information about the event, even if you don't use services or
/// resources in that Region.</p>
/// </li>
/// <li>
/// <p>
/// <i>Account-specific</i> events are specific to either your AWS
/// account or an account in your organization. For example, if there's an issue with
/// Amazon Elastic Compute Cloud in a Region that you use, AWS Health provides information about the event
/// and the affected resources in the account.</p>
/// </li>
/// </ul>
/// <p>You can determine if an event is public or account-specific by using the
/// <code>eventScopeCode</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_Event.html#AWSHealth-Type-Event-eventScopeCode">eventScopeCode</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Event {
    /// <p>The unique identifier for the event. The event ARN has the
    /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
    /// </code>
    /// format.</p>
    /// <p>For example, an event ARN might look like the following:</p>
    /// <p>
    /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
    /// </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The AWS service that is affected by the event. For example, <code>EC2</code>, <code>RDS</code>.</p>
    pub service: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the event type. The format is <code>AWS_<i>SERVICE</i>_<i>DESCRIPTION</i>
    /// </code>; for example, <code>AWS_EC2_SYSTEM_MAINTENANCE_EVENT</code>.</p>
    pub event_type_code: std::option::Option<std::string::String>,
    /// <p>The category of the event. Possible values are <code>issue</code>,
    /// <code>scheduledChange</code>, and <code>accountNotification</code>.</p>
    pub event_type_category: std::option::Option<crate::model::EventTypeCategory>,
    /// <p>The AWS Region name of the event.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The AWS Availability Zone of the event. For example, us-east-1a.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The date and time that the event began.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time that the event ended.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The most recent date and time that the event was updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The most recent status of the event. Possible values are <code>open</code>,
    /// <code>closed</code>, and <code>upcoming</code>.</p>
    pub status_code: std::option::Option<crate::model::EventStatusCode>,
    /// <p>This parameter specifies if the AWS Health event is a public AWS service event or an account-specific event.</p>
    /// <ul>
    /// <li>
    /// <p>If the <code>eventScopeCode</code> value is <code>PUBLIC</code>, then the
    /// <code>affectedAccounts</code> value is always empty.</p>
    /// </li>
    /// <li>
    /// <p>If the <code>eventScopeCode</code> value is <code>ACCOUNT_SPECIFIC</code>, then
    /// the <code>affectedAccounts</code> value lists the affected AWS accounts in your
    /// organization. For example, if an event affects a service such as Amazon Elastic Compute Cloud and you
    /// have AWS accounts that use that service, those account IDs appear in the
    /// response.</p>
    /// </li>
    /// <li>
    /// <p>If the <code>eventScopeCode</code> value is <code>NONE</code>, then the
    /// <code>eventArn</code> that you specified in the request is invalid or doesn't
    /// exist.</p>
    /// </li>
    /// </ul>
    pub event_scope_code: std::option::Option<crate::model::EventScopeCode>,
}
impl Event {
    /// <p>The unique identifier for the event. The event ARN has the
    /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
    /// </code>
    /// format.</p>
    /// <p>For example, an event ARN might look like the following:</p>
    /// <p>
    /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
    /// </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The AWS service that is affected by the event. For example, <code>EC2</code>, <code>RDS</code>.</p>
    pub fn service(&self) -> std::option::Option<&str> {
        self.service.as_deref()
    }
    /// <p>The unique identifier for the event type. The format is <code>AWS_<i>SERVICE</i>_<i>DESCRIPTION</i>
    /// </code>; for example, <code>AWS_EC2_SYSTEM_MAINTENANCE_EVENT</code>.</p>
    pub fn event_type_code(&self) -> std::option::Option<&str> {
        self.event_type_code.as_deref()
    }
    /// <p>The category of the event. Possible values are <code>issue</code>,
    /// <code>scheduledChange</code>, and <code>accountNotification</code>.</p>
    pub fn event_type_category(&self) -> std::option::Option<&crate::model::EventTypeCategory> {
        self.event_type_category.as_ref()
    }
    /// <p>The AWS Region name of the event.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>The AWS Availability Zone of the event. For example, us-east-1a.</p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>The date and time that the event began.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_time.as_ref()
    }
    /// <p>The date and time that the event ended.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
    /// <p>The most recent date and time that the event was updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_time.as_ref()
    }
    /// <p>The most recent status of the event. Possible values are <code>open</code>,
    /// <code>closed</code>, and <code>upcoming</code>.</p>
    pub fn status_code(&self) -> std::option::Option<&crate::model::EventStatusCode> {
        self.status_code.as_ref()
    }
    /// <p>This parameter specifies if the AWS Health event is a public AWS service event or an account-specific event.</p>
    /// <ul>
    /// <li>
    /// <p>If the <code>eventScopeCode</code> value is <code>PUBLIC</code>, then the
    /// <code>affectedAccounts</code> value is always empty.</p>
    /// </li>
    /// <li>
    /// <p>If the <code>eventScopeCode</code> value is <code>ACCOUNT_SPECIFIC</code>, then
    /// the <code>affectedAccounts</code> value lists the affected AWS accounts in your
    /// organization. For example, if an event affects a service such as Amazon Elastic Compute Cloud and you
    /// have AWS accounts that use that service, those account IDs appear in the
    /// response.</p>
    /// </li>
    /// <li>
    /// <p>If the <code>eventScopeCode</code> value is <code>NONE</code>, then the
    /// <code>eventArn</code> that you specified in the request is invalid or doesn't
    /// exist.</p>
    /// </li>
    /// </ul>
    pub fn event_scope_code(&self) -> std::option::Option<&crate::model::EventScopeCode> {
        self.event_scope_code.as_ref()
    }
}
impl std::fmt::Debug for Event {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Event");
        formatter.field("arn", &self.arn);
        formatter.field("service", &self.service);
        formatter.field("event_type_code", &self.event_type_code);
        formatter.field("event_type_category", &self.event_type_category);
        formatter.field("region", &self.region);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("status_code", &self.status_code);
        formatter.field("event_scope_code", &self.event_scope_code);
        formatter.finish()
    }
}
/// See [`Event`](crate::model::Event)
pub mod event {
    /// A builder for [`Event`](crate::model::Event)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) service: std::option::Option<std::string::String>,
        pub(crate) event_type_code: std::option::Option<std::string::String>,
        pub(crate) event_type_category: std::option::Option<crate::model::EventTypeCategory>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status_code: std::option::Option<crate::model::EventStatusCode>,
        pub(crate) event_scope_code: std::option::Option<crate::model::EventScopeCode>,
    }
    impl Builder {
        /// <p>The unique identifier for the event. The event ARN has the
        /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
        /// </code>
        /// format.</p>
        /// <p>For example, an event ARN might look like the following:</p>
        /// <p>
        /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
        /// </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The unique identifier for the event. The event ARN has the
        /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
        /// </code>
        /// format.</p>
        /// <p>For example, an event ARN might look like the following:</p>
        /// <p>
        /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
        /// </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The AWS service that is affected by the event. For example, <code>EC2</code>, <code>RDS</code>.</p>
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.service = Some(input.into());
            self
        }
        /// <p>The AWS service that is affected by the event. For example, <code>EC2</code>, <code>RDS</code>.</p>
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service = input;
            self
        }
        /// <p>The unique identifier for the event type. The format is <code>AWS_<i>SERVICE</i>_<i>DESCRIPTION</i>
        /// </code>; for example, <code>AWS_EC2_SYSTEM_MAINTENANCE_EVENT</code>.</p>
        pub fn event_type_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_type_code = Some(input.into());
            self
        }
        /// <p>The unique identifier for the event type. The format is <code>AWS_<i>SERVICE</i>_<i>DESCRIPTION</i>
        /// </code>; for example, <code>AWS_EC2_SYSTEM_MAINTENANCE_EVENT</code>.</p>
        pub fn set_event_type_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_type_code = input;
            self
        }
        /// <p>The category of the event. Possible values are <code>issue</code>,
        /// <code>scheduledChange</code>, and <code>accountNotification</code>.</p>
        pub fn event_type_category(mut self, input: crate::model::EventTypeCategory) -> Self {
            self.event_type_category = Some(input);
            self
        }
        /// <p>The category of the event. Possible values are <code>issue</code>,
        /// <code>scheduledChange</code>, and <code>accountNotification</code>.</p>
        pub fn set_event_type_category(
            mut self,
            input: std::option::Option<crate::model::EventTypeCategory>,
        ) -> Self {
            self.event_type_category = input;
            self
        }
        /// <p>The AWS Region name of the event.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The AWS Region name of the event.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The AWS Availability Zone of the event. For example, us-east-1a.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The AWS Availability Zone of the event. For example, us-east-1a.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The date and time that the event began.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The date and time that the event began.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The date and time that the event ended.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The date and time that the event ended.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The most recent date and time that the event was updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The most recent date and time that the event was updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>The most recent status of the event. Possible values are <code>open</code>,
        /// <code>closed</code>, and <code>upcoming</code>.</p>
        pub fn status_code(mut self, input: crate::model::EventStatusCode) -> Self {
            self.status_code = Some(input);
            self
        }
        /// <p>The most recent status of the event. Possible values are <code>open</code>,
        /// <code>closed</code>, and <code>upcoming</code>.</p>
        pub fn set_status_code(
            mut self,
            input: std::option::Option<crate::model::EventStatusCode>,
        ) -> Self {
            self.status_code = input;
            self
        }
        /// <p>This parameter specifies if the AWS Health event is a public AWS service event or an account-specific event.</p>
        /// <ul>
        /// <li>
        /// <p>If the <code>eventScopeCode</code> value is <code>PUBLIC</code>, then the
        /// <code>affectedAccounts</code> value is always empty.</p>
        /// </li>
        /// <li>
        /// <p>If the <code>eventScopeCode</code> value is <code>ACCOUNT_SPECIFIC</code>, then
        /// the <code>affectedAccounts</code> value lists the affected AWS accounts in your
        /// organization. For example, if an event affects a service such as Amazon Elastic Compute Cloud and you
        /// have AWS accounts that use that service, those account IDs appear in the
        /// response.</p>
        /// </li>
        /// <li>
        /// <p>If the <code>eventScopeCode</code> value is <code>NONE</code>, then the
        /// <code>eventArn</code> that you specified in the request is invalid or doesn't
        /// exist.</p>
        /// </li>
        /// </ul>
        pub fn event_scope_code(mut self, input: crate::model::EventScopeCode) -> Self {
            self.event_scope_code = Some(input);
            self
        }
        /// <p>This parameter specifies if the AWS Health event is a public AWS service event or an account-specific event.</p>
        /// <ul>
        /// <li>
        /// <p>If the <code>eventScopeCode</code> value is <code>PUBLIC</code>, then the
        /// <code>affectedAccounts</code> value is always empty.</p>
        /// </li>
        /// <li>
        /// <p>If the <code>eventScopeCode</code> value is <code>ACCOUNT_SPECIFIC</code>, then
        /// the <code>affectedAccounts</code> value lists the affected AWS accounts in your
        /// organization. For example, if an event affects a service such as Amazon Elastic Compute Cloud and you
        /// have AWS accounts that use that service, those account IDs appear in the
        /// response.</p>
        /// </li>
        /// <li>
        /// <p>If the <code>eventScopeCode</code> value is <code>NONE</code>, then the
        /// <code>eventArn</code> that you specified in the request is invalid or doesn't
        /// exist.</p>
        /// </li>
        /// </ul>
        pub fn set_event_scope_code(
            mut self,
            input: std::option::Option<crate::model::EventScopeCode>,
        ) -> Self {
            self.event_scope_code = input;
            self
        }
        /// Consumes the builder and constructs a [`Event`](crate::model::Event)
        pub fn build(self) -> crate::model::Event {
            crate::model::Event {
                arn: self.arn,
                service: self.service,
                event_type_code: self.event_type_code,
                event_type_category: self.event_type_category,
                region: self.region,
                availability_zone: self.availability_zone,
                start_time: self.start_time,
                end_time: self.end_time,
                last_updated_time: self.last_updated_time,
                status_code: self.status_code,
                event_scope_code: self.event_scope_code,
            }
        }
    }
}
impl Event {
    /// Creates a new builder-style object to manufacture [`Event`](crate::model::Event)
    pub fn builder() -> crate::model::event::Builder {
        crate::model::event::Builder::default()
    }
}

/// <p>The values to use to filter results from the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEvents.html">DescribeEvents</a> and
/// <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventAggregates.html">DescribeEventAggregates</a> operations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventFilter {
    /// <p>A list of event ARNs (unique identifiers). For example: <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
    /// </p>
    pub event_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of unique identifiers for event types. For example, <code>"AWS_EC2_SYSTEM_MAINTENANCE_EVENT","AWS_RDS_MAINTENANCE_SCHEDULED".</code>
    /// </p>
    pub event_type_codes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The AWS services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.</p>
    pub services: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of AWS Regions.</p>
    pub regions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of AWS Availability Zones.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of dates and times that the event began.</p>
    pub start_times: std::option::Option<std::vec::Vec<crate::model::DateTimeRange>>,
    /// <p>A list of dates and times that the event ended.</p>
    pub end_times: std::option::Option<std::vec::Vec<crate::model::DateTimeRange>>,
    /// <p>A list of dates and times that the event was last updated.</p>
    pub last_updated_times: std::option::Option<std::vec::Vec<crate::model::DateTimeRange>>,
    /// <p>A list of entity ARNs (unique identifiers).</p>
    pub entity_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of entity identifiers, such as EC2 instance IDs (<code>i-34ab692e</code>) or EBS
    /// volumes (<code>vol-426ab23e</code>).</p>
    pub entity_values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>,
    /// or <code>accountNotification</code>).</p>
    pub event_type_categories: std::option::Option<std::vec::Vec<crate::model::EventTypeCategory>>,
    /// <p>A map of entity tags attached to the affected entity.</p>
    /// <note>
    /// <p>Currently, the <code>tags</code> property isn't supported.</p>
    /// </note>
    pub tags: std::option::Option<
        std::vec::Vec<std::collections::HashMap<std::string::String, std::string::String>>,
    >,
    /// <p>A list of event status codes.</p>
    pub event_status_codes: std::option::Option<std::vec::Vec<crate::model::EventStatusCode>>,
}
impl EventFilter {
    /// <p>A list of event ARNs (unique identifiers). For example: <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
    /// </p>
    pub fn event_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.event_arns.as_deref()
    }
    /// <p>A list of unique identifiers for event types. For example, <code>"AWS_EC2_SYSTEM_MAINTENANCE_EVENT","AWS_RDS_MAINTENANCE_SCHEDULED".</code>
    /// </p>
    pub fn event_type_codes(&self) -> std::option::Option<&[std::string::String]> {
        self.event_type_codes.as_deref()
    }
    /// <p>The AWS services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.</p>
    pub fn services(&self) -> std::option::Option<&[std::string::String]> {
        self.services.as_deref()
    }
    /// <p>A list of AWS Regions.</p>
    pub fn regions(&self) -> std::option::Option<&[std::string::String]> {
        self.regions.as_deref()
    }
    /// <p>A list of AWS Availability Zones.</p>
    pub fn availability_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.availability_zones.as_deref()
    }
    /// <p>A list of dates and times that the event began.</p>
    pub fn start_times(&self) -> std::option::Option<&[crate::model::DateTimeRange]> {
        self.start_times.as_deref()
    }
    /// <p>A list of dates and times that the event ended.</p>
    pub fn end_times(&self) -> std::option::Option<&[crate::model::DateTimeRange]> {
        self.end_times.as_deref()
    }
    /// <p>A list of dates and times that the event was last updated.</p>
    pub fn last_updated_times(&self) -> std::option::Option<&[crate::model::DateTimeRange]> {
        self.last_updated_times.as_deref()
    }
    /// <p>A list of entity ARNs (unique identifiers).</p>
    pub fn entity_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.entity_arns.as_deref()
    }
    /// <p>A list of entity identifiers, such as EC2 instance IDs (<code>i-34ab692e</code>) or EBS
    /// volumes (<code>vol-426ab23e</code>).</p>
    pub fn entity_values(&self) -> std::option::Option<&[std::string::String]> {
        self.entity_values.as_deref()
    }
    /// <p>A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>,
    /// or <code>accountNotification</code>).</p>
    pub fn event_type_categories(&self) -> std::option::Option<&[crate::model::EventTypeCategory]> {
        self.event_type_categories.as_deref()
    }
    /// <p>A map of entity tags attached to the affected entity.</p>
    /// <note>
    /// <p>Currently, the <code>tags</code> property isn't supported.</p>
    /// </note>
    pub fn tags(
        &self,
    ) -> std::option::Option<&[std::collections::HashMap<std::string::String, std::string::String>]>
    {
        self.tags.as_deref()
    }
    /// <p>A list of event status codes.</p>
    pub fn event_status_codes(&self) -> std::option::Option<&[crate::model::EventStatusCode]> {
        self.event_status_codes.as_deref()
    }
}
impl std::fmt::Debug for EventFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventFilter");
        formatter.field("event_arns", &self.event_arns);
        formatter.field("event_type_codes", &self.event_type_codes);
        formatter.field("services", &self.services);
        formatter.field("regions", &self.regions);
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("start_times", &self.start_times);
        formatter.field("end_times", &self.end_times);
        formatter.field("last_updated_times", &self.last_updated_times);
        formatter.field("entity_arns", &self.entity_arns);
        formatter.field("entity_values", &self.entity_values);
        formatter.field("event_type_categories", &self.event_type_categories);
        formatter.field("tags", &self.tags);
        formatter.field("event_status_codes", &self.event_status_codes);
        formatter.finish()
    }
}
/// See [`EventFilter`](crate::model::EventFilter)
pub mod event_filter {
    /// A builder for [`EventFilter`](crate::model::EventFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) event_type_codes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) services: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) regions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) start_times: std::option::Option<std::vec::Vec<crate::model::DateTimeRange>>,
        pub(crate) end_times: std::option::Option<std::vec::Vec<crate::model::DateTimeRange>>,
        pub(crate) last_updated_times:
            std::option::Option<std::vec::Vec<crate::model::DateTimeRange>>,
        pub(crate) entity_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) entity_values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) event_type_categories:
            std::option::Option<std::vec::Vec<crate::model::EventTypeCategory>>,
        pub(crate) tags: std::option::Option<
            std::vec::Vec<std::collections::HashMap<std::string::String, std::string::String>>,
        >,
        pub(crate) event_status_codes:
            std::option::Option<std::vec::Vec<crate::model::EventStatusCode>>,
    }
    impl Builder {
        /// Appends an item to `event_arns`.
        ///
        /// To override the contents of this collection use [`set_event_arns`](Self::set_event_arns).
        ///
        /// <p>A list of event ARNs (unique identifiers). For example: <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
        /// </p>
        pub fn event_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_arns.unwrap_or_default();
            v.push(input.into());
            self.event_arns = Some(v);
            self
        }
        /// <p>A list of event ARNs (unique identifiers). For example: <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
        /// </p>
        pub fn set_event_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_arns = input;
            self
        }
        /// Appends an item to `event_type_codes`.
        ///
        /// To override the contents of this collection use [`set_event_type_codes`](Self::set_event_type_codes).
        ///
        /// <p>A list of unique identifiers for event types. For example, <code>"AWS_EC2_SYSTEM_MAINTENANCE_EVENT","AWS_RDS_MAINTENANCE_SCHEDULED".</code>
        /// </p>
        pub fn event_type_codes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_type_codes.unwrap_or_default();
            v.push(input.into());
            self.event_type_codes = Some(v);
            self
        }
        /// <p>A list of unique identifiers for event types. For example, <code>"AWS_EC2_SYSTEM_MAINTENANCE_EVENT","AWS_RDS_MAINTENANCE_SCHEDULED".</code>
        /// </p>
        pub fn set_event_type_codes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_type_codes = input;
            self
        }
        /// Appends an item to `services`.
        ///
        /// To override the contents of this collection use [`set_services`](Self::set_services).
        ///
        /// <p>The AWS services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.</p>
        pub fn services(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.services.unwrap_or_default();
            v.push(input.into());
            self.services = Some(v);
            self
        }
        /// <p>The AWS services associated with the event. For example, <code>EC2</code>, <code>RDS</code>.</p>
        pub fn set_services(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.services = input;
            self
        }
        /// Appends an item to `regions`.
        ///
        /// To override the contents of this collection use [`set_regions`](Self::set_regions).
        ///
        /// <p>A list of AWS Regions.</p>
        pub fn regions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.regions.unwrap_or_default();
            v.push(input.into());
            self.regions = Some(v);
            self
        }
        /// <p>A list of AWS Regions.</p>
        pub fn set_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.regions = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>A list of AWS Availability Zones.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>A list of AWS Availability Zones.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// Appends an item to `start_times`.
        ///
        /// To override the contents of this collection use [`set_start_times`](Self::set_start_times).
        ///
        /// <p>A list of dates and times that the event began.</p>
        pub fn start_times(mut self, input: impl Into<crate::model::DateTimeRange>) -> Self {
            let mut v = self.start_times.unwrap_or_default();
            v.push(input.into());
            self.start_times = Some(v);
            self
        }
        /// <p>A list of dates and times that the event began.</p>
        pub fn set_start_times(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DateTimeRange>>,
        ) -> Self {
            self.start_times = input;
            self
        }
        /// Appends an item to `end_times`.
        ///
        /// To override the contents of this collection use [`set_end_times`](Self::set_end_times).
        ///
        /// <p>A list of dates and times that the event ended.</p>
        pub fn end_times(mut self, input: impl Into<crate::model::DateTimeRange>) -> Self {
            let mut v = self.end_times.unwrap_or_default();
            v.push(input.into());
            self.end_times = Some(v);
            self
        }
        /// <p>A list of dates and times that the event ended.</p>
        pub fn set_end_times(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DateTimeRange>>,
        ) -> Self {
            self.end_times = input;
            self
        }
        /// Appends an item to `last_updated_times`.
        ///
        /// To override the contents of this collection use [`set_last_updated_times`](Self::set_last_updated_times).
        ///
        /// <p>A list of dates and times that the event was last updated.</p>
        pub fn last_updated_times(mut self, input: impl Into<crate::model::DateTimeRange>) -> Self {
            let mut v = self.last_updated_times.unwrap_or_default();
            v.push(input.into());
            self.last_updated_times = Some(v);
            self
        }
        /// <p>A list of dates and times that the event was last updated.</p>
        pub fn set_last_updated_times(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DateTimeRange>>,
        ) -> Self {
            self.last_updated_times = input;
            self
        }
        /// Appends an item to `entity_arns`.
        ///
        /// To override the contents of this collection use [`set_entity_arns`](Self::set_entity_arns).
        ///
        /// <p>A list of entity ARNs (unique identifiers).</p>
        pub fn entity_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.entity_arns.unwrap_or_default();
            v.push(input.into());
            self.entity_arns = Some(v);
            self
        }
        /// <p>A list of entity ARNs (unique identifiers).</p>
        pub fn set_entity_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.entity_arns = input;
            self
        }
        /// Appends an item to `entity_values`.
        ///
        /// To override the contents of this collection use [`set_entity_values`](Self::set_entity_values).
        ///
        /// <p>A list of entity identifiers, such as EC2 instance IDs (<code>i-34ab692e</code>) or EBS
        /// volumes (<code>vol-426ab23e</code>).</p>
        pub fn entity_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.entity_values.unwrap_or_default();
            v.push(input.into());
            self.entity_values = Some(v);
            self
        }
        /// <p>A list of entity identifiers, such as EC2 instance IDs (<code>i-34ab692e</code>) or EBS
        /// volumes (<code>vol-426ab23e</code>).</p>
        pub fn set_entity_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.entity_values = input;
            self
        }
        /// Appends an item to `event_type_categories`.
        ///
        /// To override the contents of this collection use [`set_event_type_categories`](Self::set_event_type_categories).
        ///
        /// <p>A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>,
        /// or <code>accountNotification</code>).</p>
        pub fn event_type_categories(
            mut self,
            input: impl Into<crate::model::EventTypeCategory>,
        ) -> Self {
            let mut v = self.event_type_categories.unwrap_or_default();
            v.push(input.into());
            self.event_type_categories = Some(v);
            self
        }
        /// <p>A list of event type category codes (<code>issue</code>, <code>scheduledChange</code>,
        /// or <code>accountNotification</code>).</p>
        pub fn set_event_type_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventTypeCategory>>,
        ) -> Self {
            self.event_type_categories = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map of entity tags attached to the affected entity.</p>
        /// <note>
        /// <p>Currently, the <code>tags</code> property isn't supported.</p>
        /// </note>
        pub fn tags(
            mut self,
            input: impl Into<std::collections::HashMap<std::string::String, std::string::String>>,
        ) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A map of entity tags attached to the affected entity.</p>
        /// <note>
        /// <p>Currently, the <code>tags</code> property isn't supported.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::vec::Vec<std::collections::HashMap<std::string::String, std::string::String>>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `event_status_codes`.
        ///
        /// To override the contents of this collection use [`set_event_status_codes`](Self::set_event_status_codes).
        ///
        /// <p>A list of event status codes.</p>
        pub fn event_status_codes(
            mut self,
            input: impl Into<crate::model::EventStatusCode>,
        ) -> Self {
            let mut v = self.event_status_codes.unwrap_or_default();
            v.push(input.into());
            self.event_status_codes = Some(v);
            self
        }
        /// <p>A list of event status codes.</p>
        pub fn set_event_status_codes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventStatusCode>>,
        ) -> Self {
            self.event_status_codes = input;
            self
        }
        /// Consumes the builder and constructs a [`EventFilter`](crate::model::EventFilter)
        pub fn build(self) -> crate::model::EventFilter {
            crate::model::EventFilter {
                event_arns: self.event_arns,
                event_type_codes: self.event_type_codes,
                services: self.services,
                regions: self.regions,
                availability_zones: self.availability_zones,
                start_times: self.start_times,
                end_times: self.end_times,
                last_updated_times: self.last_updated_times,
                entity_arns: self.entity_arns,
                entity_values: self.entity_values,
                event_type_categories: self.event_type_categories,
                tags: self.tags,
                event_status_codes: self.event_status_codes,
            }
        }
    }
}
impl EventFilter {
    /// Creates a new builder-style object to manufacture [`EventFilter`](crate::model::EventFilter)
    pub fn builder() -> crate::model::event_filter::Builder {
        crate::model::event_filter::Builder::default()
    }
}

/// <p>Error information returned when a <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventDetailsForOrganization.html">DescribeEventDetailsForOrganization</a> operation can't find a specified
/// event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationEventDetailsErrorItem {
    /// <p>Error information returned when a <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventDetailsForOrganization.html">DescribeEventDetailsForOrganization</a> operation can't find a specified
    /// event.</p>
    pub aws_account_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the event. The event ARN has the
    /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
    /// </code>
    /// format.</p>
    /// <p>For example, an event ARN might look like the following:</p>
    /// <p>
    /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
    /// </p>
    pub event_arn: std::option::Option<std::string::String>,
    /// <p>The name of the error.</p>
    pub error_name: std::option::Option<std::string::String>,
    /// <p>A message that describes the error.</p>
    /// <p>If you call the <code>DescribeEventDetailsForOrganization</code>
    /// operation and receive one of the following errors, follow the recommendations in the message:</p>
    /// <ul>
    /// <li>
    /// <p>We couldn't find a public event that matches your request. To find an event that is account specific, you must enter an AWS account ID in the request.</p>
    /// </li>
    /// <li>
    /// <p>We couldn't find an account specific event for the specified AWS account. To find an event that is public, you must enter a null value for the AWS account ID in the request.</p>
    /// </li>
    /// <li>
    /// <p>Your AWS account doesn't include the AWS Support plan required to use the AWS Health API. You must have either a Business or Enterprise Support plan.</p>
    /// </li>
    /// </ul>
    pub error_message: std::option::Option<std::string::String>,
}
impl OrganizationEventDetailsErrorItem {
    /// <p>Error information returned when a <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventDetailsForOrganization.html">DescribeEventDetailsForOrganization</a> operation can't find a specified
    /// event.</p>
    pub fn aws_account_id(&self) -> std::option::Option<&str> {
        self.aws_account_id.as_deref()
    }
    /// <p>The unique identifier for the event. The event ARN has the
    /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
    /// </code>
    /// format.</p>
    /// <p>For example, an event ARN might look like the following:</p>
    /// <p>
    /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
    /// </p>
    pub fn event_arn(&self) -> std::option::Option<&str> {
        self.event_arn.as_deref()
    }
    /// <p>The name of the error.</p>
    pub fn error_name(&self) -> std::option::Option<&str> {
        self.error_name.as_deref()
    }
    /// <p>A message that describes the error.</p>
    /// <p>If you call the <code>DescribeEventDetailsForOrganization</code>
    /// operation and receive one of the following errors, follow the recommendations in the message:</p>
    /// <ul>
    /// <li>
    /// <p>We couldn't find a public event that matches your request. To find an event that is account specific, you must enter an AWS account ID in the request.</p>
    /// </li>
    /// <li>
    /// <p>We couldn't find an account specific event for the specified AWS account. To find an event that is public, you must enter a null value for the AWS account ID in the request.</p>
    /// </li>
    /// <li>
    /// <p>Your AWS account doesn't include the AWS Support plan required to use the AWS Health API. You must have either a Business or Enterprise Support plan.</p>
    /// </li>
    /// </ul>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for OrganizationEventDetailsErrorItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationEventDetailsErrorItem");
        formatter.field("aws_account_id", &self.aws_account_id);
        formatter.field("event_arn", &self.event_arn);
        formatter.field("error_name", &self.error_name);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`OrganizationEventDetailsErrorItem`](crate::model::OrganizationEventDetailsErrorItem)
pub mod organization_event_details_error_item {
    /// A builder for [`OrganizationEventDetailsErrorItem`](crate::model::OrganizationEventDetailsErrorItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) event_arn: std::option::Option<std::string::String>,
        pub(crate) error_name: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Error information returned when a <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventDetailsForOrganization.html">DescribeEventDetailsForOrganization</a> operation can't find a specified
        /// event.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>Error information returned when a <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventDetailsForOrganization.html">DescribeEventDetailsForOrganization</a> operation can't find a specified
        /// event.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The unique identifier for the event. The event ARN has the
        /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
        /// </code>
        /// format.</p>
        /// <p>For example, an event ARN might look like the following:</p>
        /// <p>
        /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
        /// </p>
        pub fn event_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_arn = Some(input.into());
            self
        }
        /// <p>The unique identifier for the event. The event ARN has the
        /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
        /// </code>
        /// format.</p>
        /// <p>For example, an event ARN might look like the following:</p>
        /// <p>
        /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
        /// </p>
        pub fn set_event_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_arn = input;
            self
        }
        /// <p>The name of the error.</p>
        pub fn error_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_name = Some(input.into());
            self
        }
        /// <p>The name of the error.</p>
        pub fn set_error_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_name = input;
            self
        }
        /// <p>A message that describes the error.</p>
        /// <p>If you call the <code>DescribeEventDetailsForOrganization</code>
        /// operation and receive one of the following errors, follow the recommendations in the message:</p>
        /// <ul>
        /// <li>
        /// <p>We couldn't find a public event that matches your request. To find an event that is account specific, you must enter an AWS account ID in the request.</p>
        /// </li>
        /// <li>
        /// <p>We couldn't find an account specific event for the specified AWS account. To find an event that is public, you must enter a null value for the AWS account ID in the request.</p>
        /// </li>
        /// <li>
        /// <p>Your AWS account doesn't include the AWS Support plan required to use the AWS Health API. You must have either a Business or Enterprise Support plan.</p>
        /// </li>
        /// </ul>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>A message that describes the error.</p>
        /// <p>If you call the <code>DescribeEventDetailsForOrganization</code>
        /// operation and receive one of the following errors, follow the recommendations in the message:</p>
        /// <ul>
        /// <li>
        /// <p>We couldn't find a public event that matches your request. To find an event that is account specific, you must enter an AWS account ID in the request.</p>
        /// </li>
        /// <li>
        /// <p>We couldn't find an account specific event for the specified AWS account. To find an event that is public, you must enter a null value for the AWS account ID in the request.</p>
        /// </li>
        /// <li>
        /// <p>Your AWS account doesn't include the AWS Support plan required to use the AWS Health API. You must have either a Business or Enterprise Support plan.</p>
        /// </li>
        /// </ul>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationEventDetailsErrorItem`](crate::model::OrganizationEventDetailsErrorItem)
        pub fn build(self) -> crate::model::OrganizationEventDetailsErrorItem {
            crate::model::OrganizationEventDetailsErrorItem {
                aws_account_id: self.aws_account_id,
                event_arn: self.event_arn,
                error_name: self.error_name,
                error_message: self.error_message,
            }
        }
    }
}
impl OrganizationEventDetailsErrorItem {
    /// Creates a new builder-style object to manufacture [`OrganizationEventDetailsErrorItem`](crate::model::OrganizationEventDetailsErrorItem)
    pub fn builder() -> crate::model::organization_event_details_error_item::Builder {
        crate::model::organization_event_details_error_item::Builder::default()
    }
}

/// <p>Detailed information about an event. A combination of an <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_Event.html">Event</a> object, an <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EventDescription.html">EventDescription</a> object, and additional metadata about the event. Returned by
/// the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventDetailsForOrganization.html">DescribeEventDetailsForOrganization</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationEventDetails {
    /// <p>The 12-digit AWS account numbers that contains the affected entities.</p>
    pub aws_account_id: std::option::Option<std::string::String>,
    /// <p>Summary information about an AWS Health event.</p>
    /// <p>AWS Health events can be public or account-specific:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <i>Public events</i> might be service events that are not specific
    /// to an AWS account. For example, if there is an issue with an AWS Region,
    /// AWS Health provides information about the event, even if you don't use services or
    /// resources in that Region.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>Account-specific</i> events are specific to either your AWS
    /// account or an account in your organization. For example, if there's an issue with
    /// Amazon Elastic Compute Cloud in a Region that you use, AWS Health provides information about the event
    /// and the affected resources in the account.</p>
    /// </li>
    /// </ul>
    /// <p>You can determine if an event is public or account-specific by using the
    /// <code>eventScopeCode</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_Event.html#AWSHealth-Type-Event-eventScopeCode">eventScopeCode</a>.</p>
    pub event: std::option::Option<crate::model::Event>,
    /// <p>The detailed description of the event. Included in the information returned by the
    /// <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventDetails.html">DescribeEventDetails</a> operation.</p>
    pub event_description: std::option::Option<crate::model::EventDescription>,
    /// <p>Additional metadata about the event.</p>
    pub event_metadata:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl OrganizationEventDetails {
    /// <p>The 12-digit AWS account numbers that contains the affected entities.</p>
    pub fn aws_account_id(&self) -> std::option::Option<&str> {
        self.aws_account_id.as_deref()
    }
    /// <p>Summary information about an AWS Health event.</p>
    /// <p>AWS Health events can be public or account-specific:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <i>Public events</i> might be service events that are not specific
    /// to an AWS account. For example, if there is an issue with an AWS Region,
    /// AWS Health provides information about the event, even if you don't use services or
    /// resources in that Region.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <i>Account-specific</i> events are specific to either your AWS
    /// account or an account in your organization. For example, if there's an issue with
    /// Amazon Elastic Compute Cloud in a Region that you use, AWS Health provides information about the event
    /// and the affected resources in the account.</p>
    /// </li>
    /// </ul>
    /// <p>You can determine if an event is public or account-specific by using the
    /// <code>eventScopeCode</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_Event.html#AWSHealth-Type-Event-eventScopeCode">eventScopeCode</a>.</p>
    pub fn event(&self) -> std::option::Option<&crate::model::Event> {
        self.event.as_ref()
    }
    /// <p>The detailed description of the event. Included in the information returned by the
    /// <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventDetails.html">DescribeEventDetails</a> operation.</p>
    pub fn event_description(&self) -> std::option::Option<&crate::model::EventDescription> {
        self.event_description.as_ref()
    }
    /// <p>Additional metadata about the event.</p>
    pub fn event_metadata(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.event_metadata.as_ref()
    }
}
impl std::fmt::Debug for OrganizationEventDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationEventDetails");
        formatter.field("aws_account_id", &self.aws_account_id);
        formatter.field("event", &self.event);
        formatter.field("event_description", &self.event_description);
        formatter.field("event_metadata", &self.event_metadata);
        formatter.finish()
    }
}
/// See [`OrganizationEventDetails`](crate::model::OrganizationEventDetails)
pub mod organization_event_details {
    /// A builder for [`OrganizationEventDetails`](crate::model::OrganizationEventDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) event: std::option::Option<crate::model::Event>,
        pub(crate) event_description: std::option::Option<crate::model::EventDescription>,
        pub(crate) event_metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The 12-digit AWS account numbers that contains the affected entities.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The 12-digit AWS account numbers that contains the affected entities.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>Summary information about an AWS Health event.</p>
        /// <p>AWS Health events can be public or account-specific:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <i>Public events</i> might be service events that are not specific
        /// to an AWS account. For example, if there is an issue with an AWS Region,
        /// AWS Health provides information about the event, even if you don't use services or
        /// resources in that Region.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>Account-specific</i> events are specific to either your AWS
        /// account or an account in your organization. For example, if there's an issue with
        /// Amazon Elastic Compute Cloud in a Region that you use, AWS Health provides information about the event
        /// and the affected resources in the account.</p>
        /// </li>
        /// </ul>
        /// <p>You can determine if an event is public or account-specific by using the
        /// <code>eventScopeCode</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_Event.html#AWSHealth-Type-Event-eventScopeCode">eventScopeCode</a>.</p>
        pub fn event(mut self, input: crate::model::Event) -> Self {
            self.event = Some(input);
            self
        }
        /// <p>Summary information about an AWS Health event.</p>
        /// <p>AWS Health events can be public or account-specific:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <i>Public events</i> might be service events that are not specific
        /// to an AWS account. For example, if there is an issue with an AWS Region,
        /// AWS Health provides information about the event, even if you don't use services or
        /// resources in that Region.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <i>Account-specific</i> events are specific to either your AWS
        /// account or an account in your organization. For example, if there's an issue with
        /// Amazon Elastic Compute Cloud in a Region that you use, AWS Health provides information about the event
        /// and the affected resources in the account.</p>
        /// </li>
        /// </ul>
        /// <p>You can determine if an event is public or account-specific by using the
        /// <code>eventScopeCode</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_Event.html#AWSHealth-Type-Event-eventScopeCode">eventScopeCode</a>.</p>
        pub fn set_event(mut self, input: std::option::Option<crate::model::Event>) -> Self {
            self.event = input;
            self
        }
        /// <p>The detailed description of the event. Included in the information returned by the
        /// <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventDetails.html">DescribeEventDetails</a> operation.</p>
        pub fn event_description(mut self, input: crate::model::EventDescription) -> Self {
            self.event_description = Some(input);
            self
        }
        /// <p>The detailed description of the event. Included in the information returned by the
        /// <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventDetails.html">DescribeEventDetails</a> operation.</p>
        pub fn set_event_description(
            mut self,
            input: std::option::Option<crate::model::EventDescription>,
        ) -> Self {
            self.event_description = input;
            self
        }
        /// Adds a key-value pair to `event_metadata`.
        ///
        /// To override the contents of this collection use [`set_event_metadata`](Self::set_event_metadata).
        ///
        /// <p>Additional metadata about the event.</p>
        pub fn event_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.event_metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.event_metadata = Some(hash_map);
            self
        }
        /// <p>Additional metadata about the event.</p>
        pub fn set_event_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.event_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationEventDetails`](crate::model::OrganizationEventDetails)
        pub fn build(self) -> crate::model::OrganizationEventDetails {
            crate::model::OrganizationEventDetails {
                aws_account_id: self.aws_account_id,
                event: self.event,
                event_description: self.event_description,
                event_metadata: self.event_metadata,
            }
        }
    }
}
impl OrganizationEventDetails {
    /// Creates a new builder-style object to manufacture [`OrganizationEventDetails`](crate::model::OrganizationEventDetails)
    pub fn builder() -> crate::model::organization_event_details::Builder {
        crate::model::organization_event_details::Builder::default()
    }
}

/// <p>The detailed description of the event. Included in the information returned by the
/// <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventDetails.html">DescribeEventDetails</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventDescription {
    /// <p>The most recent description of the event.</p>
    pub latest_description: std::option::Option<std::string::String>,
}
impl EventDescription {
    /// <p>The most recent description of the event.</p>
    pub fn latest_description(&self) -> std::option::Option<&str> {
        self.latest_description.as_deref()
    }
}
impl std::fmt::Debug for EventDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventDescription");
        formatter.field("latest_description", &self.latest_description);
        formatter.finish()
    }
}
/// See [`EventDescription`](crate::model::EventDescription)
pub mod event_description {
    /// A builder for [`EventDescription`](crate::model::EventDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) latest_description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The most recent description of the event.</p>
        pub fn latest_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.latest_description = Some(input.into());
            self
        }
        /// <p>The most recent description of the event.</p>
        pub fn set_latest_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.latest_description = input;
            self
        }
        /// Consumes the builder and constructs a [`EventDescription`](crate::model::EventDescription)
        pub fn build(self) -> crate::model::EventDescription {
            crate::model::EventDescription {
                latest_description: self.latest_description,
            }
        }
    }
}
impl EventDescription {
    /// Creates a new builder-style object to manufacture [`EventDescription`](crate::model::EventDescription)
    pub fn builder() -> crate::model::event_description::Builder {
        crate::model::event_description::Builder::default()
    }
}

/// <p>The values used to filter results from the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventDetailsForOrganization.html">DescribeEventDetailsForOrganization</a> and <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeAffectedEntitiesForOrganization.html">DescribeAffectedEntitiesForOrganization</a> operations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventAccountFilter {
    /// <p>The unique identifier for the event. The event ARN has the
    /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
    /// </code>
    /// format.</p>
    /// <p>For example, an event ARN might look like the following:</p>
    /// <p>
    /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
    /// </p>
    pub event_arn: std::option::Option<std::string::String>,
    /// <p>The 12-digit AWS account numbers that contains the affected entities.</p>
    pub aws_account_id: std::option::Option<std::string::String>,
}
impl EventAccountFilter {
    /// <p>The unique identifier for the event. The event ARN has the
    /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
    /// </code>
    /// format.</p>
    /// <p>For example, an event ARN might look like the following:</p>
    /// <p>
    /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
    /// </p>
    pub fn event_arn(&self) -> std::option::Option<&str> {
        self.event_arn.as_deref()
    }
    /// <p>The 12-digit AWS account numbers that contains the affected entities.</p>
    pub fn aws_account_id(&self) -> std::option::Option<&str> {
        self.aws_account_id.as_deref()
    }
}
impl std::fmt::Debug for EventAccountFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventAccountFilter");
        formatter.field("event_arn", &self.event_arn);
        formatter.field("aws_account_id", &self.aws_account_id);
        formatter.finish()
    }
}
/// See [`EventAccountFilter`](crate::model::EventAccountFilter)
pub mod event_account_filter {
    /// A builder for [`EventAccountFilter`](crate::model::EventAccountFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_arn: std::option::Option<std::string::String>,
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the event. The event ARN has the
        /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
        /// </code>
        /// format.</p>
        /// <p>For example, an event ARN might look like the following:</p>
        /// <p>
        /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
        /// </p>
        pub fn event_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_arn = Some(input.into());
            self
        }
        /// <p>The unique identifier for the event. The event ARN has the
        /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
        /// </code>
        /// format.</p>
        /// <p>For example, an event ARN might look like the following:</p>
        /// <p>
        /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
        /// </p>
        pub fn set_event_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_arn = input;
            self
        }
        /// <p>The 12-digit AWS account numbers that contains the affected entities.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The 12-digit AWS account numbers that contains the affected entities.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`EventAccountFilter`](crate::model::EventAccountFilter)
        pub fn build(self) -> crate::model::EventAccountFilter {
            crate::model::EventAccountFilter {
                event_arn: self.event_arn,
                aws_account_id: self.aws_account_id,
            }
        }
    }
}
impl EventAccountFilter {
    /// Creates a new builder-style object to manufacture [`EventAccountFilter`](crate::model::EventAccountFilter)
    pub fn builder() -> crate::model::event_account_filter::Builder {
        crate::model::event_account_filter::Builder::default()
    }
}

/// <p>Error information returned when a <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventDetails.html">DescribeEventDetails</a> operation can't find a specified event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventDetailsErrorItem {
    /// <p>The unique identifier for the event. The event ARN has the
    /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
    /// </code>
    /// format.</p>
    /// <p>For example, an event ARN might look like the following:</p>
    /// <p>
    /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
    /// </p>
    pub event_arn: std::option::Option<std::string::String>,
    /// <p>The name of the error.</p>
    pub error_name: std::option::Option<std::string::String>,
    /// <p>A message that describes the error.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl EventDetailsErrorItem {
    /// <p>The unique identifier for the event. The event ARN has the
    /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
    /// </code>
    /// format.</p>
    /// <p>For example, an event ARN might look like the following:</p>
    /// <p>
    /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
    /// </p>
    pub fn event_arn(&self) -> std::option::Option<&str> {
        self.event_arn.as_deref()
    }
    /// <p>The name of the error.</p>
    pub fn error_name(&self) -> std::option::Option<&str> {
        self.error_name.as_deref()
    }
    /// <p>A message that describes the error.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for EventDetailsErrorItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventDetailsErrorItem");
        formatter.field("event_arn", &self.event_arn);
        formatter.field("error_name", &self.error_name);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`EventDetailsErrorItem`](crate::model::EventDetailsErrorItem)
pub mod event_details_error_item {
    /// A builder for [`EventDetailsErrorItem`](crate::model::EventDetailsErrorItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_arn: std::option::Option<std::string::String>,
        pub(crate) error_name: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the event. The event ARN has the
        /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
        /// </code>
        /// format.</p>
        /// <p>For example, an event ARN might look like the following:</p>
        /// <p>
        /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
        /// </p>
        pub fn event_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_arn = Some(input.into());
            self
        }
        /// <p>The unique identifier for the event. The event ARN has the
        /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
        /// </code>
        /// format.</p>
        /// <p>For example, an event ARN might look like the following:</p>
        /// <p>
        /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
        /// </p>
        pub fn set_event_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_arn = input;
            self
        }
        /// <p>The name of the error.</p>
        pub fn error_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_name = Some(input.into());
            self
        }
        /// <p>The name of the error.</p>
        pub fn set_error_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_name = input;
            self
        }
        /// <p>A message that describes the error.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>A message that describes the error.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`EventDetailsErrorItem`](crate::model::EventDetailsErrorItem)
        pub fn build(self) -> crate::model::EventDetailsErrorItem {
            crate::model::EventDetailsErrorItem {
                event_arn: self.event_arn,
                error_name: self.error_name,
                error_message: self.error_message,
            }
        }
    }
}
impl EventDetailsErrorItem {
    /// Creates a new builder-style object to manufacture [`EventDetailsErrorItem`](crate::model::EventDetailsErrorItem)
    pub fn builder() -> crate::model::event_details_error_item::Builder {
        crate::model::event_details_error_item::Builder::default()
    }
}

/// <p>Detailed information about an event. A combination of an <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_Event.html">Event</a> object, an <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EventDescription.html">EventDescription</a> object, and additional metadata about the event. Returned by
/// the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventDetails.html">DescribeEventDetails</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventDetails {
    /// <p>Summary information about the event.</p>
    pub event: std::option::Option<crate::model::Event>,
    /// <p>The most recent description of the event.</p>
    pub event_description: std::option::Option<crate::model::EventDescription>,
    /// <p>Additional metadata about the event.</p>
    pub event_metadata:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl EventDetails {
    /// <p>Summary information about the event.</p>
    pub fn event(&self) -> std::option::Option<&crate::model::Event> {
        self.event.as_ref()
    }
    /// <p>The most recent description of the event.</p>
    pub fn event_description(&self) -> std::option::Option<&crate::model::EventDescription> {
        self.event_description.as_ref()
    }
    /// <p>Additional metadata about the event.</p>
    pub fn event_metadata(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.event_metadata.as_ref()
    }
}
impl std::fmt::Debug for EventDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventDetails");
        formatter.field("event", &self.event);
        formatter.field("event_description", &self.event_description);
        formatter.field("event_metadata", &self.event_metadata);
        formatter.finish()
    }
}
/// See [`EventDetails`](crate::model::EventDetails)
pub mod event_details {
    /// A builder for [`EventDetails`](crate::model::EventDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event: std::option::Option<crate::model::Event>,
        pub(crate) event_description: std::option::Option<crate::model::EventDescription>,
        pub(crate) event_metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>Summary information about the event.</p>
        pub fn event(mut self, input: crate::model::Event) -> Self {
            self.event = Some(input);
            self
        }
        /// <p>Summary information about the event.</p>
        pub fn set_event(mut self, input: std::option::Option<crate::model::Event>) -> Self {
            self.event = input;
            self
        }
        /// <p>The most recent description of the event.</p>
        pub fn event_description(mut self, input: crate::model::EventDescription) -> Self {
            self.event_description = Some(input);
            self
        }
        /// <p>The most recent description of the event.</p>
        pub fn set_event_description(
            mut self,
            input: std::option::Option<crate::model::EventDescription>,
        ) -> Self {
            self.event_description = input;
            self
        }
        /// Adds a key-value pair to `event_metadata`.
        ///
        /// To override the contents of this collection use [`set_event_metadata`](Self::set_event_metadata).
        ///
        /// <p>Additional metadata about the event.</p>
        pub fn event_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.event_metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.event_metadata = Some(hash_map);
            self
        }
        /// <p>Additional metadata about the event.</p>
        pub fn set_event_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.event_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`EventDetails`](crate::model::EventDetails)
        pub fn build(self) -> crate::model::EventDetails {
            crate::model::EventDetails {
                event: self.event,
                event_description: self.event_description,
                event_metadata: self.event_metadata,
            }
        }
    }
}
impl EventDetails {
    /// Creates a new builder-style object to manufacture [`EventDetails`](crate::model::EventDetails)
    pub fn builder() -> crate::model::event_details::Builder {
        crate::model::event_details::Builder::default()
    }
}

/// <p>The number of events of each issue type. Returned by the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEventAggregates.html">DescribeEventAggregates</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventAggregate {
    /// <p>The issue type for the associated count.</p>
    pub aggregate_value: std::option::Option<std::string::String>,
    /// <p>The number of events of the associated issue type.</p>
    pub count: i32,
}
impl EventAggregate {
    /// <p>The issue type for the associated count.</p>
    pub fn aggregate_value(&self) -> std::option::Option<&str> {
        self.aggregate_value.as_deref()
    }
    /// <p>The number of events of the associated issue type.</p>
    pub fn count(&self) -> i32 {
        self.count
    }
}
impl std::fmt::Debug for EventAggregate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventAggregate");
        formatter.field("aggregate_value", &self.aggregate_value);
        formatter.field("count", &self.count);
        formatter.finish()
    }
}
/// See [`EventAggregate`](crate::model::EventAggregate)
pub mod event_aggregate {
    /// A builder for [`EventAggregate`](crate::model::EventAggregate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aggregate_value: std::option::Option<std::string::String>,
        pub(crate) count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The issue type for the associated count.</p>
        pub fn aggregate_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.aggregate_value = Some(input.into());
            self
        }
        /// <p>The issue type for the associated count.</p>
        pub fn set_aggregate_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aggregate_value = input;
            self
        }
        /// <p>The number of events of the associated issue type.</p>
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>The number of events of the associated issue type.</p>
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// Consumes the builder and constructs a [`EventAggregate`](crate::model::EventAggregate)
        pub fn build(self) -> crate::model::EventAggregate {
            crate::model::EventAggregate {
                aggregate_value: self.aggregate_value,
                count: self.count.unwrap_or_default(),
            }
        }
    }
}
impl EventAggregate {
    /// Creates a new builder-style object to manufacture [`EventAggregate`](crate::model::EventAggregate)
    pub fn builder() -> crate::model::event_aggregate::Builder {
        crate::model::event_aggregate::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventAggregateField {
    #[allow(missing_docs)] // documentation missing in model
    EventTypeCategory,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventAggregateField {
    fn from(s: &str) -> Self {
        match s {
            "eventTypeCategory" => EventAggregateField::EventTypeCategory,
            other => EventAggregateField::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventAggregateField {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventAggregateField::from(s))
    }
}
impl EventAggregateField {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventAggregateField::EventTypeCategory => "eventTypeCategory",
            EventAggregateField::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["eventTypeCategory"]
    }
}
impl AsRef<str> for EventAggregateField {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The number of entities that are affected by one or more events. Returned by the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEntityAggregates.html">DescribeEntityAggregates</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntityAggregate {
    /// <p>The unique identifier for the event. The event ARN has the
    /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
    /// </code>
    /// format.</p>
    /// <p>For example, an event ARN might look like the following:</p>
    /// <p>
    /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
    /// </p>
    pub event_arn: std::option::Option<std::string::String>,
    /// <p>The number of entities that match the criteria for the specified events.</p>
    pub count: i32,
}
impl EntityAggregate {
    /// <p>The unique identifier for the event. The event ARN has the
    /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
    /// </code>
    /// format.</p>
    /// <p>For example, an event ARN might look like the following:</p>
    /// <p>
    /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
    /// </p>
    pub fn event_arn(&self) -> std::option::Option<&str> {
        self.event_arn.as_deref()
    }
    /// <p>The number of entities that match the criteria for the specified events.</p>
    pub fn count(&self) -> i32 {
        self.count
    }
}
impl std::fmt::Debug for EntityAggregate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntityAggregate");
        formatter.field("event_arn", &self.event_arn);
        formatter.field("count", &self.count);
        formatter.finish()
    }
}
/// See [`EntityAggregate`](crate::model::EntityAggregate)
pub mod entity_aggregate {
    /// A builder for [`EntityAggregate`](crate::model::EntityAggregate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_arn: std::option::Option<std::string::String>,
        pub(crate) count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique identifier for the event. The event ARN has the
        /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
        /// </code>
        /// format.</p>
        /// <p>For example, an event ARN might look like the following:</p>
        /// <p>
        /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
        /// </p>
        pub fn event_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_arn = Some(input.into());
            self
        }
        /// <p>The unique identifier for the event. The event ARN has the
        /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
        /// </code>
        /// format.</p>
        /// <p>For example, an event ARN might look like the following:</p>
        /// <p>
        /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
        /// </p>
        pub fn set_event_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_arn = input;
            self
        }
        /// <p>The number of entities that match the criteria for the specified events.</p>
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>The number of entities that match the criteria for the specified events.</p>
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// Consumes the builder and constructs a [`EntityAggregate`](crate::model::EntityAggregate)
        pub fn build(self) -> crate::model::EntityAggregate {
            crate::model::EntityAggregate {
                event_arn: self.event_arn,
                count: self.count.unwrap_or_default(),
            }
        }
    }
}
impl EntityAggregate {
    /// Creates a new builder-style object to manufacture [`EntityAggregate`](crate::model::EntityAggregate)
    pub fn builder() -> crate::model::entity_aggregate::Builder {
        crate::model::entity_aggregate::Builder::default()
    }
}

/// <p>Error information returned when a <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeAffectedEntitiesForOrganization.html">DescribeAffectedEntitiesForOrganization</a> operation can't find or process a
/// specific entity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrganizationAffectedEntitiesErrorItem {
    /// <p>The 12-digit AWS account numbers that contains the affected entities.</p>
    pub aws_account_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the event. The event ARN has the
    /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
    /// </code>
    /// format.</p>
    /// <p>For example, an event ARN might look like the following:</p>
    /// <p>
    /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
    /// </p>
    pub event_arn: std::option::Option<std::string::String>,
    /// <p>The name of the error.</p>
    pub error_name: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the event type. The format is
    /// <code>AWS_SERVICE_DESCRIPTION</code>. For example,
    /// <code>AWS_EC2_SYSTEM_MAINTENANCE_EVENT</code>.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl OrganizationAffectedEntitiesErrorItem {
    /// <p>The 12-digit AWS account numbers that contains the affected entities.</p>
    pub fn aws_account_id(&self) -> std::option::Option<&str> {
        self.aws_account_id.as_deref()
    }
    /// <p>The unique identifier for the event. The event ARN has the
    /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
    /// </code>
    /// format.</p>
    /// <p>For example, an event ARN might look like the following:</p>
    /// <p>
    /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
    /// </p>
    pub fn event_arn(&self) -> std::option::Option<&str> {
        self.event_arn.as_deref()
    }
    /// <p>The name of the error.</p>
    pub fn error_name(&self) -> std::option::Option<&str> {
        self.error_name.as_deref()
    }
    /// <p>The unique identifier for the event type. The format is
    /// <code>AWS_SERVICE_DESCRIPTION</code>. For example,
    /// <code>AWS_EC2_SYSTEM_MAINTENANCE_EVENT</code>.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for OrganizationAffectedEntitiesErrorItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrganizationAffectedEntitiesErrorItem");
        formatter.field("aws_account_id", &self.aws_account_id);
        formatter.field("event_arn", &self.event_arn);
        formatter.field("error_name", &self.error_name);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`OrganizationAffectedEntitiesErrorItem`](crate::model::OrganizationAffectedEntitiesErrorItem)
pub mod organization_affected_entities_error_item {
    /// A builder for [`OrganizationAffectedEntitiesErrorItem`](crate::model::OrganizationAffectedEntitiesErrorItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) event_arn: std::option::Option<std::string::String>,
        pub(crate) error_name: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The 12-digit AWS account numbers that contains the affected entities.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The 12-digit AWS account numbers that contains the affected entities.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The unique identifier for the event. The event ARN has the
        /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
        /// </code>
        /// format.</p>
        /// <p>For example, an event ARN might look like the following:</p>
        /// <p>
        /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
        /// </p>
        pub fn event_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_arn = Some(input.into());
            self
        }
        /// <p>The unique identifier for the event. The event ARN has the
        /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
        /// </code>
        /// format.</p>
        /// <p>For example, an event ARN might look like the following:</p>
        /// <p>
        /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
        /// </p>
        pub fn set_event_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_arn = input;
            self
        }
        /// <p>The name of the error.</p>
        pub fn error_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_name = Some(input.into());
            self
        }
        /// <p>The name of the error.</p>
        pub fn set_error_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_name = input;
            self
        }
        /// <p>The unique identifier for the event type. The format is
        /// <code>AWS_SERVICE_DESCRIPTION</code>. For example,
        /// <code>AWS_EC2_SYSTEM_MAINTENANCE_EVENT</code>.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The unique identifier for the event type. The format is
        /// <code>AWS_SERVICE_DESCRIPTION</code>. For example,
        /// <code>AWS_EC2_SYSTEM_MAINTENANCE_EVENT</code>.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`OrganizationAffectedEntitiesErrorItem`](crate::model::OrganizationAffectedEntitiesErrorItem)
        pub fn build(self) -> crate::model::OrganizationAffectedEntitiesErrorItem {
            crate::model::OrganizationAffectedEntitiesErrorItem {
                aws_account_id: self.aws_account_id,
                event_arn: self.event_arn,
                error_name: self.error_name,
                error_message: self.error_message,
            }
        }
    }
}
impl OrganizationAffectedEntitiesErrorItem {
    /// Creates a new builder-style object to manufacture [`OrganizationAffectedEntitiesErrorItem`](crate::model::OrganizationAffectedEntitiesErrorItem)
    pub fn builder() -> crate::model::organization_affected_entities_error_item::Builder {
        crate::model::organization_affected_entities_error_item::Builder::default()
    }
}

/// <p>Information about an entity that is affected by a Health event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AffectedEntity {
    /// <p>The unique identifier for the entity. Format: <code>arn:aws:health:<i>entity-region</i>:<i>aws-account</i>:entity/<i>entity-id</i>
    /// </code>. Example: <code>arn:aws:health:us-east-1:111222333444:entity/AVh5GGT7ul1arKr1sE1K</code>
    /// </p>
    pub entity_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the event. The event ARN has the
    /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
    /// </code>
    /// format.</p>
    /// <p>For example, an event ARN might look like the following:</p>
    /// <p>
    /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
    /// </p>
    pub event_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the affected entity.</p>
    pub entity_value: std::option::Option<std::string::String>,
    /// <p>The URL of the affected entity.</p>
    pub entity_url: std::option::Option<std::string::String>,
    /// <p>The 12-digit AWS account number that contains the affected entity.</p>
    pub aws_account_id: std::option::Option<std::string::String>,
    /// <p>The most recent time that the entity was updated.</p>
    pub last_updated_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The most recent status of the entity affected by the event. The possible values are
    /// <code>IMPAIRED</code>, <code>UNIMPAIRED</code>, and <code>UNKNOWN</code>.</p>
    pub status_code: std::option::Option<crate::model::EntityStatusCode>,
    /// <p>A map of entity tags attached to the affected entity.</p>
    /// <note>
    /// <p>Currently, the <code>tags</code> property isn't supported.</p>
    /// </note>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl AffectedEntity {
    /// <p>The unique identifier for the entity. Format: <code>arn:aws:health:<i>entity-region</i>:<i>aws-account</i>:entity/<i>entity-id</i>
    /// </code>. Example: <code>arn:aws:health:us-east-1:111222333444:entity/AVh5GGT7ul1arKr1sE1K</code>
    /// </p>
    pub fn entity_arn(&self) -> std::option::Option<&str> {
        self.entity_arn.as_deref()
    }
    /// <p>The unique identifier for the event. The event ARN has the
    /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
    /// </code>
    /// format.</p>
    /// <p>For example, an event ARN might look like the following:</p>
    /// <p>
    /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
    /// </p>
    pub fn event_arn(&self) -> std::option::Option<&str> {
        self.event_arn.as_deref()
    }
    /// <p>The ID of the affected entity.</p>
    pub fn entity_value(&self) -> std::option::Option<&str> {
        self.entity_value.as_deref()
    }
    /// <p>The URL of the affected entity.</p>
    pub fn entity_url(&self) -> std::option::Option<&str> {
        self.entity_url.as_deref()
    }
    /// <p>The 12-digit AWS account number that contains the affected entity.</p>
    pub fn aws_account_id(&self) -> std::option::Option<&str> {
        self.aws_account_id.as_deref()
    }
    /// <p>The most recent time that the entity was updated.</p>
    pub fn last_updated_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_time.as_ref()
    }
    /// <p>The most recent status of the entity affected by the event. The possible values are
    /// <code>IMPAIRED</code>, <code>UNIMPAIRED</code>, and <code>UNKNOWN</code>.</p>
    pub fn status_code(&self) -> std::option::Option<&crate::model::EntityStatusCode> {
        self.status_code.as_ref()
    }
    /// <p>A map of entity tags attached to the affected entity.</p>
    /// <note>
    /// <p>Currently, the <code>tags</code> property isn't supported.</p>
    /// </note>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for AffectedEntity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AffectedEntity");
        formatter.field("entity_arn", &self.entity_arn);
        formatter.field("event_arn", &self.event_arn);
        formatter.field("entity_value", &self.entity_value);
        formatter.field("entity_url", &self.entity_url);
        formatter.field("aws_account_id", &self.aws_account_id);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.field("status_code", &self.status_code);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`AffectedEntity`](crate::model::AffectedEntity)
pub mod affected_entity {
    /// A builder for [`AffectedEntity`](crate::model::AffectedEntity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entity_arn: std::option::Option<std::string::String>,
        pub(crate) event_arn: std::option::Option<std::string::String>,
        pub(crate) entity_value: std::option::Option<std::string::String>,
        pub(crate) entity_url: std::option::Option<std::string::String>,
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) last_updated_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status_code: std::option::Option<crate::model::EntityStatusCode>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The unique identifier for the entity. Format: <code>arn:aws:health:<i>entity-region</i>:<i>aws-account</i>:entity/<i>entity-id</i>
        /// </code>. Example: <code>arn:aws:health:us-east-1:111222333444:entity/AVh5GGT7ul1arKr1sE1K</code>
        /// </p>
        pub fn entity_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_arn = Some(input.into());
            self
        }
        /// <p>The unique identifier for the entity. Format: <code>arn:aws:health:<i>entity-region</i>:<i>aws-account</i>:entity/<i>entity-id</i>
        /// </code>. Example: <code>arn:aws:health:us-east-1:111222333444:entity/AVh5GGT7ul1arKr1sE1K</code>
        /// </p>
        pub fn set_entity_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_arn = input;
            self
        }
        /// <p>The unique identifier for the event. The event ARN has the
        /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
        /// </code>
        /// format.</p>
        /// <p>For example, an event ARN might look like the following:</p>
        /// <p>
        /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
        /// </p>
        pub fn event_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_arn = Some(input.into());
            self
        }
        /// <p>The unique identifier for the event. The event ARN has the
        /// <code>arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i>
        /// </code>
        /// format.</p>
        /// <p>For example, an event ARN might look like the following:</p>
        /// <p>
        /// <code>arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456</code>
        /// </p>
        pub fn set_event_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_arn = input;
            self
        }
        /// <p>The ID of the affected entity.</p>
        pub fn entity_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_value = Some(input.into());
            self
        }
        /// <p>The ID of the affected entity.</p>
        pub fn set_entity_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_value = input;
            self
        }
        /// <p>The URL of the affected entity.</p>
        pub fn entity_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_url = Some(input.into());
            self
        }
        /// <p>The URL of the affected entity.</p>
        pub fn set_entity_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_url = input;
            self
        }
        /// <p>The 12-digit AWS account number that contains the affected entity.</p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p>The 12-digit AWS account number that contains the affected entity.</p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p>The most recent time that the entity was updated.</p>
        pub fn last_updated_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>The most recent time that the entity was updated.</p>
        pub fn set_last_updated_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_time = input;
            self
        }
        /// <p>The most recent status of the entity affected by the event. The possible values are
        /// <code>IMPAIRED</code>, <code>UNIMPAIRED</code>, and <code>UNKNOWN</code>.</p>
        pub fn status_code(mut self, input: crate::model::EntityStatusCode) -> Self {
            self.status_code = Some(input);
            self
        }
        /// <p>The most recent status of the entity affected by the event. The possible values are
        /// <code>IMPAIRED</code>, <code>UNIMPAIRED</code>, and <code>UNKNOWN</code>.</p>
        pub fn set_status_code(
            mut self,
            input: std::option::Option<crate::model::EntityStatusCode>,
        ) -> Self {
            self.status_code = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map of entity tags attached to the affected entity.</p>
        /// <note>
        /// <p>Currently, the <code>tags</code> property isn't supported.</p>
        /// </note>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A map of entity tags attached to the affected entity.</p>
        /// <note>
        /// <p>Currently, the <code>tags</code> property isn't supported.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`AffectedEntity`](crate::model::AffectedEntity)
        pub fn build(self) -> crate::model::AffectedEntity {
            crate::model::AffectedEntity {
                entity_arn: self.entity_arn,
                event_arn: self.event_arn,
                entity_value: self.entity_value,
                entity_url: self.entity_url,
                aws_account_id: self.aws_account_id,
                last_updated_time: self.last_updated_time,
                status_code: self.status_code,
                tags: self.tags,
            }
        }
    }
}
impl AffectedEntity {
    /// Creates a new builder-style object to manufacture [`AffectedEntity`](crate::model::AffectedEntity)
    pub fn builder() -> crate::model::affected_entity::Builder {
        crate::model::affected_entity::Builder::default()
    }
}

/// _Note: `EntityStatusCode::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EntityStatusCode {
    #[allow(missing_docs)] // documentation missing in model
    Impaired,
    #[allow(missing_docs)] // documentation missing in model
    Unimpaired,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EntityStatusCode {
    fn from(s: &str) -> Self {
        match s {
            "IMPAIRED" => EntityStatusCode::Impaired,
            "UNIMPAIRED" => EntityStatusCode::Unimpaired,
            "UNKNOWN" => EntityStatusCode::UnknownValue,
            other => EntityStatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EntityStatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EntityStatusCode::from(s))
    }
}
impl EntityStatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EntityStatusCode::Impaired => "IMPAIRED",
            EntityStatusCode::Unimpaired => "UNIMPAIRED",
            EntityStatusCode::UnknownValue => "UNKNOWN",
            EntityStatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IMPAIRED", "UNIMPAIRED", "UNKNOWN"]
    }
}
impl AsRef<str> for EntityStatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The values to use to filter results from the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EntityFilter.html">EntityFilter</a>
/// operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntityFilter {
    /// <p>A list of event ARNs (unique identifiers). For example: <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
    /// </p>
    pub event_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of entity ARNs (unique identifiers).</p>
    pub entity_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of IDs for affected entities.</p>
    pub entity_values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of the most recent dates and times that the entity was updated.</p>
    pub last_updated_times: std::option::Option<std::vec::Vec<crate::model::DateTimeRange>>,
    /// <p>A map of entity tags attached to the affected entity.</p>
    /// <note>
    /// <p>Currently, the <code>tags</code> property isn't supported.</p>
    /// </note>
    pub tags: std::option::Option<
        std::vec::Vec<std::collections::HashMap<std::string::String, std::string::String>>,
    >,
    /// <p>A list of entity status codes (<code>IMPAIRED</code>, <code>UNIMPAIRED</code>, or
    /// <code>UNKNOWN</code>).</p>
    pub status_codes: std::option::Option<std::vec::Vec<crate::model::EntityStatusCode>>,
}
impl EntityFilter {
    /// <p>A list of event ARNs (unique identifiers). For example: <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
    /// </p>
    pub fn event_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.event_arns.as_deref()
    }
    /// <p>A list of entity ARNs (unique identifiers).</p>
    pub fn entity_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.entity_arns.as_deref()
    }
    /// <p>A list of IDs for affected entities.</p>
    pub fn entity_values(&self) -> std::option::Option<&[std::string::String]> {
        self.entity_values.as_deref()
    }
    /// <p>A list of the most recent dates and times that the entity was updated.</p>
    pub fn last_updated_times(&self) -> std::option::Option<&[crate::model::DateTimeRange]> {
        self.last_updated_times.as_deref()
    }
    /// <p>A map of entity tags attached to the affected entity.</p>
    /// <note>
    /// <p>Currently, the <code>tags</code> property isn't supported.</p>
    /// </note>
    pub fn tags(
        &self,
    ) -> std::option::Option<&[std::collections::HashMap<std::string::String, std::string::String>]>
    {
        self.tags.as_deref()
    }
    /// <p>A list of entity status codes (<code>IMPAIRED</code>, <code>UNIMPAIRED</code>, or
    /// <code>UNKNOWN</code>).</p>
    pub fn status_codes(&self) -> std::option::Option<&[crate::model::EntityStatusCode]> {
        self.status_codes.as_deref()
    }
}
impl std::fmt::Debug for EntityFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntityFilter");
        formatter.field("event_arns", &self.event_arns);
        formatter.field("entity_arns", &self.entity_arns);
        formatter.field("entity_values", &self.entity_values);
        formatter.field("last_updated_times", &self.last_updated_times);
        formatter.field("tags", &self.tags);
        formatter.field("status_codes", &self.status_codes);
        formatter.finish()
    }
}
/// See [`EntityFilter`](crate::model::EntityFilter)
pub mod entity_filter {
    /// A builder for [`EntityFilter`](crate::model::EntityFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) entity_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) entity_values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) last_updated_times:
            std::option::Option<std::vec::Vec<crate::model::DateTimeRange>>,
        pub(crate) tags: std::option::Option<
            std::vec::Vec<std::collections::HashMap<std::string::String, std::string::String>>,
        >,
        pub(crate) status_codes: std::option::Option<std::vec::Vec<crate::model::EntityStatusCode>>,
    }
    impl Builder {
        /// Appends an item to `event_arns`.
        ///
        /// To override the contents of this collection use [`set_event_arns`](Self::set_event_arns).
        ///
        /// <p>A list of event ARNs (unique identifiers). For example: <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
        /// </p>
        pub fn event_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_arns.unwrap_or_default();
            v.push(input.into());
            self.event_arns = Some(v);
            self
        }
        /// <p>A list of event ARNs (unique identifiers). For example: <code>"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"</code>
        /// </p>
        pub fn set_event_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_arns = input;
            self
        }
        /// Appends an item to `entity_arns`.
        ///
        /// To override the contents of this collection use [`set_entity_arns`](Self::set_entity_arns).
        ///
        /// <p>A list of entity ARNs (unique identifiers).</p>
        pub fn entity_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.entity_arns.unwrap_or_default();
            v.push(input.into());
            self.entity_arns = Some(v);
            self
        }
        /// <p>A list of entity ARNs (unique identifiers).</p>
        pub fn set_entity_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.entity_arns = input;
            self
        }
        /// Appends an item to `entity_values`.
        ///
        /// To override the contents of this collection use [`set_entity_values`](Self::set_entity_values).
        ///
        /// <p>A list of IDs for affected entities.</p>
        pub fn entity_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.entity_values.unwrap_or_default();
            v.push(input.into());
            self.entity_values = Some(v);
            self
        }
        /// <p>A list of IDs for affected entities.</p>
        pub fn set_entity_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.entity_values = input;
            self
        }
        /// Appends an item to `last_updated_times`.
        ///
        /// To override the contents of this collection use [`set_last_updated_times`](Self::set_last_updated_times).
        ///
        /// <p>A list of the most recent dates and times that the entity was updated.</p>
        pub fn last_updated_times(mut self, input: impl Into<crate::model::DateTimeRange>) -> Self {
            let mut v = self.last_updated_times.unwrap_or_default();
            v.push(input.into());
            self.last_updated_times = Some(v);
            self
        }
        /// <p>A list of the most recent dates and times that the entity was updated.</p>
        pub fn set_last_updated_times(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DateTimeRange>>,
        ) -> Self {
            self.last_updated_times = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map of entity tags attached to the affected entity.</p>
        /// <note>
        /// <p>Currently, the <code>tags</code> property isn't supported.</p>
        /// </note>
        pub fn tags(
            mut self,
            input: impl Into<std::collections::HashMap<std::string::String, std::string::String>>,
        ) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A map of entity tags attached to the affected entity.</p>
        /// <note>
        /// <p>Currently, the <code>tags</code> property isn't supported.</p>
        /// </note>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::vec::Vec<std::collections::HashMap<std::string::String, std::string::String>>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `status_codes`.
        ///
        /// To override the contents of this collection use [`set_status_codes`](Self::set_status_codes).
        ///
        /// <p>A list of entity status codes (<code>IMPAIRED</code>, <code>UNIMPAIRED</code>, or
        /// <code>UNKNOWN</code>).</p>
        pub fn status_codes(mut self, input: impl Into<crate::model::EntityStatusCode>) -> Self {
            let mut v = self.status_codes.unwrap_or_default();
            v.push(input.into());
            self.status_codes = Some(v);
            self
        }
        /// <p>A list of entity status codes (<code>IMPAIRED</code>, <code>UNIMPAIRED</code>, or
        /// <code>UNKNOWN</code>).</p>
        pub fn set_status_codes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EntityStatusCode>>,
        ) -> Self {
            self.status_codes = input;
            self
        }
        /// Consumes the builder and constructs a [`EntityFilter`](crate::model::EntityFilter)
        pub fn build(self) -> crate::model::EntityFilter {
            crate::model::EntityFilter {
                event_arns: self.event_arns,
                entity_arns: self.entity_arns,
                entity_values: self.entity_values,
                last_updated_times: self.last_updated_times,
                tags: self.tags,
                status_codes: self.status_codes,
            }
        }
    }
}
impl EntityFilter {
    /// Creates a new builder-style object to manufacture [`EntityFilter`](crate::model::EntityFilter)
    pub fn builder() -> crate::model::entity_filter::Builder {
        crate::model::entity_filter::Builder::default()
    }
}
