// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `DescribeAffectedAccountsForOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAffectedAccountsForOrganizationError {
    /// Kind of error that occurred.
    pub kind: DescribeAffectedAccountsForOrganizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAffectedAccountsForOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAffectedAccountsForOrganizationErrorKind {
    /// <p>The specified pagination token (<code>nextToken</code>) is not valid.</p>
    InvalidPaginationToken(crate::error::InvalidPaginationToken),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAffectedAccountsForOrganizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAffectedAccountsForOrganizationErrorKind::InvalidPaginationToken(_inner) => {
                _inner.fmt(f)
            }
            DescribeAffectedAccountsForOrganizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAffectedAccountsForOrganizationError {
    fn code(&self) -> Option<&str> {
        DescribeAffectedAccountsForOrganizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAffectedAccountsForOrganizationError {
    /// Creates a new `DescribeAffectedAccountsForOrganizationError`.
    pub fn new(
        kind: DescribeAffectedAccountsForOrganizationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAffectedAccountsForOrganizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAffectedAccountsForOrganizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAffectedAccountsForOrganizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAffectedAccountsForOrganizationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeAffectedAccountsForOrganizationErrorKind::InvalidPaginationToken`.
    pub fn is_invalid_pagination_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAffectedAccountsForOrganizationErrorKind::InvalidPaginationToken(_)
        )
    }
}
impl std::error::Error for DescribeAffectedAccountsForOrganizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAffectedAccountsForOrganizationErrorKind::InvalidPaginationToken(_inner) => {
                Some(_inner)
            }
            DescribeAffectedAccountsForOrganizationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeAffectedEntities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAffectedEntitiesError {
    /// Kind of error that occurred.
    pub kind: DescribeAffectedEntitiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAffectedEntities` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAffectedEntitiesErrorKind {
    /// <p>The specified pagination token (<code>nextToken</code>) is not valid.</p>
    InvalidPaginationToken(crate::error::InvalidPaginationToken),
    /// <p>The specified locale is not supported.</p>
    UnsupportedLocale(crate::error::UnsupportedLocale),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAffectedEntitiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAffectedEntitiesErrorKind::InvalidPaginationToken(_inner) => _inner.fmt(f),
            DescribeAffectedEntitiesErrorKind::UnsupportedLocale(_inner) => _inner.fmt(f),
            DescribeAffectedEntitiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAffectedEntitiesError {
    fn code(&self) -> Option<&str> {
        DescribeAffectedEntitiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAffectedEntitiesError {
    /// Creates a new `DescribeAffectedEntitiesError`.
    pub fn new(kind: DescribeAffectedEntitiesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAffectedEntitiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAffectedEntitiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAffectedEntitiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAffectedEntitiesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeAffectedEntitiesErrorKind::InvalidPaginationToken`.
    pub fn is_invalid_pagination_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAffectedEntitiesErrorKind::InvalidPaginationToken(_)
        )
    }
    /// Returns true if the error kind is `DescribeAffectedEntitiesErrorKind::UnsupportedLocale`.
    pub fn is_unsupported_locale(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAffectedEntitiesErrorKind::UnsupportedLocale(_)
        )
    }
}
impl std::error::Error for DescribeAffectedEntitiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAffectedEntitiesErrorKind::InvalidPaginationToken(_inner) => Some(_inner),
            DescribeAffectedEntitiesErrorKind::UnsupportedLocale(_inner) => Some(_inner),
            DescribeAffectedEntitiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAffectedEntitiesForOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAffectedEntitiesForOrganizationError {
    /// Kind of error that occurred.
    pub kind: DescribeAffectedEntitiesForOrganizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAffectedEntitiesForOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAffectedEntitiesForOrganizationErrorKind {
    /// <p>The specified pagination token (<code>nextToken</code>) is not valid.</p>
    InvalidPaginationToken(crate::error::InvalidPaginationToken),
    /// <p>The specified locale is not supported.</p>
    UnsupportedLocale(crate::error::UnsupportedLocale),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAffectedEntitiesForOrganizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAffectedEntitiesForOrganizationErrorKind::InvalidPaginationToken(_inner) => {
                _inner.fmt(f)
            }
            DescribeAffectedEntitiesForOrganizationErrorKind::UnsupportedLocale(_inner) => {
                _inner.fmt(f)
            }
            DescribeAffectedEntitiesForOrganizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAffectedEntitiesForOrganizationError {
    fn code(&self) -> Option<&str> {
        DescribeAffectedEntitiesForOrganizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAffectedEntitiesForOrganizationError {
    /// Creates a new `DescribeAffectedEntitiesForOrganizationError`.
    pub fn new(
        kind: DescribeAffectedEntitiesForOrganizationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAffectedEntitiesForOrganizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAffectedEntitiesForOrganizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAffectedEntitiesForOrganizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAffectedEntitiesForOrganizationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeAffectedEntitiesForOrganizationErrorKind::InvalidPaginationToken`.
    pub fn is_invalid_pagination_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAffectedEntitiesForOrganizationErrorKind::InvalidPaginationToken(_)
        )
    }
    /// Returns true if the error kind is `DescribeAffectedEntitiesForOrganizationErrorKind::UnsupportedLocale`.
    pub fn is_unsupported_locale(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAffectedEntitiesForOrganizationErrorKind::UnsupportedLocale(_)
        )
    }
}
impl std::error::Error for DescribeAffectedEntitiesForOrganizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAffectedEntitiesForOrganizationErrorKind::InvalidPaginationToken(_inner) => {
                Some(_inner)
            }
            DescribeAffectedEntitiesForOrganizationErrorKind::UnsupportedLocale(_inner) => {
                Some(_inner)
            }
            DescribeAffectedEntitiesForOrganizationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeEntityAggregates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEntityAggregatesError {
    /// Kind of error that occurred.
    pub kind: DescribeEntityAggregatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEntityAggregates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEntityAggregatesErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEntityAggregatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEntityAggregatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEntityAggregatesError {
    fn code(&self) -> Option<&str> {
        DescribeEntityAggregatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEntityAggregatesError {
    /// Creates a new `DescribeEntityAggregatesError`.
    pub fn new(kind: DescribeEntityAggregatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEntityAggregatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEntityAggregatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEntityAggregatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEntityAggregatesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeEntityAggregatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEntityAggregatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEventAggregates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEventAggregatesError {
    /// Kind of error that occurred.
    pub kind: DescribeEventAggregatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEventAggregates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEventAggregatesErrorKind {
    /// <p>The specified pagination token (<code>nextToken</code>) is not valid.</p>
    InvalidPaginationToken(crate::error::InvalidPaginationToken),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEventAggregatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEventAggregatesErrorKind::InvalidPaginationToken(_inner) => _inner.fmt(f),
            DescribeEventAggregatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEventAggregatesError {
    fn code(&self) -> Option<&str> {
        DescribeEventAggregatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEventAggregatesError {
    /// Creates a new `DescribeEventAggregatesError`.
    pub fn new(kind: DescribeEventAggregatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEventAggregatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEventAggregatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEventAggregatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEventAggregatesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeEventAggregatesErrorKind::InvalidPaginationToken`.
    pub fn is_invalid_pagination_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventAggregatesErrorKind::InvalidPaginationToken(_)
        )
    }
}
impl std::error::Error for DescribeEventAggregatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEventAggregatesErrorKind::InvalidPaginationToken(_inner) => Some(_inner),
            DescribeEventAggregatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEventDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEventDetailsError {
    /// Kind of error that occurred.
    pub kind: DescribeEventDetailsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEventDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEventDetailsErrorKind {
    /// <p>The specified locale is not supported.</p>
    UnsupportedLocale(crate::error::UnsupportedLocale),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEventDetailsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEventDetailsErrorKind::UnsupportedLocale(_inner) => _inner.fmt(f),
            DescribeEventDetailsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEventDetailsError {
    fn code(&self) -> Option<&str> {
        DescribeEventDetailsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEventDetailsError {
    /// Creates a new `DescribeEventDetailsError`.
    pub fn new(kind: DescribeEventDetailsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEventDetailsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEventDetailsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEventDetailsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEventDetailsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeEventDetailsErrorKind::UnsupportedLocale`.
    pub fn is_unsupported_locale(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventDetailsErrorKind::UnsupportedLocale(_)
        )
    }
}
impl std::error::Error for DescribeEventDetailsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEventDetailsErrorKind::UnsupportedLocale(_inner) => Some(_inner),
            DescribeEventDetailsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEventDetailsForOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEventDetailsForOrganizationError {
    /// Kind of error that occurred.
    pub kind: DescribeEventDetailsForOrganizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEventDetailsForOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEventDetailsForOrganizationErrorKind {
    /// <p>The specified locale is not supported.</p>
    UnsupportedLocale(crate::error::UnsupportedLocale),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEventDetailsForOrganizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEventDetailsForOrganizationErrorKind::UnsupportedLocale(_inner) => {
                _inner.fmt(f)
            }
            DescribeEventDetailsForOrganizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEventDetailsForOrganizationError {
    fn code(&self) -> Option<&str> {
        DescribeEventDetailsForOrganizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEventDetailsForOrganizationError {
    /// Creates a new `DescribeEventDetailsForOrganizationError`.
    pub fn new(
        kind: DescribeEventDetailsForOrganizationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEventDetailsForOrganizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEventDetailsForOrganizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEventDetailsForOrganizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEventDetailsForOrganizationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeEventDetailsForOrganizationErrorKind::UnsupportedLocale`.
    pub fn is_unsupported_locale(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventDetailsForOrganizationErrorKind::UnsupportedLocale(_)
        )
    }
}
impl std::error::Error for DescribeEventDetailsForOrganizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEventDetailsForOrganizationErrorKind::UnsupportedLocale(_inner) => Some(_inner),
            DescribeEventDetailsForOrganizationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEventsError {
    /// Kind of error that occurred.
    pub kind: DescribeEventsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEventsErrorKind {
    /// <p>The specified pagination token (<code>nextToken</code>) is not valid.</p>
    InvalidPaginationToken(crate::error::InvalidPaginationToken),
    /// <p>The specified locale is not supported.</p>
    UnsupportedLocale(crate::error::UnsupportedLocale),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEventsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEventsErrorKind::InvalidPaginationToken(_inner) => _inner.fmt(f),
            DescribeEventsErrorKind::UnsupportedLocale(_inner) => _inner.fmt(f),
            DescribeEventsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEventsError {
    fn code(&self) -> Option<&str> {
        DescribeEventsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEventsError {
    /// Creates a new `DescribeEventsError`.
    pub fn new(kind: DescribeEventsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEventsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEventsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEventsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEventsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeEventsErrorKind::InvalidPaginationToken`.
    pub fn is_invalid_pagination_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventsErrorKind::InvalidPaginationToken(_)
        )
    }
    /// Returns true if the error kind is `DescribeEventsErrorKind::UnsupportedLocale`.
    pub fn is_unsupported_locale(&self) -> bool {
        matches!(&self.kind, DescribeEventsErrorKind::UnsupportedLocale(_))
    }
}
impl std::error::Error for DescribeEventsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEventsErrorKind::InvalidPaginationToken(_inner) => Some(_inner),
            DescribeEventsErrorKind::UnsupportedLocale(_inner) => Some(_inner),
            DescribeEventsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEventsForOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEventsForOrganizationError {
    /// Kind of error that occurred.
    pub kind: DescribeEventsForOrganizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEventsForOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEventsForOrganizationErrorKind {
    /// <p>The specified pagination token (<code>nextToken</code>) is not valid.</p>
    InvalidPaginationToken(crate::error::InvalidPaginationToken),
    /// <p>The specified locale is not supported.</p>
    UnsupportedLocale(crate::error::UnsupportedLocale),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEventsForOrganizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEventsForOrganizationErrorKind::InvalidPaginationToken(_inner) => _inner.fmt(f),
            DescribeEventsForOrganizationErrorKind::UnsupportedLocale(_inner) => _inner.fmt(f),
            DescribeEventsForOrganizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEventsForOrganizationError {
    fn code(&self) -> Option<&str> {
        DescribeEventsForOrganizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEventsForOrganizationError {
    /// Creates a new `DescribeEventsForOrganizationError`.
    pub fn new(
        kind: DescribeEventsForOrganizationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEventsForOrganizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEventsForOrganizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEventsForOrganizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEventsForOrganizationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeEventsForOrganizationErrorKind::InvalidPaginationToken`.
    pub fn is_invalid_pagination_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventsForOrganizationErrorKind::InvalidPaginationToken(_)
        )
    }
    /// Returns true if the error kind is `DescribeEventsForOrganizationErrorKind::UnsupportedLocale`.
    pub fn is_unsupported_locale(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventsForOrganizationErrorKind::UnsupportedLocale(_)
        )
    }
}
impl std::error::Error for DescribeEventsForOrganizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEventsForOrganizationErrorKind::InvalidPaginationToken(_inner) => Some(_inner),
            DescribeEventsForOrganizationErrorKind::UnsupportedLocale(_inner) => Some(_inner),
            DescribeEventsForOrganizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEventTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEventTypesError {
    /// Kind of error that occurred.
    pub kind: DescribeEventTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEventTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEventTypesErrorKind {
    /// <p>The specified pagination token (<code>nextToken</code>) is not valid.</p>
    InvalidPaginationToken(crate::error::InvalidPaginationToken),
    /// <p>The specified locale is not supported.</p>
    UnsupportedLocale(crate::error::UnsupportedLocale),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEventTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEventTypesErrorKind::InvalidPaginationToken(_inner) => _inner.fmt(f),
            DescribeEventTypesErrorKind::UnsupportedLocale(_inner) => _inner.fmt(f),
            DescribeEventTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEventTypesError {
    fn code(&self) -> Option<&str> {
        DescribeEventTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEventTypesError {
    /// Creates a new `DescribeEventTypesError`.
    pub fn new(kind: DescribeEventTypesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEventTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEventTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEventTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEventTypesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeEventTypesErrorKind::InvalidPaginationToken`.
    pub fn is_invalid_pagination_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventTypesErrorKind::InvalidPaginationToken(_)
        )
    }
    /// Returns true if the error kind is `DescribeEventTypesErrorKind::UnsupportedLocale`.
    pub fn is_unsupported_locale(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventTypesErrorKind::UnsupportedLocale(_)
        )
    }
}
impl std::error::Error for DescribeEventTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEventTypesErrorKind::InvalidPaginationToken(_inner) => Some(_inner),
            DescribeEventTypesErrorKind::UnsupportedLocale(_inner) => Some(_inner),
            DescribeEventTypesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeHealthServiceStatusForOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeHealthServiceStatusForOrganizationError {
    /// Kind of error that occurred.
    pub kind: DescribeHealthServiceStatusForOrganizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeHealthServiceStatusForOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeHealthServiceStatusForOrganizationErrorKind {
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeHealthServiceStatusForOrganizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeHealthServiceStatusForOrganizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeHealthServiceStatusForOrganizationError {
    fn code(&self) -> Option<&str> {
        DescribeHealthServiceStatusForOrganizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeHealthServiceStatusForOrganizationError {
    /// Creates a new `DescribeHealthServiceStatusForOrganizationError`.
    pub fn new(
        kind: DescribeHealthServiceStatusForOrganizationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeHealthServiceStatusForOrganizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeHealthServiceStatusForOrganizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeHealthServiceStatusForOrganizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeHealthServiceStatusForOrganizationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeHealthServiceStatusForOrganizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeHealthServiceStatusForOrganizationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DisableHealthServiceAccessForOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableHealthServiceAccessForOrganizationError {
    /// Kind of error that occurred.
    pub kind: DisableHealthServiceAccessForOrganizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableHealthServiceAccessForOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableHealthServiceAccessForOrganizationErrorKind {
    /// <p>
    /// <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EnableHealthServiceAccessForOrganization.html">EnableHealthServiceAccessForOrganization</a> is already in progress. Wait for the
    /// action to complete before trying again. To get the current status, use the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeHealthServiceStatusForOrganization.html">DescribeHealthServiceStatusForOrganization</a> operation.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableHealthServiceAccessForOrganizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableHealthServiceAccessForOrganizationErrorKind::ConcurrentModificationException(
                _inner,
            ) => _inner.fmt(f),
            DisableHealthServiceAccessForOrganizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableHealthServiceAccessForOrganizationError {
    fn code(&self) -> Option<&str> {
        DisableHealthServiceAccessForOrganizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableHealthServiceAccessForOrganizationError {
    /// Creates a new `DisableHealthServiceAccessForOrganizationError`.
    pub fn new(
        kind: DisableHealthServiceAccessForOrganizationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableHealthServiceAccessForOrganizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableHealthServiceAccessForOrganizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableHealthServiceAccessForOrganizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableHealthServiceAccessForOrganizationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DisableHealthServiceAccessForOrganizationErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableHealthServiceAccessForOrganizationErrorKind::ConcurrentModificationException(_)
        )
    }
}
impl std::error::Error for DisableHealthServiceAccessForOrganizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableHealthServiceAccessForOrganizationErrorKind::ConcurrentModificationException(
                _inner,
            ) => Some(_inner),
            DisableHealthServiceAccessForOrganizationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `EnableHealthServiceAccessForOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableHealthServiceAccessForOrganizationError {
    /// Kind of error that occurred.
    pub kind: EnableHealthServiceAccessForOrganizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableHealthServiceAccessForOrganization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableHealthServiceAccessForOrganizationErrorKind {
    /// <p>
    /// <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EnableHealthServiceAccessForOrganization.html">EnableHealthServiceAccessForOrganization</a> is already in progress. Wait for the
    /// action to complete before trying again. To get the current status, use the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeHealthServiceStatusForOrganization.html">DescribeHealthServiceStatusForOrganization</a> operation.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableHealthServiceAccessForOrganizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableHealthServiceAccessForOrganizationErrorKind::ConcurrentModificationException(
                _inner,
            ) => _inner.fmt(f),
            EnableHealthServiceAccessForOrganizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableHealthServiceAccessForOrganizationError {
    fn code(&self) -> Option<&str> {
        EnableHealthServiceAccessForOrganizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableHealthServiceAccessForOrganizationError {
    /// Creates a new `EnableHealthServiceAccessForOrganizationError`.
    pub fn new(
        kind: EnableHealthServiceAccessForOrganizationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableHealthServiceAccessForOrganizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableHealthServiceAccessForOrganizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableHealthServiceAccessForOrganizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableHealthServiceAccessForOrganizationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `EnableHealthServiceAccessForOrganizationErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableHealthServiceAccessForOrganizationErrorKind::ConcurrentModificationException(_)
        )
    }
}
impl std::error::Error for EnableHealthServiceAccessForOrganizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableHealthServiceAccessForOrganizationErrorKind::ConcurrentModificationException(
                _inner,
            ) => Some(_inner),
            EnableHealthServiceAccessForOrganizationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// <p>
/// <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_EnableHealthServiceAccessForOrganization.html">EnableHealthServiceAccessForOrganization</a> is already in progress. Wait for the
/// action to complete before trying again. To get the current status, use the <a href="https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeHealthServiceStatusForOrganization.html">DescribeHealthServiceStatusForOrganization</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConcurrentModificationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConcurrentModificationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConcurrentModificationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConcurrentModificationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConcurrentModificationException {}
/// See [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
pub mod concurrent_modification_exception {
    /// A builder for [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
        pub fn build(self) -> crate::error::ConcurrentModificationException {
            crate::error::ConcurrentModificationException {
                message: self.message,
            }
        }
    }
}
impl ConcurrentModificationException {
    /// Creates a new builder-style object to manufacture [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    pub fn builder() -> crate::error::concurrent_modification_exception::Builder {
        crate::error::concurrent_modification_exception::Builder::default()
    }
}

/// <p>The specified locale is not supported.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedLocale {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedLocale {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedLocale");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedLocale {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedLocale {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedLocale")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedLocale {}
/// See [`UnsupportedLocale`](crate::error::UnsupportedLocale)
pub mod unsupported_locale {
    /// A builder for [`UnsupportedLocale`](crate::error::UnsupportedLocale)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedLocale`](crate::error::UnsupportedLocale)
        pub fn build(self) -> crate::error::UnsupportedLocale {
            crate::error::UnsupportedLocale {
                message: self.message,
            }
        }
    }
}
impl UnsupportedLocale {
    /// Creates a new builder-style object to manufacture [`UnsupportedLocale`](crate::error::UnsupportedLocale)
    pub fn builder() -> crate::error::unsupported_locale::Builder {
        crate::error::unsupported_locale::Builder::default()
    }
}

/// <p>The specified pagination token (<code>nextToken</code>) is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidPaginationToken {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidPaginationToken {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidPaginationToken");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidPaginationToken {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidPaginationToken {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidPaginationToken")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidPaginationToken {}
/// See [`InvalidPaginationToken`](crate::error::InvalidPaginationToken)
pub mod invalid_pagination_token {
    /// A builder for [`InvalidPaginationToken`](crate::error::InvalidPaginationToken)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidPaginationToken`](crate::error::InvalidPaginationToken)
        pub fn build(self) -> crate::error::InvalidPaginationToken {
            crate::error::InvalidPaginationToken {
                message: self.message,
            }
        }
    }
}
impl InvalidPaginationToken {
    /// Creates a new builder-style object to manufacture [`InvalidPaginationToken`](crate::error::InvalidPaginationToken)
    pub fn builder() -> crate::error::invalid_pagination_token::Builder {
        crate::error::invalid_pagination_token::Builder::default()
    }
}
