// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AcceptInvitationInput`](crate::input::AcceptInvitationInput)
pub mod accept_invitation_input {
    /// A builder for [`AcceptInvitationInput`](crate::input::AcceptInvitationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) master_id: std::option::Option<std::string::String>,
        pub(crate) invitation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the detector of the GuardDuty member account.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the detector of the GuardDuty member account.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The account ID of the GuardDuty administrator account whose invitation you're accepting.</p>
        pub fn master_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_id = Some(input.into());
            self
        }
        /// <p>The account ID of the GuardDuty administrator account whose invitation you're accepting.</p>
        pub fn set_master_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.master_id = input;
            self
        }
        /// <p>The value that is used to validate the administrator account to the member account.</p>
        pub fn invitation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.invitation_id = Some(input.into());
            self
        }
        /// <p>The value that is used to validate the administrator account to the member account.</p>
        pub fn set_invitation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.invitation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptInvitationInput`](crate::input::AcceptInvitationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AcceptInvitationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AcceptInvitationInput {
                detector_id: self.detector_id,
                master_id: self.master_id,
                invitation_id: self.invitation_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AcceptInvitationInputOperationOutputAlias = crate::operation::AcceptInvitation;
#[doc(hidden)]
pub type AcceptInvitationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AcceptInvitationInput {
    /// Consumes the builder and constructs an Operation<[`AcceptInvitation`](crate::operation::AcceptInvitation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AcceptInvitation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AcceptInvitationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.detector_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_1, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/master",
                DetectorId = detector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AcceptInvitationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AcceptInvitationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_accept_invitation(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AcceptInvitation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AcceptInvitation",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AcceptInvitationInput`](crate::input::AcceptInvitationInput)
    pub fn builder() -> crate::input::accept_invitation_input::Builder {
        crate::input::accept_invitation_input::Builder::default()
    }
}

/// See [`ArchiveFindingsInput`](crate::input::ArchiveFindingsInput)
pub mod archive_findings_input {
    /// A builder for [`ArchiveFindingsInput`](crate::input::ArchiveFindingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) finding_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ID of the detector that specifies the GuardDuty service whose findings you want to archive.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The ID of the detector that specifies the GuardDuty service whose findings you want to archive.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// Appends an item to `finding_ids`.
        ///
        /// To override the contents of this collection use [`set_finding_ids`](Self::set_finding_ids).
        ///
        /// <p>The IDs of the findings that you want to archive.</p>
        pub fn finding_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.finding_ids.unwrap_or_default();
            v.push(input.into());
            self.finding_ids = Some(v);
            self
        }
        /// <p>The IDs of the findings that you want to archive.</p>
        pub fn set_finding_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.finding_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`ArchiveFindingsInput`](crate::input::ArchiveFindingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ArchiveFindingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ArchiveFindingsInput {
                detector_id: self.detector_id,
                finding_ids: self.finding_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type ArchiveFindingsInputOperationOutputAlias = crate::operation::ArchiveFindings;
#[doc(hidden)]
pub type ArchiveFindingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ArchiveFindingsInput {
    /// Consumes the builder and constructs an Operation<[`ArchiveFindings`](crate::operation::ArchiveFindings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ArchiveFindings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ArchiveFindingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.detector_id;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_2, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/findings/archive",
                DetectorId = detector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ArchiveFindingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ArchiveFindingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_archive_findings(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ArchiveFindings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ArchiveFindings",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ArchiveFindingsInput`](crate::input::ArchiveFindingsInput)
    pub fn builder() -> crate::input::archive_findings_input::Builder {
        crate::input::archive_findings_input::Builder::default()
    }
}

/// See [`CreateDetectorInput`](crate::input::CreateDetectorInput)
pub mod create_detector_input {
    /// A builder for [`CreateDetectorInput`](crate::input::CreateDetectorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enable: std::option::Option<bool>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) finding_publishing_frequency:
            std::option::Option<crate::model::FindingPublishingFrequency>,
        pub(crate) data_sources: std::option::Option<crate::model::DataSourceConfigurations>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A Boolean value that specifies whether the detector is to be enabled.</p>
        pub fn enable(mut self, input: bool) -> Self {
            self.enable = Some(input);
            self
        }
        /// <p>A Boolean value that specifies whether the detector is to be enabled.</p>
        pub fn set_enable(mut self, input: std::option::Option<bool>) -> Self {
            self.enable = input;
            self
        }
        /// <p>The idempotency token for the create request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The idempotency token for the create request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>A value that specifies how frequently updated findings are exported.</p>
        pub fn finding_publishing_frequency(
            mut self,
            input: crate::model::FindingPublishingFrequency,
        ) -> Self {
            self.finding_publishing_frequency = Some(input);
            self
        }
        /// <p>A value that specifies how frequently updated findings are exported.</p>
        pub fn set_finding_publishing_frequency(
            mut self,
            input: std::option::Option<crate::model::FindingPublishingFrequency>,
        ) -> Self {
            self.finding_publishing_frequency = input;
            self
        }
        /// <p>Describes which data sources will be enabled for the detector.</p>
        pub fn data_sources(mut self, input: crate::model::DataSourceConfigurations) -> Self {
            self.data_sources = Some(input);
            self
        }
        /// <p>Describes which data sources will be enabled for the detector.</p>
        pub fn set_data_sources(
            mut self,
            input: std::option::Option<crate::model::DataSourceConfigurations>,
        ) -> Self {
            self.data_sources = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be added to a new detector resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to be added to a new detector resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDetectorInput`](crate::input::CreateDetectorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDetectorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDetectorInput {
                enable: self.enable.unwrap_or_default(),
                client_token: self.client_token,
                finding_publishing_frequency: self.finding_publishing_frequency,
                data_sources: self.data_sources,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDetectorInputOperationOutputAlias = crate::operation::CreateDetector;
#[doc(hidden)]
pub type CreateDetectorInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDetectorInput {
    /// Consumes the builder and constructs an Operation<[`CreateDetector`](crate::operation::CreateDetector)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDetector,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDetectorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/detector").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDetectorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDetectorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_detector(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDetector::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDetector",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDetectorInput`](crate::input::CreateDetectorInput)
    pub fn builder() -> crate::input::create_detector_input::Builder {
        crate::input::create_detector_input::Builder::default()
    }
}

/// See [`CreateFilterInput`](crate::input::CreateFilterInput)
pub mod create_filter_input {
    /// A builder for [`CreateFilterInput`](crate::input::CreateFilterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) action: std::option::Option<crate::model::FilterAction>,
        pub(crate) rank: std::option::Option<i32>,
        pub(crate) finding_criteria: std::option::Option<crate::model::FindingCriteria>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the detector belonging to the GuardDuty account that you want to create a filter for.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The ID of the detector belonging to the GuardDuty account that you want to create a filter for.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The name of the filter. Minimum length of 3. Maximum length of 64. Valid characters include alphanumeric characters, dot (.), underscore (_), and dash (-). Spaces are not allowed.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the filter. Minimum length of 3. Maximum length of 64. Valid characters include alphanumeric characters, dot (.), underscore (_), and dash (-). Spaces are not allowed.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the filter.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the filter.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Specifies the action that is to be applied to the findings that match the filter.</p>
        pub fn action(mut self, input: crate::model::FilterAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>Specifies the action that is to be applied to the findings that match the filter.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::FilterAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>Specifies the position of the filter in the list of current filters. Also specifies the order in which this filter is applied to the findings.</p>
        pub fn rank(mut self, input: i32) -> Self {
            self.rank = Some(input);
            self
        }
        /// <p>Specifies the position of the filter in the list of current filters. Also specifies the order in which this filter is applied to the findings.</p>
        pub fn set_rank(mut self, input: std::option::Option<i32>) -> Self {
            self.rank = input;
            self
        }
        /// <p>Represents the criteria to be used in the filter for querying findings.</p>
        /// <p>You can only use the following attributes to query findings:</p>
        /// <ul>
        /// <li> <p>accountId</p> </li>
        /// <li> <p>region</p> </li>
        /// <li> <p>confidence</p> </li>
        /// <li> <p>id</p> </li>
        /// <li> <p>resource.accessKeyDetails.accessKeyId</p> </li>
        /// <li> <p>resource.accessKeyDetails.principalId</p> </li>
        /// <li> <p>resource.accessKeyDetails.userName</p> </li>
        /// <li> <p>resource.accessKeyDetails.userType</p> </li>
        /// <li> <p>resource.instanceDetails.iamInstanceProfile.id</p> </li>
        /// <li> <p>resource.instanceDetails.imageId</p> </li>
        /// <li> <p>resource.instanceDetails.instanceId</p> </li>
        /// <li> <p>resource.instanceDetails.outpostArn</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.ipv6Addresses</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.publicDnsName</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.publicIp</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.securityGroups.groupId</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.securityGroups.groupName</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.subnetId</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.vpcId</p> </li>
        /// <li> <p>resource.instanceDetails.tags.key</p> </li>
        /// <li> <p>resource.instanceDetails.tags.value</p> </li>
        /// <li> <p>resource.resourceType</p> </li>
        /// <li> <p>service.action.actionType</p> </li>
        /// <li> <p>service.action.awsApiCallAction.api</p> </li>
        /// <li> <p>service.action.awsApiCallAction.callerType</p> </li>
        /// <li> <p>service.action.awsApiCallAction.errorCode</p> </li>
        /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.city.cityName</p> </li>
        /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.country.countryName</p> </li>
        /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.ipAddressV4</p> </li>
        /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.organization.asn</p> </li>
        /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg</p> </li>
        /// <li> <p>service.action.awsApiCallAction.serviceName</p> </li>
        /// <li> <p>service.action.dnsRequestAction.domain</p> </li>
        /// <li> <p>service.action.networkConnectionAction.blocked</p> </li>
        /// <li> <p>service.action.networkConnectionAction.connectionDirection</p> </li>
        /// <li> <p>service.action.networkConnectionAction.localPortDetails.port</p> </li>
        /// <li> <p>service.action.networkConnectionAction.protocol</p> </li>
        /// <li> <p>service.action.networkConnectionAction.localIpDetails.ipAddressV4</p> </li>
        /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.city.cityName</p> </li>
        /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.country.countryName</p> </li>
        /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.ipAddressV4</p> </li>
        /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.organization.asn</p> </li>
        /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg</p> </li>
        /// <li> <p>service.action.networkConnectionAction.remotePortDetails.port</p> </li>
        /// <li> <p>service.additionalInfo.threatListName</p> </li>
        /// <li> <p>resource.s3BucketDetails.publicAccess.effectivePermissions</p> </li>
        /// <li> <p>resource.s3BucketDetails.name</p> </li>
        /// <li> <p>resource.s3BucketDetails.tags.key</p> </li>
        /// <li> <p>resource.s3BucketDetails.tags.value</p> </li>
        /// <li> <p>resource.s3BucketDetails.type</p> </li>
        /// <li> <p>service.archived</p> <p>When this attribute is set to TRUE, only archived findings are listed. When it's set to FALSE, only unarchived findings are listed. When this attribute is not set, all existing findings are listed.</p> </li>
        /// <li> <p>service.resourceRole</p> </li>
        /// <li> <p>severity</p> </li>
        /// <li> <p>type</p> </li>
        /// <li> <p>updatedAt</p> <p>Type: ISO 8601 string format: YYYY-MM-DDTHH:MM:SS.SSSZ or YYYY-MM-DDTHH:MM:SSZ depending on whether the value contains milliseconds.</p> </li>
        /// </ul>
        pub fn finding_criteria(mut self, input: crate::model::FindingCriteria) -> Self {
            self.finding_criteria = Some(input);
            self
        }
        /// <p>Represents the criteria to be used in the filter for querying findings.</p>
        /// <p>You can only use the following attributes to query findings:</p>
        /// <ul>
        /// <li> <p>accountId</p> </li>
        /// <li> <p>region</p> </li>
        /// <li> <p>confidence</p> </li>
        /// <li> <p>id</p> </li>
        /// <li> <p>resource.accessKeyDetails.accessKeyId</p> </li>
        /// <li> <p>resource.accessKeyDetails.principalId</p> </li>
        /// <li> <p>resource.accessKeyDetails.userName</p> </li>
        /// <li> <p>resource.accessKeyDetails.userType</p> </li>
        /// <li> <p>resource.instanceDetails.iamInstanceProfile.id</p> </li>
        /// <li> <p>resource.instanceDetails.imageId</p> </li>
        /// <li> <p>resource.instanceDetails.instanceId</p> </li>
        /// <li> <p>resource.instanceDetails.outpostArn</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.ipv6Addresses</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.publicDnsName</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.publicIp</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.securityGroups.groupId</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.securityGroups.groupName</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.subnetId</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.vpcId</p> </li>
        /// <li> <p>resource.instanceDetails.tags.key</p> </li>
        /// <li> <p>resource.instanceDetails.tags.value</p> </li>
        /// <li> <p>resource.resourceType</p> </li>
        /// <li> <p>service.action.actionType</p> </li>
        /// <li> <p>service.action.awsApiCallAction.api</p> </li>
        /// <li> <p>service.action.awsApiCallAction.callerType</p> </li>
        /// <li> <p>service.action.awsApiCallAction.errorCode</p> </li>
        /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.city.cityName</p> </li>
        /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.country.countryName</p> </li>
        /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.ipAddressV4</p> </li>
        /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.organization.asn</p> </li>
        /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg</p> </li>
        /// <li> <p>service.action.awsApiCallAction.serviceName</p> </li>
        /// <li> <p>service.action.dnsRequestAction.domain</p> </li>
        /// <li> <p>service.action.networkConnectionAction.blocked</p> </li>
        /// <li> <p>service.action.networkConnectionAction.connectionDirection</p> </li>
        /// <li> <p>service.action.networkConnectionAction.localPortDetails.port</p> </li>
        /// <li> <p>service.action.networkConnectionAction.protocol</p> </li>
        /// <li> <p>service.action.networkConnectionAction.localIpDetails.ipAddressV4</p> </li>
        /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.city.cityName</p> </li>
        /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.country.countryName</p> </li>
        /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.ipAddressV4</p> </li>
        /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.organization.asn</p> </li>
        /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg</p> </li>
        /// <li> <p>service.action.networkConnectionAction.remotePortDetails.port</p> </li>
        /// <li> <p>service.additionalInfo.threatListName</p> </li>
        /// <li> <p>resource.s3BucketDetails.publicAccess.effectivePermissions</p> </li>
        /// <li> <p>resource.s3BucketDetails.name</p> </li>
        /// <li> <p>resource.s3BucketDetails.tags.key</p> </li>
        /// <li> <p>resource.s3BucketDetails.tags.value</p> </li>
        /// <li> <p>resource.s3BucketDetails.type</p> </li>
        /// <li> <p>service.archived</p> <p>When this attribute is set to TRUE, only archived findings are listed. When it's set to FALSE, only unarchived findings are listed. When this attribute is not set, all existing findings are listed.</p> </li>
        /// <li> <p>service.resourceRole</p> </li>
        /// <li> <p>severity</p> </li>
        /// <li> <p>type</p> </li>
        /// <li> <p>updatedAt</p> <p>Type: ISO 8601 string format: YYYY-MM-DDTHH:MM:SS.SSSZ or YYYY-MM-DDTHH:MM:SSZ depending on whether the value contains milliseconds.</p> </li>
        /// </ul>
        pub fn set_finding_criteria(
            mut self,
            input: std::option::Option<crate::model::FindingCriteria>,
        ) -> Self {
            self.finding_criteria = input;
            self
        }
        /// <p>The idempotency token for the create request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The idempotency token for the create request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be added to a new filter resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to be added to a new filter resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFilterInput`](crate::input::CreateFilterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFilterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFilterInput {
                detector_id: self.detector_id,
                name: self.name,
                description: self.description,
                action: self.action,
                rank: self.rank.unwrap_or_default(),
                finding_criteria: self.finding_criteria,
                client_token: self.client_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFilterInputOperationOutputAlias = crate::operation::CreateFilter;
#[doc(hidden)]
pub type CreateFilterInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateFilterInput {
    /// Consumes the builder and constructs an Operation<[`CreateFilter`](crate::operation::CreateFilter)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFilter,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateFilterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.detector_id;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_3, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/filter",
                DetectorId = detector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateFilterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateFilterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_filter(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFilter::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFilter",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateFilterInput`](crate::input::CreateFilterInput)
    pub fn builder() -> crate::input::create_filter_input::Builder {
        crate::input::create_filter_input::Builder::default()
    }
}

/// See [`CreateIpSetInput`](crate::input::CreateIpSetInput)
pub mod create_ip_set_input {
    /// A builder for [`CreateIpSetInput`](crate::input::CreateIpSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::IpSetFormat>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) activate: std::option::Option<bool>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The unique ID of the detector of the GuardDuty account that you want to create an IPSet for.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the detector of the GuardDuty account that you want to create an IPSet for.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The user-friendly name to identify the IPSet.</p>
        /// <p> Allowed characters are alphanumerics, spaces, hyphens (-), and underscores (_).</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The user-friendly name to identify the IPSet.</p>
        /// <p> Allowed characters are alphanumerics, spaces, hyphens (-), and underscores (_).</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The format of the file that contains the IPSet.</p>
        pub fn format(mut self, input: crate::model::IpSetFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>The format of the file that contains the IPSet.</p>
        pub fn set_format(mut self, input: std::option::Option<crate::model::IpSetFormat>) -> Self {
            self.format = input;
            self
        }
        /// <p>The URI of the file that contains the IPSet. </p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The URI of the file that contains the IPSet. </p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>A Boolean value that indicates whether GuardDuty is to start using the uploaded IPSet.</p>
        pub fn activate(mut self, input: bool) -> Self {
            self.activate = Some(input);
            self
        }
        /// <p>A Boolean value that indicates whether GuardDuty is to start using the uploaded IPSet.</p>
        pub fn set_activate(mut self, input: std::option::Option<bool>) -> Self {
            self.activate = input;
            self
        }
        /// <p>The idempotency token for the create request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The idempotency token for the create request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be added to a new IP set resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to be added to a new IP set resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateIpSetInput`](crate::input::CreateIpSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateIpSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateIpSetInput {
                detector_id: self.detector_id,
                name: self.name,
                format: self.format,
                location: self.location,
                activate: self.activate.unwrap_or_default(),
                client_token: self.client_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateIpSetInputOperationOutputAlias = crate::operation::CreateIPSet;
#[doc(hidden)]
pub type CreateIpSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateIpSetInput {
    /// Consumes the builder and constructs an Operation<[`CreateIPSet`](crate::operation::CreateIPSet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateIPSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateIpSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.detector_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_4, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/ipset",
                DetectorId = detector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateIpSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateIpSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_ip_set(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateIPSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateIPSet",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateIpSetInput`](crate::input::CreateIpSetInput)
    pub fn builder() -> crate::input::create_ip_set_input::Builder {
        crate::input::create_ip_set_input::Builder::default()
    }
}

/// See [`CreateMembersInput`](crate::input::CreateMembersInput)
pub mod create_members_input {
    /// A builder for [`CreateMembersInput`](crate::input::CreateMembersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) account_details: std::option::Option<std::vec::Vec<crate::model::AccountDetail>>,
    }
    impl Builder {
        /// <p>The unique ID of the detector of the GuardDuty account that you want to associate member accounts with.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the detector of the GuardDuty account that you want to associate member accounts with.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// Appends an item to `account_details`.
        ///
        /// To override the contents of this collection use [`set_account_details`](Self::set_account_details).
        ///
        /// <p>A list of account ID and email address pairs of the accounts that you want to associate with the GuardDuty administrator account.</p>
        pub fn account_details(mut self, input: crate::model::AccountDetail) -> Self {
            let mut v = self.account_details.unwrap_or_default();
            v.push(input);
            self.account_details = Some(v);
            self
        }
        /// <p>A list of account ID and email address pairs of the accounts that you want to associate with the GuardDuty administrator account.</p>
        pub fn set_account_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccountDetail>>,
        ) -> Self {
            self.account_details = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMembersInput`](crate::input::CreateMembersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateMembersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateMembersInput {
                detector_id: self.detector_id,
                account_details: self.account_details,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateMembersInputOperationOutputAlias = crate::operation::CreateMembers;
#[doc(hidden)]
pub type CreateMembersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateMembersInput {
    /// Consumes the builder and constructs an Operation<[`CreateMembers`](crate::operation::CreateMembers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateMembers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateMembersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.detector_id;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_5, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/member",
                DetectorId = detector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateMembersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateMembersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_members(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateMembers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateMembers",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateMembersInput`](crate::input::CreateMembersInput)
    pub fn builder() -> crate::input::create_members_input::Builder {
        crate::input::create_members_input::Builder::default()
    }
}

/// See [`CreatePublishingDestinationInput`](crate::input::CreatePublishingDestinationInput)
pub mod create_publishing_destination_input {
    /// A builder for [`CreatePublishingDestinationInput`](crate::input::CreatePublishingDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) destination_type: std::option::Option<crate::model::DestinationType>,
        pub(crate) destination_properties: std::option::Option<crate::model::DestinationProperties>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the GuardDuty detector associated with the publishing destination.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The ID of the GuardDuty detector associated with the publishing destination.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The type of resource for the publishing destination. Currently only Amazon S3 buckets are supported.</p>
        pub fn destination_type(mut self, input: crate::model::DestinationType) -> Self {
            self.destination_type = Some(input);
            self
        }
        /// <p>The type of resource for the publishing destination. Currently only Amazon S3 buckets are supported.</p>
        pub fn set_destination_type(
            mut self,
            input: std::option::Option<crate::model::DestinationType>,
        ) -> Self {
            self.destination_type = input;
            self
        }
        /// <p>The properties of the publishing destination, including the ARNs for the destination and the KMS key used for encryption.</p>
        pub fn destination_properties(
            mut self,
            input: crate::model::DestinationProperties,
        ) -> Self {
            self.destination_properties = Some(input);
            self
        }
        /// <p>The properties of the publishing destination, including the ARNs for the destination and the KMS key used for encryption.</p>
        pub fn set_destination_properties(
            mut self,
            input: std::option::Option<crate::model::DestinationProperties>,
        ) -> Self {
            self.destination_properties = input;
            self
        }
        /// <p>The idempotency token for the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The idempotency token for the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePublishingDestinationInput`](crate::input::CreatePublishingDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePublishingDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePublishingDestinationInput {
                detector_id: self.detector_id,
                destination_type: self.destination_type,
                destination_properties: self.destination_properties,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePublishingDestinationInputOperationOutputAlias =
    crate::operation::CreatePublishingDestination;
#[doc(hidden)]
pub type CreatePublishingDestinationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreatePublishingDestinationInput {
    /// Consumes the builder and constructs an Operation<[`CreatePublishingDestination`](crate::operation::CreatePublishingDestination)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePublishingDestination,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreatePublishingDestinationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.detector_id;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_6, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/publishingDestination",
                DetectorId = detector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreatePublishingDestinationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreatePublishingDestinationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_publishing_destination(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePublishingDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePublishingDestination",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreatePublishingDestinationInput`](crate::input::CreatePublishingDestinationInput)
    pub fn builder() -> crate::input::create_publishing_destination_input::Builder {
        crate::input::create_publishing_destination_input::Builder::default()
    }
}

/// See [`CreateSampleFindingsInput`](crate::input::CreateSampleFindingsInput)
pub mod create_sample_findings_input {
    /// A builder for [`CreateSampleFindingsInput`](crate::input::CreateSampleFindingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) finding_types: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ID of the detector to create sample findings for.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The ID of the detector to create sample findings for.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// Appends an item to `finding_types`.
        ///
        /// To override the contents of this collection use [`set_finding_types`](Self::set_finding_types).
        ///
        /// <p>The types of sample findings to generate.</p>
        pub fn finding_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.finding_types.unwrap_or_default();
            v.push(input.into());
            self.finding_types = Some(v);
            self
        }
        /// <p>The types of sample findings to generate.</p>
        pub fn set_finding_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.finding_types = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSampleFindingsInput`](crate::input::CreateSampleFindingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSampleFindingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSampleFindingsInput {
                detector_id: self.detector_id,
                finding_types: self.finding_types,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSampleFindingsInputOperationOutputAlias = crate::operation::CreateSampleFindings;
#[doc(hidden)]
pub type CreateSampleFindingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateSampleFindingsInput {
    /// Consumes the builder and constructs an Operation<[`CreateSampleFindings`](crate::operation::CreateSampleFindings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSampleFindings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSampleFindingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.detector_id;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_7, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/findings/create",
                DetectorId = detector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSampleFindingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSampleFindingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_sample_findings(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSampleFindings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSampleFindings",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSampleFindingsInput`](crate::input::CreateSampleFindingsInput)
    pub fn builder() -> crate::input::create_sample_findings_input::Builder {
        crate::input::create_sample_findings_input::Builder::default()
    }
}

/// See [`CreateThreatIntelSetInput`](crate::input::CreateThreatIntelSetInput)
pub mod create_threat_intel_set_input {
    /// A builder for [`CreateThreatIntelSetInput`](crate::input::CreateThreatIntelSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::ThreatIntelSetFormat>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) activate: std::option::Option<bool>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The unique ID of the detector of the GuardDuty account that you want to create a threatIntelSet for.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the detector of the GuardDuty account that you want to create a threatIntelSet for.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>A user-friendly ThreatIntelSet name displayed in all findings that are generated by activity that involves IP addresses included in this ThreatIntelSet.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A user-friendly ThreatIntelSet name displayed in all findings that are generated by activity that involves IP addresses included in this ThreatIntelSet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The format of the file that contains the ThreatIntelSet.</p>
        pub fn format(mut self, input: crate::model::ThreatIntelSetFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>The format of the file that contains the ThreatIntelSet.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::ThreatIntelSetFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>The URI of the file that contains the ThreatIntelSet. </p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The URI of the file that contains the ThreatIntelSet. </p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>A Boolean value that indicates whether GuardDuty is to start using the uploaded ThreatIntelSet.</p>
        pub fn activate(mut self, input: bool) -> Self {
            self.activate = Some(input);
            self
        }
        /// <p>A Boolean value that indicates whether GuardDuty is to start using the uploaded ThreatIntelSet.</p>
        pub fn set_activate(mut self, input: std::option::Option<bool>) -> Self {
            self.activate = input;
            self
        }
        /// <p>The idempotency token for the create request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The idempotency token for the create request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be added to a new threat list resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to be added to a new threat list resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateThreatIntelSetInput`](crate::input::CreateThreatIntelSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateThreatIntelSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateThreatIntelSetInput {
                detector_id: self.detector_id,
                name: self.name,
                format: self.format,
                location: self.location,
                activate: self.activate.unwrap_or_default(),
                client_token: self.client_token,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateThreatIntelSetInputOperationOutputAlias = crate::operation::CreateThreatIntelSet;
#[doc(hidden)]
pub type CreateThreatIntelSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateThreatIntelSetInput {
    /// Consumes the builder and constructs an Operation<[`CreateThreatIntelSet`](crate::operation::CreateThreatIntelSet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateThreatIntelSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateThreatIntelSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.detector_id;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_8, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/threatintelset",
                DetectorId = detector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateThreatIntelSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateThreatIntelSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_threat_intel_set(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateThreatIntelSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateThreatIntelSet",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateThreatIntelSetInput`](crate::input::CreateThreatIntelSetInput)
    pub fn builder() -> crate::input::create_threat_intel_set_input::Builder {
        crate::input::create_threat_intel_set_input::Builder::default()
    }
}

/// See [`DeclineInvitationsInput`](crate::input::DeclineInvitationsInput)
pub mod decline_invitations_input {
    /// A builder for [`DeclineInvitationsInput`](crate::input::DeclineInvitationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>A list of account IDs of the Amazon Web Services accounts that sent invitations to the current member account that you want to decline invitations from.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>A list of account IDs of the Amazon Web Services accounts that sent invitations to the current member account that you want to decline invitations from.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DeclineInvitationsInput`](crate::input::DeclineInvitationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeclineInvitationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeclineInvitationsInput {
                account_ids: self.account_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DeclineInvitationsInputOperationOutputAlias = crate::operation::DeclineInvitations;
#[doc(hidden)]
pub type DeclineInvitationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeclineInvitationsInput {
    /// Consumes the builder and constructs an Operation<[`DeclineInvitations`](crate::operation::DeclineInvitations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeclineInvitations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeclineInvitationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/invitation/decline").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeclineInvitationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeclineInvitationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_decline_invitations(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeclineInvitations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeclineInvitations",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeclineInvitationsInput`](crate::input::DeclineInvitationsInput)
    pub fn builder() -> crate::input::decline_invitations_input::Builder {
        crate::input::decline_invitations_input::Builder::default()
    }
}

/// See [`DeleteDetectorInput`](crate::input::DeleteDetectorInput)
pub mod delete_detector_input {
    /// A builder for [`DeleteDetectorInput`](crate::input::DeleteDetectorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the detector that you want to delete.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the detector that you want to delete.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDetectorInput`](crate::input::DeleteDetectorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDetectorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDetectorInput {
                detector_id: self.detector_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDetectorInputOperationOutputAlias = crate::operation::DeleteDetector;
#[doc(hidden)]
pub type DeleteDetectorInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDetectorInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDetector`](crate::operation::DeleteDetector)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDetector,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDetectorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.detector_id;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_9, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/detector/{DetectorId}", DetectorId = detector_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDetectorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDetectorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDetector::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDetector",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDetectorInput`](crate::input::DeleteDetectorInput)
    pub fn builder() -> crate::input::delete_detector_input::Builder {
        crate::input::delete_detector_input::Builder::default()
    }
}

/// See [`DeleteFilterInput`](crate::input::DeleteFilterInput)
pub mod delete_filter_input {
    /// A builder for [`DeleteFilterInput`](crate::input::DeleteFilterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) filter_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the detector that the filter is associated with.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the detector that the filter is associated with.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The name of the filter that you want to delete.</p>
        pub fn filter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter_name = Some(input.into());
            self
        }
        /// <p>The name of the filter that you want to delete.</p>
        pub fn set_filter_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.filter_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFilterInput`](crate::input::DeleteFilterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFilterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFilterInput {
                detector_id: self.detector_id,
                filter_name: self.filter_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFilterInputOperationOutputAlias = crate::operation::DeleteFilter;
#[doc(hidden)]
pub type DeleteFilterInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteFilterInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFilter`](crate::operation::DeleteFilter)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFilter,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteFilterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_10 = &_input.detector_id;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_10, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_11 = &_input.filter_name;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "filter_name",
                        details: "cannot be empty or unset",
                    })?;
            let filter_name = aws_smithy_http::label::fmt_string(input_11, false);
            if filter_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "filter_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/filter/{FilterName}",
                DetectorId = detector_id,
                FilterName = filter_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteFilterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteFilterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFilter::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFilter",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteFilterInput`](crate::input::DeleteFilterInput)
    pub fn builder() -> crate::input::delete_filter_input::Builder {
        crate::input::delete_filter_input::Builder::default()
    }
}

/// See [`DeleteInvitationsInput`](crate::input::DeleteInvitationsInput)
pub mod delete_invitations_input {
    /// A builder for [`DeleteInvitationsInput`](crate::input::DeleteInvitationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>A list of account IDs of the Amazon Web Services accounts that sent invitations to the current member account that you want to delete invitations from.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>A list of account IDs of the Amazon Web Services accounts that sent invitations to the current member account that you want to delete invitations from.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteInvitationsInput`](crate::input::DeleteInvitationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteInvitationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteInvitationsInput {
                account_ids: self.account_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteInvitationsInputOperationOutputAlias = crate::operation::DeleteInvitations;
#[doc(hidden)]
pub type DeleteInvitationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteInvitationsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteInvitations`](crate::operation::DeleteInvitations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteInvitations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteInvitationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/invitation/delete").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteInvitationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteInvitationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_invitations(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteInvitations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteInvitations",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteInvitationsInput`](crate::input::DeleteInvitationsInput)
    pub fn builder() -> crate::input::delete_invitations_input::Builder {
        crate::input::delete_invitations_input::Builder::default()
    }
}

/// See [`DeleteIpSetInput`](crate::input::DeleteIpSetInput)
pub mod delete_ip_set_input {
    /// A builder for [`DeleteIpSetInput`](crate::input::DeleteIpSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) ip_set_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the detector associated with the IPSet.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the detector associated with the IPSet.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The unique ID of the IPSet to delete.</p>
        pub fn ip_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_set_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the IPSet to delete.</p>
        pub fn set_ip_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_set_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteIpSetInput`](crate::input::DeleteIpSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteIpSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteIpSetInput {
                detector_id: self.detector_id,
                ip_set_id: self.ip_set_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteIpSetInputOperationOutputAlias = crate::operation::DeleteIPSet;
#[doc(hidden)]
pub type DeleteIpSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteIpSetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteIPSet`](crate::operation::DeleteIPSet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteIPSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteIpSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_12 = &_input.detector_id;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_12, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_13 = &_input.ip_set_id;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "ip_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let ip_set_id = aws_smithy_http::label::fmt_string(input_13, false);
            if ip_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "ip_set_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/ipset/{IpSetId}",
                DetectorId = detector_id,
                IpSetId = ip_set_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteIpSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteIpSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteIPSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteIPSet",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteIpSetInput`](crate::input::DeleteIpSetInput)
    pub fn builder() -> crate::input::delete_ip_set_input::Builder {
        crate::input::delete_ip_set_input::Builder::default()
    }
}

/// See [`DeleteMembersInput`](crate::input::DeleteMembersInput)
pub mod delete_members_input {
    /// A builder for [`DeleteMembersInput`](crate::input::DeleteMembersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The unique ID of the detector of the GuardDuty account whose members you want to delete.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the detector of the GuardDuty account whose members you want to delete.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>A list of account IDs of the GuardDuty member accounts that you want to delete.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>A list of account IDs of the GuardDuty member accounts that you want to delete.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMembersInput`](crate::input::DeleteMembersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteMembersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteMembersInput {
                detector_id: self.detector_id,
                account_ids: self.account_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteMembersInputOperationOutputAlias = crate::operation::DeleteMembers;
#[doc(hidden)]
pub type DeleteMembersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteMembersInput {
    /// Consumes the builder and constructs an Operation<[`DeleteMembers`](crate::operation::DeleteMembers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteMembers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteMembersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_14 = &_input.detector_id;
            let input_14 =
                input_14
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_14, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/member/delete",
                DetectorId = detector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteMembersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteMembersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_members(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteMembers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteMembers",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteMembersInput`](crate::input::DeleteMembersInput)
    pub fn builder() -> crate::input::delete_members_input::Builder {
        crate::input::delete_members_input::Builder::default()
    }
}

/// See [`DeletePublishingDestinationInput`](crate::input::DeletePublishingDestinationInput)
pub mod delete_publishing_destination_input {
    /// A builder for [`DeletePublishingDestinationInput`](crate::input::DeletePublishingDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) destination_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the detector associated with the publishing destination to delete.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the detector associated with the publishing destination to delete.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The ID of the publishing destination to delete.</p>
        pub fn destination_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_id = Some(input.into());
            self
        }
        /// <p>The ID of the publishing destination to delete.</p>
        pub fn set_destination_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePublishingDestinationInput`](crate::input::DeletePublishingDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePublishingDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePublishingDestinationInput {
                detector_id: self.detector_id,
                destination_id: self.destination_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePublishingDestinationInputOperationOutputAlias =
    crate::operation::DeletePublishingDestination;
#[doc(hidden)]
pub type DeletePublishingDestinationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeletePublishingDestinationInput {
    /// Consumes the builder and constructs an Operation<[`DeletePublishingDestination`](crate::operation::DeletePublishingDestination)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePublishingDestination,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeletePublishingDestinationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_15 = &_input.detector_id;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_15, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_16 = &_input.destination_id;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "destination_id",
                        details: "cannot be empty or unset",
                    })?;
            let destination_id = aws_smithy_http::label::fmt_string(input_16, false);
            if destination_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "destination_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/publishingDestination/{DestinationId}",
                DetectorId = detector_id,
                DestinationId = destination_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeletePublishingDestinationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeletePublishingDestinationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePublishingDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePublishingDestination",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeletePublishingDestinationInput`](crate::input::DeletePublishingDestinationInput)
    pub fn builder() -> crate::input::delete_publishing_destination_input::Builder {
        crate::input::delete_publishing_destination_input::Builder::default()
    }
}

/// See [`DeleteThreatIntelSetInput`](crate::input::DeleteThreatIntelSetInput)
pub mod delete_threat_intel_set_input {
    /// A builder for [`DeleteThreatIntelSetInput`](crate::input::DeleteThreatIntelSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) threat_intel_set_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the detector that the threatIntelSet is associated with.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the detector that the threatIntelSet is associated with.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The unique ID of the threatIntelSet that you want to delete.</p>
        pub fn threat_intel_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.threat_intel_set_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the threatIntelSet that you want to delete.</p>
        pub fn set_threat_intel_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.threat_intel_set_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteThreatIntelSetInput`](crate::input::DeleteThreatIntelSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteThreatIntelSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteThreatIntelSetInput {
                detector_id: self.detector_id,
                threat_intel_set_id: self.threat_intel_set_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteThreatIntelSetInputOperationOutputAlias = crate::operation::DeleteThreatIntelSet;
#[doc(hidden)]
pub type DeleteThreatIntelSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteThreatIntelSetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteThreatIntelSet`](crate::operation::DeleteThreatIntelSet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteThreatIntelSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteThreatIntelSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_17 = &_input.detector_id;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_17, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_18 = &_input.threat_intel_set_id;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "threat_intel_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let threat_intel_set_id = aws_smithy_http::label::fmt_string(input_18, false);
            if threat_intel_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "threat_intel_set_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/threatintelset/{ThreatIntelSetId}",
                DetectorId = detector_id,
                ThreatIntelSetId = threat_intel_set_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteThreatIntelSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteThreatIntelSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteThreatIntelSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteThreatIntelSet",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteThreatIntelSetInput`](crate::input::DeleteThreatIntelSetInput)
    pub fn builder() -> crate::input::delete_threat_intel_set_input::Builder {
        crate::input::delete_threat_intel_set_input::Builder::default()
    }
}

/// See [`DescribeOrganizationConfigurationInput`](crate::input::DescribeOrganizationConfigurationInput)
pub mod describe_organization_configuration_input {
    /// A builder for [`DescribeOrganizationConfigurationInput`](crate::input::DescribeOrganizationConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the detector to retrieve information about the delegated administrator from.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The ID of the detector to retrieve information about the delegated administrator from.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOrganizationConfigurationInput`](crate::input::DescribeOrganizationConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeOrganizationConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeOrganizationConfigurationInput {
                detector_id: self.detector_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeOrganizationConfigurationInputOperationOutputAlias =
    crate::operation::DescribeOrganizationConfiguration;
#[doc(hidden)]
pub type DescribeOrganizationConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeOrganizationConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeOrganizationConfiguration`](crate::operation::DescribeOrganizationConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeOrganizationConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeOrganizationConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_19 = &_input.detector_id;
            let input_19 =
                input_19
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_19, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/admin",
                DetectorId = detector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeOrganizationConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeOrganizationConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeOrganizationConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeOrganizationConfiguration",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeOrganizationConfigurationInput`](crate::input::DescribeOrganizationConfigurationInput)
    pub fn builder() -> crate::input::describe_organization_configuration_input::Builder {
        crate::input::describe_organization_configuration_input::Builder::default()
    }
}

/// See [`DescribePublishingDestinationInput`](crate::input::DescribePublishingDestinationInput)
pub mod describe_publishing_destination_input {
    /// A builder for [`DescribePublishingDestinationInput`](crate::input::DescribePublishingDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) destination_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the detector associated with the publishing destination to retrieve.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the detector associated with the publishing destination to retrieve.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The ID of the publishing destination to retrieve.</p>
        pub fn destination_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_id = Some(input.into());
            self
        }
        /// <p>The ID of the publishing destination to retrieve.</p>
        pub fn set_destination_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePublishingDestinationInput`](crate::input::DescribePublishingDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePublishingDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePublishingDestinationInput {
                detector_id: self.detector_id,
                destination_id: self.destination_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePublishingDestinationInputOperationOutputAlias =
    crate::operation::DescribePublishingDestination;
#[doc(hidden)]
pub type DescribePublishingDestinationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribePublishingDestinationInput {
    /// Consumes the builder and constructs an Operation<[`DescribePublishingDestination`](crate::operation::DescribePublishingDestination)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePublishingDestination,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribePublishingDestinationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_20 = &_input.detector_id;
            let input_20 =
                input_20
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_20, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_21 = &_input.destination_id;
            let input_21 =
                input_21
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "destination_id",
                        details: "cannot be empty or unset",
                    })?;
            let destination_id = aws_smithy_http::label::fmt_string(input_21, false);
            if destination_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "destination_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/publishingDestination/{DestinationId}",
                DetectorId = detector_id,
                DestinationId = destination_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribePublishingDestinationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribePublishingDestinationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePublishingDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePublishingDestination",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribePublishingDestinationInput`](crate::input::DescribePublishingDestinationInput)
    pub fn builder() -> crate::input::describe_publishing_destination_input::Builder {
        crate::input::describe_publishing_destination_input::Builder::default()
    }
}

/// See [`DisableOrganizationAdminAccountInput`](crate::input::DisableOrganizationAdminAccountInput)
pub mod disable_organization_admin_account_input {
    /// A builder for [`DisableOrganizationAdminAccountInput`](crate::input::DisableOrganizationAdminAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) admin_account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services Account ID for the organizations account to be disabled as a GuardDuty delegated administrator.</p>
        pub fn admin_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.admin_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Account ID for the organizations account to be disabled as a GuardDuty delegated administrator.</p>
        pub fn set_admin_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.admin_account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableOrganizationAdminAccountInput`](crate::input::DisableOrganizationAdminAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisableOrganizationAdminAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisableOrganizationAdminAccountInput {
                admin_account_id: self.admin_account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DisableOrganizationAdminAccountInputOperationOutputAlias =
    crate::operation::DisableOrganizationAdminAccount;
#[doc(hidden)]
pub type DisableOrganizationAdminAccountInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisableOrganizationAdminAccountInput {
    /// Consumes the builder and constructs an Operation<[`DisableOrganizationAdminAccount`](crate::operation::DisableOrganizationAdminAccount)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisableOrganizationAdminAccount,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisableOrganizationAdminAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/admin/disable").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisableOrganizationAdminAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisableOrganizationAdminAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disable_organization_admin_account(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisableOrganizationAdminAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisableOrganizationAdminAccount",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisableOrganizationAdminAccountInput`](crate::input::DisableOrganizationAdminAccountInput)
    pub fn builder() -> crate::input::disable_organization_admin_account_input::Builder {
        crate::input::disable_organization_admin_account_input::Builder::default()
    }
}

/// See [`DisassociateFromMasterAccountInput`](crate::input::DisassociateFromMasterAccountInput)
pub mod disassociate_from_master_account_input {
    /// A builder for [`DisassociateFromMasterAccountInput`](crate::input::DisassociateFromMasterAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the detector of the GuardDuty member account.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the detector of the GuardDuty member account.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateFromMasterAccountInput`](crate::input::DisassociateFromMasterAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateFromMasterAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateFromMasterAccountInput {
                detector_id: self.detector_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateFromMasterAccountInputOperationOutputAlias =
    crate::operation::DisassociateFromMasterAccount;
#[doc(hidden)]
pub type DisassociateFromMasterAccountInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateFromMasterAccountInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateFromMasterAccount`](crate::operation::DisassociateFromMasterAccount)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateFromMasterAccount,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateFromMasterAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_22 = &_input.detector_id;
            let input_22 =
                input_22
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_22, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/master/disassociate",
                DetectorId = detector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateFromMasterAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateFromMasterAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateFromMasterAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateFromMasterAccount",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateFromMasterAccountInput`](crate::input::DisassociateFromMasterAccountInput)
    pub fn builder() -> crate::input::disassociate_from_master_account_input::Builder {
        crate::input::disassociate_from_master_account_input::Builder::default()
    }
}

/// See [`DisassociateMembersInput`](crate::input::DisassociateMembersInput)
pub mod disassociate_members_input {
    /// A builder for [`DisassociateMembersInput`](crate::input::DisassociateMembersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The unique ID of the detector of the GuardDuty account whose members you want to disassociate from the administrator account.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the detector of the GuardDuty account whose members you want to disassociate from the administrator account.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>A list of account IDs of the GuardDuty member accounts that you want to disassociate from the administrator account.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>A list of account IDs of the GuardDuty member accounts that you want to disassociate from the administrator account.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateMembersInput`](crate::input::DisassociateMembersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateMembersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateMembersInput {
                detector_id: self.detector_id,
                account_ids: self.account_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateMembersInputOperationOutputAlias = crate::operation::DisassociateMembers;
#[doc(hidden)]
pub type DisassociateMembersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateMembersInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateMembers`](crate::operation::DisassociateMembers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateMembers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateMembersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_23 = &_input.detector_id;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_23, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/member/disassociate",
                DetectorId = detector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateMembersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateMembersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_members(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateMembers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateMembers",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateMembersInput`](crate::input::DisassociateMembersInput)
    pub fn builder() -> crate::input::disassociate_members_input::Builder {
        crate::input::disassociate_members_input::Builder::default()
    }
}

/// See [`EnableOrganizationAdminAccountInput`](crate::input::EnableOrganizationAdminAccountInput)
pub mod enable_organization_admin_account_input {
    /// A builder for [`EnableOrganizationAdminAccountInput`](crate::input::EnableOrganizationAdminAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) admin_account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services Account ID for the organization account to be enabled as a GuardDuty delegated administrator.</p>
        pub fn admin_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.admin_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Account ID for the organization account to be enabled as a GuardDuty delegated administrator.</p>
        pub fn set_admin_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.admin_account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableOrganizationAdminAccountInput`](crate::input::EnableOrganizationAdminAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnableOrganizationAdminAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnableOrganizationAdminAccountInput {
                admin_account_id: self.admin_account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type EnableOrganizationAdminAccountInputOperationOutputAlias =
    crate::operation::EnableOrganizationAdminAccount;
#[doc(hidden)]
pub type EnableOrganizationAdminAccountInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl EnableOrganizationAdminAccountInput {
    /// Consumes the builder and constructs an Operation<[`EnableOrganizationAdminAccount`](crate::operation::EnableOrganizationAdminAccount)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnableOrganizationAdminAccount,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::EnableOrganizationAdminAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/admin/enable").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::EnableOrganizationAdminAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::EnableOrganizationAdminAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_enable_organization_admin_account(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnableOrganizationAdminAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnableOrganizationAdminAccount",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`EnableOrganizationAdminAccountInput`](crate::input::EnableOrganizationAdminAccountInput)
    pub fn builder() -> crate::input::enable_organization_admin_account_input::Builder {
        crate::input::enable_organization_admin_account_input::Builder::default()
    }
}

/// See [`GetDetectorInput`](crate::input::GetDetectorInput)
pub mod get_detector_input {
    /// A builder for [`GetDetectorInput`](crate::input::GetDetectorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the detector that you want to get.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the detector that you want to get.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDetectorInput`](crate::input::GetDetectorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDetectorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDetectorInput {
                detector_id: self.detector_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDetectorInputOperationOutputAlias = crate::operation::GetDetector;
#[doc(hidden)]
pub type GetDetectorInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDetectorInput {
    /// Consumes the builder and constructs an Operation<[`GetDetector`](crate::operation::GetDetector)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDetector,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDetectorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_24 = &_input.detector_id;
            let input_24 =
                input_24
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_24, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/detector/{DetectorId}", DetectorId = detector_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDetectorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDetectorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDetector::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDetector",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDetectorInput`](crate::input::GetDetectorInput)
    pub fn builder() -> crate::input::get_detector_input::Builder {
        crate::input::get_detector_input::Builder::default()
    }
}

/// See [`GetFilterInput`](crate::input::GetFilterInput)
pub mod get_filter_input {
    /// A builder for [`GetFilterInput`](crate::input::GetFilterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) filter_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the detector that the filter is associated with.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the detector that the filter is associated with.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The name of the filter you want to get.</p>
        pub fn filter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter_name = Some(input.into());
            self
        }
        /// <p>The name of the filter you want to get.</p>
        pub fn set_filter_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.filter_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFilterInput`](crate::input::GetFilterInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetFilterInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetFilterInput {
                detector_id: self.detector_id,
                filter_name: self.filter_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFilterInputOperationOutputAlias = crate::operation::GetFilter;
#[doc(hidden)]
pub type GetFilterInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetFilterInput {
    /// Consumes the builder and constructs an Operation<[`GetFilter`](crate::operation::GetFilter)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFilter,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetFilterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_25 = &_input.detector_id;
            let input_25 =
                input_25
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_25, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_26 = &_input.filter_name;
            let input_26 =
                input_26
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "filter_name",
                        details: "cannot be empty or unset",
                    })?;
            let filter_name = aws_smithy_http::label::fmt_string(input_26, false);
            if filter_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "filter_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/filter/{FilterName}",
                DetectorId = detector_id,
                FilterName = filter_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetFilterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetFilterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetFilter::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetFilter",
                    "guardduty",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetFilterInput`](crate::input::GetFilterInput)
    pub fn builder() -> crate::input::get_filter_input::Builder {
        crate::input::get_filter_input::Builder::default()
    }
}

/// See [`GetFindingsInput`](crate::input::GetFindingsInput)
pub mod get_findings_input {
    /// A builder for [`GetFindingsInput`](crate::input::GetFindingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) finding_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) sort_criteria: std::option::Option<crate::model::SortCriteria>,
    }
    impl Builder {
        /// <p>The ID of the detector that specifies the GuardDuty service whose findings you want to retrieve.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The ID of the detector that specifies the GuardDuty service whose findings you want to retrieve.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// Appends an item to `finding_ids`.
        ///
        /// To override the contents of this collection use [`set_finding_ids`](Self::set_finding_ids).
        ///
        /// <p>The IDs of the findings that you want to retrieve.</p>
        pub fn finding_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.finding_ids.unwrap_or_default();
            v.push(input.into());
            self.finding_ids = Some(v);
            self
        }
        /// <p>The IDs of the findings that you want to retrieve.</p>
        pub fn set_finding_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.finding_ids = input;
            self
        }
        /// <p>Represents the criteria used for sorting findings.</p>
        pub fn sort_criteria(mut self, input: crate::model::SortCriteria) -> Self {
            self.sort_criteria = Some(input);
            self
        }
        /// <p>Represents the criteria used for sorting findings.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<crate::model::SortCriteria>,
        ) -> Self {
            self.sort_criteria = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFindingsInput`](crate::input::GetFindingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFindingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFindingsInput {
                detector_id: self.detector_id,
                finding_ids: self.finding_ids,
                sort_criteria: self.sort_criteria,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFindingsInputOperationOutputAlias = crate::operation::GetFindings;
#[doc(hidden)]
pub type GetFindingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetFindingsInput {
    /// Consumes the builder and constructs an Operation<[`GetFindings`](crate::operation::GetFindings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFindings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetFindingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_27 = &_input.detector_id;
            let input_27 =
                input_27
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_27, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/findings/get",
                DetectorId = detector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetFindingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetFindingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_findings(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFindings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFindings",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetFindingsInput`](crate::input::GetFindingsInput)
    pub fn builder() -> crate::input::get_findings_input::Builder {
        crate::input::get_findings_input::Builder::default()
    }
}

/// See [`GetFindingsStatisticsInput`](crate::input::GetFindingsStatisticsInput)
pub mod get_findings_statistics_input {
    /// A builder for [`GetFindingsStatisticsInput`](crate::input::GetFindingsStatisticsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) finding_statistic_types:
            std::option::Option<std::vec::Vec<crate::model::FindingStatisticType>>,
        pub(crate) finding_criteria: std::option::Option<crate::model::FindingCriteria>,
    }
    impl Builder {
        /// <p>The ID of the detector that specifies the GuardDuty service whose findings' statistics you want to retrieve.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The ID of the detector that specifies the GuardDuty service whose findings' statistics you want to retrieve.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// Appends an item to `finding_statistic_types`.
        ///
        /// To override the contents of this collection use [`set_finding_statistic_types`](Self::set_finding_statistic_types).
        ///
        /// <p>The types of finding statistics to retrieve.</p>
        pub fn finding_statistic_types(
            mut self,
            input: crate::model::FindingStatisticType,
        ) -> Self {
            let mut v = self.finding_statistic_types.unwrap_or_default();
            v.push(input);
            self.finding_statistic_types = Some(v);
            self
        }
        /// <p>The types of finding statistics to retrieve.</p>
        pub fn set_finding_statistic_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FindingStatisticType>>,
        ) -> Self {
            self.finding_statistic_types = input;
            self
        }
        /// <p>Represents the criteria that is used for querying findings.</p>
        pub fn finding_criteria(mut self, input: crate::model::FindingCriteria) -> Self {
            self.finding_criteria = Some(input);
            self
        }
        /// <p>Represents the criteria that is used for querying findings.</p>
        pub fn set_finding_criteria(
            mut self,
            input: std::option::Option<crate::model::FindingCriteria>,
        ) -> Self {
            self.finding_criteria = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFindingsStatisticsInput`](crate::input::GetFindingsStatisticsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFindingsStatisticsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFindingsStatisticsInput {
                detector_id: self.detector_id,
                finding_statistic_types: self.finding_statistic_types,
                finding_criteria: self.finding_criteria,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFindingsStatisticsInputOperationOutputAlias = crate::operation::GetFindingsStatistics;
#[doc(hidden)]
pub type GetFindingsStatisticsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetFindingsStatisticsInput {
    /// Consumes the builder and constructs an Operation<[`GetFindingsStatistics`](crate::operation::GetFindingsStatistics)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFindingsStatistics,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetFindingsStatisticsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_28 = &_input.detector_id;
            let input_28 =
                input_28
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_28, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/findings/statistics",
                DetectorId = detector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetFindingsStatisticsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetFindingsStatisticsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_findings_statistics(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFindingsStatistics::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFindingsStatistics",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetFindingsStatisticsInput`](crate::input::GetFindingsStatisticsInput)
    pub fn builder() -> crate::input::get_findings_statistics_input::Builder {
        crate::input::get_findings_statistics_input::Builder::default()
    }
}

/// See [`GetInvitationsCountInput`](crate::input::GetInvitationsCountInput)
pub mod get_invitations_count_input {
    /// A builder for [`GetInvitationsCountInput`](crate::input::GetInvitationsCountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetInvitationsCountInput`](crate::input::GetInvitationsCountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetInvitationsCountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetInvitationsCountInput {})
        }
    }
}
#[doc(hidden)]
pub type GetInvitationsCountInputOperationOutputAlias = crate::operation::GetInvitationsCount;
#[doc(hidden)]
pub type GetInvitationsCountInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetInvitationsCountInput {
    /// Consumes the builder and constructs an Operation<[`GetInvitationsCount`](crate::operation::GetInvitationsCount)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetInvitationsCount,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetInvitationsCountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/invitation/count").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetInvitationsCountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetInvitationsCountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetInvitationsCount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetInvitationsCount",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetInvitationsCountInput`](crate::input::GetInvitationsCountInput)
    pub fn builder() -> crate::input::get_invitations_count_input::Builder {
        crate::input::get_invitations_count_input::Builder::default()
    }
}

/// See [`GetIpSetInput`](crate::input::GetIpSetInput)
pub mod get_ip_set_input {
    /// A builder for [`GetIpSetInput`](crate::input::GetIpSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) ip_set_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the detector that the IPSet is associated with.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the detector that the IPSet is associated with.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The unique ID of the IPSet to retrieve.</p>
        pub fn ip_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_set_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the IPSet to retrieve.</p>
        pub fn set_ip_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_set_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIpSetInput`](crate::input::GetIpSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetIpSetInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetIpSetInput {
                detector_id: self.detector_id,
                ip_set_id: self.ip_set_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetIpSetInputOperationOutputAlias = crate::operation::GetIPSet;
#[doc(hidden)]
pub type GetIpSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetIpSetInput {
    /// Consumes the builder and constructs an Operation<[`GetIPSet`](crate::operation::GetIPSet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetIPSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetIpSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_29 = &_input.detector_id;
            let input_29 =
                input_29
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_29, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_30 = &_input.ip_set_id;
            let input_30 =
                input_30
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "ip_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let ip_set_id = aws_smithy_http::label::fmt_string(input_30, false);
            if ip_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "ip_set_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/ipset/{IpSetId}",
                DetectorId = detector_id,
                IpSetId = ip_set_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetIpSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetIpSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetIPSet::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetIPSet",
                    "guardduty",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetIpSetInput`](crate::input::GetIpSetInput)
    pub fn builder() -> crate::input::get_ip_set_input::Builder {
        crate::input::get_ip_set_input::Builder::default()
    }
}

/// See [`GetMasterAccountInput`](crate::input::GetMasterAccountInput)
pub mod get_master_account_input {
    /// A builder for [`GetMasterAccountInput`](crate::input::GetMasterAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the detector of the GuardDuty member account.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the detector of the GuardDuty member account.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMasterAccountInput`](crate::input::GetMasterAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMasterAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMasterAccountInput {
                detector_id: self.detector_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMasterAccountInputOperationOutputAlias = crate::operation::GetMasterAccount;
#[doc(hidden)]
pub type GetMasterAccountInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetMasterAccountInput {
    /// Consumes the builder and constructs an Operation<[`GetMasterAccount`](crate::operation::GetMasterAccount)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMasterAccount,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMasterAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_31 = &_input.detector_id;
            let input_31 =
                input_31
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_31, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/master",
                DetectorId = detector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMasterAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMasterAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMasterAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMasterAccount",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMasterAccountInput`](crate::input::GetMasterAccountInput)
    pub fn builder() -> crate::input::get_master_account_input::Builder {
        crate::input::get_master_account_input::Builder::default()
    }
}

/// See [`GetMemberDetectorsInput`](crate::input::GetMemberDetectorsInput)
pub mod get_member_detectors_input {
    /// A builder for [`GetMemberDetectorsInput`](crate::input::GetMemberDetectorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The detector ID for the administrator account.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The detector ID for the administrator account.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The account ID of the member account.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>The account ID of the member account.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMemberDetectorsInput`](crate::input::GetMemberDetectorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMemberDetectorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMemberDetectorsInput {
                detector_id: self.detector_id,
                account_ids: self.account_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMemberDetectorsInputOperationOutputAlias = crate::operation::GetMemberDetectors;
#[doc(hidden)]
pub type GetMemberDetectorsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetMemberDetectorsInput {
    /// Consumes the builder and constructs an Operation<[`GetMemberDetectors`](crate::operation::GetMemberDetectors)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMemberDetectors,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMemberDetectorsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_32 = &_input.detector_id;
            let input_32 =
                input_32
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_32, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/member/detector/get",
                DetectorId = detector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMemberDetectorsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMemberDetectorsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_member_detectors(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMemberDetectors::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMemberDetectors",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMemberDetectorsInput`](crate::input::GetMemberDetectorsInput)
    pub fn builder() -> crate::input::get_member_detectors_input::Builder {
        crate::input::get_member_detectors_input::Builder::default()
    }
}

/// See [`GetMembersInput`](crate::input::GetMembersInput)
pub mod get_members_input {
    /// A builder for [`GetMembersInput`](crate::input::GetMembersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The unique ID of the detector of the GuardDuty account whose members you want to retrieve.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the detector of the GuardDuty account whose members you want to retrieve.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>A list of account IDs of the GuardDuty member accounts that you want to describe.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>A list of account IDs of the GuardDuty member accounts that you want to describe.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMembersInput`](crate::input::GetMembersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMembersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMembersInput {
                detector_id: self.detector_id,
                account_ids: self.account_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMembersInputOperationOutputAlias = crate::operation::GetMembers;
#[doc(hidden)]
pub type GetMembersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetMembersInput {
    /// Consumes the builder and constructs an Operation<[`GetMembers`](crate::operation::GetMembers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMembers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMembersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_33 = &_input.detector_id;
            let input_33 =
                input_33
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_33, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/member/get",
                DetectorId = detector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMembersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMembersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_members(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMembers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMembers",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMembersInput`](crate::input::GetMembersInput)
    pub fn builder() -> crate::input::get_members_input::Builder {
        crate::input::get_members_input::Builder::default()
    }
}

/// See [`GetThreatIntelSetInput`](crate::input::GetThreatIntelSetInput)
pub mod get_threat_intel_set_input {
    /// A builder for [`GetThreatIntelSetInput`](crate::input::GetThreatIntelSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) threat_intel_set_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the detector that the threatIntelSet is associated with.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the detector that the threatIntelSet is associated with.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The unique ID of the threatIntelSet that you want to get.</p>
        pub fn threat_intel_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.threat_intel_set_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the threatIntelSet that you want to get.</p>
        pub fn set_threat_intel_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.threat_intel_set_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetThreatIntelSetInput`](crate::input::GetThreatIntelSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetThreatIntelSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetThreatIntelSetInput {
                detector_id: self.detector_id,
                threat_intel_set_id: self.threat_intel_set_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetThreatIntelSetInputOperationOutputAlias = crate::operation::GetThreatIntelSet;
#[doc(hidden)]
pub type GetThreatIntelSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetThreatIntelSetInput {
    /// Consumes the builder and constructs an Operation<[`GetThreatIntelSet`](crate::operation::GetThreatIntelSet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetThreatIntelSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetThreatIntelSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_34 = &_input.detector_id;
            let input_34 =
                input_34
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_34, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_35 = &_input.threat_intel_set_id;
            let input_35 =
                input_35
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "threat_intel_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let threat_intel_set_id = aws_smithy_http::label::fmt_string(input_35, false);
            if threat_intel_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "threat_intel_set_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/threatintelset/{ThreatIntelSetId}",
                DetectorId = detector_id,
                ThreatIntelSetId = threat_intel_set_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetThreatIntelSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetThreatIntelSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetThreatIntelSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetThreatIntelSet",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetThreatIntelSetInput`](crate::input::GetThreatIntelSetInput)
    pub fn builder() -> crate::input::get_threat_intel_set_input::Builder {
        crate::input::get_threat_intel_set_input::Builder::default()
    }
}

/// See [`GetUsageStatisticsInput`](crate::input::GetUsageStatisticsInput)
pub mod get_usage_statistics_input {
    /// A builder for [`GetUsageStatisticsInput`](crate::input::GetUsageStatisticsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) usage_statistic_type: std::option::Option<crate::model::UsageStatisticType>,
        pub(crate) usage_criteria: std::option::Option<crate::model::UsageCriteria>,
        pub(crate) unit: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the detector that specifies the GuardDuty service whose usage statistics you want to retrieve.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The ID of the detector that specifies the GuardDuty service whose usage statistics you want to retrieve.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The type of usage statistics to retrieve.</p>
        pub fn usage_statistic_type(mut self, input: crate::model::UsageStatisticType) -> Self {
            self.usage_statistic_type = Some(input);
            self
        }
        /// <p>The type of usage statistics to retrieve.</p>
        pub fn set_usage_statistic_type(
            mut self,
            input: std::option::Option<crate::model::UsageStatisticType>,
        ) -> Self {
            self.usage_statistic_type = input;
            self
        }
        /// <p>Represents the criteria used for querying usage.</p>
        pub fn usage_criteria(mut self, input: crate::model::UsageCriteria) -> Self {
            self.usage_criteria = Some(input);
            self
        }
        /// <p>Represents the criteria used for querying usage.</p>
        pub fn set_usage_criteria(
            mut self,
            input: std::option::Option<crate::model::UsageCriteria>,
        ) -> Self {
            self.usage_criteria = input;
            self
        }
        /// <p>The currency unit you would like to view your usage statistics in. Current valid values are USD.</p>
        pub fn unit(mut self, input: impl Into<std::string::String>) -> Self {
            self.unit = Some(input.into());
            self
        }
        /// <p>The currency unit you would like to view your usage statistics in. Current valid values are USD.</p>
        pub fn set_unit(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.unit = input;
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the NextToken value returned from the previous request to continue listing results after the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the NextToken value returned from the previous request to continue listing results after the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUsageStatisticsInput`](crate::input::GetUsageStatisticsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetUsageStatisticsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetUsageStatisticsInput {
                detector_id: self.detector_id,
                usage_statistic_type: self.usage_statistic_type,
                usage_criteria: self.usage_criteria,
                unit: self.unit,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetUsageStatisticsInputOperationOutputAlias = crate::operation::GetUsageStatistics;
#[doc(hidden)]
pub type GetUsageStatisticsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetUsageStatisticsInput {
    /// Consumes the builder and constructs an Operation<[`GetUsageStatistics`](crate::operation::GetUsageStatistics)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetUsageStatistics,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetUsageStatisticsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_36 = &_input.detector_id;
            let input_36 =
                input_36
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_36, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/usage/statistics",
                DetectorId = detector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetUsageStatisticsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetUsageStatisticsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_usage_statistics(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetUsageStatistics::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetUsageStatistics",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetUsageStatisticsInput`](crate::input::GetUsageStatisticsInput)
    pub fn builder() -> crate::input::get_usage_statistics_input::Builder {
        crate::input::get_usage_statistics_input::Builder::default()
    }
}

/// See [`InviteMembersInput`](crate::input::InviteMembersInput)
pub mod invite_members_input {
    /// A builder for [`InviteMembersInput`](crate::input::InviteMembersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) disable_email_notification: std::option::Option<bool>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the detector of the GuardDuty account that you want to invite members with.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the detector of the GuardDuty account that you want to invite members with.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>A list of account IDs of the accounts that you want to invite to GuardDuty as members.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>A list of account IDs of the accounts that you want to invite to GuardDuty as members.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// <p>A Boolean value that specifies whether you want to disable email notification to the accounts that you are inviting to GuardDuty as members.</p>
        pub fn disable_email_notification(mut self, input: bool) -> Self {
            self.disable_email_notification = Some(input);
            self
        }
        /// <p>A Boolean value that specifies whether you want to disable email notification to the accounts that you are inviting to GuardDuty as members.</p>
        pub fn set_disable_email_notification(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_email_notification = input;
            self
        }
        /// <p>The invitation message that you want to send to the accounts that you're inviting to GuardDuty as members.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The invitation message that you want to send to the accounts that you're inviting to GuardDuty as members.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InviteMembersInput`](crate::input::InviteMembersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::InviteMembersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::InviteMembersInput {
                detector_id: self.detector_id,
                account_ids: self.account_ids,
                disable_email_notification: self.disable_email_notification.unwrap_or_default(),
                message: self.message,
            })
        }
    }
}
#[doc(hidden)]
pub type InviteMembersInputOperationOutputAlias = crate::operation::InviteMembers;
#[doc(hidden)]
pub type InviteMembersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl InviteMembersInput {
    /// Consumes the builder and constructs an Operation<[`InviteMembers`](crate::operation::InviteMembers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::InviteMembers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::InviteMembersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_37 = &_input.detector_id;
            let input_37 =
                input_37
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_37, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/member/invite",
                DetectorId = detector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::InviteMembersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::InviteMembersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_invite_members(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::InviteMembers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "InviteMembers",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`InviteMembersInput`](crate::input::InviteMembersInput)
    pub fn builder() -> crate::input::invite_members_input::Builder {
        crate::input::invite_members_input::Builder::default()
    }
}

/// See [`ListDetectorsInput`](crate::input::ListDetectorsInput)
pub mod list_detectors_input {
    /// A builder for [`ListDetectorsInput`](crate::input::ListDetectorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 50. The maximum value is 50.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 50. The maximum value is 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDetectorsInput`](crate::input::ListDetectorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDetectorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDetectorsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDetectorsInputOperationOutputAlias = crate::operation::ListDetectors;
#[doc(hidden)]
pub type ListDetectorsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDetectorsInput {
    /// Consumes the builder and constructs an Operation<[`ListDetectors`](crate::operation::ListDetectors)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDetectors,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDetectorsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/detector").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListDetectorsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_38) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_38));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDetectorsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDetectorsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDetectors::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDetectors",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDetectorsInput`](crate::input::ListDetectorsInput)
    pub fn builder() -> crate::input::list_detectors_input::Builder {
        crate::input::list_detectors_input::Builder::default()
    }
}

/// See [`ListFiltersInput`](crate::input::ListFiltersInput)
pub mod list_filters_input {
    /// A builder for [`ListFiltersInput`](crate::input::ListFiltersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the detector that the filter is associated with.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the detector that the filter is associated with.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 50. The maximum value is 50.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 50. The maximum value is 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFiltersInput`](crate::input::ListFiltersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFiltersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFiltersInput {
                detector_id: self.detector_id,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFiltersInputOperationOutputAlias = crate::operation::ListFilters;
#[doc(hidden)]
pub type ListFiltersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListFiltersInput {
    /// Consumes the builder and constructs an Operation<[`ListFilters`](crate::operation::ListFilters)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFilters,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFiltersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_39 = &_input.detector_id;
            let input_39 =
                input_39
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_39, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/filter",
                DetectorId = detector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListFiltersInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_40) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_40));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFiltersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFiltersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFilters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFilters",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFiltersInput`](crate::input::ListFiltersInput)
    pub fn builder() -> crate::input::list_filters_input::Builder {
        crate::input::list_filters_input::Builder::default()
    }
}

/// See [`ListFindingsInput`](crate::input::ListFindingsInput)
pub mod list_findings_input {
    /// A builder for [`ListFindingsInput`](crate::input::ListFindingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) finding_criteria: std::option::Option<crate::model::FindingCriteria>,
        pub(crate) sort_criteria: std::option::Option<crate::model::SortCriteria>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the detector that specifies the GuardDuty service whose findings you want to list.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The ID of the detector that specifies the GuardDuty service whose findings you want to list.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>Represents the criteria used for querying findings. Valid values include:</p>
        /// <ul>
        /// <li> <p>JSON field name</p> </li>
        /// <li> <p>accountId</p> </li>
        /// <li> <p>region</p> </li>
        /// <li> <p>confidence</p> </li>
        /// <li> <p>id</p> </li>
        /// <li> <p>resource.accessKeyDetails.accessKeyId</p> </li>
        /// <li> <p>resource.accessKeyDetails.principalId</p> </li>
        /// <li> <p>resource.accessKeyDetails.userName</p> </li>
        /// <li> <p>resource.accessKeyDetails.userType</p> </li>
        /// <li> <p>resource.instanceDetails.iamInstanceProfile.id</p> </li>
        /// <li> <p>resource.instanceDetails.imageId</p> </li>
        /// <li> <p>resource.instanceDetails.instanceId</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.ipv6Addresses</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.publicDnsName</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.publicIp</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.securityGroups.groupId</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.securityGroups.groupName</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.subnetId</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.vpcId</p> </li>
        /// <li> <p>resource.instanceDetails.tags.key</p> </li>
        /// <li> <p>resource.instanceDetails.tags.value</p> </li>
        /// <li> <p>resource.resourceType</p> </li>
        /// <li> <p>service.action.actionType</p> </li>
        /// <li> <p>service.action.awsApiCallAction.api</p> </li>
        /// <li> <p>service.action.awsApiCallAction.callerType</p> </li>
        /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.city.cityName</p> </li>
        /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.country.countryName</p> </li>
        /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.ipAddressV4</p> </li>
        /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.organization.asn</p> </li>
        /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg</p> </li>
        /// <li> <p>service.action.awsApiCallAction.serviceName</p> </li>
        /// <li> <p>service.action.dnsRequestAction.domain</p> </li>
        /// <li> <p>service.action.networkConnectionAction.blocked</p> </li>
        /// <li> <p>service.action.networkConnectionAction.connectionDirection</p> </li>
        /// <li> <p>service.action.networkConnectionAction.localPortDetails.port</p> </li>
        /// <li> <p>service.action.networkConnectionAction.protocol</p> </li>
        /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.country.countryName</p> </li>
        /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.ipAddressV4</p> </li>
        /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.organization.asn</p> </li>
        /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg</p> </li>
        /// <li> <p>service.action.networkConnectionAction.remotePortDetails.port</p> </li>
        /// <li> <p>service.additionalInfo.threatListName</p> </li>
        /// <li> <p>service.archived</p> <p>When this attribute is set to 'true', only archived findings are listed. When it's set to 'false', only unarchived findings are listed. When this attribute is not set, all existing findings are listed.</p> </li>
        /// <li> <p>service.resourceRole</p> </li>
        /// <li> <p>severity</p> </li>
        /// <li> <p>type</p> </li>
        /// <li> <p>updatedAt</p> <p>Type: Timestamp in Unix Epoch millisecond format: 1486685375000</p> </li>
        /// </ul>
        pub fn finding_criteria(mut self, input: crate::model::FindingCriteria) -> Self {
            self.finding_criteria = Some(input);
            self
        }
        /// <p>Represents the criteria used for querying findings. Valid values include:</p>
        /// <ul>
        /// <li> <p>JSON field name</p> </li>
        /// <li> <p>accountId</p> </li>
        /// <li> <p>region</p> </li>
        /// <li> <p>confidence</p> </li>
        /// <li> <p>id</p> </li>
        /// <li> <p>resource.accessKeyDetails.accessKeyId</p> </li>
        /// <li> <p>resource.accessKeyDetails.principalId</p> </li>
        /// <li> <p>resource.accessKeyDetails.userName</p> </li>
        /// <li> <p>resource.accessKeyDetails.userType</p> </li>
        /// <li> <p>resource.instanceDetails.iamInstanceProfile.id</p> </li>
        /// <li> <p>resource.instanceDetails.imageId</p> </li>
        /// <li> <p>resource.instanceDetails.instanceId</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.ipv6Addresses</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.publicDnsName</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.publicIp</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.securityGroups.groupId</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.securityGroups.groupName</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.subnetId</p> </li>
        /// <li> <p>resource.instanceDetails.networkInterfaces.vpcId</p> </li>
        /// <li> <p>resource.instanceDetails.tags.key</p> </li>
        /// <li> <p>resource.instanceDetails.tags.value</p> </li>
        /// <li> <p>resource.resourceType</p> </li>
        /// <li> <p>service.action.actionType</p> </li>
        /// <li> <p>service.action.awsApiCallAction.api</p> </li>
        /// <li> <p>service.action.awsApiCallAction.callerType</p> </li>
        /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.city.cityName</p> </li>
        /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.country.countryName</p> </li>
        /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.ipAddressV4</p> </li>
        /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.organization.asn</p> </li>
        /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg</p> </li>
        /// <li> <p>service.action.awsApiCallAction.serviceName</p> </li>
        /// <li> <p>service.action.dnsRequestAction.domain</p> </li>
        /// <li> <p>service.action.networkConnectionAction.blocked</p> </li>
        /// <li> <p>service.action.networkConnectionAction.connectionDirection</p> </li>
        /// <li> <p>service.action.networkConnectionAction.localPortDetails.port</p> </li>
        /// <li> <p>service.action.networkConnectionAction.protocol</p> </li>
        /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.country.countryName</p> </li>
        /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.ipAddressV4</p> </li>
        /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.organization.asn</p> </li>
        /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg</p> </li>
        /// <li> <p>service.action.networkConnectionAction.remotePortDetails.port</p> </li>
        /// <li> <p>service.additionalInfo.threatListName</p> </li>
        /// <li> <p>service.archived</p> <p>When this attribute is set to 'true', only archived findings are listed. When it's set to 'false', only unarchived findings are listed. When this attribute is not set, all existing findings are listed.</p> </li>
        /// <li> <p>service.resourceRole</p> </li>
        /// <li> <p>severity</p> </li>
        /// <li> <p>type</p> </li>
        /// <li> <p>updatedAt</p> <p>Type: Timestamp in Unix Epoch millisecond format: 1486685375000</p> </li>
        /// </ul>
        pub fn set_finding_criteria(
            mut self,
            input: std::option::Option<crate::model::FindingCriteria>,
        ) -> Self {
            self.finding_criteria = input;
            self
        }
        /// <p>Represents the criteria used for sorting findings.</p>
        pub fn sort_criteria(mut self, input: crate::model::SortCriteria) -> Self {
            self.sort_criteria = Some(input);
            self
        }
        /// <p>Represents the criteria used for sorting findings.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<crate::model::SortCriteria>,
        ) -> Self {
            self.sort_criteria = input;
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 50. The maximum value is 50.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 50. The maximum value is 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFindingsInput`](crate::input::ListFindingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFindingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFindingsInput {
                detector_id: self.detector_id,
                finding_criteria: self.finding_criteria,
                sort_criteria: self.sort_criteria,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFindingsInputOperationOutputAlias = crate::operation::ListFindings;
#[doc(hidden)]
pub type ListFindingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListFindingsInput {
    /// Consumes the builder and constructs an Operation<[`ListFindings`](crate::operation::ListFindings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFindings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFindingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_41 = &_input.detector_id;
            let input_41 =
                input_41
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_41, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/findings",
                DetectorId = detector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFindingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFindingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_findings(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFindings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFindings",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFindingsInput`](crate::input::ListFindingsInput)
    pub fn builder() -> crate::input::list_findings_input::Builder {
        crate::input::list_findings_input::Builder::default()
    }
}

/// See [`ListInvitationsInput`](crate::input::ListInvitationsInput)
pub mod list_invitations_input {
    /// A builder for [`ListInvitationsInput`](crate::input::ListInvitationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 50. The maximum value is 50.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 50. The maximum value is 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInvitationsInput`](crate::input::ListInvitationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListInvitationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListInvitationsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListInvitationsInputOperationOutputAlias = crate::operation::ListInvitations;
#[doc(hidden)]
pub type ListInvitationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListInvitationsInput {
    /// Consumes the builder and constructs an Operation<[`ListInvitations`](crate::operation::ListInvitations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListInvitations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListInvitationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/invitation").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListInvitationsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_42) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_42));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListInvitationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListInvitationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListInvitations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListInvitations",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListInvitationsInput`](crate::input::ListInvitationsInput)
    pub fn builder() -> crate::input::list_invitations_input::Builder {
        crate::input::list_invitations_input::Builder::default()
    }
}

/// See [`ListIpSetsInput`](crate::input::ListIpSetsInput)
pub mod list_ip_sets_input {
    /// A builder for [`ListIpSetsInput`](crate::input::ListIpSetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the detector that the IPSet is associated with.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the detector that the IPSet is associated with.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 50. The maximum value is 50.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 50. The maximum value is 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIpSetsInput`](crate::input::ListIpSetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListIpSetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListIpSetsInput {
                detector_id: self.detector_id,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListIpSetsInputOperationOutputAlias = crate::operation::ListIPSets;
#[doc(hidden)]
pub type ListIpSetsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListIpSetsInput {
    /// Consumes the builder and constructs an Operation<[`ListIPSets`](crate::operation::ListIPSets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListIPSets,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListIpSetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_43 = &_input.detector_id;
            let input_43 =
                input_43
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_43, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/ipset",
                DetectorId = detector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListIpSetsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_44) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_44));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListIpSetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListIpSetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListIPSets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListIPSets",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListIpSetsInput`](crate::input::ListIpSetsInput)
    pub fn builder() -> crate::input::list_ip_sets_input::Builder {
        crate::input::list_ip_sets_input::Builder::default()
    }
}

/// See [`ListMembersInput`](crate::input::ListMembersInput)
pub mod list_members_input {
    /// A builder for [`ListMembersInput`](crate::input::ListMembersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) only_associated: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the detector the member is associated with.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the detector the member is associated with.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 50. The maximum value is 50.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 50. The maximum value is 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Specifies whether to only return associated members or to return all members (including members who haven't been invited yet or have been disassociated).</p>
        pub fn only_associated(mut self, input: impl Into<std::string::String>) -> Self {
            self.only_associated = Some(input.into());
            self
        }
        /// <p>Specifies whether to only return associated members or to return all members (including members who haven't been invited yet or have been disassociated).</p>
        pub fn set_only_associated(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.only_associated = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMembersInput`](crate::input::ListMembersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListMembersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListMembersInput {
                detector_id: self.detector_id,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                only_associated: self.only_associated,
            })
        }
    }
}
#[doc(hidden)]
pub type ListMembersInputOperationOutputAlias = crate::operation::ListMembers;
#[doc(hidden)]
pub type ListMembersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListMembersInput {
    /// Consumes the builder and constructs an Operation<[`ListMembers`](crate::operation::ListMembers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListMembers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListMembersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_45 = &_input.detector_id;
            let input_45 =
                input_45
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_45, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/member",
                DetectorId = detector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListMembersInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_46) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_46));
            }
            if let Some(inner_47) = &_input.only_associated {
                query.push_kv(
                    "onlyAssociated",
                    &aws_smithy_http::query::fmt_string(&inner_47),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListMembersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListMembersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListMembers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListMembers",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListMembersInput`](crate::input::ListMembersInput)
    pub fn builder() -> crate::input::list_members_input::Builder {
        crate::input::list_members_input::Builder::default()
    }
}

/// See [`ListOrganizationAdminAccountsInput`](crate::input::ListOrganizationAdminAccountsInput)
pub mod list_organization_admin_accounts_input {
    /// A builder for [`ListOrganizationAdminAccountsInput`](crate::input::ListOrganizationAdminAccountsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOrganizationAdminAccountsInput`](crate::input::ListOrganizationAdminAccountsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListOrganizationAdminAccountsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListOrganizationAdminAccountsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListOrganizationAdminAccountsInputOperationOutputAlias =
    crate::operation::ListOrganizationAdminAccounts;
#[doc(hidden)]
pub type ListOrganizationAdminAccountsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListOrganizationAdminAccountsInput {
    /// Consumes the builder and constructs an Operation<[`ListOrganizationAdminAccounts`](crate::operation::ListOrganizationAdminAccounts)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListOrganizationAdminAccounts,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListOrganizationAdminAccountsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/admin").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListOrganizationAdminAccountsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_48) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_48));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListOrganizationAdminAccountsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListOrganizationAdminAccountsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListOrganizationAdminAccounts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListOrganizationAdminAccounts",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListOrganizationAdminAccountsInput`](crate::input::ListOrganizationAdminAccountsInput)
    pub fn builder() -> crate::input::list_organization_admin_accounts_input::Builder {
        crate::input::list_organization_admin_accounts_input::Builder::default()
    }
}

/// See [`ListPublishingDestinationsInput`](crate::input::ListPublishingDestinationsInput)
pub mod list_publishing_destinations_input {
    /// A builder for [`ListPublishingDestinationsInput`](crate::input::ListPublishingDestinationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the detector to retrieve publishing destinations for.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The ID of the detector to retrieve publishing destinations for.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPublishingDestinationsInput`](crate::input::ListPublishingDestinationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPublishingDestinationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPublishingDestinationsInput {
                detector_id: self.detector_id,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPublishingDestinationsInputOperationOutputAlias =
    crate::operation::ListPublishingDestinations;
#[doc(hidden)]
pub type ListPublishingDestinationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPublishingDestinationsInput {
    /// Consumes the builder and constructs an Operation<[`ListPublishingDestinations`](crate::operation::ListPublishingDestinations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPublishingDestinations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPublishingDestinationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_49 = &_input.detector_id;
            let input_49 =
                input_49
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_49, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/publishingDestination",
                DetectorId = detector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListPublishingDestinationsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_50) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_50));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPublishingDestinationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPublishingDestinationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPublishingDestinations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPublishingDestinations",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPublishingDestinationsInput`](crate::input::ListPublishingDestinationsInput)
    pub fn builder() -> crate::input::list_publishing_destinations_input::Builder {
        crate::input::list_publishing_destinations_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the given GuardDuty resource. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the given GuardDuty resource. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_51 = &_input.resource_arn;
            let input_51 =
                input_51
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_51, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListThreatIntelSetsInput`](crate::input::ListThreatIntelSetsInput)
pub mod list_threat_intel_sets_input {
    /// A builder for [`ListThreatIntelSetsInput`](crate::input::ListThreatIntelSetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the detector that the threatIntelSet is associated with.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the detector that the threatIntelSet is associated with.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 50. The maximum value is 50.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 50. The maximum value is 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>You can use this parameter to paginate results in the response. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>You can use this parameter to paginate results in the response. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListThreatIntelSetsInput`](crate::input::ListThreatIntelSetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListThreatIntelSetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListThreatIntelSetsInput {
                detector_id: self.detector_id,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListThreatIntelSetsInputOperationOutputAlias = crate::operation::ListThreatIntelSets;
#[doc(hidden)]
pub type ListThreatIntelSetsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListThreatIntelSetsInput {
    /// Consumes the builder and constructs an Operation<[`ListThreatIntelSets`](crate::operation::ListThreatIntelSets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListThreatIntelSets,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListThreatIntelSetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_52 = &_input.detector_id;
            let input_52 =
                input_52
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_52, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/threatintelset",
                DetectorId = detector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListThreatIntelSetsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_53) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_53));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListThreatIntelSetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListThreatIntelSetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListThreatIntelSets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListThreatIntelSets",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListThreatIntelSetsInput`](crate::input::ListThreatIntelSetsInput)
    pub fn builder() -> crate::input::list_threat_intel_sets_input::Builder {
        crate::input::list_threat_intel_sets_input::Builder::default()
    }
}

/// See [`StartMonitoringMembersInput`](crate::input::StartMonitoringMembersInput)
pub mod start_monitoring_members_input {
    /// A builder for [`StartMonitoringMembersInput`](crate::input::StartMonitoringMembersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The unique ID of the detector of the GuardDuty administrator account associated with the member accounts to monitor.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the detector of the GuardDuty administrator account associated with the member accounts to monitor.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>A list of account IDs of the GuardDuty member accounts to start monitoring.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>A list of account IDs of the GuardDuty member accounts to start monitoring.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`StartMonitoringMembersInput`](crate::input::StartMonitoringMembersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartMonitoringMembersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartMonitoringMembersInput {
                detector_id: self.detector_id,
                account_ids: self.account_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type StartMonitoringMembersInputOperationOutputAlias = crate::operation::StartMonitoringMembers;
#[doc(hidden)]
pub type StartMonitoringMembersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartMonitoringMembersInput {
    /// Consumes the builder and constructs an Operation<[`StartMonitoringMembers`](crate::operation::StartMonitoringMembers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartMonitoringMembers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartMonitoringMembersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_54 = &_input.detector_id;
            let input_54 =
                input_54
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_54, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/member/start",
                DetectorId = detector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartMonitoringMembersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartMonitoringMembersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_monitoring_members(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartMonitoringMembers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartMonitoringMembers",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartMonitoringMembersInput`](crate::input::StartMonitoringMembersInput)
    pub fn builder() -> crate::input::start_monitoring_members_input::Builder {
        crate::input::start_monitoring_members_input::Builder::default()
    }
}

/// See [`StopMonitoringMembersInput`](crate::input::StopMonitoringMembersInput)
pub mod stop_monitoring_members_input {
    /// A builder for [`StopMonitoringMembersInput`](crate::input::StopMonitoringMembersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The unique ID of the detector associated with the GuardDuty administrator account that is monitoring member accounts.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the detector associated with the GuardDuty administrator account that is monitoring member accounts.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>A list of account IDs for the member accounts to stop monitoring.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>A list of account IDs for the member accounts to stop monitoring.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`StopMonitoringMembersInput`](crate::input::StopMonitoringMembersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopMonitoringMembersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopMonitoringMembersInput {
                detector_id: self.detector_id,
                account_ids: self.account_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type StopMonitoringMembersInputOperationOutputAlias = crate::operation::StopMonitoringMembers;
#[doc(hidden)]
pub type StopMonitoringMembersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopMonitoringMembersInput {
    /// Consumes the builder and constructs an Operation<[`StopMonitoringMembers`](crate::operation::StopMonitoringMembers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopMonitoringMembers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopMonitoringMembersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_55 = &_input.detector_id;
            let input_55 =
                input_55
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_55, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/member/stop",
                DetectorId = detector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopMonitoringMembersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopMonitoringMembersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_stop_monitoring_members(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopMonitoringMembers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopMonitoringMembers",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopMonitoringMembersInput`](crate::input::StopMonitoringMembersInput)
    pub fn builder() -> crate::input::stop_monitoring_members_input::Builder {
        crate::input::stop_monitoring_members_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the GuardDuty resource to apply a tag to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the GuardDuty resource to apply a tag to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be added to a resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to be added to a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_56 = &_input.resource_arn;
            let input_56 =
                input_56
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_56, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UnarchiveFindingsInput`](crate::input::UnarchiveFindingsInput)
pub mod unarchive_findings_input {
    /// A builder for [`UnarchiveFindingsInput`](crate::input::UnarchiveFindingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) finding_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ID of the detector associated with the findings to unarchive.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The ID of the detector associated with the findings to unarchive.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// Appends an item to `finding_ids`.
        ///
        /// To override the contents of this collection use [`set_finding_ids`](Self::set_finding_ids).
        ///
        /// <p>The IDs of the findings to unarchive.</p>
        pub fn finding_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.finding_ids.unwrap_or_default();
            v.push(input.into());
            self.finding_ids = Some(v);
            self
        }
        /// <p>The IDs of the findings to unarchive.</p>
        pub fn set_finding_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.finding_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`UnarchiveFindingsInput`](crate::input::UnarchiveFindingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UnarchiveFindingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UnarchiveFindingsInput {
                detector_id: self.detector_id,
                finding_ids: self.finding_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type UnarchiveFindingsInputOperationOutputAlias = crate::operation::UnarchiveFindings;
#[doc(hidden)]
pub type UnarchiveFindingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UnarchiveFindingsInput {
    /// Consumes the builder and constructs an Operation<[`UnarchiveFindings`](crate::operation::UnarchiveFindings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UnarchiveFindings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UnarchiveFindingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_57 = &_input.detector_id;
            let input_57 =
                input_57
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_57, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/findings/unarchive",
                DetectorId = detector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UnarchiveFindingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UnarchiveFindingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_unarchive_findings(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UnarchiveFindings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UnarchiveFindings",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UnarchiveFindingsInput`](crate::input::UnarchiveFindingsInput)
    pub fn builder() -> crate::input::unarchive_findings_input::Builder {
        crate::input::unarchive_findings_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the resource to remove tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the resource to remove tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tag keys to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_58 = &_input.resource_arn;
            let input_58 =
                input_58
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_58, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UntagResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_59) = &_input.tag_keys {
                for inner_60 in inner_59 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_60));
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateDetectorInput`](crate::input::UpdateDetectorInput)
pub mod update_detector_input {
    /// A builder for [`UpdateDetectorInput`](crate::input::UpdateDetectorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) enable: std::option::Option<bool>,
        pub(crate) finding_publishing_frequency:
            std::option::Option<crate::model::FindingPublishingFrequency>,
        pub(crate) data_sources: std::option::Option<crate::model::DataSourceConfigurations>,
    }
    impl Builder {
        /// <p>The unique ID of the detector to update.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the detector to update.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>Specifies whether the detector is enabled or not enabled.</p>
        pub fn enable(mut self, input: bool) -> Self {
            self.enable = Some(input);
            self
        }
        /// <p>Specifies whether the detector is enabled or not enabled.</p>
        pub fn set_enable(mut self, input: std::option::Option<bool>) -> Self {
            self.enable = input;
            self
        }
        /// <p>An enum value that specifies how frequently findings are exported, such as to CloudWatch Events.</p>
        pub fn finding_publishing_frequency(
            mut self,
            input: crate::model::FindingPublishingFrequency,
        ) -> Self {
            self.finding_publishing_frequency = Some(input);
            self
        }
        /// <p>An enum value that specifies how frequently findings are exported, such as to CloudWatch Events.</p>
        pub fn set_finding_publishing_frequency(
            mut self,
            input: std::option::Option<crate::model::FindingPublishingFrequency>,
        ) -> Self {
            self.finding_publishing_frequency = input;
            self
        }
        /// <p>Describes which data sources will be updated.</p>
        pub fn data_sources(mut self, input: crate::model::DataSourceConfigurations) -> Self {
            self.data_sources = Some(input);
            self
        }
        /// <p>Describes which data sources will be updated.</p>
        pub fn set_data_sources(
            mut self,
            input: std::option::Option<crate::model::DataSourceConfigurations>,
        ) -> Self {
            self.data_sources = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDetectorInput`](crate::input::UpdateDetectorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDetectorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDetectorInput {
                detector_id: self.detector_id,
                enable: self.enable.unwrap_or_default(),
                finding_publishing_frequency: self.finding_publishing_frequency,
                data_sources: self.data_sources,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDetectorInputOperationOutputAlias = crate::operation::UpdateDetector;
#[doc(hidden)]
pub type UpdateDetectorInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateDetectorInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDetector`](crate::operation::UpdateDetector)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDetector,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDetectorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_61 = &_input.detector_id;
            let input_61 =
                input_61
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_61, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/detector/{DetectorId}", DetectorId = detector_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDetectorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDetectorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_detector(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDetector::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDetector",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDetectorInput`](crate::input::UpdateDetectorInput)
    pub fn builder() -> crate::input::update_detector_input::Builder {
        crate::input::update_detector_input::Builder::default()
    }
}

/// See [`UpdateFilterInput`](crate::input::UpdateFilterInput)
pub mod update_filter_input {
    /// A builder for [`UpdateFilterInput`](crate::input::UpdateFilterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) filter_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) action: std::option::Option<crate::model::FilterAction>,
        pub(crate) rank: std::option::Option<i32>,
        pub(crate) finding_criteria: std::option::Option<crate::model::FindingCriteria>,
    }
    impl Builder {
        /// <p>The unique ID of the detector that specifies the GuardDuty service where you want to update a filter.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the detector that specifies the GuardDuty service where you want to update a filter.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The name of the filter.</p>
        pub fn filter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter_name = Some(input.into());
            self
        }
        /// <p>The name of the filter.</p>
        pub fn set_filter_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.filter_name = input;
            self
        }
        /// <p>The description of the filter.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the filter.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Specifies the action that is to be applied to the findings that match the filter.</p>
        pub fn action(mut self, input: crate::model::FilterAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>Specifies the action that is to be applied to the findings that match the filter.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::FilterAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>Specifies the position of the filter in the list of current filters. Also specifies the order in which this filter is applied to the findings.</p>
        pub fn rank(mut self, input: i32) -> Self {
            self.rank = Some(input);
            self
        }
        /// <p>Specifies the position of the filter in the list of current filters. Also specifies the order in which this filter is applied to the findings.</p>
        pub fn set_rank(mut self, input: std::option::Option<i32>) -> Self {
            self.rank = input;
            self
        }
        /// <p>Represents the criteria to be used in the filter for querying findings.</p>
        pub fn finding_criteria(mut self, input: crate::model::FindingCriteria) -> Self {
            self.finding_criteria = Some(input);
            self
        }
        /// <p>Represents the criteria to be used in the filter for querying findings.</p>
        pub fn set_finding_criteria(
            mut self,
            input: std::option::Option<crate::model::FindingCriteria>,
        ) -> Self {
            self.finding_criteria = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFilterInput`](crate::input::UpdateFilterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFilterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFilterInput {
                detector_id: self.detector_id,
                filter_name: self.filter_name,
                description: self.description,
                action: self.action,
                rank: self.rank.unwrap_or_default(),
                finding_criteria: self.finding_criteria,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFilterInputOperationOutputAlias = crate::operation::UpdateFilter;
#[doc(hidden)]
pub type UpdateFilterInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateFilterInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFilter`](crate::operation::UpdateFilter)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFilter,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateFilterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_62 = &_input.detector_id;
            let input_62 =
                input_62
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_62, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_63 = &_input.filter_name;
            let input_63 =
                input_63
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "filter_name",
                        details: "cannot be empty or unset",
                    })?;
            let filter_name = aws_smithy_http::label::fmt_string(input_63, false);
            if filter_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "filter_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/filter/{FilterName}",
                DetectorId = detector_id,
                FilterName = filter_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateFilterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateFilterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_filter(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFilter::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFilter",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateFilterInput`](crate::input::UpdateFilterInput)
    pub fn builder() -> crate::input::update_filter_input::Builder {
        crate::input::update_filter_input::Builder::default()
    }
}

/// See [`UpdateFindingsFeedbackInput`](crate::input::UpdateFindingsFeedbackInput)
pub mod update_findings_feedback_input {
    /// A builder for [`UpdateFindingsFeedbackInput`](crate::input::UpdateFindingsFeedbackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) finding_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) feedback: std::option::Option<crate::model::Feedback>,
        pub(crate) comments: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the detector associated with the findings to update feedback for.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The ID of the detector associated with the findings to update feedback for.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// Appends an item to `finding_ids`.
        ///
        /// To override the contents of this collection use [`set_finding_ids`](Self::set_finding_ids).
        ///
        /// <p>The IDs of the findings that you want to mark as useful or not useful.</p>
        pub fn finding_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.finding_ids.unwrap_or_default();
            v.push(input.into());
            self.finding_ids = Some(v);
            self
        }
        /// <p>The IDs of the findings that you want to mark as useful or not useful.</p>
        pub fn set_finding_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.finding_ids = input;
            self
        }
        /// <p>The feedback for the finding.</p>
        pub fn feedback(mut self, input: crate::model::Feedback) -> Self {
            self.feedback = Some(input);
            self
        }
        /// <p>The feedback for the finding.</p>
        pub fn set_feedback(mut self, input: std::option::Option<crate::model::Feedback>) -> Self {
            self.feedback = input;
            self
        }
        /// <p>Additional feedback about the GuardDuty findings.</p>
        pub fn comments(mut self, input: impl Into<std::string::String>) -> Self {
            self.comments = Some(input.into());
            self
        }
        /// <p>Additional feedback about the GuardDuty findings.</p>
        pub fn set_comments(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comments = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFindingsFeedbackInput`](crate::input::UpdateFindingsFeedbackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFindingsFeedbackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFindingsFeedbackInput {
                detector_id: self.detector_id,
                finding_ids: self.finding_ids,
                feedback: self.feedback,
                comments: self.comments,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFindingsFeedbackInputOperationOutputAlias = crate::operation::UpdateFindingsFeedback;
#[doc(hidden)]
pub type UpdateFindingsFeedbackInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateFindingsFeedbackInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFindingsFeedback`](crate::operation::UpdateFindingsFeedback)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFindingsFeedback,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateFindingsFeedbackInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_64 = &_input.detector_id;
            let input_64 =
                input_64
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_64, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/findings/feedback",
                DetectorId = detector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateFindingsFeedbackInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateFindingsFeedbackInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_findings_feedback(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFindingsFeedback::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFindingsFeedback",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateFindingsFeedbackInput`](crate::input::UpdateFindingsFeedbackInput)
    pub fn builder() -> crate::input::update_findings_feedback_input::Builder {
        crate::input::update_findings_feedback_input::Builder::default()
    }
}

/// See [`UpdateIpSetInput`](crate::input::UpdateIpSetInput)
pub mod update_ip_set_input {
    /// A builder for [`UpdateIpSetInput`](crate::input::UpdateIpSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) ip_set_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) activate: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The detectorID that specifies the GuardDuty service whose IPSet you want to update.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The detectorID that specifies the GuardDuty service whose IPSet you want to update.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The unique ID that specifies the IPSet that you want to update.</p>
        pub fn ip_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_set_id = Some(input.into());
            self
        }
        /// <p>The unique ID that specifies the IPSet that you want to update.</p>
        pub fn set_ip_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_set_id = input;
            self
        }
        /// <p>The unique ID that specifies the IPSet that you want to update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The unique ID that specifies the IPSet that you want to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The updated URI of the file that contains the IPSet. </p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The updated URI of the file that contains the IPSet. </p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The updated Boolean value that specifies whether the IPSet is active or not.</p>
        pub fn activate(mut self, input: bool) -> Self {
            self.activate = Some(input);
            self
        }
        /// <p>The updated Boolean value that specifies whether the IPSet is active or not.</p>
        pub fn set_activate(mut self, input: std::option::Option<bool>) -> Self {
            self.activate = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateIpSetInput`](crate::input::UpdateIpSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateIpSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateIpSetInput {
                detector_id: self.detector_id,
                ip_set_id: self.ip_set_id,
                name: self.name,
                location: self.location,
                activate: self.activate.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateIpSetInputOperationOutputAlias = crate::operation::UpdateIPSet;
#[doc(hidden)]
pub type UpdateIpSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateIpSetInput {
    /// Consumes the builder and constructs an Operation<[`UpdateIPSet`](crate::operation::UpdateIPSet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateIPSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateIpSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_65 = &_input.detector_id;
            let input_65 =
                input_65
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_65, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_66 = &_input.ip_set_id;
            let input_66 =
                input_66
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "ip_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let ip_set_id = aws_smithy_http::label::fmt_string(input_66, false);
            if ip_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "ip_set_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/ipset/{IpSetId}",
                DetectorId = detector_id,
                IpSetId = ip_set_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateIpSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateIpSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_ip_set(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateIPSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateIPSet",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateIpSetInput`](crate::input::UpdateIpSetInput)
    pub fn builder() -> crate::input::update_ip_set_input::Builder {
        crate::input::update_ip_set_input::Builder::default()
    }
}

/// See [`UpdateMemberDetectorsInput`](crate::input::UpdateMemberDetectorsInput)
pub mod update_member_detectors_input {
    /// A builder for [`UpdateMemberDetectorsInput`](crate::input::UpdateMemberDetectorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) data_sources: std::option::Option<crate::model::DataSourceConfigurations>,
    }
    impl Builder {
        /// <p>The detector ID of the administrator account.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The detector ID of the administrator account.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>A list of member account IDs to be updated.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>A list of member account IDs to be updated.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// <p>Describes which data sources will be updated.</p>
        pub fn data_sources(mut self, input: crate::model::DataSourceConfigurations) -> Self {
            self.data_sources = Some(input);
            self
        }
        /// <p>Describes which data sources will be updated.</p>
        pub fn set_data_sources(
            mut self,
            input: std::option::Option<crate::model::DataSourceConfigurations>,
        ) -> Self {
            self.data_sources = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMemberDetectorsInput`](crate::input::UpdateMemberDetectorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateMemberDetectorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateMemberDetectorsInput {
                detector_id: self.detector_id,
                account_ids: self.account_ids,
                data_sources: self.data_sources,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateMemberDetectorsInputOperationOutputAlias = crate::operation::UpdateMemberDetectors;
#[doc(hidden)]
pub type UpdateMemberDetectorsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateMemberDetectorsInput {
    /// Consumes the builder and constructs an Operation<[`UpdateMemberDetectors`](crate::operation::UpdateMemberDetectors)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateMemberDetectors,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateMemberDetectorsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_67 = &_input.detector_id;
            let input_67 =
                input_67
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_67, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/member/detector/update",
                DetectorId = detector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateMemberDetectorsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateMemberDetectorsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_member_detectors(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateMemberDetectors::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateMemberDetectors",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateMemberDetectorsInput`](crate::input::UpdateMemberDetectorsInput)
    pub fn builder() -> crate::input::update_member_detectors_input::Builder {
        crate::input::update_member_detectors_input::Builder::default()
    }
}

/// See [`UpdateOrganizationConfigurationInput`](crate::input::UpdateOrganizationConfigurationInput)
pub mod update_organization_configuration_input {
    /// A builder for [`UpdateOrganizationConfigurationInput`](crate::input::UpdateOrganizationConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) auto_enable: std::option::Option<bool>,
        pub(crate) data_sources:
            std::option::Option<crate::model::OrganizationDataSourceConfigurations>,
    }
    impl Builder {
        /// <p>The ID of the detector to update the delegated administrator for.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The ID of the detector to update the delegated administrator for.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>Indicates whether to automatically enable member accounts in the organization.</p>
        pub fn auto_enable(mut self, input: bool) -> Self {
            self.auto_enable = Some(input);
            self
        }
        /// <p>Indicates whether to automatically enable member accounts in the organization.</p>
        pub fn set_auto_enable(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_enable = input;
            self
        }
        /// <p>Describes which data sources will be updated.</p>
        pub fn data_sources(
            mut self,
            input: crate::model::OrganizationDataSourceConfigurations,
        ) -> Self {
            self.data_sources = Some(input);
            self
        }
        /// <p>Describes which data sources will be updated.</p>
        pub fn set_data_sources(
            mut self,
            input: std::option::Option<crate::model::OrganizationDataSourceConfigurations>,
        ) -> Self {
            self.data_sources = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateOrganizationConfigurationInput`](crate::input::UpdateOrganizationConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateOrganizationConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateOrganizationConfigurationInput {
                detector_id: self.detector_id,
                auto_enable: self.auto_enable.unwrap_or_default(),
                data_sources: self.data_sources,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateOrganizationConfigurationInputOperationOutputAlias =
    crate::operation::UpdateOrganizationConfiguration;
#[doc(hidden)]
pub type UpdateOrganizationConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateOrganizationConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateOrganizationConfiguration`](crate::operation::UpdateOrganizationConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateOrganizationConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateOrganizationConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_68 = &_input.detector_id;
            let input_68 =
                input_68
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_68, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/admin",
                DetectorId = detector_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateOrganizationConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateOrganizationConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_organization_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateOrganizationConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateOrganizationConfiguration",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateOrganizationConfigurationInput`](crate::input::UpdateOrganizationConfigurationInput)
    pub fn builder() -> crate::input::update_organization_configuration_input::Builder {
        crate::input::update_organization_configuration_input::Builder::default()
    }
}

/// See [`UpdatePublishingDestinationInput`](crate::input::UpdatePublishingDestinationInput)
pub mod update_publishing_destination_input {
    /// A builder for [`UpdatePublishingDestinationInput`](crate::input::UpdatePublishingDestinationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) destination_id: std::option::Option<std::string::String>,
        pub(crate) destination_properties: std::option::Option<crate::model::DestinationProperties>,
    }
    impl Builder {
        /// <p>The ID of the detector associated with the publishing destinations to update.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The ID of the detector associated with the publishing destinations to update.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The ID of the publishing destination to update.</p>
        pub fn destination_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_id = Some(input.into());
            self
        }
        /// <p>The ID of the publishing destination to update.</p>
        pub fn set_destination_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_id = input;
            self
        }
        /// <p>A <code>DestinationProperties</code> object that includes the <code>DestinationArn</code> and <code>KmsKeyArn</code> of the publishing destination.</p>
        pub fn destination_properties(
            mut self,
            input: crate::model::DestinationProperties,
        ) -> Self {
            self.destination_properties = Some(input);
            self
        }
        /// <p>A <code>DestinationProperties</code> object that includes the <code>DestinationArn</code> and <code>KmsKeyArn</code> of the publishing destination.</p>
        pub fn set_destination_properties(
            mut self,
            input: std::option::Option<crate::model::DestinationProperties>,
        ) -> Self {
            self.destination_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePublishingDestinationInput`](crate::input::UpdatePublishingDestinationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdatePublishingDestinationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdatePublishingDestinationInput {
                detector_id: self.detector_id,
                destination_id: self.destination_id,
                destination_properties: self.destination_properties,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdatePublishingDestinationInputOperationOutputAlias =
    crate::operation::UpdatePublishingDestination;
#[doc(hidden)]
pub type UpdatePublishingDestinationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdatePublishingDestinationInput {
    /// Consumes the builder and constructs an Operation<[`UpdatePublishingDestination`](crate::operation::UpdatePublishingDestination)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdatePublishingDestination,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdatePublishingDestinationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_69 = &_input.detector_id;
            let input_69 =
                input_69
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_69, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_70 = &_input.destination_id;
            let input_70 =
                input_70
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "destination_id",
                        details: "cannot be empty or unset",
                    })?;
            let destination_id = aws_smithy_http::label::fmt_string(input_70, false);
            if destination_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "destination_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/publishingDestination/{DestinationId}",
                DetectorId = detector_id,
                DestinationId = destination_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdatePublishingDestinationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdatePublishingDestinationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_publishing_destination(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdatePublishingDestination::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdatePublishingDestination",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdatePublishingDestinationInput`](crate::input::UpdatePublishingDestinationInput)
    pub fn builder() -> crate::input::update_publishing_destination_input::Builder {
        crate::input::update_publishing_destination_input::Builder::default()
    }
}

/// See [`UpdateThreatIntelSetInput`](crate::input::UpdateThreatIntelSetInput)
pub mod update_threat_intel_set_input {
    /// A builder for [`UpdateThreatIntelSetInput`](crate::input::UpdateThreatIntelSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detector_id: std::option::Option<std::string::String>,
        pub(crate) threat_intel_set_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) activate: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The detectorID that specifies the GuardDuty service whose ThreatIntelSet you want to update.</p>
        pub fn detector_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.detector_id = Some(input.into());
            self
        }
        /// <p>The detectorID that specifies the GuardDuty service whose ThreatIntelSet you want to update.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detector_id = input;
            self
        }
        /// <p>The unique ID that specifies the ThreatIntelSet that you want to update.</p>
        pub fn threat_intel_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.threat_intel_set_id = Some(input.into());
            self
        }
        /// <p>The unique ID that specifies the ThreatIntelSet that you want to update.</p>
        pub fn set_threat_intel_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.threat_intel_set_id = input;
            self
        }
        /// <p>The unique ID that specifies the ThreatIntelSet that you want to update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The unique ID that specifies the ThreatIntelSet that you want to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The updated URI of the file that contains the ThreateIntelSet.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The updated URI of the file that contains the ThreateIntelSet.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The updated Boolean value that specifies whether the ThreateIntelSet is active or not.</p>
        pub fn activate(mut self, input: bool) -> Self {
            self.activate = Some(input);
            self
        }
        /// <p>The updated Boolean value that specifies whether the ThreateIntelSet is active or not.</p>
        pub fn set_activate(mut self, input: std::option::Option<bool>) -> Self {
            self.activate = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateThreatIntelSetInput`](crate::input::UpdateThreatIntelSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateThreatIntelSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateThreatIntelSetInput {
                detector_id: self.detector_id,
                threat_intel_set_id: self.threat_intel_set_id,
                name: self.name,
                location: self.location,
                activate: self.activate.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateThreatIntelSetInputOperationOutputAlias = crate::operation::UpdateThreatIntelSet;
#[doc(hidden)]
pub type UpdateThreatIntelSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateThreatIntelSetInput {
    /// Consumes the builder and constructs an Operation<[`UpdateThreatIntelSet`](crate::operation::UpdateThreatIntelSet)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateThreatIntelSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateThreatIntelSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_71 = &_input.detector_id;
            let input_71 =
                input_71
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "detector_id",
                        details: "cannot be empty or unset",
                    })?;
            let detector_id = aws_smithy_http::label::fmt_string(input_71, false);
            if detector_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "detector_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_72 = &_input.threat_intel_set_id;
            let input_72 =
                input_72
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "threat_intel_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let threat_intel_set_id = aws_smithy_http::label::fmt_string(input_72, false);
            if threat_intel_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "threat_intel_set_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/detector/{DetectorId}/threatintelset/{ThreatIntelSetId}",
                DetectorId = detector_id,
                ThreatIntelSetId = threat_intel_set_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateThreatIntelSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateThreatIntelSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_threat_intel_set(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateThreatIntelSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateThreatIntelSet",
            "guardduty",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateThreatIntelSetInput`](crate::input::UpdateThreatIntelSetInput)
    pub fn builder() -> crate::input::update_threat_intel_set_input::Builder {
        crate::input::update_threat_intel_set_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateThreatIntelSetInput {
    /// <p>The detectorID that specifies the GuardDuty service whose ThreatIntelSet you want to update.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The unique ID that specifies the ThreatIntelSet that you want to update.</p>
    pub threat_intel_set_id: std::option::Option<std::string::String>,
    /// <p>The unique ID that specifies the ThreatIntelSet that you want to update.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The updated URI of the file that contains the ThreateIntelSet.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The updated Boolean value that specifies whether the ThreateIntelSet is active or not.</p>
    pub activate: bool,
}
impl UpdateThreatIntelSetInput {
    /// <p>The detectorID that specifies the GuardDuty service whose ThreatIntelSet you want to update.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>The unique ID that specifies the ThreatIntelSet that you want to update.</p>
    pub fn threat_intel_set_id(&self) -> std::option::Option<&str> {
        self.threat_intel_set_id.as_deref()
    }
    /// <p>The unique ID that specifies the ThreatIntelSet that you want to update.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The updated URI of the file that contains the ThreateIntelSet.</p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
    /// <p>The updated Boolean value that specifies whether the ThreateIntelSet is active or not.</p>
    pub fn activate(&self) -> bool {
        self.activate
    }
}
impl std::fmt::Debug for UpdateThreatIntelSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateThreatIntelSetInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("threat_intel_set_id", &self.threat_intel_set_id);
        formatter.field("name", &self.name);
        formatter.field("location", &self.location);
        formatter.field("activate", &self.activate);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePublishingDestinationInput {
    /// <p>The ID of the detector associated with the publishing destinations to update.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The ID of the publishing destination to update.</p>
    pub destination_id: std::option::Option<std::string::String>,
    /// <p>A <code>DestinationProperties</code> object that includes the <code>DestinationArn</code> and <code>KmsKeyArn</code> of the publishing destination.</p>
    pub destination_properties: std::option::Option<crate::model::DestinationProperties>,
}
impl UpdatePublishingDestinationInput {
    /// <p>The ID of the detector associated with the publishing destinations to update.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>The ID of the publishing destination to update.</p>
    pub fn destination_id(&self) -> std::option::Option<&str> {
        self.destination_id.as_deref()
    }
    /// <p>A <code>DestinationProperties</code> object that includes the <code>DestinationArn</code> and <code>KmsKeyArn</code> of the publishing destination.</p>
    pub fn destination_properties(
        &self,
    ) -> std::option::Option<&crate::model::DestinationProperties> {
        self.destination_properties.as_ref()
    }
}
impl std::fmt::Debug for UpdatePublishingDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePublishingDestinationInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("destination_id", &self.destination_id);
        formatter.field("destination_properties", &self.destination_properties);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateOrganizationConfigurationInput {
    /// <p>The ID of the detector to update the delegated administrator for.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether to automatically enable member accounts in the organization.</p>
    pub auto_enable: bool,
    /// <p>Describes which data sources will be updated.</p>
    pub data_sources: std::option::Option<crate::model::OrganizationDataSourceConfigurations>,
}
impl UpdateOrganizationConfigurationInput {
    /// <p>The ID of the detector to update the delegated administrator for.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>Indicates whether to automatically enable member accounts in the organization.</p>
    pub fn auto_enable(&self) -> bool {
        self.auto_enable
    }
    /// <p>Describes which data sources will be updated.</p>
    pub fn data_sources(
        &self,
    ) -> std::option::Option<&crate::model::OrganizationDataSourceConfigurations> {
        self.data_sources.as_ref()
    }
}
impl std::fmt::Debug for UpdateOrganizationConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateOrganizationConfigurationInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("auto_enable", &self.auto_enable);
        formatter.field("data_sources", &self.data_sources);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMemberDetectorsInput {
    /// <p>The detector ID of the administrator account.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>A list of member account IDs to be updated.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Describes which data sources will be updated.</p>
    pub data_sources: std::option::Option<crate::model::DataSourceConfigurations>,
}
impl UpdateMemberDetectorsInput {
    /// <p>The detector ID of the administrator account.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>A list of member account IDs to be updated.</p>
    pub fn account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.account_ids.as_deref()
    }
    /// <p>Describes which data sources will be updated.</p>
    pub fn data_sources(&self) -> std::option::Option<&crate::model::DataSourceConfigurations> {
        self.data_sources.as_ref()
    }
}
impl std::fmt::Debug for UpdateMemberDetectorsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMemberDetectorsInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("account_ids", &self.account_ids);
        formatter.field("data_sources", &self.data_sources);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateIpSetInput {
    /// <p>The detectorID that specifies the GuardDuty service whose IPSet you want to update.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The unique ID that specifies the IPSet that you want to update.</p>
    pub ip_set_id: std::option::Option<std::string::String>,
    /// <p>The unique ID that specifies the IPSet that you want to update.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The updated URI of the file that contains the IPSet. </p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The updated Boolean value that specifies whether the IPSet is active or not.</p>
    pub activate: bool,
}
impl UpdateIpSetInput {
    /// <p>The detectorID that specifies the GuardDuty service whose IPSet you want to update.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>The unique ID that specifies the IPSet that you want to update.</p>
    pub fn ip_set_id(&self) -> std::option::Option<&str> {
        self.ip_set_id.as_deref()
    }
    /// <p>The unique ID that specifies the IPSet that you want to update.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The updated URI of the file that contains the IPSet. </p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
    /// <p>The updated Boolean value that specifies whether the IPSet is active or not.</p>
    pub fn activate(&self) -> bool {
        self.activate
    }
}
impl std::fmt::Debug for UpdateIpSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateIpSetInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("ip_set_id", &self.ip_set_id);
        formatter.field("name", &self.name);
        formatter.field("location", &self.location);
        formatter.field("activate", &self.activate);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFindingsFeedbackInput {
    /// <p>The ID of the detector associated with the findings to update feedback for.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The IDs of the findings that you want to mark as useful or not useful.</p>
    pub finding_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The feedback for the finding.</p>
    pub feedback: std::option::Option<crate::model::Feedback>,
    /// <p>Additional feedback about the GuardDuty findings.</p>
    pub comments: std::option::Option<std::string::String>,
}
impl UpdateFindingsFeedbackInput {
    /// <p>The ID of the detector associated with the findings to update feedback for.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>The IDs of the findings that you want to mark as useful or not useful.</p>
    pub fn finding_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.finding_ids.as_deref()
    }
    /// <p>The feedback for the finding.</p>
    pub fn feedback(&self) -> std::option::Option<&crate::model::Feedback> {
        self.feedback.as_ref()
    }
    /// <p>Additional feedback about the GuardDuty findings.</p>
    pub fn comments(&self) -> std::option::Option<&str> {
        self.comments.as_deref()
    }
}
impl std::fmt::Debug for UpdateFindingsFeedbackInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFindingsFeedbackInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("finding_ids", &self.finding_ids);
        formatter.field("feedback", &self.feedback);
        formatter.field("comments", &self.comments);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFilterInput {
    /// <p>The unique ID of the detector that specifies the GuardDuty service where you want to update a filter.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The name of the filter.</p>
    pub filter_name: std::option::Option<std::string::String>,
    /// <p>The description of the filter.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Specifies the action that is to be applied to the findings that match the filter.</p>
    pub action: std::option::Option<crate::model::FilterAction>,
    /// <p>Specifies the position of the filter in the list of current filters. Also specifies the order in which this filter is applied to the findings.</p>
    pub rank: i32,
    /// <p>Represents the criteria to be used in the filter for querying findings.</p>
    pub finding_criteria: std::option::Option<crate::model::FindingCriteria>,
}
impl UpdateFilterInput {
    /// <p>The unique ID of the detector that specifies the GuardDuty service where you want to update a filter.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>The name of the filter.</p>
    pub fn filter_name(&self) -> std::option::Option<&str> {
        self.filter_name.as_deref()
    }
    /// <p>The description of the filter.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Specifies the action that is to be applied to the findings that match the filter.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::FilterAction> {
        self.action.as_ref()
    }
    /// <p>Specifies the position of the filter in the list of current filters. Also specifies the order in which this filter is applied to the findings.</p>
    pub fn rank(&self) -> i32 {
        self.rank
    }
    /// <p>Represents the criteria to be used in the filter for querying findings.</p>
    pub fn finding_criteria(&self) -> std::option::Option<&crate::model::FindingCriteria> {
        self.finding_criteria.as_ref()
    }
}
impl std::fmt::Debug for UpdateFilterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFilterInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("filter_name", &self.filter_name);
        formatter.field("description", &self.description);
        formatter.field("action", &self.action);
        formatter.field("rank", &self.rank);
        formatter.field("finding_criteria", &self.finding_criteria);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDetectorInput {
    /// <p>The unique ID of the detector to update.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the detector is enabled or not enabled.</p>
    pub enable: bool,
    /// <p>An enum value that specifies how frequently findings are exported, such as to CloudWatch Events.</p>
    pub finding_publishing_frequency: std::option::Option<crate::model::FindingPublishingFrequency>,
    /// <p>Describes which data sources will be updated.</p>
    pub data_sources: std::option::Option<crate::model::DataSourceConfigurations>,
}
impl UpdateDetectorInput {
    /// <p>The unique ID of the detector to update.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>Specifies whether the detector is enabled or not enabled.</p>
    pub fn enable(&self) -> bool {
        self.enable
    }
    /// <p>An enum value that specifies how frequently findings are exported, such as to CloudWatch Events.</p>
    pub fn finding_publishing_frequency(
        &self,
    ) -> std::option::Option<&crate::model::FindingPublishingFrequency> {
        self.finding_publishing_frequency.as_ref()
    }
    /// <p>Describes which data sources will be updated.</p>
    pub fn data_sources(&self) -> std::option::Option<&crate::model::DataSourceConfigurations> {
        self.data_sources.as_ref()
    }
}
impl std::fmt::Debug for UpdateDetectorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDetectorInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("enable", &self.enable);
        formatter.field(
            "finding_publishing_frequency",
            &self.finding_publishing_frequency,
        );
        formatter.field("data_sources", &self.data_sources);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the resource to remove tags from.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tag keys to remove from the resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the resource to remove tags from.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tag keys to remove from the resource.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnarchiveFindingsInput {
    /// <p>The ID of the detector associated with the findings to unarchive.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The IDs of the findings to unarchive.</p>
    pub finding_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UnarchiveFindingsInput {
    /// <p>The ID of the detector associated with the findings to unarchive.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>The IDs of the findings to unarchive.</p>
    pub fn finding_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.finding_ids.as_deref()
    }
}
impl std::fmt::Debug for UnarchiveFindingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnarchiveFindingsInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("finding_ids", &self.finding_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the GuardDuty resource to apply a tag to.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags to be added to a resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the GuardDuty resource to apply a tag to.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tags to be added to a resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopMonitoringMembersInput {
    /// <p>The unique ID of the detector associated with the GuardDuty administrator account that is monitoring member accounts.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>A list of account IDs for the member accounts to stop monitoring.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl StopMonitoringMembersInput {
    /// <p>The unique ID of the detector associated with the GuardDuty administrator account that is monitoring member accounts.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>A list of account IDs for the member accounts to stop monitoring.</p>
    pub fn account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.account_ids.as_deref()
    }
}
impl std::fmt::Debug for StopMonitoringMembersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopMonitoringMembersInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("account_ids", &self.account_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartMonitoringMembersInput {
    /// <p>The unique ID of the detector of the GuardDuty administrator account associated with the member accounts to monitor.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>A list of account IDs of the GuardDuty member accounts to start monitoring.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl StartMonitoringMembersInput {
    /// <p>The unique ID of the detector of the GuardDuty administrator account associated with the member accounts to monitor.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>A list of account IDs of the GuardDuty member accounts to start monitoring.</p>
    pub fn account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.account_ids.as_deref()
    }
}
impl std::fmt::Debug for StartMonitoringMembersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartMonitoringMembersInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("account_ids", &self.account_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListThreatIntelSetsInput {
    /// <p>The unique ID of the detector that the threatIntelSet is associated with.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 50. The maximum value is 50.</p>
    pub max_results: i32,
    /// <p>You can use this parameter to paginate results in the response. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListThreatIntelSetsInput {
    /// <p>The unique ID of the detector that the threatIntelSet is associated with.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 50. The maximum value is 50.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>You can use this parameter to paginate results in the response. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListThreatIntelSetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListThreatIntelSetsInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the given GuardDuty resource. </p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) for the given GuardDuty resource. </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPublishingDestinationsInput {
    /// <p>The ID of the detector to retrieve publishing destinations for.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in the response.</p>
    pub max_results: i32,
    /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPublishingDestinationsInput {
    /// <p>The ID of the detector to retrieve publishing destinations for.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>The maximum number of results to return in the response.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPublishingDestinationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPublishingDestinationsInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOrganizationAdminAccountsInput {
    /// <p>The maximum number of results to return in the response.</p>
    pub max_results: i32,
    /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListOrganizationAdminAccountsInput {
    /// <p>The maximum number of results to return in the response.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from the previous request to continue listing results after the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListOrganizationAdminAccountsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOrganizationAdminAccountsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMembersInput {
    /// <p>The unique ID of the detector the member is associated with.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 50. The maximum value is 50.</p>
    pub max_results: i32,
    /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Specifies whether to only return associated members or to return all members (including members who haven't been invited yet or have been disassociated).</p>
    pub only_associated: std::option::Option<std::string::String>,
}
impl ListMembersInput {
    /// <p>The unique ID of the detector the member is associated with.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 50. The maximum value is 50.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Specifies whether to only return associated members or to return all members (including members who haven't been invited yet or have been disassociated).</p>
    pub fn only_associated(&self) -> std::option::Option<&str> {
        self.only_associated.as_deref()
    }
}
impl std::fmt::Debug for ListMembersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMembersInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("only_associated", &self.only_associated);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIpSetsInput {
    /// <p>The unique ID of the detector that the IPSet is associated with.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 50. The maximum value is 50.</p>
    pub max_results: i32,
    /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListIpSetsInput {
    /// <p>The unique ID of the detector that the IPSet is associated with.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 50. The maximum value is 50.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListIpSetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIpSetsInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInvitationsInput {
    /// <p>You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 50. The maximum value is 50.</p>
    pub max_results: i32,
    /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListInvitationsInput {
    /// <p>You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 50. The maximum value is 50.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListInvitationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInvitationsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFindingsInput {
    /// <p>The ID of the detector that specifies the GuardDuty service whose findings you want to list.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>Represents the criteria used for querying findings. Valid values include:</p>
    /// <ul>
    /// <li> <p>JSON field name</p> </li>
    /// <li> <p>accountId</p> </li>
    /// <li> <p>region</p> </li>
    /// <li> <p>confidence</p> </li>
    /// <li> <p>id</p> </li>
    /// <li> <p>resource.accessKeyDetails.accessKeyId</p> </li>
    /// <li> <p>resource.accessKeyDetails.principalId</p> </li>
    /// <li> <p>resource.accessKeyDetails.userName</p> </li>
    /// <li> <p>resource.accessKeyDetails.userType</p> </li>
    /// <li> <p>resource.instanceDetails.iamInstanceProfile.id</p> </li>
    /// <li> <p>resource.instanceDetails.imageId</p> </li>
    /// <li> <p>resource.instanceDetails.instanceId</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.ipv6Addresses</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.publicDnsName</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.publicIp</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.securityGroups.groupId</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.securityGroups.groupName</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.subnetId</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.vpcId</p> </li>
    /// <li> <p>resource.instanceDetails.tags.key</p> </li>
    /// <li> <p>resource.instanceDetails.tags.value</p> </li>
    /// <li> <p>resource.resourceType</p> </li>
    /// <li> <p>service.action.actionType</p> </li>
    /// <li> <p>service.action.awsApiCallAction.api</p> </li>
    /// <li> <p>service.action.awsApiCallAction.callerType</p> </li>
    /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.city.cityName</p> </li>
    /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.country.countryName</p> </li>
    /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.ipAddressV4</p> </li>
    /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.organization.asn</p> </li>
    /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg</p> </li>
    /// <li> <p>service.action.awsApiCallAction.serviceName</p> </li>
    /// <li> <p>service.action.dnsRequestAction.domain</p> </li>
    /// <li> <p>service.action.networkConnectionAction.blocked</p> </li>
    /// <li> <p>service.action.networkConnectionAction.connectionDirection</p> </li>
    /// <li> <p>service.action.networkConnectionAction.localPortDetails.port</p> </li>
    /// <li> <p>service.action.networkConnectionAction.protocol</p> </li>
    /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.country.countryName</p> </li>
    /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.ipAddressV4</p> </li>
    /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.organization.asn</p> </li>
    /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg</p> </li>
    /// <li> <p>service.action.networkConnectionAction.remotePortDetails.port</p> </li>
    /// <li> <p>service.additionalInfo.threatListName</p> </li>
    /// <li> <p>service.archived</p> <p>When this attribute is set to 'true', only archived findings are listed. When it's set to 'false', only unarchived findings are listed. When this attribute is not set, all existing findings are listed.</p> </li>
    /// <li> <p>service.resourceRole</p> </li>
    /// <li> <p>severity</p> </li>
    /// <li> <p>type</p> </li>
    /// <li> <p>updatedAt</p> <p>Type: Timestamp in Unix Epoch millisecond format: 1486685375000</p> </li>
    /// </ul>
    pub finding_criteria: std::option::Option<crate::model::FindingCriteria>,
    /// <p>Represents the criteria used for sorting findings.</p>
    pub sort_criteria: std::option::Option<crate::model::SortCriteria>,
    /// <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 50. The maximum value is 50.</p>
    pub max_results: i32,
    /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFindingsInput {
    /// <p>The ID of the detector that specifies the GuardDuty service whose findings you want to list.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>Represents the criteria used for querying findings. Valid values include:</p>
    /// <ul>
    /// <li> <p>JSON field name</p> </li>
    /// <li> <p>accountId</p> </li>
    /// <li> <p>region</p> </li>
    /// <li> <p>confidence</p> </li>
    /// <li> <p>id</p> </li>
    /// <li> <p>resource.accessKeyDetails.accessKeyId</p> </li>
    /// <li> <p>resource.accessKeyDetails.principalId</p> </li>
    /// <li> <p>resource.accessKeyDetails.userName</p> </li>
    /// <li> <p>resource.accessKeyDetails.userType</p> </li>
    /// <li> <p>resource.instanceDetails.iamInstanceProfile.id</p> </li>
    /// <li> <p>resource.instanceDetails.imageId</p> </li>
    /// <li> <p>resource.instanceDetails.instanceId</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.ipv6Addresses</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.publicDnsName</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.publicIp</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.securityGroups.groupId</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.securityGroups.groupName</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.subnetId</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.vpcId</p> </li>
    /// <li> <p>resource.instanceDetails.tags.key</p> </li>
    /// <li> <p>resource.instanceDetails.tags.value</p> </li>
    /// <li> <p>resource.resourceType</p> </li>
    /// <li> <p>service.action.actionType</p> </li>
    /// <li> <p>service.action.awsApiCallAction.api</p> </li>
    /// <li> <p>service.action.awsApiCallAction.callerType</p> </li>
    /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.city.cityName</p> </li>
    /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.country.countryName</p> </li>
    /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.ipAddressV4</p> </li>
    /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.organization.asn</p> </li>
    /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg</p> </li>
    /// <li> <p>service.action.awsApiCallAction.serviceName</p> </li>
    /// <li> <p>service.action.dnsRequestAction.domain</p> </li>
    /// <li> <p>service.action.networkConnectionAction.blocked</p> </li>
    /// <li> <p>service.action.networkConnectionAction.connectionDirection</p> </li>
    /// <li> <p>service.action.networkConnectionAction.localPortDetails.port</p> </li>
    /// <li> <p>service.action.networkConnectionAction.protocol</p> </li>
    /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.country.countryName</p> </li>
    /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.ipAddressV4</p> </li>
    /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.organization.asn</p> </li>
    /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg</p> </li>
    /// <li> <p>service.action.networkConnectionAction.remotePortDetails.port</p> </li>
    /// <li> <p>service.additionalInfo.threatListName</p> </li>
    /// <li> <p>service.archived</p> <p>When this attribute is set to 'true', only archived findings are listed. When it's set to 'false', only unarchived findings are listed. When this attribute is not set, all existing findings are listed.</p> </li>
    /// <li> <p>service.resourceRole</p> </li>
    /// <li> <p>severity</p> </li>
    /// <li> <p>type</p> </li>
    /// <li> <p>updatedAt</p> <p>Type: Timestamp in Unix Epoch millisecond format: 1486685375000</p> </li>
    /// </ul>
    pub fn finding_criteria(&self) -> std::option::Option<&crate::model::FindingCriteria> {
        self.finding_criteria.as_ref()
    }
    /// <p>Represents the criteria used for sorting findings.</p>
    pub fn sort_criteria(&self) -> std::option::Option<&crate::model::SortCriteria> {
        self.sort_criteria.as_ref()
    }
    /// <p>You can use this parameter to indicate the maximum number of items you want in the response. The default value is 50. The maximum value is 50.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFindingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFindingsInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("finding_criteria", &self.finding_criteria);
        formatter.field("sort_criteria", &self.sort_criteria);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFiltersInput {
    /// <p>The unique ID of the detector that the filter is associated with.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 50. The maximum value is 50.</p>
    pub max_results: i32,
    /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFiltersInput {
    /// <p>The unique ID of the detector that the filter is associated with.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 50. The maximum value is 50.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFiltersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFiltersInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDetectorsInput {
    /// <p>You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 50. The maximum value is 50.</p>
    pub max_results: i32,
    /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDetectorsInput {
    /// <p>You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 50. The maximum value is 50.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the list action. For subsequent calls to the action, fill nextToken in the request with the value of NextToken from the previous response to continue listing data.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDetectorsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDetectorsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InviteMembersInput {
    /// <p>The unique ID of the detector of the GuardDuty account that you want to invite members with.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>A list of account IDs of the accounts that you want to invite to GuardDuty as members.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A Boolean value that specifies whether you want to disable email notification to the accounts that you are inviting to GuardDuty as members.</p>
    pub disable_email_notification: bool,
    /// <p>The invitation message that you want to send to the accounts that you're inviting to GuardDuty as members.</p>
    pub message: std::option::Option<std::string::String>,
}
impl InviteMembersInput {
    /// <p>The unique ID of the detector of the GuardDuty account that you want to invite members with.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>A list of account IDs of the accounts that you want to invite to GuardDuty as members.</p>
    pub fn account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.account_ids.as_deref()
    }
    /// <p>A Boolean value that specifies whether you want to disable email notification to the accounts that you are inviting to GuardDuty as members.</p>
    pub fn disable_email_notification(&self) -> bool {
        self.disable_email_notification
    }
    /// <p>The invitation message that you want to send to the accounts that you're inviting to GuardDuty as members.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for InviteMembersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InviteMembersInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("account_ids", &self.account_ids);
        formatter.field(
            "disable_email_notification",
            &self.disable_email_notification,
        );
        formatter.field("message", &self.message);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUsageStatisticsInput {
    /// <p>The ID of the detector that specifies the GuardDuty service whose usage statistics you want to retrieve.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The type of usage statistics to retrieve.</p>
    pub usage_statistic_type: std::option::Option<crate::model::UsageStatisticType>,
    /// <p>Represents the criteria used for querying usage.</p>
    pub usage_criteria: std::option::Option<crate::model::UsageCriteria>,
    /// <p>The currency unit you would like to view your usage statistics in. Current valid values are USD.</p>
    pub unit: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in the response.</p>
    pub max_results: i32,
    /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the NextToken value returned from the previous request to continue listing results after the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetUsageStatisticsInput {
    /// <p>The ID of the detector that specifies the GuardDuty service whose usage statistics you want to retrieve.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>The type of usage statistics to retrieve.</p>
    pub fn usage_statistic_type(&self) -> std::option::Option<&crate::model::UsageStatisticType> {
        self.usage_statistic_type.as_ref()
    }
    /// <p>Represents the criteria used for querying usage.</p>
    pub fn usage_criteria(&self) -> std::option::Option<&crate::model::UsageCriteria> {
        self.usage_criteria.as_ref()
    }
    /// <p>The currency unit you would like to view your usage statistics in. Current valid values are USD.</p>
    pub fn unit(&self) -> std::option::Option<&str> {
        self.unit.as_deref()
    }
    /// <p>The maximum number of results to return in the response.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request to a list action. For subsequent calls, use the NextToken value returned from the previous request to continue listing results after the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetUsageStatisticsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUsageStatisticsInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("usage_statistic_type", &self.usage_statistic_type);
        formatter.field("usage_criteria", &self.usage_criteria);
        formatter.field("unit", &self.unit);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetThreatIntelSetInput {
    /// <p>The unique ID of the detector that the threatIntelSet is associated with.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The unique ID of the threatIntelSet that you want to get.</p>
    pub threat_intel_set_id: std::option::Option<std::string::String>,
}
impl GetThreatIntelSetInput {
    /// <p>The unique ID of the detector that the threatIntelSet is associated with.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>The unique ID of the threatIntelSet that you want to get.</p>
    pub fn threat_intel_set_id(&self) -> std::option::Option<&str> {
        self.threat_intel_set_id.as_deref()
    }
}
impl std::fmt::Debug for GetThreatIntelSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetThreatIntelSetInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("threat_intel_set_id", &self.threat_intel_set_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMembersInput {
    /// <p>The unique ID of the detector of the GuardDuty account whose members you want to retrieve.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>A list of account IDs of the GuardDuty member accounts that you want to describe.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GetMembersInput {
    /// <p>The unique ID of the detector of the GuardDuty account whose members you want to retrieve.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>A list of account IDs of the GuardDuty member accounts that you want to describe.</p>
    pub fn account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.account_ids.as_deref()
    }
}
impl std::fmt::Debug for GetMembersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMembersInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("account_ids", &self.account_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMemberDetectorsInput {
    /// <p>The detector ID for the administrator account.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The account ID of the member account.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GetMemberDetectorsInput {
    /// <p>The detector ID for the administrator account.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>The account ID of the member account.</p>
    pub fn account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.account_ids.as_deref()
    }
}
impl std::fmt::Debug for GetMemberDetectorsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMemberDetectorsInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("account_ids", &self.account_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMasterAccountInput {
    /// <p>The unique ID of the detector of the GuardDuty member account.</p>
    pub detector_id: std::option::Option<std::string::String>,
}
impl GetMasterAccountInput {
    /// <p>The unique ID of the detector of the GuardDuty member account.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
}
impl std::fmt::Debug for GetMasterAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMasterAccountInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIpSetInput {
    /// <p>The unique ID of the detector that the IPSet is associated with.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The unique ID of the IPSet to retrieve.</p>
    pub ip_set_id: std::option::Option<std::string::String>,
}
impl GetIpSetInput {
    /// <p>The unique ID of the detector that the IPSet is associated with.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>The unique ID of the IPSet to retrieve.</p>
    pub fn ip_set_id(&self) -> std::option::Option<&str> {
        self.ip_set_id.as_deref()
    }
}
impl std::fmt::Debug for GetIpSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIpSetInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("ip_set_id", &self.ip_set_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInvitationsCountInput {}
impl std::fmt::Debug for GetInvitationsCountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInvitationsCountInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFindingsStatisticsInput {
    /// <p>The ID of the detector that specifies the GuardDuty service whose findings' statistics you want to retrieve.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The types of finding statistics to retrieve.</p>
    pub finding_statistic_types:
        std::option::Option<std::vec::Vec<crate::model::FindingStatisticType>>,
    /// <p>Represents the criteria that is used for querying findings.</p>
    pub finding_criteria: std::option::Option<crate::model::FindingCriteria>,
}
impl GetFindingsStatisticsInput {
    /// <p>The ID of the detector that specifies the GuardDuty service whose findings' statistics you want to retrieve.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>The types of finding statistics to retrieve.</p>
    pub fn finding_statistic_types(
        &self,
    ) -> std::option::Option<&[crate::model::FindingStatisticType]> {
        self.finding_statistic_types.as_deref()
    }
    /// <p>Represents the criteria that is used for querying findings.</p>
    pub fn finding_criteria(&self) -> std::option::Option<&crate::model::FindingCriteria> {
        self.finding_criteria.as_ref()
    }
}
impl std::fmt::Debug for GetFindingsStatisticsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFindingsStatisticsInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("finding_statistic_types", &self.finding_statistic_types);
        formatter.field("finding_criteria", &self.finding_criteria);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFindingsInput {
    /// <p>The ID of the detector that specifies the GuardDuty service whose findings you want to retrieve.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The IDs of the findings that you want to retrieve.</p>
    pub finding_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Represents the criteria used for sorting findings.</p>
    pub sort_criteria: std::option::Option<crate::model::SortCriteria>,
}
impl GetFindingsInput {
    /// <p>The ID of the detector that specifies the GuardDuty service whose findings you want to retrieve.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>The IDs of the findings that you want to retrieve.</p>
    pub fn finding_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.finding_ids.as_deref()
    }
    /// <p>Represents the criteria used for sorting findings.</p>
    pub fn sort_criteria(&self) -> std::option::Option<&crate::model::SortCriteria> {
        self.sort_criteria.as_ref()
    }
}
impl std::fmt::Debug for GetFindingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFindingsInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("finding_ids", &self.finding_ids);
        formatter.field("sort_criteria", &self.sort_criteria);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFilterInput {
    /// <p>The unique ID of the detector that the filter is associated with.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The name of the filter you want to get.</p>
    pub filter_name: std::option::Option<std::string::String>,
}
impl GetFilterInput {
    /// <p>The unique ID of the detector that the filter is associated with.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>The name of the filter you want to get.</p>
    pub fn filter_name(&self) -> std::option::Option<&str> {
        self.filter_name.as_deref()
    }
}
impl std::fmt::Debug for GetFilterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFilterInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("filter_name", &self.filter_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDetectorInput {
    /// <p>The unique ID of the detector that you want to get.</p>
    pub detector_id: std::option::Option<std::string::String>,
}
impl GetDetectorInput {
    /// <p>The unique ID of the detector that you want to get.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
}
impl std::fmt::Debug for GetDetectorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDetectorInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableOrganizationAdminAccountInput {
    /// <p>The Amazon Web Services Account ID for the organization account to be enabled as a GuardDuty delegated administrator.</p>
    pub admin_account_id: std::option::Option<std::string::String>,
}
impl EnableOrganizationAdminAccountInput {
    /// <p>The Amazon Web Services Account ID for the organization account to be enabled as a GuardDuty delegated administrator.</p>
    pub fn admin_account_id(&self) -> std::option::Option<&str> {
        self.admin_account_id.as_deref()
    }
}
impl std::fmt::Debug for EnableOrganizationAdminAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableOrganizationAdminAccountInput");
        formatter.field("admin_account_id", &self.admin_account_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateMembersInput {
    /// <p>The unique ID of the detector of the GuardDuty account whose members you want to disassociate from the administrator account.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>A list of account IDs of the GuardDuty member accounts that you want to disassociate from the administrator account.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DisassociateMembersInput {
    /// <p>The unique ID of the detector of the GuardDuty account whose members you want to disassociate from the administrator account.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>A list of account IDs of the GuardDuty member accounts that you want to disassociate from the administrator account.</p>
    pub fn account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.account_ids.as_deref()
    }
}
impl std::fmt::Debug for DisassociateMembersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateMembersInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("account_ids", &self.account_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateFromMasterAccountInput {
    /// <p>The unique ID of the detector of the GuardDuty member account.</p>
    pub detector_id: std::option::Option<std::string::String>,
}
impl DisassociateFromMasterAccountInput {
    /// <p>The unique ID of the detector of the GuardDuty member account.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
}
impl std::fmt::Debug for DisassociateFromMasterAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateFromMasterAccountInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableOrganizationAdminAccountInput {
    /// <p>The Amazon Web Services Account ID for the organizations account to be disabled as a GuardDuty delegated administrator.</p>
    pub admin_account_id: std::option::Option<std::string::String>,
}
impl DisableOrganizationAdminAccountInput {
    /// <p>The Amazon Web Services Account ID for the organizations account to be disabled as a GuardDuty delegated administrator.</p>
    pub fn admin_account_id(&self) -> std::option::Option<&str> {
        self.admin_account_id.as_deref()
    }
}
impl std::fmt::Debug for DisableOrganizationAdminAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableOrganizationAdminAccountInput");
        formatter.field("admin_account_id", &self.admin_account_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePublishingDestinationInput {
    /// <p>The unique ID of the detector associated with the publishing destination to retrieve.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The ID of the publishing destination to retrieve.</p>
    pub destination_id: std::option::Option<std::string::String>,
}
impl DescribePublishingDestinationInput {
    /// <p>The unique ID of the detector associated with the publishing destination to retrieve.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>The ID of the publishing destination to retrieve.</p>
    pub fn destination_id(&self) -> std::option::Option<&str> {
        self.destination_id.as_deref()
    }
}
impl std::fmt::Debug for DescribePublishingDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePublishingDestinationInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("destination_id", &self.destination_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOrganizationConfigurationInput {
    /// <p>The ID of the detector to retrieve information about the delegated administrator from.</p>
    pub detector_id: std::option::Option<std::string::String>,
}
impl DescribeOrganizationConfigurationInput {
    /// <p>The ID of the detector to retrieve information about the delegated administrator from.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeOrganizationConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOrganizationConfigurationInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteThreatIntelSetInput {
    /// <p>The unique ID of the detector that the threatIntelSet is associated with.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The unique ID of the threatIntelSet that you want to delete.</p>
    pub threat_intel_set_id: std::option::Option<std::string::String>,
}
impl DeleteThreatIntelSetInput {
    /// <p>The unique ID of the detector that the threatIntelSet is associated with.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>The unique ID of the threatIntelSet that you want to delete.</p>
    pub fn threat_intel_set_id(&self) -> std::option::Option<&str> {
        self.threat_intel_set_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteThreatIntelSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteThreatIntelSetInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("threat_intel_set_id", &self.threat_intel_set_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePublishingDestinationInput {
    /// <p>The unique ID of the detector associated with the publishing destination to delete.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The ID of the publishing destination to delete.</p>
    pub destination_id: std::option::Option<std::string::String>,
}
impl DeletePublishingDestinationInput {
    /// <p>The unique ID of the detector associated with the publishing destination to delete.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>The ID of the publishing destination to delete.</p>
    pub fn destination_id(&self) -> std::option::Option<&str> {
        self.destination_id.as_deref()
    }
}
impl std::fmt::Debug for DeletePublishingDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePublishingDestinationInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("destination_id", &self.destination_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMembersInput {
    /// <p>The unique ID of the detector of the GuardDuty account whose members you want to delete.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>A list of account IDs of the GuardDuty member accounts that you want to delete.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DeleteMembersInput {
    /// <p>The unique ID of the detector of the GuardDuty account whose members you want to delete.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>A list of account IDs of the GuardDuty member accounts that you want to delete.</p>
    pub fn account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.account_ids.as_deref()
    }
}
impl std::fmt::Debug for DeleteMembersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMembersInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("account_ids", &self.account_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteIpSetInput {
    /// <p>The unique ID of the detector associated with the IPSet.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The unique ID of the IPSet to delete.</p>
    pub ip_set_id: std::option::Option<std::string::String>,
}
impl DeleteIpSetInput {
    /// <p>The unique ID of the detector associated with the IPSet.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>The unique ID of the IPSet to delete.</p>
    pub fn ip_set_id(&self) -> std::option::Option<&str> {
        self.ip_set_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteIpSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteIpSetInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("ip_set_id", &self.ip_set_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteInvitationsInput {
    /// <p>A list of account IDs of the Amazon Web Services accounts that sent invitations to the current member account that you want to delete invitations from.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DeleteInvitationsInput {
    /// <p>A list of account IDs of the Amazon Web Services accounts that sent invitations to the current member account that you want to delete invitations from.</p>
    pub fn account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.account_ids.as_deref()
    }
}
impl std::fmt::Debug for DeleteInvitationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteInvitationsInput");
        formatter.field("account_ids", &self.account_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFilterInput {
    /// <p>The unique ID of the detector that the filter is associated with.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The name of the filter that you want to delete.</p>
    pub filter_name: std::option::Option<std::string::String>,
}
impl DeleteFilterInput {
    /// <p>The unique ID of the detector that the filter is associated with.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>The name of the filter that you want to delete.</p>
    pub fn filter_name(&self) -> std::option::Option<&str> {
        self.filter_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteFilterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFilterInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("filter_name", &self.filter_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDetectorInput {
    /// <p>The unique ID of the detector that you want to delete.</p>
    pub detector_id: std::option::Option<std::string::String>,
}
impl DeleteDetectorInput {
    /// <p>The unique ID of the detector that you want to delete.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteDetectorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDetectorInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeclineInvitationsInput {
    /// <p>A list of account IDs of the Amazon Web Services accounts that sent invitations to the current member account that you want to decline invitations from.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DeclineInvitationsInput {
    /// <p>A list of account IDs of the Amazon Web Services accounts that sent invitations to the current member account that you want to decline invitations from.</p>
    pub fn account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.account_ids.as_deref()
    }
}
impl std::fmt::Debug for DeclineInvitationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeclineInvitationsInput");
        formatter.field("account_ids", &self.account_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateThreatIntelSetInput {
    /// <p>The unique ID of the detector of the GuardDuty account that you want to create a threatIntelSet for.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>A user-friendly ThreatIntelSet name displayed in all findings that are generated by activity that involves IP addresses included in this ThreatIntelSet.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The format of the file that contains the ThreatIntelSet.</p>
    pub format: std::option::Option<crate::model::ThreatIntelSetFormat>,
    /// <p>The URI of the file that contains the ThreatIntelSet. </p>
    pub location: std::option::Option<std::string::String>,
    /// <p>A Boolean value that indicates whether GuardDuty is to start using the uploaded ThreatIntelSet.</p>
    pub activate: bool,
    /// <p>The idempotency token for the create request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The tags to be added to a new threat list resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateThreatIntelSetInput {
    /// <p>The unique ID of the detector of the GuardDuty account that you want to create a threatIntelSet for.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>A user-friendly ThreatIntelSet name displayed in all findings that are generated by activity that involves IP addresses included in this ThreatIntelSet.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The format of the file that contains the ThreatIntelSet.</p>
    pub fn format(&self) -> std::option::Option<&crate::model::ThreatIntelSetFormat> {
        self.format.as_ref()
    }
    /// <p>The URI of the file that contains the ThreatIntelSet. </p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
    /// <p>A Boolean value that indicates whether GuardDuty is to start using the uploaded ThreatIntelSet.</p>
    pub fn activate(&self) -> bool {
        self.activate
    }
    /// <p>The idempotency token for the create request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The tags to be added to a new threat list resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateThreatIntelSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateThreatIntelSetInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("name", &self.name);
        formatter.field("format", &self.format);
        formatter.field("location", &self.location);
        formatter.field("activate", &self.activate);
        formatter.field("client_token", &self.client_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSampleFindingsInput {
    /// <p>The ID of the detector to create sample findings for.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The types of sample findings to generate.</p>
    pub finding_types: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CreateSampleFindingsInput {
    /// <p>The ID of the detector to create sample findings for.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>The types of sample findings to generate.</p>
    pub fn finding_types(&self) -> std::option::Option<&[std::string::String]> {
        self.finding_types.as_deref()
    }
}
impl std::fmt::Debug for CreateSampleFindingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSampleFindingsInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("finding_types", &self.finding_types);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePublishingDestinationInput {
    /// <p>The ID of the GuardDuty detector associated with the publishing destination.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The type of resource for the publishing destination. Currently only Amazon S3 buckets are supported.</p>
    pub destination_type: std::option::Option<crate::model::DestinationType>,
    /// <p>The properties of the publishing destination, including the ARNs for the destination and the KMS key used for encryption.</p>
    pub destination_properties: std::option::Option<crate::model::DestinationProperties>,
    /// <p>The idempotency token for the request.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreatePublishingDestinationInput {
    /// <p>The ID of the GuardDuty detector associated with the publishing destination.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>The type of resource for the publishing destination. Currently only Amazon S3 buckets are supported.</p>
    pub fn destination_type(&self) -> std::option::Option<&crate::model::DestinationType> {
        self.destination_type.as_ref()
    }
    /// <p>The properties of the publishing destination, including the ARNs for the destination and the KMS key used for encryption.</p>
    pub fn destination_properties(
        &self,
    ) -> std::option::Option<&crate::model::DestinationProperties> {
        self.destination_properties.as_ref()
    }
    /// <p>The idempotency token for the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreatePublishingDestinationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePublishingDestinationInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("destination_type", &self.destination_type);
        formatter.field("destination_properties", &self.destination_properties);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMembersInput {
    /// <p>The unique ID of the detector of the GuardDuty account that you want to associate member accounts with.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>A list of account ID and email address pairs of the accounts that you want to associate with the GuardDuty administrator account.</p>
    pub account_details: std::option::Option<std::vec::Vec<crate::model::AccountDetail>>,
}
impl CreateMembersInput {
    /// <p>The unique ID of the detector of the GuardDuty account that you want to associate member accounts with.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>A list of account ID and email address pairs of the accounts that you want to associate with the GuardDuty administrator account.</p>
    pub fn account_details(&self) -> std::option::Option<&[crate::model::AccountDetail]> {
        self.account_details.as_deref()
    }
}
impl std::fmt::Debug for CreateMembersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMembersInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("account_details", &self.account_details);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateIpSetInput {
    /// <p>The unique ID of the detector of the GuardDuty account that you want to create an IPSet for.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The user-friendly name to identify the IPSet.</p>
    /// <p> Allowed characters are alphanumerics, spaces, hyphens (-), and underscores (_).</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The format of the file that contains the IPSet.</p>
    pub format: std::option::Option<crate::model::IpSetFormat>,
    /// <p>The URI of the file that contains the IPSet. </p>
    pub location: std::option::Option<std::string::String>,
    /// <p>A Boolean value that indicates whether GuardDuty is to start using the uploaded IPSet.</p>
    pub activate: bool,
    /// <p>The idempotency token for the create request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The tags to be added to a new IP set resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateIpSetInput {
    /// <p>The unique ID of the detector of the GuardDuty account that you want to create an IPSet for.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>The user-friendly name to identify the IPSet.</p>
    /// <p> Allowed characters are alphanumerics, spaces, hyphens (-), and underscores (_).</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The format of the file that contains the IPSet.</p>
    pub fn format(&self) -> std::option::Option<&crate::model::IpSetFormat> {
        self.format.as_ref()
    }
    /// <p>The URI of the file that contains the IPSet. </p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
    /// <p>A Boolean value that indicates whether GuardDuty is to start using the uploaded IPSet.</p>
    pub fn activate(&self) -> bool {
        self.activate
    }
    /// <p>The idempotency token for the create request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The tags to be added to a new IP set resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateIpSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateIpSetInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("name", &self.name);
        formatter.field("format", &self.format);
        formatter.field("location", &self.location);
        formatter.field("activate", &self.activate);
        formatter.field("client_token", &self.client_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFilterInput {
    /// <p>The ID of the detector belonging to the GuardDuty account that you want to create a filter for.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The name of the filter. Minimum length of 3. Maximum length of 64. Valid characters include alphanumeric characters, dot (.), underscore (_), and dash (-). Spaces are not allowed.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the filter.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Specifies the action that is to be applied to the findings that match the filter.</p>
    pub action: std::option::Option<crate::model::FilterAction>,
    /// <p>Specifies the position of the filter in the list of current filters. Also specifies the order in which this filter is applied to the findings.</p>
    pub rank: i32,
    /// <p>Represents the criteria to be used in the filter for querying findings.</p>
    /// <p>You can only use the following attributes to query findings:</p>
    /// <ul>
    /// <li> <p>accountId</p> </li>
    /// <li> <p>region</p> </li>
    /// <li> <p>confidence</p> </li>
    /// <li> <p>id</p> </li>
    /// <li> <p>resource.accessKeyDetails.accessKeyId</p> </li>
    /// <li> <p>resource.accessKeyDetails.principalId</p> </li>
    /// <li> <p>resource.accessKeyDetails.userName</p> </li>
    /// <li> <p>resource.accessKeyDetails.userType</p> </li>
    /// <li> <p>resource.instanceDetails.iamInstanceProfile.id</p> </li>
    /// <li> <p>resource.instanceDetails.imageId</p> </li>
    /// <li> <p>resource.instanceDetails.instanceId</p> </li>
    /// <li> <p>resource.instanceDetails.outpostArn</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.ipv6Addresses</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.publicDnsName</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.publicIp</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.securityGroups.groupId</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.securityGroups.groupName</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.subnetId</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.vpcId</p> </li>
    /// <li> <p>resource.instanceDetails.tags.key</p> </li>
    /// <li> <p>resource.instanceDetails.tags.value</p> </li>
    /// <li> <p>resource.resourceType</p> </li>
    /// <li> <p>service.action.actionType</p> </li>
    /// <li> <p>service.action.awsApiCallAction.api</p> </li>
    /// <li> <p>service.action.awsApiCallAction.callerType</p> </li>
    /// <li> <p>service.action.awsApiCallAction.errorCode</p> </li>
    /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.city.cityName</p> </li>
    /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.country.countryName</p> </li>
    /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.ipAddressV4</p> </li>
    /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.organization.asn</p> </li>
    /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg</p> </li>
    /// <li> <p>service.action.awsApiCallAction.serviceName</p> </li>
    /// <li> <p>service.action.dnsRequestAction.domain</p> </li>
    /// <li> <p>service.action.networkConnectionAction.blocked</p> </li>
    /// <li> <p>service.action.networkConnectionAction.connectionDirection</p> </li>
    /// <li> <p>service.action.networkConnectionAction.localPortDetails.port</p> </li>
    /// <li> <p>service.action.networkConnectionAction.protocol</p> </li>
    /// <li> <p>service.action.networkConnectionAction.localIpDetails.ipAddressV4</p> </li>
    /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.city.cityName</p> </li>
    /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.country.countryName</p> </li>
    /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.ipAddressV4</p> </li>
    /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.organization.asn</p> </li>
    /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg</p> </li>
    /// <li> <p>service.action.networkConnectionAction.remotePortDetails.port</p> </li>
    /// <li> <p>service.additionalInfo.threatListName</p> </li>
    /// <li> <p>resource.s3BucketDetails.publicAccess.effectivePermissions</p> </li>
    /// <li> <p>resource.s3BucketDetails.name</p> </li>
    /// <li> <p>resource.s3BucketDetails.tags.key</p> </li>
    /// <li> <p>resource.s3BucketDetails.tags.value</p> </li>
    /// <li> <p>resource.s3BucketDetails.type</p> </li>
    /// <li> <p>service.archived</p> <p>When this attribute is set to TRUE, only archived findings are listed. When it's set to FALSE, only unarchived findings are listed. When this attribute is not set, all existing findings are listed.</p> </li>
    /// <li> <p>service.resourceRole</p> </li>
    /// <li> <p>severity</p> </li>
    /// <li> <p>type</p> </li>
    /// <li> <p>updatedAt</p> <p>Type: ISO 8601 string format: YYYY-MM-DDTHH:MM:SS.SSSZ or YYYY-MM-DDTHH:MM:SSZ depending on whether the value contains milliseconds.</p> </li>
    /// </ul>
    pub finding_criteria: std::option::Option<crate::model::FindingCriteria>,
    /// <p>The idempotency token for the create request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The tags to be added to a new filter resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateFilterInput {
    /// <p>The ID of the detector belonging to the GuardDuty account that you want to create a filter for.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>The name of the filter. Minimum length of 3. Maximum length of 64. Valid characters include alphanumeric characters, dot (.), underscore (_), and dash (-). Spaces are not allowed.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the filter.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Specifies the action that is to be applied to the findings that match the filter.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::FilterAction> {
        self.action.as_ref()
    }
    /// <p>Specifies the position of the filter in the list of current filters. Also specifies the order in which this filter is applied to the findings.</p>
    pub fn rank(&self) -> i32 {
        self.rank
    }
    /// <p>Represents the criteria to be used in the filter for querying findings.</p>
    /// <p>You can only use the following attributes to query findings:</p>
    /// <ul>
    /// <li> <p>accountId</p> </li>
    /// <li> <p>region</p> </li>
    /// <li> <p>confidence</p> </li>
    /// <li> <p>id</p> </li>
    /// <li> <p>resource.accessKeyDetails.accessKeyId</p> </li>
    /// <li> <p>resource.accessKeyDetails.principalId</p> </li>
    /// <li> <p>resource.accessKeyDetails.userName</p> </li>
    /// <li> <p>resource.accessKeyDetails.userType</p> </li>
    /// <li> <p>resource.instanceDetails.iamInstanceProfile.id</p> </li>
    /// <li> <p>resource.instanceDetails.imageId</p> </li>
    /// <li> <p>resource.instanceDetails.instanceId</p> </li>
    /// <li> <p>resource.instanceDetails.outpostArn</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.ipv6Addresses</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.publicDnsName</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.publicIp</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.securityGroups.groupId</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.securityGroups.groupName</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.subnetId</p> </li>
    /// <li> <p>resource.instanceDetails.networkInterfaces.vpcId</p> </li>
    /// <li> <p>resource.instanceDetails.tags.key</p> </li>
    /// <li> <p>resource.instanceDetails.tags.value</p> </li>
    /// <li> <p>resource.resourceType</p> </li>
    /// <li> <p>service.action.actionType</p> </li>
    /// <li> <p>service.action.awsApiCallAction.api</p> </li>
    /// <li> <p>service.action.awsApiCallAction.callerType</p> </li>
    /// <li> <p>service.action.awsApiCallAction.errorCode</p> </li>
    /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.city.cityName</p> </li>
    /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.country.countryName</p> </li>
    /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.ipAddressV4</p> </li>
    /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.organization.asn</p> </li>
    /// <li> <p>service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg</p> </li>
    /// <li> <p>service.action.awsApiCallAction.serviceName</p> </li>
    /// <li> <p>service.action.dnsRequestAction.domain</p> </li>
    /// <li> <p>service.action.networkConnectionAction.blocked</p> </li>
    /// <li> <p>service.action.networkConnectionAction.connectionDirection</p> </li>
    /// <li> <p>service.action.networkConnectionAction.localPortDetails.port</p> </li>
    /// <li> <p>service.action.networkConnectionAction.protocol</p> </li>
    /// <li> <p>service.action.networkConnectionAction.localIpDetails.ipAddressV4</p> </li>
    /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.city.cityName</p> </li>
    /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.country.countryName</p> </li>
    /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.ipAddressV4</p> </li>
    /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.organization.asn</p> </li>
    /// <li> <p>service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg</p> </li>
    /// <li> <p>service.action.networkConnectionAction.remotePortDetails.port</p> </li>
    /// <li> <p>service.additionalInfo.threatListName</p> </li>
    /// <li> <p>resource.s3BucketDetails.publicAccess.effectivePermissions</p> </li>
    /// <li> <p>resource.s3BucketDetails.name</p> </li>
    /// <li> <p>resource.s3BucketDetails.tags.key</p> </li>
    /// <li> <p>resource.s3BucketDetails.tags.value</p> </li>
    /// <li> <p>resource.s3BucketDetails.type</p> </li>
    /// <li> <p>service.archived</p> <p>When this attribute is set to TRUE, only archived findings are listed. When it's set to FALSE, only unarchived findings are listed. When this attribute is not set, all existing findings are listed.</p> </li>
    /// <li> <p>service.resourceRole</p> </li>
    /// <li> <p>severity</p> </li>
    /// <li> <p>type</p> </li>
    /// <li> <p>updatedAt</p> <p>Type: ISO 8601 string format: YYYY-MM-DDTHH:MM:SS.SSSZ or YYYY-MM-DDTHH:MM:SSZ depending on whether the value contains milliseconds.</p> </li>
    /// </ul>
    pub fn finding_criteria(&self) -> std::option::Option<&crate::model::FindingCriteria> {
        self.finding_criteria.as_ref()
    }
    /// <p>The idempotency token for the create request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The tags to be added to a new filter resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateFilterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFilterInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("action", &self.action);
        formatter.field("rank", &self.rank);
        formatter.field("finding_criteria", &self.finding_criteria);
        formatter.field("client_token", &self.client_token);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDetectorInput {
    /// <p>A Boolean value that specifies whether the detector is to be enabled.</p>
    pub enable: bool,
    /// <p>The idempotency token for the create request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>A value that specifies how frequently updated findings are exported.</p>
    pub finding_publishing_frequency: std::option::Option<crate::model::FindingPublishingFrequency>,
    /// <p>Describes which data sources will be enabled for the detector.</p>
    pub data_sources: std::option::Option<crate::model::DataSourceConfigurations>,
    /// <p>The tags to be added to a new detector resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateDetectorInput {
    /// <p>A Boolean value that specifies whether the detector is to be enabled.</p>
    pub fn enable(&self) -> bool {
        self.enable
    }
    /// <p>The idempotency token for the create request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>A value that specifies how frequently updated findings are exported.</p>
    pub fn finding_publishing_frequency(
        &self,
    ) -> std::option::Option<&crate::model::FindingPublishingFrequency> {
        self.finding_publishing_frequency.as_ref()
    }
    /// <p>Describes which data sources will be enabled for the detector.</p>
    pub fn data_sources(&self) -> std::option::Option<&crate::model::DataSourceConfigurations> {
        self.data_sources.as_ref()
    }
    /// <p>The tags to be added to a new detector resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateDetectorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDetectorInput");
        formatter.field("enable", &self.enable);
        formatter.field("client_token", &self.client_token);
        formatter.field(
            "finding_publishing_frequency",
            &self.finding_publishing_frequency,
        );
        formatter.field("data_sources", &self.data_sources);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ArchiveFindingsInput {
    /// <p>The ID of the detector that specifies the GuardDuty service whose findings you want to archive.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The IDs of the findings that you want to archive.</p>
    pub finding_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ArchiveFindingsInput {
    /// <p>The ID of the detector that specifies the GuardDuty service whose findings you want to archive.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>The IDs of the findings that you want to archive.</p>
    pub fn finding_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.finding_ids.as_deref()
    }
}
impl std::fmt::Debug for ArchiveFindingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ArchiveFindingsInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("finding_ids", &self.finding_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptInvitationInput {
    /// <p>The unique ID of the detector of the GuardDuty member account.</p>
    pub detector_id: std::option::Option<std::string::String>,
    /// <p>The account ID of the GuardDuty administrator account whose invitation you're accepting.</p>
    pub master_id: std::option::Option<std::string::String>,
    /// <p>The value that is used to validate the administrator account to the member account.</p>
    pub invitation_id: std::option::Option<std::string::String>,
}
impl AcceptInvitationInput {
    /// <p>The unique ID of the detector of the GuardDuty member account.</p>
    pub fn detector_id(&self) -> std::option::Option<&str> {
        self.detector_id.as_deref()
    }
    /// <p>The account ID of the GuardDuty administrator account whose invitation you're accepting.</p>
    pub fn master_id(&self) -> std::option::Option<&str> {
        self.master_id.as_deref()
    }
    /// <p>The value that is used to validate the administrator account to the member account.</p>
    pub fn invitation_id(&self) -> std::option::Option<&str> {
        self.invitation_id.as_deref()
    }
}
impl std::fmt::Debug for AcceptInvitationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptInvitationInput");
        formatter.field("detector_id", &self.detector_id);
        formatter.field("master_id", &self.master_id);
        formatter.field("invitation_id", &self.invitation_id);
        formatter.finish()
    }
}
