// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for Amazon GuardDuty
///
/// Client for invoking operations on Amazon GuardDuty. Each operation on Amazon GuardDuty is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_guardduty::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_guardduty::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_guardduty::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AcceptInvitation` operation.
    ///
    /// See [`AcceptInvitation`](crate::client::fluent_builders::AcceptInvitation) for more information about the
    /// operation and its arguments.
    pub fn accept_invitation(&self) -> fluent_builders::AcceptInvitation<C, M, R> {
        fluent_builders::AcceptInvitation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ArchiveFindings` operation.
    ///
    /// See [`ArchiveFindings`](crate::client::fluent_builders::ArchiveFindings) for more information about the
    /// operation and its arguments.
    pub fn archive_findings(&self) -> fluent_builders::ArchiveFindings<C, M, R> {
        fluent_builders::ArchiveFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDetector` operation.
    ///
    /// See [`CreateDetector`](crate::client::fluent_builders::CreateDetector) for more information about the
    /// operation and its arguments.
    pub fn create_detector(&self) -> fluent_builders::CreateDetector<C, M, R> {
        fluent_builders::CreateDetector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFilter` operation.
    ///
    /// See [`CreateFilter`](crate::client::fluent_builders::CreateFilter) for more information about the
    /// operation and its arguments.
    pub fn create_filter(&self) -> fluent_builders::CreateFilter<C, M, R> {
        fluent_builders::CreateFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateIPSet` operation.
    ///
    /// See [`CreateIPSet`](crate::client::fluent_builders::CreateIPSet) for more information about the
    /// operation and its arguments.
    pub fn create_ip_set(&self) -> fluent_builders::CreateIPSet<C, M, R> {
        fluent_builders::CreateIPSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateMembers` operation.
    ///
    /// See [`CreateMembers`](crate::client::fluent_builders::CreateMembers) for more information about the
    /// operation and its arguments.
    pub fn create_members(&self) -> fluent_builders::CreateMembers<C, M, R> {
        fluent_builders::CreateMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePublishingDestination` operation.
    ///
    /// See [`CreatePublishingDestination`](crate::client::fluent_builders::CreatePublishingDestination) for more information about the
    /// operation and its arguments.
    pub fn create_publishing_destination(
        &self,
    ) -> fluent_builders::CreatePublishingDestination<C, M, R> {
        fluent_builders::CreatePublishingDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSampleFindings` operation.
    ///
    /// See [`CreateSampleFindings`](crate::client::fluent_builders::CreateSampleFindings) for more information about the
    /// operation and its arguments.
    pub fn create_sample_findings(&self) -> fluent_builders::CreateSampleFindings<C, M, R> {
        fluent_builders::CreateSampleFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateThreatIntelSet` operation.
    ///
    /// See [`CreateThreatIntelSet`](crate::client::fluent_builders::CreateThreatIntelSet) for more information about the
    /// operation and its arguments.
    pub fn create_threat_intel_set(&self) -> fluent_builders::CreateThreatIntelSet<C, M, R> {
        fluent_builders::CreateThreatIntelSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeclineInvitations` operation.
    ///
    /// See [`DeclineInvitations`](crate::client::fluent_builders::DeclineInvitations) for more information about the
    /// operation and its arguments.
    pub fn decline_invitations(&self) -> fluent_builders::DeclineInvitations<C, M, R> {
        fluent_builders::DeclineInvitations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDetector` operation.
    ///
    /// See [`DeleteDetector`](crate::client::fluent_builders::DeleteDetector) for more information about the
    /// operation and its arguments.
    pub fn delete_detector(&self) -> fluent_builders::DeleteDetector<C, M, R> {
        fluent_builders::DeleteDetector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFilter` operation.
    ///
    /// See [`DeleteFilter`](crate::client::fluent_builders::DeleteFilter) for more information about the
    /// operation and its arguments.
    pub fn delete_filter(&self) -> fluent_builders::DeleteFilter<C, M, R> {
        fluent_builders::DeleteFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteInvitations` operation.
    ///
    /// See [`DeleteInvitations`](crate::client::fluent_builders::DeleteInvitations) for more information about the
    /// operation and its arguments.
    pub fn delete_invitations(&self) -> fluent_builders::DeleteInvitations<C, M, R> {
        fluent_builders::DeleteInvitations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteIPSet` operation.
    ///
    /// See [`DeleteIPSet`](crate::client::fluent_builders::DeleteIPSet) for more information about the
    /// operation and its arguments.
    pub fn delete_ip_set(&self) -> fluent_builders::DeleteIPSet<C, M, R> {
        fluent_builders::DeleteIPSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteMembers` operation.
    ///
    /// See [`DeleteMembers`](crate::client::fluent_builders::DeleteMembers) for more information about the
    /// operation and its arguments.
    pub fn delete_members(&self) -> fluent_builders::DeleteMembers<C, M, R> {
        fluent_builders::DeleteMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePublishingDestination` operation.
    ///
    /// See [`DeletePublishingDestination`](crate::client::fluent_builders::DeletePublishingDestination) for more information about the
    /// operation and its arguments.
    pub fn delete_publishing_destination(
        &self,
    ) -> fluent_builders::DeletePublishingDestination<C, M, R> {
        fluent_builders::DeletePublishingDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteThreatIntelSet` operation.
    ///
    /// See [`DeleteThreatIntelSet`](crate::client::fluent_builders::DeleteThreatIntelSet) for more information about the
    /// operation and its arguments.
    pub fn delete_threat_intel_set(&self) -> fluent_builders::DeleteThreatIntelSet<C, M, R> {
        fluent_builders::DeleteThreatIntelSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeOrganizationConfiguration` operation.
    ///
    /// See [`DescribeOrganizationConfiguration`](crate::client::fluent_builders::DescribeOrganizationConfiguration) for more information about the
    /// operation and its arguments.
    pub fn describe_organization_configuration(
        &self,
    ) -> fluent_builders::DescribeOrganizationConfiguration<C, M, R> {
        fluent_builders::DescribeOrganizationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePublishingDestination` operation.
    ///
    /// See [`DescribePublishingDestination`](crate::client::fluent_builders::DescribePublishingDestination) for more information about the
    /// operation and its arguments.
    pub fn describe_publishing_destination(
        &self,
    ) -> fluent_builders::DescribePublishingDestination<C, M, R> {
        fluent_builders::DescribePublishingDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableOrganizationAdminAccount` operation.
    ///
    /// See [`DisableOrganizationAdminAccount`](crate::client::fluent_builders::DisableOrganizationAdminAccount) for more information about the
    /// operation and its arguments.
    pub fn disable_organization_admin_account(
        &self,
    ) -> fluent_builders::DisableOrganizationAdminAccount<C, M, R> {
        fluent_builders::DisableOrganizationAdminAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateFromMasterAccount` operation.
    ///
    /// See [`DisassociateFromMasterAccount`](crate::client::fluent_builders::DisassociateFromMasterAccount) for more information about the
    /// operation and its arguments.
    pub fn disassociate_from_master_account(
        &self,
    ) -> fluent_builders::DisassociateFromMasterAccount<C, M, R> {
        fluent_builders::DisassociateFromMasterAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateMembers` operation.
    ///
    /// See [`DisassociateMembers`](crate::client::fluent_builders::DisassociateMembers) for more information about the
    /// operation and its arguments.
    pub fn disassociate_members(&self) -> fluent_builders::DisassociateMembers<C, M, R> {
        fluent_builders::DisassociateMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableOrganizationAdminAccount` operation.
    ///
    /// See [`EnableOrganizationAdminAccount`](crate::client::fluent_builders::EnableOrganizationAdminAccount) for more information about the
    /// operation and its arguments.
    pub fn enable_organization_admin_account(
        &self,
    ) -> fluent_builders::EnableOrganizationAdminAccount<C, M, R> {
        fluent_builders::EnableOrganizationAdminAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDetector` operation.
    ///
    /// See [`GetDetector`](crate::client::fluent_builders::GetDetector) for more information about the
    /// operation and its arguments.
    pub fn get_detector(&self) -> fluent_builders::GetDetector<C, M, R> {
        fluent_builders::GetDetector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFilter` operation.
    ///
    /// See [`GetFilter`](crate::client::fluent_builders::GetFilter) for more information about the
    /// operation and its arguments.
    pub fn get_filter(&self) -> fluent_builders::GetFilter<C, M, R> {
        fluent_builders::GetFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFindings` operation.
    ///
    /// See [`GetFindings`](crate::client::fluent_builders::GetFindings) for more information about the
    /// operation and its arguments.
    pub fn get_findings(&self) -> fluent_builders::GetFindings<C, M, R> {
        fluent_builders::GetFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFindingsStatistics` operation.
    ///
    /// See [`GetFindingsStatistics`](crate::client::fluent_builders::GetFindingsStatistics) for more information about the
    /// operation and its arguments.
    pub fn get_findings_statistics(&self) -> fluent_builders::GetFindingsStatistics<C, M, R> {
        fluent_builders::GetFindingsStatistics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetInvitationsCount` operation.
    ///
    /// See [`GetInvitationsCount`](crate::client::fluent_builders::GetInvitationsCount) for more information about the
    /// operation and its arguments.
    pub fn get_invitations_count(&self) -> fluent_builders::GetInvitationsCount<C, M, R> {
        fluent_builders::GetInvitationsCount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetIPSet` operation.
    ///
    /// See [`GetIPSet`](crate::client::fluent_builders::GetIPSet) for more information about the
    /// operation and its arguments.
    pub fn get_ip_set(&self) -> fluent_builders::GetIPSet<C, M, R> {
        fluent_builders::GetIPSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMasterAccount` operation.
    ///
    /// See [`GetMasterAccount`](crate::client::fluent_builders::GetMasterAccount) for more information about the
    /// operation and its arguments.
    pub fn get_master_account(&self) -> fluent_builders::GetMasterAccount<C, M, R> {
        fluent_builders::GetMasterAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMemberDetectors` operation.
    ///
    /// See [`GetMemberDetectors`](crate::client::fluent_builders::GetMemberDetectors) for more information about the
    /// operation and its arguments.
    pub fn get_member_detectors(&self) -> fluent_builders::GetMemberDetectors<C, M, R> {
        fluent_builders::GetMemberDetectors::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMembers` operation.
    ///
    /// See [`GetMembers`](crate::client::fluent_builders::GetMembers) for more information about the
    /// operation and its arguments.
    pub fn get_members(&self) -> fluent_builders::GetMembers<C, M, R> {
        fluent_builders::GetMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetThreatIntelSet` operation.
    ///
    /// See [`GetThreatIntelSet`](crate::client::fluent_builders::GetThreatIntelSet) for more information about the
    /// operation and its arguments.
    pub fn get_threat_intel_set(&self) -> fluent_builders::GetThreatIntelSet<C, M, R> {
        fluent_builders::GetThreatIntelSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetUsageStatistics` operation.
    ///
    /// See [`GetUsageStatistics`](crate::client::fluent_builders::GetUsageStatistics) for more information about the
    /// operation and its arguments.
    pub fn get_usage_statistics(&self) -> fluent_builders::GetUsageStatistics<C, M, R> {
        fluent_builders::GetUsageStatistics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `InviteMembers` operation.
    ///
    /// See [`InviteMembers`](crate::client::fluent_builders::InviteMembers) for more information about the
    /// operation and its arguments.
    pub fn invite_members(&self) -> fluent_builders::InviteMembers<C, M, R> {
        fluent_builders::InviteMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDetectors` operation.
    ///
    /// See [`ListDetectors`](crate::client::fluent_builders::ListDetectors) for more information about the
    /// operation and its arguments.
    pub fn list_detectors(&self) -> fluent_builders::ListDetectors<C, M, R> {
        fluent_builders::ListDetectors::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFilters` operation.
    ///
    /// See [`ListFilters`](crate::client::fluent_builders::ListFilters) for more information about the
    /// operation and its arguments.
    pub fn list_filters(&self) -> fluent_builders::ListFilters<C, M, R> {
        fluent_builders::ListFilters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFindings` operation.
    ///
    /// See [`ListFindings`](crate::client::fluent_builders::ListFindings) for more information about the
    /// operation and its arguments.
    pub fn list_findings(&self) -> fluent_builders::ListFindings<C, M, R> {
        fluent_builders::ListFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListInvitations` operation.
    ///
    /// See [`ListInvitations`](crate::client::fluent_builders::ListInvitations) for more information about the
    /// operation and its arguments.
    pub fn list_invitations(&self) -> fluent_builders::ListInvitations<C, M, R> {
        fluent_builders::ListInvitations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListIPSets` operation.
    ///
    /// See [`ListIPSets`](crate::client::fluent_builders::ListIPSets) for more information about the
    /// operation and its arguments.
    pub fn list_ip_sets(&self) -> fluent_builders::ListIPSets<C, M, R> {
        fluent_builders::ListIPSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListMembers` operation.
    ///
    /// See [`ListMembers`](crate::client::fluent_builders::ListMembers) for more information about the
    /// operation and its arguments.
    pub fn list_members(&self) -> fluent_builders::ListMembers<C, M, R> {
        fluent_builders::ListMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListOrganizationAdminAccounts` operation.
    ///
    /// See [`ListOrganizationAdminAccounts`](crate::client::fluent_builders::ListOrganizationAdminAccounts) for more information about the
    /// operation and its arguments.
    pub fn list_organization_admin_accounts(
        &self,
    ) -> fluent_builders::ListOrganizationAdminAccounts<C, M, R> {
        fluent_builders::ListOrganizationAdminAccounts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPublishingDestinations` operation.
    ///
    /// See [`ListPublishingDestinations`](crate::client::fluent_builders::ListPublishingDestinations) for more information about the
    /// operation and its arguments.
    pub fn list_publishing_destinations(
        &self,
    ) -> fluent_builders::ListPublishingDestinations<C, M, R> {
        fluent_builders::ListPublishingDestinations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListThreatIntelSets` operation.
    ///
    /// See [`ListThreatIntelSets`](crate::client::fluent_builders::ListThreatIntelSets) for more information about the
    /// operation and its arguments.
    pub fn list_threat_intel_sets(&self) -> fluent_builders::ListThreatIntelSets<C, M, R> {
        fluent_builders::ListThreatIntelSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartMonitoringMembers` operation.
    ///
    /// See [`StartMonitoringMembers`](crate::client::fluent_builders::StartMonitoringMembers) for more information about the
    /// operation and its arguments.
    pub fn start_monitoring_members(&self) -> fluent_builders::StartMonitoringMembers<C, M, R> {
        fluent_builders::StartMonitoringMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopMonitoringMembers` operation.
    ///
    /// See [`StopMonitoringMembers`](crate::client::fluent_builders::StopMonitoringMembers) for more information about the
    /// operation and its arguments.
    pub fn stop_monitoring_members(&self) -> fluent_builders::StopMonitoringMembers<C, M, R> {
        fluent_builders::StopMonitoringMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UnarchiveFindings` operation.
    ///
    /// See [`UnarchiveFindings`](crate::client::fluent_builders::UnarchiveFindings) for more information about the
    /// operation and its arguments.
    pub fn unarchive_findings(&self) -> fluent_builders::UnarchiveFindings<C, M, R> {
        fluent_builders::UnarchiveFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDetector` operation.
    ///
    /// See [`UpdateDetector`](crate::client::fluent_builders::UpdateDetector) for more information about the
    /// operation and its arguments.
    pub fn update_detector(&self) -> fluent_builders::UpdateDetector<C, M, R> {
        fluent_builders::UpdateDetector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFilter` operation.
    ///
    /// See [`UpdateFilter`](crate::client::fluent_builders::UpdateFilter) for more information about the
    /// operation and its arguments.
    pub fn update_filter(&self) -> fluent_builders::UpdateFilter<C, M, R> {
        fluent_builders::UpdateFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFindingsFeedback` operation.
    ///
    /// See [`UpdateFindingsFeedback`](crate::client::fluent_builders::UpdateFindingsFeedback) for more information about the
    /// operation and its arguments.
    pub fn update_findings_feedback(&self) -> fluent_builders::UpdateFindingsFeedback<C, M, R> {
        fluent_builders::UpdateFindingsFeedback::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateIPSet` operation.
    ///
    /// See [`UpdateIPSet`](crate::client::fluent_builders::UpdateIPSet) for more information about the
    /// operation and its arguments.
    pub fn update_ip_set(&self) -> fluent_builders::UpdateIPSet<C, M, R> {
        fluent_builders::UpdateIPSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateMemberDetectors` operation.
    ///
    /// See [`UpdateMemberDetectors`](crate::client::fluent_builders::UpdateMemberDetectors) for more information about the
    /// operation and its arguments.
    pub fn update_member_detectors(&self) -> fluent_builders::UpdateMemberDetectors<C, M, R> {
        fluent_builders::UpdateMemberDetectors::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateOrganizationConfiguration` operation.
    ///
    /// See [`UpdateOrganizationConfiguration`](crate::client::fluent_builders::UpdateOrganizationConfiguration) for more information about the
    /// operation and its arguments.
    pub fn update_organization_configuration(
        &self,
    ) -> fluent_builders::UpdateOrganizationConfiguration<C, M, R> {
        fluent_builders::UpdateOrganizationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdatePublishingDestination` operation.
    ///
    /// See [`UpdatePublishingDestination`](crate::client::fluent_builders::UpdatePublishingDestination) for more information about the
    /// operation and its arguments.
    pub fn update_publishing_destination(
        &self,
    ) -> fluent_builders::UpdatePublishingDestination<C, M, R> {
        fluent_builders::UpdatePublishingDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateThreatIntelSet` operation.
    ///
    /// See [`UpdateThreatIntelSet`](crate::client::fluent_builders::UpdateThreatIntelSet) for more information about the
    /// operation and its arguments.
    pub fn update_threat_intel_set(&self) -> fluent_builders::UpdateThreatIntelSet<C, M, R> {
        fluent_builders::UpdateThreatIntelSet::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptInvitation`.
    ///
    /// <p>Accepts the invitation to be monitored by a GuardDuty administrator account.</p>
    #[derive(std::fmt::Debug)]
    pub struct AcceptInvitation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_invitation_input::Builder,
    }
    impl<C, M, R> AcceptInvitation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptInvitation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptInvitationOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptInvitationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcceptInvitationInputOperationOutputAlias,
                crate::output::AcceptInvitationOutput,
                crate::error::AcceptInvitationError,
                crate::input::AcceptInvitationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the detector of the GuardDuty member account.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The unique ID of the detector of the GuardDuty member account.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The account ID of the GuardDuty administrator account whose invitation you're accepting.</p>
        pub fn master_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_id(inp);
            self
        }
        /// <p>The account ID of the GuardDuty administrator account whose invitation you're accepting.</p>
        pub fn set_master_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_master_id(input);
            self
        }
        /// <p>The value that is used to validate the administrator account to the member account.</p>
        pub fn invitation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.invitation_id(inp);
            self
        }
        /// <p>The value that is used to validate the administrator account to the member account.</p>
        pub fn set_invitation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_invitation_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ArchiveFindings`.
    ///
    /// <p>Archives GuardDuty findings that are specified by the list of finding IDs.</p>
    /// <note>
    /// <p>Only the administrator account can archive findings. Member accounts don't have permission to
    /// archive findings from their accounts.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ArchiveFindings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::archive_findings_input::Builder,
    }
    impl<C, M, R> ArchiveFindings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ArchiveFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ArchiveFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ArchiveFindingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ArchiveFindingsInputOperationOutputAlias,
                crate::output::ArchiveFindingsOutput,
                crate::error::ArchiveFindingsError,
                crate::input::ArchiveFindingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the detector that specifies the GuardDuty service whose findings you want to
        /// archive.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The ID of the detector that specifies the GuardDuty service whose findings you want to
        /// archive.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// Appends an item to `FindingIds`.
        ///
        /// To override the contents of this collection use [`set_finding_ids`](Self::set_finding_ids).
        ///
        /// <p>The IDs of the findings that you want to archive.</p>
        pub fn finding_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.finding_ids(inp);
            self
        }
        /// <p>The IDs of the findings that you want to archive.</p>
        pub fn set_finding_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_finding_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDetector`.
    ///
    /// <p>Creates a single Amazon GuardDuty detector. A detector is a resource that represents the
    /// GuardDuty service. To start using GuardDuty, you must create a detector in each Region where
    /// you enable the service. You can have only one detector per account per Region. All data
    /// sources are enabled in a new detector by default.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDetector<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_detector_input::Builder,
    }
    impl<C, M, R> CreateDetector<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDetector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDetectorOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDetectorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDetectorInputOperationOutputAlias,
                crate::output::CreateDetectorOutput,
                crate::error::CreateDetectorError,
                crate::input::CreateDetectorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A Boolean value that specifies whether the detector is to be enabled.</p>
        pub fn enable(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable(inp);
            self
        }
        /// <p>A Boolean value that specifies whether the detector is to be enabled.</p>
        pub fn set_enable(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable(input);
            self
        }
        /// <p>The idempotency token for the create request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>The idempotency token for the create request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>A value that specifies how frequently updated findings are exported.</p>
        pub fn finding_publishing_frequency(
            mut self,
            inp: crate::model::FindingPublishingFrequency,
        ) -> Self {
            self.inner = self.inner.finding_publishing_frequency(inp);
            self
        }
        /// <p>A value that specifies how frequently updated findings are exported.</p>
        pub fn set_finding_publishing_frequency(
            mut self,
            input: std::option::Option<crate::model::FindingPublishingFrequency>,
        ) -> Self {
            self.inner = self.inner.set_finding_publishing_frequency(input);
            self
        }
        /// <p>Describes which data sources will be enabled for the detector.</p>
        pub fn data_sources(mut self, inp: crate::model::DataSourceConfigurations) -> Self {
            self.inner = self.inner.data_sources(inp);
            self
        }
        /// <p>Describes which data sources will be enabled for the detector.</p>
        pub fn set_data_sources(
            mut self,
            input: std::option::Option<crate::model::DataSourceConfigurations>,
        ) -> Self {
            self.inner = self.inner.set_data_sources(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be added to a new detector resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags to be added to a new detector resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFilter`.
    ///
    /// <p>Creates a filter using the specified finding criteria.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateFilter<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_filter_input::Builder,
    }
    impl<C, M, R> CreateFilter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFilterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFilterInputOperationOutputAlias,
                crate::output::CreateFilterOutput,
                crate::error::CreateFilterError,
                crate::input::CreateFilterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the detector belonging to the GuardDuty account that you want to create a filter
        /// for.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The ID of the detector belonging to the GuardDuty account that you want to create a filter
        /// for.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The name of the filter. Minimum length of 3. Maximum length of 64. Valid characters include alphanumeric characters, dot (.), underscore (_), and dash (-). Spaces are not allowed.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the filter. Minimum length of 3. Maximum length of 64. Valid characters include alphanumeric characters, dot (.), underscore (_), and dash (-). Spaces are not allowed.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the filter.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the filter.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Specifies the action that is to be applied to the findings that match the filter.</p>
        pub fn action(mut self, inp: crate::model::FilterAction) -> Self {
            self.inner = self.inner.action(inp);
            self
        }
        /// <p>Specifies the action that is to be applied to the findings that match the filter.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::FilterAction>,
        ) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>Specifies the position of the filter in the list of current filters. Also specifies the
        /// order in which this filter is applied to the findings.</p>
        pub fn rank(mut self, inp: i32) -> Self {
            self.inner = self.inner.rank(inp);
            self
        }
        /// <p>Specifies the position of the filter in the list of current filters. Also specifies the
        /// order in which this filter is applied to the findings.</p>
        pub fn set_rank(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_rank(input);
            self
        }
        /// <p>Represents the criteria to be used in the filter for querying findings.</p>
        /// <p>You can only use the following attributes to query findings:</p>
        /// <ul>
        /// <li>
        /// <p>accountId</p>
        /// </li>
        /// <li>
        /// <p>region</p>
        /// </li>
        /// <li>
        /// <p>confidence</p>
        /// </li>
        /// <li>
        /// <p>id</p>
        /// </li>
        /// <li>
        /// <p>resource.accessKeyDetails.accessKeyId</p>
        /// </li>
        /// <li>
        /// <p>resource.accessKeyDetails.principalId</p>
        /// </li>
        /// <li>
        /// <p>resource.accessKeyDetails.userName</p>
        /// </li>
        /// <li>
        /// <p>resource.accessKeyDetails.userType</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.iamInstanceProfile.id</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.imageId</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.instanceId</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.outpostArn</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.ipv6Addresses</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.publicDnsName</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.publicIp</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.securityGroups.groupId</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.securityGroups.groupName</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.subnetId</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.vpcId</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.tags.key</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.tags.value</p>
        /// </li>
        /// <li>
        /// <p>resource.resourceType</p>
        /// </li>
        /// <li>
        /// <p>service.action.actionType</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.api</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.callerType</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.errorCode</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.remoteIpDetails.city.cityName</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.remoteIpDetails.country.countryName</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.remoteIpDetails.ipAddressV4</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.remoteIpDetails.organization.asn</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.serviceName</p>
        /// </li>
        /// <li>
        /// <p>service.action.dnsRequestAction.domain</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.blocked</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.connectionDirection</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.localPortDetails.port</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.protocol</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.localIpDetails.ipAddressV4</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.remoteIpDetails.city.cityName</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.remoteIpDetails.country.countryName</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.remoteIpDetails.ipAddressV4</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.remoteIpDetails.organization.asn</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.remotePortDetails.port</p>
        /// </li>
        /// <li>
        /// <p>service.additionalInfo.threatListName</p>
        /// </li>
        /// <li>
        /// <p>service.archived</p>
        /// <p>When this attribute is set to TRUE, only archived findings are listed. When it's set
        /// to FALSE, only unarchived findings are listed. When this attribute is not set, all
        /// existing findings are listed.</p>
        /// </li>
        /// <li>
        /// <p>service.resourceRole</p>
        /// </li>
        /// <li>
        /// <p>severity</p>
        /// </li>
        /// <li>
        /// <p>type</p>
        /// </li>
        /// <li>
        /// <p>updatedAt</p>
        /// <p>Type: ISO 8601 string format: YYYY-MM-DDTHH:MM:SS.SSSZ or YYYY-MM-DDTHH:MM:SSZ
        /// depending on whether the value contains milliseconds.</p>
        /// </li>
        /// </ul>
        pub fn finding_criteria(mut self, inp: crate::model::FindingCriteria) -> Self {
            self.inner = self.inner.finding_criteria(inp);
            self
        }
        /// <p>Represents the criteria to be used in the filter for querying findings.</p>
        /// <p>You can only use the following attributes to query findings:</p>
        /// <ul>
        /// <li>
        /// <p>accountId</p>
        /// </li>
        /// <li>
        /// <p>region</p>
        /// </li>
        /// <li>
        /// <p>confidence</p>
        /// </li>
        /// <li>
        /// <p>id</p>
        /// </li>
        /// <li>
        /// <p>resource.accessKeyDetails.accessKeyId</p>
        /// </li>
        /// <li>
        /// <p>resource.accessKeyDetails.principalId</p>
        /// </li>
        /// <li>
        /// <p>resource.accessKeyDetails.userName</p>
        /// </li>
        /// <li>
        /// <p>resource.accessKeyDetails.userType</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.iamInstanceProfile.id</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.imageId</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.instanceId</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.outpostArn</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.ipv6Addresses</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.publicDnsName</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.publicIp</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.securityGroups.groupId</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.securityGroups.groupName</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.subnetId</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.vpcId</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.tags.key</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.tags.value</p>
        /// </li>
        /// <li>
        /// <p>resource.resourceType</p>
        /// </li>
        /// <li>
        /// <p>service.action.actionType</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.api</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.callerType</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.errorCode</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.remoteIpDetails.city.cityName</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.remoteIpDetails.country.countryName</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.remoteIpDetails.ipAddressV4</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.remoteIpDetails.organization.asn</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.serviceName</p>
        /// </li>
        /// <li>
        /// <p>service.action.dnsRequestAction.domain</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.blocked</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.connectionDirection</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.localPortDetails.port</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.protocol</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.localIpDetails.ipAddressV4</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.remoteIpDetails.city.cityName</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.remoteIpDetails.country.countryName</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.remoteIpDetails.ipAddressV4</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.remoteIpDetails.organization.asn</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.remotePortDetails.port</p>
        /// </li>
        /// <li>
        /// <p>service.additionalInfo.threatListName</p>
        /// </li>
        /// <li>
        /// <p>service.archived</p>
        /// <p>When this attribute is set to TRUE, only archived findings are listed. When it's set
        /// to FALSE, only unarchived findings are listed. When this attribute is not set, all
        /// existing findings are listed.</p>
        /// </li>
        /// <li>
        /// <p>service.resourceRole</p>
        /// </li>
        /// <li>
        /// <p>severity</p>
        /// </li>
        /// <li>
        /// <p>type</p>
        /// </li>
        /// <li>
        /// <p>updatedAt</p>
        /// <p>Type: ISO 8601 string format: YYYY-MM-DDTHH:MM:SS.SSSZ or YYYY-MM-DDTHH:MM:SSZ
        /// depending on whether the value contains milliseconds.</p>
        /// </li>
        /// </ul>
        pub fn set_finding_criteria(
            mut self,
            input: std::option::Option<crate::model::FindingCriteria>,
        ) -> Self {
            self.inner = self.inner.set_finding_criteria(input);
            self
        }
        /// <p>The idempotency token for the create request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>The idempotency token for the create request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be added to a new filter resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags to be added to a new filter resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateIPSet`.
    ///
    /// <p>Creates a new IPSet, which is called a trusted IP list in the console user interface. An
    /// IPSet is a list of IP addresses that are trusted for secure communication with AWS
    /// infrastructure and applications. GuardDuty doesn't generate findings for IP addresses that are
    /// included in IPSets. Only users from the administrator account can use this operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateIPSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_ip_set_input::Builder,
    }
    impl<C, M, R> CreateIPSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateIPSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIpSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIPSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateIpSetInputOperationOutputAlias,
                crate::output::CreateIpSetOutput,
                crate::error::CreateIPSetError,
                crate::input::CreateIpSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the detector of the GuardDuty account that you want to create an IPSet
        /// for.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The unique ID of the detector of the GuardDuty account that you want to create an IPSet
        /// for.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The user-friendly name to identify the IPSet.</p>
        /// <p> Allowed characters are alphanumerics, spaces, hyphens (-), and underscores (_).</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The user-friendly name to identify the IPSet.</p>
        /// <p> Allowed characters are alphanumerics, spaces, hyphens (-), and underscores (_).</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The format of the file that contains the IPSet.</p>
        pub fn format(mut self, inp: crate::model::IpSetFormat) -> Self {
            self.inner = self.inner.format(inp);
            self
        }
        /// <p>The format of the file that contains the IPSet.</p>
        pub fn set_format(mut self, input: std::option::Option<crate::model::IpSetFormat>) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p>The URI of the file that contains the IPSet. For example:
        /// https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key.</p>
        pub fn location(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location(inp);
            self
        }
        /// <p>The URI of the file that contains the IPSet. For example:
        /// https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location(input);
            self
        }
        /// <p>A Boolean value that indicates whether GuardDuty is to start using the uploaded
        /// IPSet.</p>
        pub fn activate(mut self, inp: bool) -> Self {
            self.inner = self.inner.activate(inp);
            self
        }
        /// <p>A Boolean value that indicates whether GuardDuty is to start using the uploaded
        /// IPSet.</p>
        pub fn set_activate(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_activate(input);
            self
        }
        /// <p>The idempotency token for the create request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>The idempotency token for the create request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be added to a new IP set resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags to be added to a new IP set resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMembers`.
    ///
    /// <p>Creates member accounts of the current AWS account by specifying a list of AWS account
    /// IDs. This step is a prerequisite for managing the associated member accounts either by
    /// invitation or through an organization.</p>
    /// <p>When using <code>Create Members</code> as an organizations delegated administrator this
    /// action will enable GuardDuty in the added member accounts, with the exception of the
    /// organization delegated administrator account, which must enable GuardDuty prior to being added as a
    /// member.</p>
    /// <p>If you are adding accounts by invitation use this action after GuardDuty has been enabled
    /// in potential member accounts and before using <a href="https://docs.aws.amazon.com/guardduty/latest/APIReference/API_InviteMembers.html">
    /// <code>Invite
    /// Members</code>
    /// </a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateMembers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_members_input::Builder,
    }
    impl<C, M, R> CreateMembers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMembersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMembersInputOperationOutputAlias,
                crate::output::CreateMembersOutput,
                crate::error::CreateMembersError,
                crate::input::CreateMembersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the detector of the GuardDuty account that you want to associate member
        /// accounts with.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The unique ID of the detector of the GuardDuty account that you want to associate member
        /// accounts with.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// Appends an item to `AccountDetails`.
        ///
        /// To override the contents of this collection use [`set_account_details`](Self::set_account_details).
        ///
        /// <p>A list of account ID and email address pairs of the accounts that you want to associate
        /// with the GuardDuty administrator account.</p>
        pub fn account_details(mut self, inp: impl Into<crate::model::AccountDetail>) -> Self {
            self.inner = self.inner.account_details(inp);
            self
        }
        /// <p>A list of account ID and email address pairs of the accounts that you want to associate
        /// with the GuardDuty administrator account.</p>
        pub fn set_account_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccountDetail>>,
        ) -> Self {
            self.inner = self.inner.set_account_details(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePublishingDestination`.
    ///
    /// <p>Creates a publishing destination to export findings to. The resource to export findings to
    /// must exist before you use this operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreatePublishingDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_publishing_destination_input::Builder,
    }
    impl<C, M, R> CreatePublishingDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePublishingDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePublishingDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePublishingDestinationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePublishingDestinationInputOperationOutputAlias,
                crate::output::CreatePublishingDestinationOutput,
                crate::error::CreatePublishingDestinationError,
                crate::input::CreatePublishingDestinationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the GuardDuty detector associated with the publishing destination.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The ID of the GuardDuty detector associated with the publishing destination.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The type of resource for the publishing destination. Currently only Amazon S3 buckets are
        /// supported.</p>
        pub fn destination_type(mut self, inp: crate::model::DestinationType) -> Self {
            self.inner = self.inner.destination_type(inp);
            self
        }
        /// <p>The type of resource for the publishing destination. Currently only Amazon S3 buckets are
        /// supported.</p>
        pub fn set_destination_type(
            mut self,
            input: std::option::Option<crate::model::DestinationType>,
        ) -> Self {
            self.inner = self.inner.set_destination_type(input);
            self
        }
        /// <p>The properties of the publishing destination, including the ARNs for the destination and
        /// the KMS key used for encryption.</p>
        pub fn destination_properties(mut self, inp: crate::model::DestinationProperties) -> Self {
            self.inner = self.inner.destination_properties(inp);
            self
        }
        /// <p>The properties of the publishing destination, including the ARNs for the destination and
        /// the KMS key used for encryption.</p>
        pub fn set_destination_properties(
            mut self,
            input: std::option::Option<crate::model::DestinationProperties>,
        ) -> Self {
            self.inner = self.inner.set_destination_properties(input);
            self
        }
        /// <p>The idempotency token for the request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>The idempotency token for the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSampleFindings`.
    ///
    /// <p>Generates example findings of types specified by the list of finding types. If 'NULL' is
    /// specified for <code>findingTypes</code>, the API generates example findings of all supported
    /// finding types.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateSampleFindings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_sample_findings_input::Builder,
    }
    impl<C, M, R> CreateSampleFindings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSampleFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSampleFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSampleFindingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSampleFindingsInputOperationOutputAlias,
                crate::output::CreateSampleFindingsOutput,
                crate::error::CreateSampleFindingsError,
                crate::input::CreateSampleFindingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the detector to create sample findings for.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The ID of the detector to create sample findings for.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// Appends an item to `FindingTypes`.
        ///
        /// To override the contents of this collection use [`set_finding_types`](Self::set_finding_types).
        ///
        /// <p>The types of sample findings to generate.</p>
        pub fn finding_types(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.finding_types(inp);
            self
        }
        /// <p>The types of sample findings to generate.</p>
        pub fn set_finding_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_finding_types(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateThreatIntelSet`.
    ///
    /// <p>Creates a new ThreatIntelSet. ThreatIntelSets consist of known malicious IP addresses.
    /// GuardDuty generates findings based on ThreatIntelSets. Only users of the administrator account can
    /// use this operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateThreatIntelSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_threat_intel_set_input::Builder,
    }
    impl<C, M, R> CreateThreatIntelSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateThreatIntelSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateThreatIntelSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateThreatIntelSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateThreatIntelSetInputOperationOutputAlias,
                crate::output::CreateThreatIntelSetOutput,
                crate::error::CreateThreatIntelSetError,
                crate::input::CreateThreatIntelSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the detector of the GuardDuty account that you want to create a
        /// threatIntelSet for.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The unique ID of the detector of the GuardDuty account that you want to create a
        /// threatIntelSet for.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>A user-friendly ThreatIntelSet name displayed in all findings that are generated by
        /// activity that involves IP addresses included in this ThreatIntelSet.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A user-friendly ThreatIntelSet name displayed in all findings that are generated by
        /// activity that involves IP addresses included in this ThreatIntelSet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The format of the file that contains the ThreatIntelSet.</p>
        pub fn format(mut self, inp: crate::model::ThreatIntelSetFormat) -> Self {
            self.inner = self.inner.format(inp);
            self
        }
        /// <p>The format of the file that contains the ThreatIntelSet.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::ThreatIntelSetFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p>The URI of the file that contains the ThreatIntelSet. For example:
        /// https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key.</p>
        pub fn location(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location(inp);
            self
        }
        /// <p>The URI of the file that contains the ThreatIntelSet. For example:
        /// https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location(input);
            self
        }
        /// <p>A Boolean value that indicates whether GuardDuty is to start using the uploaded
        /// ThreatIntelSet.</p>
        pub fn activate(mut self, inp: bool) -> Self {
            self.inner = self.inner.activate(inp);
            self
        }
        /// <p>A Boolean value that indicates whether GuardDuty is to start using the uploaded
        /// ThreatIntelSet.</p>
        pub fn set_activate(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_activate(input);
            self
        }
        /// <p>The idempotency token for the create request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>The idempotency token for the create request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be added to a new threat list resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags to be added to a new threat list resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeclineInvitations`.
    ///
    /// <p>Declines invitations sent to the current member account by AWS accounts specified by their
    /// account IDs.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeclineInvitations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::decline_invitations_input::Builder,
    }
    impl<C, M, R> DeclineInvitations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeclineInvitations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeclineInvitationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeclineInvitationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeclineInvitationsInputOperationOutputAlias,
                crate::output::DeclineInvitationsOutput,
                crate::error::DeclineInvitationsError,
                crate::input::DeclineInvitationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>A list of account IDs of the AWS accounts that sent invitations to the current member
        /// account that you want to decline invitations from.</p>
        pub fn account_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(inp);
            self
        }
        /// <p>A list of account IDs of the AWS accounts that sent invitations to the current member
        /// account that you want to decline invitations from.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDetector`.
    ///
    /// <p>Deletes an Amazon GuardDuty detector that is specified by the detector ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDetector<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_detector_input::Builder,
    }
    impl<C, M, R> DeleteDetector<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDetector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDetectorOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDetectorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDetectorInputOperationOutputAlias,
                crate::output::DeleteDetectorOutput,
                crate::error::DeleteDetectorError,
                crate::input::DeleteDetectorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the detector that you want to delete.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The unique ID of the detector that you want to delete.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFilter`.
    ///
    /// <p>Deletes the filter specified by the filter name.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteFilter<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_filter_input::Builder,
    }
    impl<C, M, R> DeleteFilter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFilterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFilterInputOperationOutputAlias,
                crate::output::DeleteFilterOutput,
                crate::error::DeleteFilterError,
                crate::input::DeleteFilterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the detector that the filter is associated with.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The unique ID of the detector that the filter is associated with.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The name of the filter that you want to delete.</p>
        pub fn filter_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_name(inp);
            self
        }
        /// <p>The name of the filter that you want to delete.</p>
        pub fn set_filter_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_filter_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteInvitations`.
    ///
    /// <p>Deletes invitations sent to the current member account by AWS accounts specified by their
    /// account IDs.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteInvitations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_invitations_input::Builder,
    }
    impl<C, M, R> DeleteInvitations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteInvitations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInvitationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteInvitationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteInvitationsInputOperationOutputAlias,
                crate::output::DeleteInvitationsOutput,
                crate::error::DeleteInvitationsError,
                crate::input::DeleteInvitationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>A list of account IDs of the AWS accounts that sent invitations to the current member
        /// account that you want to delete invitations from.</p>
        pub fn account_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(inp);
            self
        }
        /// <p>A list of account IDs of the AWS accounts that sent invitations to the current member
        /// account that you want to delete invitations from.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIPSet`.
    ///
    /// <p>Deletes the IPSet specified by the <code>ipSetId</code>. IPSets are called trusted IP
    /// lists in the console user interface.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteIPSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_ip_set_input::Builder,
    }
    impl<C, M, R> DeleteIPSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteIPSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIpSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIPSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteIpSetInputOperationOutputAlias,
                crate::output::DeleteIpSetOutput,
                crate::error::DeleteIPSetError,
                crate::input::DeleteIpSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the detector associated with the IPSet.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The unique ID of the detector associated with the IPSet.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The unique ID of the IPSet to delete.</p>
        pub fn ip_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip_set_id(inp);
            self
        }
        /// <p>The unique ID of the IPSet to delete.</p>
        pub fn set_ip_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ip_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMembers`.
    ///
    /// <p>Deletes GuardDuty member accounts (to the current GuardDuty administrator account) specified by
    /// the account IDs.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteMembers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_members_input::Builder,
    }
    impl<C, M, R> DeleteMembers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMembersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMembersInputOperationOutputAlias,
                crate::output::DeleteMembersOutput,
                crate::error::DeleteMembersError,
                crate::input::DeleteMembersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the detector of the GuardDuty account whose members you want to
        /// delete.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The unique ID of the detector of the GuardDuty account whose members you want to
        /// delete.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>A list of account IDs of the GuardDuty member accounts that you want to delete.</p>
        pub fn account_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(inp);
            self
        }
        /// <p>A list of account IDs of the GuardDuty member accounts that you want to delete.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePublishingDestination`.
    ///
    /// <p>Deletes the publishing definition with the specified <code>destinationId</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeletePublishingDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_publishing_destination_input::Builder,
    }
    impl<C, M, R> DeletePublishingDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePublishingDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePublishingDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePublishingDestinationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePublishingDestinationInputOperationOutputAlias,
                crate::output::DeletePublishingDestinationOutput,
                crate::error::DeletePublishingDestinationError,
                crate::input::DeletePublishingDestinationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the detector associated with the publishing destination to delete.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The unique ID of the detector associated with the publishing destination to delete.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The ID of the publishing destination to delete.</p>
        pub fn destination_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_id(inp);
            self
        }
        /// <p>The ID of the publishing destination to delete.</p>
        pub fn set_destination_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteThreatIntelSet`.
    ///
    /// <p>Deletes the ThreatIntelSet specified by the ThreatIntelSet ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteThreatIntelSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_threat_intel_set_input::Builder,
    }
    impl<C, M, R> DeleteThreatIntelSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteThreatIntelSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteThreatIntelSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteThreatIntelSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteThreatIntelSetInputOperationOutputAlias,
                crate::output::DeleteThreatIntelSetOutput,
                crate::error::DeleteThreatIntelSetError,
                crate::input::DeleteThreatIntelSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the detector that the threatIntelSet is associated with.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The unique ID of the detector that the threatIntelSet is associated with.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The unique ID of the threatIntelSet that you want to delete.</p>
        pub fn threat_intel_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.threat_intel_set_id(inp);
            self
        }
        /// <p>The unique ID of the threatIntelSet that you want to delete.</p>
        pub fn set_threat_intel_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_threat_intel_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOrganizationConfiguration`.
    ///
    /// <p>Returns information about the account selected as the delegated administrator for
    /// GuardDuty.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeOrganizationConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_organization_configuration_input::Builder,
    }
    impl<C, M, R> DescribeOrganizationConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeOrganizationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOrganizationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOrganizationConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeOrganizationConfigurationInputOperationOutputAlias,
                crate::output::DescribeOrganizationConfigurationOutput,
                crate::error::DescribeOrganizationConfigurationError,
                crate::input::DescribeOrganizationConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the detector to retrieve information about the delegated administrator
        /// from.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The ID of the detector to retrieve information about the delegated administrator
        /// from.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePublishingDestination`.
    ///
    /// <p>Returns information about the publishing destination specified by the provided
    /// <code>destinationId</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribePublishingDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_publishing_destination_input::Builder,
    }
    impl<C, M, R> DescribePublishingDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePublishingDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePublishingDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePublishingDestinationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePublishingDestinationInputOperationOutputAlias,
                crate::output::DescribePublishingDestinationOutput,
                crate::error::DescribePublishingDestinationError,
                crate::input::DescribePublishingDestinationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the detector associated with the publishing destination to
        /// retrieve.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The unique ID of the detector associated with the publishing destination to
        /// retrieve.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The ID of the publishing destination to retrieve.</p>
        pub fn destination_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_id(inp);
            self
        }
        /// <p>The ID of the publishing destination to retrieve.</p>
        pub fn set_destination_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableOrganizationAdminAccount`.
    ///
    /// <p>Disables an AWS account within the Organization as the GuardDuty delegated
    /// administrator.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisableOrganizationAdminAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_organization_admin_account_input::Builder,
    }
    impl<C, M, R> DisableOrganizationAdminAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableOrganizationAdminAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableOrganizationAdminAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableOrganizationAdminAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableOrganizationAdminAccountInputOperationOutputAlias,
                crate::output::DisableOrganizationAdminAccountOutput,
                crate::error::DisableOrganizationAdminAccountError,
                crate::input::DisableOrganizationAdminAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS Account ID for the organizations account to be disabled as a GuardDuty delegated
        /// administrator.</p>
        pub fn admin_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.admin_account_id(inp);
            self
        }
        /// <p>The AWS Account ID for the organizations account to be disabled as a GuardDuty delegated
        /// administrator.</p>
        pub fn set_admin_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_admin_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateFromMasterAccount`.
    ///
    /// <p>Disassociates the current GuardDuty member account from its administrator account.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateFromMasterAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_from_master_account_input::Builder,
    }
    impl<C, M, R> DisassociateFromMasterAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateFromMasterAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateFromMasterAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateFromMasterAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateFromMasterAccountInputOperationOutputAlias,
                crate::output::DisassociateFromMasterAccountOutput,
                crate::error::DisassociateFromMasterAccountError,
                crate::input::DisassociateFromMasterAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the detector of the GuardDuty member account.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The unique ID of the detector of the GuardDuty member account.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateMembers`.
    ///
    /// <p>Disassociates GuardDuty member accounts (to the current GuardDuty administrator account)
    /// specified by the account IDs.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateMembers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_members_input::Builder,
    }
    impl<C, M, R> DisassociateMembers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateMembersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateMembersInputOperationOutputAlias,
                crate::output::DisassociateMembersOutput,
                crate::error::DisassociateMembersError,
                crate::input::DisassociateMembersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the detector of the GuardDuty account whose members you want to
        /// disassociate from the administrator account.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The unique ID of the detector of the GuardDuty account whose members you want to
        /// disassociate from the administrator account.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>A list of account IDs of the GuardDuty member accounts that you want to disassociate from
        /// the administrator account.</p>
        pub fn account_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(inp);
            self
        }
        /// <p>A list of account IDs of the GuardDuty member accounts that you want to disassociate from
        /// the administrator account.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableOrganizationAdminAccount`.
    ///
    /// <p>Enables an AWS account within the organization as the GuardDuty delegated
    /// administrator.</p>
    #[derive(std::fmt::Debug)]
    pub struct EnableOrganizationAdminAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_organization_admin_account_input::Builder,
    }
    impl<C, M, R> EnableOrganizationAdminAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableOrganizationAdminAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableOrganizationAdminAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableOrganizationAdminAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableOrganizationAdminAccountInputOperationOutputAlias,
                crate::output::EnableOrganizationAdminAccountOutput,
                crate::error::EnableOrganizationAdminAccountError,
                crate::input::EnableOrganizationAdminAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS Account ID for the organization account to be enabled as a GuardDuty delegated
        /// administrator.</p>
        pub fn admin_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.admin_account_id(inp);
            self
        }
        /// <p>The AWS Account ID for the organization account to be enabled as a GuardDuty delegated
        /// administrator.</p>
        pub fn set_admin_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_admin_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDetector`.
    ///
    /// <p>Retrieves an Amazon GuardDuty detector specified by the detectorId.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDetector<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_detector_input::Builder,
    }
    impl<C, M, R> GetDetector<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDetector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDetectorOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDetectorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDetectorInputOperationOutputAlias,
                crate::output::GetDetectorOutput,
                crate::error::GetDetectorError,
                crate::input::GetDetectorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the detector that you want to get.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The unique ID of the detector that you want to get.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFilter`.
    ///
    /// <p>Returns the details of the filter specified by the filter name.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetFilter<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_filter_input::Builder,
    }
    impl<C, M, R> GetFilter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFilterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFilterInputOperationOutputAlias,
                crate::output::GetFilterOutput,
                crate::error::GetFilterError,
                crate::input::GetFilterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the detector that the filter is associated with.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The unique ID of the detector that the filter is associated with.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The name of the filter you want to get.</p>
        pub fn filter_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_name(inp);
            self
        }
        /// <p>The name of the filter you want to get.</p>
        pub fn set_filter_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_filter_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFindings`.
    ///
    /// <p>Describes Amazon GuardDuty findings specified by finding IDs.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetFindings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_findings_input::Builder,
    }
    impl<C, M, R> GetFindings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFindingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFindingsInputOperationOutputAlias,
                crate::output::GetFindingsOutput,
                crate::error::GetFindingsError,
                crate::input::GetFindingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the detector that specifies the GuardDuty service whose findings you want to
        /// retrieve.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The ID of the detector that specifies the GuardDuty service whose findings you want to
        /// retrieve.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// Appends an item to `FindingIds`.
        ///
        /// To override the contents of this collection use [`set_finding_ids`](Self::set_finding_ids).
        ///
        /// <p>The IDs of the findings that you want to retrieve.</p>
        pub fn finding_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.finding_ids(inp);
            self
        }
        /// <p>The IDs of the findings that you want to retrieve.</p>
        pub fn set_finding_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_finding_ids(input);
            self
        }
        /// <p>Represents the criteria used for sorting findings.</p>
        pub fn sort_criteria(mut self, inp: crate::model::SortCriteria) -> Self {
            self.inner = self.inner.sort_criteria(inp);
            self
        }
        /// <p>Represents the criteria used for sorting findings.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<crate::model::SortCriteria>,
        ) -> Self {
            self.inner = self.inner.set_sort_criteria(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFindingsStatistics`.
    ///
    /// <p>Lists Amazon GuardDuty findings statistics for the specified detector ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetFindingsStatistics<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_findings_statistics_input::Builder,
    }
    impl<C, M, R> GetFindingsStatistics<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFindingsStatistics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFindingsStatisticsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFindingsStatisticsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFindingsStatisticsInputOperationOutputAlias,
                crate::output::GetFindingsStatisticsOutput,
                crate::error::GetFindingsStatisticsError,
                crate::input::GetFindingsStatisticsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the detector that specifies the GuardDuty service whose findings' statistics you
        /// want to retrieve.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The ID of the detector that specifies the GuardDuty service whose findings' statistics you
        /// want to retrieve.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// Appends an item to `FindingStatisticTypes`.
        ///
        /// To override the contents of this collection use [`set_finding_statistic_types`](Self::set_finding_statistic_types).
        ///
        /// <p>The types of finding statistics to retrieve.</p>
        pub fn finding_statistic_types(
            mut self,
            inp: impl Into<crate::model::FindingStatisticType>,
        ) -> Self {
            self.inner = self.inner.finding_statistic_types(inp);
            self
        }
        /// <p>The types of finding statistics to retrieve.</p>
        pub fn set_finding_statistic_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FindingStatisticType>>,
        ) -> Self {
            self.inner = self.inner.set_finding_statistic_types(input);
            self
        }
        /// <p>Represents the criteria that is used for querying findings.</p>
        pub fn finding_criteria(mut self, inp: crate::model::FindingCriteria) -> Self {
            self.inner = self.inner.finding_criteria(inp);
            self
        }
        /// <p>Represents the criteria that is used for querying findings.</p>
        pub fn set_finding_criteria(
            mut self,
            input: std::option::Option<crate::model::FindingCriteria>,
        ) -> Self {
            self.inner = self.inner.set_finding_criteria(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInvitationsCount`.
    ///
    /// <p>Returns the count of all GuardDuty membership invitations that were sent to the current
    /// member account except the currently accepted invitation.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetInvitationsCount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_invitations_count_input::Builder,
    }
    impl<C, M, R> GetInvitationsCount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInvitationsCount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInvitationsCountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInvitationsCountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInvitationsCountInputOperationOutputAlias,
                crate::output::GetInvitationsCountOutput,
                crate::error::GetInvitationsCountError,
                crate::input::GetInvitationsCountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetIPSet`.
    ///
    /// <p>Retrieves the IPSet specified by the <code>ipSetId</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetIPSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_ip_set_input::Builder,
    }
    impl<C, M, R> GetIPSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetIPSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIpSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIPSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetIpSetInputOperationOutputAlias,
                crate::output::GetIpSetOutput,
                crate::error::GetIPSetError,
                crate::input::GetIpSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the detector that the IPSet is associated with.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The unique ID of the detector that the IPSet is associated with.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The unique ID of the IPSet to retrieve.</p>
        pub fn ip_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip_set_id(inp);
            self
        }
        /// <p>The unique ID of the IPSet to retrieve.</p>
        pub fn set_ip_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ip_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMasterAccount`.
    ///
    /// <p>Provides the details for the GuardDuty administrator account associated with the current
    /// GuardDuty member account.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMasterAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_master_account_input::Builder,
    }
    impl<C, M, R> GetMasterAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMasterAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMasterAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMasterAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMasterAccountInputOperationOutputAlias,
                crate::output::GetMasterAccountOutput,
                crate::error::GetMasterAccountError,
                crate::input::GetMasterAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the detector of the GuardDuty member account.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The unique ID of the detector of the GuardDuty member account.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMemberDetectors`.
    ///
    /// <p>Describes which data sources are enabled for the member account's detector.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMemberDetectors<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_member_detectors_input::Builder,
    }
    impl<C, M, R> GetMemberDetectors<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMemberDetectors`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMemberDetectorsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMemberDetectorsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMemberDetectorsInputOperationOutputAlias,
                crate::output::GetMemberDetectorsOutput,
                crate::error::GetMemberDetectorsError,
                crate::input::GetMemberDetectorsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The detector ID for the administrator account.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The detector ID for the administrator account.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>The account ID of the member account.</p>
        pub fn account_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(inp);
            self
        }
        /// <p>The account ID of the member account.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMembers`.
    ///
    /// <p>Retrieves GuardDuty member accounts (of the current GuardDuty administrator account) specified by
    /// the account IDs.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMembers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_members_input::Builder,
    }
    impl<C, M, R> GetMembers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMembersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMembersInputOperationOutputAlias,
                crate::output::GetMembersOutput,
                crate::error::GetMembersError,
                crate::input::GetMembersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the detector of the GuardDuty account whose members you want to
        /// retrieve.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The unique ID of the detector of the GuardDuty account whose members you want to
        /// retrieve.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>A list of account IDs of the GuardDuty member accounts that you want to describe.</p>
        pub fn account_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(inp);
            self
        }
        /// <p>A list of account IDs of the GuardDuty member accounts that you want to describe.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetThreatIntelSet`.
    ///
    /// <p>Retrieves the ThreatIntelSet that is specified by the ThreatIntelSet ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetThreatIntelSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_threat_intel_set_input::Builder,
    }
    impl<C, M, R> GetThreatIntelSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetThreatIntelSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetThreatIntelSetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetThreatIntelSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetThreatIntelSetInputOperationOutputAlias,
                crate::output::GetThreatIntelSetOutput,
                crate::error::GetThreatIntelSetError,
                crate::input::GetThreatIntelSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the detector that the threatIntelSet is associated with.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The unique ID of the detector that the threatIntelSet is associated with.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The unique ID of the threatIntelSet that you want to get.</p>
        pub fn threat_intel_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.threat_intel_set_id(inp);
            self
        }
        /// <p>The unique ID of the threatIntelSet that you want to get.</p>
        pub fn set_threat_intel_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_threat_intel_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUsageStatistics`.
    ///
    /// <p>Lists Amazon GuardDuty usage statistics over the last 30 days for the specified detector
    /// ID. For newly enabled detectors or data sources the cost returned will include only the usage
    /// so far under 30 days, this may differ from the cost metrics in the console, which projects
    /// usage over 30 days to provide a monthly cost estimate. For more information see <a href="https://docs.aws.amazon.com/guardduty/latest/ug/monitoring_costs.html#usage-calculations">Understanding How Usage Costs are Calculated</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetUsageStatistics<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_usage_statistics_input::Builder,
    }
    impl<C, M, R> GetUsageStatistics<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUsageStatistics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUsageStatisticsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUsageStatisticsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUsageStatisticsInputOperationOutputAlias,
                crate::output::GetUsageStatisticsOutput,
                crate::error::GetUsageStatisticsError,
                crate::input::GetUsageStatisticsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the detector that specifies the GuardDuty service whose usage statistics you
        /// want to retrieve.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The ID of the detector that specifies the GuardDuty service whose usage statistics you
        /// want to retrieve.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The type of usage statistics to retrieve.</p>
        pub fn usage_statistic_type(mut self, inp: crate::model::UsageStatisticType) -> Self {
            self.inner = self.inner.usage_statistic_type(inp);
            self
        }
        /// <p>The type of usage statistics to retrieve.</p>
        pub fn set_usage_statistic_type(
            mut self,
            input: std::option::Option<crate::model::UsageStatisticType>,
        ) -> Self {
            self.inner = self.inner.set_usage_statistic_type(input);
            self
        }
        /// <p>Represents the criteria used for querying usage.</p>
        pub fn usage_criteria(mut self, inp: crate::model::UsageCriteria) -> Self {
            self.inner = self.inner.usage_criteria(inp);
            self
        }
        /// <p>Represents the criteria used for querying usage.</p>
        pub fn set_usage_criteria(
            mut self,
            input: std::option::Option<crate::model::UsageCriteria>,
        ) -> Self {
            self.inner = self.inner.set_usage_criteria(input);
            self
        }
        /// <p>The currency unit you would like to view your usage statistics in. Current valid values
        /// are USD.</p>
        pub fn unit(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.unit(inp);
            self
        }
        /// <p>The currency unit you would like to view your usage statistics in. Current valid values
        /// are USD.</p>
        pub fn set_unit(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_unit(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of
        /// this parameter to null for the first request to a list action. For subsequent calls, use the
        /// NextToken value returned from the previous request to continue listing results after the first
        /// page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of
        /// this parameter to null for the first request to a list action. For subsequent calls, use the
        /// NextToken value returned from the previous request to continue listing results after the first
        /// page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `InviteMembers`.
    ///
    /// <p>Invites other AWS accounts (created as members of the current AWS account by
    /// CreateMembers) to enable GuardDuty, and allow the current AWS account to view and manage these
    /// accounts' findings on their behalf as the GuardDuty administrator account.</p>
    #[derive(std::fmt::Debug)]
    pub struct InviteMembers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::invite_members_input::Builder,
    }
    impl<C, M, R> InviteMembers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `InviteMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::InviteMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::InviteMembersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::InviteMembersInputOperationOutputAlias,
                crate::output::InviteMembersOutput,
                crate::error::InviteMembersError,
                crate::input::InviteMembersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the detector of the GuardDuty account that you want to invite members
        /// with.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The unique ID of the detector of the GuardDuty account that you want to invite members
        /// with.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>A list of account IDs of the accounts that you want to invite to GuardDuty as
        /// members.</p>
        pub fn account_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(inp);
            self
        }
        /// <p>A list of account IDs of the accounts that you want to invite to GuardDuty as
        /// members.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
        /// <p>A Boolean value that specifies whether you want to disable email notification to the accounts that you are inviting to GuardDuty as members.</p>
        pub fn disable_email_notification(mut self, inp: bool) -> Self {
            self.inner = self.inner.disable_email_notification(inp);
            self
        }
        /// <p>A Boolean value that specifies whether you want to disable email notification to the accounts that you are inviting to GuardDuty as members.</p>
        pub fn set_disable_email_notification(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_disable_email_notification(input);
            self
        }
        /// <p>The invitation message that you want to send to the accounts that you're inviting to
        /// GuardDuty as members.</p>
        pub fn message(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message(inp);
            self
        }
        /// <p>The invitation message that you want to send to the accounts that you're inviting to
        /// GuardDuty as members.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDetectors`.
    ///
    /// <p>Lists detectorIds of all the existing Amazon GuardDuty detector resources.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDetectors<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_detectors_input::Builder,
    }
    impl<C, M, R> ListDetectors<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDetectors`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDetectorsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDetectorsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDetectorsInputOperationOutputAlias,
                crate::output::ListDetectorsOutput,
                crate::error::ListDetectorsError,
                crate::input::ListDetectorsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>You can use this parameter to indicate the maximum number of items that you want in the
        /// response. The default value is 50. The maximum value is 50.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items that you want in the
        /// response. The default value is 50. The maximum value is 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to
        /// null on your first call to the list action. For subsequent calls to the action, fill nextToken
        /// in the request with the value of NextToken from the previous response to continue listing
        /// data.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to
        /// null on your first call to the list action. For subsequent calls to the action, fill nextToken
        /// in the request with the value of NextToken from the previous response to continue listing
        /// data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFilters`.
    ///
    /// <p>Returns a paginated list of the current filters.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListFilters<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_filters_input::Builder,
    }
    impl<C, M, R> ListFilters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFilters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFiltersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFiltersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFiltersInputOperationOutputAlias,
                crate::output::ListFiltersOutput,
                crate::error::ListFiltersError,
                crate::input::ListFiltersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the detector that the filter is associated with.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The unique ID of the detector that the filter is associated with.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items that you want in the
        /// response. The default value is 50. The maximum value is 50.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items that you want in the
        /// response. The default value is 50. The maximum value is 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to
        /// null on your first call to the list action. For subsequent calls to the action, fill nextToken
        /// in the request with the value of NextToken from the previous response to continue listing
        /// data.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to
        /// null on your first call to the list action. For subsequent calls to the action, fill nextToken
        /// in the request with the value of NextToken from the previous response to continue listing
        /// data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFindings`.
    ///
    /// <p>Lists Amazon GuardDuty findings for the specified detector ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListFindings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_findings_input::Builder,
    }
    impl<C, M, R> ListFindings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFindingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFindingsInputOperationOutputAlias,
                crate::output::ListFindingsOutput,
                crate::error::ListFindingsError,
                crate::input::ListFindingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the detector that specifies the GuardDuty service whose findings you want to
        /// list.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The ID of the detector that specifies the GuardDuty service whose findings you want to
        /// list.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>Represents the criteria used for querying findings. Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>JSON field name</p>
        /// </li>
        /// <li>
        /// <p>accountId</p>
        /// </li>
        /// <li>
        /// <p>region</p>
        /// </li>
        /// <li>
        /// <p>confidence</p>
        /// </li>
        /// <li>
        /// <p>id</p>
        /// </li>
        /// <li>
        /// <p>resource.accessKeyDetails.accessKeyId</p>
        /// </li>
        /// <li>
        /// <p>resource.accessKeyDetails.principalId</p>
        /// </li>
        /// <li>
        /// <p>resource.accessKeyDetails.userName</p>
        /// </li>
        /// <li>
        /// <p>resource.accessKeyDetails.userType</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.iamInstanceProfile.id</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.imageId</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.instanceId</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.ipv6Addresses</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.publicDnsName</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.publicIp</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.securityGroups.groupId</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.securityGroups.groupName</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.subnetId</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.vpcId</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.tags.key</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.tags.value</p>
        /// </li>
        /// <li>
        /// <p>resource.resourceType</p>
        /// </li>
        /// <li>
        /// <p>service.action.actionType</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.api</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.callerType</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.remoteIpDetails.city.cityName</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.remoteIpDetails.country.countryName</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.remoteIpDetails.ipAddressV4</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.remoteIpDetails.organization.asn</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.serviceName</p>
        /// </li>
        /// <li>
        /// <p>service.action.dnsRequestAction.domain</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.blocked</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.connectionDirection</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.localPortDetails.port</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.protocol</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.remoteIpDetails.city.cityName</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.remoteIpDetails.country.countryName</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.remoteIpDetails.ipAddressV4</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.remoteIpDetails.organization.asn</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.remotePortDetails.port</p>
        /// </li>
        /// <li>
        /// <p>service.additionalInfo.threatListName</p>
        /// </li>
        /// <li>
        /// <p>service.archived</p>
        /// <p>When this attribute is set to 'true', only archived findings are listed. When it's set
        /// to 'false', only unarchived findings are listed. When this attribute is not set, all
        /// existing findings are listed.</p>
        /// </li>
        /// <li>
        /// <p>service.resourceRole</p>
        /// </li>
        /// <li>
        /// <p>severity</p>
        /// </li>
        /// <li>
        /// <p>type</p>
        /// </li>
        /// <li>
        /// <p>updatedAt</p>
        /// <p>Type: Timestamp in Unix Epoch millisecond format: 1486685375000</p>
        /// </li>
        /// </ul>
        pub fn finding_criteria(mut self, inp: crate::model::FindingCriteria) -> Self {
            self.inner = self.inner.finding_criteria(inp);
            self
        }
        /// <p>Represents the criteria used for querying findings. Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>JSON field name</p>
        /// </li>
        /// <li>
        /// <p>accountId</p>
        /// </li>
        /// <li>
        /// <p>region</p>
        /// </li>
        /// <li>
        /// <p>confidence</p>
        /// </li>
        /// <li>
        /// <p>id</p>
        /// </li>
        /// <li>
        /// <p>resource.accessKeyDetails.accessKeyId</p>
        /// </li>
        /// <li>
        /// <p>resource.accessKeyDetails.principalId</p>
        /// </li>
        /// <li>
        /// <p>resource.accessKeyDetails.userName</p>
        /// </li>
        /// <li>
        /// <p>resource.accessKeyDetails.userType</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.iamInstanceProfile.id</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.imageId</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.instanceId</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.ipv6Addresses</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.publicDnsName</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.publicIp</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.securityGroups.groupId</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.securityGroups.groupName</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.subnetId</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.networkInterfaces.vpcId</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.tags.key</p>
        /// </li>
        /// <li>
        /// <p>resource.instanceDetails.tags.value</p>
        /// </li>
        /// <li>
        /// <p>resource.resourceType</p>
        /// </li>
        /// <li>
        /// <p>service.action.actionType</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.api</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.callerType</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.remoteIpDetails.city.cityName</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.remoteIpDetails.country.countryName</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.remoteIpDetails.ipAddressV4</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.remoteIpDetails.organization.asn</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg</p>
        /// </li>
        /// <li>
        /// <p>service.action.awsApiCallAction.serviceName</p>
        /// </li>
        /// <li>
        /// <p>service.action.dnsRequestAction.domain</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.blocked</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.connectionDirection</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.localPortDetails.port</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.protocol</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.remoteIpDetails.city.cityName</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.remoteIpDetails.country.countryName</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.remoteIpDetails.ipAddressV4</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.remoteIpDetails.organization.asn</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg</p>
        /// </li>
        /// <li>
        /// <p>service.action.networkConnectionAction.remotePortDetails.port</p>
        /// </li>
        /// <li>
        /// <p>service.additionalInfo.threatListName</p>
        /// </li>
        /// <li>
        /// <p>service.archived</p>
        /// <p>When this attribute is set to 'true', only archived findings are listed. When it's set
        /// to 'false', only unarchived findings are listed. When this attribute is not set, all
        /// existing findings are listed.</p>
        /// </li>
        /// <li>
        /// <p>service.resourceRole</p>
        /// </li>
        /// <li>
        /// <p>severity</p>
        /// </li>
        /// <li>
        /// <p>type</p>
        /// </li>
        /// <li>
        /// <p>updatedAt</p>
        /// <p>Type: Timestamp in Unix Epoch millisecond format: 1486685375000</p>
        /// </li>
        /// </ul>
        pub fn set_finding_criteria(
            mut self,
            input: std::option::Option<crate::model::FindingCriteria>,
        ) -> Self {
            self.inner = self.inner.set_finding_criteria(input);
            self
        }
        /// <p>Represents the criteria used for sorting findings.</p>
        pub fn sort_criteria(mut self, inp: crate::model::SortCriteria) -> Self {
            self.inner = self.inner.sort_criteria(inp);
            self
        }
        /// <p>Represents the criteria used for sorting findings.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<crate::model::SortCriteria>,
        ) -> Self {
            self.inner = self.inner.set_sort_criteria(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 50. The maximum value is 50.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 50. The maximum value is 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to
        /// null on your first call to the list action. For subsequent calls to the action, fill nextToken
        /// in the request with the value of NextToken from the previous response to continue listing
        /// data.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to
        /// null on your first call to the list action. For subsequent calls to the action, fill nextToken
        /// in the request with the value of NextToken from the previous response to continue listing
        /// data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInvitations`.
    ///
    /// <p>Lists all GuardDuty membership invitations that were sent to the current AWS
    /// account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListInvitations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_invitations_input::Builder,
    }
    impl<C, M, R> ListInvitations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListInvitations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInvitationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInvitationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListInvitationsInputOperationOutputAlias,
                crate::output::ListInvitationsOutput,
                crate::error::ListInvitationsError,
                crate::input::ListInvitationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>You can use this parameter to indicate the maximum number of items that you want in the
        /// response. The default value is 50. The maximum value is 50.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items that you want in the
        /// response. The default value is 50. The maximum value is 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to
        /// null on your first call to the list action. For subsequent calls to the action, fill nextToken
        /// in the request with the value of NextToken from the previous response to continue listing
        /// data.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to
        /// null on your first call to the list action. For subsequent calls to the action, fill nextToken
        /// in the request with the value of NextToken from the previous response to continue listing
        /// data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIPSets`.
    ///
    /// <p>Lists the IPSets of the GuardDuty service specified by the detector ID. If you use this
    /// operation from a member account, the IPSets returned are the IPSets from the associated administrator
    /// account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListIPSets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_ip_sets_input::Builder,
    }
    impl<C, M, R> ListIPSets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListIPSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIpSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIPSetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListIpSetsInputOperationOutputAlias,
                crate::output::ListIpSetsOutput,
                crate::error::ListIPSetsError,
                crate::input::ListIpSetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the detector that the IPSet is associated with.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The unique ID of the detector that the IPSet is associated with.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 50. The maximum value is 50.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 50. The maximum value is 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to
        /// null on your first call to the list action. For subsequent calls to the action, fill nextToken
        /// in the request with the value of NextToken from the previous response to continue listing
        /// data.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to
        /// null on your first call to the list action. For subsequent calls to the action, fill nextToken
        /// in the request with the value of NextToken from the previous response to continue listing
        /// data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMembers`.
    ///
    /// <p>Lists details about all member accounts for the current GuardDuty administrator account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListMembers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_members_input::Builder,
    }
    impl<C, M, R> ListMembers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMembersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMembersInputOperationOutputAlias,
                crate::output::ListMembersOutput,
                crate::error::ListMembersError,
                crate::input::ListMembersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the detector the member is associated with.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The unique ID of the detector the member is associated with.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 50. The maximum value is 50.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items you want in the
        /// response. The default value is 50. The maximum value is 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to
        /// null on your first call to the list action. For subsequent calls to the action, fill nextToken
        /// in the request with the value of NextToken from the previous response to continue listing
        /// data.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>You can use this parameter when paginating results. Set the value of this parameter to
        /// null on your first call to the list action. For subsequent calls to the action, fill nextToken
        /// in the request with the value of NextToken from the previous response to continue listing
        /// data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifies whether to only return associated members or to return all members (including
        /// members who haven't been invited yet or have been disassociated).</p>
        pub fn only_associated(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.only_associated(inp);
            self
        }
        /// <p>Specifies whether to only return associated members or to return all members (including
        /// members who haven't been invited yet or have been disassociated).</p>
        pub fn set_only_associated(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_only_associated(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOrganizationAdminAccounts`.
    ///
    /// <p>Lists the accounts configured as GuardDuty delegated administrators.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListOrganizationAdminAccounts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_organization_admin_accounts_input::Builder,
    }
    impl<C, M, R> ListOrganizationAdminAccounts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListOrganizationAdminAccounts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOrganizationAdminAccountsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOrganizationAdminAccountsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListOrganizationAdminAccountsInputOperationOutputAlias,
                crate::output::ListOrganizationAdminAccountsOutput,
                crate::error::ListOrganizationAdminAccountsError,
                crate::input::ListOrganizationAdminAccountsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of
        /// this parameter to null for the first request to a list action. For subsequent calls, use the
        /// <code>NextToken</code> value returned from the previous request to continue listing results
        /// after the first page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of
        /// this parameter to null for the first request to a list action. For subsequent calls, use the
        /// <code>NextToken</code> value returned from the previous request to continue listing results
        /// after the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPublishingDestinations`.
    ///
    /// <p>Returns a list of publishing destinations associated with the specified
    /// <code>dectectorId</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPublishingDestinations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_publishing_destinations_input::Builder,
    }
    impl<C, M, R> ListPublishingDestinations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPublishingDestinations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPublishingDestinationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPublishingDestinationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPublishingDestinationsInputOperationOutputAlias,
                crate::output::ListPublishingDestinationsOutput,
                crate::error::ListPublishingDestinationsError,
                crate::input::ListPublishingDestinationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the detector to retrieve publishing destinations for.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The ID of the detector to retrieve publishing destinations for.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of
        /// this parameter to null for the first request to a list action. For subsequent calls, use the
        /// <code>NextToken</code> value returned from the previous request to continue listing results
        /// after the first page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token to use for paginating results that are returned in the response. Set the value of
        /// this parameter to null for the first request to a list action. For subsequent calls, use the
        /// <code>NextToken</code> value returned from the previous request to continue listing results
        /// after the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists tags for a resource. Tagging is currently supported for detectors, finding filters,
    /// IP sets, and threat intel sets, with a limit of 50 tags per resource. When invoked, this
    /// operation returns all assigned tags for a given resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the given GuardDuty resource. </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the given GuardDuty resource. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListThreatIntelSets`.
    ///
    /// <p>Lists the ThreatIntelSets of the GuardDuty service specified by the detector ID. If you
    /// use this operation from a member account, the ThreatIntelSets associated with the administrator
    /// account are returned.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListThreatIntelSets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_threat_intel_sets_input::Builder,
    }
    impl<C, M, R> ListThreatIntelSets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListThreatIntelSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListThreatIntelSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListThreatIntelSetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListThreatIntelSetsInputOperationOutputAlias,
                crate::output::ListThreatIntelSetsOutput,
                crate::error::ListThreatIntelSetsError,
                crate::input::ListThreatIntelSetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the detector that the threatIntelSet is associated with.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The unique ID of the detector that the threatIntelSet is associated with.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items that you want in the
        /// response. The default value is 50. The maximum value is 50.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>You can use this parameter to indicate the maximum number of items that you want in the
        /// response. The default value is 50. The maximum value is 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>You can use this parameter to paginate results in the response. Set the value of this
        /// parameter to null on your first call to the list action. For subsequent calls to the action,
        /// fill nextToken in the request with the value of NextToken from the previous response to
        /// continue listing data.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>You can use this parameter to paginate results in the response. Set the value of this
        /// parameter to null on your first call to the list action. For subsequent calls to the action,
        /// fill nextToken in the request with the value of NextToken from the previous response to
        /// continue listing data.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartMonitoringMembers`.
    ///
    /// <p>Turns on GuardDuty monitoring of the specified member accounts. Use this operation to
    /// restart monitoring of accounts that you stopped monitoring with the
    /// <code>StopMonitoringMembers</code> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartMonitoringMembers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_monitoring_members_input::Builder,
    }
    impl<C, M, R> StartMonitoringMembers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartMonitoringMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartMonitoringMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::StartMonitoringMembersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartMonitoringMembersInputOperationOutputAlias,
                crate::output::StartMonitoringMembersOutput,
                crate::error::StartMonitoringMembersError,
                crate::input::StartMonitoringMembersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the detector of the GuardDuty administrator account associated with the member
        /// accounts to monitor.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The unique ID of the detector of the GuardDuty administrator account associated with the member
        /// accounts to monitor.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>A list of account IDs of the GuardDuty member accounts to start monitoring.</p>
        pub fn account_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(inp);
            self
        }
        /// <p>A list of account IDs of the GuardDuty member accounts to start monitoring.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopMonitoringMembers`.
    ///
    /// <p>Stops GuardDuty monitoring for the specified member accounts. Use the
    /// <code>StartMonitoringMembers</code> operation to restart monitoring for those
    /// accounts.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopMonitoringMembers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_monitoring_members_input::Builder,
    }
    impl<C, M, R> StopMonitoringMembers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopMonitoringMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopMonitoringMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::StopMonitoringMembersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopMonitoringMembersInputOperationOutputAlias,
                crate::output::StopMonitoringMembersOutput,
                crate::error::StopMonitoringMembersError,
                crate::input::StopMonitoringMembersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the detector associated with the GuardDuty administrator account that is
        /// monitoring member accounts.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The unique ID of the detector associated with the GuardDuty administrator account that is
        /// monitoring member accounts.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>A list of account IDs for the member accounts to stop monitoring.</p>
        pub fn account_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(inp);
            self
        }
        /// <p>A list of account IDs for the member accounts to stop monitoring.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds tags to a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the GuardDuty resource to apply a tag to.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the GuardDuty resource to apply a tag to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be added to a resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags to be added to a resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UnarchiveFindings`.
    ///
    /// <p>Unarchives GuardDuty findings specified by the <code>findingIds</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UnarchiveFindings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::unarchive_findings_input::Builder,
    }
    impl<C, M, R> UnarchiveFindings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UnarchiveFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UnarchiveFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UnarchiveFindingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UnarchiveFindingsInputOperationOutputAlias,
                crate::output::UnarchiveFindingsOutput,
                crate::error::UnarchiveFindingsError,
                crate::input::UnarchiveFindingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the detector associated with the findings to unarchive.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The ID of the detector associated with the findings to unarchive.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// Appends an item to `FindingIds`.
        ///
        /// To override the contents of this collection use [`set_finding_ids`](Self::set_finding_ids).
        ///
        /// <p>The IDs of the findings to unarchive.</p>
        pub fn finding_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.finding_ids(inp);
            self
        }
        /// <p>The IDs of the findings to unarchive.</p>
        pub fn set_finding_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_finding_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for the resource to remove tags from.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the resource to remove tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys to remove from the resource.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The tag keys to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDetector`.
    ///
    /// <p>Updates the Amazon GuardDuty detector specified by the detectorId.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDetector<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_detector_input::Builder,
    }
    impl<C, M, R> UpdateDetector<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDetector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDetectorOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDetectorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDetectorInputOperationOutputAlias,
                crate::output::UpdateDetectorOutput,
                crate::error::UpdateDetectorError,
                crate::input::UpdateDetectorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the detector to update.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The unique ID of the detector to update.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>Specifies whether the detector is enabled or not enabled.</p>
        pub fn enable(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable(inp);
            self
        }
        /// <p>Specifies whether the detector is enabled or not enabled.</p>
        pub fn set_enable(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable(input);
            self
        }
        /// <p>An enum value that specifies how frequently findings are exported, such as to CloudWatch
        /// Events.</p>
        pub fn finding_publishing_frequency(
            mut self,
            inp: crate::model::FindingPublishingFrequency,
        ) -> Self {
            self.inner = self.inner.finding_publishing_frequency(inp);
            self
        }
        /// <p>An enum value that specifies how frequently findings are exported, such as to CloudWatch
        /// Events.</p>
        pub fn set_finding_publishing_frequency(
            mut self,
            input: std::option::Option<crate::model::FindingPublishingFrequency>,
        ) -> Self {
            self.inner = self.inner.set_finding_publishing_frequency(input);
            self
        }
        /// <p>Describes which data sources will be updated.</p>
        pub fn data_sources(mut self, inp: crate::model::DataSourceConfigurations) -> Self {
            self.inner = self.inner.data_sources(inp);
            self
        }
        /// <p>Describes which data sources will be updated.</p>
        pub fn set_data_sources(
            mut self,
            input: std::option::Option<crate::model::DataSourceConfigurations>,
        ) -> Self {
            self.inner = self.inner.set_data_sources(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFilter`.
    ///
    /// <p>Updates the filter specified by the filter name.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateFilter<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_filter_input::Builder,
    }
    impl<C, M, R> UpdateFilter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFilterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFilterInputOperationOutputAlias,
                crate::output::UpdateFilterOutput,
                crate::error::UpdateFilterError,
                crate::input::UpdateFilterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the detector that specifies the GuardDuty service where you want to
        /// update a filter.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The unique ID of the detector that specifies the GuardDuty service where you want to
        /// update a filter.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The name of the filter.</p>
        pub fn filter_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_name(inp);
            self
        }
        /// <p>The name of the filter.</p>
        pub fn set_filter_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_filter_name(input);
            self
        }
        /// <p>The description of the filter.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the filter.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Specifies the action that is to be applied to the findings that match the filter.</p>
        pub fn action(mut self, inp: crate::model::FilterAction) -> Self {
            self.inner = self.inner.action(inp);
            self
        }
        /// <p>Specifies the action that is to be applied to the findings that match the filter.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::FilterAction>,
        ) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>Specifies the position of the filter in the list of current filters. Also specifies the
        /// order in which this filter is applied to the findings.</p>
        pub fn rank(mut self, inp: i32) -> Self {
            self.inner = self.inner.rank(inp);
            self
        }
        /// <p>Specifies the position of the filter in the list of current filters. Also specifies the
        /// order in which this filter is applied to the findings.</p>
        pub fn set_rank(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_rank(input);
            self
        }
        /// <p>Represents the criteria to be used in the filter for querying findings.</p>
        pub fn finding_criteria(mut self, inp: crate::model::FindingCriteria) -> Self {
            self.inner = self.inner.finding_criteria(inp);
            self
        }
        /// <p>Represents the criteria to be used in the filter for querying findings.</p>
        pub fn set_finding_criteria(
            mut self,
            input: std::option::Option<crate::model::FindingCriteria>,
        ) -> Self {
            self.inner = self.inner.set_finding_criteria(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFindingsFeedback`.
    ///
    /// <p>Marks the specified GuardDuty findings as useful or not useful.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateFindingsFeedback<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_findings_feedback_input::Builder,
    }
    impl<C, M, R> UpdateFindingsFeedback<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFindingsFeedback`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFindingsFeedbackOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFindingsFeedbackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFindingsFeedbackInputOperationOutputAlias,
                crate::output::UpdateFindingsFeedbackOutput,
                crate::error::UpdateFindingsFeedbackError,
                crate::input::UpdateFindingsFeedbackInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the detector associated with the findings to update feedback for.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The ID of the detector associated with the findings to update feedback for.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// Appends an item to `FindingIds`.
        ///
        /// To override the contents of this collection use [`set_finding_ids`](Self::set_finding_ids).
        ///
        /// <p>The IDs of the findings that you want to mark as useful or not useful.</p>
        pub fn finding_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.finding_ids(inp);
            self
        }
        /// <p>The IDs of the findings that you want to mark as useful or not useful.</p>
        pub fn set_finding_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_finding_ids(input);
            self
        }
        /// <p>The feedback for the finding.</p>
        pub fn feedback(mut self, inp: crate::model::Feedback) -> Self {
            self.inner = self.inner.feedback(inp);
            self
        }
        /// <p>The feedback for the finding.</p>
        pub fn set_feedback(mut self, input: std::option::Option<crate::model::Feedback>) -> Self {
            self.inner = self.inner.set_feedback(input);
            self
        }
        /// <p>Additional feedback about the GuardDuty findings.</p>
        pub fn comments(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comments(inp);
            self
        }
        /// <p>Additional feedback about the GuardDuty findings.</p>
        pub fn set_comments(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comments(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateIPSet`.
    ///
    /// <p>Updates the IPSet specified by the IPSet ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateIPSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_ip_set_input::Builder,
    }
    impl<C, M, R> UpdateIPSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateIPSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateIpSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateIPSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateIpSetInputOperationOutputAlias,
                crate::output::UpdateIpSetOutput,
                crate::error::UpdateIPSetError,
                crate::input::UpdateIpSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The detectorID that specifies the GuardDuty service whose IPSet you want to update.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The detectorID that specifies the GuardDuty service whose IPSet you want to update.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The unique ID that specifies the IPSet that you want to update.</p>
        pub fn ip_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ip_set_id(inp);
            self
        }
        /// <p>The unique ID that specifies the IPSet that you want to update.</p>
        pub fn set_ip_set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ip_set_id(input);
            self
        }
        /// <p>The unique ID that specifies the IPSet that you want to update.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The unique ID that specifies the IPSet that you want to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The updated URI of the file that contains the IPSet. For example:
        /// https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key.</p>
        pub fn location(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location(inp);
            self
        }
        /// <p>The updated URI of the file that contains the IPSet. For example:
        /// https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location(input);
            self
        }
        /// <p>The updated Boolean value that specifies whether the IPSet is active or not.</p>
        pub fn activate(mut self, inp: bool) -> Self {
            self.inner = self.inner.activate(inp);
            self
        }
        /// <p>The updated Boolean value that specifies whether the IPSet is active or not.</p>
        pub fn set_activate(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_activate(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMemberDetectors`.
    ///
    /// <p>Contains information on member accounts to be updated.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateMemberDetectors<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_member_detectors_input::Builder,
    }
    impl<C, M, R> UpdateMemberDetectors<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateMemberDetectors`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMemberDetectorsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMemberDetectorsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateMemberDetectorsInputOperationOutputAlias,
                crate::output::UpdateMemberDetectorsOutput,
                crate::error::UpdateMemberDetectorsError,
                crate::input::UpdateMemberDetectorsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The detector ID of the administrator account.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The detector ID of the administrator account.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// Appends an item to `AccountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>A list of member account IDs to be updated.</p>
        pub fn account_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(inp);
            self
        }
        /// <p>A list of member account IDs to be updated.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
        /// <p>Describes which data sources will be updated.</p>
        pub fn data_sources(mut self, inp: crate::model::DataSourceConfigurations) -> Self {
            self.inner = self.inner.data_sources(inp);
            self
        }
        /// <p>Describes which data sources will be updated.</p>
        pub fn set_data_sources(
            mut self,
            input: std::option::Option<crate::model::DataSourceConfigurations>,
        ) -> Self {
            self.inner = self.inner.set_data_sources(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateOrganizationConfiguration`.
    ///
    /// <p>Updates the delegated administrator account with the values provided.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateOrganizationConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_organization_configuration_input::Builder,
    }
    impl<C, M, R> UpdateOrganizationConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateOrganizationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateOrganizationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateOrganizationConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateOrganizationConfigurationInputOperationOutputAlias,
                crate::output::UpdateOrganizationConfigurationOutput,
                crate::error::UpdateOrganizationConfigurationError,
                crate::input::UpdateOrganizationConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the detector to update the delegated administrator for.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The ID of the detector to update the delegated administrator for.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>Indicates whether to automatically enable member accounts in the organization.</p>
        pub fn auto_enable(mut self, inp: bool) -> Self {
            self.inner = self.inner.auto_enable(inp);
            self
        }
        /// <p>Indicates whether to automatically enable member accounts in the organization.</p>
        pub fn set_auto_enable(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_enable(input);
            self
        }
        /// <p>Describes which data sources will be updated.</p>
        pub fn data_sources(
            mut self,
            inp: crate::model::OrganizationDataSourceConfigurations,
        ) -> Self {
            self.inner = self.inner.data_sources(inp);
            self
        }
        /// <p>Describes which data sources will be updated.</p>
        pub fn set_data_sources(
            mut self,
            input: std::option::Option<crate::model::OrganizationDataSourceConfigurations>,
        ) -> Self {
            self.inner = self.inner.set_data_sources(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePublishingDestination`.
    ///
    /// <p>Updates information about the publishing destination specified by the
    /// <code>destinationId</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdatePublishingDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_publishing_destination_input::Builder,
    }
    impl<C, M, R> UpdatePublishingDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePublishingDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePublishingDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePublishingDestinationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePublishingDestinationInputOperationOutputAlias,
                crate::output::UpdatePublishingDestinationOutput,
                crate::error::UpdatePublishingDestinationError,
                crate::input::UpdatePublishingDestinationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the detector associated with the publishing destinations to update.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The ID of the detector associated with the publishing destinations to update.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The ID of the publishing destination to update.</p>
        pub fn destination_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_id(inp);
            self
        }
        /// <p>The ID of the publishing destination to update.</p>
        pub fn set_destination_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_id(input);
            self
        }
        /// <p>A <code>DestinationProperties</code> object that includes the <code>DestinationArn</code>
        /// and <code>KmsKeyArn</code> of the publishing destination.</p>
        pub fn destination_properties(mut self, inp: crate::model::DestinationProperties) -> Self {
            self.inner = self.inner.destination_properties(inp);
            self
        }
        /// <p>A <code>DestinationProperties</code> object that includes the <code>DestinationArn</code>
        /// and <code>KmsKeyArn</code> of the publishing destination.</p>
        pub fn set_destination_properties(
            mut self,
            input: std::option::Option<crate::model::DestinationProperties>,
        ) -> Self {
            self.inner = self.inner.set_destination_properties(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateThreatIntelSet`.
    ///
    /// <p>Updates the ThreatIntelSet specified by the ThreatIntelSet ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateThreatIntelSet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_threat_intel_set_input::Builder,
    }
    impl<C, M, R> UpdateThreatIntelSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateThreatIntelSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateThreatIntelSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateThreatIntelSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateThreatIntelSetInputOperationOutputAlias,
                crate::output::UpdateThreatIntelSetOutput,
                crate::error::UpdateThreatIntelSetError,
                crate::input::UpdateThreatIntelSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The detectorID that specifies the GuardDuty service whose ThreatIntelSet you want to
        /// update.</p>
        pub fn detector_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.detector_id(inp);
            self
        }
        /// <p>The detectorID that specifies the GuardDuty service whose ThreatIntelSet you want to
        /// update.</p>
        pub fn set_detector_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_detector_id(input);
            self
        }
        /// <p>The unique ID that specifies the ThreatIntelSet that you want to update.</p>
        pub fn threat_intel_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.threat_intel_set_id(inp);
            self
        }
        /// <p>The unique ID that specifies the ThreatIntelSet that you want to update.</p>
        pub fn set_threat_intel_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_threat_intel_set_id(input);
            self
        }
        /// <p>The unique ID that specifies the ThreatIntelSet that you want to update.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The unique ID that specifies the ThreatIntelSet that you want to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The updated URI of the file that contains the ThreateIntelSet.</p>
        pub fn location(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.location(inp);
            self
        }
        /// <p>The updated URI of the file that contains the ThreateIntelSet.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_location(input);
            self
        }
        /// <p>The updated Boolean value that specifies whether the ThreateIntelSet is active or
        /// not.</p>
        pub fn activate(mut self, inp: bool) -> Self {
            self.inner = self.inner.activate(inp);
            self
        }
        /// <p>The updated Boolean value that specifies whether the ThreateIntelSet is active or
        /// not.</p>
        pub fn set_activate(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_activate(input);
            self
        }
    }
}
impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
