// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AcceptInvitation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`accept_invitation`](crate::client::Client::accept_invitation).
///
/// See [`crate::client::fluent_builders::AcceptInvitation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AcceptInvitation {
    _private: (),
}
impl AcceptInvitation {
    /// Creates a new builder-style object to manufacture [`AcceptInvitationInput`](crate::input::AcceptInvitationInput)
    pub fn builder() -> crate::input::accept_invitation_input::Builder {
        crate::input::accept_invitation_input::Builder::default()
    }
    /// Creates a new `AcceptInvitation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AcceptInvitation {
    type Output = std::result::Result<
        crate::output::AcceptInvitationOutput,
        crate::error::AcceptInvitationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_accept_invitation_error(response)
        } else {
            crate::operation_deser::parse_accept_invitation_response(response)
        }
    }
}

/// Operation shape for `ArchiveFindings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`archive_findings`](crate::client::Client::archive_findings).
///
/// See [`crate::client::fluent_builders::ArchiveFindings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ArchiveFindings {
    _private: (),
}
impl ArchiveFindings {
    /// Creates a new builder-style object to manufacture [`ArchiveFindingsInput`](crate::input::ArchiveFindingsInput)
    pub fn builder() -> crate::input::archive_findings_input::Builder {
        crate::input::archive_findings_input::Builder::default()
    }
    /// Creates a new `ArchiveFindings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ArchiveFindings {
    type Output = std::result::Result<
        crate::output::ArchiveFindingsOutput,
        crate::error::ArchiveFindingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_archive_findings_error(response)
        } else {
            crate::operation_deser::parse_archive_findings_response(response)
        }
    }
}

/// Operation shape for `CreateDetector`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_detector`](crate::client::Client::create_detector).
///
/// See [`crate::client::fluent_builders::CreateDetector`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDetector {
    _private: (),
}
impl CreateDetector {
    /// Creates a new builder-style object to manufacture [`CreateDetectorInput`](crate::input::CreateDetectorInput)
    pub fn builder() -> crate::input::create_detector_input::Builder {
        crate::input::create_detector_input::Builder::default()
    }
    /// Creates a new `CreateDetector` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDetector {
    type Output =
        std::result::Result<crate::output::CreateDetectorOutput, crate::error::CreateDetectorError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_detector_error(response)
        } else {
            crate::operation_deser::parse_create_detector_response(response)
        }
    }
}

/// Operation shape for `CreateFilter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_filter`](crate::client::Client::create_filter).
///
/// See [`crate::client::fluent_builders::CreateFilter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFilter {
    _private: (),
}
impl CreateFilter {
    /// Creates a new builder-style object to manufacture [`CreateFilterInput`](crate::input::CreateFilterInput)
    pub fn builder() -> crate::input::create_filter_input::Builder {
        crate::input::create_filter_input::Builder::default()
    }
    /// Creates a new `CreateFilter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFilter {
    type Output =
        std::result::Result<crate::output::CreateFilterOutput, crate::error::CreateFilterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_filter_error(response)
        } else {
            crate::operation_deser::parse_create_filter_response(response)
        }
    }
}

/// Operation shape for `CreateIPSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_ip_set`](crate::client::Client::create_ip_set).
///
/// See [`crate::client::fluent_builders::CreateIPSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateIPSet {
    _private: (),
}
impl CreateIPSet {
    /// Creates a new builder-style object to manufacture [`CreateIpSetInput`](crate::input::CreateIpSetInput)
    pub fn builder() -> crate::input::create_ip_set_input::Builder {
        crate::input::create_ip_set_input::Builder::default()
    }
    /// Creates a new `CreateIPSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateIPSet {
    type Output =
        std::result::Result<crate::output::CreateIpSetOutput, crate::error::CreateIPSetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_ip_set_error(response)
        } else {
            crate::operation_deser::parse_create_ip_set_response(response)
        }
    }
}

/// Operation shape for `CreateMembers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_members`](crate::client::Client::create_members).
///
/// See [`crate::client::fluent_builders::CreateMembers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateMembers {
    _private: (),
}
impl CreateMembers {
    /// Creates a new builder-style object to manufacture [`CreateMembersInput`](crate::input::CreateMembersInput)
    pub fn builder() -> crate::input::create_members_input::Builder {
        crate::input::create_members_input::Builder::default()
    }
    /// Creates a new `CreateMembers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateMembers {
    type Output =
        std::result::Result<crate::output::CreateMembersOutput, crate::error::CreateMembersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_members_error(response)
        } else {
            crate::operation_deser::parse_create_members_response(response)
        }
    }
}

/// Operation shape for `CreatePublishingDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_publishing_destination`](crate::client::Client::create_publishing_destination).
///
/// See [`crate::client::fluent_builders::CreatePublishingDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePublishingDestination {
    _private: (),
}
impl CreatePublishingDestination {
    /// Creates a new builder-style object to manufacture [`CreatePublishingDestinationInput`](crate::input::CreatePublishingDestinationInput)
    pub fn builder() -> crate::input::create_publishing_destination_input::Builder {
        crate::input::create_publishing_destination_input::Builder::default()
    }
    /// Creates a new `CreatePublishingDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePublishingDestination {
    type Output = std::result::Result<
        crate::output::CreatePublishingDestinationOutput,
        crate::error::CreatePublishingDestinationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_publishing_destination_error(response)
        } else {
            crate::operation_deser::parse_create_publishing_destination_response(response)
        }
    }
}

/// Operation shape for `CreateSampleFindings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_sample_findings`](crate::client::Client::create_sample_findings).
///
/// See [`crate::client::fluent_builders::CreateSampleFindings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSampleFindings {
    _private: (),
}
impl CreateSampleFindings {
    /// Creates a new builder-style object to manufacture [`CreateSampleFindingsInput`](crate::input::CreateSampleFindingsInput)
    pub fn builder() -> crate::input::create_sample_findings_input::Builder {
        crate::input::create_sample_findings_input::Builder::default()
    }
    /// Creates a new `CreateSampleFindings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSampleFindings {
    type Output = std::result::Result<
        crate::output::CreateSampleFindingsOutput,
        crate::error::CreateSampleFindingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_sample_findings_error(response)
        } else {
            crate::operation_deser::parse_create_sample_findings_response(response)
        }
    }
}

/// Operation shape for `CreateThreatIntelSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_threat_intel_set`](crate::client::Client::create_threat_intel_set).
///
/// See [`crate::client::fluent_builders::CreateThreatIntelSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateThreatIntelSet {
    _private: (),
}
impl CreateThreatIntelSet {
    /// Creates a new builder-style object to manufacture [`CreateThreatIntelSetInput`](crate::input::CreateThreatIntelSetInput)
    pub fn builder() -> crate::input::create_threat_intel_set_input::Builder {
        crate::input::create_threat_intel_set_input::Builder::default()
    }
    /// Creates a new `CreateThreatIntelSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateThreatIntelSet {
    type Output = std::result::Result<
        crate::output::CreateThreatIntelSetOutput,
        crate::error::CreateThreatIntelSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_threat_intel_set_error(response)
        } else {
            crate::operation_deser::parse_create_threat_intel_set_response(response)
        }
    }
}

/// Operation shape for `DeclineInvitations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`decline_invitations`](crate::client::Client::decline_invitations).
///
/// See [`crate::client::fluent_builders::DeclineInvitations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeclineInvitations {
    _private: (),
}
impl DeclineInvitations {
    /// Creates a new builder-style object to manufacture [`DeclineInvitationsInput`](crate::input::DeclineInvitationsInput)
    pub fn builder() -> crate::input::decline_invitations_input::Builder {
        crate::input::decline_invitations_input::Builder::default()
    }
    /// Creates a new `DeclineInvitations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeclineInvitations {
    type Output = std::result::Result<
        crate::output::DeclineInvitationsOutput,
        crate::error::DeclineInvitationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_decline_invitations_error(response)
        } else {
            crate::operation_deser::parse_decline_invitations_response(response)
        }
    }
}

/// Operation shape for `DeleteDetector`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_detector`](crate::client::Client::delete_detector).
///
/// See [`crate::client::fluent_builders::DeleteDetector`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDetector {
    _private: (),
}
impl DeleteDetector {
    /// Creates a new builder-style object to manufacture [`DeleteDetectorInput`](crate::input::DeleteDetectorInput)
    pub fn builder() -> crate::input::delete_detector_input::Builder {
        crate::input::delete_detector_input::Builder::default()
    }
    /// Creates a new `DeleteDetector` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDetector {
    type Output =
        std::result::Result<crate::output::DeleteDetectorOutput, crate::error::DeleteDetectorError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_detector_error(response)
        } else {
            crate::operation_deser::parse_delete_detector_response(response)
        }
    }
}

/// Operation shape for `DeleteFilter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_filter`](crate::client::Client::delete_filter).
///
/// See [`crate::client::fluent_builders::DeleteFilter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFilter {
    _private: (),
}
impl DeleteFilter {
    /// Creates a new builder-style object to manufacture [`DeleteFilterInput`](crate::input::DeleteFilterInput)
    pub fn builder() -> crate::input::delete_filter_input::Builder {
        crate::input::delete_filter_input::Builder::default()
    }
    /// Creates a new `DeleteFilter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFilter {
    type Output =
        std::result::Result<crate::output::DeleteFilterOutput, crate::error::DeleteFilterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_filter_error(response)
        } else {
            crate::operation_deser::parse_delete_filter_response(response)
        }
    }
}

/// Operation shape for `DeleteInvitations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_invitations`](crate::client::Client::delete_invitations).
///
/// See [`crate::client::fluent_builders::DeleteInvitations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteInvitations {
    _private: (),
}
impl DeleteInvitations {
    /// Creates a new builder-style object to manufacture [`DeleteInvitationsInput`](crate::input::DeleteInvitationsInput)
    pub fn builder() -> crate::input::delete_invitations_input::Builder {
        crate::input::delete_invitations_input::Builder::default()
    }
    /// Creates a new `DeleteInvitations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteInvitations {
    type Output = std::result::Result<
        crate::output::DeleteInvitationsOutput,
        crate::error::DeleteInvitationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_invitations_error(response)
        } else {
            crate::operation_deser::parse_delete_invitations_response(response)
        }
    }
}

/// Operation shape for `DeleteIPSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_ip_set`](crate::client::Client::delete_ip_set).
///
/// See [`crate::client::fluent_builders::DeleteIPSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteIPSet {
    _private: (),
}
impl DeleteIPSet {
    /// Creates a new builder-style object to manufacture [`DeleteIpSetInput`](crate::input::DeleteIpSetInput)
    pub fn builder() -> crate::input::delete_ip_set_input::Builder {
        crate::input::delete_ip_set_input::Builder::default()
    }
    /// Creates a new `DeleteIPSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteIPSet {
    type Output =
        std::result::Result<crate::output::DeleteIpSetOutput, crate::error::DeleteIPSetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_ip_set_error(response)
        } else {
            crate::operation_deser::parse_delete_ip_set_response(response)
        }
    }
}

/// Operation shape for `DeleteMembers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_members`](crate::client::Client::delete_members).
///
/// See [`crate::client::fluent_builders::DeleteMembers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteMembers {
    _private: (),
}
impl DeleteMembers {
    /// Creates a new builder-style object to manufacture [`DeleteMembersInput`](crate::input::DeleteMembersInput)
    pub fn builder() -> crate::input::delete_members_input::Builder {
        crate::input::delete_members_input::Builder::default()
    }
    /// Creates a new `DeleteMembers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteMembers {
    type Output =
        std::result::Result<crate::output::DeleteMembersOutput, crate::error::DeleteMembersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_members_error(response)
        } else {
            crate::operation_deser::parse_delete_members_response(response)
        }
    }
}

/// Operation shape for `DeletePublishingDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_publishing_destination`](crate::client::Client::delete_publishing_destination).
///
/// See [`crate::client::fluent_builders::DeletePublishingDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePublishingDestination {
    _private: (),
}
impl DeletePublishingDestination {
    /// Creates a new builder-style object to manufacture [`DeletePublishingDestinationInput`](crate::input::DeletePublishingDestinationInput)
    pub fn builder() -> crate::input::delete_publishing_destination_input::Builder {
        crate::input::delete_publishing_destination_input::Builder::default()
    }
    /// Creates a new `DeletePublishingDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePublishingDestination {
    type Output = std::result::Result<
        crate::output::DeletePublishingDestinationOutput,
        crate::error::DeletePublishingDestinationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_publishing_destination_error(response)
        } else {
            crate::operation_deser::parse_delete_publishing_destination_response(response)
        }
    }
}

/// Operation shape for `DeleteThreatIntelSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_threat_intel_set`](crate::client::Client::delete_threat_intel_set).
///
/// See [`crate::client::fluent_builders::DeleteThreatIntelSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteThreatIntelSet {
    _private: (),
}
impl DeleteThreatIntelSet {
    /// Creates a new builder-style object to manufacture [`DeleteThreatIntelSetInput`](crate::input::DeleteThreatIntelSetInput)
    pub fn builder() -> crate::input::delete_threat_intel_set_input::Builder {
        crate::input::delete_threat_intel_set_input::Builder::default()
    }
    /// Creates a new `DeleteThreatIntelSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteThreatIntelSet {
    type Output = std::result::Result<
        crate::output::DeleteThreatIntelSetOutput,
        crate::error::DeleteThreatIntelSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_threat_intel_set_error(response)
        } else {
            crate::operation_deser::parse_delete_threat_intel_set_response(response)
        }
    }
}

/// Operation shape for `DescribeOrganizationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_organization_configuration`](crate::client::Client::describe_organization_configuration).
///
/// See [`crate::client::fluent_builders::DescribeOrganizationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeOrganizationConfiguration {
    _private: (),
}
impl DescribeOrganizationConfiguration {
    /// Creates a new builder-style object to manufacture [`DescribeOrganizationConfigurationInput`](crate::input::DescribeOrganizationConfigurationInput)
    pub fn builder() -> crate::input::describe_organization_configuration_input::Builder {
        crate::input::describe_organization_configuration_input::Builder::default()
    }
    /// Creates a new `DescribeOrganizationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeOrganizationConfiguration {
    type Output = std::result::Result<
        crate::output::DescribeOrganizationConfigurationOutput,
        crate::error::DescribeOrganizationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_organization_configuration_error(response)
        } else {
            crate::operation_deser::parse_describe_organization_configuration_response(response)
        }
    }
}

/// Operation shape for `DescribePublishingDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_publishing_destination`](crate::client::Client::describe_publishing_destination).
///
/// See [`crate::client::fluent_builders::DescribePublishingDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePublishingDestination {
    _private: (),
}
impl DescribePublishingDestination {
    /// Creates a new builder-style object to manufacture [`DescribePublishingDestinationInput`](crate::input::DescribePublishingDestinationInput)
    pub fn builder() -> crate::input::describe_publishing_destination_input::Builder {
        crate::input::describe_publishing_destination_input::Builder::default()
    }
    /// Creates a new `DescribePublishingDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePublishingDestination {
    type Output = std::result::Result<
        crate::output::DescribePublishingDestinationOutput,
        crate::error::DescribePublishingDestinationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_publishing_destination_error(response)
        } else {
            crate::operation_deser::parse_describe_publishing_destination_response(response)
        }
    }
}

/// Operation shape for `DisableOrganizationAdminAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_organization_admin_account`](crate::client::Client::disable_organization_admin_account).
///
/// See [`crate::client::fluent_builders::DisableOrganizationAdminAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableOrganizationAdminAccount {
    _private: (),
}
impl DisableOrganizationAdminAccount {
    /// Creates a new builder-style object to manufacture [`DisableOrganizationAdminAccountInput`](crate::input::DisableOrganizationAdminAccountInput)
    pub fn builder() -> crate::input::disable_organization_admin_account_input::Builder {
        crate::input::disable_organization_admin_account_input::Builder::default()
    }
    /// Creates a new `DisableOrganizationAdminAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableOrganizationAdminAccount {
    type Output = std::result::Result<
        crate::output::DisableOrganizationAdminAccountOutput,
        crate::error::DisableOrganizationAdminAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_organization_admin_account_error(response)
        } else {
            crate::operation_deser::parse_disable_organization_admin_account_response(response)
        }
    }
}

/// Operation shape for `DisassociateFromMasterAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_from_master_account`](crate::client::Client::disassociate_from_master_account).
///
/// See [`crate::client::fluent_builders::DisassociateFromMasterAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateFromMasterAccount {
    _private: (),
}
impl DisassociateFromMasterAccount {
    /// Creates a new builder-style object to manufacture [`DisassociateFromMasterAccountInput`](crate::input::DisassociateFromMasterAccountInput)
    pub fn builder() -> crate::input::disassociate_from_master_account_input::Builder {
        crate::input::disassociate_from_master_account_input::Builder::default()
    }
    /// Creates a new `DisassociateFromMasterAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateFromMasterAccount {
    type Output = std::result::Result<
        crate::output::DisassociateFromMasterAccountOutput,
        crate::error::DisassociateFromMasterAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_from_master_account_error(response)
        } else {
            crate::operation_deser::parse_disassociate_from_master_account_response(response)
        }
    }
}

/// Operation shape for `DisassociateMembers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_members`](crate::client::Client::disassociate_members).
///
/// See [`crate::client::fluent_builders::DisassociateMembers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateMembers {
    _private: (),
}
impl DisassociateMembers {
    /// Creates a new builder-style object to manufacture [`DisassociateMembersInput`](crate::input::DisassociateMembersInput)
    pub fn builder() -> crate::input::disassociate_members_input::Builder {
        crate::input::disassociate_members_input::Builder::default()
    }
    /// Creates a new `DisassociateMembers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateMembers {
    type Output = std::result::Result<
        crate::output::DisassociateMembersOutput,
        crate::error::DisassociateMembersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_members_error(response)
        } else {
            crate::operation_deser::parse_disassociate_members_response(response)
        }
    }
}

/// Operation shape for `EnableOrganizationAdminAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_organization_admin_account`](crate::client::Client::enable_organization_admin_account).
///
/// See [`crate::client::fluent_builders::EnableOrganizationAdminAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableOrganizationAdminAccount {
    _private: (),
}
impl EnableOrganizationAdminAccount {
    /// Creates a new builder-style object to manufacture [`EnableOrganizationAdminAccountInput`](crate::input::EnableOrganizationAdminAccountInput)
    pub fn builder() -> crate::input::enable_organization_admin_account_input::Builder {
        crate::input::enable_organization_admin_account_input::Builder::default()
    }
    /// Creates a new `EnableOrganizationAdminAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableOrganizationAdminAccount {
    type Output = std::result::Result<
        crate::output::EnableOrganizationAdminAccountOutput,
        crate::error::EnableOrganizationAdminAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_organization_admin_account_error(response)
        } else {
            crate::operation_deser::parse_enable_organization_admin_account_response(response)
        }
    }
}

/// Operation shape for `GetDetector`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_detector`](crate::client::Client::get_detector).
///
/// See [`crate::client::fluent_builders::GetDetector`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDetector {
    _private: (),
}
impl GetDetector {
    /// Creates a new builder-style object to manufacture [`GetDetectorInput`](crate::input::GetDetectorInput)
    pub fn builder() -> crate::input::get_detector_input::Builder {
        crate::input::get_detector_input::Builder::default()
    }
    /// Creates a new `GetDetector` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDetector {
    type Output =
        std::result::Result<crate::output::GetDetectorOutput, crate::error::GetDetectorError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_detector_error(response)
        } else {
            crate::operation_deser::parse_get_detector_response(response)
        }
    }
}

/// Operation shape for `GetFilter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_filter`](crate::client::Client::get_filter).
///
/// See [`crate::client::fluent_builders::GetFilter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFilter {
    _private: (),
}
impl GetFilter {
    /// Creates a new builder-style object to manufacture [`GetFilterInput`](crate::input::GetFilterInput)
    pub fn builder() -> crate::input::get_filter_input::Builder {
        crate::input::get_filter_input::Builder::default()
    }
    /// Creates a new `GetFilter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFilter {
    type Output = std::result::Result<crate::output::GetFilterOutput, crate::error::GetFilterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_filter_error(response)
        } else {
            crate::operation_deser::parse_get_filter_response(response)
        }
    }
}

/// Operation shape for `GetFindings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_findings`](crate::client::Client::get_findings).
///
/// See [`crate::client::fluent_builders::GetFindings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFindings {
    _private: (),
}
impl GetFindings {
    /// Creates a new builder-style object to manufacture [`GetFindingsInput`](crate::input::GetFindingsInput)
    pub fn builder() -> crate::input::get_findings_input::Builder {
        crate::input::get_findings_input::Builder::default()
    }
    /// Creates a new `GetFindings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFindings {
    type Output =
        std::result::Result<crate::output::GetFindingsOutput, crate::error::GetFindingsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_findings_error(response)
        } else {
            crate::operation_deser::parse_get_findings_response(response)
        }
    }
}

/// Operation shape for `GetFindingsStatistics`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_findings_statistics`](crate::client::Client::get_findings_statistics).
///
/// See [`crate::client::fluent_builders::GetFindingsStatistics`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFindingsStatistics {
    _private: (),
}
impl GetFindingsStatistics {
    /// Creates a new builder-style object to manufacture [`GetFindingsStatisticsInput`](crate::input::GetFindingsStatisticsInput)
    pub fn builder() -> crate::input::get_findings_statistics_input::Builder {
        crate::input::get_findings_statistics_input::Builder::default()
    }
    /// Creates a new `GetFindingsStatistics` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFindingsStatistics {
    type Output = std::result::Result<
        crate::output::GetFindingsStatisticsOutput,
        crate::error::GetFindingsStatisticsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_findings_statistics_error(response)
        } else {
            crate::operation_deser::parse_get_findings_statistics_response(response)
        }
    }
}

/// Operation shape for `GetInvitationsCount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_invitations_count`](crate::client::Client::get_invitations_count).
///
/// See [`crate::client::fluent_builders::GetInvitationsCount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetInvitationsCount {
    _private: (),
}
impl GetInvitationsCount {
    /// Creates a new builder-style object to manufacture [`GetInvitationsCountInput`](crate::input::GetInvitationsCountInput)
    pub fn builder() -> crate::input::get_invitations_count_input::Builder {
        crate::input::get_invitations_count_input::Builder::default()
    }
    /// Creates a new `GetInvitationsCount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetInvitationsCount {
    type Output = std::result::Result<
        crate::output::GetInvitationsCountOutput,
        crate::error::GetInvitationsCountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_invitations_count_error(response)
        } else {
            crate::operation_deser::parse_get_invitations_count_response(response)
        }
    }
}

/// Operation shape for `GetIPSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_ip_set`](crate::client::Client::get_ip_set).
///
/// See [`crate::client::fluent_builders::GetIPSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetIPSet {
    _private: (),
}
impl GetIPSet {
    /// Creates a new builder-style object to manufacture [`GetIpSetInput`](crate::input::GetIpSetInput)
    pub fn builder() -> crate::input::get_ip_set_input::Builder {
        crate::input::get_ip_set_input::Builder::default()
    }
    /// Creates a new `GetIPSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetIPSet {
    type Output = std::result::Result<crate::output::GetIpSetOutput, crate::error::GetIPSetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_ip_set_error(response)
        } else {
            crate::operation_deser::parse_get_ip_set_response(response)
        }
    }
}

/// Operation shape for `GetMasterAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_master_account`](crate::client::Client::get_master_account).
///
/// See [`crate::client::fluent_builders::GetMasterAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMasterAccount {
    _private: (),
}
impl GetMasterAccount {
    /// Creates a new builder-style object to manufacture [`GetMasterAccountInput`](crate::input::GetMasterAccountInput)
    pub fn builder() -> crate::input::get_master_account_input::Builder {
        crate::input::get_master_account_input::Builder::default()
    }
    /// Creates a new `GetMasterAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMasterAccount {
    type Output = std::result::Result<
        crate::output::GetMasterAccountOutput,
        crate::error::GetMasterAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_master_account_error(response)
        } else {
            crate::operation_deser::parse_get_master_account_response(response)
        }
    }
}

/// Operation shape for `GetMemberDetectors`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_member_detectors`](crate::client::Client::get_member_detectors).
///
/// See [`crate::client::fluent_builders::GetMemberDetectors`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMemberDetectors {
    _private: (),
}
impl GetMemberDetectors {
    /// Creates a new builder-style object to manufacture [`GetMemberDetectorsInput`](crate::input::GetMemberDetectorsInput)
    pub fn builder() -> crate::input::get_member_detectors_input::Builder {
        crate::input::get_member_detectors_input::Builder::default()
    }
    /// Creates a new `GetMemberDetectors` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMemberDetectors {
    type Output = std::result::Result<
        crate::output::GetMemberDetectorsOutput,
        crate::error::GetMemberDetectorsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_member_detectors_error(response)
        } else {
            crate::operation_deser::parse_get_member_detectors_response(response)
        }
    }
}

/// Operation shape for `GetMembers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_members`](crate::client::Client::get_members).
///
/// See [`crate::client::fluent_builders::GetMembers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMembers {
    _private: (),
}
impl GetMembers {
    /// Creates a new builder-style object to manufacture [`GetMembersInput`](crate::input::GetMembersInput)
    pub fn builder() -> crate::input::get_members_input::Builder {
        crate::input::get_members_input::Builder::default()
    }
    /// Creates a new `GetMembers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMembers {
    type Output =
        std::result::Result<crate::output::GetMembersOutput, crate::error::GetMembersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_members_error(response)
        } else {
            crate::operation_deser::parse_get_members_response(response)
        }
    }
}

/// Operation shape for `GetThreatIntelSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_threat_intel_set`](crate::client::Client::get_threat_intel_set).
///
/// See [`crate::client::fluent_builders::GetThreatIntelSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetThreatIntelSet {
    _private: (),
}
impl GetThreatIntelSet {
    /// Creates a new builder-style object to manufacture [`GetThreatIntelSetInput`](crate::input::GetThreatIntelSetInput)
    pub fn builder() -> crate::input::get_threat_intel_set_input::Builder {
        crate::input::get_threat_intel_set_input::Builder::default()
    }
    /// Creates a new `GetThreatIntelSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetThreatIntelSet {
    type Output = std::result::Result<
        crate::output::GetThreatIntelSetOutput,
        crate::error::GetThreatIntelSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_threat_intel_set_error(response)
        } else {
            crate::operation_deser::parse_get_threat_intel_set_response(response)
        }
    }
}

/// Operation shape for `GetUsageStatistics`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_usage_statistics`](crate::client::Client::get_usage_statistics).
///
/// See [`crate::client::fluent_builders::GetUsageStatistics`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetUsageStatistics {
    _private: (),
}
impl GetUsageStatistics {
    /// Creates a new builder-style object to manufacture [`GetUsageStatisticsInput`](crate::input::GetUsageStatisticsInput)
    pub fn builder() -> crate::input::get_usage_statistics_input::Builder {
        crate::input::get_usage_statistics_input::Builder::default()
    }
    /// Creates a new `GetUsageStatistics` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetUsageStatistics {
    type Output = std::result::Result<
        crate::output::GetUsageStatisticsOutput,
        crate::error::GetUsageStatisticsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_usage_statistics_error(response)
        } else {
            crate::operation_deser::parse_get_usage_statistics_response(response)
        }
    }
}

/// Operation shape for `InviteMembers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`invite_members`](crate::client::Client::invite_members).
///
/// See [`crate::client::fluent_builders::InviteMembers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct InviteMembers {
    _private: (),
}
impl InviteMembers {
    /// Creates a new builder-style object to manufacture [`InviteMembersInput`](crate::input::InviteMembersInput)
    pub fn builder() -> crate::input::invite_members_input::Builder {
        crate::input::invite_members_input::Builder::default()
    }
    /// Creates a new `InviteMembers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for InviteMembers {
    type Output =
        std::result::Result<crate::output::InviteMembersOutput, crate::error::InviteMembersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_invite_members_error(response)
        } else {
            crate::operation_deser::parse_invite_members_response(response)
        }
    }
}

/// Operation shape for `ListDetectors`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_detectors`](crate::client::Client::list_detectors).
///
/// See [`crate::client::fluent_builders::ListDetectors`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDetectors {
    _private: (),
}
impl ListDetectors {
    /// Creates a new builder-style object to manufacture [`ListDetectorsInput`](crate::input::ListDetectorsInput)
    pub fn builder() -> crate::input::list_detectors_input::Builder {
        crate::input::list_detectors_input::Builder::default()
    }
    /// Creates a new `ListDetectors` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDetectors {
    type Output =
        std::result::Result<crate::output::ListDetectorsOutput, crate::error::ListDetectorsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_detectors_error(response)
        } else {
            crate::operation_deser::parse_list_detectors_response(response)
        }
    }
}

/// Operation shape for `ListFilters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_filters`](crate::client::Client::list_filters).
///
/// See [`crate::client::fluent_builders::ListFilters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFilters {
    _private: (),
}
impl ListFilters {
    /// Creates a new builder-style object to manufacture [`ListFiltersInput`](crate::input::ListFiltersInput)
    pub fn builder() -> crate::input::list_filters_input::Builder {
        crate::input::list_filters_input::Builder::default()
    }
    /// Creates a new `ListFilters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFilters {
    type Output =
        std::result::Result<crate::output::ListFiltersOutput, crate::error::ListFiltersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_filters_error(response)
        } else {
            crate::operation_deser::parse_list_filters_response(response)
        }
    }
}

/// Operation shape for `ListFindings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_findings`](crate::client::Client::list_findings).
///
/// See [`crate::client::fluent_builders::ListFindings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFindings {
    _private: (),
}
impl ListFindings {
    /// Creates a new builder-style object to manufacture [`ListFindingsInput`](crate::input::ListFindingsInput)
    pub fn builder() -> crate::input::list_findings_input::Builder {
        crate::input::list_findings_input::Builder::default()
    }
    /// Creates a new `ListFindings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFindings {
    type Output =
        std::result::Result<crate::output::ListFindingsOutput, crate::error::ListFindingsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_findings_error(response)
        } else {
            crate::operation_deser::parse_list_findings_response(response)
        }
    }
}

/// Operation shape for `ListInvitations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_invitations`](crate::client::Client::list_invitations).
///
/// See [`crate::client::fluent_builders::ListInvitations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListInvitations {
    _private: (),
}
impl ListInvitations {
    /// Creates a new builder-style object to manufacture [`ListInvitationsInput`](crate::input::ListInvitationsInput)
    pub fn builder() -> crate::input::list_invitations_input::Builder {
        crate::input::list_invitations_input::Builder::default()
    }
    /// Creates a new `ListInvitations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListInvitations {
    type Output = std::result::Result<
        crate::output::ListInvitationsOutput,
        crate::error::ListInvitationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_invitations_error(response)
        } else {
            crate::operation_deser::parse_list_invitations_response(response)
        }
    }
}

/// Operation shape for `ListIPSets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_ip_sets`](crate::client::Client::list_ip_sets).
///
/// See [`crate::client::fluent_builders::ListIPSets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListIPSets {
    _private: (),
}
impl ListIPSets {
    /// Creates a new builder-style object to manufacture [`ListIpSetsInput`](crate::input::ListIpSetsInput)
    pub fn builder() -> crate::input::list_ip_sets_input::Builder {
        crate::input::list_ip_sets_input::Builder::default()
    }
    /// Creates a new `ListIPSets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListIPSets {
    type Output =
        std::result::Result<crate::output::ListIpSetsOutput, crate::error::ListIPSetsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_ip_sets_error(response)
        } else {
            crate::operation_deser::parse_list_ip_sets_response(response)
        }
    }
}

/// Operation shape for `ListMembers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_members`](crate::client::Client::list_members).
///
/// See [`crate::client::fluent_builders::ListMembers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMembers {
    _private: (),
}
impl ListMembers {
    /// Creates a new builder-style object to manufacture [`ListMembersInput`](crate::input::ListMembersInput)
    pub fn builder() -> crate::input::list_members_input::Builder {
        crate::input::list_members_input::Builder::default()
    }
    /// Creates a new `ListMembers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMembers {
    type Output =
        std::result::Result<crate::output::ListMembersOutput, crate::error::ListMembersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_members_error(response)
        } else {
            crate::operation_deser::parse_list_members_response(response)
        }
    }
}

/// Operation shape for `ListOrganizationAdminAccounts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_organization_admin_accounts`](crate::client::Client::list_organization_admin_accounts).
///
/// See [`crate::client::fluent_builders::ListOrganizationAdminAccounts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListOrganizationAdminAccounts {
    _private: (),
}
impl ListOrganizationAdminAccounts {
    /// Creates a new builder-style object to manufacture [`ListOrganizationAdminAccountsInput`](crate::input::ListOrganizationAdminAccountsInput)
    pub fn builder() -> crate::input::list_organization_admin_accounts_input::Builder {
        crate::input::list_organization_admin_accounts_input::Builder::default()
    }
    /// Creates a new `ListOrganizationAdminAccounts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListOrganizationAdminAccounts {
    type Output = std::result::Result<
        crate::output::ListOrganizationAdminAccountsOutput,
        crate::error::ListOrganizationAdminAccountsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_organization_admin_accounts_error(response)
        } else {
            crate::operation_deser::parse_list_organization_admin_accounts_response(response)
        }
    }
}

/// Operation shape for `ListPublishingDestinations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_publishing_destinations`](crate::client::Client::list_publishing_destinations).
///
/// See [`crate::client::fluent_builders::ListPublishingDestinations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPublishingDestinations {
    _private: (),
}
impl ListPublishingDestinations {
    /// Creates a new builder-style object to manufacture [`ListPublishingDestinationsInput`](crate::input::ListPublishingDestinationsInput)
    pub fn builder() -> crate::input::list_publishing_destinations_input::Builder {
        crate::input::list_publishing_destinations_input::Builder::default()
    }
    /// Creates a new `ListPublishingDestinations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPublishingDestinations {
    type Output = std::result::Result<
        crate::output::ListPublishingDestinationsOutput,
        crate::error::ListPublishingDestinationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_publishing_destinations_error(response)
        } else {
            crate::operation_deser::parse_list_publishing_destinations_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListThreatIntelSets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_threat_intel_sets`](crate::client::Client::list_threat_intel_sets).
///
/// See [`crate::client::fluent_builders::ListThreatIntelSets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListThreatIntelSets {
    _private: (),
}
impl ListThreatIntelSets {
    /// Creates a new builder-style object to manufacture [`ListThreatIntelSetsInput`](crate::input::ListThreatIntelSetsInput)
    pub fn builder() -> crate::input::list_threat_intel_sets_input::Builder {
        crate::input::list_threat_intel_sets_input::Builder::default()
    }
    /// Creates a new `ListThreatIntelSets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListThreatIntelSets {
    type Output = std::result::Result<
        crate::output::ListThreatIntelSetsOutput,
        crate::error::ListThreatIntelSetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_threat_intel_sets_error(response)
        } else {
            crate::operation_deser::parse_list_threat_intel_sets_response(response)
        }
    }
}

/// Operation shape for `StartMonitoringMembers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_monitoring_members`](crate::client::Client::start_monitoring_members).
///
/// See [`crate::client::fluent_builders::StartMonitoringMembers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartMonitoringMembers {
    _private: (),
}
impl StartMonitoringMembers {
    /// Creates a new builder-style object to manufacture [`StartMonitoringMembersInput`](crate::input::StartMonitoringMembersInput)
    pub fn builder() -> crate::input::start_monitoring_members_input::Builder {
        crate::input::start_monitoring_members_input::Builder::default()
    }
    /// Creates a new `StartMonitoringMembers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartMonitoringMembers {
    type Output = std::result::Result<
        crate::output::StartMonitoringMembersOutput,
        crate::error::StartMonitoringMembersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_monitoring_members_error(response)
        } else {
            crate::operation_deser::parse_start_monitoring_members_response(response)
        }
    }
}

/// Operation shape for `StopMonitoringMembers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_monitoring_members`](crate::client::Client::stop_monitoring_members).
///
/// See [`crate::client::fluent_builders::StopMonitoringMembers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopMonitoringMembers {
    _private: (),
}
impl StopMonitoringMembers {
    /// Creates a new builder-style object to manufacture [`StopMonitoringMembersInput`](crate::input::StopMonitoringMembersInput)
    pub fn builder() -> crate::input::stop_monitoring_members_input::Builder {
        crate::input::stop_monitoring_members_input::Builder::default()
    }
    /// Creates a new `StopMonitoringMembers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopMonitoringMembers {
    type Output = std::result::Result<
        crate::output::StopMonitoringMembersOutput,
        crate::error::StopMonitoringMembersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_monitoring_members_error(response)
        } else {
            crate::operation_deser::parse_stop_monitoring_members_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UnarchiveFindings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`unarchive_findings`](crate::client::Client::unarchive_findings).
///
/// See [`crate::client::fluent_builders::UnarchiveFindings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UnarchiveFindings {
    _private: (),
}
impl UnarchiveFindings {
    /// Creates a new builder-style object to manufacture [`UnarchiveFindingsInput`](crate::input::UnarchiveFindingsInput)
    pub fn builder() -> crate::input::unarchive_findings_input::Builder {
        crate::input::unarchive_findings_input::Builder::default()
    }
    /// Creates a new `UnarchiveFindings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UnarchiveFindings {
    type Output = std::result::Result<
        crate::output::UnarchiveFindingsOutput,
        crate::error::UnarchiveFindingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_unarchive_findings_error(response)
        } else {
            crate::operation_deser::parse_unarchive_findings_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateDetector`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_detector`](crate::client::Client::update_detector).
///
/// See [`crate::client::fluent_builders::UpdateDetector`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDetector {
    _private: (),
}
impl UpdateDetector {
    /// Creates a new builder-style object to manufacture [`UpdateDetectorInput`](crate::input::UpdateDetectorInput)
    pub fn builder() -> crate::input::update_detector_input::Builder {
        crate::input::update_detector_input::Builder::default()
    }
    /// Creates a new `UpdateDetector` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDetector {
    type Output =
        std::result::Result<crate::output::UpdateDetectorOutput, crate::error::UpdateDetectorError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_detector_error(response)
        } else {
            crate::operation_deser::parse_update_detector_response(response)
        }
    }
}

/// Operation shape for `UpdateFilter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_filter`](crate::client::Client::update_filter).
///
/// See [`crate::client::fluent_builders::UpdateFilter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFilter {
    _private: (),
}
impl UpdateFilter {
    /// Creates a new builder-style object to manufacture [`UpdateFilterInput`](crate::input::UpdateFilterInput)
    pub fn builder() -> crate::input::update_filter_input::Builder {
        crate::input::update_filter_input::Builder::default()
    }
    /// Creates a new `UpdateFilter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFilter {
    type Output =
        std::result::Result<crate::output::UpdateFilterOutput, crate::error::UpdateFilterError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_filter_error(response)
        } else {
            crate::operation_deser::parse_update_filter_response(response)
        }
    }
}

/// Operation shape for `UpdateFindingsFeedback`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_findings_feedback`](crate::client::Client::update_findings_feedback).
///
/// See [`crate::client::fluent_builders::UpdateFindingsFeedback`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFindingsFeedback {
    _private: (),
}
impl UpdateFindingsFeedback {
    /// Creates a new builder-style object to manufacture [`UpdateFindingsFeedbackInput`](crate::input::UpdateFindingsFeedbackInput)
    pub fn builder() -> crate::input::update_findings_feedback_input::Builder {
        crate::input::update_findings_feedback_input::Builder::default()
    }
    /// Creates a new `UpdateFindingsFeedback` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFindingsFeedback {
    type Output = std::result::Result<
        crate::output::UpdateFindingsFeedbackOutput,
        crate::error::UpdateFindingsFeedbackError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_findings_feedback_error(response)
        } else {
            crate::operation_deser::parse_update_findings_feedback_response(response)
        }
    }
}

/// Operation shape for `UpdateIPSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_ip_set`](crate::client::Client::update_ip_set).
///
/// See [`crate::client::fluent_builders::UpdateIPSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateIPSet {
    _private: (),
}
impl UpdateIPSet {
    /// Creates a new builder-style object to manufacture [`UpdateIpSetInput`](crate::input::UpdateIpSetInput)
    pub fn builder() -> crate::input::update_ip_set_input::Builder {
        crate::input::update_ip_set_input::Builder::default()
    }
    /// Creates a new `UpdateIPSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateIPSet {
    type Output =
        std::result::Result<crate::output::UpdateIpSetOutput, crate::error::UpdateIPSetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_ip_set_error(response)
        } else {
            crate::operation_deser::parse_update_ip_set_response(response)
        }
    }
}

/// Operation shape for `UpdateMemberDetectors`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_member_detectors`](crate::client::Client::update_member_detectors).
///
/// See [`crate::client::fluent_builders::UpdateMemberDetectors`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateMemberDetectors {
    _private: (),
}
impl UpdateMemberDetectors {
    /// Creates a new builder-style object to manufacture [`UpdateMemberDetectorsInput`](crate::input::UpdateMemberDetectorsInput)
    pub fn builder() -> crate::input::update_member_detectors_input::Builder {
        crate::input::update_member_detectors_input::Builder::default()
    }
    /// Creates a new `UpdateMemberDetectors` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateMemberDetectors {
    type Output = std::result::Result<
        crate::output::UpdateMemberDetectorsOutput,
        crate::error::UpdateMemberDetectorsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_member_detectors_error(response)
        } else {
            crate::operation_deser::parse_update_member_detectors_response(response)
        }
    }
}

/// Operation shape for `UpdateOrganizationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_organization_configuration`](crate::client::Client::update_organization_configuration).
///
/// See [`crate::client::fluent_builders::UpdateOrganizationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateOrganizationConfiguration {
    _private: (),
}
impl UpdateOrganizationConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateOrganizationConfigurationInput`](crate::input::UpdateOrganizationConfigurationInput)
    pub fn builder() -> crate::input::update_organization_configuration_input::Builder {
        crate::input::update_organization_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateOrganizationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateOrganizationConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateOrganizationConfigurationOutput,
        crate::error::UpdateOrganizationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_organization_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_organization_configuration_response(response)
        }
    }
}

/// Operation shape for `UpdatePublishingDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_publishing_destination`](crate::client::Client::update_publishing_destination).
///
/// See [`crate::client::fluent_builders::UpdatePublishingDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePublishingDestination {
    _private: (),
}
impl UpdatePublishingDestination {
    /// Creates a new builder-style object to manufacture [`UpdatePublishingDestinationInput`](crate::input::UpdatePublishingDestinationInput)
    pub fn builder() -> crate::input::update_publishing_destination_input::Builder {
        crate::input::update_publishing_destination_input::Builder::default()
    }
    /// Creates a new `UpdatePublishingDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePublishingDestination {
    type Output = std::result::Result<
        crate::output::UpdatePublishingDestinationOutput,
        crate::error::UpdatePublishingDestinationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_publishing_destination_error(response)
        } else {
            crate::operation_deser::parse_update_publishing_destination_response(response)
        }
    }
}

/// Operation shape for `UpdateThreatIntelSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_threat_intel_set`](crate::client::Client::update_threat_intel_set).
///
/// See [`crate::client::fluent_builders::UpdateThreatIntelSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateThreatIntelSet {
    _private: (),
}
impl UpdateThreatIntelSet {
    /// Creates a new builder-style object to manufacture [`UpdateThreatIntelSetInput`](crate::input::UpdateThreatIntelSetInput)
    pub fn builder() -> crate::input::update_threat_intel_set_input::Builder {
        crate::input::update_threat_intel_set_input::Builder::default()
    }
    /// Creates a new `UpdateThreatIntelSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateThreatIntelSet {
    type Output = std::result::Result<
        crate::output::UpdateThreatIntelSetOutput,
        crate::error::UpdateThreatIntelSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_threat_intel_set_error(response)
        } else {
            crate::operation_deser::parse_update_threat_intel_set_response(response)
        }
    }
}
